/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","./ResponsivePopover","./Button","./Toolbar","./ToolbarSpacer","./Bar","./List","./StandardListItem","./ListType","./library","sap/ui/core/Control","./PlacementType","sap/ui/core/IconPool","sap/ui/core/HTML","./Text","sap/ui/core/Icon","./SegmentedButton","./Page","./NavContainer","./semantic/SemanticPage","./Link","./Popover","./MessagePopoverItem","./MessageView"],function(q,R,B,T,a,b,L,S,c,l,C,P,I,H,d,e,f,g,N,h,i,j,M,k){"use strict";var m=C.extend("sap.m.MessagePopover",{metadata:{library:"sap.m",properties:{asyncDescriptionHandler:{type:"any",group:"Behavior",defaultValue:null},asyncURLHandler:{type:"any",group:"Behavior",defaultValue:null},placement:{type:"sap.m.VerticalPlacementType",group:"Behavior",defaultValue:"Vertical"},initiallyExpanded:{type:"boolean",group:"Behavior",defaultValue:true}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.MessageItem",altTypes:["sap.m.MessagePopoverItem"],multiple:true,singularName:"item"},headerButton:{type:"sap.m.Button",multiple:false}},events:{afterOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},afterClose:{parameters:{openBy:{type:"sap.ui.core.Control"}}},beforeOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},beforeClose:{parameters:{openBy:{type:"sap.ui.core.Control"}}},itemSelect:{parameters:{item:{type:"sap.m.MessagePopoverItem"},messageTypeFilter:{type:"sap.ui.core.MessageType"}}},listSelect:{parameters:{messageTypeFilter:{type:"sap.ui.core.MessageType"}}},longtextLoaded:{},urlValidated:{}}}});function n(s){return s.charAt(0).toUpperCase()+s.slice(1);}var o="sapMMsgPopover",p={back:I.getIconURI("nav-back"),close:I.getIconURI("decline"),information:I.getIconURI("message-information"),warning:I.getIconURI("message-warning"),error:I.getIconURI("message-error"),success:I.getIconURI("message-success")},A=["asyncDescriptionHandler","asyncURLHandler"],D={asyncDescriptionHandler:function(r){var s=r.item.getLongtextUrl();if(s){q.ajax({type:"GET",url:s,success:function(t){r.item.setDescription(t);r.promise.resolve();},error:function(){var E="A request has failed for long text data. URL: "+s;q.sap.log.error(E);r.promise.reject(E);}});}}};m.setDefaultHandlers=function(r){A.forEach(function(F){if(r.hasOwnProperty(F)){D[F]=r[F];}});};m.prototype.init=function(){var t=this;var r;this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._oMessageView=this._initMessageView();this._insertCloseBtn(this._oMessageView._oListHeader);this._insertCloseBtn(this._oMessageView._oDetailsHeader);this._oMessageView._oSegmentedButton.attachEvent("select",this._onSegButtonSelect,this);this._oPopover=new R(this.getId()+"-messagePopover",{showHeader:false,contentWidth:"440px",placement:this.getPlacement(),showCloseButton:false,verticalScrolling:false,horizontalScrolling:false,modal:false,afterOpen:function(E){t.fireAfterOpen({openBy:E.getParameter("openBy")});},afterClose:function(E){t._oMessageView._navContainer.backToTop();t.fireAfterClose({openBy:E.getParameter("openBy")});},beforeOpen:function(E){t.fireBeforeOpen({openBy:E.getParameter("openBy")});},beforeClose:function(E){t.fireBeforeClose({openBy:E.getParameter("openBy")});}}).addStyleClass(o);this._oPopover.addContent(this._oMessageView);this._oPopover.addAssociation("ariaLabelledBy",this.getId()+"-messageView-HeadingDescr",true);r=this._oPopover.getAggregation("_popup");r.oPopup.setAutoClose(false);r.addEventDelegate({onBeforeRendering:this.onBeforeRenderingPopover,onAfterRendering:this.onAfterRenderingPopover},this);if(sap.ui.Device.system.phone){this._oPopover.setBeginButton(new B({text:this._oResourceBundle.getText("MESSAGEPOPOVER_CLOSE"),press:this.close.bind(this)}));}A.forEach(function(F){if(D.hasOwnProperty(F)){this['set'+n(F)](D[F]);}},this);};m.prototype.onBeforeRenderingPopover=function(){if(this._bItemsChanged){var r=this.getItems();var t=this;this._oMessageView.destroyItems();r.forEach(function(s){s._updateProperties(function(){t._bItemsChanged=true;});this._oMessageView.addItem(s.clone("","",{cloneChildren:true,cloneBinding:true}));},this);this._bItemsChanged=false;}this._setInitialFocus();};m.prototype.onAfterRenderingPopover=function(){if(this._oPopover._oControl._sFocusControlId){this._oPopover._oControl._sFocusControlId=null;}};m.prototype.exit=function(){this._oResourceBundle=null;if(this._oMessageView){this._oMessageView.destroy();this._oMessageView=null;}if(this._oPopover){this._oPopover.destroy();this._oPopover=null;}};m.prototype.openBy=function(r){var s=this._oPopover.getAggregation("_popup"),t=r.getParent();if(s instanceof j){if((t instanceof T||t instanceof b||t instanceof h)){s.setShowArrow(false);s.setResizable(true);}else{s.setShowArrow(true);}}if(this._oPopover){this._restoreExpansionDefaults();this._oPopover.openBy(r);}return this;};m.prototype.close=function(){if(this._oPopover){this._oPopover.close();}return this;};m.prototype.isOpen=function(){return this._oPopover.isOpen();};m.prototype.toggle=function(r){if(this.isOpen()){this.close();}else{this.openBy(r);}return this;};m.prototype.setPlacement=function(s){this.setProperty("placement",s,true);this._oPopover.setPlacement(s);return this;};m.prototype.getDomRef=function(s){return this._oPopover&&this._oPopover.getAggregation("_popup").getDomRef(s);};m.prototype._initMessageView=function(){var t=this,r;r=new k(this.getId()+"-messageView",{listSelect:function(E){t.fireListSelect({messageTypeFilter:E.getParameter('messageTypeFilter')});},itemSelect:function(E){t.fireItemSelect({messageTypeFilter:E.getParameter('messageTypeFilter'),item:E.getParameter('item')});},longtextLoaded:function(){t.fireLongtextLoaded();},urlValidated:function(){t.fireUrlValidated();}});return r;};m.prototype._onSegButtonSelect=function(){if(this.isOpen()&&!this.getInitiallyExpanded()&&this._oPopover.hasStyleClass(o+"-init")){this._expandMsgPopover();}};m.prototype._restoreExpansionDefaults=function(){if(!this.getInitiallyExpanded()){this._collapseMsgPopover();this._oMessageView._oSegmentedButton.setSelectedButton("none");}else{this._expandMsgPopover();}};m.prototype._expandMsgPopover=function(){var s,r=this._oPopover.getContentWidth();if(this.getInitiallyExpanded()){s=this._oPopover.$("cont").css("height");r=parseFloat(s)?s:r;}this._oPopover.setContentHeight(r).removeStyleClass(o+"-init");};m.prototype._collapseMsgPopover=function(){this._oPopover.addStyleClass(o+"-init").setContentHeight("auto");};m.prototype._insertCloseBtn=function(r){var s=this._oResourceBundle.getText("MESSAGEPOPOVER_CLOSE"),t=new B({icon:p["close"],visible:!sap.ui.Device.system.phone,tooltip:s,press:this.close.bind(this)}).addStyleClass(o+"CloseBtn");r.insertContent(t,3,true);};m.prototype._setInitialFocus=function(){if(this._oMessageView._isListPage()&&this.getInitiallyExpanded()){this._oPopover.setInitialFocus(this._oMessageView._oLists[this._sCurrentList||'all']);}};m.prototype._afterNavigate=function(){q.sap.delayedCall(0,this,"_restoreFocus");};m.prototype._restoreFocus=function(){if(this._oMessageView._isListPage()){var r=this._oRestoreFocus&&this._oRestoreFocus.control(0);r&&r.focus();}else{this._oMessageView._oBackButton.focus();}};m.prototype.setAsyncDescriptionHandler=function(r){this.setProperty('asyncDescriptionHandler',r,true);this._oMessageView.setProperty('asyncDescriptionHandler',r,true);return this;};m.prototype.setAsyncURLHandler=function(r){this.setProperty('asyncURLHandler',r,true);this._oMessageView.setProperty('asyncURLHandler',r,true);return this;};m.prototype.setHeaderButton=function(r){this._oMessageView.setHeaderButton(r);return this;};m.prototype.getHeaderButton=function(){return this._oMessageView.getHeaderButton();};["invalidate","addStyleClass","removeStyleClass","toggleStyleClass","hasStyleClass","getBusyIndicatorDelay","setBusyIndicatorDelay","getVisible","setVisible","getBusy","setBusy"].forEach(function(s){m.prototype[s]=function(){if(this._oPopover&&this._oPopover[s]){var r=this._oPopover;var t=r[s].apply(r,arguments);return t===r?this:t;}};});["setModel","bindAggregation","setAggregation","insertAggregation","addAggregation","removeAggregation","removeAllAggregation","destroyAggregation"].forEach(function(F){m.prototype["_"+F+"Old"]=m.prototype[F];m.prototype[F]=function(){var r=m.prototype["_"+F+"Old"].apply(this,arguments);this._bItemsChanged=true;if(this._oPopover){this._oPopover.invalidate();}if(["removeAggregation","removeAllAggregation"].indexOf(F)!==-1){return r;}return this;};});return m;},true);
