/*
 * ! UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./ColumnListItem','./P13nSelectionPanel','./P13nChartSelectionItem','./SearchField','./Table','./library','sap/ui/core/Control','sap/ui/model/json/JSONModel'],function(q,C,P,a,S,T,l,b,J){"use strict";var c=P.extend("sap.m.P13nChartSelectionPanel",{metadata:{library:"sap.m",properties:{chartTypeKey:{type:"string",defaultValue:""}},aggregations:{availableChartTypes:{type:"sap.ui.core.Item",multiple:true,singularName:"availableChartType"}}},renderer:function(r,o){r.write("<div");r.writeControlData(o);r.addClass("sapMP13nColumnsPanel");r.writeClasses();r.write(">");var d=o.getAggregation("content");if(d){d.forEach(function(e){r.renderControl(e);});}r.write("</div>");}});c.prototype.getOkPayload=function(){this._syncModel2Panel();return{selectionItems:this.getSelectionItems(),chartTypeKey:this.getChartTypeKey()};};c.prototype.init=function(){P.prototype.init.apply(this,arguments);var d=this._getInternalModel().getData();d.availableChartTypes=[];d.selectedChartTypeKey=null;this.setType(sap.m.P13nPanelType.dimeasure);this.setTitle(this._oRb.getText("CHARTPANEL_TITLE"));};c.prototype.getConfig=function(){return{isEnabledSelectedItemsSorting:true,isEnabledSelectedButton:true,isEnabledMoveButtons:true};};c.prototype.setChartTypeKey=function(s){var m=this._getInternalModel();this.setProperty("chartTypeKey",s);m.getData().selectedChartTypeKey=s;return this;};c.prototype.addSelectionItem=function(s){var m=this._getInternalModel();var d=m.getData();this.addAggregation("selectionItems",s);var M=this._getModelItemByColumnKey(s.getColumnKey());if(!M){return;}M.persistentIndex=s.getIndex();M.persistentSelected=s.getSelected();M.role=s.getRole();this._sortModelItemsByPersistentIndex(d.items);this._updateModelItemsTableIndex(d);this._updateCounts(d);return this;};c.prototype.insertSelectionItem=function(s,i){var m=this._getInternalModel();var d=m.getData();this.insertAggregation("selectionItems",s,i);var M=this._getModelItemByColumnKey(s.getColumnKey());if(!M){return;}M.persistentIndex=s.getIndex();M.persistentSelected=s.getSelected();M.role=s.getRole();this._sortModelItemsByPersistentIndex(d.items);this._updateModelItemsTableIndex(d);this._updateCounts(d);return this;};c.prototype.removeSelectionItem=function(s){var m=this._getInternalModel();var d=m.getData();s=this.removeAggregation("selectionItems",s);var M=this._getModelItemByColumnKey(s.getColumnKey());if(!M){return;}M.persistentIndex=-1;M.persistentSelected=undefined;M.role=undefined;this._sortModelItemsByPersistentIndex(d.items);this._updateModelItemsTableIndex(d);this._updateCounts(d);return s;};c.prototype.removeAllSelectionItems=function(){var m=this._getInternalModel();var d=m.getData();this.getSelectionItems().forEach(function(o){var M=this._getModelItemByColumnKey(o.getColumnKey());if(!M){return;}M.persistentIndex=-1;M.persistentSelected=undefined;M.role=undefined;},this);this._sortModelItemsByPersistentIndex(d.items);this._updateModelItemsTableIndex(d);this._updateCounts(d);var s=this.removeAllAggregation("selectionItems");return s;};c.prototype.destroySelectionItems=function(){var m=this._getInternalModel();var d=m.getData();this.getSelectionItems().forEach(function(s){var M=this._getModelItemByColumnKey(s.getColumnKey());if(!M){return;}M.persistentIndex=-1;M.persistentSelected=undefined;M.role=undefined;},this);this._sortModelItemsByPersistentIndex(d.items);this._updateModelItemsTableIndex(d);this._updateCounts(d);this.destroyAggregation("selectionItems");return this;};c.prototype.addAvailableChartType=function(i){var m=this._getInternalModel();this.addAggregation("availableChartTypes",i);m.getData().availableChartTypes.push({key:i.getKey(),text:i.getText()});return this;};c.prototype.insertAvailableChartType=function(i,I){var m=this._getInternalModel();this.insertAggregation("availableChartTypes",i,I);m.getData().availableChartTypes.splice(I,0,{key:i.getKey(),text:i.getText()});return this;};c.prototype.removeAvailableChartType=function(i){var I=this.indexOfAvailableChartTypes(i);if(I>-1){var m=this._getInternalModel();m.getData().availableChartTypes.splice(I,1);}i=this.removeAggregation("availableChartTypes",i);return i;};c.prototype.removeAllAvailableChartType=function(){var m=this._getInternalModel();var i=this.removeAllAggregation("availableChartTypes");m.getData().availableChartTypes=[];return i;};c.prototype.destroyAvailableChartType=function(){var m=this._getInternalModel();this.destroyAggregation("availableChartTypes");m.getData().availableChartTypes=[];return this;};c.prototype.onBeforeNavigationFrom=function(){var s=this.getChartTypeKey();var d=[];var m=[];this.getSelectionItems().forEach(function(o){var M=this._getModelItemByColumnKey(o.getColumnKey());if(!M){return;}if(M.aggregationRole==="Dimension"){d.push(o);}else if(M.aggregationRole==="Measure"){m.push(o);}},this);d=d.filter(function(i){return i.getSelected();}).map(function(i){return{name:i.getColumnKey()};});m=m.filter(function(i){return i.getSelected();}).map(function(i){return{name:i.getColumnKey()};});sap.ui.getCore().loadLibrary("sap.chart");var r;try{r=sap.chart.api.getChartTypeLayout(s,d,m);}catch(e){return false;}return r.errors.length===0;};c.prototype._syncPanel2Model=function(){var m=this._getInternalModel();var d=m.getData();this.getSelectionItems().forEach(function(s){var M=this._getModelItemByColumnKey(s.getColumnKey());if(!M||this._isSelectionItemEqualToModelItem(s,M)){return;}M.persistentIndex=s.getIndex();M.persistentSelected=s.getSelected();M.role=s.getRole();this._sortModelItemsByPersistentIndex(d.items);this._updateModelItemsTableIndex(d);this._updateCounts(d);},this);m.refresh();};c.prototype._syncModel2Panel=function(){if(!this._bOnBeforeRenderingFirstTimeExecuted){return;}var d=this._getInternalModel().getData();this.setChartTypeKey(d.selectedChartTypeKey);d.items.forEach(function(m){var s=this._getSelectionItemByColumnKey(m.columnKey);if(s){if(!this._isSelectionItemEqualToModelItem(s,m)){s.setSelected(m.persistentSelected);s.setIndex(m.persistentIndex);s.setRole(m.role);}return;}if(!m.persistentSelected){return;}s=new sap.m.P13nChartSelectionItem({columnKey:m.columnKey,selected:m.persistentSelected,index:m.persistentIndex,role:m.role});this.addAggregation("selectionItems",s,true);},this);};c.prototype._filterModelItemsBySearchText=function(){var m=this._getInternalModel();var s=this._getSearchText();s=s.replace(/(^\s+)|(\s+$)/g,'');s=s.replace(/[-\/\\^$*+?.()|[\]{}]/g,'\\$&');var r=new RegExp(s,'igm');if(!r){return;}this._getVisibleModelItems().forEach(function(M){M.visible=false;if(M.text&&M.text.match(r)){M.visible=true;}if(M.aggregationRole&&M.aggregationRole.match(r)){M.visible=true;}if(M.role&&M.role.match(r)){M.visible=true;}if(M.tooltip&&M.tooltip.match(r)){M.visible=true;}});m.refresh();};c.prototype._includeModelItem=function(i,I){var m=this._getInternalModel();var d=m.getData();if(I<0){I=d.items.length;}var t=this;var g=function(){if(i.getAggregationRole()==="Dimension"){return[{key:"category",text:t._oRb.getText('COLUMNSPANEL_CHARTROLE_CATEGORY')},{key:"series",text:t._oRb.getText('COLUMNSPANEL_CHARTROLE_SERIES')}];}if(i.getAggregationRole()==="Measure"){return[{key:"axis1",text:t._oRb.getText('COLUMNSPANEL_CHARTROLE_AXIS1')},{key:"axis2",text:t._oRb.getText('COLUMNSPANEL_CHARTROLE_AXIS2')}];}return[];};var M={columnKey:i.getColumnKey(),visible:true,text:i.getText(),tooltip:i.getTooltip(),aggregationRole:i.getAggregationRole(),availableRoleTypes:g(),persistentIndex:-1,persistentSelected:undefined,role:undefined,tableIndex:undefined};d.items.splice(I,0,M);};c.prototype._getTableColumns=function(){var t=this;return[new sap.m.Column({header:new sap.m.Text({text:{parts:[{path:'/countOfSelectedItems'},{path:'/countOfItems'}],formatter:function(i,d){return t._oRb.getText('COLUMNSPANEL_SELECT_ALL_WITH_COUNTER',[i,d]);}}})}),new sap.m.Column({header:new sap.m.Text({text:this._oRb.getText('COLUMNSPANEL_COLUMN_TYPE')})}),new sap.m.Column({header:new sap.m.Text({text:this._oRb.getText('COLUMNSPANEL_COLUMN_ROLE')})})];};c.prototype._getTableTemplate=function(){var t=this;return new sap.m.ColumnListItem({cells:[new sap.m.Text({text:"{text}"}),new sap.m.Text({text:{path:'',formatter:function(m){if(m.aggregationRole==="Dimension"){return t._oRb.getText('COLUMNSPANEL_TYPE_DIMENSION');}if(m.aggregationRole==="Measure"){return t._oRb.getText('COLUMNSPANEL_TYPE_MEASURE');}}}}),new sap.m.Select({selectedKey:"{role}",items:{path:'availableRoleTypes',factory:function(i,B){var A=B.getObject();return new sap.ui.core.Item({key:A.key,text:A.text});}},change:q.proxy(t.notifyChange,t)})],visible:"{visible}",selected:"{persistentSelected}",tooltip:"{tooltip}",type:sap.m.ListType.Active});};c.prototype._createToolbar=function(){P.prototype._createToolbar.apply(this,arguments);var m=this._getInternalModel();var i=new sap.ui.core.InvisibleText({text:this._oRb.getText('COLUMNSPANEL_CHARTTYPE')});var o=new sap.m.ComboBox({placeholder:this._oRb.getText('COLUMNSPANEL_CHARTTYPE'),selectedKey:{path:'/selectedChartTypeKey'},ariaLabelledBy:i,items:{path:'/availableChartTypes',templateShareable:false,template:new sap.ui.core.Item({key:"{key}",text:"{text}"})},layoutData:new sap.m.OverflowToolbarLayoutData({moveToOverflow:false,stayInOverflow:false})});o.setModel(m);this._getToolbar().insertContent(i,0).insertContent(o,1);};c.prototype._isSelectionItemEqualToModelItem=function(s,m){return m.persistentIndex===s.getIndex()&&m.persistentSelected===s.getSelected()&&m.role===s.getRole();};c.prototype._showAll=function(){q.sap.log.info("ModelItems: visible tableIndex isPersistent        TableItems: current");q.sap.log.info("--------------------------------------------------------------");var d=this._getInternalModel().getData();var t=this._oTable.getItems();var L=Math.max(d.items.length,this._oTable.getItems().length);for(var i=0;i<L;i++){var m=d.items[i];var o=t[i];q.sap.log.info(m.columnKey+": "+m.visible+" "+m.tableIndex+" "+m.persistentSelected+"_"+m.persistentIndex+";    "+o.getId()+" "+o.getCells()[0].getText()+": "+o.getSelected()+" "+o.getCells()[1].getText());}};return c;},true);
