/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/m/semantic/SegmentedContainer','sap/m/semantic/SemanticConfiguration','sap/m/Button','sap/m/Title','sap/m/ActionSheet','sap/m/Page','sap/m/OverflowToolbar','sap/m/OverflowToolbarButton','sap/m/OverflowToolbarLayoutData','sap/m/ToolbarSpacer','sap/m/Bar','sap/ui/core/CustomData','sap/ui/base/ManagedObject','sap/ui/core/AccessibleLandmarkRole','sap/m/PageAccessibleLandmarkInfo','sap/ui/base/ManagedObjectObserver'],function(q,S,a,B,T,A,P,O,b,c,d,e,C,M,f,g,h){"use strict";var i=sap.ui.core.Control.extend("sap.m.semantic.SemanticPage",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Misc",defaultValue:null},titleLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:sap.ui.core.TitleLevel.Auto},showNavButton:{type:"boolean",group:"Appearance",defaultValue:false},showSubHeader:{type:"boolean",group:"Appearance",defaultValue:true},enableScrolling:{type:"boolean",group:"Behavior",defaultValue:true},showFooter:{type:"boolean",group:"Appearance",defaultValue:true},floatingFooter:{type:"boolean",group:"Appearance",defaultValue:false},semanticRuleSet:{type:"sap.m.semantic.SemanticRuleSetType",group:"Misc",defaultValue:sap.m.semantic.SemanticRuleSetType.Classic}},defaultAggregation:"content",aggregations:{subHeader:{type:"sap.m.IBar",multiple:false},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},customHeaderContent:{type:"sap.m.Button",multiple:true,singularName:"customHeaderContent"},customFooterContent:{type:"sap.m.Button",multiple:true,singularName:"customFooterContent"},landmarkInfo:{type:"sap.m.PageAccessibleLandmarkInfo",multiple:false},_page:{type:"sap.m.Page",multiple:false,visibility:"hidden"}},events:{navButtonPress:{}},designTime:true}});i.prototype.init=function(){this._oHeaderObserver=new h(i.prototype._updateHeaderVisibility.bind(this));this._currentMode=a._PageMode.display;this._getPage().setCustomHeader(this._getInternalHeader());this._getPage().setFooter(new O(this.getId()+"-footer"));this._getPage().setLandmarkInfo(new g());this._getPage().setShowHeader(false);};i.prototype.exit=function(){if(this._oInternalHeader){this._oInternalHeader.destroy();this._oInternalHeader=null;}if(this._oWrappedFooter){this._oWrappedFooter.destroy();this._oWrappedFooter=null;}if(this._oTitle){this._oTitle.destroy();this._oTitle=null;}if(this._oNavButton){this._oNavButton.destroy();this._oNavButton=null;}if(this._oHeaderObserver){this._oHeaderObserver.disconnect();this._oHeaderObserver=null;}this._oPositionsMap=null;};i.prototype.setSubHeader=function(o,k){this._getPage().setSubHeader(o,k);return this;};i.prototype.getSubHeader=function(){return this._getPage().getSubHeader();};i.prototype.destroySubHeader=function(k){this._getPage().destroySubHeader(k);return this;};i.prototype.getShowSubHeader=function(){return this._getPage().getShowSubHeader();};i.prototype.setShowSubHeader=function(k,l){this._getPage().setShowSubHeader(k,l);this.setProperty("showSubHeader",k,true);return this;};i.prototype.getShowFooter=function(){return this._getPage().getShowFooter();};i.prototype.setShowFooter=function(k,l){this._getPage().setShowFooter(k,l);this.setProperty("showFooter",k,true);return this;};i.prototype.setFloatingFooter=function(F,k){this._getPage().setFloatingFooter(F,k);this.setProperty("floatingFooter",F,true);return this;};i.prototype.getContent=function(){return this._getPage().getContent();};i.prototype.addContent=function(o,k){this._getPage().addContent(o,k);return this;};i.prototype.indexOfContent=function(o){return this._getPage().indexOfContent(o);};i.prototype.insertContent=function(o,I,k){this._getPage().insertContent(o,I,k);return this;};i.prototype.removeContent=function(o,k){return this._getPage().removeContent(o,k);};i.prototype.removeAllContent=function(k){return this._getPage().removeAllContent(k);};i.prototype.destroyContent=function(k){this._getPage().destroyContent(k);return this;};i.prototype.setTitle=function(t){var o=this._getTitle();if(o){o.setText(t);if(!o.getParent()){this._getInternalHeader().addContentMiddle(o);}}this.setProperty("title",t,true);return this;};i.prototype.setTitleLevel=function(t){this.setProperty("titleLevel",t,true);this._getTitle().setLevel(t);return this;};i.prototype.setShowNavButton=function(k){var o=this._getNavButton();if(o){o.setVisible(k);if(!o.getParent()){this._getInternalHeader().addContentLeft(o);}}this.setProperty("showNavButton",k,true);return this;};i.prototype.setEnableScrolling=function(E){this._getPage().setEnableScrolling(E);this.setProperty("enableScrolling",E,true);return this;};i.prototype.setLandmarkInfo=function(l){return this._getPage().setLandmarkInfo(l);};i.prototype.getLandmarkInfo=function(){return this._getPage().getLandmarkInfo();};i.prototype.destroyLandmarkInfo=function(){return this._getPage().destroyLandmarkInfo();};i.prototype.getCustomFooterContent=function(){return this._getSegmentedFooter().getSection("customRight").getContent();};i.prototype.addCustomFooterContent=function(o,k){this._getSegmentedFooter().getSection("customRight").addContent(o,k);return this;};i.prototype.indexOfCustomFooterContent=function(o){return this._getSegmentedFooter().getSection("customRight").indexOfContent(o);};i.prototype.insertCustomFooterContent=function(o,I,k){this._getSegmentedFooter().getSection("customRight").insertContent(o,I,k);return this;};i.prototype.removeCustomFooterContent=function(o,k){return this._getSegmentedFooter().getSection("customRight").removeContent(o,k);};i.prototype.removeAllCustomFooterContent=function(k){return this._getSegmentedFooter().getSection("customRight").removeAllContent(k);};i.prototype.destroyCustomFooterContent=function(k){var l=this.getCustomFooterContent();if(!l){return this;}if(k){this.iSuppressInvalidate++;}this._getSegmentedFooter().getSection("customRight").destroy(k);if(!this.isInvalidateSuppressed()){this.invalidate();}if(k){this.iSuppressInvalidate--;}return this;};i.prototype.getCustomHeaderContent=function(){return this._getSegmentedHeader().getSection("customRight").getContent();};i.prototype.addCustomHeaderContent=function(o,k){this._getSegmentedHeader().getSection("customRight").addContent(o,k);return this;};i.prototype.indexOfCustomHeaderContent=function(o){return this._getSegmentedHeader().getSection("customRight").indexOfContent(o);};i.prototype.insertCustomHeaderContent=function(o,I,k){this._getSegmentedHeader().getSection("customRight").insertContent(o,I,k);return this;};i.prototype.removeCustomHeaderContent=function(o,k){return this._getSegmentedHeader().getSection("customRight").removeContent(o,k);};i.prototype.removeAllCustomHeaderContent=function(k){return this._getSegmentedHeader().getSection("customRight").removeAllContent(k);};i.prototype.destroyCustomHeaderContent=function(k){var l=this.getCustomHeaderContent();if(!l){return this;}if(k){this.iSuppressInvalidate++;}this._getSegmentedHeader().getSection("customRight").destroy(k);if(!this.isInvalidateSuppressed()){this.invalidate();}if(k){this.iSuppressInvalidate--;}return this;};i.prototype.setAggregation=function(k,o,l){var m=this.mAggregations[k];if(m===o){return this;}o=this.validateAggregation(k,o,false);var t=this.getMetadata().getManagedAggregation(k).type;if(a.isKnownSemanticType(t)){if(m){this._stopMonitor(m);this._removeFromInnerAggregation(m._getControl(),a.getPositionInPage(t),l);}if(o){this._initMonitor(o);this._addToInnerAggregation(o._getControl(),a.getPositionInPage(t),a.getSequenceOrderIndex(t),l);}return M.prototype.setAggregation.call(this,k,o,true);}return M.prototype.setAggregation.call(this,k,o,l);};i.prototype.destroyAggregation=function(k,l){var o=this.getMetadata().getAggregations()[k];if(o&&a.isKnownSemanticType(o.type)){var m=M.prototype.getAggregation.call(this,k);if(m){this._stopMonitor(m);if(!m._getControl().bIsDestroyed){this._removeFromInnerAggregation(m._getControl(),a.getPositionInPage(o.type),l);}}}return M.prototype.destroyAggregation.call(this,k,m,l);};i.prototype._updateHeaderVisibility=function(){var H=this._getInternalHeader();var E=(H.getContentLeft().length===0)&&(H.getContentMiddle().length===0)&&(H.getContentRight().length===0);this._getPage().setShowHeader(!E);};i.prototype._getTitle=function(){if(!this._oTitle){this._oTitle=new T(this.getId()+"-title",{text:this.getTitle()});}return this._oTitle;};i.prototype._getNavButton=function(){if(!this._oNavButton){this._oNavButton=new B(this.getId()+"-navButton",{type:sap.m.ButtonType.Up,tooltip:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("PAGE_NAVBUTTON_TEXT"),press:q.proxy(this.fireNavButtonPress,this)});}return this._oNavButton;};i.prototype._initMonitor=function(o){var k=o._getConfiguration();if(k.triggers){o.attachEvent("press",this._updateCurrentMode,this);}var l=k.states,t=this;if(l){q.each(a._PageMode,function(m,v){if(l[m]){t.attachEvent(m,o._onPageStateChanged,o);}});}};i.prototype._stopMonitor=function(o){o.detachEvent("press",this._updateCurrentMode,this);var k=o._getConfiguration();var l=k.states,t=this;if(l){q.each(a._PageMode,function(m,v){if(l[m]){t.detachEvent(m,o._onPageStateChanged,o);}});}};i.prototype._updateCurrentMode=function(E){var o=E.oSource._getConfiguration();if(typeof o.triggers==='string'){this._currentMode=o.triggers;}else{var l=o.triggers.length;if(l&&l>0){for(var I=0;I<l;I++){var t=o.triggers[I];if(t&&(t.inState===this._currentMode)){this._currentMode=t.triggers;break;}}}}this.fireEvent(this._currentMode);};i.prototype._removeFromInnerAggregation=function(o,p,k){var l=this._getSemanticPositionsMap()[p];if(l&&l.oContainer&&l.sAggregation){l.oContainer["remove"+j(l.sAggregation)](o,k);}};i.prototype._addToInnerAggregation=function(o,p,k,l){if(!o||!p){return;}var m=this._getSemanticPositionsMap()[p];if(!m||!m.oContainer||!m.sAggregation){return;}if(typeof k!=='undefined'){o.addCustomData(new C({key:"sortIndex",value:k}));}return m.oContainer["add"+j(m.sAggregation)](o,l);};i.prototype._getSemanticPositionsMap=function(o,k){if(!this._oPositionsMap){this._oPositionsMap={};this._oPositionsMap[a.prototype._PositionInPage.headerLeft]={oContainer:this._getInternalHeader(),sAggregation:"contentLeft"};this._oPositionsMap[a.prototype._PositionInPage.headerRight]={oContainer:this._getSegmentedHeader().getSection("semanticRight"),sAggregation:"content"};this._oPositionsMap[a.prototype._PositionInPage.headerMiddle]={oContainer:this._getInternalHeader(),sAggregation:"contentMiddle"};this._oPositionsMap[a.prototype._PositionInPage.footerLeft]={oContainer:this._getSegmentedFooter().getSection("semanticLeft"),sAggregation:"content"};this._oPositionsMap[a.prototype._PositionInPage.footerRight_IconOnly]={oContainer:this._getSegmentedFooter().getSection("semanticRight_IconOnly"),sAggregation:"content"};this._oPositionsMap[a.prototype._PositionInPage.footerRight_TextOnly]={oContainer:this._getSegmentedFooter().getSection("semanticRight_TextOnly"),sAggregation:"content"};}return this._oPositionsMap;};i.prototype._getPage=function(){var p=this.getAggregation("_page");if(!p){this.setAggregation("_page",new P(this.getId()+"-page"));p=this.getAggregation("_page");}return p;};i.prototype._getInternalHeader=function(){if(!this._oInternalHeader){this._oInternalHeader=new e(this.getId()+"-intHeader");if(this._oHeaderObserver){this._oHeaderObserver.observe(this._oInternalHeader,{aggregations:["contentLeft","contentMiddle","contentRight"]});}}return this._oInternalHeader;};i.prototype._getAnyHeader=function(){return this._getInternalHeader();};i.prototype._getSegmentedHeader=function(){if(!this._oWrappedHeader){var H=this._getInternalHeader();if(!H){q.sap.log.error("missing page header",this);return null;}this._oWrappedHeader=new S(H,"contentRight");this._oWrappedHeader.addSection({sTag:"customRight"});this._oWrappedHeader.addSection({sTag:"semanticRight"});}return this._oWrappedHeader;};i.prototype._getSegmentedFooter=function(){if(!this._oWrappedFooter){var F=this._getPage().getFooter();if(!F){q.sap.log.error("missing page footer",this);return null;}this._oWrappedFooter=new S(F);this._oWrappedFooter.addSection({sTag:"semanticLeft"});this._oWrappedFooter.addSection({sTag:"spacer",aContent:[new d()]});this._oWrappedFooter.addSection({sTag:"semanticRight_TextOnly",fnSortFunction:s});this._oWrappedFooter.addSection({sTag:"customRight"});this._oWrappedFooter.addSection({sTag:"semanticRight_IconOnly",fnSortFunction:s});}return this._oWrappedFooter;};function j(n){return n.substring(0,1).toUpperCase()+n.substring(1);}function s(o,k){var l=o.data("sortIndex");var m=k.data("sortIndex");if((typeof l==='undefined')||(typeof m==='undefined')){q.sap.log.warning("sortIndex missing",this);return null;}return(l-m);}return i;},false);
