/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/support/library"],function(q,S){"use strict";var C=S.Categories;var a=S.Severity;var A=S.Audiences;return{addRulesToRuleSet:function(r){r.addRule({id:"preloadAsyncCheck",audiences:[A.Control,A.Internal],categories:[C.Performance],enabled:true,minversion:"1.32",maxversion:"-",title:"Preload Configuration",description:"Checks whether the preload configuration was set correctly to async",resolution:"Add \"data-sap-ui-preload=\"async\"\" to script tag that includes \"sap-ui-core.js\"",resolutionurls:[{text:"Performance: Speed Up Your App",href:"https://sapui5.hana.ondemand.com/#docs/guide/408b40efed3c416681e1bd8cdd8910d4.html"}],check:function(i,c){if(sap.ui.getCore().getConfiguration().getPreload()!=="async"){i.addIssue({severity:a.High,details:"None",context:{id:"WEBPAGE"}});}}});r.addRule({id:"cacheBusterToken",audiences:[A.Application],categories:[C.Performance],enabled:true,minversion:"1.28",title:"Cache Buster Token",description:"Checks whether the application uses cache buster tokens in its requests for static resources from SAPUI5 repositories.",resolution:"Change the application.\n"+"Note: Not using cache buster tokens negatively impacts performance.\n"+"For more information, see the SAPUI5 developer guide.",resolutionurls:[{text:"SAPUI5 developer guide: ",href:"https://sapui5.hana.ondemand.com/#docs/guide/4cfe7eff3001447a9d4b0abeaba95166.html"}],check:function(I,c,s){var u="/sap/bc/ui5_ui5/";var b=[];var d;var R=q.sap.measure.getRequestTimings();for(var i=0;i<R.length;i++){var U=R[i].name;if(U.indexOf(u)>0){if(!U.match(/\/~[A-Z0-9]*~/g)){if(U.indexOf("/sap-ui-cachebuster/sap-ui-core.js")<0&&U.indexOf("sap-ui-cachebuster-info.json")<0){var e=U.split(u);e=e[1].split("/");d=e[0]==="sap"?e[1]:"/"+e[0]+"/"+e[1];if(b.indexOf(d)<0){b.push(d);}}}}}for(var i=0;i<b.length;i++){d=b[i];var f=u+(d.charAt(0)==="/"?d.substr(1):"sap/"+d);I.addIssue({severity:a.Medium,details:"Application '"+d+"' is lacking cache buster tokens in some or all of its requests.\n "+"For more information about the URLs affected under application '"+d+"' please check the network trace for URLs starting with '"+f+"'",context:{id:"WEBPAGE"}});}}});}};},true);
