/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/support/library","sap/ui/support/supportRules/util/StringAnalyzer","sap/ui/model/ListBinding","sap/ui/model/json/JSONModel","sap/ui/model/odata/ODataMetadata","sap/ui/model/CompositeBinding","sap/ui/model/PropertyBinding"],function(q,S,a,L,J,O,C,P){"use strict";var b=S.Categories;var c=S.Severity;var A=S.Audiences;return{addRulesToRuleSet:function(r){r.addRule({id:"unresolvedPropertyBindings",audiences:[A.Control,A.Application],categories:[b.Bindings],enabled:true,minversion:"1.32",title:"Unresolved Property Bindings",description:"Unresolved bindings might be caused by typos in their path",resolution:"Check the binding path for typos",resolutionurls:[{href:"https://sapui5.hana.ondemand.com/#docs/api/symbols/sap.ui.model.Context.html",text:"Context class"},{href:"https://sapui5.hana.ondemand.com/#docs/guide/e5310932a71f42daa41f3a6143efca9c.html",text:"Data binding"},{href:"https://sapui5.hana.ondemand.com/#docs/guide/97830de2d7314e93b5c1ee3878a17be9.html",text:"Aggregation binding with templates"},{href:"https://sapui5.hana.ondemand.com/#docs/guide/6c7c5c266b534e7ea9a28f861dc515f5.html",text:"Element binding"}],check:function(i,o,s){var e=s.getElements();for(var n in e){var E=e[n],B=E.mBindingInfos;for(var m in B){var d=B[m].binding;if(d){if(!(d instanceof C)&&d instanceof P&&d.getModel()){if(d.getValue()===undefined){i.addIssue({severity:c.Low,details:"Element "+E.getId()+" has unresolved bindings.",context:{id:E.getId()}});}}}}}}});function _(v,B){var j=-1;var s=false;v.forEach(function(k){var i=a.calculateLevenshteinDistance(B,k);if(j===-1||i<j){j=i;s=k;}});return s;}r.addRule({id:"bindingPathSyntaxValidation",audiences:[A.Control,A.Application],categories:[b.Bindings],enabled:true,minversion:"1.32",title:"Model: Unresolved binding path",description:"The binding path used in the model could not be resolved",resolution:"Check the binding path for typos",resolutionurls:[{href:"https://sapui5.hana.ondemand.com/#docs/api/symbols/sap.ui.model.Context.html",text:"API Reference: Context"},{href:"https://sapui5.hana.ondemand.com/#docs/guide/e5310932a71f42daa41f3a6143efca9c.html",text:"Documentation: Data Binding"},{href:"https://sapui5.hana.ondemand.com/#docs/guide/97830de2d7314e93b5c1ee3878a17be9.html",text:"Data Binding Tutorial - Step 12: Aggregation Binding Using Templates"},{href:"https://sapui5.hana.ondemand.com/#docs/guide/6c7c5c266b534e7ea9a28f861dc515f5.html",text:"Data Binding Tutorial - Step 13: Element Binding"}],check:function(i,o,s){var e=s.getElements();Object.keys(e).forEach(function(E){var d=e[E],B=d.mBindingInfos;Object.keys(B).forEach(function(f){var g=B[f].binding;if(g&&!(g instanceof C)&&g.getModel&&g.getModel()){var m=g.getModel();if((g.getValue&&g.getValue()===undefined)||(g instanceof L&&g.getLength()===0)){var j=false;if(m instanceof J){var h=m.getObject(g.getPath());if(!h){var D=m.getData();j=_(Object.keys(D),g.getPath());}}else if(m.oMetadata&&m.oMetadata instanceof O){var k=m.oMetadata._getEntityTypeByPath(g.getPath());if(!k){var v=[];m.oMetadata.getServiceMetadata().dataServices.schema.forEach(function(l){if(l.entityContainer){l.entityContainer.forEach(function(n){if(n.entitySet){n.entitySet.forEach(function(p){if(p.name){v.push(p.name);}});}});}});j=_(v,g.getPath());}}if(j){i.addIssue({severity:c.High,details:"Element "+d.getId()+" "+g.getPath()+" has unresolved bindings.",resolution:"You could try '"+j+"' instead",context:{id:d.getId()}});}}else if(g.getValue&&g.getValue()===g.getPath()){i.addIssue({severity:c.Low,details:"Element "+d.getId()+" "+g.getPath()+" has the same value as the path. Potential Error.",context:{id:d.getId()}});}}});});}});}};},true);
