/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/support/library"],function(q,S){"use strict";var C=S.Categories;var a=S.Severity;var A=S.Audiences;return{addRulesToRuleSet:function(r,c){c=c||{};r.addRule({id:"XMLViewWrongNamespace",audiences:[A.Application],categories:[C.Functionality],enabled:true,title:"XML View is not configured with namespace 'sap.ui.core.mvc'",description:"For consistency and proper resource loading, the root node of an XML view must be configured with the namespace 'mvc'",resolution:"Define the XML view as '<core:View ...>' and configure the XML namepspace as 'xmlns:mvc=\"sap.ui.core.mvc\"'",resolutionurls:[{text:"Documentation: Namespaces in XML Views",href:"https://sapui5.hana.ondemand.com/#docs/guide/2421a2c9fa574b2e937461b5313671f0.html"}],check:function(i,o,s){var x=s.getElements().filter(function(b){return b.getMetadata().getName()==="sap.ui.core.mvc.XMLView";});x.forEach(function(X){if(X._xContent.namespaceURI!=="sap.ui.core.mvc"){var v=X.getViewName().split("\.").pop();i.addIssue({severity:a.Medium,details:"The view '"+v+"' ("+X.getId()+") is configured with namespace '"+X._xContent.namespaceURI+"' instead of 'sap.ui.core.mvc'",context:{id:X.getId()}});}});}});r.addRule({id:"XMLViewDefaultNamespace",audiences:[A.Control,A.Application],categories:[C.Performance],enabled:true,title:"Default namespace missing in XML view",description:"If the default namespace is missing, the code is less readable and parsing performance may be slow",resolution:"Set the namespace of the control library that holds most of the controls you use as default namespace (e.g. xmlns=\"sap.m\")",resolutionurls:[{text:"Documentation: Namespaces in XML Views",href:"https://sapui5.hana.ondemand.com/#docs/guide/2421a2c9fa574b2e937461b5313671f0.html"}],check:function(i,o,s){var x=s.getElements().filter(function(b){return b.getMetadata().getName()==="sap.ui.core.mvc.XMLView";});x.forEach(function(X){if(!X._xContent.attributes.getNamedItem("xmlns")){var v=X.getViewName().split("\.").pop();i.addIssue({severity:a.Low,details:"The view '"+v+"' ("+X.getId()+") does not contain a default namespace",context:{id:X.getId()}});}});}});r.addRule({id:"XMLViewUnusedNamespaces",audiences:[A.Control,A.Application],categories:[C.Performance],enabled:true,title:"Unused namespaces in XML view",description:"Namespaces that are declared but not used have a negative impact on performance (and may confuse readers of the code)",resolution:"Remove the unused namespaces from the view definition",resolutionurls:[{text:"Documentation: Namespaces in XML Views",href:"https://sapui5.hana.ondemand.com/#docs/guide/2421a2c9fa574b2e937461b5313671f0.html"}],check:function(I,o,s){var x=s.getElements().filter(function(b){return b.getMetadata().getName()==="sap.ui.core.mvc.XMLView";});x.forEach(function(X){for(var i=0;i<X._xContent.attributes.length;i++){var n=X._xContent.attributes.item(i).name;var l=X._xContent.attributes.item(i).localName;var f=X._xContent.attributes.item(i).value;if(n.match("xmlns:")&&l!=="xmlns:support"){for(var j=0;j<X._xContent.children.length;j++){var b=X._xContent.children[j].outerHTML;if(!b.match("<"+l+":")){var v=X.getViewName().split("\.").pop();I.addIssue({severity:a.Medium,details:"View '"+v+"' ("+X.getId()+") contains an unused XML namespace '"+l+"' referencing library '"+f+"'",context:{id:X.getId()}});}}}}});}});}};},true);
