/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/UIComponent","sap/ui/Device","sap/ui/documentation/sdk/model/models","sap/ui/documentation/sdk/controller/ErrorHandler","sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/util/DocumentationRouter","sap/ui/documentation/sdk/controller/util/ConfigUtil","sap/ui/documentation/sdk/controller/util/APIInfo","sap/m/ColumnListItem"],function(U,D,m,E,J,a,C,A,b){"use strict";var t=[],l={},T=1000000;return U.extend("sap.ui.documentation.sdk.Component",{metadata:{manifest:"json",includes:["css/style.css","thirdparty/google-code-prettify/prettify.css","thirdparty/google-code-prettify/prettify.js","thirdparty/google-code-prettify/lang-css.js"]},init:function(){this._modelsPromise=null;this._oErrorHandler=new E(this);this.setModel(m.createDeviceModel(),"device");this.setModel(new J(),"treeData");this.setModel(new J(),"libsData");U.prototype.init.apply(this,arguments);this.getRouter().initialize();if(D.system.desktop){this.fetchAPIInfoAndBindModels();}sap.m.TablePopin.prototype.onfocusin=function(){};},destroy:function(){this._oErrorHandler.destroy();this._oConfigUtil.destroy();this._oConfigUtil=null;U.prototype.destroy.apply(this,arguments);},getContentDensityClass:function(){if(this._sContentDensityClass===undefined){if(jQuery(document.body).hasClass("sapUiSizeCozy")||jQuery(document.body).hasClass("sapUiSizeCompact")){this._sContentDensityClass="";}else if(!D.support.touch){this._sContentDensityClass="sapUiSizeCompact";}else{this._sContentDensityClass="sapUiSizeCozy";}}return this._sContentDensityClass;},getConfigUtil:function(){if(!this._oConfigUtil){this._oConfigUtil=new C(this);}return this._oConfigUtil;},fetchAPIInfoAndBindModels:function(){if(this._modelsPromise){return this._modelsPromise;}this._modelsPromise=new Promise(function(r){A.getAllLibrariesElementsJSONPromise().then(function(L){L.forEach(this._parseLibraryElements,this);if(t.length>0){t.push({isSelected:false,name:"experimental",ref:"#/api/experimental",text:"Experimental APIs"},{isSelected:false,name:"deprecated",ref:"#/api/deprecated",text:"Deprecated APIs"});}this._addDeprecatedAndExperimentalData(l);this._bindAllLibsModel(l);this._bindTreeModel(t);r();}.bind(this));}.bind(this));return this._modelsPromise;},isInternalVersion:function(){return/internal/i.test(sap.ui.getVersionInfo().name);},_parseLibraryElements:function(L){for(var i=0;i<L.length;i++){if(!L[i].children){l[L[i].name]=L[i];}this._addElementToTreeData(L[i]);if(L[i].children){this._parseLibraryElements(L[i].children,true);}}},_addElementToTreeData:function(j){if(j.visibility==="public"){if(j.kind!=="namespace"){var o=this._createTreeNode(j.basename,j.name,j.name===this._topicId);var n=j.name.substring(0,(j.name.indexOf(j.basename)-1));var e=this._findNodeNamespaceInTreeStructure(n);if(e){if(!e.nodes){e.nodes=[];}e.nodes.push(o);}else{var N=this._createTreeNode(n,n,n===this._topicId);N.nodes=[];N.nodes.push(o);t.push(N);this._removeDuplicatedNodeFromTree(n);}}else{var N=this._createTreeNode(j.name,j.name,j.name===this._topicId);t.push(N);}}},_createTreeNode:function(c,n,i){var o={};o.text=c;o.name=n;o.ref="#/api/"+n;o.isSelected=i;return o;},_findNodeNamespaceInTreeStructure:function(n,c){c=c||t;for(var i=0;i<c.length;i++){var o=c[i];if(o.name===n){return o;}if(o.nodes){var d=this._findNodeNamespaceInTreeStructure(n,o.nodes);if(d){return d;}}}},_removeNodeFromNamespace:function(n,N){for(var i=0;i<N.nodes.length;i++){if(N.nodes[i].text===n){N.nodes.splice(i,1);return;}}},_removeDuplicatedNodeFromTree:function(n){if(l[n]){var N=n.substring(0,n.lastIndexOf("."));var o=this._findNodeNamespaceInTreeStructure(N);var s=n.substring(n.lastIndexOf(".")+1,n.lenght);this._removeNodeFromNamespace(s,o);}},_bindAllLibsModel:function(o){var L=this.getModel("libsData");L.setSizeLimit(T);L.setData(o,false);},_bindTreeModel:function(t){var c=this.getModel("treeData");c.setSizeLimit(T);c.setData(t,false);},_addDeprecatedAndExperimentalData:function(l){var w="Without Version",i=this.isInternalVersion();l.deprecated={noVersion:{name:w,apis:[]}};l.experimental={noVersion:{name:w,apis:[]}};function c(d,e,o,s){var f={control:s,entityName:e.name,text:e[d].text||e.description,type:o,"static":!!e.static};if(e[d].since){var S=e[d].since.split(".");var v=S[0]+"."+S[1];f.since=e[d].since;if(!l[d][v]){l[d][v]={name:v,apis:[]};}l[d][v].apis.push(f);}else{l[d].noVersion.apis.push(f);}}Object.keys(l).forEach(function(L){var s=l[L];s.methods&&s.methods.forEach(function(M){var I=M.visibility==="restricted";if(I&&!i){return;}if(M.deprecated){c("deprecated",M,"methods",s.name);}if(M.experimental){c("experimental",M,"methods",s.name);}});s.events&&s.events.forEach(function(e){if(e.deprecated){c("deprecated",e,"events",s.name);}if(e.experimental){c("experimental",e,"events",s.name);}});});}});});
