/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','./library'],function(q,C,l){"use strict";var B=C.extend("sap.ui.layout.BlockLayoutRow",{metadata:{library:"sap.ui.layout",properties:{scrollable:{type:"boolean",group:"Appearance",defaultValue:false},rowColorSet:{type:"sap.ui.layout.BlockRowColorSets",group:"Appearance"}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.layout.BlockLayoutCell",multiple:true,singularName:"content"}},associations:{accentCells:{type:"sap.ui.layout.BlockLayoutCell",multiple:true,singularName:"accentCell"}}}});B.CONSTANTS={maxScrollableCellsPerRow:10,minScrollableCellsPerRow:3,guidelineRatios:[0.25,0.5,0.75,1.0]};B.prototype.onBeforeRendering=function(){this._checkGuidelinesAndUpdateCells();};B.prototype.setRowColorSet=function(t){var a=Array.prototype.slice.call(arguments),o=C.prototype.setProperty.apply(this,["rowColorSet"].concat(a)),c="sapUiBlockLayoutBackground"+t,p=this.getParent(),b=p&&p.getBackground(),T=p&&p.indexOfAggregation("content",this),P=p&&p.getContent(),d=(T&&P[T-1])||null,n=(P&&P[T+1])||null,e=sap.ui.layout.BlockRowColorSets,f=Object.keys(e).map(function(k){return e[k];}),i=false;if(d&&d._hasStyleClass(c,b,i,t)){c+="Inverted";i=true;}f.forEach(function(s){var g="sapUiBlockLayoutBackground"+s,I=g+"Inverted";if(this._hasStyleClass(g,b,false,s)){this.removeStyleClass(g,true);}else if(this._hasStyleClass(I,b,true,s)){this.removeStyleClass(I,true);}},this);this.addStyleClass(c,true);if(n&&n._hasStyleClass(c,b,i,t)){n.setRowColorSet.apply(n,a);}this.invalidate();return o;};B.prototype.addAccentCell=function(i){var o,I=i&&i.getId?i.getId():i,a=Array.prototype.slice.call(arguments),b=sap.ui.layout.BlockBackgroundType,p=this.getParent(),L=p&&(p.getBackground()||"");o=this.addAssociation.apply(this,["accentCells"].concat(a));if(!p){return this;}if([b.Accent,b.Mixed].indexOf(L)===-1){q.sap.log.warning(I+" was not se as accent cell. Accent cells could be set only for 'Accent' and 'Mixed' layout backgrounds.");return this;}if(b.Mixed===L){this._processMixedCellStyles(I,this.getContent());}else if(b.Accent===L){this._processAccentCellStyles(this.getAccentCells(),this.getContent());}return o;};B.prototype._processMixedCellStyles=function(i,c){var p,P;if(!c||!c.length){q.sap.log.warning("No accent cells were set");return this;}p=this.getParent();P=p&&(p.hasStyleClass("sapUiBlockLayoutSizeL")||p.hasStyleClass("sapUiBlockLayoutSizeXL"));c.forEach(function(o){var a,u;if(P&&o.getId()===i&&o.getWidth()===1){o.addStyleClass("sapContrast").addStyleClass("sapContrastPlus");a=sap.ui.layout.BlockRowColorSets;u=this._hasStyleClass("sapUiBlockLayoutBackground"+a.ColorSet1,sap.ui.layout.BlockBackgroundType.Mixed,false,a.ColorSet1)||this._hasStyleClass("sapUiBlockLayoutBackground"+a.ColorSet1,sap.ui.layout.BlockBackgroundType.Mixed,true,a.ColorSet1);if(u){o.addStyleClass("sapUiBlockLayoutBackgroundContrast2");}}else if((!P||o.getId()!==i)&&(o.hasStyleClass("sapContrast")||o.hasStyleClass("sapContrastPlus"))){o.removeStyleClass("sapContrast").removeStyleClass("sapContrastPlus").removeStyleClass("sapUiBlockLayoutBackgroundContrast2");this.removeAssociation("accentCells",o);q.sap.log.warning(i+" was removed as accent cell. Only one cell at a time could be accented for Mixed layout background");}},this);return this;};B.prototype._processAccentCellStyles=function(a,r){var c,s,b,i=0,I=0,A=Array.prototype.slice.call(a);if(!a||!a.length){q.sap.log.warning("No accent cells were set");return this;}for(i=0;i<r.length;i++){c=r[i];s=c.getId();if(!A.length){break;}if(A.indexOf(s)>-1){I++;b="sapUiBlockLayoutBackgroundColorSetGray"+((I%2)+1);if(c.hasStyleClass(b)){continue;}A.splice(A.indexOf(s),1);c.removeStyleClass("sapUiBlockLayoutBackgroundColorSetGray1").removeStyleClass("sapUiBlockLayoutBackgroundColorSetGray2").addStyleClass(b);}}return this;};B.prototype._checkGuidelinesAndUpdateCells=function(){var t=this,c=this.getContent(),a=this._calcCellRatios(),d=this._checkDifferentSBreakpointCase(),g=this._guidelinesCheck();c.forEach(function(b,i){b._clearState();if(t.getScrollable()){b._setParentRowScrollable(true);}else if(d&&g){b._setDifferentSBreakpointSize(true,a[i]);}});if(!this.getScrollable()&&d&&g){this._rowSCase=true;this.addStyleClass("sapUiBlockRowSCase",true);}else{this._rowSCase=false;this.removeStyleClass("sapUiBlockRowSCase",true);}};B.prototype._guidelinesCheck=function(){if(this.getScrollable()){return this._checkScrollableCellsCount();}else{return this._checkNonScrollableGuidelines();}};B.prototype._calcCellRatios=function(){var c=[],t=0,a=this.getContent();a.forEach(function(b){var d=(b.getWidth()==0)?1:b.getWidth();t+=d;});a.forEach(function(b){var d=(b.getWidth()==0)?1:b.getWidth(),e=d/t;c.push(e);});return c;};B.prototype._checkNonScrollableGuidelines=function(){var t=this,c=this._calcCellRatios(),g=true;c.forEach(function(a){if(!t._isCellRatioIncluded(a)){g=false;}});if(!g){q.sap.log.error("In your BlockLayoutRow "+this.getId()+" you are using cell ratios that are "+"not recommended in the guidelines. Cells can be with width of 25% 50% 75% or 100% according to the guidelines.");}return g;};B.prototype._checkDifferentSBreakpointCase=function(){var c=this._calcCellRatios(),a=this.getContent();if(a.length==4||(a.length==3&&c[1]!=0.5)){return true;}return false;};B.prototype._isCellRatioIncluded=function(r){var g=B.CONSTANTS.guidelineRatios;for(var i=0;i<g.length;i++){if(g[i]===r){return true;}}return false;};B.prototype._checkScrollableCellsCount=function(){if(this.getContent().length>B.CONSTANTS.maxScrollableCellsPerRow){q.sap.log.error("You are using too much cells in your scrollable row: "+this.getId()+"."+"This is violating the BlockLayout guidelines, please consider changing your implementation. Max cells allowed: 10.");return false;}if(this.getContent().length<B.CONSTANTS.minScrollableCellsPerRow){q.sap.log.error("You are using not enough cells in your scrollable row: "+this.getId()+"."+"This is violating the BlockLayout guidelines, please consider changing your implementation. Min cells allowed: 3.");return false;}return true;};B.prototype._hasStyleClass=function(s,L,I,t){var b=sap.ui.layout.BlockBackgroundType,c=sap.ui.layout.BlockRowColorSets,i,S,e;if([b.Light,b.Mixed].indexOf(L)===-1){return this.hasStyleClass(s);}else if(this.hasStyleClass(s)){return true;}e=[[c.ColorSet1,c.ColorSet3],[c.ColorSet2,c.ColorSet4]];for(i=0;i<=e.length;i++){if(e[i]&&e[i].indexOf(t)>-1){break;}}if(!e[i]){return false;}S=e[i].map(function(a){return"sapUiBlockLayoutBackground"+a+(I?"Inverted":"");});return S.some(this.hasStyleClass,this);};return B;},true);
