/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/model/BindingMode','sap/ui/base/BindingParser','sap/ui/model/Context','sap/ui/base/ManagedObject','sap/ui/model/ClientContextBinding','sap/ui/model/FilterProcessor','sap/ui/model/json/JSONModel','sap/ui/model/json/JSONListBinding','sap/ui/model/json/JSONPropertyBinding','sap/ui/model/json/JSONTreeBinding','sap/ui/model/MetaModel','./_ODataMetaModelUtils'],function(q,B,a,C,M,b,F,J,c,d,e,f,U){"use strict";var o="sap.ui.model.odata.ODataMetaModel",p=[o],P=o+"/load",r=/^((\/dataServices\/schema\/\d+)\/(?:complexType|entityType)\/\d+)\/property\/\d+$/;var O=c.extend("sap.ui.model.odata.ODataMetaListBinding"),R=M.extend("sap.ui.model.odata._resolver",{metadata:{properties:{any:"any"}}});O.prototype.applyFilter=function(){var t=this;this.aIndices=F.apply(this.aIndices,this.aFilters.concat(this.aApplicationFilters),function(v,s){return s==="@sapui.name"?v:t.oModel.getProperty(s,t.oList[v]);});this.iLength=this.aIndices.length;};var g=f.extend("sap.ui.model.odata.ODataMetaModel",{constructor:function(m,A,h){var t=this;function l(){var D;if(t.bDestroyed){throw new Error("Meta model already destroyed");}q.sap.measure.average(P,"",p);D=JSON.parse(JSON.stringify(m.getServiceMetadata()));U.merge(A?A.getAnnotationsData():{},D);t.oModel=new J(D);t.oModel.setDefaultBindingMode(t.sDefaultBindingMode);q.sap.measure.end(P);}h=h||{};f.apply(this);this.oModel=null;this.mContext2Promise={};this.sDefaultBindingMode=B.OneTime;this.oLoadedPromise=h.annotationsLoadedPromise?h.annotationsLoadedPromise.then(l):new Promise(function(i,j){l();i();});this.oMetadata=m;this.oODataModelInterface=h;this.mQueryCache={};this.mQName2PendingRequest={};this.oResolver=undefined;this.mSupportedBindingModes={"OneTime":true};}});g.prototype._getObject=function(s,h){var j=h,k,l,i,E,n,v,m,t=s||"",u;if(!h||h instanceof C){t=this.resolve(s||"",h);if(!t){q.sap.log.error("Invalid relative path w/o context",s,o);return null;}}if(t.charAt(0)==="/"){j=this.oModel._getObject("/");t=t.slice(1);}m="/";n=j;while(t){v=undefined;k=undefined;if(t.charAt(0)==='['){try{u=a.parseExpression(t,1);E=u.at;if(E>=0&&(t.length===E+1||t.charAt(E+1)==='/')){k=u.result;v=t.slice(0,E+1);t=t.slice(E+2);}}catch(w){if(!(w instanceof SyntaxError)){throw w;}}}if(v===undefined){E=t.indexOf("/");if(E<0){v=t;t="";}else{v=t.slice(0,E);t=t.slice(E+1);}}if(!n){if(q.sap.log.isLoggable(q.sap.log.Level.WARNING,o)){q.sap.log.warning("Invalid part: "+v,"path: "+s+", context: "+(h instanceof C?h.getPath():h),o);}break;}if(k){if(j===h){q.sap.log.error("A query is not allowed when an object context has been given",s,o);return null;}if(!Array.isArray(n)){q.sap.log.error("Invalid query: '"+m+"' does not point to an array",s,o);return null;}l=m+v;v=this.mQueryCache[l];if(v===undefined){this.oResolver=this.oResolver||new R({models:this.oModel});for(i=0;i<n.length;i++){this.oResolver.bindObject(m+i);this.oResolver.bindProperty("any",k);try{if(this.oResolver.getAny()){this.mQueryCache[l]=v=i;break;}}finally{this.oResolver.unbindProperty("any");this.oResolver.unbindObject();}}}}n=n[v];m=m+v+"/";}return n;};g.prototype._mergeMetadata=function(h){var E=this.getODataEntityContainer(),m=U.getChildAnnotations(h.annotations,E.namespace+"."+E.name,true),i=E.entitySet.length,s=this.oModel.getObject("/dataServices/schema"),t=this;h.entitySets.forEach(function(j){var k,S,T=j.entityType,n=T.slice(0,T.lastIndexOf("."));if(!t.getODataEntitySet(j.name)){E.entitySet.push(JSON.parse(JSON.stringify(j)));if(!t.getODataEntityType(T)){k=t.oMetadata._getEntityTypeByName(T);S=U.getSchema(s,n);S.entityType.push(JSON.parse(JSON.stringify(k)));U.visitParents(S,h.annotations,"entityType",U.visitEntityType,S.entityType.length-1);}}});U.visitChildren(E.entitySet,m,"EntitySet",s,null,i);};g.prototype._sendBundledRequest=function(){var Q=this.mQName2PendingRequest,h=Object.keys(Q),t=this;if(!h.length){return;}this.mQName2PendingRequest={};h=h.sort();h.forEach(function(s,i){h[i]=encodeURIComponent(s);});this.oODataModelInterface.addAnnotationUrl("$metadata?sap-value-list="+h.join(",")).then(function(i){var s;t._mergeMetadata(i);for(s in Q){try{Q[s].resolve(i);}catch(E){Q[s].reject(E);}}},function(E){var s;for(s in Q){Q[s].reject(E);}});};g.prototype.bindContext=function(s,h,m){return new b(this,s,h,m);};g.prototype.bindList=function(s,h,S,i,m){return new O(this,s,h,S,i,m);};g.prototype.bindProperty=function(s,h,m){return new d(this,s,h,m);};g.prototype.bindTree=function(s,h,i,m){return new e(this,s,h,i,m);};g.prototype.destroy=function(){f.prototype.destroy.apply(this,arguments);return this.oModel&&this.oModel.destroy.apply(this.oModel,arguments);};g.prototype.getMetaContext=function(s){var A,E,h,m,n,i,Q;function j(S){var k=S.indexOf("(");return k>=0?S.slice(0,k):S;}if(!s){return null;}i=s.split("/");if(i[0]!==""){throw new Error("Not an absolute path: "+s);}i.shift();E=this.getODataEntitySet(j(i[0]));if(!E){throw new Error("Entity set not found: "+i[0]);}i.shift();Q=E.entityType;while(i.length){h=this.getODataEntityType(Q);n=j(i[0]);A=this.getODataAssociationEnd(h,n);if(A){Q=A.type;if(A.multiplicity==="1"&&n!==i[0]){throw new Error("Multiplicity is 1: "+i[0]);}i.shift();}else{m=this.getODataProperty(h,i,true);if(i.length){throw new Error("Property not found: "+i.join("/"));}break;}}m=m||this.getODataEntityType(Q,true);return this.createBindingContext(m);};g.prototype.getODataAssociationEnd=function(E,n){var N=E?U.findObject(E.navigationProperty,n):null,A=N?U.getObject(this.oModel,"association",N.relationship):null,h=A?U.findObject(A.end,N.toRole,"role"):null;return h;};g.prototype.getODataAssociationSetEnd=function(E,n){var A,h=null,i=this.getODataEntityContainer(),N=E?U.findObject(E.navigationProperty,n):null;if(i&&N){A=U.findObject(i.associationSet,N.relationship,"association");h=A?U.findObject(A.end,N.toRole,"role"):null;}return h;};g.prototype.getODataComplexType=function(Q,A){return U.getObject(this.oModel,"complexType",Q,A);};g.prototype.getODataEntityContainer=function(A){var v=A?undefined:null,s=this.oModel.getObject("/dataServices/schema");if(s){s.forEach(function(S,i){var j=U.findIndex(S.entityContainer,"true","isDefaultEntityContainer");if(j>=0){v=A?"/dataServices/schema/"+i+"/entityContainer/"+j:S.entityContainer[j];return false;}});if(!v&&s.length===1&&s[0].entityContainer&&s[0].entityContainer.length===1){v=A?"/dataServices/schema/0/entityContainer/0":s[0].entityContainer[0];}}return v;};g.prototype.getODataEntitySet=function(n,A){return U.getFromContainer(this.getODataEntityContainer(),"entitySet",n,A);};g.prototype.getODataEntityType=function(Q,A){return U.getObject(this.oModel,"entityType",Q,A);};g.prototype.getODataFunctionImport=function(n,A){var h=n&&n.indexOf('/')>=0?n.split('/'):undefined,E=h?U.getObject(this.oModel,"entityContainer",h[0]):this.getODataEntityContainer();return U.getFromContainer(E,"functionImport",h?h[1]:n,A);};g.prototype.getODataProperty=function(t,n,A){var i,h=Array.isArray(n)?n:[n],j=null,s;while(t&&h.length){i=U.findIndex(t.property,h[0]);if(i<0){break;}h.shift();j=t.property[i];s=t.$path+"/property/"+i;if(h.length){t=this.getODataComplexType(j.type);}}return A?s:j;};g.prototype.getODataValueLists=function(h){var i=false,m,s=h.getPath(),j=this.mContext2Promise[s],t=this;if(j){return j;}m=r.exec(s);if(!m){throw new Error("Unsupported property context with path "+s);}j=new Promise(function(k,l){var n=h.getObject(),Q,v=U.getValueLists(n);if(!(""in v)&&n["sap:value-list"]&&t.oODataModelInterface.addAnnotationUrl){i=true;Q=t.oModel.getObject(m[2]).namespace+"."+t.oModel.getObject(m[1]).name;t.mQName2PendingRequest[Q+"/"+n.name]={resolve:function(u){q.extend(n,((u.annotations.propertyAnnotations||{})[Q]||{})[n.name]);v=U.getValueLists(n);if(q.isEmptyObject(v)){l(new Error("No value lists returned for "+s));}else{delete t.mContext2Promise[s];k(v);}},reject:l};setTimeout(t._sendBundledRequest.bind(t),0);}else{k(v);}});if(i){this.mContext2Promise[s]=j;}return j;};g.prototype.getProperty=function(){return this._getObject.apply(this,arguments);};g.prototype.isList=function(){return this.oModel.isList.apply(this.oModel,arguments);};g.prototype.loaded=function(){return this.oLoadedPromise;};g.prototype.refresh=function(){throw new Error("Unsupported operation: ODataMetaModel#refresh");};g.prototype.setLegacySyntax=function(l){if(l){throw new Error("Legacy syntax not supported by ODataMetaModel");}};g.prototype.setProperty=function(){throw new Error("Unsupported operation: ODataMetaModel#setProperty");};return g;});
