/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global"],function(q){"use strict";var b={"Bool":"false"},B={"Bool":"true"},f={"interval":"SingleInterval","multi-value":"MultiValue","single-value":"SingleValue"},l="sap.ui.model.odata.ODataMetaModel",s={"bday":"Contact","city":"Contact/adr","country":"Contact/adr","email":"Contact/email","familyname":"Contact/n","givenname":"Contact/n","honorific":"Contact/n","middlename":"Contact/n","name":"Contact","nickname":"Contact","note":"Contact","org":"Contact","org-role":"Contact","org-unit":"Contact","photo":"Contact","pobox":"Contact/adr","region":"Contact/adr","street":"Contact/adr","suffix":"Contact/n","tel":"Contact/tel","title":"Contact","zip":"Contact/adr","class":"Event","dtend":"Event","dtstart":"Event","duration":"Event","fbtype":"Event","location":"Event","status":"Event","transp":"Event","wholeday":"Event","body":"Message","from":"Message","received":"Message","sender":"Message","subject":"Message","completed":"Task","due":"Task","percent-complete":"Task","priority":"Task"},r=/(\w+)(?:;type=([\w,]+))?/,v={"email":{typeMapping:{"home":"home","pref":"preferred","work":"work"},v4EnumType:"com.sap.vocabularies.Communication.v1.ContactInformationType",v4PropertyAnnotation:"com.sap.vocabularies.Communication.v1.IsEmailAddress"},"tel":{typeMapping:{"cell":"cell","fax":"fax","home":"home","pref":"preferred","video":"video","voice":"voice","work":"work"},v4EnumType:"com.sap.vocabularies.Communication.v1.PhoneType",v4PropertyAnnotation:"com.sap.vocabularies.Communication.v1.IsPhoneNumber"}},V={creatable:{"Org.OData.Capabilities.V1.InsertRestrictions":{"Insertable":b}},pageable:{"Org.OData.Capabilities.V1.SkipSupported":b,"Org.OData.Capabilities.V1.TopSupported":b},"requires-filter":{"Org.OData.Capabilities.V1.FilterRestrictions":{"RequiresFilter":B}},topable:{"Org.OData.Capabilities.V1.TopSupported":b}},m={"city":"locality","email":"address","familyname":"surname","givenname":"given","honorific":"prefix","middlename":"additional","name":"fn","org-role":"role","org-unit":"orgunit","percent-complete":"percentcomplete","tel":"uri","zip":"code"},a={"sap:filterable":["Org.OData.Capabilities.V1.FilterRestrictions","NonFilterableProperties"],"sap:required-in-filter":["Org.OData.Capabilities.V1.FilterRestrictions","RequiredProperties"],"sap:sortable":["Org.OData.Capabilities.V1.SortRestrictions","NonSortableProperties"]},c=/^com\.sap\.vocabularies\.Common\.v1\.ValueList(#.*)?$/,w=q.sap.log.Level.WARNING,U;U={addEntitySetAnnotation:function(o,e,t,n,d){if(t==="EntitySet"&&e.value===n){if(d){q.extend(true,o,V[e.name]);}else{q.extend(o,V[e.name]);}}},addFilterRestriction:function(p,e){var F,d=f[p["sap:filter-restriction"]];if(!d){if(q.sap.log.isLoggable(w,l)){q.sap.log.warning("Unsupported sap:filter-restriction: "+p["sap:filter-restriction"],e.entityType+"."+p.name,l);}return;}F=e["com.sap.vocabularies.Common.v1.FilterExpressionRestrictions"]||[];F.push({"Property":{"PropertyPath":p.name},"AllowedExpressions":{"EnumMember":"com.sap.vocabularies.Common.v1.FilterExpressionType/"+d}});e["com.sap.vocabularies.Common.v1.FilterExpressionRestrictions"]=F;},addPropertyToAnnotation:function(d,e,p){var n=a[d],t=n[0],C=n[1],A=e[t]||{},g=A[C]||[];g.push({"PropertyPath":p.name});A[C]=g;e[t]=A;},addSapSemantics:function(t){if(t.property){t.property.forEach(function(p){var A,i,M,S,T,d=p["sap:semantics"],e,g,o,h,j;if(!d){return;}M=r.exec(d);if(!M){if(q.sap.log.isLoggable(w,l)){q.sap.log.warning("Unsupported sap:semantics: "+d,t.name+"."+p.name,l);}return;}if(M[2]){d=M[1];j=U.getV4TypesForV2Semantics(d,M[2],p,t);}h=v[d];i=d==="tel"||d==="email";g=s[d];if(g){A=g.split("/");e="com.sap.vocabularies.Communication.v1."+A[0];t[e]=t[e]||{};o=t[e];S=A[1];if(S){o[S]=o[S]||(i?[]:{});if(i){T={};o[S].push(T);o=T;}else{o=o[S];}}o[m[d]||d]={"Path":p.name};if(j){o.type={"EnumMember":j};}}if(h){p[h.v4PropertyAnnotation]=p[h.v4PropertyAnnotation]||B;}});}},addUnitAnnotation:function(o,p){var u=o["sap:unit"],i=U.findIndex(p,u),d;if(i>=0){d=p[i];if(d["sap:semantics"]==="unit-of-measure"){o["Org.OData.Measures.V1.Unit"]={"Path":d.name};}else if(d["sap:semantics"]==="currency-code"){o["Org.OData.Measures.V1.ISOCurrency"]={"Path":d.name};}}},addV4Annotation:function(o,e,t){switch(e.name){case"aggregation-role":if(e.value==="dimension"){o["com.sap.vocabularies.Analytics.v1.Dimension"]=B;}else if(e.value==="measure"){o["com.sap.vocabularies.Analytics.v1.Measure"]=B;}break;case"display-format":if(e.value==="NonNegative"){o["com.sap.vocabularies.Common.v1.IsDigitSequence"]=B;}else if(e.value==="UpperCase"){o["com.sap.vocabularies.Common.v1.IsUpperCase"]=B;}break;case"pageable":case"topable":U.addEntitySetAnnotation(o,e,t,"false",false);break;case"creatable":U.addEntitySetAnnotation(o,e,t,"false",true);break;case"deletable":case"deletable-path":U.handleXableAndXablePath(o,e,t,"Org.OData.Capabilities.V1.DeleteRestrictions","Deletable");break;case"updatable":case"updatable-path":U.handleXableAndXablePath(o,e,t,"Org.OData.Capabilities.V1.UpdateRestrictions","Updatable");break;case"requires-filter":U.addEntitySetAnnotation(o,e,t,"true",true);break;case"field-control":o["com.sap.vocabularies.Common.v1.FieldControl"]={"Path":e.value};break;case"heading":o["com.sap.vocabularies.Common.v1.Heading"]={"String":e.value};break;case"label":o["com.sap.vocabularies.Common.v1.Label"]={"String":e.value};break;case"precision":o["Org.OData.Measures.V1.Scale"]={"Path":e.value};break;case"quickinfo":o["com.sap.vocabularies.Common.v1.QuickInfo"]={"String":e.value};break;case"text":o["com.sap.vocabularies.Common.v1.Text"]={"Path":e.value};break;case"visible":if(e.value==="false"){o["com.sap.vocabularies.Common.v1.FieldControl"]={"EnumMember":"com.sap.vocabularies.Common.v1.FieldControlType/Hidden"};o["com.sap.vocabularies.UI.v1.Hidden"]=B;}break;default:}},calculateEntitySetAnnotations:function(e,E){if(E.property){E.property.forEach(function(p){if(p["sap:filterable"]==="false"){U.addPropertyToAnnotation("sap:filterable",e,p);}if(p["sap:required-in-filter"]==="true"){U.addPropertyToAnnotation("sap:required-in-filter",e,p);}if(p["sap:sortable"]==="false"){U.addPropertyToAnnotation("sap:sortable",e,p);}if(p["sap:filter-restriction"]){U.addFilterRestriction(p,e);}});}if(E.navigationProperty){E.navigationProperty.forEach(function(n){if(n["sap:filterable"]==="false"){U.addPropertyToAnnotation("sap:filterable",e,n);}U.handleCreatableNavigationProperty(e,n);});}},findIndex:function(A,e,p){var I=-1;p=p||"name";if(A){A.forEach(function(o,i){if(o[p]===e){I=i;return false;}});}return I;},findObject:function(A,e,p){var i=U.findIndex(A,e,p);return i<0?null:A[i];},getChildAnnotations:function(A,Q,i){var o=i?A.EntityContainer:A.propertyAnnotations;return o&&o[Q]||{};},getFromContainer:function(e,A,n,d){var k,R=d?undefined:null;if(e){k=U.findIndex(e[A],n);if(k>=0){R=d?e.$path+"/"+A+"/"+k:e[A][k];}}return R;},getObject:function(M,A,Q,d){var e,R=d?undefined:null,S,i,n,N;Q=Q||"";i=Q.lastIndexOf(".");n=Q.slice(0,i);N=Q.slice(i+1);S=U.getSchema(M,n);if(S){e=S[A];if(e){e.forEach(function(t){if(t.name===N){R=d?t.$path:t;return false;}});}}return R;},getSchema:function(M,n){var S=null,d=Array.isArray(M)?M:M.getObject("/dataServices/schema");if(d){d.forEach(function(o){if(o.namespace===n){S=o;return false;}});}return S;},getV4TypesForV2Semantics:function(S,t,p,T){var R=[],o=v[S];if(o){t.split(",").forEach(function(d){var e=o.typeMapping[d];if(e){R.push(o.v4EnumType+"/"+e);}else if(q.sap.log.isLoggable(w,l)){q.sap.log.warning("Unsupported type for sap:semantics: "+d,T.name+"."+p.name,l);}});}return R.join(" ");},getValueLists:function(p){var M,n,Q,d={};for(n in p){M=c.exec(n);if(M){Q=(M[1]||"").slice(1);d[Q]=p[n];}}return d;},handleCreatableNavigationProperty:function(e,n){var C=n["sap:creatable"],d=n["sap:creatable-path"],i,N={"NavigationPropertyPath":n.name},g;if(C&&d){q.sap.log.warning("Inconsistent service","Use either 'sap:creatable' or 'sap:creatable-path' at navigation property "+"'"+e.entityType+"/"+n.name+"'",l);C="false";d=undefined;}if(C==="false"||d){i=e["Org.OData.Capabilities.V1.InsertRestrictions"]=e["Org.OData.Capabilities.V1.InsertRestrictions"]||{};g=i["NonInsertableNavigationProperties"]=i["NonInsertableNavigationProperties"]||[];if(d){N={"If":[{"Not":{"Path":d}},N]};}g.push(N);}},handleXableAndXablePath:function(o,e,t,T,p){var d=p.toLowerCase(),g;if(t!=="EntitySet"){return;}if(o["sap:"+d]&&o["sap:"+d+"-path"]){q.sap.log.warning("Inconsistent service","Use either 'sap:"+d+"' or 'sap:"+d+"-path'"+" at entity set '"+o.name+"'",l);g=b;}else if(d!==e.name){g={"Path":e.value};}else if(e.value==="false"){g=b;}if(g){o[T]=o[T]||{};o[T][p]=g;}},liftSAPData:function(o,t){if(!o.extensions){return;}o.extensions.forEach(function(e){if(e.namespace==="http://www.sap.com/Protocols/SAPData"){o["sap:"+e.name]=e.value;U.addV4Annotation(o,e,t);}});switch(t){case"Property":if(o["sap:updatable"]==="false"){if(o["sap:creatable"]==="false"){o["Org.OData.Core.V1.Computed"]=B;}else{o["Org.OData.Core.V1.Immutable"]=B;}}break;case"EntitySet":if(o["sap:searchable"]!=="true"){o["Org.OData.Capabilities.V1.SearchRestrictions"]={"Searchable":b};}break;default:}},merge:function(A,d){var S=d.dataServices.schema;if(!S){return;}S.forEach(function(o,i){delete o.annotations;U.liftSAPData(o);o.$path="/dataServices/schema/"+i;q.extend(o,A[o.namespace]);U.visitParents(o,A,"association",function(e,C){U.visitChildren(e.end,C);});U.visitParents(o,A,"complexType",function(C,e){U.visitChildren(C.property,e,"Property");U.addSapSemantics(C);});U.visitParents(o,A,"entityType",U.visitEntityType);U.visitParents(o,A,"entityContainer",function(e,C){U.visitChildren(e.associationSet,C);U.visitChildren(e.entitySet,C,"EntitySet",S);U.visitChildren(e.functionImport,C,"",null,U.visitParameters.bind(this,A,o,e));});});},visitChildren:function(C,d,t,S,e,i){if(!C){return;}if(i){C=C.slice(i);}C.forEach(function(o){U.liftSAPData(o,t);});C.forEach(function(o){var E;if(t==="Property"&&o["sap:unit"]){U.addUnitAnnotation(o,C);}else if(t==="EntitySet"){E=U.getObject(S,"entityType",o.entityType);U.calculateEntitySetAnnotations(o,E);}if(e){e(o);}q.extend(o,d[o.name||o.role]);});},visitEntityType:function(e,C){U.visitChildren(e.property,C,"Property");U.visitChildren(e.navigationProperty,C);U.addSapSemantics(e);},visitParameters:function(A,S,e,F){var d;if(!F.parameter){return;}d=U.getChildAnnotations(A,S.namespace+"."+e.name,true);F.parameter.forEach(function(p){U.liftSAPData(p);q.extend(p,d[F.name+"/"+p.name]);});},visitParents:function(S,A,d,C,i){var p=S[d];function e(P,j){var Q=S.namespace+"."+P.name,g=U.getChildAnnotations(A,Q,d==="entityContainer");U.liftSAPData(P);P.namespace=S.namespace;P.$path=S.$path+"/"+d+"/"+j;C(P,g);q.extend(P,A[Q]);}if(!p){return;}if(i!==undefined){e(p[i],i);}else{p.forEach(e);}}};return U;},false);
