/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/support/supportRules/Storage","sap/ui/support/supportRules/Constants"],function(q,s,c){"use strict";var r={};var R=function(S){S=S||{};if(!S.name){q.sap.log.error("Please provide a name for the RuleSet.");}if(r[S.name]){return r[S.name];}this._oSettings=S;this._mRules={};r[S.name]=this;};R.clearAllRuleSets=function(){r={};};R.prototype.getRules=function(){return this._mRules;};R.prototype.updateRule=function(o,n){var v=this._verifySettingsObject(n,true);if(v==="success"){delete this._mRules[o];this._mRules[n.id]=n;}return v;};R.prototype._verifySettingsObject=function(S,u){if(!S.id){q.sap.log.error("Support rule needs an id.");return"Support rule needs an unique id.";}if(!u&&this._mRules[S.id]){q.sap.log.error("Support rule with the id "+S.id+" already exists.");return"Support rule with the id "+S.id+" already exists.";}if(!S.check){q.sap.log.error("Support rule with the id "+S.id+" needs a check function.");return"Support rule with the id "+S.id+" needs a check function.";}if(!S.title){q.sap.log.error("Support rule with the id "+S.id+" needs a title.");return"Support rule with the id "+S.id+" needs a title.";}if(!S.description){q.sap.log.error("Support rule with the id "+S.id+" needs a description.");return"Support rule with the id "+S.id+" needs a description.";}if(!S.resolution&&(!S.resolutionurls||!S.resolutionurls.length>0)){q.sap.log.error("Support rule with the id "+S.id+" needs either a resolution or resolutionurls or should have a ticket handler function");return"Support rule with the id "+S.id+" needs either a resolution or resolutionurls or should have a ticket handler function";}if(!S.audiences||S.audiences.length===0){q.sap.log.error("Support rule with the id "+S.id+" should have an audience. Applying audience ['Control']");S.audiences=[sap.ui.support.Audiences.Control];}if(S.audiences&&S.audiences.forEach){var w=false,a="";S.audiences.forEach(function(f){if(!sap.ui.support.Audiences[f]){w=true;a=f;}});if(w){q.sap.log.error("Audience "+a+" does not exist. Please use the audiences from sap.ui.support.Audiences");return"Audience "+a+" does not exist. Please use the audiences from sap.ui.support.Audiences";}}if(!S.categories||S.categories.length===0){q.sap.log.error("Support rule with the id "+S.id+" should have a category. Applying category ['Performance']");S.categories=["Performance"];}if(S.categories&&S.categories.forEach){var b=false,d="";S.categories.forEach(function(f){if(!sap.ui.support.Categories[f]){b=true;d=f;}});if(b){q.sap.log.error("Category "+d+" does not exist. Please use the categories from sap.ui.support.Categories");return"Category "+d+" does not exist. Please use the categories from sap.ui.support.Categories";}}return"success";};R.prototype.addRule=function(S){var C=R.versionInfo?R.versionInfo.version:'';var a=S.minversion?S.minversion:'';if(a==='-'){a='';}if(a&&q.sap.Version(C).compareTo(a)<0){return"Rule "+S.id+" should be used with a version >= "+S.minversion;}var v=this._verifySettingsObject(S);if(v==="success"){this._mRules[S.id]=S;S.libName=this._oSettings.name;}return v;};R.addToTempRules=function(d,t){if(t){t.forEach(function(a){var b=a.id;d[c.TEMP_RuleSetS_NAME].RuleSet._mRules[b]=a;});}};R.storeSelectionOfRules=function(l){var a=e(l);s.setSelectedRules(a);};R.loadSelectionOfRules=function(l){var a=s.getSelectedRules();if(!a){return;}for(var i=0;i<l.length;i+=1){var b=l[i].rules;var d=l[i].title;for(var f=0;f<b.length;f+=1){if(a[d]&&a[d].hasOwnProperty(b[f].id)){b[f].selected=a[d][b[f].id].selected;}}}};function e(l){var a=Object.create(null);var b;var d=l.length;var f;var g;var h;for(var i=0;i<d;i+=1){g=l[i].title;a[g]=Object.create(null);b=l[i].rules;f=b.length;for(var j=0;j<f;j+=1){h=Object.create(null);h.id=b[j].id;h.selected=b[j].selected;a[g][h.id]=h;}}return a;}return R;},true);
