/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/core/mvc/Controller","sap/ui/model/json/JSONModel","sap/m/Panel","sap/m/List","sap/m/ListItemBase","sap/m/StandardListItem","sap/m/InputListItem","sap/m/Button","sap/m/Toolbar","sap/m/ToolbarSpacer","sap/m/Label","sap/m/MessageToast","sap/ui/support/supportRules/WindowCommunicationBus","sap/ui/support/supportRules/WCBChannels","sap/ui/support/supportRules/ui/models/SharedModel","sap/ui/support/supportRules/RuleSerializer","sap/ui/support/supportRules/Constants","sap/ui/support/supportRules/RuleSet","sap/ui/support/supportRules/Storage"],function($,Controller,JSONModel,Panel,List,ListItemBase,StandardListItem,InputListItem,Button,Toolbar,ToolbarSpacer,Label,MessageToast,CommunicationBus,channelNames,SharedModel,RuleSerializer,constants,Ruleset,storage){"use strict";return Controller.extend("sap.ui.support.supportRules.ui.controllers.Analysis",{onInit:function(){this.model=SharedModel;this.setCommunicationSubscriptions();this.initSettingsPopover();CommunicationBus.publish(channelNames.ON_INIT_ANALYSIS_CTRL);this.tempRulesLoaded=false;this.hackListItemBase();this.getView().setModel(this.model);},getTemporaryLib:function(){var l=this.model.getProperty("/libraries");for(var i=0;i<l.length;i++){if(l[i].title==constants.TEMP_RULESETS_NAME){return l[i];}}},setCommunicationSubscriptions:function(){CommunicationBus.subscribe(channelNames.UPDATE_SUPPORT_RULES,this.updatesupportRules,this);CommunicationBus.subscribe(channelNames.VERIFY_RULE_CREATE_RESULT,function(d){var r=d.result,n=RuleSerializer.deserialize(d.newRule,true),p=this.model.getProperty("/persistingSettings"),t=this.getTemporaryLib();if(r=="success"){t.rules.push(n);if(p){storage.setRules(t.rules);if(this.showRuleCreatedToast){MessageToast.show('Your temporary rule "'+n.id+'" was persisted in the local storage');this.showRuleCreatedToast=false;}}var e=this.model.getProperty("/newEmptyRule");this.model.setProperty("/newRule",jQuery.extend(true,{},e));this.goToRuleProperties();this.createRulesUI();this.model.setProperty("/selectedRule",n);var a=this.getView().byId("ruleSetContainer").getContent()[0];a.setExpanded(true);}else{MessageToast.show("Add rule failed because: "+r);}},this);CommunicationBus.subscribe(channelNames.VERIFY_RULE_UPDATE_RESULT,function(d){var r=d.result,u=RuleSerializer.deserialize(d.updateRule,true);if(r==="success"){var a=this.model.getProperty("/editRuleSource");var l=this.model.getProperty('/libraries');l.forEach(function(b,c){if(b.title===constants.TEMP_RULESETS_NAME){b.rules.forEach(function(e,f){if(e.id===a.id){b.rules[f]=u;storage.setRules(b.rules);}});}});this.model.checkUpdate(true);this.model.setProperty('/selectedRule',u);this.goToRuleProperties();}else{MessageToast.show("Update rule failed because: "+r);}},this);CommunicationBus.subscribe(channelNames.POST_AVAILABLE_LIBRARIES,function(d){this.model.setProperty("/availableLibrariesSet",d.libNames);if(this.loadingFromLoadButton){MessageToast.show("Libraries ruleset loaded");this.loadingFromLoadButton=false;}},this);CommunicationBus.subscribe(channelNames.POST_AVAILABLE_COMPONENTS,function(d){var e=[],m=this.model.getProperty("/executionScopeComponents"),s=storage.getSelectedScopeComponents(),i;for(var c=0;c<d.length;c+=1){e.push({text:d[c]});}if(m&&m.length>0){for(i=0;i<e.length;i++){e[i].selected=this.checkIfComponentIsSelected(e[i],m);}}else if(s&&s.length>0){for(i=0;i<e.length;i++){e[i].selected=this.checkIfComponentIsSelected(e[i],s);}}this.model.setProperty("/executionScopeComponents",e);},this);},checkIfComponentIsSelected:function(c,s){for(var i=0;i<s.length;i+=1){if(s[i].text==c.text&&s[i].selected){return true;}}return false;},onAnalyze:function(){var s=this._getSelectedRules(),e=this._getExecutionContext();CommunicationBus.publish(channelNames.ON_ANALYZE_REQUEST,{selectedRules:s,executionContext:e});this.model.setProperty("/showProgressIndicator",true);},initSettingsPopover:function(){this._settingsPopover=sap.ui.xmlfragment("sap.ui.support.supportRules.ui.views.AnalyzeSettings",this);this._settingsPopover.setModel(SharedModel);this.getView().addDependent(this._oPopover);},_getExecutionContext:function(){var c={type:this.model.getProperty("/analyzeContext/key")};if(c.type==="subtree"){c.parentId=this.model.getProperty("/subtreeExecutionContextId");}if(c.type==="components"){var s=sap.ui.getCore().byId("componentsSelectionContainer"),a=s.getContent();c.components=[];a.forEach(function(b){if(b.getSelected()){c.components.push(b.getText());}});}return c;},_getSelectedRules:function(){var l=this.model.getProperty("/libraries"),s=[];if(Array.isArray(l)){l.forEach(function(a,b){a.rules.forEach(function(r){if(r.selected){s.push({libName:a.title,ruleId:r.id});}});});}return s;},onAnalyzeSettings:function(e){CommunicationBus.publish(channelNames.GET_AVAILABLE_COMPONENTS);this._settingsPopover.openBy(e.getSource());},onContextSelect:function(e){if(e.getParameter("selected")){var s=e.getSource(),r=s.getCustomData()[0].getValue(),a=this.model.getProperty("/executionScopes")[r];this.model.setProperty("/analyzeContext",a);}var c=storage.readPersistenceCookie(constants.COOKIE_NAME);if(c){this.persistExecutionScope();}},onExecutionContextChange:function(e){var v=e.getSource().getValue();if(v){this.model.setProperty("/subtreeExecutionContextId",v);}var c=storage.readPersistenceCookie(constants.COOKIE_NAME);if(c){this.persistExecutionScope();}},persistExecutionScope:function(){var s={analyzeContext:this.model.getProperty("/analyzeContext"),subtreeExecutionContextId:this.model.getProperty("/subtreeExecutionContextId")};storage.setSelectedContext(s);},onScopeComponentSelect:function(e){var s=this.model.getProperty("/executionScopeComponents"),c=storage.readPersistenceCookie(constants.COOKIE_NAME);if(c){storage.setSelectedScopeComponents(s);}},onBeforePopoverOpen:function(){if(this.model.getProperty("/executionScopeComponents").length===0){CommunicationBus.publish(channelNames.GET_AVAILABLE_COMPONENTS);}},createNewRulePress:function(e){var a=this.model.getProperty("/newEmptyRule");this.model.setProperty("/selectedSetPreviewKey","availableRules");this.model.setProperty("/newRule",jQuery.extend(true,{},a));this.goToCreateRule();},goToRuleProperties:function(){var n=this.getView().byId("rulesNavContainer");n.to(this.getView().byId("rulesDisplayPage"),"show");},hackListItemBase:function(){var t=this,o=ListItemBase.prototype.ontap,a=ListItemBase.prototype.updateSelectedDOM,b=ListItemBase.prototype.onAfterRendering;var i=function(l){var c=l.getCustomData();if(!c||c.length==0){return false;}var r=false;c.forEach(function(d){if(d.getKey()==="rulesList"){r=true;}});return r;};ListItemBase.prototype.onAfterRendering=function(){b.apply(this,arguments);if(i(this.getParent())){this.$().removeClass("sapMLIBSelected");}};ListItemBase.prototype.ontap=function(e){if(!i(this.getParent())){o.call(this,e);return;}if($(e.target).hasClass("sapMCbBg")||$(e.target).hasClass("sapMCb")){o.call(this,e);}else{t.model.setProperty("/selectedRuleStringify","");t.markLIBAsSelected(this);var s=this.getBindingContext().getObject();t.model.setProperty("/selectedRule",s);t.model.setProperty("/selectedRuleStringify",t.createRuleString(s));}Ruleset.storeSelectionOfRules(t.model.getProperty("/libraries"));};ListItemBase.prototype.updateSelectedDOM=function(s,T){a.call(this,s,T);if(i(this.getParent())){T.removeClass("sapMLIBSelected");}};},createRuleString:function(r){if(!r){return'';}var s="{\n",c=0,k=Object.keys(r).length;for(var a in r){var v=r[a];c++;s+="\t";s+=a+": ";if(a==="check"){s+=v.split("\n").join("\n\t");}else{s+=JSON.stringify(v);}if(c<k){s+=",";}s+="\n";}s+="}";return s;},markLIBAsSelected:function(l){if(!l){var s=this.model.getProperty("/selectedRule/title");this.getView().byId("ruleSetContainer").getContent().forEach(function(a){a.getContent()[0].getItems().forEach(function(b){if(b.getLabel()===s){l=b;}});});}else{this.getView().$().find(".sapMLIB").removeClass("sapMLIBSelected");l.$().addClass("sapMLIBSelected");}},onAfterNavigate:function(e){var t=e.getParameter("to"),a=this;if(t===this.getView().byId("rulesDisplayPage")){setTimeout(function(){a.markLIBAsSelected();},250);}},selectAll:function(){var t=this;this.visitAllRules(function(r,a,l){t.model.setProperty("/libraries/"+l+"/rules/"+a+"/selected",true);});Ruleset.storeSelectionOfRules(this.model.getProperty("/libraries"));},deselectAll:function(){var t=this;t.visitAllRules(function(r,a,l){t.model.setProperty("/libraries/"+l+"/rules/"+a+"/selected",false);});Ruleset.storeSelectionOfRules(this.model.getProperty("/libraries"));},updateRule:function(){var o=this.model.getProperty("/editRuleSource/id"),u=this.model.getProperty("/editRule");if(this.checkFunctionString(u.check)){CommunicationBus.publish(channelNames.VERIFY_UPDATE_RULE,{oldId:o,updateObj:RuleSerializer.serialize(u)});}},updatesupportRules:function(d){d=RuleSerializer.deserialize(d);var l=[],t=this;for(var i in d){var r=[],a=d[i].ruleset._mRules;for(var j in a){var b=a[j];b.libName=i;b.selected=true;r.push(b);}l.push({title:i,type:"library",rules:r});}var f=l[0].rules[0];t.placeTemporaryRulesetAtStart(l);t.model.setProperty("/selectedRuleStringify","");t.model.setProperty("/selectedRule",f);t.model.setProperty("/selectedRuleStringify",t.createRuleString(f));t.model.setProperty("/libraries",l);var c=storage.getRules(),e=t.model.getProperty("/loadingAdditionalRuleSets");if(c&&!e&&!this.tempRulesLoaded){this.tempRulesLoaded=true;c.forEach(function(g){CommunicationBus.publish(channelNames.VERIFY_CREATE_RULE,RuleSerializer.serialize(g));});}t.model.setProperty("/loadingAdditionalRuleSets",false);Ruleset.loadSelectionOfRules(t.model.getProperty("/libraries"));t.createRulesUI();var p=t.getView().byId("ruleSetContainer").getContent()[0];p.setExpanded(true);},placeTemporaryRulesetAtStart:function(l){for(var i=0;i<l.length;i++){var r=l[i];if(r.title===constants.TEMP_RULESETS_NAME){var t=r;l.splice(i,1);l.unshift(t);return;}}},createRulesUI:function(){var l=this.model.getProperty("/libraries"),r=0,t=this,v=this.getView().byId("ruleSetContainer");t.model.setProperty("/selectedRule",t.model.getProperty("/libraries/1/rules/1"));v.getContent().forEach(function(c,a){v.removeContent(c);});l.forEach(function(a,b){var c=t._creatingContentForRulesList(a,b,t);var d=new List({mode:"MultiSelect",includeItemInSelection:true,items:{path:"/libraries/"+b+"/rules",template:new InputListItem({label:"{title}",selected:"{selected}",content:c})}});d.data("rulesList",true);if(a.rules.length===undefined){r=1;}else{r=a.rules.length;}var e=new Panel({width:"100%",expandable:true,expanded:false,content:d,headerToolbar:new Toolbar({content:[new Label({text:a.title+" ("+r+")"})]})});v.addContent(e);});},addLinkToNewRule:function(){var t=this.model.getProperty("/tempLink"),c=jQuery.extend(true,{},t);this.model.getProperty("/newRule/resolutionurls").push(c);this.model.checkUpdate(true,true);},addLinkToEditRule:function(){var t=this.model.getProperty("/tempLink"),c=jQuery.extend(true,{},t);this.model.getProperty("/editRule/resolutionurls").push(c);this.model.checkUpdate(true,true);},goToCreateRule:function(){var n=this.getView().byId("rulesNavContainer");n.to(this.getView().byId("rulesCreatePage"),"show");},checkFunctionString:function(functionString){try{eval("var testAsignedVar = "+functionString);}catch(err){MessageToast.show("Your check function contains errors, and can't be evaluated:"+err);return false;}return true;},addNewRule:function(){var n=this.model.getProperty("/newRule");if(this.checkFunctionString(n.check)){this.showRuleCreatedToast=true;CommunicationBus.publish(channelNames.VERIFY_CREATE_RULE,RuleSerializer.serialize(n));}},rulesToolbarITHSelect:function(e){if(e.getParameter("key")==="jsonOutput"){var n=this.model.getProperty("/newRule"),s=this.createRuleString(n);this.model.setProperty("/newRuleStringified",s);}},rulesToolbarEditITHSelect:function(e){if(e.getParameter("key")==="jsonOutput"){var n=this.model.getProperty("/editRule"),s=this.createRuleString(n);this.model.setProperty("/updateRuleStringified",s);}},visitAllRules:function(c){var l=this.model.getProperty("/libraries");l.forEach(function(a,b){a.rules.forEach(function(r,d){c(r,d,b);});});},loadMarkedSupportLibraries:function(){var l=this.getView().byId("availableLibrariesSet"),a=l.getSelectedItems().map(function(i){return i.getTitle();});l.getItems().forEach(function(i){i.setSelected(false);});if(a.length>0){this.loadingFromLoadButton=true;CommunicationBus.publish(channelNames.LOAD_RULESETS,{libNames:a});this.model.setProperty("/loadingAdditionalRuleSets",true);}},_creatingContentForRulesList:function(l,a,t){var b=[new sap.m.Button({icon:"sap-icon://edit",press:function(e){var s=this.getParent().getBindingContext().getObject();t.model.setProperty("/editRuleSource",s);t.model.setProperty("/editRule",jQuery.extend(true,{},s));t.model.checkUpdate(true,true);var n=t.getView().byId("rulesNavContainer");n.to(t.getView().byId("ruleUpdatePage"),"show");}}),new sap.m.Button({icon:"sap-icon://delete",press:function(e){var s=this.getParent().getBindingContext().getObject(),r=[];for(var i=0;i<l.rules.length;i++){if(l.rules[i].id!==s.id){r.push(l.rules[i]);}}t.model.setProperty("/libraries/0/rules",r);storage.removeSelectedRules(r);t.createRulesUI();var f=t.getView().byId("ruleSetContainer").getContent()[0];f.setExpanded(true);}})];var c=l.title===constants.TEMP_RULESETS_NAME?b:new sap.m.Button({text:"Duplicate",press:function(e){var s=this.getParent().getBindingContext().getObject();var d=jQuery.extend(true,{},s);t.model.setProperty("/newRule",d);t.model.checkUpdate(true,false);t.goToCreateRule();}});return c;}});});
