/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/mvc/Controller","sap/ui/model/json/JSONModel","sap/ui/support/supportRules/WindowCommunicationBus","sap/ui/support/supportRules/ui/models/SharedModel","sap/ui/support/supportRules/WCBChannels","sap/ui/support/supportRules/Constants","sap/ui/support/supportRules/Storage"],function(C,J,a,S,c,b,s){"use strict";return C.extend("sap.ui.support.supportRules.ui.controllers.Main",{onInit:function(){this.model=S;this.getView().setModel(this.model);this.resizeDown();this.setCommunicationSubscriptions();this.initSettingsPopover();this.hidden=false;this.model.setProperty("/hasNoOpener",window.opener?false:true);this.model.setProperty("/constants",b);this.updateShowButton();this._setContextSettings();},initSettingsPopover:function(){this._settingsPopover=sap.ui.xmlfragment("sap.ui.support.supportRules.ui.views.StorageSettings",this);this._settingsPopover.setModel(S);this.getView().addDependent(this._oPopover);},setCommunicationSubscriptions:function(){a.subscribe(c.ON_ANALYZE_FINISH,function(d){this._clearProcessIndicator();this.ensureOpened();this.model.setProperty("/showProgressIndicator",false);this.model.setProperty("/coreStateChanged",false);this.model.setProperty("/lastAnalysisElapsedTime",d.elapsedTime);this.goToIssues();this.model.setProperty("/analyzedFinish",true);},this);a.subscribe(c.ON_PROGRESS_UPDATE,function(d){var e=d.currentProgress,p=this.getView().byId("progressIndicator");p.setDisplayValue(e+"/"+100);this.model.setProperty("/progress",e);},this);a.subscribe(c.ON_CORE_STATE_CHANGE,function(){this.model.setProperty("/coreStateChanged",true);},this);},resizeUp:function(){a.publish(c.RESIZE_FRAME,{bigger:true});},ensureOpened:function(){a.publish(c.ENSURE_FRAME_OPENED);},resizeDown:function(){a.publish(c.RESIZE_FRAME,{bigger:false});},onPersistedSettingSelect:function(){if(this.model.getProperty("/persistingSettings")){s.createPersistenceCookie(b.COOKIE_NAME,true);this.model.getProperty("/libraries").forEach(function(l){if(l.title==b.TEMP_RULESETS_NAME){s.setRules(l.rules);}});this.persistExecutionScope();}else{s.deletePersistenceCookie(b.COOKIE_NAME);this.deletePersistedData();}},onSettings:function(e){a.publish(c.ENSURE_FRAME_OPENED);var t=this,d=e.getSource();setTimeout(function(){t._settingsPopover.openBy(d);},0);},onNavConAfterNavigate:function(e){var t=e.getParameter("to");if(t===this.getView().byId("analysis")){setTimeout(function(){t.getController().markLIBAsSelected();},250);}},goToAnalysis:function(e){var n=this.getView().byId("navCon");n.to(this.getView().byId("analysis"),"show");this.ensureOpened();},goToIssues:function(){var n=this.getView().byId("navCon");n.to(this.getView().byId("issues"),"show");this.ensureOpened();},goToWiki:function(){window.open('https://uacp2.hana.ondemand.com/viewer/DRAFT/SAPUI5_Internal/57ccd7d7103640e3a187ed55e1d2c163.html','_blank');},setRulesLabel:function(l){var d=0;if(l===null){return"Rules ("+d+")";}else{l.forEach(function(e,f){d+=e.rules.length;});return"Rules ("+d+")";}},updateShowButton:function(){this.getView().byId("sapSTShowButtonBar").setVisible(this.hidden);},toggleHide:function(){this.hidden=!this.hidden;this.updateShowButton();a.publish(c.TOGGLE_FRAME_HIDDEN,this.hidden);},persistExecutionScope:function(){var d={analyzeContext:this.model.getProperty("/analyzeContext"),subtreeExecutionContextId:this.model.getProperty("/subtreeExecutionContextId")},e=this.model.getProperty("/executionScopeComponents");s.setSelectedScopeComponents(e);s.setSelectedContext(d);},deletePersistedData:function(){s.deletePersistenceCookie(b.COOKIE_NAME);this.model.setProperty("/persistingSettings",false);s.removeAllData();},_clearProcessIndicator:function(){var p=this.getView().byId("progressIndicator");p.setDisplayValue("None");this.model.setProperty("/progress",0.1);},_setContextSettings:function(){var d=s.readPersistenceCookie(b.COOKIE_NAME);if(d){this.model.setProperty("/persistingSettings",true);var e=s.getSelectedContext();if(e){this.model.setProperty("/analyzeContext",e.analyzeContext);this.model.setProperty("/subtreeExecutionContextId",e.subtreeExecutionContextId);}else{this.model.setProperty("/analyzeContext",this.model.getProperty("/analyzeContext"));this.model.setProperty("/subtreeExecutionContextId","");}}}});});
