/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/support/library","sap/ui/support/supportRules/RuleSet","./TableHelper.support"],function(q,S,R,a){"use strict";var C=S.Categories,b=S.Severity;var l={name:"sap.ui.table",niceName:"UI5 Table library"};var r=new R(l);function c(o){o.id="GRIDTABLE_"+o.id;a.addRuleToRuleset(o,r);}c({id:"CONTENT_DENSITY",title:"Content Density Usage",description:"Checks whether the content densities 'Cozy', 'Compact' and 'Condensed' are used correctly.",resolution:"Ensure that either only the 'Cozy' or 'Compact' content density is used or the 'Condensed' and 'Compact' content densities in combination are used.",resolutionurls:[a.createDocuRef("How to use Content Densities","#docs/guide/e54f729da8e3405fae5e4fe8ae7784c1.html")],check:function(i,o,s){var d=q("html");var $=d.find(".sapUiSizeCozy");var e=d.find(".sapUiSizeCompact");var f=d.find(".sapUiSizeCondensed");function g(h,t,m){var F=false;h.each(function(){if(q(this).closest(t).length){F=true;}});if(F&&m){a.reportIssue(i,m,b.High);}return F;}g(e,".sapUiSizeCozy","'Compact' content density is used within 'Cozy' area.");g($,".sapUiSizeCompact","'Cozy' content density is used within 'Compact' area.");g(f,".sapUiSizeCozy","'Condensed' content density is used within 'Cozy' area.");g($,".sapUiSizeCondensed","'Cozy' content density is used within 'Condensed' area.");if(f.length>0){var F=g(f,".sapUiSizeCompact");if(!F){a.reportIssue(i,"'Condensed' content density must be used in combination with 'Compact'.",b.High);}}}});c({id:"VALIDATE_ACC_TITLE",categories:[C.Accessibility],title:"Accessible Label",description:"Checks whether 'sap.ui.table.Table' controls have an accessible label.",resolution:"Use the 'title' aggregation or the 'ariaLabelledBy' association of the 'sap.ui.table.Table' control to define a proper accessible labeling.",check:function(I,o,s){var t=a.find(s,true,"sap/ui/table/Table");for(var i=0;i<t.length;i++){if(!t[i].getTitle()&&t[i].getAriaLabelledBy().length==0){a.reportIssue(I,"Table '"+t[i].getId()+"' does not have an accessible label.",b.High,t[i].getId());}}}});return{lib:l,ruleset:r};},true);
