/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/model/type/Date','sap/ui/unified/calendar/CalendarUtils','./calendar/Header','./calendar/Month','./calendar/MonthPicker','./calendar/YearPicker','./calendar/CalendarDate','./library'],function(q,C,L,D,a,H,M,b,Y,c,l){"use strict";var d=C.extend("sap.ui.unified.Calendar",{metadata:{library:"sap.ui.unified",properties:{intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},months:{type:"int",group:"Appearance",defaultValue:1},firstDayOfWeek:{type:"int",group:"Appearance",defaultValue:-1},nonWorkingDays:{type:"int[]",group:"Appearance",defaultValue:null},primaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance",defaultValue:null},secondaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null},showWeekNumbers:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},disabledDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"disabledDate"},header:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},month:{type:"sap.ui.unified.calendar.Month",multiple:true,visibility:"hidden"},monthPicker:{type:"sap.ui.unified.calendar.MonthPicker",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},cancel:{},startDateChange:{}}}});d.prototype.init=function(){this._iBreakPointTablet=sap.ui.Device.media._predefinedRangeSets[sap.ui.Device.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0];this._iBreakPointDesktop=sap.ui.Device.media._predefinedRangeSets[sap.ui.Device.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1];this._iBreakPointLargeDesktop=sap.ui.Device.media._predefinedRangeSets[sap.ui.Device.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2];var i=sap.ui.getCore().getConfiguration().getCalendarType();this.setProperty("primaryCalendarType",i);this.setProperty("secondaryCalendarType",i);this._iMode=0;this._oYearFormat=sap.ui.core.format.DateFormat.getDateInstance({format:"y",calendarType:i});this.data("sap-ui-fastnavgroup","true",true);this._oMinDate=a._minDate(this.getPrimaryCalendarType());this._oMaxDate=a._maxDate(this.getPrimaryCalendarType());var A=new H(this.getId()+"--Head");A.attachEvent("pressPrevious",this._handlePrevious,this);A.attachEvent("pressNext",this._handleNext,this);A.attachEvent("pressButton1",p,this);A.attachEvent("pressButton2",r,this);this.setAggregation("header",A);var B=this._createMonth(this.getId()+"--Month0");B.attachEvent("focus",this._handleFocus,this);B.attachEvent("select",t,this);B.attachEvent("_renderMonth",s,this);B.attachEvent("_bindMousemove",u,this);B.attachEvent("_unbindMousemove",v,this);B._bNoThemeChange=true;this.addAggregation("month",B);var E=new b(this.getId()+"--MP");E.attachEvent("select",w,this);E._bNoThemeChange=true;this.setAggregation("monthPicker",E);var F=new Y(this.getId()+"--YP");F.attachEvent("select",x,this);this.setAggregation("yearPicker",F);this._resizeProxy=q.proxy(y,this);};d.prototype.exit=function(){if(this._sInvalidateMonth){q.sap.clearDelayedCall(this._sInvalidateMonth);}if(this._sResizeListener){sap.ui.core.ResizeHandler.deregister(this._sResizeListener);this._sResizeListener=undefined;}};d.prototype._createMonth=function(i){var A=new M(i,{width:"100%"});return A;};d.prototype.onBeforeRendering=function(){var A=this.getAggregation("month");var B;var E=A[0].getDate();var F=this._getFocusedDate();if(A.length>1&&E){B=c.fromLocalJSDate(E,this.getPrimaryCalendarType());}else if(A.length>1){B=z.call(this,this._getFocusedDate());}else{B=F;}for(var i=0;i<A.length;i++){E=new c(B);if(i>0){E.setDate(1);E.setMonth(E.getMonth()+i);}var G=E;if(F.getYear()===E.getYear()&&F.getMonth()===E.getMonth()){G=F;}A[i].displayDate(G.toLocalJSDate());A[i].setShowWeekNumbers(this.getShowWeekNumbers());}this._updateHeader(B);this._iSize=0;};d.prototype.onAfterRendering=function(E){k.call(this);if(o.call(this)>1||this._bInitMonth){E.size={width:this.getDomRef().offsetWidth};y.call(this,E,true);if(!this._sResizeListener){this._sResizeListener=sap.ui.core.ResizeHandler.register(this,this._resizeProxy);}this._bInitMonth=undefined;}};d.prototype.invalidate=function(O){if(!this._bDateRangeChanged&&(!O||!(O instanceof sap.ui.unified.DateRange))){C.prototype.invalidate.apply(this,arguments);}else if(this.getDomRef()&&this._iMode==0&&!this._sInvalidateMonth){this._sInvalidateMonth=q.sap.delayedCall(0,this,this._invalidateMonth,[O]);}};d.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("selectedDates");return R;};d.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("selectedDates");return i;};d.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("specialDates");return R;};d.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("specialDates");return i;};d.prototype.getSpecialDates=function(){var P=this.getParent();if(P&&P.getSpecialDates){return P.getSpecialDates();}else{return this.getAggregation("specialDates",[]);}};d.prototype.removeAllDisabledDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("disabledDates");return R;};d.prototype.destroyDisabledDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("disabledDates");return i;};d.prototype.setLocale=function(i){if(this._sLocale!=i){this._sLocale=i;this._oLocaleData=undefined;this.invalidate();}return this;};d.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};d.prototype._getFocusedDate=function(){if(!this._oFocusedDate){e.call(this);}return this._oFocusedDate;};d.prototype._setFocusedDate=function(i){a._checkCalendarDate(i);this._oFocusedDate=new c(i,this.getPrimaryCalendarType());};d.prototype.focusDate=function(i){n.call(this,i,false);return this;};d.prototype.displayDate=function(i){n.call(this,i,true);return this;};d.prototype.getStartDate=function(){var S;if(this.getDomRef()){var i=this.getAggregation("month");S=c.fromLocalJSDate(i[0].getDate(),this.getPrimaryCalendarType());}else{S=new c(this._getFocusedDate());}S.setDate(1);return S.toLocalJSDate();};d.prototype.setPopupMode=function(P){this._bPoupupMode=P;return this;};d.prototype.setMonths=function(A){this._bDateRangeChanged=undefined;this.setProperty("months",A,false);A=o.call(this);var B=this.getAggregation("month");var i=0;var E;if(B.length<A){for(i=B.length;i<A;i++){E=this._createMonth(this.getId()+"--Month"+i);E.attachEvent("focus",this._handleFocus,this);E.attachEvent("select",t,this);E.attachEvent("_renderMonth",s,this);E.attachEvent("_bindMousemove",u,this);E.attachEvent("_unbindMousemove",v,this);E._bNoThemeChange=true;this.addAggregation("month",E);}}else if(B.length>A){for(i=B.length;i>A;i--){E=this.removeAggregation("month",i-1);E.destroy();}if(A==1){this._bInitMonth=true;}}if(A>1&&B[0].getDate()){B[0].setProperty("date",null,true);}return this;};d.prototype.setPrimaryCalendarType=function(A){var B=this.getAggregation("month");var R=false;if(B.length>1){R=true;}this.setProperty("primaryCalendarType",A,!R);this._oYearFormat=sap.ui.core.format.DateFormat.getDateInstance({format:"y",calendarType:A});if(this._oFocusedDate){this._oFocusedDate=new c(this._oFocusedDate,A);}this._oMinDate=new c(this._oMinDate,A);this._oMaxDate=new c(this._oMaxDate,A);for(var i=0;i<B.length;i++){var E=B[i];E.setPrimaryCalendarType(A);}var F=this.getAggregation("monthPicker");F.setPrimaryCalendarType(A);var G=this.getAggregation("yearPicker");G.setPrimaryCalendarType(A);if(this.getDomRef()){this._updateHeader(this._oFocusedDate);if(this.iMode!=1&&F.getDomRef()){F.$().remove();}if(this.iMode!=2&&G.getDomRef()){G.$().remove();}}return this;};d.prototype.setSecondaryCalendarType=function(A){this._bSecondaryCalendarTypeSet=true;this.setProperty("secondaryCalendarType",A,true);this._oYearFormatSecondary=sap.ui.core.format.DateFormat.getDateInstance({format:"y",calendarType:A});var B=this.getAggregation("month");for(var i=0;i<B.length;i++){var E=B[i];E.setSecondaryCalendarType(A);}if(this.getDomRef()){this._updateHeader(this._getFocusedDate());this.$().toggleClass("sapUiCalSecType",!!this._getSecondaryCalendarType());}return this;};d.prototype._getSecondaryCalendarType=function(){var S;if(this._bSecondaryCalendarTypeSet){S=this.getSecondaryCalendarType();var P=this.getPrimaryCalendarType();if(S==P){S=undefined;}}return S;};d.prototype.setMinDate=function(i){if(q.sap.equal(i,this.getMinDate())){return this;}if(!i){this._oMinDate=a._minDate(this.getPrimaryCalendarType());}else{a._checkJSDateObject(i);this._oMinDate=c.fromLocalJSDate(i,this.getPrimaryCalendarType());var A=this._oMinDate.getYear();a._checkYearInValidRange(A);if(this._oMaxDate.isBefore(this._oMinDate)){q.sap.log.warning("minDate > maxDate -> maxDate set to end of the month",this);this._oMaxDate=c.fromLocalJSDate(i,this.getPrimaryCalendarType());this._oMaxDate.setDate(a._daysInMonth(this._oMaxDate));this.setProperty("maxDate",this._oMaxDate.toLocalJSDate(),true);}this._setMinMaxDateExtend(c.fromLocalJSDate(i,this.getPrimaryCalendarType()));}this.setProperty("minDate",i,false);var B=this.getAggregation("yearPicker");B._oMinDate.setYear(this._oMinDate.getYear());return this;};d.prototype.setMaxDate=function(i){if(q.sap.equal(i,this.getMaxDate())){return this;}if(!i){this._oMaxDate=a._maxDate(this.getPrimaryCalendarType());}else{a._checkJSDateObject(i);this._oMaxDate=c.fromLocalJSDate(i,this.getPrimaryCalendarType());var A=this._oMaxDate.getYear();a._checkYearInValidRange(A);if(this._oMinDate.isAfter(this._oMaxDate)){q.sap.log.warning("maxDate < minDate -> minDate set to begin of the month",this);this._oMinDate=c.fromLocalJSDate(i,this.getPrimaryCalendarType());this._oMinDate.setDate(1);this.setProperty("minDate",this._oMinDate.toLocalJSDate(),true);}this._setMinMaxDateExtend(c.fromLocalJSDate(i,this.getPrimaryCalendarType()));}this.setProperty("maxDate",i,false);var B=this.getAggregation("yearPicker");B._oMaxDate.setYear(this._oMaxDate.getYear());return this;};d.prototype._setMinMaxDateExtend=function(i){if(this._oFocusedDate){if(a._isOutside(this._oFocusedDate,this._oMinDate,this._oMaxDate)){q.sap.log.warning("focused date is not between [minDate - maxDate] -> refocus to the new max/min date: "+i.toString(),this);this.focusDate(i.toLocalJSDate());}}};d.prototype._getLocaleData=function(){if(!this._oLocaleData){var i=this.getLocale();var A=new sap.ui.core.Locale(i);this._oLocaleData=L.getInstance(A);}return this._oLocaleData;};d.prototype._getShowMonthHeader=function(){var i=o.call(this);if(i>2){return true;}else{return false;}};d.prototype.setWidth=function(W){this.setProperty("width",W,true);if(this.getDomRef()){W=this.getWidth();this.$().css("width",W);if(W){this.$().addClass("sapUiCalWidth");}else{this.$().removeClass("sapUiCalWidth");}}return this;};d.prototype.onclick=function(E){if(E.isMarked("delayedMouseEvent")){return;}if(E.target.id==this.getId()+"-cancel"){this.onsapescape(E);}};d.prototype.onmousedown=function(E){E.preventDefault();E.setMark("cancelAutoClose");};d.prototype.onsapescape=function(E){if(this._iMode==0){this.fireCancel();}this._closedPickers();};d.prototype.onsapshow=function(E){if(this._bPoupupMode){this._closedPickers();this.fireCancel();E.preventDefault();}};d.prototype.onsaphide=d.prototype.onsapshow;d.prototype.onsaptabnext=function(E){var A=this.getAggregation("header");if(q.sap.containsOrEquals(this.getDomRef("content"),E.target)){q.sap.focus(A.getDomRef("B1"));if(!this._bPoupupMode){var B=this.getAggregation("month");var F=this.getAggregation("monthPicker");var G=this.getAggregation("yearPicker");for(var i=0;i<B.length;i++){var I=B[i];q(I._oItemNavigation.getItemDomRefs()[I._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(F.getDomRef()){q(F._oItemNavigation.getItemDomRefs()[F._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(G.getDomRef()){q(G._oItemNavigation.getItemDomRefs()[G._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}E.preventDefault();}else if(E.target.id==A.getId()+"-B1"){q.sap.focus(A.getDomRef("B2"));E.preventDefault();}};d.prototype.onsaptabprevious=function(E){var A=this.getAggregation("header");if(q.sap.containsOrEquals(this.getDomRef("content"),E.target)){if(this._bPoupupMode){q.sap.focus(A.getDomRef("B2"));E.preventDefault();}}else if(E.target.id==A.getId()+"-B1"){var B=this.getAggregation("month");var F=this.getAggregation("monthPicker");var G=this.getAggregation("yearPicker");var I;switch(this._iMode){case 0:I=this._getFocusedDate();for(var i=0;i<B.length;i++){var J=B[i];var K=c.fromLocalJSDate(J.getDate(),this.getPrimaryCalendarType());if(I.isSame(K)){J._oItemNavigation.focusItem(J._oItemNavigation.getFocusedIndex());}else{q(J._oItemNavigation.getItemDomRefs()[J._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}break;case 1:F._oItemNavigation.focusItem(F._oItemNavigation.getFocusedIndex());break;case 2:G._oItemNavigation.focusItem(G._oItemNavigation.getFocusedIndex());break;}E.preventDefault();}else if(E.target.id==A.getId()+"-B2"){q.sap.focus(A.getDomRef("B1"));E.preventDefault();}};d.prototype.onfocusin=function(E){if(E.target.id==this.getId()+"-end"){var A=this.getAggregation("header");var B=this.getAggregation("month");var F=this.getAggregation("monthPicker");var G=this.getAggregation("yearPicker");q.sap.focus(A.getDomRef("B2"));if(!this._bPoupupMode){for(var i=0;i<B.length;i++){var I=B[i];q(I._oItemNavigation.getItemDomRefs()[I._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(F.getDomRef()){q(F._oItemNavigation.getItemDomRefs()[F._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(G.getDomRef()){q(G._oItemNavigation.getItemDomRefs()[G._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}this.$("end").attr("tabindex","-1");};d.prototype.onsapfocusleave=function(E){if(!E.relatedControlId||!q.sap.containsOrEquals(this.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())){this.$("end").attr("tabindex","0");if(!this._bPoupupMode){var A=this.getAggregation("month");var B=this.getAggregation("monthPicker");var F=this.getAggregation("yearPicker");switch(this._iMode){case 0:for(var i=0;i<A.length;i++){var G=A[i];q(G._oItemNavigation.getItemDomRefs()[G._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;case 1:q(B._oItemNavigation.getItemDomRefs()[B._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");break;case 2:q(F._oItemNavigation.getItemDomRefs()[F._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");break;}}}};d.prototype.getFocusDomRef=function(){var i=this.getAggregation("month");var A=i[0];return A._oItemNavigation.getItemDomRefs()[A._oItemNavigation.getFocusedIndex()];};d.prototype.onThemeChanged=function(){if(!this.getDomRef()){return;}this._bNamesLengthChecked=undefined;var A=this.getAggregation("monthPicker");f.call(this,true);A._bNoThemeChange=false;A.onThemeChanged(arguments);A._bNoThemeChange=true;this._bLongMonth=A._bLongMonth;g.call(this,true);var B=this.getAggregation("month");for(var i=0;i<B.length;i++){var E=B[i];E._bNoThemeChange=false;E.onThemeChanged(arguments);E._bNoThemeChange=true;}var F;if(B.length>1){F=c.fromLocalJSDate(B[0].getDate(),this.getPrimaryCalendarType());}else{F=this._getFocusedDate();}m.call(this,F);k.call(this);};d.prototype._updateHeader=function(i){m.call(this,i);this._togglePrevNext(i,true);};d.prototype._togglePrevNext=function(i,A){var B=this._oMaxDate.getYear();var E=this._oMinDate.getYear();var F=this._oMaxDate.getMonth();var G=this._oMinDate.getMonth();var I=this.getAggregation("header");var J=o.call(this);var K=new c(i,this.getPrimaryCalendarType());if(this._iMode==0&&J>1){K=z.call(this,i);K.setMonth(K.getMonth()+J-1);K.setDate(a._daysInMonth(K));}else{K.setDate(a._daysInMonth(K));}var N=K.getYear();var O=K.getMonth();if(N>B||(N==B&&(!A||O>=F))||(this._iMode==1&&this.getPickerPopup&&this.getPickerPopup())){I.setEnabledNext(false);}else{I.setEnabledNext(true);}if(this._iMode==0&&J>1){K.setMonth(K.getMonth()-J+1);K.setDate(1);}else{K.setDate(1);}N=K.getYear();O=K.getMonth();if(N<E||(N==E&&(!A||O<=G))||(this._iMode==1&&this.getPickerPopup&&this.getPickerPopup())){I.setEnabledPrevious(false);}else{I.setEnabledPrevious(true);}};d.prototype._togglePrevNexYearPicker=function(){var i=this.getAggregation("yearPicker");var A=i.getYears();var B=c.fromLocalJSDate(i.getFirstRenderedDate());B.setYear(B.getYear()+Math.floor(A/2));var E=this.getAggregation("header");var F=new c(this._oMaxDate,this.getPrimaryCalendarType());F.setYear(F.getYear()-Math.ceil(A/2));F.setMonth(11);F.setDate(31);var G=new c(this._oMinDate,this.getPrimaryCalendarType());G.setYear(G.getYear()+Math.floor(A/2)+1);G.setMonth(0);G.setDate(1);E.setEnabledNext(B.isSameOrBefore(F));E.setEnabledPrevious(B.isSameOrAfter(G));};d.prototype._handlePrevious=function(E){var F=this._getFocusedDate();var i=this.getAggregation("header");var A=this.getAggregation("yearPicker");var B=o.call(this);var G;var I;var N=false;switch(this._iMode){case 0:if(B>1){G=c.fromLocalJSDate(this.getAggregation("month")[0].getDate(),this.getPrimaryCalendarType());G.setDate(1);this._setFocusedDate(G);F=this._getFocusedDate();}else{F.setDate(1);}F.setDate(F.getDate()-1);_.call(this,N,true);break;case 1:F.setYear(F.getYear()-1);i.setTextButton2(this._oYearFormat.format(F.toUTCJSDate(),true));var S=this._getSecondaryCalendarType();if(S){I=new c(F,S);I.setMonth(0);I.setDate(1);i.setAdditionalTextButton2(this._oYearFormatSecondary.format(I.toUTCJSDate(),true));}else{i.setAdditionalTextButton2();}this._togglePrevNext(F);this._setDisabledMonths(F.getYear());break;case 2:A.previousPage();this._togglePrevNexYearPicker();break;}};d.prototype._handleNext=function(E){var F=this._getFocusedDate();var i=this.getAggregation("header");var A=this.getAggregation("yearPicker");var B=o.call(this);var G;var I;switch(this._iMode){case 0:if(B>1){G=c.fromLocalJSDate(this.getAggregation("month")[0].getDate(),this.getPrimaryCalendarType());this._setFocusedDate(G);F=this._getFocusedDate();}F.setDate(1);F.setMonth(F.getMonth()+B);_.call(this);break;case 1:F.setYear(F.getYear()+1);i.setTextButton2(this._oYearFormat.format(F.toUTCJSDate(),true));var S=this._getSecondaryCalendarType();if(S){I=new c(F,S);I.setMonth(0);I.setDate(1);i.setAdditionalTextButton2(this._oYearFormatSecondary.format(I.toUTCJSDate(),true));}else{i.setAdditionalTextButton2();}this._togglePrevNext(F);this._setDisabledMonths(F.getYear());break;case 2:A.nextPage();this._togglePrevNexYearPicker();break;}};d.prototype._getDisplayedMonths=function(A){var B=[];var E=A.getMonth();var F=o.call(this);if(F>1){for(var i=0;i<F;i++){B.push((E+i)%12);}}else{B.push(E);}return B;};d.prototype._getDisplayedSecondaryMonths=function(P,S){var i=this.getAggregation("month");var F=c.fromLocalJSDate(i[0].getDate(),P);F.setDate(1);F=new c(F,S);var A=F.getMonth();var B=c.fromLocalJSDate(i[i.length-1].getDate(),P);B.setDate(a._daysInMonth(B));B=new c(B,S);var E=B.getMonth();return{start:A,end:E};};d.prototype._closedPickers=function(){switch(this._iMode){case 0:break;case 1:g.call(this);break;case 2:j.call(this);break;}};d.prototype._setDisabledMonths=function(i,A){var B=0;var E=11;if(i==this._oMinDate.getYear()){B=this._oMinDate.getMonth();}if(i==this._oMaxDate.getYear()){E=this._oMaxDate.getMonth();}if(!A){A=this.getAggregation("monthPicker");}A.setMinMax(B,E);};d.prototype._handleFocus=function(E){var i=c.fromLocalJSDate(E.getParameter("date"),this.getPrimaryCalendarType());var O=E.getParameter("otherMonth");var R=E.getParameter("restoreOldDate");if(R){if(!q.sap.equal(this._getFocusedDate(),i)){_.call(this,false,false,true);}}else{this._focusDate(i,O);}};d.prototype._getVisibleDays=function(){var i=this.getAggregation("month")[0];return i._getVisibleDays(i._getDate(),false);};function _(N,I,A){var B=this._getFocusedDate();var E=this.getAggregation("month");var F=false;var G;var J;var K;var i=0;for(i=0;i<E.length;i++){G=E[i];if(G.checkDateFocusable(B.toLocalJSDate())){F=true;}if(F||E.length==1){if(!N){G.setDate(B.toLocalJSDate());}else{G.displayDate(B.toLocalJSDate());}break;}}if(!F){K=new c(B,this.getPrimaryCalendarType());if(E.length>1){K=z.call(this,K);for(i=0;i<E.length;i++){G=E[i];J=new c(K,this.getPrimaryCalendarType());J.setMonth(K.getMonth()+i);if(!N&&a._isSameMonthAndYear(J,B)){G.setDate(B.toLocalJSDate());}else{G.displayDate(J.toLocalJSDate());}}}this._updateHeader(K);if(!A){this.fireStartDateChange();}}}function e(){var S=this.getSelectedDates();var i=this.getPrimaryCalendarType();if(S&&S[0]&&S[0].getStartDate()){this._oFocusedDate=c.fromLocalJSDate(S[0].getStartDate(),i);}else{this._oFocusedDate=c.fromLocalJSDate(new Date(),i);}if(this._oFocusedDate.isBefore(this._oMinDate)){this._oFocusedDate=new c(this._oMinDate,i);}else if(this._oFocusedDate.isAfter(this._oMaxDate)){this._oFocusedDate=new c(this._oMaxDate,i);}}function f(N){if(this._iMode==2){j.call(this,true);}var A=this._getFocusedDate();var B=this.getAggregation("monthPicker");if(!this.getPickerPopup||!this.getPickerPopup()){if(B.getDomRef()){B.$().css("display","");}else{var R=sap.ui.getCore().createRenderManager();var $=this.$("content");R.renderControl(B);R.flush($[0],false,true);R.destroy();}}else{this._openPickerPopup(B);}this.$("contentOver").css("display","");if(!N){B.setMonth(A.getMonth());this._setDisabledMonths(A.getYear(),B);if(this._iMode==0){var E=this.getAggregation("month");for(var i=0;i<E.length;i++){var F=E[i];q(F._oItemNavigation.getItemDomRefs()[F._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}this._iMode=1;this._togglePrevNext(A,false);}function g(N){this._iMode=0;if(!this.getPickerPopup||!this.getPickerPopup()){var A=this.getAggregation("monthPicker");A.$().css("display","none");}else if(this._oPopup.isOpen()){this._oPopup.close();}this.$("contentOver").css("display","none");if(!N){_.call(this);if(o.call(this)>1){var B=this.getAggregation("month");for(var i=0;i<B.length;i++){var E=B[i];q(E._oItemNavigation.getItemDomRefs()[E._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}}this._togglePrevNext(this._getFocusedDate(),true);}function h(){if(this._iMode==1){g.call(this,true);}var A=this._getFocusedDate();var B=this.getAggregation("yearPicker");if(!this.getPickerPopup||!this.getPickerPopup()){if(B.getDomRef()){B.$().css("display","");}else{var R=sap.ui.getCore().createRenderManager();var $=this.$("content");R.renderControl(B);R.flush($[0],false,true);R.destroy();}}else{this._openPickerPopup(B);}this.$("contentOver").css("display","");B.setDate(A.toLocalJSDate());var E;if(o.call(this)==1){E=this.getAggregation("month")[0];var F=E.$("days").find(".sapUiCalItem");if(F.length==28){B.$().addClass("sapUiCalYearNoTop");}else{B.$().removeClass("sapUiCalYearNoTop");}}if(this._iMode==0){var G=this.getAggregation("month");for(var i=0;i<G.length;i++){E=G[i];q(E._oItemNavigation.getItemDomRefs()[E._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}this._togglePrevNexYearPicker();this._iMode=2;}function j(N){this._iMode=0;if(!this.getPickerPopup||!this.getPickerPopup()){var A=this.getAggregation("yearPicker");A.$().css("display","none");}else if(this._oPopup.isOpen()){this._oPopup.close();}this.$("contentOver").css("display","none");if(!N){_.call(this);if(o.call(this)>1){var B=this.getAggregation("month");for(var i=0;i<B.length;i++){var E=B[i];q(E._oItemNavigation.getItemDomRefs()[E._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}}this._togglePrevNext(this._getFocusedDate(),true);}function k(){if(!this._bNamesLengthChecked){f.call(this,true);g.call(this,true);var i=this.getAggregation("monthPicker");this._bLongMonth=i._bLongMonth;this._bNamesLengthChecked=true;if(!this._bLongMonth){var A=this.getAggregation("month");var B;if(A.length>1){B=c.fromLocalJSDate(A[0].getDate(),this.getPrimaryCalendarType());}else{B=this._getFocusedDate();}m.call(this,B);}}else if(o.call(this)>1){this._focusDate(this._getFocusedDate(),true,true);}}d.prototype._focusDate=function(i,O,N){var F;var A=false;var B=false;if(i.isBefore(this._oMinDate)){F=this._oMinDate;A=true;}else if(i.isAfter(this._oMaxDate)){F=this._oMaxDate;A=true;}else{F=i;}if(this._focusDateExtend){B=this._focusDateExtend(i,O,N);}var I=F.isBefore(this._getFocusedDate());this._setFocusedDate(F);if(A||O){_.call(this,false,I,N);}if(B){this.fireStartDateChange();}};d.prototype._invalidateMonth=function(O){this._sInvalidateMonth=undefined;var A=this.getAggregation("month");if(A){for(var i=0;i<A.length;i++){var B=A[i];B._bDateRangeChanged=true;B._bInvalidateSync=true;if(A.length>1){B._bNoFocus=true;}B.invalidate(O);B._bInvalidateSync=undefined;}if(A.length>1){this._focusDate(this._getFocusedDate(),true,true);}}this._bDateRangeChanged=undefined;};function m(i){var A=this.getAggregation("header");var B=this._getLocaleData();var E=[];var F=[];var G=[];var I;var S=false;var T;var P;var J=this.getPrimaryCalendarType();var K=this._getSecondaryCalendarType();if(this._bLongMonth||!this._bNamesLengthChecked){E=B.getMonthsStandAlone("wide",J);}else{S=true;E=B.getMonthsStandAlone("abbreviated",J);F=B.getMonthsStandAlone("wide",J);}if(K){G=B.getMonthsStandAlone("abbreviated",K);var N=this._getDisplayedSecondaryMonths(J,K);if(N.start==N.end){T=G[N.start];}else{P=B.getIntervalPattern();T=P.replace(/\{0\}/,G[N.start]).replace(/\{1\}/,G[N.end]);}}A.setAdditionalTextButton1(T);var O=this._getDisplayedMonths(i);if(O.length>1&&!this._bShowOneMonth){if(!P){P=B.getIntervalPattern();}T=P.replace(/\{0\}/,E[O[0]]).replace(/\{1\}/,E[O[O.length-1]]);if(S){I=P.replace(/\{0\}/,F[O[0]]).replace(/\{1\}/,F[O[O.length-1]]);}}else{T=E[O[0]];if(S){I=F[O[0]];}}A.setTextButton1(T);if(S){A.setAriaLabelButton1(I);}var Q=new c(i,J);Q.setDate(1);A.setTextButton2(this._oYearFormat.format(Q.toUTCJSDate(),true));if(K){Q=new c(Q,K);A.setAdditionalTextButton2(this._oYearFormatSecondary.format(Q.toUTCJSDate(),true));}else{A.setAdditionalTextButton2();}}function n(i,N){if(!i){return;}var A=c.fromLocalJSDate(i,this.getPrimaryCalendarType());if(this._oFocusedDate&&this._oFocusedDate.isSame(A)){return;}var B=A.getYear();a._checkYearInValidRange(B);if(a._isOutside(A,this._oMinDate,this._oMaxDate)){throw new Error("Date must not be in valid range (minDate and maxDate); "+this);}this._setFocusedDate(A);if(this.getDomRef()&&this._iMode==0){_.call(this,N,false,true);}}function o(){if(sap.ui.Device.system.phone){return 1;}else{return this.getMonths();}}function p(E){if(this._iMode!=1){f.call(this);}else{g.call(this);}}function r(E){if(this._iMode!=2){h.call(this);}else{j.call(this);}}function s(E){this.fireEvent("_renderMonth",{days:E.getParameter("days")});}function t(E){if(o.call(this)>1){var A=this.getAggregation("month");for(var i=0;i<A.length;i++){var B=A[i];if(B.getId()!=E.oSource.getId()){B._updateSelection();}}}this.fireSelect();}function u(E){if(o.call(this)>1){var A=this.getAggregation("month");for(var i=0;i<A.length;i++){var B=A[i];if(B.getId()!=E.oSource.getId()){B._bindMousemove();}}}}function v(E){if(o.call(this)>1){var A=this.getAggregation("month");for(var i=0;i<A.length;i++){var B=A[i];if(B.getId()!=E.oSource.getId()){B._unbindMousemove();}}}}function w(E){var F=new c(this._getFocusedDate(),this.getPrimaryCalendarType()),i=this.getAggregation("monthPicker"),A=i.getMonth();if(this._adjustFocusedDateUponMonthChange){this._adjustFocusedDateUponMonthChange(F,A);}else{F.setMonth(A);if(A!=F.getMonth()){F.setDate(0);}}this._focusDate(F,true);g.call(this);}function x(E){var F=new c(this._getFocusedDate(),this.getPrimaryCalendarType());var i=this.getAggregation("yearPicker");var A=c.fromLocalJSDate(i.getDate(),this.getPrimaryCalendarType());var B=i.getYear();var G;if(this._adjustFocusedDateUponYearChange){G=this._adjustFocusedDateUponYearChange(F,B);if(G){F=G;}}else{A.setMonth(F.getMonth());A.setDate(F.getDate());F=A;}this._focusDate(F,true);j.call(this);}function y(E){var W=E.size.width;if(W<=0){return;}var O=this._iSize;if(W<this._iBreakPointTablet){this._iSize=0;}else if(W<this._iBreakPointDesktop){this._iSize=1;}else if(W<this._iBreakPointLargeDesktop){this._iSize=2;}else{this._iSize=3;}var A=o.call(this);var B;if(O!=this._iSize||this._bInitMonth){switch(this._iSize){case 1:B=2;break;case 2:B=3;break;case 3:B=4;break;default:B=1;break;}if(A<B){B=A;}if(B>2&&A>B){var F=B;var U=0.0;var G=B;while(F>=2){var I=A%F;if(I==0){G=F;break;}else{var N=I/F;if(N>U){U=N;G=F;}}F--;}B=G;}var J;var K=this.getAggregation("month");if(B>1){J=100/B+"%";this.$("content").removeClass("sapUiCalContentSingle");}else{J="100%";this.$("content").addClass("sapUiCalContentSingle");}for(var i=0;i<K.length;i++){var P=K[i];P.setWidth(J);}}}function z(i){var F=new c(i,this.getPrimaryCalendarType());F.setDate(1);var A=o.call(this);if(A<=12){var B=i.getMonth();B=B-B%A;if(12%A>0&&B+A>11){B=12-A;}F.setMonth(B);}return F;}return d;},true);
