/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/core/IconPool","sap/ui/base/EventProvider","sap/m/Button","sap/m/library","sap/m/OverflowToolbarButton","sap/m/OverflowToolbarLayoutData","./SemanticConfiguration","./SemanticContainer"],function(q,I,E,B,m,O,a,S,b){"use strict";var c=m.ButtonType;var d=b.extend("sap.f.semantic.SemanticShareMenu",{constructor:function(C,p){b.call(this,C,p);this._aShareMenuActions=[];this._aCustomShareActions=[];this._setMode(d._Mode.initial);}});d._Mode={initial:"initial",menu:"menu"};d.prototype.addCustomAction=function(C){this._onControlAdded(C);this._callContainerAggregationMethod("insertButton",C,this._getCustomActionInsertIndex());this._aCustomShareActions.push(C);return this;};d.prototype.insertCustomAction=function(C,i){this._onControlAdded(C);this._callContainerAggregationMethod("insertButton",C,this._getCustomActionInsertIndex(i));this._aCustomShareActions.splice(i,0,C);return this;};d.prototype.getCustomActions=function(){return this._aCustomShareActions;};d.prototype.indexOfCustomAction=function(C){return this._aCustomShareActions.indexOf(C);};d.prototype.removeCustomAction=function(C){var r=this._callContainerAggregationMethod("removeButton",C);this._aCustomShareActions.splice(this._aCustomShareActions.indexOf(C),1);this._onControlRemoved();return r;};d.prototype.removeAllCustomActions=function(){var r=[];this._aCustomShareActions.forEach(function(C){var R=this._callContainerAggregationMethod("removeButton",C);if(R){r.push(C);}},this);this._aCustomShareActions=[];this._onControlRemoved();return r;};d.prototype.destroyCustomActions=function(){this.removeAllCustomActions(true).forEach(function(C){C.destroy();});return this;};d.prototype.addContent=function(s){var C=this._getControl(s);this._onControlAdded(C);this._aShareMenuActions.push(s);this._preProcessOverflowToolbarButton(C);this._callContainerAggregationMethod("insertButton",C,this._getSemanticActionInsertIndex(s));return this;};d.prototype.removeContent=function(s){var C=this._getControl(s);this._callContainerAggregationMethod("removeButton",C);this._aShareMenuActions.splice(this._aShareMenuActions.indexOf(s),1);this._postProcessOverflowToolbarButton(s);this._onControlRemoved();return this;};d.prototype.destroy=function(){this._oShareMenuBtn=null;this._aShareMenuActions=null;this._aCustomShareActions=null;return b.prototype.destroy.call(this);};d.prototype._getMode=function(){return this._mode;};d.prototype._setMode=function(M){if(this._getMode()===M){return this;}if(M===d._Mode.initial){if(this._getMode()){this._fireContentChanged(true);}this._mode=d._Mode.initial;return this;}if(M===d._Mode.menu){this._mode=d._Mode.menu;this._fireContentChanged(false);}return this;};d.prototype._fireContentChanged=function(e){E.prototype.fireEvent.call(this._getParent(),"_shareMenuContentChanged",{"bEmpty":e});};d.prototype._getShareMenuButton=function(){var C=this._getContainer();if(!this._oShareMenuBtn){this._oShareMenuBtn=new O(C.getId()+"-shareButton",{icon:I.getIconURI("action"),tooltip:sap.ui.getCore().getLibraryResourceBundle("sap.f").getText("SEMANTIC_CONTROL_ACTION_SHARE"),layoutData:new a({closeOverflowOnInteraction:false}),text:sap.ui.getCore().getLibraryResourceBundle("sap.f").getText("SEMANTIC_CONTROL_ACTION_SHARE"),type:c.Transparent,press:function(){C.openBy(this._oShareMenuBtn);}.bind(this)});this._oShareMenuBtn.addEventDelegate({onAfterRendering:function(){this._oShareMenuBtn.$().attr("aria-haspopup",true);}.bind(this)},this);}return this._oShareMenuBtn;};d.prototype._getCustomActionInsertIndex=function(i){var C=this._aCustomShareActions.length;if(i===undefined){return this._aShareMenuActions.length+C;}i=i>=C?C:i;i+=this._aShareMenuActions.length;return i;};d.prototype._getSemanticActionInsertIndex=function(s){this._aShareMenuActions.sort(this._sortControlByOrder.bind(this));return this._aShareMenuActions.indexOf(s);};d.prototype._onControlAdded=function(C){if(this._isInitialMode()){this._setMode(d._Mode.menu,C);}};d.prototype._onControlRemoved=function(){var A=this._aShareMenuActions.length,C=this._aCustomShareActions.length,e=(A+C)===0;if(this._isMenuMode()&&e){this._setMode(d._Mode.initial);}};d.prototype._preProcessOverflowToolbarButton=function(o){if(o instanceof O){o._bInOverflow=true;}};d.prototype._postProcessOverflowToolbarButton=function(o){if(o instanceof O){delete o._bInOverflow;}};d.prototype._isInitialMode=function(){return this._getMode()===d._Mode.initial;};d.prototype._isMenuMode=function(){return this._getMode()===d._Mode.menu;};return d;},false);
