/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/m/library","sap/m/ToolbarSeparator","sap/m/ToolbarSpacer","./SemanticConfiguration","./SemanticContainer"],function(q,m,T,a,S,b){"use strict";var B=m.ButtonType;var c=b.extend("sap.f.semantic.SemanticTitle",{constructor:function(C,p){b.call(this,C,p);this._iMainActionCount=0;this._aSemanticTextActions=[];this._aSemanticSimpleIconActions=[];this._aSemanticNavIconActions=[];this._aCustomTextActions=[];this._aCustomIconActions=[];this._insertSeparator();this._attachContainerWidthChange();}});c.mPlacementMethodMap={titleText:"TextContent",titleIcon:"IconContent",shareIcon:"ShareContent"};c.prototype.addContent=function(s,p){this["_insertSemantic"+c.mPlacementMethodMap[p]].call(this,s);return this;};c.prototype.removeContent=function(s,p){this["_removeSemantic"+c.mPlacementMethodMap[p]].call(this,s);return this;};c.prototype.destroy=function(){this._aSemanticSimpleIconActions=null;this._aSemanticTextActions=null;this._aCustomTextActions=null;this._aCustomIconActions=null;this._aSemanticNavIconActions=null;this._oSeparator=null;return b.prototype.destroy.call(this);};c.prototype.addCustomTextAction=function(C){C.setType(B.Transparent);this._callContainerAggregationMethod("insertAction",C,this._getCustomTextActionInsertIndex());this._aCustomTextActions.push(C);return this;};c.prototype.insertCustomTextAction=function(C,i){C.setType(B.Transparent);this._callContainerAggregationMethod("insertAction",C,this._getCustomTextActionInsertIndex(i));this._aCustomTextActions.splice(i,0,C);return this;};c.prototype.indexOfCustomTextAction=function(C){return this._aCustomTextActions.indexOf(C);};c.prototype.removeCustomTextAction=function(C){var i=this._aCustomTextActions.indexOf(C),r=this._callContainerAggregationMethod("removeAction",C);this._aCustomTextActions.splice(i,1);return r;};c.prototype.removeAllCustomTextActions=function(){var r=[];this._aCustomTextActions.forEach(function(C){var R=this._callContainerAggregationMethod("removeAction",C);if(R){r.push(C);}},this);this._aCustomTextActions=[];return r;};c.prototype.destroyCustomTextActions=function(){this.removeAllCustomTextActions().forEach(function(C){C.destroy();});return this;};c.prototype.getCustomTextActions=function(){return this._aCustomTextActions;};c.prototype.addCustomIconAction=function(C){C.setType(B.Transparent);this._callContainerAggregationMethod("insertAction",C,this._getCustomIconActionInsertIndex());this._aCustomIconActions.push(C);return this;};c.prototype.insertCustomIconAction=function(C,i){C.setType(B.Transparent);this._callContainerAggregationMethod("insertAction",C,this._getCustomIconActionInsertIndex(i));this._aCustomIconActions.splice(i,0,C);return this;};c.prototype.indexOfCustomIconAction=function(C){return this._aCustomIconActions.indexOf(C);};c.prototype.removeCustomIconAction=function(C){var i=this._aCustomIconActions.indexOf(C),r=this._callContainerAggregationMethod("removeAction",C);this._aCustomIconActions.splice(i,1);return r;};c.prototype.removeAllCustomIconActions=function(){var r=[];this._aCustomIconActions.forEach(function(C){var R=this._callContainerAggregationMethod("removeAction",C);if(R){r.push(C);}},this);this._aCustomIconActions=[];return r;};c.prototype.destroyCustomIconActions=function(){this.removeAllCustomIconActions().forEach(function(C){C.destroy();});return this;};c.prototype.getCustomIconActions=function(){return this._aCustomIconActions;};c.prototype._insertSemanticTextContent=function(s){var C=this._getControl(s),i=this._isMainAction(s),I;this._aSemanticTextActions.push(s);if(i){this._iMainActionCount++;I=this._getSemanticTextMainActionInsertIndex();}else{I=this._getSemanticTextActionInsertIndex(s);}this._callContainerAggregationMethod("insertAction",C,I);return this;};c.prototype._removeSemanticTextContent=function(s){var C=this._getControl(s),i=this._aSemanticTextActions.indexOf(s),I=this._isMainAction(s);if(I){this._iMainActionCount--;}this._aSemanticTextActions.splice(i,1);this._callContainerAggregationMethod("removeAction",C);return this;};c.prototype._insertSemanticIconContent=function(s){var C=this._getControl(s),i=0;if(this._isNavigationAction(s)){this._aSemanticNavIconActions.push(s);i=this._getSemanticNavIconActionInsertIndex(s);}else{this._aSemanticSimpleIconActions.push(s);i=this._getSemanticSimpleIconActionInsertIndex(s);}this._callContainerAggregationMethod("insertAction",C,i);return this;};c.prototype._removeSemanticIconContent=function(s){var C=this._getControl(s),i;if(this._isNavigationAction(s)){i=this._aSemanticNavIconActions.indexOf(s);this._aSemanticNavIconActions.splice(i,1);}else{i=this._aSemanticTextActions.indexOf(s);this._aSemanticSimpleIconActions.splice(i,1);}this._callContainerAggregationMethod("removeAction",C);return this;};c.prototype._insertSemanticShareContent=function(s){var C=this._getControl(s),i=this._getSemanticShareMenuInsertIndex();this._callContainerAggregationMethod("insertAction",C,i);return this;};c.prototype._removeSemanticShareContent=function(s){var C=this._getControl(s);this._callContainerAggregationMethod("removeAction",C);return this;};c.prototype._getSemanticTextMainActionInsertIndex=function(){return 0;};c.prototype._getCustomTextActionInsertIndex=function(i){var C=this._aCustomTextActions.length;if(i===undefined){return this._iMainActionCount+C;}i=i>=C?C:i;i+=this._iMainActionCount;return i;};c.prototype._getSemanticTextActionInsertIndex=function(s){this._aSemanticTextActions.sort(this._sortControlByOrder.bind(this));return this._getCustomTextActionInsertIndex()+this._aSemanticTextActions.indexOf(s)-this._iMainActionCount;};c.prototype._getCustomIconActionInsertIndex=function(i){var C=this._aCustomIconActions.length,p=this._aCustomTextActions.length+this._aSemanticTextActions.length;if(i===undefined){return p+C;}i=i>=C?C:i;i+=p;return i;};c.prototype._getSemanticSimpleIconActionInsertIndex=function(s){this._aSemanticSimpleIconActions.sort(this._sortControlByOrder.bind(this));return this._getCustomIconActionInsertIndex()+this._aSemanticSimpleIconActions.indexOf(s);};c.prototype._getSemanticNavIconActionInsertIndex=function(s){this._aSemanticNavIconActions.sort(this._sortControlByOrder.bind(this));return this._getSeparatorIndex()+this._aSemanticNavIconActions.indexOf(s)+1;};c.prototype._getSemanticShareMenuInsertIndex=function(){return this._getSeparatorIndex();};c.prototype._getSeparatorIndex=function(){return this._callContainerAggregationMethod("indexOfAction",this._oSeparator);};c.prototype._updateSeparatorVisibility=function(){var C=this._getContainerBar(),v;if(!C){return;}v=C._getVisibleAndNonOverflowContent();if(v.length>0){this._toggleSeparator(this._shouldSeparatorBeVisible(v));}};c.prototype._shouldSeparatorBeVisible=function(v){var f=v[0],l=v[v.length-1];return!(f instanceof T||l instanceof T);};c.prototype._toggleSeparator=function(s){var $=this._getSeparator().$();if($.length>0){$.toggleClass("sapUiHidden",!s);}};c.prototype._insertSeparator=function(){this._callContainerAggregationMethod("addAction",this._getSeparator());return this;};c.prototype._getSeparator=function(){if(!this._oSeparator){this._oSeparator=new T();this._oSeparator.addStyleClass("sapUiHidden");}return this._oSeparator;};c.prototype._attachContainerWidthChange=function(){var C=this._getContainerBar();if(C){C.attachEvent("_controlWidthChanged",this._onContainerWidthChanged,this);}};c.prototype._onContainerWidthChanged=function(){q.sap.delayedCall(0,this,this._updateSeparatorVisibility);};c.prototype._getContainerBar=function(){var C=this._getContainer();if(C){return C.getAggregation("_overflowToolbar");}return null;};return c;},false);
