/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/model/type/Date','sap/ui/model/odata/type/ODataType','./InputBase'],function(q,S,O,I){"use strict";var D=I.extend("sap.m.DateTimeField",{metadata:{"abstract":true,library:"sap.m",properties:{displayFormat:{type:"string",group:"Appearance",defaultValue:null},valueFormat:{type:"string",group:"Data",defaultValue:null},dateValue:{type:"object",group:"Data",defaultValue:null}}}});D.prototype.setValue=function(v){v=this.validateProperty("value",v);var o=this.getValue();if(v===o){return this;}else{this._lastValue=v;}this.setProperty("value",v,true);this._bValid=true;var d;if(v){d=this._parseValue(v);if(!d||d.getTime()<this._oMinDate.getTime()||d.getTime()>this._oMaxDate.getTime()){this._bValid=false;q.sap.log.warning("Value can not be converted to a valid date",this);this._oWantedDate=d;}}if(this._bValid){this.setProperty("dateValue",d,true);this._oWantedDate=undefined;}if(this.getDomRef()){var s;if(d){s=this._formatValue(d);}else{s=v;}if(this._$input.val()!==s){this._$input.val(s);this._curpos=this._$input.cursorPos();}}return this;};D.prototype.setDateValue=function(d){if(d&&!(d instanceof Date)){throw new Error("Date must be a JavaScript date object; "+this);}if(q.sap.equal(this.getDateValue(),d)){return this;}d=this._dateValidation(d);var v=this._formatValue(d,true);if(v!==this.getValue()){this._lastValue=v;}this.setProperty("value",v,true);if(this.getDomRef()){var o=this._formatValue(d);if(this._$input.val()!==o){this._$input.val(o);this._setLabelVisibility();this._curpos=this._$input.cursorPos();}}return this;};D.prototype.setValueFormat=function(v){this.setProperty("valueFormat",v,true);var V=this.getValue();if(V){this._handleDateValidation(this._parseValue(V));}return this;};D.prototype.setDisplayFormat=function(d){this.setProperty("displayFormat",d,true);this.updateDomValue(this._formatValue(this.getDateValue()));return this;};D.prototype.getDisplayFormatType=function(){return null;};D.prototype._dateValidation=function(d){this._bValid=true;this.setProperty("dateValue",d,true);return d;};D.prototype._handleDateValidation=function(d){this._bValid=true;this.setProperty("dateValue",d,true);};D.prototype._getPlaceholder=function(){var p=this.getPlaceholder();if(!p){p=this._getDisplayFormatPattern();if(!p){p=this._getDefaultDisplayStyle();}if(this._checkStyle(p)){var l=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();var L=sap.ui.core.LocaleData.getInstance(l);p=this._getPlaceholderPattern(L,p);}}return p;};D.prototype._getPlaceholderPattern=function(l,p){return l.getDatePattern(p);};D.prototype._parseValue=function(v,d){return this._getFormatter(d).parse(v);};D.prototype._formatValue=function(d,v){if(d){return this._getFormatter(!v).format(d);}return"";};D.prototype._getDefaultDisplayStyle=function(){return"medium";};D.prototype._getDefaultValueStyle=function(){return"short";};D.prototype._getFormatter=function(d){var p=this._getBoundValueTypePattern(),r=false,f,b=this.getBinding("value"),c;if(b&&b.oType&&b.oType.oOutputFormat){r=!!b.oType.oOutputFormat.oFormatOptions.relative;c=b.oType.oOutputFormat.oFormatOptions.calendarType;}if(!p){if(d){p=(this.getDisplayFormat()||this._getDefaultDisplayStyle());c=this.getDisplayFormatType();}else{p=(this.getValueFormat()||this._getDefaultValueStyle());c=sap.ui.core.CalendarType.Gregorian;}}if(!c){c=sap.ui.getCore().getConfiguration().getCalendarType();}if(d){if(p===this._sUsedDisplayPattern&&c===this._sUsedDisplayCalendarType){f=this._oDisplayFormat;}}else{if(p===this._sUsedValuePattern&&c===this._sUsedValueCalendarType){f=this._oValueFormat;}}if(f){return f;}return this._getFormatterInstance(f,p,r,c,d);};D.prototype._getFormatterInstance=function(f,p,r,c,d){if(this._checkStyle(p)){f=this._getFormatInstance({style:p,strictParsing:true,relative:r,calendarType:c},d);}else{f=this._getFormatInstance({pattern:p,strictParsing:true,relative:r,calendarType:c},d);}if(d){this._sUsedDisplayPattern=p;this._sUsedDisplayCalendarType=c;this._oDisplayFormat=f;}else{this._sUsedValuePattern=p;this._sUsedValueCalendarType=c;this._oValueFormat=f;}return f;};D.prototype._getFormatInstance=function(a,d){return sap.ui.core.format.DateFormat.getInstance(a);};D.prototype._checkStyle=function(p){return(p==="short"||p==="medium"||p==="long"||p==="full");};D.prototype._getDisplayFormatPattern=function(){return this._getBoundValueTypePattern()||this.getDisplayFormat();};D.prototype._getBoundValueTypePattern=function(){var b=this.getBinding("value"),B=b&&b.getType&&b.getType();if(B instanceof S){return B.getOutputPattern();}if(B instanceof O&&B.oFormat){return B.oFormat.oFormatOptions.pattern;}return undefined;};return D;},true);
