/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','./NotificationListBase','sap/ui/core/InvisibleText','./ListItemBase'],function(q,l,C,N,I,L){'use strict';var a=N.extend('sap.m.NotificationListGroup',{metadata:{library:'sap.m',properties:{collapsed:{type:'boolean',group:'Behavior',defaultValue:false},autoPriority:{type:'boolean',group:'Behavior',defaultValue:true},showEmptyGroup:{type:'boolean',group:'Behavior',defaultValue:false},enableCollapseButtonWhenEmpty:{type:'boolean',group:'Behavior',defaultValue:false}},defaultAggregation:'items',aggregations:{items:{type:'sap.m.NotificationListItem',multiple:true,singularName:'item'},_ariaDetailsText:{type:'sap.ui.core.InvisibleText',multiple:false,visibility:'hidden'}},events:{onCollapse:{parameters:{collapsed:{type:'boolean'}}}}}});a.prototype.init=function(){sap.m.NotificationListBase.prototype.init.call(this);var r=sap.ui.getCore().getLibraryResourceBundle('sap.m');this._closeText=r.getText('NOTIFICATION_LIST_BASE_CLOSE');var _=new sap.m.Button(this.getId()+'-closeButton',{type:sap.m.ButtonType.Transparent,icon:sap.ui.core.IconPool.getIconURI('decline'),tooltip:this._closeText,press:function(){this.close();}.bind(this)});this.setAggregation('_closeButton',_,true);var b=new sap.m.Button({type:sap.m.ButtonType.Transparent,press:function(){this.setCollapsed(!this.getCollapsed());}.bind(this)});this.setAggregation('_collapseButton',b,true);this._maxNumberReached=false;this._ariaLabbeledByIds='';this.setAggregation('_ariaDetailsText',new I());this._resourceBundle=sap.ui.getCore().getLibraryResourceBundle('sap.m');};a.prototype.setCollapsed=function(b){this._toggleCollapsed();this.setProperty('collapsed',b,true);this.fireOnCollapse({collapsed:b});return this;};a.prototype.getPriority=function(){if(!this.getAutoPriority()){return this.getProperty('priority');}var n=this.getAggregation('items');var p=sap.ui.core.Priority.None;if(n){n.forEach(function(i){p=c(p,i.getPriority());});}else{p=this.getProperty('priority');}return p;};a.prototype.getUnread=function(){var n=this.getItems();if(n.length){return n.some(function(i){return i.getUnread();});}return this.getProperty('unread');};a.prototype.onBeforeRendering=function(){var n=this.getItems();var b=n.length;var d=this.getAggregation('_collapseButton');this._maxNumberOfNotifications=sap.ui.Device.system.desktop?400:100;d.setEnabled(this._getCollapseButtonEnabled(),true);this._maxNumberReached=b>this._maxNumberOfNotifications;n.forEach(function(i){i.addEventDelegate({onfocusin:this._notificationFocusHandler},this);i.addEventDelegate({onkeydown:this._notificationNavigationHandler},this);}.bind(this));this._updateAccessibilityInfo();this._updateCollapseButtonText(this.getCollapsed());this._maxNumberOfNotificationsTitle=this._resourceBundle.getText('NOTIFICATION_LIST_GROUP_MAX_NOTIFICATIONS_TITLE',b-this._maxNumberOfNotifications);this._maxNumberOfNotificationsBody=this._resourceBundle.getText('NOTIFICATION_LIST_GROUP_MAX_NOTIFICATIONS_BODY');};a.prototype.clone=function(){return N.prototype.clone.apply(this,arguments);};a.prototype._getHeaderTitle=function(){var t=sap.m.NotificationListBase.prototype._getHeaderTitle.call(this);t.addStyleClass('sapMNLG-Title');if(this.getUnread()){t.addStyleClass('sapMNLGTitleUnread');}return t;};a.prototype._getDateTimeText=function(){var d=sap.m.NotificationListBase.prototype._getDateTimeText.call(this);d.setTextAlign('End');return d;};a.prototype._toggleCollapsed=function(){var n=!this.getCollapsed();this._updateCollapseButtonText(n);this.$().toggleClass('sapMNLG-Collapsed',n);this.$().toggleClass('sapMNLG-NoNotifications',this._getVisibleItemsCount()<=0);};a.prototype._getVisibleItemsCount=function(){var i=this.getItems();var r=0;i.forEach(function(b){if(b.getVisible()){r+=1;}});return r;};a.prototype._getCollapseButtonEnabled=function(){if(this._getVisibleItemsCount()>0){return true;}return this.getEnableCollapseButtonWhenEmpty();};a.prototype._notificationFocusHandler=function(e){L.prototype.onfocusin.call(this,e);var t=e.srcControl;if(t.getMetadata().getName()!='sap.m.NotificationListItem'){return;}var n=t.getParent();var g=n.indexOfItem(t);var b=t.getDomRef();b.setAttribute('aria-posinset',g+1);b.setAttribute('aria-setsize',n.getItems().length);};a.prototype._notificationNavigationHandler=function(e){L.prototype.onkeydown.call(this,e);var t=e.srcControl;if(t.getMetadata().getName()!='sap.m.NotificationListItem'){return;}var n=t.getParent();var g=n.indexOfItem(t);switch(e.which){case q.sap.KeyCodes.ARROW_UP:if(g==0){return;}var p=g-1;n.getItems()[p].focus();break;case q.sap.KeyCodes.ARROW_DOWN:var b=g+1;if(b==n.getItems().length){return;}n.getItems()[b].focus();break;default:return;}};a.prototype._updateAccessibilityInfo=function(){var b=this.getAuthorName();var i=this._resourceBundle.getText('NOTIFICATION_LIST_ITEM_DATETIME_PRIORITY',[this.getDatetime(),this.getPriority()]);var u=this.getUnread()?this._resourceBundle.getText('NOTIFICATION_LIST_GROUP_UNREAD'):this._resourceBundle.getText('NOTIFICATION_LIST_GROUP_READ');var d='';var e=this.getAggregation('_ariaDetailsText');if(b){d+=this._resourceBundle.getText('NOTIFICATION_LIST_ITEM_CREATED_BY')+' '+b+' ';}d+=i+' '+u;e.setText(d);this._ariaLabbeledByIds=this._getHeaderTitle().getId()+' '+e.getId();};a.prototype._updateCollapseButtonText=function(b){var d=b?this._resourceBundle.getText('NOTIFICATION_LIST_GROUP_EXPAND'):this._resourceBundle.getText('NOTIFICATION_LIST_GROUP_COLLAPSE');this.getAggregation('_collapseButton').setText(d,true);};function c(f,s){if(f==s){return f;}if((f=='None')){return s;}if((f=='Low')&&(s!='None')){return s;}if((f=='Medium')&&(s!='None'&&s!='Low')){return s;}return f;}return a;},true);
