/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/IconPool','sap/m/Image'],function(q,l,C,I,a){"use strict";var N=C.extend("sap.m.NumericContent",{metadata:{library:"sap.m",properties:{"animateTextChange":{type:"boolean",group:"Behavior",defaultValue:true},"formatterValue":{type:"boolean",group:"Data",defaultValue:false},"icon":{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},"iconDescription":{type:"string",group:"Accessibility",defaultValue:null},"indicator":{type:"sap.m.DeviationIndicator",group:"Appearance",defaultValue:"None"},"nullifyValue":{type:"boolean",group:"Behavior",defaultValue:true},"scale":{type:"string",group:"Appearance",defaultValue:null},"size":{type:"sap.m.Size",group:"Appearance",defaultValue:"Auto"},"truncateValueTo":{type:"int",group:"Appearance",defaultValue:4},"value":{type:"string",group:"Data",defaultValue:null},"valueColor":{type:"sap.m.ValueColor",group:"Appearance",defaultValue:"Neutral"},"width":{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},"withMargin":{type:"boolean",group:"Appearance",defaultValue:true},"state":{type:"sap.m.LoadState",group:"Behavior",defaultValue:"Loaded"}},events:{"press":{}}}});N.prototype.init=function(){this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this.setTooltip("{AltText}");};N.prototype.onBeforeRendering=function(){this.$().unbind("mouseenter",this._addTooltip);this.$().unbind("mouseleave",this._removeTooltip);};N.prototype.onAfterRendering=function(){this.$().bind("mouseenter",this._addTooltip.bind(this));this.$().bind("mouseleave",this._removeTooltip.bind(this));if(l.LoadState.Loaded==this.getState()||this.getAnimateTextChange()){q.sap.byId(this.getId()).animate({opacity:"1"},1000);}};N.prototype._addTooltip=function(){this.$().attr("title",this.getTooltip_AsString());};N.prototype._removeTooltip=function(){this.$().attr("title",null);};N.prototype.exit=function(){if(this._oIcon){this._oIcon.destroy();}};N.prototype.getAltText=function(){var v=this.getValue();var s=this.getScale();var e;var m=this._rb.getText(("SEMANTIC_COLOR_"+this.getValueColor()).toUpperCase());var A="";if(this.getNullifyValue()){e="0";}else{e="";}if(this.getIconDescription()){A=A.concat(this.getIconDescription());A=A.concat("\n");}if(v){A=A.concat(v+s);}else{A=A.concat(e);}A=A.concat("\n");if(this.getIndicator()&&this.getIndicator()!==l.DeviationIndicator.None){A=A.concat(this._rb.getText(("NUMERICCONTENT_DEVIATION_"+this.getIndicator()).toUpperCase()));A=A.concat("\n");}A=A.concat(m);return A;};N.prototype.getTooltip_AsString=function(){var t=this.getTooltip();var T=this.getAltText();if(typeof t==="string"||t instanceof String){T=t.split("{AltText}").join(T).split("((AltText))").join(T);return T;}if(t){return t;}else{return"";}};N.prototype.setIcon=function(u){var v=!q.sap.equal(this.getIcon(),u);if(v){if(this._oIcon){this._oIcon.destroy();this._oIcon=undefined;}if(u){this._oIcon=I.createControlByURI({id:this.getId()+"-icon-image",src:u},a);}}this._setPointerOnIcon();return this.setProperty("icon",u);};N.prototype._setPointerOnIcon=function(){if(this._oIcon&&this.hasListeners("press")){this._oIcon.addStyleClass("sapMPointer");}else if(this._oIcon&&this._oIcon.hasStyleClass("sapMPointer")){this._oIcon.removeStyleClass("sapMPointer");}};N.prototype.ontap=function(e){this.$().focus();this.firePress();e.preventDefault();};N.prototype.onkeyup=function(e){if(e.which===q.sap.KeyCodes.ENTER||e.which===q.sap.KeyCodes.SPACE){this.firePress();e.preventDefault();}};N.prototype.onkeydown=function(e){if(e.which===q.sap.KeyCodes.SPACE){e.preventDefault();}};N.prototype.attachEvent=function(e,d,f,b){C.prototype.attachEvent.call(this,e,d,f,b);if(this.hasListeners("press")){this.$().attr("tabindex",0).addClass("sapMPointer");this._setPointerOnIcon();}return this;};N.prototype.detachEvent=function(e,f,b){C.prototype.detachEvent.call(this,e,f,b);if(!this.hasListeners("press")){this.$().removeAttr("tabindex").removeClass("sapMPointer");this._setPointerOnIcon();}return this;};N.prototype._parseFormattedValue=function(v){var t=v.replace(String.fromCharCode(8206),"").replace(String.fromCharCode(8207),"");return{scale:t.replace(/[+-., \d]*(.*)$/g,"$1").trim().replace(/\.$/,""),value:t.replace(/([+-., \d]*).*$/g,"$1").trim()};};return N;});
