/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/core/IconPool','sap/ui/core/delegate/ItemNavigation','sap/ui/base/ManagedObject','sap/ui/core/delegate/ScrollEnablement','sap/ui/core/InvisibleText','./AccButton','./TabStripItem','sap/m/Select','sap/m/SelectList','sap/ui/Device','sap/ui/core/Renderer'],function(q,C,I,a,M,S,b,A,T,c,d,D,R){"use strict";var e=C.extend("sap.m.TabStrip",{metadata:{library:"sap.m",properties:{hasSelect:{type:"boolean",group:"Misc",defaultValue:false}},aggregations:{items:{type:"sap.m.TabStripItem",multiple:true,singularName:"item"},addButton:{type:"sap.m.Button",multiple:false,singularName:"addButton"},_select:{type:'sap.m.Select',multiple:false,visibility:"hidden"},_rightArrowButton:{type:'sap.m.AccButton',multiple:false,visibility:"hidden"},_leftArrowButton:{type:'sap.m.AccButton',multiple:false,visibility:"hidden"}},associations:{selectedItem:{type:'sap.m.TabStripItem',group:"Misc"}},events:{itemClose:{allowPreventDefault:true,parameters:{item:{type:"sap.m.TabStripItem"}}},itemPress:{parameters:{item:{type:"sap.m.TabStripItem"}}},itemSelect:{allowPreventDefault:true,parameters:{item:{type:"sap.m.TabContainerItem"}}}}},constructor:function(v,s){var H=false;if(!s&&typeof v==='object'){s=v;}if(s){H=s['hasSelect'];delete s['hasSelect'];}sap.ui.base.ManagedObject.prototype.constructor.apply(this,arguments);this.setProperty('hasSelect',H,true);}});var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");e.ICON_BUTTONS={LeftArrowButton:"slim-arrow-left",RightArrowButton:"slim-arrow-right",DownArrowButton:"slim-arrow-down",AddButton:"add"};e.SELECT_ITEMS_ID_SUFFIX='-SelectItem';e.SCROLL_SIZE=320;e.MIN_DRAG_OFFSET=sap.ui.Device.support.touch?15:5;e.SCROLL_ANIMATION_DURATION=sap.ui.getCore().getConfiguration().getAnimation()?500:0;e.ARIA_STATIC_TEXTS={closable:new b({text:r.getText("TABSTRIP_ITEM_CLOSABLE")}).toStatic(),modified:new b({text:r.getText("TABSTRIP_ITEM_MODIFIED")}).toStatic(),notModified:new b({text:r.getText("TABSTRIP_ITEM_NOT_MODIFIED")}).toStatic()};e.prototype.init=function(){this._bDoScroll=!sap.ui.Device.system.phone;this._bRtl=sap.ui.getCore().getConfiguration().getRTL();this._iCurrentScrollLeft=0;this._iMaxOffsetLeft=null;this._scrollable=null;this._oTouchStartX=null;if(!sap.ui.Device.system.phone){this._oScroller=new S(this,this.getId()+"-tabs",{horizontal:true,vertical:false,nonTouchScrolling:true});}};e.prototype.exit=function(){this._bRtl=null;this._iCurrentScrollLeft=null;this._iMaxOffsetLeft=null;this._scrollable=null;this._oTouchStartX=null;if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this._sResizeListenerId){sap.ui.core.ResizeHandler.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}this._removeItemNavigation();};e.prototype.onBeforeRendering=function(){if(this._sResizeListenerId){sap.ui.core.ResizeHandler.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}};e.prototype.onAfterRendering=function(){if(this._oScroller){this._oScroller.setIconTabBar(this,q.proxy(this._handleOverflowButtons,this),null);}this._addItemNavigation();if(!sap.ui.Device.system.phone){this._adjustScrolling();this._sResizeListenerId=sap.ui.core.ResizeHandler.register(this.getDomRef(),q.proxy(this._adjustScrolling,this));}};e.prototype.getFocusDomRef=function(){var t=sap.ui.getCore().byId(this.getSelectedItem());if(!t){return null;}return t.getDomRef();};e.prototype.applyFocusInfo=function(F){if(F.focusDomRef){q(F.focusDomRef).focus();}};e.prototype._addItemNavigation=function(){var H=this.getDomRef("tabsContainer"),j=this.getItems(),t=[];j.forEach(function(o){var k=o.getDomRef();q(k).attr("tabindex","-1");t.push(k);});if(!this._oItemNavigation){this._oItemNavigation=new a();}this._oItemNavigation.setRootDomRef(H);this._oItemNavigation.setItemDomRefs(t);this._oItemNavigation.setCycling(false);this._oItemNavigation.setPageSize(5);this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"]});this.addDelegate(this._oItemNavigation);};e.prototype._checkScrolling=function(){var t=this.getDomRef("tabs"),s=t&&(t.scrollWidth>this.getDomRef("tabsContainer").offsetWidth);this.$().toggleClass("sapMTSScrollable",s);return s;};e.prototype._handleOverflowButtons=function(){var t=this.getDomRef("tabs"),o=this.getDomRef("tabsContainer"),s,j,k,l=false,m=false,n=this._checkScrolling();if(n&&!this.getAggregation("_rightArrowButton")&&!this.getAggregation("_leftArrowButton")){this._getLeftArrowButton();this._getRightArrowButton();var p=sap.ui.getCore().createRenderManager();this.getRenderer().renderRightOverflowButtons(p,this,true);this.getRenderer().renderLeftOverflowButtons(p,this,true);p.destroy();}if(n&&t&&o){if(this._bRtl&&D.browser.firefox){s=-o.scrollLeft;}else{s=o.scrollLeft;}j=t.scrollWidth;k=o.clientWidth;if(Math.abs(j-k)===1){j=k;}if(s>0){if(this._bRtl&&D.browser.webkit){m=true;}else{l=true;}}if((j>k)&&(s+k<j)){if(this._bRtl&&D.browser.webkit){l=true;}else{m=true;}}this.$().toggleClass("sapMTSScrollBack",l).toggleClass("sapMTSScrollForward",m);}else{this.$().toggleClass("sapMTSScrollBack",false).toggleClass("sapMTSScrollForward",false);}};e.prototype._adjustScrolling=function(){this._iMaxOffsetLeft=Math.abs(this.$("tabsContainer").width()-this.$("tabs").width());this._handleOverflowButtons();};e.prototype._getLeftArrowButton=function(){return this._getArrowButton("_leftArrowButton",r.getText("TABSTRIP_SCROLL_BACK"),e.ICON_BUTTONS.LeftArrowButton,-e.SCROLL_SIZE);};e.prototype._getRightArrowButton=function(){return this._getArrowButton("_rightArrowButton",r.getText("TABSTRIP_SCROLL_FORWARD"),e.ICON_BUTTONS.RightArrowButton,e.SCROLL_SIZE);};e.prototype._getArrowButton=function(B,t,s,j){var o=this.getAggregation(B),k=this;if(!o){o=new A({type:sap.m.ButtonType.Transparent,icon:I.getIconURI(s),tooltip:t,tabIndex:"-1",ariaHidden:"true",press:function(E){k._scroll(j,e.SCROLL_ANIMATION_DURATION);}});this.setAggregation(B,o,true);}return o;};e.prototype._removeItemNavigation=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}};e.prototype._scroll=function(j,k){var s=this.getDomRef("tabsContainer").scrollLeft,l=D.browser.internet_explorer||D.browser.edge,m;if(this._bRtl&&!l){m=s-j;if(D.browser.firefox){if(m<-this._iMaxOffsetLeft){m=-this._iMaxOffsetLeft;}if(m>0){m=0;}}}else{m=s+j;if(m<0){m=0;}if(m>this._iMaxOffsetLeft){m=this._iMaxOffsetLeft;}}this._oScroller.scrollTo(m,0,k);this._iCurrentScrollLeft=m;};e.prototype._scrollIntoView=function(o,j){var $=this.$("tabs"),k=o.$(),t=$.innerWidth()-$.width(),l=k.outerWidth(true),m=k.position().left-t/2,n=this.getDomRef("tabsContainer"),s=n.scrollLeft,p=this.$("tabsContainer").width(),N=s;if(m<0||m>p-l){if(this._bRtl&&D.browser.firefox){if(m<0){N+=m+l-p;}else{N+=m;}}else{if(m<0){N+=m;}else{N+=m+l-p;}}this._iCurrentScrollLeft=N;this._oScroller.scrollTo(N,0,j);}};e.prototype._createSelect=function(t){var s,o,j,k={type:D.system.phone?sap.m.SelectType.Default:sap.m.SelectType.IconOnly,autoAdjustWidth:true,maxWidth:D.system.phone?"100%":"2.5rem",icon:I.getIconURI(e.ICON_BUTTONS.DownArrowButton),tooltip:r.getText("TABSTRIP_OPENED_TABS"),change:function(E){o=E.getParameters()['selectedItem'];j=this._findTabStripItemFromSelectItem(o);this._activateItem(j,E);}.bind(this)};s=new g(k).addStyleClass("sapMTSOverflowSelect");this._addItemsToSelect(s,t);return s;};e.prototype.onsapselect=function(E){E.setMarked();E.preventDefault();this._activateItem(E.srcControl,E);};e.prototype.onsapdelete=function(E){var o=q("#"+E.target.id).control(0),s=o.getId()===this.getSelectedItem(),j=function(){this._moveToNextItem(s);};this._removeItem(o,j);};e.prototype._moveToNextItem=function(s){if(!this._oItemNavigation){return;}var j=this.getItems().length,k=this._oItemNavigation.getFocusedIndex(),n=j===k?--k:k,N=this.getItems()[n],F=function(){if(this._oItemNavigation){this._oItemNavigation.focusItem(n);}};if(s){this.setSelectedItem(N);this.fireItemPress({item:N});}q.sap.delayedCall(0,this,F);};e.prototype._activateItem=function(o,E){if(this.fireItemSelect({item:o})){if(o&&o instanceof sap.m.TabStripItem){if(!this.getSelectedItem()||this.getSelectedItem()!==o.getId()){this.setSelectedItem(o);}this.fireItemPress({item:o});}}else if(E&&!E.isDefaultPrevented()){E.preventDefault();}};e.prototype.addAggregation=function(s,o,j){if(s==='items'){this._handleItemsAggregation(['addAggregation',o,j],true);}return C.prototype.addAggregation.call(this,s,o,j);};e.prototype.insertAggregation=function(s,o,j,k){if(s==='items'){this._handleItemsAggregation(['insertAggregation',o,j,k],true);}return C.prototype.insertAggregation.call(this,s,o,j,k);};e.prototype.removeAggregation=function(s,o,j){if(s==='items'){this._handleItemsAggregation(['removeAggregation',o,j]);}return C.prototype.removeAggregation.call(this,s,o,j);};e.prototype.removeAllAggregation=function(s,j){if(s==='items'){this._handleItemsAggregation(['removeAllAggregation',null,j]);}return C.prototype.removeAllAggregation.call(this,s,j);};e.prototype.destroyAggregation=function(s,j){if(s==='items'){this._handleItemsAggregation(['destroyAggregation',j]);}return C.prototype.destroyAggregation.call(this,s,j);};e.prototype.setSelectedItem=function(s){if(!s){return;}if(s.$().length>0){this._scrollIntoView(s,500);}this._updateAriaSelectedAttributes(this.getItems(),s);this._updateSelectedItemClasses(s.getId());if(this.getHasSelect()){var o=this._findSelectItemFromTabStripItem(s);this.getAggregation('_select').setSelectedItem(o);}return e.prototype.setAssociation.call(this,"selectedItem",s,true);};e.prototype.setProperty=function(p,v,s){var j;j=C.prototype.setProperty.call(this,p,v,s);if(p==='hasSelect'){if(v){if(!this.getAggregation('_select')){j=this.setAggregation('_select',this._createSelect(this.getItems()));}}else{j=this.destroyAggregation('_select');}}return j;};e.prototype._attachItemEventListeners=function(o){if(o instanceof T){var E=['itemClosePressed','itemPropertyChanged'];E.forEach(function(s){s=s.charAt(0).toUpperCase()+s.slice(1);o['detach'+s](this['_handle'+s]);o['attach'+s](this['_handle'+s].bind(this));},this);}};e.prototype._detachItemEventListeners=function(o){if(!o||typeof o!=='object'||!(o instanceof T)){var j=this.getItems();j.forEach(function(k){if(typeof k!=='object'||!(k instanceof T)){return;}return this._detachItemEventListeners(k);}.bind(this));}};e.prototype._handleItemPropertyChanged=function(E){var s=this._findSelectItemFromTabStripItem(E.getSource());s.setProperty(E['mParameters'].propertyKey,E['mParameters'].propertyValue);};e.prototype._handleItemClosePressed=function(E){this._removeItem(E.getSource());};e.prototype._removeItem=function(o,j){var t;if(!(o instanceof T)){q.sap.log.error('Expecting instance of a TabStripSelectItem, given: ',o);}if(o.getId().indexOf(e.SELECT_ITEMS_ID_SUFFIX)!==-1){t=this._findTabStripItemFromSelectItem(o);}else{t=o;}if(this.fireItemClose({item:t})){this.removeAggregation('items',t);this._moveToNextItem(o.getId()===this.getSelectedItem());if(j){j.call(this);}}};e.prototype._handleItemsAggregation=function(j,k){var s='items',F=j[0],o=j[1],n=[s];j.forEach(function(l,m){if(m>0){n.push(l);}});if(k){this._attachItemEventListeners(o);}else{this._detachItemEventListeners(o);}if(s!=="items"){return this;}if(this.getHasSelect()){this._handleSelectItemsAggregation(n,k,F,o);}return this;};e.prototype._handleSelectItemsAggregation=function(j,k,F,o){var s=this.getAggregation('_select'),l;if(F==='destroyAggregation'&&!s){return;}if(o===null||typeof o!=='object'){return s[F]['apply'](s,j);}if(k){l=this._createSelectItemFromTabStripItem(o);}else{l=this._findSelectItemFromTabStripItem(o);}j.forEach(function(m,n){if(typeof m==='object'){j[n]=l;}});return s[F]['apply'](s,j);};e.prototype._addItemsToSelect=function(s,j){j.forEach(function(o){var k=this._createSelectItemFromTabStripItem(o);s.addAggregation('items',k);if(o.getId()===this.getSelectedItem()){s.setSelectedItem(k);}},this);};e.prototype._createSelectItemFromTabStripItem=function(t){var s;if(!t&&!(t instanceof sap.m.TabContainerItem)){q.sap.log.error('Expecting instance of "sap.m.TabContainerItem": instead of '+t+' given.');return;}s=new T({id:t.getId()+e.SELECT_ITEMS_ID_SUFFIX,text:t.getText(),modified:t.getModified(),itemClosePressed:function(E){this._handleItemClosePressed(E);}.bind(this)});s.addEventDelegate({ontap:function(E){var o=E.srcControl;if((o instanceof A||o instanceof sap.ui.core.Icon)){this.fireItemClosePressed({item:this});}}},s);return s;};e.prototype._findTabStripItemFromSelectItem=function(t){var j,s=t.getId().replace(e.SELECT_ITEMS_ID_SUFFIX,''),k=this.getItems();for(j=0;j<k.length;j++){if(k[j].getId()===s){return k[j];}}};e.prototype._findSelectItemFromTabStripItem=function(t){var j,s,k=t.getId()+e.SELECT_ITEMS_ID_SUFFIX;if(this.getHasSelect()){s=this.getAggregation('_select').getItems();for(j=0;j<s.length;j++){if(s[j].getId()===k){return s[j];}}}};e.prototype._updateAriaSelectedAttributes=function(j,s){var k="false";j.forEach(function(o){if(o.$()){if(s&&s.getId()===o.getId()){k="true";}o.$().attr("aria-selected",k);}});};e.prototype._updateSelectedItemClasses=function(s){if(this.$("tabs")){this.$("tabs").children(".sapMTabStripItemSelected").removeClass("sapMTabStripItemSelected");q("#"+s).addClass("sapMTabStripItemSelected");}};e.prototype.changeItemState=function(v,s){var $;var j=this.getItems();j.forEach(function(o){if(v===o.getId()){$=q(o.$());if(s===true&&!$.hasClass(T.CSS_CLASS_MODIFIED)){$.addClass(T.CSS_CLASS_MODIFIED);}else{$.removeClass(T.CSS_CLASS_MODIFIED);}}});};e.prototype.ontouchstart=function(E){var t=q(E.target).control(0);if(t instanceof T||t instanceof A||t instanceof sap.ui.core.Icon||t instanceof g){this._oTouchStartX=E.changedTouches[0].pageX;}};e.prototype.ontouchend=function(E){var t,j;if(!this._oTouchStartX){return;}t=q(E.target).control(0);j=Math.abs(E.changedTouches[0].pageX-this._oTouchStartX);if(j<e.MIN_DRAG_OFFSET){if(t instanceof T){this._activateItem(t,E);}else if(t instanceof sap.m.AccButton){if(t&&t.getParent&&t.getParent()instanceof T){t=t.getParent();this._removeItem(t);}}else if(t instanceof sap.ui.core.Icon){if(t&&t.getParent&&t.getParent().getParent&&t.getParent().getParent()instanceof T){t=t.getParent().getParent();this._removeItem(t);}}this._oTouchStartX=null;}};e.prototype.destroyItems=function(){this.setAssociation("selectedItem",null);return this.destroyAggregation("items");};var f=R.extend(sap.m.SelectRenderer);var g=c.extend("CustomSelect",{renderer:f});g.prototype.onAfterRendering=function(){c.prototype.onAfterRendering.apply(this,arguments);this.$().attr("tabindex","-1");};g.prototype.onAfterRenderingPicker=function(){var p=this.getPicker();c.prototype.onAfterRenderingPicker.call(this);if(D.system.phone){return;}p.setOffsetX(Math.round(sap.ui.getCore().getConfiguration().getRTL()?this.getPicker().$().width()-this.$().width():this.$().width()-this.getPicker().$().width()));p.setOffsetY(this.$().parents().hasClass('sapUiSizeCompact')?2:3);p._calcPlacement();};g.prototype.createList=function(){this._oList=new i({width:"100%"}).attachSelectionChange(this.onSelectionChange,this).addEventDelegate({ontap:function(E){this.close();}},this);return this._oList;};g.prototype.setValue=function(v){c.prototype.setValue.apply(this,arguments);this.$("label").toggleClass("sapMTSOverflowSelectLabelModified",this.getSelectedItem()&&this.getSelectedItem().getProperty("modified"));return this;};var h=R.extend(sap.m.SelectListRenderer);h.renderItem=function(o,l,j,s){o.write("<li");o.writeElementData(j);o.addClass(sap.m.SelectListRenderer.CSS_CLASS+"ItemBase");o.addClass(sap.m.SelectListRenderer.CSS_CLASS+"Item");o.addClass("sapMTSOverflowSelectListItem");if(j.getProperty("modified")){o.addClass("sapMTSOverflowSelectListItemModified");}if(D.system.desktop){o.addClass(sap.m.SelectListRenderer.CSS_CLASS+"ItemBaseHoverable");}if(j===l.getSelectedItem()){o.addClass(sap.m.SelectListRenderer.CSS_CLASS+"ItemBaseSelected");}o.writeClasses();this.writeItemAccessibilityState.apply(this,arguments);o.write(">");o.write('<p class=\"sapMSelectListItemText\">');o.writeEscaped(j.getText().slice(0,(D.system.phone?j.getText().length:T.DISPLAY_TEXT_MAX_LENGTH)));if(!D.system.phone&&j.getText().length>T.DISPLAY_TEXT_MAX_LENGTH){o.write('...');}o.write('</p>');o.renderControl(j.getAggregation('_closeButton'));o.write("</li>");};var i=d.extend("CustomSelectList",{renderer:h});return e;},false);
