/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides the default renderer for control sap.tnt.NavigationList
sap.ui.define(['jquery.sap.global', 'sap/ui/core/Renderer'],
	function(jQuery, Renderer) {
		"use strict";

		/**
		 * NavigationListRenderer renderer.
		 *
		 * @author SAP SE
		 * @namespace
		 */
		var NavigationListRenderer = {};

		/**
		 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
		 *
		 * @param {sap.ui.core.RenderManager} rm The RenderManager that can be used for writing to the renderer output buffer
		 * @param {sap.ui.core.Control} control An object representation of the control that should be rendered
		 */
		NavigationListRenderer.render = function (rm, control) {
			var group,
				role,
				groups = control.getItems(),
				length = groups.length,
				expanded = control.getExpanded();

			rm.write("<ul");
			rm.writeControlData(control);

			var width = control.getWidth();
			if (width && expanded) {
				rm.addStyle("width", width);
			}
			rm.writeStyles();

			rm.addClass("sapTntNavLI");

			if (!expanded) {
				rm.addClass("sapTntNavLICollapsed");
			}

			rm.writeClasses();

			// ARIA
			role = expanded ? 'tree' : 'toolbar';

			rm.writeAttribute("role", role);

			rm.write(">");

			for (var i = 0; i < length; i++) {
				group = groups[i];
				group.render(rm, control, i, length);
			}

			rm.write("</ul>");
		};

		return NavigationListRenderer;

	}, /* bExport= */ true);
