/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./BindingParser','./DataType','./EventProvider','./ManagedObjectMetadata','../model/BindingMode','../model/CompositeBinding','../model/Context','../model/FormatException','../model/ListBinding','../model/Model','../model/ParseException','../model/TreeBinding','../model/Type','../model/ValidateException','jquery.sap.act','jquery.sap.script','jquery.sap.strings'],function(q,B,D,E,M,d,C,f,F,L,g,P,T,h,V){"use strict";var I;var j=E.extend("sap.ui.base.ManagedObject",{metadata:{"abstract":true,publicMethods:["getId","getMetadata","getModel","setModel","hasModel","bindProperty","unbindProperty","bindAggregation","unbindAggregation","bindObject","unbindObject","getObjectBinding"],library:"sap.ui.core",properties:{},aggregations:{},associations:{},events:{"validationSuccess":{enableEventBubbling:true,parameters:{element:{type:'sap.ui.base.ManagedObject'},property:{type:'string'},type:{type:'sap.ui.model.Type'},newValue:{type:'any'},oldValue:{type:'any'}}},"validationError":{enableEventBubbling:true,parameters:{element:{type:'sap.ui.base.ManagedObject'},property:{type:'string'},type:{type:'sap.ui.model.Type'},newValue:{type:'any'},oldValue:{type:'any'},message:{type:'string'}}},"parseError":{enableEventBubbling:true,parameters:{element:{type:'sap.ui.base.ManagedObject'},property:{type:'string'},type:{type:'sap.ui.model.Type'},newValue:{type:'any'},oldValue:{type:'any'},message:{type:'string'}}},"formatError":{enableEventBubbling:true,parameters:{element:{type:'sap.ui.base.ManagedObject'},property:{type:'string'},type:{type:'sap.ui.model.Type'},newValue:{type:'any'},oldValue:{type:'any'}}},"modelContextChange":{}},specialSettings:{id:'sap.ui.core.ID',models:'object',bindingContexts:'object',objectBindings:'object',metadataContexts:'object',Type:{type:'string',visibility:'hidden'}}},constructor:function(i,s,a){var t=this;E.call(this);if(typeof i!=='string'&&i!==undefined){a=s;s=i;i=s&&s.id;}if(!i){i=this.getMetadata().uid();}else{var p=j._fnIdPreprocessor;i=(p?p.call(this,i):i);var b=I||(I=D.getType("sap.ui.core.ID"));if(!b.isValid(i)){throw new Error("\""+i+"\" is not a valid ID.");}}this.sId=i;this.mProperties=this.getMetadata().createPropertyBag();this.mAggregations={};this.mAssociations={};this.oParent=null;this.aDelegates=[];this.aBeforeDelegates=[];this.iSuppressInvalidate=0;this.oPropagatedProperties=j._oEmptyPropagatedProperties;this.mSkipPropagation={};this.oModels={};this.aPropagationListeners=[];this.oBindingContexts={};this.mElementBindingContexts={};this.mBindingInfos={};this.mObjectBindingInfos={};this._oContextualSettings=j._defaultContextualSettings;this._sOwnerId=j._sOwnerId;(function(){var c=false;if(t.register){t.register();}try{if(t._initCompositeSupport){t._initCompositeSupport(s);}if(t.init){t.init();}t.applySettings(s,a);c=true;}finally{if(!c&&t.deregister){t.deregister();}}}());}},M);j.create=function(v,K,s){if(!v||v instanceof j||typeof v!=="object"||v instanceof String){return v;}function a(t){if(typeof t==="function"){return t;}if(typeof t==="string"){return q.sap.getObject(t);}}var c=a(v.Type)||a(K&&K.type);if(typeof c==="function"){return new c(v,s);}var b="Don't know how to create a ManagedObject from "+v+" ("+(typeof v)+")";q.sap.log.fatal(b);throw new Error(b);};var S;function k(i){if(!S){S=sap.ui.require("sap/ui/core/StashedControlSupport");}if(S){return S.getStashedControls(i);}return[];}j._fnIdPreprocessor=null;j._fnSettingsPreprocessor=null;j.runWithPreprocessors=function(a,p){var O={id:this._fnIdPreprocessor,settings:this._fnSettingsPreprocessor};p=p||{};this._fnIdPreprocessor=p.id;this._fnSettingsPreprocessor=p.settings;try{var r=a.call();this._fnIdPreprocessor=O.id;this._fnSettingsPreprocessor=O.settings;return r;}catch(e){this._fnIdPreprocessor=O.id;this._fnSettingsPreprocessor=O.settings;throw e;}};j.prototype.applySettings=function(s,a){if(!s||q.isEmptyObject(s)){return this;}var t=this,b=this.getMetadata(),v=b.getJSONKeys(),c=j.create,p=j._fnSettingsPreprocessor,K,e,n;function r(O){for(var i=0,w=O.length;i<w;i++){var x=O[i];if(Array.isArray(x)){r(x);}else{t[n._sMutator](c(x,n,a));}}}p&&p.call(this,s);if(s.metadataContexts&&this._processMetadataContexts){this._processMetadataContexts(s.metadataContexts,s);}if(s.models){if(typeof s.models!=="object"){throw new Error("models must be a simple object");}if(s.models instanceof g){this.setModel(s.models);}else{for(K in s.models){this.setModel(s.models[K],K==="undefined"?undefined:K);}}}if(s.bindingContexts){if(typeof s.bindingContexts!=="object"){throw new Error("bindingContexts must be a simple object");}if(s.bindingContexts instanceof f){this.setBindingContext(s.bindingContexts);}else{for(K in s.bindingContexts){this.setBindingContext(s.bindingContexts[K],K==="undefined"?undefined:K);}}}if(s.objectBindings){if(typeof s.objectBindings!=="string"&&typeof s.objectBindings!=="object"){throw new Error("binding must be a string or simple object");}if(typeof s.objectBindings==="string"||s.objectBindings.path){this.bindObject(s.objectBindings);}else{for(var K in s.objectBindings){s.objectBindings.model=K;this.bindObject(s.objectBindings[K]);}}}for(K in s){e=s[K];if((n=v[K])!==undefined){var u;switch(n._iKind){case 0:u=this.extractBindingInfo(e,a);if(u&&typeof u==="object"){this.bindProperty(K,u);}else{this[n._sMutator](u||e);}break;case 1:u=n.altTypes&&this.extractBindingInfo(e,a);if(u&&typeof u==="object"){this.bindProperty(K,u);}else{if(Array.isArray(e)){if(e.length>1){q.sap.log.error("Tried to add an array of controls to a single aggregation");}e=e[0];}this[n._sMutator](c(u||e,n,a));}break;case 2:u=this.extractBindingInfo(e,a);if(u&&typeof u==="object"){this.bindAggregation(K,u);}else{e=u||e;if(e){if(Array.isArray(e)){r(e);}else{t[n._sMutator](c(e,n,a));}}}break;case 3:this[n._sMutator](e);break;case 4:if(e){if(Array.isArray(e)){for(var i=0,l=e.length;i<l;i++){this[n._sMutator](e[i]);}}else{this[n._sMutator](e);}}break;case 5:if(typeof e=="function"){this[n._sMutator](e);}else{this[n._sMutator](e[0],e[1],e[2]);}break;case-1:default:break;}}else{}}return this;};j.prototype.toString=function(){return"ManagedObject "+this.getMetadata().getName()+"#"+this.getId();};j.prototype.getId=function(){return this.sId;};j.prototype.setProperty=function(p,v,s){var O=this.mProperties[p];v=this.validateProperty(p,v);if(q.sap.equal(O,v)){this.mProperties[p]=v;return this;}if(s){q.sap.act.refresh();this.iSuppressInvalidate++;}this.mProperties[p]=v;if(!this.isInvalidateSuppressed()){this.invalidate();}this.updateModelProperty(p,v,O);if(this.mEventRegistry["_change"]){E.prototype.fireEvent.call(this,"_change",{"id":this.getId(),"name":p,"oldValue":O,"newValue":v});}if(this._observer){this._observer.propertyChange(this,p,O,v);}if(s){this.iSuppressInvalidate--;}return this;};j.prototype.getProperty=function(p){var v=this.mProperties[p],a=this.getMetadata().getProperty(p),t;if(!a){throw new Error("Property \""+p+"\" does not exist in "+this);}t=D.getType(a.type);if(t instanceof D&&t.isArrayType()&&Array.isArray(v)){v=v.slice(0);}if(v instanceof String){v=v.valueOf();}return v;};j.prototype.validateProperty=function(p,v){var a=this.getMetadata().getProperty(p),t;if(!a){throw new Error("Property \""+p+"\" does not exist in "+this);}t=D.getType(a.type);if(t instanceof D&&t.isArrayType()&&Array.isArray(v)){v=v.slice(0);}if(v==null){v=a.getDefaultValue();}else if(t instanceof D){if(t.getName()=="string"){if(!(typeof v=="string"||v instanceof String)){v=""+v;}}else if(t.getName()=="string[]"){if(typeof v=="string"){v=[v];}if(!Array.isArray(v)){throw new Error("\""+v+"\" is of type "+typeof v+", expected string[]"+" for property \""+p+"\" of "+this);}for(var i=0;i<v.length;i++){if(typeof v[i]!=="string"){v[i]=""+v[i];}}}else if(!t.isValid(v)){throw new Error("\""+v+"\" is of type "+typeof v+", expected "+t.getName()+" for property \""+p+"\" of "+this);}}if(t&&t.normalize&&typeof t.normalize==="function"){v=t.normalize(v);}return v;};j.prototype.isPropertyInitial=function(p){return!Object.prototype.hasOwnProperty.call(this.mProperties,p)&&!this.isBound(p);};j.prototype.resetProperty=function(p){if(this.mProperties.hasOwnProperty(p)){var a=this.getMetadata().getProperty(p);this[a._sMutator](null);if(this.mProperties[p]===a.getDefaultValue()){delete this.mProperties[p];}}return this;};j.prototype.getOriginInfo=function(p){var v=this.mProperties[p];if(!(v instanceof String&&v.originInfo)){return null;}return v.originInfo;};j.prototype.setAssociation=function(a,i,s){if(i instanceof j){i=i.getId();}else if(i!=null&&typeof i!=="string"){return this;}if(this.mAssociations[a]===i){return this;}if(s){this.iSuppressInvalidate++;}if(this._observer&&this.mAssociations[a]!=null){this._observer.associationChange(this,a,"remove",this.mAssociations[a]);}this.mAssociations[a]=i;if(this._observer&&this.mAssociations[a]!=null){this._observer.associationChange(this,a,"insert",i);}if(!this.isInvalidateSuppressed()){this.invalidate();}if(s){this.iSuppressInvalidate--;}return this;};j.prototype.getAssociation=function(a,b){var r=this.mAssociations[a];if(!r){r=this.mAssociations[a]=b||null;}else{if(typeof r.length==='number'&&!(r.propertyIsEnumerable('length'))){return r.slice();}return r;}return r;};j.prototype.addAssociation=function(a,i,s){if(i instanceof j){i=i.getId();}else if(typeof i!=="string"){return this;}if(s){this.iSuppressInvalidate++;}var b=this.mAssociations[a];if(!b){b=this.mAssociations[a]=[i];}else{b.push(i);}if(this._observer){this._observer.associationChange(this,a,"insert",i);}if(!this.isInvalidateSuppressed()){this.invalidate();}if(s){this.iSuppressInvalidate--;}return this;};j.prototype.removeAssociation=function(a,O,s){var b=this.mAssociations[a];var c=null;if(!b){return null;}if(s){this.iSuppressInvalidate++;}if(typeof(O)=="object"&&O.getId){O=O.getId();}if(typeof(O)=="string"){for(var i=0;i<b.length;i++){if(b[i]==O){O=i;break;}}}if(typeof(O)=="number"){if(O<0||O>=b.length){q.sap.log.warning("ManagedObject.removeAssociation called with invalid index: "+a+", "+O);}else{c=b[O];b.splice(O,1);if(this._observer){this._observer.associationChange(this,a,"remove",c);}if(!this.isInvalidateSuppressed()){this.invalidate();}}}if(s){this.iSuppressInvalidate--;}return c;};j.prototype.removeAllAssociation=function(a,s){var i=this.mAssociations[a];if(!i){return[];}if(s){this.iSuppressInvalidate++;}delete this.mAssociations[a];if(this._observer){this._observer.associationChange(this,a,"remove",i);}if(!this.isInvalidateSuppressed()){this.invalidate();}if(s){this.iSuppressInvalidate--;}return i;};j.prototype.validateAggregation=function(a,O,b){var c=this.getMetadata(),A=c.getManagedAggregation(a),e,t,i,l;if(!A){throw new Error("Aggregation \""+a+"\" does not exist in "+this);}if(A.multiple!==b){throw new Error("Aggregation '"+a+"' of "+this+" used with wrong cardinality (declared as "+(A.multiple?"0..n":"0..1")+")");}if(!A.multiple&&!O){return O;}t=q.sap.getObject(A.type);if(typeof t==="function"&&O instanceof t){return O;}if(O&&O.getMetadata&&O.getMetadata().isInstanceOf(A.type)){return O;}e=A.altTypes;if(e&&e.length){if(O==null){return O;}for(i=0;i<e.length;i++){t=D.getType(e[i]);if(t instanceof D){if(t.isValid(O)){return O;}}}}l="\""+O+"\" is not valid for aggregation \""+a+"\" of "+this;if(D.isInterfaceType(A.type)){return O;}else{throw new Error(l);}};j.prototype.setAggregation=function(a,O,s){var b=this.mAggregations[a];if(b===O){return this;}O=this.validateAggregation(a,O,false);if(s){this.iSuppressInvalidate++;}if(b instanceof j){b.setParent(null);}this.mAggregations[a]=O;if(O instanceof j){O.setParent(this,a,s);}else{if(!this.isInvalidateSuppressed()){this.invalidate();}}if(s){this.iSuppressInvalidate--;}return this;};j.prototype.getAggregation=function(a,b){var c=this.mAggregations[a];if(!c){c=this.mAggregations[a]=b||null;}if(c){if(typeof c.length==='number'&&!(c.propertyIsEnumerable('length'))){return c.slice();}return c;}else{return null;}};j.prototype.indexOfAggregation=function(a,O){var c=this.mAggregations[a];if(c){if(c.length==undefined){return-2;}for(var i=0;i<c.length;i++){if(c[i]==O){return i;}}}return-1;};j.prototype.insertAggregation=function(a,O,b,s){if(!O){return this;}O=this.validateAggregation(a,O,true);var c=this.mAggregations[a]||(this.mAggregations[a]=[]);var i;if(b<0){i=0;}else if(b>c.length){i=c.length;}else{i=b;}if(i!==b){q.sap.log.warning("ManagedObject.insertAggregation: index '"+b+"' out of range [0,"+c.length+"], forced to "+i);}c.splice(i,0,O);O.setParent(this,a,s);return this;};j.prototype.addAggregation=function(a,O,s){if(!O){return this;}O=this.validateAggregation(a,O,true);var c=this.mAggregations[a];if(!c){c=this.mAggregations[a]=[O];}else{c.push(O);}O.setParent(this,a,s);return this;};j.prototype.removeAggregation=function(a,O,s){var c=this.mAggregations[a],b=null,i;if(!c){return null;}if(s){this.iSuppressInvalidate++;}if(typeof(O)=="string"){for(i=0;i<c.length;i++){if(c[i]&&c[i].getId()===O){O=i;break;}}}if(typeof(O)=="object"){for(i=0;i<c.length;i++){if(c[i]==O){O=i;break;}}}if(typeof(O)=="number"){if(O<0||O>=c.length){q.sap.log.warning("ManagedObject.removeAggregation called with invalid index: "+a+", "+O);}else{b=c[O];c.splice(O,1);b.setParent(null);if(!this.isInvalidateSuppressed()){this.invalidate();}}}if(s){this.iSuppressInvalidate--;}return b;};j.prototype.removeAllAggregation=function(a,s){var c=this.mAggregations[a];if(!c){return[];}if(s){this.iSuppressInvalidate++;}delete this.mAggregations[a];for(var i=0;i<c.length;i++){c[i].setParent(null);}if(!this.isInvalidateSuppressed()){this.invalidate();}if(s){this.iSuppressInvalidate--;}return c;};j.prototype.destroyAggregation=function(a,s){var b=this.mAggregations[a],i,e;k(this.getId()).forEach(function(c){if(c.sParentAggregationName===a){c.destroy();}});if(!b){return this;}if(s){this.iSuppressInvalidate++;}delete this.mAggregations[a];if(b instanceof j){b.destroy(s);if(this._observer){this._observer.aggregationChange(this,a,"remove",b);}}else if(Array.isArray(b)){for(i=b.length-1;i>=0;i--){e=b[i];if(e){e.destroy(s);if(this._observer){this._observer.aggregationChange(this,a,"remove",e);}}}}if(!this.isInvalidateSuppressed()){this.invalidate();}if(s){this.iSuppressInvalidate--;}return this;};j.prototype.invalidate=function(){if(this.oParent){this.oParent.invalidate(this);}};j.prototype.isInvalidateSuppressed=function(){var i=this.iSuppressInvalidate>0;if(this.oParent&&this.oParent instanceof j){i=i||this.oParent.isInvalidateSuppressed();}return i;};j.prototype._removeChild=function(c,a,s){if(!a){q.sap.log.error("Cannot remove aggregated child without aggregation name.",null,this);}else{if(s){this.iSuppressInvalidate++;}var i=this.indexOfAggregation(a,c);var A=this.getMetadata().getAggregation(a);if(i==-2){if(A&&this[A._sMutator]){this[A._sMutator](null);}else{this.setAggregation(a,null,s);}}else if(i>-1){if(A&&this[A._sRemoveMutator]){this[A._sRemoveMutator](i);}else{this.removeAggregation(a,i,s);}}if(s){this.iSuppressInvalidate--;}}};function m(a,b){while(a&&a!==b){a=a.oParent;}return!!a;}j.prototype.setParent=function(p,a,s){if(!p){if(this.oParent){if(this.oParent._observer){this.oParent._observer.aggregationChange(this.oParent,this.sParentAggregationName,"remove",this);}}this.oParent=null;this.sParentAggregationName=null;var b=j._oEmptyPropagatedProperties;if(b!==this.oPropagatedProperties){this.oPropagatedProperties=b;if(!this._bIsBeingDestroyed){setTimeout(function(){if(!this.oParent){this.updateBindings(true,null);this.updateBindingContext(false,undefined,true);this.propagateProperties(true);this.fireModelContextChange();}}.bind(this),0);}}this._oContextualSettings=j._defaultContextualSettings;if(!this._bIsBeingDestroyed){setTimeout(function(){if(!this.oParent){this._propagateContextualSettings();}}.bind(this),0);}q.sap.act.refresh();return;}if(m(p,this)){throw new Error("Cycle detected: new parent '"+p+"' is already a descendant of (or equal to) '"+this+"'");}if(s){q.sap.act.refresh();this.iSuppressInvalidate++;}var O=this.getParent();if(O){O._removeChild(this,this.sParentAggregationName);}this.oParent=p;this.sParentAggregationName=a;var b=p._getPropertiesToPropagate();if(b!==this.oPropagatedProperties){this.oPropagatedProperties=b;if(this.hasModel()){this.updateBindings(true,null);this.updateBindingContext(false,undefined,true);this.propagateProperties(true);}this._callPropagationListener();this.fireModelContextChange();}this._applyContextualSettings(p._oContextualSettings);if(p&&!this.isInvalidateSuppressed()){p.invalidate(this);}if(s){this.iSuppressInvalidate--;}if(p._observer){p._observer.aggregationChange(p,a,"insert",this);}return this;};j.prototype._applyContextualSettings=function(c){if(this._oContextualSettings!==c){this._oContextualSettings=c;this._propagateContextualSettings();this._onContextualSettingsChanged();}};j.prototype._onContextualSettingsChanged=function(){};j.prototype._propagateContextualSettings=function(){var s=this._oContextualSettings,a,A,i;for(a in this.mAggregations){A=this.mAggregations[a];if(A instanceof j){A._applyContextualSettings(s);}else if(A instanceof Array){for(i=0;i<A.length;i++){if(A[i]instanceof j){A[i]._applyContextualSettings(s);}}}}};j.prototype._getContextualSettings=function(){return this._oContextualSettings;};j.prototype.getParent=function(){return this.oParent;};j.prototype.destroy=function(s){var t=this;this._bIsBeingDestroyed=true;if(s){this.iSuppressInvalidate++;}if(this.exit){this.exit();}if(this._exitCompositeSupport){this._exitCompositeSupport();}for(var a in this.mAggregations){this.destroyAggregation(a,s);}k(this.getId()).forEach(function(c){c.destroy();});if(this.deregister){this.deregister();}if(this.oParent&&this.sParentAggregationName){this.oParent._removeChild(this,this.sParentAggregationName,s);}delete this.oParent;q.each(this.mBindingInfos,function(n,b){if(b.factory){t.unbindAggregation(n,true);}else{t.unbindProperty(n,true);}});q.each(this.mObjectBindingInfos,function(n,b){t.unbindObject(n,true);});if(s){this.iSuppressInvalidate--;}if(this._observer){this._observer=undefined;}E.prototype.destroy.apply(this,arguments);this.setParent=function(){throw Error("The object with ID "+t.getId()+" was destroyed and cannot be used anymore.");};this.bIsDestroyed=true;};j.bindingParser=B.simpleParser;j.prototype.isBinding=function(v,K){return typeof this.extractBindingInfo(v)==="object";};j.prototype.extractBindingInfo=function(v,s){if(v&&typeof v==="object"){if(v.ui5object){delete v.ui5object;}else if(v.path!=undefined||v.parts){if(v.template){v.template=j.create(v.template);}return v;}}if(typeof v==="string"){return j.bindingParser(v,s,true);}};j.prototype.getBindingInfo=function(n){return this.mBindingInfos[n];};j.prototype.bindObject=function(p,a){var b={},s,i;if(typeof p=="object"){b=p;p=b.path;}else{b.path=p;b.parameters=a;}i=p.indexOf(">");if(i>0){b.model=p.substr(0,i);b.path=p.substr(i+1);}s=b.model;if(this.mObjectBindingInfos[s]){this.unbindObject(s,true);}this.mObjectBindingInfos[s]=b;if(this.getModel(s)){this._bindObject(b);}return this;};j.prototype._bindObject=function(b){var a,c,s,e,t=this;var i=function(l){if(a.getBoundContext()===t.getBindingContext(s)){t.setElementBindingContext(null,s);}t.setElementBindingContext(a.getBoundContext(),s);};s=b.model;e=this.getModel(s);c=this.getBindingContext(s);a=e.bindContext(b.path,c,b.parameters);a.attachChange(i);b.binding=a;b.modelChangeHandler=i;a.attachEvents(b.events);a.initialize();};j.prototype.bindContext=function(p){return this.bindObject(p);};j.prototype.unbindContext=function(s){return this.unbindObject(s);};j.prototype.unbindObject=function(s,_){var b=this.mObjectBindingInfos[s];if(b){if(b.binding){b.binding.detachChange(b.modelChangeHandler);b.binding.detachEvents(b.events);b.binding.destroy();}delete this.mObjectBindingInfos[s];delete this.mElementBindingContexts[s];if(!_){this.updateBindingContext(false,s);this.propagateProperties(s);this.fireModelContextChange();}}return this;};j.prototype.bindProperty=function(n,b,_,a){var s,A=true,p=this.getMetadata().getPropertyLikeSetting(n);if(!p){throw new Error("Property \""+n+"\" does not exist in "+this);}if(typeof b=="string"){b={parts:[{path:b,type:_ instanceof h?_:undefined,mode:a}],formatter:typeof _==='function'?_:undefined};}if(!b.parts){b.parts=[];b.parts[0]={path:b.path,targetType:b.targetType,type:b.type,suspended:b.suspended,formatOptions:b.formatOptions,constraints:b.constraints,model:b.model,mode:b.mode};delete b.path;delete b.targetType;delete b.mode;delete b.model;}for(var i=0;i<b.parts.length;i++){var c=b.parts[i];if(typeof c=="string"){c={path:c};b.parts[i]=c;}s=c.path.indexOf(">");if(s>0){c.model=c.path.substr(0,s);c.path=c.path.substr(s+1);}if(b.formatter&&c.mode!=d.OneWay&&c.mode!=d.OneTime){c.mode=d.OneWay;}if(!this.getModel(c.model)){A=false;}}if(this.isBound(n)){this.unbindProperty(n,true);}this.mBindingInfos[n]=b;if(A){this._bindProperty(n,b);}return this;};j.prototype._bindProperty=function(n,b){var a,c,e,s,i=d.TwoWay,t,l,p=this.getMetadata().getPropertyLikeSetting(n),r=p._iKind===0?p.type:p.altTypes[0],u=this,v=[],w=function(y){u.updateProperty(n);var z=e.getDataState();if(z){var A=z.getControlMessages();if(A&&A.length>0){var G=sap.ui.getCore().getMessageManager();z.setControlMessages([]);if(A){G.removeMessages(A);}}z.setInvalidValue(undefined);}if(e.getBindingMode()===d.OneTime&&e.isResolved()){e.detachChange(w);e.detachEvents(b.events);e.destroy();}},x=function(){var y=e.getDataState();if(!y){return;}if(u.refreshDataState){u.refreshDataState(n,y);}};c=this.getBindingContext(b.model);b.parts.forEach(function(y){c=u.getBindingContext(y.model);a=u.getModel(y.model);t=y.type;if(typeof t=="string"){l=q.sap.getObject(t);if(typeof l!=="function"){throw new Error("Cannot find type \""+t+"\" used in control \""+u.getId()+"\"!");}t=new l(y.formatOptions,y.constraints);}e=a.bindProperty(y.path,c,b.parameters);e.setType(t,y.targetType||r);e.setFormatter(y.formatter);if(y.suspended){e.suspend(true);}s=y.mode||a.getDefaultBindingMode();e.setBindingMode(s);if(s!=d.TwoWay){i=d.OneWay;}v.push(e);});if(v.length>1||(b.formatter&&b.formatter.textFragments)){t=b.type;if(typeof t=="string"){l=q.sap.getObject(t);t=new l(b.formatOptions,b.constraints);}e=new C(v,b.useRawValues,b.useInternalValues);e.setType(t,b.targetType||r);e.setBindingMode(b.mode||i);}else{e=v[0];}e.attachChange(w);if(this.refreshDataState){e.attachAggregatedDataStateChange(x);}e.setFormatter(q.proxy(b.formatter,this));b.binding=e;b.modelChangeHandler=w;b.dataStateChangeHandler=x;e.attachEvents(b.events);e.initialize();};j.prototype.unbindProperty=function(n,s){var b=this.mBindingInfos[n];if(b){if(b.binding){b.binding.detachChange(b.modelChangeHandler);if(this.refreshDataState){b.binding.detachAggregatedDataStateChange(b.dataStateChangeHandler);}b.binding.detachEvents(b.events);b.binding.destroy();}delete this.mBindingInfos[n];if(!s){this.resetProperty(n);}}return this;};j.prototype.updateProperty=function(n){var b=this.mBindingInfos[n],a=b.binding,p=this.getMetadata().getPropertyLikeSetting(n);if(b.skipPropertyUpdate){return;}try{var v=a.getExternalValue();b.skipModelUpdate=true;this[p._sMutator](v);b.skipModelUpdate=false;}catch(e){b.skipModelUpdate=false;if(e instanceof F){this.fireFormatError({element:this,property:n,type:a.getType(),newValue:a.getValue(),oldValue:this[p._sGetter](),exception:e,message:e.message},false,true);b.skipModelUpdate=true;this.resetProperty(n);b.skipModelUpdate=false;}else{throw e;}}};j.prototype.updateModelProperty=function(n,v,O){if(this.isBound(n)){var b=this.mBindingInfos[n],a=b.binding;if(b.skipModelUpdate||(a&&a.isSuspended())){return;}if(a&&a.getBindingMode()==d.TwoWay){try{b.skipPropertyUpdate=true;a.setExternalValue(v);b.skipPropertyUpdate=false;var e=a.getExternalValue();if(v!=e){this.updateProperty(n);}if(a.hasValidation()){this.fireValidationSuccess({element:this,property:n,type:a.getType(),newValue:v,oldValue:O},false,true);}}catch(c){b.skipPropertyUpdate=false;if(c instanceof P){this.fireParseError({element:this,property:n,type:a.getType(),newValue:v,oldValue:O,exception:c,message:c.message},false,true);}else if(c instanceof V){this.fireValidationError({element:this,property:n,type:a.getType(),newValue:v,oldValue:O,exception:c,message:c.message},false,true);}else{throw c;}}}}};var o=1;j.prototype.bindAggregation=function(n,b){var p,t,s,a,c=this.getMetadata(),A=c.getAggregation(n);if(!A){throw new Error("Aggregation \""+n+"\" does not exist in "+this);}if(!A.multiple){q.sap.log.error("Binding of single aggregation \""+n+"\" of "+this+" is not supported!");}if(typeof b=="string"){p=arguments[1];t=arguments[2];s=arguments[3];a=arguments[4];b={path:p,sorter:s,filters:a};if(t instanceof j){b.template=t;}else if(typeof t==="function"){b.factory=t;}}if(this.isBound(n)){this.unbindAggregation(n);}if(!(b.template||b.factory)){if(A._doesNotRequireFactory){b.factory=function(){throw new Error("dummy factory called unexpectedly ");};}else{throw new Error("Missing template or factory function for aggregation "+n+" of "+this+" !");}}if(b.template){if(b.template._sapui_candidateForDestroy){q.sap.log.warning("A binding template that is marked as 'candidate for destroy' is reused in a binding. "+"You can use 'templateShareable:true' to fix this issue for all bindings that are affected "+"(The template is used in aggregation '"+n+"' of object '"+this.getId()+"'). "+"For more information, see documentation under 'Aggregation Binding'.");delete b.template._sapui_candidateForDestroy;}if(b.templateShareable===undefined){b.templateShareable=o;}b.factory=function(e){return b.template.clone(e);};}var i=b.path.indexOf(">");if(i>0){b.model=b.path.substr(0,i);b.path=b.path.substr(i+1);}this.mBindingInfos[n]=b;if(this.getModel(b.model)){this._bindAggregation(n,b);}return this;};j.prototype._bindAggregation=function(n,b){var t=this,a,c=function(l){var u="update"+n.substr(0,1).toUpperCase()+n.substr(1);if(t[u]){var s=l&&l.getParameter("reason");if(s){t[u](s);}else{t[u]();}}else{t.updateAggregation(n);}},e=function(l){var r="refresh"+n.substr(0,1).toUpperCase()+n.substr(1);if(t[r]){t[r](l.getParameter("reason"));}else{c(l);}};var i=this.getModel(b.model);if(this.isTreeBinding(n)){a=i.bindTree(b.path,this.getBindingContext(b.model),b.filters,b.parameters,b.sorter);}else{a=i.bindList(b.path,this.getBindingContext(b.model),b.sorter,b.filters,b.parameters);if(this.bUseExtendedChangeDetection){a.enableExtendedChangeDetection(!b.template,b.key);}}if(b.suspended){a.suspend(true);}b.binding=a;b.modelChangeHandler=c;b.modelRefreshHandler=e;a.attachChange(c);a.attachRefresh(e);a.attachEvents(b.events);a.initialize();};j.prototype.unbindAggregation=function(n,s){var b=this.mBindingInfos[n],a=this.getMetadata().getAggregation(n);if(b){if(b.binding){b.binding.detachChange(b.modelChangeHandler);b.binding.detachRefresh(b.modelRefreshHandler);b.binding.detachEvents(b.events);b.binding.destroy();}if(b.template){if(!b.templateShareable&&b.template.destroy){b.template.destroy();}if(b.templateShareable===o){b.template._sapui_candidateForDestroy=true;}}delete this.mBindingInfos[n];if(!s){this[a._sDestructor]();}}return this;};j.prototype.updateAggregation=function(n){var b=this.mBindingInfos[n],a=b.binding,c=b.factory,A=this.getMetadata().getAggregation(n),G,e,l,s=A._sMutator+"Group",t=this;function p(i,x){if(t.bUseExtendedChangeDetection){return M.uid('clone');}else{return i.getId()+"-"+x;}}function u(x,l,y,z){var H=x[A._sGetter]()||[],J,K;if(H.length>l.length){for(var i=l.length;i<H.length;i++){K=H[i];x[A._sRemoveMutator](K);K.destroy("KeepDom");}}for(var i=0;i<l.length;i++){J=l[i];K=H[i];if(y){y(J);}if(K){K.setBindingContext(J,b.model);}else{K=c(p(x,i),J);K.setBindingContext(J,b.model);x[A._sMutator](K);}if(z){z(J,K);}}}function r(x,l){var y=l.diff,z=x[A._sGetter]()||[],H,J,K,i;if(!y||z.length===0){u(x,l);return;}if(y.length==0){return;}for(i=0;i<y.length;i++){H=y[i];switch(H.type){case"insert":K=l[H.index];J=c(p(x,H.index),K);J.setBindingContext(K,b.model);x[A._sInsertMutator](J,H.index);break;case"delete":J=x[A._sRemoveMutator](H.index);J.destroy("KeepDom");break;default:q.sap.log.error("Unknown diff type \""+H.type+"\"");}}z=x[A._sGetter]()||[];for(i=0;i<z.length;i++){z[i].setBindingContext(l[i]);}}function v(i){var N=a.getGroup(i);if(N.key!==G){var x;if(b.groupHeaderFactory){x=b.groupHeaderFactory(N);}t[s](N,x);G=N.key;}}function w(i,x){u(i,x,null,function(y,z){w(z,a.getNodeContexts(y));});}if(a instanceof L){l=a.getContexts(b.startIndex,b.length);e=a.isGrouped()&&t[s];if(e||a.bWasGrouped){this[A._sDestructor]();u(this,l,e?v:undefined);}else if(this.bUseExtendedChangeDetection){r(this,l);}else{if(!b.template){this[A._sDestructor]();}u(this,l);}a.bWasGrouped=e;}else if(a instanceof T){if(!b.template){this[A._sDestructor]();}w(this,a.getRootContexts());}};j.prototype.refreshAggregation=function(n){var b=this.mBindingInfos[n],a=b.binding;a.getContexts(b.startIndex,b.length);};j.prototype.propagateMessages=function(n,a){q.sap.log.warning("Message for "+this+", Property "+n);};j.prototype.isTreeBinding=function(n){return false;};j.prototype.updateBindings=function(u,s){var t=this,n,b;function a(b){var p=b.parts,i;if(p){if(p.length==1){return(u||p[0].model==s)&&!b.binding.updateRequired(t.getModel(p[0].model));}else{for(i=0;i<p.length;i++){if((u||p[i].model==s)&&!b.binding.aBindings[i].updateRequired(t.getModel(p[i].model))){return true;}}}}else{return(u||b.model==s)&&!b.binding.updateRequired(t.getModel(b.model));}}function c(b){var p=b.parts,i;if(p){for(i=0;i<p.length;i++){if(!t.getModel(p[i].model)){return false;}}return true;}else{return!!t.getModel(b.model);}}function r(b){if(t.refreshDataState){t.refreshDataState(n,b.binding.getDataState());}b.binding.detachChange(b.modelChangeHandler);if(b.modelRefreshHandler){b.binding.detachRefresh(b.modelRefreshHandler);}b.binding.detachEvents(b.events);b.binding.destroy();delete b.binding;delete b.modelChangeHandler;delete b.dataStateChangeHandler;delete b.modelRefreshHandler;}for(n in this.mBindingInfos){b=this.mBindingInfos[n];if(b.binding&&a(b)){r(b);}if(!b.binding&&c(b)){if(b.factory){this._bindAggregation(n,b);}else{this._bindProperty(n,b);}}}for(n in this.mObjectBindingInfos){b=this.mObjectBindingInfos[n];if(b.binding&&a(b)){r(b);}if(!b.binding&&c(b)){this._bindObject(b);}}};j.prototype.isBound=function(n){return(n in this.mBindingInfos);};j.prototype.getObjectBinding=function(s){return this.mObjectBindingInfos[s]&&this.mObjectBindingInfos[s].binding;};j.prototype.getEventingParent=function(){return this.oParent;};j.prototype.getBinding=function(n){return this.mBindingInfos[n]&&this.mBindingInfos[n].binding;};j.prototype.getBindingPath=function(n){var i=this.mBindingInfos[n];return i&&(i.path||(i.parts&&i.parts[0]&&i.parts[0].path));};j.prototype.setBindingContext=function(c,s){var O=this.oBindingContexts[s];if(O!==c){this.oBindingContexts[s]=c;this.updateBindingContext(false,s);this.propagateProperties(s);this.fireModelContextChange();}return this;};j.prototype.setElementBindingContext=function(c,s){var O=this.mElementBindingContexts[s];if(O!==c){this.mElementBindingContexts[s]=c;this.updateBindingContext(true,s);this.propagateProperties(s);this.fireModelContextChange();}return this;};j.prototype.updateBindingContext=function(s,a,u){var b,c={},e,l,n,p,i;if(u){for(e in this.oModels){if(this.oModels.hasOwnProperty(e)){c[e]=e;}}for(e in this.oPropagatedProperties.oModels){if(this.oPropagatedProperties.oModels.hasOwnProperty(e)){c[e]=e;}}}else{c[a]=a;}for(e in c){if(c.hasOwnProperty(e)){e=e==="undefined"?undefined:e;b=this.getModel(e);p=this.mObjectBindingInfos[e];if(b&&p&&!s){if(!p.binding){this._bindObject(p);}else{l=this._getBindingContext(e);if(l!==p.binding.getContext()){p.binding.setContext(l);}}continue;}l=this.getBindingContext(e);for(n in this.mBindingInfos){var p=this.mBindingInfos[n],r=p.binding,t=p.parts;if(!r){continue;}if(t&&t.length>1){for(i=0;i<t.length;i++){if(t[i].model==e){r.aBindings[i].setContext(l);}}}else if(p.factory){if(p.model==e){r.setContext(l);}}else{if(t[0].model==e){r.setContext(l);}}}}}};j.prototype.getBindingContext=function(s){var a=this.getModel(s),e=this.mElementBindingContexts[s];if(e&&!a){return e;}else if(e&&a&&e.getModel()===a){return e;}else{return this._getBindingContext(s);}};j.prototype._getBindingContext=function(s){var a=this.getModel(s),c=this.oBindingContexts[s],p=this.oPropagatedProperties.oBindingContexts[s];if(c&&!a){return this.oBindingContexts[s];}else if(c&&a&&c.getModel()===a){return this.oBindingContexts[s];}else if(p&&a&&p.getModel()!==a){return undefined;}else{return p;}};j.prototype.setModel=function(a,n){if(!a&&this.oModels[n]){delete this.oModels[n];this.propagateProperties(n);this.updateBindings(false,n);this.fireModelContextChange();}else if(a&&a!==this.oModels[n]){this.oModels[n]=a;this.propagateProperties(n);this.updateBindingContext(false,n);this.updateBindings(false,n);this.fireModelContextChange();}return this;};j.prototype.addPropagationListener=function(l){this.aPropagationListeners.push(l);this.propagateProperties(false);this._callPropagationListener(l);return this;};j.prototype.removePropagationListener=function(l){var a=this.aPropagationListeners;var i=a.indexOf(l);if(i>=0){a.splice(i,1);this.propagateProperties(false);}return this;};j.prototype.getPropagationListeners=function(){return this.oPropagatedProperties.aPropagationListeners.concat(this.aPropagationListeners);};j.prototype._callPropagationListener=function(l){var a;if(l){l(this);}else{a=this.getPropagationListeners();for(var i=0;i<a.length;i++){l=a[i];l(this);}}return this;};j._oEmptyPropagatedProperties={oModels:{},oBindingContexts:{},aPropagationListeners:[]};j.prototype.propagateProperties=function(n){var p=this._getPropertiesToPropagate(),u=n===true,U=n===false,N=u?undefined:n,a,A,i;for(a in this.mAggregations){if(this.mSkipPropagation[a]){continue;}A=this.mAggregations[a];if(A instanceof j){this._propagateProperties(n,A,p,u,N,U);}else if(A instanceof Array){for(i=0;i<A.length;i++){if(A[i]instanceof j){this._propagateProperties(n,A[i],p,u,N,U);}}}}};j.prototype._propagateProperties=function(n,O,p,u,N,U){if(!p){p=this._getPropertiesToPropagate();u=n===true;U=n===false;N=u?undefined:n;}if(O.oPropagatedProperties!==p){O.oPropagatedProperties=p;if(U!==true){O.updateBindings(u,N);O.updateBindingContext(false,N,u);}O.propagateProperties(n);if(U||u){O._callPropagationListener();}O.fireModelContextChange();}};j.prototype._getPropertiesToPropagate=function(){var n=q.isEmptyObject(this.oModels),N=q.isEmptyObject(this.oBindingContexts),b=this.aPropagationListeners.length===0,a=q.isEmptyObject(this.mElementBindingContexts);function c(i,l,p,r){return i?l:q.extend({},l,p,r);}function e(i,l,p){return i?l:l.concat(p);}if(N&&n&&a&&b){return this.oPropagatedProperties;}else{return{oModels:c(n,this.oPropagatedProperties.oModels,this.oModels),oBindingContexts:c((N&&a),this.oPropagatedProperties.oBindingContexts,this.oBindingContexts,this.mElementBindingContexts),aPropagationListeners:e(b,this.oPropagatedProperties.aPropagationListeners,this.aPropagationListeners)};}};j.prototype.getModel=function(n){return this.oModels[n]||this.oPropagatedProperties.oModels[n];};j.prototype.hasModel=function(){return!(q.isEmptyObject(this.oModels)&&q.isEmptyObject(this.oPropagatedProperties.oModels));};j.prototype.clone=function(s,a,O){var c=true,b=true;if(O){c=!!O.cloneChildren;b=!!O.cloneBindings;}if(!s){s=M.uid("clone")||q.sap.uid();}if(!a&&c){a=this.findAggregatedObjects(true).map(function(J){return J.getId();});}var e=this.getMetadata(),n=e._oClass,p=this.getId()+"-"+s,r={},t=this.mProperties,K,N,u,v=j.bindingParser.escape,i;var w=Object.keys(t);i=w.length;while(i>0){K=w[--i];if(!(this.isBound(K)&&b)){if(typeof t[K]==="string"){r[K]=v(t[K]);}else{r[K]=t[K];}}}r["models"]=this.oModels;r["bindingContexts"]=this.oBindingContexts;if(c){for(N in this.mAggregations){var A=this.mAggregations[N];if(e.hasAggregation(N)&&!(this.isBound(N)&&b)){if(A instanceof j){r[N]=A.clone(s,a);}else if(Array.isArray(A)){r[N]=[];for(var i=0;i<A.length;i++){r[N].push(A[i].clone(s,a));}}else{r[N]=A;}}}var x=k(this.getId());for(var i=0,l=x.length;i<l;i++){var y=x[i].clone(s);y.sParentId=p;y.sParentAggregationName=x[i].sParentAggregationName;}for(N in this.mAssociations){var z=this.mAssociations[N];if(Array.isArray(z)){z=z.slice(0);for(var i=0;i<z.length;i++){if(a.indexOf(z[i])>=0){z[i]+="-"+s;}}}else if(a.indexOf(z)>=0){z+="-"+s;}r[N]=z;}}u=new n(p,r);for(N in this.mObjectBindingInfos){u.mObjectBindingInfos[N]=q.extend({},this.mObjectBindingInfos[N]);}for(N in this.mEventRegistry){u.mEventRegistry[N]=this.mEventRegistry[N].slice();}if(b){for(N in this.mBindingInfos){var G=this.mBindingInfos[N];var H=q.extend({},G);if(!G.templateShareable&&G.template&&G.template.clone){H.template=G.template.clone(s,a);delete H.factory;}else if(G.templateShareable===o){G.templateShareable=H.templateShareable=true;q.sap.log.error("During a clone operation, a template was found that neither was marked with 'templateShareable:true' nor 'templateShareable:false'. "+"The framework won't destroy the template. This could cause errors (e.g. duplicate IDs) or memory leaks "+"(The template is used in aggregation '"+N+"' of object '"+this.getId()+"')."+"For more information, see documentation under 'Aggregation Binding'.");}delete H.binding;delete H.modelChangeHandler;delete H.dataStateChangeHandler;delete H.modelRefreshHandler;if(G.factory||G.template){u.bindAggregation(N,H);}else{u.bindProperty(N,H);}}}if(j._supportInfo){j._supportInfo.addSupportInfo(u.getId(),j._supportInfo.byId(this.getId()));}if(this._cloneMetadataContexts){this._cloneMetadataContexts(u);}return u;};j._handleLocalizationChange=function(p){var i;if(p===1){q.each(this.oModels,function(n,a){if(a&&a._handleLocalizationChange){a._handleLocalizationChange();}});}else if(p===2){q.each(this.mBindingInfos,function(n,b){var a=b.parts;if(a){for(i=0;i<a.length;i++){if(b.type&&b.type._handleLocalizationChange){b.type._handleLocalizationChange();}}if(b.modelChangeHandler){b.modelChangeHandler();}}});}};j.prototype.findAggregatedObjects=function(r,c){var A=[];if(c&&typeof c!=="function"){c=null;}function b(O){var a,i,n;for(n in O.mAggregations){a=O.mAggregations[n];if(Array.isArray(a)){for(i=0;i<a.length;i++){if(!c||c(a[i])){A.push(a[i]);}if(r){b(a[i]);}}}else if(a instanceof j){if(!c||c(a)){A.push(a);}if(r){b(a);}}}}b(this);return A;};j._defaultContextualSettings={};return j;});
