/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/Device","sap/ui/documentation/sdk/controller/BaseController","sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/controller/util/ControlsInfo","sap/ui/documentation/sdk/util/ToggleFullScreenHandler","sap/uxap/ObjectPageSubSection","sap/ui/documentation/sdk/controller/util/JSDocUtil"],function(q,D,B,J,C,T,O,a){"use strict";return B.extend("sap.ui.documentation.sdk.controller.ApiDetail",{METHOD:'method',EVENT:'event',PARAM:'param',NOT_AVAILABLE:'N/A',ANNOTATIONS_LINK:'http://docs.oasis-open.org/odata/odata/v4.0/odata-v4.0-part3-csdl.html',ANNOTATIONS_NAMESPACE_LINK:'http://docs.oasis-open.org/odata/odata/v4.0/errata02/os/complete/vocabularies/',ANNOTATION_DESCRIPTION_STRIP_REGEX:/<i>XML[\s\S].*Example/,_baseTypes:["sap.ui.core.any","sap.ui.core.object","sap.ui.core.function","sap.ui.core.number","sap.ui.core.float","sap.ui.core.int","sap.ui.core.boolean","sap.ui.core.string","sap.ui.core.URI","sap.ui.core.ID","sap.ui.core.void","sap.ui.core.CSSSize","null","any","object","object[]","object|object[]","function","float","int","boolean","string","string[]","number"],onInit:function(){this._objectPage=this.byId("apiDetailObjectPage");this.getRouter().getRoute("apiId").attachPatternMatched(this._onTopicMatched,this);this.getView().attachBrowserEvent("click",this.onJSDocLinkClick,this);this.setModel(new J(),"topics");this.setModel(new J(),"constructorParams");this.setModel(new J(),'methods');this.setModel(new J(),'events');this.setModel(new J(),"entity");this.setModel(new J(),"borrowedMethods");this.setModel(new J(),"borrowedEvents");this.getView().byId("apiDetailObjectPage").attachEvent("onAfterRenderingDOMReady",function(){q.sap.delayedCall(250,this,function(){this._scrollToEntity(this._sEntityType,this._sEntityId);});},this);},onAfterRendering:function(){this._createMethodsSummary();this._createEventsSummary();this._createAnnotationsSummary();},onExit:function(){this.getView().detachBrowserEvent("click",this.onJSDocLinkClick,this);},onSampleLinkPress:function(e){var E=e.getSource().data("name");this.getRouter().navTo("entity",{id:E,part:"samples"},true);},onToggleFullScreen:function(e){T.updateMode(e,this.getView(),this);},onJSDocLinkClick:function(e){var r="apiId",c=this.getOwnerComponent(),l=c.getModel("libsData").getData(),t=e.target,s=t.getAttribute("data-sap-ui-target"),m="",n;if(!s&&t.getAttribute("href")==="#"){s=t.getAttribute("target");}if(!s){return;}if(s.indexOf('/')>=0){n=s.split('/');if(n[0]===this._sTopicid&&n[1]===this._sEntityType&&n[2]===this._sEntityId){this._scrollToEntity(n[1],n[2]);}else{c.getRouter().navTo(r,{id:n[0],entityType:n[1],entityId:n[2]},false);}}else if(!l[s]){m=s.slice(s.lastIndexOf('.')+1);s=s.slice(0,s.lastIndexOf("."));c.getRouter().navTo(r,{id:s,entityType:"methods",entityId:m},false);}else{c.getRouter().navTo(r,{id:s},false);}e.preventDefault();},_onTopicMatched:function(e){var A=this.byId("apiDetailObjectPage"),c=this.getOwnerComponent();this._sTopicid=e.getParameter("arguments").id;this._sEntityType=e.getParameter("arguments").entityType;this._sEntityId=e.getParameter("arguments").entityId;c.loadVersionInfo().then(c.fetchAPIInfoAndBindModels.bind(c)).then(function(){A._suppressLayoutCalculations();this._bindData(this._sTopicid);this._bindEntityData(this._sTopicid);this._createMethodsSummary();this._createEventsSummary();this._createAnnotationsSummary();A._resumeLayoutCalculations();if(this._sEntityType){this._scrollToEntity(this._sEntityType,this._sEntityId);}else{this._scrollContentToTop();}setTimeout(this._prettify,0);this.searchResultsButtonVisibilitySwitch(this.getView().byId("apiDetailBackToSearch"));}.bind(this));},_prettify:function(){q('pre').addClass('prettyprint');window.prettyPrint();},_createMethodsSummary:function(){var s=sap.ui.xmlfragment(this.getView().getId()+"-methodsSummary","sap.ui.documentation.sdk.view.ApiDetailMethodsSummary",this);var S=this.getView().byId("methods");var b=S.getSubSections();if(b.length>0&&b[0].getTitle()==="Summary"){return;}S.insertSubSection(new O({title:"Summary",blocks:[s]}),0);},_createEventsSummary:function(){var s=sap.ui.xmlfragment(this.getView().getId()+"-eventsSummary","sap.ui.documentation.sdk.view.ApiDetailEventsSummary",this);var S=this.getView().byId("events");var b=S.getSubSections();if(b.length>0&&b[0].getTitle()==="Summary"){return;}S.insertSubSection(new O({title:"Summary",blocks:[s]}),0);},_createAnnotationsSummary:function(){var s=sap.ui.xmlfragment(this.getView().getId()+"-annotationsSummary","sap.ui.documentation.sdk.view.ApiDetailAnnotationsSummary",this);var S=this.getView().byId("annotations");var b=S.getSubSections();if(b.length>0&&b[0].getTitle()==="Summary"){return;}S.insertSubSection(new O({title:"Summary",blocks:[s]}),0);},scrollToMethod:function(e){var l=e.getSource();this._scrollToEntity("methods",l.getText());},scrollToEvent:function(e){var l=e.getSource();this._scrollToEntity("events",l.getText());},scrollToAnnotation:function(e){var l=e.getSource();this._scrollToEntity("annotations",l.getText());},_scrollToEntity:function(s,S){var o=this.getView().byId(s);if(!o){return;}var b=o.getSubSections();var f=b.filter(function(c){return c.getTitle()===S;});if(f.length){this.getView().byId("apiDetailObjectPage").scrollToSection(f[0].getId(),250);}},_scrollContentToTop:function(){if(this._objectPage&&this._objectPage.$().length>0){this._objectPage.getScrollDelegate().scrollTo(0,0);}},_bindEntityData:function(t){C.loadData().then(function(c){var e=this._getEntityData(t,c);this.getModel("entity").setData(e,false);}.bind(this));},_bindData:function(t){var l=this.getOwnerComponent().getModel("libsData").getData(),c=l[t],b=this.getOwnerComponent().getModel("treeData").getData(),d=this._getControlChildren(b,t),m,o={parameters:[]},e,M={methods:[]},f,E={events:[]},u;if(d){if(!c){c={};}c.controlChildren=d;this._addChildrenDescription(l,c.controlChildren);}u=c['ui5-metadata'];this.getView().byId('apiDetailPage').setBusy(false);this.getView().byId('apiDetailObjectPage').setVisible(true);if(c.controlChildren){c.hasChildren=true;}else{c.hasChildren=false;}if(c.hasOwnProperty('properties')&&this.hasPublicElement(c.properties)){c.hasProperties=true;}else{c.hasProperties=false;}c.hasConstructor=c.hasOwnProperty('constructor');if(u&&u.properties&&this.hasPublicElement(u.properties)){c.hasControlProperties=true;}else{c.hasControlProperties=false;}if(c&&c.events){c.hasEvents=true;}else{c.hasEvents=false;}c.hasMethods=c.hasOwnProperty('methods')&&this.hasPublicElement(c.methods);if(u&&u.associations&&this.hasPublicElement(u.associations)){c.hasAssociations=true;}else{c.hasAssociations=false;}if(u&&u.aggregations&&this.hasPublicElement(u.aggregations)){c.hasAggregations=true;}else{c.hasAggregations=false;}if(u&&u.specialSettings&&this.hasPublicElement(u.specialSettings)){c.hasSpecialSettings=true;}else{c.hasSpecialSettings=false;}if(u&&u.annotations&&Object.keys(u.annotations).length>0){if(!c.hasAnnotations){u.annotations.unshift({});}c.hasAnnotations=true;}else{c.hasAnnotations=false;}if(c.hasConstructor&&c.constructor.parameters){for(var i=0;i<c.constructor.parameters.length;i++){this.subParamPhoneName=c.constructor.parameters[i].name;o.parameters=o.parameters.concat(this._getParameters(c.constructor.parameters[i]));}this.subParamPhoneName='';}if(c.hasMethods){M.methods=this.buildMethodsModel(c.methods);}if(c.hasEvents){E.events=this.buildEventsModel(c.events);}c.borrowed=this.buildBorrowedModel(t,l,c.methods);if(c.implements&&c.implements.length){c.implementsParsed=c.implements.map(function(g,h,j){var k=g.split("."),s=k[k.length-1];return{href:g,name:s,isLast:h===j.length-1};});c.hasImplementsData=true;}else{c.hasImplementsData=false;}c.isClass=c.kind==="class";c.isDerived=!!c.extends;c.extendsText=c.extends||this.NOT_AVAILABLE;c.sinceText=c.since||this.NOT_AVAILABLE;c.module=c.module||this.NOT_AVAILABLE;f=this.getModel("methods");e=this.getModel("borrowedMethods");f.setSizeLimit(1000);e.setSizeLimit(1000);this.getModel("topics").setSizeLimit(1000);this.getModel("topics").setData(c,false);this.getModel("constructorParams").setData(o,false);f.setData(M,false);f.setDefaultBindingMode("OneWay");this.getModel('events').setData(E,false);this.getModel('events').setDefaultBindingMode("OneWay");e.setData(c.borrowed.methods,false);this.getModel('borrowedEvents').setData(c.borrowed.events,false);if(this.extHookbindData){this.extHookbindData(t,m);}this.getView().findAggregatedObjects(true,function(g){if(g instanceof sap.ui.codeeditor.CodeEditor){g._getEditorInstance().focus=function(){};}});},_getControlChildren:function(t,s){for(var i=0;i<t.length;i++){if(t[i].name===s){return t[i].nodes;}}},_addChildrenDescription:function(l,c){for(var i=0;i<c.length;i++){c[i].description=l[c[i].name].description;c[i].link="{@link "+c[i].name+"}";}},_getEntityData:function(e,c){var f=c.entities.filter(function(b){return b.id===e;});var E=f.length?f[0]:undefined;var A=this._getControlComponent(e,c);return{appComponent:A||this.NOT_AVAILABLE,sample:(E&&e)||this.NOT_AVAILABLE,hasSample:!!(E&&E.sampleCount>0)};},buildMethodsModel:function(m){var I=this.getModel("versionData").getProperty("/isInternal");if(!m.length){return m;}var r=m.filter(function(b){return I?true:b.visibility!=="restricted";}).map(function(b){var s=[];b.parameters=b.parameters||[];b.parameters=b.parameters.map(function(p){var c,d;var t=(p.type||"").split("|");p.types=[];for(var i=0;i<t.length;i++){p.types.push({value:t[i],isLast:i===t.length-1});}if(p.parameterProperties&&!b.subParametersInjected){c=p.parameterProperties;for(var e in c){d=(c[e].type||"").split("|");c[e].types=[];c[e].types=d.map(function(f,g,h){return{value:f,isLast:g===h.length-1};});c[e].isSubProperty=true;c[e].phoneName=p.name+'.'+c[e].name;s.push(c[e]);}}return p;});if(b.returnValue){var t=(b.returnValue.type||"").split("|");b.returnValue.types=[];for(var i=0;i<t.length;i++){b.returnValue.types.push({value:t[i],isLast:i===t.length-1});}}if(!b.subParametersInjected){b.parameters=b.parameters.concat(s);b.subParametersInjected=true;}return b;});r.unshift({});return r;},buildBorrowedModel:function(t,l,m){var b,c,s,d,o,M;d={methods:[],events:[]};s=l[t]?l[t].extends:"";var v=function(i){return i.visibility==="public";};m=m||[];M=m.map(function(g){return g.name;});var f=function(i){return M.indexOf(i.name)===-1;};var e=function(i){return{name:i.name,link:"#/api/"+s+"/methods/"+i.name};};var E=function(i){return{name:i.name,link:"#/api/"+s+"/events/"+i.name};};while(s){o=l[s];if(!o){break;}b=(o.methods||[]).filter(v).filter(f).map(e);if(b.length){d.methods.push({name:s,methods:b});}c=(o.events||[]).filter(v).map(E);if(c.length){d.events.push({name:s,events:c});}s=o.extends;}return d;},buildEventsModel:function(e){if(e.length===0){return e;}var r=e.map(function(b){if(b.parameters&&!b.subParametersInjected){var p=[];b.parameters.map(function(P){this.subParamPhoneName=P.name;p=p.concat(this._getParameters(P));},this);this.subParamPhoneName='';b.parameters=p;b.subParametersInjected=true;}return b;},this);r.unshift({});return r;},subParamLevel:0,subParamPhoneName:'',_getParameters:function(p){var r=[p];var t=(p.type||"").split("|"),b;p.types=[];for(var i=0;i<t.length;i++){p.types.push({value:t[i],isLast:i===t.length-1});}if(p.parameterProperties){this.subParamLevel++;for(var s in p.parameterProperties){var c='is';for(var i=0;i<this.subParamLevel;i++){c+='Sub';}c+='Property';this.subParamPhoneName+='.'+s;p.parameterProperties[s][c]=true;p.parameterProperties[s].phoneName=this.subParamPhoneName;b=(p.parameterProperties[s].type||"").split("|");p.parameterProperties[s].types=[];p.parameterProperties[s].types=b.map(function(d,e,f){return{value:d,isLast:e===f.length-1};});r=r.concat(this._getParameters(p.parameterProperties[s]));if(this.subParamPhoneName.indexOf('.')>-1){this.subParamPhoneName=this.subParamPhoneName.substring(0,this.subParamPhoneName.lastIndexOf('.'));}else{this.subParamPhoneName='';}}this.subParamLevel--;}return r;},formatSubtitle:function(d){var r="";if(d){r+="Deprecated in version: "+d.since;}return r;},formatConstructor:function(n,p){var r='new ';if(n){r+=n+'(';}if(p){p.forEach(function(e,i,b){r+=e.name;if(e.optional){r+='?';}if(i<b.length-1){r+=', ';}});}if(n){r+=')';}return r;},_formatChildDescription:function(d){if(d){d=this._extractFirstSentence(d);d=this._wrapInSpanTag(d);return"<div>"+d+"<\div>";}},_extractFirstSentence:function(d){var b=d.slice(),s;if(d.lastIndexOf("}")>d.lastIndexOf(".")){return"";}b=this._sliceSpecialTags(b,"{","}");b=this._sliceSpecialTags(b,"<code>","</code>");s=d.length-b.length;d=d.slice(0,b.indexOf(".")+".".length+s);return d;},_sliceSpecialTags:function(d,s,e){var b,c;while(d.indexOf(s)!==-1&&d.indexOf(s)<d.indexOf(".")){b=d.indexOf(s);c=d.indexOf(e);d=d.slice(0,b)+d.slice(c+e.length,d.length);}return d;},formatDefaultValue:function(d){switch(d){case null:return'';case undefined:return'';case'':return'empty string';default:return d;}},formatEntityName:function(n,c,s){return(s===true)?c+"."+n:n;},formatDeprecated:function(s,d,e){var r;if(d){d=d.replace(/{@link\s+([^}\s]+)(?:\s+([^}]*))?}|<code>(\S+)<\/code>/gi,function(m,E,n,c){var t;if(c){return['<em>',c,'</em>'].join("");}else{if(e){E=E[0]==="#"?E.substring(1,E.length):E;t=[this._sTopicid,"/",e,"/",E].join("");}else{t=E;}return['<a target="',t,'" href="#">',(n?n:E),'</a>'].join("");}}.bind(this));}r=["Deprecated"];if(s){r.push(" since "+s);}if(d){r.push(". "+d);}return r.join("");},formatMethodDeprecated:function(s,d){return this.formatDeprecated(s,d,"methods");},formatEventDeprecated:function(s,d){return this.formatDeprecated(s,d,"events");},formatDescription:function(d,b,c){if(!d&&!b&&!c){return"";}var r=d||"";if(c||b){r+="<span class=\"sapUiDocumentationDeprecated\">";if(c){r+='<br/>Deprecated since version '+c+'.';}if(b){if(c){r+=' '+b;}else{r+='<br/>'+b;}}r+="</span>";}r=this._wrapInSpanTag(r);return r;},formatDescriptionSince:function(d,s){var r=d||"";if(s){r+='<br/><br/><i>Since: '+s+'.</i>';}r=this._wrapInSpanTag(r);return r;},formatAnnotationDescription:function(d,s){var r=d||"";r+='<br/>For more information, see '+'<a target="_blank" href="'+this.ANNOTATIONS_LINK+'">OData v4 Annotations</a>';if(s){r+='<br/><br/><i>Since: '+s+'.</i>';}r=this._wrapInSpanTag(r);return r;},formatAnnotationDescriptionSummary:function(d){var r=d||"";r=r.split(this.ANNOTATION_DESCRIPTION_STRIP_REGEX)[0];r=this._wrapInSpanTag(r);return r;},formatAnnotationTarget:function(t){var r="";if(t){t.forEach(function(e){r+=e+'<br/>';});}r=this._wrapInSpanTag(r);return r;},formatAnnotationNamespace:function(n){var r,N=n.split(".");if(N[0]==="Org"&&N[1]==="OData"){r='<a target="_blank" href="'+this.ANNOTATIONS_NAMESPACE_LINK+n+'.xml">'+n+'</a>';}else{r=n;}r=this._wrapInSpanTag(r);return r;},hasPublicElement:function(e){for(var i=0;i<e.length;i++){if(e[i].visibility==='public'){return true;}}return false;},formatEventsName:function(e){return e?e.name:"";},formatEventsParam:function(e){if(e&&e.type!=this.EVENT){return e.name;}else{return"";}},formatMethodCode:function(n,p,r){var b=n+'(';if(p&&p.length>0){p.forEach(function(e,i,c){if(e.isSubProperty||e.isSubSubProperty){return;}b+=e.name;if(e.optional){b+='?';}if(i<c.length-1){b+=', ';}});}b+=') : ';if(r){b+=r.type;}else{b+='void';}return b;},formatMethodsParam:function(m){if(m&&m.type!=this.METHOD){return m.name;}else{return"";}},formatLinkEnabled:function(l){return this._baseTypes.indexOf(l)===-1;},formatEventClassName:function(i,b,p){if(p&&(i||b)){return"sapUiDocumentationParamPhone";}else if(b){return"sapUiDocumentationParamSubSub";}else if(i){return"sapUiDocumentationParamSub";}else{return"sapUiDocumentationParamBold";}},formatMethodClassName:function(i,p){if(p&&i){return"sapUiDocumentationParamPhone";}else if(i){return"sapUiDocumentationParamSub";}else{return"sapUiDocumentationParamBold";}},onTypeLinkPress:function(e){var t=e.getSource().getText();t=t.replace('[]','');this.getRouter().navTo("apiId",{id:t},true);},onAnnotationsLinkPress:function(e){this._scrollToEntity("annotations","Summary");},backToSearch:function(){this.onNavBack();},_wrapInSpanTag:function(t){var b=this.getModel('topics').oData,c=b.name||"",d=b.methods||[];var f=a.formatTextBlock(t,{linkFormatter:function(e,g){var h,H,i;g=g||e;if(e.match("://")){return'<a target="_blank" href="'+e+'">'+g+'</a>';}e=e.trim().replace(/\.prototype\./g,"#");h=e.indexOf('#');H=e.indexOf('#.');i=e.indexOf('#event:');if(h===-1){var l=e.lastIndexOf('.'),j=e.substring(l+1),k=d.filter(function(m){if(m.name===j){return m;}})[0];if(k){if(k.static===true){e=c+'/methods/'+e;}else{e=c+'/methods/'+j;}}}if(H===0){e=e.slice(2);e=c+'/methods/'+c+'.'+e;}else if(i===0){e=e.slice('#event:'.length);e=c+'/events/'+e;}else if(h===0){e=e.slice(1);e=c+'/methods/'+e;}if(h>0){e=e.replace('#','/methods/');}return"<a class=\"jsdoclink\" href=\"javascript:void(0);\" data-sap-ui-target=\""+e+"\">"+g+"</a>";}});return'<span class="sapUiDocumentationJsDoc">'+f+'</span>';}});});
