/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/Device","sap/ui/documentation/sdk/controller/BaseController","sap/ui/documentation/sdk/controller/util/APIInfo","sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/controller/util/ControlsInfo","sap/m/GroupHeaderListItem","sap/ui/core/Component","sap/ui/model/Filter","sap/ui/model/Sorter","jquery.sap.storage"],function(q,D,B,A,J,C,G,a,F,S,Q){"use strict";return B.extend("sap.ui.documentation.sdk.controller.ControlsMaster",{_oStorage:Q.sap.storage(Q.sap.storage.Type.local),_sStorageKey:"UI5_EXPLORED_LIST_SETTINGS_FROM_1_48",_oViewSettings:{compactOn:false,themeActive:"sap_belize",rtl:false},_oDefaultSettings:{compactOn:false,themeActive:"sap_belize",rtl:false},_oListSettings:{filter:{},groupProperty:"category",groupDescending:false,version:q.sap.Version(sap.ui.version).getMajor()+"."+q.sap.Version(sap.ui.version).getMinor()},_mGroupFunctions:{"name":function(c){var k=c.getProperty("name").charAt(0);return{key:k,text:k};},"namespace":true,"category":true,"since":true,"formFactors":true},_sFilterValue:"",onInit:function(){var e,d,f,o=function(c){this._oView.getModel().setData({entityCount:c.entityCount,entities:c.entities});this.getModel("filter").setData(c.filter);this._toggleListItem(this._getItemToSelect(),true);}.bind(this);this._oRouter=this.getRouter();this._bNavToEntityViaList=false;this._oView=this.getView();C.loadData().then(o);e=new J();e.setSizeLimit(100000);this._oView.setModel(e);d=new J({listMode:(D.system.phone)?"None":"SingleSelectMaster",listItemType:(D.system.phone)?"Active":"Inactive"});d.setDefaultBindingMode("OneWay");this._oView.setModel(d,"viewModel");f=new J();f.setSizeLimit(100000);this.setModel(f,"filter");this._vsFilterBar=this._oView.byId("vsFilterBar");this._vsFilterLabel=this._oView.byId("vsFilterLabel");this._oRouter.getRoute("group").attachPatternMatched(this._onGroupMatched,this);this._oRouter.getRoute("entity").attachPatternMatched(this._onEntityMatched,this);this._oRouter.getRoute("sample").attachPatternMatched(this._onSampleMatched,this);this._oRouter.getRoute("code").attachPatternMatched(this._onSampleMatched,this);this._oRouter.getRoute("controls").attachPatternMatched(this._onControlsMatched,this);this._oRouter.getRoute("controlsMaster").attachPatternMatched(this._onControlsMasterMatched,this);this.LIST_SCROLL_DURATION=0;this._iDomRenderingDelay=0;this._getList().addEventDelegate({onAfterRendering:function(){q.sap.delayedCall(this._iDomRenderingDelay,this,this._scrollToSelectedListItem);}},this);this._oCore.attachThemeChanged(this._scrollToSelectedListItem,this);this._oCore.attachLocalizationChanged(this._onLocalizationChange,this);this._oView.addEventDelegate({onBeforeFirstShow:this.onBeforeFirstShow.bind(this)});this._oComponent=this.getOwnerComponent();this._oRootView=this.getRootView();this._oViewSettings.compactOn=this._oComponent.getContentDensityClass()==="sapUiSizeCompact"&&this._oRootView.hasStyleClass("sapUiSizeCompact");this._oViewSettings.rtl=this._oCore.getConfiguration().getRTL();this._oDefaultSettings.compactOn=this._oViewSettings.compactOn;this._oDefaultSettings.rtl=this._oViewSettings.rtl;this._initListSettings();},_viewSettingsResetOnNavigation:function(e){var r=e.getParameter("name");if(["group","entity","sample","code","code_file","controls","controlsMaster"].indexOf(r)===-1){this._applyAppConfiguration(this._oDefaultSettings.themeActive,this._oDefaultSettings.compactOn,this._oDefaultSettings.rtl);this.getRouter().detachBeforeRouteMatched(this._viewSettingsResetOnNavigation,this);}},_initListSettings:function(){var j=this._oStorage.get(this._sStorageKey);if(j){this._oListSettings=JSON.parse(j);}},_applyAppConfiguration:function(t,c,r){var s,$,o,b;this._oCore.applyTheme(t);this._oRootView.toggleStyleClass("sapUiSizeCompact",c).toggleStyleClass("sapUiSizeCozy",!c);this._oCore.getConfiguration().setRTL(r);if(this._oComponent._oCurrentOpenedSample){o=this._oComponent._oCurrentOpenedSample.getComponentInstance().getRootControl();if(o){b=o.getContent()[0];if(b){b.invalidate();}}}$=q("#sampleFrame");if($.length>0){s=$[0].contentWindow;if(s){s.sap.ui.getCore().applyTheme(t);s.sap.ui.getCore().getConfiguration().setRTL(r);s.jQuery('body').toggleClass("sapUiSizeCompact",c).toggleClass("sapUiSizeCozy",!c);}}},_onGroupMatched:function(e){this._onMatched('#/group/',e);},_onEntityMatched:function(e){this._onMatched('#/entity/',e);},_onSampleMatched:function(e){this._onMatched('#/sample/',e);},_onMatched:function(n,e){var E=this._getList().getModel(),s=e.getParameter("arguments").id;this.showMasterSide();this._topicId=n+s;this._entityId=s;E.refresh();this._updateListSelection();},_onControlsMasterMatched:function(e){this.showMasterSide();if(!D.system.phone){this.getRouter().navTo("controls");}},_onControlsMatched:function(){this.showMasterSide();this._resetListSelection();},_onLocalizationChange:function(e){this._iDomRenderingDelay=3000;q.sap.delayedCall(this._iDomRenderingDelay,this,function(){this._iDomRenderingDelay=0;});},onNavToEntity:function(e){var i=e.getParameter("listItem"),I=(i)?i:e.getSource(),p=I.getBindingContext().getPath(),E=this.getView().getModel().getProperty(p),r=!D.system.phone;this._bNavToEntityViaList=true;this.getRouter().navTo("entity",{id:E.id,part:"samples"},r);},getGroupHeader:function(g){return new G({title:g.key,upperCase:false});},_updateListSelection:function(){var i=this._getItemToSelect();if(!i){return;}this._toggleListItem(i,true);if(!this._bNavToEntityViaList){q.sap.delayedCall(0,this,this._scrollToSelectedListItem);}this._bNavToEntityViaList=false;},_resetListSelection:function(){var s=this._getList().getSelectedItem();if(s){this._toggleListItem(s,false);q.sap.delayedCall(0,this,this._scrollPageTo,[0,0]);}},_toggleListItem:function(i,s){this._getList().setSelectedItem(i,s,false);},_scrollToSelectedListItem:function(){var i=this._getList().getSelectedItem();if(i){this._getPage().scrollToElement(i,this.LIST_SCROLL_DURATION);}},_scrollPageTo:function(p,d){this._getPage().scrollTo(p,d);},_getItemToSelect:function(){var l=this._getList(),e=l.getModel(),E,i,I,L=this._entityId,o=null;l.getItems().forEach(function(b){i=b.getBindingContext();if(i){I=i.getPath();E=e.getProperty(I);if(E.id===L){o=b;return false;}}});return o;},_getPage:function(){if(!this.oPage){this.oPage=this.byId("exploredMasterPage");}return this.oPage;},_getList:function(){if(!this.oList){this.oList=this.byId("exploredMasterList");}return this.oList;},onBeforeFirstShow:function(){this._updateView();},onExit:function(){this._oCore.detachThemeChanged(this._scrollToSelectedListItem,this);this._oCore.detachLocalizationChanged(this._onLocalizationChange,this);},onConfirmViewSettings:function(e){var g=e.getParameter("groupItem");this._oListSettings.filter=e.getParameter("filterCompoundKeys");this._oListSettings.groupProperty=g?g.getKey():null;this._oListSettings.groupDescending=e.getParameter("groupDescending");this._oStorage.put(this._sStorageKey,JSON.stringify(this._oListSettings));this._updateView();},handleListSettings:function(){if(!this._oVSDialog){this._oVSDialog=sap.ui.xmlfragment(this.getView().getId(),"sap.ui.documentation.sdk.view.viewSettingsDialog",this);this.getView().addDependent(this._oVSDialog);}this._oVSDialog.setSelectedFilterCompoundKeys(this._oListSettings.filter);this._oVSDialog.setSelectedGroupItem(this._oListSettings.groupProperty);this._oVSDialog.setGroupDescending(this._oListSettings.groupDescending);this._oVSDialog.toggleStyleClass("sapUiSizeCompact",this._oViewSettings.compactOn).toggleStyleClass("sapUiSizeCozy",!this._oViewSettings.compactOn);this._oVSDialog.open();},handleListFilter:function(e){this._sFilterValue=e.getParameter("newValue").trim();this._updateView();},_updateListBinding:function(){var f,s,b=[],c=[],d=false,g=false,l=this._oView.byId("exploredMasterList"),o=l.getBinding("items");d=true;b.push(new F("searchTags","Contains",this._sFilterValue));q.each(this._oListSettings.filter,function(p,v){var P=[];q.each(v,function(k,V){var O=(p==="formFactors")?"Contains":"EQ";P.push(new F(p,O,k));});d=true;b.push(new F(P,false));});if(d&&b.length===0){o.filter(b,"Application");}else if(d&&b.length>0){f=new F(b,true);o.filter(f,"Application");}if(this._oListSettings.groupProperty&&this._oListSettings.groupProperty!==this._sCurrentGroup){g=true;}else if(this._oListSettings.groupProperty&&this._oListSettings.groupDescending!==this._bCurrentlyGroupedDescending){g=true;}if(g){s=new S(this._oListSettings.groupProperty,this._oListSettings.groupDescending,this._mGroupFunctions[this._oListSettings.groupProperty]);c.push(s);c.push(new S("name",false));o.sort(c);}this._sCurrentGroup=this._oListSettings.groupProperty;this._bCurrentlyGroupedDescending=this._oListSettings.groupDescending;this._bIsViewUpdatedAtLeastOnce=true;},_updateView:function(){this._updateFilterBarDisplay();this._updateListBinding();},_updateFilterBarDisplay:function(){var f=[];q.each(this._oListSettings.filter,function(p,v){f=f.concat(Object.keys(v));});if(f.length>0){this._vsFilterBar.setVisible(true);this._vsFilterLabel.setText(f.join(", "));}else{this._vsFilterBar.setVisible(false);}},handleSettings:function(){if(!this._oSettingsDialog){this._oSettingsDialog=new sap.ui.xmlfragment("sap.ui.documentation.sdk.view.appSettingsDialog",this);this._oView.addDependent(this._oSettingsDialog);}q.sap.delayedCall(0,this,function(){var o=this._oCore.getConfiguration(),t=this._oCore.byId("ThemeSelect"),u=q.sap.getUriParameters().get("sap-theme"),c=this._oViewSettings.compactOn;t.setSelectedKey(u?u:o.getTheme());this._oCore.byId("RTLSwitch").setState(o.getRTL());this._oCore.byId("CompactModeSwitch").setState(c);this._oSettingsDialog.toggleStyleClass("sapUiSizeCompact",c).toggleStyleClass("sapUiSizeCozy",!c);this._oSettingsDialog.open();});},handleCloseAppSettings:function(){this._oSettingsDialog.close();},handleSaveAppSettings:function(){var b,c=this._oCore.byId('CompactModeSwitch').getState(),t=this._oCore.byId('ThemeSelect').getSelectedKey(),r=this._oCore.byId('RTLSwitch').getState();this._oSettingsDialog.close();if(!this._oBusyDialog){q.sap.require("sap.m.BusyDialog");b=sap.ui.require("sap/m/BusyDialog");this._oBusyDialog=new b();this.getView().addDependent(this._oBusyDialog);}this._oBusyDialog.open();q.sap.delayedCall(1000,this,function(){this._oBusyDialog.close();});this._oViewSettings.compactOn=c;this._oViewSettings.themeActive=t;this._oViewSettings.rtl=r;this._applyAppConfiguration(t,c,r);this.getRouter().attachBeforeRouteMatched(this._viewSettingsResetOnNavigation,this);}});});
