/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/model/TreeBinding','sap/ui/model/ChangeReason','sap/ui/model/Filter','sap/ui/model/FilterOperator','sap/ui/model/FilterType','sap/ui/model/Sorter','sap/ui/model/odata/CountMode','./odata4analytics','./BatchResponseCollector','./AnalyticalVersionInfo'],function(Q,T,C,F,a,b,S,c,d,B,A){"use strict";var f=T.extend("sap.ui.model.analytics.AnalyticalBinding",{constructor:function(m,p,o,s,e,P){T.call(this,m,p,o,e,P);this.sEntitySetName=(P&&P.entitySet)?P.entitySet:undefined;this.bArtificalRootContext=false;this.aApplicationFilter=this._convertDeprecatedFilterObjects(e);this.aControlFilter=undefined;this.aSorter=s?s:[];this.aMaxAggregationLevel=[];this.aAggregationLevel=[];this.oPendingRequests={};this.oPendingRequestHandle=[];this.oGroupedRequests={};this.bUseBatchRequests=(P&&P.useBatchRequests===true)?true:false;this.bProvideTotalSize=(P&&P.provideTotalResultSize===false)?false:true;this.bProvideGrandTotals=(P&&P.provideGrandTotals===false)?false:true;this.bReloadSingleUnitMeasures=(P&&P.reloadSingleUnitMeasures===false)?false:true;this.bUseAcceleratedAutoExpand=(P&&P.useAcceleratedAutoExpand===false)?false:true;this.bNoPaging=(P&&P.noPaging===true)?true:false;this.iTotalSize=-1;this.mServiceKey={};this.mServiceLength={};this.mServiceFinalLength={};this.mKeyIndex={};this.mFinalLength=this.mServiceFinalLength;this.mLength={};this.mMultiUnitKey={};this.aMultiUnitLoadFactor={};this.bNeedsUpdate=false;this.mEntityKey={};this.sCustomParams=this.oModel.createCustomParams({custom:this.mParameters.custom});this.oAnalyticalQueryResult=null;this.aAnalyticalInfo=[];this.mAnalyticalInfoByProperty={};this.aBatchRequestQueue=[];if(P&&P.countMode==c.None){Q.sap.log.fatal("requested count mode is ignored; OData requests will include $inlinecout options");}else if(P&&(P.countMode==c.Request||P.countMode==c.Both)){Q.sap.log.warning("default count mode is ignored; OData requests will include $inlinecout options");}else if(this.oModel.sDefaultCountMode==c.Request){Q.sap.log.warning("default count mode is ignored; OData requests will include $inlinecout options");}this.iModelVersion=A.getVersion(this.oModel);if(this.iModelVersion===null){Q.sap.log.error("The AnalyticalBinding does not support Models other than sap.ui.model.odata.ODataModel version 1 or 2.");return;}this.aAllDimensionSortedByName=null;this.aInitialAnalyticalInfo=(P==undefined?[]:P.analyticalInfo);this.bInitial=true;}});function t(o,e){return function(){if(!o.__supportUID){o.__supportUID=Q.sap.uid();}return{type:"sap.ui.model.analytics.AnalyticalBinding",analyticalError:e,analyticalBindingId:o.__supportUID};};}f.prototype.setContext=function(o){if(this.oContext!==o){this.oContext=o;this.oDataState=null;if(!this.isRelative()){return;}var r=this.oModel.resolve(this.sPath,this.oContext);if(r){this.resetData();this._initialize();this._fireChange({reason:C.Context});}}};f.prototype.initialize=function(){if(this.oModel.oMetadata&&this.oModel.oMetadata.isLoaded()&&this.isInitial()){var i=this.isRelative();if(!i||(i&&this.oContext)){this._initialize();}this._fireRefresh({reason:C.Refresh});}return this;};f.prototype._initialize=function(){if(this.oModel.oMetadata&&this.oModel.oMetadata.isLoaded()){this.bInitial=false;this.oAnalyticalQueryResult=this.oModel.getAnalyticalExtensions().findQueryResultByName(this._getEntitySet());if(!this.oAnalyticalQueryResult){throw("Error in AnalyticalBinding - The QueryResult '"+this._getEntitySet()+"' could not be retrieved. Please check your service definition.");}this.updateAnalyticalInfo(this.aInitialAnalyticalInfo);this.aAllDimensionSortedByName=this.oAnalyticalQueryResult.getAllDimensionNames().concat([]).sort();this._fireRefresh({reason:C.Refresh});}};f.prototype.getRootContexts=function(p){if(this.isInitial()){return[];}var i=(p&&p.numberOfExpandedLevels?p.numberOfExpandedLevels+1:1);var r=null;var R=this._getRequestId(f._requestType.groupMembersQuery,{groupId:null});if(this.bArtificalRootContext&&!this._cleanupGroupingForCompletedRequest(R)){return r;}r=this._getContextsForParentContext(null);if(r.length==1){return r;}if(i<=1){if(i==1){this._considerRequestGrouping([R,this._getRequestId(f._requestType.groupMembersQuery,{groupId:"/"})]);this.getNodeContexts(this.getModel().getContext("/"),{startIndex:p.startIndex,length:p.length,threshold:p.threshold,level:0,numberOfExpandedLevels:0});}}else{var e=this._prepareGroupMembersAutoExpansionRequestIds("/",p.numberOfExpandedLevels);e.push(R);this._considerRequestGrouping(e);this.getNodeContexts(this.getModel().getContext("/"),{startIndex:p.startIndex,length:p.length,threshold:p.threshold,level:0,numberOfExpandedLevels:p.numberOfExpandedLevels});}if(r.length>1){Q.sap.log.fatal("assertion failed: grand total represented by a single entry");}return r;};f.prototype.getNodeContexts=function(o,p){if(this.isInitial()){return[];}var s,l,i,L,n,e;if(typeof p=="object"){s=p.startIndex;l=p.length;i=p.threshold;L=p.level;n=p.numberOfExpandedLevels;e=p.supressRequest;}else{s=arguments[1];l=arguments[2];i=arguments[3];L=arguments[4];n=arguments[5];e=arguments[6];}var g=this._getContextsForParentContext(o,s,l,i,L,n,e);return g;};f.prototype.ContextsAvailabilityStatus={ALL:2,SOME:1,NONE:0};f.prototype.hasAvailableNodeContexts=function(o,l){var g=this._getGroupIdFromContext(o,l);if(this._getKeys(g)!=undefined){if(this.mFinalLength[g]==true){return f.prototype.ContextsAvailabilityStatus.ALL;}else{return f.prototype.ContextsAvailabilityStatus.SOME;}}else{return f.prototype.ContextsAvailabilityStatus.NONE;}};f.prototype.getGroupSize=function(o,l){if(o===undefined){return 0;}var g=this._getGroupIdFromContext(o,l);return this.mFinalLength[g]?this.mLength[g]:-1;};f.prototype.getTotalSize=function(){if(!this.bProvideTotalSize){Q.sap.log.fatal("total size of result explicitly turned off, but getter invoked");}return+this.iTotalSize;};f.prototype.hasChildren=function(o,p){if(o===undefined){return false;}if(o==null){return true;}var i=p.level;if(i==0){return true;}if(this.aAggregationLevel.length<i){return false;}return Q.inArray(this.aAggregationLevel[i-1],this.aMaxAggregationLevel)<this.aMaxAggregationLevel.length-1;};f.prototype.hasMeasures=function(){var h=false;for(var p in this.oMeasureDetailsSet){if(this.oMeasureDetailsSet.hasOwnProperty(p)){h=true;break;}}return h;};f.prototype.getDimensionDetails=function(){return this.oDimensionDetailsSet;};f.prototype.getMeasureDetails=function(){return this.oMeasureDetailsSet;};f.prototype.providesGrandTotal=function(){return this.bProvideGrandTotals;};f.prototype.getProperty=function(p){if(this.isInitial()){return{};}return this.oAnalyticalQueryResult.getEntityType().findPropertyByName(p);};f.prototype.getFilterablePropertyNames=function(){if(this.isInitial()){return[];}return this.oAnalyticalQueryResult.getEntityType().getFilterablePropertyNames();};f.prototype.getSortablePropertyNames=function(){if(this.isInitial()){return[];}return this.oAnalyticalQueryResult.getEntityType().getSortablePropertyNames();};f.prototype.getPropertyLabel=function(p){if(this.isInitial()){return"";}return this.oAnalyticalQueryResult.getEntityType().getLabelOfProperty(p);};f.prototype.getPropertyHeading=function(p){if(this.isInitial()){return"";}return this.oAnalyticalQueryResult.getEntityType().getHeadingOfProperty(p);};f.prototype.getPropertyQuickInfo=function(p){if(this.isInitial()){return"";}return this.oAnalyticalQueryResult.getEntityType().getQuickInfoOfProperty(p);};f.prototype.isMeasure=function(p){return Q.inArray(p,this.aMeasureName)!==-1;};f.prototype.filter=function(e,s){if(!e){e=[];}if(e instanceof F){e=[e];}e=this._convertDeprecatedFilterObjects(e);if(s==b.Application){this.aApplicationFilter=e;}else{this.aControlFilter=e;}this.iTotalSize=-1;this._abortAllPendingRequests();this.resetData();this._fireRefresh({reason:C.Filter});return this;};f.prototype.sort=function(s){if(s instanceof S){s=[s];}this.aSorter=s?s:[];this._abortAllPendingRequests();this.resetData(undefined,{reason:C.Sort});this._fireRefresh({reason:C.Sort});return this;};f.prototype.getGroupName=function(o,l){if(o===undefined){return"";}var g=this.aAggregationLevel[l-1],D=this.oAnalyticalQueryResult.findDimensionByPropertyName(g),v=this.mAnalyticalInfoByProperty[g]&&this.mAnalyticalInfoByProperty[g].formatter,p=o.getProperty(g),e,s,G;if(D&&this.oDimensionDetailsSet[g].textPropertyName){e=D.getTextProperty();}var h,i,j;if(e){h=D.getTextProperty().name;j=this.mAnalyticalInfoByProperty[h]&&this.mAnalyticalInfoByProperty[h].formatter;i=o.getProperty(h);}if(!e){s=v?v(p):p;G=((D.getLabelText())?D.getLabelText()+': ':'')+s;}else{s=v?v(p,i):p;G=((D.getLabelText())?D.getLabelText()+': ':'')+s;var k=j?j(i,p):i;if(k){G+=' - '+k;}}return G;};f.prototype.updateAnalyticalInfo=function(e,g){if(!this.oModel.oMetadata||!this.oModel.oMetadata.isLoaded()||this.isInitial()){this.aInitialAnalyticalInfo=e;return;}if(Q.sap.equal(this._aLastChangedAnalyticalInfo,e)){if(g){setTimeout(function(){this._fireChange({reason:C.Change});}.bind(this),0);}return;}this._aLastChangedAnalyticalInfo=[];for(var j=0;j<e.length;j++){this._aLastChangedAnalyticalInfo[j]=Q.extend({},e[j]);}var p=this.oDimensionDetailsSet;this.mAnalyticalInfoByProperty={};this.aMaxAggregationLevel=[];this.aAggregationLevel=[];this.aMeasureName=[];if(this.iAnalyticalInfoVersionNumber==undefined){this.iAnalyticalInfoVersionNumber=1;}else if(this.iAnalyticalInfoVersionNumber>999){this.iAnalyticalInfoVersionNumber=1;}else{this.iAnalyticalInfoVersionNumber=this.iAnalyticalInfoVersionNumber+1;}this.oMeasureDetailsSet={};this.oDimensionDetailsSet={};for(var i=0;i<e.length;i++){var D=this.oAnalyticalQueryResult.findDimensionByPropertyName(e[i].name);if(D&&(e[i].inResult==true||e[i].visible==true)){e[i].dimensionPropertyName=D.getName();var o=this.oDimensionDetailsSet[D.getName()];if(!o){o={};o.name=D.getName();o.aAttributeName=[];o.grouped=false;this.oDimensionDetailsSet[D.getName()]=o;this.aMaxAggregationLevel.push(o.name);if(e[i].grouped==true){this.aAggregationLevel.push(o.name);}}if(e[i].grouped==true){if(Q.inArray(D.getName(),this.getSortablePropertyNames())==-1){Q.sap.log.fatal("property "+D.getName()+" must be sortable in order to be used as grouped dimension");}o.grouped=true;}if(D.getName()==e[i].name){o.keyPropertyName=e[i].name;}var h=D.getTextProperty();if(h&&h.name==e[i].name){o.textPropertyName=e[i].name;}if(D.findAttributeByName(e[i].name)){o.aAttributeName.push(e[i].name);}o.analyticalInfo=e[i];}var m=this.oAnalyticalQueryResult.findMeasureByPropertyName(e[i].name);if(m&&(e[i].inResult==true||e[i].visible==true)){e[i].measurePropertyName=m.getName();var M=this.oMeasureDetailsSet[m.getName()];if(!M){M={};M.name=m.getName();this.oMeasureDetailsSet[m.getName()]=M;this.aMeasureName.push(M.name);}if(m.getRawValueProperty().name==e[i].name){M.rawValuePropertyName=e[i].name;}var k=m.getFormattedValueProperty();if(k&&k.name==e[i].name){M.formattedValuePropertyName=e[i].name;}M.analyticalInfo=e[i];}this.mAnalyticalInfoByProperty[e[i].name]=e[i];}for(var l in this.oMeasureDetailsSet){var u=this.oAnalyticalQueryResult.findMeasureByName(l).getUnitProperty();if(u){this.oMeasureDetailsSet[l].unitPropertyName=u.name;}}var n=function(q){var N=[];for(var r in q){N.push(r.name);}return N.sort().join(";");};if(n(p)!=n(this.oDimensionDetailsSet)){this.iTotalSize=-1;}this.aAnalyticalInfo=e;this.resetData();this.bNeedsUpdate=false;if(g){this._fireChange({reason:C.Change});}};f.prototype.getAnalyticalInfoForColumn=function(s){return this.mAnalyticalInfoByProperty[s];};f.prototype.loadGroups=function(g){var G=[];for(var s in g){G.push(s);this._resetData(s);var e=g[s];for(var i=0;i<e.length;i++){var o=e[i];this._getContextsForParentGroupId(s,o.startIndex,o.length,o.threshold);}var r=[];for(var j=-1,h;(h=G[++j])!==undefined;){r.push(this._getRequestId(f._requestType.groupMembersQuery,{groupId:h}));}this._considerRequestGrouping(r);}};f.prototype.getAnalyticalQueryResult=function(){return this.oAnalyticalQueryResult;};f._requestType={groupMembersQuery:1,totalSizeQuery:2,groupMembersAutoExpansionQuery:3,levelMembersQuery:4,reloadMeasuresQuery:5};f._artificialRootContextGroupId="artificialRootContext";f.prototype._getContextsForParentContext=function(p,s,l,i,L,n,e){if(p===undefined){return[];}if(p&&p.getPath()=="/"+f._artificialRootContextGroupId){p=this.getModel().getContext("/");}var P=this._getGroupIdFromContext(p,L);return this._getContextsForParentGroupId(P,s,l,i,n,e);};f.prototype._getContextsForParentGroupId=function(p,s,l,e,n,g){if(p===undefined){return[];}if(!s){s=0;}if(!l){l=this.oModel.iSizeLimit;}if(this.mFinalLength[p]&&this.mLength[p]<s+l){l=this.mLength[p]-s;if(l<0){Q.sap.log.fatal("invalid start index greater than total group length passed");}}if(!e){e=0;}if(!n){n=0;}if(p==null){if(n>0){Q.sap.log.fatal("invalid request to determine nodes of root context");return null;}}else{if(this._getGroupIdLevel(p)>=this.aAggregationLevel.length&&n>0){Q.sap.log.fatal("invalid request to determine nodes of context with group ID "+p);return null;}if(this._getGroupIdLevel(p)+n>this.aAggregationLevel.length){n=this.aAggregationLevel.length-this._getGroupIdLevel(p)-1;}}var h=[],L,G,o,m;var k=p==null?0:this._getGroupIdLevel(p)+1;if(!this.aMultiUnitLoadFactor[k]){this.aMultiUnitLoadFactor[k]=1;}var q=n>0&&p!=null;if(q){var M=this._getGroupIdLevel(p);var r=M+n;var D=true;if(!g){o=this._calculateRequiredGroupExpansion(p,r,s,l+e);D=o.groupId_Missing==null;D=D||o.groupId_Missing.length<p.length||o.groupId_Missing.substring(0,p.length)!=p;}if(D){h=this._getLoadedContextsForGroup(p,s,l);}else{m=l+e;}L=!D;m=Math.ceil(m*this.aMultiUnitLoadFactor[k]);}else{h=this._getLoadedContextsForGroup(p,s,l,g);L=false;if(!g){G=this._calculateRequiredGroupSection(p,s,l,e,h);var P=G.length>0&&l<G.length;L=(h.length!=l&&!(this.mFinalLength[p]&&h.length>=this.mLength[p]-s))||P;G.length=Math.ceil(G.length*this.aMultiUnitLoadFactor[k]);}}if(!L){this._cleanupGroupingForCompletedRequest(this._getRequestId(f._requestType.groupMembersQuery,{groupId:p}));}var E=false;if(this.oModel.getServiceMetadata()){if(L){var N=this.bProvideTotalSize&&this.iTotalSize==-1&&!this._isRequestPending(this._getRequestId(f._requestType.totalSizeQuery));E=true;var u;if(this.bUseBatchRequests){if(q){u=this._prepareGroupMembersAutoExpansionRequestIds(p,n);for(var i=-1,R;(R=u[++i])!==undefined;){if(this._isRequestPending(R)){E=false;break;}}if(E){this.aBatchRequestQueue.push([f._requestType.groupMembersAutoExpansionQuery,p,o,m,n]);}}else{E=!this._isRequestPending(this._getRequestId(f._requestType.groupMembersQuery,{groupId:p}));if(E){this.aBatchRequestQueue.push([f._requestType.groupMembersQuery,p,G.startIndex,G.length]);u=[this._getRequestId(f._requestType.groupMembersQuery,{groupId:p})];}}if(E&&N){u.push(this._getRequestId(f._requestType.totalSizeQuery));this._considerRequestGrouping(u);this.aBatchRequestQueue.push([f._requestType.totalSizeQuery]);}if(E){if(p==null){this._abortAllPendingRequests();}Promise.resolve().then(f.prototype._processRequestQueue.bind(this));}}else{var v;if(q){u=this._prepareGroupMembersAutoExpansionRequestIds(p,n);for(var j=-1,w;(w=u[++j])!==undefined;){if(this._isRequestPending(w)){E=false;break;}}if(E){v=this._prepareGroupMembersAutoExpansionQueryRequest(f._requestType.groupMembersAutoExpansionQuery,p,o,m,n);}}else{E=!this._isRequestPending(this._getRequestId(f._requestType.groupMembersQuery,{groupId:p}));if(E){v=this._prepareGroupMembersQueryRequest(f._requestType.groupMembersQuery,p,G.startIndex,G.length);u=[v.sRequestId];}}if(E){if(p==null){this._abortAllPendingRequests();}this._executeQueryRequest(v);if(N&&!v.bIsFlatListRequest){u.push(this._getRequestId(f._requestType.totalSizeQuery));this._considerRequestGrouping(u);this._executeQueryRequest(this._prepareTotalSizeQueryRequest(f._requestType.totalSizeQuery));}}}}}return h;};f.prototype._processRequestQueue=function(r){if(r===undefined||r===null){r=this.aBatchRequestQueue||[];}if(r.length==0){return;}var R=[];var e=false;var i,o,g;for(i=-1;(g=r[++i])!==undefined;){if(g[0]==f._requestType.groupMembersQuery){o=f.prototype._prepareGroupMembersQueryRequest.apply(this,g);e=e||o.bIsFlatListRequest;R.push(o);}}for(i=-1;(g=r[++i])!==undefined;){o=null;switch(g[0]){case f._requestType.groupMembersQuery:continue;case f._requestType.totalSizeQuery:if(!e){o=f.prototype._prepareTotalSizeQueryRequest.apply(this,g);R.push(o);}break;case f._requestType.groupMembersAutoExpansionQuery:o=f.prototype._prepareGroupMembersAutoExpansionQueryRequest.apply(this,g);for(var j=-1,l;(l=o.aGroupMembersAutoExpansionRequestDetails[++j])!==undefined;){R.push(l);}break;case f._requestType.reloadMeasuresQuery:{var h=g[1];for(var k=-1,m;(m=h[++k])!==undefined;){R.push(m);}break;}default:Q.sap.log.fatal("unhandled request type "+r[i][0]);continue;}}if(R.length>1){this._executeBatchRequest(R);}else{this._executeQueryRequest(R[0]);}if(r===this.aBatchRequestQueue){this.aBatchRequestQueue=[];}};f.prototype._prepareGroupMembersQueryRequest=function(r,g,s,L){var G=[];var o=new d.QueryResultRequest(this.oAnalyticalQueryResult);o.setResourcePath(this._getResourcePath());o.getSortExpression().clear();var e=0,h=-1;if(g){G=this._getGroupIdComponents(g);e=h=G.length;var u=0;for(var j=0,p=0;j<e;p++){if(this.oDimensionDetailsSet[this.aMaxAggregationLevel[p]].grouped==false){++u;}else{++j;}}e=h=e+u;if(this.aMaxAggregationLevel.length>0){while(this.oDimensionDetailsSet[this.aMaxAggregationLevel[h]].grouped==false){if(++h==this.aMaxAggregationLevel.length){break;}}}}var I=h>=this.aMaxAggregationLevel.length-1;var q=this.aMaxAggregationLevel.slice(0,h+1);o.setAggregationLevel(q);for(var i=0;i<q.length;i++){var D=this.oDimensionDetailsSet[q[i]];var v=(D.textPropertyName!=undefined);o.includeDimensionKeyTextAttributes(D.name,true,v,D.aAttributeName);if(D.grouped){o.getSortExpression().addSorter(q[i],d.SortOrder.Ascending);}}var w=o.getFilterExpression();w.clear();if(this.aApplicationFilter){w.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){w.addUI5FilterConditions(this.aControlFilter);}if(e>=1){for(var k=0,l=G.length;k<l;k++){w.removeConditions(this.aAggregationLevel[k]);w.addCondition(this.aAggregationLevel[k],a.EQ,G[k]);}}var x;var y;var z;var M;var E=[];if(g!=null||this.bProvideGrandTotals){o.setMeasures(this.aMeasureName);for(var H in this.oMeasureDetailsSet){M=this.oMeasureDetailsSet[H];if(!I&&this.mAnalyticalInfoByProperty[H].total==false){x=false;y=false;z=false;}else{x=(M.rawValuePropertyName!=undefined);y=(M.formattedValuePropertyName!=undefined);z=(M.unitPropertyName!=undefined);if(z){if(Q.inArray(M.unitPropertyName,E)==-1){E.push(M.unitPropertyName);}}}o.includeMeasureRawFormattedValueUnit(M.name,x,y,z);}for(var n in q){var J;if((J=Q.inArray(q[n],E))!=-1){E.splice(J,1);}}}var K=o.getSortExpression();for(var m=0;m<this.aSorter.length;m++){if(this.aSorter[m]){K.addSorter(this.aSorter[m].sPath,this.aSorter[m].bDescending?d.SortOrder.Descending:d.SortOrder.Ascending);}}if(L==0){Q.sap.log.fatal("unhandled case: load 0 entities of sub group");}var N=this._getKeyIndexMapping(g,s);if(!this.bNoPaging){o.setResultPageBoundaries(N.iServiceKeyIndex+1,N.iServiceKeyIndex+L);}o.setRequestOptions(null,!this.mFinalLength[g]);return{iRequestType:r,sRequestId:this._getRequestId(f._requestType.groupMembersQuery,{groupId:g}),oAnalyticalQueryRequest:o,sGroupId:g,aSelectedUnitPropertyName:E,aAggregationLevel:q,bIsFlatListRequest:I&&e==0,bIsLeafGroupsRequest:I,iStartIndex:s,iLength:L,oKeyIndexMapping:N};};f.prototype._prepareTotalSizeQueryRequest=function(r){var o=new d.QueryResultRequest(this.oAnalyticalQueryResult);o.setResourcePath(this._getResourcePath());o.setAggregationLevel(this.aMaxAggregationLevel);o.setMeasures([]);var e=o.getFilterExpression();e.clear();if(this.aApplicationFilter){e.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){e.addUI5FilterConditions(this.aControlFilter);}o.setRequestOptions(null,null,true);o.setRequestOptions(null,true);return{iRequestType:r,sRequestId:this._getRequestId(f._requestType.totalSizeQuery),oAnalyticalQueryRequest:o};};f.prototype._prepareGroupMembersAutoExpansionQueryRequest=function(r,g,G,L,n){var e=this;var p=function(G,o){var u=[];if(G.groupId_Missing==null){Q.sap.log.fatal("missing group Id not present");return u;}var q=e._getGroupIdComponents(G.groupId_Missing);var s=q.length;if(s>o){Q.sap.log.fatal("the given group ID is too deep for requested level for auto expansion");return u;}var k=[];for(var i=0;i<s;i++){var l=e.aAggregationLevel[i];var V=q[i];var K=e._getFilterOperatorMatchingPropertySortOrder(l);k[i]=new F(l,K,V);}var M=null;if(G.startIndex_Missing>0){var N=e._getKey(G.groupId_Missing,G.startIndex_Missing-1);var O=e.oModel.getObject("/"+N);var P=e.aAggregationLevel[s];var U=O[P];M=new F(P,e._getFilterOperatorMatchingPropertySortOrder(P,false),U);}for(var w=0;w<o;w++){var W=[];var X=Math.min(s,w+1);for(var Y=0;Y<X;Y++){var Z=[];var $=Math.min(s,Y+1);var _=G.startIndex_Missing>0;for(var a1=0;a1<$;a1++){var b1=new F("x",a.EQ,"x");b1=Q.extend(true,b1,k[a1]);if($>1&&a1<$-1){b1.sOperator=a.EQ;}if(a1==s-1&&w>s-1&&!_){if(b1.sOperator==a.GT){b1.sOperator=a.GE;}else{b1.sOperator=a.LE;}}Z.push(b1);}if(Z.length>0){W.push(new F(Z,true));if(w>s-1&&Y==s-1&&_){var c1=[];for(var j=0;j<Z.length;j++){var d1=new F("x",a.EQ,"x");d1=Q.extend(true,d1,Z[j]);c1.push(d1);}c1[s-1].sOperator=a.EQ;c1.push(M);W.push(new F(c1,true));break;}}}if(W.length>0){u[w]=new F(W,false);}else{u[w]=null;}}return u;};var h=function(r,g,w,K,x,L,M,U){var N=new d.QueryResultRequest(e.oAnalyticalQueryResult);N.setResourcePath(e._getResourcePath());N.getSortExpression().clear();var O=0,P=-1;O=P=w-1;var V=0;for(var i=0,W=0;i<O;W++){if(e.oDimensionDetailsSet[e.aMaxAggregationLevel[W]].grouped==false){++V;}else{++i;}}O=P=O+V;if(e.aMaxAggregationLevel.length>0){while(e.oDimensionDetailsSet[e.aMaxAggregationLevel[P]].grouped==false){if(++P==e.aMaxAggregationLevel.length){break;}}}var X=P>=e.aMaxAggregationLevel.length-1;var Y=e.aMaxAggregationLevel.slice(0,P+1);N.setAggregationLevel(Y);for(var l=0;l<Y.length;l++){var Z=e.oDimensionDetailsSet[Y[l]];var $=(Z.textPropertyName!=undefined);N.includeDimensionKeyTextAttributes(Z.name,true,$,Z.aAttributeName);if(Z.grouped){N.getSortExpression().addSorter(Y[l],d.SortOrder.Ascending);}}var _=N.getFilterExpression();_.clear();if(e.aApplicationFilter){_.addUI5FilterConditions(e.aApplicationFilter);}if(e.aControlFilter){_.addUI5FilterConditions(e.aControlFilter);}if(K){_.addUI5FilterConditions([K]);}var a1;var b1;var c1;var d1;var e1=[];N.setMeasures(e.aMeasureName);for(var f1 in e.oMeasureDetailsSet){d1=e.oMeasureDetailsSet[f1];if(!X&&e.mAnalyticalInfoByProperty[f1].total==false){a1=false;b1=false;c1=false;}else{a1=(d1.rawValuePropertyName!=undefined);b1=(d1.formattedValuePropertyName!=undefined);c1=(d1.unitPropertyName!=undefined);if(c1){if(Q.inArray(d1.unitPropertyName,e1)==-1){e1.push(d1.unitPropertyName);}}}N.includeMeasureRawFormattedValueUnit(d1.name,a1,b1,c1);}for(var j in Y){var g1;if((g1=Q.inArray(Y[j],e1))!=-1){e1.splice(g1,1);}}var h1=N.getSortExpression();for(var k=0;k<e.aSorter.length;k++){if(e.aSorter[k]){h1.addSorter(e.aSorter[k].sPath,e.aSorter[k].bDescending?d.SortOrder.Descending:d.SortOrder.Ascending);}}if(L==0){Q.sap.log.fatal("unhandled case: load 0 entities of sub group");}var i1=x;if(!U){i1=0;}else{var j1=0;for(var k1 in e.mServiceKey){if(k1.split("/").length===w+1){j1+=e.mServiceKey[k1].length;}}i1=Math.max(i1,j1);}if(!e.bNoPaging){N.setResultPageBoundaries(i1+1,L);}return{iRequestType:r,sRequestId:null,oAnalyticalQueryRequest:N,iLevel:w,aSelectedUnitPropertyName:e1,aAggregationLevel:Y,bIsFlatListRequest:X,bIsLeafGroupsRequest:X,iStartIndex:x,iLength:L,bAvoidLengthUpdate:M};};var m=[];var R=[];if(!G){Q.sap.log.fatal("no first missing group member specified");}var o=this._getGroupIdLevel(g)+n+1;var q=e._getGroupIdComponents(G.groupId_Missing);var s=q.length;var u=p(G,o);var v;for(var w=1;w<=o;w++){var x;if(w>=s+2){x=0;v=undefined;}else if(w==s+1){x=G.startIndex_Missing;v=G.groupId_Missing;}else if(s>0){if(w==s){v=G.groupId_Missing;}else{v=this._getGroupIdAncestors(G.groupId_Missing,-(s-w))[0];}var y=this._getGroupIdAncestors(G.groupId_Missing,-(s-w+1))[0];if(!y){Q.sap.log.fatal("failed to determine group id at parent level; group ID = "+g+", level = "+w);}x=this._findKeyIndex(y,this.mEntityKey[v]);if(x==-1){Q.sap.log.fatal("failed to determine position of value "+v+" in group "+y);}v=y;x++;}var z=L>w?Math.ceil((L-w)/(o-w+1)):L;var D=u[w-1];if(this.bUseAcceleratedAutoExpand){var E=h(f._requestType.levelMembersQuery,g,w,D,x,z,false,D==null?true:false);E.sGroupId_Missing_AtLevel=v;E.sRequestId=this._getRequestId(f._requestType.levelMembersQuery,{groupId:g,level:w});m.push(E);R.push(E.sRequestId);}else if(D&&D.aFilters.length>0){if(!D._bMultiFilter||D.bAnd){Q.sap.log.fatal("level filter in wrong shape; cannot break it up");}for(var i=0;i<D.aFilters.length;i++){var H=D.aFilters[i];var I=h(f._requestType.levelMembersQuery,g,w,H,x,z,false,D==null?true:false);I.sGroupId_Missing_AtLevel=v;I.sRequestId=this._getRequestId(f._requestType.levelMembersQuery,{groupId:g,level:w,tupleIndex:i});m.push(I);R.push(I.sRequestId);}}else{var J=h(f._requestType.levelMembersQuery,g,w,null,x,z,false,D==null?true:false);J.sGroupId_Missing_AtLevel=v;J.sRequestId=this._getRequestId(f._requestType.levelMembersQuery,{groupId:g,level:w});m.push(J);R.push(J.sRequestId);}}return{iRequestType:r,aRequestId:R,aGroupMembersAutoExpansionRequestDetails:m,sGroupId:g,iLength:L};};f.prototype._prepareReloadMeasurePropertiesQueryRequest=function(r,g,m){var o=new d.QueryResultRequest(this.oAnalyticalQueryResult);o.setResourcePath(this._getResourcePath());o.getSortExpression().clear();var e=g.aAggregationLevel;o.setAggregationLevel(e);var I=g.bIsLeafGroupsRequest;var h=o.getFilterExpression();h.clear();if(this.aApplicationFilter){h.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){h.addUI5FilterConditions(this.aControlFilter);}var k=[];for(var i=0;i<e.length;i++){var l=new F(e[i],a.EQ,m.oEntry[e[i]]);k.push(l);}h.addUI5FilterConditions(k);var n;var p;var q;var M;var s=[];o.setMeasures(m.aReloadMeasurePropertyName);for(var u in this.oMeasureDetailsSet){M=this.oMeasureDetailsSet[u];if(Q.inArray(M.name,m.aReloadMeasurePropertyName)==-1){continue;}if(!I&&this.mAnalyticalInfoByProperty[u].total==false){n=false;p=false;q=false;}else{n=(M.rawValuePropertyName!=undefined);p=(M.formattedValuePropertyName!=undefined);q=(M.unitPropertyName!=undefined);if(q){if(Q.inArray(M.unitPropertyName,s)==-1){s.push(M.unitPropertyName);}}}o.includeMeasureRawFormattedValueUnit(M.name,n,p,q);}for(var j in e){var v;if((v=Q.inArray(e[j],s))!=-1){s.splice(v,1);}}return{iRequestType:r,sRequestId:this._getRequestId(f._requestType.reloadMeasuresQuery,{multiUnitEntryKey:this.oModel.getKey(m.oEntry)}),oAnalyticalQueryRequest:o,aSelectedUnitPropertyName:s,aAggregationLevel:e,oMultiUnitRepresentative:m};};f.prototype._prepareGroupMembersAutoExpansionRequestIds=function(g,n){var m=this._getGroupIdLevel(g)+1;var i=m+n;var r=[];for(var l=m;l<=i;l++){r.push(this._getRequestId(f._requestType.levelMembersQuery,{groupId:g,level:l}));}return r;};f.prototype._getQueryODataRequestOptions=function(o,p){p=p||{};try{o.getFilterExpression().checkValidity();}catch(e){Q.sap.log.fatal("filter expression is not valid",e.toString());return undefined;}var s=o.getURIQueryOptionValue("$select");var g=o.getURIQueryOptionValue("$filter");var O=o.getURIQueryOptionValue("$orderby");var h=o.getURIQueryOptionValue("$skip");var j=o.getURIQueryOptionValue("$top");var I=o.getURIQueryOptionValue("$inlinecount");if(this.mParameters&&this.mParameters["filter"]){g+="and ("+this.mParameters["filter"]+")";}var P=[];if(s!==null){P.push("$select="+s);}if(g!==null){P.push("$filter="+g);}if(O!==null){P.push("$orderby="+O);}if(h!==null){P.push("$skip="+h);}if(j!==null){P.push("$top="+j);}if(I!==null){P.push("$inlinecount="+I);}if(p.encode===true){for(var i=0;i<P.length;i++){P[i]=P[i].replace(/\ /g,"%20");}}return P;};f.prototype._executeBatchRequest=function(r){var e=this.iAnalyticalInfoVersionNumber;var g=this;var h=[],E=[];function l(){g.fireDataReceived({__simulateAsyncAnalyticalBinding:true});}var R=new B();function s(j,k){R.success(k);}function m(j,k){R.error(k||j);}this.bNeedsUpdate=true;for(var D=0;D<r.length;D++){var o=r[D];if(o.aAggregationLevel&&o.aAggregationLevel.length>0){this.bNeedsUpdate=false;}}for(var i=-1,n;(n=r[++i])!==undefined;){var p=n.oAnalyticalQueryRequest,G=n.sGroupId;if(p.getURIQueryOptionValue("$select")==null){this.fireDataRequested({__simulateAsyncAnalyticalBinding:true});G=null;this.mServiceLength[G]=this.mLength[G]=1;this.mServiceFinalLength[G]=true;this._setServiceKey(this._getKeyIndexMapping(G,0),f._artificialRootContextGroupId);setTimeout(l);this.bArtificalRootContext=true;continue;}var P=p.getURIToQueryResultEntries();if(!this.oContext&&P[0]!=="/"){P="/"+P;}if(!this._isRequestPending(n.sRequestId)){this._registerNewRequest(n.sRequestId);if(this.iModelVersion===A.V1){h.push(this.oModel.createBatchOperation(P.replace(/\ /g,"%20"),"GET"));}else if(this.iModelVersion===A.V2){var u=this._getQueryODataRequestOptions(p,{encode:true});if(this.sCustomParams){u.push(this.sCustomParams);}var q=this.oModel.read(P.replace(/\ /g,"%20"),{success:s,error:m,context:this.oContext,urlParameters:u});h.push(q);}E.push(n);}}if(h.length>0){Q.sap.log.debug("AnalyticalBinding: executing batch request with "+E.length+" operations");var v;var w=this._getIdForNewRequestHandle();this.fireDataRequested();if(this.iModelVersion===A.V1){this.oModel.addBatchReadOperations(h);v=this.oModel.submitBatch(x,y,true,true);this.oModel.fireRequestSent({url:this.oModel.sServiceUrl+"/$batch",type:"POST",async:true,info:"",infoObject:{}});}else{v={abort:function(){for(var j=0;j<h.length;j++){h[j].abort();}}};R.setup({executedRequests:E,binding:this,success:x,error:y});}this._registerNewRequestHandle(w,v);}function x(z,H){g._deregisterHandleOfCompletedRequest(w);if(E.length!=z.__batchResponses.length){Q.sap.log.fatal("assertion failed: received "+z.__batchResponses.length+" responses for "+E.length+" read operations in the batch request");}if(e!=g.iAnalyticalInfoVersionNumber){for(var j=0;j<E.length;j++){var I=E[j].sRequestId;if(I!==undefined){g._deregisterCompletedRequest(I);g._cleanupGroupingForCompletedRequest(I);}}g.fireDataReceived({data:[]});return;}var J=0;for(var k=0;k<z.__batchResponses.length;k++){if(z.__batchResponses[k].data!=undefined){if(z.__batchResponses[k].data.results.length==0){J++;}switch(E[k].iRequestType){case f._requestType.groupMembersQuery:g._processGroupMembersQueryResponse(E[k],z.__batchResponses[k].data);break;case f._requestType.totalSizeQuery:g._processTotalSizeQueryResponse(E[k],z.__batchResponses[k].data);break;case f._requestType.levelMembersQuery:g._processLevelMembersQueryResponse(E[k],z.__batchResponses[k].data);break;case f._requestType.reloadMeasuresQuery:g._processReloadMeasurePropertiesQueryResponse(E[k],z.__batchResponses[k].data);break;default:Q.sap.log.fatal("invalid request type "+E[k].iRequestType);continue;}}g._deregisterCompletedRequest(E[k].sRequestId);g._cleanupGroupingForCompletedRequest(E[k].sRequestId);}if(g.mParameters&&g.mParameters.numberOfExpandedLevels>0){if(J==z.__batchResponses.length){g.mLength["/"]=0;g.mFinalLength["/"]=true;}}var O=true;var K;g.fireDataReceived({data:z});var V={};if(g.iModelVersion===A.V1){K=g.oModel._getBatchErrors(z);if(K.length>0){O=false;V=g.oModel._handleError(K[0]);}g.oModel.fireRequestCompleted({url:H.requestUri,type:"POST",async:true,info:"",infoObject:{},success:O,errorobject:O?{}:V});if(O){g.oModel.checkUpdate();}}}function y(k){if(k&&k.statusText!="abort"){g._deregisterHandleOfCompletedRequest(w);for(var j=-1,z;(z=E[++j])!==undefined;){g._deregisterCompletedRequest(z.sRequestId);g._cleanupGroupingForCompletedRequest(z.sRequestId);}}if(e!=g.iAnalyticalInfoVersionNumber){return;}var V=k;if(g.iModelVersion===A.V1){V=g.oModel._handleError(k);}g.oModel.fireRequestCompleted({url:"",type:"POST",async:true,info:"",infoObject:{},success:false,errorobject:V});if(g.iModelVersion===A.V1){g.oModel.fireRequestFailed(V);}g.fireDataReceived();}};f.prototype._executeQueryRequest=function(r){if(r.iRequestType==f._requestType.groupMembersAutoExpansionQuery){for(var i=-1,o;(o=r.aGroupMembersAutoExpansionRequestDetails[++i])!==undefined;){this._executeQueryRequest(o);}return;}var e=this.iAnalyticalInfoVersionNumber;var g=r.oAnalyticalQueryRequest,G=r.sGroupId;var p=g.getURIToQueryResultEntitySet();var P=this._getQueryODataRequestOptions(g);if(!P){return;}var h=this;if(g.getURIQueryOptionValue("$select")==null){this.fireDataRequested({__simulateAsyncAnalyticalBinding:true});G=null;this.mServiceLength[G]=this.mLength[G]=1;this.mServiceFinalLength[G]=true;this._setServiceKey(this._getKeyIndexMapping(G,0),f._artificialRootContextGroupId);this.bNeedsUpdate=true;setTimeout(function(){if(h._cleanupGroupingForCompletedRequest(r.sRequestId)){h.fireDataReceived({__simulateAsyncAnalyticalBinding:true});}});this.bArtificalRootContext=true;return;}this._registerNewRequest(r.sRequestId);this.fireDataRequested();for(var j=0;j<P.length;j++){P[j]=P[j].replace(/\ /g,"%20");}Q.sap.log.debug("AnalyticalBinding: executing query request");var R=this._getIdForNewRequestHandle();if(this.iModelVersion===A.V1){this.oModel._loadData(p,P,s,E,false,u,l);}else{if(this.sCustomParams){P.push(this.sCustomParams);}var k=this.oModel.read(p,{success:s,error:E,context:this.oContext,urlParameters:P});h._registerNewRequestHandle(R,k);}function s(D){h._deregisterHandleOfCompletedRequest(R);if(e!=h.iAnalyticalInfoVersionNumber){h._deregisterCompletedRequest(r.sRequestId);return;}switch(r.iRequestType){case f._requestType.groupMembersQuery:h._processGroupMembersQueryResponse(r,D);break;case f._requestType.totalSizeQuery:h._processTotalSizeQueryResponse(r,D);break;case f._requestType.levelMembersQuery:h._processLevelMembersQueryResponse(r,D);break;case f._requestType.reloadMeasuresQuery:h._processReloadMeasurePropertiesQueryResponse(r,D);break;default:Q.sap.log.fatal("invalid request type "+r.iRequestType);break;}h._deregisterCompletedRequest(r.sRequestId);if(h.iModelVersion===A.V2){l(D);}}function l(D){if(e!=h.iAnalyticalInfoVersionNumber){return;}if(h._cleanupGroupingForCompletedRequest(r.sRequestId)){h.fireDataReceived({data:D});}}function E(m){if(m&&m.statusText=="abort"){h.fireDataReceived();return;}h._deregisterHandleOfCompletedRequest(R);h._deregisterCompletedRequest(r.sRequestId);h._cleanupGroupingForCompletedRequest(r.sRequestId);if(e!=h.iAnalyticalInfoVersionNumber){return;}h.fireDataReceived();}function u(k){h._registerNewRequestHandle(R,k);}};f.prototype._abortAllPendingRequests=function(){this._abortAllPendingRequestsByHandle();this._clearAllPendingRequests();};f.prototype._processGroupMembersQueryResponse=function(R,D){var G=R.sGroupId,s=R.aSelectedUnitPropertyName,e=R.aAggregationLevel,n=R.oKeyIndexMapping.iIndex,u=R.oKeyIndexMapping.iServiceKeyIndex,L=R.iLength,K=R.oKeyIndexMapping,v=G==null?0:this._getGroupIdLevel(G)+1;var U=(s.length>0);var P,w;var x;var y=0;var z;var E,H=[];var O=D.results.length;var I=this._getServiceKeys(G,K.iIndex-1);P=undefined;if(I&&I.length>0){for(var i=0,J=I.length;i<J;i++){D.results[i-J]=this.oModel.getObject("/"+I[i]);}var M=D.results[-I.length];P="";for(var j=0;j<e.length;j++){P+=M[e[j]]+"|";}}z=I&&I.length==1;for(var h=0;h<O;h++){var N=D.results[h];if(U){w="";for(var g=0;g<e.length;g++){w+=N[e[g]]+"|";}if(P==w){if(x===undefined){if(h==0){x=-I.length;K.iServiceKeyIndex-=I.length-1;}else{x=h-1;}}var V=-1,W=D.results[h-1];for(var k=0;k<s.length;k++){if(W[s[k]]!=N[s[k]]){V=k;break;}}if(V==-1){Q.sap.log.fatal("assertion failed: no deviating units found for result entries "+(h-1)+" and "+h,null,null,t(this,"NO_DEVIATING_UNITS"));}}if((P!=w||h==O-1)&&x!==undefined){var X=[];for(var l=x;l<h;l++){X.push(D.results[l]);}if(P==w){X.push(D.results[h]);}var Y=[];for(var m=0;m<s.length;m++){var Z=s[m];for(var o=1;o<X.length;o++){if(X[o-1][Z]!=X[o][Z]){Y.push(Z);break;}}}var $=this._createMultiUnitRepresentativeEntry(G,D.results[x],s,Y,R.bIsFlatListRequest);if($.aReloadMeasurePropertyName.length>0){E=this._prepareReloadMeasurePropertiesQueryRequest(f._requestType.reloadMeasuresQuery,R,$);if(E.oAnalyticalQueryRequest&&E.oAnalyticalQueryRequest.getURIQueryOptionValue("$select")!=null){H.push(E);}}var _=this._setAdjacentMultiUnitKeys(K,$,X);var a1;if($.bIsNewEntry){a1=X.length-1;}else{a1=_;}if(z){z=false;}if(a1<0){Q.sap.log.fatal("assertion failed: iDiscardedEntriesCount must be non-negative");}y+=a1;var b1=this.oModel._getKey($.oEntry);var c1=this.oModel.getContext('/'+b1);this._getGroupIdFromContext(c1,v);this.mEntityKey[e1]=b1;x=undefined;if(P!=w){z=this._setServiceKey(K,this.oModel._getKey(N));}}else if(P!=w){z=this._setServiceKey(K,this.oModel._getKey(N));}P=w;}else{this._setServiceKey(K,this.oModel._getKey(N));}if(!R.bIsLeafGroupsRequest){var d1=this._getKey(G,K.iIndex-1),e1=this._getGroupIdFromContext(this.oModel.getContext('/'+d1),v);this.mEntityKey[e1]=d1;}}var f1=[];if(this.bReloadSingleUnitMeasures&&H.length>0){if(this.bUseBatchRequests){this.aBatchRequestQueue.push([f._requestType.reloadMeasuresQuery,H]);Promise.resolve().then(f.prototype._processRequestQueue.bind(this));}else{for(var q=0;q<H.length;q++){var g1=H[q];this._executeQueryRequest(g1);}}for(var p=0;p<H.length;p++){var h1=H[p];f1.push(h1.sRequestId);}this._considerRequestGrouping(f1);}if(I&&I.length>0){for(var r=0,i1=I.length;r<i1;r++){delete D.results[r-i1];}}if(U){y+=this._mergeLoadedKeyIndexWithSubsequentIndexes(K,e,s,R.bIsFlatListRequest);}if(!R.bAvoidLengthUpdate){var j1=false;if(D.__count){this.mServiceLength[G]=parseInt(D.__count,10);this.mLength[G]=this.mServiceLength[G]-y;this.mFinalLength[G]=true;if(R.bIsFlatListRequest){this.iTotalSize=D.__count;}j1=true;}if(this.mServiceLength[G]<u+O){this.mServiceLength[G]=u+O;this.mLength[G]=n+O-y;this.mFinalLength[G]=false;}if(O<L||L===undefined){this.mServiceLength[G]=u+O;this.mLength[G]=n+K.iIndex-n;this.mFinalLength[G]=true;j1=true;}if(O==0){this.mLength[G]=this.mServiceLength[G]=0;this.mFinalLength[G]=true;j1=true;}if(!j1&&this.mLength[G]!==undefined&&y>0){this.mLength[G]-=y;}}this.bNeedsUpdate=true;if(y>0){if(D.results.length-y>0){this.aMultiUnitLoadFactor[e.length]=D.results.length/(D.results.length-y);}if(this.aMultiUnitLoadFactor[e.length]<1.5){this.aMultiUnitLoadFactor[e.length]=2;}}Q.sap.log.info("MultiUnit Situation in Group ("+G+"), discarded: "+y+", load-factor is now: "+this.aMultiUnitLoadFactor[e.length]);};f.prototype._processTotalSizeQueryResponse=function(r,D){if(D.__count==undefined){Q.sap.log.fatal("missing entity count in query result");return;}this.iTotalSize=D.__count;};f.prototype._processLevelMembersQueryResponse=function(r,D){var e=this;var p,P;var g=function(h,I){var G={iRequestType:f._requestType.groupMembersQuery,sRequestId:e._getRequestId(f._requestType.groupMembersQuery,{groupId:p}),oAnalyticalQueryRequest:r.oAnalyticalQueryRequest,sGroupId:p,aSelectedUnitPropertyName:r.aSelectedUnitPropertyName,aAggregationLevel:r.aAggregationLevel,bIsFlatListRequest:r.bIsFlatListRequest,bIsLeafGroupsRequest:r.bIsLeafGroupsRequest,iStartIndex:h?r.iStartIndex:0,iLength:r.iLength,bAvoidLengthUpdate:r.bAvoidLengthUpdate};if(h&&r.iStartIndex>0&&(r.sGroupId_Missing_AtLevel!=G.sGroupId||e._getKeys(G.sGroupId)===undefined)){var s=e._getParentGroupId(G.sGroupId);var j=e._findKeyIndex(s,e.mEntityKey[G.sGroupId]);if(j==-1){Q.sap.log.fatal("assertion failed: failed to determine position of "+G.sGroupId+" in group "+s);}if(j>0&&e._getKey(s,j-1)!==undefined){var k=e._getKey(s,j-1);var l=e._getGroupIdFromContext(e.oModel.getContext('/'+k),e._getGroupIdLevel(G.sGroupId));e.mFinalLength[l]=true;G.iStartIndex=0;}}if(I){G.iLength=P.length;}G.oKeyIndexMapping=e._getKeyIndexMapping(G.sGroupId,G.iStartIndex);var m=Q.extend(true,{},D);m.results=P;e._processGroupMembersQueryResponse(G,m);};if(D.results.length==0){return;}p=this._getGroupIdFromContext(this.oModel.getContext("/"+this.oModel._getKey(D.results[0])),r.iLevel-1);P=[];var h=true;for(var i=0;i<D.results.length;i++){var E=D.results[i];var o=this.oModel.getContext("/"+this.oModel._getKey(D.results[i]));var s=this._getGroupIdFromContext(o,r.iLevel-1);if(p==s){P.push(E);if(i<D.results.length-1){continue;}}g(h,D.results.length==r.iLength&&i==D.results.length-1);h=false;if(p!=s){P=[E];}p=s;}if(D.results.length>1&&P.length==1){g(h,D.results.length==r.iLength);}};f.prototype._processReloadMeasurePropertiesQueryResponse=function(r,D){var m=r.oMultiUnitRepresentative;var M=this.oModel.getKey(m.oEntry);if(D.results.length!=1){Q.sap.log.fatal("assertion failed: more than one entity for reloaded measure properties of entity with key "+M);return;}var R=D.results[0];var o=this.oModel.getObject("/"+M);if(!o){Q.sap.log.fatal("assertion failed: no entity found with key "+M);return;}var e=m.aReloadMeasurePropertyName;for(var i=0;i<e.length;i++){o[e[i]]=R[e[i]];}};f.prototype._getLoadedContextsForGroup=function(g,s,l,e){var h=[],o,k=this._getKeys(g),K;if(!k){return h;}if(!s){s=0;}if(!l){l=this.oModel.iSizeLimit;if(this.mFinalLength[g]){l=this.mLength[g];}}if(e){i=s||0;K=k(i);while(K){o=this.oModel.getContext('/'+K);h.push(o);i++;K=k(i);}return h;}for(var i=s;i<s+l;i++){K=k(i);if(!K){break;}o=this.oModel.getContext('/'+K);h.push(o);}return h;};f.prototype._calculateRequiredGroupSection=function(g,s,l,e,h){var k,m,p,P,r,o={},K=this._getKeys(g),n;m=s;k=0;if(!K){P=s;p=s+l;}else{for(var i=s-1;i>=Math.max(s-e,0);i--){n=K(i);if(!n){P=i+1;break;}}for(var j=s+l;j<s+l+e;j++){n=K(j);if(!n){p=j;break;}}}r=s-P;if(P&&s>e&&r<e){if(h.length!==l){m=s-e;}else{m=P-e;}k=e;}m=Math.max(m,0);if(m===s){m+=h.length;}if(h.length!==l){k+=l-h.length;}r=p-s-l;if(r==0){k+=e;}if(p&&r<e&&r>0){if(m>s){m=p;k+=e;}}if(this.mFinalLength[g]&&this.mLength[g]<(k+m)){k=this.mLength[g]-m;}o.startIndex=m;o.length=k;return o;};f.prototype._calculateRequiredGroupExpansion=function(g,e,s,l){var n={groupId_Missing:null,length_Missing:0};var h=this;var j=function(g,e,s,l){var L=h._getGroupIdLevel(g);if(L==e){var u=h._getLoadedContextsForGroup(g,s,l);var v=s+u.length-1;if(u.length>=l){return n;}else if(h.mFinalLength[g]){if(u.length>=h.mLength[g]){return{groupId_Missing:null,length_Missing:l-u.length};}else{return{groupId_Missing:g,startIndex_Missing:v+1,length_Missing:l-u.length};}}else{return{groupId_Missing:g,startIndex_Missing:v+1,length_Missing:l-u.length};}}var w=h._getLoadedContextsForGroup(g,s,l);var k=l,x=s+w.length-1;for(var i=-1,y;(y=w[++i])!==undefined;){k--;var G=j(h._getGroupIdFromContext(y,L+1),e,0,k);if(G.groupId_Missing==null){if(G.length_Missing==0){return G;}else{k=G.length_Missing;}}else{return G;}if(k==0){break;}}if(h.mFinalLength[g]||k==0){return{groupId_Missing:null,length_Missing:k};}else{return{groupId_Missing:g,startIndex_Missing:x+1,length_Missing:k};}};var L=this._getGroupIdLevel(g);if(L==e+1){g=this._getParentGroupId(g);--L;}if(g==null||L>e){return n;}var k=l,m=s;while(g!=null){var G=j(g,e,m,k);if(G.groupId_Missing!=null){return G;}else if(G.length_Missing==0){return G;}else{var o=false;while(!o){var p=this._getParentGroupId(g);if(p==null){g=p;--L;break;}var q=this.mEntityKey[g];if(!q){return n;}var r=this._findKeyIndex(p,q);if(r==-1){return n;}if(r==this._getKeyCount(p)-1){if(this.mFinalLength[p]){g=p;--L;continue;}else{return{groupId_Missing:p,startIndex_Missing:r+1,length_Missing:k};}}else{q=this._getKey(p,r+1);g=this._getGroupIdFromContext(this.oModel.getContext('/'+q),L);o=true;}}m=0;k=G.length_Missing;}}return{groupId_Missing:null,length_Missing:k};};f.prototype._getResourcePath=function(){return this.isRelative()?this.oModel.resolve(this.sPath,this.getContext()):this.sPath;};f.prototype._getEntitySet=function(){var e=this.sEntitySetName;if(!e){e=this.sPath.split("/")[1];if(e.indexOf("(")!=-1){e=e.split("(")[0]+"Results";}}return e;};f.prototype._getEffectiveSortOrder=function(p){for(var i=0;i<this.aSorter.length;i++){if(this.aSorter[i]&&this.aSorter[i].sPath==p){return this.aSorter[i].bDescending?d.SortOrder.Descending:d.SortOrder.Ascending;}}return null;};f.prototype._getFilterOperatorMatchingPropertySortOrder=function(p,w){var s;switch(this._getEffectiveSortOrder(p)){case d.SortOrder.Ascending:if(w){s=a.GE;}else{s=a.GT;}break;case d.SortOrder.Descending:if(w){s=a.LE;}else{s=a.LT;}break;default:s=a.GT;}return s;};f.prototype._convertDeprecatedFilterObjects=function(e){if(!e){return e;}var O=sap.ui.require("sap/ui/model/odata/Filter");if(typeof O==='function'){for(var i=0,l=e.length;i<l;i++){if(e[i]instanceof O){e[i]=e[i].convert();}}}return e;};f.prototype._getGroupIdFromContext=function(o,l){if(!o){return null;}var g="/";var D=null;if(l>this.aAggregationLevel.length){Q.sap.log.fatal("assertion failed: aggregation level deeper than number of current aggregation levels");}for(var i=0;i<l;i++){D=o.getProperty(this.aAggregationLevel[i]);if(D!=null){g+=encodeURIComponent(D)+"/";}else{g+="@/";}}return g;};f.prototype._getGroupIdLevel=function(g){if(g==null){Q.sap.log.fatal("assertion failed: no need to determine level of group ID = null");return-1;}return g.split("/").length-2;};f.prototype._getGroupIdComponents=function(g){if(g==null){return null;}var G=g.split("/");var D=[];for(var i=1;i<G.length-1;i++){if(G[i]=="@"){D[i-1]=null;}else{D[i-1]=decodeURIComponent(G[i]);}}return D;};f.prototype._getGroupIdAncestors=function(g,n){if(!n){return[];}if(g==null){Q.sap.log.fatal("group ID null does not have ancestors");return[];}if(g=="/"){if(Math.abs(n)==1){return[null];}else{Q.sap.log.fatal("invalid level count "+n+" for ancestors of groupId "+g);return[];}}var G=g.split("/");var e=[],s="";var h=0,k=G.length-3;if(n>0){if(n-1>k){Q.sap.log.fatal("invalid level count "+n+" for ancestors of groupId "+g);}else{k=n-1;}}else if(-(n+1)>k){Q.sap.log.fatal("invalid level count "+n+" for ancestors of groupId "+g);}else{h=k+1+n;for(var i=0;i<h;i++){s+=G[i]+"/";}}for(var j=h;j<=k;j++){s+=G[j]+"/";e.push(s);}return e;};f.prototype._getParentGroupId=function(g){return this._getGroupIdAncestors(g,-1)[0];};f.prototype._removeDuplicatesFromStringArray=function(e){var o={};for(var i=0;i<e.length;i++){o[e[i]]=true;}var u=[];for(var s in o){u.push(s);}return u;};f.prototype._getIdForNewRequestHandle=function(){if(this.oPendingRequestHandle===undefined){this.oPendingRequestHandle=[];}for(var i=0;i<this.oPendingRequestHandle.length;i++){if(this.oPendingRequestHandle[i]===undefined){return i;}}this.oPendingRequestHandle[this.oPendingRequestHandle.length]=undefined;return this.oPendingRequestHandle.length-1;};f.prototype._registerNewRequestHandle=function(r,R){if(this.oPendingRequestHandle[r]!==undefined){Q.sap.log.fatal("request handle ID already in use");}this.oPendingRequestHandle[r]=R;};f.prototype._deregisterHandleOfCompletedRequest=function(r){if(Q.isEmptyObject(this.oPendingRequestHandle)){Q.sap.log.warning("No request handles to be cleared. Previous abort/resetData?");return;}if(this.oPendingRequestHandle[r]===undefined){Q.sap.log.fatal("no handle found for this request ID");}this.oPendingRequestHandle[r]=undefined;};f.prototype._abortAllPendingRequestsByHandle=function(){for(var i=0;i<this.oPendingRequestHandle.length;i++){if(this.oPendingRequestHandle[i]){if(this.oPendingRequestHandle[i]!==undefined){this.oPendingRequestHandle[i].abort();}}}this.oPendingRequestHandle=[];};f.prototype._getRequestId=function(r,p){switch(r){case f._requestType.groupMembersQuery:if(p.groupId===undefined){Q.sap.log.fatal("missing group ID");}return f._requestType.groupMembersQuery+(p.groupId==null?"":p.groupId);case f._requestType.levelMembersQuery:if(p.level===undefined){Q.sap.log.fatal("missing level");}if(p.groupId===undefined){Q.sap.log.fatal("missing groupId");}return""+f._requestType.levelMembersQuery+p.level+(p.tupleIndex?"-"+p.tupleIndex:"");case f._requestType.totalSizeQuery:return f._requestType.totalSizeQuery;case f._requestType.reloadMeasuresQuery:if(!p.multiUnitEntryKey){Q.sap.log.fatal("missing multi unit entry key");}return f._requestType.reloadMeasuresQuery+p.multiUnitEntryKey;default:Q.sap.log.fatal("invalid request type "+r);return-1;}};f.prototype._registerNewRequest=function(r){if(r==undefined||r==""){Q.sap.log.fatal("missing request ID");return;}if(!this.oPendingRequests[r]){this.oPendingRequests[r]=1;}else{++this.oPendingRequests[r];}};f.prototype._considerRequestGrouping=function(r){for(var i=-1,R;(R=r[++i])!==undefined;){if(this.oGroupedRequests[R]===undefined){this.oGroupedRequests[R]={};}var g=this.oGroupedRequests[R];for(var j=0;j<r.length;j++){g[r[j]]=true;}}};f.prototype._isRequestPending=function(r){return this.oPendingRequests[r]!=undefined&&this.oPendingRequests[r]>0;};f.prototype._deregisterCompletedRequest=function(r){if(Q.isEmptyObject(this.oPendingRequests)){Q.sap.log.warning("There are no pending requests which could be set to 'completed'.");return;}if(!this.oPendingRequests[r]){Q.sap.log.fatal("assertion failed: there is no pending request ID "+r);}if(this.oPendingRequests[r]==1){delete this.oPendingRequests[r];}else{--this.oPendingRequests[r];}};f.prototype._cleanupGroupingForCompletedRequest=function(r){if(this._isRequestPending(r)){return false;}var g=true;if(this.oGroupedRequests[r]!=undefined){for(var o in this.oGroupedRequests[r]){if(this.oPendingRequests[o]){g=false;break;}}}if(g){var R=this.oGroupedRequests[r];delete this.oGroupedRequests[r];for(var O in R){if(O!=r){this._cleanupGroupingForCompletedRequest(O);}}}return g;};f.prototype._getKeyIndexMapping=function(g,s){var k=this.mKeyIndex[g];var e=this.mServiceKey[g];var i=s;if(k!==undefined){var l=s;if(l>0){while(--l>0){if(k[l]!==undefined){break;}}}var L;if(l==0){L=0;}else{if(k[l]>=0){L=k[l];}else if(k[l+1]===undefined){L=k[l]=="ZERO"?0:-k[l];while(e[L+1]!==undefined){++L;}}else{L=Math.abs(k[l+1])-1;}if(e[L]===undefined){Q.sap.log.fatal("assertion failed: no service key at iLastOccupiedServiceKeyIndex = "+L);}}var D=s-l;i=L+D;}var K={sGroupId:g,iIndex:s,iServiceKeyIndex:i};return K;};f.prototype._moveKeyIndexMapping=function(k,i){return this._getKeyIndexMapping(k.sGroupId,k.iIndex+i);};f.prototype._getKey=function(g,i){var s=this.mKeyIndex[g][i];if(s===undefined){return undefined;}if(s>=0){return this.mServiceKey[g][s];}if(this.mMultiUnitKey[g]===undefined){Q.sap.log.fatal("assertion failed: missing expected multi currency key for group with ID "+g);return null;}var k=this.mMultiUnitKey[g][i];if(k===undefined){Q.sap.log.fatal("assertion failed: missing expected multi currency key for group with ID "+g+" at pos "+i);return null;}return k;};f.prototype._getKeys=function(g){if(this.mKeyIndex[g]===undefined){return undefined;}var e=this;return function(i){return e._getKey(g,i);};};f.prototype._getServiceKeys=function(g,I){var k=this.mKeyIndex[g];if(k===undefined){return undefined;}var s=this.mServiceKey[g],e=k[I];if(e===undefined){return undefined;}if(e>=0){return[s[e]];}var G=[];if(k[I+1]===undefined){e=k[I]=="ZERO"?0:-k[I];while(s[e]!==undefined){G.push(s[e++]);}}else{e=k[I]=="ZERO"?0:-k[I];for(var i=e,n=Math.abs(k[I+1]);i<n;i++){G.push(s[i]);}}return G;};f.prototype._getKeyCount=function(g){if(this.mKeyIndex[g]===undefined){return undefined;}return this.mKeyIndex[g].length;};f.prototype._findKeyIndex=function(g,k){var K=this.mKeyIndex[g];var s=this.mServiceKey[g];var m=this.mMultiUnitKey[g];for(var i=0;i<this.mLength[g];i++){if(K[i]<0){if(m[i]==k){return i;}}else if(s[K[i]]==k){return i;}}return-1;};f.prototype._setServiceKey=function(k,s){if(!this.mServiceKey[k.sGroupId]){this.mServiceKey[k.sGroupId]=[];}if(!this.mKeyIndex[k.sGroupId]){this.mKeyIndex[k.sGroupId]=[];}var n=this.mServiceKey[k.sGroupId][k.iServiceKeyIndex]===undefined;this.mServiceKey[k.sGroupId][k.iServiceKeyIndex++]=s;this.mKeyIndex[k.sGroupId][k.iIndex++]=k.iServiceKeyIndex-1;return n;};f.prototype._setAdjacentMultiUnitKeys=function(k,m,M){if(!this.mServiceKey[k.sGroupId]){this.mServiceKey[k.sGroupId]=[];}if(!this.mKeyIndex[k.sGroupId]){this.mKeyIndex[k.sGroupId]=[];}if(!this.mMultiUnitKey[k.sGroupId]){this.mMultiUnitKey[k.sGroupId]=[];}--k.iIndex;--k.iServiceKeyIndex;this.mMultiUnitKey[k.sGroupId][k.iIndex]=this.oModel._getKey(m.oEntry);this.mKeyIndex[k.sGroupId][k.iIndex++]=k.iServiceKeyIndex>0?-k.iServiceKeyIndex:"ZERO";var n=0;for(var i=0;i<M.length;i++){if(!this.mServiceKey[k.sGroupId][k.iServiceKeyIndex]){++n;}this.mServiceKey[k.sGroupId][k.iServiceKeyIndex++]=this.oModel._getKey(M[i]);}return n;};f.prototype._mergeLoadedKeyIndexWithSubsequentIndexes=function(k,e,s,I){var K=this.mKeyIndex[k.sGroupId],g=this.mServiceKey[k.sGroupId],m=this.mMultiUnitKey[k.sGroupId],D=0,n=k.iServiceKeyIndex,h=k.iIndex;var M,o;if(K===undefined){return D;}var N=false;var p=g[n-1],j=g[n];if(j===undefined){return D;}if(p===undefined){Q.sap.log.fatal("assertion failed: missing expected entry before given key index");return D;}var P=this.oModel.getObject("/"+p);var l=this.oModel.getObject("/"+j);var q="",r="";for(var i=0;i<e.length;i++){q+=P[e[i]]+"|";r+=l[e[i]]+"|";}N=q==r;var u=h;if(u>=this.mLength[k.sGroupId]){Q.sap.log.fatal("assertion failed: service key exists,but no corresponding key index found");return D;}while(K[u]===undefined||Math.abs(K[u])<n){++u;}if(N){if(Math.abs(K[u])==n&&K[u]<0){if(u>h){if(K[h-1]<0){m[u]=undefined;K.splice(h,u-h+1);m.splice(h,u-h+1);}else{K[h-1]=-K[h-1];m[h-1]=m[u];m[u]=undefined;K.splice(h,u-h+1);m.splice(h,u-h+1);D=1;}}}else if(Math.abs(K[u])>n){var v=u-1;if(K[v]>0){M=this._createMultiUnitRepresentativeEntry(k.sGroupId,P,s,undefined,I);o=this.oModel._getKey(M.oEntry);K[v]=-K[v];m[v]=o;if(v>h){K.splice(h,v-h);m.splice(h,v-h);}if(M.bIsNewEntry){D=1;}else{D=0;}}else if(K[h-1]<0){if(u>h){m[v]=undefined;K.splice(h,v-h+1);m.splice(h,v-h+1);}}else{K[h-1]=-K[h-1];m[h-1]=m[v];m[v]=undefined;K.splice(h,v-h+1);m.splice(h,v-h+1);}}else if(K[u]==n){if(u>h){if(K[h-1]<0){K.splice(h,u-h+1);m.splice(h,u-h+1);D=1;}else{M=this._createMultiUnitRepresentativeEntry(k.sGroupId,P,s,undefined,I);o=this.oModel._getKey(M.oEntry);if(!M.bIsNewEntry){Q.sap.log.fatal("assertion failed: multi-unit entry already existed before");}K[h-1]=-K[h-1];m[h-1]=o;K.splice(h,u-h+1);m.splice(h,u-h+1);D=1;}}}else{Q.sap.log.fatal("assertion failed: uncovered case detected");return D;}}else if(K[u]>n){Q.sap.log.fatal("unstable query result for group ID "+k.sGroupId+": entries have been removed or added. Complete reload required");}else if(u-h>0){K.splice(h,u-h);m.splice(h,u-h);}return D;};f.prototype._createMultiUnitRepresentativeEntry=function(g,r,s,D,i){var m=Q.extend(true,{},r);var R=[];for(var M in this.oMeasureDetailsSet){var o=this.oMeasureDetailsSet[M];if(!i&&!this.mAnalyticalInfoByProperty[M].total){if(o.rawValuePropertyName!=undefined){m[o.rawValuePropertyName]=undefined;}if(o.formattedValuePropertyName!=undefined){m[o.formattedValuePropertyName]=undefined;}}else{if(o.rawValuePropertyName!=undefined){m[o.rawValuePropertyName]=null;}if(o.formattedValuePropertyName!=undefined){m[o.formattedValuePropertyName]="*";}}if(D){if(!o.unitPropertyName||Q.inArray(o.unitPropertyName,D)==-1){R.push(o.rawValuePropertyName);}}}for(var k=0;k<s.length;k++){if(Q.inArray(s[k],D)!=-1){m[s[k]]="*";}}var e="";for(var l=0;l<this.aAllDimensionSortedByName.length;l++){var h=m[this.aAllDimensionSortedByName[l]];var j=h===""?'""':h;j=j===undefined?"":j;e+=(j+",");}e+="-multiple-units-not-dereferencable";var n;if(this.mMultiUnitKey[g]&&(n=Q.inArray(e,this.mMultiUnitKey[g]))!=-1){return{oEntry:this.oModel.getObject("/"+e),bIsNewEntry:false,iIndex:n,aReloadMeasurePropertyName:R};}m.__metadata.uri=e;delete m.__metadata["self"];delete m.__metadata["self_link_extensions"];m["^~volatile"]=true;this.oModel._importData(m,{},{});var p=this.oModel._getKey(m);this.oModel.getContext('/'+p)["_volatile"]=true;return{oEntry:m,bIsNewEntry:true,aReloadMeasurePropertyName:R};};f.prototype._clearAllPendingRequests=function(){this.oPendingRequests={};this.oGroupedRequests={};};f.prototype.resetData=function(o){var g=o?o.getPath():undefined;this._resetData(g);};f.prototype._resetData=function(g){if(g){delete this.mServiceKey[g];delete this.mServiceLength[g];delete this.mServiceFinalLength[g];delete this.mKeyIndex[g];delete this.mLength[g];delete this.mMultiUnitKey[g];delete this.mEntityKey[g];}else{this.mServiceKey={};this.mServiceLength={};this.mServiceFinalLength={};this.mFinalLength=this.mServiceFinalLength;this.mKeyIndex={};this.mLength={};this.mMultiUnitKey={};this.mEntityKey={};}};f.prototype.refresh=function(e){f.prototype._refresh.apply(this,arguments);};f.prototype._refresh=function(e,m,E){var g=false;if(!e){if(E){var r=this.oModel.resolve(this.sPath,this.oContext);var o=this.oModel.oMetadata._getEntityTypeByPath(r);if(o&&(o.entityType in E)){g=true;}}if(m&&!g){Q.each(this.mServiceKey,function(i,n){Q.each(n,function(i,k){if(k in m){g=true;return false;}});if(g){return false;}});}if(!m&&!E){g=true;}}if(e||g){this._abortAllPendingRequests();this.resetData();this.bNeedsUpdate=false;this._fireRefresh({reason:C.Refresh});}};f.prototype.checkUpdate=function(e,m){var g=false;if(!e){if(this.bNeedsUpdate||!m){g=true;}else{Q.each(this.mServiceKey,function(i,n){Q.each(n,function(i,k){if(k in m){g=true;return false;}});if(g){return false;}});}}if(e||g){this.bNeedsUpdate=false;this._fireChange({reason:C.Change});}};f.prototype.getDownloadUrl=function(s){var o=new d.QueryResultRequest(this.oAnalyticalQueryResult);o.setResourcePath(this._getResourcePath());var e=[];var g=[];for(var D in this.oDimensionDetailsSet){e.push(D);}o.setAggregationLevel(e);for(var h in this.oDimensionDetailsSet){var n=this.oDimensionDetailsSet[h];var I=(n.textPropertyName!=undefined);o.includeDimensionKeyTextAttributes(n.name,true,I,n.aAttributeName);}for(var M in this.oMeasureDetailsSet){g.push(M);}o.setMeasures(g);for(var p in this.oMeasureDetailsSet){var q=this.oMeasureDetailsSet[p];var r=(q.rawValuePropertyName!=undefined);var u=(q.formattedValuePropertyName!=undefined);var v=(q.unitPropertyName!=undefined);o.includeMeasureRawFormattedValueUnit(q.name,r,u,v);}var w=o.getSortExpression();w.clear();for(var i=0;i<this.aSorter.length;i++){if(this.aSorter[i]){w.addSorter(this.aSorter[i].sPath,this.aSorter[i].bDescending?d.SortOrder.Descending:d.SortOrder.Ascending);}}var x=o.getFilterExpression();x.clear();if(this.aApplicationFilter){x.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){x.addUI5FilterConditions(this.aControlFilter);}var P=o.getURIToQueryResultEntitySet();var y=this._getQueryODataRequestOptions(o);if(!y){return undefined;}var E=[];for(var k=0,m=this.aAnalyticalInfo.length;k<m;k++){var z=this.aAnalyticalInfo[k];if((z.visible||z.inResult)&&z.name!==""&&z.name!==E[E.length-1]){E.push(z.name);if(this.oMeasureDetailsSet[z.name]!=undefined&&this.oMeasureDetailsSet[z.name].unitPropertyName!=undefined){E.push(this.oMeasureDetailsSet[z.name].unitPropertyName);}}}for(var j=0,l=y.length;j<l;j++){if(/^\$select/i.test(y[j])){y[j]="$select="+E.join(",");break;}}if(s){y.splice(0,0,"$format="+encodeURIComponent(s));}if(this.sCustomParams){y.push(this.sCustomParams);}if(P){return this.oModel._createRequestUrl(P,null,y);}};return f;});
