/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/base/ManagedObject','sap/m/Dialog','sap/m/Popover','sap/m/InstanceManager','sap/ui/core/Popup','sap/ui/dt/OverlayRegistry','sap/ui/dt/Overlay','sap/ui/fl/Utils','sap/ui/core/Component'],function(q,M,D,P,I,a,O,b,f,C){"use strict";var F={"add":"_addFocusEventListeners","remove":"_removeFocusEventListeners"};var c=M.extend("sap.ui.rta.util.PopupManager",{metadata:{properties:{rta:"any"},events:{open:{parameters:{oControl:{type:"sap.ui.core.Control"}}},close:{parameters:{oControl:{type:"sap.ui.core.Control"}}}},library:"sap.ui.rta"}});c.prototype._overrideInstanceFunctions=function(){this._applyPopupMethods(this._createPopupOverlays);this._overrideAddPopupInstance();this._overrideRemovePopupInstance();};c.prototype.getRelevantPopups=function(){var o,d;o=I.getOpenDialogs();d=I.getOpenPopovers();var r={aDialogs:this._getValidatedPopups(o),aPopovers:this._getValidatedPopups(d)};return r;};c.prototype._getValidatedPopups=function(o){o.forEach(function(p,i){if(!this._isSupportedPopup(p)||(this.oRtaRootAppComponent!==this._getAppComponentForControl(p)&&!this._isComponentInsidePopup(p))){o.splice(i,1);}}.bind(this));return(o.length>0)?o:false;};c.prototype._isComponentInsidePopup=function(p){return p.getContent().some(function(o){if(o instanceof sap.ui.core.ComponentContainer){return this.oRtaRootAppComponent===this._getAppComponentForControl(sap.ui.getCore().getComponent(o.getComponent()));}}.bind(this));};c.prototype._isSupportedPopup=function(p){return(p instanceof sap.m.Dialog||p instanceof sap.m.Popover);};c.prototype.setRta=function(r){if(r&&r._oDesignTime){this.setProperty("rta",r);var R=sap.ui.getCore().byId(r.getRootControl());this.oRtaRootAppComponent=this._getAppComponentForControl(R);this._overrideInstanceFunctions();var m=this._onModeChange.bind(this);r.attachModeChanged(m);}};c.prototype._onModeChange=function(e){var s,n=e.getParameters().mode;var A=function(p){p.oPopup[s]();};if(n==='navigation'){s=this._getFocusEventName("add");this._applyFocusEventsToOpenPopups(A);}else{s=this._getFocusEventName("remove");this._removeFocusEventsFromOpenPopups(A);}};c.prototype._applyFocusEventsToOpenPopups=function(d){this._applyPopupMethods(d,true);};c.prototype._removeFocusEventsFromOpenPopups=function(d){this._applyPopupMethods(d);};c.prototype._getFocusEventName=function(o){return F[o];};c.prototype._overrideAddPopupInstance=function(){this._fnOriginalAddDialogInstance=I.addDialogInstance;I.addDialogInstance=this._overrideAddFunctions(this._fnOriginalAddDialogInstance);this._fnOriginalAddPopoverInstance=I.addPopoverInstance;I.addPopoverInstance=this._overrideAddFunctions(this._fnOriginalAddPopoverInstance);};c.prototype._overrideAddFunctions=function(o){return function(p){var v=o.apply(I,arguments);if(this.getRta()._oDesignTime&&this.oRtaRootAppComponent===this._getAppComponentForControl(p)&&this._isSupportedPopup(p)){p.attachAfterOpen(this._createPopupOverlays,this);this.fireOpen(p);}return v;}.bind(this);};c.prototype._applyPopupMethods=function(p,d){var r=this.getRelevantPopups();Object.keys(r).forEach(function(k){if(r[k]){if(d){q.sap.focus(r[k][0].oPopup.oContent);}r[k].forEach(function(o){p.call(this,o);}.bind(this));}}.bind(this));};c.prototype._applyPopupPatch=function(p){var o=O.getOverlay(p);var d=b.getOverlayContainer(o);var e=p.oPopup;var A=[e.oContent.getDomRef(),d];if(this.getRta().getShowToolbars()){A.push(this.getRta().getToolbar().getDomRef());}e.setAutoCloseAreas(A);if(!this.fnOriginalPopupOnAfterRendering){this.fnOriginalPopupOnAfterRendering=e.onAfterRendering;}e.onAfterRendering=function(){var v=this.fnOriginalPopupOnAfterRendering.apply(e,arguments);e[this._getFocusEventName("remove")]();return v;}.bind(this);if(this.getRta().getMode()==='adaptation'){e[this._getFocusEventName("remove")]();}};c.prototype._overrideRemovePopupInstance=function(){this._fnOriginalRemoveDialogInstance=I.removeDialogInstance;I.removeDialogInstance=this._overrideRemoveFunctions(this._fnOriginalRemoveDialogInstance);this._fnOriginalRemovePopoverInstance=I.removePopoverInstance;I.removePopoverInstance=this._overrideRemoveFunctions(this._fnOriginalRemovePopoverInstance);};c.prototype._overrideRemoveFunctions=function(o){return function(p){var v=o.apply(I,arguments);if(this.getRta()._oDesignTime&&this.oRtaRootAppComponent===this._getAppComponentForControl(p)&&this._isSupportedPopup(p)){this.getRta()._oDesignTime.removeRootElement(p);this.fireClose(p);}return v;}.bind(this);};c.prototype._getAppComponentForControl=function(o){var d,A;if(o instanceof sap.ui.core.Component){d=o;}else{d=this._getComponentForControl(o);}if(d){A=f.getAppComponentForControl(d);}return A;};c.prototype._getComponentForControl=function(o){var d;if(o){d=C.getOwnerComponentFor(o);if(!d&&typeof o.getParent==="function"&&!(o.getParent()instanceof sap.ui.core.UIArea)){o=o.getParent();d=this._getComponentForControl(o);}}return d;};c.prototype._createPopupOverlays=function(e){if(!e){return;}var p=(e instanceof sap.ui.core.Control)?e:e.getSource();if(this.getRta()._oDesignTime.getRootElements().indexOf(p.getId())===-1&&!this._isComponentInsidePopup(p)){this.getRta()._oDesignTime.addRootElement(p);}p.detachAfterOpen(this._createPopupOverlays,this);this._applyPopupPatch(p);};c.prototype._restoreInstanceFunctions=function(){if(this._fnOriginalAddDialogInstance){I.addDialogInstance=this._fnOriginalAddDialogInstance;}if(this._fnOriginalRemoveDialogInstance){I.removeDialogInstance=this._fnOriginalRemoveDialogInstance;}if(this._fnOriginalAddPopoverInstance){I.addPopoverInstance=this._fnOriginalAddPopoverInstance;}if(this._fnOriginalRemovePopoverInstance){I.removePopoverInstance=this._fnOriginalRemovePopoverInstance;}this._applyPopupMethods(this._removePopupPatch);};c.prototype._removePopupPatch=function(p){var o=p.oPopup;o[this._getFocusEventName("add")]();if(this.fnOriginalPopupOnAfterRendering){o.onAfterRendering=this.fnOriginalPopupOnAfterRendering;}};c.prototype.exit=function(){this._restoreInstanceFunctions();};return c;},true);
