/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/model/type/Date','sap/ui/unified/calendar/CalendarUtils','./calendar/Header','./calendar/MonthsRow','./calendar/MonthPicker','./calendar/YearPicker','sap/ui/unified/calendar/CalendarDate','sap/ui/core/Renderer'],function(q,C,L,D,a,H,M,b,Y,c,R){"use strict";var d=C.extend("sap.ui.unified.CalendarMonthInterval",{metadata:{library:"sap.ui.unified",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},startDate:{type:"object",group:"Data"},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},months:{type:"int",group:"Appearance",defaultValue:12},pickerPopup:{type:"boolean",group:"Appearance",defaultValue:false},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},header:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},monthsRow:{type:"sap.ui.unified.calendar.MonthsRow",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"},calendarPicker:{type:"sap.ui.unified.Calendar",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},cancel:{},startDateChange:{}}}});d.prototype.init=function(){this._iMode=0;this.data("sap-ui-fastnavgroup","true",true);this._oYearFormat=sap.ui.core.format.DateFormat.getDateInstance({format:"y"});this._oMinDate=a._minDate();this._oMaxDate=a._maxDate();this._initializeHeader();this._initializeMonthsRow();this._initilizeYearPicker();this._iDaysMonthsHead=15;};d.prototype.exit=function(){if(this._sInvalidateContent){q.sap.clearDelayedCall(this._sInvalidateContent);}};d.prototype.onBeforeRendering=function(){var E=this.getAggregation("monthsRow");var F=this._getFocusedDate();j.call(this);E.displayDate(F.toLocalJSDate());};d.prototype._initializeHeader=function(){var E=new H(this.getId()+"--Head",{visibleButton0:false,visibleButton1:false,visibleButton2:true});E.attachEvent("pressPrevious",this._handlePrevious,this);E.attachEvent("pressNext",this._handleNext,this);E.attachEvent("pressButton2",p,this);this.setAggregation("header",E);};d.prototype._initializeMonthsRow=function(){var E=new M(this.getId()+"--MonthsRow");E.attachEvent("focus",t,this);E.attachEvent("select",s,this);E._bNoThemeChange=true;this.setAggregation("monthsRow",E);};d.prototype._initilizeYearPicker=function(){this.setAggregation("yearPicker",this._createYearPicker());};d.prototype._createYearPicker=function(){var E=new Y(this.getId()+"--YP",{columns:0,years:6});E.attachEvent("select",v,this);E.attachEvent("pageChange",A,this);E._oMinDate.setYear(this._oMinDate.getYear());E._oMaxDate.setYear(this._oMaxDate.getYear());return E;};d.prototype._getCalendarPicker=function(){var E=this.getAggregation("calendarPicker");if(!E){E=new B(this.getId()+"--Cal");E.setPopupMode(true);E.attachEvent("select",u,this);E.attachEvent("cancel",function(F){this._oPopup.close();},this);this.setAggregation("calendarPicker",E);}return E;};d.prototype.setStartDate=function(S){a._checkJSDateObject(S);if(q.sap.equal(this.getStartDate(),S)){return this;}var E=S.getFullYear();a._checkYearInValidRange(E);this.setProperty("startDate",S,true);this._oStartDate=c.fromLocalJSDate(S);this._oStartDate.setDate(1);var F=this.getAggregation("monthsRow");F.setStartDate(S);j.call(this);var G=this._getFocusedDate().toLocalJSDate();if(!F.checkDateFocusable(G)){this._setFocusedDate(this._oStartDate);F.displayDate(S);}return this;};d.prototype.invalidate=function(O){if(!this._bDateRangeChanged&&(!O||!(O instanceof sap.ui.unified.DateRange))){C.prototype.invalidate.apply(this,arguments);}else if(this.getDomRef()&&this._iMode==0&&!this._sInvalidateContent){this._sInvalidateContent=q.sap.delayedCall(0,this,w);}};d.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var E=this.removeAllAggregation("selectedDates");return E;};d.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var E=this.destroyAggregation("selectedDates");return E;};d.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var E=this.removeAllAggregation("specialDates");return E;};d.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var E=this.destroyAggregation("specialDates");return E;};d.prototype.setLocale=function(E){if(this._sLocale!=E){this._sLocale=E;this._oLocaleData=undefined;this.invalidate();}return this;};d.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};d.prototype._getFocusedDate=function(){if(!this._oFocusedDate){g.call(this);}return this._oFocusedDate;};d.prototype._setFocusedDate=function(E){a._checkCalendarDate(E);this._oFocusedDate=new c(E);};d.prototype.focusDate=function(E){var F=false;var G=this.getAggregation("monthsRow");if(E&&!G.checkDateFocusable(E)){x.call(this,c.fromLocalJSDate(E));F=true;}o.call(this,E,false);if(F){this.fireStartDateChange();}return this;};d.prototype.displayDate=function(E){o.call(this,E,true);return this;};d.prototype.setMonths=function(E){this.setProperty("months",E,true);E=this._getMonths();var F=this.getAggregation("monthsRow");F.setMonths(E);if(!F.checkDateFocusable(this._getFocusedDate().toLocalJSDate())){var S=e.call(this);this._setFocusedDate(this._oStartDate);F.setDate(S.toLocalJSDate());}if(!this.getPickerPopup()){var G=this.getAggregation("yearPicker");var I=Math.floor(E/2);if(I>20){I=20;}G.setYears(I);}j.call(this);if(this.getDomRef()){if(this._getShowItemHeader()){this.$().addClass("sapUiCalIntHead");}else{this.$().removeClass("sapUiCalIntHead");}}return this;};d.prototype._getMonths=function(){var E=this.getMonths();if(sap.ui.Device.system.phone&&E>6){return 6;}else{return E;}};d.prototype._getLocaleData=function(){if(!this._oLocaleData){var E=this.getLocale();var F=new sap.ui.core.Locale(E);this._oLocaleData=L.getInstance(F);}return this._oLocaleData;};d.prototype.setPickerPopup=function(P){var E;this.setProperty("pickerPopup",P,true);if(P){if(this.getAggregation("yearPicker")){this.getAggregation("yearPicker").destroy();}}else{if(!this.getAggregation("yearPicker")){this.setAggregation("yearPicker",this._createYearPicker());}E=this.getAggregation("yearPicker");E.setColumns(0);E.setYears(6);}return this;};d.prototype.setMinDate=function(E){if(q.sap.equal(E,this.getMinDate())){return this;}if(!E){this._oMinDate=a._minDate();}else{a._checkJSDateObject(E);this._oMinDate=c.fromLocalJSDate(E);this._oMinDate.setDate(1);var F=this._oMinDate.getYear();a._checkYearInValidRange(F);if(this._oMaxDate.isBefore(this._oMinDate)){q.sap.log.warning("minDate > maxDate -> maxDate set to end of the month",this);this._oMaxDate=c.fromLocalJSDate(E);this._oMaxDate.setDate(a._daysInMonth(this._oMaxDate));this.setProperty("maxDate",this._oMaxDate.toLocalJSDate(),true);}if(this._oFocusedDate){if(this._oFocusedDate.isBefore(this._oMinDate)){q.sap.log.warning("focused date < minDate -> minDate focused",this);this.focusDate(E);}}if(this._oStartDate&&this._oStartDate.isBefore(this._oMinDate)){q.sap.log.warning("start date < minDate -> minDate set as start date",this);_.call(this,new c(this._oMinDate),true,true);}}this.setProperty("minDate",E,false);if(this.getPickerPopup()){var G=this._getCalendarPicker();G.setMinDate(E);}else{var I=this.getAggregation("yearPicker");I._oMinDate.setYear(this._oMinDate.getYear());}return this;};d.prototype.setMaxDate=function(E){if(q.sap.equal(E,this.getMaxDate())){return this;}if(!E){this._oMaxDate=a._maxDate();}else{a._checkJSDateObject(E);this._oMaxDate=c.fromLocalJSDate(E);this._oMaxDate.setDate(a._daysInMonth(this._oMaxDate));var F=this._oMaxDate.getYear();a._checkYearInValidRange(F);if(this._oMinDate.isAfter(this._oMaxDate)){q.sap.log.warning("maxDate < minDate -> minDate set to begin of the month",this);this._oMinDate=c.fromLocalJSDate(E);this._oMinDate.setDate(1);this.setProperty("minDate",this._oMinDate.toLocalJSDate(),true);}if(this._oFocusedDate){if(this._oFocusedDate.isAfter(this._oMaxDate)){q.sap.log.warning("focused date > maxDate -> maxDate focused",this);this.focusDate(E);}}if(this._oStartDate){var G=new c(this._oStartDate);G.setDate(1);G.setMonth(G.getMonth()+this._getMonths());G.setDate(0);if(G.isAfter(this._oMaxDate)){var S=new c(this._oMaxDate);S.setDate(1);S.setMonth(S.getMonth()-this._getMonths()+1);if(S.isSameOrAfter(this._oMinDate)){q.sap.log.warning("end date > maxDate -> maxDate set as end date",this);_.call(this,S,true,true);}}}}this.setProperty("maxDate",E,false);if(this.getPickerPopup()){var I=this._getCalendarPicker();I.setMaxDate(E);}else{var J=this.getAggregation("yearPicker");J._oMaxDate.setYear(this._oMaxDate.getYear());}return this;};d.prototype.onclick=function(E){if(E.isMarked("delayedMouseEvent")){return;}if(E.target.id==this.getId()+"-cancel"){this.onsapescape(E);}};d.prototype.onmousedown=function(E){E.preventDefault();E.setMark("cancelAutoClose");};d.prototype.onsapescape=function(E){if(this.getPickerPopup()){r.call(this);this.fireCancel();}else{switch(this._iMode){case 0:this.fireCancel();break;case 1:i.call(this);break;}}};d.prototype.onsaptabnext=function(E){var F=this.getAggregation("header"),G,I;if(q.sap.containsOrEquals(this.getDomRef("content"),E.target)){q.sap.focus(F.getDomRef("B2"));if(!this._bPoupupMode){I=this.getAggregation("monthsRow");q(I._oItemNavigation.getItemDomRefs()[I._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");if(!this.getPickerPopup()){G=this.getAggregation("yearPicker");if(G.getDomRef()){q(G._oItemNavigation.getItemDomRefs()[G._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}E.preventDefault();}};d.prototype.onsaptabprevious=function(E){var F=this.getAggregation("header"),G,I;if(q.sap.containsOrEquals(this.getDomRef("content"),E.target)){if(this._bPoupupMode){q.sap.focus(F.getDomRef("B2"));E.preventDefault();}}else if(E.target.id==F.getId()+"-B2"){switch(this._iMode){case 0:G=this.getAggregation("monthsRow");G._oItemNavigation.focusItem(G._oItemNavigation.getFocusedIndex());break;case 1:if(!this.getPickerPopup()){I=this.getAggregation("yearPicker");I._oItemNavigation.focusItem(I._oItemNavigation.getFocusedIndex());}break;}E.preventDefault();}};d.prototype.onfocusin=function(E){if(E.target.id==this.getId()+"-end"){var F=this.getAggregation("header"),G,I;q.sap.focus(F.getDomRef("B2"));if(!this._bPoupupMode){G=this.getAggregation("monthsRow");q(G._oItemNavigation.getItemDomRefs()[G._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");if(!this.getPickerPopup()){I=this.getAggregation("yearPicker");if(I.getDomRef()){q(I._oItemNavigation.getItemDomRefs()[I._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}}this.$("end").attr("tabindex","-1");};d.prototype.onsapfocusleave=function(E){var F,G;if(!E.relatedControlId||!q.sap.containsOrEquals(this.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())){this.$("end").attr("tabindex","0");if(!this._bPoupupMode){switch(this._iMode){case 0:F=this.getAggregation("monthsRow");q(F._oItemNavigation.getItemDomRefs()[F._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");break;case 1:if(!this.getPickerPopup()){G=this.getAggregation("yearPicker");q(G._oItemNavigation.getItemDomRefs()[G._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;}}}};d.prototype._handlePrevious=function(E){var F,G,S,I;switch(this._iMode){case 0:F=this._getFocusedDate();G=this._getMonths();S=new c(e.call(this));S.setMonth(S.getMonth()-G);F.setMonth(F.getMonth()-G);this._setFocusedDate(F);_.call(this,S,true);break;case 1:if(!this.getPickerPopup()){I=this.getAggregation("yearPicker");I.previousPage();l.call(this);}break;}};d.prototype._handleNext=function(E){var F,G,S,I;switch(this._iMode){case 0:F=this._getFocusedDate();G=this._getMonths();S=new c(e.call(this));S.setMonth(S.getMonth()+G);F.setMonth(F.getMonth()+G);this._setFocusedDate(F);_.call(this,S,true);break;case 1:if(!this.getPickerPopup()){I=this.getAggregation("yearPicker");I.nextPage();l.call(this);}break;}};d.prototype._showOverlay=function(){this.$("contentOver").css("display","");};d.prototype._hideOverlay=function(){this.$("contentOver").css("display","none");};d.prototype._getShowItemHeader=function(){var E=this.getMonths();if(E>this._iDaysMonthsHead){return true;}else{return false;}};function _(S,E,F){var G=new c(this._oMaxDate);G.setDate(1);G.setMonth(G.getMonth()-this._getMonths()+1);if(G.isBefore(this._oMinDate)){G=new c(this._oMinDate);G.setMonth(G.getMonth()+this._getMonths()-1);}if(S.isBefore(this._oMinDate)){S=new c(this._oMinDate);}else if(S.isAfter(G)){S=G;}S.setDate(1);var I=S.toLocalJSDate();this.setProperty("startDate",I,true);this._oStartDate=S;var J=this.getAggregation("monthsRow");J.setStartDate(I);j.call(this);if(E){var K=this._getFocusedDate().toLocalJSDate();if(!J.checkDateFocusable(K)){this._setFocusedDate(S);J.setDate(I);}else{J.setDate(K);}}if(!F){this.fireStartDateChange();}}function e(){if(!this._oStartDate){this._oStartDate=this._getFocusedDate();this._oStartDate.setDate(1);}return this._oStartDate;}function f(N){var E=this._getFocusedDate();var F=this.getAggregation("monthsRow");if(!N){F.setDate(E.toLocalJSDate());}else{F.displayDate(E.toLocalJSDate());}j.call(this);}function g(){var S=this.getSelectedDates();if(S&&S[0]&&S[0].getStartDate()){this._oFocusedDate=c.fromLocalJSDate(S[0].getStartDate());}else{this._oFocusedDate=new c();}this._oFocusedDate.setDate(1);if(this._oFocusedDate.isBefore(this._oMinDate)){this._oFocusedDate=new c(this._oMinDate);}else if(this._oFocusedDate.isAfter(this._oMaxDate)){this._oFocusedDate=new c(this._oMaxDate);}}function h(){var E=this._getFocusedDate();var F=this.getAggregation("yearPicker");if(F.getDomRef()){F.$().css("display","");}else{var G=sap.ui.getCore().createRenderManager();var $=this.$("content");G.renderControl(F);G.flush($[0],false,true);G.destroy();}this._showOverlay();F.setDate(E.toLocalJSDate());if(this._iMode==0){var I=this.getAggregation("monthsRow");q(I._oItemNavigation.getItemDomRefs()[I._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}l.call(this);this._iMode=1;}function i(N){this._iMode=0;var E=this.getAggregation("yearPicker");E.$().css("display","none");this._hideOverlay();if(!N){f.call(this);var F=this.getAggregation("monthsRow");q(F._oItemNavigation.getItemDomRefs()[F._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}function j(){m.call(this);k.call(this);}function k(){var E=new c(e.call(this));var F=this._getMonths();var G=E.getYear();var I=this._oMaxDate.getYear();var J=this._oMinDate.getYear();var K=E.getMonth();var N=this._oMaxDate.getMonth();var O=this._oMinDate.getMonth();var P=this.getAggregation("header");if(G<J||(G==J&&K<=O)){P.setEnabledPrevious(false);}else{P.setEnabledPrevious(true);}E.setMonth(E.getMonth()+F-1);G=E.getYear();K=E.getMonth();if(G>I||(G==I&&K>=N)){P.setEnabledNext(false);}else{P.setEnabledNext(true);}}function l(){var E=this.getAggregation("yearPicker");var F=E.getYears();var G=c.fromLocalJSDate(E.getFirstRenderedDate());G.setYear(G.getYear()+Math.floor(F/2));var I=this.getAggregation("header");var J=new c(this._oMaxDate);J.setYear(J.getYear()-Math.ceil(F/2));J.setMonth(11,31);var K=new c(this._oMinDate);K.setYear(K.getYear()+Math.floor(F/2)+1);K.setMonth(0,1);I.setEnabledNext(!G.isAfter(J));I.setEnabledPrevious(!G.isBefore(K));}function m(){var T;var S=e.call(this);var E=this._oYearFormat.format(S.toUTCJSDate(),true);var F=new c(S);F.setMonth(F.getMonth()+this._getMonths()-1);var G=this._oYearFormat.format(F.toUTCJSDate(),true);if(E!=G){var I=this._getLocaleData();var P=I.getIntervalPattern();T=P.replace(/\{0\}/,E).replace(/\{1\}/,G);}else{T=E;}var J=this.getAggregation("header");J.setTextButton2(T);}function n(E,N){var F;var G=false;if(E.isBefore(this._oMinDate)){F=this._oMinDate;G=true;}else if(E.isAfter(this._oMaxDate)){F=this._oMaxDate;G=true;}else{F=E;}this._setFocusedDate(F);if(G||N){x.call(this,F);f.call(this,false);this.fireStartDateChange();}}function o(E,S){if(!E){return;}var F=c.fromLocalJSDate(E);if(this._oFocusedDate&&this._oFocusedDate.isSame(F)){return;}var G=F.getYear();a._checkYearInValidRange(G);if(a._isOutside(F,this._oMinDate,this._oMaxDate)){throw new Error("Date must not be in valid range (minDate and maxDate); "+this);}this._setFocusedDate(F);if(this.getDomRef()&&this._iMode==0){f.call(this,S);}}function p(E){if(this.getPickerPopup()){this._showCalendarPicker();}else{if(this._iMode!=1){h.call(this);}else{i.call(this);}}}d.prototype._showCalendarPicker=function(){var E=this._getFocusedDate(true).toLocalJSDate();var F=this._getCalendarPicker();var S=new sap.ui.unified.DateRange({startDate:E});F.displayDate(E,false);F.removeAllSelectedDates();F.addSelectedDate(S);F.setMinDate(this.getMinDate());F.setMaxDate(this.getMaxDate());y.call(this,F);this._showOverlay();};function r(N){if(this._oPopup&&this._oPopup.isOpen()){this._oPopup.close();}this._hideOverlay();if(!N){f.call(this);var E=this.getAggregation("monthsRow");q(E._oItemNavigation.getItemDomRefs()[E._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}function s(E){this.fireSelect();}function t(E){var F=c.fromLocalJSDate(E.getParameter("date"));var N=E.getParameter("notVisible");n.call(this,F,N);}function u(E){var F=new c(this._getFocusedDate());var G=this._getCalendarPicker();var S=G.getSelectedDates()[0].getStartDate();var N=c.fromLocalJSDate(S);N.setMonth(F.getMonth());N.setDate(F.getDate());n.call(this,N,true);r.call(this);}function v(E){var F=new c(this._getFocusedDate());var G=this.getAggregation("yearPicker");var I=c.fromLocalJSDate(G.getDate());I.setMonth(F.getMonth());I.setDate(F.getDate());F=I;n.call(this,F,true);i.call(this);}function w(){this._sInvalidateContent=undefined;var E=this.getAggregation("monthsRow");E._bDateRangeChanged=true;E._bInvalidateSync=true;E.invalidate();E._bInvalidateSync=undefined;this._bDateRangeChanged=undefined;}function x(E){var F=this.getAggregation("monthsRow");var S=e.call(this);var G=F._oItemNavigation.getFocusedIndex();S=new c(E);S.setMonth(S.getMonth()-G);_.call(this,S,false,true);}function y(P){if(!this._oPopup){q.sap.require("sap.ui.core.Popup");this._oPopup=new sap.ui.core.Popup();this._oPopup.setAutoClose(true);this._oPopup.setAutoCloseAreas([this.getDomRef()]);this._oPopup.setDurations(0,0);this._oPopup._oCalendar=this;this._oPopup.attachClosed(z,this);this._oPopup.onsapescape=function(G){this._oCalendar.onsapescape(G);};}this._oPopup.setContent(P);var E=this.getAggregation("header");var F=sap.ui.core.Popup.Dock;this._oPopup.open(0,F.CenterTop,F.CenterTop,E,null,"flipfit",true);}function z(E){r.call(this);}function A(E){l.call(this);}var B=sap.ui.unified.Calendar.extend("CustomYearPicker",{renderer:R.extend(sap.ui.unified.CalendarRenderer)});B.prototype._initializeHeader=function(){var E=new H(this.getId()+"--Head",{visibleButton1:false});E.attachEvent("pressPrevious",this._handlePrevious,this);E.attachEvent("pressNext",this._handleNext,this);E.attachEvent("pressButton2",this._handleButton2,this);this.setAggregation("header",E);};B.prototype.onAfterRendering=function(){sap.ui.unified.Calendar.prototype.onAfterRendering.apply(this,arguments);var E=this.getAggregation("header");E.$("B2").css("background-color","inherit").css("color","inherit").css("cursor","inherit").css("pointer-events","none");this._showYearPicker();};B.prototype.onThemeChanged=function(){sap.ui.unified.Calendar.prototype.onThemeChanged.apply(this,arguments);var E=this.getAggregation("header");E.$("B2").css("background-color","inherit").css("color","inherit").css("cursor","inherit").css("pointer-events","none");};B.prototype._selectYear=function(){var E=this.getAggregation("yearPicker");var F=this.getSelectedDates()[0];if(!F){F=new sap.ui.unified.DateRange();}F.setStartDate(E.getDate());this.addSelectedDate(F);this.fireSelect();};B.prototype.onsapescape=function(E){this.fireCancel();};B.prototype._shouldFocusB2OnTabPrevious=function(E){return false;};return d;},true);
