/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/Device','sap/ui/core/LocaleData','sap/ui/model/type/Date','sap/ui/unified/calendar/CalendarUtils','sap/ui/core/date/UniversalDate','./library'],function(q,C,D,L,a,b,U,l){"use strict";var c=C.extend("sap.ui.unified.CalendarRow",{metadata:{library:"sap.ui.unified",properties:{startDate:{type:"object",group:"Data"},intervals:{type:"int",group:"Appearance",defaultValue:12},intervalType:{type:"sap.ui.unified.CalendarIntervalType",group:"Appearance",defaultValue:sap.ui.unified.CalendarIntervalType.Hour},showSubIntervals:{type:"boolean",group:"Appearance",defaultValue:false},showIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},showEmptyIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},nonWorkingDays:{type:"int[]",group:"Misc",defaultValue:null},nonWorkingHours:{type:"int[]",group:"Misc",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},checkResize:{type:"boolean",group:"Behavior",defaultValue:true},updateCurrentTime:{type:"boolean",group:"Behavior",defaultValue:true},groupAppointmentsMode:{type:"sap.ui.unified.GroupAppointmentsMode",group:"Appearance",defaultValue:sap.ui.unified.GroupAppointmentsMode.Collapsed},appointmentsReducedHeight:{type:"boolean",group:"Appearance",defaultValue:false},appointmentsVisualization:{type:"sap.ui.unified.CalendarAppointmentVisualization",group:"Appearance",defaultValue:sap.ui.unified.CalendarAppointmentVisualization.Standard}},aggregations:{appointments:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"appointment"},intervalHeaders:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"intervalHeader"},groupAppointments:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"groupAppointment",visibility:"hidden"},_nonWorkingDates:{type:"sap.ui.unified.DateRange",multiple:true,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{parameters:{appointment:{type:"sap.ui.unified.CalendarAppointment"},appointments:{type:"sap.ui.unified.CalendarAppointment[]"},multiSelect:{type:"boolean"},domRefId:{type:"string"}}},startDateChange:{},leaveRow:{parameters:{type:{type:"string"}}},intervalSelect:{parameters:{startDate:{type:"object"},endDate:{type:"object"},subInterval:{type:"boolean"}}}}}});c.PCROW_FOREIGN_KEY_NAME="relatedToPCRowDateRange";var d=sap.ui.unified.CalendarIntervalType;c.AGGR_NONWORKING_DATES_NAME="_nonWorkingDates";c.prototype.init=function(){this._bRTL=sap.ui.getCore().getConfiguration().getRTL();this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");if(!c._oStaticAppointmentText){c._oStaticAppointmentText=new sap.ui.core.InvisibleText({text:this._oRb.getText("APPOINTMENT")});c._oStaticAppointmentText.toStatic();c._oStaticTentativeText=new sap.ui.core.InvisibleText({text:this._oRb.getText("APPOINTMENT_TENTATIVE")});c._oStaticTentativeText.toStatic();}if(!c._oStaticSelectedText){c._oStaticSelectedText=new sap.ui.core.InvisibleText({text:this._oRb.getText("APPOINTMENT_SELECTED")});c._oStaticSelectedText.toStatic();}this._oFormatAria=sap.ui.core.format.DateFormat.getDateTimeInstance({pattern:"EEEE dd/MM/YYYY 'at' HH:mm:ss a"});this._iHoursMinDelta=1;this._iDaysMinDelta=30;this._iMonthsMinDelta=720;this._aVisibleAppointments=[];this._aVisibleIntervalHeaders=[];this.setStartDate(new Date());this._resizeProxy=q.proxy(this.handleResize,this);};c.prototype.exit=function(){if(this._sResizeListener){sap.ui.core.ResizeHandler.deregister(this._sResizeListener);this._sResizeListener=undefined;}if(this._sUpdateCurrentTime){q.sap.clearDelayedCall(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}};c.prototype.onBeforeRendering=function(){f.call(this);m.call(this);r.call(this);if(this._sUpdateCurrentTime){q.sap.clearDelayedCall(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}};c.prototype.onAfterRendering=function(){s.call(this);this.updateCurrentTimeVisualization();if(this.getCheckResize()&&!this._sResizeListener){this._sResizeListener=sap.ui.core.ResizeHandler.register(this,this._resizeProxy);}};c.prototype.onThemeChanged=function(E){if(this.getDomRef()){for(var i=0;i<this._aVisibleAppointments.length;i++){var A=this._aVisibleAppointments[i];A.level=-1;}this.handleResize(E);}};c.prototype.invalidate=function(O){if(O&&O instanceof sap.ui.unified.CalendarAppointment){var F=false;for(var i=0;i<this._aVisibleAppointments.length;i++){if(this._aVisibleAppointments[i].appointment==O){F=true;break;}}if(F){this._aVisibleAppointments=[];}}C.prototype.invalidate.apply(this,arguments);};c.prototype.setStartDate=function(S){if(!S){S=new Date();}b._checkJSDateObject(S);var Y=S.getFullYear();b._checkYearInValidRange(Y);this.setProperty("startDate",S);return this;};c.prototype._getStartDate=function(){if(!this._oUTCStartDate){this._oUTCStartDate=b._createUniversalUTCDate(this.getStartDate(),undefined,true);}return this._oUTCStartDate;};c.prototype.setIntervalType=function(i){this.setProperty("intervalType",i);this._aVisibleAppointments=[];return this;};c.prototype.setGroupAppointmentsMode=function(G){this.setProperty("groupAppointmentsMode",G);this._aVisibleAppointments=[];return this;};c.prototype.setAppointmentsReducedHeight=function(A){this.setProperty("appointmentsReducedHeight",A);this._aVisibleAppointments=[];return this;};c.prototype._getAppointmentReducedHeight=function(A){var R=false;if(!D.system.phone&&this.getAppointmentsReducedHeight()&&!A.getText()){R=true;}return R;};c.prototype.onfocusin=function(E){if(q(E.target).hasClass("sapUiCalendarApp")){w.call(this,E.target.id);}else{var V=this._getVisibleAppointments();var F=false;var A;for(var i=0;i<V.length;i++){A=V[i].appointment;if(q.sap.containsOrEquals(A.getDomRef(),E.target)){F=true;A.focus();break;}}if(!F){A=this.getFocusedAppointment();if(A){A.focus();}}}};c.prototype.applyFocusInfo=function(F){if(this._sFocusedAppointmentId){this.getFocusedAppointment().focus();}return this;};c.prototype.onsapleft=function(E){if(q(E.target).hasClass("sapUiCalendarApp")){x.call(this,this._bRTL,1);}E.preventDefault();E.stopPropagation();};c.prototype.onsapright=function(E){if(q(E.target).hasClass("sapUiCalendarApp")){x.call(this,!this._bRTL,1);}E.preventDefault();E.stopPropagation();};c.prototype.onsapup=function(E){this.fireLeaveRow({type:E.type});};c.prototype.onsapdown=function(E){this.fireLeaveRow({type:E.type});};c.prototype.onsaphome=function(E){y.call(this,E);E.preventDefault();E.stopPropagation();};c.prototype.onsapend=function(E){y.call(this,E);E.preventDefault();E.stopPropagation();};c.prototype.onsapselect=function(E){var V=this._getVisibleAppointments();for(var i=0;i<V.length;i++){var A=V[i].appointment;if(q.sap.containsOrEquals(A.getDomRef(),E.target)){t.call(this,A,!E.ctrlKey);break;}}E.stopPropagation();E.preventDefault();};c.prototype.ontap=function(E){var i=this.$("Apps").children(".sapUiCalendarRowAppsInt");var I=0;var j=false;for(I=0;I<i.length;I++){var k=i[I];if(!this._isOneMonthIntervalOnSmallSizes()&&q.sap.containsOrEquals(k,E.target)){j=true;break;}}if(j){z.call(this,I,E.target);}else{this.onsapselect(E);}};c.prototype.onsapselectmodifiers=function(E){this.onsapselect(E);};c.prototype.handleResize=function(E){if(E&&E.size&&E.size.width<=0){return this;}var $=this.$("DummyApp");$.css("display","");s.call(this);return this;};c.prototype.updateCurrentTimeVisualization=function(){var N=this.$("Now");var i=b._createUniversalUTCDate(new Date(),undefined,true);var I=this.getIntervals();var j=this.getIntervalType();var S=this._getStartDate();var k=S.getTime();var E=this._oUTCEndDate;var A=E.getTime();this._sUpdateCurrentTime=undefined;if(i.getTime()<=A&&i.getTime()>=k){var B=o.call(this,j,I,S,E,k,i);var T=0;if(this._bRTL){N.css("right",B+"%");}else{N.css("left",B+"%");}N.css("display","");if(this.getUpdateCurrentTime()){switch(j){case d.Hour:T=60000;break;case d.Day:case d.Week:case d.OneMonth:T=1800000;break;default:T=-1;break;}if(T>0){this._sUpdateCurrentTime=q.sap.delayedCall(T,this,this.updateCurrentTimeVisualization);}}}else{N.css("display","none");}return this;};c.prototype.getFocusedAppointment=function(){var A=u.call(this);var G=this.getAggregation("groupAppointments",[]);var j;var i=0;for(i=0;i<G.length;i++){if(G[i].getId()==this._sFocusedAppointmentId){j=G[i];break;}}if(!j){for(i=0;i<A.length;i++){if(A[i].getId()==this._sFocusedAppointmentId){j=A[i];break;}}}return j;};c.prototype.focusAppointment=function(A){if(!A||!(A instanceof sap.ui.unified.CalendarAppointment)){throw new Error("Appointment must be a CalendarAppointment; "+this);}var i=A.getId();if(this._sFocusedAppointmentId!=i){w.call(this,i);}else{A.focus();}return this;};c.prototype.focusNearestAppointment=function(j){b._checkJSDateObject(j);var A=u.call(this);var N;var P;var k;for(var i=0;i<A.length;i++){N=A[i];if(N.getStartDate()>j){if(i>0){P=A[i-1];}else{P=N;}break;}}if(N){if(P&&Math.abs(N.getStartDate()-j)>=Math.abs(P.getStartDate()-j)){k=P;}else{k=N;}this.focusAppointment(k);}return this;};c.prototype._getVisibleAppointments=function(){return this._aVisibleAppointments;};c.prototype._getVisibleIntervalHeaders=function(){return this._aVisibleIntervalHeaders;};c.prototype._getNonWorkingDays=function(){var N=this.getNonWorkingDays();if(!N){var j=e.call(this);var W=j.getWeekendStart();var k=j.getWeekendEnd();N=[];for(var i=0;i<=6;i++){if((W<=k&&i>=W&&i<=k)||(W>k&&(i>=W||i<=k))){N.push(i);}}}else if(!q.isArray(N)){N=[];}return N;};c.prototype._isOneMonthIntervalOnSmallSizes=function(){return this.getIntervalType()===d.OneMonth&&this.getIntervals()===1;};function _(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;}function e(){if(!this._oLocaleData){var i=_.call(this);var j=new sap.ui.core.Locale(i);this._oLocaleData=L.getInstance(j);}return this._oLocaleData;}function f(){var S=this.getStartDate();var E;var i=this.getIntervals();var I=this.getIntervalType();this._oUTCStartDate=g.call(this,S);switch(I){case d.Hour:E=new U(this._oUTCStartDate.getTime());E.setUTCHours(E.getUTCHours()+i);this._iMinDelta=this._iHoursMinDelta;break;case d.Day:case d.Week:case d.OneMonth:E=new U(this._oUTCStartDate.getTime());E.setUTCDate(E.getUTCDate()+i);this._iMinDelta=this._iDaysMinDelta;break;case d.Month:E=new U(this._oUTCStartDate.getTime());E.setUTCMonth(E.getUTCMonth()+i);this._iMinDelta=this._iMonthsMinDelta;break;default:throw new Error("Unknown IntervalType: "+I+"; "+this);}E.setUTCMilliseconds(-1);this._iRowSize=E.getTime()-this._oUTCStartDate.getTime();this._iIntervalSize=Math.floor(this._iRowSize/i);this._oUTCEndDate=E;}function g(i){var I=this.getIntervalType();var j=b._createUniversalUTCDate(i,undefined,true);switch(I){case d.Hour:j.setUTCMinutes(0);j.setUTCSeconds(0);j.setUTCMilliseconds(0);break;case d.Day:case d.Week:case d.OneMonth:j.setUTCHours(0);j.setUTCMinutes(0);j.setUTCSeconds(0);j.setUTCMilliseconds(0);break;case d.Month:j.setUTCDate(1);j.setUTCHours(0);j.setUTCMinutes(0);j.setUTCSeconds(0);j.setUTCMilliseconds(0);break;default:throw new Error("Unknown IntervalType: "+I+"; "+this);}return j;}function h(){return D.system.phone||(this.getGroupAppointmentsMode()===sap.ui.unified.GroupAppointmentsMode.Collapsed);}function m(){var O=this._aVisibleAppointments||[];var A=u.call(this);var B;var G;var E;var I=this.getIntervals();var F=this.getIntervalType();var S=this._getStartDate();var H=S.getTime();var J=this._oUTCEndDate;var K=J.getTime();var V=[];var M=false;var i=0;var j=0;var N=h.call(this);this.destroyAggregation("groupAppointments",true);for(i=0;i<A.length;i++){B=A[i];var P=b._createUniversalUTCDate(B.getStartDate(),undefined,true);P.setUTCSeconds(0);P.setUTCMilliseconds(0);var Q=B.getEndDate()?b._createUniversalUTCDate(B.getEndDate(),undefined,true):b._createUniversalUTCDate(new Date(864000000000000),undefined,true);Q.setUTCSeconds(0);Q.setUTCMilliseconds(0);var R=false;if(P.getTime()<H&&Q.getTime()>=H){P=new U(H);R=true;}if(Q.getTime()>K&&P.getTime()<=K){Q=new U(K);R=true;}var T=P.getUTCHours()*60+P.getUTCMinutes();P.setUTCMinutes(P.getUTCMinutes()-(T%this._iMinDelta));var W=(Q.getTime()-P.getTime())/60000;if(R&&W==0){continue;}var X=0;var Y=0;var Z=-1;G=undefined;E=undefined;if(P&&P.getTime()<=K&&Q&&Q.getTime()>=H){if(N&&(F==d.Month)&&((Q.getTime()-P.getTime())<604800000)){G=n.call(this,P,B,F,I,S,J,H,V);var $=b._createUniversalUTCDate(G.getEndDate(),undefined,true);if(Q.getTime()>$.getTime()){E=n.call(this,Q,B,F,I,S,J,H,V);}}X=o.call(this,F,I,S,J,H,P);Y=p.call(this,F,I,S,J,H,Q);for(j=0;j<O.length;j++){var a1=O[j];if(B==a1.appointment){Z=a1.level;}}if(G){G._iBegin=X;G._iEnd=Y;G._iLevel=Z;if(E){E._iBegin=X;E._iEnd=Y;E._iLevel=Z;}continue;}V.push({appointment:B,begin:X,end:Y,calculatedEnd:Y,level:Z});if(this._sFocusedAppointmentId&&this._sFocusedAppointmentId==B.getId()){M=true;}}}var b1=this.getAggregation("groupAppointments",[]);if(b1.length>0){for(i=0;i<V.length;i++){B=V[i];if(B.appointment._aAppointments&&B.appointment._aAppointments.length<=1){G=B.appointment;var c1=false;if(G._aAppointments.length==0){c1=true;}else{for(j=0;j<V.length;j++){if(V[j].appointment==G._aAppointments[0]){c1=true;break;}}}if(!c1){for(j=0;j<b1.length;j++){E=b1[j];if(G!=E){for(var k=0;k<E._aAppointments.length;k++){if(G._aAppointments[0]==E._aAppointments[k]){E._aAppointments.splice(k,1);if(E._aAppointments.length==1){this.removeAggregation("groupAppointments",E);E.destroy();b1=this.getAggregation("groupAppointments",[]);}else{E.setProperty("title",E._aAppointments.length,true);}break;}}}}B.begin=G._iBegin;B.end=G._iEnd;B.calculatedEnd=G._iEnd;B.level=G._iLevel;B.appointment=G._aAppointments[0];}else{V.splice(i,1);i--;}this.removeAggregation("groupAppointments",G);G.destroy();b1=this.getAggregation("groupAppointments",[]);}}}if(!M){if(V.length>0){this._sFocusedAppointmentId=V[0].appointment.getId();}else{this._sFocusedAppointmentId=undefined;}}this._aVisibleAppointments=V;return this._aVisibleAppointments;}function n(i,A,I,k,S,E,B,V){var G=this.getAggregation("groupAppointments",[]);var F;var H=e.call(this);var J=H.getFirstDayOfWeek();var K=i.getUTCDay();var M=new U(i.getTime());M.setUTCHours(0);M.setUTCMinutes(0);M.setUTCSeconds(0);M.setUTCMilliseconds(0);if(J<=K){M.setDate(M.getDate()-(K-J));}else{M.setDate(M.getDate()-(7-K-J));}for(var j=0;j<G.length;j++){F=G[j];var N=b._createUniversalUTCDate(F.getStartDate(),undefined,true);if(N.getTime()==M.getTime()){break;}F=undefined;}if(!F){var O=new U(M.getTime());O.setDate(O.getDate()+7);O.setMilliseconds(-1);F=new sap.ui.unified.CalendarAppointment(this.getId()+"-Group"+G.length,{type:A.getType(),startDate:b._createLocalDate(new Date(M.getTime()),true),endDate:b._createLocalDate(new Date(O.getTime()),true)});F._aAppointments=[];this.addAggregation("groupAppointments",F,true);var P=o.call(this,I,k,S,E,B,M);var Q=p.call(this,I,k,S,E,B,O);V.push({appointment:F,begin:P,end:Q,calculatedEnd:Q,level:-1});}F._aAppointments.push(A);if(F.getType()!=sap.ui.unified.CalendarDayType.None&&F.getType()!=A.getType()){F.setType(sap.ui.unified.CalendarDayType.None);}F.setProperty("title",F._aAppointments.length,true);return F;}function o(i,I,S,E,j,A){var B=0;if(i!=d.Month){B=100*(A.getTime()-j)/this._iRowSize;}else{var M=new U(A.getTime());M.setUTCDate(1);M.setUTCHours(0);M.setUTCMinutes(0);M.setUTCSeconds(0);M.setUTCMilliseconds(0);var k=new U(M.getTime());k.setUTCMonth(k.getUTCMonth()+1);k.setMilliseconds(-1);var F=k.getTime()-M.getTime();var G=(M.getUTCFullYear()-S.getUTCFullYear())*12+M.getUTCMonth()-S.getUTCMonth();B=(100*G/I)+(100*(A.getTime()-M.getTime())/F)/I;}if(B<0){B=0;}B=Math.round(B*100000)/100000;return B;}function p(i,I,S,E,j,A){var k=0;if(i!=d.Month){k=100-(100*(A.getTime()-j)/this._iRowSize);}else{var M=new U(A.getTime());M.setUTCDate(1);M.setUTCHours(0);M.setUTCMinutes(0);M.setUTCSeconds(0);M.setUTCMilliseconds(0);var B=new U(M.getTime());B.setUTCMonth(B.getUTCMonth()+1);B.setMilliseconds(-1);var F=B.getTime()-M.getTime();var G=(M.getUTCFullYear()-S.getUTCFullYear())*12+M.getUTCMonth()-S.getUTCMonth();k=100-((100*G/I)+(100*(A.getTime()-M.getTime())/F)/I);}if(k<0){k=0;}k=Math.round(k*100000)/100000;return k;}function r(){var V=[];if(this.getShowIntervalHeaders()){var A=this.getIntervalHeaders();var k;var I=this.getIntervals();var B=this.getIntervalType();var S=this._getStartDate();var E=S.getTime();var F=this._oUTCEndDate;var G=F.getTime();var i=0;var j=0;for(i=0;i<A.length;i++){k=A[i];var H=b._createUniversalUTCDate(k.getStartDate(),undefined,true);H.setUTCSeconds(0);H.setUTCMilliseconds(0);var J=k.getEndDate()?b._createUniversalUTCDate(k.getEndDate(),undefined,true):b._createUniversalUTCDate(new Date(864000000000000),undefined,true);J.setUTCSeconds(0);J.setUTCMilliseconds(0);if(H&&H.getTime()<=G&&J&&J.getTime()>=E){var K=new U(S.getTime());var M=new U(S.getTime());M.setUTCMinutes(M.getUTCMinutes()-1);var N=-1;var O=-1;for(j=0;j<I;j++){switch(B){case d.Hour:M.setUTCHours(M.getUTCHours()+1);if(j>0){K.setUTCHours(K.getUTCHours()+1);}break;case d.Day:case d.Week:case d.OneMonth:M.setUTCDate(M.getUTCDate()+1);if(j>0){K.setUTCDate(K.getUTCDate()+1);}break;case d.Month:M.setUTCDate(1);M.setUTCMonth(M.getUTCMonth()+2);M.setUTCDate(0);if(j>0){K.setUTCMonth(K.getUTCMonth()+1);}break;default:throw new Error("Unknown IntervalType: "+B+"; "+this);}if(H&&H.getTime()<=K.getTime()&&J&&J.getTime()>=M.getTime()){if(N<0){N=j;}O=j;}}if(N>=0){V.push({interval:N,appointment:k,last:O});}}}}this._aVisibleIntervalHeaders=V;return this._aVisibleIntervalHeaders;}function s(){if(this._isOneMonthIntervalOnSmallSizes()){return;}var A=this.$("Apps");var R=A.innerWidth();if(R<=0){return;}var $=this.$("DummyApp");var H=$.outerHeight(true);if(H<=0){return;}var M=$.outerWidth();var k=M/R*100;var B=Math.ceil(1000*k)/1000;var E;var F;var S=0;var G=0;var i=0;var I=!D.system.phone&&this.getAppointmentsReducedHeight();if(this.getShowIntervalHeaders()&&(this.getShowEmptyIntervalHeaders()||this._getVisibleIntervalHeaders().length>0)){S=q(this.$("AppsInt0").children(".sapUiCalendarRowAppsIntHead")[0]).outerHeight(true);}for(i=0;i<this._aVisibleAppointments.length;i++){E=this._aVisibleAppointments[i];F=E.appointment.$();var P=Math.floor(1000*(100-E.calculatedEnd-E.begin))/1000;var J=false;if(P<B){E.end=100-E.begin-k;if(E.end<0){E.end=0;}E.level=-1;J=true;F.addClass("sapUiCalendarAppSmall");}else if(F.hasClass("sapUiCalendarAppSmall")){E.end=E.calculatedEnd;J=true;F.removeClass("sapUiCalendarAppSmall");}if(J){if(this._bRTL){F.css("left",E.end+"%");}else{F.css("right",E.end+"%");}}}for(i=0;i<this._aVisibleAppointments.length;i++){E=this._aVisibleAppointments[i];F=E.appointment.$();var K={};var T=I&&!this._getAppointmentReducedHeight(E.appointment);if(E.level<0){for(var j=0;j<this._aVisibleAppointments.length;j++){var V=this._aVisibleAppointments[j];if(E!=V&&E.begin<(Math.floor(1000*(100-V.end))/1000)&&(Math.floor(1000*(100-E.end))/1000)>V.begin&&V.level>=0){if(K[V.level]){K[V.level]++;}else{K[V.level]=1;}if(I&&!this._getAppointmentReducedHeight(V.appointment)){if(K[V.level+1]){K[V.level+1]++;}else{K[V.level+1]=1;}}}}E.level=0;while(K[E.level]||(T&&K[E.level+1])){E.level++;}F.attr("data-sap-level",E.level);}F.css("top",(H*E.level+S)+"px");var N=E.level;if(T){N++;}if(G<N){G=N;}}G++;H=H*G+S;if(!this.getHeight()){A.outerHeight(H);}else{var O=this.$("Apps").children(".sapUiCalendarRowAppsInt");for(i=0;i<O.length;i++){var Q=q(O[i]);Q.outerHeight(H);}}$.css("display","none");}function t(A,R){var i=0;var O;var j;var k;var B;var S=sap.ui.unified.CalendarRow._oStaticSelectedText.getId();if(R){var E=this.getAppointments();var G=this.getAggregation("groupAppointments",[]);q.merge(E,G);for(i=0;i<E.length;i++){O=E[i];if(O.getSelected()){O.setProperty("selected",false,true);O.$().removeClass("sapUiCalendarAppSel");j=O.$().attr("aria-labelledby");k=j?j.replace(S,""):"";O.$().attr("aria-labelledby",k);}}}A.setProperty("selected",true,true);A.$().addClass("sapUiCalendarAppSel");B=A.$().attr("aria-labelledby")+" "+S;A.$().attr("aria-labelledby",B);if(A._aAppointments){for(i=0;i<A._aAppointments.length;i++){O=A._aAppointments[i];O.setProperty("selected",true,true);B=O.$().attr("aria-labelledby")+" "+S;O.$().attr("aria-labelledby",B);}this.fireSelect({appointments:A._aAppointments,multiSelect:!R,domRefId:A.getId()});}else{this.fireSelect({appointment:A,multiSelect:!R,domRefId:A.getId()});}}function u(){var A=this.getAppointments();A.sort(function(i,j){var R=i.getStartDate()-j.getStartDate();if(R==0){R=j.getEndDate()-i.getEndDate();}return R;});return A;}function v(I){var G=this.getAggregation("groupAppointments",[]);var k;var F=false;for(var i=0;i<G.length;i++){var A=G[i]._aAppointments;for(var j=0;j<A.length;j++){if(A[j].getId()==I){k=G[i];F=true;break;}}if(F){break;}}return k;}function w(I){if(this._sFocusedAppointmentId!=I){var A=u.call(this);var V=this._aVisibleAppointments;var j;var i=0;j=v.call(this,I);if(j){I=j.getId();j=undefined;}for(i=0;i<V.length;i++){if(V[i].appointment.getId()==I){j=V[i].appointment;break;}}if(j){var O=this.getFocusedAppointment().$();var $=j.$();this._sFocusedAppointmentId=j.getId();O.attr("tabindex","-1");$.attr("tabindex","0");$.focus();}else{for(i=0;i<A.length;i++){if(A[i].getId()==I){j=A[i];break;}}if(j){this._sFocusedAppointmentId=j.getId();var k=g.call(this,j.getStartDate());this.setStartDate(b._createLocalDate(k,true));if(!q.sap.containsOrEquals(this.getDomRef(),document.activeElement)){q.sap.delayedCall(0,this,function(){this.getFocusedAppointment().focus();});}this.fireStartDateChange();}}}}function x(F,S){var I=this._sFocusedAppointmentId;var A=u.call(this);var G=this.getAggregation("groupAppointments",[]);var j;var k=0;var i=0;for(i=0;i<G.length;i++){if(G[i].getId()==I){var B=G[i]._aAppointments;if(F){I=B[B.length-1].getId();}else{I=B[0].getId();}break;}}for(i=0;i<A.length;i++){if(A[i].getId()==I){k=i;break;}}if(F){k=k+S;}else{k=k-S;}if(k<0){k=0;}else if(k>=A.length){k=A.length-1;}j=A[k];w.call(this,j.getId());}function y(E){var A=u.call(this);var j;var S=new U(this._getStartDate());var k=new U(this._oUTCEndDate);var I=this.getIntervalType();var B;var G;S.setUTCHours(0);k.setUTCHours(0);k.setUTCMinutes(0);k.setUTCSeconds(0);switch(I){case d.Hour:k.setUTCDate(k.getUTCDate()+1);k.setUTCMilliseconds(-1);break;case d.Day:case d.Week:case d.OneMonth:S.setUTCDate(1);k.setUTCMonth(k.getUTCMonth()+1);k.setUTCDate(1);k.setUTCMilliseconds(-1);break;case d.Month:S.setUTCMonth(0);S.setUTCDate(1);k.setUTCFullYear(k.getUTCFullYear()+1);k.setUTCMonth(1);k.setUTCDate(1);k.setUTCMilliseconds(-1);break;default:throw new Error("Unknown IntervalType: "+I+"; "+this);}var F=b._createLocalDate(S,true);var H=b._createLocalDate(k,true);for(var i=0;i<A.length;i++){if(A[i].getStartDate()>=F&&A[i].getStartDate()<=H){j=A[i];B=j.getId();if(E.type=="saphome"){break;}}else if(A[i].getStartDate()>H){break;}}G=v.call(this,B);if(G){j=G;B=j.getId();}if(B&&B!=this._sFocusedAppointmentId){w.call(this,B);}else if(E._bPlanningCalendar&&j){j.focus();}else{this.fireLeaveRow({type:E.type});}}function z(i,j){var I=this.getIntervalType();var S=this._getStartDate();var k=new U(S.getTime());var A;var B=false;var E=0;var F=0;if(q(j).hasClass("sapUiCalendarRowAppsSubInt")){B=true;var G=q(q(j).parent()).children(".sapUiCalendarRowAppsSubInt");F=G.length;for(E=0;E<F;E++){var H=G[E];if(H==j){break;}}}switch(I){case d.Hour:k.setUTCHours(k.getUTCHours()+i);if(B){k.setUTCMinutes(k.getUTCMinutes()+E*60/F);A=new U(k.getTime());A.setUTCMinutes(A.getUTCMinutes()+60/F);}else{A=new U(k.getTime());A.setUTCHours(A.getUTCHours()+1);}break;case d.Day:case d.Week:case d.OneMonth:k.setUTCDate(k.getUTCDate()+i);if(B){k.setUTCHours(k.getUTCHours()+E*24/F);A=new U(k.getTime());A.setUTCHours(A.getUTCHours()+24/F);}else{A=new U(k.getTime());A.setUTCDate(A.getUTCDate()+1);}break;case d.Month:k.setUTCMonth(k.getUTCMonth()+i);if(B){k.setUTCDate(k.getUTCDate()+E);A=new U(k.getTime());A.setUTCDate(A.getUTCDate()+1);}else{A=new U(k.getTime());A.setUTCMonth(A.getUTCMonth()+1);}break;default:throw new Error("Unknown IntervalType: "+I+"; "+this);}A.setUTCMilliseconds(A.getUTCMilliseconds()-1);k=b._createLocalDate(k,true);A=b._createLocalDate(A,true);this.fireIntervalSelect({startDate:k,endDate:A,subInterval:B});}return c;},true);
