/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/model/type/Date','sap/ui/unified/calendar/CalendarUtils','./calendar/Header','./calendar/TimesRow','./calendar/DatesRow','./calendar/MonthPicker','./calendar/YearPicker','sap/ui/core/date/UniversalDate','./library'],function(q,C,L,D,a,H,T,b,M,Y,U,l){"use strict";var c=C.extend("sap.ui.unified.CalendarTimeInterval",{metadata:{library:"sap.ui.unified",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},startDate:{type:"object",group:"Data"},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},items:{type:"int",group:"Appearance",defaultValue:12},intervalMinutes:{type:"int",group:"Appearance",defaultValue:60},pickerPopup:{type:"boolean",group:"Appearance",defaultValue:false},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},header:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},timesRow:{type:"sap.ui.unified.calendar.TimesRow",multiple:false,visibility:"hidden"},datesRow:{type:"sap.ui.unified.calendar.Month",multiple:false,visibility:"hidden"},monthPicker:{type:"sap.ui.unified.calendar.MonthPicker",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"},calendarPicker:{type:"sap.ui.unified.Calendar",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},cancel:{},startDateChange:{}}}});c.prototype.init=function(){this._iMode=0;this._oYearFormat=sap.ui.core.format.DateFormat.getDateInstance({format:"y"});this.data("sap-ui-fastnavgroup","true",true);this._oMinDate=new U(new Date(Date.UTC(1,0,1)));this._oMinDate.getJSDate().setUTCFullYear(1);this._oMaxDate=new U(new Date(Date.UTC(9999,11,31,23,59,59)));this._initializeHeader();this._initializeTimesRow();this._initilizeMonthPicker();this._initilizeYearPicker();this.setPickerPopup(false);this._iItemsHead=15;};c.prototype._initializeHeader=function(){var S=new H(this.getId()+"--Head");S.attachEvent("pressPrevious",this._handlePrevious,this);S.attachEvent("pressNext",this._handleNext,this);this.setAggregation("header",S);};c.prototype._initializeTimesRow=function(){var S=new T(this.getId()+"--TimesRow");S.attachEvent("focus",z,this);S.attachEvent("select",y,this);S._bNoThemeChange=true;this.setAggregation("timesRow",S);};c.prototype._initilizeMonthPicker=function(){this.setAggregation("monthPicker",this._createMonthPicker());};c.prototype._initilizeYearPicker=function(){this.setAggregation("yearPicker",this._createYearPicker());};c.prototype._createDatesRow=function(){var S=new b(this.getId()+"--DatesRow",{days:18,selectedDates:[new sap.ui.unified.DateRange(this.getId()+"--Range")]});S.attachEvent("focus",E,this);S.attachEvent("select",B,this);S._bNoThemeChange=true;S.getIntervalSelection=function(){return this.getProperty("intervalSelection");};S.getSingleSelection=function(){return this.getProperty("singleSelection");};S.getSelectedDates=function(){return this.getAggregation("selectedDates",[]);};S.getSpecialDates=function(){return this.getAggregation("specialDates",[]);};S.getAriaLabelledBy=function(){return this.getAssociation("ariaLabelledBy",[]);};return S;};c.prototype._createMonthPicker=function(){var S=new M(this.getId()+"--MP",{columns:0,months:6});S.attachEvent("select",F,this);S._bNoThemeChange=true;S.attachEvent("pageChange",Q,this);return S;};c.prototype._createYearPicker=function(){var S=new Y(this.getId()+"--YP",{columns:0,years:6});S.attachEvent("select",G,this);S.attachEvent("pageChange",R,this);S._oMinDate.setYear(this._oMinDate.getUTCFullYear());S._oMaxDate.setYear(this._oMaxDate.getUTCFullYear());return S;};c.prototype.exit=function(){if(this._sInvalidateContent){q.sap.clearDelayedCall(this._sInvalidateContent);}};c.prototype.onBeforeRendering=function(){var S=this.getAggregation("timesRow");var V=this._getFocusedDate();o.call(this);S.displayDate(a._createLocalDate(V,true));};c.prototype._getCalendarPicker=function(){var S=this.getAggregation("calendarPicker");if(!S){S=new sap.ui.unified.Calendar(this.getId()+"--Cal",{});S.setPopupMode(true);S.attachEvent("select",A,this);S.attachEvent("cancel",function(V){this._oPopup.close();},this);this.setAggregation("calendarPicker",S);}return S;};c.prototype.setStartDate=function(S){a._checkJSDateObject(S);if(q.sap.equal(this.getStartDate(),S)){return this;}var V=S.getFullYear();a._checkYearInValidRange(V);var W=this.getMinDate();if(W&&S.getTime()<W.getTime()){q.sap.log.warning("startDate < minDate -> minDate as startDate set",this);S=new Date(W);}var X=this.getMaxDate();if(X&&S.getTime()>X.getTime()){q.sap.log.warning("startDate > maxDate -> maxDate as startDate set",this);S=new Date(X);}this.setProperty("startDate",S,true);var Z=this.getAggregation("timesRow");Z.setStartDate(S);this._oUTCStartDate=new U(Z._getStartDate().getTime());o.call(this);var $=a._createLocalDate(this._getFocusedDate(),true);if(!Z.checkDateFocusable($)){this._setFocusedDate(this._oUTCStartDate);Z.displayDate(S);}return this;};c.prototype.invalidate=function(S){if(!this._bDateRangeChanged&&(!S||!(S instanceof sap.ui.unified.DateRange))){if(!S||(!(S instanceof sap.ui.unified.calendar.DatesRow||S instanceof sap.ui.unified.calendar.MonthPicker||S instanceof sap.ui.unified.calendar.YearPicker||S instanceof sap.ui.unified.calendar.Header))){C.prototype.invalidate.apply(this,arguments);}}else if(this.getDomRef()&&this._iMode==0&&!this._sInvalidateContent){this._sInvalidateContent=q.sap.delayedCall(0,this,I);}};c.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var S=this.removeAllAggregation("selectedDates");return S;};c.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var S=this.destroyAggregation("selectedDates");return S;};c.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var S=this.removeAllAggregation("specialDates");return S;};c.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var S=this.destroyAggregation("specialDates");return S;};c.prototype.setIntervalMinutes=function(S){if(S>=720){throw new Error("Only intervals < 720 minutes are allowed; "+this);}if(1440%S>0){throw new Error("A day must be divisible by the interval size; "+this);}this.setProperty("intervalMinutes",S,false);var V=this.getAggregation("timesRow");var W=a._createLocalDate(this._getFocusedDate(),true);if(!V.checkDateFocusable(W)){var X=d.call(this);this._setFocusedDate(X);V.setDate(a._createLocalDate(X,true));}return this;};c.prototype.setLocale=function(S){if(this._sLocale!=S){this._sLocale=S;this._oLocaleData=undefined;this.invalidate();}return this;};c.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};c.prototype._getFocusedDate=function(){if(!this._oFocusedDate){f.call(this);}return this._oFocusedDate;};c.prototype._setFocusedDate=function(S){if(!(S instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}this._oFocusedDate=new U(S.getTime());};c.prototype.focusDate=function(S){var V=false;var W=this.getAggregation("timesRow");if(!W.checkDateFocusable(S)){var X=a._createUniversalUTCDate(S,undefined,true);J.call(this,X);V=true;}u.call(this,S,false);if(V){this.fireStartDateChange();}return this;};c.prototype.displayDate=function(S){u.call(this,S,true);return this;};c.prototype.setItems=function(S){this.setProperty("items",S,true);S=this._getItems();var V=this.getAggregation("timesRow");V.setItems(S);var W=a._createLocalDate(this._getFocusedDate(),true);if(!V.checkDateFocusable(W)){var X=d.call(this);this._setFocusedDate(X);V.setDate(a._createLocalDate(X,true));}if(!this.getPickerPopup()){var Z=this.getAggregation("datesRow");var $=Math.floor(S*1.5);if($>31){$=31;}Z.setDays($);var a1=this.getAggregation("monthPicker");var b1=Math.floor(S/2);if(b1>12){b1=12;}a1.setMonths(b1);var c1=this.getAggregation("yearPicker");var d1=Math.floor(S/2);if(d1>20){d1=20;}c1.setYears(d1);}o.call(this);if(this.getDomRef()){if(this._getShowItemHeader()){this.$().addClass("sapUiCalIntHead");}else{this.$().removeClass("sapUiCalIntHead");}}return this;};c.prototype._getItems=function(){var S=this.getItems();if(sap.ui.Device.system.phone&&S>6){return 6;}else{return S;}};c.prototype._getLocaleData=function(){if(!this._oLocaleData){var S=this.getLocale();var V=new sap.ui.core.Locale(S);this._oLocaleData=L.getInstance(V);}return this._oLocaleData;};c.prototype.setPickerPopup=function(S){var V=this.getAggregation("header"),W,X,Z;this.setProperty("pickerPopup",S,true);if(W){W.destroy();}if(S){V.setVisibleButton0(false);V.setVisibleButton1(true);V.setVisibleButton2(false);V.detachEvent("pressButton1",w,this);V.attachEvent("pressButton1",w,this);if(this.getAggregation("datesRow")){this.getAggregation("datesRow").destroy();}if(this.getAggregation("monthPicker")){this.getAggregation("monthPicker").destroy();}if(this.getAggregation("yearPicker")){this.getAggregation("yearPicker").destroy();}}else{V.setVisibleButton0(true);V.setVisibleButton1(true);V.setVisibleButton2(true);V.detachEvent("pressButton0",v,this);V.attachEvent("pressButton0",v,this);V.detachEvent("pressButton1",w,this);V.attachEvent("pressButton1",w,this);V.detachEvent("pressButton2",x,this);V.attachEvent("pressButton2",x,this);if(!this.getAggregation("datesRow")){this.setAggregation("datesRow",this._createDatesRow());}if(!this.getAggregation("yearPicker")){this.setAggregation("yearPicker",this._createYearPicker());}if(!this.getAggregation("monthPicker")){this.setAggregation("monthPicker",this._createMonthPicker());}X=this.getAggregation("monthPicker");Z=this.getAggregation("yearPicker");X.setColumns(0);X.setMonths(6);Z.setColumns(0);Z.setYears(6);}return this;};c.prototype.setMinDate=function(S){var V,W,X,Z;if(q.sap.equal(S,this.getMinDate())){return this;}if(!S){a._updateUTCDate(this._oMinDate.getJSDate(),1,0,1,0,0,0,0);}else{a._checkJSDateObject(S);this._oMinDate=a._createUniversalUTCDate(S,undefined,true);V=this.getAggregation("timesRow");this._oMinDate=V._getIntervalStart(this._oMinDate);W=this._oMinDate.getUTCFullYear();a._checkYearInValidRange(W);if(this._oMaxDate.getTime()<this._oMinDate.getTime()){q.sap.log.warning("minDate > maxDate -> maxDate set to end of the month",this);this._oMaxDate=a._createUniversalUTCDate(S,undefined,true);a._updateUTCDate(this._oMaxDate,null,this._oMaxDate.getUTCMonth()+1,0,23,59,59,0);this.setProperty("maxDate",a._createLocalDate(this._oMaxDate,true),true);}if(this._oFocusedDate){if(this._oFocusedDate.getTime()<this._oMinDate.getTime()){q.sap.log.warning("focused date < minDate -> minDate focused",this);this.focusDate(S);}}if(this._oUTCStartDate&&this._oUTCStartDate.getTime()<this._oMinDate.getTime()){q.sap.log.warning("start date < minDate -> minDate set as start date",this);_.call(this,new U(this._oMinDate.getTime()),true,true);}}this.setProperty("minDate",S,false);if(this.getPickerPopup()){Z=this._getCalendarPicker();Z.setMinDate(S);}else{X=this.getAggregation("yearPicker");X._oMinDate.setYear(this._oMinDate.getUTCFullYear());}return this;};c.prototype.setMaxDate=function(S){var V,W,X,Z,$,a1;if(q.sap.equal(S,this.getMaxDate())){return this;}if(!S){a._updateUTCDate(this._oMaxDate.getJSDate(),9999,11,31,23,59,59,0);}else{a._checkJSDateObject(S);this._oMaxDate=a._createUniversalUTCDate(S,undefined,true);V=this.getAggregation("timesRow");this._oMaxDate=V._getIntervalStart(this._oMaxDate);this._oMaxDate.setUTCMinutes(this._oMaxDate.getUTCMinutes()+this.getIntervalMinutes());this._oMaxDate.setUTCMilliseconds(-1);W=this._oMaxDate.getUTCFullYear();a._checkYearInValidRange(W);if(this._oMinDate.getTime()>this._oMaxDate.getTime()){q.sap.log.warning("maxDate < minDate -> minDate set to begin of the month",this);this._oMinDate=a._createUniversalUTCDate(S,undefined,true);a._updateUTCDate(this._oMinDate,null,null,1,0,0,0,0);this.setProperty("minDate",a._createLocalDate(this._oMinDate,true),true);}if(this._oFocusedDate){if(this._oFocusedDate.getTime()>this._oMaxDate.getTime()){q.sap.log.warning("focused date > maxDate -> maxDate focused",this);this.focusDate(S);}}if(this._oUTCStartDate){X=new U(this._oUTCStartDate.getTime());X.setUTCMinutes(X.getUTCMinutes()+this.getIntervalMinutes()*(this._getItems()-1));if(X.getTime()>this._oMaxDate.getTime()){Z=new U(this._oMaxDate.getTime());Z.setUTCMinutes(Z.getUTCMinutes()-this.getIntervalMinutes()*(this._getItems()-1));if(Z.getTime()>=this._oMinDate.getTime()){q.sap.log.warning("end date > maxDate -> maxDate set as end date",this);_.call(this,Z,true,true);}}}}this.setProperty("maxDate",S,false);if(this.getPickerPopup()){a1=this._getCalendarPicker();a1.setMaxDate(S);}else{$=this.getAggregation("yearPicker");$._oMaxDate.setYear(this._oMaxDate.getUTCFullYear());}return this;};c.prototype.onclick=function(S){if(S.isMarked("delayedMouseEvent")){return;}if(S.target.id==this.getId()+"-cancel"){this.onsapescape(S);}};c.prototype.onmousedown=function(S){S.preventDefault();S.setMark("cancelAutoClose");};c.prototype.onsapescape=function(S){if(this.getPickerPopup()){g.call(this);this.fireCancel();}else{switch(this._iMode){case 0:this.fireCancel();break;case 1:i.call(this);break;case 2:k.call(this);break;case 3:n.call(this);break;}}};c.prototype.onsaptabnext=function(S){var V=this.getAggregation("header"),W,X,Z;if(q.sap.containsOrEquals(this.getDomRef("content"),S.target)){if(this.getPickerPopup()){q.sap.focus(V.getDomRef("B1"));}else{q.sap.focus(V.getDomRef("B0"));}if(!this._bPoupupMode){Z=this.getAggregation("timesRow");q(Z._oItemNavigation.getItemDomRefs()[Z._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");if(!this.getPickerPopup()){W=this.getAggregation("monthPicker");X=this.getAggregation("yearPicker");if(W.getDomRef()){q(W._oItemNavigation.getItemDomRefs()[W._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(X.getDomRef()){q(X._oItemNavigation.getItemDomRefs()[X._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}S.preventDefault();}else if(S.target.id==V.getId()+"-B0"){q.sap.focus(V.getDomRef("B1"));S.preventDefault();}else if(!this.getPickerPopup()&&(S.target.id==V.getId()+"-B1")){q.sap.focus(V.getDomRef("B2"));S.preventDefault();}};c.prototype.onsaptabprevious=function(S){var V=this.getAggregation("header"),W,X,Z;if(q.sap.containsOrEquals(this.getDomRef("content"),S.target)){if(this._bPoupupMode){q.sap.focus(V.getDomRef("B2"));S.preventDefault();}}else if(S.target.id==V.getId()+"-B0"){Z=this.getAggregation("timesRow");switch(this._iMode){case 0:Z._oItemNavigation.focusItem(Z._oItemNavigation.getFocusedIndex());break;case 2:if(!this.getPickerPopup()){W=this.getAggregation("monthPicker");W._oItemNavigation.focusItem(W._oItemNavigation.getFocusedIndex());}break;case 3:if(!this.getPickerPopup()){X=this.getAggregation("yearPicker");X._oItemNavigation.focusItem(X._oItemNavigation.getFocusedIndex());}break;}S.preventDefault();}else if(S.target.id==V.getId()+"-B2"){q.sap.focus(V.getDomRef("B1"));S.preventDefault();}else if(S.target.id==V.getId()+"-B1"){if(!this.getPickerPopup()){q.sap.focus(V.getDomRef("B0"));}else{Z=this.getAggregation("timesRow");Z._oItemNavigation.focusItem(Z._oItemNavigation.getFocusedIndex());}S.preventDefault();}};c.prototype.onfocusin=function(S){if(S.target.id==this.getId()+"-end"){var V=this.getAggregation("header"),W,X,Z;if(this.getPickerPopup()){q.sap.focus(V.getDomRef("B1"));}else{q.sap.focus(V.getDomRef("B2"));}if(!this._bPoupupMode){W=this.getAggregation("timesRow");q(W._oItemNavigation.getItemDomRefs()[W._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");if(!this.getPickerPopup()){X=this.getAggregation("monthPicker");Z=this.getAggregation("yearPicker");if(X.getDomRef()){q(X._oItemNavigation.getItemDomRefs()[X._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(Z.getDomRef()){q(Z._oItemNavigation.getItemDomRefs()[Z._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}}this.$("end").attr("tabindex","-1");};c.prototype.onsapfocusleave=function(S){if(!S.relatedControlId||!q.sap.containsOrEquals(this.getDomRef(),sap.ui.getCore().byId(S.relatedControlId).getFocusDomRef())){this.$("end").attr("tabindex","0");if(!this._bPoupupMode){var V,W,X;switch(this._iMode){case 0:V=this.getAggregation("timesRow");q(V._oItemNavigation.getItemDomRefs()[V._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");break;case 2:if(!this.getPickerPopup()){W=this.getAggregation("monthPicker");q(W._oItemNavigation.getItemDomRefs()[W._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;case 3:if(!this.getPickerPopup()){X=this.getAggregation("yearPicker");q(X._oItemNavigation.getItemDomRefs()[X._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;}}}};c.prototype._handlePrevious=function(S){var V=this._getFocusedDate(),W,X,Z,$,a1,b1,c1,d1;switch(this._iMode){case 0:W=this._getItems();X=new U(d.call(this).getTime());Z=this.getIntervalMinutes();X.setUTCMinutes(X.getUTCMinutes()-W*Z);V.setUTCMinutes(V.getUTCMinutes()-W*Z);this._setFocusedDate(V);_.call(this,X,true);break;case 1:if(!this.getPickerPopup()){$=this.getAggregation("datesRow");a1=a._createUniversalUTCDate($.getDate());b1=$.getDays();if(a1.getUTCDate()<=b1){a1.setUTCDate(1);}else{a1.setUTCDate(a1.getUTCDate()-b1);}K.call(this,a1);}break;case 2:if(!this.getPickerPopup()){c1=this.getAggregation("monthPicker");if(c1.getMonths()<12){c1.previousPage();p.call(this);}else{V.setUTCFullYear(V.getUTCFullYear()-1);J.call(this,V);this._setFocusedDate(V);o.call(this);P.call(this,V.getUTCFullYear(),c1);this.fireStartDateChange();}}break;case 3:if(!this.getPickerPopup()){d1=this.getAggregation("yearPicker");d1.previousPage();r.call(this);}break;}};c.prototype._handleNext=function(S){var V=this._getFocusedDate();switch(this._iMode){case 0:var W=this._getItems();var X=new U(d.call(this).getTime());var Z=this.getIntervalMinutes();X.setUTCMinutes(X.getUTCMinutes()+W*Z);V.setUTCMinutes(V.getUTCMinutes()+W*Z);this._setFocusedDate(V);_.call(this,X,true);break;case 1:if(!this.getPickerPopup()){var $=this.getAggregation("datesRow");var a1=a._createUniversalUTCDate($.getDate());var b1=new U(a1.getTime());b1.setUTCDate(1);b1.setUTCMonth(b1.getUTCMonth()+1);b1.setUTCDate(0);var c1=$.getDays();if(a1.getUTCDate()+c1>b1.getUTCDate()){a1.setUTCDate(b1.getUTCDate());}else{a1.setUTCDate(a1.getUTCDate()+c1);}K.call(this,a1);}break;case 2:if(!this.getPickerPopup()){var d1=this.getAggregation("monthPicker");if(d1.getMonths()<12){d1.nextPage();p.call(this);}else{V.setUTCFullYear(V.getUTCFullYear()+1);J.call(this,V);this._setFocusedDate(V);o.call(this);P.call(this,V.getUTCFullYear(),d1);this.fireStartDateChange();}}break;case 3:if(!this.getPickerPopup()){var e1=this.getAggregation("yearPicker");e1.nextPage();r.call(this);}break;}};c.prototype._getShowItemHeader=function(){var S=this.getItems();if(S>this._iItemsHead){return true;}else{return false;}};function _(S,V,W){var X=new U(this._oMaxDate.getTime());X.setUTCMinutes(X.getUTCMinutes()-this.getIntervalMinutes()*(this._getItems()-1));if(X.getTime()<this._oMinDate.getTime()){X=new U(this._oMinDate.getTime());X.setUTCMinutes(X.getUTCMinutes()+this.getIntervalMinutes()*(this._getItems()-1));}if(S.getTime()<this._oMinDate.getTime()){S=new U(this._oMinDate.getTime());}else if(S.getTime()>X.getTime()){S=X;}var Z=this.getAggregation("timesRow");var $=a._createLocalDate(S,true);Z.setStartDate($);this._oUTCStartDate=new U(Z._getStartDate().getTime());$=a._createLocalDate(this._oUTCStartDate,true);this.setProperty("startDate",$,true);o.call(this);if(V){var a1=a._createLocalDate(this._getFocusedDate(),true);if(!Z.checkDateFocusable(a1)){this._setFocusedDate(S);Z.setDate($);}else{Z.setDate(a1);}}if(!W){this.fireStartDateChange();}}function d(){if(!this._oUTCStartDate){var S=this.getAggregation("timesRow");S.setStartDate(a._createLocalDate(this._getFocusedDate(),true));this._oUTCStartDate=new U(S._getStartDate().getTime());this._setFocusedDate(this._oUTCStartDate);}return this._oUTCStartDate;}function e(S){var V=this._getFocusedDate();var W=this.getAggregation("timesRow");if(!S){W.setDate(a._createLocalDate(V,true));}else{W.displayDate(a._createLocalDate(V,true));}o.call(this);}function f(){var S=this.getSelectedDates();if(S&&S[0]&&S[0].getStartDate()){this._oFocusedDate=a._createUniversalUTCDate(S[0].getStartDate(),undefined,true);}else{var V=new Date();this._oFocusedDate=a._createUniversalUTCDate(V,undefined,true);}if(this._oFocusedDate.getTime()<this._oMinDate.getTime()){this._oFocusedDate=new U(this._oMinDate.getTime());}else if(this._oFocusedDate.getTime()>this._oMaxDate.getTime()){this._oFocusedDate=new U(this._oMaxDate.getTime());}}c.prototype._showCalendarPicker=function(){var S=a._createLocalDate(this._getFocusedDate(),true);var V=this._getCalendarPicker();var W=new sap.ui.unified.DateRange({startDate:S});V.displayDate(S,false);V.removeAllSelectedDates();V.addSelectedDate(W);V.setMinDate(this.getMinDate());V.setMaxDate(this.getMaxDate());N.call(this,V);this._showOverlay();};c.prototype._showOverlay=function(){this.$("contentOver").css("display","");};c.prototype._hideOverlay=function(){this.$("contentOver").css("display","none");};function g(S){if(this._oPopup&&this._oPopup.isOpen()){this._oPopup.close();}this._hideOverlay();if(!S){e.call(this);var V=this.getAggregation("timesRow");q(V._oItemNavigation.getItemDomRefs()[V._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}function h(){if(this._iMode==3){n.call(this,true);}else if(this._iMode==2){k.call(this,true);}var S=this._getFocusedDate();var V=this._getItems();var W=this.getAggregation("datesRow");var X=W.getSelectedDates()[0];X.setStartDate(a._createLocalDate(S,true));var Z=new U(S.getTime());Z.setUTCDate(1);Z.setUTCMonth(Z.getUTCMonth()+1);Z.setUTCDate(0);var $=Z.getUTCDate();var a1=Math.floor(V*1.5);if(a1>$){a1=$;}W.setDays(a1);if(W.getDomRef()){W.$().css("display","");}else{var b1=sap.ui.getCore().createRenderManager();var c1=this.$("content");b1.renderControl(W);b1.flush(c1[0],false,true);b1.destroy();}this._showOverlay();K.call(this,S);if(this._iMode==0){var d1=this.getAggregation("timesRow");q(d1._oItemNavigation.getItemDomRefs()[d1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}this._iMode=1;}function i(S){this._iMode=0;var V=this.getAggregation("datesRow");V.$().css("display","none");this._hideOverlay();if(!S){e.call(this);var W=this.getAggregation("timesRow");q(W._oItemNavigation.getItemDomRefs()[W._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}function j(){if(this._iMode==1){i.call(this,true);}else if(this._iMode==3){n.call(this,true);}var S=this._getFocusedDate();var V=this.getAggregation("monthPicker");if(V.getDomRef()){V.$().css("display","");}else{var W=sap.ui.getCore().createRenderManager();var $=this.$("content");W.renderControl(V);W.flush($[0],false,true);W.destroy();}this._showOverlay();V.setMonth(S.getUTCMonth());P.call(this,S.getUTCFullYear(),V);if(this._iMode==0){var X=this.getAggregation("timesRow");q(X._oItemNavigation.getItemDomRefs()[X._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}this._iMode=2;p.call(this);}function k(S){this._iMode=0;var V=this.getAggregation("monthPicker");V.$().css("display","none");this._hideOverlay();if(!S){e.call(this);var W=this.getAggregation("timesRow");q(W._oItemNavigation.getItemDomRefs()[W._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}function m(){if(this._iMode==1){i.call(this,true);}else if(this._iMode==2){k.call(this,true);}var S=this._getFocusedDate();var V=this.getAggregation("yearPicker");if(V.getDomRef()){V.$().css("display","");}else{var W=sap.ui.getCore().createRenderManager();var $=this.$("content");W.renderControl(V);W.flush($[0],false,true);W.destroy();}this._showOverlay();V.setDate(S.getJSDate());if(this._iMode==0){var X=this.getAggregation("timesRow");q(X._oItemNavigation.getItemDomRefs()[X._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}r.call(this);this._iMode=3;}function n(S){this._iMode=0;var V=this.getAggregation("yearPicker");V.$().css("display","none");this._hideOverlay();if(!S){e.call(this);var W=this.getAggregation("timesRow");q(W._oItemNavigation.getItemDomRefs()[W._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}function o(){s.call(this);p.call(this,true);}function p(S){var V=new U(d.call(this).getTime());var W=this._getItems();var X=V.getJSDate().getUTCFullYear();var Z=this._oMaxDate.getJSDate().getUTCFullYear();var $=this._oMinDate.getJSDate().getUTCFullYear();var a1=V.getJSDate().getUTCMonth();var b1=this._oMaxDate.getJSDate().getUTCMonth();var c1=this._oMinDate.getJSDate().getUTCMonth();var d1=V.getJSDate().getUTCDate();var e1=this._oMaxDate.getJSDate().getUTCDate();var f1=this._oMinDate.getJSDate().getUTCDate();var g1=V.getJSDate().getUTCHours();var h1=this._oMaxDate.getJSDate().getUTCHours();var i1=this._oMinDate.getJSDate().getUTCHours();var j1=V.getJSDate().getUTCMinutes();var k1=this._oMaxDate.getJSDate().getUTCMinutes();var l1=this._oMinDate.getJSDate().getUTCMinutes();var m1=this.getAggregation("header");if(this._iMode==2&&!S){var n1=this.getAggregation("monthPicker");var o1=n1.getMonths();var p1=n1.getStartMonth();var q1=p1+o1-1;if(p1==0||(X==$&&p1<=c1)){m1.setEnabledPrevious(false);}else{m1.setEnabledPrevious(true);}if(q1>10||(X==Z&&q1>=b1)){m1.setEnabledNext(false);}else{m1.setEnabledNext(true);}return;}if((X<$||(X==$&&(!S||(a1<c1||(a1==c1&&(d1<f1||(d1==f1&&(g1<i1||(g1==i1&&j1<=l1)))))))))||((this._iMode==1||this._iMode==2)&&this.getPickerPopup())){m1.setEnabledPrevious(false);}else{m1.setEnabledPrevious(true);}V.setUTCMinutes(V.getUTCMinutes()+(W)*this.getIntervalMinutes()-1);X=V.getJSDate().getUTCFullYear();a1=V.getJSDate().getUTCMonth();d1=V.getJSDate().getUTCDate();g1=V.getJSDate().getUTCHours();j1=V.getJSDate().getUTCMinutes();if((X>Z||(X==Z&&(!S||(a1>b1||(a1==b1&&(d1>e1||(d1==e1&&(g1>h1||(g1==h1&&j1>=k1)))))))))||((this._iMode==1||this._iMode==2)&&this.getPickerPopup())){m1.setEnabledNext(false);}else{m1.setEnabledNext(true);}}function r(){var S=this.getAggregation("yearPicker");var V=S.getYears();var W=a._createUniversalUTCDate(S.getFirstRenderedDate());W.setUTCFullYear(W.getUTCFullYear()+Math.floor(V/2));var X=this.getAggregation("header");var Z=new U(this._oMaxDate);Z.setUTCFullYear(Z.getUTCFullYear()-Math.ceil(V/2));Z.setUTCMonth(11,31);var $=new U(this._oMinDate);$.setUTCFullYear($.getUTCFullYear()+Math.floor(V/2)+1);$.setUTCMonth(0,1);if(W.getTime()>Z.getTime()){X.setEnabledNext(false);}else{X.setEnabledNext(true);}if(W.getTime()<$.getTime()){X.setEnabledPrevious(false);}else{X.setEnabledPrevious(true);}}function s(){var S=this.getAggregation("header");var V;var W=d.call(this);var X;var Z=this._getLocaleData();var $=[];var a1=[];var b1;var c1=false;var d1;var e1=sap.ui.core.CalendarType.Gregorian;var f1=false;if(Z.oLocale.sLanguage.toLowerCase()==="ja"||Z.oLocale.sLanguage.toLowerCase()==="zh"){d1=sap.ui.core.format.DateFormat.getDateInstance({format:"d"}).format(W,true);}else{d1=(W.getUTCDate()).toString();}if(this._bLongMonth||!this._bNamesLengthChecked){$=Z.getMonthsStandAlone("wide");}else{c1=true;$=Z.getMonthsStandAlone("abbreviated");a1=Z.getMonthsStandAlone("wide");}var g1=W.getUTCMonth();V=$[g1];if(c1){b1=a1[$[g1]];}if(!this.getPickerPopup()){S.setTextButton0(d1);S.setTextButton1(V);S.setTextButton2(this._oYearFormat.format(W,true));}else{X=sap.ui.core.format.DateFormat.getInstance({style:"long",strictParsing:true,relative:f1,calendarType:e1},Z.oLocale);b1=d1=X.format(a._createLocalDate(W,true));S.setTextButton1(d1);}if(c1){S.setAriaLabelButton1(b1);}}function t(S,V){var W;var X=false;if(S.getTime()<this._oMinDate.getTime()){W=this._oMinDate;X=true;}else if(S.getTime()>this._oMaxDate.getTime()){W=this._oMaxDate;X=true;}else{W=S;}this._setFocusedDate(W);if(X||V){J.call(this,W);e.call(this,false);this.fireStartDateChange();}}function u(S,V){if(S&&(!this._oFocusedDate||this._oFocusedDate.getTime()!=S.getTime())){a._checkJSDateObject(S);S=a._createUniversalUTCDate(S,undefined,true);var W=S.getUTCFullYear();a._checkYearInValidRange(W);if(S.getTime()<this._oMinDate.getTime()||S.getTime()>this._oMaxDate.getTime()){throw new Error("Date must not be in valid range (minDate and maxDate); "+this);}this._setFocusedDate(S);if(this.getDomRef()&&this._iMode==0){e.call(this,V);}}}function v(S){if(this._iMode!=1){h.call(this);}else{i.call(this);}}function w(S){if(this.getPickerPopup()){this._showCalendarPicker();}else{if(this._iMode!=2){j.call(this);}else{k.call(this);}}}function x(S){if(this._iMode!=3){m.call(this);}else{n.call(this);}}function y(S){this.fireSelect();}function z(S){var V=a._createUniversalUTCDate(S.getParameter("date"),undefined,true);var W=S.getParameter("notVisible");t.call(this,V,W);}function A(S){var V=S.getSource(),W=V.getSelectedDates()[0].getStartDate();var X=new U(this._getFocusedDate().getTime());var Z=a._createUniversalUTCDate(W);X.setUTCDate(Z.getUTCDate());X.setUTCMonth(Z.getUTCMonth());X.setUTCFullYear(Z.getUTCFullYear());t.call(this,X,true);g.call(this);}function B(S){var V=new U(this._getFocusedDate().getTime());var W=S.oSource;var X=W.getSelectedDates()[0];var Z=a._createUniversalUTCDate(X.getStartDate());if(!this.getPickerPopup()||Z.getUTCMonth()==V.getUTCMonth()){V.setUTCDate(Z.getUTCDate());V.setUTCMonth(Z.getUTCMonth());V.setUTCFullYear(Z.getUTCFullYear());t.call(this,V,true);i.call(this);}}function E(S){var V=new U(this._getFocusedDate().getTime());var W=a._createUniversalUTCDate(S.getParameter("date"),undefined,true);var X=S.getParameter("otherMonth");if(X&&W.getUTCMonth()==V.getUTCMonth()&&W.getUTCFullYear()==V.getUTCFullYear()){K.call(this,W);}}function F(S){var V=new U(this._getFocusedDate().getTime());var W=this.getAggregation("monthPicker");var X=W.getMonth();V.setUTCMonth(X);if(X!=V.getUTCMonth()){V.setUTCDate(0);}t.call(this,V,true);k.call(this);}function G(S){var V=new U(this._getFocusedDate().getTime());var W=this.getAggregation("yearPicker");var X=a._createUniversalUTCDate(W.getDate());var Z=V.getUTCMonth();X.setUTCMonth(V.getUTCMonth(),V.getUTCDate());X.setUTCHours(V.getUTCHours());X.setUTCMinutes(V.getUTCMinutes());V=X;if(Z!=V.getUTCMonth()){V.setUTCDate(0);}t.call(this,V,true);n.call(this);}function I(){this._sInvalidateContent=undefined;var S=this.getAggregation("timesRow");S._bDateRangeChanged=true;S._bInvalidateSync=true;S.invalidate();S._bInvalidateSync=undefined;this._bDateRangeChanged=undefined;}function J(S){var V=this.getAggregation("timesRow");var W=d.call(this);var X=V._oItemNavigation.getFocusedIndex();W=new U(S.getTime());W.setUTCMinutes(W.getUTCMinutes()-X*this.getIntervalMinutes());_.call(this,W,false,true);}function K(S){var V=this.getAggregation("datesRow");var W=this.getAggregation("header");if(!this.getPickerPopup()){var X=new U(S.getTime());X.setUTCDate(1);X.setUTCMonth(X.getUTCMonth()+1);X.setUTCDate(0);var Z=V.getDays();var $=new U(S.getTime());$.setUTCDate(1+(Math.ceil(S.getUTCDate()/Z)-1)*Z);if(X.getUTCDate()-$.getUTCDate()<Z){$.setUTCDate(X.getUTCDate()-Z+1);}V.setStartDate(a._createLocalDate($,true));var a1=$.getJSDate().getUTCFullYear();var b1=this._oMaxDate.getJSDate().getUTCFullYear();var c1=this._oMinDate.getJSDate().getUTCFullYear();var d1=$.getJSDate().getUTCMonth();var e1=this._oMaxDate.getJSDate().getUTCMonth();var f1=this._oMinDate.getJSDate().getUTCMonth();var g1=$.getJSDate().getUTCDate();var h1=this._oMaxDate.getJSDate().getUTCDate();var i1=this._oMinDate.getJSDate().getUTCDate();if(g1<=1||(a1==c1&&d1==f1&&g1<=i1)){W.setEnabledPrevious(false);}else{W.setEnabledPrevious(true);}if((g1+Z)>=X.getUTCDate()||(a1==b1&&d1==e1&&g1>=h1)){W.setEnabledNext(false);}else{W.setEnabledNext(true);}}else{W.setEnabledPrevious(false);W.setEnabledNext(false);}V.setDate(a._createLocalDate(S,true));}function N(S){if(!this._oPopup){q.sap.require("sap.ui.core.Popup");this._oPopup=new sap.ui.core.Popup();this._oPopup.setAutoClose(true);this._oPopup.setAutoCloseAreas([this.getDomRef()]);this._oPopup.setDurations(0,0);this._oPopup._oCalendar=this;this._oPopup.attachClosed(O,this);this._oPopup.onsapescape=function(X){this._oCalendar.onsapescape(X);};}this._oPopup.setContent(S);var V=this.getAggregation("header");var W=sap.ui.core.Popup.Dock;this._oPopup.open(0,W.CenterTop,W.CenterTop,V,null,"flipfit",true);}function O(S){g.call(this);}function P(S,V){var W=0;var X=11;if(S==this._oMinDate.getUTCFullYear()){W=this._oMinDate.getUTCMonth();}if(S==this._oMaxDate.getUTCFullYear()){X=this._oMaxDate.getUTCMonth();}V.setMinMax(W,X);}function Q(S){p.call(this);}function R(S){r.call(this);}return c;},true);
