/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','./library','sap/ui/model/type/Date','sap/ui/model/type/Time','sap/ui/model/type/DateTime','sap/ui/model/odata/type/ODataType'],function(q,C,l,D,T,a,O){"use strict";var b=C.extend("sap.m.DateTimeInput",{metadata:{library:"sap.m",properties:{value:{type:"string",group:"Data",defaultValue:null,bindable:"bindable"},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},enabled:{type:"boolean",group:"Behavior",defaultValue:true},editable:{type:"boolean",group:"Behavior",defaultValue:true},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:sap.ui.core.ValueState.None},valueStateText:{type:"string",group:"Misc",defaultValue:null},showValueStateMessage:{type:"boolean",group:"Misc",defaultValue:true},name:{type:"string",group:"Misc",defaultValue:null},placeholder:{type:"string",group:"Misc",defaultValue:null},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:sap.ui.core.TextAlign.Initial},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit},type:{type:"sap.m.DateTimeInputType",group:"Data",defaultValue:sap.m.DateTimeInputType.Date},displayFormat:{type:"string",group:"Appearance",defaultValue:null},valueFormat:{type:"string",group:"Data",defaultValue:null},dateValue:{type:"object",group:"Data",defaultValue:null}},aggregations:{_picker:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{change:{parameters:{value:{type:"string"},dateValue:{type:"object"},valid:{type:"boolean"}}}}}});!(function(p,$,o){var f=sap.m.getLocaleData();$.extend(p,{_types:{Date:{valueFormat:f.getDatePattern("short"),displayFormat:f.getDatePattern("medium")},Time:{valueFormat:f.getTimePattern("short"),displayFormat:f.getTimePattern("short")},DateTime:{valueFormat:f.getDateTimePattern("short"),displayFormat:f.getDateTimePattern("short")}}});["Time","Date"].forEach(function(t,n){["valueFormat","displayFormat"].forEach(function(F){var g=p._types;g.DateTime[F]=g.DateTime[F].replace("{"+n+"}",g[t][F]);});});}(b.prototype,q,sap.ui.Device));b.prototype.init=function(){this.setType(sap.m.DateTimeInputType.Date);};b.prototype.onBeforeRendering=function(){d.call(this);};b.prototype.getFocusDomRef=function(){var p=_.call(this);return p.getFocusDomRef();};b.prototype.getIdForLabel=function(){var p=_.call(this);return p.getIdForLabel();};function c(t){var p;switch(t){case sap.m.DateTimeInputType.DateTime:q.sap.require("sap.m.DateTimePicker");p=new sap.m.DateTimePicker(this.getId()+"-Picker");break;case sap.m.DateTimeInputType.Time:q.sap.require("sap.m.TimePicker");p=new sap.m.TimePicker(this.getId()+"-Picker",{localeId:sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString()});break;default:q.sap.require("sap.m.DatePicker");p=new sap.m.DatePicker(this.getId()+"-Picker");break;}p.setDisplayFormat(this.getDisplayFormat()||this._types[t].displayFormat);p.setValueFormat(this.getValueFormat()||this._types[t].valueFormat);if(this.getDateValue()){p.setDateValue(this.getDateValue());}p.setEnabled(this.getEnabled());p.setEditable(this.getEditable());p.setValueState(this.getValueState());p.setValueStateText(this.getValueStateText());p.setShowValueStateMessage(this.getShowValueStateMessage());p.setName(this.getName());p.setPlaceholder(this.getPlaceholder());p.setTextAlign(this.getTextAlign());p.setTextDirection(this.getTextDirection());p.setWidth("100%");p.attachChange(e,this);var A=this.getAriaLabelledBy();for(var i=0;i<A.length;i++){p.addAriaLabelledBy(A[i]);}return p;}b.prototype.setType=function(t){if(t==this.getType()&&_.call(this)){return this;}this.destroyAggregation("_picker");var p=c.call(this,t);this.setAggregation("_picker",p);this.setProperty("type",t);return this;};b.prototype.setWidth=function(w){this.setProperty("width",w);if(this.getDomRef()){w=this.getWidth();this.$().css("width",w);}return this;};b.prototype.setValue=function(v){d.call(this);v=this.validateProperty("value",v);if(v.toLowerCase()=="now"){return this.setDateValue(new Date());}if(v===this.getValue()){return this;}this.setProperty("value",v,true);var p=_.call(this);p.setValue(v);var o=p.getDateValue();this.setProperty("dateValue",o,true);return this;};b.prototype.setDateValue=function(o){if(o&&!(o instanceof Date)){throw new Error("Date must be a JavaScript date object; "+this);}d.call(this);this.setProperty("dateValue",o,true);var p=_.call(this);p.setDateValue(o);var v=p.getValue();this.setProperty("value",v,true);return this;};b.prototype.setDisplayFormat=function(s){this.setProperty("displayFormat",s,true);var p=_.call(this);p.setDisplayFormat(s||this._types[this.getType()].displayFormat);return this;};b.prototype.setValueFormat=function(v){this.setProperty("valueFormat",v,true);var p=_.call(this);p.setValueFormat(v||this._types[this.getType()].ValueFormat);return this;};b.prototype.setEnabled=function(E){this.setProperty("enabled",E,true);var p=_.call(this);p.setEnabled(E);return this;};b.prototype.setEditable=function(E){this.setProperty("editable",E,true);var p=_.call(this);p.setEditable(E);return this;};b.prototype.setValueState=function(v){this.setProperty("valueState",v,true);var p=_.call(this);p.setValueState(v);return this;};b.prototype.setValueStateText=function(v){this.setProperty("valueStateText",v,true);var p=_.call(this);p.setValueStateText(v);return this;};b.prototype.setShowValueStateMessage=function(s){this.setProperty("showValueStateMessage",s,true);var p=_.call(this);p.setShowValueStateMessage(s);return this;};b.prototype.setName=function(n){this.setProperty("name",n,true);var p=_.call(this);p.setName(n);return this;};b.prototype.setPlaceholder=function(p){this.setProperty("placeholder",p,true);var P=_.call(this);P.setPlaceholder(p);return this;};b.prototype.setTextAlign=function(t){this.setProperty("textAlign",t,true);var p=_.call(this);p.setTextAlign(t);return this;};b.prototype.setTextDirection=function(t){this.setProperty("textDirection",t,true);var p=_.call(this);p.setTextDirection(t);return this;};b.prototype.addAriaLabelledBy=function(i){this.addAssociation("ariaLabelledBy",i,true);var p=_.call(this);p.addAriaLabelledBy(i);return this;};b.prototype.removeAriaLabelledBy=function(i){this.removeAssociation("ariaLabelledBy",i,true);var p=_.call(this);p.removeAriaLabelledBy(i);return this;};b.prototype.removeAllAriaLabelledBy=function(){this.removeAssociation("ariaLabelledBy",true);var p=_.call(this);p.removeAllAriaLabelledBy();return this;};b.prototype.getAccessibilityInfo=function(){var p=_.call(this);return p&&p.getAccessibilityInfo?p.getAccessibilityInfo():null;};b.prototype._getPickerByTypeAndPattern=function(t,p,f){var r=/[DdYyMLWwGQUur]/,R=/[HhKkmsa]/,g=R.test(f),h=r.test(f),i=g&&!h,j=h&&!g,k=h&&g,n,N;switch(t){case sap.m.DateTimeInputType.Time:case sap.m.DateTimeInputType.Date:case sap.m.DateTimeInputType.DateTime:if(i&&p.getMetadata().getName()!=="sap.m.TimePicker"){n=sap.m.DateTimeInputType.Time;}else if(j&&p.getMetadata().getName()!=="sap.m.DatePicker"){n=sap.m.DateTimeInputType.Date;}else if(k&&p.getMetadata().getName()!=="sap.m.DateTimePicker"){n=sap.m.DateTimeInputType.DateTime;}break;default:{throw"Invalid type: "+t+". Expected is one of the sap.m.DateTimeInputType";}}if(n){this.destroyAggregation("_picker");N=c.call(this,n);this.setAggregation("_picker",N);}return N||p;};b.prototype._getBoundValueTypePattern=function(){var B=this.getBinding("value"),o=B&&B.getType()&&B.getType();if(o instanceof D||o instanceof T||o instanceof a){return o.getOutputPattern();}if(o instanceof O&&o.oFormat){return o.oFormat.oFormatOptions.pattern;}return undefined;};function _(){return this.getAggregation("_picker");}function d(){if(this._getBoundValueTypePattern()){var p=this._getBoundValueTypePattern();var P=_.call(this);P=this._getPickerByTypeAndPattern(this.getType(),P,p);if(P.getValueFormat()!=p){P.setValueFormat(p);}if(P.getDisplayFormat()!=p){P.setDisplayFormat(p);}}}function e(E){var v=E.getParameter("value");var o;var V=E.getParameter("valid");this.setProperty("value",v,true);if(V){o=E.oSource.getDateValue();this.setProperty("dateValue",o,true);}this.fireChange({value:v,newValue:v,valid:V,dateValue:o,newDateValue:o});}return b;},true);
