/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./InputBase','./DateTimeField','./MaskInputRule','./ResponsivePopover','sap/ui/core/EnabledPropagator','sap/ui/core/IconPool','sap/ui/model/type/Time','sap/ui/model/odata/type/Time','./TimePickerSliders','./MaskEnabler','sap/ui/core/InvisibleText'],function(q,I,D,M,R,E,a,T,b,c,d,e){"use strict";var f=D.extend("sap.m.TimePicker",{metadata:{library:"sap.m",properties:{localeId:{type:"string",group:"Data"},title:{type:"string",group:"Misc",defaultValue:null},minutesStep:{type:"int",group:"Misc",defaultValue:1},secondsStep:{type:"int",group:"Misc",defaultValue:1},placeholderSymbol:{type:"string",group:"Misc",defaultValue:"_"},mask:{type:"string",group:"Misc",defaultValue:null}},aggregations:{rules:{type:"sap.m.MaskInputRule",multiple:true,singularName:"rule"},_picker:{type:"sap.m.ResponsivePopover",multiple:false,visibility:"hidden"}}}});a.insertFontFaceStyle();E.call(f.prototype,true);d.call(f.prototype);var g={Short:"short",Medium:"medium",Long:"long"},h={Hour:"hour",Minute:"minute",Second:"second"},P='-';f.prototype.init=function(){d.init.apply(this,arguments);this.setDisplayFormat(k());this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._bValid=false;this._sUsedDisplayPattern=null;this._sUsedValuePattern=null;this._oDisplayFormat=null;this._sValueFormat=null;this._oPopoverKeydownEventDelegate=null;this._rPlaceholderRegEx=new RegExp(P,'g');this._sLastChangeValue=null;};f.prototype.exit=function(){if(this._oTimeSemanticMaskHelper){this._oTimeSemanticMaskHelper.destroy();}d.exit.apply(this,arguments);this._removePickerEvents();this._oResourceBundle=null;this._bValid=false;this._sUsedDisplayPattern=null;this._oDisplayFormat=null;this._oPopoverKeydownEventDelegate=null;this._sUsedValuePattern=null;this._sValueFormat=null;this._sLastChangeValue=null;};f.prototype.ontap=function(o){var i,p;if(!(this.getEditable()&&this.getEnabled())){return;}i=q(o.target).hasClass("sapUiIcon");p=this._getPicker()&&this._getPicker().isOpen();if(!p&&i){this._openPicker();}else if(i&&!sap.ui.Device.system.phone){this._closePicker();}};f.prototype.onfocusin=function(o){var p=this._getPicker();var i=q(o.target).hasClass("sapUiIcon");d.onfocusin.apply(this,arguments);if(p&&p.isOpen()&&!i){this._closePicker();}};f.prototype.onBeforeOpen=function(){var s=this._getSliders();s.setTimeValues(this.getDateValue());s.collapseAll();this.$().addClass("sapMTPInputActive");};f.prototype.onAfterOpen=function(){var s=this._getSliders();if(s){s._initFocus();this._handleAriaOnExpandCollapse();}};f.prototype.onAfterClose=function(){this.$().removeClass("sapMTPInputActive");this._handleAriaOnExpandCollapse();};f.prototype._handleInputChange=function(v){var o;v=v||this._$input.val();this._bValid=true;if(v!==""){o=this._parseValue(v,true);if(!o){this._bValid=false;}else{v=this._formatValue(o);}}this.updateDomValue(v);if(o){v=this._formatValue(o,true);}this.setProperty("value",v,true);if(this._bValid){this.setProperty("dateValue",o,true);}this.fireChangeEvent(v,{valid:this._bValid});return true;};f.prototype.onChange=function(o){var v=o?o.value:null;if(this.getEditable()&&this.getEnabled()){return this._handleInputChange(v);}return false;};f.prototype.setMinutesStep=function(s){var S=this._getSliders();if(S){S.setMinutesStep(s);}return this.setProperty("minutesStep",s,true);};f.prototype.setSecondsStep=function(s){var S=this._getSliders();if(S){S.setSecondsStep(s);}return this.setProperty("secondsStep",s,true);};f.prototype.setTitle=function(t){var s=this._getSliders();if(s){s.setLabelText(t);}this.setProperty("title",t,true);return this;};f.prototype._handleDateValidation=function(o){if(!o){this._bValid=false;q.sap.log.warning("Value can not be converted to a valid date",this);}else{this._bValid=true;this.setProperty("dateValue",o,true);var v=this._formatValue(o);if(this.isActive()){this.updateDomValue(v);}else{this.setProperty("value",v,true);this._sLastChangeValue=v;}}};f.prototype.setDisplayFormat=function(s){this.setProperty("displayFormat",s,true);this._initMask();var o=this.getDateValue();if(!o){return this;}this.updateDomValue(this._formatValue(o));return this;};f.prototype.setValue=function(v){var o,O;v=this.validateProperty('value',v);this._initMask();d.setValue.call(this,v);this._sLastChangeValue=v;this._bValid=true;if(v){o=this._parseValue(v);if(!o){this._bValid=false;q.sap.log.warning("Value can not be converted to a valid date",this);}}if(this._bValid){this.setProperty("dateValue",o,true);}if(o){O=this._formatValue(o);}else{O=v;}this.updateDomValue(O);return this;};f.prototype.setTooltip=function(t){var o=this.getDomRef(),s;this._refreshTooltipBaseDelegate(t);this.setAggregation("tooltip",t,true);if(!o){return this;}s=this.getTooltip_AsString();if(s){o.setAttribute("title",s);}else{o.removeAttribute("title");}this._handleTooltipHiddenTextLifecycle();return this;};f.prototype._handleTooltipHiddenTextLifecycle=function(){var r,s,A,H,C,o;if(!sap.ui.getCore().getConfiguration().getAccessibility()){return;}r=this.getRenderer();s=r.getAriaDescribedBy(this);A=r.getDescribedByAnnouncement(this);H=this.getId()+"-describedby";C=s.indexOf(H)>-1;o=this.getDomRef("describedby");if(C){o=document.createElement("span");o.id=H;o.setAttribute("aria-hidden","true");o.className="sapUiInvisibleText";o.textContent=A;this.getDomRef().appendChild(o);}else{this.getDomRef().removeChild(o);}this._$input.attr("aria-describedby",s);};f.prototype.setLocaleId=function(l){var C=this.getValue();this.setProperty("localeId",l,true);this._initMask();this._oDisplayFormat=null;this._sValueFormat=null;if(C){this.setValue(C);}return this;};f.prototype._getDefaultDisplayStyle=function(){return g.Medium;};f.prototype._getDefaultValueStyle=function(){return g.Medium;};f.prototype._getFormatterInstance=function(F,p,r,C,i){if(p===g.Short||p===g.Medium||p===g.Long){F=sap.ui.core.format.DateFormat.getTimeInstance({style:p,strictParsing:true,relative:r},new sap.ui.core.Locale(this.getLocaleId()));}else{F=sap.ui.core.format.DateFormat.getTimeInstance({pattern:p,strictParsing:true,relative:r},new sap.ui.core.Locale(this.getLocaleId()));}if(i){this._sUsedDisplayPattern=p;this._oDisplayFormat=F;}else{this._sUsedValuePattern=p;this._sValueFormat=F;}return F;};f.prototype._getFormat=function(){var F=this._getDisplayFormatPattern();if(!F){F=g.Medium;}if(Object.keys(g).indexOf(F)!==-1){F=k();}return F;};f.prototype.onsappageup=function(o){this._increaseTime(1,h.Hour);o.preventDefault();};f.prototype.onsappageupmodifiers=function(o){if(!(o.ctrlKey||o.metaKey||o.altKey)&&o.shiftKey){this._increaseTime(1,h.Minute);}if(!o.altKey&&o.shiftKey&&(o.ctrlKey||o.metaKey)){this._increaseTime(1,h.Second);}o.preventDefault();};f.prototype.onsappagedown=function(o){this._increaseTime(-1,h.Hour);o.preventDefault();};f.prototype.onsappagedownmodifiers=function(o){if(!(o.ctrlKey||o.metaKey||o.altKey)&&o.shiftKey){this._increaseTime(-1,h.Minute);}if(!o.altKey&&o.shiftKey&&(o.ctrlKey||o.metaKey)){this._increaseTime(-1,h.Second);}o.preventDefault();};f.prototype.onkeydown=function(o){var K=q.sap.KeyCodes,i=o.which||o.keyCode,A=o.altKey,p;if(i===K.F4||(A&&(i===K.ARROW_UP||i===K.ARROW_DOWN))){p=this._getPicker()&&this._getPicker().isOpen();if(!p){this._openPicker();}else{this._closePicker();}o.preventDefault();}else{d.onkeydown.call(this,o);}};f.prototype._getPicker=function(){return this.getAggregation("_picker");};f.prototype._removePickerEvents=function(){var p,o=this._getPicker();if(o){p=o.getAggregation("_popup");if(typeof this._oPopoverKeydownEventDelegate==='function'){p.removeEventDelegate(this._oPopoverKeydownEventDelegate);}}};f.prototype._openPicker=function(){var p=this._getPicker(),s;if(!p){p=this._createPicker(this._getDisplayFormatPattern());}p.open();s=this._getSliders();q.sap.delayedCall(0,s,s.updateSlidersValues);return p;};f.prototype._closePicker=function(){var p=this._getPicker();if(p){p.close();}else{q.sap.log.warning("There is no picker to close.");}return p;};f.prototype._createPicker=function(F){var t=this,p,o,r,O,C,s;r=sap.ui.getCore().getLibraryResourceBundle("sap.m");O=r.getText("TIMEPICKER_SET");C=r.getText("TIMEPICKER_CANCEL");s=this.getTitle();o=new R(t.getId()+"-RP",{showCloseButton:false,showHeader:false,horizontalScrolling:false,verticalScrolling:false,placement:sap.m.PlacementType.VerticalPreferedBottom,beginButton:new sap.m.Button({text:O,press:q.proxy(this._handleOkPress,this)}),endButton:new sap.m.Button({text:C,press:q.proxy(this._handleCancelPress,this)}),content:[new c(this.getId()+"-sliders",{format:F,labelText:s?s:"",invokedBy:t.getId(),minutesStep:this.getMinutesStep(),secondsStep:this.getSecondsStep()})],contentHeight:f._PICKER_CONTENT_HEIGHT});p=o.getAggregation("_popup");if(p.setShowArrow){p.setShowArrow(false);}p.oPopup.setAutoCloseAreas([this.getDomRef("icon")]);o.addStyleClass(this.getRenderer().CSS_CLASS+"DropDown").attachBeforeOpen(this.onBeforeOpen,this).attachAfterOpen(this.onAfterOpen,this).attachAfterClose(this.onAfterClose,this);o.open=function(){return this.openBy(t);};if(sap.ui.Device.system.desktop){this._oPopoverKeydownEventDelegate={onkeydown:function(i){var K=q.sap.KeyCodes,l=i.which||i.keyCode,A=i.altKey;if((A&&(l===K.ARROW_UP||l===K.ARROW_DOWN))||l===K.F4){this._handleOkPress(i);this.focus();i.preventDefault();}}};p.addEventDelegate(this._oPopoverKeydownEventDelegate,this);p._afterAdjustPositionAndArrowHook=function(){t._getSliders()._onOrientationChanged();};}this.setAggregation("_picker",o,true);return o;};f.prototype._getSliders=function(){var p=this._getPicker();if(!p){return null;}return p.getContent()[0];};f.prototype._handleOkPress=function(o){var i=this._getSliders().getTimeValues(),v=this._formatValue(i);this.updateDomValue(v);this._handleInputChange();this._closePicker();};f.prototype._handleCancelPress=function(o){this._closePicker();};f.prototype._parseValue=function(v,i){if(i){v=this._oTimeSemanticMaskHelper.stripValueOfLeadingSpaces(v);v=v.replace(this._rPlaceholderRegEx,'');}return D.prototype._parseValue.call(this,v,i);};f.prototype._formatValue=function(o,v){var V=D.prototype._formatValue.apply(this,arguments);if(o){if(!v&&this._oTimeSemanticMaskHelper){V=this._oTimeSemanticMaskHelper.formatValueWithLeadingTrailingSpaces(V);}}return V;};f.prototype._handleAriaOnExpandCollapse=function(){this.getFocusDomRef().setAttribute("aria-expanded",this._getPicker().isOpen());};f.prototype._increaseTime=function(n,u){var o=this.getDateValue(),i,m;if(o&&this.getEditable()&&this.getEnabled()){i=new Date(o.getTime());switch(u){case h.Hour:i.setHours(i.getHours()+n);m=60*60*1000;break;case h.Minute:i.setMinutes(i.getMinutes()+n);m=60*1000;break;case h.Second:m=1000;i.setSeconds(i.getSeconds()+n);}if(n<0&&i.getTime()-o.getTime()!==n*m){i=new Date(o.getTime()+n*m);}this.setDateValue(i);this.fireChangeEvent(this.getValue(),{valid:true});}};f.prototype._initMask=function(){if(this._oTimeSemanticMaskHelper){this._oTimeSemanticMaskHelper.destroy();}this._oTimeSemanticMaskHelper=new j(this);};f.prototype.fireChangeEvent=function(v,p){if(v){v=v.trim();}if(v!==this._sLastChangeValue){this._sLastChangeValue=v;I.prototype.fireChangeEvent.call(this,v,p);}};var j=function(t){var s=t._getDisplayFormatPattern(),m=s,A,l=t.getLocaleId()||sap.ui.getCore().getConfiguration().getFormatLocale(),L=new sap.ui.core.Locale(l),i;t.setProperty("localeId",l,true);this._oTimePicker=t;this.aOriginalAmPmValues=sap.ui.core.LocaleData.getInstance(L).getDayPeriods("abbreviated");this.aAmPmValues=this.aOriginalAmPmValues.slice(0);this.iAmPmValueMaxLength=Math.max(this.aAmPmValues[0].length,this.aAmPmValues[1].length);for(i=0;i<this.aAmPmValues.length;i++){while(this.aAmPmValues[i].length<this.iAmPmValueMaxLength){this.aAmPmValues[i]+=" ";}}this.b24H=s.indexOf("H")!==-1;this.bLeadingZero=s.indexOf("HH")!==-1||s.indexOf("hh")!==-1;this.sLeadingChar=this.bLeadingZero?"0":" ";this.sAlternativeLeadingChar=this.bLeadingZero?" ":"0";this.sLeadingRegexChar=this.bLeadingZero?"0":"\\s";t.setPlaceholderSymbol(P);m=m.replace(/hh/ig,"h").replace(/h/ig,"h9");if(this.b24H){A="["+this.sLeadingRegexChar+"012]";}else{A="["+this.sLeadingRegexChar+"1]";}this._maskRuleHours=new M({maskFormatSymbol:"h",regex:A});t.addRule(this._maskRuleHours);this.iHourNumber1Index=m.indexOf("h9");this.iHourNumber2Index=this.iHourNumber1Index!==-1?this.iHourNumber1Index+1:-1;this.iMinuteNumber1Index=m.indexOf("mm");m=m.replace(/mm/g,"59");this.iSecondNumber1Index=m.indexOf("ss");m=m.replace(/ss/g,"59");this._maskRuleMinSec=new M({maskFormatSymbol:"5",regex:"[0-5]"});t.addRule(this._maskRuleMinSec);this.aAllowedHours=v.call(this,this.b24H,this.sLeadingChar);this.aAllowedMinutesAndSeconds=w.call(this);this.iAmPmChar1Index=m.indexOf("a");this.iAfterAmPmValueIndex=-1;if(this.iAmPmChar1Index!==-1){this.iAfterAmPmValueIndex=this.iAmPmChar1Index+this.iAmPmValueMaxLength;var C=this.iAmPmValueMaxLength-"a".length;this.shiftIndexes(C);var n=65;var o="";var p="";var r="";for(i=0;i<this.iAmPmValueMaxLength;i++){p="[";if(this.aAmPmValues[0][i]){p+=this.aAmPmValues[0][i];}else{p+="\\s";}if(this.aAmPmValues[1][i]!==this.aAmPmValues[0][i]){if(this.aAmPmValues[1][i]){p+=this.aAmPmValues[1][i];}else{p+="\\s";}}p+="]";r=String.fromCharCode(n++);o+=r;this._maskRuleChars=new M({maskFormatSymbol:r,regex:p});t.addRule(this._maskRuleChars);}m=m.replace(/a/g,o);}t.setMask(m);function u(S,x,y){var z=[],B,i;for(i=S;i<=x;i++){B=i.toString();if(i<10){B=y+B;}z.push(B);}return z;}function v(x,y){var S=x?0:1,z=x?23:12;return u(S,z,y);}function w(){return u(0,59,"0");}};j.prototype.replaceChar=function(C,p,s){var A=p-this.iAmPmChar1Index,l,m,n,S,o,r,i;if(p===this.iHourNumber1Index&&this.sAlternativeLeadingChar===C){if(this.aAllowedHours.indexOf(this.sLeadingChar+C)!==-1){return this.sLeadingChar+C;}else{return this.sLeadingChar;}}else if(p===this.iHourNumber1Index&&!this._oTimePicker._isCharAllowed(C,p)&&this.aAllowedHours.indexOf(this.sLeadingChar+C)!==-1){return this.sLeadingChar+C;}else if(p===this.iHourNumber2Index&&this.aAllowedHours.indexOf(s[this.iHourNumber1Index]+C)===-1){return"";}else if((p===this.iMinuteNumber1Index||p===this.iSecondNumber1Index)&&!this._oTimePicker._isCharAllowed(C,p)&&this.aAllowedMinutesAndSeconds.indexOf("0"+C)!==-1){return"0"+C;}else if(A>=0&&p<this.iAfterAmPmValueIndex){l=s.slice(this.iAmPmChar1Index,p);m=this.aAmPmValues[0].slice(0,A);n=this.aAmPmValues[1].slice(0,A);o=this.aAmPmValues[0].slice(A,this.iAfterAmPmValueIndex);r=this.aAmPmValues[1].slice(A,this.iAfterAmPmValueIndex);S=(m===n);var t="";for(i=A;i<this.iAmPmValueMaxLength;i++){if(this.aAmPmValues[0][i]===this.aAmPmValues[1][i]){t+=this.aAmPmValues[0][i];}else{break;}}if(i===this.iAmPmValueMaxLength||i!==A){return t;}else{if(!S){if(l===m){return o;}else if(l===n){return r;}else{return C;}}else{if(this.aAmPmValues[0][A].toLowerCase()===C.toLowerCase()&&this.aAmPmValues[0]===l+o){return o;}else if(this.aAmPmValues[1][A].toLowerCase()===C.toLowerCase()&&this.aAmPmValues[1]===l+r){return r;}else{return C;}}}}else{return C;}};j.prototype.formatValueWithLeadingTrailingSpaces=function(v){var m=this._oTimePicker.getMask().length;if(this.aOriginalAmPmValues[0]!==this.aAmPmValues[0]){v=v.replace(this.aOriginalAmPmValues[0],this.aAmPmValues[0]);}if(this.aOriginalAmPmValues[1]!==this.aAmPmValues[1]){v=v.replace(this.aOriginalAmPmValues[1],this.aAmPmValues[1]);}while(m>v.length){v=[v.slice(0,this.iHourNumber1Index)," ",v.slice(this.iHourNumber1Index)].join('');}return v;};j.prototype.stripValueOfLeadingSpaces=function(v){if(v[this.iHourNumber1Index]===" "){v=[v.slice(0,this.iHourNumber1Index),v.slice(this.iHourNumber1Index+1)].join('');}return v;};j.prototype.shiftIndexes=function(s){if(this.iAmPmChar1Index<this.iHourNumber1Index){this.iHourNumber1Index+=s;this.iHourNumber2Index+=s;}if(this.iAmPmChar1Index<this.iMinuteNumber1Index){this.iMinuteNumber1Index+=s;}if(this.iAmPmChar1Index<this.iSecondNumber1Index){this.iSecondNumber1Index+=s;}};j.prototype.destroy=function(){if(this._maskRuleHours){this._maskRuleHours.destroy();this._maskRuleHours=null;}if(this._maskRuleMinSec){this._maskRuleMinSec.destroy();this._maskRuleMinSec=null;}if(this._maskRuleChars){this._maskRuleChars.destroy();this._maskRuleChars=null;}};f.prototype._feedReplaceChar=function(C,p,s){return this._oTimeSemanticMaskHelper.replaceChar(C,p,s);};f.prototype.getAccessibilityInfo=function(){var r=this.getRenderer();var i=I.prototype.getAccessibilityInfo.apply(this,arguments);var v=this.getValue()||"";if(this._bValid){var o=this.getDateValue();if(o){v=this._formatValue(o);}}q.extend(true,i,{role:r.getAriaRole(this),type:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_TIMEINPUT"),description:[v,r.getLabelledByAnnouncement(this),r.getDescribedByAnnouncement(this)].join(" ").trim(),multiline:false,autocomplete:"none",expanded:false,haspopup:true,owns:this.getId()+"-sliders"});return i;};function k(){var l=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale(),L=sap.ui.core.LocaleData.getInstance(l);return L.getTimePattern(g.Medium);}f._PICKER_CONTENT_HEIGHT="25rem";return f;},true);
