/*
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/base/ManagedObject','./Manifest','./ComponentMetadata','./Core','sap/ui/thirdparty/URI','jquery.sap.trace'],function(q,M,a,C,b,U){"use strict";function c(u){['sap-client','sap-server'].forEach(function(n){if(!u.hasSearch(n)){var v=sap.ui.getCore().getConfiguration().getSAPParam(n);if(v){u.addSearch(n,v);}}});}function d(D,m,s,S){if(s){for(var n in D){if(!m[n]&&s[n]&&s[n].uri){m[n]=S;}}}}function g(m,o,k,e){var D=o.getEntry(k);if(D!==undefined&&!q.isPlainObject(D)){return D;}var p,P;if(e&&(p=m.getParent())instanceof C){P=p.getManifestEntry(k,e);}if(P||D){D=q.extend(true,{},P,D);}return D;}function f(o,e){var i=Object.create(Object.getPrototypeOf(o));i._oMetadata=o;i._oManifest=e;for(var m in o){if(!/^(getManifest|getManifestObject|getManifestEntry|getMetadataVersion)$/.test(m)&&typeof o[m]==="function"){i[m]=o[m].bind(o);}}i.getManifest=function(){return e&&e.getJson();};i.getManifestObject=function(){return e;};i.getManifestEntry=function(k,n){return g(o,e,k,n);};i.getMetadataVersion=function(){return 2;};return i;}function r(e,o){var i=M._sOwnerId;try{M._sOwnerId=o;return e.call();}finally{M._sOwnerId=i;}}var h=M.extend("sap.ui.core.Component",{constructor:function(i,s){var e=Array.prototype.slice.call(arguments);if(typeof i!=="string"){s=i;i=undefined;}if(s&&typeof s._metadataProxy==="object"){this._oMetadataProxy=s._metadataProxy;this._oManifest=s._metadataProxy._oManifest;delete s._metadataProxy;this.getMetadata=function(){return this._oMetadataProxy;};}if(s&&typeof s._cacheTokens==="object"){this._mCacheTokens=s._cacheTokens;delete s._cacheTokens;}if(s&&typeof s._manifestModels==="object"){this._mManifestModels=s._manifestModels;delete s._manifestModels;}else{this._mManifestModels={};}this._mServices={};M.apply(this,e);},metadata:{stereotype:"component","abstract":true,specialSettings:{componentData:'any'},version:"0.0",includes:[],dependencies:{libs:[],components:[],ui5version:""},config:{},customizing:{},library:"sap.ui.core"}},C);h.prototype.getManifest=function(){if(!this._oManifest){return this.getMetadata().getManifest();}else{return this._oManifest.getJson();}};h.prototype.getManifestEntry=function(k){return this._getManifestEntry(k);};h.prototype._getManifestEntry=function(k,m){if(!this._oManifest){return this.getMetadata().getManifestEntry(k,m);}else{return g(this.getMetadata(),this._oManifest,k,m);}};h.prototype.getManifestObject=function(){if(!this._oManifest){return this.getMetadata().getManifestObject();}else{return this._oManifest;}};h.prototype._isVariant=function(){if(this._oManifest){var m=this._oMetadataProxy._oMetadata.getManifestEntry("/sap.app/id");return m!==this.getManifestEntry("/sap.app/id");}else{return false;}};h.activateCustomizing=function(s){};h.deactivateCustomizing=function(s){};h.getOwnerIdFor=function(o){var O=(o instanceof M)&&o._sOwnerId;return O||undefined;};h.getOwnerComponentFor=function(o){var O=h.getOwnerIdFor(o);return O&&sap.ui.component(O);};h.prototype.runAsOwner=function(e){return r(e,this.getId());};h.prototype.getInterface=function(){return this;};h.prototype._initCompositeSupport=function(s){this.oComponentData=s&&s.componentData;if(!this._isVariant()){this.getMetadata().init();}else{this._oManifest.init(this);}this.initComponentModels();if(this.onWindowError){this._fnWindowErrorHandler=q.proxy(function(e){var E=e.originalEvent;this.onWindowError(E.message,E.filename,E.lineno);},this);q(window).bind("error",this._fnWindowErrorHandler);}if(this.onWindowBeforeUnload){this._fnWindowBeforeUnloadHandler=q.proxy(this.onWindowBeforeUnload,this);q(window).bind("beforeunload",this._fnWindowBeforeUnloadHandler);}if(this.onWindowUnload){this._fnWindowUnloadHandler=q.proxy(this.onWindowUnload,this);q(window).bind("unload",this._fnWindowUnloadHandler);}};h.prototype.destroy=function(){for(var L in this._mServices){if(this._mServices[L].instance){this._mServices[L].instance.destroy();}}delete this._mServices;for(var m in this._mManifestModels){this._mManifestModels[m].destroy();}delete this._mManifestModels;if(this._fnWindowErrorHandler){q(window).unbind("error",this._fnWindowErrorHandler);delete this._fnWindowErrorHandler;}if(this._fnWindowBeforeUnloadHandler){q(window).unbind("beforeunload",this._fnWindowBeforeUnloadHandler);delete this._fnWindowBeforeUnloadHandler;}if(this._fnWindowUnloadHandler){q(window).unbind("unload",this._fnWindowUnloadHandler);delete this._fnWindowUnloadHandler;}if(this._oEventBus){this._oEventBus.destroy();delete this._oEventBus;}M.prototype.destroy.apply(this,arguments);sap.ui.getCore().getMessageManager().unregisterObject(this);if(!this._isVariant()){this.getMetadata().exit();}else{this._oManifest.exit(this);}};h.prototype.getComponentData=function(){return this.oComponentData;};h.prototype.getEventBus=function(){if(!this._oEventBus){var E=sap.ui.requireSync("sap/ui/core/EventBus");this._oEventBus=new E();}return this._oEventBus;};h.prototype.initComponentModels=function(){var m=this.getMetadata();if(m.isBaseClass()){return;}var o=this._getManifestEntry("/sap.app/dataSources",true)||{};var e=this._getManifestEntry("/sap.ui5/models",true)||{};this._initComponentModels(e,o);};h.prototype._initComponentModels=function(m,D){var A=h._createManifestModelConfigurations({models:m,dataSources:D,component:this,mergeParent:true,cacheTokens:this._mCacheTokens});if(!A){return;}var e={};for(var s in A){if(!this._mManifestModels[s]){e[s]=A[s];}}var i=h._createManifestModels(e,this.toString());for(var s in i){this._mManifestModels[s]=i[s];}for(var s in this._mManifestModels){var o=this._mManifestModels[s];this.setModel(o,s||undefined);}};h.prototype.getService=function(L){if(!this._mServices[L]){this._mServices[L]={};this._mServices[L].promise=new Promise(function(R,e){sap.ui.require(["sap/ui/core/service/ServiceFactoryRegistry"],function(S){var s=this.getManifestEntry("/sap.ui5/services/"+L);var i=s.factoryName;if(!i){e(new Error("Service "+L+" not declared!"));return;}var o=S.get(i);if(o){o.createInstance({scopeObject:this,scopeType:"component",settings:s.settings||{}}).then(function(k){if(!this.bIsDestroyed){this._mServices[L].instance=k;this._mServices[L].interface=k.getInterface();R(this._mServices[L].interface);}else{e(new Error("Service "+L+" could not be loaded as its Component was destroyed."));}}.bind(this)).catch(e);}else{var E="The ServiceFactory "+i+" for Service "+L+" not found in ServiceFactoryRegistry!";var O=this.getManifestEntry("/sap.ui5/services/"+L+"/optional");if(!O){q.sap.log.error(E);}e(new Error(E));}}.bind(this));}.bind(this));}return this._mServices[L].promise;};function j(o){var s=o.getManifestEntry("/sap.ui5/services");for(var S in s){if(s[S].lazy===false){o.getService(S);}}}h.prototype.createComponent=function(u){var m={async:true};if(u&&typeof u==="object"){m.usage=u.usage;["id","async","settings","componentData"].forEach(function(n){if(u[n]!==undefined){m[n]=u[n];}});}else if(typeof u==="string"){m.usage=u;}return this._createComponent(m);};h.prototype._createComponent=function(m){if(m&&m.usage){var u=m.usage;var e=this.getManifestEntry("/sap.ui5/componentUsages/"+u);if(!e){throw new Error("Component usage \""+u+"\" not declared in Component \""+this.getManifestObject().getComponentName()+"\"!");}m=q.extend(true,e,m);}return this.runAsOwner(function(){return sap.ui.component(m);});};h._createManifestModelConfigurations=function(o){var e=o.component;var m=o.manifest||e.getManifestObject();var k=o.mergeParent;var n=o.cacheTokens||{};var L=e?e.toString():m.getComponentName();var p=sap.ui.getCore().getConfiguration();if(!o.models){return null;}var s={models:o.models,dataSources:o.dataSources||{},origin:{dataSources:{},models:{}}};if(e&&k){var t=e.getMetadata();while(t instanceof C){var u=t.getManifestObject();var v=t.getManifestEntry("/sap.app/dataSources");d(s.dataSources,s.origin.dataSources,v,u);var w=t.getManifestEntry("/sap.ui5/models");d(s.models,s.origin.models,w,u);t=t.getParent();}}var x={};for(var y in s.models){var z=s.models[y];var I=false;var A=null;if(typeof z==='string'){z={dataSource:z};}if(z.dataSource){var D=s.dataSources&&s.dataSources[z.dataSource];if(typeof D==='object'){if(D.type===undefined){D.type='OData';}if(!z.type){switch(D.type){case'OData':if(D.settings&&D.settings.odataVersion==="4.0"){z.type='sap.ui.model.odata.v4.ODataModel';}else{z.type='sap.ui.model.odata.v2.ODataModel';}break;case'JSON':z.type='sap.ui.model.json.JSONModel';break;case'XML':z.type='sap.ui.model.xml.XMLModel';break;default:}}if(z.type==='sap.ui.model.odata.v4.ODataModel'&&D.settings&&D.settings.odataVersion){z.settings=z.settings||{};z.settings.odataVersion=D.settings.odataVersion;}if(!z.uri){z.uri=D.uri;I=true;}if(D.type==='OData'&&D.settings&&typeof D.settings.maxAge==="number"){z.settings=z.settings||{};z.settings.headers=z.settings.headers||{};z.settings.headers["Cache-Control"]="max-age="+D.settings.maxAge;}if(D.type==='OData'&&D.settings&&D.settings.annotations){var B=D.settings.annotations;for(var i=0;i<B.length;i++){var E=s.dataSources[B[i]];if(!E){q.sap.log.error("Component Manifest: ODataAnnotation \""+B[i]+"\" for dataSource \""+z.dataSource+"\" could not be found in manifest","[\"sap.app\"][\"dataSources\"][\""+B[i]+"\"]",L);continue;}if(E.type!=='ODataAnnotation'){q.sap.log.error("Component Manifest: dataSource \""+B[i]+"\" was expected to have type \"ODataAnnotation\" but was \""+E.type+"\"","[\"sap.app\"][\"dataSources\"][\""+B[i]+"\"]",L);continue;}if(!E.uri){q.sap.log.error("Component Manifest: Missing \"uri\" for ODataAnnotation \""+B[i]+"\"","[\"sap.app\"][\"dataSources\"][\""+B[i]+"\"]",L);continue;}var F=new U(E.uri);if(z.type==='sap.ui.model.odata.v2.ODataModel'){["sap-language","sap-client"].forEach(function(X){if(!F.hasQuery(X)&&p.getSAPParam(X)){F.setQuery(X,p.getSAPParam(X));}});var G=n.dataSources&&n.dataSources[E.uri];if(G){var H=function(){if(!F.hasQuery("sap-language")){q.sap.log.warning("Component Manifest: Ignoring provided \"sap-context-token="+G+"\" for ODataAnnotation \""+B[i]+"\" ("+F.toString()+"). "+"Missing \"sap-language\" URI parameter","[\"sap.app\"][\"dataSources\"][\""+B[i]+"\"]",L);return;}if(!F.hasQuery("sap-client")){q.sap.log.warning("Component Manifest: Ignoring provided \"sap-context-token="+G+"\" for ODataAnnotation \""+B[i]+"\" ("+F.toString()+"). "+"Missing \"sap-client\" URI parameter","[\"sap.app\"][\"dataSources\"][\""+B[i]+"\"]",L);return;}if(!F.hasQuery("sap-client",p.getSAPParam("sap-client"))){q.sap.log.warning("Component Manifest: Ignoring provided \"sap-context-token="+G+"\" for ODataAnnotation \""+B[i]+"\" ("+F.toString()+"). "+"URI parameter \"sap-client="+F.query(true)["sap-client"]+"\" must be identical with configuration \"sap-client="+p.getSAPParam("sap-client")+"\"","[\"sap.app\"][\"dataSources\"][\""+B[i]+"\"]",L);return;}if(F.hasQuery("sap-context-token")&&!F.hasQuery("sap-context-token",G)){var X=F.query(true)["sap-context-token"];q.sap.log.warning("Component Manifest: Overriding existing \"sap-context-token="+X+"\" with provided value \""+G+"\" for ODataAnnotation \""+B[i]+"\" ("+F.toString()+").","[\"sap.app\"][\"dataSources\"][\""+B[i]+"\"]",L);}F.setQuery("sap-context-token",G);};H();}}var J=s.origin.dataSources[B[i]]||m;var K=J.resolveUri(F).toString();z.settings=z.settings||{};z.settings.annotationURI=z.settings.annotationURI||[];z.settings.annotationURI.push(K);}}}else{q.sap.log.error("Component Manifest: dataSource \""+z.dataSource+"\" for model \""+y+"\" not found or invalid","[\"sap.app\"][\"dataSources\"][\""+z.dataSource+"\"]",L);}}if(!z.type){q.sap.log.error("Component Manifest: Missing \"type\" for model \""+y+"\"","[\"sap.ui5\"][\"models\"][\""+y+"\"]",L);continue;}if(z.type==='sap.ui.model.odata.ODataModel'&&(!z.settings||z.settings.json===undefined)){z.settings=z.settings||{};z.settings.json=true;}if(z.uri){var N=new U(z.uri);var O=(I?s.origin.dataSources[z.dataSource]:s.origin.models[y])||m;N=O.resolveUri(N);if(z.dataSource){c(N);if(z.type==='sap.ui.model.odata.v2.ODataModel'){A=z.settings&&z.settings.metadataUrlParams;if((!A||typeof A['sap-language']==='undefined')&&!N.hasQuery('sap-language')&&p.getSAPParam('sap-language')){z.settings=z.settings||{};A=z.settings.metadataUrlParams=z.settings.metadataUrlParams||{};A['sap-language']=p.getSAPParam('sap-language');}if(n.dataSources){var G=n.dataSources[D.uri];if(G){var P=function(){if(N.hasQuery("sap-context-token")){q.sap.log.warning("Component Manifest: Ignoring provided \"sap-context-token="+G+"\" for model \""+y+"\" ("+N.toString()+"). "+"Model URI already contains parameter \"sap-context-token="+N.query(true)["sap-context-token"]+"\"","[\"sap.ui5\"][\"models\"][\""+y+"\"]",L);return;}if((!A||typeof A["sap-language"]==="undefined")&&!N.hasQuery("sap-language")){q.sap.log.warning("Component Manifest: Ignoring provided \"sap-context-token="+G+"\" for model \""+y+"\" ("+N.toString()+"). "+"Missing \"sap-language\" parameter","[\"sap.ui5\"][\"models\"][\""+y+"\"]",L);return;}if(!N.hasQuery("sap-client")){q.sap.log.warning("Component Manifest: Ignoring provided \"sap-context-token="+G+"\" for model \""+y+"\" ("+N.toString()+"). "+"Missing \"sap-client\" parameter","[\"sap.ui5\"][\"models\"][\""+y+"\"]",L);return;}if(!N.hasQuery("sap-client",p.getSAPParam("sap-client"))){q.sap.log.warning("Component Manifest: Ignoring provided \"sap-context-token="+G+"\" for model \""+y+"\" ("+N.toString()+"). "+"URI parameter \"sap-client="+N.query(true)["sap-client"]+"\" must be identical with configuration \"sap-client="+p.getSAPParam("sap-client")+"\"","[\"sap.ui5\"][\"models\"][\""+y+"\"]",L);return;}if(A&&typeof A["sap-client"]!=="undefined"){if(A["sap-client"]!==p.getSAPParam("sap-client")){q.sap.log.warning("Component Manifest: Ignoring provided \"sap-context-token="+G+"\" for model \""+y+"\" ("+N.toString()+"). "+"Parameter metadataUrlParams[\"sap-client\"] = \""+A["sap-client"]+"\" must be identical with configuration \"sap-client="+p.getSAPParam("sap-client")+"\"","[\"sap.ui5\"][\"models\"][\""+y+"\"]",L);return;}}if(A&&A["sap-context-token"]&&A["sap-context-token"]!==G){q.sap.log.warning("Component Manifest: Overriding existing \"sap-context-token="+A["sap-context-token"]+"\" with provided value \""+G+"\" for model \""+y+"\" ("+N.toString()+").","[\"sap.ui5\"][\"models\"][\""+y+"\"]",L);}if(!A){z.settings=z.settings||{};A=z.settings.metadataUrlParams=z.settings.metadataUrlParams||{};}A["sap-context-token"]=G;};P();}}}}z.uri=N.toString();}if(z.uriSettingName===undefined){switch(z.type){case'sap.ui.model.odata.ODataModel':case'sap.ui.model.odata.v2.ODataModel':case'sap.ui.model.odata.v4.ODataModel':z.uriSettingName='serviceUrl';break;case'sap.ui.model.resource.ResourceModel':z.uriSettingName='bundleUrl';break;default:}}var S;var Q;if(e){Q=e.getComponentData();}else{Q=o.componentData;}S=Q&&Q.startupParameters&&Q.startupParameters["sap-system"];if(!S){S=p.getSAPParam("sap-system");}var R=false;var T;if(S&&["sap.ui.model.odata.ODataModel","sap.ui.model.odata.v2.ODataModel"].indexOf(z.type)!=-1){R=true;T=sap.ui.requireSync("sap/ui/model/odata/ODataUtils");}if(z.uri){if(R){z.preOriginBaseUri=z.uri.split("?")[0];z.uri=T.setOrigin(z.uri,{alias:S});z.postOriginBaseUri=z.uri.split("?")[0];}if(z.uriSettingName!==undefined){z.settings=z.settings||{};if(!z.settings[z.uriSettingName]){z.settings[z.uriSettingName]=z.uri;}}else if(z.settings){z.settings=[z.uri,z.settings];}else{z.settings=[z.uri];}}else{if(R&&z.uriSettingName!==undefined&&z.settings&&z.settings[z.uriSettingName]){z.preOriginBaseUri=z.settings[z.uriSettingName].split("?")[0];z.settings[z.uriSettingName]=T.setOrigin(z.settings[z.uriSettingName],{alias:S});z.postOriginUri=z.settings[z.uriSettingName].split("?")[0];}}if(R&&z.settings&&z.settings.annotationURI){var V=[].concat(z.settings.annotationURI);var W=[];for(var i=0;i<V.length;i++){W.push(T.setAnnotationOrigin(V[i],{alias:S,preOriginBaseUri:z.preOriginBaseUri,postOriginBaseUri:z.postOriginBaseUri}));}z.settings.annotationURI=W;}if(z.settings&&!Array.isArray(z.settings)){z.settings=[z.settings];}x[y]=z;}return x;};h._createManifestModels=function(m,L){var e={};for(var s in m){var o=m[s];try{q.sap.require(o.type);}catch(E){q.sap.log.error("Component Manifest: Class \""+o.type+"\" for model \""+s+"\" could not be loaded. "+E,"[\"sap.ui5\"][\"models\"][\""+s+"\"]",L);continue;}var i=q.sap.getObject(o.type);if(!i){q.sap.log.error("Component Manifest: Class \""+o.type+"\" for model \""+s+"\" could not be found","[\"sap.ui5\"][\"models\"][\""+s+"\"]",L);continue;}var A=[null].concat(o.settings||[]);var F=i.bind.apply(i,A);var k=new F();e[s]=k;}return e;};h._fnLoadComponentCallback=null;h._fnOnInstanceCreated=null;sap.ui.component=function(v){if(!v){throw new Error("sap.ui.component cannot be called without parameter!");}if(typeof v==='string'){return sap.ui.getCore().getComponent(v);}function e(o){var n=v.name,I=v.id,k=v.componentData,m=n+'.Component',S=v.settings;var p=new o(q.extend({},S,{id:I,componentData:k,_cacheTokens:v.asyncHints&&v.asyncHints.cacheTokens}));q.sap.log.info("Component instance Id = "+p.getId());var H=p.getMetadata().handleValidation()!==undefined||v.handleValidation;if(H){if(p.getMetadata().handleValidation()!==undefined){H=p.getMetadata().handleValidation();}else{H=v.handleValidation;}sap.ui.getCore().getMessageManager().registerObject(p,H);}j(p);if(typeof h._fnOnInstanceCreated==="function"){var P=h._fnOnInstanceCreated(p,v);if(v.async&&P instanceof Promise){return P.then(function(){return p;});}}return p;}var i=l(v,{failOnError:true,createModels:true,waitFor:v.asyncHints&&v.asyncHints.waitFor});if(v.async){var s=M._sOwnerId;return i.then(function(o){return r(function(){return e(o);},s);});}else{return e(i);}};sap.ui.component.load=function(o,F){return l(o,{failOnError:F,preloadOnly:o.asyncHints&&o.asyncHints.preloadOnly});};function l(o,O){var n=o.name,u=o.url,k=sap.ui.getCore().getConfiguration(),m=/^(sync|async)$/.test(k.getComponentPreload()),p=o.manifest,s,t,w,x,y;function z(R){var w=new a(JSON.parse(JSON.stringify(R)));return o.async?Promise.resolve(w):w;}if(p===undefined){s=o.manifestFirst===undefined?k.getManifestFirst():!!o.manifestFirst;t=o.manifestUrl;}else{if(o.async===undefined){o.async=true;}s=!!p;t=p&&typeof p==='string'?p:undefined;w=p&&typeof p==='object'?z(p):undefined;}q.sap.interaction.setStepComponent(n);if(!w&&t){w=a.load({manifestUrl:t,componentName:n,async:o.async});}if(w&&!o.async){n=w.getComponentName();}if(!(w&&o.async)){if(!n){throw new Error("The name of the component is undefined.");}}if(n&&u){q.sap.registerModulePath(n,u);}if(s&&!w){w=a.load({manifestUrl:q.sap.getModulePath(n)+"/manifest.json",componentName:n,async:o.async,failOnError:false});}function A(){return q.sap.getResourceName(n+".Component","");}function B(e){var i=n+'.Component';if(!e){var v="The specified component controller '"+i+"' could not be found!";if(O.failOnError){throw new Error(v);}else{q.sap.log.warning(v);}}if(w){var N=f(e.getMetadata(),w);var P=function(){var Q=Array.prototype.slice.call(arguments);var S;if(Q.length===0||typeof Q[0]==="object"){S=Q[0]=Q[0]||{};}else if(typeof Q[0]==="string"){S=Q[1]=Q[1]||{};}S._metadataProxy=N;if(x){S._manifestModels=x;}var R=Object.create(e.prototype);e.apply(R,Q);return R;};P.getMetadata=function(){return N;};P.extend=function(){throw new Error("Extending Components created by Manifest is not supported!");};return P;}else{return e;}}function D(v,i){if(typeof v==='object'){if(v.url){q.sap.registerModulePath(v.name,v.url);}return(v.lazy&&i!==true)?undefined:v.name;}return v;}function E(i,v){var N=i+'.Component',P;if(m&&i!=null&&!q.sap.isDeclared(N,true)){if(v){P=q.sap.getResourceName(N,'-preload.js');return q.sap._loadJSResourceAsync(P,true);}try{P=N+'-preload';q.sap.require(P);}catch(e){q.sap.log.warning("couldn't preload component from "+P+": "+((e&&e.message)||e));}}}function F(e,w,i){var P=[];var v=i?function(V){P.push(V);}:q.noop;w.defineResourceRoots();var N=w.getEntry("/sap.ui5/dependencies/libs");if(N){var Q=[];for(var R in N){if(!N[R].lazy){Q.push(R);}}if(Q.length>0){q.sap.log.info("Component \""+e+"\" is loading libraries: \""+Q.join(", ")+"\"");v(sap.ui.getCore().loadLibraries(Q,{async:i}));}}var S=w.getEntry("/sap.ui5/extends/component");if(S){v(E(S,i));}var T=w.getEntry("/sap.ui5/dependencies/components");if(T){for(var e in T){if(!T[e].lazy){v(E(e,i));}}}return i?Promise.all(P):undefined;}if(o.async){var G=o.asyncHints||{},H=[],I=function(P){if(P){H.push(P);}},J=function($){return $;},K,L;if(w&&O.createModels){I(w.then(function(w){var e=q.extend(true,{},w.getEntry("/sap.app/dataSources"));var i=q.extend(true,{},w.getEntry("/sap.ui5/models"));var v=h._createManifestModelConfigurations({models:i,dataSources:e,manifest:w,componentData:o.componentData,cacheTokens:G.cacheTokens});if(v){var P=q.sap.getUriParameters().get("sap-ui-xx-preload-component-models-"+w.getComponentName());var N=P&&P.split(",");var Q={};for(var R in v){var S=v[R];if(!S.preload&&N&&N.indexOf(R)>-1){S.preload=true;q.sap.log.warning("FOR TESTING ONLY!!! Activating preload for model \""+R+"\" ("+S.type+")",w.getComponentName(),"sap.ui.core.Component");}if(S.preload){if(q.sap.isDeclared(S.type,true)){Q[R]=S;}else{q.sap.log.warning("Can not preload model \""+R+"\" as required class has not been loaded: \""+S.type+"\"",w.getComponentName(),"sap.ui.core.Component");}}}if(Object.keys(Q).length>0){x=h._createManifestModels(Q,w.getComponentName());}}return w;}));}K=[];if(Array.isArray(G.preloadBundles)){G.preloadBundles.forEach(function(v){K.push(q.sap._loadJSResourceAsync(D(v,true),true));});}if(Array.isArray(G.libs)){L=G.libs.map(D).filter(J);K.push(sap.ui.getCore().loadLibraries(L,{preloadOnly:true}));}K=Promise.all(K);if(L&&!O.preloadOnly){K=K.then(function(){return sap.ui.getCore().loadLibraries(L);});}I(K);if(!w){I(E(n,true));}else{I(w.then(function(w){var e=w.getComponentName();if(u){q.sap.registerModulePath(e,u);}return E(e,true);}));y=function(e){if(typeof h._fnLoadComponentCallback==="function"){var i=q.extend(true,{},o);var v=q.extend(true,{},e);try{h._fnLoadComponentCallback(i,v);}catch(N){q.sap.log.error("Callback for loading the component \""+w.getComponentName()+"\" run into an error. The callback was skipped and the component loading resumed.",N,"sap.ui.core.Component");}}};}if(G.components){q.each(G.components,function(i,v){I(E(D(v),true));});}return Promise.all(H).then(function(v){if(w&&y){w.then(y);}return v;}).then(function(v){q.sap.log.debug("Component.load: all promises fulfilled, then "+v);if(w){return w.then(function(e){w=e;n=w.getComponentName();return F(n,w,true);});}else{return v;}}).then(function(){if(O.preloadOnly){return true;}return new Promise(function(e,i){sap.ui.require([A()],function(v){e(B(v));});});}).then(function(e){var i=O.waitFor;if(i){var P=Array.isArray(i)?i:[i];return Promise.all(P).then(function(){return e;});}return e;}).catch(function(e){if(x){for(var n in x){var i=x[n];if(i&&typeof i.destroy==="function"){i.destroy();}}}throw e;});}if(w){F(n,w);}E(n);return B(sap.ui.requireSync(A()));}return h;});
