/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/format/DateFormat","sap/ui/model/odata/ODataUtils","./_Helper"],function(D,O,_){"use strict";var r=/^\/Date\((\d+)\)\/$/,d=D.getDateInstance({pattern:"yyyy-MM-dd",UTC:true}),a=/^\/Date\((\d+)(?:([-+])(\d\d)(\d\d))?\)\/$/,o=D.getDateTimeInstance({pattern:"yyyy-MM-dd'T'HH:mm:ss",UTC:true}),b=D.getDateTimeInstance({pattern:"yyyy-MM-dd'T'HH:mm:ss.SSS",UTC:true}),c=/\+/g,e=/\//g,f=/^PT(?:(?:(\d+)H)?(?:(\d+)M)?(?:(\d+)(\.\d+)?S)?)$/i,t=D.getTimeInstance({pattern:"HH:mm:ss",UTC:true});function g(){}g.prototype.mFinalHeaders={"Content-Type":"application/json;charset=UTF-8"};g.prototype.mPredefinedPartHeaders={"Accept":"application/json"};g.prototype.mPredefinedRequestHeaders={"Accept":"application/json","MaxDataServiceVersion":"2.0","DataServiceVersion":"2.0","X-CSRF-Token":"Fetch"};g.prototype.convertBinary=function(v){return v.replace(c,"-").replace(e,"_");};g.prototype.convertDate=function(v){var h,m=r.exec(v);if(!m){throw new Error("Not a valid Edm.DateTime value '"+v+"'");}h=new Date(parseInt(m[1],10));if(Number(m[1]%(24*60*60*1000))!==0){throw new Error("Cannot convert Edm.DateTime value '"+v+"' to Edm.Date because it contains a time of day");}return d.format(h);};g.prototype.convertDateTimeOffset=function(v){var m=a.exec(v),F,s,i,h,j,T;if(!m){throw new Error("Not a valid Edm.DateTimeOffset value '"+v+"'");}T=parseInt(m[1],10);i=parseInt(m[3],10);h=parseInt(m[4],10);if(!m[2]||i===0&&h===0){s="Z";}else{j=m[2]==="-"?-1:1;T+=j*(i*60*60*1000+h*60*1000);s=m[2]+m[3]+":"+m[4];}F=T%1000?b:o;return F.format(new Date(T))+s;};g.prototype.convertDoubleSingle=function(v){switch(v){case"NaN":case"INF":case"-INF":return v;default:return parseFloat(v);}};g.prototype.convertTimeOfDay=function(v){var h,m=f.exec(v),T;if(!m){throw new Error("Not a valid Edm.Time value '"+v+"'");}T=Date.UTC(1970,0,1,m[1]||0,m[2]||0,m[3]||0);h=new Date(T);return t.format(h)+(m[4]||"");};g.prototype.convertNonPrimitive=function(h,T){var p,P,i,s,v,j=this;if(h.results&&!h.__metadata){h.results.forEach(function(I){j.convertNonPrimitive(I,T);});return h.results;}if(!h.__metadata||!h.__metadata.type){throw new Error("Cannot convert complex value without type information in "+"__metadata.type: "+JSON.stringify(h));}s=h.__metadata.type;i=T[s];delete h.__metadata;for(p in h){v=h[p];if(v===null){continue;}if(typeof v==="object"){if(v.__deferred){delete h[p];}else{h[p]=this.convertNonPrimitive(v,T);}continue;}P=i[p]&&i[p].$Type;h[p]=this.convertPrimitive(v,P,s,p);}return h;};g.prototype.convertPrimitive=function(v,p,T,P){switch(p){case"Edm.Binary":return this.convertBinary(v);case"Edm.Date":return this.convertDate(v);case"Edm.DateTimeOffset":return this.convertDateTimeOffset(v);case"Edm.Boolean":case"Edm.Byte":case"Edm.Decimal":case"Edm.Guid":case"Edm.Int16":case"Edm.Int32":case"Edm.Int64":case"Edm.SByte":case"Edm.String":return v;case"Edm.Double":case"Edm.Single":return this.convertDoubleSingle(v);case"Edm.TimeOfDay":return this.convertTimeOfDay(v);default:throw new Error("Type '"+p+"' of property '"+P+"' in type '"+T+"' is unknown; cannot convert value: "+v);}};g.prototype.doFetchV4Response=function(R){var h=this;return this.fnFetchEntityContainer().then(function(s){var p=h.convertNonPrimitive(R.d,s);if(R.d.results&&!R.d.__metadata){p={value:p};if(R.d.__count){p["@odata.count"]=R.d.__count;}if(R.d.__next){p["@odata.nextLink"]=R.d.__next;}}return p;});};g.prototype.doConvertSystemQueryOptions=function(q,R,h,s){var S=[];function i(E,m,p){if(!m||typeof m!=="object"){throw new Error("$expand must be a valid object");}Object.keys(m).forEach(function(j){var A=_.buildPath(p,j),v=m[j],k;E.push(A);if(typeof v==="object"){Object.keys(v).forEach(function(Q){switch(Q){case"$expand":i(E,v.$expand,A);break;case"$select":k=v.$select;if(!Array.isArray(k)){k=k.split(",");}k.forEach(function(l){S.push(_.buildPath(A,l));});break;default:throw new Error("Unsupported query option in $expand: "+Q);}});}if(!v.$select){S.push(A+"/*");}});return E;}Object.keys(q).forEach(function(n){var I=n[0]==='$',v=q[n];if(h&&I){return;}switch(n){case"$expand":v=i([],v,"");v=(s?v.sort():v).join(",");break;case"$orderby":break;case"$select":S.push.apply(S,Array.isArray(v)?v:v.split(","));return;default:if(I){throw new Error("Unsupported system query option: "+n);}}R(n,v);});if(S.length>0){if(!q.$select){S.push("*");}R("$select",(s?S.sort():S).join(","));}};g.prototype.formatPropertyAsLiteral=function(v,p){var T=p.$v2Type||p.$Type;switch(T){case"Edm.Binary":case"Edm.DateTime":case"Edm.DateTimeOffset":case"Edm.Time":throw new Error("Type '"+T+"' in the key is not supported");default:return O.formatValue(v,T);}};return function(h){jQuery.extend(h,g.prototype);};},false);
