/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/base/ManagedObject","sap/ui/rta/toolbar/Fiori","sap/ui/rta/toolbar/Standalone","sap/ui/rta/toolbar/Personalization","sap/ui/dt/ElementUtil","sap/ui/dt/DesignTime","sap/ui/dt/OverlayRegistry","sap/ui/dt/Overlay","sap/ui/rta/command/Stack","sap/ui/rta/command/CommandFactory","sap/ui/rta/command/LREPSerializer","sap/ui/rta/plugin/Rename","sap/ui/rta/plugin/DragDrop","sap/ui/rta/plugin/RTAElementMover","sap/ui/rta/plugin/CutPaste","sap/ui/rta/plugin/Remove","sap/ui/rta/plugin/CreateContainer","sap/ui/rta/plugin/additionalElements/AdditionalElementsPlugin","sap/ui/rta/plugin/additionalElements/AddElementsDialog","sap/ui/rta/plugin/additionalElements/AdditionalElementsAnalyzer","sap/ui/rta/plugin/Combine","sap/ui/rta/plugin/Split","sap/ui/rta/plugin/Selection","sap/ui/rta/plugin/Settings","sap/ui/dt/plugin/ContextMenu","sap/ui/dt/plugin/TabHandling","sap/ui/fl/FlexControllerFactory","sap/ui/rta/ui/SettingsDialog","sap/ui/rta/Utils","sap/ui/fl/transport/Transports","sap/ui/fl/transport/TransportSelection","sap/ui/fl/Utils","sap/ui/fl/registry/Settings","sap/m/MessageBox","sap/m/MessageToast","sap/ui/rta/util/PopupManager","sap/ui/core/BusyIndicator","sap/ui/dt/DOMUtil","sap/ui/rta/util/StylesLoader","sap/ui/rta/appVariant/ManageAppsLoader","sap/ui/Device"],function(q,M,F,S,P,E,D,O,a,C,b,L,R,c,d,e,f,g,A,h,i,j,k,l,m,n,T,o,p,U,r,s,t,u,v,w,x,B,y,z,G,H){"use strict";var I="sap-ui-fl-max-layer";var J=M.extend("sap.ui.rta.RuntimeAuthoring",{metadata:{library:"sap.ui.rta",associations:{"rootControl":{type:"sap.ui.core.Control"}},properties:{"customFieldUrl":"string","showCreateCustomField":"boolean","showToolbars":{type:"boolean",defaultValue:true},"triggeredFromDialog":{type:"boolean",defaultValue:false},"showSettingsDialog":{type:"boolean",defaultValue:true},"showWindowUnloadDialog":{type:"boolean",defaultValue:true},"commandStack":{type:"any"},"plugins":{type:"any",defaultValue:{}},"flexSettings":{type:"object",defaultValue:{layer:"CUSTOMER",developerMode:true}},"mode":{type:"string",defaultValue:"adaptation"}},events:{"start":{parameters:{editablePluginsCount:{type:"int"}}},"stop":{},"failed":{},"selectionChange":{parameters:{selection:{type:"sap.ui.dt.Overlay[]"}}},"modeChanged":{},"undoRedoStackModified":{}}},_sAppTitle:null,_dependents:null,constructor:function(){M.apply(this,arguments);this._dependents={};this.iEditableOverlaysCount=0;this.addDependent(new x(),'popupManager');if(this.getShowToolbars()){this.getPopupManager().attachOpen(this.onPopupOpen,this);this.getPopupManager().attachClose(this.onPopupClose,this);}}});J.prototype.getDefaultPlugins=function(){if(!this._mDefaultPlugins){var d1=new b({flexSettings:this.getFlexSettings()});this._mDefaultPlugins={};this._mDefaultPlugins["selection"]=new l({commandFactory:d1,multiSelectionRequiredPlugins:[j.getMetadata().getName(),f.getMetadata().getName()],elementEditableChange:this._onElementEditableChange.bind(this)});var e1=new d({commandFactory:d1});this._mDefaultPlugins["dragDrop"]=new c({elementMover:e1,commandFactory:d1,dragStarted:this._handleStopCutPaste.bind(this)});this._mDefaultPlugins["cutPaste"]=new e({elementMover:e1,commandFactory:d1});this._mDefaultPlugins["remove"]=new f({commandFactory:d1});this._mDefaultPlugins["additionalElements"]=new A({commandFactory:d1,analyzer:i,dialog:new h()});this._mDefaultPlugins["rename"]=new R({commandFactory:d1,editable:this._handleStopCutPaste.bind(this)});this._mDefaultPlugins["settings"]=new m({commandFactory:d1});this._mDefaultPlugins["createContainer"]=new g({commandFactory:d1});this._mDefaultPlugins["combine"]=new j({commandFactory:d1});this._mDefaultPlugins["split"]=new k({commandFactory:d1});this._mDefaultPlugins["contextMenu"]=new n({styleClass:U.getRtaStyleClassName()});this._mDefaultPlugins["tabHandling"]=new T();}return q.extend({},this._mDefaultPlugins);};J.prototype.addDependent=function(d1,e1){if(!(e1 in this._dependents)){if(e1){this['get'+q.sap.charToUpperCase(e1,0)]=this.getDependent.bind(this,e1);}this._dependents[e1||d1.getId()]=d1;}};J.prototype.getDependent=function(d1){return this._dependents[d1];};J.prototype.getDependents=function(){return this._dependents;};J.prototype._destroyDefaultPlugins=function(d1){for(var e1 in this._mDefaultPlugins){var f1=this._mDefaultPlugins[e1];if(f1&&!f1.bIsDestroyed){if(!d1||d1[e1]!==f1){f1.destroy();}}}if(!d1){this._mDefaultPlugins=null;}};J.prototype.onPopupOpen=function(d1){if(d1.getParameters()instanceof sap.m.Dialog&&this.getToolbar()instanceof F){this.getToolbar().setColor("contrast");}this.getToolbar().bringToFront();};J.prototype.onPopupClose=function(d1){if(d1.getParameters()instanceof sap.m.Dialog){this.getToolbar().setColor();}};J.prototype.setPlugins=function(d1){if(this._oDesignTime){throw new Error('Cannot replace plugins: runtime authoring already started');}this.setProperty("plugins",d1);};J.prototype.setFlexSettings=function(d1){var e1=q.sap.getUriParameters();var f1=e1.mParams["sap-ui-layer"];d1=q.extend({},this.getFlexSettings(),d1);if(f1&&f1.length>0){d1.layer=f1[0];}U.setRtaStyleClassName(d1.layer);this.setProperty("flexSettings",d1);};J.prototype.getLayer=function(d1){return this.getFlexSettings().layer;};J.prototype._getFlexController=function(){var d1=this._oRootControl||sap.ui.getCore().byId(this.getRootControl());return o.createForControl(d1);};J.prototype._getTextResources=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");};J.prototype.start=function(){if(!this._oDesignTime){this._oRootControl=sap.ui.getCore().byId(this.getRootControl());return this._handlePersonalizationChangesOnStart().then(function(d1){if(!d1){if(!this.getPlugins()||!Object.keys(this.getPlugins()).length){this.setPlugins(this.getDefaultPlugins());}this._destroyDefaultPlugins(this.getPlugins());Object.keys(this.getPlugins()).forEach(function(g1){if(this.getPlugins()[g1].attachElementModified){this.getPlugins()[g1].attachElementModified(this._handleElementModified,this);}}.bind(this));if(this.getPlugins()["settings"]){this.getPlugins()["settings"].setCommandStack(this.getCommandStack());}this._buildContextMenu();this._oSerializer=new L({commandStack:this.getCommandStack(),rootControl:this.getRootControl()});var e1=Object.keys(this.getPlugins());var f1=e1.map(function(g1){return this.getPlugins()[g1];},this);q.sap.measure.start("rta.dt.startup","Measurement of RTA: DesignTime start up");this._oDesignTime=new D({rootElements:[this._oRootControl],plugins:f1});q(a.getOverlayContainer()).addClass("sapUiRta");if(this.getLayer()==="USER"){q(a.getOverlayContainer()).addClass("sapUiRtaPersonalize");}this._oRootControl.addStyleClass("sapUiRtaRoot");this._oDesignTime.attachSelectionChange(function(g1){this.fireSelectionChange({selection:g1.getParameter("selection")});},this);this._oDesignTime.attachEventOnce("synced",function(){this.fireStart({editablePluginsCount:this.iEditableOverlaysCount});q.sap.measure.end("rta.dt.startup","Measurement of RTA: DesignTime start up");},this);this._oDesignTime.attachEventOnce("syncFailed",function(){this.fireFailed();},this);this._$document=q(document);this.fnKeyDown=this._onKeyDown.bind(this);this._$document.on("keydown",this.fnKeyDown);this._oldUnloadHandler=window.onbeforeunload;window.onbeforeunload=this._onUnload.bind(this);sap.ui.getCore().getEventBus().subscribe("sap.ushell.renderers.fiori2.Renderer","appClosed",this._onAppClosed,this);}return Promise.resolve(d1);}.bind(this)).then(function(d1){var e1;if(this.getShowToolbars()&&!d1){return u.getInstance(t.getComponentClassName(this._oRootControl)).then(function(f1){e1=G.hasAppVariantsSupport(this.getLayer(),f1.isAtoEnabled()&&f1.isAtoAvailable());return!f1.isProductiveSystem()&&!f1.hasMergeErrorOccured();}.bind(this)).catch(function(f1){return false;}).then(function(f1){this._createToolsMenu(f1,e1);return this.getToolbar().show();}.bind(this));}}.bind(this)).then(function(){this.getPopupManager().setRta(this);var d1=this.getPopupManager().getRelevantPopups();if(d1.aDialogs||d1.aPopovers){return this.getShowToolbars()&&this.getToolbar().bringToFront();}}.bind(this)).then(function(){z.loadStyles('InPageStyles').then(function(d1){var e1=d1.replace(/%scrollWidth%/g,y.getScrollbarWidth()+'px');y.insertStyles(e1);});});}};var K=function(d1){var e1=d1.stack||d1.message||d1.status||d1;var f1=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");q.sap.log.error("Failed to transfer runtime adaptation changes to layered repository",e1);var g1=f1.getText("MSG_LREP_TRANSFER_ERROR")+"\n"+f1.getText("MSG_ERROR_REASON",e1);v.error(g1,{styleClass:U.getRtaStyleClassName()});};J.prototype._onAppClosed=function(){this.stop(true,true);};J.prototype.setCommandStack=function(d1){var e1=this.getProperty("commandStack");if(e1){e1.detachModified(this._onStackModified,this);}if(this._oInternalCommandStack){this._oInternalCommandStack.destroy();delete this._oInternalCommandStack;}var f1=this.setProperty("commandStack",d1);if(d1){d1.attachModified(this._onStackModified,this);}if(this.getPlugins()&&this.getPlugins()["settings"]){this.getPlugins()["settings"].setCommandStack(d1);}return f1;};J.prototype.getCommandStack=function(){var d1=this.getProperty("commandStack");if(!d1){d1=new C();this._oInternalCommandStack=d1;this.setCommandStack(d1);}return d1;};J.prototype._onStackModified=function(){var d1=this.getCommandStack();var e1=d1.canUndo();var f1=d1.canRedo();var g1=U.getUshellContainer();if(this.getShowToolbars()){this.getToolbar().setUndoRedoEnabled(e1,f1);this.getToolbar().setPublishEnabled(this._bChangesExist||e1);this.getToolbar().setRestoreEnabled(this._bChangesExist||e1);}this.fireUndoRedoStackModified();if(g1){if(e1){g1.setDirtyFlag(true);}else{g1.setDirtyFlag(false);}}};J.prototype._closeToolbar=function(){if(this.getShowToolbars()){return this.getToolbar().hide();}};J.prototype.getSelection=function(){if(this._oDesignTime){return this._oDesignTime.getSelection();}else{return[];}};J.prototype.stop=function(d1,e1){return((d1)?Promise.resolve():this._serializeToLrep()).then(this._closeToolbar.bind(this)).then(e1?Promise.resolve():this._handlePersonalizationChangesOnExit.bind(this)).then(function(){this.exit();this.fireStop();}.bind(this))['catch'](K);};J.prototype.restore=function(){this._onRestore();};J.prototype.transport=function(){this._onTransport();};J.prototype.undo=function(){return this._onUndo();};J.prototype.redo=function(){return this._onRedo();};J.prototype.canUndo=function(){return this.getCommandStack().canUndo();};J.prototype.canRedo=function(){return this.getCommandStack().canRedo();};J.prototype._onKeyDown=function(d1){var e1=H.os.macintosh;var f1=a.getOverlayContainer().contains(document.activeElement);var g1=this.getShowToolbars()&&this.getToolbar().getDomRef().contains(document.activeElement);var h1=document.body===document.activeElement;var i1=q(document.activeElement).parents('.sapUiRtaEditableField').length>0;if((f1||g1||h1)&&!i1){var j1=e1?d1.metaKey:d1.ctrlKey;if(d1.keyCode===q.sap.KeyCodes.Z&&d1.shiftKey===false&&d1.altKey===false&&j1===true){this._onUndo().then(d1.stopPropagation.bind(d1));}else if(((e1&&d1.keyCode===q.sap.KeyCodes.Z&&d1.shiftKey===true)||(!e1&&d1.keyCode===q.sap.KeyCodes.Y&&d1.shiftKey===false))&&d1.altKey===false&&j1===true){this._onRedo().then(d1.stopPropagation.bind(d1));}}};J.prototype._onUnload=function(){var d1=this.getCommandStack();var e1=d1.canUndo()||d1.canRedo();if(e1&&this.getShowWindowUnloadDialog()){var f1=this._getTextResources().getText("MSG_UNSAVED_CHANGES");return f1;}else{window.onbeforeunload=this._oldUnloadHandler;}};J.prototype._serializeToLrep=function(){return this._oSerializer.saveCommands();};J.prototype._onUndo=function(){this._handleStopCutPaste();return this.getCommandStack().undo();};J.prototype._onRedo=function(){this._handleStopCutPaste();return this.getCommandStack().redo();};J.prototype._createToolsMenu=function(d1,e1){if(!this.getDependent('toolbar')){var f1;if(this.getLayer()==="USER"){f1=P;}else if(U.getFiori2Renderer()){f1=F;}else{f1=S;}if(this.getLayer()==="USER"){this.addDependent(new f1({textResources:this._getTextResources(),exit:this.stop.bind(this,false,false),restore:this._onRestore.bind(this)}),'toolbar');}else{this.addDependent(new f1({modeSwitcher:this.getMode(),publishVisible:d1,textResources:this._getTextResources(),manageAppsVisible:e1,exit:this.stop.bind(this,false,false),transport:this._onTransport.bind(this),restore:this._onRestore.bind(this),undo:this._onUndo.bind(this),redo:this._onRedo.bind(this),modeChange:this._onModeChange.bind(this),manageApps:G.load.bind(null,this.getRootControl())}),'toolbar');}this._checkChangesExist().then(function(g1){this._bChangesExist=g1;this.getToolbar().setPublishEnabled(g1);this.getToolbar().setRestoreEnabled(g1);}.bind(this));}};J.prototype.exit=function(){q.map(this._dependents,function(e1){e1.destroy();});if(this._oDesignTime){q(a.getOverlayContainer()).removeClass("sapUiRta");this._oDesignTime.destroy();this._oDesignTime=null;this._$document.off("keydown",this.fnKeyDown);this._destroyDefaultPlugins();this.setPlugins(null);}if(this._oRootControl){this._oRootControl.removeStyleClass("sapUiRtaRoot");}this.setCommandStack(null);var d1=U.getUshellContainer();if(d1){d1.setDirtyFlag(false);}window.onbeforeunload=this._oldUnloadHandler;sap.ui.getCore().getEventBus().unsubscribe("sap.ushell.renderers.fiori2.Renderer","appClosed",this._onAppClosed,this);};J.prototype._onTransport=function(){var d1=function(e1){B.hide();if(e1.message!=='createAndApply failed'){t.log.error("transport error"+e1);return this._showMessage(v.Icon.ERROR,"HEADER_TRANSPORT_ERROR","MSG_TRANSPORT_ERROR",e1);}}.bind(this);this._handleStopCutPaste();return this._openSelection().then(this._checkTransportInfo).then(function(e1){if(e1){return this._serializeToLrep().then(function(){return this._getFlexController().getComponentChanges({currentLayer:this.getLayer()}).then(function(f1){if(f1.length>0){B.show(0);return this._createAndApplyChanges(f1).then(this._transportAllLocalChanges.bind(this,e1))['catch'](d1);}}.bind(this));}.bind(this))['catch'](K);}}.bind(this));};J.prototype._checkTransportInfo=function(d1){if(d1&&d1.transport&&d1.packageName!=="$TMP"){return d1;}else{return false;}};J.prototype._openSelection=function(){return new s().openTransportSelection(null,this._oRootControl,U.getRtaStyleClassName());};J.prototype._createAndApplyChanges=function(d1){var e1=[];return Promise.resolve().then(function(){function f1(g1){return g1&&g1.selector&&g1.selector.id;}d1.filter(f1).forEach(function(g1){var h1=sap.ui.getCore().byId(g1.selector.id);e1.push(function(){return Promise.resolve().then(function(){return this._getFlexController().createAndApplyChange(g1,h1);}.bind(this));}.bind(this));}.bind(this));return t.execPromiseQueueSequentially(e1);}.bind(this)).catch(function(f1){t.log.error("Create and apply error: "+f1);return f1;}).then(function(f1){return this._getFlexController().saveAll().then(function(){if(f1){throw f1;}});}.bind(this)).catch(function(f1){t.log.error("Create and apply and/or save error: "+f1);return this._showMessage(v.Icon.ERROR,"HEADER_TRANSPORT_APPLYSAVE_ERROR","MSG_TRANSPORT_APPLYSAVE_ERROR",f1);}.bind(this));};J.prototype._deleteChanges=function(){var d1=new s();var e1=this.getLayer();var f1=this.getCommandStack().getAllExecutedCommands().reduce(function(g1,h1){if(h1.getPreparedChange){g1.push(h1.getPreparedChange());}return g1;},[]);this._getFlexController().getComponentChanges({currentLayer:e1}).then(function(g1){g1=g1.concat(f1);return u.getInstance(t.getComponentClassName(this._oRootControl)).then(function(h1){if(!h1.isProductiveSystem()&&!h1.hasMergeErrorOccured()){return d1.setTransports(g1,this._oRootControl);}}.bind(this)).then(function(){return this._getFlexController().discardChanges(g1,e1==="USER");}.bind(this)).then(function(){return window.location.reload();});}.bind(this))["catch"](function(g1){return this._showMessage(v.Icon.ERROR,"HEADER_RESTORE_FAILED","MSG_RESTORE_FAILED",g1);}.bind(this));};J.prototype._showMessage=function(d1,e1,f1,g1){var h1=this._getTextResources().getText(f1,g1?[g1.message||g1]:undefined);var i1=this._getTextResources().getText(e1);return new Promise(function(j1){v.show(h1,{icon:d1,title:i1,onClose:j1,styleClass:U.getRtaStyleClassName()});});};J.prototype._showMessageToast=function(d1){var e1=this._getTextResources().getText(d1);w.show(e1);};J.needsRestart=function(d1){var e1=!!window.localStorage.getItem("sap.ui.rta.restart."+d1);return e1;};J.enableRestart=function(d1){window.localStorage.setItem("sap.ui.rta.restart."+d1,true);};J.disableRestart=function(d1){window.localStorage.removeItem("sap.ui.rta.restart."+d1);};J.prototype._onRestore=function(){var d1=this.getLayer()==="USER"?this._getTextResources().getText("FORM_PERS_RESET_MESSAGE_PERSONALIZATION"):this._getTextResources().getText("FORM_PERS_RESET_MESSAGE");var e1=this.getLayer()==="USER"?this._getTextResources().getText("BTN_RESTORE"):this._getTextResources().getText("FORM_PERS_RESET_TITLE");var f1=function(g1){if(g1==="OK"){J.enableRestart(this.getLayer());this._deleteChanges();this.getCommandStack().removeAllCommands();}}.bind(this);this._handleStopCutPaste();v.confirm(d1,{icon:v.Icon.WARNING,title:e1,onClose:f1,styleClass:U.getRtaStyleClassName()});};J.prototype._transportAllLocalChanges=function(d1){return this._getFlexController().getComponentChanges({currentLayer:this.getLayer()}).then(function(e1){var f1=new r();var g1=f1._convertToChangeTransportData(e1);var h1={};h1.package=d1.packageName;h1.transportId=d1.transport;h1.changeIds=g1;return f1.makeChangesTransportable(h1).then(function(){e1.forEach(function(i1){if(i1.getPackage()==='$TMP'){var j1=i1.getDefinition();j1.packageName=d1.packageName;i1.setResponse(j1);}});}).then(function(){B.hide();this._showMessageToast("MSG_TRANSPORT_SUCCESS");}.bind(this));}.bind(this));};J.prototype._isEqualParentInfo=function(d1,e1){var f1=!!d1&&!!e1;if(f1&&(d1.parent&&e1.parent)){f1=d1.parent.getId()===e1.parent.getId();}if(f1&&(d1.index||e1.index)){f1=d1.index===e1.index;}if(f1&&(d1.aggregation||e1.aggregation)){f1=d1.aggregation===e1.aggregation;}return f1;};J.prototype._setRenameOnCreatedContainer=function(d1,e1){var f1=this.getPlugins()["createContainer"].getCreatedContainerOverlay(d1,e1);if(f1){f1.setSelected(true);if(this.getPlugins()["rename"]){var g1={"onAfterRendering":function(){setTimeout(function(){this.getPlugins()["rename"].startEdit(f1);}.bind(this),0);f1.removeEventDelegate(g1);}.bind(this)};f1.addEventDelegate(g1);}}};J.prototype._handleElementModified=function(d1){this._handleStopCutPaste();var e1=d1.getParameter("action");var f1=d1.getParameter("newControlId");var g1=d1.getParameter("command");if(g1 instanceof sap.ui.rta.command.BaseCommand){return this.getCommandStack().pushAndExecute(g1).then(function(){if(e1&&f1){this._setRenameOnCreatedContainer(e1,f1);}}.bind(this));}return Promise.resolve();};J.prototype._onElementEditableChange=function(d1){var e1=d1.getParameter("editable");if(e1){this.iEditableOverlaysCount+=1;}else{this.iEditableOverlaysCount-=1;}};J.prototype._handleRemoveElement=function(d1){this.getPlugins()["remove"].removeElement(d1);};J.prototype._openSettingsDialog=function(d1){var e1=(d1.mParameters)?d1.getParameter("selectedOverlays"):d1;var f1=e1[0].getElementInstance();this._handleStopCutPaste();if(!this._oSettingsDialog){this._oSettingsDialog=new p();}this._oSettingsDialog.setCommandStack(this.getCommandStack());this._oSettingsDialog.open(f1);};var N=function(d1){return this._oDesignTime.getSelection().length<2;};var Q=function(d1){return d1.getMovable();};var V=function(d1){return this.getPlugins()["remove"].isRemoveAvailable(d1);};var W=function(d1){return this.getPlugins()["remove"].isRemoveEnabled(d1);};var X=function(d1){return this.getPlugins()["rename"].isRenameAvailable(d1);};var Y=function(d1){return this.getPlugins()["rename"].isRenameEnabled(d1);};var Z=function(d1){return this.getPlugins()["settings"].isSettingsAvailable(d1);};var $=function(d1){return this.getPlugins()["settings"].isSettingsEnabled(d1);};var _=function(d1){return this.getPlugins()["combine"].isCombineAvailable(d1);};var a1=function(d1){return this.getPlugins()["combine"].isCombineEnabled(d1);};var b1=function(d1){return this.getPlugins()["split"].isSplitAvailable(d1);};var c1=function(d1){return this.getPlugins()["split"].isSplitEnabled(d1);};J.prototype._buildContextMenu=function(){var d1=this.getPlugins()["contextMenu"];if(!d1){return;}var e1=this.getPlugins()["additionalElements"];var f1=this.getPlugins()["createContainer"];if(this.getPlugins()["rename"]){d1.addMenuItem({id:"CTX_RENAME_LABEL",text:this._getTextResources().getText("CTX_RENAME"),handler:this._handleRename.bind(this),available:X.bind(this),enabled:function(g1){return(N.call(this,g1)&&Y.call(this,g1));}.bind(this)});}if(e1){d1.addMenuItem({id:"CTX_ADD_ELEMENTS_AS_SIBLING",text:e1.getContextMenuTitle.bind(e1,true),handler:e1.showAvailableElements.bind(e1,true),available:e1.isAvailable.bind(e1,true),enabled:function(g1){return N.call(this,g1)&&e1.isEnabled(true,g1);}.bind(this)});d1.addMenuItem({id:"CTX_ADD_ELEMENTS_AS_CHILD",text:e1.getContextMenuTitle.bind(e1,false),handler:e1.showAvailableElements.bind(e1,false),available:e1.isAvailable.bind(e1,false),enabled:function(g1){return N.call(this,g1)&&e1.isEnabled(false,g1);}.bind(this)});}if(f1){d1.addMenuItem({id:"CTX_CREATE_CHILD_CONTAINER",text:f1.getCreateContainerText.bind(f1,false),handler:this._createContainer.bind(this,false),available:f1.isCreateAvailable.bind(f1,false),enabled:f1.isCreateEnabled.bind(f1,false)});d1.addMenuItem({id:"CTX_CREATE_SIBLING_CONTAINER",text:f1.getCreateContainerText.bind(f1,true),handler:this._createContainer.bind(this,true),available:f1.isCreateAvailable.bind(f1,true),enabled:f1.isCreateEnabled.bind(f1,true)});}if(this.getPlugins()["remove"]){d1.addMenuItem({id:"CTX_REMOVE",text:this._getTextResources().getText("CTX_REMOVE"),handler:this._handleRemoveElement.bind(this),available:V.bind(this),enabled:W.bind(this)});}d1.addMenuItem({id:"CTX_CUT",text:this._getTextResources().getText("CTX_CUT"),handler:this._handleCutElement.bind(this),available:Q,enabled:function(){return this._oDesignTime.getSelection().length===1;}.bind(this)});if(this.getPlugins()["cutPaste"]){d1.addMenuItem({id:"CTX_PASTE",text:this._getTextResources().getText("CTX_PASTE"),handler:this._handlePasteElement.bind(this),available:Q,enabled:function(g1){return this.getPlugins()["cutPaste"].isElementPasteable(g1);}.bind(this)});}d1.addMenuItem({id:"CTX_GROUP_FIELDS",text:this._getTextResources().getText("CTX_GROUP_FIELDS"),handler:this._handleCombineElements.bind(this),available:_.bind(this),enabled:a1.bind(this)});d1.addMenuItem({id:"CTX_UNGROUP_FIELDS",text:this._getTextResources().getText("CTX_UNGROUP_FIELDS"),handler:this._handleSplitElements.bind(this),available:b1.bind(this),enabled:c1.bind(this)});if(this.getPlugins()["settings"]){d1.addMenuItem({id:"CTX_SETTINGS",text:this._getTextResources().getText("CTX_SETTINGS"),handler:this._handleSettings.bind(this),available:Z.bind(this),enabled:$.bind(this)});}};J.prototype._createContainer=function(d1,e1){this._handleStopCutPaste();var f1=e1[0];this.getPlugins()["createContainer"].handleCreate(d1,f1);};J.prototype._handleRename=function(d1){var e1=d1[0];this.getPlugins()["rename"].startEdit(e1);};J.prototype._handleCutElement=function(d1){var e1=d1[0];this.getPlugins()["cutPaste"].cut(e1);};J.prototype._handlePasteElement=function(d1){var e1=d1[0];this.getPlugins()["cutPaste"].paste(e1);};J.prototype._handleStopCutPaste=function(){this.getPlugins()["cutPaste"].stopCutAndPaste();};J.prototype._handleCombineElements=function(){this._handleStopCutPaste();var d1=this.getPlugins()["contextMenu"].getContextElement();this.getPlugins()["combine"].handleCombine(d1);};J.prototype._handleSplitElements=function(){this._handleStopCutPaste();var d1=this.getPlugins()["contextMenu"].getContextElement();this.getPlugins()["split"].handleSplit(d1);};J.prototype._handleSettings=function(d1){this.getPlugins()["settings"].handleSettings(d1);};J.prototype._getApplicationTitle=function(){var d1="";var e1=sap.ui.core.Component.getOwnerComponentFor(this._oRootControl);if(e1){d1=e1.getMetadata().getManifestEntry("sap.app").title;}return d1;};J.prototype._checkChangesExist=function(){if(this._getFlexController().getComponentName().length>0){return this._getFlexController().getComponentChanges({currentLayer:this.getLayer()}).then(function(d1){return d1.length>0;});}else{return Promise.resolve(false);}};J.prototype._getURLParsedHash=function(){var d1=sap.ushell.Container.getService("URLParsing");if(d1.parseShellHash&&d1.getHash){return d1.parseShellHash(d1.getHash(window.location.href));}};J.prototype._buildNavigationArguments=function(d1){return{target:{semanticObject:d1.semanticObject,action:d1.action,context:d1.contextRaw},params:d1.params,appSpecificRoute:d1.appSpecificRoute,writeHistory:false};};J.prototype._hasCustomerLayerParameter=function(d1){return d1.params&&d1.params[I]&&d1.params[I][0]==="CUSTOMER";};J.prototype._reloadWithoutPersonalizationChanges=function(d1,e1){if(!this._hasCustomerLayerParameter(d1)){if(!d1.params){d1.params={};}d1.params[I]=["CUSTOMER"];J.enableRestart("CUSTOMER");e1.toExternal(this._buildNavigationArguments(d1));return Promise.resolve(true);}};J.prototype._reloadWithPersonalizationChanges=function(d1,e1){if(this._hasCustomerLayerParameter(d1)){delete d1.params[I];e1.toExternal(this._buildNavigationArguments(d1));return Promise.resolve(true);}};J.prototype._handlePersonalizationMessageBoxOnStart=function(){return this._showMessage(v.Icon.INFORMATION,"HEADER_PERSONALIZATION_EXISTS","MSG_PERSONALIZATION_EXISTS");};J.prototype._handlePersonalizationChangesOnStart=function(){var d1=U.getUshellContainer();if(d1&&this.getLayer()!=="USER"){var e1=this._getURLParsedHash();return this._getFlexController().isPersonalized({ignoreMaxLayerParameter:false}).then(function(f1){if(f1){return this._handlePersonalizationMessageBoxOnStart().then(function(){var g1=sap.ushell.Container.getService("CrossApplicationNavigation");if(g1.toExternal&&e1){return this._reloadWithoutPersonalizationChanges(e1,g1);}}.bind(this));}}.bind(this));}else{return Promise.resolve(false);}};J.prototype._handlePersonalizationMessageBoxOnExit=function(){return new Promise(function(d1){var e1=this._getTextResources().getText("MSG_LOAD_PERSONALIZATION_CHANGES");var f1=this._getTextResources().getText("HEADER_LOAD_PERSONALIZATION_CHANGES");var g1=this._getTextResources().getText("MSG_PERSONALIZATION_CONFIRM_BUTTON_TEXT");var h1=this._getTextResources().getText("MSG_PERSONALIZATION_CANCEL_BUTTON_TEXT");var i1=function(j1){if(j1===g1){return d1(true);}else if(j1===h1){return d1(false);}};v.confirm(e1,{icon:v.Icon.QUESTION,title:f1,actions:[g1,h1],onClose:i1,styleClass:U.getRtaStyleClassName()});}.bind(this));};J.prototype._handlePersonalizationChangesOnExit=function(){var d1=U.getUshellContainer();sap.ui.getCore().getEventBus().unsubscribe("sap.ushell.renderers.fiori2.Renderer","appClosed",this._onAppClosed,this);if(d1&&this.getLayer()!=="USER"){return this._getFlexController().isPersonalized({ignoreMaxLayerParameter:true}).then(function(e1){if(e1){return this._handlePersonalizationMessageBoxOnExit().then(function(f1){if(f1){var g1=sap.ushell.Container.getService("CrossApplicationNavigation");var h1=this._getURLParsedHash();if(g1.toExternal&&h1){return this._reloadWithPersonalizationChanges(h1,g1);}}}.bind(this));}}.bind(this));}else{return Promise.resolve(false);}};J.prototype._onModeChange=function(d1){this.setMode(d1.getParameter('key'));};J.prototype.setMode=function(d1){if(this.getProperty('mode')!==d1){var e1=this.getShowToolbars()&&this.getToolbar().getControl('modeSwitcher');var f1=d1==='adaptation';if(e1){e1.setSelectedButton(e1.getItems().filter(function(g1){return g1.getKey()===d1;}).pop().getId());}this._oDesignTime.setEnabled(f1);this.getPlugins()['tabHandling'][f1?'removeTabIndex':'restoreTabIndex']();this.setProperty('mode',d1);this.fireModeChanged({mode:d1});}};return J;},true);
