/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/rta/plugin/Plugin','sap/ui/rta/Utils','sap/ui/rta/command/CompositeCommand','sap/ui/dt/OverlayRegistry'],function(P,U,C,O){"use strict";var R=P.extend("sap.ui.rta.plugin.Remove",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});R.prototype.registerElementOverlay=function(o){if(this.isRemoveEnabled(o)){o.attachBrowserEvent("keydown",this._onKeyDown,this);}P.prototype.registerElementOverlay.apply(this,arguments);};R.prototype._isEditable=function(o){var e=false;var E=o.getElementInstance();var p=U.getRelevantContainerDesigntimeMetadata(o);if(!p){return false;}var r=this._getRemoveAction(o);if(r&&r.changeType){if(r.changeOnRelevantContainer){E=o.getRelevantContainer();}e=this.hasChangeHandler(r.changeType,E);}if(e){return this.hasStableId(o);}return e;};R.prototype._getRemoveAction=function(o){return o.getDesignTimeMetadata()?o.getDesignTimeMetadata().getAction("remove",o.getElementInstance()):null;};R.prototype.isRemoveAvailable=function(o){return this._isEditableByPlugin(o);};R.prototype.isRemoveEnabled=function(o){var a=this._getRemoveAction(o);if(!a){return false;}if(typeof a.isEnabled!=="undefined"){if(typeof a.isEnabled==="function"){return a.isEnabled(o.getElementInstance());}else{return a.isEnabled;}}return true;};R.prototype._getConfirmationText=function(o){var a=this._getRemoveAction(o);if(a&&a.getConfirmationText){return a.getConfirmationText(o.getElementInstance());}};R.prototype.deregisterElementOverlay=function(o){if(this.isRemoveEnabled(o)){o.detachBrowserEvent("keydown",this._onKeyDown,this);}P.prototype.deregisterElementOverlay.apply(this,arguments);};R.prototype._onKeyDown=function(e){if(e.keyCode===jQuery.sap.KeyCodes.DELETE){e.stopPropagation();this.removeElement();}};R.prototype.removeElement=function(o){var s;if(o){s=o;}else{var d=this.getDesignTime();s=d.getSelection();}s=s.filter(this.isRemoveEnabled,this);if(s.length>0){this._handleRemove(s);}};R.prototype._getRemoveCommand=function(r,d,v){return this.getCommandFactory().getCommandFor(r,"Remove",{removedElement:r},d,v);};R.prototype._fireElementModified=function(c){if(c.getCommands().length){this.fireElementModified({"command":c});}};R.prototype._handleRemove=function(s){var p=[];var c=new C();var S=function(o){o.setSelected(true);setTimeout(function(){o.focus();},0);};var n=R._getElementToFocus(s);s.forEach(function(o){var a;var r=o.getElementInstance();var d=o.getDesignTimeMetadata();var b=this._getRemoveAction(o);var e;if(b.changeOnRelevantContainer){e=o.getRelevantContainer();}else{e=r;}var v=this.getVariantManagementKey(o,e,b.changeType);var f=this._getConfirmationText(o);if(f){p.push(U.openRemoveConfirmationDialog(r,f).then(function(g){if(g){a=this._getRemoveCommand(r,d,v);c.addCommand(a);}}.bind(this)));}else{a=this._getRemoveCommand(r,d,v);c.addCommand(a);}},this);if(p.length){Promise.all(p).then(function(){this._fireElementModified(c);S(n);}.bind(this));}else{this._fireElementModified(c);S(n);}};R._getElementToFocus=function(s){var n;if(s.length===1){var o=s[0];var S=o.getParent().getAggregation(o.sParentAggregationName);if(S.length>1){var i=S.indexOf(o);var c=S.slice(i+1);if(i!==0){c=c.concat(S.slice(0,i).reverse());}n=c.filter(function(a){return a.getElementInstance().getVisible();}).shift();}}if(!n){n=O.getOverlay(s[0].getRelevantContainer());}return n;};return R;},true);
