/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/rta/plugin/Plugin','sap/ui/dt/Overlay','sap/ui/dt/ElementUtil','sap/ui/dt/OverlayUtil','sap/ui/dt/OverlayRegistry','sap/ui/rta/Utils','sap/ui/dt/DOMUtil'],function(q,P,O,E,a,b,U,D){"use strict";var R=P.extend("sap.ui.rta.plugin.Rename",{metadata:{library:"sap.ui.rta",properties:{oldValue:"string"},associations:{},events:{"editable":{},"nonEditable":{}}}});R.prototype.exit=function(){P.prototype.exit.apply(this,arguments);if(this._$oEditableControlDomRef){this._stopEdit();}clearTimeout(this._iStopTimeout);};R.prototype.setDesignTime=function(d){this._aSelection=[];var o=this.getDesignTime();if(o){o.detachSelectionChange(this._onDesignTimeSelectionChange,this);}P.prototype.setDesignTime.apply(this,arguments);if(d){d.attachSelectionChange(this._onDesignTimeSelectionChange,this);this._aSelection=d.getSelection();}};R.prototype._getRenameAction=function(o){var d=o.getDesignTimeMetadata();if(d&&d.getAction){return d.getAction("rename",o.getElementInstance());}};R.prototype.isRenameAvailable=function(o){return this._isEditableByPlugin(o);};R.prototype.isRenameEnabled=function(o){var i=true;var A=this._getRenameAction(o);if(!A){i=false;}if(i&&typeof A.isEnabled!=="undefined"){if(typeof A.isEnabled==="function"){i=A.isEnabled(o.getElementInstance());}else{i=A.isEnabled;}}if(i){var d=o.getDesignTimeMetadata();if(!d.getAssociatedDomRef(o.getElementInstance(),A.domRef)){i=false;}}return i;};R.prototype.registerElementOverlay=function(o){o.attachEvent("editableChange",this._manageClickEvent,this);P.prototype.registerElementOverlay.apply(this,arguments);};R.prototype._isEditable=function(o){var e=false;var c=o.getElementInstance();if(!U.getRelevantContainerDesigntimeMetadata(o)){return false;}var r=this._getRenameAction(o);if(r&&r.changeType){if(r.changeOnRelevantContainer){c=o.getRelevantContainer();}e=this.hasChangeHandler(r.changeType,c);}if(e){return this.hasStableId(o);}return e;};R.prototype.deregisterElementOverlay=function(o){o.detachEvent("editableChange",this._manageClickEvent,this);o.detachBrowserEvent("click",this._onClick,this);this.removeFromPluginsList(o);};R.prototype._onClick=function(e){var o=sap.ui.getCore().byId(e.currentTarget.id);if(this.isRenameEnabled(o)&&!e.metaKey&&!e.ctrlKey){this.startEdit(o);e.preventDefault();}};R.prototype._onDesignTimeSelectionChange=function(e){var s=e.getParameter("selection");this._aSelection.forEach(this._manageClickEvent,this);s.forEach(this._manageClickEvent,this);this._aSelection=s;};R.prototype._manageClickEvent=function(e){var o=e.getSource?e.getSource():e;if(o.isSelected()&&this.isRenameAvailable(o)){o.attachBrowserEvent("click",this._onClick,this);}else{o.detachBrowserEvent("click",this._onClick,this);}};R.prototype.startEdit=function(o){this._oEditedOverlay=o;var e=o.getElementInstance();var d=this._oEditedOverlay.getDesignTimeMetadata();var v=d.getAction("rename",e).domRef;var c=d.getAssociatedDomRef(e,v);if(!U.isElementInViewport(c)){c.get(0).scrollIntoView();}this._$oEditableControlDomRef=q(c);var f=sap.ui.dt.OverlayRegistry.getOverlay(c.id)||o;var w=q("<div class='sapUiRtaEditableField'></div>").appendTo(f.$());this._$editableField=q("<div contentEditable='true'></div>").appendTo(w);if(this._$oEditableControlDomRef.text()===""){this._$oEditableControlDomRef.text("_?_");this._$editableField.text("");}else{this._$editableField.text(this._$oEditableControlDomRef.text());}D.copyComputedStyle(this._$oEditableControlDomRef,this._$editableField);this._$editableField.children().remove();this._$editableField.css('visibility','hidden');this._$editableField.css({"-moz-user-modify":"read-write","-webkit-user-modify":"read-write","-ms-user-modify":"read-write","user-modify":"read-write","text-overflow":"clip"});O.getMutationObserver().ignoreOnce({target:this._$oEditableControlDomRef.get(0)});this._$editableField.one("focus",this._onEditableFieldFocus.bind(this));this._$editableField.on("blur",this._onEditableFieldBlur.bind(this));this._$editableField.on("keydown",this._onEditableFieldKeydown.bind(this));this._$editableField.on("dragstart",this._stopPropagation.bind(this));this._$editableField.on("drag",this._stopPropagation.bind(this));this._$editableField.on("dragend",this._stopPropagation.bind(this));this._$editableField.on("click",this._stopPropagation.bind(this));this._$editableField.on("mousedown",this._stopPropagation.bind(this));this.setOldValue(this._getCurrentEditableFieldText());setTimeout(function(){this._$oEditableControlDomRef.css("visibility","hidden");this._$editableField.offset({left:this._$oEditableControlDomRef.offset().left});this._$editableField.offset({top:this._$oEditableControlDomRef.offset().top});this._$editableField.css('visibility','');this._$editableField.focus();o.setSelected(true);sap.ui.getCore().getEventBus().publish('sap.ui.rta','plugin.Rename.startEdit',{overlay:o,editableField:this._$editableField});}.bind(this),0);};R.prototype._stopPropagation=function(e){e.stopPropagation();};R.prototype._onEditableFieldFocus=function(e){this._oEditedOverlay.setSelected(false);var c=e.target;var r=document.createRange();r.selectNodeContents(c);var s=window.getSelection();s.removeAllRanges();s.addRange(r);};R.prototype._stopEdit=function(r){if(this._$oEditableControlDomRef.text()==="_?_"){this._$oEditableControlDomRef.text("");}this._oEditedOverlay.$().find(".sapUiRtaEditableField").remove();O.getMutationObserver().ignoreOnce({target:this._$oEditableControlDomRef.get(0)});this._$oEditableControlDomRef.css("visibility","visible");if(r){var o=this._oEditedOverlay;this._iStopTimeout=setTimeout(function(){o.setSelected(true);o.focus();sap.ui.getCore().getEventBus().publish('sap.ui.rta','plugin.Rename.stopEdit',{overlay:o});},500);}this._oEditedOverlay.setSelected(false);delete this._$editableField;delete this._$oEditableControlDomRef;delete this._oEditedOverlay;};R.prototype._onEditableFieldBlur=function(e){this._emitLabelChangeEvent();this._stopEdit();};R.prototype._onEditableFieldKeydown=function(e){switch(e.keyCode){case q.sap.KeyCodes.ENTER:this._emitLabelChangeEvent();this._stopEdit(true);e.preventDefault();break;case q.sap.KeyCodes.ESCAPE:this._stopEdit(true);e.preventDefault();break;case q.sap.KeyCodes.DELETE:e.stopPropagation();break;default:}};R.prototype._emitLabelChangeEvent=function(){var t=this._getCurrentEditableFieldText();if(this.getOldValue()!==t){this._$oEditableControlDomRef.text(t);try{var r;var o=this._oEditedOverlay.getElementInstance();var d=this._oEditedOverlay.getDesignTimeMetadata();r=this.getCommandFactory().getCommandFor(o,"rename",{renamedElement:o,newValue:t},d);this.fireElementModified({"command":r});}catch(e){q.sap.log.error("Error during rename : ",e);}}};R.prototype._getCurrentEditableFieldText=function(){var t=this._$editableField.text();if(t===""){t='\xa0';}return t;};return R;},true);
