/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/rta/library','sap/ui/core/Control','sap/m/Dialog','sap/ui/layout/VerticalLayout','sap/m/Label','sap/m/Input','sap/m/Select','sap/ui/core/Item','sap/m/Button','sap/m/CheckBox','sap/ui/rta/command/CommandFactory','sap/ui/rta/command/CompositeCommand','sap/ui/dt/ElementUtil'],function(q,l,C,D,V,L,I,S,a,B,b,c,d,E){"use strict";var e=C.extend("sap.ui.rta.ui.SettingsDialog",{metadata:{library:"sap.ui.rta",properties:{"commandStack":{type:"sap.ui.core.Control"}},associations:{"element":{type:"sap.ui.core.Element"}}}});e.prototype.init=function(){this._oTextResources=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");this._oDialog=this._createDialog();};e.prototype._createDialog=function(){return new D({title:this._oTextResources.getText("HEADER_SETTINGS"),contentHeight:"500px",draggable:true,buttons:[new B({text:this._oTextResources.getText("BTN_FREP_OK"),press:[this._applyChangesAndClose,this]}),new B({text:this._oTextResources.getText("BTN_FREP_CANCEL"),press:[this._cancelDialog,this]})]}).addStyleClass("sapUiPopupWithPadding").addStyleClass("sapUiSizeCompact");};e.prototype._applyChangesAndClose=function(){this._applyChanges();this._oDialog.close();};e.prototype._iterateExecutedCommands=function(f){Object.keys(this._mCommands).forEach(function(p){f(this._mCommands[p]);},this);};e.prototype._applyChanges=function(){var o=new d();this._iterateExecutedCommands(function(f){o.addCommand(f);});if(o.getCommands().length){this.getCommandStack().pushExecutedCommand(o);}};e.prototype._cancelDialog=function(){this._iterateExecutedCommands(function(o){o.undo();});this._oDialog.close();};e.prototype._executePropertyChangeCommand=function(o,p,n,O){if(!this._mCommands[p]){var P=c.getCommandFor(o,"property",{propertyName:p,newValue:n,oldValue:O});this._mCommands[p]=P;P.execute();}else{this._mCommands[p].undo();delete this._mCommands[p];}};e.prototype._createBooleanEditor=function(o,p,P){var f=new b({text:p,selected:P});f.attachSelect(function(g){var n=g.getParameter("selected");var O=!n;this._executePropertyChangeCommand(o,p,n,O);},this);return f;};e.prototype._createStringEditor=function(o,p,P){var i=new I({value:P});i.attachChange(function(f){var n=f.getParameter("value");var O=P;this._executePropertyChangeCommand(o,p,n,O);},this);return i;};e.prototype._createEnumEditor=function(o,p,P,v){var s=new S();Object.keys(p).forEach(function(k){s.addItem(new a({text:k,key:p[k]}));});s.setSelectedKey(v);s.attachChange(function(f){var i=f.getParameter("selectedItem");if(i){var n=i.getKey();var O=v;this._executePropertyChangeCommand(o,P,n,O);}},this);return s;};e.prototype._updateDialogContent=function(o){this._oDialog.removeAllContent();var v=new V();var p=o.getMetadata().getAllProperties();Object.keys(p).forEach(function(P){var f;var g=p[P];var h=o[g._sGetter]();if(g.type==="boolean"){f=this._createBooleanEditor(o,P,h);v.addContent(f);}else if(g.type==="string"||g.type==="sap.ui.core.CSSSize"){f=new V();var i=this._createStringEditor(o,P,h);f.addContent(new L({text:P,labelFor:i.getId()}));f.addContent(i);f.addStyleClass("sapUiRtaDialogEntryWithMargin");}else{var j=q.sap.getObject(g.type);if(j){f=new V();var k=this._createEnumEditor(o,j,P,h);f.addContent(new L({text:P,labelFor:k.getId()}));f.addContent(k);f.addStyleClass("sapUiRtaDialogEntryWithMargin");}}if(f){v.addContent(f);}},this);this._oDialog.addContent(v);};e.prototype.open=function(o){this._mCommands={};this._updateDialogContent(o);this._oDialog.open();};return e;},true);
