/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/Device','sap/ui/core/Control','sap/ui/core/Element','sap/ui/core/IconPool','sap/ui/core/ResizeHandler','sap/ui/core/ScrollBar','sap/ui/core/delegate/ItemNavigation','sap/ui/core/theming/Parameters','sap/ui/model/ChangeReason','sap/ui/model/Context','sap/ui/model/Filter','sap/ui/model/SelectionModel','sap/ui/model/Sorter',"sap/ui/model/BindingMode",'./Column','./Row','./library','./TableUtils','./TableExtension','./TableAccExtension','./TableKeyboardExtension','./TablePointerExtension','./TableScrollExtension','jquery.sap.dom','jquery.sap.trace'],function(q,D,C,E,I,R,S,c,P,d,e,F,f,g,B,h,j,k,T,m,n,o,p,r){"use strict";var G=k.GroupEventType,N=k.NavigationMode,s=k.SelectionMode,t=k.SelectionBehavior,u=k.SortOrder,V=k.VisibleRowCountMode;var v=C.extend("sap.ui.table.Table",{metadata:{library:"sap.ui.table",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'},rowHeight:{type:"int",group:"Appearance",defaultValue:null},columnHeaderHeight:{type:"int",group:"Appearance",defaultValue:null},columnHeaderVisible:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCount:{type:"int",group:"Appearance",defaultValue:10},firstVisibleRow:{type:"int",group:"Appearance",defaultValue:0},selectionMode:{type:"sap.ui.table.SelectionMode",group:"Behavior",defaultValue:s.MultiToggle},selectionBehavior:{type:"sap.ui.table.SelectionBehavior",group:"Behavior",defaultValue:t.RowSelector},selectedIndex:{type:"int",group:"Appearance",defaultValue:-1},editable:{type:"boolean",group:"Behavior",defaultValue:true},navigationMode:{type:"sap.ui.table.NavigationMode",group:"Behavior",defaultValue:N.Scrollbar},threshold:{type:"int",group:"Appearance",defaultValue:100},enableColumnReordering:{type:"boolean",group:"Behavior",defaultValue:true},enableGrouping:{type:"boolean",group:"Behavior",defaultValue:false},showColumnVisibilityMenu:{type:"boolean",group:"Appearance",defaultValue:false},showNoData:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCountMode:{type:"sap.ui.table.VisibleRowCountMode",group:"Appearance",defaultValue:V.Fixed},minAutoRowCount:{type:"int",group:"Appearance",defaultValue:5},fixedColumnCount:{type:"int",group:"Appearance",defaultValue:0},fixedRowCount:{type:"int",group:"Appearance",defaultValue:0},fixedBottomRowCount:{type:"int",group:"Appearance",defaultValue:0},enableColumnFreeze:{type:"boolean",group:"Behavior",defaultValue:false},enableCellFilter:{type:"boolean",group:"Behavior",defaultValue:false},showOverlay:{type:"boolean",group:"Appearance",defaultValue:false},enableSelectAll:{type:"boolean",group:"Behavior",defaultValue:true},enableCustomFilter:{type:"boolean",group:"Behavior",defaultValue:false},enableBusyIndicator:{type:"boolean",group:"Behavior",defaultValue:false},rowActionCount:{type:"int",group:"Appearance",defaultValue:0}},defaultAggregation:"columns",aggregations:{title:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},footer:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},toolbar:{type:"sap.ui.core.Toolbar",multiple:false,deprecated:true},extension:{type:"sap.ui.core.Control",multiple:true,singularName:"extension"},columns:{type:"sap.ui.table.Column",multiple:true,singularName:"column",bindable:"bindable"},rows:{type:"sap.ui.table.Row",multiple:true,singularName:"row",bindable:"bindable"},noData:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},rowActionTemplate:{type:"sap.ui.table.RowAction",multiple:false},rowSettingsTemplate:{type:"sap.ui.table.RowSettings",multiple:false}},associations:{groupBy:{type:"sap.ui.table.Column",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{rowSelectionChange:{parameters:{rowIndex:{type:"int"},rowContext:{type:"object"},rowIndices:{type:"int[]"},selectAll:{type:"boolean"},userInteraction:{type:"boolean"}}},columnSelect:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},columnResize:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},width:{type:"sap.ui.core.CSSSize"}}},columnMove:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},newPos:{type:"int"}}},sort:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},sortOrder:{type:"sap.ui.table.SortOrder"},columnAdded:{type:"boolean"}}},filter:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},value:{type:"string"}}},group:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},columnVisibility:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},visible:{type:"boolean"}}},cellClick:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},cellDomRef:{type:"Object"},rowIndex:{type:"int"},columnIndex:{type:"int"},columnId:{type:"string"},rowBindingContext:{type:"sap.ui.model.Context"}}},cellContextmenu:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},cellDomRef:{type:"Object"},rowIndex:{type:"int"},columnIndex:{type:"int"},columnId:{type:"string"},rowBindingContext:{type:"sap.ui.model.Context"}}},columnFreeze:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},customFilter:{column:{type:"sap.ui.table.Column"},value:{type:"string"}},firstVisibleRowChanged:{firstVisibleRow:{type:"int"}},busyStateChanged:{busy:{type:"boolean"}}},designTime:true}});I.insertFontFaceStyle();v.prototype.init=function(){this._iBaseFontSize=parseFloat(q("body").css("font-size"))||16;this._oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.table");this._bRtlMode=sap.ui.getCore().getConfiguration().getRTL();this._attachExtensions();this._bBindingLengthChanged=false;this._bRowAggregationInvalid=true;this._mTimeouts={};this._bHideStandardTooltips=false;this._lastCalledUpdateRows=0;this._iBindingTimerDelay=50;this._iMaxScrollbarHeight=1000000;this._aRowHeights=[];this._iRowHeightsDelta=0;this._iRenderedFirstVisibleRow=0;this._aSortedColumns=[];var a=this;this._performUpdateRows=function(b){if(!a.bIsDestroyed){a._lastCalledUpdateRows=Date.now();a._updateBindingContexts();if(!a._bInvalid){a._updateTableContent();a._getAccExtension().updateAccForCurrentCell(false);a._updateSelection();a._collectTableSizes();a._aRowHeights=a._collectRowHeights(false);a._updateRowHeights(a._collectRowHeights(true),true);a._updateRowHeights(a._aRowHeights,false);if(T.isVariableRowHeightEnabled(a)){a._iRowHeightsDelta=this._getRowHeightsDelta(a._aRowHeights);a._iRenderedFirstVisibleRow=this.getFirstVisibleRow();}if(a._bBindingLengthChanged){a._updateVSbScrollTop();}a._toggleVSb();if(T.isVariableRowHeightEnabled(a)){var i=0;var l=a._getScrollExtension().getVerticalScrollbar();if(l){i=l.scrollTop;}a._adjustTablePosition(i,a._aRowHeights);}}a._mTimeouts.bindingTimer=undefined;a._fireRowsUpdated(b);}a._bBindingLengthChanged=false;};this._initSelectionModel(f.MULTI_SELECTION);this._aTableHeaders=[];this._aIdxCols2Cells=[];this._bInheritEditableToControls=false;this._bAllowColumnHeaderTextSelection=false;this._iPendingRequests=0;this._bPendingRequest=false;this._iTableRowContentHeight=0;this._bFirstRendering=true;this._bInvalid=true;this._bIsScrollVertical=null;};v.prototype._attachExtensions=function(){if(this._bExtensionsInitialized){return;}m.enrich(this,p);m.enrich(this,r);m.enrich(this,o);m.enrich(this,n);this._bExtensionsInitialized=true;};v.prototype.exit=function(){this._bExitCalled=true;this.invalidateRowsAggregation();this._detachExtensions();if(this._dataReceivedHandlerId!=null){q.sap.clearDelayedCall(this._dataReceivedHandlerId);delete this._dataReceivedHandlerId;}this._cleanUpTimers();this._detachEvents();if(this._oSelection){this._oSelection.destroy();}delete this._aTableHeaders;};v.prototype._detachExtensions=function(){m.cleanup(this);};v.prototype.onThemeChanged=function(){if(this.getDomRef()){this.invalidate();}};v.prototype.onlocalizationChanged=function(a){var b=a.changes||{};var i=b.hasOwnProperty("rtl");var l=b.hasOwnProperty("language");if(i||l){this._adaptLocalization(i,l);this.invalidate();}};v.prototype._adaptLocalization=function(b,l){if(b){this._bRtlMode=sap.ui.getCore().getConfiguration().getRTL();}if(l){var a=this.getRows();var i;this._oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.table");var w;for(i=0;i<a.length;i++){w=a[i].getAggregation("_rowAction");if(w){w._oResBundle=this._oResBundle;}}var x;for(i=0;i<a.length;i++){x=a[i].getAggregation("_settings");if(x){x._oResBundle=this._oResBundle;}}T.Menu.cleanupDataCellContextMenu(this);this._invalidateColumnMenus(true);}};v.prototype._collectRowHeights=function(H){var a=this.getDomRef();if(!a){return[];}if(H&&this.getColumnHeaderHeight()){return[];}var b=this._getDefaultRowHeight();var l=H?".sapUiTableColHdrTr":".sapUiTableTr";var w=a.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr"+l);var x=a.querySelectorAll(".sapUiTableCtrlScroll > tbody > tr"+l);var y=this.getRows().length;var z=[];var A=D.browser.chrome&&window.devicePixelRatio!=1;for(var i=0;i<y;i++){var J=w[i]==null?0:w[i].getBoundingClientRect().height;var K=x[i]==null?0:x[i].getBoundingClientRect().height;var L=Math.max(J,K);if(A){var M=b-L;if(M>0&&M<1){z.push(Math.max(L,b-1));continue;}}z.push(Math.max(L,b));}return z;};v.prototype._resetRowHeights=function(){var a=this.getRowHeight();var b="";if(a){b=a+"px";}var l=this.getDomRef();if(l){var w=l.querySelectorAll(".sapUiTableTr");for(var i=0;i<w.length;i++){w[i].style.height=b;}}};v.prototype._resetColumnHeaderHeights=function(){if(this.getColumnHeaderHeight()){return;}var a=this.getDomRef();if(a){var b=a.querySelectorAll(".sapUiTableColHdrTr");for(var i=0;i<b.length;i++){b[i].style.height=null;}}};v.prototype._determineAvailableSpace=function(){var a=this.getDomRef();if(a&&a.parentNode){var b=a.querySelector(".sapUiTableCCnt");if(b){var U=a.scrollHeight-b.clientHeight;var i=0;if(a.parentNode.firstChild!==a){var l=parseFloat(window.getComputedStyle(a.parentNode).paddingTop);if(isNaN(l)){l=0;}i=a.offsetTop-l;}U+=18;return Math.floor(q(a.parentNode).height()-U-i);}}return 0;};v.prototype._collectTableSizes=function(){var a={tableCtrlScrollWidth:0,tableRowHdrScrWidth:0,tableCtrlScrWidth:0,tableHSbScrollLeft:0,tableCtrlFixedWidth:0,tableCntHeight:0,tableCntWidth:0};var b=this.getDomRef();if(!b){return a;}var l=b.querySelector(".sapUiTableCnt");if(l){a.tableCntHeight=l.clientHeight;a.tableCntWidth=l.clientWidth;}var w=b.querySelector(".sapUiTableCtrlScroll:not(.sapUiTableCHT)");if(w){a.tableCtrlScrollWidth=w.clientWidth;}var x=b.querySelector(".sapUiTableRowHdrScr");if(x){a.tableRowHdrScrWidth=x.clientWidth;}var y=b.querySelector(".sapUiTableCtrlScr:not(.sapUiTableCHA)");if(y){a.tableCtrlScrWidth=y.clientWidth;}var H=this._getScrollExtension().getHorizontalScrollbar();if(H){a.tableHSbScrollLeft=H.scrollLeft;}var z=b.querySelector(".sapUiTableCtrlScrFixed:not(.sapUiTableCHA) > .sapUiTableCtrlFixed");if(z){a.tableCtrlFixedWidth=z.clientWidth;}var A=this.getProperty("fixedColumnCount");var J=0;if(A){var K=b.querySelectorAll(".sapUiTableCtrlFirstCol:not(.sapUiTableCHTHR) > th");for(var i=0;i<K.length;i++){var L=parseInt(K[i].getAttribute("data-sap-ui-headcolindex"),10);if(!isNaN(L)&&(L<A)){J+=K[i].getBoundingClientRect().width;}}}if(J>0){var U=a.tableRowHdrScrWidth;var M=this.getDomRef("vsb");if(M){U+=M.offsetWidth;}if(T.hasRowActions(this)){var O=this.getDomRef("sapUiTableRowActionScr");if(O){U+=O.offsetWidth;}}var Q=a.tableCtrlScrollWidth===a.tableCtrlScrWidth;if(!Q){U+=T.Column.getMinColumnWidth();}var W=a.tableCtrlFixedWidth+U<=a.tableCntWidth;var X=false;if(!Q||!W){X=(a.tableCntWidth-U<J);}if(this._bIgnoreFixedColumnCount!==X){this._bIgnoreFixedColumnCount=X;this.invalidate();}}return a;};v.prototype._updateRowHeights=function(b,H){var i=this.getDomRef();if(!i){return;}if(H&&this.getColumnHeaderHeight()){return;}function l(J,K){var L=b[K];if(L){J.style.height=L+"px";}}var w=H?".sapUiTableColHdrTr":".sapUiTableTr";var x=H?[]:i.querySelectorAll(".sapUiTableRowHdr");var y=H?[]:i.querySelectorAll(".sapUiTableRowAction");var z=i.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr"+w);var A=i.querySelectorAll(".sapUiTableCtrlScroll > tbody > tr"+w);var a=[];a.forEach.call(x,l);a.forEach.call(y,l);a.forEach.call(z,l);a.forEach.call(A,l);};v.prototype.onBeforeRendering=function(a){if(a&&a.isMarked("renderRows")){return;}if(this._mTimeouts.bindingTimer){this._updateBindingContexts();}this._cleanUpTimers();this._detachEvents();var b=this.getVisibleRowCountMode();var i=this.getRows();if(b==V.Interactive||b==V.Fixed||(b==V.Auto&&this._iTableRowContentHeight&&i.length==0)){if(this.getBinding("rows")){this._updateRows(this._calculateRowsToDisplay(),T.RowsUpdateReason.Render);}else{var l=this;this._mTimeouts.onBeforeRenderingAdjustRows=this._mTimeouts.onBeforeRenderingAdjustRows||window.setTimeout(function(){l._updateRows(l._calculateRowsToDisplay(),T.RowsUpdateReason.Render);l._mTimeouts.onBeforeRenderingAdjustRows=undefined;},0);}}else if(this._bRowAggregationInvalid&&i.length>0){this._updateRows(i.length,T.RowsUpdateReason.Render);}this._aTableHeaders=[];};v.prototype.onAfterRendering=function(a){var b=a&&a.isMarked("renderRows");if(b){this._getScrollExtension().updateVerticalScrollbarHeight();this._updateVSbRange();}this._bInvalid=false;this._bOnAfterRendering=true;var $=this.$();this._attachEvents();this._initRowDomRefs();var w=this.getColumns();for(var i=0,l=w.length;i<l;i++){if(w[i].getVisible()){w[i]._restoreIcons();}}if(!this._bAllowColumnHeaderTextSelection&&!b){this._disableTextSelection($.find(".sapUiTableColHdrCnt"));}this._bOnAfterRendering=false;this._getKeyboardExtension().invalidateItemNavigation();this._updateTableContent();if(this._bFirstRendering&&this.getVisibleRowCountMode()==V.Auto){this._bFirstRendering=false;Promise.resolve().then(this._updateTableSizes.bind(this,T.RowsUpdateReason.Render,true));}else{this._updateTableSizes(T.RowsUpdateReason.Render,null,b,b&&T.isVariableRowHeightEnabled(this));}if(!b){this._aTableHeaders=this.$().find(".sapUiTableColHdrCnt th");if(this.getBinding("rows")){this._fireRowsUpdated(T.RowsUpdateReason.Render);}}};v.prototype.invalidate=function(){if(!this._ignoreInvalidateOfChildControls){this._bInvalid=true;var a=C.prototype.invalidate.call(this);T.Column.invalidateColumnUtils(this);}return a;};v.prototype._initRowDomRefs=function(){var a=this.getRows();for(var i=0;i<a.length;i++){a[i].initDomRefs();}};v.prototype._updateTableSizes=function(a,b,l,w){var x=this.getDomRef();var y=this;if(this._bInvalid||!x){return;}if(!x.offsetWidth){T.deregisterResizeHandler(this,"");U();return;}this._resetRowHeights();this._resetColumnHeaderHeights();this._aRowHeights=this._collectRowHeights(false);var z=this._collectRowHeights(true);if(T.isVariableRowHeightEnabled(this)){this._iRowHeightsDelta=this._getRowHeightsDelta(this._aRowHeights);}var A=0;if(!l&&this.getVisibleRowCountMode()==V.Auto){A=this._determineAvailableSpace();if(this._handleRowCountModeAuto(A,a)&&!b){return;}}T.deregisterResizeHandler(this,"");function H(W){var X=W.getDomRef();var Y=T.Column.getMinColumnWidth();var Z=[];var _=W.getColumnHeaderVisible();function a1(d1,e1){if(d1<=e1){return Math.max(d1,e1-5,Y)+"px";}return-1;}function b1(e1){var f1=Math.max(e1._minWidth||0,Y,e1.getMinWidth());var g1=e1.getWidth();var h1;var i1;var j1;if(T.isVariableWidth(g1)&&!T.isFixedColumn(W,e1.getIndex())){h1=X.querySelectorAll('th[data-sap-ui-colid="'+e1.getId()+'"]');i1=h1[_?0:1];j1=i1?i1.offsetWidth:null;if(j1!==null){if(j1<=f1){return{headers:h1,newWidth:a1(j1,f1)};}else if(i1&&i1.style.width!=g1){Z.push({col:e1,header:i1,minWidth:f1,headers:h1});return{headers:h1,newWidth:g1};}Z.push({col:e1,header:i1,minWidth:f1,headers:h1});}}return null;}function c1(e1){if(e1){Array.prototype.forEach.call(e1.headers,function(f1){f1.style.width=e1.newWidth;});}}W._getVisibleColumns().map(b1).forEach(c1);if(Z.length){var d1;for(var i=0;i<Z.length;i++){d1=Z[i].header&&Z[i].header.offsetWidth;Z[i].newWidth=a1(d1,Z[i].minWidth);if(parseInt(Z[i].newWidth,10)>=0){c1(Z[i]);}}}}H(this);var J=this._collectTableSizes();if(J.tableCntHeight==0&&J.tableCntWidth==0){T.registerResizeHandler(this,"",this._onTableResize.bind(this),true);return;}this._updateRowHeights(this._aRowHeights,false);this._updateRowHeights(z,true);this._determineVisibleCols(J);if(!l||w){this._setRowContentHeight(A);}this._updateHSb(J);this._updateVSbTop();var $=this.$();if(T.hasRowActions(this)){var K=$.hasClass("sapUiTableRActFlexible");var L=this.getDomRef("dummycolhdr");var M=L?L.clientWidth:0;if(!K&&M>0){var O=J.tableCtrlScrWidth+J.tableRowHdrScrWidth+J.tableCtrlFixedWidth-M;var Q={width:"auto"};Q[this._bRtlMode?"right":"left"]=O;this.$("sapUiTableRowActionScr").css(Q);this.$("rowacthdr").css(Q);$.toggleClass("sapUiTableRActFlexible",true);}else if(K&&M<=0){this.$("sapUiTableRowActionScr").removeAttr("style");this.$("rowacthdr").removeAttr("style");$.toggleClass("sapUiTableRActFlexible",false);}}$.find(".sapUiTableNoOpacity").addBack().removeClass("sapUiTableNoOpacity");function U(){T.registerResizeHandler(y,"",y._onTableResize.bind(y),true);}if($.closest(".sapUiLoSplitter").length){U();}else{Promise.resolve().then(U);}};v.prototype.setShowOverlay=function(b){b=!!b;this.setProperty("showOverlay",b,true);if(this.getDomRef()){var a=document.activeElement;this.$().toggleClass("sapUiTableOverlay",b);this._getAccExtension().updateAriaStateForOverlayAndNoData();this._getKeyboardExtension().updateNoDataAndOverlayFocus(a);}return this;};v.prototype._updateFixedBottomRows=function(){var i=this.getFixedBottomRowCount();var a=this.getDomRef();if(a&&i>0){var $=q(a).find(".sapUiTableFixedPreBottomRow");$.removeClass("sapUiTableFixedPreBottomRow");var b=q(a).find(".sapUiTableFixedFirstBottomRow");b.removeClass("sapUiTableFixedFirstBottomRow");var l=T.getFirstFixedButtomRowIndex(this);var w=this.getRows();var x;if(l>=0&&l<w.length){x=w[l].getDomRefs(true);x.row.addClass("sapUiTableFixedFirstBottomRow",true);}if(l>=1&&l<w.length){x=w[l-1].getDomRefs(true);x.row.addClass("sapUiTableFixedPreBottomRow",true);}}};v.prototype.getFocusInfo=function(){var i=this.$().find(":focus").attr("id");if(i){return{customId:i};}else{return E.prototype.getFocusInfo.apply(this,arguments);}};v.prototype.applyFocusInfo=function(a){if(a&&a.customId){this.$().find("#"+a.customId).focus();}else{E.prototype.getFocusInfo.apply(this,arguments);}return this;};v.prototype.setTitle=function(a){var b=a;if(typeof(a)==="string"||a instanceof String){b=k.TableHelper.createTextView({text:a,width:"100%"});b.addStyleClass("sapUiTableHdrTitle");}this.setAggregation("title",b);return this;};v.prototype.setFooter=function(a){var b=a;if(typeof(a)==="string"||a instanceof String){b=k.TableHelper.createTextView({text:a,width:"100%"});}this.setAggregation("footer",b);return this;};v.prototype.setSelectionMode=function(a){this.clearSelection();if(a===s.Single){this._oSelection.setSelectionMode(f.SINGLE_SELECTION);}else{this._oSelection.setSelectionMode(f.MULTI_SELECTION);}a=T.sanitizeSelectionMode(this,a);this.setProperty("selectionMode",a);return this;};v.prototype._adjustTablePosition=function(i,a){var b=i<this._getVirtualScrollRange();var l=this._getRowCount()>this.getVisibleRowCount();if(b&&this.getFirstVisibleRow()!=this._iRenderedFirstVisibleRow){return;}var w=null;if(b&&l){var x=a[0];var y=this._getScrollingPixelsForRow();var z=i-(this.getFirstVisibleRow()*y);var A=z/y;w=Math.ceil(A*x);if(w>x){w=null;}}else if(this._iRowHeightsDelta>=0){var H=l?i-this._getVirtualScrollRange():i;w=(this._iRowHeightsDelta/this._getRowCorrectionScrollRange())*H;}if(w!=null&&w>-1){this.$().find(".sapUiTableCCnt").scrollTop(w);}};v.prototype.setFirstVisibleRow=function(i,O,b){if(parseInt(i,10)<0){q.sap.log.error("The index of the first visible row must be greater than or equal to 0."+" The value has been set to 0.",this);i=0;}if(this._getRowCount()>0){var M=this._getMaxRowIndex();if(M<i){q.sap.log.warning("The index of the first visible row must be lesser or equal than the scrollable row count minus the visible row count."+" The value has been set to "+M+".",this);i=M;}}var a=this.getFirstVisibleRow()!=i;if(a){this.setProperty("firstVisibleRow",i,true);if(this.getBinding("rows")){var l=O===true?T.RowsUpdateReason.VerticalScroll:T.RowsUpdateReason.FirstVisibleRowChange;this.updateRows(l);if(!O){this._updateVSbScrollTop();}}if(!b){this.fireFirstVisibleRowChanged({firstVisibleRow:i});}}return this;};v.getMetadata().getAggregation("rows")._doesNotRequireFactory=true;v.prototype.bindAggregation=function(a){if(a==="rows"){return this.bindRows.apply(this,[].slice.call(arguments,1));}return C.prototype.bindAggregation.apply(this,arguments);};v.prototype.bindRows=function(b){if(this.getEnableBusyIndicator()){this.setBusy(false);}this._iPendingRequests=0;this._bPendingRequest=false;return C.prototype.bindAggregation.call(this,"rows",v._getSanitizedBindingInfo(arguments));};v.prototype._bindAggregation=function(a,b){if(a==="rows"){v._addBindingListener(b,"change",this._onBindingChange.bind(this));v._addBindingListener(b,"dataRequested",this._onBindingDataRequested.bind(this));v._addBindingListener(b,"dataReceived",this._onBindingDataReceived.bind(this));}E.prototype._bindAggregation.call(this,a,b);var i=this.getBinding("rows");if(a==="rows"&&i!=null){var M=i.getModel();if(M!=null&&M.getDefaultBindingMode()===B.OneTime){q.sap.log.error("The binding mode of the model is set to \"OneTime\"."+" This binding mode is not supported for the \"rows\" aggregation!"+" Scrolling can not be performed.",this);}}this._initSelectionModel(f.MULTI_SELECTION);};v._getSanitizedBindingInfo=function(a){var b;if(a==null||a[0]==null){b=null;}else if(typeof a[0]==="string"){var i=a[0];var l=a[1];var w=a[2];var x=a[3];if(l instanceof g||q.isArray(w)&&w[0]instanceof F){x=w;w=l;l=undefined;}b={path:i,sorter:w,filters:x,template:l};}else{b=a[0];}return b;};v._addBindingListener=function(b,a,H){if(b.events==null){b.events={};}if(b.events[a]==null){b.events[a]=H;}else{var O=b.events[a];b.events[a]=function(){H.apply(this,arguments);O.apply(this,arguments);};}};v.prototype._initSelectionModel=function(a){if(this._oSelection){this._oSelection.detachSelectionChanged(this._onSelectionChanged,this);}this._oSelection=new f(a);this._oSelection.attachSelectionChanged(this._onSelectionChanged,this);return this;};v.prototype._onBindingChange=function(a){var b=typeof(a)==="object"?a.getParameter("reason"):a;if(b==="sort"||b==="filter"){this.clearSelection();this.setFirstVisibleRow(0);}};v.prototype.unbindAggregation=function(a,b){var i=this.getBinding("rows");if(a==="rows"&&this.isBound("rows")){b=true;}var l=E.prototype.unbindAggregation.apply(this,[a,b]);if(a==="rows"&&i){this._restoreAppDefaultsColumnHeaderSortFilter();this._invalidateColumnMenus();this._updateBindingLength();this.updateRows(T.RowsUpdateReason.Unbind);}return l;};v.prototype.setVisibleRowCount=function(i){if(i!=null&&!isFinite(i)){return this;}var a=this.getVisibleRowCountMode();if(a==V.Auto){q.sap.log.error("VisibleRowCount will be ignored since VisibleRowCountMode is set to Auto",this);return this;}var b=this.getFixedRowCount()+this.getFixedBottomRowCount();if(i<=b&&b>0){q.sap.log.error("Table: "+this.getId()+" visibleRowCount('"+i+"') must be bigger than number of fixed rows('"+(this.getFixedRowCount()+this.getFixedBottomRowCount())+"')",this);return this;}i=this.validateProperty("visibleRowCount",i);if(this.getBinding("rows")&&this.getBinding("rows").getLength()<=i){this.setProperty("firstVisibleRow",0);}this.setProperty("visibleRowCount",i);this._setRowContentHeight(i*this._getDefaultRowHeight());return this;};v.prototype.setRowHeight=function(i){this.setProperty("rowHeight",i);this._iTableRowContentHeight=undefined;return this;};v.prototype.setTooltip=function(a){q.sap.log.warning("The aggregation tooltip is not supported for sap.ui.table.Table");return this.setAggregation("tooltip",a,true);};v.prototype.setNavigationMode=function(){this.setProperty("navigationMode",N.Scrollbar,true);q.sap.log.error("The navigationMode property is deprecated and must not be used anymore. Your setting was defaulted to 'Scrollbar'",this);};v.prototype._getFixedBottomRowContexts=function(i,b){var a=this.getBinding("rows");var l=[];if(!a){return l;}i=i||this.getFixedBottomRowCount();b=b||a.getLength();var w=this.getVisibleRowCount();if(i>0&&(w-i)<b){l=this._getContexts(b-i,i,1);}return l;};v.prototype._getFixedRowContexts=function(i){i=i||this.getFixedRowCount();if(i>0){return this._getContexts(0,i);}else{return[];}};v.prototype._getContexts=function(i,l,a){var b=this.getBinding("rows");if(b){return b.getContexts(i,l,a);}else{return[];}};v.prototype._getRowContexts=function(a,b,l){var w=this.getBinding("rows");var x=a==null?this.getRows().length:a;if(!w||x<=0){return[];}b=b===true;l=l===true;var y=this.getFirstVisibleRow();var z=this.getFixedRowCount();var A=this.getFixedBottomRowCount();var H=0;var J;var K=[];var L;var M=x-A;var O=0;var Q=M;var U=this.getThreshold();U=U?Math.max(x,U):0;var W=y;var X=function($,_,W){for(var i=0;i<_.length;i++){$[W+i]=_[i];}};if(z>0&&y>0){W=y+z;M-=z;O=z;L=this._getFixedRowContexts(z);H+=L.length;K=K.concat(L);}L=this._getContexts(W,M,U);var Y=this._updateBindingLength(b);J=L.length<Math.min(M,Y-A);H+=L.length;X(K,L,O);Q=Math.min(Q,Math.max(Y-A,0));if(A>0){L=this._getFixedBottomRowContexts(A,Y);H+=L.length;X(K,L,Q);}if(J&&!l){if(Y>0){var Z=this._getMaxRowIndex();if(Z<y){y=Z;this.setProperty("firstVisibleRow",y,true);K=this._getRowContexts(x,b,true);H=K.length;}}}return K;};v.prototype._updateBindingLength=function(b){var a=this.getBinding("rows");var i=0;b=b===true;if(a){i=a.getLength();}if(i!=this._iBindingLength){this._iBindingLength=i;this._bBindingLengthChanged=true;if(!b){this._updateFixedBottomRows();this._toggleVSb();this._updateVSbRange();var l=T.isInstanceOf(a,"sap/ui/model/ClientListBinding")||T.isInstanceOf(a,"sap/ui/model/ClientTreeBinding");if(a==null||l){this._updateNoData();}}}return i;};v.prototype.refreshRows=function(a){var b=this.getBinding("rows");if(!b){q.sap.log.error("RefreshRows must not be called without a binding",this);return;}var i=this;var l=typeof(a)==="object"?a.getParameter("reason"):a;var w=this.getVisibleRowCountMode();if((this.bOutput&&w===V.Auto)||w!==V.Auto){var x=this._calculateRowsToDisplay();if(this.bOutput){b.attachEventOnce("dataRequested",function(){if(i._mTimeouts.refreshRowsAdjustRows){window.clearTimeout(i._mTimeouts.refreshRowsAdjustRows);}i._mTimeouts.refreshRowsAdjustRows=window.setTimeout(function(){i._updateRows(x,l,false);},0);});}if(l===d.Filter||l===d.Sort){this.setFirstVisibleRow(0);}this._updateBindingContexts(x,true);}};v.prototype.updateRows=function(a){if(this._bExitCalled){return;}var b=this.getVisibleRowCountMode();if((this.getRows().length<=0||this._bRowAggregationInvalid)&&((b==V.Auto&&this.bOutput)||b!=V.Auto)){if(this._iTableRowContentHeight){this._updateRows(this._calculateRowsToDisplay(),a);}}if(!this.bIsDestroyed){var i=(a===d.Change||(!this._mTimeouts.bindingTimer&&Date.now()-this._lastCalledUpdateRows>this._iBindingTimerDelay)||a===T.RowsUpdateReason.Unbind?0:this._iBindingTimerDelay);var l=this;if(i===0&&a){Promise.resolve().then(function(){l._performUpdateRows(a);});}else{this._mTimeouts.bindingTimer=this._mTimeouts.bindingTimer||window.setTimeout(function(){l._performUpdateRows(a);},i);}}};v.prototype.insertRow=function(){q.sap.log.error("The control manages the rows aggregation. The method \"insertRow\" cannot be used programmatically!",this);};v.prototype.addRow=function(){q.sap.log.error("The control manages the rows aggregation. The method \"addRow\" cannot be used programmatically!",this);};v.prototype.removeRow=function(){q.sap.log.error("The control manages the rows aggregation. The method \"removeRow\" cannot be used programmatically!",this);};v.prototype.removeAllRows=function(){q.sap.log.error("The control manages the rows aggregation. The method \"removeAllRows\" cannot be used programmatically!",this);};v.prototype.destroyRows=function(){q.sap.log.error("The control manages the rows aggregation. The method \"destroyRows\" cannot be used programmatically!",this);};v.prototype.autoResizeColumn=function(i){this._getPointerExtension().doAutoResizeColumn(i);};v.prototype._attachEvents=function(){var $=this.$();$.find(".sapUiTableColHdrScr").scroll(q.proxy(this._oncolscroll,this));$.find(".sapUiTableCtrlScr").scroll(q.proxy(this._oncntscroll,this));$.find(".sapUiTableCtrlScrFixed").scroll(q.proxy(this._oncntscroll,this));$.find(".sapUiTableCtrlScrFixed").on("scroll.sapUiTablePreventFixedAreaScroll",function(a){a.target.scrollLeft=0;});if(T.isVariableRowHeightEnabled(this)){var i=$.find(".sapUiTableCtrlScr, .sapUiTableCtrlScrFixed, .sapUiTableRowHdrScr");i.on("scroll.sapUiTableSyncScrollPosition",function(a){i.scrollTop(a.target.scrollTop);});}if(sap.ui.getCore().getConfiguration().getAnimation()){q(document.body).on("webkitTransitionEnd transitionend",function(a){if(q(a.target).has($).length>0){this._iDefaultRowHeight=undefined;this._updateTableSizes(T.RowsUpdateReason.Animation);}}.bind(this));}m.attachEvents(this);};v.prototype._detachEvents=function(){q(document.body).off('webkitTransitionEnd transitionend');T.deregisterResizeHandler(this);m.detachEvents(this);};v.prototype._getScrollTargets=function(){var $=q(this.getDomRef("sapUiTableCtrlScr"));var a=q(this.getDomRef("rsz"));var b=q(this.getDomRef("sapUiTableCtrlScrFixed"));var i=q(this.getDomRef("sapUiTableRowHdrScr"));return $.add(b).add(i).add(a);};v.prototype._cleanUpTimers=function(){for(var K in this._mTimeouts){if(this._mTimeouts[K]){window.clearTimeout(this._mTimeouts[K]);delete this._mTimeouts[K];}}};v.prototype._updateHSb=function(a){var $=this.$();var i=a.tableCtrlScrollWidth;if(!!D.browser.safari){i=Math.max(i,this._getColumnsWidth(this.getFixedColumnCount()));}if(i>a.tableCtrlScrWidth){if(!this._getScrollExtension().isHorizontalScrollbarVisible()){$.addClass("sapUiTableHScr");if(!!D.browser.safari){var b=$.find(".sapUiTableCtrlScroll, .sapUiTableColHdrScr > .sapUiTableColHdr");b.outerWidth(i);}}var l=a.tableCtrlFixedWidth;if($.find(".sapUiTableRowHdrScr").length>0){l+=a.tableRowHdrScrWidth;}if(this.getRows().length>0){var w=$.find(".sapUiTableHSb");if(this._bRtlMode){w.css('margin-right',l+'px');}else{w.css('margin-left',l+'px');}}var H=this.getDomRef("hsb-content");if(H){H.style.width=i+"px";}}else{if(this._getScrollExtension().isHorizontalScrollbarVisible()){$.removeClass("sapUiTableHScr");if(!!D.browser.safari){$.find(".sapUiTableCtrlScroll, .sapUiTableColHdr").css("width","");}}}};v.prototype._updateVSbTop=function(){var a=this._getScrollExtension().getVerticalScrollbar();if(!a){return;}var b=this.getDomRef("tableCCnt");if(b){var i=b.offsetTop;var l=this.getDomRef("vsb-bg");l.style.top=i+"px";var w=this.getFixedRowCount();if(w>0){i+=this._iVsbTop;}a.style.top=i+"px";}};v.prototype._updateVSbScrollTop=function(i){var a=this._getScrollExtension();var b=a.getVerticalScrollbar();if(!b){return;}if(!this._isVSbRequired()){return;}if(i===undefined){i=Math.ceil(this.getFirstVisibleRow()*this._getScrollingPixelsForRow());}a._iVerticalScrollPosition=null;window.requestAnimationFrame(function(){b.scrollTop=i;});};v.prototype._updateVSbRange=function(){var a=this._getScrollExtension().getVerticalScrollbar();if(!a){return;}q(this.getDomRef("vsb-content")).height(this._getTotalScrollRange());};v.prototype._toggleVSb=function(){var a=this.getDomRef();if(a){if(this._isVSbRequired()){if(!a.classList.contains("sapUiTableVScr")){a.classList.add("sapUiTableVScr");this._updateVSbScrollTop(0);}}else{a.classList.remove("sapUiTableVScr");}}};v.prototype._isVSbRequired=function(){if(this._iRowHeightsDelta>0||(this.getBinding("rows")&&this._iBindingLength>this.getVisibleRowCount())){return true;}return false;};v.prototype._updateBindingContexts=function(i,b){var a=this.getBinding("rows");var l;b=b===true;if(a!=null){l=this._getRowContexts(i,b);}if(!b){this._resetRowHeights();var w=this.getRows(),x=this.mBindingInfos["rows"],M=x&&x.model;for(var y=w.length-1;y>=0;y--){var z=l?l[y]:undefined;var A=w[y];if(A){A.setRowBindingContext(z,M,a);}}}};v.prototype._updateNoData=function(){if(!this.getDomRef()){return;}var a=document.activeElement;this.$().toggleClass("sapUiTableEmpty",T.isNoDataVisible(this));this._getAccExtension().updateAriaStateForOverlayAndNoData();this._getKeyboardExtension().updateNoDataAndOverlayFocus(a);};v.prototype._determineVisibleCols=function(a){var b=[];this.getColumns().forEach(function(l,i){if(l.shouldRender()){b.push(i);}});};v.prototype.removeColumn=function(a,b){var i=this.removeAggregation('columns',a,b);if(typeof a==="number"&&a>-1){a=this.getColumns()[a];}var l=q.inArray(a,this._aSortedColumns);if(!this._bReorderInProcess&&l>=0){this._aSortedColumns.splice(l,1);}this.invalidateRowsAggregation();return i;};v.prototype.removeAllColumns=function(){var a=this.removeAllAggregation('columns');this._aSortedColumns=[];this.invalidateRowsAggregation();return a;};v.prototype.destroyColumns=function(){var a=this.destroyAggregation('columns');this._aSortedColumns=[];this.invalidateRowsAggregation();return a;};v.prototype.addColumn=function(a,b){this.addAggregation('columns',a,b);this.invalidateRowsAggregation();return this;};v.prototype.insertColumn=function(a,i,b){this.insertAggregation('columns',a,i,b);this.invalidateRowsAggregation();return this;};v.prototype._getRowCount=function(){return this._iBindingLength;};v.prototype._getSelectableRowCount=function(){var b=this.getBinding("rows");return this._iBindingLength||(b?b.getLength():0);};v.prototype._getFirstVisibleRowByScrollTop=function(i){if(T.isVariableRowHeightEnabled(this)&&this._getRowCount()<this.getVisibleRowCount()){return 0;}else{var a=Math.floor(i/this._getScrollingPixelsForRow());var b=this._getVirtualScrollRange()-i;var l=b<1;return l?this._getMaxRowIndex():a;}};v.prototype._getScrollingPixelsForRow=function(){return this._getVirtualScrollRange()/Math.max(1,this._getMaxRowIndex());};v.prototype._getVSbHeight=function(){return this._getScrollableRowCount()*this._getDefaultRowHeight();};v.prototype._getScrollableRowCount=function(){return Math.max(1,this.getVisibleRowCount()-this.getFixedRowCount()-this.getFixedBottomRowCount());};v.prototype._getRowHeightsDelta=function(i){var l=this._getDefaultRowHeight()*this.getVisibleRowCount();if(this.getVisibleRowCount()>=this._getRowCount()){i=i.slice(0,this._getRowCount());}var w=i.reduce(function(a,b){return a+b;},0)-l;if(w>0){w=Math.ceil(w);}return Math.max(0,w);};v.prototype._getTotalScrollRange=function(){var i=Math.max(this._getRowCount(),this.getVisibleRowCount()+1);var a=this._getDefaultRowHeight()*i;return Math.min(this._iMaxScrollbarHeight,a);};v.prototype._getVirtualScrollRange=function(){var M=this._getTotalScrollRange()-this._getVSbHeight();if(T.isVariableRowHeightEnabled(this)){M=M-this._iRowHeightsDelta;}return Math.max(1,M);};v.prototype._getRowCorrectionScrollRange=function(){var i=this._getTotalScrollRange()-this._getVSbHeight();if(this._getRowCount()>this.getVisibleRowCount()){i-=this._getVirtualScrollRange();}return Math.max(1,i);};v.prototype._getMaxRowIndex=function(){var M=this._getRowCount()-this.getVisibleRowCount();if(T.isVariableRowHeightEnabled(this)){M-=1;}return Math.max(0,M);};v.prototype._getVisibleColumns=function(){var a=[];var b=this.getColumns();for(var i=0,l=b.length;i<l;i++){if(b[i].shouldRender()){a.push(b[i]);}}return a;};v.prototype._getColumnsWidth=function(a,b){var w=this.getColumns();var x=0;if(a!==0&&!a){a=0;}if(b!==0&&!b){b=w.length;}for(var i=a,l=b;i<l;i++){if(w[i]&&w[i].shouldRender()){x+=this._CSSSizeToPixel(w[i].getWidth());}}return x;};v.prototype._CSSSizeToPixel=function(a,b){var i=T.Column.getMinColumnWidth();if(a){if(q.sap.endsWith(a,"px")){i=parseInt(a,10);}else if(q.sap.endsWith(a,"em")||q.sap.endsWith(a,"rem")){i=Math.ceil(parseFloat(a)*this._getBaseFontSize());}}if(b){return i+"px";}else{return parseInt(i,10);}};v.prototype._getBaseFontSize=function(){return this._iBaseFontSize;};v.prototype._onTableResize=function(){if(this._bInvalid||!this.getDomRef()){return;}this._updateTableSizes(T.RowsUpdateReason.Resize);};v.prototype._handleRowCountModeAuto=function(i,a){var b=this.getBinding("rows");if(b&&this.getRows().length>0){return this._executeAdjustRows(a,i);}else{var l=!this._mTimeouts.handleRowCountModeAutoAdjustRows;var w=this.getBusyIndicatorDelay();var x=this.getEnableBusyIndicator();var y=this;if(b&&x){this.setBusyIndicatorDelay(0);this.setBusy(true);}if(i){this._setRowContentHeight(i);}this._mTimeouts.handleRowCountModeAutoAdjustRows=this._mTimeouts.handleRowCountModeAutoAdjustRows||window.setTimeout(function(){if(!y._executeAdjustRows(a)){y._updateTableSizes(a,false,true);}delete y._mTimeouts.handleRowCountModeAutoAdjustRows;if(b&&x){y.setBusyIndicatorDelay(w);y.setBusy(false);}},0);return l;}};v.prototype._executeAdjustRows=function(a,i){i=i||this._determineAvailableSpace();var b=this._calculateRowsToDisplay(i);if(b==this._determineMinAutoRowCount()){this.$().height("auto");}else{this.$().height("0px");}return this._updateRows(b,a);};v.prototype._disableTextSelection=function(a){q(a||document.body).attr("unselectable","on").css({"-moz-user-select":"none","-webkit-user-select":"none","user-select":"none"}).bind("selectstart",function(b){b.preventDefault();return false;});};v.prototype._enableTextSelection=function(a){q(a||document.body).attr("unselectable","off").css({"-moz-user-select":"","-webkit-user-select":"","user-select":""}).unbind("selectstart");};v.prototype._clearTextSelection=function(){if(window.getSelection){if(window.getSelection().empty){window.getSelection().empty();}else if(window.getSelection().removeAllRanges){window.getSelection().removeAllRanges();}}else if(document.selection&&document.selection.empty){try{document.selection.empty();}catch(a){}}};v.prototype._findAndfireCellEvent=function(a,b,i){var $=q(b.target);var l=$.closest("td.sapUiTableTd");var w=l.attr("id");var M=/.*-row(\d*)-col(\d*)/i.exec(w);var x=false;if(M){var y=M[1];var z=M[2];var A=this.getRows()[y];var H=A&&A.getCells()[z];var J=A&&A.getIndex();var K=H.data("sap-ui-colid");var L;if(this.getBindingInfo("rows")){L=A.getBindingContext(this.getBindingInfo("rows").model);}var O={rowIndex:J,columnIndex:z,columnId:K,cellControl:H,rowBindingContext:L,cellDomRef:l.get(0)};x=!a.call(this,O);if(!x&&typeof i==="function"){O.cellDomRef=l[0];x=i.call(this,O);}}return x;};v.prototype.getFocusDomRef=function(){this._getKeyboardExtension().initItemNavigation();var a=T.getFocusedItemInfo(this);if(a!==null){return a.domRef||C.prototype.getFocusDomRef.apply(this,arguments);}return null;};v.prototype._isRowSelectable=function(i){return i>=0&&i<this._getRowCount();};v.prototype.pushSortedColumn=function(a,A){if(!A){this._aSortedColumns=[];}this._aSortedColumns.push(a);};v.prototype.getSortedColumns=function(){return this._aSortedColumns.slice();};v.prototype.sort=function(a,b,A){if(!a){for(var i=0;i<this._aSortedColumns.length;i++){this._aSortedColumns[i].setSorted(false);}var l=this.getBinding("rows");if(l){l.sort();}this._aSortedColumns=[];}if(q.inArray(a,this.getColumns())>=0){a.sort(b===u.Descending,A);}};v.prototype.filter=function(a,b){if(q.inArray(a,this.getColumns())>=0){a.filter(b);}};v.prototype._updateSelection=function(){var a=this.getSelectionMode();if(a===s.None){return;}var b=this._getAccExtension().getAriaTextsForSelectionMode(true);var l=T.isRowSelectionAllowed(this);var w=this.getRows();for(var i=0;i<w.length;i++){var x=w[i];x._updateSelection(this,b,l);}this.setProperty("selectedIndex",this.getSelectedIndex(),true);if(T.hasSelectAll(this)){var $=this.$("selall");var A=T.areAllRowsSelected(this);$.toggleClass("sapUiTableSelAll",!A);this._getAccExtension().setSelectAllState(A);if(this._getShowStandardTooltips()){var y=A?"TBL_DESELECT_ALL":"TBL_SELECT_ALL";$.attr('title',this._oResBundle.getText(y));}}};v.prototype._getShowStandardTooltips=function(){return!this._bHideStandardTooltips;};v.prototype._onSelectionChanged=function(a){var b=a.getParameter("rowIndices");var i=a.getParameter("selectAll");var l=this._iSourceRowIndex!==undefined?this._iSourceRowIndex:this.getSelectedIndex();this._updateSelection();this.fireRowSelectionChange({rowIndex:l,rowContext:this.getContextByIndex(l),rowIndices:b,selectAll:i,userInteraction:this._iSourceRowIndex!==undefined});};v.prototype.getContextByIndex=function(i){var b=this.getBinding("rows");return i>=0&&b?b.getContexts(i,1)[0]:null;};v.prototype.getSelectedIndex=function(){return this._oSelection.getLeadSelectedIndex();};v.prototype.setSelectedIndex=function(i){if(i===-1){this.clearSelection();}else{this._oSelection.setSelectionInterval(i,i);}return this;};v.prototype.clearSelection=function(){this._oSelection.clearSelection();return this;};v.prototype.selectAll=function(){if(!T.hasSelectAll(this)){return this;}var b=this.getBinding("rows");if(b){this._oSelection.selectAll((b.getLength()||0)-1);}return this;};v.prototype.getSelectedIndices=function(){return this._oSelection.getSelectedIndices();};v.prototype.addSelectionInterval=function(i,a){if(this.getSelectionMode()===k.SelectionMode.None){return this;}this._oSelection.addSelectionInterval(i,a);return this;};v.prototype.setSelectionInterval=function(i,a){if(this.getSelectionMode()===k.SelectionMode.None){return this;}this._oSelection.setSelectionInterval(i,a);return this;};v.prototype.removeSelectionInterval=function(i,a){this._oSelection.removeSelectionInterval(i,a);return this;};v.prototype.isIndexSelected=function(i){return this._oSelection.isSelectedIndex(i);};v.prototype.setGroupBy=function(a){var b=a;var O=sap.ui.getCore().byId(this.getGroupBy());if(typeof b==="string"){b=sap.ui.getCore().byId(b);}var i=false;if(b!=null&&b instanceof h&&b!==O){if(q.inArray(b,this.getColumns())===-1){throw new Error("Column has to be part of the columns aggregation!");}var l=this.fireGroup({column:b,groupedColumns:[b.getId()],type:G.group});if(O!=null){O.setGrouped(false);i=true;}if(l&&this.getEnableGrouping()){b.setGrouped(true);}}if(b==null||i){if(O!=null){O.setGrouped(false);}T.Grouping.resetExperimentalGrouping(this);}return this.setAssociation("groupBy",b);};v.prototype.getBinding=function(a){T.Grouping.setupExperimentalGrouping(this);return E.prototype.getBinding.call(this,[a||"rows"]);};v.prototype.setEnableGrouping=function(b){var a=sap.ui.getCore().byId(this.getGroupBy());this.setProperty("enableGrouping",b);if(a!=null){a.setGrouped(b);}T.Grouping.resetExperimentalGrouping(this);this._invalidateColumnMenus();return this;};v.prototype.setEnableCustomFilter=function(b){this.setProperty("enableCustomFilter",b);this._invalidateColumnMenus();return this;};v.prototype.setEnableColumnFreeze=function(b){this.setProperty("enableColumnFreeze",b);this._invalidateColumnMenus();return this;};v.prototype.setShowColumnVisibilityMenu=function(b){this.setProperty("showColumnVisibilityMenu",b);this._invalidateColumnMenus();return this;};v.prototype.getFixedColumnCount=function(){if(this._bIgnoreFixedColumnCount){return 0;}else{return this.getProperty("fixedColumnCount");}};v.prototype.setFixedColumnCount=function(a,b){var l=this.getColumns();var w,i;for(i=a-1;i>=0;i--){w=l[i];if(w&&w.getVisible()){a=Math.max(a,w.getIndex()+T.Column.getHeaderSpan(w));break;}}var $=this.$().find(".sapUiTableCtrlFirstCol > th");for(i=a-1;i>=0;i--){w=l[i];if(w&&T.isVariableWidth(w.getWidth())){w._iFixWidth=$.filter("[data-sap-ui-headcolindex='"+w.getIndex()+"']").width();}}this.setProperty("fixedColumnCount",a,b);this._collectTableSizes();this._invalidateColumnMenus();return this;};v.prototype.setFixedRowCount=function(i){if(!(parseInt(i,10)>=0)){q.sap.log.error("Number of fixed rows must be greater or equal 0",this);return this;}if((i+this.getFixedBottomRowCount())<this.getVisibleRowCount()){this.setProperty("fixedRowCount",i);this._updateBindingContexts();}else{q.sap.log.error("Table '"+this.getId()+"' fixed rows('"+(i+this.getFixedBottomRowCount())+"') must be smaller than numberOfVisibleRows('"+this.getVisibleRowCount()+"')",this);}return this;};v.prototype.setFixedBottomRowCount=function(i){if(!(parseInt(i,10)>=0)){q.sap.log.error("Number of fixed bottom rows must be greater or equal 0",this);return this;}if((i+this.getFixedRowCount())<this.getVisibleRowCount()){this.setProperty("fixedBottomRowCount",i);this._updateBindingContexts();}else{q.sap.log.error("Table '"+this.getId()+"' fixed rows('"+(i+this.getFixedRowCount())+"') must be smaller than numberOfVisibleRows('"+this.getVisibleRowCount()+"')",this);}return this;};v.prototype.setThreshold=function(i){this.setProperty("threshold",i,true);};v.prototype._invalidateColumnMenus=function(U){var a=this.getColumns();for(var i=0,l=a.length;i<l;i++){a[i].invalidateMenu(U);}};v.prototype._isTouchEvent=function(a){return a!=null&&a.originalEvent!=null&&a.originalEvent.touches!=null;};v.prototype._getRowClone=function(a){var b=new j(this.getId()+"-rows"+"-row"+a);var w=this.getColumns();for(var i=0,l=w.length;i<l;i++){if(w[i].getVisible()){var x=w[i].getTemplateClone(i);if(x){b.addCell(x);}}}if(T.hasRowActions(this)){var y=this.getRowActionTemplate().clone();y._setFixedLayout(true);y._setCount(this.getRowActionCount());y._setIconLabel(this.getId()+"-rowacthdr");b.setAggregation("_rowAction",y,true);}var z=this.getRowSettingsTemplate();if(z){var A=z.clone();b.setAggregation("_settings",A,true);}return b;};v.prototype.invalidateRowsAggregation=function(){this._bRowAggregationInvalid=true;};v.prototype._updateRows=function(a,b,U){if(isNaN(a)){return false;}if(U==null){U=true;}if(T.isVariableRowHeightEnabled(this)){a=a+1;}var i;var l=this.getRows();if(this._bRowAggregationInvalid&&l.length>0){this.destroyAggregation("rows",true);l=[];}if(a==l.length){return false;}for(i=l.length-1;i>=a;i--){this.removeAggregation("rows",i,true).destroy();}if(T.isVariableRowHeightEnabled(this)){this.setProperty("visibleRowCount",a-1,true);}else{this.setProperty("visibleRowCount",a,true);}this._ignoreInvalidateOfChildControls=true;var w;var x;var M;var y=this.getBinding("rows");if(U){x=this.getBindingInfo("rows");M=x&&x.model;w=this._getRowContexts(a);for(i=0;i<l.length;i++){l[i].setRowBindingContext(w[i],M,y);}}if(l.length<a){for(i=l.length;i<a;i++){var z=this._getRowClone(i);if(U){z.setRowBindingContext(w[i],M,y);}this.addAggregation("rows",z,true);this._bRowAggregationInvalid=false;if(U){z._updateTableCells(w[i]);}}}this._ignoreInvalidateOfChildControls=false;var A=U&&w.length>0;return this._renderRows(b,A);};v.prototype._renderRows=function(a,b){var i=false;b=b===true;if(!this._bInvalid){var l=this.getDomRef("tableCCnt");if(this.getRows().length===0||!l){return false;}this._detachEvents();if(this.getVisibleRowCountMode()===V.Auto){var w=this.getDomRef();if(w){w.style.height="0px";}}var x=q.Event("BeforeRendering");x.setMarked("renderRows");x.srcControl=this;this._handleEvent(x);var y=new sap.ui.getCore().createRenderManager(),z=this.getRenderer();z.renderTableCCnt(y,this);y.flush(l,false,false);y.destroy();x=q.Event("AfterRendering");x.setMarked("renderRows");x.srcControl=this;this._handleEvent(x);i=true;}if(b&&!this._bInvalid&&this.getBinding("rows")){var A=this;if(this._mTimeouts._rowsUpdated){window.clearTimeout(this._mTimeouts._rowsUpdated);}this._mTimeouts._rowsUpdated=window.setTimeout(function(){A._fireRowsUpdated(a);},0);}return i;};v.prototype._getDefaultRowHeight=function(){var i=this.getRowHeight();if(i>0){return i;}else{var a=T.getContentDensity(this);return T.DEFAULT_ROW_HEIGHT[a];}};v.prototype._setRowContentHeight=function(H){H=H||0;var a=this.getVisibleRowCountMode();var i=this.getVisibleRowCount();var b=this._getDefaultRowHeight();var M=this.getMinAutoRowCount();var l;if(a==V.Interactive||a==V.Fixed){if(this._iTableRowContentHeight&&a==V.Interactive){l=M*b;if(!H){H=this._iTableRowContentHeight;}}else{l=i*b;H=l;}}else if(a==V.Auto){l=M*b;}var w=Math.max(H,l);if((a==V.Fixed&&this.getRows().length==0)||a!=V.Fixed){this._iTableRowContentHeight=Math.floor(w/b)*b;}else{this._iTableRowContentHeight=undefined;}if(T.isVariableRowHeightEnabled(this)){q(this.getDomRef("tableCCnt")).css("height",b*this.getVisibleRowCount()+"px");}else{if((a==V.Fixed||a==V.Interactive)&&this.getRows().length>0){q(this.getDomRef("tableCtrlCnt")).css("height","auto");}else{q(this.getDomRef("tableCtrlCnt")).css("height",this._iTableRowContentHeight+"px");}}this._toggleVSb();};v.prototype._determineMinAutoRowCount=function(){var i=this.getVisibleRowCount();var M=this.getMinAutoRowCount();var a=M||i||5;if(this.getVisibleRowCountMode()==V.Interactive&&!this.bOutput){a=i||M||5;}return a;};v.prototype._calculateRowsToDisplay=function(i){i=i||this._iTableRowContentHeight;var a=this.getVisibleRowCountMode();var b=0;if(a==V.Fixed){b=this.getVisibleRowCount()||0;}else if(a==V.Interactive||a==V.Auto){var M=this._determineMinAutoRowCount();var l=this._getDefaultRowHeight();if(!l||!i){b=M;}else{var A=Math.min(i,50000);var w=Math.floor(A/l);b=Math.max((this.getFixedRowCount()+this.getFixedBottomRowCount()+1),Math.max(M,w));}}return Math.max(b,0);};v.prototype.setShowNoData=function(b){this.setProperty('showNoData',b,true);this._updateNoData();return this;};v.prototype.exportData=function(a){var b=sap.ui.requireSync("sap/ui/core/util/Export");a=a||{};if(!a.rows){var w=this.getBinding("rows"),x=this.getBindingInfo("rows");var y=w.aFilters.concat(w.aApplicationFilters);a.rows={path:x.path,model:x.model,sorter:w.aSorters,filters:y,parameters:x.parameters};}if(!a.exportType){var z=sap.ui.requireSync("sap/ui/core/util/ExportTypeCSV");a.exportType=new z();}var M=a.rows.model;if(!M){var A=a.rows.path;var H=A.indexOf(">");if(H>0){M=A.substr(0,H);}}if(!a.columns){a.columns=[];var J=this.getColumns();for(var i=0,l=J.length;i<l;i++){var K=J[i];if(K.getSortProperty()){a.columns.push({name:K.getLabel().getText(),template:{content:{path:K.getSortProperty(),model:M}}});}}}var L=new b(a);this.addDependent(L);return L;};v.prototype._onPersoApplied=function(){var a=this.getColumns();var b=[];for(var i=0,l=a.length;i<l;i++){var w=a[i];if(w.getSorted()){b.push(new g(w.getSortProperty(),w.getSortOrder()===u.Descending));}}var x=this.getBinding("rows");if(x){if(b.length>0){x.sort(b);}this.refreshRows();}};v.prototype._toggleSelectAll=function(){if(!T.hasData(this)){return;}if(T.areAllRowsSelected(this)){this._iSourceRowIndex=-1;this.clearSelection();}else{this._iSourceRowIndex=0;this.selectAll();}this._iSourceRowIndex=undefined;};v.prototype._restoreAppDefaultsColumnHeaderSortFilter=function(){var a=this.getColumns();q.each(a,function(i,b){b._restoreAppDefaults();});};v.prototype.setBusy=function(b,a){var i=this.getBusy()!=b;a="sapUiTableCnt";var l=C.prototype.setBusy.call(this,b,a);if(i){this.fireBusyStateChanged({busy:b});}return l;};v.prototype.setEnableBusyIndicator=function(b){this.setProperty("enableBusyIndicator",b,true);if(!b){this.setBusy(false);}};v.prototype._onBindingDataRequested=function(a){if(a.getSource()!=this.getBinding("rows")||a.getParameter("__simulateAsyncAnalyticalBinding")){return;}this._iPendingRequests++;this._bPendingRequest=true;var b=T.canUsePendingRequestsCounter(this);if(this.getEnableBusyIndicator()&&(b&&this._iPendingRequests===1||!b)){this.setBusy(true);}if(this._dataReceivedHandlerId!=null){q.sap.clearDelayedCall(this._dataReceivedHandlerId);delete this._dataReceivedHandlerId;}};v.prototype._onBindingDataReceived=function(a){if(a.getSource()!=this.getBinding("rows")||a.getParameter("__simulateAsyncAnalyticalBinding")){return;}this._iPendingRequests--;this._bPendingRequest=false;this._updateBindingLength();if(!T.hasPendingRequests(this)){this._dataReceivedHandlerId=q.sap.delayedCall(0,this,function(){if(this.getEnableBusyIndicator()){this.setBusy(false);}this._updateNoData();delete this._dataReceivedHandlerId;});}};v.prototype._setLargeDataScrolling=function(l){this._bLargeDataScrolling=!!l;};v.prototype._getSelectedIndicesCount=function(){return this.getSelectedIndices().length;};v.prototype._updateTableContent=function(){T.Grouping.updateGroups(this);};v.prototype.setRowActionTemplate=function(a){this.setAggregation("rowActionTemplate",a);a=this.getRowActionTemplate();if(a){a._setCount(this.getRowActionCount());}this.invalidateRowsAggregation();return this;};v.prototype.setRowActionCount=function(a){this.setProperty("rowActionCount",a);a=this.getRowActionCount();var b=this.getRowActionTemplate();if(b){b._setCount(a);}var l=this.getRows();for(var i=0;i<l.length;i++){b=l[i].getAggregation("_rowAction");if(b){b._setCount(a);}}return this;};v.prototype.setRowSettingsTemplate=function(a){this.setAggregation("rowSettingsTemplate",a);this.invalidateRowsAggregation();return this;};v.prototype._validateRow=function(a){return a&&a instanceof j&&a.getParent()===this;};v.prototype.getRowForCell=function(a){if(a){var b=a.getParent();if(this._validateRow(b)){return b;}}return null;};v.prototype.getColumnForCell=function(a){if(this.getRowForCell(a)){var i=a.data("sap-ui-colindex");var b=this.getColumns();if(i>=0&&i<b.length){return b[i];}}return null;};v.prototype.getCellControl=function(i,a,b){var l=T.getRowColCell(this,i,a,!b);return l.cell;};v.prototype._fireRowsUpdated=function(a){if(a==null){a=T.RowsUpdateReason.Unknown;}this.fireEvent("_rowsUpdated",{reason:a});};return v;});
