/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/table/AnalyticalColumn',['jquery.sap.global','./Column','./library','sap/ui/core/Element','sap/ui/model/type/Boolean','sap/ui/model/type/DateTime','sap/ui/model/type/Float','sap/ui/model/type/Integer','sap/ui/model/type/Time','./TableUtils','./AnalyticalColumnMenu'],function(q,C,l,E,B,D,F,I,T,a,A){"use strict";
function i(c){return a.isInstanceOf(c,"sap/ui/table/AnalyticalTable");}
var b=C.extend("sap.ui.table.AnalyticalColumn",{metadata:{library:"sap.ui.table",properties:{leadingProperty:{type:"string",group:"Misc",defaultValue:null},summed:{type:"boolean",group:"Misc",defaultValue:false},inResult:{type:"boolean",group:"Misc",defaultValue:false},showIfGrouped:{type:"boolean",group:"Appearance",defaultValue:false},groupHeaderFormatter:{type:"any",group:"Behavior",defaultValue:null}}}});
b.prototype.init=function(){C.prototype.init.apply(this,arguments);};
b._DEFAULT_FILTERTYPES={"Time":new T({UTC:true}),"DateTime":new D({UTC:true}),"Float":new F(),"Integer":new I(),"Boolean":new Boolean()};
b.prototype._createMenu=function(){return new A(this.getId()+"-menu");};
b.prototype.setGrouped=function(g,s){var p=this.getParent();if(i(p)){if(g){p._addGroupedColumn(this.getId());}else{p._removeGroupedColumn(this.getId());}}var r=this.setProperty("grouped",g,s);this._updateColumns();return r;};
b.prototype.setSummed=function(s){var r=this.setProperty("summed",s,true);this._updateTableAnalyticalInfo();return r;};
b.prototype.setVisible=function(v,s){this.setProperty("visible",v,s);this._updateColumns();return this;};
b.prototype.getLabel=function(){var L=this.getAggregation("label");if(!L){if(!this._oBindingLabel){var p=this.getParent();if(i(p)){var o=p.getBinding("rows");if(o){this._oBindingLabel=l.TableHelper.createLabel();var m=o.getModel();if(m.oMetadata&&m.oMetadata.isLoaded()){this._oBindingLabel.setText(o.getPropertyLabel(this.getLeadingProperty()));}else{var t=this;m.attachMetadataLoaded(function(){t._oBindingLabel.setText(o.getPropertyLabel(t.getLeadingProperty()));});}}}}L=this._oBindingLabel;}return L;};
b.prototype.getFilterProperty=function(){var p=this.getProperty("filterProperty");if(!p){var P=this.getParent();if(i(P)){var o=P.getBinding("rows");var L=this.getLeadingProperty();if(o&&q.inArray(L,o.getFilterablePropertyNames())>-1){p=L;}}}return p;};
b.prototype.getSortProperty=function(){var p=this.getProperty("sortProperty");if(!p){var P=this.getParent();if(i(P)){var o=P.getBinding("rows");var L=this.getLeadingProperty();if(o&&q.inArray(L,o.getSortablePropertyNames())>-1){p=L;}}}return p;};
b.prototype.getFilterType=function(){var f=this.getProperty("filterType");if(!f){var p=this.getParent();if(i(p)){var o=p.getBinding("rows");var L=this.getLeadingProperty(),P=o&&o.getProperty(L);if(P){switch(P.type){case"Edm.Time":f=b._DEFAULT_FILTERTYPES["Time"];break;case"Edm.DateTime":case"Edm.DateTimeOffset":f=b._DEFAULT_FILTERTYPES["DateTime"];break;case"Edm.Single":case"Edm.Double":case"Edm.Decimal":f=b._DEFAULT_FILTERTYPES["Float"];break;case"Edm.SByte":case"Edm.Int16":case"Edm.Int32":case"Edm.Int64":f=b._DEFAULT_FILTERTYPES["Integer"];break;case"Edm.Boolean":f=b._DEFAULT_FILTERTYPES["Boolean"];break;}}}}return f;};
b.prototype._updateColumns=function(s,f){var p=this.getParent();if(i(p)){p._updateColumns(s,f);}};
b.prototype._updateTableAnalyticalInfo=function(s){var p=this.getParent();if(p&&i(p)&&!p._bSuspendUpdateAnalyticalInfo){p.updateAnalyticalInfo(s);}};
b.prototype._updateTableColumnDetails=function(){var p=this.getParent();if(p&&i(p)&&!p._bSuspendUpdateAnalyticalInfo){p._updateTableColumnDetails();}};
b.prototype.shouldRender=function(){if(!this.getVisible()||this.getTemplate()==null){return false;}return(!this.getGrouped()||this._bLastGroupAndGrouped||this.getShowIfGrouped())&&(!this._bDependendGrouped||this._bLastGroupAndGrouped);};
b.prototype.getTooltip_AsString=function(){var t=E.prototype.getTooltip_AsString.apply(this);var p=this.getParent();if(!t&&i(p)){var o=p.getBinding("rows");if(o&&this.getLeadingProperty()){t=o.getPropertyQuickInfo(this.getLeadingProperty());}}return t;};
b.prototype._menuHasItems=function(){var m=function(){var t=this.getParent();var o=t.getBinding("rows");var r=o&&o.getAnalyticalQueryResult();return(t&&r&&r.findMeasureByPropertyName(this.getLeadingProperty()));}.bind(this);return C.prototype._menuHasItems.apply(this)||m();};
b.prototype.isFilterableByMenu=function(){var f=this.getFilterProperty();if(!f||!this.getShowFilterMenuEntry()){return false;}var p=this.getParent();if(i(p)){var o=p.getBinding("rows");if(o){if(q.inArray(f,o.getFilterablePropertyNames())>-1&&!o.isMeasure(f)&&o.getProperty(f)){return true;}}}return false;};
b.prototype.isGroupableByMenu=function(){var p=this.getParent();if(i(p)){var o=p.getBinding("rows");if(o){var r=o.getAnalyticalQueryResult();if(r&&r.findDimensionByPropertyName(this.getLeadingProperty())&&q.inArray(this.getLeadingProperty(),o.getSortablePropertyNames())>-1&&q.inArray(this.getLeadingProperty(),o.getFilterablePropertyNames())>-1){return true;}}}return false;};
return b;});
sap.ui.predefine('sap/ui/table/AnalyticalColumnMenu',['jquery.sap.global','./ColumnMenu','./library'],function(q,C,l){"use strict";var G=l.GroupEventType;
var A=C.extend("sap.ui.table.AnalyticalColumnMenu",{
metadata:{library:"sap.ui.table"},
renderer:"sap.ui.table.ColumnMenuRenderer"
});
A.prototype._addMenuItems=function(){C.prototype._addMenuItems.apply(this);if(this._oColumn){this._addSumMenuItem();}};
A.prototype._addGroupMenuItem=function(){var c=this._oColumn,t=this._oTable;if(c.isGroupableByMenu()){this._oGroupIcon=this._createMenuItem("group","TBL_GROUP",c.getGrouped()?"accept":null,function(e){var m=e.getSource();var g=c.getGrouped();var s=g?G.group:G.ungroup;c.setGrouped(!g);t.fireGroup({column:c,groupedColumns:t._aGroupedColumns,type:s});m.setIcon(!g?"sap-icon://accept":null);});this.addItem(this._oGroupIcon);}};
A.prototype._addSumMenuItem=function(){var c=this._oColumn,t=this._oTable,b=t.getBinding("rows"),r=b&&b.getAnalyticalQueryResult();if(t&&r&&r.findMeasureByPropertyName(c.getLeadingProperty())){this._oSumItem=this._createMenuItem("total","TBL_TOTAL",c.getSummed()?"accept":null,q.proxy(function(e){var m=e.getSource(),s=c.getSummed();c.setSummed(!s);m.setIcon(!s?"sap-icon://accept":null);},this));this.addItem(this._oSumItem);}};
A.prototype.open=function(){C.prototype.open.apply(this,arguments);var c=this._oColumn;this._oSumItem&&this._oSumItem.setIcon(c.getSummed()?"sap-icon://accept":null);this._oGroupIcon&&this._oGroupIcon.setIcon(c.getGrouped()?"sap-icon://accept":null);};
return A;});
sap.ui.predefine('sap/ui/table/AnalyticalColumnMenuRenderer',['sap/ui/table/AnalyticalColumnMenu'],function(M){"use strict";return M.getMetadata().getRenderer();},true);
sap.ui.predefine('sap/ui/table/AnalyticalTable.designtime',[],function(){"use strict";return{aggregations:{columns:{domRef:".sapUiTableCHA"},hScroll:{ignore:false,domRef:function(e){return e.$("hsb").get(0);}},vScroll:{ignore:false,domRef:function(e){return e.$("vsb").get(0);}}}};},false);
sap.ui.predefine('sap/ui/table/AnalyticalTable',['jquery.sap.global','./AnalyticalColumn','./Table','./TreeTable','./library','sap/ui/model/analytics/ODataModelAdapter','sap/ui/model/SelectionModel','sap/ui/model/Sorter','sap/ui/base/ManagedObject','sap/ui/core/Popup','sap/ui/unified/Menu','sap/ui/unified/MenuItem','./TableUtils'],function(q,A,T,a,b,O,S,c,M,P,d,e,f){"use strict";var G=b.GroupEventType,g=b.SelectionBehavior,h=b.SelectionMode,k=b.SortOrder,m=b.TreeAutoExpandMode;
var n=T.extend("sap.ui.table.AnalyticalTable",{
metadata:{library:"sap.ui.table",properties:{sumOnTop:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},numberOfExpandedLevels:{type:"int",group:"Misc",defaultValue:0,deprecated:true},autoExpandMode:{type:"string",group:"Misc",defaultValue:"Bundled",deprecated:true},columnVisibilityMenuSorter:{type:"any",group:"Appearance",defaultValue:null},collapseRecursive:{type:"boolean",defaultValue:true},dirty:{type:"boolean",group:"Appearance",defaultValue:null,deprecated:true}},designTime:true},
renderer:"sap.ui.table.TableRenderer"
});
n.prototype._getFixedBottomRowContexts=function(){var B=this.getBinding("rows");if(B){return[B.getGrandTotalNode()];}};
n.prototype._getContexts=a.prototype._getContexts;
n.prototype.init=function(){T.prototype.init.apply(this,arguments);this.addStyleClass("sapUiAnalyticalTable");this.attachBrowserEvent("contextmenu",this._onContextMenu);this.setSelectionMode(h.MultiToggle);this.setShowColumnVisibilityMenu(true);this.setEnableColumnFreeze(true);this.setEnableCellFilter(true);this._aGroupedColumns=[];this._bSuspendUpdateAnalyticalInfo=false;f.Grouping.setGroupMode(this);};
n.prototype.exit=function(){this._cleanupGroupHeaderMenu();T.prototype.exit.apply(this,arguments);};
n.prototype._adaptLocalization=function(r,l){T.prototype._adaptLocalization.apply(this,arguments);if(l){this._cleanupGroupHeaderMenu();}};
n.prototype.setFixedRowCount=function(){q.sap.log.error("The property fixedRowCount is not supported by control sap.ui.table.AnalyticalTable!");return this;};
n.prototype.setFixedBottomRowCount=function(){q.sap.log.error("The property fixedBottomRowCount is managed by control sap.ui.table.AnalyticalTable!");return this;};
n.prototype.setDirty=function(D){q.sap.log.error("The property dirty of control sap.ui.table.AnalyticalTable is deprecated. Please use showOverlay instead.");this.setProperty("dirty",D,true);this.setShowOverlay(this.getDirty());return this;};
n.prototype.setEnableGrouping=function(){q.sap.log.error("The property enableGrouping is not supported by the sap.ui.table.AnalyticalTable control");return this;};
n.prototype.setGroupBy=function(){q.sap.log.warning("The groupBy association is not supported by the sap.ui.table.AnalyticalTable control");return this;};
n.prototype.getModel=function(N){var o=T.prototype.getModel.apply(this,arguments);var r=this.getBindingInfo("rows");if(o&&r&&r.model==N){O.apply(o);}return o;};
n.prototype._onBindingChange=function(E){T.prototype._onBindingChange.apply(this,arguments);var r=typeof(E)==="object"?E.getParameter("reason"):E;if(r!=="sort"){this._invalidateColumnMenus();}};
n.prototype.bindRows=function(B){B=T._getSanitizedBindingInfo(arguments);if(B!=null){this._applyAnalyticalBindingInfo(B);this._updateTotalRow(true);}return T.prototype.bindRows.call(this,B);};
n.prototype._bindAggregation=function(N,B){if(N==="rows"){this.setProperty("firstVisibleRow",0,true);this._applyODataModelAnalyticalAdapter(B.model);T._addBindingListener(B,"selectionChanged",this._onSelectionChanged.bind(this));}T.prototype._bindAggregation.call(this,N,B);};
n.prototype._initSelectionModel=function(s){this._oSelection=new S(s);return this;};
n.prototype.setSelectionMode=function(s){if(s===h.None){q.sap.log.fatal("SelectionMode 'None' is not supported by the AnalyticalTable.");return this;}var B=this.getBinding("rows");if(B&&B.clearSelection){B.clearSelection();}s=f.sanitizeSelectionMode(this,s);this.setProperty("selectionMode",s);return this;};
n.prototype.setSelectionBehavior=function(B){if(B===g.RowOnly){q.sap.log.fatal("SelectionBehavior 'RowOnly' is not supported by the AnalyticalTable.");return this;}else{return T.prototype.setSelectionBehavior.apply(this,arguments);}};
n.prototype._applyAnalyticalBindingInfo=function(B){var C=this.getColumns();for(var i=0,l=C.length;i<l;i++){if(C[i].getSorted()){B.sorter=B.sorter||[];B.sorter.push(new c(C[i].getSortProperty()||C[i].getLeadingProperty(),C[i].getSortOrder()===k.Descending));}}B.parameters=B.parameters||{};B.parameters.analyticalInfo=this._getColumnInformation();if(!B.parameters.hasOwnProperty("sumOnTop")){B.parameters.sumOnTop=this.getSumOnTop();}if(!B.parameters.hasOwnProperty("numberOfExpandedLevels")){B.parameters.numberOfExpandedLevels=this.getNumberOfExpandedLevels();}if(B.parameters.numberOfExpandedLevels>this._aGroupedColumns.length){B.parameters.numberOfExpandedLevels=0;}if(!B.parameters.hasOwnProperty("autoExpandMode")){var E=this.getAutoExpandMode();if(E!=m.Bundled&&E!=m.Sequential){E=m.Bundled;}B.parameters.autoExpandMode=E;}};
n.prototype._applyODataModelAnalyticalAdapter=function(o){if(o!=null){O.apply(o);}};
n.prototype._getColumnInformation=function(){var C=[],t=this.getColumns();for(var i=0;i<this._aGroupedColumns.length;i++){var o=sap.ui.getCore().byId(this._aGroupedColumns[i]);if(!o){continue;}C.push({name:o.getLeadingProperty(),visible:o.getVisible(),grouped:o.getGrouped(),total:o.getSummed(),sorted:o.getSorted(),sortOrder:o.getSortOrder(),inResult:o.getInResult(),formatter:o.getGroupHeaderFormatter()});}for(var i=0;i<t.length;i++){var o=t[i];if(q.inArray(o.getId(),this._aGroupedColumns)>-1){continue;}if(!o instanceof A){q.sap.log.error("You have to use AnalyticalColumns for the Analytical table");}C.push({name:o.getLeadingProperty(),visible:o.getVisible(),grouped:o.getGrouped(),total:o.getSummed(),sorted:o.getSorted(),sortOrder:o.getSortOrder(),inResult:o.getInResult(),formatter:o.getGroupHeaderFormatter()});}return C;};
n.prototype._updateTableContent=function(){var B=this.getBinding("rows"),F=this.getFirstVisibleRow(),j=this.getFixedBottomRowCount(),C=this.getVisibleRowCount(),o=this.getColumns();var r=this.getRows();if(!B){for(var i=0;i<r.length;i++){f.Grouping.cleanupTableRowForGrouping(this,r[i]);}return;}var p=this.getBindingInfo("rows");for(var R=0,l=Math.min(C,r.length);R<l;R++){var I=R>(C-j-1)&&B.getLength()>C,s=I?(B.getLength()-1-(C-1-R)):F+R,t=r[R],$=t.$(),u=this.$().find("div[data-sap-ui-rowindex="+$.attr("data-sap-ui-rowindex")+"]");var v;if(I&&B.bProvideGrandTotals){v=B.getGrandTotalContextInfo();}else{v=this.getContextInfoByIndex(s);}var L=v?v.level:0;if(!v||!v.context){f.Grouping.cleanupTableRowForGrouping(this,t);if(v&&!v.context){$.addClass("sapUiAnalyticalTableDummy");u.addClass("sapUiAnalyticalTableDummy");}continue;}if(B.nodeHasChildren&&B.nodeHasChildren(v)){f.Grouping.updateTableRowForGrouping(this,t,true,v.nodeState.expanded,v.nodeState.expanded&&!p.parameters.sumOnTop,false,L,B.getGroupName(v.context,v.level));}else{f.Grouping.updateTableRowForGrouping(this,t,false,false,false,v.nodeState.sum,L,v.nodeState.sum&&v.level>0?B.getGroupName(v.context,v.level):null);}var w=t.getCells();for(var i=0,x=w.length;i<x;i++){var y=w[i].data("sap-ui-colindex");var z=o[y];var D=q(w[i].$().closest("td"));if(B.isMeasure(z.getLeadingProperty())){D.addClass("sapUiTableMeasureCell");D.toggleClass("sapUiTableCellHidden",v.nodeState.sum&&!z.getSummed());}else{D.removeClass("sapUiTableMeasureCell");}}}};
n.prototype._onContextMenu=function(E){if(q(E.target).closest('tr').hasClass('sapUiTableGroupHeader')||q(E.target).closest('.sapUiTableRowHdr.sapUiTableGroupHeader').length>0){this._iGroupedLevel=q(E.target).closest('[data-sap-ui-level]').data('sap-ui-level');var o=this._getGroupHeaderMenu();var i=P.Dock;var l=E.pageX||E.clientX;var L=E.pageY||E.clientY;o.open(false,E.target,i.LeftTop,i.LeftTop,document,(l-2)+" "+(L-2));E.preventDefault();E.stopPropagation();return;}return true;};
n.prototype._getGroupHeaderMenu=function(){var t=this;function j(){var i=t._iGroupedLevel-1;if(t._aGroupedColumns[i]){var l=t.getColumns().filter(function(C){return t._aGroupedColumns[i]===C.getId();})[0];return{column:l,index:i};}else{return undefined;}}if(!this._oGroupHeaderMenu){this._oGroupHeaderMenu=new d();this._oGroupHeaderMenuVisibilityItem=new e({text:this._oResBundle.getText("TBL_SHOW_COLUMN"),select:function(){var o=j();if(o){var C=o.column,s=C.getShowIfGrouped();C.setShowIfGrouped(!s);t.fireGroup({column:C,groupedColumns:C.getParent()._aGroupedColumns,type:(!s?G.showGroupedColumn:G.hideGroupedColumn)});}}});this._oGroupHeaderMenu.addItem(this._oGroupHeaderMenuVisibilityItem);this._oGroupHeaderMenu.addItem(new e({text:this._oResBundle.getText("TBL_UNGROUP"),select:function(){var o=j();if(o!=null&&o.column!=null){var u=o.column;u.setGrouped(false);t.fireGroup({column:u,groupedColumns:t._aGroupedColumns,type:G.ungroup});}}}));this._oGroupHeaderMenu.addItem(new e({text:this._oResBundle.getText("TBL_UNGROUP_ALL"),select:function(){var l=t.getColumns();t.suspendUpdateAnalyticalInfo();for(var i=0;i<l.length;i++){l[i].setGrouped(false);}t.resumeUpdateAnalyticalInfo();t.fireGroup({column:undefined,groupedColumns:[],type:G.ungroupAll});}}));this._oGroupHeaderMoveUpItem=new e({text:this._oResBundle.getText("TBL_MOVE_UP"),select:function(){var o=j();if(o){var C=o.column;var i=q.inArray(C.getId(),t._aGroupedColumns);if(i>0){t._aGroupedColumns[i]=t._aGroupedColumns.splice(i-1,1,t._aGroupedColumns[i])[0];t.updateAnalyticalInfo();t.fireGroup({column:C,groupedColumns:C.getParent()._aGroupedColumns,type:G.moveUp});}}},icon:"sap-icon://arrow-top"});this._oGroupHeaderMenu.addItem(this._oGroupHeaderMoveUpItem);this._oGroupHeaderMoveDownItem=new e({text:this._oResBundle.getText("TBL_MOVE_DOWN"),select:function(){var o=j();if(o){var C=o.column;var i=q.inArray(C.getId(),t._aGroupedColumns);if(i<t._aGroupedColumns.length){t._aGroupedColumns[i]=t._aGroupedColumns.splice(i+1,1,t._aGroupedColumns[i])[0];t.updateAnalyticalInfo();t.fireGroup({column:C,groupedColumns:C.getParent()._aGroupedColumns,type:G.moveDown});}}},icon:"sap-icon://arrow-bottom"});this._oGroupHeaderMenu.addItem(this._oGroupHeaderMoveDownItem);this._oGroupHeaderMenu.addItem(new e({text:this._oResBundle.getText("TBL_SORT_ASC"),select:function(){var o=j();if(o){var C=o.column;C.sort(false);}},icon:"sap-icon://up"}));this._oGroupHeaderMenu.addItem(new e({text:this._oResBundle.getText("TBL_SORT_DESC"),select:function(){var o=j();if(o){var C=o.column;C.sort(true);}},icon:"sap-icon://down"}));this._oGroupHeaderMenu.addItem(new e({text:this._oResBundle.getText("TBL_COLLAPSE_LEVEL"),select:function(){t.getBinding("rows").collapseToLevel(t._iGroupedLevel-1);t.setFirstVisibleRow(0);t.clearSelection();}}));this._oGroupHeaderMenu.addItem(new e({text:this._oResBundle.getText("TBL_COLLAPSE_ALL"),select:function(){t.getBinding("rows").collapseToLevel(0);t.setFirstVisibleRow(0);t.clearSelection();}}));}var o=j();if(o){var C=o.column;if(C.getShowIfGrouped()){this._oGroupHeaderMenuVisibilityItem.setText(this._oResBundle.getText("TBL_HIDE_COLUMN"));}else{this._oGroupHeaderMenuVisibilityItem.setText(this._oResBundle.getText("TBL_SHOW_COLUMN"));}this._oGroupHeaderMoveUpItem.setEnabled(o.index>0);this._oGroupHeaderMoveDownItem.setEnabled(o.index<this._aGroupedColumns.length-1);}else{this._oGroupHeaderMoveUpItem.setEnabled(true);this._oGroupHeaderMoveDownItem.setEnabled(true);}return this._oGroupHeaderMenu;};
n.prototype._cleanupGroupHeaderMenu=function(){if(this._oGroupHeaderMenu){this._oGroupHeaderMenu.destroy();this._oGroupHeaderMenu=null;this._oGroupHeaderMenuVisibilityItem=null;this._oGroupHeaderMoveUpItem=null;this._oGroupHeaderMoveDownItem=null;}};
n.prototype.expand=function(r){var B=this.getBinding("rows");if(B){B.expand(r);}};
n.prototype.collapse=function(r){var B=this.getBinding("rows");if(B){B.collapse(r);}};
n.prototype.collapseAll=function(){var B=this.getBinding("rows");if(B){B.collapseToLevel(0);this.setFirstVisibleRow(0);}return this;};
n.prototype.isExpanded=function(r){var B=this.getBinding("rows");if(B){return B.isExpanded(r);}return false;};
n.prototype.getContextByIndex=function(i){var B=this.getBinding("rows");return i>=0&&B?B.getContextByIndex(i):null;};
n.prototype.getContextInfoByIndex=function(i){var B=this.getBinding("rows");return i>=0&&B?B.getNodeByIndex(i):null;};
n.prototype.suspendUpdateAnalyticalInfo=function(){this._bSuspendUpdateAnalyticalInfo=true;};
n.prototype.resumeUpdateAnalyticalInfo=function(s,F){this._bSuspendUpdateAnalyticalInfo=false;this._updateColumns(s,F);};
n.prototype.addColumn=function(C,s){var o=this._getColumn(C);if(o.getGrouped()){this._addGroupedColumn(o.getId());}T.prototype.addColumn.call(this,o,s);this._updateColumns(s);return this;};
n.prototype.insertColumn=function(C,i,s){var o=this._getColumn(C);if(o.getGrouped()){this._addGroupedColumn(o.getId());}T.prototype.insertColumn.call(this,o,i,s);this._updateColumns(s);return this;};
n.prototype.removeColumn=function(C,s){var r=T.prototype.removeColumn.apply(this,arguments);if(!this._bReorderInProcess){this._aGroupedColumns=q.grep(this._aGroupedColumns,function(v){if(C.getId){return v!=C.getId();}else{return v==C;}});}this.updateAnalyticalInfo(s);return r;};
n.prototype.removeAllColumns=function(s){this._aGroupedColumns=[];var r=T.prototype.removeAllColumns.apply(this,arguments);this._updateColumns(s);return r;};
n.prototype._getColumn=function(C){if(typeof C==="string"){var o=new A({leadingProperty:C,template:C,managed:true});return o;}else if(C instanceof A){return C;}else{throw new Error("Wrong column type. You need to define a string (property) or pass an AnalyticalColumnObject");}};
n.prototype._updateColumns=function(s,F){if(!this._bSuspendUpdateAnalyticalInfo){this._updateTableColumnDetails();this.updateAnalyticalInfo(s,F);}};
n.prototype.updateAnalyticalInfo=function(s,F){if(this._bSuspendUpdateAnalyticalInfo){return;}var B=this.getBinding("rows");if(B){var C=this._getColumnInformation();var N=B.getNumberOfExpandedLevels()||0;if(N>this._aGroupedColumns.length){B.setNumberOfExpandedLevels(0);}B.updateAnalyticalInfo(C,F);this._updateTotalRow(s);if(!s){this._getRowContexts();}}};
n.prototype.refreshRows=function(){sap.ui.table.Table.prototype.refreshRows.apply(this,arguments);this._updateTotalRow();};
n.prototype._updateTotalRow=function(s){var B=this.getBinding("rows");var F=this.getFixedBottomRowCount();if(B&&(B.providesGrandTotal()&&B.hasTotaledMeasures())){if(F!==1){this.setProperty("fixedBottomRowCount",1,s);}}else{if(F!==0){this.setProperty("fixedBottomRowCount",0,s);}}};
n.prototype._updateTableColumnDetails=function(){if(this._bSuspendUpdateAnalyticalInfo){return;}var B=this.getBinding("rows"),r=B&&B.getAnalyticalQueryResult();if(r){var C=this.getColumns(),l=[],u=[],D=[],p={},t,v;for(var i=0;i<C.length;i++){t=C[i];t._isLastGroupableLeft=false;t._bLastGroupAndGrouped=false;t._bDependendGrouped=false;if(!t.getVisible()){continue;}var L=t.getLeadingProperty();v=r.findDimensionByPropertyName(L);if(v){var w=v.getName();if(!p[w]){p[w]={dimension:v,columns:[t]};}else{p[w].columns.push(t);}if(t.getGrouped()&&q.inArray(w,l)==-1){l.push(w);}if(q.inArray(w,D)==-1){D.push(w);}}}u=q.grep(D,function(s){return(q.inArray(s,l)==-1);});if(l.length>0){q.each(l,function(i,s){q.each(p[s].columns,function(j,o){if(!o.getGrouped()){o._bDependendGrouped=true;}});});if(l.length==D.length){v=r.findDimensionByPropertyName(sap.ui.getCore().byId(this._aGroupedColumns[this._aGroupedColumns.length-1]).getLeadingProperty());var x=p[v.getName()].columns;q.each(x,function(i,o){o._bLastGroupAndGrouped=true;});}}if(u.length==1){q.each(p[u[0]].columns,function(j,o){o._isLastGroupableLeft=true;});}}};
n.prototype._getFirstMeasureColumnIndex=function(){var B=this.getBinding("rows"),r=B&&B.getAnalyticalQueryResult(),C=this._getVisibleColumns();if(!r){return-1;}for(var i=0;i<C.length;i++){var o=C[i],l=o.getLeadingProperty();if(r.findMeasureByName(l)||r.findMeasureByPropertyName(l)){return i;}}};
n.prototype.getTotalSize=function(){var B=this.getBinding("rows");if(B){return B.getTotalSize();}return 0;};
n.prototype._onPersoApplied=function(){T.prototype._onPersoApplied.apply(this,arguments);this._aGroupedColumns=[];var C=this.getColumns();for(var i=0,l=C.length;i<l;i++){if(C[i].getGrouped()){this._addGroupedColumn(C[i].getId());}}this._updateColumns();};
n.prototype._addGroupedColumn=function(C){if(this._aGroupedColumns.indexOf(C)===-1){this._aGroupedColumns.push(C);}};
n.prototype._removeGroupedColumn=function(C){var i=this._aGroupedColumns.indexOf(C);if(i>=0){this._aGroupedColumns.splice(i,1);}};
n.prototype.getGroupedColumns=function(){return this._aGroupedColumns;};
n.prototype.setCollapseRecursive=function(C){var B=this.getBinding("rows");if(B){if(B.setCollapseRecursive){B.setCollapseRecursive(C);}}this.setProperty("collapseRecursive",!!C,true);return this;};
n.prototype._getSelectableRowCount=function(){var B=this.getBinding("rows");if(B){var r=B.getGrandTotalContextInfo();return r?r.totalNumberOfLeafs:0;}};
n.prototype.isIndexSelected=a.prototype.isIndexSelected;n.prototype.setSelectedIndex=a.prototype.setSelectedIndex;n.prototype.getSelectedIndices=a.prototype.getSelectedIndices;n.prototype.setSelectionInterval=a.prototype.setSelectionInterval;n.prototype.addSelectionInterval=a.prototype.addSelectionInterval;n.prototype.removeSelectionInterval=a.prototype.removeSelectionInterval;n.prototype.selectAll=a.prototype.selectAll;n.prototype.getSelectedIndex=a.prototype.getSelectedIndex;n.prototype.clearSelection=a.prototype.clearSelection;
n.prototype._isRowSelectable=function(r){var B=this.getBinding("rows");if(B){return B.isIndexSelectable(r);}else{return false;}};
n.prototype._getSelectedIndicesCount=a.prototype._getSelectedIndicesCount;
n.prototype.getAnalyticalInfoOfRow=function(r){if(!this._validateRow(r)){return null;}var B=this.getBindingInfo("rows");var o=this.getBinding("rows");if(!B||!o){return null;}var C=r.getBindingContext(B.model);if(!C){return null;}var I=C===o.getGrandTotalContext();var j=null;var l=-1;if(I){j=o.getGrandTotalContextInfo();l=0;}else{j=this.getContextInfoByIndex(r.getIndex());if(j){l=j.level;}}var p=j&&o.nodeHasChildren&&o.nodeHasChildren(j);var s=!p&&!I&&j&&j.nodeState&&j.nodeState.sum;var t=[];if(s||p){var u=this.getGroupedColumns();if(u.length>0&&l>0&&l<=u.length){for(var i=0;i<l;i++){t.push(u[i]);}}}return{grandTotal:I,group:p,groupTotal:s,level:l,context:C,groupedColumns:t};};
return n;});
sap.ui.predefine('sap/ui/table/AnalyticalTableRenderer',['sap/ui/table/AnalyticalTable'],function(T){"use strict";return T.getMetadata().getRenderer();},true);
sap.ui.predefine('sap/ui/table/Column',['jquery.sap.global','sap/ui/core/Element','sap/ui/core/library','sap/ui/core/Popup','sap/ui/core/RenderManager','sap/ui/model/Filter','sap/ui/model/FilterOperator','sap/ui/model/FilterType','sap/ui/model/Sorter','sap/ui/model/Type','sap/ui/model/type/String','./TableUtils','./library','./ColumnMenu'],function(q,E,c,P,R,F,a,b,S,T,d,f,g,C){"use strict";var H=c.HorizontalAlign,h=g.SortOrder,V=c.ValueState;
var j=E.extend("sap.ui.table.Column",{metadata:{library:"sap.ui.table",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},minWidth:{type:"int",group:"Dimension",defaultValue:0},flexible:{type:"boolean",group:"Behavior",defaultValue:true},resizable:{type:"boolean",group:"Behavior",defaultValue:true},hAlign:{type:"sap.ui.core.HorizontalAlign",group:"Appearance",defaultValue:H.Begin},sorted:{type:"boolean",group:"Appearance",defaultValue:false},sortOrder:{type:"sap.ui.table.SortOrder",group:"Appearance",defaultValue:h.Ascending},sortProperty:{type:"string",group:"Behavior",defaultValue:null},filtered:{type:"boolean",group:"Appearance",defaultValue:false},filterProperty:{type:"string",group:"Behavior",defaultValue:null},filterValue:{type:"string",group:"Behavior",defaultValue:null},filterOperator:{type:"string",group:"Behavior",defaultValue:null},defaultFilterOperator:{type:"string",group:"Behavior",defaultValue:null},filterType:{type:"any",group:"Misc",defaultValue:null},grouped:{type:"boolean",group:"Appearance",defaultValue:false},visible:{type:"boolean",group:"Appearance",defaultValue:true},name:{type:"string",group:"Appearance",defaultValue:null},showFilterMenuEntry:{type:"boolean",group:"Appearance",defaultValue:true},showSortMenuEntry:{type:"boolean",group:"Appearance",defaultValue:true},headerSpan:{type:"any",group:"Behavior",defaultValue:1},autoResizable:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"label",aggregations:{label:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},multiLabels:{type:"sap.ui.core.Control",multiple:true,singularName:"multiLabel"},template:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},menu:{type:"sap.ui.unified.Menu",multiple:false}},events:{columnMenuOpen:{allowPreventDefault:true,parameters:{menu:{type:"sap.ui.unified.Menu"}}}}}});
j._DEFAULT_FILTER_TYPE=new d();
j.prototype.init=function(){this._oSorter=null;this.mSkipPropagation={template:true};this._aTemplateClones=[];};
j.prototype.exit=function(){this._destroyTemplateClones();};
j.prototype.setParent=function(p,A,s){E.prototype.setParent.apply(this,arguments);var m=this.getAggregation("menu");if(m&&typeof m._updateReferences==="function"){m._updateReferences(this);}};
j.prototype.invalidate=function(o){if(o!==this.getTemplate()&&!f.isInstanceOf(o,"sap/ui/table/ColumnMenu")){E.prototype.invalidate.apply(this,arguments);}};
j.prototype.setLabel=function(l){var L=l;if(typeof(l)==="string"){L=g.TableHelper.createLabel({text:l});}this.setAggregation("label",L);return this;};
j.prototype.setTemplate=function(t){var o=t;if(typeof(t)==="string"){o=g.TableHelper.createTextView().bindProperty("text",t);}this.setAggregation("template",o);this.invalidate();this._destroyTemplateClones();var e=this.getParent();if(e&&e.invalidateRowsAggregation&&this.getVisible()==true){e.invalidateRowsAggregation();}return this;};
j.prototype.getMenu=function(){var m=this.getAggregation("menu");if(!m){m=this._createMenu();this.setMenu(m);}return m;};
j.prototype.invalidateMenu=function(u){var m=this.getAggregation("menu");if(this._bMenuIsColumnMenu){if(u){m._updateResourceBundle();}else{m._invalidate();}}};
j.prototype._menuHasItems=function(){var m=this.getAggregation("menu");var t=this.getParent();var M=function(){return(this.isSortableByMenu()||this.isFilterableByMenu()||this.isGroupableByMenu()||(t&&t.getEnableColumnFreeze())||(t&&t.getShowColumnVisibilityMenu()));}.bind(this);return!!((m&&m.getItems().length>0)||M());};
j.prototype.isFilterableByMenu=function(){return!!(this.getFilterProperty()&&this.getShowFilterMenuEntry());};
j.prototype.isSortableByMenu=function(){return!!(this.getSortProperty()&&this.getShowSortMenuEntry());};
j.prototype.isGroupableByMenu=function(){var t=this.getParent();return!!(t&&t.getEnableGrouping&&t.getEnableGrouping()&&this.getSortProperty());};
j.prototype.setMenu=function(m){this.setAggregation("menu",m,true);this._bMenuIsColumnMenu=f.isInstanceOf(m,"sap/ui/table/ColumnMenu");return this;};
j.prototype._createMenu=function(){if(!this._defaultMenu){this._defaultMenu=new C(this.getId()+"-menu",{ariaLabelledBy:this});}return this._defaultMenu;};
j.prototype._setAppDefault=function(p,v){if(!this._appDefaults){this._appDefaults={};}if(p=="sorted"){this._appDefaults.sorted=v;}else if(p=="sortOrder"){this._appDefaults.sortOrder=v;}else if(p=="filtered"){this._appDefaults.filtered=v;}else if(p=="filterValue"){this._appDefaults.filterValue=v;}else if(p=="filterOperator"){this._appDefaults.filterOperator=v;}};
j.prototype._restoreAppDefaults=function(){if(this._appDefaults){this.setProperty("sorted",this._appDefaults.sorted,true);this.setProperty("sortOrder",this._appDefaults.sortOrder,true);this.setProperty("filtered",this._appDefaults.filtered,true);this.setProperty("filterValue",this._appDefaults.filterValue,true);this.setProperty("filterOperator",this._appDefaults.filterOperator,true);this._updateIcons();}};
j.prototype.setSortProperty=function(v){this.setProperty("sortProperty",v);this.invalidateMenu();return this;};
j.prototype.setSorted=function(e){this.setProperty("sorted",e,true);this._setAppDefault("sorted",e);this._updateIcons();return this;};
j.prototype.setSortOrder=function(t){this.setProperty("sortOrder",t,true);this._setAppDefault("sortOrder",t);this._updateIcons();return this;};
j.prototype.setFilterProperty=function(v){this.invalidateMenu();return this.setProperty("filterProperty",v);};
j.prototype.setFiltered=function(e){this.setProperty("filtered",e,true);this._setAppDefault("filtered",e);this._updateIcons();return this;};
j.prototype.setFilterValue=function(v){this.setProperty("filterValue",v,true);this._setAppDefault("filterValue",v);var m=this.getMenu();if(this._bMenuIsColumnMenu){m._setFilterValue(v);}return this;};
j.prototype.setFilterOperator=function(v){this._setAppDefault("filterOperator",v);return this.setProperty("filterOperator",v,true);};
j.prototype._openMenu=function(D,w){var m=this.getMenu();var e=this.fireColumnMenuOpen({menu:m});if(e){var i=P.Dock;var o=D;if(!D){D=this.getDomRef();o=this.getFocusDomRef();}m.open(!!w,o,i.BeginTop,i.BeginBottom,D,"none none");}};
j.prototype.toggleSort=function(){this.sort(this.getSorted()&&this.getSortOrder()===h.Ascending);};
j.prototype.sort=function(D,A){var t=this.getParent();if(t){t.pushSortedColumn(this,A);var n=D?h.Descending:h.Ascending;var e=t.fireSort({column:this,sortOrder:n,columnAdded:A});if(e){var s=t.getSortedColumns();var k=t.getColumns();for(var i=0,l=k.length;i<l;i++){if(q.inArray(k[i],s)<0){k[i].setProperty("sorted",false,true);k[i].setProperty("sortOrder",h.Ascending,true);k[i]._updateIcons();delete k[i]._oSorter;}}this.setProperty("sorted",true,true);this.setProperty("sortOrder",n,true);this._oSorter=new S(this.getSortProperty(),this.getSortOrder()===h.Descending);var m=[];for(var i=0,l=s.length;i<l;i++){s[i]._updateIcons();m.push(s[i]._oSorter);}var B=t.getBinding("rows");if(B){if(this._updateTableAnalyticalInfo){this._updateTableAnalyticalInfo(true);}B.sort(m);}else{q.sap.log.warning("Sorting not performed because no binding present",this);}}}return this;};
j.prototype._updateIcons=function(){var t=this.getParent(),s=this.getSorted(),e=this.getFiltered();if(!t||!t.getDomRef()){return;}this.$().parents(".sapUiTableCHT").find('td[data-sap-ui-colindex="'+this.getIndex()+'"]').filter(":not([colspan]):visible").first().find(".sapUiTableColCell").toggleClass("sapUiTableColSF",s||e).toggleClass("sapUiTableColFiltered",e).toggleClass("sapUiTableColSorted",s).toggleClass("sapUiTableColSortedD",s&&this.getSortOrder()===h.Descending);t._getAccExtension().updateAriaStateOfColumn(this);};
j.prototype._renderSortIcon=function(){this._updateIcons();};
j.prototype._getFilter=function(){var o,p=this.getFilterProperty(),v=this.getFilterValue(),O=this.getFilterOperator(),s,e,t=this.getFilterType()||j._DEFAULT_FILTER_TYPE,i=t instanceof d,B;if(v){if(!O){B=v.match(/(.*)\s*\.\.\s*(.*)/);if(v.indexOf("=")==0){O=a.EQ;s=v.substr(1);}else if(v.indexOf("!=")==0){O=a.NE;s=v.substr(2);}else if(v.indexOf("<=")==0){O=a.LE;s=v.substr(2);}else if(v.indexOf("<")==0){O=a.LT;s=v.substr(1);}else if(v.indexOf(">=")==0){O=a.GE;s=v.substr(2);}else if(v.indexOf(">")==0){O=a.GT;s=v.substr(1);}else if(B){if(B[1]&&B[2]){O=a.BT;s=B[1];e=B[2];}else if(B[1]&&!B[2]){O=a.GE;s=B[1];}else{O=a.LE;s=B[2];}}else if(i&&v.indexOf("*")==0&&v.lastIndexOf("*")==v.length-1){O=a.Contains;s=v.substr(1,v.length-2);}else if(i&&v.indexOf("*")==0){O=a.EndsWith;s=v.substr(1);}else if(i&&v.lastIndexOf("*")==v.length-1){O=a.StartsWith;s=v.substr(0,v.length-1);}else{if(this.getDefaultFilterOperator()){O=this.getDefaultFilterOperator();}else{if(i){O=a.Contains;}else{O=a.EQ;}}s=v.substr(0);}if(!e){o=new F(p,O,this._parseFilterValue(s));}else{o=new F(p,O,this._parseFilterValue(s),this._parseFilterValue(e));}}else{o=new F(p,O,this._parseFilterValue(v));}}return o;};
j.prototype.filter=function(v){var t=this.getParent();if(t&&t.isBound("rows")){var k=t.fireFilter({column:this,value:v});if(k){this.setProperty("filtered",!!v,true);this.setProperty("filterValue",v,true);var m=this.getMenu();if(this._bMenuIsColumnMenu){m._setFilterValue(v);}var n=[];var o=t.getColumns();for(var i=0,l=o.length;i<l;i++){var p=o[i],r;m=p.getMenu();try{r=p._getFilter();if(p._bMenuIsColumnMenu){m._setFilterState(V.None);}}catch(e){if(p._bMenuIsColumnMenu){m._setFilterState(V.Error);}continue;}if(r){n.push(r);}}t.getBinding("rows").filter(n,b.Control);this._updateIcons();}}return this;};
j.prototype._parseFilterValue=function(v){var o=this.getFilterType();if(o){if(q.isFunction(o)){v=o(v);}else{v=o.parseValue(v,"string");}}return v;};
j.prototype._restoreIcons=function(){this._updateIcons();};
j.prototype.shouldRender=function(){return this.getVisible()&&!this.getGrouped()&&this.getTemplate()!=null;};
j.PROPERTIES_FOR_ROW_INVALIDATION={visible:true,flexible:true,headerSpan:true};
j.prototype.setProperty=function(n,v){var t=this.getParent();if(t&&t.invalidateRowsAggregation&&this.getProperty(n)!=v&&j.PROPERTIES_FOR_ROW_INVALIDATION[n]&&(this.getVisible()||n=="visible")){t.invalidateRowsAggregation();}return E.prototype.setProperty.apply(this,arguments);};
j.prototype.setFilterType=function(t){var o=t;if(typeof(t)==="string"){try{var m=q.sap.parseJS(t);if(typeof(m.type)==="string"){var e=q.sap.getObject(m.type);o=e&&new e(m.formatOptions,m.constraints);}}catch(i){var e=q.sap.getObject(t);o=e&&new e();}if(!(o instanceof T)){q.sap.log.error("The filter type is not an instance of sap.ui.model.Type! Ignoring the filter type!");o=undefined;}}this.setProperty("filterType",o,true);return this;};
j.prototype.getIndex=function(){var t=this.getParent();if(t){return t.indexOfColumn(this);}else{return-1;}};
j.prototype._getFreeTemplateClone=function(){var o=null;for(var i=0;i<this._aTemplateClones.length;i++){if(this._aTemplateClones[i]==null||this._aTemplateClones[i].bIsDestroyed){this._aTemplateClones.splice(i,1);i--;}else if(o===null&&this._aTemplateClones[i].getParent()==null){o=this._aTemplateClones[i];}}return o;};
j.prototype.getTemplateClone=function(i){if(i==null){return null;}var o=this._getFreeTemplateClone();if(o===null){var t=this.getTemplate();if(t){o=t.clone();this._aTemplateClones.push(o);}}if(o!=null){o.data("sap-ui-colindex",i);o.data("sap-ui-colid",this.getId());var e=this.getParent();if(e!=null){e._getAccExtension().addColumnHeaderLabel(this,o);}}return o;};
j.prototype._destroyTemplateClones=function(){for(var i=0;i<this._aTemplateClones.length;i++){if(this._aTemplateClones[i]!=null&&!this._aTemplateClones[i].bIsDestroyed){this._aTemplateClones[i].destroy();}}this._aTemplateClones=[];};
return j;});
sap.ui.predefine('sap/ui/table/ColumnMenu',['jquery.sap.global','sap/ui/core/RenderManager','./library','sap/ui/unified/Menu','sap/ui/unified/MenuItem','sap/ui/unified/MenuTextFieldItem','sap/ui/Device','./TableUtils'],function(q,R,a,M,b,c,D,T){"use strict";
var C=M.extend("sap.ui.table.ColumnMenu",{
metadata:{library:"sap.ui.table"},
renderer:"sap.ui.unified.MenuRenderer"
});
C.prototype.init=function(){if(M.prototype.init){M.prototype.init.apply(this,arguments);}this.addStyleClass("sapUiTableColumnMenu");this._oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.table");this._bInvalidated=true;this._iPopupClosedTimeoutId=null;this._oColumn=null;this._oTable=null;this._attachPopupClosed();};
C.prototype.exit=function(){if(M.prototype.exit){M.prototype.exit.apply(this,arguments);}window.clearTimeout(this._iPopupClosedTimeoutId);this._detachEvents();this._oColumn=this._oTable=null;};
C.prototype.onThemeChanged=function(){if(this.getDomRef()){this._invalidate();}};
C.prototype.setParent=function(p){this._detachEvents();this._invalidate();this._updateReferences(p);this._attachEvents();return M.prototype.setParent.apply(this,arguments);};
C.prototype._updateReferences=function(p){this._oColumn=p;if(p){this._oTable=this._oColumn.getParent();if(this._oTable){}}};
C.prototype._attachEvents=function(){if(this._oTable){this._oTable.attachColumnVisibility(this._invalidate,this);this._oTable.attachColumnMove(this._invalidate,this);}};
C.prototype._detachEvents=function(){if(this._oTable){this._oTable.detachColumnVisibility(this._invalidate,this);this._oTable.detachColumnMove(this._invalidate,this);}};
C.prototype._invalidate=function(){this._bInvalidated=true;};
C.prototype._updateResourceBundle=function(){this._oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.table");this._invalidate();};
C.prototype._attachPopupClosed=function(){var t=this;if(!D.support.touch){this.getPopup().attachClosed(function(){t._iPopupClosedTimeoutId=window.setTimeout(function(){if(t._oColumn){if(t._lastFocusedDomRef){t._lastFocusedDomRef.focus();}else{t._oColumn.focus();}}},0);});}};
C.prototype.open=function(){if(this._bInvalidated){this._bInvalidated=false;this.destroyItems();this._addMenuItems();}if(this.getItems().length>0){this._lastFocusedDomRef=arguments[4];M.prototype.open.apply(this,arguments);}};
C.prototype._addMenuItems=function(){if(this._oColumn){this._addSortMenuItem(false);this._addSortMenuItem(true);this._addFilterMenuItem();this._addGroupMenuItem();this._addFreezeMenuItem();this._addColumnVisibilityMenuItem();}};
C.prototype._addSortMenuItem=function(d){var o=this._oColumn;if(o.isSortableByMenu()){var s=d?"desc":"asc";var i=d?"sort-descending":"sort-ascending";this.addItem(this._createMenuItem(s,"TBL_SORT_"+s.toUpperCase(),i,function(e){o.sort(d,e.getParameter("ctrlKey")===true);}));}};
C.prototype._addFilterMenuItem=function(){var o=this._oColumn;if(o.isFilterableByMenu()){var t=o.getParent();var d=t&&t.getEnableCustomFilter();if(d){this.addItem(this._createMenuItem("filter","TBL_FILTER_ITEM","filter",function(){t.fireCustomFilter({column:o});}));}else{this.addItem(this._createMenuTextFieldItem("filter","TBL_FILTER","filter",o.getFilterValue(),function(){o.filter(this.getValue());}));}}};
C.prototype._addGroupMenuItem=function(){var o=this._oColumn;if(o.isGroupableByMenu()){var t=this._oTable;this.addItem(this._createMenuItem("group","TBL_GROUP",null,function(){t.setGroupBy(o);}));}};
C.prototype._addFreezeMenuItem=function(){var o=this._oColumn;var t=this._oTable;var d=t&&t.getEnableColumnFreeze();if(d){var i=o.getIndex();var I=i+T.Column.getHeaderSpan(o)==t.getFixedColumnCount();this.addItem(this._createMenuItem("freeze",I?"TBL_UNFREEZE":"TBL_FREEZE",null,function(){var e=t.fireColumnFreeze({column:o});if(e){if(I){t.setFixedColumnCount(0);}else{t.setFixedColumnCount(i+1);}}}));}};
C.prototype._addColumnVisibilityMenuItem=function(){var t=this._oTable;if(t&&t.getShowColumnVisibilityMenu()){var o=this._createMenuItem("column-visibilty","TBL_COLUMNS");this.addItem(o);var d=new M(o.getId()+"-menu");o.setSubmenu(d);var e=t.getColumns();if(t.getColumnVisibilityMenuSorter&&typeof t.getColumnVisibilityMenuSorter==="function"){var s=t.getColumnVisibilityMenuSorter();if(typeof s==="function"){e=e.sort(s);}}var B=t.getBinding();var A=T.isInstanceOf(B,"sap/ui/model/analytics/AnalyticalBinding");for(var i=0,l=e.length;i<l;i++){var f=e[i];if(A&&T.isInstanceOf(f,"sap/ui/table/AnalyticalColumn")){var Q=B.getAnalyticalQueryResult();var E=Q.getEntityType();var m=B.getModel().getProperty("/#"+E.getTypeDescription().name+"/"+f.getLeadingProperty()+"/sap:visible");if(m&&(m.value==="false"||m.value===false)){continue;}}var g=this._createColumnVisibilityMenuItem(d.getId()+"-item-"+i,f);d.addItem(g);}}};
C.prototype._createColumnVisibilityMenuItem=function(i,o){function g(l){return l&&l.getText&&l.getText();}var t=o.getName()||g(o.getLabel());if(!t){o.getMultiLabels().forEach(function(l,d){if(T.Column.getHeaderSpan(o,d)===1){t=g(l)||t;}});}return new b(i,{text:t,icon:o.getVisible()?"sap-icon://accept":null,select:q.proxy(function(e){var m=e.getSource();var v=!o.getVisible();if(v||T.getVisibleColumnCount(this._oTable)>1){var d=o.getParent();var E=true;if(d&&T.isInstanceOf(d,"sap/ui/table/Table")){E=d.fireColumnVisibility({column:o,newVisible:v});}if(E){o.setVisible(v);}m.setIcon(v?"sap-icon://accept":null);}},this)});};
C.prototype._createMenuItem=function(i,t,I,h){return new b(this.getId()+"-"+i,{text:this._oResBundle.getText(t),icon:I?"sap-icon://"+I:null,select:h||function(){}});};
C.prototype._createMenuTextFieldItem=function(i,t,I,v,h){h=h||function(){};return new c(this.getId()+"-"+i,{label:this._oResBundle.getText(t),icon:I?"sap-icon://"+I:null,value:v,select:h||function(){}});};
C.prototype._setFilterValue=function(v){var o=this.getParent();var t=(o?o.getParent():undefined);var f=sap.ui.getCore().byId(this.getId()+"-filter");if(f&&(t&&!t.getEnableCustomFilter())){f.setValue(v);}return this;};
C.prototype._setFilterState=function(f){var o=this.getParent();var t=(o?o.getParent():undefined);var F=sap.ui.getCore().byId(this.getId()+"-filter");if(F&&(t&&!t.getEnableCustomFilter())){F.setValueState(f);}return this;};
return C;});
sap.ui.predefine('sap/ui/table/ColumnMenuRenderer',['sap/ui/table/ColumnMenu'],function(M){"use strict";return M.getMetadata().getRenderer();},true);
sap.ui.predefine('sap/ui/table/Row',['jquery.sap.global','sap/ui/core/Element','sap/ui/model/Context','./TableUtils'],function(q,E,C,T){"use strict";
var R=E.extend("sap.ui.table.Row",{metadata:{library:"sap.ui.table",defaultAggregation:"cells",aggregations:{cells:{type:"sap.ui.core.Control",multiple:true,singularName:"cell"},_rowAction:{type:"sap.ui.table.RowAction",multiple:false,visibility:"hidden"},_settings:{type:"sap.ui.table.RowSettings",multiple:false,visibility:"hidden"}}}});
R.prototype.init=function(){this.initDomRefs();};
R.prototype.exit=function(){this.initDomRefs();};
R.prototype.getFocusInfo=function(){var t=this.getParent();return t?t.getFocusInfo():E.prototype.getFocusInfo.apply(this,arguments);};
R.prototype.applyFocusInfo=function(f){var t=this.getParent();if(t){t.applyFocusInfo(f);}else{E.prototype.applyFocusInfo.apply(this,arguments);}return this;};
R.prototype.initDomRefs=function(){this._mDomRefs={};};
R.prototype.getIndex=function(){var t=this.getParent();if(t){var r=t.indexOfRow(this);var n=t.getFixedRowCount();if(n>0&&r<n){return r;}var N=t.getFixedBottomRowCount();var v=t.getVisibleRowCount();if(N>0&&r>=v-N){var b=t.getBinding("rows");if(b&&b.getLength()>=v){return b.getLength()-(v-r);}else{return r;}}var f=t.getFirstVisibleRow();return f+r;}return-1;};
R.prototype.getDomRefs=function(j){var a;var k;if(j===true){a=q.sap.byId;k="jQuery";}else{a=q.sap.domById;k="dom";}if(!this._mDomRefs[k]){this._mDomRefs[k]={};var t=this.getParent();if(t){var r=t.indexOfRow(this);this._mDomRefs[k].rowSelector=a(t.getId()+"-rowsel"+r);this._mDomRefs[k].rowAction=a(t.getId()+"-rowact"+r);}this._mDomRefs[k].rowScrollPart=a(this.getId());this._mDomRefs[k].rowFixedPart=a(this.getId()+"-fixed");this._mDomRefs[k].rowSelectorText=a(this.getId()+"-rowselecttext");if(j===true){this._mDomRefs[k].row=this._mDomRefs[k].rowScrollPart;if(this._mDomRefs[k].rowFixedPart.length>0){this._mDomRefs[k].row=this._mDomRefs[k].row.add(this._mDomRefs[k].rowFixedPart);}else{this._mDomRefs[k].rowFixedPart=undefined;}if(this._mDomRefs[k].rowSelector&&this._mDomRefs[k].rowSelector.length>0){this._mDomRefs[k].row=this._mDomRefs[k].row.add(this._mDomRefs[k].rowSelector);}else{this._mDomRefs[k].rowSelector=undefined;}if(this._mDomRefs[k].rowAction&&this._mDomRefs[k].rowAction.length>0){this._mDomRefs[k].row=this._mDomRefs[k].row.add(this._mDomRefs[k].rowAction);}else{this._mDomRefs[k].rowAction=undefined;}}}return this._mDomRefs[k];};
R.prototype._updateSelection=function(t,m,s){var i=t.isIndexSelected(this.getIndex());var d=this.getDomRefs(true);var S="rowSelect";if(i){S="rowDeselect";}if(d.rowSelector){d.rowSelector.attr("title",m.mouse[S]);}if(d.rowSelectorText){var a="";if(!this._bHidden&&!T.Grouping.isInSumRow(d.rowSelector)&&!T.Grouping.isInGroupingRow(d.rowSelector)){a=m.keyboard[S];}d.rowSelectorText.text(a);}var r=d.rowScrollPart;if(d.rowFixedPart){r=r.add(d.rowFixedPart);}if(s){r.attr("title",m.mouse[S]);}else{r.removeAttr("title");}if(d.row){d.row.toggleClass("sapUiTableRowSel",i);t._getAccExtension().updateAriaStateOfRow(this,d,i);}};
R.prototype.setRowBindingContext=function(c,m,b){var n;if(c&&!(c instanceof C)){n=c;c=c.context;}var $=this.getDomRefs(true).row;this._bHidden=!c;$.toggleClass("sapUiTableRowHidden",this._bHidden);this._collectRenderingInformation(c,n,b);this.setBindingContext(c,m);};
R.prototype.setBindingContext=function(c,m){var r=E.prototype.setBindingContext.call(this,c||null,m);this._updateTableCells(c);return r;};
R.prototype._updateTableCells=function(c){var t=this.getParent();if(!t){return;}var a=this.getCells(),A=this.getIndex(),h=!!t._updateTableCell,o,$,H;for(var i=0;i<a.length;i++){o=a[i];H=!!o._updateTableCell;$=H||h?o.$().closest("td"):null;if(H){o._updateTableCell(o,c,$,A);}if(h){t._updateTableCell(o,c,$,A);}}};
R.prototype._collectRenderingInformation=function(c,n,b){this._oNodeState=undefined;this._iLevel=0;this._bIsExpanded=false;this._bHasChildren=false;this._sTreeIconClass="";if(n){this._oNodeState=n.nodeState;this._iLevel=n.level;this._bIsExpanded=false;this._bHasChildren=false;this._sTreeIconClass="sapUiTableTreeIconLeaf";this._sGroupIconClass="";if(b){if(b.getLevel){this._bIsExpanded=b.isExpanded(this.getIndex());}else if(b.findNode){this._bIsExpanded=this&&this._oNodeState?this._oNodeState.expanded:false;}if(b.nodeHasChildren){if(this._oNodeState){this._bHasChildren=b.nodeHasChildren(n);}}else if(b.hasChildren){this._bHasChildren=b.hasChildren(c);}if(this._bHasChildren){this._sTreeIconClass=this._bIsExpanded?"sapUiTableTreeIconNodeOpen":"sapUiTableTreeIconNodeClosed";this._sGroupIconClass=this._bIsExpanded?"sapUiTableGroupIconOpen":"sapUiTableGroupIconClosed";}}}};
R.prototype.destroy=function(){this.removeAllCells();return E.prototype.destroy.apply(this,arguments);};
return R;});
sap.ui.predefine('sap/ui/table/RowAction',['jquery.sap.global','sap/ui/core/Control','./TableUtils','./library','sap/ui/core/Icon','sap/ui/unified/Menu','sap/ui/core/Popup','./RowActionItem'],function(q,C,T,l,I,M,P,R){"use strict";
var a=C.extend("sap.ui.table.RowAction",{metadata:{library:"sap.ui.table",properties:{visible:{type:"boolean",group:"Misc",defaultValue:true}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.table.RowActionItem",multiple:true},_icons:{type:"sap.ui.core.Icon",multiple:true,visibility:"hidden"},_menu:{type:"sap.ui.unified.Menu",multiple:false,visibility:"hidden"}},events:{}}});
a.prototype.init=function(){var s=function(v){this.setAggregation("tooltip",v,true);this.setSrc(this.getSrc());return this;};var o=function(e){this._bKeyboard=e.which===q.sap.KeyCodes.SPACE||e.which===q.sap.KeyCodes.ENTER;I.prototype.onkeyup.apply(this,arguments);};var t=this;var i=new I(this.getId()+"-icon0",{decorative:false,press:function(e){t._handlePress(e,true);}});i.addStyleClass("sapUiTableActionIcon");i.setTooltip=s;i.onkeyup=o;this.addAggregation("_icons",i);i=new I(this.getId()+"-icon1",{decorative:false,press:function(e){t._handlePress(e,false);}});i.addStyleClass("sapUiTableActionIcon");i.setTooltip=s;i.onkeyup=o;this.addAggregation("_icons",i);this._oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.table");this._iLen=0;this._iCount=2;this._aActions=["",""];this._iLastCloseTime=0;};
a.prototype.onAfterRendering=function(){this._updateIcons();};
a.prototype.setVisible=function(v){this.setProperty("visible",v,true);this.$().toggleClass("sapUiTableActionHidden",!v);return this;};
a.prototype.setTooltip=function(t){this.setAggregation("tooltip",t,true);var s=this.getTooltip_AsString();if(!s){this.$().removeAttr("title");}else{this.$().attr("title",s);}return this;};
a.prototype.insertItem=function(i,b){this.insertAggregation("items",i,b,true);this._updateIcons(true);return this;};
a.prototype.addItem=function(i){this.addAggregation("items",i,true);this._updateIcons(true);return this;};
a.prototype.removeItem=function(i){var r=this.removeAggregation("items",i,true);this._updateIcons(true);return r;};
a.prototype.removeAllItems=function(){var r=this.removeAllAggregation("items",true);this._updateIcons(true);return r;};
a.prototype.destroyItems=function(){this.destroyAggregation("items",true);this._updateIcons(true);return this;};
a.prototype.getAccessibilityInfo=function(){var p=this.$().parent();var A=this.getVisible()&&this._iLen>0&&this._iCount>0&&!p.hasClass("sapUiTableRowHidden")&&!p.hasClass("sapUiTableGroupHeader")&&!p.hasClass("sapUiAnalyticalTableSum");var t;if(A){t=this._oResBundle.getText(this._iLen==1?"TBL_ROW_ACTION_SINGLE_ACTION":"TBL_ROW_ACTION_MULTIPLE_ACTION",[this._iLen]);}else{t=this._oResBundle.getText("TBL_ROW_ACTION_NO_ACTION");}return{focusable:A,enabled:A,description:t};};
a.prototype._getVisibleItems=function(f){if(!this._aVisibleItems||f){this._aVisibleItems=[];this._iLen=0;var b=this.getItems();for(var i=0;i<b.length;i++){if(b[i].getVisible()){this._aVisibleItems.push(b[i]);this._iLen++;}}}return this._aVisibleItems;};
a.prototype._getRow=function(){return this.getParent();};
a.prototype._getCount=function(){return this._iCount;};
a.prototype._setCount=function(c){if(c<0){this._iCount=0;}else if(c>=0){this._iCount=Math.min(c,2);}this._updateIcons();};
a.prototype._setFixedLayout=function(f){this._bFixedLayout=!!f;this._updateIcons();};
a.prototype._setIconLabel=function(L){var b=this.getAggregation("_icons");for(var i=0;i<b.length;i++){b[i].removeAllAriaLabelledBy();if(L){b[i].addAriaLabelledBy(L);}}};
a.prototype._handlePress=function(e,f){var b=f?0:1;var o=this.getAggregation("_icons")[b];var A=this._aActions[b];var k=o._bKeyboard;o._bKeyboard=false;if(A=="action"){this._getVisibleItems()[b]._doFirePress();}else if(A=="action_fixed"){this._getVisibleItems()[0]._doFirePress();}else if(A=="menu"){var m=this.getAggregation("_menu");if(!m){m=new M();this.setAggregation("_menu",m,true);m.getPopup().attachClosed(function(){this._iLastCloseTime=Date.now();},this);}m.removeAllItems();if(Date.now()-this._iLastCloseTime<500){return;}var c=this.getItems();for(var i=f?0:1;i<c.length;i++){m.addItem(c[i]._getMenuItem());}m.open(!!k,o,P.Dock.EndTop,P.Dock.EndBottom,o);}};
a.prototype._updateIcons=function(f){var i=this._getVisibleItems(f);var b=this.getAggregation("_icons");var $=this.$().children();function s(c){b[0].$()[c==0?"attr":"removeAttr"]("aria-haspopup",c==0?"true":undefined);b[1].$()[c==1?"attr":"removeAttr"]("aria-haspopup",c==1?"true":undefined);}if(this._bFixedLayout&&this._iLen==1&&this._iCount==2){var A=this.getItems();if(A.length>1&&i[0]===A[1]){i[0]._syncIcon(b[1]);q($.get(0)).toggleClass("sapUiTableActionHidden",true);q($.get(1)).toggleClass("sapUiTableActionHidden",false);s(-1);this._aActions=["","action_fixed"];return;}}if(this._iLen==0||this._iCount==0){$.toggleClass("sapUiTableActionHidden",true);s(-1);this._aActions=["",""];}else if(this._iLen==1&&this._iCount>0){i[0]._syncIcon(b[0]);q($.get(0)).toggleClass("sapUiTableActionHidden",false);q($.get(1)).toggleClass("sapUiTableActionHidden",true);s(-1);this._aActions=["action",""];}else if(this._iLen==2&&this._iCount==2){i[0]._syncIcon(b[0]);i[1]._syncIcon(b[1]);$.toggleClass("sapUiTableActionHidden",false);s(-1);this._aActions=["action","action"];}else if(this._iLen>2&&this._iCount==2){i[0]._syncIcon(b[0]);b[1].setSrc("sap-icon://overflow");b[1].setTooltip(this._oResBundle.getText("TBL_ROW_ACTION_MORE"));$.toggleClass("sapUiTableActionHidden",false);s(1);this._aActions=["action","menu"];}else{b[0].setSrc("sap-icon://overflow");b[0].setTooltip(this._oResBundle.getText("TBL_ROW_ACTION_MORE"));q($.get(0)).toggleClass("sapUiTableActionHidden",false);q($.get(1)).toggleClass("sapUiTableActionHidden",true);s(0);this._aActions=["menu",""];}};
return a;});
sap.ui.predefine('sap/ui/table/RowActionItem',['sap/ui/core/Element','./library','sap/ui/unified/MenuItem'],function(E,l,M){"use strict";var R=l.RowActionType;
var I=E.extend("sap.ui.table.RowActionItem",{metadata:{library:"sap.ui.table",properties:{icon:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},visible:{type:"boolean",group:"Misc",defaultValue:true},text:{type:"string",group:"Misc",defaultValue:""},type:{type:"sap.ui.table.RowActionType",group:"Behavior",defaultValue:R.Custom}},events:{press:{item:{type:"sap.ui.table.RowActionItem"},row:{type:"sap.ui.table.Row"}}}}});
I.prototype.exit=function(){if(this._menuItem){this._menuItem.destroy();this._menuItem=null;}};
I.prototype.setIcon=function(i){this.setProperty("icon",i,true);this._updateRowAction();return this;};
I.prototype.setText=function(t){this.setProperty("text",t,true);this._updateRowAction();return this;};
I.prototype.setType=function(t){this.setProperty("type",t,true);this._updateRowAction();return this;};
I.prototype.setVisible=function(v){this.setProperty("visible",v,true);this._updateRowAction(true);return this;};
I.prototype.setTooltip=function(t){this.setAggregation("tooltip",t,true);this._updateRowAction();return this;};
I.prototype._doFirePress=function(){var p=this.getParent();this.firePress({item:this,row:p&&p._getRow?p._getRow():null});};
I.prototype._getMenuItem=function(){if(!this._menuItem){var t=this;this._menuItem=new M({select:function(e){t._doFirePress();}});}this._menuItem.setIcon(this._getIcon());this._menuItem.setVisible(this.getVisible());this._menuItem.setText(this._getText(false));return this._menuItem;};
I.prototype._getIcon=function(){var i=this.getIcon();if(i){return i;}if(this.getType()==R.Navigation){return"sap-icon://navigation-right-arrow";}if(this.getType()==R.Delete){return"sap-icon://sys-cancel";}return null;};
I.prototype._getText=function(p){var t=p?(this.getTooltip_AsString()||this.getText()):(this.getText()||this.getTooltip_AsString());if(t){return t;}if(this.getType()==R.Navigation){return this.getParent()._oResBundle.getText("TBL_ROW_ACTION_NAVIGATE");}if(this.getType()==R.Delete){return this.getParent()._oResBundle.getText("TBL_ROW_ACTION_DELETE");}return null;};
I.prototype._syncIcon=function(i){i.setSrc(this._getIcon());i.setTooltip(this._getText(true));};
I.prototype._updateRowAction=function(f){var p=this.getParent();if(p&&p._updateIcons){p._updateIcons(f);}};
return I;});
sap.ui.predefine('sap/ui/table/RowActionRenderer',['jquery.sap.global','sap/ui/table/Row'],function(q,R){"use strict";var a={};
a.render=function(r,A){r.write("<div");r.writeControlData(A);r.addClass("sapUiTableAction");if(!(A.getParent()instanceof R)){r.addStyle("display","none");}if(!A.getVisible()){r.addClass("sapUiTableActionHidden");}r.writeClasses();r.writeStyles();var t=A.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}r.write(">");var i=A.getAggregation("_icons");r.write("<div>");r.renderControl(i[0]);r.write("</div>");r.write("<div>");r.renderControl(i[1]);r.write("</div>");r.write("</div>");};
return a;},true);
sap.ui.predefine('sap/ui/table/RowSettings',['jquery.sap.global','sap/ui/core/Element','./TableUtils','./library',"sap/ui/core/library"],function(q,E,T,l,c){"use strict";var M=c.MessageType;
var R=E.extend("sap.ui.table.RowSettings",{metadata:{library:"sap.ui.table",properties:{highlight:{type:"sap.ui.core.MessageType",group:"Appearance",defaultValue:"None"}}}});
R.prototype.init=function(){this._oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.table");};
R.prototype.setHighlight=function(h){var r;var H;this.setProperty("highlight",h,true);r=this._getRow();if(r==null){return this;}H=r.getDomRef("highlight");if(H==null){return this;}for(var m in M){H.classList.remove("sapUiTableRowHighlight"+m);}H.classList.add(this._getHighlightCSSClassName());var t=r.getParent();var a=t!=null?t._getAccExtension():null;if(a!=null){a.updateAriaStateOfRowHighlight(this);}return this;};
R.prototype._getHighlightCSSClassName=function(){var h=this.getHighlight();if(h==null){h=M.None;}return"sapUiTableRowHighlight"+h;};
R.prototype._getHighlightText=function(){var h=this.getHighlight();if(h==null||h===M.None){return"";}return this._oResBundle.getText("TBL_ROW_STATE_"+h.toUpperCase());};
R.prototype._getRow=function(){var r=this.getParent();if(T.isInstanceOf(r,"sap/ui/table/Row")){return r;}else{return null;}};
return R;});
sap.ui.predefine('sap/ui/table/Table.designtime',[],function(){"use strict";return{aggregations:{columns:{domRef:".sapUiTableCHA"},hScroll:{ignore:false,domRef:function(e){return e.$("hsb").get(0);}},vScroll:{ignore:false,domRef:function(e){return e.$("vsb").get(0);}}}};},false);
sap.ui.predefine('sap/ui/table/Table',['jquery.sap.global','sap/ui/Device','sap/ui/core/Control','sap/ui/core/Element','sap/ui/core/IconPool','sap/ui/core/ResizeHandler','sap/ui/core/ScrollBar','sap/ui/core/delegate/ItemNavigation','sap/ui/core/theming/Parameters','sap/ui/model/ChangeReason','sap/ui/model/Context','sap/ui/model/Filter','sap/ui/model/SelectionModel','sap/ui/model/Sorter',"sap/ui/model/BindingMode",'./Column','./Row','./library','./TableUtils','./TableExtension','./TableAccExtension','./TableKeyboardExtension','./TablePointerExtension','./TableScrollExtension','jquery.sap.dom','jquery.sap.trace'],function(q,D,C,E,I,R,S,c,P,d,e,F,f,g,B,h,j,k,T,m,n,o,p,r){"use strict";var G=k.GroupEventType,N=k.NavigationMode,s=k.SelectionMode,t=k.SelectionBehavior,u=k.SortOrder,V=k.VisibleRowCountMode;
var v=C.extend("sap.ui.table.Table",{metadata:{library:"sap.ui.table",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'},rowHeight:{type:"int",group:"Appearance",defaultValue:null},columnHeaderHeight:{type:"int",group:"Appearance",defaultValue:null},columnHeaderVisible:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCount:{type:"int",group:"Appearance",defaultValue:10},firstVisibleRow:{type:"int",group:"Appearance",defaultValue:0},selectionMode:{type:"sap.ui.table.SelectionMode",group:"Behavior",defaultValue:s.MultiToggle},selectionBehavior:{type:"sap.ui.table.SelectionBehavior",group:"Behavior",defaultValue:t.RowSelector},selectedIndex:{type:"int",group:"Appearance",defaultValue:-1},editable:{type:"boolean",group:"Behavior",defaultValue:true},navigationMode:{type:"sap.ui.table.NavigationMode",group:"Behavior",defaultValue:N.Scrollbar},threshold:{type:"int",group:"Appearance",defaultValue:100},enableColumnReordering:{type:"boolean",group:"Behavior",defaultValue:true},enableGrouping:{type:"boolean",group:"Behavior",defaultValue:false},showColumnVisibilityMenu:{type:"boolean",group:"Appearance",defaultValue:false},showNoData:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCountMode:{type:"sap.ui.table.VisibleRowCountMode",group:"Appearance",defaultValue:V.Fixed},minAutoRowCount:{type:"int",group:"Appearance",defaultValue:5},fixedColumnCount:{type:"int",group:"Appearance",defaultValue:0},fixedRowCount:{type:"int",group:"Appearance",defaultValue:0},fixedBottomRowCount:{type:"int",group:"Appearance",defaultValue:0},enableColumnFreeze:{type:"boolean",group:"Behavior",defaultValue:false},enableCellFilter:{type:"boolean",group:"Behavior",defaultValue:false},showOverlay:{type:"boolean",group:"Appearance",defaultValue:false},enableSelectAll:{type:"boolean",group:"Behavior",defaultValue:true},enableCustomFilter:{type:"boolean",group:"Behavior",defaultValue:false},enableBusyIndicator:{type:"boolean",group:"Behavior",defaultValue:false},rowActionCount:{type:"int",group:"Appearance",defaultValue:0}},defaultAggregation:"columns",aggregations:{title:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},footer:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},toolbar:{type:"sap.ui.core.Toolbar",multiple:false,deprecated:true},extension:{type:"sap.ui.core.Control",multiple:true,singularName:"extension"},columns:{type:"sap.ui.table.Column",multiple:true,singularName:"column",bindable:"bindable"},rows:{type:"sap.ui.table.Row",multiple:true,singularName:"row",bindable:"bindable"},noData:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},rowActionTemplate:{type:"sap.ui.table.RowAction",multiple:false},rowSettingsTemplate:{type:"sap.ui.table.RowSettings",multiple:false}},associations:{groupBy:{type:"sap.ui.table.Column",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{rowSelectionChange:{parameters:{rowIndex:{type:"int"},rowContext:{type:"object"},rowIndices:{type:"int[]"},selectAll:{type:"boolean"},userInteraction:{type:"boolean"}}},columnSelect:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},columnResize:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},width:{type:"sap.ui.core.CSSSize"}}},columnMove:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},newPos:{type:"int"}}},sort:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},sortOrder:{type:"sap.ui.table.SortOrder"},columnAdded:{type:"boolean"}}},filter:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},value:{type:"string"}}},group:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},columnVisibility:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},visible:{type:"boolean"}}},cellClick:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},cellDomRef:{type:"Object"},rowIndex:{type:"int"},columnIndex:{type:"int"},columnId:{type:"string"},rowBindingContext:{type:"sap.ui.model.Context"}}},cellContextmenu:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},cellDomRef:{type:"Object"},rowIndex:{type:"int"},columnIndex:{type:"int"},columnId:{type:"string"},rowBindingContext:{type:"sap.ui.model.Context"}}},columnFreeze:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},customFilter:{column:{type:"sap.ui.table.Column"},value:{type:"string"}},firstVisibleRowChanged:{firstVisibleRow:{type:"int"}},busyStateChanged:{busy:{type:"boolean"}}},designTime:true}});
I.insertFontFaceStyle();
v.prototype.init=function(){this._iBaseFontSize=parseFloat(q("body").css("font-size"))||16;this._oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.table");this._bRtlMode=sap.ui.getCore().getConfiguration().getRTL();this._attachExtensions();this._bBindingLengthChanged=false;this._bRowAggregationInvalid=true;this._mTimeouts={};this._bHideStandardTooltips=false;this._lastCalledUpdateRows=0;this._iBindingTimerDelay=50;this._iMaxScrollbarHeight=1000000;this._aRowHeights=[];this._iRowHeightsDelta=0;this._iRenderedFirstVisibleRow=0;this._aSortedColumns=[];var a=this;this._performUpdateRows=function(b){if(!a.bIsDestroyed){a._lastCalledUpdateRows=Date.now();a._updateBindingContexts();if(!a._bInvalid){a._updateTableContent();a._getAccExtension().updateAccForCurrentCell(false);a._updateSelection();a._collectTableSizes();a._aRowHeights=a._collectRowHeights(false);a._updateRowHeights(a._collectRowHeights(true),true);a._updateRowHeights(a._aRowHeights,false);if(T.isVariableRowHeightEnabled(a)){a._iRowHeightsDelta=this._getRowHeightsDelta(a._aRowHeights);a._iRenderedFirstVisibleRow=this.getFirstVisibleRow();}if(a._bBindingLengthChanged){a._updateVSbScrollTop();}a._toggleVSb();if(T.isVariableRowHeightEnabled(a)){var i=0;var l=a._getScrollExtension().getVerticalScrollbar();if(l){i=l.scrollTop;}a._adjustTablePosition(i,a._aRowHeights);}}a._mTimeouts.bindingTimer=undefined;a._fireRowsUpdated(b);}a._bBindingLengthChanged=false;};this._initSelectionModel(f.MULTI_SELECTION);this._aTableHeaders=[];this._aIdxCols2Cells=[];this._bInheritEditableToControls=false;this._bAllowColumnHeaderTextSelection=false;this._iPendingRequests=0;this._bPendingRequest=false;this._iTableRowContentHeight=0;this._bFirstRendering=true;this._bInvalid=true;this._bIsScrollVertical=null;};
v.prototype._attachExtensions=function(){if(this._bExtensionsInitialized){return;}m.enrich(this,p);m.enrich(this,r);m.enrich(this,o);m.enrich(this,n);this._bExtensionsInitialized=true;};
v.prototype.exit=function(){this._bExitCalled=true;this.invalidateRowsAggregation();this._detachExtensions();if(this._dataReceivedHandlerId!=null){q.sap.clearDelayedCall(this._dataReceivedHandlerId);delete this._dataReceivedHandlerId;}this._cleanUpTimers();this._detachEvents();if(this._oSelection){this._oSelection.destroy();}delete this._aTableHeaders;};
v.prototype._detachExtensions=function(){m.cleanup(this);};
v.prototype.onThemeChanged=function(){if(this.getDomRef()){this.invalidate();}};
v.prototype.onlocalizationChanged=function(a){var b=a.changes||{};var i=b.hasOwnProperty("rtl");var l=b.hasOwnProperty("language");if(i||l){this._adaptLocalization(i,l);this.invalidate();}};
v.prototype._adaptLocalization=function(b,l){if(b){this._bRtlMode=sap.ui.getCore().getConfiguration().getRTL();}if(l){var a=this.getRows();var i;this._oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.table");var w;for(i=0;i<a.length;i++){w=a[i].getAggregation("_rowAction");if(w){w._oResBundle=this._oResBundle;}}var x;for(i=0;i<a.length;i++){x=a[i].getAggregation("_settings");if(x){x._oResBundle=this._oResBundle;}}T.Menu.cleanupDataCellContextMenu(this);this._invalidateColumnMenus(true);}};
v.prototype._collectRowHeights=function(H){var a=this.getDomRef();if(!a){return[];}if(H&&this.getColumnHeaderHeight()){return[];}var b=this._getDefaultRowHeight();var l=H?".sapUiTableColHdrTr":".sapUiTableTr";var w=a.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr"+l);var x=a.querySelectorAll(".sapUiTableCtrlScroll > tbody > tr"+l);var y=this.getRows().length;var z=[];var A=D.browser.chrome&&window.devicePixelRatio!=1;for(var i=0;i<y;i++){var J=w[i]==null?0:w[i].getBoundingClientRect().height;var K=x[i]==null?0:x[i].getBoundingClientRect().height;var L=Math.max(J,K);if(A){var M=b-L;if(M>0&&M<1){z.push(Math.max(L,b-1));continue;}}z.push(Math.max(L,b));}return z;};
v.prototype._resetRowHeights=function(){var a=this.getRowHeight();var b="";if(a){b=a+"px";}var l=this.getDomRef();if(l){var w=l.querySelectorAll(".sapUiTableTr");for(var i=0;i<w.length;i++){w[i].style.height=b;}}};
v.prototype._resetColumnHeaderHeights=function(){if(this.getColumnHeaderHeight()){return;}var a=this.getDomRef();if(a){var b=a.querySelectorAll(".sapUiTableColHdrTr");for(var i=0;i<b.length;i++){b[i].style.height=null;}}};
v.prototype._determineAvailableSpace=function(){var a=this.getDomRef();if(a&&a.parentNode){var b=a.querySelector(".sapUiTableCCnt");if(b){var U=a.scrollHeight-b.clientHeight;var i=0;if(a.parentNode.firstChild!==a){var l=parseFloat(window.getComputedStyle(a.parentNode).paddingTop);if(isNaN(l)){l=0;}i=a.offsetTop-l;}U+=18;return Math.floor(q(a.parentNode).height()-U-i);}}return 0;};
v.prototype._collectTableSizes=function(){var a={tableCtrlScrollWidth:0,tableRowHdrScrWidth:0,tableCtrlScrWidth:0,tableHSbScrollLeft:0,tableCtrlFixedWidth:0,tableCntHeight:0,tableCntWidth:0};var b=this.getDomRef();if(!b){return a;}var l=b.querySelector(".sapUiTableCnt");if(l){a.tableCntHeight=l.clientHeight;a.tableCntWidth=l.clientWidth;}var w=b.querySelector(".sapUiTableCtrlScroll:not(.sapUiTableCHT)");if(w){a.tableCtrlScrollWidth=w.clientWidth;}var x=b.querySelector(".sapUiTableRowHdrScr");if(x){a.tableRowHdrScrWidth=x.clientWidth;}var y=b.querySelector(".sapUiTableCtrlScr:not(.sapUiTableCHA)");if(y){a.tableCtrlScrWidth=y.clientWidth;}var H=this._getScrollExtension().getHorizontalScrollbar();if(H){a.tableHSbScrollLeft=H.scrollLeft;}var z=b.querySelector(".sapUiTableCtrlScrFixed:not(.sapUiTableCHA) > .sapUiTableCtrlFixed");if(z){a.tableCtrlFixedWidth=z.clientWidth;}var A=this.getProperty("fixedColumnCount");var J=0;if(A){var K=b.querySelectorAll(".sapUiTableCtrlFirstCol:not(.sapUiTableCHTHR) > th");for(var i=0;i<K.length;i++){var L=parseInt(K[i].getAttribute("data-sap-ui-headcolindex"),10);if(!isNaN(L)&&(L<A)){J+=K[i].getBoundingClientRect().width;}}}if(J>0){var U=a.tableRowHdrScrWidth;var M=this.getDomRef("vsb");if(M){U+=M.offsetWidth;}if(T.hasRowActions(this)){var O=this.getDomRef("sapUiTableRowActionScr");if(O){U+=O.offsetWidth;}}var Q=a.tableCtrlScrollWidth===a.tableCtrlScrWidth;if(!Q){U+=T.Column.getMinColumnWidth();}var W=a.tableCtrlFixedWidth+U<=a.tableCntWidth;var X=false;if(!Q||!W){X=(a.tableCntWidth-U<J);}if(this._bIgnoreFixedColumnCount!==X){this._bIgnoreFixedColumnCount=X;this.invalidate();}}return a;};
v.prototype._updateRowHeights=function(b,H){var i=this.getDomRef();if(!i){return;}if(H&&this.getColumnHeaderHeight()){return;}function l(J,K){var L=b[K];if(L){J.style.height=L+"px";}}var w=H?".sapUiTableColHdrTr":".sapUiTableTr";var x=H?[]:i.querySelectorAll(".sapUiTableRowHdr");var y=H?[]:i.querySelectorAll(".sapUiTableRowAction");var z=i.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr"+w);var A=i.querySelectorAll(".sapUiTableCtrlScroll > tbody > tr"+w);var a=[];a.forEach.call(x,l);a.forEach.call(y,l);a.forEach.call(z,l);a.forEach.call(A,l);};
v.prototype.onBeforeRendering=function(a){if(a&&a.isMarked("renderRows")){return;}if(this._mTimeouts.bindingTimer){this._updateBindingContexts();}this._cleanUpTimers();this._detachEvents();var b=this.getVisibleRowCountMode();var i=this.getRows();if(b==V.Interactive||b==V.Fixed||(b==V.Auto&&this._iTableRowContentHeight&&i.length==0)){if(this.getBinding("rows")){this._updateRows(this._calculateRowsToDisplay(),T.RowsUpdateReason.Render);}else{var l=this;this._mTimeouts.onBeforeRenderingAdjustRows=this._mTimeouts.onBeforeRenderingAdjustRows||window.setTimeout(function(){l._updateRows(l._calculateRowsToDisplay(),T.RowsUpdateReason.Render);l._mTimeouts.onBeforeRenderingAdjustRows=undefined;},0);}}else if(this._bRowAggregationInvalid&&i.length>0){this._updateRows(i.length,T.RowsUpdateReason.Render);}this._aTableHeaders=[];};
v.prototype.onAfterRendering=function(a){var b=a&&a.isMarked("renderRows");if(b){this._getScrollExtension().updateVerticalScrollbarHeight();this._updateVSbRange();}this._bInvalid=false;this._bOnAfterRendering=true;var $=this.$();this._attachEvents();this._initRowDomRefs();var w=this.getColumns();for(var i=0,l=w.length;i<l;i++){if(w[i].getVisible()){w[i]._restoreIcons();}}if(!this._bAllowColumnHeaderTextSelection&&!b){this._disableTextSelection($.find(".sapUiTableColHdrCnt"));}this._bOnAfterRendering=false;this._getKeyboardExtension().invalidateItemNavigation();this._updateTableContent();if(this._bFirstRendering&&this.getVisibleRowCountMode()==V.Auto){this._bFirstRendering=false;Promise.resolve().then(this._updateTableSizes.bind(this,T.RowsUpdateReason.Render,true));}else{this._updateTableSizes(T.RowsUpdateReason.Render,null,b,b&&T.isVariableRowHeightEnabled(this));}if(!b){this._aTableHeaders=this.$().find(".sapUiTableColHdrCnt th");if(this.getBinding("rows")){this._fireRowsUpdated(T.RowsUpdateReason.Render);}}};
v.prototype.invalidate=function(){if(!this._ignoreInvalidateOfChildControls){this._bInvalid=true;var a=C.prototype.invalidate.call(this);T.Column.invalidateColumnUtils(this);}return a;};
v.prototype._initRowDomRefs=function(){var a=this.getRows();for(var i=0;i<a.length;i++){a[i].initDomRefs();}};
v.prototype._updateTableSizes=function(a,b,l,w){var x=this.getDomRef();var y=this;if(this._bInvalid||!x){return;}if(!x.offsetWidth){T.deregisterResizeHandler(this,"");U();return;}this._resetRowHeights();this._resetColumnHeaderHeights();this._aRowHeights=this._collectRowHeights(false);var z=this._collectRowHeights(true);if(T.isVariableRowHeightEnabled(this)){this._iRowHeightsDelta=this._getRowHeightsDelta(this._aRowHeights);}var A=0;if(!l&&this.getVisibleRowCountMode()==V.Auto){A=this._determineAvailableSpace();if(this._handleRowCountModeAuto(A,a)&&!b){return;}}T.deregisterResizeHandler(this,"");function H(W){var X=W.getDomRef();var Y=T.Column.getMinColumnWidth();var Z=[];var _=W.getColumnHeaderVisible();function a1(d1,e1){if(d1<=e1){return Math.max(d1,e1-5,Y)+"px";}return-1;}function b1(e1){var f1=Math.max(e1._minWidth||0,Y,e1.getMinWidth());var g1=e1.getWidth();var h1;var i1;var j1;if(T.isVariableWidth(g1)&&!T.isFixedColumn(W,e1.getIndex())){h1=X.querySelectorAll('th[data-sap-ui-colid="'+e1.getId()+'"]');i1=h1[_?0:1];j1=i1?i1.offsetWidth:null;if(j1!==null){if(j1<=f1){return{headers:h1,newWidth:a1(j1,f1)};}else if(i1&&i1.style.width!=g1){Z.push({col:e1,header:i1,minWidth:f1,headers:h1});return{headers:h1,newWidth:g1};}Z.push({col:e1,header:i1,minWidth:f1,headers:h1});}}return null;}function c1(e1){if(e1){Array.prototype.forEach.call(e1.headers,function(f1){f1.style.width=e1.newWidth;});}}W._getVisibleColumns().map(b1).forEach(c1);if(Z.length){var d1;for(var i=0;i<Z.length;i++){d1=Z[i].header&&Z[i].header.offsetWidth;Z[i].newWidth=a1(d1,Z[i].minWidth);if(parseInt(Z[i].newWidth,10)>=0){c1(Z[i]);}}}}H(this);var J=this._collectTableSizes();if(J.tableCntHeight==0&&J.tableCntWidth==0){T.registerResizeHandler(this,"",this._onTableResize.bind(this),true);return;}this._updateRowHeights(this._aRowHeights,false);this._updateRowHeights(z,true);this._determineVisibleCols(J);if(!l||w){this._setRowContentHeight(A);}this._updateHSb(J);this._updateVSbTop();var $=this.$();if(T.hasRowActions(this)){var K=$.hasClass("sapUiTableRActFlexible");var L=this.getDomRef("dummycolhdr");var M=L?L.clientWidth:0;if(!K&&M>0){var O=J.tableCtrlScrWidth+J.tableRowHdrScrWidth+J.tableCtrlFixedWidth-M;var Q={width:"auto"};Q[this._bRtlMode?"right":"left"]=O;this.$("sapUiTableRowActionScr").css(Q);this.$("rowacthdr").css(Q);$.toggleClass("sapUiTableRActFlexible",true);}else if(K&&M<=0){this.$("sapUiTableRowActionScr").removeAttr("style");this.$("rowacthdr").removeAttr("style");$.toggleClass("sapUiTableRActFlexible",false);}}$.find(".sapUiTableNoOpacity").addBack().removeClass("sapUiTableNoOpacity");function U(){T.registerResizeHandler(y,"",y._onTableResize.bind(y),true);}if($.closest(".sapUiLoSplitter").length){U();}else{Promise.resolve().then(U);}};
v.prototype.setShowOverlay=function(b){b=!!b;this.setProperty("showOverlay",b,true);if(this.getDomRef()){var a=document.activeElement;this.$().toggleClass("sapUiTableOverlay",b);this._getAccExtension().updateAriaStateForOverlayAndNoData();this._getKeyboardExtension().updateNoDataAndOverlayFocus(a);}return this;};
v.prototype._updateFixedBottomRows=function(){var i=this.getFixedBottomRowCount();var a=this.getDomRef();if(a&&i>0){var $=q(a).find(".sapUiTableFixedPreBottomRow");$.removeClass("sapUiTableFixedPreBottomRow");var b=q(a).find(".sapUiTableFixedFirstBottomRow");b.removeClass("sapUiTableFixedFirstBottomRow");var l=T.getFirstFixedButtomRowIndex(this);var w=this.getRows();var x;if(l>=0&&l<w.length){x=w[l].getDomRefs(true);x.row.addClass("sapUiTableFixedFirstBottomRow",true);}if(l>=1&&l<w.length){x=w[l-1].getDomRefs(true);x.row.addClass("sapUiTableFixedPreBottomRow",true);}}};
v.prototype.getFocusInfo=function(){var i=this.$().find(":focus").attr("id");if(i){return{customId:i};}else{return E.prototype.getFocusInfo.apply(this,arguments);}};
v.prototype.applyFocusInfo=function(a){if(a&&a.customId){this.$().find("#"+a.customId).focus();}else{E.prototype.getFocusInfo.apply(this,arguments);}return this;};
v.prototype.setTitle=function(a){var b=a;if(typeof(a)==="string"||a instanceof String){b=k.TableHelper.createTextView({text:a,width:"100%"});b.addStyleClass("sapUiTableHdrTitle");}this.setAggregation("title",b);return this;};
v.prototype.setFooter=function(a){var b=a;if(typeof(a)==="string"||a instanceof String){b=k.TableHelper.createTextView({text:a,width:"100%"});}this.setAggregation("footer",b);return this;};
v.prototype.setSelectionMode=function(a){this.clearSelection();if(a===s.Single){this._oSelection.setSelectionMode(f.SINGLE_SELECTION);}else{this._oSelection.setSelectionMode(f.MULTI_SELECTION);}a=T.sanitizeSelectionMode(this,a);this.setProperty("selectionMode",a);return this;};
v.prototype._adjustTablePosition=function(i,a){var b=i<this._getVirtualScrollRange();var l=this._getRowCount()>this.getVisibleRowCount();if(b&&this.getFirstVisibleRow()!=this._iRenderedFirstVisibleRow){return;}var w=null;if(b&&l){var x=a[0];var y=this._getScrollingPixelsForRow();var z=i-(this.getFirstVisibleRow()*y);var A=z/y;w=Math.ceil(A*x);if(w>x){w=null;}}else if(this._iRowHeightsDelta>=0){var H=l?i-this._getVirtualScrollRange():i;w=(this._iRowHeightsDelta/this._getRowCorrectionScrollRange())*H;}if(w!=null&&w>-1){this.$().find(".sapUiTableCCnt").scrollTop(w);}};
v.prototype.setFirstVisibleRow=function(i,O,b){if(parseInt(i,10)<0){q.sap.log.error("The index of the first visible row must be greater than or equal to 0."+" The value has been set to 0.",this);i=0;}if(this._getRowCount()>0){var M=this._getMaxRowIndex();if(M<i){q.sap.log.warning("The index of the first visible row must be lesser or equal than the scrollable row count minus the visible row count."+" The value has been set to "+M+".",this);i=M;}}var a=this.getFirstVisibleRow()!=i;if(a){this.setProperty("firstVisibleRow",i,true);if(this.getBinding("rows")){var l=O===true?T.RowsUpdateReason.VerticalScroll:T.RowsUpdateReason.FirstVisibleRowChange;this.updateRows(l);if(!O){this._updateVSbScrollTop();}}if(!b){this.fireFirstVisibleRowChanged({firstVisibleRow:i});}}return this;};
v.getMetadata().getAggregation("rows")._doesNotRequireFactory=true;
v.prototype.bindAggregation=function(a){if(a==="rows"){return this.bindRows.apply(this,[].slice.call(arguments,1));}return C.prototype.bindAggregation.apply(this,arguments);};
v.prototype.bindRows=function(b){if(this.getEnableBusyIndicator()){this.setBusy(false);}this._iPendingRequests=0;this._bPendingRequest=false;return C.prototype.bindAggregation.call(this,"rows",v._getSanitizedBindingInfo(arguments));};
v.prototype._bindAggregation=function(a,b){if(a==="rows"){v._addBindingListener(b,"change",this._onBindingChange.bind(this));v._addBindingListener(b,"dataRequested",this._onBindingDataRequested.bind(this));v._addBindingListener(b,"dataReceived",this._onBindingDataReceived.bind(this));}E.prototype._bindAggregation.call(this,a,b);var i=this.getBinding("rows");if(a==="rows"&&i!=null){var M=i.getModel();if(M!=null&&M.getDefaultBindingMode()===B.OneTime){q.sap.log.error("The binding mode of the model is set to \"OneTime\"."+" This binding mode is not supported for the \"rows\" aggregation!"+" Scrolling can not be performed.",this);}}this._initSelectionModel(f.MULTI_SELECTION);};
v._getSanitizedBindingInfo=function(a){var b;if(a==null||a[0]==null){b=null;}else if(typeof a[0]==="string"){var i=a[0];var l=a[1];var w=a[2];var x=a[3];if(l instanceof g||q.isArray(w)&&w[0]instanceof F){x=w;w=l;l=undefined;}b={path:i,sorter:w,filters:x,template:l};}else{b=a[0];}return b;};
v._addBindingListener=function(b,a,H){if(b.events==null){b.events={};}if(b.events[a]==null){b.events[a]=H;}else{var O=b.events[a];b.events[a]=function(){H.apply(this,arguments);O.apply(this,arguments);};}};
v.prototype._initSelectionModel=function(a){if(this._oSelection){this._oSelection.detachSelectionChanged(this._onSelectionChanged,this);}this._oSelection=new f(a);this._oSelection.attachSelectionChanged(this._onSelectionChanged,this);return this;};
v.prototype._onBindingChange=function(a){var b=typeof(a)==="object"?a.getParameter("reason"):a;if(b==="sort"||b==="filter"){this.clearSelection();this.setFirstVisibleRow(0);}};
v.prototype.unbindAggregation=function(a,b){var i=this.getBinding("rows");if(a==="rows"&&this.isBound("rows")){b=true;}var l=E.prototype.unbindAggregation.apply(this,[a,b]);if(a==="rows"&&i){this._restoreAppDefaultsColumnHeaderSortFilter();this._invalidateColumnMenus();this._updateBindingLength();this.updateRows(T.RowsUpdateReason.Unbind);}return l;};
v.prototype.setVisibleRowCount=function(i){if(i!=null&&!isFinite(i)){return this;}var a=this.getVisibleRowCountMode();if(a==V.Auto){q.sap.log.error("VisibleRowCount will be ignored since VisibleRowCountMode is set to Auto",this);return this;}var b=this.getFixedRowCount()+this.getFixedBottomRowCount();if(i<=b&&b>0){q.sap.log.error("Table: "+this.getId()+" visibleRowCount('"+i+"') must be bigger than number of fixed rows('"+(this.getFixedRowCount()+this.getFixedBottomRowCount())+"')",this);return this;}i=this.validateProperty("visibleRowCount",i);if(this.getBinding("rows")&&this.getBinding("rows").getLength()<=i){this.setProperty("firstVisibleRow",0);}this.setProperty("visibleRowCount",i);this._setRowContentHeight(i*this._getDefaultRowHeight());return this;};
v.prototype.setRowHeight=function(i){this.setProperty("rowHeight",i);this._iTableRowContentHeight=undefined;return this;};
v.prototype.setTooltip=function(a){q.sap.log.warning("The aggregation tooltip is not supported for sap.ui.table.Table");return this.setAggregation("tooltip",a,true);};
v.prototype.setNavigationMode=function(){this.setProperty("navigationMode",N.Scrollbar,true);q.sap.log.error("The navigationMode property is deprecated and must not be used anymore. Your setting was defaulted to 'Scrollbar'",this);};
v.prototype._getFixedBottomRowContexts=function(i,b){var a=this.getBinding("rows");var l=[];if(!a){return l;}i=i||this.getFixedBottomRowCount();b=b||a.getLength();var w=this.getVisibleRowCount();if(i>0&&(w-i)<b){l=this._getContexts(b-i,i,1);}return l;};
v.prototype._getFixedRowContexts=function(i){i=i||this.getFixedRowCount();if(i>0){return this._getContexts(0,i);}else{return[];}};
v.prototype._getContexts=function(i,l,a){var b=this.getBinding("rows");if(b){return b.getContexts(i,l,a);}else{return[];}};
v.prototype._getRowContexts=function(a,b,l){var w=this.getBinding("rows");var x=a==null?this.getRows().length:a;if(!w||x<=0){return[];}b=b===true;l=l===true;var y=this.getFirstVisibleRow();var z=this.getFixedRowCount();var A=this.getFixedBottomRowCount();var H=0;var J;var K=[];var L;var M=x-A;var O=0;var Q=M;var U=this.getThreshold();U=U?Math.max(x,U):0;var W=y;var X=function($,_,W){for(var i=0;i<_.length;i++){$[W+i]=_[i];}};if(z>0&&y>0){W=y+z;M-=z;O=z;L=this._getFixedRowContexts(z);H+=L.length;K=K.concat(L);}L=this._getContexts(W,M,U);var Y=this._updateBindingLength(b);J=L.length<Math.min(M,Y-A);H+=L.length;X(K,L,O);Q=Math.min(Q,Math.max(Y-A,0));if(A>0){L=this._getFixedBottomRowContexts(A,Y);H+=L.length;X(K,L,Q);}if(J&&!l){if(Y>0){var Z=this._getMaxRowIndex();if(Z<y){y=Z;this.setProperty("firstVisibleRow",y,true);K=this._getRowContexts(x,b,true);H=K.length;}}}return K;};
v.prototype._updateBindingLength=function(b){var a=this.getBinding("rows");var i=0;b=b===true;if(a){i=a.getLength();}if(i!=this._iBindingLength){this._iBindingLength=i;this._bBindingLengthChanged=true;if(!b){this._updateFixedBottomRows();this._toggleVSb();this._updateVSbRange();var l=T.isInstanceOf(a,"sap/ui/model/ClientListBinding")||T.isInstanceOf(a,"sap/ui/model/ClientTreeBinding");if(a==null||l){this._updateNoData();}}}return i;};
v.prototype.refreshRows=function(a){var b=this.getBinding("rows");if(!b){q.sap.log.error("RefreshRows must not be called without a binding",this);return;}var i=this;var l=typeof(a)==="object"?a.getParameter("reason"):a;var w=this.getVisibleRowCountMode();if((this.bOutput&&w===V.Auto)||w!==V.Auto){var x=this._calculateRowsToDisplay();if(this.bOutput){b.attachEventOnce("dataRequested",function(){if(i._mTimeouts.refreshRowsAdjustRows){window.clearTimeout(i._mTimeouts.refreshRowsAdjustRows);}i._mTimeouts.refreshRowsAdjustRows=window.setTimeout(function(){i._updateRows(x,l,false);},0);});}if(l===d.Filter||l===d.Sort){this.setFirstVisibleRow(0);}this._updateBindingContexts(x,true);}};
v.prototype.updateRows=function(a){if(this._bExitCalled){return;}var b=this.getVisibleRowCountMode();if((this.getRows().length<=0||this._bRowAggregationInvalid)&&((b==V.Auto&&this.bOutput)||b!=V.Auto)){if(this._iTableRowContentHeight){this._updateRows(this._calculateRowsToDisplay(),a);}}if(!this.bIsDestroyed){var i=(a===d.Change||(!this._mTimeouts.bindingTimer&&Date.now()-this._lastCalledUpdateRows>this._iBindingTimerDelay)||a===T.RowsUpdateReason.Unbind?0:this._iBindingTimerDelay);var l=this;if(i===0&&a){Promise.resolve().then(function(){l._performUpdateRows(a);});}else{this._mTimeouts.bindingTimer=this._mTimeouts.bindingTimer||window.setTimeout(function(){l._performUpdateRows(a);},i);}}};
v.prototype.insertRow=function(){q.sap.log.error("The control manages the rows aggregation. The method \"insertRow\" cannot be used programmatically!",this);};
v.prototype.addRow=function(){q.sap.log.error("The control manages the rows aggregation. The method \"addRow\" cannot be used programmatically!",this);};
v.prototype.removeRow=function(){q.sap.log.error("The control manages the rows aggregation. The method \"removeRow\" cannot be used programmatically!",this);};
v.prototype.removeAllRows=function(){q.sap.log.error("The control manages the rows aggregation. The method \"removeAllRows\" cannot be used programmatically!",this);};
v.prototype.destroyRows=function(){q.sap.log.error("The control manages the rows aggregation. The method \"destroyRows\" cannot be used programmatically!",this);};
v.prototype.autoResizeColumn=function(i){this._getPointerExtension().doAutoResizeColumn(i);};
v.prototype._attachEvents=function(){var $=this.$();$.find(".sapUiTableColHdrScr").scroll(q.proxy(this._oncolscroll,this));$.find(".sapUiTableCtrlScr").scroll(q.proxy(this._oncntscroll,this));$.find(".sapUiTableCtrlScrFixed").scroll(q.proxy(this._oncntscroll,this));$.find(".sapUiTableCtrlScrFixed").on("scroll.sapUiTablePreventFixedAreaScroll",function(a){a.target.scrollLeft=0;});if(T.isVariableRowHeightEnabled(this)){var i=$.find(".sapUiTableCtrlScr, .sapUiTableCtrlScrFixed, .sapUiTableRowHdrScr");i.on("scroll.sapUiTableSyncScrollPosition",function(a){i.scrollTop(a.target.scrollTop);});}if(sap.ui.getCore().getConfiguration().getAnimation()){q(document.body).on("webkitTransitionEnd transitionend",function(a){if(q(a.target).has($).length>0){this._iDefaultRowHeight=undefined;this._updateTableSizes(T.RowsUpdateReason.Animation);}}.bind(this));}m.attachEvents(this);};
v.prototype._detachEvents=function(){q(document.body).off('webkitTransitionEnd transitionend');T.deregisterResizeHandler(this);m.detachEvents(this);};
v.prototype._getScrollTargets=function(){var $=q(this.getDomRef("sapUiTableCtrlScr"));var a=q(this.getDomRef("rsz"));var b=q(this.getDomRef("sapUiTableCtrlScrFixed"));var i=q(this.getDomRef("sapUiTableRowHdrScr"));return $.add(b).add(i).add(a);};
v.prototype._cleanUpTimers=function(){for(var K in this._mTimeouts){if(this._mTimeouts[K]){window.clearTimeout(this._mTimeouts[K]);delete this._mTimeouts[K];}}};
v.prototype._updateHSb=function(a){var $=this.$();var i=a.tableCtrlScrollWidth;if(!!D.browser.safari){i=Math.max(i,this._getColumnsWidth(this.getFixedColumnCount()));}if(i>a.tableCtrlScrWidth){if(!this._getScrollExtension().isHorizontalScrollbarVisible()){$.addClass("sapUiTableHScr");if(!!D.browser.safari){var b=$.find(".sapUiTableCtrlScroll, .sapUiTableColHdrScr > .sapUiTableColHdr");b.outerWidth(i);}}var l=a.tableCtrlFixedWidth;if($.find(".sapUiTableRowHdrScr").length>0){l+=a.tableRowHdrScrWidth;}if(this.getRows().length>0){var w=$.find(".sapUiTableHSb");if(this._bRtlMode){w.css('margin-right',l+'px');}else{w.css('margin-left',l+'px');}}var H=this.getDomRef("hsb-content");if(H){H.style.width=i+"px";}}else{if(this._getScrollExtension().isHorizontalScrollbarVisible()){$.removeClass("sapUiTableHScr");if(!!D.browser.safari){$.find(".sapUiTableCtrlScroll, .sapUiTableColHdr").css("width","");}}}};
v.prototype._updateVSbTop=function(){var a=this._getScrollExtension().getVerticalScrollbar();if(!a){return;}var b=this.getDomRef("tableCCnt");if(b){var i=b.offsetTop;var l=this.getDomRef("vsb-bg");l.style.top=i+"px";var w=this.getFixedRowCount();if(w>0){i+=this._iVsbTop;}a.style.top=i+"px";}};
v.prototype._updateVSbScrollTop=function(i){var a=this._getScrollExtension();var b=a.getVerticalScrollbar();if(!b){return;}if(!this._isVSbRequired()){return;}if(i===undefined){i=Math.ceil(this.getFirstVisibleRow()*this._getScrollingPixelsForRow());}a._iVerticalScrollPosition=null;window.requestAnimationFrame(function(){b.scrollTop=i;});};
v.prototype._updateVSbRange=function(){var a=this._getScrollExtension().getVerticalScrollbar();if(!a){return;}q(this.getDomRef("vsb-content")).height(this._getTotalScrollRange());};
v.prototype._toggleVSb=function(){var a=this.getDomRef();if(a){if(this._isVSbRequired()){if(!a.classList.contains("sapUiTableVScr")){a.classList.add("sapUiTableVScr");this._updateVSbScrollTop(0);}}else{a.classList.remove("sapUiTableVScr");}}};
v.prototype._isVSbRequired=function(){if(this._iRowHeightsDelta>0||(this.getBinding("rows")&&this._iBindingLength>this.getVisibleRowCount())){return true;}return false;};
v.prototype._updateBindingContexts=function(i,b){var a=this.getBinding("rows");var l;b=b===true;if(a!=null){l=this._getRowContexts(i,b);}if(!b){this._resetRowHeights();var w=this.getRows(),x=this.mBindingInfos["rows"],M=x&&x.model;for(var y=w.length-1;y>=0;y--){var z=l?l[y]:undefined;var A=w[y];if(A){A.setRowBindingContext(z,M,a);}}}};
v.prototype._updateNoData=function(){if(!this.getDomRef()){return;}var a=document.activeElement;this.$().toggleClass("sapUiTableEmpty",T.isNoDataVisible(this));this._getAccExtension().updateAriaStateForOverlayAndNoData();this._getKeyboardExtension().updateNoDataAndOverlayFocus(a);};
v.prototype._determineVisibleCols=function(a){var b=[];this.getColumns().forEach(function(l,i){if(l.shouldRender()){b.push(i);}});};
v.prototype.removeColumn=function(a,b){var i=this.removeAggregation('columns',a,b);if(typeof a==="number"&&a>-1){a=this.getColumns()[a];}var l=q.inArray(a,this._aSortedColumns);if(!this._bReorderInProcess&&l>=0){this._aSortedColumns.splice(l,1);}this.invalidateRowsAggregation();return i;};
v.prototype.removeAllColumns=function(){var a=this.removeAllAggregation('columns');this._aSortedColumns=[];this.invalidateRowsAggregation();return a;};
v.prototype.destroyColumns=function(){var a=this.destroyAggregation('columns');this._aSortedColumns=[];this.invalidateRowsAggregation();return a;};
v.prototype.addColumn=function(a,b){this.addAggregation('columns',a,b);this.invalidateRowsAggregation();return this;};
v.prototype.insertColumn=function(a,i,b){this.insertAggregation('columns',a,i,b);this.invalidateRowsAggregation();return this;};
v.prototype._getRowCount=function(){return this._iBindingLength;};
v.prototype._getSelectableRowCount=function(){var b=this.getBinding("rows");return this._iBindingLength||(b?b.getLength():0);};
v.prototype._getFirstVisibleRowByScrollTop=function(i){if(T.isVariableRowHeightEnabled(this)&&this._getRowCount()<this.getVisibleRowCount()){return 0;}else{var a=Math.floor(i/this._getScrollingPixelsForRow());var b=this._getVirtualScrollRange()-i;var l=b<1;return l?this._getMaxRowIndex():a;}};
v.prototype._getScrollingPixelsForRow=function(){return this._getVirtualScrollRange()/Math.max(1,this._getMaxRowIndex());};
v.prototype._getVSbHeight=function(){return this._getScrollableRowCount()*this._getDefaultRowHeight();};
v.prototype._getScrollableRowCount=function(){return Math.max(1,this.getVisibleRowCount()-this.getFixedRowCount()-this.getFixedBottomRowCount());};
v.prototype._getRowHeightsDelta=function(i){var l=this._getDefaultRowHeight()*this.getVisibleRowCount();if(this.getVisibleRowCount()>=this._getRowCount()){i=i.slice(0,this._getRowCount());}var w=i.reduce(function(a,b){return a+b;},0)-l;if(w>0){w=Math.ceil(w);}return Math.max(0,w);};
v.prototype._getTotalScrollRange=function(){var i=Math.max(this._getRowCount(),this.getVisibleRowCount()+1);var a=this._getDefaultRowHeight()*i;return Math.min(this._iMaxScrollbarHeight,a);};
v.prototype._getVirtualScrollRange=function(){var M=this._getTotalScrollRange()-this._getVSbHeight();if(T.isVariableRowHeightEnabled(this)){M=M-this._iRowHeightsDelta;}return Math.max(1,M);};
v.prototype._getRowCorrectionScrollRange=function(){var i=this._getTotalScrollRange()-this._getVSbHeight();if(this._getRowCount()>this.getVisibleRowCount()){i-=this._getVirtualScrollRange();}return Math.max(1,i);};
v.prototype._getMaxRowIndex=function(){var M=this._getRowCount()-this.getVisibleRowCount();if(T.isVariableRowHeightEnabled(this)){M-=1;}return Math.max(0,M);};
v.prototype._getVisibleColumns=function(){var a=[];var b=this.getColumns();for(var i=0,l=b.length;i<l;i++){if(b[i].shouldRender()){a.push(b[i]);}}return a;};
v.prototype._getColumnsWidth=function(a,b){var w=this.getColumns();var x=0;if(a!==0&&!a){a=0;}if(b!==0&&!b){b=w.length;}for(var i=a,l=b;i<l;i++){if(w[i]&&w[i].shouldRender()){x+=this._CSSSizeToPixel(w[i].getWidth());}}return x;};
v.prototype._CSSSizeToPixel=function(a,b){var i=T.Column.getMinColumnWidth();if(a){if(q.sap.endsWith(a,"px")){i=parseInt(a,10);}else if(q.sap.endsWith(a,"em")||q.sap.endsWith(a,"rem")){i=Math.ceil(parseFloat(a)*this._getBaseFontSize());}}if(b){return i+"px";}else{return parseInt(i,10);}};
v.prototype._getBaseFontSize=function(){return this._iBaseFontSize;};
v.prototype._onTableResize=function(){if(this._bInvalid||!this.getDomRef()){return;}this._updateTableSizes(T.RowsUpdateReason.Resize);};
v.prototype._handleRowCountModeAuto=function(i,a){var b=this.getBinding("rows");if(b&&this.getRows().length>0){return this._executeAdjustRows(a,i);}else{var l=!this._mTimeouts.handleRowCountModeAutoAdjustRows;var w=this.getBusyIndicatorDelay();var x=this.getEnableBusyIndicator();var y=this;if(b&&x){this.setBusyIndicatorDelay(0);this.setBusy(true);}if(i){this._setRowContentHeight(i);}this._mTimeouts.handleRowCountModeAutoAdjustRows=this._mTimeouts.handleRowCountModeAutoAdjustRows||window.setTimeout(function(){if(!y._executeAdjustRows(a)){y._updateTableSizes(a,false,true);}delete y._mTimeouts.handleRowCountModeAutoAdjustRows;if(b&&x){y.setBusyIndicatorDelay(w);y.setBusy(false);}},0);return l;}};
v.prototype._executeAdjustRows=function(a,i){i=i||this._determineAvailableSpace();var b=this._calculateRowsToDisplay(i);if(b==this._determineMinAutoRowCount()){this.$().height("auto");}else{this.$().height("0px");}return this._updateRows(b,a);};
v.prototype._disableTextSelection=function(a){q(a||document.body).attr("unselectable","on").css({"-moz-user-select":"none","-webkit-user-select":"none","user-select":"none"}).bind("selectstart",function(b){b.preventDefault();return false;});};
v.prototype._enableTextSelection=function(a){q(a||document.body).attr("unselectable","off").css({"-moz-user-select":"","-webkit-user-select":"","user-select":""}).unbind("selectstart");};
v.prototype._clearTextSelection=function(){if(window.getSelection){if(window.getSelection().empty){window.getSelection().empty();}else if(window.getSelection().removeAllRanges){window.getSelection().removeAllRanges();}}else if(document.selection&&document.selection.empty){try{document.selection.empty();}catch(a){}}};
v.prototype._findAndfireCellEvent=function(a,b,i){var $=q(b.target);var l=$.closest("td.sapUiTableTd");var w=l.attr("id");var M=/.*-row(\d*)-col(\d*)/i.exec(w);var x=false;if(M){var y=M[1];var z=M[2];var A=this.getRows()[y];var H=A&&A.getCells()[z];var J=A&&A.getIndex();var K=H.data("sap-ui-colid");var L;if(this.getBindingInfo("rows")){L=A.getBindingContext(this.getBindingInfo("rows").model);}var O={rowIndex:J,columnIndex:z,columnId:K,cellControl:H,rowBindingContext:L,cellDomRef:l.get(0)};x=!a.call(this,O);if(!x&&typeof i==="function"){O.cellDomRef=l[0];x=i.call(this,O);}}return x;};
v.prototype.getFocusDomRef=function(){this._getKeyboardExtension().initItemNavigation();var a=T.getFocusedItemInfo(this);if(a!==null){return a.domRef||C.prototype.getFocusDomRef.apply(this,arguments);}return null;};
v.prototype._isRowSelectable=function(i){return i>=0&&i<this._getRowCount();};
v.prototype.pushSortedColumn=function(a,A){if(!A){this._aSortedColumns=[];}this._aSortedColumns.push(a);};
v.prototype.getSortedColumns=function(){return this._aSortedColumns.slice();};
v.prototype.sort=function(a,b,A){if(!a){for(var i=0;i<this._aSortedColumns.length;i++){this._aSortedColumns[i].setSorted(false);}var l=this.getBinding("rows");if(l){l.sort();}this._aSortedColumns=[];}if(q.inArray(a,this.getColumns())>=0){a.sort(b===u.Descending,A);}};
v.prototype.filter=function(a,b){if(q.inArray(a,this.getColumns())>=0){a.filter(b);}};
v.prototype._updateSelection=function(){var a=this.getSelectionMode();if(a===s.None){return;}var b=this._getAccExtension().getAriaTextsForSelectionMode(true);var l=T.isRowSelectionAllowed(this);var w=this.getRows();for(var i=0;i<w.length;i++){var x=w[i];x._updateSelection(this,b,l);}this.setProperty("selectedIndex",this.getSelectedIndex(),true);if(T.hasSelectAll(this)){var $=this.$("selall");var A=T.areAllRowsSelected(this);$.toggleClass("sapUiTableSelAll",!A);this._getAccExtension().setSelectAllState(A);if(this._getShowStandardTooltips()){var y=A?"TBL_DESELECT_ALL":"TBL_SELECT_ALL";$.attr('title',this._oResBundle.getText(y));}}};
v.prototype._getShowStandardTooltips=function(){return!this._bHideStandardTooltips;};
v.prototype._onSelectionChanged=function(a){var b=a.getParameter("rowIndices");var i=a.getParameter("selectAll");var l=this._iSourceRowIndex!==undefined?this._iSourceRowIndex:this.getSelectedIndex();this._updateSelection();this.fireRowSelectionChange({rowIndex:l,rowContext:this.getContextByIndex(l),rowIndices:b,selectAll:i,userInteraction:this._iSourceRowIndex!==undefined});};
v.prototype.getContextByIndex=function(i){var b=this.getBinding("rows");return i>=0&&b?b.getContexts(i,1)[0]:null;};
v.prototype.getSelectedIndex=function(){return this._oSelection.getLeadSelectedIndex();};
v.prototype.setSelectedIndex=function(i){if(i===-1){this.clearSelection();}else{this._oSelection.setSelectionInterval(i,i);}return this;};
v.prototype.clearSelection=function(){this._oSelection.clearSelection();return this;};
v.prototype.selectAll=function(){if(!T.hasSelectAll(this)){return this;}var b=this.getBinding("rows");if(b){this._oSelection.selectAll((b.getLength()||0)-1);}return this;};
v.prototype.getSelectedIndices=function(){return this._oSelection.getSelectedIndices();};
v.prototype.addSelectionInterval=function(i,a){if(this.getSelectionMode()===k.SelectionMode.None){return this;}this._oSelection.addSelectionInterval(i,a);return this;};
v.prototype.setSelectionInterval=function(i,a){if(this.getSelectionMode()===k.SelectionMode.None){return this;}this._oSelection.setSelectionInterval(i,a);return this;};
v.prototype.removeSelectionInterval=function(i,a){this._oSelection.removeSelectionInterval(i,a);return this;};
v.prototype.isIndexSelected=function(i){return this._oSelection.isSelectedIndex(i);};
v.prototype.setGroupBy=function(a){var b=a;var O=sap.ui.getCore().byId(this.getGroupBy());if(typeof b==="string"){b=sap.ui.getCore().byId(b);}var i=false;if(b!=null&&b instanceof h&&b!==O){if(q.inArray(b,this.getColumns())===-1){throw new Error("Column has to be part of the columns aggregation!");}var l=this.fireGroup({column:b,groupedColumns:[b.getId()],type:G.group});if(O!=null){O.setGrouped(false);i=true;}if(l&&this.getEnableGrouping()){b.setGrouped(true);}}if(b==null||i){if(O!=null){O.setGrouped(false);}T.Grouping.resetExperimentalGrouping(this);}return this.setAssociation("groupBy",b);};
v.prototype.getBinding=function(a){T.Grouping.setupExperimentalGrouping(this);return E.prototype.getBinding.call(this,[a||"rows"]);};
v.prototype.setEnableGrouping=function(b){var a=sap.ui.getCore().byId(this.getGroupBy());this.setProperty("enableGrouping",b);if(a!=null){a.setGrouped(b);}T.Grouping.resetExperimentalGrouping(this);this._invalidateColumnMenus();return this;};
v.prototype.setEnableCustomFilter=function(b){this.setProperty("enableCustomFilter",b);this._invalidateColumnMenus();return this;};
v.prototype.setEnableColumnFreeze=function(b){this.setProperty("enableColumnFreeze",b);this._invalidateColumnMenus();return this;};
v.prototype.setShowColumnVisibilityMenu=function(b){this.setProperty("showColumnVisibilityMenu",b);this._invalidateColumnMenus();return this;};
v.prototype.getFixedColumnCount=function(){if(this._bIgnoreFixedColumnCount){return 0;}else{return this.getProperty("fixedColumnCount");}};
v.prototype.setFixedColumnCount=function(a,b){var l=this.getColumns();var w,i;for(i=a-1;i>=0;i--){w=l[i];if(w&&w.getVisible()){a=Math.max(a,w.getIndex()+T.Column.getHeaderSpan(w));break;}}var $=this.$().find(".sapUiTableCtrlFirstCol > th");for(i=a-1;i>=0;i--){w=l[i];if(w&&T.isVariableWidth(w.getWidth())){w._iFixWidth=$.filter("[data-sap-ui-headcolindex='"+w.getIndex()+"']").width();}}this.setProperty("fixedColumnCount",a,b);this._collectTableSizes();this._invalidateColumnMenus();return this;};
v.prototype.setFixedRowCount=function(i){if(!(parseInt(i,10)>=0)){q.sap.log.error("Number of fixed rows must be greater or equal 0",this);return this;}if((i+this.getFixedBottomRowCount())<this.getVisibleRowCount()){this.setProperty("fixedRowCount",i);this._updateBindingContexts();}else{q.sap.log.error("Table '"+this.getId()+"' fixed rows('"+(i+this.getFixedBottomRowCount())+"') must be smaller than numberOfVisibleRows('"+this.getVisibleRowCount()+"')",this);}return this;};
v.prototype.setFixedBottomRowCount=function(i){if(!(parseInt(i,10)>=0)){q.sap.log.error("Number of fixed bottom rows must be greater or equal 0",this);return this;}if((i+this.getFixedRowCount())<this.getVisibleRowCount()){this.setProperty("fixedBottomRowCount",i);this._updateBindingContexts();}else{q.sap.log.error("Table '"+this.getId()+"' fixed rows('"+(i+this.getFixedRowCount())+"') must be smaller than numberOfVisibleRows('"+this.getVisibleRowCount()+"')",this);}return this;};
v.prototype.setThreshold=function(i){this.setProperty("threshold",i,true);};
v.prototype._invalidateColumnMenus=function(U){var a=this.getColumns();for(var i=0,l=a.length;i<l;i++){a[i].invalidateMenu(U);}};
v.prototype._isTouchEvent=function(a){return a!=null&&a.originalEvent!=null&&a.originalEvent.touches!=null;};
v.prototype._getRowClone=function(a){var b=new j(this.getId()+"-rows"+"-row"+a);var w=this.getColumns();for(var i=0,l=w.length;i<l;i++){if(w[i].getVisible()){var x=w[i].getTemplateClone(i);if(x){b.addCell(x);}}}if(T.hasRowActions(this)){var y=this.getRowActionTemplate().clone();y._setFixedLayout(true);y._setCount(this.getRowActionCount());y._setIconLabel(this.getId()+"-rowacthdr");b.setAggregation("_rowAction",y,true);}var z=this.getRowSettingsTemplate();if(z){var A=z.clone();b.setAggregation("_settings",A,true);}return b;};
v.prototype.invalidateRowsAggregation=function(){this._bRowAggregationInvalid=true;};
v.prototype._updateRows=function(a,b,U){if(isNaN(a)){return false;}if(U==null){U=true;}if(T.isVariableRowHeightEnabled(this)){a=a+1;}var i;var l=this.getRows();if(this._bRowAggregationInvalid&&l.length>0){this.destroyAggregation("rows",true);l=[];}if(a==l.length){return false;}for(i=l.length-1;i>=a;i--){this.removeAggregation("rows",i,true).destroy();}if(T.isVariableRowHeightEnabled(this)){this.setProperty("visibleRowCount",a-1,true);}else{this.setProperty("visibleRowCount",a,true);}this._ignoreInvalidateOfChildControls=true;var w;var x;var M;var y=this.getBinding("rows");if(U){x=this.getBindingInfo("rows");M=x&&x.model;w=this._getRowContexts(a);for(i=0;i<l.length;i++){l[i].setRowBindingContext(w[i],M,y);}}if(l.length<a){for(i=l.length;i<a;i++){var z=this._getRowClone(i);if(U){z.setRowBindingContext(w[i],M,y);}this.addAggregation("rows",z,true);this._bRowAggregationInvalid=false;if(U){z._updateTableCells(w[i]);}}}this._ignoreInvalidateOfChildControls=false;var A=U&&w.length>0;return this._renderRows(b,A);};
v.prototype._renderRows=function(a,b){var i=false;b=b===true;if(!this._bInvalid){var l=this.getDomRef("tableCCnt");if(this.getRows().length===0||!l){return false;}this._detachEvents();if(this.getVisibleRowCountMode()===V.Auto){var w=this.getDomRef();if(w){w.style.height="0px";}}var x=q.Event("BeforeRendering");x.setMarked("renderRows");x.srcControl=this;this._handleEvent(x);var y=new sap.ui.getCore().createRenderManager(),z=this.getRenderer();z.renderTableCCnt(y,this);y.flush(l,false,false);y.destroy();x=q.Event("AfterRendering");x.setMarked("renderRows");x.srcControl=this;this._handleEvent(x);i=true;}if(b&&!this._bInvalid&&this.getBinding("rows")){var A=this;if(this._mTimeouts._rowsUpdated){window.clearTimeout(this._mTimeouts._rowsUpdated);}this._mTimeouts._rowsUpdated=window.setTimeout(function(){A._fireRowsUpdated(a);},0);}return i;};
v.prototype._getDefaultRowHeight=function(){var i=this.getRowHeight();if(i>0){return i;}else{var a=T.getContentDensity(this);return T.DEFAULT_ROW_HEIGHT[a];}};
v.prototype._setRowContentHeight=function(H){H=H||0;var a=this.getVisibleRowCountMode();var i=this.getVisibleRowCount();var b=this._getDefaultRowHeight();var M=this.getMinAutoRowCount();var l;if(a==V.Interactive||a==V.Fixed){if(this._iTableRowContentHeight&&a==V.Interactive){l=M*b;if(!H){H=this._iTableRowContentHeight;}}else{l=i*b;H=l;}}else if(a==V.Auto){l=M*b;}var w=Math.max(H,l);if((a==V.Fixed&&this.getRows().length==0)||a!=V.Fixed){this._iTableRowContentHeight=Math.floor(w/b)*b;}else{this._iTableRowContentHeight=undefined;}if(T.isVariableRowHeightEnabled(this)){q(this.getDomRef("tableCCnt")).css("height",b*this.getVisibleRowCount()+"px");}else{if((a==V.Fixed||a==V.Interactive)&&this.getRows().length>0){q(this.getDomRef("tableCtrlCnt")).css("height","auto");}else{q(this.getDomRef("tableCtrlCnt")).css("height",this._iTableRowContentHeight+"px");}}this._toggleVSb();};
v.prototype._determineMinAutoRowCount=function(){var i=this.getVisibleRowCount();var M=this.getMinAutoRowCount();var a=M||i||5;if(this.getVisibleRowCountMode()==V.Interactive&&!this.bOutput){a=i||M||5;}return a;};
v.prototype._calculateRowsToDisplay=function(i){i=i||this._iTableRowContentHeight;var a=this.getVisibleRowCountMode();var b=0;if(a==V.Fixed){b=this.getVisibleRowCount()||0;}else if(a==V.Interactive||a==V.Auto){var M=this._determineMinAutoRowCount();var l=this._getDefaultRowHeight();if(!l||!i){b=M;}else{var A=Math.min(i,50000);var w=Math.floor(A/l);b=Math.max((this.getFixedRowCount()+this.getFixedBottomRowCount()+1),Math.max(M,w));}}return Math.max(b,0);};
v.prototype.setShowNoData=function(b){this.setProperty('showNoData',b,true);this._updateNoData();return this;};
v.prototype.exportData=function(a){var b=sap.ui.requireSync("sap/ui/core/util/Export");a=a||{};if(!a.rows){var w=this.getBinding("rows"),x=this.getBindingInfo("rows");var y=w.aFilters.concat(w.aApplicationFilters);a.rows={path:x.path,model:x.model,sorter:w.aSorters,filters:y,parameters:x.parameters};}if(!a.exportType){var z=sap.ui.requireSync("sap/ui/core/util/ExportTypeCSV");a.exportType=new z();}var M=a.rows.model;if(!M){var A=a.rows.path;var H=A.indexOf(">");if(H>0){M=A.substr(0,H);}}if(!a.columns){a.columns=[];var J=this.getColumns();for(var i=0,l=J.length;i<l;i++){var K=J[i];if(K.getSortProperty()){a.columns.push({name:K.getLabel().getText(),template:{content:{path:K.getSortProperty(),model:M}}});}}}var L=new b(a);this.addDependent(L);return L;};
v.prototype._onPersoApplied=function(){var a=this.getColumns();var b=[];for(var i=0,l=a.length;i<l;i++){var w=a[i];if(w.getSorted()){b.push(new g(w.getSortProperty(),w.getSortOrder()===u.Descending));}}var x=this.getBinding("rows");if(x){if(b.length>0){x.sort(b);}this.refreshRows();}};
v.prototype._toggleSelectAll=function(){if(!T.hasData(this)){return;}if(T.areAllRowsSelected(this)){this._iSourceRowIndex=-1;this.clearSelection();}else{this._iSourceRowIndex=0;this.selectAll();}this._iSourceRowIndex=undefined;};
v.prototype._restoreAppDefaultsColumnHeaderSortFilter=function(){var a=this.getColumns();q.each(a,function(i,b){b._restoreAppDefaults();});};
v.prototype.setBusy=function(b,a){var i=this.getBusy()!=b;a="sapUiTableCnt";var l=C.prototype.setBusy.call(this,b,a);if(i){this.fireBusyStateChanged({busy:b});}return l;};
v.prototype.setEnableBusyIndicator=function(b){this.setProperty("enableBusyIndicator",b,true);if(!b){this.setBusy(false);}};
v.prototype._onBindingDataRequested=function(a){if(a.getSource()!=this.getBinding("rows")||a.getParameter("__simulateAsyncAnalyticalBinding")){return;}this._iPendingRequests++;this._bPendingRequest=true;var b=T.canUsePendingRequestsCounter(this);if(this.getEnableBusyIndicator()&&(b&&this._iPendingRequests===1||!b)){this.setBusy(true);}if(this._dataReceivedHandlerId!=null){q.sap.clearDelayedCall(this._dataReceivedHandlerId);delete this._dataReceivedHandlerId;}};
v.prototype._onBindingDataReceived=function(a){if(a.getSource()!=this.getBinding("rows")||a.getParameter("__simulateAsyncAnalyticalBinding")){return;}this._iPendingRequests--;this._bPendingRequest=false;this._updateBindingLength();if(!T.hasPendingRequests(this)){this._dataReceivedHandlerId=q.sap.delayedCall(0,this,function(){if(this.getEnableBusyIndicator()){this.setBusy(false);}this._updateNoData();delete this._dataReceivedHandlerId;});}};
v.prototype._setLargeDataScrolling=function(l){this._bLargeDataScrolling=!!l;};
v.prototype._getSelectedIndicesCount=function(){return this.getSelectedIndices().length;};
v.prototype._updateTableContent=function(){T.Grouping.updateGroups(this);};
v.prototype.setRowActionTemplate=function(a){this.setAggregation("rowActionTemplate",a);a=this.getRowActionTemplate();if(a){a._setCount(this.getRowActionCount());}this.invalidateRowsAggregation();return this;};
v.prototype.setRowActionCount=function(a){this.setProperty("rowActionCount",a);a=this.getRowActionCount();var b=this.getRowActionTemplate();if(b){b._setCount(a);}var l=this.getRows();for(var i=0;i<l.length;i++){b=l[i].getAggregation("_rowAction");if(b){b._setCount(a);}}return this;};
v.prototype.setRowSettingsTemplate=function(a){this.setAggregation("rowSettingsTemplate",a);this.invalidateRowsAggregation();return this;};
v.prototype._validateRow=function(a){return a&&a instanceof j&&a.getParent()===this;};
v.prototype.getRowForCell=function(a){if(a){var b=a.getParent();if(this._validateRow(b)){return b;}}return null;};
v.prototype.getColumnForCell=function(a){if(this.getRowForCell(a)){var i=a.data("sap-ui-colindex");var b=this.getColumns();if(i>=0&&i<b.length){return b[i];}}return null;};
v.prototype.getCellControl=function(i,a,b){var l=T.getRowColCell(this,i,a,!b);return l.cell;};
v.prototype._fireRowsUpdated=function(a){if(a==null){a=T.RowsUpdateReason.Unknown;}this.fireEvent("_rowsUpdated",{reason:a});};
return v;});
sap.ui.predefine('sap/ui/table/TableAccExtension',["jquery.sap.global","sap/ui/core/Control","./library","./TableExtension","./TableAccRenderExtension","./TableUtils"],function(q,C,l,T,a,b){"use strict";var S=l.SelectionMode;var c=b.CELLTYPE;var A={getAccInfoOfControl:function(o,B){if(o&&typeof o.getAccessibilityInfo==="function"){if(typeof o.getVisible==="function"&&!o.getVisible()){return A._normalize({});}var s=o.getAccessibilityInfo();if(s){var t={};A._flatten(s,t,B);return t;}}return null;},_normalize:function(i){if(!i){return null;}if(i._normalized){return i;}i.role=i.role||"";i.type=i.type||"";i.description=i.description||"";i.focusable=!!i.focusable;i.enabled=(i.enabled===true||i.enabled===false)?i.enabled:null;i.editable=(i.editable===true||i.editable===false)?i.editable:null;i.children=i.children||[];i._normalized=true;return i;},_flatten:function(s,t,B,L){L=L?L:0;A._normalize(s);if(L==0){A._normalize(t);t._descriptions=[];}t.focusable=t.focusable||s.focusable;t._descriptions.push(A._getFullDescription(s,B));s.children.forEach(function(o){if(!o.getAccessibilityInfo||(o.getVisible&&!o.getVisible())){return;}var e=o.getAccessibilityInfo();if(e){A._flatten(e,t,B,L+1);}});if(L==0){t.description=t._descriptions.join(" ").trim();t._descriptions=undefined;}},_getFullDescription:function(i,B){var D=i.type+" "+i.description;if(i.enabled!=null&&!i.enabled){D=D+" "+B.getText("TBL_CTRL_STATE_DISABLED");}else if(i.editable!=null&&!i.editable){D=D+" "+B.getText("TBL_CTRL_STATE_READONLY");}return D.trim();}};var E={getColumnIndexOfFocusedCell:function(e){var t=e.getTable();var i=b.getFocusedItemInfo(t);return i.cellInRow-(b.hasRowHeader(t)?1:0);},getInfoOfFocusedCell:function(e){var t=e.getTable();var i=t._getItemNavigation();var o=t.getDomRef();if(!e.getAccMode()||!o||!i){return null;}var f=i.getFocusedDomRef();if(!f||f!==document.activeElement){return null;}return b.getCellInfo(f);},getRelevantColumnHeaders:function(t,o){if(!t||!o){return[];}var h=b.getHeaderRowCount(t),s=o.getId(),L=[s];if(h>1){for(var i=1;i<h;i++){L.push(s+"_"+i);}var e=b.Column.getParentSpannedColumns(t,s);if(e&&e.length){for(var i=0;i<e.length;i++){var f=e[i].level;var p=e[i].column.getId();L[f]=f===0?p:(p+"_"+f);}}}return L;},isHiddenCell:function($,o){var g=b.Grouping.isInGroupingRow($);var s=b.Grouping.isInSumRow($);var e=!!o&&!!o.hasStyleClass;var i=$.parent().hasClass("sapUiTableRowHidden");var I=$.hasClass("sapUiTableCellHidden");var n=g&&$.hasClass("sapUiTableTdFirst")&&!$.hasClass("sapUiTableMeasureCell");var G=g&&e&&o.hasStyleClass("sapUiAnalyticalTableGroupCellHidden");var f=s&&e&&o.hasStyleClass("sapUiAnalyticalTableSumCellHidden");return i||I||n||G||f;},isTreeColumnCell:function(e,$){return b.Grouping.isTreeMode(e.getTable())&&$.hasClass("sapUiTableTdFirst");},getColumnTooltip:function(o){if(!o){return null;}var t=o.getTooltip_AsString();if(t){return t;}var L=o.getLabel();if(L instanceof C){t=L.getTooltip_AsString();}if(t){return t;}return null;},updateRowColCount:function(e){var t=e.getTable(),i=t._getItemNavigation(),I=false,f=false,g=false;if(i){var h=E.getColumnIndexOfFocusedCell(e)+1;var r=b.getRowIndexOfFocusedCell(t)+t.getFirstVisibleRow()+1;var j=b.getVisibleColumnCount(t)+(b.hasRowActions(t)?1:0);var R=b.isNoDataVisible(t)?0:b.getTotalRowCount(t,true);I=e._iLastRowNumber!=r||(e._iLastRowNumber==r&&e._iLastColumnNumber==h);f=e._iLastColumnNumber!=h;g=!e._iLastRowNumber&&!e._iLastColumnNumber;t.$("rownumberofrows").text(I?t._oResBundle.getText("TBL_ROW_ROWCOUNT",[r,R]):" ");t.$("colnumberofcols").text(f?t._oResBundle.getText("TBL_COL_COLCOUNT",[h,j]):" ");t.$("ariacount").text(g?t._oResBundle.getText("TBL_DATA_ROWS_COLS",[R,j]):" ");e._iLastRowNumber=r;e._iLastColumnNumber=h;}return{rowChange:I,colChange:f,initial:g};},cleanupCellModifications:function(e){if(e._cleanupInfo){e._cleanupInfo.cell.attr(e._cleanupInfo.attr);e._cleanupInfo=null;}},storeDefaultsBeforeCellModifications:function(e,$,D,f){e._cleanupInfo={cell:$,attr:{"aria-labelledby":D&&D.length?D.join(" "):null,"aria-describedby":f&&f.length?f.join(" "):null}};},performCellModifications:function(e,$,D,f,L,g,t,h){E.storeDefaultsBeforeCellModifications(e,$,D,f);var o=E.updateRowColCount(e);e.getTable().$("cellacc").text(t||" ");if(h){h(L,g,o.rowChange,o.colChange,o.initial);}var s="";if(o.initial){var i=e.getTable();s=i.getAriaLabelledBy().join(" ")+" "+i.getId()+"-ariadesc "+i.getId()+"-ariacount";if(i.getSelectionMode()!==S.None){s=s+" "+i.getId()+"-ariaselection";}}if(L&&L.length){s=s+" "+L.join(" ");}$.attr({"aria-labelledby":s?s:null,"aria-describedby":g&&g.length?g.join(" "):null});},modifyAccOfDATACELL:function($,o){var t=this.getTable(),s=t.getId(),i=t._getItemNavigation();if(!i){return;}var r=b.getRowIndexOfFocusedCell(t),e=E.getColumnIndexOfFocusedCell(this),f=b.getRowColCell(t,r,e,false),I=null,h=E.isHiddenCell($,f.cell),g=E.isTreeColumnCell(this,$),j=b.Grouping.isInGroupingRow($),k=b.Grouping.isInSumRow($),D=E.getAriaAttributesFor(this,d.ELEMENTTYPES.DATACELL,{index:e,column:f.column,fixed:b.isFixedColumn(t,e)})["aria-labelledby"]||[],m=[],L=[s+"-rownumberofrows",s+"-colnumberofcols"];if(j){L.push(s+"-ariarowgrouplabel");L.push(s+"-rows-row"+r+"-groupHeader");}if(k){var n=$.parent().data("sap-ui-level");if(n==0){L.push(s+"-ariagrandtotallabel");}else if(n>0){L.push(s+"-ariagrouptotallabel");L.push(s+"-rows-row"+r+"-groupHeader");}}if(b.hasRowHighlights(t)&&!j&&!k){L.push(f.row.getId()+"-highlighttext");}L=L.concat(D);if(!h){I=A.getAccInfoOfControl(f.cell,t._oResBundle);L.push(I?(s+"-cellacc"):f.cell.getId());if(((!I||I.focusable)&&!this._readonly)||(g&&f.row&&f.row._bHasChildren)){m.push(s+"-toggleedit");}}var p=I?I.description:" ";if(g&&!h){var u=E.getAriaAttributesFor(this,d.ELEMENTTYPES.TREEICON,{row:f.row});if(u&&u["aria-label"]){p=u["aria-label"]+" "+p;}}E.performCellModifications(this,$,D,null,L,m,p,function(L,m,R,v,w){if(!h&&b.isRowSelectionAllowed(t)&&R){m.push(f.row.getId()+"-rowselecttext");}});},modifyAccOfROWHEADER:function($,o){var t=this.getTable(),s=t.getId(),i=b.Grouping.isInGroupingRow($),I=b.Grouping.isInSumRow($),r=t.getRows()[$.attr("data-sap-ui-rowindex")],D=E.getAriaAttributesFor(this,d.ELEMENTTYPES.ROWHEADER)["aria-labelledby"]||[],L=D.concat([s+"-rownumberofrows"]);if(!I&&!i){if(!$.hasClass("sapUiTableRowHidden")){L.push(r.getId()+"-rowselecttext");if(b.hasRowHighlights(t)){L.push(r.getId()+"-highlighttext");}}}if(i){L.push(s+"-ariarowgrouplabel");}if(I){var e=$.data("sap-ui-level");if(e==0){L.push(s+"-ariagrandtotallabel");}else if(e>0){L.push(s+"-ariagrouptotallabel");}}E.performCellModifications(this,$,D,null,L,null,null);},modifyAccOfCOLUMNHEADER:function($,o){var t=this.getTable(),e=sap.ui.getCore().byId($.attr("data-sap-ui-colid")),m=E.getAriaAttributesFor(this,d.ELEMENTTYPES.COLUMNHEADER,{headerId:$.attr("id"),column:e,index:$.attr("data-sap-ui-colindex")}),s=E.getColumnTooltip(e),L=[t.getId()+"-colnumberofcols"].concat(m["aria-labelledby"]),f=b.getCellInfo($),i=f.columnSpan;if(i>1){L.push(t.getId()+"-ariacolspan");t.$("ariacolspan").text(t._oResBundle.getText("TBL_COL_DESC_SPAN",[""+i]));}if(s){L.push(t.getId()+"-cellacc");}if(i<=1&&e&&e.getSorted()){L.push(t.getId()+(e.getSortOrder()==="Ascending"?"-ariacolsortedasc":"-ariacolsorteddes"));}if(i<=1&&e&&e.getFiltered()){L.push(t.getId()+"-ariacolfiltered");}if(i<=1&&$.attr("aria-haspopup")==="true"){L.push(t.getId()+"-ariacolmenu");}E.performCellModifications(this,$,m["aria-labelledby"],m["aria-describedby"],L,m["aria-describedby"],s);},modifyAccOfCOLUMNROWHEADER:function($,o){var t=this.getTable(),e=$.hasClass("sapUiTableSelAllEnabled");var m=E.getAriaAttributesFor(this,d.ELEMENTTYPES.COLUMNROWHEADER,{enabled:e,checked:e&&!t.$().hasClass("sapUiTableSelAll")});E.performCellModifications(this,$,m["aria-labelledby"],m["aria-describedby"],m["aria-labelledby"],m["aria-describedby"],null);},modifyAccOfROWACTION:function($,o){var t=this.getTable(),s=t.getId(),i=b.Grouping.isInGroupingRow($),I=b.Grouping.isInSumRow($),r=$.attr("data-sap-ui-rowindex"),R=t.getRows()[r],h=E.isHiddenCell($),D=E.getAriaAttributesFor(this,d.ELEMENTTYPES.ROWACTION)["aria-labelledby"]||[],L=[s+"-rownumberofrows",s+"-colnumberofcols"].concat(D),e=[];if(i){L.push(s+"-ariarowgrouplabel");L.push(s+"-rows-row"+r+"-groupHeader");}if(I){var f=$.data("sap-ui-level");if(f==0){L.push(s+"-ariagrandtotallabel");}else if(f>0){L.push(s+"-ariagrouptotallabel");L.push(s+"-rows-row"+r+"-groupHeader");}}if(!I&&!i&&$.attr("aria-selected")=="true"){L.push(s+"-ariarowselected");}if(b.hasRowHighlights(t)&&!i&&!I){L.push(R.getId()+"-highlighttext");}var g="";if(!h){var j=R.getAggregation("_rowAction");if(j){var k=j.getAccessibilityInfo();if(k){L.push(s+"-cellacc");g=k.description;if(k.focusable){e.push(s+"-toggleedit");}}}}E.performCellModifications(this,$,D,[],L,e,g);},getAriaAttributesFor:function(e,t,p){var m={},o=e.getTable(),s=o.getId();function f(o,v,O,w){var M="";if(O&&w){M="overlay,nodata";}else if(O&&!w){M="overlay";}else if(!O&&w){M="nodata";}var x=false;if(O&&o.getShowOverlay()||w&&b.isNoDataVisible(o)){x=true;}if(x){m["aria-hidden"]="true";}if(M){m["data-sap-ui-table-acc-covered"]=M;}}switch(t){case d.ELEMENTTYPES.COLUMNROWHEADER:m["aria-labelledby"]=[s+"-ariacolrowheaderlabel"];var g=false;m["role"]=["button"];if(p&&p.enabled){m["aria-pressed"]=p.checked?"true":"false";}else{g=true;m["aria-disabled"]="true";m["aria-pressed"]="false";}if(g||!o._getShowStandardTooltips()){m["aria-labelledby"].push(s+"-ariaselectall");}break;case d.ELEMENTTYPES.ROWHEADER:m["aria-labelledby"]=[s+"-ariarowheaderlabel"];if(!b.Grouping.isTreeMode(o)){m["role"]=["rowheader"];}if(o.getSelectionMode()!==S.None&&(!p||!p.rowHidden)){var h=p&&p.rowSelected;m["aria-selected"]=""+h;var j=e.getAriaTextsForSelectionMode(true);m["title"]=j.mouse[h?"rowDeselect":"rowSelect"];}break;case d.ELEMENTTYPES.ROWACTION:m["role"]=["gridcell"];m["aria-labelledby"]=[s+"-rowacthdr"];if(o.getSelectionMode()!==S.None&&(!p||!p.rowHidden)){var h=p&&p.rowSelected;m["aria-selected"]=""+h;}break;case d.ELEMENTTYPES.COLUMNHEADER:var k=p&&p.column;var H=p&&p.colspan;m["role"]="columnheader";var L=[];if(p&&p.headerId){var n=E.getRelevantColumnHeaders(o,k);var I=q.inArray(p.headerId,n);L=I>0?n.slice(0,I+1):[p.headerId];}for(var i=0;i<L.length;i++){L[i]=L[i]+"-inner";}m["aria-labelledby"]=L;if(p&&(p.index<o.getFixedColumnCount())){m["aria-labelledby"].push(s+"-ariafixedcolumn");}if(!H&&k&&k.getSorted()){m["aria-sort"]=k.getSortOrder()==="Ascending"?"ascending":"descending";}if(!H&&k&&k._menuHasItems()){m["aria-haspopup"]="true";}break;case d.ELEMENTTYPES.DATACELL:m["role"]="gridcell";if(p&&typeof p.index==="number"){m["headers"]=s+"_col"+p.index;}var L=[],k=p&&p.column?p.column:null;if(k){L=E.getRelevantColumnHeaders(o,k);for(var i=0;i<L.length;i++){L[i]=L[i]+"-inner";}if(p&&p.fixed){L.push(s+"-ariafixedcolumn");}}m["aria-labelledby"]=L;if(b.Grouping.isTreeMode(o)&&p&&p.firstCol&&p.row){var B=o.mBindingInfos["rows"];if(p.row.getBindingContext(B&&B.model)){m["aria-level"]=p.row._iLevel+1;m["aria-expanded"]=""+p.row._bIsExpanded;}}break;case d.ELEMENTTYPES.ROOT:break;case d.ELEMENTTYPES.TABLE:m["role"]="presentation";f(o,m,true,true);break;case d.ELEMENTTYPES.CONTENT:m["role"]=b.Grouping.isGroupMode(o)||b.Grouping.isTreeMode(o)?"treegrid":"grid";m["aria-labelledby"]=[].concat(o.getAriaLabelledBy());if(o.getTitle()){m["aria-labelledby"].push(o.getTitle().getId());}if(o.getSelectionMode()===S.Multi||o.getSelectionMode()===S.MultiToggle){m["aria-multiselectable"]="true";}break;case d.ELEMENTTYPES.TABLEHEADER:m["role"]="heading";f(o,m,true,false);break;case d.ELEMENTTYPES.COLUMNHEADER_TBL:m["role"]="presentation";break;case d.ELEMENTTYPES.COLUMNHEADER_ROW:if(!b.hasRowHeader(o)){m["role"]="row";}f(o,m,true,false);break;case d.ELEMENTTYPES.ROWHEADER_COL:f(o,m,true,true);break;case d.ELEMENTTYPES.TH:var r=o.getFixedColumnCount()>0;m["role"]=r?"columnheader":"presentation";m["scope"]="col";if(r){if(p&&p.column){m["aria-owns"]=p.column.getId();m["aria-labelledby"]=[p.column.getId()];}}else{m["aria-hidden"]="true";}break;case d.ELEMENTTYPES.ROWHEADER_TD:m["role"]="rowheader";m["aria-labelledby"]=[s+"-ariarowheaderlabel"];m["headers"]=s+"-colsel";if(p&&typeof p.index==="number"){m["aria-owns"]=s+"-rowsel"+p.index;}if(o.getSelectionMode()!==S.None){var h=p&&p.rowSelected;m["aria-selected"]=""+h;}break;case d.ELEMENTTYPES.TR:m["role"]="row";var h=false;if(p&&typeof p.index==="number"&&o.getSelectionMode()!==S.None&&o.isIndexSelected(p.index)){m["aria-selected"]="true";h=true;}if(b.isRowSelectionAllowed(o)){var j=e.getAriaTextsForSelectionMode(true);m["title"]=j.mouse[h?"rowDeselect":"rowSelect"];}break;case d.ELEMENTTYPES.TREEICON:if(b.Grouping.isTreeMode(o)){m={"aria-label":"","title":"","role":""};if(o.getBinding("rows")){m["role"]="button";if(p&&p.row){if(p.row._bHasChildren){var u=o._oResBundle.getText(p.row._bIsExpanded?"TBL_COLLAPSE":"TBL_EXPAND");if(o._getShowStandardTooltips()){m["title"]=u;}else{m["aria-label"]=u;}m["aria-expanded"]=""+(!!p.row._bIsExpanded);}else{m["aria-label"]=o._oResBundle.getText("TBL_LEAF");}}}}break;case d.ELEMENTTYPES.NODATA:m["role"]="gridcell";var N=o.getNoData();m["aria-labelledby"]=[N instanceof C?N.getId():(s+"-noDataMsg")];f(o,m,true,false);break;case d.ELEMENTTYPES.OVERLAY:m["role"]="region";m["aria-labelledby"]=[].concat(o.getAriaLabelledBy());if(o.getTitle()){m["aria-labelledby"].push(o.getTitle().getId());}m["aria-labelledby"].push(s+"-ariainvalid");break;case d.ELEMENTTYPES.TABLEFOOTER:case d.ELEMENTTYPES.TABLESUBHEADER:f(o,m,true,false);break;case d.ELEMENTTYPES.ROWACTIONHEADER:m["aria-hidden"]="true";break;case"PRESENTATION":m["role"]="presentation";break;}return m;}};
var d=T.extend("sap.ui.table.TableAccExtension",{
_init:function(t,s,m){this._accMode=sap.ui.getCore().getConfiguration().getAccessibility();this._readonly=s===T.TABLETYPES.ANALYTICAL;t.addEventDelegate(this);T.enrich(t,a);return"AccExtension";},
_debug:function(){this._ExtensionHelper=E;this._ACCInfoHelper=A;},
destroy:function(){this.getTable().removeEventDelegate(this);this._readonly=false;T.prototype.destroy.apply(this,arguments);},
getAriaAttributesFor:function(t,p){return E.getAriaAttributesFor(this,t,p);},
onfocusin:function(e){var t=this.getTable();if(!t||b.getCellInfo(e.target).cell==null){return;}if(t._mTimeouts._cleanupACCExtension){q.sap.clearDelayedCall(t._mTimeouts._cleanupACCExtension);t._mTimeouts._cleanupACCExtension=null;}this.updateAccForCurrentCell(true);},
onfocusout:function(e){var t=this.getTable();if(!t){return;}t._mTimeouts._cleanupACCExtension=q.sap.delayedCall(100,this,function(){var t=this.getTable();if(!t){return;}this._iLastRowNumber=null;this._iLastColumnNumber=null;E.cleanupCellModifications(this);t._mTimeouts._cleanupACCExtension=null;});}
});
d.ELEMENTTYPES={DATACELL:"DATACELL",COLUMNHEADER:"COLUMNHEADER",ROWHEADER:"ROWHEADER",ROWACTION:"ROWACTION",COLUMNROWHEADER:"COLUMNROWHEADER",ROOT:"ROOT",CONTENT:"CONTENT",TABLE:"TABLE",TABLEHEADER:"TABLEHEADER",TABLEFOOTER:"TABLEFOOTER",TABLESUBHEADER:"TABLESUBHEADER",COLUMNHEADER_TBL:"COLUMNHEADER_TABLE",COLUMNHEADER_ROW:"COLUMNHEADER_ROW",ROWHEADER_COL:"ROWHEADER_COL",TH:"TH",ROWHEADER_TD:"ROWHEADER_TD",TR:"TR",TREEICON:"TREEICON",ROWACTIONHEADER:"ROWACTIONHEADER",NODATA:"NODATA",OVERLAY:"OVERLAY"};
d.prototype.getAccMode=function(){return this._accMode;};
d.prototype.updateAccForCurrentCell=function(o){if(!this._accMode||!this.getTable()._getItemNavigation()){return;}var t=this.getTable();if(t._mTimeouts._cleanupACCFocusRefresh){q.sap.clearDelayedCall(t._mTimeouts._cleanupACCFocusRefresh);t._mTimeouts._cleanupACCFocusRefresh=null;}if(o){E.cleanupCellModifications(this);}var i=E.getInfoOfFocusedCell(this);var s;if(!i||!i.cell){return;}if(i.isOfType(c.DATACELL)){s=d.ELEMENTTYPES.DATACELL;}else if(i.isOfType(c.COLUMNHEADER)){s=d.ELEMENTTYPES.COLUMNHEADER;}else if(i.isOfType(c.ROWHEADER)){s=d.ELEMENTTYPES.ROWHEADER;}else if(i.isOfType(c.ROWACTION)){s=d.ELEMENTTYPES.ROWACTION;}else if(i.isOfType(c.COLUMNROWHEADER)){s=d.ELEMENTTYPES.COLUMNROWHEADER;}if(!E["modifyAccOf"+s]){return;}if(!o){if(i.isOfType(c.DATACELL|c.ROWHEADER)){t._mTimeouts._cleanupACCFocusRefresh=q.sap.delayedCall(100,this,function($){var t=this.getTable();if(!t){return;}var i=E.getInfoOfFocusedCell(this);if(i&&i.cell&&i.cell.get(0)&&$.get(0)===i.cell.get(0)){i.cell.blur().focus();}t._mTimeouts._cleanupACCFocusRefresh=null;},[i.cell]);}return;}E["modifyAccOf"+s].apply(this,[i.cell,o]);};
d.prototype.updateAriaStateOfColumn=function(o){if(!this._accMode){return;}var m=E.getAriaAttributesFor(this,d.ELEMENTTYPES.COLUMNHEADER,{headerId:o.getId(),column:o,index:this.getTable().indexOfColumn(o)});var h=E.getRelevantColumnHeaders(this.getTable(),o);for(var i=0;i<h.length;i++){var H=q.sap.byId(h[i]);if(!H.attr("colspan")){H.attr({"aria-sort":m["aria-sort"]||null});}}};
d.prototype.updateAriaStateOfRow=function(r,R,i){if(!this._accMode){return;}if(!R){R=r.getDomRefs(true);}if(R.row){R.row.children("td").add(R.row).attr("aria-selected",i?"true":null);if(i&&R.rowSelectorText){var t=R.rowSelectorText.text();if(t){t=this.getTable()._oResBundle.getText("TBL_ROW_DESC_SELECTED")+" "+t;}R.rowSelectorText.text(t);}}};
d.prototype.updateAriaExpandAndLevelState=function(r,s,R,f,$,g,e,L,t){if(!this._accMode){return;}var h=null,o=this.getTable(),j=[s,s.children(),R,f,f?f.children():null,$],k=!!t,B=o.getBinding("rows");if(!g&&R&&!k){var I=R.attr("data-sap-ui-rowindex");var m=E.getAriaAttributesFor(this,d.ELEMENTTYPES.ROWHEADER,{rowSelected:!r._bHidden&&o.isIndexSelected(I)});h=m["title"]||null;}if(R&&!k){R.attr({"aria-haspopup":g?"true":null,"title":h});}if(B&&B.hasTotaledMeasures&&L>0&&(!B.bProvideGrandTotals||!B.hasTotaledMeasures())){L=L-1;}for(var i=0;i<j.length;i++){if(j[i]){j[i].attr({"aria-expanded":g?e+"":null,"aria-level":L<0?null:(L+1)});}}if(k){t.attr(E.getAriaAttributesFor(this,d.ELEMENTTYPES.TREEICON,{row:r}));}};
d.prototype.updateAriaStateOfRowHighlight=function(r){if(!this._accMode||r==null){return;}var R=r._getRow();if(R!=null){var h=R.getDomRef("highlighttext");h.innerText=r._getHighlightText();}};
d.prototype.updateAriaStateForOverlayAndNoData=function(){var t=this.getTable();if(!t||!t.getDomRef()||!this._accMode){return;}if(t.getShowOverlay()){t.$().find("[data-sap-ui-table-acc-covered*='overlay']").attr("aria-hidden","true");}else{t.$().find("[data-sap-ui-table-acc-covered*='overlay']").removeAttr("aria-hidden");if(b.isNoDataVisible(t)){t.$().find("[data-sap-ui-table-acc-covered*='nodata']").attr("aria-hidden","true");}else{t.$().find("[data-sap-ui-table-acc-covered*='nodata']").removeAttr("aria-hidden");}}};
d.prototype.getAriaTextsForSelectionMode=function(e,s){var t=this.getTable();if(!s){s=t.getSelectionMode();}var r=t._oResBundle;var f=t._getShowStandardTooltips();var m={mouse:{rowSelect:"",rowDeselect:""},keyboard:{rowSelect:"",rowDeselect:""}};var i=t._getSelectedIndicesCount();if(s===S.Single){m.mouse.rowSelect=f?r.getText("TBL_ROW_SELECT"):"";m.mouse.rowDeselect=f?r.getText("TBL_ROW_DESELECT"):"";m.keyboard.rowSelect=r.getText("TBL_ROW_SELECT_KEY");m.keyboard.rowDeselect=r.getText("TBL_ROW_DESELECT_KEY");}else if(s===S.MultiToggle){m.mouse.rowSelect=f?r.getText("TBL_ROW_SELECT_MULTI_TOGGLE"):"";m.mouse.rowDeselect=f?r.getText("TBL_ROW_DESELECT"):"";m.keyboard.rowSelect=r.getText("TBL_ROW_SELECT_MULTI_TOGGLE_KEY");m.keyboard.rowDeselect=r.getText("TBL_ROW_DESELECT_KEY");if(e===true&&i===0){m.mouse.rowSelect=f?r.getText("TBL_ROW_SELECT"):"";m.keyboard.rowSelect=r.getText("TBL_ROW_SELECT_KEY");}}return m;};
d.prototype.setSelectAllState=function(s){var t=this.getTable();if(t){t.$("selall").attr("aria-pressed",s?"true":"false");}};
d.prototype.addColumnHeaderLabel=function(o,e){var t=this.getTable();if(!this._accMode||!e.getAriaLabelledBy||!t){return;}var L=t.getColumnHeaderVisible()?o.getId():null;if(!L){var f=o.getAggregation("label");if(f){L=f.getId();}}var g=e.getAriaLabelledBy();if(L&&q.inArray(L,g)<0){e.addAriaLabelledBy(L);}};
return d;});
sap.ui.predefine('sap/ui/table/TableAccRenderExtension',["jquery.sap.global","./TableExtension","./library"],function(q,T,l){"use strict";var S=l.SelectionMode;var _=function(r,p,i,t,c){c=c||[];c.push("sapUiInvisibleText");r.write("<span");r.writeAttribute("id",p+"-"+i);r.writeAttribute("class",c.join(" "));r.writeAttribute("aria-hidden","true");r.write(">");if(t){r.writeEscaped(t);}r.write("</span>");};
var A=T.extend("sap.ui.table.TableAccRenderExtension",{
_init:function(t,s,m){return"AccRenderExtension";},
writeHiddenAccTexts:function(r,t){if(!t._getAccExtension().getAccMode()){return;}var b=t._oResBundle,s=t.getId();r.write("<div class='sapUiTableHiddenTexts' style='display:none;' aria-hidden='true'>");var d=t.getTitle()&&t.getTitle().getText&&t.getTitle().getText()!=""?t.getTitle().getText():"";_(r,s,"ariadesc",d);_(r,s,"ariacount");_(r,s,"toggleedit",b.getText("TBL_TOGGLE_EDIT_KEY"));_(r,s,"ariaselectall",b.getText("TBL_SELECT_ALL"));_(r,s,"ariarowheaderlabel",b.getText("TBL_ROW_HEADER_LABEL"));_(r,s,"ariarowgrouplabel",b.getText("TBL_ROW_GROUP_LABEL"));_(r,s,"ariagrandtotallabel",b.getText("TBL_GRAND_TOTAL_ROW"));_(r,s,"ariagrouptotallabel",b.getText("TBL_GROUP_TOTAL_ROW"));_(r,s,"ariacolrowheaderlabel",b.getText("TBL_ROW_COL_HEADER_LABEL"));_(r,s,"rownumberofrows");_(r,s,"colnumberofcols");_(r,s,"cellacc");_(r,s,"ariarowselected",b.getText("TBL_ROW_DESC_SELECTED"));_(r,s,"ariacolmenu",b.getText("TBL_COL_DESC_MENU"));_(r,s,"ariacolspan");_(r,s,"ariacolfiltered",b.getText("TBL_COL_DESC_FILTERED"));_(r,s,"ariacolsortedasc",b.getText("TBL_COL_DESC_SORTED_ASC"));_(r,s,"ariacolsorteddes",b.getText("TBL_COL_DESC_SORTED_DES"));_(r,s,"ariainvalid",b.getText("TBL_TABLE_INVALID"));var o=t.getSelectionMode();if(o!==S.None){_(r,s,"ariaselection",b.getText(o==S.MultiToggle?"TBL_TABLE_SELECTION_MULTI":"TBL_TABLE_SELECTION_SINGLE"));}if(t.getFixedColumnCount()>0){_(r,s,"ariafixedcolumn",b.getText("TBL_FIXED_COLUMN"));}r.write("</div>");},
writeAriaAttributesFor:function(r,t,s,p){var e=t._getAccExtension();if(!e.getAccMode()){return;}var a=e.getAriaAttributesFor(s,p);var v,k;for(k in a){v=a[k];if(q.isArray(v)){v=v.join(" ");}if(v){r.writeAttributeEscaped(k,v);}}},
writeAccRowSelectorText:function(r,t,R,i){if(!t._getAccExtension().getAccMode()){return;}var I=t.isIndexSelected(i);var m=t._getAccExtension().getAriaTextsForSelectionMode(true);var s=m.keyboard[I?"rowDeselect":"rowSelect"];_(r,R.getId(),"rowselecttext",R._bHidden?"":s,["sapUiTableAriaRowSel"]);},
writeAccRowHighlightText:function(r,t,R,i){if(!t._getAccExtension().getAccMode()){return;}var o=R.getAggregation("_settings");var h=o._getHighlightText();_(r,R.getId(),"highlighttext",h);}
});
return A;});
sap.ui.predefine('sap/ui/table/TableColumnUtils',['jquery.sap.global','sap/ui/core/Element','sap/ui/Device','./library'],function(q,E,D,l){"use strict";var T={TableUtils:null,initColumnUtils:function(t){if(!t._oColumnInfo){T.updateColumnInfo(t,T.collectColumnInfo(t));}},invalidateColumnUtils:function(t){t._oColumnInfo=null;},updateColumnInfo:function(t,c){t._oColumnInfo=c;},collectColumnInfo:function(t){return{columnCount:t.getColumns().length,visibleColumnCount:T.TableUtils.getVisibleColumnCount(t),columnMap:T._getColumnMap(t)};},_getColumnMap:function(t){var i;var c;var C={};var o={};var a=t.getColumns();var m=T.TableUtils.getHeaderRowCount(t);var p={};for(var b=0;b<a.length;b++){c=a[b];C={};C.id=c.getId();C.column=c;C.levelInfo=[];C.parents=[];for(var L=0;L<m;L++){C.levelInfo[L]={};C.levelInfo[L].spannedColumns=[];var h=T.getHeaderSpan(c,L);for(i=1;i<h;i++){var s=a[b+i];if(s){var P=s.getId();C.levelInfo[L].spannedColumns.push(a[b+i]);if(!p[P]){p[P]=[];}p[P].push({column:c,level:L});}}}o[C.id]=C;}var d=Object.keys(p);for(i=0;i<d.length;i++){var e=d[i];o[e].parents=p[e];}return o;},_getColumnMapItem:function(t,c){T.initColumnUtils(t);var s=t._oColumnInfo.columnMap[c];if(!s){q.sap.log.error("Column with ID '"+c+"' not found",t);}else{return s;}},getParentSpannedColumns:function(t,c,L){var C=T._getColumnMapItem(t,c);if(!C){return undefined;}var p=[];for(var i=0;i<C.parents.length;i++){var P=C.parents[i];if(L===undefined||P.level===L){p.push(P);}}return p;},getChildrenSpannedColumns:function(t,c,L){var C=T._getColumnMapItem(t,c);if(!C){return undefined;}var a=[];var e;if(L===undefined){e=C.levelInfo.length;}else{e=L+1;}for(var i=L||0;i<e;i++){var o=C.levelInfo[i];for(var j=0;j<o.spannedColumns.length;j++){a.push({column:o.spannedColumns[j],level:i});}}return a;},getHeaderSpan:function(c,L){var h=c.getHeaderSpan();var H;if(!h){return 1;}if(!Array.isArray(h)){h=(h+"").split(",");}function g(s){var r=parseInt(s,10);return isNaN(r)?1:r;}if(isNaN(L)){H=Math.max.apply(null,h.map(g));}else{H=g(h[L]);}return Math.max(H,1);},getMaxHeaderSpan:function(c){return T.getHeaderSpan(c);},hasHeaderSpan:function(c){return T.getHeaderSpan(c)>1;},getColumnBoundaries:function(t,c){var C=T._getColumnMapItem(t,c);if(!C){return undefined;}var m={};if(c){m[c]=C.column;}var f=function(m,n){var o;var i;var g=[];n=n||[];for(i=0;i<n.length;i++){o=m[n[i]];g=g.concat(T.getParentSpannedColumns(t,o.getId()));g=g.concat(T.getChildrenSpannedColumns(t,o.getId()));}n=[];for(i=0;i<g.length;i++){o=g[i].column;var c=o.getId();if(!m[c]){n.push(c);m[c]=o;}}if(n.length>0){return f(m,n);}else{return m;}};m=f(m,[c]);var a=t.indexOfColumn(C.column);var b={startColumn:C.column,startIndex:a,endColumn:C.column,endIndex:-1};var d=t.getColumns();var k=Object.getOwnPropertyNames(m);for(var i=0;i<k.length;i++){var o=m[k[i]];a=t.indexOfColumn(o);var h=T.getMaxHeaderSpan(o);if(a<b.startIndex){b.startIndex=a;b.startColumn=o;}var e=a+h-1;if(e>b.endIndex){b.endIndex=e;b.endColumn=d[e];}}return b;},isColumnMovable:function(c){var t=c.getParent();if(!t||!t.getEnableColumnReordering()){return false;}var C=t.indexOfColumn(c);if(C<t.getFixedColumnCount()||C<t._iFirstReorderableIndex){return false;}if(T.hasHeaderSpan(c)||T.getParentSpannedColumns(t,c.getId()).length!=0){return false;}return true;},_normalizeColumnMoveTargetIndex:function(c,n){var t=c.getParent(),C=t.indexOfColumn(c),a=t.getColumns();if(n>C){n--;}if(n<0){n=0;}else if(n>a.length){n=a.length;}return n;},isColumnMovableTo:function(c,n){var t=c.getParent();if(!t||n===undefined||!T.isColumnMovable(c)){return false;}n=T._normalizeColumnMoveTargetIndex(c,n);if(n<t.getFixedColumnCount()||n<t._iFirstReorderableIndex){return false;}var C=t.indexOfColumn(c),a=t.getColumns();if(n>C){var b=a[n>=a.length?a.length-1:n];var o=T.getColumnBoundaries(t,b.getId());if(T.hasHeaderSpan(b)||o.endIndex>n){return false;}}else{var A=a[n];if(T.getParentSpannedColumns(t,A.getId()).length!=0){return false;}}return true;},moveColumnTo:function(c,n){if(!T.isColumnMovableTo(c,n)){return false;}var t=c.getParent(),C=t.indexOfColumn(c);if(n===C){return false;}n=T._normalizeColumnMoveTargetIndex(c,n);var e=t.fireColumnMove({column:c,newPos:n});if(!e){return false;}t._bReorderInProcess=true;t.removeColumn(c);t.insertColumn(c,n);t._bReorderInProcess=false;return true;},getMinColumnWidth:function(){if(this._iColMinWidth){return this._iColMinWidth;}this._iColMinWidth=48;if(!D.system.desktop){this._iColMinWidth=88;}return this._iColMinWidth;},resizeColumn:function(t,c,w,f,C){if(t==null||c==null||c<0||w==null||w<=0){return false;}if(C==null||C<=0){C=1;}if(f==null){f=true;}var a=t.getColumns();if(c>=a.length||!a[c].getVisible()){return false;}var v=[];for(var i=c;i<a.length;i++){var o=a[i];if(o.getVisible()){v.push(o);if(v.length===C){break;}}}var r=[];for(var i=0;i<v.length;i++){var V=v[i];if(V.getResizable()){r.push(V);}}if(r.length===0){return false;}var s=0;for(var i=0;i<v.length;i++){var V=v[i];s+=T.getColumnWidth(t,V.getIndex());}var p=w-s;var S=Math.round(p/r.length);var R=false;var b=t.getDomRef();if(!T.TableUtils.isFixedColumn(t,c)){t._getVisibleColumns().forEach(function(m){var u=m.getWidth(),x;if(b&&r.indexOf(m)<0&&T.TableUtils.isVariableWidth(u)){x=b.querySelector('th[data-sap-ui-colid="'+m.getId()+'"]');if(x){m._minWidth=Math.max(x.offsetWidth,T.getMinColumnWidth());}}});}for(var i=0;i<r.length;i++){var d=r[i];var e=T.getColumnWidth(t,d.getIndex());var n=e+S;var g=T.getMinColumnWidth();if(n<g){n=g;}var W=n-e;if(Math.abs(W)<Math.abs(S)){var h=r.length-(i+1);p-=W;S=Math.round(p/h);}if(W!==0){var j=true;var k=n+"px";if(f){j=t.fireColumnResize({column:d,width:k});}if(j){d.setWidth(k);R=true;}}}return R;},getColumnWidth:function(t,c){if(t==null||c==null||c<0){return null;}var C=t.getColumns();if(c>=C.length){return null;}var o=C[c];var s=o.getWidth();if(s===""||s==="auto"||s.match(/%$/)){if(o.getVisible()){var a=o.getDomRef();return a!=null?a.offsetWidth:0;}else{return 0;}}else{return t._CSSSizeToPixel(s);}},getFixedColumnCount:function(t,c){var f=t.getFixedColumnCount();if(!c){return f;}if(f<=0||t._bIgnoreFixedColumnCount){return 0;}var C=t.getColumns();var v=0;f=Math.min(f,C.length);for(var i=0;i<f;i++){if(C[i].shouldRender()){v++;}}return v;}};return T;},true);
sap.ui.predefine('sap/ui/table/TableDragDropExtension',['jquery.sap.global','./TableExtension'],function(q,T){"use strict";var E={};var a={};
var b=T.extend("sap.ui.table.TableDragDropExtension",{
_init:function(t,s,S){this._type=s;this._delegate=a;t.addEventDelegate(this._delegate,t);return"DragDropExtension";},
_attachEvents:function(){},
_detachEvents:function(){},
_debug:function(){this._ExtensionHelper=E;this._ExtensionDelegate=a;},
destroy:function(){var t=this.getTable();if(t){t.removeEventDelegate(this._delegate);}this._delegate=null;T.prototype.destroy.apply(this,arguments);}
});
return b;},true);
sap.ui.predefine('sap/ui/table/TableExtension',["jquery.sap.global","sap/ui/base/Object","./TableUtils"],function(q,B,T){"use strict";
var a=B.extend("sap.ui.table.TableExtension",{
_table:null,
_type:null,
_settings:null,
constructor:function(t,s){B.call(this);this._table=t;this._settings=s||{};this._type=a.TABLETYPES.STANDARD;if(T.isInstanceOf(t,"sap/ui/table/TreeTable")){this._type=a.TABLETYPES.TREE;}else if(T.isInstanceOf(t,"sap/ui/table/AnalyticalTable")){this._type=a.TABLETYPES.ANALYTICAL;}var e=this._init(this._table,this._type,this._settings);if(e){var b=this;t["_get"+e]=function(){return b;};}},
destroy:function(){this._table=null;this._type=null;B.prototype.destroy.apply(this,arguments);},
getInterface:function(){return this;}
});
a.TABLETYPES={TREE:"TREE",ANALYTICAL:"ANALYTICAL",STANDARD:"STANDARD"};
a.prototype.getTable=function(){return this._table;};
a.prototype._init=function(t,s,S){return null;};
a.prototype._attachEvents=function(){};
a.prototype._detachEvents=function(){};
a.attachEvents=function(t){if(!t._aExtensions){return;}for(var i=0;i<t._aExtensions.length;i++){t._aExtensions[i]._attachEvents();}};
a.detachEvents=function(t){if(!t._aExtensions){return;}for(var i=0;i<t._aExtensions.length;i++){t._aExtensions[i]._detachEvents();}};
a.enrich=function(t,E,s){if(!E||!(E.prototype instanceof a)){return null;}var e=new E(t,s);if(!t._aExtensions){t._aExtensions=[];}t._aExtensions.push(e);return e;};
a.cleanup=function(t){if(!t._bExtensionsInitialized||!t._aExtensions){return;}for(var i=0;i<t._aExtensions.length;i++){t._aExtensions[i].destroy();}delete t._aExtensions;delete t._bExtensionsInitialized;};
return a;});
sap.ui.predefine('sap/ui/table/TableGrouping',['jquery.sap.global','sap/ui/core/Element','sap/ui/model/Sorter','sap/ui/Device','./library'],function(q,E,S,D,l){"use strict";var T={TableUtils:null,clearMode:function(t){t._mode=null;},setGroupMode:function(t){t._mode="Group";},isGroupMode:function(t){return t._mode=="Group";},setTreeMode:function(t){t._mode="Tree";},isTreeMode:function(t){return t._mode=="Tree";},getModeCssClass:function(t){if(t._mode){return"sapUiTable"+t._mode+"Mode";}return null;},showGroupMenuButton:function(t){if(t._bShowGroupMenuButton===true||t._bShowGroupMenuButton===false){return t._bShowGroupMenuButton;}if(!D.system.desktop&&T.TableUtils.isInstanceOf(t,"sap/ui/table/AnalyticalTable")){t._bShowGroupMenuButton=true;}else{t._bShowGroupMenuButton=false;}return t._bShowGroupMenuButton;},toggleGroupHeader:function(t,r,e){var b=t.getBinding("rows");if(b){var i=b.isExpanded(r);var I=true;if(b.nodeHasChildren!=null){if(b.getNodeByIndex!=null){I=!b.nodeHasChildren(b.getNodeByIndex(r));}else{I=false;}}if(I){return null;}else if(e===true&&!i){b.expand(r);}else if(e===false&&i){b.collapse(r);}else if(e!==true&&e!==false){b.toggleIndex(r);}else{return null;}return!i;}return null;},toggleGroupHeaderByRef:function(t,r,e){var R=q(r);var g;if(R.hasClass("sapUiTableTreeIcon")||(T.isTreeMode(t)&&R.hasClass("sapUiTableTdFirst"))){g=R.closest("tr",t.getDomRef());}else{g=R.closest(".sapUiTableGroupHeader",t.getDomRef());}var b=t.getBinding("rows");if(g.length>0&&b){var G=g.data("sap-ui-rowindex");var o=t.getRows()[G];if(o!=null){var a=o.getIndex();var i=T.toggleGroupHeader(t,a,e);var c=i===true||i===false;if(c&&t._onGroupHeaderChanged){t._onGroupHeaderChanged(a,i);}return c;}}return false;},isInGroupingRow:function(c){var i=T.TableUtils.getCellInfo(c);if(i.isOfType(T.TableUtils.CELLTYPE.DATACELL)){return i.cell.parent().hasClass("sapUiTableGroupHeader");}else if(i.isOfType(T.TableUtils.CELLTYPE.ROWHEADER|T.TableUtils.CELLTYPE.ROWACTION)){return i.cell.hasClass("sapUiTableGroupHeader");}return false;},isGroupingRow:function(r){if(!r){return false;}return q(r).hasClass("sapUiTableGroupHeader");},isInSumRow:function(c){var i=T.TableUtils.getCellInfo(c);if(i.isOfType(T.TableUtils.CELLTYPE.DATACELL)){return i.cell.parent().hasClass("sapUiAnalyticalTableSum");}else if(i.isOfType(T.TableUtils.CELLTYPE.ROWHEADER|T.TableUtils.CELLTYPE.ROWACTION)){return i.cell.hasClass("sapUiAnalyticalTableSum");}return false;},_calcGroupIndent:function(t,L,c){if(T.TableUtils.isInstanceOf(t,"sap/ui/table/TreeTable")){var I=0;for(var i=0;i<L;i++){I=I+(i<2?12:8);}return I;}else if(T.TableUtils.isInstanceOf(t,"sap/ui/table/AnalyticalTable")){var I=0;L=L-1;L=!c?L-1:L;L=Math.max(L,0);for(var i=0;i<L;i++){if(I==0){I=12;}I=I+(i<2?12:8);}return I;}else{var I=0;L=!c?L-1:L;L=Math.max(L,0);for(var i=0;i<L;i++){I=I+(i<2?12:8);}return I;}},_setIndent:function(t,r,R,i){var b=t._bRtlMode,f=r.find("td.sapUiTableTdFirst > .sapUiTableCell"),s=R.find(".sapUiTableGroupShield");if(i<=0){R.css(b?"right":"left","");s.css("width","").css(b?"margin-right":"margin-left","");f.css(b?"padding-right":"padding-left","");}else{R.css(b?"right":"left",i+"px");s.css("width",i+"px").css(b?"margin-right":"margin-left",((-1)*i)+"px");f.css(b?"padding-right":"padding-left",(i+8)+"px");}},updateTableRowForGrouping:function(t,r,c,e,h,s,L,g){var d=r.getDomRefs(true),R=d.row,$=d.rowScrollPart,f=d.rowFixedPart,a=d.rowSelector,b=d.rowAction;R.attr({"data-sap-ui-level":L});R.data("sap-ui-level",L);if(T.isGroupMode(t)){R.toggleClass("sapUiAnalyticalTableSum",!c&&s).toggleClass("sapUiAnalyticalTableDummy",false).toggleClass("sapUiTableGroupHeader",c).toggleClass("sapUiTableRowHidden",c&&h||r._bHidden);q.sap.byId(r.getId()+"-groupHeader").toggleClass("sapUiTableGroupIconOpen",c&&e).toggleClass("sapUiTableGroupIconClosed",c&&!e).attr("title",t._getShowStandardTooltips()&&g?g:null).text(g||"");T._setIndent(t,R,a,T._calcGroupIndent(t,L,c));}var i=null;if(T.isTreeMode(t)){i=R.find(".sapUiTableTreeIcon");i.css(t._bRtlMode?"margin-right":"margin-left",(L*17)+"px").toggleClass("sapUiTableTreeIconLeaf",!c).toggleClass("sapUiTableTreeIconNodeOpen",c&&e).toggleClass("sapUiTableTreeIconNodeClosed",c&&!e);}if(T.showGroupMenuButton(t)){var j=0;var k=t.$();if(k.hasClass("sapUiTableVScr")){j+=k.find('.sapUiTableVSb').width();}var G=a.find(".sapUiTableGroupMenuButton");if(t._bRtlMode){G.css("right",(k.width()-G.width()+a.position().left-j-5)+"px");}else{G.css("left",(k.width()-G.width()-a.position().left-j-5)+"px");}}t._getAccExtension().updateAriaExpandAndLevelState(r,$,a,f,b,c,e,L,i);},cleanupTableRowForGrouping:function(t,r){var d=r.getDomRefs(true);d.row.removeAttr("data-sap-ui-level");d.row.removeData("sap-ui-level");if(T.isGroupMode(t)){d.row.removeClass("sapUiTableGroupHeader sapUiAnalyticalTableSum sapUiAnalyticalTableDummy");T._setIndent(t,d.row,d.rowSelector,0);}var $=null;if(T.isTreeMode(t)){$=d.row.find(".sapUiTableTreeIcon");$.removeClass("sapUiTableTreeIconLeaf").removeClass("sapUiTableTreeIconNodeOpen").removeClass("sapUiTableTreeIconNodeClosed").css(this._bRtlMode?"margin-right":"margin-left","");}t._getAccExtension().updateAriaExpandAndLevelState(r,d.rowScrollPart,d.rowSelector,d.rowFixedPart,d.rowAction,false,false,-1,$);},updateGroups:function(t){if(T.isGroupMode(t)||T.isTreeMode(t)){var b=t.getBinding("rows"),r=t.getBindingInfo("rows"),R=t.getRows(),c=R.length;if(b){var o;for(var i=0;i<c;i++){o=T._getRowGroupInfo(t,R[i],b,r);T.updateTableRowForGrouping(t,R[i],o.isHeader,o.expanded,o.hidden,false,o.level,o.title);}}else{for(var i=0;i<c;i++){T.cleanupTableRowForGrouping(t,R[i]);}}}},_getRowGroupInfo:function(t,r,R,o){var a={isHeader:false,expanded:false,hidden:false,title:"",level:0};if(t.getGroupHeaderProperty){a.isHeader=r._bHasChildren;a.expanded=r._bIsExpanded;a.hidden=a.isHeader;a.level=r._iLevel;var h=t.getGroupHeaderProperty();if(T.isGroupMode(t)&&h){var m=o&&o.model;a.title=t.getModel(m).getProperty(h,r.getBindingContext(m));}}else{var i=r.getIndex();a.isHeader=!!R.isGroupHeader(i);a.level=a.isHeader?0:1;if(a.isHeader){a.expanded=!!R.isExpanded(i);a.hidden=true;a.title=R.getTitle(i);}}return a;},setupExperimentalGrouping:function(t){if(!t.getEnableGrouping()){return;}var b=E.prototype.getBinding.call(t,"rows");var g=sap.ui.getCore().byId(t.getGroupBy());var I=g&&g.getGrouped()&&b&&T.TableUtils.isInstanceOf(b,"sap/ui/model/ClientListBinding");if(!I||b._modified){return;}b._modified=true;T.setGroupMode(t);var p=g.getSortProperty();b.sort(new S(p));var L=b.getLength(),c=b.getContexts(0,L);var k;var C=0;for(var i=L-1;i>=0;i--){var n=c[i].getProperty(p);if(!k){k=n;}if(k!==n){var G=c[i+1].getModel().getContext("/sap.ui.table.GroupInfo"+i);G.__groupInfo={oContext:c[i+1],name:k,count:C,groupHeader:true,expanded:true};c.splice(i+1,0,G);k=n;C=0;}C++;}var G=c[0].getModel().getContext("/sap.ui.table.GroupInfo");G.__groupInfo={oContext:c[0],name:k,count:C,groupHeader:true,expanded:true};c.splice(0,0,G);q.extend(b,{getLength:function(){return c.length;},getContexts:function(s,L){return c.slice(s,s+L);},isGroupHeader:function(a){var o=c[a];return(o&&o.__groupInfo&&o.__groupInfo.groupHeader)===true;},getTitle:function(a){var o=c[a];return o&&o.__groupInfo&&o.__groupInfo.name+" - "+o.__groupInfo.count;},isExpanded:function(a){var o=c[a];return this.isGroupHeader(a)&&o.__groupInfo&&o.__groupInfo.expanded;},expand:function(a){if(this.isGroupHeader(a)&&!c[a].__groupInfo.expanded){for(var i=0;i<c[a].__childs.length;i++){c.splice(a+1+i,0,c[a].__childs[i]);}delete c[a].__childs;c[a].__groupInfo.expanded=true;this._fireChange();}},collapse:function(a){if(this.isGroupHeader(a)&&c[a].__groupInfo.expanded){c[a].__childs=c.splice(a+1,c[a].__groupInfo.count);c[a].__groupInfo.expanded=false;this._fireChange();}},toggleIndex:function(a){if(this.isExpanded(a)){this.collapse(a);}else{this.expand(a);}},nodeHasChildren:function(o){if(o==null||o.__groupInfo==null){return false;}else{return o.__groupInfo.groupHeader===true;}},getNodeByIndex:function(a){return c[a];}});t._mTimeouts.groupingFireBindingChange=t._mTimeouts.groupingFireBindingChange||window.setTimeout(function(){b._fireChange();},0);},resetExperimentalGrouping:function(t){var b=t.getBinding("rows");if(b&&b._modified){T.clearMode(t);var B=t.getBindingInfo("rows");t.unbindRows();t.bindRows(B);}}};return T;},true);
sap.ui.predefine('sap/ui/table/TableKeyboardDelegate2',["jquery.sap.global","sap/ui/base/Object","sap/ui/Device","./library","./TableUtils"],function(q,B,D,l,T){"use strict";var C=T.CELLTYPE;var S=l.SelectionMode;var M={CTRL:1,SHIFT:2,ALT:4};var N={LEFT:"Left",RIGHT:"Right",UP:"Up",DOWN:"Down"};var I=":sapTabbable, input:sapFocusable, .sapUiTableTreeIcon:not(.sapUiTableTreeIconLeaf)";var H=5;var a="1em";
function p(e,P){e.setMarked("sapUiTableSkipItemNavigation",P!==false);}
var b=B.extend("sap.ui.table.TableKeyboardDelegate2",{
constructor:function(t){B.call(this);},
destroy:function(){B.prototype.destroy.apply(this,arguments);},
getInterface:function(){return this;}
});
b._restoreFocusOnLastFocusedDataCell=function(t,e){var c=T.getFocusedItemInfo(t);var L=t._getKeyboardExtension()._getLastFocusedCellInfo();T.focusItem(t,c.cellInRow+(c.columnCount*L.row),e);};
b._setFocusOnColumnHeaderOfLastFocusedDataCell=function(t,e){var c=T.getFocusedItemInfo(t);T.focusItem(t,c.cellInRow,e);};
b._forwardFocusToTabDummy=function(t,s){t._getKeyboardExtension()._setSilentFocus(t.$().find("."+s));};
b._isKeyCombination=function(e,k,m){if(m==null){m=0;}var c=typeof k==="string"?String.fromCharCode(e.charCode):e.keyCode;var d=0;d|=(D.os.macintosh?e.metaKey:e.ctrlKey)&&k!==q.sap.KeyCodes.CONTROL?M.CTRL:0;d|=e.shiftKey&&k!==q.sap.KeyCodes.SHIFT?M.SHIFT:0;d|=e.altKey&&k!==q.sap.KeyCodes.ALT?M.ALT:0;var v=k==null||c===k;var V=m===d;return v&&V;};
b._handleSpaceAndEnter=function(t,e){var c=T.getCellInfo(e.target);if(c.isOfType(C.COLUMNROWHEADER)){t._toggleSelectAll();}else if(b._isElementGroupToggler(t,e.target)){T.Grouping.toggleGroupHeaderByRef(t,e.target);}else if(c.isOfType(C.ROWHEADER)){T.toggleRowSelection(t,e.target);}else if(c.isOfType(C.DATACELL|C.ROWACTION)){var E=!t.hasListeners("cellClick");if(!t._findAndfireCellEvent(t.fireCellClick,e)){if(T.isRowSelectionAllowed(t)){T.toggleRowSelection(t,e.target);E=false;}}if(E){var i=b._getInteractiveElements(e.target);if(i!==null){t._getKeyboardExtension().setActionMode(true);}}}};
b._moveColumn=function(c,n){var t=c.getParent();var v=t._getVisibleColumns();var i=v.indexOf(c);var d;if(n&&i<v.length-1){d=t.indexOfColumn(v[i+1])+1;}else if(!n&&i>0){d=t.indexOfColumn(v[i-1]);}if(d!=null){T.Column.moveColumnTo(c,d);}};
b._getVisibleAndGroupedColumns=function(t){return t.getColumns().filter(function(c){return c.getVisible()||c.getGrouped();});};
b._getColumnIndexInVisibleAndGroupedColumns=function(t,c){var v=b._getVisibleAndGroupedColumns(t);for(var i=0;i<v.length;i++){var V=v[i];if(V===c){return i;}}return-1;};
b._focusElement=function(t,e,s,c){if(t==null||e==null){return;}if(s==null){s=false;}if(c==null){c=false;}function h(e){return e instanceof window.HTMLInputElement&&/^(text|password|search|tel|url)$/.test(e.type);}if(h(document.activeElement)){document.activeElement.setSelectionRange(0,0);}if(c){t._getKeyboardExtension()._setSilentFocus(e);}else{e.focus();}if(s&&h(e)){e.select();}};
b._focusCell=function(t,c,r,i,f){if(t==null||c==null||r==null||r<0||r>=t.getRows().length){return;}var R=t.getRows()[r];var o;if(c===C.ROWHEADER){t._getKeyboardExtension()._setFocus(t.getDomRef("rowsel"+r));return;}else if(c===C.ROWACTION){o=t.getDomRef("rowact"+r);}else if(c===C.DATACELL&&(i!=null&&i>=0&&i<T.getVisibleColumnCount(t))){var d=t.getColumns()[i];var e=b._getColumnIndexInVisibleAndGroupedColumns(t,d);o=R.getDomRef("col"+e);}if(o==null){return;}if(f){var $=b._getInteractiveElements(o);if($!=null){b._focusElement(t,$[0],true);return;}}o.focus();};
b._navigate=function(t,e,d){if(e.isMarked()){return;}var k=t._getKeyboardExtension();var A=k.isInActionMode();var c=T.getCellInfo(T.getCell(t,e.target));var s=false;if((d===N.UP||d===N.DOWN)&&c.isOfType(C.ANYCONTENTCELL)){var f=b._isKeyCombination(e,null,M.CTRL);var g=f||A;var P=T.getParentCell(t,e.target);if(!f&&(e.target instanceof window.HTMLInputElement||e.target instanceof window.HTMLTextAreaElement)){return;}if(!g&&P!=null){P.focus();return;}p(e);if(d===N.UP){if(T.isFirstScrollableRow(t,c.cell)){s=t._getScrollExtension().scroll(false,false,true);}}else if(T.isLastScrollableRow(t,c.cell)){s=t._getScrollExtension().scroll(true,false,true);}if(s){e.preventDefault();if(g){t.attachEventOnce("_rowsUpdated",function(){setTimeout(function(){b._focusCell(t,c.type,c.rowIndex,c.columnIndex,true);},0);});}}else if(d===N.UP&&c.rowIndex===0){p(e,c.isOfType(C.ROWACTION)||g);if(!A&&P!=null){P.focus();}else{k.setActionMode(false);}}else if(d===N.DOWN&&c.rowIndex===t.getVisibleRowCount()-1){if(!A&&P!=null){P.focus();}else{k.setActionMode(false);}}else{var i=d===N.DOWN?1:-1;b._focusCell(t,c.type,c.rowIndex+i,c.columnIndex,g);e.preventDefault();}}else if(d===N.DOWN&&c.isOfType(C.ANYCOLUMNHEADER)){var h=T.getHeaderRowCount(t);if(T.isNoDataVisible(t)){var F=T.getFocusedItemInfo(t);if(F.row-h<=1){p(e);}}else if(c.isOfType(C.COLUMNROWHEADER)&&h>1){p(e);T.focusItem(t,h*(T.getVisibleColumnCount(t)+1),e);}}else if(d===N.LEFT&&!A){var j=sap.ui.getCore().getConfiguration().getRTL();if(c.isOfType(C.COLUMNHEADER)&&j){var o=T.getFocusedItemInfo(t);var m=o.cellInRow-(T.hasRowHeader(t)?1:0);var n=T.getVisibleColumnCount(t);if(T.hasRowActions(t)&&m===n-1){p(e);}}}};
b._isElementGroupToggler=function(t,e){return T.Grouping.isInGroupingRow(e)||(T.Grouping.isTreeMode(t)&&e.classList.contains("sapUiTableTdFirst")&&(e.querySelector(".sapUiTableTreeIconNodeOpen")!=null||e.querySelector(".sapUiTableTreeIconNodeClosed")!=null))||e.classList.contains("sapUiTableTreeIconNodeOpen")||e.classList.contains("sapUiTableTreeIconNodeClosed");};
b._isElementInteractive=function(e){if(e==null){return false;}return q(e).is(I);};
b._getInteractiveElements=function(c){if(c==null){return null;}var $=q(c);var o=T.getCellInfo($);if(o.isOfType(C.DATACELL|C.ROWACTION)){var i=$.find(I);if(i.length>0){return i;}}return null;};
b._getFirstInteractiveElement=function(r){if(r==null){return null;}var t=r.getParent();var c=r.getCells();var $;var d;if(T.hasRowActions(t)){c.push(r.getAggregation("_rowAction"));}for(var i=0;i<c.length;i++){$=T.getParentCell(t,c[i].getDomRef());d=this._getInteractiveElements($);if(d!==null){return d.first();}}return null;};
b._getLastInteractiveElement=function(r){if(r==null){return null;}var t=r.getParent();var c=r.getCells();var $;var d;if(T.hasRowActions(t)){c.push(r.getAggregation("_rowAction"));}for(var i=c.length-1;i>=0;i--){$=T.getParentCell(t,c[i].getDomRef());d=this._getInteractiveElements($);if(d!==null){return d.last();}}return null;};
b._getPreviousInteractiveElement=function(t,e){if(t==null||e==null){return null;}var E=q(e);if(!this._isElementInteractive(E)){return null;}var c=T.getParentCell(t,e);var $;var o;var d;var f;var g;var h;var j;$=this._getInteractiveElements(c);if($[0]!==E[0]){return $.eq($.index(e)-1);}o=T.getCellInfo(c);f=t.getRows()[o.rowIndex].getCells();if(o.isOfType(C.ROWACTION)){j=f.length-1;}else{g=t.getColumns()[o.columnIndex];h=b._getColumnIndexInVisibleAndGroupedColumns(t,g);j=h-1;}for(var i=j;i>=0;i--){d=f[i].getDomRef();c=T.getParentCell(t,d);$=this._getInteractiveElements(c);if($!==null){return $.last();}}return null;};
b._getNextInteractiveElement=function(t,e){if(t==null||e==null){return null;}var E=q(e);if(!this._isElementInteractive(E)){return null;}var c=T.getParentCell(t,e);var $;var o;var d;var f;var g;var r;var h;$=this._getInteractiveElements(c);if($.get(-1)!==E[0]){return $.eq($.index(e)+1);}o=T.getCellInfo(c);if(o.isOfType(C.ROWACTION)){return null;}r=t.getRows()[o.rowIndex];f=r.getCells();g=t.getColumns()[o.columnIndex];h=b._getColumnIndexInVisibleAndGroupedColumns(t,g);for(var i=h+1;i<f.length;i++){d=f[i].getDomRef();c=T.getParentCell(t,d);$=this._getInteractiveElements(c);if($!==null){return $.first();}}if(T.hasRowActions(t)){c=T.getParentCell(t,r.getAggregation("_rowAction").getDomRef());$=this._getInteractiveElements(c);if($.get(-1)!==E[0]){return $.eq($.index(e)+1);}}return null;};
b.prototype.enterActionMode=function(){var k=this._getKeyboardExtension();var A=document.activeElement;var i=b._getInteractiveElements(A);var c=T.getParentCell(this,A);if(i!==null){k._suspendItemNavigation();A.tabIndex=-1;b._focusElement(this,i[0],true,true);return true;}else if(c!==null){this._getKeyboardExtension()._suspendItemNavigation();return true;}return false;};
b.prototype.leaveActionMode=function(A){A=A==null?true:A;var k=this._getKeyboardExtension();var o=document.activeElement;var c=T.getParentCell(this,o);k._resumeItemNavigation();if(A){if(c!==null){b._focusElement(this,c[0],false,true);}else{k._setSilentFocus(o);}}};
b.prototype.onfocusin=function(e){if(e.isMarked("sapUiTableIgnoreFocusIn")){return;}var t=q(e.target);if(t.hasClass("sapUiTableOuterBefore")||t.hasClass("sapUiTableOuterAfter")||(e.target!=this.getDomRef("overlay")&&this.getShowOverlay())){this.$("overlay").focus();}else if(t.hasClass("sapUiTableCtrlBefore")){var n=T.isNoDataVisible(this);if(!n||n&&this.getColumnHeaderVisible()){b._setFocusOnColumnHeaderOfLastFocusedDataCell(this,e);}else{this._getKeyboardExtension()._setSilentFocus(this.$("noDataCnt"));}}else if(t.hasClass("sapUiTableCtrlAfter")){if(!T.isNoDataVisible(this)){b._restoreFocusOnLastFocusedDataCell(this,e);}}var c=T.getParentCell(this,t);var E=c!==null;var i=E&&b._isElementInteractive(t);if(this._getKeyboardExtension().isInActionMode()){var o=T.getCellInfo(e.target);var d=o.cell!=null;var f=o.isOfType(C.ROWHEADER)&&T.Grouping.isInGroupingRow(e.target);var g=o.isOfType(C.ROWHEADER)&&!f&&T.isRowSelectorSelectionAllowed(this);if(d&&!f&&!g){this._getKeyboardExtension().setActionMode(false);}else if(E&&!i){this._getKeyboardExtension().setActionMode(false,false);}}else if(i){this._getKeyboardExtension().setActionMode(true);}};
b.prototype.onkeydown=function(e){var k=this._getKeyboardExtension();if(b._isKeyCombination(e,q.sap.KeyCodes.F2)){var i=k.isInActionMode();var P=T.getParentCell(this,e.target);if(!i&&P!=null){P.focus();}else{k.setActionMode(!i);}return;}else if(b._isKeyCombination(e,q.sap.KeyCodes.F4)&&b._isElementGroupToggler(this,e.target)){T.Grouping.toggleGroupHeaderByRef(this,e.target);return;}if(this._getKeyboardExtension().isInActionMode()){return;}if(b._isKeyCombination(e,q.sap.KeyCodes.SPACE)&&T.getCellInfo(e.target).type){e.preventDefault();}var t=q(e.target);var c=T.getCellInfo(t);var s=this.getSelectionMode();if(b._isKeyCombination(e,q.sap.KeyCodes.SHIFT)&&s===S.MultiToggle&&(c.isOfType(C.ROWHEADER)&&T.isRowSelectorSelectionAllowed(this)||(c.isOfType(C.DATACELL|C.ROWACTION))&&T.isRowSelectionAllowed(this))){var f=T.getRowIndexOfFocusedCell(this);var d=this.getRows()[f].getIndex();this._oRangeSelection={startIndex:d,selected:this.isIndexSelected(d)};}else if(b._isKeyCombination(e,q.sap.KeyCodes.A,M.CTRL)){e.preventDefault();if(c.isOfType(C.ANYCONTENTCELL|C.COLUMNROWHEADER)&&s===S.MultiToggle){this._toggleSelectAll();}}else if(b._isKeyCombination(e,q.sap.KeyCodes.A,M.CTRL+M.SHIFT)){if(c.isOfType(C.ANYCONTENTCELL|C.COLUMNROWHEADER)){this.clearSelection();}}else if(b._isKeyCombination(e,q.sap.KeyCodes.F4)){if(c.isOfType(C.DATACELL)){k.setActionMode(true);}}else if(b._isKeyCombination(e,q.sap.KeyCodes.F10,M.SHIFT)){e.preventDefault();T.Menu.openContextMenu(this,e.target,true);}};
b.prototype.onkeypress=function(e){var k=this._getKeyboardExtension();var c=T.getCellInfo(e.target);if(b._isKeyCombination(e,"+")){if(b._isElementGroupToggler(this,e.target)){T.Grouping.toggleGroupHeaderByRef(this,e.target,true);}else if(c.isOfType(C.DATACELL|C.ROWACTION)){k.setActionMode(true);}}else if(b._isKeyCombination(e,"-")){if(b._isElementGroupToggler(this,e.target)){T.Grouping.toggleGroupHeaderByRef(this,e.target,false);}else if(c.isOfType(C.DATACELL|C.ROWACTION)){k.setActionMode(true);}}};
b.prototype.oncontextmenu=function(e){if(e.isMarked("handledByPointerExtension")){return;}e.preventDefault();var c=T.getCell(this,e.target);var o=T.getCellInfo(c);if(o.isOfType(C.COLUMNHEADER|C.DATACELL)){T.Menu.openContextMenu(this,e.target,true);}};
b.prototype.onkeyup=function(e){var c=T.getCellInfo(e.target);if(b._isKeyCombination(e,q.sap.KeyCodes.SHIFT)){delete this._oRangeSelection;}if(b._isKeyCombination(e,q.sap.KeyCodes.SPACE)){if(c.isOfType(C.COLUMNHEADER)){T.Menu.openContextMenu(this,e.target,true);}else{b._handleSpaceAndEnter(this,e);}}if(b._isKeyCombination(e,q.sap.KeyCodes.ENTER)){if(c.isOfType(C.COLUMNHEADER)){T.Menu.openContextMenu(this,e.target,true);}}};
b.prototype.onsaptabnext=function(e){var k=this._getKeyboardExtension();var c=T.getCellInfo(e.target);var $;if(k.isInActionMode()){var i;$=T.getCell(this,e.target);c=T.getCellInfo($);if($===null){return;}var r=this.getRows()[c.rowIndex];var L=b._getLastInteractiveElement(r);var d=L===null||L[0]===e.target;if(d){var A=r.getIndex();var f=T.isLastScrollableRow(this,$);var g=this._getRowCount()-1===A;var t=T.isRowSelectorSelectionAllowed(this);var s=false;if(!g&&f){s=this._getScrollExtension().scroll(true,null,true);}if(g){e.preventDefault();k.setActionMode(false);}else if(s){e.preventDefault();this.attachEventOnce("_rowsUpdated",function(){setTimeout(function(){var j=T.Grouping.isGroupingRow(r.getDomRef());if(t||j){b._focusCell(this,C.ROWHEADER,c.rowIndex);}else{i=b._getFirstInteractiveElement(r);b._focusElement(this,i[0],true);}}.bind(this),0);}.bind(this));}else{e.preventDefault();var n=c.rowIndex+1;var o=this.getRows()[n];var h=T.Grouping.isGroupingRow(o.getDomRef());if(t||h){b._focusCell(this,C.ROWHEADER,n);}else{i=b._getFirstInteractiveElement(o);b._focusElement(this,i[0],true);}}}else if(c.isOfType(C.ROWHEADER)){e.preventDefault();i=b._getFirstInteractiveElement(r);b._focusElement(this,i[0],true);}else{e.preventDefault();i=b._getNextInteractiveElement(this,e.target);b._focusElement(this,i[0],true);}}else if(c.isOfType(C.ANYCOLUMNHEADER)){if(T.isNoDataVisible(this)){this.$("noDataCnt").focus();}else{b._restoreFocusOnLastFocusedDataCell(this,e);}e.preventDefault();}else if(c.isOfType(C.DATACELL|C.ROWHEADER)){b._forwardFocusToTabDummy(this,"sapUiTableCtrlAfter");}else if(e.target===this.getDomRef("overlay")){k._setSilentFocus(this.$().find(".sapUiTableOuterAfter"));}else if(c.cell===null){$=T.getParentCell(this,e.target);if($!==null){e.preventDefault();$.focus();}}};
b.prototype.onsaptabprevious=function(e){var k=this._getKeyboardExtension();var c=T.getCellInfo(e.target);var $;if(k.isInActionMode()){var i;$=T.getCell(this,e.target);c=T.getCellInfo($);if($===null){return;}var r=this.getRows()[c.rowIndex];var A=r.getIndex();var f=b._getFirstInteractiveElement(r);var d=f!==null&&f[0]===e.target;var t=T.isRowSelectorSelectionAllowed(this);var R=T.Grouping.isGroupingRow(r);var g=t||R;if(d&&g){e.preventDefault();b._focusCell(this,C.ROWHEADER,c.rowIndex);}else if((d&&!g)||c.isOfType(C.ROWHEADER)){var h=T.isFirstScrollableRow(this,$);var j=A===0;var s=false;if(!j&&h){s=this._getScrollExtension().scroll(false,null,true);}if(j){e.preventDefault();k.setActionMode(false);}else if(s){e.preventDefault();this.attachEventOnce("_rowsUpdated",function(){setTimeout(function(){var n=T.Grouping.isGroupingRow(r.getDomRef());if(n){b._focusCell(this,C.ROWHEADER,c.rowIndex);}else{i=b._getLastInteractiveElement(r);b._focusElement(this,i[0],true);}}.bind(this),0);}.bind(this));}else{e.preventDefault();var P=c.rowIndex-1;var o=this.getRows()[P];var m=T.Grouping.isGroupingRow(o.getDomRef());if(m){b._focusCell(this,C.ROWHEADER,P);}else{i=b._getLastInteractiveElement(o);b._focusElement(this,i[0],true);}}}else{e.preventDefault();i=b._getPreviousInteractiveElement(this,e.target);b._focusElement(this,i[0],true);}}else if(c.isOfType(C.DATACELL|C.ROWHEADER)||e.target===this.getDomRef("noDataCnt")){if(this.getColumnHeaderVisible()){b._setFocusOnColumnHeaderOfLastFocusedDataCell(this,e);e.preventDefault();}else{b._forwardFocusToTabDummy(this,"sapUiTableCtrlBefore");}}else if(e.target===this.getDomRef("overlay")){this._getKeyboardExtension()._setSilentFocus(this.$().find(".sapUiTableOuterBefore"));}else if(c.cell===null){$=T.getParentCell(this,e.target);if($!==null){e.preventDefault();$.focus();}}};
b.prototype.onsapdown=function(e){b._navigate(this,e,N.DOWN);};
b.prototype.onsapdownmodifiers=function(e){if(b._isKeyCombination(e,null,M.CTRL)){b._navigate(this,e,N.DOWN);return;}var k=this._getKeyboardExtension();if(b._isKeyCombination(e,null,M.ALT)&&b._isElementGroupToggler(this,e.target)){p(e);T.Grouping.toggleGroupHeaderByRef(this,e.target,true);return;}if(k.isInActionMode()){return;}var c=T.getCellInfo(e.target);if(b._isKeyCombination(e,null,M.SHIFT)){e.preventDefault();if(c.isOfType(C.ANYCONTENTCELL)){if(!this._oRangeSelection){p(e);return;}var f=T.getRowIndexOfFocusedCell(this);var d=this.getRows()[f].getIndex();if(d===this._getRowCount()-1){return;}if(T.isLastScrollableRow(this,e.target)){var s=this._getScrollExtension().scroll(true,false,true);if(s){p(e);}}if(this._oRangeSelection.startIndex<=d){d++;if(this._oRangeSelection.selected){T.toggleRowSelection(this,d,true);}else{T.toggleRowSelection(this,d,false);}}else{T.toggleRowSelection(this,d,false);}}else{p(e);}}if(b._isKeyCombination(e,null,M.ALT)){if(c.isOfType(C.DATACELL)){k.setActionMode(true);}p(e);}};
b.prototype.onsapup=function(e){b._navigate(this,e,N.UP);};
b.prototype.onsapupmodifiers=function(e){var k=this._getKeyboardExtension();if(b._isKeyCombination(e,null,M.CTRL)){b._navigate(this,e,N.UP);return;}if(b._isKeyCombination(e,null,M.ALT)&&b._isElementGroupToggler(this,e.target)){p(e);T.Grouping.toggleGroupHeaderByRef(this,e.target,false);return;}if(k.isInActionMode()){return;}var c=T.getCellInfo(e.target);if(b._isKeyCombination(e,null,M.SHIFT)){e.preventDefault();if(c.isOfType(C.ANYCONTENTCELL)){if(!this._oRangeSelection){p(e);return;}var f=T.getRowIndexOfFocusedCell(this);var d=this.getRows()[f].getIndex();if(d===0){p(e);return;}if(T.isFirstScrollableRow(this,e.target)){var s=this._getScrollExtension().scroll(false,false,true);if(s){p(e);}}if(this._oRangeSelection.startIndex>=d){d--;if(this._oRangeSelection.selected){T.toggleRowSelection(this,d,true);}else{T.toggleRowSelection(this,d,false);}}else{T.toggleRowSelection(this,d,false);}}else{p(e);}}if(b._isKeyCombination(e,null,M.ALT)){if(c.isOfType(C.DATACELL)){k.setActionMode(true);}p(e);}};
b.prototype.onsapleft=function(e){b._navigate(this,e,N.LEFT);};
b.prototype.onsapleftmodifiers=function(e){if(this._getKeyboardExtension().isInActionMode()){return;}var c=T.getCellInfo(e.target);var d=sap.ui.getCore().getConfiguration().getRTL();if(b._isKeyCombination(e,null,M.SHIFT)){e.preventDefault();if(c.isOfType(C.DATACELL)){if(!this._oRangeSelection){p(e);return;}var f=T.getFocusedItemInfo(this);var F=T.hasRowHeader(this)&&f.cellInRow===1;if(F&&!T.isRowSelectorSelectionAllowed(this)){p(e);}}else if(c.isOfType(C.ROWACTION)){if(!this._oRangeSelection){p(e);}}else if(c.isOfType(C.ROWHEADER)&&d){if(!T.isRowSelectionAllowed(this)){p(e);}}else if(c.isOfType(C.COLUMNROWHEADER)&&d){p(e);}else if(c.isOfType(C.COLUMNHEADER)){var r=-this._CSSSizeToPixel(a);var g=0;if(d){r=r*-1;}for(var i=c.columnIndex;i<c.columnIndex+c.columnSpan;i++){g+=T.Column.getColumnWidth(this,i);}T.Column.resizeColumn(this,c.columnIndex,g+r,true,c.columnSpan);p(e);}}else if(b._isKeyCombination(e,null,M.CTRL)){if(c.isOfType(C.COLUMNHEADER)){e.preventDefault();e.stopImmediatePropagation();var o=this.getColumns()[c.columnIndex];b._moveColumn(o,d);}}};
b.prototype.onsaprightmodifiers=function(e){if(this._getKeyboardExtension().isInActionMode()){return;}var c=T.getCellInfo(e.target);var d=sap.ui.getCore().getConfiguration().getRTL();if(b._isKeyCombination(e,null,M.SHIFT)){e.preventDefault();if(c.isOfType(C.DATACELL)){if(!this._oRangeSelection){p(e);}}else if(c.isOfType(C.ROWHEADER)){if(!T.isRowSelectionAllowed(this)){p(e);}}else if(c.isOfType(C.ROWACTION)&&d){if(!this._oRangeSelection){p(e);}}else if(c.isOfType(C.COLUMNHEADER)){var r=this._CSSSizeToPixel(a);var f=0;if(d){r=r*-1;}for(var i=c.columnIndex;i<c.columnIndex+c.columnSpan;i++){f+=T.Column.getColumnWidth(this,i);}T.Column.resizeColumn(this,c.columnIndex,f+r,true,c.columnSpan);p(e);}else if(c.isOfType(C.COLUMNROWHEADER)){p(e);}}else if(b._isKeyCombination(e,null,M.CTRL)){if(c.isOfType(C.COLUMNHEADER)){e.preventDefault();e.stopImmediatePropagation();var o=this.getColumns()[c.columnIndex];b._moveColumn(o,!d);}}};
b.prototype.onsaphome=function(e){if(this._getKeyboardExtension().isInActionMode()){return;}e.preventDefault();if(T.Grouping.isInGroupingRow(e.target)){p(e);return;}var c=T.getCellInfo(e.target);if(c.isOfType(C.DATACELL|C.ROWACTION|C.COLUMNHEADER)){var f=T.getFocusedItemInfo(this);var F=f.cell;var i=f.cellInRow;var d=this.getFixedColumnCount();var h=T.hasRowHeader(this);var r=h?1:0;if(T.hasFixedColumns(this)&&i>d+r){p(e);T.focusItem(this,F-i+d+r,null);}else if(h&&i>1){p(e);T.focusItem(this,F-i+r,null);}}};
b.prototype.onsapend=function(e){if(this._getKeyboardExtension().isInActionMode()){return;}e.preventDefault();if(T.Grouping.isInGroupingRow(e.target)){p(e);return;}var c=T.getCellInfo(e.target);if(c.isOfType(C.ANY)){var f=T.getFocusedItemInfo(this);var F=f.cell;var i=f.columnCount;var d=this.getFixedColumnCount();var g=f.cellInRow;var h=T.hasRowHeader(this);var r=h?1:0;var j=false;if(c.isOfType(C.COLUMNHEADER)&&T.hasFixedColumns(this)){var k=parseInt(c.cell.attr("colspan")||1,10);if(k>1&&g+k-r===d){j=true;}}if(h&&g===0){p(e);T.focusItem(this,F+1,null);}else if(T.hasFixedColumns(this)&&g<d-1+r&&!j){p(e);T.focusItem(this,F+d-g,null);}else if(T.hasRowActions(this)&&c.isOfType(C.DATACELL)&&g<i-2){p(e);T.focusItem(this,F-g+i-2,null);}}};
b.prototype.onsaphomemodifiers=function(e){if(this._getKeyboardExtension().isInActionMode()){return;}if(b._isKeyCombination(e,null,M.CTRL)){e.preventDefault();var c=T.getCellInfo(e.target);if(c.isOfType(C.ANYCONTENTCELL|C.COLUMNHEADER)){p(e);var f=T.getFocusedItemInfo(this);var F=f.row;if(F>0){var i=f.cell;var d=f.columnCount;var h=T.getHeaderRowCount(this);var g=this.getFixedRowCount();var j=this.getFixedBottomRowCount();if(F<h+g){if(c.isOfType(C.ROWACTION)){T.focusItem(this,i-d*(F-h),e);}else{T.focusItem(this,i-d*F,e);}}else if(F>=h+g&&F<h+T.getNonEmptyVisibleRowCount(this)-j){this._getScrollExtension().scrollMax(false,true);if(g>0||c.isOfType(C.ROWACTION)){T.focusItem(this,i-d*(F-h),e);}else{T.focusItem(this,i-d*F,e);}}else{this._getScrollExtension().scrollMax(false,true);T.focusItem(this,i-d*(F-h-g),e);}}}}};
b.prototype.onsapendmodifiers=function(e){if(this._getKeyboardExtension().isInActionMode()){return;}if(b._isKeyCombination(e,null,M.CTRL)){e.preventDefault();var c=T.getCellInfo(e.target);if(c.isOfType(C.ANY)){var f=T.getFocusedItemInfo(this);var F=f.row;var h=T.getHeaderRowCount(this);var n=T.getNonEmptyVisibleRowCount(this);var i=this.getFixedRowCount();var d=this.getFixedBottomRowCount();p(e);if(d===0||F<h+n-1||(T.isNoDataVisible(this)&&F<h-1)){var g=f.cell;var j=f.columnCount;if(T.isNoDataVisible(this)){T.focusItem(this,g+j*(h-F-1),e);}else if(F<h){if(i>0){T.focusItem(this,g+j*(h+i-F-1),e);}else{this._getScrollExtension().scrollMax(true,true);T.focusItem(this,g+j*(h+n-d-F-1),e);}}else if(F>=h&&F<h+i){this._getScrollExtension().scrollMax(true,true);T.focusItem(this,g+j*(h+n-d-F-1),e);}else if(F>=h+i&&F<h+n-d){this._getScrollExtension().scrollMax(true,true);T.focusItem(this,g+j*(h+n-F-1),e);}else{T.focusItem(this,g+j*(h+n-F-1),e);}}}}};
b.prototype.onsappageup=function(e){if(this._getKeyboardExtension().isInActionMode()){return;}e.preventDefault();var c=T.getCellInfo(e.target);if(c.isOfType(C.ANYCONTENTCELL|C.COLUMNHEADER)){var f=T.getFocusedItemInfo(this);var F=f.row;var h=T.getHeaderRowCount(this);var i=this.getFixedRowCount();var d=this.getFixedBottomRowCount();if(i===0&&F>=h||i>0&&F>h){p(e);var g=f.cell;var j=f.columnCount;if(F<h+i){T.focusItem(this,g-j*(F-h),e);}else if(F===h+i){var P=T.getNonEmptyVisibleRowCount(this)-i-d;var r=this.getFirstVisibleRow();this._getScrollExtension().scroll(false,true,true);if(r<P){if(i>0||c.isOfType(C.ROWACTION)){T.focusItem(this,g-j*(F-h),e);}else{T.focusItem(this,g-j*h,e);}}}else if(F>h+i&&F<h+T.getNonEmptyVisibleRowCount(this)){T.focusItem(this,g-j*(F-h-i),e);}else{T.focusItem(this,g-j*(F-h-T.getNonEmptyVisibleRowCount(this)+1),e);}}if(c.isOfType(C.ROWACTION)&&F===h&&i>0){p(e);}}};
b.prototype.onsappagedown=function(e){if(this._getKeyboardExtension().isInActionMode()){return;}e.preventDefault();var c=T.getCellInfo(e.target);if(c.isOfType(C.ANY)){var f=T.getFocusedItemInfo(this);var F=f.row;var h=T.getHeaderRowCount(this);var n=T.getNonEmptyVisibleRowCount(this);var i=this.getFixedRowCount();var d=this.getFixedBottomRowCount();p(e);if((T.isNoDataVisible(this)&&F<h-1)||d===0||F<h+n-1){var g=f.cell;var j=f.columnCount;if(F<h-1&&!c.isOfType(C.COLUMNROWHEADER)){T.focusItem(this,g+j*(h-F-1),e);}else if(F<h){if(!T.isNoDataVisible(this)){T.focusItem(this,g+j*(h-F),e);}}else if(F>=h&&F<h+n-d-1){T.focusItem(this,g+j*(h+n-d-F-1),e);}else if(F===h+n-d-1){var P=T.getNonEmptyVisibleRowCount(this)-i-d;var r=this._getRowCount()-d-this.getFirstVisibleRow()-P*2;this._getScrollExtension().scroll(true,true,true);if(r<P&&d>0){T.focusItem(this,g+j*(h+n-F-1),e);}}else{T.focusItem(this,g+j*(h+n-F-1),e);}}}};
b.prototype.onsappageupmodifiers=function(e){if(this._getKeyboardExtension().isInActionMode()){return;}if(b._isKeyCombination(e,null,M.ALT)){var c=T.getCellInfo(e.target);var f=T.getFocusedItemInfo(this);if(c.isOfType(C.DATACELL|C.COLUMNHEADER)){var F=f.cell;var i=f.cellInRow;var h=T.hasRowHeader(this);var r=h?1:0;var P=H;p(e);if(h&&(T.Grouping.isInGroupingRow(e.target)||i===1)){T.focusItem(this,F-i,null);}else if(i-r<P){T.focusItem(this,F-i+r,null);}else{T.focusItem(this,F-P,null);}}else if(c.isOfType(C.ROWACTION)){T.focusItem(this,f.cell-1,null);}}};
b.prototype.onsappagedownmodifiers=function(e){if(this._getKeyboardExtension().isInActionMode()){return;}if(b._isKeyCombination(e,null,M.ALT)){var c=T.getCellInfo(e.target);if(c.isOfType(C.DATACELL|C.ROWHEADER|C.ANYCOLUMNHEADER)){var f=T.getFocusedItemInfo(this);var F=f.cellInRow;var h=T.hasRowHeader(this);var r=h?1:0;var v=T.getVisibleColumnCount(this);var i=parseInt(c.cell.attr("colspan")||1,10);p(e);if(F+i-r<v){var d=f.cell;var P=H;if(h&&F===0){T.focusItem(this,d+1,null);}else if(i>P){T.focusItem(this,d+i,null);}else if(F+i-r+P>v){T.focusItem(this,d+v-F-1+r,null);}else if(!T.Grouping.isInGroupingRow(e.target)){T.focusItem(this,d+P,null);}}else if(c.isOfType(C.DATACELL)&&T.hasRowActions(this)&&F===f.columnCount-2){T.focusItem(this,f.cell+1,null);}}}};
b.prototype.onsapenter=function(e){b._handleSpaceAndEnter(this,e);};
return b;});
sap.ui.predefine('sap/ui/table/TableKeyboardExtension',["jquery.sap.global","./TableExtension","sap/ui/core/delegate/ItemNavigation","./TableUtils","./TableKeyboardDelegate2","sap/ui/Device"],function(q,T,I,a,b,D){"use strict";var c=false;
function d(o){if(D.browser.msie){if(!c){q("head").append("<style type=\"text/css\">"+"/* Avoid focus outline problems in tables */\n"+".sapUiTableStatic[data-sap-ui-table-focus]{}"+"</style>");c=true;}var C=a.getCellInfo(o)||{};if(C.cell){C.cell.attr("data-sap-ui-table-focus",Date.now());}}}
var e={_forward:function(t,o){var i=t._getItemNavigation();if(i!=null&&!t._getKeyboardExtension()._isItemNavigationSuspended()&&!o.isMarked("sapUiTableSkipItemNavigation")&&!a.isBusyIndicatorVisible(t)){i["on"+o.type](o);}},onfocusin:function(o){e._forward(this,o);d(o.target);},onsapfocusleave:function(o){e._forward(this,o);},onmousedown:function(o){e._forward(this,o);},onsapnext:function(o){e._forward(this,o);},onsapnextmodifiers:function(o){e._forward(this,o);},onsapprevious:function(o){e._forward(this,o);},onsappreviousmodifiers:function(o){e._forward(this,o);},onsappageup:function(o){e._forward(this,o);},onsappagedown:function(o){e._forward(this,o);},onsaphome:function(o){e._forward(this,o);},onsaphomemodifiers:function(o){e._forward(this,o);},onsapend:function(o){e._forward(this,o);},onsapendmodifiers:function(o){e._forward(this,o);},onsapkeyup:function(o){e._forward(this,o);}};var E={onfocusin:function(o){var h=this._getKeyboardExtension();if(!h._bIgnoreFocusIn){h.initItemNavigation();if(f.isItemNavigationInvalid(this)){o.setMarked("sapUiTableInitItemNavigation");}}else{o.setMarked("sapUiTableIgnoreFocusIn");}if(o.target&&o.target.id===this.getId()+"-rsz"){o.preventDefault();o.setMarked("sapUiTableSkipItemNavigation");}}};var f={_initItemNavigation:function(o){var t=o.getTable();if(a.isBusyIndicatorVisible(t)){return;}var $=t.$();var C=a.getVisibleColumnCount(t);var h=C;var H=a.hasRowHeader(t);var j=a.hasRowActions(t);var k=a.hasFixedColumns(t);var l=[],r,R,m,n,p;if(k){m=$.find(".sapUiTableCtrlFixed.sapUiTableCtrlRowFixed:not(.sapUiTableCHT)");n=$.find(".sapUiTableCtrlFixed.sapUiTableCtrlRowScroll:not(.sapUiTableCHT)");p=$.find(".sapUiTableCtrlFixed.sapUiTableCtrlRowFixedBottom:not(.sapUiTableCHT)");}var s=$.find(".sapUiTableCtrlScroll.sapUiTableCtrlRowFixed:not(.sapUiTableCHT)");var u=$.find(".sapUiTableCtrlScroll.sapUiTableCtrlRowScroll:not(.sapUiTableCHT)");var v=$.find(".sapUiTableCtrlScroll.sapUiTableCtrlRowFixedBottom:not(.sapUiTableCHT)");if(H){r=$.find(".sapUiTableRowHdr").get();h++;}if(j){R=$.find(".sapUiTableRowAction").get();h++;}for(var i=0;i<t.getVisibleRowCount();i++){if(H){l.push(r[i]);}if(k){l=l.concat(m.find("tr[data-sap-ui-rowindex=\""+i+"\"]").find("td[tabindex]").get());}l=l.concat(s.find("tr[data-sap-ui-rowindex=\""+i+"\"]").find("td[tabindex]").get());if(k){l=l.concat(n.find("tr[data-sap-ui-rowindex=\""+i+"\"]").find("td[tabindex]").get());}l=l.concat(u.find("tr[data-sap-ui-rowindex=\""+i+"\"]").find("td[tabindex]").get());if(k){l=l.concat(p.find("tr[data-sap-ui-rowindex=\""+i+"\"]").find("td[tabindex]").get());}l=l.concat(v.find("tr[data-sap-ui-rowindex=\""+i+"\"]").find("td[tabindex]").get());if(j){l.push(R[i]);}}if(t.getColumnHeaderVisible()){var w=[];var F=$.find(".sapUiTableCHT.sapUiTableCtrlFixed>tbody>tr");var S=$.find(".sapUiTableCHT.sapUiTableCtrlScroll>tbody>tr");for(var i=0;i<a.getHeaderRowCount(t);i++){if(H){w.push(t.getDomRef("selall"));}if(F.length){w=w.concat(q(F.get(i)).find(".sapUiTableCol").get());}if(S.length){w=w.concat(q(S.get(i)).find(".sapUiTableCol").get());}if(j){w.push($.find(".sapUiTableRowActionHeader").get(0));}}l=w.concat(l);}if(!o._itemNavigation){o._itemNavigation=new I();o._itemNavigation.setTableMode(true);o._itemNavigation.attachEvent(I.Events.AfterFocus,function(x){var y=a.getFocusedItemInfo(t);y.header=a.getHeaderRowCount(t);y.domRef=null;if(y.row>=y.header){o._oLastFocusedCellInfo=y;}},t);}o._itemNavigation.setColumns(h);o._itemNavigation.setRootDomRef($.find(".sapUiTableCnt").get(0));o._itemNavigation.setItemDomRefs(l);o._itemNavigation.setFocusedIndex(f.getInitialItemNavigationIndex(o));o._itemNavigationInvalidated=false;},getInitialItemNavigationIndex:function(o){return a.hasRowHeader(o.getTable())?1:0;},isItemNavigationInvalid:function(o){return!o._itemNavigation||o._itemNavigationInvalidated;}};
var g=T.extend("sap.ui.table.TableKeyboardExtension",{
_init:function(t,s,S){this._itemNavigation=null;this._itemNavigationInvalidated=false;this._itemNavigationSuspended=false;this._delegate=new b(s);this._actionMode=false;t.addEventDelegate(E,t);t.addEventDelegate(this._delegate,t);t.addEventDelegate(e,t);t._getItemNavigation=function(){return this._itemNavigation;}.bind(this);return"KeyboardExtension";},
_debug:function(){this._ExtensionHelper=f;this._ItemNavigationDelegate=e;this._ExtensionDelegate=E;},
destroy:function(){var t=this.getTable();if(t){t.removeEventDelegate(E);t.removeEventDelegate(this._delegate);t.removeEventDelegate(e);}if(this._itemNavigation){this._itemNavigation.destroy();this._itemNavigation=null;}if(this._delegate){this._delegate.destroy();this._delegate=null;}T.prototype.destroy.apply(this,arguments);}
});
g.prototype.initItemNavigation=function(){if(f.isItemNavigationInvalid(this)){f._initItemNavigation(this);}};
g.prototype.invalidateItemNavigation=function(){this._itemNavigationInvalidated=true;};
g.prototype.setActionMode=function(h){if(h===true&&!this._actionMode&&this._delegate.enterActionMode){this._actionMode=this._delegate.enterActionMode.apply(this.getTable(),Array.prototype.slice.call(arguments,1))===true;}else if(h===false&&this._actionMode&&this._delegate.leaveActionMode){this._actionMode=false;this._delegate.leaveActionMode.apply(this.getTable(),Array.prototype.slice.call(arguments,1));}};
g.prototype.isInActionMode=function(){return this._actionMode;};
g.prototype.updateNoDataAndOverlayFocus=function(p){var t=this.getTable();if(!t||!t.getDomRef()){return;}if(t.getShowOverlay()){if(q.sap.containsOrEquals(t.getDomRef(),p)){t.$("overlay").focus();}}else if(a.isNoDataVisible(t)){if(q.sap.containsOrEquals(t.getDomRef("sapUiTableCnt"),p)){t.$("noDataCnt").focus();}}else if(q.sap.containsOrEquals(t.getDomRef("noDataCnt"),p)||q.sap.containsOrEquals(t.getDomRef("overlay"),p)){a.focusItem(t,f.getInitialItemNavigationIndex(this));}};
g.prototype._suspendItemNavigation=function(){this._itemNavigationSuspended=true;};
g.prototype._resumeItemNavigation=function(){this._itemNavigationSuspended=false;};
g.prototype._isItemNavigationSuspended=function(){return this._itemNavigationSuspended;};
g.prototype._getLastFocusedCellInfo=function(){var h=a.getHeaderRowCount(this.getTable());if(!this._oLastFocusedCellInfo||this._oLastFocusedCellInfo.header!=h){var i=a.getFocusedItemInfo(this.getTable());var j=f.getInitialItemNavigationIndex(this);return{cellInRow:j,row:h,header:h,cellCount:i.cellCount,columnCount:i.columnCount,cell:i.columnCount*h+j};}return this._oLastFocusedCellInfo;};
g.prototype._setSilentFocus=function(o){this._bIgnoreFocusIn=true;this._setFocus(o);this._bIgnoreFocusIn=false;};
g.prototype._setFocus=function(o){if(!o){return;}var t=this.getTable();var C=a.getCellInfo(o);if(C.cell&&t){var $=q(o);if($.attr("tabindex")!="0"){var h=t._getItemNavigation();if(h&&h.aItemDomRefs){for(var i=0;i<h.aItemDomRefs.length;i++){if(h.aItemDomRefs[i]){h.aItemDomRefs[i].setAttribute("tabindex","-1");}}}$.attr("tabindex","0");}}o.focus();};
g.prototype._getTableType=function(){return this._type;};
return g;},true);
sap.ui.predefine('sap/ui/table/TableMenuUtils',['jquery.sap.global','sap/ui/Device','sap/ui/unified/Menu','sap/ui/unified/MenuItem','sap/ui/core/Popup'],function(q,D,M,a,P){"use strict";P.setInitialZIndex(10);var b={TableUtils:null,openContextMenu:function(t,e,h,f){if(t==null||e==null){return;}if(f==null){f=true;}var T=q(e);var $=b.TableUtils.getCell(t,T);if($===null){return;}var c=b.TableUtils.getCellInfo($);var C=c.columnIndex;var r=c.rowIndex;var E;if(c.isOfType(b.TableUtils.CELLTYPE.COLUMNHEADER)){var d=$.find(".sapUiTableColDropDown").length>0;if(D.system.desktop||d){b.removeColumnHeaderCellMenu(t,C);E=true;if(f){E=t.fireColumnSelect({column:t.getColumns()[C]});}if(E){b.openColumnContextMenu(t,C,h,$);}}else{b.applyColumnHeaderCellMenu(t,C,$);}}else if(c.isOfType(b.TableUtils.CELLTYPE.DATACELL)){E=true;if(f){var R=b.TableUtils.getRowColCell(t,r,C,true);var o=R.row;var g;var i=t.getBindingInfo("rows");if(i!=null){g=o.getBindingContext(i.model);}var p={rowIndex:o.getIndex(),columnIndex:C,columnId:R.column.getId(),cellControl:R.cell,rowBindingContext:g,cellDomRef:$[0]};E=t.fireCellContextmenu(p);}if(E){b.openDataCellContextMenu(t,C,r,h);}}},openColumnContextMenu:function(t,c,h,C){if(t==null||c==null||c<0){return;}if(h==null){h=false;}var o=t.getColumns();if(c>=o.length){return;}var d=o[c];if(!d.getVisible()){return;}for(var i=0;i<o.length;i++){if(o[i]!==d){b.closeColumnContextMenu(t,i);}}b.closeDataCellContextMenu(t);var e=C&&C.attr("colspan");if(e&&e!=="1"){return;}d._openMenu(C&&C[0]||d.getDomRef(),h);},closeColumnContextMenu:function(t,c){if(t==null||c==null||c<0){return;}var C=t.getColumns();if(c>=C.length){return;}var o=C[c];var m=o.getMenu();m.close();},openDataCellContextMenu:function(t,c,r,h){if(t==null||c==null||c<0||r==null||r<0||r>=b.TableUtils.getNonEmptyVisibleRowCount(t)){return;}if(h==null){h=false;}var C=t.getColumns();if(c>=C.length){return;}var o=C[c];if(!o.getVisible()){return;}if(t.getEnableCellFilter()&&o.isFilterableByMenu()){var R=t.getRows()[r];if(t._oCellContextMenu==null){t._oCellContextMenu=new M(t.getId()+"-cellcontextmenu");var d=new a({text:t._oResBundle.getText("TBL_FILTER")});d._onSelect=function(o,r){var g=this.getContextByIndex(r);var F=o.getFilterProperty();var s=g.getProperty(F);if(this.getEnableCustomFilter()){this.fireCustomFilter({column:o,value:s});}else{this.filter(o,s);}};d.attachSelect(d._onSelect.bind(t,o,R.getIndex()));t._oCellContextMenu.addItem(d);t.addDependent(t._oCellContextMenu);}else{var m=t._oCellContextMenu.getItems()[0];m.mEventRegistry.select[0].fFunction=m._onSelect.bind(t,o,R.getIndex());}var e=R.getCells()[c];var $=b.TableUtils.getParentCell(t,e.getDomRef());if($!==null&&!b.TableUtils.Grouping.isInGroupingRow($)){e=$[0];var f=t._oCellContextMenu.bOpen&&t._oCellContextMenu.oOpenerRef!==e;if(f){b.closeDataCellContextMenu(t);}for(var i=0;i<C.length;i++){b.closeColumnContextMenu(t,i);}t._oCellContextMenu.open(h,e,P.Dock.BeginTop,P.Dock.BeginBottom,e,"none none");}}},closeDataCellContextMenu:function(t){if(t==null){return;}var m=t._oCellContextMenu;var c=m!=null&&m.bOpen;if(c){m.close();}},cleanupDataCellContextMenu:function(t){if(!t||!t._oCellContextMenu){return;}t._oCellContextMenu.destroy();t._oCellContextMenu=null;},applyColumnHeaderCellMenu:function(t,c,T){if(t==null||c==null||c<0){return;}var C=t.getColumns();if(c>=C.length){return;}var d=T&&T.attr("colspan");if(d&&d!=="1"){return;}var o=C[c];if(o.getVisible()&&(o.getResizable()||o._menuHasItems())){var $=T||o.$();var e=$.find(".sapUiTableColCell");var f=$.find(".sapUiTableColCellMenu").length>0;if(!f){e.hide();var s="";if(o._menuHasItems()){s="<div class='sapUiTableColDropDown'></div>";}var g="";if(o.getResizable()){g="<div class='sapUiTableColResizer''></div>";}var h=q("<div class='sapUiTableColCellMenu'>"+s+g+"</div>");$.append(h);$.on("focusout",function(t,c){b.removeColumnHeaderCellMenu(t);this.off("focusout");}.bind($,t,c));}}},removeColumnHeaderCellMenu:function(t){var c=t&&t.$().find(".sapUiTableCHT .sapUiTableColCellMenu");if(c.length){c.parent().find(".sapUiTableColCell").show();c.remove();}}};return b;},true);
sap.ui.predefine('sap/ui/table/TablePersoController',['jquery.sap.global','sap/ui/base/ManagedObject'],function(q,M){"use strict";
var T=M.extend("sap.ui.table.TablePersoController",{
constructor:function(i,s){M.apply(this,arguments);},
metadata:{properties:{"autoSave":{type:"boolean",defaultValue:true},"persoService":{type:"any"},"customDataKey":{type:"string",defaultValue:"persoKey"}},associations:{"table":{type:"sap.ui.table.Table",multiple:false}},library:"sap.ui.table"}
});
T.prototype.init=function(){this._schemaProperty="_persoSchemaVersion";this._schemaVersion="1.0";this._oInitialPersoData=null;this._aTableEvents=["columnResize","columnMove","columnVisibility","sort","filter","group"];this._aColumnProperties=["visible","width","sorted","sortOrder","grouped","summed"];this._bSaveFilters=false;if(this._bSaveFilters){this._aTableEvents.push("filter");this._aColumnProperties.push("filtered");this._aColumnProperties.push("filterValue");}};
T.prototype.exit=function(){var t=this._getTable();if(t){this._manageTableEventHandlers(t,false);}delete this._schemaProperty;delete this._schemaVersion;delete this._oInitialPersoData;delete this._oDialog;};
T.prototype.setPersoService=function(s){s=this.validateProperty("persoService",s);if(s&&(!q.isFunction(s.getPersData)||!q.isFunction(s.setPersData)||!q.isFunction(s.delPersData))){throw new Error("Value of property \"persoService\" needs to be null/undefined or an object that has the methods "+"\"getPersData\", \"setPersData\" and \"delPersData\".");}var o=this.getPersoService();this.setProperty("persoService",s,true);var n=this.getPersoService();if(n&&n!==o&&this._getTable()&&(this.getAutoSave()||!o)){this.refresh();}return this;};
T.prototype.setAutoSave=function(a){var o=this.getAutoSave();this.setProperty("autoSave",a,true);var n=this.getAutoSave();if(n&&!o){this.savePersonalizations();}return this;};
T.prototype.setTable=function(t){var o=this._getTable();if(o){o._oPersoController=undefined;}this.setAssociation("table",t,true);var n=this._getTable();if(n){n._oPersoController=this;}if(o){this._manageTableEventHandlers(o,false);}if(n&&n!==o){this._oInitialPersoData=this._getCurrentTablePersoData(true);this._manageTableEventHandlers(n,true);if(this.getPersoService()&&(this.getAutoSave()||!o)){this.refresh();}}else if(!n){this._oInitialPersoData=null;}return this;};
T.prototype.setCustomDataKey=function(c){var o=this.getCustomDataKey();this.setProperty("customDataKey",c,true);var n=this.getCustomDataKey();if(o!==n&&this.getAutoSave()){this.savePersonalizations();}return this;};
T.prototype._manageTableEventHandlers=function(t,a){for(var i=0,l=this._aTableEvents.length;i<l;i++){var f=t[(a?"attachEvent":"detachEvent")];f.apply(t,[this._aTableEvents[i],this._tableEventHandler,this]);}};
T.prototype.refresh=function(){var t=this;var s=this.getPersoService();if(s){return s.getPersData().done(function(S){var D=(S&&q.isArray(S.aColumns))?S:t._oInitialPersoData;t._adjustTable(D);}).fail(function(){q.sap.log.error("Problem reading persisted personalization data.");});}else{q.sap.log.error("The Personalization Service is not available!");var d=q.Deferred();d.reject();return d.promise();}};
T.prototype.savePersonalizations=function(){var s=this.getPersoService();if(s){var d=this._getCurrentTablePersoData();d[this._schemaProperty]=this._schemaVersion;return s.setPersData(d).fail(function(){q.sap.log.error("Problem persisting personalization data.");});}else{q.sap.log.error("The Personalization Service is not available!");var D=q.Deferred();D.reject();return D.promise();}};
T.prototype._adjustTable=function(d){var t=this._getTable();if(!t||!d||!q.isArray(d.aColumns)){return;}var c={},C=t.getColumns();for(var i=0,l=C.length;i<l;i++){c[this._getColumnPersoKey(C[i])]=C[i];}var a=d.aColumns;for(var i=0,l=a.length;i<l;i++){var o=a[i];var b=c[o.id];if(b){if(t.indexOfColumn(b)!==o.order){t.removeColumn(b);t.insertColumn(b,o.order);}var m=b.getMetadata();for(var j=0,e=this._aColumnProperties.length;j<e;j++){var p=this._aColumnProperties[j];if(o[p]!==undefined){try{if(m.hasProperty(p)&&b.getProperty(p)!=o[p]){b.setProperty(p,o[p]);}}catch(f){q.sap.log.error("sap.ui.table.TablePersoController: failed to apply the value \""+b[p]+"\" for the property + \""+p+"\".");}}}}}if(typeof t._onPersoApplied==="function"){t._onPersoApplied();}};
T.prototype._tableEventHandler=function(e){if(this.getAutoSave()&&!this._iTriggerSaveTimeout){var t=this;this._iTriggerSaveTimeout=setTimeout(function(){t.savePersonalizations();t._iTriggerSaveTimeout=null;},0);}};
T.prototype._getCurrentTablePersoData=function(f){var t=this._getTable(),c=t.getColumns();var d={aColumns:[]};for(var i=0,l=c.length;i<l;i++){var C=c[i];var p=this._getColumnPersoKey(C);var o={id:p,order:i};var m=C.getMetadata();for(var j=0,a=this._aColumnProperties.length;j<a;j++){var P=this._aColumnProperties[j];if(m.hasProperty(P)){o[P]=C.getProperty(P);}}if(f){o.text=C.getLabel()&&C.getLabel().getText()||p;}d.aColumns.push(o);}return d;};
T.prototype._getTable=function(){return sap.ui.getCore().byId(this.getTable());};
T.prototype._getColumnPersoKey=function(c){return this._getPersoKey(this._getTable())+"-"+this._getPersoKey(c);};
T.prototype._getPersoKey=function(c){var p=c.data(this.getCustomDataKey());if(!p){p=c.getId();if(p.indexOf(sap.ui.getCore().getConfiguration().getUIDPrefix())===0){q.sap.log.warning("Generated IDs should not be used as personalization keys! The stability cannot be ensured! (Control: \""+c.getId()+"\")");}}return p;};
T.prototype.openDialog=function(s){sap.ui.getCore().loadLibrary("sap.m");var a=sap.ui.requireSync("sap/m/TablePersoDialog");if(!this._oDialog){var t=this;this._oDialog=new a({persoService:this.getPersoService(),showSelectAll:true,showResetAll:true,grouping:false,contentWidth:s&&s.contentWidth,contentHeight:s&&s.contentHeight||"20rem",initialColumnState:this._oInitialPersoData.aColumns,columnInfoCallback:function(o,p,P){return t._getCurrentTablePersoData(true).aColumns;},confirm:function(){t._adjustTable(this.retrievePersonalizations());if(t.getAutoSave()){t.savePersonalizations();}}});this._oDialog._oDialog.removeStyleClass("sapUiPopupWithPadding");q.sap.syncStyleClass("sapUiSizeCompact",this._getTable(),this._oDialog._oDialog);}this._oDialog.open();};
return T;});
sap.ui.predefine('sap/ui/table/TablePointerExtension',["./library","jquery.sap.global","./TableExtension","./TableUtils","sap/ui/Device","sap/ui/core/Popup","jquery.sap.dom"],function(l,q,T,a,D,P,Q){"use strict";var S=l.SelectionMode;var K=["sapMBtnBase","sapMInputBase","sapMLnk","sapMSlt","sapMCb","sapMRI","sapMSegBBtn","sapUiIconPointer"];var E={_getEventPosition:function(e,t){var p;function g(o){if(!t._isTouchEvent(o)){return null;}var f=["touches","targetTouches","changedTouches"];for(var i=0;i<f.length;i++){var s=f[i];if(e[s]&&e[s][0]){return e[s][0];}if(e.originalEvent[s]&&e.originalEvent[s][0]){return e.originalEvent[s][0];}}return null;}p=g(e)||e;return{x:p.pageX,y:p.pageY};},_skipClick:function(e,t,o){if(!o.isOfType(a.CELLTYPE.DATACELL|a.CELLTYPE.ROWACTION)){return false;}if(e.isMarked()){return true;}var f=t.control(0);if(f){var $=f.$();if($.length){for(var i=0;i<K.length;i++){if($.hasClass(K[i])){return typeof f.getEnabled==="function"?f.getEnabled():true;}}}}var h=false;if(window.getSelection){var s=window.getSelection();h=s.rangeCount?!s.getRangeAt(0).collapsed:false;}if(h){q.sap.log.debug("DOM Selection detected -> Click event on table skipped, Target: "+e.target);return true;}return false;},_handleClickSelection:function(e,$,t){a.toggleRowSelection(t,$,null,function(r){if((D.browser.msie||D.browser.edge)&&e.shiftKey){t._clearTextSelection();}var s=t.getSelectionMode();if(s===S.Single){if(!t.isIndexSelected(r)){t.setSelectedIndex(r);}else{t.clearSelection();}}else{var f=!!(e.metaKey||e.ctrlKey);if(s===S.MultiToggle){f=true;}if(e.shiftKey){var i=t.getSelectedIndex();if(i>=0){t.addSelectionInterval(i,r);}else{t.setSelectedIndex(r);}}else{if(!t.isIndexSelected(r)){if(f){t.addSelectionInterval(r,r);}else{t.setSelectedIndex(r);}}else{if(f){t.removeSelectionInterval(r,r);}else{if(t._getSelectedIndicesCount()===1){t.clearSelection();}else{t.setSelectedIndex(r);}}}}}return true;});}};var C={initColumnResizing:function(t,e){if(t._bIsColumnResizerMoving){return;}t._bIsColumnResizerMoving=true;t.$().toggleClass("sapUiTableResizing",true);var $=q(document),f=t._isTouchEvent(e);t._$colResize=t.$("rsz");t._iColumnResizeStart=E._getEventPosition(e,t).x;$.bind((f?"touchend":"mouseup")+".sapUiTableColumnResize",C.exitColumnResizing.bind(t));$.bind((f?"touchmove":"mousemove")+".sapUiTableColumnResize",C.onMouseMoveWhileColumnResizing.bind(t));t._disableTextSelection();},exitColumnResizing:function(e){C._resizeColumn(this,this._iLastHoveredColumnIndex);},onMouseMoveWhileColumnResizing:function(e){var L=E._getEventPosition(e,this).x;if(this._iColumnResizeStart&&L<this._iColumnResizeStart+3&&L>this._iColumnResizeStart-3){return;}if(this._isTouchEvent(e)){e.stopPropagation();e.preventDefault();}this._$colResize.toggleClass("sapUiTableColRszActive",true);var o=this._getVisibleColumns()[this._iLastHoveredColumnIndex];var i=L-this._iColumnResizeStart;var f=this.$().find("th[data-sap-ui-colid=\""+o.getId()+"\"]").width();var w=Math.max(f+i*(this._bRtlMode?-1:1),a.Column.getMinColumnWidth());var r=this.$().find(".sapUiTableCnt").offset().left;var g=Math.floor((L-r)-(this._$colResize.width()/2));this._$colResize.css("left",g+"px");o._iNewWidth=w;},_cleanupColumResizing:function(t){if(t._$colResize){t._$colResize.toggleClass("sapUiTableColRszActive",false);t._$colResize=null;}t._iColumnResizeStart=null;t._bIsColumnResizerMoving=false;t.$().toggleClass("sapUiTableResizing",false);t._enableTextSelection();var $=q(document);$.unbind("touchmove.sapUiTableColumnResize");$.unbind("touchend.sapUiTableColumnResize");$.unbind("mousemove.sapUiTableColumnResize");$.unbind("mouseup.sapUiTableColumnResize");},_resizeColumn:function(t,i){var v=t._getVisibleColumns(),o,r=false;if(i>=0&&i<v.length){o=v[i];if(o._iNewWidth){a.Column.resizeColumn(t,t.indexOfColumn(o),o._iNewWidth);delete o._iNewWidth;r=true;}}C._cleanupColumResizing(t);o.focus();if(r){t.invalidate();}},doAutoResizeColumn:function(t,i){var v=t._getVisibleColumns(),o;if(i>=0&&i<v.length){o=v[i];if(!o.getAutoResizable()||!o.getResizable()){return;}var n=C._calculateAutomaticColumnWidth.apply(t,[o,i]);if(n){o._iNewWidth=n;C._resizeColumn(t,i);}}},_calculateAutomaticColumnWidth:function(o,i){o=o||this.getColumns()[i];var $=this.$();var e=q("<div>").addClass("sapUiTableHiddenSizeDetector");$.append(e);var f=$.find("td[data-sap-ui-colid = \""+o.getId()+"\"]:not([colspan])").filter(function(g,h){return h.style.display!="none";}).children().clone();f.find("[id]").removeAttr("id");var w=e.append(f).width()+4;w=Math.min(w,$.find(".sapUiTableCnt").width());w=Math.max(w+4,a.Column.getMinColumnWidth());e.remove();return w;},initColumnTracking:function(t){t.$().find(".sapUiTableCtrlScr, .sapUiTableCtrlScrFixed").mousemove(function(e){var o=this.getDomRef();if(!o||this._bIsColumnResizerMoving){return;}var p=e.clientX,f=o.getBoundingClientRect(),L=0,r=this._bRtlMode?10000:-10000;for(var i=0;i<this._aTableHeaders.length;i++){var g=this._aTableHeaders[i].getBoundingClientRect();if(this._bRtlMode){if((p<g.right-5)&&(p>=g.left)){L=i;r=g.left-f.left;break;}}else{if((p>g.left+5)&&(p<=g.right)){L=i;r=g.right-f.left;break;}}}var h=this._getVisibleColumns()[L];if(h&&h.getResizable()){this.$("rsz").css("left",r+"px");this._iLastHoveredColumnIndex=L;}}.bind(t));}};var I={initInteractiveResizing:function(t,e){var B=q(document.body),s=t.$("sb"),$=q(document),o=s.offset(),h=s.height(),w=s.width(),f=t._isTouchEvent(e);B.bind("selectstart",I.onSelectStartWhileInteractiveResizing);B.append("<div id=\""+t.getId()+"-ghost\" class=\"sapUiTableInteractiveResizerGhost\" style =\" height:"+h+"px; width:"+w+"px; left:"+o.left+"px; top:"+o.top+"px\" ></div>");s.append("<div id=\""+t.getId()+"-rzoverlay\" style =\"left: 0px; right: 0px; bottom: 0px; top: 0px; position:absolute\" ></div>");$.bind((f?"touchend":"mouseup")+".sapUiTableInteractiveResize",I.exitInteractiveResizing.bind(t));$.bind((f?"touchmove":"mousemove")+".sapUiTableInteractiveResize",I.onMouseMoveWhileInteractiveResizing.bind(t));t._disableTextSelection();},exitInteractiveResizing:function(e){var B=q(document.body),$=q(document),t=this.$(),g=this.$("ghost"),L=E._getEventPosition(e,this).y;var n=L-t.find(".sapUiTableCCnt").offset().top-g.height()-t.find(".sapUiTableFtr").height();this._setRowContentHeight(n);this._updateRows(this._calculateRowsToDisplay(n),a.RowsUpdateReason.Resize);g.remove();this.$("rzoverlay").remove();B.unbind("selectstart",I.onSelectStartWhileInteractiveResizing);$.unbind("touchend.sapUiTableInteractiveResize");$.unbind("touchmove.sapUiTableInteractiveResize");$.unbind("mouseup.sapUiTableInteractiveResize");$.unbind("mousemove.sapUiTableInteractiveResize");this._enableTextSelection();},onSelectStartWhileInteractiveResizing:function(e){e.preventDefault();e.stopPropagation();return false;},onMouseMoveWhileInteractiveResizing:function(e){var L=E._getEventPosition(e,this).y;var m=this.$().offset().top;if(L>m){this.$("ghost").css("top",L+"px");}}};var R={initReordering:function(t,i,e){var o=t.getColumns()[i],$=o.$(),f=t.$();t._disableTextSelection();f.addClass("sapUiTableDragDrop");var g=$.clone();g.find("*").addBack(g).removeAttr("id").removeAttr("data-sap-ui").removeAttr("tabindex");g.attr("id",t.getId()+"-roghost").addClass("sapUiTableColReorderGhost").css({"left":-10000,"top":-10000,"z-index":P.getNextZIndex()});g.toggleClass(a.getContentDensity(t),true);g.appendTo(document.body);t._$ReorderGhost=t.getDomRef("roghost");f.find("td[data-sap-ui-colid='"+o.getId()+"']").toggleClass("sapUiTableColReorderFade",true);var h=q("<div id='"+t.getId()+"-roind' class='sapUiTableColReorderIndicator'><div class='sapUiTableColReorderIndicatorArrow'></div><div class='sapUiTableColReorderIndicatorInner'></div></div>");h.appendTo(t.getDomRef("sapUiTableCnt"));t._$ReorderIndicator=t.getDomRef("roind");t._iDnDColIndex=i;var j=q(document),k=t._isTouchEvent(e);j.bind((k?"touchend":"mouseup")+".sapUiColumnMove",R.exitReordering.bind(t));j.bind((k?"touchmove":"mousemove")+".sapUiColumnMove",R.onMouseMoveWhileReordering.bind(t));},onMouseMoveWhileReordering:function(e){var o=E._getEventPosition(e,this),L=o.x,i=o.y,O=this._iNewColPos;this._iNewColPos=this._iDnDColIndex;e.preventDefault();var p=R.findColumnForPosition(this,L);if(!p||!p.id){this._iNewColPos=O;return;}var s=40,f=this.getDomRef("sapUiTableCtrlScr"),$=q(f),g=f.getBoundingClientRect(),h=$.outerWidth(),j=this._bRtlMode?$.scrollLeftRTL():$.scrollLeft();this._bReorderScroll=false;if(L>g.left+h-s&&j+h<f.scrollWidth){this._bReorderScroll=true;R.doScroll(this,!this._bRtlMode);R.adaptReorderMarkerPosition(this,p,false);}else if(L<g.left+s&&j>0){this._bReorderScroll=true;R.doScroll(this,this._bRtlMode);R.adaptReorderMarkerPosition(this,p,false);}q(this._$ReorderGhost).css({"left":L+5,"top":i+5});if(this._bReorderScroll||!p){return;}if(p.before||(p.after&&p.index==this._iDnDColIndex)){this._iNewColPos=p.index;}else if(p.after&&p.index!=this._iDnDColIndex){this._iNewColPos=p.index+1;}if(!a.Column.isColumnMovableTo(this.getColumns()[this._iDnDColIndex],this._iNewColPos)){this._iNewColPos=O;}else{R.adaptReorderMarkerPosition(this,p,true);}},exitReordering:function(e){var o=this._iDnDColIndex;var n=this._iNewColPos;var $=q(document);$.unbind("touchmove.sapUiColumnMove");$.unbind("touchend.sapUiColumnMove");$.unbind("mousemove.sapUiColumnMove");$.unbind("mouseup.sapUiColumnMove");this._bReorderScroll=false;this.$().removeClass("sapUiTableDragDrop");delete this._iDnDColIndex;delete this._iNewColPos;q(this._$ReorderGhost).remove();delete this._$ReorderGhost;q(this._$ReorderIndicator).remove();delete this._$ReorderIndicator;this.$().find(".sapUiTableColReorderFade").removeClass("sapUiTableColReorderFade");this._enableTextSelection();a.Column.moveColumnTo(this.getColumns()[o],n);if(this._mTimeouts.reApplyFocusTimerId){window.clearTimeout(this._mTimeouts.reApplyFocusTimerId);}var t=this;this._mTimeouts.reApplyFocusTimerId=window.setTimeout(function(){var O=a.getFocusedItemInfo(t).cell;a.focusItem(t,0,e);a.focusItem(t,O,e);},0);if(this.updateAnalyticalInfo){this.updateAnalyticalInfo(true,true);}},findColumnForPosition:function(t,L){var h,H,r,w,p,B,A;for(var i=0;i<t._aTableHeaders.length;i++){h=t._aTableHeaders[i];H=q(h);r=h.getBoundingClientRect();w=H.outerWidth();p={left:r.left,center:r.left+w/2,right:r.left+w,width:w,index:parseInt(H.attr("data-sap-ui-headcolindex"),10),id:H.attr("data-sap-ui-colid")};B=L>=p.left&&L<=p.center;A=L>=p.center&&L<=p.right;if(B||A){p.before=t._bRtlMode?A:B;p.after=t._bRtlMode?B:A;return p;}}return null;},doScroll:function(t,f){if(t._mTimeouts.horizontalReorderScrollTimerId){window.clearTimeout(t._mTimeouts.horizontalReorderScrollTimerId);t._mTimeouts.horizontalReorderScrollTimerId=null;}if(t._bReorderScroll){var s=f?30:-30;if(t._bRtlMode){s=(-1)*s;}t._mTimeouts.horizontalReorderScrollTimerId=q.sap.delayedCall(60,t,R.doScroll,[t,f]);var $=t.$("sapUiTableCtrlScr");var e=t._bRtlMode?"scrollLeftRTL":"scrollLeft";$[e]($[e]()+s);}},adaptReorderMarkerPosition:function(t,p,s){if(!p||!t._$ReorderIndicator){return;}var L=p.left-t.getDomRef().getBoundingClientRect().left;if(t._bRtlMode&&p.before||!t._bRtlMode&&p.after){L=L+p.width;}q(t._$ReorderIndicator).css({"left":L+"px"}).toggleClass("sapUiTableColReorderIndicatorActive",s);}};var b={ROWAREAS:[".sapUiTableRowHdr",".sapUiTableRowAction",".sapUiTableCtrlFixed > tbody > .sapUiTableTr",".sapUiTableCtrlScroll > tbody > .sapUiTableTr"],initRowHovering:function(t){var $=t.$();for(var i=0;i<b.ROWAREAS.length;i++){b._initRowHoveringForArea($,b.ROWAREAS[i]);}},_initRowHoveringForArea:function(t,A){t.find(A).hover(function(){b._onHover(this,t,A);},function(){b._onUnhover(this,t);});},_onHover:function(e,t,A){var f=t.find(A).index(e);for(var i=0;i<b.ROWAREAS.length;i++){t.find(b.ROWAREAS[i]).filter(":eq("+(f)+")").addClass("sapUiTableRowHvr");}},_onUnhover:function(e,t){for(var i=0;i<b.ROWAREAS.length;i++){t.find(b.ROWAREAS[i]).removeClass("sapUiTableRowHvr");}}};var c={onmousedown:function(e){var p=this._getPointerExtension();var $=a.getCell(this,e.target);var o=a.getCellInfo($);var t=q(e.target);var f;var m;var M;this._getKeyboardExtension().initItemNavigation();if(e.button===0){if(e.target===this.getDomRef("sb")){I.initInteractiveResizing(this,e);}else if(e.target===this.getDomRef("rsz")){C.initColumnResizing(this,e);}else if(t.hasClass("sapUiTableColResizer")){var i=t.closest(".sapUiTableCol").attr("data-sap-ui-colindex");this._iLastHoveredColumnIndex=parseInt(i,10);C.initColumnResizing(this,e);}else if(o.isOfType(a.CELLTYPE.COLUMNHEADER)){f=this.getColumns()[o.columnIndex];m=f.getAggregation("menu");M=m&&m.bOpen;if(!M){p._bShowMenu=true;this._mTimeouts.delayedMenuTimerId=q.sap.delayedCall(200,this,function(){delete p._bShowMenu;});}if(this.getEnableColumnReordering()&&!(this._isTouchEvent(e)&&t.hasClass("sapUiTableColDropDown"))){this._getPointerExtension().doReorderColumn(o.columnIndex,e);}}if((D.browser.firefox&&!!(e.metaKey||e.ctrlKey))||t.closest(".sapUiTableHSb",this.getDomRef()).length===1||t.closest(".sapUiTableVSb",this.getDomRef()).length===1){e.preventDefault();}}if(e.button===2){if(E._skipClick(e,t,o)){p._bShowDefaultMenu=true;return;}if(o.isOfType(a.CELLTYPE.COLUMNHEADER)){f=this.getColumns()[o.columnIndex];m=f.getAggregation("menu");M=m&&m.bOpen;if(!M){p._bShowMenu=true;}else{p._bHideMenu=true;}}else if(o.isOfType(a.CELLTYPE.DATACELL)){M=this._oCellContextMenu&&this._oCellContextMenu.bOpen;var g=M&&this._oCellContextMenu.oOpenerRef!==$[0];if(!M||g){p._bShowMenu=true;}else{p._bHideMenu=true;}}else{p._bShowDefaultMenu=true;}}},onmouseup:function(e){q.sap.clearDelayedCall(this._mTimeouts.delayedColumnReorderTimerId);},ondblclick:function(e){if(D.system.desktop&&e.target===this.getDomRef("rsz")){e.preventDefault();C.doAutoResizeColumn(this,this._iLastHoveredColumnIndex);}},onclick:function(e){q.sap.clearDelayedCall(this._mTimeouts.delayedColumnReorderTimerId);if(e.isMarked()){return;}var t=q(e.target);if(t.hasClass("sapUiAnalyticalTableSum")){e.preventDefault();return;}else if(t.hasClass("sapUiTableGroupMenuButton")){this._onContextMenu(e);e.preventDefault();return;}else if(t.hasClass("sapUiTableGroupIcon")||t.hasClass("sapUiTableTreeIcon")){if(a.Grouping.toggleGroupHeaderByRef(this,e.target)){return;}}var $=a.getCell(this,e.target);var o=a.getCellInfo($);if(o.isOfType(a.CELLTYPE.COLUMNHEADER)){var p=this._getPointerExtension();if(p._bShowMenu){a.Menu.openContextMenu(this,e.target,false);delete p._bShowMenu;}}else{if(E._skipClick(e,t,o)){return;}if(!this._findAndfireCellEvent(this.fireCellClick,e)){if(o.isOfType(a.CELLTYPE.COLUMNROWHEADER)){this._toggleSelectAll();}else{E._handleClickSelection(e,$,this);}}else{e.preventDefault();}}},oncontextmenu:function(e){var p=this._getPointerExtension();if(p._bShowDefaultMenu){e.setMarked("handledByPointerExtension");delete p._bShowDefaultMenu;}else if(p._bShowMenu){e.setMarked("handledByPointerExtension");e.preventDefault();a.Menu.openContextMenu(this,e.target,false);delete p._bShowMenu;}else if(p._bHideMenu){e.setMarked("handledByPointerExtension");e.preventDefault();delete p._bHideMenu;}}};
var d=T.extend("sap.ui.table.TablePointerExtension",{
_init:function(t,s,m){this._delegate=c;t.addEventDelegate(this._delegate,t);t._iLastHoveredColumnIndex=0;t._bIsColumnResizerMoving=false;t._iFirstReorderableIndex=s==T.TABLETYPES.TREE?1:0;return"PointerExtension";},
_attachEvents:function(){var t=this.getTable();if(t){C.initColumnTracking(t);b.initRowHovering(t);}},
_detachEvents:function(){var t=this.getTable();if(t){var $=t.$();$.find(".sapUiTableCtrlScr, .sapUiTableCtrlScrFixed").unbind();$.find(".sapUiTableCtrl > tbody > tr").unbind();$.find(".sapUiTableRowHdr").unbind();}},
_debug:function(){this._ExtensionHelper=E;this._ColumnResizeHelper=C;this._InteractiveResizeHelper=I;this._ReorderHelper=R;this._ExtensionDelegate=c;this._RowHoverHandler=b;this._KNOWNCLICKABLECONTROLS=K;},
doAutoResizeColumn:function(i){var t=this.getTable();if(t){C.doAutoResizeColumn(t,i);}},
doReorderColumn:function(i,e){var t=this.getTable();if(t&&a.Column.isColumnMovable(t.getColumns()[i])){t._mTimeouts.delayedColumnReorderTimerId=q.sap.delayedCall(200,t,function(){R.initReordering(this,i,e);});}},
destroy:function(){var t=this.getTable();if(t){t.removeEventDelegate(this._delegate);}this._delegate=null;T.prototype.destroy.apply(this,arguments);}
});
return d;},true);
sap.ui.predefine('sap/ui/table/TableRenderer',['jquery.sap.global','sap/ui/core/Control','sap/ui/core/theming/Parameters','sap/ui/Device','./library','./TableUtils','sap/ui/core/Renderer','sap/ui/core/IconPool'],function(q,C,P,D,a,T,R,I){"use strict";var S=a.SelectionMode,V=a.VisibleRowCountMode;var b={};
b.render=function(r,t){delete t._iHeaderRowCount;r.write("<div");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"ROOT");r.writeControlData(t);r.addClass("sapUiTable");if('ontouchstart'in document){r.addClass("sapUiTableTouch");}r.addClass("sapUiTableSelMode"+t.getSelectionMode());if(t.getColumnHeaderVisible()){r.addClass("sapUiTableCHdr");}if(T.hasRowHeader(t)){r.addClass("sapUiTableRowSelectors");}if(T.hasRowHighlights(t)){r.addClass("sapUiTableRowHighlights");}var s=a.TableHelper.addTableClass();if(s){r.addClass(s);}if(t._isVSbRequired()){r.addClass("sapUiTableVScr");}if(t.getEditable()){r.addClass("sapUiTableEdt");}if(T.hasRowActions(t)){var i=T.getRowActionCount(t);r.addClass(i==1?"sapUiTableRActS":"sapUiTableRAct");}if(T.isNoDataVisible(t)&&!T.hasPendingRequests(t)){r.addClass("sapUiTableEmpty");}if(t.getShowOverlay()){r.addClass("sapUiTableOverlay");}var m=T.Grouping.getModeCssClass(t);if(m){r.addClass(m);}if(t.getWidth()){r.addStyle("width",t.getWidth());}if(t.getVisibleRowCountMode()==V.Auto){r.addStyle("height","0px");if(t._bFirstRendering){r.addClass("sapUiTableNoOpacity");}}r.writeClasses();r.writeStyles();r.write(">");this.renderTabElement(r,"sapUiTableOuterBefore");if(t.getTitle()){this.renderHeader(r,t,t.getTitle());}if(t.getToolbar()){this.renderToolbar(r,t,t.getToolbar());}if(t.getExtension()&&t.getExtension().length>0){this.renderExtensions(r,t,t.getExtension());}r.write("<div");r.writeAttribute("id",t.getId()+"-sapUiTableCnt");r.addClass("sapUiTableCnt");r.writeClasses();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"CONTENT");r.writeAttribute("data-sap-ui-fastnavgroup","true");r.write(">");this.renderColRsz(r,t);this.renderColHdr(r,t);this.renderTable(r,t);t._getAccRenderExtension().writeHiddenAccTexts(r,t);r.write("<div");r.addClass("sapUiTableOverlayArea");r.writeClasses();r.writeAttribute("tabindex","0");r.writeAttribute("id",t.getId()+"-overlay");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"OVERLAY");r.write("></div>");r.write("</div>");if(t.getFooter()){this.renderFooter(r,t,t.getFooter());}if(t.getVisibleRowCountMode()==V.Interactive){this.renderVariableHeight(r,t);}this.renderTabElement(r,"sapUiTableOuterAfter");r.write("</div>");};
b.renderHeader=function(r,t,o){r.write("<div");r.addClass("sapUiTableHdr");r.writeClasses();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TABLEHEADER");r.write(">");r.renderControl(o);r.write("</div>");};
b.renderToolbar=function(r,t,o){r.write("<div");r.addClass("sapUiTableTbr");if(typeof o.getStandalone!=="function"){r.addClass("sapUiTableMTbr");}r.writeClasses();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TABLESUBHEADER");r.write(">");if(typeof o.getStandalone==="function"&&o.getStandalone()){o.setStandalone(false);}if(T.isInstanceOf(o,"sap/m/Toolbar")){o.setDesign(P.get("_sap_ui_table_Table_ToolbarDesign"),true);}r.renderControl(o);r.write("</div>");};
b.renderExtensions=function(r,t,e){for(var i=0,l=e.length;i<l;i++){this.renderExtension(r,t,e[i]);}};
b.renderExtension=function(r,t,e){r.write("<div");r.addClass("sapUiTableExt");r.writeClasses();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TABLESUBHEADER");r.write(">");r.renderControl(e);r.write("</div>");};
b.renderTable=function(r,t){r.write("<div");r.writeAttribute("id",t.getId()+"-tableCCnt");r.addClass("sapUiTableCCnt");r.writeClasses();r.write(">");this.renderTableCCnt(r,t);r.write("</div>");this.renderVSb(r,t);this.renderHSb(r,t);};
b.renderTableCCnt=function(r,t){this.renderTabElement(r,"sapUiTableCtrlBefore");this.renderTableCtrl(r,t);this.renderRowHdr(r,t);this.renderRowActions(r,t);this.renderTabElement(r,"sapUiTableCtrlAfter");r.write("<div");r.addClass("sapUiTableCtrlEmpty");r.writeClasses();r.writeAttribute("tabindex","0");r.writeAttribute("id",t.getId()+"-noDataCnt");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"NODATA");r.write(">");if(t.getNoData()instanceof C){r.renderControl(t.getNoData());}else{r.write("<span");r.writeAttribute("id",t.getId()+"-noDataMsg");r.addClass("sapUiTableCtrlEmptyMsg");r.writeClasses();r.write(">");r.writeEscaped(T.getNoDataText(t));r.write("</span>");}r.write("</div>");};
b.renderFooter=function(r,t,f){r.write("<div");r.addClass("sapUiTableFtr");r.writeClasses();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TABLEFOOTER");r.write(">");r.renderControl(f);r.write("</div>");};
b.renderVariableHeight=function(r,t){r.write('<div id="'+t.getId()+'-sb" tabIndex="-1"');r.addClass("sapUiTableHeightResizer");r.addStyle("height","5px");r.writeClasses();r.writeStyles();r.write(">");r.write("</div>");};
b.renderColHdr=function(r,t){var n=T.getHeaderRowCount(t);var c=t.getColumns();var f=t.getFixedColumnCount();r.write("<div");r.addClass("sapUiTableColHdrCnt");r.writeClasses();if(t.getColumnHeaderHeight()>0){r.addStyle("height",(t.getColumnHeaderHeight()*n)+"px");}r.writeStyles();r.write(">");this.renderColRowHdr(r,t);if(f>0){r.write("<div");r.addClass("sapUiTableCHA");r.addClass("sapUiTableCtrlScrFixed");r.addClass("sapUiTableNoOpacity");r.writeClasses();r.write(">");this.renderTableControlCnt(r,t,true,0,f,true,false,0,n,true);r.write("</div>");}r.write("<div");r.writeAttribute("id",t.getId()+"-sapUiTableColHdrScr");r.addClass("sapUiTableCHA");r.addClass("sapUiTableCtrlScr");if(c.length==0){r.addClass("sapUiTableHasNoColumns");}r.writeClasses();if(f>0){if(t._bRtlMode){r.addStyle("margin-right","0");}else{r.addStyle("margin-left","0");}r.writeStyles();}r.write(">");this.renderTableControlCnt(r,t,false,f,c.length,false,false,0,n,true);r.write("</div>");if(T.hasRowActions(t)){r.write("<div class='sapUiTableRowActionHeader' id='"+t.getId()+"-rowacthdr'");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"ROWACTIONHEADER");r.write("><span>");r.writeEscaped(t._oResBundle.getText("TBL_ROW_ACTION_COLUMN_LABEL"));r.write("</span></div>");}r.write("</div>");};
b.renderColRowHdr=function(r,t){var e=false;var s=false;r.write("<div");r.writeAttribute("id",t.getId()+"-selall");if(T.hasSelectAll(t)){var A=T.areAllRowsSelected(t);if(t._getShowStandardTooltips()){var c=A?"TBL_DESELECT_ALL":"TBL_SELECT_ALL";r.writeAttributeEscaped("title",t._oResBundle.getText(c));}if(!A){r.addClass("sapUiTableSelAll");}else{s=true;}r.addClass("sapUiTableSelAllEnabled");e=true;}else{r.addClass("sapUiTableSelAllDisabled");}r.addClass("sapUiTableColRowHdr");r.writeClasses();r.writeAttribute("tabindex","-1");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"COLUMNROWHEADER",{enabled:e,checked:s});r.write(">");if(t.getSelectionMode()!==S.Single){r.write("<div");r.addClass("sapUiTableColRowHdrIco");r.writeClasses();if(t.getColumnHeaderHeight()>0){r.addStyle("height",t.getColumnHeaderHeight()+"px");}r.write(">");r.write("</div>");}r.write("</div>");};
b.renderCol=function(r,t,c,h,n,l){var L,i=!n,d=c.getIndex(),e=c.getMultiLabels();if(e.length>0){L=e[h];}else if(h==0){L=c.getLabel();}r.write("<td");var H=c.getId();if(h===0){r.writeElementData(c);}else{H=H+"_"+h;r.writeAttribute('id',H);}r.writeAttribute('data-sap-ui-colid',c.getId());r.writeAttribute("data-sap-ui-colindex",d);r.writeAttribute("tabindex","-1");var A={column:c,headerId:H,index:d};if(n>1){r.writeAttribute("colspan",n);A.colspan=true;}t._getAccRenderExtension().writeAriaAttributesFor(r,t,"COLUMNHEADER",A);r.addClass("sapUiTableCol");if(l){r.addClass("sapUiTableColLastFixed");}r.writeClasses();if(t.getColumnHeaderHeight()>0){r.addStyle("height",t.getColumnHeaderHeight()+"px");}if(i){r.addStyle("display","none");}r.writeStyles();var s=c.getTooltip_AsString();if(s){r.writeAttributeEscaped("title",s);}r.write("><div");r.addClass("sapUiTableColCell");r.writeAttribute("id",H+"-inner");r.writeClasses();var f=R.getTextAlign(c.getHAlign(),L&&L.getTextDirection&&L.getTextDirection());if(f){r.addStyle("text-align",f);}r.writeStyles();r.write(">");if(L){r.renderControl(L);}r.write("</div></td>");};
b.renderColRsz=function(r,t){r.write("<div");r.writeAttribute("id",t.getId()+"-rsz");r.addClass("sapUiTableColRsz");r.writeClasses();r.write("></div>");};
b.renderRowHdr=function(r,t){r.write("<div");r.writeAttribute("id",t.getId()+"-sapUiTableRowHdrScr");r.addClass("sapUiTableRowHdrScr");r.addClass("sapUiTableNoOpacity");r.writeClasses();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"ROWHEADER_COL");r.write(">");for(var c=0,d=t.getRows().length;c<d;c++){this.renderRowAddon(r,t,t.getRows()[c],c,true);}r.write("</div>");};
b.renderRowActions=function(r,t){if(!T.hasRowActions(t)){return;}r.write("<div");r.writeAttribute("id",t.getId()+"-sapUiTableRowActionScr");r.addClass("sapUiTableRowActionScr");r.addClass("sapUiTableNoOpacity");r.writeClasses();r.write(">");for(var c=0,d=t.getRows().length;c<d;c++){this.renderRowAddon(r,t,t.getRows()[c],c,false);}r.write("</div>");};
b._addFixedRowCSSClasses=function(r,t,i){var f=t.getFixedRowCount();var F=T.getFirstFixedButtomRowIndex(t);if(f>0){if(i<f){r.addClass("sapUiTableFixedTopRow");}if(i==f-1){r.addClass("sapUiTableFixedLastTopRow");}}if(F>=0&&F===i){r.addClass("sapUiTableFixedFirstBottomRow");}else if(F>=1&&F-1===i){r.addClass("sapUiTableFixedPreBottomRow");}};
b.renderRowAddon=function(r,t,o,i,h){r.write("<div");r.writeAttribute("id",t.getId()+(h?"-rowsel":"-rowact")+i);r.writeAttribute("data-sap-ui-rowindex",i);r.addClass(h?"sapUiTableRowHdr":"sapUiTableRowAction");this._addFixedRowCSSClasses(r,t,i);var c=false;var d=false;if(o._bHidden){r.addClass("sapUiTableRowHidden");d=true;}else{if(t.isIndexSelected(o.getIndex())){r.addClass("sapUiTableRowSel");c=true;}}r.writeClasses();if(t.getRowHeight()>0){r.addStyle("height",t.getRowHeight()+"px");}r.writeAttribute("tabindex","-1");t._getAccRenderExtension().writeAriaAttributesFor(r,t,h?"ROWHEADER":"ROWACTION",{rowSelected:c,rowHidden:d});r.writeStyles();r.write(">");if(h){this.writeRowHighlightContent(r,t,o,i);this.writeRowSelectorContent(r,t,o,i);}else{var A=o.getAggregation("_rowAction");if(A){r.renderControl(A);}}r.write("</div>");};
b.renderTableCtrl=function(r,t){if(t.getFixedColumnCount()>0){r.write("<div");r.writeAttribute("id",t.getId()+"-sapUiTableCtrlScrFixed");r.addClass("sapUiTableCtrlScrFixed");r.writeClasses();r.write(">");this.renderTableControl(r,t,true);r.write("</div>");}r.write("<div");r.writeAttribute("id",t.getId()+"-sapUiTableCtrlScr");r.addClass("sapUiTableCtrlScr");r.writeClasses();if(t.getFixedColumnCount()>0){if(t._bRtlMode){r.addStyle("margin-right","0");}else{r.addStyle("margin-left","0");}r.writeStyles();}r.write(">");r.write("<div");r.writeAttribute("id",t.getId()+"-tableCtrlCnt");r.addClass("sapUiTableCtrlCnt");r.writeClasses();var v=t.getVisibleRowCountMode();if(t._iTableRowContentHeight&&(v==V.Fixed||v==V.Interactive)){var s="height";if(t.getVisibleRowCountMode()==V.Fixed){s="min-height";}r.addStyle(s,t._iTableRowContentHeight+"px");r.writeStyles();}r.write(">");this.renderTableControl(r,t,false);r.write("</div></div>");};
b.renderTableControl=function(r,t,f){var s,e;if(f){s=0;e=t.getFixedColumnCount();}else{s=t.getFixedColumnCount();e=t.getColumns().length;}var F=t.getFixedRowCount();var i=t.getFixedBottomRowCount();var c=t.getRows();if(F>0){this.renderTableControlCnt(r,t,f,s,e,true,false,0,F);}this.renderTableControlCnt(r,t,f,s,e,false,false,F,c.length-i);if(i>0&&c.length>0){this.renderTableControlCnt(r,t,f,s,e,false,true,c.length-i,c.length);}};
b.renderTableControlCnt=function(r,t,f,s,e,F,c,i,E,h){r.write("<table");var d=h?"-header":"-table";var g=t.getId()+d;if(f){g+="-fixed";r.addClass("sapUiTableCtrlFixed");}else{r.addClass("sapUiTableCtrlScroll");}if(F){g+="-fixrow";r.addClass("sapUiTableCtrlRowFixed");}else if(c){g+="-fixrow-bottom";r.addClass("sapUiTableCtrlRowFixedBottom");}else{r.addClass("sapUiTableCtrlRowScroll");}r.writeAttribute("id",g);t._getAccRenderExtension().writeAriaAttributesFor(r,t,h?"COLUMNHEADER_TABLE":"TABLE");r.addClass("sapUiTableCtrl");if(h){r.addClass("sapUiTableCHT");}r.writeClasses();r.addStyle("min-width",t._getColumnsWidth(s,e)+"px");if(f&&(!!D.browser.firefox||!!D.browser.chrome||!!D.browser.safari)){r.addStyle("width",t._getColumnsWidth(s,e)+"px");}r.writeStyles();r.write(">");r.write("<thead>");r.write("<tr");r.addClass("sapUiTableCtrlCol");if(i==0){r.addClass("sapUiTableCtrlFirstCol");}if(h){r.addClass("sapUiTableCHTHR");}r.writeClasses();r.write(">");var j=t.getColumns();var k=new Array(e);var l;var o;var H=false;var m=!f&&e>s;for(l=s;l<e;l++){o=j[l];var n={shouldRender:!!(o&&o.shouldRender())};if(n.shouldRender){var w=o.getWidth();if(T.isVariableWidth(w)){m=false;if(f){w=(o._iFixWidth||160)+"px";}else if(w&&w.indexOf("%")>0){H=true;}}n.width=w;}k[l]=n;}if(T.hasRowHeader(t)&&!h){r.write("<th");if(H){r.addStyle("width","0%");}else{r.addStyle("width","0px");}r.writeStyles();if(i==0){t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TH");if(!h){r.writeAttribute("id",t.getId()+"-colsel");}r.addClass("sapUiTableColSel");r.writeClasses();}r.write("></th>");}else{if(j.length===0){r.write("<th></th>");}}for(l=s;l<e;l++){d=h?"_hdr":"_col";o=j[l];n=k[l];if(n.shouldRender){r.write("<th");if(n.width){r.addStyle("width",n.width);r.writeStyles();}if(i==0){t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TH",{column:o});r.writeAttribute("id",t.getId()+d+l);}r.writeAttribute("data-sap-ui-headcolindex",l);r.writeAttribute("data-sap-ui-colid",o.getId());r.write(">");if(i==0&&T.getHeaderRowCount(t)==0&&!h){if(o.getMultiLabels().length>0){r.renderControl(o.getMultiLabels()[0]);}else{r.renderControl(o.getLabel());}}r.write("</th>");}}if(m){r.write("<th");if(h){r.writeAttribute("id",t.getId()+"-dummycolhdr");}t._getAccRenderExtension().writeAriaAttributesFor(r,t,"PRESENTATION");r.write("></th>");}r.write("</tr>");r.write("</thead>");r.write("<tbody>");var v=t._getVisibleColumns();var p=t.getRows();var u;var x;if(h){for(u=i,x=E;u<x;u++){this.renderColumnHeaderRow(r,t,u,f,s,e,m);}}else{var y=t._getAccExtension().getAriaTextsForSelectionMode(true);var z=T.isRowSelectionAllowed(t);for(u=i,x=E;u<x;u++){this.renderTableRow(r,t,p[u],u,f,s,e,false,v,m,y,z);}}r.write("</tbody>");r.write("</table>");};
b.addTrClasses=function(r,t,o,i){return;};
b.writeRowSelectorContent=function(r,t,o,i){t._getAccRenderExtension().writeAccRowSelectorText(r,t,o,i);if(T.Grouping.isGroupMode(t)){r.write("<div");r.writeAttribute("class","sapUiTableGroupShield");r.write("></div>");r.write("<div");r.writeAttribute("id",o.getId()+"-groupHeader");r.writeAttribute("class","sapUiTableGroupIcon");r.write("></div>");if(T.Grouping.showGroupMenuButton(t)){var c=I.getIconInfo("sap-icon://drop-down-list");r.write("<div class='sapUiTableGroupMenuButton'>");r.writeEscaped(c.content);r.write("</div>");}}};
b.writeRowHighlightContent=function(r,t,o,i){if(!T.hasRowHighlights(t)){return;}var c=o.getAggregation("_settings");var h=c._getHighlightCSSClassName();r.write("<div");r.writeAttribute("id",o.getId()+"-highlight");r.addClass("sapUiTableRowHighlight");r.addClass(h);r.writeClasses();r.write(">");t._getAccRenderExtension().writeAccRowHighlightText(r,t,o,i);r.write("</div>");};
b.renderColumnHeaderRow=function(r,t,i,f,s,e,h){r.write("<tr");r.addClass("sapUiTableColHdrTr");r.writeClasses();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"COLUMNHEADER_ROW");r.write(">");var c,n=0,l=-1;c=t.getColumns().slice(s,e).filter(function(o){return!!o&&o.shouldRender();});function d(o,j,k){var m=T.Column.getHeaderSpan(o,i),p;if(n<1){if(m>1){p=o.getIndex();m=k.slice(j+1,j+m).reduce(function(u,v){return v.getIndex()-p<m?u+1:u;},1);}o._nSpan=n=m;l=j;}else{o._nSpan=0;}n--;}c.forEach(d);function g(o,j){this.renderCol(r,t,o,i,o._nSpan,f&&(j==l));o._nSpan=undefined;}c.forEach(g.bind(this));if(!f&&h&&c.length>0){r.write('<td class="sapUiTableTDDummy"');t._getAccRenderExtension().writeAriaAttributesFor(r,t,"PRESENTATION");r.write('></td>');}r.write("</tr>");};
b.renderTableRow=function(r,t,o,i,f,s,e,F,v,h,m,c){if(!o){return;}r.write("<tr");if(o._bDummyRow){r.addStyle("opacity","0");}r.addClass("sapUiTableTr");if(f){r.writeAttribute("id",o.getId()+"-fixed");}else{r.writeElementData(o);}if(o._bHidden){r.addClass("sapUiTableRowHidden");}else{if(t.isIndexSelected(o.getIndex())){r.addClass("sapUiTableRowSel");}this.addTrClasses(r,t,o,i);}if(i%2===0){r.addClass("sapUiTableRowEven");}else{r.addClass("sapUiTableRowOdd");}var d=t.getRows();var g=d.length;if(g>0&&d[g-1]===o){r.addClass("sapUiTableLastRow");}else if(g>0&&d[0]===o){r.addClass("sapUiTableFirstRow");}this._addFixedRowCSSClasses(r,t,i);r.writeClasses();r.writeAttribute("data-sap-ui-rowindex",i);var j=t.getRowHeight();if(j>0){r.addStyle("height",j+"px");}r.writeStyles();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TR",{index:i});r.write(">");var k=o.getCells();if(T.hasRowHeader(t)||k.length===0){r.write("<td");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"ROWHEADER_TD",{rowSelected:!o._bHidden&&t.isIndexSelected(o.getIndex()),index:i});r.write("></td>");}for(var l=0,n=k.length;l<n;l++){this.renderTableCell(r,t,o,k[l],l,f,s,e,v);}if(!f&&h&&k.length>0){r.write('<td class="sapUiTableTDDummy"');t._getAccRenderExtension().writeAriaAttributesFor(r,t,"PRESENTATION");r.write('></td>');}r.write("</tr>");};
b.renderTableCell=function(r,t,o,c,i,f,s,e,v){var d=c.data("sap-ui-colindex");var g=t.getColumns()[d];if(g.shouldRender()&&s<=d&&e>d){r.write("<td");var h=o.getId()+"-col"+i;r.writeAttribute("id",h);r.writeAttribute("tabindex","-1");r.writeAttribute("data-sap-ui-colid",g.getId());var n=v.length;var j=n>0&&v[0]===g;var k=n>0&&v[n-1]===g;t._getAccRenderExtension().writeAriaAttributesFor(r,t,"DATACELL",{index:d,column:g,row:o,fixed:f,firstCol:j});var H=R.getTextAlign(g.getHAlign(),c&&c.getTextDirection&&c.getTextDirection());if(H){r.addStyle("text-align",H);}r.writeStyles();r.addClass("sapUiTableTd");if(j){r.addClass("sapUiTableTdFirst");}if(k){r.addClass("sapUiTableTdLast");}if(g.getGrouped()){r.addClass("sapUiTableTdGroup");}var B=t.getBinding("rows");if(B&&g.getLeadingProperty&&B.isMeasure(g.getLeadingProperty())){r.addClass("sapUiTableMeasureCell");}r.writeClasses();r.write("><div");r.addClass("sapUiTableCell");if(j&&T.Grouping.isTreeMode(t)){r.addClass("sapUiTableCellFlex");}r.writeClasses();if(t.getRowHeight()&&t.getVisibleRowCountMode()==V.Auto){r.addStyle("max-height",t.getRowHeight()+"px");}r.writeStyles();r.write(">");this.renderTableCellControl(r,t,c,j);r.write("</div></td>");}};
b.renderTableCellControl=function(r,t,c,i){if(i&&T.Grouping.isTreeMode(t)&&!t._bFlatMode){var o=c.getParent();r.write("<span class='sapUiTableTreeIcon' tabindex='-1' id='"+o.getId()+"-treeicon'");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TREEICON",{row:o});r.write("></span>");}r.renderControl(c);};
b.renderVSb=function(r,t){r.write("<div");r.addClass("sapUiTableVSbBg");r.writeAttribute("id",t.getId()+"-vsb-bg");r.writeClasses();r.write("></div>");r.write("<div");r.addClass("sapUiTableVSb");r.writeClasses();r.writeAttribute("id",t.getId()+"-vsb");r.writeAttribute("tabindex","-1");r.addStyle("max-height",t._getVSbHeight()+"px");if(t.getFixedRowCount()>0){t._iVsbTop=(t.getFixedRowCount()*t._getDefaultRowHeight())-1;r.addStyle("top",t._iVsbTop+'px');}r.writeStyles();r.write(">");r.write("<div");r.writeAttribute("id",t.getId()+"-vsb-content");r.addClass("sapUiTableVSbContent");r.writeClasses();r.addStyle("height",t._getTotalScrollRange()+"px");r.writeStyles();r.write(">");r.write("</div>");r.write("</div>");};
b.renderHSb=function(r,t){r.write("<div");r.addClass("sapUiTableHSbBg");r.writeAttribute("id",t.getId()+"-hsb-bg");r.writeClasses();r.write("></div>");r.write("<div");r.addClass("sapUiTableHSb");r.writeClasses();r.writeAttribute("id",t.getId()+"-hsb");r.writeAttribute("tabindex","-1");r.write(">");r.write("<div");r.writeAttribute("id",t.getId()+"-hsb-content");r.addClass("sapUiTableHSbContent");r.writeClasses();r.write(">");r.write("</div>");r.write("</div>");};
b.renderTabElement=function(r,c){r.write("<div");if(c){r.addClass(c);r.writeClasses();}r.writeAttribute("tabindex","0");r.write("></div>");};
return b;},true);
sap.ui.predefine('sap/ui/table/TableRendererUtils',['jquery.sap.global','sap/ui/core/Control'],function(q,C){"use strict";var T=null;var a={addClass:function(r,c,s){if(c&&(!!s||arguments.length==2)){r.addClass(c);if(T){T.writeClasses=true;}}return a;},addStyle:function(r,n,v,s){if(n&&v&&(!!s||arguments.length==3)){r.addStyle(n,v);if(T){T.writeStyles=true;}}return a;},startElement:function(r,t,c){c=c||{};r.write("<",c.tag||"div");T=c;if(c.furtherSettings){c.furtherSettings(r,t);}if(q.isArray(c.classname)&&c.classname.length){for(var i=0;i<c.classname.length;i++){a.addClass(r,c.classname[i]);}}else if(c.classname){a.addClass(r,c.classname);}if(c.id){r.writeAttribute("id",(c.element||t).getId()+"-"+c.id);}else if(c.element){if(c.element instanceof C){r.writeControlData(c.element);}else{r.writeElementData(c.element);}}if(c.attributes){for(var n in c.attributes){if(c.attributes.hasOwnProperty(n)){r.writeAttribute(n,c.attributes[n]);}}}if(typeof c.tabindex==="number"){r.writeAttribute("tabindex",""+c.tabindex);}if(c.aria){t._getAccRenderExtension().writeAriaAttributesFor(r,t,c.aria,c.ariaconfig);}if(T.writeClasses){r.writeClasses();}if(T.writeStyles){r.writeStyles();}T=null;r.write(">");return a;},endElement:function(r,t){r.write("</",t||"div",">");return a;},renderElement:function(r,t,c){a.startElement(r,t,c);a.endElement(r,c?c.tag:null);return a;}};return a;},true);
sap.ui.predefine('sap/ui/table/TableScrollExtension',["jquery.sap.global","./TableExtension","./TableUtils","sap/ui/Device","./library"],function(q,T,a,D,l){"use strict";var S=l.SharedDomRef;var H={onScroll:function(e){var s=this._getScrollExtension();q.sap.interaction.notifyScrollEvent&&q.sap.interaction.notifyScrollEvent(e);if(this._bOnAfterRendering){return;}var n=e.target.scrollLeft;var O=e.target._scrollLeft;if(n!==O){var f=H._getScrollAreas(this);e.target._scrollLeft=n;for(var i=0;i<f.length;i++){var g=f[i];if(g!==e.target&&g.scrollLeft!==n){g.scrollLeft=n;g._scrollLeft=n;}}s._iHorizontalScrollPosition=n;this._determineVisibleCols(this._collectTableSizes());}},restoreScrollPosition:function(t){var s=t._getScrollExtension();var h=s.getHorizontalScrollbar();if(h!==null&&s._iHorizontalScrollPosition!==null){var e=H._getScrollAreas(t);for(var i=0;i<e.length;i++){var f=e[i];delete f._scrollLeft;}if(h.scrollLeft!==s._iHorizontalScrollPosition){h.scrollLeft=s._iHorizontalScrollPosition;}else{var g=q.Event("scroll");g.target=h;H.onScroll.call(t,g);}}},addEventListeners:function(t){var s=t._getScrollExtension();var e=H._getScrollAreas(t);if(s._onHorizontalScrollEventHandler==null){s._onHorizontalScrollEventHandler=H.onScroll.bind(t);}for(var i=0;i<e.length;i++){e[i].addEventListener("scroll",s._onHorizontalScrollEventHandler);}},removeEventListeners:function(t){var s=t._getScrollExtension();var e=H._getScrollAreas(t);if(s._onHorizontalScrollEventHandler!=null){for(var i=0;i<e.length;i++){e[i].removeEventListener("scroll",s._onHorizontalScrollEventHandler);delete e[i]._scrollLeft;}delete s._onHorizontalScrollEventHandler;}},_getScrollAreas:function(t){var s=[t._getScrollExtension().getHorizontalScrollbar(),t.getDomRef("sapUiTableColHdrScr"),t.getDomRef("sapUiTableCtrlScr")];return s.filter(function(e){return e!=null;});}};var V={onScroll:function(e){var s=this._getScrollExtension();q.sap.interaction.notifyScrollEvent&&q.sap.interaction.notifyScrollEvent(e);if(s._bIsScrolledVerticallyByKeyboard){return;}this._getKeyboardExtension().setActionMode(false);function u(t){var v=t._getScrollExtension().getVerticalScrollbar();if(!v){return;}var i=v.scrollTop;s._iVerticalScrollPosition=i;var n=t._getFirstVisibleRowByScrollTop(i);var O=t.getFirstVisibleRow();var f=n!==O;if(f){t.setFirstVisibleRow(n,true);if(a.isVariableRowHeightEnabled(t)){t.attachEventOnce("_rowsUpdated",function(){this._adjustTablePosition(v.scrollTop,this._aRowHeights);});}}else if(a.isVariableRowHeightEnabled(t)){t._adjustTablePosition(i,t._aRowHeights);}}if(this._bLargeDataScrolling&&!s._bIsScrolledVerticallyByWheel){q.sap.clearDelayedCall(this._mTimeouts.scrollUpdateTimerId);this._mTimeouts.scrollUpdateTimerId=q.sap.delayedCall(300,this,function(){u(this);delete this._mTimeouts.scrollUpdateTimerId;}.bind(this));}else{u(this);}s._bIsScrolledVerticallyByWheel=false;},onScrollbarMouseDown:function(e){var s=this._getScrollExtension();s._bIsScrolledVerticallyByWheel=false;s._bIsScrolledVerticallyByKeyboard=false;},restoreScrollPosition:function(t){var s=t._getScrollExtension();if(s._iVerticalScrollPosition!==null){t._updateVSbScrollTop(s._iVerticalScrollPosition);}else{t._updateVSbScrollTop();}},addEventListeners:function(t){var s=t._getScrollExtension();var e=V._getScrollAreas(t);var v=s.getVerticalScrollbar();if(s._onVerticalScrollEventHandler==null){s._onVerticalScrollEventHandler=V.onScroll.bind(t);}for(var i=0;i<e.length;i++){e[i].addEventListener("scroll",s._onVerticalScrollEventHandler);}if(v!==null){if(s._onVerticalScrollbarMouseDownEventHandler==null){s._onVerticalScrollbarMouseDownEventHandler=V.onScrollbarMouseDown.bind(t);}v.addEventListener("mousedown",s._onVerticalScrollbarMouseDownEventHandler);}},removeEventListeners:function(t){var s=t._getScrollExtension();var e=V._getScrollAreas(t);var v=s.getVerticalScrollbar();if(s._onVerticalScrollEventHandler!=null){for(var i=0;i<e.length;i++){e[i].removeEventListener("scroll",s._onVerticalScrollEventHandler);}delete s._onVerticalScrollEventHandler;}if(v!==null&&s._onVerticalScrollbarMouseDownEventHandler!=null){v.removeEventListener("mousedown",s._onVerticalScrollbarMouseDownEventHandler);delete s._onVerticalScrollbarMouseDownEventHandler;}},_getScrollAreas:function(t){var s=[t._getScrollExtension().getVerticalScrollbar()];return s.filter(function(e){return e!=null;});}};var E={onMouseWheelScrolling:function(e){var s=this._getScrollExtension();var O=e.originalEvent;var h=O.shiftKey;var f;var g=false;var i=0;if(D.browser.firefox){i=O.detail;}else if(h){i=O.deltaX;}else{i=O.deltaY;}f=i>0;if(h){var j=s.getHorizontalScrollbar();if(f){g=j.scrollLeft===j.scrollWidth-j.clientWidth;}else{g=j.scrollLeft===0;}if(s.isHorizontalScrollbarVisible()&&!g){e.preventDefault();e.stopPropagation();j.scrollLeft=j.scrollLeft+i;}}else{var v=s.getVerticalScrollbar();if(f){g=v.scrollTop===v.scrollHeight-v.clientHeight;}else{g=v.scrollTop===0;}if(s.isVerticalScrollbarVisible()&&!g){e.preventDefault();e.stopPropagation();var r=i/this._getDefaultRowHeight();if(r>1){r=Math.floor(r);}s._bIsScrolledVerticallyByWheel=true;s._bIsScrolledVerticallyByKeyboard=false;v.scrollTop+=r*this._getScrollingPixelsForRow();}}}};
function o(e){if(e.type==="touchstart"||e.pointerType==="touch"){this._bIsScrollVertical=null;var t=e.touches?e.touches[0]:e;this._aTouchStartPosition=[t.pageX,t.pageY];if(this._oVSb){this._iTouchScrollTop=this._oVSb.scrollTop;}if(this._oHSb){this._iTouchScrollLeft=this._oHSb.scrollLeft;}}}
function b(e){if((e.type==="touchmove"||e.pointerType==="touch")&&this._aTouchStartPosition){var t=e.touches?e.touches[0]:e;var i=(t.pageX-this._aTouchStartPosition[0]);var f=(t.pageY-this._aTouchStartPosition[1]);if(this._bIsScrollVertical===null){if(i===0&&f===0){return;}this._bIsScrollVertical=Math.abs(f)>=Math.abs(i);}if(this._bIsScrollVertical&&this._oVSb){this._oVSb.scrollTop=this._iTouchScrollTop-f;if(D.browser.safari){e.preventDefault();}}else if(!this._bIsScrollVertical&&this._oHSb){this._oHSb.scrollLeft=this._iTouchScrollLeft-i;if(D.browser.safari){e.preventDefault();}}}}
var c={_ontouchstart:o,_ontouchmove:b,onAfterRendering:function(e){V.restoreScrollPosition(this);H.restoreScrollPosition(this);this._oVSb=this._getScrollExtension().getVerticalScrollbar();this._oHSb=this._getScrollExtension().getHorizontalScrollbar();var f=this.getDomRef("tableCCnt");if(D.support.pointer&&D.system.desktop){f.addEventListener("pointerdown",o.bind(this));f.addEventListener("pointermove",b.bind(this),D.browser.chrome?{passive:true}:false);}else if(D.support.touch){f.addEventListener("touchstart",o.bind(this));f.addEventListener("touchmove",b.bind(this));}},onfocusin:function(e){var $;var f=q(e.target);if(f.parent(".sapUiTableTr").length>0){$=q(this.getDomRef("sapUiTableCtrlScr"));}else if(f.parent(".sapUiTableColHdr").length>0){$=q(this.getDomRef("sapUiTableColHdrScr"));}if((D.browser.firefox||D.browser.chrome)&&$&&$.length>0){var C=$.scrollLeft();var i=$.width();var g=f.position().left;var h=g+f.width();var O=g-C;var j=h-i-C;var k=this._getScrollExtension().getHorizontalScrollbar();if(j>0){k.scrollLeft=k.scrollLeft+j+1;}else if(O<0){k.scrollLeft=k.scrollLeft+O-1;}}var p=a.getParentCell(this,e.target);if(p!=null){Promise.resolve().then(function(){var I=p.find(".sapUiTableCell")[0];if(I!=null){I.scrollLeft=0;I.scrollTop=0;}});}}};
var d=T.extend("sap.ui.table.TableScrollExtension",{
_init:function(t,s,m){this._type=s;this._delegate=c;this._iHorizontalScrollPosition=null;this._iVerticalScrollPosition=null;this._bIsScrolledVerticallyByWheel=false;this._bIsScrolledVerticallyByKeyboard=false;t.addEventDelegate(this._delegate,t);return"ScrollExtension";},
_attachEvents:function(){var t=this.getTable();H.addEventListeners(t);V.addEventListeners(t);if(D.browser.firefox){t._getScrollTargets().on("MozMousePixelScroll.sapUiTableMouseWheel",E.onMouseWheelScrolling.bind(t));}else{t._getScrollTargets().on("wheel.sapUiTableMouseWheel",E.onMouseWheelScrolling.bind(t));}},
_detachEvents:function(){var t=this.getTable();H.removeEventListeners(t);V.removeEventListeners(t);if(D.browser.firefox){t._getScrollTargets().off("MozMousePixelScroll.sapUiTableMouseWheel");}else{t._getScrollTargets().off("wheel.sapUiTableMouseWheel");}},
_debug:function(){this._ExtensionHelper=E;this._ExtensionDelegate=c;this._HorizontalScrollingHelper=H;this._VerticalScrollingHelper=V;},
destroy:function(){var t=this.getTable();if(t){t.removeEventDelegate(this._delegate);}this._delegate=null;T.prototype.destroy.apply(this,arguments);}
});
d.prototype.scroll=function(e,p,i){if(e==null){e=false;}if(p==null){p=false;}if(i==null){i=false;}var t=this.getTable();var s=false;var r=t._getRowCount();var v=t.getVisibleRowCount();var f=v-t.getFixedRowCount()-t.getFixedBottomRowCount();var F=t.getFirstVisibleRow();var g=p?f:1;if(e){if(F+v<r){t.setFirstVisibleRow(Math.min(F+g,r-v));s=true;}}else if(F>0){t.setFirstVisibleRow(Math.max(F-g,0));s=true;}if(s&&i){this._bIsScrolledVerticallyByKeyboard=true;}return s;};
d.prototype.scrollMax=function(e,i){if(e==null){e=false;}if(i==null){i=false;}var t=this.getTable();var s=false;var f=t.getFirstVisibleRow();if(e){var F=t._getRowCount()-a.getNonEmptyVisibleRowCount(t);if(f<F){t.setFirstVisibleRow(F);s=true;}}else if(f>0){t.setFirstVisibleRow(0);s=true;}if(s&&i){this._bIsScrolledVerticallyByKeyboard=true;}return s;};
d.prototype.getHorizontalScrollbar=function(){var t=this.getTable();if(t!=null){var v=t.getDomRef(S.HorizontalScrollBar);if(v!=null){return v;}}return null;};
d.prototype.getVerticalScrollbar=function(){var t=this.getTable();if(t!=null){var v=t.getDomRef(S.VerticalScrollBar);if(v!=null){return v;}}return null;};
d.prototype.isHorizontalScrollbarVisible=function(){var t=this.getTable();if(t!=null){var e=t.getDomRef();if(e!=null){return e.classList.contains("sapUiTableHScr");}}return false;};
d.prototype.isVerticalScrollbarVisible=function(){var t=this.getTable();if(t!=null){var e=t.getDomRef();if(e!=null){return e.classList.contains("sapUiTableVScr");}}return false;};
d.prototype.updateVerticalScrollbarHeight=function(){var t=this.getTable();t.getDomRef(S.VerticalScrollBar).style.maxHeight=t._getVSbHeight()+"px";};
return d;},true);
sap.ui.predefine('sap/ui/table/TableUtils',["jquery.sap.global","sap/ui/core/Control","sap/ui/core/ResizeHandler","sap/ui/core/library","sap/ui/Device","sap/ui/model/ChangeReason","./TableGrouping","./TableColumnUtils","./TableMenuUtils","./library"],function(q,C,R,c,D,a,T,b,d,l){"use strict";var S=l.SelectionBehavior;var e=l.SelectionMode;var M=c.MessageType;var f=1;var g={DATACELL:1,COLUMNHEADER:2,ROWHEADER:4,ROWACTION:8,COLUMNROWHEADER:16};g.ANYCONTENTCELL=g.ROWHEADER|g.DATACELL|g.ROWACTION;g.ANYCOLUMNHEADER=g.COLUMNHEADER|g.COLUMNROWHEADER;g.ANYROWHEADER=g.ROWHEADER|g.COLUMNROWHEADER;g.ANY=g.ANYCONTENTCELL|g.ANYCOLUMNHEADER;var h={Grouping:T,Column:b,Menu:d,CELLTYPE:g,DEFAULT_ROW_HEIGHT:{sapUiSizeCondensed:24+f,sapUiSizeCompact:32+f,sapUiSizeCozy:48+f,undefined:32+f},RowsUpdateReason:(function(){var u={};for(var p in a){u[p]=a[p];}u.Render="Render";u.VerticalScroll="VerticalScroll";u.FirstVisibleRowChange="FirstVisibleRowChange";u.Unbind="Unbind";u.Animation="Animation";u.Resize="Resize";u.Unknown="Unknown";return u;})(),hasRowHeader:function(t){return(t.getSelectionMode()!==e.None&&t.getSelectionBehavior()!==S.RowOnly)||T.isGroupMode(t);},hasSelectAll:function(t){var s=t!=null?t.getSelectionMode():e.None;return(s===e.Multi||s===e.MultiToggle)&&t.getEnableSelectAll();},hasRowHighlights:function(t){if(t==null){return false;}var r=t.getRowSettingsTemplate();if(r==null){return false;}var H=r.getHighlight();return r.isBound("highlight")||(H!=null&&H!==M.None);},getRowActionCount:function(t){var o=t.getRowActionTemplate();return o?o._getCount():0;},hasRowActions:function(t){var r=t.getRowActionTemplate();return r!=null&&(r.isBound("visible")||r.getVisible())&&h.getRowActionCount(t)>0;},isRowSelectionAllowed:function(t){return t.getSelectionMode()!==e.None&&(t.getSelectionBehavior()===S.Row||t.getSelectionBehavior()===S.RowOnly);},isRowSelectorSelectionAllowed:function(t){return t.getSelectionMode()!==e.None&&h.hasRowHeader(t);},areAllRowsSelected:function(t){if(t==null){return false;}var s=t._getSelectableRowCount();return s>0&&s===t._getSelectedIndicesCount();},isNoDataVisible:function(t){if(!t.getShowNoData()){return false;}return!h.hasData(t);},hasData:function(t){var B=t.getBinding("rows"),i=t._getRowCount(),H=B?!!i:false;if(B&&B.providesGrandTotal){var j=B.providesGrandTotal()&&B.hasTotaledMeasures();H=(j&&i<2)||(!j&&i===0)?false:true;}return H;},isBusyIndicatorVisible:function(t){if(t==null||t.getDomRef()==null){return false;}return t.getDomRef().querySelector(".sapUiTableCnt > .sapUiLocalBusyIndicator")!=null;},hasPendingRequests:function(t){if(t==null){return false;}if(h.canUsePendingRequestsCounter(t)){return t._iPendingRequests>0;}else{return t._bPendingRequest;}},canUsePendingRequestsCounter:function(t){var B=t!=null?t.getBinding("rows"):null;var A=h.isInstanceOf(B,"sap/ui/model/analytics/AnalyticalBinding")&&!B.bUseBatchRequests;var i=h.isInstanceOf(B,"sap/ui/model/TreeBinding");return!A&&!i;},isInstanceOf:function(o,t){if(!o||!t){return false;}var i=sap.ui.require(t);return!!(i&&(o instanceof i));},toggleRowSelection:function(t,r,s,i){if(t==null||t.getBinding("rows")==null||t.getSelectionMode()===e.None||r==null){return false;}function j(A){if(!t._isRowSelectable(A)){return false;}t._iSourceRowIndex=A;var k=true;if(i){k=i(A,s);}else{if(t.isIndexSelected(A)){if(s!=null&&s){return false;}t.removeSelectionInterval(A,A);}else{if(s!=null&&!s){return false;}t.addSelectionInterval(A,A);}}delete t._iSourceRowIndex;return k;}if(typeof r==="number"){if(r<0||r>=t._getRowCount()){return false;}return j(r);}else{var $=q(r);var o=h.getCellInfo($[0]);var I=h.isRowSelectionAllowed(t);if(!h.Grouping.isInGroupingRow($[0])&&((o.isOfType(h.CELLTYPE.DATACELL|h.CELLTYPE.ROWACTION)&&I)||(o.isOfType(h.CELLTYPE.ROWHEADER)&&h.isRowSelectorSelectionAllowed(t)))){var A;if(o.isOfType(h.CELLTYPE.DATACELL)){A=t.getRows()[parseInt($.closest("tr",t.getDomRef()).attr("data-sap-ui-rowindex"),10)].getIndex();}else{A=t.getRows()[parseInt($.attr("data-sap-ui-rowindex"),10)].getIndex();}return j(A);}return false;}},getNoDataText:function(t){var n=t.getNoData();if(n instanceof C){return null;}else if(typeof n==="string"||t.getNoData()instanceof String){return n;}else{return t._oResBundle.getText("TBL_NO_DATA");}},getVisibleColumnCount:function(t){return t._getVisibleColumns().length;},getHeaderRowCount:function(t){if(t._iHeaderRowCount===undefined){if(!t.getColumnHeaderVisible()){t._iHeaderRowCount=0;}else{var H=1;var j=t.getColumns();for(var i=0;i<j.length;i++){if(j[i].shouldRender()){H=Math.max(H,j[i].getMultiLabels().length);}}t._iHeaderRowCount=H;}}return t._iHeaderRowCount;},isVariableRowHeightEnabled:function(t){return t._bVariableRowHeightEnabled&&t.getFixedRowCount()<=0&&t.getFixedBottomRowCount()<=0;},getTotalRowCount:function(t,i){var r=t._getRowCount();if(i){r=Math.max(r,t.getVisibleRowCount());}return r;},getNonEmptyVisibleRowCount:function(t){return Math.min(t.getVisibleRowCount(),t._getRowCount());},getFocusedItemInfo:function(t){var i=t._getItemNavigation();if(!i){return null;}return{cell:i.getFocusedIndex(),columnCount:i.iColumns,cellInRow:i.getFocusedIndex()%i.iColumns,row:Math.floor(i.getFocusedIndex()/i.iColumns),cellCount:i.getItemDomRefs().length,domRef:i.getFocusedDomRef()};},getRowIndexOfFocusedCell:function(t){var i=h.getFocusedItemInfo(t);return i.row-h.getHeaderRowCount(t);},isFixedColumn:function(t,i){return i<t.getFixedColumnCount();},hasFixedColumns:function(t){return t.getFixedColumnCount()>0;},focusItem:function(t,i,E){var I=t._getItemNavigation();if(I){I.focusItem(i,E);}},getCellInfo:function(o){var i;var $=q(o);var s;var j;var r;var k;var m;i={type:0,cell:null,rowIndex:null,columnIndex:null,columnSpan:null};if($.hasClass("sapUiTableTd")){s=$.data("sap-ui-colid");j=sap.ui.getCore().byId(s);i.type=h.CELLTYPE.DATACELL;i.rowIndex=parseInt($.parent().data("sap-ui-rowindex"),10);i.columnIndex=j.getIndex();i.columnSpan=1;}else if($.hasClass("sapUiTableCol")){r=/_([\d]+)/;s=$.attr("id");k=r.exec(s);m=k==null||k[1]==null?0:parseInt(k[1],10);i.type=h.CELLTYPE.COLUMNHEADER;i.rowIndex=m;i.columnIndex=parseInt($.data("sap-ui-colindex"),10);i.columnSpan=parseInt($.attr("colspan")||1,10);}else if($.hasClass("sapUiTableRowHdr")){i.type=h.CELLTYPE.ROWHEADER;i.rowIndex=parseInt($.data("sap-ui-rowindex"),10);i.columnIndex=-1;i.columnSpan=1;}else if($.hasClass("sapUiTableRowAction")){i.type=h.CELLTYPE.ROWACTION;i.rowIndex=parseInt($.data("sap-ui-rowindex"),10);i.columnIndex=-2;i.columnSpan=1;}else if($.hasClass("sapUiTableColRowHdr")){i.type=h.CELLTYPE.COLUMNROWHEADER;i.columnIndex=-1;i.columnSpan=1;}if(i.type!==0){i.cell=$;}i.isOfType=function(n){if(n==null){return false;}return(this.type&n)>0;};return i;},getRowColCell:function(t,r,j,I){var o=r>=0&&r<t.getRows().length?t.getRows()[r]:null;var k=I?t.getColumns():t._getVisibleColumns();var m=j>=0&&j<k.length?k[j]:null;var n=null;if(o&&m){if(I){if(m.shouldRender()){var v=t._getVisibleColumns();for(var i=0;i<v.length;i++){if(v[i]===m){n=o.getCells()[i];break;}}}}else{n=o.getCells()[j];}if(n&&n.data("sap-ui-colid")!=m.getId()){var p=o.getCells();for(var i=0;i<p.length;i++){if(p[i].data("sap-ui-colid")===m.getId()){n=p[i];break;}}}}return{row:o,column:m,cell:n};},getCell:function(t,E){if(t==null||E==null){return null;}var $=q(E);var j;var o=t.getDomRef();var k=[".sapUiTableTd",".sapUiTableCol",".sapUiTableRowHdr",".sapUiTableRowAction",".sapUiTableColRowHdr"];var s;for(var i=0;i<k.length;i++){s=k[i];j=$.closest(s,o);if(j.length>0){return j;}}return null;},getParentCell:function(t,E){var $=q(E);var i=h.getCell(t,E);if(i===null||i[0]===$[0]){return null;}else{return i;}},registerResizeHandler:function(t,i,H,r){var o;if(typeof i=="string"){o=t.getDomRef(i);}else{q.sap.log.error("sIdSuffix must be a string",t);return;}if(typeof H!=="function"){q.sap.log.error("fnHandler must be a function",t);return;}h.deregisterResizeHandler(t,i);if(!t._mResizeHandlerIds){t._mResizeHandlerIds={};}if(r&&o){o=o.parentNode;}if(o){t._mResizeHandlerIds[i]=R.register(o,H);}return t._mResizeHandlerIds[i];},deregisterResizeHandler:function(t,I){var j;if(!t._mResizeHandlerIds){return;}if(typeof I=="string"){j=[I];}else if(I===undefined){j=[];for(var k in t._mResizeHandlerIds){if(typeof k=="string"&&t._mResizeHandlerIds.hasOwnProperty(k)){j.push(k);}}}else if(q.isArray(I)){j=I;}for(var i=0;i<j.length;i++){var s=j[i];if(t._mResizeHandlerIds[s]){R.deregister(t._mResizeHandlerIds[s]);t._mResizeHandlerIds[s]=undefined;}}},isFirstScrollableRow:function(t,r){if(isNaN(r)){var $=q(r);r=parseInt($.add($.parent()).filter("[data-sap-ui-rowindex]").data("sap-ui-rowindex"),10);}var F=t.getFixedRowCount()||0;return r==F;},isLastScrollableRow:function(t,r){if(isNaN(r)){var $=q(r);r=parseInt($.add($.parent()).filter("[data-sap-ui-rowindex]").data("sap-ui-rowindex"),10);}var F=t.getFixedBottomRowCount()||0;return r==t.getVisibleRowCount()-F-1;},getContentDensity:function(o){var s;var j=["sapUiSizeCompact","sapUiSizeCondensed","sapUiSizeCozy"];var G=function(F,O){if(!O[F]){return;}for(var i=0;i<j.length;i++){if(O[F](j[i])){return j[i];}}};var $=o.$();if($.length>0){s=G("hasClass",$);}else{s=G("hasStyleClass",o);}if(s){return s;}var p=null;var P=o.getParent();if(P){do{s=G("hasStyleClass",P);if(s){return s;}if(P.getDomRef){p=P.getDomRef();}else if(P.getRootNode){p=P.getRootNode();}if(!p&&P.getParent){P=P.getParent();}else{P=null;}}while(P&&!p);}$=q(p||document.body);s=G("hasClass",$.closest("."+j.join(",.")));return s;},sanitizeSelectionMode:function(t,s){if(s===e.Multi){s=e.MultiToggle;q.sap.log.warning("The selection mode 'Multi' is deprecated and must not be used anymore. Your setting was defaulted to selection mode 'MultiToggle'");}return s;},isVariableWidth:function(w){return!w||w=="auto"||w.toString().match(/%$/);},getFirstFixedButtomRowIndex:function(t){var F=t.getFixedBottomRowCount();var B=t.getBinding("rows");var i=-1;if(B&&F>0){var v=t.getVisibleRowCount();var j=t.getFirstVisibleRow();if(t._iBindingLength>=v){i=v-F;}else{var I=t._iBindingLength-F-j;if(I>=0&&(j+I)<t._iBindingLength){i=I;}}}return i;}};T.TableUtils=h;b.TableUtils=h;d.TableUtils=h;return h;},true);
sap.ui.predefine('sap/ui/table/TreeTable',['jquery.sap.global','./Table','sap/ui/model/odata/ODataTreeBindingAdapter','sap/ui/model/ClientTreeBindingAdapter','sap/ui/model/TreeBindingCompatibilityAdapter','./library','sap/ui/core/Element','./TableUtils'],function(q,T,O,C,a,l,E,b){"use strict";
var c=T.extend("sap.ui.table.TreeTable",{
metadata:{library:"sap.ui.table",properties:{expandFirstLevel:{type:"boolean",defaultValue:false,deprecated:true},useGroupMode:{type:"boolean",group:"Appearance",defaultValue:false},groupHeaderProperty:{type:"string",group:"Data",defaultValue:null},collapseRecursive:{type:"boolean",defaultValue:true},rootLevel:{type:"int",group:"Data",defaultValue:0}},events:{toggleOpenState:{parameters:{rowIndex:{type:"int"},rowContext:{type:"object"},expanded:{type:"boolean"}}}}},
renderer:"sap.ui.table.TableRenderer"
});
c.prototype.init=function(){T.prototype.init.apply(this,arguments);b.Grouping.setTreeMode(this);};
c.prototype.bindRows=function(B){B=T._getSanitizedBindingInfo(arguments);if(B!=null){if(B.parameters==null){B.parameters={};}B.parameters.rootLevel=this.getRootLevel();B.parameters.collapseRecursive=this.getCollapseRecursive();B.parameters.numberOfExpandedLevels=B.parameters.numberOfExpandedLevels||(this.getExpandFirstLevel()?1:0);}return T.prototype.bindRows.call(this,B);};
c.prototype._bindAggregation=function(n,B){T.prototype._bindAggregation.call(this,n,B);var o=this.getBinding("rows");if(n==="rows"&&o!=null){o.attachEvents({selectionChanged:this._onSelectionChanged.bind(this)});}};
c.prototype.setSelectionMode=function(s){var B=this.getBinding("rows");if(B&&B.clearSelection){B.clearSelection();s=b.sanitizeSelectionMode(this,s);this.setProperty("selectionMode",s);}else{T.prototype.setSelectionMode.call(this,s);}return this;};
c.prototype.setFixedRowCount=function(r){q.sap.log.warning("TreeTable: the property \"fixedRowCount\" is not supported and will be ignored!");return this;};
c.prototype.isTreeBinding=function(n){n=n||"rows";if(n==="rows"){return true;}return E.prototype.isTreeBinding.apply(this,arguments);};
c.prototype.getBinding=function(n){n=n||"rows";var B=E.prototype.getBinding.call(this,n);if(B&&n==="rows"&&!B.getLength){if(b.isInstanceOf(B,"sap/ui/model/odata/ODataTreeBinding")){a(B,this);}else if(b.isInstanceOf(B,"sap/ui/model/odata/v2/ODataTreeBinding")){B.applyAdapterInterface();}else if(b.isInstanceOf(B,"sap/ui/model/ClientTreeBinding")){C.apply(B);}else{q.sap.log.error("Binding not supported by sap.ui.table.TreeTable");}}return B;};
c.prototype._getContexts=function(s,L,t){var B=this.getBinding("rows");if(B){return B.getNodes(s,L,t);}else{return[];}};
c.prototype._onGroupHeaderChanged=function(r,e){this.fireToggleOpenState({rowIndex:r,rowContext:this.getContextByIndex(r),expanded:e});};
c.prototype.expand=function(r){var B=this.getBinding("rows");if(B&&r>=0){B.expand(r);}return this;};
c.prototype.collapse=function(r){var B=this.getBinding("rows");if(B&&r>=0){B.collapse(r);}return this;};
c.prototype.collapseAll=function(){var B=this.getBinding("rows");if(B){B.collapseToLevel(0);this.setFirstVisibleRow(0);}return this;};
c.prototype.expandToLevel=function(L){var B=this.getBinding("rows");if(B&&B.expandToLevel){B.expandToLevel(L);}return this;};
c.prototype.isExpanded=function(r){var B=this.getBinding("rows");if(B){return B.isExpanded(r);}return false;};
c.prototype.isIndexSelected=function(r){var B=this.getBinding("rows");if(B&&B.isIndexSelected){return B.isIndexSelected(r);}else{return T.prototype.isIndexSelected.call(this,r);}};
c.prototype.setSelectedIndex=function(r){if(r===-1){this.clearSelection();}var B=this.getBinding("rows");if(B&&B.findNode&&B.setNodeSelection){B.setSelectedIndex(r);}else{T.prototype.setSelectedIndex.call(this,r);}return this;};
c.prototype.getSelectedIndices=function(){var B=this.getBinding("rows");if(B&&B.findNode&&B.getSelectedIndices){return B.getSelectedIndices();}else{return T.prototype.getSelectedIndices.call(this);}};
c.prototype.setSelectionInterval=function(f,t){var s=this.getSelectionMode();if(s===l.SelectionMode.None){return this;}var B=this.getBinding("rows");if(B&&B.findNode&&B.setSelectionInterval){if(s===l.SelectionMode.Single){B.setSelectionInterval(f,f);}else{B.setSelectionInterval(f,t);}}else{T.prototype.setSelectionInterval.call(this,f,t);}return this;};
c.prototype.addSelectionInterval=function(f,t){var s=this.getSelectionMode();if(s===l.SelectionMode.None){return this;}var B=this.getBinding("rows");if(B&&B.findNode&&B.addSelectionInterval){if(s===l.SelectionMode.Single){B.setSelectionInterval(f,f);}else{B.addSelectionInterval(f,t);}}else{T.prototype.addSelectionInterval.call(this,f,t);}return this;};
c.prototype.removeSelectionInterval=function(f,t){var B=this.getBinding("rows");if(B&&B.findNode&&B.removeSelectionInterval){B.removeSelectionInterval(f,t);}else{T.prototype.removeSelectionInterval.call(this,f,t);}return this;};
c.prototype.selectAll=function(){if(!b.hasSelectAll(this)){return this;}var B=this.getBinding("rows");if(B&&B.selectAll){B.selectAll();}else{T.prototype.selectAll.call(this);}return this;};
c.prototype.getSelectedIndex=function(){var B=this.getBinding("rows");if(B&&B.findNode){return B.getSelectedIndex();}else{return T.prototype.getSelectedIndex.call(this);}};
c.prototype.clearSelection=function(){var B=this.getBinding("rows");if(B&&B.clearSelection){B.clearSelection();}else{T.prototype.clearSelection.call(this);}return this;};
c.prototype.getContextByIndex=function(r){var B=this.getBinding("rows");if(B){return B.getContextByIndex(r);}};
c.prototype.setRootLevel=function(r){this.setFirstVisibleRow(0);var B=this.getBinding("rows");if(B){if(B.setRootLevel){B.setRootLevel(r);}}this.setProperty("rootLevel",r,true);return this;};
c.prototype.setCollapseRecursive=function(d){var B=this.getBinding("rows");if(B){if(B.setCollapseRecursive){B.setCollapseRecursive(d);}}this.setProperty("collapseRecursive",!!d,true);return this;};
c.prototype._getSelectedIndicesCount=function(){var s;var B=this.getBinding("rows");if(B&&B.getSelectedNodesCount){return B.getSelectedNodesCount();}else{return T.prototype.getSelectedIndices.call(this);}return s;};
c.prototype.setUseGroupMode=function(g){this.setProperty("useGroupMode",!!g);if(!!g){b.Grouping.setGroupMode(this);}else{b.Grouping.setTreeMode(this);}return this;};
c.prototype.setEnableGrouping=function(){q.sap.log.warning("The property enableGrouping is not supported by the sap.ui.table.TreeTable control");return this;};
c.prototype.setGroupBy=function(){q.sap.log.warning("The groupBy association is not supported by the sap.ui.table.TreeTable control");return this;};
c.prototype.setUseFlatMode=function(f){f=!!f;if(f!=this._bFlatMode){this._bFlatMode=f;if(this.getDomRef()&&b.Grouping.isTreeMode(this)){this.invalidate();}}return this;};
return c;});
sap.ui.predefine('sap/ui/table/TreeTableRenderer',['sap/ui/table/TreeTable'],function(T){"use strict";return T.getMetadata().getRenderer();},true);
sap.ui.predefine('sap/ui/table/library',['jquery.sap.global','sap/ui/core/Core','sap/ui/model/TreeAutoExpandMode','sap/ui/core/library','sap/ui/unified/library'],function(q,C,T){"use strict";sap.ui.getCore().initLibrary({name:"sap.ui.table",version:"1.50.5",dependencies:["sap.ui.core","sap.ui.unified"],types:["sap.ui.table.NavigationMode","sap.ui.table.RowActionType","sap.ui.table.SelectionBehavior","sap.ui.table.SelectionMode","sap.ui.table.SortOrder","sap.ui.table.VisibleRowCountMode","sap.ui.table.SharedDomRef","sap.ui.table.TreeAutoExpandMode"],interfaces:[],controls:["sap.ui.table.AnalyticalColumnMenu","sap.ui.table.AnalyticalTable","sap.ui.table.ColumnMenu","sap.ui.table.Table","sap.ui.table.TreeTable","sap.ui.table.RowAction"],elements:["sap.ui.table.AnalyticalColumn","sap.ui.table.Column","sap.ui.table.Row","sap.ui.table.RowActionItem","sap.ui.table.RowSettings"],extensions:{flChangeHandlers:{"sap.ui.table.Column":{"propertyChange":"default"},"sap.ui.table.Table":{"moveElements":"default"},"sap.ui.table.AnalyticalTable":{"moveElements":"default"}}}});var t=sap.ui.table;t.NavigationMode={Scrollbar:"Scrollbar",Paginator:"Paginator"};t.RowActionType={Custom:"Custom",Navigation:"Navigation",Delete:"Delete"};t.SelectionBehavior={Row:"Row",RowSelector:"RowSelector",RowOnly:"RowOnly"};t.SelectionMode={MultiToggle:"MultiToggle",Multi:"Multi",Single:"Single",None:"None"};t.SortOrder={Ascending:"Ascending",Descending:"Descending"};t.VisibleRowCountMode={Fixed:"Fixed",Interactive:"Interactive",Auto:"Auto"};t.SharedDomRef={HorizontalScrollBar:"hsb",VerticalScrollBar:"vsb"};t.GroupEventType={group:"group",ungroup:"ungroup",ungroupAll:"ungroupAll",moveUp:"moveUp",moveDown:"moveDown",showGroupedColumn:"showGroupedColumn",hideGroupedColumn:"hideGroupedColumn"};t.ColumnHeader=t.Column;t.TreeAutoExpandMode=T;if(!t.TableHelper){t.TableHelper={addTableClass:function(){return"";},createLabel:function(c){throw new Error("no Label control available!");},createTextView:function(c){throw new Error("no TextView control available!");},bFinal:false};}return t;});
jQuery.sap.registerPreloadedModules({
"name":"sap/ui/table/library-preload",
"version":"2.0",
"modules":{
	"sap/ui/table/manifest.json":'{\n  "_version": "1.2.0",\n  "sap.app": {\n    "_version": "1.2.0",\n    "id": "sap.ui.table",\n    "type": "library",\n    "embeds": [],\n    "applicationVersion": {\n      "version": "1.50.5"\n    },\n    "title": "Table-like controls, mainly for desktop scenarios.",\n    "description": "Table-like controls, mainly for desktop scenarios.",\n    "ach": "CA-UI5-TBL",\n    "resources": "resources.json",\n    "offline": true\n  },\n  "sap.ui": {\n    "_version": "1.1.0",\n    "technology": "UI5",\n    "supportedThemes": [\n      "base",\n      "sap_hcb"\n    ]\n  },\n  "sap.ui5": {\n    "_version": "1.1.0",\n    "dependencies": {\n      "minUI5Version": "1.50",\n      "libs": {\n        "sap.ui.core": {\n          "minVersion": "1.50.5"\n        },\n        "sap.ui.unified": {\n          "minVersion": "1.50.5"\n        }\n      }\n    }\n  }\n}'
}});
//# sourceMappingURL=library-preload.js.map