/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/core/delegate/ItemNavigation','sap/ui/model/type/Date','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/calendar/Month','sap/ui/unified/library'],function(q,C,L,I,D,a,b,M,l){"use strict";var c=M.extend("sap.ui.unified.calendar.DatesRow",{metadata:{library:"sap.ui.unified",properties:{startDate:{type:"object",group:"Data"},days:{type:"int",group:"Appearance",defaultValue:7},showDayNamesLine:{type:"boolean",group:"Appearance",defaultValue:true}}}});c.prototype.init=function(){M.prototype.init.apply(this,arguments);this._iColumns=1;};c.prototype.setStartDate=function(s){a._checkJSDateObject(s);var y=s.getFullYear();a._checkYearInValidRange(y);this.setProperty("startDate",s,true);this._oStartDate=b.fromLocalJSDate(s,this.getPrimaryCalendarType());if(this.getDomRef()){var o=this._getDate().toLocalJSDate();this._bNoRangeCheck=true;this.displayDate(s);this._bNoRangeCheck=false;if(o&&this.checkDateFocusable(o)){this.displayDate(o);}}return this;};c.prototype._getStartDate=function(){if(!this._oStartDate){this._oStartDate=b.fromLocalJSDate(new Date(),this.getPrimaryCalendarType());}return this._oStartDate;};c.prototype.setDate=function(d){if(!this._bNoRangeCheck&&!this.checkDateFocusable(d)){throw new Error("Date must be in visible date range; "+this);}M.prototype.setDate.apply(this,arguments);return this;};c.prototype.displayDate=function(d){if(!this._bNoRangeCheck&&!this.checkDateFocusable(d)){throw new Error("Date must be in visible date range; "+this);}M.prototype.displayDate.apply(this,arguments);return this;};c.prototype.setPrimaryCalendarType=function(s){M.prototype.setPrimaryCalendarType.apply(this,arguments);if(this._oStartDate){this._oStartDate=new b(this._oStartDate,s);}return this;};c.prototype.setFirstDayOfWeek=function(f){if(f==-1){return this.setProperty("firstDayOfWeek",f,false);}else{throw new Error("Property firstDayOfWeek not supported "+this);}};c.prototype._handleBorderReached=function(o){var e=o.getParameter("event");var d=this.getDays();var O=this._getDate();var f=new b(O,this.getPrimaryCalendarType());if(e.type){switch(e.type){case"sapnext":case"sapnextmodifiers":f.setDate(f.getDate()+1);break;case"sapprevious":case"sappreviousmodifiers":f.setDate(f.getDate()-1);break;case"sappagedown":f.setDate(f.getDate()+d);break;case"sappageup":f.setDate(f.getDate()-d);break;default:break;}this.fireFocus({date:f.toLocalJSDate(),otherMonth:true,_outsideBorder:true});}};c.prototype.checkDateFocusable=function(d){a._checkJSDateObject(d);if(this._bNoRangeCheck){return false;}var s=this._getStartDate();var e=new b(s,this.getPrimaryCalendarType());e.setDate(e.getDate()+this.getDays());var o=b.fromLocalJSDate(d,this.getPrimaryCalendarType());return o.isSameOrAfter(s)&&o.isBefore(e);};c.prototype._renderHeader=function(){var s=this._getStartDate();var S=s.getDay();var o=this._getLocaleData();var w=this.$("Names").children();var W=[];if(this._bLongWeekDays||!this._bNamesLengthChecked){W=o.getDaysStandAlone("abbreviated");}else{W=o.getDaysStandAlone("narrow");}var d=o.getDaysStandAlone("wide");var i=0;for(i=0;i<w.length;i++){var $=q(w[i]);$.text(W[(i+S)%7]);$.attr("aria-label",d[(i+S)%7]);}if(this._getShowHeader()){var e=this.$("Head");if(e.length>0){var r=sap.ui.getCore().createRenderManager();this.getRenderer().renderHeaderLine(r,this,o,s);r.flush(e[0]);r.destroy();}}};c.prototype._getFirstWeekDay=function(){return this._getStartDate().getDay();};return c;},true);
