/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/core/ResizeHandler","sap/ui/core/Control","sap/ui/core/CustomData","sap/ui/Device","sap/ui/core/delegate/ScrollEnablement","./ObjectPageSection","./ObjectPageSubSection","./LazyLoading","./ObjectPageLayoutABHelper","./ThrottledTaskHelper","sap/ui/core/ScrollBar","sap/ui/core/library","./library"],function(q,R,C,a,D,S,O,b,L,A,T,c,d,l){"use strict";var e=d.TitleLevel;var f=l.ObjectPageSubSectionLayout;var g=C.extend("sap.uxap.ObjectPageLayout",{metadata:{library:"sap.uxap",properties:{showAnchorBar:{type:"boolean",defaultValue:true},showAnchorBarPopover:{type:"boolean",defaultValue:true},upperCaseAnchorBar:{type:"boolean",defaultValue:true},height:{type:"sap.ui.core.CSSSize",defaultValue:"100%"},enableLazyLoading:{type:"boolean",defaultValue:false},subSectionLayout:{type:"sap.uxap.ObjectPageSubSectionLayout",defaultValue:f.TitleOnTop},sectionTitleLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:sap.ui.core.TitleLevel.Auto},useIconTabBar:{type:"boolean",group:"Misc",defaultValue:false},showHeaderContent:{type:"boolean",group:"Misc",defaultValue:true},useTwoColumnsForLargeScreen:{type:"boolean",group:"Appearance",defaultValue:false},showTitleInHeaderContent:{type:"boolean",group:"Appearance",defaultValue:false},showOnlyHighImportance:{type:"boolean",group:"Behavior",defaultValue:false},isChildPage:{type:"boolean",group:"Appearance",defaultValue:false},alwaysShowContentHeader:{type:"boolean",group:"Behavior",defaultValue:false},showEditHeaderButton:{type:"boolean",group:"Behavior",defaultValue:false},flexEnabled:{type:"boolean",group:"Misc",defaultValue:false},showFooter:{type:"boolean",group:"Behavior",defaultValue:false}},associations:{selectedSection:{type:"sap.uxap.ObjectPageSection",multiple:false}},defaultAggregation:"sections",aggregations:{sections:{type:"sap.uxap.ObjectPageSection",multiple:true,singularName:"section"},headerTitle:{type:"sap.uxap.ObjectPageHeader",multiple:false},headerContent:{type:"sap.ui.core.Control",multiple:true,singularName:"headerContent"},footer:{type:"sap.m.IBar",multiple:false},_anchorBar:{type:"sap.uxap.AnchorBar",multiple:false,visibility:"hidden"},_iconTabBar:{type:"sap.m.IconTabBar",multiple:false,visibility:"hidden"},_headerContent:{type:"sap.uxap.ObjectPageHeaderContent",multiple:false,visibility:"hidden"},_customScrollBar:{type:"sap.ui.core.ScrollBar",multiple:false,visibility:"hidden"}},events:{toggleAnchorBar:{parameters:{fixed:{type:"boolean"}}},editHeaderButtonPress:{},navigate:{parameters:{section:{type:"sap.uxap.ObjectPageSection"}}}},designTime:true}});g.HEADER_CALC_DELAY=350;g.DOM_CALC_DELAY=200;g.FOOTER_ANIMATION_DURATION=350;g.TITLE_LEVEL_AS_ARRAY=Object.keys(e);g._getNextTitleLevelEntry=function(t){var i=g.TITLE_LEVEL_AS_ARRAY.indexOf(t),j=i!==-1,H=j&&(i!==g.TITLE_LEVEL_AS_ARRAY.length-1);if(!j){return e.Auto;}return g.TITLE_LEVEL_AS_ARRAY[H?i+1:i];};g.prototype.init=function(){this.oCore=sap.ui.getCore();this._bFirstRendering=true;this._bDomReady=false;this._bStickyAnchorBar=false;this._iStoredScrollPosition=0;this._bInternalAnchorBarVisible=true;this._$opWrapper=[];this._$anchorBar=[];this._$headerTitle=[];this._$stickyAnchorBar=[];this._$headerContent=[];this._$stickyHeaderContent=[];this._bMobileScenario=false;this._oSectionInfo={};this._aSectionBases=[];this._sScrolledSectionId="";this._iScrollToSectionDuration=600;this._$spacer=[];this.iHeaderContentHeight=0;this.iStickyHeaderContentHeight=0;this.iHeaderTitleHeight=0;this.iHeaderTitleHeightStickied=0;this.iAnchorBarHeight=0;this.iTotalHeaderSize=0;this._iREMSize=parseInt(q("body").css("font-size"),10);this._iOffset=parseInt(0.25*this._iREMSize,10);this._iResizeId=R.register(this,this._onUpdateScreenSize.bind(this));this._iAfterRenderingDomReadyTimeout=null;this._oABHelper=new A(this);this._bSuppressLayoutCalculations=false;};g.prototype.onBeforeRendering=function(){this._oLazyLoading=new L(this);if(!this.getVisible()){return;}this._bMobileScenario=l.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange());this._bTabletScenario=l.Utilities.isTabletScenario(this._getCurrentMediaContainerRange());this._bHContentAlwaysExpanded=this._checkAlwaysShowContentHeader();this._initializeScroller();this._getHeaderContent().setContentDesign(this._getHeaderDesign());this._oABHelper._getAnchorBar().setProperty("upperCase",this.getUpperCaseAnchorBar(),true);this._storeScrollLocation();this._applyUxRules();this._getCustomScrollBar().setScrollPosition(0);if(!q.isEmptyObject(this._oSectionInfo)&&this._bFirstRendering){this._preloadSectionsOnBeforeFirstRendering();this._bFirstRendering=false;}this._bStickyAnchorBar=false;this._handleExpandButtonPressEventLifeCycle(false);};g.prototype._handleExpandButtonPressEventLifeCycle=function(i){var H=this.getHeaderTitle(),E;if(H){E=H.getAggregation("_expandButton");if(E){E[i?"attachPress":"detachPress"](this._handleExpandButtonPress,this);}}};g.prototype._adjustSelectedSectionByUXRules=function(){var s=this.oCore.byId(this.getSelectedSection()),v=s&&this._sectionCanBeRenderedByUXRules(s);if(!v){if(this._oFirstVisibleSection){s=this._oFirstVisibleSection;this.setAssociation("selectedSection",s.getId(),true);}else{this.setAssociation("selectedSection",null,true);return;}}var o=this.oCore.byId(this._sStoredScrolledSubSectionId),V=o&&this._sectionCanBeRenderedByUXRules(o)&&(s.indexOfSubSection(o)>=0);if(!V){this._sStoredScrolledSubSectionId=null;}};g.prototype._sectionCanBeRenderedByUXRules=function(s){if(!s||!s.getVisible()||!s._getInternalVisible()){return false;}var i=this._aSectionBases.map(function(o){return o.getId();});return(i.indexOf(s.getId())>-1);};g.prototype._getSectionsToRender=function(){this._adjustSelectedSectionByUXRules();var s=this.oCore.byId(this.getSelectedSection());if(this.getUseIconTabBar()&&s){return[s];}else{return this.getSections();}};g.prototype._preloadSectionsOnBeforeFirstRendering=function(){var t;if(!this.getEnableLazyLoading()){t=this._getSectionsToRender();}else{var s=this.getUseIconTabBar()?this._grepCurrentTabSectionBases():this._aSectionBases;t=this._oLazyLoading.getSubsectionsToPreload(s);}this._connectModelsForSections(t);};g.prototype._grepCurrentTabSectionBases=function(){var F=[],s;this._adjustSelectedSectionByUXRules();s=this.oCore.byId(this.getSelectedSection());if(s){var i=s.getId();this._aSectionBases.forEach(function(o){if(o.getParent().getId()===i){F.push(o);}});}return F;};g.prototype.onAfterRendering=function(){this._ensureCorrectParentHeight();this._cacheDomElements();this._$opWrapper.on("scroll",this._onScroll.bind(this));if(this._bDomReady&&this.$().parents(":hidden").length===0){this._onAfterRenderingDomReady();}else{this._iAfterRenderingDomReadyTimeout=q.sap.delayedCall(g.HEADER_CALC_DELAY,this,this._onAfterRenderingDomReady);}this._handleExpandButtonPressEventLifeCycle(true);};g.prototype._onAfterRenderingDomReady=function(){var s,o;if(this._bIsBeingDestroyed){return;}this._adjustSelectedSectionByUXRules();s=this.getSelectedSection();o=this.oCore.byId(s);this._iAfterRenderingDomReadyTimeout=null;this._bDomReady=true;this._adjustHeaderHeights();this._initAnchorBarScroll();if(s){if(this.getUseIconTabBar()){this._setSelectedSectionId(s);this._setCurrentTabSection(o);}else{this.scrollToSection(s,0);}}if(sap.ui.Device.system.desktop){this._$opWrapper.on("scroll",this.onWrapperScroll.bind(this));}this._registerOnContentResize();this.getHeaderTitle()&&this.getHeaderTitle()._shiftHeaderTitle();this.getFooter()&&this._shiftFooter();this._setSectionsFocusValues();this._restoreScrollPosition();this.oCore.getEventBus().publish("sap.ui","ControlForPersonalizationRendered",this);this.fireEvent("onAfterRenderingDOMReady");};g.prototype._shiftFooter=function(){var $=this.$("footerWrapper"),s=this._calculateShiftOffset();$.css(s.sStyleAttribute,s.iMarginalsOffset+"px");};g.prototype._calculateShiftOffset=function(){var H=0,s=this.oCore.getConfiguration().getRTL()?"left":"right",i=this._hasVerticalScrollBar(),j=this._iOffset,k;if(sap.ui.Device.system.desktop){k=q.sap.scrollbarSize().width;H=k;if(!i){H=0;j+=k;}}return{"sStyleAttribute":s,"iActionsOffset":j,"iMarginalsOffset":H};};g.prototype.exit=function(){if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this._iResizeId){R.deregister(this._iResizeId);}if(this._iContentResizeId){R.deregister(this._iContentResizeId);}if(this._iAfterRenderingDomReadyTimeout){clearTimeout(this._iAfterRenderingDomReadyTimeout);}this._oFirstVisibleSection=null;};g.prototype._getCustomScrollBar=function(){if(!this.getAggregation("_customScrollBar")){var v=new c(this.getId()+"-vertSB",{vertical:true,size:"100%",scrollPosition:0,scroll:this.onCustomScrollerScroll.bind(this)});this.setAggregation("_customScrollBar",v,true);}return this.getAggregation("_customScrollBar");};g.prototype.onWrapperScroll=function(E){var s=Math.max(E.target.scrollTop,0);if(this._getCustomScrollBar()){if(this.allowCustomScroll===true){this.allowCustomScroll=false;return;}this.allowInnerDiv=true;this._getCustomScrollBar().setScrollPosition(s);}};g.prototype.onCustomScrollerScroll=function(E){var s=Math.max(this._getCustomScrollBar().getScrollPosition(),0);if(this.allowInnerDiv===true){this.allowInnerDiv=false;return;}this.allowCustomScroll=true;q(this._$opWrapper).scrollTop(s);};g.prototype.setShowOnlyHighImportance=function(v){var o=this.getShowOnlyHighImportance();if(o!==v){this.setProperty("showOnlyHighImportance",v,true);this.getSections().forEach(function(s){s._updateImportance();});}return this;};g.prototype.setIsHeaderContentAlwaysExpanded=function(v){var o=this.getAlwaysShowContentHeader();var s=(D.system.phone||D.system.tablet);if(o!==v){this.setProperty("alwaysShowContentHeader",v,s);}return this;};g.prototype._initializeScroller=function(){if(this._oScroller){return;}this._oScroller=new S(this,this.getId()+"-scroll",{horizontal:false,vertical:true});};g.prototype.setSelectedSection=function(s){var i;if(s instanceof O){i=s.getId();}else if(typeof s==="string"){i=s;}if(!i){("section or sectionID expected");return;}if(i===this.getSelectedSection()){return this;}this.scrollToSection(i);return this.setAssociation("selectedSection",i,true);};g.prototype._ensureCorrectParentHeight=function(){if(this._bCorrectParentHeightIsSet){return;}if(this.getParent().getHeight&&["","auto"].indexOf(this.getParent().getHeight())!==-1){this.$().parent().css("height","100%");}this._bCorrectParentHeightIsSet=true;};g.prototype._cacheDomElements=function(){this._$headerTitle=q.sap.byId(this.getId()+"-headerTitle");this._$anchorBar=q.sap.byId(this.getId()+"-anchorBar");this._$stickyAnchorBar=q.sap.byId(this.getId()+"-stickyAnchorBar");this._$opWrapper=q.sap.byId(this.getId()+"-opwrapper");this._$spacer=q.sap.byId(this.getId()+"-spacer");this._$headerContent=q.sap.byId(this.getId()+"-headerContent");this._$stickyHeaderContent=q.sap.byId(this.getId()+"-stickyHeaderContent");this._$contentContainer=q.sap.byId(this.getId()+"-scroll");this._$sectionsContainer=q.sap.byId(this.getId()+"-sectionsContainer");this._bDomElementsCached=true;};g.prototype._handleExpandButtonPress=function(E){this._expandCollapseHeader(true);};g.prototype._toggleStickyHeader=function(E){this._bIsHeaderExpanded=E;this._$headerTitle.toggleClass("sapUxAPObjectPageHeaderStickied",!E);};g.prototype._expandCollapseHeader=function(E){if(this._bHContentAlwaysExpanded){return;}if(E&&this._bStickyAnchorBar){this._$headerContent.css("height",this.iHeaderContentHeight).children().appendTo(this._$stickyHeaderContent);this._toggleStickyHeader(E);}else if(!E&&this._bIsHeaderExpanded){this._$headerContent.css("height","auto").append(this._$stickyHeaderContent.children());this._$stickyHeaderContent.children().remove();this._toggleStickyHeader(E);}};g.prototype._updateNavigation=function(){if(this.getShowAnchorBar()){this._oABHelper._buildAnchorBar();}};g.prototype._applyUxRules=function(i){var s,j,v,V,k,m,n,F,o;s=this.getSections()||[];V=0;m=this.getShowAnchorBar();n=this.getUseIconTabBar();F=null;this._cleanMemory();s.forEach(function(p){if(!p.getVisible()){return true;}this._registerSectionBaseInfo(p);j=p.getSubSections()||[];v=0;o=null;j.forEach(function(r){if(!r.getVisible()){return true;}this._registerSectionBaseInfo(r);k=r.getVisibleBlocksCount();if(k===0){r._setInternalVisible(false,i);q.sap.log.info("ObjectPageLayout :: noVisibleBlock UX rule matched","subSection "+r.getTitle()+" forced to hidden");}else{r._setInternalVisible(true,i);r._setInternalTitleVisible(true,i);v++;if(!o){o=r;}if(this._shouldApplySectionTitleLevel(r)){r._setInternalTitleLevel(this._determineSectionBaseInternalTitleLevel(r));}}},this);if(v==0){p._setInternalVisible(false,i);q.sap.log.info("ObjectPageLayout :: noVisibleSubSection UX rule matched","section "+p.getTitle()+" forced to hidden");}else{p._setInternalVisible(true,i);p._setInternalTitleVisible(true,i);if(!F){F=p;}if(this.getSubSectionLayout()===f.TitleOnTop&&v===1&&o.getTitle().trim()!==""){q.sap.log.info("ObjectPageLayout :: TitleOnTop.sectionGetSingleSubSectionTitle UX rule matched","section "+p.getTitle()+" is taking its single subsection title "+o.getTitle());p._setInternalTitle(o.getTitle(),i);o._setInternalTitleVisible(false,i);}else{p._setInternalTitle("",i);}if(this._shouldApplySectionTitleLevel(p)){p._setInternalTitleLevel(this._determineSectionBaseInternalTitleLevel(p));}V++;}if(n){p._setInternalTitleVisible(false,i);}},this);if(V<=1){m=false;q.sap.log.info("ObjectPageLayout :: notEnoughVisibleSection UX rule matched","anchorBar forced to hidden");}else if(F&&m){F._setInternalTitleVisible(false,i);q.sap.log.info("ObjectPageLayout :: firstSectionTitleHidden UX rule matched","section "+F.getTitle()+" title forced to hidden");}if(m){this._oABHelper._buildAnchorBar();}this._setInternalAnchorBarVisible(m,i);this._oFirstVisibleSection=F;};g.prototype.setUseIconTabBar=function(v){var o=this.getUseIconTabBar();if(v!=o){this._applyUxRules();}this.setProperty("useIconTabBar",v);return this;};g.prototype._setCurrentTabSection=function(s,i){if(!s){return;}var o;if(s instanceof sap.uxap.ObjectPageSubSection){o=s;s=s.getParent();}else{o=this._getFirstVisibleSubSection(s);}if(this._oCurrentTabSection!==s){this._renderSection(s);this._oCurrentTabSection=s;}this._oCurrentTabSubSection=o;};g.prototype._renderSection=function(s){var $=this.$().find(".sapUxAPObjectPageContainer"),r;if(s&&$.length){r=this.oCore.createRenderManager();r.renderControl(s);r.flush($[0]);r.destroy();}};g.prototype.setShowAnchorBarPopover=function(v,s){this._oABHelper._buildAnchorBar();this._oABHelper._getAnchorBar().setShowPopover(v);return this.setProperty("showAnchorBarPopover",v,true);};g.prototype._getInternalAnchorBarVisible=function(){return this._bInternalAnchorBarVisible;};g.prototype._setInternalAnchorBarVisible=function(v,i){if(v!=this._bInternalAnchorBarVisible){this._bInternalAnchorBarVisible=v;if(i===true){this.invalidate();}}};g.prototype.setUpperCaseAnchorBar=function(v){this._oABHelper._getAnchorBar().setProperty("upperCase",v);return this.setProperty("upperCaseAnchorBar",v,true);};g.prototype._requestAdjustLayout=function(E,i,n){if(!this._oLayoutTask){this._oLayoutTask=new T(this._executeAdjustLayout,g.DOM_CALC_DELAY,this);}if(!i){q.sap.log.debug("ObjectPageLayout :: _requestAdjustLayout","delayed by "+g.DOM_CALC_DELAY+" ms because of dom modifications");}return this._oLayoutTask.reSchedule(i,{needLazyLoading:!!n}).catch(function(r){});};g.prototype._executeAdjustLayout=function(o){var n=o.needLazyLoading,s=this._updateScreenHeightSectionBasesAndSpacer();if(s&&n){this._oLazyLoading.doLazyLoading();}return s;};g.prototype._adjustLayoutAndUxRules=function(){if(this._bSuppressLayoutCalculations){return;}var s,o;q.sap.log.debug("ObjectPageLayout :: _requestAdjustLayout","refreshing ux rules");this._applyUxRules(true);this._adjustSelectedSectionByUXRules();s=this.getSelectedSection();o=this.oCore.byId(s);if(o){this._setSelectedSectionId(s);if(this.getUseIconTabBar()){this._setCurrentTabSection(o);}this._requestAdjustLayout(null,false,true).then(function(){this._adjustSelectedSectionByUXRules();s=this.getSelectedSection();if(!this._isClosestScrolledSection(s)){this.scrollToSection(s);}}.bind(this));}};g.prototype._isClosestScrolledSection=function(s){var i=this._$opWrapper.scrollTop(),p=this.iScreenHeight,j=this._getClosestScrolledSectionId(i,p);return j&&(s===j);};g.prototype._suppressLayoutCalculations=function(){this._bSuppressLayoutCalculations=true;};g.prototype._resumeLayoutCalculations=function(){this._bSuppressLayoutCalculations=false;this._adjustLayoutAndUxRules();};g.prototype._setSelectedSectionId=function(s){var o=this.getAggregation("_anchorBar"),i=s&&this._oSectionInfo[s];if(!i){return;}if(o&&i.buttonId){o.setSelectedButton(i.buttonId);this.setAssociation("selectedSection",s,true);}};g.prototype.isFirstRendering=function(){return this._bFirstRendering;};g.prototype._cleanMemory=function(){var o=this.getAggregation("_anchorBar");if(o){o._resetControl();}this._oSectionInfo={};this._aSectionBases=[];};g.prototype._registerSectionBaseInfo=function(s){this._oSectionInfo[s.getId()]={$dom:[],positionTop:0,positionTopMobile:0,buttonId:"",isSection:(s instanceof O),sectionReference:s};this._aSectionBases.push(s);};g.prototype._triggerVisibleSubSectionsEvents=function(){if(this.getEnableLazyLoading()&&this._oLazyLoading){this._oLazyLoading._triggerVisibleSubSectionsEvents();}};g.prototype.scrollToSection=function(i,j,o,I){var s=this.oCore.byId(i);if(!this.getDomRef()){q.sap.log.warning("scrollToSection can only be used after the ObjectPage is rendered",this);return;}if(!s){q.sap.log.warning("scrollToSection aborted: unknown section",i,this);return;}if(!this._oSectionInfo[i]){q.sap.log.warning("scrollToSection aborted: section is hidden by UX rules",i,this);return;}if(this.bIsDestroyed){q.sap.log.debug("ObjectPageLayout :: scrollToSection","scrolling canceled as page is being destroyed");return;}if(this.getUseIconTabBar()){var t=O._getClosestSection(s);if(this._oCurrentTabSection){this._oCurrentTabSection._allowPropagationToLoadedViews(false);}t._allowPropagationToLoadedViews(true);this._setCurrentTabSection(s);this.getAggregation("_anchorBar").setSelectedButton(this._oSectionInfo[t.getId()].buttonId);this.setAssociation("selectedSection",t.getId(),true);}if(I){this.fireNavigate({section:O._getClosestSection(s)});}if(this._bIsHeaderExpanded){this._expandCollapseHeader(false);}o=o||0;s._expandSection();this._requestAdjustLayout(null,true);j=this._computeScrollDuration(j,s);var k=this._computeScrollPosition(s);if(this._sCurrentScrollId!=i){this._sCurrentScrollId=i;if(this._iCurrentScrollTimeout){clearTimeout(this._iCurrentScrollTimeout);if(this._$contentContainer){this._$contentContainer.parent().stop(true,false);}}if(this._bDomElementsCached){this._iCurrentScrollTimeout=q.sap.delayedCall(j,this,function(){this._sCurrentScrollId=undefined;this._iCurrentScrollTimeout=undefined;});}this._preloadSectionsOnScroll(s);this.getHeaderTitle()&&this.getHeaderTitle()._shiftHeaderTitle();this._scrollTo(k+o,j);}};g.prototype._computeScrollDuration=function(i,t){var j=parseInt(i,10);j=j>=0?j:this._iScrollToSectionDuration;if(this.getUseIconTabBar()&&((t instanceof O)||this._isFirstVisibleSectionBase(t))&&this._bStickyAnchorBar){j=0;}return j;};g.prototype._computeScrollPosition=function(t){var F=t&&(t instanceof O),i=t.getId(),s=this._bMobileScenario||F?this._oSectionInfo[i].positionTopMobile:this._oSectionInfo[i].positionTop,E=!this._bStickyAnchorBar;if(E&&this._isFirstVisibleSectionBase(t)){s=0;}return s;};g.prototype._preloadSectionsOnScroll=function(t){var i=t.getId(),j;if(!this.getEnableLazyLoading()&&this.getUseIconTabBar()){j=(t instanceof O)?t:t.getParent();this._connectModelsForSections([j]);}if(this.getEnableLazyLoading()){var s=this.getUseIconTabBar()?this._grepCurrentTabSectionBases():this._aSectionBases;j=this._oLazyLoading.getSubsectionsToPreload(s,i);if(D.system.desktop){q.sap.delayedCall(50,this,function(){this._connectModelsForSections(j);});}else{this._connectModelsForSections(j);}j.forEach(function(k){this.fireEvent("subSectionEnteredViewPort",{subSection:k});},this);}};g.prototype.getScrollingSectionId=function(){return this._sScrolledSectionId;};g.prototype.setDirectScrollingToSection=function(s){this.sDirectSectionId=s;};g.prototype.getDirectScrollingToSection=function(){return this.sDirectSectionId;};g.prototype.clearDirectScrollingToSection=function(){this.sDirectSectionId=null;};g.prototype._scrollTo=function(y,t){if(this._oScroller&&this._bDomReady){q.sap.log.debug("ObjectPageLayout :: scrolling to "+y);if((t===0)&&this._shouldSnapHeaderOnScroll(y)){this._toggleHeader(true);}this._oScroller.scrollTo(0,y,t);}return this;};g.prototype._updateScreenHeightSectionBasesAndSpacer=function(){var i,o,s,p,P,j,$=this.getDomRef();if(!$||!this._bDomReady){return false;}q.sap.log.debug("ObjectPageLayout :: _updateScreenHeightSectionBasesAndSpacer","re-evaluating dom positions");this.iScreenHeight=$.parentElement?$.getBoundingClientRect().height:0;if(this.iScreenHeight===0){return;}var k=0;this._aSectionBases.forEach(function(m){var I=this._oSectionInfo[m.getId()],n=m.$(),r,t=false;if(!I||!n.length){return;}if(!I.isSection){k++;}I.$dom=n;var u=n.position().top;I.positionTop=Math.ceil(u);if(I.isSection){r=m.$("header");}else{r=m.$("headerTitle");}t=r.length===0;if(!t){I.positionTopMobile=Math.ceil(r.position().top)+r.outerHeight();}else{I.positionTopMobile=I.positionTop;}if(!this._bStickyAnchorBar&&!this._bIsHeaderExpanded){I.positionTopMobile-=this.iAnchorBarHeight;I.positionTop-=this.iAnchorBarHeight;}I.sectionReference.toggleStyleClass("sapUxAPObjectPageSubSectionPromoted",t);if(this._bMobileScenario){var v=this.oCore.byId(m.getId()).getParent();if(v instanceof O&&v._getIsHidden()){return;}if(P){this._oSectionInfo[P].positionBottom=I.positionTop;}P=m.getId();o=m;}else{if(I.isSection){if(P){this._oSectionInfo[P].positionBottom=I.positionTop;if(p){this._oSectionInfo[p].positionBottom=I.positionTop;}}P=m.getId();p=null;}else{if(p){this._oSectionInfo[p].positionBottom=I.positionTop;}p=m.getId();o=m;}}},this);if(o){i=this._computeLastVisibleHeight(o);if(this._bMobileScenario&&P){this._oSectionInfo[P].positionBottom=this._oSectionInfo[P].positionTop+i;}else{if(p){this._oSectionInfo[p].positionBottom=this._oSectionInfo[p].positionTop+i;}if(P&&p){this._oSectionInfo[P].positionBottom=this._oSectionInfo[p].positionTop+i;}}j=this._bStickyAnchorBar||(k>1)||this._checkContentBottomRequiresSnap(o);s=this._computeSpacerHeight(o,i,j);this._$spacer.height(s+"px");q.sap.log.debug("ObjectPageLayout :: bottom spacer is now "+s+"px");}this._updateCustomScrollerHeight(j);return true;};g.prototype._updateCustomScrollerHeight=function(r){if(sap.ui.Device.system.desktop&&this.getAggregation("_customScrollBar")){var s=this._computeScrollableContentSize(r);s+=this._getStickyAreaHeight(r);this._getCustomScrollBar().setContentSize(s+"px");var i=(s>this.iScreenHeight),v=(i!==this._getCustomScrollBar().getVisible());if(v){this._getCustomScrollBar().setVisible(i);this.getHeaderTitle()&&this.getHeaderTitle()._shiftHeaderTitle();}}};g.prototype._computeScrollableContentSize=function(s){var i=0;if(this._$contentContainer&&this._$contentContainer.length){i=this._$contentContainer[0].scrollHeight;}if(!this._bStickyAnchorBar&&s){i-=this.iAnchorBarHeight;}if(this._bStickyAnchorBar&&!s){i+=this.iAnchorBarHeight;}return i;};g.prototype._computeLastVisibleHeight=function(o){var i=this._bStickyAnchorBar||this._bIsHeaderExpanded;var j=this._getSectionPositionTop(o,i);return this._$spacer.position().top-j;};g.prototype._getStickyAreaHeight=function(i){if(this._bHContentAlwaysExpanded){return this.iHeaderTitleHeight;}if(i){return this.iHeaderTitleHeightStickied+this.iAnchorBarHeight;}return this.iHeaderTitleHeight;};g.prototype._getScrollableViewportHeight=function(i){var s=this.$().height();return s-this._getStickyAreaHeight(i);};g.prototype._getSectionPositionTop=function(s,i){var p=this._oSectionInfo[s.getId()].positionTop;if(!i){p+=this.iAnchorBarHeight;}return p;};g.prototype._getSectionPositionBottom=function(s,i){var p=this._oSectionInfo[s.getId()].positionBottom;if(!i){p+=this.iAnchorBarHeight;}return p;};g.prototype._determineSectionBaseInternalTitleLevel=function(s){var i=this.getSectionTitleLevel(),I=s instanceof O;if(i===e.Auto){return I?e.H3:e.H4;}return I?i:g._getNextTitleLevelEntry(i);};g.prototype._shouldApplySectionTitleLevel=function(s){return s.getTitleLevel()===e.Auto;};g.prototype._checkContentBottomRequiresSnap=function(s){var i=false;return this._getSectionPositionBottom(s,i)>=(this._getScrollableViewportHeight(i)+this._getSnapPosition());};g.prototype._computeSpacerHeight=function(o,i,s){var j,k,F;if(this.getFooter()&&this.getShowFooter()){F=this.$("footerWrapper").outerHeight();}k=this._getScrollableViewportHeight(s);if(!s){i=this._getSectionPositionBottom(o,false);}if(i<k){j=k-i;if(this._bMobileScenario){j+=(this._oSectionInfo[o.getId()].positionTopMobile-this._oSectionInfo[o.getId()].positionTop);}}else{j=0;}if(F>j){j+=F;}return j;};g.prototype._isFirstVisibleSectionBase=function(s){var o=this._oSectionInfo[s.getId()];if(o){return Math.abs(o.positionTop-this.iHeaderContentHeight)<=1;}return false;};g.prototype._getFirstVisibleSubSection=function(s){if(!s){return;}var F;this._aSectionBases.every(function(o){if(o.getParent()&&(o.getParent().getId()===s.getId())){F=o;return false;}return true;});return F;};g.prototype._initAnchorBarScroll=function(){var s=this.oCore.byId(this.getSelectedSection()),i;this._requestAdjustLayout(null,true);i=s?this._computeScrollPosition(s):0;this._sScrolledSectionId="";this._sCurrentScrollId="";this._onScroll({target:{scrollTop:i}});};g.prototype._setAsCurrentSection=function(s){var o,i,j;if(this._sScrolledSectionId===s){return;}q.sap.log.debug("ObjectPageLayout :: current section is "+s);this._sScrolledSectionId=s;o=this.getAggregation("_anchorBar");if(o&&this._getInternalAnchorBarVisible()){i=this.oCore.byId(s);j=i&&i instanceof b&&(i.getTitle().trim()===""||!i._getInternalTitleVisible()||i.getParent()._getIsHidden());if(j){s=i.getParent().getId();q.sap.log.debug("ObjectPageLayout :: current section is a subSection with an empty or hidden title, selecting parent "+s);}if(this._oSectionInfo[s]){o.setSelectedButton(this._oSectionInfo[s].buttonId);this.setAssociation("selectedSection",s,true);this._setSectionsFocusValues(s);}}};g.prototype._registerOnContentResize=function(){var $=this._$sectionsContainer.length&&this._$sectionsContainer[0];if(!$){return;}if(this._iContentResizeId){R.deregister(this._iContentResizeId);}this._iContentResizeId=R.register($,this._onUpdateContentSize.bind(this));};g.prototype._onUpdateContentSize=function(E){var s,p,i,j;this._requestAdjustLayout().then(function(){s=this._$opWrapper.scrollTop();p=this.iScreenHeight;if(p===0){return;}i=this._getClosestScrolledSectionId(s,p);j=this.getSelectedSection();if(i&&j!==i){this.getAggregation("_anchorBar").setSelectedButton(this._oSectionInfo[i].buttonId);}}.bind(this));};g.prototype._onUpdateScreenSize=function(E){if(!this._bDomReady){q.sap.log.info("ObjectPageLayout :: cannot _onUpdateScreenSize before dom is ready");return;}this._oLazyLoading.setLazyLoadingParameters();q.sap.delayedCall(g.HEADER_CALC_DELAY,this,function(){this._bMobileScenario=l.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange());this._bTabletScenario=l.Utilities.isTabletScenario(this._getCurrentMediaContainerRange());if(this._bHContentAlwaysExpanded!=this._checkAlwaysShowContentHeader()){this.invalidate();}this._adjustHeaderHeights();this._requestAdjustLayout(null,true);if(this.getFooter()&&this.getShowFooter()){this._shiftFooter();}this._scrollTo(this._$opWrapper.scrollTop(),0);});};g.prototype._shouldSnapHeaderOnScroll=function(s){return(s>0)&&(s>=this._getSnapPosition());};g.prototype._onScroll=function(E){var s=Math.max(E.target.scrollTop,0),p,H=this.getHeaderTitle(),i=this._shouldSnapHeaderOnScroll(s),j,k=false;p=this.iScreenHeight;if(p===0){return;}if(i&&!this._bHContentAlwaysExpanded){p-=(this.iAnchorBarHeight+this.iHeaderTitleHeightStickied);}else{if(i&&this._bHContentAlwaysExpanded){p=p-(this._$stickyAnchorBar.height()+this.iHeaderTitleHeight+this.iStickyHeaderContentHeight);}}if(this._bIsHeaderExpanded){this._expandCollapseHeader(false);}if(!this._bHContentAlwaysExpanded&&((H&&this.getShowHeaderContent())||this.getShowAnchorBar())){this._toggleHeader(i);}else if(s==0&&((H&&this.getShowHeaderContent())||this.getShowAnchorBar())){this._toggleHeader(false);}if(!this._bHContentAlwaysExpanded){this._adjustHeaderTitleBackgroundPosition(s);}q.sap.log.debug("ObjectPageLayout :: lazy loading : Scrolling at "+s,"----------------------------------------");j=this._getClosestScrolledSectionId(s,p);if(j){var m=this.getDirectScrollingToSection();if(j!==this._sScrolledSectionId){q.sap.log.debug("ObjectPageLayout :: closest id "+j,"----------------------------------------");var m=this.getDirectScrollingToSection();if(m&&m!==j){return;}this.clearDirectScrollingToSection();this._setAsCurrentSection(j);}else if(j===this.getDirectScrollingToSection()){this.clearDirectScrollingToSection();}}if(this.getEnableLazyLoading()){this._oLazyLoading.lazyLoadDuringScroll(s,E.timeStamp,p);}if(H&&this.getShowHeaderContent()&&this.getShowTitleInHeaderContent()&&H.getShowTitleSelector()){if(s===0){q.sap.byId(this.getId()+"-scroll").css("z-index","1000");k=false;}else if(!k){k=true;q.sap.byId(this.getId()+"-scroll").css("z-index","0");}}};g.prototype._getSnapPosition=function(){return(this.iHeaderContentHeight-(this.iHeaderTitleHeightStickied-this.iHeaderTitleHeight));};g.prototype._getClosestScrolledSectionId=function(s,p,i){if(this.getUseIconTabBar()&&this._oCurrentTabSection){return this._oCurrentTabSection.getId();}var j=s+p,k,t=i||this._bMobileScenario;q.each(this._oSectionInfo,function(I,o){var m=this.oCore.byId(I).getParent(),n=m instanceof O&&m._getIsHidden();if(o.isSection||(t&&!n)){if(!k&&(o.sectionReference._getInternalVisible()===true)){k=I;}if(o.isSection&&!!i){return true;}if(o.positionTop<=j&&s<=o.positionBottom){if(o.positionTop<=s&&o.positionBottom>=s){k=I;return false;}}}}.bind(this));return k;};g.prototype._toggleHeader=function(s){var H=this.getHeaderTitle();if(!this._bHContentAlwaysExpanded&&!this._bIsHeaderExpanded){this._$headerTitle.toggleClass("sapUxAPObjectPageHeaderStickied",s);}if(!this._bStickyAnchorBar&&s){this._restoreFocusAfter(this._convertHeaderToStickied);H&&H._adaptLayout();this._adjustHeaderHeights();}else if(this._bStickyAnchorBar&&!s){this._restoreFocusAfter(this._convertHeaderToExpanded);H&&H._adaptLayout();this._adjustHeaderHeights();}};g.prototype._restoreFocusAfter=function(m){var o=this.oCore.byId(this.oCore.getCurrentFocusedControlId());m.call(this);if(D.system.phone!==true){if(!this.oCore.byId(this.oCore.getCurrentFocusedControlId())){o&&o.$().focus();}}return this;};g.prototype._convertHeaderToStickied=function(){if(!this._bHContentAlwaysExpanded){this._$anchorBar.children().appendTo(this._$stickyAnchorBar);this._toggleHeaderStyleRules(true);if(this.iHeaderTitleHeight!=this.iHeaderTitleHeightStickied){this._adjustHeaderBackgroundSize();}}return this;};g.prototype._convertHeaderToExpanded=function(){if(!this._bHContentAlwaysExpanded){this._$anchorBar.css("height","auto").append(this._$stickyAnchorBar.children());this._toggleHeaderStyleRules(false);}return this;};g.prototype._toggleHeaderStyleRules=function(s){s=!!s;var v=s?"hidden":"inherit";this._bStickyAnchorBar=s;this._$headerContent.css("overflow",v);this._$headerContent.toggleClass("sapContrastPlus",!s);this._$headerContent.toggleClass("sapUxAPObjectPageHeaderDetailsHidden",s);this._$anchorBar.css("visibility",v);this.fireToggleAnchorBar({fixed:s});};g.prototype.getScrollDelegate=function(){return this._oScroller;};g.prototype.setHeaderTitle=function(H,s){if(H&&typeof H.addEventDelegate==="function"){H.addEventDelegate({onAfterRendering:this._adjustHeaderHeights.bind(this)});}return this.setAggregation("headerTitle",H,s);};g.prototype._adjustHeaderBackgroundSize=function(){var H=this.getHeaderTitle();if(H&&H.getHeaderDesign()=="Dark"){if(!this._bHContentAlwaysExpanded){this.iTotalHeaderSize=this.iHeaderTitleHeight+this.iHeaderContentHeight;this._$headerContent.css("background-size","100% "+this.iTotalHeaderSize+"px");}else{this.iTotalHeaderSize=this.iHeaderTitleHeight-this._$stickyAnchorBar.height();this._$stickyHeaderContent.css("background-size","100% "+this.iTotalHeaderSize+"px");}H.$().css("background-size","100% "+this.iTotalHeaderSize+"px");this._adjustHeaderTitleBackgroundPosition(0);}};g.prototype._adjustHeaderTitleBackgroundPosition=function(s){var H=this.getHeaderTitle();if(H&&H.getHeaderDesign()=="Dark"){if(this._bStickyAnchorBar){H.$().css("background-position","0px "+((this.iTotalHeaderSize-this.iHeaderTitleHeightStickied)*-1)+"px");}else{if(this._bHContentAlwaysExpanded){H.$().css("background-position","0px 0px");}else{H.$().css("background-position","0px "+(this.iHeaderTitleHeight+this.iHeaderContentHeight-this.iTotalHeaderSize-s)+"px");}}}};g.prototype._adjustHeaderHeights=function(){if(this._$headerTitle.length>0){var $=this._$headerTitle.clone();this.iHeaderContentHeight=this._$headerContent[0].parentElement?this._$headerContent[0].getBoundingClientRect().height:0;this.iStickyHeaderContentHeight=this._$stickyHeaderContent.height();this.iAnchorBarHeight=this._bStickyAnchorBar?this._$stickyAnchorBar.height():this._$anchorBar.height();$.css({left:"-10000px",top:"-10000px",width:this._$headerTitle.width()+"px"});if(this._bStickyAnchorBar){this.iHeaderTitleHeightStickied=this._$headerTitle.height()-this.iAnchorBarHeight;$.removeClass("sapUxAPObjectPageHeaderStickied");$.appendTo(this._$headerTitle.parent());this.iHeaderTitleHeight=$.is(":visible")?$.height()-this.iAnchorBarHeight:0;}else{this.iHeaderTitleHeight=this._$headerTitle.is(":visible")?this._$headerTitle.height():0;$.addClass("sapUxAPObjectPageHeaderStickied");$.appendTo(this._$headerTitle.parent());this.iHeaderTitleHeightStickied=$.height();}$.remove();this._adjustHeaderBackgroundSize();q.sap.log.info("ObjectPageLayout :: adjustHeaderHeight","headerTitleHeight: "+this.iHeaderTitleHeight+" - headerTitleStickiedHeight: "+this.iHeaderTitleHeightStickied+" - headerContentHeight: "+this.iHeaderContentHeight);}else{q.sap.log.debug("ObjectPageLayout :: adjustHeaderHeight","skipped as the objectPageLayout is being rendered");}};g.prototype._getHeaderDesign=function(){var H=this.getHeaderTitle(),s=l.ObjectPageHeaderDesign.Light;if(H!=null){s=H.getHeaderDesign();}return s;};g.prototype._getVisibleSections=function(){return this.getSections().filter(function(s){return s.getVisible()&&s._getInternalVisible();});};g.prototype._setSectionsFocusValues=function(s){var i=this._getVisibleSections()||[],$,F='0',n='-1',t="tabIndex",o,j=i[0];i.forEach(function(k){$=k.$();if(s===k.sId){$.attr(t,F);o=k;k._setSubSectionsFocusValues();}else{$.attr(t,n);k._disableSubSectionsFocus();}});if(!o&&i.length>0){j.$().attr(t,F);j._setSubSectionsFocusValues();o=j;}return o;};g.prototype.setShowHeaderContent=function(s){var o=this.getShowHeaderContent();if(o!==s){if(o&&this._bIsHeaderExpanded){this._expandCollapseHeader(false);}this.setProperty("showHeaderContent",s);this._getHeaderContent().setProperty("visible",s);}return this;};g.prototype._headerTitleChangeHandler=function(i){var r;if(!this.getShowTitleInHeaderContent()){return;}if(i){this._getHeaderContent()._destroyObjectImage(true);}r=this.oCore.createRenderManager();this.getRenderer()._rerenderHeaderContentArea(r,this);this._getHeaderContent().invalidate();r.destroy();};g.prototype.getHeaderContent=function(){return this._getHeaderContent().getAggregation("content");};g.prototype.insertHeaderContent=function(o,i,s){return this._getHeaderContent().insertAggregation("content",o,i,s);};g.prototype.addHeaderContent=function(o,s){return this._getHeaderContent().addAggregation("content",o,s);};g.prototype.removeAllHeaderContent=function(s){return this._getHeaderContent().removeAllAggregation("content",s);};g.prototype.removeHeaderContent=function(o,s){return this._getHeaderContent().removeAggregation("content",o,s);};g.prototype.destroyHeaderContent=function(s){return this._getHeaderContent().destroyAggregation("content",s);};g.prototype.indexOfHeaderContent=function(o){return this._getHeaderContent().indexOfAggregation("content",o);};g.prototype._getHeaderContent=function(){if(!this.getAggregation("_headerContent")){this.setAggregation("_headerContent",new l.ObjectPageHeaderContent({visible:this.getShowHeaderContent(),contentDesign:this._getHeaderDesign(),content:this.getAggregation("headerContent",[])}),true);}return this.getAggregation("_headerContent");};g.prototype._checkAlwaysShowContentHeader=function(){return!this._bMobileScenario&&!this._bTabletScenario&&this.getShowHeaderContent()&&this.getAlwaysShowContentHeader();};g.prototype._connectModelsForSections=function(s){s=s||[];s.forEach(function(o){o.connectToModels();});};g.prototype._getHeightRelatedParameters=function(){return{iHeaderContentHeight:this.iHeaderContentHeight,iScreenHeight:this.iScreenHeight,iAnchorBarHeight:this.iAnchorBarHeight,iHeaderTitleHeightStickied:this.iHeaderTitleHeightStickied,iStickyHeaderContentHeight:this.iStickyHeaderContentHeight,iScrollTop:this._$opWrapper.scrollTop()};};g.prototype._hasVerticalScrollBar=function(){return(this._getCustomScrollBar().getVisible()===true);};g.prototype._shiftHeader=function(s,p){this.$().find(".sapUxAPObjectPageHeaderTitle").css("padding-"+s,p);};g.prototype._isFirstSection=function(s){var i=this._getVisibleSections();if(s===i[0]){return true;}return false;};g.prototype._isPositionWithinSection=function(s,o){if(!o||!this._bDomReady||!this._oSectionInfo[o.getId()]){return;}var i=this._computeScrollPosition(o),j=q(o.getDomRef()).height(),k=i+j;return((s>=i)&&(s<k));};g.prototype._restoreScrollPosition=function(){var s=this.oCore.byId(this._sStoredScrolledSubSectionId);if(!s){return;}if(this._isPositionWithinSection(this._iStoredScrollPosition,s)){this._scrollTo(this._iStoredScrollPosition,0);}else{this.scrollToSection(s.getId(),0);}};g.prototype._storeScrollLocation=function(){if(!this._bDomReady){return;}this._iStoredScrollPosition=this._oScroller.getScrollTop();this._sStoredScrolledSubSectionId=this._getClosestScrolledSectionId(this._oScroller.getScrollTop(),this.iScreenHeight,true);this._oCurrentTabSection=null;};g.prototype.onkeyup=function(E){var F,o;if(E.which===q.sap.KeyCodes.TAB){F=this.oCore.getCurrentFocusedControlId();o=F&&this.oCore.byId(F);if(o&&this._isFirstSection(o)){this._scrollTo(0,0);}}};g.prototype.setShowFooter=function(s){var r=this.setProperty("showFooter",s,true);this._toggleFooter(s);return r;};g.prototype._toggleFooter=function(s){var u=this.oCore.getConfiguration().getAnimation(),F=this.getFooter();if(!h(F)){return;}F.toggleStyleClass("sapUxAPObjectPageFloatingFooterShow",s);F.toggleStyleClass("sapUxAPObjectPageFloatingFooterHide",!s);if(this._iFooterWrapperHideTimeout){q.sap.clearDelayedCall(this._iFooterWrapperHideTimeout);}if(u){if(!s){this._iFooterWrapperHideTimeout=q.sap.delayedCall(g.FOOTER_ANIMATION_DURATION,this,function(){this.$("footerWrapper").toggleClass("sapUiHidden",!s);});}else{this.$("footerWrapper").toggleClass("sapUiHidden",!s);this._iFooterWrapperHideTimeout=null;}q.sap.delayedCall(g.FOOTER_ANIMATION_DURATION,this,function(){F.removeStyleClass("sapUxAPObjectPageFloatingFooterShow");});}this._requestAdjustLayout();};g.prototype.clone=function(){Object.keys(this.mAggregations).forEach(this._cloneProxiedAggregations,this);return C.prototype.clone.apply(this,arguments);};g.prototype._cloneProxiedAggregations=function(s){var o=this.mAggregations[s];if(Array.isArray(o)&&o.length===0){o=this["get"+s.charAt(0).toUpperCase()+s.slice(1)]();}this.mAggregations[s]=o;};function h(o){if(arguments.length===1){return Array.isArray(o)?o.length>0:!!o;}return Array.prototype.slice.call(arguments).every(function(i){return h(i);});}return g;});
