/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","./library","sap/ui/core/Control","sap/ui/core/InvisibleText","sap/m/library","sap/m/ToggleButton"],function(q,l,C,I,m,T){"use strict";var B=m.ButtonType;var D=C.extend("sap.f.DynamicPageHeader",{metadata:{library:"sap.f",properties:{pinnable:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true},_pinButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},designTime:true}});D._getResourceBundle=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.f");};D.ARIA={ARIA_CONTROLS:"aria-controls",ARIA_EXPANDED:"aria-expanded",ARIA_LABEL:"aria-label",LABEL_EXPANDED:D._getResourceBundle().getText("EXPANDED_HEADER"),LABEL_SNAPPED:D._getResourceBundle().getText("SNAPPED_HEADER"),LABEL_PINNED:D._getResourceBundle().getText("PIN_HEADER"),LABEL_UNPINNED:D._getResourceBundle().getText("UNPIN_HEADER"),STATE_TRUE:"true",STATE_FALSE:"false"};D.prototype.onAfterRendering=function(){this._initARIAState();this._initPinButtonARIAState();};D.prototype._togglePinButton=function(v){this._getPinButton().setPressed(v);};D.prototype._setShowPinBtn=function(v){this._getPinButton().$().toggleClass("sapUiHidden",!v);};D.prototype._pinUnpinFireEvent=function(){this.fireEvent("_pinUnpinPress");};D.prototype._initARIAState=function(){var $=this.$();$.attr(D.ARIA.ARIA_EXPANDED,D.ARIA.STATE_TRUE);$.attr(D.ARIA.ARIA_LABEL,D.ARIA.LABEL_EXPANDED);};D.prototype._initPinButtonARIAState=function(){var $;if(this.getPinnable()){$=this._getPinButtonJQueryRef();$.attr(D.ARIA.ARIA_CONTROLS,this.getId());}};D.prototype._updateARIAState=function(e){var $=this.$();if(e){$.attr(D.ARIA.ARIA_EXPANDED,D.ARIA.STATE_TRUE);$.attr(D.ARIA.ARIA_LABEL,D.ARIA.LABEL_EXPANDED);}else{$.attr(D.ARIA.ARIA_EXPANDED,D.ARIA.STATE_FALSE);$.attr(D.ARIA.ARIA_LABEL,D.ARIA.LABEL_SNAPPED);}};D.prototype._updateARIAPinButtonState=function(p){var P=this._getPinButton();if(p){P.setTooltip(D.ARIA.LABEL_UNPINNED);}else{P.setTooltip(D.ARIA.LABEL_PINNED);}};D.prototype._getPinButton=function(){if(!this.getAggregation("_pinButton")){var p=new T({id:this.getId()+"-pinBtn",icon:"sap-icon://pushpin-off",tooltip:D.ARIA.LABEL_PINNED,type:B.Transparent,press:this._pinUnpinFireEvent.bind(this)});this.setAggregation("_pinButton",p,true);}return this.getAggregation("_pinButton");};D.prototype._focusPinButton=function(){this._getPinButtonJQueryRef().focus();};D.prototype._getPinButtonJQueryRef=function(){return this._getPinButton().$();};return D;},false);
