/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Item','sap/ui/core/Renderer','sap/ui/core/IconPool','sap/ui/core/InvisibleText'],function(q,l,I,R,a,b){"use strict";var c=I.extend("sap.m.IconTabFilter",{metadata:{interfaces:["sap.m.IconTab","sap.ui.core.PopupInterface"],library:"sap.m",properties:{count:{type:"string",group:"Data",defaultValue:''},showAll:{type:"boolean",group:"Misc",defaultValue:false},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:''},iconColor:{type:"sap.ui.core.IconColor",group:"Appearance",defaultValue:sap.ui.core.IconColor.Default},iconDensityAware:{type:"boolean",group:"Appearance",defaultValue:true},visible:{type:"boolean",group:"Behavior",defaultValue:true},design:{type:"sap.m.IconTabFilterDesign",group:"Appearance",defaultValue:sap.m.IconTabFilterDesign.Vertical}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}}}});c._aAllIconColors=['sapMITBFilterCritical','sapMITBFilterPositive','sapMITBFilterNegative','sapMITBFilterDefault','sapMITBFilterNeutral'];c.prototype._getImageControl=function(C,p,d){var P={src:this.getIcon(),densityAware:this.getIconDensityAware(),useIconTooltip:false};if(P.src){this._oImageControl=sap.m.ImageHelper.getImageControl(this.getId()+"-icon",this._oImageControl,p,P,C,d);}else if(this._oImageControl){this._oImageControl.destroy();this._oImageControl=null;}return this._oImageControl;};c.prototype.exit=function(e){if(this._oImageControl){this._oImageControl.destroy();}if(I.prototype.exit){I.prototype.exit.call(this,e);}};c.prototype.invalidate=function(){var i=this.getParent(),o;if(i instanceof sap.m.IconTabHeader&&i.getParent()instanceof sap.m.IconTabBar){o=i.getParent();if(o.getParent()instanceof sap.m.ObjectHeader){var O=o.getParent();O.invalidate();}else{o.invalidate();}}};c.prototype.setProperty=function(p,v,s){switch(p){case'visible':case'enabled':case'textDirection':case'text':case'count':case'showAll':case'icon':case'iconColor':case'iconDensityAware':case'design':if(this.getProperty(p)===v){return this;}sap.ui.core.Control.prototype.setProperty.call(this,p,v,true);if(!s){var i=this.getParent();if(i instanceof sap.m.IconTabHeader){i.invalidate();}}break;default:sap.ui.core.Control.prototype.setProperty.apply(this,arguments);break;}return this;};c.prototype._getNonEmptyKey=function(){var k=this.getKey();if(k){return k;}return this.getId();};c.prototype.render=function(r,v,d){var t=this;if(!t.getVisible()){return;}var i=this.getParent(),e=i.getParent(),h=e instanceof sap.m.IconTabBar,f=sap.ui.getCore().getLibraryResourceBundle('sap.m'),g='role="tab"',j=t.getId(),k=t.getCount(),m=t.getText(),n=t.getIcon(),o=t.getDesign(),p=t.getIconColor(),s=p==='Positive'||p==='Critical'||p==='Negative',u=o===sap.m.IconTabFilterDesign.Horizontal,w=h&&e.getUpperCase(),x=i._bTextOnly,y=i._bInLine||i.isInlineMode();if(h){g+=' aria-controls="'+e.sId+'-content" ';}if(m.length||k!==''||n){g+='aria-labelledby="';var z=[];if(m.length){z.push(j+'-text');}if(k!==''){z.push(j+'-count');}if(n){z.push(j+'-icon');}if(s){z.push(j+'-iconColor');}g+=z.join(' ');g+='"';}r.write('<div '+g+' ');if(v!==undefined&&d!==undefined){r.writeAccessibilityState({posinset:v+1,setsize:d});}r.writeElementData(t);r.addClass('sapMITBItem');if(!k){r.addClass('sapMITBItemNoCount');}if(u){r.addClass('sapMITBHorizontal');}else{r.addClass('sapMITBVertical');}if(t.getShowAll()){r.addClass('sapMITBAll');}else{r.addClass('sapMITBFilter');r.addClass('sapMITBFilter'+p);}if(!t.getEnabled()){r.addClass('sapMITBDisabled');r.writeAttribute('aria-disabled',true);}r.writeAttribute('aria-selected',false);var T=t.getTooltip_AsString();if(T){r.writeAttributeEscaped('title',T);}r.writeClasses();r.write('>');if(!y){r.write('<div id="'+j+'-tab" class="sapMITBTab">');if(!t.getShowAll()||!n){if(s){r.write('<div id="'+j+'-iconColor" style="display: none;">'+f.getText('ICONTABBAR_ICONCOLOR_'+p.toUpperCase())+'</div>');}r.renderControl(t._getImageControl(['sapMITBFilterIcon','sapMITBFilter'+p],i,c._aAllIconColors));}if(!t.getShowAll()&&!n&&!x){r.write('<span class="sapMITBFilterNoIcon"> </span>');}if(u&&!t.getShowAll()){r.write('</div>');r.write('<div class="sapMITBHorizontalWrapper">');}r.write('<span id="'+j+'-count" ');r.addClass('sapMITBCount');r.writeClasses();r.write('>');if(k===''&&u){r.write('&nbsp;');}else{r.writeEscaped(k);}r.write('</span>');if(!u){r.write('</div>');}}if(m.length){r.write('<div id="'+j+'-text" ');r.addClass('sapMITBText');if(w){r.addClass('sapMITBTextUpperCase');}if(y){r.writeAttribute('dir','ltr');}r.writeClasses();r.write('>');r.writeEscaped(i._getDisplayText(t));r.write('</div>');}if(!y&&u){r.write('</div>');}r.write('<div class="sapMITBContentArrow"></div>');r.write('</div>');};c.prototype.renderInSelectList=function(r,s,v,d){var t=this;if(!t.getVisible()){return;}var i=true,e,f=s._iconTabHeader,g=sap.ui.getCore().getLibraryResourceBundle('sap.m');if(f){i=f._bTextOnly;e=s._bIconOnly;}r.write('<li');r.writeElementData(t);r.writeAttribute('tabindex','-1');r.writeAttribute('role','option');if(v!==undefined&&d!==undefined){r.writeAttribute('aria-posinset',v+1);r.writeAttribute('aria-setsize',d);}var h=t.getTooltip_AsString();if(h){r.writeAttributeEscaped('title',h);}if(!t.getEnabled()){r.addClass('sapMITBDisabled');r.writeAttribute('aria-disabled',true);}r.addClass('sapMITBSelectItem');if(s.getSelectedItem()==t){r.addClass('sapMITBSelectItemSelected');r.writeAttribute('aria-selected',true);}var j=t.getIconColor();r.addClass('sapMITBFilter'+j);r.writeClasses();var k=t.getId(),m,n=j=='Positive'||j=='Critical'||j=='Negative';var o=' aria-labelledby="';if(!e){o+=k+'-text ';}if(!i&&t.getIcon()){o+=k+'-icon ';}if(n){m=new b({text:g.getText('ICONTABBAR_ICONCOLOR_'+j.toUpperCase())});o+=m.getId();}o+='"';r.write(o+'>');if(m){r.renderControl(m);}if(!i){this._renderIcon(r);}if(!e){this._renderText(r);}r.write('</li>');};c.prototype._renderIcon=function(r){var i=this.getIcon();if(i){var d=a.getIconInfo(i);var e=['sapMITBSelectItemIcon'];if(d&&!d.suppressMirroring){e.push('sapUiIconMirrorInRTL');}r.writeIcon(i,e,{id:this.getId()+'-icon','aria-hidden':true});}else{r.write('<span class="sapUiIcon"></span>');}};c.prototype._renderText=function(r){var t=this.getText(),d=this.getCount(),i=sap.ui.getCore().getConfiguration().getRTL(),e=this.getTextDirection();r.write('<span');r.writeAttribute('id',this.getId()+'-text');r.writeAttribute('dir','ltr');r.addClass('sapMText');r.addClass('sapMTextNoWrap');r.addClass('sapMITBText');r.writeClasses();if(e!==sap.ui.core.TextDirection.Inherit){r.writeAttribute('dir',e.toLowerCase());}var f=R.getTextAlign(sap.ui.core.TextAlign.Begin,e);if(f){r.addStyle('text-align',f);r.writeStyles();}if(d){if(i){t='('+d+') '+t;}else{t+=' ('+d+')';}}r.write('>');r.writeEscaped(t);r.write('</span>');};return c;},true);
