/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/core/Control","sap/ui/core/IconPool","sap/ui/core/HTML","sap/ui/core/Icon","./Button","./Toolbar","./ToolbarSpacer","./Bar","./List","./StandardListItem","./library","./Text","./SegmentedButton","./Page","./NavContainer","./Link","./Popover","./MessageItem","./GroupHeaderListItem"],function(q,C,I,H,a,B,T,b,c,L,S,l,d,e,P,N,f,g,M,G){"use strict";var h=l.ListType;var j=C.extend("sap.m.MessageView",{metadata:{library:"sap.m",properties:{asyncDescriptionHandler:{type:"any",group:"Behavior",defaultValue:null},asyncURLHandler:{type:"any",group:"Behavior",defaultValue:null},groupItems:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.MessageItem",multiple:true,singularName:"item"},headerButton:{type:"sap.m.Button",multiple:false}},events:{afterOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},itemSelect:{parameters:{item:{type:"sap.m.MessageItem"},messageTypeFilter:{type:"sap.ui.core.MessageType"}}},listSelect:{parameters:{messageTypeFilter:{type:"sap.ui.core.MessageType"}}},longtextLoaded:{},urlValidated:{}}}});var k="sapMMsgView";var m={back:I.getIconURI("nav-back"),close:I.getIconURI("decline"),information:I.getIconURI("message-information"),warning:I.getIconURI("message-warning"),error:I.getIconURI("message-error"),success:I.getIconURI("message-success")};var n=["all","error","warning","success","information"];var A=["asyncDescriptionHandler","asyncURLHandler"];var D={asyncDescriptionHandler:function(i){var s=i.item.getLongtextUrl();if(s){q.ajax({type:"GET",url:s,success:function(o){i.item.setDescription(o);i.promise.resolve();},error:function(){var E="A request has failed for long text data. URL: "+s;q.sap.log.error(E);i.promise.reject(E);}});}}};j.setDefaultHandlers=function(i){A.forEach(function(F){if(i.hasOwnProperty(F)){D[F]=i[F];}});};j.prototype.init=function(){var t=this;this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._createNavigationPages();this._createLists();A.forEach(function(F){if(D.hasOwnProperty(F)){t.setProperty(F,D[F]);}});};j.prototype.onBeforeRendering=function(){var o;this._clearLists();if(this.getGroupItems()){o=this._groupItems(this.getItems());this._fillGroupedLists(o);}else{this._fillLists(this.getItems());}this._clearSegmentedButton();this._fillSegmentedButton();this._fnFilterList(this._getCurrentMessageTypeFilter()||"all");var i=this.getHeaderButton();if(i){this._oListHeader.insertContent(i,2);}if(!this.getBindingInfo("items")&&!this.getItems().length){this._makeAutomaticBinding();}};j.prototype._fillGroupedLists=function(o){var i=Object.keys(o),u=i.indexOf(""),U,p;if(u!==-1){U=o[""];p=Object.keys(U);p.forEach(function(t){var r=U[t];this._fillLists(r);delete o[""];i.splice(u,1);},this);}i.forEach(function(s){this._fillListsWithGroups(s,o[s]);},this);};j.prototype._fillListsWithGroups=function(s,i){var t=Object.keys(i),o=new G({title:s}),p;this._oLists["all"].addAggregation("items",o,true);t.forEach(function(r){this._oLists[r.toLowerCase()].addAggregation("items",o.clone(),true);p=i[r];this._fillLists(p);},this);};j.prototype.exit=function(){if(this._navContainer){this._navContainer.destroy();}if(this._oLists){this._destroyLists();}if(this._oMessageItemTemplate){this._oMessageItemTemplate.destroy();}this._oResourceBundle=null;this._oListHeader=null;this._oDetailsHeader=null;this._oSegmentedButton=null;this._oBackButton=null;this._navContainer=null;this._listPage=null;this._detailsPage=null;this._sCurrentList=null;};j.prototype._makeAutomaticBinding=function(){var t=this;this.setModel(sap.ui.getCore().getMessageManager().getMessageModel(),"message");this._oMessageItemTemplate=new M({type:"{message>type}",title:"{message>message}",description:"{message>description}",longtextUrl:"{message>longtextUrl}"});this.bindAggregation("items",{path:"message>/",template:t._oMessageItemTemplate});};j.prototype._groupItems=function(i){var o={},s,p;i.forEach(function(r){s=r.getGroupName();p=r.getType();o[s]=o[s]||{};var t=o[s];if(t[p]){t[p].push(r);}else{t[p]=[r];}});return o;};j.prototype._onkeypress=function(E){if(E.shiftKey&&E.keyCode==q.sap.KeyCodes.ENTER){this._fnHandleBackPress();}};j.prototype._getListHeader=function(){return this._oListHeader||this._createListHeader();};j.prototype._getDetailsHeader=function(){return this._oDetailsHeader||this._createDetailsHeader();};j.prototype._createListHeader=function(){var s=this._oResourceBundle.getText("MESSAGEPOPOVER_CLOSE");var i=this.getId()+"-CloseBtnDescr";var o=new H(i,{content:"<span id=\""+i+"\" style=\"display: none;\">"+s+"</span>"});var p=this._oResourceBundle.getText("MESSAGEPOPOVER_ARIA_HEADING");var r=this.getId()+"-HeadingDescr";var t=new H(r,{content:"<span id=\""+r+"\" style=\"display: none;\" role=\"heading\">"+p+"</span>"});this._oSegmentedButton=new e(this.getId()+"-segmented",{}).addStyleClass("sapMSegmentedButtonNoAutoWidth");this._oListHeader=new T({content:[this._oSegmentedButton,new b(),o,t]});return this._oListHeader;};j.prototype._createDetailsHeader=function(){var s=this._oResourceBundle.getText("MESSAGEPOPOVER_CLOSE");var i=this.getId()+"-CloseBtnDetDescr";var o=new H(i,{content:"<span id=\""+i+"\" style=\"display: none;\">"+s+"</span>"});var p=this._oResourceBundle.getText("MESSAGEPOPOVER_ARIA_BACK_BUTTON_TOOLTIP");var r=this._oResourceBundle.getText("MESSAGEPOPOVER_ARIA_BACK_BUTTON");var t=this.getId()+"-BackBtnDetDescr";var u=new H(t,{content:"<span id=\""+t+"\" style=\"display: none;\">"+r+"</span>"});this._oBackButton=new B({icon:m["back"],press:this._fnHandleBackPress.bind(this),ariaLabelledBy:u,tooltip:p}).addStyleClass(k+"BackBtn");this._oDetailsHeader=new T({content:[this._oBackButton,new b(),o,u]});return this._oDetailsHeader;};j.prototype._createNavigationPages=function(){this._listPage=new P(this.getId()+"listPage",{customHeader:this._getListHeader()});this._detailsPage=new P(this.getId()+"-detailsPage",{customHeader:this._getDetailsHeader()});this._detailsPage.addEventDelegate({onclick:function(E){var t=E.target;if(t.nodeName.toUpperCase()==="A"&&(t.className.indexOf("sapMMsgPopoverItemDisabledLink")!==-1||t.className.indexOf("sapMMsgPopoverItemPendingLink")!==-1)){E.preventDefault();}}});this._navContainer=new N(this.getId()+"-navContainer",{initialPage:this.getId()+"listPage",pages:[this._listPage,this._detailsPage]});return this;};j.prototype._createLists=function(){this._oLists={};n.forEach(function(s){this._oLists[s]=new L({itemPress:this._fnHandleItemPress.bind(this),visible:false});this._listPage.addAggregation("content",this._oLists[s],true);},this);return this;};j.prototype._clearLists=function(){n.forEach(function(s){if(this._oLists[s]){this._oLists[s].destroyAggregation("items",true);}},this);return this;};j.prototype._destroyLists=function(){n.forEach(function(s){this._oLists[s]=null;},this);this._oLists=null;};j.prototype._fillLists=function(i){i.forEach(function(o){var p=this._mapItemToListItem(o),r=this._mapItemToListItem(o);this._oLists["all"].addAggregation("items",p,true);this._oLists[o.getType().toLowerCase()].addAggregation("items",r,true);},this);};j.prototype._mapItemToListItem=function(o){if(!o){return null;}var t=o.getType(),i=this._getItemType(o),p=new S({title:o.getTitle(),description:o.getSubtitle(),counter:o.getCounter(),icon:this._mapIcon(t),infoState:this._mapInfoState(t),info:"\r",type:i}).addStyleClass(k+"Item").addStyleClass(k+"Item"+t);if(i!==h.Navigation){p.addEventDelegate({onAfterRendering:function(){var r=this.getDomRef().querySelector(".sapMSLITitleDiv > div");if(r.offsetWidth<r.scrollWidth){this.setType(h.Navigation);}}},p);}p._oMessageItem=o;return p;};j.prototype._mapInfoState=function(t){if(!t){return null;}var i=sap.ui.core.MessageType,V=sap.ui.core.ValueState;switch(t){case i.Warning:return V.Warning;case i.Error:return V.Error;case i.Success:return V.Success;case i.Information:case i.None:return V.None;default:q.sap.log.warning("The provided MessageType is not mapped to a specific ValueState",t);return null;}};j.prototype._mapIcon=function(i){if(!i){return null;}return m[i.toLowerCase()];};j.prototype._getItemType=function(o){return(o.getDescription()||o.getMarkupDescription()||o.getLongtextUrl())?h.Navigation:h.Inactive;};j.prototype._clearSegmentedButton=function(){if(this._oSegmentedButton){this._oSegmentedButton.destroyAggregation("buttons",true);}return this;};j.prototype._fillSegmentedButton=function(){var t=this;var p=function(s){return function(){t._fnFilterList(s);};};n.forEach(function(s){var o=this._oLists[s],i=o.getItems().filter(function(u){return(u instanceof S);}).length,r;if(i>0){r=new B(this.getId()+"-"+s,{text:s=="all"?this._oResourceBundle.getText("MESSAGEPOPOVER_ALL"):i,icon:m[s],press:p(s)}).addStyleClass(k+"Btn"+s.charAt(0).toUpperCase()+s.slice(1));this._oSegmentedButton.addButton(r,true);}},this);return this;};j.prototype._setIcon=function(o,i){this._previousIconTypeClass=k+"DescIcon"+o.getType();this._oMessageIcon=new a({src:i.getIcon()}).addStyleClass(k+"DescIcon").addStyleClass(this._previousIconTypeClass);this._detailsPage.addContent(this._oMessageIcon);};j.prototype._setTitle=function(o){this._oMessageTitleText=new d(this.getId()+"MessageTitleText",{text:o.getTitle()}).addStyleClass("sapMMsgViewTitleText");this._detailsPage.addAggregation("content",this._oMessageTitleText);};j.prototype._setDescription=function(o){var i=o.getLink();this._oLastSelectedItem=o;if(o.getMarkupDescription()){this._oMessageDescriptionText=new H(this.getId()+"MarkupDescription",{content:"<div class='sapMMsgViewDescriptionText'>"+o.getDescription()+"</div>"});}else{this._oMessageDescriptionText=new d(this.getId()+"MessageDescriptionText",{text:o.getDescription()}).addStyleClass("sapMMsgViewDescriptionText");}this._detailsPage.addContent(this._oMessageDescriptionText);if(i){this._detailsPage.addContent(i);i.addStyleClass("sapMMsgViewDescriptionLink");}};j.prototype._iNextValidationTaskId=0;j.prototype._validateURL=function(u){if(q.sap.validateUrl(u)){return u;}q.sap.log.warning("You have entered invalid URL");return"";};j.prototype._queueValidation=function(i){var o=this.getAsyncURLHandler();var v=++this._iNextValidationTaskId;var p={};var r=new window.Promise(function(s,t){p.resolve=s;p.reject=t;var u={url:i,id:v,promise:p};o(u);});r.id=v;return r;};j.prototype._getTagPolicy=function(){var t=this,i;var o=html.makeTagPolicy(this._validateURL());return function customTagPolicy(p,r){var s,v=false;if(p.toUpperCase()==="A"){for(i=0;i<r.length;){if(r[i]==="href"){v=true;s=r[i+1];r.splice(0,2);continue;}i+=2;}}r=o(p,r);if(v&&typeof t.getAsyncURLHandler()==="function"){r=r||[];var u="sapMMsgViewItemDisabledLink sapMMsgViewItemPendingLink";var w=r.indexOf("class");if(w>-1){r[w+1]+=u;}else{r.unshift(u);r.unshift("class");}var x=r.indexOf("id");if(x>-1){r.splice(x+1,1);r.splice(x,1);}var V=t._queueValidation(s);r.push("href");r.push(s);r.push("target");r.push("_blank");r.push("id");r.push("sap-ui-"+t.getId()+"-link-under-validation-"+V.id);V.then(function(y){var $=q.sap.byId("sap-ui-"+t.getId()+"-link-under-validation-"+y.id);if(y.allowed){q.sap.log.info("Allow link "+s);}else{q.sap.log.info("Disallow link "+s);}$.removeClass("sapMMsgViewItemPendingLink");$.toggleClass("sapMMsgViewItemDisabledLink",!y.allowed);t.fireUrlValidated();}).catch(function(){q.sap.log.warning("Async URL validation could not be performed.");});}return r;};};j.prototype._sanitizeDescription=function(o){q.sap.require("jquery.sap.encoder");q.sap.require("sap.ui.thirdparty.caja-html-sanitizer");var s=o.getDescription();if(o.getMarkupDescription()){var t=this._getTagPolicy();s=html.sanitizeWithPolicy(s,t);}o.setDescription(s);this._setDescription(o);};j.prototype._fnHandleItemPress=function(E){var o=E.getParameter("listItem"),i=o._oMessageItem,p=this._detailsPage.getContent()||[];var r=this.getAsyncDescriptionHandler();var s=function(w){this._setTitle(i);this._sanitizeDescription(i);this._setIcon(i,o);this._detailsPage.rerender();this.fireLongtextLoaded();if(!w){this._navContainer.to(this._detailsPage);}}.bind(this);this._previousIconTypeClass=this._previousIconTypeClass||"";this.fireItemSelect({item:i,messageTypeFilter:this._getCurrentMessageTypeFilter()});p.forEach(function(w){if(w instanceof f){this._oLastSelectedItem.setLink(w);w.removeAllAriaLabelledBy();}else{w.destroy();}},this);if(typeof r==="function"&&!!i.getLongtextUrl()){i.setMarkupDescription(true);var t={};var u=new window.Promise(function(w,x){t.resolve=w;t.reject=x;});var v=function(){this._detailsPage.setBusy(false);s(true);}.bind(this);u.then(v).catch(function(){q.sap.log.warning("Async description loading could not be performed.");v();});this._navContainer.to(this._detailsPage);this._detailsPage.setBusy(true);r({promise:t,item:i});}else{s();}this._listPage.$().attr("aria-hidden","true");};j.prototype._fnHandleBackPress=function(){this._listPage.$().removeAttr("aria-hidden");this._navContainer.back();};j.prototype._fnFilterList=function(s){n.forEach(function(i){if(i!=s&&this._oLists[i].getVisible()){this._oLists[i].setVisible(false);}},this);this._sCurrentList=s;this._oLists[s].setVisible(true);this._listPage.rerender();this.fireListSelect({messageTypeFilter:this._getCurrentMessageTypeFilter()});};j.prototype._getCurrentMessageTypeFilter=function(){return this._sCurrentList=="all"?"":this._sCurrentList;};j.prototype._isListPage=function(){return this._navContainer.getCurrentPage()==this._listPage;};return j;},true);
