/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./Bar','./InputBase','./ComboBoxTextField','./ComboBoxBase','./Dialog','./MultiInput','./Input','./ToggleButton','./List','./MultiComboBoxRenderer','./Popover','./library','sap/ui/core/EnabledPropagator','sap/ui/core/InvisibleText','sap/ui/core/IconPool','jquery.sap.xml'],function(q,B,I,C,a,D,M,b,T,L,c,P,l,E,d,e){"use strict";var f=a.extend("sap.m.MultiComboBox",{metadata:{library:"sap.m",properties:{selectedKeys:{type:"string[]",group:"Data",defaultValue:[]}},associations:{selectedItems:{type:"sap.ui.core.Item",multiple:true,singularName:"selectedItem"}},events:{selectionChange:{parameters:{changedItem:{type:"sap.ui.core.Item"},selected:{type:"boolean"}}},selectionFinish:{parameters:{selectedItems:{type:"sap.ui.core.Item[]"}}}}}});e.insertFontFaceStyle();E.apply(f.prototype,[true]);f.prototype.onsapend=function(o){sap.m.Tokenizer.prototype.onsapend.apply(this._oTokenizer,arguments);};f.prototype.onsaphome=function(o){sap.m.Tokenizer.prototype.onsaphome.apply(this._oTokenizer,arguments);};f.prototype.onsapdown=function(o){if(!this.getEnabled()||!this.getEditable()){return;}o.setMarked();o.preventDefault();var i=this.getSelectableItems();var g=i[0];if(g&&this.isOpen()){this.getListItem(g).focus();return;}if(this._oTokenizer.getSelectedTokens().length){return;}this._oTraversalItem=this._getNextTraversalItem();if(this._oTraversalItem){this.updateDomValue(this._oTraversalItem.getText());this.selectText(0,this.getValue().length);}};f.prototype.onsapup=function(o){if(!this.getEnabled()||!this.getEditable()){return;}o.setMarked();o.preventDefault();if(this._oTokenizer.getSelectedTokens().length){return;}this._oTraversalItem=this._getPreviousTraversalItem();if(this._oTraversalItem){this.updateDomValue(this._oTraversalItem.getText());this.selectText(0,this.getValue().length);}};f.prototype.onsapshow=function(o){var g=this.getList(),p=this.getPicker(),s=this.getSelectableItems(),S=this.getSelectedItems(),i,h=g.getItemNavigation(),j,k;k=q(document.activeElement).control()[0];if(k instanceof sap.m.Token){i=this._getItemByToken(k);}else{i=S.length?this._getItemByListItem(this.getList().getSelectedItems()[0]):s[0];}j=this.getItems().indexOf(i);if(h){h.setSelectedIndex(j);}else{this._bListItemNavigationInvalidated=true;this._iInitialItemFocus=j;}p.setInitialFocus(g);a.prototype.onsapshow.apply(this,arguments);};f.prototype.onsaphide=f.prototype.onsapshow;f.prototype._selectItemByKey=function(o){var v,p,g,i,h,j=this.isOpen();if(!this.getEnabled()||!this.getEditable()){return;}if(o){o.setMarked();}v=this._getUnselectedItems(j?"":this.getValue());for(i=0;i<v.length;i++){if(v[i].getText().toUpperCase()===this.getValue().toUpperCase()){g=v[i];h=true;break;}}if(h){p={item:g,id:g.getId(),key:g.getKey(),fireChangeEvent:true,fireFinishEvent:true,suppressInvalidate:true,listItemUpdated:false};this._bPreventValueRemove=false;if(this.getValue()===""||q.sap.startsWithIgnoreCase(g.getText(),this.getValue())){if(this.getListItem(g).isSelected()){this.setValue('');}else{this.setSelection(p);}}}else{this._bPreventValueRemove=true;this._showWrongValueVisualEffect();}if(o){this.close();}};f.prototype.onsapenter=function(o){I.prototype.onsapenter.apply(this,arguments);if(this.getValue()){this._selectItemByKey(o);}};f.prototype.onsaptabnext=function(o){var i=this.getValue();if(i){var s=this._getUnselectedItemsStartingText(i);if(s.length===1){this._selectItemByKey(o);}else{this._showWrongValueVisualEffect();this.setValue(null);}}};f.prototype.onsapfocusleave=function(o){var p=this.getAggregation("picker");var t=this.isPlatformTablet();var g=sap.ui.getCore().byId(o.relatedControlId);var F=g&&g.getFocusDomRef();if(!p||!p.getFocusDomRef()||!F||!q.contains(p.getFocusDomRef(),F)){this.setValue(null);if(!(g instanceof sap.m.Token)){this._oTokenizer.scrollToEnd();}}if(p&&F){if(q.sap.equal(p.getFocusDomRef(),F)&&!t&&!this.isPickerDialog()){this.focus();}}};f.prototype.onfocusin=function(o){var g=this.getPickerType()==="Dropdown";if(o.target===this.getFocusDomRef()){this.getEditable()&&this.addStyleClass("sapMMultiComboBoxFocus");}if(o.target===this.getOpenArea()&&g&&!this.isPlatformTablet()){this.focus();}if(!this.isOpen()&&this.shouldValueStateMessageBeOpened()){this.openValueStateMessage();}};f.prototype._handleItemTap=function(o){if(o.target.childElementCount===0||o.target.childElementCount===2){this._bCheckBoxClicked=false;if(this.isOpen()&&!this._isListInSuggestMode()){this.close();}}};f.prototype._handleItemPress=function(o){if(this.isOpen()&&this._isListInSuggestMode()&&this.getPicker().oPopup.getOpenState()!==sap.ui.core.OpenState.CLOSING){this.clearFilter();var i=this._getLastSelectedItem();if(i){this.getListItem(i).focus();}}};f.prototype._handleSelectionLiveChange=function(o){var g=o.getParameter("listItem");var i=o.getParameter("selected");var n=this._getItemByListItem(g);if(g.getType()==="Inactive"){return;}if(!n){return;}var p={item:n,id:n.getId(),key:n.getKey(),fireChangeEvent:true,suppressInvalidate:true,listItemUpdated:true};if(i){this.fireChangeEvent(n.getText());this.setSelection(p);}else{this.fireChangeEvent(n.getText());this.removeSelection(p);}if(this._bCheckBoxClicked){this.setValue(this._sOldValue);if(this.isOpen()&&this.getPicker().oPopup.getOpenState()!==sap.ui.core.OpenState.CLOSING){g.focus();}}else{this._bCheckBoxClicked=true;this.setValue("");this.close();}};f.prototype.onkeydown=function(o){a.prototype.onkeydown.apply(this,arguments);if(!this.getEnabled()||!this.getEditable()){return;}this._bIsPasteEvent=(o.ctrlKey||o.metaKey)&&(o.which===q.sap.KeyCodes.V);if(this.getValue().length===0&&(o.ctrlKey||o.metaKey)&&(o.which===q.sap.KeyCodes.A)&&this._hasTokens()){this._oTokenizer.focus();this._oTokenizer.selectAllTokens(true);o.preventDefault();}if(this.isPickerDialog()){this._sOldValue=this.getPickerTextField().getValue();this._iOldCursorPos=q(this.getFocusDomRef()).cursorPos();}};f.prototype.oninput=function(o){a.prototype.oninput.apply(this,arguments);var i=o.srcControl;if(!this.getEnabled()||!this.getEditable()){return;}if(this._bIsPasteEvent){i.updateDomValue(this._sOldValue||"");return;}if(!this._bCompositionStart&&!this._bCompositionEnd){this._handleInputValidation(o,false);}};f.prototype.filterItems=function(i,v){i.forEach(function(o){var m=q.sap.startsWithIgnoreCase(o.getText(),v);if(v===""){m=true;if(!this.bOpenedByKeyboardOrButton){return;}}var g=this.getListItem(o);if(g){g.setVisible(m);}},this);};f.prototype.onkeyup=function(o){if(!this.getEnabled()||!this.getEditable()){return;}this._sOldValue=this.getValue();this._iOldCursorPos=q(this.getFocusDomRef()).cursorPos();};f.prototype._showWrongValueVisualEffect=function(){var o=this.getValueState();if(o===sap.ui.core.ValueState.Error){return;}if(this.isPickerDialog()){this.getPickerTextField().setValueState(sap.ui.core.ValueState.Error);q.sap.delayedCall(1000,this.getPickerTextField(),"setValueState",[o]);}else{this.setValueState(sap.ui.core.ValueState.Error);q.sap.delayedCall(1000,this,"setValueState",[o]);}};f.prototype.createPicker=function(p){var o=this.getAggregation("picker");if(o){return o;}o=this["create"+p]();this.setAggregation("picker",o,true);var r=this.getRenderer(),g=r.CSS_CLASS_MULTICOMBOBOX;o.setHorizontalScrolling(false).addStyleClass(r.CSS_CLASS_COMBOBOXBASE+"Picker").addStyleClass(g+"Picker").addStyleClass(g+"Picker-CTX").attachBeforeOpen(this.onBeforeOpen,this).attachAfterOpen(this.onAfterOpen,this).attachBeforeClose(this.onBeforeClose,this).attachAfterClose(this.onAfterClose,this).addEventDelegate({onBeforeRendering:this.onBeforeRenderingPicker,onAfterRendering:this.onAfterRenderingPicker},this).addContent(this.getList());return o;};f.prototype.createPickerTextField=function(){return new b();};f.prototype.onBeforeRendering=function(){a.prototype.onBeforeRendering.apply(this,arguments);var i=this.getItems();var o=this.getList();if(o){this._synchronizeSelectedItemAndKey(i);o.destroyItems();this._clearTokenizer();this._fillList(i);if(o.getItemNavigation()){this._iFocusedIndex=o.getItemNavigation().getFocusedIndex();}this.setEditable(this.getEditable());}};f.prototype.onBeforeRenderingPicker=function(){var o=this["_onBeforeRendering"+this.getPickerType()];if(o){o.call(this);}};f.prototype.onAfterRenderingPicker=function(){var o=this["_onAfterRendering"+this.getPickerType()];if(o){o.call(this);}};f.prototype.onBeforeOpen=function(){var p=this["_onBeforeOpen"+this.getPickerType()];this.addStyleClass(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Pressed");this._resetCurrentItem();this.addContent();this._aInitiallySelectedItems=this.getSelectedItems();if(p){p.call(this);}};f.prototype.onAfterOpen=function(){if(!this.isPlatformTablet()){this.getPicker().setInitialFocus(this);}this.closeValueStateMessage();};f.prototype.onBeforeClose=function(){a.prototype.onBeforeClose.apply(this,arguments);};f.prototype.onAfterClose=function(){this.removeStyleClass(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Pressed");this.clearFilter();!this._bPreventValueRemove&&this.setValue("");this._sOldValue="";if(this.isPickerDialog()){this.getPickerTextField().setValue("");this._getFilterSelectedButton().setPressed(false);}this.fireSelectionFinish({selectedItems:this.getSelectedItems()});};f.prototype._onBeforeOpenDialog=function(){};f.prototype._onBeforeOpenPopover=function(){var p=this.getPicker(),o=this.getDomRef(),w;if(o&&p){w=(o.offsetWidth/parseFloat(sap.m.BaseFontSize))+"rem";p.setContentMinWidth(w);}};f.prototype._decoratePopover=function(p){var t=this;p.open=function(){return this.openBy(t);};};f.prototype.createDropdown=function(){var o=new P(this.getDropdownSettings());o.setInitialFocus(this);this._decoratePopover(o);return o;};f.prototype.createDialog=function(){var o=a.prototype.createDialog.apply(this,arguments),s=this._createFilterSelectedButton();o.getSubHeader().addContent(s);return o;};f.prototype._createFilterSelectedButton=function(){var i=e.getIconURI("multiselect-all"),r=this.getRenderer(),t=this;return new T({icon:i,press:t._filterSelectedItems.bind(this)}).addStyleClass(r.CSS_CLASS_MULTICOMBOBOX+"ToggleButton");};f.prototype._getFilterSelectedButton=function(){return this.getPicker().getSubHeader().getContent()[1];};f.prototype._filterSelectedItems=function(o){var g=o.oSource,h,m,v=this.getPickerTextField().getValue(),p=g.getPressed(),V=this.getVisibleItems(),i=this.getItems(),s=this.getSelectedItems();if(p){V.forEach(function(j){m=s.indexOf(j)>-1?true:false;h=this.getListItem(j);if(h){h.setVisible(m);}},this);}else{this.filterItems(i,v);}};f.prototype.revertSelection=function(){this.setSelectedItems(this._aInitiallySelectedItems);};f.prototype.createList=function(){var r=this.getRenderer();this._oList=new L({width:"100%",mode:sap.m.ListMode.MultiSelect,includeItemInSelection:true,rememberSelections:false}).addStyleClass(r.CSS_CLASS_COMBOBOXBASE+"List").addStyleClass(r.CSS_CLASS_MULTICOMBOBOX+"List").attachBrowserEvent("tap",this._handleItemTap,this).attachSelectionChange(this._handleSelectionLiveChange,this).attachItemPress(this._handleItemPress,this);this._oList.addEventDelegate({onAfterRendering:this.onAfterRenderingList,onfocusin:this.onFocusinList},this);};f.prototype.setSelection=function(o){if(o.item&&this.isItemSelected(o.item)){return;}if(!o.item){return;}if(!o.listItemUpdated&&this.getListItem(o.item)){this.getList().setSelectedItem(this.getListItem(o.item),true);}var t=new sap.m.Token({key:o.key});t.setText(o.item.getText());t.setTooltip(o.item.getText());o.item.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Token",t);this._oTokenizer.addToken(t);this.$().toggleClass("sapMMultiComboBoxHasToken",this._hasTokens());this.setValue('');this.addAssociation("selectedItems",o.item,o.suppressInvalidate);var s=this.getKeys(this.getSelectedItems());this.setProperty("selectedKeys",s,o.suppressInvalidate);if(o.fireChangeEvent){this.fireSelectionChange({changedItem:o.item,selected:true});}if(o.fireFinishEvent){if(!this.isOpen()){this.fireSelectionFinish({selectedItems:this.getSelectedItems()});}}};f.prototype.removeSelection=function(o){if(o.item&&!this.isItemSelected(o.item)){return;}if(!o.item){return;}this.removeAssociation("selectedItems",o.item,o.suppressInvalidate);var s=this.getKeys(this.getSelectedItems());this.setProperty("selectedKeys",s,o.suppressInvalidate);if(!o.listItemUpdated&&this.getListItem(o.item)){this.getList().setSelectedItem(this.getListItem(o.item),false);}if(!o.tokenUpdated){var t=this._getTokenByItem(o.item);o.item.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Token",null);this._oTokenizer.removeToken(t);}this.$().toggleClass("sapMMultiComboBoxHasToken",this._hasTokens());if(o.fireChangeEvent){this.fireSelectionChange({changedItem:o.item,selected:false});}if(o.fireFinishEvent){if(!this.isOpen()){this.fireSelectionFinish({selectedItems:this.getSelectedItems()});}}};f.prototype._synchronizeSelectedItemAndKey=function(g){if(!g.length){q.sap.log.info("Info: _synchronizeSelectedItemAndKey() the MultiComboBox control does not contain any item on ",this);return;}var s=this.getSelectedKeys()||this._aCustomerKeys;var k=this.getKeys(this.getSelectedItems());if(s.length){for(var i=0,K=null,o=null,h=null,j=s.length;i<j;i++){K=s[i];if(k.indexOf(K)>-1){if(this._aCustomerKeys.length&&(h=this._aCustomerKeys.indexOf(K))>-1){this._aCustomerKeys.splice(h,1);}continue;}o=this.getItemByKey(""+K);if(o){if(this._aCustomerKeys.length&&(h=this._aCustomerKeys.indexOf(K))>-1){this._aCustomerKeys.splice(h,1);}this.setSelection({item:o,id:o.getId(),key:o.getKey(),fireChangeEvent:false,suppressInvalidate:true,listItemUpdated:false});}}return;}};f.prototype._getTokenByItem=function(i){return i?i.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Token"):null;};f.prototype.updateItems=function(r){var k,i,K=this.getSelectedKeys();var u=a.prototype.updateItems.apply(this,arguments);i=this.getSelectedItems();k=(i.length===K.length)&&i.every(function(o){return o&&o.getKey&&K.indexOf(o.getKey())>-1;});if(!k){i=K.map(this.getItemByKey,this);this.setSelectedItems(i);}return u;};f.prototype._getSelectedItemsOf=function(g){for(var i=0,h=g.length,s=[];i<h;i++){if(this.getListItem(g[i]).isSelected()){s.push(g[i]);}}return s;};f.prototype._getLastSelectedItem=function(){var t=this._oTokenizer.getTokens();var o=t.length?t[t.length-1]:null;if(!o){return null;}return this._getItemByToken(o);};f.prototype._getOrderedSelectedItems=function(){var g=[];for(var i=0,t=this._oTokenizer.getTokens(),h=t.length;i<h;i++){g[i]=this._getItemByToken(t[i]);}return g;};f.prototype._getFocusedListItem=function(){if(!document.activeElement){return null;}var F=sap.ui.getCore().byId(document.activeElement.id);if(this.getList()&&q.sap.containsOrEquals(this.getList().getFocusDomRef(),F.getFocusDomRef())){return F;}return null;};f.prototype._getFocusedItem=function(){var o=this._getFocusedListItem();return this._getItemByListItem(o);};f.prototype._isRangeSelectionSet=function(o){var $=o.getDomRef();return $.indexOf(this.getRenderer().CSS_CLASS_MULTICOMBOBOX+"ItemRangeSelection")>-1?true:false;};f.prototype._hasTokens=function(){return this._oTokenizer.getTokens().length>0;};f.prototype._getCurrentItem=function(){if(!this._oCurrentItem){return this._getFocusedItem();}return this._oCurrentItem;};f.prototype._setCurrentItem=function(i){this._oCurrentItem=i;};f.prototype._resetCurrentItem=function(){this._oCurrentItem=null;};f.prototype._decorateListItem=function(o){o.addDelegate({onkeyup:function(g){var i=null;if(g.which==q.sap.KeyCodes.SPACE&&this.isOpen()&&this._isListInSuggestMode()){this.open();i=this._getLastSelectedItem();if(i){this.getListItem(i).focus();}return;}},onkeydown:function(g){var i=null,h=null;if(g.shiftKey&&g.which==q.sap.KeyCodes.ARROW_DOWN){h=this._getCurrentItem();i=this._getNextVisibleItemOf(h);}if(g.shiftKey&&g.which==q.sap.KeyCodes.ARROW_UP){h=this._getCurrentItem();i=this._getPreviousVisibleItemOf(h);}if(g.shiftKey&&g.which===q.sap.KeyCodes.SPACE){h=this._getCurrentItem();this._selectPreviousItemsOf(h);}if(i&&i!==h){if(this.getListItem(h).isSelected()){this.setSelection({item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:true,suppressInvalidate:true});this._setCurrentItem(i);}else{this.removeSelection({item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:true,suppressInvalidate:true});this._setCurrentItem(i);}return;}this._resetCurrentItem();if((g.ctrlKey||g.metaKey)&&g.which==q.sap.KeyCodes.A){g.setMarked();g.preventDefault();var v=this.getSelectableItems();var s=this._getSelectedItemsOf(v);if(s.length!==v.length){v.forEach(function(i){this.setSelection({item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:true,suppressInvalidate:true,listItemUpdated:false});},this);}else{v.forEach(function(i){this.removeSelection({item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:true,suppressInvalidate:true,listItemUpdated:false});},this);}}}},true,this);o.addEventDelegate({onsapbackspace:function(g){g.preventDefault();},onsapshow:function(g){g.setMarked();if(g.keyCode===q.sap.KeyCodes.F4){g.preventDefault();}if(this.isOpen()){this.close();return;}if(this.hasContent()){this.open();}},onsaphide:function(g){this.onsapshow(g);},onsapenter:function(g){g.setMarked();this.close();},onsaphome:function(g){g.setMarked();g.preventDefault();var v=this.getSelectableItems();var i=v[0];this.getListItem(i).focus();},onsapend:function(g){g.setMarked();g.preventDefault();var v=this.getSelectableItems();var i=v[v.length-1];this.getListItem(i).focus();},onsapup:function(g){g.setMarked();g.preventDefault();var v=this.getSelectableItems();var i=v[0];var h=q(document.activeElement).control()[0];if(h===this.getListItem(i)){this.focus();g.stopPropagation(true);}},onfocusin:function(g){this.addStyleClass(this.getRenderer().CSS_CLASS_MULTICOMBOBOX+"Focused");},onfocusout:function(g){this.removeStyleClass(this.getRenderer().CSS_CLASS_MULTICOMBOBOX+"Focused");},onsapfocusleave:function(g){var p=this.getAggregation("picker");var h=sap.ui.getCore().byId(g.relatedControlId);if(p&&h&&q.sap.equal(p.getFocusDomRef(),h.getFocusDomRef())){if(g.srcControl){g.srcControl.focus();}}}},this);if(sap.ui.Device.support.touch){o.addEventDelegate({ontouchstart:function(g){g.setMark("cancelAutoClose");}});}};f.prototype._createTokenizer=function(){var t=new sap.m.Tokenizer({tokens:[]}).attachTokenChange(this._handleTokenChange,this);t.setParent(this);t.addEventDelegate({onAfterRendering:this._onAfterRenderingTokenizer},this);return t;};f.prototype._onAfterRenderingTokenizer=function(){this._oTokenizer.scrollToEnd();};f.prototype._handleTokenChange=function(o){var t=o.getParameter("type");var g=o.getParameter("token");var i=null;if(t!==sap.m.Tokenizer.TokenChangeType.Removed&&t!==sap.m.Tokenizer.TokenChangeType.Added){return;}if(t===sap.m.Tokenizer.TokenChangeType.Removed){i=(g&&this._getItemByToken(g));if(i&&this.isItemSelected(i)){this.removeSelection({item:i,id:i.getId(),key:i.getKey(),tokenUpdated:true,fireChangeEvent:true,fireFinishEvent:true,suppressInvalidate:true});!this.isPickerDialog()&&this.focus();this.fireChangeEvent("");}}};f.prototype.onAfterRenderingList=function(){var o=this.getList();if(this._iFocusedIndex!=null&&o.getItems().length>this._iFocusedIndex){o.getItems()[this._iFocusedIndex].focus();this._iFocusedIndex=null;}};f.prototype.onFocusinList=function(){if(this._bListItemNavigationInvalidated){this.getList().getItemNavigation().setSelectedIndex(this._iInitialItemFocus);this._bListItemNavigationInvalidated=false;}};f.prototype.onAfterRendering=function(){a.prototype.onAfterRendering.apply(this,arguments);var p=this.getPicker();var o=q(this.getDomRef());var g=o.find(this.getRenderer().DOT_CSS_CLASS_MULTICOMBOBOX+"Border");p._oOpenBy=g[0];};f.prototype.onfocusout=function(o){this.removeStyleClass("sapMMultiComboBoxFocus");a.prototype.onfocusout.apply(this,arguments);};f.prototype.onpaste=function(o){var O;if(window.clipboardData){O=window.clipboardData.getData("Text");}else{O=o.originalEvent.clipboardData.getData('text/plain');}var s=this._oTokenizer._parseString(O);if(s&&s.length>0){this.getSelectableItems().forEach(function(i){if(q.inArray(i.getText(),s)>-1){this.setSelection({item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:true,fireFinishEvent:true,suppressInvalidate:true,listItemUpdated:false});}},this);}};f.prototype.onsapbackspace=function(o){if(!this.getEnabled()||!this.getEditable()){o.preventDefault();return;}if(this.getCursorPosition()>0||this.getValue().length>0){return;}sap.m.Tokenizer.prototype.onsapbackspace.apply(this._oTokenizer,arguments);o.preventDefault();};f.prototype.onsapdelete=function(o){if(!this.getEnabled()||!this.getEditable()){return;}if(this.getValue()&&!this._isCompleteTextSelected()){return;}sap.m.Tokenizer.prototype.onsapdelete.apply(this._oTokenizer,arguments);};f.prototype.onsapnext=function(o){if(o.isMarked()){return;}var F=q(document.activeElement).control()[0];if(!F){return;}if(F===this._oTokenizer||this._oTokenizer.$().find(F.$()).length>0&&this.getEditable()){this.focus();}};f.prototype.onsapprevious=function(o){if(this.getCursorPosition()===0&&!this._isCompleteTextSelected()){if(o.srcControl===this){sap.m.Tokenizer.prototype.onsapprevious.apply(this._oTokenizer,arguments);}}};f.prototype.getOpenArea=function(){if(this.isPickerDialog()){return this.getDomRef();}else{return a.prototype.getOpenArea.apply(this,arguments);}};f.prototype._getItemsStartingText=function(t,i){var g=[],s=i?this.getEnabledItems():this.getSelectableItems();s.forEach(function(o){if(q.sap.startsWithIgnoreCase(o.getText(),t)){g.push(o);}},this);return g;};f.prototype._getUnselectedItemsStartingText=function(t){var i=[];this._getUnselectedItems().forEach(function(o){if(q.sap.startsWithIgnoreCase(o.getText(),t)){i.push(o);}},this);return i;};f.prototype.getCursorPosition=function(){return this._$input.cursorPos();};f.prototype._isCompleteTextSelected=function(){if(!this.getValue().length){return false;}var i=this._$input[0];if(i.selectionStart!==0||i.selectionEnd!==this.getValue().length){return false;}return true;};f.prototype._selectPreviousItemsOf=function(i){var g;do{g=true;var p=this._getPreviousVisibleItemOf(i);if(p){var o=this.getListItem(p);if(o){g=this.getListItem(p).getSelected();}}this.setSelection({item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:true,suppressInvalidate:true});i=p;}while(!g);};f.prototype._getNextVisibleItemOf=function(i){var g=this.getSelectableItems();var h=g.indexOf(i)+1;if(h<=0||h>g.length-1){return null;}return g[h];};f.prototype._getPreviousVisibleItemOf=function(i){var g=this.getSelectableItems();var h=g.indexOf(i)-1;if(h<0){return null;}return g[h];};f.prototype._getNextUnselectedItemOf=function(i){var g=this._getUnselectedItems();var h=g.indexOf(i)+1;if(h<=0||h>g.length-1){return null;}return g[h];};f.prototype._getPreviousUnselectedItemOf=function(i){var g=this._getUnselectedItems();var h=g.indexOf(i)-1;if(h<0){return null;}return g[h];};f.prototype._getNextTraversalItem=function(){var i=this._getItemsStartingText(this.getValue());var s=this._getUnselectedItems();if(i.indexOf(this._oTraversalItem)>-1&&this._oTraversalItem.getText()===this.getValue()){return this._getNextUnselectedItemOf(this._oTraversalItem);}if(i.length&&i[0].getText()===this.getValue()){return this._getNextUnselectedItemOf(i[0]);}return i.length?i[0]:s[0];};f.prototype._getPreviousTraversalItem=function(){var i=this._getItemsStartingText(this.getValue());if(i.indexOf(this._oTraversalItem)>-1&&this._oTraversalItem.getText()===this.getValue()){return this._getPreviousUnselectedItemOf(this._oTraversalItem);}if(i.length&&i[i.length-1].getText()===this.getValue()){return this._getPreviousUnselectedItemOf(i[i.length-1]);}if(i.length){return i[i.length-1];}else{var s=this._getUnselectedItems();if(s.length>0){return s[s.length-1];}else{return null;}}};f.prototype.findFirstEnabledItem=function(g){g=g||this.getItems();for(var i=0;i<g.length;i++){if(g[i].getEnabled()){return g[i];}}return null;};f.prototype.getVisibleItems=function(){for(var i=0,o,g=this.getItems(),v=[];i<g.length;i++){o=this.getListItem(g[i]);if(o&&o.getVisible()){v.push(g[i]);}}return v;};f.prototype.findLastEnabledItem=function(i){i=i||this.getItems();return this.findFirstEnabledItem(i.reverse());};f.prototype.setSelectedItems=function(i){this.removeAllSelectedItems();if(!i||!i.length){return this;}if(!q.isArray(i)){q.sap.log.warning("Warning: setSelectedItems() has to be an array of sap.ui.core.Item instances or of valid sap.ui.core.Item IDs",this);return this;}i.forEach(function(o){if(!(o instanceof sap.ui.core.Item)&&(typeof o!=="string")){q.sap.log.warning("Warning: setSelectedItems() has to be an array of sap.ui.core.Item instances or of valid sap.ui.core.Item IDs",this);return;}if(typeof o==="string"){o=sap.ui.getCore().byId(o);}this.setSelection({item:o?o:null,id:o?o.getId():"",key:o?o.getKey():"",suppressInvalidate:true});},this);return this;};f.prototype.addSelectedItem=function(i){if(!i){return this;}if(typeof i==="string"){i=sap.ui.getCore().byId(i);}this.setSelection({item:i?i:null,id:i?i.getId():"",key:i?i.getKey():"",fireChangeEvent:false,suppressInvalidate:true});return this;};f.prototype.removeSelectedItem=function(i){if(!i){return null;}if(typeof i==="string"){i=sap.ui.getCore().byId(i);}if(!this.isItemSelected(i)){return null;}this.removeSelection({item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:false,suppressInvalidate:true});return i;};f.prototype.removeAllSelectedItems=function(){var i=[];var g=this.getAssociation("selectedItems",[]);g.forEach(function(o){var h=this.removeSelectedItem(o);if(h){i.push(h.getId());}},this);return i;};f.prototype.removeSelectedKeys=function(k){var i=[],g;if(!k||!k.length||!q.isArray(k)){return i;}var o;k.forEach(function(K){o=this.getItemByKey(K);if(o){this.removeSelection({item:o?o:null,id:o?o.getId():"",key:o?o.getKey():"",fireChangeEvent:false,suppressInvalidate:true});i.push(o);}if(this._aCustomerKeys.length&&(g=this._aCustomerKeys.indexOf(K))>-1){this._aCustomerKeys.splice(g,1);}},this);return i;};f.prototype.setSelectedKeys=function(k){this.removeAllSelectedItems();this._aCustomerKeys=[];this.addSelectedKeys(k);return this;};f.prototype.addSelectedKeys=function(k){k=this.validateProperty("selectedKeys",k);k.forEach(function(K){var i=this.getItemByKey(K);if(i){this.addSelectedItem(i);}else if(K!=null){this._aCustomerKeys.push(K);}},this);return this;};f.prototype.getSelectedKeys=function(){var i=this.getSelectedItems()||[],k=[];i.forEach(function(o){k.push(o.getKey());},this);if(this._aCustomerKeys.length){k=k.concat(this._aCustomerKeys);}return k;};f.prototype._getUnselectedItems=function(){return q(this.getSelectableItems()).not(this.getSelectedItems()).get();};f.prototype.getSelectedItems=function(){var i=[],g=this.getAssociation("selectedItems")||[];g.forEach(function(s){var o=sap.ui.getCore().byId(s);if(o){i.push(o);}},this);return i;};f.prototype.getSelectableItems=function(){return this.getEnabledItems(this.getVisibleItems());};f.prototype.getWidth=function(){return this.getProperty("width")||"100%";};f.prototype.setEditable=function(g){a.prototype.setEditable.apply(this,arguments);this._oTokenizer.setEditable(g);return this;};f.prototype.clearFilter=function(){this.getItems().forEach(function(i){this.getListItem(i).setVisible(i.getEnabled()&&this.getSelectable(i));},this);};f.prototype._isListInSuggestMode=function(){return this.getList().getItems().some(function(o){return!o.getVisible()&&this._getItemByListItem(o).getEnabled();},this);};f.prototype._mapItemToListItem=function(i){if(!i){return null;}var s=this.getRenderer().CSS_CLASS_MULTICOMBOBOX+"Item";var g=(this.isItemSelected(i))?s+"Selected":"";var o=new sap.m.StandardListItem({type:sap.m.ListType.Active,visible:i.getEnabled()}).addStyleClass(s+" "+g);o.setTooltip(i.getTooltip());i.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"ListItem",o);o.setTitle(i.getText());if(g){var t=new sap.m.Token({key:i.getKey()});t.setText(i.getText());t.setTooltip(i.getText());i.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Token",t);this._oTokenizer.addToken(t);}this.setSelectable(i,i.getEnabled());this._decorateListItem(o);return o;};f.prototype._findMappedItem=function(o,g){for(var i=0,g=g||this.getItems(),h=g.length;i<h;i++){if(this.getListItem(g[i])===o){return g[i];}}return null;};f.prototype.setSelectable=function(i,s){if(this.indexOfItem(i)<0){return;}i._bSelectable=s;var o=this.getListItem(i);if(o){o.setVisible(s);}var t=this._getTokenByItem(i);if(t){t.setVisible(s);}};f.prototype.getSelectable=function(i){return i._bSelectable;};f.prototype._fillList=function(g){if(!g){return null;}if(!this._oListItemEnterEventDelegate){this._oListItemEnterEventDelegate={onsapenter:function(j){if(j.srcControl.isSelected()){j.setMarked();}}};}for(var i=0,o,h=g.length;i<h;i++){o=this._mapItemToListItem(g[i]);o.removeEventDelegate(this._oListItemEnterEventDelegate);o.addDelegate(this._oListItemEnterEventDelegate,true,this,true);this.getList().addAggregation("items",o,true);if(this.isItemSelected(g[i])){this.getList().setSelectedItem(o,true);}}};f.prototype._handleInputValidation=function(o,g){var v=o.target.value,i,V,h,r,u,s;var j=g?q(o.target).control(0):o.srcControl;i=this._getItemsStartingText(v,true);V=!!i.length;if(!V&&v!==""){u=g?this._sComposition:(this._sOldValue||"");j.updateDomValue(u);if(this._iOldCursorPos){q(j.getFocusDomRef()).cursorPos(this._iOldCursorPos);}this._showWrongValueVisualEffect();return;}h=this.getEnabledItems();r=this._sOldInput&&this._sOldInput.length>v.length;if(this.isPickerDialog()){s=this._getFilterSelectedButton();if(s!=null&&s.getPressed()){s.setPressed(false);}}if(r){h=this.getItems();}this.filterItems(h,v);if((!this.getValue()||!V)&&!this.bOpenedByKeyboardOrButton&&!this.isPickerDialog()){this.close();}else{this.open();}this._sOldInput=v;};f.prototype.init=function(){C.prototype.init.apply(this,arguments);this.createList();this.bItemsUpdated=false;this._bListItemNavigationInvalidated=false;this._iInitialItemFocus=-1;this._bCheckBoxClicked=true;this._bPreventValueRemove=false;this.setPickerType(sap.ui.Device.system.phone?"Dialog":"Dropdown");this._oTokenizer=this._createTokenizer();this._aCustomerKeys=[];this._aInitiallySelectedItems=[];this._bCompositionStart=false;this._bCompositionEnd=false;this._sComposition="";this.attachBrowserEvent("compositionstart",function(){this._bCompositionStart=true;this._bCompositionEnd=false;},this);this.attachBrowserEvent("compositionend",function(o){this._bCompositionStart=false;this._bCompositionEnd=true;this._handleInputValidation(o,true);this._bCompositionEnd=false;this._sComposition=o.target.value;},this);};f.prototype.clearSelection=function(){this.removeAllSelectedItems();};f.prototype.addItem=function(i){this.addAggregation("items",i);if(i){i.attachEvent("_change",this.onItemChange,this);}if(this.getList()){this.getList().addItem(this._mapItemToListItem(i));}return this;};f.prototype.insertItem=function(i,g){this.insertAggregation("items",i,g,true);if(i){i.attachEvent("_change",this.onItemChange,this);}if(this.getList()){this.getList().insertItem(this._mapItemToListItem(i),g);}return this;};f.prototype.getEnabledItems=function(i){i=i||this.getItems();return i.filter(function(o){return o.getEnabled();});};f.prototype.getItemByKey=function(k){return this.findItem("key",k);};f.prototype.removeItem=function(i){i=this.removeAggregation("items",i);if(this.getList()){this.getList().removeItem(i&&this.getListItem(i));}this.removeSelection({item:i,id:i?i.getId():"",key:i?i.getKey():"",fireChangeEvent:false,suppressInvalidate:true,listItemUpdated:true});return i;};f.prototype.isItemSelected=function(i){return this.getSelectedItems().indexOf(i)>-1;};f.prototype.findItem=function(p,v){var m="get"+p.charAt(0).toUpperCase()+p.slice(1);for(var i=0,g=this.getItems();i<g.length;i++){if(g[i][m]()===v){return g[i];}}return null;};f.prototype._clearTokenizer=function(){this._oTokenizer.destroyAggregation("tokens",true);};f.prototype.getList=function(){return this._oList;};f.prototype.exit=function(){a.prototype.exit.apply(this,arguments);if(this.getList()){this.getList().destroy();this._oList=null;}if(this._oTokenizer){this._oTokenizer.destroy();this._oTokenizer=null;}};f.prototype.destroyItems=function(){this.destroyAggregation("items");if(this.getList()){this.getList().destroyItems();}this._oTokenizer.destroyTokens();return this;};f.prototype.removeAllItems=function(){var i=this.removeAllAggregation("items");this.removeAllSelectedItems();if(this.getList()){this.getList().removeAllItems();}return i;};f.prototype._getItemByListItem=function(o){return this._getItemBy(o,"ListItem");};f.prototype._getItemByToken=function(t){return this._getItemBy(t,"Token");};f.prototype._getItemBy=function(o,s){s=this.getRenderer().CSS_CLASS_COMBOBOXBASE+s;for(var i=0,g=this.getItems(),h=g.length;i<h;i++){if(g[i].data(s)===o){return g[i];}}return null;};f.prototype.getListItem=function(i){return i?i.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"ListItem"):null;};f.prototype.getAccessibilityInfo=function(){var t=this.getSelectedItems().map(function(o){return o.getText();}).join(" ");var i=a.prototype.getAccessibilityInfo.apply(this,arguments);i.type=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_MULTICOMBO");i.description=((i.description||"")+" "+t).trim();return i;};return f;},true);
