/*
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./Button','./Dialog','./InputListItem','./List','./Toolbar','sap/ui/base/ManagedObject'],function(q,B,D,I,L,T,M){"use strict";var a=M.extend("sap.m.TablePersoDialog",{constructor:function(i,s){M.apply(this,arguments);},metadata:{properties:{"contentWidth":{type:"sap.ui.core.CSSSize"},"contentHeight":{type:"sap.ui.core.CSSSize",since:"1.22"},"persoMap":{type:"object"},"columnInfoCallback":{type:"object",since:"1.22"},"initialColumnState":{type:"object",since:"1.22"},"hasGrouping":{type:"boolean",since:"1.22"},"showSelectAll":{type:"boolean",since:"1.22"},"showResetAll":{type:"boolean",since:"1.22"}},aggregations:{"persoService":{type:"Object",multiple:false,deprecated:true}},associations:{"persoDialogFor":"sap.m.Table"},events:{confirm:{},cancel:{}},library:"sap.m"}});a.prototype.init=function(){var t=this,l=0;this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._oP13nModel=new sap.ui.model.json.JSONModel();this._oP13nModel.setSizeLimit(Number.MAX_VALUE);this._fnUpdateCheckBoxes=q.proxy(function(e){var s=e.getParameter('selected'),d=this._oP13nModel.getData();if(e.getSource().getId()===this._getSelectAllCheckboxId()){d.aColumns.forEach(function(c){c.visible=s;});}else{var S=!d.aColumns.some(function(c){return!c.visible;});d.oHeader.visible=S;}this._oP13nModel.setData(d);},this);this._oColumnItemTemplate=new I({label:"{Personalization>text}",content:new sap.m.CheckBox({selected:"{Personalization>visible}",select:this._fnUpdateCheckBoxes})}).addStyleClass("sapMPersoDialogLI");this._oButtonUp=new B({icon:"sap-icon://arrow-top",enabled:false,tooltip:t._oRb.getText('PERSODIALOG_UP'),press:function(){t._moveItem(-1);}});this._oButtonDown=new B({icon:"sap-icon://arrow-bottom",enabled:false,tooltip:t._oRb.getText('PERSODIALOG_DOWN'),press:function(){t._moveItem(1);}});this._fnHandleResize=function(){if(t._oDialog){var $=t._oDialog.$("cont");var b=t._oDialog.$("scroll");if($.children().length>0){var c=$.children()[0].clientHeight;var p=b[0].clientHeight-c;var h=t.getShowSelectAll()?t._oSelectAllToolbar.$().outerHeight():0;t._oScrollContainer.setHeight((c-h-p)+'px');}}};this._fnUpdateArrowButtons=function(u){var b=true,c=true,v=t._oSearchField.getValue(),i=t._oList.getItems().length;if(!!v||t._oList.getSelectedItems().length===0){c=false;b=false;}else{if(t._oList.getItems()[0].getSelected()){c=false;if(u){q.sap.focus(t._oButtonDown.getDomRef());}}if(t._oList.getItems()[i-1].getSelected()){b=false;if(u){q.sap.focus(t._oButtonUp.getDomRef());}}}t._oButtonUp.setEnabled(c);t._oButtonDown.setEnabled(b);};this._fnListUpdateFinished=function(){var b=t._oList.$().find('.sapMCb'),c=b.length;for(var i=0;i<c;i++){var $=q(b[i]).parent(),s=$.siblings(),d=s.length==1?q(s[0]):null;if(d){$=$.detach();$[0].className='sapMLIBSelectM';$.insertBefore(d);}}if(t._sLastSelectedItemId){var f=function(o){var r=(o.getBindingContext('Personalization')&&o.getBindingContext('Personalization').getProperty('id')===t._sLastSelectedItemId);if(r){t._oList.setSelectedItem(o);}return r;};t._oList.getItems().some(f);t._sLastSelectedItemId=null;if(t._fnUpdateArrowButtons){t._fnUpdateArrowButtons.call(this);}}};this._fnAfterDialogOpen=function(){t._fnUpdateArrowButtons.call(t);};this._fnAfterScrollContainerRendering=function(){t._oScrollContainer.$().attr('tabindex','-1');};this._oList=new L({includeItemInSelection:true,noDataText:this._oRb.getText('PERSODIALOG_NO_DATA'),mode:sap.m.ListMode.SingleSelectMaster,selectionChange:function(){this._fnUpdateArrowButtons.call(this);}.bind(this),updateFinished:this._fnListUpdateFinished});this._oList.addDelegate({onAfterRendering:this._fnListUpdateFinished});this._oSearchField=new sap.m.SearchField(this.getId()+"-searchField",{width:"100%",liveChange:function(e){var v=e.getSource().getValue(),d=(v?300:0);clearTimeout(l);if(d){l=setTimeout(function(){t._executeSearch();},d);}else{t._executeSearch();}},search:function(){t._executeSearch();}});this._oScrollContainer=new sap.m.ScrollContainer({horizontal:false,vertical:true,content:[this._oList],width:'100%'});this._oScrollContainer.addDelegate({onAfterRendering:this._fnAfterScrollContainerRendering});this._resetAllButton=new B({icon:"sap-icon://undo",tooltip:this._oRb.getText('PERSODIALOG_UNDO'),press:function(){this._resetAll();}.bind(this)}).addStyleClass("sapMPersoDialogResetBtn");this._oSelectAllCheckbox=new sap.m.CheckBox(this._getSelectAllCheckboxId(),{selected:"{Personalization>/oHeader/visible}",select:this._fnUpdateCheckBoxes,text:"{Personalization>/oHeader/text}"}).addStyleClass("sapMPersoDialogSelectAllCb");this._oSelectAllToolbar=new T({active:false,design:sap.m.ToolbarDesign.Transparent,content:[this._oSelectAllCheckbox,this._resetAllButton]}).addStyleClass("sapMPersoDialogFixedBar");this._oDialog=new D({title:this._oRb.getText("PERSODIALOG_COLUMNS_TITLE"),stretch:sap.ui.Device.system.phone,horizontalScrolling:false,verticalScrolling:false,initialFocus:(sap.ui.Device.system.desktop?this._oList:null),content:[this._oSelectAllToolbar,this._oScrollContainer],subHeader:new T({active:false,content:[this._oButtonUp,this._oButtonDown,this._oSearchField]}),leftButton:new B({text:this._oRb.getText("PERSODIALOG_OK"),press:function(){t._oDialog.close();t._oSearchField.setValue("");t._oSelectAllToolbar.setVisible(true);sap.ui.Device.resize.detachHandler(t._fnHandleResize);t.fireConfirm();}}),rightButton:new B({text:this._oRb.getText("PERSODIALOG_CANCEL"),press:function(){t._oDialog.close();t._oSearchField.setValue("");t._oSelectAllToolbar.setVisible(true);sap.ui.Device.resize.detachHandler(t._fnHandleResize);t.fireCancel();}}),afterOpen:this._fnAfterDialogOpen}).addStyleClass("sapMPersoDialog");};a.prototype.retrievePersonalizations=function(){return this._oP13nModel.getData();};a.prototype.open=function(){var s=null;if(this.getHasGrouping()){s=[new sap.ui.model.Sorter('group',false,true)];}this._readCurrentSettingsFromTable();this._oDialog.setModel(this._oP13nModel,"Personalization");this._oList.bindAggregation("items",{path:"Personalization>/aColumns",sorter:s,template:this._oColumnItemTemplate});if(!this._oList.getSelectedItem()){var i=this._oList.getItems();if(this.getHasGrouping()){i=i.filter(function(o){return o.getMetadata().getName()!="sap.m.GroupHeaderListItem";});}if(i.length>0){this._sLastSelectedItemId=i[0].getBindingContext('Personalization').getProperty('id');}}this._fnUpdateArrowButtons.call(this);this._oDialog.open();this._fnHandleResize.call(this);sap.ui.Device.resize.attachHandler(this._fnHandleResize);};a.prototype.setContentHeight=function(h){this.setProperty("contentHeight",h,true);this._oDialog.setContentHeight(h);return this;};a.prototype.setContentWidth=function(w){this.setProperty("contentWidth",w,true);this._oDialog.setContentWidth(w);return this;};a.prototype.exit=function(){this._oRb=null;this._oP13nModel=null;if(this._oColumnItemTemplate){this._oColumnItemTemplate.destroy();this._oColumnItemTemplate=null;}if(this._oSelectAllToolbar){this._oSelectAllToolbar.destroy();this._oSelectAllToolbar=null;}if(this._oList){this._oList.destroy();this._oList=null;}if(this._oSearchField){this._oSearchField.destroy();this._oSearchField=null;}if(this._oScrollContainer){this._oScrollContainer.destroy();this._oScrollContainer=null;}if(this._oDialog){this._oDialog.destroy();this._oDialog=null;}if(this._oButtonDown){this._oButtonDown.destroy();this._oButtonDown=null;}if(this._oButtonUp){this._oButtonUp.destroy();this._oButtonUp=null;}};a.prototype._resetAll=function(){if(this.getInitialColumnState()){var i=q.extend(true,[],this.getInitialColumnState()),t=this;var l=this._oList.getSelectedItem();this._sLastSelectedItemId=l&&l.getBindingContext('Personalization')&&l.getBindingContext('Personalization').getProperty('id');if(!!this._mColumnCaptions){i.forEach(function(c){c.text=t._mColumnCaptions[c.id];});}this._oP13nModel.getData().aColumns=i;this._oP13nModel.getData().oHeader.visible=!this.getInitialColumnState().some(function(c){return!c.visible;});this._oP13nModel.updateBindings();sap.ui.getCore().applyChanges();}};a.prototype._moveItem=function(d){var s=this._oList.getSelectedItem();if(!s){return;}var o=this._oP13nModel.getData();var i=s.getBindingContext("Personalization").getPath().split("/").pop()*1;var b=i+d;if(b<0||b>=o.aColumns.length){return;}var t=o.aColumns[b];o.aColumns[b]=o.aColumns[i];o.aColumns[b].order=b;o.aColumns[i]=t;o.aColumns[i].order=i;this._oList.removeSelections(true);this._oP13nModel.updateBindings();var S=this._oList.getItems()[b];this._oList.setSelectedItem(S,true);sap.ui.getCore().applyChanges();if(!!S.getDomRef()){var e=S.$().position().top,m=18,v=this._oScrollContainer.$().height(),V=this._oScrollContainer.$().offset().top-this._oList.$().offset().top,c=V+v;if(e<V){this._oScrollContainer.scrollTo(0,Math.max(0,V-v+m));}else if(e+m>c){this._oScrollContainer.scrollTo(0,e);}}this._fnUpdateArrowButtons.call(this,true);};a.prototype._readCurrentSettingsFromTable=function(){var t=sap.ui.getCore().byId(this.getPersoDialogFor()),b=this,c=this.getColumnInfoCallback().call(this,t,this.getPersoMap());this._oP13nModel.setData({aColumns:c,oHeader:{text:this._oRb.getText("PERSODIALOG_SELECT_ALL"),visible:!c.some(function(C){return!C.visible;}),id:this._getSelectAllCheckboxId()}});this._mColumnCaptions={};c.forEach(function(C){b._mColumnCaptions[C.id]=C.text;});};a.prototype._getSelectAllCheckboxId=function(){return this.getId()+'_SelectAll';};a.prototype._executeSearch=function(){var v=this._oSearchField.getValue(),f=new sap.ui.model.Filter("text",sap.ui.model.FilterOperator.Contains,v),b=this._oList.getBinding("items");this._oSelectAllToolbar.setVisible(!v&&this.getShowSelectAll());b.filter([f]);this._fnUpdateArrowButtons.call(this);return this;};a.prototype.setHasGrouping=function(h){this.setProperty("hasGrouping",h,true);var b=this._oDialog.getSubHeader();if(!h){if(b.getContent().length===1){b.insertContent(this._oButtonDown,0);b.insertContent(this._oButtonUp,0);}}else{b.removeContent(this._oButtonUp);b.removeContent(this._oButtonDown);}return this;};a.prototype.setShowSelectAll=function(s){this.setProperty("showSelectAll",s,true);this._oSelectAllToolbar.setVisible(s);this._fnHandleResize.call(this);return this;};a.prototype.setShowResetAll=function(s){this.setProperty("showResetAll",s,true);this._resetAllButton.setVisible(s);return this;};return a;},true);
