/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/m/library","./MessageBox","./Dialog","./library","sap/ui/core/Control","sap/ui/core/Icon","sap/ui/core/IconPool","sap/m/Image","sap/m/Text","sap/m/List","sap/ui/unified/FileUploaderParameter","sap/ui/unified/FileUploader","sap/ui/core/format/FileSizeFormat","sap/m/Link","sap/m/OverflowToolbar","./ObjectAttribute","./ObjectStatus","./UploadCollectionItem","sap/ui/core/HTML","./BusyIndicator","./CustomListItem","sap/ui/core/ResizeHandler","sap/ui/Device","./CustomListItemRenderer","sap/ui/core/HTMLRenderer","./LinkRenderer","./ObjectAttributeRenderer","./ObjectStatusRenderer","./ObjectMarkerRenderer","./TextRenderer","./DialogRenderer"],function(q,M,a,D,L,C,I,b,c,T,d,F,f,g,h,O,k,l,U,H,B,m,R,n){"use strict";var o=C.extend("sap.m.UploadCollection",{constructor:function(i,s){var j;if(s&&s.instantUpload===false){j=s.instantUpload;delete s.instantUpload;}else if(i&&i.instantUpload===false){j=i.instantUpload;delete i.instantUpload;}if(s&&s.mode===sap.m.ListMode.MultiSelect&&j===false){s.mode=sap.m.ListMode.None;q.sap.log.info("sap.m.ListMode.MultiSelect is not supported by UploadCollection for Upload Pending scenario. Value has been resetted to 'None'");}else if(i&&i.mode===sap.m.ListMode.MultiSelect&&j===false){i.mode=sap.m.ListMode.None;q.sap.log.info("sap.m.ListMode.MultiSelect is not supported by UploadCollection for Upload Pending scenario. Value has been resetted to 'None'");}try{C.apply(this,arguments);if(j===false){this.bInstantUpload=j;this._oFormatDecimal=g.getInstance({binaryFilesize:false,maxFractionDigits:1,maxIntegerDigits:3});}}catch(e){this.destroy();throw e;}},metadata:{library:"sap.m",properties:{fileType:{type:"string[]",group:"Data",defaultValue:null},maximumFilenameLength:{type:"int",group:"Data",defaultValue:null},maximumFileSize:{type:"float",group:"Data",defaultValue:null},mimeType:{type:"string[]",group:"Data",defaultValue:null},multiple:{type:"boolean",group:"Behavior",defaultValue:false},noDataText:{type:"string",group:"Appearance",defaultValue:null},noDataDescription:{type:"string",group:"Appearance",defaultValue:null},sameFilenameAllowed:{type:"boolean",group:"Behavior",defaultValue:false},showSeparators:{type:"sap.m.ListSeparators",group:"Appearance",defaultValue:"All"},uploadEnabled:{type:"boolean",group:"Behavior",defaultValue:true},uploadUrl:{type:"string",group:"Data",defaultValue:"../../../upload"},instantUpload:{type:"boolean",group:"Behavior",defaultValue:true},numberOfAttachmentsText:{type:"string",group:"Appearance",defaultValue:null},mode:{type:"sap.m.ListMode",group:"Behavior",defaultValue:"None"},uploadButtonInvisible:{type:"boolean",group:"Appearance",defaultValue:false},terminationEnabled:{type:"boolean",group:"Behavior",defaultValue:true}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.UploadCollectionItem",multiple:true,singularName:"item",bindable:"bindable"},headerParameters:{type:"sap.m.UploadCollectionParameter",multiple:true,singularName:"headerParameter"},parameters:{type:"sap.m.UploadCollectionParameter",multiple:true,singularName:"parameter"},toolbar:{type:"sap.m.OverflowToolbar",multiple:false},infoToolbar:{type:"sap.m.Toolbar",multiple:false},_list:{type:"sap.m.List",multiple:false,visibility:"hidden"},_noDataIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_dragDropIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_dragDropText:{type:"sap.m.Text",multiple:false,visibility:"hidden"}},events:{change:{parameters:{documentId:{type:"string"},files:{type:"object[]"}}},fileDeleted:{parameters:{documentId:{type:"string"},item:{type:"sap.m.UploadCollectionItem"}}},filenameLengthExceed:{parameters:{documentId:{type:"string"},files:{type:"object[]"}}},fileRenamed:{parameters:{documentId:{type:"string"},fileName:{type:"string"},item:{type:"sap.m.UploadCollectionItem"}}},fileSizeExceed:{parameters:{documentId:{type:"string"},fileSize:{type:"string"},files:{type:"object[]"}}},typeMissmatch:{parameters:{documentId:{type:"string"},fileType:{type:"string"},mimeType:{type:"string"},files:{type:"object[]"}}},uploadComplete:{parameters:{readyStateXHR:{type:"string"},response:{type:"string"},status:{type:"string"},files:{type:"object[]"}}},uploadTerminated:{parameters:{fileName:{type:"string"},getHeaderParameter:{type:"function",parameters:{headerParameterName:{type:"string"}}}}},beforeUploadStarts:{parameters:{fileName:{type:"string"},addHeaderParameter:{type:"function",parameters:{headerParameter:{type:"sap.m.UploadCollectionParameter"}}},getHeaderParameter:{type:"function",parameters:{headerParameterName:{type:"string"}}}}},selectionChange:{parameters:{selectedItem:{type:"sap.m.UploadCollectionItem"},selectedItems:{type:"sap.m.UploadCollectionItem[]"},selected:{type:"boolean"}}}}}});o._uploadingStatus="uploading";o._displayStatus="display";o._toBeDeletedStatus="toBeDeleted";o._pendingUploadStatus="pendingUploadStatus";o._placeholderCamera="sap-icon://card";o._markerMargin=8;if(n.system.phone){o._resizeTimeoutInterval=500;}else{o._resizeTimeoutInterval=100;}o.prototype.init=function(){o.prototype._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._headerParamConst={requestIdName:"requestId"+q.now(),fileNameRequestIdName:"fileNameRequestId"+q.now()};this._requestIdValue=0;this._iFUCounter=0;this._oList=new d(this.getId()+"-list",{selectionChange:[this._handleSelectionChange,this]});this.setAggregation("_list",this._oList,true);this._oList.addStyleClass("sapMUCList");this.setAggregation("_noDataIcon",new I(this.getId()+"-no-data-icon",{src:"sap-icon://document",size:"6rem",noTabStop:true}),true);this.setAggregation("_dragDropIcon",new I(this.getId()+"-drag-drop-icon",{src:"sap-icon://upload-to-cloud",size:"4rem",noTabStop:true}),true);this.setAggregation("_dragDropText",new T(this.getId()+"-drag-drop-text",{text:this._oRb.getText("UPLOADCOLLECTION_DRAG_FILE_INDICATOR")}),true);this._iUploadStartCallCounter=0;this.aItems=[];this._aDeletedItemForPendingUpload=[];this._aFileUploadersForPendingUpload=[];this._aFilesFromDragAndDropForPendingUpload=[];this._iFileUploaderPH=null;this._oListEventDelegate=null;this._oItemToUpdate=null;this._sReziseHandlerId=null;};o.prototype.setFileType=function(e){if(!e){return this;}if(!this.getInstantUpload()){q.sap.log.info("As property instantUpload is false it is not allowed to change fileType at runtime.");}else{var j=e.length;for(var i=0;i<j;i++){e[i]=e[i].toLowerCase();}this.setProperty("fileType",e);if(this._getFileUploader().getFileType()!==e){this._getFileUploader().setFileType(e);}}return this;};o.prototype.setMaximumFilenameLength=function(i){if(!this.getInstantUpload()){q.sap.log.info("As property instantUpload is false it is not allowed to change maximumFilenameLength at runtime.");}else{this.setProperty("maximumFilenameLength",i,true);if(this._getFileUploader().getMaximumFilenameLength()!==i){this._getFileUploader().setMaximumFilenameLength(i);}}return this;};o.prototype.setMaximumFileSize=function(i){if(!this.getInstantUpload()){q.sap.log.info("As property instantUpload is false it is not allowed to change maximumFileSize at runtime.");}else{this.setProperty("maximumFileSize",i,true);if(this._getFileUploader().getMaximumFileSize()!==i){this._getFileUploader().setMaximumFileSize(i);}}return this;};o.prototype.setMimeType=function(e){if(!this.getInstantUpload()){q.sap.log.info("As property instantUpload is false it is not allowed to change mimeType at runtime.");}else{this.setProperty("mimeType",e);if(this._getFileUploader().getMimeType()!==e){this._getFileUploader().setMimeType(e);}}return this;};o.prototype.setMultiple=function(e){if(!this.getInstantUpload()){q.sap.log.info("As property instantUpload is false it is not allowed to change multiple at runtime.");}else{this.setProperty("multiple",e);if(this._getFileUploader().getMultiple()!==e){this._getFileUploader().setMultiple(e);}}return this;};o.prototype.setShowSeparators=function(s){this.setProperty("showSeparators",s);if(this._oList.getShowSeparators()!==s){this._oList.setShowSeparators(s);}return this;};o.prototype.setUploadEnabled=function(u){if(!this.getInstantUpload()){q.sap.log.info("As property instantUpload is false it is not allowed to change uploadEnabled at runtime.");}else{this.setProperty("uploadEnabled",u);if(this._getFileUploader().getEnabled()!==u){this._getFileUploader().setEnabled(u);}}return this;};o.prototype.setUploadUrl=function(u){if(!this.getInstantUpload()){q.sap.log.info("As property instantUpload is false it is not allowed to change uploadUrl at runtime.");}else{this.setProperty("uploadUrl",u);if(this._getFileUploader().getUploadUrl()!==u){this._getFileUploader().setUploadUrl(u);}}return this;};o.prototype.setInstantUpload=function(){q.sap.log.error("It is not supported to change the behavior at runtime.");return this;};o.prototype.setMode=function(e){if(e===sap.m.ListMode.Delete){this._oList.setMode(sap.m.ListMode.None);q.sap.log.info("sap.m.ListMode.Delete is not supported by UploadCollection. Value has been resetted to 'None'");}else if(e===sap.m.ListMode.MultiSelect&&!this.getInstantUpload()){this._oList.setMode(sap.m.ListMode.None);q.sap.log.info("sap.m.ListMode.MultiSelect is not supported by UploadCollection for Pending Upload. Value has been resetted to 'None'");}else{this._oList.setMode(e);}return this;};o.prototype.getMode=function(){return this._oList.getMode();};o.prototype.getToolbar=function(){return this._oHeaderToolbar;};o.prototype.getInfoToolbar=function(){return this._oList.getAggregation("infoToolbar");};o.prototype.getNoDataText=function(){var N=this.getProperty("noDataText");N=N||this._oRb.getText("UPLOADCOLLECTION_NO_DATA_TEXT");return N;};o.prototype.getNoDataDescription=function(){var N=this.getProperty("noDataDescription");N=N||this._oRb.getText("UPLOADCOLLECTION_NO_DATA_DESCRIPTION");return N;};o.prototype.setInfoToolbar=function(i){if(this.getInfoToolbar()!==i){this._oList.setAggregation("infoToolbar",i,false);}};o.prototype.setUploadButtonInvisible=function(u){if(this.getUploadButtonInvisible()===u){return this;}this.setProperty("uploadButtonInvisible",u,true);if(this.getInstantUpload()){this._getFileUploader().setVisible(!u);}else{this._setFileUploaderVisibility(u);}if(this._bDragDropEnabled){this._unbindDragEnterLeave();this._bDragDropEnabled=false;}else{this._bindDragEnterLeave();}return this;};o.prototype.getInternalRequestHeaderNames=function(){return[this._headerParamConst.fileNameRequestIdName,this._headerParamConst.requestIdName];};o.prototype.upload=function(){if(this.getInstantUpload()){q.sap.log.error("Not a valid API call. 'instantUpload' should be set to 'false'.");}var e=this._aFileUploadersForPendingUpload.length;for(var i=0;i<e;i++){this._iUploadStartCallCounter=0;if(this._aFileUploadersForPendingUpload[i].getValue()){this._aFileUploadersForPendingUpload[i].upload();}}if(this._aFilesFromDragAndDropForPendingUpload.length>0){this._oFileUploader._sendFilesFromDragAndDrop(this._aFilesFromDragAndDropForPendingUpload);this._aFilesFromDragAndDropForPendingUpload=[];}};o.prototype.getSelectedItems=function(){var s=this._oList.getSelectedItems();return this._getUploadCollectionItemsByListItems(s);};o.prototype.getSelectedItem=function(){var s=this._oList.getSelectedItem();if(s){return this._getUploadCollectionItemByListItem(s);}};o.prototype.setSelectedItemById=function(i,s){this._oList.setSelectedItemById(i+"-cli",s);this._setSelectedForItems([this._getUploadCollectionItemById(i)],s);return this;};o.prototype.setSelectedItem=function(u,s){return this.setSelectedItemById(u.getId(),s);};o.prototype.selectAll=function(){var s=this._oList.selectAll();if(s.getItems().length!==this.getItems().length){q.sap.log.info("Internal 'List' and external 'UploadCollection' are not in sync.");}this._setSelectedForItems(this.getItems(),true);return this;};o.prototype.downloadItem=function(u,e){if(!this.getInstantUpload()){q.sap.log.info("Download is not possible on Pending Upload mode");return false;}else{return u.download(e);}};o.prototype.openFileDialog=function(i){if(this._oFileUploader){if(i){if(!this._oFileUploader.getMultiple()){this._oItemToUpdate=i;this._oFileUploader.$().find("input[type=file]").trigger("click");}else{q.sap.log.warning("Version Upload cannot be used in multiple upload mode");}}else{this._oFileUploader.$().find("input[type=file]").trigger("click");}}return this;};o.prototype.removeAggregation=function(A,v,s){var e,i,j;if(!this.getInstantUpload()&&A==="items"&&v){e=v._internalFileIdWithinDragDropArray;if(e){i=this._aFilesFromDragAndDropForPendingUpload.indexOf(e);if(i!==-1){this._aFilesFromDragAndDropForPendingUpload.splice(i,1);}}else if(q.isNumeric(v)){j=this.getItems();this._aDeletedItemForPendingUpload.push(j[v]);}else{this._aDeletedItemForPendingUpload.push(v);}}return C.prototype.removeAggregation.apply(this,arguments);};o.prototype.removeAllAggregation=function(A,s){if(!this.getInstantUpload()&&A==="items"){if(this._aFileUploadersForPendingUpload){for(var i=0;i<this._aFileUploadersForPendingUpload.length;i++){this._aFileUploadersForPendingUpload[i].destroy();this._aFileUploadersForPendingUpload[i]=null;}this._aFileUploadersForPendingUpload=[];}}return C.prototype.removeAllAggregation.apply(this,arguments);};o.prototype.onBeforeRendering=function(){this._RenderManager=this._RenderManager||sap.ui.getCore().createRenderManager();var i,e;if(this._oListEventDelegate){this._oList.removeEventDelegate(this._oListEventDelegate);this._oListEventDelegate=null;}this._deregisterSizeHandler();this._unbindDragEnterLeave();j.bind(this)();if(!this.getInstantUpload()){this.aItems=this.getItems();this._getListHeader(this.aItems.length);this._clearList();this._fillList(this.aItems);this._oList.setHeaderToolbar(this._oHeaderToolbar);return;}if(this.aItems.length>0){e=this.aItems.length;var u=[];for(i=0;i<e;i++){if(this.aItems[i]&&this.aItems[i]._status===o._uploadingStatus){u.push(this.aItems[i]);}else if(this.aItems[i]&&this.aItems[i]._status!==o._uploadingStatus&&this.aItems[i]._percentUploaded===100&&this.getItems().length===0){u.push(this.aItems[i]);}}if(u.length!==0){this.aItems=[];this.aItems=this.getItems();this.aItems=u.concat(this.aItems);}else{this.aItems=this.getItems();}}else{this.aItems=this.getItems();}this._getListHeader(this.aItems.length);this._clearList();this._fillList(this.aItems);this._oList.setAggregation("headerToolbar",this._oHeaderToolbar,true);if((n.browser.msie&&n.browser.version<=9)&&this.aItems.length>0&&this.aItems[0]._status===o._uploadingStatus){this._oFileUploader.setEnabled(false);}else if(this.sErrorState!=="Error"){if(this.getUploadEnabled()!==this._oFileUploader.getEnabled()){this._oFileUploader.setEnabled(this.getUploadEnabled());}}else{this._oFileUploader.setEnabled(false);}if(this.sDeletedItemId){q(document.activeElement).blur();}function j(){if(this.bInstantUpload===false){this.setProperty("instantUpload",this.bInstantUpload,true);delete this.bInstantUpload;}}};o.prototype.onAfterRendering=function(){this._bindDragEnterLeave();if(this.getInstantUpload()){if(this.aItems||(this.aItems===this.getItems())){if(this.editModeItem){var $=q.sap.byId(this.editModeItem+"-ta_editFileName-inner");if($){var i=this.editModeItem;if(!n.os.ios){$.focus(function(){$.selectText(0,$.val().length);});}$.focus();this._oListEventDelegate={onclick:function(e){this._handleClick(e,i);}.bind(this)};this._oList.addDelegate(this._oListEventDelegate);}}else if(this.sFocusId){sap.m.UploadCollection.prototype._setFocusToLineItem(this.sFocusId);this.sFocusId=null;}else if(this.sDeletedItemId){this._setFocusAfterDeletion();}}}else if(this.sFocusId){sap.m.UploadCollection.prototype._setFocusToLineItem(this.sFocusId);this.sFocusId=null;}};o.prototype.exit=function(){var i,p,e;this._unbindDragEnterLeave();if(this._$RootNode){this._$RootNode=null;}if(this._oFileUploader){this._oFileUploader.destroy();this._oFileUploader=null;}if(this._oHeaderToolbar){this._oHeaderToolbar.destroy();this._oHeaderToolbar=null;}if(this._oNumberOfAttachmentsTitle){this._oNumberOfAttachmentsTitle.destroy();this._oNumberOfAttachmentsTitle=null;}if(this._RenderManager){this._RenderManager.destroy();}if(this._aFileUploadersForPendingUpload){p=this._aFileUploadersForPendingUpload.length;for(i=0;i<p;i++){this._aFileUploadersForPendingUpload[i].destroy();this._aFileUploadersForPendingUpload[i]=null;}this._aFileUploadersForPendingUpload=null;}for(i=0;i<this.aItems.length;i++){if(this.aItems[i]._status===o._uploadingStatus){e=this.aItems.splice(i,1)[0];if(e.destroy){e.destroy();}}}this._deregisterSizeHandler();};o.prototype._bindDragEnterLeave=function(){this._bDragDropEnabled=this._isDragAndDropAllowed();if(!this._bDragDropEnabled){return;}if(!this._oDragDropHandler){this._oDragDropHandler={dragEnterUIArea:this._onDragEnterUIArea.bind(this),dragLeaveUIArea:this._onDragLeaveUIArea.bind(this),dragOverUIArea:this._onDragOverUIArea.bind(this),dropOnUIArea:this._onDropOnUIArea.bind(this),dragEnterUploadCollection:this._onDragEnterUploadCollection.bind(this),dragLeaveUploadCollection:this._onDragLeaveUploadCollection.bind(this),dragOverUploadCollection:this._onDragOverUploadCollection.bind(this),dropOnUploadCollection:this._onDropOnUploadCollection.bind(this)};}this._$RootNode=q(document.body);this._$RootNode.bind("dragenter",this._oDragDropHandler.dragEnterUIArea);this._$RootNode.bind("dragleave",this._oDragDropHandler.dragLeaveUIArea);this._$RootNode.bind("dragover",this._oDragDropHandler.dragOverUIArea);this._$RootNode.bind("drop",this._oDragDropHandler.dropOnUIArea);this._$DragDropArea=this.$("drag-drop-area");this.$().bind("dragenter",this._oDragDropHandler.dragEnterUploadCollection);this.$().bind("dragleave",this._oDragDropHandler.dragLeaveUploadCollection);this.$().bind("dragover",this._oDragDropHandler.dragOverUploadCollection);this.$().bind("drop",this._oDragDropHandler.dropOnUploadCollection);};o.prototype._unbindDragEnterLeave=function(){if(!this._bDragDropEnabled&&!this._oDragDropHandler){return;}if(this._$RootNode){this._$RootNode.unbind("dragenter",this._oDragDropHandler.dragEnterUIArea);this._$RootNode.unbind("dragleave",this._oDragDropHandler.dragLeaveUIArea);this._$RootNode.unbind("dragover",this._oDragDropHandler.dragOverUIArea);this._$RootNode.unbind("drop",this._oDragDropHandler.dropOnUIArea);}this.$().unbind("dragenter",this._oDragDropHandler.dragEnterUploadCollection);this.$().unbind("dragleave",this._oDragDropHandler.dragLeaveUploadCollection);this.$().unbind("dragover",this._oDragDropHandler.dragOverUploadCollection);this.$().unbind("drop",this._oDragDropHandler.dropOnUploadCollection);};o.prototype._onDragEnterUIArea=function(e){if(!this._checkForFiles(e)){return;}this._oLastEnterUIArea=e.target;this._$DragDropArea.removeClass("sapMUCDragDropOverlayHide");this._adjustDragDropIcon();};o.prototype._onDragOverUIArea=function(e){e.preventDefault();if(!this._checkForFiles(e)){return;}this._$DragDropArea.removeClass("sapMUCDragDropOverlayHide");};o.prototype._onDragLeaveUIArea=function(e){if(this._oLastEnterUIArea===e.target){this._$DragDropArea.addClass("sapMUCDragDropOverlayHide");}};o.prototype._onDropOnUIArea=function(e){this._$DragDropArea.addClass("sapMUCDragDropOverlayHide");};o.prototype._onDragEnterUploadCollection=function(e){if(!this._checkForFiles(e)){return;}if(e.target===this._$DragDropArea[0]){this._$DragDropArea.addClass("sapMUCDropIndicator");this._adjustDragDropIcon();this.getAggregation("_dragDropText").setText(this._oRb.getText("UPLOADCOLLECTION_DROP_FILE_INDICATOR"));}};o.prototype._onDragOverUploadCollection=function(e){e.preventDefault();};o.prototype._onDragLeaveUploadCollection=function(e){if(e.target===this._$DragDropArea[0]){this._$DragDropArea.removeClass("sapMUCDropIndicator");this.getAggregation("_dragDropText").setText(this._oRb.getText("UPLOADCOLLECTION_DRAG_FILE_INDICATOR"));}};o.prototype._checkForFiles=function(e){var t=e.originalEvent.dataTransfer.types;if(t){for(var i=0;i<t.length;i++){if(t[i]==="Files"){return true;}}}return false;};o.prototype._isDragAndDropAllowed=function(){return this.getUploadEnabled()&&!this.getUploadButtonInvisible();};o.prototype._onDropOnUploadCollection=function(e){if(!this._checkForFiles(e)){e.preventDefault();return;}if(e.target===this._$DragDropArea[0]){e.preventDefault();this._$DragDropArea.removeClass("sapMUCDropIndicator");this._$DragDropArea.addClass("sapMUCDragDropOverlayHide");this.getAggregation("_dragDropText").setText(this._oRb.getText("UPLOADCOLLECTION_DRAG_FILE_INDICATOR"));var j=e.originalEvent.dataTransfer.files;if(j.length>1&&!this.getMultiple()){var s=this._oRb.getText("UPLOADCOLLECTION_MULTIPLE_FALSE");a.error(s);return;}if(!this._oFileUploader._areFilesAllowed(j)){return;}if(!this.getInstantUpload()){for(var i=0;i<j.length;i++){this._oFileUploader.fireChange({files:[j[i]],fromDragDrop:true});this._aFilesFromDragAndDropForPendingUpload.push(j[i]);}}else{this._oFileUploader.fireChange({files:j});this._oFileUploader._sendFilesFromDragAndDrop(j);}}};o.prototype._adjustDragDropIcon=function(){if(this._$DragDropArea[0].offsetHeight<160){this.getAggregation("_dragDropIcon").$().hide();}};o.prototype._deregisterSizeHandler=function(){n.orientation.detachHandler(this._onResize,this);R.deregister(this._sReziseHandlerId);};o.prototype._hideFileUploaders=function(){var t,i;if(!this.getInstantUpload()){t=this._oHeaderToolbar.getContent().length;if(this._aFileUploadersForPendingUpload.length){for(i=0;i<t;i++){if(this._oHeaderToolbar.getContent()[i]instanceof sap.ui.unified.FileUploader){if(i===this._iFileUploaderPH&&this._bFocusFileUploader){this._oHeaderToolbar.getContent()[i].$().find("button").focus();}else{this._oHeaderToolbar.getContent()[i].$().hide();}}}}}};o.prototype._truncateFileName=function(e){if(!e){return;}if(e._status==="Edit"){var s=e.getId()+"-cli";this.$().find("#"+s).find(".sapMUCObjectMarkerContainer").attr("style","display: none");return;}var j=0;var p=e.getMarkers();var S;for(var i=0;i<p.length;i++){j=j+p[i].$().width()+o._markerMargin;}if(j>0){var $=this.$().find("#"+e.getId()+"-ta_filenameHL");if($){S="max-width: calc(100% - "+j+"px)";if($.attr("style")!==S){$.attr("style",S);}}}};o.prototype._getListHeader=function(e){var j,i;this._setNumberOfAttachmentsTitle(e);if(!this._oHeaderToolbar){if(!!this._oFileUploader&&!this.getInstantUpload()){this._oFileUploader.destroy();}j=this._getFileUploader();this._oHeaderToolbar=this.getAggregation("toolbar");if(!this._oHeaderToolbar){this._oHeaderToolbar=new sap.m.OverflowToolbar(this.getId()+"-toolbar",{content:[this._oNumberOfAttachmentsTitle,new sap.m.ToolbarSpacer(),j]}).addEventDelegate({onAfterRendering:this._hideFileUploaders},this);this._iFileUploaderPH=2;}else{this._oHeaderToolbar.addEventDelegate({onAfterRendering:this._hideFileUploaders},this);this._iFileUploaderPH=this._getFileUploaderPlaceHolderPosition(this._oHeaderToolbar);if(this._oHeaderToolbar&&this._iFileUploaderPH>-1){this._setFileUploaderInToolbar(j);}else{q.sap.log.info("A place holder of type 'sap.m.UploadCollectionPlaceholder' needs to be provided.");}}}else if(!this.getInstantUpload()){var p=this._aFileUploadersForPendingUpload.length;for(i=p-1;i>=0;i--){if(this._aFileUploadersForPendingUpload[i].getId()===this._oFileUploader.getId()){j=this._getFileUploader();this._oHeaderToolbar.insertAggregation("content",j,this._iFileUploaderPH,true);break;}}}};o.prototype._getFileUploaderPlaceHolderPosition=function(t){for(var i=0;i<t.getContent().length;i++){if(t.getContent()[i]instanceof sap.m.UploadCollectionToolbarPlaceholder){return i;}}return-1;};o.prototype._setFileUploaderInToolbar=function(e){this._oHeaderToolbar.getContent()[this._iFileUploaderPH].setVisible(false);this._oHeaderToolbar.insertContent(e,this._iFileUploaderPH);};o.prototype._mapItemToListItem=function(i){if(!i||(this._oItemToUpdate&&i.getId()===this._oItemToUpdate.getId())){return null;}var s,S,e,j,p,r,$,t,u;s=i.getId();S=i._status;e=i.getFileName();if(S===o._uploadingStatus){j=i._getBusyIndicator?i._getBusyIndicator():i._getControl("sap.m.BusyIndicator",{id:s+"-ia_indicator"},"BusyIndicator").addStyleClass("sapMUCloadingIcon");}else{u=this._createIcon(i,s,e);}r=s+"-container";$=q.sap.byId(r);if($){$.remove();$=null;}t=new sap.ui.core.HTML({content:"<span id="+r+" class='sapMUCTextButtonContainer'></span>",afterRendering:this._renderContent.bind(this,i,r)});p=new sap.m.CustomListItem(s+"-cli",{content:[j,u,t],selected:i.getSelected()});p._oUploadCollectionItem=i;p._status=S;p.addStyleClass("sapMUCItem");p.setTooltip(i.getTooltip_Text());return p;};o.prototype._renderContent=function(e,j){var s,i,A,S,p,P,r,t,u,v,w;P=e._percentUploaded;r=e.getAllAttributes();t=e.getStatuses();w=e.getMarkers();s=e.getId();A=r.length;S=t.length;p=w.length;v=e._status;u=this._RenderManager;u.write("<div class=\"sapMUCTextContainer ");if(v==="Edit"){u.write("sapMUCEditMode ");}u.write("\" >");u.renderControl(this._getFileNameControl(e));if(v===o._uploadingStatus&&!(n.browser.msie&&n.browser.version<=9)){u.renderControl(this._createProgressLabel(e,P));}else{if(p>0){u.write("<div class=\"sapMUCObjectMarkerContainer\">");for(i=0;i<p;i++){u.renderControl(w[i].addStyleClass("sapMUCObjectMarker"));}u.write("</div>");}if(A>0){u.write("<div class=\"sapMUCAttrContainer\">");for(i=0;i<A;i++){r[i].addStyleClass("sapMUCAttr");u.renderControl(r[i]);if((i+1)<A){u.write("<div class=\"sapMUCSeparator\">&nbsp&#x00B7&#160</div>");}}u.write("</div>");}if(S>0){u.write("<div class=\"sapMUCStatusContainer\">");for(i=0;i<S;i++){t[i].detachBrowserEvent("hover");u.renderControl(t[i]);if((i+1)<S){u.write("<div class=\"sapMUCSeparator\">&nbsp&#x00B7&#160</div>");}}u.write("</div>");}}u.write("</div>");this._renderButtons(u,e,v,s);u.flush(q.sap.byId(j)[0],true);this._truncateFileName(e);this._sReziseHandlerId=R.register(this,this._onResize.bind(this));n.orientation.attachHandler(this._onResize,this);};o.prototype._renderButtons=function(r,e,s,j){var p,t;p=this._getButtons(e,s,j);if(p){t=p.length;}if(t>0){r.write("<div class=\"sapMUCButtonContainer\">");for(var i=0;i<t;i++){if((i+1)<t){p[i].addStyleClass("sapMUCFirstButton");}r.renderControl(p[i]);}r.write("</div>");}};o.prototype._getFileNameControl=function(i){var e,j,s,p,r,S,t,v,u,w,V;p=i.getFileName();r=i.getId();S=i._status;if(S!=="Edit"){e=i._getFileNameLink?i._getFileNameLink():i._getControl("sap.m.Link",{id:r+"-ta_filenameHL",press:[i,this._onItemPressed,this]},"FileNameLink");e.setEnabled(this._getItemPressEnabled(i));e.addStyleClass("sapMUCFileName");e.setModel(i.getModel());e.setText(p);return e;}else{j=this._splitFilename(p);t=this.getMaximumFilenameLength();v="None";u=false;s=j.name;if(i.errorState==="Error"){u=true;v="Error";s=i.changedFileName;if(s.length===0){V=this._oRb.getText("UPLOADCOLLECTION_TYPE_FILENAME");}else{V=this._oRb.getText("UPLOADCOLLECTION_EXISTS");}}w=i._getFileNameEditBox?i._getFileNameEditBox():i._getControl("sap.m.Input",{id:r+"-ta_editFileName",type:sap.m.InputType.Text},"FileNameEditBox");w.addStyleClass("sapMUCEditBox");w.setModel(i.getModel());w.setValue(s);w.setValueState(v);w.setFieldWidth("75%");w.setValueStateText(V);w.setDescription(j.extension);w.setShowValueStateMessage(u);if((t-j.extension.length)>0){w.setProperty("maxLength",t-j.extension.length,true);}return w;}};o.prototype._getItemPressEnabled=function(i){return i._getPressEnabled()&&this.sErrorState!=="Error";};o.prototype._onItemPressed=function(e,i){if(i.hasListeners("press")){i.firePress();}else if(this.sErrorState!=="Error"&&q.trim(i.getProperty("url"))){this._triggerLink(e);}};o.prototype._createProgressLabel=function(i,p){var P,s=i.getId();P=i._getProgressLabel?i._getProgressLabel():i._getControl("sap.m.Label",{id:s+"-ta_progress"},"ProgressLabel").addStyleClass("sapMUCProgress");P.setText(this._oRb.getText("UPLOADCOLLECTION_UPLOADING",[p]));return P;};o.prototype._createIcon=function(i,e,j){var t,s,p,S;t=i.getThumbnailUrl();if(t){p=b.createControlByURI({id:e+"-ia_imageHL",src:sap.m.UploadCollection.prototype._getThumbnail(t,j),decorative:false},c).addStyleClass("sapMUCItemImage sapMUCItemIcon");p.setAlt(this._getAriaLabelForPicture(i));}else{s=sap.m.UploadCollection.prototype._getThumbnail(undefined,j);p=new I(e+"-ia_iconHL",{src:s,decorative:false,useIconTooltip:false});p.setAlt(this._getAriaLabelForPicture(i));if(this.sErrorState!=="Error"&&q.trim(i.getProperty("url"))){S="sapMUCItemIcon";}else{S="sapMUCItemIconInactive";}if(s===o._placeholderCamera){if(this.sErrorState!=="Error"&&q.trim(i.getProperty("url"))){S=S+" sapMUCItemPlaceholder";}else{S=S+" sapMUCItemPlaceholderInactive";}}p.addStyleClass(S);}if(this._getItemPressEnabled(i)){p.attachPress(i,this._onItemPressed,this);}return p;};o.prototype._getButtons=function(i,s,e){var j,p,r,t,u,E,v;j=[];if(!this.getInstantUpload()){t="deleteButton";u=this._createDeleteButton(e,t,i,this.sErrorState);j.push(u);return j;}if(s==="Edit"){p=i._getOkButton?i._getOkButton():i._getControl("sap.m.Button",{id:e+"-okButton",text:this._oRb.getText("UPLOADCOLLECTION_RENAMEBUTTON_TEXT"),type:L.ButtonType.Transparent},"OkButton").addStyleClass("sapMUCOkBtn");r=i._getCancelButton?i._getCancelButton():i._getControl("sap.m.Button",{id:e+"-cancelButton",text:this._oRb.getText("UPLOADCOLLECTION_CANCELBUTTON_TEXT"),type:L.ButtonType.Transparent},"CancelButton").addStyleClass("sapMUCCancelBtn");j.push(p);j.push(r);}else if(s===o._uploadingStatus&&!(n.browser.msie&&n.browser.version<=9)){t="terminateButton";u=this._createDeleteButton(e,t,i,this.sErrorState);j.push(u);}else{E=i.getEnableEdit();if(this.sErrorState==="Error"){E=false;}if(i.getVisibleEdit()){v=i._getEditButton?i._getEditButton():i._getControl("sap.m.Button",{id:e+"-editButton",icon:"sap-icon://edit",type:L.ButtonType.Standard,tooltip:this._oRb.getText("UPLOADCOLLECTION_EDITBUTTON_TEXT"),press:[i,this._handleEdit,this]},"EditButton").addStyleClass("sapMUCEditBtn");v.setEnabled(E);v.setVisible(i.getVisibleEdit());j.push(v);}t="deleteButton";if(i.getVisibleDelete()){u=this._createDeleteButton(e,t,i,this.sErrorState);j.push(u);}}return j;};o.prototype._createDeleteButton=function(i,e,j,p){var E,r,G,t,s,v,P;E=j.getEnableDelete();if(p==="Error"){E=false;}if(e==="deleteButton"){G="DeleteButton";s=j._getDeleteButton;t=this._oRb.getText("UPLOADCOLLECTION_DELETEBUTTON_TEXT");v=j.getVisibleDelete();P=[this,this._handleDelete,this];}else{G="TerminateButton";s=j._getTerminateButton;t=this._oRb.getText("UPLOADCOLLECTION_TERMINATEBUTTON_TEXT");v=this.getTerminationEnabled();P=[j,this._handleTerminate,this];}r=s?s():j._getControl("sap.m.Button",{id:i+"-"+e,icon:"sap-icon://sys-cancel",type:L.ButtonType.Standard,press:P},G).addStyleClass("sapMUCDeleteBtn");r.setVisible(v);r.setEnabled(E);r.setTooltip(t);return r;};o.prototype._fillList=function(i){var t=this,e=i.length-1,j=this.getBinding("items"),G=false,s,p=this.getBindingInfo("items")?this.getBindingInfo("items").groupHeaderFactory:null;var r=function(v){return v.getBindingContext()?j.getGroup(v.getBindingContext()):null;};var u=function(v){return r(v)&&r(v).key;};q.each(i,function(v,w){if(j&&j.isGrouped()&&w){if(!G||s!==u(w)){if(p){t._oList.addItemGroup(r(w),p(r(w)),true);}else if(r(w)){t._oList.addItemGroup(r(w),null,true);}G=true;s=u(w);}}if(!w._status){w._status=o._displayStatus;}else if(t.getInstantUpload()&&t._oItemForDelete&&t._oItemForDelete._status===o._toBeDeletedStatus&&w.getDocumentId()===t._oItemForDelete.documentId){return false;}if(!w._percentUploaded&&w._status===o._uploadingStatus){w._percentUploaded=0;}var x=t._mapItemToListItem(w);if(x){if(v===0&&e===0){x.addStyleClass("sapMUCListSingleItem");}else if(v===0){x.addStyleClass("sapMUCListFirstItem");}else if(v===e){x.addStyleClass("sapMUCListLastItem");}else{x.addStyleClass("sapMUCListItem");}t._oList.addAggregation("items",x,true);w.attachEvent("selected",t._handleItemSetSelected,t);}return true;});};o.prototype._clearList=function(){if(this._oList){this._oList.destroyAggregation("items",true);}};o.prototype._setNumberOfAttachmentsTitle=function(e){var i=e||0;var t;if(this._oItemToUpdate){i--;}if(this.getNumberOfAttachmentsText()){t=this.getNumberOfAttachmentsText();}else{t=this._oRb.getText("UPLOADCOLLECTION_ATTACHMENTS",[i]);}if(!this._oNumberOfAttachmentsTitle){this._oNumberOfAttachmentsTitle=new sap.m.Title(this.getId()+"-numberOfAttachmentsTitle",{text:t});}else{this._oNumberOfAttachmentsTitle.setText(t);}};o.prototype._setFileUploaderVisibility=function(u){var t=this._oHeaderToolbar.getContent();if(t){var p=t[this._iFileUploaderPH];if(p instanceof sap.ui.unified.FileUploader){p.setVisible(!u);}}};o.prototype._handleDelete=function(e){var p=e.getParameters();var j=this.getItems();var s=p.id.split("-deleteButton")[0];var r;var t;var u="";var v;var w;for(var i=0;i<j.length;i++){if(j[i].sId===s){t=i;r={documentId:j[i].getDocumentId(),_iLineNumber:t};break;}}if(j[t].hasListeners("deletePress")){j[t].fireDeletePress();return;}this.sDeletedItemId=s;if(q.sap.byId(this.sId).hasClass("sapUiSizeCompact")){u="sapUiSizeCompact";}if(this.editModeItem){this._handleOk(e,this.editModeItem,true);if(this.sErrorState==="Error"){return;}}if(j[t]&&j[t].getEnableDelete()){v=j[t].getFileName();if(!v){w=this._oRb.getText("UPLOADCOLLECTION_DELETE_WITHOUT_FILENAME_TEXT");}else{w=this._oRb.getText("UPLOADCOLLECTION_DELETE_TEXT",v);}this._oItemForDelete=r;sap.m.MessageBox.show(w,{title:this._oRb.getText("UPLOADCOLLECTION_DELETE_TITLE"),actions:[sap.m.MessageBox.Action.OK,sap.m.MessageBox.Action.CANCEL],onClose:this._onCloseMessageBoxDeleteItem.bind(this),dialogId:"messageBoxDeleteFile",styleClass:u});}};o.prototype._onCloseMessageBoxDeleteItem=function(e){var j=this.getItems();var p;if(this.getInstantUpload()){for(var i=0;i<j.length;i++){if(j[i].getDocumentId()===this._oItemForDelete.documentId){p=j[i];}}}else{p=j[this._oItemForDelete._iLineNumber];}if(e===sap.m.MessageBox.Action.OK){this._oItemForDelete._status=o._toBeDeletedStatus;if(this.getInstantUpload()){this.fireFileDeleted({documentId:this._oItemForDelete.documentId,item:p});this._oItemForDelete=null;}else{if(this.aItems.length===1){if(!this.getUploadButtonInvisible()){this.sFocusId=this._oFileUploader.$().find(":button")[0].id;}}else if(this._oItemForDelete._iLineNumber<this.aItems.length-1){this.sFocusId=this.aItems[this._oItemForDelete._iLineNumber+1].getId()+"-cli";}else{this.sFocusId=this.aItems[0].getId()+"-cli";}this._aDeletedItemForPendingUpload.push(p);this.aItems.splice(this._oItemForDelete._iLineNumber,1);this.removeAggregation("items",p,false);}}};o.prototype._handleTerminate=function(e,j){var p,r;p=new sap.m.List({items:[new sap.m.StandardListItem({title:j.getFileName(),icon:this._getIconFromFilename(j.getFileName())})]});r=new sap.m.Dialog({id:this.getId()+"deleteDialog",title:this._oRb.getText("UPLOADCOLLECTION_TERMINATE_TITLE"),content:[new sap.m.Text({text:this._oRb.getText("UPLOADCOLLECTION_TERMINATE_TEXT")}),p],buttons:[new sap.m.Button({text:this._oRb.getText("UPLOADCOLLECTION_OKBUTTON_TEXT"),press:[s,this]}),new sap.m.Button({text:this._oRb.getText("UPLOADCOLLECTION_CANCELBUTTON_TEXT"),press:function(){r.close();}})],afterClose:function(){r.destroy();}}).open();function s(){var A=false;for(var i=0;i<this.aItems.length;i++){if(this.aItems[i]._status===o._uploadingStatus&&this.aItems[i]._requestIdName===j._requestIdName){this.aItems[i]._status=o._toBeDeletedStatus;this._oItemForDelete=this.aItems[i];A=true;break;}else if(j.getFileName()===this.aItems[i].getFileName()&&this.aItems[i]._status===o._displayStatus){this.aItems[i]._status=o._toBeDeletedStatus;this._oItemForDelete=this.aItems[i];this.fireFileDeleted({documentId:this.aItems[i].getDocumentId(),item:this.aItems[i]});break;}}if(A){this._getFileUploader().abort(this._headerParamConst.fileNameRequestIdName,this._encodeToAscii(j.getFileName())+this._oItemForDelete._requestIdName);}r.close();this.invalidate();}};o.prototype._handleEdit=function(e,j){var i,s=j.getId(),p=this.aItems.length;if(this.editModeItem){this._handleOk(e,this.editModeItem,false);}if(this.sErrorState!=="Error"){for(i=0;i<p;i++){if(this.aItems[i].getId()===s){this.aItems[i]._status="Edit";break;}}j._status="Edit";this.editModeItem=e.getSource().getId().split("-editButton")[0];this.invalidate();}};o.prototype._handleClick=function(e,i){var $=q(e.target).closest("button");var s="";if($.length){s=$.prop("id");}if(s.lastIndexOf("editButton")===-1){if(s.lastIndexOf("cancelButton")!==-1){this._handleCancel(e,i);}else if(e.target.id.lastIndexOf("ia_imageHL")<0&&e.target.id.lastIndexOf("ia_iconHL")<0&&e.target.id.lastIndexOf("deleteButton")<0&&e.target.id.lastIndexOf("ta_editFileName-inner")<0){if(e.target.id.lastIndexOf("cli")>0){this.sFocusId=e.target.id;}this._handleOk(e,i,true);}}};o.prototype._handleOk=function(e,i,j){var E=document.getElementById(i+"-ta_editFileName-inner");var N;var s=o._findById(i,this.aItems);var p=s.getProperty("fileName");var r=o.prototype._splitFilename(p);var t=sap.ui.getCore().byId(i+"-ta_editFileName");var u=s.errorState;var v=s.changedFileName;if(E!==null){N=E.value.replace(/^\s+/,"");}this.sFocusId=i+"-cli";if(!N||N.length===0){if(E!==null){this._setErrorStateOnItem(this,s,N,v,u);}return;}s._status=o._displayStatus;if(r.name===N){this._removeErrorStateFromItem(this,s);if(j){this.invalidate();}return;}if(this.getSameFilenameAllowed()){this._removeErrorStateFromItem(this,s);this._oItemForRename=s;this._onEditItemOk.bind(this)(N+r.extension);return;}if(sap.m.UploadCollection.prototype._checkDoubleFileName(N+r.extension,this.aItems)){t.setProperty("valueState","Error",true);this._setErrorStateOnItem(this,s,N,v,u);}else{t.setProperty("valueState","None",true);s.changedFileName=null;this._removeErrorStateFromItem(this,s);if(j){this.invalidate();}this._oItemForRename=s;this._onEditItemOk.bind(this)(N+r.extension);}};o.prototype._setErrorStateOnItem=function(e,s,N,i,E){s._status="Edit";s.errorState="Error";e.sErrorState="Error";s.changedFileName=N;if(E!=="Error"||i!==N){e.invalidate();}};o.prototype._removeErrorStateFromItem=function(e,i){i.errorState=null;e.sErrorState=null;e.editModeItem=null;};o.prototype._onEditItemOk=function(N){if(this._oItemForRename){this._oItemForRename.setFileName(N);this.fireFileRenamed({documentId:this._oItemForRename.getProperty("documentId"),fileName:N,item:this._oItemForRename});}delete this._oItemForRename;};o.prototype._handleCancel=function(e,i){var j=o._findById(i,this.aItems);j._status=o._displayStatus;j.errorState=null;j.changedFileName=j._getFileNameEditBox().getValue();this.sFocusId=this.editModeItem+"-cli";this.sErrorState=null;this.editModeItem=null;this.invalidate();};o.prototype._onChange=function(e){if(e){var t=this;var r,j,i,s,p,S,u,A;if(n.browser.msie&&n.browser.version<=9){var N=e.getParameter("newValue");if(!N){return;}s=N.split(/" "/)[0];if(s.length===0){return;}}else{j=e.getParameter("files").length;if(j===0){return;}this._oFileUploader.removeAllAggregation("headerParameters",true);this.removeAllAggregation("headerParameters",true);}this._oFileUploader.removeAllAggregation("parameters",true);this.removeAllAggregation("parameters",true);if(n.browser.msie&&n.browser.version<=9){var v={name:e.getParameter("newValue")};var P={files:[v]};this.fireChange({getParameter:function(y){if(y==="files"){return[v];}},getParameters:function(){return P;},mParameters:P,files:[v]});}else{this.fireChange({getParameter:function(y){if(y){return e.getParameter(y);}},getParameters:function(){return e.getParameters();},mParameters:e.getParameters(),files:e.getParameter("files")});}var w=this.getAggregation("parameters");if(w){q.each(w,function(y,z){var E=new sap.ui.unified.FileUploaderParameter({name:z.getProperty("name"),value:z.getProperty("value")});t._oFileUploader.addParameter(E);});}if(!this.getInstantUpload()){this._bFocusFileUploader=true;S=o._pendingUploadStatus;}else{S=o._uploadingStatus;}if(n.browser.msie&&n.browser.version<=9){p=new sap.m.UploadCollectionItem({fileName:s});p._status=S;p._internalFileIndexWithinFileUploader=1;if(!this.getInstantUpload()){p.setAssociation("fileUploader",this._oFileUploader,true);this.insertItem(p);this._aFileUploadersForPendingUpload.push(this._oFileUploader);}else{p._percentUploaded=0;}this.aItems.unshift(p);}else{this._requestIdValue=this._requestIdValue+1;r=this._requestIdValue.toString();var x=this.getAggregation("headerParameters");if(!this.getInstantUpload()){this._aFileUploadersForPendingUpload.push(this._oFileUploader);}for(i=0;i<j;i++){p=new L.UploadCollectionItem({fileName:e.getParameter("files")[i].name});if(e.getParameter("fromDragDrop")){p._internalFileIdWithinDragDropArray=e.getParameter("files")[i];}p._status=S;p._internalFileIndexWithinFileUploader=i+1;p._requestIdName=r;if(!this.getInstantUpload()){p.setAssociation("fileUploader",this._oFileUploader,true);u=this._oFormatDecimal.format(e.getParameter("files")[i].size);A=new k({text:u});p.insertAggregation("attributes",A,true);this.insertItem(p);}else{p._percentUploaded=0;}this.aItems.unshift(p);}if(x){q.each(x,function(y,z){t._oFileUploader.addHeaderParameter(new sap.ui.unified.FileUploaderParameter({name:z.getProperty("name"),value:z.getProperty("value")}));});}t._oFileUploader.addHeaderParameter(new sap.ui.unified.FileUploaderParameter({name:this._headerParamConst.requestIdName,value:r}));}}};o.prototype._onFilenameLengthExceed=function(e){var i={name:e.getParameter("fileName")};var j=[i];this.fireFilenameLengthExceed({getParameter:function(p){if(p){return e.getParameter(p);}},getParameters:function(){return e.getParameters();},mParameters:e.getParameters(),files:j});};o.prototype._onFileSizeExceed=function(e){var i;if(n.browser.msie&&n.browser.version<=9){var s=e.getParameter("newValue");i={name:s};var p={newValue:s,files:[i]};this.fireFileSizeExceed({getParameter:function(P){if(P==="files"){return[i];}else if(P==="newValue"){return s;}},getParameters:function(){return p;},mParameters:p,files:[i]});}else{i={name:e.getParameter("fileName"),fileSize:e.getParameter("fileSize")};this.fireFileSizeExceed({getParameter:function(P){if(P){return e.getParameter(P);}},getParameters:function(){return e.getParameters();},mParameters:e.getParameters(),files:[i]});}};o.prototype._onTypeMissmatch=function(e){var i={name:e.getParameter("fileName"),fileType:e.getParameter("fileType"),mimeType:e.getParameter("mimeType")};var j=[i];this.fireTypeMissmatch({getParameter:function(p){if(p){return e.getParameter(p);}},getParameters:function(){return e.getParameters();},mParameters:e.getParameters(),files:j});};o.prototype._onUploadTerminated=function(e){var i;var r=this._getRequestId(e);var s=e.getParameter("fileName");var j=this.aItems.length;for(i=0;i<j;i++){if(this.aItems[i]&&this.aItems[i].getFileName()===s&&this.aItems[i]._requestIdName===r&&(this.aItems[i]._status===o._uploadingStatus||this.aItems[i]._status===o._toBeDeletedStatus)){this.aItems.splice(i,1);this.removeItem(i);break;}}this.fireUploadTerminated({fileName:s,getHeaderParameter:this._getHeaderParameterWithinEvent.bind(e)});};o.prototype._onUploadComplete=function(e){if(e){var i,r,u,j,p,s,t=w();r=this._getRequestId(e);u=e.getParameter("fileName");if(!u){var v=(e.getSource().getProperty("value")).split(/\" "/);u=v[0];}j=this.aItems.length;s=[o._uploadingStatus,o._pendingUploadStatus];for(i=0;i<j;i++){if((!r||this.aItems[i]._requestIdName===r)&&this.aItems[i].getProperty("fileName")===u&&(s.indexOf(this.aItems[i]._status)>=0)){if(t&&this.aItems[i]._status!==o._pendingUploadStatus){this.aItems[i]._percentUploaded=100;this.aItems[i]._status=o._displayStatus;}p=this.aItems.splice(i,1)[0];if(p.destroy){p.destroy();}this._oItemToUpdate=null;break;}}this.fireUploadComplete({getParameter:e.getParameter,getParameters:e.getParameters,mParameters:e.getParameters(),files:[{fileName:e.getParameter("fileName")||u,responseRaw:e.getParameter("responseRaw"),reponse:e.getParameter("response"),response:e.getParameter("response"),status:e.getParameter("status"),headers:e.getParameter("headers")}]});}this.invalidate();function w(){var x=e.getParameter("status").toString()||"200";return x[0]==="2"||x[0]==="3";}};o.prototype._onUploadProgress=function(e){if(e){var i,u,p,P,r,j,s,$,t;u=e.getParameter("fileName");r=this._getRequestId(e);P=Math.round(e.getParameter("loaded")/e.getParameter("total")*100);if(P===100){p=this._oRb.getText("UPLOADCOLLECTION_UPLOAD_COMPLETED");}else{p=this._oRb.getText("UPLOADCOLLECTION_UPLOADING",[P]);}j=this.aItems.length;for(i=0;i<j;i++){t=this.aItems[i];if(t.getProperty("fileName")===u&&t._requestIdName===r&&t._status===o._uploadingStatus){s=t._getProgressLabel?t._getProgressLabel():t._getControl("sap.m.Label",{id:t.getId()+"-ta_progress"},"ProgressLabel");if(s){s.setText(p);t._percentUploaded=P;$=q.sap.byId(t.getId()+"-ia_indicator");if(P===100){$.attr("aria-label",p);}else{$.attr("aria-valuenow",P);}break;}}}}};o.prototype._getRequestId=function(e){var i;i=e.getParameter("requestHeaders");if(!i){return null;}for(var j=0;j<i.length;j++){if(i[j].name===this._headerParamConst.requestIdName){return i[j].value;}}return null;};o.prototype._getFileUploader=function(){var u=this.getInstantUpload();if(!u||!this._oFileUploader){var s=!(n.browser.msie&&n.browser.version<=9),t=this.getInstantUpload()?this._oRb.getText("UPLOADCOLLECTION_UPLOAD"):this._oRb.getText("UPLOADCOLLECTION_ADD");this._iFUCounter=this._iFUCounter+1;this._oFileUploader=new sap.ui.unified.FileUploader(this.getId()+"-"+this._iFUCounter+"-uploader",{buttonOnly:true,buttonText:t,tooltip:t,iconOnly:true,enabled:this.getUploadEnabled(),fileType:this.getFileType(),icon:"sap-icon://add",iconFirst:false,style:"Transparent",maximumFilenameLength:this.getMaximumFilenameLength(),maximumFileSize:this.getMaximumFileSize(),mimeType:this.getMimeType(),multiple:this.getMultiple(),name:"uploadCollection",uploadOnChange:u,sameFilenameAllowed:true,uploadUrl:this.getUploadUrl(),useMultipart:false,sendXHR:s,change:[this._onChange,this],filenameLengthExceed:[this._onFilenameLengthExceed,this],fileSizeExceed:[this._onFileSizeExceed,this],typeMissmatch:[this._onTypeMissmatch,this],uploadAborted:[this._onUploadTerminated,this],uploadComplete:[this._onUploadComplete,this],uploadProgress:function(e){if(this.getInstantUpload()){this._onUploadProgress(e);}}.bind(this),uploadStart:[this._onUploadStart,this],visible:!this.getUploadButtonInvisible()});}return this._oFileUploader;};o.prototype._onUploadStart=function(e){var r,i,s,p,j,G;this._iUploadStartCallCounter++;p=e.getParameter("requestHeaders").length;for(i=0;i<p;i++){if(e.getParameter("requestHeaders")[i].name===this._headerParamConst.requestIdName){s=e.getParameter("requestHeaders")[i].value;break;}}j=e.getParameter("fileName");r={name:this._headerParamConst.fileNameRequestIdName,value:this._encodeToAscii(j)+s};e.getParameter("requestHeaders").push(r);for(i=0;i<this._aDeletedItemForPendingUpload.length;i++){if(this._aDeletedItemForPendingUpload[i].getAssociation("fileUploader")===e.oSource.sId&&this._aDeletedItemForPendingUpload[i].getFileName()===j&&this._aDeletedItemForPendingUpload[i]._internalFileIndexWithinFileUploader===this._iUploadStartCallCounter){e.getSource().abort(this._headerParamConst.fileNameRequestIdName,this._encodeToAscii(j)+s);return;}}this.fireBeforeUploadStarts({fileName:j,addHeaderParameter:t,getHeaderParameter:u.bind(this)});if(q.isArray(G)){for(i=0;i<G.length;i++){if(e.getParameter("requestHeaders")[i].name===G[i].getName()){e.getParameter("requestHeaders")[i].value=G[i].getValue();}}}else if(G instanceof sap.m.UploadCollectionParameter){for(i=0;i<e.getParameter("requestHeaders").length;i++){if(e.getParameter("requestHeaders")[i].name===G.getName()){e.getParameter("requestHeaders")[i].value=G.getValue();break;}}}function t(v){var r={name:v.getName(),value:v.getValue()};e.getParameter("requestHeaders").push(r);}function u(v){G=this._getHeaderParameterWithinEvent.bind(e)(v);return G;}};o.prototype._getIconFromFilename=function(s){var e=this._splitFilename(s).extension;if(q.type(e)==="string"){e=e.toLowerCase();}switch(e){case".bmp":case".jpg":case".jpeg":case".png":return o._placeholderCamera;case".csv":case".xls":case".xlsx":return"sap-icon://excel-attachment";case".doc":case".docx":case".odt":return"sap-icon://doc-attachment";case".pdf":return"sap-icon://pdf-attachment";case".ppt":case".pptx":return"sap-icon://ppt-attachment";case".txt":return"sap-icon://document-text";default:return"sap-icon://document";}};o.prototype._getThumbnail=function(t,s){if(t){return t;}else{return this._getIconFromFilename(s);}};o.prototype._triggerLink=function(e){var i,j;if(this.editModeItem){this._handleOk(e,this.editModeItem,true);if(this.sErrorState==="Error"){return;}this.sFocusId=e.getParameter("id");}j=e.oSource.getId().split("-");i=j[j.length-2];M.URLHelper.redirect(this.aItems[i].getProperty("url"),true);};o.prototype.onkeydown=function(e){switch(e.keyCode){case q.sap.KeyCodes.F2:this._handleF2(e);break;case q.sap.KeyCodes.ESCAPE:this._handleESC(e);break;case q.sap.KeyCodes.DELETE:this._handleDEL(e);break;case q.sap.KeyCodes.ENTER:this._handleENTER(e);break;default:return;}e.setMarked();};o.prototype._setFocusAfterDeletion=function(){var i=this.aItems.length;var s;if(i===0){this._oFileUploader.focus();}else{var e=this.sDeletedItemId.split("-").pop();if(e<=i-1){s=this.sDeletedItemId+"-cli";}else{s=this.aItems[this.aItems.length-1].sId+"-cli";}this._setFocusToLineItem(s);}this.sDeletedItemId=null;};o.prototype._setFocusToLineItem=function(i){q.sap.byId(i).focus();};o.prototype._handleENTER=function(e){var t,s,i,j;if(this.editModeItem){t=e.target.id.split(this.editModeItem).pop();}else{t=e.target.id.split("-").pop();}switch(t){case"-ta_editFileName-inner":case"-okButton":this._handleOk(e,this.editModeItem,true);break;case"-cancelButton":e.preventDefault();this._handleCancel(e,this.editModeItem);break;case"-ia_iconHL":case"-ia_imageHL":j=this.editModeItem.split("-").pop();M.URLHelper.redirect(this.aItems[j].getProperty("url"),true);break;case"ia_iconHL":case"ia_imageHL":case"cli":s=e.target.id.split(t)[0]+"ta_filenameHL";i=sap.ui.getCore().byId(s);if(i.getEnabled()){j=e.target.id.split("-")[2];M.URLHelper.redirect(this.aItems[j].getProperty("url"),true);}break;default:break;}};o.prototype._handleDEL=function(e){if(!this.editModeItem){var i=q.sap.byId(e.target.id);var j=i.find("[id$='-deleteButton']");var p=sap.ui.getCore().byId(j[0].id);p.firePress();}};o.prototype._handleESC=function(e){if(this.editModeItem){this.sFocusId=this.editModeItem+"-cli";this.aItems[this.editModeItem.split("-").pop()]._status=o._displayStatus;this._handleCancel(e,this.editModeItem);}};o.prototype._handleF2=function(e){var i=sap.ui.getCore().byId(e.target.id);if(i!==undefined){if(i._status===o._displayStatus){var j=q.sap.byId(e.target.id);var p=j.find("[id$='-editButton']");var E=sap.ui.getCore().byId(p[0].id);if(E.getEnabled()){if(this.editModeItem){this._handleClick(e,this.editModeItem);}if(this.sErrorState!=="Error"){E.firePress();}}}else{this._handleClick(e,this.editModeItem);}}else if(e.target.id.search(this.editModeItem)===0){this._handleOk(e,this.editModeItem,true);}};o.prototype._getFileNames=function(e){if(this.getMultiple()&&!(n.browser.msie&&n.browser.version<=9)){return e.substring(1,e.length-2).split(/\" "/);}else{return e.split(/\" "/);}};o.prototype._checkDoubleFileName=function(e,j){if(j.length===0||!e){return false;}var p=j.length;e=e.replace(/^\s+/,"");for(var i=0;i<p;i++){if(e===j[i].getProperty("fileName")){return true;}}return false;};o.prototype._splitFilename=function(e){var r={};var N=e.split(".");if(N.length===1){r.extension="";r.name=N.pop();return r;}r.extension="."+N.pop();r.name=N.join(".");return r;};o.prototype._getAriaLabelForPicture=function(i){var t;t=(i.getAriaLabelForPicture()||i.getFileName());return t;};o.prototype._getHeaderParameterWithinEvent=function(s){var u=[];var r=this.getParameter("requestHeaders");var p=r.length;var i;if(r&&s){for(i=0;i<p;i++){if(r[i].name===s){return new sap.m.UploadCollectionParameter({name:r[i].name,value:r[i].value});}}}else{if(r){for(i=0;i<p;i++){u.push(new sap.m.UploadCollectionParameter({name:r[i].name,value:r[i].value}));}}return u;}};o.prototype._encodeToAscii=function(v){var e="";for(var i=0;i<v.length;i++){e=e+v.charCodeAt(i);}return e;};o.prototype._onResize=function(){var e=this._oList.getItems();for(var i=0;i<e.length;i++){q.sap.delayedCall(o._resizeTimeoutInterval,this,this._truncateFileName.bind(this),[e[i]._oUploadCollectionItem]);}};o.prototype._getUploadCollectionItemByListItem=function(e){var A=this.getItems();for(var i=0;i<A.length;i++){if(A[i].getId()===e.getId().replace("-cli","")){return A[i];}}return null;};o.prototype._getUploadCollectionItemById=function(u){var A=this.getItems();for(var i=0;i<A.length;i++){if(A[i].getId()===u){return A[i];}}return null;};o.prototype._getUploadCollectionItemsByListItems=function(e){var u=[];var p=this.getItems();if(e){for(var i=0;i<e.length;i++){for(var j=0;j<p.length;j++){if(e[i].getId().replace("-cli","")===p[j].getId()){u.push(p[j]);break;}}}return u;}return null;};o.prototype._setSelectedForItems=function(u,s){if(this.getMode()!==sap.m.ListMode.MultiSelect&&s){var e=this.getItems();for(var j=0;j<e.length;j++){e[j].setSelected(false);}}for(var i=0;i<u.length;i++){u[i].setSelected(s);}};o.prototype._handleItemSetSelected=function(e){var i=e.getSource();if(i instanceof sap.m.UploadCollectionItem){var j=this._getListItemById(i.getId()+"-cli");if(j){j.setSelected(i.getSelected());}}};o.prototype._handleSelectionChange=function(e){var i=e.getParameter("listItem");var s=e.getParameter("selected");var u=this._getUploadCollectionItemsByListItems(e.getParameter("listItems"));var j=this._getUploadCollectionItemByListItem(i);if(j&&i&&u){this.fireSelectionChange({selectedItem:j,selectedItems:u,selected:s});j.setSelected(i.getSelected());}};o.prototype._getListItemById=function(e){var i=this._oList.getItems();return o._findById(e,i);};o._findById=function(e,j){for(var i=0;i<j.length;i++){if(j[i].getId()===e){return j[i];}}return null;};return o;});
