/*
 * ! UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/m/CustomTreeItem',['jquery.sap.global','./TreeItemBase','./ListItemBase','./library'],function(q,T,L,l){"use strict";
var C=T.extend("sap.m.CustomTreeItem",{metadata:{library:"sap.m",defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",bindable:"bindable"}}}});
C.prototype.getContentAnnouncement=function(){return this.getContent().map(function(c){return L.getAccessibilityText(c);}).join(" ").trim();};
return C;},true);
sap.ui.predefine('sap/m/CustomTreeItemRenderer',['jquery.sap.global','./TreeItemBaseRenderer','sap/ui/core/Renderer'],function(q,T,R){"use strict";var C=R.extend(T);
C.renderLIAttributes=function(r,l){r.addClass("sapMCTI");T.renderLIAttributes.apply(this,arguments);};
C.renderLIContent=function(r,l){l.getContent().forEach(function(c){r.renderControl(c);});};
return C;},true);
sap.ui.predefine('sap/m/ObjectIdentifier.designtime',['sap/m/library'],function(M){"use strict";var w;return{registerSettingsHandler:function(W){w=W;},getStableElements:function(o){return w?w.getStableElements(o):null;},actions:{settings:function(){if(!w){return;}if(!w.isSettingsAvailable()){jQuery.sap.log.error("sap.ui.comp.navpopover.ObjectIdentifier.designtime: 'settings' action is not available");return;}return{handler:function(o,g){return w.execute(o,g);}};}}};},false);
sap.ui.predefine('sap/m/P13nColumnsItem',['jquery.sap.global','./library','sap/ui/core/Item'],function(q,l,I){"use strict";
var P=I.extend("sap.m.P13nColumnsItem",{metadata:{library:"sap.m",properties:{columnKey:{type:"string",group:"Misc"},index:{type:"int",group:"Appearance"},visible:{type:"boolean",group:"Appearance"},width:{type:"string",group:"Misc"},total:{type:"boolean"}}}});
return P;},true);
sap.ui.predefine('sap/m/P13nColumnsPanel',['jquery.sap.global','./ColumnListItem','./P13nPanel','./P13nColumnsItem','./SearchField','./Table','./library','sap/ui/core/Control','sap/ui/model/ChangeReason','sap/ui/model/json/JSONModel'],function(q,C,P,c,S,T,l,d,e,J){"use strict";
var f=P.extend("sap.m.P13nColumnsPanel",{
metadata:{library:"sap.m",properties:{visibleItemsThreshold:{type:"int",group:"Behavior",defaultValue:-1}},aggregations:{columnsItems:{type:"sap.m.P13nColumnsItem",multiple:true,singularName:"columnsItem",bindable:"bindable"},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"}},events:{addColumnsItem:{parameters:{newItem:{type:"sap.m.P13nColumnsItem"}}},changeColumnsItems:{parameters:{newItems:{type:"sap.m.P13nColumnsItem[]"},existingItems:{type:"sap.m.P13nColumnsItem[]"},items:{type:"object[]"}}},setData:{}}},
renderer:function(r,o){r.write("<div");r.writeControlData(o);r.addClass("sapMP13nColumnsPanel");r.writeClasses();r.write(">");var a=o.getAggregation("content");if(a){a.forEach(function(b){r.renderControl(b);});}r.write("</div>");}
});
f.prototype.init=function(){this._iLiveChangeTimer=0;this._iSearchTimer=0;this._bIgnoreUpdateInternalModel=false;this._bUpdateInternalModel=true;this._bTableItemsChanged=false;this._bOnAfterRenderingFirstTimeExecuted=false;var m=new J({items:[],columnKeyOfMarkedItem:undefined,isMoveDownButtonEnabled:undefined,isMoveUpButtonEnabled:undefined,showOnlySelectedItems:undefined,countOfSelectedItems:0,countOfItems:0});m.setDefaultBindingMode(sap.ui.model.BindingMode.TwoWay);m.setSizeLimit(1000);this.setModel(m,"$sapmP13nColumnsPanel");this.setType(sap.m.P13nPanelType.columns);this.setTitle(sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("COLUMSPANEL_TITLE"));this._createTable();this._createToolbar();this.setVerticalScrolling(false);var s=new sap.m.ScrollContainer({horizontal:false,vertical:true,content:[this._oTable],width:'100%',height:'100%'});this.addAggregation("content",s);var t=this;this._fnHandleResize=function(){var b=false,i,a;if(t.getParent){var $=null,g,h;var p=t.getParent();var o=t._getToolbar();if(p){$=q("#"+p.getId()+"-cont");if($.children().length>0&&o.$().length>0){i=s.$()[0].clientHeight;g=$.children()[0].clientHeight;h=o?o.$()[0].clientHeight:0;a=g-h;if(i!==a){s.setHeight(a+'px');b=true;}}}}return b;};this._sContainerResizeListener=sap.ui.core.ResizeHandler.register(s,this._fnHandleResize);};
f.prototype.reInitialize=function(){};
f.prototype.onBeforeRendering=function(){this._updateInternalModel();if(!this._getInternalModel().getProperty("/columnKeyOfMarkedItem")){this._setColumnKeyOfMarkedItem(this._getColumnKeyByTableItem(this._getVisibleTableItems()[0]));}this._switchMarkedTableItemTo(this._getTableItemByColumnKey(this._getInternalModel().getProperty("/columnKeyOfMarkedItem")));this._updateControlLogic();};
f.prototype.onAfterRendering=function(){if(!this._bOnAfterRenderingFirstTimeExecuted){this._bOnAfterRenderingFirstTimeExecuted=true;window.clearTimeout(this._iLiveChangeTimer);var t=this;this._iLiveChangeTimer=window.setTimeout(function(){t._fnHandleResize();},0);}};
f.prototype.getOkPayload=function(){this._updateInternalModel();var m=this._getInternalModel().getProperty("/items");return{tableItems:m.map(function(M){return{columnKey:M.columnKey,index:M.persistentIndex===-1?undefined:M.persistentIndex,visible:M.persistentSelected,width:M.width};}),tableItemsChanged:this._bTableItemsChanged,selectedItems:m.filter(function(M){return M.persistentSelected;}).map(function(M){return{columnKey:M.columnKey};})};};
f.prototype.getResetPayload=function(){return{oPanel:this};};
f.prototype.exit=function(){sap.ui.core.ResizeHandler.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null;this._getToolbar().destroy();this._oTable.destroy();this._oTable=null;if(this._getInternalModel()){this._getInternalModel().destroy();}window.clearTimeout(this._iLiveChangeTimer);window.clearTimeout(this._iSearchTimer);};
f.prototype.addItem=function(i){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.addAggregation("items",i);return this;};
f.prototype.insertItem=function(i,I){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.insertAggregation("items",i,I);return this;};
f.prototype.removeItem=function(i){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}i=this.removeAggregation("items",i);return i;};
f.prototype.removeAllItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAllAggregation("items");};
f.prototype.destroyItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.destroyAggregation("items");return this;};
f.prototype.addColumnsItem=function(o){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.addAggregation("columnsItems",o);return this;};
f.prototype.insertColumnsItem=function(o,i){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.insertAggregation("columnsItems",o,i);return this;};
f.prototype.updateColumnsItems=function(r){this.updateAggregation("columnsItems");if(r===e.Change&&!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}};
f.prototype.removeColumnsItem=function(o){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAggregation("columnsItems",o);};
f.prototype.removeAllColumnsItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAllAggregation("columnsItems");};
f.prototype.destroyColumnsItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.destroyAggregation("columnsItems");return this;};
f.prototype.onBeforeNavigationFrom=function(){var m=this._getSelectedModelItems();var v=this.getVisibleItemsThreshold();return!(m&&v!==-1&&m.length>v);};
f.prototype._notifyChange=function(){this._bTableItemsChanged=true;var L=this.getChangeNotifier();if(L){L(this);}};
f.prototype._scrollToSelectedItem=function(i){if(!i){return;}sap.ui.getCore().applyChanges();if(!!i.getDomRef()){i.focus();}};
f.prototype._getInternalModel=function(){return this.getModel("$sapmP13nColumnsPanel");};
f.prototype._createTable=function(){this._oTable=new T({mode:sap.m.ListMode.MultiSelect,rememberSelections:false,itemPress:q.proxy(this._onItemPressed,this),selectionChange:q.proxy(this._onSelectionChange,this),columns:[new sap.m.Column({header:new sap.m.Text({text:{parts:[{path:'/countOfSelectedItems'},{path:'/countOfItems'}],formatter:function(i,a){return sap.ui.getCore().getLibraryResourceBundle("sap.m").getText('COLUMNSPANEL_SELECT_ALL_WITH_COUNTER',[i,a]);}}})})],items:{path:"/items",templateShareable:false,template:new sap.m.ColumnListItem({cells:[new sap.m.Text({text:"{text}"})],visible:"{visible}",selected:"{persistentSelected}",tooltip:"{tooltip}",type:sap.m.ListType.Active})}});this._oTable.setModel(this._getInternalModel());};
f.prototype._createToolbar=function(){var t=this;var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");var o=new sap.m.OverflowToolbar(this.getId()+"-toolbar",{design:sap.m.ToolbarDesign.Auto,content:[new sap.m.ToolbarSpacer(),new S(this.getId()+"-searchField",{liveChange:function(E){var v=E.getSource().getValue(),D=(v?300:0);window.clearTimeout(t._iSearchTimer);if(D){t._iSearchTimer=window.setTimeout(function(){t._onExecuteSearch();},D);}else{t._onExecuteSearch();}},search:q.proxy(this._onExecuteSearch,this),layoutData:new sap.m.OverflowToolbarLayoutData({minWidth:"12.5rem",maxWidth:"23.077rem",shrinkable:true,moveToOverflow:false,stayInOverflow:false})}),new sap.m.Button({text:{path:'/showOnlySelectedItems',formatter:function(s){return s?r.getText('COLUMNSPANEL_SHOW_ALL'):r.getText('COLUMNSPANEL_SHOW_SELECTED');}},tooltip:{path:'/showOnlySelectedItems',formatter:function(s){return s?r.getText('COLUMNSPANEL_SHOW_ALL'):r.getText('COLUMNSPANEL_SHOW_SELECTED');}},type:sap.m.ButtonType.Transparent,press:q.proxy(this._onSwitchButtonShowSelected,this),layoutData:new sap.m.OverflowToolbarLayoutData({moveToOverflow:true,priority:sap.m.OverflowToolbarPriority.High})}),new sap.m.OverflowToolbarButton({icon:sap.ui.core.IconPool.getIconURI("collapse-group"),text:r.getText('COLUMNSPANEL_MOVE_TO_TOP'),tooltip:r.getText('COLUMNSPANEL_MOVE_TO_TOP'),type:sap.m.ButtonType.Transparent,enabled:{path:'/isMoveUpButtonEnabled'},press:q.proxy(this.onPressButtonMoveToTop,this),layoutData:new sap.m.OverflowToolbarLayoutData({moveToOverflow:true,priority:sap.m.OverflowToolbarPriority.Low,group:2})}),new sap.m.OverflowToolbarButton({icon:sap.ui.core.IconPool.getIconURI("slim-arrow-up"),text:r.getText('COLUMNSPANEL_MOVE_UP'),tooltip:r.getText('COLUMNSPANEL_MOVE_UP'),type:sap.m.ButtonType.Transparent,enabled:{path:'/isMoveUpButtonEnabled'},press:q.proxy(this.onPressButtonMoveUp,this),layoutData:new sap.m.OverflowToolbarLayoutData({moveToOverflow:true,priority:sap.m.OverflowToolbarPriority.High,group:1})}),new sap.m.OverflowToolbarButton({icon:sap.ui.core.IconPool.getIconURI("slim-arrow-down"),text:r.getText('COLUMNSPANEL_MOVE_DOWN'),tooltip:r.getText('COLUMNSPANEL_MOVE_DOWN'),type:sap.m.ButtonType.Transparent,enabled:{path:'/isMoveDownButtonEnabled'},press:q.proxy(this.onPressButtonMoveDown,this),layoutData:new sap.m.OverflowToolbarLayoutData({moveToOverflow:true,priority:sap.m.OverflowToolbarPriority.High,group:1})}),new sap.m.OverflowToolbarButton({icon:sap.ui.core.IconPool.getIconURI("expand-group"),text:r.getText('COLUMNSPANEL_MOVE_TO_BOTTOM'),tooltip:r.getText('COLUMNSPANEL_MOVE_TO_BOTTOM'),type:sap.m.ButtonType.Transparent,enabled:{path:'/isMoveDownButtonEnabled'},press:q.proxy(this.onPressButtonMoveToBottom,this),layoutData:new sap.m.OverflowToolbarLayoutData({moveToOverflow:true,priority:sap.m.OverflowToolbarPriority.Low,group:2})})]});o.setModel(this._getInternalModel());this.addAggregation("content",o);};
f.prototype.onPressButtonMoveToTop=function(){this._moveMarkedTableItem(this._getMarkedTableItem(),this._getVisibleTableItems()[0]);};
f.prototype.onPressButtonMoveUp=function(){var v=this._getVisibleTableItems();this._moveMarkedTableItem(this._getMarkedTableItem(),v[v.indexOf(this._getMarkedTableItem())-1]);};
f.prototype.onPressButtonMoveDown=function(){var v=this._getVisibleTableItems();this._moveMarkedTableItem(this._getMarkedTableItem(),v[v.indexOf(this._getMarkedTableItem())+1]);};
f.prototype.onPressButtonMoveToBottom=function(){var v=this._getVisibleTableItems();this._moveMarkedTableItem(this._getMarkedTableItem(),v[v.length-1]);};
f.prototype._onSwitchButtonShowSelected=function(){this._getInternalModel().setProperty("/showOnlySelectedItems",!this._getInternalModel().getProperty("/showOnlySelectedItems"));this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();this._scrollToSelectedItem(this._getMarkedTableItem());this._updateControlLogic();this._fnHandleResize();};
f.prototype._onExecuteSearch=function(){this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();this._updateControlLogic();};
f.prototype._switchVisibilityOfUnselectedModelItems=function(){var s=this._isFilteredByShowSelected();var m=this._getInternalModel().getProperty("/items");m.forEach(function(M){if(M.persistentSelected){M.visible=true;return;}M.visible=!s;});this._getInternalModel().setProperty("/items",m);};
f.prototype._getVisibleModelItems=function(){return this._getInternalModel().getProperty("/items").filter(function(m){return!!m.visible;});};
f.prototype._moveMarkedTableItem=function(t,o){var m=this._getModelItemByColumnKey(this._getColumnKeyByTableItem(t));var M=this._getModelItemByColumnKey(this._getColumnKeyByTableItem(o));var i=this._getModelItemIndexByColumnKey(m.columnKey);var I=this._getModelItemIndexByColumnKey(M.columnKey);this._moveModelItems(i,I);this._scrollToSelectedItem(this._getMarkedTableItem());this._updateControlLogic();this._fireChangeColumnsItems();this._fireSetData();this._notifyChange();};
f.prototype._moveModelItems=function(i,I){var m=this._getInternalModel().getProperty("/items");if(i<0||I<0||i>m.length-1||I>m.length-1){return false;}this._removeStyleOfMarkedTableItem();var M=m.splice(i,1);m.splice(I,0,M[0]);this._updateModelItemsPersistentIndex(m);this._updateCounts(m);this._getInternalModel().setProperty("/items",m);this._switchMarkedTableItemTo(this._getMarkedTableItem());return true;};
f.prototype._getModelItemByColumnKey=function(s){var m=this._getInternalModel().getProperty("/items").filter(function(M){return M.columnKey===s;});return m[0];};
f.prototype._updateCounts=function(m){var i=0;var a=0;m.forEach(function(M){i++;if(M.persistentSelected){a++;}});this._getInternalModel().setProperty("/countOfItems",i);this._getInternalModel().setProperty("/countOfSelectedItems",a);};
f.prototype._sortModelItemsByPersistentIndex=function(m){m.sort(function(a,b){if(a.persistentSelected===true&&(b.persistentSelected===false||b.persistentSelected===undefined)){return-1;}else if((a.persistentSelected===false||a.persistentSelected===undefined)&&b.persistentSelected===true){return 1;}else if(a.persistentSelected===true&&b.persistentSelected===true){if(a.persistentIndex>-1&&a.persistentIndex<b.persistentIndex){return-1;}else if(b.persistentIndex>-1&&a.persistentIndex>b.persistentIndex){return 1;}else{return 0;}}else if((a.persistentSelected===false||a.persistentSelected===undefined)&&(b.persistentSelected===false||b.persistentSelected===undefined)){if(a.text<b.text){return-1;}else if(a.text>b.text){return 1;}else{return 0;}}});};
f.prototype._getColumnKeyByTableItem=function(t){var i=this._oTable.indexOfItem(t);if(i<0){return null;}return this._oTable.getBinding("items").getContexts()[i].getObject().columnKey;};
f.prototype._getModelItemIndexByColumnKey=function(s){var i=-1;this._getInternalModel().getProperty("/items").some(function(m,I){if(m.columnKey===s){i=I;return true;}});return i;};
f.prototype._getSelectedModelItems=function(){return this._getInternalModel().getProperty("/items").filter(function(m){return m.persistentSelected;});};
f.prototype._getVisibleTableItems=function(){return this._oTable.getItems().filter(function(t){return t.getVisible();});};
f.prototype._getTableItemByColumnKey=function(s){var a=this._oTable.getBinding("items").getContexts();var t=this._oTable.getItems().filter(function(o,i){return a[i].getObject().columnKey===s;});return t[0];};
f.prototype._getToolbar=function(){return sap.ui.getCore().byId(this.getId()+"-toolbar")||null;};
f.prototype._getSearchField=function(){return sap.ui.getCore().byId(this.getId()+"-searchField")||null;};
f.prototype._getSearchText=function(){var s=this._getSearchField();return s?s.getValue():"";};
f.prototype._isFilteredBySearchText=function(){return!!this._getSearchText().length;};
f.prototype._isFilteredByShowSelected=function(){return this._getInternalModel().getData().showOnlySelectedItems;};
f.prototype._updateControlLogic=function(){var i=this._isFilteredBySearchText();var s=this._isFilteredByShowSelected();var v=this._getVisibleTableItems();this._getInternalModel().setProperty("/isMoveUpButtonEnabled",v.indexOf(this._getMarkedTableItem())>0);this._getInternalModel().setProperty("/isMoveDownButtonEnabled",v.indexOf(this._getMarkedTableItem())>-1&&v.indexOf(this._getMarkedTableItem())<v.length-1);var t=sap.ui.getCore().byId(this._oTable.getId()+'-sa');if(t){t.setEnabled(!i&&!s);}};
f.prototype._updateModelItemsPersistentIndex=function(m){var p=-1;m.forEach(function(M){M.persistentIndex=-1;if(M.persistentSelected){p++;M.persistentIndex=p;}});};
f.prototype._fireSetData=function(){this._bIgnoreUpdateInternalModel=true;this.fireSetData();this._bIgnoreUpdateInternalModel=false;};
f.prototype._fireChangeColumnsItems=function(){this._bIgnoreUpdateInternalModel=true;var m=this._getInternalModel().getProperty("/items");var E={newItems:[],existingItems:[],items:m.map(function(M){return{columnKey:M.columnKey,visible:M.persistentSelected,index:M.persistentIndex===-1?undefined:M.persistentIndex,width:M.width,total:M.total};})};m.forEach(function(M){var o=this._getColumnsItemByColumnKey(M.columnKey);if(o){o.setVisible(M.persistentSelected);o.setIndex(M.persistentIndex===-1?undefined:M.persistentIndex);if(M.width!==undefined){o.setWidth(M.width);}if(M.total!==undefined){o.setTotal(M.total);}E.existingItems.push(o);}else{E.newItems.push(new sap.m.P13nColumnsItem({columnKey:M.columnKey,visible:M.persistentSelected,index:M.persistentIndex===-1?undefined:M.persistentIndex,width:M.width,total:M.total}));}},this);this.fireChangeColumnsItems(E);this._bIgnoreUpdateInternalModel=false;};
f.prototype._getColumnsItemByColumnKey=function(s){var a=this.getColumnsItems().filter(function(o){return o.getColumnKey()===s;});return a[0];};
f.prototype._getMarkedTableItem=function(){return this._getTableItemByColumnKey(this._getInternalModel().getProperty("/columnKeyOfMarkedItem"));};
f.prototype._setColumnKeyOfMarkedItem=function(s){this._getInternalModel().setProperty("/columnKeyOfMarkedItem",s);};
f.prototype._onItemPressed=function(E){this._switchMarkedTableItemTo(E.getParameter('listItem'));this._updateControlLogic();};
f.prototype._onSelectionChange=function(E){if(!E.getParameter("selectAll")&&E.getParameter("listItems").length===1){this._switchMarkedTableItemTo(E.getParameter("listItem"));}this._selectTableItem();};
f.prototype._selectTableItem=function(){this._updateControlLogic();var m=this._getInternalModel().getProperty("/items");this._updateModelItemsPersistentIndex(m);this._updateCounts(m);this._getInternalModel().setProperty("/items",m);this._fireChangeColumnsItems();this._fireSetData();this._notifyChange();var v=this.getValidationExecutor();if(v){v();}};
f.prototype._switchMarkedTableItemTo=function(t){this._removeStyleOfMarkedTableItem();var s=this._getColumnKeyByTableItem(t);if(s){this._setColumnKeyOfMarkedItem(s);t.addStyleClass("sapMP13nColumnsPanelItemSelected");}};
f.prototype._removeStyleOfMarkedTableItem=function(){if(this._getMarkedTableItem()){this._getMarkedTableItem().removeStyleClass("sapMP13nColumnsPanelItemSelected");}};
f.prototype._filterModelItemsBySearchText=function(){var s=this._getSearchText();s=s.replace(/(^\s+)|(\s+$)/g,'');s=s.replace(/[-\/\\^$*+?.()|[\]{}]/g,'\\$&');var r=new RegExp(s,'igm');if(!r){return;}this._getVisibleModelItems().forEach(function(m){m.visible=false;if(m.text&&m.text.match(r)){m.visible=true;}if(m.tooltip&&m.tooltip.match(r)){m.visible=true;}});this._getInternalModel().refresh();};
f.prototype._updateInternalModel=function(){if(!this._bUpdateInternalModel){return;}this._bUpdateInternalModel=false;this._removeStyleOfMarkedTableItem();var m=this._getInternalModel().getProperty("/items");this._getInternalModel().setProperty("/items",this.getItems().map(function(i){return{columnKey:i.getColumnKey(),visible:true,text:i.getText(),tooltip:i.getTooltip(),persistentIndex:-1,persistentSelected:i.getVisible(),width:undefined,total:undefined};},this));this.getColumnsItems().forEach(function(o){var a=this._getModelItemByColumnKey(o.getColumnKey());if(!a){return;}if(o.getIndex()!==undefined){a.persistentIndex=o.getIndex();}if(o.getVisible()!==undefined){a.persistentSelected=o.getVisible();}if(o.getWidth()!==undefined){a.width=o.getWidth();}if(o.getTotal()!==undefined){a.total=o.getTotal();}},this);this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();var M=this._getInternalModel().getProperty("/items");this._sortModelItemsByPersistentIndex(M);this._updateCounts(M);this._getInternalModel().setProperty("/items",M);this._switchMarkedTableItemTo(this._getMarkedTableItem());if(q(M).not(m).length!==0||q(m).not(M).length!==0){this._bTableItemsChanged=true;}};
return f;},true);
sap.ui.predefine('sap/m/P13nConditionPanel',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/format/DateFormat','sap/ui/core/format/NumberFormat','sap/ui/core/IconPool'],function(q,a,C,D,N,I){"use strict";
var P=C.extend("sap.m.P13nConditionPanel",{
metadata:{library:"sap.m",properties:{maxConditions:{type:"string",group:"Misc",defaultValue:'-1'},exclude:{type:"boolean",group:"Misc",defaultValue:false},containerQuery:{type:"boolean",group:"Misc",defaultValue:false},autoAddNewRow:{type:"boolean",group:"Misc",defaultValue:false},disableFirstRemoveIcon:{type:"boolean",group:"Misc",defaultValue:false},alwaysShowAddIcon:{type:"boolean",group:"Misc",defaultValue:true},usePrevConditionSetting:{type:"boolean",group:"Misc",defaultValue:true},autoReduceKeyFieldItems:{type:"boolean",group:"Misc",defaultValue:false},layoutMode:{type:"string",group:"Misc",defaultValue:null},showLabel:{type:"boolean",group:"Misc",defaultValue:false},displayFormat:{type:"string",group:"Misc",defaultValue:null},validationExecutor:{type:"object",group:"Misc",defaultValue:null}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"}},events:{dataChange:{}}},
renderer:function(r,c){r.write("<section");r.writeControlData(c);r.addClass("sapMConditionPanel");r.writeClasses();r.writeStyles();r.write(">");r.write("<div");r.addClass("sapMConditionPanelContent");r.addClass("sapMConditionPanelBG");r.writeClasses();r.write(">");var b=c.getAggregation("content");var l=b.length;for(var i=0;i<l;i++){r.renderControl(b[i]);}r.write("</div>");r.write("</section>");}
});
P.prototype.setConditions=function(c){if(!c){q.sap.log.error("sap.m.P13nConditionPanel : aCondition is not defined");}if(this._bIgnoreSetConditions){return;}this._oConditionsMap={};this._aConditionKeys=[];this._iConditions=0;for(var i=0;i<c.length;i++){this._addCondition2Map(c[i]);}this._clearConditions();this._fillConditions();};
P.prototype.removeAllConditions=function(){this._oConditionsMap={};this._aConditionKeys=[];this._iConditions=0;this._clearConditions();this._fillConditions();};
P.prototype.addCondition=function(c){if(this._bIgnoreSetConditions){return;}c.index=this._iConditions;this._addCondition2Map(c);this._addCondition(c);};
P.prototype.insertCondition=function(c,i){if(this._bIgnoreSetConditions){return;}if(i!==undefined){c.index=i;}this._addCondition2Map(c);this._addCondition(c);};
P.prototype.removeCondition=function(c){this._clearConditions();if(typeof c=="string"){this._removeConditionFromMap(c);}if(typeof c=="object"){this._removeConditionFromMap(c.key);}this._fillConditions();};
P.prototype._addCondition2Map=function(c){if(!c.key){c.key="condition_"+this._iConditions;if(this.getExclude()){c.key="x"+c.key;}}this._iConditions++;this._oConditionsMap[c.key]=c;this._aConditionKeys.push(c.key);};
P.prototype._removeConditionFromMap=function(k){this._iConditions--;delete this._oConditionsMap[k];var i=this._aConditionKeys.indexOf(k);if(i>=0){this._aConditionKeys.splice(i,1);}};
P.prototype.getConditions=function(){var c;var b=[];if(this._oConditionsMap){for(var d in this._oConditionsMap){c=this._oConditionsMap[d];var v=c.value;if(!v){v=this._getFormatedConditionText(c.operation,c.value1,c.value2,c.exclude,c.keyField,c.showIfGrouped);}if(!c._oGrid||c._oGrid.select.getSelected()){b.push({"key":d,"text":v,"exclude":c.exclude,"operation":c.operation,"keyField":c.keyField,"value1":c.value1,"value2":c.operation===sap.m.P13nConditionOperation.BT?c.value2:null,"showIfGrouped":c.showIfGrouped});}}}return b;};
P.prototype.setOperations=function(o,t){t=t||"default";this._oTypeOperations[t]=o;this._updateAllOperations();};
P.prototype.setValues=function(v,t){t=t||"default";this._oTypeValues[t]=v;};
P.prototype.addOperation=function(o,t){t=t||"default";this._oTypeOperations[t].push(o);this._updateAllOperations();};
P.prototype.removeAllOperations=function(t){t=t||"default";this._oTypeOperations[t]=[];this._updateAllOperations();};
P.prototype.getOperations=function(t){t=t||"default";return this._oTypeOperations[t];};
P.prototype.setKeyFields=function(k){this._aKeyFields=k;this._updateKeyFieldItems(this._oConditionsGrid,true);this._updateAllConditionsEnableStates();this._createAndUpdateAllKeyFields();this._updateAllOperations();};
P.prototype.addKeyField=function(k){this._aKeyFields.push(k);this._updateKeyFieldItems(this._oConditionsGrid,true,true);this._updateAllConditionsEnableStates();this._createAndUpdateAllKeyFields();this._updateAllOperations();};
P.prototype.removeAllKeyFields=function(){this._aKeyFields=[];this._updateKeyFieldItems(this._oConditionsGrid,true);};
P.prototype.getKeyFields=function(){return this._aKeyFields;};
P.prototype.setAlwaysShowAddIcon=function(e){this.setProperty("alwaysShowAddIcon",e);if(this._oConditionsGrid){this._oConditionsGrid.toggleStyleClass("conditionRootGrid",this.getLayoutMode()!=="Desktop");}return this;};
P.prototype.setLayoutMode=function(l){this.setProperty("layoutMode",l);if(this._oConditionsGrid){this._oConditionsGrid.toggleStyleClass("conditionRootGrid",l!=="Desktop");}this._updateConditionFieldSpans(l);this._clearConditions();this._fillConditions();return this;};
P.prototype.setContainerQuery=function(e){this._unregisterResizeHandler();this.setProperty("containerQuery",e);this._registerResizeHandler();this._clearConditions();this._fillConditions();return this;};
P.prototype._updateConditionFieldSpans=function(m){if(this._aConditionsFields){var d=m==="Desktop";if(d){this._aConditionsFields[2].SpanFilter="L3 M3 S3";this._aConditionsFields[4].SpanFilter="L2 M2 S2";this._aConditionsFields[5].SpanFilter="L3 M3 S3";this._aConditionsFields[6].SpanFilter="L2 M2 S2";this._aConditionsFields[7].SpanFilter="L1 M1 S1";}var t=m==="Tablet";if(t){this._aConditionsFields[2].SpanFilter="L5 M5 S5";this._aConditionsFields[4].SpanFilter="L5 M5 S5";this._aConditionsFields[5].SpanFilter="L10 M10 S10";this._aConditionsFields[6].SpanFilter="L10 M10 S10";this._aConditionsFields[7].SpanFilter="L1 M1 S1";}}};
P.prototype.init=function(){sap.ui.getCore().loadLibrary("sap.ui.layout");q.sap.require("sap.ui.layout.Grid");sap.ui.layout.Grid.prototype.init.apply(this);this.addStyleClass("sapMConditionPanel");this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._sFromLabelText=this._oRb.getText("CONDITIONPANEL_LABELFROM");this._sToLabelText=this._oRb.getText("CONDITIONPANEL_LABELTO");this._sValueLabelText=this._oRb.getText("CONDITIONPANEL_LABELVALUE");this._sShowIfGroupedLabelText=this._oRb.getText("CONDITIONPANEL_LABELGROUPING");this._sValidationDialogFieldMessage=this._oRb.getText("CONDITIONPANEL_FIELDMESSAGE");this._oTypeOperations={"default":[]};this._oTypeValues={"default":[]};this._aKeyFields=[];this._oConditionsMap={};this._aConditionKeys=[];this._iConditions=0;this._sLayoutMode="Desktop";this._sConditionType="Filter";this._sAddRemoveIconTooltip="FILTER";this._iBreakPointTablet=sap.ui.Device.media._predefinedRangeSets[sap.ui.Device.media.RANGESETS.SAP_STANDARD].points[0];this._iBreakPointDesktop=sap.ui.Device.media._predefinedRangeSets[sap.ui.Device.media.RANGESETS.SAP_STANDARD].points[1];this._oConditionsGrid=new sap.ui.layout.Grid({width:"100%",defaultSpan:"L12 M12 S12",hSpacing:0,vSpacing:0}).toggleStyleClass("conditionRootGrid",this.getLayoutMode()!=="Desktop");this._iFirstConditionIndex=0;this._iConditionPageSize=10;this._oInvisibleTextField=new sap.ui.core.InvisibleText({text:this._oRb.getText("CONDITIONPANEL_FIELD_LABEL")});this._oInvisibleTextOperator=new sap.ui.core.InvisibleText({text:this._oRb.getText("CONDITIONPANEL_OPERATOR_LABEL")});this.addAggregation("content",this._oInvisibleTextField);this.addAggregation("content",this._oInvisibleTextOperator);this.addAggregation("content",this._oConditionsGrid);this._registerResizeHandler();this._aConditionsFields=[{"ID":"select","Label":"","SpanFilter":"L1 M1 S1","SpanSort":"L1 M1 S1","SpanGroup":"L1 M1 S1","Control":"CheckBox","Value":""},{"ID":"keyFieldLabel","Text":"Sort By","SpanFilter":"L1 M1 S1","SpanSort":"L1 M1 S1","SpanGroup":"L1 M1 S1","Control":"Label"},{"ID":"keyField","Label":"","SpanFilter":"L3 M5 S10","SpanSort":"L5 M5 S12","SpanGroup":"L4 M4 S12","Control":"ComboBox"},{"ID":"operationLabel","Text":"Sort Order","SpanFilter":"L1 M1 S1","SpanSort":"L1 M1 S1","SpanGroup":"L1 M1 S1","Control":"Label"},{"ID":"operation","Label":"","SpanFilter":"L2 M5 S10","SpanSort":sap.ui.Device.system.phone?"L5 M5 S8":"L5 M5 S9","SpanGroup":"L2 M5 S10","Control":"ComboBox"},{"ID":"value1","Label":this._sFromLabelText,"SpanFilter":"L3 M10 S10","SpanSort":"L3 M10 S10","SpanGroup":"L3 M10 S10","Control":"TextField","Value":""},{"ID":"value2","Label":this._sToLabelText,"SpanFilter":"L2 M10 S10","SpanSort":"L2 M10 S10","SpanGroup":"L2 M10 S10","Control":"TextField","Value":""},{"ID":"showIfGrouped","Label":this._sShowIfGroupedLabelText,"SpanFilter":"L1 M10 S10","SpanSort":"L1 M10 S10","SpanGroup":"L3 M4 S9","Control":"CheckBox","Value":"false"}];this._oButtonGroupSpan={"SpanFilter":"L1 M2 S2","SpanSort":sap.ui.Device.system.phone?"L2 M2 S4":"L2 M2 S3","SpanGroup":"L2 M2 S3"};this._updateConditionFieldSpans(this.getLayoutMode());this._fillConditions();};
P.prototype._createPaginatorToolbar=function(){this._bPaginatorButtonsVisible=false;var t=this;this._oPrevButton=new sap.m.Button({icon:sap.ui.core.IconPool.getIconURI("navigation-left-arrow"),tooltip:this._oRb.getText("WIZARD_FINISH"),visible:true,press:function(e){t._iFirstConditionIndex=Math.max(0,t._iFirstConditionIndex-t._iConditionPageSize);t._clearConditions();t._fillConditions();},layoutData:new sap.m.OverflowToolbarLayoutData({priority:sap.m.OverflowToolbarPriority.NeverOverflow})});this._oNextButton=new sap.m.Button({icon:sap.ui.core.IconPool.getIconURI("navigation-right-arrow"),tooltip:this._oRb.getText("WIZARD_NEXT"),visible:true,press:function(e){t._iFirstConditionIndex+=t._iConditionPageSize;t._clearConditions();t._fillConditions();},layoutData:new sap.m.OverflowToolbarLayoutData({priority:sap.m.OverflowToolbarPriority.NeverOverflow})});this._oRemoveAllButton=new sap.m.Button({text:this._oRb.getText("CONDITIONPANEL_REMOVE_ALL"),visible:true,press:function(e){t._aConditionKeys.forEach(function(k,i){if(i>=0){this.fireDataChange({key:k,index:i,operation:"remove",newData:null});}},t);this._iFirstConditionIndex=0;t.removeAllConditions();},layoutData:new sap.m.OverflowToolbarLayoutData({priority:sap.m.OverflowToolbarPriority.Low})});this._oAddButton=new sap.m.Button({icon:sap.ui.core.IconPool.getIconURI("add"),tooltip:this._oRb.getText("CONDITIONPANEL_ADD"+(this._sAddRemoveIconTooltipKey?"_"+this._sAddRemoveIconTooltipKey:"")+"_TOOLTIP"),visible:true,press:function(e){var c=t._createConditionRow(t._oConditionsGrid,undefined,null,0);t._changeField(c);setTimeout(function(){c.keyField.focus();});t._updatePaginatorToolbar();},layoutData:new sap.m.OverflowToolbarLayoutData({priority:sap.m.OverflowToolbarPriority.Low})});this._oHeaderText=new sap.m.Text({wrapping:false,layoutData:new sap.m.OverflowToolbarLayoutData({priority:sap.m.OverflowToolbarPriority.NeverOverflow})});this._oPageText=new sap.m.Text({wrapping:false,textAlign:sap.ui.core.TextAlign.Center,layoutData:new sap.m.OverflowToolbarLayoutData({priority:sap.m.OverflowToolbarPriority.NeverOverflow})});this._oFilterField=new sap.m.SearchField({width:"12rem",layoutData:new sap.m.OverflowToolbarLayoutData({priority:sap.m.OverflowToolbarPriority.High})});this._oPaginatorToolbar=new sap.m.OverflowToolbar({height:"3rem",design:sap.m.ToolbarDesign.Transparent,content:[this._oHeaderText,new sap.m.ToolbarSpacer(),this._oFilterField,this._oPrevButton,this._oPageText,this._oNextButton,this._oRemoveAllButton,this._oAddButton]});};
P.prototype._updatePaginatorToolbar=function(){if(this._sConditionType!=="Filter"||this.getMaxConditions()!=="-1"){return;}var i=this._aConditionKeys.length;var p=1+Math.floor(Math.max(0,i-1)/this._iConditionPageSize);var b=1+Math.floor(this._iFirstConditionIndex/this._iConditionPageSize);var o=this.getParent();if(!this._oPaginatorToolbar){if(i>this._iConditionPageSize){this._createPaginatorToolbar();this.insertAggregation("content",this._oPaginatorToolbar,0);this._onGridResize();}else{if(o&&o.setHeaderText){if(this._sOrgHeaderText==undefined){this._sOrgHeaderText=o.getHeaderText();}o.setHeaderText(this._sOrgHeaderText+(i>0?" ("+i+")":""));}return;}}this._oPrevButton.setEnabled(this._iFirstConditionIndex>0);this._oNextButton.setEnabled(this._iFirstConditionIndex+this._iConditionPageSize<i);if(o&&o.setHeaderToolbar){if(!o.getHeaderToolbar()){this.removeAggregation("content",this._oPaginatorToolbar);o.setHeaderToolbar(this._oPaginatorToolbar);o.attachExpand(function(e){this._setToolbarElementVisibility(e.getSource().getExpanded()&&this._bPaginatorButtonsVisible);}.bind(this));}}if(o&&o.setHeaderText){if(this._sOrgHeaderText==undefined){this._sOrgHeaderText=o.getHeaderText();}var h=this._sOrgHeaderText+(i>0?" ("+i+")":"");o.setHeaderText(h);this._oHeaderText.setText(h);}else{this._oHeaderText.setText(i+" Conditions");}this._oPageText.setText(b+"/"+p);this._bPaginatorButtonsVisible=this._bPaginatorButtonsVisible||p>1;this._setToolbarElementVisibility(this._bPaginatorButtonsVisible);if(b>p){this._iFirstConditionIndex-=Math.max(0,this._iConditionPageSize);this._clearConditions();this._fillConditions();}var n=0;this._oConditionsGrid.getContent().forEach(function(g){if(g.select.getSelected()){n++;}},this);if(p==b&&(i-this._iFirstConditionIndex)>n){this._clearConditions();this._fillConditions();}};
P.prototype._setToolbarElementVisibility=function(v){this._oPrevButton.setVisible(v);this._oNextButton.setVisible(v);this._oPageText.setVisible(v);this._oFilterField.setVisible(false);this._oAddButton.setVisible(v);this._oRemoveAllButton.setVisible(v);};
P.prototype.exit=function(){this._clearConditions();this._unregisterResizeHandler();this._aConditionsFields=null;this._aKeys=null;this._aKeyFields=null;this._oTypeOperations=null;this._oRb=null;this._sFromLabelText=null;this._sToLabelText=null;this._sValueLabelText=null;this._sValidationDialogFieldMessage=null;this._oConditionsMap=null;this._aConditionKeys=[];};
P.prototype._clearConditions=function(){var g=this._oConditionsGrid.getContent();g.forEach(function(G){for(var f in this._aConditionsFields){var b=this._aConditionsFields[f];if(G[b["ID"]]&&G.getContent().indexOf(G[b["ID"]])===-1){G[b["ID"]].destroy();}}},this);this._oConditionsGrid.destroyContent();};
P.prototype._fillConditions=function(){var c,s;var i=0,m=this._getMaxConditionsAsNumber(),n=this._aConditionKeys.length;if(this._oConditionsMap){var p=this._sConditionType!=="Filter"||this.getMaxConditions()!=="-1"?9999:this._iConditionPageSize;n=Math.min(n,Math.min(m,this._iFirstConditionIndex+p));for(i=this._iFirstConditionIndex;i<n;i++){s=this._aConditionKeys[i];c=this._oConditionsMap[s];this._createConditionRow(this._oConditionsGrid,c,s);}}this._updatePaginatorToolbar();if((this.getAutoAddNewRow()||this._oConditionsGrid.getContent().length===0)&&this._oConditionsGrid.getContent().length<m){this._createConditionRow(this._oConditionsGrid);}};
P.prototype._addCondition=function(c){var i=0;var m=this._getMaxConditionsAsNumber();if(this._oConditionsMap){for(var b in this._oConditionsMap){if(i<m&&c===this._oConditionsMap[b]){this._createConditionRow(this._oConditionsGrid,c,b,i);}i++;}}this._updatePaginatorToolbar();};
P.prototype._getMaxConditionsAsNumber=function(){return this.getMaxConditions()==="-1"?9999:parseInt(this.getMaxConditions(),10);};
P.prototype.onAfterRendering=function(){if(this.getLayoutMode()){this._sLayoutMode=this.getLayoutMode();return;}};
P.prototype._handleMediaChange=function(p){this._sLayoutMode=p.name;this._updateLayout(p);};
P.prototype._unregisterResizeHandler=function(){if(this._sContainerResizeListener){sap.ui.core.ResizeHandler.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null;}sap.ui.Device.media.detachHandler(this._handleMediaChange,this,sap.ui.Device.media.RANGESETS.SAP_STANDARD);};
P.prototype._registerResizeHandler=function(){if(this.getContainerQuery()){this._sContainerResizeListener=sap.ui.core.ResizeHandler.register(this._oConditionsGrid,q.proxy(this._onGridResize,this));this._onGridResize();}else{sap.ui.Device.media.attachHandler(this._handleMediaChange,this,sap.ui.Device.media.RANGESETS.SAP_STANDARD);}};
P.prototype._getKeyFromConditionGrid=function(c){var k=c.data("_key");if(!k){k=this._createConditionKey();}return k;};
P.prototype._createConditionKey=function(){var i=0;var k;do{k="condition_"+i;if(this.getExclude()){k="x"+k;}i++;}while(this._oConditionsMap[k]);return k;};
P.prototype._createConditionRow=function(t,c,k,p){var b=null;var g;var d=this;if(p===undefined){p=t.getContent().length;}var o=new sap.ui.layout.Grid({width:"100%",defaultSpan:"L12 M12 S12",hSpacing:1,vSpacing:0,containerQuery:this.getContainerQuery()}).data("_key",k);for(var f in this._aConditionsFields){var e;var h=this._aConditionsFields[f];switch(h["Control"]){case"CheckBox":e=new sap.m.CheckBox({enabled:false,visible:false,layoutData:new sap.ui.layout.GridData({span:h["Span"+this._sConditionType]})});if(h["ID"]==="showIfGrouped"){e.setEnabled(true);e.setText(h["Label"]);e.attachSelect(function(){d._changeField(o);});e.setSelected(c?c.showIfGrouped:true);}else{if(c){e.setSelected(true);e.setEnabled(true);}}break;case"ComboBox":if(h["ID"]==="keyField"){e=new sap.m.ComboBox({width:"100%",ariaLabelledBy:this._oInvisibleTextField});var O=q.proxy(e.setSelectedKey,e);e.setSelectedKey=function(k){O(k);var m=d.getValidationExecutor();if(m){m();}};var i=q.proxy(e.setSelectedItem,e);e.setSelectedItem=function(m){i(m);var n=d.getValidationExecutor();if(n){n();}};e.setLayoutData(new sap.ui.layout.GridData({span:h["Span"+this._sConditionType]}));this._fillKeyFieldListItems(e,this._aKeyFields);if(e.attachSelectionChange){e.attachSelectionChange(function(E){var m=d.getValidationExecutor();if(m){m();}d._handleSelectionChangeOnKeyField(t,o);});}if(e.attachChange){e.attachChange(function(E){o.keyField.close();d._handleChangeOnKeyField(t,o);});}if(e.setSelectedItem){if(c){e.setSelectedKey(c.keyField);this._aKeyFields.forEach(function(K,m){var n=K.key;if(n===undefined){n=K;}if(c.keyField===n){e.setSelectedItem(e.getItems()[m]);}},this);}else{if(this.getUsePrevConditionSetting()&&!this.getAutoReduceKeyFieldItems()){if(p>0&&!k){g=t.getContent()[p-1];if(g.keyField.getSelectedKey()){e.setSelectedKey(g.keyField.getSelectedKey());}else{if(!e.getSelectedItem()&&e.getItems().length>0){e.setSelectedItem(e.getItems()[0]);}}}else{this._aKeyFields.some(function(K,m){if(K.isDefault){e.setSelectedItem(e.getItems()[m]);return true;}if(!e.getSelectedItem()&&K.type!=="boolean"){e.setSelectedItem(e.getItems()[m]);}},this);if(!e.getSelectedItem()&&e.getItems().length>0){e.setSelectedItem(e.getItems()[0]);}}}else{this._aKeyFields.forEach(function(K,m){if(K.isDefault){e.setSelectedItem(e.getItems()[m]);}},this);}}}}if(h["ID"]==="operation"){e=new sap.m.Select({width:"100%",ariaLabelledBy:this._oInvisibleTextOperator,layoutData:new sap.ui.layout.GridData({span:h["Span"+this._sConditionType]})});e.attachChange(function(){d._handleChangeOnOperationField(t,o);});o[h["ID"]]=e;this._updateOperationItems(t,o);if(c){var K=this._getCurrentKeyFieldItem(o.keyField);var j=this._oTypeOperations["default"];if(K){if(K.type&&this._oTypeOperations[K.type]){j=this._oTypeOperations[K.type];}if(K.operations){j=K.operations;}}j.some(function(m,n){if(c.operation===m){e.setSelectedKey(m);return true;}},this);}else{if(this.getUsePrevConditionSetting()){if(p>0&&k===null){var g=t.getContent()[p-1];e.setSelectedKey(g.operation.getSelectedKey());}}}}if(e.getSelectedItem&&e.getSelectedItem()){e.setTooltip(e.getSelectedItem().getTooltip()||e.getSelectedItem().getText());}break;case"TextField":var l=this._getCurrentKeyFieldItem(o.keyField);e=this._createValueField(l,h,o);e.oTargetGrid=t;if(c&&c[h["ID"]]!==undefined){var v=c[h["ID"]];var V;if(e instanceof sap.m.Select){if(typeof v==="string"&&l.type==="boolean"){v=v==="true";}if(typeof v==="boolean"){e.setSelectedIndex(v?2:1);}else{e.setSelectedItem(e.getItemByKey(v.toString()));}}else{if(typeof v==="string"&&o.oFormatter instanceof sap.ui.core.format.NumberFormat){V=parseFloat(v);v=o.oFormatter.format(V);}if(typeof v==="string"&&o.oFormatter){V=o.oFormatter.parse(v);}else{V=v;}if(!isNaN(V)&&V!==null&&o.oFormatter){v=o.oFormatter.format(V);e.setValue(v);}else{if(!V&&v&&o.oFormatter instanceof sap.ui.core.format.DateFormat){V=new Date(v);v=o.oFormatter.format(V);e.setValue(v);}else{e.setValue(V);}}}}break;case"Label":e=new sap.m.Label({text:h["Text"]+":",visible:this.getShowLabel(),layoutData:new sap.ui.layout.GridData({span:h["Span"+this._sConditionType]})}).addStyleClass("conditionLabel");e.oTargetGrid=t;break;}o[h["ID"]]=e;o.addContent(e);}b=new sap.ui.layout.HorizontalLayout({layoutData:new sap.ui.layout.GridData({span:this.getLayoutMode()==="Desktop"?"L2 M2 S2":this._oButtonGroupSpan["Span"+this._sConditionType]})}).addStyleClass("floatRight");o.addContent(b);o["ButtonContainer"]=b;var r=new sap.m.Button({type:sap.m.ButtonType.Transparent,icon:sap.ui.core.IconPool.getIconURI("sys-cancel"),tooltip:this._oRb.getText("CONDITIONPANEL_REMOVE"+(this._sAddRemoveIconTooltipKey?"_"+this._sAddRemoveIconTooltipKey:"")+"_TOOLTIP"),press:function(){d._handleRemoveCondition(this.oTargetGrid,o);},layoutData:new sap.ui.layout.GridData({span:this.getLayoutMode()==="Desktop"?"L1 M1 S1":"L1 M2 S2"})});r.oTargetGrid=t;b.addContent(r);o["remove"]=r;var A=new sap.m.Button({type:sap.m.ButtonType.Transparent,icon:sap.ui.core.IconPool.getIconURI("add"),tooltip:this._oRb.getText("CONDITIONPANEL_ADD"+(this._sAddRemoveIconTooltipKey?"_"+this._sAddRemoveIconTooltipKey:"")+"_TOOLTIP"),press:function(){d._handleAddCondition(this.oTargetGrid,o);},layoutData:new sap.ui.layout.GridData({span:this.getLayoutMode()==="Desktop"?"L1 M1 S1":"L1 M10 S10"})});A.oTargetGrid=t;A.addStyleClass("conditionAddBtnFloatRight");b.addContent(A);o["add"]=A;t.insertContent(o,p);this._updateOperationItems(t,o);this._changeOperationValueFields(t,o);this._updateAllConditionsEnableStates();this._updateConditionButtons(t);if(this.getAutoReduceKeyFieldItems()){this._updateKeyFieldItems(t,false);}if(this._sLayoutMode){this._updateLayout({name:this._sLayoutMode});}if(c){var s=this._getFormatedConditionText(c.operation,c.value1,c.value2,c.exclude,c.keyField,c.showIfGrouped);c._oGrid=o;c.value=s;this._oConditionsMap[k]=c;}return o;};
P.prototype._handleRemoveCondition=function(t,c){var i=t.getContent().indexOf(c);this._removeCondition(t,c);if(this.getAutoReduceKeyFieldItems()){this._updateKeyFieldItems(t,false);}if(i>=0){i=Math.min(i,t.getContent().length-1);var c=t.getContent()[i];setTimeout(function(){c.remove.focus();});}this._updatePaginatorToolbar();};
P.prototype._handleAddCondition=function(t,s){var p=t.getContent().indexOf(s);var c=this._createConditionRow(t,undefined,null,p+1);this._changeField(c);setTimeout(function(){c.keyField.focus();});this._updatePaginatorToolbar();};
P.prototype._getCurrentKeyFieldItem=function(k){if(k.getSelectedKey&&k.getSelectedKey()){var K=k.getSelectedKey();var i=this._aKeyFields;for(var b in i){var o=i[b];if(o.key===K){return o;}}}return null;};
P.prototype._createValueField=function(c,f,o){var b;var s=c?c.type:"";var t=this;var p={value:f["Value"],width:"100%",placeholder:f["Label"],change:function(e){t._validateFormatFieldValue(e);t._changeField(o);},layoutData:new sap.ui.layout.GridData({span:f["Span"+this._sConditionType]})};switch(s){case"boolean":case"enum":var d=[];var v=c.values||this._oTypeValues[s]||["",false,true];v.forEach(function(V,i){d.push(new sap.ui.core.Item({key:s==="boolean"?(i===v.length-1).toString():V.toString(),text:V.toString()}));});p={width:"100%",items:d,change:function(){t._changeField(o);},layoutData:new sap.ui.layout.GridData({span:f["Span"+this._sConditionType]})};o.oFormatter=null;b=new sap.m.Select(p);break;case"numeric":var F;if(c.precision||c.scale){F={};if(c.precision){F["maxIntegerDigits"]=parseInt(c.precision,10);}if(c.scale){F["maxFractionDigits"]=parseInt(c.scale,10);}}o.oFormatter=N.getFloatInstance(F);b=new sap.m.Input(p);break;case"date":o.oFormatter=D.getDateInstance({strictParsing:true});b=new sap.m.DatePicker(p);break;case"time":o.oFormatter=D.getTimeInstance({strictParsing:true});b=new sap.m.TimePicker(p);break;default:o.oFormatter=null;b=new sap.m.Input(p);if(this._fSuggestCallback){var c=this._getCurrentKeyFieldItem(o.keyField);if(c&&c.key){var S=this._fSuggestCallback(b,c.key);if(S){b._oSuggestProvider=S;}}}}if(s!=="boolean"&&s!=="enum"){b.onpaste=function(e){var O;if(window.clipboardData){O=window.clipboardData.getData("Text");}else{O=e.originalEvent.clipboardData.getData('text/plain');}var o=e.srcControl.getParent();var g=O.split(/\r\n|\r|\n/g);if(g){setTimeout(function(){var L=g?g.length:0;if(L>1){var k=t._getCurrentKeyFieldItem(o.keyField);var h=o.operation;for(var i=0;i<L;i++){if(t._aConditionKeys.length>=t._getMaxConditionsAsNumber()){break;}if(g[i]){var j={"key":t._createConditionKey(),"exclude":t.getExclude(),"operation":h.getSelectedKey(),"keyField":k.key,"value1":g[i],"value2":null};t._addCondition2Map(j);t.fireDataChange({key:j.key,index:j.index,operation:"add",newData:j});}}t._clearConditions();t._fillConditions();}},0);}};}if(c&&c.maxLength&&b.setMaxLength){var l=-1;if(typeof c.maxLength==="string"){l=parseInt(c.maxLength,10);}if(typeof c.maxLength==="number"){l=c.maxLength;}if(l>0&&(!b.getShowSuggestion||!b.getShowSuggestion())){b.setMaxLength(l);}}return b;};
P.prototype._fillOperationListItems=function(c,o,t){if(t==="_STRING_"){t="";}if(t==="_TIME_"){t="_DATE_";}if(t==="_BOOLEAN_"){t="";}c.destroyItems();for(var O in o){var T=this._oRb.getText("CONDITIONPANEL_OPTION"+t+o[O]);if(q.sap.startsWith(T,"CONDITIONPANEL_OPTION")){T=this._oRb.getText("CONDITIONPANEL_OPTION"+o[O]);}c.addItem(new sap.ui.core.ListItem({key:o[O],text:T,tooltip:T}));}};
P.prototype._fillKeyFieldListItems=function(c,i){c.destroyItems();for(var b in i){var o=i[b];c.addItem(new sap.ui.core.ListItem({key:o.key,text:o.text,tooltip:o.tooltip?o.tooltip:o.text}));}};
P.prototype._handleChangeOnOperationField=function(t,c){this._changeOperationValueFields(t,c);this._changeField(c);};
P.prototype._handleSelectionChangeOnKeyField=function(t,c){if(this._sConditionType==="Filter"){this._updateOperationItems(t,c);this._createAndUpdateValueFields(t,c);this._changeOperationValueFields(t,c);}this._changeField(c);};
P.prototype._handleChangeOnKeyField=function(t,c){if(this.getAutoReduceKeyFieldItems()){this._updateKeyFieldItems(t,false,false,c.keyField);}};
P.prototype._createAndUpdateAllKeyFields=function(){var c=this._oConditionsGrid.getContent();c.forEach(function(o){this._createAndUpdateValueFields(this._oConditionsGrid,o);this._changeOperationValueFields(this._oConditionsGrid,o);},this);};
P.prototype._createAndUpdateValueFields=function(t,c){var o=this._getCurrentKeyFieldItem(c.keyField);var f=function(c,b,i){var O=b.getValue?b.getValue():"";var d=c.indexOfContent(b);c.removeContent(b);if(b._oSuggestProvider){b._oSuggestProvider.destroy();b._oSuggestProvider=null;}b.destroy();var e=this._aConditionsFields[i];b=this._createValueField(o,e,c);c[e["ID"]]=b;c.insertContent(b,d===-1?0:d);var v,V;if(c.oFormatter&&O){v=c.oFormatter.parse(O);if(!isNaN(v)&&v!==null){V=c.oFormatter.format(v);b.setValue(V);}}if(!V){b.setValue(O);}};q.proxy(f,this)(c,c.value1,5);q.proxy(f,this)(c,c.value2,6);};
P.prototype._updateAllOperations=function(){var c=this._oConditionsGrid.getContent();c.forEach(function(o){this._updateOperationItems(this._oConditionsGrid,o);this._changeOperationValueFields(this._oConditionsGrid,o);},this);};
P.prototype._updateOperationItems=function(t,c){var T="";var k=this._getCurrentKeyFieldItem(c.keyField);var o=c.operation;var O=this._oTypeOperations["default"];var b=o.getSelectedItem();if(k&&!this.getExclude()){if(k.type&&k.type!==""&&this._oTypeOperations[k.type]){T=k.type;O=this._oTypeOperations[T];}if(k.operations){O=k.operations;}}this._fillOperationListItems(o,O,T?"_"+T.toUpperCase()+"_":"");if(b&&o.getItemByKey(b.getKey())){o.setSelectedKey(b.getKey());}else{o.setSelectedItem(o.getItems()[0]);}this._sConditionType="Filter";if(O[0]===sap.m.P13nConditionOperation.Ascending||O[0]===sap.m.P13nConditionOperation.Descending){this._sConditionType="Sort";}if(O[0]===sap.m.P13nConditionOperation.GroupAscending||O[0]===sap.m.P13nConditionOperation.GroupDescending){this._sConditionType="Group";}this._adjustValue1Span(c);};
P.prototype._updateKeyFieldItems=function(t,f,A,o){var n=t.getContent().length;var i;var u={};if(!f){for(i=0;i<n;i++){var k=t.getContent()[i].keyField;var K=k.getSelectedKey();if(K!=null&&K!==""){u[K]=true;}}}for(i=0;i<n;i++){var k=t.getContent()[i].keyField;var s=t.getContent()[i].select;var O=k.getSelectedKey();var j=0;var b=this._aKeyFields;if(k!==o){if(A){j=b.length-1;}else{k.destroyItems();}for(j;j<b.length;j++){var c=b[j];if(c.key==null||c.key===""||!u[c.key]||c.key===O){k.addItem(new sap.ui.core.ListItem({key:c.key,text:c.text,tooltip:c.tooltip?c.tooltip:c.text}));}}}if(O){k.setSelectedKey(O);}else if(k.getItems().length>0){k.setSelectedItem(k.getItems()[0]);}if(!s.getSelected()){this._aKeyFields.some(function(d,e){if(d.isDefault){k.setSelectedItem(k.getItems()[e]);return true;}if(!k.getSelectedItem()){if(d.type!=="boolean"){k.setSelectedItem(k.getItems()[e]);}}},this);}if(k.getSelectedItem()){k.setTooltip(k.getSelectedItem().getTooltip()||k.getSelectedItem().getText());}}};
P.prototype._changeOperationValueFields=function(t,c){var o=c.operation;var O=o.getSelectedKey();var v=c.value1;var V=c.value2;var s=c.showIfGrouped;if(!O){return;}if(O===sap.m.P13nConditionOperation.BT){if(v.setPlaceholder&&v.getPlaceholder()!==this._sFromLabelText){v.setPlaceholder(this._sFromLabelText);}if(!v.getVisible()){v.setVisible(true);c.insertContent(v,c.getContent().length-1);}if(V.setPlaceholder&&V.getPlaceholder()!==this._sToLabelText){V.setPlaceholder(this._sToLabelText);}if(!V.getVisible()){V.setVisible(true);c.insertContent(V,c.getContent().length-1);}}else{if(O===sap.m.P13nConditionOperation.GroupAscending||O===sap.m.P13nConditionOperation.GroupDescending){if(v.getVisible()){v.setVisible(false);c.removeContent(v);}if(V.getVisible()){V.setVisible(false);c.removeContent(V);}if(o.getVisible()){o.setVisible(false);c.removeContent(o);}s.setVisible(this._getMaxConditionsAsNumber()!=1);}else{if(O===sap.m.P13nConditionOperation.NotEmpty||O===sap.m.P13nConditionOperation.Empty||O===sap.m.P13nConditionOperation.Initial||O===sap.m.P13nConditionOperation.Ascending||O===sap.m.P13nConditionOperation.Descending||O===sap.m.P13nConditionOperation.Total||O===sap.m.P13nConditionOperation.Average||O===sap.m.P13nConditionOperation.Minimum||O===sap.m.P13nConditionOperation.Maximum){if(v.getVisible()){v.setVisible(false);c.removeContent(v);}if(V.getVisible()){V.setVisible(false);c.removeContent(V);}c.removeContent(s);}else{if(v.setPlaceholder&&v.getPlaceholder()!==this._sValueLabelText){v.setPlaceholder(this._sValueLabelText);}if(!v.getVisible()){v.setVisible(true);c.insertContent(v,c.getContent().length-1);}if(V.getVisible()){V.setVisible(false);c.removeContent(V);}}}}this._adjustValue1Span(c);};
P.prototype._adjustValue1Span=function(c){if(this._sConditionType==="Filter"&&c.value1&&c.operation){var o=c.operation;var n=this._aConditionsFields[5]["Span"+this._sConditionType];if(o.getSelectedKey()!=="BT"){n="L5 M10 S10";}var l=c.value1.getLayoutData();if(l.getSpan()!==n){l.setSpan(n);}}};
P.prototype._getIndexOfCondition=function(c){var i=-1;c.getParent().getContent().some(function(g){if(g.select.getSelected()){i++;}return(g===c);},this);return i+this._iFirstConditionIndex;};
P.prototype._makeFieldValid=function(c,v){if(v){c.setValueState(sap.ui.core.ValueState.None);c.setValueStateText("");}else{c.setValueState(sap.ui.core.ValueState.Warning);c.setValueStateText(this._sValidationDialogFieldMessage);}};
P.prototype._validateFormatFieldValue=function(e){var c=e.oSource;var o=c.getParent();var v;if(c.getDateValue&&e){v=e.getParameter("value");var V=e.getParameter("valid");this._makeFieldValid(c,V);return;}else{v=c.getValue&&c.getValue();}if(!o){return;}if(this.getDisplayFormat()==="UpperCase"&&v){v=v.toUpperCase();c.setValue(v);}if(o.oFormatter&&v){var b=o.oFormatter.parse(v);var V=!isNaN(b)&&b!==null;this._makeFieldValid(c,V);if(V){v=o.oFormatter.format(b);c.setValue(v);}}else{this._makeFieldValid(c,true);}};
P.prototype._changeField=function(c,e){var k=c.keyField.getSelectedKey();if(c.keyField.getSelectedItem()){c.keyField.setTooltip(c.keyField.getSelectedItem().getTooltip()||c.keyField.getSelectedItem().getText());}else{c.keyField.setTooltip(null);}var o=c.operation.getSelectedKey();if(c.operation.getSelectedItem()){c.operation.setTooltip(c.operation.getSelectedItem().getTooltip()||c.operation.getSelectedItem().getText());}else{c.operation.setTooltip(null);}var v=this._getValueTextFromField(c.value1,c.oFormatter);var V=v;if(c.oFormatter&&v){V=c.oFormatter.parse(v);if(isNaN(V)||V===null){v="";}}if(o==="BT"&&c.value1.setMinDate){if(c.value2&&c.value2.setMinDate){c.value2.setMinDate(V instanceof Date?V:null);}}var s=this._getValueTextFromField(c.value2,c.oFormatter);var b=s;if(c.oFormatter&&s){b=c.oFormatter.parse(s);if(isNaN(b)||b===null){s="";}}var d=this._getCurrentKeyFieldItem(c.keyField);var f=d?d.type:"";if(f==="boolean"){var g=d.values||this._oTypeValues[f]||["",false,true];var t=g[g.length-1].toString();V=v===t;b=null;}var S=c.showIfGrouped.getSelected();var E=this.getExclude();var h=c.select;var i="";var K;if(k===""||k==null){k=null;K=this._getKeyFromConditionGrid(c);this._removeConditionFromMap(K);this._enableCondition(c,false);var j=this._getIndexOfCondition(c);if(h.getSelected()){h.setSelected(false);h.setEnabled(false);this._bIgnoreSetConditions=true;this.fireDataChange({key:K,index:j,operation:"remove",newData:null});this._bIgnoreSetConditions=false;}return;}this._enableCondition(c,true);i=this._getFormatedConditionText(o,v,s,E,k,S);var l={"value":i,"exclude":E,"operation":o,"keyField":k,"value1":V,"value2":o===sap.m.P13nConditionOperation.BT?b:null,"showIfGrouped":S};K=this._getKeyFromConditionGrid(c);if(i!==""){h.setSelected(true);h.setEnabled(true);var o="update";if(!this._oConditionsMap[K]){o="add";}this._oConditionsMap[K]=l;if(o==="add"){this._aConditionKeys.splice(this._getIndexOfCondition(c),0,K);}c.data("_key",K);this.fireDataChange({key:K,index:this._getIndexOfCondition(c),operation:o,newData:l});}else if(this._oConditionsMap[K]!==undefined){this._removeConditionFromMap(K);c.data("_key",null);var j=this._getIndexOfCondition(c);if(h.getSelected()){h.setSelected(false);h.setEnabled(false);this._bIgnoreSetConditions=true;this.fireDataChange({key:K,index:j,operation:"remove",newData:null});this._bIgnoreSetConditions=false;}}this._updatePaginatorToolbar();};
P.prototype._getValueTextFromField=function(c,f){if(c.getDateValue&&c.getDateValue()){return f.format(c.getDateValue());}if(c instanceof sap.m.Select){return c.getSelectedItem()?c.getSelectedItem().getText():"";}return c.getValue();};
P.prototype._updateAllConditionsEnableStates=function(){var c=this._oConditionsGrid.getContent();c.forEach(function(o){var k=this._getCurrentKeyFieldItem(o.keyField);var K=k&&k.key!==undefined?k.key:k;var e=K!==""&&K!==null;this._enableCondition(o,e);},this);};
P.prototype._enableCondition=function(c,e){c.operation.setEnabled(e);c.value1.setEnabled(e);c.value2.setEnabled(e);c.showIfGrouped.setEnabled(e);};
P.prototype._removeCondition=function(t,c){var k=this._getKeyFromConditionGrid(c);var i=-1;if(c.select.getSelected()){i=this._getIndexOfCondition(c);}this._removeConditionFromMap(k);c.destroy();if(t.getContent().length<1){this._createConditionRow(t);}else{this._updateConditionButtons(t);}if(i>=0){this.fireDataChange({key:k,index:i,operation:"remove",newData:null});}};
P.prototype._updateConditionButtons=function(t){var m=this._getMaxConditionsAsNumber();var n=t.getContent().length;for(var i=0;i<n;i++){var A=t.getContent()[i].add;if((this.getAlwaysShowAddIcon()&&(n<m))||(i===n-1&&i<m-1)){A.removeStyleClass("displayNone");}else{A.addStyleClass("displayNone");}var r=t.getContent()[i].remove;if(m===1||(i===0&&n===1&&this.getDisableFirstRemoveIcon())){r.addStyleClass("displayNone");}else{r.removeStyleClass("displayNone");}}};
P.prototype.validateConditions=function(){var t=this;var c=function(g){var v=true;for(var i=0;i<g.length;i++){var G=g[i];var b=t._checkCondition(G,i===g.length-1);v=v&&b;}return v;};return c(this._oConditionsGrid.getContent());};
P.prototype.removeValidationErrors=function(){this._oConditionsGrid.getContent().forEach(function(c){var v=c.value1;var V=c.value2;v.setValueState(sap.ui.core.ValueState.None);v.setValueStateText("");V.setValueState(sap.ui.core.ValueState.None);V.setValueStateText("");},this);};
P.prototype.removeInvalidConditions=function(){var i=[];this._oConditionsGrid.getContent().forEach(function(c){if(c.value1.getValueState()!==sap.ui.core.ValueState.None||c.value2.getValueState()!==sap.ui.core.ValueState.None){i.push(c);}},this);i.forEach(function(c){this._removeCondition(this._oConditionsGrid,c);if(this.getAutoReduceKeyFieldItems()){this._updateKeyFieldItems(this._oConditionsGrid,false);}},this);};
P.prototype._checkCondition=function(c,i){var v=true;var b=c.value1;var d=c.value2;var V=b&&(b.getVisible()&&!this._getValueTextFromField(b,c.oFormatter));var e=b&&b.getVisible()&&b.getValueState?b.getValueState():sap.ui.core.ValueState.None;var f=d&&(d.getVisible()&&!this._getValueTextFromField(d,c.oFormatter));var g=d&&d.getVisible()&&d.getValueState?d.getValueState():sap.ui.core.ValueState.None;var o=c.operation.getSelectedKey();if(o===sap.m.P13nConditionOperation.BT){if(!V?f:!f){if(V){b.setValueState(sap.ui.core.ValueState.Warning);b.setValueStateText(this._sValidationDialogFieldMessage);}if(f){d.setValueState(sap.ui.core.ValueState.Warning);d.setValueStateText(this._sValidationDialogFieldMessage);}v=false;}else if(e!==sap.ui.core.ValueState.None||g!==sap.ui.core.ValueState.None){v=false;}else{b.setValueState(sap.ui.core.ValueState.None);b.setValueStateText("");d.setValueState(sap.ui.core.ValueState.None);d.setValueStateText("");}}if((b.getVisible()&&b.getValueState&&b.getValueState()!==sap.ui.core.ValueState.None)||(d.getVisible()&&d.getValueState&&d.getValueState()!==sap.ui.core.ValueState.None)){v=false;}return v;};
P.prototype._getFormatedConditionText=function(o,v,V,e,k,s){var c="";var K=null;if(this._aKeyFields&&this._aKeyFields.length>1){for(var i=0;i<this._aKeyFields.length;i++){var b=this._aKeyFields[i];if(typeof b!=="string"){if(b.key===k&&b.text){K=b.text;}}}}switch(o){case sap.m.P13nConditionOperation.EQ:if(v!==""&&v!==undefined){c="="+v;}break;case sap.m.P13nConditionOperation.GT:if(v!==""&&v!==undefined){c=">"+v;}break;case sap.m.P13nConditionOperation.GE:if(v!==""&&v!==undefined){c=">="+v;}break;case sap.m.P13nConditionOperation.LT:if(v!==""&&v!==undefined){c="<"+v;}break;case sap.m.P13nConditionOperation.LE:if(v!==""&&v!==undefined){c="<="+v;}break;case sap.m.P13nConditionOperation.Contains:if(v!==""&&v!==undefined){c="*"+v+"*";}break;case sap.m.P13nConditionOperation.StartsWith:if(v!==""&&v!==undefined){c=v+"*";}break;case sap.m.P13nConditionOperation.EndsWith:if(v!==""&&v!==undefined){c="*"+v;}break;case sap.m.P13nConditionOperation.BT:if(v!==""&&v!==undefined){if(V!==""){c=v+"..."+V;}}break;case sap.m.P13nConditionOperation.Initial:c="=''";break;case sap.m.P13nConditionOperation.Empty:c="''";break;case sap.m.P13nConditionOperation.NotEmpty:c="!''";break;case sap.m.P13nConditionOperation.Ascending:c="ascending";break;case sap.m.P13nConditionOperation.GroupAscending:c="ascending";c+=" showIfGrouped:"+s;break;case sap.m.P13nConditionOperation.Descending:c="descending";break;case sap.m.P13nConditionOperation.GroupDescending:c="descending";c+=" showIfGrouped:"+s;break;case sap.m.P13nConditionOperation.Total:c="total";break;case sap.m.P13nConditionOperation.Average:c="average";break;case sap.m.P13nConditionOperation.Minimum:c="minimum";break;case sap.m.P13nConditionOperation.Maximum:c="maximum";break;}if(e&&c!==""){c="!("+c+")";}if(K&&c!==""){c=K+": "+c;}return c;};
P.prototype._updateLayout=function(r){if(!this._oConditionsGrid){return;}var g=this._oConditionsGrid.getContent();var n=this._aConditionsFields.length;var b=n;if(r.name==="Tablet"){b=5;}if(r.name==="Phone"){b=3;}if(this._sConditionType==="Filter"){for(var i=0;i<g.length;i++){var c=g[i];c.ButtonContainer.removeStyleClass("floatRight");c.removeContent(c.ButtonContainer);c.insertContent(c.ButtonContainer,b);if(!this.getAlwaysShowAddIcon()){if(b!==n){c.ButtonContainer.removeContent(c.add);c.addContent(c.add);}else{c.removeContent(c.add);c.ButtonContainer.addContent(c.add);}}}}};
P.prototype._onGridResize=function(){if(this._oPaginatorToolbar&&this._oConditionsGrid&&this._oConditionsGrid.getContent().length>0){var g=this._oConditionsGrid.getContent()[0];if(g.remove&&g.remove.$().position()){var w=0;if(this._oPaginatorToolbar.getParent()&&this._oPaginatorToolbar.getParent().getExpandable&&this._oPaginatorToolbar.getParent().getExpandable()){w=48-4;}var t=g.remove.$().position().left-w+g.remove.$().width();this._oPaginatorToolbar.setWidth(t+"px");}}var d=this._oConditionsGrid.getDomRef();if(!d){return;}if(!q(d).is(":visible")){return;}var w=d.clientWidth;var r={};if(w<=this._iBreakPointTablet){r.name="Phone";}else if((w>this._iBreakPointTablet)&&(w<=this._iBreakPointDesktop)){r.name="Tablet";}else{r.name="Desktop";}if(r.name==="Phone"&&this._sLayoutMode!==r.name){this._updateLayout(r);this._sLayoutMode=r.name;}if(r.name==="Tablet"&&this._sLayoutMode!==r.name){this._updateLayout(r);this._sLayoutMode=r.name;}if(r.name==="Desktop"&&this._sLayoutMode!==r.name){this._updateLayout(r);this._sLayoutMode=r.name;}};
sap.m.P13nConditionOperation={BT:"BT",EQ:"EQ",Contains:"Contains",StartsWith:"StartsWith",EndsWith:"EndsWith",LT:"LT",LE:"LE",GT:"GT",GE:"GE",Initial:"Initial",Empty:"Empty",NotEmpty:"NotEmpty",Ascending:"Ascending",Descending:"Descending",GroupAscending:"GroupAscending",GroupDescending:"GroupDescending",Total:"Total",Average:"Average",Minimum:"Minimum",Maximum:"Maximum"};return P;},true);
sap.ui.predefine('sap/m/P13nDialog',['jquery.sap.global','./Dialog','./IconTabBar','./IconTabFilter','./library','sap/ui/core/EnabledPropagator','sap/m/DialogRenderer','sap/ui/core/library'],function(q,D,I,a,l,E,b,c){"use strict";var M=c.MessageType;var B=l.ButtonType;
var P=D.extend("sap.m.P13nDialog",{
metadata:{library:"sap.m",properties:{initialVisiblePanelType:{type:"string",group:"Misc",defaultValue:null},showReset:{type:"boolean",group:"Appearance",defaultValue:false},showResetEnabled:{type:"boolean",group:"Appearance",defaultValue:false},validationExecutor:{type:"object",group:"Misc",defaultValue:null}},aggregations:{panels:{type:"sap.m.P13nPanel",multiple:true,singularName:"panel",bindable:"bindable"}},events:{ok:{},cancel:{},reset:{}}},
renderer:function(r,C){b.render.apply(this,arguments);var i=C._getVisiblePanelID();var p=C.getVisiblePanel();if(i&&p){r.write("<div");r.writeAttribute("id",i);r.write(">");r.renderControl(p);r.write("</div>");}}
});
E.apply(P.prototype,[true]);
P.prototype.init=function(e){this.addStyleClass("sapMP13nDialog");D.prototype.init.apply(this,arguments);this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._oResetButton=null;this._mValidationListener={};this._createDialog();};
P.prototype.setShowReset=function(s){this.setProperty("showReset",s);if(this.getButtons()&&this.getButtons()[2]){this.getButtons()[2].setVisible(s);}return this;};
P.prototype.setShowResetEnabled=function(e){this.setProperty("showResetEnabled",e);if(this.getButtons()&&this.getButtons()[2]){this.getButtons()[2].setEnabled(e);}return this;};
P.prototype.addPanel=function(p){this.addAggregation("panels",p);var n=this._mapPanelToNavigationItem(p);p.data("sapMP13nDialogNavigationItem",n);var N=this._getNavigationControl();if(N){sap.ui.Device.system.phone?N.addItem(n):N.addButton(n);}this._setVisibilityOfPanel(p);this._setDialogTitleFor(p);return this;};
P.prototype.insertPanel=function(p,i){this.insertAggregation("panels",p,i);var n=this._mapPanelToNavigationItem(p);p.data("sapMP13nDialogNavigationItem",n);var N=this._getNavigationControl();if(N){sap.ui.Device.system.phone?N.insertItem(n):N.insertButton(n);}this._setVisibilityOfPanel(p);this._setDialogTitleFor(p);return this;};
P.prototype.removePanel=function(p){p=this.removeAggregation("panels",p);var n=this._getNavigationControl();if(n){sap.ui.Device.system.phone?n.removeItem(p&&this._getNavigationItemByPanel(p)):n.removeButton(p&&this._getNavigationItemByPanel(p));}return p;};
P.prototype.removeAllPanels=function(){var p=this.removeAllAggregation("panels");var n=this._getNavigationControl();if(n){sap.ui.Device.system.phone?n.removeAllItems():n.removeAllButtons();}return p;};
P.prototype.destroyPanels=function(){this.destroyAggregation("panels");var n=this._getNavigationControl();if(n){sap.ui.Device.system.phone?n.destroyItems():n.destroyButtons();}return this;};
P.prototype._createDialog=function(){if(sap.ui.Device.system.phone){var t=this;this.setStretch(true);this.setVerticalScrolling(false);this.setHorizontalScrolling(false);this.setCustomHeader(new sap.m.Bar({contentLeft:new sap.m.Button({visible:false,type:B.Back,press:function(e){t._backToList();}}),contentMiddle:new sap.m.Title({text:this._oResourceBundle.getText("P13NDIALOG_VIEW_SETTINGS"),level:"H1"})}));this.addButton(this._createOKButton());this.addButton(this._createCancelButton());this.addButton(this._createResetButton());}else{this.setHorizontalScrolling(false);this.setContentWidth("65rem");this.setContentHeight("40rem");this.setDraggable(true);this.setResizable(true);this.setTitle(this._oResourceBundle.getText("P13NDIALOG_VIEW_SETTINGS"));this.addButton(this._createOKButton());this.addButton(this._createCancelButton());this.addButton(this._createResetButton());}};
P.prototype._getNavigationControl=function(){if(this.getPanels().length<2){return null;}var t=this;if(sap.ui.Device.system.phone){if(!this.getContent().length){this.addContent(new sap.m.List({mode:sap.m.ListMode.None,itemPress:function(e){if(e){t._switchPanel(e.getParameter("listItem"));}}}));this.getContent()[0].addItem(this._getNavigationItemByPanel(this.getPanels()[0]));}return this.getContent()[0];}else{if(!this.getSubHeader()||!this.getSubHeader().getContentLeft().length){this.setSubHeader(new sap.m.Bar({contentLeft:[new sap.m.SegmentedButton({select:function(e){t._switchPanel(e.getParameter("button"));},width:'100%'})]}));this.getSubHeader().getContentLeft()[0].addButton(this._getNavigationItemByPanel(this.getPanels()[0]));}return this.getSubHeader().getContentLeft()[0];}};
P.prototype._showValidationDialog=function(C,f,v){var w=[];var e=[];this._prepareMessages(f,v,w,e);q.sap.require("sap.m.MessageBox");var m="";if(e.length){e.forEach(function(o,i,d){m=(d.length>1?"• ":"")+o.messageText+"\n"+m;});sap.m.MessageBox.show(m,{icon:sap.m.MessageBox.Icon.ERROR,title:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_TITLE_ERROR"),actions:[sap.m.MessageBox.Action.CLOSE],styleClass:!!this.$().closest(".sapUiSizeCompact").length?"sapUiSizeCompact":""});}else if(w.length){w.forEach(function(o,i,d){m=(d.length>1?"• ":"")+o.messageText+"\n"+m;});m=m+sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_MESSAGE_QUESTION");sap.m.MessageBox.show(m,{icon:sap.m.MessageBox.Icon.WARNING,title:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_TITLE"),actions:[sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_FIX"),sap.m.MessageBox.Action.IGNORE],onClose:function(A){if(A===sap.m.MessageBox.Action.IGNORE){C();}},styleClass:!!this.$().closest(".sapUiSizeCompact").length?"sapUiSizeCompact":""});}};
P.prototype._prepareMessages=function(f,v,w,e){if(!f.length&&!v.length){return;}f.forEach(function(p){switch(p){case sap.m.P13nPanelType.filter:v.push({messageType:M.Warning,messageText:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_MESSAGE")});break;case sap.m.P13nPanelType.columns:v.push({messageType:M.Warning,messageText:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VISIBLE_ITEMS_THRESHOLD_MESSAGE")});break;case sap.m.P13nPanelType.dimeasure:v.push({messageType:M.Error,messageText:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_CHARTTYPE")});break;}});var u=v.filter(function(m,d,g){for(var i=++d;i<g.length;i++){if(m.messageText===g[i].messageText){return false;}}return true;});u.forEach(function(m){if(m.messageType===M.Warning){w.push(m);}else if(m.messageType===M.Error){e.push(m);}});};
P.prototype._mapPanelToNavigationItem=function(p){if(!p){return null;}var n=null;if(sap.ui.Device.system.phone){n=new sap.m.StandardListItem({type:sap.m.ListType.Navigation,title:p.getBindingPath("title")?q.extend(true,{},p.getBindingInfo("title")):p.getTitle()});}else{n=new sap.m.Button({type:B.Default,text:p.getBindingPath("title")?q.extend(true,{},p.getBindingInfo("title")):p.getTitle()});}p.setValidationExecutor(q.proxy(this._callValidationExecutor,this));p.setValidationListener(q.proxy(this._registerValidationListener,this));p.setChangeNotifier(q.proxy(this._callChangeNotifier,this));return n;};
P.prototype._switchPanel=function(n){var p=this._getPanelByNavigationItem(n);this.setVerticalScrolling(p.getVerticalScrolling());if(sap.ui.Device.system.phone){var N=this._getNavigationControl();if(N){N.setVisible(false);p.beforeNavigationTo();p.setVisible(true);this.getCustomHeader().getContentMiddle()[0].setText(p.getTitle());this.getCustomHeader().getContentLeft()[0].setVisible(true);}}else{this.getPanels().forEach(function(o){if(o===p){o.beforeNavigationTo();o.setVisible(true);}else{o.setVisible(false);}},this);}this.invalidate();this.rerender();};
P.prototype._backToList=function(){var n=this._getNavigationControl();if(n){n.setVisible(true);var p=this.getVisiblePanel();p.setVisible(false);this._setDialogTitleFor(p);this.getCustomHeader().getContentLeft()[0].setVisible(false);}};
P.prototype.getVisiblePanel=function(){var p=null;this.getPanels().some(function(o){if(o.getVisible()){p=o;return true;}});return p;};
P.prototype._getPanelByNavigationItem=function(n){for(var i=0,p=this.getPanels(),d=p.length;i<d;i++){if(p[i].data("sapMP13nDialogNavigationItem")===n){return p[i];}}return null;};
P.prototype._getNavigationItemByPanel=function(p){if(!p){return null;}return p.data("sapMP13nDialogNavigationItem");};
P.prototype._setVisibilityOfOtherPanels=function(p,v){for(var i=0,d=this.getPanels(),e=d.length;i<e;i++){if(d[i]===p){continue;}d[i].setVisible(v);}};
P.prototype._setVisibilityOfPanel=function(p){var v;if(sap.ui.Device.system.phone){v=this.getPanels().length===1;if(v){p.beforeNavigationTo();if(!this.getModel()){this.setModel(p.getModel("$sapmP13nPanel"),"$sapmP13nDialog");}}p.setVisible(v);this._setVisibilityOfOtherPanels(p,false);}else{v=this.getInitialVisiblePanelType()===p.getType()||this.getPanels().length===1;if(v){p.beforeNavigationTo();if(!this.getModel()){this.setModel(p.getModel("$sapmP13nPanel"),"$sapmP13nDialog");}}p.setVisible(v);if(v){this._setVisibilityOfOtherPanels(p,false);this.setVerticalScrolling(p.getVerticalScrolling());var o=this._getNavigationItemByPanel(p);var n=this._getNavigationControl();if(n){n.setSelectedButton(o);}}}};
P.prototype.onAfterRendering=function(){D.prototype.onAfterRendering.apply(this,arguments);var C=q(this.getFocusDomRef()).find(".sapMDialogScrollCont");var i=this._getVisiblePanelID();if(i&&C){var p=q.find("#"+i);q(p).appendTo(q(C));}};
P.prototype._getVisiblePanelID=function(){var p=this.getVisiblePanel();if(p){return this.getId()+"-panel_"+p.getId();}return null;};
P.prototype._setDialogTitleFor=function(p){var t;if(this.getPanels().length>1){t=this._oResourceBundle.getText("P13NDIALOG_VIEW_SETTINGS");}else{switch(p.getType()){case sap.m.P13nPanelType.filter:t=this._oResourceBundle.getText("P13NDIALOG_TITLE_FILTER");break;case sap.m.P13nPanelType.sort:t=this._oResourceBundle.getText("P13NDIALOG_TITLE_SORT");break;case sap.m.P13nPanelType.group:t=this._oResourceBundle.getText("P13NDIALOG_TITLE_GROUP");break;case sap.m.P13nPanelType.columns:t=this._oResourceBundle.getText("P13NDIALOG_TITLE_COLUMNS");break;case sap.m.P13nPanelType.dimeasure:t=this._oResourceBundle.getText("P13NDIALOG_TITLE_DIMEASURE");break;default:t=p.getTitleLarge()||this._oResourceBundle.getText("P13NDIALOG_VIEW_SETTINGS");}}if(sap.ui.Device.system.phone){this.getCustomHeader().getContentMiddle()[0].setText(t);}else{this.setTitle(t);}};
P.prototype._registerValidationListener=function(p,C){if(this.getPanels().indexOf(p)&&C&&this._mValidationListener[p.getType()]===undefined){this._mValidationListener[p.getType()]=C;}};
P.prototype._callValidationExecutor=function(){var v=this.getValidationExecutor();if(v&&!q.isEmptyObject(this._mValidationListener)){var t=this;v(this._getPayloadOfPanels()).then(function(V){var r=t._distributeValidationResult(V);for(var T in t._mValidationListener){var C=t._mValidationListener[T];C(r[T]||[]);}});}};
P.prototype._callChangeNotifier=function(p){if(this.getShowReset()){this.setShowResetEnabled(true);}};
P.prototype._distributeValidationResult=function(r){var d={};r.forEach(function(R){R.panelTypes.forEach(function(t){if(d[t]===undefined){d[t]=[];}d[t].push({columnKey:R.columnKey,messageType:R.messageType,messageText:R.messageText});});});return d;};
P.prototype._createOKButton=function(){var t=this;return new sap.m.Button({text:this._oResourceBundle.getText("P13NDIALOG_OK"),layoutData:new sap.m.OverflowToolbarLayoutData({priority:sap.m.OverflowToolbarPriority.NeverOverflow}),press:function(){t.setBusy(true);var p=t._getPayloadOfPanels();var f=function(){t.setBusy(false);t.fireOk({payload:p});};var F=[];var C=function(){t.getPanels().forEach(function(o){if(F.indexOf(o.getType())>-1){o.onAfterNavigationFrom();}});f();};t.getPanels().forEach(function(o){if(!o.onBeforeNavigationFrom()){F.push(o.getType());}});var v=[];var V=t.getValidationExecutor();if(V){V(p).then(function(v){if(F.length||v.length){t.setBusy(false);t._showValidationDialog(C,F,v);}else{f();}});}else{if(F.length||v.length){t.setBusy(false);t._showValidationDialog(C,F,v);}else{f();}}}});};
P.prototype._createCancelButton=function(){var t=this;return new sap.m.Button({text:this._oResourceBundle.getText("P13NDIALOG_CANCEL"),layoutData:new sap.m.OverflowToolbarLayoutData({priority:sap.m.OverflowToolbarPriority.NeverOverflow}),press:function(){t.fireCancel();}});};
P.prototype._createResetButton=function(){var t=this;return new sap.m.Button({text:this._oResourceBundle.getText("P13NDIALOG_RESET"),layoutData:new sap.m.OverflowToolbarLayoutData({priority:sap.m.OverflowToolbarPriority.NeverOverflow}),visible:this.getShowReset(),enabled:this.getShowResetEnabled(),press:function(){t.setShowResetEnabled(false);var p={};t.getPanels().forEach(function(o){p[o.getType()]=o.getResetPayload();});t.fireReset({payload:p});}});};
P.prototype._getPayloadOfPanels=function(){var p={};this.getPanels().forEach(function(o){p[o.getType()]=o.getOkPayload();});return p;};
P.prototype.exit=function(){D.prototype.exit.apply(this,arguments);};
return P;},true);
sap.ui.predefine('sap/m/P13nDimMeasureItem',['jquery.sap.global','./library','sap/ui/core/Item'],function(q,l,I){"use strict";
var P=I.extend("sap.m.P13nDimMeasureItem",{metadata:{library:"sap.m",properties:{columnKey:{type:"string"},index:{type:"int",defaultValue:-1},visible:{type:"boolean"},role:{type:"string"}}}});
return P;},true);
sap.ui.predefine('sap/m/P13nDimMeasurePanel',['jquery.sap.global','./ColumnListItem','./P13nPanel','./P13nDimMeasureItem','./SearchField','./Table','./library','sap/ui/core/Control','sap/ui/model/ChangeReason','sap/ui/model/json/JSONModel'],function(q,C,P,c,S,T,l,d,e,J){"use strict";
var f=P.extend("sap.m.P13nDimMeasurePanel",{
metadata:{library:"sap.m",properties:{chartTypeKey:{type:"string",defaultValue:""}},aggregations:{dimMeasureItems:{type:"sap.m.P13nDimMeasureItem",multiple:true,singularName:"dimMeasureItem",bindable:"bindable"},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"},availableChartTypes:{type:"sap.ui.core.Item",multiple:true,singularName:"availableChartType"}},events:{changeDimMeasureItems:{},changeChartType:{}}},
renderer:function(r,o){r.write("<div");r.writeControlData(o);r.addClass("sapMP13nColumnsPanel");r.writeClasses();r.write(">");var a=o.getAggregation("content");if(a){a.forEach(function(b){r.renderControl(b);});}r.write("</div>");}
});
f.prototype.init=function(){var t=this;this._iLiveChangeTimer=0;this._iSearchTimer=0;this._bIgnoreUpdateInternalModel=false;this._bUpdateInternalModel=true;this._bOnAfterRenderingFirstTimeExecuted=false;var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");this.oAvailableRoleTypes={Dimension:[{key:"category",text:r.getText('COLUMNSPANEL_CHARTROLE_CATEGORY')},{key:"series",text:r.getText('COLUMNSPANEL_CHARTROLE_SERIES')}],Measure:[{key:"axis1",text:r.getText('COLUMNSPANEL_CHARTROLE_AXIS1')},{key:"axis2",text:r.getText('COLUMNSPANEL_CHARTROLE_AXIS2')}]};var m=new J({availableChartTypes:[],selectedChartTypeKey:null,items:[],columnKeyOfMarkedItem:undefined,isMoveDownButtonEnabled:undefined,isMoveUpButtonEnabled:undefined,showOnlySelectedItems:undefined,countOfSelectedItems:0,countOfItems:0});m.setDefaultBindingMode(sap.ui.model.BindingMode.TwoWay);m.setSizeLimit(1000);this.setModel(m,"$sapmP13nDimMeasurePanel");this.setType(sap.m.P13nPanelType.dimeasure);this.setTitle(r.getText("CHARTPANEL_TITLE"));this._createTable();this._createToolbar();this.setVerticalScrolling(false);var s=new sap.m.ScrollContainer({horizontal:false,vertical:true,content:[this._oTable],width:'100%',height:'100%'});this.addAggregation("content",s);this._fnHandleResize=function(){var b=false,i,a;if(t.getParent){var $=null,g,h;var p=t.getParent();var o=t._getToolbar();if(p){$=q("#"+p.getId()+"-cont");if($.children().length>0&&o.$().length>0){i=s.$()[0].clientHeight;g=$.children()[0].clientHeight;h=o?o.$()[0].clientHeight:0;a=g-h;if(i!==a){s.setHeight(a+'px');b=true;}}}}return b;};this._sContainerResizeListener=sap.ui.core.ResizeHandler.register(s,this._fnHandleResize);};
f.prototype.onBeforeRendering=function(){this._updateInternalModel();if(!this._getInternalModel().getProperty("/columnKeyOfMarkedItem")){this._setColumnKeyOfMarkedItem(this._getColumnKeyByTableItem(this._getVisibleTableItems()[0]));}this._switchMarkedTableItemTo(this._getTableItemByColumnKey(this._getInternalModel().getProperty("/columnKeyOfMarkedItem")));this._updateControlLogic();};
f.prototype.onAfterRendering=function(){var t=this;if(!this._bOnAfterRenderingFirstTimeExecuted){this._bOnAfterRenderingFirstTimeExecuted=true;window.clearTimeout(this._iLiveChangeTimer);this._iLiveChangeTimer=window.setTimeout(function(){t._fnHandleResize();t._getToolbar()._resetAndInvalidateToolbar();},0);}};
f.prototype.getOkPayload=function(){this._updateInternalModel();this._getInternalModel().getProperty("/items").forEach(function(m){if(this._getDimMeasureItemByColumnKey(m.columnKey)){return;}if(!m.persistentSelected){return;}this.addAggregation("dimMeasureItems",new sap.m.P13nDimMeasureItem({columnKey:m.columnKey,visible:m.persistentSelected,index:m.persistentIndex===-1?undefined:m.persistentIndex,role:m.role}));},this);return{dimMeasureItems:this.getDimMeasureItems(),chartTypeKey:this.getChartTypeKey()};};
f.prototype.exit=function(){sap.ui.core.ResizeHandler.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null;this._getToolbar().destroy();this._oTable.destroy();this._oTable=null;if(this._getInternalModel()){this._getInternalModel().destroy();}window.clearTimeout(this._iLiveChangeTimer);window.clearTimeout(this._iSearchTimer);};
f.prototype.addItem=function(i){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.addAggregation("items",i);return this;};
f.prototype.insertItem=function(i,I){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.insertAggregation("items",i,I);return this;};
f.prototype.removeItem=function(i){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}i=this.removeAggregation("items",i);return i;};
f.prototype.removeAllItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAllAggregation("items");};
f.prototype.destroyItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.destroyAggregation("items");return this;};
f.prototype.addDimMeasureItem=function(D){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.addAggregation("dimMeasureItems",D);return this;};
f.prototype.insertDimMeasureItem=function(D,i){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.insertAggregation("dimMeasureItems",D,i);return this;};
f.prototype.updateDimMeasureItems=function(r){this.updateAggregation("dimMeasureItems");if(r===e.Change&&!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}};
f.prototype.removeDimMeasureItem=function(D){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAggregation("dimMeasureItems",D);};
f.prototype.removeAllDimMeasureItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAllAggregation("dimMeasureItems");};
f.prototype.destroyDimMeasureItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.destroyAggregation("dimMeasureItems");return this;};
f.prototype.setChartTypeKey=function(s){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.setProperty("chartTypeKey",s);return this;};
f.prototype.addAvailableChartType=function(a){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.addAggregation("availableChartTypes",a);return this;};
f.prototype.insertAvailableChartType=function(a,i){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.insertAggregation("availableChartTypes",a,i);return this;};
f.prototype.removeAvailableChartType=function(a){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAggregation("availableChartTypes",a);};
f.prototype.removeAllAvailableChartType=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAllAggregation("availableChartTypes");};
f.prototype.destroyAvailableChartType=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.destroyAggregation("availableChartTypes");return this;};
f.prototype.onBeforeNavigationFrom=function(){var s=this.getChartTypeKey();var D=[];var m=[];this.getDimMeasureItems().forEach(function(o){var M=this._getModelItemByColumnKey(o.getColumnKey());if(!M){return;}if(M.aggregationRole==="Dimension"){D.push(o);}else if(M.aggregationRole==="Measure"){m.push(o);}},this);D=D.filter(function(i){return i.getVisible();}).map(function(i){return{name:i.getColumnKey()};});m=m.filter(function(i){return i.getVisible();}).map(function(i){return{name:i.getColumnKey()};});sap.ui.getCore().loadLibrary("sap.chart");var r;try{r=sap.chart.api.getChartTypeLayout(s,D,m);}catch(E){return false;}return r.errors.length===0;};
f.prototype._notifyChange=function(){var L=this.getChangeNotifier();if(L){L(this);}};
f.prototype._scrollToSelectedItem=function(i){if(!i){return;}sap.ui.getCore().applyChanges();if(!!i.getDomRef()){i.focus();}};
f.prototype._getInternalModel=function(){return this.getModel("$sapmP13nDimMeasurePanel");};
f.prototype._createTable=function(){var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._oTable=new T({mode:sap.m.ListMode.MultiSelect,rememberSelections:false,itemPress:q.proxy(this._onItemPressed,this),selectionChange:q.proxy(this._onSelectionChange,this),columns:[new sap.m.Column({header:new sap.m.Text({text:{parts:[{path:'/countOfSelectedItems'},{path:'/countOfItems'}],formatter:function(i,a){return r.getText('COLUMNSPANEL_SELECT_ALL_WITH_COUNTER',[i,a]);}}})}),new sap.m.Column({header:new sap.m.Text({text:r.getText('COLUMNSPANEL_COLUMN_TYPE')})}),new sap.m.Column({header:new sap.m.Text({text:r.getText('COLUMNSPANEL_COLUMN_ROLE')})})],items:{path:"/items",templateShareable:false,template:new sap.m.ColumnListItem({cells:[new sap.m.Text({text:"{text}"}),new sap.m.Text({text:{path:'',formatter:function(m){if(m.aggregationRole==="Dimension"){return r.getText('COLUMNSPANEL_TYPE_DIMENSION');}if(m.aggregationRole==="Measure"){return r.getText('COLUMNSPANEL_TYPE_MEASURE');}}}}),new sap.m.Select({selectedKey:"{role}",items:{path:'availableRoleTypes',factory:function(i,b){var a=b.getObject();return new sap.ui.core.Item({key:a.key,text:a.text});}},change:q.proxy(this._onRoleChange,this)})],visible:"{visible}",selected:"{persistentSelected}",tooltip:"{tooltip}",type:sap.m.ListType.Active})}});this._oTable.setModel(this._getInternalModel());};
f.prototype._createToolbar=function(){var t=this;var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");var i=new sap.ui.core.InvisibleText({text:r.getText('COLUMNSPANEL_CHARTTYPE')});var o=new sap.m.ComboBox({placeholder:i.getText(),selectedKey:{path:'/selectedChartTypeKey'},ariaLabelledBy:i,items:{path:'/availableChartTypes',templateShareable:false,template:new sap.ui.core.Item({key:"{key}",text:"{text}"})},selectionChange:q.proxy(this._onChartTypeChange,this),layoutData:new sap.m.OverflowToolbarLayoutData({moveToOverflow:false,stayInOverflow:false})});var a=new sap.m.OverflowToolbar(this.getId()+"-toolbar",{design:sap.m.ToolbarDesign.Auto,content:[i,o,new sap.m.ToolbarSpacer(),new S(this.getId()+"-searchField",{liveChange:function(E){var v=E.getSource().getValue(),D=(v?300:0);window.clearTimeout(t._iSearchTimer);if(D){t._iSearchTimer=window.setTimeout(function(){t._onExecuteSearch();},D);}else{t._onExecuteSearch();}},search:q.proxy(this._onExecuteSearch,this),layoutData:new sap.m.OverflowToolbarLayoutData({minWidth:"12.5rem",maxWidth:"23.077rem",shrinkable:true,moveToOverflow:false,stayInOverflow:false})}),new sap.m.Button({text:{path:'/showOnlySelectedItems',formatter:function(s){return s?r.getText('COLUMNSPANEL_SHOW_ALL'):r.getText('COLUMNSPANEL_SHOW_SELECTED');}},tooltip:{path:'/showOnlySelectedItems',formatter:function(s){return s?r.getText('COLUMNSPANEL_SHOW_ALL'):r.getText('COLUMNSPANEL_SHOW_SELECTED');}},type:sap.m.ButtonType.Transparent,press:q.proxy(this._onSwitchButtonShowSelected,this),layoutData:new sap.m.OverflowToolbarLayoutData({moveToOverflow:true,priority:sap.m.OverflowToolbarPriority.High})}),new sap.m.OverflowToolbarButton({icon:sap.ui.core.IconPool.getIconURI("collapse-group"),text:r.getText('COLUMNSPANEL_MOVE_TO_TOP'),tooltip:r.getText('COLUMNSPANEL_MOVE_TO_TOP'),type:sap.m.ButtonType.Transparent,enabled:{path:'/isMoveUpButtonEnabled'},press:q.proxy(this.onPressButtonMoveToTop,this),layoutData:new sap.m.OverflowToolbarLayoutData({moveToOverflow:true,priority:sap.m.OverflowToolbarPriority.Low,group:2})}),new sap.m.OverflowToolbarButton({icon:sap.ui.core.IconPool.getIconURI("slim-arrow-up"),text:r.getText('COLUMNSPANEL_MOVE_UP'),tooltip:r.getText('COLUMNSPANEL_MOVE_UP'),type:sap.m.ButtonType.Transparent,enabled:{path:'/isMoveUpButtonEnabled'},press:q.proxy(this.onPressButtonMoveUp,this),layoutData:new sap.m.OverflowToolbarLayoutData({moveToOverflow:true,priority:sap.m.OverflowToolbarPriority.High,group:1})}),new sap.m.OverflowToolbarButton({icon:sap.ui.core.IconPool.getIconURI("slim-arrow-down"),text:r.getText('COLUMNSPANEL_MOVE_DOWN'),tooltip:r.getText('COLUMNSPANEL_MOVE_DOWN'),type:sap.m.ButtonType.Transparent,enabled:{path:'/isMoveDownButtonEnabled'},press:q.proxy(this.onPressButtonMoveDown,this),layoutData:new sap.m.OverflowToolbarLayoutData({moveToOverflow:true,priority:sap.m.OverflowToolbarPriority.High,group:1})}),new sap.m.OverflowToolbarButton({icon:sap.ui.core.IconPool.getIconURI("expand-group"),text:r.getText('COLUMNSPANEL_MOVE_TO_BOTTOM'),tooltip:r.getText('COLUMNSPANEL_MOVE_TO_BOTTOM'),type:sap.m.ButtonType.Transparent,enabled:{path:'/isMoveDownButtonEnabled'},press:q.proxy(this.onPressButtonMoveToBottom,this),layoutData:new sap.m.OverflowToolbarLayoutData({moveToOverflow:true,priority:sap.m.OverflowToolbarPriority.Low,group:2})})]});a.setModel(this._getInternalModel());this.addAggregation("content",a);};
f.prototype.onPressButtonMoveToTop=function(){this._moveMarkedTableItem(this._getMarkedTableItem(),this._getVisibleTableItems()[0]);};
f.prototype.onPressButtonMoveUp=function(){var v=this._getVisibleTableItems();this._moveMarkedTableItem(this._getMarkedTableItem(),v[v.indexOf(this._getMarkedTableItem())-1]);};
f.prototype.onPressButtonMoveDown=function(){var v=this._getVisibleTableItems();this._moveMarkedTableItem(this._getMarkedTableItem(),v[v.indexOf(this._getMarkedTableItem())+1]);};
f.prototype.onPressButtonMoveToBottom=function(){var v=this._getVisibleTableItems();this._moveMarkedTableItem(this._getMarkedTableItem(),v[v.length-1]);};
f.prototype._onSwitchButtonShowSelected=function(){this._getInternalModel().setProperty("/showOnlySelectedItems",!this._getInternalModel().getProperty("/showOnlySelectedItems"));this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();this._scrollToSelectedItem(this._getMarkedTableItem());this._updateControlLogic();this._fnHandleResize();};
f.prototype._onExecuteSearch=function(){this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();this._scrollToSelectedItem(this._getMarkedTableItem());this._updateControlLogic();};
f.prototype._switchVisibilityOfUnselectedModelItems=function(){var s=this._isFilteredByShowSelected();var m=this._getInternalModel().getProperty("/items");m.forEach(function(M){if(M.persistentSelected){M.visible=true;return;}M.visible=!s;});this._getInternalModel().setProperty("/items",m);};
f.prototype._getVisibleModelItems=function(){return this._getInternalModel().getProperty("/items").filter(function(m){return!!m.visible;});};
f.prototype._getVisibleModelItems=function(){return this._getInternalModel().getProperty("/items").filter(function(m){return!!m.visible;});};
f.prototype._moveMarkedTableItem=function(t,o){var m=this._getModelItemByColumnKey(this._getColumnKeyByTableItem(t));var M=this._getModelItemByColumnKey(this._getColumnKeyByTableItem(o));var i=this._getModelItemIndexByColumnKey(m.columnKey);var I=this._getModelItemIndexByColumnKey(M.columnKey);this._moveModelItems(i,I);this._scrollToSelectedItem(this._getMarkedTableItem());this._updateControlLogic();this._fireChangeDimMeasureItems();this._notifyChange();};
f.prototype._moveModelItems=function(i,I){var m=this._getInternalModel().getProperty("/items");if(i<0||I<0||i>m.length-1||I>m.length-1){return false;}this._removeStyleOfMarkedTableItem();var M=m.splice(i,1);m.splice(I,0,M[0]);this._updateModelItemsPersistentIndex(m);this._updateCounts(m);this._getInternalModel().setProperty("/items",m);this._switchMarkedTableItemTo(this._getMarkedTableItem());return true;};
f.prototype._getModelItemByColumnKey=function(s){var m=this._getInternalModel().getProperty("/items").filter(function(M){return M.columnKey===s;});return m[0];};
f.prototype._updateCounts=function(m){var i=0;var a=0;m.forEach(function(M){i++;if(M.persistentSelected){a++;}});this._getInternalModel().setProperty("/countOfItems",i);this._getInternalModel().setProperty("/countOfSelectedItems",a);};
f.prototype._sortModelItemsByPersistentIndex=function(m){m.sort(function(a,b){if(a.persistentSelected===true&&(b.persistentSelected===false||b.persistentSelected===undefined)){return-1;}else if((a.persistentSelected===false||a.persistentSelected===undefined)&&b.persistentSelected===true){return 1;}else if(a.persistentSelected===true&&b.persistentSelected===true){if(a.persistentIndex>-1&&a.persistentIndex<b.persistentIndex){return-1;}else if(b.persistentIndex>-1&&a.persistentIndex>b.persistentIndex){return 1;}else{return 0;}}else if((a.persistentSelected===false||a.persistentSelected===undefined)&&(b.persistentSelected===false||b.persistentSelected===undefined)){if(a.text<b.text){return-1;}else if(a.text>b.text){return 1;}else{return 0;}}});};
f.prototype._getColumnKeyByTableItem=function(t){var i=this._oTable.indexOfItem(t);if(i<0){return null;}return this._oTable.getBinding("items").getContexts()[i].getObject().columnKey;};
f.prototype._getModelItemIndexByColumnKey=function(s){var i=-1;this._getInternalModel().getData().items.some(function(m,I){if(m.columnKey===s){i=I;return true;}});return i;};
f.prototype._getSelectedModelItems=function(){return this._getInternalModel().getProperty("/items").filter(function(m){return m.persistentSelected;});};
f.prototype._getVisibleTableItems=function(){return this._oTable.getItems().filter(function(t){return t.getVisible();});};
f.prototype._getTableItemByColumnKey=function(s){var a=this._oTable.getBinding("items").getContexts();var t=this._oTable.getItems().filter(function(o,i){return a[i].getObject().columnKey===s;});return t[0];};
f.prototype._getToolbar=function(){return sap.ui.getCore().byId(this.getId()+"-toolbar")||null;};
f.prototype._getSearchField=function(){return sap.ui.getCore().byId(this.getId()+"-searchField")||null;};
f.prototype._getSearchText=function(){var s=this._getSearchField();return s?s.getValue():"";};
f.prototype._isFilteredBySearchText=function(){return!!this._getSearchText().length;};
f.prototype._isFilteredByShowSelected=function(){return this._getInternalModel().getData().showOnlySelectedItems;};
f.prototype._updateControlLogic=function(){var i=this._isFilteredBySearchText();var s=this._isFilteredByShowSelected();var v=this._getVisibleTableItems();this._getInternalModel().setProperty("/isMoveUpButtonEnabled",v.indexOf(this._getMarkedTableItem())>0);this._getInternalModel().setProperty("/isMoveDownButtonEnabled",v.indexOf(this._getMarkedTableItem())>-1&&v.indexOf(this._getMarkedTableItem())<v.length-1);var t=sap.ui.getCore().byId(this._oTable.getId()+'-sa');if(t){t.setEnabled(!i&&!s);}};
f.prototype._updateModelItemsPersistentIndex=function(m){var p=-1;m.forEach(function(M){M.persistentIndex=-1;if(M.persistentSelected){p++;M.persistentIndex=p;}});};
f.prototype._fireChangeDimMeasureItems=function(){this._bIgnoreUpdateInternalModel=true;this.fireChangeDimMeasureItems({items:this._getInternalModel().getProperty("/items").map(function(m){return{columnKey:m.columnKey,visible:m.persistentSelected,index:m.persistentIndex===-1?undefined:m.persistentIndex,role:m.role};})});this._bIgnoreUpdateInternalModel=false;};
f.prototype._fireChangeChartType=function(){this._bIgnoreUpdateInternalModel=true;this.fireChangeChartType({chartTypeKey:this._getInternalModel().getProperty("/selectedChartTypeKey")});this._bIgnoreUpdateInternalModel=false;};
f.prototype._getDimMeasureItemByColumnKey=function(s){var D=this.getDimMeasureItems().filter(function(o){return o.getColumnKey()===s;});return D[0];};
f.prototype._getMarkedTableItem=function(){return this._getTableItemByColumnKey(this._getInternalModel().getProperty("/columnKeyOfMarkedItem"));};
f.prototype._setColumnKeyOfMarkedItem=function(s){this._getInternalModel().setProperty("/columnKeyOfMarkedItem",s);};
f.prototype._onItemPressed=function(E){this._switchMarkedTableItemTo(E.getParameter('listItem'));this._updateControlLogic();};
f.prototype._onChartTypeChange=function(E){this._fireChangeChartType();this._notifyChange();};
f.prototype._onRoleChange=function(E){this._fireChangeDimMeasureItems();this._notifyChange();};
f.prototype._onSelectionChange=function(E){if(!E.getParameter("selectAll")&&E.getParameter("listItems").length===1){this._switchMarkedTableItemTo(E.getParameter("listItem"));}this._selectTableItem();};
f.prototype._selectTableItem=function(){this._updateControlLogic();var m=this._getInternalModel().getProperty("/items");this._updateModelItemsPersistentIndex(m);this._updateCounts(m);this._getInternalModel().setProperty("/items",m);this._fireChangeDimMeasureItems();this._notifyChange();};
f.prototype._switchMarkedTableItemTo=function(t){this._removeStyleOfMarkedTableItem();var s=this._getColumnKeyByTableItem(t);if(s){this._setColumnKeyOfMarkedItem(s);t.addStyleClass("sapMP13nColumnsPanelItemSelected");}};
f.prototype._removeStyleOfMarkedTableItem=function(){if(this._getMarkedTableItem()){this._getMarkedTableItem().removeStyleClass("sapMP13nColumnsPanelItemSelected");}};
f.prototype._filterModelItemsBySearchText=function(){var s=this._getSearchText();s=s.replace(/(^\s+)|(\s+$)/g,'');s=s.replace(/[-\/\\^$*+?.()|[\]{}]/g,'\\$&');var r=new RegExp(s,'igm');if(!r){return;}this._getVisibleModelItems().forEach(function(m){m.visible=false;if(m.text&&m.text.match(r)){m.visible=true;}if(m.aggregationRole&&m.aggregationRole.match(r)){m.visible=true;}if(m.role&&m.role.match(r)){m.visible=true;}if(m.tooltip&&m.tooltip.match(r)){m.visible=true;}});this._getInternalModel().refresh();};
f.prototype._updateInternalModel=function(){if(!this._bUpdateInternalModel){return;}this._bUpdateInternalModel=false;this._removeStyleOfMarkedTableItem();this._getInternalModel().setProperty("/items",this.getItems().map(function(i){return{columnKey:i.getColumnKey(),visible:true,text:i.getText(),tooltip:i.getTooltip(),aggregationRole:i.getAggregationRole(),availableRoleTypes:this.oAvailableRoleTypes[i.getAggregationRole()],role:i.getRole(),persistentIndex:-1,persistentSelected:undefined};},this));this._getInternalModel().setProperty("/selectedChartTypeKey",this.getChartTypeKey());this._getInternalModel().setProperty("/availableChartTypes",this.getAvailableChartTypes().map(function(a){return{key:a.getKey(),text:a.getText()};},this));this.getDimMeasureItems().forEach(function(D){var M=this._getModelItemByColumnKey(D.getColumnKey());if(!M){return;}if(D.getIndex()!==undefined){M.persistentIndex=D.getIndex();}if(D.getVisible()!==undefined){M.persistentSelected=D.getVisible();}if(D.getRole()!==undefined){M.role=D.getRole();}},this);this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();var m=this._getInternalModel().getProperty("/items");this._sortModelItemsByPersistentIndex(m);this._updateCounts(m);this._getInternalModel().setProperty("/items",m);this._switchMarkedTableItemTo(this._getMarkedTableItem());};
return f;},true);
sap.ui.predefine('sap/m/P13nFilterItem',['jquery.sap.global','./library','sap/ui/core/Item'],function(q,l,I){"use strict";
var P=I.extend("sap.m.P13nFilterItem",{metadata:{library:"sap.m",properties:{operation:{type:"string",group:"Misc",defaultValue:null},value1:{type:"string",group:"Misc",defaultValue:null},value2:{type:"string",group:"Misc",defaultValue:null},columnKey:{type:"string",group:"Misc",defaultValue:null},exclude:{type:"boolean",group:"Misc",defaultValue:false}}}});
P.prototype.setOperation=function(o){return this.setProperty("operation",o,true);};
P.prototype.setColumnKey=function(k){return this.setProperty("columnKey",k,true);};
P.prototype.setValue1=function(k){return this.setProperty("value1",k,true);};
P.prototype.setValue2=function(k){return this.setProperty("value2",k,true);};
P.prototype.setExclude=function(k){return this.setProperty("exclude",k,true);};
return P;},true);
sap.ui.predefine('sap/m/P13nFilterPanel',['jquery.sap.global','./P13nConditionPanel','./P13nPanel','./library','sap/ui/core/Control'],function(q,P,a,l,C){"use strict";
var b=a.extend("sap.m.P13nFilterPanel",{
metadata:{library:"sap.m",properties:{maxIncludes:{type:"string",group:"Misc",defaultValue:'-1'},maxExcludes:{type:"string",group:"Misc",defaultValue:'-1'},containerQuery:{type:"boolean",group:"Misc",defaultValue:false},layoutMode:{type:"string",group:"Misc",defaultValue:null}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"},filterItems:{type:"sap.m.P13nFilterItem",multiple:true,singularName:"filterItem",bindable:"bindable"}},events:{addFilterItem:{},removeFilterItem:{},updateFilterItem:{}}},
renderer:function(r,c){r.write("<section");r.writeControlData(c);r.addClass("sapMFilterPanel");r.writeClasses();r.writeStyles();r.write(">");r.write("<div");r.addClass("sapMFilterPanelContent");r.addClass("sapMFilterPanelBG");r.writeClasses();r.write(">");var d=c.getAggregation("content");var L=d.length;for(var i=0;i<L;i++){r.renderControl(d[i]);}r.write("</div>");r.write("</section>");}
});
b.prototype.setConditions=function(c){var I=[];var e=[];if(c.length){for(var i=0;i<c.length;i++){var o=c[i];if(!o.exclude){I.push(o);}else{e.push(o);}}}this._oIncludeFilterPanel.setConditions(I);this._oExcludeFilterPanel.setConditions(e);if(e.length>0){this._oExcludePanel.setExpanded(true);}return this;};
b.prototype.getConditions=function(){var i=this._oIncludeFilterPanel.getConditions();var e=this._oExcludeFilterPanel.getConditions();return i.concat(e);};
b.prototype.setContainerQuery=function(c){this.setProperty("containerQuery",c);this._oIncludeFilterPanel.setContainerQuery(c);this._oExcludeFilterPanel.setContainerQuery(c);return this;};
b.prototype.setLayoutMode=function(m){this.setProperty("layoutMode",m);this._oIncludeFilterPanel.setLayoutMode(m);this._oExcludeFilterPanel.setLayoutMode(m);return this;};
b.prototype.validateConditions=function(){return this._oIncludeFilterPanel.validateConditions()&&this._oExcludeFilterPanel.validateConditions();};
b.prototype.removeInvalidConditions=function(){this._oIncludeFilterPanel.removeInvalidConditions();this._oExcludeFilterPanel.removeInvalidConditions();};
b.prototype.removeValidationErrors=function(){this._oIncludeFilterPanel.removeValidationErrors();this._oExcludeFilterPanel.removeValidationErrors();};
b.prototype.onBeforeNavigationFrom=function(){return this.validateConditions();};
b.prototype.onAfterNavigationFrom=function(){return this.removeInvalidConditions();};
b.prototype.setIncludeOperations=function(o,t){t=t||"default";this._aIncludeOperations[t]=o;if(this._oIncludeFilterPanel){this._oIncludeFilterPanel.setOperations(this._aIncludeOperations[t],t);}};
b.prototype.getIncludeOperations=function(t){if(this._oIncludeFilterPanel){return this._oIncludeFilterPanel.getOperations(t);}};
b.prototype.setExcludeOperations=function(o,t){t=t||"default";this._aExcludeOperations[t]=o;if(this._oExcludeFilterPanel){this._oExcludeFilterPanel.setOperations(this._aExcludeOperations[t],t);}};
b.prototype.getExcludeOperations=function(t){if(this._oExcludeFilterPanel){return this._oExcludeFilterPanel.getOperations(t);}};
b.prototype.setKeyFields=function(k){this._aKeyFields=k;if(this._oIncludeFilterPanel){this._oIncludeFilterPanel.setKeyFields(this._aKeyFields);}if(this._oExcludeFilterPanel){this._oExcludeFilterPanel.setKeyFields(this._aKeyFields);}};
b.prototype.getKeyFields=function(){return this._aKeyFields;};
b.prototype.setMaxIncludes=function(m){this.setProperty("maxIncludes",m);if(this._oIncludeFilterPanel){this._oIncludeFilterPanel.setMaxConditions(m);}this._updatePanel();return this;};
b.prototype.setMaxExcludes=function(m){this.setProperty("maxExcludes",m);if(this._oExcludeFilterPanel){this._oExcludeFilterPanel.setMaxConditions(m);}this._updatePanel();return this;};
b.prototype._updatePanel=function(){var m=this.getMaxIncludes()==="-1"?1000:parseInt(this.getMaxIncludes(),10);var M=this.getMaxExcludes()==="-1"?1000:parseInt(this.getMaxExcludes(),10);if(m>0){if(M<=0){this._oIncludePanel.setHeaderText(null);this._oIncludePanel.setExpandable(false);this._oIncludePanel.addStyleClass("panelTopMargin");this._oIncludePanel.addStyleClass("panelNoHeader");}}if(M===0){this._oExcludePanel.setHeaderText(null);this._oExcludePanel.setExpandable(false);this._oExcludePanel.addStyleClass("panelNoHeader");}};
b.prototype.init=function(){this.setType(sap.m.P13nPanelType.filter);this.setTitle(sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("FILTERPANEL_TITLE"));sap.ui.getCore().loadLibrary("sap.ui.layout");q.sap.require("sap.ui.layout.Grid");sap.ui.layout.Grid.prototype.init.apply(this);this._aKeyFields=[];this.addStyleClass("sapMFilterPanel");this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._aIncludeOperations={};if(!this._aIncludeOperations["default"]){this.setIncludeOperations([sap.m.P13nConditionOperation.EQ,sap.m.P13nConditionOperation.BT,sap.m.P13nConditionOperation.LT,sap.m.P13nConditionOperation.LE,sap.m.P13nConditionOperation.GT,sap.m.P13nConditionOperation.GE]);}if(!this._aIncludeOperations["string"]){this.setIncludeOperations([sap.m.P13nConditionOperation.Contains,sap.m.P13nConditionOperation.EQ,sap.m.P13nConditionOperation.BT,sap.m.P13nConditionOperation.StartsWith,sap.m.P13nConditionOperation.EndsWith,sap.m.P13nConditionOperation.LT,sap.m.P13nConditionOperation.LE,sap.m.P13nConditionOperation.GT,sap.m.P13nConditionOperation.GE],"string");}if(!this._aIncludeOperations["date"]){this.setIncludeOperations([sap.m.P13nConditionOperation.EQ,sap.m.P13nConditionOperation.BT,sap.m.P13nConditionOperation.LT,sap.m.P13nConditionOperation.LE,sap.m.P13nConditionOperation.GT,sap.m.P13nConditionOperation.GE],"date");}if(!this._aIncludeOperations["time"]){this.setIncludeOperations([sap.m.P13nConditionOperation.EQ,sap.m.P13nConditionOperation.BT,sap.m.P13nConditionOperation.LT,sap.m.P13nConditionOperation.LE,sap.m.P13nConditionOperation.GT,sap.m.P13nConditionOperation.GE],"time");}if(!this._aIncludeOperations["numeric"]){this.setIncludeOperations([sap.m.P13nConditionOperation.EQ,sap.m.P13nConditionOperation.BT,sap.m.P13nConditionOperation.LT,sap.m.P13nConditionOperation.LE,sap.m.P13nConditionOperation.GT,sap.m.P13nConditionOperation.GE],"numeric");}if(!this._aIncludeOperations["boolean"]){this.setIncludeOperations([sap.m.P13nConditionOperation.EQ],"boolean");}this._aExcludeOperations={};if(!this._aExcludeOperations["default"]){this.setExcludeOperations([sap.m.P13nConditionOperation.EQ]);}this._oIncludePanel=new sap.m.Panel({expanded:true,expandable:true,headerText:this._oRb.getText("FILTERPANEL_INCLUDES"),width:"auto"}).addStyleClass("sapMFilterPadding");this._oIncludeFilterPanel=new P({maxConditions:this.getMaxIncludes(),alwaysShowAddIcon:false,layoutMode:this.getLayoutMode(),dataChange:this._handleDataChange()});this._oIncludeFilterPanel._sAddRemoveIconTooltipKey="FILTER";for(var t in this._aIncludeOperations){this._oIncludeFilterPanel.setOperations(this._aIncludeOperations[t],t);}this._oIncludePanel.addContent(this._oIncludeFilterPanel);this.addAggregation("content",this._oIncludePanel);this._oExcludePanel=new sap.m.Panel({expanded:false,expandable:true,headerText:this._oRb.getText("FILTERPANEL_EXCLUDES"),width:"auto"}).addStyleClass("sapMFilterPadding");this._oExcludeFilterPanel=new P({exclude:true,maxConditions:this.getMaxExcludes(),alwaysShowAddIcon:false,layoutMode:this.getLayoutMode(),dataChange:this._handleDataChange()});this._oExcludeFilterPanel._sAddRemoveIconTooltipKey="FILTER";for(var t in this._aExcludeOperations){this._oExcludeFilterPanel.setOperations(this._aExcludeOperations[t],t);}this._oExcludePanel.addContent(this._oExcludeFilterPanel);this.addAggregation("content",this._oExcludePanel);this._updatePanel();};
b.prototype.exit=function(){var d=function(o){if(o&&o.destroy){o.destroy();}return null;};this._aKeyFields=d(this._aKeyFields);this._aIncludeOperations=d(this._aIncludeOperations);this._aExcludeOperations=d(this._aExcludeOperations);this._oRb=d(this._oRb);};
b.prototype.onBeforeRendering=function(){if(this._bUpdateRequired){this._bUpdateRequired=false;var k=[];var m=(this.getBindingInfo("items")||{}).model;var g=function(n,o,i){var B=i.getBinding(n);if(B&&o){return o.getObject()[B.getPath()];}return i.getMetadata().getProperty(n)?i.getProperty(n):i.getAggregation(n);};this.getItems().forEach(function(i){var o=i.getBindingContext(m);if(i.getBinding("key")){o.getObject()[i.getBinding("key").getPath()]=i.getKey();}k.push({key:i.getColumnKey(),text:g("text",o,i),tooltip:g("tooltip",o,i),maxLength:g("maxLength",o,i),type:g("type",o,i),precision:g("precision",o,i),scale:g("scale",o,i),isDefault:g("isDefault",o,i),values:g("values",o,i)});var n=k.length;if(k[n-1].maxLength===1||k[n-1].maxLength==="1"){k[n-1].operations=[sap.m.P13nConditionOperation.EQ,sap.m.P13nConditionOperation.BT,sap.m.P13nConditionOperation.LT,sap.m.P13nConditionOperation.LE,sap.m.P13nConditionOperation.GT,sap.m.P13nConditionOperation.GE];}});this.setKeyFields(k);var c=[];m=(this.getBindingInfo("filterItems")||{}).model;this.getFilterItems().forEach(function(f){var o=f.getBindingContext(m);if(f.getBinding("key")&&o){o.getObject()[f.getBinding("key").getPath()]=f.getKey();}c.push({key:f.getKey(),keyField:g("columnKey",o,f),operation:g("operation",o,f),value1:g("value1",o,f),value2:g("value2",o,f),exclude:g("exclude",o,f)});});this.setConditions(c);}};
b.prototype.addItem=function(i){a.prototype.addItem.apply(this,arguments);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
b.prototype.removeItem=function(i){var r=a.prototype.removeItem.apply(this,arguments);this._bUpdateRequired=true;return r;};
b.prototype.destroyItems=function(){this.destroyAggregation("items");if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
b.prototype.addFilterItem=function(f){this.addAggregation("filterItems",f,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
b.prototype.insertFilterItem=function(f,i){this.insertAggregation("filterItems",f,i,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
b.prototype.updateFilterItems=function(r){this.updateAggregation("filterItems");if(r=="change"&&!this._bIgnoreBindCalls){this._bUpdateRequired=true;}};
b.prototype.removeFilterItem=function(f){f=this.removeAggregation("filterItems",f,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return f;};
b.prototype.removeAllFilterItems=function(){var f=this.removeAllAggregation("filterItems",true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return f;};
b.prototype.destroyFilterItems=function(){this.destroyAggregation("filterItems");if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
b.prototype._handleDataChange=function(){var t=this;return function(e){var n=e.getParameter("newData");var o=e.getParameter("operation");var k=e.getParameter("key");var c=e.getParameter("index");var f;var I=-1;var E=e.getSource()===t._oExcludeFilterPanel;t.getFilterItems().some(function(d,i){if((!d.getExclude()&&!E)||(d.getExclude()&&E)){c--;}I=i;return c<0;},this);if(o==="update"){f=t.getFilterItems()[I];if(f){f.setExclude(n.exclude);f.setColumnKey(n.keyField);f.setOperation(n.operation);f.setValue1(n.value1);f.setValue2(n.value2);}t.fireUpdateFilterItem({key:k,index:I,filterItemData:f});t._notifyChange();}if(o==="add"){if(c>=0){I++;}f=new sap.m.P13nFilterItem({key:k,columnKey:n.keyField,exclude:n.exclude,operation:n.operation,value1:n.value1,value2:n.value2});t._bIgnoreBindCalls=true;t.fireAddFilterItem({key:k,index:I,filterItemData:f});t._bIgnoreBindCalls=false;t._notifyChange();}if(o==="remove"){t._bIgnoreBindCalls=true;t.fireRemoveFilterItem({key:k,index:I});t._bIgnoreBindCalls=false;t._notifyChange();}};};
b.prototype._notifyChange=function(){var L=this.getChangeNotifier();if(L){L(this);}};
return b;},true);
sap.ui.predefine('sap/m/P13nGroupItem',['jquery.sap.global','./library','sap/ui/core/Item'],function(q,l,I){"use strict";
var P=I.extend("sap.m.P13nGroupItem",{metadata:{library:"sap.m",properties:{operation:{type:"string",group:"Misc",defaultValue:null},columnKey:{type:"string",group:"Misc",defaultValue:null},showIfGrouped:{type:"boolean",group:"Misc",defaultValue:false}}}});
P.prototype.setColumnKey=function(v){return this.setProperty("columnKey",v,true);};
P.prototype.setOperation=function(v){return this.setProperty("operation",v,true);};
P.prototype.setShowIfGrouped=function(v){return this.setProperty("showIfGrouped",v,true);};
return P;},true);
sap.ui.predefine('sap/m/P13nGroupPanel',['jquery.sap.global','./P13nConditionPanel','./P13nPanel','./library','sap/ui/core/Control'],function(q,P,a,l,C){"use strict";
var c=a.extend("sap.m.P13nGroupPanel",{
metadata:{library:"sap.m",properties:{maxGroups:{type:"string",group:"Misc",defaultValue:'-1'},containerQuery:{type:"boolean",group:"Misc",defaultValue:false},layoutMode:{type:"string",group:"Misc",defaultValue:null}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"},groupItems:{type:"sap.m.P13nGroupItem",multiple:true,singularName:"groupItem",bindable:"bindable"}},events:{addGroupItem:{parameters:{}},removeGroupItem:{},updateGroupItem:{}}},
renderer:function(r,o){r.write("<section");r.writeControlData(o);r.addClass("sapMGroupPanel");r.writeClasses();r.writeStyles();r.write(">");r.write("<div");r.addClass("sapMGroupPanelContent");r.addClass("sapMGroupPanelBG");r.writeClasses();r.write(">");var b=o.getAggregation("content");var L=b.length;for(var i=0;i<L;i++){r.renderControl(b[i]);}r.write("</div>");r.write("</section>");}
});
c.prototype.setMaxGroups=function(m){this.setProperty("maxGroups",m);if(this._oGroupPanel){this._oGroupPanel.setMaxConditions(m);}};
c.prototype._getConditions=function(){return this._oGroupPanel.getConditions();};
c.prototype.setContainerQuery=function(b){this.setProperty("containerQuery",b);this._oGroupPanel.setContainerQuery(b);};
c.prototype.setLayoutMode=function(m){this.setProperty("layoutMode",m);this._oGroupPanel.setLayoutMode(m);};
c.prototype.validateConditions=function(){return this._oGroupPanel.validateConditions();};
c.prototype.removeInvalidConditions=function(){this._oGroupPanel.removeInvalidConditions();};
c.prototype.removeValidationErrors=function(){this._oGroupPanel.removeValidationErrors();};
c.prototype.onBeforeNavigationFrom=function(){return this.validateConditions();};
c.prototype.onAfterNavigationFrom=function(){return this.removeInvalidConditions();};
c.prototype.setOperations=function(o){this._aOperations=o;if(this._oGroupPanel){this._oGroupPanel.setOperations(this._aOperations);}};
c.prototype.init=function(){this.setType(sap.m.P13nPanelType.group);this.setTitle(sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("GROUPPANEL_TITLE"));sap.ui.getCore().loadLibrary("sap.ui.layout");q.sap.require("sap.ui.layout.Grid");sap.ui.layout.Grid.prototype.init.apply(this);this._aKeyFields=[];this.addStyleClass("sapMGroupPanel");if(!this._aOperations){this.setOperations([sap.m.P13nConditionOperation.GroupAscending,sap.m.P13nConditionOperation.GroupDescending]);}this._oGroupPanel=new P({maxConditions:this.getMaxGroups(),autoReduceKeyFieldItems:true,layoutMode:this.getLayoutMode(),dataChange:this._handleDataChange(),validationExecutor:q.proxy(this._callValidationExecutor,this)});this._oGroupPanel.setOperations(this._aOperations);this._oGroupPanel._sAddRemoveIconTooltipKey="GROUP";this.addAggregation("content",this._oGroupPanel);};
c.prototype.exit=function(){var d=function(o){if(o&&o.destroy){o.destroy();}return null;};this._aKeyFields=d(this._aKeyFields);this._aOperations=d(this._aOperations);};
c.prototype.onBeforeRendering=function(){if(this._bUpdateRequired){this._bUpdateRequired=false;var k=[];var m=(this.getBindingInfo("items")||{}).model;var g=function(n,o,i){var B=i.getBinding(n);if(B&&o){return o.getObject()[B.getPath()];}return i.getMetadata().getProperty(n)?i.getProperty(n):i.getAggregation(n);};this.getItems().forEach(function(i){var o=i.getBindingContext(m);if(i.getBinding("key")){o.getObject()[i.getBinding("key").getPath()]=i.getKey();}k.push({key:i.getColumnKey(),text:g("text",o,i),tooltip:g("tooltip",o,i)});});k.splice(0,0,{key:null,text:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_SELECTION_NONE")});this._oGroupPanel.setKeyFields(k);var b=[];m=(this.getBindingInfo("groupItems")||{}).model;this.getGroupItems().forEach(function(G){var o=G.getBindingContext(m);if(G.getBinding("key")){o.getObject()[G.getBinding("key").getPath()]=G.getKey();}b.push({key:G.getKey(),keyField:g("columnKey",o,G),operation:g("operation",o,G),showIfGrouped:g("showIfGrouped",o,G)});});this._oGroupPanel.setConditions(b);}};
c.prototype.addItem=function(i){a.prototype.addItem.apply(this,arguments);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
c.prototype.removeItem=function(i){var r=a.prototype.removeItem.apply(this,arguments);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return r;};
c.prototype.destroyItems=function(){this.destroyAggregation("items");if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
c.prototype.addGroupItem=function(g){this.addAggregation("groupItems",g,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
c.prototype.insertGroupItem=function(g,i){this.insertAggregation("groupItems",g,i,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
c.prototype.updateGroupItems=function(r){this.updateAggregation("groupItems");if(r=="change"&&!this._bIgnoreBindCalls){this._bUpdateRequired=true;}};
c.prototype.removeGroupItem=function(g){g=this.removeAggregation("groupItems",g,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return g;};
c.prototype.removeAllGroupItems=function(){var g=this.removeAllAggregation("groupItems",true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return g;};
c.prototype.destroyGroupItems=function(){this.destroyAggregation("groupItems");if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
c.prototype._handleDataChange=function(){var t=this;return function(e){var n=e.getParameter("newData");var o=e.getParameter("operation");var k=e.getParameter("key");var i=e.getParameter("index");var g;if(o==="update"){g=t.getGroupItems()[i];if(g){g.setColumnKey(n.keyField);g.setOperation(n.operation);g.setShowIfGrouped(n.showIfGrouped);}t.fireUpdateGroupItem({key:k,index:i,groupItemData:g});t._notifyChange();}if(o==="add"){g=new sap.m.P13nGroupItem({key:k,columnKey:n.keyField,operation:n.operation,showIfGrouped:n.showIfGrouped});t._bIgnoreBindCalls=true;t.fireAddGroupItem({key:k,index:i,groupItemData:g});t._bIgnoreBindCalls=false;t._notifyChange();}if(o==="remove"){t._bIgnoreBindCalls=true;t.fireRemoveGroupItem({key:k,index:i});t._bIgnoreBindCalls=false;t._notifyChange();}};};
c.prototype.getOkPayload=function(){if(!this.getModel()){return null;}var s=[];this._oGroupPanel._oConditionsGrid.getContent().forEach(function(o){var b=o.keyField;s.push(b.getSelectedKey());});return{selectedColumnKeys:s};};
c.prototype._callValidationExecutor=function(){var v=this.getValidationExecutor();if(v){v();}};
c.prototype._updateValidationResult=function(v){this._oGroupPanel._oConditionsGrid.getContent().forEach(function(o){var b=o.keyField;b.setValueStateText("");b.setValueState("None");var s=b.getSelectedKey();v.forEach(function(r){if(r.columnKey===s){b.setValueStateText(r.messageText);b.setValueState(r.messageType);}});});};
c.prototype.setValidationListener=function(L){this.setProperty("validationListener",L);if(L){L(this,q.proxy(this._updateValidationResult,this));}};
c.prototype._notifyChange=function(){var L=this.getChangeNotifier();if(L){L(this);}};
return c;},true);
sap.ui.predefine('sap/m/P13nItem',['jquery.sap.global','./library','sap/ui/core/Element'],function(q,l,E){"use strict";
var P=E.extend("sap.m.P13nItem",{metadata:{library:"sap.m",properties:{columnKey:{type:"string",group:"Data",defaultValue:null},text:{type:"string",group:"Misc",defaultValue:""},visible:{type:"boolean",group:"Misc",defaultValue:null},type:{type:"string",group:"Misc",defaultValue:"text"},precision:{type:"string",group:"Misc",defaultValue:null},scale:{type:"string",group:"Misc",defaultValue:null},maxLength:{type:"string",group:"Misc",defaultValue:null},width:{type:"string",group:"Misc",defaultValue:null},isDefault:{type:"boolean",group:"Misc",defaultValue:false},values:{type:"string[]",group:"Misc",defaultValue:null},role:{type:"string",defaultValue:null},aggregationRole:{type:"string",defaultValue:null},href:{type:"string",defaultValue:null},target:{type:"string",defaultValue:null},press:{type:"object",defaultValue:null}}}});
return P;},true);
sap.ui.predefine('sap/m/P13nPanel',['jquery.sap.global','./library','sap/ui/core/Control'],function(q,l,C){"use strict";
var P=C.extend("sap.m.P13nPanel",{
metadata:{library:"sap.m",properties:{title:{type:"string",group:"Appearance",defaultValue:null},titleLarge:{type:"string",group:"Appearance",defaultValue:null},type:{type:"string",group:"Misc",defaultValue:null},verticalScrolling:{type:"boolean",group:"Misc",defaultValue:true},validationExecutor:{type:"object",group:"Misc",defaultValue:null},validationListener:{type:"object",group:"Misc",defaultValue:null},changeNotifier:{type:"object",group:"Misc",defaultValue:null}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.P13nItem",multiple:true,singularName:"item",bindable:"bindable"}},events:{beforeNavigationTo:{}}},
renderer:function(r,c){r.write("<span");r.writeControlData(c);r.addClass("sapMP13nPanel");r.writeClasses();r.write(">");r.write("</span>");}
});
P.prototype.getOkPayload=function(){return{};};
P.prototype.getResetPayload=function(){return{};};
P.prototype.beforeNavigationTo=function(){this.fireBeforeNavigationTo();};
P.prototype.onBeforeNavigationFrom=function(){return true;};
P.prototype.onAfterNavigationFrom=function(){};
return P;},true);
sap.ui.predefine('sap/m/P13nSelectionItem',['jquery.sap.global','./library','sap/ui/core/Item'],function(q,l,I){"use strict";
var P=I.extend("sap.m.P13nSelectionItem",{metadata:{library:"sap.m",properties:{columnKey:{type:"string",defaultValue:undefined},index:{type:"int",defaultValue:-1},selected:{type:"boolean",defaultValue:false}}}});
return P;},true);
sap.ui.predefine('sap/m/P13nSelectionPanel',['jquery.sap.global','./ColumnListItem','./P13nPanel','./P13nSelectionItem','./SearchField','./Table','./library','sap/ui/core/Control','sap/ui/model/json/JSONModel'],function(q,C,P,c,S,T,l,d,J){"use strict";
var e=P.extend("sap.m.P13nSelectionPanel",{
metadata:{library:"sap.m",aggregations:{selectionItems:{type:"sap.m.P13nSelectionItem",multiple:true,singularName:"selectionItem",bindable:"bindable"},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"}}},
renderer:function(r,o){r.write("<div");r.writeControlData(o);r.addClass("sapMP13nColumnsPanel");r.writeClasses();r.write(">");var a=o.getAggregation("content");if(a){a.forEach(function(b){r.renderControl(b);});}r.write("</div>");}
});
e.prototype.getOkPayload=function(){this._syncModel2Panel();return{selectionItems:this.getSelectionItems()};};
e.prototype.init=function(){this._iLiveChangeTimer=0;this._iSearchTimer=0;this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._bOnAfterRenderingFirstTimeExecuted=false;this._bOnBeforeRenderingFirstTimeExecuted=false;var m=new J({linkPressMap:{},items:[],indexOfMarkedTableItem:-1,markedTableItem:null,isMoveDownButtonEnabled:false,isMoveUpButtonEnabled:false,showOnlySelectedItems:false,countOfSelectedItems:0,countOfItems:0,config:this.getConfig()});m.setDefaultBindingMode(sap.ui.model.BindingMode.TwoWay);m.setSizeLimit(1000);this.setModel(m,"$sapmP13nSelectionPanel");this.setType(sap.m.P13nPanelType.selection);};
e.prototype.getConfig=function(){return{isEnabledSelectedItemsSorting:false,isEnabledSelectedButton:false,isEnabledMoveButtons:false};};
e.prototype.applySettings=function(s){P.prototype.applySettings.apply(this,arguments);var t=this;this._createTable();this._createToolbar();this.setVerticalScrolling(false);var o=new sap.m.ScrollContainer({horizontal:false,vertical:true,content:[this._oTable],width:'100%',height:'100%'});this._fnHandleResize=function(){var b=false,i,a;if(t.getParent){var $=null,f,h;var p=t.getParent();var g=t._getToolbar();if(p){$=q("#"+p.getId()+"-cont");if($.children().length>0&&g.$().length>0){i=o.$()[0].clientHeight;f=$.children()[0].clientHeight;h=g?g.$()[0].clientHeight:0;a=f-h;if(i!==a){o.setHeight(a+'px');b=true;}}}}return b;};this.addAggregation("content",o);this._sContainerResizeListener=sap.ui.core.ResizeHandler.register(o,this._fnHandleResize);};
e.prototype.onBeforeRendering=function(){if(!this._bOnBeforeRenderingFirstTimeExecuted){this._bOnBeforeRenderingFirstTimeExecuted=true;this._syncPanel2Model();}if(!this._getInternalModel().getData().markedTableItem){var v=this._getVisibleTableItems();this._switchMarkedTableItemTo(v[0]);}};
e.prototype.onAfterRendering=function(){var t=this;if(!this._bOnAfterRenderingFirstTimeExecuted){this._bOnAfterRenderingFirstTimeExecuted=true;window.clearTimeout(this._iLiveChangeTimer);this._iLiveChangeTimer=window.setTimeout(function(){t._fnHandleResize();},0);}};
e.prototype.addItem=function(i){var m=this._getInternalModel();var D=m.getData();this._bOnBeforeRenderingFirstTimeExecuted=false;this.addAggregation("items",i);this._includeModelItem(i,-1);this._sortModelItemsByPersistentIndex(D.items);this._updateModelItemsTableIndex(D);this._updateCounts(D);return this;};
e.prototype.insertItem=function(i,I){var m=this._getInternalModel();var D=m.getData();this._bOnBeforeRenderingFirstTimeExecuted=false;this.insertAggregation("items",i,I);this._includeModelItem(i,I);this._sortModelItemsByPersistentIndex(D.items);this._updateModelItemsTableIndex(D);this._updateCounts(D);return this;};
e.prototype.removeItem=function(i){var I=this.indexOfItem(i);if(I>-1){var m=this._getInternalModel();var D=m.getData();this._bOnBeforeRenderingFirstTimeExecuted=false;m.getData().items.splice(I,1);this._sortModelItemsByPersistentIndex(D.items);this._updateModelItemsTableIndex(D);this._updateCounts(D);}i=this.removeAggregation("items",i);return i;};
e.prototype.removeAllItems=function(){var m=this._getInternalModel();this._bOnBeforeRenderingFirstTimeExecuted=false;var i=this.removeAllAggregation("items");m.getData().items=[];return i;};
e.prototype.destroyItems=function(){var m=this._getInternalModel();this._bOnBeforeRenderingFirstTimeExecuted=false;this.destroyAggregation("items");m.getData().items=[];return this;};
e.prototype.addSelectionItem=function(s){var m=this._getInternalModel();var D=m.getData();this.addAggregation("selectionItems",s);var M=this._getModelItemByColumnKey(s.getColumnKey());if(!M){return;}M.persistentIndex=s.getIndex();M.persistentSelected=s.getSelected();this._sortModelItemsByPersistentIndex(D.items);this._updateModelItemsTableIndex(D);this._updateCounts(D);return this;};
e.prototype.insertSelectionItem=function(s,i){var m=this._getInternalModel();var D=m.getData();this.insertAggregation("selectionItems",s,i);var M=this._getModelItemByColumnKey(s.getColumnKey());if(!M){return;}M.persistentIndex=s.getIndex();M.persistentSelected=s.getSelected();this._sortModelItemsByPersistentIndex(D.items);this._updateModelItemsTableIndex(D);this._updateCounts(D);return this;};
e.prototype.removeSelectionItem=function(s){var m=this._getInternalModel();var D=m.getData();s=this.removeAggregation("selectionItems",s);var M=this._getModelItemByColumnKey(s.getColumnKey());if(!M){return;}M.persistentIndex=-1;M.persistentSelected=undefined;this._sortModelItemsByPersistentIndex(D.items);this._updateModelItemsTableIndex(D);this._updateCounts(D);return s;};
e.prototype.removeAllSelectionItems=function(){var m=this._getInternalModel();var D=m.getData();this.getSelectionItems().forEach(function(o){var M=this._getModelItemByColumnKey(o.getColumnKey());if(!M){return;}M.persistentIndex=-1;M.persistentSelected=undefined;},this);this._sortModelItemsByPersistentIndex(D.items);this._updateModelItemsTableIndex(D);this._updateCounts(D);var s=this.removeAllAggregation("selectionItems");return s;};
e.prototype.destroySelectionItems=function(){var m=this._getInternalModel();var D=m.getData();this.getSelectionItems().forEach(function(s){var M=this._getModelItemByColumnKey(s.getColumnKey());if(!M){return;}M.persistentIndex=-1;M.persistentSelected=undefined;},this);this._sortModelItemsByPersistentIndex(D.items);this._updateModelItemsTableIndex(D);this._updateCounts(D);this.destroyAggregation("selectionItems");return this;};
e.prototype.onBeforeNavigationFrom=function(){this._syncModel2Panel();return true;};
e.prototype.exit=function(){sap.ui.core.ResizeHandler.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null;this._getToolbar().destroy();this._oTable.destroy();this._oTable=null;if(this._getInternalModel()){this._getInternalModel().destroy();}window.clearTimeout(this._iLiveChangeTimer);window.clearTimeout(this._iSearchTimer);};
e.prototype._syncPanel2Model=function(){var m=this._getInternalModel();var D=m.getData();this.getSelectionItems().forEach(function(s){var M=this._getModelItemByColumnKey(s.getColumnKey());if(!M||this._isSelectionItemEqualToModelItem(s,M)){return;}M.persistentIndex=s.getIndex();M.persistentSelected=s.getSelected();this._sortModelItemsByPersistentIndex(D.items);this._updateModelItemsTableIndex(D);this._updateCounts(D);},this);m.refresh();};
e.prototype._syncModel2Panel=function(){if(!this._bOnBeforeRenderingFirstTimeExecuted){return;}var D=this._getInternalModel().getData();D.items.forEach(function(m){var s=this._getSelectionItemByColumnKey(m.columnKey);if(s){if(!this._isSelectionItemEqualToModelItem(s,m)){s.setProperty("selected",m.persistentSelected,true);s.setProperty("index",m.persistentIndex,true);}return;}if(!m.persistentSelected){return;}s=new sap.m.P13nSelectionItem({columnKey:m.columnKey,selected:m.persistentSelected,index:m.persistentIndex});this.addAggregation("selectionItems",s,true);},this);};
e.prototype._moveMarkedTableItem=function(D){var o=this._getInternalModel().getData();if(!o.markedTableItem||o.indexOfMarkedTableItem<0){return;}var v=this._getVisibleTableItems();if(v.indexOf(o.markedTableItem)<0){return;}var f=function(){switch(D){case"Down":return o.indexOfMarkedTableItem+1;case"Bottom":return V.length-1;case"Up":return o.indexOfMarkedTableItem-1;case"Top":return 0;}};var V=this._getVisibleModelItems();var m=V[o.indexOfMarkedTableItem];var M=V[f()];if(this._moveModelItems(this._getModelItemIndexByColumnKey(m.columnKey),this._getModelItemIndexByColumnKey(M.columnKey))){this._switchMarkedTableItemTo(v[f()]);this.notifyChange();}};
e.prototype._filterModelItemsBySearchText=function(){var m=this._getInternalModel();var s=this._getSearchText();s=s.replace(/(^\s+)|(\s+$)/g,'');s=s.replace(/[-\/\\^$*+?.()|[\]{}]/g,'\\$&');var r=new RegExp(s,'igm');if(!r){return;}this._getVisibleModelItems().forEach(function(M){M.visible=false;if(M.text&&M.text.match(r)){M.visible=true;}if(M.tooltip&&M.tooltip.match(r)){M.visible=true;}});m.refresh();};
e.prototype._scrollToSelectedItem=function(i){var f=null;if(i){sap.ui.getCore().applyChanges();if(!!i.getDomRef()){f=document.activeElement;i.focus();if(f&&f.focus){f.focus();}}}};
e.prototype._includeModelItem=function(i,I){var m=this._getInternalModel();var D=m.getData();if(I<0){I=D.items.length;}var M={columnKey:i.getColumnKey(),visible:true,text:i.getText(),href:i.getHref(),target:i.getTarget(),tooltip:i.getTooltip(),originalIndex:I,persistentIndex:-1,persistentSelected:undefined,tableIndex:undefined};D.linkPressMap[i.getText()+"---"+i.getHref()]=i.getPress();D.items.splice(I,0,M);};
e.prototype._onItemPressed=function(E){this._switchMarkedTableItemTo(E.getParameter('listItem'));};
e.prototype._onSelectionChange=function(E){var m=this._getInternalModel();var D=m.getData();var t=E.getParameter("listItem");this._switchMarkedTableItemTo(t);this._updateModelItemsPersistentIndex(D);this._updateCounts(D);m.refresh();this.notifyChange();};
e.prototype._onSwitchButtonShowSelected=function(){var D=this._getInternalModel().getData();D.showOnlySelectedItems=!D.showOnlySelectedItems;this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();this._scrollToSelectedItem(D.markedTableItem);this._updateControlLogic();this._fnHandleResize();};
e.prototype._onExecuteSearch=function(){var D=this._getInternalModel().getData();this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();this._scrollToSelectedItem(D.markedTableItem);this._updateControlLogic();};
e.prototype._getSelectionItemByColumnKey=function(s){for(var i=0,a=this.getSelectionItems(),b=a.length;i<b;i++){if(a[i].getColumnKey()===s){return a[i];}}return null;};
e.prototype._getModelItemIndexByColumnKey=function(s){var i=-1;this._getInternalModel().getData().items.some(function(m,I){if(m.columnKey===s){i=I;return true;}});return i;};
e.prototype._getModelItemByColumnKey=function(s){var m=null;this._getInternalModel().getData().items.some(function(M){if(M.columnKey===s){m=M;return true;}});return m;};
e.prototype._moveModelItems=function(i,I){var m=this._getInternalModel();var D=m.getData();if(i<0||I<0||i>D.items.length-1||I>D.items.length-1){return false;}var M=D.items.splice(i,1);D.items.splice(I,0,M[0]);this._updateModelItemsPersistentIndex(D);this._updateModelItemsTableIndex(D);this._updateCounts(D);m.refresh();return true;};
e.prototype._switchVisibilityOfUnselectedModelItems=function(){var m=this._getInternalModel();var s=this._isFilteredByShowSelected();m.getData().items.forEach(function(M){if(M.persistentSelected){M.visible=true;return;}M.visible=!s;});m.refresh();};
e.prototype._getVisibleTableItems=function(){var v=[];this._oTable.getItems().forEach(function(t){if(t.getVisible()){v.push(t);}});return v;};
e.prototype._getVisibleModelItems=function(){var v=[];this._getInternalModel().getData().items.forEach(function(m){if(m.visible){v.push(m);}});return v;};
e.prototype._getSelectedModelItems=function(){var s=[];this._getInternalModel().getData().items.forEach(function(m){if(m.persistentSelected){s.push(m);}});return s;};
e.prototype._getModelItemByTableItem=function(t){var i=this._getVisibleTableItems().indexOf(t);return this._getVisibleModelItems()[i];};
e.prototype._updateModelItemsTableIndex=function(D){D.items.forEach(function(m,t){m.tableIndex=t;});};
e.prototype._updateModelItemsPersistentIndex=function(D){var p=-1;D.items.forEach(function(m){m.persistentIndex=-1;if(m.persistentSelected){p++;m.persistentIndex=p;}});};
e.prototype._updateCounts=function(D){D.countOfSelectedItems=0;D.countOfItems=0;D.items.forEach(function(m){D.countOfItems++;if(m.persistentSelected){D.countOfSelectedItems++;}});};
e.prototype._sortModelItemsByPersistentIndex=function(m){if(!this._getInternalModel().getProperty("/config/isEnabledSelectedItemsSorting")){return;}m.sort(function(a,b){if(a.persistentSelected===true&&(b.persistentSelected===false||b.persistentSelected===undefined)){return-1;}else if((a.persistentSelected===false||a.persistentSelected===undefined)&&b.persistentSelected===true){return 1;}else if(a.persistentSelected===true&&b.persistentSelected===true){if(a.persistentIndex<b.persistentIndex){return-1;}else if(a.persistentIndex>b.persistentIndex){return 1;}else{return 0;}}else if((a.persistentSelected===false||a.persistentSelected===undefined)&&(b.persistentSelected===false||b.persistentSelected===undefined)){if(a.text<b.text){return-1;}else if(a.text>b.text){return 1;}else{return 0;}}});};
e.prototype._switchMarkedTableItemTo=function(t){var D=this._getInternalModel().getData();if(D.markedTableItem===t){return;}if(D.markedTableItem){D.markedTableItem.removeStyleClass("sapMP13nColumnsPanelItemSelected");}D.indexOfMarkedTableItem=this._getVisibleTableItems().indexOf(t);D.markedTableItem=t;if(D.markedTableItem){D.markedTableItem.addStyleClass("sapMP13nColumnsPanelItemSelected");}this._scrollToSelectedItem(D.markedTableItem);this._updateControlLogic();};
e.prototype._getTableColumns=function(){var t=this;return[new sap.m.Column({header:new sap.m.Text({text:{parts:[{path:'/countOfSelectedItems'},{path:'/countOfItems'}],formatter:function(i,a){return t._oRb.getText('COLUMNSPANEL_SELECT_ALL_WITH_COUNTER',[i,a]);}}})})];};
e.prototype._getTableTemplate=function(){var t=this;return new sap.m.ColumnListItem({cells:[new sap.m.Link({href:"{href}",text:"{text}",target:"{target}",enabled:{path:'href',formatter:function(v){if(!v){this.addStyleClass("sapUiCompSmartLink");}return!!v;}},press:function(E){var o=t._getInternalModel().getProperty("/linkPressMap")[this.getText()+"---"+this.getHref()];if(o){o(E);}}})],visible:"{visible}",selected:"{persistentSelected}",tooltip:"{tooltip}",type:sap.m.ListType.Active});};
e.prototype._createTable=function(){this._oTable=new T({mode:sap.m.ListMode.MultiSelect,rememberSelections:false,itemPress:q.proxy(this._onItemPressed,this),selectionChange:q.proxy(this._onSelectionChange,this),columns:this._getTableColumns(),items:{path:"/items",templateShareable:false,template:this._getTableTemplate()}});this._oTable.setModel(this._getInternalModel());};
e.prototype._createToolbar=function(){var m=this._getInternalModel();var t=this;var s=new S(this.getId()+"-searchField",{liveChange:function(E){var v=E.getSource().getValue(),D=(v?300:0);window.clearTimeout(t._iSearchTimer);if(D){t._iSearchTimer=window.setTimeout(function(){t._onExecuteSearch();},D);}else{t._onExecuteSearch();}},search:q.proxy(this._onExecuteSearch,this),layoutData:new sap.m.OverflowToolbarLayoutData({minWidth:"12.5rem",maxWidth:"23.077rem",shrinkable:true,moveToOverflow:true,priority:sap.m.OverflowToolbarPriority.High})});var o=new sap.m.OverflowToolbar(this.getId()+"-toolbar",{active:true,design:sap.m.ToolbarDesign.Auto,content:[new sap.m.ToolbarSpacer(),s]});var a=new sap.m.Button({text:{path:'/showOnlySelectedItems',formatter:function(h){return h?t._oRb.getText('COLUMNSPANEL_SHOW_ALL'):t._oRb.getText('COLUMNSPANEL_SHOW_SELECTED');}},tooltip:this._oRb.getText('COLUMNSPANEL_SHOW_SELECTED'),type:sap.m.ButtonType.Transparent,press:q.proxy(this._onSwitchButtonShowSelected,this),layoutData:new sap.m.OverflowToolbarLayoutData({moveToOverflow:true,priority:sap.m.OverflowToolbarPriority.High}),visible:{path:'/config/isEnabledSelectedButton'}});a.setModel(m);o.addContent(a);var M=new sap.m.OverflowToolbarButton({icon:sap.ui.core.IconPool.getIconURI("slim-arrow-down"),text:this._oRb.getText('COLUMNSPANEL_MOVE_DOWN'),tooltip:this._oRb.getText('COLUMNSPANEL_MOVE_DOWN'),type:sap.m.ButtonType.Transparent,enabled:{path:'/isMoveDownButtonEnabled'},press:function(){t._moveMarkedTableItem("Down");var h=t._getInternalModel().getData();if(!h.isMoveDownButtonEnabled){h.markedTableItem.focus();}},layoutData:new sap.m.OverflowToolbarLayoutData({moveToOverflow:true,priority:sap.m.OverflowToolbarPriority.High,group:1}),visible:{path:'/config/isEnabledMoveButtons'}});M.setModel(m);var b=new sap.m.OverflowToolbarButton({icon:sap.ui.core.IconPool.getIconURI("slim-arrow-up"),text:this._oRb.getText('COLUMNSPANEL_MOVE_UP'),tooltip:this._oRb.getText('COLUMNSPANEL_MOVE_UP'),type:sap.m.ButtonType.Transparent,enabled:{path:'/isMoveUpButtonEnabled'},press:function(){t._moveMarkedTableItem("Up");var h=t._getInternalModel().getData();if(!h.isMoveUpButtonEnabled){h.markedTableItem.focus();}},layoutData:new sap.m.OverflowToolbarLayoutData({moveToOverflow:true,priority:sap.m.OverflowToolbarPriority.High,group:1}),visible:{path:'/config/isEnabledMoveButtons'}});b.setModel(m);var f=new sap.m.OverflowToolbarButton({icon:sap.ui.core.IconPool.getIconURI("expand-group"),text:this._oRb.getText('COLUMNSPANEL_MOVE_TO_BOTTOM'),tooltip:this._oRb.getText('COLUMNSPANEL_MOVE_TO_BOTTOM'),type:sap.m.ButtonType.Transparent,enabled:{path:'/isMoveDownButtonEnabled'},press:function(){t._moveMarkedTableItem("Bottom");var h=t._getInternalModel().getData();if(!h.isMoveDownButtonEnabled){h.markedTableItem.focus();}},layoutData:new sap.m.OverflowToolbarLayoutData({moveToOverflow:true,priority:sap.m.OverflowToolbarPriority.Low,group:2}),visible:{path:'/config/isEnabledMoveButtons'}});f.setModel(m);var g=new sap.m.OverflowToolbarButton({icon:sap.ui.core.IconPool.getIconURI("collapse-group"),text:this._oRb.getText('COLUMNSPANEL_MOVE_TO_TOP'),tooltip:this._oRb.getText('COLUMNSPANEL_MOVE_TO_TOP'),type:sap.m.ButtonType.Transparent,enabled:{path:'/isMoveUpButtonEnabled'},press:function(){t._moveMarkedTableItem("Top");var h=t._getInternalModel().getData();if(!h.isMoveUpButtonEnabled){h.markedTableItem.focus();}},layoutData:new sap.m.OverflowToolbarLayoutData({moveToOverflow:true,priority:sap.m.OverflowToolbarPriority.Low,group:2}),visible:{path:'/config/isEnabledMoveButtons'}});g.setModel(m);o.addContent(g).addContent(b).addContent(M).addContent(f);this.addAggregation("content",o);};
e.prototype._getToolbar=function(){return sap.ui.getCore().byId(this.getId()+"-toolbar")||null;};
e.prototype._getSearchField=function(){return sap.ui.getCore().byId(this.getId()+"-searchField")||null;};
e.prototype._getSearchText=function(){var s=this._getSearchField();return s?s.getValue():"";};
e.prototype._isFilteredBySearchText=function(){return!!this._getSearchText().length;};
e.prototype._isFilteredByShowSelected=function(){return this._getInternalModel().getData().showOnlySelectedItems;};
e.prototype._isSelectionItemEqualToModelItem=function(s,m){return m.persistentIndex===s.getIndex()&&m.persistentSelected===s.getSelected();};
e.prototype._updateControlLogic=function(){var m=this._getInternalModel();var D=m.getData();var i=this._isFilteredBySearchText();var s=this._isFilteredByShowSelected();var v=this._getVisibleTableItems();D.isMoveUpButtonEnabled=v.indexOf(D.markedTableItem)>-1&&D.indexOfMarkedTableItem>0;D.isMoveDownButtonEnabled=v.indexOf(D.markedTableItem)>-1&&D.indexOfMarkedTableItem<v.length-1&&D.indexOfMarkedTableItem>-1;var t=sap.ui.getCore().byId(this._oTable.getId()+'-sa');if(t){t.setEnabled(!i&&!s);}m.refresh();};
e.prototype._getInternalModel=function(){return this.getModel("$sapmP13nSelectionPanel");};
e.prototype.notifyChange=function(){var L=this.getChangeNotifier();if(L){L(this);}};
e.prototype._showAll=function(){q.sap.log.info("ModelItems: columnKey originalIndex  tableIndex_isVisible  persistentIndex_isPersistent        TableItems: current");q.sap.log.info("--------------------------------------------------------------");var D=this._getInternalModel().getData();var t=this._oTable.getItems();var L=Math.max(D.items.length,this._oTable.getItems().length);for(var i=0;i<L;i++){var m=D.items[i];var o=t[i];q.sap.log.info(m.columnKey+": "+m.originalIndex+" "+m.tableIndex+"_"+m.visible+" "+m.persistentIndex+"_"+m.persistentSelected+";  "+o.getCells()[0].getText()+": "+o.getSelected());}};
return e;},true);
sap.ui.predefine('sap/m/P13nSortItem',['jquery.sap.global','./library','sap/ui/core/Item'],function(q,l,I){"use strict";
var P=I.extend("sap.m.P13nSortItem",{metadata:{library:"sap.m",properties:{operation:{type:"string",group:"Misc",defaultValue:null},columnKey:{type:"string",group:"Misc",defaultValue:null}}}});
P.prototype.setColumnKey=function(v){return this.setProperty("columnKey",v,true);};
P.prototype.setOperation=function(v){return this.setProperty("operation",v,true);};
return P;},true);
sap.ui.predefine('sap/m/P13nSortPanel',['jquery.sap.global','./P13nConditionPanel','./P13nPanel','./library','sap/ui/core/Control'],function(q,P,a,l,C){"use strict";
var c=a.extend("sap.m.P13nSortPanel",{
metadata:{library:"sap.m",properties:{containerQuery:{type:"boolean",group:"Misc",defaultValue:false},layoutMode:{type:"string",group:"Misc",defaultValue:null}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"},sortItems:{type:"sap.m.P13nSortItem",multiple:true,singularName:"sortItem",bindable:"bindable"}},events:{addSortItem:{},removeSortItem:{},updateSortItem:{}}},
renderer:function(r,o){if(!o.getVisible()){return;}r.write("<section");r.writeControlData(o);r.addClass("sapMSortPanel");r.writeClasses();r.writeStyles();r.write(">");r.write("<div");r.addClass("sapMSortPanelContent");r.addClass("sapMSortPanelBG");r.writeClasses();r.write(">");var b=o.getAggregation("content");var L=b.length;for(var i=0;i<L;i++){r.renderControl(b[i]);}r.write("</div>");r.write("</section>");}
});
c.prototype._getConditions=function(){return this._oSortPanel.getConditions();};
c.prototype.setContainerQuery=function(b){this.setProperty("containerQuery",b);this._oSortPanel.setContainerQuery(b);return this;};
c.prototype.setLayoutMode=function(m){this.setProperty("layoutMode",m);this._oSortPanel.setLayoutMode(m);return this;};
c.prototype.validateConditions=function(){return this._oSortPanel.validateConditions();};
c.prototype.removeInvalidConditions=function(){this._oSortPanel.removeInvalidConditions();};
c.prototype.removeValidationErrors=function(){this._oSortPanel.removeValidationErrors();};
c.prototype.onBeforeNavigationFrom=function(){return this.validateConditions();};
c.prototype.onAfterNavigationFrom=function(){return this.removeInvalidConditions();};
c.prototype.setOperations=function(o){this._aOperations=o;if(this._oSortPanel){this._oSortPanel.setOperations(this._aOperations);}return this;};
c.prototype.init=function(){this.setType(sap.m.P13nPanelType.sort);this.setTitle(sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("SORTPANEL_TITLE"));sap.ui.getCore().loadLibrary("sap.ui.layout");q.sap.require("sap.ui.layout.Grid");sap.ui.layout.Grid.prototype.init.apply(this);this._aKeyFields=[];this.addStyleClass("sapMSortPanel");if(!this._aOperations){this.setOperations([sap.m.P13nConditionOperation.Ascending,sap.m.P13nConditionOperation.Descending]);}this._oSortPanel=new P({autoReduceKeyFieldItems:true,layoutMode:this.getLayoutMode(),dataChange:this._handleDataChange()});this._oSortPanel.setOperations(this._aOperations);this._oSortPanel._sAddRemoveIconTooltipKey="SORT";this.addAggregation("content",this._oSortPanel);};
c.prototype.exit=function(){var d=function(o){if(o&&o.destroy){o.destroy();}return null;};this._aKeyFields=d(this._aKeyFields);this._aOperations=d(this._aOperations);};
c.prototype.onBeforeRendering=function(){if(this._bUpdateRequired){this._bUpdateRequired=false;var k=[];var m=(this.getBindingInfo("items")||{}).model;var g=function(n,o,i){var B=i.getBinding(n);if(B&&o){return o.getObject()[B.getPath()];}return i.getMetadata().getProperty(n)?i.getProperty(n):i.getAggregation(n);};this.getItems().forEach(function(i){var o=i.getBindingContext(m);if(i.getBinding("key")){o.getObject()[i.getBinding("key").getPath()]=i.getKey();}k.push({key:i.getColumnKey(),text:g("text",o,i),tooltip:g("tooltip",o,i)});});k.splice(0,0,{key:null,text:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_SELECTION_NONE")});this._oSortPanel.setKeyFields(k);var b=[];m=(this.getBindingInfo("sortItems")||{}).model;this.getSortItems().forEach(function(s){var o=s.getBindingContext(m);if(s.getBinding("key")){o.getObject()[s.getBinding("key").getPath()]=s.getKey();}b.push({key:s.getKey(),keyField:g("columnKey",o,s),operation:g("operation",o,s)});});this._oSortPanel.setConditions(b);}};
c.prototype.addItem=function(i){a.prototype.addItem.apply(this,arguments);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
c.prototype.removeItem=function(i){var r=a.prototype.removeItem.apply(this,arguments);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return r;};
c.prototype.destroyItems=function(){this.destroyAggregation("items");if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
c.prototype.addSortItem=function(s){this.addAggregation("sortItems",s,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
c.prototype.insertSortItem=function(s,i){this.insertAggregation("sortItems",s,i,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
c.prototype.updateSortItems=function(r){this.updateAggregation("sortItems");if(r=="change"&&!this._bIgnoreBindCalls){this._bUpdateRequired=true;}};
c.prototype.removeSortItem=function(s){s=this.removeAggregation("sortItems",s,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return s;};
c.prototype.removeAllSortItems=function(){var s=this.removeAllAggregation("sortItems",true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return s;};
c.prototype.destroySortItems=function(){this.destroyAggregation("sortItems");if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
c.prototype._handleDataChange=function(){var t=this;return function(e){var n=e.getParameter("newData");var o=e.getParameter("operation");var k=e.getParameter("key");var i=e.getParameter("index");var s;if(o==="update"){s=t.getSortItems()[i];if(s){s.setColumnKey(n.keyField);s.setOperation(n.operation);}t.fireUpdateSortItem({key:k,index:i,sortItemData:s});t._notifyChange();}if(o==="add"){s=new sap.m.P13nSortItem({key:k,columnKey:n.keyField,operation:n.operation});t._bIgnoreBindCalls=true;t.fireAddSortItem({key:k,index:i,sortItemData:s});t._bIgnoreBindCalls=false;t._notifyChange();}if(o==="remove"){t._bIgnoreBindCalls=true;t.fireRemoveSortItem({key:k,index:i});t._bIgnoreBindCalls=false;t._notifyChange();}};};
c.prototype._notifyChange=function(){var L=this.getChangeNotifier();if(L){L(this);}};
return c;},true);
sap.ui.predefine('sap/m/QuickView',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/IconPool','./QuickViewBase','./ResponsivePopover','./NavContainer','./Page','./Bar','./Button'],function(q,l,C,I,Q,R,N,P,B,a){"use strict";var b=l.PlacementType;
var c=Q.extend("sap.m.QuickView",{metadata:{library:"sap.m",properties:{placement:{type:"sap.m.PlacementType",group:"Misc",defaultValue:b.Right},width:{type:'sap.ui.core.CSSSize',group:'Dimension',defaultValue:'320px'}},aggregations:{},events:{afterOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},afterClose:{parameters:{openBy:{type:"sap.ui.core.Control"},origin:{type:"sap.m.Button"}}},beforeOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},beforeClose:{parameters:{openBy:{type:"sap.ui.core.Control"},origin:{type:"sap.m.Button"}}}}}});
c.prototype.init=function(){var n={pages:[new P()],navigate:this._navigate.bind(this),afterNavigate:this._afterNavigate.bind(this)};this._oNavContainer=new N(n);var t=this;this._oPopover=new R(this.getId()+'-quickView',{placement:this.getPlacement(),content:[this._oNavContainer],contentWidth:this.getWidth(),showHeader:false,showCloseButton:false,afterOpen:function(e){t._afterOpen(e);t.fireAfterOpen({openBy:e.getParameter("openBy")});},afterClose:function(e){t.fireAfterClose({openBy:e.getParameter("openBy"),origin:t.getCloseButton()});},beforeOpen:function(e){t.fireBeforeOpen({openBy:e.getParameter("openBy")});},beforeClose:function(e){t.fireBeforeClose({openBy:e.getParameter("openBy"),origin:t.getCloseButton()});}});this._oPopover.addStyleClass('sapMQuickView');var p=this._oPopover.getAggregation("_popup");p.addEventDelegate({onBeforeRendering:this.onBeforeRenderingPopover,onAfterRendering:this._setLinkWidth,onkeydown:this._onPopupKeyDown},this);var t=this;var s=p._fnAdjustPositionAndArrow;if(s){p._fnAdjustPositionAndArrow=function(){s.apply(p,arguments);t._adjustContainerHeight();};}this._bItemsChanged=true;this._oPopover.addStyleClass("sapMQuickView");};
c.prototype.onBeforeRenderingPopover=function(){this._bRendered=true;if(this._bItemsChanged){this._clearContainerHeight();this._initPages();var p=this.getAggregation("pages");if(!p&&sap.ui.Device.system.phone){this._addEmptyPage();}this._bItemsChanged=false;}};
c.prototype.exit=function(){this._bRendered=false;this._bItemsChanged=true;if(this._oPopover){this._oPopover.destroy();this._oPopover=null;}};
c.prototype._createPage=function(o){return o._createPage();};
c.prototype._onPopupKeyDown=function(e){this._processKeyboard(e);};
c.prototype._afterOpen=function(e){if(sap.ui.Device.system.phone){this._restoreFocus();}};
c.prototype._addEmptyPage=function(){var p=new P({customHeader:new B().addStyleClass("sapMQuickViewHeader")});var t=this;var o=p.getCustomHeader();o.addContentRight(new a({icon:I.getIconURI("decline"),press:function(){t._oPopover.close();}}));p.addStyleClass('sapMQuickViewPage');this._oNavContainer.addPage(p);};
c.prototype._clearContainerHeight=function(){var p=this._oPopover.getAggregation("_popup");var $=p.$().find('.sapMPopoverCont');if($[0]&&$[0].style.height){$[0].style.height='';}};
c.prototype._adjustContainerHeight=function(){var p=this._oPopover.getAggregation("_popup");var $=p.$().find('.sapMPopoverCont');if($[0]&&!$[0].style.height){$[0].style.height=$.height()+'px';}};
c.prototype._setLinkWidth=function(){this._oPopover.$().find(".sapMLnk").css("width","auto");};
c.prototype.getCloseButton=function(){if(!sap.ui.Device.system.phone){return undefined;}var p=this._oNavContainer.getCurrentPage();var o=p.getCustomHeader().getContentRight()[0];return o;};
c.prototype.setPlacement=function(p){this.setProperty("placement",p,true);this._oPopover.setPlacement(p);return this;};
c.prototype.setWidth=function(w){if(this._oPopover){this._oPopover.setContentWidth(w);this.setProperty('width',w,true);}return this;};
c.prototype.openBy=function(o){this._bItemsChanged=true;this._oPopover.openBy(o);return this;};
c.prototype.getDomRef=function(s){return this._oPopover&&this._oPopover.getAggregation("_popup").getDomRef(s);};
["addStyleClass","removeStyleClass","toggleStyleClass","hasStyleClass","getBusyIndicatorDelay","setBusyIndicatorDelay","getVisible","setVisible","getFieldGroupIds","setFieldGroupIds","getBusy","setBusy","setTooltip","getTooltip"].forEach(function(n){c.prototype[n]=function(){if(this._oPopover&&this._oPopover[n]){var r=this._oPopover.getAggregation("_popup")[n].apply(this._oPopover.getAggregation("_popup"),arguments);return r===this._oPopover.getAggregation("_popup")?this:r;}};});["setModel","bindAggregation","setAggregation","insertAggregation","addAggregation","removeAggregation","removeAllAggregation","destroyAggregation"].forEach(function(f){c.prototype["_"+f+"Old"]=c.prototype[f];c.prototype[f]=function(){var r=c.prototype["_"+f+"Old"].apply(this,arguments);this._bItemsChanged=true;if(this._oPopover){if(arguments[0]!="pages"){this._oPopover[f].apply(this._oPopover,arguments);}if(this._bRendered){this._oPopover.invalidate();}}if(["removeAggregation","removeAllAggregation"].indexOf(f)!==-1){return r;}return this;};});return c;},true);
sap.ui.predefine('sap/m/QuickViewBase',['jquery.sap.global','./library','sap/ui/core/Control','jquery.sap.dom'],function(q,l,C){"use strict";
var Q=C.extend("sap.m.QuickViewBase",{metadata:{library:"sap.m",properties:{},defaultAggregation:"pages",aggregations:{pages:{type:"sap.m.QuickViewPage",multiple:true,singularName:"page",bindable:"bindable"}},events:{navigate:{allowPreventDefault:true,parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"},navOrigin:{type:"sap.ui.core.Control"}}},afterNavigate:{parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"},isTopPage:{type:"boolean"},navOrigin:{type:"sap.ui.core.Control"}}}}}});
Q.prototype.navigateBack=function(){if(!this._oNavContainer.currentPageIsTopPage()){this._setNavOrigin(null);this._oNavContainer.back();}};
Q.prototype.getNavContainer=function(){return this._oNavContainer;};
Q.prototype._initPages=function(){var n=this._oNavContainer;n.destroyPages();n.init();var p=this.getAggregation("pages");if(!p){return;}var I=this.getId();for(var i=0;i<p.length;i++){var o=p[i];o._oPage=null;var N={hasBackButton:i>0,popover:this._oPopover,navContainer:n,quickViewId:I,quickView:this};o.setNavContext(N);var P=this._createPage(o);this._oNavContainer.addPage(P);}};
Q.prototype._processKeyboard=function(e){if(e.shiftKey&&e.which===q.sap.KeyCodes.ENTER){this.navigateBack();e.preventDefault();}};
Q.prototype._createPage=function(o){return o;};
Q.prototype._navigate=function(e){var t=e.getParameter('to');var f=e.getParameter('from');var T=e.getParameter('toId');var F=e.getParameter('fromId');var i=q.sap.byId(F).index();var a=q.sap.byId(T).index();if(a==-1||a>i){t.addStyleClass('sapMNavItemOffset');}else{f.addStyleClass('sapMNavItemOffset');}f.$().parents('.sapMPanelContent').scrollTop(0);var p=e.getParameters();if(this._navOrigin){p.navOrigin=this._navOrigin;}this.fireNavigate(p);};
Q.prototype._afterNavigate=function(e){var t=e.getParameter('to');var f=e.getParameter('from');var T=e.getParameter('toId');var F=e.getParameter('fromId');var i=q.sap.byId(F).index();var a=q.sap.byId(T).index();if(a>i){t.removeStyleClass('sapMNavItemOffset');}else{f.removeStyleClass('sapMNavItemOffset');}var p=e.getParameters();p.isTopPage=this._oNavContainer.currentPageIsTopPage();if(this._navOrigin){p.navOrigin=this._navOrigin;}this.fireAfterNavigate(p);this._setLinkWidth();q.sap.delayedCall(0,this,this._restoreFocus);};
Q.prototype._restoreFocus=function(){var p=this._oNavContainer.getCurrentPage();var f=this._oNavContainer._mFocusObject[p.getId()];if(!f){var c=p.getContent();if(c&&c.length>1){f=c[1].$().firstFocusableDomRef();}}if(f){q.sap.focus(f);}};
Q.prototype._setLinkWidth=function(){};
Q.prototype._setNavOrigin=function(c){this._navOrigin=c;};
return Q;},true);
sap.ui.predefine('sap/m/QuickViewCard',['jquery.sap.global','./library','sap/ui/core/Control','./QuickViewBase','./NavContainer','./Page','./ScrollContainer'],function(q,l,C,Q,N,P,S){"use strict";
var a=Q.extend("sap.m.QuickViewCard",{metadata:{library:"sap.m",properties:{showVerticalScrollBar:{type:"boolean",group:"Behavior",defaultValue:true}}}});
a.prototype.init=function(){var n={pages:[new P()],navigate:this._navigate.bind(this),afterNavigate:this._afterNavigate.bind(this)};this._oNavContainer=new N(n);};
a.prototype.onBeforeRendering=function(){this._initPages();};
a.prototype.onAfterRendering=function(){this._setLinkWidth();};
a.prototype.exit=function(){if(this._oNavContainer){this._oNavContainer.destroy();}};
a.prototype.onkeydown=function(e){this._processKeyboard(e);};
a.prototype._createPage=function(o){var c=o._createPageContent();o._mPageContent=null;var b=new S(this.getId()+'-'+o.getPageId(),{horizontal:false,vertical:false});if(c.header){b.addContent(c.header);}b.addContent(c.form);b.addStyleClass('sapMQuickViewPage');return b;};
a.prototype._setLinkWidth=function(){this.$().find(".sapMLnk").css("width","auto");};
return a;},true);
sap.ui.predefine('sap/m/QuickViewGroupElement',['jquery.sap.global','./library','sap/ui/core/Element','./Link','./Text','sap/ui/core/CustomData'],function(q,l,E,L,T,C){"use strict";var G=l.QuickViewGroupElementType;
var a=E.extend("sap.m.QuickViewGroupElement",{metadata:{library:"sap.m",properties:{visible:{type:"boolean",group:"Appearance",defaultValue:true},label:{type:"string",group:"Misc",defaultValue:""},value:{type:"string",group:"Misc",defaultValue:""},url:{type:"string",group:"Misc",defaultValue:""},target:{type:"string",group:"Misc",defaultValue:"_blank"},type:{type:"sap.m.QuickViewGroupElementType",group:"Misc",defaultValue:G.text},pageLinkId:{type:"string",group:"Misc",defaultValue:""},emailSubject:{type:"string",group:"Misc",defaultValue:""}}}});
a.prototype._getGroupElementValue=function(Q){if(!this.getValue()){return null;}switch(this.getType()){case G.email:var h="mailto:"+this.getValue();var s=this.getEmailSubject();if(s){h+='?subject='+s;}return new L({href:h,text:this.getValue(),wrapping:true});case G.phone:case G.mobile:return new L({href:"tel:"+this.getValue(),text:this.getValue()});case G.link:return new L({href:this.getUrl(),text:this.getValue(),target:this.getTarget()});case G.pageLink:var b=this.getPageLinkId();if(Q){b=Q+'-'+b;}return new L({href:"#",text:this.getValue(),customData:[new C({key:"pageNumber",value:b})]});default:return new T({text:this.getValue()});}};
a.prototype.setProperty=function(){E.prototype.setProperty.apply(this,arguments);var g=this.getParent();if(!g){return;}var p=g.getParent();if(p){p._updatePage();}};
return a;},true);
sap.ui.predefine('sap/m/QuickViewPage',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/IconPool','sap/ui/layout/form/SimpleForm','sap/ui/layout/VerticalLayout','sap/ui/layout/HorizontalLayout','./Page','./Button','./Bar','./Title','./Image','./Link','./Text','./Label','./HBox','sap/ui/core/Icon','sap/ui/core/Title','sap/ui/core/CustomData','sap/ui/core/library','sap/ui/layout/library'],function(q,l,C,I,S,V,H,P,B,a,T,b,L,c,d,f,g,h,i,m,n){"use strict";var o=n.form.SimpleFormLayout;var p=m.TitleLevel;var Q=l.QuickViewGroupElementType;var r=l.ButtonType;
var s=C.extend("sap.m.QuickViewPage",{metadata:{library:"sap.m",properties:{pageId:{type:"string",group:"Misc",defaultValue:""},header:{type:"string",group:"Misc",defaultValue:""},title:{type:"string",group:"Misc",defaultValue:""},titleUrl:{type:"string",group:"Misc",defaultValue:""},crossAppNavCallback:{type:"object",group:"Misc"},description:{type:"string",group:"Misc",defaultValue:""},icon:{type:"string",group:"Misc",defaultValue:""}},defaultAggregation:"groups",aggregations:{groups:{type:"sap.m.QuickViewGroup",multiple:true,singularName:"group",bindable:"bindable"}}}});
s.prototype.init=function(){this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle('sap.m');var G=sap.ushell&&sap.ushell.Container&&sap.ushell.Container.getService;if(G){this.oCrossAppNavigator=G("CrossApplicationNavigation");}};
s.prototype.onBeforeRendering=function(){this._destroyPageContent();this._createPageContent();};
s.prototype.getPageContent=function(){return this._mPageContent;};
s.prototype.setNavContext=function(e){this._mNavContext=e;};
s.prototype.getNavContext=function(){return this._mNavContext;};
s.prototype.setPageTitleControl=function(t){this._oPageTitle=t;};
s.prototype.getPageTitleControl=function(){return this._oPageTitle;};
s.prototype._createPage=function(){var e=this._createPageContent();var N=this.getNavContext();var j;if(this._oPage){j=this._oPage;j.destroyContent();j.setCustomHeader(new a());}else{j=this._oPage=new P(N.quickViewId+'-'+this.getPageId(),{customHeader:new a()});j.addEventDelegate({onAfterRendering:this.onAfterRenderingPage},this);}if(e.header){j.addContent(e.header);}j.addContent(e.form);var k=j.getCustomHeader();k.addContentMiddle(new T({text:this.getHeader()}).addStyleClass("sapMQuickViewTitle"));if(N.hasBackButton){k.addContentLeft(new B({type:r.Back,tooltip:this._oResourceBundle.getText("PAGE_NAVBUTTON_TEXT"),press:function(){if(N.navContainer){N.quickView._setNavOrigin(null);N.navContainer.back();}}}));}if(N.popover&&sap.ui.Device.system.phone){k.addContentRight(new B({icon:I.getIconURI("decline"),press:function(){N.popover.close();}}));}j.addStyleClass('sapMQuickViewPage');return j;};
s.prototype.onAfterRenderingPage=function(){if(this._bItemsChanged){var N=this.getNavContext();if(N){N.quickView._restoreFocus();}this._bItemsChanged=false;}};
s.prototype._createPageContent=function(){var F=this._createForm();var e=this._getPageHeaderContent();var j=this.getPageTitleControl();if(e&&j){F.addAriaLabelledBy(j);}this._mPageContent={form:F,header:e};return this._mPageContent;};
s.prototype._createForm=function(){var G=this.getAggregation("groups"),F=new S({maxContainerCols:1,editable:false,layout:o.ResponsiveGridLayout});if(G){for(var j=0;j<G.length;j++){if(G[j].getVisible()){this._renderGroup(G[j],F);}}}return F;};
s.prototype._getPageHeaderContent=function(){var e,v=new V(),j=new H(),k=this.getIcon(),t=this.getTitle(),D=this.getDescription(),u=this.getTitleUrl();if(!k&&!t&&!D){return null;}if(k){if(this.getIcon().indexOf("sap-icon")==0){e=new g({src:k,decorative:!u,useIconTooltip:false,tooltip:t});}else{e=new b({src:k,decorative:false,tooltip:t}).addStyleClass("sapUiIcon");}e.addStyleClass("sapMQuickViewThumbnail");if(u){e.attachPress(this._crossApplicationNavigation(this));}j.addContent(e);}var w;if(u){w=new L({text:t,href:u,target:"_blank"});}else if(this.getCrossAppNavCallback()){w=new L({text:t});w.attachPress(this._crossApplicationNavigation(this));}else{w=new T({text:t,level:p.H1});}this.setPageTitleControl(w);var x=new c({text:D});v.addContent(w);v.addContent(x);j.addContent(v);return j;};
s.prototype._renderGroup=function(G,F){var e=G.getAggregation("elements");var j,t,u;if(G.getHeading()){F.addContent(new h({text:G.getHeading(),level:p.H2}));}if(!e){return;}var N=this.getNavContext();for(var k=0;k<e.length;k++){j=e[k];if(!j.getVisible()){continue;}u=new d({text:j.getLabel()});var v;if(N){v=N.quickViewId;}t=j._getGroupElementValue(v);F.addContent(u);if(!t){F.addContent(new sap.m.Text({text:""}));continue;}u.setLabelFor(t.getId());if(j.getType()==Q.pageLink){t.attachPress(this._attachPressLink(this));}if(j.getType()==Q.mobile&&!sap.ui.Device.system.desktop){var w=new g({src:I.getIconURI("post"),tooltip:this._oResourceBundle.getText("QUICKVIEW_SEND_SMS"),decorative:false,customData:[new i({key:"phoneNumber",value:j.getValue()})],press:this._mobilePress});var x=new f({items:[t,w]});F.addContent(x);}else{F.addContent(t);}}};
s.prototype._crossApplicationNavigation=function(t){return function(){if(t.getCrossAppNavCallback()&&t.oCrossAppNavigator){var e=t.getCrossAppNavCallback();if(typeof e=="function"){var j=e();var k=t.oCrossAppNavigator.hrefForExternal({target:{semanticObject:j.target.semanticObject,action:j.target.action},params:j.params});sap.m.URLHelper.redirect(k);}}else if(t.getTitleUrl()){window.open(t.getTitleUrl(),"_blank");}};};
s.prototype._destroyPageContent=function(){if(!this._mPageContent){return;}if(this._mPageContent.form){this._mPageContent.form.destroy();}if(this._mPageContent.header){this._mPageContent.header.destroy();}this._mPageContent=null;};
s.prototype.exit=function(){this._oResourceBundle=null;if(this._oPage){this._oPage.destroy();this._oPage=null;}else{this._destroyPageContent();}this._mNavContext=null;};
s.prototype._attachPressLink=function(t){var N=t.getNavContext();return function(e){e.preventDefault();var j=this.getCustomData()[0].getValue();if(N.navContainer&&j){N.quickView._setNavOrigin(this);N.navContainer.to(j);}};};
s.prototype._mobilePress=function(){var e="sms://"+q.sap.encodeURL(this.getCustomData()[0].getValue());window.location.replace(e);};
s.prototype._updatePage=function(){var N=this.getNavContext();if(N&&N.quickView._bRendered){this._bItemsChanged=true;N.popover.focus();if(N.quickView.indexOfPage(this)==0){N.quickView._clearContainerHeight();}this._createPage();N.popover.$().css('display','block');N.quickView._restoreFocus();}};
["setModel","bindAggregation","setAggregation","insertAggregation","addAggregation","removeAggregation","removeAllAggregation","destroyAggregation"].forEach(function(F){s.prototype["_"+F+"Old"]=s.prototype[F];s.prototype[F]=function(){var e=s.prototype["_"+F+"Old"].apply(this,arguments);this._updatePage();if(["removeAggregation","removeAllAggregation"].indexOf(F)!==-1){return e;}return this;};});
s.prototype.setProperty=function(){C.prototype.setProperty.apply(this,arguments);this._updatePage();};
return s;},true);
/*!
 * @copyright@
 */
sap.ui.predefine('sap/m/NumericContentRenderer',['./library'],function(l){"use strict";var N={};
N.render=function(r,c){var v=c.getValue();var i=c.getIndicator();var s=c.getScale();var S=c.getState();var I=l.DeviationIndicator.None!==i&&v!=="";var w=c.getWithMargin();var W;if(w){W="";}else{W="WithoutMargin";}if(c.getFormatterValue()){var f=c._parseFormattedValue(v);s=f.scale;v=f.value;}var b=s&&v;r.write("<div");r.writeControlData(c);var t=c.getTooltip_AsString();if(typeof t!=="string"){t="";}r.writeAttributeEscaped("aria-label",t);r.writeAttribute("role","img");if(S==l.LoadState.Failed||S==l.LoadState.Loading){r.writeAttribute("aria-disabled","true");}if(c.getAnimateTextChange()){r.addStyle("opacity","0.25");}if(c.getWidth()){r.addStyle("width",c.getWidth());}r.writeStyles();r.addClass("sapMNC");r.addClass(W);if(c.hasListeners("press")){r.writeAttribute("tabindex","0");r.addClass("sapMPointer");}r.writeClasses();r.write(">");r.write("<div");r.addClass("sapMNCInner");r.addClass(W);r.writeClasses();r.write(">");if(w){this._renderScaleAndIndicator(r,c,I,b,W,i,s);this._renderValue(r,c,W,v);}else{this._renderValue(r,c,W,v);this._renderScaleAndIndicator(r,c,I,b,W,i,s);}r.write("</div>");r.write("</div>");};
N._prepareAndRenderIcon=function(r,c,i){if(i){var s,L=l.LoadState,C=c.getState();for(s in L){if(L.hasOwnProperty(s)&&s!==C){i.removeStyleClass(s);}else if(L.hasOwnProperty(s)&&s===C){i.addStyleClass(s);}}i.addStyleClass("sapMNCIconImage");r.renderControl(i);}};
N._renderScaleAndIndicator=function(r,c,i,a,w,t,b){if(i||a){var s=c.getState();var C=c.getValueColor();r.write("<div");r.addClass("sapMNCIndScale");r.addClass(w);r.addClass(s);r.writeClasses();r.write(">");r.write("<div");r.writeAttribute("id",c.getId()+"-indicator");r.addClass("sapMNCIndicator");r.addClass(t);r.addClass(s);r.addClass(C);r.writeClasses();r.write("/>");if(a){r.write("<div");r.writeAttribute("id",c.getId()+"-scale");r.addClass("sapMNCScale");r.addClass(s);r.addClass(C);r.writeClasses();r.write(">");r.writeEscaped(b.substring(0,3));r.write("</div>");}r.write("</div>");}};
N._renderValue=function(r,c,w,v){var e;if(c.getNullifyValue()){e="0";}else{e="";}r.write("<div");r.writeAttribute("id",c.getId()+"-value");r.addClass("sapMNCValue");r.addClass(w);r.addClass(c.getValueColor());r.addClass(c.getState());r.writeClasses();r.write(">");r.write("<div");r.writeAttribute("id",c.getId()+"-value-scr");r.addClass("sapMNCValueScr");r.addClass(w);r.writeClasses();r.write(">");this._prepareAndRenderIcon(r,c,c._oIcon);var C=c.getTruncateValueTo();if(v.length>=C&&(v[C-1]==="."||v[C-1]===",")){r.writeEscaped(v.substring(0,C-1));}else{if(v){r.writeEscaped(v.substring(0,C));}else{r.writeEscaped(e);}}r.write("</div>");r.write("</div>");};
return N;},true);
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/m/AccButton',['jquery.sap.global','./Button'],function(q,B){"use strict";
var A=B.extend("sap.m.AccButton",{metadata:{library:"sap.m",properties:{"tabIndex":{type:"string",defaultValue:null,bindable:"bindable"},"ariaHidden":{type:"string",defaultValue:null,bindable:"bindable"}}}});
return A;},false);
sap.ui.predefine('sap/m/AccButtonRenderer',['jquery.sap.global','./ButtonRenderer','sap/ui/core/Renderer'],function(q,B,R){"use strict";var A=R.extend(B);
A.renderAccessibilityAttributes=function(r,c){if(c.getTabIndex()){r.writeAttribute("tabindex",c.getTabIndex());}if(c.getAriaHidden()){r.writeAttribute("aria-hidden",c.getAriaHidden());}};
return A;},true);
sap.ui.predefine('sap/m/ActionListItem',['jquery.sap.global','./ListItemBase','./library','sap/ui/core/EnabledPropagator'],function(q,L,l,E){"use strict";
var A=L.extend("sap.m.ActionListItem",{metadata:{library:"sap.m",properties:{text:{type:"string",group:"Misc",defaultValue:null}}}});
A.prototype.init=function(){this.setType(sap.m.ListType.Active);L.prototype.init.apply(this,arguments);};
A.prototype.getMode=function(){return sap.m.ListMode.None;};
A.prototype.onsapspace=A.prototype.onsapenter;
A.prototype.getContentAnnouncement=function(){return this.getText();};
return A;},true);
sap.ui.predefine('sap/m/ActionListItemRenderer',['jquery.sap.global','./ListItemBaseRenderer','sap/ui/core/Renderer'],function(q,L,R){"use strict";var A=R.extend(L);
A.renderLIAttributes=function(r,l){r.addClass("sapMALI");};
A.renderLIContent=function(r,l){var i=l.getText();if(i){r.write("<div class='sapMALIText'>");r.writeEscaped(i);r.write("</div>");}};
return A;},true);
sap.ui.predefine('sap/m/ActionSelect',['jquery.sap.global','./Select','./library'],function(q,S,l){"use strict";
var A=S.extend("sap.m.ActionSelect",{metadata:{library:"sap.m",associations:{buttons:{type:"sap.m.Button",multiple:true,singularName:"button"}}}});
A.prototype.init=function(){S.prototype.init.call(this);this.getList().addEventDelegate({onfocusin:this.onfocusinList},this);};
A.prototype.hasContent=function(){return S.prototype.hasContent.call(this)||!!this.getButtons().length;};
A.prototype.addContent=function(){var c=sap.ui.getCore(),p=this.getPicker();this.getButtons().forEach(function(b){p.addContent(c.byId(b));});};
A.prototype.onAfterRenderingPicker=function(){S.prototype.onAfterRenderingPicker.call(this);var p=this.getPicker(),r=this.getRenderer();p.addStyleClass(r.CSS_CLASS+"Picker");p.addStyleClass(r.ACTION_SELECT_CSS_CLASS+"Picker");p.addStyleClass(r.ACTION_SELECT_CSS_CLASS+"Picker-CTX");};
A.prototype.createPickerCloseButton=function(){};
A.prototype.removeButton=function(b){var p=this.getPicker();if(p){if(typeof b==="number"){b=this.getButtons()[b];}p.removeContent(b);}return this.removeAssociation("buttons",b);};
A.prototype.removeAllButtons=function(){var p=this.getPicker();if(p){this.getButtons().forEach(function(b){p.removeContent(b);});}return this.removeAllAssociation("buttons");};
A.prototype.onsaptabprevious=function(e){var b=this.getButtons(),p=this.getPicker(),i;if(e.isMarked()||!this.getEnabled()){return;}e.setMarked();if(p&&p.isOpen()&&b.length>0){for(i=b.length-1;i>=0;i--){if(sap.ui.getCore().byId(b[i]).getEnabled()){sap.ui.getCore().byId(b[i]).focus();e.preventDefault();break;}}}};
A.prototype.onsaptabnext=function(e){var b=this.getButtons(),p=this.getPicker(),i;if(e.isMarked()||!this.getEnabled()){return;}e.setMarked();if(p&&p.isOpen()&&b.length>0){for(i=0;i<b.length;i++){if(sap.ui.getCore().byId(b[i]).getEnabled()){sap.ui.getCore().byId(b[i]).focus();e.preventDefault();break;}}}};
A.prototype.onsapfocusleave=function(e){var b=this.getButtons();var k=(b.indexOf(e.relatedControlId)==-1);if(k){S.prototype.onsapfocusleave.apply(this,arguments);}this._toggleListFocusIndication(true);};
A.prototype.onfocusinList=function(e){if(document.activeElement!==this.getList().getDomRef()){this.focus();}};
A.prototype.onfocusin=function(){S.prototype.onfocusin.apply(this,arguments);this._toggleListFocusIndication(false);};
A.prototype._toggleListFocusIndication=function(r){var s=this.getSelectedItem();if(this.isOpen()&&s){s.$().toggleClass("sapMActionSelectItemWithoutFocus",r);}};
return A;},true);
sap.ui.predefine('sap/m/ActionSelectRenderer',['jquery.sap.global','sap/ui/core/Renderer','./SelectRenderer'],function(q,R,S){"use strict";var A=R.extend(S);A.ACTION_SELECT_CSS_CLASS="sapMActionSelect";
A.addClass=function(r,a){r.addClass(A.ACTION_SELECT_CSS_CLASS);};
return A;},true);
sap.ui.predefine('sap/m/ActionSheet',['jquery.sap.global','./Dialog','./Popover','./library','sap/ui/core/Control','sap/ui/core/delegate/ItemNavigation','sap/ui/core/InvisibleText','sap/ui/base/ManagedObject'],function(q,D,P,l,C,I,a,M){"use strict";
var A=C.extend("sap.m.ActionSheet",{metadata:{library:"sap.m",properties:{placement:{type:"sap.m.PlacementType",group:"Appearance",defaultValue:sap.m.PlacementType.Bottom},showCancelButton:{type:"boolean",group:"Appearance",defaultValue:true},cancelButtonText:{type:"string",group:"Appearance",defaultValue:null},title:{type:"string",group:"Appearance",defaultValue:null}},aggregations:{buttons:{type:"sap.m.Button",multiple:true,singularName:"button"},_cancelButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_invisibleAriaTexts:{type:"sap.ui.core.InvisibleText",multiple:true,visibility:"hidden"}},defaultAggregation:"buttons",events:{cancelButtonTap:{deprecated:true},beforeOpen:{},afterOpen:{},beforeClose:{origin:{type:"sap.m.Button"}},afterClose:{origin:{type:"sap.m.Button"}},cancelButtonPress:{}}}});
var p;
A.prototype.init=function(){this._fnOrientationChange=this._orientationChange.bind(this);};
A.prototype.exit=function(){sap.ui.Device.resize.detachHandler(this._fnOrientationChange);if(this._parent){this._parent.destroy();this._parent=null;}if(this._oCancelButton){this._oCancelButton.destroy();this._oCancelButton=null;}this._clearItemNavigation();};
A.prototype._clearItemNavigation=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}};
A.prototype._setItemNavigation=function(){var b=this._getAllButtons(),d=[],o=this.getDomRef();if(o){this._oItemNavigation.setRootDomRef(o);for(var i=0;i<b.length;i++){if(b[i].getEnabled()&&b[i].getVisible()){d.push(b[i].getFocusDomRef());}}if(this._oCancelButton){d.push(this._oCancelButton.getFocusDomRef());}this._oItemNavigation.setItemDomRefs(d);this._oItemNavigation.setSelectedIndex(0);this._oItemNavigation.setPageSize(5);this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"]});}};
A.prototype.onBeforeRendering=function(){this._clearItemNavigation();};
A.prototype.onAfterRendering=function(){this._oItemNavigation=new I();this._oItemNavigation.setCycling(false);this.addDelegate(this._oItemNavigation);this._setItemNavigation();};
A.prototype.sapfocusleave=function(){this.close();};
A.prototype.openBy=function(c){var t=this;if(!this._parent){var o=this.getParent();if(o){this.setParent(null);}if(!sap.ui.Device.system.phone){this._parent=new P({placement:this.getPlacement(),showHeader:false,content:[this],beforeOpen:function(){t.fireBeforeOpen();},afterOpen:function(){t.focus();t.fireAfterOpen();},beforeClose:function(){t.fireBeforeClose();},afterClose:function(){if(t.getShowCancelButton()){t.fireCancelButtonTap();t.fireCancelButtonPress();}t.fireAfterClose();},ariaLabelledBy:this.getPopupHiddenLabelId()||undefined}).addStyleClass("sapMActionSheetPopover");if(sap.ui.Device.browser.internet_explorer){this._parent._fnAdjustPositionAndArrow=q.proxy(function(){P.prototype._adjustPositionAndArrow.apply(this);var $=this.$(),f=$.children(".sapMPopoverCont")[0].getBoundingClientRect().width;q.each($.find(".sapMActionSheet > .sapMBtn"),function(i,b){var d=q(b),B;d.css("width","");B=b.getBoundingClientRect().width;if(B<=f){d.css("width","100%");}});},this._parent);}}else{this._parent=new D({title:this.getTitle(),type:sap.m.DialogType.Standard,content:[this],beforeOpen:function(){t.fireBeforeOpen();},afterOpen:function(){t.focus();t.fireAfterOpen();},beforeClose:function(e){t.fireBeforeClose({origin:e.getParameter("origin")});},afterClose:function(e){t.fireAfterClose({origin:e.getParameter("origin")});sap.ui.Device.resize.detachHandler(t._fnOrientationChange);}}).addStyleClass("sapMActionSheetDialog");if(this.getTitle()){this._parent.addStyleClass("sapMActionSheetDialogWithTitle");}else{this._parent.addAriaLabelledBy(this.getPopupHiddenLabelId()||undefined);}if(!sap.ui.Device.system.phone){this._parent.setBeginButton(this._getCancelButton());}if(sap.ui.Device.system.phone){this._parent.oPopup.setModal(true);this._parent._setDimensions=function(){sap.m.Dialog.prototype._setDimensions.apply(this);this.$("cont").css("max-height","");};this._parent._adjustScrollingPane=function(){var h=this.$().height();this.$("cont").css("max-height",h);if(this._oScroller){this._oScroller.refresh();}};}}if(o){o.addDependent(this._parent);}}if(!sap.ui.Device.system.phone){this._parent.openBy(c);}else{this._parent.open();sap.ui.Device.resize.attachHandler(this._fnOrientationChange);}};
A.prototype.close=function(c){if(this._parent){this._parent.close();}};
A.prototype.isOpen=function(c){return!!this._parent&&this._parent.isOpen();};
A.prototype._createCancelButton=function(){if(!this._oCancelButton){var c=(this.getCancelButtonText())?this.getCancelButtonText():sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACTIONSHEET_CANCELBUTTON_TEXT"),t=this;this._oCancelButton=new sap.m.Button(this.getId()+'-cancelBtn',{text:c,type:sap.m.ButtonType.Reject,press:function(){if(sap.ui.Device.system.phone&&t._parent){t._parent._oCloseTrigger=this;}t.close();t.fireCancelButtonTap();t.fireCancelButtonPress();}}).addStyleClass("sapMActionSheetButton sapMActionSheetCancelButton sapMBtnTransparent sapMBtnInverted");if(sap.ui.Device.system.phone){this.setAggregation("_cancelButton",this._oCancelButton,true);}}return this;};
A.prototype._getCancelButton=function(){if(sap.ui.Device.system.phone&&this.getShowCancelButton()){this._createCancelButton();return this._oCancelButton;}return null;};
A.prototype.setCancelButtonText=function(t){this.setProperty("cancelButtonText",t,true);if(this._oCancelButton){this._oCancelButton.setText(t);}return this;};
A.prototype._preProcessActionButton=function(b){var t=b.getType();if(t!==sap.m.ButtonType.Accept&&t!==sap.m.ButtonType.Reject){b.setType(sap.m.ButtonType.Transparent);}b.addStyleClass("sapMBtnInverted");this._parent&&this._parent.invalidate();return this;};
A.prototype.setShowCancelButton=function(v){if(this._parent){if(sap.ui.Device.system.phone){this.setProperty("showCancelButton",v,false);}}else{this.setProperty("showCancelButton",v,true);}return this;};
A.prototype.setTitle=function(t){this.setProperty("title",t,true);if(this._parent&&sap.ui.Device.system.phone){this._parent.setTitle(t);this._parent.toggleStyleClass("sapMDialog-NoHeader",!t);}if(this._parent){if(t){this._parent.addStyleClass("sapMActionSheetDialogWithTitle");}else{this._parent.removeStyleClass("sapMActionSheetDialogWithTitle");}}return this;};
A.prototype.setPlacement=function(s){this.setProperty("placement",s,true);if(!sap.ui.Device.system.phone){if(this._parent){this._parent.setPlacement(s);}}return this;};
A.prototype._buttonSelected=function(){if(sap.ui.Device.system.phone&&this._parent){this._parent._oCloseTrigger=this;}this.close();};
A.prototype._orientationChange=function(){this._parent._adjustScrollingPane();};
A.prototype._addAriaHiddenTexts=function(b){var B=b.getId(),i;if(sap.ui.getCore().getConfiguration().getAccessibility()){i=new a(B+"-actionSheetHiddenText");this.addAggregation("_invisibleAriaTexts",i,false);b.addAriaLabelledBy(i.getId());}};
A.prototype._removeAriaHiddenTexts=function(b){b.getAriaLabelledBy().forEach(function(i){var c=sap.ui.getCore().byId(i);if(c instanceof a&&i.indexOf("actionSheetHiddenText")>-1){this.removeAggregation("_invisibleAriaTexts",c,false);b.removeAriaLabelledBy(c);c.destroy();}},this);};
A.prototype.addButton=function(b){this.addAggregation("buttons",b,false);this._addAriaHiddenTexts(b);this._preProcessActionButton(b);b.attachPress(this._buttonSelected,this);return this;};
A.prototype.insertButton=function(b,i){this.insertAggregation("buttons",b,i,false);this._addAriaHiddenTexts(b);this._preProcessActionButton(b);b.attachPress(this._buttonSelected,this);return this;};
A.prototype.removeButton=function(b){var r=this.removeAggregation("buttons",b,false);if(r){r.detachPress(this._buttonSelected,this);this._removeAriaHiddenTexts(r);}return r;};
A.prototype.removeAllButtons=function(){var r=this.removeAllAggregation("buttons",false),t=this;q.each(r,function(i,b){b.detachPress(t._buttonSelected,t);t._removeAriaHiddenTexts(b);});return r;};
A.prototype.clone=function(){var b=this.getButtons();for(var i=0;i<b.length;i++){b[i].detachPress(this._buttonSelected,this);}var c=C.prototype.clone.apply(this,arguments);for(var j=0;j<b.length;j++){b[j].attachPress(this._buttonSelected,this);}return c;};
A.prototype._getAllButtons=function(){return this.getButtons();};
A.prototype.getPopupHiddenLabelId=function(){if(!sap.ui.getCore().getConfiguration().getAccessibility()){return"";}var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");if(!p){p=new a({text:r.getText("ACTIONSHEET_AVAILABLE_ACTIONS")}).toStatic().getId();}return p;};
A.prototype._applyContextualSettings=function(){M.prototype._applyContextualSettings.call(this,M._defaultContextualSettings);};
return A;},true);
sap.ui.predefine('sap/m/ActionSheetRenderer',['jquery.sap.global'],function(q){"use strict";var A={};
A.render=function(r,c){var a=c._getAllButtons(),I=c.getAggregation("_invisibleAriaTexts"),R=sap.ui.getCore().getLibraryResourceBundle('sap.m'),b=a.length,d=sap.ui.getCore().getConfiguration().getAccessibility(),v=a.filter(function(B){return B.getVisible();}).length,C,i,m,B,V=1,g=function(o){return I.filter(function(e){return e.getId().indexOf(o.getId())>-1;})[0];};for(i=0;i<b;i++){B=a[i];B.removeStyleClass("sapMActionSheetButtonNoIcon");if(B.getIcon()&&B.getVisible()){m=true;}else{B.addStyleClass("sapMActionSheetButtonNoIcon");}}r.write("<div");r.writeControlData(c);r.addClass("sapMActionSheet");if(m){r.addClass("sapMActionSheetMixedButtons");}r.writeClasses();var t=c.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}d&&r.writeAttributeEscaped("role","presentation");r.write(">");for(i=0;i<b;i++){B=a[i];r.renderControl(a[i].addStyleClass("sapMActionSheetButton"));if(d&&B.getVisible()){C=g(B);if(C){C.setText(R.getText('ACTIONSHEET_BUTTON_INDEX',[V,v]));r.renderControl(C);}V++;}}if(sap.ui.Device.system.phone&&c.getShowCancelButton()){r.renderControl(c._getCancelButton());}r.write("</div>");};
return A;},true);
sap.ui.predefine('sap/m/App',['jquery.sap.global','./NavContainer','./library'],function(q,N,l){"use strict";
var A=N.extend("sap.m.App",{metadata:{library:"sap.m",properties:{homeIcon:{type:"any",group:"Misc",defaultValue:null},backgroundColor:{type:"string",group:"Appearance",defaultValue:null},backgroundImage:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},backgroundRepeat:{type:"boolean",group:"Appearance",defaultValue:false},backgroundOpacity:{type:"float",group:"Appearance",defaultValue:1}},events:{orientationChange:{deprecated:true,parameters:{landscape:{type:"boolean"}}}}}});
A.prototype.init=function(){N.prototype.init.apply(this,arguments);this.addStyleClass("sapMApp");q.sap.initMobile({viewport:!this._debugZoomAndScroll,statusBar:"default",hideBrowser:true,preventScroll:!this._debugZoomAndScroll,rootId:this.getId()});q(window).bind("resize",q.proxy(this._handleOrientationChange,this));};
A.prototype.onBeforeRendering=function(){if(N.prototype.onBeforeRendering){N.prototype.onBeforeRendering.apply(this,arguments);}q.sap.initMobile({homeIcon:this.getHomeIcon()});};
A.prototype.onAfterRendering=function(){if(N.prototype.onAfterRendering){N.prototype.onAfterRendering.apply(this,arguments);}var r=this.getDomRef().parentNode;while(r&&r!==document.documentElement){var $=q(r);if($.attr("data-sap-ui-root-content")){break;}if(!r.style.height){r.style.height="100%";}r=r.parentNode;}};
A.prototype.exit=function(){q(window).unbind("resize",this._handleOrientationChange);if(this._sInitTimer){q.sap.clearDelayedCall(this._sInitTimer);}};
A.prototype._handleOrientationChange=function(){var $=q(window);var i=$.width()>$.height();if(this._oldIsLandscape!==i){this.fireOrientationChange({landscape:i});this._oldIsLandscape=i;}};
A.prototype.setBackgroundOpacity=function(o){if(o>1||o<0){q.sap.log.warning("Invalid value "+o+" for App.setBackgroundOpacity() ignored. Valid values are: floats between 0 and 1.");return this;}this.$("BG").css("opacity",o);return this.setProperty("backgroundOpacity",o,true);};
return A;},true);
sap.ui.predefine('sap/m/AppRenderer',['jquery.sap.global','./NavContainerRenderer','sap/ui/core/Renderer'],function(q,N,R){"use strict";var A={};var A=R.extend(N);
A.renderAttributes=function(r,c){sap.m.BackgroundHelper.addBackgroundColorStyles(r,c.getBackgroundColor(),c.getBackgroundImage());};
A.renderBeforeContent=function(r,c){sap.m.BackgroundHelper.renderBackgroundImageTag(r,c,"sapMAppBG",c.getBackgroundImage(),c.getBackgroundRepeat(),c.getBackgroundOpacity());};
return A;},true);
sap.ui.predefine('sap/m/AssociativeOverflowToolbar',['./OverflowToolbar','./OverflowToolbarRenderer','./Toolbar'],function(O,a,T){"use strict";
var A=O.extend("sap.m.AssociativeOverflowToolbar",{
metadata:{associations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}}},
renderer:a
});
A.prototype.getContent=function(){var b=this.getAssociation("content")||[];return b.map(function(c){return sap.ui.getCore().byId(c);});};
A.prototype.exit=function(){O.prototype.exit.apply(this,arguments);return this._callToolbarMethod('destroyContent',[true]);};
A.prototype.indexOfContent=function(c){var b=this.getAssociation("content")||[];return b.indexOf(c.getId());};
A.prototype._callToolbarMethod=function(f,b){switch(f){case'addContent':return this.addAssociation("content",b[0]);case'getContent':return this.getContent();case'insertContent':return this.addAssociation("content",b[0],b[3]);case'removeContent':return sap.ui.getCore().byId(this.removeAssociation("content",b[0],b[1],b[2]))||null;case'destroyContent':var c=this.removeAllAssociation("content",b[0]).map(function(d){return sap.ui.getCore().byId(d);});c.forEach(function(d){if(d){d.destroy();}});return this;case'removeAllContent':return this.removeAllAssociation("content",b[0]).map(function(d){return sap.ui.getCore().byId(d);});default:return T.prototype[f].apply(this,b);}};
return A;},false);
sap.ui.predefine('sap/m/Bar.designtime',[],function(){"use strict";return{aggregations:{contentLeft:{domRef:":sap-domref > .sapMBarLeft",actions:{move:"moveControls"}},contentMiddle:{domRef:":sap-domref > .sapMBarMiddle > .sapMBarPH",actions:{move:"moveControls"}},contentRight:{domRef:":sap-domref > .sapMBarRight",actions:{move:"moveControls"}}}};},false);
sap.ui.predefine('sap/m/Bar',['jquery.sap.global','./BarInPageEnabler','./library','sap/ui/core/Control'],function(q,B,l,C){"use strict";
var a=C.extend("sap.m.Bar",{metadata:{interfaces:["sap.m.IBar"],library:"sap.m",properties:{enableFlexBox:{type:"boolean",group:"Misc",defaultValue:false,deprecated:true},translucent:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},design:{type:"sap.m.BarDesign",group:"Appearance",defaultValue:sap.m.BarDesign.Auto}},aggregations:{contentLeft:{type:"sap.ui.core.Control",multiple:true,singularName:"contentLeft"},contentMiddle:{type:"sap.ui.core.Control",multiple:true,singularName:"contentMiddle"},contentRight:{type:"sap.ui.core.Control",multiple:true,singularName:"contentRight"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},designTime:true}});
a.prototype.onBeforeRendering=function(){this._removeAllListeners();};
a.prototype.onAfterRendering=function(){this._handleResize();};
a.prototype.init=function(){this.data("sap-ui-fastnavgroup","true",true);};
a.prototype.exit=function(){this._removeAllListeners();if(this._oflexBox){this._oflexBox.destroy();this._oflexBox=null;}this._$MidBarPlaceHolder=null;this._$RightBar=null;this._$LeftBar=null;};
a._aResizeHandlers=["_sResizeListenerId","_sResizeListenerIdMid","_sResizeListenerIdRight","_sResizeListenerIdLeft"];
a.prototype._removeAllListeners=function(){var t=this;a._aResizeHandlers.forEach(function(i){t._removeListenerFailsave(i);});};
a.prototype._removeListenerFailsave=function(L){if(this[L]){sap.ui.core.ResizeHandler.deregister(this[L]);this[L]=null;}};
a.prototype._handleResize=function(){this._removeAllListeners();var c=!!this.getContentLeft().length,d=!!this.getContentMiddle().length,e=!!this.getContentRight().length;if(!this.getVisible()){return;}if(!c&&!d&&!e){return;}this._$LeftBar=this.$("BarLeft");this._$RightBar=this.$("BarRight");this._$MidBarPlaceHolder=this.$("BarPH");this._updatePosition(c,d,e);this._sResizeListenerId=sap.ui.core.ResizeHandler.register(this.getDomRef(),q.proxy(this._handleResize,this));if(this.getEnableFlexBox()){return;}if(c){this._sResizeListenerIdLeft=sap.ui.core.ResizeHandler.register(this._$LeftBar[0],q.proxy(this._handleResize,this));}if(d){this._sResizeListenerIdMid=sap.ui.core.ResizeHandler.register(this._$MidBarPlaceHolder[0],q.proxy(this._handleResize,this));}if(e){this._sResizeListenerIdRight=sap.ui.core.ResizeHandler.register(this._$RightBar[0],q.proxy(this._handleResize,this));}};
a.prototype._updatePosition=function(c,d,e){if(!c&&!e&&d){return;}if(c&&!d&&!e){return;}if(!c&&!d&&e){return;}var i=this.$().outerWidth(true);this._$RightBar.css({width:""});this._$LeftBar.css({width:""});this._$MidBarPlaceHolder.css({position:"",width:"",visibility:'hidden'});var r=this._$RightBar.outerWidth(true);if(r>i){if(c){this._$LeftBar.css({width:"0px"});}if(d){this._$MidBarPlaceHolder.css({width:"0px"});}this._$RightBar.css({width:i+"px"});return;}var L=this._getBarContainerWidth(this._$LeftBar);if(i<(L+r)){L=i-r;this._$LeftBar.css({width:L+"px"});this._$MidBarPlaceHolder.css({width:"0px"});return;}this._$MidBarPlaceHolder.css(this._getMidBarCss(r,i,L));};
a.prototype._getMidBarCss=function(r,i,L){var m=this._$MidBarPlaceHolder.outerWidth(true),R=sap.ui.getCore().getConfiguration().getRTL(),s=R?"right":"left",M={visibility:""};if(this.getEnableFlexBox()){m=i-L-r-parseInt(this._$MidBarPlaceHolder.css('margin-left'),10)-parseInt(this._$MidBarPlaceHolder.css('margin-right'),10);M.position="absolute";M.width=m+"px";M[s]=L;return M;}var S=i-L-r,c=(i/2)-(m/2),d=L>c,e=(i/2)+(m/2),f=(i-r)<e;if(S>0&&(d||f)){M.position="absolute";M.width=S+"px";M.left=R?r:L;}return M;};
a.prototype._getBarContainerWidth=function(c){var i,d=0,e=c.children(),f=0;if(sap.ui.Device.browser.webkit||sap.ui.Device.browser.firefox||sap.ui.Device.browser.edge){for(i=0;i<e.length;i++){f+=q(e[i]).outerWidth(true);}d=c.outerWidth(true);}else{var o;for(i=0;i<e.length;i++){o=window.getComputedStyle(e[i]);if(o.width=="auto"){f+=q(e[i]).width()+1;}else{f+=parseFloat(o.width);}f+=parseFloat(o.marginLeft);f+=parseFloat(o.marginRight);f+=parseFloat(o.paddingLeft);f+=parseFloat(o.paddingRight);}var g=window.getComputedStyle(c[0]);d+=parseFloat(g.width);d+=parseFloat(g.marginLeft);d+=parseFloat(g.marginRight);d+=parseFloat(g.paddingLeft);d+=parseFloat(g.paddingRight);}if(d<f){d=f;}return d;};
var b=B.extend("sap.m.BarInAnyContentEnabler",{});
b.mContexts={dialogFooter:{contextClass:"sapMFooter-CTX",tag:"Footer",internalAriaLabel:"BAR_ARIA_DESCRIPTION_FOOTER"}};
b.prototype.getContext=function(){var p=B.prototype.getContext.call();for(var k in b.mContexts){p[k]=b.mContexts[k];}return p;};
a.prototype.getContext=b.prototype.getContext;a.prototype.isContextSensitive=b.prototype.isContextSensitive;a.prototype.setHTMLTag=b.prototype.setHTMLTag;a.prototype.getHTMLTag=b.prototype.getHTMLTag;a.prototype.applyTagAndContextClassFor=b.prototype.applyTagAndContextClassFor;a.prototype._applyContextClassFor=b.prototype._applyContextClassFor;a.prototype._applyTag=b.prototype._applyTag;a.prototype._getContextOptions=b.prototype._getContextOptions;a.prototype._setRootAccessibilityRole=b.prototype._setRootAccessibilityRole;a.prototype._getRootAccessibilityRole=b.prototype._getRootAccessibilityRole;return a;},true);
sap.ui.predefine('sap/m/BarInPageEnabler',['sap/ui/base/Object','./PageAccessibleLandmarkInfo','sap/ui/core/InvisibleText'],function(O,P,I){"use strict";var c={footer:{contextClass:"sapMFooter-CTX sapContrast sapContrastPlus",tag:"Footer",internalAriaLabel:"BAR_ARIA_DESCRIPTION_FOOTER"},header:{contextClass:"sapMHeader-CTX",tag:"Header",internalAriaLabel:"BAR_ARIA_DESCRIPTION_HEADER"},subheader:{contextClass:"sapMSubHeader-CTX",tag:"Header",internalAriaLabel:"BAR_ARIA_DESCRIPTION_SUBHEADER"}};var a="sapMIBar";var _={},b=sap.ui.getCore().getLibraryResourceBundle("sap.m");var d=function(t,T){if(typeof _[t]==="undefined"){_[t]=new I({text:T}).toStatic().getId();}return _[t];};
var B=O.extend("sap.m.BarInPageEnabler",{
isContextSensitive:function(){return this.getDesign&&this.getDesign()==="Auto";},
setHTMLTag:function(n){if(n===this.sTag){return this;}this.sTag=n;return this;},
getHTMLTag:function(){if(!this.hasOwnProperty("sTag")){this.sTag=sap.m.IBarHTMLTag.Div;}return this.sTag;},
getContext:function(){return c;},
_getRootAccessibilityRole:function(){var r=this._sRootAccessibilityRole||"toolbar";return r;},
_setRootAccessibilityRole:function(r){this._sRootAccessibilityRole=r;return this;},
applyTagAndContextClassFor:function(C){this._applyTag(C);return this._applyContextClassFor(C);},
_applyContextClassFor:function(C){var o=this._getContextOptions(C);if(!o){return this;}if(!this.isContextSensitive){jQuery.sap.log.error("The bar control you are using does not implement all the members of the IBar interface",this);return this;}if(!this.getRenderer().shouldAddIBarContext()){this.addStyleClass(a+"-CTX");}if(o.internalAriaLabel){this._sInternalAriaLabelId=d(o.tag,b.getText(o.internalAriaLabel));}if(this.isContextSensitive()){this.addStyleClass(o.contextClass);}return this;},
_applyTag:function(C){var o=this._getContextOptions(C);if(!o){return this;}if(!this.setHTMLTag){jQuery.sap.log.error("The bar control you are using does not implement all the members of the IBar interface",this);return this;}this.setHTMLTag(o.tag);return this;},
_getContextOptions:function(C){var o;if(this.getContext){o=this.getContext();}else{o=c;}var e=o[C];if(!e){jQuery.sap.log.error("The context "+C+" is not known",this);return null;}return e;},
render:function(r,C){var t=C.getHTMLTag().toLowerCase();r.write("<"+t);r.addClass(a);if(C._sInternalAriaLabelId){r.writeAccessibilityState(C,{"labelledby":{value:C._sInternalAriaLabelId,append:true}});}if(this.shouldAddIBarContext(C)){r.addClass(a+"-CTX");}r.writeControlData(C);B.renderTooltip(r,C);this.decorateRootElement(r,C);r.writeClasses();r.writeStyles();r.write(">");this.renderBarContent(r,C);r.write("</"+t+">");}
});
B.renderTooltip=function(r,C){var t=C.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}};
B.addChildClassTo=function(C){C.addStyleClass("sapMBarChild");};
B.prototype.exit=function(){if(this._sInternalAriaLabelId){this._sInternalAriaLabelId.destroy();this._sInternalAriaLabelId=null;}};
return B;},true);
sap.ui.predefine('sap/m/BarRenderer',['jquery.sap.global','./BarInPageEnabler'],function(q,B){"use strict";var a={};a.render=B.prototype.render;
a.decorateRootElement=function(r,c){r.addClass("sapMBar");r.addClass(this.getContext(c));r.writeAccessibilityState(c,{"role":c._getRootAccessibilityRole()});if(c.getTranslucent()&&(sap.ui.Device.support.touch||q.sap.simulateMobileOnDesktop)){r.addClass("sapMBarTranslucent");}r.addClass("sapMBar-CTX");};
a.shouldAddIBarContext=function(){return true;};
a.renderBarContent=function(r,c){var C="</div>";r.write("<div id='"+c.getId()+"-BarLeft' ");r.addClass('sapMBarLeft');r.addClass('sapMBarContainer');r.writeClasses();w("left",r,c);r.write(">");this.renderAllControls(c.getContentLeft(),r,c);r.write(C);r.write("<div id='"+c.getId()+"-BarMiddle' ");r.addClass('sapMBarMiddle');r.writeClasses();r.write(">");if(c.getEnableFlexBox()){c._oflexBox=c._oflexBox||new sap.m.HBox(c.getId()+"-BarPH",{alignItems:"Center"}).addStyleClass("sapMBarPH").setParent(c,null,true);var b=!!c.getContentLeft().length,d=!!c.getContentMiddle().length,e=!!c.getContentRight().length;if(d&&!b&&!e){c._oflexBox.addStyleClass("sapMBarFlexBoxWidth100");}c.getContentMiddle().forEach(function(m){c._oflexBox.addItem(m);});r.renderControl(c._oflexBox);}else{r.write("<div id='"+c.getId()+"-BarPH' ");r.addClass('sapMBarPH');r.addClass('sapMBarContainer');w("middle",r,c);r.writeClasses();r.write(">");this.renderAllControls(c.getContentMiddle(),r,c);r.write(C);}r.write(C);r.write("<div id='"+c.getId()+"-BarRight'");r.addClass('sapMBarRight');r.addClass('sapMBarContainer');if(sap.ui.getCore().getConfiguration().getRTL()){r.addClass("sapMRTL");}r.writeClasses();w("right",r,c);r.write(">");this.renderAllControls(c.getContentRight(),r,c);r.write(C);};
a.renderAllControls=function(c,r,b){c.forEach(function(C){sap.m.BarInPageEnabler.addChildClassTo(C,b);r.renderControl(C);});};
a._mContexts={Header:"sapMHeader-CTX",SubHeader:"sapMSubHeader-CTX",Footer:"sapMFooter-CTX",Default:"sapMContent-CTX"};
a.getContext=function(c){var d=c.getDesign(),C=a._mContexts;return C[d]||C.Default;};
function w(A,r,c){var C=!!c.getContentLeft().length,b=!!c.getContentMiddle().length,d=!!c.getContentRight().length;function e(){r.addStyle("width","100%");r.writeStyles();}switch(A.toLowerCase()){case"left":if(C&&!b&&!d){e();}break;case"middle":if(b&&!C&&!d){e();}break;case"right":if(d&&!C&&!b){e();}break;default:q.sap.log.error("Cannot determine which of the three content aggregations is alone");}}
return a;},true);
sap.ui.predefine('sap/m/Breadcrumbs',["sap/ui/core/Control","sap/m/Text","sap/m/Link","sap/m/Select","sap/ui/core/Item","sap/ui/core/delegate/ItemNavigation","sap/ui/core/ResizeHandler","sap/ui/core/IconPool","sap/ui/Device"],function(C,T,L,S,I,a,R,b,D){"use strict";
var B=C.extend("sap.m.Breadcrumbs",{metadata:{library:"sap.m",properties:{currentLocationText:{type:"string",group:"Behavior",defaultValue:null}},aggregations:{links:{type:"sap.m.Link",multiple:true,singularName:"link"},_currentLocation:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_select:{type:"sap.m.Select",multiple:false,visibility:"hidden"}},defaultAggregation:"links"}});
B.prototype.onBeforeRendering=function(){this.bRenderingPhase=true;if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}if(this._bControlsInfoCached){this._updateSelect(true);}};
B.prototype.onAfterRendering=function(){if(!this._sResizeListenerId){this._sResizeListenerId=R.register(this,this._handleScreenResize.bind(this));}if(!this._bControlsInfoCached){this._updateSelect(true);return;}this._configureKeyboardHandling();this.bRenderingPhase=false;};
B.prototype.onThemeChanged=function(){this._resetControl();};
B.prototype.exit=function(){this._resetControl();this._destroyItemNavigation();};
B.PAGEUP_AND_PAGEDOWN_JUMP_SIZE=5;
B._getResourceBundle=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.m");};
B.prototype._getAugmentedId=function(s){return this.getId()+"-"+s;};
B.prototype._getSelect=function(){if(!this.getAggregation("_select")){this.setAggregation("_select",this._decorateSelect(new S({id:this._getAugmentedId("select"),change:this._selectChangeHandler.bind(this),forceSelection:false,autoAdjustWidth:true,icon:b.getIconURI("slim-arrow-down"),type:sap.m.SelectType.IconOnly,tooltip:B._getResourceBundle().getText("BREADCRUMB_SELECT_TOOLTIP")})));}return this.getAggregation("_select");};
B.prototype._getCurrentLocation=function(){if(!this.getAggregation("_currentLocation")){this.setAggregation("_currentLocation",new T({id:this._getAugmentedId("currentText"),text:this.getCurrentLocationText(),wrapping:false}).addStyleClass("sapMBreadcrumbsCurrentLocation"));}return this.getAggregation("_currentLocation");};
function c(A,d){var e=Array.prototype.slice.apply(d);e.unshift(A);return e;}
B.prototype.insertLink=function(l,i){var r=this.insertAggregation.apply(this,c("links",arguments));this._registerControlListener(l);this._resetControl();return r;};
B.prototype.addLink=function(l){var r=this.addAggregation.apply(this,c("links",arguments));this._registerControlListener(l);this._resetControl();return r;};
B.prototype.removeLink=function(o){var r=this.removeAggregation.apply(this,c("links",arguments));this._deregisterControlListener(r);this._resetControl();return r;};
B.prototype.removeAllLinks=function(){var l=this.getAggregation("links",[]);var r=this.removeAllAggregation.apply(this,c("links",arguments));l.forEach(this._deregisterControlListener,this);this._resetControl();return r;};
B.prototype.destroyLinks=function(){var l=this.getAggregation("links",[]);var r=this.destroyAggregation.apply(this,c("links",arguments));l.forEach(this._deregisterControlListener,this);this._resetControl();return r;};
B.prototype._decorateSelect=function(s){s.getPicker().attachAfterOpen(this._removeItemNavigation,this).attachBeforeClose(this._restoreItemNavigation,this);s._onBeforeOpenDialog=this._onSelectBeforeOpenDialog.bind(this);s._onBeforeOpenPopover=this._onSelectBeforeOpenPopover.bind(this);s.onsapescape=this._onSelectEscPress.bind(this);return s;};
B.prototype._removeItemNavigation=function(){this.removeDelegate(this._getItemNavigation());};
B.prototype._onSelectBeforeOpenDialog=function(){var s=this._getSelect();if(this.getCurrentLocationText()&&D.system.phone){s.setSelectedIndex(0);}else{s.setSelectedItem(null);}S.prototype._onBeforeOpenDialog.call(s);this._removeItemNavigation();};
B.prototype._onSelectBeforeOpenPopover=function(){this._getSelect().setSelectedItem(null);this._removeItemNavigation();};
B.prototype._restoreItemNavigation=function(){this.addDelegate(this._getItemNavigation());};
B.prototype._onSelectEscPress=function(){this._getSelect().close();};
B.prototype._createSelectItem=function(i){return new I({key:i.getId(),text:i.getText()});};
B.prototype._selectChangeHandler=function(e){var l,s,d,o=e.getParameter("selectedItem");if(!o){return;}if(!this._getSelect().isOpen()){return;}l=sap.ui.getCore().byId(o.getKey());if(!(l instanceof L)){return;}s=l.getHref();d=l.getTarget();l.firePress();if(s){if(d){window.open(s,d);}else{window.location.href=s;}}};
B.prototype._getItemsForMobile=function(){var i=this.getLinks();if(this.getCurrentLocationText()){i.push(this._getCurrentLocation());}return i;};
B.prototype._updateSelect=function(i){var s=this._getSelect(),d,o=this._getControlDistribution();if(!this._bControlDistributionCached||i){s.destroyItems();d=D.system.phone?this._getItemsForMobile():o.aControlsForSelect;d.map(this._createSelectItem).reverse().forEach(s.insertItem,s);this._bControlDistributionCached=true;this.invalidate(this);}s.setVisible(!!o.aControlsForSelect.length);if(!this._sResizeListenerId&&!this.bRenderingPhase){this._sResizeListenerId=R.register(this,this._handleScreenResize.bind(this));}};
B.prototype._getControlsForBreadcrumbTrail=function(){var v;if(this._bControlDistributionCached&&this._oDistributedControls){return this._oDistributedControls.aControlsForBreadcrumbTrail;}v=this.getLinks().filter(function(l){return l.getVisible();});if(this.getCurrentLocationText()){return v.concat([this._getCurrentLocation()]);}return v;};
B.prototype._getControlInfo=function(o){return{id:o.getId(),control:o,width:o.$().parent().outerWidth(true),bCanOverflow:o instanceof L};};
B.prototype._getControlDistribution=function(m){m=m||this._iContainerSize;this._iContainerSize=m;this._oDistributedControls=this._determineControlDistribution(m);return this._oDistributedControls;};
B.prototype._determineControlDistribution=function(m){var i,o,d=this._getControlsInfo().aControlInfo,s=this._iSelectWidth,e=[],f=[],u=s;for(i=d.length-1;i>=0;i--){o=d[i];u+=o.width;if(d.length-1===i){f.push(o.control);continue;}if(i===0){u-=s;}if(u>m&&o.bCanOverflow){e.unshift(o.control);}else{f.unshift(o.control);}}return{aControlsForBreadcrumbTrail:f,aControlsForSelect:e};};
B.prototype._getControlsInfo=function(){if(!this._bControlsInfoCached){this._iSelectWidth=this._getSelect().$().parent().outerWidth(true)||0;this._aControlInfo=this._getControlsForBreadcrumbTrail().map(this._getControlInfo);this._iContainerSize=this.$().outerWidth(true);this._bControlsInfoCached=true;}return{aControlInfo:this._aControlInfo,iSelectWidth:this._iSelectWidth,iContentSize:this._iContainerSize};};
B.prototype._handleScreenResize=function(e){var i=this._oDistributedControls.aControlsForBreadcrumbTrail.length,o=this._getControlDistribution(e.size.width),d=o.aControlsForBreadcrumbTrail.length;if(i!==d){this._updateSelect(true);}return this;};
B.prototype._getItemsToNavigate=function(){var i=this._getControlsForBreadcrumbTrail().slice(),s=this._getSelect();if(s.getVisible()){i.unshift(s);}return i;};
B.prototype._getItemNavigation=function(){if(!this._itemNavigation){this._itemNavigation=new a();}return this._itemNavigation;};
B.prototype._destroyItemNavigation=function(){if(this._itemNavigation){this.removeEventDelegate(this._itemNavigation);this._itemNavigation.destroy();this._itemNavigation=null;}};
B.prototype._configureKeyboardHandling=function(){var i=this._getItemNavigation(),s=-1,d=this._getItemsToNavigate(),n=[];d.forEach(function(o,e){if(e===0){o.$().attr("tabIndex","0");}o.$().attr("tabIndex","-1");n.push(o.getDomRef());});this.addDelegate(i);i.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"],saphome:["alt"],sapend:["alt"]});i.setCycling(false);i.setPageSize(B.PAGEUP_AND_PAGEDOWN_JUMP_SIZE);i.setRootDomRef(this.getDomRef());i.setItemDomRefs(n);i.setSelectedIndex(s);return this;};
B.prototype._registerControlListener=function(o){if(o){o.attachEvent("_change",this._resetControl,this);}};
B.prototype._deregisterControlListener=function(o){if(o){o.detachEvent("_change",this._resetControl,this);}};
B.prototype.setCurrentLocationText=function(t){var o=this._getCurrentLocation(),r=this.setProperty("currentLocationText",t,true);if(o.getText()!==t){o.setText(t);this._resetControl();}return r;};
B.prototype._resetControl=function(){this._aControlInfo=null;this._iContainerSize=null;this._bControlsInfoCached=null;this._bControlDistributionCached=null;this._oDistributedControls=null;if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}this.removeDelegate(this._getItemNavigation());this.invalidate(this);return this;};
return B;},true);
sap.ui.predefine('sap/m/BreadcrumbsRenderer',["sap/m/Breadcrumbs","sap/m/Text"],function(C,T){"use strict";var B={};
B.render=function(r,c){var a=c._getControlsForBreadcrumbTrail(),s=c._getSelect();r.write("<ul");r.writeControlData(c);r.addClass("sapMBreadcrumbs");r.writeClasses();r.writeAttribute("role","navigation");r.writeAttributeEscaped("aria-label",C._getResourceBundle().getText("BREADCRUMB_LABEL"));r.write(">");if(s.getVisible()){this._renderControlInListItem(r,s,false,"sapMBreadcrumbsSelectItem");}a.forEach(function(o){this._renderControlInListItem(r,o,o instanceof T);},this);r.write("</ul>");};
B._renderControlInListItem=function(r,c,s,a){r.write("<li");r.writeAttribute("role","presentation");r.writeAttribute("aria-hidden","true");r.addClass("sapMBreadcrumbsItem");r.addClass(a);r.writeClasses();r.write(">");r.renderControl(c);if(!s){r.write("<span");r.addClass("sapMBreadcrumbsSeparator");r.writeClasses();r.write(">/</span>");}r.write("</li>");};
return B;},true);
sap.ui.predefine('sap/m/BusyDialog',['jquery.sap.global','./library','sap/ui/core/Control','sap/m/Dialog','sap/m/BusyIndicator','sap/m/Label','sap/m/Button'],function(q,l,C,D,B,L,a,P,b){"use strict";
var c=C.extend("sap.m.BusyDialog",{
metadata:{library:"sap.m",properties:{text:{type:"string",group:"Appearance",defaultValue:''},title:{type:"string",group:"Appearance",defaultValue:''},customIcon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:''},customIconRotationSpeed:{type:"int",group:"Appearance",defaultValue:1000},customIconDensityAware:{type:"boolean",defaultValue:true},customIconWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"44px"},customIconHeight:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"44px"},cancelButtonText:{type:"string",group:"Misc",defaultValue:''},showCancelButton:{type:"boolean",group:"Appearance",defaultValue:false}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{close:{parameters:{cancelPressed:{type:"boolean"}}}}},
renderer:function(r,o){}
});
c.prototype.init=function(){this._busyIndicator=new B(this.getId()+'-busyInd',{visible:true});function o(){if(sap.ui.getCore().getConfiguration().getAccessibility()){this._$content.attr('role','application');}}this._oDialog=new D(this.getId()+'-Dialog',{content:this._busyIndicator,showHeader:false,afterOpen:o,initialFocus:this._busyIndicator}).addStyleClass('sapMBusyDialog');this._oDialog.close=function(){};this._oDialog.addEventDelegate({onBeforeRendering:function(){var t=this.getText();var d=this.getTitle();var s=this.getShowCancelButton()||this.getCancelButtonText();if(!t&&!d&&!s){this._oDialog.addStyleClass('sapMBusyDialog-Light');}else{this._oDialog.removeStyleClass('sapMBusyDialog-Light');}}},this);this._oDialog.oPopup.onsapescape=function(e){this.close(true);}.bind(this);};
c.prototype.exit=function(){this._busyIndicator.destroy();this._busyIndicator=null;if(this._cancelButton){this._cancelButton.destroy();this._cancelButton=null;}if(this._oLabel){this._oLabel.destroy();this._oLabel=null;}if(this._oDialog){this._oDialog.destroy();this._oDialog=null;}};
c.prototype.open=function(){q.sap.log.debug("sap.m.BusyDialog.open called at "+new Date().getTime());if(this.getAriaLabelledBy()&&!this._oDialog._$dialog){var t=this;this.getAriaLabelledBy().forEach(function(i){t._oDialog.addAriaLabelledBy(i);});}if(!document.body||!sap.ui.getCore().isInitialized()){setTimeout(function(){this.open();}.bind(this),50);}else{this._oDialog.open();}return this;};
c.prototype.close=function(i){this.fireClose({cancelPressed:i||false});D.prototype.close.call(this._oDialog);return this;};
c.prototype.setTitle=function(t){this.setProperty('title',t,true);this._oDialog.setTitle(t).setShowHeader(!!t);return this;};
c.prototype.setTooltip=function(t){this._oDialog.setTooltip(t);return this;};
c.prototype.getTooltip=function(){this._oDialog.getTooltip();return this;};
c.prototype.setText=function(t){this.setProperty('text',t,true);if(!this._oLabel){if(t){this._oLabel=new L(this.getId()+'-TextLabel',{text:t}).addStyleClass('sapMBusyDialogLabel');this._oDialog.insertAggregation('content',this._oLabel,0);this._oDialog.addAriaLabelledBy(this._oLabel.getId());}}else{if(t){this._oLabel.setText(t).setVisible(true);}else{this._oLabel.setVisible(false);}}return this;};
c.prototype.setCustomIcon=function(i){this.setProperty("customIcon",i,true);this._busyIndicator.setCustomIcon(i);return this;};
c.prototype.setCustomIconRotationSpeed=function(s){this.setProperty("customIconRotationSpeed",s,true);this._busyIndicator.setCustomIconRotationSpeed(s);return this;};
c.prototype.setCustomIconDensityAware=function(i){this.setProperty("customIconDensityAware",i,true);this._busyIndicator.setCustomIconDensityAware(i);return this;};
c.prototype.setCustomIconWidth=function(w){this.setProperty("customIconWidth",w,true);this._busyIndicator.setCustomIconWidth(w);return this;};
c.prototype.setCustomIconHeight=function(h){this.setProperty("customIconHeight",h,true);this._busyIndicator.setCustomIconHeight(h);return this;};
c.prototype.setShowCancelButton=function(i){this.setProperty("showCancelButton",i,false);if(i){this._oDialog.setEndButton(this._getCancelButton());}else{this._destroyTheCancelButton();}return this;};
c.prototype.setCancelButtonText=function(t){this.setProperty("cancelButtonText",t,false);if(t){this._getCancelButton().setText(t);this._oDialog.setEndButton(this._getCancelButton());}else{this._destroyTheCancelButton();}return this;};
c.prototype.getDomRef=function(){return this._oDialog&&this._oDialog.getDomRef();};
c.prototype._destroyTheCancelButton=function(){this._oDialog.destroyEndButton();this._cancelButton=null;};
c.prototype._getCancelButton=function(){var d=this.getCancelButtonText();d=d?d:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("BUSYDIALOG_CANCELBUTTON_TEXT");return this._cancelButton?this._cancelButton:this._cancelButton=new a(this.getId()+'busyCancelBtn',{text:d,press:function(){this.close(true);}.bind(this)});};
return c;},true);
sap.ui.predefine('sap/m/BusyIndicator',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/theming/Parameters'],function(q,l,C,P){"use strict";
var B=C.extend("sap.m.BusyIndicator",{metadata:{library:"sap.m",properties:{text:{type:"string",group:"Data",defaultValue:""},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit},customIcon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:""},customIconRotationSpeed:{type:"int",group:"Appearance",defaultValue:1000},customIconDensityAware:{type:"boolean",defaultValue:true},customIconWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"44px"},customIconHeight:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"44px"},size:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:"1rem"},design:{type:"string",group:"Appearance",defaultValue:"auto"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}}}});
B.prototype.init=function(){this.setBusyIndicatorDelay(0);};
B.prototype.setText=function(t){this.setProperty("text",t,true);this._createLabel("setText",t);return this;};
B.prototype.setTextDirection=function(d){this.setProperty("textDirection",d,true);this._createLabel("setTextDirection",d);return this;};
B.prototype.setCustomIcon=function(s){this.setProperty("customIcon",s,false);this._createCustomIcon("setSrc",s);return this;};
B.prototype.setCustomIconRotationSpeed=function(s){if(isNaN(s)||s<0){s=0;}if(s!==this.getCustomIconRotationSpeed()){this.setProperty("customIconRotationSpeed",s,true);this._setRotationSpeed();}return this;};
B.prototype.setCustomIconDensityAware=function(a){this.setProperty("customIconDensityAware",a,true);this._createCustomIcon("setDensityAware",a);return this;};
B.prototype.setCustomIconWidth=function(w){this.setProperty("customIconWidth",w,true);this._createCustomIcon("setWidth",w);return this;};
B.prototype.setCustomIconHeight=function(h){this.setProperty("customIconHeight",h,true);this._createCustomIcon("setHeight",h);return this;};
B.prototype.setSize=function(s){this.setProperty("size",s,true);var d=this.getDomRef();if(d){d.style.fontSize=s;}return this;};
B.prototype.onBeforeRendering=function(){if(this.getCustomIcon()){this.setBusy(false);}else{this.setBusy(true,"busy-area");}};
B.prototype.exit=function(){if(this._iconImage){this._iconImage.destroy();this._iconImage=null;}if(this._busyLabel){this._busyLabel.destroy();this._busyLabel=null;}};
B.prototype._createCustomIcon=function(n,v){if(!this._iconImage){this._iconImage=new sap.m.Image(this.getId()+"-icon",{width:"44px",height:"44px"}).addStyleClass("sapMBsyIndIcon");this._iconImage.addEventDelegate({onAfterRendering:function(){this._setRotationSpeed();}},this);}this._iconImage[n](v);this._setRotationSpeed();};
B.prototype._createLabel=function(n,v){if(!this._busyLabel){this._busyLabel=new sap.m.Label(this.getId()+"-label",{labelFor:this.getId(),textAlign:"Center"});}this._busyLabel[n](v);};
B.prototype._setRotationSpeed=function(){if(!this._iconImage){return;}if(q.support.cssAnimations){var $=this._iconImage.$();var r=this.getCustomIconRotationSpeed()+"ms";$.css("-webkit-animation-duration",r).css("animation-duration",r);$.css("display","none");setTimeout(function(){$.css("display","inline");},0);}else{this._rotateCustomIcon();}};
B.prototype._rotateCustomIcon=function(){if(!this._iconImage){return;}var $=this._iconImage.$();if(!$[0]||!$[0].offsetWidth){return;}var r=this.getCustomIconRotationSpeed();if(!r){return;}if(!this._fnRotateCustomIcon){this._fnRotateCustomIcon=q.proxy(this._rotateCustomIcon,this);}var R=this._fnRotateCustomIcon;if(!this._$CustomRotator){this._$CustomRotator=q({deg:0});}var a=this._$CustomRotator;if(a.running){return;}a[0].deg=0;a.animate({deg:360},{duration:r,easing:"linear",step:function(n){a.running=true;$.css("-ms-transform",'rotate('+n+'deg)');},complete:function(){a.running=false;window.setTimeout(R,10);}});};
return B;},true);
sap.ui.predefine('sap/m/BusyIndicatorRenderer',['jquery.sap.global'],function(q){"use strict";var B={};
B.render=function(r,b){this.startBusyIndicator(r,b);this.renderBusyIndication(r,b);this.renderLabel(r,b);this.endBusyIndicator(r);};
B.startBusyIndicator=function(r,b){var a={role:"progressbar",valuemin:"0",valuemax:"100"};r.write("<div tabindex='0' ");r.writeControlData(b);r.addClass("sapMBusyIndicator");r.writeClasses();r.addStyle("font-size",b.getSize());r.writeStyles();r.writeAccessibilityState(b,a);this.renderTooltip(r,b.getTooltip_AsString());r.write(">");};
B.renderTooltip=function(r,t){if(t){r.writeAttributeEscaped("title",t);}};
B.renderBusyIndication=function(r,b){if(b.getCustomIcon()){r.renderControl(b._iconImage);}else{r.write("<div class='sapMBusyIndicatorBusyArea'");r.writeAttribute("id",b.getId()+"-busy-area");r.write("></div>");}};
B.renderLabel=function(r,b){if(b.getText()){r.renderControl(b._busyLabel);}};
B.endBusyIndicator=function(r){r.write("</div>");};
return B;},true);
sap.ui.predefine('sap/m/Button.designtime',[],function(){"use strict";return{actions:{combine:{changeType:"combineButtons",changeOnRelevantContainer:true,isEnabled:true}}};},false);
sap.ui.predefine('sap/m/Button',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/EnabledPropagator','sap/ui/core/IconPool','sap/ui/Device','sap/ui/core/ContextMenuSupport'],function(q,l,C,E,I,D,a){"use strict";
var B=C.extend("sap.m.Button",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.m",properties:{text:{type:"string",group:"Misc",defaultValue:null},type:{type:"sap.m.ButtonType",group:"Appearance",defaultValue:sap.m.ButtonType.Default},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},iconFirst:{type:"boolean",group:"Appearance",defaultValue:true},activeIcon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconDensityAware:{type:"boolean",group:"Misc",defaultValue:true},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{tap:{deprecated:true},press:{}},designTime:true}});
E.call(B.prototype);a.apply(B.prototype);
B.prototype.exit=function(){if(this._image){this._image.destroy();}if(this._iconBtn){this._iconBtn.destroy();}};
B.prototype.onBeforeRendering=function(){this._bRenderActive=this._bActive;};
B.prototype.onAfterRendering=function(){if(this._bRenderActive){this._activeButton();this._bRenderActive=this._bActive;}};
B.prototype.ontouchstart=function(e){e.setMarked();if(this._bRenderActive){delete this._bRenderActive;}if(e.targetTouches.length===1){this._activeButton();}if(this.getEnabled()&&this.getVisible()){if(D.browser.safari&&(e.originalEvent&&e.originalEvent.type==="mousedown")){this.focus();e.preventDefault();}}};
B.prototype.ontouchend=function(e){this._inactiveButton();if(this._bRenderActive){delete this._bRenderActive;if(e.originalEvent&&e.originalEvent.type in{mouseup:1,touchend:1}){this.ontap(e);}}};
B.prototype.ontouchcancel=function(){this._inactiveButton();};
B.prototype.ontap=function(e){e.setMarked();if(this.getEnabled()&&this.getVisible()){if((e.originalEvent&&e.originalEvent.type==="touchend")){this.focus();}this.fireTap({});this.firePress({});}};
B.prototype.onkeydown=function(e){if(e.which===q.sap.KeyCodes.SPACE||e.which===q.sap.KeyCodes.ENTER){e.setMarked();this._activeButton();}};
B.prototype.onkeyup=function(e){if(e.which===q.sap.KeyCodes.SPACE||e.which===q.sap.KeyCodes.ENTER){e.setMarked();this._inactiveButton();this.firePress({});}};
B.prototype.onfocusout=function(){this._inactiveButton();};
B.prototype._activeButton=function(){if(!this._isUnstyled()){this.$("inner").addClass("sapMBtnActive");}this._bActive=this.getEnabled();if(this._bActive){if(this.getIcon()&&this.getActiveIcon()&&this._image){this._image.setSrc(this.getActiveIcon());}}};
B.prototype._inactiveButton=function(){if(!this._isUnstyled()){this.$("inner").removeClass("sapMBtnActive");}this._bActive=false;if(this.getEnabled()){if(this.getIcon()&&this.getActiveIcon()&&this._image){this._image.setSrc(this.getIcon());}}};
B.prototype._isHoverable=function(){return this.getEnabled()&&D.system.desktop;};
B.prototype._getImage=function(i,s,A,b){if(this._image&&(this._image.getSrc()!==s)){this._image.destroy();this._image=undefined;}var o=this._image;var c=this.getIconFirst();if(!!o){o.setSrc(s);if(o instanceof sap.m.Image){o.setActiveSrc(A);o.setDensityAware(b);}}else{o=I.createControlByURI({id:i,src:s,activeSrc:A,densityAware:b,useIconTooltip:false},sap.m.Image).addStyleClass("sapMBtnCustomIcon").setParent(this,null,true);}o.addStyleClass("sapMBtnIcon");o.toggleStyleClass("sapMBtnIconLeft",c);o.toggleStyleClass("sapMBtnIconRight",!c);this._image=o;return this._image;};
B.prototype._getInternalIconBtn=function(i,s){var o=this._iconBtn;if(o){o.setSrc(s);}else{o=I.createControlByURI({id:i,src:s,useIconTooltip:false},sap.m.Image).setParent(this,null,true);}o.addStyleClass("sapMBtnIcon");o.addStyleClass("sapMBtnIconLeft");this._iconBtn=o;return this._iconBtn;};
B.prototype._isUnstyled=function(){var u=false;if(this.getType()===sap.m.ButtonType.Unstyled){u=true;}return u;};
B.prototype.setText=function(t){var v=this.getText();if(t===null||t===undefined){t="";}if(v!==t){var d=this.getDomRef("content");var s=!!d;this.setProperty("text",t,s);if(s){t=this.getText();d.innerHTML=q.sap.encodeHTML(t);this.$("inner").toggleClass("sapMBtnText",!!t);}}return this;};
B.prototype.setIcon=function(i){var v=this.getIcon()||"";i=i||"";if(v!==i){var s=!!v&&!!i&&I.isIconURI(i)===I.isIconURI(v);this.setProperty("icon",i,s);if(s&&this._image){this._image.setSrc(i);}}return this;};
B.prototype.getPopupAnchorDomRef=function(){return this.getDomRef("inner");};
B.prototype._getText=function(){return this.getText();};
B.prototype._getTooltip=function(){var t=this.getTooltip_AsString();if(!t&&!this.getText()){var i=sap.ui.core.IconPool.getIconInfo(this.getIcon());if(i&&i.text){t=i.text;}}return t;};
B.prototype.setType=function(t){this.setProperty("type",t);var T="";var r;switch(t){case sap.m.ButtonType.Accept:if(!B._oStaticAcceptText){r=sap.ui.getCore().getLibraryResourceBundle("sap.m");T=r.getText("BUTTON_ARIA_TYPE_ACCEPT");B._oStaticAcceptText=new sap.ui.core.InvisibleText({text:T});B._oStaticAcceptText.toStatic();}break;case sap.m.ButtonType.Reject:if(!B._oStaticRejectText){r=sap.ui.getCore().getLibraryResourceBundle("sap.m");T=r.getText("BUTTON_ARIA_TYPE_REJECT");B._oStaticRejectText=new sap.ui.core.InvisibleText({text:T});B._oStaticRejectText.toStatic();}break;case sap.m.ButtonType.Emphasized:if(!B._oStaticEmphasizedText){r=sap.ui.getCore().getLibraryResourceBundle("sap.m");T=r.getText("BUTTON_ARIA_TYPE_EMPHASIZED");B._oStaticEmphasizedText=new sap.ui.core.InvisibleText({text:T});B._oStaticEmphasizedText.toStatic();}break;default:break;}return this;};
B.prototype.getAccessibilityInfo=function(){var d=this.getText()||this.getTooltip_AsString();if(!d&&this.getIcon()){var i=sap.ui.core.IconPool.getIconInfo(this.getIcon());if(i){d=i.text||i.name;}}return{role:"button",type:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_BUTTON"),description:d,focusable:this.getEnabled(),enabled:this.getEnabled()};};
return B;},true);
sap.ui.predefine('sap/m/ButtonRenderer',['jquery.sap.global'],function(q){"use strict";var B={};
B.render=function(R,b){var t=b.getType();var e=b.getEnabled();var w=b.getWidth();var T=b._getTooltip();var s=b._getText();var a=b.getTextDirection();var i=sap.ui.Device.browser.internet_explorer||sap.ui.Device.browser.edge;var c=(a===sap.ui.core.TextDirection.Inherit)&&!i;var d=sap.ui.core.IconPool.getIconURI("nav-back");R.write("<button");R.writeControlData(b);R.addClass("sapMBtnBase");if(!b._isUnstyled()){R.addClass("sapMBtn");if((t===sap.m.ButtonType.Back||t===sap.m.ButtonType.Up)&&b.getIcon()&&!s){R.addClass("sapMBtnBack");}}var A={};var f="";switch(t){case sap.m.ButtonType.Accept:f=sap.m.Button._oStaticAcceptText.getId();break;case sap.m.ButtonType.Reject:f=sap.m.Button._oStaticRejectText.getId();break;case sap.m.ButtonType.Emphasized:f=sap.m.Button._oStaticEmphasizedText.getId();break;default:break;}if(f){A["describedby"]={value:f,append:true};}if(b.getAriaLabelledBy()&&b.getAriaLabelledBy().length>0){A["labelledby"]={value:b.getId(),append:true};}if(this.renderAccessibilityAttributes){this.renderAccessibilityAttributes(R,b,A);}R.writeAccessibilityState(b,A);if(!e){R.writeAttribute("disabled","disabled");if(!b._isUnstyled()){R.addClass("sapMBtnDisabled");}}else{switch(t){case sap.m.ButtonType.Accept:case sap.m.ButtonType.Reject:case sap.m.ButtonType.Emphasized:R.addClass("sapMBtnInverted");break;default:break;}}if(T){R.writeAttributeEscaped("title",T);}R.writeClasses();if(w!=""||w.toLowerCase()==="auto"){R.addStyle("width",w);R.writeStyles();}r(b,R);R.write(">");R.write("<span");R.writeAttribute("id",b.getId()+"-inner");if(!b._isUnstyled()){R.addClass("sapMBtnInner");}if(b._isHoverable()){R.addClass("sapMBtnHoverable");}if(e){R.addClass("sapMFocusable");if(i){R.addClass("sapMIE");}}if(!b._isUnstyled()){if(s){R.addClass("sapMBtnText");}if(t===sap.m.ButtonType.Back||t===sap.m.ButtonType.Up){R.addClass("sapMBtnBack");}if(b.getIcon()){if(b.getIconFirst()){R.addClass("sapMBtnIconFirst");}else{R.addClass("sapMBtnIconLast");}}}if(this.renderButtonAttributes){this.renderButtonAttributes(R,b);}if(!b._isUnstyled()&&t!==""){R.addClass("sapMBtn"+q.sap.encodeHTML(t));}R.writeClasses();r(b,R);R.write(">");if(t===sap.m.ButtonType.Back||t===sap.m.ButtonType.Up){this.writeInternalIconPoolHtml(R,b,d);}if(b.getIcon()){this.writeImgHtml(R,b);}if(s){R.write("<span");R.addClass("sapMBtnContent");if(a!==sap.ui.core.TextDirection.Inherit){R.writeAttribute("dir",a.toLowerCase());}R.writeClasses();R.writeAttribute("id",b.getId()+"-content");R.write(">");if(c){R.write("<bdi>");}R.writeEscaped(s);if(c){R.write("</bdi>");}R.write("</span>");}if(i&&e){R.write('<span class="sapMBtnFocusDiv"></span>');}R.write("</span>");R.write("</button>");};
B.writeImgHtml=function(R,b){R.renderControl(b._getImage((b.getId()+"-img"),b.getIcon(),b.getActiveIcon(),b.getIconDensityAware()));};
B.writeInternalIconPoolHtml=function(R,b,u){R.renderControl(b._getInternalIconBtn((b.getId()+"-iconBtn"),u));};
function r(b,R){if(b._bExcludeFromTabChain){R.writeAttribute("tabindex",-1);}}
return B;},true);
sap.ui.predefine('sap/m/Carousel',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/thirdparty/mobify-carousel'],function(q,l,C,m){"use strict";
var a=C.extend("sap.m.Carousel",{metadata:{library:"sap.m",properties:{height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},loop:{type:"boolean",group:"Misc",defaultValue:false},showPageIndicator:{type:"boolean",group:"Appearance",defaultValue:true},pageIndicatorPlacement:{type:"sap.m.PlacementType",group:"Appearance",defaultValue:sap.m.PlacementType.Bottom},showBusyIndicator:{type:"boolean",group:"Appearance",defaultValue:true,deprecated:true},busyIndicatorSize:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'6em',deprecated:true},arrowsPlacement:{type:"sap.m.CarouselArrowsPlacement",group:"Appearance",defaultValue:sap.m.CarouselArrowsPlacement.Content}},defaultAggregation:"pages",aggregations:{pages:{type:"sap.ui.core.Control",multiple:true,singularName:"page"}},associations:{activePage:{type:"sap.ui.core.Control",multiple:false}},events:{loadPage:{deprecated:true,parameters:{pageId:{type:"string"}}},unloadPage:{deprecated:true,parameters:{pageId:{type:"string"}}},pageChanged:{parameters:{oldActivePageId:{type:"string"},newActivePageId:{type:"string"}}}}}});
a._INNER_SELECTOR=".sapMCrslInner";a._PAGE_INDICATOR_SELECTOR=".sapMCrslBulleted";a._PAGE_INDICATOR_ARROWS_SELECTOR=".sapMCrslIndicatorArrow";a._CONTROLS=".sapMCrslControls";a._ITEM_SELECTOR=".sapMCrslItem";a._LEFTMOST_CLASS="sapMCrslLeftmost";a._RIGHTMOST_CLASS="sapMCrslRightmost";a._LATERAL_CLASSES="sapMCrslLeftmost sapMCrslRightmost";a._bIE9=(sap.ui.Device.browser.internet_explorer&&sap.ui.Device.browser.version<10);a._MODIFIERNUMBERFORKEYBOARDHANDLING=10;a._BULLETS_TO_NUMBERS_THRESHOLD=9;
a.prototype.init=function(){this._aScrollContainers=[];this._fnAdjustAfterResize=q.proxy(function(){var $=this.$().find(a._INNER_SELECTOR);this._oMobifyCarousel.resize($);},this);this.data("sap-ui-fastnavgroup","true",true);};
a.prototype.exit=function(){if(this._oMobifyCarousel){this._oMobifyCarousel.destroy();delete this._oMobifyCarousel;}if(this._oArrowLeft){this._oArrowLeft.destroy();delete this._oArrowLeft;}if(this._oArrowRight){this._oArrowRight.destroy();delete this._oArrowRight;}if(this._sResizeListenerId){sap.ui.core.ResizeHandler.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}this.$().off('afterSlide');this._cleanUpScrollContainer();this._fnAdjustAfterResize=null;this._aScrollContainers=null;this._$InnerDiv=null;};
a.prototype._cleanUpScrollContainer=function(){var s;while(this._aScrollContainers&&this._aScrollContainers.length>0){s=this._aScrollContainers.pop();s.removeAllContent();if(s&&typeof s.destroy==='function'){s.destroy();}}};
a.prototype.ontouchstart=function(e){if(this._oMobifyCarousel){this._oMobifyCarousel.touchstart(e);}};
a.prototype.ontouchmove=function(e){if(this._oMobifyCarousel){this._oMobifyCarousel.touchmove(e);}};
a.prototype.ontouchend=function(e){if(this._oMobifyCarousel){this._oMobifyCarousel.touchend(e);}};
a.prototype.onBeforeRendering=function(){var A=this.getActivePage();if(!A&&this.getPages().length>0){this.setAssociation("activePage",this.getPages()[0].getId(),true);}if(this._sResizeListenerId){sap.ui.core.ResizeHandler.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}return this;};
a.prototype.onAfterRendering=function(){if(this._oMobifyCarousel){this._oMobifyCarousel.unbind();}this.$().carousel();this._oMobifyCarousel=this.getDomRef()._carousel;this._oMobifyCarousel.setLoop(this.getLoop());this._oMobifyCarousel.setRTL(sap.ui.getCore().getConfiguration().getRTL());var A=this.getActivePage();if(A){var i=this._getPageNumber(A);if(isNaN(i)||i==0){if(this.getPages().length>0){this.setAssociation("activePage",this.getPages()[0].getId(),true);this._adjustHUDVisibility(1);}}else{var c=sap.ui.getCore();if(c.isThemeApplied()){this._moveToPage(i+1);}else{c.attachThemeChanged(this._handleThemeLoad,this);}if(sap.zen&&sap.zen.commons&&this.getParent()instanceof sap.zen.commons.layout.PositionContainer){if(this._isCarouselUsedWithCommonsLayout===undefined){q.sap.delayedCall(0,this,"invalidate");this._isCarouselUsedWithCommonsLayout=true;}}}}this.$().on('afterSlide',q.proxy(function(e,P,n){if(e.target!==this.getDomRef()){return;}if(n>0){this._changePage(n);}},this));this._$InnerDiv=this.$().find(a._INNER_SELECTOR)[0];this._sResizeListenerId=sap.ui.core.ResizeHandler.register(this._$InnerDiv,this._fnAdjustAfterResize);this.$().find('.sapMCrslItemTableCell').focus(function(e){e.preventDefault();q(e.target).parents('.sapMCrsl').focus();return false;});var s='sap.m.IconTabBar';var p=this.getParent();while(p){if(p.getMetadata().getName()==s){var t=this;p.attachExpand(function(e){var E=e.getParameter('expand');if(E&&i>0){t._moveToPage(i+1);}});break;}p=p.getParent();}};
a.prototype._handleThemeLoad=function(){var c,A=this.getActivePage();if(A){var i=this._getPageNumber(A);if(i>0){this._moveToPage(i+1);}}c=sap.ui.getCore();c.detachThemeChanged(this._handleThemeLoad,this);};
a.prototype._moveToPage=function(i){this._oMobifyCarousel.changeAnimation('sapMCrslNoTransition');this._oMobifyCarousel.move(i);this._changePage(i);};
a.prototype._changePage=function(n){this._adjustHUDVisibility(n);var o=this.getActivePage();var N=this.getPages()[n-1].getId();this.setAssociation("activePage",N,true);var t=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("CAROUSEL_PAGE_INDICATOR_TEXT");var i=this.getId()+'-'+'slide-number';var s=n+' '+t+' '+this.getPages().length;q.sap.log.debug("sap.m.Carousel: firing pageChanged event: old page: "+o+", new page: "+N);if(sap.ui.Device.system.tablet||sap.ui.Device.system.phone){q(document.activeElement).blur();}this.firePageChanged({oldActivePageId:o,newActivePageId:N});if(document.getElementById(i)){document.getElementById(i).innerHTML=s;}};
a.prototype._adjustHUDVisibility=function(n){if(sap.ui.Device.system.desktop&&!this.getLoop()&&this.getPages().length>1){var h=this.$('hud');h.removeClass(a._LATERAL_CLASSES);if(n===1){h.addClass(a._LEFTMOST_CLASS);}else if(n===this.getPages().length){h.addClass(a._RIGHTMOST_CLASS);}}};
a.prototype.setActivePage=function(p){var P=null;if(typeof(p)=='string'){P=p;}else if(p instanceof C){P=p.getId();}if(P){if(P===this.getActivePage()){return this;}var i=this._getPageNumber(P);if(!isNaN(i)){if(this._oMobifyCarousel){this._oMobifyCarousel.move(i+1);}}}this.setAssociation("activePage",P,true);return this;};
a.prototype.setHeight=function(h){this.setProperty("height",h,true);this.$().css("height",h);return this;};
a.prototype.setWidth=function(w){this.setProperty("width",w,true);this.$().css("width",w);return this;};
a.prototype.setLoop=function(L){this.setProperty("loop",L,true);if(this._oMobifyCarousel){this._oMobifyCarousel.setLoop(L);}return this;};
a.prototype._getNavigationArrow=function(n){q.sap.require("sap.ui.core.IconPool");var p={src:"sap-icon://slim-arrow-"+n,useIconTooltip:false};if(n==="left"){if(!this._oArrowLeft){this._oArrowLeft=sap.m.ImageHelper.getImageControl(this.getId()+"-arrowScrollLeft",this._oArrowLeft,this,p);}return this._oArrowLeft;}else if(n==="right"){if(!this._oArrowRight){this._oArrowRight=sap.m.ImageHelper.getImageControl(this.getId()+"-arrowScrollRight",this._oArrowRight,this,p);}return this._oArrowRight;}};
a.prototype._createScrollContainer=function(p){var i;var s=sap.ui.Device.system.desktop&&this.getArrowsPlacement()===sap.m.CarouselArrowsPlacement.PageIndicator;if(s){i="sapMCrslImg";}else{i="sapMCrslImgNoArrows";}var c=p instanceof sap.m.Image?"sapMCrslItemTableCell "+i:"sapMCrslItemTableCell",o=new sap.ui.core.HTML({content:"<div class='sapMCrslItemTable'>"+"<div class='"+c+"'></div>"+"</div>",afterRendering:function(e){var r=sap.ui.getCore().createRenderManager();r.render(p,this.getDomRef().firstChild);r.destroy();}});var S=new sap.m.ScrollContainer({horizontal:false,vertical:false,content:[o],width:'100%',height:'100%'});S.setParent(this,null,true);this._aScrollContainers.push(S);return S;};
a.prototype.previous=function(){if(this._oMobifyCarousel){this._oMobifyCarousel.prev();}else{q.sap.log.warning("Unable to execute sap.m.Carousel.previous: carousel must be rendered first.");}return this;};
a.prototype.next=function(){if(this._oMobifyCarousel){this._oMobifyCarousel.next();}else{q.sap.log.warning("Unable to execute sap.m.Carousel.next: carousel must be rendered first.");}return this;};
a.prototype._getPageNumber=function(p){var i,r;for(i=0;i<this.getPages().length;i++){if(this.getPages()[i].getId()==p){r=i;break;}}return r;};
a.prototype.onsaptabprevious=function(e){this._bDirection=false;this._fnOnTabPress(e);};
a.prototype.onsaptabnext=function(e){this._bDirection=true;this._fnOnTabPress(e);};
a.prototype.onfocusin=function(e){this.saveLastFocusReference(e);this._bDirection=undefined;};
a.prototype.onsapskipforward=function(e){e.preventDefault();this._handleGroupNavigation(e,false);};
a.prototype.onsapskipback=function(e){e.preventDefault();this._handleGroupNavigation(e,true);};
a.prototype.onkeydown=function(e){if(e.keyCode==q.sap.KeyCodes.F7){this._handleF7Key(e);return;}if(e.target!=this.getDomRef()){return;}switch(e.keyCode){case 189:case q.sap.KeyCodes.NUMPAD_MINUS:this._fnSkipToIndex(e,-1);break;case q.sap.KeyCodes.PLUS:case q.sap.KeyCodes.NUMPAD_PLUS:this._fnSkipToIndex(e,1);break;}};
a.prototype.onsapescape=function(e){var b;if(e.target===this.$()[0]&&this._lastActivePageNumber){b=this._lastActivePageNumber+1;this._oMobifyCarousel.move(b);this._changePage(b);}};
a.prototype.onsapright=function(e){this._fnSkipToIndex(e,1);};
a.prototype.onsapup=function(e){this._fnSkipToIndex(e,-1);};
a.prototype.onsapleft=function(e){this._fnSkipToIndex(e,-1);};
a.prototype.onsapdown=function(e){this._fnSkipToIndex(e,1);};
a.prototype.onsaphome=function(e){this._fnSkipToIndex(e,0);};
a.prototype.onsapend=function(e){this._fnSkipToIndex(e,this.getPages().length);};
a.prototype.onsaprightmodifiers=function(e){if(e.ctrlKey){this._fnSkipToIndex(e,a._MODIFIERNUMBERFORKEYBOARDHANDLING);}};
a.prototype.onsapupmodifiers=function(e){if(e.ctrlKey){this._fnSkipToIndex(e,a._MODIFIERNUMBERFORKEYBOARDHANDLING);}};
a.prototype.onsappageup=function(e){this._fnSkipToIndex(e,a._MODIFIERNUMBERFORKEYBOARDHANDLING);};
a.prototype.onsapleftmodifiers=function(e){if(e.ctrlKey){this._fnSkipToIndex(e,-a._MODIFIERNUMBERFORKEYBOARDHANDLING);}};
a.prototype.onsapdownmodifiers=function(e){if(e.ctrlKey){this._fnSkipToIndex(e,-a._MODIFIERNUMBERFORKEYBOARDHANDLING);}};
a.prototype.onsappagedown=function(e){this._fnSkipToIndex(e,-a._MODIFIERNUMBERFORKEYBOARDHANDLING);};
a.prototype._fnOnTabPress=function(e){if(e.target===this.$()[0]){this._lastActivePageNumber=this._getPageNumber(this.getActivePage());}};
a.prototype._handleGroupNavigation=function(e,s){var E=q.Event("keydown");e.preventDefault();this.$().focus();E.target=e.target;E.keyCode=q.sap.KeyCodes.F6;E.shiftKey=s;q.sap.handleF6GroupNavigation(E);};
a.prototype.saveLastFocusReference=function(e){if(this._bDirection===undefined){return;}if(this._lastFocusablePageElement===undefined){this._lastFocusablePageElement={};}this._lastFocusablePageElement[this.getActivePage()]=e.target;};
a.prototype._getActivePageLastFocusedElement=function(){if(this._lastFocusablePageElement){return this._lastFocusablePageElement[this.getActivePage()];}};
a.prototype._fnSkipToIndex=function(e,n){var b=n;if(e.target!==this.getDomRef()){return;}e.preventDefault();if(n!==0){b=this._getPageNumber(this.getActivePage())+1+n;}this._oMobifyCarousel.move(b);};
a.prototype._handleF7Key=function(e){var A;e.preventDefault();A=this._getActivePageLastFocusedElement();if(e.target===this.$()[0]&&A){A.focus();}else{this.$().focus();}};
a.prototype.setShowBusyIndicator=function(){q.sap.log.warning("sap.m.Carousel: Deprecated function 'setShowBusyIndicator' called. Does nothing.");return this;};
a.prototype.getShowBusyIndicator=function(){q.sap.log.warning("sap.m.Carousel: Deprecated function 'getShowBusyIndicator' called. Does nothing.");return false;};
a.prototype.setBusyIndicatorSize=function(){q.sap.log.warning("sap.m.Carousel: Deprecated function 'setBusyIndicatorSize' called. Does nothing.");return this;};
a.prototype.getBusyIndicatorSize=function(){q.sap.log.warning("sap.m.Carousel: Deprecated function 'getBusyIndicatorSize' called. Does nothing.");return"";};
return a;},true);
sap.ui.predefine('sap/m/CarouselRenderer',['jquery.sap.global'],function(q){"use strict";var C={};
C.render=function(r,c){var p=c.getPages(),P=p.length,s=c.getPageIndicatorPlacement(),a=c.getArrowsPlacement(),i=c.getId(),b=sap.m.Carousel._BULLETS_TO_NUMBERS_THRESHOLD,I=c._getPageNumber(c.getActivePage());this._renderOpeningDiv(r,c);if(s===sap.m.PlacementType.Top){this._renderPageIndicatorAndArrows({rm:r,iPageCount:P,sId:i,iIndex:I,iBulletsToNumbersThreshold:b,sArrowsPlacement:a,bBottom:false,bShowPageIndicator:c.getShowPageIndicator()},c);}this._renderInnerDiv(r,c,p,s);if(sap.ui.Device.system.desktop&&P>1&&a===sap.m.CarouselArrowsPlacement.Content){this._renderHudArrows(r,c);}if(s===sap.m.PlacementType.Bottom){this._renderPageIndicatorAndArrows({rm:r,iPageCount:P,sId:i,iIndex:I,iBulletsToNumbersThreshold:b,sArrowsPlacement:a,bBottom:true,bShowPageIndicator:c.getShowPageIndicator()},c);}this._renderClosingDiv(r);};
C._renderOpeningDiv=function(r,c){var t=c.getTooltip_AsString();r.write("<div");r.writeControlData(c);r.writeAttribute("data-sap-ui-customfastnavgroup","true");r.addStyle("width",c.getWidth());r.addStyle("height",c.getHeight());r.writeStyles();r.addClass("sapMCrsl");r.addClass("sapMCrslFluid");r.writeClasses();if(t){r.writeAttributeEscaped("title",t);}r.writeAttributeEscaped("tabindex","0");r.writeAccessibilityState(c,{role:"list"});r.write(">");};
C._renderInnerDiv=function(r,c,p,P){r.write("<div class='sapMCrslInner");c._cleanUpScrollContainer();if(p.length>1&&(c.getShowPageIndicator()||c.getArrowsPlacement()===sap.m.CarouselArrowsPlacement.PageIndicator)){if(P===sap.m.PlacementType.Bottom){r.write(" sapMCrslBottomOffset");if(c.getArrowsPlacement()===sap.m.CarouselArrowsPlacement.PageIndicator){r.write(" sapMCrslBottomArrowsOffset");}}else{r.write(" sapMCrslTopOffset");if(c.getArrowsPlacement()===sap.m.CarouselArrowsPlacement.PageIndicator){r.write(" sapMCrslTopArrowsOffset");}}}r.write("'>");var R=function(o,i,a){r.write("<div class='sapMCrslItem");r.write("' id='"+c.sId+"-"+o.sId+"-slide'");r.writeAccessibilityState(o,{role:"listitem",posinset:i+1,setsize:a.length});r.write(">");r.renderControl(c._createScrollContainer(o,i));r.write("</div>");};p.forEach(R);r.write("</div>");};
C._renderClosingDiv=function(r){r.write('</div>');};
C._renderPageIndicatorAndArrows=function(s,c){var r=s.rm,p=s.iPageCount,S=sap.ui.Device.system.desktop&&s.sArrowsPlacement===sap.m.CarouselArrowsPlacement.PageIndicator,b=s.bBottom,I=s.sId,a=s.iIndex,B=s.iBulletsToNumbersThreshold,d=s.bShowPageIndicator,P=d?'':'opacity: 0',R=sap.ui.getCore().getLibraryResourceBundle('sap.m'),o="",t=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("CAROUSEL_PAGE_INDICATOR_TEXT");if(p<=1){return;}if(!d&&!S){return;}if(b){o+=" sapMCrslControlsBottom";}else{o+=" sapMCrslControlsTop";}if(S){r.write('<div');r.addClass("sapMCrslControls");r.addClass(o);r.writeClasses();r.write('>');r.write('<div class="sapMCrslControlsContainer'+o+'">');}else{r.write('<div class="sapMCrslControlsNoArrows'+o+'">');}if(S){this._renderPrevArrow(r,c);}var e=I+'-pageIndicator';r.write('<div id="'+e+'" style="'+P+'"');if(p<B){r.write(' class="sapMCrslBulleted">');for(var i=1;i<=p;i++){r.write("<span role='img' data-slide="+i+" aria-label='"+R.getText('CAROUSEL_POSITION',[i,p])+"'>"+i+"</span>");}}else{r.write(' class="sapMCrslNumeric">');r.write('<span id='+I+'-'+'slide-number>'+(a+1)+' '+t+' '+p+'</span>');}r.write('</div>');if(S){this._renderNextArrow(r,c);}if(!S){r.write('</div>');}if(S){r.write('</div>');r.write('</div>');}};
C._renderHudArrows=function(r,c){var a;if(c.getShowPageIndicator()){if(c.getPageIndicatorPlacement()===sap.m.PlacementType.Top){a="sapMCrslHudTop";}else if(c.getPageIndicatorPlacement()===sap.m.PlacementType.Bottom){a="sapMCrslHudBottom";}}else{a="sapMCrslHudMiddle";}var h=c.getId()+'-hud';r.write('<div id="'+h+'" class="sapMCrslHud '+a+'">');this._renderPrevArrow(r,c);this._renderNextArrow(r,c);r.write("</div>");};
C._renderPrevArrow=function(r,c){r.write("<a class='sapMCrslPrev' href='#' data-slide='prev' tabindex='-1'><div class='sapMCrslArrowInner'>");r.renderControl(c._getNavigationArrow('left'));r.write("</div></a>");};
C._renderNextArrow=function(r,c){r.write("<a class='sapMCrslNext' href='#' data-slide='next' tabindex='-1'><div class='sapMCrslArrowInner'>");r.renderControl(c._getNavigationArrow('right'));r.write("</div></a>");};
return C;},true);
sap.ui.predefine('sap/m/CheckBox.designtime',[],function(){"use strict";return{actions:{remove:{changeType:"hideControl"},rename:{changeType:"rename",domRef:function(c){return c.$().find(".sapMCbLabel")[0];}},reveal:{changeType:"unhideControl"}},name:{singular:"CHECKBOX_NAME",plural:"CHECKBOX_NAME_PLURAL"}};},false);
sap.ui.predefine('sap/m/CheckBox',['jquery.sap.global','./Label','./library','sap/ui/Device','sap/ui/core/Control',"sap/ui/core/IconPool",'sap/ui/core/EnabledPropagator'],function(q,L,l,D,C,I,E){"use strict";
var a=C.extend("sap.m.CheckBox",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.m",properties:{selected:{type:"boolean",group:"Data",defaultValue:false},enabled:{type:"boolean",group:"Behavior",defaultValue:true},name:{type:"string",group:"Misc",defaultValue:null},text:{type:"string",group:"Appearance",defaultValue:null},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:sap.ui.core.TextAlign.Begin},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:''},activeHandling:{type:"boolean",group:"Misc",defaultValue:true},editable:{type:"boolean",group:"Behavior",defaultValue:true},valueState:{type:"sap.ui.core.ValueState",group:"Data",defaultValue:sap.ui.core.ValueState.None}},aggregations:{_label:{type:"sap.m.Label",group:"Behavior",multiple:false,visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{select:{parameters:{selected:{type:"boolean"}}}},designTime:true}});
E.call(a.prototype);
a.prototype.init=function(){this.addActiveState(this);I.insertFontFaceStyle();};
a.prototype.exit=function(){this._oLabel=null;delete this._iTabIndex;};
a.prototype.setSelected=function(s){s=!!s;if(s==this.getSelected()){return this;}this.$("CbBg").toggleClass("sapMCbMarkChecked",s);this.$().attr("aria-checked",s);var c=this.getDomRef("CB");if(c){s?c.setAttribute('checked','checked'):c.removeAttribute('checked');}this.setProperty("selected",s,true);return this;};
a.prototype.setText=function(t){var o=this._getLabel(),h=!!t;this.setProperty("text",t,true);o.setText(t);this.$().toggleClass("sapMCbHasLabel",h);return this;};
a.prototype.setWidth=function(w){var o=this._getLabel();this.setProperty("width",w,true);o.setWidth(w);return this;};
a.prototype.setTextDirection=function(d){var o=this._getLabel();this.setProperty("textDirection",d,true);o.setTextDirection(d);return this;};
a.prototype.setTextAlign=function(A){var o=this._getLabel();this.setProperty("textAlign",A,true);o.setTextAlign(A);return this;};
a.prototype.addActiveState=function(c){if(D.os.blackberry){c.addDelegate({ontouchstart:function(e){q(c.getDomRef()).addClass("sapMActive");},ontouchend:function(e){q(c.getDomRef()).removeClass("sapMActive");}});}};
a.prototype.ontouchstart=function(e){e.originalEvent._sapui_handledByControl=true;};
a.prototype.ontap=function(e){if(this.getEnabled()&&this.getEditable()){this.$().focus();var s=!this.getSelected();this.setSelected(s);this.fireSelect({selected:s});e&&e.setMarked();}};
a.prototype.onsapspace=function(e){this.ontap(e);if(e){e.preventDefault();e.stopPropagation();}};
a.prototype.onsapenter=function(e){this.ontap(e);};
a.prototype.setTabIndex=function(t){this._iTabIndex=t;this.$("CbBg").attr("tabindex",t);return this;};
a.prototype.getTabIndex=function(){if(this.hasOwnProperty("_iTabIndex")){return this._iTabIndex;}return this.getEnabled()?0:-1;};
a.prototype._getLabel=function(){if(!this._oLabel){this._oLabel=new L(this.getId()+"-label",{labelFor:this.getId()}).addStyleClass("sapMCbLabel");this.setAggregation("_label",this._oLabel,true);}return this.getAggregation("_label");};
a.prototype.getAccessibilityInfo=function(){var b=sap.ui.getCore().getLibraryResourceBundle("sap.m");return{role:"checkbox",type:b.getText("ACC_CTR_TYPE_CHECKBOX"),description:(this.getText()||"")+(this.getSelected()?(" "+b.getText("ACC_CTR_STATE_CHECKED")):""),focusable:this.getEnabled(),enabled:this.getEnabled(),editable:this.getEditable()};};
a.prototype.getFormDoNotAdjustWidth=function(){return this.getText()?false:true;};
return a;},true);
sap.ui.predefine('sap/m/CheckBoxRenderer',['jquery.sap.global','sap/ui/core/library','sap/ui/core/ValueStateSupport'],function(q,c,V){"use strict";var a=c.ValueState;var C={};
C.render=function(r,o){var i=o.getId(),e=o.getEnabled(),E=o.getEditable(),b=o.getAggregation("_label"),I=a.Error===o.getValueState(),d=a.Warning===o.getValueState();r.write("<div");r.addClass("sapMCb");if(!E){r.addClass("sapMCbRo");}if(!e){r.addClass("sapMCbBgDis");}if(I){r.addClass("sapMCbErr");}else if(d){r.addClass("sapMCbWarn");}if(o.getText()){r.addClass("sapMCbHasLabel");}r.writeControlData(o);r.writeClasses();var t=V.enrichTooltip(o,o.getTooltip_AsString());if(t){r.writeAttributeEscaped("title",t);}if(e){r.writeAttribute("tabindex",o.getTabIndex());}r.writeAccessibilityState(o,{role:"checkbox",selected:null,checked:o.getSelected(),describedby:t?i+"-Descr":undefined});r.write(">");r.write("<div id='");r.write(o.getId()+"-CbBg'");r.addClass("sapMCbBg");if(e&&E&&sap.ui.Device.system.desktop){r.addClass("sapMCbHoverable");}if(!o.getActiveHandling()){r.addClass("sapMCbActiveStateOff");}r.addClass("sapMCbMark");if(o.getSelected()){r.addClass("sapMCbMarkChecked");}r.writeClasses();r.write(">");r.write("<input type='CheckBox' id='");r.write(o.getId()+"-CB'");if(o.getSelected()){r.writeAttribute("checked","checked");}if(o.getName()){r.writeAttributeEscaped('name',o.getName());}if(!e){r.write(" disabled=\"disabled\"");}if(!E){r.write(" readonly=\"readonly\"");}r.write(" /></div>");r.renderControl(b);if(t&&sap.ui.getCore().getConfiguration().getAccessibility()){r.write("<span id=\""+i+"-Descr\" class=\"sapUiHidden\">");r.writeEscaped(t);r.write("</span>");}r.write("</div>");};
return C;},true);
sap.ui.predefine('sap/m/Column',['jquery.sap.global','./library','sap/ui/core/Element','sap/ui/core/Renderer'],function(q,l,E,R){"use strict";
var C=E.extend("sap.m.Column",{metadata:{library:"sap.m",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},hAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:sap.ui.core.TextAlign.Begin},vAlign:{type:"sap.ui.core.VerticalAlign",group:"Appearance",defaultValue:sap.ui.core.VerticalAlign.Inherit},styleClass:{type:"string",group:"Appearance",defaultValue:null},visible:{type:"boolean",group:"Appearance",defaultValue:true},minScreenWidth:{type:"string",group:"Behavior",defaultValue:null},demandPopin:{type:"boolean",group:"Behavior",defaultValue:false},popinHAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:sap.ui.core.TextAlign.Begin,deprecated:true},popinDisplay:{type:"sap.m.PopinDisplay",group:"Appearance",defaultValue:sap.m.PopinDisplay.Block},mergeDuplicates:{type:"boolean",group:"Behavior",defaultValue:false},mergeFunctionName:{type:"string",group:"Misc",defaultValue:'getText'}},defaultAggregation:"header",aggregations:{header:{type:"sap.ui.core.Control",multiple:false},footer:{type:"sap.ui.core.Control",multiple:false}}}});
C.prototype._index=-1;C.prototype._screen="";C.prototype._media=null;
C.prototype.exit=function(){this._clearMedia();};
C.prototype._clearMedia=function(){if(this._media&&this._minWidth){this._detachMediaContainerWidthChange(this._notifyResize,this,this.getId());sap.ui.Device.media.removeRangeSet(this.getId());this._media=null;}};
C.prototype._addMedia=function(){delete this._bShouldAddMedia;if(this._minWidth){sap.ui.Device.media.initRangeSet(this.getId(),[parseFloat(this._minWidth)]);this._attachMediaContainerWidthChange(this._notifyResize,this,this.getId());this._media=this._getCurrentMediaContainerRange(this.getId());if(this._media){this._media.matches=!!this._media.from;}}};
C.prototype._notifyResize=function(m){if(this._media.from===m.from){return;}this._media=m;this._media.matches=!!m.from;q.sap.delayedCall(0,this,function(){var p=this.getParent();this.fireEvent("media",this);if(p&&p.onColumnResize){p.onColumnResize(this);}});};
C.prototype._validateMinWidth=function(w){if(!w){return;}if(Object.prototype.toString.call(w)!="[object String]"){throw new Error('expected string for property "minScreenWidth" of '+this);}if(Object.keys(sap.m.ScreenSizes).indexOf(w.toLowerCase())!=-1){return;}if(!/^\d+(\.\d+)?(px|em|rem)$/i.test(w)){throw new Error('invalid CSS size("px", "em", "rem" required) or sap.m.ScreenSize enumeration for property "minScreenWidth" of '+this);}};
C.prototype._isWidthPredefined=function(w){var t=this,u=w.replace(/[^a-z]/ig,""),b=parseFloat(sap.m.BaseFontSize)||16;q.each(sap.m.ScreenSizes,function(s,a){if(u!="px"){a/=b;}if(a+u==w){t._minWidth=this+"px";t._screen=s;return false;}});if(this._minWidth){return true;}if(u=="px"){this._minWidth=w;}else{this._minWidth=parseFloat(w)*b+"px";}};
C.prototype.applyAlignTo=function(c,a){a=a||this.getHAlign();if(a===sap.ui.core.TextAlign.Initial||!c.getMetadata().getProperties().textAlign||c.getTextAlign()===a){return c;}c.setProperty("textAlign",a,true);var d=c.getDomRef();a=this.getCssAlign(a);if(d&&a){d.style.textAlign=a;}return c;};
C.prototype.getCssAlign=function(a){a=a||this.getHAlign();var t=sap.ui.core.TextAlign;if(a===t.Begin||a===t.End||a===t.Initial){a=R.getTextAlign(a);}return a.toLowerCase();};
C.prototype.getStyleClass=function(r){var c=this.getProperty("styleClass");if(!r){return c;}if(this._screen&&(!this.getDemandPopin()||!window.matchMedia)){c+=" sapMSize-"+this._screen;}else if(this._media&&!this._media.matches){c+=" sapMListTblNone";}return c.trim();};
C.prototype.setIndex=function(n){this._index=+n;};
C.prototype.setOrder=function(n){this._order=+n;};
C.prototype.getOrder=function(){return this.hasOwnProperty("_order")?this._order:this.getInitialOrder();};
C.prototype.setInitialOrder=function(n){this._initialOrder=+n;};
C.prototype.getInitialOrder=function(){if(this.hasOwnProperty("_initialOrder")){return this._initialOrder;}var p=this.getParent();if(p&&p.indexOfColumn){return p.indexOfColumn(this);}return-1;};
C.prototype.setDisplay=function(t,d){if(!t||this._index<0){return;}var i=this._index+1,p=this.getParent(),a=d?"table-cell":"none",h=t.querySelector("tr > th:nth-child("+i+")"),c=t.querySelectorAll("tr > td:nth-child("+i+")"),b=c.length;h.style.display=a;h.setAttribute("aria-hidden",!d);for(i=0;i<b;i++){c[i].style.display=a;c[i].setAttribute("aria-hidden",!d);}if(p&&p.setTableHeaderVisibility){setTimeout(function(){p.setTableHeaderVisibility(d);},0);}};
C.prototype.setDisplayViaMedia=function(t){var p=this.getParent(),d=this._media&&this._media.matches;if(!this.getDemandPopin()&&this._screen&&p&&p.setTableHeaderVisibility){setTimeout(function(){p.setTableHeaderVisibility(d);},0);}else{this.setDisplay(t,d);}};
C.prototype.setVisible=function(v){if(v==this.getVisible()){return this;}var p=this.getParent(),t=p&&p.getTableDomRef&&p.getTableDomRef(),s=t&&this._index>=0;this.setProperty("visible",v,s);if(s){this.setDisplay(t,v);}return this;};
C.prototype.setMinScreenWidth=function(w){var p=this.getParent();if(w==this.getMinScreenWidth()){return this;}this._validateMinWidth(w);this._clearMedia();this._minWidth=0;this._screen="";if(w){w=w.toLowerCase();var a=sap.m.ScreenSizes[w];if(a){this._screen=w;this._minWidth=a+"px";}else{this._isWidthPredefined(w);}if(p&&p.isActive()){this._addMedia();}else{this._bShouldAddMedia=true;}}return this.setProperty("minScreenWidth",w);};
C.prototype.setDemandPopin=function(v){if(v==this.getDemandPopin()){return this;}if(!this.getMinScreenWidth()){return this.setProperty("demandPopin",v,true);}return this.setProperty("demandPopin",v);};
C.prototype.isPopin=function(){if(!this.getDemandPopin()){return false;}if(this._media){return!this._media.matches;}return false;};
C.prototype.isHidden=function(){if(this._media){return!this._media.matches;}if(this._screen&&this._minWidth){return parseFloat(this._minWidth)>window.innerWidth;}return false;};
C.prototype.setLastValue=function(v){if(this.getMergeDuplicates()){this._lastValue=v;}return this;};
C.prototype.clearLastValue=function(){return this.setLastValue(NaN);};
C.prototype.getLastValue=function(){return this._lastValue;};
C.prototype.onItemsRemoved=function(){this.clearLastValue();};
return C;},true);
sap.ui.predefine('sap/m/ColumnListItem',['jquery.sap.global','sap/ui/core/Element','./ListItemBase','./library'],function(q,E,L,l){"use strict";
var C=L.extend("sap.m.ColumnListItem",{metadata:{library:"sap.m",properties:{vAlign:{type:"sap.ui.core.VerticalAlign",group:"Appearance",defaultValue:sap.ui.core.VerticalAlign.Inherit}},defaultAggregation:"cells",aggregations:{cells:{type:"sap.ui.core.Control",multiple:true,singularName:"cell",bindable:"bindable"}}}});
var T=E.extend("sap.m.TablePopin",{onfocusin:function(e){if(e.srcControl===this||!q(e.target).is(":sapFocusable")){this.getParent().focus();}}});
C.prototype.TagName="tr";
C.prototype.init=function(){L.prototype.init.call(this);this._bNeedsTypeColumn=false;this._aClonedHeaders=[];};
C.prototype.onAfterRendering=function(){L.prototype.onAfterRendering.call(this);this._checkTypeColumn();};
C.prototype.exit=function(){L.prototype.exit.call(this);this._checkTypeColumn(false);this._destroyClonedHeaders();if(this._oPopin){this._oPopin.destroy(true);this._oPopin=null;}};
C.prototype.setVisible=function(v){L.prototype.setVisible.call(this,v);if(!v&&this.hasPopin()){this.removePopin();}return this;};
C.prototype.getTable=function(){var p=this.getParent();if(p instanceof sap.m.Table){return p;}if(p&&p.getMetadata().getName()=="sap.m.Table"){return p;}};
C.prototype.getPopin=function(){if(!this._oPopin){this._oPopin=new T({id:this.getId()+"-sub"}).addEventDelegate({ontouchstart:this.ontouchstart,ontouchmove:this.ontouchmove,ontap:this.ontap,ontouchend:this.ontouchend,ontouchcancel:this.ontouchcancel,onsaptabnext:this.onsaptabnext,onsaptabprevious:this.onsaptabprevious,onsapup:this.onsapup,onsapdown:this.onsapdown},this).setParent(this,null,true);}return this._oPopin;};
C.prototype.$Popin=function(){return this.$("sub");};
C.prototype.hasPopin=function(){return!!(this._oPopin&&this.getTable().hasPopin());};
C.prototype.removePopin=function(){this._oPopin&&this.$Popin().remove();};
C.prototype.getTabbables=function(){return this.$().add(this.$Popin()).find(":sapTabbable");};
C.prototype.getAccessibilityType=function(b){return b.getText("ACC_CTR_TYPE_ROW");};
C.prototype.getContentAnnouncement=function(b){var t=this.getTable();if(!t){return;}var a="",c=this.getCells(),d=t.getColumns(true);d.forEach(function(o){var e=c[o.getInitialOrder()];if(!e||!o.getVisible()||(o.isHidden()&&!o.isPopin())){return;}var h=o.getHeader();if(h&&h.getVisible()){a+=L.getAccessibilityText(h)+" ";}a+=L.getAccessibilityText(e,true)+" ";});return a;};
C.prototype.updateSelectedDOM=function(s,t){L.prototype.updateSelectedDOM.apply(this,arguments);if(this.hasPopin()){this.$Popin().attr("aria-selected",s);}};
C.prototype._checkTypeColumn=function(n){if(n==undefined){n=this._needsTypeColumn();}if(this._bNeedsTypeColumn!=n){this._bNeedsTypeColumn=n;this.informList("TypeColumnChange",n);}};
C.prototype._needsTypeColumn=function(){var t=this.getType(),m=sap.m.ListType;return this.getVisible()&&(t==m.Detail||t==m.Navigation||t==m.DetailAndActive);};
C.prototype._addClonedHeader=function(h){return this._aClonedHeaders.push(h);};
C.prototype._destroyClonedHeaders=function(){if(this._aClonedHeaders.length){this._aClonedHeaders.forEach(function(c){c.destroy("KeepDom");});this._aClonedHeaders=[];}};
C.prototype._activeHandlingInheritor=function(){this._toggleActiveClass(true);};
C.prototype._inactiveHandlingInheritor=function(){this._toggleActiveClass(false);};
C.prototype._toggleActiveClass=function(s){if(this.hasPopin()){this.$Popin().toggleClass("sapMLIBActive",s);}};
return C;},true);
sap.ui.predefine('sap/m/ColumnListItemRenderer',['jquery.sap.global','./ListItemBaseRenderer','./ListRenderer','sap/ui/core/Renderer'],function(q,L,a,R){"use strict";var C=R.extend(L);
C.render=function(r,l){var t=l.getTable();if(!t){return;}L.render.apply(this,arguments);if(l.getVisible()&&t.hasPopin()){this.renderPopin(r,l,t);}};
C.renderHighlight=function(r,l){r.write('<td class="sapMListTblHighlightCell" aria-hidden="true">');L.renderHighlight.apply(this,arguments);r.write('</td>');};
C.renderType=function(r,l){r.write('<td class="sapMListTblNavCol" aria-hidden="true">');L.renderType.apply(this,arguments);r.write('</td>');};
C.renderModeContent=function(r,l){r.write('<td class="sapMListTblSelCol" aria-hidden="true">');L.renderModeContent.apply(this,arguments);r.write('</td>');};
C.renderCounter=function(r,l){};
C.getAriaRole=function(l){return"";};
C.renderLIAttributes=function(r,l){r.addClass("sapMListTblRow");var A=l.getVAlign();if(A!=sap.ui.core.VerticalAlign.Inherit){r.addClass("sapMListTblRow"+A);}};
C.renderLIContentWrapper=function(r,l){var t=l.getTable();if(!t){return;}var c=t.getColumns(true),b=l.getCells();l._destroyClonedHeaders();c.forEach(function(o,i){var d,h,e=true,f=b[o.getInitialOrder()];if(!f||!o.getVisible()||o.isPopin()){o.setIndex(-1);return;}r.write("<td");r.addClass("sapMListTblCell");r.writeAttribute("id",l.getId()+"_cell"+i);if(o){d=o.getStyleClass(true);d&&r.addClass(q.sap.encodeHTML(d));h=o.getHeader();if(h){r.writeAttribute("headers",h.getId());}if(!t.hasPopin()&&o.getMergeDuplicates()){var F=o.getMergeFunctionName(),g=F.split("#"),s=g[1],j=g[0];if(typeof f[j]!="function"){q.sap.log.warning("mergeFunctionName property is defined on "+o+" but this is not function of "+f);}else{var k=o.getLastValue(),m=f[j](s);if(k===m){e=sap.ui.getCore().getConfiguration().getAccessibility();f.addStyleClass("sapMListTblCellDupCnt");r.addClass("sapMListTblCellDup");}else{o.setLastValue(m);}}}o.getVAlign()!="Inherit"&&r.addStyle("vertical-align",o.getVAlign().toLowerCase());var A=o.getCssAlign();if(A){r.addStyle("text-align",A);}r.writeStyles();}r.writeClasses();r.write(">");if(e){this.applyAriaLabelledBy(h,f);r.renderControl(o.applyAlignTo(f));}r.write("</td>");},this);};
C.applyAriaLabelledBy=function(h,c){if(c){c.removeAssociation("ariaLabelledBy",c.data("ariaLabelledBy")||undefined,true);}if(h&&h.getText&&c.getAriaLabelledBy&&h.getVisible()){c.addAssociation("ariaLabelledBy",h,true);c.data("ariaLabelledBy",h.getId());}};
C.renderPopin=function(r,l,t){l.removePopin();r.write("<tr");r.addClass("sapMListTblSubRow");r.writeElementData(l.getPopin());r.writeAttribute("tabindex","-1");if(l.isSelectable()){r.writeAttribute("aria-selected",l.getSelected());}r.writeClasses();r.write(">");this.renderHighlight(r,l);r.write("<td");r.writeAttribute("id",l.getId()+"-subcell");r.writeAttribute("colspan",t.getColSpan());r.write("><div class='sapMListTblSubCnt'>");var c=l.getCells(),b=t.getColumns(true);b.forEach(function(o){if(!o.getVisible()||!o.isPopin()){return;}var d=c[o.getInitialOrder()],h=o.getHeader();if(!h&&!d){return;}var s=o.getStyleClass(),p=o.getPopinDisplay();r.write("<div");r.addClass("sapMListTblSubCntRow");s&&r.addClass(q.sap.encodeHTML(s));r.writeClasses();r.write(">");if(h&&p!=sap.m.PopinDisplay.WithoutHeader){r.write("<div");r.addClass("sapMListTblSubCntHdr");r.writeClasses();r.write(">");h=h.clone();o.addDependent(h);l._addClonedHeader(h);o.applyAlignTo(h,"Begin");r.renderControl(h);r.write("</div>");r.write("<div class='sapMListTblSubCntSpr'>:</div>");}if(d){r.write("<div");r.addClass("sapMListTblSubCntVal");r.addClass("sapMListTblSubCntVal"+p);r.writeClasses();r.write(">");o.applyAlignTo(d,"Begin");this.applyAriaLabelledBy(h,d);r.renderControl(d);r.write("</div>");}r.write("</div>");},this);r.write("</div></td></tr>");};
C.addLegacyOutlineClass=function(r,l){};
return C;},true);
sap.ui.predefine('sap/m/ComboBox',['jquery.sap.global','./ComboBoxTextField','./ComboBoxBase','./ComboBoxRenderer','./Popover','./SelectList','./Dialog','./Toolbar','./Button','./library'],function(q,C,a,b,P,S,D,T,B,l){"use strict";
var c=a.extend("sap.m.ComboBox",{metadata:{library:"sap.m",properties:{selectedKey:{type:"string",group:"Data",defaultValue:""},selectedItemId:{type:"string",group:"Misc",defaultValue:""},showSecondaryValues:{type:"boolean",group:"Misc",defaultValue:false},filterSecondaryValues:{type:"boolean",group:"Misc",defaultValue:false}},associations:{selectedItem:{type:"sap.ui.core.Item",multiple:false}},events:{change:{parameters:{value:{type:"string"},itemPressed:{type:"boolean"}}},selectionChange:{parameters:{selectedItem:{type:"sap.ui.core.Item"}}}}}});
function h(o,i){if(!i){return;}var d=o.getFocusDomRef(),e=d.selectionStart,g=d.selectionEnd,I=e!==g,t=d.value.substring(0,d.selectionStart),j=this.getSelectedItem();if(i!==j){o.updateDomValue(i.getText());this.setSelection(i);this.fireSelectionChange({selectedItem:i});i=this.getSelectedItem();if(!q.sap.startsWithIgnoreCase(i.getText(),t)||!I){e=0;}o.selectText(e,d.value.length);}this.scrollToItem(i);}
function s(i,e){if(document.activeElement===this.getFocusDomRef()){this.selectText(i,e);}}
function f(i){var I=this.getSelectedItem(),o=I&&I.getDomRef(),d=I&&o.offsetTop,e=I&&o.offsetHeight,p=this.getPicker(),g=p.getDomRef("cont"),j=g.clientHeight;if(I&&((d+e)>(j))){if(!i){this.getList().$().css("visibility","hidden");}else{g.scrollTop=d-e/2;this.getList().$().css("visibility","visible");}}}
c.prototype._handleAriaActiveDescendant=function(i){var d=this.getFocusDomRef(),A="aria-activedescendant";if(d){if(i&&i.getDomRef()&&this.isOpen()){d.setAttribute(A,i.getId());}else{d.removeAttribute(A);}}};
c.prototype._getSelectedItemText=function(i){i=i||this.getSelectedItem();if(!i){i=this.getDefaultSelectedItem();}if(i){return i.getText();}return"";};
c.prototype._callMethodInControl=function(F,A){var L=this.getList();if(A[0]==="items"){if(L){return S.prototype[F].apply(L,A);}}else{return a.prototype[F].apply(this,A);}};
c.prototype._setItemVisibility=function(i,v){var o=i&&i.$(),d="sapMSelectListItemBaseInvisible";if(v){i.bVisible=true;o.length&&o.removeClass(d);}else{i.bVisible=false;o.length&&o.addClass(d);}};
c.prototype._highlightList=function(v){var i=this.getVisibleItems(),I=v.length,v=v.replace(/[-[\]{}()*+?.,\\^$|#\s]/g,'\\$&'),r=new RegExp("^"+v,"i");i.forEach(function(o){var d=o.getDomRef(),e,g;if(d===null){return;}e=d.children[1];g=Array.prototype.filter.call(d.children,function(j){return j.tagName.toLowerCase()!=="b";})[0]||d;g.innerHTML=this._boldItemRef(o.getText(),r,I);if(e&&o.getAdditionalText){e.innerHTML=this._boldItemRef(o.getAdditionalText(),r,I);}},this);};
c.prototype._boldItemRef=function(i,r,I){var R;var t="<b>"+q.sap.encodeHTML(i.slice(0,I))+"</b>";var p=i.split(r);if(p.length===1){R=q.sap.encodeHTML(i);}else{R=p.map(function(d){return q.sap.encodeHTML(d);}).join(t);}return R;};
c.prototype.setSelectedIndex=function(i,_){var I;_=_||this.getItems();i=(i>_.length-1)?_.length-1:Math.max(0,i);I=_[i];if(I){this.setSelection(I);}};
c.prototype.createDropdown=function(){var t=this;var d=new P(this.getDropdownSettings());d.setInitialFocus(this);d.open=function(){return this.openBy(t);};return d;};
c.prototype.createPickerTextField=function(){var t=new C({width:"100%",showValueStateMessage:false,showButton:false}).addEventDelegate({onsapenter:function(){this.updateDomValue(t.getValue());this.onChange();}},this);return t;};
c.prototype.revertSelection=function(){var p,o=this.getPickerTextField();this.setSelectedItem(this._oSelectedItemBeforeOpen);this.setValue(this._sValueBeforeOpen);if(this.getSelectedItem()===null){p=this._sValueBeforeOpen;}else{p=this._oSelectedItemBeforeOpen.getText();}o&&o.setValue(p);};
c.prototype.filterItems=function(o,I){var p=o.properties,v=o.value,e=v==="",m=false,t=false,M=[],F=[],d=null;this._oFirstItemTextMatched=null;p.forEach(function(g){M.push("get"+g.charAt(0).toUpperCase()+g.slice(1));});I=I||this.getItems();for(var i=0;i<I.length;i++){d=I[i];m=e;for(var j=0;j<M.length;j++){if(q.sap.startsWithIgnoreCase(d[M[j]](),v)){m=true;if(M[j]==="getText"){t=true;}}}if(m){F.push(d);}if(!this._oFirstItemTextMatched&&t){this._oFirstItemTextMatched=d;}this._setItemVisibility(d,m);}return F;};
c.prototype._getFilters=function(){return this.getFilterSecondaryValues()?["text","additionalText"]:["text"];};
c.prototype.init=function(){a.prototype.init.apply(this,arguments);this.bOpenValueStateMessage=true;this._sValueBeforeOpen="";this._sInputValueBeforeOpen="";this._oSelectedItemBeforeOpen=null;this._oFirstItemTextMatched=null;};
c.prototype.onBeforeRendering=function(){a.prototype.onBeforeRendering.apply(this,arguments);this.synchronizeSelection();};
c.prototype.exit=function(){a.prototype.exit.apply(this,arguments);this._oSelectedItemBeforeOpen=null;this._oFirstItemTextMatched=null;};
c.prototype.onBeforeRenderingPicker=function(){var o=this["onBeforeRendering"+this.getPickerType()];o&&o.call(this);};
c.prototype.onBeforeRenderingDropdown=function(){var p=this.getPicker(),w=(this.$().outerWidth()/parseFloat(sap.m.BaseFontSize))+"rem";if(p){p.setContentMinWidth(w);}};
c.prototype.onBeforeRenderingList=function(){if(this.bProcessingLoadItemsEvent){var L=this.getList(),F=this.getFocusDomRef();if(L){L.setBusy(true);}if(F){F.setAttribute("aria-busy","true");}}};
c.prototype.onAfterRenderingPicker=function(){var o=this["onAfterRendering"+this.getPickerType()];o&&o.call(this);f.call(this,false);};
c.prototype.onAfterRenderingList=function(){if(this.bProcessingLoadItemsEvent&&(this.getItems().length===0)){return;}var L=this.getList(),F=this.getFocusDomRef();this._highlightList(this._sInputValueBeforeOpen);if(L){L.setBusy(false);}if(F){F.removeAttribute("aria-busy");}};
c.prototype.oninput=function(e){a.prototype.oninput.apply(this,arguments);if(e.isMarked("invalid")){return;}var t=(this.getPickerType()==="Dropdown");this.loadItems(function(){var o=this.getSelectedItem(),v=e.target.value,E=v==="",d=e.srcControl,V;if(E&&!this.bOpenedByKeyboardOrButton){V=this.getItems();}else{V=this.filterItems({properties:this._getFilters(),value:v});}var i=!!V.length;var F=V[0];var g=(F&&q.sap.startsWithIgnoreCase(F.getText(),v));var j=this.getFilterSecondaryValues();var k=sap.ui.Device.system.desktop;if(!E&&F&&F.getEnabled()){if(d._bDoTypeAhead){if(j&&this._oFirstItemTextMatched){d.updateDomValue(this._oFirstItemTextMatched.getText());this.setSelection(this._oFirstItemTextMatched);}else if(j){if(g){d.updateDomValue(F.getText());}else{d.updateDomValue(F.getAdditionalText());}this.setSelection(F);}else{d.updateDomValue(F.getText());this.setSelection(F);}}if(o!==this.getSelectedItem()){this.fireSelectionChange({selectedItem:this.getSelectedItem()});}if(d._bDoTypeAhead){if(k){s.call(d,v.length,d.getValue().length);}else{setTimeout(s.bind(d,v.length,d.getValue().length),0);}}}if(E||!i||(!d._bDoTypeAhead&&(this._getSelectedItemText()!==v))){this.setSelection(null);if(o!==this.getSelectedItem()){this.fireSelectionChange({selectedItem:this.getSelectedItem()});}}this._sInputValueBeforeOpen=v;if(this.isOpen()){this._highlightList(v);}if(i){if(E&&!this.bOpenedByKeyboardOrButton){this.close();}else if(t){this.open();this.scrollToItem(this.getSelectedItem());}}else if(this.isOpen()){if(t&&!this.bOpenedByKeyboardOrButton){this.close();}}else{this.clearFilter();}},{name:"input",busyIndicator:false});if(this.bProcessingLoadItemsEvent&&t){this.open();}};
c.prototype.onSelectionChange=function(o){var i=o.getParameter("selectedItem"),p=this.getChangeEventParams();this.setSelection(i);this.fireSelectionChange({selectedItem:this.getSelectedItem()});p.itemPressed=true;this.onChange(null,p);};
c.prototype.onItemPress=function(o){var i=o.getParameter("item");var t=i.getText();this.updateDomValue(t);this.close();this.setProperty("value",i.getText(),true);setTimeout(this.selectText.bind(this,this.getValue().length,this.getValue().length),0);};
c.prototype.onBeforeOpen=function(){var p=this["onBeforeOpen"+this.getPickerType()],d=this.getFocusDomRef();if(this.hasLoadItemsEventListeners()&&!this.bProcessingLoadItemsEvent){this.loadItems();}this.addStyleClass(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Pressed");if(d){d.setAttribute("aria-owns",this.getList().getId());}this.addContent();p&&p.call(this);};
c.prototype.onBeforeOpenDropdown=function(){};
c.prototype.onBeforeOpenDialog=function(){var p=this.getPickerTextField();this._oSelectedItemBeforeOpen=this.getSelectedItem();this._sValueBeforeOpen=this.getValue();if(this.getSelectedItem()){this.filterItems({properties:this._getFilters(),value:""});}p.setValue(this._sValueBeforeOpen);};
c.prototype.onAfterOpen=function(){var d=this.getFocusDomRef(),i=this.getSelectedItem();if(d){d.setAttribute("aria-expanded","true");i&&d.setAttribute("aria-activedescendant",i.getId());}f.call(this,true);};
c.prototype.onBeforeClose=function(){a.prototype.onBeforeClose.apply(this,arguments);var d=this.getFocusDomRef();if(d){d.removeAttribute("aria-owns");d.removeAttribute("aria-activedescendant");}this.removeStyleClass(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Pressed");};
c.prototype.onAfterClose=function(){var d=this.getFocusDomRef();if(d){d.setAttribute("aria-expanded","false");}this.clearFilter();this._sInputValueBeforeOpen="";if(this.shouldValueStateMessageBeOpened()&&(document.activeElement===d)){this.openValueStateMessage();}};
c.prototype.onItemChange=function(o){var d=this.getAssociation("selectedItem"),n=o.getParameter("newValue"),p=o.getParameter("name");if(d===o.getParameter("id")){switch(p){case"text":if(!this.isBound("value")){this.setValue(n);}break;case"key":if(!this.isBound("selectedKey")){this.setSelectedKey(n);}break;}}};
c.prototype.onkeydown=function(e){var o=e.srcControl;a.prototype.onkeydown.apply(o,arguments);if(!o.getEnabled()||!o.getEditable()){return;}var k=q.sap.KeyCodes;o._bDoTypeAhead=(e.which!==k.BACKSPACE)&&(e.which!==k.DELETE);};
c.prototype.oncut=function(e){var o=e.srcControl;a.prototype.oncut.apply(o,arguments);o._bDoTypeAhead=false;};
c.prototype.onsapenter=function(e){var o=e.srcControl,i=o.getSelectedItem();if(i&&this.getFilterSecondaryValues()){o.updateDomValue(i.getText());}a.prototype.onsapenter.apply(o,arguments);if(!o.getEnabled()||!o.getEditable()){return;}if(o.isOpen()){o.close();}};
c.prototype.onsapdown=function(e){var o=e.srcControl;if(!o.getEnabled()||!o.getEditable()){return;}e.setMarked();e.preventDefault();this.loadItems(function navigateToNextSelectableItem(){var d=this.getSelectableItems();var n=d[d.indexOf(this.getSelectedItem())+1];h.call(this,o,n);});};
c.prototype.onsapup=function(e){var o=e.srcControl;if(!o.getEnabled()||!o.getEditable()){return;}e.setMarked();e.preventDefault();this.loadItems(function navigateToPrevSelectableItem(){var d=this.getSelectableItems();var p=d[d.indexOf(this.getSelectedItem())-1];h.call(this,o,p);});};
c.prototype.onsaphome=function(e){var o=e.srcControl;if(!o.getEnabled()||!o.getEditable()){return;}e.setMarked();e.preventDefault();this.loadItems(function navigateToFirstSelectableItem(){var F=this.getSelectableItems()[0];h.call(this,o,F);});};
c.prototype.onsapend=function(e){var o=e.srcControl;if(!o.getEnabled()||!o.getEditable()){return;}e.setMarked();e.preventDefault();this.loadItems(function navigateToLastSelectableItem(){var L=this.findLastEnabledItem(this.getSelectableItems());h.call(this,o,L);});};
c.prototype.onsappagedown=function(e){var o=e.srcControl;if(!o.getEnabled()||!o.getEditable()){return;}e.setMarked();e.preventDefault();this.loadItems(function(){var d=this.getSelectableItems(),i=d.indexOf(this.getSelectedItem())+10,I;i=(i>d.length-1)?d.length-1:Math.max(0,i);I=d[i];h.call(this,o,I);});};
c.prototype.onsappageup=function(e){var o=e.srcControl;if(!o.getEnabled()||!o.getEditable()){return;}e.setMarked();e.preventDefault();this.loadItems(function(){var d=this.getSelectableItems(),i=d.indexOf(this.getSelectedItem())-10,I;i=(i>d.length-1)?d.length-1:Math.max(0,i);I=d[i];h.call(this,o,I);});};
c.prototype.onsapshow=function(e){var d,i;a.prototype.onsapshow.apply(this,arguments);if(!this.getValue()){d=this.getSelectableItems();i=d[0];if(i){this.setSelection(i);this.updateDomValue(i.getText());this.fireSelectionChange({selectedItem:i});setTimeout(function(){this.selectText(0,i.getText().length);}.bind(this),0);}}};
c.prototype.onsaphide=c.prototype.onsapshow;
c.prototype.onfocusin=function(e){var d=this.getPickerType()==="Dropdown";if(e.target===this.getOpenArea()){this.bOpenValueStateMessage=false;if(d&&!this.isPlatformTablet()){this.focus();}}else{if(d){setTimeout(function(){if(document.activeElement===this.getFocusDomRef()&&!this.bFocusoutDueRendering&&!this.getSelectedText()){this.selectText(0,this.getValue().length);}}.bind(this),0);}if(!this.isOpen()&&this.bOpenValueStateMessage&&this.shouldValueStateMessageBeOpened()){this.openValueStateMessage();}this.bOpenValueStateMessage=true;}this.$().addClass("sapMFocus");};
c.prototype.onsapfocusleave=function(e){var t,p,r,F,o=e.srcControl,i=o.getSelectedItem();if(i&&this.getFilterSecondaryValues()){o.updateDomValue(i.getText());}a.prototype.onsapfocusleave.apply(this,arguments);if(this.isPickerDialog()){return;}p=this.getAggregation("picker");if(!e.relatedControlId||!p){return;}t=this.isPlatformTablet();r=sap.ui.getCore().byId(e.relatedControlId);F=r&&r.getFocusDomRef();if(q.sap.containsOrEquals(p.getFocusDomRef(),F)&&!t){this.focus();}};
c.prototype.setSelection=function(i){var L=this.getList(),k;if(L){L.setSelection(i);}this.setAssociation("selectedItem",i,true);this.setProperty("selectedItemId",(i instanceof sap.ui.core.Item)?i.getId():i,true);if(typeof i==="string"){i=sap.ui.getCore().byId(i);}k=i?i.getKey():"";this.setProperty("selectedKey",k,true);this._handleAriaActiveDescendant(i);this.toggleStyleClass(this.getRenderer().CSS_CLASS_COMBOBOX+"SelectionActive",!!k);};
c.prototype.isSelectionSynchronized=function(){var i=this.getSelectedItem();return this.getSelectedKey()===(i&&i.getKey());};
c.prototype.synchronizeSelection=function(){if(this.isSelectionSynchronized()){return;}var k=this.getSelectedKey(),i=this.getItemByKey(""+k);if(i&&(k!=="")){this.setAssociation("selectedItem",i,true);this.setProperty("selectedItemId",i.getId(),true);if(this._sValue===this.getValue()){this.setValue(i.getText());this._sValue=this.getValue();}}};
c.prototype.isFiltered=function(){var L=this.getList();return L&&(L.getVisibleItems().length!==L.getItems().length);};
c.prototype.isItemVisible=function(i){return i&&(i.bVisible===undefined||i.bVisible);};
c.prototype.createPicker=function(p){var o=this.getAggregation("picker");if(o){return o;}o=this["create"+p]();this.setAggregation("picker",o,true);var d=this.getRenderer().CSS_CLASS_COMBOBOXBASE;o.setHorizontalScrolling(false).addStyleClass(d+"Picker").addStyleClass(d+"Picker-CTX").attachBeforeOpen(this.onBeforeOpen,this).attachAfterOpen(this.onAfterOpen,this).attachBeforeClose(this.onBeforeClose,this).attachAfterClose(this.onAfterClose,this).addEventDelegate({onBeforeRendering:this.onBeforeRenderingPicker,onAfterRendering:this.onAfterRenderingPicker},this).addContent(this.createList());return o;};
c.prototype.createList=function(){var r=this.getRenderer();this._oList=new S({width:"100%",busyIndicatorDelay:0}).addStyleClass(r.CSS_CLASS_COMBOBOXBASE+"List").addStyleClass(r.CSS_CLASS_COMBOBOX+"List").addEventDelegate({ontap:function(e){this.close();},onBeforeRendering:this.onBeforeRenderingList,onAfterRendering:this.onAfterRenderingList},this).attachSelectionChange(this.onSelectionChange,this).attachItemPress(this.onItemPress,this);return this._oList;};
c.prototype.isItemSelected=function(i){return i&&(i.getId()===this.getAssociation("selectedItem"));};
c.prototype.getDefaultSelectedItem=function(){return null;};
c.prototype.getChangeEventParams=function(){return{itemPressed:false};};
c.prototype.clearSelection=function(){this.setSelection(null);};
c.prototype.selectText=function(i,d){a.prototype.selectText.apply(this,arguments);this.textSelectionStart=i;this.textSelectionEnd=d;return this;};
c.prototype.addAggregation=function(A,o,d){this._callMethodInControl("addAggregation",arguments);if(A==="items"&&!d&&!this.isInvalidateSuppressed()){this.invalidate(o);}return this;};
c.prototype.getAggregation=function(){return this._callMethodInControl("getAggregation",arguments);};
c.prototype.setAssociation=function(A,i,d){var L=this.getList();if(L&&(A==="selectedItem")){S.prototype.setAssociation.apply(L,arguments);}return a.prototype.setAssociation.apply(this,arguments);};
c.prototype.indexOfAggregation=function(){return this._callMethodInControl("indexOfAggregation",arguments);};
c.prototype.insertAggregation=function(){this._callMethodInControl("insertAggregation",arguments);return this;};
c.prototype.removeAggregation=function(){return this._callMethodInControl("removeAggregation",arguments);};
c.prototype.removeAllAggregation=function(){return this._callMethodInControl("removeAllAggregation",arguments);};
c.prototype.destroyAggregation=function(A,d){this._callMethodInControl("destroyAggregation",arguments);return this;};
c.prototype.setProperty=function(p,v,d){var L=this.getList();if(/selectedKey|selectedItemId/.test(p)){L&&S.prototype.setProperty.apply(L,arguments);}return a.prototype.setProperty.apply(this,arguments);};
c.prototype.removeAllAssociation=function(A,d){var L=this.getList();if(L&&(A==="selectedItem")){S.prototype.removeAllAssociation.apply(L,arguments);}return a.prototype.removeAllAssociation.apply(this,arguments);};
c.prototype.clone=function(I){var o=a.prototype.clone.apply(this,arguments),L=this.getList();if(!this.isBound("items")&&L){for(var i=0,d=L.getItems();i<d.length;i++){o.addItem(d[i].clone());}o.setSelectedIndex(this.indexOfItem(this.getSelectedItem()));}return o;};
c.prototype.findAggregatedObjects=function(){var L=this.getList();if(L){return S.prototype.findAggregatedObjects.apply(L,arguments);}return[];};
c.prototype.setShowSecondaryValues=function(A){this.setProperty("showSecondaryValues",A,true);var L=this.getList();if(L){L.setShowSecondaryValues(A);}return this;};
c.prototype.getItems=function(){var L=this.getList();return L?L.getItems():[];};
c.prototype.setSelectedItem=function(i){if(typeof i==="string"){this.setAssociation("selectedItem",i,true);i=sap.ui.getCore().byId(i);}if(!(i instanceof sap.ui.core.Item)&&i!==null){return this;}if(!i){i=this.getDefaultSelectedItem();}this.setSelection(i);this.setValue(this._getSelectedItemText(i));return this;};
c.prototype.setSelectedItemId=function(i){i=this.validateProperty("selectedItemId",i);if(!i){i=this.getDefaultSelectedItem();}this.setSelection(i);i=this.getSelectedItem();this.setValue(this._getSelectedItemText(i));return this;};
c.prototype.setSelectedKey=function(k){k=this.validateProperty("selectedKey",k);var d=(k===""),e=this.isBound("selectedKey")&&this.isBound("value")&&this.getBindingInfo("selectedKey").skipModelUpdate;if(d){this.setSelection(null);if(!e){this.setValue("");}return this;}var i=this.getItemByKey(k);if(i){this.setSelection(i);if(!e){this.setValue(this._getSelectedItemText(i));}return this;}this._sValue=this.getValue();return this.setProperty("selectedKey",k);};
c.prototype.getSelectedItem=function(){var v=this.getAssociation("selectedItem");return(v===null)?null:sap.ui.getCore().byId(v)||null;};
c.prototype.updateItems=function(){var r,o=this.getSelectedItem(),r=a.prototype.updateItems.apply(this,arguments);q.sap.clearDelayedCall(this._debounceItemsUpdate);this._debounceItemsUpdate=q.sap.delayedCall(0,this,"_syncItemsSelection",[o]);return r;};
c.prototype._syncItemsSelection=function(o){var H,n,d=this.getSelectedKey();if(!o||o===this.getSelectedItem()){return;}n=this.getItems();H=n.some(function(i){return d===i.getKey();});this.setSelectedItem(H&&d?this.getItemByKey(d):null);};
c.prototype.removeItem=function(i){i=a.prototype.removeItem.apply(this,arguments);var I;if(this.isBound("items")&&!this.bItemsUpdated){return i;}var v=this.getValue();if(this.getItems().length===0){this.clearSelection();}else if(this.isItemSelected(i)){I=this.getDefaultSelectedItem();this.setSelection(I);this.setValue(v);}return i;};
return c;},true);
sap.ui.predefine('sap/m/ComboBoxBase',['jquery.sap.global','./Dialog','./ComboBoxTextField','./Toolbar','./Button','./Bar','./Text','./Title','./SelectList','./Popover','sap/ui/core/InvisibleText','sap/ui/core/IconPool','sap/ui/core/ValueStateSupport','./library','sap/ui/Device'],function(q,D,C,T,B,a,b,c,S,P,I,d,V,l,e){"use strict";
var f=C.extend("sap.m.ComboBoxBase",{metadata:{library:"sap.m","abstract":true,defaultAggregation:"items",aggregations:{items:{type:"sap.ui.core.Item",multiple:true,singularName:"item",bindable:"bindable"},picker:{type:"sap.ui.core.PopupInterface",multiple:false,visibility:"hidden"}},events:{loadItems:{}}}});
var p;
f.prototype.updateItems=function(r){this.bItemsUpdated=false;this.destroyItems();this.updateAggregation("items");this.bItemsUpdated=true;if(this.hasLoadItemsEventListeners()){this.onItemsLoaded();}};
f.prototype.refreshItems=function(){this.bItemsUpdated=false;this.refreshAggregation("items");};
f.prototype.loadItems=function(g,o){var h=typeof g==="function";if(this.hasLoadItemsEventListeners()&&(this.getItems().length===0)){this._bOnItemsLoadedScheduled=false;if(h){o=q.extend({action:g,busyIndicator:true,busyIndicatorDelay:300},o);this.aMessageQueue.push(o);if((this.iLoadItemsEventInitialProcessingTimeoutID===-1)&&(o.busyIndicator)){this.iLoadItemsEventInitialProcessingTimeoutID=setTimeout(function onItemsNotLoadedAfterDelay(){this.setInternalBusyIndicatorDelay(0);this.setInternalBusyIndicator(true);}.bind(this),o.busyIndicatorDelay);}}if(!this.bProcessingLoadItemsEvent){this.bProcessingLoadItemsEvent=true;this.fireLoadItems();}}else if(h){g.call(this);}};
f.prototype.onItemsLoaded=function(){this.bProcessingLoadItemsEvent=false;clearTimeout(this.iLoadItemsEventInitialProcessingTimeoutID);if(this.bInitialBusyIndicatorState!==this.getBusy()){this.setInternalBusyIndicator(this.bInitialBusyIndicatorState);}if(this.iInitialBusyIndicatorDelay!==this.getBusyIndicatorDelay()){this.setInternalBusyIndicatorDelay(this.iInitialBusyIndicatorDelay);}for(var i=0,m,n,g;i<this.aMessageQueue.length;i++){m=this.aMessageQueue.shift();i--;g=(i+1)===this.aMessageQueue.length;n=g?null:this.aMessageQueue[i+1];if(typeof m.action==="function"){if((m.name==="input")&&!g&&(n.name==="input")){continue;}m.action.call(this);}}};
f.prototype.hasLoadItemsEventListeners=function(){return this.hasListeners("loadItems");};
f.prototype._scheduleOnItemsLoadedOnce=function(){if(!this._bOnItemsLoadedScheduled&&!this.isBound("items")&&this.hasLoadItemsEventListeners()&&this.bProcessingLoadItemsEvent){this._bOnItemsLoadedScheduled=true;setTimeout(this.onItemsLoaded.bind(this),0);}};
f.prototype.getPickerInvisibleTextId=function(){if(!sap.ui.getCore().getConfiguration().getAccessibility()){return"";}var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");if(!p){p=new I({text:r.getText("COMBOBOX_AVAILABLE_OPTIONS")}).toStatic().getId();}return p;};
f.prototype.init=function(){C.prototype.init.apply(this,arguments);this.setPickerType(e.system.phone?"Dialog":"Dropdown");if(e.system.phone){this.attachEvent("_change",this.onPropertyChange,this);}this.createPicker(this.getPickerType());this.bItemsUpdated=false;this.bOpenedByKeyboardOrButton=false;this._oPickerValueStateText=null;this.bProcessingLoadItemsEvent=false;this.iLoadItemsEventInitialProcessingTimeoutID=-1;this.aMessageQueue=[];this.bInitialBusyIndicatorState=this.getBusy();this.iInitialBusyIndicatorDelay=this.getBusyIndicatorDelay();this._bOnItemsLoadedScheduled=false;this._bDoTypeAhead=true;};
f.prototype.onBeforeRendering=function(){var n=this.getValueState()===sap.ui.core.ValueState.None;C.prototype.onBeforeRendering.apply(this,arguments);if(!this.isPickerDialog()&&n){this._showValueStateText(false);}};
f.prototype.exit=function(){C.prototype.exit.apply(this,arguments);if(this.getList()){this.getList().destroy();this._oList=null;}if(this._oPickerValueStateText){this._oPickerValueStateText.destroy();}clearTimeout(this.iLoadItemsEventInitialProcessingTimeoutID);this.aMessageQueue=null;};
f.prototype.ontouchstart=function(E){if(!this.getEnabled()||!this.getEditable()){return;}E.setMarked();if(this.isOpenArea(E.target)){this.addStyleClass(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Pressed");}};
f.prototype.ontouchend=function(E){if(!this.getEnabled()||!this.getEditable()){return;}E.setMarked();if(!this.isOpen()&&this.isOpenArea(E.target)){this.removeStyleClass(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Pressed");}};
f.prototype.ontap=function(E){C.prototype.ontap.apply(this,arguments);var g=this.getRenderer().CSS_CLASS_COMBOBOXBASE,o=E.srcControl,h;if(!this.getEnabled()||!this.getEditable()){return;}E.setMarked();if(o.isOpenArea&&o.isOpenArea(E.target)){if(this.isOpen()){this.close();this.removeStyleClass(g+"Pressed");return;}this.loadItems();this.bOpenedByKeyboardOrButton=true;if(this.isPlatformTablet()){h=this.getPicker();h.setInitialFocus(h);}this.open();}if(this.isOpen()){this.addStyleClass(g+"Pressed");}};
f.prototype.onsapshow=function(E){if(!this.getEnabled()||!this.getEditable()){return;}E.setMarked();if(E.keyCode===q.sap.KeyCodes.F4){this.onF4(E);}if(this.isOpen()){this.close();return;}this.selectText(0,this.getValue().length);this.loadItems();this.bOpenedByKeyboardOrButton=true;this.open();};
f.prototype.onF4=function(E){E.preventDefault();};
f.prototype.onsapescape=function(E){if(this.getEnabled()&&this.getEditable()&&this.isOpen()){E.setMarked();E.preventDefault();this.close();}else{C.prototype.onsapescape.apply(this,arguments);}};
f.prototype.onsaphide=f.prototype.onsapshow;
f.prototype.onsapfocusleave=function(E){if(!E.relatedControlId){C.prototype.onsapfocusleave.apply(this,arguments);return;}var r=sap.ui.getCore().byId(E.relatedControlId);if(r===this){return;}var o=this.getAggregation("picker"),F=r&&r.getFocusDomRef();if(o&&q.sap.containsOrEquals(o.getFocusDomRef(),F)){return;}C.prototype.onsapfocusleave.apply(this,arguments);};
f.prototype.getPopupAnchorDomRef=function(){return this.getDomRef();};
f.prototype.addContent=function(o){};
f.prototype.getList=function(){if(this.bIsDestroyed){return null;}return this._oList;};
f.prototype.setPickerType=function(s){this._sPickerType=s;};
f.prototype.getPickerType=function(){return this._sPickerType;};
f.prototype.setValueState=function(v){var A,s=this.getValueStateText(),g=(v===sap.ui.core.ValueState.None?false:this.getShowValueStateMessage());this._sOldValueState=this.getValueState();C.prototype.setValueState.apply(this,arguments);this._showValueStateText(g);if(s){this._setValueStateText(s);}else{A=V.getAdditionalText(this);this._setValueStateText(A);}this._alignValueStateStyles();return this;};
f.prototype.setValueStateText=function(t){C.prototype.setValueStateText.apply(this,arguments);this._setValueStateText(this.getValueStateText());return this;};
f.prototype.setShowValueStateMessage=function(s){C.prototype.setShowValueStateMessage.apply(this,arguments);this._showValueStateText(this.getShowValueStateMessage());return this;};
f.prototype._showValueStateText=function(s){var o;if(this.isPickerDialog()){if(this._oPickerValueStateText){this._oPickerValueStateText.setVisible(s);}}else{o=this._getPickerCustomHeader();if(o){o.setVisible(s);}}};
f.prototype._setValueStateText=function(t){var h;if(this.isPickerDialog()){this._oPickerValueStateText=this.getPickerValueStateText();this._oPickerValueStateText.setText(t);}else{h=this._getPickerCustomHeader();if(h){h.getContentLeft()[0].setText(t);}}};
f.prototype._getPickerCustomHeader=function(){var i,o,g=this.getPicker(),s=this.getRenderer().CSS_CLASS_COMBOBOXBASE+"PickerTitle";if(!g){return null;}if(g.getCustomHeader()){return g.getCustomHeader();}i=new c({textAlign:"Left"}).addStyleClass(s);o=new a({visible:false,contentLeft:i});g.setCustomHeader(o);return o;};
f.prototype._alignValueStateStyles=function(){var o=this._sOldValueState,g=this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Picker",s=g+"ValueState",O=g+o+"State",h=g+this.getValueState()+"State",i;if(this.isPickerDialog()&&this._oPickerValueStateText){this._oPickerValueStateText.addStyleClass(s);this._oPickerValueStateText.removeStyleClass(O);this._oPickerValueStateText.addStyleClass(h);}else{i=this._getPickerCustomHeader();if(i){i.addStyleClass(s);i.removeStyleClass(O);i.addStyleClass(h);}}};
f.prototype.shouldValueStateMessageBeOpened=function(){var s=C.prototype.shouldValueStateMessageBeOpened.apply(this,arguments);return(s&&!this.isOpen());};
f.prototype.onPropertyChange=function(o,g){var n=o.getParameter("newValue"),s=o.getParameter("name"),m="set"+s.charAt(0).toUpperCase()+s.slice(1),h=(g&&g.srcControl)||this.getPickerTextField();if(/\bvalue\b|\benabled\b|\bname\b|\bplaceholder\b|\beditable\b|\btextAlign\b|\btextDirection\b|\bvalueState\b/.test(s)&&h&&(typeof h[m]==="function")){h[m](n);}};
f.prototype.isPickerDialog=function(){return this.getPickerType()==="Dialog";};
f.prototype.isPlatformTablet=function(){var n=!e.system.combi,t=e.system.tablet&&n;return t;};
f.prototype.getDropdownSettings=function(){return{showArrow:false,placement:sap.m.PlacementType.VerticalPreferredBottom,offsetX:0,offsetY:0,bounce:false,ariaLabelledBy:this.getPickerInvisibleTextId()||undefined};};
f.prototype.getPickerValueStateText=function(){var o=this.getPicker();if(!this._oPickerValueStateText){this._oPickerValueStateText=new b({width:"100%"});o.insertContent(this._oPickerValueStateText,0);}return this._oPickerValueStateText;};
f.prototype.createPicker=function(s){};
f.prototype.onBeforeClose=function(){this.bOpenedByKeyboardOrButton=false;};
f.prototype.getPicker=function(){if(this.bIsDestroyed){return null;}return this.createPicker(this.getPickerType());};
f.prototype.getPickerTextField=function(){var o=this.getPicker(),s=o.getSubHeader();return s&&s.getContent()[0]||null;};
f.prototype.getPickerTitle=function(){var o=this.getPicker(),h=o&&o.getCustomHeader();if(this.isPickerDialog()&&h){return h.getContentMiddle()[0];}return null;};
f.prototype.createDialog=function(){var t=this,o=this.createPickerTextField(),g=o._handleEvent;o._handleEvent=function(E){g.apply(this,arguments);if(/keydown|sapdown|sapup|saphome|sapend|sappagedown|sappageup|input/.test(E.type)){t._handleEvent(E);}};return new D({stretch:true,customHeader:t.createPickerHeader(),buttons:this.createPickerCloseButton(),subHeader:new T({content:o}),beforeOpen:function(){t.updatePickerHeaderTitle();},ariaLabelledBy:t.getPickerInvisibleTextId()||undefined});};
f.prototype.createPickerHeader=function(){var t=this,i=d.getIconURI("decline");return new a({contentMiddle:new c(),contentRight:new B({icon:i,press:function(){t.close();t.revertSelection();}})});};
f.prototype.revertSelection=function(){};
f.prototype.updatePickerHeaderTitle=function(){var o=this.getPicker(),r=sap.ui.getCore().getLibraryResourceBundle("sap.m"),L,g;if(!o){return;}g=this.getLabels();if(g.length){L=g[0];if(L&&(typeof L.getText==="function")){this.getPickerTitle().setText(L.getText());}}else{this.getPickerTitle().setText(r.getText("COMBOBOX_PICKER_TITLE"));}};
f.prototype.createPickerCloseButton=function(){var t=this,o,r=sap.ui.getCore().getLibraryResourceBundle("sap.m");return new B({text:r.getText("COMBOBOX_CLOSE_BUTTON"),press:function(){o=t.getPickerTextField();t.updateDomValue(o.getValue());t.onChange();t.close();}});};
f.prototype.hasContent=function(){return this.getItems().length>0;};
f.prototype.findFirstEnabledItem=function(i){var L=this.getList();return L?L.findFirstEnabledItem(i):null;};
f.prototype.findLastEnabledItem=function(i){var L=this.getList();return L?L.findLastEnabledItem(i):null;};
f.prototype.open=function(){var o=this.getPicker();if(o){o.open();}return this;};
f.prototype.getVisibleItems=function(){var L=this.getList();return L?L.getVisibleItems():[];};
f.prototype.isItemSelected=function(){};
f.prototype.getKeys=function(g){g=g||this.getItems();for(var i=0,k=[];i<g.length;i++){k[i]=g[i].getKey();}return k;};
f.prototype.getSelectableItems=function(){var L=this.getList();return L?L.getSelectableItems():[];};
f.prototype.findItem=function(s,v){var L=this.getList();return L?L.findItem(s,v):null;};
f.prototype.getItemByText=function(t){return this.findItem("text",t);};
f.prototype.scrollToItem=function(i){var o=this.getPicker(),g=o.getDomRef("cont"),h=i&&i.getDomRef();if(!o||!g||!h){return;}var j=g.scrollTop,k=h.offsetTop,m=g.clientHeight,n=h.offsetHeight;if(j>k){g.scrollTop=k;}else if((k+n)>(j+m)){g.scrollTop=Math.ceil(k+n-m);}};
f.prototype.clearFilter=function(){for(var i=0,g=this.getItems();i<g.length;i++){g[i].bVisible=true;}};
f.prototype.onItemChange=function(o){};
f.prototype.clearSelection=function(){};
f.prototype.setInternalBusyIndicator=function(g){this.bInitialBusyIndicatorState=this.getBusy();return this.setBusy.apply(this,arguments);};
f.prototype.setInternalBusyIndicatorDelay=function(i){this.iInitialBusyIndicatorDelay=this.getBusyIndicatorDelay();return this.setBusyIndicatorDelay.apply(this,arguments);};
f.prototype.addItem=function(i){this.addAggregation("items",i);if(i){i.attachEvent("_change",this.onItemChange,this);}this._scheduleOnItemsLoadedOnce();return this;};
f.prototype.insertItem=function(i,g){this.insertAggregation("items",i,g,true);if(i){i.attachEvent("_change",this.onItemChange,this);}this._scheduleOnItemsLoadedOnce();return this;};
f.prototype.getItemAt=function(i){return this.getItems()[+i]||null;};
f.prototype.getFirstItem=function(){return this.getItems()[0]||null;};
f.prototype.getLastItem=function(){var i=this.getItems();return i[i.length-1]||null;};
f.prototype.getEnabledItems=function(i){var L=this.getList();return L?L.getEnabledItems(i):[];};
f.prototype.getItemByKey=function(k){var L=this.getList();return L?L.getItemByKey(k):null;};
f.prototype.isOpen=function(){var o=this.getAggregation("picker");return!!(o&&o.isOpen());};
f.prototype.close=function(){var o=this.getAggregation("picker");if(o){o.close();}return this;};
f.prototype.removeItem=function(i){var L=this.getList();i=L?L.removeItem(i):null;if(i){i.detachEvent("_change",this.onItemChange,this);}return i;};
f.prototype.removeAllItems=function(){var L=this.getList(),g=L?L.removeAllItems():[];this.clearSelection();for(var i=0;i<g.length;i++){g[i].detachEvent("_change",this.onItemChange,this);}return g;};
f.prototype.destroyItems=function(){var L=this.getList();if(L){L.destroyItems();}return this;};
return f;},true);
sap.ui.predefine('sap/m/ComboBoxBaseRenderer',['jquery.sap.global','./ComboBoxTextFieldRenderer','sap/ui/core/Renderer'],function(q,C,R){"use strict";var a=R.extend(C);a.CSS_CLASS_COMBOBOXBASE="sapMComboBoxBase";
a.getAccessibilityState=function(c){var A=C.getAccessibilityState.call(this,c);A.expanded=c.isOpen();return A;};
a.addOuterClasses=function(r,c){C.addOuterClasses.apply(this,arguments);var b=a.CSS_CLASS_COMBOBOXBASE;r.addClass(b);if(!c.getEnabled()){r.addClass(b+"Disabled");}if(!c.getEditable()){r.addClass(b+"Readonly");}};
a.addButtonClasses=function(r,c){C.addButtonClasses.apply(this,arguments);r.addClass(a.CSS_CLASS_COMBOBOXBASE+"Arrow");};
return a;},true);
sap.ui.predefine('sap/m/ComboBoxRenderer',['jquery.sap.global','./ComboBoxBaseRenderer','sap/ui/core/Renderer'],function(q,C,R){"use strict";var a=R.extend(C);a.CSS_CLASS_COMBOBOX="sapMComboBox";
a.addOuterClasses=function(r,c){C.addOuterClasses.apply(this,arguments);r.addClass(a.CSS_CLASS_COMBOBOX);};
a.addInnerClasses=function(r,c){C.addInnerClasses.apply(this,arguments);r.addClass(a.CSS_CLASS_COMBOBOX+"Inner");};
a.addButtonClasses=function(r,c){C.addButtonClasses.apply(this,arguments);r.addClass(a.CSS_CLASS_COMBOBOX+"Arrow");};
a.addPlaceholderClasses=function(r,c){C.addPlaceholderClasses.apply(this,arguments);r.addClass(a.CSS_CLASS_COMBOBOX+"Placeholder");};
return a;},true);
sap.ui.predefine('sap/m/ComboBoxTextField',['jquery.sap.global','./InputBase','./library','sap/ui/core/InvisibleText'],function(q,I,l,a){"use strict";
var C=I.extend("sap.m.ComboBoxTextField",{metadata:{library:"sap.m",properties:{maxWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},showButton:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{_buttonLabelText:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"}}}});
C.prototype.init=function(){I.prototype.init.apply(this,arguments);var r,A;if(sap.ui.getCore().getConfiguration().getAccessibility()){r=sap.ui.getCore().getLibraryResourceBundle("sap.m");A=new a({text:r.getText("COMBOBOX_BUTTON")});this.setAggregation("_buttonLabelText",A,true);}};
C.prototype.updateValueStateClasses=function(v,o){I.prototype.updateValueStateClasses.apply(this,arguments);var V=sap.ui.core.ValueState,b=this.getRenderer().CSS_CLASS_COMBOBOXTEXTFIELD,d=this.$();if(o!==V.None){d.removeClass(b+"State "+b+o);}if(v!==V.None){d.addClass(b+"State "+b+v);}};
C.prototype.getOpenArea=function(){return this.getDomRef("arrow");};
C.prototype.isOpenArea=function(d){var o=this.getOpenArea();return o&&o.contains(d);};
C.prototype.onsapenter=function(e){I.prototype.onsapenter.apply(this,arguments);if(!this.getEnabled()||!this.getEditable()){return;}e.setMarked();var v=this.getValue(),V=v.length;this.setValue(v);this.selectText(V,V);};
C.prototype.bShowLabelAsPlaceholder=sap.ui.Device.browser.msie;
C.prototype.getValue=function(){var d=this.getFocusDomRef();if(d){return d.value;}return this.getProperty("value");};
C.prototype.getDomRefForValueStateMessage=function(){return this.getDomRef();};
C.prototype.getAccessibilityInfo=function(){var i=I.prototype.getAccessibilityInfo.apply(this,arguments);i.type=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_COMBO");return i;};
return C;},true);
sap.ui.predefine('sap/m/ComboBoxTextFieldRenderer',['jquery.sap.global','./InputBaseRenderer','sap/ui/core/Renderer'],function(q,I,R){"use strict";var C=R.extend(I);C.CSS_CLASS_COMBOBOXTEXTFIELD="sapMComboBoxTextField";
C.writeInnerAttributes=function(r,c){r.writeAttribute("autocomplete","off");r.writeAttribute("autocorrect","off");r.writeAttribute("autocapitalize","off");r.writeAttribute("type","text");};
C.writeOuterAttributes=function(r,c){if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAttribute("role","combobox");}};
C.getAriaRole=function(){};
C.getAccessibilityState=function(c){var a=I.getAccessibilityState.call(this,c);a.autocomplete="both";return a;};
C.addOuterStyles=function(r,c){r.addStyle("max-width",c.getMaxWidth());};
C.addOuterClasses=function(r,c){var a=C.CSS_CLASS_COMBOBOXTEXTFIELD;r.addClass(a);if(!c.getEnabled()){r.addClass(a+"Disabled");}if(!c.getEditable()){r.addClass(a+"Readonly");}};
C.addPaddingClass=q.noop;
C.addInnerClasses=function(r,c){var a=C.CSS_CLASS_COMBOBOXTEXTFIELD;r.addClass(a+"Inner");if(!c.getEditable()){r.addClass(a+"InnerReadonly");}if(c.getShowButton()){r.addClass(a+"InnerWidthExtraPadding");}};
C.addValueStateClasses=function(r,c){var a=C.CSS_CLASS_COMBOBOXTEXTFIELD;r.addClass(a+"State");r.addClass(a+c.getValueState());};
C.writeDecorations=function(r,c){if(c.getShowButton()){this.renderButton(r,c);}};
C.renderButton=function(r,c){var i=c.getId(),b=i+"-arrow",a=sap.ui.getCore().getConfiguration().getAccessibility(),A=c.getAggregation("_buttonLabelText");r.write('<span tabindex="-1" ');r.writeAttribute("id",b);if(a){r.writeAttribute("role","button");r.writeAttribute("aria-labelledby",A.getId());}this.addButtonClasses(r,c);r.writeClasses();r.write(">");a&&r.renderControl(A);r.write("</span>");};
C.addButtonClasses=function(r,c){var a=C.CSS_CLASS_COMBOBOXTEXTFIELD+"Arrow";r.addClass(a);if(!c.getEnabled()){r.addClass(a+"Disabled");}};
return C;},true);
sap.ui.predefine('sap/m/CustomListItem.designtime',[],function(){"use strict";return{aggregations:{content:{domRef:":sap-domref > .sapMLIBContent",actions:{move:"moveControls"}}}};},false);
sap.ui.predefine('sap/m/CustomListItem',['jquery.sap.global','./ListItemBase','./library'],function(q,L,l){"use strict";
var C=L.extend("sap.m.CustomListItem",{metadata:{library:"sap.m",defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",bindable:"bindable"}},designTime:true}});
C.prototype.getContentAnnouncement=function(){return this.getContent().map(function(c){return L.getAccessibilityText(c);}).join(" ").trim();};
return C;},true);
sap.ui.predefine('sap/m/CustomListItemRenderer',['jquery.sap.global','./ListItemBaseRenderer','sap/ui/core/Renderer'],function(q,L,R){"use strict";var C=R.extend(L);
C.renderLIAttributes=function(r,l){r.addClass("sapMCLI");};
C.renderLIContent=function(r,l){var c=l.getContent();var a=c.length;for(var i=0;i<a;i++){r.renderControl(c[i]);}};
return C;},true);
sap.ui.predefine('sap/m/CustomTile.designtime',[],function(){"use strict";return{aggregations:{content:{domRef:":sap-domref"}}};},false);
sap.ui.predefine('sap/m/CustomTile',['jquery.sap.global','./Tile','./library'],function(q,T,l){"use strict";
var C=T.extend("sap.m.CustomTile",{metadata:{library:"sap.m",defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:false}},designTime:true}});
return C;},true);
sap.ui.predefine('sap/m/CustomTileRenderer',['jquery.sap.global','./TileRenderer'],function(q,T){"use strict";var C=sap.ui.core.Renderer.extend(T);
C.render=function(r,c){var t,v;r.write("<div tabindex=\"0\"");r.writeControlData(c);r.addClass("sapMCustomTile");r.writeClasses();if(c._invisible){r.addStyle("visibility","hidden");r.writeStyles();}if(c.getParent()instanceof sap.m.TileContainer){t=c.getParent();v=t._getVisibleTiles();r.writeAccessibilityState(c,{role:"option",posinset:t._indexOfVisibleTile(c,v)+1,setsize:v.length});}r.write(">");r.write("<div id=\""+c.getId()+"-remove\" class=\"sapMTCRemove\"></div>");r.write("<div class=\"sapMCustomTileContent\">");this._renderContent(r,c);r.write("</div></div>");};
C._renderContent=function(r,t){r.renderControl(t.getContent());};
return C;},true);
sap.ui.predefine('sap/m/DatePicker.designtime',[],function(){"use strict";return{actions:{remove:{changeType:"hideControl"},reveal:{changeType:"unhideControl"}},name:{singular:"DATEPICKER_NAME",plural:"DATEPICKER_NAME_PLURAL"}};},false);
sap.ui.predefine('sap/m/DatePicker',['jquery.sap.global','sap/ui/Device','./InputBase','./DateTimeField','sap/ui/model/type/Date','sap/ui/model/odata/type/ODataType','sap/ui/core/date/UniversalDate','./library'],function(q,D,I,a,b,O,U,l){"use strict";
var c=a.extend("sap.m.DatePicker",{metadata:{library:"sap.m",properties:{displayFormatType:{type:"string",group:"Appearance",defaultValue:""},secondaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance",defaultValue:null},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null}},aggregations:{specialDates:{type:"sap.ui.core.Element",multiple:true,singularName:"specialDate"}},associations:{legend:{type:"sap.ui.core.Control",multiple:false}},events:{navigate:{parameters:{dateRange:{type:"sap.ui.unified.DateRange"}}}},designTime:true}});
c.prototype.init=function(){I.prototype.init.apply(this,arguments);this._bIntervalSelection=false;this._bOnlyCalendar=true;this._bDatePickerInstance=this.getMetadata().getName()==="sap.m.DatePicker";this._bValid=true;this._oMinDate=new Date(1,0,1);this._oMinDate.setFullYear(1);this._oMaxDate=this._bDatePickerInstance?new Date(9999,11,31):new Date(9999,11,31,23,59,59,99);};
c.prototype.exit=function(){I.prototype.exit.apply(this,arguments);if(this._oPopup){if(this._oPopup.isOpen()){this._oPopup.close();}delete this._oPopup;}if(this._oCalendar){this._oCalendar.destroy();delete this._oCalendar;}if(this._iInvalidateCalendar){q.sap.clearDelayedCall(this._iInvalidateCalendar);}this._sUsedDisplayPattern=undefined;this._sUsedDisplayCalendarType=undefined;this._oDisplayFormat=undefined;this._sUsedValuePattern=undefined;this._sUsedValueCalendarType=undefined;this._oValueFormat=undefined;this._bDatePickerInstance=undefined;};
c.prototype.invalidate=function(o){if(!o||o!=this._oCalendar){sap.ui.core.Control.prototype.invalidate.apply(this,arguments);this._iInvalidateCalendar=q.sap.delayedCall(0,this,k);}};
c.prototype.onBeforeRendering=function(){I.prototype.onBeforeRendering.apply(this,arguments);this._checkMinMaxDate();};
c.prototype.setWidth=function(w){return I.prototype.setWidth.call(this,w||"100%");};
c.prototype.getWidth=function(w){return this.getProperty("width")||"100%";};
c.prototype.applyFocusInfo=function(F){this._bFocusNoPopup=true;I.prototype.applyFocusInfo.apply(this,arguments);};
c.prototype.onfocusin=function(E){if(!q(E.target).hasClass("sapUiIcon")){I.prototype.onfocusin.apply(this,arguments);}this._bFocusNoPopup=undefined;};
c.prototype.onsapshow=function(E){d.call(this);E.preventDefault();};
c.prototype.onsaphide=c.prototype.onsapshow;
c.prototype.onsappageup=function(E){f.call(this,1,"day");E.preventDefault();};
c.prototype.onsappageupmodifiers=function(E){if(!E.ctrlKey&&E.shiftKey){f.call(this,1,"month");}else{f.call(this,1,"year");}E.preventDefault();};
c.prototype.onsappagedown=function(E){f.call(this,-1,"day");E.preventDefault();};
c.prototype.onsappagedownmodifiers=function(E){if(!E.ctrlKey&&E.shiftKey){f.call(this,-1,"month");}else{f.call(this,-1,"year");}E.preventDefault();};
c.prototype.onkeypress=function(E){if(!E.charCode||E.metaKey||E.ctrlKey){return;}var F=this._getFormatter(true);var C=String.fromCharCode(E.charCode);if(C&&F.sAllowedCharacters&&F.sAllowedCharacters.indexOf(C)<0){E.preventDefault();}};
c.prototype.onclick=function(E){if(q(E.target).hasClass("sapUiIcon")){d.call(this);}};
c.prototype._dateValidation=function(o){if(o&&(o.getTime()<this._oMinDate.getTime()||o.getTime()>this._oMaxDate.getTime())){this._bValid=false;this._oWantedDate=o;o=undefined;}else{this._bValid=true;this.setProperty("dateValue",o,true);this._oWantedDate=undefined;}return o;};
c.prototype.setMinDate=function(o){if(o&&!(o instanceof Date)){throw new Error("Date must be a JavaScript date object; "+this);}if(q.sap.equal(this.getMinDate(),o)){return this;}if(o){var y=o.getFullYear();if(y<1||y>9999){throw new Error("Date must be between 0001-01-01 and 9999-12-31; "+this);}this._oMinDate=new Date(o.getTime());var m=this.getDateValue();if(m&&m.getTime()<o.getTime()){q.sap.log.warning("DateValue not in valid date -> changed to minDate",this);this.setDateValue(new Date(o.getTime()));}}else{this._oMinDate=new Date(1,0,1);this._oMinDate.setFullYear(1);}this.setProperty("minDate",o,false);if(this._oCalendar){this._oCalendar.setMinDate(o);}if(this._bDatePickerInstance){this._oMinDate.setHours(0,0,0,0);}return this;};
c.prototype.setMaxDate=function(o){if(o&&!(o instanceof Date)){throw new Error("Date must be a JavaScript date object; "+this);}if(q.sap.equal(this.getMaxDate(),o)){return this;}if(o){var y=o.getFullYear();if(y<1||y>9999){throw new Error("Date must be between 0001-01-01 and 9999-12-31; "+this);}this._oMaxDate=new Date(o.getTime());var m=this.getDateValue();if(m&&m.getTime()>o.getTime()){q.sap.log.warning("DateValue not in valid date -> changed to maxDate",this);this.setDateValue(new Date(o.getTime()));}}else{this._oMaxDate=new Date(9999,11,31,23,59,59,99);}this.setProperty("maxDate",o,false);if(this._oCalendar){this._oCalendar.setMaxDate(o);}if(this._bDatePickerInstance){this._oMaxDate.setHours(0,0,0,0);}return this;};
c.prototype._checkMinMaxDate=function(){if(this._oMinDate.getTime()>this._oMaxDate.getTime()){q.sap.log.warning("minDate > MaxDate -> dates switched",this);var m=new Date(this._oMinDate.getTime());var M=new Date(this._oMaxDate.getTime());this._oMinDate=new Date(M.getTime());this._oMaxDate=new Date(m.getTime());this.setProperty("minDate",M,true);this.setProperty("maxDate",m,true);if(this._oCalendar){this._oCalendar.setMinDate(M);this._oCalendar.setMaxDate(m);}}if(this._oWantedDate&&this._oWantedDate.getTime()>=this._oMinDate.getTime()&&this._oWantedDate.getTime()<=this._oMaxDate.getTime()){this.setDateValue(this._oWantedDate);}};
c.prototype.getDisplayFormatType=function(){return this.getProperty("displayFormatType");};
c.prototype._handleDateValidation=function(o){if(!o||o.getTime()<this._oMinDate.getTime()||o.getTime()>this._oMaxDate.getTime()){this._bValid=false;q.sap.log.warning("Value can not be converted to a valid date",this);}else{this._bValid=true;this.setProperty("dateValue",o,true);}};
c.prototype.setDisplayFormatType=function(s){if(s){var F=false;for(var t in sap.ui.core.CalendarType){if(t==s){F=true;break;}}if(!F){throw new Error(s+" is not a valid calendar type"+this);}}this.setProperty("displayFormatType",s,true);this.setDisplayFormat(this.getDisplayFormat());return this;};
c.prototype.setSecondaryCalendarType=function(C){this._bSecondaryCalendarTypeSet=true;this.setProperty("secondaryCalendarType",C,true);if(this._oCalendar){this._oCalendar.setSecondaryCalendarType(C);}return this;};
c.prototype.addSpecialDate=function(s){j.call(this,s);this.addAggregation("specialDates",s,true);k.call(this);return this;};
c.prototype.insertSpecialDate=function(s,m){j.call(this,s);this.insertAggregation("specialDates",s,m,true);k.call(this);return this;};
c.prototype.removeSpecialDate=function(s){var r=this.removeAggregation("specialDates",s,true);k.call(this);return r;};
c.prototype.removeAllSpecialDates=function(){var r=this.removeAllAggregation("specialDates",true);k.call(this);return r;};
c.prototype.destroySpecialDates=function(){this.destroyAggregation("specialDates",true);k.call(this);return this;};
c.prototype.setLegend=function(L){this.setAssociation("legend",L,true);var s=this.getLegend();if(s){if(!sap.ui.unified.CalendarLegend){sap.ui.getCore().loadLibrary("sap.ui.unified");q.sap.require("sap.ui.unified.library");}L=sap.ui.getCore().byId(s);if(L&&!(L instanceof sap.ui.unified.CalendarLegend)){throw new Error(L+" is not an sap.ui.unified.CalendarLegend. "+this);}}if(this._oCalendar){this._oCalendar.setLegend(s);}return this;};
c.prototype.onChange=function(E){if(!this.getEditable()||!this.getEnabled()){return;}var v=this._$input.val();var o=this._formatValue(this.getDateValue());if(v==o&&this._bValid){return;}var m;this._oWantedDate=undefined;this._bValid=true;if(v!=""){m=this._parseValue(v,true);if(!m||m.getTime()<this._oMinDate.getTime()||m.getTime()>this._oMaxDate.getTime()){this._bValid=false;m=undefined;}else{v=this._formatValue(m);}}if(this.getDomRef()&&(this._$input.val()!==v)){this._$input.val(v);this._curpos=this._$input.cursorPos();}if(m){v=this._formatValue(m,true);}if(this._lastValue!==v||(m&&this.getDateValue()&&m.getFullYear()!==this.getDateValue().getFullYear())){this._lastValue=v;this.setProperty("value",v,true);var n=this.getValue();if(this._bValid&&v==n){this.setProperty("dateValue",m,true);}v=n;if(this._oPopup&&this._oPopup.isOpen()){if(this._bValid){m=this.getDateValue();}this._oCalendar.focusDate(m);var s=this._oDateRange.getStartDate();if((!s&&m)||(s&&m&&s.getTime()!=m.getTime())){this._oDateRange.setStartDate(new Date(m.getTime()));}else if(s&&!m){this._oDateRange.setStartDate(undefined);}}this.fireChangeEvent(v,{valid:this._bValid});}};
c.prototype._getInputValue=function(v){v=(typeof v=="undefined")?this._$input.val():v.toString();var o=this._parseValue(v,true);v=this._formatValue(o,true);return v;};
c.prototype.updateDomValue=function(v){if(this.isActive()&&(this._$input.val()!==v)){this._bCheckDomValue=true;v=(typeof v=="undefined")?this._$input.val():v.toString();this._curpos=this._$input.cursorPos();var o=this._parseValue(v,true);v=this._formatValue(o);this._$input.val(v);this._$input.cursorPos(this._curpos);}return this;};
function _(){this._createPopup();this._createPopupContent();var C;var B=this.getBinding("value");if(B&&B.oType&&B.oType.oOutputFormat){C=B.oType.oOutputFormat.oFormatOptions.calendarType;}else if(B&&B.oType&&B.oType.oFormat){C=B.oType.oFormat.oFormatOptions.calendarType;}if(!C){C=this.getDisplayFormatType();}if(C){this._oCalendar.setPrimaryCalendarType(C);}var v=this._bValid?this._formatValue(this.getDateValue()):this.getValue();if(v!=this._$input.val()){this.onChange();}this._fillDateRange();this._openPopup();this.fireNavigate({dateRange:this._getVisibleDatesRange(this._oCalendar)});}
c.prototype._createPopup=function(){if(!this._oPopup){q.sap.require("sap.ui.core.Popup");this._oPopup=new sap.ui.core.Popup();this._oPopup.setAutoClose(true);this._oPopup.setDurations(0,0);this._oPopup.attachOpened(g,this);this._oPopup.attachClosed(h,this);}};
c.prototype._openPopup=function(){if(!this._oPopup){return;}this._oPopup.setAutoCloseAreas([this.getDomRef()]);var m=sap.ui.core.Popup.Dock;var A;if(this.getTextAlign()==sap.ui.core.TextAlign.End){A=m.EndBottom+"-4";this._oPopup.open(0,m.EndTop,A,this,null,"fit",true);}else{A=m.BeginBottom+"-4";this._oPopup.open(0,m.BeginTop,A,this,null,"fit",true);}};
c.prototype._getVisibleDatesRange=function(C){var v=C._getVisibleDays();return new sap.ui.unified.DateRange({startDate:v[0].toLocalJSDate(),endDate:v[v.length-1].toLocalJSDate()});};
c.prototype._createPopupContent=function(){if(!this._oCalendar){sap.ui.getCore().loadLibrary("sap.ui.unified");q.sap.require("sap.ui.unified.library");this._oCalendar=new sap.ui.unified.Calendar(this.getId()+"-cal",{intervalSelection:this._bIntervalSelection,minDate:this.getMinDate(),maxDate:this.getMaxDate(),legend:this.getLegend(),startDateChange:function(){this.fireNavigate({dateRange:this._getVisibleDatesRange(this._oCalendar)});}.bind(this)});this._oDateRange=new sap.ui.unified.DateRange();this._oCalendar.addSelectedDate(this._oDateRange);if(this.$().closest(".sapUiSizeCompact").length>0){this._oCalendar.addStyleClass("sapUiSizeCompact");}if(this._bSecondaryCalendarTypeSet){this._oCalendar.setSecondaryCalendarType(this.getSecondaryCalendarType());}if(this._bOnlyCalendar){this._oCalendar.attachSelect(this._selectDate,this);this._oCalendar.attachCancel(e,this);this._oCalendar.attachEvent("_renderMonth",i,this);this._oCalendar.setPopupMode(true);this._oCalendar.setParent(this,undefined,true);this._oPopup.setContent(this._oCalendar);}}};
c.prototype._fillDateRange=function(){var o=this.getDateValue();if(o){this._oCalendar.focusDate(new Date(o.getTime()));if(!this._oDateRange.getStartDate()||this._oDateRange.getStartDate().getTime()!=o.getTime()){this._oDateRange.setStartDate(new Date(o.getTime()));}}else{var F=new Date();var m=this._oMaxDate.getTime()+86400000;if(F.getTime()<this._oMinDate.getTime()||F.getTime()>m){F=this._oMinDate;}this._oCalendar.focusDate(F);if(this._oDateRange.getStartDate()){this._oDateRange.setStartDate(undefined);}}};
c.prototype.getAccessibilityInfo=function(){var r=this.getRenderer();var o=I.prototype.getAccessibilityInfo.apply(this,arguments);var v=this.getValue()||"";if(this._bValid){var m=this.getDateValue();if(m){v=this._formatValue(m);}}o.type=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_DATEINPUT");o.description=[v,r.getLabelledByAnnouncement(this),r.getDescribedByAnnouncement(this)].join(" ").trim();return o;};
function d(){if(this.getEditable()&&this.getEnabled()){if(!this._oPopup||!this._oPopup.isOpen()){_.call(this);}else{e.call(this);}}}
c.prototype._selectDate=function(E){var o=this.getDateValue();var m=this._getSelectedDate();var v="";if(!q.sap.equal(m,o)){this.setDateValue(new Date(m.getTime()));v=this.getValue();this.fireChangeEvent(v,{valid:true});if(this.getDomRef()&&(D.system.desktop||!D.support.touch)&&!q.sap.simulateMobileOnDesktop){this._curpos=this._$input.val().length;this._$input.cursorPos(this._curpos);}}else if(!this._bValid){v=this._formatValue(m);if(v!=this._$input.val()){this._bValid=true;if(this.getDomRef()){this._$input.val(v);this._lastValue=v;}this.setProperty("value",v,true);this.fireChangeEvent(v,{valid:true});}}this._oPopup.close();};
c.prototype._getSelectedDate=function(){var s=this._oCalendar.getSelectedDates();var o;if(s.length>0){o=s[0].getStartDate();}return o;};
function e(E){if(this._oPopup&&this._oPopup.isOpen()){this._oPopup.close();if((D.system.desktop||!D.support.touch)&&!q.sap.simulateMobileOnDesktop){this.focus();}}}
function f(n,u){var o=this.getDateValue();var C=this._$input.cursorPos();if(o&&this.getEditable()&&this.getEnabled()){var s;var B=this.getBinding("value");if(B&&B.oType&&B.oType.oOutputFormat){s=B.oType.oOutputFormat.oFormatOptions.calendarType;}else if(B&&B.oType&&B.oType.oFormat){s=B.oType.oFormat.oFormatOptions.calendarType;}if(!s){s=this.getDisplayFormatType();}var m=U.getInstance(new Date(o.getTime()),s);o=U.getInstance(new Date(o.getTime()),s);switch(u){case"day":m.setDate(m.getDate()+n);break;case"month":m.setMonth(m.getMonth()+n);var M=(o.getMonth()+n)%12;if(M<0){M=12+M;}while(m.getMonth()!=M){m.setDate(m.getDate()-1);}break;case"year":m.setFullYear(m.getFullYear()+n);while(m.getMonth()!=o.getMonth()){m.setDate(m.getDate()-1);}break;default:break;}if(m.getTime()<this._oMinDate.getTime()){m=new U(this._oMinDate.getTime());}else if(m.getTime()>this._oMaxDate.getTime()){m=new U(this._oMaxDate.getTime());}if(!q.sap.equal(this.getDateValue(),m.getJSDate())){this.setDateValue(new Date(m.getTime()));this._curpos=C;this._$input.cursorPos(this._curpos);var v=this.getValue();this.fireChangeEvent(v,{valid:true});}}}
function g(E){this._renderedDays=this._oCalendar.$("-Month0-days").find(".sapUiCalItem").length;this.$("inner").attr("aria-owns",this.getId()+"-cal");this.$("inner").attr("aria-expanded",true);}
function h(E){this.$("inner").attr("aria-expanded",false);}
function i(E){var m=E.getParameter("days");if(m>this._renderedDays){this._renderedDays=m;this._oPopup._applyPosition(this._oPopup._oLastPosition);}}
function j(s){if(!sap.ui.unified.DateTypeRange){sap.ui.getCore().loadLibrary("sap.ui.unified");q.sap.require("sap.ui.unified.library");}if(s&&!(s instanceof sap.ui.unified.DateTypeRange)){throw new Error(s+"is not valid for aggregation \"specialDates\" of "+this);}}
function k(){if(this._oPopup&&this._oPopup.isOpen()){this._oCalendar._bDateRangeChanged=true;this._oCalendar.invalidate();}}
return c;},true);
sap.ui.predefine('sap/m/DatePickerRenderer',['jquery.sap.global','sap/ui/core/Renderer','./InputBaseRenderer'],function(q,R,I){"use strict";var D=R.extend(I);
D.addOuterClasses=function(r,d){r.addClass("sapMDP");if(d.getEnabled()&&d.getEditable()){r.addClass("sapMInputVH");}};
D.writeDecorations=function(r,d){if(d.getEnabled()&&d.getEditable()){var c=["sapMInputValHelpInner"];var a={};a["id"]=d.getId()+"-icon";a["tabindex"]="-1";a["title"]=null;r.write('<div class="sapMInputValHelp">');r.writeIcon(this._getIcon(),c,a);r.write("</div>");}};
D._getIcon=function(){return"sap-icon://appointment-2";};
D.writeInnerValue=function(r,d){if(d._bValid){r.writeAttributeEscaped("value",d._formatValue(d.getDateValue()));}else{r.writeAttributeEscaped("value",d.getValue());}};
D.writeInnerAttributes=function(r,d){r.writeAttribute("type","text");if(d._bMobile){r.writeAttribute("readonly","readonly");}};
D.getAriaRole=function(d){return"combobox";};
D.getDescribedByAnnouncement=function(d){var b=I.getDescribedByAnnouncement.apply(this,arguments);return sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("DATEPICKER_DATE_TYPE")+" "+b;};
D.getAccessibilityState=function(d){var a=I.getAccessibilityState.apply(this,arguments);a["autocomplete"]="none";a["haspopup"]=true;a["expanded"]=false;if(d._bMobile&&d.getEnabled()&&d.getEditable()){a["readonly"]=false;}return a;};
return D;},true);
sap.ui.predefine('sap/m/DateRangeSelection',['jquery.sap.global','sap/ui/Device','./DatePicker','./library'],function(q,D,a,l){"use strict";
var b=a.extend("sap.m.DateRangeSelection",{metadata:{library:"sap.m",properties:{delimiter:{type:"string",group:"Misc",defaultValue:'-'},secondDateValue:{type:"object",group:"Data",defaultValue:null},from:{type:"object",group:"Misc",defaultValue:null,deprecated:true},to:{type:"object",group:"Misc",defaultValue:null,deprecated:true}}}});
b.prototype.init=function(){a.prototype.init.apply(this,arguments);this._bIntervalSelection=true;};
b.prototype.onkeypress=function(E){if(!E.charCode||E.metaKey||E.ctrlKey){return;}var F=e.call(this);var s=d.call(this);var A=F.sAllowedCharacters+s+" ";var C=String.fromCharCode(E.charCode);if(C&&F.sAllowedCharacters&&A.indexOf(C)<0){E.preventDefault();}};
b.prototype._getPlaceholder=function(){var p=this.getPlaceholder();if(!p){p=this.getDisplayFormat();if(!p){p="medium";}if(this._checkStyle(p)){var L=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();var o=sap.ui.core.LocaleData.getInstance(L);p=o.getDatePattern(p);}var s=d.call(this);if(s&&s!==""){p=p+" "+s+" "+p;}}return p;};
b.prototype.setValue=function(v){if(v!==this.getValue()){this._lastValue=v;}else{return this;}this.setProperty("value",v,true);this._bValid=true;var i=[undefined,undefined];if(v){i=this._parseValue(v);this._oWantedDate=i[0];this._oWantedSecondDate=i[1];i=c.call(this,i[0],i[1]);if(!i[0]){this._bValid=false;q.sap.log.warning("Value can not be converted to a valid dates",this);}}if(this._bValid){this.setProperty("dateValue",i[0],true);this.setProperty("secondDateValue",i[1],true);this._oWantedDate=undefined;this._oWantedSecondDate=undefined;}if(this.getDomRef()){var o=this._formatValue(i[0],i[1]);if(this._$input.val()!==o){this._$input.val(o);this._setLabelVisibility();this._curpos=this._$input.cursorPos();}}return this;};
b.prototype.setValueFormat=function(v){this.setProperty("valueFormat",v,true);q.sap.log.warning("Property valueFormat is not supported in sap.m.DateRangeSelection control.",this);return this;};
b.prototype.setDisplayFormat=function(s){this.setProperty("displayFormat",s,true);var o=this._formatValue(this.getDateValue(),this.getSecondDateValue());this.setProperty("value",o,true);if(this.getDomRef()&&(this._$input.val()!==o)){this._$input.val(o);this._curpos=this._$input.cursorPos();}return this;};
b.prototype.setFrom=function(F){this.setDateValue(F);return this;};
b.prototype.getFrom=function(){return this.getDateValue();};
b.prototype.setTo=function(t){this.setSecondDateValue(t);return this;};
b.prototype.getTo=function(){return this.getSecondDateValue();};
b.prototype.setDateValue=function(o){if(o&&!(o instanceof Date)){throw new Error("Date must be a JavaScript date object; "+this);}if(q.sap.equal(this.getDateValue(),o)){return this;}if(o&&(o.getTime()<this._oMinDate.getTime()||o.getTime()>this._oMaxDate.getTime())){this._bValid=false;this._oWantedDate=o;o=undefined;}else{this._bValid=true;this.setProperty("dateValue",o,true);this._oWantedDate=undefined;}var s=this.getSecondDateValue();var v=this._formatValue(o,s);if(v!==this.getValue()){this._lastValue=v;}this.setProperty("value",v,true);if(this.getDomRef()){var O=this._formatValue(o,s);if(this._$input.val()!==O){this._$input.val(O);this._setLabelVisibility();this._curpos=this._$input.cursorPos();}}return this;};
b.prototype.setSecondDateValue=function(s){if(s&&!(s instanceof Date)){throw new Error("Date must be a JavaScript date object; "+this);}if(q.sap.equal(this.getSecondDateValue(),s)){return this;}if(s&&(s.getTime()<this._oMinDate.getTime()||s.getTime()>this._oMaxDate.getTime())){this._bValid=false;this._oWantedSecondDate=s;s=undefined;}else{this._bValid=true;this.setProperty("secondDateValue",s,true);this._oWantedSecondDate=undefined;}var o=this.getDateValue();var v=this._formatValue(o,s);if(v!==this.getValue()){this._lastValue=v;}this.setProperty("value",v,true);if(this.getDomRef()){var O=this._formatValue(o,s);if(this._$input.val()!==O){this._$input.val(O);this._setLabelVisibility();this._curpos=this._$input.cursorPos();}}return this;};
b.prototype.setMinDate=function(o){a.prototype.setMinDate.apply(this,arguments);if(o){var s=this.getSecondDateValue();if(s&&s.getTime()<this._oMinDate.getTime()){q.sap.log.warning("SecondDateValue not in valid date -> changed to minDate",this);this.setSecondDateValue(new Date(this._oMinDate.getTime()));}}return this;};
b.prototype.setMaxDate=function(o){a.prototype.setMaxDate.apply(this,arguments);if(o){var s=this.getSecondDateValue();if(s&&s.getTime()>this._oMaxDate.getTime()){q.sap.log.warning("SecondDateValue not in valid date -> changed to maxDate",this);this.setSecondDateValue(new Date(this._oMaxDate.getTime()));}}return this;};
b.prototype._checkMinMaxDate=function(){a.prototype._checkMinMaxDate.apply(this,arguments);if(this._oWantedSecondDate&&this._oWantedSecondDate.getTime()>=this._oMinDate.getTime()&&this._oWantedSecondDate.getTime()<=this._oMaxDate.getTime()){this.setSecondDateValue(this._oWantedSecondDate);}};
b.prototype._parseValue=function(v){var F;var i=[];var o,j;var s=d.call(this);v=v.trim();if(s&&v){v=h(v,[s," "]);i=v.split(s);if(i.length===2){if(i[0].slice(i[0].length-1,i[0].length)==" "){i[0]=i[0].slice(0,i[0].length-1);}if(i[1].slice(0,1)==" "){i[1]=i[1].slice(1);}}else{i=v.split(" "+s+" ");}if(v.indexOf(s)===-1){var k=v.split(" ");if(k.length===2){i=k;}}}if(v&&i.length<=2){F=e.call(this);if((!s||s==="")||i.length===1){o=F.parse(v);}else if(i.length===2){o=F.parse(i[0]);j=F.parse(i[1]);if(!o||!j){o=undefined;j=undefined;}}}return[o,j];};
b.prototype._formatValue=function(o,s){var v="";var i=d.call(this);if(o){var F;F=e.call(this);if(i&&i!==""&&s){v=F.format(o)+" "+i+" "+F.format(s);}else{v=F.format(o);}}return v;};
b.prototype.onChange=function(){if(!this.getEditable()||!this.getEnabled()){return;}var v=this._$input.val();var i=[undefined,undefined];this._oWantedDate=undefined;this._oWantedSecondDate=undefined;this._bValid=true;if(v!=""){i=this._parseValue(v);i=c.call(this,i[0],i[1]);if(i[0]){v=this._formatValue(i[0],i[1]);}else{this._bValid=false;}}if(v!==this._lastValue){if(this.getDomRef()&&(this._$input.val()!==v)){this._$input.val(v);this._curpos=this._$input.cursorPos();}this._lastValue=v;this.setProperty("value",v,true);if(this._bValid){this.setProperty("dateValue",i[0],true);this.setProperty("secondDateValue",i[1],true);}this._setLabelVisibility();if(this._oPopup&&this._oPopup.isOpen()){var s=this.getDateValue();if(s){if(!this._oDateRange.getStartDate()||this._oDateRange.getStartDate().getTime()!==s.getTime()){this._oDateRange.setStartDate(new Date(s.getTime()));this._oCalendar.focusDate(s);}}else{if(this._oDateRange.getStartDate()){this._oDateRange.setStartDate(undefined);}}var E=this.getSecondDateValue();if(E){if(!this._oDateRange.getEndDate()||this._oDateRange.getEndDate().getTime()!==E.getTime()){this._oDateRange.setEndDate(new Date(E.getTime()));this._oCalendar.focusDate(E);}}else{if(this._oDateRange.getEndDate()){this._oDateRange.setEndDate(undefined);}}}_.call(this,this._bValid);}};
b.prototype._getInputValue=function(v){v=(typeof v=="undefined")?this._$input.val():v.toString();var i=this._parseValue(v);v=this._formatValue(i[0],i[1]);return v;};
b.prototype.updateDomValue=function(v){this._bCheckDomValue=true;v=(typeof v=="undefined")?this._$input.val():v.toString();this._curpos=this._$input.cursorPos();var i=this._parseValue(v);v=this._formatValue(i[0],i[1]);if(this.isActive()&&(this._$input.val()!==v)){this._$input.val(v);this._$input.cursorPos(this._curpos);}this._setLabelVisibility();return this;};
b.prototype.onsappageup=function(){};
b.prototype.onsappageupmodifiers=function(){};
b.prototype.onsappagedown=function(){};
b.prototype.onsappagedownmodifiers=function(){};
b.prototype._fillDateRange=function(){a.prototype._fillDateRange.apply(this,arguments);var E=this.getSecondDateValue();if(E){if(!this._oDateRange.getEndDate()||this._oDateRange.getEndDate().getTime()!==E.getTime()){this._oDateRange.setEndDate(new Date(E.getTime()));}}else{if(this._oDateRange.getEndDate()){this._oDateRange.setEndDate(undefined);}}};
b.prototype._selectDate=function(E){var s=this._oCalendar.getSelectedDates();if(s.length>0){var o=s[0].getStartDate();var i=s[0].getEndDate();if(o&&i){var j=this.getDateValue();var k=this.getSecondDateValue();var v;if(!q.sap.equal(o,j)||!q.sap.equal(i,k)){if(q.sap.equal(i,k)){this.setDateValue(o);}else{this.setProperty("dateValue",o,true);this.setSecondDateValue(i);}v=this.getValue();_.call(this,true);if((D.system.desktop||!D.support.touch)&&!q.sap.simulateMobileOnDesktop){this._curpos=v.length;this._$input.cursorPos(this._curpos);}}else if(!this._bValid){v=this._formatValue(o,i);if(v!=this._$input.val()){this._bValid=true;if(this.getDomRef()){this._$input.val(v);}_.call(this,true);}}this._oPopup.close();}}};
b.prototype.getAccessibilityInfo=function(){var r=this.getRenderer();var i=a.prototype.getAccessibilityInfo.apply(this,arguments);var v=this.getValue()||"";if(this._bValid){var o=this.getDateValue();if(o){v=this._formatValue(o,this.getSecondDateValue());}}i.description=[v,r.getLabelledByAnnouncement(this),r.getDescribedByAnnouncement(this)].join(" ").trim();return i;};
function _(v){this.fireChangeEvent(this.getValue(),{from:this.getDateValue(),to:this.getSecondDateValue(),valid:v});}
function c(o,s){if(o&&s&&o.getTime()>s.getTime()){var t=o;o=s;s=t;}if((o&&(o.getTime()<this._oMinDate.getTime()||o.getTime()>this._oMaxDate.getTime()))||(s&&(s.getTime()<this._oMinDate.getTime()||s.getTime()>this._oMaxDate.getTime()))){return[undefined,undefined];}else{return[o,s];}}
function d(){var s=this.getDelimiter();if(!s){if(!this._sLocaleDelimiter){var L=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();var o=sap.ui.core.LocaleData.getInstance(L);var p=o.getIntervalPattern();var i=p.indexOf("{0}")+3;var I=p.indexOf("{1}");s=p.slice(i,I);if(s.length>1){if(s.slice(0,1)==" "){s=s.slice(1);}if(s.slice(s.length-1,s.length)==" "){s=s.slice(0,s.length-1);}}this._sLocaleDelimiter=s;}else{s=this._sLocaleDelimiter;}}return s;}
function e(){var p=(this.getDisplayFormat()||"medium");var F;var C=this.getDisplayFormatType();if(p==this._sUsedDisplayPattern&&C==this._sUsedDisplayCalendarType){F=this._oDisplayFormat;}else{if(this._checkStyle(p)){F=sap.ui.core.format.DateFormat.getInstance({style:p,strictParsing:true,calendarType:C});}else{F=sap.ui.core.format.DateFormat.getInstance({pattern:p,strictParsing:true,calendarType:C});}this._sUsedDisplayPattern=p;this._sUsedDisplayCalendarType=C;this._oDisplayFormat=F;}return F;}
function f(v,E){return v&&E&&v.lastIndexOf(E)===v.length-E.length;}
function g(v,s){return v&&s&&v.indexOf(s)===0;}
function h(v,p){var i=0,t=p;if(!t){t=[" "];}while(i<t.length){if(f(v,t[i])){v=v.substring(0,v.length-t[i].length);i=0;continue;}i++;}i=0;while(i<t.length){if(g(v,t[i])){v=v.substring(t[i].length);i=0;continue;}i++;}return v;}
return b;},true);
sap.ui.predefine('sap/m/DateRangeSelectionRenderer',['jquery.sap.global','sap/ui/core/Renderer','./DatePickerRenderer'],function(q,R,D){"use strict";var a=R.extend(D);
a.writeInnerValue=function(r,c){if(c._bValid){r.writeAttributeEscaped("value",c._formatValue(c.getDateValue(),c.getSecondDateValue()));}else{r.writeAttributeEscaped("value",c.getValue());}};
return a;},true);
sap.ui.predefine('sap/m/DateTimeField',['jquery.sap.global','sap/ui/model/type/Date','sap/ui/model/odata/type/ODataType','./InputBase'],function(q,S,O,I){"use strict";
var D=I.extend("sap.m.DateTimeField",{metadata:{"abstract":true,library:"sap.m",properties:{displayFormat:{type:"string",group:"Appearance",defaultValue:null},valueFormat:{type:"string",group:"Data",defaultValue:null},dateValue:{type:"object",group:"Data",defaultValue:null}}}});
D.prototype.setValue=function(v){v=this.validateProperty("value",v);var o=this.getValue();if(v===o){return this;}else{this._lastValue=v;}this.setProperty("value",v,true);this._bValid=true;var d;if(v){d=this._parseValue(v);if(!d||d.getTime()<this._oMinDate.getTime()||d.getTime()>this._oMaxDate.getTime()){this._bValid=false;q.sap.log.warning("Value can not be converted to a valid date",this);this._oWantedDate=d;}}if(this._bValid){this.setProperty("dateValue",d,true);this._oWantedDate=undefined;}if(this.getDomRef()){var s;if(d){s=this._formatValue(d);}else{s=v;}if(this._$input.val()!==s){this._$input.val(s);this._curpos=this._$input.cursorPos();}}return this;};
D.prototype.setDateValue=function(d){if(d&&!(d instanceof Date)){throw new Error("Date must be a JavaScript date object; "+this);}if(q.sap.equal(this.getDateValue(),d)){return this;}d=this._dateValidation(d);var v=this._formatValue(d,true);if(v!==this.getValue()){this._lastValue=v;}this.setProperty("value",v,true);if(this.getDomRef()){var o=this._formatValue(d);if(this._$input.val()!==o){this._$input.val(o);this._setLabelVisibility();this._curpos=this._$input.cursorPos();}}return this;};
D.prototype.setValueFormat=function(v){this.setProperty("valueFormat",v,true);var V=this.getValue();if(V){this._handleDateValidation(this._parseValue(V));}return this;};
D.prototype.setDisplayFormat=function(d){this.setProperty("displayFormat",d,true);this.updateDomValue(this._formatValue(this.getDateValue()));return this;};
D.prototype.getDisplayFormatType=function(){return null;};
D.prototype._dateValidation=function(d){this._bValid=true;this.setProperty("dateValue",d,true);return d;};
D.prototype._handleDateValidation=function(d){this._bValid=true;this.setProperty("dateValue",d,true);};
D.prototype._getPlaceholder=function(){var p=this.getPlaceholder();if(!p){p=this._getDisplayFormatPattern();if(!p){p=this._getDefaultDisplayStyle();}if(this._checkStyle(p)){var l=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();var L=sap.ui.core.LocaleData.getInstance(l);p=this._getPlaceholderPattern(L,p);}}return p;};
D.prototype._getPlaceholderPattern=function(l,p){return l.getDatePattern(p);};
D.prototype._parseValue=function(v,d){return this._getFormatter(d).parse(v);};
D.prototype._formatValue=function(d,v){if(d){return this._getFormatter(!v).format(d);}return"";};
D.prototype._getDefaultDisplayStyle=function(){return"medium";};
D.prototype._getDefaultValueStyle=function(){return"short";};
D.prototype._getFormatter=function(d){var p=this._getBoundValueTypePattern(),r=false,f,b=this.getBinding("value"),c;if(b&&b.oType&&b.oType.oOutputFormat){r=!!b.oType.oOutputFormat.oFormatOptions.relative;c=b.oType.oOutputFormat.oFormatOptions.calendarType;}if(!p){if(d){p=(this.getDisplayFormat()||this._getDefaultDisplayStyle());c=this.getDisplayFormatType();}else{p=(this.getValueFormat()||this._getDefaultValueStyle());c=sap.ui.core.CalendarType.Gregorian;}}if(!c){c=sap.ui.getCore().getConfiguration().getCalendarType();}if(d){if(p===this._sUsedDisplayPattern&&c===this._sUsedDisplayCalendarType){f=this._oDisplayFormat;}}else{if(p===this._sUsedValuePattern&&c===this._sUsedValueCalendarType){f=this._oValueFormat;}}if(f){return f;}return this._getFormatterInstance(f,p,r,c,d);};
D.prototype._getFormatterInstance=function(f,p,r,c,d){if(this._checkStyle(p)){f=this._getFormatInstance({style:p,strictParsing:true,relative:r,calendarType:c},d);}else{f=this._getFormatInstance({pattern:p,strictParsing:true,relative:r,calendarType:c},d);}if(d){this._sUsedDisplayPattern=p;this._sUsedDisplayCalendarType=c;this._oDisplayFormat=f;}else{this._sUsedValuePattern=p;this._sUsedValueCalendarType=c;this._oValueFormat=f;}return f;};
D.prototype._getFormatInstance=function(a,d){return sap.ui.core.format.DateFormat.getInstance(a);};
D.prototype._checkStyle=function(p){return(p==="short"||p==="medium"||p==="long"||p==="full");};
D.prototype._getDisplayFormatPattern=function(){return this._getBoundValueTypePattern()||this.getDisplayFormat();};
D.prototype._getBoundValueTypePattern=function(){var b=this.getBinding("value"),B=b&&b.getType&&b.getType();if(B instanceof S){return B.getOutputPattern();}if(B instanceof O&&B.oFormat){return B.oFormat.oFormatOptions.pattern;}return undefined;};
return D;},true);
sap.ui.predefine('sap/m/DateTimeFieldRenderer',['sap/ui/core/Renderer','./InputBaseRenderer'],function(R,I){"use strict";var D=R.extend(I);return D;},true);
sap.ui.predefine('sap/m/DateTimeInput',['jquery.sap.global','sap/ui/core/Control','./library','sap/ui/model/type/Date','sap/ui/model/type/Time','sap/ui/model/type/DateTime','sap/ui/model/odata/type/ODataType'],function(q,C,l,D,T,a,O){"use strict";
var b=C.extend("sap.m.DateTimeInput",{metadata:{library:"sap.m",properties:{value:{type:"string",group:"Data",defaultValue:null,bindable:"bindable"},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},enabled:{type:"boolean",group:"Behavior",defaultValue:true},editable:{type:"boolean",group:"Behavior",defaultValue:true},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:sap.ui.core.ValueState.None},valueStateText:{type:"string",group:"Misc",defaultValue:null},showValueStateMessage:{type:"boolean",group:"Misc",defaultValue:true},name:{type:"string",group:"Misc",defaultValue:null},placeholder:{type:"string",group:"Misc",defaultValue:null},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:sap.ui.core.TextAlign.Initial},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit},type:{type:"sap.m.DateTimeInputType",group:"Data",defaultValue:sap.m.DateTimeInputType.Date},displayFormat:{type:"string",group:"Appearance",defaultValue:null},valueFormat:{type:"string",group:"Data",defaultValue:null},dateValue:{type:"object",group:"Data",defaultValue:null}},aggregations:{_picker:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{change:{parameters:{value:{type:"string"},dateValue:{type:"object"},valid:{type:"boolean"}}}}}});
!(function(p,$,o){var f=sap.m.getLocaleData();$.extend(p,{_types:{Date:{valueFormat:f.getDatePattern("short"),displayFormat:f.getDatePattern("medium")},Time:{valueFormat:f.getTimePattern("short"),displayFormat:f.getTimePattern("short")},DateTime:{valueFormat:f.getDateTimePattern("short"),displayFormat:f.getDateTimePattern("short")}}});["Time","Date"].forEach(function(t,n){["valueFormat","displayFormat"].forEach(function(F){var g=p._types;g.DateTime[F]=g.DateTime[F].replace("{"+n+"}",g[t][F]);});});}(b.prototype,q,sap.ui.Device));
b.prototype.init=function(){this.setType(sap.m.DateTimeInputType.Date);};
b.prototype.onBeforeRendering=function(){d.call(this);};
b.prototype.getFocusDomRef=function(){var p=_.call(this);return p.getFocusDomRef();};
b.prototype.getIdForLabel=function(){var p=_.call(this);return p.getIdForLabel();};
function c(t){var p;switch(t){case sap.m.DateTimeInputType.DateTime:q.sap.require("sap.m.DateTimePicker");p=new sap.m.DateTimePicker(this.getId()+"-Picker");break;case sap.m.DateTimeInputType.Time:q.sap.require("sap.m.TimePicker");p=new sap.m.TimePicker(this.getId()+"-Picker",{localeId:sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString()});break;default:q.sap.require("sap.m.DatePicker");p=new sap.m.DatePicker(this.getId()+"-Picker");break;}p.setDisplayFormat(this.getDisplayFormat()||this._types[t].displayFormat);p.setValueFormat(this.getValueFormat()||this._types[t].valueFormat);if(this.getDateValue()){p.setDateValue(this.getDateValue());}p.setEnabled(this.getEnabled());p.setEditable(this.getEditable());p.setValueState(this.getValueState());p.setValueStateText(this.getValueStateText());p.setShowValueStateMessage(this.getShowValueStateMessage());p.setName(this.getName());p.setPlaceholder(this.getPlaceholder());p.setTextAlign(this.getTextAlign());p.setTextDirection(this.getTextDirection());p.setWidth("100%");p.attachChange(e,this);var A=this.getAriaLabelledBy();for(var i=0;i<A.length;i++){p.addAriaLabelledBy(A[i]);}return p;}
b.prototype.setType=function(t){if(t==this.getType()&&_.call(this)){return this;}this.destroyAggregation("_picker");var p=c.call(this,t);this.setAggregation("_picker",p);this.setProperty("type",t);return this;};
b.prototype.setWidth=function(w){this.setProperty("width",w);if(this.getDomRef()){w=this.getWidth();this.$().css("width",w);}return this;};
b.prototype.setValue=function(v){d.call(this);v=this.validateProperty("value",v);if(v.toLowerCase()=="now"){return this.setDateValue(new Date());}if(v===this.getValue()){return this;}this.setProperty("value",v,true);var p=_.call(this);p.setValue(v);var o=p.getDateValue();this.setProperty("dateValue",o,true);return this;};
b.prototype.setDateValue=function(o){if(o&&!(o instanceof Date)){throw new Error("Date must be a JavaScript date object; "+this);}d.call(this);this.setProperty("dateValue",o,true);var p=_.call(this);p.setDateValue(o);var v=p.getValue();this.setProperty("value",v,true);return this;};
b.prototype.setDisplayFormat=function(s){this.setProperty("displayFormat",s,true);var p=_.call(this);p.setDisplayFormat(s||this._types[this.getType()].displayFormat);return this;};
b.prototype.setValueFormat=function(v){this.setProperty("valueFormat",v,true);var p=_.call(this);p.setValueFormat(v||this._types[this.getType()].ValueFormat);return this;};
b.prototype.setEnabled=function(E){this.setProperty("enabled",E,true);var p=_.call(this);p.setEnabled(E);return this;};
b.prototype.setEditable=function(E){this.setProperty("editable",E,true);var p=_.call(this);p.setEditable(E);return this;};
b.prototype.setValueState=function(v){this.setProperty("valueState",v,true);var p=_.call(this);p.setValueState(v);return this;};
b.prototype.setValueStateText=function(v){this.setProperty("valueStateText",v,true);var p=_.call(this);p.setValueStateText(v);return this;};
b.prototype.setShowValueStateMessage=function(s){this.setProperty("showValueStateMessage",s,true);var p=_.call(this);p.setShowValueStateMessage(s);return this;};
b.prototype.setName=function(n){this.setProperty("name",n,true);var p=_.call(this);p.setName(n);return this;};
b.prototype.setPlaceholder=function(p){this.setProperty("placeholder",p,true);var P=_.call(this);P.setPlaceholder(p);return this;};
b.prototype.setTextAlign=function(t){this.setProperty("textAlign",t,true);var p=_.call(this);p.setTextAlign(t);return this;};
b.prototype.setTextDirection=function(t){this.setProperty("textDirection",t,true);var p=_.call(this);p.setTextDirection(t);return this;};
b.prototype.addAriaLabelledBy=function(i){this.addAssociation("ariaLabelledBy",i,true);var p=_.call(this);p.addAriaLabelledBy(i);return this;};
b.prototype.removeAriaLabelledBy=function(i){this.removeAssociation("ariaLabelledBy",i,true);var p=_.call(this);p.removeAriaLabelledBy(i);return this;};
b.prototype.removeAllAriaLabelledBy=function(){this.removeAssociation("ariaLabelledBy",true);var p=_.call(this);p.removeAllAriaLabelledBy();return this;};
b.prototype.getAccessibilityInfo=function(){var p=_.call(this);return p&&p.getAccessibilityInfo?p.getAccessibilityInfo():null;};
b.prototype._getPickerByTypeAndPattern=function(t,p,f){var r=/[DdYyMLWwGQUur]/,R=/[HhKkmsa]/,g=R.test(f),h=r.test(f),i=g&&!h,j=h&&!g,k=h&&g,n,N;switch(t){case sap.m.DateTimeInputType.Time:case sap.m.DateTimeInputType.Date:case sap.m.DateTimeInputType.DateTime:if(i&&p.getMetadata().getName()!=="sap.m.TimePicker"){n=sap.m.DateTimeInputType.Time;}else if(j&&p.getMetadata().getName()!=="sap.m.DatePicker"){n=sap.m.DateTimeInputType.Date;}else if(k&&p.getMetadata().getName()!=="sap.m.DateTimePicker"){n=sap.m.DateTimeInputType.DateTime;}break;default:{throw"Invalid type: "+t+". Expected is one of the sap.m.DateTimeInputType";}}if(n){this.destroyAggregation("_picker");N=c.call(this,n);this.setAggregation("_picker",N);}return N||p;};
b.prototype._getBoundValueTypePattern=function(){var B=this.getBinding("value"),o=B&&B.getType()&&B.getType();if(o instanceof D||o instanceof T||o instanceof a){return o.getOutputPattern();}if(o instanceof O&&o.oFormat){return o.oFormat.oFormatOptions.pattern;}return undefined;};
function _(){return this.getAggregation("_picker");}
function d(){if(this._getBoundValueTypePattern()){var p=this._getBoundValueTypePattern();var P=_.call(this);P=this._getPickerByTypeAndPattern(this.getType(),P,p);if(P.getValueFormat()!=p){P.setValueFormat(p);}if(P.getDisplayFormat()!=p){P.setDisplayFormat(p);}}}
function e(E){var v=E.getParameter("value");var o;var V=E.getParameter("valid");this.setProperty("value",v,true);if(V){o=E.oSource.getDateValue();this.setProperty("dateValue",o,true);}this.fireChange({value:v,newValue:v,valid:V,dateValue:o,newDateValue:o});}
return b;},true);
sap.ui.predefine('sap/m/DateTimeInputRenderer',['jquery.sap.global','sap/ui/core/Renderer'],function(q,R){"use strict";var D={};
D.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapMDTI");var w=c.getWidth();if(w){r.addStyle("width",w);}r.writeStyles();r.writeClasses();r.write(">");var p=c.getAggregation("_picker");if(p){r.renderControl(p);}r.write("</div>");};
return D;},true);
sap.ui.predefine('sap/m/DateTimePicker',['jquery.sap.global','./DatePicker','sap/ui/model/type/Date','./library'],function(q,D,a,l){"use strict";
var b=D.extend("sap.m.DateTimePicker",{metadata:{library:"sap.m",aggregations:{_popup:{type:"sap.m.ResponsivePopover",multiple:false,visibility:"hidden"}}}});
var P=sap.ui.core.Control.extend("DateTimePickerPopup",{
metadata:{aggregations:{_switcher:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},calendar:{type:"sap.ui.core.Control",multiple:false},timeSliders:{type:"sap.ui.core.Control",multiple:false}}},
renderer:function(r,p){r.write("<div");r.writeControlData(p);r.addClass("sapMDateTimePopupCont");r.addClass("sapMTimePickerDropDown");r.writeClasses();r.write(">");var s=p.getAggregation("_switcher");if(s&&s.getVisible()){r.write("<div");r.addClass("sapMTimePickerSwitch");r.writeClasses();r.write(">");r.renderControl(s);r.write("</div>");}var C=p.getCalendar();if(C){r.renderControl(C);}r.write("<div");r.addClass("sapMTimePickerSep");r.writeClasses();r.write(">");r.write("</div>");var S=p.getTimeSliders();if(S){r.renderControl(S);}r.write("</div>");},
init:function(){},
onBeforeRendering:function(){var s=this.getAggregation("_switcher");if(sap.ui.Device.system.phone||q('html').hasClass("sapUiMedia-Std-Phone")){if(!s){var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");var i=r.getText("DATETIMEPICKER_DATE");var t=r.getText("DATETIMEPICKER_TIME");s=new sap.m.SegmentedButton(this.getId()+"-Switch",{selectedKey:"Cal",items:[new sap.m.SegmentedButtonItem(this.getId()+"-Switch-Cal",{key:"Cal",text:i}),new sap.m.SegmentedButtonItem(this.getId()+"-Switch-Sli",{key:"Sli",text:t})]});s.attachSelect(this._handleSelect,this);this.setAggregation("_switcher",s,true);}else{s.setVisible(true);s.setSelectedKey("Cal");}}else if(s){s.setVisible(false);}},
onAfterRendering:function(){if(sap.ui.Device.system.phone||q('html').hasClass("sapUiMedia-Std-Phone")){var s=this.getAggregation("_switcher");var k=s.getSelectedKey();this._switchVisibility(k);if(sap.ui.Device.system.phone){this._adjustTimePickerHeightOnPhone();}}},
_adjustTimePickerHeightOnPhone:function(){var s=this.getAggregation("_switcher"),S=s.$().children(0).css("height").replace('px','');this.$().css("height",(document.documentElement.clientHeight-parseInt(S,10))+"px");},
_handleSelect:function(E){this._switchVisibility(E.getParameter("key"));},
_switchVisibility:function(k){var C=this.getCalendar();var s=this.getTimeSliders();if(!C||!s){return;}if(k=="Cal"){C.$().css("display","");s.$().css("display","none");}else{C.$().css("display","none");s.$().css("display","");s.updateSlidersValues();s._onOrientationChanged();s._initFocus();}},
switchToTime:function(){var s=this.getAggregation("_switcher");if(s&&s.getVisible()){s.setSelectedKey("Sli");this._switchVisibility("Sli");}},
getSpecialDates:function(){return this._oDateTimePicker.getSpecialDates();}
});
b.prototype.init=function(){D.prototype.init.apply(this,arguments);this._bOnlyCalendar=false;};
b.prototype.exit=function(){D.prototype.exit.apply(this,arguments);if(this._oSliders){this._oSliders.destroy();delete this._oSliders;}this._oPopupContent=undefined;};
b.prototype.setDisplayFormat=function(s){D.prototype.setDisplayFormat.apply(this,arguments);if(this._oSliders){this._oSliders.setFormat(g.call(this));}return this;};
b.prototype._getFormatInstance=function(A,i){var m=q.extend({},A);var s=-1;if(m.style){s=m.style.indexOf("/");}if(i){var o=q.extend({},m);if(s>0){o.style=o.style.substr(0,s);}this._oDisplayFormatDate=sap.ui.core.format.DateFormat.getInstance(o);}return sap.ui.core.format.DateFormat.getDateTimeInstance(m);};
b.prototype._checkStyle=function(p){if(D.prototype._checkStyle.apply(this,arguments)){return true;}else if(p.indexOf("/")>0){var s=["short","medium","long","full"];var S=false;for(var i=0;i<s.length;i++){var k=s[i];for(var j=0;j<s.length;j++){var m=s[j];if(p==k+"/"+m){S=true;break;}}if(S){break;}}return S;}return false;};
b.prototype._parseValue=function(v,i){var o=D.prototype._parseValue.apply(this,arguments);if(i&&!o){o=this._oDisplayFormatDate.parse(v);if(o){var O=this.getDateValue();if(!O){O=new Date();}o.setHours(O.getHours());o.setMinutes(O.getMinutes());o.setSeconds(O.getSeconds());o.setMilliseconds(O.getMilliseconds());}}return o;};
b.prototype._getPlaceholderPattern=function(L,p){var s=p.indexOf("/");if(s>0){return L.getCombinedDateTimePattern(p.substr(0,s),p.substr(s+1));}else{return L.getCombinedDateTimePattern(p,p);}};
b.prototype._createPopup=function(){if(!this._oPopup){var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");var o=r.getText("TIMEPICKER_SET");var C=r.getText("TIMEPICKER_CANCEL");this._oPopupContent=new P(this.getId()+"-PC");this._oPopupContent._oDateTimePicker=this;this._oPopup=new sap.m.ResponsivePopover(this.getId()+"-RP",{showCloseButton:false,showHeader:false,placement:sap.m.PlacementType.VerticalPreferedBottom,beginButton:new sap.m.Button(this.getId()+"-OK",{text:o,press:q.proxy(_,this)}),endButton:new sap.m.Button(this.getId()+"-Cancel",{text:C,press:q.proxy(c,this)}),content:this._oPopupContent});this._oPopup.addStyleClass("sapMDateTimePopup");var p=this._oPopup.getAggregation("_popup");if(p.setShowArrow){p.setShowArrow(false);}this._oPopup.attachBeforeOpen(d,this);this._oPopup.attachAfterOpen(e,this);this._oPopup.attachAfterClose(f,this);if(sap.ui.Device.system.desktop){this._oPopoverKeydownEventDelegate={onkeydown:function(E){var k=q.sap.KeyCodes,K=E.which||E.keyCode,A=E.altKey;if((A&&(K===k.ARROW_UP||K===k.ARROW_DOWN))||K===k.F4){_.call(this,E);this.focus();E.preventDefault();}}};this._oPopup.addEventDelegate(this._oPopoverKeydownEventDelegate,this);}this.setAggregation("_popup",this._oPopup,true);}};
b.prototype._openPopup=function(){if(!this._oPopup){return;}var p=this._oPopup.getAggregation("_popup");p.oPopup.setAutoCloseAreas([this.getDomRef()]);this._oPopup.openBy(this);var s=this._oPopup.getContent()[0]&&this._oPopup.getContent()[0].getTimeSliders();if(s){q.sap.delayedCall(0,s,s.updateSlidersValues);}};
b.prototype._createPopupContent=function(){var n=!this._oCalendar;D.prototype._createPopupContent.apply(this,arguments);if(n){this._oPopupContent.setCalendar(this._oCalendar);this._oCalendar.attachSelect(h,this);}if(!this._oSliders){q.sap.require("sap.m.TimePickerSliders");this._oSliders=new sap.m.TimePickerSliders(this.getId()+"-Sliders",{format:g.call(this),invokedBy:this.getId()});this._oPopupContent.setTimeSliders(this._oSliders);}};
b.prototype._fillDateRange=function(){var o=this.getDateValue();if(o){o=new Date(o.getTime());}else{o=new Date();var m=this._oMaxDate.getTime()+86400000;if(o.getTime()<this._oMinDate.getTime()||o.getTime()>m){o=this._oMinDate;}}this._oCalendar.focusDate(o);if(!this._oDateRange.getStartDate()||this._oDateRange.getStartDate().getTime()!=o.getTime()){this._oDateRange.setStartDate(o);}this._oSliders.setTimeValues(o);};
b.prototype._getSelectedDate=function(){var o=D.prototype._getSelectedDate.apply(this,arguments);if(o){var i=this._oSliders.getTimeValues();var p=this._oSliders.getFormat();if(p.search("h")>=0||p.search("H")>=0){o.setHours(i.getHours());}if(p.search("m")>=0){o.setMinutes(i.getMinutes());}if(p.search("s")>=0){o.setSeconds(i.getSeconds());}if(o.getTime()<this._oMinDate.getTime()){o=new Date(this._oMinDate.getTime());}else if(o.getTime()>this._oMaxDate.getTime()){o=new Date(this._oMaxDate.getTime());}}return o;};
b.prototype.getLocaleId=function(){return sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();};
b.prototype.getAccessibilityInfo=function(){var i=D.prototype.getAccessibilityInfo.apply(this,arguments);i.type=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_DATETIMEINPUT");return i;};
function _(E){this._selectDate();}
function c(E){this.onsaphide(E);}
function d(E){}
function e(E){this.$("inner").attr("aria-expanded",true);this._oCalendar.focus();this._oSliders._onOrientationChanged();}
function f(E){this.$("inner").attr("aria-expanded",false);}
function g(){var s=this.getDisplayFormat();var t;var B=this.getBinding("value");if(B&&B.oType&&(B.oType instanceof a)){s=B.oType.getOutputPattern();}else if(B&&B.oType&&B.oType.oFormat){s=B.oType.oFormat.oFormatOptions.pattern;}else{s=this.getDisplayFormat();}if(!s){s="medium";}var S=s.indexOf("/");if(S>0&&this._checkStyle(s)){s=s.substr(S+1);}if(s=="short"||s=="medium"||s=="long"||s=="full"){var L=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();var o=sap.ui.core.LocaleData.getInstance(L);t=o.getTimePattern(s);}else{t=s;}return t;}
function h(E){this._oPopupContent.switchToTime();}
return b;},true);
sap.ui.predefine('sap/m/DateTimePickerRenderer',['jquery.sap.global','sap/ui/core/Renderer','./DatePickerRenderer','./InputBaseRenderer'],function(q,R,D,I){"use strict";var a=R.extend(D);
a._getIcon=function(){return"sap-icon://date-time";};
a.getDescribedByAnnouncement=function(d){var b=I.getDescribedByAnnouncement.apply(this,arguments);return sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("DATETIMEPICKER_TYPE")+" "+b;};
return a;},true);
sap.ui.predefine('sap/m/Dialog.designtime',[],function(){"use strict";return{aggregations:{content:{domRef:"> .sapMDialogSection"}}};},false);
sap.ui.predefine('sap/m/Dialog',['jquery.sap.global','./Bar','./InstanceManager','./AssociativeOverflowToolbar','./ToolbarSpacer','./library','sap/ui/core/Control','sap/ui/core/IconPool','sap/ui/core/Popup','sap/ui/core/delegate/ScrollEnablement','sap/ui/core/theming/Parameters','sap/ui/core/RenderManager','sap/ui/core/InvisibleText','sap/ui/core/ResizeHandler','sap/ui/Device','sap/ui/base/ManagedObject'],function(q,B,I,A,T,l,C,a,P,S,b,R,c,d,D,M){"use strict";var V=sap.ui.core.ValueState;
var f=C.extend("sap.m.Dialog",{metadata:{interfaces:["sap.ui.core.PopupInterface"],library:"sap.m",properties:{icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},title:{type:"string",group:"Appearance",defaultValue:null},showHeader:{type:"boolean",group:"Appearance",defaultValue:true},type:{type:"sap.m.DialogType",group:"Appearance",defaultValue:sap.m.DialogType.Standard},state:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:V.None},stretchOnPhone:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},stretch:{type:"boolean",group:"Appearance",defaultValue:false},contentWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},contentHeight:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},horizontalScrolling:{type:"boolean",group:"Behavior",defaultValue:true},verticalScrolling:{type:"boolean",group:"Behavior",defaultValue:true},resizable:{type:"boolean",group:"Behavior",defaultValue:false},draggable:{type:"boolean",group:"Behavior",defaultValue:false},escapeHandler:{type:"any",group:"Behavior",defaultValue:null}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},subHeader:{type:"sap.m.IBar",multiple:false},customHeader:{type:"sap.m.IBar",multiple:false},beginButton:{type:"sap.m.Button",multiple:false},endButton:{type:"sap.m.Button",multiple:false},buttons:{type:"sap.m.Button",multiple:true,singularName:"button"},_header:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_title:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_icon:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_toolbar:{type:"sap.m.OverflowToolbar",multiple:false,visibility:"hidden"},_valueState:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"}},associations:{leftButton:{type:"sap.m.Button",multiple:false,deprecated:true},rightButton:{type:"sap.m.Button",multiple:false,deprecated:true},initialFocus:{type:"sap.ui.core.Control",multiple:false},ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{beforeOpen:{},afterOpen:{},beforeClose:{parameters:{origin:{type:"sap.m.Button"}}},afterClose:{parameters:{origin:{type:"sap.m.Button"}}}},designTime:true}});
f._bPaddingByDefault=(sap.ui.getCore().getConfiguration().getCompatibilityVersion("sapMDialogWithPadding").compareTo("1.16")<0);f._mStateClasses={};f._mStateClasses[V.None]="";f._mStateClasses[V.Success]="sapMDialogSuccess";f._mStateClasses[V.Warning]="sapMDialogWarning";f._mStateClasses[V.Error]="sapMDialogError";f._mIcons={};f._mIcons[V.Success]=a.getIconURI("message-success");f._mIcons[V.Warning]=a.getIconURI("message-warning");f._mIcons[V.Error]=a.getIconURI("message-error");
f.prototype.init=function(){var t=this;this._externalIcon=undefined;this._oManuallySetSize=null;this._oManuallySetPosition=null;this._bRTL=sap.ui.getCore().getConfiguration().getRTL();this._scrollContentList=["NavContainer","Page","ScrollContainer","SplitContainer","MultiInput"];this.oPopup=new P();this.oPopup.setShadow(true);this.oPopup.setNavigationMode("SCOPE");if(q.device.is.iphone&&!this._bMessageType){this.oPopup.setModal(true,"sapMDialogTransparentBlk");}else{this.oPopup.setModal(true,"sapMDialogBlockLayerInit");}this.oPopup.setAnimations(q.proxy(this._openAnimation,this),q.proxy(this._closeAnimation,this));this.oPopup._applyPosition=function(p,F){var s;var e;t._setDimensions();t._adjustScrollingPane();p.at={};if(t._oManuallySetPosition){p.at.left=t._oManuallySetPosition.x;p.at.top=t._oManuallySetPosition.y;}else{if(window.scrollY===undefined){s=window.pageYOffset;}else{s=window.scrollY;}if(s<0){s=0;}p.at.top='calc(50% + '+s+'px)';if(t._bRTL){p.at.left='auto';}else{if(window.scrollX===undefined){e=window.pageXOffset;}else{e=window.scrollX;}if(e<0){e=0;}p.at.left='calc(50% + '+e+'px)';}}t._deregisterContentResizeHandler();P.prototype._applyPosition.call(this,p);t._registerContentResizeHandler();};if(f._bPaddingByDefault){this.addStyleClass("sapUiPopupWithPadding");}};
f.prototype.onBeforeRendering=function(){if(this._hasSingleScrollableContent()){this.setProperty("verticalScrolling",false);this.setProperty("horizontalScrolling",false);q.sap.log.info("VerticalScrolling and horizontalScrolling in sap.m.Dialog with ID "+this.getId()+" has been disabled because there's scrollable content inside");}else if(!this._oScroller){this._oScroller=new S(this,this.getId()+"-scroll",{horizontal:this.getHorizontalScrolling(),vertical:this.getVerticalScrolling()});}this._createToolbarButtons();if(sap.ui.getCore().getConfiguration().getAccessibility()&&this.getState()!=V.None){var v=new c({text:this.getValueStateString(this.getState())});this.setAggregation("_valueState",v);this.addAriaLabelledBy(v.getId());}};
f.prototype.onAfterRendering=function(){this._$scrollPane=this.$("scroll");this._$content=this.$("cont");this._$dialog=this.$();if(this.isOpen()){this._setInitialFocus();}if(this.getType()===sap.m.DialogType.Message||(D.system.phone&&!this.getStretch())){this.$("footer").removeClass("sapContrast sapContrastPlus");}};
f.prototype.exit=function(){I.removeDialogInstance(this);this._deregisterContentResizeHandler();this._deregisterResizeHandler();if(this.oPopup){this.oPopup.detachOpened(this._handleOpened,this);this.oPopup.detachClosed(this._handleClosed,this);this.oPopup.destroy();this.oPopup=null;}if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this._header){this._header.destroy();this._header=null;}if(this._headerTitle){this._headerTitle.destroy();this._headerTitle=null;}if(this._iconImage){this._iconImage.destroy();this._iconImage=null;}if(this._toolbarSpacer){this._toolbarSpacer.destroy();this._toolbarSpacer=null;}};
f.prototype.open=function(){var p=this.oPopup;p.setInitialFocusId(this.getId());var o=p.getOpenState();switch(o){case sap.ui.core.OpenState.OPEN:case sap.ui.core.OpenState.OPENING:return this;case sap.ui.core.OpenState.CLOSING:this._bOpenAfterClose=true;break;default:}this._oCloseTrigger=null;this.fireBeforeOpen();p.attachOpened(this._handleOpened,this);p.setContent(this);p.open();this._registerResizeHandler();I.addDialogInstance(this);return this;};
f.prototype.close=function(){this._bOpenAfterClose=false;this.$().removeClass('sapDialogDisableTransition');this._deregisterResizeHandler();var p=this.oPopup;var e=this.oPopup.getOpenState();if(!(e===sap.ui.core.OpenState.CLOSED||e===sap.ui.core.OpenState.CLOSING)){sap.m.closeKeyboard();this.fireBeforeClose({origin:this._oCloseTrigger});p.attachClosed(this._handleClosed,this);this._bDisableRepositioning=false;this._oManuallySetPosition=null;this._oManuallySetSize=null;p.close();this._deregisterContentResizeHandler();}return this;};
f.prototype.isOpen=function(){return this.oPopup&&this.oPopup.isOpen();};
f.prototype._handleOpened=function(){this.oPopup.detachOpened(this._handleOpened,this);this._setInitialFocus();this.fireAfterOpen();};
f.prototype._handleClosed=function(){if(!this.oPopup){return;}this.oPopup.detachClosed(this._handleClosed,this);if(this.getDomRef()){R.preserveContent(this.getDomRef());this.$().remove();}I.removeDialogInstance(this);this.fireAfterClose({origin:this._oCloseTrigger});if(this._bOpenAfterClose){this._bOpenAfterClose=false;this.open();}};
f.prototype.onfocusin=function(e){var s=e.target;if(s.id===this.getId()+"-firstfe"){var L=this.$("footer").lastFocusableDomRef()||this.$("cont").lastFocusableDomRef()||(this.getSubHeader()&&this.getSubHeader().$().firstFocusableDomRef())||(this._getAnyHeader()&&this._getAnyHeader().$().lastFocusableDomRef());if(L){q.sap.focus(L);}}else if(s.id===this.getId()+"-lastfe"){var F=(this._getAnyHeader()&&this._getAnyHeader().$().firstFocusableDomRef())||(this.getSubHeader()&&this.getSubHeader().$().firstFocusableDomRef())||this.$("cont").firstFocusableDomRef()||this.$("footer").firstFocusableDomRef();if(F){q.sap.focus(F);}}};
f.prototype._getPromiseWrapper=function(){var t=this;return{reject:function(){t.currentPromise.reject();},resolve:function(){t.currentPromise.resolve();}};};
f.prototype.onsapescape=function(e){var E=this.getEscapeHandler(),p={},t=this;if(e.originalEvent&&e.originalEvent._sapui_handledByControl){return;}if(typeof E==='function'){new window.Promise(function(r,h){p.resolve=r;p.reject=h;t.currentPromise=p;E(t._getPromiseWrapper());}).then(function(r){t.close();}).catch(function(){q.sap.log.info("Disallow dialog closing");});}else{this.close();}e.stopPropagation();};
f.prototype._openAnimation=function(r,i,o){r.addClass("sapMDialogOpen");r.css("display","block");setTimeout(o,300);};
f.prototype._closeAnimation=function(r,i,e){r.removeClass("sapMDialogOpen");setTimeout(e,300);};
f.prototype._setDimensions=function(){var $=this.$(),s=this.getStretch(),e=this.getStretchOnPhone()&&D.system.phone,m=this._bMessageType,o={};if(!s){if(!this._oManuallySetSize){o.width=this.getContentWidth()||undefined;o.height=this.getContentHeight()||undefined;}else{o.width=this._oManuallySetSize.width;o.height=this._oManuallySetSize.height;}}if(o.width=='auto'){o.width=undefined;}if(o.height=='auto'){o.height=undefined;}if((s&&!m)||(e)){this.$().addClass('sapMDialogStretched');}$.css(o);if(!s&&!this._oManuallySetSize&&!this._bDisableRepositioning){this._applyCustomTranslate();}if(window.navigator.userAgent.toLowerCase().indexOf("chrome")!==-1&&this.getStretch()){$.find('> footer').css({bottom:'0.001px'});}};
f.prototype._adjustScrollingPane=function(){if(this._oScroller){this._oScroller.refresh();}};
f.prototype._reposition=function(){};
f.prototype._repositionAfterOpen=function(){};
f.prototype._reapplyPosition=function(){this._adjustScrollingPane();};
f.prototype._onResize=function(){var $=this.$(),e=this.$('cont'),h=e[0].clientWidth,i,s=this.getContentHeight(),j=this.getContentWidth(),k,m=Math.floor(window.innerWidth*0.9),n=2,o=sap.ui.Device.browser;if(this._oManuallySetSize){e.css({width:'auto'});return;}if(!s||s=='auto'){i=e.scrollTop();e.css({height:'auto'});k=parseFloat($.height())+n;e.height(Math.round(k));e.scrollTop(i);}if((o.internet_explorer||o.edge)&&(!j||j=='auto')&&!this.getStretch()&&h<e[0].scrollWidth&&e.width()<m){var v=e.width()-h;e.css({width:Math.min(e.width()+v,m)+"px"});}if(!this.getStretch()&&!this._oManuallySetSize&&!this._bDisableRepositioning){this._applyCustomTranslate();}if(D.browser.chrome){var F=this.$("footer");F.css("height","auto");setTimeout(function(){F.css("height","");},10);}};
f.prototype._applyCustomTranslate=function(){var $=this.$(),t,s,i=$.innerWidth(),e=$.innerHeight();if(D.system.desktop&&(i%2!==0||e%2!==0)){if(!this._bRTL){t='-'+Math.floor(i/2)+"px";}else{t=Math.floor(i/2)+"px";}s='-'+Math.floor(e/2)+"px";$.css('transform','translate('+t+','+s+') scale(1)');}else{$.css('transform','');}};
f.prototype._createHeader=function(){if(!this._header){this._header=new B(this.getId()+"-header").addStyleClass("sapMDialogTitle");this._header._setRootAccessibilityRole("heading");this.setAggregation("_header",this._header,false);}};
f.prototype._hasSingleScrollableContent=function(){var e=this.getContent(),i;while(e.length===1&&e[0]instanceof sap.ui.core.mvc.View){e=e[0].getContent();}if(e.length===1){for(i=0;i<this._scrollContentList.length;i++){if(e[0]instanceof sap.m[this._scrollContentList[i]]){return true;}}}return false;};
f.prototype._initBlockLayerAnimation=function(){this.oPopup._hideBlockLayer=function(){var $=q("#sap-ui-blocklayer-popup");$.removeClass("sapMDialogTransparentBlk");P.prototype._hideBlockLayer.call(this);};};
f.prototype._clearBlockLayerAnimation=function(){if(q.device.is.iphone&&!this._bMessageType){delete this.oPopup._showBlockLayer;this.oPopup._hideBlockLayer=function(){var $=q("#sap-ui-blocklayer-popup");$.removeClass("sapMDialogTransparentBlk");P.prototype._hideBlockLayer.call(this);};}};
f.prototype._getFocusId=function(){return this.getInitialFocus()||this._getFirstFocusableContentSubHeader()||this._getFirstFocusableContentElementId()||this._getFirstVisibleButtonId()||this.getId();};
f.prototype._getFirstVisibleButtonId=function(){var o=this.getBeginButton(),e=this.getEndButton(),h=this.getButtons(),s="";if(o&&o.getVisible()){s=o.getId();}else if(e&&e.getVisible()){s=e.getId();}else if(h&&h.length>0){for(var i=0;i<h.length;i++){if(h[i].getVisible()){s=h[i].getId();break;}}}return s;};
f.prototype._getFirstFocusableContentSubHeader=function(){var $=this.$().find('.sapMDialogSubHeader');var r;var F=$.firstFocusableDomRef();if(F){r=F.id;}return r;};
f.prototype._getFirstFocusableContentElementId=function(){var r="";var $=this.$("cont");var F=$.firstFocusableDomRef();if(F){r=F.id;}return r;};
f.prototype._setInitialFocus=function(){var F=this._getFocusId();var o=sap.ui.getCore().byId(F);var e;if(o){if(o.getVisible&&!o.getVisible()){this.focus();return;}e=o.getFocusDomRef();}e=e||q.sap.domById(F);if(!e){this.setInitialFocus("");e=sap.ui.getCore().byId(this._getFocusId());}if(!this.getInitialFocus()){this.setAssociation('initialFocus',e?e.id:this.getId(),true);}if(D.system.desktop||(e&&!/input|textarea|select/i.test(e.tagName))){q.sap.focus(e);}else{this.focus();}};
f.prototype.getScrollDelegate=function(){return this._oScroller;};
f.prototype._composeAggreNameInHeader=function(p){var h;if(p==="Begin"){h="contentLeft";}else if(p==="End"){h="contentRight";}else{h="content"+p;}return h;};
f.prototype._isToolbarEmpty=function(){var e=this._oToolbar.getContent().filter(function(h){return h.getMetadata().getName()!=='sap.m.ToolbarSpacer';});return e.length===0;};
f.prototype._setButton=function(o,p,s){return this;};
f.prototype._getButton=function(p){var s=p.toLowerCase()+"Button",e="_o"+this._firstLetterUpperCase(p)+"Button";if(D.system.phone){return this.getAggregation(s,null,true);}else{return this[e];}};
f.prototype._getButtonFromHeader=function(p){if(this._header){var h=this._composeAggreNameInHeader(this._firstLetterUpperCase(p)),e=this._header.getAggregation(h);return e&&e[0];}else{return null;}};
f.prototype._firstLetterUpperCase=function(v){return v.charAt(0).toUpperCase()+v.slice(1);};
f.prototype._getAnyHeader=function(){var o=this.getCustomHeader();if(o){return o;}else{var s=this.getShowHeader();if(!s){return null;}this._createHeader();return this._header;}};
f.prototype._deregisterResizeHandler=function(){if(this._resizeListenerId){d.deregister(this._resizeListenerId);this._resizeListenerId=null;}D.resize.detachHandler(this._onResize,this);};
f.prototype._registerResizeHandler=function(){var _=this.$("scroll");this._resizeListenerId=d.register(_.get(0),q.proxy(this._onResize,this));D.resize.attachHandler(this._onResize,this);this._onResize();};
f.prototype._deregisterContentResizeHandler=function(){if(this._sContentResizeListenerId){d.deregister(this._sContentResizeListenerId);this._sContentResizeListenerId=null;}};
f.prototype._registerContentResizeHandler=function(){if(!this._sContentResizeListenerId){this._sContentResizeListenerId=d.register(this.getDomRef("scrollCont"),q.proxy(this._onResize,this));}this._onResize();};
f.prototype._attachHandler=function(o){var t=this;if(!this._oButtonDelegate){this._oButtonDelegate={ontap:function(){t._oCloseTrigger=this;}};}if(o){o.addDelegate(this._oButtonDelegate,true,o);}};
f.prototype._createToolbarButtons=function(){var t=this._getToolbar();var e=this.getButtons();var h=this.getBeginButton();var i=this.getEndButton(),j=this,k=[h,i];k.forEach(function(o){if(o&&j._oButtonDelegate){o.removeDelegate(j._oButtonDelegate);}});t.removeAllContent();if(!("_toolbarSpacer"in this)){this._toolbarSpacer=new T();}t.addContent(this._toolbarSpacer);k.forEach(function(o){j._attachHandler(o);});if(e&&e.length){e.forEach(function(m){t.addContent(m);});}else{if(h){t.addContent(h);}if(i){t.addContent(i);}}};
f.prototype._getToolbar=function(){if(!this._oToolbar){this._oToolbar=new A(this.getId()+"-footer").addStyleClass("sapMTBNoBorders").applyTagAndContextClassFor("footer");this._oToolbar._isControlsInfoCached=function(){return false;};this.setAggregation("_toolbar",this._oToolbar);}return this._oToolbar;};
f.prototype.getValueStateString=function(v){var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");switch(v){case(sap.ui.core.ValueState.Success):return r.getText("LIST_ITEM_STATE_SUCCESS");case(sap.ui.core.ValueState.Warning):return r.getText("LIST_ITEM_STATE_WARNING");case(sap.ui.core.ValueState.Error):return r.getText("LIST_ITEM_STATE_ERROR");default:return"";}};
f.prototype.setSubHeader=function(o){this.setAggregation("subHeader",o);if(o){o.setVisible=function(i){this.$().toggleClass('sapMDialogWithSubHeader',i);o.setProperty("visible",i);}.bind(this);}return o;};
f.prototype.setLeftButton=function(v){if(!(v instanceof sap.m.Button)){v=sap.ui.getCore().byId(v);}this.setBeginButton(v);return this.setAssociation("leftButton",v);};
f.prototype.setRightButton=function(v){if(!(v instanceof sap.m.Button)){v=sap.ui.getCore().byId(v);}this.setEndButton(v);return this.setAssociation("rightButton",v);};
f.prototype.getLeftButton=function(){var o=this.getBeginButton();return o?o.getId():null;};
f.prototype.getRightButton=function(){var e=this.getEndButton();return e?e.getId():null;};
f.prototype.getAggregation=function(s,o,p){var e=C.prototype.getAggregation.apply(this,Array.prototype.slice.call(arguments,0,2));if(s==='buttons'&&e.length===0){this.getBeginButton()&&e.push(this.getBeginButton());this.getEndButton()&&e.push(this.getEndButton());}return e;};
f.prototype.getAriaLabelledBy=function(){var h=this._getAnyHeader(),e=this.getAssociation("ariaLabelledBy",[]).slice();var s=this.getSubHeader();if(s){e.unshift(s.getId());}if(h){e.unshift(h.getId());}return e;};
f.prototype.setTitle=function(t){this.setProperty("title",t,true);if(this._headerTitle){this._headerTitle.setText(t);}else{this._headerTitle=new sap.m.Title(this.getId()+"-title",{text:t,level:"H1"}).addStyleClass("sapMDialogTitle");this._createHeader();this._header.addContentMiddle(this._headerTitle);}return this;};
f.prototype.setCustomHeader=function(o){if(o){o.addStyleClass("sapMDialogTitle");}this.setAggregation("customHeader",o);};
f.prototype.setState=function(s){var F={},$=this.$(),n;F[s]=true;this.setProperty("state",s,true);for(n in f._mStateClasses){$.toggleClass(f._mStateClasses[n],!!F[n]);}this.setIcon(f._mIcons[s],true);return this;};
f.prototype.setIcon=function(i,e){if(!e){this._externalIcon=i;}else{if(this._externalIcon){i=this._externalIcon;}}if(i){if(i!==this.getIcon()){if(this._iconImage){this._iconImage.setSrc(i);}else{this._iconImage=a.createControlByURI({id:this.getId()+"-icon",src:i,useIconTooltip:false},sap.m.Image).addStyleClass("sapMDialogIcon");this._createHeader();this._header.insertAggregation("contentMiddle",this._iconImage,0);}}}else{var s=this.getState();if(!e&&s!==V.None){if(this._iconImage){this._iconImage.setSrc(f._mIcons[s]);}}else{if(this._iconImage){this._iconImage.destroy();this._iconImage=null;}}}this.setProperty("icon",i,true);return this;};
f.prototype.setType=function(t){var o=this.getType();if(o===t){return this;}this._bMessageType=(t===sap.m.DialogType.Message);return this.setProperty("type",t,false);};
f.prototype.setStretch=function(s){this._bStretchSet=true;return this.setProperty("stretch",s);};
f.prototype.setStretchOnPhone=function(s){if(this._bStretchSet){q.sap.log.warning("sap.m.Dialog: stretchOnPhone property is deprecated. Setting stretchOnPhone property is ignored when there's already stretch property set.");return this;}this.setProperty("stretchOnPhone",s);return this.setProperty("stretch",s&&D.system.phone);};
f.prototype.setVerticalScrolling=function(v){var o=this.getVerticalScrolling(),h=this._hasSingleScrollableContent();if(h){q.sap.log.warning("sap.m.Dialog: property verticalScrolling automatically reset to false. See documentation.");v=false;}if(o===v){return this;}this.$().toggleClass("sapMDialogVerScrollDisabled",!v);this.setProperty("verticalScrolling",v);if(this._oScroller){this._oScroller.setVertical(v);}return this;};
f.prototype.setHorizontalScrolling=function(v){var o=this.getHorizontalScrolling(),h=this._hasSingleScrollableContent();if(h){q.sap.log.warning("sap.m.Dialog: property horizontalScrolling automatically reset to false. See documentation.");v=false;}if(o===v){return this;}this.$().toggleClass("sapMDialogHorScrollDisabled",!v);this.setProperty("horizontalScrolling",v);if(this._oScroller){this._oScroller.setHorizontal(v);}return this;};
f.prototype.setInitialFocus=function(i){return this.setAssociation("initialFocus",i,true);};
f.prototype.forceInvalidate=C.prototype.invalidate;
f.prototype.invalidate=function(o){if(this.isOpen()){this.forceInvalidate(o);}};
function g(e){var $=q(e);var o=$.control(0);if(!o||o.getMetadata().getInterfaces().indexOf("sap.m.IBar")>-1){return true;}return $.hasClass('sapMDialogTitle');}
if(D.system.desktop){f.prototype.ondblclick=function(e){if(g(e.target)){this._bDisableRepositioning=false;this._oManuallySetPosition=null;this._oManuallySetSize=null;this.oPopup&&this.oPopup._applyPosition(this.oPopup._oLastPosition,true);this._$dialog.removeClass('sapMDialogTouched');}};f.prototype.onmousedown=function(e){if(e.which===3){return;}if(this.getStretch()||(!this.getDraggable()&&!this.getResizable())){return;}var t;var h=this;var $=q(document);var i=q(e.target);var r=i.hasClass('sapMDialogResizeHandler')&&this.getResizable();var m=function(x){t=t?clearTimeout(t):setTimeout(function(){x();},0);};var w=window.innerWidth;var j=window.innerHeight;var k={x:e.pageX,y:e.pageY,width:h._$dialog.width(),height:h._$dialog.height(),outerHeight:h._$dialog.outerHeight(),offset:{x:e.offsetX?e.offsetX:e.originalEvent.layerX,y:e.offsetY?e.offsetY:e.originalEvent.layerY},position:{x:h._$dialog.offset().left,y:h._$dialog.offset().top}};function n(){var x=h.$(),y=h.$('cont'),z,E;$.off("mouseup mousemove");if(r){h._$dialog.removeClass('sapMDialogResizing');z=parseInt(x[0].style.height,10)||parseInt(x.height(),10);E=parseInt(x.css("border-top-width"),10)+parseInt(x.css("border-bottom-width"),10);y.height(z+E);}}if((g(e.target)&&this.getDraggable())||r){h._bDisableRepositioning=true;h._$dialog.addClass('sapDialogDisableTransition');h._$dialog.addClass('sapMDialogTouched');h._oManuallySetPosition={x:k.position.x,y:k.position.y};h._$dialog.css({left:Math.min(Math.max(0,h._oManuallySetPosition.x),w-k.width),top:Math.min(Math.max(0,h._oManuallySetPosition.y),j-k.height),transform:""});}if(g(e.target)&&this.getDraggable()){$.on("mousemove",function(x){if(x.buttons===0){n();return;}m(function(){h._bDisableRepositioning=true;h._oManuallySetPosition={x:x.pageX-e.pageX+k.position.x,y:x.pageY-e.pageY+k.position.y};h._$dialog.css({left:Math.min(Math.max(0,h._oManuallySetPosition.x),w-k.width),top:Math.min(Math.max(0,h._oManuallySetPosition.y),j-k.outerHeight),transform:""});});});}else if(r){h._$dialog.addClass('sapMDialogResizing');var s={};var o=parseInt(h._$dialog.css('min-width'),10);var p=k.x+k.width-o;var u=i.width()-e.offsetX;var v=i.height()-e.offsetY;$.on("mousemove",function(x){m(function(){h._bDisableRepositioning=true;h.$('cont').height('').width('');if(x.pageY+v>j){x.pageY=j-v;}if(x.pageX+u>w){x.pageX=w-u;}h._oManuallySetSize={width:k.width+x.pageX-k.x,height:k.height+x.pageY-k.y};if(h._bRTL){s.left=Math.min(Math.max(x.pageX,0),p);s.transform="";h._oManuallySetSize.width=k.width+k.x-Math.max(x.pageX,0);}s.width=h._oManuallySetSize.width;s.height=h._oManuallySetSize.height;h._$dialog.css(s);});});}else{return;}$.on("mouseup",n);e.preventDefault();e.stopPropagation();};}
f.prototype._applyContextualSettings=function(){M.prototype._applyContextualSettings.call(this,M._defaultContextualSettings);};
return f;},true);
sap.ui.predefine('sap/m/DialogRenderer',['jquery.sap.global','./BarRenderer'],function(q,B){"use strict";var D={};
D.render=function(r,c){var a=c.getId(),t=c.getType(),h=c._getAnyHeader(),s=c.getSubHeader(),m=(t===sap.m.DialogType.Message),l=c.getBeginButton(),R=c.getEndButton(),H=c.getHorizontalScrolling(),v=c.getVerticalScrolling(),S=c.getState(),b=c.getStretch(),d=c.getStretchOnPhone()&&sap.ui.Device.system.phone,e=c.getResizable(),f=c.getDraggable(),V=c.getAggregation("_valueState");if(h){h.applyTagAndContextClassFor("header");}if(s){s.applyTagAndContextClassFor("subheader");}var g=c.getContentWidth()&&c.getContentWidth()!='auto'?' width: '+c.getContentWidth()+';':'';var j=c.getContentHeight()&&c.getContentHeight()!='auto'?' height: '+c.getContentHeight()+';':'';var k="style='"+g+j+"'";r.write('<div '+k);r.writeControlData(c);r.addClass("sapMDialog");r.addClass("sapMDialog-CTX");r.addClass("sapMPopup-CTX");if(c.isOpen()){r.addClass("sapMDialogOpen");}if(window.devicePixelRatio>1){r.addClass("sapMDialogHighPixelDensity");}if(c._bDisableRepositioning){r.addClass("sapMDialogTouched");}if(b||(d)){r.addClass("sapMDialogStretched");}r.addClass(sap.m.Dialog._mStateClasses[S]);var n=!c._oToolbar&&!l&&!R;var o=c._oToolbar&&c._isToolbarEmpty()&&!l&&!R;if(n||o){r.addClass("sapMDialog-NoFooter");}if(!h){r.addClass("sapMDialog-NoHeader");}if(S==="Error"||S==="Warning"){r.writeAccessibilityState(c,{role:"alertdialog"});}else{r.writeAccessibilityState(c,{role:"dialog"});}if(c._forceDisableScrolling){r.addClass("sapMDialogWithScrollCont");}if(s&&s.getVisible()){r.addClass("sapMDialogWithSubHeader");}if(m){r.addClass("sapMMessageDialog");}if(!v){r.addClass("sapMDialogVerScrollDisabled");}if(!H){r.addClass("sapMDialogHorScrollDisabled");}if(sap.ui.Device.system.phone){r.addClass("sapMDialogPhone");}if(f&&!b){r.addClass("sapMDialogDraggable");}if(sap.m._bSizeCompact){r.addClass("sapUiSizeCompact");}r.writeClasses();var T=c.getTooltip_AsString();if(T){r.writeAttributeEscaped("title",T);}r.writeAttribute("tabindex","-1");r.write(">");if(sap.ui.Device.system.desktop){if(e&&!b){r.writeIcon("sap-icon://resize-corner",["sapMDialogResizeHandler"],{"title":""});}r.write('<span id="'+c.getId()+'-firstfe" tabindex="0"/>');}if(h){r.renderControl(h);}if(s){s.addStyleClass("sapMDialogSubHeader");r.renderControl(s);}if(V){r.renderControl(V);}r.write('<section id="'+a+'-cont" class="sapMDialogSection">');r.write('<div id="'+a+'-scroll" class="sapMDialogScroll">');r.write('<div id="'+a+'-scrollCont" class="sapMDialogScrollCont');if(c.getStretch()||j){r.write(' sapMDialogStretchContent');}r.write('">');var C=c.getContent();for(var i=0;i<C.length;i++){r.renderControl(C[i]);}r.write("</div>");r.write("</div>");r.write("</section>");if(!(n||o)){r.renderControl(c._oToolbar);}if(sap.ui.Device.system.desktop){r.write('<span id="'+c.getId()+'-lastfe" tabindex="0"/>');}r.write("</div>");};
return D;},true);
sap.ui.predefine('sap/m/DisplayListItem',['jquery.sap.global','./ListItemBase','./library'],function(q,L,l){"use strict";
var D=L.extend("sap.m.DisplayListItem",{metadata:{library:"sap.m",properties:{label:{type:"string",group:"Misc",defaultValue:null},value:{type:"string",group:"Data",defaultValue:null},valueTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit}}}});
D.prototype.getContentAnnouncement=function(){return this.getLabel()+" "+this.getValue();};
return D;},true);
sap.ui.predefine('sap/m/DisplayListItemRenderer',['jquery.sap.global','./ListItemBaseRenderer','sap/ui/core/Renderer'],function(q,L,R){"use strict";var D=R.extend(L);
D.renderLIAttributes=function(r,l){r.addClass("sapMDLI");};
D.renderLIContent=function(r,l){var i=l.getLabel();if(i){r.write("<label for='"+l.getId()+"-value' class='sapMDLILabel'>");r.writeEscaped(l.getLabel());r.write("</label>");}var a=l.getValue();var v=l.getValueTextDirection();if(a){r.write("<div id='"+l.getId()+"-value' class='sapMDLIValue'");if(v!=sap.ui.core.TextDirection.Inherit){r.writeAttribute("dir",v.toLowerCase());}r.write(">");r.writeEscaped(l.getValue());r.write("</div>");}};
return D;},true);
sap.ui.predefine('sap/m/DraftIndicator',["sap/ui/core/Control","sap/m/Label"],function(C,L){"use strict";
var D=C.extend("sap.m.DraftIndicator",{metadata:{properties:{state:{type:"sap.m.DraftIndicatorState",group:"Behavior",defaultValue:sap.m.DraftIndicatorState.Clear},minDisplayTime:{type:"int",group:"Behavior",defaultValue:1500}},aggregations:{_label:{type:"sap.m.Label",multiple:false,visibility:"hidden"}}}});
var b=sap.ui.getCore().getLibraryResourceBundle("sap.m");D._oTEXTS={};D._oTEXTS[sap.m.DraftIndicatorState.Saving]=b.getText("DRAFT_INDICATOR_SAVING_DRAFT");D._oTEXTS[sap.m.DraftIndicatorState.Saved]=b.getText("DRAFT_INDICATOR_DRAFT_SAVED");D._oTEXTS[sap.m.DraftIndicatorState.Clear]="";
D.prototype.init=function(){this.aQueue=[];this.iDelayedCallId=null;};
D.prototype.setState=function(s){this.setProperty("state",s);this._addToQueue(s);if(s===sap.m.DraftIndicatorState.Saving){this._addToQueue(sap.m.DraftIndicatorState.Clear);}return this;};
D.prototype._getLabel=function(){var c=this.getAggregation('_label');if(!c){var c=new sap.m.Label({id:this.getId()+"-label"});this.setAggregation('_label',c,true);c=this.getAggregation('_label');}return c;};
D.prototype.showDraftSaving=function(){this._addToQueue(sap.m.DraftIndicatorState.Saving);this._addToQueue(sap.m.DraftIndicatorState.Clear);};
D.prototype.showDraftSaved=function(){this._addToQueue(sap.m.DraftIndicatorState.Saved);};
D.prototype.clearDraftState=function(){this._addToQueue(sap.m.DraftIndicatorState.Clear);};
D.prototype._addToQueue=function(s){this.aQueue.push(s);this._processQueue();};
D.prototype._processQueue=function(){if(this.iDelayedCallId){return;}var n=this.aQueue.shift();var t=this.getMinDisplayTime();if(!n){return;}this._applyState(n);if(n===sap.m.DraftIndicatorState.Clear){this._proceed();return;}this.iDelayedCallId=jQuery.sap.delayedCall(t,this,this._proceed);};
D.prototype._proceed=function(){this._resetDraftTimer();this._processQueue();};
D.prototype._applyState=function(s){this._getLabel().setText(D._oTEXTS[s]);};
D.prototype._resetDraftTimer=function(){jQuery.sap.clearDelayedCall(this.iDelayedCallId);this.iDelayedCallId=null;};
return D;},true);
sap.ui.predefine('sap/m/DraftIndicatorRenderer',['jquery.sap.global'],function(q){"use strict";var D={};
D.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapMDraftIndicator");r.writeClasses();r.write(">");var l=c._getLabel();r.renderControl(l);r.write("</div>");};
return D;},true);
sap.ui.predefine('sap/m/FacetFilter',['jquery.sap.global','./NavContainer','./library','sap/ui/core/Control','sap/ui/core/IconPool','sap/ui/core/delegate/ItemNavigation','sap/ui/core/InvisibleText'],function(q,N,l,C,I,a,b){"use strict";
var F=C.extend("sap.m.FacetFilter",{metadata:{interfaces:["sap.ui.core.IShrinkable"],library:"sap.m",properties:{showPersonalization:{type:"boolean",group:"Appearance",defaultValue:false},type:{type:"sap.m.FacetFilterType",group:"Appearance",defaultValue:sap.m.FacetFilterType.Simple},liveSearch:{type:"boolean",group:"Behavior",defaultValue:true},showSummaryBar:{type:"boolean",group:"Behavior",defaultValue:false},showReset:{type:"boolean",group:"Behavior",defaultValue:true},showPopoverOKButton:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"lists",aggregations:{lists:{type:"sap.m.FacetFilterList",multiple:true,singularName:"list"},buttons:{type:"sap.m.Button",multiple:true,singularName:"button",visibility:"hidden"},removeFacetIcons:{type:"sap.ui.core.Icon",multiple:true,singularName:"removeFacetIcon",visibility:"hidden"},popover:{type:"sap.m.Popover",multiple:false,visibility:"hidden"},addFacetButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},dialog:{type:"sap.m.Dialog",multiple:false,visibility:"hidden"},summaryBar:{type:"sap.m.Toolbar",multiple:false,visibility:"hidden"},resetButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},arrowLeft:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},arrowRight:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},events:{reset:{},confirm:{}}}});
F.SCROLL_STEP=264;
F.prototype.setType=function(t){var s=this.getAggregation("summaryBar");if(sap.ui.Device.system.phone){this.setProperty("type",sap.m.FacetFilterType.Light);s.setActive(true);}else{this.setProperty("type",t);s.setActive(t===sap.m.FacetFilterType.Light);}if(t===sap.m.FacetFilterType.Light){if(this.getShowReset()){this._addResetToSummary(s);}else{this._removeResetFromSummary(s);}}return this;};
F.prototype.setShowReset=function(v){this.setProperty("showReset",v);var s=this.getAggregation("summaryBar");if(v){if(this.getShowSummaryBar()||this.getType()===sap.m.FacetFilterType.Light){this._addResetToSummary(s);}}else{if(this.getShowSummaryBar()||this.getType()===sap.m.FacetFilterType.Light){this._removeResetFromSummary(s);}}return this;};
F.prototype.setShowSummaryBar=function(v){this.setProperty("showSummaryBar",v);if(v){var s=this.getAggregation("summaryBar");if(this.getShowReset()){this._addResetToSummary(s);}else{this._removeResetFromSummary(s);}s.setActive(this.getType()===sap.m.FacetFilterType.Light);}return this;};
F.prototype.setLiveSearch=function(v){this.setProperty("liveSearch",v);if(this._displayedList){var L=this._displayedList;var s=sap.ui.getCore().byId(L.getAssociation("search"));s.detachLiveChange(L._handleSearchEvent,L);if(v){s.attachLiveChange(L._handleSearchEvent,L);}}return this;};
F.prototype.getLists=function(){var L=this.getAggregation("lists");if(!L){L=[];}if(this._displayedList){L.splice(this._listAggrIndex,0,this._displayedList);}return L;};
F.prototype.removeList=function(o){var L=sap.ui.base.ManagedObject.prototype.removeAggregation.call(this,"lists",o);this._removeList(L);return L;};
F.prototype.removeAggregation=function(){var L=sap.ui.base.ManagedObject.prototype.removeAggregation.apply(this,arguments);if(arguments[0]==="lists"){this._removeList(L);}return L;};
F.prototype.openFilterDialog=function(){var d=this._getFacetDialog();var n=this._getFacetDialogNavContainer();d.addContent(n);this.getLists().forEach(function(L){L._preserveOriginalActiveState();});d.setInitialFocus(n.getPages()[0].getContent()[0].getItems()[0]);d.open();return this;};
F.prototype.init=function(){this._pageSize=5;this._addDelegateFlag=false;this._invalidateFlag=false;this._closePopoverFlag=false;this._lastCategoryFocusIndex=0;this._aDomRefs=null;this._previousTarget=null;this._addTarget=null;this._aRows=null;this._bundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this.data("sap-ui-fastnavgroup","true",true);this._buttons={};this._aOwnedLabels=[];this._removeFacetIcons={};this._listAggrIndex=-1;this._displayedList=null;this._lastScrolling=false;this._bPreviousScrollForward=false;this._bPreviousScrollBack=false;this._getAddFacetButton();this._getSummaryBar();this.setAggregation("resetButton",this._createResetButton());if(q.sap.touchEventMode==="ON"&&!sap.ui.Device.system.phone){this._enableTouchSupport();}if(sap.ui.Device.system.phone){this.setType(sap.m.FacetFilterType.Light);}};
F.prototype.exit=function(){var c;sap.ui.getCore().detachIntervalTimer(this._checkOverflow,this);if(this.oItemNavigation){this.removeDelegate(this.oItemNavigation);this.oItemNavigation.destroy();}if(this._aOwnedLabels){this._aOwnedLabels.forEach(function(i){c=sap.ui.getCore().byId(i);if(c){c.destroy();}});this._aOwnedLabels=null;}};
F.prototype.onBeforeRendering=function(){if(this.getShowSummaryBar()||this.getType()===sap.m.FacetFilterType.Light){var s=this.getAggregation("summaryBar");var t=s.getContent()[0];t.setText(this._getSummaryText());t.setTooltip(this._getSummaryText());}sap.ui.getCore().detachIntervalTimer(this._checkOverflow,this);};
F.prototype.onAfterRendering=function(){if(this.getType()!==sap.m.FacetFilterType.Light&&!sap.ui.Device.system.phone){sap.ui.getCore().attachIntervalTimer(this._checkOverflow,this);}this._startItemNavigation();};
F.prototype._startItemNavigation=function(){var f=this.getDomRef(),r=f.getElementsByClassName("sapMFFHead"),d=[];if(r.length>0){for(var i=0;i<r[0].childNodes.length;i++){if(r[0].childNodes[i].id.indexOf("ff")<0&&r[0].childNodes[i].id.indexOf("icon")<0&&r[0].childNodes[i].id.indexOf("add")<0){d.push(r[0].childNodes[i]);}if(r[0].childNodes[i].id.indexOf("add")>=0){d.push(r[0].childNodes[i]);}}}if(d!=""){this._aDomRefs=d;}if((!this.oItemNavigation)||this._addDelegateFlag==true){this.oItemNavigation=new a();this.addDelegate(this.oItemNavigation);this._addDelegateFlag=false;}this._aRows=r;for(var i=0;i<this.$().find(":sapTabbable").length;i++){if(this.$().find(":sapTabbable")[i].id.indexOf("add")>=0){this._addTarget=this.$().find(":sapTabbable")[i];break;}}this.oItemNavigation.setRootDomRef(f);this.oItemNavigation.setItemDomRefs(d);this.oItemNavigation.setCycling(false);this.oItemNavigation.setPageSize(this._pageSize);};
F.prototype.onsapdelete=function(e){var B,L;if(!this.getShowPersonalization()){return;}B=sap.ui.getCore().byId(e.target.id);if(!B){return;}L=sap.ui.getCore().byId(B.getAssociation("list"));if(!L){return;}if(!L.getShowRemoveFacetIcon()){return;}L.removeSelections(true);L.setSelectedKeys();L.setProperty("active",false,true);this.invalidate();var t=this.$().find(":sapTabbable");q(t[t.length-1]).focus();var n=this.oItemNavigation.getFocusedIndex();q(e.target).blur();this.oItemNavigation.setFocusedIndex(n+1);this.focus();if(this.oItemNavigation.getFocusedIndex()==0){for(var k=0;k<this.$().find(":sapTabbable").length-1;k++){if(t[k].id.indexOf("add")>=0){q(t[k]).focus();}}}};
F.prototype.onsaptabnext=function(e){this._previousTarget=e.target;if(e.target.parentNode.className=="sapMFFHead"){for(var i=0;i<this.$().find(":sapTabbable").length;i++){if(this.$().find(":sapTabbable")[i].parentNode.className=="sapMFFResetDiv"){q(this.$().find(":sapTabbable")[i]).focus();e.preventDefault();e.setMarked();return;}}}this._lastCategoryFocusIndex=this.oItemNavigation.getFocusedIndex();if(this._invalidateFlag==true){this.oItemNavigation.setFocusedIndex(-1);this.focus();this._invalidateFlag=false;}if(this._closePopoverFlag==true){this.oItemNavigation.setFocusedIndex(-1);this.focus();this._closePopoverFlag=false;}};
F.prototype.onsaptabprevious=function(e){if(e.target.parentNode.className=="sapMFFResetDiv"&&this._previousTarget==null){q(this.$().find(":sapTabbable")[0]).focus();e.preventDefault();e.setMarked();return;}if(e.target.parentNode.className=="sapMFFResetDiv"&&this._previousTarget!=null&&this._previousTarget.id!=e.target.id){q(this._previousTarget).focus();e.preventDefault();e.setMarked();return;}if(e.target.id.indexOf("add")>=0||e.target.parentNode.className=="sapMFFHead"){this._previousTarget=e.target;q(this.$().find(":sapTabbable")[0]).focus();}};
F.prototype.onsapend=function(e){if(this._addTarget!=null){q(this._addTarget).focus();e.preventDefault();e.setMarked();}else{q(this._aRows[this._aRows.length-1]).focus();e.preventDefault();e.setMarked();}this._previousTarget=e.target;};
F.prototype.onsaphome=function(e){q(this._aRows[0]).focus();e.preventDefault();e.setMarked();this._previousTarget=e.target;};
F.prototype.onsappageup=function(e){this._previousTarget=e.target;};
F.prototype.onsappagedown=function(e){this._previousTarget=e.target;};
F.prototype.onsapincreasemodifiers=function(e){if(e.which==q.sap.KeyCodes.ARROW_RIGHT){this._previousTarget=e.target;var c=this.oItemNavigation.getFocusedIndex()-1;var n=c+this._pageSize;q(e.target).blur();this.oItemNavigation.setFocusedIndex(n);this.focus();}};
F.prototype.onsapdecreasemodifiers=function(e){var c=0;if(e.which==q.sap.KeyCodes.ARROW_LEFT){this._previousTarget=e.target;c=this.oItemNavigation.getFocusedIndex()+1;var n=c-this._pageSize;q(e.target).blur();this.oItemNavigation.setFocusedIndex(n);this.focus();}};
F.prototype.onsapdownmodifiers=function(e){this._previousTarget=e.target;var c=0;c=this.oItemNavigation.getFocusedIndex()-1;var n=c+this._pageSize;q(e.target).blur();this.oItemNavigation.setFocusedIndex(n);this.focus();};
F.prototype.onsapupmodifiers=function(e){this._previousTarget=e.target;var c=0;c=this.oItemNavigation.getFocusedIndex();if(c!=0){c=c+1;}var n=c-this._pageSize;q(e.target).blur();this.oItemNavigation.setFocusedIndex(n);this.focus();};
F.prototype.onsapexpand=function(e){this._previousTarget=e.target;var n=this.oItemNavigation.getFocusedIndex()+1;q(e.target).blur();this.oItemNavigation.setFocusedIndex(n);this.focus();};
F.prototype.onsapcollapse=function(e){this._previousTarget=e.target;var n=this.oItemNavigation.getFocusedIndex()-1;q(e.target).blur();this.oItemNavigation.setFocusedIndex(n);this.focus();};
F.prototype.onsapdown=function(e){this._previousTarget=e.target;if(e.target.parentNode.className=="sapMFFResetDiv"){q(e.target).focus();e.preventDefault();e.setMarked();return;}};
F.prototype.onsapup=function(e){this._previousTarget=e.target;if(e.target.parentNode.className=="sapMFFResetDiv"){q(e.target).focus();e.preventDefault();e.setMarked();}};
F.prototype.onsapleft=function(e){this._previousTarget=e.target;if(e.target.parentNode.className=="sapMFFResetDiv"){q(e.target).focus();e.preventDefault();e.setMarked();}};
F.prototype.onsapright=function(e){this._previousTarget=e.target;if(e.target.parentNode.className=="sapMFFResetDiv"){q(e.target).focus();e.preventDefault();e.setMarked();}};
F.prototype.onsapescape=function(e){if(e.target.parentNode.className=="sapMFFResetDiv"){return;}var n=this._lastCategoryFocusIndex;q(e.target).blur();this.oItemNavigation.setFocusedIndex(n);this.focus();};
F.prototype._getPopover=function(){var p=this.getAggregation("popover");if(!p){var t=this;p=new sap.m.Popover({placement:sap.m.PlacementType.Bottom,beforeOpen:function(e){if(t._displayedList){t._displayedList._setSearchValue("");}this.setCustomHeader(t._createFilterItemsSearchFieldBar(t._displayedList));var s=this.getSubHeader();if(!s){this.setSubHeader(t._createSelectAllCheckboxBar(t._displayedList));}c(t._displayedList);},afterClose:function(e){t._addDelegateFlag=true;t._closePopoverFlag=true;if(sap.ui.Device.browser.internet_explorer&&sap.ui.Device.browser.version<10){q.sap.delayedCall(100,t,t._handlePopoverAfterClose);}else{t._handlePopoverAfterClose();}},horizontalScrolling:false});this.setAggregation("popover",p,true);p.setContentWidth("30%");if(sap.ui.Device.browser.internet_explorer&&sap.ui.Device.browser.version<10){p.setContentWidth("30%");}p.addStyleClass("sapMFFPop");var c=function(L){if(!L){return;}var i=t._getFacetRemoveIcon(L);if(i){i._bTouchStarted=false;}};}if(this.getShowPopoverOKButton()){this._addOKButtonToPopover(p);}else{p.destroyAggregation("footer");}return p;};
F.prototype._handlePopoverAfterClose=function(){var p=this.getAggregation("popover"),L=this._displayedList;if(!p){return;}var i=this._getFacetRemoveIcon(L);if(i&&i._bTouchStarted){return;}this._restoreListFromDisplayContainer(p);this._displayRemoveIcon(false,L);L._fireListCloseEvent();this._fireConfirmEvent();this.destroyAggregation("popover");if(this._oOpenPopoverDeferred){q.sap.delayedCall(0,this,function(){this._oOpenPopoverDeferred.resolve();this._oOpenPopoverDeferred=undefined;});}};
F.prototype._fireConfirmEvent=function(){this.fireEvent('confirm');};
F.prototype._openPopover=function(p,c){if(!p.isOpen()){var L=sap.ui.getCore().byId(c.getAssociation("list"));L.fireListOpen({});this._moveListToDisplayContainer(L,p);p.openBy(c);if(L.getShowRemoveFacetIcon()){this._displayRemoveIcon(true,L);}if(L.getWordWrap()){p.setContentWidth("30%");}L._applySearch();}return this;};
F.prototype._getAddFacetButton=function(){var B=this.getAggregation("addFacetButton");if(!B){var t=this;var B=new sap.m.Button(this.getId()+"-add",{icon:I.getIconURI("add-filter"),type:sap.m.ButtonType.Transparent,tooltip:this._bundle.getText("FACETFILTER_ADDFACET"),press:function(e){t.openFilterDialog();}});this.setAggregation("addFacetButton",B,true);}return B;};
F.prototype._getButtonForList=function(L){if(this._buttons[L.getId()]){this._setButtonText(L);return this._buttons[L.getId()];}var t=this;var B=new sap.m.Button({type:sap.m.ButtonType.Transparent,press:function(e){var T=this;var o=function(){var p=t._getPopover();t._openPopover(p,T);};L._preserveOriginalActiveState();if(sap.ui.Device.browser.internet_explorer&&sap.ui.Device.browser.version<10){q.sap.delayedCall(100,this,o);}else{var p=t._getPopover();if(p.isOpen()){q.sap.delayedCall(100,this,function(){if(p.isOpen()){return;}t._oOpenPopoverDeferred=q.Deferred();t._oOpenPopoverDeferred.promise().done(o);});}else{q.sap.delayedCall(100,this,o);}}}});this._buttons[L.getId()]=B;this.addAggregation("buttons",B);B.setAssociation("list",L.getId(),true);this._setButtonText(L);return B;};
F.prototype._setButtonText=function(L){var B=this._buttons[L.getId()];if(B){var t="";var s=Object.getOwnPropertyNames(L._oSelectedKeys);var i=s.length;if(i===1){var S=L._oSelectedKeys[s[0]];t=this._bundle.getText("FACETFILTER_ITEM_SELECTION",[L.getTitle(),S]);}else if(i>0&&i===L._getNonGroupItems().length){t=this._bundle.getText("FACETFILTER_ALL_SELECTED",[L.getTitle()]);}else if(i>0){t=this._bundle.getText("FACETFILTER_ITEM_SELECTION",[L.getTitle(),i]);}else{t=L.getTitle();}B.setText(t);B.setTooltip(t);}};
F.prototype._getFacetRemoveIcon=function(L){var t=this,i=this._removeFacetIcons[L.getId()];if(!i){i=new sap.ui.core.Icon({src:I.getIconURI("sys-cancel"),tooltip:this._bundle.getText("FACETFILTER_REMOVE"),press:function(){i._bPressed=true;}});i.addDelegate({ontouchstart:function(){i._bTouchStarted=true;i._bPressed=false;},ontouchend:function(){t._displayRemoveIcon(false,L);i._bTouchStarted=false;q.sap.delayedCall(100,this,p);}},true);var p=function(){if(i._bPressed){L.removeSelections(true);L.setSelectedKeys();L.setProperty("active",false,true);}t._handlePopoverAfterClose();};i.setAssociation("list",L.getId(),true);i.addStyleClass("sapMFFLRemoveIcon");this._removeFacetIcons[L.getId()]=i;this.addAggregation("removeFacetIcons",i);this._displayRemoveIcon(false,L);}return i;};
F.prototype._displayRemoveIcon=function(d,L){if(this.getShowPersonalization()){var i=this._removeFacetIcons[L.getId()];if(d){i.removeStyleClass("sapMFFLHiddenRemoveIcon");i.addStyleClass("sapMFFLVisibleRemoveIcon");}else{i.removeStyleClass("sapMFFLVisibleRemoveIcon");i.addStyleClass("sapMFFLHiddenRemoveIcon");}}};
F.prototype._getFacetDialogNavContainer=function(){var n=new N({autoFocus:false});var f=this._createFacetPage();n.addPage(f);n.setInitialPage(f);var t=this;n.attachAfterNavigate(function(e){var T=e.getParameters()["to"];var o=e.getParameters()['from'];if(o===f){var c=T.getContent(0)[1].getItems()[0];if(c){c.focus();}}if(T===f){o.destroySubHeader();o.destroyContent();t._selectedFacetItem.invalidate();T.invalidate();q.sap.focus(t._selectedFacetItem);t._selectedFacetItem=null;}});return n;};
F.prototype._createFacetPage=function(){var f=this._createFacetList();var o=new sap.m.SearchField({width:"100%",tooltip:this._bundle.getText("FACETFILTER_SEARCH"),liveChange:function(e){var c=f.getBinding("items");if(c){var d=new sap.ui.model.Filter("text",sap.ui.model.FilterOperator.Contains,e.getParameters()["newValue"]);c.filter([d]);}}});var p=new sap.m.Page({enableScrolling:true,title:this._bundle.getText("FACETFILTER_TITLE"),subHeader:new sap.m.Bar({contentMiddle:o}),content:[f]});return p;};
F.prototype._createFilterItemsPage=function(){var t=this;var p=new sap.m.Page({showNavButton:true,enableScrolling:true,navButtonPress:function(e){var n=e.getSource().getParent();t._navFromFilterItemsPage(n);}});return p;};
F.prototype._getFilterItemsPage=function(n){var o=n.getPages()[1];if(o){n.removePage(o);o.destroy();}var p=this._createFilterItemsPage();n.addPage(p);return p;};
F.prototype._createFilterItemsSearchFieldBar=function(L){var t=this;var s=true;if(L.getDataType()!=sap.m.FacetFilterListDataType.String){s=false;}var S=new sap.m.SearchField({value:L._getSearchValue(),width:"100%",enabled:s,tooltip:this._bundle.getText("FACETFILTER_SEARCH"),search:function(e){t._displayedList._handleSearchEvent(e);}});if(this.getLiveSearch()){S.attachLiveChange(L._handleSearchEvent,L);}var B=new sap.m.Bar({contentMiddle:S});L.setAssociation("search",S);return B;};
F.prototype._getFacetDialog=function(){var d=this.getAggregation("dialog");if(!d){var t=this;d=new sap.m.Dialog({showHeader:false,stretch:sap.ui.Device.system.phone?true:false,afterClose:function(){t._addDelegateFlag=true;t._invalidateFlag=true;var n=this.getContent()[0];var f=n.getPages()[1];if(n.getCurrentPage()===f){var L=t._restoreListFromDisplayContainer(f);L._updateActiveState();L._fireListCloseEvent();}this.destroyAggregation("content",true);t.invalidate();},beginButton:new sap.m.Button({text:this._bundle.getText("FACETFILTER_ACCEPT"),tooltip:this._bundle.getText("FACETFILTER_ACCEPT"),press:function(){t._closeDialog();}}),contentHeight:"500px"});d.addStyleClass("sapMFFDialog");d.onsapentermodifiers=function(e){if(e.shiftKey&&!e.ctrlKey&&!e.altKey){var n=this.getContent()[0];t._navFromFilterItemsPage(n);}};this.setAggregation("dialog",d,true);}return d;};
F.prototype._closeDialog=function(){var d=this.getAggregation("dialog");if(d&&d.isOpen()){d.close();this._fireConfirmEvent();}};
F.prototype._closePopover=function(){var p=this.getAggregation("popover");if(p&&p.isOpen()){p.close();}};
F.prototype._createFacetList=function(){var f=new sap.m.List({mode:sap.m.ListMode.None,items:{path:"/items",template:new sap.m.StandardListItem({title:"{text}",counter:"{count}",type:sap.m.ListType.Navigation,customData:[new sap.ui.core.CustomData({key:"index",value:"{index}"})]})}});var c=[];for(var i=0;i<this.getLists().length;i++){var L=this.getLists()[i];c.push({text:L.getTitle(),count:L.getAllCount(),index:i});}var m=new sap.ui.model.json.JSONModel({items:c});if(c.length>100){m.setSizeLimit(c.length);}var t=this;f.attachUpdateFinished(function(){for(var i=0;i<f.getItems().length;i++){var o=this.getItems()[i];o.detachPress(t._handleFacetListItemPress,t);o.attachPress(t._handleFacetListItemPress,t);}});f.setModel(m);return f;};
F.prototype._createSelectAllCheckboxBar=function(L){if(!L.getMultiSelect()){return null;}var s=L.getActive()&&L.getItems().length>0&&Object.getOwnPropertyNames(L._oSelectedKeys).length===L.getItems().length;var c=new sap.m.CheckBox(L.getId()+"-selectAll",{text:this._bundle.getText("FACETFILTER_CHECKBOX_ALL"),tooltip:this._bundle.getText("FACETFILTER_CHECKBOX_ALL"),selected:s,select:function(e){c.setSelected(e.getParameter("selected"));L._handleSelectAllClick(e.getParameter("selected"));}});L.setAssociation("allcheckbox",c);var B=new sap.m.Bar();B.addEventDelegate({ontap:function(e){if(e.srcControl===this){L._handleSelectAllClick(c.getSelected());}}},B);B.addContentLeft(c);B.addStyleClass("sapMFFCheckbar");return B;};
F.prototype._handleFacetListItemPress=function(e){this._navToFilterItemsPage(e.getSource());};
F.prototype._navToFilterItemsPage=function(f){this._selectedFacetItem=f;var n=this.getAggregation("dialog").getContent()[0];var c=f.getCustomData();var i=c[0].getValue();var o=this.getLists()[i];this._listIndexAgg=this.indexOfAggregation("lists",o);if(this._listIndexAgg==i){var d=this._getFilterItemsPage(n);o.fireListOpen({});this._moveListToDisplayContainer(o,d);d.setSubHeader(this._createFilterItemsSearchFieldBar(o));var e=this._createSelectAllCheckboxBar(o);if(e){d.insertContent(e,0);}d.setTitle(o.getTitle());n.to(d);}};
F.prototype._navFromFilterItemsPage=function(n){var f=n.getPages()[1];var L=this._restoreListFromDisplayContainer(f);L._updateActiveState();L._fireListCloseEvent();this._selectedFacetItem.setCounter(L.getAllCount());n.backToTop();};
F.prototype._moveListToDisplayContainer=function(L,c){this._listAggrIndex=this.indexOfAggregation("lists",L);sap.ui.base.ManagedObject.prototype.removeAggregation.call(this,"lists",L,true);c.addAggregation("content",L,false);L.setAssociation("facetFilter",this,true);this._displayedList=L;};
F.prototype._restoreListFromDisplayContainer=function(c){var L=c.removeAggregation("content",this._displayedList,true);this.insertAggregation("lists",L,this._listAggrIndex,L.getActive());this._listAggrIndex=-1;this._displayedList=null;return L;};
F.prototype._getSequencedLists=function(){var m=-1;var s=[];var L=this.getLists();if(L.length>0){for(var i=0;i<L.length;i++){if(L[i].getActive()){if(L[i].getSequence()<-1){L[i].setSequence(-1);}else if(L[i].getSequence()>m){m=L[i].getSequence();}s.push(L[i]);}else if(!L[i].getRetainListSequence()){L[i].setSequence(-1);}}for(var j=0;j<s.length;j++){if(s[j].getSequence()<=-1){m+=1;s[j].setSequence(m);}}if(s.length>1){s.sort(function(c,d){return c.getSequence()-d.getSequence();});}}return s;};
F.prototype._getSummaryBar=function(){var s=this.getAggregation("summaryBar");if(!s){var t=new sap.m.Text({maxLines:1});var c=this;s=new sap.m.Toolbar({content:[t],active:this.getType()===sap.m.FacetFilterType.Light?true:false,design:sap.m.ToolbarDesign.Info,press:function(e){c.openFilterDialog();}});var f=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("FACETFILTER_ARIA_FACET_FILTER"),i=new b({text:f}).toStatic().getId();this._aOwnedLabels.push(i);s._setRootAccessibilityRole("button");s._sInternalAriaLabelId=i;this.setAggregation("summaryBar",s);}return s;};
F.prototype._createResetButton=function(){var t=this;var B=new sap.m.Button({type:sap.m.ButtonType.Transparent,icon:I.getIconURI("undo"),tooltip:this._bundle.getText("FACETFILTER_RESET"),press:function(e){t._addDelegateFlag=true;t._invalidateFlag=true;t.fireReset();var L=t.getLists();for(var i=0;i<L.length;i++){L[i]._searchValue="";L[i]._applySearch();q.sap.focus(L[i].getItems()[0]);}t.invalidate();}});return B;};
F.prototype._addOKButtonToPopover=function(p){var B=p.getFooter();if(!B){var t=this;var B=new sap.m.Button({text:this._bundle.getText("FACETFILTER_ACCEPT"),tooltip:this._bundle.getText("FACETFILTER_ACCEPT"),width:"100%",press:function(){t._closePopover();}});p.setFooter(B);}return B;};
F.prototype._getSummaryText=function(){var c=", ";var S=" ";var f="";var d=true;var L=this.getLists();if(L.length>0){for(var i=0;i<L.length;i++){var o=L[i];if(o.getActive()){var e=this._getSelectedItemsText(o);var t="";for(var j=0;j<e.length;j++){t=t+e[j]+c;}if(t){t=t.substring(0,t.lastIndexOf(c)).trim();if(d){f=this._bundle.getText("FACETFILTER_INFOBAR_FILTERED_BY",[o.getTitle(),t]);d=false;}else{f=f+S+this._bundle.getText("FACETFILTER_INFOBAR_AND")+S+this._bundle.getText("FACETFILTER_INFOBAR_AFTER_AND",[o.getTitle(),t]);}}}}}if(!f){f=this._bundle.getText("FACETFILTER_INFOBAR_NO_FILTERS");}return f;};
F.prototype._getSelectedItemsText=function(L){var t=L.getSelectedItems().map(function(v){return v.getText();});L._oSelectedKeys&&Object.getOwnPropertyNames(L._oSelectedKeys).forEach(function(v){t.indexOf(L._oSelectedKeys[v])===-1&&t.push(L._oSelectedKeys[v]);});return t;};
F.prototype._addResetToSummary=function(s){if(s.getContent().length===1){s.addContent(new sap.m.ToolbarSpacer({width:""}));var B=this._createResetButton();s.addContent(B);B.addStyleClass("sapUiSizeCompact");B.addStyleClass("sapMFFRefresh");B.addStyleClass("sapMFFBtnHoverable");}};
F.prototype._removeResetFromSummary=function(s){if(s.getContent().length===3){var S=s.removeAggregation("content",1);S.destroy();var B=s.removeAggregation("content",1);B.destroy();}};
F.prototype._removeList=function(L){if(L){var B=this._buttons[L.getId()];if(B){this.removeAggregation("buttons",B);B.destroy();}var r=this._removeFacetIcons[L.getId()];if(r){this.removeAggregation("removeIcons",r);r.destroy();}delete this._buttons[L.getId()];delete this._removeFacetIcons[L.getId()];}};
F.prototype._getScrollingArrow=function(n){var A=null;var p={src:"sap-icon://navigation-"+n+"-arrow"};if(n==="left"){A=this.getAggregation("arrowLeft");if(!A){p.id=this.getId()+"-arrowScrollLeft";A=I.createControlByURI(p);var c=["sapMPointer","sapMFFArrowScroll","sapMFFArrowScrollLeft"];for(var i=0;i<c.length;i++){A.addStyleClass(c[i]);A.setTooltip(this._bundle.getText("FACETFILTER_PREVIOUS"));}this.setAggregation("arrowLeft",A);}}else if(n==="right"){A=this.getAggregation("arrowRight");if(!A){p.id=this.getId()+"-arrowScrollRight";A=I.createControlByURI(p);var d=["sapMPointer","sapMFFArrowScroll","sapMFFArrowScrollRight"];for(var i=0;i<d.length;i++){A.addStyleClass(d[i]);A.setTooltip(this._bundle.getText("FACETFILTER_NEXT"));}this.setAggregation("arrowRight",A);}}else{q.sap.log.error("Scrolling arrow name "+n+" is not valid");}return A;};
F.prototype._checkOverflow=function(){var B=this.getDomRef("head"),L=q(B),$=this.$(),s=false,S=false,c=false,i=null,d=null,e=null;if(B){i=B.scrollLeft;d=B.scrollWidth;e=B.clientWidth;if(d>e){if(d-e==1){d=e;}else{c=true;}}$.toggleClass("sapMFFScrolling",c);$.toggleClass("sapMFFNoScrolling",!c);this._lastScrolling=c;if(!this._bRtl){s=i>0;S=(d>e)&&(d>i+e);}else{S=L.scrollLeftRTL()>0;s=L.scrollRightRTL()>0;}if((S!=this._bPreviousScrollForward)||(s!=this._bPreviousScrollBack)){$.toggleClass("sapMFFNoScrollBack",!s);$.toggleClass("sapMFFNoScrollForward",!S);}}};
F.prototype.onclick=function(e){var t=e.target.id;if(t){var i=this.getId();e.preventDefault();if(t==i+"-arrowScrollLeft"){this._scroll(-F.SCROLL_STEP,500);}else if(t==i+"-arrowScrollRight"){this._scroll(F.SCROLL_STEP,500);}}};
F.prototype._scroll=function(d,D){var o=this.getDomRef("head");var s=o.scrollLeft;if(!sap.ui.Device.browser.internet_explorer&&this._bRtl){d=-d;}var S=s+d;q(o).stop(true,true).animate({scrollLeft:S},D);};
F.prototype._enableTouchSupport=function(){var t=this;var T=function(e){var s=t.getType();if(s===sap.m.FacetFilterType.Light){return;}e.preventDefault();if(t._iInertiaIntervalId){window.clearInterval(t._iInertiaIntervalId);}t.startScrollX=t.getDomRef("head").scrollLeft;t.startTouchX=e.touches[0].pageX;t._bTouchNotMoved=true;t._lastMoveTime=new Date().getTime();};var f=function(e){var s=t.getType();if(s===sap.m.FacetFilterType.Light){return;}var d=e.touches[0].pageX-t.startTouchX;var L=t.getDomRef("head");var o=L.scrollLeft;var n=t.startScrollX-d;L.scrollLeft=n;t._bTouchNotMoved=false;var g=new Date().getTime()-t._lastMoveTime;t._lastMoveTime=new Date().getTime();if(g>0){t._velocity=(n-o)/g;}e.preventDefault();};var c=function(e){var s=t.getType();if(s===sap.m.FacetFilterType.Light){return;}if(t._bTouchNotMoved===false){e.preventDefault();var L=t.getDomRef("head");var d=50;var g=Math.abs(t._velocity/10);t._iInertiaIntervalId=window.setInterval(function(){t._velocity=t._velocity*0.80;var h=t._velocity*d;L.scrollLeft=L.scrollLeft+h;if(Math.abs(t._velocity)<g){window.clearInterval(t._iInertiaIntervalId);t._iInertiaIntervalId=undefined;}},d);}else if(t._bTouchNotMoved===true){t.onclick(e);e.preventDefault();}t._bTouchNotMoved=undefined;t._lastMoveTime=undefined;};this.addEventDelegate({ontouchstart:T},this);this.addEventDelegate({ontouchend:c},this);this.addEventDelegate({ontouchmove:f},this);};
return F;},true);
sap.ui.predefine('sap/m/FacetFilterItem',['jquery.sap.global','./ListItemBase','./library'],function(q,L,l){"use strict";
var F=L.extend("sap.m.FacetFilterItem",{metadata:{library:"sap.m",properties:{key:{type:"string",group:"Data",defaultValue:null},text:{type:"string",group:"Misc",defaultValue:null},count:{type:"int",group:"Misc",defaultValue:null,deprecated:true}}}});
F.prototype.setCount=function(c){this.setProperty("count",c);this.setProperty("counter",c);return this;};
F.prototype.setCounter=function(c){this.setProperty("count",c);this.setProperty("counter",c);return this;};
F.prototype.init=function(){this.attachEvent("_change",this._itemTextChange);L.prototype.init.apply(this);this.addStyleClass("sapMFFLI");};
F.prototype.exit=function(){L.prototype.exit.apply(this);this.detachEvent("_change",this._itemTextChange);};
F.prototype._itemTextChange=function(e){if(e.getParameter("name")==="text"){this.informList("TextChange",e.getParameter("newValue"));}};
return F;},true);
sap.ui.predefine('sap/m/FacetFilterItemRenderer',['jquery.sap.global','./ListItemBaseRenderer','sap/ui/core/Renderer'],function(q,L,R){"use strict";var F=R.extend(L);
F.renderLIContent=function(r,c){r.write("<div");if(c.getParent()&&c.getParent().getWordWrap()){r.addClass("sapMFFLITitleWrap");}else{r.addClass("sapMFFLITitle");}r.writeClasses();r.write(">");r.writeEscaped(c.getText());r.write("</div>");};
return F;},true);
sap.ui.predefine('sap/m/FacetFilterList',['jquery.sap.global','./List','./library'],function(q,L,l){"use strict";
var F=L.extend("sap.m.FacetFilterList",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Appearance",defaultValue:null},wordWrap:{type:"boolean",group:"Appearance",defaultValue:false},multiSelect:{type:"boolean",group:"Behavior",defaultValue:true,deprecated:true},active:{type:"boolean",group:"Behavior",defaultValue:true},enableCaseInsensitiveSearch:{type:"boolean",group:"Behavior",defaultValue:false,deprecated:false},allCount:{type:"int",group:"Appearance",defaultValue:null},sequence:{type:"int",group:"Behavior",defaultValue:-1},key:{type:"string",group:"Identification",defaultValue:null},showRemoveFacetIcon:{type:"boolean",group:"Misc",defaultValue:true},retainListSequence:{type:"boolean",group:"Misc",defaultValue:false},dataType:{type:"sap.m.FacetFilterListDataType",group:"Misc",defaultValue:sap.m.FacetFilterListDataType.String}},events:{listOpen:{},listClose:{parameters:{selectedItems:{type:"sap.m.FacetFilterItem[]"},allSelected:{type:"boolean"},selectedKeys:{type:"object"}}}}}});
F.prototype.setTitle=function(t){this.setProperty("title",t,true);this._updateFacetFilterButtonText();return this;};
F.prototype.setMultiSelect=function(v){this.setProperty("multiSelect",v,true);var m=v?sap.m.ListMode.MultiSelect:sap.m.ListMode.SingleSelectMaster;this.setMode(m);return this;};
F.prototype.setMode=function(m){if(m===sap.m.ListMode.MultiSelect||m===sap.m.ListMode.SingleSelectMaster){L.prototype.setMode.call(this,m);this.setProperty("multiSelect",m===sap.m.ListMode.MultiSelect?true:false,true);}return this;};
F.prototype._applySearch=function(){var s=this._getSearchValue();if(s!=null){this._search(s,true);this._updateSelectAllCheckBox();}};
F.prototype.getSelectedItems=function(){var s=[];var c={};var C=sap.m.ListBase.prototype.getSelectedItems.apply(this,arguments);C.forEach(function(i){s.push(new sap.m.FacetFilterItem({text:i.getText(),key:i.getKey(),selected:true}));c[i.getKey()]=true;});var S=this.getSelectedKeys();var a=Object.getOwnPropertyNames(S);if(C.length<a.length){a.forEach(function(k){if(!c[k]){s.push(new sap.m.FacetFilterItem({text:S[k],key:k,selected:true}));}});}return s;};
F.prototype.getSelectedItem=function(){var i=sap.m.ListBase.prototype.getSelectedItem.apply(this,arguments);var s=Object.getOwnPropertyNames(this.getSelectedKeys());if(!i&&s.length>0){i=new sap.m.FacetFilterItem({text:this.getSelectedKeys()[s[0]],key:s[0],selected:true});}return i;};
F.prototype.removeSelections=function(a){if(this._allowRemoveSelections){a?this.setSelectedKeys():sap.m.ListBase.prototype.removeSelections.call(this,a);}return this;};
F.prototype.getSelectedKeys=function(){var r={};var k=this._oSelectedKeys;Object.getOwnPropertyNames(k).forEach(function(a){r[a]=k[a];});return r;};
F.prototype.setSelectedKeys=function(k){this._oSelectedKeys={};var K=false;k&&Object.getOwnPropertyNames(k).forEach(function(a){this._addSelectedKey(a,k[a]);K=true;},this);if(K){this.setActive(true);this._selectItemsByKeys();}else{sap.m.ListBase.prototype.removeSelections.call(this);}};
F.prototype._getNonGroupItems=function(){var i=[];this.getItems().forEach(function(I){if(I.getMode()!==sap.m.ListMode.None){i.push(I);}});return i;};
F.prototype.removeSelectedKey=function(k,t){if(this._removeSelectedKey(k,t)){this._getNonGroupItems().forEach(function(i){var I=i.getKey()||i.getText();k===I&&i.setSelected(false);});}};
F.prototype.removeSelectedKeys=function(){this._oSelectedKeys={};sap.m.ListBase.prototype.removeSelections.call(this,true);};
F.prototype.removeItem=function(i){var I=sap.m.ListBase.prototype.removeItem.apply(this,arguments);if(!this._filtering){I&&I.getSelected()&&this.removeSelectedKey(I.getKey(),I.getText());return I;}};
F.prototype.init=function(){this._firstTime=true;this._saveBindInfo;this._oSelectedKeys={};L.prototype.init.call(this);this.setMode(sap.m.ListMode.MultiSelect);this.setIncludeItemInSelection(true);this.setGrowing(true);this.setRememberSelections(false);this._searchValue=null;this.attachUpdateFinished(function(e){var u=e.getParameter("reason");u=u?u.toLowerCase():u;if(u!=="growing"&&u!==sap.ui.model.ChangeReason.Filter.toLowerCase()){this._oSelectedKeys={};this._getNonGroupItems().forEach(function(i){if(i.getSelected()){this._addSelectedKey(i.getKey(),i.getText());}},this);}if(u!==sap.ui.model.ChangeReason.Filter.toLowerCase()){this._selectItemsByKeys();}this._updateFacetFilterButtonText();});this._allowRemoveSelections=true;this._bOriginalActiveState;};
F.prototype._resetItemsBinding=function(){if(this.isBound("items")){this._searchValue=null;this._allowRemoveSelections=false;sap.m.ListBase.prototype._resetItemsBinding.apply(this,arguments);this._allowRemoveSelections=true;}};
F.prototype._fireListCloseEvent=function(){var s=this.getSelectedItems();var S=this.getSelectedKeys();var a=s.length===0;this._firstTime=true;this.fireListClose({selectedItems:s,selectedKeys:S,allSelected:a});};
F.prototype._updateActiveState=function(){var c=sap.ui.getCore().byId(this.getAssociation("allcheckbox"));if(Object.getOwnPropertyNames(this._oSelectedKeys).length>0||(c&&c.getSelected())){this.setActive(true);}};
F.prototype._handleSearchEvent=function(e){var s=e.getParameters()["query"];if(s===undefined){s=e.getParameters()["newValue"];}this._search(s);this._updateSelectAllCheckBox();};
F.prototype._search=function(s,f){var b;var n=0;function i(m){return m instanceof sap.ui.model.odata.ODataModel||m instanceof sap.ui.model.odata.v2.ODataModel;}if(f||(s!==this._searchValue)){this._searchValue=s;var B=this.getBinding("items");var o=this.getBindingInfo("items");if(o&&o.binding){b=o.binding.aFilters;if(b.length>0){n=b[0].aFilters.length;if(this._firstTime){this._saveBindInfo=b[0].aFilters[0];this._firstTime=false;}}}if(B){if(s||n>0){var p=this.getBindingInfo("items").template.getBindingInfo("text").parts[0].path;if(p){var u=new sap.ui.model.Filter(p,sap.ui.model.FilterOperator.Contains,s);if(this.getEnableCaseInsensitiveSearch()&&i(B.getModel())){var e="'"+String(s).replace(/'/g,"''")+"'";e=e.toLowerCase();u=new sap.ui.model.Filter("tolower("+p+")",sap.ui.model.FilterOperator.Contains,e);}if(n>1){var a=new sap.ui.model.Filter([u,this._saveBindInfo],true);}else{if(this._saveBindInfo>""&&u.sPath!=this._saveBindInfo.sPath){var a=new sap.ui.model.Filter([u,this._saveBindInfo],true);}else{if(s==""){var a=[];}else{var a=new sap.ui.model.Filter([u],true);}}}B.filter(a,sap.ui.model.FilterType.Control);}}else{B.filter([],sap.ui.model.FilterType.Control);}}else{q.sap.log.warning("No filtering performed","The list must be defined with a binding for search to work",this);}}};
F.prototype._getSearchValue=function(){return this._searchValue;};
F.prototype._updateSelectAllCheckBox=function(){var i=this._getNonGroupItems(),I=i.length,c,a,s;function b(o){return o.getSelected();}if(this.getMultiSelect()){c=sap.ui.getCore().byId(this.getAssociation("allcheckbox"));a=I>0&&I===i.filter(b).length;s=this.getActive()&&a;c&&c.setSelected(s);}};
F.prototype._addSelectedKey=function(k,t){if(!k&&!t){q.sap.log.error("Both sKey and sText are not defined. At least one must be defined.");return;}if(this.getMode()===sap.m.ListMode.SingleSelectMaster){this.removeSelectedKeys();}if(!k){k=t;}this._oSelectedKeys[k]=t||k;};
F.prototype._removeSelectedKey=function(k,t){if(!k&&!t){q.sap.log.error("Both sKey and sText are not defined. At least one must be defined.");return false;}if(!k){k=t;}delete this._oSelectedKeys[k];return true;};
F.prototype._setSearchValue=function(v){this._searchValue=v;};
F.prototype._isItemSelected=function(i){return!!(this._oSelectedKeys[i&&(i.getKey()||i.getText())]);};
F.prototype._updateFacetFilterButtonText=function(){if(this.getParent()&&this.getParent()._setButtonText){this.getParent()._setButtonText(this);}};
F.prototype._selectItemsByKeys=function(){this._getNonGroupItems().forEach(function(i){i.setSelected(this._isItemSelected(i));},this);this._updateFacetFilterButtonText();};
F.prototype._handleSelectAllClick=function(s){var a;this._getNonGroupItems().forEach(function(i){if(s){this._addSelectedKey(i.getKey(),i.getText());}else{this._removeSelectedKey(i.getKey(),i.getText());}i.setSelected(s,true);},this);a=this._getOriginalActiveState()||s;this.setActive(a);q.sap.delayedCall(0,this,this._updateSelectAllCheckBox);};
F.prototype.onItemTextChange=function(i,n){var k=i.getKey();if(this._oSelectedKeys[k]&&n){this._oSelectedKeys[k]=n;}};
F.prototype.onItemSelectedChange=function(i,s){var a;if(s){this._addSelectedKey(i.getKey(),i.getText());}else{this._removeSelectedKey(i.getKey(),i.getText());}sap.m.ListBase.prototype.onItemSelectedChange.apply(this,arguments);a=this._getOriginalActiveState()||s||this.getSelectedItems().length>1;this.setActive(a);!this.getDomRef()&&this.getParent()&&this.getParent().getDomRef()&&this.getParent().invalidate();q.sap.delayedCall(0,this,this._updateSelectAllCheckBox);};
F.prototype.updateItems=function(r){this._filtering=r===sap.ui.model.ChangeReason.Filter;sap.m.ListBase.prototype.updateItems.apply(this,arguments);this._filtering=false;if(!this.getGrowing()||r===sap.ui.model.ChangeReason.Filter){this._selectItemsByKeys();}};
F.prototype._getOriginalActiveState=function(){return this._bOriginalActiveState;};
F.prototype._preserveOriginalActiveState=function(){this._bOriginalActiveState=this.getActive();};
return F;},true);
sap.ui.predefine('sap/m/FacetFilterListRenderer',['jquery.sap.global','./ListRenderer','sap/ui/core/Renderer'],function(q,L,R){"use strict";var F=R.extend(L);return F;},true);
sap.ui.predefine('sap/m/FacetFilterRenderer',['jquery.sap.global'],function(q){"use strict";var F={};var a={};
F.render=function(r,c){switch(c.getType()){case sap.m.FacetFilterType.Simple:F.renderSimpleFlow(r,c);break;case sap.m.FacetFilterType.Light:F.renderSummaryBar(r,c);break;}};
F.renderSimpleFlow=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapMFF");if(c.getShowSummaryBar()){r.write(">");F.renderSummaryBar(r,c);}else{if(c._lastScrolling){r.addClass("sapMFFScrolling");}else{r.addClass("sapMFFNoScrolling");}if(c.getShowReset()){r.addClass("sapMFFResetSpacer");}r.writeClasses();r.write(">");if(sap.ui.Device.system.desktop){r.renderControl(c._getScrollingArrow("left"));}r.write("<div");r.writeAttribute("id",c.getId()+"-head");r.addClass("sapMFFHead");r.writeClasses();r.write(">");F.renderFacetFilterListButtons(c,r);if(c.getShowPersonalization()){r.renderControl(c.getAggregation("addFacetButton"));}r.write("</div>");if(sap.ui.Device.system.desktop){r.renderControl(c._getScrollingArrow("right"));}if(c.getShowReset()){r.write("<div");r.addClass("sapMFFResetDiv");r.writeClasses();r.write(">");r.renderControl(c.getAggregation("resetButton"));r.write("</div>");}}r.write("</div>");};
F.renderSummaryBar=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapMFF");r.writeClasses();r.write(">");r.renderControl(c.getAggregation("summaryBar"));r.write("</div>");};
F.getAriaAnnouncement=function(k,b){if(a[k]){return a[k];}b=b||"FACETFILTER_"+k.toUpperCase();a[k]=new sap.ui.core.InvisibleText({text:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText(b)}).toStatic().getId();return a[k];};
F.getAriaDescribedBy=function(c){var d=[];if(c.getShowPersonalization()){d.push(this.getAriaAnnouncement("ARIA_REMOVE"));}d=d.concat(c._aAriaPositionTextIds);return d.join(" ");};
F.getAccessibilityState=function(c){return{describedby:{value:this.getAriaDescribedBy(c),append:true}};};
F.renderFacetFilterListButtons=function(c,r){var l=c._getSequencedLists(),L=l.length,b,i,p,A,o=[],n=[],f=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("FACETFILTER_ARIA_FACET_FILTER"),R=this.getAriaAnnouncement("ARIA_REMOVE");for(i=0;i<L;i++){b=c._getButtonForList(l[i]);o=b.removeAllAriaDescribedBy();o.forEach(d);p=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("FACETFILTERLIST_ARIA_POSITION",[(i+1),L]);A=new sap.ui.core.InvisibleText({text:f+" "+p}).toStatic();c._aOwnedLabels.push(A.getId());b.addAriaDescribedBy(A);n.push(A.getId());if(c.getShowPersonalization()){b.addAriaDescribedBy(F.getAriaAnnouncement("ARIA_REMOVE"));}r.renderControl(b);if(c.getShowPersonalization()){r.renderControl(c._getFacetRemoveIcon(l[i]));}}c._aAriaPositionTextIds=n;function d(I){if(R!==I){var e=sap.ui.getCore().byId(I);if(e){e.destroy();}}}};
return F;},true);
sap.ui.predefine('sap/m/FeedContent',['jquery.sap.global','./library','sap/ui/core/Control','sap/m/Text'],function(q,l,C,T){"use strict";
var F=C.extend("sap.m.FeedContent",{metadata:{library:"sap.m",properties:{"size":{type:"sap.m.Size",group:"Misc",defaultValue:sap.m.Size.Auto},"contentText":{type:"string",group:"Misc",defaultValue:null},"subheader":{type:"string",group:"Misc",defaultValue:null},"value":{type:"string",group:"Misc",defaultValue:null},"valueColor":{type:"sap.m.ValueColor",group:"Misc",defaultValue:null},"truncateValueTo":{type:"int",group:"Misc",defaultValue:4}},defaultAggregation:"_contentTextAgr",aggregations:{"_contentTextAgr":{type:"sap.m.Text",multiple:false,visibility:"hidden"}},events:{"press":{}}}});
F.prototype.init=function(){this._oContentText=new T(this.getId()+"-content-text",{maxLines:2});this._oContentText.cacheLineHeight=false;this.setAggregation("_contentTextAgr",this._oContentText,true);this.setTooltip("{AltText}");};
F.prototype.onBeforeRendering=function(){this.$().unbind("mouseenter",this._addTooltip);this.$().unbind("mouseleave",this._removeTooltip);};
F.prototype.onAfterRendering=function(){this.$().bind("mouseenter",this._addTooltip.bind(this));this.$().bind("mouseleave",this._removeTooltip.bind(this));};
F.prototype.exit=function(){this._oContentText=null;};
F.prototype._addTooltip=function(){this.$().attr("title",this.getTooltip_AsString());};
F.prototype._removeTooltip=function(){this.$().attr("title",null);};
F.prototype.getAltText=function(){var a="";var i=true;if(this.getAggregation("_contentTextAgr").getText()){a+=this.getAggregation("_contentTextAgr").getText();i=false;}if(this.getSubheader()){if(i){a+=""+this.getSubheader();}else{a+="\n"+this.getSubheader();}i=false;}if(this.getValue()){if(i){a+=""+this.getValue();}else{a+="\n"+this.getValue();}}return a;};
F.prototype.getTooltip_AsString=function(){var t=this.getTooltip();var s=this.getAltText();if(typeof t==="string"||t instanceof String){s=t.split("{AltText}").join(s).split("((AltText))").join(s);return s;}if(t){return t;}else{return"";}};
F.prototype.setContentText=function(t){this._oContentText.setText(t);return this;};
F.prototype.ontap=function(e){if(sap.ui.Device.browser.msie){this.$().focus();}this.firePress();};
F.prototype.onkeydown=function(e){if(e.which===q.sap.KeyCodes.ENTER||e.which===q.sap.KeyCodes.SPACE){this.firePress();e.preventDefault();}};
F.prototype.attachEvent=function(e,d,f,a){sap.ui.core.Control.prototype.attachEvent.call(this,e,d,f,a);if(this.hasListeners("press")){this.$().attr("tabindex",0).addClass("sapMPointer");}return this;};
F.prototype.detachEvent=function(e,f,a){sap.ui.core.Control.prototype.detachEvent.call(this,e,f,a);if(!this.hasListeners("press")){this.$().removeAttr("tabindex").removeClass("sapMPointer");}return this;};
return F;});
sap.ui.predefine('sap/m/FeedContentRenderer',[],function(){"use strict";var F={};
F.render=function(r,c){var s=c.getSubheader();var v=c.getValue();var t=c.getTooltip_AsString();if(typeof t!=="string"){t="";}r.write("<div");r.writeControlData(c);r.writeAttribute("id",c.getId()+"-feed-content");r.writeAttribute("role","presentation");r.writeAttributeEscaped("aria-label",t);r.addClass("sapMFC");if(c.hasListeners("press")){r.writeAttribute("tabindex","0");r.addClass("sapMPointer");}r.writeClasses();r.write(">");if(v){r.write("<div");r.writeAttribute("id",c.getId()+"-value");r.addClass("sapMFCValue");r.addClass(c.getValueColor());r.writeClasses();r.write(">");var C=c.getTruncateValueTo();if(v.length>=C&&(v[C-1]==="."||v[C-1]===",")){r.writeEscaped(v.substring(0,C-1));}else if(v){r.writeEscaped(v.substring(0,C));}else{r.writeEscaped("");}r.write("</div>");}r.write("<div");r.addClass("sapMFCCTxt");r.writeClasses();r.write(">");r.renderControl(c._oContentText);r.write("</div>");r.write("<div");r.writeAttribute("id",c.getId()+"-subheader");r.addClass("sapMFCSbh");r.writeClasses();r.write(">");r.writeEscaped(s);r.write("</div>");r.write("</div>");};
return F;},true);
sap.ui.predefine('sap/m/FeedInput',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/HTML','sap/ui/core/IconPool','sap/m/TextArea','sap/m/Button'],function(q,l,C,H,I,T,B){"use strict";
var F=C.extend("sap.m.FeedInput",{metadata:{library:"sap.m",properties:{enabled:{type:"boolean",group:"Behavior",defaultValue:true},maxLength:{type:"int",group:"Behavior",defaultValue:0},placeholder:{type:"string",group:"Appearance",defaultValue:"Post something here"},value:{type:"string",group:"Data",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},showIcon:{type:"boolean",group:"Behavior",defaultValue:true},iconDensityAware:{type:"boolean",group:"Appearance",defaultValue:true},buttonTooltip:{type:"sap.ui.core.TooltipBase",group:"Accessibility",defaultValue:"Submit"},ariaLabelForPicture:{type:"string",group:"Accessibility",defaultValue:null}},events:{post:{parameters:{value:{type:"string"}}}}}});
F.prototype.init=function(){var b=sap.ui.getCore().getLibraryResourceBundle("sap.m");this.setProperty("placeholder",b.getText("FEEDINPUT_PLACEHOLDER"),true);this.setProperty("buttonTooltip",b.getText("FEEDINPUT_SUBMIT"),true);};
F.prototype.exit=function(){if(this._oTextArea){this._oTextArea.destroy();}if(this._oButton){this._oButton.destroy();}if(this._oImageControl){this._oImageControl.destroy();}};
F.prototype.setIconDensityAware=function(i){this.setProperty("iconDensityAware",i,true);if(this._getImageControl()instanceof sap.m.Image){this._getImageControl().setDensityAware(i);}return this;};
F.prototype.setMaxLength=function(m){this.setProperty("maxLength",m,true);this._getTextArea().setMaxLength(m);return this;};
F.prototype.setValue=function(v){this.setProperty("value",v,true);this._getTextArea().setValue(v);this._enablePostButton();return this;};
F.prototype.setPlaceholder=function(v){this.setProperty("placeholder",v,true);this._getTextArea().setPlaceholder(v);return this;};
F.prototype.setEnabled=function(e){this.setProperty("enabled",e,true);this._getTextArea().setEnabled(e);this._enablePostButton();return this;};
F.prototype.setButtonTooltip=function(b){this.setProperty("buttonTooltip",b,true);this._getPostButton().setTooltip(b);return this;};
F.prototype._getTextArea=function(){if(!this._oTextArea){this._oTextArea=new T(this.getId()+"-textArea",{rows:3,value:null,maxLength:this.getMaxLength(),placeholder:this.getPlaceholder(),height:"100%",liveChange:q.proxy(function(e){var v=e.getParameter("value");this.setProperty("value",v,true);this._enablePostButton();},this)});this._oTextArea.setParent(this);}return this._oTextArea;};
F.prototype._getPostButton=function(){if(!this._oButton){this._oButton=new B(this.getId()+"-button",{enabled:false,type:sap.m.ButtonType.Default,icon:"sap-icon://feeder-arrow",tooltip:this.getButtonTooltip(),press:q.proxy(function(e){this._oTextArea.focus();this.firePost({value:this.getValue()});this.setValue(null);},this)});this._oButton.setParent(this);}return this._oButton;};
F.prototype._enablePostButton=function(){var p=this._isControlEnabled();var b=this._getPostButton();b.setEnabled(p);};
F.prototype._isControlEnabled=function(){var v=this.getValue();return this.getEnabled()&&q.type(v)==="string"&&v.trim().length>0;};
F.prototype._getImageControl=function(){var i=this.getIcon()||I.getIconURI("person-placeholder"),s=this.getId()+'-icon',p={src:i,alt:this.getAriaLabelForPicture(),densityAware:this.getIconDensityAware(),decorative:false,useIconTooltip:false},c=['sapMFeedInImage'];this._oImageControl=l.ImageHelper.getImageControl(s,this._oImageControl,this,p,c);return this._oImageControl;};
return F;},true);
sap.ui.predefine('sap/m/FeedInputRenderer',['jquery.sap.global'],function(q){"use strict";var F={};
F.render=function(r,c){var m=c.getId();r.write("<div");r.writeControlData(c);r.addClass("sapMFeedIn");if(!c.getShowIcon()){r.addClass("sapMFeedInNoIcon");}if(!c.getEnabled()){r.addClass("sapMFeedInDisabled");}r.writeClasses();r.write(">");if(!!c.getShowIcon()){this._addImage(r,c,m);}r.write('<div id="'+m+'-container"');r.addClass("sapMFeedInContainer");r.writeClasses();r.write(">");var t=c._getTextArea();r.renderControl(t);r.renderControl(c._getPostButton());r.write("</div>");r.write("</div>");};
F._addImage=function(r,c,m){r.write('<figure id="'+m+'-figure" class ="sapMFeedInFigure');if(!!c.getIcon()){r.write('">');}else{r.write(' sapMFeedListItemIsDefaultIcon">');}r.renderControl(c._getImageControl());r.write('</figure>');};
return F;},true);
sap.ui.predefine('sap/m/FeedListItem',['jquery.sap.global','./ListItemBase','./library','./FormattedText'],function(q,L,l,F){"use strict";
var a=L.extend("sap.m.FeedListItem",{metadata:{library:"sap.m",properties:{icon:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},activeIcon:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},sender:{type:"string",group:"Data",defaultValue:null},text:{type:"string",group:"Data",defaultValue:null},info:{type:"string",group:"Data",defaultValue:null},timestamp:{type:"string",group:"Data",defaultValue:null},senderActive:{type:"boolean",group:"Behavior",defaultValue:true},iconActive:{type:"boolean",group:"Behavior",defaultValue:true},iconDensityAware:{type:"boolean",defaultValue:true},showIcon:{type:"boolean",group:"Behavior",defaultValue:true},convertLinksToAnchorTags:{type:"sap.m.LinkConversion",group:"Behavior",defaultValue:sap.m.LinkConversion.None},convertedLinksDefaultTarget:{type:"string",group:"Behavior",defaultValue:"_blank"},maxCharacters:{type:"int",group:"Behavior",defaultValue:null}},defaultAggregation:"_text",aggregations:{"_text":{type:"sap.m.FormattedText",multiple:false,visibility:"hidden"}},events:{senderPress:{parameters:{domRef:{type:"string"},getDomRef:{type:"function"}}},iconPress:{parameters:{domRef:{type:"string"},getDomRef:{type:"function"}}}}}});
a._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");a._nMaxCharactersMobile=300;a._nMaxCharactersDesktop=500;a._sTextShowMore=a._oRb.getText("TEXT_SHOW_MORE");a._sTextShowLess=a._oRb.getText("TEXT_SHOW_LESS");
a.prototype.init=function(){L.prototype.init.apply(this);this.setAggregation("_text",new F(this.getId()+"-formattedText"),true);};
a.prototype.onBeforeRendering=function(){this.$("realtext").find('a[target="_blank"]').off("click");var f=this.getAggregation("_text");f.setProperty("convertLinksToAnchorTags",this.getConvertLinksToAnchorTags(),true);f.setProperty("convertedLinksDefaultTarget",this.getConvertedLinksDefaultTarget(),true);if(this.getConvertLinksToAnchorTags()===l.LinkConversion.None){f.setHtmlText(this.getText());}else{f.setProperty("htmlText",this.getText(),true);}this._sFullText=f._getDisplayHtml().replace(/\n/g,"<br>");this._sShortText=this._getCollapsedText();this._bEmptyTagsInShortTextCleared=false;};
a.prototype.onAfterRendering=function(){if(this._checkTextIsExpandable()&&!this._bTextExpanded){this._clearEmptyTagsInCollapsedText();}var r=this.$("realtext");F.prototype.onAfterRendering.apply({$:function(){return r;}});};
a.prototype.exit=function(){this.$("realtext").find('a[target="_blank"]').off("click");if(this._oLinkControl){this._oLinkControl.destroy();}if(this._oImageControl){this._oImageControl.destroy();}if(this._oLinkExpandCollapse){this._oLinkExpandCollapse.destroy();}L.prototype.exit.apply(this);};
a.prototype.ontap=function(e){if(e.srcControl){if((!this.getIconActive()&&this._oImageControl&&e.srcControl.getId()===this._oImageControl.getId())||(!this.getSenderActive()&&this._oLinkControl&&e.srcControl.getId()===this._oLinkControl.getId())||(!this._oImageControl||(e.srcControl.getId()!==this._oImageControl.getId())&&(!this._oLinkControl||(e.srcControl.getId()!==this._oLinkControl.getId()))&&(!this._oLinkExpandCollapse||(e.srcControl.getId()!==this._oLinkExpandCollapse.getId())))){L.prototype.ontap.apply(this,[e]);}}};
a.prototype.onfocusin=function(e){if(this._oImageControl){var $=this.$("icon");if(e.target.id===this.getId()){$.removeAttr("alt");}else{$.attr("alt"," ");}}};
a.prototype._getImageControl=function(){var i=this.getIcon();var I=i?i:sap.ui.core.IconPool.getIconURI("person-placeholder");var s=this.getId()+'-icon';var p={src:I,alt:encodeURI(this.getSender()),densityAware:this.getIconDensityAware(),decorative:false,useIconTooltip:false};var c;if(this.getIconActive()){c=['sapMFeedListItemImage'];}else{c=['sapMFeedListItemImageInactive'];}var t=this;this._oImageControl=sap.m.ImageHelper.getImageControl(s,this._oImageControl,this,p,c);if(this.getIconActive()){this._oImageControl.attachPress(function(){t.fireIconPress({domRef:this.getDomRef(),getDomRef:this.getDomRef.bind(this)});});}return this._oImageControl;};
a.prototype._getLinkSender=function(w){if(!this._oLinkControl){q.sap.require("sap.m.Link");var t=this;this._oLinkControl=new sap.m.Link({press:function(){t.fireSenderPress({domRef:this.getDomRef(),getDomRef:this.getDomRef.bind(this)});}});this._oLinkControl.setParent(this,null,true);}if(w){this._oLinkControl.setProperty("text",this.getSender()+a._oRb.getText("COLON"),true);}else{this._oLinkControl.setProperty("text",this.getSender(),true);}this._oLinkControl.setProperty("enabled",this.getSenderActive(),true);return this._oLinkControl;};
a.prototype._activeHandlingInheritor=function(){var A=this.getActiveIcon();if(this._oImageControl&&A){this._oImageControl.setSrc(A);}};
a.prototype._inactiveHandlingInheritor=function(){var s=this.getIcon()?this.getIcon():sap.ui.core.IconPool.getIconURI("person-placeholder");if(this._oImageControl){this._oImageControl.setSrc(s);}};
a.prototype._getCollapsedText=function(){this._nMaxCollapsedLength=this.getMaxCharacters();if(this._nMaxCollapsedLength===0){if(sap.ui.Device.system.phone){this._nMaxCollapsedLength=a._nMaxCharactersMobile;}else{this._nMaxCollapsedLength=a._nMaxCharactersDesktop;}}var p=this._convertHtmlToPlainText(this._sFullText);var t=null;if(p&&p.length>this._nMaxCollapsedLength){var c=p.substring(0,this._nMaxCollapsedLength);var n=c.lastIndexOf(" ");if(n>0){c=c.substr(0,n);}if(p.length===this._sFullText.length){t=c;}else{t=this._convertPlainToHtmlText(c);}}return t;};
a.prototype._clearEmptyTagsInCollapsedText=function(){var r;if(this._bEmptyTagsInShortTextCleared){return;}this._bEmptyTagsInShortTextCleared=true;do{r=this.$("realtext").find(":empty").remove();}while(r.length>0);this._sShortText=this.$("realtext").html();};
a.prototype._toggleTextExpanded=function(){var $=this.$("realtext");var b=this.$("threeDots");if(this._bTextExpanded){$.html(this._sShortText.replace(/&#xa;/g,"<br>"));b.text(" ... ");this._oLinkExpandCollapse.setText(a._sTextShowMore);this._bTextExpanded=false;this._clearEmptyTagsInCollapsedText();}else{$.html(this._sFullText.replace(/&#xa;/g,"<br>"));b.text("  ");this._oLinkExpandCollapse.setText(a._sTextShowLess);this._bTextExpanded=true;}};
a.prototype._getLinkExpandCollapse=function(){if(!this._oLinkExpandCollapse){q.sap.require("sap.m.Link");this._oLinkExpandCollapse=new sap.m.Link({text:a._sTextShowMore,press:q.proxy(function(){this._toggleTextExpanded();},this)});this._bTextExpanded=false;this._oLinkExpandCollapse.setParent(this,null,true);}return this._oLinkExpandCollapse;};
a.prototype._convertHtmlToPlainText=function(h){var r=/(<([^>]+)>)/ig;return h.replace(r,"");};
a.prototype._convertPlainToHtmlText=function(b){var f=this._sFullText;var r=/(<([^>]+)>)/ig;var e=f.split(r);var t="";for(var i=0;i<e.length;i++){if(e[i].length===0){continue;}if(b.length>0&&e[i].indexOf(b.trim())!==-1){e[i]=b;}if(/^<.+>$/.test(e[i])){t=t+e[i];e[i+1]="";continue;}if(b.indexOf(e[i].trim())===-1){continue;}else{b=b.replace(e[i],"");}t=t+e[i];}return t;};
a.prototype._checkTextIsExpandable=function(){return this._sShortText!==null;};
a.prototype.setType=function(t){if(t===sap.m.ListType.Navigation){this.setProperty("type",sap.m.ListType.Active);}else{this.setProperty("type",t);}return this;};
a.prototype.setUnread=function(v){this.setProperty("unread",false);return this;};
return a;},true);
sap.ui.predefine('sap/m/FeedListItemRenderer',['jquery.sap.global','./ListItemBaseRenderer','sap/ui/core/Renderer'],function(q,L,R){"use strict";var F=R.extend(L);
F.renderLIAttributes=function(r,f){r.addClass("sapMFeedListItemTitleDiv");r.addClass("sapMFeedListShowSeparatorsAll");};
F.renderLIContent=function(r,f){var m=f.getId(),i=sap.ui.Device.system.phone;r.write('<div');r.addClass('sapMFeedListItem');r.writeClasses();r.write('>');if(!!f.getShowIcon()){this._writeImageControl(r,f,m);}if(i){r.write('<div class= "sapMFeedListItemHeader sapUiSelectable ');if(!!f.getShowIcon()){r.write('sapMFeedListItemHasFigure ');}if(!!f.getSender()&&!!f.getTimestamp()){r.write('sapMFeedListItemFullHeight');}r.write('" >');if(!!f.getSender()){r.write('<p id="'+m+'-name" class="sapMFeedListItemTextName sapUiSelectable">');r.renderControl(f._getLinkSender(false));r.write('</p>');}if(!!f.getTimestamp()){r.write('<p id="'+m+'-timestamp" class="sapMFeedListItemTimestamp sapUiSelectable">');r.writeEscaped(f.getTimestamp());r.write('</p>');}r.write('</div>');r.write('<div class="sapMFeedListItemText sapUiSelectable">');r.write('<span id="'+m+'-realtext" class="sapMFeedListItemText sapUiSelectable">');if(!!f._checkTextIsExpandable()){this._writeCollapsedText(r,f,m);}else{r.write(f._sFullText);r.write('</span>');}r.write('</div>');if(!!f.getInfo()){r.write('<p class="sapMFeedListItemFooter sapUiSelectable">');if(!!f.getInfo()){r.write('<span id="'+m+'-info" class="sapMFeedListItemInfo sapUiSelectable">');r.writeEscaped(f.getInfo());r.write('</span>');}r.write('</p>');}}else{r.write('<div class= "sapMFeedListItemText ');if(!!f.getShowIcon()){r.write('sapMFeedListItemHasFigure');}r.write('" >');r.write('<div id="'+m+'-text" class="sapMFeedListItemTextText sapUiSelectable">');if(!!f.getSender()){r.write('<span id="'+m+'-name" class="sapMFeedListItemTextName sapUiSelectable">');r.renderControl(f._getLinkSender(true));r.write(' ');r.write('</span>');}r.write('<span id="'+m+'-realtext" class="sapMFeedListItemTextString sapUiSelectable">');if(!!f._checkTextIsExpandable()){this._writeCollapsedText(r,f,m);}else{r.write(f._sFullText);r.write('</span>');}r.write('</div>');if(!!f.getInfo()||!!f.getTimestamp()){r.write('<p class="sapMFeedListItemFooter sapUiSelectable">');if(!sap.ui.getCore().getConfiguration().getRTL()){if(!!f.getInfo()){this._writeInfo(r,f,m);if(!!f.getTimestamp()){r.write("<span>&#160&#160&#x00B7&#160&#160</span>");}}if(!!f.getTimestamp()){this._writeTimestamp(r,f,m);}}else{if(!!f.getTimestamp()){this._writeTimestamp(r,f,m);}if(!!f.getInfo()){if(!!f.getTimestamp()){r.write("<span>&#160&#160&#x00B7&#160&#160</span>");}this._writeInfo(r,f,m);}}r.write('</p>');}r.write('</div>');}r.write('</div>');};
F._writeImageControl=function(r,f,m){r.write('<figure id="'+m+'-figure"');r.addClass('sapMFeedListItemFigure');if(!f.getIcon()){r.addClass('sapMFeedListItemIsDefaultIcon');}r.writeClasses();r.write('>');r.renderControl(f._getImageControl());r.write('</figure>');};
F._writeCollapsedText=function(r,f,m){if(f._bTextExpanded){r.write(f._sFullText);r.write('</span>');r.write('<span id="'+m+'-threeDots" class ="sapMFeedListItemTextString">');r.write("&#32");r.write('</span>');}else{r.write(f._sShortText);r.write('</span>');r.write('<span id="'+m+'-threeDots" class ="sapMFeedListItemTextString">');r.write("&#32&#46&#46&#46&#32");r.write('</span>');}var l=f._getLinkExpandCollapse();l.addStyleClass("sapMFeedListItemLinkExpandCollapse");r.renderControl(l);};
F._writeTimestamp=function(r,f,m){r.write('<span id="'+m+'-timestamp" class="sapMFeedListItemTimestampText sapUiSelectable">');r.writeEscaped(f.getTimestamp());r.write('</span>');};
F._writeInfo=function(r,f,m){r.write('<span id="'+m+'-info" class="sapMFeedListItemInfoText sapUiSelectable">');r.writeEscaped(f.getInfo());r.write('</span>');};
return F;},true);
sap.ui.predefine('sap/m/Fiori20Adapter',['jquery.sap.global','sap/ui/base/Object','sap/ui/base/EventProvider','sap/ui/base/ManagedObjectObserver','sap/ui/Device'],function(q,O,E,M,D){"use strict";var e=new E(),i,c;
var H=O.extend("HeaderAdapter",{constructor:function(o,A){if(!o||!A){q.sap.log.error("Cannot initialize: Invalid arguments.");return;}this._oHeader=o;this._oStyledPage=null;this._oTitleInfo=null;this._oSubTitleInfo=null;this._oBackButtonInfo=null;this._oAdaptOptions=A;}});
H.prototype.adapt=function(){var s=this._oAdaptOptions.bStylePage,C=this._oAdaptOptions.bCollapseHeader;if(s){this._toggleStyle("sapF2Adapted",true,true);}this._adaptTitle();this._adaptBackButton();if(C){this._collapseHeader();}return this.getAdaptedContent();};
H.prototype.getAdaptedContent=function(){return{oTitleInfo:this._oTitleInfo,oSubTitleInfo:this._oSubTitleInfo,oBackButtonInfo:this._oBackButtonInfo,oStyledPage:this._oStyledPage};};
H.prototype._adaptTitle=function(){if(!H._isAdaptableHeader(this._oHeader)||this._oAdaptOptions.bMoveTitle!==true){return false;}this._oTitleInfo=this._detectTitle();this._oSubTitleInfo=this._detectSubTitle();var s=!!this._oTitleInfo||!!this._oSubTitleInfo;if(this._oTitleInfo){this._oTitleInfo.oControl.toggleStyleClass("sapF2AdaptedTitle",true);}return s;};
H.prototype._adaptBackButton=function(){if(!H._isAdaptableHeader(this._oHeader)||this._oAdaptOptions.bHideBackButton!==true){return false;}var j,B=false;this._oBackButtonInfo=this._detectBackButton();if(this._oBackButtonInfo){j=this._oBackButtonInfo.oControl.getVisible();this._oBackButtonInfo.oControl.toggleStyleClass("sapF2AdaptedNavigation",j);B=true;}return B;};
H.prototype._toggleStyle=function(s,A,S){var p=this._oHeader.getParent();if(!p){return;}this._oStyledPage=p;if(A===true){p.addStyleClass(s,S);}else if(A===false){p.removeStyleClass(s,S);}else if(A===undefined){p.hasStyleClass(s)?p.removeStyleClass(s,S):p.addStyleClass(s,S);}};
H._isAdaptableHeader=function(o){if(!o||!f(o,"sap/m/Bar")){return false;}var p=o.getParent();return p&&(f(p,"sap/m/Page")||f(p,"sap/uxap/ObjectPageHeader"));};
H.prototype._detectTitle=function(){var t;if(H._isAdaptableHeader(this._oHeader)){var m=this._oHeader.getContentMiddle();if(m.length===1&&a(m[0])){var T=m[0];t={id:T.getId(),text:T.getText(),oControl:T,sChangeEventId:"_change"};}}return t;};
H.prototype._detectSubTitle=function(p){if(f(p,"sap/uxap/ObjectPageHeader")){var o=p.getHeaderTitle();if(o){return{id:o.getId(),text:o.getObjectTitle(),oControl:o,sChangeEventId:"_titleChange"};}}};
H.prototype._detectBackButton=function(){var B,o;if(H._isAdaptableHeader(this._oHeader)){B=this._oHeader.getContentLeft();if(B.length>0&&f(B[0],"sap/m/Button")&&(B[0].getType()==="Back"||B[0].getType()==="Up"||B[0].getIcon()==="sap-icon://nav-back")){o=B[0];return{id:o.getId(),oControl:o,sChangeEventId:"_change"};}}};
H.prototype._collapseHeader=function(){var t=this._oTitleInfo,B=this._oBackButtonInfo,j,m,k,l,n,o,A;if(H._isAdaptableHeader(this._oHeader)){j=this._oHeader.getContentLeft();m=this._oHeader.getContentMiddle();k=this._oHeader.getContentRight();l=(j.length===1)&&(h(j[0])||B);n=(m.length===1)&&(h(m[0])||t);o=(k.length===1)&&h(k[0]);A=(j.length===0||l)&&(m.length===0||n)&&((k.length===0)||o);this._toggleStyle("sapF2CollapsedHeader",A,true);}};
var F=O.extend("sap.m.Fiori20Adapter",{});
F.attachViewChange=function(l,L){e.attachEvent("adaptedViewChange",l,L);};
F.detachViewChange=function(l,L){e.detachEvent("adaptedViewChange",l,L);};
F.traverse=function(C,A){i={aViewTitles:{},aViewSubTitles:{},aViewBackButtons:{},aChangeListeners:{}};c=null;this._doBFS([{oNode:C,oAdaptOptions:A}]);if(this._getCurrentTopViewId()){this._fireViewChange(this._getCurrentTopViewId(),A);}};
F._doBFS=function(Q){var n=Q.shift();if(!n){return;}var N=n.oNode,A=n.oAdaptOptions,s=A.iSearchDepth;A=this._applyRules(A,N);if(!this._isAdaptationRequired(N,A)||(s<=0)){return;}var I=this._isTopNavigableView(N);if(I){this._setAsCurrentTopViewId(N.getId());}var o=this._processNode(N,A);var C=this._getNodeChildren(N),j=q.extend({},A,{iSearchDepth:this._updateSearchDepth(s,N)});if(o){var t=!!o.oTitleInfo,B=!!o.oBackButton,p=!!o.oStyledPage;j=q.extend(j,{bMoveTitle:A.bMoveTitle&&!t,bHideBackButton:A.bHideBackButton&&!B,bStylePage:A.bStylePage&&!p});}C.forEach(function(k){if(k){Q.push({oNode:k,oAdaptOptions:j});}});this._doBFS(Q);};
F._processNode=function(C,A){this._attachDefferedAdaptationListeners(C,A);if(H._isAdaptableHeader(C)){return this._adaptHeader(C,A);}if(C.getParent()&&f(C.getParent(),"sap/m/NavContainer")){return this._getCachedViewInfoToMerge(C.getId());}};
F._attachDefferedAdaptationListeners=function(C,A){this._attachAdaptableContentChange(C,A);this._attachNavigablePageChange(C,A);if(f(C,"sap/m/Page")){this._attachModifyAggregation(C,"content",A);}if((A.bLateAdaptation===true)&&f(C,"sap/m/Bar")){this._attachModifyAggregation(C,"contentLeft",A,C);this._attachModifyAggregation(C,"contentMiddle",A,C);this._attachModifyAggregation(C,"contentRight",A,C);}if(f(C,"sap/ui/core/ComponentContainer")){var o=C.getComponentInstance();if(!o&&C.getName()&&!C.getDomRef()){var t=this;var j={onBeforeRendering:function(){C.removeEventDelegate(j);t._doBFS([{oNode:C.getComponentInstance(),oAdaptOptions:A}]);if(t._getCurrentTopViewId()){t._fireViewChange(t._getCurrentTopViewId(),A);}}};C.addEventDelegate(j,this);}}};
F._checkHasListener=function(k){return i.aChangeListeners[k];};
F._setHasListener=function(k,v){i.aChangeListeners[k]=v;};
F._attachAdaptableContentChange=function(C,A){if(!C._getAdaptableContent||!q.isFunction(C._getAdaptableContent)){return;}var k=C.getId()+"_adaptableContentChange";if(this._checkHasListener(k)){return;}var o=this._getCurrentTopViewId();var j=function(l){var m=l.getParameter("adaptableContent");this._setAsCurrentTopViewId(o);this._doBFS([{oNode:m,oAdaptOptions:A}]);if(this._getCurrentTopViewId()){this._fireViewChange(this._getCurrentTopViewId(),A);}}.bind(this);C.attachEvent("_adaptableContentChange",j);this._setHasListener(k,j);};
F._attachNavigablePageChange=function(C,A){if(!f(C,"sap/m/NavContainer")){return;}var k=C.getId()+"navigate";if(this._checkHasListener(k)){return;}var o=function(j){var n=j.getParameter("to");A=this._applyRules(A,n);this._doBFS([{oNode:n,oAdaptOptions:A}]);if(this._getCurrentTopViewId()){this._fireViewChange(this._getCurrentTopViewId(),A);}}.bind(this);C.attachNavigate(o);this._setHasListener(k,o);};
F._attachModifyAggregation=function(C,A,o,j){var k=C.getId()+A;if(this._checkHasListener(k)){return;}var l=this._getCurrentTopViewId(),m=function(p){var s=p.mutation,r=p.object;if((s==="add")||(s==="insert")){this._setAsCurrentTopViewId(l);this._doBFS([{oNode:j?j:r,oAdaptOptions:o}]);if(this._getCurrentTopViewId()){this._fireViewChange(l,o);}}}.bind(this),n=new M(m);n.observe(C,{aggregations:[A]});this._setHasListener(k,n);};
F._getNodeChildren=function(C){if(C._getAdaptableContent&&q.isFunction(C._getAdaptableContent)){var j=[C._getAdaptableContent()];if(f(C,"sap/m/Page")){j=j.concat(C.getContent());}return j;}if(f(C,"sap/m/SplitContainer")){return[].concat(C.getAggregation("_navMaster"),C.getAggregation("_navDetail"));}if(f(C,"sap/uxap/ObjectPageLayout")){return[C.getHeaderTitle()];}if(f(C,"sap/ui/core/ComponentContainer")){return[C.getComponentInstance()];}if(f(C,"sap/ui/core/UIComponent")){return[C.getAggregation("rootControl")];}return C.findAggregatedObjects(false,g);};
F._updateSearchDepth=function(s,C){if(f(C,"sap/ui/core/mvc/View")||f(C,"sap/ui/core/Component")||f(C,"sap/ui/core/ComponentContainer")){return s;}return s-1;};
F._getTotalCachedInfoToMerge=function(v){var V=sap.ui.getCore().byId(v),C=this._getCachedViewInfoToMerge(v),j,k,s,S,o,p,l;if(!D.system.phone&&this._isTopSplitContainerSubView(V)){p=V.getParent();o=p&&p.getParent();if(o){j=o._oMasterNav&&(o._oMasterNav.getId()===p.getId());k=o._oDetailNav&&(o._oDetailNav.getId()===p.getId());}}if(j){s=o.getCurrentDetailPage();S=s&&s.getId();l=this._getCachedViewInfoToMerge(S);C=this._mergeSplitViewInfos(C,l);}if(k){s=o.getCurrentMasterPage();S=s&&s.getId();l=this._getCachedViewInfoToMerge(S);C=this._mergeSplitViewInfos(l,C);}C.sViewId=(j||k)?o.getId():v;return C;};
F._isTopSplitContainerSubView=function(C){var p=C&&C.getParent();return this._isTopmostNavContainer(p)&&f(p.getParent(),"sap/m/SplitContainer");};
F._mergeSplitViewInfos=function(m,o){q.each(m,function(k,v){m[k]=v||o[k];});return m;};
F._getCachedViewInfoToMerge=function(v){var B=(i.aViewBackButtons[v])?i.aViewBackButtons[v].oControl:undefined;return{oTitleInfo:i.aViewTitles[v],oSubTitleInfo:i.aViewSubTitles[v],oBackButton:B};};
F._applyRules=function(A,C){var p=C.getParent();if(f(p,"sap/m/SplitContainer")){var I=sap.ui.Device.system.phone,m=A.bMoveTitle,j=A.bHideBackButton;if(m){m=I;}if(j&&!sap.ui.Device.system.phone){j='initialPage';}return q.extend({},A,{bMoveTitle:m,bHideBackButton:j});}if(f(p,"sap/m/NavContainer")){if(A.bHideBackButton==='initialPage'){var k=p._getActualInitialPage()&&(p._getActualInitialPage().getId()===C.getId());return q.extend({},A,{bHideBackButton:k});}}if((A.bMoveTitle===false)||(A.bHideBackButton===false)){return q.extend({},A,{bCollapseHeader:false});}return A;};
F._getCurrentTopViewId=function(){return c;};
F._setAsCurrentTopViewId=function(v){c=v;};
F._isTopNavigableView=function(n){var p=n.getParent();return p&&this._isTopmostNavContainer(p);};
F._isTopmostNavContainer=function(C){var o,n=C;while(n){if(f(n,"sap/m/NavContainer")){o=n;}n=n.getParent();}return o&&(o.getId()===C.getId());};
F._adaptHeader=function(o,A){if(!o||!A){return;}var j=new H(o,A),k=j.adapt();var t=this._getCurrentTopViewId();if(k.oTitleInfo){i.aViewTitles[t]=k.oTitleInfo;this._registerTextChangeListener(i.aViewTitles,t,A);}if(k.oSubTitleInfo){i.aViewSubTitles[t]=k.oSubTitleInfo;this._registerTextChangeListener(i.aViewSubTitles,t,A);}if(k.oBackButtonInfo){if(k.oBackButtonInfo.oControl.getVisible()){i.aViewBackButtons[t]=k.oBackButtonInfo;}this._registerVisibilityChangeListener(k.oBackButtonInfo,i.aViewBackButtons,t,A);}return k;};
F._registerTextChangeListener=function(t,v,A){var T=t[v];if(T&&T.oControl&&T.sChangeEventId&&!i.aChangeListeners[T.id]){var C=function(o){var T=t[v];T.text=o.getParameter("newValue");this._fireViewChange(v,A);}.bind(this);T.oControl.attachEvent(T.sChangeEventId,C);i.aChangeListeners[T.id]=C;}};
F._registerVisibilityChangeListener=function(C,j,v,A){var V;if(C&&C.oControl&&C.sChangeEventId&&!i.aChangeListeners[C.id]){var k=function(o){V=o.getParameter("newValue");if(!V){q.each(j,function(I,l){if(l.oControl.getId()===C.oControl.getId()){delete j[I];}});}var p=C.oControl.getParent();if(H._isAdaptableHeader(p)){F._adaptHeader(p,A);this._fireViewChange(v,A);}}.bind(this);C.oControl.attachEvent(C.sChangeEventId,k);i.aChangeListeners[C.id]=k;}};
F._fireViewChange=function(v,A){var t=this._getTotalCachedInfoToMerge(v);t.oAdaptOptions=A;e.fireEvent("adaptedViewChange",t);};
F._isAdaptationRequired=function(n,A){if(!n||this._isNonAdaptableControl(n)){return false;}for(var o in A){if(A.hasOwnProperty(o)&&((A[o]===true)||(A[o]==="initialPage"))){return true;}}return false;};
F._isNonAdaptableControl=function(C){return b(C);};
function a(C){return d(C,["sap/m/Label","sap/m/Text","sap/m/Title"]);}
function b(C){return d(C,["sap/m/List","sap/m/Table","sap/ui/table/Table","sap/ui/table/TreeTable"]);}
function d(C,t){if(!C||!t){return;}return t.some(function(T){return f(C,T);});}
function f(C,t){var T=sap.ui.require(t);return T&&(C instanceof T);}
function g(o){return o&&(o.sParentAggregationName!=="dependents");}
function h(o){return o&&(typeof o.getVisible==="function")&&(o.getVisible()===false);}
return F;},false);
sap.ui.predefine('sap/m/FlexBox.designtime',[],function(){"use strict";return{actions:{remove:{changeType:"hideControl"},reveal:{changeType:"unhideControl"}},aggregations:{items:{domRef:":sap-domref",actions:{move:"moveControls"}}},name:{singular:"FLEXBOX_CONTROL_NAME",plural:"FLEXBOX_CONTROL_NAME_PLURAL"}};},false);
sap.ui.predefine('sap/m/FlexBox',['jquery.sap.global','./FlexBoxStylingHelper','./FlexItemData','./library','sap/ui/core/Control'],function(q,F,a,l,C){"use strict";var b=l.FlexRendertype;var c=l.FlexDirection;
var d=C.extend("sap.m.FlexBox",{metadata:{library:"sap.m",properties:{height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:''},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:''},displayInline:{type:"boolean",group:"Appearance",defaultValue:false},direction:{type:"sap.m.FlexDirection",group:"Appearance",defaultValue:sap.m.FlexDirection.Row},fitContainer:{type:"boolean",group:"Appearance",defaultValue:false},renderType:{type:"sap.m.FlexRendertype",group:"Misc",defaultValue:sap.m.FlexRendertype.Div},justifyContent:{type:"sap.m.FlexJustifyContent",group:"Appearance",defaultValue:sap.m.FlexJustifyContent.Start},alignItems:{type:"sap.m.FlexAlignItems",group:"Appearance",defaultValue:sap.m.FlexAlignItems.Stretch},wrap:{type:"sap.m.FlexWrap",group:"Appearance",defaultValue:sap.m.FlexWrap.NoWrap},alignContent:{type:"sap.m.FlexAlignContent",group:"Appearance",defaultValue:sap.m.FlexAlignContent.Stretch},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:sap.m.BackgroundDesign.Transparent}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.core.Control",multiple:true,singularName:"item"}},designTime:true}});
d.prototype.init=function(){if(this instanceof sap.m.HBox&&(this.getDirection()!==sap.m.FlexDirection.Row||this.getDirection()!==c.RowReverse)){this.setDirection('Row');}if(this instanceof sap.m.VBox&&(this.getDirection()!==sap.m.FlexDirection.Column||this.getDirection()!==c.ColumnReverse)){this.setDirection('Column');}this._oItemDelegate={onAfterRendering:this._onAfterItemRendering};};
d.prototype.addItem=function(i){this.addAggregation("items",i);this._onItemInserted(i);return this;};
d.prototype.insertItem=function(i,I){this.insertAggregation("items",i,I);this._onItemInserted(i);return this;};
d.prototype.removeItem=function(i){var I=this.removeAggregation("items",i);this._onItemRemoved(I);return I;};
d.prototype.removeAllItems=function(){var I=this.getItems();for(var i=0;i<I.length;i++){this._onItemRemoved(I[i]);}return this.removeAllAggregation("items");};
d.prototype._onItemInserted=function(i){if(i&&!(i instanceof sap.m.FlexBox)){i.attachEvent("_change",this._onItemChange,this);if(this.getRenderType()===b.Bare){i.addEventDelegate(this._oItemDelegate,i);}}};
d.prototype._onItemRemoved=function(i){if(i&&!(i instanceof sap.m.FlexBox)){i.detachEvent("_change",this._onItemChange,this);if(this.getRenderType()===b.Bare){i.removeEventDelegate(this._oItemDelegate,i);}}};
d.prototype._onItemChange=function(o){if(o.getParameter("name")!=="visible"||(this.getRenderType()!==b.List&&this.getRenderType()!==b.Div)){return;}var i=sap.ui.getCore().byId(o.getParameter("id")),w=null;if(i.getLayoutData()){w=q.sap.byId(i.getLayoutData().getId());}else{w=q.sap.byId(sap.ui.core.RenderManager.createInvisiblePlaceholderId(i)).parent();}if(o.getParameter("newValue")){w.removeClass("sapUiHiddenPlaceholder").removeAttr("aria-hidden");}else{w.addClass("sapUiHiddenPlaceholder").attr("aria-hidden","true");}};
d.prototype._onAfterItemRendering=function(){var L=this.getLayoutData();if(L instanceof a){F.setFlexItemStyles(null,L);}};
d.prototype.setRenderType=function(v){var o=this.getRenderType(),i=this.getItems();if(v===o){return this;}this.setProperty("renderType",v);if(o==="Bare"){i.forEach(this._onItemRemoved,this);}if(v==="Bare"){i.forEach(this._onItemInserted,this);}return this;};
d.prototype.setDisplayInline=function(i){this.setProperty("displayInline",i,true);this.$().toggleClass("sapMFlexBoxInline",this.getDisplayInline());return this;};
d.prototype.setDirection=function(v){this.setProperty("direction",v,true);if(this.getDirection()===c.Column||this.getDirection()===c.ColumnReverse){this.$().removeClass("sapMHBox").addClass("sapMVBox");}else{this.$().removeClass("sapMVBox").addClass("sapMHBox");}if(this.getDirection()===c.RowReverse||this.getDirection()===c.ColumnReverse){this.$().addClass("sapMFlexBoxReverse");}else{this.$().removeClass("sapMFlexBoxReverse");}return this;};
d.prototype.setFitContainer=function(v){this.setProperty("fitContainer",v,true);this.$().toggleClass("sapMFlexBoxFit",this.getFitContainer());return this;};
d.prototype.setWrap=function(v){var o=this.getWrap();this.setProperty("wrap",v,true);this.$().removeClass("sapMFlexBoxWrap"+o).addClass("sapMFlexBoxWrap"+this.getWrap());return this;};
d.prototype.setJustifyContent=function(v){var o=this.getJustifyContent();this.setProperty("justifyContent",v,true);this.$().removeClass("sapMFlexBoxJustify"+o).addClass("sapMFlexBoxJustify"+this.getJustifyContent());return this;};
d.prototype.setAlignItems=function(v){var o=this.getAlignItems();this.setProperty("alignItems",v,true);this.$().removeClass("sapMFlexBoxAlignItems"+o).addClass("sapMFlexBoxAlignItems"+this.getAlignItems());return this;};
d.prototype.setAlignContent=function(v){var o=this.getAlignContent();this.setProperty("alignContent",v,true);this.$().removeClass("sapMFlexBoxAlignContent"+o).addClass("sapMFlexBoxAlignContent"+this.getAlignContent());return this;};
d.prototype.setHeight=function(v){this.setProperty("height",v,true);this.$().css("height",this.getHeight());return this;};
d.prototype.setWidth=function(v){this.setProperty("width",v,true);this.$().css("width",this.getWidth());return this;};
d.prototype.setBackgroundDesign=function(v){var o=this.getBackgroundDesign();this.setProperty("backgroundDesign",v,true);this.$().removeClass("sapMFlexBoxBG"+o).addClass("sapMFlexBoxBG"+this.getBackgroundDesign());return this;};
d.prototype.getAccessibilityInfo=function(){return{children:this.getItems()};};
return d;},true);
sap.ui.predefine('sap/m/FlexBoxCssPropertyMap',['jquery.sap.global'],function(q){"use strict";var F={'spec0907':{'order':{'<number>':{'box-ordinal-group':'<integer>'}},'flex-grow':{'<number>':{'box-flex':'<number>'}},'flex-shrink':null,'flex-basis':null},'specie10':{'order':{'<number>':{'flex-order':'<number>'}},'flex-grow':{'<number>':{'flex-positive':'<number>','flex-preferred-size':'auto'}},'flex-shrink':{'<number>':{'flex-negative':'<number>'}},'flex-basis':{'<number>':{'flex-preferred-size':'<number>'}}}};return F;},true);
sap.ui.predefine('sap/m/FlexBoxRenderer',['jquery.sap.global','./FlexBoxStylingHelper'],function(q,F){"use strict";if(!q.support.flexBoxLayout&&!q.support.newFlexBoxLayout&&!q.support.ie10FlexBoxLayout){q.sap.log.warning("This browser does not support flexible box layouts natively.");}var a={};
a.render=function(r,c){if(c.getRenderType()===sap.m.FlexRendertype.List){r.write('<ul');}else{r.write('<div');}r.writeControlData(c);var p=c.getParent();if(c.getParent()instanceof sap.m.FlexBox){r.addClass("sapMFlexItem");var l=c.getLayoutData();if(l instanceof sap.m.FlexItemData){F.setFlexItemStyles(r,l);}if(p.getRenderType()===sap.m.FlexRendertype.List){r.write('<li');}}else if(c.getFitContainer()){r.addClass("sapMFlexBoxFit");}r.addClass("sapMFlexBox");if(c.getDisplayInline()){r.addClass("sapMFlexBoxInline");}if(c.getDirection()===sap.m.FlexDirection.Column||c.getDirection()===sap.m.FlexDirection.ColumnReverse){r.addClass("sapMVBox");}else{r.addClass("sapMHBox");}if(c.getDirection()===sap.m.FlexDirection.RowReverse||c.getDirection()===sap.m.FlexDirection.ColumnReverse){r.addClass("sapMFlexBoxReverse");}r.addClass("sapMFlexBoxJustify"+c.getJustifyContent());r.addClass("sapMFlexBoxAlignItems"+c.getAlignItems());r.addClass("sapMFlexBoxWrap"+c.getWrap());r.addClass("sapMFlexBoxAlignContent"+c.getAlignContent());r.addClass("sapMFlexBoxBG"+c.getBackgroundDesign());r.writeClasses();if(c.getHeight()){r.addStyle("height",c.getHeight());}if(c.getWidth()){r.addStyle("width",c.getWidth());}r.writeStyles();var t=c.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}r.write(">");a.renderItems(c,r);if(c.getRenderType()===sap.m.FlexRendertype.List){r.write("</ul>");}else{r.write("</div>");}};
a.renderItems=function(c,r){var C=c.getItems(),w='';for(var i=0;i<C.length;i++){if(C[i]instanceof sap.m.FlexBox||c.getRenderType()===sap.m.FlexRendertype.Bare){w="";}else if(c.getRenderType()===sap.m.FlexRendertype.List){w="li";}else{w="div";}a.renderItem(C[i],w,r);}};
a.renderItem=function(i,w,r){if(w){r.write('<'+w);if(i instanceof sap.m.ScrollContainer){r.addClass("sapMFlexBoxScroll");}if(!i.getVisible()){r.addClass("sapUiHiddenPlaceholder");}}var l=i.getLayoutData();if(w&&!l){i.setAggregation("layoutData",new sap.m.FlexItemData(),true);l=i.getLayoutData();}if(!(l instanceof sap.m.FlexItemData)){q.sap.log.warning(l+" set on "+i+" is not of type sap.m.FlexItemData");}else{if(w&&l.getId()){r.writeAttributeEscaped("id",l.getId());}if(l.getStyleClass()){a.addItemClass(q.sap.encodeHTML(l.getStyleClass()),i,w,r);}a.addItemClass("sapMFlexItemAlign"+l.getAlignSelf(),i,w,r);a.addItemClass("sapMFlexBoxBG"+l.getBackgroundDesign(),i,w,r);if(w){F.setFlexItemStyles(r,l);}}a.addItemClass("sapMFlexItem",i,w,r);if(w){r.writeStyles();r.writeClasses();r.write(">");}r.renderControl(i);if(w){r.write('</'+w+'>');}};
a.addItemClass=function(c,i,w,r){if(w){r.addClass(c);}else{i.addStyleClass(c);}};
return a;},true);
sap.ui.predefine('sap/m/FlexBoxStylingHelper',['jquery.sap.global','./FlexBoxCssPropertyMap'],function(q,F){"use strict";var a={};
a.setFlexItemStyles=function(r,l){r=r||null;var o=''+l.getOrder(),g=''+l.getGrowFactor(),s=''+l.getShrinkFactor(),b=l.getBaseSize().toLowerCase(),m=l.getMinHeight(),M=l.getMaxHeight(),c=l.getMinWidth(),d=l.getMaxWidth();if(typeof o!=='undefined'){a.setStyle(r,l,"order",o);}if(typeof g!=='undefined'){a.setStyle(r,l,"flex-grow",g);}if(q.support.newFlexBoxLayout||q.support.ie10FlexBoxLayout){if(typeof s!=='undefined'){a.setStyle(r,l,"flex-shrink",s);}if(typeof b!=='undefined'){a.setStyle(r,l,"flex-basis",b);}}if(typeof m!=='undefined'){a.setStyle(r,l,"min-height",m);}if(typeof M!=='undefined'){a.setStyle(r,l,"max-height",M);}if(typeof c!=='undefined'){a.setStyle(r,l,"min-width",c);}if(typeof d!=='undefined'){a.setStyle(r,l,"max-width",d);}};
a.setStyle=function(r,l,p,v){if(typeof(v)==="string"){v=v.replace(/([a-z])([A-Z])/g,"$1-$2").toLowerCase();}if(q.support.flexBoxPrefixed){if(sap.ui.Device.browser.webkit){this.sVendorPrefix="-webkit-";}else if(sap.ui.Device.browser.mozilla){this.sVendorPrefix="-moz-";}else if(sap.ui.Device.browser.internet_explorer){this.sVendorPrefix="-ms-";}}else{this.sVendorPrefix="";}if(q.support.newFlexBoxLayout||["min-height","max-height","min-width","max-width"].indexOf(p)!==-1){a.writeStyle(r,l,p,v);}else if(q.support.flexBoxLayout||q.support.ie10FlexBoxLayout){a.setOldSpecStyle(r,l,p,v);}};
a.setOldSpecStyle=function(r,l,p,v){var s="";if(this.sVendorPrefix=="-ms-"){s="specie10";}else{s="spec0907";}if(F[s][p]!==null&&F[s][p]!=="<idem>"){var L=null;if(typeof(F[s][p])==="object"){if(F[s][p]["<number>"]){L={};for(var k in F[s][p]["<number>"]){if(F[s][p]["<number>"][k]==="<number>"){L[k]=v;}else{L[k]=F[s][p]["<number>"][k];}}}else{L=F[s][p][v];}}else{L=F[s][p][v];}if(L!==null&&L!=="<idem>"){if(typeof(L)==="object"){for(var b in L){a.writeStyle(r,l,b,L[b]);}}}}};
a.writeStyle=function(r,l,p,v){var P="";var V="";if(p!=="display"){P=this.sVendorPrefix;}else{V=this.sVendorPrefix;}if(sap.ui.Device.browser.internet_explorer&&(p==="flex-basis"||p==="flex-preferred-size")){P="";if(l.getParent()){if(l.getParent().getParent().getDirection().indexOf("Row")>-1){p="width";}else{p="height";}}}if(r){if(v==="0"||v){r.addStyle(P+p,V+v);}}else{if(l.$().length){if(v!=="0"&&!v){l.$().css(P+p,null);}else{l.$().css(P+p,V+v);}}else{if(l.getParent()){if(v!=="0"&&!v){l.getParent().$().css(P+p,null);}else{l.getParent().$().css(P+p,V+v);}}}}};
return a;},true);
sap.ui.predefine('sap/m/FlexItemData',['jquery.sap.global','./FlexBoxStylingHelper','./library','sap/ui/core/LayoutData'],function(q,F,l,L){"use strict";
var a=L.extend("sap.m.FlexItemData",{metadata:{library:"sap.m",properties:{alignSelf:{type:"sap.m.FlexAlignSelf",group:"Misc",defaultValue:sap.m.FlexAlignSelf.Auto},order:{type:"int",group:"Misc",defaultValue:0},growFactor:{type:"float",group:"Misc",defaultValue:0},shrinkFactor:{type:"float",group:"Misc",defaultValue:1},baseSize:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:"auto"},minHeight:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'},maxHeight:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:''},minWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'},maxWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:''},styleClass:{type:"string",group:"Misc",defaultValue:''},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:sap.m.BackgroundDesign.Transparent}}}});
a.prototype.setAlignSelf=function(v){var o=this.getAlignSelf();this.setProperty("alignSelf",v,true);this.$().removeClass("sapMFlexItemAlign"+o).addClass("sapMFlexItemAlign"+this.getAlignSelf());return this;};
a.prototype.setOrder=function(v){this.setProperty("order",v,true);F.setStyle(null,this,"order",this.getOrder());return this;};
a.prototype.setGrowFactor=function(v){this.setProperty("growFactor",v,true);F.setStyle(null,this,"flex-grow",this.getGrowFactor());return this;};
a.prototype.setShrinkFactor=function(v){this.setProperty("shrinkFactor",v,true);F.setStyle(null,this,"flex-shrink",this.getShrinkFactor());return this;};
a.prototype.setBaseSize=function(v){this.setProperty("baseSize",v,true);F.setStyle(null,this,"flex-basis",this.getBaseSize());return this;};
a.prototype.setMinHeight=function(v){this.setProperty("minHeight",v,true);this.$().css("min-height",this.getMinHeight());return this;};
a.prototype.setMaxHeight=function(v){this.setProperty("maxHeight",v,true);this.$().css("max-height",this.getMaxHeight());return this;};
a.prototype.setMinWidth=function(v){this.setProperty("minWidth",v,true);this.$().css("min-width",this.getMinWidth());return this;};
a.prototype.setMaxWidth=function(v){this.setProperty("maxWidth",v,true);this.$().css("max-width",this.getMaxWidth());return this;};
a.prototype.setBackgroundDesign=function(v){var o=this.getBackgroundDesign();this.setProperty("backgroundDesign",v,true);this.$().removeClass("sapMFlexBoxBG"+o).addClass("sapMFlexBoxBG"+this.getBackgroundDesign());return this;};
a.prototype.setStyleClass=function(v){var o=this.getStyleClass();this.setProperty("styleClass",v,true);this.$().removeClass(o).addClass(this.getStyleClass());return this;};
return a;},true);
sap.ui.predefine('sap/m/FormattedText',['jquery.sap.global','./library','sap/ui/core/Control','./FormattedTextAnchorGenerator'],function(q,l,C,F){"use strict";
var a=C.extend("sap.m.FormattedText",{metadata:{library:"sap.m",properties:{htmlText:{type:"string",group:"Misc",defaultValue:""},width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},convertLinksToAnchorTags:{type:"sap.m.LinkConversion",group:"Behavior",defaultValue:sap.m.LinkConversion.None},convertedLinksDefaultTarget:{type:"string",group:"Behavior",defaultValue:"_blank"},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null}}}});
var _={ATTRIBS:{'style':1,'class':1,'a::href':1,'a::target':1},ELEMENTS:{'a':{cssClass:'sapMLnk'},'abbr':1,'blockquote':1,'br':1,'cite':1,'code':1,'em':1,'h1':{cssClass:'sapMTitle sapMTitleStyleH1'},'h2':{cssClass:'sapMTitle sapMTitleStyleH2'},'h3':{cssClass:'sapMTitle sapMTitleStyleH3'},'h4':{cssClass:'sapMTitle sapMTitleStyleH4'},'h5':{cssClass:'sapMTitle sapMTitleStyleH5'},'h6':{cssClass:'sapMTitle sapMTitleStyleH6'},'p':1,'pre':1,'strong':1,'span':1,'u':1,'dl':1,'dt':1,'dd':1,'ol':1,'ul':1,'li':1}},b={ATTRIBS:{'a::href':1,'a::target':1},ELEMENTS:{'a':{cssClass:'sapMLnk'},'em':1,'strong':1,'u':1}},c=_;
a.prototype.init=function(){};
function s(t,e){var w;var f,v,g=t==="a";var h=c.ELEMENTS[t].cssClass||"";for(var i=0;i<e.length;i+=2){f=e[i];v=e[i+1];if(!c.ATTRIBS[f]&&!c.ATTRIBS[t+"::"+f]){w='FormattedText: <'+t+'> with attribute ['+f+'="'+v+'"] is not allowed';q.sap.log.warning(w,this);e[i+1]=null;continue;}if(f=="href"){if(!q.sap.validateUrl(v)){q.sap.log.warning("FormattedText: incorrect href attribute:"+v,this);e[i+1]="#";g=false;}}if(f=="target"){g=false;}if(h&&f.toLowerCase()=="class"){e[i+1]=h+" "+v;h="";}}if(g){e.push("target");e.push("_blank");}if(h){e.push("class");e.push(h);}return e;}
function p(t,e){if(c.ELEMENTS[t]){return s(t,e);}else{var w='<'+t+'> is not allowed';q.sap.log.warning(w,this);}}
function d(t){return q.sap._sanitizeHTML(t,{tagPolicy:p,uriRewriter:function(u){if(q.sap.validateUrl(u)){return u;}}});}
function o(e){var n=window.open();n.opener=null;n.location=e.currentTarget.href;e.preventDefault();}
a.prototype.onAfterRendering=function(){this.$().find('a[target="_blank"]').on("click",o);};
a.prototype._getDisplayHtml=function(){var t=this.getHtmlText(),A=this.getConvertLinksToAnchorTags();if(A===l.LinkConversion.None){return t;}t=F.generateAnchors(t,A,this.getConvertedLinksDefaultTarget());return d(t);};
a.prototype.setHtmlText=function(t){return this.setProperty("htmlText",d(t));};
a.prototype._setUseLimitedRenderingRules=function(L){c=L?b:_;};
return a;},true);
sap.ui.predefine('sap/m/FormattedTextAnchorGenerator',["jquery.sap.global","sap/ui/base/Metadata"],function(q,M){"use strict";var A=M.createClass("sap.m.FormattedTextAnchorGenerator",{});var L=/(\b(https?|ftp):\/\/[-A-Z0-9+&@#\/%?=~_|!:,.;]*[-A-Z0-9+&@#\/%=~_|])/gim;var W=/(www\.[^\s><]+(\b|$))/gim;var c="//";var D=/<(?:"[^"]*"['"]*|'[^']*'['"]*|[^'">])+(?!\/\s\*)>/gim;var E=/<a[^>]*>([^<]+)<\/a>/gim;var d=[D,E];
A.generateAnchors=function(t,l,T){if(l===sap.m.LinkConversion.ProtocolOnly){t=A._createAnchors(t,L,T);}if(l===sap.m.LinkConversion.All){t=A._createAnchors(t,L,T);t=A._createAnchors(t,W,T,c);}return t;};
A._createPositionObject=function(i,l){return{iStartPos:i,iEndPos:i+l};};
A._isNested=function(f,s){return f.iStartPos<s.iStartPos&&f.iEndPos>s.iEndPos;};
A._isAllowed=function(b,C){return b.some(function(B){return A._isNested(B,C);});};
A._shouldBeProcessed=function(u,C,b){return q.sap.validateUrl(u)&&!A._isAllowed(b,C);};
A._scanForEntitiesToSkip=function(r,t){var e=[],C;while((C=r.exec(t))!==null){e.push(A._createPositionObject(C.index,C[0].length));}return e;};
A._getEntitiesToSkipWhileSearchingForLinks=function(t){return d.map(function(s){return A._scanForEntitiesToSkip(s,t);}).reduce(function(a,b){return a.concat(b);});};
A._createAnchors=function(t,r,T,p){var e=A._getEntitiesToSkipWhileSearchingForLinks(t),C;p=p||'';C=function(P){var o=A._createPositionObject(arguments[3],P.length);if(!A._shouldBeProcessed(P,o,e)){return P;}return"<a href=\""+p+P+"\" target=\""+T+"\">"+P+"</a>";};return t.replace(r,C);};
return A;},false);
sap.ui.predefine('sap/m/FormattedTextRenderer',['jquery.sap.global'],function(q){"use strict";var F={};
F.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapMFT");r.writeClasses();if(c.getTooltip_AsString()){r.writeAttributeEscaped("title",c.getTooltip_AsString());}r.addStyle("width",c.getWidth()||null);r.addStyle("height",c.getHeight()||null);r.writeStyles();r.write(">");r.write(c._getDisplayHtml());r.write("</div>");};
return F;},true);
sap.ui.predefine('sap/m/GenericTile',['jquery.sap.global','./library','sap/ui/core/Control','sap/m/Text','sap/ui/core/HTML','sap/ui/core/Icon','sap/ui/core/IconPool','sap/m/Button','sap/m/GenericTileRenderer','sap/m/GenericTileLineModeRenderer','sap/ui/Device','sap/ui/core/ResizeHandler'],function(q,l,C,T,H,I,a,B,G,L,D,R){"use strict";
var b=C.extend("sap.m.GenericTile",{
metadata:{library:"sap.m",properties:{"mode":{type:"sap.m.GenericTileMode",group:"Appearance",defaultValue:sap.m.GenericTileMode.ContentMode},"header":{type:"string",group:"Appearance",defaultValue:null},"subheader":{type:"string",group:"Appearance",defaultValue:null},"failedText":{type:"string",group:"Appearance",defaultValue:null},"size":{type:"sap.m.Size",group:"Misc",defaultValue:sap.m.Size.Auto},"frameType":{type:"sap.m.FrameType",group:"Misc",defaultValue:sap.m.FrameType.OneByOne},"backgroundImage":{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},"headerImage":{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},"state":{type:"sap.m.LoadState",group:"Misc",defaultValue:sap.m.LoadState.Loaded},"imageDescription":{type:"string",group:"Accessibility",defaultValue:null},"scope":{type:"sap.m.GenericTileScope",group:"Misc",defaultValue:sap.m.GenericTileScope.Display},"ariaLabel":{type:"string",group:"Accessibility",defaultValue:null}},defaultAggregation:"tileContent",aggregations:{"tileContent":{type:"sap.m.TileContent",multiple:true,bindable:"bindable"},"icon":{type:"sap.ui.core.Control",multiple:false},"_titleText":{type:"sap.m.Text",multiple:false,visibility:"hidden"},"_failedMessageText":{type:"sap.m.Text",multiple:false,visibility:"hidden"}},events:{"press":{parameters:{"scope":{type:"sap.m.GenericTileScope"},"action":{type:"string"},"domRef":{type:"any"}}}}},
renderer:function(r,c){if(c.getMode()===l.GenericTileMode.LineMode){L.render(r,c);}else{G.render(r,c);}}
});
b._Action={Press:"Press",Remove:"Remove"};b.LINEMODE_SIBLING_PROPERTIES=["state","subheader","header","scope"];
b.prototype.init=function(){this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");D.media.initRangeSet("GenericTileDeviceSet",[450],"px",["small","large"]);this._oTitle=new T(this.getId()+"-title");this._oTitle.addStyleClass("sapMGTTitle");this._oTitle.cacheLineHeight=false;this.setAggregation("_titleText",this._oTitle,true);this._sFailedToLoad=this._oRb.getText("INFOTILE_CANNOT_LOAD_TILE");this._sLoading=this._oRb.getText("INFOTILE_LOADING");this._oFailedText=new T(this.getId()+"-failed-txt",{maxLines:2});this._oFailedText.cacheLineHeight=false;this._oFailedText.addStyleClass("sapMGTFailed");this.setAggregation("_failedMessageText",this._oFailedText,true);this._oWarningIcon=new I(this.getId()+"-warn-icon",{src:"sap-icon://notification",size:"1.375rem"});this._oWarningIcon.addStyleClass("sapMGTFtrFldIcnMrk");this._oBusy=new H(this.getId()+"-overlay");this._oBusy.setBusyIndicatorDelay(0);this._bTilePress=true;this._bThemeApplied=true;if(!sap.ui.getCore().isInitialized()){this._bThemeApplied=false;sap.ui.getCore().attachInit(this._handleCoreInitialized.bind(this));}else{this._handleCoreInitialized();}};
b.prototype._handleCoreInitialized=function(){this._bThemeApplied=sap.ui.getCore().isThemeApplied();if(!this._bThemeApplied){sap.ui.getCore().attachThemeChanged(this._handleThemeApplied,this);}};
b.prototype._handleThemeApplied=function(){this._bThemeApplied=true;this._oTitle.clampHeight();sap.ui.getCore().detachThemeChanged(this._handleThemeApplied,this);};
b.prototype._initScopeContent=function(t){switch(this.getScope()){case l.GenericTileScope.Actions:if(this.getState&&this.getState()===l.LoadState.Disabled){break;}this._oMoreIcon=this._oMoreIcon||a.createControlByURI({id:this.getId()+"-action-more",size:"1rem",useIconTooltip:false,src:"sap-icon://overflow"}).addStyleClass("sapMPointer").addStyleClass(t+"MoreIcon");this._oRemoveButton=this._oRemoveButton||new B({id:this.getId()+"-action-remove",icon:"sap-icon://decline",tooltip:this._oRb.getText("GENERICTILE_REMOVEBUTTON_TEXT")}).addStyleClass("sapUiSizeCompact").addStyleClass(t+"RemoveButton");this._oRemoveButton._bExcludeFromTabChain=true;break;default:}};
b.prototype.exit=function(){if(this._sParentResizeListenerId){R.deregister(this._sResizeListenerId);this._sParentResizeListenerId=null;}D.media.detachHandler(this._handleMediaChange,this,"GenericTileDeviceSet");if(this._$RootNode){this._$RootNode.off(this._getAnimationEvents());this._$RootNode=null;}this._clearAnimationUpdateQueue();this._oWarningIcon.destroy();if(this._oImage){this._oImage.destroy();}this._oBusy.destroy();if(this._oMoreIcon){this._oMoreIcon.destroy();}if(this._oRemoveButton){this._oRemoveButton.destroy();}};
b.prototype.onBeforeRendering=function(){var s=!!this.getSubheader();if(this.getMode()===l.GenericTileMode.HeaderMode){this._applyHeaderMode(s);}else{this._applyContentMode(s);}var t=this.getTileContent().length;for(var i=0;i<t;i++){this.getTileContent()[i].setDisabled(this.getState()===l.LoadState.Disabled);}this._initScopeContent("sapMGT");this._generateFailedText();this.$().unbind("mouseenter",this._updateAriaAndTitle);this.$().unbind("mouseleave",this._removeTooltipFromControl);if(this._sParentResizeListenerId){R.deregister(this._sResizeListenerId);this._sParentResizeListenerId=null;}D.media.detachHandler(this._handleMediaChange,this,"GenericTileDeviceSet");if(this._$RootNode){this._$RootNode.off(this._getAnimationEvents());}if(this.getFrameType()===l.FrameType.Auto){this.setProperty("frameType",l.FrameType.OneByOne,true);}};
b.prototype.onAfterRendering=function(){this.$().bind("mouseenter",this._updateAriaAndTitle.bind(this));this.$().bind("mouseleave",this._removeTooltipFromControl.bind(this));var m=this.getMode();if(m===l.GenericTileMode.LineMode&&this._isScreenLarge()){this.$().parent().addClass("sapMGTLineModeContainer");this._updateHoverStyle(true);if(this.getParent()instanceof C){this._sParentResizeListenerId=R.register(this.getParent(),this._handleResize.bind(this));}else{this._sParentResizeListenerId=R.register(this.$().parent(),this._handleResize.bind(this));}}if(m===l.GenericTileMode.LineMode&&this._bUpdateLineTileSiblings){this._updateLineTileSiblings();this._bUpdateLineTileSiblings=false;}if(m===l.GenericTileMode.LineMode){D.media.attachHandler(this._handleMediaChange,this,"GenericTileDeviceSet");}};
b.prototype._handleResize=function(){if(this.getMode()===l.GenericTileMode.LineMode&&this._isScreenLarge()&&this.getParent()){this._queueAnimationEnd();}};
b.prototype._isCompact=function(){return q("body").hasClass("sapUiSizeCompact")||this.$().is(".sapUiSizeCompact")||this.$().closest(".sapUiSizeCompact").length>0;};
b.prototype._calculateStyleData=function(){this.$("lineBreak").remove();if(!this._isScreenLarge()||!this.getDomRef()||this.$().is(":hidden")){return null;}var $=this.$(),e=this.$("endMarker"),s=this.$("startMarker");if(e.length===0||s.length===0){return null;}var c=this._getLineCount(),d,f,g=Math.ceil(L._getCSSPixelValue(this,"margin-top")),h,A=this.$().parent().innerWidth(),j=Math.ceil(L._getCSSPixelValue(this,"min-height")),k=L._getCSSPixelValue(this,"line-height"),m=this.$().is(":not(:first-child)")&&c>1,n=q("<span><br /></span>"),i=0,r=sap.ui.getCore().getConfiguration().getRTL(),E=e.position();if(m){n.attr("id",this.getId()+"-lineBreak");$.prepend(n);c=this._getLineCount();E=e.position();}var S={rtl:r,lineBreak:m,startOffset:s.offset(),endOffset:e.offset(),availableWidth:A,lines:[]};var o;if(D.browser.msie||D.browser.edge){o=n.find("br").position();}else{o=n.position();}var p=o;if(!(D.browser.mozilla||D.browser.msie||D.browser.edge)&&o.left<E.left){p=E;}S.positionLeft=m?o.left:$.position().left;S.positionRight=m?$.width()-p.left:S.availableWidth-$.position().left;if(!m&&c>1){S.positionRight=s.parent().innerWidth()-(s.position().left+s.width());}for(i;i<c;i++){if(m&&i===0){continue;}if(c===1){d=r?S.availableWidth-S.positionLeft:S.positionLeft;h=$.width();}else if(i===c-1){d=0;h=r?$.width()-E.left:E.left;}else if(m&&i===1){d=0;h=A;}else{d=0;h=A;}f=i*k+g;S.lines.push({offset:{x:d,y:f},width:h,height:j});}return S;};
b.prototype._getStyleData=function(){var s=this._calculateStyleData();if(!q.sap.equal(this._oStyleData,s)){delete this._oStyleData;this._oStyleData=s;return true;}return false;};
b.prototype._getAnimationEvents=function(){return"transitionend.sapMGT$id animationend.sapMGT$id".replace(/\$id/g,q.sap.camelCase(this.getId()));};
b.prototype._updateHoverStyle=function(f){if(!this._getStyleData()&&!f){return;}this._clearAnimationUpdateQueue();this._cHoverStyleUpdates=-1;this._oAnimationEndCallIds={};if(this._oStyleData&&this._oStyleData.lineBreak&&this.getUIArea()){this._$RootNode=q(this.getUIArea().getRootNode());this._$RootNode.on(this._getAnimationEvents(),this._queueAnimationEnd.bind(this));}this._queueAnimationEnd();};
b.prototype._queueAnimationEnd=function(e){if(e){var t=q(e.target);if(t.is(".sapMGT, .sapMGT *")){return false;}}if(typeof this._cHoverStyleUpdates!=="number"){this._cHoverStyleUpdates=-1;}if(!this._oAnimationEndCallIds){this._oAnimationEndCallIds={};}this._cHoverStyleUpdates++;this._oAnimationEndCallIds[this._cHoverStyleUpdates]=q.sap.delayedCall(10,this,this._handleAnimationEnd,[this._cHoverStyleUpdates]);};
b.prototype._handleAnimationEnd=function(h){delete this._oAnimationEndCallIds[h];if(this._cHoverStyleUpdates===h){this._getStyleData();L._updateHoverStyle.call(this);}};
b.prototype._clearAnimationUpdateQueue=function(){for(var k in this._oAnimationEndCallIds){q.sap.clearDelayedCall(this._oAnimationEndCallIds[k]);delete this._oAnimationEndCallIds[k];}};
b.prototype._getLineCount=function(){var c=this.getDomRef().getBoundingClientRect(),d=L._getCSSPixelValue(this,"line-height");return Math.round(c.height/d);};
b.prototype.getBoundingRects=function(){var p=this.$().offset();if(this.getMode()===l.GenericTileMode.LineMode&&this._isScreenLarge()){this._getStyleData();var r=[],s,o;this.$().find(".sapMGTLineStyleHelper").each(function(){s=q(this);o=s.offset();r.push({offset:{x:o.left,y:o.top},width:s.width(),height:s.height()});});return r;}else{return[{offset:{x:p.left,y:p.top},width:this.$().width(),height:this.$().height()}];}};
b.prototype._updateLineTileSiblings=function(){var p=this.getParent();if(this.getMode()===l.GenericTileMode.LineMode&&this._isScreenLarge()&&p){var i=p.indexOfAggregation(this.sParentAggregationName,this);var s=p.getAggregation(this.sParentAggregationName).splice(i+1);for(i=0;i<s.length;i++){var S=s[i];if(S instanceof l.GenericTile&&S.getMode()===l.GenericTileMode.LineMode){S._updateHoverStyle();}}}};
b.prototype.ontouchstart=function(){if(this.$("hover-overlay").length>0){this.$("hover-overlay").addClass("sapMGTPressActive");}if(this.getMode()===l.GenericTileMode.LineMode){this.addStyleClass("sapMGTLineModePress");}if(D.browser.internet_explorer&&this.getState()!==l.LoadState.Disabled){this.$().focus();}};
b.prototype.ontouchcancel=function(){if(this.$("hover-overlay").length>0){this.$("hover-overlay").removeClass("sapMGTPressActive");}};
b.prototype.ontouchend=function(){if(this.$("hover-overlay").length>0){this.$("hover-overlay").removeClass("sapMGTPressActive");}if(this.getMode()===l.GenericTileMode.LineMode){this.removeStyleClass("sapMGTLineModePress");}if(D.browser.internet_explorer&&this.getState()!==l.LoadState.Disabled){this.$().focus();}};
b.prototype.ontap=function(e){var p;if(this._bTilePress&&this.getState()!==l.LoadState.Disabled){this.$().focus();p=this._getEventParams(e);this.firePress(p);e.preventDefault();}};
b.prototype.onkeydown=function(e){if(q.sap.PseudoEvents.sapselect.fnCheck(e)&&this.getState()!==l.LoadState.Disabled){if(this.$("hover-overlay").length>0){this.$("hover-overlay").addClass("sapMGTPressActive");}e.preventDefault();}};
b.prototype.onkeyup=function(e){var p,f=false,s=this.getScope(),A=s===l.GenericTileScope.Actions;if(A&&(q.sap.PseudoEvents.sapdelete.fnCheck(e)||q.sap.PseudoEvents.sapbackspace.fnCheck(e))){p={scope:s,action:b._Action.Remove,domRef:this._oRemoveButton.getPopupAnchorDomRef()};f=true;}if(q.sap.PseudoEvents.sapselect.fnCheck(e)&&this.getState()!==l.LoadState.Disabled){if(this.$("hover-overlay").length>0){this.$("hover-overlay").removeClass("sapMGTPressActive");}p=this._getEventParams(e);f=true;}if(f){this.firePress(p);e.preventDefault();}};
b.prototype.setProperty=function(p){sap.ui.core.Control.prototype.setProperty.apply(this,arguments);if(this.getMode()===l.GenericTileMode.LineMode&&b.LINEMODE_SIBLING_PROPERTIES.indexOf(p)!==-1){this._bUpdateLineTileSiblings=true;}return this;};
b.prototype.getHeader=function(){return this._oTitle.getText();};
b.prototype.setHeader=function(t){this._oTitle.setText(t);return this;};
b.prototype.setHeaderImage=function(u){var v=!q.sap.equal(this.getHeaderImage(),u);if(v){if(this._oImage){this._oImage.destroy();this._oImage=undefined;}if(u){this._oImage=a.createControlByURI({id:this.getId()+"-icon-image",src:u},l.Image);this._oImage.addStyleClass("sapMGTHdrIconImage");}}return this.setProperty("headerImage",u);};
b.prototype._applyHeaderMode=function(s){if(s){this._oTitle.setMaxLines(4);}else{this._oTitle.setMaxLines(5);}this._changeTileContentContentVisibility(false);};
b.prototype._applyContentMode=function(s){if(s){this._oTitle.setMaxLines(2);}else{this._oTitle.setMaxLines(3);}this._changeTileContentContentVisibility(true);};
b.prototype._changeTileContentContentVisibility=function(v){var t;t=this.getTileContent();for(var i=0;i<t.length;i++){t[i].setRenderContent(v);}};
b.prototype._getHeaderAriaAndTooltipText=function(){var t="";var i=true;if(this.getHeader()){t+=this.getHeader();i=false;}if(this.getSubheader()){t+=(i?"":"\n")+this.getSubheader();i=false;}if(this.getImageDescription()){t+=(i?"":"\n")+this.getImageDescription();}return t;};
b.prototype._getContentAriaAndTooltipText=function(){var t="";var c=true;var d=this.getTileContent();for(var i=0;i<d.length;i++){if(q.isFunction(d[i]._getAriaAndTooltipText)){t+=(c?"":"\n")+d[i]._getAriaAndTooltipText();}else if(d[i].getTooltip_AsString()){t+=(c?"":"\n")+d[i].getTooltip_AsString();}c=false;}return t;};
b.prototype._getAriaAndTooltipText=function(){var A=(this.getTooltip_AsString()&&!this._isTooltipSuppressed())?this.getTooltip_AsString():(this._getHeaderAriaAndTooltipText()+"\n"+this._getContentAriaAndTooltipText());switch(this.getState()){case l.LoadState.Disabled:return"";case l.LoadState.Loading:return A+"\n"+this._sLoading;case l.LoadState.Failed:return A+"\n"+this._oFailedText.getText();default:if(q.trim(A).length===0){return"";}else{return A;}}};
b.prototype._getAriaText=function(){var A=this.getTooltip_Text();var s=this.getAriaLabel();if(!A||this._isTooltipSuppressed()){A=this._getAriaAndTooltipText();}if(this.getScope()===l.GenericTileScope.Actions){A=this._oRb.getText("GENERICTILE_ACTIONS_ARIA_TEXT")+" "+A;}if(s){A=s+" "+A;}return A;};
b.prototype._getTooltipText=function(){var t=this.getTooltip_Text();if(this._isTooltipSuppressed()===true){t=null;}return t;};
b.prototype._checkFooter=function(t,c){var s=c.getState();var A=this.getScope()===l.GenericTileScope.Actions||this._bShowActionsView===true;if(s===l.LoadState.Failed||A&&s!==l.LoadState.Disabled){t.setRenderFooter(false);}else{t.setRenderFooter(true);}};
b.prototype._generateFailedText=function(){var c=this.getFailedText();var f=c?c:this._sFailedToLoad;this._oFailedText.setText(f);this._oFailedText.setTooltip(f);};
b.prototype._isTooltipSuppressed=function(){var t=this.getTooltip_Text();if(t&&t.length>0&&q.trim(t).length===0){return true;}else{return false;}};
b.prototype._isHeaderTextTruncated=function(){var d,m,h,w;if(this.getMode()===l.GenericTileMode.LineMode){h=this.$("hdr-text");if(h.length>0){w=Math.ceil(h[0].getBoundingClientRect().width);return(h[0]&&w<h[0].scrollWidth);}else{return false;}}else{d=this.getAggregation("_titleText").getDomRef("inner");m=this.getAggregation("_titleText").getClampHeight(d);return(m<d.scrollHeight);}};
b.prototype._isSubheaderTextTruncated=function(){var s=this.$("subHdr-text"),w;if(s.length>0){w=Math.ceil(s[0].getBoundingClientRect().width);return(s[0]&&w<s[0].scrollWidth);}else{return false;}};
b.prototype._setTooltipFromControl=function(){var c,t="";var d=true;var e=this.getTileContent();if(this._isHeaderTextTruncated()){t=this._oTitle.getText();d=false;}if(this._isSubheaderTextTruncated()){t+=(d?"":"\n")+this.getSubheader();d=false;}if(this.getScope()!==l.GenericTileScope.Actions){for(var i=0;i<e.length;i++){c=e[i].getContent();if(c&&c.getMetadata().getLibraryName()==="sap.suite.ui.microchart"){t+=(d?"":"\n")+c.getTooltip_AsString();}d=false;}}if(t&&!this._getTooltipText()&&!this._isTooltipSuppressed()){this.$().attr("title",t);this._bTooltipFromControl=true;}};
b.prototype._updateAriaAndTitle=function(){var A=this._getAriaAndTooltipText();var s=this._getAriaText();var t=this.$();if(t.attr("title")!==A){t.attr("aria-label",s);}if(this.getScope()===l.GenericTileScope.Actions){t.find('*:not(.sapMGTRemoveButton)').removeAttr("aria-label").removeAttr("title").unbind("mouseenter");}else{t.find('*').removeAttr("aria-label").removeAttr("title").unbind("mouseenter");}this._setTooltipFromControl();};
b.prototype._removeTooltipFromControl=function(){if(this._bTooltipFromControl){this.$().removeAttr("title");this._bTooltipFromControl=false;}};
b.prototype._isScreenLarge=function(){return this._getCurrentMediaContainerRange("GenericTileDeviceSet").name==="large";};
b.prototype._getEventParams=function(e){var p,A=b._Action.Press,s=this.getScope(),d=this.getDomRef();if(s===l.GenericTileScope.Actions&&e.target.id.indexOf("-action-remove")>-1){A=b._Action.Remove;d=this._oRemoveButton.getPopupAnchorDomRef();}else if(s===l.GenericTileScope.Actions){d=this._oMoreIcon.getDomRef();}p={scope:s,action:A,domRef:d};return p;};
b.prototype._handleMediaChange=function(){this._bUpdateLineTileSiblings=true;this.invalidate();};
b.prototype.setPressEnabled=function(v){this._bTilePress=v;};
b.prototype.showActionsView=function(v){if(this._bShowActionsView!==v){this._bShowActionsView=v;this.invalidate();}};
return b;},true);
sap.ui.predefine('sap/m/GenericTileLineModeRenderer',["sap/m/GenericTileRenderer","sap/m/library"],function(T,l){"use strict";var G=l.GenericTileScope;var L=l.LoadState;var a={};
a.render=function(r,c){var t=c._getTooltipText(),i=c._isScreenLarge(),A=c._getAriaText(),s=jQuery.sap.encodeCSS("sapMGTScope"+c.getScope()),h=c.hasListeners("press");this._bRTL=sap.ui.getCore().getConfiguration().getRTL();r.write("<span");r.writeControlData(c);r.writeAttributeEscaped("aria-label",A);if(h){r.writeAttribute("role","button");}else{r.writeAttribute("role","presentation");}r.addClass("sapMGT");r.addClass(s);r.addClass("sapMGTLineMode");this._writeDirection(r);if(t){r.writeAttributeEscaped("title",t);}var S=c.getState();if(S!==L.Disabled){r.addClass("sapMPointer");r.writeAttribute("tabindex","0");}else{r.addClass("sapMGTDisabled");}if(S===L.Failed){r.addClass("sapMGTFailed");}r.writeClasses();r.write(">");if(i){r.write("<div");r.writeAttribute("id",c.getId()+"-startMarker");r.addClass("sapMGTStartMarker");r.writeClasses();r.write("/>");this._renderFailedIcon(r,c);this._renderHeader(r,c);if(c.getSubheader()){this._renderSubheader(r,c);}r.write("<div");r.writeAttribute("id",c.getId()+"-endMarker");r.addClass("sapMGTEndMarker");r.writeClasses();r.write(">");if(c.getScope()===G.Actions){this._renderActionsScope(r,c);}r.write("</div>");r.write("<div");r.writeAttribute("id",c.getId()+"-styleHelper");r.addClass("sapMGTStyleHelper");r.writeClasses();r.write("/>");}else{if(c.getState()!==L.Disabled){this._renderFocusDiv(r,c);}r.write("<div");r.writeAttribute("id",c.getId()+"-touchArea");r.addClass("sapMGTTouchArea");r.writeClasses();r.write(">");this._renderFailedIcon(r,c);r.write("<span");r.writeAttribute("id",c.getId()+"-lineModeHelpContainer");r.addClass("sapMGTLineModeHelpContainer");r.writeClasses();r.write(">");this._renderHeader(r,c);if(c.getSubheader()){this._renderSubheader(r,c);}r.write("</span>");if(c.getScope()===G.Actions){this._renderActionsScope(r,c);}r.write("</div>");}r.write("</span>");};
a._writeDirection=function(r){if(this._bRTL){r.writeAttribute("dir","rtl");}};
a._renderFailedIcon=function(r,c){if(c.getState()===L.Failed){if(c._isCompact()){c._oWarningIcon.setSize("1.25rem");}else{c._oWarningIcon.setSize("1.375rem");}r.renderControl(c._oWarningIcon.addStyleClass("sapMGTLineModeFailedIcon"));}};
a._renderHeader=function(r,c){r.write("<span");this._writeDirection(r);r.addClass("sapMGTHdrTxt");r.writeClasses();r.writeAttribute("id",c.getId()+"-hdr-text");r.write(">");r.writeEscaped(c._oTitle.getText());r.write("</span>");};
a._renderSubheader=function(r,c){r.write("<span");this._writeDirection(r);r.addClass("sapMGTSubHdrTxt");r.writeClasses();r.writeAttribute("id",c.getId()+"-subHdr-text");r.write(">");r.writeEscaped(c.getSubheader());r.write("</span>");};
a._renderActionsScope=function(r,c){if(c.getState()!==L.Disabled){r.write("<span");r.writeAttribute("id",c.getId()+"-actions");r.addClass("sapMGTActionsContainer");r.writeClasses();r.write(">");r.renderControl(c._oMoreIcon);r.renderControl(c._oRemoveButton);r.write("</span>");}};
a._updateHoverStyle=function(){var s=this.$("styleHelper"),o,i=0,h="";s.empty();if(!this._oStyleData||this.$().is(":hidden")){return;}if(this._oStyleData.rtl){s.css("right",-this._oStyleData.positionRight);}else{s.css("left",-this._oStyleData.positionLeft);}for(i;i<this._oStyleData.lines.length;i++){o=this._oStyleData.lines[i];var r=jQuery("<div class='sapMGTLineStyleHelper'><div class='sapMGTLineStyleHelperInner' /></div>");if(this._oStyleData.rtl){r.css("right",o.offset.x+"px");}else{r.css("left",o.offset.x+"px");}r.css({top:o.offset.y+"px",width:o.width+"px",height:o.height});h+=r.outerHTML();}s.html(h);};
a._renderFocusDiv=function(r,c){r.write("<div");r.writeAttribute("id",c.getId()+"-focus");r.addClass("sapMGTFocusDiv");r.writeClasses();r.write(">");r.write("</div>");};
a._getCSSPixelValue=function(o,p){var O=o instanceof jQuery?o:o.$(),m=(O.css(p)||"").match(/([^a-zA-Z\%]*)(.*)/),v=parseFloat(m[1]),u=m[2];return(u==="px")?v:v*16;};
return a;},true);
sap.ui.predefine('sap/m/GenericTileRenderer',["sap/m/library"],function(l){"use strict";var G=l.GenericTileScope;var L=l.LoadState;var a={};
a.render=function(r,c){var t=c._getTooltipText();var A=c._getAriaText();var h=c.getHeaderImage();var H=c.hasListeners("press");var s=c.getState();var S=c.getScope();var b=jQuery.sap.encodeCSS("sapMGTState"+s);var d=jQuery.sap.encodeCSS("sapMGTScope"+S);r.write("<div");r.writeControlData(c);if(t){r.writeAttributeEscaped("title",t);}r.addClass("sapMGT");r.addClass(b);r.addClass(d);if(S!==G.Actions&&c._bShowActionsView){r.addClass("sapMGTScopeActions");}r.addClass(c.getFrameType());if(H){r.writeAttribute("role","button");}else{r.writeAttribute("role","presentation");}r.writeAttributeEscaped("aria-label",A);if(s!==L.Disabled){r.addClass("sapMPointer");r.writeAttribute("tabindex","0");}if(c.getBackgroundImage()){r.write(" style='background-image:url(");r.writeEscaped(c.getBackgroundImage());r.write(");'");r.addClass("sapMGTBackgroundImage");}if(c.getMode()===sap.m.GenericTileMode.HeaderMode){r.addClass("sapMGTHeaderMode");}r.writeClasses();r.write(">");r.write("<div");r.addClass("sapMGTHdrContent");r.addClass(c.getFrameType());if(t){r.writeAttributeEscaped("title",t);}r.writeClasses();r.write(">");if(h){r.renderControl(c._oImage);}this._renderHeader(r,c);if(c.getSubheader()){this._renderSubheader(r,c);}r.write("</div>");r.write("<div");r.addClass("sapMGTContent");r.writeClasses();r.writeAttribute("id",c.getId()+"-content");r.write(">");var T=c.getTileContent();var e=T.length;for(var i=0;i<e;i++){c._checkFooter(T[i],c);r.renderControl(T[i]);}r.write("</div>");if(s!==L.Loaded){this._renderStateOverlay(r,c,t);}if(s!==L.Disabled){this._renderHoverOverlay(r,c);this._renderFocusDiv(r,c);}if(S===G.Actions){this._renderActionsScope(r,c);}r.write("</div>");};
a._renderFocusDiv=function(r,c){r.write("<div");r.addClass("sapMGTFocusDiv");r.writeClasses();r.writeAttribute("id",c.getId()+"-focus");r.write(">");r.write("</div>");};
a._renderStateOverlay=function(r,c,t){var s=c.getState();r.write("<div");r.addClass("sapMGTOverlay");r.writeClasses();r.writeAttribute("id",c.getId()+"-overlay");if(t){r.writeAttributeEscaped("title",t);}r.write(">");switch(s){case L.Loading:c._oBusy.setBusy(s==L.Loading);r.renderControl(c._oBusy);break;case L.Failed:r.write("<div");r.writeAttribute("id",c.getId()+"-failed-ftr");r.addClass("sapMGenericTileFtrFld");r.writeClasses();r.write(">");r.write("<div");r.writeAttribute("id",c.getId()+"-failed-icon");r.addClass("sapMGenericTileFtrFldIcn");r.writeClasses();r.write(">");r.renderControl(c._oWarningIcon);r.write("</div>");if(c.getScope()!==G.Actions&&!c._bShowActionsView){r.write("<div");r.writeAttribute("id",c.getId()+"-failed-text");r.addClass("sapMGenericTileFtrFldTxt");r.writeClasses();r.write(">");r.renderControl(c.getAggregation("_failedMessageText"));r.write("</div>");}r.write("</div>");break;default:}r.write("</div>");};
a._renderActionsScope=function(r,c){if(c.getState()!==L.Disabled){r.renderControl(c._oRemoveButton);r.renderControl(c._oMoreIcon);}};
a._renderHoverOverlay=function(r,c){r.write("<div");if(c.getBackgroundImage()){r.addClass("sapMGTWithImageHoverOverlay");}else{r.addClass("sapMGTWithoutImageHoverOverlay");}r.writeClasses();r.writeAttribute("id",c.getId()+"-hover-overlay");r.write(">");r.write("</div>");};
a._renderHeader=function(r,c){r.write("<div");r.addClass("sapMGTHdrTxt");r.writeClasses();r.writeAttribute("id",c.getId()+"-hdr-text");r.write(">");r.renderControl(c._oTitle);r.write("</div>");};
a._renderSubheader=function(r,c){r.write("<div");r.addClass("sapMGTSubHdrTxt");r.writeClasses();r.writeAttribute("id",c.getId()+"-subHdr-text");r.write(">");r.writeEscaped(c.getSubheader());r.write("</div>");};
return a;},true);
sap.ui.predefine('sap/m/GroupHeaderListItem',['jquery.sap.global','./ListItemBase','./library'],function(q,L,l){"use strict";
var G=L.extend("sap.m.GroupHeaderListItem",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Data",defaultValue:null},count:{type:"string",group:"Data",defaultValue:null},upperCase:{type:"boolean",group:"Appearance",defaultValue:false},titleTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit}}}});
G.prototype.getMode=function(){return sap.m.ListMode.None;};
G.prototype.shouldClearLastValue=function(){return true;};
G.prototype.getTable=function(){var p=this.getParent();if(p instanceof sap.m.Table){return p;}if(p&&p.getMetadata().getName()=="sap.m.Table"){return p;}};
G.prototype.onBeforeRendering=function(){var p=this.getParent();if(p&&sap.m.Table&&p instanceof sap.m.Table){p.getColumns().forEach(function(c){c.clearLastValue();});this.TagName="tr";}};
G.prototype.getAccessibilityType=function(b){var t=this.getTable()?"ROW":"OPTION";return b.getText("LIST_ITEM_GROUP_HEADER")+" "+b.getText("ACC_CTR_TYPE_"+t);};
G.prototype.getContentAnnouncement=function(){return this.getTitle();};
return G;},true);
sap.ui.predefine('sap/m/GroupHeaderListItemRenderer',['jquery.sap.global','./ListItemBaseRenderer','sap/ui/core/Renderer'],function(q,L,R){"use strict";var G=R.extend(L);
G.renderType=function(r,l){var t=l.getTable();t&&r.write('<td class="sapMListTblNavCol">');L.renderType.apply(this,arguments);t&&r.write('</td>');};
G.renderCounter=function(r,l){};
G.renderLIAttributes=function(r,l){r.addClass("sapMGHLI");if(l.getUpperCase()){r.addClass("sapMGHLIUpperCase");}};
G.renderLIContentWrapper=function(r,l){var t=l.getTable();if(t){r.write('<td class="sapMGHLICell"');r.writeAttribute("colspan",t.getColSpan());r.write(">");}L.renderLIContentWrapper.apply(this,arguments);if(t){r.write("</td>");}};
G.renderLIContent=function(r,l){var t=l.getTitleTextDirection();r.write("<span class='sapMGHLITitle'");if(t!=sap.ui.core.TextDirection.Inherit){r.writeAttribute("dir",t.toLowerCase());}r.write(">");r.writeEscaped(l.getTitle());r.write("</span>");var c=l.getCount()||l.getCounter();if(c){r.write("<span class='sapMGHLICounter'>");r.writeEscaped(" ("+c+")");r.write("</span>");}};
G.addLegacyOutlineClass=function(r,l){if(!l.getTable()){L.addLegacyOutlineClass.apply(this,arguments);}};
return G;},true);
sap.ui.predefine('sap/m/GrowingEnablement',['jquery.sap.global','sap/ui/base/Object','sap/ui/core/format/NumberFormat'],function(q,B,N){"use strict";
var G=B.extend("sap.m.GrowingEnablement",{
constructor:function(c){B.apply(this);this._oControl=c;this._oControl.bUseExtendedChangeDetection=true;this._oControl.addDelegate(this);var r=this._oControl.getItems(true).length;this._iRenderedDataItems=r;this._iLimit=r;this._bLoading=false;this._sGroupingPath="";this._bDataRequested=false;this._oContainerDomRef=null;this._iTriggerTimer=0;this._aChunk=[];this._oRM=null;},
destroy:function(){if(this._oTrigger){this._oTrigger.destroy();this._oTrigger=null;}if(this._oScrollDelegate){this._oScrollDelegate.setGrowingList(null);this._oScrollDelegate=null;}if(this._oRM){this._oRM.destroy();this._oRM=null;}this._oControl.$("triggerList").remove();this._oControl.bUseExtendedChangeDetection=false;this._oControl.removeDelegate(this);this._oContainerDomRef=null;this._oControl=null;},
render:function(r){r.write("<div");r.addClass("sapMListUl");r.addClass("sapMGrowingList");r.writeAttribute("id",this._oControl.getId()+"-triggerList");r.addStyle("display","none");r.writeClasses();r.writeStyles();r.write(">");r.renderControl(this._getTrigger());r.write("</div>");},
onAfterRendering:function(){var c=this._oControl;if(c.getGrowingScrollToLoad()){var s=sap.m.getScrollDelegate(c);if(s){this._oScrollDelegate=s;s.setGrowingList(this.onScrollToLoad.bind(this),c.getGrowingDirection());}}else if(this._oScrollDelegate){this._oScrollDelegate.setGrowingList(null);this._oScrollDelegate=null;}this._updateTriggerDelayed(false);},
setTriggerText:function(t){this._oControl.$("triggerText").text(t);},
reset:function(){this._iLimit=0;},
shouldReset:function(c){var C=sap.ui.model.ChangeReason;return c==C.Sort||c==C.Filter||c==C.Context;},
getInfo:function(){return{total:this._oControl.getMaxItemsCount(),actual:this._iRenderedDataItems};},
onScrollToLoad:function(){if(!this._bLoading&&this._oControl.getGrowingDirection()==sap.m.ListGrowingDirection.Upwards){var s=this._oScrollDelegate;this._oScrollPosition={left:s.getScrollLeft(),top:s.getScrollHeight()};}this.requestNewPage();},
requestNewPage:function(){if(!this._oControl||this._bLoading){return;}var b=this._oControl.getBinding("items");if(b&&!b.isLengthFinal()||this._iLimit<this._oControl.getMaxItemsCount()){if(this._oControl.getMetadata().hasProperty("enableBusyIndicator")){this._bParentEnableBusyIndicator=this._oControl.getEnableBusyIndicator();this._oControl.setEnableBusyIndicator(false);}this._iLimit+=this._oControl.getGrowingThreshold();this._updateTriggerDelayed(true);this.updateItems("Growing");}},
_onBeforePageLoaded:function(c){this._bLoading=true;this._oControl.onBeforePageLoaded(this.getInfo(),c);},
_onAfterPageLoaded:function(c){this._bLoading=false;this._updateTriggerDelayed(false);this._oControl.onAfterPageLoaded(this.getInfo(),c);if(this._oControl.setEnableBusyIndicator){this._oControl.setEnableBusyIndicator(this._bParentEnableBusyIndicator);}},
_getTrigger:function(){var t=this._oControl.getId()+"-trigger",T=this._oControl.getGrowingTriggerText();T=T||sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("LOAD_MORE_DATA");this._oControl.addNavSection(t);if(this._oTrigger){this.setTriggerText(T);return this._oTrigger;}this._oTrigger=new sap.m.CustomListItem({id:t,busyIndicatorDelay:0,type:sap.m.ListType.Active,content:new sap.ui.core.HTML({content:'<div class="sapMGrowingListTrigger">'+'<div class="sapMSLITitleDiv sapMGrowingListTriggerText">'+'<span class="sapMSLITitle" id="'+t+'Text">'+q.sap.encodeHTML(T)+'</span>'+'</div>'+'<div class="sapMGrowingListDescription sapMSLIDescription" id="'+t+'Info"></div>'+'</div>'})}).setParent(this._oControl,null,true).attachPress(this.requestNewPage,this).addEventDelegate({onsapenter:function(e){this.requestNewPage();e.preventDefault();},onsapspace:function(e){this.requestNewPage();e.preventDefault();},onAfterRendering:function(e){this._oTrigger.$().attr({"tabindex":0,"role":"button","aria-labelledby":t+"Text"+" "+t+"Info"});}},this);this._oTrigger.getList=function(){};this._oTrigger.TagName="div";return this._oTrigger;},
_getListItemInfo:function(){return("[ "+this._iRenderedDataItems+" / "+N.getFloatInstance().format(this._oControl.getMaxItemsCount())+" ]");},
_getGroupingPath:function(b){var s=b.aSorters||[];var S=s[0]||{};return(S.fnGroup)?S.sPath||"":"";},
_getDomIndex:function(i){if(typeof i!="number"){return i;}if(this._oControl.hasPopin&&this._oControl.hasPopin()){return(i*2);}return i;},
_getHasScrollbars:function(){if(!this._oScrollDelegate){return false;}if(this._iRenderedDataItems>=40){return true;}return this._oScrollDelegate.getMaxScrollTop()>this._oControl.$("triggerList").outerHeight();},
destroyListItems:function(s){this._oControl.destroyItems(s);this._iRenderedDataItems=0;this._aChunk=[];},
addListItem:function(c,b,s){var C=this._oControl,o=b.binding,i=this.createListItem(c,b);if(o.isGrouped()){var I=C.getItems(true),l=I[I.length-1],m=b.model,g=o.getGroup(i.getBindingContext(m));if(l&&l.isGroupHeader()){C.removeAggregation("items",l,true);this._fnAppendGroupItem=this.appendGroupItem.bind(this,g,l,s);l=I[I.length-1];}if(!l||g.key!==o.getGroup(l.getBindingContext(m)).key){var a=(b.groupHeaderFactory)?b.groupHeaderFactory(g):null;if(C.getGrowingDirection()==sap.m.ListGrowingDirection.Upwards){this.applyPendingGroupItem();this._fnAppendGroupItem=this.appendGroupItem.bind(this,g,a,s);}else{this.appendGroupItem(g,a,s);}}}C.addAggregation("items",i,s);if(s){this._aChunk.push(i);}},
applyPendingGroupItem:function(){if(this._fnAppendGroupItem){this._fnAppendGroupItem();this._fnAppendGroupItem=undefined;}},
appendGroupItem:function(g,o,s){o=this._oControl.addItemGroup(g,o,s);if(s){this._aChunk.push(o);}},
createListItem:function(c,b){this._iRenderedDataItems++;var i=b.factory(sap.ui.base.ManagedObjectMetadata.uid("clone"),c);return i.setBindingContext(c,b.model);},
updateItemsBindingContext:function(C,m){if(!C.length){return;}var I=this._oControl.getItems(true);for(var i=0,c=0,o;i<I.length;i++){o=I[i];if(!o.isGroupHeader()){o.setBindingContext(C[c++],m);}}},
applyChunk:function(I,d){this.applyPendingGroupItem();var l=this._aChunk.length;if(!l){return;}if(this._oControl.getGrowingDirection()==sap.m.ListGrowingDirection.Upwards){this._aChunk.reverse();if(I===true){I=0;}else if(typeof I=="number"){I=this._iRenderedDataItems-l-I;}}d=d||this._oContainerDomRef;this._oRM=this._oRM||sap.ui.getCore().createRenderManager();for(var i=0;i<l;i++){this._oRM.renderControl(this._aChunk[i]);}this._oRM.flush(d,false,this._getDomIndex(I));this._aChunk=[];},
addListItems:function(c,b,s){for(var i=0;i<c.length;i++){this.addListItem(c[i],b,s);}},
rebuildListItems:function(c,b,s){this.destroyListItems(s);this.addListItems(c,b,s);if(s){var h=this._oContainerDomRef.contains(document.activeElement);this.applyChunk(false);h&&this._oControl.focus();}else{this.applyPendingGroupItem();}},
insertListItem:function(c,b,i){var I=this.createListItem(c,b);this._oControl.insertAggregation("items",I,i,true);this._aChunk.push(I);},
deleteListItem:function(i){this._oControl.getItems(true)[i].destroy(true);this._iRenderedDataItems--;},
refreshItems:function(c){if(!this._bDataRequested){this._bDataRequested=true;this._onBeforePageLoaded(c);}if(!this._iLimit||this.shouldReset(c)||!this._oControl.getItems(true).length){this._iLimit=this._oControl.getGrowingThreshold();}this._oControl.getBinding("items").getContexts(0,this._iLimit);},
updateItems:function(c){var C=this._oControl,b=C.getBinding("items"),o=C.getBindingInfo("items"),I=C.getItems(true);if(!this._iLimit||this.shouldReset(c)||!I.length){this._iLimit=C.getGrowingThreshold();}if(this._bDataRequested){this._bDataRequested=false;}else{this._onBeforePageLoaded(c);}var a=b.getContexts(0,this._iLimit)||[];if(a.dataRequested){this._bDataRequested=true;if(a.diff&&!a.diff.length){return;}}this._oContainerDomRef=C.getItemsContainerDomRef();var d=a.diff,f=false,v;if(!a.length){this.destroyListItems();}else if(!this._oContainerDomRef){this.rebuildListItems(a,o);}else if(!d||!I.length&&d.length){this.rebuildListItems(a,o,true);}else if(b.isGrouped()||C.checkGrowingFromScratch()){if(this._sGroupingPath!=this._getGroupingPath(b)){f=true;}else{for(var i=0;i<d.length;i++){var D=d[i],e=a[D.index];if(D.type=="delete"){f=true;break;}else if(D.index!=this._iRenderedDataItems){f=true;break;}else{this.addListItem(e,o,true);v=true;}}}}else{if(this._sGroupingPath){C.removeGroupHeaders(true);}v=-1;var l=-1;for(var i=0;i<d.length;i++){var D=d[i],g=D.index,e=a[g];if(D.type=="delete"){if(v!=-1){this.applyChunk(v);l=-1;v=-1;}this.deleteListItem(g);}else{if(v==-1){v=g;}else if(l>-1&&g!=l+1){this.applyChunk(v);v=g;}this.insertListItem(e,o,g);l=g;}}}if(f){this.rebuildListItems(a,o,true);}else if(this._oContainerDomRef&&d&&d.length){this.updateItemsBindingContext(a,o.model);this.applyChunk(v);}this._oContainerDomRef=null;this._sGroupingPath=this._getGroupingPath(b);if(!this._bDataRequested){this._onAfterPageLoaded(c);}},
_updateTriggerDelayed:function(l){if(this._oControl.getGrowingScrollToLoad()){this._iTriggerTimer&&window.cancelAnimationFrame(this._iTriggerTimer);this._iTriggerTimer=window.requestAnimationFrame(this._updateTrigger.bind(this,l));}else{this._updateTrigger(l);}},
_updateTrigger:function(l){var t=this._oTrigger,c=this._oControl;if(!t||!c||!c.shouldRenderItems()){return;}var b=c.getBinding("items");if(!b){return;}t.setBusy(l);t.$().toggleClass("sapMGrowingListBusyIndicatorVisible",l);if(l){t.setActive(false);c.$("triggerList").css("display","");}else{var i=c.getItems(true),I=i.length,a=b.getLength()||0,L=b.isLengthFinal(),h=c.getGrowingScrollToLoad();if(!I||!this._iLimit||(L&&this._iLimit>=a)||(h&&this._getHasScrollbars())){c.$("triggerList").css("display","none");if(document.activeElement===t.getDomRef()){c.$().focus();}}else{if(L){c.$("triggerInfo").css("display","block").text(this._getListItemInfo());}t.$().removeClass("sapMGrowingListBusyIndicatorVisible");c.$("triggerList").css("display","");}if(h&&this._oScrollPosition===undefined&&c.getGrowingDirection()==sap.m.ListGrowingDirection.Upwards){this._oScrollPosition={left:0,top:0};}if(I>0&&this._oScrollPosition){var s=this._oScrollDelegate,S=this._oScrollPosition;s.scrollTo(S.left,s.getScrollHeight()-S.top);this._oScrollPosition=null;}}}
});
return G;},true);
sap.ui.predefine('sap/m/GrowingList',['jquery.sap.global','./List','./library'],function(q,L,l){"use strict";
var G=L.extend("sap.m.GrowingList",{metadata:{deprecated:true,library:"sap.m",properties:{threshold:{type:"int",group:"Misc",defaultValue:20},triggerText:{type:"string",group:"Appearance",defaultValue:null},scrollToLoad:{type:"boolean",group:"Behavior",defaultValue:false}}}});
G.prototype._isIncompatible=function(){return sap.ui.getCore().getConfiguration().getCompatibilityVersion("sapMGrowingList").compareTo("1.16")>=0;};
G.prototype.init=function(){sap.m.ListBase.prototype.init.call(this);if(!this._isIncompatible()){this.setGrowing();}};
G.prototype.setGrowing=function(){return sap.m.ListBase.prototype.setGrowing.call(this,true);};
!(function(g,o){["Threshold","TriggerText","ScrollToLoad"].forEach(function(p){g["set"+p]=o["setGrowing"+p];g["get"+p]=o["getGrowing"+p];});}(G.prototype,sap.m.ListBase.prototype));return G;},true);
sap.ui.predefine('sap/m/GrowingListRenderer',['jquery.sap.global','./ListRenderer','sap/ui/core/Renderer'],function(q,L,R){"use strict";var G=R.extend(L);
G.render=function(r,c){if(c._isIncompatible()){q.sap.log.warning("Does not render sap.m.GrowingList#"+c.getId()+" when compatibility version is 1.16 or higher. Instead use sap.m.List/Table control with growing feature!");}else{L.render.call(this,r,c);}};
return G;},true);
sap.ui.predefine('sap/m/HBox',['jquery.sap.global','./FlexBox','./library'],function(q,F,l){"use strict";
var H=F.extend("sap.m.HBox",{metadata:{library:"sap.m"}});
return H;},true);
sap.ui.predefine('sap/m/HBoxRenderer',['jquery.sap.global','./FlexBoxRenderer'],function(q,F){"use strict";var H={};
H.render=function(r,c){F.render.apply(this,[r,c]);};
return H;},true);
sap.ui.predefine('sap/m/HeaderContainer',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/Device','sap/ui/core/delegate/ScrollEnablement','sap/ui/core/delegate/ItemNavigation','sap/ui/core/library','sap/ui/base/ManagedObject','sap/ui/core/Icon'],function(q,l,C,D,S,I,c,M,a){"use strict";var O=c.Orientation;
var H=C.extend("sap.m.HeaderContainerItemContainer",{
metadata:{defaultAggregation:"item",aggregations:{item:{type:"sap.ui.core.Control",multiple:false}}},
renderer:function(r,o){r.write("<div");r.writeControlData(o);r.addClass("sapMHdrCntrItemCntr");r.addClass("sapMHrdrCntrInner");r.writeClasses();r.write(">");r.renderControl(o.getAggregation("item"));r.write("</div>");}
});
var b=C.extend("sap.m.HeaderContainer",{metadata:{interfaces:["sap.m.ObjectHeaderContainer"],library:"sap.m",properties:{scrollStep:{type:"int",defaultValue:300,group:"Behavior"},scrollTime:{type:"int",defaultValue:500,group:"Behavior"},showDividers:{type:"boolean",defaultValue:true,group:"Appearance"},orientation:{type:"sap.ui.core.Orientation",defaultValue:O.Horizontal,group:"Appearance"},backgroundDesign:{type:"sap.m.BackgroundDesign",defaultValue:l.BackgroundDesign.Transparent,group:"Appearance"},width:{type:"sap.ui.core.CSSSize",group:"Appearance"},height:{type:"sap.ui.core.CSSSize",group:"Appearance"}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true},_scrollContainer:{type:"sap.m.ScrollContainer",multiple:false,visibility:"hidden"},_prevButton:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_nextButton:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}}}});
b.prototype.init=function(){this._bRtl=sap.ui.getCore().getConfiguration().getRTL();this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._oScrollCntr=new l.ScrollContainer(this.getId()+"-scrl-cntnr",{width:"100%",height:"100%",horizontal:!D.system.desktop});this.setAggregation("_scrollContainer",this._oScrollCntr,true);if(D.system.desktop){this._oArrowPrev=new l.Button({id:this.getId()+"-scrl-prev-button",type:l.ButtonType.Transparent,tooltip:this._oRb.getText("HEADERCONTAINER_BUTTON_PREV_SECTION"),press:function(e){e.cancelBubble();this._scroll(-this.getScrollStep(),this.getScrollTime());}.bind(this)}).addStyleClass("sapMHdrCntrBtn").addStyleClass("sapMHdrCntrLeft");this._oArrowPrev._bExcludeFromTabChain=true;this.setAggregation("_prevButton",this._oArrowPrev,true);this._oArrowNext=new l.Button({id:this.getId()+"-scrl-next-button",type:l.ButtonType.Transparent,tooltip:this._oRb.getText("HEADERCONTAINER_BUTTON_NEXT_SECTION"),press:function(e){e.cancelBubble();this._scroll(this.getScrollStep(),this.getScrollTime());}.bind(this)}).addStyleClass("sapMHdrCntrBtn").addStyleClass("sapMHdrCntrRight");this._oArrowNext._bExcludeFromTabChain=true;this.setAggregation("_nextButton",this._oArrowNext,true);}else if(D.system.phone||D.system.tablet){this._oArrowPrev=new a({id:this.getId()+"-scrl-prev-button"}).addStyleClass("sapMHdrCntrBtn").addStyleClass("sapMHdrCntrLeft");this.setAggregation("_prevButton",this._oArrowPrev,true);this._oArrowNext=new a({id:this.getId()+"-scrl-next-button"}).addStyleClass("sapMHdrCntrBtn").addStyleClass("sapMHdrCntrRight");this.setAggregation("_nextButton",this._oArrowNext,true);}this._oScrollCntr.addDelegate({onAfterRendering:function(){if(D.system.desktop){var f=this._oScrollCntr.getDomRef("scroll");var F=this._oScrollCntr.$("scroll");var d=F.find(".sapMHrdrCntrInner").attr("tabindex","0");if(!this._oItemNavigation){this._oItemNavigation=new I();this.addDelegate(this._oItemNavigation);this._oItemNavigation.attachEvent(I.Events.BorderReached,this._handleBorderReached,this);this._oItemNavigation.attachEvent(I.Events.AfterFocus,this._handleBorderReached,this);this._oItemNavigation.attachEvent(I.Events.BeforeFocus,this._handleBeforeFocus,this);if(D.browser.msie||D.browser.edge){this._oItemNavigation.attachEvent(I.Events.FocusAgain,this._handleFocusAgain,this);}}this._oItemNavigation.setRootDomRef(f);this._oItemNavigation.setItemDomRefs(d);this._oItemNavigation.setTabIndex0();this._oItemNavigation.setCycling(false);}}.bind(this)});sap.ui.getCore().attachIntervalTimer(this._checkOverflow,this);};
b.prototype.onBeforeRendering=function(){if(!this.getHeight()){q.sap.log.warning("No height provided",this);}if(!this.getWidth()){q.sap.log.warning("No width provided",this);}if(D.system.desktop){this._oArrowPrev.setIcon(this.getOrientation()===O.Horizontal?"sap-icon://slim-arrow-left":"sap-icon://slim-arrow-up");this._oArrowNext.setIcon(this.getOrientation()===O.Horizontal?"sap-icon://slim-arrow-right":"sap-icon://slim-arrow-down");}else if(D.system.phone||D.system.tablet){this._oArrowPrev.setSrc(this.getOrientation()===O.Horizontal?"sap-icon://slim-arrow-left":"sap-icon://slim-arrow-up");this._oArrowNext.setSrc(this.getOrientation()===O.Horizontal?"sap-icon://slim-arrow-right":"sap-icon://slim-arrow-down");}};
b.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();this._oItemNavigation=null;}sap.ui.getCore().detachIntervalTimer(this._checkOverflow,this);};
b.prototype.onsaptabnext=function(e){var f=this.$().find(":focusable");var t=f.index(e.target);var n=f.eq(t+1).get(0);var F=this._getParentCell(e.target);var T;if(n){T=this._getParentCell(n);}if(F&&T&&F.id!==T.id||n&&n.id===this.getId()+"-after"){var L=f.last().get(0);if(L){this._bIgnoreFocusIn=true;L.focus();}}};
b.prototype.onsaptabprevious=function(e){this.$().find(".sapMHdrCntrItemCntr").css("border-color","");var f=this.$().find(":focusable");var t=f.index(e.target);var p=f.eq(t-1).get(0);var F=this._getParentCell(e.target);var T;if(p){T=this._getParentCell(p);}if(!T||F&&F.id!==T.id){var s=this.$().attr("tabindex");this.$().attr("tabindex","0");this.$().focus();if(!s){this.$().removeAttr("tabindex");}else{this.$().attr("tabindex",s);}}};
b.prototype.setOrientation=function(v){this.setProperty("orientation",v);if(v===O.Horizontal&&!D.system.desktop){this._oScrollCntr.setHorizontal(true);this._oScrollCntr.setVertical(false);}else if(!D.system.desktop){this._oScrollCntr.setHorizontal(false);this._oScrollCntr.setVertical(true);}return this;};
b.prototype.validateAggregation=function(A,o,m){return this._callMethodInManagedObject("validateAggregation",A,o,m);};
b.prototype.getAggregation=function(A,o,s){return this._callMethodInManagedObject("getAggregation",A,o,s);};
b.prototype.setAggregation=function(A,o,s){return this._callMethodInManagedObject("setAggregation",A,o,s);};
b.prototype.indexOfAggregation=function(A,o){return this._callMethodInManagedObject("indexOfAggregation",A,o);};
b.prototype.insertAggregation=function(A,o,i,s){return this._callMethodInManagedObject("insertAggregation",A,o,i,s);};
b.prototype.addAggregation=function(A,o,s){return this._callMethodInManagedObject("addAggregation",A,o,s);};
b.prototype.removeAggregation=function(A,o,s){return this._callMethodInManagedObject("removeAggregation",A,o,s);};
b.prototype.removeAllAggregation=function(A,s){return this._callMethodInManagedObject("removeAllAggregation",A,s);};
b.prototype.destroyAggregation=function(A,s){return this._callMethodInManagedObject("destroyAggregation",A,s);};
b.prototype._setScrollInProcess=function(v){this.bScrollInProcess=v;};
b.prototype._scroll=function(d,i){this._setScrollInProcess(true);q.sap.delayedCall(i+300,this,this._setScrollInProcess,[false]);if(this.getOrientation()===O.Horizontal){this._hScroll(d,i);}else{this._vScroll(d,i);}};
b.prototype._vScroll=function(d,e){var o=this._oScrollCntr.getDomRef(),s=o.scrollTop,i=o.scrollHeight,f=s+d,g=o.clientHeight,p=parseFloat(this.$("scroll-area").css("padding-top")),r;if(f<=0){r=this._calculateRemainingScrolling(d,e,s);this.$("scroll-area").css("transition","padding "+r+"s");this.$().removeClass("sapMHrdrTopPadding");}else if(f+g+p>=i){r=this._calculateRemainingScrolling(d,e,i-g-s);this.$("scroll-area").css("transition","padding "+r+"s");if(g+d>i&&g!==i){this.$().removeClass("sapMHrdrBottomPadding");this.$().addClass("sapMHrdrTopPadding");}else{this.$().removeClass("sapMHrdrBottomPadding");}}else{this.$("scroll-area").css("transition","padding "+e/1000+"s");}this._oScrollCntr.scrollTo(0,f,e);};
b.prototype._hScroll=function(d,e){var o=this._oScrollCntr.getDomRef();var s,i,f,g,p,r;if(!this._bRtl){i=o.scrollLeft;g=o.scrollWidth;f=o.clientWidth+(D.browser.msie?1:0);s=i+d;p=parseFloat(this.$("scroll-area").css("padding-left"));if(s<=0){r=this._calculateRemainingScrolling(d,e,i);this.$("scroll-area").css("transition","padding "+r+"s");this.$().removeClass("sapMHrdrLeftPadding");}else if(s+o.clientWidth+p>=g){r=this._calculateRemainingScrolling(d,e,g-f-i);this.$("scroll-area").css("transition","padding "+r+"s");if(f+d>g&&f!==g){this.$().removeClass("sapMHrdrRightPadding");this.$().addClass("sapMHrdrLeftPadding");}else{this.$().removeClass("sapMHrdrRightPadding");}}else{this.$("scroll-area").css("transition","padding "+e/1000+"s");}this._oScrollCntr.scrollTo(s,0,e);}else{s=q(o).scrollRightRTL()+d;this._oScrollCntr.scrollTo((s>0)?s:0,0,e);}};
b.prototype._calculateRemainingScrolling=function(d,e,f){return Math.abs(f*e/(1000*d));};
b.prototype._checkOverflow=function(){if(this.getOrientation()===O.Horizontal){this._checkHOverflow();}else{this._checkVOverflow();}};
b.prototype._checkVOverflow=function(){var B=this._oScrollCntr.getDomRef(),o,$;if(B){var s=Math.ceil(B.scrollTop);var d=false;var e=false;var r=B.scrollHeight;var f=B.clientHeight;if(Math.abs(r-f)===1){r=f;}if(s>0){d=true;}if((r>f)&&(s+f<r)){e=true;}$=this.$("prev-button-container");o=$.is(":visible");if(o&&!d){$.hide();this.$().removeClass("sapMHrdrTopPadding");}if(!o&&d){$.show();this.$().addClass("sapMHrdrTopPadding");}$=this.$("next-button-container");var g=$.is(":visible");if(g&&!e){$.hide();this.$().removeClass("sapMHrdrBottomPadding");}if(!g&&e){$.show();this.$().addClass("sapMHrdrBottomPadding");}}};
b.prototype._checkHOverflow=function(){var B=this._oScrollCntr.getDomRef(),$;if(B){var s=Math.ceil(B.scrollLeft);var d=false;var e=false;var r=B.scrollWidth;var f=B.clientWidth;if(Math.abs(r-f)===1){r=f;}if(this._bRtl){var i=q(B).scrollLeftRTL();if(i>((D.browser.msie||D.browser.edge)?1:0)){e=true;}}else if(s>1){d=true;}if(r-5>f){if(this._bRtl){if(q(B).scrollRightRTL()>1){d=true;}}else if(s+f<r){e=true;}}$=this.$("prev-button-container");var o=$.is(":visible");if(o&&!d){$.hide();this.$().removeClass("sapMHrdrLeftPadding");}if(!o&&d){$.show();this.$().addClass("sapMHrdrLeftPadding");}$=this.$("next-button-container");var g=$.is(":visible");if(g&&!e){$.hide();this.$().removeClass("sapMHrdrRightPadding");}if(!g&&e){$.show();this.$().addClass("sapMHrdrRightPadding");}}};
b.prototype._handleBorderReached=function(e){if(D.browser.msie&&this.bScrollInProcess){return;}var i=e.getParameter("index");if(i===0){this._scroll(-this.getScrollStep(),this.getScrollTime());}else if(i===this.getContent().length-1){this._scroll(this.getScrollStep(),this.getScrollTime());}};
b.prototype._handleFocusAgain=function(e){e.getParameter("event").preventDefault();};
b.prototype._handleBeforeFocus=function(e){var o=e.getParameter("event");if(q(o.target).hasClass("sapMHdrCntrItemCntr")||q(o.target).hasClass("sapMScrollContScroll")||q.sap.PseudoEvents.sapprevious.fnCheck(o)||q.sap.PseudoEvents.sapnext.fnCheck(o)){this.$().find(".sapMHdrCntrItemCntr").css("border-color","");}else{this.$().find(".sapMHdrCntrItemCntr").css("border-color","transparent");}};
b.prototype._unWrapHeaderContainerItemContainer=function(w){if(w instanceof H){w=w.getItem();}else if(q.isArray(w)){for(var i=0;i<w.length;i++){if(w[i]instanceof H){w[i]=w[i].getItem();}}}return w;};
b._AGGREGATION_FUNCTIONS=["validateAggregation","validateAggregation","getAggregation","setAggregation","indexOfAggregation","removeAggregation"];b._AGGREGATION_FUNCTIONS_FOR_INSERT=["insertAggregation","addAggregation"];
b.prototype._callMethodInManagedObject=function(f,A){var d=Array.prototype.slice.call(arguments);if(A==="content"){var o=d[2];d[1]="content";if(o instanceof C){if(q.inArray(f,b._AGGREGATION_FUNCTIONS)>-1&&o.getParent()instanceof H){d[2]=o.getParent();}else if(q.inArray(f,b._AGGREGATION_FUNCTIONS_FOR_INSERT)>-1){d[2]=new H({item:o});}}return this._unWrapHeaderContainerItemContainer(this._oScrollCntr[f].apply(this._oScrollCntr,d.slice(1)));}else{return M.prototype[f].apply(this,d.slice(1));}};
b.prototype._getParentCell=function(d){return q(d).parents(".sapMHrdrCntrInner").andSelf(".sapMHrdrCntrInner").get(0);};
b.prototype.onfocusin=function(e){if(this._bIgnoreFocusIn){this._bIgnoreFocusIn=false;return;}if(e.target.id===this.getId()+"-after"){this._restoreLastFocused();}};
b.prototype._restoreLastFocused=function(){if(!this._oItemNavigation){return;}var n=this._oItemNavigation.getItemDomRefs();var L=this._oItemNavigation.getFocusedIndex();var $=q(n[L]);var r=$.control(0)||{};var t=r.getTabbables?r.getTabbables():$.find(":sapTabbable");t.eq(-1).add($).eq(-1).focus();};
return b;});
sap.ui.predefine('sap/m/HeaderContainerRenderer',['jquery.sap.global','sap/ui/core/library'],function(q,c){"use strict";var O=c.Orientation;var H={};
H.render=function(r,C){var t=C.getTooltip_AsString();var o=C.getOrientation();if(o){o=q.sap.encodeCSS(o);}var b=q.sap.encodeCSS("sapMHdrCntrBG"+C.getBackgroundDesign());r.write("<div");r.writeControlData(C);if(t&&(typeof t==="string")){r.writeAttributeEscaped("title",t);}r.addClass("sapMHdrCntr");r.addClass(o);if(C.getShowDividers()){r.addClass("sapMHrdrCntrDvdrs");}r.writeClasses();if(C.getHeight()){r.addStyle("height",C.getHeight());}else{r.addStyle("height",(C.getOrientation()===O.Horizontal)?"auto":"100%");}if(C.getWidth()){r.addStyle("width",C.getWidth());}else{r.addStyle("width",(C.getOrientation()===O.Horizontal)?"100%":"auto");}r.writeStyles();var d="";var a=C.getContent();for(var i=0;a&&i<a.length;i++){d+=a[i].getId()+" ";}r.writeAttribute("aria-labelledby",d);r.write(">");r.write("<div");r.writeAttributeEscaped("id",C.getId()+"-scroll-area");r.addClass("sapMHdrCntrCntr");r.addClass(o);r.addClass(b);r.writeClasses();r.write(">");r.renderControl(C.getAggregation("_scrollContainer"));r.write("</div>");var B=C.getAggregation("_prevButton");if(B){r.write("<div");r.writeAttributeEscaped("id",C.getId()+"-prev-button-container");r.addClass("sapMHdrCntrBtnCntr");r.addClass("sapMHdrCntrLeft");r.addClass(o);r.writeClasses();r.write(">");r.renderControl(B);r.write("</div>");}B=C.getAggregation("_nextButton");if(B){r.write("<div");r.writeAttributeEscaped("id",C.getId()+"-next-button-container");r.addClass("sapMHdrCntrBtnCntr");r.addClass("sapMHdrCntrRight");r.addClass(o);r.writeClasses();r.write(">");r.renderControl(B);r.write("</div>");}r.write("<div");r.writeAttribute("id",C.getId()+"-after");r.writeAttribute("tabindex","0");r.write("/>");r.write("</div>");};
return H;},true);
sap.ui.predefine('sap/m/IconTabBar',['jquery.sap.global','./library','sap/ui/core/Control'],function(q,l,C){"use strict";
var I=C.extend("sap.m.IconTabBar",{metadata:{interfaces:["sap.m.ObjectHeaderContainer"],library:"sap.m",properties:{showSelection:{type:"boolean",group:"Misc",defaultValue:true,deprecated:true},expandable:{type:"boolean",group:"Misc",defaultValue:true},expanded:{type:"boolean",group:"Misc",defaultValue:true},selectedKey:{type:"string",group:"Data",defaultValue:null},upperCase:{type:"boolean",group:"Appearance",defaultValue:false},stretchContentHeight:{type:"boolean",group:"Appearance",defaultValue:false},applyContentPadding:{type:"boolean",group:"Appearance",defaultValue:true},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:sap.m.BackgroundDesign.Solid},headerMode:{type:"sap.m.IconTabHeaderMode",group:"Appearance",defaultValue:sap.m.IconTabHeaderMode.Standard},showOverflowSelectList:{type:"boolean",group:"Appearance",defaultValue:false},headerBackgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:sap.m.BackgroundDesign.Solid},enableTabReordering:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{items:{type:"sap.m.IconTab",multiple:true,singularName:"item"},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},_header:{type:"sap.m.IconTabHeader",multiple:false,visibility:"hidden"}},events:{select:{parameters:{item:{type:"sap.m.IconTabFilter"},key:{type:"string"},selectedItem:{type:"sap.m.IconTabFilter"},selectedKey:{type:"string"}}},expand:{parameters:{expand:{type:"boolean"},collapse:{type:"boolean"}}}}}});
I.prototype.clone=function(){var c=C.prototype.clone.apply(this,arguments);var i=this._getIconTabHeader();c.setAggregation("_header",i.clone(),true);return c;};
I.prototype.setExpanded=function(e){this.setProperty("expanded",e,true);if(this.$().length){this._toggleExpandCollapse(e);}return this;};
I.prototype.setExpandable=function(e){this.setProperty("expandable",e,true);return this;};
I.prototype.setHeaderMode=function(m){this.setProperty("headerMode",m,true);this._getIconTabHeader().setMode(m);return this;};
I.prototype.setHeaderBackgroundDesign=function(h){this.setProperty("headerBackgroundDesign",h,true);this._getIconTabHeader().setBackgroundDesign(h);return this;};
I.prototype.setShowOverflowSelectList=function(v){this.setProperty("showOverflowSelectList",v,true);this._getIconTabHeader().setShowOverflowSelectList(v);return this;};
I.prototype.setEnableTabReordering=function(v){this.setProperty("enableTabReordering",v,true);this._getIconTabHeader().setEnableTabReordering(v);return this;};
I.prototype._rerenderContent=function(c){var $=this.$("content");if(c&&($.length>0)){var r=sap.ui.getCore().createRenderManager();for(var i=0;i<c.length;i++){r.renderControl(c[i]);}r.flush($[0]);r.destroy();}};
I.prototype._toggleExpandCollapse=function(e){var $=this.$("content");var s=this._getIconTabHeader().oSelectedItem;if(e===undefined){e=!this.getExpanded();}if(s){s.$().toggleClass("sapMITBSelected",e);s.$().attr({'aria-expanded':e});if(e){s.$().attr({'aria-selected':e});}else{s.$().removeAttr('aria-selected');}}this._iAnimationCounter=(this._iAnimationCounter===undefined?1:++this._iAnimationCounter);if(e){if(s){if(this.$("content").children().length===0){var S=s.getContent();if(S.length>0){this._rerenderContent(S);}else{this._rerenderContent(this.getContent());}}$.stop(true,true).slideDown('400',q.proxy(this.onTransitionEnded,this,e));this.$("containerContent").toggleClass("sapMITBContentClosed",!e);}}else{this.$("contentArrow").hide();$.stop(true,true).slideUp('400',q.proxy(this.onTransitionEnded,this,e));}if(!e||s){this.setProperty("expanded",e,true);}this.fireExpand({expand:e,collapse:!e});return this;};
I.prototype.onTransitionEnded=function(e){var $=this.$("content"),a=this.$("containerContent"),b=this.$("contentArrow");if(this._iAnimationCounter===1){a.toggleClass("sapMITBContentClosed",!e);if(e){b.show();$.css("display","block");}else{b.hide();$.css("display","none");}}this._iAnimationCounter=(this._iAnimationCounter>0?--this._iAnimationCounter:0);return this;};
I.prototype._getIconTabHeader=function(){var c=this.getAggregation("_header");if(!c){c=new sap.m.IconTabHeader(this.getId()+"--header",{});this.setAggregation("_header",c,true);}return c;};
I.prototype.setShowSelection=function(v){this._getIconTabHeader().setShowSelection(v);return this;};
I.prototype.getShowSelection=function(){return this._getIconTabHeader().getShowSelection();};
I.prototype.setSelectedKey=function(v){this._getIconTabHeader().setSelectedKey(v);return this;};
I.prototype.getSelectedKey=function(){return this._getIconTabHeader().getSelectedKey();};
I.prototype.setSelectedItem=function(i,a){return this._getIconTabHeader().setSelectedItem(i,a);};
I.prototype._callMethodInManagedObject=function(f,a){var A=Array.prototype.slice.call(arguments),h;if(a==="items"){h=this._getIconTabHeader();return h[f].apply(h,A.slice(1));}else{return sap.ui.base.ManagedObject.prototype[f].apply(this,A.slice(1));}};
I.prototype.bindAggregation=function(){var a=Array.prototype.slice.call(arguments);this._callMethodInManagedObject.apply(this,["bindAggregation"].concat(a));return this;};
I.prototype.validateAggregation=function(a,o,m){return this._callMethodInManagedObject("validateAggregation",a,o,m);};
I.prototype.setAggregation=function(a,o,s){this._callMethodInManagedObject("setAggregation",a,o,s);return this;};
I.prototype.getAggregation=function(a,d){return this._callMethodInManagedObject("getAggregation",a,d);};
I.prototype.indexOfAggregation=function(a,o){return this._callMethodInManagedObject("indexOfAggregation",a,o);};
I.prototype.insertAggregation=function(a,o,i,s){this._callMethodInManagedObject("insertAggregation",a,o,i,s);return this;};
I.prototype.addAggregation=function(a,o,s){this._callMethodInManagedObject("addAggregation",a,o,s);return this;};
I.prototype.removeAggregation=function(a,o,s){return this._callMethodInManagedObject("removeAggregation",a,o,s);};
I.prototype.removeAllAggregation=function(a,s){return this._callMethodInManagedObject("removeAllAggregation",a,s);};
I.prototype.destroyAggregation=function(a,s){this._callMethodInManagedObject("destroyAggregation",a,s);return this;};
I.prototype.getBinding=function(a){return this._callMethodInManagedObject("getBinding",a);};
I.prototype.getBindingInfo=function(a){return this._callMethodInManagedObject("getBindingInfo",a);};
I.prototype.getBindingPath=function(a){return this._callMethodInManagedObject("getBindingPath",a);};
return I;},true);
sap.ui.predefine('sap/m/IconTabBarRenderer',['jquery.sap.global','sap/ui/core/IconPool'],function(q,I){"use strict";var a={};a._aAllIconColors=['sapMITBFilterCritical','sapMITBFilterPositive','sapMITBFilterNegative','sapMITBFilterDefault'];
a.render=function(r,c){var C=c.getContent(),h=c._getIconTabHeader();r.write("<div ");r.writeControlData(c);r.addClass("sapMITB");if(c.getStretchContentHeight()){r.addClass("sapMITBStretch");}if(!c.getApplyContentPadding()){r.addClass("sapMITBNoContentPadding");}r.addClass("sapMITBBackgroundDesign"+c.getBackgroundDesign());r.writeClasses();r.write(">");if(!c._bHideHeader){r.renderControl(h);}r.write("<div id='"+c.getId()+"-containerContent' ");r.addClass("sapMITBContainerContent");if(!c.getExpanded()){r.addClass("sapMITBContentClosed");}r.writeClasses();r.write(">");r.write("<div id='"+c.getId()+"-content' class='sapMITBContent' role='tabpanel' ");if(!c.getExpanded()){r.write("style='display: none'");}r.write(">");if(c.getExpanded()){if(h.oSelectedItem&&h.oSelectedItem.getContent()){var o=h.oSelectedItem.getContent();if(o.length>0){C=o;}}if(C.length>0){for(var i=0;i<C.length;i++){r.renderControl(C[i]);}}}r.write("</div>");r.write("</div>");r.write("</div>");};
return a;},true);
sap.ui.predefine('sap/m/IconTabBarSelectList',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/delegate/ItemNavigation'],function(q,l,C,I){"use strict";
var a=C.extend("sap.m.IconTabBarSelectList",{metadata:{library:"sap.m",aggregations:{items:{type:"sap.m.IconTabFilter",multiple:true,singularName:"item"}},events:{selectionChange:{parameters:{selectedItem:{type:"sap.m.IconTabFilter"}}}}}});
a.prototype.init=function(){this._itemNavigation=new I();this._itemNavigation.setCycling(false);this.addEventDelegate(this._itemNavigation);this._itemNavigation.setPageSize(10);};
a.prototype.exit=function(){if(this._itemNavigation){this._itemNavigation.destroy();this._itemNavigation=null;}};
a.prototype.onAfterRendering=function(){var b,c=this.getItems(),d=[];for(var i=0;i<c.length;i++){b=c[i];d.push(b.getDomRef());}this._itemNavigation.setRootDomRef(this.getDomRef());this._itemNavigation.setItemDomRefs(d);};
a.prototype.getVisibleItems=function(){var b=this.getItems(),v=[],c;for(var i=0;i<b.length;i++){c=b[i];if(c.getVisible()){v.push(c);}}return v;};
a.prototype.setSelectedItem=function(i){if(this._selectedItem){this._deselectItem(this._selectedItem);}if(i){this._selectItem(i);}this._selectedItem=i;};
a.prototype.getSelectedItem=function(){return this._selectedItem;};
a.prototype._deselectItem=function(i){var $=i.$();if($){$.removeClass('sapMITBSelectItemSelected');$.removeAttr('aria-selected');}};
a.prototype._selectItem=function(i){var $=i.$();if($){$.addClass('sapMITBSelectItemSelected');$.attr('aria-selected',true);}};
a.prototype.ontap=function(e){var $=q(e.target);if(!$.hasClass('sapMITBSelectItem')){$=$.parent(".sapMITBSelectItem");}var s=sap.ui.getCore().byId($[0].id);if(s&&s.getEnabled()){e.preventDefault();if(s!=this.getSelectedItem()){this._selectItem(s);this.fireSelectionChange({selectedItem:s});}}if(this._iconTabHeader){this._iconTabHeader._closeOverflow();}};
a.prototype.onsapenter=a.prototype.ontap;a.prototype.onsapspace=a.prototype.ontap;
a.prototype.checkIconOnly=function(b){var c,d=b.length;for(var i=0;i<d;i++){c=b[i];if(c.getText()||c.getCount()){return false;}}return true;};
return a;},true);
sap.ui.predefine('sap/m/IconTabBarSelectListRenderer',['jquery.sap.global','sap/ui/core/Renderer'],function(q,R){'use strict';var I={};
I.render=function(r,c){var i,a,b=c.getVisibleItems(),d=b.length,e=c._iconTabHeader,f=true;if(e){e._checkTextOnly(b);f=e._bTextOnly;c._bIconOnly=c.checkIconOnly(b);}r.write('<ul');r.writeAttribute('role','listbox');r.writeControlData(c);r.addClass('sapMITBSelectList');if(f){r.addClass('sapMITBSelectListTextOnly');}r.writeClasses();r.write('>');for(i=0;i<d;i++){a=b[i];a.renderInSelectList(r,c,i,d);}r.write('</ul>');};
return I;},true);
sap.ui.predefine('sap/m/IconTabFilter',['jquery.sap.global','./library','sap/ui/core/Item','sap/ui/core/Renderer','sap/ui/core/IconPool','sap/ui/core/InvisibleText'],function(q,l,I,R,a,b){"use strict";
var c=I.extend("sap.m.IconTabFilter",{metadata:{interfaces:["sap.m.IconTab","sap.ui.core.PopupInterface"],library:"sap.m",properties:{count:{type:"string",group:"Data",defaultValue:''},showAll:{type:"boolean",group:"Misc",defaultValue:false},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:''},iconColor:{type:"sap.ui.core.IconColor",group:"Appearance",defaultValue:sap.ui.core.IconColor.Default},iconDensityAware:{type:"boolean",group:"Appearance",defaultValue:true},visible:{type:"boolean",group:"Behavior",defaultValue:true},design:{type:"sap.m.IconTabFilterDesign",group:"Appearance",defaultValue:sap.m.IconTabFilterDesign.Vertical}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}}}});
c._aAllIconColors=['sapMITBFilterCritical','sapMITBFilterPositive','sapMITBFilterNegative','sapMITBFilterDefault','sapMITBFilterNeutral'];
c.prototype._getImageControl=function(C,p,d){var P={src:this.getIcon(),densityAware:this.getIconDensityAware(),useIconTooltip:false};if(P.src){this._oImageControl=sap.m.ImageHelper.getImageControl(this.getId()+"-icon",this._oImageControl,p,P,C,d);}else if(this._oImageControl){this._oImageControl.destroy();this._oImageControl=null;}return this._oImageControl;};
c.prototype.exit=function(e){if(this._oImageControl){this._oImageControl.destroy();}if(I.prototype.exit){I.prototype.exit.call(this,e);}};
c.prototype.invalidate=function(){var i=this.getParent(),o;if(i instanceof sap.m.IconTabHeader&&i.getParent()instanceof sap.m.IconTabBar){o=i.getParent();if(o.getParent()instanceof sap.m.ObjectHeader){var O=o.getParent();O.invalidate();}else{o.invalidate();}}};
c.prototype.setProperty=function(p,v,s){switch(p){case'visible':case'enabled':case'textDirection':case'text':case'count':case'showAll':case'icon':case'iconColor':case'iconDensityAware':case'design':if(this.getProperty(p)===v){return this;}sap.ui.core.Control.prototype.setProperty.call(this,p,v,true);if(!s){var i=this.getParent();if(i instanceof sap.m.IconTabHeader){i.invalidate();}}break;default:sap.ui.core.Control.prototype.setProperty.apply(this,arguments);break;}return this;};
c.prototype._getNonEmptyKey=function(){var k=this.getKey();if(k){return k;}return this.getId();};
c.prototype.render=function(r,v,d){var t=this;if(!t.getVisible()){return;}var i=this.getParent(),e=i.getParent(),h=e instanceof sap.m.IconTabBar,f=sap.ui.getCore().getLibraryResourceBundle('sap.m'),g='role="tab"',j=t.getId(),k=t.getCount(),m=t.getText(),n=t.getIcon(),o=t.getDesign(),p=t.getIconColor(),s=p==='Positive'||p==='Critical'||p==='Negative',u=o===sap.m.IconTabFilterDesign.Horizontal,w=h&&e.getUpperCase(),x=i._bTextOnly,y=i._bInLine||i.isInlineMode();if(h){g+=' aria-controls="'+e.sId+'-content" ';}if(m.length||k!==''||n){g+='aria-labelledby="';var z=[];if(m.length){z.push(j+'-text');}if(k!==''){z.push(j+'-count');}if(n){z.push(j+'-icon');}if(s){z.push(j+'-iconColor');}g+=z.join(' ');g+='"';}r.write('<div '+g+' ');if(v!==undefined&&d!==undefined){r.writeAccessibilityState({posinset:v+1,setsize:d});}r.writeElementData(t);r.addClass('sapMITBItem');if(!k){r.addClass('sapMITBItemNoCount');}if(u){r.addClass('sapMITBHorizontal');}else{r.addClass('sapMITBVertical');}if(t.getShowAll()){r.addClass('sapMITBAll');}else{r.addClass('sapMITBFilter');r.addClass('sapMITBFilter'+p);}if(!t.getEnabled()){r.addClass('sapMITBDisabled');r.writeAttribute('aria-disabled',true);}r.writeAttribute('aria-selected',false);var T=t.getTooltip_AsString();if(T){r.writeAttributeEscaped('title',T);}r.writeClasses();r.write('>');if(!y){r.write('<div id="'+j+'-tab" class="sapMITBTab">');if(!t.getShowAll()||!n){if(s){r.write('<div id="'+j+'-iconColor" style="display: none;">'+f.getText('ICONTABBAR_ICONCOLOR_'+p.toUpperCase())+'</div>');}r.renderControl(t._getImageControl(['sapMITBFilterIcon','sapMITBFilter'+p],i,c._aAllIconColors));}if(!t.getShowAll()&&!n&&!x){r.write('<span class="sapMITBFilterNoIcon"> </span>');}if(u&&!t.getShowAll()){r.write('</div>');r.write('<div class="sapMITBHorizontalWrapper">');}r.write('<span id="'+j+'-count" ');r.addClass('sapMITBCount');r.writeClasses();r.write('>');if(k===''&&u){r.write('&nbsp;');}else{r.writeEscaped(k);}r.write('</span>');if(!u){r.write('</div>');}}if(m.length){r.write('<div id="'+j+'-text" ');r.addClass('sapMITBText');if(w){r.addClass('sapMITBTextUpperCase');}if(y){r.writeAttribute('dir','ltr');}r.writeClasses();r.write('>');r.writeEscaped(i._getDisplayText(t));r.write('</div>');}if(!y&&u){r.write('</div>');}r.write('<div class="sapMITBContentArrow"></div>');r.write('</div>');};
c.prototype.renderInSelectList=function(r,s,v,d){var t=this;if(!t.getVisible()){return;}var i=true,e,f=s._iconTabHeader,g=sap.ui.getCore().getLibraryResourceBundle('sap.m');if(f){i=f._bTextOnly;e=s._bIconOnly;}r.write('<li');r.writeElementData(t);r.writeAttribute('tabindex','-1');r.writeAttribute('role','option');if(v!==undefined&&d!==undefined){r.writeAttribute('aria-posinset',v+1);r.writeAttribute('aria-setsize',d);}var h=t.getTooltip_AsString();if(h){r.writeAttributeEscaped('title',h);}if(!t.getEnabled()){r.addClass('sapMITBDisabled');r.writeAttribute('aria-disabled',true);}r.addClass('sapMITBSelectItem');if(s.getSelectedItem()==t){r.addClass('sapMITBSelectItemSelected');r.writeAttribute('aria-selected',true);}var j=t.getIconColor();r.addClass('sapMITBFilter'+j);r.writeClasses();var k=t.getId(),m,n=j=='Positive'||j=='Critical'||j=='Negative';var o=' aria-labelledby="';if(!e){o+=k+'-text ';}if(!i&&t.getIcon()){o+=k+'-icon ';}if(n){m=new b({text:g.getText('ICONTABBAR_ICONCOLOR_'+j.toUpperCase())});o+=m.getId();}o+='"';r.write(o+'>');if(m){r.renderControl(m);}if(!i){this._renderIcon(r);}if(!e){this._renderText(r);}r.write('</li>');};
c.prototype._renderIcon=function(r){var i=this.getIcon();if(i){var d=a.getIconInfo(i);var e=['sapMITBSelectItemIcon'];if(d&&!d.suppressMirroring){e.push('sapUiIconMirrorInRTL');}r.writeIcon(i,e,{id:this.getId()+'-icon','aria-hidden':true});}else{r.write('<span class="sapUiIcon"></span>');}};
c.prototype._renderText=function(r){var t=this.getText(),d=this.getCount(),i=sap.ui.getCore().getConfiguration().getRTL(),e=this.getTextDirection();r.write('<span');r.writeAttribute('id',this.getId()+'-text');r.writeAttribute('dir','ltr');r.addClass('sapMText');r.addClass('sapMTextNoWrap');r.addClass('sapMITBText');r.writeClasses();if(e!==sap.ui.core.TextDirection.Inherit){r.writeAttribute('dir',e.toLowerCase());}var f=R.getTextAlign(sap.ui.core.TextAlign.Begin,e);if(f){r.addStyle('text-align',f);r.writeStyles();}if(d){if(i){t='('+d+') '+t;}else{t+=' ('+d+')';}}r.write('>');r.writeEscaped(t);r.write('</span>');};
return c;},true);
sap.ui.predefine('sap/m/IconTabHeader',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/EnabledPropagator','sap/ui/core/delegate/ItemNavigation','sap/ui/core/IconPool','sap/ui/core/delegate/ScrollEnablement','./IconTabBarSelectList','./Button','./ResponsivePopover','./IconTabFilter'],function(q,l,C,E,I,a,S,b,B,R,c){"use strict";
var d=C.extend("sap.m.IconTabHeader",{metadata:{library:"sap.m",properties:{showSelection:{type:"boolean",group:"Misc",defaultValue:true,deprecated:true},selectedKey:{type:"string",group:"Data",defaultValue:null},visible:{type:"boolean",group:"Behavior",defaultValue:true},mode:{type:"sap.m.IconTabHeaderMode",group:"Appearance",defaultValue:sap.m.IconTabHeaderMode.Standard},showOverflowSelectList:{type:"boolean",group:"Appearance",defaultValue:false},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:sap.m.BackgroundDesign.Solid},enableTabReordering:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{items:{type:"sap.m.IconTab",multiple:true,singularName:"item"}},events:{select:{parameters:{item:{type:"sap.m.IconTabFilter"},key:{type:"string"}}}}}});
E.apply(d.prototype,[true]);d.ANIMATION_DURATION=sap.ui.getCore().getConfiguration().getAnimation()?200:0;d.SCROLL_STEP=264;
d.prototype.init=function(){this._bPreviousScrollForward=false;this._bPreviousScrollBack=false;this._iCurrentScrollLeft=0;this._bRtl=sap.ui.getCore().getConfiguration().getRTL();this.startScrollX=0;this.startTouchX=0;this._scrollable=null;this._aTabKeys=[];this._oItemNavigation=new I().setCycling(false);this._oItemNavigation.attachEvent(I.Events.FocusLeave,this._onItemNavigationFocusLeave,this);this._oItemNavigation.attachEvent(I.Events.AfterFocus,this._onItemNavigationAfterFocus,this);this._oItemNavigation.setDisabledModifiers({sapnext:["alt","meta"],sapprevious:["alt","meta"]});this.addDelegate(this._oItemNavigation);this._oScroller=new S(this,this.getId()+"-head",{horizontal:true,vertical:false,nonTouchScrolling:true});};
d.prototype.isTouchScrollingDisabled=function(){return this.getShowOverflowSelectList()&&this.getParent().getMetadata().getName()=='sap.tnt.ToolHeader';};
d.prototype._getSelectList=function(){var t=this;if(!this._oSelectList){this._oSelectList=new b({selectionChange:function(e){var T=e.getParameter('selectedItem');t.setSelectedItem(T._tabFilter);}});this._oSelectList._iconTabHeader=this;}return this._oSelectList;};
d.prototype._getOverflowButton=function(){if(!this._oOverflowButton){this._oOverflowButton=new B({id:this.getId()+'-overflow',icon:"sap-icon://overflow",type:sap.m.ButtonType.Transparent,press:this._overflowButtonPress.bind(this)});}return this._oOverflowButton;};
d.prototype._overflowButtonPress=function(e){if(!this._oPopover){this._oPopover=new R({showArrow:false,showHeader:false,placement:sap.m.PlacementType.Vertical,offsetX:0,offsetY:0}).addStyleClass('sapMITBPopover');if(sap.ui.Device.system.phone){this._oPopover._oControl.addButton(this._createPopoverCloseButton());}this.addDependent(this._oPopover);}var s=this._getSelectList();this._setSelectListItems();this._oPopover.removeAllContent();this._oPopover.addContent(s);this._oPopover.setInitialFocus(s.getSelectedItem());this._oPopover.openBy(this._getOverflowButton());};
d.prototype._createPopoverCloseButton=function(){var t=this;var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");return new B({text:r.getText("SELECT_CANCEL_BUTTON"),press:function(){t._closeOverflow();}});};
d.prototype._closeOverflow=function(){if(!sap.ui.Device.system.desktop){this._oPopover.close();}if(this.oSelectedItem){this.oSelectedItem.$().focus();}};
d.prototype._setSelectListItems=function(){if(!this.getShowOverflowSelectList()){return;}var s,t,o=this._getSelectList(),T=this.getTabFilters();o.removeAllItems();for(var i=0;i<T.length;i++){t=T[i];s=t.clone();s._tabFilter=t;o.addItem(s);if(t==this.oSelectedItem){o.setSelectedItem(s);}}};
d.prototype._findSelectItem=function(t){var s=this._getSelectList(),e=s.getItems(),o;for(var i=0;i<e.length;i++){o=e[i];if(o._tabFilter==t){return o;}}};
d.prototype._onItemNavigationFocusLeave=function(){if(!this.oSelectedItem){return;}var e=this.getItems();var f=-1;var o;for(var i=0;i<e.length;i++){o=e[i];if(o instanceof sap.m.IconTabFilter==false){continue;}f++;if(this.oSelectedItem==o){break;}}this._oItemNavigation.setFocusedIndex(f);};
d.prototype._onItemNavigationAfterFocus=function(e){var h=this.getDomRef("head"),i=e.getParameter("index"),$=e.getParameter('event');if($.keyCode===undefined){return;}this._iCurrentScrollLeft=h.scrollLeft;this._checkOverflow();if(i!==null&&i!==undefined){this._scrollIntoView(this.getTabFilters()[i],0);}};
d.prototype.getTabFilters=function(){var i=this.getItems();var t=[];i.forEach(function(o){if(o instanceof sap.m.IconTabFilter){t.push(o);}});return t;};
d.prototype.exit=function(){if(this._oArrowLeft){this._oArrowLeft.destroy();}if(this._oArrowRight){this._oArrowRight.destroy();}if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this._sResizeListenerId){sap.ui.core.ResizeHandler.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}if(this._aTabKeys){this._aTabKeys=null;}if(this._oPopover){this._oPopover.destroy();this._oPopover=null;}if(this._oOverflowButton){this._oOverflowButton.destroy();this._oOverflowButton=null;}};
d.prototype.onBeforeRendering=function(){var e=this.getItems(),s=this.getSelectedKey(),i=0,p=this.getParent(),f=p instanceof sap.m.IconTabBar,g=p&&p.getMetadata().getName()=='sap.tnt.ToolHeader';if(this._sResizeListenerId){sap.ui.core.ResizeHandler.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}if(e.length>0){if(!this.oSelectedItem||s&&s!==this.oSelectedItem._getNonEmptyKey()){if(s){for(;i<e.length;i++){if(!(e[i]instanceof sap.m.IconTabSeparator)&&e[i]._getNonEmptyKey()===s){this.oSelectedItem=e[i];break;}}}if(!this.oSelectedItem&&(f||!s)){for(i=0;i<e.length;i++){if(!(e[i]instanceof sap.m.IconTabSeparator)&&e[i].getVisible()){this.oSelectedItem=e[i];break;}}}}if(!g&&this.oSelectedItem&&!this.oSelectedItem.getVisible()){for(i=0;i<e.length;i++){if(!(e[i]instanceof sap.m.IconTabSeparator)&&e[i].getVisible()){this.oSelectedItem=e[i];break;}}}if(this.oSelectedItem){this.setProperty("selectedKey",this.oSelectedItem._getNonEmptyKey(),true);}}this._isTouchScrollingDisabled=this.isTouchScrollingDisabled();this._oScroller.setHorizontal(!this._isTouchScrollingDisabled);if(this._sResizeListenerNoFlexboxSupportId){sap.ui.core.ResizeHandler.deregister(this._sResizeListenerNoFlexboxSupportId);this._sResizeListenerNoFlexboxSupportId=null;}};
d.prototype.setSelectedKey=function(k){var e=this.getTabFilters(),i=0,p=this.getParent(),f=p instanceof sap.m.IconTabBar,s;if(e.length>0){k=k||e[0]._getNonEmptyKey();}if(this.$().length){for(;i<e.length;i++){if(e[i]._getNonEmptyKey()===k){this.setSelectedItem(e[i],true);s=true;break;}}if(!s&&!f&&k){this.setSelectedItem(null);}}this.setProperty("selectedKey",k,true);return this;};
d.prototype.setSelectedItem=function(i,A){if(!i||!i.getEnabled()){if(this.oSelectedItem){this.oSelectedItem.$().removeClass("sapMITBSelected");this.oSelectedItem=null;}return this;}if(this.getShowOverflowSelectList()){var s=this._findSelectItem(i);if(s){this._getSelectList().setSelectedItem(s);}}var p=this.getParent();var e=p instanceof sap.m.IconTabBar;var f=false;if(i.getContent().length===0&&this.oSelectedItem&&this.oSelectedItem.getContent().length===0){f=true;}if(this.oSelectedItem&&this.oSelectedItem.getVisible()&&(!A&&e&&p.getExpandable()||this.oSelectedItem!==i)){this.oSelectedItem.$().removeClass("sapMITBSelected").attr('aria-selected',false).removeAttr('aria-expanded');}if(i.getVisible()){if(this.oSelectedItem===i){if(!A&&e&&p.getExpandable()){p._toggleExpandCollapse();}}else{if(e){p.$("content").attr('aria-labelledby',i.sId);}this.oSelectedItem=i;this.setProperty("selectedKey",this.oSelectedItem._getNonEmptyKey(),true);if(!e){this.oSelectedItem.$().addClass("sapMITBSelected").attr({'aria-selected':true});}if(e&&(p.getExpandable()||p.getExpanded())){this.oSelectedItem.$().addClass("sapMITBSelected").attr({'aria-selected':true});var o=this.oSelectedItem.getContent();if(o.length>0){p._rerenderContent(o);}else{if(!f){p._rerenderContent(p.getContent());}}if(!A&&p.getExpandable()&&!p.getExpanded()){p._toggleExpandCollapse(true);}}}if(this.oSelectedItem.$().length>0){this._scrollIntoView(i,500);}else{this._scrollAfterRendering=true;}}this.oSelectedItem=i;var g=this.oSelectedItem._getNonEmptyKey();this.setProperty("selectedKey",g,true);if(e){p.setProperty("selectedKey",g,true);}if(!A){if(e){p.fireSelect({selectedItem:this.oSelectedItem,selectedKey:g,item:this.oSelectedItem,key:g});}else{this.fireSelect({selectedItem:this.oSelectedItem,selectedKey:g,item:this.oSelectedItem,key:g});}}return this;};
d.prototype.getVisibleTabFilters=function(){var e=this.getTabFilters(),v=[],o;for(var i=0;i<e.length;i++){o=e[i];if(o.getVisible()){v.push(o);}}return v;};
d.prototype._getFirstVisibleItem=function(e){for(var i=0;i<e.length;i++){if(e[i].getVisible()){return e[i];}}return null;};
d.prototype._initItemNavigation=function(){var t=this,h=this.getDomRef("head"),i=this.getItems(),T=[],s=-1;i.forEach(function(o){if(o instanceof sap.m.IconTabFilter){var e=t.getFocusDomRef(o);q(e).attr("tabindex","-1");T.push(e);if(o===t.oSelectedItem){s=T.indexOf(e);}}});if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.attachEvent(I.Events.FocusLeave,this._onItemNavigationFocusLeave,this);this._oItemNavigation.attachEvent(I.Events.AfterFocus,this._onItemNavigationAfterFocus,this);this.addDelegate(this._oItemNavigation);}this._oItemNavigation.setRootDomRef(h);this._oItemNavigation.setItemDomRefs(T);this._oItemNavigation.setSelectedIndex(s);};
d.prototype.onAfterRendering=function(){if(this._oScroller){this._oScroller.setIconTabBar(this,q.proxy(this._afterIscroll,this),q.proxy(this._scrollPreparation,this));}var p=this.getParent();var i=p instanceof sap.m.IconTabBar;if(this.oSelectedItem&&(!i||i&&p.getExpanded())){this.oSelectedItem.$().addClass("sapMITBSelected").attr({'aria-selected':true});}q.sap.delayedCall(350,this,"_checkOverflow");if(this.oSelectedItem){this._scrollIntoView(this.oSelectedItem,500);}this._initItemNavigation();if(this.getShowOverflowSelectList()){this.$('overflow').attr('tabindex',-1);}this._sResizeListenerId=sap.ui.core.ResizeHandler.register(this.getDomRef(),q.proxy(this._fnResize,this));if(!q.support.newFlexBoxLayout&&i&&p.getStretchContentHeight()){this._sResizeListenerNoFlexboxSupportId=sap.ui.core.ResizeHandler.register(p.getDomRef(),q.proxy(this._fnResizeNoFlexboxSupport,this));this._fnResizeNoFlexboxSupport();}this._bCheckIfIntoView=true;};
d.prototype.destroyItems=function(){this.oSelectedItem=null;this._aTabKeys=[];this.destroyAggregation("items");};
d.prototype.addItem=function(i){if(!(i instanceof sap.m.IconTabSeparator)){var k=i.getKey();if(this._aTabKeys.indexOf(k)!==-1){q.sap.log.warning("sap.m.IconTabHeader: duplicate key '"+k+"' inside the IconTabFilter. Please use unique keys.");}this._aTabKeys.push(k);}this.addAggregation("items",i);};
d.prototype.insertItem=function(i,e){if(!(i instanceof sap.m.IconTabSeparator)){var k=i.getKey();if(this._aTabKeys.indexOf(k)!==-1){q.sap.log.warning("sap.m.IconTabHeader: duplicate key '"+k+"' inside the IconTabFilter. Please use unique keys.");}this._aTabKeys.push(k);}this.insertAggregation("items",i,e);};
d.prototype.removeAllItems=function(){this._aTabKeys=[];this.removeAllAggregation("items");};
d.prototype.removeItem=function(i){i=this.removeAggregation("items",i);if(i&&!(i instanceof sap.m.IconTabSeparator)){var k=i.getKey();this._aTabKeys.splice(this._aTabKeys.indexOf(k),1);}return i;};
d.prototype.updateAggregation=function(){this.oSelectedItem=null;return C.prototype.updateAggregation.apply(this,arguments);};
d.prototype.removeAggregation=function(A,o,s){var i=this.getTabFilters();var e=C.prototype.removeAggregation.apply(this,arguments);if(this._oDragContext){return e;}if(e&&e==this.oSelectedItem&&A=='items'){var f=q.inArray(e,i);i=this.getTabFilters();f=Math.max(0,Math.min(f,i.length-1));var g=i[f];if(g){this.setSelectedItem(g,true);}else{var h=this.getParent();if(h instanceof sap.m.IconTabBar&&h.getExpanded()){h.$("content").children().remove();}}}return e;};
d.prototype.removeAllAggregation=function(A,s){if(A=='items'){var i=this.getParent();if(i instanceof sap.m.IconTabBar&&i.getExpanded()){i.$("content").children().remove();}}return C.prototype.removeAllAggregation.apply(this,arguments);};
d.prototype._getDisplayText=function(i){var t=i.getText();if(this.isInlineMode()){var s=i.getCount();if(s){if(this._bRtl){t='('+s+') '+t;}else{t+=' ('+s+')';}}}return t;};
d.prototype.isInlineMode=function(){return this._bTextOnly&&this.getMode()==sap.m.IconTabHeaderMode.Inline;};
d.prototype._checkTextOnly=function(e){if(e.length>0){for(var i=0;i<e.length;i++){if(!(e[i]instanceof sap.m.IconTabSeparator)){if(e[i].getIcon()){this._bTextOnly=false;return false;}}}}this._bTextOnly=true;return true;};
d.prototype._checkNoText=function(e){if(e.length>0){for(var i=0;i<e.length;i++){if(!(e[i]instanceof sap.m.IconTabSeparator)){if(e[i].getText().length>0){return false;}}}}return true;};
d.prototype._checkInLine=function(e){var o;if(e.length>0){for(var i=0;i<e.length;i++){o=e[i];if(!(o instanceof sap.m.IconTabSeparator)){if(o.getIcon()||o.getCount()){this._bInLine=false;return false;}}}}this._bInLine=true;return true;};
d.prototype._checkScrolling=function(h){var $=this.$();var s=false;var e=this.getDomRef("scrollContainer");var f=this.getDomRef("head");if(f&&e){if(f.offsetWidth>e.offsetWidth){s=true;}}if(this._scrollable!==s){$.toggleClass("sapMITBScrollable",s);$.toggleClass("sapMITBNotScrollable",!s);this._scrollable=s;}this._setTabsVisibility();return s;};
d.prototype._getScrollingArrow=function(n){var s=a.getIconURI("slim-arrow-"+n);var p={src:s,useIconTooltip:false};var e=this._bTextOnly?"TextOnly":"";var L="sapMITBArrowScrollLeft"+e;var r="sapMITBArrowScrollRight"+e;var f=["sapMITBArrowScroll",L];var g=["sapMITBArrowScroll",r];if(this._bInLine){f.push('sapMITBArrowScrollLeftInLine');g.push('sapMITBArrowScrollRightInLine');}if(n==="left"){if(!this._oArrowLeft){this._oArrowLeft=sap.m.ImageHelper.getImageControl(this.getId()+"-arrowScrollLeft",this._oArrowLeft,this,p,f);}return this._oArrowLeft;}if(n==="right"){if(!this._oArrowRight){this._oArrowRight=sap.m.ImageHelper.getImageControl(this.getId()+"-arrowScrollRight",this._oArrowRight,this,p,g);}return this._oArrowRight;}};
d.prototype._checkOverflow=function(){var o=this.getDomRef("head");var $=this.$();if(this._checkScrolling(o)&&o){var s=false;var e=false;var f=this.getDomRef("scrollContainer");var g=this.getDomRef("head");if(this._oScroller.getScrollLeft()>0){s=true;}if((this._oScroller.getScrollLeft()+f.offsetWidth)<g.offsetWidth){e=true;}if((e!=this._bPreviousScrollForward)||(s!=this._bPreviousScrollBack)){this._bPreviousScrollForward=e;this._bPreviousScrollBack=s;$.toggleClass("sapMITBScrollBack",s);$.toggleClass("sapMITBNoScrollBack",!s);$.toggleClass("sapMITBScrollForward",e);$.toggleClass("sapMITBNoScrollForward",!e);}}else{this._bPreviousScrollForward=false;this._bPreviousScrollBack=false;}};
d.prototype._handleActivation=function(e){var t=e.target.id,o=e.srcControl,s;if(this._oDragContext&&this._oDragContext.movedTabIndexes.length){return;}if(o instanceof B){return;}var $=q.sap.byId(t);if(q.inArray(this.$("content")[0],$.parents())>-1){}else{if(t){var i=this.getId();e.preventDefault();if(t==i+"-arrowScrollLeft"&&sap.ui.Device.system.desktop){var f=this._oScroller.getScrollLeft()-d.SCROLL_STEP;if(f<0){f=0;}this._scrollPreparation();q.sap.delayedCall(0,this._oScroller,"scrollTo",[f,0,500]);q.sap.delayedCall(500,this,"_afterIscroll");}else if(t==i+"-arrowScrollRight"&&sap.ui.Device.system.desktop){var f=this._oScroller.getScrollLeft()+d.SCROLL_STEP;var g=this.$("scrollContainer").width();var h=this.$("head").width();if(f>(h-g)){f=h-g;}this._scrollPreparation();q.sap.delayedCall(0,this._oScroller,"scrollTo",[f,0,500]);q.sap.delayedCall(500,this,"_afterIscroll");}else{if(o instanceof sap.ui.core.Icon||o instanceof sap.m.Image){s=e.srcControl.getId().replace(/-icon$/,"");o=sap.ui.getCore().byId(s);if(o.getMetadata().isInstanceOf("sap.m.IconTab")&&!(o instanceof sap.m.IconTabSeparator)){this.setSelectedItem(o);}}else if(o.getMetadata().isInstanceOf("sap.m.IconTab")&&!(o instanceof sap.m.IconTabSeparator)){this.setSelectedItem(o);}}}else{if(o.getMetadata().isInstanceOf("sap.m.IconTab")&&!(o instanceof sap.m.IconTabSeparator)){this.setSelectedItem(o);}}}};
d.prototype._scrollIntoView=function(i,D){var $=i.$(),s,n,e;if($.length>0){var f=this.$('head');var h=f.innerWidth()-f.width();var g=$.outerWidth(true);var j=$.position().left-h/2;s=this._oScroller.getScrollLeft();e=this.$("scrollContainer").width();n=0;if(j-s<0||j-s>e-g){if(j-s<0){n+=j;}else{n+=Math.min(j,j+g-e);}this._scrollPreparation();this._iCurrentScrollLeft=n;q.sap.delayedCall(0,this._oScroller,"scrollTo",[n,0,D]);q.sap.delayedCall(D,this,"_afterIscroll");}}return this;};
d.prototype._scroll=function(D,i){this._scrollPreparation();var o=this.getDomRef("head");var s=o.scrollLeft;var e=sap.ui.Device.browser.internet_explorer||sap.ui.Device.browser.edge;if(!e&&this._bRtl){D=-D;}var f=s+D;q(o).stop(true,true).animate({scrollLeft:f},i,q.proxy(this._adjustAndShowArrow,this));this._iCurrentScrollLeft=f;};
d.prototype._adjustAndShowArrow=function(){this._$bar&&this._$bar.toggleClass("sapMITBScrolling",false);this._$bar=null;if(sap.ui.Device.system.desktop){this._checkOverflow();}};
d.prototype._scrollPreparation=function(){if(!this._$bar){this._$bar=this.$().toggleClass("sapMITBScrolling",true);}};
d.prototype._afterIscroll=function(){this._checkOverflow();this._adjustAndShowArrow();this._setTabsVisibility();};
d.prototype._fnResize=function(){this._checkOverflow();if(this.oSelectedItem&&this._bCheckIfIntoView){this._scrollIntoView(this.oSelectedItem,0);if(!this._isTouchScrollingDisabled){this._bCheckIfIntoView=false;}}this._setTabsVisibility();};
d.prototype._fnResizeNoFlexboxSupport=function(){var $=this.getParent().$("containerContent"),D=$.outerHeight(true)-$.height();$.height(this.getParent().$().height()-$.position().top-D);};
d.prototype._setTabsVisibility=function(){if(!this._isTouchScrollingDisabled){return;}var t=this.getItems(),T,$,h,i;for(i=0;i<t.length;i++){T=t[i];$=T.$();if(!$.hasClass('sapMITBSelected')&&!this._isTabIntoView($)){$.addClass('sapMITBFilterHidden');}else{h=true;$.removeClass('sapMITBFilterHidden');}}if(!h){for(i=0;i<t.length;i++){T=t[i];$=T.$();if(this._isTabIntoView($,true)){$.removeClass('sapMITBFilterHidden');break;}}}this._moveVisibleTabs();};
d.prototype._isTabIntoView=function($,s){if(!$.length){return false;}var i=this._oScroller.getScrollLeft(),e=this.$("scrollContainer").width(),f=this.$('head'),h=f.innerWidth()-f.width(),g=$.css('margin-left'),j=$.outerWidth()+parseFloat(g),k=Math.ceil($.position().left-h/2);if(k-i<0||(!s&&(k+j-i>e))){return false;}return true;};
d.prototype._moveVisibleTabs=function(){if(!this._oScroller){return;}var s=this._oScroller.getScrollLeft(),$=this.$('head'),h=$.innerWidth()-$.width(),e=this.$().find('.sapMITBFilter:not(.sapMITBFilterHidden)').first(),i,f;if(!e.length){return;}f=e.position().left-h/2;if(!this._bRtl&&f-s>2){i=s-f;$.css('transform','translate('+i+'px)');}else{$.css('transform','');}return true;};
d.prototype.onExit=function(){if(this._sResizeListenerNoFlexboxSupportId){sap.ui.core.ResizeHandler.deregister(this._sResizeListenerNoFlexboxSupportId);this._sResizeListenerNoFlexboxSupportId=null;}};
d.prototype.getFocusDomRef=function(f){var t=f||this.oSelectedItem;if(!t){return null;}return t.getDomRef();};
d.prototype.applyFocusInfo=function(f){if(f.focusDomRef){q(f.focusDomRef).focus();}};
d.prototype.ontouchstart=function(e){var t=e.targetTouches[0];this._iActiveTouch=t.identifier;this._iTouchStartPageX=t.pageX;this._iTouchDragX=0;var $=q(e.target);if($.hasClass('sapMITBArrowScroll')){e.preventDefault();}if(sap.ui.Device.browser.internet_explorer){if($.hasClass('sapMITBFilterIcon')||$.hasClass('sapMITBCount')||$.hasClass('sapMITBText')||$.hasClass('sapMITBTab')||$.hasClass('sapMITBContentArrow')||$.hasClass('sapMITBSep')||$.hasClass('sapMITBSepIcon')){e.preventDefault();}}};
d.prototype.ontouchmove=function(e){if(this._iActiveTouch===undefined){return;}var t=sap.m.touch.find(e.changedTouches,this._iActiveTouch);if(!t||t.pageX===this._iTouchStartPageX){return;}this._iTouchDragX+=Math.abs(this._iTouchStartPageX-t.pageX);this._iTouchStartPageX=t.pageX;};
d.prototype.ontouchend=function(e){if(this._iActiveTouch===undefined){return;}if(this._scrollable&&this._iTouchDragX>(sap.ui.Device.system.desktop?5:15)){return;}var M=0;var L=1;var f;if(e.which===f||e.which===M||e.which===L){this._handleActivation(e);}this._iActiveTouch=undefined;};
d.prototype.ontouchcancel=d.prototype.ontouchend;
d.prototype.onsapselect=function(e){this._handleActivation(e);};
d.prototype.onmousedown=function(e){if(!this.getEnableTabReordering()){return;}var i=!!e.originalEvent["touches"];if(i){return;}var $=q(e.target);var f=$.closest(".sapMITBFilter, .sapMITBAll");if(f.length===1){this._onTabMoveStart(f,e);}};
d.prototype._onTabMoveStart=function($,e){var i=this._getItemIndex($),f=this.$().find('.sapMITBHead').children(),w=$.outerWidth(true),g=q(document);e.preventDefault();$.zIndex(this.$().zIndex()+10);this._oDragContext={index:q.inArray($[0],f),tabIndex:i,startX:e.pageX,$tab:$,tab:this.getItems()[i],tabWidth:w,tabCenter:$.position().left+w/2,movedTabIndexes:[]};this._oScroller.setHorizontal(false);g.mousemove(q.proxy(this._onTabMove,this));g.mouseup(q.proxy(this._onTabMoved,this));};
d.prototype._onTabMove=function(e){var D=this._oDragContext;if(!D){return;}var p=e.pageX,f=p-D.startX,$,x,o,r,g=this.$().find('.sapMITBHead').children(),m=D.movedTabIndexes,h=sap.ui.getCore().getConfiguration().getRTL();D.$tab.css({left:f});for(var i=0;i<g.length;i++){if(i==D.index){continue;}$=q(g[i]);x=$.position().left;o=parseFloat($.css('left'));if(!isNaN(o)){x-=o;}if(i<D.index!=h){r=x+$.outerWidth(true)>D.tabCenter+f;this._onAnimateTab($,D.tabWidth,r,m,i);}else{r=x<D.tabCenter+f;this._onAnimateTab($,-D.tabWidth,r,m,i);}}};
d.prototype._onAnimateTab=function($,D,r,m,i){var e=q.inArray(i,m),f=e!=-1;if(r&&!f){$.stop(true,true);$.animate({left:D},d.ANIMATION_DURATION);m.push(i);}else if(!r&&f){$.stop(true,true);$.animate({left:0},d.ANIMATION_DURATION);m.splice(e,1);}};
d.prototype._onTabMoved=function(e){var D=this._oDragContext;if(!D){return;}var m=D.movedTabIndexes;if(m.length>0){var $=D.$tab,f=this.$().find('.sapMITBHead').children(),n=m[m.length-1],N=this._getItemIndex(q(f[n]));this.removeAggregation('items',D.tab,true);this.insertAggregation('items',D.tab,N,true);if(n>D.index){$.insertAfter(q(f[n]));}else{$.insertBefore(q(f[n]));}this._initItemNavigation();q.sap.delayedCall(100,this,function(){$.focus();});}this._stopMoving();};
d.prototype._stopMoving=function(){var D=this._oDragContext,$=D.$tab,e=this.$().find('.sapMITBHead').children();$.css('z-index','');e.stop(true,true);e.css('left','');this._oDragContext=null;var f=q(document);f.off("mousemove",this._onTabMove);f.off("mouseup",this._onTabMoved);this._oScroller.setHorizontal(true);this._enableTextSelection();};
d.prototype._getItemIndex=function($){var s=$.attr('id'),t=this.getItems();for(var i=0;i<t.length;i++){if(t[i].getId()==s){return i;}}return-1;};
d.prototype._disableTextSelection=function(e){q(e||document.body).attr("unselectable","on").addClass('sapMITBNoSelection').bind("selectstart",function(o){o.preventDefault();return false;});};
d.prototype._enableTextSelection=function(e){q(e||document.body).attr("unselectable","off").removeClass('sapMITBNoSelection').unbind("selectstart");};
return d;},true);
sap.ui.predefine('sap/m/IconTabHeaderRenderer',['jquery.sap.global','sap/ui/core/IconPool'],function(q,I){"use strict";var a={};
a.render=function(r,c){if(!c.getVisible()){return;}var b=c.getItems(),d=b.length,v=c.getVisibleTabFilters(),V=v.length,e=0,t=c._checkTextOnly(b),n=c._checkNoText(b),f=c._checkInLine(b)||c.isInlineMode(),s=c.getShowOverflowSelectList(),o,g,h;var j=c.getParent();var u=j&&j instanceof sap.m.IconTabBar&&j.getUpperCase();r.write("<div role='tablist' ");r.addClass("sapMITH");r.addClass("sapContrastPlus");r.addClass("sapMITHBackgroundDesign"+c.getBackgroundDesign());if(s){r.addClass("sapMITHOverflowList");}if(c._scrollable){r.addClass("sapMITBScrollable");if(c._bPreviousScrollForward){r.addClass("sapMITBScrollForward");}else{r.addClass("sapMITBNoScrollForward");}if(c._bPreviousScrollBack){r.addClass("sapMITBScrollBack");}else{r.addClass("sapMITBNoScrollBack");}}else{r.addClass("sapMITBNotScrollable");}if(u){r.addClass("sapMITBTextUpperCase");}r.writeControlData(c);r.writeClasses();r.write(">");r.renderControl(c._getScrollingArrow("left"));r.write("<div id='"+c.getId()+"-scrollContainer' aria-hidden='true' class='sapMITBScrollContainer'>");r.write("<div id='"+c.getId()+"-head' aria-hidden='true' ");r.addClass("sapMITBHead");if(t){r.addClass("sapMITBTextOnly");}if(n){r.addClass("sapMITBNoText");}if(f){r.addClass("sapMITBInLine");}r.writeClasses();r.write(">");for(var i=0;i<d;i++){o=b[i];o.render(r,e,V);if(o instanceof sap.m.IconTabFilter){g=o.getDesign()===sap.m.IconTabFilterDesign.Horizontal;if(g){h=true;}if(o.getVisible()){e++;}}}r.write("</div>");r.write("</div>");r.renderControl(c._getScrollingArrow("right"));if(s){var O=c._getOverflowButton();if(f){O.addStyleClass('sapMBtnInline');}else if(t){O.addStyleClass('sapMBtnTextOnly');}else if(n||h){O.addStyleClass('sapMBtnNoText');}r.renderControl(O);}r.write("</div>");};
return a;},true);
sap.ui.predefine('sap/m/IconTabSeparator',['jquery.sap.global','./library','sap/ui/core/Element'],function(q,l,E){"use strict";
var I=E.extend("sap.m.IconTabSeparator",{metadata:{interfaces:["sap.m.IconTab"],library:"sap.m",properties:{icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:''},visible:{type:"boolean",group:"Behavior",defaultValue:true},iconDensityAware:{type:"boolean",group:"Appearance",defaultValue:true}}}});
I.prototype._getImageControl=function(c,p){var P={src:this.getIcon(),densityAware:this.getIconDensityAware(),useIconTooltip:false};this._oImageControl=sap.m.ImageHelper.getImageControl(this.getId()+"-icon",this._oImageControl,p,P,c);return this._oImageControl;};
I.prototype.exit=function(e){if(this._oImageControl){this._oImageControl.destroy();}if(sap.ui.core.Item.prototype.exit){sap.ui.core.Item.prototype.exit.call(this,e);}};
I.prototype.render=function(r){if(!this.getVisible()){return;}var i=this.getIcon(),a=this.getParent(),b=sap.ui.getCore().getLibraryResourceBundle('sap.m'),c='';if(i){c+='role="img" aria-label="'+b.getText("ICONTABBAR_NEXTSTEP")+'"';}else{c+='role="separator"';}r.write('<div '+c+' ');r.writeElementData(this);r.addClass("sapMITBItem");r.addClass("sapMITBSep");if(!i){r.addClass("sapMITBSepLine");}r.writeClasses();r.write(">");if(i){r.renderControl(this._getImageControl(['sapMITBSepIcon'],a));}r.write("</div>");};
I.prototype.renderInSelectList=function(r,s){};
return I;},true);
sap.ui.predefine('sap/m/Image.designtime',[],function(){"use strict";return{aggregations:{detailBox:{ignore:true}},actions:{remove:{changeType:"hideControl"},reveal:{changeType:"unhideControl"}},name:{singular:"IMAGE_NAME",plural:"IMAGE_NAME_PLURAL"}};},false);
sap.ui.predefine('sap/m/Image',['jquery.sap.global','./library','sap/ui/core/Control'],function(q,l,C){"use strict";
var I=C.extend("sap.m.Image",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.m",properties:{src:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},decorative:{type:"boolean",group:"Accessibility",defaultValue:true},alt:{type:"string",group:"Accessibility",defaultValue:null},useMap:{type:"string",group:"Misc",defaultValue:null},densityAware:{type:"boolean",group:"Misc",defaultValue:true},activeSrc:{type:"sap.ui.core.URI",group:"Data",defaultValue:""},mode:{type:"sap.m.ImageMode",group:"Misc",defaultValue:"Image"},backgroundSize:{type:"string",group:"Appearance",defaultValue:"cover"},backgroundPosition:{type:"string",group:"Appearance",defaultValue:"initial"},backgroundRepeat:{type:"string",group:"Appearance",defaultValue:"no-repeat"}},aggregations:{detailBox:{type:'sap.m.LightBox',multiple:false,bindable:"bindable"}},events:{tap:{},press:{},load:{},error:{}},designTime:true}});
I._currentDevicePixelRatio=(function(){var r=(window.devicePixelRatio===undefined?1:window.devicePixelRatio);if(r<=1){r=1;}else{r*=2;r=Math.round(r);r/=2;}if(r>2){r=2;}return r;}());
I.prototype.onload=function(e){var w,h;if(!this._defaultEventTriggered){this._defaultEventTriggered=true;}this._bVersion2Tried=false;var d=this.$(),D=d[0];if(this.getMode()===sap.m.ImageMode.Background){d.css("background-image","url(\""+this._oImage.src+"\")");}if(!this._isWidthOrHeightSet()){if(this._iLoadImageDensity>1){w=Math.round(D.getBoundingClientRect().width);h=Math.round(D.getBoundingClientRect().height);if((w===D.naturalWidth)&&(h===D.naturalHeight)){d.width(w/this._iLoadImageDensity);}}}d.removeClass("sapMNoImg");this.fireLoad();};
I.prototype.onerror=function(e){if(!this._defaultEventTriggered){this._defaultEventTriggered=true;}var D=this.$(),m=this.getMode(),s=(m===sap.m.ImageMode.Image)?D.attr("src"):this._oImage.src,d=I._currentDevicePixelRatio,c=this._isActiveState?this.getActiveSrc():this.getSrc();D.addClass("sapMNoImg");if(!s||this._iLoadImageDensity===1){D.removeClass("sapMNoImg");this.fireError();return;}if(d===2||d<1){this._iLoadImageDensity=1;this._updateDomSrc(this._generateSrcByDensity(c,1));}else if(d===1.5){if(this._bVersion2Tried){setTimeout(q.proxy(function(){this._iLoadImageDensity=1;this._updateDomSrc(this._generateSrcByDensity(c,1));},this),0);}else{setTimeout(q.proxy(function(){this._iLoadImageDensity=2;this._updateDomSrc(this._generateSrcByDensity(c,2));this._bVersion2Tried=true;},this),0);}}};
I.prototype.setDetailBox=function(L){var c=this.getDetailBox();if(L){if(L===c){return this;}if(c){this.detachPress(this._fnLightBoxOpen,c);}this._fnLightBoxOpen=L.open;this.attachPress(this._fnLightBoxOpen,L);}else if(this._fnLightBoxOpen){this.detachPress(this._fnLightBoxOpen,c);this._fnLightBoxOpen=null;}return this.setAggregation("detailBox",L);};
I.prototype.onBeforeRendering=function(){this._defaultEventTriggered=false;};
I.prototype.onAfterRendering=function(){var d=this.$(),m=this.getMode(),D;if(m===sap.m.ImageMode.Image){d.on("load",q.proxy(this.onload,this));d.on("error",q.proxy(this.onerror,this));D=d[0];}if(m===sap.m.ImageMode.Background){D=this._oImage;}if(D&&D.complete&&!this._defaultEventTriggered){if(D.naturalWidth>0){this.onload({});}else{this.onerror({});}}};
I.prototype.exit=function(){if(this._oImage){q(this._oImage).off("load",this.onload).off("error",this.onerror);this._oImage=null;}else{this.$().off("load",this.onload).off("error",this.onerror);}if(this._fnLightBoxOpen){this._fnLightBoxOpen=null;}};
I.prototype.ontouchstart=function(e){if(e.srcControl.mEventRegistry["press"]||e.srcControl.mEventRegistry["tap"]){e.setMarked();}if(e.targetTouches.length===1&&this.getActiveSrc()){this._updateDomSrc(this._getDensityAwareActiveSrc());this._isActiveState=true;}};
I.prototype.ontouchend=function(e){if(e.targetTouches.length===0&&this.getActiveSrc()){this._isActiveState=false;this._updateDomSrc(this._getDensityAwareSrc());this.$().removeClass("sapMNoImg");}};
I.prototype.setSrc=function(s){if(s===this.getSrc()){return this;}this.setProperty("src",s,true);var d=this.getDomRef();if(d){this._updateDomSrc(this._getDensityAwareSrc());}return this;};
I.prototype.setActiveSrc=function(a){if(!a){a="";}return this.setProperty("activeSrc",a,true);};
I.prototype.attachPress=function(){Array.prototype.unshift.apply(arguments,["press"]);sap.ui.core.Control.prototype.attachEvent.apply(this,arguments);if(this.hasListeners("press")){this.$().attr("tabindex","0");this.$().attr("role","button");}return this;};
I.prototype.detachPress=function(){Array.prototype.unshift.apply(arguments,["press"]);sap.ui.core.Control.prototype.detachEvent.apply(this,arguments);if(!this.hasListeners("press")){this.$().removeAttr("tabindex");if(this.getDecorative()){this.$().attr("role","presentation");}else{this.$().removeAttr("role");}}return this;};
I.prototype.ontap=function(e){this.fireTap({});this.firePress({});};
I.prototype.onkeyup=function(e){if(e.which===q.sap.KeyCodes.SPACE||e.which===q.sap.KeyCodes.ENTER){this.firePress({});e.stopPropagation();}};
I.prototype._updateDomSrc=function(s){var d=this.$(),m=this.getMode();if(d.length){if(m===sap.m.ImageMode.Image){d.attr("src",s);}else{d.addClass("sapMNoImg");q(this._oImage).attr("src",s);}}};
I.prototype._preLoadImage=function(s){if(this.getMode()!==sap.m.ImageMode.Background){return;}var i=q(this._oImage);if(!this._oImage){this._oImage=new window.Image();i=q(this._oImage);i.on("load",q.proxy(this.onload,this)).on("error",q.proxy(this.onerror,this));}this._oImage.src=s;};
I.prototype._isWidthOrHeightSet=function(){return(this.getWidth()&&this.getWidth()!=='')||(this.getHeight()&&this.getHeight()!=='');};
I.prototype._getDensityAwareSrc=function(){var s=this.getSrc(),D=this.getDensityAware(),d=D?I._currentDevicePixelRatio:1;this._iLoadImageDensity=d;if(d===1){return s;}return this._generateSrcByDensity(s,d);};
I.prototype._getDensityAwareActiveSrc=function(){var a=this.getActiveSrc(),D=this.getDensityAware(),d=D?I._currentDevicePixelRatio:1;this._iLoadImageDensity=d;if(d===1){return a;}return this._generateSrcByDensity(a,d);};
I.prototype._generateSrcByDensity=function(s,d){if(!s){return"";}if(this._isDataUri(s)){this._iLoadImageDensity=1;return s;}if(d===1){return s;}var L=s.lastIndexOf("."),i=s.lastIndexOf("/"),n=s.substring(0,L),e=s.substring(L);if(L===-1||(i>L)){return s+"@"+d;}n=n+"@"+d;return n+e;};
I.prototype._isDataUri=function(s){return s?s.indexOf("data:")===0:false;};
I.prototype.getAccessibilityInfo=function(){var h=this.hasListeners("press");if(this.getDecorative()&&!this.getUseMap()&&!h){return null;}return{role:h?"button":"img",type:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText(h?"ACC_CTR_TYPE_BUTTON":"ACC_CTR_TYPE_IMAGE"),description:this.getAlt()||this.getTooltip_AsString()||"",focusable:h};};
I.prototype.getFormDoNotAdjustWidth=function(){return true;};
return I;},true);
sap.ui.predefine('sap/m/ImageContent',['jquery.sap.global','./library','sap/ui/core/Control','sap/m/Image','sap/ui/core/IconPool'],function(q,l,C,I,a){"use strict";
var b=C.extend("sap.m.ImageContent",{metadata:{library:"sap.m",properties:{"src":{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},"description":{type:"string",group:"Accessibility",defaultValue:null}},defaultAggregation:"_content",aggregations:{"_content":{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{"press":{}}}});
b.prototype.onBeforeRendering=function(){var i,u,d;i=this.getAggregation("_content");u=this.getSrc();d=this.getDescription();if(!i||u!==i.getSrc()||d!==i.getAlt()){if(i){i.destroy();i=null;}i=a.createControlByURI({id:this.getId()+"-icon-image",src:u,alt:d,decorative:false},I);this.setAggregation("_content",i,true);this._setPointerOnImage();}if(d){this.setTooltip(d.trim());}};
b.prototype._setPointerOnImage=function(){var i=this.getAggregation("_content");if(i&&this.hasListeners("press")){i.addStyleClass("sapMPointer");}else if(i&&i.hasStyleClass("sapMPointer")){i.removeStyleClass("sapMPointer");}};
b.prototype.ontap=function(e){if(sap.ui.Device.browser.msie){this.$().focus();}this.firePress();};
b.prototype.onkeydown=function(e){if(e.which===q.sap.KeyCodes.ENTER||e.which===q.sap.KeyCodes.SPACE){this.firePress();e.preventDefault();}};
b.prototype.attachEvent=function(e,d,f,c){sap.ui.core.Control.prototype.attachEvent.call(this,e,d,f,c);if(this.hasListeners("press")){this.$().attr("tabindex",0).addClass("sapMPointer");this._setPointerOnImage();}return this;};
b.prototype.detachEvent=function(e,f,c){sap.ui.core.Control.prototype.detachEvent.call(this,e,f,c);if(!this.hasListeners("press")){this.$().removeAttr("tabindex").removeClass("sapMPointer");this._setPointerOnImage();}return this;};
b.prototype.getAltText=function(){var c=this.getAggregation("_content");if(c&&c.getAlt()!==""){return c.getAlt();}else if(c){return c.getAccessibilityInfo().description;}};
return b;});
sap.ui.predefine('sap/m/ImageContentRenderer',[],function(){"use strict";var I={};
I.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapMImageContent");var t=c.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}if(c.hasListeners("press")){r.addClass("sapMPointer");r.writeAttribute("tabindex","0");}r.writeClasses();r.write(">");var C=c.getAggregation("_content");if(C){C.addStyleClass("sapMImageContentImageIcon");r.renderControl(C);}r.write("</div>");};
return I;},true);
sap.ui.predefine('sap/m/ImageRenderer',['jquery.sap.global'],function(q){"use strict";var I={};
I.render=function(r,i){var m=i.getMode(),a=i.getAlt(),t=i.getTooltip_AsString(),h=i.hasListeners("press"),l=i.getDetailBox(),u=i.getUseMap();if(l){r.write("<span class=\"sapMLightBoxImage\"");r.writeControlData(i);r.write(">");r.write("<span class=\"sapMLightBoxMagnifyingGlass\"></span>");}r.write(m===sap.m.ImageMode.Image?"<img":"<span");if(!l){r.writeControlData(i);}if(m===sap.m.ImageMode.Image){r.writeAttributeEscaped("src",i._getDensityAwareSrc());}else{i._preLoadImage(i._getDensityAwareSrc());r.addStyle("background-size",q.sap.encodeHTML(i.getBackgroundSize()));r.addStyle("background-position",q.sap.encodeHTML(i.getBackgroundPosition()));r.addStyle("background-repeat",q.sap.encodeHTML(i.getBackgroundRepeat()));}r.addClass("sapMImg");if(i.hasListeners("press")||i.hasListeners("tap")){r.addClass("sapMPointer");}if(u||!i.getDecorative()||h){r.addClass("sapMImgFocusable");}r.writeClasses();if(u){if(!(q.sap.startsWith(u,"#"))){u="#"+u;}r.writeAttributeEscaped("useMap",u);}if(i.getDecorative()&&!u&&!h){r.writeAttribute("role","presentation");r.writeAttribute("aria-hidden","true");r.write(" alt=''");}else{if(a||t){r.writeAttributeEscaped("alt",a||t);}}if(a||t){r.writeAttributeEscaped("aria-label",a||t);}if(t){r.writeAttributeEscaped("title",t);}if(h){r.writeAttribute("role","button");r.writeAttribute("tabIndex",0);}if(i.getWidth()&&i.getWidth()!=''){r.addStyle("width",i.getWidth());}if(i.getHeight()&&i.getHeight()!=''){r.addStyle("height",i.getHeight());}r.writeStyles();r.write(" />");if(l){r.write("</span>");}};
return I;},true);
sap.ui.predefine('sap/m/Input',['jquery.sap.global','./Bar','./Dialog','./InputBase','./List','./Popover','sap/ui/core/Item','./ColumnListItem','./StandardListItem','./DisplayListItem','sap/ui/core/ListItem','./Table','./Toolbar','./ToolbarSpacer','./library','sap/ui/core/IconPool','sap/ui/core/InvisibleText'],function(q,B,D,I,L,P,a,C,S,b,c,T,d,e,l,f,g){"use strict";
var h=I.extend("sap.m.Input",{metadata:{library:"sap.m",properties:{type:{type:"sap.m.InputType",group:"Data",defaultValue:sap.m.InputType.Text},maxLength:{type:"int",group:"Behavior",defaultValue:0},dateFormat:{type:"string",group:"Misc",defaultValue:'YYYY-MM-dd',deprecated:true},showValueHelp:{type:"boolean",group:"Behavior",defaultValue:false},showSuggestion:{type:"boolean",group:"Behavior",defaultValue:false},valueHelpOnly:{type:"boolean",group:"Behavior",defaultValue:false},filterSuggests:{type:"boolean",group:"Behavior",defaultValue:true},maxSuggestionWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},startSuggestion:{type:"int",group:"Behavior",defaultValue:1},showTableSuggestionValueHelp:{type:"boolean",group:"Behavior",defaultValue:true},description:{type:"string",group:"Misc",defaultValue:null},fieldWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'50%'},valueLiveUpdate:{type:"boolean",group:"Behavior",defaultValue:false},selectedKey:{type:"string",group:"Data",defaultValue:""},textFormatMode:{type:"sap.m.InputTextFormatMode",group:"Misc",defaultValue:sap.m.InputTextFormatMode.Value},textFormatter:{type:"any",group:"Misc",defaultValue:""},suggestionRowValidator:{type:"any",group:"Misc",defaultValue:""},enableSuggestionsHighlighting:{type:"boolean",group:"Behavior",defaultValue:true}},defaultAggregation:"suggestionItems",aggregations:{suggestionItems:{type:"sap.ui.core.Item",multiple:true,singularName:"suggestionItem"},suggestionColumns:{type:"sap.m.Column",multiple:true,singularName:"suggestionColumn",bindable:"bindable"},suggestionRows:{type:"sap.m.ColumnListItem",multiple:true,singularName:"suggestionRow",bindable:"bindable"},_valueHelpIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},associations:{selectedItem:{type:"sap.ui.core.Item",multiple:false},selectedRow:{type:"sap.m.ColumnListItem",multiple:false}},events:{liveChange:{parameters:{value:{type:"string"},escPressed:{type:"boolean"},previousValue:{type:"string"}}},valueHelpRequest:{parameters:{fromSuggestions:{type:"boolean"}}},suggest:{parameters:{suggestValue:{type:"string"},suggestionColumns:{type:"sap.m.ListBase"}}},suggestionItemSelected:{parameters:{selectedItem:{type:"sap.ui.core.Item"},selectedRow:{type:"sap.m.ColumnListItem"}}},submit:{parameters:{value:{type:"string"}}}}}});
f.insertFontFaceStyle();
h._wordStartsWithValue=function(t,v){var i;while(t){if(q.sap.startsWithIgnoreCase(t,v)){return true;}i=t.indexOf(' ');if(i==-1){break;}t=t.substring(i+1);}return false;};
h._DEFAULTFILTER=function(v,i){if(i instanceof c&&h._wordStartsWithValue(i.getAdditionalText(),v)){return true;}return h._wordStartsWithValue(i.getText(),v);};
h._DEFAULTFILTER_TABULAR=function(v,o){var j=o.getCells(),i=0;for(;i<j.length;i++){if(j[i].getText){if(h._wordStartsWithValue(j[i].getText(),v)){return true;}}}return false;};
h._DEFAULTRESULT_TABULAR=function(o){var j=o.getCells(),i=0;for(;i<j.length;i++){if(j[i].getText){return j[i].getText();}}return"";};
h.prototype.init=function(){I.prototype.init.call(this);this._fnFilter=h._DEFAULTFILTER;this._bUseDialog=sap.ui.Device.system.phone;this._bFullScreen=sap.ui.Device.system.phone;this._iSetCount=0;this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");if(!h._sAriaPopupLabelId){h._sAriaPopupLabelId=new g({text:this._oRb.getText("INPUT_AVALIABLE_VALUES")}).toStatic().getId();}};
h.prototype.exit=function(){this._deregisterEvents();this.cancelPendingSuggest();if(this._iRefreshListTimeout){q.sap.clearDelayedCall(this._iRefreshListTimeout);this._iRefreshListTimeout=null;}if(this._oSuggestionPopup){this._oSuggestionPopup.destroy();this._oSuggestionPopup=null;}if(this._oList){this._oList.destroy();this._oList=null;}if(this._oSuggestionTable){this._oSuggestionTable.destroy();this._oSuggestionTable=null;}if(this._oButtonToolbar){this._oButtonToolbar.destroy();this._oButtonToolbar=null;}if(this._oShowMoreButton){this._oShowMoreButton.destroy();this._oShowMoreButton=null;}};
h.prototype._resizePopup=function(){var t=this;if(this._oList&&this._oSuggestionPopup){if(this.getMaxSuggestionWidth()){this._oSuggestionPopup.setContentWidth(this.getMaxSuggestionWidth());}else{this._oSuggestionPopup.setContentWidth((this.$().outerWidth())+"px");}setTimeout(function(){if(t._oSuggestionPopup&&t._oSuggestionPopup.isOpen()&&t._oSuggestionPopup.$().outerWidth()<t.$().outerWidth()){t._oSuggestionPopup.setContentWidth((t.$().outerWidth())+"px");}},0);}};
h.prototype.onBeforeRendering=function(){I.prototype.onBeforeRendering.call(this);this._deregisterEvents();};
h.prototype.onAfterRendering=function(){var t=this;I.prototype.onAfterRendering.call(this);if(!this._bFullScreen){this._resizePopup();this._sPopupResizeHandler=sap.ui.core.ResizeHandler.register(this.getDomRef(),function(){t._resizePopup();});}if(this._bUseDialog&&this.getEditable()){this.$().on("click",q.proxy(function(E){if(this._onclick){this._onclick(E);}if(this.getShowSuggestion()&&this._oSuggestionPopup&&E.target.id!=this.getId()+"-vhi"){this._oSuggestionPopup.open();}},this));}};
h.prototype._getDisplayText=function(i){var t=this.getTextFormatter();if(t){return t(i);}var s=i.getText(),k=i.getKey(),j=this.getTextFormatMode();switch(j){case sap.m.InputTextFormatMode.Key:return k;case sap.m.InputTextFormatMode.ValueKey:return s+' ('+k+')';case sap.m.InputTextFormatMode.KeyValue:return'('+k+') '+s;default:return s;}};
h.prototype._onValueUpdated=function(n){if(this._bSelectingItem||n===this._sSelectedValue){return;}var k=this.getSelectedKey(),H;if(k===''){return;}if(this._hasTabularSuggestions()){H=!!this._oSuggestionTable.getSelectedItem();}else{H=!!this._oList.getSelectedItem();}if(H){return;}this.setProperty("selectedKey",'',true);this.setAssociation("selectedRow",null,true);this.setAssociation("selectedItem",null,true);this.fireSuggestionItemSelected({selectedItem:null,selectedRow:null});};
h.prototype.setSelectionItem=function(i,j){if(!i){this.setAssociation("selectedItem",null,true);this.setProperty("selectedKey",'',true);this.setValue('');return;}this._bSelectingItem=true;var k=this._iSetCount,n;this.setAssociation("selectedItem",i,true);this.setProperty("selectedKey",i.getKey(),true);if(j){this.fireSuggestionItemSelected({selectedItem:i});}if(k!==this._iSetCount){n=this.getValue();}else{n=this._getDisplayText(i);}this._sSelectedValue=n;if(this._bUseDialog){this._oPopupInput.setValue(n);this._oPopupInput._doSelect();}else{this.setDOMValue(this._getInputValue(n));this.onChange();}this._iPopupListSelectedIndex=-1;if(!(this._bUseDialog&&this instanceof sap.m.MultiInput&&this._isMultiLineMode)){this._closeSuggestionPopup();}if(!sap.ui.Device.support.touch){this._doSelect();}this._bSelectingItem=false;};
h.prototype.setSelectedItem=function(i){if(typeof i==="string"){i=sap.ui.getCore().byId(i);}if(i!==null&&!(i instanceof a)){return this;}this.setSelectionItem(i);return this;};
h.prototype.setSelectedKey=function(k){k=this.validateProperty("selectedKey",k);if(this._hasTabularSuggestions()){this.setProperty("selectedKey",k,true);return this;}if(!k){this.setSelectionItem();return this;}var i=this.getSuggestionItemByKey(k);this.setSelectionItem(i);return this;};
h.prototype.getSuggestionItemByKey=function(k){var j=this.getSuggestionItems()||[],o,i;for(i=0;i<j.length;i++){o=j[i];if(o.getKey()===k){return o;}}};
h.prototype.setSelectionRow=function(o,i){if(!o){this.setAssociation("selectedRow",null,true);this.setProperty("selectedKey",'',true);this.setValue('');return;}this._bSelectingItem=true;var j,s=this.getSuggestionRowValidator();if(s){j=s(o);if(!(j instanceof a)){j=null;}}var k=this._iSetCount,K="",n;this.setAssociation("selectedRow",o,true);if(j){K=j.getKey();}this.setProperty("selectedKey",K,true);if(i){this.fireSuggestionItemSelected({selectedRow:o});}if(k!==this._iSetCount){n=this.getValue();}else{if(j){n=this._getDisplayText(j);}else{n=this._fnRowResultFilter(o);}}this._sSelectedValue=n;if(this._bUseDialog){this._oPopupInput.setValue(n);this._oPopupInput._doSelect();}else{this.setDOMValue(this._getInputValue(n));this.onChange();}this._iPopupListSelectedIndex=-1;if(!(this._bUseDialog&&this instanceof sap.m.MultiInput&&this._isMultiLineMode)){this._closeSuggestionPopup();}if(!sap.ui.Device.support.touch){this._doSelect();}this._bSelectingItem=false;};
h.prototype.setSelectedRow=function(o){if(typeof o==="string"){o=sap.ui.getCore().byId(o);}if(o!==null&&!(o instanceof C)){return this;}this.setSelectionRow(o);return this;};
h.prototype._getValueHelpIcon=function(){var t=this,v=this.getAggregation("_valueHelpIcon"),u;if(v){return v;}u=f.getIconURI("value-help");v=f.createControlByURI({id:this.getId()+"-vhi",src:u,useIconTooltip:false,noTabStop:true});v.addStyleClass("sapMInputValHelpInner");v.attachPress(function(i){if(!t.getValueHelpOnly()){this.getParent().focus();t.fireValueHelpRequest({fromSuggestions:false});}});this.setAggregation("_valueHelpIcon",v);return v;};
h.prototype._fireValueHelpRequestForValueHelpOnly=function(){if(this.getEnabled()&&this.getEditable()&&this.getShowValueHelp()&&this.getValueHelpOnly()){this.fireValueHelpRequest({fromSuggestions:false});}};
h.prototype.ontap=function(E){I.prototype.ontap.call(this,E);this._fireValueHelpRequestForValueHelpOnly();};
h.prototype.setWidth=function(w){return I.prototype.setWidth.call(this,w||"100%");};
h.prototype.getWidth=function(){return this.getProperty("width")||"100%";};
h.prototype.setFilterFunction=function(F){if(F===null||F===undefined){this._fnFilter=h._DEFAULTFILTER;return this;}this._fnFilter=F;return this;};
h.prototype.setRowResultFunction=function(F){if(F===null||F===undefined){this._fnRowResultFilter=h._DEFAULTRESULT_TABULAR;return this;}this._fnRowResultFilter=F;return this;};
h.prototype.closeSuggestions=function(){this._closeSuggestionPopup();};
h.prototype.setShowValueHelp=function(s){this.setProperty("showValueHelp",s);if(s&&!h.prototype._sAriaValueHelpLabelId){h.prototype._sAriaValueHelpLabelId=new g({text:this._oRb.getText("INPUT_VALUEHELP")}).toStatic().getId();}return this;};
h.prototype.setValueHelpOnly=function(v){this.setProperty("valueHelpOnly",v);if(v&&!h.prototype._sAriaInputDisabledLabelId){h.prototype._sAriaInputDisabledLabelId=new g({text:this._oRb.getText("INPUT_DISABLED")}).toStatic().getId();}return this;};
h.prototype._doSelect=function(s,E){if(sap.ui.Device.support.touch){return;}var o=this._$input[0];if(o){var r=this._$input;o.focus();r.selectText(s?s:0,E?E:r.val().length);}return this;};
h.prototype._scrollToItem=function(i){var p=this._oSuggestionPopup,o=this._oList,s,j,k,t,m;if(!(p instanceof P)||!o){return;}s=p.getScrollDelegate();if(!s){return;}var n=o.getItems()[i],r=n&&n.getDomRef();if(!r){return;}j=p.getDomRef("cont").getBoundingClientRect();k=r.getBoundingClientRect();t=j.top-k.top;m=k.bottom-j.bottom;if(t>0){s.scrollTo(s._scrollX,Math.max(s._scrollY-t,0));}else if(m>0){s.scrollTo(s._scrollX,s._scrollY+m);}};
h.prototype._isSuggestionItemSelectable=function(i){return i.getVisible()&&(this._hasTabularSuggestions()||i.getType()!==sap.m.ListType.Inactive);};
h.prototype._isIncrementalType=function(){var t=this.getType();if(t==="Number"||t==="Date"||t==="Datetime"||t==="Month"||t==="Time"||t==="Week"){return true;}return false;};
h.prototype._onsaparrowkey=function(E,s,i){if(!this.getEnabled()||!this.getEditable()){return;}if(s!=="up"&&s!=="down"){return;}if(this._isIncrementalType()){E.setMarked();}if(!this._oSuggestionPopup||!this._oSuggestionPopup.isOpen()){return;}E.preventDefault();E.stopPropagation();var F=false,o=this._oList,j=this.getSuggestionItems(),k=o.getItems(),m=this._iPopupListSelectedIndex,n,O=m;if(s==="up"&&m===0){return;}if(s=="down"&&m===k.length-1){return;}var p;if(i>1){if(s=="down"&&m+i>=k.length){s="up";i=1;k[m].setSelected(false);p=m;m=k.length-1;F=true;}else if(s=="up"&&m-i<0){s="down";i=1;k[m].setSelected(false);p=m;m=0;F=true;}}if(m===-1){m=0;if(this._isSuggestionItemSelectable(k[m])){O=m;F=true;}else{s="down";}}if(s==="down"){while(m<k.length-1&&(!F||!this._isSuggestionItemSelectable(k[m]))){k[m].setSelected(false);m=m+i;F=true;i=1;if(p===m){break;}}}else{while(m>0&&(!F||!k[m].getVisible()||!this._isSuggestionItemSelectable(k[m]))){k[m].setSelected(false);m=m-i;F=true;i=1;if(p===m){break;}}}if(!this._isSuggestionItemSelectable(k[m])){if(O>=0){k[O].setSelected(true).updateAccessibilityState();this.$("inner").attr("aria-activedescendant",k[O].getId());}return;}else{k[m].setSelected(true).updateAccessibilityState();this.$("inner").attr("aria-activedescendant",k[m].getId());}if(sap.ui.Device.system.desktop){this._scrollToItem(m);}if(sap.m.ColumnListItem&&k[m]instanceof sap.m.ColumnListItem){n=this._getInputValue(this._fnRowResultFilter(k[m]));}else{var r=(j[0]instanceof c?true:false);if(r){n=this._getInputValue(k[m].getLabel());}else{n=this._getInputValue(k[m].getTitle());}}this.setDOMValue(n);this._sSelectedSuggViaKeyboard=n;this._doSelect();this._iPopupListSelectedIndex=m;};
h.prototype.onsapup=function(E){this._onsaparrowkey(E,"up",1);};
h.prototype.onsapdown=function(E){this._onsaparrowkey(E,"down",1);};
h.prototype.onsappageup=function(E){this._onsaparrowkey(E,"up",5);};
h.prototype.onsappagedown=function(E){this._onsaparrowkey(E,"down",5);};
h.prototype.onsaphome=function(E){if(this._oList){this._onsaparrowkey(E,"up",this._oList.getItems().length);}};
h.prototype.onsapend=function(E){if(this._oList){this._onsaparrowkey(E,"down",this._oList.getItems().length);}};
h.prototype.onsapescape=function(E){var i;if(this._oSuggestionPopup&&this._oSuggestionPopup.isOpen()){E.originalEvent._sapui_handledByControl=true;this._iPopupListSelectedIndex=-1;this._closeSuggestionPopup();if(this._sBeforeSuggest!==undefined){if(this._sBeforeSuggest!==this.getValue()){i=this._lastValue;this.setValue(this._sBeforeSuggest);this._lastValue=i;}this._sBeforeSuggest=undefined;}return;}if(I.prototype.onsapescape){I.prototype.onsapescape.apply(this,arguments);}};
h.prototype.onsapenter=function(E){if(I.prototype.onsapenter){I.prototype.onsapenter.apply(this,arguments);}this.cancelPendingSuggest();if(this._oSuggestionPopup&&this._oSuggestionPopup.isOpen()){var s=this._oList.getSelectedItem();if(s){if(this._hasTabularSuggestions()){this.setSelectionRow(s,true);}else{this.setSelectionItem(s._oItem,true);}}else{if(this._iPopupListSelectedIndex>=0){this._fireSuggestionItemSelectedEvent();this._doSelect();this._iPopupListSelectedIndex=-1;}this._closeSuggestionPopup();}}if(this.getEnabled()&&this.getEditable()&&!(this.getValueHelpOnly()&&this.getShowValueHelp())){this.fireSubmit({value:this.getValue()});}};
h.prototype.onsapfocusleave=function(E){var p=this._oSuggestionPopup;if(p instanceof P){if(E.relatedControlId&&q.sap.containsOrEquals(p.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())){this._bPopupHasFocus=true;this.focus();}else{if(this.getDOMValue()===this._sSelectedSuggViaKeyboard){this._sSelectedSuggViaKeyboard=null;}}}var F=sap.ui.getCore().byId(E.relatedControlId);if(!(p&&F&&q.sap.containsOrEquals(p.getDomRef(),F.getFocusDomRef()))){I.prototype.onsapfocusleave.apply(this,arguments);}};
h.prototype.onmousedown=function(E){var p=this._oSuggestionPopup;if((p instanceof P)&&p.isOpen()){E.stopPropagation();}};
h.prototype._deregisterEvents=function(){if(this._sPopupResizeHandler){sap.ui.core.ResizeHandler.deregister(this._sPopupResizeHandler);this._sPopupResizeHandler=null;}if(this._bUseDialog&&this._oSuggestionPopup){this.$().off("click");}};
h.prototype.updateSuggestionItems=function(){this.updateAggregation("suggestionItems");this._bShouldRefreshListItems=true;this._refreshItemsDelayed();return this;};
h.prototype.cancelPendingSuggest=function(){if(this._iSuggestDelay){q.sap.clearDelayedCall(this._iSuggestDelay);this._iSuggestDelay=null;}};
h.prototype._triggerSuggest=function(v){this.cancelPendingSuggest();this._bShouldRefreshListItems=true;if(!v){v="";}if(v.length>=this.getStartSuggestion()){this._iSuggestDelay=q.sap.delayedCall(300,this,function(){if(this._sPrevSuggValue!==v){this._bBindingUpdated=false;this.fireSuggest({suggestValue:v});if(!this._bBindingUpdated){this._refreshItemsDelayed();}this._sPrevSuggValue=v;}});}else if(this._bUseDialog){if(this._oList instanceof T){this._oList.addStyleClass("sapMInputSuggestionTableHidden");}else if(this._oList&&this._oList.destroyItems){this._oList.destroyItems();}}else if(this._oSuggestionPopup&&this._oSuggestionPopup.isOpen()){q.sap.delayedCall(0,this,function(){var n=this.getDOMValue()||'';if(n<this.getStartSuggestion()){this._iPopupListSelectedIndex=-1;this._closeSuggestionPopup();}});}};
(function(){
h.prototype.setShowSuggestion=function(v){this.setProperty("showSuggestion",v,true);this._iPopupListSelectedIndex=-1;if(v){this._lazyInitializeSuggestionPopup(this);}else{m(this);}return this;};
h.prototype.setShowTableSuggestionValueHelp=function(v){this.setProperty("showTableSuggestionValueHelp",v,true);if(!this._oSuggestionPopup){return this;}if(v){this._addShowMoreButton();}else{this._removeShowMoreButton();}return this;};
h.prototype._getShowMoreButton=function(){var t=this,M=this._oRb;return this._oShowMoreButton||(this._oShowMoreButton=new sap.m.Button({text:M.getText("INPUT_SUGGESTIONS_SHOW_ALL"),press:function(){if(t.getShowTableSuggestionValueHelp()){t.fireValueHelpRequest({fromSuggestions:true});t._iPopupListSelectedIndex=-1;t._closeSuggestionPopup();}}}));};
h.prototype._getButtonToolbar=function(){var s=this._getShowMoreButton();return this._oButtonToolbar||(this._oButtonToolbar=new d({content:[new e(),s]}));};
h.prototype._addShowMoreButton=function(t){if(!this._oSuggestionPopup||!t&&!this._hasTabularSuggestions()){return;}if(this._oSuggestionPopup instanceof D){var s=this._getShowMoreButton();this._oSuggestionPopup.setEndButton(s);}else{var i=this._getButtonToolbar();this._oSuggestionPopup.setFooter(i);}};
h.prototype._removeShowMoreButton=function(){if(!this._oSuggestionPopup||!this._hasTabularSuggestions()){return;}if(this._oSuggestionPopup instanceof D){this._oSuggestionPopup.setEndButton(null);}else{this._oSuggestionPopup.setFooter(null);}};
h.prototype.oninput=function(E){I.prototype.oninput.call(this,E);if(E.isMarked("invalid")){return;}var v=this.getDOMValue();if(this.getValueLiveUpdate()){this.setProperty("value",v,true);this._onValueUpdated(v);}this.fireLiveChange({value:v,newValue:v});if(this.getShowSuggestion()&&!this._bUseDialog){this._triggerSuggest(v);}};
h.prototype.getValue=function(){return this.getDomRef("inner")&&this._$input?this.getDOMValue():this.getProperty("value");};
h.prototype._refreshItemsDelayed=function(){q.sap.clearDelayedCall(this._iRefreshListTimeout);this._iRefreshListTimeout=q.sap.delayedCall(0,this,r,[this]);};
h.prototype.addSuggestionItem=function(i){this.addAggregation("suggestionItems",i,true);this._bShouldRefreshListItems=true;this._refreshItemsDelayed();k(this);return this;};
h.prototype.insertSuggestionItem=function(i,n){this.insertAggregation("suggestionItems",n,i,true);this._bShouldRefreshListItems=true;this._refreshItemsDelayed();k(this);return this;};
h.prototype.removeSuggestionItem=function(i){var n=this.removeAggregation("suggestionItems",i,true);this._bShouldRefreshListItems=true;this._refreshItemsDelayed();return n;};
h.prototype.removeAllSuggestionItems=function(){var i=this.removeAllAggregation("suggestionItems",true);this._bShouldRefreshListItems=true;this._refreshItemsDelayed();return i;};
h.prototype.destroySuggestionItems=function(){this.destroyAggregation("suggestionItems",true);this._bShouldRefreshListItems=true;this._refreshItemsDelayed();return this;};
h.prototype.addSuggestionRow=function(i){i.setType(sap.m.ListType.Active);this.addAggregation("suggestionRows",i);this._bShouldRefreshListItems=true;this._refreshItemsDelayed();k(this);return this;};
h.prototype.insertSuggestionRow=function(i,n){i.setType(sap.m.ListType.Active);this.insertAggregation("suggestionRows",n,i);this._bShouldRefreshListItems=true;this._refreshItemsDelayed();k(this);return this;};
h.prototype.removeSuggestionRow=function(i){var n=this.removeAggregation("suggestionRows",i);this._bShouldRefreshListItems=true;this._refreshItemsDelayed();return n;};
h.prototype.removeAllSuggestionRows=function(){var i=this.removeAllAggregation("suggestionRows");this._bShouldRefreshListItems=true;this._refreshItemsDelayed();return i;};
h.prototype.destroySuggestionRows=function(){this.destroyAggregation("suggestionRows");this._bShouldRefreshListItems=true;this._refreshItemsDelayed();return this;};
h.prototype.bindAggregation=function(){var i=Array.prototype.slice.call(arguments);if(i[0]==="suggestionRows"||i[0]==="suggestionColumns"||i[0]==="suggestionItems"){k(this,i[0]==="suggestionRows"||i[0]==="suggestionColumns");this._bBindingUpdated=true;}this._callMethodInManagedObject.apply(this,["bindAggregation"].concat(i));return this;};
h.prototype._lazyInitializeSuggestionPopup=function(){if(!this._oSuggestionPopup){j(this);}};
h.prototype._closeSuggestionPopup=function(){if(this._oSuggestionPopup){this._bShouldRefreshListItems=false;this.cancelPendingSuggest();this._oSuggestionPopup.close();this.$("SuggDescr").text("");this.$("inner").removeAttr("aria-haspopup");this.$("inner").removeAttr("aria-activedescendant");this._sPrevSuggValue=null;}};
function j(i){var M=i._oRb;if(i._bUseDialog){i._oPopupInput=new h(i.getId()+"-popup-input",{width:"100%",valueLiveUpdate:true,showValueHelp:i.getShowValueHelp(),valueHelpRequest:function(E){i.fireValueHelpRequest({fromSuggestions:true});i._iPopupListSelectedIndex=-1;i._closeSuggestionPopup();},liveChange:function(E){var v=E.getParameter("newValue");i.setDOMValue(i._getInputValue(i._oPopupInput.getValue()));i._triggerSuggest(v);i.fireLiveChange({value:v,newValue:v});}}).addStyleClass("sapMInputSuggInDialog");}i._oSuggestionPopup=!i._bUseDialog?(new P(i.getId()+"-popup",{showArrow:false,showHeader:false,placement:sap.m.PlacementType.Vertical,initialFocus:i,horizontalScrolling:true}).attachAfterClose(function(){if(i._iPopupListSelectedIndex>=0){i._fireSuggestionItemSelectedEvent();}if(i._oList instanceof T){i._oList.removeSelections(true);}else{i._oList.destroyItems();}}).attachBeforeOpen(function(){i._sBeforeSuggest=i.getValue();})):(new D(i.getId()+"-popup",{beginButton:new sap.m.Button(i.getId()+"-popup-closeButton",{text:M.getText("MSGBOX_CLOSE"),press:function(){i._closeSuggestionPopup();}}),stretch:i._bFullScreen,contentHeight:i._bFullScreen?undefined:"20rem",customHeader:new B(i.getId()+"-popup-header",{contentMiddle:i._oPopupInput.addEventDelegate({onsapenter:function(){if(!(sap.m.MultiInput&&i instanceof sap.m.MultiInput)){i._closeSuggestionPopup();}}},this)}),horizontalScrolling:false,initialFocus:i._oPopupInput}).attachBeforeOpen(function(){i._oPopupInput.setPlaceholder(i.getPlaceholder());i._oPopupInput.setMaxLength(i.getMaxLength());}).attachBeforeClose(function(){i.setDOMValue(i._getInputValue(i._oPopupInput.getValue()));i.onChange();if(i instanceof sap.m.MultiInput&&i._bUseDialog){i._onDialogClose();}}).attachAfterClose(function(){if(i instanceof sap.m.MultiInput&&i._isMultiLineMode){i._showIndicator();}if(i._oList){if(T&&!(i._oList instanceof T)){i._oList.destroyItems();}else{i._oList.removeSelections(true);}}}).attachAfterOpen(function(){var v=i.getValue();i._oPopupInput.setValue(v);i._triggerSuggest(v);r(i);}));i._oSuggestionPopup.addStyleClass("sapMInputSuggestionPopup");i._oSuggestionPopup.addAriaLabelledBy(h._sAriaPopupLabelId);i.addDependent(i._oSuggestionPopup);if(!i._bUseDialog){o(i._oSuggestionPopup,i);}if(i._oList){i._oSuggestionPopup.addContent(i._oList);}if(i.getShowTableSuggestionValueHelp()){i._addShowMoreButton();}}
function k(i,t){if(i._oList){return;}if(!i._hasTabularSuggestions()&&!t){i._oList=new L(i.getId()+"-popup-list",{width:"100%",showNoData:false,mode:sap.m.ListMode.SingleSelectMaster,rememberSelections:false,itemPress:function(E){var p=E.getParameter("listItem");i.setSelectionItem(p._oItem,true);}});i._oList.addEventDelegate({onAfterRendering:i._highlightListText.bind(i)});}else{if(i._fnFilter===h._DEFAULTFILTER){i._fnFilter=h._DEFAULTFILTER_TABULAR;}if(!i._fnRowResultFilter){i._fnRowResultFilter=h._DEFAULTRESULT_TABULAR;}i._oList=i._getSuggestionsTable();if(i.getShowTableSuggestionValueHelp()){i._addShowMoreButton(t);}}if(i._oSuggestionPopup){if(i._bUseDialog){i._oSuggestionPopup.addAggregation("content",i._oList,true);var R=i._oSuggestionPopup.$("scrollCont")[0];if(R){var n=sap.ui.getCore().createRenderManager();n.renderControl(i._oList);n.flush(R);n.destroy();}}else{i._oSuggestionPopup.addContent(i._oList);}}}
function m(i){if(i._oSuggestionPopup){if(i._oList instanceof T){i._oSuggestionPopup.removeAllContent();i._removeShowMoreButton();}i._oSuggestionPopup.destroy();i._oSuggestionPopup=null;}if(i._oList instanceof L){i._oList.destroy();i._oList=null;}}
function o(p,i){p.open=function(){this.openBy(i,false,true);};p.oPopup.setAnimations(function(R,n,O){O();},function(R,n,s){s();});}
function r(n){var s=n.getShowSuggestion();var R=n._oRb;n._iPopupListSelectedIndex=-1;if(!s||!n._bShouldRefreshListItems||!n.getDomRef()||(!n._bUseDialog&&!n.$().hasClass("sapMInputFocused"))){return false;}var p,t=n.getSuggestionItems(),u=n.getSuggestionRows(),v=n.getDOMValue()||"",w=n._oList,F=n.getFilterSuggests(),H=[],x=0,y=n._oSuggestionPopup,z={ontouchstart:function(J){(J.originalEvent||J)._sapui_cancelAutoClose=true;}},A,i;if(n._oList){if(n._oList instanceof T){w.removeSelections(true);}else{w.destroyItems();}}if(v.length<n.getStartSuggestion()){if(!n._bUseDialog){n._iPopupListSelectedIndex=-1;this.cancelPendingSuggest();y.close();}else{if(n._hasTabularSuggestions()&&n._oList){n._oList.addStyleClass("sapMInputSuggestionTableHidden");}}n.$("SuggDescr").text("");n.$("inner").removeAttr("aria-haspopup");n.$("inner").removeAttr("aria-activedescendant");return false;}if(n._hasTabularSuggestions()){if(n._bUseDialog&&n._oList){n._oList.removeStyleClass("sapMInputSuggestionTableHidden");}for(i=0;i<u.length;i++){if(!F||n._fnFilter(v,u[i])){u[i].setVisible(true);H.push(u[i]);}else{u[i].setVisible(false);}}n._oSuggestionTable.invalidate();}else{var E=(t[0]instanceof c?true:false);for(i=0;i<t.length;i++){p=t[i];if(!F||n._fnFilter(v,p)){if(E){A=new b(p.getId()+"-dli");A.setLabel(p.getText());A.setValue(p.getAdditionalText());}else{A=new S(p.getId()+"-sli");A.setTitle(p.getText());}A.setType(p.getEnabled()?sap.m.ListType.Active:sap.m.ListType.Inactive);A._oItem=p;A.addEventDelegate(z);H.push(A);}}}x=H.length;var G="";if(x>0){if(x==1){G=R.getText("INPUT_SUGGESTIONS_ONE_HIT");}else{G=R.getText("INPUT_SUGGESTIONS_MORE_HITS",x);}n.$("inner").attr("aria-haspopup","true");if(!n._hasTabularSuggestions()){for(i=0;i<x;i++){w.addItem(H[i]);}}if(!n._bUseDialog){if(n._sCloseTimer){clearTimeout(n._sCloseTimer);n._sCloseTimer=null;}if(!y.isOpen()&&!n._sOpenTimer&&(this.getValue().length>=this.getStartSuggestion())){n._sOpenTimer=setTimeout(function(){n._resizePopup();n._sOpenTimer=null;y.open();},0);}}}else{G=R.getText("INPUT_SUGGESTIONS_NO_HIT");n.$("inner").removeAttr("aria-haspopup");n.$("inner").removeAttr("aria-activedescendant");if(!n._bUseDialog){if(y.isOpen()){n._sCloseTimer=setTimeout(function(){n._iPopupListSelectedIndex=-1;n.cancelPendingSuggest();y.close();},0);}}else{if(n._hasTabularSuggestions()&&n._oList){n._oList.addStyleClass("sapMInputSuggestionTableHidden");}}}n.$("SuggDescr").text(G);}
})();
h.prototype._createHighlightedText=function(i){var t=i.innerText,v=this.getValue().toLowerCase(),j=v.length,k=t.toLowerCase(),s,n='';if(!h._wordStartsWithValue(t,v)){return t;}var m=k.indexOf(v);if(m>0){m=k.indexOf(' '+v)+1;}if(m>-1){n+=t.substring(0,m);s=t.substring(m,m+j);n+='<span class="sapMInputHighlight">'+s+'</span>';n+=t.substring(m+j);}else{n=t;}return n;};
h.prototype._highlightListText=function(){if(!this.getEnableSuggestionsHighlighting()){return;}var i,j,k=this._oList.$().find('.sapMDLILabel, .sapMSLITitleOnly, .sapMDLIValue');for(i=0;i<k.length;i++){j=k[i];j.innerHTML=this._createHighlightedText(j);}};
h.prototype._highlightTableText=function(){if(!this.getEnableSuggestionsHighlighting()){return;}var i,j,k=this._oSuggestionTable.$().find('tbody .sapMLabel');for(i=0;i<k.length;i++){j=k[i];j.innerHTML=this._createHighlightedText(j);}};
h.prototype.onfocusin=function(E){I.prototype.onfocusin.apply(this,arguments);this.$().addClass("sapMInputFocused");if(!this._bPopupHasFocus&&!this.getStartSuggestion()&&!this.getValue()){this._triggerSuggest(this.getValue());}this._bPopupHasFocus=undefined;this._sPrevSuggValue=null;};
h.prototype.onsapshow=function(E){if(!this.getEnabled()||!this.getEditable()||!this.getShowValueHelp()){return;}this.fireValueHelpRequest({fromSuggestions:false});E.preventDefault();E.stopPropagation();};
h.prototype.onsaphide=h.prototype.onsapshow;
h.prototype.onsapselect=function(E){this._fireValueHelpRequestForValueHelpOnly();};
h.prototype.onfocusout=function(E){I.prototype.onfocusout.apply(this,arguments);this.$().removeClass("sapMInputFocused");this.closeValueStateMessage(this);};
h.prototype._hasTabularSuggestions=function(){return!!(this.getAggregation("suggestionColumns")&&this.getAggregation("suggestionColumns").length);};
h.prototype._getSuggestionsTable=function(){var t=this;if(!this._oSuggestionTable){this._oSuggestionTable=new T(this.getId()+"-popup-table",{mode:sap.m.ListMode.SingleSelectMaster,showNoData:false,showSeparators:"All",width:"100%",enableBusyIndicator:false,rememberSelections:false,selectionChange:function(E){var s=E.getParameter("listItem");t.setSelectionRow(s,true);}});this._oSuggestionTable.addEventDelegate({onAfterRendering:this._highlightTableText.bind(this)});if(this._bUseDialog){this._oSuggestionTable.addStyleClass("sapMInputSuggestionTableHidden");}this._oSuggestionTable.updateItems=function(){T.prototype.updateItems.apply(this,arguments);t._refreshItemsDelayed();return this;};}return this._oSuggestionTable;};
h.prototype._fireSuggestionItemSelectedEvent=function(){if(this._iPopupListSelectedIndex>=0){var s=this._oList.getItems()[this._iPopupListSelectedIndex];if(s){if(sap.m.ColumnListItem&&s instanceof sap.m.ColumnListItem){this.fireSuggestionItemSelected({selectedRow:s});}else{this.fireSuggestionItemSelected({selectedItem:s._oItem});}}this._iPopupListSelectedIndex=-1;}};
h.prototype._callMethodInManagedObject=function(F,A){var i=Array.prototype.slice.call(arguments),s;if(A==="suggestionColumns"){s=this._getSuggestionsTable();return s[F].apply(s,["columns"].concat(i.slice(2)));}else if(A==="suggestionRows"){s=this._getSuggestionsTable();return s[F].apply(s,["items"].concat(i.slice(2)));}else{return sap.ui.core.Control.prototype[F].apply(this,i.slice(1));}};
h.prototype.validateAggregation=function(A,o,m){return this._callMethodInManagedObject("validateAggregation",A,o,m);};
h.prototype.setAggregation=function(A,o,s){this._callMethodInManagedObject("setAggregation",A,o,s);return this;};
h.prototype.getAggregation=function(A,o){return this._callMethodInManagedObject("getAggregation",A,o);};
h.prototype.indexOfAggregation=function(A,o){return this._callMethodInManagedObject("indexOfAggregation",A,o);};
h.prototype.insertAggregation=function(A,o,i,s){this._callMethodInManagedObject("insertAggregation",A,o,i,s);return this;};
h.prototype.addAggregation=function(A,o,s){this._callMethodInManagedObject("addAggregation",A,o,s);return this;};
h.prototype.removeAggregation=function(A,o,s){return this._callMethodInManagedObject("removeAggregation",A,o,s);};
h.prototype.removeAllAggregation=function(A,s){return this._callMethodInManagedObject("removeAllAggregation",A,s);};
h.prototype.destroyAggregation=function(A,s){this._callMethodInManagedObject("destroyAggregation",A,s);return this;};
h.prototype.getBinding=function(A){return this._callMethodInManagedObject("getBinding",A);};
h.prototype.getBindingInfo=function(A){return this._callMethodInManagedObject("getBindingInfo",A);};
h.prototype.getBindingPath=function(A){return this._callMethodInManagedObject("getBindingPath",A);};
h.prototype.clone=function(){var i=sap.ui.core.Control.prototype.clone.apply(this,arguments),j;j=this.getBindingInfo("suggestionColumns");if(j){i.bindAggregation("suggestionColumns",q.extend({},j));}else{this.getSuggestionColumns().forEach(function(o){i.addSuggestionColumn(o.clone(),true);});}j=this.getBindingInfo("suggestionRows");if(j){i.bindAggregation("suggestionRows",q.extend({},j));}else{this.getSuggestionRows().forEach(function(r){i.addSuggestionRow(r.clone(),true);});}return i;};
h.prototype.setValue=function(v){this._iSetCount++;I.prototype.setValue.call(this,v);this._onValueUpdated(v);return this;};
h.prototype.setDOMValue=function(v){this._$input.val(v);};
h.prototype.getDOMValue=function(){return this._$input.val();};
h.prototype.getAccessibilityInfo=function(){var i=I.prototype.getAccessibilityInfo.apply(this,arguments);i.description=((i.description||"")+" "+this.getDescription()).trim();return i;};
return h;},true);
sap.ui.predefine('sap/m/InputBase.designtime',[],function(){"use strict";return{actions:{remove:{changeType:"hideControl"},reveal:{changeType:"unhideControl"}},name:{singular:"INPUT_BASE_NAME",plural:"INPUT_BASE_NAME_PLURAL"}};},false);
sap.ui.predefine('sap/m/InputBase',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/EnabledPropagator','sap/ui/core/IconPool','sap/ui/core/Popup','./delegate/ValueStateMessage','sap/ui/core/message/MessageMixin'],function(q,l,C,E,I,P,V,M){"use strict";
var a=C.extend("sap.m.InputBase",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.m",properties:{value:{type:"string",group:"Data",defaultValue:null,bindable:"bindable"},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:sap.ui.core.ValueState.None},name:{type:"string",group:"Misc",defaultValue:null},placeholder:{type:"string",group:"Misc",defaultValue:null},editable:{type:"boolean",group:"Behavior",defaultValue:true},valueStateText:{type:"string",group:"Misc",defaultValue:null},showValueStateMessage:{type:"boolean",group:"Misc",defaultValue:true},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:sap.ui.core.TextAlign.Initial},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit},required:{type:"boolean",group:"Misc",defaultValue:false}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{change:{parameters:{value:{type:"string"}}}},designTime:true}});
E.call(a.prototype);I.insertFontFaceStyle();M.call(a.prototype);a.prototype.bShowLabelAsPlaceholder=!sap.ui.Device.support.input.placeholder;
a.prototype._getPlaceholder=function(){return this.getPlaceholder();};
a.prototype._setLabelVisibility=function(){if(!this.bShowLabelAsPlaceholder){return;}var v=this.$("inner").val();this.$("placeholder").css("display",v?"none":"inline");};
a.prototype._getInputValue=function(v){v=(v===undefined)?this.$("inner").val()||"":v.toString();if(this.getMaxLength&&this.getMaxLength()>0){v=v.substring(0,this.getMaxLength());}return v;};
a.prototype._getInputElementTagName=function(){if(!this._sInputTagElementName){this._sInputTagElementName=this._$input&&this._$input.get(0)&&this._$input.get(0).tagName;}return this._sInputTagElementName;};
a.prototype.init=function(){this._lastValue="";this.bRenderingPhase=false;this.bFocusoutDueRendering=false;this._bIgnoreNextInputEventNonASCII=false;this._oValueStateMessage=new V(this);};
a.prototype.onBeforeRendering=function(){if(this._bCheckDomValue&&!this.bRenderingPhase){this._sDomValue=this._getInputValue();}this.bRenderingPhase=true;};
a.prototype.onAfterRendering=function(){if(this._bCheckDomValue&&this._sDomValue!==this._getInputValue()){this.$("inner").val(this._sDomValue);}this._bCheckDomValue=false;this._setLabelVisibility();this.bRenderingPhase=false;};
a.prototype.exit=function(){if(this._oValueStateMessage){this._oValueStateMessage.destroy();}this._oValueStateMessage=null;};
a.prototype.ontouchstart=function(e){e.setMarked();};
a.prototype.onfocusin=function(e){this._bIgnoreNextInput=!this.bShowLabelAsPlaceholder&&sap.ui.Device.browser.msie&&sap.ui.Device.browser.version>9&&!!this.getPlaceholder()&&!this._getInputValue()&&this._getInputElementTagName()==="INPUT";this.$().toggleClass("sapMFocus",true);if(this.shouldValueStateMessageBeOpened()){this.openValueStateMessage();}};
a.prototype.onfocusout=function(e){this.bFocusoutDueRendering=this.bRenderingPhase;this.$().toggleClass("sapMFocus",false);if(this.bRenderingPhase){return;}this.closeValueStateMessage();};
a.prototype.onsapfocusleave=function(e){if(!this.preventChangeOnFocusLeave(e)){this.onChange(e);}};
a.prototype.preventChangeOnFocusLeave=function(e){return this.bFocusoutDueRendering;};
a.prototype.getChangeEventParams=function(){return{};};
a.prototype.ontap=function(e){if(this.getEnabled()&&this.getEditable()&&this.bShowLabelAsPlaceholder&&e.target.id===this.getId()+"-placeholder"){this.focus();}};
a.prototype.onChange=function(e,p){p=p||this.getChangeEventParams();if(!this.getEditable()||!this.getEnabled()){return;}var v=this._getInputValue();if(v!==this._lastValue){this.setValue(v);if(e){this._bIgnoreNextInputEventNonASCII=false;}v=this.getValue();this._lastValue=v;this.fireChangeEvent(v,p);return true;}else{this._bCheckDomValue=false;}};
a.prototype.fireChangeEvent=function(v,p){var c=q.extend({value:v,newValue:v},p);this.fireChange(c);};
a.prototype.onValueRevertedByEscape=function(v,p){this.fireEvent("liveChange",{value:v,escPressed:true,previousValue:p,newValue:v});};
a.prototype.onsapenter=function(e){this.onChange(e);};
a.prototype.onsapescape=function(e){var v=this._getInputValue();if(v!==this._lastValue){e.setMarked();e.preventDefault();this.updateDomValue(this._lastValue);this.onValueRevertedByEscape(this._lastValue,v);}};
a.prototype.oninput=function(e){if(this._bIgnoreNextInput){this._bIgnoreNextInput=false;e.setMarked("invalid");return;}if(!this.getEditable()){e.setMarked("invalid");return;}if(this._bIgnoreNextInputEventNonASCII&&this.getValue()===this._lastValue){this._bIgnoreNextInputEventNonASCII=false;e.setMarked("invalid");return;}if(document.activeElement!==e.target&&sap.ui.Device.browser.msie&&this.getValue()===this._lastValue){e.setMarked("invalid");return;}this._bCheckDomValue=true;this._setLabelVisibility();};
a.prototype.onkeydown=function(e){if(this.getDomRef("inner").getAttribute("readonly")&&e.keyCode==q.sap.KeyCodes.BACKSPACE){e.preventDefault();}};
a.prototype.oncut=function(e){};
a.prototype.selectText=function(s,S){this.$("inner").selectText(s,S);return this;};
a.prototype.getSelectedText=function(){return this.$("inner").getSelectedText();};
a.prototype.setProperty=function(p,v,s){if(p=="value"){this._bCheckDomValue=false;}return C.prototype.setProperty.apply(this,arguments);};
a.prototype.getFocusInfo=function(){var f=C.prototype.getFocusInfo.call(this),F=this.getFocusDomRef();q.extend(f,{cursorPos:0,selectionStart:0,selectionEnd:0});if(F){f.cursorPos=q(F).cursorPos();try{f.selectionStart=F.selectionStart;f.selectionEnd=F.selectionEnd;}catch(e){}}return f;};
a.prototype.applyFocusInfo=function(f){C.prototype.applyFocusInfo.call(this,f);this.$("inner").cursorPos(f.cursorPos);this.selectText(f.selectionStart,f.selectionEnd);return this;};
a.prototype.bindToInputEvent=function(c){if(this._oInputEventDelegate){this.removeEventDelegate(this._oInputEventDelegate);}this._oInputEventDelegate={oninput:c};return this.addEventDelegate(this._oInputEventDelegate);};
a.prototype.updateDomValue=function(v){if(!this.isActive()){return this;}v=this._getInputValue(v);if(sap.ui.Device.browser.msie&&sap.ui.Device.browser.version>9&&!/^[\x00-\x7F]*$/.test(v)){this._bIgnoreNextInput=true;}if(this._getInputValue()!==v){this.$("inner").val(v);this._bCheckDomValue=true;}this._setLabelVisibility();return this;};
a.prototype.closeValueStateMessage=function(){if(this._oValueStateMessage){this._oValueStateMessage.close();}};
a.prototype.getDomRefForValueStateMessage=function(){return this.getFocusDomRef();};
a.prototype.iOpenMessagePopupDuration=0;
a.prototype.getValueStateMessageId=function(){return this.getId()+"-message";};
a.prototype.getLabels=function(){var L=this.getAriaLabelledBy().map(function(s){return sap.ui.getCore().byId(s);});var o=sap.ui.require("sap/ui/core/LabelEnablement");if(o){L=L.concat(o.getReferencingLabels(this).map(function(s){return sap.ui.getCore().byId(s);}));}return L;};
a.prototype.openValueStateMessage=function(){if(this._oValueStateMessage){this._oValueStateMessage.open();}};
a.prototype.updateValueStateClasses=function(v,o){var t=this.$(),i=this.$("inner"),m=sap.ui.core.ValueState;if(o!==m.None){t.removeClass("sapMInputBaseState sapMInputBase"+o);i.removeClass("sapMInputBaseStateInner sapMInputBase"+o+"Inner");}if(v!==m.None){t.addClass("sapMInputBaseState sapMInputBase"+v);i.addClass("sapMInputBaseStateInner sapMInputBase"+v+"Inner");}};
a.prototype.shouldValueStateMessageBeOpened=function(){return((this.getValueState()!==sap.ui.core.ValueState.None)&&this.getEditable()&&this.getEnabled()&&this.getShowValueStateMessage());};
a.prototype.setValueState=function(v){var o=this.getValueState();this.setProperty("valueState",v,true);v=this.getValueState();if(v===o){return this;}var d=this.getDomRef();if(!d){return this;}var i=this.$("inner"),m=sap.ui.core.ValueState;if(v===m.Error){i.attr("aria-invalid","true");}else{i.removeAttr("aria-invalid");}this.updateValueStateClasses(v,o);if(i[0]===document.activeElement){if(v===m.None){this.closeValueStateMessage();}else if(this.shouldValueStateMessageBeOpened()){this.openValueStateMessage();}}return this;};
a.prototype.setValueStateText=function(t){this.setProperty("valueStateText",t,true);this.$("message").text(this.getValueStateText());return this;};
a.prototype.setValue=function(v){v=this.validateProperty("value",v);v=this._getInputValue(v);this.updateDomValue(v);if(sap.ui.Device.browser.msie&&sap.ui.Device.browser.version>9&&!/^[\x00-\x7F]*$/.test(v)){this._bIgnoreNextInputEventNonASCII=true;}if(v!==this.getProperty("value")){this._lastValue=v;}this.setProperty("value",v,true);return this;};
a.prototype.getFocusDomRef=function(){return this.getDomRef("inner");};
a.prototype.getIdForLabel=function(){return this.getId()+"-inner";};
a.prototype.setTooltip=function(t){var d=this.getDomRef();this._refreshTooltipBaseDelegate(t);this.setAggregation("tooltip",t,true);if(!d){return this;}var T=this.getTooltip_AsString();if(T){d.setAttribute("title",T);}else{d.removeAttribute("title");}if(sap.ui.getCore().getConfiguration().getAccessibility()){var D=this.getDomRef("describedby"),A=this.getRenderer().getDescribedByAnnouncement(this),s=this.getId()+"-describedby",b="aria-describedby",f=this.getFocusDomRef(),c=f.getAttribute(b);if(!D&&A){D=document.createElement("span");D.id=s;D.setAttribute("aria-hidden","true");D.className="sapUiInvisibleText";if(this.getAriaDescribedBy){f.setAttribute(b,(this.getAriaDescribedBy().join(" ")+" "+s).trim());}else{f.setAttribute(b,s);}d.appendChild(D);}else if(D&&!A){d.removeChild(D);var e=D.id;if(c&&e){f.setAttribute(b,c.replace(e,"").trim());}}if(D){D.textContent=A;}}return this;};
a.prototype.getAccessibilityInfo=function(){var r=this.getRenderer();return{role:r.getAriaRole(this),type:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_INPUT"),description:[this.getValue()||"",r.getLabelledByAnnouncement(this),r.getDescribedByAnnouncement(this)].join(" ").trim(),focusable:this.getEnabled(),enabled:this.getEnabled(),editable:this.getEnabled()&&this.getEditable()};};
Object.defineProperty(a.prototype,"_$input",{get:function(){return this.$("inner");}});return a;},true);
sap.ui.predefine('sap/m/InputBaseRenderer',['jquery.sap.global','sap/ui/core/Renderer','sap/ui/core/ValueStateSupport'],function(q,R,V){"use strict";var I={};
I.render=function(r,c){var v=c.getValueState(),t=c.getTextDirection(),T=R.getTextAlign(c.getTextAlign(),t),a=sap.ui.getCore().getConfiguration().getAccessibility();r.write("<div");r.writeControlData(c);this.addOuterStyles(r,c);this.addControlWidth(r,c);r.writeStyles();r.addClass("sapMInputBase");this.addPaddingClass(r,c);this.addCursorClass(r,c);this.addOuterClasses(r,c);if(!c.getEnabled()){r.addClass("sapMInputBaseDisabled");}if(!c.getEditable()){r.addClass("sapMInputBaseReadonly");}if(v!==sap.ui.core.ValueState.None){this.addValueStateClasses(r,c);}r.writeClasses();this.writeOuterAttributes(r,c);var s=c.getTooltip_AsString();if(s){r.writeAttributeEscaped("title",s);}r.write(">");this.prependInnerContent(r,c);if(c.bShowLabelAsPlaceholder){r.write("<span");r.writeAttribute("id",c.getId()+"-placeholder");if(T){r.addStyle("text-align",T);}this.addPlaceholderClasses(r,c);this.addPlaceholderStyles(r,c);r.writeClasses();r.writeStyles();r.write(">");r.writeEscaped(c._getPlaceholder());r.write("</span>");}r.write('<div ');r.addClass("sapMInputDivWrapper");if(!c.getEnabled()){r.addClass("sapMInputBaseDisabledInner");}else if(!c.getEditable()){r.addClass("sapMInputBaseReadonlyInner");}r.writeClasses();this.addWrapperStyles(r,c);r.writeStyles();r.write('>');this.openInputTag(r,c);this.writeInnerId(r,c);if(c.getName()){r.writeAttributeEscaped("name",c.getName());}if(!c.bShowLabelAsPlaceholder&&c._getPlaceholder()){r.writeAttributeEscaped("placeholder",c._getPlaceholder());}if(c.getMaxLength&&c.getMaxLength()>0){r.writeAttribute("maxlength",c.getMaxLength());}if(!c.getEnabled()){r.writeAttribute("disabled","disabled");}else if(!c.getEditable()){r.writeAttribute("readonly","readonly");}if(t!=sap.ui.core.TextDirection.Inherit){r.writeAttribute("dir",t.toLowerCase());}this.writeInnerValue(r,c);if(a){this.writeAccessibilityState(r,c);}if(sap.ui.Device.browser.mozilla){if(s){r.writeAttributeEscaped("x-moz-errormessage",s);}else{r.writeAttribute("x-moz-errormessage"," ");}}this.writeInnerAttributes(r,c);r.addClass("sapMInputBaseInner");if(v!==sap.ui.core.ValueState.None){this.addValueStateInnerClasses(r,c);}this.addInnerClasses(r,c);r.writeClasses();if(T){r.addStyle("text-align",T);}this.addInnerStyles(r,c);r.writeStyles();r.write(">");this.writeInnerContent(r,c);this.closeInputTag(r,c);r.write('</div>');this.writeDecorations(r,c);if(a){this.renderAriaLabelledBy(r,c);this.renderAriaDescribedBy(r,c);}r.write("</div>");};
I.getAriaRole=function(c){return"textbox";};
I.getAriaLabelledBy=function(c){if(this.getLabelledByAnnouncement(c)){return c.getId()+"-labelledby";}};
I.getLabelledByAnnouncement=function(c){return c._getPlaceholder()||"";};
I.renderAriaLabelledBy=function(r,c){var a=this.getLabelledByAnnouncement(c);if(a){r.write("<span");r.writeAttribute("id",c.getId()+"-labelledby");r.writeAttribute("aria-hidden","true");r.addClass("sapUiInvisibleText");r.writeClasses();r.write(">");r.writeEscaped(a.trim());r.write("</span>");}};
I.getAriaDescribedBy=function(c){if(this.getDescribedByAnnouncement(c)){return c.getId()+"-describedby";}};
I.getDescribedByAnnouncement=function(c){return c.getTooltip_AsString()||"";};
I.renderAriaDescribedBy=function(r,c){var a=this.getDescribedByAnnouncement(c);if(a){r.write("<span");r.writeAttribute("id",c.getId()+"-describedby");r.writeAttribute("aria-hidden","true");r.addClass("sapUiInvisibleText");r.writeClasses();r.write(">");r.writeEscaped(a.trim());r.write("</span>");}};
I.getAccessibilityState=function(c){var a=this.getAriaLabelledBy(c),A=this.getAriaDescribedBy(c),r=this.getAriaRole(c),m={};if(r){m.role=r;}if(c.getValueState()===sap.ui.core.ValueState.Error){m.invalid=true;}if(a){m.labelledby={value:a.trim(),append:true};}if(A){m.describedby={value:A.trim(),append:true};}return m;};
I.writeAccessibilityState=function(r,c){r.writeAccessibilityState(c,this.getAccessibilityState(c));};
I.openInputTag=function(r,c){r.write("<input");};
I.writeInnerValue=function(r,c){r.writeAttributeEscaped("value",c.getValue());};
I.addCursorClass=function(r,c){};
I.addPaddingClass=function(r,c){r.addClass("sapMInputBaseWidthPadding");};
I.addOuterStyles=function(r,c){};
I.addControlWidth=function(r,c){if(c.getWidth()){r.addStyle("width",c.getWidth());}};
I.addOuterClasses=function(r,c){};
I.writeOuterAttributes=function(r,c){};
I.addInnerStyles=function(r,c){};
I.addWrapperStyles=function(r,c){};
I.addInnerClasses=function(r,c){};
I.writeInnerAttributes=function(r,c){};
I.prependInnerContent=function(r,c){};
I.writeInnerContent=function(r,c){};
I.writeDecorations=function(r,c){};
I.closeInputTag=function(r,c){};
I.addPlaceholderStyles=function(r,c){};
I.addPlaceholderClasses=function(r,c){r.addClass("sapMInputBasePlaceholder");};
I.addValueStateInnerClasses=function(r,c){r.addClass("sapMInputBaseStateInner");r.addClass("sapMInputBase"+c.getValueState()+"Inner");};
I.addValueStateClasses=function(r,c){r.addClass("sapMInputBaseState");r.addClass("sapMInputBase"+c.getValueState());};
I.writeInnerId=function(r,c){r.writeAttribute("id",c.getId()+"-inner");};
return I;},true);
sap.ui.predefine('sap/m/InputListItem.designtime',[],function(){"use strict";return{aggregations:{content:{domRef:":sap-domref > .sapMLIBContent",actions:{move:"moveControls"}}},actions:{rename:{changeType:"rename",domRef:function(c){return c.$().find(".sapMLIBContent > .sapMILILabel")[0];}}},name:{singular:"LIST_ITEM_BASE_NAME",plural:"LIST_ITEM_BASE_NAME_PLURAL"}};},false);
sap.ui.predefine('sap/m/InputListItem',['jquery.sap.global','./ListItemBase','./library'],function(q,L,l){"use strict";
var I=L.extend("sap.m.InputListItem",{metadata:{library:"sap.m",properties:{label:{type:"string",group:"Misc",defaultValue:null},labelTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",bindable:"bindable"}},designTime:true}});
I.prototype.getContentAnnouncement=function(){var a=this.getLabel();this.getContent().forEach(function(c){a+=L.getAccessibilityText(c)+" ";});return a;};
return I;},true);
sap.ui.predefine('sap/m/InputListItemRenderer',['jquery.sap.global','./ListItemBaseRenderer','sap/ui/core/Renderer'],function(q,L,R){"use strict";var I=R.extend(L);
I.renderLIAttributes=function(r,l){r.addClass("sapMILI");};
I.renderLIContent=function(r,l){var s=l.getLabel();if(s){var a=l.getId()+"-label",b=l.getLabelTextDirection();r.write('<label id="'+a+'" class="sapMILILabel"');if(b!==sap.ui.core.TextDirection.Inherit){r.writeAttribute("dir",b.toLowerCase());}r.write('>');r.writeEscaped(s);r.write('</label>');}r.write('<div class="sapMILIDiv sapMILI-CTX">');l.getContent().forEach(function(c){if(a&&c.addAriaLabelledBy&&c.getAriaLabelledBy().indexOf(a)==-1){c.addAssociation("ariaLabelledBy",a,true);}r.renderControl(c);});r.write('</div>');};
return I;},true);
sap.ui.predefine('sap/m/InputRenderer',['jquery.sap.global','sap/ui/core/Renderer','./InputBaseRenderer'],function(q,R,I){"use strict";var a=R.extend(I);
a.addOuterClasses=function(r,c){r.addClass("sapMInput");if(c.getShowValueHelp()&&c.getEnabled()&&c.getEditable()){r.addClass("sapMInputVH");if(c.getValueHelpOnly()){r.addClass("sapMInputVHO");}}if(c.getDescription()){r.addClass("sapMInputDescription");}};
a.addOuterStyles=function(r,c){};
a.writeInnerAttributes=function(r,c){r.writeAttribute("type",c.getType().toLowerCase());if(c.getType()==sap.m.InputType.Number&&sap.ui.getCore().getConfiguration().getRTL()){r.writeAttribute("dir","ltr");r.addStyle("text-align","right");}if(c.getShowSuggestion()){r.writeAttribute("autocomplete","off");}if((!c.getEnabled()&&c.getType()=="Password")||(c.getShowSuggestion()&&c._bUseDialog)||(c.getValueHelpOnly()&&c.getEnabled()&&c.getEditable()&&c.getShowValueHelp())){r.writeAttribute("readonly","readonly");}};
a.addInnerClasses=function(r,c){};
a.addWrapperStyles=function(r,c){if(c.getDescription()){r.addStyle("width",c.getFieldWidth()||"50%");}};
a.writeDecorations=function(r,c){var i=c.getId(),d=c.getDescription();if(!d){this.writeValueHelpIcon(r,c);}else{r.write("<span id=\""+c.getId()+"-Descr\">");this.writeValueHelpIcon(r,c);r.write('<span class="sapMInputDescriptionText">');r.writeEscaped(d);r.write("</span></span>");}if(sap.ui.getCore().getConfiguration().getAccessibility()){if(c.getShowSuggestion()&&c.getEnabled()&&c.getEditable()){r.write("<span id=\""+i+"-SuggDescr\" class=\"sapUiPseudoInvisibleText\" role=\"status\" aria-live=\"polite\"></span>");}}};
a.writeValueHelpIcon=function(r,c){if(c.getShowValueHelp()&&c.getEnabled()&&c.getEditable()){r.write('<div class="sapMInputValHelp" tabindex="-1">');r.renderControl(c._getValueHelpIcon());r.write("</div>");}};
a.addPlaceholderStyles=function(r,c){if(c.getDescription()){r.addStyle("width",c.getFieldWidth()||"50%");}};
a.getAriaLabelledBy=function(c){var b=I.getAriaLabelledBy.call(this,c)||"";if(c.getDescription()){b=b+" "+c.getId()+"-Descr";}return b;};
a.getAriaDescribedBy=function(c){var A=I.getAriaDescribedBy.apply(this,arguments);if(c.getShowValueHelp()&&c.getEnabled()&&c.getEditable()){if(A){A=A+" "+c._sAriaValueHelpLabelId;}else{A=c._sAriaValueHelpLabelId;}if(c.getValueHelpOnly()){A=A+" "+c._sAriaInputDisabledLabelId;}}if(c.getShowSuggestion()&&c.getEnabled()&&c.getEditable()){if(A){A=A+" "+c.getId()+"-SuggDescr";}else{A=c.getId()+"-SuggDescr";}}return A;};
a.getAriaRole=function(c){return"";};
a.getAccessibilityState=function(c){var A=I.getAccessibilityState.apply(this,arguments);if(c.getShowSuggestion()&&c.getEnabled()&&c.getEditable()){A.autocomplete="list";}return A;};
return a;},true);
sap.ui.predefine('sap/m/InstanceManager',['jquery.sap.global'],function(q){"use strict";var I={};(function(){var r={},e=[];var p="_POPOVER_",d="_DIALOG_",l="_LIGHTBOX_";
I.addInstance=function(c,i){if(!r[c]){r[c]=[];}if(r[c].indexOf(i)===-1){r[c].push(i);}return this;};
I.removeInstance=function(c,o){var C=r[c],i;if(!C){q.sap.log.warning("Can't remove control from a non-managed category id: "+c);return null;}i=C.indexOf(o);return(i===-1)?null:C.splice(i,1);};
I.getInstancesByCategoryId=function(c){return r[c]||e;};
I.isInstanceManaged=function(c,i){var C=r[c];if(!C||!i){return false;}return C.indexOf(i)!==-1;};
I.isCategoryEmpty=function(c){var C=r[c];return!C||C.length===0;};
I.addPopoverInstance=function(P){if(typeof P.close==="function"){I.addInstance(p,P);}else{q.sap.log.warning("In method addPopoverInstance: the parameter doesn't have a close method and can't be managed.");}return this;};
I.addDialogInstance=function(D){if(typeof D.close==="function"){I.addInstance(d,D);}else{q.sap.log.warning("In method addDialogInstance: the parameter doesn't have a close method and can't be managed.");}return this;};
I.addLightBoxInstance=function(L){if(typeof L.close==="function"){I.addInstance(l,L);}else{q.sap.log.warning("In method addLightBoxInstance: the parameter doesn't have a close method and can't be managed.");}return this;};
I.removePopoverInstance=function(P){return I.removeInstance(p,P);};
I.removeDialogInstance=function(D){return I.removeInstance(d,D);};
I.removeLightBoxInstance=function(L){return I.removeInstance(l,L);};
I.hasOpenPopover=function(){return!I.isCategoryEmpty(p);};
I.hasOpenDialog=function(){return!I.isCategoryEmpty(d);};
I.hasOpenLightBox=function(){return!I.isCategoryEmpty(l);};
I.isDialogOpen=function(D){return I.isInstanceManaged(d,D);};
I.isPopoverOpen=function(P){return I.isInstanceManaged(p,P);};
I.isLightBoxOpen=function(L){return I.isInstanceManaged(l,L);};
I.getOpenPopovers=function(){return I.getInstancesByCategoryId(p);};
I.getOpenDialogs=function(){return I.getInstancesByCategoryId(d);};
I.getOpenLightBoxes=function(){return I.getInstancesByCategoryId(l);};
I.closeAllPopovers=function(){var a=I.getOpenPopovers(),i;for(i=0;i<a.length;i++){a[i].close();}return this;};
I.closeAllDialogs=function(c){var D,a=[],b=I.getOpenDialogs(),f,i;for(i=0;i<b.length;i++){f=b[i];if(c){D=new q.Deferred().done();a.push(D);f.attachEvent("afterClose",(function(g){return function(){g.resolve();};}(D)));}f.close();}if(c){q.when.apply(this,a).then(c);}return this;};
I.closeAllLightBoxes=function(){var i=I.getOpenLightBoxes(),L=i.length,a;for(a=0;a<L;a+=1){i[a].close();}return this;};
}());return I;},true);
sap.ui.predefine('sap/m/Label.designtime',[],function(){"use strict";return{actions:{remove:{changeType:"hideControl"},rename:{changeType:"rename",domRef:function(c){return c.$()[0];}},reveal:{changeType:"unhideControl"}},name:{singular:"LABEL_NAME",plural:"LABEL_NAME_PLURAL"}};},false);
sap.ui.predefine('sap/m/Label',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/LabelEnablement'],function(q,l,C,L){"use strict";
var a=C.extend("sap.m.Label",{metadata:{interfaces:["sap.ui.core.Label","sap.ui.core.IShrinkable"],library:"sap.m",properties:{design:{type:"sap.m.LabelDesign",group:"Appearance",defaultValue:sap.m.LabelDesign.Standard},text:{type:"string",group:"Misc",defaultValue:null},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:sap.ui.core.TextAlign.Begin},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:''},required:{type:"boolean",group:"Misc",defaultValue:false},displayOnly:{type:"boolean",group:"Appearance",defaultValue:false},wrapping:{type:"boolean",group:"Appearance",defaultValue:false}},associations:{labelFor:{type:"sap.ui.core.Control",multiple:false}},designTime:true}});
a.prototype.setText=function(t){var v=this.getText();if(v!==t){this.setProperty("text",t,true);this.$().html(q.sap.encodeHTML(this.getProperty("text")));if(t){this.$().removeClass("sapMLabelNoText");}else{this.$().addClass("sapMLabelNoText");}}return this;};
a.prototype.setTooltip=function(t){var v=this.getTooltip();if(v!==t){this.setAggregation("tooltip",t,true);this.$().attr("title",this.getTooltip());}return this;};
a.prototype.setDisplayOnly=function(d){if(typeof d!=="boolean"){q.sap.log.error("DisplayOnly property should be boolean. The new value will not be set");return this;}this.$().toggleClass("sapMLabelDisplayOnly",d);return sap.ui.core.Control.prototype.setProperty.call(this,"displayOnly",d);};
a.prototype.getAccessibilityInfo=function(){return{description:this.getText()};};
L.enrich(a.prototype);return a;},true);
sap.ui.predefine('sap/m/LabelRenderer',['jquery.sap.global','sap/ui/core/Renderer'],function(q,R){"use strict";var L={};
L.render=function(a,l){var r=L,t=l.getTextDirection(),T=l.getTextAlign(),w=l.getWidth(),s=l.getText(),b=l.getTooltip_AsString(),c=l.getLabelForRendering(),h=c?"label":"span",d=l.getDisplayOnly();a.write("<"+h);a.writeControlData(l);a.addClass("sapMLabel");a.addClass("sapUiSelectable");if(l.getWrapping()){a.addClass("sapMLabelWrapped");}if(l.getDesign()==sap.m.LabelDesign.Bold){a.addStyle("font-weight","bold");}if(l.isRequired()){a.addClass("sapMLabelRequired");}if(c){sap.ui.core.LabelEnablement.writeLabelForAttribute(a,l);}else if(l.getParent()instanceof sap.m.Toolbar){a.addClass("sapMLabelTBHeader");}if(t!==sap.ui.core.TextDirection.Inherit){a.writeAttribute("dir",t.toLowerCase());}if(w){a.addStyle("width",w);}else{a.addClass("sapMLabelMaxWidth");}if(T){T=r.getTextAlign(T,t);if(T){a.addStyle("text-align",T);}}if(s==""){a.addClass("sapMLabelNoText");}if(d){a.addClass("sapMLabelDisplayOnly");}a.writeStyles();a.writeClasses();if(b){a.writeAttributeEscaped("title",b);}a.write(">");if(s){a.writeEscaped(s);}a.write("</"+h+">");};
L.getTextAlign=R.getTextAlign;return L;},true);
sap.ui.predefine('sap/m/LightBox',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/Popup','sap/m/Text','sap/m/Button','sap/m/Image','sap/ui/core/ResizeHandler','sap/ui/Device','sap/m/MessagePage','sap/ui/core/Icon','sap/ui/layout/VerticalLayout','./InstanceManager','sap/ui/core/InvisibleText'],function(q,l,C,P,T,B,I,R,D,M,a,V,b,c){'use strict';
var L=C.extend('sap.m.LightBox',{metadata:{interfaces:['sap.ui.core.PopupInterface'],library:'sap.m',aggregations:{imageContent:{type:'sap.m.LightBoxItem',multiple:true,bindable:"bindable"},_closeButton:{type:'sap.m.Button',multiple:false,visibility:'hidden'},_errorIcon:{type:'sap.ui.core.Icon',multiple:false,visibility:'hidden'},_errorTitle:{type:'sap.m.Text',multiple:false,visibility:'hidden'},_errorSubtitle:{type:'sap.m.Text',multiple:false,visibility:'hidden'},_verticalLayout:{type:'sap.ui.layout.VerticalLayout',multiple:false,visibility:'hidden'},_invisiblePopupText:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"},_busy:{type:"sap.m.BusyIndicator",multiple:false,visibility:"hidden"}},events:{},defaultAggregation:'imageContent'}});
L.prototype.init=function(){this._createPopup();this._width=0;this._height=0;this._isRendering=true;this._resizeListenerId=null;this._$lightBox=null;this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._closeButtonText=this._rb.getText("LIGHTBOX_CLOSE_BUTTON");if(sap.ui.getCore().getConfiguration().getAccessibility()){this.setAggregation("_invisiblePopupText",new c());}};
L.prototype.onBeforeRendering=function(){var i=this._getImageContent(),n=i._getNativeImage(),s=i._getImageState();this._createErrorControls();if(!n.src){n.src=i.getImageSrc();}if(this._resizeListenerId){D.resize.detachHandler(this._onResize);R.deregister(this._resizeListenerId);this._resizeListenerId=null;}switch(s){case sap.m.LightBoxLoadingStates.Loading:this._timeoutId=setTimeout(function(){i._setImageState(sap.m.LightBoxLoadingStates.TimeOutError);},10000);break;case sap.m.LightBoxLoadingStates.Loaded:clearTimeout(this._timeoutId);this._calculateSizes(n);break;case sap.m.LightBoxLoadingStates.Error:clearTimeout(this._timeoutId);break;default:break;}var o=this.getAggregation('_invisiblePopupText');if(i&&o){o.setText(this._rb.getText("LIGHTBOX_ARIA_ENLARGED",i.getTitle()));}this._isRendering=true;};
L.prototype.onAfterRendering=function(){this._isRendering=false;this._$lightBox=this.$();if(!this._resizeListenerId){D.resize.attachHandler(this._onResize.bind(this));this._resizeListenerId=R.register(this,this._onResize.bind(this));}};
L.prototype.forceInvalidate=C.prototype.invalidate;
L.prototype.invalidate=function(o){var i=this._getImageContent();if(this.isOpen()){if(i&&i.getImageSrc()){this.forceInvalidate(o);}else{this.close();}}return this;};
L.prototype.exit=function(){if(this._oPopup){this._oPopup.detachOpened(this._fnOpened,this);this._oPopup.detachClosed(this._fnClosed,this);this._oPopup.destroy();this._oPopup=null;}if(this._resizeListenerId){D.resize.detachHandler(this._onResize);R.deregister(this._resizeListenerId);this._resizeListenerId=null;}b.removeLightBoxInstance(this);};
L.prototype.open=function(){var i=this._getImageContent();this._oPopup.setContent(this);if(i&&i.getImageSrc()){this._oPopup.open(300,'center center','center center',document.body,null);b.addLightBoxInstance(this);}return this;};
L.prototype.isOpen=function(){if(this._oPopup&&this._oPopup.isOpen()){return true;}return false;};
L.prototype.close=function(){if(this._resizeListenerId){D.resize.detachHandler(this._onResize);R.deregister(this._resizeListenerId);this._resizeListenerId=null;}this._oPopup.close();b.removeLightBoxInstance(this);return this;};
L.prototype._getCloseButton=function(){var e=this.getAggregation('_closeButton');if(!e){e=new B({id:this.getId()+'-closeButton',text:this._closeButtonText,type:sap.m.ButtonType.Transparent,press:function(){this.close();}.bind(this)});this.setAggregation('_closeButton',e,true);}return e;};
L.prototype._getBusyIndicator=function(){var o=this.getAggregation("_busy");if(!o){o=new sap.m.BusyIndicator();this.setAggregation("_busy",o,true);}return o;};
L.prototype._imageStateChanged=function(n){if((n===sap.m.LightBoxLoadingStates.Loaded||n===sap.m.LightBoxLoadingStates.Error)&&!this._isRendering){this.rerender();}};
L.prototype._createPopup=function(){this._oPopup=new P(this,true,true);this._oPopup.attachOpened(this._fnOpened,this);this._oPopup.attachClosed(this._fnClosed,this);};
L.prototype._fnOpened=function(){var t=this;q('#sap-ui-blocklayer-popup').on("click",function(){t.close();});};
L.prototype._fnClosed=function(){q('#sap-ui-blocklayer-popup').off("click");};
L.prototype._createErrorControls=function(){var r=this._rb;var e;var f;if(this._getImageContent()._getImageState()===sap.m.LightBoxLoadingStates.TimeOutError){e=r.getText('LIGHTBOX_IMAGE_TIMED_OUT');f=r.getText('LIGHTBOX_IMAGE_TIMED_OUT_DETAILS');}else{e=r.getText('LIGHTBOX_IMAGE_ERROR');f=r.getText('LIGHTBOX_IMAGE_ERROR_DETAILS');}if(!this.getAggregation('_verticalLayout')){var g=new T({text:e,textAlign:sap.ui.core.TextAlign.Center}).addStyleClass("sapMLightBoxErrorTitle"),h=new T({text:f,textAlign:sap.ui.core.TextAlign.Center}).addStyleClass("sapMLightBoxErrorSubtitle"),i=new a({src:"sap-icon://picture"}).addStyleClass("sapMLightBoxErrorIcon");this.setAggregation('_verticalLayout',new V({content:[i,g,h]}).addStyleClass('sapMLightBoxVerticalLayout'));}};
L.prototype._onResize=function(){var m=d()/2+'px',t=m,e=m,f='',g='',i=this._getImageContent(),h=this.getDomRef(),j,k,n=d(),o=2;if(i._getImageState()===sap.m.LightBoxLoadingStates.Loaded){this._calculateSizes(i._getNativeImage());j=this._width;k=this._height;this._$lightBox.width(j);this._$lightBox.height(k);}else{j=h.clientWidth;k=h.clientHeight;}if(window.innerWidth>j+n){e='50%';g=Math.round(-j/2);}if(window.innerHeight>k+n){t='50%';f=Math.round(-k/2);}if(sap.ui.getCore().getConfiguration().getTheme()==='sap_hcb'){f-=o;g-=o;}this._$lightBox.css({'top':t,'margin-top':f,'left':e,'margin-left':g});};
L.prototype._calculateSizes=function(i){var f=this._calculateFooterHeightInPx(),e=288-f,g=this._getImageContent().getAggregation("_image"),h;this._setImageSize(g,i.naturalWidth,i.naturalHeight);this._calculateAndSetLightBoxSize(g);h=this._pxToNumber(g.getHeight());this.toggleStyleClass('sapMLightBoxMinSize',(h<e));this._isBusy=false;};
L.prototype._calculateFooterHeightInPx=function(i){var e=this.$().parents().hasClass('sapUiSizeCompact');var s=this._getImageContent().getSubtitle();var f=2.5;if(!e){f+=0.5;}if(s){f+=1.5;}return f*16;};
L.prototype._calculateAndSetLightBoxSize=function(i){var e,f=(20*16),g=(18*16),F=this._calculateFooterHeightInPx();e=this._pxToNumber(i.getHeight());this._width=Math.max(f,this._pxToNumber(i.getWidth()));this._height=Math.max(g,e+F);};
L.prototype._setImageSize=function(i,e,f){var g=this._calculateFooterHeightInPx(),h=this._getDimensions(e,f,g);i.setWidth(h.width+'px');i.setHeight(h.height+'px');};
L.prototype._getDimensions=function(i,e,f){var g=20*16,h=18*16,$=q(window),w=$.height(),j=$.width(),m=d(),k=Math.max(j-m,g),n=Math.max(w-m,h),s;n-=f;if(e<=n){if(i<=k){}else{e*=k/i;i=k;}}else{if(i<=k){i*=n/e;e=n;}else{s=Math.max(i/k,e/n);i/=s;e/=s;}}return{width:Math.round(i),height:Math.round(e)};};
L.prototype._pxToNumber=function(s){return(s.substring(0,(s.length-2)))*1;};
L.prototype._getImageContent=function(){var r=this.getAggregation('imageContent');return r&&r[0];};
function d(){var s=sap.ui.Device.system;if(s.desktop){return 4*16;}if(s.tablet){return 2*16;}return 0;}
return L;},true);
sap.ui.predefine('sap/m/LightBoxItem',['jquery.sap.global','./library','sap/ui/core/Element','./Image','./Text'],function(q,l,E,I,T){"use strict";
var L=E.extend("sap.m.LightBoxItem",{metadata:{library:"sap.m",properties:{imageSrc:{type:'sap.ui.core.URI',group:'Appearance',multiple:false,defaultValue:''},alt:{type:'string',group:'Appearance',multiple:false,defaultValue:''},title:{type:'string',group:'Appearance',multiple:false,defaultValue:''},subtitle:{type:'string',group:'Appearance',multiple:false,defaultValue:''}},aggregations:{_image:{type:'sap.m.Image',multiple:false,visibility:'hidden'},_title:{type:'sap.m.Text',multiple:false,visibility:'hidden'},_subtitle:{type:'sap.m.Text',multiple:false,visibility:'hidden'}}}});
L.prototype.init=function(){this._createNativeImage();this.setAggregation('_image',new I({decorative:false,densityAware:false}),true);this.setAggregation('_title',new T({wrapping:false}),true);this.setAggregation('_subtitle',new T({wrapping:false}),true);};
L.prototype._createNativeImage=function(){var t=this;this._imageState=sap.m.LightBoxLoadingStates.Loading;this._oImage=new window.Image();this._oImage.onload=function(e){if(this.complete&&t._imageState===sap.m.LightBoxLoadingStates.Loading){t._setImageState(sap.m.LightBoxLoadingStates.Loaded);}};this._oImage.onerror=function(e){t._setImageState(sap.m.LightBoxLoadingStates.Error);};};
L.prototype.exit=function(){this._oImage=null;};
L.prototype._setImageState=function(i){if(i!==this._imageState){this._imageState=i;if(this.getParent()){this.getParent()._imageStateChanged(i);}}};
L.prototype._getImageState=function(){return this._imageState;};
L.prototype._getNativeImage=function(){return this._oImage;};
L.prototype.setImageSrc=function(i){var o=this.getAggregation("_image"),a=this.getParent();if(this.getImageSrc()===i){return this;}this._imageState=sap.m.LightBoxLoadingStates.Loading;if(a&&a._oPopup.getOpenState()===sap.ui.core.OpenState.OPEN){this._oImage.src=i;}this.setProperty("imageSrc",i,false);o.setSrc(i);return this;};
L.prototype.setAlt=function(a){var i=this.getAggregation("_image");this.setProperty("alt",a,false);i.setAlt(a);return this;};
L.prototype.setTitle=function(t){var o=this.getAggregation("_title");this.setProperty("title",t,false);o.setText(t);return this;};
L.prototype.setSubtitle=function(s){var S=this.getAggregation("_subtitle");this.setProperty("subtitle",s,false);S.setText(s);return this;};
return L;},true);
sap.ui.predefine('sap/m/LightBoxRenderer',['jquery.sap.global'],function(q){'use strict';var L={};var c='sapMLightBox';var a='sapMLightBoxTwoLines';var b='sapMLightBoxImageContainer';var d='sapMLightBoxImageContainerTwoHeaders';var e='sapMLightBoxError';var f='sapMLightBoxErrorContainer';var g='sapMLightBoxErrorContainerTwoHeaders';var h='sapMLightBoxFooter';var i='sapContrast';var j='sapContrastPlus';var k='sapMLightBoxTitleSection';var l='sapMLightBoxTitle';var m='sapMLightBoxSubtitle';var n='sapMLightBoxFooterTwoLines';
L.render=function(r,C){var o=C._getImageContent();var p=o._getImageState();var s=C.getAggregation('_invisiblePopupText');r.write('<div');r.writeControlData(C);r.addClass(c);if(o.getSubtitle()){r.addClass(a);}if(p!==sap.m.LightBoxLoadingStates.Error){r.addStyle('width',C._width+'px');r.addStyle('height',C._height+'px');}else{r.addClass(e);}r.writeAccessibilityState({role:'dialog',labelledby:s&&s.getId()});r.writeClasses();r.writeStyles();r.write('>');r.renderControl(s);if(p===sap.m.LightBoxLoadingStates.Loading){this.renderBusyState(r,C);}else if(p===sap.m.LightBoxLoadingStates.TimeOutError||p===sap.m.LightBoxLoadingStates.Error){this.renderError(r,C);}else{this.renderImage(r,C);}this.renderFooter(r,C,o);r.write('</div>');C._isRendering=false;};
L.renderImage=function(r,C){var o=C._getImageContent();if(o.getSubtitle()){r.write('<div class="'+d+'">');}else{r.write('<div class="'+b+'">');}r.renderControl(o.getAggregation('_image'));r.write('</div>');};
L.renderError=function(r,C){var o=C._getImageContent(),v=C.getAggregation('_verticalLayout');if(o.getSubtitle()){r.write('<div class="'+g+'">');}else{r.write('<div class="'+f+'">');}r.renderControl(v);r.write('</div>');};
L.renderBusyState=function(r,C){r.renderControl(C._getBusyIndicator());};
L.renderFooter=function(r,C,I){var t=I.getAggregation("_title"),s=I.getAggregation("_subtitle");r.write('<div');r.addClass(h);r.addClass(i);r.addClass(j);if(I.getSubtitle()){r.addClass(n);}r.writeClasses();r.write('>');r.write('<div class="'+k+'">');if(t){r.renderControl(t.addStyleClass(l));}if(s&&s.getText()){r.renderControl(s.addStyleClass(m));}r.write('</div>');r.renderControl(C._getCloseButton());r.write('</div>');};
return L;},true);
sap.ui.predefine('sap/m/Link.designtime',[],function(){"use strict";return{actions:{remove:{changeType:"hideControl"},reveal:{changeType:"unhideControl"}},name:{singular:"LINK_NAME",plural:"LINK_NAME_PLURAL"}};},false);
sap.ui.predefine('sap/m/Link',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/InvisibleText','sap/ui/core/EnabledPropagator'],function(q,l,C,I,E){"use strict";
var L=C.extend("sap.m.Link",{metadata:{interfaces:["sap.ui.core.IShrinkable","sap.ui.core.IFormContent"],library:"sap.m",properties:{text:{type:"string",group:"Data",defaultValue:''},enabled:{type:"boolean",group:"Behavior",defaultValue:true},target:{type:"string",group:"Behavior",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},href:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},wrapping:{type:"boolean",group:"Appearance",defaultValue:false},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:sap.ui.core.TextAlign.Initial},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit},subtle:{type:"boolean",group:"Behavior",defaultValue:false},emphasized:{type:"boolean",group:"Behavior",defaultValue:false}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{press:{allowPreventDefault:true}},designTime:true}});
E.call(L.prototype);
L.prototype.onBeforeRendering=function(){};
L.prototype.onsapspace=function(e){this._handlePress(e);if(this.getHref()&&!e.isDefaultPrevented()){e.preventDefault();e.setMarked();var c=document.createEvent('MouseEvents');c.initEvent('click',false,true);this.getDomRef().dispatchEvent(c);}};
L.prototype._handlePress=function(e){if(this.getEnabled()){e.setMarked();if(!this.firePress()||!this.getHref()){e.preventDefault();}}else{e.preventDefault();}};
if(sap.ui.Device.support.touch){L.prototype.ontap=L.prototype._handlePress;}else{L.prototype.onclick=L.prototype._handlePress;}
L.prototype.ontouchstart=function(e){if(this.getEnabled()){e.setMarked();}};
L.prototype.setText=function(t){var $=this.$();this.setProperty("text",t,true);t=this.getProperty("text");if(this.writeText){this.writeText(t);}else{$.text(t);}if(t){$.attr("tabindex","0");}else{$.attr("tabindex","-1");}return this;};
L.prototype.setHref=function(u){this.setProperty("href",u,true);if(this.getEnabled()){u=this.getProperty("href");if(!u){this.$().removeAttr("href");}else{this.$().attr("href",u);}}return this;};
L.prototype.setSubtle=function(s){this.setProperty("subtle",s,true);var $=this.$();if($.length){$.toggleClass("sapMLnkSubtle",s);if(s){L._addToDescribedBy($,this._sAriaLinkSubtleId);}else{L._removeFromDescribedBy($,this._sAriaLinkSubtleId);}}if(s&&!L.prototype._sAriaLinkSubtleId){L.prototype._sAriaLinkSubtleId=L._getARIAInvisibleTextId("LINK_SUBTLE");}return this;};
L.prototype.setEmphasized=function(e){this.setProperty("emphasized",e,true);var $=this.$();if($.length){$.toggleClass("sapMLnkEmphasized",e);if(e){L._addToDescribedBy($,this._sAriaLinkEmphasizedId);}else{L._removeFromDescribedBy($,this._sAriaLinkEmphasizedId);}}if(e&&!L.prototype._sAriaLinkEmphasizedId){L.prototype._sAriaLinkEmphasizedId=L._getARIAInvisibleTextId("LINK_EMPHASIZED");}return this;};
L.prototype.setWrapping=function(w){this.setProperty("wrapping",w,true);this.$().toggleClass("sapMLnkWrapping",w);return this;};
L.prototype.setEnabled=function(e){if(e!==this.getProperty("enabled")){this.setProperty("enabled",e,true);var $=this.$();$.toggleClass("sapMLnkDsbl",!e);if(e){$.attr("disabled",false);if(this.getText()){$.attr("tabindex","0");}else{$.attr("tabindex","-1");}$.removeAttr("aria-disabled");if(this.getHref()){$.attr("href",this.getHref());}}else{$.attr("disabled",true);$.attr("tabindex","-1");$.attr("aria-disabled",true);$.removeAttr("href");}}return this;};
L.prototype.setWidth=function(w){this.setProperty("width",w,true);this.$().toggleClass("sapMLnkMaxWidth",!w);this.$().css("width",w);return this;};
L.prototype.setTarget=function(t){this.setProperty("target",t,true);if(!t){this.$().removeAttr("target");}else{this.$().attr("target",t);}return this;};
L._getResourceBundle=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.m");};
L._getARIAInvisibleTextId=function(r){var R=L._getResourceBundle();return new I({text:R.getText(r)}).toStatic().getId();};
L._addToDescribedBy=function($,i){var a=$.attr("aria-describedby");if(a){$.attr("aria-describedby",a+" "+i);}else{$.attr("aria-describedby",i);}};
L._removeFromDescribedBy=function($,i){var a=$.attr("aria-describedby");if(a&&a.indexOf(i)!==-1){a=a.replace(i,'');if(a.length>1){$.attr("aria-describedby",a);}else{$.removeAttr("aria-describedby");}}};
L.prototype.getAccessibilityInfo=function(){return{role:"link",type:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_LINK"),description:this.getText()||this.getHref()||"",focusable:this.getEnabled(),enabled:this.getEnabled()};};
L.prototype.getFormDoNotAdjustWidth=function(){return true;};
return L;},true);
sap.ui.predefine('sap/m/LinkRenderer',['jquery.sap.global','sap/ui/core/Renderer','sap/ui/core/LabelEnablement'],function(q,R,L){"use strict";var a={};
a.render=function(r,c){var t=c.getTextDirection(),T=R.getTextAlign(c.getTextAlign(),t),s=c.getAriaLabelledBy().indexOf(c.getId())===-1&&(c.getAriaLabelledBy().length>0||L.getReferencingLabels(c).length>0||(c.getParent()&&c.getParent().enhanceAccessibilityState)),A={role:'link',labelledby:s?{value:c.getId(),append:true}:undefined};r.write("<a");r.writeControlData(c);r.addClass("sapMLnk");if(c.getSubtle()){r.addClass("sapMLnkSubtle");if(A.describedby){A.describedby+=" "+c._sAriaLinkSubtleId;}else{A.describedby=c._sAriaLinkSubtleId;}}if(c.getEmphasized()){r.addClass("sapMLnkEmphasized");if(A.describedby){A.describedby+=" "+c._sAriaLinkEmphasizedId;}else{A.describedby=c._sAriaLinkEmphasizedId;}}if(!c.getEnabled()){r.addClass("sapMLnkDsbl");r.writeAttribute("disabled","true");r.writeAttribute("tabIndex","-1");}else if(c.getText()){r.writeAttribute("tabIndex","0");}else{r.writeAttribute("tabIndex","-1");}if(c.getWrapping()){r.addClass("sapMLnkWrapping");}if(c.getTooltip_AsString()){r.writeAttributeEscaped("title",c.getTooltip_AsString());}if(c.getHref()&&c.getEnabled()){r.writeAttributeEscaped("href",c.getHref());}if(c.getTarget()){r.writeAttributeEscaped("target",c.getTarget());}if(c.getWidth()){r.addStyle("width",c.getWidth());}else{r.addClass("sapMLnkMaxWidth");}if(T){r.addStyle("text-align",T);}if(t!==sap.ui.core.TextDirection.Inherit){r.writeAttribute("dir",t.toLowerCase());}r.writeAccessibilityState(c,A);r.writeClasses();r.writeStyles();r.write(">");if(this.writeText){this.writeText(r,c);}else{this.renderText(r,c);}r.write("</a>");};
a.renderText=function(r,c){r.writeEscaped(c.getText());};
return a;},true);
sap.ui.predefine('sap/m/List',['jquery.sap.global','./ListBase','./library'],function(q,L,l){"use strict";
var a=L.extend("sap.m.List",{metadata:{library:"sap.m",properties:{backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:sap.m.BackgroundDesign.Solid}},aggregations:{columns:{type:"sap.m.Column",multiple:true,singularName:"column",deprecated:true}}}});
a.prototype.onBeforeRendering=function(){if(L.prototype.onBeforeRendering){L.prototype.onBeforeRendering.call(this);}if(!this.getColumns().length||this._isColumnsIncompatible()){return;}q.sap.require("sap.m.Table");var p=sap.m.Table.prototype;Object.keys(p).forEach(function(k){this[k]=p[k];},this);if(!this.mProperties.hasOwnProperty("backgroundDesign")){this.setBackgroundDesign("Translucent");}};
a.prototype._isColumnsIncompatible=function(){return sap.ui.getCore().getConfiguration().getCompatibilityVersion("sapMListAsTable").compareTo("1.16")>=0;};
return a;},true);
sap.ui.predefine('sap/m/ListBase.designtime',[],function(){"use strict";return{aggregations:{items:{domRef:":sap-domref > .sapMListUl:not(.sapMGrowingList)",actions:{move:"moveControls"}},swipeContent:{domRef:":sap-domref > .sapMListSwp",ignore:true},headerToolbar:{domRef:":sap-domref > .sapMListHdrTBar"},infoToolbar:{domRef:":sap-domref > .sapMListInfoTBar"}},actions:{remove:{changeType:"hideControl"},reveal:{changeType:"unhideControl"}},name:{singular:"LIST_BASE_NAME",plural:"LIST_BASE_NAME_PLURAL"}};},false);
sap.ui.predefine('sap/m/ListBase',['jquery.sap.global','./GroupHeaderListItem','./ListItemBase','./library','sap/ui/core/Control','sap/ui/core/delegate/ItemNavigation','sap/ui/core/InvisibleText','sap/ui/core/LabelEnablement'],function(q,G,L,l,C,I,a,b){"use strict";
var c=C.extend("sap.m.ListBase",{metadata:{library:"sap.m",properties:{inset:{type:"boolean",group:"Appearance",defaultValue:false},headerText:{type:"string",group:"Misc",defaultValue:null},headerDesign:{type:"sap.m.ListHeaderDesign",group:"Appearance",defaultValue:sap.m.ListHeaderDesign.Standard,deprecated:true},footerText:{type:"string",group:"Misc",defaultValue:null},mode:{type:"sap.m.ListMode",group:"Behavior",defaultValue:sap.m.ListMode.None},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},includeItemInSelection:{type:"boolean",group:"Behavior",defaultValue:false},showUnread:{type:"boolean",group:"Misc",defaultValue:false},noDataText:{type:"string",group:"Misc",defaultValue:null},showNoData:{type:"boolean",group:"Misc",defaultValue:true},enableBusyIndicator:{type:"boolean",group:"Behavior",defaultValue:true},modeAnimationOn:{type:"boolean",group:"Misc",defaultValue:true},showSeparators:{type:"sap.m.ListSeparators",group:"Appearance",defaultValue:sap.m.ListSeparators.All},swipeDirection:{type:"sap.m.SwipeDirection",group:"Misc",defaultValue:sap.m.SwipeDirection.Both},growing:{type:"boolean",group:"Behavior",defaultValue:false},growingThreshold:{type:"int",group:"Misc",defaultValue:20},growingTriggerText:{type:"string",group:"Appearance",defaultValue:null},growingScrollToLoad:{type:"boolean",group:"Behavior",defaultValue:false},growingDirection:{type:"sap.m.ListGrowingDirection",group:"Behavior",defaultValue:sap.m.ListGrowingDirection.Downwards},rememberSelections:{type:"boolean",group:"Behavior",defaultValue:true},keyboardMode:{type:"sap.m.ListKeyboardMode",group:"Behavior",defaultValue:sap.m.ListKeyboardMode.Navigation}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.ListItemBase",multiple:true,singularName:"item",bindable:"bindable"},swipeContent:{type:"sap.ui.core.Control",multiple:false},headerToolbar:{type:"sap.m.Toolbar",multiple:false},infoToolbar:{type:"sap.m.Toolbar",multiple:false}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{select:{deprecated:true,parameters:{listItem:{type:"sap.m.ListItemBase"}}},selectionChange:{parameters:{listItem:{type:"sap.m.ListItemBase"},listItems:{type:"sap.m.ListItemBase[]"},selected:{type:"boolean"},selectAll:{type:"boolean"}}},"delete":{parameters:{listItem:{type:"sap.m.ListItemBase"}}},swipe:{allowPreventDefault:true,parameters:{listItem:{type:"sap.m.ListItemBase"},swipeContent:{type:"sap.ui.core.Control"},srcControl:{type:"sap.ui.core.Control"}}},growingStarted:{deprecated:true,parameters:{actual:{type:"int"},total:{type:"int"}}},growingFinished:{deprecated:true,parameters:{actual:{type:"int"},total:{type:"int"}}},updateStarted:{parameters:{reason:{type:"string"},actual:{type:"int"},total:{type:"int"}}},updateFinished:{parameters:{reason:{type:"string"},actual:{type:"int"},total:{type:"int"}}},itemPress:{parameters:{listItem:{type:"sap.m.ListItemBase"},srcControl:{type:"sap.ui.core.Control"}}}},designTime:true}});
c.prototype.iAnnounceDetails=1;
c.getInvisibleText=function(){return this.oInvisibleText||(this.oInvisibleText=new a().toStatic());};
c.prototype.sNavItemClass="sapMLIB";
c.prototype.init=function(){this._aNavSections=[];this._aSelectedPaths=[];this._iItemNeedsHighlight=0;this.data("sap-ui-fastnavgroup","true",true);};
c.prototype.onBeforeRendering=function(){this._bRendering=true;this._bActiveItem=false;this._aNavSections=[];this._removeSwipeContent();};
c.prototype.onAfterRendering=function(){this._bRendering=false;this._sLastMode=this.getMode();if(sap.ui.Device.system.desktop){this._bItemNavigationInvalidated=true;}};
c.prototype.exit=function(){this._oSelectedItem=null;this._aNavSections=[];this._aSelectedPaths=[];this._destroyGrowingDelegate();this._destroyItemNavigation();};
c.prototype.refreshItems=function(r){if(this._oGrowingDelegate){this._oGrowingDelegate.refreshItems(r);}else{if(!this._bReceivingData){this._updateStarted(r);this._bReceivingData=true;}this.refreshAggregation("items");}};
c.prototype.updateItems=function(r){if(this._oGrowingDelegate){this._oGrowingDelegate.updateItems(r);}else{if(this._bReceivingData){this._bReceivingData=false;}else{this._updateStarted(r);}this.updateAggregation("items");this._updateFinished();}};
c.prototype.setBindingContext=function(){this._resetItemsBinding();return C.prototype.setBindingContext.apply(this,arguments);};
c.prototype._bindAggregation=function(n,B){function d(B,e,h){B.events=B.events||{};if(!B.events[e]){B.events[e]=h;}else{var o=B.events[e];B.events[e]=function(){o.apply(this,arguments);h.apply(this,arguments);};}}if(n==="items"){this._resetItemsBinding();d(B,"dataRequested",this._onBindingDataRequestedListener.bind(this));d(B,"dataReceived",this._onBindingDataReceivedListener.bind(this));}C.prototype._bindAggregation.call(this,n,B);};
c.prototype._onBindingDataRequestedListener=function(e){this._showBusyIndicator();if(this._dataReceivedHandlerId!=null){q.sap.clearDelayedCall(this._dataReceivedHandlerId);delete this._dataReceivedHandlerId;}};
c.prototype._onBindingDataReceivedListener=function(e){if(this._dataReceivedHandlerId!=null){q.sap.clearDelayedCall(this._dataReceivedHandlerId);delete this._dataReceivedHandlerId;}this._dataReceivedHandlerId=q.sap.delayedCall(0,this,function(){this._hideBusyIndicator();delete this._dataReceivedHandlerId;});};
c.prototype.destroyItems=function(s){if(!this.getItems(true).length){return this;}this._oSelectedItem=null;this.destroyAggregation("items","KeepDom");if(!s){this.invalidate();}return this;};
c.prototype.removeAllItems=function(A){this._oSelectedItem=null;return this.removeAllAggregation("items");};
c.prototype.removeItem=function(i){var o=this.removeAggregation("items",i);if(o&&o===this._oSelectedItem){this._oSelectedItem=null;}return o;};
c.prototype.getItems=function(r){if(r){return this.mAggregations["items"]||[];}return this.getAggregation("items",[]);};
c.prototype.getId=function(s){var i=this.sId;return s?i+"-"+s:i;};
c.prototype.setGrowing=function(g){g=!!g;if(this.getGrowing()!=g){this.setProperty("growing",g,!g);if(g){q.sap.require("sap.m.GrowingEnablement");this._oGrowingDelegate=new sap.m.GrowingEnablement(this);}else if(this._oGrowingDelegate){this._oGrowingDelegate.destroy();this._oGrowingDelegate=null;}}return this;};
c.prototype.setGrowingThreshold=function(t){return this.setProperty("growingThreshold",t,true);};
c.prototype.setEnableBusyIndicator=function(e){this.setProperty("enableBusyIndicator",e,true);if(!this.getEnableBusyIndicator()){this._hideBusyIndicator();}return this;};
c.prototype.setNoDataText=function(n){this.setProperty("noDataText",n,true);this.$("nodata-text").text(this.getNoDataText());return this;};
c.prototype.getNoDataText=function(d){if(d&&this._bBusy){return"";}var n=this.getProperty("noDataText");n=n||sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("LIST_NO_DATA");return n;};
c.prototype.getSelectedItem=function(){var d=this.getItems(true);for(var i=0;i<d.length;i++){if(d[i].getSelected()){return d[i];}}return null;};
c.prototype.setSelectedItem=function(o,s,f){if(this.indexOfItem(o)<0){q.sap.log.warning("setSelectedItem is called without valid ListItem parameter on "+this);return;}if(this._bSelectionMode){o.setSelected((s===undefined)?true:!!s);f&&this._fireSelectionChangeEvent([o]);}};
c.prototype.getSelectedItems=function(){return this.getItems(true).filter(function(i){return i.getSelected();});};
c.prototype.setSelectedItemById=function(i,s){var o=sap.ui.getCore().byId(i);return this.setSelectedItem(o,s);};
c.prototype.getSelectedContexts=function(A){var B=this.getBindingInfo("items"),m=(B||{}).model,M=this.getModel(m);if(!B||!M){return[];}if(A&&this.getRememberSelections()){return this._aSelectedPaths.map(function(p){return M.getContext(p);});}return this.getSelectedItems().map(function(i){return i.getBindingContext(m);});};
c.prototype.removeSelections=function(A,f,d){var e=[];this._oSelectedItem=null;A&&(this._aSelectedPaths=[]);this.getItems(true).forEach(function(i){if(!i.getSelected()){return;}if(d&&i.isSelectedBoundTwoWay()){return;}i.setSelected(false,true);e.push(i);!A&&this._updateSelectedPaths(i);},this);if(f&&e.length){this._fireSelectionChangeEvent(e);}return this;};
c.prototype.selectAll=function(f){if(this.getMode()!="MultiSelect"){return this;}var d=[];this.getItems(true).forEach(function(i){if(!i.getSelected()){i.setSelected(true,true);d.push(i);this._updateSelectedPaths(i);}},this);if(f&&d.length){this._fireSelectionChangeEvent(d,f);}return this;};
c.prototype.getLastMode=function(m){return this._sLastMode;};
c.prototype.setMode=function(m){m=this.validateProperty("mode",m);var o=this.getMode();if(o==m){return this;}this._bSelectionMode=m.indexOf("Select")>-1;if(!this._bSelectionMode){this.removeSelections(true);}else{var s=this.getSelectedItems();if(s.length>1){this.removeSelections(true);}else if(o===sap.m.ListMode.MultiSelect){this._oSelectedItem=s[0];}}return this.setProperty("mode",m);};
c.prototype.getGrowingInfo=function(){return this._oGrowingDelegate?this._oGrowingDelegate.getInfo():null;};
c.prototype.setRememberSelections=function(r){this.setProperty("rememberSelections",r,true);!this.getRememberSelections()&&(this._aSelectedPaths=[]);return this;};
c.prototype.setSelectedContextPaths=function(s){this._aSelectedPaths=s||[];};
c.prototype.getSelectedContextPaths=function(A){if(!A||(A&&this.getRememberSelections())){return this._aSelectedPaths.slice(0);}return this.getSelectedItems().map(function(i){return i.getBindingContextPath();});};
c.prototype.isAllSelectableSelected=function(){if(this.getMode()!=sap.m.ListMode.MultiSelect){return false;}var i=this.getItems(true),s=this.getSelectedItems().length,S=i.filter(function(o){return o.isSelectable();}).length;return(i.length>0)&&(s==S);};
c.prototype.getVisibleItems=function(){return this.getItems(true).filter(function(i){return i.getVisible();});};
c.prototype.getActiveItem=function(){return this._bActiveItem;};
c.prototype.onItemDOMUpdate=function(o){if(!this._bRendering&&this.bOutput){this._startItemNavigation(true);}};
c.prototype.onItemActiveChange=function(o,A){this._bActiveItem=A;};
c.prototype.onItemHighlightChange=function(i,n){this._iItemNeedsHighlight+=(n?1:-1);if(this._iItemNeedsHighlight==1&&n){this.$("listUl").addClass("sapMListHighlight");}else if(this._iItemNeedsHighlight==0){this.$("listUl").removeClass("sapMListHighlight");}};
c.prototype.onItemSelectedChange=function(o,s){if(this.getMode()==sap.m.ListMode.MultiSelect){this._updateSelectedPaths(o,s);return;}if(s){this._aSelectedPaths=[];this._oSelectedItem&&this._oSelectedItem.setSelected(false,true);this._oSelectedItem=o;}else if(this._oSelectedItem===o){this._oSelectedItem=null;}this._updateSelectedPaths(o,s);};
c.prototype.getItemsContainerDomRef=function(){return this.getDomRef("listUl");};
c.prototype.checkGrowingFromScratch=function(){};
c.prototype.onBeforePageLoaded=function(g,s){this._fireUpdateStarted(s,g);this.fireGrowingStarted(g);};
c.prototype.onAfterPageLoaded=function(g,s){this._fireUpdateFinished(g);this.fireGrowingFinished(g);};
c.prototype.addNavSection=function(i){this._aNavSections.push(i);return i;};
c.prototype.getMaxItemsCount=function(){var B=this.getBinding("items");if(B&&B.getLength){return B.getLength()||0;}return this.getItems(true).length;};
c.prototype.shouldRenderItems=function(){return true;};
c.prototype._resetItemsBinding=function(){if(this.isBound("items")){this._bUpdating=false;this._bReceivingData=false;this.removeSelections(true,false,true);this._oGrowingDelegate&&this._oGrowingDelegate.reset();this._hideBusyIndicator();if(this._oItemNavigation){this._oItemNavigation.iFocusedIndex=-1;}}};
c.prototype._updateStarted=function(r){if(!this._bReceivingData&&!this._bUpdating){this._bUpdating=true;this._fireUpdateStarted(r);}};
c.prototype._fireUpdateStarted=function(r,i){this._sUpdateReason=q.sap.charToUpperCase(r||"Refresh");this.fireUpdateStarted({reason:this._sUpdateReason,actual:i?i.actual:this.getItems(true).length,total:i?i.total:this.getMaxItemsCount()});};
c.prototype._updateFinished=function(){if(!this._bReceivingData&&this._bUpdating){this._fireUpdateFinished();this._bUpdating=false;}};
c.prototype._fireUpdateFinished=function(i){q.sap.delayedCall(0,this,function(){this._bItemNavigationInvalidated=true;this.fireUpdateFinished({reason:this._sUpdateReason,actual:i?i.actual:this.getItems(true).length,total:i?i.total:this.getMaxItemsCount()});});};
c.prototype._showBusyIndicator=function(){if(this.getEnableBusyIndicator()&&!this.getBusy()&&!this._bBusy){this._bBusy=true;this._sBusyTimer=q.sap.delayedCall(this.getBusyIndicatorDelay(),this,function(){this.$("nodata-text").text("");});this.setBusy(true,"listUl");}};
c.prototype._hideBusyIndicator=function(){if(this._bBusy){this._bBusy=false;this.setBusy(false,"listUl");q.sap.clearDelayedCall(this._sBusyTimer);if(!this.getItems(true).length){this.$("nodata-text").text(this.getNoDataText());}}};
c.prototype.onItemBindingContextSet=function(i){if(!this._bSelectionMode||!this.getRememberSelections()||!this.isBound("items")){return;}if(i.isSelectedBoundTwoWay()){return;}var p=i.getBindingContextPath();if(p){var s=(this._aSelectedPaths.indexOf(p)>-1);i.setSelected(s);}};
c.prototype.onItemInserted=function(i,s){if(s){this.onItemSelectedChange(i,true);}if(!this._bSelectionMode||!this._aSelectedPaths.length||!this.getRememberSelections()||!this.isBound("items")||i.isSelectedBoundTwoWay()||i.getSelected()){return;}var p=i.getBindingContextPath();if(p&&this._aSelectedPaths.indexOf(p)>-1){i.setSelected(true);}};
c.prototype.onItemSelect=function(o,s){if(this.getMode()==sap.m.ListMode.MultiSelect){this._fireSelectionChangeEvent([o]);}else if(this._bSelectionMode&&s){this._fireSelectionChangeEvent([o]);}};
c.prototype._fireSelectionChangeEvent=function(d,s){var o=d&&d[0];if(!o){return;}this.fireSelectionChange({listItem:o,listItems:d,selected:o.getSelected(),selectAll:!!s});this.fireSelect({listItem:o});};
c.prototype.onItemDelete=function(o){this.fireDelete({listItem:o});};
c.prototype.onItemPress=function(o,s){if(o.getType()==sap.m.ListType.Inactive){return;}q.sap.delayedCall(0,this,function(){this.fireItemPress({listItem:o,srcControl:s});});};
c.prototype._updateSelectedPaths=function(i,s){if(!this.getRememberSelections()||!this.isBound("items")){return;}var p=i.getBindingContextPath();if(!p){return;}s=(s===undefined)?i.getSelected():s;var d=this._aSelectedPaths.indexOf(p);if(s){d<0&&this._aSelectedPaths.push(p);}else{d>-1&&this._aSelectedPaths.splice(d,1);}};
c.prototype._destroyGrowingDelegate=function(){if(this._oGrowingDelegate){this._oGrowingDelegate.destroy();this._oGrowingDelegate=null;}};
c.prototype._destroyItemNavigation=function(){if(this._oItemNavigation){this.removeEventDelegate(this._oItemNavigation);this._oItemNavigation.destroy();this._oItemNavigation=null;}};
c.prototype._getTouchBlocker=function(){return this.$().children();};
c.prototype._getSwipeContainer=function(){return this._$swipeContainer||(q.sap.require("sap.m.InstanceManager"),this._$swipeContainer=q("<div>",{"id":this.getId("swp"),"class":"sapMListSwp"}));};
c.prototype._setSwipePosition=function(){if(this._isSwipeActive){return this._getSwipeContainer().css("top",this._swipedItem.$().position().top);}};
c.prototype._renderSwipeContent=function(){var $=this._swipedItem.$(),d=this._getSwipeContainer();this.$().prepend(d.css({top:$.position().top,height:$.outerHeight(true)}));if(this._bRerenderSwipeContent){this._bRerenderSwipeContent=false;var r=sap.ui.getCore().createRenderManager();r.render(this.getSwipeContent(),d.empty()[0]);r.destroy();}return this;};
c.prototype._swipeIn=function(){var t=this,$=t._getTouchBlocker(),d=t._getSwipeContainer();t._isSwipeActive=true;t._renderSwipeContent();sap.m.InstanceManager.addDialogInstance(t);window.document.activeElement.blur();q(window).on("resize.swp",function(){t._setSwipePosition();});$.css("pointer-events","none").on("touchstart.swp mousedown.swp",function(e){if(!d[0].firstChild.contains(e.target)){e.preventDefault();e.stopPropagation();}});d.bind("webkitAnimationEnd animationend",function(){q(this).unbind("webkitAnimationEnd animationend");d.css("opacity",1).focus();$.parent().on("touchend.swp touchcancel.swp mouseup.swp",function(e){if(!d[0].firstChild.contains(e.target)){t.swipeOut();}});}).removeClass("sapMListSwpOutAnim").addClass("sapMListSwpInAnim");};
c.prototype._onSwipeOut=function(d){this._getSwipeContainer().css("opacity",0).remove();q(window).off("resize.swp");this._getTouchBlocker().css("pointer-events","auto").off("touchstart.swp mousedown.swp");if(typeof d=="function"){d.call(this,this._swipedItem,this.getSwipeContent());}this._isSwipeActive=false;sap.m.InstanceManager.removeDialogInstance(this);};
c.prototype.swipeOut=function(d){if(!this._isSwipeActive){return this;}var t=this,$=this._getSwipeContainer();this._getTouchBlocker().parent().off("touchend.swp touchend.swp touchcancel.swp mouseup.swp");$.bind("webkitAnimationEnd animationend",function(){q(this).unbind("webkitAnimationEnd animationend");t._onSwipeOut(d);}).removeClass("sapMListSwpInAnim").addClass("sapMListSwpOutAnim");return this;};
c.prototype._removeSwipeContent=function(){if(this._isSwipeActive){this.swipeOut()._onSwipeOut();}};
c.prototype.close=c.prototype._removeSwipeContent;
c.prototype._onSwipe=function(e){var o=this.getSwipeContent(),s=e.srcControl;if(o&&s&&!this._isSwipeActive&&this!==s&&!this._eventHandledByControl&&(sap.ui.Device.support.touch||(sap.ui.Device.os.windows&&sap.ui.Device.os.version>=8))){for(var d=s;d&&!(d instanceof sap.m.ListItemBase);d=d.oParent);if(d instanceof sap.m.ListItemBase){this._swipedItem=d;this.fireSwipe({listItem:this._swipedItem,swipeContent:o,srcControl:s},true)&&this._swipeIn();}}};
c.prototype.ontouchstart=function(e){this._eventHandledByControl=e.isMarked();};
c.prototype.onswipeleft=function(e){var d=sap.ui.getCore().getConfiguration().getRTL()?"RightToLeft":"LeftToRight";if(this.getSwipeDirection()!=d){this._onSwipe(e);}};
c.prototype.onswiperight=function(e){var d=sap.ui.getCore().getConfiguration().getRTL()?"LeftToRight":"RightToLeft";if(this.getSwipeDirection()!=d){this._onSwipe(e);}};
c.prototype.setSwipeDirection=function(d){return this.setProperty("swipeDirection",d,true);};
c.prototype.getSwipedItem=function(){return(this._isSwipeActive?this._swipedItem:null);};
c.prototype.setSwipeContent=function(o){this._bRerenderSwipeContent=true;this.toggleStyleClass("sapMListSwipable",!!o);return this.setAggregation("swipeContent",o,!this._isSwipeActive);};
c.prototype.invalidate=function(o){if(o&&o===this.getSwipeContent()){this._bRerenderSwipeContent=true;this._isSwipeActive&&this._renderSwipeContent();return this;}C.prototype.invalidate.apply(this,arguments);return this;};
c.prototype.addItemGroup=function(g,h,s){h=h||new G({title:g.text||g.key});h._bGroupHeader=true;this.addAggregation("items",h,s);return h;};
c.prototype.removeGroupHeaders=function(s){this.getItems(true).forEach(function(i){if(i.isGroupHeader()){i.destroy(s);}});};
c.prototype.getAccessibilityType=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_LIST");};
c.prototype.getAccessibilityStates=function(){if(!this.getItems(true).length){return"";}var s="",m=sap.m.ListMode,M=this.getMode(),B=this.getBinding("rows"),o=sap.ui.getCore().getLibraryResourceBundle("sap.m");if(b.isRequired(this)){s+=o.getText("LIST_REQUIRED")+" ";}if(M==m.MultiSelect){s+=o.getText("LIST_MULTISELECTABLE")+" ";}else if(M==m.Delete){s+=o.getText("LIST_DELETABLE")+" ";}else if(M!=m.None){s+=o.getText("LIST_SELECTABLE")+" ";}if(B&&B.isGrouped()){s+=o.getText("LIST_GROUPED")+" ";}return s;};
c.prototype.getAccessibilityDescription=function(){var d=this.getAriaLabelledBy().map(function(A){var o=sap.ui.getCore().byId(A);return L.getAccessibilityText(o);}).join(" ");var h=this.getHeaderToolbar();if(h){var t=h.getTitleControl();if(t){d+=t.getText()+" ";}}else{d+=this.getHeaderText()+" ";}d+=this.getAccessibilityType()+" ";d+=this.getAccessibilityStates()+" ";d+=this.getFooterText();return d.trim();};
c.prototype.getAccessibilityInfo=function(){return{description:this.getAccessibilityDescription(),focusable:true};};
c.prototype.getAccessbilityPosition=function(i){var s=0,d=this.getVisibleItems(),p=d.indexOf(i)+1,B=this.getBinding("items");if(this.getGrowing()&&this.getGrowingScrollToLoad()&&B&&B.isLengthFinal()){s=B.getLength();if(B.isGrouped()){s+=d.filter(function(i){return i.isGroupHeader()&&i.getVisible();}).length;}}else{s=d.length;}return{setSize:s,posInset:p};};
c.prototype.onItemFocusIn=function(i){if(!sap.ui.getCore().getConfiguration().getAccessibility()){return;}var o=i.getDomRef(),p=this.getAccessbilityPosition(i);if(!i.getContentAnnouncement){this.getNavigationRoot().setAttribute("aria-activedescendant",o.id);o.setAttribute("aria-posinset",p.posInset);o.setAttribute("aria-setsize",p.setSize);}else{var A=i.getAccessibilityInfo(),B=sap.ui.getCore().getLibraryResourceBundle("sap.m"),d=A.type+" ";d+=B.getText("LIST_ITEM_POSITION",[p.posInset,p.setSize])+" ";d+=A.description;this.updateInvisibleText(d,o);}};
c.prototype.updateInvisibleText=function(t,i,p){var o=c.getInvisibleText(),f=q(i||document.activeElement);if(this.iAnnounceDetails){if(this.iAnnounceDetails==1){t=this.getAccessibilityStates()+" "+t;}else{t=this.getAccessibilityInfo().description+" "+t;}this.iAnnounceDetails=0;}o.setText(t.trim());f.addAriaLabelledBy(o.getId(),p);window.setTimeout(function(){f.removeAriaLabelledBy(o.getId());},0);};
c.prototype.getNavigationRoot=function(){return this.getDomRef("listUl");};
c.prototype.getFocusDomRef=function(){return this.getNavigationRoot();};
c.prototype._startItemNavigation=function(i){if(!sap.ui.Device.system.desktop){return;}var k=this.getKeyboardMode(),K=sap.m.ListKeyboardMode;if(k==K.Edit&&!this.getItems(true).length){return;}if(i&&!this.getNavigationRoot().contains(document.activeElement)){this._bItemNavigationInvalidated=true;return;}if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.setCycling(false);this.addEventDelegate(this._oItemNavigation);var t=(k==K.Edit)?-1:0;this._setItemNavigationTabIndex(t);this._oItemNavigation.setTableMode(true,true).setColumns(1);this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"]});}this._oItemNavigation.setPageSize(this.getGrowingThreshold());var n=this.getNavigationRoot();this._oItemNavigation.setRootDomRef(n);this.setNavigationItems(this._oItemNavigation,n);this._bItemNavigationInvalidated=false;};
c.prototype.setNavigationItems=function(i,n){var N=q(n).children(".sapMLIB").get();i.setItemDomRefs(N);if(i.getFocusedIndex()==-1){if(this.getGrowing()&&this.getGrowingDirection()==sap.m.ListGrowingDirection.Upwards){i.setFocusedIndex(N.length-1);}else{i.setFocusedIndex(0);}}};
c.prototype.getItemNavigation=function(){return this._oItemNavigation;};
c.prototype._setItemNavigationTabIndex=function(t){if(this._oItemNavigation){this._oItemNavigation.iActiveTabIndex=t;this._oItemNavigation.iTabIndex=t;}};
c.prototype.setKeyboardMode=function(k){this.setProperty("keyboardMode",k,true);if(this.isActive()){var t=(k==sap.m.ListKeyboardMode.Edit)?-1:0;this.$("listUl").prop("tabIndex",t);this.$("after").prop("tabIndex",t);this._setItemNavigationTabIndex(t);}return this;};
c.prototype.setItemFocusable=function(o){if(!this._oItemNavigation){return;}var i=this._oItemNavigation.getItemDomRefs();var d=i.indexOf(o.getDomRef());if(d>=0){this._oItemNavigation.setFocusedIndex(d);}};
c.prototype.forwardTab=function(f){this._bIgnoreFocusIn=true;this.$(f?"after":"before").focus();};
c.prototype.onsaptabnext=function(e){if(e.isMarked()||this.getKeyboardMode()==sap.m.ListKeyboardMode.Edit){return;}if(e.target.id==this.getId("nodata")){this.forwardTab(true);e.setMarked();}};
c.prototype.onsaptabprevious=function(e){if(e.isMarked()||this.getKeyboardMode()==sap.m.ListKeyboardMode.Edit){return;}var t=e.target.id;if(t==this.getId("nodata")){this.forwardTab(false);}else if(t==this.getId("trigger")){this.focusPrevious();e.preventDefault();}};
c.prototype._navToSection=function(f){var t;var i=0;var s=f?1:-1;var d=this._aNavSections.length;this._aNavSections.some(function(S,e){var g=q.sap.domById(S);if(g&&g.contains(document.activeElement)){i=e;return true;}});var o=this.getItemsContainerDomRef();var $=q.sap.byId(this._aNavSections[i]);if($[0]===o&&this._oItemNavigation){$.data("redirect",this._oItemNavigation.getFocusedIndex());}this._aNavSections.some(function(){i=(i+s+d)%d;t=q.sap.byId(this._aNavSections[i]);if(t[0]===o&&this._oItemNavigation){var r=t.data("redirect");var e=this._oItemNavigation.getItemDomRefs();var T=e[r]||o.children[0];t=q(T);}if(t.is(":focusable")){t.focus();return true;}},this);return t;};
c.prototype.onsapshow=function(e){if(e.isMarked()||e.which==q.sap.KeyCodes.F4||e.target.id!=this.getId("trigger")&&!q(e.target).hasClass(this.sNavItemClass)){return;}if(this._navToSection(true)){e.preventDefault();e.setMarked();}};
c.prototype.onsaphide=function(e){if(e.isMarked()||e.target.id!=this.getId("trigger")&&!q(e.target).hasClass(this.sNavItemClass)){return;}if(this._navToSection(false)){e.preventDefault();e.setMarked();}};
c.prototype.onkeydown=function(e){var d=(e.which==q.sap.KeyCodes.A)&&(e.metaKey||e.ctrlKey);if(e.isMarked()||!d||!q(e.target).hasClass(this.sNavItemClass)){return;}e.preventDefault();if(this.getMode()!==sap.m.ListMode.MultiSelect){return;}if(this.isAllSelectableSelected()){this.removeSelections(false,true);}else{this.selectAll(true);}e.setMarked();};
c.prototype.onmousedown=function(e){if(this._bItemNavigationInvalidated){this._startItemNavigation();}};
c.prototype.focusPrevious=function(){if(!this._oItemNavigation){return;}var n=this._oItemNavigation.getItemDomRefs();var i=this._oItemNavigation.getFocusedIndex();var $=q(n[i]);var r=$.control(0)||{};var t=r.getTabbables?r.getTabbables():$.find(":sapTabbable");var f=t.eq(-1).add($).eq(-1);this.iAnnounceDetails=2;f.focus();};
c.prototype.onfocusin=function(e){if(this._bIgnoreFocusIn){this._bIgnoreFocusIn=false;e.stopImmediatePropagation(true);return;}if(this._bItemNavigationInvalidated){this._startItemNavigation();}if(e.isMarked()||!this._oItemNavigation||this.getKeyboardMode()==sap.m.ListKeyboardMode.Edit||e.target.id!=this.getId("after")){return;}this.focusPrevious();e.setMarked();};
c.prototype.onsapfocusleave=function(e){if(!this.iAnnounceDetails&&this._oItemNavigation&&!this.getNavigationRoot().contains(e.target)){this.iAnnounceDetails=1;}};
c.prototype.onItemArrowUpDown=function(o,e){var i=this.getItems(true),d=i.indexOf(o)+(e.type=="sapup"?-1:1),f=i[d];if(f&&f.isGroupHeader()){f=i[d+(e.type=="sapup"?-1:1)];}if(!f){return;}var t=f.getTabbables(),F=o.getTabbables().index(e.target),E=t.eq(t[F]?F:-1);E[0]?E.focus():f.focus();e.preventDefault();e.setMarked();};
return c;},true);
sap.ui.predefine('sap/m/ListBaseRenderer',['jquery.sap.global','sap/ui/core/theming/Parameters','./ListItemBaseRenderer'],function(q,P,L){"use strict";var a={};a.ModeOrder={None:0,Delete:1,MultiSelect:-1,SingleSelect:1,SingleSelectLeft:-1,SingleSelectMaster:0};
a.render=function(r,c){r.write("<div");r.addClass("sapMList");r.writeControlData(c);r.writeAttribute("tabindex","-1");if(c.getInset()){r.addClass("sapMListInsetBG");}if(c.getWidth()){r.addStyle("width",c.getWidth());}if(c.getBackgroundDesign){r.addClass("sapMListBG"+c.getBackgroundDesign());}var t=c.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}this.renderContainerAttributes(r,c);r.writeStyles();r.writeClasses();r.write(">");var h=c.getHeaderText();var H=c.getHeaderToolbar();if(H){H.setDesign(sap.m.ToolbarDesign.Transparent,true);H.addStyleClass("sapMListHdrTBar");r.renderControl(H);}else if(h){r.write("<header class='sapMListHdr'");r.writeAttribute("id",c.getId("header"));r.write(">");r.writeEscaped(h);r.write("</header>");}var I=c.getInfoToolbar();if(I){I.setDesign(sap.m.ToolbarDesign.Info,true);I.addStyleClass("sapMListInfoTBar");r.renderControl(I);}var b=c.getItems(),s=c.getShowNoData(),R=c.shouldRenderItems()&&b.length,T=c.getKeyboardMode()==sap.m.ListKeyboardMode.Edit?-1:0,u=c.getGrowingDirection()==sap.m.ListGrowingDirection.Upwards&&c.getGrowing();if(u){this.renderGrowing(r,c);}if(R||s){this.renderDummyArea(r,c,"before",-1);}this.renderListStartAttributes(r,c);r.writeAccessibilityState(c,this.getAccessibilityState(c));r.addClass("sapMListUl");if(c._iItemNeedsHighlight){r.addClass("sapMListHighlight");}r.writeAttribute("id",c.getId("listUl"));if(R||s){r.writeAttribute("tabindex",T);}r.addClass("sapMListShowSeparators"+c.getShowSeparators());r.addClass("sapMListMode"+c.getMode());c.getInset()&&r.addClass("sapMListInset");r.writeClasses();r.writeStyles();r.write(">");this.renderListHeadAttributes(r,c);if(R){if(u){b.reverse();}for(var i=0;i<b.length;i++){r.renderControl(b[i]);}}if(!R&&s){this.renderNoData(r,c);}this.renderListEndAttributes(r,c);if(R||s){this.renderDummyArea(r,c,"after",T);}if(!u){this.renderGrowing(r,c);}if(c.getFooterText()){r.write("<footer class='sapMListFtr'");r.writeAttribute("id",c.getId("footer"));r.write(">");r.writeEscaped(c.getFooterText());r.write("</footer>");}r.write("</div>");};
a.renderContainerAttributes=function(r,c){};
a.renderListHeadAttributes=function(r,c){};
a.renderListStartAttributes=function(r,c){r.write("<ul");c.addNavSection(c.getId("listUl"));};
a.getAriaRole=function(c){return"listbox";};
a.getAriaLabelledBy=function(c){var h=c.getHeaderToolbar();if(h){return h.getTitleId();}if(c.getHeaderText()){return c.getId("header");}};
a.getAriaDescribedBy=function(c){if(c.getFooterText()){return c.getId("footer");}};
a.getAccessibilityState=function(c){return{role:this.getAriaRole(c),labelledby:{value:this.getAriaLabelledBy(c),append:true},describedby:{value:this.getAriaDescribedBy(c),append:true}};};
a.renderListEndAttributes=function(r,c){r.write("</ul>");};
a.renderNoData=function(r,c){r.write("<li");r.writeAttribute("tabindex",c.getKeyboardMode()==sap.m.ListKeyboardMode.Navigation?-1:0);r.writeAttribute("id",c.getId("nodata"));r.addClass("sapMLIB sapMListNoData sapMLIBTypeInactive");L.addFocusableClasses.call(L,r);r.writeClasses();r.write(">");r.write("<div");r.addClass("sapMListNoDataText");r.writeAttribute("id",c.getId("nodata-text"));r.writeClasses();r.write(">");r.writeEscaped(c.getNoDataText(true));r.write("</div>");r.write("</li>");};
a.renderDummyArea=function(r,c,A,t){r.write("<div");r.writeAttribute("id",c.getId(A));r.writeAttribute("tabindex",t);if(sap.ui.Device.system.desktop){r.addClass("sapMListDummyArea").writeClasses();}r.write("></div>");};
a.renderGrowing=function(r,c){var g=c._oGrowingDelegate;if(!g){return;}g.render(r);};
return a;},true);
sap.ui.predefine('sap/m/ListItemBase.designtime',[],function(){"use strict";return{actions:{remove:{changeType:"hideControl"},reveal:{changeType:"unhideControl"}},name:{singular:"LIST_ITEM_BASE_NAME",plural:"LIST_ITEM_BASE_NAME_PLURAL"}};},false);
sap.ui.predefine('sap/m/ListItemBase',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/IconPool','sap/ui/core/Icon','sap/m/Button'],function(q,l,C,I,a,B){"use strict";var b=l.ButtonType;
var L=C.extend("sap.m.ListItemBase",{metadata:{library:"sap.m",properties:{type:{type:"sap.m.ListType",group:"Misc",defaultValue:sap.m.ListType.Inactive},visible:{type:"boolean",group:"Appearance",defaultValue:true},unread:{type:"boolean",group:"Misc",defaultValue:false},selected:{type:"boolean",defaultValue:false},counter:{type:"int",group:"Misc",defaultValue:null},highlight:{type:"sap.ui.core.MessageType",group:"Appearance",defaultValue:"None"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{tap:{deprecated:true},detailTap:{deprecated:true},press:{},detailPress:{}},designTime:true}});
L.getAccessibilityText=function(c,d){if(!c||!c.getVisible||!c.getVisible()){return"";}var A;if(c.getAccessibilityInfo){A=c.getAccessibilityInfo();}if(!A||!c.getAccessibilityInfo){A=this.getDefaultAccessibilityInfo(c.getDomRef());}A=q.extend({type:"",description:"",children:[]},A);var o=sap.ui.getCore().getLibraryResourceBundle("sap.m"),t=A.type+" "+A.description+" ",T=c.getTooltip_AsString();if(A.enabled===false){t+=o.getText("CONTROL_DISABLED")+" ";}if(A.editable===false){t+=o.getText("CONTROL_READONLY")+" ";}if(!A.type&&T&&t.indexOf(T)==-1){t=T+" "+t;}A.children.forEach(function(e){t+=L.getAccessibilityText(e)+" ";});t=t.trim();if(d&&!t){t=o.getText("CONTROL_EMPTY");}return t;};
L.getDefaultAccessibilityInfo=function(d){if(!d){return null;}var N=window.Node,c=window.NodeFilter,t=document.createTreeWalker(d,c.SHOW_TEXT+c.SHOW_ELEMENT,function(n){if(n.type===N.ELEMENT_NODE){if(n.classList.contains("sapUiInvisibleText")){return c.FILTER_SKIP;}if(n.getAttribute("aria-hidden")=="true"||n.style.visibility=="hidden"||n.style.display=="none"){return c.FILTER_REJECT;}return c.FILTER_SKIP;}return c.FILTER_ACCEPT;},false);var T=[];while(t.nextNode()){var n=t.currentNode;if(n.nodeType===N.TEXT_NODE){var s=(n.nodeValue||"").trim();if(s){T.push(s);}}}return{description:T.join(" ")};};
L.prototype.DetailIconURI=I.getIconURI("edit");L.prototype.DeleteIconURI=I.getIconURI("sys-cancel");L.prototype.NavigationIconURI=I.getIconURI("slim-arrow-right");L.prototype.TagName="li";
L.prototype.init=function(){this._active=false;this._bGroupHeader=false;this._bNeedsHighlight=false;};
L.prototype.onAfterRendering=function(){this.informList("DOMUpdate",true);this._checkHighlight();};
L.prototype.getBindingContextPath=function(m){var o=this.getList();if(o&&!m){m=(o.getBindingInfo("items")||{}).model;}var c=this.getBindingContext(m);if(c){return c.getPath();}};
L.prototype.isSelectedBoundTwoWay=function(){var o=this.getBinding("selected");if(o&&o.getBindingMode()==sap.ui.model.BindingMode.TwoWay){return true;}};
L.prototype.getList=function(){var p=this.getParent();if(p instanceof sap.m.ListBase){return p;}};
L.prototype.getListProperty=function(p,f){var o=this.getList();if(o){p=q.sap.charToUpperCase(p);return o["get"+p]();}return f;};
L.prototype.informList=function(e,p,P){var o=this.getList();if(o){var m="onItem"+e;if(o[m]){o[m](this,p,P);}}};
L.prototype.informSelectedChange=function(s){var o=this.getList();if(o){o.onItemSelectedChange(this,s);this.bSelectedDelayed=undefined;}else{this.bSelectedDelayed=s;}};
L.prototype.getAccessibilityType=function(o){return o.getText("ACC_CTR_TYPE_OPTION");};
L.prototype.getAccessibilityDescription=function(o){var O=[],t=sap.m.ListType,T=this.getType(),h=this.getHighlight(),s=this.getTooltip_AsString();if(this.getSelected()){O.push(o.getText("LIST_ITEM_SELECTED"));}if(h!="None"){O.push(o.getText("LIST_ITEM_STATE_"+h.toUpperCase()));}if(this.getUnread()&&this.getListProperty("showUnread")){O.push(o.getText("LIST_ITEM_UNREAD"));}if(this.getCounter()){O.push(o.getText("LIST_ITEM_COUNTER",this.getCounter()));}if(T==t.Navigation){O.push(o.getText("LIST_ITEM_NAVIGATION"));}else{if(T==t.Detail||T==t.DetailAndActive){O.push(o.getText("LIST_ITEM_DETAIL"));}if(T==t.Active||T==t.DetailAndActive){O.push(o.getText("LIST_ITEM_ACTIVE"));}}if(this.getContentAnnouncement){O.push((this.getContentAnnouncement(o)||"").trim());}if(s){O.push(s);}return O.join(" ");};
L.prototype.getAccessibilityInfo=function(){var o=sap.ui.getCore().getLibraryResourceBundle("sap.m");return{type:this.getAccessibilityType(o),description:this.getAccessibilityDescription(o),focusable:true};};
L.prototype.getMode=function(){return this.getListProperty("mode","");};
L.prototype.updateAccessibilityState=function(A){var t=this.$();if(!t.length){return;}var i=t.parent().children(".sapMLIB");t.attr(q.extend({"aria-setsize":i.length,"aria-posinset":i.index(t)+1},A));};
L.prototype.getDeleteControl=function(){if(this._oDeleteControl){return this._oDeleteControl;}this._oDeleteControl=new B({id:this.getId()+"-imgDel",icon:this.DeleteIconURI,type:b.Transparent,tooltip:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("LIST_ITEM_DELETE")}).addStyleClass("sapMLIBIconDel sapMLIBSelectD").setParent(this,null,true).attachPress(function(e){this.informList("Delete");},this);this._oDeleteControl._bExcludeFromTabChain=true;return this._oDeleteControl;};
L.prototype.getDetailControl=function(){if(this._oDetailControl){return this._oDetailControl;}this._oDetailControl=new B({id:this.getId()+"-imgDet",icon:this.DetailIconURI,type:b.Transparent,tooltip:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("LIST_ITEM_EDIT")}).addStyleClass("sapMLIBType sapMLIBIconDet").setParent(this,null,true).attachPress(function(){this.fireDetailTap();this.fireDetailPress();},this);this._oDetailControl._bExcludeFromTabChain=true;return this._oDetailControl;};
L.prototype.getNavigationControl=function(){if(this._oNavigationControl){return this._oNavigationControl;}this._oNavigationControl=new a({id:this.getId()+"-imgNav",src:this.NavigationIconURI,useIconTooltip:false,noTabStop:true}).setParent(this,null,true).addStyleClass("sapMLIBType sapMLIBImgNav");return this._oNavigationControl;};
L.prototype.getSingleSelectControl=function(){if(this._oSingleSelectControl){return this._oSingleSelectControl;}this._oSingleSelectControl=new sap.m.RadioButton({id:this.getId()+"-selectSingle",groupName:this.getListProperty("id")+"_selectGroup",activeHandling:false,selected:this.getSelected()}).addStyleClass("sapMLIBSelectS").setParent(this,null,true).setTabIndex(-1).attachSelect(function(e){var s=e.getParameter("selected");this.setSelected(s);this.informList("Select",s);},this);return this._oSingleSelectControl;};
L.prototype.getMultiSelectControl=function(){if(this._oMultiSelectControl){return this._oMultiSelectControl;}this._oMultiSelectControl=new sap.m.CheckBox({id:this.getId()+"-selectMulti",activeHandling:false,selected:this.getSelected()}).addStyleClass("sapMLIBSelectM").setParent(this,null,true).setTabIndex(-1).attachSelect(function(e){var s=e.getParameter("selected");this.setSelected(s);this.informList("Select",s);},this);return this._oMultiSelectControl;};
L.prototype.getModeControl=function(u){var m=this.getMode(),c=sap.m.ListMode;if(!m||m==c.None){return;}if(m==c.Delete){return this.getDeleteControl();}var s=null;if(m==c.MultiSelect){s=this.getMultiSelectControl();}else{s=this.getSingleSelectControl();}if(s&&u){s.setSelected(this.getSelected());}return s;};
L.prototype.getTypeControl=function(){var t=this.getType(),T=sap.m.ListType;if(t==T.Detail||t==T.DetailAndActive){return this.getDetailControl();}if(t==T.Navigation){return this.getNavigationControl();}};
L.prototype.destroyControls=function(c){c.forEach(function(s){s="_o"+s+"Control";if(this[s]){this[s].destroy("KeepDom");this[s]=null;}},this);};
L.prototype.isActionable=function(){return this.getListProperty("includeItemInSelection")||this.getMode()==sap.m.ListMode.SingleSelectMaster||(this.getType()!=sap.m.ListType.Inactive&&this.getType()!=sap.m.ListType.Detail);};
L.prototype.exit=function(){this._oLastFocused=null;this._checkHighlight(false);this.setActive(false);this.destroyControls(["Delete","SingleSelect","MultiSelect","Detail","Navigation"]);};
L.prototype.isSelectable=function(){var m=this.getMode();return!(m==sap.m.ListMode.None||m==sap.m.ListMode.Delete);};
L.prototype.getSelected=function(){if(this.isSelectable()){return this.getProperty("selected");}return false;};
L.prototype.isSelected=L.prototype.getSelected;
L.prototype.setSelected=function(s,d){s=this.validateProperty("selected",s);if(!this.isSelectable()||s==this.getSelected()){return this;}if(!d){this.informSelectedChange(s);}var S=this.getModeControl();if(S){S.setSelected(s);}this.updateSelectedDOM(s,this.$());this.setProperty("selected",s,true);return this;};
L.prototype.updateSelectedDOM=function(s,t){t.toggleClass("sapMLIBSelected",s);t.attr("aria-selected",s);};
L.prototype.setParent=function(p){C.prototype.setParent.apply(this,arguments);if(!p){this._bGroupHeader=false;return;}this.informList("Inserted",this.bSelectedDelayed);return this;};
L.prototype.setBindingContext=function(){C.prototype.setBindingContext.apply(this,arguments);this.informList("BindingContextSet");return this;};
L.prototype.isGroupHeader=function(){return this._bGroupHeader;};
L.prototype.isIncludedIntoSelection=function(){var m=this.getMode(),M=sap.m.ListMode;return(m==M.SingleSelectMaster||(this.getListProperty("includeItemInSelection")&&(m==M.SingleSelectLeft||m==M.SingleSelect||m==M.MultiSelect)));};
L.prototype._checkHighlight=function(n){if(n==undefined){n=(this.getVisible()&&this.getHighlight()!="None");}if(this._bNeedsHighlight!=n){this._bNeedsHighlight=n;this.informList("HighlightChange",n);}};
L.prototype.hasActiveType=function(){var t=sap.m.ListType,T=this.getType();return(T==t.Active||T==t.Navigation||T==t.DetailAndActive);};
L.prototype.setActive=function(A){if(A==this._active){return this;}if(A&&this.getListProperty("activeItem")){return this;}var t=this.$();this._active=A;this._activeHandling(t);if(this.getType()==sap.m.ListType.Navigation){this._activeHandlingNav(t);}if(A){this._activeHandlingInheritor(t);}else{this._inactiveHandlingInheritor(t);}this.informList("ActiveChange",A);};
L.prototype.ontap=function(e){if(this._eventHandledByControl){return;}if(this.isIncludedIntoSelection()){if(this.getMode()==sap.m.ListMode.MultiSelect){this.setSelected(!this.getSelected());this.informList("Select",this.getSelected());}else if(!this.getSelected()){this.setSelected(true);this.informList("Select",true);}}else if(this.hasActiveType()){window.clearTimeout(this._timeoutIdStart);window.clearTimeout(this._timeoutIdEnd);this.setActive(true);if(sap.ui.Device.os.ios){this.focus();}q.sap.delayedCall(180,this,function(){this.setActive(false);});q.sap.delayedCall(0,this,function(){this.fireTap();this.firePress();});}this.informList("Press",e.srcControl);};
L.prototype.ontouchstart=function(e){this._eventHandledByControl=e.isMarked();var t=e.targetTouches[0];this._touchedY=t.clientY;this._touchedX=t.clientX;if(this._eventHandledByControl||e.touches.length!=1||!this.hasActiveType()){return;}this._timeoutIdStart=q.sap.delayedCall(100,this,function(){this.setActive(true);e.setMarked();});};
L.prototype.ontouchmove=function(e){if((this._active||this._timeoutIdStart)&&(Math.abs(this._touchedY-e.targetTouches[0].clientY)>10||Math.abs(this._touchedX-e.targetTouches[0].clientX)>10)){clearTimeout(this._timeoutIdStart);this._timeoutIdStart=null;this._timeoutIdEnd=null;this.setActive(false);}};
L.prototype.ontouchend=function(e){if(e.targetTouches.length==0&&this.hasActiveType()){this._timeoutIdEnd=q.sap.delayedCall(100,this,function(){this.setActive(false);});}};
L.prototype.ontouchcancel=L.prototype.ontouchend;
L.prototype._activeHandlingNav=function(){};
L.prototype._activeHandlingInheritor=function(){};
L.prototype._inactiveHandlingInheritor=function(){};
L.prototype._activeHandling=function(t){t.toggleClass("sapMLIBActive",this._active);if(sap.ui.Device.system.Desktop&&this.isActionable()){t.toggleClass("sapMLIBHoverable",!this._active);}};
L.prototype.onsapspace=function(e){if(e.srcControl!==this){return;}e.preventDefault();if(e.isMarked()||!this.isSelectable()){return;}if(this.getMode()==sap.m.ListMode.MultiSelect){this.setSelected(!this.getSelected());this.informList("Select",this.getSelected());}else if(!this.getSelected()){this.setSelected(true);this.informList("Select",true);}e.setMarked();};
L.prototype.onsapenter=function(e){var o=this.getList();if(e.isMarked()||!o){return;}var k=sap.m.ListKeyboardMode;if(e.srcControl!==this&&o.getKeyboardMode()==k.Edit){o.setKeyboardMode(k.Navigation);this._switchFocus(e);return;}if(e.srcControl!==this){return;}if(this.isIncludedIntoSelection()){this.onsapspace(e);}else if(this.hasActiveType()){e.setMarked();this.setActive(true);q.sap.delayedCall(180,this,function(){this.setActive(false);});q.sap.delayedCall(0,this,function(){this.fireTap();this.firePress();});}o.onItemPress(this,e.srcControl);};
L.prototype.onsapdelete=function(e){if(e.isMarked()||e.srcControl!==this||this.getMode()!=sap.m.ListMode.Delete){return;}this.informList("Delete");e.preventDefault();e.setMarked();};
L.prototype._switchFocus=function(e){var o=this.getList();if(!o){return;}var t=this.getTabbables();if(e.srcControl!==this){o._iLastFocusPosOfItem=t.index(e.target);this.focus();}else if(t.length){var f=o._iLastFocusPosOfItem||0;f=t[f]?f:-1;t.eq(f).focus();}e.preventDefault();e.setMarked();};
L.prototype.onkeydown=function(e){if(e.isMarked()){return;}var k=q.sap.KeyCodes;if(e.which==k.F7){this._switchFocus(e);return;}if(e.which==k.F2){if(e.srcControl===this&&this.getType().indexOf("Detail")==0&&this.hasListeners("detailPress")||this.hasListeners("detailTap")){this.fireDetailTap();this.fireDetailPress();e.preventDefault();e.setMarked();}else{var o=this.getList();if(o){this.$().prop("tabIndex",-1);var K=sap.m.ListKeyboardMode;o.setKeyboardMode(o.getKeyboardMode()==K.Edit?K.Navigation:K.Edit);this._switchFocus(e);}}}};
L.prototype.getTabbables=function(){return this.$().find(":sapTabbable");};
L.prototype.onsaptabnext=function(e){var o=this.getList();if(!o||e.isMarked()||o.getKeyboardMode()==sap.m.ListKeyboardMode.Edit){return;}var c=this.getTabbables().get(-1)||this.getDomRef();if(e.target===c){o.forwardTab(true);e.setMarked();}};
L.prototype.onsaptabprevious=function(e){var o=this.getList();if(!o||e.isMarked()||o.getKeyboardMode()==sap.m.ListKeyboardMode.Edit){return;}if(e.target===this.getDomRef()){o.forwardTab(false);e.setMarked();}};
L.prototype.onfocusin=function(e){var o=this.getList();if(!o||e.isMarked()){return;}if(e.srcControl===this){o.onItemFocusIn(this);return;}if(o.getKeyboardMode()==sap.m.ListKeyboardMode.Edit||!q(e.target).is(":sapFocusable")){return;}q.sap.delayedCall(0,o,"setItemFocusable",[this]);e.setMarked();};
L.prototype.onsapup=function(e){if(e.isMarked()||e.srcControl===this||this.getListProperty("keyboardMode")===sap.m.ListKeyboardMode.Navigation){return;}this.informList("ArrowUpDown",e);};
L.prototype.onsapdown=L.prototype.onsapup;return L;},true);
sap.ui.predefine('sap/m/ListItemBaseRenderer',['jquery.sap.global','sap/ui/core/IconPool','sap/ui/core/theming/Parameters'],function(q,I,P){"use strict";var L={};var a={};
L.renderInvisible=function(r,l){this.openItemTag(r,l);r.writeInvisiblePlaceholderData(l);r.write(">");this.closeItemTag(r,l);};
L.renderHighlight=function(r,l){var h=l.getHighlight();if(h=="None"){return;}r.write("<div");r.addClass("sapMLIBHighlight");r.addClass("sapMLIBHighlight"+h);r.writeClasses();r.write("></div>");};
L.isModeMatched=function(m,o){var O=(sap.m.ListBaseRenderer||{}).ModeOrder||{};return(O[m]==o);};
L.renderMode=function(r,l,o){var m=l.getMode();if(!this.isModeMatched(m,o)){return;}var M=l.getModeControl(true);if(M){this.renderModeContent(r,l,M);}};
L.renderModeContent=function(r,l,m){this.decorateMode(m,l);r.renderControl(m);};
L.decorateMode=function(m,l){m.removeStyleClass("sapMLIBSelectAnimation sapMLIBUnselectAnimation");if(!sap.ui.getCore().getConfiguration().getAnimation()||!l.getListProperty("modeAnimationOn")){return;}var M=l.getMode(),s=l.getListProperty("lastMode");if(!s||s==M){return;}if(M==sap.m.ListMode.None){m.addStyleClass("sapMLIBUnselectAnimation");}else{m.addStyleClass("sapMLIBSelectAnimation");}};
L.renderCounter=function(r,l){var c=l.getCounter();if(c){this.renderCounterContent(r,l,c);}};
L.renderCounterContent=function(r,l,c){r.write("<div");r.writeAttribute("id",l.getId()+"-counter");var A=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("LIST_ITEM_COUNTER",c);r.writeAttribute("aria-label",A);r.addClass("sapMLIBCounter");r.writeClasses();r.write(">");r.write(c);r.write("</div>");};
L.renderType=function(r,l){var t=l.getTypeControl();if(t){r.renderControl(t);}};
L.openItemTag=function(r,l){r.write("<"+l.TagName);};
L.closeItemTag=function(r,l){r.write("</"+l.TagName+">");};
L.renderTabIndex=function(r,l){r.writeAttribute("tabindex","-1");};
L.renderTooltip=function(r,l){var t=l.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}};
L.addFocusableClasses=function(r,l){if(sap.ui.Device.system.desktop){r.addClass("sapMLIBFocusable");this.addLegacyOutlineClass(r,l);}};
L.addLegacyOutlineClass=function(r,l){if(sap.ui.Device.browser.msie||sap.ui.Device.browser.edge){r.addClass("sapMLIBLegacyOutline");}};
L.getAriaAnnouncement=function(k,b){if(a[k]){return a[k];}b=b||"LIST_ITEM_"+k.toUpperCase();a[k]=new sap.ui.core.InvisibleText({text:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText(b)}).toStatic().getId();return a[k];};
L.getAriaRole=function(l){return"option";};
L.getAriaLabelledBy=function(l){if(!l.getContentAnnouncement&&l.getAriaLabelledBy().length){return l.getId();}};
L.getAriaDescribedBy=function(l){if(l.getContentAnnouncement){return"";}var d=[],t=l.getType(),T=sap.m.ListType;if(l.getListProperty("showUnread")&&l.getUnread()){d.push(this.getAriaAnnouncement("unread"));}if(l.getMode()==sap.m.ListMode.Delete){d.push(this.getAriaAnnouncement("deletable"));}if(t==T.Navigation){d.push(this.getAriaAnnouncement("navigation"));}else{if(t==T.Detail||t==T.DetailAndActive){d.push(this.getAriaAnnouncement("detail"));}if(t==T.Active||t==T.DetailAndActive){d.push(this.getAriaAnnouncement("active"));}}return d.join(" ");};
L.getAccessibilityState=function(l){var A=this.getAriaLabelledBy(l),s=this.getAriaDescribedBy(l),m={role:this.getAriaRole(l)};if(l.isSelectable()){m.selected=l.getProperty("selected");}if(A){m.labelledby={value:A.trim(),append:true};}if(s){m.describedby={value:s.trim(),append:true};}return m;};
L.renderLIContent=function(r,l){};
L.renderLIAttributes=function(r,l){};
L.renderContentFormer=function(r,l){this.renderHighlight(r,l);this.renderMode(r,l,-1);};
L.renderContentLatter=function(r,l){this.renderCounter(r,l);this.renderType(r,l);this.renderMode(r,l,1);};
L.renderLIContentWrapper=function(r,l){r.write('<div class="sapMLIBContent"');r.writeAttribute("id",l.getId()+"-content");r.write(">");this.renderLIContent(r,l);r.write('</div>');};
L.render=function(r,l){if(!l.getVisible()){this.renderInvisible(r,l);return false;}this.openItemTag(r,l);r.writeControlData(l);r.addClass("sapMLIB");r.addClass("sapMLIB-CTX");r.addClass("sapMLIBShowSeparator");r.addClass("sapMLIBType"+l.getType());if(sap.ui.Device.system.desktop&&l.isActionable()){r.addClass("sapMLIBActionable");r.addClass("sapMLIBHoverable");}if(l.getSelected()){r.addClass("sapMLIBSelected");}if(l.getListProperty("showUnread")&&l.getUnread()){r.addClass("sapMLIBUnread");}this.addFocusableClasses(r,l);this.renderTooltip(r,l);this.renderTabIndex(r,l);if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAccessibilityState(l,this.getAccessibilityState(l));}this.renderLIAttributes(r,l);r.writeClasses();r.writeStyles();r.write(">");this.renderContentFormer(r,l);this.renderLIContentWrapper(r,l);this.renderContentLatter(r,l);this.closeItemTag(r,l);};
return L;},true);
sap.ui.predefine('sap/m/ListRenderer',['jquery.sap.global','sap/ui/core/Renderer','./ListBaseRenderer'],function(q,R,L){"use strict";var a=R.extend(L);
a.render=function(r,c){if(!c.getColumns().length){L.render.call(this,r,c);return;}if(c._isColumnsIncompatible()){q.sap.log.warning("Does not render sap.m.List#"+c.getId()+" with columns aggregation when compatibility version is 1.16 or higher. Instead use sap.m.Table control!");return;}q.sap.require("sap.m.TableRenderer");var o=q.extend({},this,sap.m.TableRenderer);L.render.call(o,r,c);};
return a;},true);
sap.ui.predefine('sap/m/MaskEnabler',['sap/ui/core/Control','./InputBase'],function(C,I){"use strict";var M=function(){var E='^';this.init=M.init=function(){I.prototype.init.call(this);this._iCaretTimeoutId=null;this._iUserInputStartPosition=null;this._iMaskLength=null;this._sOldInputValue=null;this._oRules=null;this._oTempValue=null;this._bSkipSetupMaskVariables=null;this._setDefaultRules();};this.exit=M.exit=function(){this._iCaretTimeoutId=null;this._iUserInputStartPosition=null;this._iMaskLength=null;this._sOldInputValue=null;this._oRules=null;this._oTempValue=null;this._bSkipSetupMaskVariables=null;};this.onBeforeRendering=function(){var v=this._validateDependencies();if(v){jQuery.sap.log.warning("Invalid mask input: "+v);}I.prototype.onBeforeRendering.apply(this,arguments);};this.onAfterRendering=function(){I.prototype.onAfterRendering.apply(this,arguments);};this.onfocusin=M.onfocusin=function(e){this._sOldInputValue=this._getInputValue();I.prototype.onfocusin.apply(this,arguments);if(!this._oTempValue.differsFromOriginal()||!this._isValidInput(this._sOldInputValue)){this._applyMask();}this._positionCaret(true);};this.onfocusout=function(e){this.bFocusoutDueRendering=this.bRenderingPhase;this.$().toggleClass("sapMFocus",false);jQuery(document).off('.sapMIBtouchstart');if(this.bRenderingPhase){return;}this.closeValueStateMessage();this._inputCompletedHandler();};this.oninput=function(e){I.prototype.oninput.apply(this,arguments);this._applyMask();this._positionCaret(false);};this.onkeypress=function(e){this._keyPressHandler(e);};this.onkeydown=M.onkeydown=function(e){var k=this._parseKeyBoardEvent(e),b=sap.ui.Device.browser,i;i=(k.bBackspace||k.bDelete)&&b.msie&&b.version<10;if(!i){I.prototype.onkeydown.apply(this,arguments);}this._keyDownHandler(e,k);};this.onsapenter=function(e){};this.onsapfocusleave=function(e){};this.setValue=M.setValue=function(v){v=this.validateProperty('value',v);I.prototype.setValue.call(this,v);this._sOldInputValue=v;if(!this._oTempValue){this._setupMaskVariables();}if(this._oTempValue._aInitial.join('')!==v){this._applyRules(v);}return this;};this.addAggregation=function(A,o,s){if(A==="rules"){if(!this._validateRegexAgainstPlaceHolderSymbol(o)){return this;}this._removeRuleWithSymbol(o.getMaskFormatSymbol());C.prototype.addAggregation.apply(this,arguments);if(!this._bSkipSetupMaskVariables){this._setupMaskVariables();}return this;}return C.prototype.addAggregation.apply(this,arguments);};this.insertAggregation=function(A,o,i,s){if(A==="rules"){if(!this._validateRegexAgainstPlaceHolderSymbol(o)){return this;}this._removeRuleWithSymbol(o.getMaskFormatSymbol());C.prototype.insertAggregation.apply(this,arguments);this._setupMaskVariables();return this;}return C.prototype.insertAggregation.apply(this,arguments);};this._validateRegexAgainstPlaceHolderSymbol=function(r){if(new RegExp(r.getRegex()).test(this.getPlaceholderSymbol())){jQuery.sap.log.error("Rejecting input mask rule because it includes the currently set placeholder symbol.");return false;}return true;};this.setPlaceholderSymbol=function(s){var S;if(!/^.$/i.test(s)){jQuery.sap.log.error("Invalid placeholder symbol string given");return this;}S=this.getRules().some(function(r){return new RegExp(r.getRegex()).test(s);});if(S){jQuery.sap.log.error("Rejecting placeholder symbol because it is included as a regex in an existing mask input rule.");}else{this.setProperty("placeholderSymbol",s);this._setupMaskVariables();}return this;};this.setMask=function(m){if(!m){var e="Setting an empty mask is pointless. Make sure you set it with a non-empty value.";jQuery.sap.log.warning(e);return this;}this.setProperty("mask",m,true);this._setupMaskVariables();return this;};this._isCharAllowed=function(c,i){return this._oRules.applyCharAt(c,i);};this._feedReplaceChar=function(c,p,s){return c;};var a=function(c){this._aInitial=c.slice(0);this._aContent=c;};a.prototype.setCharAt=function(c,p){this._aContent[p]=c;};a.prototype.charAt=function(p){return this._aContent[p];};a.prototype.toString=function(){return this._aContent.join('');};a.prototype.differsFromOriginal=function(){return this.differsFrom(this._aInitial);};a.prototype.differsFrom=function(v){var i=0;if(v.length!==this._aContent.length){return true;}for(;i<v.length;i++){if(v[i]!==this._aContent[i]){return true;}}return false;};a.prototype.getSize=function(){return this._aContent.length;};var T=function(r){this._aRules=r;};T.prototype.nextTo=function(c){if(typeof c==="undefined"){c=-1;}do{c++;}while(c<this._aRules.length&&!this._aRules[c]);return c;};T.prototype.previousTo=function(c){do{c--;}while(!this._aRules[c]&&c>0);return c;};T.prototype.hasRuleAt=function(i){return!!this._aRules[i];};T.prototype.applyCharAt=function(c,i){return this._aRules[i].test(c);};this._setDefaultRules=function(){this._bSkipSetupMaskVariables=true;this.addRule(new sap.m.MaskInputRule({maskFormatSymbol:"a",regex:"[A-Za-z]"}),true);this.addRule(new sap.m.MaskInputRule({maskFormatSymbol:"9",regex:"[0-9]"}),true);this._bSkipSetupMaskVariables=false;};this._validateDependencies=function(){var p=this.getPlaceholderSymbol(),r=this.getRules(),m=[],e=[];if(!this.getMask()){e.push("Empty mask");}if(r.length){m=[];r.every(function(R){var s=R.getMaskFormatSymbol(),c=s!==p,b;b=!m.some(function(S){return s===S;});m.push(s);if(!c){e.push("Placeholder symbol is the  same as the existing rule's mask format symbol");}if(!b){e.push("Duplicated rule's maskFormatSymbol ["+s+"]");}return c&&b;});}return e.length?e.join(". "):null;};this._removeRuleWithSymbol=function(s){var S=this._findRuleBySymbol(s,this.getRules());if(S){this.removeAggregation('rules',S.oRule);S.oRule.destroy();}};this._findRuleBySymbol=function(m,r){var R=null;if(typeof m!=="string"||m.length!==1){jQuery.sap.log.error(m+" is not a valid mask rule symbol");return null;}jQuery.each(r,function(i,o){if(o.getMaskFormatSymbol()===m){R={oRule:o,iIndex:i};return false;}});return R;};this._getTextSelection=function(){var _=jQuery(this.getFocusDomRef());if(!_&&(_.length===0||_.is(":hidden"))){return;}return{iFrom:_[0].selectionStart,iTo:_[0].selectionEnd,bHasSelection:(_[0].selectionEnd-_[0].selectionStart!==0)};};this._setCursorPosition=function(p){if(p<0){p=0;}return jQuery(this.getFocusDomRef()).cursorPos(p);};this._getCursorPosition=function(){return jQuery(this.getFocusDomRef()).cursorPos();};this._setupMaskVariables=function(){var r=this.getRules(),m=this.getMask(),s=this._getSkipIndexes(m),b=this._getMaskArray(m,s),p=this.getPlaceholderSymbol(),i=this._buildMaskValueArray(b,p,r,s),t=this._buildRules(b,r,s);this._oTempValue=new a(i);this._iMaskLength=t.length;this._oRules=new T(t);this._iUserInputStartPosition=this._oRules.nextTo();};this._getMaskArray=function(m,s){var l=Array.isArray(s)?s.length:0,b=(m)?m.split(""):[],i;for(i=0;i<l;i++){b.splice(s[i],1);}return b;};this._getSkipIndexes=function(m){var l=(m)?m.length:0,i,s=[],p=0,L=false;for(i=0;i<l;i++){if(m[i]===E&&!L){s.push(i-p);L=true;p++;}else{L=false;}}return s;};this._applyMask=function(){var m=this._getInputValue();if(!this.getEditable()){return;}this._applyAndUpdate(m);};this._resetTempValue=function(f,t){var i,p=this.getPlaceholderSymbol();if(typeof f==="undefined"||f===null){f=0;t=this._oTempValue.getSize()-1;}for(i=f;i<=t;i++){if(this._oRules.hasRuleAt(i)){this._oTempValue.setCharAt(p,i);}}};this._applyAndUpdate=function(m){this._applyRules(m);this.updateDomValue(this._oTempValue.toString());};this._findFirstPlaceholderPosition=function(){return this._oTempValue.toString().indexOf(this.getPlaceholderSymbol());};this._applyRules=function(i){var c,b=0,m,p=this.getPlaceholderSymbol(),d;for(m=0;m<this._iMaskLength;m++){if(this._oRules.hasRuleAt(m)){this._oTempValue.setCharAt(p,m);d=false;if(i.length){do{c=i.charAt(b);b++;if(this._oRules.applyCharAt(c,m)){this._oTempValue.setCharAt(c,m);d=true;}}while(!d&&(b<i.length));}if(!d){this._resetTempValue(m+1,this._iMaskLength-1);break;}}else{if(this._oTempValue.charAt(m)===i.charAt(b)){b++;}}}};this._keyPressHandler=function(e){if(!this.getEditable()){return;}var s=this._getTextSelection(),p,c,k=this._parseKeyBoardEvent(e);if(k.bCtrlKey||k.bAltKey||k.bMetaKey||k.bBeforeSpace){return;}if(!k.bEnter&&!k.bShiftLeftOrRightArrow&&!k.bHome&&!k.bEnd&&!(k.bShift&&k.bDelete)&&!(k.bCtrlKey&&k.bInsert)&&!(k.bShift&&k.bInsert)){if(s.bHasSelection){this._resetTempValue(s.iFrom,s.iTo-1);this.updateDomValue(this._oTempValue.toString());this._setCursorPosition(Math.max(this._iUserInputStartPosition,s.iFrom));}p=this._oRules.nextTo(s.iFrom-1);if(p<this._iMaskLength){c=this._feedReplaceChar(k.sChar,p,this._getInputValue());this._feedNextString(c,p);}e.preventDefault();}};this.oncut=function(e){var s=this._getTextSelection(),m=this._getMinBrowserDelay(),b=s.iFrom,i=s.iTo;I.prototype.oncut(e);if(!s.bHasSelection){return;}i=i-1;this._resetTempValue(b,i);jQuery.sap.delayedCall(m,this,function updateDomAndCursor(v,p,o){this._oTempValue._aContent=o;this.updateDomValue(v);jQuery.sap.delayedCall(m,this,this._setCursorPosition,[p]);},[this._oTempValue.toString(),Math.max(this._iUserInputStartPosition,b),this._oTempValue._aContent.slice(0)]);};this._keyDownHandler=function(e,k){var d,s,c,n,k=k||this._parseKeyBoardEvent(e);if(!this.getEditable()){return;}if(!k.bShift&&(k.bArrowRight||k.bArrowLeft)){c=this._getCursorPosition();s=this._getTextSelection();d=this._determineArrowKeyDirection(k,s);if(this._isRtlMode()&&s.bHasSelection){n=this._determineRtlCaretPositionFromSelection(d);}else{n=this._oRules[d](c);}if(this._isWebkitProblematicCase()){n=this._fixWebkitBorderPositions(n,d);}this._setCursorPosition(n);e.preventDefault();}else if(k.bEscape){this._applyAndUpdate(this._sOldInputValue);this._positionCaret(true);e.preventDefault();}else if(k.bEnter){this._inputCompletedHandler(e);}else if((k.bCtrlKey&&k.bInsert)||(k.bShift&&k.bInsert)){I.prototype.onkeydown.apply(this,arguments);}else if((!k.bShift&&k.bDelete)||k.bBackspace){this._revertKey(k);e.preventDefault();}else if(sap.ui.Device.browser.chrome&&sap.ui.Device.os.android){this._setCursorPosition(Math.max(this._iUserInputStartPosition,this._getTextSelection().iFrom));}};this._revertKey=function(k){var s=this._getTextSelection(),b=s.iFrom,e=s.iTo;if(!s.bHasSelection){if(k.bBackspace){b=this._oRules.previousTo(b);}}if(k.bBackspace||(k.bDelete&&s.bHasSelection)){e=e-1;}this._resetTempValue(b,e);this.updateDomValue(this._oTempValue.toString());this._setCursorPosition(Math.max(this._iUserInputStartPosition,b));};this._feedNextString=function(n,p){var N,A=false,b=n.split(""),s;while(b.length){s=b.splice(0,1)[0];if(this._oRules.applyCharAt(s,p)){A=true;this._oTempValue.setCharAt(s,p);p=this._oRules.nextTo(p);}}if(A){N=p;this.updateDomValue(this._oTempValue.toString());this._setCursorPosition(N);}};this._inputCompletedHandler=function(){var n=this._getInputValue(),t,v,e,b;if(this._oTempValue.differsFrom(n)){this._applyAndUpdate(n);}t=this._oTempValue.differsFromOriginal();v=t?this._oTempValue.toString():"";e=!this._sOldInputValue;b=!n;if(e&&(b||!t)){this.updateDomValue("");return;}if(this._sOldInputValue!==this._oTempValue.toString()){I.prototype.setValue.call(this,v);this._sOldInputValue=v;if(this.onChange&&!this.onChange({value:v})){this.fireChangeEvent(v);}}};this._buildMaskValueArray=function(m,p,r,s){return m.map(function(c,i){var n=s.indexOf(i)===-1,R=this._findRuleBySymbol(c,r);return(n&&R)?p:c;},this);};this._buildRules=function(m,r,s){var t=[],S,l=m.length,i=0;for(;i<l;i++){if(s.indexOf(i)===-1){S=this._findRuleBySymbol(m[i],r);t.push(S?new RegExp(S.oRule.getRegex()):null);}else{t.push(null);}}return t;};this._parseKeyBoardEvent=function(e){var p=e.which||e.keyCode,k=jQuery.sap.KeyCodes,A=p===k.ARROW_RIGHT,b=p===k.ARROW_LEFT,s=e.shiftKey;return{iCode:p,sChar:String.fromCharCode(p),bCtrlKey:e.ctrlKey,bAltKey:e.altKey,bMetaKey:e.metaKey,bShift:s,bInsert:p===jQuery.sap.KeyCodes.INSERT,bBackspace:p===k.BACKSPACE,bDelete:p===k.DELETE,bEscape:p===k.ESCAPE,bEnter:p===k.ENTER,bIphoneEscape:(sap.ui.Device.system.phone&&sap.ui.Device.os.ios&&p===127),bArrowRight:A,bArrowLeft:b,bHome:p===jQuery.sap.KeyCodes.HOME,bEnd:p===jQuery.sap.KeyCodes.END,bShiftLeftOrRightArrow:s&&(b||A),bBeforeSpace:p<k.SPACE};};this._positionCaret=function(s){var m=this.getMask(),i=this._getMinBrowserDelay(),e;clearTimeout(this._iCaretTimeoutId);e=this._findFirstPlaceholderPosition();if(e<0){e=m.length;}this._iCaretTimeoutId=jQuery.sap.delayedCall(i,this,function(){if(this.getFocusDomRef()!==document.activeElement){return;}if(s&&(e===(m.length))){this.selectText(0,e);}else{this._setCursorPosition(e);}});};this._getMinBrowserDelay=function(){return!sap.ui.Device.browser.msie?4:50;};this._isValidInput=function(s){var l=s.length,i=0,c;for(;i<l;i++){c=s[i];if(this._oRules.hasRuleAt(i)&&(!this._oRules.applyCharAt(c,i)&&c!==this.getPlaceholderSymbol())){return false;}if(!this._oRules.hasRuleAt(i)&&c!==this._oTempValue.charAt(i)){return false;}}return true;};this._isRtlChar=function(s){var l='A-Za-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02B8\u0300-\u0590\u0800-\u1FFF'+'\u2C00-\uFB1C\uFDFE-\uFE6F\uFEFD-\uFFFF',r='\u0591-\u07FF\uFB1D-\uFDFD\uFE70-\uFEFC',b=new RegExp('^[^'+l+']*['+r+']');return b.test(s);};this._fixWebkitBorderPositions=function(c,d){var t=this._oTempValue.toString().length;if(d==='nextTo'){if(c===0||c===t||c===1){c=0;}else if(c===t+1){c=1;}}else{if(c===0||c===t-1){c=t;}else if(c===-1||c===t){c=t-1;}}return c;};this._containsRtlChars=function(){var t=this._oTempValue.toString(),c=false;for(var i=0;i<t.length;i++){c=this._isRtlChar(t[i]);}return c;};this._isRtlMode=function(){return sap.ui.getCore().getConfiguration().getRTL()||(this.getTextDirection()===sap.ui.core.TextDirection.RTL);};this._isWebkitProblematicCase=function(){return(sap.ui.Device.browser.webkit&&this._isRtlMode()&&!this._containsRtlChars());};this._determineArrowKeyDirection=function(k,s){var d;if(!this._isRtlMode()||!this._containsRtlChars()||s.bHasSelection){if(k.bArrowRight){d='nextTo';}else{d='previousTo';}}else{if(k.bArrowRight){d='previousTo';}else{d='nextTo';}}return d;};this._determineRtlCaretPositionFromSelection=function(d,w){var n,s=this._getTextSelection();if(w){if(d==='nextTo'){if(!this._containsRtlChars()){n=s.iFrom;}else{n=s.iTo;}}else{if(!this._containsRtlChars()){n=s.iTo;}else{n=s.iFrom;}}}else{if(d==='nextTo'){if(!this._containsRtlChars()){n=s.iTo;}else{n=s.iFrom;}}else{if(!this._containsRtlChars()){n=s.iFrom;}else{n=s.iTo;}}}return n;};};return M;},true);
sap.ui.predefine('sap/m/MaskInput',['jquery.sap.global','./InputBase','./MaskEnabler'],function(q,I,M){"use strict";
var a=I.extend("sap.m.MaskInput",{metadata:{library:"sap.m",properties:{placeholderSymbol:{type:"string",group:"Misc",defaultValue:"_"},mask:{type:"string",group:"Misc",defaultValue:null}},aggregations:{rules:{type:"sap.m.MaskInputRule",multiple:true,singularName:"rule"}}}});
M.call(a.prototype);return a;},true);
sap.ui.predefine('sap/m/MaskInputRenderer',['sap/ui/core/Renderer','./InputBaseRenderer'],function(R,I){"use strict";var M=R.extend(I);
M.getLabelledByAnnouncement=function(c){var m=c.getMask(),p=c.getPlaceholder()||"",t=c.getTooltip_AsString()||"",r,s,a="";if(m&&m.length){r=sap.ui.getCore().getLibraryResourceBundle("sap.m");s=r.getText("MASKINPUT_SCREENREADER_TAG");if(t){t=" "+t+" ";}if(p){p=" "+p+" ";}a=s+p+t;return a;}return I.getLabelledByAnnouncement.apply(this,arguments);};
M.getDescribedByAnnouncement=function(c){var m=c.getMask(),s=c.getPlaceholderSymbol(),r,a="";if(m.length&&s){r=sap.ui.getCore().getLibraryResourceBundle("sap.m");a=r.getText("MASKINPUT_SCREENREADER_DESCRIPTION",[s,m]);return jQuery.trim(a);}return I.getDescribedByAnnouncement.apply(this,arguments);};
return M;},true);
sap.ui.predefine('sap/m/MaskInputRule',['jquery.sap.global','sap/ui/core/Element'],function(q,E){"use strict";
var M=E.extend("sap.m.MaskInputRule",{metadata:{library:"sap.m",properties:{maskFormatSymbol:{type:"string",group:"Misc",defaultValue:"*"},regex:{type:"string",group:"Misc",defaultValue:"[a-zA-Z0-9]"}}}});
M.prototype.setMaskFormatSymbol=function(n){var i=v.call(this,n);if(i){this.setProperty("maskFormatSymbol",n);}return this;};
M.prototype.setRegex=function(n){var i=a.call(this,n);if(i){this.setProperty("regex",n);}return this;};
M.prototype.toString=function(){return this.getMaskFormatSymbol()+":"+this.getRegex();};
function v(n){if(/^.$/i.test(n)){return true;}q.sap.log.error("The mask format symbol '"+n+"' is not valid");return false;}
function a(r){if(/.+/i.test(r)){return true;}q.sap.log.error("The regex value '"+r+"' is not valid");return false;}
return M;},true);
sap.ui.predefine('sap/m/Menu',['jquery.sap.global','./library','sap/ui/core/Control','./Button','./Dialog','./NavContainer','./List','./Page','./MenuListItem','sap/ui/unified/Menu','sap/ui/Device','sap/ui/core/EnabledPropagator'],function(q,l,C,B,D,N,L,P,M,U,a,E){"use strict";
var b=C.extend("sap.m.Menu",{metadata:{interfaces:["sap.ui.core.IContextMenu"],library:"sap.m",properties:{title:{type:"string",group:"Misc",defaultValue:null}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.MenuItem",multiple:true,singularName:"item",bindable:"bindable"},_dialog:{type:"sap.m.Dialog",multiple:false,visibility:"hidden"},_menu:{type:"sap.ui.unified.Menu",multiple:false,visibility:"hidden"}},events:{itemSelected:{parameters:{item:{type:"sap.m.MenuItem"}}},closed:{}}}});
E.call(b.prototype);b.UNIFIED_MENU_ITEMS_ID_SUFFIX='-unifiedmenu';b.UNFIFIED_MENU_ITEMS_PROPS=sap.ui.unified.MenuItem.getMetadata().getAllProperties();b.LIST_ITEMS_ID_SUFFIX='-menuinnerlist';b.MENU_LIST_ITEMS_PROPS=M.getMetadata().getAllProperties();
b.prototype.init=function(){if(a.system.phone){this._initDialog();}this._bIsInitialized=false;};
b.prototype.exit=function(){if(this._navContainerId){this._navContainerId=null;}if(this._bIsInitialized){this._bIsInitialized=null;}if(this._getMenu()&&this._getMenu().getPopup()){this._getMenu().getPopup().detachClosed(this._menuClosed,this);}};
b.prototype.invalidate=function(){};
b.prototype.setTitle=function(t){var n=this._getNavContainer();this.setProperty("title",t,true);if(n&&n.getPages().length){n.getPages()[0].setTitle(t);}return this;};
b.prototype.openBy=function(o,w){if(a.system.phone){this._openDialog();}else{if(!this._bIsInitialized){this._initAllMenuItems();this._bIsInitialized=true;}var e=sap.ui.core.Popup.Dock;this._getMenu().open(w,o,e.BeginTop,e.BeginBottom,o,"0 -2");}};
b.prototype.close=function(){if(sap.ui.Device.system.phone){this._getDialog().close();}else{this._getVisualParent().close();}};
b.prototype._initDialog=function(){var d=new D({showHeader:false,stretch:true,content:this._initNavContainer(),buttons:[this._initCloseButton()]});d.addStyleClass("sapMRespMenuDialog");this.setAggregation("_dialog",d,true);};
b.prototype._getDialog=function(){return this.getAggregation("_dialog");};
b.prototype._openDialog=function(){if(!this._bIsInitialized){this._initAllPages();this._bIsInitialized=true;}this._getNavContainer().to(this._getNavContainer().getPages()[0]);this._getDialog().open();};
b.prototype._initAllMenuItems=function(){this._initMenuForItems(this.getItems());};
b.prototype._initMenuForItems=function(i,p){var m=new U();m.isCozy=this._isMenuCozy.bind(this,m);this.addStyleClass('sapMMenu');m.aCustomStyleClasses=this.aCustomStyleClasses;m.mCustomStyleClassMap=this.mCustomStyleClassMap;i.forEach(function(I){this._addVisualMenuItemFromItem(I,m);}.bind(this));if(p){p.setSubmenu(m);}else{m.getPopup().attachClosed(this._menuClosed,this);this.setAggregation('_menu',m,true);}m.attachItemSelect(this._handleMenuItemSelect,this);};
b.prototype._menuClosed=function(){this.fireClosed();};
b.prototype._getMenu=function(){return this.getAggregation("_menu");};
b.prototype._initCloseButton=function(){var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");return new B({text:r.getText("MENU_CLOSE"),press:f.bind(this)});};
function f(){this._getDialog().close();}
b.prototype._initNavContainer=function(){var n=new N();this._navContainerId=n.getId();return n;};
b.prototype._getNavContainer=function(){return sap.ui.getCore().byId(this._navContainerId);};
b.prototype._initAllPages=function(){this._initPageForParent(this);};
b.prototype._initPageForParent=function(p){var i=p.getItems(),d=p instanceof sap.m.Menu,s=d?p.getTitle():p.getText(),o=new L({mode:sap.m.ListMode.None}),e=new P({title:s,showNavButton:!d,content:o});if(!d){this._setBackButtonTooltipForPageWithParent(p,e);}e.attachNavButtonPress(function(){this._getNavContainer().back();},this);this._getNavContainer().addPage(e);i.forEach(function(I){this._addListItemFromItem(I,e);},this);this._updateListInset(o);o.attachEvent("itemPress",this._handleListItemPress,this);return e;};
b.prototype._handleListItemPress=function(e){var o=e.getParameter("listItem"),m=sap.ui.getCore().byId(o.getMenuItem()),p=m._getVisualChild();if(p){this._getNavContainer().to(p);}else{this._getDialog().close();this.fireItemSelected({item:m});}m.firePress();};
b.prototype._setBackButtonTooltipForPageWithParent=function(p,o){var d=p.getParent(),r=sap.ui.getCore().getLibraryResourceBundle("sap.m"),s;s=d instanceof sap.m.Menu?d.getTitle():d.getText();s=r.getText("MENU_PAGE_BACK_BUTTON")+" "+s;o.setNavButtonTooltip(s);};
b.prototype._createMenuListItemFromItem=function(i){return new M({id:this._generateListItemId(i.getId()),type:sap.m.ListType.Active,icon:i.getIcon(),title:i.getText(),startsSection:i.getStartsSection(),menuItem:i,tooltip:i.getTooltip(),visible:i.getVisible()});};
b.prototype._createVisualMenuItemFromItem=function(i){return new sap.ui.unified.MenuItem({id:this._generateUnifiedMenuItemId(i.getId()),icon:i.getIcon(),text:i.getText(),startsSection:i.getStartsSection(),tooltip:i.getTooltip(),visible:i.getVisible(),enabled:i.getEnabled()});};
b.prototype._addVisualMenuItemFromItem=function(i,m,I){var o=this._createVisualMenuItemFromItem(i);i._setVisualParent(m);i._setVisualControl(o);var e=['aggregationChanged','propertyChanged'];e.forEach(function(s){var d='_on'+s.slice(0,1).toUpperCase()+s.slice(1);i.attachEvent(s,this[d],this);},this);if(i.getItems().length!==0){this._initMenuForItems(i.getItems(),o);i._setVisualChild(i.getItems()[0]._getVisualParent());}if(I===undefined){m.addItem(o);}else{m.insertItem(o,I);}};
b.prototype._addListItemFromItem=function(i,p,I){var m=this._createMenuListItemFromItem(i),o=p.getContent()[0];i._setVisualParent(p);i._setVisualControl(m);var e=['aggregationChanged','propertyChanged'];e.forEach(function(s){var d='_on'+s.slice(0,1).toUpperCase()+s.slice(1);i.attachEvent(s,this[d],this);},this);if(i.getItems().length!==0){this._initPageForParent(i);i._setVisualChild(i.getItems()[0]._getVisualParent());}if(I===undefined){o.addItem(m);}else{o.insertItem(m,I);}o.rerender();};
b.prototype._addVisualItemFromItem=function(i,o,I){if(!o){return;}if(a.system.phone){this._addListItemFromItem(i,o,I);var d=o.getContent()[0];this._updateListInset(d);}else{this._addVisualMenuItemFromItem(i,o,I);}};
b.prototype._updateListInset=function(o){var h=false,I="sapMListIcons",d=o.getItems();for(var i=0;i<d.length;i++){if(d[i].getIcon()){h=true;break;}}if(h){o.addStyleClass(I);}else{o.removeStyleClass(I);}};
b.prototype._handleMenuItemSelect=function(e){var u=e.getParameter("item"),m;if(!u){return;}m=this._findMenuItemByUnfdMenuItem(u);if(m&&!m.getItems().length){this.fireItemSelected({item:m});}if(m){m.firePress();}};
b.prototype._generateListItemId=function(m){return m+b.LIST_ITEMS_ID_SUFFIX;};
b.prototype._generateUnifiedMenuItemId=function(m){return m+b.UNIFIED_MENU_ITEMS_ID_SUFFIX;};
b.prototype._findMenuItemByUnfdMenuItem=function(u){var d=[],o=u,I,e,i;do{d.push(o.getId());o=o.getParent().getParent();}while(o instanceof sap.ui.unified.MenuItem);I=this.getItems();do{e=d.pop();for(i=0;i<I.length;i++){if(I[i]._getVisualControl()===e){if(d.length===0){return I[i];}else{I=I[i].getItems();break;}}}}while(d.length);return null;};
b.prototype._isMenuCozy=function(m){if(!m.bCozySupported){return false;}if(m.hasStyleClass("sapUiSizeCozy")){return true;}if(c(m.oOpenerRef)){return true;}return false;};
function c(r){if(!r){return false;}r=r.$?r.$():q(r);var $=r.closest(".sapUiSizeCompact,.sapUiSizeCondensed,.sapUiSizeCozy");return(!$.hasClass("sapUiSizeCompact")&&!$.hasClass("sapUiSizeCondensed"))||$.hasClass("sapUiSizeCozy");}
b.prototype.addAggregation=function(A,o,s){C.prototype.addAggregation.apply(this,arguments);if(A==="items"){this._addVisualItemFromItem(o,this._getVisualParent());}return this;};
b.prototype.insertAggregation=function(A,o,i,s){C.prototype.insertAggregation.apply(this,arguments);if(A==="items"){this._addVisualItemFromItem(o,this._getVisualParent(),i);}return this;};
b.prototype.removeAggregation=function(A,o,s){var i=C.prototype.removeAggregation.apply(this,arguments);if(A==="items"){this._removeVisualItem(i);}return i;};
b.prototype.removeAllAggregation=function(A,s){var I=C.prototype.removeAllAggregation.apply(this,arguments);if(A==="items"){for(var i=0;i<I.length;i++){this._removeVisualItem(I[i]);}}return I;};
b.prototype._removeVisualItem=function(i,p){var v=sap.ui.getCore().byId(i._getVisualControl()),m,o;if(v){m=v.getParent();m.removeItem(v);if(a.system.phone){this._removeSubPageForItem(i);if(m.getItems().length===0){o=sap.ui.getCore().byId(i._getVisualParent());this._getNavContainer().removePage(o);o.destroy();if(p){p._setVisualChild(null);sap.ui.getCore().byId(p._getVisualControl()).rerender();}}if(m){m.rerender();}}v.destroy();}};
b.prototype.destroyAggregation=function(A,s){if(A==="items"){for(var i=0;i<this.getItems().length;i++){this._removeVisualItem(this.getItems()[i]);}}return C.prototype.destroyAggregation.apply(this,arguments);};
b.prototype._removeSubPageForItem=function(I,s){var S;if(!s){for(var i=0;i<I.getItems().length;i++){this._removeSubPageForItem(I.getItems()[i]);}}if(I._getVisualChild()){S=sap.ui.getCore().byId(I._getVisualChild());if(this._getNavContainer()&&S){this._getNavContainer().removePage(S);}!!S&&S.destroy();}};
b.prototype._getVisualParent=function(){var n=this._getNavContainer(),m=this._getMenu();if(n&&n.getPages().length){return n.getPages()[0];}else{return m;}};
b.prototype._onPropertyChanged=function(e){var p=e.getParameter("propertyKey"),o=e.getParameter("propertyValue"),t=a.system.phone?b.MENU_LIST_ITEMS_PROPS:b.UNFIFIED_MENU_ITEMS_PROPS,g=a.system.phone?this._generateListItemId:this._generateUnifiedMenuItemId,T;if(a.system.phone&&p==='text'){p='title';}if(!t[p]){return;}T=g(e.getSource().getId());if(T){sap.ui.getCore().byId(T).setProperty(p,o);if(a.system.phone&&this._getDialog().isOpen()){this._getDialog().close();}}};
b.prototype._onAggregationChanged=function(e){var A=e.getParameter("aggregationName");switch(A){case'items':this._onItemsAggregationChanged(e);break;}};
b.prototype._onItemsAggregationChanged=function(e){var I=e.getSource(),m=e.getParameter("methodName"),d=e.getParameter("methodParams"),g;if(m==="add"||m==="insert"){if(m==="insert"){g=d.index;}this._addOrInsertItem(I,d.item,g);}if(m==="remove"){this._removeVisualItem(d.item,I);}if(m==="removeall"){for(var i=0;i<d.items.length;i++){this._removeVisualItem(d.items[i],I);}}if(m==="destroy"){this._destroyItem(I);}};
b.prototype._addOrInsertItem=function(p,n,i){var o;if(p._getVisualChild()){this._addVisualItemFromItem(n,sap.ui.getCore().byId(p._getVisualChild()),i);}else{if(a.system.phone){this._initPageForParent(p);p._setVisualChild(p.getItems()[0]._getVisualParent());o=sap.ui.getCore().byId(p._getVisualControl());o.rerender();}else{this._initMenuForItems(p.getItems(),sap.ui.getCore().byId(p._getVisualControl()));p._setVisualChild(p.getItems()[0]._getVisualParent());}}};
b.prototype._destroyItem=function(i){var v=sap.ui.getCore().byId(i._getVisualControl());if(v&&v.setMenuItem){v.setMenuItem(null);}this._removeSubPageForItem(i,true);i._setVisualChild(null);if(v&&v.setMenuItem){v.rerender();v.setMenuItem(i);}};
b.prototype.getDomRefId=function(){if(a.system.phone){return this._getDialog().getId();}else{return this._getMenu().getId();}};
b.prototype.openAsContextMenu=function(e,o){if(a.system.phone){this._openDialog();}else{if(!this._bIsInitialized){this._initAllMenuItems();this._bIsInitialized=true;}this._getMenu().openAsContextMenu(e,o);}};
["addStyleClass","removeStyleClass","toggleStyleClass"].forEach(function(m){b.prototype[m]=function(s,S){var d=this._getDialog();C.prototype[m].apply(this,arguments);if(d){d[m].apply(d,arguments);}return this;};});return b;},true);
sap.ui.predefine('sap/m/MenuButton.designtime',[],function(){"use strict";return{aggregations:{menu:{ignore:true}},actions:{split:{changeType:"splitMenuButton",changeOnRelevantContainer:true,getControlsCount:function(m){return m.getMenu().getItems().length;}},rename:{changeType:"rename",domRef:function(c){return c.$().find('.sapMBtn > .sapMBtnInner > .sapMBtnContent')[0];}}}};},false);
sap.ui.predefine('sap/m/MenuButton',['jquery.sap.global','./library','sap/ui/core/Control','./Button','./SplitButton','./Dialog','sap/ui/Device','sap/ui/core/EnabledPropagator'],function(q,l,C,B,S,D,a,E){"use strict";
var M=C.extend("sap.m.MenuButton",{metadata:{library:"sap.m",properties:{text:{type:"string",group:"Misc",defaultValue:null},type:{type:"sap.m.ButtonType",group:"Appearance",defaultValue:sap.m.ButtonType.Default},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},activeIcon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconDensityAware:{type:"boolean",group:"Misc",defaultValue:true},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit},buttonMode:{type:"sap.m.MenuButtonMode",group:"Misc",defaultValue:sap.m.MenuButtonMode.Regular},useDefaultActionOnly:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{menu:{type:"sap.m.Menu",multiple:false,singularName:"menu"},_button:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{defaultAction:{}},defaultAggregation:"menu",designTime:true}});
E.call(M.prototype);
M.prototype.init=function(){this._initButtonControl();};
M.prototype.exit=function(){if(this._sDefaultText){this._sDefaultText=null;}if(this._sDefaultIcon){this._sDefaultIcon=null;}if(this._iInitialWidth){this._iInitialWidth=null;}if(this._lastActionItemId){this._lastActionItemId=null;}if(this.getMenu()){this.getMenu().detachClosed(this._menuClosed,this);}};
M.prototype.onBeforeRendering=function(){if(!this._sDefaultText){this._sDefaultText=this.getText();}if(!this._sDefaultIcon){this._sDefaultIcon=this.getIcon();}this._updateButtonControl();this._attachMenuEvents();};
M.prototype.onAfterRendering=function(){q.sap.delayedCall(0,this,"_setInitialBtnWidth");this._setAriaHasPopup();};
M.prototype._setInitialBtnWidth=function(){var i;if(this._isSplitButton()&&!this._iInitialWidth){i=this.$().outerWidth();if(i){this._iInitialWidth=i+1;}}};
M.prototype._setAriaHasPopup=function(){if(this._isSplitButton()){this._getButtonControl()._getArrowButton().$().attr("aria-haspopup","true");}else{this._getButtonControl().$().attr("aria-haspopup","true");}};
M.prototype.setButtonMode=function(m){var t=this.getTooltip();C.prototype.setProperty.call(this,"buttonMode",m,true);this._getButtonControl().destroy();this._initButtonControl();for(var k in this.mProperties){if(this.mProperties.hasOwnProperty(k)&&k!=="buttonMode"&&k!=="useDefaultActionOnly"&&k!=="width"){this._getButtonControl().setProperty(k,this.mProperties[k],true);}}if(t){this._getButtonControl().setTooltip(t);}if(!this._isSplitButton()&&this._sDefaultText){this.setText(this._sDefaultText);}else if(!this.getUseDefaultActionOnly()&&this._getLastSelectedItem()){this.setText(sap.ui.getCore().byId(this._getLastSelectedItem()).getText());}if(!this._isSplitButton()&&this._sDefaultIcon){this.setIcon(this._sDefaultIcon);}else if(!this.getUseDefaultActionOnly()&&this._getLastSelectedItem()){this.setIcon(sap.ui.getCore().byId(this._getLastSelectedItem()).getIcon());}this.invalidate();return this;};
M.prototype._initButton=function(){var b=new B({width:"100%"});b.attachPress(this._handleButtonPress,this);return b;};
M.prototype._initSplitButton=function(){var b=new S({width:"100%"});b.attachPress(this._handleActionPress,this);b.attachArrowPress(this._handleButtonPress,this);return b;};
M.prototype._initButtonControl=function(){var b;if(this._isSplitButton()){b=this._initSplitButton();}else{b=this._initButton();}this.setAggregation("_button",b,true);};
M.prototype._updateButtonControl=function(){this._getButtonControl().setText(this.getText());};
M.prototype._getButtonControl=function(){return this.getAggregation("_button");};
M.prototype._handleButtonPress=function(w){var m=this.getMenu();if(!m){return;}if(!m.getTitle()){m.setTitle(this.getText());}m.openBy(this,w);this._writeAriaAttributes();if(this._isSplitButton()&&!a.system.phone){this._getButtonControl().setArrowState(true);}};
M.prototype._handleActionPress=function(){var L=this._getLastSelectedItem(),o;if(!this.getUseDefaultActionOnly()&&L){o=sap.ui.getCore().byId(L);this.getMenu().fireItemSelected({item:o});}else{this.fireDefaultAction();}};
M.prototype._menuClosed=function(){if(this._isSplitButton()){this._getButtonControl().setArrowState(false);}};
M.prototype._menuItemSelected=function(e){var m=e.getParameter("item");this.fireEvent("_menuItemSelected",{item:m});if(!this._isSplitButton()||this.getUseDefaultActionOnly()||!m){return;}this._lastActionItemId=m.getId();!!this._sDefaultText&&this.setText(m.getText());!!this._sDefaultIcon&&this.setIcon(m.getIcon());};
M.prototype._getLastSelectedItem=function(){return this._lastActionItemId;};
M.prototype._attachMenuEvents=function(){if(this.getMenu()){this.getMenu().attachClosed(this._menuClosed,this);this.getMenu().attachItemSelected(this._menuItemSelected,this);}};
M.prototype._isSplitButton=function(){return this.getButtonMode()===sap.m.MenuButtonMode.Split;};
M.prototype.setProperty=function(p,v,s){function i(t){var T=[sap.m.ButtonType.Up,sap.m.ButtonType.Back,sap.m.ButtonType.Unstyled];return T.indexOf(t)!==-1;}if(p==="type"&&i(v)){return this;}if(p==='text'){this._sDefaultText=v;}switch(p){case'activeIcon':case'iconDensityAware':case'textDirection':this._getButtonControl().setProperty(p,v);break;}return C.prototype.setProperty.apply(this,arguments);};
M.prototype.setTooltip=function(t){this._getButtonControl().setTooltip(t);return C.prototype.setTooltip.apply(this,arguments);};
M.prototype.setText=function(v){B.prototype.setProperty.call(this,'text',v);this._getButtonControl().setText(v);return this;};
M.prototype.setType=function(v){B.prototype.setProperty.call(this,'type',v);this._getButtonControl().setType(v);return this;};
M.prototype.setIcon=function(v){B.prototype.setProperty.call(this,'icon',v);this._getButtonControl().setIcon(v);return this;};
M.prototype.getFocusDomRef=function(){return this._getButtonControl().getDomRef();};
M.prototype.onsapup=function(e){this.openMenuByKeyboard();};
M.prototype.onsapdown=function(e){this.openMenuByKeyboard();};
M.prototype.onsapupmodifiers=function(e){this.openMenuByKeyboard();};
M.prototype.onsapdownmodifiers=function(e){this.openMenuByKeyboard();};
M.prototype.onsapshow=function(e){this.openMenuByKeyboard();!!e&&e.preventDefault();};
M.prototype.openMenuByKeyboard=function(){if(!this._isSplitButton()){this._handleButtonPress(true);}};
M.prototype._writeAriaAttributes=function(){if(this.getMenu()){this.$().attr("aria-controls",this.getMenu().getDomRefId());}};
return M;},true);
sap.ui.predefine('sap/m/MenuButtonRenderer',['jquery.sap.global'],function(q){"use strict";var M={};M.CSS_CLASS="sapMMenuBtn";
M.render=function(r,m){var w=m.getWidth();r.write("<div");r.writeControlData(m);this.writeAriaAttributes(r,m);r.addClass(M.CSS_CLASS);r.addClass(M.CSS_CLASS+m.getButtonMode());r.writeClasses();if(w!=""||w.toLowerCase()==="auto"){r.addStyle("width",w);}else if(m._isSplitButton()&&m._iInitialWidth){r.addStyle("width",m._iInitialWidth+"px");}r.writeStyles();r.write(">");r.renderControl(m._getButtonControl());r.write("</div>");};
M.writeAriaAttributes=function(r,m){r.writeAttribute("aria-haspopup","true");};
return M;},true);
sap.ui.predefine('sap/m/MenuItem',['jquery.sap.global','./library','sap/ui/core/Item'],function(q,l,I){"use strict";
var M=I.extend("sap.m.MenuItem",{metadata:{library:"sap.m",properties:{icon:{type:"string",group:"Appearance",defaultValue:null},visible:{type:"boolean",group:"Appearance",defaultValue:true},startsSection:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.MenuItem",multiple:true,singularName:"item",bindable:"bindable"}},events:{press:{},propertyChanged:{parameters:{propertyKey:{type:"string"},propertyValue:{type:"any"}}},aggregationChanged:{parameters:{aggregationName:{type:"String"},methodName:{type:"String"},methodParams:{type:"Object"}}}}}});
M.prototype.exit=function(){if(this._sVisualChild){this._sVisualChild=null;}if(this._sVisualParent){this._sVisualParent=null;}if(this._sVisualControl){this._sVisualControl=null;}};
M.prototype.setProperty=function(p,P){I.prototype.setProperty.apply(this,arguments);this.fireEvent("propertyChanged",{propertyKey:p,propertyValue:P});};
M.prototype.addAggregation=function(a,o,s){I.prototype.addAggregation.apply(this,arguments);this.fireEvent("aggregationChanged",{aggregationName:a,methodName:"add",methodParams:{item:o}});return this;};
M.prototype.insertAggregation=function(a,o,i,s){I.prototype.insertAggregation.apply(this,arguments);this.fireEvent("aggregationChanged",{aggregationName:a,methodName:"insert",methodParams:{item:o,index:i}});return this;};
M.prototype.removeAggregation=function(a,o,s){var O=I.prototype.removeAggregation.apply(this,arguments);this.fireEvent("aggregationChanged",{aggregationName:a,methodName:"remove",methodParams:{item:O}});return O;};
M.prototype.removeAllAggregation=function(a,s){var o=I.prototype.removeAllAggregation.apply(this,arguments);this.fireEvent("aggregationChanged",{aggregationName:a,methodName:"removeall",methodParams:{items:o}});return o;};
M.prototype.destroyAggregation=function(a,s){this.fireEvent("aggregationChanged",{aggregationName:a,methodName:"destroy"});return I.prototype.destroyAggregation.apply(this,arguments);};
M.prototype._setVisualChild=function(c){this._setInternalRef(c,"_sVisualChild");};
M.prototype._setVisualParent=function(c){this._setInternalRef(c,"_sVisualParent");};
M.prototype._setVisualControl=function(c){this._setInternalRef(c,"_sVisualControl");};
M.prototype._setInternalRef=function(c,i){if(!c||typeof c==="string"){this[i]=c;}else if(c.getId){this[i]=c.getId();}};
M.prototype._getVisualChild=function(){return this._sVisualChild;};
M.prototype._getVisualParent=function(){return this._sVisualParent;};
M.prototype._getVisualControl=function(){return this._sVisualControl;};
return M;},true);
sap.ui.predefine('sap/m/MenuListItem',['jquery.sap.global','./ListItemBase','./library','sap/ui/core/EnabledPropagator','sap/ui/core/IconPool'],function(q,L,l,E,I){"use strict";
var M=L.extend("sap.m.MenuListItem",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Misc",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconDensityAware:{type:"boolean",group:"Misc",defaultValue:true},titleTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit},startsSection:{type:"boolean",group:"Behavior",defaultValue:false}},associations:{menuItem:{type:"sap.m.MenuItem",multiple:false}}}});
M.prototype.exit=function(){if(this._image){this._image.destroy();}if(this._imageRightArrow){this._imageRightArrow.destroy();}L.prototype.exit.apply(this,arguments);};
M.prototype._getImage=function(i,s,S,b){var o=this._image;if(o){o.setSrc(S);if(o instanceof sap.m.Image){o.setDensityAware(b);}}else{o=I.createControlByURI({id:i,src:S,densityAware:b,useIconTooltip:false},sap.m.Image).setParent(this,null,true);}if(o instanceof sap.m.Image){o.addStyleClass(s,true);}else{o.addStyleClass(s+"Icon",true);}this._image=o;return this._image;};
M.prototype._getIconArrowRight=function(){if(!this._imageRightArrow){this._imageRightArrow=I.createControlByURI({id:this.getId()+"-arrowRight",src:"sap-icon://slim-arrow-right",useIconTooltip:false},sap.m.Image).setParent(this,null,true);this._imageRightArrow.addStyleClass("sapMMenuLIArrowRightIcon",true);}return this._imageRightArrow;};
M.prototype._hasSubItems=function(){return!!(this.getMenuItem()&&sap.ui.getCore().byId(this.getMenuItem()).getItems().length);};
return M;},false);
sap.ui.predefine('sap/m/MenuListItemRenderer',['jquery.sap.global','./ListItemBaseRenderer','sap/ui/core/Renderer'],function(q,L,R){"use strict";var M=R.extend(L);
M.openItemTag=function(r,l){if(l.getStartsSection()){r.write("<li ");r.write("role=\"separator\" ");r.write("class=\"sapUiMnuDiv\"><div class=\"sapUiMnuDivL\"></div><hr><div class=\"sapUiMnuDivR\"></div></li>");}L.openItemTag(r,l);};
M.renderLIAttributes=function(r,l){r.addClass("sapMSLI");if(l.getIcon()){r.addClass("sapMSLIIcon");}if(l.getType()==sap.m.ListType.Detail||l.getType()==sap.m.ListType.DetailAndActive){r.addClass("sapMSLIDetail");}if(l._hasSubItems()){r.addClass("sapMMenuLIHasChildren");}};
M.renderLIContent=function(r,l){var t=l.getTitleTextDirection();if(l.getIcon()){r.renderControl(l._getImage((l.getId()+"-img"),"sapMMenuLIImgThumb",l.getIcon(),l.getIconDensityAware()));}r.write("<div");r.addClass("sapMSLIDiv");r.addClass("sapMSLITitleDiv");r.writeClasses();r.write(">");if(l._bNoFlex){r.write('<div class="sapMLIBNoFlex">');}r.write("<div");r.addClass("sapMSLITitleOnly");r.writeClasses();if(t!==sap.ui.core.TextDirection.Inherit){r.writeAttribute("dir",t.toLowerCase());}r.write(">");r.writeEscaped(l.getTitle());r.write("</div>");if(l._bNoFlex){r.write('</div>');}r.write("</div>");if(l._hasSubItems()){r.renderControl(l._getIconArrowRight());}};
return M;},true);
sap.ui.predefine('sap/m/MessageBox',['jquery.sap.global','./Button','./Dialog','./Text','./FormattedText','./Link','./VBox','sap/ui/core/IconPool'],function(q,B,D,T,F,L,V,I){"use strict";var M={};M.Action={OK:"OK",CANCEL:"CANCEL",YES:"YES",NO:"NO",ABORT:"ABORT",RETRY:"RETRY",IGNORE:"IGNORE",CLOSE:"CLOSE",DELETE:"DELETE"};M.Icon={NONE:undefined,INFORMATION:"INFORMATION",WARNING:"WARNING",ERROR:"ERROR",SUCCESS:"SUCCESS",QUESTION:"QUESTION"};(function(){var A=M.Action,a=M.Icon,c={"INFORMATION":"sapMMessageBoxInfo","WARNING":"sapMMessageBoxWarning","ERROR":"sapMMessageBoxError","SUCCESS":"sapMMessageBoxSuccess","QUESTION":"sapMMessageBoxQuestion","STANDARD":"sapMMessageBoxStandard"},m={"INFORMATION":I.getIconURI("message-information"),"WARNING":I.getIconURI("message-warning"),"ERROR":I.getIconURI("message-error"),"SUCCESS":I.getIconURI("message-success"),"QUESTION":I.getIconURI("question-mark")};var _=function(){if(M._rb!==sap.ui.getCore().getLibraryResourceBundle("sap.m")){M._rb=sap.ui.getCore().getLibraryResourceBundle("sap.m");}};
M.show=function(v,o){var d,b,e,r=null,t=this,f=[],i,s,g,h,C,j,k,l={id:sap.ui.core.ElementMetadata.uid("mbox"),initialFocus:null,textDirection:sap.ui.core.TextDirection.Inherit,verticalScrolling:true,horizontalScrolling:true,details:"",contentWidth:null};_();if(typeof o==="string"||arguments.length>2){s=arguments[1];g=arguments[2];h=arguments[3];C=arguments[4];j=arguments[5];k=arguments[6];o={icon:s,title:g,actions:h,onClose:C,id:j,styleClass:k};}if(o&&o.hasOwnProperty("details")){l.icon=sap.m.MessageBox.Icon.INFORMATION;l.actions=[A.OK,A.CANCEL];o=q.extend({},l,o);}o=q.extend({},l,o);if(typeof o.actions!=="undefined"&&!q.isArray(o.actions)){o.actions=[o.actions];}if(!o.actions||o.actions.length===0){o.actions=[A.OK];}function n(y){var z;if(M.Action.hasOwnProperty(y)){z=t._rb.getText("MSGBOX_"+y);}var E=new B({id:sap.ui.core.ElementMetadata.uid("mbox-btn-"),text:z||y,press:function(){r=y;d.close();}});return E;}for(i=0;i<o.actions.length;i++){f.push(n(o.actions[i]));}function p(o,b){if(typeof o.details=='object'){o.details="<pre>"+JSON.stringify(o.details,null,'\t').replace(/{/gi,"\\{")+"</pre>";}var y=new F().setVisible(false).setHtmlText(o.details);var S=new L({text:t._rb.getText("MSGBOX_LINK_TITLE"),press:function(){y.setVisible(true);this.setVisible(false);d._setInitialFocus();}});S.addStyleClass("sapMMessageBoxLinkText");y.addStyleClass("sapMMessageBoxDetails");return new V({items:[b,S,y]});}function u(){if(typeof o.onClose==="function"){o.onClose(r);}d.detachAfterClose(u);d.destroy();}function w(){var i=0;var y=null;if(o.initialFocus){if(o.initialFocus instanceof sap.ui.core.Control){y=o.initialFocus;}if(typeof o.initialFocus==="string"){for(i=0;i<f.length;i++){if(M.Action.hasOwnProperty(o.initialFocus)){if(t._rb.getText("MSGBOX_"+o.initialFocus).toLowerCase()===f[i].getText().toLowerCase()){y=f[i];break;}}else{if(o.initialFocus.toLowerCase()===f[i].getText().toLowerCase()){y=f[i];break;}}}}}return y;}if(typeof(v)==="string"){e=new T({textDirection:o.textDirection}).setText(v).addStyleClass("sapMMsgBoxText");b=e;}else if(v instanceof sap.ui.core.Control){e=v.addStyleClass("sapMMsgBoxText");}if(o&&o.hasOwnProperty("details")&&o.details!==""){e=p(o,e);}function x(){if(sap.ui.getCore().getConfiguration().getAccessibility()){d.$().attr("role","alertdialog");}}d=new D({id:o.id,type:sap.m.DialogType.Message,title:o.title,content:e,icon:m[o.icon],initialFocus:w(),verticalScrolling:o.verticalScrolling,horizontalScrolling:o.horizontalScrolling,afterOpen:x,afterClose:u,buttons:f,ariaLabelledBy:b?b.getId():undefined,contentWidth:o.contentWidth});if(c[o.icon]){d.addStyleClass(c[o.icon]);}else{d.addStyleClass(c.STANDARD);}if(o.styleClass){d.addStyleClass(o.styleClass);}d.open();};
M.alert=function(v,o){_();var d={icon:a.NONE,title:this._rb.getText("MSGBOX_TITLE_ALERT"),actions:A.OK,id:sap.ui.core.ElementMetadata.uid("alert"),initialFocus:null},C,t,s,S;if(typeof o==="function"||arguments.length>2){C=arguments[1];t=arguments[2];s=arguments[3];S=arguments[4];o={onClose:C,title:t,id:s,styleClass:S};}o=q.extend({},d,o);return M.show(v,o);};
M.confirm=function(v,o){_();var d={icon:a.QUESTION,title:this._rb.getText("MSGBOX_TITLE_CONFIRM"),actions:[A.OK,A.CANCEL],id:sap.ui.core.ElementMetadata.uid("confirm"),initialFocus:null},C,t,s,S;if(typeof o==="function"||arguments.length>2){C=arguments[1];t=arguments[2];s=arguments[3];S=arguments[4];o={onClose:C,title:t,id:s,styleClass:S};}o=q.extend({},d,o);return M.show(v,o);};
M.error=function(v,o){_();var d={icon:a.ERROR,title:this._rb.getText("MSGBOX_TITLE_ERROR"),actions:[A.CLOSE],id:sap.ui.core.ElementMetadata.uid("error"),initialFocus:null};o=q.extend({},d,o);return M.show(v,o);};
M.information=function(v,o){_();var d={icon:a.INFORMATION,title:this._rb.getText("MSGBOX_TITLE_INFO"),actions:[A.OK],id:sap.ui.core.ElementMetadata.uid("info"),initialFocus:null};o=q.extend({},d,o);return M.show(v,o);};
M.warning=function(v,o){_();var d={icon:a.WARNING,title:this._rb.getText("MSGBOX_TITLE_WARNING"),actions:[A.OK],id:sap.ui.core.ElementMetadata.uid("warning"),initialFocus:null};o=q.extend({},d,o);return M.show(v,o);};
M.success=function(v,o){_();var d={icon:a.SUCCESS,title:this._rb.getText("MSGBOX_TITLE_SUCCESS"),actions:[A.OK],id:sap.ui.core.ElementMetadata.uid("success"),initialFocus:null};o=q.extend({},d,o);return M.show(v,o);};
}());return M;},true);
sap.ui.predefine('sap/m/MessageItem',["jquery.sap.global","./library","sap/ui/core/Item"],function(q,l,I){"use strict";
var M=I.extend("sap.m.MessageItem",{metadata:{library:"sap.m",properties:{type:{type:"sap.ui.core.MessageType",group:"Appearance",defaultValue:sap.ui.core.MessageType.Error},title:{type:"string",group:"Appearance",defaultValue:""},subtitle:{type:"string",group:"Misc",defaultValue:null},description:{type:"string",group:"Appearance",defaultValue:""},markupDescription:{type:"boolean",group:"Appearance",defaultValue:false},longtextUrl:{type:"sap.ui.core.URI",group:"Behavior",defaultValue:null},counter:{type:"int",group:"Misc",defaultValue:null},groupName:{type:"string",group:"Misc",defaultValue:""}},defaultAggregation:"link",aggregations:{link:{type:"sap.m.Link",multiple:false,singularName:"link"}}}});
M.prototype.setProperty=function(p,v,s){var P=this.getParent(),t=this.getType().toLowerCase(),a=["description","type","groupName"],u=function(n,i){if(i._oMessagePopoverItem.getId()===this.getId()&&i.getMetadata().getProperty(n)){i.setProperty(n,v);}};if(a.indexOf(p)===-1&&P&&("_bItemsChanged"in P)&&!P._bItemsChanged){P._oLists&&P._oLists.all&&P._oLists.all.getItems&&P._oLists.all.getItems().forEach(u.bind(this,p));P._oLists&&P._oLists[t]&&P._oLists[t].getItems&&P._oLists[t].getItems().forEach(u.bind(this,p));}if(typeof this._updatePropertiesFn==="function"){this._updatePropertiesFn();}return I.prototype.setProperty.apply(this,arguments);};
M.prototype._updateProperties=function(c){this._updatePropertiesFn=c;};
M.prototype.setDescription=function(d){if(typeof d==='undefined'){d='';}if(this.getMarkupDescription()){d=q.sap._sanitizeHTML(d);}this.setProperty("description",d,true);return this;};
M.prototype.setType=function(t){if(t===sap.ui.core.MessageType.None){t=sap.ui.core.MessageType.Information;q.sap.log.warning("The provided None type is handled and rendered as Information type");}return this.setProperty("type",t,true);};
return M;},true);
sap.ui.predefine('sap/m/MessagePage',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/IconPool'],function(q,l,C,I){"use strict";
var M=C.extend("sap.m.MessagePage",{metadata:{library:"sap.m",properties:{text:{type:"string",group:"Misc",defaultValue:"No matching items found."},description:{type:"string",group:"Misc",defaultValue:"Check the filter settings."},title:{type:"string",group:"Misc",defaultValue:null},showHeader:{type:"boolean",group:"Appearance",defaultValue:true},showNavButton:{type:"boolean",group:"Appearance",defaultValue:false},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:"sap-icon://documents"},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit}},aggregations:{customText:{type:"sap.m.Link",multiple:false},customDescription:{type:"sap.m.Link",multiple:false},_page:{type:"sap.m.Page",multiple:false,visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{navButtonPress:{}}}});
M.prototype.init=function(){var b=sap.ui.getCore().getLibraryResourceBundle("sap.m");this.setAggregation("_page",new sap.m.Page({id:this.getId()+"-page",showHeader:this.getShowHeader(),navButtonPress:q.proxy(function(){this.fireNavButtonPress();},this)}));this.setProperty("text",b.getText("MESSAGE_PAGE_TEXT"),true);this.setProperty("description",b.getText("MESSAGE_PAGE_DESCRIPTION"),true);};
M.prototype.onBeforeRendering=function(){if(!(this._oText&&this._oDescription)){this._addPageContent();}};
M.prototype.exit=function(){var p=this.getAggregation("_page");if(p){p.destroy();p=null;}if(this._oText){this._oText=null;}if(this._oDescription){this._oDescription=null;}if(this._oIconControl){this._oIconControl=null;}};
M.prototype.setTitle=function(t){this.setProperty("title",t,true);this.getAggregation("_page").setTitle(t);return this;};
M.prototype.setText=function(t){this.setProperty("text",t,true);this._oText&&this._oText.setText(t);return this;};
M.prototype.setDescription=function(d){this.setProperty("description",d,true);this._oDescription&&this._oDescription.setText(d);return this;};
M.prototype.setShowHeader=function(s){this.setProperty("showHeader",s,true);this.getAggregation("_page").setShowHeader(s);return this;};
M.prototype.setShowNavButton=function(s){this.setProperty("showNavButton",s,true);this.getAggregation("_page").setShowNavButton(s);return this;};
M.prototype.setTextDirection=function(t){this.setProperty("textDirection",t,true);this._oText&&this._oText.setTextDirection(t);this._oDescription&&this._oDescription.setTextDirection(t);return this;};
M.prototype.setIcon=function(i){var o=this.getIcon();this.setProperty("icon",i,true);if(this._oIconControl){if(o!==i&&I.isIconURI(o)!=I.isIconURI(i)){var p=this.getAggregation("_page");p.removeContent(this._oIconControl);this._oIconControl.destroy();p.insertContent(this._getIconControl(),0);}else{this._oIconControl.setSrc(i);}}return this;};
M.prototype._addPageContent=function(){var p=this.getAggregation("_page");if(this.getAggregation("customText")){this._oText=this.getAggregation("customText");}else{this._oText=new sap.m.Text({id:this.getId()+"-customText",text:this.getText(),textAlign:sap.ui.core.TextAlign.Center,textDirection:this.getTextDirection()});}if(this.getAggregation("customDescription")){this._oDescription=this.getAggregation("customDescription");}else{this._oDescription=new sap.m.Text({id:this.getId()+"-customDescription",text:this.getDescription(),textAlign:sap.ui.core.TextAlign.Center,textDirection:this.getTextDirection()});}p.addContent(this._getIconControl());p.addContent(this._oText.addStyleClass("sapMMessagePageMainText"));p.addContent(this._oDescription.addStyleClass("sapMMessagePageDescription"));};
M.prototype._getIconControl=function(){this._oIconControl=I.createControlByURI({id:this.getId()+"-pageIcon",src:this.getIcon(),height:"8rem",useIconTooltip:true,decorative:false},sap.m.Image).addStyleClass("sapMMessagePageIcon");return this._oIconControl;};
M.prototype._getAnyHeader=function(){return this._getInternalHeader();};
M.prototype._getInternalHeader=function(){return this.getAggregation("_page").getAggregation("_internalHeader");};
return M;},true);
sap.ui.predefine('sap/m/MessagePageRenderer',['jquery.sap.global'],function(q){"use strict";var M={};
M.render=function(r,m){r.write("<div");r.writeControlData(m);r.addClass("sapMMessagePage");r.writeClasses();r.write(">");r.renderControl(m.getAggregation("_page"));r.write("</div>");};
return M;},true);
sap.ui.predefine('sap/m/MessagePopover',["jquery.sap.global","./ResponsivePopover","./Button","./Toolbar","./ToolbarSpacer","./Bar","./List","./StandardListItem","sap/ui/core/Control","sap/ui/core/IconPool","sap/ui/core/HTML","./Text","sap/ui/core/Icon","./SegmentedButton","./Page","./NavContainer","./semantic/SemanticPage","./Link","./Popover","./MessagePopoverItem","./MessageView"],function(q,R,B,T,a,b,L,S,C,I,H,c,d,e,P,N,f,g,h,M,i){"use strict";
var j=C.extend("sap.m.MessagePopover",{metadata:{library:"sap.m",properties:{asyncDescriptionHandler:{type:"any",group:"Behavior",defaultValue:null},asyncURLHandler:{type:"any",group:"Behavior",defaultValue:null},placement:{type:"sap.m.VerticalPlacementType",group:"Behavior",defaultValue:"Vertical"},initiallyExpanded:{type:"boolean",group:"Behavior",defaultValue:true}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.MessageItem",altTypes:["sap.m.MessagePopoverItem"],multiple:true,singularName:"item"},headerButton:{type:"sap.m.Button",multiple:false}},events:{afterOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},afterClose:{parameters:{openBy:{type:"sap.ui.core.Control"}}},beforeOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},beforeClose:{parameters:{openBy:{type:"sap.ui.core.Control"}}},itemSelect:{parameters:{item:{type:"sap.m.MessagePopoverItem"},messageTypeFilter:{type:"sap.ui.core.MessageType"}}},listSelect:{parameters:{messageTypeFilter:{type:"sap.ui.core.MessageType"}}},longtextLoaded:{},urlValidated:{}}}});
function k(s){return s.charAt(0).toUpperCase()+s.slice(1);}
var l="sapMMsgPopover",D="320px",m="440px",n={back:I.getIconURI("nav-back"),close:I.getIconURI("decline"),information:I.getIconURI("message-information"),warning:I.getIconURI("message-warning"),error:I.getIconURI("message-error"),success:I.getIconURI("message-success")},A=["asyncDescriptionHandler","asyncURLHandler"],o={asyncDescriptionHandler:function(p){var s=p.item.getLongtextUrl();if(s){q.ajax({type:"GET",url:s,success:function(r){p.item.setDescription(r);p.promise.resolve();},error:function(){var E="A request has failed for long text data. URL: "+s;q.sap.log.error(E);p.promise.reject(E);}});}}};
j.setDefaultHandlers=function(p){A.forEach(function(F){if(p.hasOwnProperty(F)){o[F]=p[F];}});};
j.prototype.init=function(){var t=this;var p;this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._oMessageView=this._initMessageView();this._insertCloseBtn(this._oMessageView._oListHeader);this._insertCloseBtn(this._oMessageView._oDetailsHeader);this._oMessageView._oSegmentedButton.attachEvent("select",this._onSegButtonSelect,this);this._oPopover=new R(this.getId()+"-messagePopover",{showHeader:false,contentWidth:m,contentHeight:D,placement:this.getPlacement(),showCloseButton:false,verticalScrolling:false,horizontalScrolling:false,modal:false,afterOpen:function(E){t.fireAfterOpen({openBy:E.getParameter("openBy")});},afterClose:function(E){t._oMessageView._navContainer.backToTop();t.fireAfterClose({openBy:E.getParameter("openBy")});},beforeOpen:function(E){t.fireBeforeOpen({openBy:E.getParameter("openBy")});},beforeClose:function(E){t.fireBeforeClose({openBy:E.getParameter("openBy")});}}).addStyleClass(l);this._oPopover.addContent(this._oMessageView);this._oPopover.addAssociation("ariaLabelledBy",this.getId()+"-messageView-HeadingDescr",true);p=this._oPopover.getAggregation("_popup");p.oPopup.setAutoClose(false);p.addEventDelegate({onBeforeRendering:this.onBeforeRenderingPopover,onAfterRendering:this.onAfterRenderingPopover},this);if(sap.ui.Device.system.phone){this._oPopover.setBeginButton(new B({text:this._oResourceBundle.getText("MESSAGEPOPOVER_CLOSE"),press:this.close.bind(this)}));}A.forEach(function(F){if(o.hasOwnProperty(F)){this['set'+k(F)](o[F]);}},this);};
j.prototype.onBeforeRendering=function(){if(this.getDependents().indexOf(this._oPopover)===-1){this.addDependent(this._oPopover);}};
j.prototype.onBeforeRenderingPopover=function(){if(this._bItemsChanged){var p=this.getItems();var t=this;this._oMessageView.destroyItems();p.forEach(function(r){r._updateProperties(function(){t._bItemsChanged=true;});this._oMessageView.addItem(r.clone("","",{cloneChildren:true,cloneBinding:true}));},this);this._bItemsChanged=false;}this._setInitialFocus();};
j.prototype.onAfterRenderingPopover=function(){if(this._oPopover._oControl._sFocusControlId){this._oPopover._oControl._sFocusControlId=null;}};
j.prototype.exit=function(){this._oResourceBundle=null;if(this._oMessageView){this._oMessageView.destroy();this._oMessageView=null;}if(this._oPopover){this._oPopover.destroy();this._oPopover=null;}};
j.prototype.openBy=function(p){var r=this._oPopover.getAggregation("_popup"),s=p.getParent();if(r instanceof h){if((s instanceof T||s instanceof b||s instanceof f)){r.setShowArrow(false);r.setResizable(true);}else{r.setShowArrow(true);}}if(this._oPopover){this._restoreExpansionDefaults();this._oPopover.openBy(p);}return this;};
j.prototype.close=function(){if(this._oPopover){this._oPopover.close();}return this;};
j.prototype.isOpen=function(){return this._oPopover.isOpen();};
j.prototype.toggle=function(p){if(this.isOpen()){this.close();}else{this.openBy(p);}return this;};
j.prototype.setPlacement=function(p){this.setProperty("placement",p,true);this._oPopover.setPlacement(p);return this;};
j.prototype.getDomRef=function(s){return this._oPopover&&this._oPopover.getAggregation("_popup").getDomRef(s);};
j.prototype._initMessageView=function(){var t=this,p;p=new i(this.getId()+"-messageView",{listSelect:function(E){t.fireListSelect({messageTypeFilter:E.getParameter('messageTypeFilter')});},itemSelect:function(E){t.fireItemSelect({messageTypeFilter:E.getParameter('messageTypeFilter'),item:E.getParameter('item')});},longtextLoaded:function(){t.fireLongtextLoaded();},urlValidated:function(){t.fireUrlValidated();}});return p;};
j.prototype._onSegButtonSelect=function(){if(this.isOpen()&&!this.getInitiallyExpanded()&&this._oPopover.hasStyleClass(l+"-init")){this._expandMsgPopover();}};
j.prototype._restoreExpansionDefaults=function(){if(!this.getInitiallyExpanded()){this._collapseMsgPopover();this._oMessageView._oSegmentedButton.setSelectedButton("none");}else{this._expandMsgPopover();}};
j.prototype._expandMsgPopover=function(){var s,p=D,s=this._oPopover.$("cont").css("height");if(this.getInitiallyExpanded()&&s!=="0px"){p=parseFloat(s)?s:p;}this._oPopover.setContentHeight(p).removeStyleClass(l+"-init");};
j.prototype._collapseMsgPopover=function(){this._oPopover.addStyleClass(l+"-init").setContentHeight("auto");};
j.prototype._insertCloseBtn=function(p){var s=this._oResourceBundle.getText("MESSAGEPOPOVER_CLOSE"),r=new B({icon:n["close"],visible:!sap.ui.Device.system.phone,tooltip:s,press:this.close.bind(this)}).addStyleClass(l+"CloseBtn");p.insertContent(r,3,true);};
j.prototype._setInitialFocus=function(){if(this._oMessageView._isListPage()&&this.getInitiallyExpanded()){this._oPopover.setInitialFocus(this._oMessageView._oLists[this._sCurrentList||'all']);}};
j.prototype._afterNavigate=function(){q.sap.delayedCall(0,this,"_restoreFocus");};
j.prototype._restoreFocus=function(){if(this._oMessageView._isListPage()){var r=this._oRestoreFocus&&this._oRestoreFocus.control(0);r&&r.focus();}else{this._oMessageView._oBackButton.focus();}};
j.prototype.setAsyncDescriptionHandler=function(p){this.setProperty('asyncDescriptionHandler',p,true);this._oMessageView.setProperty('asyncDescriptionHandler',p,true);return this;};
j.prototype.setAsyncURLHandler=function(p){this.setProperty('asyncURLHandler',p,true);this._oMessageView.setProperty('asyncURLHandler',p,true);return this;};
j.prototype.setHeaderButton=function(p){this._oMessageView.setHeaderButton(p);return this;};
j.prototype.getHeaderButton=function(){return this._oMessageView.getHeaderButton();};
j.prototype.setModel=function(p,s){this._oMessageView.setModel(p,s);return C.prototype.setModel.apply(this,arguments);};
["invalidate","addStyleClass","removeStyleClass","toggleStyleClass","hasStyleClass","getBusyIndicatorDelay","setBusyIndicatorDelay","getVisible","setVisible","getBusy","setBusy"].forEach(function(s){j.prototype[s]=function(){if(this._oPopover&&this._oPopover[s]){var p=this._oPopover;var r=p[s].apply(p,arguments);return r===p?this:r;}};});["setModel","bindAggregation","setAggregation","insertAggregation","addAggregation","removeAggregation","removeAllAggregation","destroyAggregation"].forEach(function(F){j.prototype["_"+F+"Old"]=j.prototype[F];j.prototype[F]=function(){var r=j.prototype["_"+F+"Old"].apply(this,arguments);this._bItemsChanged=true;if(this._oPopover){this._oPopover.invalidate();}if(["removeAggregation","removeAllAggregation"].indexOf(F)!==-1){return r;}return this;};});return j;},true);
sap.ui.predefine('sap/m/MessagePopoverItem',["jquery.sap.global","./library","./MessageItem"],function(q,l,M){"use strict";
var a=M.extend("sap.m.MessagePopoverItem",{});
return a;},true);
sap.ui.predefine('sap/m/MessagePopoverRenderer',["jquery.sap.global"],function(q){"use strict";var M={};
M.render=function(r,c){};
return M;},true);
sap.ui.predefine('sap/m/MessageStrip',["jquery.sap.global","./library","sap/ui/core/Control","./MessageStripUtilities","./Text","./Link","./FormattedText"],function(q,l,C,M,T,L,F){"use strict";
var a=C.extend("sap.m.MessageStrip",{metadata:{library:"sap.m",properties:{text:{type:"string",group:"Appearance",defaultValue:""},type:{type:"sap.ui.core.MessageType",group:"Appearance",defaultValue:sap.ui.core.MessageType.Information},customIcon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:""},showIcon:{type:"boolean",group:"Appearance",defaultValue:false},showCloseButton:{type:"boolean",group:"Appearance",defaultValue:false},enableFormattedText:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"link",aggregations:{link:{type:"sap.m.Link",multiple:false,singularName:"link"},_formattedText:{type:"sap.m.FormattedText",multiple:false,visibility:"hidden"},_text:{type:"sap.m.Text",multiple:false,visibility:"hidden"}},events:{close:{}}}});
a.prototype.init=function(){this.data("sap-ui-fastnavgroup","true",true);this.setAggregation("_text",new T());};
a.prototype.setText=function(t){var f=this.getAggregation("_formattedText");if(f){f.setHtmlText(t);}this.getAggregation("_text").setText(t);return this.setProperty("text",t);};
a.prototype.setType=function(t){if(t===sap.ui.core.MessageType.None){q.sap.log.warning(M.MESSAGES.TYPE_NOT_SUPPORTED);t=sap.ui.core.MessageType.Information;}return this.setProperty("type",t);};
a.prototype.setEnableFormattedText=function(e){var f=this.getAggregation("_formattedText");if(e){if(!f){f=new F();f._setUseLimitedRenderingRules(true);this.setAggregation("_formattedText",f);}f.setHtmlText(this.getText());}return this.setProperty("enableFormattedText",e);};
a.prototype.setAggregation=function(n,c,s){if(n==="link"&&c instanceof L){c.addAriaLabelledBy(this.getId());}C.prototype.setAggregation.call(this,n,c,s);return this;};
a.prototype.ontap=M.handleMSCloseButtonInteraction;a.prototype.onsapenter=M.handleMSCloseButtonInteraction;a.prototype.onsapspace=M.handleMSCloseButtonInteraction;
a.prototype.ontouchmove=function(e){e.setMarked();};
a.prototype.close=function(){var c=function(){this.fireClose();this.setVisible(false);}.bind(this);if(!sap.ui.getCore().getConfiguration().getAnimation()){c();return;}if(sap.ui.Device.browser.internet_explorer&&sap.ui.Device.browser.version<10){M.closeTransitionWithJavascript.call(this,c);}else{M.closeTransitionWithCSS.call(this,c);}};
return a;},true);
sap.ui.predefine('sap/m/MessageStripRenderer',["./MessageStripUtilities"],function(M){"use strict";var a={};
a.render=function(r,c){this.startMessageStrip(r,c);this.renderAriaTypeText(r,c);if(c.getShowIcon()){this.renderIcon(r,c);}this.renderTextAndLink(r,c);if(c.getShowCloseButton()){this.renderCloseButton(r);}this.endMessageStrip(r);};
a.startMessageStrip=function(r,c){r.write("<div");r.addClass(M.CLASSES.ROOT);r.addClass(M.CLASSES.ROOT+c.getType());r.writeControlData(c);r.writeClasses();r.writeAttribute(M.ATTRIBUTES.CLOSABLE,c.getShowCloseButton());r.writeAccessibilityState(c,M.getAccessibilityState.call(c));r.write(">");};
a.renderAriaTypeText=function(r,c){r.write("<span class='sapUiPseudoInvisibleText'>");r.write(M.getAriaTypeText.call(c));r.write("</span>");};
a.renderIcon=function(r,c){r.write("<div class='"+M.CLASSES.ICON+"'>");r.writeIcon(M.getIconURI.call(c),null,{"title":null});r.write("</div>");};
a.renderTextAndLink=function(r,c){var f=c.getAggregation("_formattedText");r.write("<div class='"+M.CLASSES.MESSAGE+"'>");if(c.getEnableFormattedText()&&f){r.renderControl(f);}else{r.renderControl(c.getAggregation("_text"));}r.renderControl(c.getLink());r.write("</div>");};
a.renderCloseButton=function(r){r.write("<button");r.writeAttribute("class",M.CLASSES.CLOSE_BUTTON);r.writeAttribute("title",M.RESOURCE_BUNDLE.getText("CLOSE"));r.write("></button>");};
a.endMessageStrip=function(r){r.write("</div>");};
return a;},true);
sap.ui.predefine('sap/m/MessageStripUtilities',function(){"use strict";var M={};M.MESSAGES={TYPE_NOT_SUPPORTED:"Value 'sap.ui.core.MessageType.None' for property 'type' is not supported."+"Defaulting to 'sap.ui.core.MessageType.Information'"};M.CLASSES={ROOT:"sapMMsgStrip",ICON:"sapMMsgStripIcon",MESSAGE:"sapMMsgStripMessage",CLOSE_BUTTON:"sapMMsgStripCloseButton",CLOSING_TRANSITION:"sapMMsgStripClosing"};M.ATTRIBUTES={CLOSABLE:"data-sap-ui-ms-closable"};M.RESOURCE_BUNDLE=sap.ui.getCore().getLibraryResourceBundle("sap.ui.core");
M.getIconURI=function(){var t=this.getType(),c=this.getCustomIcon(),i="sap-icon://message-"+t.toLowerCase();return c||i;};
M.getAriaTypeText=function(){var b="MESSAGE_STRIP_"+this.getType().toUpperCase(),a=M.RESOURCE_BUNDLE.getText(b);if(this.getShowCloseButton()){a+=" "+M.RESOURCE_BUNDLE.getText("MESSAGE_STRIP_CLOSABLE");}return a;};
M.handleMSCloseButtonInteraction=function(e){if(M.isMSCloseButtonPressed(e.target)){this.close();}};
M.isMSCloseButtonPressed=function(t){return t.className.indexOf(M.CLASSES.CLOSE_BUTTON)!==-1||t.parentNode.className.indexOf(M.CLASSES.CLOSE_BUTTON)!==-1;};
M.closeTransitionWithJavascript=function(c){this.$().animate({opacity:0},{duration:200,complete:c});};
M.closeTransitionWithCSS=function(c){this.$().addClass(M.CLASSES.CLOSING_TRANSITION).one("webkitTransitionEnd transitionend",c);};
M.getAccessibilityState=function(){return{role:"alert",live:"assertive",labelledby:this.getId()};};
return M;});
sap.ui.predefine('sap/m/MessageToast',['jquery.sap.global','./InstanceManager','sap/ui/core/Popup'],function(q,I,P){"use strict";var M={};var O="0 -64",C="sapMMessageToast",E="sapUiSelectable",B="sapContrast",a="sapContrastPlus";M._mSettings={duration:3000,width:"15em",my:"center bottom",at:"center bottom",of:document.defaultView,offset:"0 0",collision:"fit fit",onClose:null,animationTimingFunction:"ease",animationDuration:1000,autoClose:true,closeOnBrowserNavigation:true};M._aPopups=[];M._iOpenedPopups=0;M._bBoundedEvents=false;
M._validateSettings=function(s){this._isFiniteInteger(s.duration);this._validateWidth(s.width);this._validateDockPosition(s.my);this._validateDockPosition(s.at);this._validateOf(s.of);this._validateOffset(s.offset);this._validateCollision(s.collision);this._validateOnClose(s.onClose);this._validateAutoClose(s.autoClose);this._validateAnimationTimingFunction(s.animationTimingFunction);this._isFiniteInteger(s.animationDuration);};
M._isFiniteInteger=function(N){if(typeof N!=="number"||!isFinite(N)||!(Math.floor(N)===N)||N<=0){q.sap.log.error('"iNumber" needs to be a finite positive nonzero integer on '+this+"._isFiniteInteger");}};
M._validateWidth=function(w){if(!sap.ui.core.CSSSize.isValid(w)){q.sap.log.error(w+' is not of type '+'"sap.ui.core.CSSSize" for property "width" on '+this+"._validateWidth");}};
M._validateDockPosition=function(d){if(!sap.ui.core.Dock.isValid(d)){q.sap.log.error('"'+d+'"'+' is not of type '+'"sap.ui.core.Popup.Dock" on '+this+"._validateDockPosition");}};
M._validateOf=function(e){if(!(e instanceof q)&&!(e&&e.nodeType===1)&&!(e instanceof sap.ui.core.Control)&&e!==window){q.sap.log.error('"of" needs to be an instance of sap.ui.core.Control or an Element or a jQuery object or the window on '+this+"._validateOf");}};
M._validateOffset=function(o){if(typeof o!=="string"){q.sap.log.error(o+' is of type '+typeof o+', expected "string" for property "offset" on '+this+"._validateOffset");}};
M._validateCollision=function(s){var r=/^(fit|flip|none|flipfit|flipflip|flip flip|flip fit|fitflip|fitfit|fit fit|fit flip)$/i;if(!r.test(s)){q.sap.log.error('"collision" needs to be a single value “fit”, “flip”, or “none”, or a pair for horizontal and vertical e.g. "fit flip”, "fit none", "flipfit" on '+this+"._validateOffset");}};
M._validateOnClose=function(f){if(typeof f!=="function"&&f!==null){q.sap.log.error('"onClose" should be a function or null on '+this+"._validateOnClose");}};
M._validateAutoClose=function(b){if(typeof b!=="boolean"){q.sap.log.error('"autoClose" should be a boolean on '+this+"._validateAutoClose");}};
M._validateAnimationTimingFunction=function(t){var r=/^(ease|linear|ease-in|ease-out|ease-in-out)$/i;if(!r.test(t)){q.sap.log.error('"animationTimingFunction" should be a string, expected values: '+"ease, linear, ease-in, ease-out, ease-in-out on "+this+"._validateAnimationTimingFunction");}};
function h(o){for(var p=["my","at","of","offset"],i=0;i<p.length;i++){if(o[p[i]]!==undefined){return false;}}return true;}
function c(s){var m=document.createElement("div");m.className=C+" "+E+" "+B+" "+a;if(sap.ui.getCore().getConfiguration().getAccessibility()){m.setAttribute("role","alert");m.setAttribute("aria-label"," ");}m.style.width=s.width;m.appendChild(document.createTextNode(s.message));return m;}
function n(o){if(o){if(h(o)){o.offset=O;}if(o.of&&o.of.nodeType===9){o.of=document.defaultView;}}else{o={offset:O};}return o;}
M._handleResizeEvent=function(){if(sap.ui.Device.system.phone||sap.ui.Device.system.tablet){this._resetPosition(this._aPopups);}q.sap.delayedCall(0,this,"_applyPositions",[this._aPopups]);};
M._handleMouseDownEvent=function(e){var i=e.target.hasAttribute("class")&&e.target.getAttribute("class").indexOf(C)!==-1;if(i||e.isMarked("delayedMouseEvent")){return;}this._aPopups.forEach(function(p){p&&p.__bAutoClose&&p.close();});};
M._resetPosition=function(p){for(var i=0,m;i<p.length;i++){m=p[i]&&p[i].getContent();if(m){m.style.visibility="hidden";m.style.left=0;}}};
M._applyPositions=function(p){for(var i=0,o,m;i<p.length;i++){o=p[i];if(o){m=o._oPosition;if(sap.ui.Device.system.phone||sap.ui.Device.system.tablet){q.sap.delayedCall(0,this,"_applyPosition",[o,m]);}else{o.setPosition(m.my,m.at,m.of,m.offset);}}}};
M._applyPosition=function(p,m){var m=m||p._oPosition,o=p.getContent();p.setPosition(m.my,m.at,m.of,m.offset);o.style.visibility="visible";};
M._setCloseAnimation=function(m,d,f,s){var b="opacity "+s.animationTimingFunction+" "+s.animationDuration+"ms",t="webkitTransitionEnd."+C+" transitionend."+C;if(sap.ui.getCore().getConfiguration().getAnimation()&&s.animationDuration>0){m[0].style.webkitTransition=b;m[0].style.transition=b;m[0].style.opacity=0;m.on(t,function handleMTTransitionEnd(){m.off(t);f();});}else{f();}};
M.show=function(m,o){var t=this,s=q.extend({},this._mSettings,{message:m}),p=new P(),i,b,d="mousedown."+C+" touchstart."+C,e,f;o=n(o);q.extend(s,o);this._validateSettings(s);b=c(s);i=this._aPopups.push(p)-1;p.setContent(b);p.setPosition(s.my,s.at,s.of,s.offset,s.collision);if(q.support.cssTransitions){p.setAnimations(function fnMessageToastOpen($,D,k){k();},function fnMessageToastClose($,D,k){t._setCloseAnimation($,D,k,s);});}p.setShadow(false);p.__bAutoClose=s.autoClose;if(s.closeOnBrowserNavigation){I.addPopoverInstance(p);}if(!this._bBoundedEvents){q(window).on("resize."+C,this._handleResizeEvent.bind(this));q(document).on(d,this._handleMouseDownEvent.bind(this));this._bBoundedEvents=true;}p.open();this._iOpenedPopups++;function g(){I.removePopoverInstance(t._aPopups[i]);q(t._aPopups[i].getContent()).remove();t._aPopups[i].detachClosed(g);t._aPopups[i].destroy();t._aPopups[i]=null;t._iOpenedPopups--;if(t._iOpenedPopups===0){t._aPopups=[];q(window).off("resize."+C);q(document).off(d);t._bBoundedEvents=false;}if(typeof s.onClose==="function"){s.onClose.call(t);}}p.attachClosed(g);e=q.sap.delayedCall(s.duration,p,"close");function j(){q.sap.clearDelayedCall(e);e=null;function k(){f=q.sap.delayedCall(s.duration,p,"close");p.getContent().removeEventListener("mouseleave",k);}p.getContent().addEventListener("mouseleave",k);q.sap.clearDelayedCall(f);f=null;}p.getContent().addEventListener("touchstart",j);p.getContent().addEventListener("mouseover",j);if(sap.ui.Device.system.desktop){p.getContent().addEventListener("mouseleave",function(){e=q.sap.delayedCall(s.duration,p,"close");});}};
M.toString=function(){return"sap.m.MessageToast";};
return M;},true);
sap.ui.predefine('sap/m/MessageView',["jquery.sap.global","sap/ui/core/Control","sap/ui/core/IconPool","sap/ui/core/HTML","sap/ui/core/Icon","./Button","./Toolbar","./ToolbarSpacer","./Bar","./List","./StandardListItem","./library","./Text","./SegmentedButton","./Page","./NavContainer","./Link","./Popover","./MessageItem","./GroupHeaderListItem"],function(q,C,I,H,a,B,T,b,c,L,S,l,d,e,P,N,f,g,M,G){"use strict";var h=l.ListType;
var j=C.extend("sap.m.MessageView",{metadata:{library:"sap.m",properties:{asyncDescriptionHandler:{type:"any",group:"Behavior",defaultValue:null},asyncURLHandler:{type:"any",group:"Behavior",defaultValue:null},groupItems:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.MessageItem",multiple:true,singularName:"item"},headerButton:{type:"sap.m.Button",multiple:false}},events:{afterOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},itemSelect:{parameters:{item:{type:"sap.m.MessageItem"},messageTypeFilter:{type:"sap.ui.core.MessageType"}}},listSelect:{parameters:{messageTypeFilter:{type:"sap.ui.core.MessageType"}}},longtextLoaded:{},urlValidated:{}}}});
var k="sapMMsgView";var m={back:I.getIconURI("nav-back"),close:I.getIconURI("decline"),information:I.getIconURI("message-information"),warning:I.getIconURI("message-warning"),error:I.getIconURI("message-error"),success:I.getIconURI("message-success")};var n=["all","error","warning","success","information"];var A=["asyncDescriptionHandler","asyncURLHandler"];var D={asyncDescriptionHandler:function(i){var s=i.item.getLongtextUrl();if(s){q.ajax({type:"GET",url:s,success:function(o){i.item.setDescription(o);i.promise.resolve();},error:function(){var E="A request has failed for long text data. URL: "+s;q.sap.log.error(E);i.promise.reject(E);}});}}};
j.setDefaultHandlers=function(i){A.forEach(function(F){if(i.hasOwnProperty(F)){D[F]=i[F];}});};
j.prototype.init=function(){var t=this;this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._createNavigationPages();this._createLists();A.forEach(function(F){if(D.hasOwnProperty(F)){t.setProperty(F,D[F]);}});};
j.prototype.onBeforeRendering=function(){var o;this._clearLists();if(this.getGroupItems()){o=this._groupItems(this.getItems());this._fillGroupedLists(o);}else{this._fillLists(this.getItems());}this._clearSegmentedButton();this._fillSegmentedButton();this._fnFilterList(this._getCurrentMessageTypeFilter()||"all");var i=this.getHeaderButton();if(i){this._oListHeader.insertContent(i,2);}if(!this.getBindingInfo("items")&&!this.getItems().length){this._makeAutomaticBinding();}};
j.prototype._fillGroupedLists=function(o){var i=Object.keys(o),u=i.indexOf(""),U,p;if(u!==-1){U=o[""];p=Object.keys(U);p.forEach(function(t){var r=U[t];this._fillLists(r);delete o[""];i.splice(u,1);},this);}i.forEach(function(s){this._fillListsWithGroups(s,o[s]);},this);};
j.prototype._fillListsWithGroups=function(s,i){var t=Object.keys(i),o=new G({title:s}),p;this._oLists["all"].addAggregation("items",o,true);t.forEach(function(r){this._oLists[r.toLowerCase()].addAggregation("items",o.clone(),true);p=i[r];this._fillLists(p);},this);};
j.prototype.exit=function(){if(this._navContainer){this._navContainer.destroy();}if(this._oLists){this._destroyLists();}if(this._oMessageItemTemplate){this._oMessageItemTemplate.destroy();}this._oResourceBundle=null;this._oListHeader=null;this._oDetailsHeader=null;this._oSegmentedButton=null;this._oBackButton=null;this._navContainer=null;this._listPage=null;this._detailsPage=null;this._sCurrentList=null;};
j.prototype._makeAutomaticBinding=function(){var t=this;this.setModel(sap.ui.getCore().getMessageManager().getMessageModel(),"message");this._oMessageItemTemplate=new M({type:"{message>type}",title:"{message>message}",description:"{message>description}",longtextUrl:"{message>longtextUrl}"});this.bindAggregation("items",{path:"message>/",template:t._oMessageItemTemplate});};
j.prototype._groupItems=function(i){var o={},s,p;i.forEach(function(r){s=r.getGroupName();p=r.getType();o[s]=o[s]||{};var t=o[s];if(t[p]){t[p].push(r);}else{t[p]=[r];}});return o;};
j.prototype._onkeypress=function(E){if(E.shiftKey&&E.keyCode==q.sap.KeyCodes.ENTER){this._fnHandleBackPress();}};
j.prototype._getListHeader=function(){return this._oListHeader||this._createListHeader();};
j.prototype._getDetailsHeader=function(){return this._oDetailsHeader||this._createDetailsHeader();};
j.prototype._createListHeader=function(){var s=this._oResourceBundle.getText("MESSAGEPOPOVER_CLOSE");var i=this.getId()+"-CloseBtnDescr";var o=new H(i,{content:"<span id=\""+i+"\" style=\"display: none;\">"+s+"</span>"});var p=this._oResourceBundle.getText("MESSAGEPOPOVER_ARIA_HEADING");var r=this.getId()+"-HeadingDescr";var t=new H(r,{content:"<span id=\""+r+"\" style=\"display: none;\" role=\"heading\">"+p+"</span>"});this._oSegmentedButton=new e(this.getId()+"-segmented",{}).addStyleClass("sapMSegmentedButtonNoAutoWidth");this._oListHeader=new T({content:[this._oSegmentedButton,new b(),o,t]});return this._oListHeader;};
j.prototype._createDetailsHeader=function(){var s=this._oResourceBundle.getText("MESSAGEPOPOVER_CLOSE");var i=this.getId()+"-CloseBtnDetDescr";var o=new H(i,{content:"<span id=\""+i+"\" style=\"display: none;\">"+s+"</span>"});var p=this._oResourceBundle.getText("MESSAGEPOPOVER_ARIA_BACK_BUTTON_TOOLTIP");var r=this._oResourceBundle.getText("MESSAGEPOPOVER_ARIA_BACK_BUTTON");var t=this.getId()+"-BackBtnDetDescr";var u=new H(t,{content:"<span id=\""+t+"\" style=\"display: none;\">"+r+"</span>"});this._oBackButton=new B({icon:m["back"],press:this._fnHandleBackPress.bind(this),ariaLabelledBy:u,tooltip:p}).addStyleClass(k+"BackBtn");this._oDetailsHeader=new T({content:[this._oBackButton,new b(),o,u]});return this._oDetailsHeader;};
j.prototype._createNavigationPages=function(){this._listPage=new P(this.getId()+"listPage",{customHeader:this._getListHeader()});this._detailsPage=new P(this.getId()+"-detailsPage",{customHeader:this._getDetailsHeader()});this._detailsPage.addEventDelegate({onclick:function(E){var t=E.target;if(t.nodeName.toUpperCase()==="A"&&(t.className.indexOf("sapMMsgPopoverItemDisabledLink")!==-1||t.className.indexOf("sapMMsgPopoverItemPendingLink")!==-1)){E.preventDefault();}}});this._navContainer=new N(this.getId()+"-navContainer",{initialPage:this.getId()+"listPage",pages:[this._listPage,this._detailsPage]});return this;};
j.prototype._createLists=function(){this._oLists={};n.forEach(function(s){this._oLists[s]=new L({itemPress:this._fnHandleItemPress.bind(this),visible:false});this._listPage.addAggregation("content",this._oLists[s],true);},this);return this;};
j.prototype._clearLists=function(){n.forEach(function(s){if(this._oLists[s]){this._oLists[s].destroyAggregation("items",true);}},this);return this;};
j.prototype._destroyLists=function(){n.forEach(function(s){this._oLists[s]=null;},this);this._oLists=null;};
j.prototype._fillLists=function(i){i.forEach(function(o){var p=this._mapItemToListItem(o),r=this._mapItemToListItem(o);this._oLists["all"].addAggregation("items",p,true);this._oLists[o.getType().toLowerCase()].addAggregation("items",r,true);},this);};
j.prototype._mapItemToListItem=function(o){if(!o){return null;}var t=o.getType(),i=this._getItemType(o),p=new S({title:o.getTitle(),description:o.getSubtitle(),counter:o.getCounter(),icon:this._mapIcon(t),infoState:this._mapInfoState(t),info:"\r",type:i}).addStyleClass(k+"Item").addStyleClass(k+"Item"+t);if(i!==h.Navigation){p.addEventDelegate({onAfterRendering:function(){var r=this.getDomRef().querySelector(".sapMSLITitleDiv > div");if(r.offsetWidth<r.scrollWidth){this.setType(h.Navigation);}}},p);}p._oMessageItem=o;return p;};
j.prototype._mapInfoState=function(t){if(!t){return null;}var i=sap.ui.core.MessageType,V=sap.ui.core.ValueState;switch(t){case i.Warning:return V.Warning;case i.Error:return V.Error;case i.Success:return V.Success;case i.Information:case i.None:return V.None;default:q.sap.log.warning("The provided MessageType is not mapped to a specific ValueState",t);return null;}};
j.prototype._mapIcon=function(i){if(!i){return null;}return m[i.toLowerCase()];};
j.prototype._getItemType=function(o){return(o.getDescription()||o.getMarkupDescription()||o.getLongtextUrl())?h.Navigation:h.Inactive;};
j.prototype._clearSegmentedButton=function(){if(this._oSegmentedButton){this._oSegmentedButton.destroyAggregation("buttons",true);}return this;};
j.prototype._fillSegmentedButton=function(){var t=this;var p=function(s){return function(){t._fnFilterList(s);};};n.forEach(function(s){var o=this._oLists[s],i=o.getItems().filter(function(u){return(u instanceof S);}).length,r;if(i>0){r=new B(this.getId()+"-"+s,{text:s=="all"?this._oResourceBundle.getText("MESSAGEPOPOVER_ALL"):i,icon:m[s],press:p(s)}).addStyleClass(k+"Btn"+s.charAt(0).toUpperCase()+s.slice(1));this._oSegmentedButton.addButton(r,true);}},this);return this;};
j.prototype._setIcon=function(o,i){this._previousIconTypeClass=k+"DescIcon"+o.getType();this._oMessageIcon=new a({src:i.getIcon()}).addStyleClass(k+"DescIcon").addStyleClass(this._previousIconTypeClass);this._detailsPage.addContent(this._oMessageIcon);};
j.prototype._setTitle=function(o){this._oMessageTitleText=new d(this.getId()+"MessageTitleText",{text:o.getTitle()}).addStyleClass("sapMMsgViewTitleText");this._detailsPage.addAggregation("content",this._oMessageTitleText);};
j.prototype._setDescription=function(o){var i=o.getLink();this._oLastSelectedItem=o;if(o.getMarkupDescription()){this._oMessageDescriptionText=new H(this.getId()+"MarkupDescription",{content:"<div class='sapMMsgViewDescriptionText'>"+o.getDescription()+"</div>"});}else{this._oMessageDescriptionText=new d(this.getId()+"MessageDescriptionText",{text:o.getDescription()}).addStyleClass("sapMMsgViewDescriptionText");}this._detailsPage.addContent(this._oMessageDescriptionText);if(i){this._detailsPage.addContent(i);i.addStyleClass("sapMMsgViewDescriptionLink");}};
j.prototype._iNextValidationTaskId=0;
j.prototype._validateURL=function(u){if(q.sap.validateUrl(u)){return u;}q.sap.log.warning("You have entered invalid URL");return"";};
j.prototype._queueValidation=function(i){var o=this.getAsyncURLHandler();var v=++this._iNextValidationTaskId;var p={};var r=new window.Promise(function(s,t){p.resolve=s;p.reject=t;var u={url:i,id:v,promise:p};o(u);});r.id=v;return r;};
j.prototype._getTagPolicy=function(){var t=this,i;var o=html.makeTagPolicy(this._validateURL());return function customTagPolicy(p,r){var s,v=false;if(p.toUpperCase()==="A"){for(i=0;i<r.length;){if(r[i]==="href"){v=true;s=r[i+1];r.splice(0,2);continue;}i+=2;}}r=o(p,r);if(v&&typeof t.getAsyncURLHandler()==="function"){r=r||[];var u="sapMMsgViewItemDisabledLink sapMMsgViewItemPendingLink";var w=r.indexOf("class");if(w>-1){r[w+1]+=u;}else{r.unshift(u);r.unshift("class");}var x=r.indexOf("id");if(x>-1){r.splice(x+1,1);r.splice(x,1);}var V=t._queueValidation(s);r.push("href");r.push(s);r.push("target");r.push("_blank");r.push("id");r.push("sap-ui-"+t.getId()+"-link-under-validation-"+V.id);V.then(function(y){var $=q.sap.byId("sap-ui-"+t.getId()+"-link-under-validation-"+y.id);if(y.allowed){q.sap.log.info("Allow link "+s);}else{q.sap.log.info("Disallow link "+s);}$.removeClass("sapMMsgViewItemPendingLink");$.toggleClass("sapMMsgViewItemDisabledLink",!y.allowed);t.fireUrlValidated();}).catch(function(){q.sap.log.warning("Async URL validation could not be performed.");});}return r;};};
j.prototype._sanitizeDescription=function(o){q.sap.require("jquery.sap.encoder");q.sap.require("sap.ui.thirdparty.caja-html-sanitizer");var s=o.getDescription();if(o.getMarkupDescription()){var t=this._getTagPolicy();s=html.sanitizeWithPolicy(s,t);}o.setDescription(s);this._setDescription(o);};
j.prototype._fnHandleItemPress=function(E){var o=E.getParameter("listItem"),i=o._oMessageItem,p=this._detailsPage.getContent()||[];var r=this.getAsyncDescriptionHandler();var s=function(w){this._setTitle(i);this._sanitizeDescription(i);this._setIcon(i,o);this._detailsPage.rerender();this.fireLongtextLoaded();if(!w){this._navContainer.to(this._detailsPage);}}.bind(this);this._previousIconTypeClass=this._previousIconTypeClass||"";this.fireItemSelect({item:i,messageTypeFilter:this._getCurrentMessageTypeFilter()});p.forEach(function(w){if(w instanceof f){this._oLastSelectedItem.setLink(w);w.removeAllAriaLabelledBy();}else{w.destroy();}},this);if(typeof r==="function"&&!!i.getLongtextUrl()){i.setMarkupDescription(true);var t={};var u=new window.Promise(function(w,x){t.resolve=w;t.reject=x;});var v=function(){this._detailsPage.setBusy(false);s(true);}.bind(this);u.then(v).catch(function(){q.sap.log.warning("Async description loading could not be performed.");v();});this._navContainer.to(this._detailsPage);this._detailsPage.setBusy(true);r({promise:t,item:i});}else{s();}this._listPage.$().attr("aria-hidden","true");};
j.prototype._fnHandleBackPress=function(){this._listPage.$().removeAttr("aria-hidden");this._navContainer.back();};
j.prototype._fnFilterList=function(s){n.forEach(function(i){if(i!=s&&this._oLists[i].getVisible()){this._oLists[i].setVisible(false);}},this);this._sCurrentList=s;this._oLists[s].setVisible(true);this._listPage.rerender();this.fireListSelect({messageTypeFilter:this._getCurrentMessageTypeFilter()});};
j.prototype._getCurrentMessageTypeFilter=function(){return this._sCurrentList=="all"?"":this._sCurrentList;};
j.prototype._isListPage=function(){return this._navContainer.getCurrentPage()==this._listPage;};
return j;},true);
sap.ui.predefine('sap/m/MessageViewRenderer',function(){"use strict";var M={};var C="sapMMsgView";
M.render=function(r,c){r.write("<div");r.writeControlData(c);r.writeStyles();r.addClass(C);r.writeClasses();r.write(">");r.renderControl(c._navContainer);r.write("</div>");};
return M;},true);
sap.ui.predefine('sap/m/MultiComboBox',['jquery.sap.global','./Bar','./InputBase','./ComboBoxTextField','./ComboBoxBase','./Dialog','./MultiInput','./Input','./ToggleButton','./List','./MultiComboBoxRenderer','./Popover','./library','sap/ui/core/EnabledPropagator','sap/ui/core/InvisibleText','sap/ui/core/IconPool','jquery.sap.xml'],function(q,B,I,C,a,D,M,b,T,L,c,P,l,E,d,e){"use strict";
var f=a.extend("sap.m.MultiComboBox",{metadata:{library:"sap.m",properties:{selectedKeys:{type:"string[]",group:"Data",defaultValue:[]}},associations:{selectedItems:{type:"sap.ui.core.Item",multiple:true,singularName:"selectedItem"}},events:{selectionChange:{parameters:{changedItem:{type:"sap.ui.core.Item"},selected:{type:"boolean"}}},selectionFinish:{parameters:{selectedItems:{type:"sap.ui.core.Item[]"}}}}}});
e.insertFontFaceStyle();E.apply(f.prototype,[true]);
f.prototype.onsapend=function(o){sap.m.Tokenizer.prototype.onsapend.apply(this._oTokenizer,arguments);};
f.prototype.onsaphome=function(o){sap.m.Tokenizer.prototype.onsaphome.apply(this._oTokenizer,arguments);};
f.prototype.onsapdown=function(o){if(!this.getEnabled()||!this.getEditable()){return;}o.setMarked();o.preventDefault();var i=this.getSelectableItems();var g=i[0];if(g&&this.isOpen()){this.getListItem(g).focus();return;}if(this._oTokenizer.getSelectedTokens().length){return;}this._oTraversalItem=this._getNextTraversalItem();if(this._oTraversalItem){this.updateDomValue(this._oTraversalItem.getText());this.selectText(0,this.getValue().length);}};
f.prototype.onsapup=function(o){if(!this.getEnabled()||!this.getEditable()){return;}o.setMarked();o.preventDefault();if(this._oTokenizer.getSelectedTokens().length){return;}this._oTraversalItem=this._getPreviousTraversalItem();if(this._oTraversalItem){this.updateDomValue(this._oTraversalItem.getText());this.selectText(0,this.getValue().length);}};
f.prototype.onsapshow=function(o){var g=this.getList(),p=this.getPicker(),s=this.getSelectableItems(),S=this.getSelectedItems(),i,h=g.getItemNavigation(),j,k;k=q(document.activeElement).control()[0];if(k instanceof sap.m.Token){i=this._getItemByToken(k);}else{i=S.length?this._getItemByListItem(this.getList().getSelectedItems()[0]):s[0];}j=this.getItems().indexOf(i);if(h){h.setSelectedIndex(j);}else{this._bListItemNavigationInvalidated=true;this._iInitialItemFocus=j;}p.setInitialFocus(g);a.prototype.onsapshow.apply(this,arguments);};
f.prototype.onsaphide=f.prototype.onsapshow;
f.prototype._selectItemByKey=function(o){var v,p,g,i,h,j=this.isOpen();if(!this.getEnabled()||!this.getEditable()){return;}if(o){o.setMarked();}v=this._getUnselectedItems(j?"":this.getValue());for(i=0;i<v.length;i++){if(v[i].getText().toUpperCase()===this.getValue().toUpperCase()){g=v[i];h=true;break;}}if(h){p={item:g,id:g.getId(),key:g.getKey(),fireChangeEvent:true,fireFinishEvent:true,suppressInvalidate:true,listItemUpdated:false};this._bPreventValueRemove=false;if(this.getValue()===""||q.sap.startsWithIgnoreCase(g.getText(),this.getValue())){if(this.getListItem(g).isSelected()){this.setValue('');}else{this.setSelection(p);}}}else{this._bPreventValueRemove=true;this._showWrongValueVisualEffect();}if(o){this.close();}};
f.prototype.onsapenter=function(o){I.prototype.onsapenter.apply(this,arguments);if(this.getValue()){this._selectItemByKey(o);}};
f.prototype.onsaptabnext=function(o){var i=this.getValue();if(i){var s=this._getUnselectedItemsStartingText(i);if(s.length===1){this._selectItemByKey(o);}else{this._showWrongValueVisualEffect();this.setValue(null);}}};
f.prototype.onsapfocusleave=function(o){var p=this.getAggregation("picker");var t=this.isPlatformTablet();var g=sap.ui.getCore().byId(o.relatedControlId);var F=g&&g.getFocusDomRef();if(!p||!p.getFocusDomRef()||!F||!q.contains(p.getFocusDomRef(),F)){this.setValue(null);if(!(g instanceof sap.m.Token)){this._oTokenizer.scrollToEnd();}}if(p&&F){if(q.sap.equal(p.getFocusDomRef(),F)&&!t&&!this.isPickerDialog()){this.focus();}}};
f.prototype.onfocusin=function(o){var g=this.getPickerType()==="Dropdown";if(o.target===this.getFocusDomRef()){this.getEditable()&&this.addStyleClass("sapMMultiComboBoxFocus");}if(o.target===this.getOpenArea()&&g&&!this.isPlatformTablet()){this.focus();}if(!this.isOpen()&&this.shouldValueStateMessageBeOpened()){this.openValueStateMessage();}};
f.prototype._handleItemTap=function(o){if(o.target.childElementCount===0||o.target.childElementCount===2){this._bCheckBoxClicked=false;if(this.isOpen()&&!this._isListInSuggestMode()){this.close();}}};
f.prototype._handleItemPress=function(o){if(this.isOpen()&&this._isListInSuggestMode()&&this.getPicker().oPopup.getOpenState()!==sap.ui.core.OpenState.CLOSING){this.clearFilter();var i=this._getLastSelectedItem();if(i){this.getListItem(i).focus();}}};
f.prototype._handleSelectionLiveChange=function(o){var g=o.getParameter("listItem");var i=o.getParameter("selected");var n=this._getItemByListItem(g);if(g.getType()==="Inactive"){return;}if(!n){return;}var p={item:n,id:n.getId(),key:n.getKey(),fireChangeEvent:true,suppressInvalidate:true,listItemUpdated:true};if(i){this.fireChangeEvent(n.getText());this.setSelection(p);}else{this.fireChangeEvent(n.getText());this.removeSelection(p);}if(this._bCheckBoxClicked){this.setValue(this._sOldValue);if(this.isOpen()&&this.getPicker().oPopup.getOpenState()!==sap.ui.core.OpenState.CLOSING){g.focus();}}else{this._bCheckBoxClicked=true;this.setValue("");this.close();}};
f.prototype.onkeydown=function(o){a.prototype.onkeydown.apply(this,arguments);if(!this.getEnabled()||!this.getEditable()){return;}this._bIsPasteEvent=(o.ctrlKey||o.metaKey)&&(o.which===q.sap.KeyCodes.V);if(this.getValue().length===0&&(o.ctrlKey||o.metaKey)&&(o.which===q.sap.KeyCodes.A)&&this._hasTokens()){this._oTokenizer.focus();this._oTokenizer.selectAllTokens(true);o.preventDefault();}if(this.isPickerDialog()){this._sOldValue=this.getPickerTextField().getValue();this._iOldCursorPos=q(this.getFocusDomRef()).cursorPos();}};
f.prototype.oninput=function(o){a.prototype.oninput.apply(this,arguments);var i=o.srcControl;if(!this.getEnabled()||!this.getEditable()){return;}if(this._bIsPasteEvent){i.updateDomValue(this._sOldValue||"");return;}if(!this._bCompositionStart&&!this._bCompositionEnd){this._handleInputValidation(o,false);}};
f.prototype.filterItems=function(i,v){i.forEach(function(o){var m=q.sap.startsWithIgnoreCase(o.getText(),v);if(v===""){m=true;if(!this.bOpenedByKeyboardOrButton){return;}}var g=this.getListItem(o);if(g){g.setVisible(m);}},this);};
f.prototype.onkeyup=function(o){if(!this.getEnabled()||!this.getEditable()){return;}this._sOldValue=this.getValue();this._iOldCursorPos=q(this.getFocusDomRef()).cursorPos();};
f.prototype._showWrongValueVisualEffect=function(){var o=this.getValueState();if(o===sap.ui.core.ValueState.Error){return;}if(this.isPickerDialog()){this.getPickerTextField().setValueState(sap.ui.core.ValueState.Error);q.sap.delayedCall(1000,this.getPickerTextField(),"setValueState",[o]);}else{this.setValueState(sap.ui.core.ValueState.Error);q.sap.delayedCall(1000,this,"setValueState",[o]);}};
f.prototype.createPicker=function(p){var o=this.getAggregation("picker");if(o){return o;}o=this["create"+p]();this.setAggregation("picker",o,true);var r=this.getRenderer(),g=r.CSS_CLASS_MULTICOMBOBOX;o.setHorizontalScrolling(false).addStyleClass(r.CSS_CLASS_COMBOBOXBASE+"Picker").addStyleClass(g+"Picker").addStyleClass(g+"Picker-CTX").attachBeforeOpen(this.onBeforeOpen,this).attachAfterOpen(this.onAfterOpen,this).attachBeforeClose(this.onBeforeClose,this).attachAfterClose(this.onAfterClose,this).addEventDelegate({onBeforeRendering:this.onBeforeRenderingPicker,onAfterRendering:this.onAfterRenderingPicker},this).addContent(this.getList());return o;};
f.prototype.createPickerTextField=function(){return new b();};
f.prototype.onBeforeRendering=function(){a.prototype.onBeforeRendering.apply(this,arguments);var i=this.getItems();var o=this.getList();if(o){this._synchronizeSelectedItemAndKey(i);o.destroyItems();this._clearTokenizer();this._fillList(i);if(o.getItemNavigation()){this._iFocusedIndex=o.getItemNavigation().getFocusedIndex();}this.setEditable(this.getEditable());}};
f.prototype.onBeforeRenderingPicker=function(){var o=this["_onBeforeRendering"+this.getPickerType()];if(o){o.call(this);}};
f.prototype.onAfterRenderingPicker=function(){var o=this["_onAfterRendering"+this.getPickerType()];if(o){o.call(this);}};
f.prototype.onBeforeOpen=function(){var p=this["_onBeforeOpen"+this.getPickerType()];this.addStyleClass(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Pressed");this._resetCurrentItem();this.addContent();this._aInitiallySelectedItems=this.getSelectedItems();if(p){p.call(this);}};
f.prototype.onAfterOpen=function(){if(!this.isPlatformTablet()){this.getPicker().setInitialFocus(this);}this.closeValueStateMessage();};
f.prototype.onBeforeClose=function(){a.prototype.onBeforeClose.apply(this,arguments);};
f.prototype.onAfterClose=function(){this.removeStyleClass(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Pressed");this.clearFilter();!this._bPreventValueRemove&&this.setValue("");this._sOldValue="";if(this.isPickerDialog()){this.getPickerTextField().setValue("");this._getFilterSelectedButton().setPressed(false);}this.fireSelectionFinish({selectedItems:this.getSelectedItems()});};
f.prototype._onBeforeOpenDialog=function(){};
f.prototype._onBeforeOpenPopover=function(){var p=this.getPicker(),o=this.getDomRef(),w;if(o&&p){w=(o.offsetWidth/parseFloat(sap.m.BaseFontSize))+"rem";p.setContentMinWidth(w);}};
f.prototype._decoratePopover=function(p){var t=this;p.open=function(){return this.openBy(t);};};
f.prototype.createDropdown=function(){var o=new P(this.getDropdownSettings());o.setInitialFocus(this);this._decoratePopover(o);return o;};
f.prototype.createDialog=function(){var o=a.prototype.createDialog.apply(this,arguments),s=this._createFilterSelectedButton();o.getSubHeader().addContent(s);return o;};
f.prototype._createFilterSelectedButton=function(){var i=e.getIconURI("multiselect-all"),r=this.getRenderer(),t=this;return new T({icon:i,press:t._filterSelectedItems.bind(this)}).addStyleClass(r.CSS_CLASS_MULTICOMBOBOX+"ToggleButton");};
f.prototype._getFilterSelectedButton=function(){return this.getPicker().getSubHeader().getContent()[1];};
f.prototype._filterSelectedItems=function(o){var g=o.oSource,h,m,v=this.getPickerTextField().getValue(),p=g.getPressed(),V=this.getVisibleItems(),i=this.getItems(),s=this.getSelectedItems();if(p){V.forEach(function(j){m=s.indexOf(j)>-1?true:false;h=this.getListItem(j);if(h){h.setVisible(m);}},this);}else{this.filterItems(i,v);}};
f.prototype.revertSelection=function(){this.setSelectedItems(this._aInitiallySelectedItems);};
f.prototype.createList=function(){var r=this.getRenderer();this._oList=new L({width:"100%",mode:sap.m.ListMode.MultiSelect,includeItemInSelection:true,rememberSelections:false}).addStyleClass(r.CSS_CLASS_COMBOBOXBASE+"List").addStyleClass(r.CSS_CLASS_MULTICOMBOBOX+"List").attachBrowserEvent("tap",this._handleItemTap,this).attachSelectionChange(this._handleSelectionLiveChange,this).attachItemPress(this._handleItemPress,this);this._oList.addEventDelegate({onAfterRendering:this.onAfterRenderingList,onfocusin:this.onFocusinList},this);};
f.prototype.setSelection=function(o){if(o.item&&this.isItemSelected(o.item)){return;}if(!o.item){return;}if(!o.listItemUpdated&&this.getListItem(o.item)){this.getList().setSelectedItem(this.getListItem(o.item),true);}var t=new sap.m.Token({key:o.key});t.setText(o.item.getText());t.setTooltip(o.item.getText());o.item.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Token",t);this._oTokenizer.addToken(t);this.$().toggleClass("sapMMultiComboBoxHasToken",this._hasTokens());this.setValue('');this.addAssociation("selectedItems",o.item,o.suppressInvalidate);var s=this.getKeys(this.getSelectedItems());this.setProperty("selectedKeys",s,o.suppressInvalidate);if(o.fireChangeEvent){this.fireSelectionChange({changedItem:o.item,selected:true});}if(o.fireFinishEvent){if(!this.isOpen()){this.fireSelectionFinish({selectedItems:this.getSelectedItems()});}}};
f.prototype.removeSelection=function(o){if(o.item&&!this.isItemSelected(o.item)){return;}if(!o.item){return;}this.removeAssociation("selectedItems",o.item,o.suppressInvalidate);var s=this.getKeys(this.getSelectedItems());this.setProperty("selectedKeys",s,o.suppressInvalidate);if(!o.listItemUpdated&&this.getListItem(o.item)){this.getList().setSelectedItem(this.getListItem(o.item),false);}if(!o.tokenUpdated){var t=this._getTokenByItem(o.item);o.item.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Token",null);this._oTokenizer.removeToken(t);}this.$().toggleClass("sapMMultiComboBoxHasToken",this._hasTokens());if(o.fireChangeEvent){this.fireSelectionChange({changedItem:o.item,selected:false});}if(o.fireFinishEvent){if(!this.isOpen()){this.fireSelectionFinish({selectedItems:this.getSelectedItems()});}}};
f.prototype._synchronizeSelectedItemAndKey=function(g){if(!g.length){q.sap.log.info("Info: _synchronizeSelectedItemAndKey() the MultiComboBox control does not contain any item on ",this);return;}var s=this.getSelectedKeys()||this._aCustomerKeys;var k=this.getKeys(this.getSelectedItems());if(s.length){for(var i=0,K=null,o=null,h=null,j=s.length;i<j;i++){K=s[i];if(k.indexOf(K)>-1){if(this._aCustomerKeys.length&&(h=this._aCustomerKeys.indexOf(K))>-1){this._aCustomerKeys.splice(h,1);}continue;}o=this.getItemByKey(""+K);if(o){if(this._aCustomerKeys.length&&(h=this._aCustomerKeys.indexOf(K))>-1){this._aCustomerKeys.splice(h,1);}this.setSelection({item:o,id:o.getId(),key:o.getKey(),fireChangeEvent:false,suppressInvalidate:true,listItemUpdated:false});}}return;}};
f.prototype._getTokenByItem=function(i){return i?i.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Token"):null;};
f.prototype.updateItems=function(r){var k,i,K=this.getSelectedKeys();var u=a.prototype.updateItems.apply(this,arguments);i=this.getSelectedItems();k=(i.length===K.length)&&i.every(function(o){return o&&o.getKey&&K.indexOf(o.getKey())>-1;});if(!k){i=K.map(this.getItemByKey,this);this.setSelectedItems(i);}return u;};
f.prototype._getSelectedItemsOf=function(g){for(var i=0,h=g.length,s=[];i<h;i++){if(this.getListItem(g[i]).isSelected()){s.push(g[i]);}}return s;};
f.prototype._getLastSelectedItem=function(){var t=this._oTokenizer.getTokens();var o=t.length?t[t.length-1]:null;if(!o){return null;}return this._getItemByToken(o);};
f.prototype._getOrderedSelectedItems=function(){var g=[];for(var i=0,t=this._oTokenizer.getTokens(),h=t.length;i<h;i++){g[i]=this._getItemByToken(t[i]);}return g;};
f.prototype._getFocusedListItem=function(){if(!document.activeElement){return null;}var F=sap.ui.getCore().byId(document.activeElement.id);if(this.getList()&&q.sap.containsOrEquals(this.getList().getFocusDomRef(),F.getFocusDomRef())){return F;}return null;};
f.prototype._getFocusedItem=function(){var o=this._getFocusedListItem();return this._getItemByListItem(o);};
f.prototype._isRangeSelectionSet=function(o){var $=o.getDomRef();return $.indexOf(this.getRenderer().CSS_CLASS_MULTICOMBOBOX+"ItemRangeSelection")>-1?true:false;};
f.prototype._hasTokens=function(){return this._oTokenizer.getTokens().length>0;};
f.prototype._getCurrentItem=function(){if(!this._oCurrentItem){return this._getFocusedItem();}return this._oCurrentItem;};
f.prototype._setCurrentItem=function(i){this._oCurrentItem=i;};
f.prototype._resetCurrentItem=function(){this._oCurrentItem=null;};
f.prototype._decorateListItem=function(o){o.addDelegate({onkeyup:function(g){var i=null;if(g.which==q.sap.KeyCodes.SPACE&&this.isOpen()&&this._isListInSuggestMode()){this.open();i=this._getLastSelectedItem();if(i){this.getListItem(i).focus();}return;}},onkeydown:function(g){var i=null,h=null;if(g.shiftKey&&g.which==q.sap.KeyCodes.ARROW_DOWN){h=this._getCurrentItem();i=this._getNextVisibleItemOf(h);}if(g.shiftKey&&g.which==q.sap.KeyCodes.ARROW_UP){h=this._getCurrentItem();i=this._getPreviousVisibleItemOf(h);}if(g.shiftKey&&g.which===q.sap.KeyCodes.SPACE){h=this._getCurrentItem();this._selectPreviousItemsOf(h);}if(i&&i!==h){if(this.getListItem(h).isSelected()){this.setSelection({item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:true,suppressInvalidate:true});this._setCurrentItem(i);}else{this.removeSelection({item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:true,suppressInvalidate:true});this._setCurrentItem(i);}return;}this._resetCurrentItem();if((g.ctrlKey||g.metaKey)&&g.which==q.sap.KeyCodes.A){g.setMarked();g.preventDefault();var v=this.getSelectableItems();var s=this._getSelectedItemsOf(v);if(s.length!==v.length){v.forEach(function(i){this.setSelection({item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:true,suppressInvalidate:true,listItemUpdated:false});},this);}else{v.forEach(function(i){this.removeSelection({item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:true,suppressInvalidate:true,listItemUpdated:false});},this);}}}},true,this);o.addEventDelegate({onsapbackspace:function(g){g.preventDefault();},onsapshow:function(g){g.setMarked();if(g.keyCode===q.sap.KeyCodes.F4){g.preventDefault();}if(this.isOpen()){this.close();return;}if(this.hasContent()){this.open();}},onsaphide:function(g){this.onsapshow(g);},onsapenter:function(g){g.setMarked();this.close();},onsaphome:function(g){g.setMarked();g.preventDefault();var v=this.getSelectableItems();var i=v[0];this.getListItem(i).focus();},onsapend:function(g){g.setMarked();g.preventDefault();var v=this.getSelectableItems();var i=v[v.length-1];this.getListItem(i).focus();},onsapup:function(g){g.setMarked();g.preventDefault();var v=this.getSelectableItems();var i=v[0];var h=q(document.activeElement).control()[0];if(h===this.getListItem(i)){this.focus();g.stopPropagation(true);}},onfocusin:function(g){this.addStyleClass(this.getRenderer().CSS_CLASS_MULTICOMBOBOX+"Focused");},onfocusout:function(g){this.removeStyleClass(this.getRenderer().CSS_CLASS_MULTICOMBOBOX+"Focused");},onsapfocusleave:function(g){var p=this.getAggregation("picker");var h=sap.ui.getCore().byId(g.relatedControlId);if(p&&h&&q.sap.equal(p.getFocusDomRef(),h.getFocusDomRef())){if(g.srcControl){g.srcControl.focus();}}}},this);if(sap.ui.Device.support.touch){o.addEventDelegate({ontouchstart:function(g){g.setMark("cancelAutoClose");}});}};
f.prototype._createTokenizer=function(){var t=new sap.m.Tokenizer({tokens:[]}).attachTokenChange(this._handleTokenChange,this);t.setParent(this);t.addEventDelegate({onAfterRendering:this._onAfterRenderingTokenizer},this);return t;};
f.prototype._onAfterRenderingTokenizer=function(){this._oTokenizer.scrollToEnd();};
f.prototype._handleTokenChange=function(o){var t=o.getParameter("type");var g=o.getParameter("token");var i=null;if(t!==sap.m.Tokenizer.TokenChangeType.Removed&&t!==sap.m.Tokenizer.TokenChangeType.Added){return;}if(t===sap.m.Tokenizer.TokenChangeType.Removed){i=(g&&this._getItemByToken(g));if(i&&this.isItemSelected(i)){this.removeSelection({item:i,id:i.getId(),key:i.getKey(),tokenUpdated:true,fireChangeEvent:true,fireFinishEvent:true,suppressInvalidate:true});!this.isPickerDialog()&&this.focus();this.fireChangeEvent("");}}};
f.prototype.onAfterRenderingList=function(){var o=this.getList();if(this._iFocusedIndex!=null&&o.getItems().length>this._iFocusedIndex){o.getItems()[this._iFocusedIndex].focus();this._iFocusedIndex=null;}};
f.prototype.onFocusinList=function(){if(this._bListItemNavigationInvalidated){this.getList().getItemNavigation().setSelectedIndex(this._iInitialItemFocus);this._bListItemNavigationInvalidated=false;}};
f.prototype.onAfterRendering=function(){a.prototype.onAfterRendering.apply(this,arguments);var p=this.getPicker();var o=q(this.getDomRef());var g=o.find(this.getRenderer().DOT_CSS_CLASS_MULTICOMBOBOX+"Border");p._oOpenBy=g[0];};
f.prototype.onfocusout=function(o){this.removeStyleClass("sapMMultiComboBoxFocus");a.prototype.onfocusout.apply(this,arguments);};
f.prototype.onpaste=function(o){var O;if(window.clipboardData){O=window.clipboardData.getData("Text");}else{O=o.originalEvent.clipboardData.getData('text/plain');}var s=this._oTokenizer._parseString(O);if(s&&s.length>0){this.getSelectableItems().forEach(function(i){if(q.inArray(i.getText(),s)>-1){this.setSelection({item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:true,fireFinishEvent:true,suppressInvalidate:true,listItemUpdated:false});}},this);}};
f.prototype.onsapbackspace=function(o){if(!this.getEnabled()||!this.getEditable()){o.preventDefault();return;}if(this.getCursorPosition()>0||this.getValue().length>0){return;}sap.m.Tokenizer.prototype.onsapbackspace.apply(this._oTokenizer,arguments);o.preventDefault();};
f.prototype.onsapdelete=function(o){if(!this.getEnabled()||!this.getEditable()){return;}if(this.getValue()&&!this._isCompleteTextSelected()){return;}sap.m.Tokenizer.prototype.onsapdelete.apply(this._oTokenizer,arguments);};
f.prototype.onsapnext=function(o){if(o.isMarked()){return;}var F=q(document.activeElement).control()[0];if(!F){return;}if(F===this._oTokenizer||this._oTokenizer.$().find(F.$()).length>0&&this.getEditable()){this.focus();}};
f.prototype.onsapprevious=function(o){if(this.getCursorPosition()===0&&!this._isCompleteTextSelected()){if(o.srcControl===this){sap.m.Tokenizer.prototype.onsapprevious.apply(this._oTokenizer,arguments);}}};
f.prototype.getOpenArea=function(){if(this.isPickerDialog()){return this.getDomRef();}else{return a.prototype.getOpenArea.apply(this,arguments);}};
f.prototype._getItemsStartingText=function(t,i){var g=[],s=i?this.getEnabledItems():this.getSelectableItems();s.forEach(function(o){if(q.sap.startsWithIgnoreCase(o.getText(),t)){g.push(o);}},this);return g;};
f.prototype._getUnselectedItemsStartingText=function(t){var i=[];this._getUnselectedItems().forEach(function(o){if(q.sap.startsWithIgnoreCase(o.getText(),t)){i.push(o);}},this);return i;};
f.prototype.getCursorPosition=function(){return this._$input.cursorPos();};
f.prototype._isCompleteTextSelected=function(){if(!this.getValue().length){return false;}var i=this._$input[0];if(i.selectionStart!==0||i.selectionEnd!==this.getValue().length){return false;}return true;};
f.prototype._selectPreviousItemsOf=function(i){var g;do{g=true;var p=this._getPreviousVisibleItemOf(i);if(p){var o=this.getListItem(p);if(o){g=this.getListItem(p).getSelected();}}this.setSelection({item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:true,suppressInvalidate:true});i=p;}while(!g);};
f.prototype._getNextVisibleItemOf=function(i){var g=this.getSelectableItems();var h=g.indexOf(i)+1;if(h<=0||h>g.length-1){return null;}return g[h];};
f.prototype._getPreviousVisibleItemOf=function(i){var g=this.getSelectableItems();var h=g.indexOf(i)-1;if(h<0){return null;}return g[h];};
f.prototype._getNextUnselectedItemOf=function(i){var g=this._getUnselectedItems();var h=g.indexOf(i)+1;if(h<=0||h>g.length-1){return null;}return g[h];};
f.prototype._getPreviousUnselectedItemOf=function(i){var g=this._getUnselectedItems();var h=g.indexOf(i)-1;if(h<0){return null;}return g[h];};
f.prototype._getNextTraversalItem=function(){var i=this._getItemsStartingText(this.getValue());var s=this._getUnselectedItems();if(i.indexOf(this._oTraversalItem)>-1&&this._oTraversalItem.getText()===this.getValue()){return this._getNextUnselectedItemOf(this._oTraversalItem);}if(i.length&&i[0].getText()===this.getValue()){return this._getNextUnselectedItemOf(i[0]);}return i.length?i[0]:s[0];};
f.prototype._getPreviousTraversalItem=function(){var i=this._getItemsStartingText(this.getValue());if(i.indexOf(this._oTraversalItem)>-1&&this._oTraversalItem.getText()===this.getValue()){return this._getPreviousUnselectedItemOf(this._oTraversalItem);}if(i.length&&i[i.length-1].getText()===this.getValue()){return this._getPreviousUnselectedItemOf(i[i.length-1]);}if(i.length){return i[i.length-1];}else{var s=this._getUnselectedItems();if(s.length>0){return s[s.length-1];}else{return null;}}};
f.prototype.findFirstEnabledItem=function(g){g=g||this.getItems();for(var i=0;i<g.length;i++){if(g[i].getEnabled()){return g[i];}}return null;};
f.prototype.getVisibleItems=function(){for(var i=0,o,g=this.getItems(),v=[];i<g.length;i++){o=this.getListItem(g[i]);if(o&&o.getVisible()){v.push(g[i]);}}return v;};
f.prototype.findLastEnabledItem=function(i){i=i||this.getItems();return this.findFirstEnabledItem(i.reverse());};
f.prototype.setSelectedItems=function(i){this.removeAllSelectedItems();if(!i||!i.length){return this;}if(!q.isArray(i)){q.sap.log.warning("Warning: setSelectedItems() has to be an array of sap.ui.core.Item instances or of valid sap.ui.core.Item IDs",this);return this;}i.forEach(function(o){if(!(o instanceof sap.ui.core.Item)&&(typeof o!=="string")){q.sap.log.warning("Warning: setSelectedItems() has to be an array of sap.ui.core.Item instances or of valid sap.ui.core.Item IDs",this);return;}if(typeof o==="string"){o=sap.ui.getCore().byId(o);}this.setSelection({item:o?o:null,id:o?o.getId():"",key:o?o.getKey():"",suppressInvalidate:true});},this);return this;};
f.prototype.addSelectedItem=function(i){if(!i){return this;}if(typeof i==="string"){i=sap.ui.getCore().byId(i);}this.setSelection({item:i?i:null,id:i?i.getId():"",key:i?i.getKey():"",fireChangeEvent:false,suppressInvalidate:true});return this;};
f.prototype.removeSelectedItem=function(i){if(!i){return null;}if(typeof i==="string"){i=sap.ui.getCore().byId(i);}if(!this.isItemSelected(i)){return null;}this.removeSelection({item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:false,suppressInvalidate:true});return i;};
f.prototype.removeAllSelectedItems=function(){var i=[];var g=this.getAssociation("selectedItems",[]);g.forEach(function(o){var h=this.removeSelectedItem(o);if(h){i.push(h.getId());}},this);return i;};
f.prototype.removeSelectedKeys=function(k){var i=[],g;if(!k||!k.length||!q.isArray(k)){return i;}var o;k.forEach(function(K){o=this.getItemByKey(K);if(o){this.removeSelection({item:o?o:null,id:o?o.getId():"",key:o?o.getKey():"",fireChangeEvent:false,suppressInvalidate:true});i.push(o);}if(this._aCustomerKeys.length&&(g=this._aCustomerKeys.indexOf(K))>-1){this._aCustomerKeys.splice(g,1);}},this);return i;};
f.prototype.setSelectedKeys=function(k){this.removeAllSelectedItems();this._aCustomerKeys=[];this.addSelectedKeys(k);return this;};
f.prototype.addSelectedKeys=function(k){k=this.validateProperty("selectedKeys",k);k.forEach(function(K){var i=this.getItemByKey(K);if(i){this.addSelectedItem(i);}else if(K!=null){this._aCustomerKeys.push(K);}},this);return this;};
f.prototype.getSelectedKeys=function(){var i=this.getSelectedItems()||[],k=[];i.forEach(function(o){k.push(o.getKey());},this);if(this._aCustomerKeys.length){k=k.concat(this._aCustomerKeys);}return k;};
f.prototype._getUnselectedItems=function(){return q(this.getSelectableItems()).not(this.getSelectedItems()).get();};
f.prototype.getSelectedItems=function(){var i=[],g=this.getAssociation("selectedItems")||[];g.forEach(function(s){var o=sap.ui.getCore().byId(s);if(o){i.push(o);}},this);return i;};
f.prototype.getSelectableItems=function(){return this.getEnabledItems(this.getVisibleItems());};
f.prototype.getWidth=function(){return this.getProperty("width")||"100%";};
f.prototype.setEditable=function(g){a.prototype.setEditable.apply(this,arguments);this._oTokenizer.setEditable(g);return this;};
f.prototype.clearFilter=function(){this.getItems().forEach(function(i){this.getListItem(i).setVisible(i.getEnabled()&&this.getSelectable(i));},this);};
f.prototype._isListInSuggestMode=function(){return this.getList().getItems().some(function(o){return!o.getVisible()&&this._getItemByListItem(o).getEnabled();},this);};
f.prototype._mapItemToListItem=function(i){if(!i){return null;}var s=this.getRenderer().CSS_CLASS_MULTICOMBOBOX+"Item";var g=(this.isItemSelected(i))?s+"Selected":"";var o=new sap.m.StandardListItem({type:sap.m.ListType.Active,visible:i.getEnabled()}).addStyleClass(s+" "+g);o.setTooltip(i.getTooltip());i.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"ListItem",o);o.setTitle(i.getText());if(g){var t=new sap.m.Token({key:i.getKey()});t.setText(i.getText());t.setTooltip(i.getText());i.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Token",t);this._oTokenizer.addToken(t);}this.setSelectable(i,i.getEnabled());this._decorateListItem(o);return o;};
f.prototype._findMappedItem=function(o,g){for(var i=0,g=g||this.getItems(),h=g.length;i<h;i++){if(this.getListItem(g[i])===o){return g[i];}}return null;};
f.prototype.setSelectable=function(i,s){if(this.indexOfItem(i)<0){return;}i._bSelectable=s;var o=this.getListItem(i);if(o){o.setVisible(s);}var t=this._getTokenByItem(i);if(t){t.setVisible(s);}};
f.prototype.getSelectable=function(i){return i._bSelectable;};
f.prototype._fillList=function(g){if(!g){return null;}if(!this._oListItemEnterEventDelegate){this._oListItemEnterEventDelegate={onsapenter:function(j){if(j.srcControl.isSelected()){j.setMarked();}}};}for(var i=0,o,h=g.length;i<h;i++){o=this._mapItemToListItem(g[i]);o.removeEventDelegate(this._oListItemEnterEventDelegate);o.addDelegate(this._oListItemEnterEventDelegate,true,this,true);this.getList().addAggregation("items",o,true);if(this.isItemSelected(g[i])){this.getList().setSelectedItem(o,true);}}};
f.prototype._handleInputValidation=function(o,g){var v=o.target.value,i,V,h,r,u,s;var j=g?q(o.target).control(0):o.srcControl;i=this._getItemsStartingText(v,true);V=!!i.length;if(!V&&v!==""){u=g?this._sComposition:(this._sOldValue||"");j.updateDomValue(u);if(this._iOldCursorPos){q(j.getFocusDomRef()).cursorPos(this._iOldCursorPos);}this._showWrongValueVisualEffect();return;}h=this.getEnabledItems();r=this._sOldInput&&this._sOldInput.length>v.length;if(this.isPickerDialog()){s=this._getFilterSelectedButton();if(s!=null&&s.getPressed()){s.setPressed(false);}}if(r){h=this.getItems();}this.filterItems(h,v);if((!this.getValue()||!V)&&!this.bOpenedByKeyboardOrButton&&!this.isPickerDialog()){this.close();}else{this.open();}this._sOldInput=v;};
f.prototype.init=function(){C.prototype.init.apply(this,arguments);this.createList();this.bItemsUpdated=false;this._bListItemNavigationInvalidated=false;this._iInitialItemFocus=-1;this._bCheckBoxClicked=true;this._bPreventValueRemove=false;this.setPickerType(sap.ui.Device.system.phone?"Dialog":"Dropdown");this._oTokenizer=this._createTokenizer();this._aCustomerKeys=[];this._aInitiallySelectedItems=[];this._bCompositionStart=false;this._bCompositionEnd=false;this._sComposition="";this.attachBrowserEvent("compositionstart",function(){this._bCompositionStart=true;this._bCompositionEnd=false;},this);this.attachBrowserEvent("compositionend",function(o){this._bCompositionStart=false;this._bCompositionEnd=true;this._handleInputValidation(o,true);this._bCompositionEnd=false;this._sComposition=o.target.value;},this);};
f.prototype.clearSelection=function(){this.removeAllSelectedItems();};
f.prototype.addItem=function(i){this.addAggregation("items",i);if(i){i.attachEvent("_change",this.onItemChange,this);}if(this.getList()){this.getList().addItem(this._mapItemToListItem(i));}return this;};
f.prototype.insertItem=function(i,g){this.insertAggregation("items",i,g,true);if(i){i.attachEvent("_change",this.onItemChange,this);}if(this.getList()){this.getList().insertItem(this._mapItemToListItem(i),g);}return this;};
f.prototype.getEnabledItems=function(i){i=i||this.getItems();return i.filter(function(o){return o.getEnabled();});};
f.prototype.getItemByKey=function(k){return this.findItem("key",k);};
f.prototype.removeItem=function(i){i=this.removeAggregation("items",i);if(this.getList()){this.getList().removeItem(i&&this.getListItem(i));}this.removeSelection({item:i,id:i?i.getId():"",key:i?i.getKey():"",fireChangeEvent:false,suppressInvalidate:true,listItemUpdated:true});return i;};
f.prototype.isItemSelected=function(i){return this.getSelectedItems().indexOf(i)>-1;};
f.prototype.findItem=function(p,v){var m="get"+p.charAt(0).toUpperCase()+p.slice(1);for(var i=0,g=this.getItems();i<g.length;i++){if(g[i][m]()===v){return g[i];}}return null;};
f.prototype._clearTokenizer=function(){this._oTokenizer.destroyAggregation("tokens",true);};
f.prototype.getList=function(){return this._oList;};
f.prototype.exit=function(){a.prototype.exit.apply(this,arguments);if(this.getList()){this.getList().destroy();this._oList=null;}if(this._oTokenizer){this._oTokenizer.destroy();this._oTokenizer=null;}};
f.prototype.destroyItems=function(){this.destroyAggregation("items");if(this.getList()){this.getList().destroyItems();}this._oTokenizer.destroyTokens();return this;};
f.prototype.removeAllItems=function(){var i=this.removeAllAggregation("items");this.removeAllSelectedItems();if(this.getList()){this.getList().removeAllItems();}return i;};
f.prototype._getItemByListItem=function(o){return this._getItemBy(o,"ListItem");};
f.prototype._getItemByToken=function(t){return this._getItemBy(t,"Token");};
f.prototype._getItemBy=function(o,s){s=this.getRenderer().CSS_CLASS_COMBOBOXBASE+s;for(var i=0,g=this.getItems(),h=g.length;i<h;i++){if(g[i].data(s)===o){return g[i];}}return null;};
f.prototype.getListItem=function(i){return i?i.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"ListItem"):null;};
f.prototype.getAccessibilityInfo=function(){var t=this.getSelectedItems().map(function(o){return o.getText();}).join(" ");var i=a.prototype.getAccessibilityInfo.apply(this,arguments);i.type=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_MULTICOMBO");i.description=((i.description||"")+" "+t).trim();return i;};
return f;},true);
sap.ui.predefine('sap/m/MultiComboBoxRenderer',['jquery.sap.global','./ComboBoxBaseRenderer','sap/ui/core/Renderer','sap/ui/core/ValueStateSupport'],function(q,C,R,V){"use strict";var M=R.extend(sap.m.ComboBoxBaseRenderer);M.CSS_CLASS_MULTICOMBOBOX="sapMMultiComboBox";M.DOT_CSS_CLASS_MULTICOMBOBOX=".sapMMultiComboBox";
M.addOuterClasses=function(r,c){sap.m.ComboBoxBaseRenderer.addOuterClasses.apply(this,arguments);r.addClass(M.CSS_CLASS_MULTICOMBOBOX);if(c._hasTokens()){r.addClass("sapMMultiComboBoxHasToken");}};
M.addInnerClasses=function(r,c){C.addInnerClasses.apply(this,arguments);r.addClass(M.CSS_CLASS_MULTICOMBOBOX+"InputInner");};
M.addButtonClasses=function(r,c){C.addButtonClasses.apply(this,arguments);r.addClass(M.CSS_CLASS_MULTICOMBOBOX+"Arrow");};
M.openInputTag=function(r,c){r.write('<div class="sapMMultiComboBoxBorder"');r.writeAttribute("id",c.getId()+"-border");r.write(">");r.renderControl(c._oTokenizer);r.write("<div class=\"sapMMultiComboBoxInputContainer\">");C.openInputTag.call(this,r,c);};
M.closeInputTag=function(r,c){C.closeInputTag.call(this,r,c);r.write("</div>");r.write("</div>");};
return M;},true);
sap.ui.predefine('sap/m/MultiInput',['jquery.sap.global','./Input','./Tokenizer','./Token','./library','sap/ui/core/EnabledPropagator','sap/ui/Device','sap/ui/core/InvisibleText'],function(q,I,T,a,l,E,D,b){"use strict";
var M=I.extend("sap.m.MultiInput",{metadata:{library:"sap.m",properties:{enableMultiLineMode:{type:"boolean",group:"Behavior",defaultValue:false},maxTokens:{type:"int",group:"Behavior"}},aggregations:{tokens:{type:"sap.m.Token",multiple:true,singularName:"token"},tokenizer:{type:"sap.m.Tokenizer",multiple:false,visibility:"hidden"},_tokensInfo:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"}},events:{tokenChange:{parameters:{type:{type:"string"},token:{type:"sap.m.Token"},tokens:{type:"sap.m.Token[]"},addedTokens:{type:"sap.m.Token[]"},removedTokens:{type:"sap.m.Token[]"}}},tokenUpdate:{allowPreventDefault:true,parameters:{type:{type:"string"},addedTokens:{type:"sap.m.Token[]"},removedTokens:{type:"sap.m.Token[]"}}}}}});
E.apply(M.prototype,[true]);var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");
M.prototype.init=function(){I.prototype.init.call(this);this._bIsValidating=false;this._tokenizer=new T();this.setAggregation("tokenizer",this._tokenizer);this._tokenizer.attachTokenChange(this._onTokenChange,this);this._tokenizer.attachTokenUpdate(this._onTokenUpdate,this);this.setShowValueHelp(true);this.setShowSuggestion(true);this.attachSuggestionItemSelected(this._onSuggestionItemSelected,this);this.attachLiveChange(this._onLiveChange,this);this.attachValueHelpRequest(function(){this._bValueHelpOpen=true;},this);if(sap.ui.getCore().getConfiguration().getAccessibility()){var A=new b({text:r.getText("MULTIINPUT_ARIA_CONTAIN_TOKEN")});this.setAggregation("_tokensInfo",A);}};
M.prototype._onTokenChange=function(c){var t=this.getTokens(),L=t.length;this.fireTokenChange(c.getParameters());this.invalidate();if(this._bUseDialog&&this._tokenizer.getParent()instanceof sap.m.Dialog){this._showAllTokens();return;}var f=q.sap.containsOrEquals(this.getDomRef(),document.activeElement);if(c.getParameter("type")==="tokensChanged"&&c.getParameter("removedTokens").length>0&&f){this.focus();}if(c.getParameter("type")==="added"&&L>1&&this.getEditable()&&this._isMultiLineMode&&!this.$("border").hasClass("sapMMultiInputMultiModeBorder")){this._showIndicator();}if(c.getParameter("type")==="removed"&&this._isMultiLineMode){if(L<2){this._removeIndicator();}}};
M.prototype._onTokenUpdate=function(c){var e=this.fireTokenUpdate(c.getParameters());if(!e){c.preventDefault();}else{this.invalidate();}};
M.prototype._onSuggestionItemSelected=function(e){var i=null,t=null,c=this,o=this._tokenizer.getTokens().length;if(this.getMaxTokens()&&o>=this.getMaxTokens()||this._bValueHelpOpen){return;}if(this._hasTabularSuggestions()){i=e.getParameter("selectedRow");}else{i=e.getParameter("selectedItem");if(i){t=new a({text:i.getText(),key:i.getKey()});}}if(i){var d=this.getValue();this._tokenizer._addValidateToken({text:d,token:t,suggestionObject:i,validationCallback:function(v){if(v){c.setValue("");}}});}if(this._bUseDialog&&this._tokenizer.getParent()instanceof sap.m.Dialog){var n=this._tokenizer.getTokens().length;if(o<n){this.setValue("");}if(this._tokenizer.getVisible()===false){this._tokenizer.setVisible(true);}if(this._oList instanceof sap.m.Table){this._oList.addStyleClass("sapMInputSuggestionTableHidden");}else{this._oList.destroyItems();}var s=this._oSuggestionPopup.getScrollDelegate();if(s){s.scrollTo(0,0,0);}this._oPopupInput.focus();}};
M.prototype._onLiveChange=function(e){this._tokenizer._removeSelectedTokens();if(this._bUseDialog&&this._isMultiLineMode){var v=e.getParameter("newValue");if(this._oSuggestionPopup&&this._oSuggestionPopup.getContent().length>1&&v.length>0){this._tokenizer.setVisible(false);}else{this._tokenizer.setVisible(true);}}};
M.prototype._showIndicator=function(){var t=this.getTokens(),i=t.length;this._tokenizer.setVisible(true);if(i>1){if(this.$().find(".sapMMultiInputIndicator").length!==0){this._removeIndicator();}var s="<span class=\"sapMMultiInputIndicator\">"+r.getText("MULTIINPUT_SHOW_MORE_TOKENS",i-1)+"</span>";this.$().find(".sapMMultiInputInputContainer").prepend(s);this._setValueInvisible();this._bShowIndicator=true;}};
M.prototype._setValueInvisible=function(){this.$("inner").css("opacity","0");};
M.prototype._setValueVisible=function(){this.$("inner").css("opacity","1");};
M.prototype._showAllTokens=function(){this._tokenizer.setVisible(true);this._removeIndicator();};
M.prototype._removeIndicator=function(){this.$().find(".sapMMultiInputIndicator").remove();this._bShowIndicator=false;};
M.prototype.setEnableMultiLineMode=function(m){this.setProperty("enableMultiLineMode",m,true);if(m){this.$().addClass("sapMMultiInputMultiLine");}else{this.$().removeClass("sapMMultiInputMultiLine");}this.closeMultiLine();var t=this;if(this._bUseDialog){m=true;}if(m){if(this.getEditable()){this._showIndicator();}this._isMultiLineMode=true;if(this.getDomRef()){setTimeout(function(){t._tokenizer.scrollToEnd();},0);}}else{this._isMultiLineMode=false;this._showAllTokens();this._setValueVisible();if(this.getDomRef()){setTimeout(function(){t._tokenizer.scrollToEnd();},0);}}return this;};
M.prototype._openMultiLineOnPhone=function(){var t=this;if(!this.getEditable()){return;}this._oSuggestionPopup.open();this._oSuggestionPopup.insertContent(this._tokenizer,0);this._tokenizer.setReverseTokens(true);var v=this._oPopupInput.getValue();if(this._oSuggestionPopup&&this._oSuggestionPopup.getContent().length>1&&v.length>0){this._tokenizer.setVisible(false);}else{this._tokenizer.setVisible(true);}this._tokenizer._oScroller.setHorizontal(false);this._tokenizer.addStyleClass("sapMTokenizerMultiLine");if(this._oSuggestionTable.getItems().length===0){this._oPopupInput.onsapenter=function(e){t._validateCurrentText();t._setValueInvisible();};}};
M.prototype.onmousedown=function(e){if(e.target==this.getDomRef('border')){e.preventDefault();e.stopPropagation();}};
M.prototype._openMultiLineOnDesktop=function(){var t=this;this._setValueVisible();this.$("border").addClass("sapMMultiInputMultiModeBorder");if(this._$input){this._$input.parents('.sapMMultiInputBorder').addClass("sapMMultiInputMultiModeInputContainer");}this.$().find(".sapMInputValHelp").attr("tabindex","-1");var p=this.getParent();this._originalOverflow=null;if(p&&p.$&&p.$().css("overflow")==="hidden"){this._originalOverflow=p.$().css("overflow");p.$().css("overflow","visible");}var P;if(this.$().closest('.sapUiVlt').length!==0){P=this.$().closest('.sapUiVlt');}else if(this.$().parent('[class*="sapUiRespGridSpan"]').length!==0){P=this.$().parent('[class*="sapUiRespGridSpan"]');}else if(this.$().parents(".sapUiRFLContainer").length!==0){P=this.$().parents(".sapUiRFLContainer");}if(P&&P.length>0&&P.css("overflow")==="hidden"){P.css("overflow","visible");}t._showAllTokens();t._tokenizer.scrollToStart();};
M.prototype.openMultiLine=function(){var t=this.getTokens();if(!this.getEditable()){return;}if(this.getEnableMultiLineMode()&&t.length>0&&!D.system.phone){this._openMultiLineOnDesktop();}};
M.prototype.closeMultiLine=function(){if(!this.getEditable()){return;}if(this._bUseDialog){this._oSuggestionPopup.close();this._tokenizer.setVisible(true);}else{this.$("border").removeClass("sapMMultiInputMultiModeBorder");if(this._$input){this._$input.parents('.sapMMultiInputBorder').removeClass("sapMMultiInputMultiModeInputContainer");}this.$().find(".sapMInputValHelp").removeAttr("tabindex");if(this._originalOverflow){var p=this.getParent();p.$().css("overflow",this._originalOverflow);}}if(this.getTokens().length>1&&this._isMultiLineMode){this._showIndicator();}};
M.prototype.getScrollDelegate=function(){return this._tokenizer._oScroller;};
M.prototype.onBeforeRendering=function(){var t=this.getAggregation("tokenizer"),i=this.getTokens().length,o,m="";if(t){t.toggleStyleClass("sapMTokenizerEmpty",t.getTokens().length===0);}if(sap.ui.getCore().getConfiguration().getAccessibility()){o=this.getAggregation("_tokensInfo");switch(i){case 0:m=r.getText("MULTIINPUT_ARIA_CONTAIN_TOKEN");break;case 1:m=r.getText("MULTIINPUT_ARIA_CONTAIN_ONE_TOKEN");break;default:m=r.getText("MULTIINPUT_ARIA_CONTAIN_SEVERAL_TOKENS",i);break;}o.setText(m);}I.prototype.onBeforeRendering.apply(this,arguments);};
M.prototype.onAfterRendering=function(){this._tokenizer.scrollToEnd();I.prototype.onAfterRendering.apply(this,arguments);};
M.prototype.addValidator=function(v){this._tokenizer.addValidator(v);};
M.prototype.removeValidator=function(v){this._tokenizer.removeValidator(v);};
M.prototype.removeAllValidators=function(){this._tokenizer.removeAllValidators();};
M.prototype.onsapnext=function(e){if(e.isMarked()){return;}var f=q(document.activeElement).control()[0];if(!f){return;}if(this._tokenizer===f||this._tokenizer.$().find(f.$()).length>0){this._scrollAndFocus();}};
M.prototype.onsapbackspace=function(e){if(this.getCursorPosition()>0||!this.getEditable()||this.getValue().length>0){return;}T.prototype.onsapbackspace.apply(this._tokenizer,arguments);e.preventDefault();e.stopPropagation();};
M.prototype.onsapdelete=function(e){if(!this.getEditable()){return;}if(this.getValue()&&!this._completeTextIsSelected()){return;}T.prototype.onsapdelete.apply(this._tokenizer,arguments);};
M.prototype.onkeydown=function(e){if(e.which===q.sap.KeyCodes.TAB){this._tokenizer._changeAllTokensSelection(false);}if((e.ctrlKey||e.metaKey)&&e.which===q.sap.KeyCodes.A){if(this._tokenizer.getTokens().length>0){this._tokenizer.focus();this._tokenizer._changeAllTokensSelection(true);e.preventDefault();}}if((e.ctrlKey||e.metaKey)&&(e.which===q.sap.KeyCodes.C||e.which===q.sap.KeyCodes.INSERT)){this._tokenizer._copy();}if(((e.ctrlKey||e.metaKey)&&e.which===q.sap.KeyCodes.X)||(e.shiftKey&&e.which===q.sap.KeyCodes.DELETE)){if(this.getEditable()){this._tokenizer._cut();}else{this._tokenizer._copy();}}};
M.prototype.onpaste=function(e){var o,i,v=[],A=[];if(this.getValueHelpOnly()){return;}if(window.clipboardData){o=window.clipboardData.getData("Text");}else{o=e.originalEvent.clipboardData.getData('text/plain');}var s=this._tokenizer._parseString(o);setTimeout(function(){if(s){if(this.fireEvent("_validateOnPaste",{texts:s},true)){var c="";for(i=0;i<s.length;i++){if(s[i]){var t=this._convertTextToToken(s[i]);if(t){v.push(t);}else{c=s[i];}}}this.updateDomValue(c);for(i=0;i<v.length;i++){if(this._tokenizer._addUniqueToken(v[i])){A.push(v[i]);}}if(A.length>0){this.fireTokenUpdate({addedTokens:A,removedTokens:[],type:T.TokenUpdateType.Added});}}if(A.length){this.cancelPendingSuggest();}}}.bind(this),0);};
M.prototype._convertTextToToken=function(t){var c=null,i=null,d=null,o=this._tokenizer.getTokens().length;if(!this.getEditable()){return null;}t=t.trim();if(!t){return null;}if(this._getIsSuggestionPopupOpen()){if(this._hasTabularSuggestions()){i=this._oSuggestionTable._oSelectedItem;}else{i=this._getSuggestionItem(t);}}if(i&&i.getText&&i.getKey){d=new a({text:i.getText(),key:i.getKey()});}var e=this;c=this._tokenizer._validateToken({text:t,token:d,suggestionObject:i,validationCallback:function(v){e._bIsValidating=false;if(v){e.setValue("");if(e._bUseDialog&&e._isMultiLineMode&&e._oSuggestionTable.getItems().length===0){var n=e._tokenizer.getTokens().length;if(o<n){e._oPopupInput.setValue("");}if(e._tokenizer.getVisible()===false){e._tokenizer.setVisible(true);}e._setAllTokenVisible();}}}});return c;};
M.prototype.onsapprevious=function(e){if(this._getIsSuggestionPopupOpen()){return;}if(this.getCursorPosition()===0){if(e.srcControl===this){T.prototype.onsapprevious.apply(this._tokenizer,arguments);e.preventDefault();}}};
M.prototype._scrollAndFocus=function(){this._tokenizer.scrollToEnd();this.$().find("input").focus();};
M.prototype.onsaphome=function(e){if(this._tokenizer._checkFocus()){T.prototype.onsaphome.apply(this._tokenizer,arguments);}};
M.prototype.onsapend=function(e){if(this._tokenizer._checkFocus()){T.prototype.onsapend.apply(this._tokenizer,arguments);e.preventDefault();}};
M.prototype.onsapenter=function(e){var v=true;if(this._oSuggestionPopup&&this._oSuggestionPopup.isOpen()){if(this._hasTabularSuggestions()){v=!this._oSuggestionTable.getSelectedItem();}else{v=!this._oList.getSelectedItem();}}if(v){this._validateCurrentText();}if(I.prototype.onsapenter){I.prototype.onsapenter.apply(this,arguments);}this.focus();};
M.prototype._checkFocus=function(){return this.getDomRef()&&q.sap.containsOrEquals(this.getDomRef(),document.activeElement);};
M.prototype.onsapfocusleave=function(e){var p=this._oSuggestionPopup,n=false,N=false,c=this._checkFocus(),R;if(p instanceof sap.m.Popover){if(e.relatedControlId){R=sap.ui.getCore().byId(e.relatedControlId).getFocusDomRef();n=q.sap.containsOrEquals(p.getFocusDomRef(),R);N=q.sap.containsOrEquals(this._tokenizer.getFocusDomRef(),R);}}if(!N&&!n&&!this._isMultiLineMode){this._tokenizer.scrollToEnd();}I.prototype.onsapfocusleave.apply(this,arguments);if(this._bIsValidating||this._bValueHelpOpen){return;}if(!this._bUseDialog&&!n&&e.relatedControlId!==this.getId()&&e.relatedControlId!==this._tokenizer.getId()&&!N&&!(this._isMultiLineMode&&this._bShowIndicator)){this._validateCurrentText(true);}if(!this._bUseDialog&&this._isMultiLineMode&&this.getDomRef("inner").style.opacity=="1"&&this.getEditable()){if(c||n){return;}this.closeMultiLine();this._showIndicator();}T.prototype.onsapfocusleave.apply(this._tokenizer,arguments);if(!this._bUseDialog&&this._isMultiLineMode&&this._bShowIndicator){var $=this.$().find(".sapMMultiInputBorder");$.scrollTop(0);}};
M.prototype._onDialogClose=function(){this._validateCurrentText();this._tokenizer._oScroller.setHorizontal(true);this._tokenizer.removeStyleClass("sapMTokenizerMultiLine");this.setAggregation("tokenizer",this._tokenizer);this._tokenizer.setReverseTokens(false);this._tokenizer.invalidate();};
M.prototype.ontap=function(e){if(document.activeElement===this._$input[0]||document.activeElement===this._tokenizer.getDomRef()){this._tokenizer.selectAllTokens(false);}if(e&&e.isMarked("tokenDeletePress")){return;}I.prototype.ontap.apply(this,arguments);};
M.prototype._onclick=function(e){if(this._bUseDialog){this._openMultiLineOnPhone();}};
M.prototype.onfocusin=function(e){this._bValueHelpOpen=false;if(this.getEditable()&&this.getEnableMultiLineMode()&&(!e.target.classList.contains("sapMInputValHelp")&&!e.target.classList.contains("sapMInputValHelpInner"))){this.openMultiLine();}if(e.target===this.getFocusDomRef()){I.prototype.onfocusin.apply(this,arguments);}};
M.prototype.onsapescape=function(e){this._tokenizer.selectAllTokens(false);this.selectText(0,0);I.prototype.onsapescape.apply(this,arguments);};
M.prototype._validateCurrentText=function(e){var o=this._tokenizer.getTokens().length;var t=this.getValue();if(!t||!this.getEditable()){return;}t=t.trim();if(!t){return;}var i=null;if(e||this._getIsSuggestionPopupOpen()){if(this._hasTabularSuggestions()){i=this._oSuggestionTable._oSelectedItem;}else{i=this._getSuggestionItem(t,e);}}var c=null;if(i&&i.getText&&i.getKey){c=new a({text:i.getText(),key:i.getKey()});}var d=this;if(!this.getMaxTokens()||this.getTokens().length<this.getMaxTokens()){this._bIsValidating=true;this._tokenizer._addValidateToken({text:t,token:c,suggestionObject:i,validationCallback:function(v){d._bIsValidating=false;if(v){d.setValue("");if(d._bUseDialog&&d._isMultiLineMode&&d._oSuggestionTable.getItems().length===0){var n=d._tokenizer.getTokens().length;if(o<n){d._oPopupInput.setValue("");}if(d._tokenizer.getVisible()===false){d._tokenizer.setVisible(true);}}}}});}};
M.prototype.getCursorPosition=function(){return this._$input.cursorPos();};
M.prototype._completeTextIsSelected=function(){var i=this._$input[0];if(i.selectionStart!==0){return false;}if(i.selectionEnd!==this.getValue().length){return false;}return true;};
M.prototype._getIsSuggestionPopupOpen=function(){return this._oSuggestionPopup&&this._oSuggestionPopup.isOpen();};
M.prototype.setEditable=function(e){e=this.validateProperty("editable",e);if(e===this.getEditable()){return this;}if(e&&(this.getEnableMultiLineMode()||this._bUseDialog)&&this.getTokens().length>1){this._bShowIndicator=true;}else{this._bShowIndicator=false;}if(I.prototype.setEditable){I.prototype.setEditable.apply(this,arguments);}this._tokenizer.setEditable(e);return this;};
M.prototype._findItem=function(t,c,e,g){if(!t){return;}if(!(c&&c.length)){return;}t=t.toLowerCase();var d=c.length;for(var i=0;i<d;i++){var f=c[i];var h=g(f);if(!h){continue;}h=h.toLowerCase();if(h===t){return f;}if(!e&&h.indexOf(t)===0){return f;}}};
M.prototype._getSuggestionItem=function(t,e){var c=null;var d=null;if(this._hasTabularSuggestions()){c=this.getSuggestionRows();d=this._findItem(t,c,e,function(R){var f=R.getCells();var g=null;if(f){var i;for(i=0;i<f.length;i++){if(f[i].getText){g=f[i].getText();break;}}}return g;});}else{c=this.getSuggestionItems();d=this._findItem(t,c,e,function(d){return d.getText();});}return d;};
M.prototype.addToken=function(t){this._tokenizer.addToken(t);return this;};
M.prototype.removeToken=function(t){return this._tokenizer.removeToken(t);};
M.prototype.removeAllTokens=function(){return this._tokenizer.removeAllTokens();};
M.prototype.getTokens=function(){return this._tokenizer.getTokens();};
M.prototype.insertToken=function(t,i){this._tokenizer.insertToken(t,i);return this;};
M.prototype.indexOfToken=function(t){return this._tokenizer.indexOfToken(t);};
M.prototype.destroyTokens=function(){this._tokenizer.destroyTokens();return this;};
M.prototype.updateTokens=function(){this.destroyTokens();this.updateAggregation("tokens");};
M.prototype.getAggregation=function(A,d){var t;if(A==="tokens"){t=this.getTokens();if(t.length===0){t=d||null;}return t;}else{return I.prototype.getAggregation.apply(this,arguments);}};
M.prototype.clone=function(){var c,t;this.detachSuggestionItemSelected(this._onSuggestionItemSelected,this);this.detachLiveChange(this._onLiveChange,this);this._tokenizer.detachTokenChange(this._onTokenChange,this);this._tokenizer.detachTokenUpdate(this._onTokenUpdate,this);c=I.prototype.clone.apply(this,arguments);t=this._tokenizer.clone();c._tokenizer=t;c.setAggregation("tokenizer",t,true);this._tokenizer.attachTokenChange(this._onTokenChange,this);this._tokenizer.attachTokenUpdate(this._onTokenUpdate,this);c._tokenizer.attachTokenChange(c._onTokenChange,c);c._tokenizer.attachTokenUpdate(c._onTokenUpdate,c);this.attachSuggestionItemSelected(this._onSuggestionItemSelected,this);this.attachLiveChange(this._onLiveChange,this);return c;};
M.prototype.getPopupAnchorDomRef=function(){return this.getDomRef("border");};
M.prototype.setTokens=function(t){var v,V=[],i;if(Array.isArray(t)){for(i=0;i<t.length;i++){v=this.validateAggregation("tokens",t[i],true);V.push(v);}this._tokenizer.setTokens(V);}else{throw new Error("\""+t+"\" is of type "+typeof t+", expected array for aggregation tokens of "+this);}return this;};
M.TokenChangeType={Added:"added",Removed:"removed",RemovedAll:"removedAll",TokensChanged:"tokensChanged"};M.WaitForAsyncValidation="sap.m.Tokenizer.WaitForAsyncValidation";M.prototype.getDomRefForValueStateMessage=M.prototype.getPopupAnchorDomRef;
M.prototype.getAccessibilityInfo=function(){var t=this.getTokens().map(function(o){return o.getText();}).join(" ");var i=I.prototype.getAccessibilityInfo.apply(this,arguments);i.type=r.getText("ACC_CTR_TYPE_MULTIINPUT");i.description=((i.description||"")+" "+t).trim();return i;};
return M;},true);
sap.ui.predefine('sap/m/MultiInputRenderer',['jquery.sap.global','./InputRenderer','sap/ui/core/Renderer'],function(q,I,R){"use strict";var M=R.extend(I);
M.addOuterClasses=function(r,c){I.addOuterClasses.call(this,r,c);r.addClass("sapMMultiInput");if(c.getEnableMultiLineMode()){r.addClass("sapMMultiInputMultiLine");}if(c.getTokens().length>0){r.addClass("sapMMultiInputNoPlaceholder");}};
M.getAriaDescribedBy=function(c){var a=I.getAriaDescribedBy.apply(this,arguments),i=c.getAggregation("_tokensInfo").getId();if(a){a=a+" "+i;}else{a=i;}return a;};
M.renderAriaDescribedBy=function(r,c){I.renderAriaDescribedBy.call(this,r,c);r.renderControl(c.getAggregation("_tokensInfo"));};
M.openInputTag=function(r,c){r.write('<div id="'+c.getId()+'-border"');r.addClass('sapMMultiInputBorder');if(c.getTokens().length>0){r.addClass("sapMMultiInputNarrowBorder");}if(c.getEnableMultiLineMode()||c._bUseDialog){c._isMultiLineMode=true;if(c.getEditable()){c._showIndicator();}else{c._showAllTokens();}}r.writeClasses();r.write('>');M._renderTokens(r,c);M._renderInput(r,c);};
M._renderTokens=function(r,c){r.renderControl(c.getAggregation("tokenizer"));};
M._renderInput=function(r,c){r.write("<div class=\"sapMMultiInputInputContainer\">");if(c._isMultiLineMode&&c._bShowIndicator===true){var t=c.getTokens().length;r.write("<span class=\"sapMMultiInputIndicator\">");if(t>1){var m=sap.ui.getCore().getLibraryResourceBundle("sap.m");r.write(m.getText("MULTIINPUT_SHOW_MORE_TOKENS",t-1));}r.write("</span>");}I.openInputTag.call(this,r,c);};
M.writeDecorations=function(r,c){};
M.closeInputTag=function(r,c){I.closeInputTag.call(this,r,c);r.write("</div>");I.writeValueHelpIcon(r,c);r.write("</div>");r.write("<div class=\"sapMMultiInputShadowDiv\"></div>");};
M.addInnerStyles=function(r,c){if(c._isMultiLineMode&&c._bShowIndicator===true&&c.getTokens().length>1){r.addStyle("opacity",0);}};
M.addControlWidth=function(r,c){if(!c.getWidth()||c.getWidth()==="auto"){r.addStyle("width","100%");}else{I.addControlWidth.call(this,r,c);}};
return M;},true);
sap.ui.predefine('sap/m/NavContainer',['jquery.sap.global','./library','sap/ui/core/Control'],function(q,a,C){"use strict";
var N=C.extend("sap.m.NavContainer",{metadata:{library:"sap.m",properties:{autoFocus:{type:"boolean",group:"Behavior",defaultValue:true},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},visible:{type:"boolean",group:"Appearance",defaultValue:true},defaultTransitionName:{type:"string",group:"Appearance",defaultValue:"slide"}},defaultAggregation:"pages",aggregations:{pages:{type:"sap.ui.core.Control",multiple:true,singularName:"page"}},associations:{initialPage:{type:"sap.ui.core.Control",multiple:false}},events:{navigate:{allowPreventDefault:true,parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},afterNavigate:{parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}}}}});
var u=sap.ui.getCore().getConfiguration().getAnimation(),g=function(d){return u?d:0;};var I=function(p){var P=p&&p.getParent();return P&&P.isActive();};
N.prototype.init=function(){this._pageStack=[];this._aQueue=[];this._mVisitedPages={};this._mFocusObject={};this._iTransitionsCompleted=0;this._bNeverRendered=true;this._bNavigating=false;this._bRenderingInProgress=false;};
N.prototype.exit=function(){this._mFocusObject=null;};
N.prototype.onBeforeRendering=function(){var p=this.getCurrentPage();if(this._bNeverRendered&&p){var b=p.getId();if(!this._mVisitedPages[b]){this._mVisitedPages[b]=true;var n={from:null,fromId:null,to:p,toId:b,firstTime:true,isTo:false,isBack:false,isBackToPage:false,isBackToTop:false,direction:"initial"};var e=q.Event("BeforeFirstShow",n);e.srcControl=this;e.data=this._oToDataBeforeRendering||{};e.backData={};p._handleEvent(e);e=q.Event("BeforeShow",n);e.srcControl=this;e.data=this._oToDataBeforeRendering||{};e.backData={};p._handleEvent(e);}}};
N.prototype.onAfterRendering=function(){var p=this.getCurrentPage(),f,n,b,e;if(this._bNeverRendered&&p){this._bNeverRendered=false;delete this._bNeverRendered;b=p.getId();if(!this._isInsideAPopup()&&this.getAutoFocus()){f=N._applyAutoFocusTo(b);if(f){this._mFocusObject[b]=f;}}n={from:null,fromId:null,to:p,toId:b,firstTime:true,isTo:false,isBack:false,isBackToTop:false,isBackToPage:false,direction:"initial"};e=q.Event("AfterShow",n);e.srcControl=this;e.data=this._oToDataBeforeRendering||{};e.backData={};p._handleEvent(e);}};
N.prototype._getActualInitialPage=function(){var p=this.getInitialPage();if(p){var b=sap.ui.getCore().byId(p);if(b){return b;}else{q.sap.log.error("NavContainer: control with ID '"+p+"' was set as 'initialPage' but was not found as a DIRECT child of this NavContainer (number of current children: "+this.getPages().length+").");}}var c=this.getPages();return(c.length>0?c[0]:null);};
N.prototype.getPage=function(p){var P=this.getPages();for(var i=0;i<P.length;i++){if(P[i]&&(P[i].getId()==p)){return P[i];}}return null;};
N.prototype._ensurePageStackInitialized=function(d){if(this._pageStack.length===0){var p=this._getActualInitialPage();if(p){this._pageStack.push({id:p.getId(),isInitial:true,data:d||{}});}}return this._pageStack;};
N.prototype.getCurrentPage=function(){var s=this._ensurePageStackInitialized();if(s.length>=1){return this.getPage(s[s.length-1].id);}else{q.sap.log.warning(this+": page stack is empty but should have been initialized - application failed to provide a page to display");return undefined;}};
N.prototype.getPreviousPage=function(){var s=this._ensurePageStackInitialized();if(s.length>1){return this.getPage(s[s.length-2].id);}else if(s.length==1){return undefined;}else{q.sap.log.warning(this+": page stack is empty but should have been initialized - application failed to provide a page to display");}};
N.prototype.currentPageIsTopPage=function(){var s=this._ensurePageStackInitialized();return(s.length===1);};
N.prototype.insertPreviousPage=function(p,t,d){var s=this._ensurePageStackInitialized();if(this._pageStack.length>0){var i=s.length-1;var b={id:p,transition:t,data:d};if(i===0){b.isInitial=true;delete s[s.length-1].isInitial;}s.splice(i,0,b);}else{q.sap.log.warning(this+": insertPreviousPage called with empty page stack; ignoring");}return this;};
N._applyAutoFocusTo=function(i){var f=q.sap.byId(i).firstFocusableDomRef();if(f){q.sap.focus(f);}return f;};
N.prototype._applyAutoFocus=function(n){var p=n.toId,d,A=this.getAutoFocus(),b=n.isBack||n.isBackToPage||n.isBackToTop;if(!n.bFocusInsideFromPage){return;}if(b){d=this._mFocusObject!=null?this._mFocusObject[p]:null;if(d){q.sap.focus(d);}else if(A){N._applyAutoFocusTo(p);}}else if(n.isTo&&A){N._applyAutoFocusTo(p);}};
N.prototype._afterTransitionCallback=function(n,d,b){var e=q.Event("AfterShow",n);e.data=d||{};e.backData=b||{};e.srcControl=this;n.to._handleEvent(e);e=q.Event("AfterHide",n);e.srcControl=this;n.from._handleEvent(e);this._iTransitionsCompleted++;this._bNavigating=false;this._applyAutoFocus(n);this.fireAfterNavigate(n);q.sap.log.info(this+": _afterTransitionCallback called, to: "+n.toId);if(n.to.hasStyleClass("sapMNavItemHidden")){q.sap.log.warning(this.toString()+": target page '"+n.toId+"' still has CSS class 'sapMNavItemHidden' after transition. This should not be the case, please check the preceding log statements.");n.to.removeStyleClass("sapMNavItemHidden");}this._dequeueNavigation();};
N.prototype._dequeueNavigation=function(){var n=this._aQueue.shift();if(typeof n==="function"){n();}};
N.prototype._isInPageStack=function(p){return this._pageStack.some(function(P){return P.id===p;});};
N.prototype._safeBackToPage=function(p,t,d,T){if(!this.getPage(p)){return this;}if(this._isInPageStack(p)){return this.backToPage(p,d,T);}else{return this.to(p,t,d,T);}};
N.prototype._isFocusInControl=function(c){return q(document.activeElement).closest(c.$()).length>0;};
N.prototype.to=function(p,t,d,T,f){if(p instanceof C){p=p.getId();}if(typeof(t)!=="string"){T=d;d=t;}t=t||this.getDefaultTransitionName();T=T||{};d=d||{};var F={id:p,transition:t,data:d};this._ensurePageStackInitialized(d);if(this._bNavigating){q.sap.log.info(this.toString()+": Cannot navigate to page "+p+" because another navigation is already in progress. - navigation will be executed after the previous one");this._aQueue.push(q.proxy(function(){this.to(p,t,d,T,true);},this));return this;}if(this._bNeverRendered){this._oToDataBeforeRendering=d;}var o=this.getCurrentPage();if(o&&(o.getId()===p)){q.sap.log.warning(this.toString()+": Cannot navigate to page "+p+" because this is the current page.");if(f){this._dequeueNavigation();}if(this._pageStack.length===1){this._pageStack[0].transition=F.transition;}return this;}var b=this.getPage(p);if(b){if(!o){q.sap.log.warning("Navigation triggered to page with ID '"+p+"', but the current page is not known/aggregated by "+this);return this;}var n={from:o,fromId:o.getId(),to:b,toId:p,firstTime:!this._mVisitedPages[p],isTo:true,isBack:false,isBackToTop:false,isBackToPage:false,direction:"to",bFocusInsideFromPage:this._isFocusInControl(o)};if(n.bFocusInsideFromPage){this._mFocusObject[o.getId()]=document.activeElement;}var c=this.fireNavigate(n);if(c){sap.m.closeKeyboard();var e=q.Event("BeforeHide",n);e.srcControl=this;o._handleEvent(e);if(!this._mVisitedPages[p]){e=q.Event("BeforeFirstShow",n);e.srcControl=this;e.data=d||{};e.backData={};b._handleEvent(e);}e=q.Event("BeforeShow",n);e.srcControl=this;e.data=d||{};e.backData={};b._handleEvent(e);this._pageStack.push(F);q.sap.log.info(this.toString()+": navigating to page '"+p+"': "+b.toString());this._mVisitedPages[p]=true;if(!this.getDomRef()){q.sap.log.info("'Hidden' 'to' navigation in not-rendered NavContainer "+this.toString());if(this._bRenderingInProgress){q.sap.delayedCall(0,this,this.invalidate);}return this;}var h;if(!(h=b.getDomRef())||h.parentNode!=this.getDomRef()||sap.ui.core.RenderManager.isPreservedContent(h)){b.addStyleClass("sapMNavItemRendering");q.sap.log.debug("Rendering 'to' page '"+b.toString()+"' for 'to' navigation");var r=sap.ui.getCore().createRenderManager();r.render(b,this.getDomRef());r.destroy();b.addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemRendering");}var i=N.transitions[t]||N.transitions["slide"];var j=this._iTransitionsCompleted;var k=this;window.setTimeout(function(){if(k&&(k._iTransitionsCompleted<j+1)){q.sap.log.warning("Transition '"+t+"' 'to' was triggered five seconds ago, but has not yet invoked the end-of-transition callback.");}},g(5000));this._bNavigating=true;i.to.call(this,o,b,q.proxy(function(){this._afterTransitionCallback(n,d);},this),T);}else{q.sap.log.info("Navigation to page with ID '"+p+"' has been aborted by the application");}}else{q.sap.log.warning("Navigation triggered to page with ID '"+p+"', but this page is not known/aggregated by "+this);}return this;};
N.prototype.back=function(b,t){this._backTo("back",b,t);return this;};
N.prototype.backToPage=function(p,b,t){this._backTo("backToPage",b,t,p);return this;};
N.prototype.backToTop=function(b,t){this._backTo("backToTop",b,t);return this;};
N.prototype._backTo=function(t,b,T,r){if(this._bNavigating){q.sap.log.warning(this.toString()+": Cannot navigate back because another navigation is already in progress. - navigation will be executed after the previous one");this._aQueue.push(q.proxy(function(){this._backTo(t,b,T,r);},this));return this;}if(this._pageStack.length<=1){if(this._pageStack.length===1&&!this._pageStack[0].isInitial){throw new Error("Initial page not found on the stack. How did this happen?");}return this;}else{if(r instanceof C){r=r.getId();}var f=this._pageStack[this._pageStack.length-1];var c=f.transition;var F=this.getPage(f.id);var o;var d;if(t==="backToTop"){o=this._getActualInitialPage();d=null;}else if(t==="backToPage"){var i=this._findClosestPreviousPageInfo(r);if(!i){q.sap.log.error(this.toString()+": Cannot navigate backToPage('"+r+"') because target page was not found among the previous pages.");return this;}o=sap.ui.getCore().byId(i.id);if(!o){q.sap.log.error(this.toString()+": Cannot navigate backToPage('"+r+"') because target page does not exist anymore.");return this;}d=i.data;}else{o=this.getPreviousPage();d=this._pageStack[this._pageStack.length-2].data;}if(!o){q.sap.log.error("NavContainer back navigation: target page is not defined or not aggregated by this NavContainer. Aborting navigation.");return;}var e=o.getId();b=b||{};T=T||{};var n={from:F,fromId:F.getId(),to:o,toId:e,firstTime:!this._mVisitedPages[e],isTo:false,isBack:(t==="back"),isBackToPage:(t==="backToPage"),isBackToTop:(t==="backToTop"),direction:t,bFocusInsideFromPage:this._isFocusInControl(F)};var h=this.fireNavigate(n);if(h){sap.m.closeKeyboard();var E=q.Event("BeforeHide",n);E.srcControl=this;F._handleEvent(E);if(!this._mVisitedPages[e]){E=q.Event("BeforeFirstShow",n);E.srcControl=this;E.backData=b||{};E.data={};o._handleEvent(E);}E=q.Event("BeforeShow",n);E.srcControl=this;E.backData=b||{};E.data=d||{};o._handleEvent(E);this._pageStack.pop();q.sap.log.info(this.toString()+": navigating back to page "+o.toString());this._mVisitedPages[e]=true;if(t==="backToTop"){this._pageStack=[];q.sap.log.info(this.toString()+": navigating back to top");this.getCurrentPage();}else if(t==="backToPage"){var p=[],j;while(this._pageStack[this._pageStack.length-1].id!==r){j=this._pageStack.pop();p.push(j.id);}q.sap.log.info(this.toString()+": navigating back to specific page "+o.toString()+" across the pages: "+p.join(", "));}if(!this.getDomRef()){q.sap.log.info("'Hidden' back navigation in not-rendered NavContainer "+this.toString());return this;}var k=N.transitions[c]||N.transitions["slide"];var l=this._iTransitionsCompleted;var m=this;window.setTimeout(function(){if(m&&(m._iTransitionsCompleted<l+1)){q.sap.log.warning("Transition '"+c+"' 'back' was triggered five seconds ago, but has not yet invoked the end-of-transition callback.");}},g(5000));this._bNavigating=true;var s;if(!(s=o.getDomRef())||s.parentNode!=this.getDomRef()||sap.ui.core.RenderManager.isPreservedContent(s)){o.addStyleClass("sapMNavItemRendering");q.sap.log.debug("Rendering 'to' page '"+o.toString()+"' for back navigation");var v=sap.ui.getCore().createRenderManager();var w=this.$().children().index(F.getDomRef());v.renderControl(o);v.flush(this.getDomRef(),false,w);v.destroy();o.addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemRendering");}if(F.getId()===o.getId()){q.sap.log.info("Transition is skipped when navigating back to the same page instance"+o.toString());this._afterTransitionCallback(n,d,b);return this;}k.back.call(this,F,o,q.proxy(function(){this._afterTransitionCallback(n,d,b);},this),T);}}return this;};
N.prototype._findClosestPreviousPageInfo=function(r){for(var i=this._pageStack.length-2;i>=0;i--){var b=this._pageStack[i];if(b.id===r){return b;}}return null;};
N.transitions=N.transitions||{};N.transitions["show"]={to:function(f,t,c){t.removeStyleClass("sapMNavItemHidden");f&&f.addStyleClass("sapMNavItemHidden");c();},back:function(f,t,c){t.removeStyleClass("sapMNavItemHidden");f&&f.addStyleClass("sapMNavItemHidden");c();}};if(q.support.cssTransitions){N.transitions["slide"]={to:function(f,t,c){f.addStyleClass("sapMNavItemCenter");window.setTimeout(function(){t.addStyleClass("sapMNavItemRight");t.removeStyleClass("sapMNavItemHidden");window.setTimeout(function(){var o=false;var T=true;var A=null;A=function(){q(this).unbind("webkitTransitionEnd transitionend");if(!o){o=true;}else{T=false;if(I(t)){t.removeStyleClass("sapMNavItemSliding").removeStyleClass("sapMNavItemCenter");}if(I(f)){f.removeStyleClass("sapMNavItemSliding").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemLeft");}c();}};f.$().bind("webkitTransitionEnd transitionend",A);t.$().bind("webkitTransitionEnd transitionend",A);t.addStyleClass("sapMNavItemSliding").addStyleClass("sapMNavItemCenter").removeStyleClass("sapMNavItemRight");f.addStyleClass("sapMNavItemSliding").removeStyleClass("sapMNavItemCenter").addStyleClass("sapMNavItemLeft");window.setTimeout(function(){if(T){o=true;A.apply(f.$().add(t.$()));}},g(400));},g(60));},0);},back:function(f,t,c){t.addStyleClass("sapMNavItemLeft");t.removeStyleClass("sapMNavItemHidden");f.addStyleClass("sapMNavItemCenter");window.setTimeout(function(){var o=false;var T=true;var A=null;A=function(){q(this).unbind("webkitTransitionEnd transitionend");if(!o){o=true;}else{T=false;if(I(t)){t.removeStyleClass("sapMNavItemSliding").removeStyleClass("sapMNavItemCenter");}if(I(f)){f.removeStyleClass("sapMNavItemSliding").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemRight");}c();}};f.$().bind("webkitTransitionEnd transitionend",A);t.$().bind("webkitTransitionEnd transitionend",A);if(sap.ui.Device.browser.webkit){window.setTimeout(function(){t.$().css("box-shadow","0em 1px 0em rgba(128, 128, 1280, 0.1)");window.setTimeout(function(){t.$().css("box-shadow","");},g(50));},0);}t.addStyleClass("sapMNavItemSliding").addStyleClass("sapMNavItemCenter").removeStyleClass("sapMNavItemLeft");f.addStyleClass("sapMNavItemSliding").removeStyleClass("sapMNavItemCenter").addStyleClass("sapMNavItemRight");window.setTimeout(function(){if(T){o=true;A.apply(f.$().add(t.$()));}},g(400));},g(100));}};}else{N.transitions["slide"]={to:function(f,t,c){var T=t.$();T.css("left","100%");t.removeStyleClass("sapMNavItemHidden");T.animate({left:"0%"},g(300));var F=f.$();F.animate({left:"-100%"},g(300),function(){f.addStyleClass("sapMNavItemHidden");F.css("left","0");c();});},back:function(f,t,c){var T=t.$();T.css("left","-100%");t.removeStyleClass("sapMNavItemHidden");T.animate({left:"0%"},g(300));var F=f.$();F.animate({left:"100%"},g(300),function(){f.addStyleClass("sapMNavItemHidden");F.css("left","0");c();});}};}if(q.support.cssTransitions){N.transitions["fade"]={to:function(f,t,c){t.addStyleClass("sapMNavItemTransparent");t.removeStyleClass("sapMNavItemHidden");window.setTimeout(function(){var A=null;var T=true;A=function(){q(this).unbind("webkitTransitionEnd transitionend");T=false;if(I(f)){f.addStyleClass("sapMNavItemHidden");}if(I(t)){t.removeStyleClass("sapMNavItemFading").removeStyleClass("sapMNavItemOpaque");}c();};t.$().bind("webkitTransitionEnd transitionend",A);t.addStyleClass("sapMNavItemFading").removeStyleClass("sapMNavItemTransparent").addStyleClass("sapMNavItemOpaque");window.setTimeout(function(){if(T){A.apply(t.$());}},g(600));},g(10));},back:function(f,t,c){f.addStyleClass("sapMNavItemOpaque");t.removeStyleClass("sapMNavItemHidden");window.setTimeout(function(){var A=null;var T=true;A=function(){q(this).unbind("webkitTransitionEnd transitionend");T=false;if(I(f)){f.removeStyleClass("sapMNavItemFading").addStyleClass("sapMNavItemHidden");f.removeStyleClass("sapMNavItemTransparent");}c();};f.$().bind("webkitTransitionEnd transitionend",A);f.addStyleClass("sapMNavItemFading").removeStyleClass("sapMNavItemOpaque");f.addStyleClass("sapMNavItemTransparent");window.setTimeout(function(){if(T){A.apply(t.$());}},g(600));},g(10));}};}else{N.transitions["fade"]={to:function(f,t,c){var T=t.$();T.css("opacity","0");t.removeStyleClass("sapMNavItemHidden");T.animate({opacity:"1"},g(500),function(){f.addStyleClass("sapMNavItemHidden");c();});},back:function(f,t,c){var F=f.$();t.removeStyleClass("sapMNavItemHidden");F.animate({opacity:"0"},g(500),function(){f.addStyleClass("sapMNavItemHidden");F.css("opacity","1");c();});}};}if(q.support.cssTransitions){N.transitions["flip"]={to:function(f,t,c){var b=this;window.setTimeout(function(){b.$().addClass("sapMNavFlip");t.addStyleClass("sapMNavItemFlipNext");t.removeStyleClass("sapMNavItemHidden");window.setTimeout(function(){var o=false;var T=true;var A=null;A=function(){q(this).unbind("webkitTransitionEnd transitionend");if(!o){o=true;}else{T=false;if(I(t)){t.removeStyleClass("sapMNavItemFlipping");}if(I(f)){f.removeStyleClass("sapMNavItemFlipping").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemFlipPrevious");}b.$().removeClass("sapMNavFlip");c();}};f.$().bind("webkitTransitionEnd transitionend",A);t.$().bind("webkitTransitionEnd transitionend",A);t.addStyleClass("sapMNavItemFlipping").removeStyleClass("sapMNavItemFlipNext");f.addStyleClass("sapMNavItemFlipping").addStyleClass("sapMNavItemFlipPrevious");window.setTimeout(function(){if(T){o=true;A.apply(f.$().add(t.$()));}},g(600));},g(60));},0);},back:function(f,t,c){var b=this;b.$().addClass("sapMNavFlip");t.addStyleClass("sapMNavItemFlipPrevious");t.removeStyleClass("sapMNavItemHidden");window.setTimeout(function(){var o=false;var T=true;var A=null;A=function(){q(this).unbind("webkitTransitionEnd transitionend");if(!o){o=true;}else{T=false;if(I(t)){t.removeStyleClass("sapMNavItemFlipping");}if(I(f)){f.removeStyleClass("sapMNavItemFlipping").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemFlipNext");}b.$().removeClass("sapMNavFlip");c();}};f.$().bind("webkitTransitionEnd transitionend",A);t.$().bind("webkitTransitionEnd transitionend",A);t.addStyleClass("sapMNavItemFlipping").removeStyleClass("sapMNavItemFlipPrevious");f.addStyleClass("sapMNavItemFlipping").addStyleClass("sapMNavItemFlipNext");window.setTimeout(function(){if(T){o=true;A.apply(f.$().add(t.$()));}},g(600));},g(60));}};}else{N.transitions["flip"]=N.transitions["slide"];}if(q.support.cssTransitions){N.transitions["door"]={to:function(f,t,c){var b=this;window.setTimeout(function(){b.$().addClass("sapMNavDoor");t.addStyleClass("sapMNavItemDoorInNext");t.removeStyleClass("sapMNavItemHidden");window.setTimeout(function(){var o=false;var T=true;var A=null;A=function(){q(this).unbind("webkitAnimationEnd animationend");if(!o){o=true;}else{T=false;if(I(t)){t.removeStyleClass("sapMNavItemDooring").removeStyleClass("sapMNavItemDoorInNext");}if(I(f)){f.removeStyleClass("sapMNavItemDooring").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemDoorInPrevious");}b.$().removeClass("sapMNavDoor");c();}};f.$().bind("webkitAnimationEnd animationend",A);t.$().bind("webkitAnimationEnd animationend",A);t.addStyleClass("sapMNavItemDooring");f.addStyleClass("sapMNavItemDooring").addStyleClass("sapMNavItemDoorInPrevious");window.setTimeout(function(){if(T){o=true;A.apply(f.$().add(t.$()));}},g(1000));},g(60));},0);},back:function(f,t,c){var b=this;b.$().addClass("sapMNavDoor");t.addStyleClass("sapMNavItemDoorOutNext");t.removeStyleClass("sapMNavItemHidden");window.setTimeout(function(){var o=false;var T=true;var A=null;A=function(){q(this).unbind("webkitAnimationEnd animationend");if(!o){o=true;}else{T=false;if(I(t)){t.removeStyleClass("sapMNavItemDooring").removeStyleClass("sapMNavItemDoorOutNext");}if(I(f)){f.removeStyleClass("sapMNavItemDooring").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemDoorOutPrevious");}b.$().removeClass("sapMNavDoor");c();}};f.$().bind("webkitAnimationEnd animationend",A);t.$().bind("webkitAnimationEnd animationend",A);t.addStyleClass("sapMNavItemDooring");f.addStyleClass("sapMNavItemDooring").addStyleClass("sapMNavItemDoorOutPrevious");window.setTimeout(function(){if(T){o=true;A.apply(f.$().add(t.$()));}},g(1000));},g(60));}};}else{N.transitions["door"]=N.transitions["slide"];}
N.prototype.addCustomTransition=function(n,t,b){if(N.transitions[n]){q.sap.log.warning("Transition with name "+n+" already exists in "+this+". It is now being replaced by custom transition.");}N.transitions[n]={to:t,back:b};return this;};
N.addCustomTransition=N.prototype.addCustomTransition;N.prototype.forceInvalidation=N.prototype.invalidate;
N.prototype.invalidate=function(s){if(s==this){}else if(!s){this.forceInvalidation();}else if(s instanceof C){var b=false,p=this.getPages(),l=p.length;for(var i=0;i<l;i++){if(p[i]===s){b=true;break;}}if((!b||s===this.getCurrentPage())&&!this._isInsideAPopup()){this.forceInvalidation();}}else{this.forceInvalidation();}};
N.prototype._isInsideAPopup=function(){var s;s=function(c){if(!c){return false;}if(c.getMetadata().isInstanceOf("sap.ui.core.PopupInterface")){return true;}return s(c.getParent());};return s(this);};
N.prototype.removePage=function(p){p=this.removeAggregation("pages",p,p!==this.getCurrentPage());this._onPageRemoved(p);return p;};
N.prototype._onPageRemoved=function(p){if(!p){return;}p.$().remove();p.removeStyleClass("sapMNavItemHidden");p.removeStyleClass("sapMNavItem");var s=this._ensurePageStackInitialized();this._pageStack=s.filter(function(P){return p.getId()!==P.id;});};
N.prototype.removeAllPages=function(){var p=this.getPages();if(!p){return[];}for(var i=0;i<p.length;i++){this._onPageRemoved(p[i]);}return this.removeAllAggregation("pages");};
N.prototype.addPage=function(p){var P=this.getPages();if(q.inArray(p,P)>-1){return this;}this.addAggregation("pages",p,true);p.addStyleClass("sapMNavItem");var i=P.length;if(i===0&&this.getPages().length===1&&this.getDomRef()){this._ensurePageStackInitialized();this.rerender();this._fireAdaptableContentChange(p);}return this;};
N.prototype.insertPage=function(p,i){var P=this.getPages().length;this.insertAggregation("pages",p,i,true);p.addStyleClass("sapMNavItem");if(P===0&&this.getPages().length===1&&this.getDomRef()){this._ensurePageStackInitialized();this.rerender();this._fireAdaptableContentChange(p);}return this;};
N.prototype._getAdaptableContent=function(){return this.getCurrentPage();};
N.prototype._fireAdaptableContentChange=function(p){if(p&&this.mEventRegistry["_adaptableContentChange"]){this.fireEvent("_adaptableContentChange",{"parent":this,"adaptableContent":p});}};
return N;},true);
sap.ui.predefine('sap/m/NavContainerRenderer',['jquery.sap.global'],function(q){"use strict";var N={};
N.render=function(r,c){c._bRenderingInProgress=true;if(!c.getVisible()){return;}r.write("<div");r.writeControlData(c);r.addClass("sapMNav");if(c.getWidth()){r.addStyle("width",c.getWidth());}var h=c.getHeight();if(h&&h!="100%"){r.addStyle("height",h);}if(this.renderAttributes){this.renderAttributes(r,c);}r.writeClasses();r.writeStyles();var t=c.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}r.write(">");if(this.renderBeforeContent){this.renderBeforeContent(r,c);}var C=c.getCurrentPage();if(C){C.removeStyleClass("sapMNavItemHidden");r.renderControl(C);}r.write("</div>");c._bRenderingInProgress=false;};
return N;},true);
sap.ui.predefine('sap/m/NewsContent',['jquery.sap.global','./library','sap/ui/core/Control','sap/m/Text','sap/ui/Device'],function(q,l,C,T,D){"use strict";
var N=C.extend("sap.m.NewsContent",{metadata:{library:"sap.m",properties:{"size":{type:"sap.m.Size",group:"Misc",defaultValue:"Auto"},"contentText":{type:"string",group:"Misc",defaultValue:null},"subheader":{type:"string",group:"Misc",defaultValue:null}},defaultAggregation:"_contentText",aggregations:{"_contentText":{type:"sap.m.Text",multiple:false,visibility:"hidden"}},events:{"press":{}}}});
N.prototype.init=function(){this._oContentText=new T(this.getId()+"-content-text",{maxLines:2});this._oContentText.cacheLineHeight=false;this.setAggregation("_contentText",this._oContentText,true);this.setTooltip("{AltText}");};
N.prototype.onBeforeRendering=function(){this._setPointerOnContentText();this.$().unbind("mouseenter",this._addTooltip);this.$().unbind("mouseleave",this._removeTooltip);};
N.prototype.onAfterRendering=function(){this.$().bind("mouseenter",this._addTooltip.bind(this));this.$().bind("mouseleave",this._removeTooltip.bind(this));};
N.prototype._addTooltip=function(){this.$().attr("title",this.getTooltip_AsString());};
N.prototype._removeTooltip=function(){this.$().attr("title",null);};
N.prototype._setPointerOnContentText=function(){var t=this.getAggregation("_contentText");if(t&&this.hasListeners("press")){t.addStyleClass("sapMPointer");}else if(t&&t.hasStyleClass("sapMPointer")){t.removeStyleClass("sapMPointer");}};
N.prototype.getAltText=function(){var a="";var i=true;if(this.getAggregation("_contentText").getText()){a+=this.getAggregation("_contentText").getText();i=false;}if(this.getSubheader()){if(i){a+=""+this.getSubheader();}else{a+="\n"+this.getSubheader();}}return a;};
N.prototype.getTooltip_AsString=function(){var t=this.getTooltip();var s=this.getAltText();if(typeof t==="string"||t instanceof String){s=t.split("{AltText}").join(s).split("((AltText))").join(s);return s;}if(t){return t;}else{return"";}};
N.prototype.setContentText=function(t){this._oContentText.setText(t);return this.setProperty("contentText",t,true);};
N.prototype.ontap=function(e){if(D.browser.msie){this.$().focus();}this.firePress();};
N.prototype.onkeydown=function(e){if(e.which===q.sap.KeyCodes.ENTER||e.which===q.sap.KeyCodes.SPACE){this.firePress();e.preventDefault();}};
N.prototype.attachEvent=function(e,d,f,a){C.prototype.attachEvent.call(this,e,d,f,a);if(this.hasListeners("press")){this.$().attr("tabindex",0).addClass("sapMPointer");this._setPointerOnContentText();}return this;};
N.prototype.detachEvent=function(e,f,a){C.prototype.detachEvent.call(this,e,f,a);if(!this.hasListeners("press")){this.$().removeAttr("tabindex").removeClass("sapMPointer");this._setPointerOnContentText();}return this;};
return N;});
sap.ui.predefine('sap/m/NewsContentRenderer',[],function(){"use strict";var N={};
N.render=function(r,c){var s=c.getSubheader();var t=c.getTooltip_AsString();if(typeof t!=="string"){t="";}r.write("<div");r.writeControlData(c);r.writeAttribute("id",c.getId()+"-news-content");r.writeAttribute("role","presentation");r.writeAttributeEscaped("aria-label",t);r.addClass("sapMNwC");if(c.hasListeners("press")){r.addClass("sapMPointer");r.writeAttribute("tabindex","0");}r.writeClasses();r.write(">");r.write("<div");r.addClass("sapMNwCCTxt");r.writeClasses();r.write(">");r.renderControl(c._oContentText);r.write("</div>");r.write("<div");r.writeAttribute("id",c.getId()+"-subheader");r.addClass("sapMNwCSbh");r.writeClasses();r.write(">");r.writeEscaped(s);r.write("</div>");r.write("</div>");};
return N;},true);
sap.ui.predefine('sap/m/NotificationListBase',['jquery.sap.global','./library','sap/ui/core/Control','./ListItemBase','./Text','./Image','./OverflowToolbar','sap/ui/core/Icon'],function(q,l,C,L,T,I,O,a){'use strict';
var N=L.extend('sap.m.NotificationListBase',{metadata:{library:'sap.m',properties:{priority:{type:'sap.ui.core.Priority',group:'Appearance',defaultValue:sap.ui.core.Priority.None},title:{type:'string',group:'Appearance',defaultValue:''},datetime:{type:'string',group:'Appearance',defaultValue:''},showButtons:{type:'boolean',group:'Behavior',defaultValue:true},showCloseButton:{type:'boolean',group:'Behavior',defaultValue:true},authorName:{type:'string',group:'Appearance',defaultValue:''},authorPicture:{type:'sap.ui.core.URI',multiple:false}},aggregations:{buttons:{type:'sap.m.Button',multiple:true},_headerTitle:{type:'sap.m.Text',multiple:false,visibility:"hidden"},_dateTime:{type:'sap.m.Text',multiple:false,visibility:'hidden'},_authorName:{type:'sap.m.Text',multiple:false,visibility:"hidden"},_authorImage:{type:'sap.ui.core.Control',multiple:false,visibility:"hidden"},_overflowToolbar:{type:'sap.m.OverflowToolbar',multiple:false,visibility:"hidden"},_closeButton:{type:'sap.m.Button',multiple:false,visibility:"hidden"},_collapseButton:{type:'sap.m.Button',multiple:false,visibility:"hidden"}},events:{close:{}}}});
N.prototype.init=function(){this.setAggregation('_overflowToolbar',new O());};
N.prototype.setTitle=function(t){var r=this.setProperty('title',t);this._getHeaderTitle().setText(t);return r;};
N.prototype.setDatetime=function(d){var r=this.setProperty('datetime',d);this._getDateTimeText().setText(d);return r;};
N.prototype.setAuthorName=function(b){var r=this.setProperty('authorName',b);this._getAuthorName().setText(b);return r;};
N.prototype.clone=function(){var c=C.prototype.clone.apply(this,arguments);var o=this.getAggregation('_overflowToolbar');c.setAggregation("_overflowToolbar",o.clone(),true);return c;};
N.prototype.close=function(){var p=this.getParent();this.fireClose();if(p&&p instanceof sap.ui.core.Element){var d={onAfterRendering:function(){p.getDomRef().focus();p.removeEventDelegate(d);}};p.addEventDelegate(d);}};
N.prototype.bindAggregation=function(b,c){if(b=='buttons'){this.getAggregation('_overflowToolbar').bindAggregation('content',c);return this;}else{return sap.ui.core.Control.prototype.bindAggregation.call(this,b,c);}};
N.prototype.validateAggregation=function(b,o,m){if(b=='buttons'){this.getAggregation('_overflowToolbar').validateAggregation('content',o,m);return this;}else{return sap.ui.core.Control.prototype.validateAggregation.call(this,b,o,m);}};
N.prototype.setAggregation=function(b,o,s){if(b=='buttons'){this.getAggregation('_overflowToolbar').setAggregation('content',o,s);return this;}else{return sap.ui.core.Control.prototype.setAggregation.call(this,b,o,s);}};
N.prototype.getAggregation=function(b,d){if(b=='buttons'){var t=this.getAggregation('_overflowToolbar');return t.getContent().filter(function(c){return c instanceof sap.m.Button;});}else{return sap.ui.core.Control.prototype.getAggregation.call(this,b,d);}};
N.prototype.indexOfAggregation=function(b,o){if(b=='buttons'){return this.getAggregation('_overflowToolbar').indexOfAggregation('content',o);}else{return sap.ui.core.Control.prototype.indexOfAggregation.call(this,b,o);}};
N.prototype.insertAggregation=function(b,o,c,s){if(b=='buttons'){this.getAggregation('_overflowToolbar').insertAggregation('content',o,c,s);return this;}else{return sap.ui.core.Control.prototype.insertAggregation.call(this,o,c,s);}};
N.prototype.addAggregation=function(b,o,s){if(b=='buttons'){var t=this.getAggregation('_overflowToolbar');return t.addAggregation('content',o,s);}else{return sap.ui.core.Control.prototype.addAggregation.call(this,b,o,s);}};
N.prototype.removeAggregation=function(b,o,s){if(b=='buttons'){return this.getAggregation('_overflowToolbar').removeAggregation('content',o,s);}else{return sap.ui.core.Control.prototype.removeAggregation.call(this,b,o,s);}};
N.prototype.removeAllAggregation=function(b,s){if(b=='buttons'){return this.getAggregation('_overflowToolbar').removeAllAggregation('content',s);}else{return sap.ui.core.Control.prototype.removeAllAggregation.call(this,b,s);}};
N.prototype.destroyAggregation=function(b,s){if(b=='buttons'){return this.getAggregation('_overflowToolbar').destroyAggregation('content',s);}else{return sap.ui.core.Control.prototype.destroyAggregation.call(this,b,s);}};
N.prototype.getBinding=function(b){if(b=='buttons'){return this.getAggregation('_overflowToolbar').getBinding('content');}else{return sap.ui.core.Control.prototype.getBinding.call(this,b);}};
N.prototype.getBindingInfo=function(b){if(b=='buttons'){return this.getAggregation('_overflowToolbar').getBindingInfo('content');}else{return sap.ui.core.Control.prototype.getBindingInfo.call(this,b);}};
N.prototype.getBindingPath=function(b){if(b=='buttons'){return this.getAggregation('_overflowToolbar').getBindingPath('content');}else{return sap.ui.core.Control.prototype.getBindingPath.call(this,b);}};
N.prototype._getHeaderTitle=function(){var t=this.getAggregation("_headerTitle");if(!t){t=new T({id:this.getId()+'-title',text:this.getTitle(),maxLines:2});this.setAggregation("_headerTitle",t,true);}return t;};
N.prototype._getDateTimeText=function(){var d=this.getAggregation('_dateTime');if(!d){d=new sap.m.Text({id:this.getId()+'-datetime',text:this.getDatetime()}).addStyleClass('sapMNLI-Datetime');this.setAggregation('_dateTime',d,true);}return d;};
N.prototype._getAuthorName=function(){var b=this.getAggregation('_authorName');if(!b){b=new T({text:this.getAuthorName()}).addStyleClass('sapMNLI-Text');this.setAggregation('_authorName',b,true);}return b;};
N.prototype._getAuthorImage=function(){var b=this.getAggregation('_authorImage');if(!b){var c=this.getAuthorPicture();var d=this.getAuthorName();if(i(c)){b=new a({src:c,alt:d});}else{b=new I({src:c,alt:d});}this.setAggregation('_authorImage',b,true);}return b;};
N.prototype._getToolbar=function(){var t=this.getAggregation("_overflowToolbar");if(!t){t=new O();this.setAggregation("_overflowToolbar",t,true);}return t;};
function i(s){if(!s){return false;}var r=window.URI.parse(s);return(r.protocol&&r.protocol=='sap-icon');}
return N;},true);
sap.ui.predefine('sap/m/NotificationListGroup',['jquery.sap.global','./library','sap/ui/core/Control','./NotificationListBase','sap/ui/core/InvisibleText','./ListItemBase'],function(q,l,C,N,I,L){'use strict';
var a=N.extend('sap.m.NotificationListGroup',{metadata:{library:'sap.m',properties:{collapsed:{type:'boolean',group:'Behavior',defaultValue:false},autoPriority:{type:'boolean',group:'Behavior',defaultValue:true},showEmptyGroup:{type:'boolean',group:'Behavior',defaultValue:false},enableCollapseButtonWhenEmpty:{type:'boolean',group:'Behavior',defaultValue:false}},defaultAggregation:'items',aggregations:{items:{type:'sap.m.NotificationListItem',multiple:true,singularName:'item'},_ariaDetailsText:{type:'sap.ui.core.InvisibleText',multiple:false,visibility:'hidden'}},events:{onCollapse:{parameters:{collapsed:{type:'boolean'}}}}}});
a.prototype.init=function(){sap.m.NotificationListBase.prototype.init.call(this);var r=sap.ui.getCore().getLibraryResourceBundle('sap.m');this._closeText=r.getText('NOTIFICATION_LIST_BASE_CLOSE');var _=new sap.m.Button(this.getId()+'-closeButton',{type:sap.m.ButtonType.Transparent,icon:sap.ui.core.IconPool.getIconURI('decline'),tooltip:this._closeText,press:function(){this.close();}.bind(this)});this.setAggregation('_closeButton',_,true);var b=new sap.m.Button({type:sap.m.ButtonType.Transparent,press:function(){this.setCollapsed(!this.getCollapsed());}.bind(this)});this.setAggregation('_collapseButton',b,true);this._maxNumberReached=false;this._ariaLabbeledByIds='';this.setAggregation('_ariaDetailsText',new I());this._resourceBundle=sap.ui.getCore().getLibraryResourceBundle('sap.m');};
a.prototype.setCollapsed=function(b){this._toggleCollapsed();this.setProperty('collapsed',b,true);this.fireOnCollapse({collapsed:b});return this;};
a.prototype.getPriority=function(){if(!this.getAutoPriority()){return this.getProperty('priority');}var n=this.getAggregation('items');var p=sap.ui.core.Priority.None;if(n){n.forEach(function(i){p=c(p,i.getPriority());});}else{p=this.getProperty('priority');}return p;};
a.prototype.getUnread=function(){var n=this.getItems();if(n.length){return n.some(function(i){return i.getUnread();});}return this.getProperty('unread');};
a.prototype.onBeforeRendering=function(){var n=this.getItems();var b=n.length;var d=this.getAggregation('_collapseButton');this._maxNumberOfNotifications=sap.ui.Device.system.desktop?400:100;d.setEnabled(this._getCollapseButtonEnabled(),true);this._maxNumberReached=b>this._maxNumberOfNotifications;n.forEach(function(i){i.addEventDelegate({onfocusin:this._notificationFocusHandler},this);i.addEventDelegate({onkeydown:this._notificationNavigationHandler},this);}.bind(this));this._updateAccessibilityInfo();this._updateCollapseButtonText(this.getCollapsed());this._maxNumberOfNotificationsTitle=this._resourceBundle.getText('NOTIFICATION_LIST_GROUP_MAX_NOTIFICATIONS_TITLE',b-this._maxNumberOfNotifications);this._maxNumberOfNotificationsBody=this._resourceBundle.getText('NOTIFICATION_LIST_GROUP_MAX_NOTIFICATIONS_BODY');};
a.prototype.clone=function(){return N.prototype.clone.apply(this,arguments);};
a.prototype._getHeaderTitle=function(){var t=sap.m.NotificationListBase.prototype._getHeaderTitle.call(this);t.addStyleClass('sapMNLG-Title');if(this.getUnread()){t.addStyleClass('sapMNLGTitleUnread');}return t;};
a.prototype._getDateTimeText=function(){var d=sap.m.NotificationListBase.prototype._getDateTimeText.call(this);d.setTextAlign('End');return d;};
a.prototype._toggleCollapsed=function(){var n=!this.getCollapsed();this._updateCollapseButtonText(n);this.$().toggleClass('sapMNLG-Collapsed',n);this.$().toggleClass('sapMNLG-NoNotifications',this._getVisibleItemsCount()<=0);};
a.prototype._getVisibleItemsCount=function(){var i=this.getItems();var r=0;i.forEach(function(b){if(b.getVisible()){r+=1;}});return r;};
a.prototype._getCollapseButtonEnabled=function(){if(this._getVisibleItemsCount()>0){return true;}return this.getEnableCollapseButtonWhenEmpty();};
a.prototype._notificationFocusHandler=function(e){L.prototype.onfocusin.call(this,e);var t=e.srcControl;if(t.getMetadata().getName()!='sap.m.NotificationListItem'){return;}var n=t.getParent();var g=n.indexOfItem(t);var b=t.getDomRef();b.setAttribute('aria-posinset',g+1);b.setAttribute('aria-setsize',n.getItems().length);};
a.prototype._notificationNavigationHandler=function(e){L.prototype.onkeydown.call(this,e);var t=e.srcControl;if(t.getMetadata().getName()!='sap.m.NotificationListItem'){return;}var n=t.getParent();var g=n.indexOfItem(t);switch(e.which){case q.sap.KeyCodes.ARROW_UP:if(g==0){return;}var p=g-1;n.getItems()[p].focus();break;case q.sap.KeyCodes.ARROW_DOWN:var b=g+1;if(b==n.getItems().length){return;}n.getItems()[b].focus();break;default:return;}};
a.prototype._updateAccessibilityInfo=function(){var b=this.getAuthorName();var i=this._resourceBundle.getText('NOTIFICATION_LIST_ITEM_DATETIME_PRIORITY',[this.getDatetime(),this.getPriority()]);var u=this.getUnread()?this._resourceBundle.getText('NOTIFICATION_LIST_GROUP_UNREAD'):this._resourceBundle.getText('NOTIFICATION_LIST_GROUP_READ');var d='';var e=this.getAggregation('_ariaDetailsText');if(b){d+=this._resourceBundle.getText('NOTIFICATION_LIST_ITEM_CREATED_BY')+' '+b+' ';}d+=i+' '+u;e.setText(d);this._ariaLabbeledByIds=this._getHeaderTitle().getId()+' '+e.getId();};
a.prototype._updateCollapseButtonText=function(b){var d=b?this._resourceBundle.getText('NOTIFICATION_LIST_GROUP_EXPAND'):this._resourceBundle.getText('NOTIFICATION_LIST_GROUP_COLLAPSE');this.getAggregation('_collapseButton').setText(d,true);};
function c(f,s){if(f==s){return f;}if((f=='None')){return s;}if((f=='Low')&&(s!='None')){return s;}if((f=='Medium')&&(s!='None'&&s!='Low')){return s;}return f;}
return a;},true);
sap.ui.predefine('sap/m/NotificationListGroupRenderer',[],function(){'use strict';var N={};var c='sapMNLG';var a='sapMNLB';var b='sapMLIB';var d='sapMNLB-AuthorPicture';var e='sapMNLB-Header';var f='sapMNLG-Header';var g='sapMNLG-Body';var h='sapMNLB-SubHeader';var i='sapMNLG-SubHeader';var j='sapMNLB-CloseButton';var k='sapMNLB-Priority';var l='sapMNLG-Details';var m='sapMNLB-Bullet';var n='sapMNLG-Description';var o='sapMNLG-Collapsed';var p='sapMNLGNoHdrFooter';var q='sapMNLG-MaxNotifications';var r='sapMNLG-NoNotifications';
N.render=function(R,C){if(C.getVisible()){var v=C._getVisibleItemsCount();var _=C.getShowEmptyGroup()||(v>0);R.write('<li');R.addClass(c);R.addClass(a);R.addClass(b);if(!_){R.addClass(p);}if(C.getCollapsed()){R.addClass(o);}if(v==0){R.addClass(r);}R.writeClasses();R.writeControlData(C);R.writeAttribute('tabindex','0');R.writeAccessibilityState(C,{labelledby:C._ariaLabbeledByIds});R.write('>');if(_){this.renderHeader(R,C);this.renderSubHeader(R,C);this.renderBody(R,C);}R.write('</li>');}else{this.renderInvisibleItem(R,C);}};
N.renderHeader=function(R,C){R.write('<div');R.addClass(e);R.addClass(f);R.writeClasses();R.write('>');this.renderInvisibleInfoText(R,C);this.renderPriorityArea(R,C);this.renderCloseButton(R,C);this.renderTitle(R,C);this.renderDetails(R,C);R.write('</div>');};
N.renderTitle=function(R,C){R.renderControl(C._getHeaderTitle());};
N.renderCloseButton=function(R,C){if(C.getShowCloseButton()){R.renderControl(C.getAggregation('_closeButton').addStyleClass(j));}};
N.renderAuthorPicture=function(R,C){if(!C.getAuthorPicture()){return;}R.write('<div');R.addClass(d);R.writeClasses();R.write('>');R.renderControl(C._getAuthorImage());R.write('</div>');};
N.renderDetails=function(R,C){R.write('<div class="'+l+'">');this.renderAuthorPicture(R,C);R.write('<div class="'+n+'">');this.renderAuthorName(R,C);if(C.getAuthorName()!=""&&C.getDatetime()!=""){R.write('<span class="'+m+'">&#x00B7</span>');}this.renderDatetime(R,C);R.write('</div></div>');};
N.renderInvisibleInfoText=function(R,C){R.renderControl(C.getAggregation('_ariaDetailsText'));};
N.renderAuthorName=function(R,C){R.renderControl(C._getAuthorName());};
N.renderSubHeader=function(R,C){var s=C.getButtons();R.write('<div');R.addClass(i);R.addClass(h);R.writeClasses();R.write('>');this.renderPriorityArea(R,C);this.renderCollapseGroupButton(R,C);if(s&&s.length&&C.getShowButtons()){R.renderControl(C.getAggregation('_overflowToolbar'));}R.write('</div>');};
N.renderPriorityArea=function(R,C){R.write('<div');var s='';var t=C.getPriority();switch(t){case(sap.ui.core.Priority.Low):s='sapMNLB-Low';break;case(sap.ui.core.Priority.Medium):s='sapMNLB-Medium';break;case(sap.ui.core.Priority.High):s='sapMNLB-High';break;default:s='sapMNLB-None';break;}R.addClass(k);R.addClass(s);R.writeClasses();R.write('>');R.write('</div>');};
N.renderCollapseGroupButton=function(R,C){R.renderControl(C.getAggregation('_collapseButton'));};
N.renderInvisibleItem=function(R,C){R.write("<li");R.writeInvisiblePlaceholderData(C);R.write(">");R.write("</li>");};
N.renderBody=function(R,C){R.write('<ul class='+g+'>');this.renderNotifications(R,C);if(C._maxNumberReached){this.renderMaxNumberReachedMessage(R,C);}R.write('</ul>');};
N.renderDatetime=function(R,C){R.renderControl(C._getDateTimeText());};
N.renderNotifications=function(R,C){var s=C.getItems();var t=s.length;if(t){for(var u=0;u<C._maxNumberOfNotifications;u++){R.renderControl(s[u]);}}};
N.renderMaxNumberReachedMessage=function(R,C){var s='<span>'+C._maxNumberOfNotificationsTitle+'</span> <br>'+C._maxNumberOfNotificationsBody;R.write('<div');R.addClass(q);R.writeClasses();R.write('>');R.write(s);R.write('</div>');};
return N;},true);
sap.ui.predefine('sap/m/NotificationListItem',['jquery.sap.global','./library','sap/ui/core/Control','./NotificationListBase','sap/ui/core/InvisibleText'],function(q,l,C,N,I){'use strict';
var a=N.extend('sap.m.NotificationListItem',{metadata:{library:'sap.m',properties:{description:{type:'string',group:'Appearance',defaultValue:''},truncate:{type:'boolean',group:'Appearance',defaultValue:true},hideShowMoreButton:{type:'boolean',group:'Appearance',defaultValue:false}},aggregations:{processingMessage:{type:'sap.m.MessageStrip',multiple:false},_bodyText:{type:'sap.m.Text',multiple:false,visibility:"hidden"}}}});
a.prototype.init=function(){sap.m.NotificationListBase.prototype.init.call(this);var r=sap.ui.getCore().getLibraryResourceBundle('sap.m');this._expandText=r.getText('NOTIFICATION_LIST_ITEM_SHOW_MORE');this._collapseText=r.getText('NOTIFICATION_LIST_ITEM_SHOW_LESS');this._closeText=r.getText('NOTIFICATION_LIST_BASE_CLOSE');this.setType('Active');var _=new sap.m.Button(this.getId()+'-closeButton',{type:sap.m.ButtonType.Transparent,icon:sap.ui.core.IconPool.getIconURI('decline'),tooltip:this._closeText,press:function(){this.close();}.bind(this)});this.setAggregation("_closeButton",_,true);var b=new sap.m.Button({type:sap.m.ButtonType.Transparent,text:this.getTruncate()?this._expandText:this._collapseText,id:this.getId()+'-expandCollapseButton',press:function(){this._deregisterResize();this.setProperty("truncate",!this.getTruncate(),true);b.setText(this.getTruncate()?this._expandText:this._collapseText);this.$().find('.sapMNLI-Header').toggleClass('sapMNLI-TitleWrapper--is-expanded');this.$().find('.sapMNLI-TextWrapper').toggleClass('sapMNLI-TextWrapper--is-expanded',this.getDescription());this._registerResize();}.bind(this)});this.setAggregation("_collapseButton",b,true);this._ariaDetailsText=new I({id:this.getId()+'-info'}).toStatic();};
a.prototype.setDescription=function(d){var r=this.setProperty('description',d);this._getDescriptionText().setText(d);return r;};
a.prototype.setDatetime=function(d){var r=sap.m.NotificationListBase.prototype.setDatetime.call(this,d);this._updateAriaAdditionalInfo();return r;};
a.prototype.setUnread=function(u){var r=this.setProperty('unread',u,true);var t=this.getAggregation('_headerTitle');if(t){t.toggleStyleClass('sapMNLI-Unread',this.getUnread());}return r;};
a.prototype.setPriority=function(p,s){var r=this.setProperty('priority',p,s);this._updateAriaAdditionalInfo();return r;};
a.prototype.setAuthorPicture=function(b,s){var r=this.setProperty('authorPicture',b,s);this._getAuthorImage().setSrc(b);return r;};
a.prototype.clone=function(){return N.prototype.clone.apply(this,arguments);};
a.prototype.onBeforeRendering=function(){this._updateAriaAdditionalInfo();this._deregisterResize();};
a.prototype.onAfterRendering=function(){this._registerResize();};
a.prototype.exit=function(){this._deregisterResize();if(this._ariaDetailsText){this._ariaDetailsText.destroy();this._ariaDetailsText=null;}};
a.prototype._getDescriptionText=function(){var b=this.getAggregation('_bodyText');if(!b){b=new sap.m.Text({id:this.getId()+'-body',text:this.getDescription(),maxLines:2}).addStyleClass('sapMNLI-Text');this.setAggregation("_bodyText",b,true);}return b;};
a.prototype._activeHandling=function(){this.$().toggleClass("sapMNLIActive",this._active);};
a.prototype._updateAriaAdditionalInfo=function(){var r=sap.ui.getCore().getLibraryResourceBundle('sap.m');var b=this.getUnread()?r.getText('NOTIFICATION_LIST_ITEM_UNREAD'):r.getText('NOTIFICATION_LIST_ITEM_READ');var d=r.getText('NOTIFICATION_LIST_ITEM_DATETIME_PRIORITY',[this.getDatetime(),this.getPriority()]);var c=this.getAuthorName();var e=b+' ';if(c){e+=r.getText('NOTIFICATION_LIST_ITEM_CREATED_BY')+' '+this.getAuthorName()+' ';}e+=d;this._ariaDetailsText.setText(e);};
a.prototype._canTruncate=function(){var t=this.getDomRef('title').offsetHeight;var b=this.getDomRef('title').parentElement.offsetHeight;var c;var d;if(this._getDescriptionText().getText()){c=this.getDomRef("body").offsetHeight;d=this.getDomRef("body").parentElement.offsetHeight;}return c>d||t>b;};
a.prototype._showHideTruncateButton=function(){var n=this.getDomRef();if(this._canTruncate()&&(!this.getHideShowMoreButton())){this.getDomRef('expandCollapseButton').classList.remove('sapMNLI-CollapseButtonHide');if(this.getTruncate()){this.getAggregation('_collapseButton').setText(this._expandText);n.querySelector('.sapMNLI-Header').classList.remove('sapMNLI-TitleWrapper--is-expanded');if(this.getDescription()){n.querySelector('.sapMNLI-TextWrapper').classList.remove('sapMNLI-TextWrapper--is-expanded');}}else{this.getAggregation('_collapseButton').setText(this._collapseText);this.$().find('.sapMNLI-TextWrapper').toggleClass('sapMNLI-TextWrapper--is-expanded',this.getDescription());n.querySelector('.sapMNLI-Header').classList.add('sapMNLI-TitleWrapper--is-expanded');}}else{this.getDomRef('expandCollapseButton').classList.add('sapMNLI-CollapseButtonHide');}if(this.getDescription()){n.querySelector('.sapMNLI-TextWrapper').classList.remove('sapMNLI-TextWrapper--initial-overwrite');}if(this.getTitle()){n.querySelector('.sapMNLI-Header').classList.remove('sapMNLI-TitleWrapper--initial-overwrite');}};
a.prototype._deregisterResize=function(){if(this._sNotificationResizeHandler){sap.ui.core.ResizeHandler.deregister(this._sNotificationResizeHandler);this._sNotificationResizeHandler=null;}};
a.prototype._registerResize=function(){var t=this;var n=this.getDomRef();if(!n){return;}t._resizeNotification();this._sNotificationResizeHandler=sap.ui.core.ResizeHandler.register(n,function(){t._resizeNotification();});};
a.prototype._resizeNotification=function(){var n=this.getDomRef();var c=sap.ui.getCore();if(n.offsetWidth>=640){n.classList.add('sapMNLI-LSize');}else{n.classList.remove('sapMNLI-LSize');}if(this._getDescriptionText().getText()){n.querySelector('.sapMNLI-TextWrapper').classList.remove('sapMNLI-TextWrapper--is-expanded');n.querySelector('.sapMNLI-TextWrapper').classList.add('sapMNLI-TextWrapper--initial-overwrite');}n.querySelector('.sapMNLI-Header').classList.remove('sapMNLI-TitleWrapper--is-expanded');n.querySelector('.sapMNLI-Header').classList.add('sapMNLI-TitleWrapper--initial-overwrite');if(c.isThemeApplied()){this._showHideTruncateButton();}else{c.attachThemeChanged(this._showHideTruncateButton,this);}};
return a;},true);
sap.ui.predefine('sap/m/NotificationListItemRenderer',[],function(){'use strict';var N={};var c='sapMNLI';var a='sapMNLB';var b='sapMNLI-TextWrapper';var d='sapMLIB';var e='sapMNLB-AuthorPicture';var f='sapMNLB-Priority';var g='sapMNLB-Header';var h='sapMNLI-Header';var i='sapMNLI-Body';var j='sapMNLI-Description';var k='sapMNLI-Details';var l='sapMNLB-Bullet';var m='sapMNLB-Footer';var n='sapMNLI-Footer';var o='sapMNLI-No-Footer';var p='sapMNLB-CloseButton';var q='sapMNLI-CollapseButton';var r='sapMNLI-TitleWrapper--initial-overwrite';var s='sapMNLI-TextWrapper--initial-overwrite';
N.render=function(R,C){if(C.getVisible()){var u=C.getId();var v=(u+'-title')+' '+(u+'-body')+' '+(u+'-info');R.write('<li');R.addClass(c);R.addClass(a);R.addClass(d);R.writeControlData(C);R.writeAttribute('tabindex','0');R.writeAccessibilityState(C,{role:"listitem",labelledby:v});R.writeClasses();R.write('>');this.renderPriorityArea(R,C);this.renderMessageStrip(R,C);this.renderHeader(R,C);this.renderBody(R,C);this.renderFooter(R,C);R.write('</li>');}else{this.renderInvisibleItem(R,C);}};
N.renderPriorityArea=function(R,C){R.write('<div');var u='';switch(C.getPriority()){case(sap.ui.core.Priority.Low):u='sapMNLB-Low';break;case(sap.ui.core.Priority.Medium):u='sapMNLB-Medium';break;case(sap.ui.core.Priority.High):u='sapMNLB-High';break;default:u='sapMNLB-None';break;}R.addClass(f);R.addClass(u);R.writeClasses();R.write('>');R.write('</div>');};
N.renderMessageStrip=function(R,C){R.renderControl(C.getProcessingMessage());};
N.renderAuthorPicture=function(R,C){if(!C.getAuthorPicture()){return;}R.write('<div');R.addClass(e);R.writeClasses();R.write('>');R.renderControl(C._getAuthorImage());R.write('</div>');};
N.renderCloseButton=function(R,C){if(C.getShowCloseButton()){R.renderControl(C.getAggregation('_closeButton').addStyleClass(p));}};
N.renderCollapseButton=function(R,C){R.renderControl(C.getAggregation('_collapseButton').addStyleClass(q));};
N.renderHeader=function(R,C){R.write('<div');R.addClass(g);R.addClass(h);R.addClass(r);if(t(C)){R.addClass(o);}R.writeClasses();R.write('>');this.renderCloseButton(R,C);this.renderTitle(R,C);R.write('</div>');};
N.renderTitle=function(R,C){R.renderControl(C._getHeaderTitle());};
N.renderBody=function(R,C){if(!C._getDescriptionText().getText()&&!C.getAuthorName()&&!C.getDatetime()&&!C.getAuthorPicture()){return;}R.write('<div');R.addClass(i);if(t(C)){R.addClass(o);}R.writeClasses();R.write('>');this.renderAuthorPicture(R,C);R.write('<div class='+j+'>');this.renderDescription(R,C);this.renderDetails(R,C);R.write('</div>');this.renderAriaText(R,C);R.write('</div>');};
N.renderDescription=function(R,C){if(!C._getDescriptionText().getText()){return;}R.write('<div');R.addClass(b);R.addClass(s);R.writeClasses();R.write('>');R.renderControl(C._getDescriptionText());R.write('</div>');};
N.renderDetails=function(R,C){if(!C.getAuthorName()&&!C.getDatetime()){return;}R.write('<div class="'+k+'">');this.renderAuthorName(R,C);if(C.getAuthorName()){R.write('<span class="'+l+'">&#x00B7</span>');}this.renderDatetime(R,C);R.write('</div>');};
N.renderDatetime=function(R,C){R.renderControl(C._getDateTimeText());};
N.renderAuthorName=function(R,C){R.renderControl(C._getAuthorName());};
N.renderAriaText=function(R,C){R.renderControl(C._ariaDetailsText);};
N.renderFooter=function(R,C){var B=C.getButtons();R.write('<div');R.addClass(n);R.addClass(m);R.writeClasses();R.write('>');this.renderCollapseButton(R,C);if(B&&B.length&&C.getShowButtons()){R.renderControl(C.getAggregation('_overflowToolbar'));}R.write('</div>');};
N.renderInvisibleItem=function(R,C){R.write("<li");R.writeInvisiblePlaceholderData(C);R.write(">");R.write("</li>");};
function t(C){return C.getHideShowMoreButton()&&(!C.getShowButtons()||!C.getButtons());}
return N;},true);
sap.ui.predefine('sap/m/NumericContent',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/IconPool','sap/m/Image'],function(q,l,C,I,a){"use strict";
var N=C.extend("sap.m.NumericContent",{metadata:{library:"sap.m",properties:{"animateTextChange":{type:"boolean",group:"Behavior",defaultValue:true},"formatterValue":{type:"boolean",group:"Data",defaultValue:false},"icon":{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},"iconDescription":{type:"string",group:"Accessibility",defaultValue:null},"indicator":{type:"sap.m.DeviationIndicator",group:"Appearance",defaultValue:"None"},"nullifyValue":{type:"boolean",group:"Behavior",defaultValue:true},"scale":{type:"string",group:"Appearance",defaultValue:null},"size":{type:"sap.m.Size",group:"Appearance",defaultValue:"Auto"},"truncateValueTo":{type:"int",group:"Appearance",defaultValue:4},"value":{type:"string",group:"Data",defaultValue:null},"valueColor":{type:"sap.m.ValueColor",group:"Appearance",defaultValue:"Neutral"},"width":{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},"withMargin":{type:"boolean",group:"Appearance",defaultValue:true},"state":{type:"sap.m.LoadState",group:"Behavior",defaultValue:"Loaded"}},events:{"press":{}}}});
N.prototype.init=function(){this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this.setTooltip("{AltText}");};
N.prototype.onBeforeRendering=function(){this.$().unbind("mouseenter",this._addTooltip);this.$().unbind("mouseleave",this._removeTooltip);};
N.prototype.onAfterRendering=function(){this.$().bind("mouseenter",this._addTooltip.bind(this));this.$().bind("mouseleave",this._removeTooltip.bind(this));if(l.LoadState.Loaded==this.getState()||this.getAnimateTextChange()){q.sap.byId(this.getId()).animate({opacity:"1"},1000);}};
N.prototype._addTooltip=function(){this.$().attr("title",this.getTooltip_AsString());};
N.prototype._removeTooltip=function(){this.$().attr("title",null);};
N.prototype.exit=function(){if(this._oIcon){this._oIcon.destroy();}};
N.prototype.getAltText=function(){var v=this.getValue();var s=this.getScale();var e;var m=this._rb.getText(("SEMANTIC_COLOR_"+this.getValueColor()).toUpperCase());var A="";if(this.getNullifyValue()){e="0";}else{e="";}if(this.getIconDescription()){A=A.concat(this.getIconDescription());A=A.concat("\n");}if(v){A=A.concat(v+s);}else{A=A.concat(e);}A=A.concat("\n");if(this.getIndicator()&&this.getIndicator()!==l.DeviationIndicator.None){A=A.concat(this._rb.getText(("NUMERICCONTENT_DEVIATION_"+this.getIndicator()).toUpperCase()));A=A.concat("\n");}A=A.concat(m);return A;};
N.prototype.getTooltip_AsString=function(){var t=this.getTooltip();var T=this.getAltText();if(typeof t==="string"||t instanceof String){T=t.split("{AltText}").join(T).split("((AltText))").join(T);return T;}if(t){return t;}else{return"";}};
N.prototype.setIcon=function(u){var v=!q.sap.equal(this.getIcon(),u);if(v){if(this._oIcon){this._oIcon.destroy();this._oIcon=undefined;}if(u){this._oIcon=I.createControlByURI({id:this.getId()+"-icon-image",src:u},a);}}this._setPointerOnIcon();return this.setProperty("icon",u);};
N.prototype._setPointerOnIcon=function(){if(this._oIcon&&this.hasListeners("press")){this._oIcon.addStyleClass("sapMPointer");}else if(this._oIcon&&this._oIcon.hasStyleClass("sapMPointer")){this._oIcon.removeStyleClass("sapMPointer");}};
N.prototype.ontap=function(e){this.$().focus();this.firePress();e.preventDefault();};
N.prototype.onkeyup=function(e){if(e.which===q.sap.KeyCodes.ENTER||e.which===q.sap.KeyCodes.SPACE){this.firePress();e.preventDefault();}};
N.prototype.onkeydown=function(e){if(e.which===q.sap.KeyCodes.SPACE){e.preventDefault();}};
N.prototype.attachEvent=function(e,d,f,b){C.prototype.attachEvent.call(this,e,d,f,b);if(this.hasListeners("press")){this.$().attr("tabindex",0).addClass("sapMPointer");this._setPointerOnIcon();}return this;};
N.prototype.detachEvent=function(e,f,b){C.prototype.detachEvent.call(this,e,f,b);if(!this.hasListeners("press")){this.$().removeAttr("tabindex").removeClass("sapMPointer");this._setPointerOnIcon();}return this;};
N.prototype._parseFormattedValue=function(v){var t=v.replace(String.fromCharCode(8206),"").replace(String.fromCharCode(8207),"");return{scale:t.replace(/[+-., \d]*(.*)$/g,"$1").trim().replace(/\.$/,""),value:t.replace(/([+-., \d]*).*$/g,"$1").trim()};};
return N;});
sap.ui.predefine('sap/m/ObjectAttribute',['jquery.sap.global','./library','sap/ui/core/Control'],function(q,l,C){"use strict";
var O=C.extend("sap.m.ObjectAttribute",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Misc",defaultValue:null},text:{type:"string",group:"Misc",defaultValue:null},active:{type:"boolean",group:"Misc",defaultValue:null},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit}},aggregations:{customContent:{type:"sap.ui.core.Control",multiple:false},_textControl:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{press:{parameters:{domRef:{type:"string"}}}}}});
O.MAX_LINES={SINGLE_LINE:1,MULTI_LINE:2};
O.prototype.init=function(){this.setAggregation('_textControl',new sap.m.Text());};
O.prototype._getUpdatedTextControl=function(){var a=this.getAggregation('customContent')||this.getAggregation('_textControl'),t=this.getTitle(),T=this.getAggregation('customContent')?this.getAggregation('customContent').getText():this.getText(),s=this.getTextDirection(),p=this.getParent(),P=sap.ui.getCore().getConfiguration().getRTL(),m=O.MAX_LINES.MULTI_LINE,w=true,o='';if(s===sap.ui.core.TextDirection.LTR&&P){o='\u200e';}if(s===sap.ui.core.TextDirection.RTL&&!P){o='\u200f';}T=o+T+o;if(t){T=t+": "+T;}a.setProperty('text',T,true);if(p instanceof sap.m.ObjectListItem){w=false;m=O.MAX_LINES.SINGLE_LINE;}this._setControlWrapping(a,w,m);return a;};
O.prototype._setControlWrapping=function(a,w,m){if(a instanceof sap.m.Link){a.setProperty('wrapping',w,true);}if(a instanceof sap.m.Text){a.setProperty('maxLines',m,true);}};
O.prototype.ontap=function(e){if(this._isSimulatedLink()&&(e.target.id!=this.getId())){this.firePress({domRef:this.getDomRef()});}};
O.prototype.onsapenter=function(e){if(this._isSimulatedLink()){this.firePress({domRef:this.getDomRef()});e.setMarked();}};
O.prototype.onsapspace=function(e){this.onsapenter(e);};
O.prototype._isEmpty=function(){if(this.getAggregation('customContent')&&!(this.getAggregation('customContent')instanceof sap.m.Link||this.getAggregation('customContent')instanceof sap.m.Text)){q.sap.log.warning("Only sap.m.Link or sap.m.Text are allowed in \"sap.m.ObjectAttribute.customContent\" aggregation");return true;}return!(this.getText().trim()||this.getTitle().trim());};
O.prototype.ontouchstart=function(e){if(this._isSimulatedLink()){e.originalEvent._sapui_handledByControl=true;}};
O.prototype.getPopupAnchorDomRef=function(){return this.getDomRef("text");};
O.prototype._isSimulatedLink=function(){return(this.getActive()&&this.getText()!=="")&&!this.getAggregation('customContent');};
return O;},true);
sap.ui.predefine('sap/m/ObjectAttributeRenderer',['jquery.sap.global'],function(q){"use strict";var O={};
O.render=function(r,o){var p=o.getParent(),t=o.getTooltip_AsString();if(o._isEmpty()){return;}r.write("<div");r.writeControlData(o);r.addClass("sapMObjectAttributeDiv");if(o._isSimulatedLink()){r.addClass("sapMObjectAttributeActive");r.writeAttribute("tabindex","0");r.writeAccessibilityState(o,{role:"link"});}r.writeClasses();if(t){r.writeAttributeEscaped("title",t);}r.write(">");if(o.getActive()||(p instanceof sap.m.ObjectHeader)){this.renderActiveTitle(r,o);this.renderActiveText(r,o,p);}else{r.renderControl(o._getUpdatedTextControl());}r.write("</div>");};
O.renderActiveTitle=function(r,o){if(!o.getProperty("title")){return;}r.write("<span id=\""+o.getId()+"-title\"");r.addClass("sapMObjectAttributeTitle");r.writeClasses();r.write(">");r.writeEscaped(o.getProperty("title"));r.write("</span>");r.write("<span id=\""+o.getId()+"-colon\"");r.addClass("sapMObjectAttributeColon");r.writeClasses();r.write(">");r.write(":&nbsp;");r.write("</span>");};
O.renderActiveText=function(r,o,p){var t=o.getTextDirection(),a=o.getAggregation("customContent");r.write("<span id=\""+o.getId()+"-text\"");r.addClass("sapMObjectAttributeText");if(t&&t!==sap.ui.core.TextDirection.Inherit){r.writeAttribute("dir",t.toLowerCase());}r.writeClasses();r.write(">");if(a&&p){if((p instanceof sap.m.ObjectHeader)&&!o.getParent().getResponsive()){o._setControlWrapping(a,true,sap.m.ObjectAttribute.MAX_LINES.MULTI_LINE);}else{o._setControlWrapping(a,false,sap.m.ObjectAttribute.MAX_LINES.SINGLE_LINE);}r.renderControl(a);}else{r.writeEscaped(o.getProperty("text"));}r.write("</span>");};
return O;},true);
sap.ui.predefine('sap/m/ObjectHeader',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/IconPool'],function(q,l,C,I){"use strict";
var O=C.extend("sap.m.ObjectHeader",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Misc",defaultValue:null},number:{type:"string",group:"Misc",defaultValue:null},numberUnit:{type:"string",group:"Misc",defaultValue:null},intro:{type:"string",group:"Misc",defaultValue:null},introActive:{type:"boolean",group:"Misc",defaultValue:null},titleActive:{type:"boolean",group:"Misc",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconActive:{type:"boolean",group:"Misc",defaultValue:null},iconAlt:{type:"string",group:"Accessibility",defaultValue:null},iconTooltip:{type:"string",group:"Accessibility",defaultValue:null},iconDensityAware:{type:"boolean",group:"Misc",defaultValue:true},markFavorite:{type:"boolean",group:"Misc",defaultValue:false,deprecated:true},markFlagged:{type:"boolean",group:"Misc",defaultValue:false,deprecated:true},showMarkers:{type:"boolean",group:"Misc",defaultValue:false,deprecated:true},showTitleSelector:{type:"boolean",group:"Misc",defaultValue:false},numberState:{type:"sap.ui.core.ValueState",group:"Misc",defaultValue:sap.ui.core.ValueState.None},condensed:{type:"boolean",group:"Appearance",defaultValue:false},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance"},responsive:{type:"boolean",group:"Behavior",defaultValue:false},fullScreenOptimized:{type:"boolean",group:"Appearance",defaultValue:false},titleHref:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},titleTarget:{type:"string",group:"Behavior",defaultValue:null},introHref:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},introTarget:{type:"string",group:"Behavior",defaultValue:null},titleTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit},introTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit},numberTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit},titleSelectorTooltip:{type:"string",group:"Misc",defaultValue:"Options"},titleLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:sap.ui.core.TitleLevel.H1}},defaultAggregation:"attributes",aggregations:{attributes:{type:"sap.m.ObjectAttribute",multiple:true,singularName:"attribute"},firstStatus:{type:"sap.m.ObjectStatus",multiple:false,deprecated:true},secondStatus:{type:"sap.m.ObjectStatus",multiple:false,deprecated:true},statuses:{type:"sap.ui.core.Control",multiple:true,singularName:"status"},_objectNumber:{type:"sap.m.ObjectNumber",multiple:false,visibility:"hidden"},additionalNumbers:{type:"sap.m.ObjectNumber",multiple:true,singularName:"additionalNumber"},headerContainer:{type:"sap.m.ObjectHeaderContainer",multiple:false},markers:{type:"sap.m.ObjectMarker",multiple:true,singularName:"marker"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{titlePress:{parameters:{domRef:{type:"object"}}},introPress:{parameters:{domRef:{type:"object"}}},iconPress:{parameters:{domRef:{type:"object"}}},titleSelectorPress:{parameters:{domRef:{type:"object"}}}}}});
O.prototype.init=function(){var L=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._oTitleArrowIcon=I.createControlByURI({id:this.getId()+"-titleArrow",src:I.getIconURI("arrow-down"),decorative:false,visible:false,tooltip:L.getText("OH_SELECT_ARROW_TOOLTIP"),size:"1.375rem",press:function(e){}});this._fNumberWidth=undefined;this._titleText=new sap.m.Text(this.getId()+"-titleText");this._titleText.setMaxLines(3);};
O.prototype.insertAttribute=function(a,i){var r=this.insertAggregation("attributes",a,i);this._registerControlListener(a);return r;};
O.prototype.addAttribute=function(a){var r=this.addAggregation("attributes",a);this._registerControlListener(a);return r;};
O.prototype.removeAttribute=function(a){var r=this.removeAggregation("attributes",a);this._deregisterControlListener(r);return r;};
O.prototype.removeAllAttributes=function(){var a=this.removeAllAggregation("attributes");a.forEach(this._deregisterControlListener,this);return a;};
O.prototype.destroyAttributes=function(){var a=this.getAggregation("attributes");if(a!==null){a.forEach(this._deregisterControlListener,this);}return this.destroyAggregation("attributes");};
O.prototype.insertStatus=function(s,i){var r=this.insertAggregation("statuses",s,i);this._registerControlListener(s);return r;};
O.prototype.addStatus=function(s){var r=this.addAggregation("statuses",s);this._registerControlListener(s);return r;};
O.prototype.removeStatus=function(s){var r=this.removeAggregation("statuses",s);this._deregisterControlListener(r);return r;};
O.prototype.removeAllStatuses=function(){var s=this.removeAllAggregation("statuses");s.forEach(this._deregisterControlListener,this);return s;};
O.prototype.destroyStatuses=function(){var s=this.getAggregation("statuses");if(s!==null){s.forEach(this._deregisterControlListener,this);}return this.destroyAggregation("statuses");};
O.prototype._registerControlListener=function(c){if(c){c.attachEvent("_change",this.invalidate,this);}};
O.prototype._deregisterControlListener=function(c){if(c){c.detachEvent("_change",this.invalidate,this);}};
O.prototype.setCondensed=function(c){this.setProperty("condensed",c);if(this.getCondensed()){this._oTitleArrowIcon.setSize("1rem");}else{this._oTitleArrowIcon.setSize("1.375rem");}return this;};
O.prototype.setNumber=function(n){this.setProperty("number",n);this._getObjectNumber().setNumber(n);return this;};
O.prototype.setNumberUnit=function(u){this.setProperty("numberUnit",u);this._getObjectNumber().setUnit(u);return this;};
O.prototype.setNumberState=function(s){this.setProperty("numberState",s,true);this._getObjectNumber().setState(s);return this;};
O.prototype.setTitleSelectorTooltip=function(t){this.setProperty("titleSelectorTooltip",t,false);this._oTitleArrowIcon.setTooltip(t);return this;};
O.prototype.setMarkFavorite=function(m){return this._setOldMarkers(sap.m.ObjectMarkerType.Favorite,m);};
O.prototype.setMarkFlagged=function(m){return this._setOldMarkers(sap.m.ObjectMarkerType.Flagged,m);};
O.prototype.setShowMarkers=function(m){var M,a=this.getMarkers(),i;this.setProperty("showMarkers",m,false);for(i=0;i<a.length;i++){M=a[i].getType();if((M===sap.m.ObjectMarkerType.Flagged&&this.getMarkFlagged())||(M===sap.m.ObjectMarkerType.Favorite&&this.getMarkFavorite())){a[i].setVisible(m);}}return this;};
O.prototype._setOldMarkers=function(m,M){var a=this.getMarkers(),h=false,i,o={Flagged:"-flag",Favorite:"-favorite"};this.setProperty("mark"+m,M,false);if(!this.getShowMarkers()){M=false;}for(i=0;i<a.length;i++){if(a[i].getType()===m){h=true;a[i].setVisible(M);break;}}if(!h){this.insertAggregation("markers",new sap.m.ObjectMarker({id:this.getId()+o[m],type:m,visible:M}));}return this;};
O.prototype._getVisibleMarkers=function(){var a=this.getMarkers(),v=[],i;for(i=0;i<a.length;i++){if(a[i].getVisible()){v.push(a[i]);}}return v;};
O.prototype._getObjectNumber=function(){var c=this.getAggregation("_objectNumber");if(!c){c=new sap.m.ObjectNumber(this.getId()+"-number",{emphasized:false});this.setAggregation("_objectNumber",c,true);}return c;};
O.prototype.getFocusDomRef=function(){if(this.getResponsive()){return this.$("txt");}else{return this.$("title");}};
O.prototype.ontap=function(e){var s=e.target.id;if(this.getIntroActive()&&s===this.getId()+"-intro"){if(!this.getIntroHref()){this.fireIntroPress({domRef:q.sap.domById(s)});}}else if(!this.getResponsive()&&this.getTitleActive()&&(s===this.getId()+"-title"||q(e.target).parent().attr('id')===this.getId()+"-title"||s===this.getId()+"-titleText-inner")){if(!this.getTitleHref()){e.preventDefault();s=this.getId()+"-title";this.fireTitlePress({domRef:q.sap.domById(s)});}}else if(this.getResponsive()&&this.getTitleActive()&&(s===this.getId()+"-txt"||q(e.target).parent().attr('id')===this.getId()+"-txt")){if(!this.getTitleHref()){e.preventDefault();s=this.getId()+"-txt";this.fireTitlePress({domRef:q.sap.domById(s)});}}else if(this.getIconActive()&&(s===this.getId()+"-img"||s===this.getId()+"-icon")){this.fireIconPress({domRef:q.sap.domById(s)});}else if(s===this.getId()+"-titleArrow"){this.fireTitleSelectorPress({domRef:q.sap.domById(s)});}};
O.prototype._handleSpaceOrEnter=function(e){var s=e.target.id;e.setMarked();if(!this.getResponsive()&&this.getTitleActive()&&(s===this.getId()+"-title"||q(e.target).parent().attr('id')===this.getId()+"-title"||s===this.getId()+"-titleText-inner")){if(e.type==="sapspace"){e.preventDefault();}s=this.getId()+"-title";if(!this.getTitleHref()){e.preventDefault();this.fireTitlePress({domRef:q.sap.domById(s)});}else{if(e.type==="sapspace"){this._linkClick(e,s);}}}else if(this.getResponsive()&&this.getTitleActive()&&(s===this.getId()+"-txt"||q(e.target).parent().attr('id')===this.getId()+"-txt")){if(e.type==="sapspace"){e.preventDefault();}s=this.getId()+"-txt";if(!this.getTitleHref()){e.preventDefault();this.fireTitlePress({domRef:q.sap.domById(s)});}else{if(e.type==="sapspace"){this._linkClick(e,s);}}}else if(this.getIntroActive()&&s===this.getId()+"-intro"){if(e.type==="sapspace"){e.preventDefault();}if(!this.getIntroHref()){this.fireIntroPress({domRef:q.sap.domById(s)});}}else if(this.getIconActive()&&q(e.target).is('.sapMOHIcon,.sapMOHRIcon')){if(e.type==="sapspace"){e.preventDefault();}var i=q.sap.domById(this.getId()+"-icon");if(!i){i=q.sap.domById(this.getId()+"-img");}this.fireIconPress({domRef:i});}else if(s===this.getId()+"-titleArrow"){if(e.type==="sapspace"){e.preventDefault();}this.fireTitleSelectorPress({domRef:q.sap.domById(s)});}};
O.prototype.onsapspace=O.prototype._handleSpaceOrEnter;O.prototype.onsapenter=O.prototype._handleSpaceOrEnter;
O.prototype._linkClick=function(e,s){e.setMarked();var c=document.createEvent('MouseEvents');c.initEvent('click',false,true);q.sap.domById(s).dispatchEvent(c);};
O.prototype._onOrientationChange=function(){var i=this.getId();if(sap.ui.Device.system.tablet&&this.getFullScreenOptimized()&&(this._hasAttributes()||this._hasStatus())){this._rerenderStates();}if(sap.ui.Device.system.phone){if(sap.ui.Device.orientation.portrait){if(this.getTitle().length>50){this._rerenderTitle(50);}if(this.getIcon()){q.sap.byId(i+"-titlediv").removeClass("sapMOHRTitleIcon");q.sap.byId(i+"-titleIcon").addClass("sapMOHRHideIcon");}}else{if(sap.ui.Device.orientation.landscape){if(this.getTitle().length>80){this._rerenderTitle(80);}if(this.getIcon()){q.sap.byId(i+"-titlediv").addClass("sapMOHRTitleIcon");q.sap.byId(i+"-titleIcon").removeClass("sapMOHRHideIcon");}}}this._adjustNumberDiv();}this._adjustIntroDiv();};
O.prototype._rerenderTitle=function(n){var r=sap.ui.getCore().createRenderManager();this.getRenderer()._rerenderTitle(r,this,n);r.destroy();};
O.prototype._rerenderStates=function(){var r=sap.ui.getCore().createRenderManager();this.getRenderer()._rerenderResponsiveStates(r,this);r.destroy();};
O.prototype.exit=function(){if(!sap.ui.Device.system.phone){this._detachMediaContainerWidthChange(this._rerenderOHR,this,sap.ui.Device.media.RANGESETS.SAP_STANDARD);}if(sap.ui.Device.system.tablet||sap.ui.Device.system.phone){sap.ui.Device.orientation.detachHandler(this._onOrientationChange,this);}if(this._oImageControl){this._oImageControl.destroy();this._oImageControl=undefined;}if(this._oTitleArrowIcon){this._oTitleArrowIcon.destroy();this._oTitleArrowIcon=undefined;}if(this._titleText){this._titleText.destroy();this._titleText=undefined;}if(this._introText){this._introText.destroy();this._introText=undefined;}};
O.prototype._getImageControl=function(){var i=this.getId()+"-img";var s="2.5rem";var p=q.extend({src:this.getIcon(),tooltip:this.getIconTooltip(),alt:this.getIconAlt(),useIconTooltip:false,densityAware:this.getIconDensityAware()},I.isIconURI(this.getIcon())?{size:s}:{});this._oImageControl=sap.m.ImageHelper.getImageControl(i,this._oImageControl,this,p);return this._oImageControl;};
O.prototype.onBeforeRendering=function(){if(sap.ui.Device.system.tablet||sap.ui.Device.system.phone){sap.ui.Device.orientation.detachHandler(this._onOrientationChange,this);}if(!sap.ui.Device.system.phone){this._detachMediaContainerWidthChange(this._rerenderOHR,this,sap.ui.Device.media.RANGESETS.SAP_STANDARD);}if(this._introText){this._introText.destroy();this._introText=undefined;}};
O.prototype.onAfterRendering=function(){var o=this.getAggregation("_objectNumber");var p=sap.ui.getCore().getConfiguration().getRTL();var $=this.$("titleArrow");$.attr("role","button");if(this.getResponsive()){this._adjustIntroDiv();if(o&&o.getNumber()){if(sap.ui.Device.system.desktop&&q('html').hasClass("sapUiMedia-Std-Desktop")&&this.getFullScreenOptimized()&&this._iCountVisAttrStat>=1&&this._iCountVisAttrStat<=3){o.setTextAlign(p?sap.ui.core.TextAlign.Right:sap.ui.core.TextAlign.Left);}else{o.setTextAlign(p?sap.ui.core.TextAlign.Left:sap.ui.core.TextAlign.Right);}}this._adjustNumberDiv();if(sap.ui.Device.system.tablet||sap.ui.Device.system.phone){sap.ui.Device.orientation.attachHandler(this._onOrientationChange,this);}if(!sap.ui.Device.system.phone){this._attachMediaContainerWidthChange(this._rerenderOHR,this,sap.ui.Device.media.RANGESETS.SAP_STANDARD);}}else{var t=p?sap.ui.core.TextAlign.Left:sap.ui.core.TextAlign.Right;if(o&&o.getNumber()){o.setTextAlign(t);}if(this.getAdditionalNumbers()){this._setTextAlignANum(t);}}};
O.prototype._rerenderOHR=function(){this.invalidate();};
O.prototype._adjustNumberDiv=function(){var i=this.getId();var o=this.getAggregation("_objectNumber");var p=sap.ui.getCore().getConfiguration().getRTL();if(o&&o.getNumber()){var $=q.sap.byId(i+"-number");var a=q.sap.byId(i+"-titlediv");if(this._isMediaSize("Phone")){if($.hasClass("sapMObjectNumberBelowTitle")){o.setTextAlign(p?sap.ui.core.TextAlign.Left:sap.ui.core.TextAlign.Right);$.removeClass("sapMObjectNumberBelowTitle");a.removeClass("sapMOHRTitleDivFull");}var n=$.parent().width()*0.4;if($.outerWidth()>n){o.setTextAlign(p?sap.ui.core.TextAlign.Right:sap.ui.core.TextAlign.Left);$.addClass("sapMObjectNumberBelowTitle");a.addClass("sapMOHRTitleDivFull");}}}};
O.prototype._adjustIntroDiv=function(){var i=this.getId();var $=q.sap.byId(i+"-txt");var a=q.sap.byId(i+"-titleArrow");var b=q.sap.byId(i+"-intro");if(b.parent().hasClass("sapMOHRIntroMargin")){b.parent().removeClass("sapMOHRIntroMargin");}if(a.height()!==null&&($.height()<a.height())){b.parent().addClass("sapMOHRIntroMargin");}};
O._escapeId=function(i){return i?"#"+i.replace(/(:|\.)/g,'\\$1'):"";};
O.prototype._hasBottomContent=function(){return(this._hasAttributes()||this._hasStatus()||this._hasMarkers());};
O.prototype._hasIcon=function(){return!!this.getIcon().trim();};
O.prototype._hasAttributes=function(){var a=this.getAttributes();if(a&&a.length>0){for(var i=0;i<a.length;i++){if(!a[i]._isEmpty()){return true;}}}return false;};
O.prototype._hasStatus=function(){var h=((this.getFirstStatus()&&!this.getFirstStatus()._isEmpty())||(this.getSecondStatus()&&!this.getSecondStatus()._isEmpty()));if(!h&&this.getStatuses()&&this.getStatuses().length>0){var s=this.getStatuses();for(var i=0;i<s.length;i++){if(s[i]instanceof sap.m.ObjectStatus&&!s[i]._isEmpty()){h=true;break;}else if(s[i]instanceof sap.m.ProgressIndicator){h=true;break;}}}return h;};
O.prototype._hasMarkers=function(){var m=this.getMarkers(),h=this.getShowMarkers()&&(this.getMarkFavorite()||this.getMarkFlagged()),H=m&&m.length;return(h||H);};
O.prototype._getDefaultBackgroundDesign=function(){if(this.getCondensed()){return sap.m.BackgroundDesign.Solid;}else{if(this.getResponsive()){return sap.m.BackgroundDesign.Translucent;}else{return sap.m.BackgroundDesign.Transparent;}}};
O.prototype._getBackground=function(){if(this.getBackgroundDesign()===undefined){return this._getDefaultBackgroundDesign();}else{return this.getBackgroundDesign();}};
O.prototype._setTextAlignANum=function(t){var n=this.getAdditionalNumbers();for(var i=0;i<n.length;i++){n[i].setTextAlign(t);}};
O.prototype._isMediaSize=function(r){return this._getCurrentMediaContainerRange(sap.ui.Device.media.RANGESETS.SAP_STANDARD).name===r;};
return O;},true);
sap.ui.predefine('sap/m/ObjectHeaderRenderer',['jquery.sap.global','sap/ui/core/IconPool'],function(q,I){"use strict";var O={};
O._isEmptyObject=function(o){if(!o){return true;}if((!o._isEmpty||!o._isEmpty())&&(!o.getVisible||o.getVisible())){return false;}return true;};
O._isEmptyArray=function(a){if(a){for(var i=0;i<a.length;i++){if(!O._isEmptyObject(a[i])){return false;}}}return true;};
O._isEmptyRow=function(l,r){return O._isEmptyObject(l)&&O._isEmptyArray(r);};
O._renderObjects=function(r,o,a){for(var i=0;i<o.length;i++){if(o[i]instanceof sap.ui.core.Control){this._renderChildControl(r,a,o[i]);}}};
O._computeChildControlsToBeRendered=function(o){o.__controlsToBeRendered={};var c=o.getAttributes();for(var i=0;i<c.length;i++){o.__controlsToBeRendered[c[i].getId()]=c[i];}c=o.getStatuses();for(var i=0;i<c.length;i++){o.__controlsToBeRendered[c[i].getId()]=c[i];}var C=o.getFirstStatus();if(C){o.__controlsToBeRendered[C.getId()]=C;}C=o.getSecondStatus();if(C){o.__controlsToBeRendered[C.getId()]=C;}C=o.getAggregation("_objectNumber");if(C){o.__controlsToBeRendered[C.getId()]=C;}};
O._cleanupNotRenderedChildControls=function(r,o){for(var i in o.__controlsToBeRendered){r.cleanupControlWithoutRendering(o.__controlsToBeRendered[i]);}delete o.__controlsToBeRendered;};
O._getMarkers=function(o){return o._getVisibleMarkers();};
O._renderIntro=function(r,o,i,s){if(o.getIntroActive()){o._introText=new sap.m.Link(o.getId()+"-intro");o._introText.setText(o.getIntro());o._introText.setHref(o.getIntroHref());o._introText.setTarget(o.getIntroTarget());o._introText.press=o.introPress;}else{o._introText=new sap.m.Text(o.getId()+"-intro");o._introText.setText(o.getIntro());o._introText.setMaxLines(3);}o._introText.setTextDirection(o.getIntroTextDirection());r.write("<div");r.addClass(i);if(o.getIntroActive()){r.addClass(s);}r.writeClasses();r.write(">");this._renderChildControl(r,o,o._introText);r.write("</div>");};
O._renderAttribute=function(r,o,a,f){r.write("<div");r.addClass("sapMOHAttr");r.writeClasses();if(f){r.addStyle("width","100%");r.writeStyles();}r.write(">");this._renderChildControl(r,o,a);r.write("</div>");};
O._getVisibleStatuses=function(o){var v=[];if(o.getFirstStatus()&&o.getFirstStatus().getVisible()){v.push([o.getFirstStatus()]);}if(o.getSecondStatus()&&o.getSecondStatus().getVisible()){v.push([o.getSecondStatus()]);}if(o.getStatuses()){var s=o.getStatuses();for(var i=0;i<s.length;i++){if(!s[i].getVisible||s[i].getVisible()){if(s[i]instanceof sap.m.ObjectStatus||s[i]instanceof sap.m.ProgressIndicator){v.push([s[i]]);}else{q.sap.log.warning("Only sap.m.ObjectStatus or sap.m.ProgressIndicator are allowed in \"sap.m.ObjectHeader.statuses\" aggregation."+" Current object is "+s[i].constructor.getMetadata().getName()+" with id \""+s[i].getId()+"\"");}}}}return v;};
O._getVisibleAttribsAndStatuses=function(o){var r=[],a=o.getAttributes(),v=[];for(var j=0;j<a.length;j++){if(a[j].getVisible()){v.push(a[j]);}}var V=this._getVisibleStatuses(o);r[0]=v;r[1]=V;return r;};
O._renderRow=function(r,o,l,R){if(O._isEmptyRow(l,R)){return;}r.write("<div");r.addClass("sapMOHAttrRow");r.writeClasses();r.write(">");if(!O._isEmptyObject(l)){this._renderAttribute(r,o,l,O._isEmptyArray(R));}else if(O._isEmptyObject(l)&&!O._isEmptyArray(R)){if(R[0]instanceof sap.m.ProgressIndicator){r.write("<div");r.addClass("sapMOHAttr");r.writeClasses();r.write(">");r.write("</div>");}}if(!O._isEmptyArray(R)){r.write("<div");if(R[0]instanceof sap.m.ProgressIndicator){r.addClass("sapMOHStatusFixedWidth");}else if(R[0]instanceof sap.m.ObjectMarker){r.addClass("sapMOHStatusFixedWidth");r.addClass("sapMObjStatusMarker");}else{r.addClass("sapMOHStatus");}r.writeClasses();r.write(">");O._renderObjects(r,R,o);r.write("</div>");}r.write("</div>");};
O._renderAttributesAndStatuses=function(r,o){var a=o.getAttributes();var v=[];for(var j=0;j<a.length;j++){if(a[j].getVisible()){v.push(a[j]);}}var A=v.length;var m=[];var M=O._getMarkers(o);if(!o.getResponsive()&&!O._isEmptyArray(M)){m.push(M);}var V=this._getVisibleStatuses(o);m=m.concat(V);var i=m.length;var n=A>i?A:i;if(!o.getResponsive()){for(var c=0;c<n;c++){this._renderRow(r,o,v[c],m[c]);}}};
O._renderNumber=function(r,o){var n=o.getAdditionalNumbers();if(!o.getNumber()&&(n&&!n.length)){return;}r.write("<div");r.writeAttribute("id",o.getId()+"-numberdiv");r.addClass("sapMOHNumberDiv");r.writeClasses();r.write(">");var a=o.getAggregation("_objectNumber");if(a&&a.getNumber()){a.setTextDirection(o.getNumberTextDirection());this._renderChildControl(r,o,a);}r.write("</div>");if(!o.getCondensed()){this._renderAdditionalNumbers(r,o);}};
O._renderAdditionalNumbers=function(r,o){var n=o.getAdditionalNumbers();if(n&&!n.length){return;}if(n.length===1){r.write("<div");r.addClass("additionalOHNumberSeparatorDiv");r.writeClasses();r.write("></div>");}for(var i=0;i<n.length;i++){r.write("<div");r.writeAttribute("id",o.getId()+"-additionalNumber"+i);r.addClass("sapMOHNumberDiv additionalOHNumberDiv");if(n.length===1){r.addClass("sapMOHOnlyANumber");}r.writeClasses();r.write(">");n[i].setTextDirection(o.getNumberTextDirection());this._renderChildControl(r,o,n[i]);r.write("</div>");}};
O._renderTitle=function(r,o){o._oTitleArrowIcon.setVisible(o.getShowTitleSelector());if(o.getShowTitleSelector()&&o._oTitleArrowIcon.getVisible()){r.write("<div");r.addClass("sapMOHTitleAndArrow");r.writeClasses();r.write(">");}if(o.getTitle()){var t=(o.getTitleLevel()===sap.ui.core.TitleLevel.Auto)?sap.ui.core.TitleLevel.H1:o.getTitleLevel();o._titleText.setText(o.getTitle());o._titleText.setTextDirection(o.getTitleTextDirection());if(o.getTitleActive()){r.write("<a");if(o.getTitleHref()){r.writeAttributeEscaped("href",o.getTitleHref());if(o.getTitleTarget()){r.writeAttributeEscaped("target",o.getTitleTarget());}}else{r.writeAttribute("href","#");}r.writeAccessibilityState({role:"link",haspopup:!o.getTitleHref()});}else{r.write("<div");}r.writeAttribute("id",o.getId()+"-title");r.addClass("sapMOHTitle");if(o.getTitleActive()){r.writeAttribute("tabindex","0");r.addClass("sapMOHTitleActive");}if(o.getShowTitleSelector()){r.addClass("sapMOHTitleFollowArrow");}r.writeClasses();r.write(">");r.write("<"+t+">");this._renderChildControl(r,o,o._titleText);r.write("</"+t+">");if(o.getTitleActive()){r.write("</a>");}else{r.write("</div>");}}if(o.getShowTitleSelector()){r.write("<span");r.addClass("sapMOHTitleArrow");r.writeClasses();r.write(">");this._renderChildControl(r,o,o._oTitleArrowIcon);r.write("</span>");}if(o.getShowTitleSelector()&&o._oTitleArrowIcon.getVisible()){r.write("</div>");}};
O._renderFullTitle=function(r,o){var n=o.getAdditionalNumbers();if(!o.getNumber()&&(n&&!n.length)){r.addClass("sapMOHTitleDivFull");}};
O._renderFullOH=function(r,o){var l=sap.ui.getCore().getLibraryResourceBundle("sap.m");if(o.getIntro()){this._renderIntro(r,o,"sapMOHIntro","sapMOHIntroActive");}r.write("<div");r.addClass("sapMOHTopRow");r.writeClasses();r.write(">");r.write("<div");r.writeAttribute("id",o.getId()+"-titlediv");r.addClass("sapMOHTitleDiv");if(o._hasIcon()){r.addClass("sapMOHTitleIcon");}this._renderFullTitle(r,o);r.writeClasses();r.write(">");if(o._hasIcon()){r.write("<div");r.addClass("sapMOHIcon");if(o.getIconActive()){r.writeAttribute("tabindex","0");r.addClass("sapMPointer");r.writeAccessibilityState({role:"link",haspopup:true,label:l.getText("OH_ARIA_ICON")});}r.writeClasses();r.write(">");this._renderChildControl(r,o,o._getImageControl());r.write("</div>");}this._renderTitle(r,o);r.write("</div>");this._renderNumber(r,o);r.write("<div class=\"sapMOHDivider\"></div>");r.write("</div>");if(o._hasBottomContent()){r.write("<div");r.addClass("sapMOHBottomRow");r.writeClasses();r.write(">");this._renderAttributesAndStatuses(r,o);r.write("<div class=\"sapMOHDivider\"></div>");r.write("</div>");}};
O._renderCondensedOH=function(r,o){r.write("<div");r.writeAttribute("id",o.getId()+"-titlediv");r.addClass("sapMOHTitleDiv");this._renderFullTitle(r,o);r.writeClasses();r.write(">");this._renderTitle(r,o);r.write("</div>");this._renderNumber(r,o);var f=o.getAttributes()[0];if(f&&!f._isEmpty()){this._renderAttribute(r,o,f);}};
O.render=function(r,o){if(o.getResponsive()){this._renderResponsive(r,o);return;}this._computeChildControlsToBeRendered(o);var c=o.getCondensed();r.write("<div");r.writeControlData(o);r.addClass("sapMOH");if(o._getBackground()!==sap.m.BackgroundDesign.Transparent){r.addClass("sapContrastPlus");}if(c){r.addClass("sapMOHC");}r.addClass("sapMOHBg"+o._getBackground());r.writeClasses();var t=o.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}r.writeAccessibilityState({role:"region",labelledby:{value:o.getId()+"-titleText-inner",append:true}});r.write(">");if(c){this._renderCondensedOH(r,o);}else{this._renderFullOH(r,o);}r.write("<div class=\"sapMOHLastDivider\"></div>");r.write("</div>");this._cleanupNotRenderedChildControls(r,o);};
O._renderChildControl=function(r,o,c){r.renderControl(c);if(!o.getResponsive()&&o.__controlsToBeRendered){o.__controlsToBeRendered[c.getId()]=undefined;}};
O._renderResponsive=function(r,o){var s=this._hasResponsiveStates(o),t=this._hasResponsiveTabs(o),h=o.getHeaderContainer();r.write("<div");r.addClass("sapMOHROuter");r.writeClasses();var T=o.getTooltip_AsString();if(T){r.writeAttributeEscaped("title",T);}r.writeAccessibilityState({role:"region",labelledby:{value:o.getId()+"-txt",append:true}});r.writeControlData(o);r.write(">");r.write("<div");r.addClass("sapMOHR");if(o._getBackground()!==sap.m.BackgroundDesign.Transparent){r.addClass("sapContrastPlus");}if(t){r.addClass("sapMOHRNoBorder");}r.addClass("sapMOHRBg"+o._getBackground());r.writeClasses();r.write(">");r.write("<div");if(sap.ui.Device.system.desktop&&o._isMediaSize("Desktop")&&o.getFullScreenOptimized()&&o._iCountVisAttrStat>=1&&o._iCountVisAttrStat<=3){r.addClass("sapMOHRStatesOneOrThree");}r.writeClasses();r.write(">");this._renderResponsiveTitleBlock(r,o);if(s){this._renderResponsiveStates(r,o);}r.write("</div>");if(t){this._renderResponsiveTabs(r,o);}r.write("</div>");if(h&&h instanceof sap.m.IconTabBar){this._renderChildControl(r,o,h);}r.write("</div>");if(!o.getTitle()){if(!o.getBinding("title")){q.sap.log.warning("The title shouldn't be empty!");}}};
O._renderResponsiveTitleBlock=function(r,c){var l=sap.ui.getCore().getLibraryResourceBundle("sap.m");r.write("<div");r.writeAttribute("id",c.getId()+"-titlenumdiv");r.addClass("sapMOHRTitleNumberDiv");r.writeClasses();r.write(">");r.write("<div");r.writeAttribute("id",c.getId()+"-titlediv");r.addClass("sapMOHRTitleDiv");if(c._hasIcon()){if(sap.ui.Device.system.phone||c._isMediaSize("Phone")){if(sap.ui.Device.orientation.landscape||(c._isMediaSize("Phone")&&!sap.ui.Device.system.phone)){r.addClass("sapMOHRTitleIcon");}}else{r.addClass("sapMOHRTitleIcon");}}if(!c.getNumber()){r.addClass("sapMOHRTitleDivFull");}r.writeClasses();r.write(">");this._renderResponsiveTitle(r,c);if(c._hasIcon()){r.write("<div");r.writeAttribute("id",c.getId()+"-titleIcon");r.addClass("sapMOHRIcon");if((sap.ui.Device.system.phone&&sap.ui.Device.orientation.portrait)){r.addClass("sapMOHRHideIcon");}if(c.getIconActive()){r.addClass("sapMPointer");r.writeAttribute("tabindex","0");r.writeAccessibilityState({role:"link",haspopup:true,label:l.getText("OH_ARIA_ICON")});}r.writeClasses();r.write(">");this._renderChildControl(r,c,c._getImageControl());r.write("</div>");}r.write("</div>");this._renderResponsiveNumber(r,c);r.write("</div>");};
O._renderResponsiveStates=function(r,c){r.write("<div");r.writeAttribute("id",c.getId()+"-states");r.addClass("sapMOHRStates");r.writeClasses();r.write(">");this._renderResponsiveRow(r,c);r.write("</div>");};
O._renderResponsiveRow=function(r,o){var v=[];v=this._getVisibleAttribsAndStatuses(o);var V=v[0].concat(v[1]),c=v[0].length,C=V.length,R=1,s='';if(C===0){return;}if(sap.ui.Device.system.desktop){if(!o.getFullScreenOptimized()){if(C>=1&&C<=4){R=2;s='sapMOHRTwoCols';}if(C>=5){R=3;s='sapMOHRThreeCols';}}else{if(C>=1&&C<=3){R=1;s='sapMOHROneCols';}if(C>=4){R=4;s='sapMOHRFourCols';}}}if((sap.ui.Device.system.tablet&&!sap.ui.Device.system.desktop)||(sap.ui.Device.system.desktop&&o._isMediaSize("Tablet"))){if(!o.getFullScreenOptimized()||(sap.ui.Device.orientation.portrait&&o.getFullScreenOptimized())){R=2;s='sapMOHRTwoCols';}else{if(o.getFullScreenOptimized()&&(sap.ui.Device.orientation.landscape||(sap.ui.Device.system.desktop&&o._isMediaSize("Tablet")))){if(C>=1&&C<=2){R=2;s='sapMOHRTwoCols';}if(C>=3){R=3;s='sapMOHRThreeCols';}}}}if(sap.ui.Device.system.phone||(sap.ui.Device.system.desktop&&o._isMediaSize("Phone"))){R=1;s='sapMOHROneCols';}this._renderResponsiveStatesColumn(r,o,R,V,c,s);};
O._renderResponsiveStatesColumn=function(r,o,R,v,c,C){var a=Math.floor(v.length/R);var b=v.length%R;var d=0;var e=1;for(var i=0;i<v.length;i++){if(d==0){r.write("<div");r.addClass("sapMOHRStatesCont"+e);r.addClass(C);r.writeClasses();r.write(">");}if(i<c){this._renderResponsiveAttribute(r,o,v[i]);}else{this._renderResponsiveStatus(r,o,v[i]);}d++;if((d==a&&e>b)||(d==(a+1)&&e<=b)||i==v.length-1){r.write("</div>");d=0;e++;}}};
O._renderResponsiveAttribute=function(r,o,a){r.write("<div");r.addClass("sapMOHRAttr");r.writeClasses();r.write(">");this._renderChildControl(r,o,a);r.write("</div>");};
O._renderResponsiveStatus=function(r,o,s){r.write("<div");r.addClass("sapMOHRStatus");r.writeClasses();r.write(">");this._renderChildControl(r,o,s[0]);r.write("</div>");};
O._renderResponsiveMarkers=function(r,c){var m=[],t=c.getTitleTextDirection(),p=sap.ui.getCore().getConfiguration().getRTL();m=c._getVisibleMarkers();r.write("<span");r.addClass("sapMObjStatusMarker");if((t===sap.ui.core.TextDirection.LTR&&p)||(t===sap.ui.core.TextDirection.RTL&&!p)){r.addClass("sapMObjStatusMarkerOpposite");}r.writeClasses();r.writeAttribute("id",c.getId()+"-markers");r.write(">");for(var i=0;i<m.length;i++){this._renderChildControl(r,c,m[i]);}r.write("</span>");};
O._renderResponsiveNumber=function(r,c){var o=c.getAggregation("_objectNumber");if(o&&o.getNumber()){o.setTextDirection(c.getNumberTextDirection());this._renderChildControl(r,c,o);}};
O._hasResponsiveStates=function(c){var a=c.getAttributes(),v=[];if(!(c._hasAttributes()||c._hasStatus())){c._iCountVisAttrStat=0;return false;}for(var j=0;j<a.length;j++){if(a[j].getVisible()){v.push(a[j]);}}var V=this._getVisibleStatuses(c);c._iCountVisAttrStat=v.length+V.length;return!!(v.length+V.length);};
O._hasResponsiveTabs=function(c){var h=c.getHeaderContainer(),i;if(h){if(h instanceof sap.m.IconTabBar){i=h._getIconTabHeader();if(i.getVisible()){c._iCountVisTabs=i.getItems().length;return!!i.getItems().length;}}else if(h.getMetadata().getName()==="sap.m.HeaderContainer"){return!!h.getContent().length;}else if(h.getMetadata().getName()==="sap.suite.ui.commons.HeaderContainer"){return!!h.getItems().length;}}return false;};
O._renderResponsiveTabs=function(r,c){var h=c.getHeaderContainer(),i;r.write("<div class=\"sapMOHRTabs"+(h instanceof sap.m.IconTabBar?" sapMOHRTabsITB":"")+"\">");if(h){if(h instanceof sap.m.IconTabBar){i=h._getIconTabHeader();this._renderChildControl(r,c,i);h._bHideHeader=true;}else if(h.getMetadata().getName()==="sap.m.HeaderContainer"||h.getMetadata().getName()==="sap.suite.ui.commons.HeaderContainer"){this._renderChildControl(r,c,h);}else{q.sap.log.warning("The control "+h+" is not supported for aggregation \"headerContainer\"");}}r.write("</div>");};
O._renderResponsiveTitle=function(r,o){var n;o._oTitleArrowIcon.setVisible(o.getShowTitleSelector());r.write("<div");r.writeAttribute("id",o.getId()+"-title");r.addClass("sapMOHRTitle");if(o.getTitle().length&&o.getTitleActive()){r.addClass("sapMOHRTitleActive");}if(o.getShowTitleSelector()){r.addClass("sapMOHRTitleFollowArrow");}r.writeClasses();r.write(">");if((sap.ui.Device.system.phone&&sap.ui.Device.orientation.portrait)){n=50;}else{n=80;}r.write("<div");r.writeAttribute("id",o.getId()+"-title-arrow");r.addStyle("display","inline-block");r.writeStyles();r.write(">");this._renderResponsiveTitleAndArrow(r,o,n);r.write("</div>");if(o.getIntro()){this._renderIntro(r,o,"sapMOHRIntro","sapMOHRIntroActive");}r.write("</div>");};
O._rerenderTitle=function(r,o,n){var i=o.getId();this._renderResponsiveTitleAndArrow(r,o,n);r.flush(q.sap.byId(i+"-title-arrow"));};
O._renderResponsiveTitleAndArrow=function(r,o,n){var s,e='',t=o.getTitleTextDirection();var m=!!o._getVisibleMarkers().length;var T=(o.getTitleLevel()===sap.ui.core.TitleLevel.Auto)?sap.ui.core.TitleLevel.H1:o.getTitleLevel();r.write("<"+T+">");r.write("<span");r.addClass("sapMOHRTitleTextContainer");r.writeClasses();if(t!=sap.ui.core.TextDirection.Inherit){r.writeAttribute("dir",t.toLowerCase());}r.write(">");if(o.getTitle().length&&o.getTitleActive()){r.write("<a");if(o.getTitleHref()){r.writeAttributeEscaped("href",o.getTitleHref());if(o.getTitleTarget()){r.writeAttributeEscaped("target",o.getTitleTarget());}}else{r.writeAttribute("href","#");}r.writeAttribute("tabindex","0");r.writeAccessibilityState({role:"link",haspopup:!o.getTitleHref()});}else{r.write("<span");}r.writeAttribute("id",o.getId()+"-txt");r.addClass("sapMOHRTitleText");r.writeClasses();r.write(">");r.write("<span");r.addClass("sapMOHRTitleTextWrappable");r.writeClasses();r.write(">");if(o.getTitle().length>n){s=o.getTitle().substr(0,n).trim();e='...';}else{s=o.getTitle();}if(m){var a=s.substr(s.lastIndexOf(" ")+1);var b=s.substr(0,s.lastIndexOf(" ")+1);if(a.length===1){a=s;b='';}r.writeEscaped(b);r.write("</span>");r.writeEscaped(a);r.write(e);if(o.getTitleActive()){r.write("</a>");}else{r.write("</span>");}this._renderResponsiveMarkers(r,o);r.write("</span>");}else{if(!e){r.writeEscaped(s);}else{r.writeEscaped(s+e);}if(o.getTitleActive()){r.write("</span></a></span>");}else{r.write("</span></span></span>");}}if(o.getShowTitleSelector()){r.write("<span");r.addClass("sapMOHRTitleArrow");r.writeClasses();r.write(">");this._renderChildControl(r,o,o._oTitleArrowIcon);r.write("</span>");}r.write("</"+T+">");};
O._rerenderResponsiveStates=function(r,o){var i=o.getId(),v=this._getVisibleAttribsAndStatuses(o),V=v[0].concat(v[1]),c=v[0].length,C=V.length,R=1,s='';if(C===0){return;}if(sap.ui.Device.orientation.portrait){R=2;s='sapMOHRTwoCols';}else{if(C>=1&&C<=2){R=2;s='sapMOHRTwoCols';}if(C>=3){R=3;s='sapMOHRThreeCols';}}this._renderResponsiveStatesColumn(r,o,R,V,c,s);r.flush(q.sap.byId(i+"-states")[0]);};
return O;},true);
sap.ui.predefine('sap/m/ObjectIdentifier',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/IconPool','sap/ui/core/InvisibleText'],function(q,l,C,I,a){"use strict";
var O=C.extend("sap.m.ObjectIdentifier",{metadata:{library:"sap.m",designTime:true,properties:{title:{type:"string",group:"Misc",defaultValue:null},text:{type:"string",group:"Misc",defaultValue:null},badgeNotes:{type:"boolean",group:"Misc",defaultValue:null,deprecated:true},badgePeople:{type:"boolean",group:"Misc",defaultValue:null,deprecated:true},badgeAttachments:{type:"boolean",group:"Misc",defaultValue:null,deprecated:true},visible:{type:"boolean",group:"Appearance",defaultValue:true},titleActive:{type:"boolean",group:"Misc",defaultValue:false},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit}},aggregations:{_titleControl:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_textControl:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{titlePress:{parameters:{domRef:{type:"object"}}}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}}}});
O.prototype.init=function(){var L=sap.ui.getCore().getLibraryResourceBundle("sap.m");if(sap.ui.getCore().getConfiguration().getAccessibility()){O.OI_ARIA_ROLE=L.getText("OI_ARIA_ROLE");this._createAriaInfoTextControl();}};
O.prototype.exit=function(){if(this._attachmentsIcon){this._attachmentsIcon.destroy();this._attachmentsIcon=null;}if(this._peopleIcon){this._peopleIcon.destroy();this._peopleIcon=null;}if(this._notesIcon){this._notesIcon.destroy();this._notesIcon=null;}if(this._oAriaCustomRole){this._oAriaCustomRole.destroy();this._oAriaCustomRole=null;}};
O.prototype._getAttachmentsIcon=function(){if(!this._attachmentsIcon){this._attachmentsIcon=this._getIcon(I.getIconURI("attachment"),this.getId()+"-attachments");}return this._attachmentsIcon;};
O.prototype._getPeopleIcon=function(){if(!this._peopleIcon){this._peopleIcon=this._getIcon(I.getIconURI("group"),this.getId()+"-people");}return this._peopleIcon;};
O.prototype._getNotesIcon=function(){if(!this._notesIcon){this._notesIcon=this._getIcon(I.getIconURI("notes"),this.getId()+"-notes");}return this._notesIcon;};
O.prototype._getIcon=function(u,i){var s=sap.ui.Device.system.phone?"1em":"1em";var o;o=this._icon||I.createControlByURI({src:u,id:i+"-icon",size:s,useIconTooltip:false},sap.m.Image);o.setSrc(u);return o;};
O.prototype._getTitleControl=function(){var t=this.getAggregation("_titleControl");if(!t){if(this.getProperty("titleActive")){t=new sap.m.Link({id:this.getId()+"-link",text:this.getProperty("title"),ariaLabelledBy:this._oAriaCustomRole});}else{t=new sap.m.Text({id:this.getId()+"-txt",text:this.getProperty("title")});}this.setAggregation("_titleControl",t,true);}t.setVisible(!!this.getTitle());return t;};
O.prototype._updateTitleControl=function(i){var r,t=this.getAggregation("_titleControl");if(i&&t instanceof sap.m.Text){this.destroyAggregation("_titleControl",true);t=new sap.m.Link({id:this.getId()+"-link",text:this.getProperty("title"),ariaLabelledBy:this._oAriaCustomRole});this.setAggregation("_titleControl",t,true);}else if(!i&&t instanceof sap.m.Link){this.destroyAggregation("_titleControl",true);t=new sap.m.Text({id:this.getId()+"-txt",text:this.getProperty("title")});this.setAggregation("_titleControl",t,true);}if(this.$("title").children().length>0){t.setProperty("text",this.getProperty("title"),true);r=sap.ui.getCore().createRenderManager();r.renderControl(t);r.flush(this.$("title")[0]);r.destroy();}return t;};
O.prototype._getTextControl=function(){var t=this.getAggregation("_textControl");if(!t){t=new sap.m.Text({text:this.getProperty("text")});this.setAggregation("_textControl",t,true);}t.setTextDirection(this.getTextDirection());t.setVisible(!!this.getText());return t;};
O.prototype.setTitle=function(t){var T=this._getTitleControl();T.setProperty("text",t,false);T.setVisible(!!t);this.setProperty("title",t,true);this.$("text").toggleClass("sapMObjectIdentifierTextBellow",!!this.getProperty("text")&&!!this.getProperty("title"));return this;};
O.prototype.setText=function(t){this.setProperty("text",t,true);var T=this._getTextControl();T.setProperty("text",t,false);this.$("text").toggleClass("sapMObjectIdentifierTextBellow",!!this.getProperty("text")&&!!this.getProperty("title"));return this;};
O.prototype.setTitleActive=function(v){var p=this.getProperty("titleActive");if(p!=v){this.setProperty("titleActive",v,true);this._updateTitleControl(v);}return this;};
O.prototype._handlePress=function(e){var c=e.target;if(this.getTitleActive()&&this.$("title")[0].firstChild==c){this.fireTitlePress({domRef:c});e.setMarked();}};
O.prototype.onsapenter=function(e){O.prototype._handlePress.apply(this,arguments);};
O.prototype.onsapspace=function(e){O.prototype._handlePress.apply(this,arguments);};
O.prototype.ontap=function(e){O.prototype._handlePress.apply(this,arguments);};
O.prototype.addAssociation=function(A,i,s){var t=this.getAggregation("_titleControl");if(A==="ariaLabelledBy"){if(this.getTitleActive()&&t instanceof sap.m.Link){t.addAssociation("ariaLabelledBy",i,true);}}return C.prototype.addAssociation.apply(this,arguments);};
O.prototype.removeAssociation=function(A,o,s){var t=this.getAggregation("_titleControl");if(A==="ariaLabelledBy"){if(this.getTitleActive()&&t instanceof sap.m.Link){t.removeAssociation("ariaLabelledBy",o,true);}}return C.prototype.removeAssociation.apply(this,arguments);};
O.prototype._createAriaInfoTextControl=function(){if(!this._oAriaCustomRole){this._oAriaCustomRole=new a(this.getId()+"-oIHiddenText",{text:O.OI_ARIA_ROLE});}return this._oAriaCustomRole;};
return O;},true);
sap.ui.predefine('sap/m/ObjectIdentifierRenderer',['jquery.sap.global'],function(q){"use strict";var O={};
O.render=function(r,o){var t;if(!o.getVisible()){return;}r.write("<div");r.writeControlData(o);r.writeAccessibilityState(o);r.addClass("sapMObjectIdentifier");r.writeClasses();t=o.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}r.write(">");r.write("<div");r.addClass("sapMObjectIdentifierTopRow");r.writeClasses();r.write(">");r.write("<div");r.addClass("sapMObjectIdentifierIcons");r.writeClasses();r.write(">");if(o.getBadgeAttachments()){r.write("<span");r.addClass("sapMObjectIdentifierIconSpan");r.writeClasses();r.write(">");r.renderControl(o._getAttachmentsIcon());r.write("</span>");}if(o.getBadgeNotes()){r.write("<span");r.addClass("sapMObjectIdentifierIconSpan");r.writeClasses();r.write(">");r.renderControl(o._getNotesIcon());r.write("</span>");}if(o.getBadgePeople()){r.write("<span");r.addClass("sapMObjectIdentifierIconSpan");r.writeClasses();r.write(">");r.renderControl(o._getPeopleIcon());r.write("</span>");}r.write("</div>");r.write("<div id='"+o.getId()+"-title'");r.addClass("sapMObjectIdentifierTitle");r.writeClasses();r.write(">");r.renderControl(o._getTitleControl());r.renderControl(o._oAriaCustomRole);r.write("</div>");r.write("</div>");r.write("<div id='"+o.getId()+"-text'");r.addClass("sapMObjectIdentifierText");if(!!o.getProperty("text")&&!!o.getProperty("title")){r.addClass("sapMObjectIdentifierTextBellow");}r.writeClasses();r.write(">");r.renderControl(o._getTextControl());r.write("</div>");r.write("</div>");};
return O;},true);
sap.ui.predefine('sap/m/ObjectListItem.designtime',[],function(){"use strict";return{aggregations:{firstStatus:{domRef:":sap-domref .sapMObjLStatus1DivEmpty"},secondStatus:{domRef:":sap-domref .sapMObjLStatus2DivEmpty"},attributes:{domRef:":sap-domref .sapMObjLAttrDivEmpty"}}};},false);
sap.ui.predefine('sap/m/ObjectListItem',['jquery.sap.global','./ListItemBase','./library','sap/ui/core/IconPool','sap/m/ObjectNumber'],function(q,L,l,I,O){"use strict";
var a=L.extend("sap.m.ObjectListItem",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Misc",defaultValue:null},number:{type:"string",group:"Misc",defaultValue:null},numberUnit:{type:"string",group:"Misc",defaultValue:null},intro:{type:"string",group:"Misc",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},activeIcon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconDensityAware:{type:"boolean",group:"Misc",defaultValue:true},markFavorite:{type:"boolean",group:"Misc",defaultValue:null,deprecated:true},markFlagged:{type:"boolean",group:"Misc",defaultValue:null,deprecated:true},showMarkers:{type:"boolean",group:"Misc",defaultValue:null,deprecated:true},numberState:{type:"sap.ui.core.ValueState",group:"Misc",defaultValue:sap.ui.core.ValueState.None},titleTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit},introTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit},numberTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit},markLocked:{type:"boolean",group:"Misc",defaultValue:false,deprecated:true}},defaultAggregation:"attributes",aggregations:{attributes:{type:"sap.m.ObjectAttribute",multiple:true,singularName:"attribute"},firstStatus:{type:"sap.m.ObjectStatus",multiple:false},secondStatus:{type:"sap.m.ObjectStatus",multiple:false},markers:{type:"sap.m.ObjectMarker",multiple:true,singularName:"marker"},_objectNumber:{type:"sap.m.ObjectNumber",multiple:false,visibility:"hidden"}},designTime:true}});
a.prototype.init=function(e){this._generateObjectNumber();};
a.prototype.exit=function(e){if(this._oImageControl){this._oImageControl.destroy();}if(this._oTitleText){this._oTitleText.destroy();this._oTitleText=undefined;}L.prototype.exit.apply(this);};
a.prototype.onAfterRendering=function(){var o=this.getAggregation("_objectNumber"),p=sap.ui.getCore().getConfiguration().getRTL(),t=p?sap.ui.core.TextAlign.Left:sap.ui.core.TextAlign.Right;if(o&&o.getNumber()){o.setTextAlign(t);}};
a.prototype._generateObjectNumber=function(){var n=this.getNumber(),N=this.getNumberUnit(),s=this.getNumberState(),t=this.getNumberTextDirection();this.setAggregation("_objectNumber",new O(this.getId()+"-ObjectNumber",{number:n,unit:N,state:s,textDirection:t}),true);};
a.prototype._hasAttributes=function(){var b=this.getAttributes();if(b.length>0){for(var i=0;i<b.length;i++){if(!b[i]._isEmpty()){return true;}}}return false;};
a.prototype._hasStatus=function(){return((this.getFirstStatus()&&!this.getFirstStatus()._isEmpty())||(this.getSecondStatus()&&!this.getSecondStatus()._isEmpty()));};
a.prototype._hasBottomContent=function(){return(this._hasAttributes()||this._hasStatus()||this.getShowMarkers()||this.getMarkLocked()||this._getVisibleMarkers().length>0);};
a.prototype._getVisibleAttributes=function(){var A=this.getAttributes();var v=[];for(var i=0;i<A.length;i++){if(A[i].getVisible()){v.push(A[i]);}}return v;};
a.prototype._getVisibleMarkers=function(){var A=this.getMarkers();var v=[];for(var i=0;i<A.length;i++){if(A[i].getVisible()){v.push(A[i]);}}return v;};
a.prototype._getImageControl=function(){var i=this.getId()+'-img';var s="2.5rem";var p;if(I.isIconURI(this.getIcon())){p={src:this.getIcon(),height:s,width:s,size:s,useIconTooltip:false,densityAware:this.getIconDensityAware()};}else{p={src:this.getIcon(),useIconTooltip:false,densityAware:this.getIconDensityAware()};}var c=['sapMObjLIcon'];this._oImageControl=sap.m.ImageHelper.getImageControl(i,this._oImageControl,this,p,c);return this._oImageControl;};
a.prototype._activeHandlingInheritor=function(){var A=this.getActiveIcon();if(!!this._oImageControl&&!!A){this._oImageControl.setSrc(A);}};
a.prototype._inactiveHandlingInheritor=function(){var s=this.getIcon();if(!!this._oImageControl){this._oImageControl.setSrc(s);}};
a.prototype.setNumber=function(n){this.setProperty('number',n,true);this.getAggregation("_objectNumber").setNumber(n);return this;};
a.prototype.setNumberUnit=function(n){this.setProperty('numberUnit',n,true);this.getAggregation('_objectNumber').setUnit(n);return this;};
a.prototype.setNumberTextDirection=function(t){this.setProperty('numberTextDirection',t,true);this.getAggregation("_objectNumber").setTextDirection(t);return this;};
a.prototype.setNumberState=function(v){this.setProperty('numberState',v,true);this.getAggregation("_objectNumber").setState(v);return this;};
a.prototype.setMarkFavorite=function(m){return this._setOldMarkers(sap.m.ObjectMarkerType.Favorite,m);};
a.prototype.setMarkFlagged=function(m){return this._setOldMarkers(sap.m.ObjectMarkerType.Flagged,m);};
a.prototype.setMarkLocked=function(m){return this._setOldMarkers(sap.m.ObjectMarkerType.Locked,m);};
a.prototype.setShowMarkers=function(m){var M;var A=this.getMarkers();this.setProperty("showMarkers",m,false);for(var i=0;i<A.length;i++){M=A[i].getType();if((M===sap.m.ObjectMarkerType.Flagged&&this.getMarkFlagged())||(M===sap.m.ObjectMarkerType.Favorite&&this.getMarkFavorite())||(M===sap.m.ObjectMarkerType.Locked&&this.getMarkLocked())){A[i].setVisible(m);}}return this;};
a.prototype._setOldMarkers=function(m,M){var A=this.getMarkers();var h=false;var o={Flagged:"-flag",Favorite:"-favorite",Locked:"-lock"};this.setProperty("mark"+m,M,false);if(!this.getShowMarkers()){M=false;}for(var i=0;i<A.length;i++){if(A[i].getType()===m){h=true;A[i].setVisible(M);break;}}if(!h){this.insertAggregation("markers",new sap.m.ObjectMarker({id:this.getId()+o[m],type:m,visible:M}));}return this;};
a.prototype._getTitleText=function(){if(!this._oTitleText){this._oTitleText=new sap.m.Text(this.getId()+"-titleText",{maxLines:2});this._oTitleText.setParent(this,null,true);}return this._oTitleText;};
return a;},true);
sap.ui.predefine('sap/m/ObjectListItemRenderer',['jquery.sap.global','./ListItemBaseRenderer','sap/ui/core/Renderer'],function(q,L,R){"use strict";var O=R.extend(L);
O.renderAttributeStatus=function(r,l,a,s){if(!a&&!s||(a&&a._isEmpty()&&s&&s._isEmpty())){return;}r.write("<div");r.addClass("sapMObjLAttrRow");r.writeClasses();r.write(">");if(a&&!a._isEmpty()){r.write("<div");r.addClass("sapMObjLAttrDiv");if(s&&(!s._isEmpty())){if(s instanceof Array){r.addClass("sapMObjAttrWithMarker");}}r.writeClasses();if(!s||s._isEmpty()){r.addStyle("width","100%");r.writeStyles();}r.write(">");r.renderControl(a);r.write("</div>");}if(s&&!s._isEmpty()){r.write("<div");r.addClass("sapMObjLStatusDiv");if(s instanceof Array&&s.length>0){r.addClass("sapMObjStatusMarker");}r.writeClasses();if(!a||a._isEmpty()){r.addStyle("width","100%");r.writeStyles();}r.write(">");if(s instanceof Array){while(s.length>0){r.renderControl(s.shift());}}else{r.renderControl(s);}r.write("</div>");}r.write("</div>");};
O.renderLIAttributes=function(r,l){r.addClass("sapMObjLItem");r.addClass("sapMObjLListModeDiv");};
O.renderLIContent=function(r,l){var o=l.getAggregation("_objectNumber"),t=l.getTitleTextDirection(),i=l.getIntroTextDirection();if(l.getIntro()){r.write("<div");r.addClass("sapMObjLIntro");r.writeClasses();r.writeAttribute("id",l.getId()+"-intro");r.write(">");r.write("<span");if(i!==sap.ui.core.TextDirection.Inherit){r.writeAttribute("dir",i.toLowerCase());}r.write(">");r.writeEscaped(l.getIntro());r.write("</span>");r.write("</div>");}r.write("<div");r.addClass("sapMObjLTopRow");r.writeClasses();r.write(">");if(!!l.getIcon()){r.write("<div");r.addClass("sapMObjLIconDiv");r.writeClasses();r.write(">");r.renderControl(l._getImageControl());r.write("</div>");}r.write("<div");r.addClass("sapMObjLNumberDiv");r.writeClasses();r.write(">");if(o&&o.getNumber()){o.setTextDirection(l.getNumberTextDirection());r.renderControl(o);}r.write("</div>");r.write("<div");r.addStyle("display","-webkit-box");r.addStyle("overflow","hidden");r.writeStyles();r.write(">");var T=l._getTitleText();if(T){T.setTextDirection(t);T.setText(l.getTitle());T.addStyleClass("sapMObjLTitle");r.renderControl(T);}r.write("</div>");r.write("</div>");if(!(sap.ui.Device.browser.internet_explorer&&sap.ui.Device.browser.version<10)){r.write("<div style=\"clear: both;\"></div>");}if(l._hasBottomContent()){r.write("<div");r.addClass("sapMObjLBottomRow");r.writeClasses();r.write(">");var a=l._getVisibleAttributes();var s=[];var m=l._getVisibleMarkers();m._isEmpty=function(){return!(m.length);};if(!m._isEmpty()){s.push(m);}s.push(l.getFirstStatus());s.push(l.getSecondStatus());while(a.length>0){this.renderAttributeStatus(r,l,a.shift(),s.shift());}while(s.length>0){this.renderAttributeStatus(r,l,null,s.shift());}r.write("</div>");}};
O.getAriaLabelledBy=function(l){var a=[],f=l.getFirstStatus(),s=l.getSecondStatus();if(l.getIntro()){a.push(l.getId()+"-intro");}if(l.getTitle()){a.push(l.getId()+"-titleText");}if(l.getNumber()){a.push(l.getId()+"-ObjectNumber");}if(l.getAttributes()){l.getAttributes().forEach(function(b){if(!b._isEmpty()){a.push(b.getId());}});}if(f&&!f._isEmpty()){a.push(f.getId());}if(s&&!s._isEmpty()){a.push(s.getId());}if(l.getMarkers()){l.getMarkers().forEach(function(m){a.push(m.getId()+"-text");});}return a.join(" ");};
return O;},true);
sap.ui.predefine('sap/m/ObjectMarker',['jquery.sap.global',"sap/ui/core/Control",'sap/ui/core/Renderer'],function(q,C,R){"use strict";
var O=C.extend("sap.m.ObjectMarker",{metadata:{library:"sap.m",properties:{type:{type:"sap.m.ObjectMarkerType",group:"Misc"},visibility:{type:"sap.m.ObjectMarkerVisibility",group:"Misc"},additionalInfo:{type:"string",group:"Misc",defaultValue:""}},aggregations:{_innerControl:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{press:{type:{type:"sap.m.ObjectMarkerType"}}}}});
var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");O.M_PREDEFINED_TYPES={Flagged:{icon:{src:"sap-icon://flag",visibility:{small:true,large:true}},text:{value:r.getText("OM_FLAG"),visibility:{small:false,large:false}}},Favorite:{icon:{src:"sap-icon://favorite",visibility:{small:true,large:true}},text:{value:r.getText("OM_FAVORITE"),visibility:{small:false,large:false}}},Draft:{icon:{src:"sap-icon://request",visibility:{small:false,large:false}},text:{value:r.getText("OM_DRAFT"),visibility:{small:true,large:true}}},Locked:{icon:{src:"sap-icon://private",visibility:{small:true,large:true}},text:{value:r.getText("OM_LOCKED"),visibility:{small:false,large:true}}},Unsaved:{icon:{src:"sap-icon://user-edit",visibility:{small:true,large:true}},text:{value:r.getText("OM_UNSAVED"),visibility:{small:false,large:true}}},LockedBy:{icon:{src:"sap-icon://private",visibility:{small:true,large:true}},text:{value:r.getText("OM_LOCKED_BY"),visibility:{small:false,large:true}}},UnsavedBy:{icon:{src:"sap-icon://user-edit",visibility:{small:true,large:true}},text:{value:r.getText("OM_UNSAVED_BY"),visibility:{small:false,large:true}}}};
O.prototype.init=function(){sap.ui.Device.media.initRangeSet("DeviceSet",[600],"px",["small","large"]);};
O.prototype.onAfterRendering=function(){this._attachMediaContainerWidthChange(this._handleMediaChange,this,"DeviceSet");};
O.prototype.onBeforeRendering=function(){this._cleanup();this._adjustControl();};
O.prototype.exit=function(){this._cleanup();};
O.prototype.attachPress=function(){var i=this._getInnerControl();Array.prototype.unshift.apply(arguments,["press"]);C.prototype.attachEvent.apply(this,arguments);if(this.hasListeners("press")&&i&&i instanceof b){i.destroy();this.setAggregation("_innerControl",this._createCustomLink(),true);this._adjustControl();}return this;};
O.prototype.detachPress=function(){var i=this._getInnerControl();Array.prototype.unshift.apply(arguments,["press"]);C.prototype.detachEvent.apply(this,arguments);if(!this.hasListeners("press")&&i&&i instanceof d){i.destroy();this.setAggregation("_innerControl",this._createCustomText(),true);this._adjustControl();}return this;};
O.prototype._cleanup=function(){this._detachMediaContainerWidthChange(this._handleMediaChange,this,"DeviceSet");};
O.prototype._handleMediaChange=function(){this._adjustControl();};
O.prototype._adjustControl=function(){var t=O.M_PREDEFINED_TYPES[this.getType()],i=this._getInnerControl(),A=this.getAdditionalInfo(),T=this.getType(),s;if(!i){return false;}if(t){s=this._getMarkerText(t,T,A);}if(this._isIconVisible()){i.setIcon(t.icon.src);this.addStyleClass("sapMObjectMarkerIcon");}else{i.setIcon(null);this.removeStyleClass("sapMObjectMarkerIcon");}if(this._isTextVisible()){i.setTooltip(null);i.setText(s);this.addStyleClass("sapMObjectMarkerText");}else{if(i.getIcon()){i.setTooltip(s);}i.setText(null);this.removeStyleClass("sapMObjectMarkerText");}return true;};
O.prototype._getMarkerText=function(t,T,A){switch(T){case"LockedBy":return(A==="")?r.getText('OM_LOCKED_BY_ANOTHER_USER'):r.getText('OM_LOCKED_BY',[A]);case"UnsavedBy":return(A==="")?r.getText('OM_UNSAVED_BY_ANOTHER_USER'):r.getText('OM_UNSAVED_BY',[A]);default:return(A==="")?t.text.value:t.text.value+" "+A;}};
O.prototype._isIconVisible=function(){var t=O.M_PREDEFINED_TYPES[this.getType()],v=this.getVisibility(),D=this._getDeviceType(),T=t&&t.icon.visibility[D]||false;return v===sap.m.ObjectMarkerVisibility.IconOnly||v===sap.m.ObjectMarkerVisibility.IconAndText||(v!==sap.m.ObjectMarkerVisibility.TextOnly&&T);};
O.prototype._isTextVisible=function(){var t=O.M_PREDEFINED_TYPES[this.getType()],v=this.getVisibility(),D=this._getDeviceType(),T=t&&t.text.visibility[D]||false;return v===sap.m.ObjectMarkerVisibility.TextOnly||v===sap.m.ObjectMarkerVisibility.IconAndText||(v!==sap.m.ObjectMarkerVisibility.IconOnly&&T);};
O.prototype._getDeviceType=function(){return this._getCurrentMediaContainerRange("DeviceSet").name.toLowerCase();};
O.prototype._getInnerControl=function(){var i=this.getAggregation("_innerControl");if(!i&&this.getType()){i=this._createInnerControl();this.setAggregation("_innerControl",i,true);this._adjustControl();}return i;};
O.prototype._createInnerControl=function(){if(this.hasListeners("press")){return this._createCustomLink();}else{return this._createCustomText();}};
O.prototype._createCustomLink=function(){var o=new d(this.getId()+"-link",{wrapping:true});o.attachPress(function(e){this.firePress({type:this.getType()});},this);return o;};
O.prototype._createCustomText=function(){return new b(this.getId()+"-text",{textAlign:sap.ui.core.TextAlign.Initial});};
var a=R.extend(sap.m.TextRenderer);
a.renderText=function(o,e){o.renderControl(e._getIconAggregation());sap.m.TextRenderer.renderText(o,e);};
var b=sap.m.Text.extend("CustomText",{
metadata:{properties:{icon:{type:"sap.ui.core.URI",group:"Data",defaultValue:null}},aggregations:{_iconControl:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}}},
renderer:a
});
b.prototype.setIcon=function(i){var I=this._getIconAggregation();this.setProperty("icon",i,false);I.setSrc(i);};
b.prototype._getIconAggregation=function(){var i=this.getAggregation("_iconControl");if(!i){i=new sap.ui.core.Icon();this.setAggregation("_iconControl",i);}return i;};
b.prototype.setText=function(t){this.setProperty("text",t,true);};
var c=R.extend(sap.m.LinkRenderer);
c.renderText=function(o,e){o.renderControl(e._getIconAggregation());sap.m.LinkRenderer.renderText(o,e);};
var d=sap.m.Link.extend("CustomLink",{
metadata:{properties:{icon:{type:"sap.ui.core.URI",group:"Data",defaultValue:null}},aggregations:{_iconControl:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}}},
renderer:c
});
d.prototype.setIcon=function(i){var I=this._getIconAggregation();this.setProperty("icon",i,false);I.setSrc(i);};
d.prototype._getIconAggregation=function(){var i=this.getAggregation("_iconControl");if(!i){i=new sap.ui.core.Icon();this.setAggregation("_iconControl",i);}return i;};
d.prototype.setText=function(t){this.setProperty("text",t,true);};
return O;},true);
sap.ui.predefine('sap/m/ObjectMarkerRenderer',['jquery.sap.global','sap/ui/core/Renderer'],function(q,R){"use strict";var O={};
O.render=function(r,c){r.write("<span ");r.writeControlData(c);r.addClass("sapMObjectMarker");if(c._isIconVisible()){r.addClass("sapMObjectMarkerIcon");}if(c._isTextVisible()){r.addClass("sapMObjectMarkerText");}r.writeClasses();r.write(">");r.renderControl(c._getInnerControl());r.write("</span>");};
return O;},true);
sap.ui.predefine('sap/m/ObjectNumber',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/Renderer'],function(q,l,C,R){"use strict";
var O=C.extend("sap.m.ObjectNumber",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.m",properties:{number:{type:"string",group:"Misc",defaultValue:null},numberUnit:{type:"string",group:"Misc",defaultValue:null,deprecated:true},emphasized:{type:"boolean",group:"Appearance",defaultValue:true},state:{type:"sap.ui.core.ValueState",group:"Misc",defaultValue:sap.ui.core.ValueState.None},unit:{type:"string",group:"Misc",defaultValue:null},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:sap.ui.core.TextAlign.Begin}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"}}}});
O.prototype._sCSSPrefixObjNumberStatus='sapMObjectNumberStatus';
O.prototype.setState=function(s){this.$().removeClass(this._sCSSPrefixObjNumberStatus+this.getState());this.setProperty("state",s,true);this.$().addClass(this._sCSSPrefixObjNumberStatus+this.getState());return this;};
O.prototype.setTextAlign=function(a){var A=R.getTextAlign(a,this.getTextDirection());this.setProperty("textAlign",a,true);A=A||a;this.$().css("text-align",a);return this;};
return O;},true);
sap.ui.predefine('sap/m/ObjectNumberRenderer',['jquery.sap.global','sap/ui/core/Renderer'],function(q,R){"use strict";var O={};
O.render=function(r,o){var t=o.getTooltip_AsString(),T=o.getTextDirection(),s=o.getTextAlign();r.write("<div");r.writeControlData(o);r.addClass("sapMObjectNumber");r.addClass(o._sCSSPrefixObjNumberStatus+o.getState());if(o.getEmphasized()){r.addClass("sapMObjectNumberEmph");}if(t){r.writeAttributeEscaped("title",t);}if(T!==sap.ui.core.TextDirection.Inherit){r.writeAttribute("dir",T.toLowerCase());}s=R.getTextAlign(s,T);if(s){r.addStyle("text-align",s);}r.writeClasses();r.writeStyles();if(o.getState()!==sap.ui.core.ValueState.None){r.writeAccessibilityState({labelledby:o.getId()+"-state"});}r.write(">");this.renderText(r,o);r.write("  ");this.renderUnit(r,o);this.renderHiddenARIAElement(r,o);r.write("</div>");};
O.renderText=function(r,o){r.write("<span");r.addClass("sapMObjectNumberText");r.writeClasses();r.write(">");r.writeEscaped(o.getNumber());r.write("</span>");};
O.renderUnit=function(r,o){var u=o.getUnit()||o.getNumberUnit();if(u!==""){r.write("<span");r.addClass("sapMObjectNumberUnit");r.writeClasses();r.write(">");r.writeEscaped(u);r.write("</span>");}};
O.renderHiddenARIAElement=function(r,o){var a="",b=sap.ui.getCore().getLibraryResourceBundle("sap.m");if(o.getState()==sap.ui.core.ValueState.None){return;}r.write("<span id='"+o.getId()+"-state' class='sapUiInvisibleText' aria-hidden='true'>");switch(o.getState()){case sap.ui.core.ValueState.Error:a=b.getText("OBJECTNUMBER_ARIA_VALUE_STATE_ERROR");break;case sap.ui.core.ValueState.Warning:a=b.getText("OBJECTNUMBER_AR