/*
 * ! UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/base/ManagedObjectObserver',['jquery.sap.global','sap/ui/base/Object','sap/ui/base/ManagedObject','jquery.sap.script'],function(q,B,M){"use strict";
var a=B.extend("sap.ui.base.ManagedObjectObserver",{constructor:function(C){if(!C&&typeof C!=="function"){throw new Error("Missing callback function in ManagedObjectObserver constructor");}this._fnCallback=C;}});
a.prototype.observe=function(o,C){if(!(o instanceof M)){if(o==null){return;}throw new TypeError("ManagedObjectObserver can only handle ManagedObjects, but observe was called for "+o);}j(o,C);c(o,this,C);};
a.prototype.unobserve=function(o,C){if(!(o instanceof M)){if(o==null){return;}throw new TypeError("ManagedObjectObserver can only handle ManagedObjects, but unobserve was called for "+o);}j(o,C);r(o,this,C);};
a.prototype.isObserved=function(o,C){if(!(o instanceof M)){if(o==null){return false;}throw new TypeError("ManagedObjectObserver can only handle ManagedObjects, but isObserved was called for "+o);}return d(o,this,C);};
a.prototype.disconnect=function(){e(this);};
var O={},t=Object.create(null);
O.propertyChange=function(m,n,o,N){h("properties",m,n,function(){return{type:"property",old:o,current:N};});};
O.aggregationChange=function(m,n,s,o){h("aggregations",m,n,function(){return{type:"aggregation",mutation:s,children:Array.isArray(o)?o:null,child:!Array.isArray(o)?o:null};});};
O.associationChange=function(m,n,s,i){h("associations",m,n,function(){return{type:"association",mutation:s,ids:i};});};
function h(T,o,n,C){var I=o.getId(),k=t[I];if(k){var l;for(var i=0;i<k.listeners.length;i++){if(b(k.configurations[i],T,n)){if(!l){l=C();l.name=n;l.object=o;}var L=k.listeners[i];L._fnCallback(l);}}}}
function b(C,T,n){if(C==null||!T||!n){return false;}return C[T]===true||(Array.isArray(C[T])&&C[T].indexOf(n)>-1);}
function c(T,l,C){var i=T.getId(),o=t[i];if(!o){o=t[i]={listeners:[],configurations:[],object:T};}var I=o.listeners.indexOf(l);if(I===-1){o.listeners.push(l);o.configurations.push(C);}else{u(o.configurations[I],C,false);}if(!T._observer){T._observer=O;}}
function r(T,l,C){var i=T.getId(),o=t[i];if(!o){return;}var I=o.listeners.indexOf(l);if(I>=0){u(o.configurations[I],C,true);}if(!T._observer){T._observer=O;}}
function d(T,l,C){var i=T.getId(),o=t[i];if(!o){return false;}var I=o.listeners.indexOf(l);if(I===-1){return false;}else{return g(o.configurations[I].properties,C.properties)&&g(o.configurations[I].aggregations,C.aggregations)&&g(o.configurations[I].associations,C.associations);}}
function e(l){for(var n in t){var T=t[n];for(var i=0;i<T.listeners.length;i++){if(T.listeners[i]===l){T.listeners.splice(i,1);T.configurations.splice(i,1);}}if(T.listeners&&T.listeners.length===0){delete t[n];delete T.object._observer;}}}
function u(C,A,R){C.properties=C.properties||[];f(C.properties,A.properties,R);C.aggregations=C.aggregations||[];f(C.aggregations,A.aggregations,R);C.associations=C.associations||[];f(C.associations,A.associations,R);}
function f(o,A,R){if(!A){return;}for(var i=0;i<A.length;i++){var I=o.indexOf(A[i]);if(I>-1&&R){o.splice(I,1);}else if(I===-1&&!R){o.push(A[i]);}}}
function g(F,s){if(!Array.isArray(s)||s.length==0){return true;}if(!Array.isArray(F)||F.length==0){return false;}var U=q.sap.unique(F.concat(s));return F.length===U.length;}
function j(o,C){var m=o.getMetadata();C.properties=C.properties===true?Object.keys(m.getAllProperties()):C.properties;C.aggregations=C.aggregations===true?Object.keys(m.getAllAggregations()):C.aggregations;C.associations=C.associations===true?Object.keys(m.getAllAssociations()):C.associations;}
return a;});
sap.ui.predefine('sap/ui/model/base/ManagedObjectModel',['jquery.sap.global','../Binding','../json/JSONModel','../json/JSONPropertyBinding','../json/JSONListBinding','sap/ui/base/ManagedObject','sap/ui/base/ManagedObjectObserver','../Context','../ChangeReason'],function(q,B,J,a,b,M,c,C,d){"use strict";var e=b.extend("sap.ui.model.base.ManagedObjectModelAggregationBinding"),f=a.extend("sap.ui.model.base.ManagedObjectModelPropertyBinding"),g="@custom",I="--";
var h=J.extend("sap.ui.model.base.ManagedObjectModel",{constructor:function(o,D){if(!D&&typeof D!="object"){D={};}D[g]={};this._oObject=o;this._mObservedCount={properties:{},aggregations:{}};J.apply(this,[D]);this._oObserver=new c(this.observerChanges.bind(this));}});
h.prototype.getAggregation=J.prototype.getProperty;
h.prototype.setData=function(D,m){var _={};_[g]=D;J.prototype.setData.apply(this,[_,m]);};
h.prototype.getJSON=function(){return JSON.stringify(this.oData[g]);};
h.prototype.setProperty=function(p,v,o,A){var r=this.resolve(p,o),l,O,P;if(!r){return false;}if(r.indexOf("/"+g)===0){return J.prototype.setProperty.apply(this,arguments);}l=r.lastIndexOf("/");O=r.substring(0,l||1);P=r.substr(l+1);var i=this._getObject(O);if(i){if(i instanceof M){var j=i.getMetadata().getProperty(P);if(j){var s=j._sMutator,G=j._sGetter;if(i[G]()!==v){i[s](v);this.checkUpdate(false,A);return true;}}}else if(i[P]!==v){i[P]=v;this.checkUpdate(false,A);return true;}}return false;};
h.prototype.addBinding=function(o){J.prototype.addBinding.apply(this,arguments);this.checkUpdate();};
h.prototype.removeBinding=function(o){J.prototype.removeBinding.apply(this,arguments);if(o._bAttached){o._bAttached=false;this._getObject(o.getPath(),o.getContext(),false);}};
h.prototype.firePropertyChange=function(A){if(A.reason===d.Binding){A.resolvedPath=this.resolve(A.path,A.context);}J.prototype.firePropertyChange.call(this,A);};
h.prototype.bindAggregation=function(p,o,P){return J.prototype.bindProperty.apply(this,arguments);};
h.prototype.bindProperty=function(p,o,P){var i=new f(this,p,o,P);return i;};
h.prototype.bindList=function(p,o,s,F,P){var i=new e(this,p,o,s,F,P);i.enableExtendedChangeDetection();return i;};
h.prototype.getManagedObject=function(p,o){if(p instanceof C){o=p;p=o.getPath();}var O=this.getProperty(p,o);if(O instanceof M){return O;}return null;};
h.prototype.getRootObject=function(){return this._oObject;};
h.prototype._observePropertyChange=function(o,p){if(!o||!p){return;}var k=o.getId()+"/@"+p.name;if(!this._oObserver.isObserved(o,{properties:[p.name]})){this._oObserver.observe(o,{properties:[p.name]});this._mObservedCount.properties[k]=1;}else{this._mObservedCount.properties[k]++;}};
h.prototype._unobservePropertyChange=function(o,p){if(!o||!p){return;}var k=o.getId()+"/@"+p.name;this._mObservedCount.properties[k]--;if(this._mObservedCount.properties[k]==0){this._oObserver.unobserve(o,{properties:[p.name]});delete this._mObservedCount.properties[k];}};
h.prototype._observeAggregationChange=function(o,A){if(!o||!A){return;}var k=o.getId()+"/@"+A.name;if(!this._oObserver.isObserved(o,{aggregations:[A.name]})){this._oObserver.observe(o,{aggregations:[A.name]});this._mObservedCount.aggregations[k]=1;}else{this._mObservedCount.aggregations[k]++;}};
h.prototype._unobserveAggregationChange=function(o,A){if(!o||!A){return;}var k=o.getId()+"/@"+A.name;this._mObservedCount.aggregations[k]--;if(this._mObservedCount.aggregations[k]==0){this._oObserver.unobserve(o,{aggregations:[A.name]});delete this._mObservedCount.aggregations[k];}};
h.prototype._createId=function(i){var o=this._oObject;if(typeof o.createId==="function"){return o.createId(i);}if(!i){return o.getId()+I+q.sap.uid();}if(i.indexOf(o.getId()+I)!=0){return o.getId()+I+i;}return i;};
h.prototype._getSpecialNode=function(n,s,p,P){if(n instanceof M){if(s==="className"){if(n.getMetadata){return n.getMetadata().getName();}else{return typeof n;}}else if(s==="id"){return n.getId();}else if(s==="metadataContexts"){return n._oProviderData;}}else if(s==="binding"&&p&&P){return p.getBinding(P);}else if(s==="bound"&&p&&P){return p.isBound(P);}else if(s==="bindingInfo"&&p&&P){return p.getBindingInfo(P);}else if(q.isArray(n)){if(s==="length"){return n.length;}else if(s.indexOf("id=")===0){var j=s.substring(3),F=null;for(var i=0;i<n.length;i++){if(n[i].getId()===this._createId(j)||n[i].getId()===j){F=n[i];break;}}return F;}}return null;};
h.prototype._getObject=function(p,o,j){var n=this._oObject,r="";for(var i=0;i<this.aBindings.length;i++){var k=this.aBindings[i],R=this.resolve(k.getPath(),k.getContext());if(R&&!k._bAttached){k._bAttached=true;this._getObject(k.getPath(),k.getContext(),true);}}if(typeof p==="string"&&p.indexOf("/")!=0&&!o){return null;}if(o instanceof M){n=o;r=p;}else if(!o||o instanceof C){r=this.resolve(p,o);if(!r){return n;}if(r.indexOf("/"+g)===0){return J.prototype._getObject.apply(this,[p,o]);}}else{n=o;r=p;}if(!n){return null;}var P=r.split("/"),l=0;if(!P[0]){l++;}var m=null,s=null;while(n!==null&&P[l]){var t=P[l];if(t.indexOf("@")===0){n=this._getSpecialNode(n,t.substring(1),m,s);}else if(n instanceof M){m=n;s=t;var N=n.getMetadata(),u=N.getProperty(t);if(u){if(j===true){this._observePropertyChange(n,u);}else if(j===false){this._unobservePropertyChange(n,u);}n=n[u._sGetter]();}else{var A=N.getAggregation(t)||N.getAllPrivateAggregations()[t];if(A){if(j===true){this._observeAggregationChange(n,A);}else if(j===false){this._unobserveAggregationChange(n,A);}n=n[A._sGetter]?n[A._sGetter]():n.getAggregation(t);}else{if(n&&n[t]&&typeof n[t]==="function"){n=n[t]();}else{n=null;}}}}else if(q.isArray(n)||q.isPlainObject(n)){n=n[t];}else{if(n&&n[t]&&typeof n[t]==="function"){n=n[t]();}else{n=null;}}l++;}return n;};
h.prototype.destroy=function(){for(var n in this._mAggregationObjects){var o=this._mAggregationObjects[n];if(o.object.invalidate.fn){o.object.invalidate=o.object.invalidate.fn;}}J.prototype.destroy.apply(this,arguments);};
h.prototype.observerChanges=function(o){this.checkUpdate();};
return h;});
sap.ui.predefine('sap/ui/model/base/XMLNodeAttributesModel',['jquery.sap.global','../json/JSONModel','sap/ui/base/ManagedObject','./XMLNodeUtils'],function(q,J,M,U){"use strict";
var X=J.extend("sap.ui.model.base.XMLNodeAttributesModel",{
constructor:function(n,c,C){this.oCallback=c;this.oNode=n;this.sContext=C;this.getMetadata();J.apply(this,[n]);},
evalMode:{simple:"",binding:"@binding",bindingStr:"@bindingStr",data:"@data",metaContext:"@metaContext"}
});
X.prototype.getMetadata=function(){if(!this.oMetadata){var n=this.oNode.namespaceURI,c=U.findControlClass(n,U.localName(this.oNode));this.oMetadata=c.getMetadata();this.mAggregations=this.oMetadata.getAllAggregations();this.mProperties=this.oMetadata.getAllProperties();this.mSpecialSettings=this.oMetadata._mAllSpecialSettings;this.mEvent=this.oMetadata.getAllEvents();}return this.oMetadata;};
X.prototype.getVisitor=function(){return this.oCallback;};
X.prototype.getProperty=function(p,c){var r,C=p.length==0;var e=this.evalMode.simple;p=this.resolve(p,c);p=p.substring(1);var P=p.split("/");var d=P.indexOf("@data");var m=P.indexOf("@metaContext");if(d>-1){e=this.evalMode.data;P.splice(d,1);}else if(m>-1){var a=P.slice(0,m);var s=P.slice(m+1,P.length);var o=this._diveDeep(a,C,this.evalMode.metaContext);r=this._getAnnotation(s,o);return r;}else{var l=P[P.length-1];if(l.startsWith("@")){P.splice(-1,1);e=l;}}if(P[0]=="metadataContexts"){var b=this.oNode.getAttribute("metadataContexts");if(P.length==1){r=b;}else{var f=M.bindingParser(b);switch(P[1]){case"model":r=f.model;break;case"data":P.splice(1,1);r=this._diveDeep(P,C,this.evalMode.data);break;default:r=b;break;}}}else{r=this._diveDeep(P,C,e);}return r;};
X.prototype.getAggregation=X.prototype.getProperty;X.prototype.getSpecialSetting=X.prototype.getProperty;X.prototype.getEvent=X.prototype.getProperty;
X.prototype._diveDeep=function(p,c,e){var r=this._getTopProperty(p[0],e);if(p.length>1){p.shift();for(var i=0;i<p.length;i++){if(r){r=r[p[i]];}}}return r;};
X.prototype._getTopProperty=function(p,e){var r=null;var P;if(this.mProperties.hasOwnProperty(p)){P=this.mProperties[p];if(e===this.evalMode.simple){e=this.evalMode.data;}if(!this.oNode.hasAttribute(p)){r=P.defaultValue;}else{r=this.oNode.getAttribute(p);}}else if(!this.mAggregations.hasOwnProperty(p)&&!this.mSpecialSettings.hasOwnProperty(p)&&!this.mEvents.hasOwnProperty(p)){r=null;}else{if(this.oNode.hasAttribute(p)){r=this.oNode.getAttribute(p);}}var b=M.bindingParser(r);switch(e){case this.evalMode.simple:break;case this.evalMode.binding:r=b;break;case this.evalMode.bindingStr:if(!b){r="";}break;case this.evalMode.metaContext:var m={};if(b){if(typeof b==="string"){b=M.bindingParser("{"+b+"}");}var o=this.oCallback.getSettings().models[b.model];if(o){m.metaModel=o.getMetaModel();if(m.metaModel&&m.metaModel.getMetaContext){m.metaContext=m.metaModel.getMetaContext(b.path);m.schema=m.metaModel.getProperty(m.metaContext.getPath());}}r=m;}return r;case this.evalMode.data:if(b){var R=null;try{R=this.oCallback.getResult(r);}catch(a){}if(R){r=R;}}break;}if(r){if(P){var s=U.parseScalarType(P.type,r,p);if(!(typeof s==="object"&&s.path)){r=s;}}}return r;};
X.prototype._getObject=function(p,c,C){p=this.resolve(p,c);var i,o=this.getProperty(p,c);if(Array.isArray(o)){var l=o;var P=function(a){return function(){return p+"/"+a;};};for(i=0;i<l.length;i++){l[i].getPath=P(i);}return l;}return o;};
X.prototype.getContextName=function(){return this.sContext;};
X.prototype._getAnnotation=function(p,m){var a=m.schema;var i=0;while(a&&p[i]){a=a[p[i]];i++;}return a;};
return X;});
sap.ui.predefine('sap/ui/model/base/XMLNodeUtils',['jquery.sap.global','sap/ui/base/DataType','sap/ui/base/ManagedObject'],function(q,D,M){"use strict";return{parseScalarType:function(t,v,n,c){var b=M.bindingParser(v,c,true);if(b&&typeof b==="object"){return b;}var V=v=b||v;var T=D.getType(t);if(T){if(T instanceof D&&!T.isValid(V)){V=T.parseValue(v);}}else{throw new Error("Property "+n+" has unknown type "+t);}return typeof V==="string"?M.bindingParser.escape(V):V;},localName:function(x){return x.localName||x.baseName||x.nodeName;},findControlClass:function(n,l){var c;var L=sap.ui.getCore().getLoadedLibraries();q.each(L,function(s,o){if(n===o.namespace||n===o.name){c=o.name+"."+((o.tagNames&&o.tagNames[l])||l);}});c=c||n+"."+l;q.sap.require(c);var C=q.sap.getObject(c);if(C){return C;}else{q.sap.log.error("Can't find object class '"+c+"' for XML-view","","XMLTemplateProcessor.js");}}};});
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('jquery.sap.history',['jquery.sap.global','jquery.sap.strings'],function(q){"use strict";(function($,w){var s="_skip",r=/\|id-[0-9]+-[0-9]+/,a=new RegExp(s+"[0-9]*$"),b=[],h=[],S={},c=0,d,I="|",H=[],e=false,f,g=false;
$.sap.history=function(z){if(!q.isPlainObject(z)){return;}if(!g){var W=$(w),A=(w.location.href.split("#")[1]||"");W.bind('hashchange',k);if($.isArray(z.routes)){var i,B;for(i=0;i<z.routes.length;i++){B=z.routes[i];if(B.path&&B.handler){$.sap.history.addRoute(B.path,B.handler);}}}if(q.isFunction(z.defaultHandler)){f=z.defaultHandler;}h.push(A);if(A.length>1){W.trigger("hashchange",[true]);}else{d=A;}g=true;}};
$.sap.history.addHistory=function(i,z,B,V){var A,C;if(B===undefined){B=true;}if(!V){C=p(i,z);A=n(C);if(A){C+=(I+A);}C+=(I+(B?"1":"0"));}else{C=m(d);}H.push(C);S[C]=true;w.location.hash=C;return C;};
$.sap.history.addVirtualHistory=function(){$.sap.history.addHistory("",undefined,false,true);};
$.sap.history.addRoute=function(i,z,T){if(T){z=q.proxy(z,T);}var R={};R.sIdentifier=i;R['action']=z;b.push(R);return this;};
$.sap.history.setDefaultHandler=function(i){f=i;};
$.sap.history.getDefaultHandler=function(){return f;};
$.sap.history.backToHash=function(i){i=i||"";var z;if(h.length===1){if($.isFunction(f)){f();}}else{z=j(d,i);if(z<0){w.history.go(z);}else{q.sap.log.error("jQuery.sap.history.backToHash: "+i+"is not in the history stack or it's after the current hash");}}};
$.sap.history.backThroughPath=function(P){P=P||"";P=w.encodeURIComponent(P);var i;if(h.length===1){if($.isFunction(f)){f();}}else{i=j(d,P,true);if(i<0){w.history.go(i);}else{q.sap.log.error("jQuery.sap.history.backThroughPath: there's no history state which has the "+P+" identifier in the history stack before the current hash");}}};
$.sap.history.back=function(i){if(h.length===1){if($.isFunction(f)){f($.sap.history.NavType.Back);}}else{if(!i){i=1;}w.history.go(-1*i);}};
$.sap.history.NavType={Back:"_back",Forward:"_forward",Bookmark:"_bookmark",Unknown:"_unknown"};
function j(C,T,P){var z=$.inArray(C,h),A,i,B;if(z>0){if(P){for(i=z-1;i>=0;i--){B=h[i];if(B.indexOf(T)===0&&!t(B)){return i-z;}}}else{A=$.inArray(T,h);if((A===-1)&&T.length===0){return-1*z;}if((A>-1)&&(A<z)){return A-z;}}}return 0;}
function k(E,M){var i=(w.location.href.split("#")[1]||"");i=l(i);if(M||!S[i]){H.push(i);}if(!e){e=true;if(H.length>0){var z=H.shift();if(S[z]){o(z);delete S[z];}else{v(z);}d=z;}e=false;}}
function l(i,R){var z=i,A=i?i.indexOf("#"):-1;if(A===0){z=z.slice(A+1);}if(R){z=z.replace(r,"");}return z;}
function m(i){var P=i?i:"";if(t(P)){var z=P.lastIndexOf(s);P=P.slice(0,z);}return P+s+c++;}
function p(i,z){var E=w.encodeURIComponent(i);var A=w.encodeURIComponent(w.JSON.stringify(z));return E+I+A;}
function n(z){var A=$.inArray(d,h),i,B;if(A>-1){for(i=0;i<A+1;i++){B=h[i];if(B.slice(0,B.length-2)===z){return q.sap.uid();}}}return"";}
function o(i){var z=$.inArray(d,h);if(!(z===-1||z===h.length-1)){h.splice(z+1,h.length-1-z);}h.push(i);}
function t(i){return a.test(i);}
function u(C,F){var z=$.inArray(C,h),i;if(z!==-1){if(F){for(i=z;i<h.length;i++){if(!t(h[i])){return i-z;}}}else{for(i=z;i>=0;i--){if(!t(h[i])){return i-z;}}return-1*(z+1);}}}
function v(i){var R,z,P,N,A;if(d===undefined){P=y(i);if(!P||!P.bBookmarkable){if(q.isFunction(f)){f($.sap.history.NavType.Bookmark);}return;}}if(i.length===0){if(q.isFunction(f)){f($.sap.history.NavType.Back);}}else{N=h.indexOf(i);if(N===0){P=y(i);if(!P||!P.bBookmarkable){if(q.isFunction(f)){f($.sap.history.NavType.Back);}return;}}if(t(i)){if(t(d)){z=u(i,false);w.history.go(z);}else{var B=new RegExp(q.sap.escapeRegExp(d+s)+"[0-9]*$");if(B.test(i)){z=u(i,true);if(z){w.history.go(z);}else{w.history.back();}}else{z=u(i,false);w.history.go(z);}}}else{if(N===-1){A=$.sap.history.NavType.Unknown;h.push(i);}else{if(h.indexOf(d,N+1)===-1){A=$.sap.history.NavType.Forward;}else{A=$.sap.history.NavType.Back;}}P=y(i);if(P){R=x(P.sIdentifier);if(R){R.action.apply(null,[P.oStateData,A]);}}else{q.sap.log.error("hash format error! The current Hash: "+i);}}}}
function x(z){var i;for(i=0;i<b.length;i++){if(b[i].sIdentifier===z){return b[i];}}}
function y(z){if(t(z)){var i=z.lastIndexOf(s);z=z.slice(0,i);}var P=z.split(I),R={};if(P.length===4||P.length===3){R.sIdentifier=w.decodeURIComponent(P[0]);R.oStateData=w.JSON.parse(w.decodeURIComponent(P[1]));if(P.length===4){R.uid=P[2];}R.bBookmarkable=P[P.length-1]==="0"?false:true;return R;}else{return null;}}
})(q,this);return q;});
sap.ui.predefine('jquery.sap.promise',['jquery.sap.global','sap/ui/Device'],function(q,D){"use strict";if(D.browser.edge||D.browser.safari){window.Promise=undefined;}if(!window.Promise){q.sap.require("sap.ui.thirdparty.es6-promise");ES6Promise.polyfill();}});
sap.ui.predefine('jquery.sap.storage',['jquery.sap.global'],function(q){"use strict";var s=!!(window.JSON&&JSON.parse&&JSON.stringify);var S="state.key_";var f=function(a,b){var t="unknown",P=b||S;P+="-";var T=P+"___sapui5TEST___",o;if(!a||typeof(a)==="string"){t=a||"session";try{o=window[t+"Storage"];}catch(e){o=null;}try{if(o){o.setItem(T,"1");o.removeItem(T);}}catch(e){o=null;}}else if(typeof(a)==="object"){t=a.getType?a.getType():"unknown";o=a;}var c=!!o;this.isSupported=function(){if(!c){return false;}if(typeof(o.isSupported)=="function"){return o.isSupported();}return true;};this.put=function(i,d){if(this.isSupported()&&i){try{o.setItem(P+i,s?JSON.stringify(d):d);return true;}catch(e){return false;}}else{return false;}};this.get=function(i){if(this.isSupported()&&i){try{var I=o.getItem(P+i);return s?JSON.parse(I):I;}catch(e){return null;}}else{return null;}};this.remove=function(i){if(this.isSupported()&&i){try{o.removeItem(P+i);return true;}catch(e){return false;}}else{return false;}};this.removeAll=function(I){if(this.isSupported()&&o.length&&typeof o.key==="function"){try{var l=o.length;var k=[];var d,i;var p=P+(I||"");for(i=0;i<l;i++){d=o.key(i);if(d&&d.indexOf(p)==0){k.push(d);}}for(i=0;i<k.length;i++){o.removeItem(k[i]);}return true;}catch(e){return false;}}else{return false;}};this.clear=function(){if(this.isSupported()){try{o.clear();return true;}catch(e){return false;}}else{return false;}};this.getType=function(){return t;};};var m={};
q.sap.storage=function(o,i){if(!o){o=q.sap.storage.Type.session;}if(typeof(o)==="string"&&q.sap.storage.Type[o]){var k=o;if(i&&i!=S){k=o+"_"+i;}return m[k]||(m[k]=new f(o,i));}return new f(o,i);};
q.sap.storage.Type={local:"local",session:"session",global:"global"};f.apply(q.sap.storage);m[q.sap.storage.Type.session]=q.sap.storage;return q;});
sap.ui.predefine('jquery.sap.xml',['jquery.sap.global','sap/ui/Device'],function(q,D){"use strict";
q.sap.parseXML=function parseXML(x){var X;if(window.DOMParser){var p=new DOMParser();try{X=p.parseFromString(x,"text/xml");}catch(e){var P=q.sap.getParseError(X);X={};P.reason=e.message;X.parseError=P;return X;}}else{X=new ActiveXObject("Microsoft.XMLDOM");X.async=false;X.loadXML(x);}var P=q.sap.getParseError(X);if(P){if(!X.parseError){X.parseError=P;}}return X;};
q.sap.serializeXML=function serializeXML(x){var X="";if(window.ActiveXObject){X=x.xml;if(X){return X;}}if(window.XMLSerializer){var s=new XMLSerializer();X=s.serializeToString(x);}return X;};
q.sap.isEqualNode=function(n,N){if(n===N){return true;}if(!n||!N){return false;}if(n.isEqualNode){return n.isEqualNode(N);}if(n.nodeType!=N.nodeType){return false;}if(n.nodeValue!=N.nodeValue){return false;}if(n.baseName!=N.baseName){return false;}if(n.nodeName!=N.nodeName){return false;}if(n.nameSpaceURI!=N.nameSpaceURI){return false;}if(n.prefix!=N.prefix){return false;}if(n.nodeType!=1){return true;}if(n.attributes.length!=N.attributes.length){return false;}for(var i=0;i<n.attributes.length;i++){if(!q.sap.isEqualNode(n.attributes[i],N.attributes[i])){return false;}}if(n.childNodes.length!=N.childNodes.length){return false;}for(var i=0;i<n.childNodes.length;i++){if(!q.sap.isEqualNode(n.childNodes[i],N.childNodes[i])){return false;}}return true;};
q.sap.getParseError=function getParseError(d){var p={errorCode:-1,url:"",reason:"unknown error",srcText:"",line:-1,linepos:-1,filepos:-1};if(D.browser.msie&&d&&d.parseError&&d.parseError.errorCode!=0){return d.parseError;}if((D.browser.firefox||D.browser.edge)&&d&&d.documentElement&&d.documentElement.tagName=="parsererror"){var e=d.documentElement.firstChild.nodeValue,r=/XML Parsing Error: (.*)\nLocation: (.*)\nLine Number (\d+), Column (\d+):(.*)/;if(r.test(e)){p.reason=RegExp.$1;p.url=RegExp.$2;p.line=parseInt(RegExp.$3,10);p.linepos=parseInt(RegExp.$4,10);p.srcText=RegExp.$5;}return p;}if(D.browser.webkit&&d&&d.documentElement&&d.getElementsByTagName("parsererror").length>0){var e=q.sap.serializeXML(d),r=/(error|warning) on line (\d+) at column (\d+): ([^<]*)\n/;if(r.test(e)){p.reason=RegExp.$4;p.url="";p.line=parseInt(RegExp.$2,10);p.linepos=parseInt(RegExp.$3,10);p.srcText="";p.type=RegExp.$1;}return p;}if(!d||!d.documentElement){return p;}return{errorCode:0};};
return q;});
sap.ui.predefine('sap/ui/app/Application',['jquery.sap.global','./ApplicationMetadata','sap/ui/core/Component','jquery.sap.sjax'],function(q,A,C){"use strict";
var a=C.extend("sap.ui.app.Application",{
metadata:{"abstract":true,properties:{root:"string",config:"any"},aggregations:{rootComponent:{type:"sap.ui.core.UIComponent",multiple:false}},publicMethods:["getView"],deprecated:true},
constructor:function(i,s){if(this.onError){this.onWindowError=this.onError;}if(this.onBeforeExit){this.onWindowBeforeUnload=this.onBeforeExit;}if(this.onExit){this.onWindowUnload=this.onExit;}C.apply(this,arguments);if(sap.ui.getApplication){throw new Error("Only one instance of sap.ui.app.Application is allowed");}sap.ui.getApplication=q.proxy(this._getInstance,this);sap.ui.getCore().attachInit(q.proxy(function(){this._initRootComponent();this.main();},this));},
_initRootComponent:function(){var r=this.createRootComponent();if(r){this.setRootComponent(r);var c=new sap.ui.core.ComponentContainer({component:r});c.placeAt(this.getRoot()||document.body);}},
createRootComponent:function(){var r=this.getMetadata().getRootComponent();var R;if(r){R=sap.ui.component({name:r});}return R;},
getView:function(){return this.getRootComponent();},
_getInstance:function(){return this;},
main:function(){},
onBeforeExit:function(){},
onExit:function(){},
onError:null,
setConfig:function(c){if(typeof c==="string"){var u=c;var c=new sap.ui.model.json.JSONModel();var r=q.sap.sjax({url:u,dataType:'json'});if(r.success){c.setData(r.data);}else{throw new Error("Could not load config file: "+u);}}if(typeof c==="object"&&!c instanceof sap.ui.model.Model){c=new sap.ui.model.JSONModel(c);}this.setProperty("config",c);},
destroy:function(s){delete sap.ui.getApplication;C.prototype.destroy.apply(this,arguments);}
},A);
return a;},true);
sap.ui.predefine('sap/ui/app/ApplicationMetadata',['jquery.sap.global','sap/ui/core/ComponentMetadata','jquery.sap.sjax'],function(q,C){"use strict";var A=function(c,o){C.apply(this,arguments);};A.prototype=q.sap.newObject(C.prototype);
A.preprocessClassInfo=function(c){if(c&&typeof c.metadata==="string"){c.metadata={_src:c.metadata};}return c;};
A.prototype.applySettings=function(c){var s=c.metadata;C.prototype.applySettings.call(this,c);if(s._src){q.sap.log.warning("The metadata of the application "+this.getName()+" is loaded from file "+s._src+". This is a design time feature and not for productive usage!");var p=this.getName().replace(/\.\w+?$/,"");var u=q.sap.getModulePath(p,"/"+s._src);var r=q.sap.syncGetJSON(u);if(r.success){q.extend(s,r.data);}else{q.sap.log.error("Failed to load application metadata from \""+s._src+"\"! Reason: "+r.error);}}this._mRootComponent=s.rootComponent||null;};
A.prototype.getRootComponent=function(){return this._mRootComponent;};
return A;},true);
sap.ui.predefine('sap/ui/app/MockServer',['jquery.sap.global','sap/ui/core/util/MockServer'],function(q,M){"use strict";var a=M;return a;},true);
sap.ui.predefine('sap/ui/core/AggregationProxy',['jquery.sap.global','sap/ui/base/ManagedObject','sap/ui/core/Control','sap/ui/core/Element'],function(q,M,C,E){"use strict";var c=["getParent","setParent","_getPropertiesToPropagate","destroy"];
function u(f){if(f._mProxyMethods){c.map(function(m){f[m]=f._mProxyMethods[m];});delete f._mProxyMethods;}}
function r(n,f){if(!f._mProxyMethods){f._mProxyMethods={};c.map(function(m){f._mProxyMethods[m]=f[m];});}f.getParent=function(){return n;};f.setParent=function(){u(this);return this.setParent.apply(this,arguments);};f.destroy=function(){u(this);this.destroy.apply(this,arguments);};f._getPropertiesToPropagate=function(){var p=M.prototype._getPropertiesToPropagate.apply(this,arguments);var o=n.oModels;var m={};var b=p.oModels;for(var d in b){if(!b.hasOwnProperty(d)){continue;}if(!o[d]){m[d]=b[d];}}p.oModels=m;var B={};for(var d in m){B[d]=p.oBindingContexts[d];}p.oBindingContexts=B;return p;};}
function a(){var p=this.getParent();if(p){var n=this.sParentAggregationName,b=p.getBinding(n),o=p.getMetadata().getAggregation(n);if(!o||!o.multiple){throw new Error("Cannot use AggregationProxy with single aggregations (="+n+" in parent "+p+") on lists");}if(b){if(!p[o._sGetter].fnOriginalGetter){var O=p[o._sGetter];p[o._sGetter]=function(){var R=[];if(b){var d=b.getContexts();for(var i=0;i<d.length;i++){var e=d[i].getProperty();r(this,e);R.push(e);}this.mAggregations[o.name]=R;}return O.apply(this,[]);};p[o._sGetter].fnOriginalGetter=O;}}}}
var A=M.extend("sap.ui.core.AggregationProxy",{
constructor:function(i,s){if(!s&&i&&typeof i==="object"){s=i;i=M.getMetadata().uid();}s=s||{};if(s.ref){return new S(i,{ref:s.ref});}else{if(!s.type){s.type="sap.ui.core.Control";}var b=sap.ui.require(q.sap.getResourceName(s.type,""));if(!b){q.sap.log.debug("The given proxy type "+s.type+" is unknown. Using control instead.");s.type="sap.ui.core.Control";b=C;}var I=new(b)();if(!(I instanceof E)){q.sap.log.error("The given type "+s.type+" needs to derive from sap.ui.core.Element");return null;}I.attachModelContextChange(a);return I;}},
metadata:{properties:{type:{type:"string"}},aggregations:{ref:{type:"sap.ui.core.Control",multiple:true,_doesNotRequireFactory:true}}}
});
var S=C.extend("sap.ui.core.SingleAggregationProxy",{
metadata:{aggregations:{ref:{type:"sap.ui.core.Control",multiple:true,_doesNotRequireFactory:true}}},
renderer:function(R,o){var b=o._oContent;if(b&&b.getParent()===o.getParent()){R.renderControl(b);}}
});
S.prototype.updateRef=function(){var b=this.getBinding("ref");if(b){var o=b.getModel().getProperty(b.getPath(),b.getContext());if(Array.isArray(o)){q.sap.log.warning("Cannot add AggregationProxy with multiple aggregations");return;}if(o&&!o._bIsBeingDestroyed){r(this.getParent(),o);if(o.getParent()){o.getParent().invalidate();}}this._oContent=o;}};
return A;});
sap.ui.predefine('sap/ui/core/AppCacheBuster',['jquery.sap.global','sap/ui/base/ManagedObject','./Core','sap/ui/thirdparty/URI'],function(q,M,C,U){"use strict";var c=sap.ui.getCore().getConfiguration();var l=c.getLanguage();var s=c.getAppCacheBusterMode()==="sync";var b=c.getAppCacheBusterMode()==="batch";var S={index:{},active:false};var a,v,d,f;var L=document.location.href.replace(/\?.*|#.*/g,"");var u=U(q.sap.getModulePath("","/../"));var o=u.toString();if(u.is("relative")){u=u.absoluteTo(L);}var B=u.normalize().toString();var r=U("resources").absoluteTo(B).toString();var F=new RegExp("^"+q.sap.escapeRegExp(r));var E=function(e){if(e.length>0&&e.slice(-1)!=="/"){e+="/";}return e;};var R=function(B,e){var i=S.index;var g;var j;var k;if(Array.isArray(B)&&!b){B.forEach(function(y){R(y,e);});}else if(Array.isArray(B)&&b){var m=E(B[0]);var n=[];q.sap.log.debug("sap.ui.core.AppCacheBuster.register(\""+m+"\"); // BATCH MODE!");var p=A.normalizeURL(m);q.sap.log.debug("  --> normalized to: \""+p+"\"");B.forEach(function(y){j=E(y);var z=A.normalizeURL(j);if(!i[k]){n.push(z);}});if(n.length>0){var j=p+"sap-ui-cachebuster-info.json?sap-ui-language="+l;g={url:j,type:"POST",async:!s&&!!e,dataType:"json",contentType:"text/plain",data:n.join("\n"),success:function(y){A.onIndexLoaded(j,y);q.extend(i,y);},error:function(){q.sap.log.error("Failed to batch load AppCacheBuster index file from: \""+j+"\".");}};}}else{B=E(B);q.sap.log.debug("sap.ui.core.AppCacheBuster.register(\""+B+"\");");k=A.normalizeURL(B);q.sap.log.debug("  --> normalized to: \""+k+"\"");if(!i[k]){var j=k+"sap-ui-cachebuster-info.json?sap-ui-language="+l;g={url:j,async:!s&&!!e,dataType:"json",success:function(y){A.onIndexLoaded(j,y);i[k]=y;},error:function(){q.sap.log.error("Failed to load AppCacheBuster index file from: \""+j+"\".");}};}}if(g){var I=A.onIndexLoad(g.url);if(I!=null){q.sap.log.info("AppCacheBuster index file injected for: \""+j+"\".");g.success(I);}else{if(g.async){var t=e.startTask("load "+j);var w=g.success,x=g.error;q.extend(g,{success:function(y){w.apply(this,arguments);e.finishTask(t);},error:function(){x.apply(this,arguments);e.finishTask(t,false);}});}q.sap.log.info("Loading AppCacheBuster index file from: \""+j+"\".");q.ajax(g);}}};var A={boot:function(e){var g=c.getAppCacheBuster();if(g&&g.length>0){g=g.slice();var i=true;var V=String(g[0]).toLowerCase();if(g.length===1){if(V==="true"||V==="x"){var u=U(o);g=u.is("relative")?[u.toString()]:[];}else if(V==="false"){i=false;}}if(i){A.init();R(g,e);}}},init:function(){S.active=true;a=q.ajax;v=M.prototype.validateProperty;d=Object.getOwnPropertyDescriptor(HTMLScriptElement.prototype,"src");f=Object.getOwnPropertyDescriptor(HTMLLinkElement.prototype,"href");var g=A.convertURL;var n=A.normalizeURL;var i=function(e){if(this.active===true&&e&&typeof(e)==="string"){e=n(e);return!e.match(F);}return false;}.bind(S);q.ajax=function(e,p){if(e&&e.url&&i(e.url)){e.url=g(e.url);}return a.apply(this,arguments);};M.prototype.validateProperty=function(p,V){var t=this.getMetadata(),P=t.getProperty(p),w;if(P&&P.type==="sap.ui.core.URI"){w=Array.prototype.slice.apply(arguments);try{if(i(w[1])){w[1]=g(w[1]);}}catch(e){}}return v.apply(this,w||arguments);};var j=function(e){var p={get:e.get,set:function(t){if(i(t)){t=g(t);}e.set.call(this,t);},enumerable:e.enumerable,configurable:e.configurable};p.set._sapUiCoreACB=true;return p;};var k=false;try{Object.defineProperty(HTMLScriptElement.prototype,"src",j(d));}catch(m){q.sap.log.error("Your browser doesn't support redefining the src property of the script tag. Disabling AppCacheBuster as it is not supported on your browser!\nError: "+m);k=true;}try{Object.defineProperty(HTMLLinkElement.prototype,"href",j(f));}catch(m){q.sap.log.error("Your browser doesn't support redefining the href property of the link tag. Disabling AppCacheBuster as it is not supported on your browser!\nError: "+m);k=true;}if(k){this.exit();}},exit:function(){q.ajax=a;M.prototype.validateProperty=v;var e;if((e=Object.getOwnPropertyDescriptor(HTMLScriptElement.prototype,"src"))&&e.set&&e.set._sapUiCoreACB===true){Object.defineProperty(HTMLScriptElement.prototype,"src",d);}if((e=Object.getOwnPropertyDescriptor(HTMLLinkElement.prototype,"href"))&&e.set&&e.set._sapUiCoreACB===true){Object.defineProperty(HTMLLinkElement.prototype,"href",f);}S.index={};S.active=false;S={index:{},active:false};},register:function(B){R(B);},convertURL:function(e){q.sap.log.debug("sap.ui.core.AppCacheBuster.convertURL(\""+e+"\");");var i=S.index;if(i&&e){var n=A.normalizeURL(e);q.sap.log.debug("  --> normalized to: \""+n+"\"");if(n&&A.handleURL(n)){q.each(i,function(B,m){var g;if(B&&n.length>=B.length&&n.slice(0,B.length)===B){g=n.slice(B.length);if(m[g]){e=B+"~"+m[g]+"~/"+g;q.sap.log.debug("  ==> rewritten to \""+e+"\";");return false;}}});}}return e;},normalizeURL:function(e){var u=U(e||"./");if(u.is("relative")){u=u.absoluteTo(L);}return u.normalizeProtocol().normalizeHostname().normalizePort().normalizePath().toString();},handleURL:function(e){return true;},onIndexLoad:function(e){return null;},onIndexLoaded:function(e,i){}};var h=c.getAppCacheBusterHooks();if(h){["handleURL","onIndexLoad","onIndexLoaded"].forEach(function(e){if(typeof h[e]==="function"){A[e]=h[e];}});}return A;},true);
sap.ui.predefine('sap/ui/core/BusyIndicator',['jquery.sap.global','../base/EventProvider','./Popup','./Core','./BusyIndicatorUtils'],function(q,E,P,C,B){"use strict";var a=q.extend(new E(),{oPopup:null,oDomRef:null,bOpenRequested:false,iDEFAULT_DELAY_MS:1000,sDOM_ID:"sapUiBusyIndicator"});a.M_EVENTS={Open:"Open",Close:"Close"};a._bShowIsDelayed=undefined;
a._init=function(){var r=document.createElement("div");r.id=this.sDOM_ID;var b=document.createElement("div");this._oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.core");var t=this._oResBundle.getText("BUSY_TEXT");delete this._oResBundle;b.className="sapUiBusy";b.setAttribute("tabindex","0");b.setAttribute("role","progressbar");b.setAttribute("alt","");b.setAttribute("title",t);r.appendChild(b);var o=B.getElement("Big");o.setAttribute("title",t);r.appendChild(o);var i=sap.ui.getCore().getStaticAreaRef();i.appendChild(r);this.oDomRef=r;this.oPopup=new P(r);this.oPopup.setModal(true,"sapUiBlyBusy");this.oPopup.setShadow(false);this.oPopup.attachOpened(function(e){this._onOpen(e);},this);};
a._onOpen=function(e){var d=q.sap.domById(a.sDOM_ID);d.style.height="100%";d.style.width="100%";var A=d.querySelector(".sapUiLocalBusyIndicator");A.className+=" sapUiLocalBusyIndicatorFade";q.sap.focus(d);q("body").attr("aria-busy",true);this.fireOpen({$Busy:this.oPopup._$()});};
a.show=function(d){q.sap.log.debug("sap.ui.core.BusyIndicator.show (delay: "+d+") at "+new Date().getTime());if(!document.body||!sap.ui.getCore().isInitialized()){if(a._bShowIsDelayed===undefined){sap.ui.getCore().attachInit(function(){if(a._bShowIsDelayed){a.show(d);}});}a._bShowIsDelayed=true;return;}if((d===undefined)||((d!=0)&&(parseInt(d,10)==0))||(parseInt(d,10)<0)){d=this.iDEFAULT_DELAY_MS;}if(q.sap.fesr.getActive()){this._fDelayedStartTime=q.sap.now()+d;}if(!this.oDomRef){this._init();}this.bOpenRequested=true;if(d===0){this._showNowIfRequested();}else{q.sap.delayedCall(d,this,"_showNowIfRequested");}};
a._showNowIfRequested=function(){q.sap.log.debug("sap.ui.core.BusyIndicator._showNowIfRequested (bOpenRequested: "+this.bOpenRequested+") at "+new Date().getTime());if(!this.bOpenRequested){return;}var o=(window.scrollX===undefined?window.pageXOffset:window.scrollX);var O=(window.scrollY===undefined?window.pageYOffset:window.scrollY);var s=o+" "+O;this.bOpenRequested=false;this.oPopup.open(0,P.Dock.LeftTop,P.Dock.LeftTop,document,s);};
a.hide=function(){q.sap.log.debug("sap.ui.core.BusyIndicator.hide at "+new Date().getTime());if(this._fDelayedStartTime){var b=q.sap.now()-this._fDelayedStartTime;q.sap.fesr.addBusyDuration((b>0)?b:0);delete this._fDelayedStartTime;}var c=a;if(a._bShowIsDelayed===true){a._bShowIsDelayed=false;}c.bOpenRequested=false;if(c.oDomRef){q("body").removeAttr("aria-busy");var A=c.oDomRef.querySelector(".sapUiLocalBusyIndicator");q(A).removeClass("sapUiLocalBusyIndicatorFade");this.fireClose({$Busy:this.oPopup._$()});c.oPopup.close(0);}};
a.attachOpen=function(f,l){this.attachEvent(a.M_EVENTS.Open,f,l);return this;};
a.detachOpen=function(f,l){this.detachEvent(a.M_EVENTS.Open,f,l);return this;};
a.attachClose=function(f,l){this.attachEvent(a.M_EVENTS.Close,f,l);return this;};
a.detachClose=function(f,l){this.detachEvent(a.M_EVENTS.Close,f,l);return this;};
a.fireOpen=function(p){this.fireEvent(a.M_EVENTS.Open,p);};
a.fireClose=function(p){this.fireEvent(a.M_EVENTS.Close,p);};
return a;},true);
sap.ui.predefine('sap/ui/core/ComponentContainer.designtime',[],function(){"use strict";return{associations:{component:{aggregationLike:true}}};},false);
sap.ui.predefine('sap/ui/core/ComponentContainer',['sap/ui/base/ManagedObject','./Control','./Component','./Core','./library'],function(M,C,a,b,l){"use strict";var c=l.ComponentLifecycle;
var d=C.extend("sap.ui.core.ComponentContainer",{metadata:{library:"sap.ui.core",properties:{name:{type:"string",defaultValue:null},url:{type:"sap.ui.core.URI",defaultValue:null},async:{type:"boolean",defaultValue:false},handleValidation:{type:"boolean",defaultValue:false},settings:{type:"object",defaultValue:null},propagateModel:{type:"boolean",defaultValue:false},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},lifecycle:{type:"sap.ui.core.ComponentLifecycle",defaultValue:c.Legacy},autoPrefixId:{type:"boolean",defaultValue:false},usage:{type:"string",defaultValue:null}},associations:{component:{type:"sap.ui.core.UIComponent",multiple:false}},events:{componentCreated:{parameters:{component:"sap.ui.core.Component"}}},designTime:true}});
function s(o,v,S,D){var f=typeof v==="string"?b.getComponent(v):v;var O=o.getComponentInstance();if(O!==f){if(O){O.setContainer(undefined);if(D){O.destroy();}else{o._propagateProperties(true,O,M._oEmptyPropagatedProperties,true);}}o.setAssociation("component",f,S);f=o.getComponentInstance();if(f){f.setContainer(o);o.propagateProperties(true);}}}
d.prototype.getComponentInstance=function(){var f=this.getComponent();return f&&b.getComponent(f);};
d.prototype.setComponent=function(v,S){s(this,v,S,this.getLifecycle()===c.Container||(typeof this.getUsage()==="string"&&this.getUsage()&&this.getLifecycle()===c.Legacy));return this;};
d.prototype.applySettings=function(S,o){if(S&&S.autoPrefixId===true&&S.settings&&S.settings.id){S.settings.id=this.getId()+"-"+S.settings.id;}C.prototype.applySettings.apply(this,arguments);};
function e(o){var n=o.getName();var u=o.getUsage();var m={name:n?n:undefined,usage:u?u:undefined,async:o.getAsync(),url:o.getUrl(),handleValidation:o.getHandleValidation(),settings:o.getSettings()};return m;}
d.prototype.onBeforeRendering=function(){var o=this.getComponentInstance(),u=this.getUsage(),n=this.getName();if(!o&&(u||n)){var O=a.getOwnerComponentFor(this),m=e(this);if(!O){o=sap.ui.component(m);}else{o=O._createComponent(m);}if(o instanceof Promise){o.then(function(o){this.setComponent(o);this.fireComponentCreated({component:o});}.bind(this));}else{this.setComponent(o,true);this.fireComponentCreated({component:o});}}if(o&&o.onBeforeRendering){o.onBeforeRendering();}};
d.prototype.onAfterRendering=function(){var o=this.getComponentInstance();if(o&&o.onAfterRendering){o.onAfterRendering();}};
d.prototype.exit=function(){s(this,undefined,true,this.getLifecycle()!==c.Application);};
d.prototype.propagateProperties=function(n){var o=this.getComponentInstance();if(o&&this.getPropagateModel()){this._propagateProperties(n,o);C.prototype.propagateProperties.apply(this,arguments);}};
d.prototype._propagateContextualSettings=function(){var o=this.getComponentInstance();if(o){o._applyContextualSettings(this._getContextualSettings());}};
return d;});
sap.ui.predefine('sap/ui/core/ComponentContainerRenderer',function(){"use strict";var C={};
C.render=function(r,c){var R=r;var o=c.getComponentInstance();var w=c.getWidth();var h=c.getHeight();R.write("<div");R.writeControlData(c);if(w){R.addStyle("width",w);}if(h){R.addStyle("height",h);}R.writeStyles();R.addClass("sapUiComponentContainer");R.writeClasses();R.write(">");R.write("<div id=\""+c.getId()+"-uiarea\"");if(w&&w!=="auto"){R.addStyle("width","100%");}if(h&&h!=="auto"){R.addStyle("height","100%");}R.writeStyles();R.write(">");if(o){o.render(R);}R.write("</div></div>");};
return C;},true);
sap.ui.predefine('sap/ui/core/CompositeSupport',['jquery.sap.global','./Control','sap/ui/model/control/ControlModel','sap/ui/base/EventProvider'],function(q,C,a,E){"use strict";var b={};
b.mixInto=function(f,F,m){if(arguments.length==2&&typeof F==="object"){m=F;F="ComponentFactory";}function _(){var M=f.getMetadata();do{M=M.getParent();if(M&&M.getComponentFactoryClass){return M.getComponentFactoryClass();}}while(M);return c;}f[F]=(_()).subclass(m);f.getMetadata().getComponentFactoryClass=q.sap.getter(f[F]);if(!f.prototype._initCompositeSupport){f.prototype._initCompositeSupport=function(s){var o=new(this.getMetadata().getComponentFactoryClass())(this);if(s.componentFactory){o.customize(s.componentFactory);delete s.componentFactory;}this.getComponentFactory=q.sap.getter(o);};}if(!f.prototype._exitCompositeSupport){f.prototype._exitCompositeSupport=function(){this.getComponentFactory().destroy();delete this.getComponentFactory;};}};
var c=E.extend("sap.ui.core.ComponentFactory",{constructor:function(o){E.apply(this);this.oComposite=o;return this;}});
c.prototype.attachChange=function(f,o){this.getModel();this.attachEvent("change",f,o);return this;};
c.prototype.detachChange=function(f,o){this.getModel();this.detachEvent("change",f,o);return this;};
c.prototype.getModel=function(){if(!this.oModel){var t=this;this.oModel=new a(this.oComposite);this.oModel._onchange=function(e){t.fireEvent("change",e.getParameters&&e.getParameters());};}return this.oModel;};
c.prototype.addFacadeComponent=function(e){this.getModel().add(e);};
c.prototype.removeFacadeComponent=function(e){this.getModel().remove(e);};
(function(){
function _(o,m,D){q.each(m,function(n,f){if(n.indexOf("default")!=0){o[n]=f;}if(D&&n.indexOf("create")==0){o["defaultC"+n.substring(1)]=o[n];}});}
function d(B){return function(m){var f=function(){B.apply(this,arguments);};f.prototype=Object.create(B.prototype);_(f.prototype,m,true);f.customize=function(m){_(f.prototype,m);return this;};f.subclass=d(f);return f;};}
c.subclass=d(c);
c.prototype.customize=function(m){_(this,m);if(this.oComposite&&this.oComposite._onComponentFactoryChanged){this.oComposite._onComponentFactoryChanged();}return this;};
}());return b;},true);
sap.ui.predefine('sap/ui/core/ContextMenuSupport',["./Control"],function(C){"use strict";var a=function(){var c;if(!(this instanceof C)){return;}function o(e){e.stopPropagation();if(e.srcControl!==this){return;}e.preventDefault();this._oContextMenu.openAsContextMenu(e,this);}c={oncontextmenu:o};this.setContextMenu=function(b){if(b==null&&this.getContextMenu()){this._oContextMenu=null;this.removeEventDelegate(c,this);return;}else if(!b||!b.getMetadata||!b.getMetadata().isInstanceOf("sap.ui.core.IContextMenu")){return;}if(!this._oContextMenu){this.addEventDelegate(c,this);}this._oContextMenu=b;};this.getContextMenu=function(){return this._oContextMenu;};};return a;},true);
sap.ui.predefine('sap/ui/core/CustomData.designtime',[],function(){"use strict";return{aggregations:{customData:{ignored:true}}};},false);
sap.ui.predefine('sap/ui/core/CustomData',['jquery.sap.global','./Element','./library'],function(q,E,l){"use strict";var I=l.ID;
var C=E.extend("sap.ui.core.CustomData",{metadata:{library:"sap.ui.core",properties:{key:{type:"string",group:"Data",defaultValue:null},value:{type:"any",group:"Data",defaultValue:null},writeToDom:{type:"boolean",group:"Data",defaultValue:false}},designTime:true}});
C.prototype.setValue=function(v){this.setProperty("value",v,true);var c=this.getParent();if(c&&c.getDomRef()){var o=this._checkWriteToDom(c);if(o){c.$().attr(o.key,o.value);}}return this;};
C.prototype._checkWriteToDom=function(r){if(!this.getWriteToDom()){return null;}var k=this.getKey();var v=this.getValue();if(typeof v!="string"){q.sap.log.error("CustomData with key "+k+" should be written to HTML of "+r+" but the value is not a string.");return null;}if(!(I.isValid(k))||(k.indexOf(":")!=-1)){q.sap.log.error("CustomData with key "+k+" should be written to HTML of "+r+" but the key is not valid (must be a valid sap.ui.core.ID without any colon).");return null;}if(k==q.sap._FASTNAVIGATIONKEY){v=/^\s*(x|true)\s*$/i.test(v)?"true":"false";}else if(k.indexOf("sap-ui")==0){q.sap.log.error("CustomData with key "+k+" should be written to HTML of "+r+" but the key is not valid (may not start with 'sap-ui').");return null;}return{key:"data-"+k,value:v};};
return C;});
sap.ui.predefine('sap/ui/core/CustomizingConfiguration',['jquery.sap.global','./Core','./Component'],function(q,C,a){"use strict";var b="sap.ui.viewReplacements",c="sap.ui.viewExtensions",d="sap.ui.viewModifications",e="sap.ui.controllerExtensions",f="sap.ui.controllerReplacements";var m={};
function g(t,o,i){var s=o&&typeof o==="string"?o:(o&&a.getOwnerIdFor(o));if(s){var j=sap.ui.component(s);var k=j&&j.getMetadata().getComponentName();var l=m[k+"::"+s];if(l&&l[t]&&i(l[t])){return false;}else{l=m[k];if(l&&l[t]&&i(l[t])){return false;}}}else{q.each(m,function(k,l){if(l&&l[t]&&i(l[t])){return false;}});}}
var h={log:function(){if(window.console){window.console.log(m);}},activateForComponent:function(s){q.sap.log.info("CustomizingConfiguration: activateForComponent('"+s+"')");var F=s+".Component";q.sap.require(F);var o=q.sap.getObject(F).getMetadata().getCustomizing();m[s]=o;q.sap.log.debug("CustomizingConfiguration: customizing configuration for component '"+s+"' loaded: "+JSON.stringify(o));},deactivateForComponent:function(s){if(m[s]){q.sap.log.info("CustomizingConfiguration: deactivateForComponent('"+s+"')");delete m[s];}},activateForComponentInstance:function(o){q.sap.log.info("CustomizingConfiguration: activateForComponentInstance('"+o.getId()+"')");var s=o.getMetadata().getComponentName(),k=s+"::"+o.getId(),i=o.getManifest()["sap.ui5"]&&o.getManifest()["sap.ui5"]["extends"]&&o.getManifest()["sap.ui5"]["extends"]["extensions"];m[k]=i;q.sap.log.debug("CustomizingConfiguration: customizing configuration for component '"+k+"' loaded: "+JSON.stringify(i));},deactivateForComponentInstance:function(o){var s=o.getMetadata().getComponentName(),k=s+"::"+o.getId();if(m[k]){q.sap.log.info("CustomizingConfiguration: deactivateForComponent('"+k+"')");delete m[k];}},getViewReplacement:function(v,o){var r;g(b,o,function(i){r=i[v];return!!r;});return r;},getViewExtension:function(v,E,o){var r;g(c,o,function(i){r=i[v]&&i[v][E];return!!r;});return r;},getControllerExtension:function(s,o){var r;g(e,o,function(i){r=i[s];return!!r;});return r;},getControllerReplacement:function(s,o){var r;g(f,o,function(i){r=i[s];return!!r;});return r;},getCustomProperties:function(v,s,o){var S;g(d,o,function(i){var j=i[v]&&i[v][s];var u={};var V=false;if(j){q.each(j,function(n,k){if(n==="visible"){V=true;u[n]=k;q.sap.log.info("Customizing: custom value for property '"+n+"' of control '"+s+"' in View '"+v+"' applied: "+k);}else{q.sap.log.warning("Customizing: custom value for property '"+n+"' of control '"+s+"' in View '"+v+"' ignored: only the 'visible' property can be customized.");}});if(V){S=S||{};q.extend(S,u);}}});return S;},hasCustomProperties:function(v,o){var s={};g(d,o,function(i){if(!!i[v]){s=i[v];}});return(!q.isEmptyObject(s));}};if(sap.ui.getCore().getConfiguration().getDisableCustomizing()){q.sap.log.info("CustomizingConfiguration: disabling Customizing now");q.each(h,function(n,A){if(typeof A==="function"){h[n]=function(){};}});}return h;},true);
sap.ui.predefine('sap/ui/core/DeclarativeSupport',['jquery.sap.global','sap/ui/base/DataType','sap/ui/base/ManagedObject','./Control','./CustomData','./HTML','./mvc/View'],function(q,D,M,C,a,H,V){"use strict";var b={};b.attributes={"data-sap-ui-type":true,"data-sap-ui-id":true,"data-sap-ui-aggregation":true,"data-sap-ui-default-aggregation":true,"data-sap-ui-binding":function(v,s){var B=M.bindingParser(v);s.objectBindings=s.objectBindings||{};s.objectBindings[B.model||undefined]=B;},"data-tooltip":function(v,s){s["tooltip"]=v;},"tooltip":function(v,s,c){s["tooltip"]=v;q.sap.log.warning('[Deprecated] Control "'+s.id+'": The attribute "tooltip" is not prefixed with "data-*". Future version of declarative support will only suppport attributes with "data-*" prefix.');},"class":true,"style":true,"id":true};
b.compile=function(e,v,i){var t=this;q(e).find("[data-sap-ui-type]").filter(function(){return q(this).parents("[data-sap-ui-type]").length===0;}).each(function(){t._compile(this,v,i);});};
b._compile=function(e,v,i){var $=q(e);var t=$.attr("data-sap-ui-type");var c=[];var I=t==="sap.ui.core.UIArea";if(I){var d=this;$.children().each(function(){var o=d._createControl(this,v);if(o){c.push(o);}});}else{var o=this._createControl(e,v);if(o){c.push(o);}}$.empty();var A=[];q.each(e.attributes,function(f,g){var n=g.name;if(!I||I&&/^data-/g.test(n.toLowerCase())){A.push(n);}});if(A.length>0){$.removeAttr(A.join(" "));}c.forEach(function(o){if(o instanceof C){if(v&&!i){v.addContent(o);}else{o.placeAt(e);if(v){v.connectControl(o);}}}});};
b._createControl=function(e,v){var $=q(e);var c=null;var t=$.attr("data-sap-ui-type");if(t){q.sap.require(t);var f=q.sap.getObject(t);var s={};s.id=this._getId($,v);this._addSettingsForAttributes(s,f,e,v);this._addSettingsForAggregations(s,f,e,v);var c;if(V.prototype.isPrototypeOf(f.prototype)&&typeof f._sType==="string"){c=sap.ui.view(s,undefined,f._sType);}else{c=new f(s);}if(e.className){c.addStyleClass(e.className);}$.removeAttr("data-sap-ui-type");}else{c=this._createHtmlControl(e,v);}return c;};
b._createHtmlControl=function(e,v){var h=new H();h.setDOMContent(e);this.compile(e,v,true);return h;};
b._addSettingsForAttributes=function(s,c,e,v){var t=this;var S=b.attributes;var B=M.bindingParser;var d=[];var r=/^data-custom-data:(.+)/i;q.each(e.attributes,function(i,A){var n=A.name;var f=A.value;if(!r.test(n)){if(typeof S[n]==="undefined"){n=t.convertAttributeToSettingName(n,s.id);var p=t._getProperty(c,n);if(p){var o=B(f,v&&v.getController(),true);if(o&&typeof o==="object"){s[n]=o;}else{s[n]=t.convertValueToType(t.getPropertyDataType(p),o||f);}}else if(t._getAssociation(c,n)){var g=t._getAssociation(c,n);if(g.multiple){f=f.replace(/\s*,\s*|\s+/g,",");s[n]=f.split(",").map(function(I){return v?v.createId(I):I;});}else{s[n]=v?v.createId(f):f;}}else if(t._getAggregation(c,n)){var h=t._getAggregation(c,n);if(h.multiple){var o=B(f,v&&v.getController());if(o){s[n]=o;}else{throw new Error("Aggregation "+n+" with cardinality 0..n only allows binding paths as attribute value");}}else if(h.altTypes){var o=B(f,v&&v.getController(),true);if(o&&typeof o==="object"){s[n]=o;}else{s[n]=t.convertValueToType(h.altTypes[0],o||f);}}else{throw new Error("Aggregation "+n+" not supported");}}else if(t._getEvent(c,n)){var j=v&&(v._oContainingView||v).getController();var k=V._resolveEventHandler(f,j);if(k){s[n]=k;}else{throw new Error('Control "'+s.id+'": The function "'+f+'" for the event "'+n+'" is not defined');}}else{}}else if(typeof S[n]==="function"){S[n](f,s,c);}}else{n=q.sap.camelCase(r.exec(n)[1]);var o=B(f,v&&v.getController());d.push(new a({key:n,value:o||f}));}});if(d.length>0){s.customData=d;}return s;};
b._addSettingsForAggregations=function(s,c,e,v){var $=q(e);var d=this._getDefaultAggregation(c,e);var t=this;var A=c.getMetadata().getAllAggregations();$.children().each(function(){var f=q(this);var g=f.attr("data-sap-ui-aggregation");var T=f.attr("data-sap-ui-type");var u=false;if(!g){u=true;g=d;}if(g&&A[g]){var m=A[g].multiple;var h=function(o){var i=t._createControl(o,v);if(i){if(m){if(!s[g]){s[g]=[];}if(typeof s[g].path==="string"){s[g].template=i;}else{s[g].push(i);}}else{s[g]=i;}}};if(u||(T&&!u)){h(this);}else{f.children().each(function(){h(this);});}}f.removeAttr("data-sap-ui-aggregation");f.removeAttr("data-sap-ui-type");});return s;};
b._getId=function(e,v){var $=q(e);var i=$.attr("id");if(i){if(v){i=v.createId(i);$.attr("data-sap-ui-id",i);}$.attr("id","");}return i;};
b._getProperty=function(c,n){return c.getMetadata().getProperty(n);};
b.convertValueToType=function(t,v){if(t instanceof D){v=t.parseValue(v);}return typeof v==="string"?M.bindingParser.escape(v):v;};
b.getPropertyDataType=function(p){var t=D.getType(p.type);if(!t){throw new Error("Property "+p.name+" has no known type");}return t;};
b.convertAttributeToSettingName=function(A,i,d){if(A.indexOf("data-")===0){A=A.substr(5);}else if(d){q.sap.log.warning('[Deprecated] Control "'+i+'": The attribute "'+A+'" is not prefixed with "data-*". Future version of declarative support will only suppport attributes with "data-*" prefix.');}else{throw new Error('Control "'+i+'": The attribute "'+A+'" is not prefixed with "data-*".');}return q.sap.camelCase(A);};
b._getAssociation=function(c,n){return c.getMetadata().getAssociation(n);};
b._getAggregation=function(c,n){return c.getMetadata().getAggregation(n);};
b._getEvent=function(c,n){return c.getMetadata().getEvent(n);};
b._getDefaultAggregation=function(c,e){var $=q(e);var d=$.attr("data-sap-ui-default-aggregation")||c.getMetadata().getDefaultAggregationName();$.removeAttr("data-sap-ui-default-aggregation");return d;};
return b;},true);
sap.ui.predefine('sap/ui/core/EnabledPropagator',['./Control'],function(C){"use strict";var E=function(d,l){if(!(this instanceof C)){throw new Error("EnabledPropagator only supports subclasses of Control");}if(d===undefined){d=true;}function f(c){var p=c.getParent();while(p&&!p.getEnabled&&p.getParent){p=p.getParent();}return p;}if(this.getEnabled===undefined){this.getEnabled=function(){var p=f(this);return(p&&p.getEnabled&&!p.getEnabled())?false:this.getProperty("enabled");};if(l){this.getMetadata().addProperty("Enabled",{type:"boolean",group:"Behavior",defaultValue:!!d});}this.getMetadata().addProperty("enabled",{type:"boolean",group:"Behavior",defaultValue:!!d});this.getMetadata().addPublicMethods('getEnabled');}else{var o=this.getEnabled;this.getEnabled=function(){var p=f(this);return(p&&p.getEnabled&&!p.getEnabled())?false:o.apply(this);};}if(this.setEnabled===undefined){this.setEnabled=function(e){return this.setProperty("enabled",e);};this.getMetadata().addPublicMethods('setEnabled');}};return E;},true);
sap.ui.predefine('sap/ui/core/EventBus',['jquery.sap.global','sap/ui/base/Object','sap/ui/base/EventProvider'],function(q,B,E){"use strict";
var a=B.extend("sap.ui.core.EventBus",{constructor:function(){B.apply(this);this._mChannels={};this._defaultChannel=new E();}});
a.prototype.subscribe=function(c,e,f,l){if(typeof(e)==="function"){l=f;f=e;e=c;c=null;}var C=b(this,c);C.attachEvent(e,f,l);return this;};
a.prototype.subscribeOnce=function(c,e,f,l){if(typeof(e)==="function"){l=f;f=e;e=c;c=null;}function o(){this.unsubscribe(c,e,o,undefined);f.apply(l||this,arguments);}return this.subscribe(c,e,o,undefined);};
a.prototype.unsubscribe=function(c,e,f,l){if(typeof(e)==="function"){l=f;f=e;e=c;c=null;}var C=g(this,c);if(!C){return this;}C.detachEvent(e,f,l);if(C!=this._defaultChannel){var m=E.getEventList(C);var i=true;for(var I in m){if(C.hasListeners(I)){i=false;break;}}if(i){delete this._mChannels[c];}}return this;};
a.prototype.publish=function(c,e,d){if(arguments.length==1){d=null;e=c;c=null;}else if(arguments.length==2){if(typeof(e)!="string"){d=e;e=c;c=null;}}d=d?d:{};var C=g(this,c);if(!C){return;}var f=E.getEventList(C)[e];if(Array.isArray(f)){f=f.slice();var I;for(var i=0,l=f.length;i<l;i++){I=f[i];I.fFunction.call(I.oListener||this,c,e,d);}}};
a.prototype.getInterface=function(){return this;};
a.prototype.destroy=function(){this._defaultChannel.destroy();for(var c in this._mChannels){this._mChannels[c].destroy();}this._mChannels={};B.prototype.destroy.apply(this,arguments);};
function g(e,c){if(!c){return e._defaultChannel;}return e._mChannels[c];}
function b(e,c){var C=g(e,c);if(!C&&c){e._mChannels[c]=new E();C=e._mChannels[c];}return C;}
return a;});
sap.ui.predefine('sap/ui/core/ExtensionPoint',['jquery.sap.global'],function(q){"use strict";
sap.ui.extensionpoint=function(c,e,C,t,a){var b,v,r;var d=sap.ui.require('sap/ui/core/CustomizingConfiguration'),V=sap.ui.require('sap/ui/core/mvc/View'),F=sap.ui.require('sap/ui/core/Fragment');if(d){if(V&&c instanceof V){b=d.getViewExtension(c.sViewName,e,c);v=c;}else if(F&&c instanceof F){b=d.getViewExtension(c.getFragmentName(),e,c);v=c._oContainingView;}if(b){if(b.className){q.sap.require(b.className);var o=q.sap.getObject(b.className),I=v&&b.id?v.createId(b.id):b.id;q.sap.log.info("Customizing: View extension found for extension point '"+e+"' in View '"+v.sViewName+"': "+b.className+": "+(b.viewName||b.fragmentName));if(b.className==="sap.ui.core.Fragment"){var f=new o({id:I,type:b.type,fragmentName:b.fragmentName,containingView:v});r=(Array.isArray(f)?f:[f]);}else if(b.className==="sap.ui.core.mvc.View"){var v=sap.ui.view({type:b.type,viewName:b.viewName,id:I});r=[v];}else{q.sap.log.warning("Customizing: Unknown extension className configured (and ignored) in Component.js for extension point '"+e+"' in View '"+v.sViewName+"': "+b.className);}}else{q.sap.log.warning("Customizing: no extension className configured in Component.js for extension point '"+e+"' in View '"+v.sViewName+"': "+b.className);}}}if(!r&&typeof C==='function'){r=C();}if(r&&!Array.isArray(r)){r=[r];}if(r&&t){var A=t.getMetadata().getAggregation(a);if(A){for(var i=0,l=r.length;i<l;i++){t[A._sMutator](r[i]);}}else{q.sap.log.error("Creating extension point failed - Tried to add extension point with name "+e+" to an aggregation of "+t.getId()+" in view "+v.sViewName+", but sAggregationName was not provided correctly and I could not find a default aggregation");}}return r||[];};
return sap.ui.extensionpoint;});
sap.ui.predefine('sap/ui/core/Fragment',['jquery.sap.global','../base/ManagedObject','./Element','./DeclarativeSupport','./XMLTemplateProcessor'],function(q,M,E,D,X){"use strict";var r={},t={};
var F=M.extend("sap.ui.core.Fragment",{
metadata:{properties:{type:"string"},specialSettings:{fragmentName:'string',fragmentContent:'any',containingView:{type:'sap.ui.core.mvc.View',visibility:'hidden'},oController:{type:'sap.ui.core.mvc.Controller',visibility:'hidden'},sId:{type:'sap.ui.core.ID',visibility:'hidden'}}},
constructor:function(i,s){M.apply(this,arguments);if(this._aContent&&this._aContent.length==1){return this._aContent[0];}else{return this._aContent;}}
});
F.registerType=function(T,f){if(!typeof(T)==="string"){q.sap.log.error("Ignoring non-string Fragment type: "+T);return;}if(t[T]){q.sap.log.warning("sap.ui.core.Fragment.registerType(): Fragment type '"+T+"' is already defined. Overriding this type now!");}t[T]=f;};
F.prototype._initCompositeSupport=function(s){if(!s){throw new Error("Settings must be set");}if(!(s.fragmentName||s.fragmentContent)){throw new Error("Please provide a fragment name");}if(s.oController){this.oController=s.oController;}this._sExplicitId=s.sId||s.id;this._sFragmentName=s.fragmentName;var f=t[s.type];if(f){f.init.apply(this,[s]);}else{throw new Error("No type for the fragment has been specified: "+s.type);}};
F.prototype.getFragmentName=function(){return this._sFragmentName;};
F.prototype.getController=function(){return this.oController;};
F.byId=function(f,i){if(!(typeof(f)==="string"&&typeof(i)==="string")){q.sap.log.error("sap.ui.core.Fragment.byId: two strings must be given as parameters, but are: "+f+" and "+i);return undefined;}return sap.ui.getCore().byId(f+"--"+i);};
F.createId=function(f,i){if(!(typeof(f)==="string"&&typeof(i)==="string")){q.sap.log.error("sap.ui.core.Fragment.createId: two strings must be given as parameters, but are: "+f+" and "+i);return undefined;}return f+"--"+i;};
F.prototype.createId=function(i){var a=this._sExplicitId?this._sExplicitId+"--"+i:i;if(this._oContainingView&&this._oContainingView!=this){a=this._oContainingView.createId(a);}return a;};
F.prototype.isSubView=function(){return true;};
sap.ui.fragment=function(n,T,c){var s={};if(typeof(n)==="string"){s.fragmentName=n;s.oController=c;s.type=T;}else if(typeof(n)==="object"){s=n;if(T){s.oController=T;}}else{q.sap.log.error("sap.ui.fragment() must be called with Fragment name or config object as first parameter, but is: "+n);}return new F(s);};
sap.ui.xmlfragment=function(i,f,c){if(typeof(i)==="string"){if(typeof(f)==="string"){return sap.ui.fragment({fragmentName:f,sId:i,type:"XML"},c);}else{return sap.ui.fragment(i,"XML",f);}}else{i.type="XML";return sap.ui.fragment(i,f);}};
sap.ui.jsfragment=function(n,f){if(typeof(n)==="string"&&typeof(f)==="object"){if(f.createContent){r[n]=f;q.sap.declare({modName:n,type:"fragment"},false);}else{return sap.ui.fragment(n,"JS",f);}}else if(typeof(n)==="string"&&f===undefined){return sap.ui.fragment(n,"JS");}else{if(typeof(n)==="object"){n.type="JS";return sap.ui.fragment(n,f);}else if(arguments&&arguments.length>=3){return sap.ui.fragment({id:n,fragmentName:f,type:"JS"},arguments[2]);}else{q.sap.log.error("sap.ui.jsfragment() was called with wrong parameter set: "+n+" + "+f);}}};
sap.ui.htmlfragment=function(i,f,c){if(typeof(i)==="string"){if(typeof(f)==="string"){return sap.ui.fragment({fragmentName:f,sId:i,type:"HTML"},c);}else{return sap.ui.fragment(i,"HTML",f);}}else{i.type="HTML";return sap.ui.fragment(i,f);}};
F.registerType("XML",{init:function(s){if(s.fragmentContent){if(typeof(s.fragmentContent)==="string"){this._xContent=q.parseXML(s.fragmentContent).documentElement;}else{this._xContent=s.fragmentContent;}}else{this._xContent=X.loadTemplate(s.fragmentName,"fragment");}this._oContainingView=this._sExplicitId?this:(s.containingView||this);if((this._oContainingView===this)){this._oContainingView.oController=(s.containingView&&s.containingView.oController)||s.oController;}var a=this;M.runWithPreprocessors(function(){a._aContent=X.parseTemplate(a._xContent,a);if(a._aContent&&a._aContent.length&&s.objectBindings){a._aContent.forEach(function(c,i){if(c instanceof E){for(var m in s.objectBindings){c.bindObject(s.objectBindings[m]);}}});}},{settings:a._oContainingView._fnSettingsPreprocessor});}});F.registerType("JS",{init:function(s){if(!r[s.fragmentName]){q.sap.require({modName:s.fragmentName,type:"fragment"});}q.extend(this,r[s.fragmentName]);this._oContainingView=s.containingView||this;var a=this;M.runWithPreprocessors(function(){var c=a.createContent(s.oController||a._oContainingView.oController);a._aContent=[];a._aContent=a._aContent.concat(c);},{settings:a._oContainingView._fnSettingsPreprocessor});}});(function(){var _={};var a=function(T){var u=q.sap.getModulePath(T,".fragment.html");var h=_[u];var R;if(!h){R=q.sap.getResourceName(T,".fragment.html");h=q.sap.loadResource(R);_[u]=h;}return h;};F.registerType("HTML",{init:function(s){this._aContent=[];this.getContent=function(){return this._aContent;};this.addContent=function(c){this._aContent.push(c);};this._oContainingView=s.containingView||this;var h=s.fragmentContent||a(s.fragmentName);this._oTemplate=document.createElement("div");if(typeof h==="string"){this._oTemplate.innerHTML=h;}else{var n=h;var f=document.createDocumentFragment();for(var i=0;i<n.length;i++){f.appendChild(n.item(i));}this._oTemplate.appendChild(f);}var m=this._oTemplate.getElementsByTagName("template")[0];var p=this.getMetadata().getAllProperties();if(m){var b=this;q.each(m.attributes,function(I,A){var N=D.convertAttributeToSettingName(A.name,b.getId());var v=A.value;var P=p[N];if(!s[N]){if(P){s[N]=D.convertValueToType(D.getPropertyDataType(P),v);}else if(sap.ui.core.mvc.HTMLView._mAllowedSettings[N]){s[N]=v;}}});this._oTemplate=m;}if(this._oTemplate.content){var f=this._oTemplate.content;this._oTemplate=document.createElement("div");this._oTemplate.appendChild(f);}var b=this;M.runWithPreprocessors(function(){D.compile(b._oTemplate,b);var c=b.getContent();if(c&&c.length===1){b._aContent=[c[0]];}},{settings:b._oContainingView._fnSettingsPreprocessor});}});}());return F;});
sap.ui.predefine('sap/ui/core/FragmentControl',['jquery.sap.global','sap/ui/core/Control','sap/ui/core/FragmentControlMetadata','sap/ui/model/base/ManagedObjectModel','sap/ui/core/util/XMLPreprocessor','sap/ui/model/json/JSONModel','sap/ui/core/Fragment','sap/ui/base/ManagedObject','sap/ui/base/DataType','sap/ui/core/FragmentProxy'],function(q,C,F,M,X,J,a,b,D,P){"use strict";var c={};
function i(f,o){if(!c[f]){q.sap.require(f);c[f]=q.sap.getObject(f);}return c[f];}
function p(t,v,n,o){var B=b.bindingParser(v,o,true);if(B&&typeof B==="object"){return B;}var V=v=B||v;var T=D.getType(t);if(T){if(T instanceof D){V=T.parseValue(v);}}else{throw new Error("Property "+n+" has unknown type "+t);}return typeof V==="string"?b.bindingParser.escape(V):V;}
function d(m,n,E,I,v){var A=new J(E),o=I.getMetadata(),f=o.getAllAggregations(),h=o.getAllProperties(),s=o._mAllSpecialSettings;A.getVisitor=function(){return v;};A.getProperty=function(j,k){var r;j=this.resolve(j,k);j=j.substring(1);if(h.hasOwnProperty(j)){var l=h[j];if(!E.hasAttribute(j)){return l.defaultValue;}r=v.getResult(E.getAttribute(j))||E.getAttribute(j);if(r){var S=p(l.type,r,j);if(typeof S==="object"&&S.path){return r;}return S;}return null;}else if(f.hasOwnProperty(j)){var t=f[j];if(t.multiple===true&&t.type==="TemplateMetadataContext"){if(!E.hasAttribute(j)){return null;}return E.getAttribute(j);}return E.getAttribute(j);}else if(s.hasOwnProperty(j)){if(!E.hasAttribute(j)){return null;}r=v.getResult(E.getAttribute(j));if(r){return r;}return E.getAttribute(j);}};A.getContextName=function(){return n;};m[n]=A.getContext("/");}
function g(o){var s={};s.models=o.oModels||{};s.bindingContexts=o.oBindingContexts||{};return s;}
var e=C.extend("sap.ui.core.FragmentControl",{
metadata:{aggregations:{_content:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}}},
renderer:function(r,o){r.write("<div");r.writeControlData(o);r.writeClasses();r.write(">");var f=o.getAggregation(o.getMetadata().getCompositeAggregationName());if(f){r.renderControl(f);}r.write("</div>");}
},F);
e.prototype.applySettings=function(){this._bIsInitializing=true;var r=C.prototype.applySettings.apply(this,arguments);this._bIsInitializing=false;return r;};
e.prototype.byId=function(I){return sap.ui.getCore().byId(a.createId(this.getId(),I));};
e.prototype._getManagedObjectModel=function(){if(!this._oManagedObjectModel){this._oManagedObjectModel=new M(this);}return this._oManagedObjectModel;};
e.prototype.getSuppressInvalidateAggregation=function(n,s){var m=this.getMetadata(),A=m.getAggregation(n)||m.getAllPrivateAggregations()[n];if(!A){return true;}s=m._suppressInvalidate(A,s);m._requestFragmentRetemplatingCheck(this,A);return s;};
e.prototype.setProperty=function(n,v,s){var m=this.getMetadata(),o=m.getProperty(n);if(!o){return this;}s=this.getMetadata()._suppressInvalidate(o,s);if(C.prototype.getProperty.apply(this,[n])!==v){m._requestFragmentRetemplatingCheck(this,o);}return C.prototype.setProperty.apply(this,[n,v,s]);};
e.prototype.bindAggregation=function(n,o){var m=this.getMetadata(),A=m.getAggregation(n)||m.getAllPrivateAggregations()[n],B=C.prototype.getBinding.apply(this,[n]);if(!B||(B&&B.getPath()!==o.path)){m._requestFragmentRetemplatingCheck(this,A);}return C.prototype.bindAggregation.apply(this,[n,o]);};
e.prototype.unbindAggregation=function(n){var m=this.getMetadata(),A=m.getAggregation(n)||m.getAllPrivateAggregations()[n];if(this.isBound(n)){m._requestFragmentRetemplatingCheck(this,A,true);}return C.prototype.unbindAggregation.apply(this,[n]);};
e.prototype.setAggregation=function(n,o,s){return C.prototype.setAggregation.apply(this,[n,o,this.getSuppressInvalidateAggregation(n,s)]);};
e.prototype.addAggregation=function(n,o,s){return C.prototype.addAggregation.apply(this,[n,o,this.getSuppressInvalidateAggregation(n,s)]);};
e.prototype.insertAggregation=function(n,o,I,s){return C.prototype.insertAggregation.apply(this,[n,o,I,this.getSuppressInvalidateAggregation(n,s)]);};
e.prototype.removeAggregation=function(n,o,s){return C.prototype.removeAggregation.apply(this,[n,o,this.getSuppressInvalidateAggregation(n,s)]);};
e.prototype.removeAllAggregation=function(n,s){return C.prototype.removeAllAggregation.apply(this,[n,this.getSuppressInvalidateAggregation(n,s)]);};
e.prototype.destroyAggregation=function(n,s){return C.prototype.destroyAggregation.apply(this,[n,this.getSuppressInvalidateAggregation(n,s)]);};
e.prototype.updateAggregation=function(n,s){var A=this.getMetadata().getAggregation(n);if(A&&A.type==="TemplateMetadataContext"){this.invalidate();return;}C.prototype.updateAggregation.apply(this,arguments);};
e.prototype.setVisible=function(v){this.setProperty("visible",v);if(this.getParent()){this.getParent().invalidate();}return this;};
e.prototype._destroyCompositeAggregation=function(){var s=this.getMetadata().getCompositeAggregationName(),o=this.getAggregation(s);if(o){o.destroy();}return this;};
e.prototype.updateBindings=function(){if(this._bIsInitializing){return;}var r=C.prototype.updateBindings.apply(this,arguments);for(var n in this.mBindingInfos){var A=this.getMetadata().getAggregation(n);if(A&&A.multiple&&!A._doesNotRequireFactory&&this.isBound(n)&&!this.getBinding(n)){this[A._sDestructor]();}}return r;};
e.prototype._setCompositeAggregation=function(N){var s=this.getMetadata().getCompositeAggregationName();this._destroyCompositeAggregation();if(!this._oManagedObjectModel){this._getManagedObjectModel();}if(q.isArray(N)){this.setAggregation(s,null);return;}if(N){N.setModel(this._oManagedObjectModel,"$"+this.alias);N.bindObject("$"+this.alias+">/");}var t=this;this.setAggregation(s,N);var t=this;N._getPropertiesToPropagate=function(){var o=b.prototype._getPropertiesToPropagate.apply(this,arguments),B={},m={},f;for(var n in o.oBindingContexts){var h=o.oBindingContexts[n];if(h){f=h.getModel();if(f instanceof M&&f.getRootObject()instanceof e&&"$"+t.alias!==n){continue;}B[n]=o.oBindingContexts[n];}}for(var n in o.oModels){var f=o.oModels[n];if(f&&f instanceof M&&f.getRootObject()instanceof e&&"$"+t.alias!==n){continue;}m[n]=o.oModels[n];}o.oBindingContexts=B;o.oModels=m;return o;};this.invalidate();};
e.prototype._initCompositeSupport=function(s){var m=this.getMetadata(),A=m.getCompositeAggregationName(),I=false;if(s&&A){var n=s[A];if(n&&n.localName==="FragmentDefinition"){this._destroyCompositeAggregation();this._setCompositeAggregation(sap.ui.xmlfragment({sId:this.getId(),fragmentContent:s[A],oController:this}));I=true;}delete s[A];}if(!I){this._destroyCompositeAggregation();this._setCompositeAggregation(sap.ui.xmlfragment({sId:this.getId(),fragmentContent:this.getMetadata()._fragment,oController:this}));}};
e.prototype.requestFragmentRetemplating=function(f){if(f){this.fragmentRetemplating();return;}var A=this.getMetadata().getMandatoryAggregations(),B=true;for(var n in A){B=typeof this.getBindingInfo(n)==="object";if(!B){break;}}if(B){this.fragmentRetemplating();}};
e.prototype.fragmentRetemplating=function(){var m=this.getMetadata(),f=m.getFragment();if(!f){throw new Error("Fragment "+f.tagName+" not found");}var o=this._getManagedObjectModel();var t=this;o.getContextName=function(){return t.alias;};this.setModel(o,this.alias);this.bindObject(this.alias+">/");o._mSettings=g(this._getPropertiesToPropagate());delete o._mSettings.models["$"+this.alias];delete o._mSettings.bindingContexts["$"+this.alias];this.setModel(null,this.alias);X.process(f.querySelector("*"),{},o._mSettings);var s={};s[m.getCompositeAggregationName()]=f;this._initCompositeSupport(s);};
e.initialTemplating=function(E,v,f){var I=i(f),m={},o=I.getMetadata().getFragment();if(!o){throw new Error("Fragment "+f+" not found");}d(m,I.prototype.alias,E,I,v);var h=v["with"](m,true),j=I.getMetadata();h.visitChildNodes(o);var n=o.ownerDocument.createElementNS("http://schemas.sap.com/sapui5/extension/sap.ui.core.fragmentcontrol/1",j.getCompositeAggregationName());n.appendChild(o);E.appendChild(n);};
e.helper={listContext:function(o){var B=o.getModel().getProperty(o.getPath());if(typeof B==="string"){B=b.bindingParser(B);}if(q.isArray(B)){var f=o.getModel().getProperty(o.getPath()+"/@binding");if(f){return f.getModel().getMetaModel().getMetaContext(f.getPath());}else{return undefined;}}if(typeof B==="object"){var v=o.getModel().getVisitor();var m=v.getSettings().models[B.model];if(m){return m.createBindingContext(B.path);}return null;}else{return undefined;}},listMetaContext:function(o){var B=o.getModel().getProperty(o.getPath());if(typeof B==="string"){B=b.bindingParser(B);}if(q.isArray(B)){var f=o.getModel().getProperty(o.getPath()+"/@binding");if(f){return f.getModel().getMetaModel().getMetaContext(f.getPath());}else{return undefined;}}if(typeof B==="object"){var v=o.getModel().getVisitor();B=b.bindingParser("{"+B.path+"}");var m=v.getSettings().models[B.model];if(m){var h=m.getMetaModel();if(h&&h.getMetaContext){return h.getMetaContext(B.path);}}return null;}else{return undefined;}},runtimeProperty:function(o,v){if(o.getModel().getContextName){return"{$"+o.getModel().getContextName()+">"+o.getPath()+"}";}return v;},runtimeBinding:function(o,v){return"{Name}";},runtimeListBinding:function(o,v){if(q.isArray(v)){var B=o.getModel().getProperty(o.getPath()+"/@binding");if(B){return"{path: '"+B.getPath()+"'}";}return null;}return v;}};e.helper.listMetaContext.requiresIContext=true;e.helper.runtimeProperty.requiresIContext=true;e.helper.runtimeListBinding.requiresIContext=true;e.helper.runtimeBinding.requiresIContext=true;return e;},true);
sap.ui.predefine('sap/ui/core/FragmentControlMetadata',['jquery.sap.global','sap/ui/core/ElementMetadata','sap/ui/core/XMLTemplateProcessor'],function(q,E,X){"use strict";var I={Render:true,Template:"template",None:false};var F=function(c,C){if(!C.hasOwnProperty("renderer")){C.renderer="sap.ui.core.FragmentControlRenderer";}if(!C.hasOwnProperty("alias")){C.alias="this";}E.apply(this,arguments);var b=this._bAbstract;if(!b){if(!C.fragment&&c!=="sap.ui.core.FragmentControl"){C.fragment=c;C.fragmentUnspecified=true;}if(!this._fragment&&C.fragment){try{this._fragment=X.loadTemplate(C.fragment,"control");}catch(e){if(!C.fragmentUnspecified){throw(e);}else{q.sap.log.warning("Implicitly inferred fragment xml "+C.fragment+" not found. "+c+" is not abstract!");}}}}this._sCompositeAggregation=C.metadata?C.metadata.compositeAggregation||null:null;this._createPrivateAggregationAccessors();this._applyAggregationSettings();};F.prototype=Object.create(E.prototype);F.uid=E.uid;
F.prototype.getCompositeAggregationName=function(){return this._sCompositeAggregation||"_content";};
F.prototype.getFragment=function(){if(this._fragment){return this._fragment.cloneNode(true);}};
F.prototype._applyAggregationSettings=function(){var a=this.getAllAggregations();for(var n in a){if(a[n].type==="TemplateMetadataContext"){this.getAggregation(n)._doesNotRequireFactory=true;}}};
F.prototype._createPrivateAggregationAccessors=function(){var p=this.getAllPrivateAggregations(),a=this.getClass().prototype,g=function(b,f){if(!a[b]){a[b]=f;}};for(var n in p){p[n].generate(g);}};
F.prototype._suppressInvalidate=function(m,s){if(s){return true;}if(!m.appData){m.appData={};m.appData.invalidate=I.None;}if(m&&m.appData&&m.appData.invalidate===I.Render){return false;}return true;};
F.prototype._requestFragmentRetemplatingCheck=function(c,m,f){if(!c._bIsInitializing&&m&&m.appData&&m.appData.invalidate===I.Template&&!c._requestFragmentRetemplatingPending){if(c.requestFragmentRetemplating){c._requestFragmentRetemplatingPending=true;setTimeout(function(){c.requestFragmentRetemplating(f);c._requestFragmentRetemplatingPending=false;},0);}else{throw new Error("Function requestFragmentRetemplating not available although invalidationMode was set to template");}}};
F.prototype.getMandatoryAggregations=function(){if(!this._mMandatoryAggregations){var a=this.getAllAggregations(),m={};for(var n in a){if(a[n].type==="TemplateMetadataContext"&&a[n].appData.mandatory){m[n]=a[n];}}this._mMandatoryAggregations=m;}return this._mMandatoryAggregations;};
return F;},true);
sap.ui.predefine('sap/ui/core/FragmentProxy',['jquery.sap.global','sap/ui/base/ManagedObject','sap/ui/core/Control','sap/ui/core/Element'],function(q,M,C,E){"use strict";var c=["getParent","setParent","_getPropertiesToPropagate","destroy"];
function u(f){if(f._mProxyMethods){c.map(function(m){f[m]=f._mProxyMethods[m];});delete f._mProxyMethods;}}
function r(n,f){if(!f._mProxyMethods){f._mProxyMethods={};c.map(function(m){f._mProxyMethods[m]=f[m];});}f.getParent=function(){return n;};f.setParent=function(){u(this);return this.setParent.apply(this,arguments);};f.destroy=function(){u(this);this.destroy.apply(this,arguments);};f._getPropertiesToPropagate=function(){var p=sap.ui.base.ManagedObject.prototype._getPropertiesToPropagate.apply(this,arguments);var o=n.oModels;var m={};var b=p.oModels;for(var d in b){if(!b.hasOwnProperty(d)){continue;}if(!o[d]){m[d]=b[d];}}p.oModels=m;var B={};for(var d in m){B[d]=p.oBindingContexts[d];}p.oBindingContexts=B;return p;};}
function a(){var p=this.getParent();if(p){var n=this.sParentAggregationName,b=p.getBinding(n),A=p.getMetadata().getAggregation(n);if(!A||!A.multiple){throw new Error("Cannot use FragmentControl proxy with single aggregations (="+n+" in parent "+p+") on lists");}if(b){if(!p[A._sGetter].fnOriginalGetter){var o=p[A._sGetter];p[A._sGetter]=function(){var R=[];if(b){var d=b.getContexts();for(var i=0;i<d.length;i++){var O=d[i].getProperty();r(this,O);R.push(O);}this.mAggregations[A.name]=R;}return o.apply(this,[]);};p[A._sGetter].fnOriginalGetter=o;}}}}
var F=M.extend("sap.ui.core.FragmentProxy",{
constructor:function(i,s){if(!s&&i&&typeof i==="object"){s=i;i=M.getMetadata().uid();}s=s||{};if(s.ref){return new S(i,{ref:s.ref});}else{if(!s.type){s.type="sap.ui.core.Control";}var b=sap.ui.require(q.sap.getResourceName(s.type,""));if(!b){q.sap.log.debug("The given proxy type "+s.type+" is unknown. Using control instead.");s.type="sap.ui.core.Control";b=C;}var I=new(b)();if(!(I instanceof E)){q.sap.log.error("The given type "+s.type+" needs to derive from sap.ui.core.Element");return null;}I.attachModelContextChange(a);return I;}},
metadata:{properties:{type:{type:"string"}},aggregations:{ref:{type:"sap.ui.core.Control",multiple:true,_doesNotRequireFactory:true}}}
});
var S=C.extend("sap.ui.core.SingleFragmentProxy",{
metadata:{aggregations:{ref:{type:"sap.ui.core.Control",multiple:true,_doesNotRequireFactory:true}}},
renderer:function(R,o){var b=o._oContent;if(b&&b.getParent()===o.getParent()){R.renderControl(b);}}
});
S.prototype.updateRef=function(){var b=this.getBinding("ref");if(b){var o=b.getModel().getProperty(b.getPath(),b.getContext());if(Array.isArray(o)){q.sap.log.warning("Cannot add FragmentControl proxy with multiple aggregations");return;}if(o&&!o._bIsBeingDestroyed){r(this.getParent(),o);if(o.getParent()){o.getParent().invalidate();}}this._oContent=o;}};
return F;});
sap.ui.predefine('sap/ui/core/HTML',['jquery.sap.global','./Control','./RenderManager'],function(q,C,R){"use strict";var b=R.RenderPrefixes;
var H=C.extend("sap.ui.core.HTML",{metadata:{library:"sap.ui.core",properties:{content:{type:"string",group:"Misc",defaultValue:null},preferDOM:{type:"boolean",group:"Misc",defaultValue:true},sanitizeContent:{type:"boolean",group:"Misc",defaultValue:false},visible:{type:"boolean",group:"Appearance",defaultValue:true}},events:{afterRendering:{parameters:{isPreservedDOM:{type:"boolean"}}}}}});
H.prototype.getDomRef=function(s){var i=s?this.getId()+"-"+s:this.getId();return q.sap.domById(b.Dummy+i)||q.sap.domById(i);};
H.prototype.setContent=function(c){function p(s){if(q.parseHTML){var a=q.parseHTML(s);if(a){var d=0,e=a.length;while(d<e&&a[d].nodeType!=1){d++;}while(d<e&&a[e-1].nodeType!=1){e--;}if(d>0||e<a.length){a=a.slice(d,e);}return q(a);}}return q(s);}if(this.getSanitizeContent()){c=q.sap._sanitizeHTML(c);}this.setProperty("content",c,true);if(this.getDomRef()){var $=p(this.getContent());q(this.getDomRef()).replaceWith($);this._postprocessNewContent($);}else{this.invalidate();}return this;};
H.prototype.setSanitizeContent=function(s){this.setProperty("sanitizeContent",s,true);if(s){this.setContent(this.getContent());}return this;};
H.prototype.onBeforeRendering=function(){if(this.getPreferDOM()&&this.getDomRef()&&!R.isPreservedContent(this.getDomRef())){R.preserveContent(this.getDomRef(),true,false);}};
H.prototype.onAfterRendering=function(){if(!this.getVisible()){return;}var $=q(q.sap.domById(b.Dummy+this.getId()));var a=R.findPreservedContent(this.getId());var c;var i=false;if((!this.getPreferDOM()||a.size()==0)){a.remove();c=new q(this.getContent());$.replaceWith(c);}else if(a.size()>0){$.replaceWith(a);c=a;i=true;}else{$.remove();}this._postprocessNewContent(c);this.fireAfterRendering({isPreservedDOM:i});};
H.prototype._postprocessNewContent=function($){if($&&$.size()>0){if($.length>1){q.sap.log.warning("[Unsupported Feature]: "+this+" has rendered "+$.length+" root nodes!");}else{var c=$.attr("id");if(c&&c!=this.getId()){q.sap.log.warning("[Unsupported Feature]: Id of HTML Control '"+this.getId()+"' does not match with content id '"+c+"'!");}}R.markPreservableContent($,this.getId());if($.find("#"+this.getId().replace(/(:|\.)/g,'\\$1')).length===0){$.filter(":not([id])").first().attr("id",this.getId());}}else{q.sap.log.debug(""+this+" is empty after rendering, setting bOutput to false");this.bOutput=false;}};
H.prototype.setDOMContent=function(d){var $=q(d);if(this.getDomRef()){q(this.getDomRef()).replaceWith($);this._postprocessNewContent($);}else{$.appendTo(R.getPreserveAreaRef());if(this.getUIArea()){this.getUIArea().invalidate();}this._postprocessNewContent($);}return this;};
H.prototype.setTooltip=function(){q.sap.log.warning("The sap.ui.core.HTML control doesn't support tooltips. Add the tooltip to the HTML content instead.");return C.prototype.setTooltip.apply(this,arguments);};
"hasStyleClass addStyleClass removeStyleClass toggleStyleClass".split(" ").forEach(function(m){H.prototype[m]=function(){q.sap.log.warning("The sap.ui.core.HTML control doesn't support custom style classes. Manage custom CSS classes in the HTML content instead.");return C.prototype[m].apply(this,arguments);};});return H;});
sap.ui.predefine('sap/ui/core/HTMLRenderer',['./RenderManager'],function(R){"use strict";var a=R.RenderPrefixes;var H={render:function(r,c){r.write("<div id=\""+a.Dummy+c.getId()+"\" style=\"display:none\">");r.write("</div>");}};return H;},true);
sap.ui.predefine('sap/ui/core/History',['jquery.sap.global','sap/ui/base/Object','jquery.sap.storage'],function(q,B){"use strict";
var H=B.extend("sap.ui.core.History",{
constructor:function(i,s){B.apply(this);if(!s){s={};}var h=s.prefix?s.prefix:document.location.pathname;this._iMaxHistory=s.max?s.max:100;this._sHistoryId=h+i;this._oStorage=q.sap.storage(q.sap.storage.Type.local);this._fFilter=s.filter?s.filter:function(a,v){return a&&(!v||(v&&q.sap.startsWithIgnoreCase(a,v)));};this._fCheckHistory=s.checkHistory?s.checkHistory:function(a){return a;};},
_initHistory:function(){if(!this._aHistory){var h=this._oStorage.get(this._sHistoryId);if(typeof(h)==="string"){h=h.split(",");}else if(!h){h=[];}this._aHistory=this._fCheckHistory(h);}return this._aHistory;},
get:function(v){var h=this._initHistory();var r=[];for(var i=0;i<h.length;i++){if(this._fFilter(h[i],v)){r.push(h[i]);}}return r;},
remove:function(v){var h=this._initHistory();for(var i=0;i<h.length;i++){if(h[i]==v){h.splice(i,1);break;}}},
add:function(v){var h=this._initHistory();for(var i=0;i<h.length;i++){if(h[i]===v){h.splice(i,1);break;}}h.unshift(v);if(h.length>this._iMaxHistory){h.splice(this._iMaxHistory);}this._oStorage.put(this._sHistoryId,h);},
clear:function(){this._oStorage.remove(this._sHistoryId);this._aHistory=null;}
});
return H;});
sap.ui.predefine('sap/ui/core/Icon',['jquery.sap.global','../Device','./Control','./IconPool','./InvisibleText','./library'],function(q,D,C,I,a,l){"use strict";var b=l.IconColor;
var c=C.extend("sap.ui.core.Icon",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.ui.core",properties:{src:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},size:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},color:{type:"string",group:"Appearance",defaultValue:null},hoverColor:{type:"string",group:"Appearance",defaultValue:null},activeColor:{type:"string",group:"Appearance",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},backgroundColor:{type:"string",group:"Appearance",defaultValue:null},hoverBackgroundColor:{type:"string",group:"Appearance",defaultValue:null},activeBackgroundColor:{type:"string",group:"Appearance",defaultValue:null},decorative:{type:"boolean",group:"Accessibility",defaultValue:true},useIconTooltip:{type:"boolean",group:"Accessibility",defaultValue:true},alt:{type:"string",group:"Accessibility",defaultValue:null},noTabStop:{type:"boolean",group:"Accessibility",defaultValue:false}},aggregations:{_invisibleText:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{press:{}}}});
c.prototype[D.support.touch?"ontouchstart":"onmousedown"]=function(e){if(this.hasListeners("press")){e.setMarked();}var A=this.getActiveColor(),s=this.getActiveBackgroundColor(),i;if(A||s){if(!e.targetTouches||(e.targetTouches&&e.targetTouches.length===1)){i=this.$();i.addClass("sapUiIconActive");if(A){this._addColorClass(A,"color");}if(s){this._addColorClass(s,"background-color");}}}};c.prototype[D.support.touch?"ontouchend":"onmouseup"]=function(e){if(!e.targetTouches||(e.targetTouches&&e.targetTouches.length===0)){this.$().removeClass("sapUiIconActive");this._restoreColors();}};
c.prototype.onmouseover=function(){var h=this.getHoverColor(),H=this.getHoverBackgroundColor();if(h){this._addColorClass(h,"color");}if(H){this._addColorClass(H,"background-color");}};
c.prototype.onmouseout=function(){this._restoreColors();};
c.prototype[D.support.touch&&!D.system.desktop?"ontap":"onclick"]=function(e){if(this.hasListeners("press")){e.setMarked();}this.firePress({});};
c.prototype.onkeydown=function(e){if(e.which===q.sap.KeyCodes.SPACE||e.which===q.sap.KeyCodes.ENTER){e.preventDefault();var i=this.$(),A=this.getActiveColor(),s=this.getActiveBackgroundColor();i.addClass("sapUiIconActive");if(A){this._addColorClass(A,"color");}if(s){this._addColorClass(s,"background-color");}}};
c.prototype.onkeyup=function(e){if(e.which===q.sap.KeyCodes.SPACE||e.which===q.sap.KeyCodes.ENTER){this.$().removeClass("sapUiIconActive");this._restoreColors();this.firePress({});}};
c.prototype._restoreColors=function(){this._addColorClass(this.getColor()||"","color");this._addColorClass(this.getBackgroundColor()||"","background-color");};
c.prototype.setSrc=function(s){var i=I.getIconInfo(s),$=this.$(),d,t,u,L,o;this.setProperty("src",s,!!i);if(i&&$.length){$.css("font-family",i.fontFamily);$.attr("data-sap-ui-icon-content",i.content);$.toggleClass("sapUiIconMirrorInRTL",!i.suppressMirroring);t=this.getTooltip_AsString();L=this.getAriaLabelledBy();u=this.getUseIconTooltip();d=this._getIconLabel();if(t||(u&&i.text)){$.attr("title",t||i.text);}else{$.attr("title",null);}if(L.length===0){if(d){$.attr("aria-label",d);}else{$.attr("aria-label",null);}}else{o=this.getAggregation("_invisibleText");if(o){o.setText(d);}}}return this;};
c.prototype.setWidth=function(w){this.setProperty("width",w,true);this.$().css("width",w);return this;};
c.prototype.setHeight=function(h){this.setProperty("height",h,true);this.$().css({"height":h,"line-height":h});return this;};
c.prototype.setSize=function(s){this.setProperty("size",s,true);this.$().css("font-size",s);return this;};
c.prototype.setColor=function(s){this.setProperty("color",s,true);this._addColorClass(s,"color");return this;};
c.prototype._addColorClass=function(s,d){var i=this.$(),t=this;var e="";if(d==="color"){e="sapUiIconColor";}else if(d==="background-color"){e="sapUiIconBGColor";}else{return;}q.each(b,function(p,P){t.removeStyleClass(e+P);});if(s in b){i.css(d,"");this.addStyleClass(e+s);}else{i.css(d,s);}};
c.prototype.setActiveColor=function(s){return this.setProperty("activeColor",s,true);};
c.prototype.setHoverColor=function(s){return this.setProperty("hoverColor",s,true);};
c.prototype.setBackgroundColor=function(s){this.setProperty("backgroundColor",s,true);this._addColorClass(s,"background-color");return this;};
c.prototype.setActiveBackgroundColor=function(s){return this.setProperty("activeBackgroundColor",s,true);};
c.prototype.setHoverBackgroundColor=function(s){return this.setProperty("hoverBackgroundColor",s,true);};
c.prototype.attachPress=function(){var m=Array.prototype.slice.apply(arguments);m.unshift("press");C.prototype.attachEvent.apply(this,m);if(this.hasListeners("press")){this.$().toggleClass("sapUiIconPointer",true).attr({role:"button",tabindex:this.getNoTabStop()?undefined:0});}return this;};
c.prototype.detachPress=function(){var m=Array.prototype.slice.apply(arguments);m.unshift("press");C.prototype.detachEvent.apply(this,m);if(!this.hasListeners("press")){this.$().toggleClass("sapUiIconPointer",false).attr({role:this.getDecorative()?"presentation":"img"}).removeAttr("tabindex");}return this;};
c.prototype._getOutputTitle=function(){var i=I.getIconInfo(this.getSrc()),t=this.getTooltip_AsString(),u=this.getUseIconTooltip();if(t||(u&&i&&i.text)){return t||i.text;}};
c.prototype._getIconLabel=function(){var i=I.getIconInfo(this.getSrc()),A=this.getAlt(),t=this.getTooltip_AsString(),u=this.getUseIconTooltip(),L=A||t||(u&&i&&(i.text||i.name)),o=this._getOutputTitle();if(L&&L!==o){return L;}};
c.prototype._createInvisibleText=function(t){var i=this.getAggregation("_invisibleText");if(!i){i=new a(this.getId()+"-label",{text:t});this.setAggregation("_invisibleText",i,true);}else{i.setProperty("text",t,true);}return i;};
c.prototype._getAccessibilityAttributes=function(){var L=this.getAriaLabelledBy(),A={},i=this._getIconLabel(),o;if(this.getDecorative()){A.role="presentation";A.hidden="true";}else{if(this.hasListeners("press")){A.role="button";}else{A.role="img";}}if(L.length>0){if(i){o=this._createInvisibleText(i);L.push(o.getId());}A.labelledby=L.join(" ");}else if(i){A.label=i;}return A;};
c.prototype.getAccessibilityInfo=function(){if(this.getDecorative()){return null;}var h=this.hasListeners("press");var i=I.getIconInfo(this.getSrc());return{role:h?"button":"img",type:sap.ui.getCore().getLibraryResourceBundle("sap.ui.core").getText(h?"ACC_CTR_TYPE_BUTTON":"ACC_CTR_TYPE_IMAGE"),description:this.getAlt()||this.getTooltip_AsString()||(i?i.text||i.name:""),focusable:h};};
return c;});
sap.ui.predefine('sap/ui/core/IconPool',['jquery.sap.global','./Core','sap/ui/thirdparty/URI'],function(q,c,U){"use strict";var S='SAP-icons';var I='sap-icon';var r={'undefined':{'accidental-leave':0xe000,'account':0xe001,'wrench':0xe002,'windows-doors':0xe003,'washing-machine':0xe004,'visits':0xe005,'video':0xe006,'travel-expense':0x1e007,'temperature':0xe008,'task':0x1e009,'synchronize':0xe00a,'survey':0x1e00b,'settings':0xe00c,'search':0x1e00d,'sales-document':0x1e00e,'retail-store':0xe00f,'refresh':0xe010,'product':0xe011,'present':0xe012,'ppt-attachment':0xe013,'pool':0xe014,'pie-chart':0xe015,'picture':0xe016,'photo-voltaic':0xe017,'phone':0xe018,'pending':0xe019,'pdf-attachment':0xe01a,'past':0x1e01b,'outgoing-call':0xe01c,'opportunity':0xe01d,'opportunities':0x1e01e,'notes':0xe01f,'money-bills':0x1e020,'map':0xe021,'log':0xe022,'line-charts':0xe023,'lightbulb':0xe024,'leads':0xe025,'lead':0x1e026,'laptop':0xe027,'kpi-managing-my-area':0x1e028,'kpi-corporate-performance':0x1e029,'incoming-call':0xe02a,'inbox':0xe02b,'horizontal-bar-chart':0xe02c,'history':0xe02d,'heating-cooling':0xe02e,'gantt-bars':0xe02f,'future':0x1e030,'fridge':0xe031,'fallback':0xe032,'expense-report':0x1e033,'excel-attachment':0xe034,'energy-saving-lightbulb':0xe035,'employee':0xe036,'email':0xe037,'edit':0xe038,'duplicate':0xe039,'download':0xe03a,'doc-attachment':0xe03b,'dishwasher':0xe03c,'delete':0xe03d,'decline':0xe03e,'complete':0x1e03f,'competitor':0xe040,'collections-management':0xe041,'chalkboard':0x1e042,'cart':0xe043,'card':0xe044,'camera':0xe045,'calendar':0x1e046,'begin':0xe047,'basket':0xe048,'bar-chart':0xe049,'attachment':0xe04a,'arrow-top':0xe04b,'arrow-right':0xe04c,'arrow-left':0xe04d,'arrow-bottom':0xe04e,'approvals':0x1e04f,'appointment':0xe050,'alphabetical-order':0x1e051,'along-stacked-chart':0xe052,'alert':0xe053,'addresses':0xe054,'address-book':0x1e055,'add-filter':0xe056,'add-favorite':0xe057,'add':0xe058,'activities':0x1e059,'action':0xe05a,'accept':0x1e05b,'hint':0x1e05c,'group':0xe05d,'check-availability':0x1e05e,'weather-proofing':0xe05f,'payment-approval':0x1e060,'batch-payments':0x1e061,'bed':0xe062,'arobase':0x1e063,'family-care':0xe064,'favorite':0xe065,'navigation-right-arrow':0xe066,'navigation-left-arrow':0xe067,'e-care':0xe068,'less':0xe069,'lateness':0xe06a,'lab':0xe06b,'internet-browser':0xe06c,'instance':0xe06d,'inspection':0xe06e,'image-viewer':0xe06f,'home':0xe070,'grid':0xe071,'goalseek':0xe072,'general-leave-request':0xe073,'create-leave-request':0xe074,'flight':0xe075,'filter':0xe076,'favorite-list':0xe077,'factory':0xe078,'endoscopy':0xe079,'employee-pane':0xe07a,'employee-approvals':0x1e07b,'email-read':0xe07c,'electrocardiogram':0xe07d,'documents':0xe07e,'decision':0xe07f,'database':0xe080,'customer-history':0xe081,'customer':0xe082,'credit-card':0xe083,'create-entry-time':0xe084,'contacts':0xe085,'compare':0xe086,'clinical-order':0xe087,'chain-link':0xe088,'pull-down':0xe089,'cargo-train':0xe08a,'car-rental':0xe08b,'business-card':0xe08c,'bar-code':0xe08d,'folder-blank':0xe08e,'passenger-train':0xe08f,'question-mark':0x1e090,'world':0xe091,'iphone':0xe092,'ipad':0xe093,'warning':0xe094,'sort':0xe095,'course-book':0xe096,'course-program':0xe097,'add-coursebook':0xe098,'print':0xe099,'save':0xe09a,'play':0x1e09b,'pause':0xe09c,'record':0xe09d,'response':0xe09e,'pushpin-on':0xe09f,'pushpin-off':0xe0a0,'unfavorite':0xe0a1,'learning-assistant':0xe0a2,'timesheet':0xe0a3,'time-entry-request':0xe0a4,'list':0xe0a5,'action-settings':0xe0a6,'share':0xe0a7,'feed':0xe0a8,'role':0xe0a9,'flag':0x1e0aa,'post':0xe0ab,'inspect':0xe0ac,'inspect-down':0xe0ad,'appointment-2':0xe0ae,'target-group':0xe0af,'marketing-campaign':0xe0b0,'notification':0xe0b1,'message-error':0xe0b1,'comment':0xe0b2,'shipping-status':0xe0b3,'collaborate':0xe0b4,'shortcut':0xe0b5,'lead-outdated':0x1e0b6,'tools-opportunity':0xe0b7,'permission':0xe0b8,'supplier':0xe0b9,'table-view':0xe0ba,'table-chart':0xe0bb,'switch-views':0xe0bc,'e-learning':0xe0bd,'manager':0xe0be,'switch-classes':0xe0bf,'simple-payment':0x1e0c0,'signature':0xe0c1,'sales-order-item':0x1e0c2,'sales-order':0x1e0c3,'request':0xe0c4,'receipt':0xe0c5,'puzzle':0xe0c6,'process':0xe0c7,'private':0xe0c8,'popup-window':0xe0c9,'person-placeholder':0xe0ca,'per-diem':0x1e0cb,'paper-plane':0xe0cc,'paid-leave':0x1e0cd,'pdf-reader':0x1e0ce,'overview-chart':0xe0cf,'overlay':0xe0d0,'org-chart':0xe0d1,'number-sign':0xe0d2,'notification-2':0xe0d3,'my-sales-order':0x1e0d4,'meal':0xe0d5,'loan':0x1e0d6,'order-status':0x1e0d7,'customer-order-entry':0x1e0d8,'performance':0xe0d9,'menu':0xe0da,'employee-lookup':0xe0db,'education':0xe0dc,'customer-briefing':0xe0dd,'customer-and-contacts':0xe0de,'my-view':0xe0df,'accelerated':0xe0e0,'to-be-reviewed':0xe0e1,'warning2':0xe0e2,'feeder-arrow':0xe0e3,'quality-issue':0xe0e4,'workflow-tasks':0xe0e5,'create':0xe0e6,'home-share':0xe0e7,'globe':0x1e0e8,'tags':0xe0e9,'work-history':0xe0ea,'x-ray':0xe0eb,'wounds-doc':0xe0ec,'web-cam':0xe0ed,'waiver':0x1e0ee,'vertical-bar-chart':0xe0ef,'upstacked-chart':0xe0f0,'trip-report':0xe0f1,'microphone':0xe0f2,'unpaid-leave':0x1e0f3,'tree':0xe0f4,'toaster-up':0xe0f5,'toaster-top':0xe0f6,'toaster-down':0xe0f7,'time-account':0xe0f8,'theater':0xe0f9,'taxi':0xe0fa,'subway-train':0xe0fb,'study-leave':0xe0fc,'stethoscope':0xe0fd,'step':0xe0fe,'sonography':0xe0ff,'soccor':0xe100,'physical-activity':0xe101,'pharmacy':0xe102,'official-service':0xe103,'offsite-work':0xe104,'nutrition-activity':0xe105,'newspaper':0xe106,'monitor-payments':0x1e107,'map-2':0xe108,'machine':0xe109,'mri-scan':0xe10a,'end-user-experience-monitoring':0xe10b,'unwired':0xe10c,'customer-financial-fact-sheet':0x1e10d,'retail-store-manager':0xe10e,'Netweaver-business-client':0xe10f,'electronic-medical-record':0xe110,'eam-work-order':0x1e111,'customer-view':0xe112,'crm-service-manager':0xe113,'crm-sales':0x1e114,'widgets':0x1e115,'commission-check':0x1e116,'collections-insight':0x1e117,'clinical-tast-tracker':0xe118,'citizen-connect':0xe119,'cart-approval':0x1e11a,'capital-projects':0x1e11b,'bo-strategy-management':0xe11c,'business-objects-mobile':0xe11d,'business-objects-explorer':0xe11e,'business-objects-experience':0xe11f,'bbyd-dashboard':0xe120,'bbyd-active-sales':0x1e121,'business-by-design':0x1e122,'business-one':0x1e123,'sap-box':0xe124,'manager-insight':0xe125,'accounting-document-verification':0x1e126,'hr-approval':0x1e127,'idea-wall':0xe128,'Chart-Tree-Map':0xe129,'cart-5':0xe12a,'cart-4':0xe12b,'wallet':0xe12c,'vehicle-repair':0xe12d,'upload':0xe12e,'unlocked':0xe12f,'umbrella':0xe130,'travel-request':0x1e131,'travel-expense-report':0x1e132,'travel-itinerary':0xe133,'time-overtime':0x1e134,'thing-type':0xe135,'technical-object':0xe136,'tag':0xe137,'syringe':0xe138,'syntax':0xe139,'suitcase':0xe13a,'simulate':0xe13b,'shield':0xe13c,'share-2':0xe13d,'sales-quote':0x1e13e,'repost':0xe13f,'provision':0xe140,'projector':0xe141,'add-product':0xe142,'pipeline-analysis':0xe143,'add-photo':0xe144,'palette':0xe145,'nurse':0xe146,'sales-notification':0x1e147,'mileage':0xe148,'meeting-room':0xe149,'media-forward':0x1e14a,'media-play':0x1e14b,'media-pause':0xe14c,'media-reverse':0x1e14d,'media-rewind':0x1e14e,'measurement-document':0xe14f,'measuring-point':0xe150,'measure':0xe151,'map-3':0xe152,'locked':0xe153,'letter':0xe154,'journey-arrive':0xe155,'journey-change':0xe156,'journey-depart':0xe157,'it-system':0xe158,'it-instance':0xe159,'it-host':0xe15a,'iphone-2':0xe15b,'ipad-2':0xe15c,'inventory':0xe15d,'insurance-house':0xe15e,'insurance-life':0xe15f,'insurance-car':0xe160,'initiative':0xe161,'incident':0x1e162,'group-2':0xe163,'goal':0xe164,'functional-location':0xe165,'full-screen':0xe166,'form':0xe167,'fob-watch':0xe168,'blank-tag':0xe169,'family-protection':0xe16a,'folder':0xe16b,'fax-machine':0xe16c,'example':0xe16d,'eraser':0xe16e,'employee-rejections':0xe16f,'drop-down-list':0xe170,'draw-rectangle':0xe171,'document':0xe172,'doctor':0xe173,'discussion-2':0xe174,'discussion':0xe175,'dimension':0xe176,'customer-and-supplier':0xe177,'crop':0xe178,'add-contact':0xe179,'compare-2':0xe17a,'color-fill':0xe17b,'collision':0xe17c,'curriculum':0xe17d,'chart-axis':0xe17e,'full-stacked-chart':0xe17f,'full-stacked-column-chart':0xe180,'vertical-bar-chart-2':0xe181,'horizontal-bar-chart-2':0xe182,'horizontal-stacked-chart':0xe183,'vertical-stacked-chart':0xe184,'choropleth-chart':0x1e185,'geographic-bubble-chart':0x1e186,'multiple-radar-chart':0xe187,'radar-chart':0xe188,'crossed-line-chart':0xe189,'multiple-line-chart':0xe18a,'multiple-bar-chart':0xe18b,'line-chart':0xe18c,'line-chart-dual-axis':0xe18d,'bubble-chart':0xe18e,'scatter-chart':0xe18f,'multiple-pie-chart':0xe190,'column-chart-dual-axis':0xe191,'tag-cloud-chart':0xe192,'area-chart':0xe193,'cause':0xe194,'cart-3':0xe195,'cart-2':0xe196,'bus-public-transport':0xe197,'burglary':0xe198,'building':0xe199,'border':0xe19a,'bookmark':0xe19b,'badge':0xe19c,'attachment-audio':0xe19d,'attachment-video':0xe19e,'attachment-html':0xe19f,'attachment-photo':0xe1a0,'attachment-e-pub':0xe1a1,'attachment-zip-file':0xe1a2,'attachment-text-file':0xe1a3,'add-equipment':0xe1a4,'add-activity':0x1e1a5,'activity-individual':0xe1a6,'activity-2':0x1e1a7,'add-activity-2':0x1e1a8,'activity-items':0xe1a9,'activity-assigned-to-goal':0xe1aa,'status-completed':0xe1ab,'status-positive':0xe1ab,'status-error':0xe1ac,'status-negative':0xe1ac,'status-inactive':0xe1ad,'status-in-process':0xe1ae,'status-critical':0xe1ae,'blank-tag-2':0xe1af,'cart-full':0xe1b0,'locate-me':0xe1b1,'paging':0xe1b2,'company-view':0xe1b3,'document-text':0xe1b4,'explorer':0xe1b5,'personnel-view':0xe1b6,'sorting-ranking':0xe1b7,'drill-down':0xe1b8,'drill-up':0xe1b9,'vds-file':0xe1ba,'sap-logo-shape':0x1e1bb,'folder-full':0xe1bc,'system-exit':0xe1bd,'system-exit-2':0xe1be,'close-command-field':0xe1bf,'open-command-field':0xe1c0,'sys-enter-2':0x1e1c1,'sys-enter':0x1e1c2,'sys-help-2':0x1e1c3,'sys-help':0x1e1c4,'sys-back':0xe1c5,'sys-back-2':0xe1c6,'sys-cancel':0xe1c7,'sys-cancel-2':0xe1c8,'open-folder':0xe1c9,'sys-find-next':0xe1ca,'sys-find':0xe1cb,'sys-monitor':0xe1cc,'sys-prev-page':0xe1cd,'sys-first-page':0xe1ce,'sys-next-page':0xe1cf,'sys-last-page':0xe1d0,'generate-shortcut':0xe1d1,'create-session':0xe1d2,'display-more':0xe1d3,'enter-more':0xe1d4,'zoom-in':0xe1d5,'zoom-out':0xe1d6,'header':0xe1d7,'detail-view':0xe1d8,'show-edit':0xe1d8,'collapse':0xe1d9,'expand':0xe1da,'positive':0xe1db,'negative':0xe1dc,'display':0xe1dd,'menu2':0xe1de,'redo':0xe1df,'undo':0xe1e0,'navigation-up-arrow':0xe1e1,'navigation-down-arrow':0xe1e2,'down':0xe1e3,'up':0xe1e4,'shelf':0xe1e5,'background':0xe1e6,'resize':0xe1e7,'move':0xe1e8,'show':0xe1e9,'hide':0xe1ea,'nav-back':0xe1eb,'error':0xe1ec,'slim-arrow-right':0xe1ed,'slim-arrow-left':0xe1ee,'slim-arrow-down':0xe1ef,'slim-arrow-up':0xe1f0,'forward':0xe1f1,'overflow':0xe1f2,'value-help':0xe1f3,'multi-select':0x1e1f4,'exit-full-screen':0xe1f5,'sys-add':0xe1f6,'sys-minus':0xe1f7,'dropdown':0xe1f8,'expand-group':0xe1f9,'collapse-group':0xe200,'vertical-grip':0xe1fa,'horizontal-grip':0xe1fb,'sort-descending':0xe1fc,'sort-ascending':0xe1fd,'arrow-down':0xe1fe,'legend':0xe1ff,'message-warning':0xe201,'message-information':0x1e202,'message-success':0x1e203,'restart':0xe204,'stop':0xe205,'add-process':0xe206,'cancel-maintenance':0xe207,'activate':0xe208,'resize-horizontal':0xe209,'resize-vertical':0xe20a,'connected':0xe20b,'disconnected':0xe20c,'edit-outside':0xe20d,'key':0xe20e,'minimize':0xe20f,'back-to-top':0xe210,'hello-world':0xe211,'outbox':0xe212,'donut-chart':0xe213,'heatmap-chart':0xe214,'horizontal-bullet-chart':0xe215,'vertical-bullet-chart':0xe216,'call':0xe217,'download-from-cloud':0xe218,'upload-to-cloud':0xe219,'jam':0xe21a,'sap-ui5':0xe21b,'message-popup':0xe21c,'cloud':0xe21d,'horizontal-waterfall-chart':0x1e21e,'vertical-waterfall-chart':0x1e21f,'broken-link':0xe220,'headset':0xe221,'thumb-up':0x1e222,'thumb-down':0x1e223,'multiselect-all':0x1e224,'multiselect-none':0x1e225,'scissors':0xe226,'sound':0x1e227,'sound-loud':0x1e228,'sound-off':0x1e229,'date-time':0x1e22a,'user-settings':0xe22b,'key-user-settings':0xe22c,'developer-settings':0xe22d,'text-formatting':0x1e22e,'bold-text':0x1e22f,'italic-text':0x1e230,'underline-text':0x1e231,'text-align-justified':0xe232,'text-align-left':0xe233,'text-align-center':0xe234,'text-align-right':0xe235,'bullet-text':0x1e236,'numbered-text':0x1e237,'co':0xe238,'ui-notifications':0xe239,'bell':0xe23a,'cancel-share':0xe23b,'write-new-document':0xe23c,'write-new':0xe23d,'cancel':0x1e23e,'screen-split-one':0xe23f,'screen-split-two':0xe240,'screen-split-three':0xe241,'customize':0xe242,'user-edit':0xe243,'source-code':0xe244,'copy':0xe245,'paste':0xe246,'line-chart-time-axis':0x1e247,'clear-filter':0xe248,'reset':0xe249,'trend-up':0xe24a,'trend-down':0xe24b,'cursor-arrow':0xe24c,'add-document':0xe24d,'create-form':0xe24e,'resize-corner':0xe24f,'chevron-phase':0xe250,'chevron-phase-2':0xe251,'rhombus-milestone':0xe252,'rhombus-milestone-2':0xe253,'circle-task':0xe254,'circle-task-2':0xe255,'project-definition-triangle':0xe256,'project-definition-triangle-2':0xe257,'master-task-triangle':0xe258,'master-task-triangle-2':0xe259,'program-triangles':0xe25a,'program-triangles-2':0xe25b,'mirrored-task-circle':0xe25c,'mirrored-task-circle-2':0xe25d,'checklist-item':0xe25e,'checklist-item-2':0xe25f,'checklist':0xe260,'checklist-2':0xe261,'chart-table-view':0xe262,'filter-analytics':0xe263,'filter-facets':0xe264,'filter-fields':0xe265,'indent':0xe266,'outdent':0xe267,'heading1':0x1e268,'heading2':0x1e269,'heading3':0x1e26a,'decrease-line-height':0xe26b,'increase-line-height':0xe26c,'fx':0x1e26d,'add-folder':0xe26e,'away':0xe26f,'busy':0xe270,'appear-offline':0xe271,'blur':0xe272,'pixelate':0xe273,'horizontal-combination-chart':0xe274,'add-employee':0xe275,'text-color':0x1e276,'browse-folder':0xe277,'primary-key':0xe278,'two-keys':0xe279,'strikethrough':0xe27a,'text':0xe27b,'responsive':0xe27c,'desktop-mobile':0xe27d,'table-row':0xe27e,'table-column':0xe27f,'validate':0x1e280,'keyboard-and-mouse':0xe281,'touch':0xe282}};var f=false;var C=sap.ui.getCore().getLibraryResourceBundle("sap.ui.core");var a;var b={};
b.createControlByURI=function(s,d){if(typeof s==="string"){s={src:s};}if(s&&s.src){var e=s.src,g=d;if(b.isIconURI(e)){a=a||sap.ui.requireSync("sap/ui/core/Icon");g=a;if(s.tap){s.press=s.tap;delete s.tap;}}if(typeof g==="function"){s=g.getMetadata().removeUnknownSettings(s);return new g(s);}}};
b.addIcon=function(d,e,g){if(typeof g==="string"){g={fontFamily:arguments[2],content:arguments[3],overWrite:!!arguments[4],suppressMirroring:!!arguments[5]};}if(typeof e!=="string"){e=String(e);}e=e==='undefined'?undefined:e;if(!r[e]){r[e]={};}var h=r[e],j=h[d],p,s,t,k;if(j){if(e===undefined){q.sap.log.warning("Icon with name '"+d+"' in built-in collection already exists and can not be overwritten.","sap.ui.core.IconPool");return;}else if(!g.overWrite){q.sap.log.warning("Icon with name '"+d+"' in collection '"+e+"' already exists. Specify 'iconInfo.overWrite' in order to overwrite.","sap.ui.core.IconPool");return;}}p={protocol:I,hostname:e||d,path:e?d:undefined};if(Array.isArray(g.content)){s=g.content.map(m).join('');}else{s=m(g.content);}if(q.sap.resources.isBundle(g.resourceBundle)){k="Icon."+d;if(g.resourceBundle.hasText(k)){t=g.resourceBundle.getText(k);}}j=h[d]={name:d,collection:e,uri:U.build(p),fontFamily:g.fontFamily,content:s,text:t||'',suppressMirroring:g.suppressMirroring,skipMirroring:g.suppressMirroring};return j;};
b.getIconURI=function(d,e){var g=this.getIconInfo(d,e);return g&&g.uri;};
b.getIconInfo=function(d,e){b.insertFontFaceStyle();var p,g,h;if(b.isIconURI(d)){p=U.parse(d);if(p.path.length===1){e=undefined;d=p.hostname;}else{e=p.hostname;d=p.path.slice(1);}}g=r[e];h=g&&g[d];if(typeof h==='number'){g[d]=undefined;h=b.addIcon(d,undefined,{fontFamily:S,content:h&0xFFFF,suppressMirroring:!!(h&0x10000),resourceBundle:C});}return h;};
b.isIconURI=function(u){if(!u){return false;}var p=U.parse(u);return(p.protocol===I)&&!!p.hostname;};
b.getIconCollectionNames=function(){return Object.keys(r);};
b.getIconNames=function(d){var e=r[d];return e?Object.keys(e):[];};
b.insertFontFaceStyle=function(){if(f){return;}var F=q.sap.getModulePath("sap.ui.core.themes.base","/fonts/"),s;s="@font-face {"+"font-family: 'SAP-icons';"+"src: url('"+F+"SAP-icons.woff2') format('woff2'),"+"url('"+F+"SAP-icons.woff') format('woff'),"+"url('"+F+"SAP-icons.ttf') format('truetype'),"+"local('SAP-icons');"+"font-weight: normal;"+"font-style: normal;"+"}";q('head').append('<style type="text/css">'+s+'</style>');f=true;};
var i={"application/msword":"sap-icon://doc-attachment","application/vnd.openxmlformats-officedocument.wordprocessingml.document":"sap-icon://doc-attachment","application/rtf":"sap-icon://doc-attachment","application/pdf":"sap-icon://pdf-attachment","application/vnd.openxmlformats-officedocument.spreadsheetml.sheet":"sap-icon://excel-attachment","application/vnd.ms-excel":"sap-icon://excel-attachment","application/msexcel":"sap-icon://excel-attachment","application/vnd.ms-powerpoint":"sap-icon://ppt-attachment","application/vnd.openxmlformats-officedocument.presentationml.presentation":"sap-icon://ppt-attachment","application/vnd.openxmlformats-officedocument.presentationml.slideshow":"sap-icon://ppt-attachment","application/mspowerpoint":"sap-icon://ppt-attachment","application/xml":"sap-icon://attachment-html","application/xhtml+xml":"sap-icon://attachment-html","application/x-httpd-php":"sap-icon://attachment-html","application/x-javascript":"sap-icon://attachment-html","application/gzip":"sap-icon://attachment-zip-file","application/x-rar-compressed":"sap-icon://attachment-zip-file","application/x-tar":"sap-icon://attachment-zip-file","application/zip":"sap-icon://attachment-zip-file","audio/voxware":"sap-icon://attachment-audio","audio/x-aiff":"sap-icon://attachment-audio","audio/x-midi":"sap-icon://attachment-audio","audio/x-mpeg":"sap-icon://attachment-audio","audio/x-pn-realaudio":"sap-icon://attachment-audio","audio/x-pn-realaudio-plugin":"sap-icon://attachment-audio","audio/x-qt-stream":"sap-icon://attachment-audio","audio/x-wav":"sap-icon://attachment-audio","image/png":"sap-icon://attachment-photo","image/tiff":"sap-icon://attachment-photo","image/bmp":"sap-icon://attachment-photo","image/jpeg":"sap-icon://attachment-photo","image/gif":"sap-icon://attachment-photo","text/plain":"sap-icon://attachment-text-file","text/comma-separated-values":"sap-icon://attachment-text-file","text/css":"sap-icon://attachment-text-file","text/html":"sap-icon://attachment-text-file","text/javascript":"sap-icon://attachment-text-file","text/richtext":"sap-icon://attachment-text-file","text/rtf":"sap-icon://attachment-text-file","text/tab-separated-values":"sap-icon://attachment-text-file","text/xml":"sap-icon://attachment-text-file","video/mpeg":"sap-icon://attachment-video","video/quicktime":"sap-icon://attachment-video","video/x-msvideo":"sap-icon://attachment-video","application/x-shockwave-flash":"sap-icon://attachment-video"};
b.getIconForMimeType=function(M){return i[M]||"sap-icon://document";};
function m(d){return String.fromCharCode(typeof d==='number'?d:parseInt(d,16));}
return b;},true);
sap.ui.predefine('sap/ui/core/IconRenderer',['jquery.sap.global','./IconPool','./library'],function(q,I,l){"use strict";var a=l.IconColor;var b={};
b.render=function(r,c){var i=I.getIconInfo(c.getSrc()),w=c.getWidth(),h=c.getHeight(),C=c.getColor(),B=c.getBackgroundColor(),s=c.getSize(),n=c.getNoTabStop(),L=c.getAriaLabelledBy(),A=c._getAccessibilityAttributes(),t=c._getOutputTitle(),o=c.getAggregation("_invisibleText");r.write("<span");r.writeControlData(c);r.writeAccessibilityState(c,A);if(t){r.writeAttributeEscaped("title",t);}if(c.hasListeners("press")&&!n){r.writeAttribute("tabindex",0);}if(i){r.writeAttributeEscaped("data-sap-ui-icon-content",i.content);r.addStyle("font-family","'"+q.sap.encodeHTML(i.fontFamily)+"'");}if(w){r.addStyle("width",w);}if(h){r.addStyle("height",h);r.addStyle("line-height",h);}if(C&&!(C in a)){r.addStyle("color",q.sap.encodeHTML(C));}if(B&&!(B in a)){r.addStyle("background-color",q.sap.encodeHTML(B));}if(s){r.addStyle("font-size",s);}r.addClass("sapUiIcon");if(i&&!i.suppressMirroring){r.addClass("sapUiIconMirrorInRTL");}if(c.hasListeners("press")){r.addClass("sapUiIconPointer");}r.writeClasses();r.writeStyles();r.write(">");if(L.length&&o){r.renderControl(o);}r.write("</span>");};
return b;},true);
sap.ui.predefine('sap/ui/core/IntervalTrigger',['jquery.sap.global','../base/Object','./EventBus'],function(q,B,E){"use strict";var _="sapUiIntervalTrigger-event";
var I=B.extend("sap.ui.core.IntervalTrigger",{constructor:function(i){B.apply(this);this._oEventBus=new E();this._delayedCallId=null;this._triggerProxy=q.proxy(t,this);this._iInterval=0;if(i){this.setInterval(i);}}});
var t=function(){q.sap.clearDelayedCall(this._delayedCallId);var h=this._oEventBus._defaultChannel.hasListeners(_);if(this._iInterval>0&&h){this._oEventBus.publish(_);this._delayedCallId=q.sap.delayedCall(this._iInterval,this,this._triggerProxy);}};
I.prototype.destroy=function(){B.prototype.destroy.apply(this,arguments);delete this._triggerProxy;this._oEventBus.destroy();delete this._oEventBus;};
I.prototype.setInterval=function(i){if(this._iInterval!==i){this._iInterval=i;this._triggerProxy();}};
I.prototype.addListener=function(f,l){this._oEventBus.subscribe(_,f,l);this._triggerProxy();};
I.prototype.removeListener=function(f,l){this._oEventBus.unsubscribe(_,f,l);};
I.prototype.getInterface=function(){return this;};
return I;});
sap.ui.predefine('sap/ui/core/InvisibleText',['jquery.sap.global','./Control','./library','jquery.sap.encoder'],function(q,C,l){"use strict";
var I=C.extend("sap.ui.core.InvisibleText",{
metadata:{library:"sap.ui.core",publicMethods:["toStatic"],properties:{text:{type:"string",defaultValue:""}}},
renderer:function(r,c){r.write("<span");r.writeControlData(c);r.addClass("sapUiInvisibleText");r.writeClasses();r.writeAttribute("aria-hidden","true");r.write(">");r.writeEscaped(c.getText()||"");r.write("</span>");}
});
I.prototype.setBusy=function(){q.sap.log.warning("Property busy is not supported by control sap.ui.core.InvisibleText.");return this;};
I.prototype.setBusyIndicatorDelay=function(){q.sap.log.warning("Property busyIndicatorDelay is not supported by control sap.ui.core.InvisibleText.");return this;};
I.prototype.setVisible=function(){q.sap.log.warning("Property visible is not supported by control sap.ui.core.InvisibleText.");return this;};
I.prototype.setTooltip=function(){q.sap.log.warning("Aggregation tooltip is not supported by control sap.ui.core.InvisibleText.");return this;};
I.prototype.setText=function(t){this.setProperty("text",t,true);this.$().html(q.sap.encodeHTML(this.getText()||""));return this;};
I.prototype.toStatic=function(){var c=sap.ui.getCore();try{var s=c.getStaticAreaRef();var r=c.createRenderManager();r.render(this,s);r.destroy();}catch(e){this.placeAt("sap-ui-static");}return this;};
return I;});
sap.ui.predefine('sap/ui/core/Item',['./Element','./library'],function(E,l){"use strict";var T=l.TextDirection;
var I=E.extend("sap.ui.core.Item",{metadata:{library:"sap.ui.core",properties:{text:{type:"string",group:"Misc",defaultValue:""},enabled:{type:"boolean",group:"Misc",defaultValue:true},textDirection:{type:"sap.ui.core.TextDirection",group:"Misc",defaultValue:T.Inherit},key:{type:"string",group:"Data",defaultValue:null}}}});
return I;});
sap.ui.predefine('sap/ui/core/LayoutData',['jquery.sap.global','./Element','./library'],function(q,E,l){"use strict";
var L=E.extend("sap.ui.core.LayoutData",{metadata:{"abstract":true,library:"sap.ui.core"}});
L.prototype.invalidate=function(){var p=this.getParent();if(p&&p.getMetadata().getName()=="sap.ui.core.VariantLayoutData"){p=p.getParent();}if(p){var o=p.getParent();if(o){var e=q.Event("LayoutDataChange");e.srcControl=p;o._handleEvent(e);}}};
L.prototype.setLayoutData=function(o){return this;};
return L;});
sap.ui.predefine('sap/ui/core/ListItem',['./Item','./library'],function(I,l){"use strict";
var L=I.extend("sap.ui.core.ListItem",{metadata:{library:"sap.ui.core",properties:{icon:{type:"string",group:"Appearance",defaultValue:null},additionalText:{type:"string",group:"Data",defaultValue:null}}}});
return L;});
sap.ui.predefine('sap/ui/core/LocalBusyIndicator',['jquery.sap.global','./Control','./library','./theming/Parameters'],function(q,C,l,P){"use strict";
var L=C.extend("sap.ui.core.LocalBusyIndicator",{metadata:{deprecated:true,library:"sap.ui.core",properties:{width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:'100px'},height:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:'100px'}}}});
(function(){
L.prototype.init=function(){var r="sap.ui.core.LocalBusyIndicator:";var p="sapUiLocalBusyIndicatorBoxSize";p=P.get(r+p);this._iBoxSize=8;p="sapUiLocalBusyIndicatorBoxColor";this._sBoxColor=P.get(r+p);p="sapUiLocalBusyIndicatorBoxColorActive";this._sBoxColorActive=P.get(r+p);this._animateProxy=q.proxy(a,this);};
L.prototype.exit=function(){q.sap.clearDelayedCall(this._delayedCallId);delete this._delayedCallId;};
L.prototype.onThemeChanged=function(e){if(this.getDomRef()){this.invalidate();}};
L.prototype.onAfterRendering=function(){var w=parseInt(this.getWidth(),10);var h=parseInt(this.getHeight(),10);var $=this.$();$.css("width",w+"px");$.css("height",h+"px");var b=this.$("animation");var c=Math.floor(w/2);c-=Math.floor((5*this._iBoxSize)/2);var t=Math.floor(h/2)-Math.floor(this._iBoxSize/2);b.css("left",c+"px");b.css("top",t+"px");if(!this._$left){this._$left=this.$("leftBox");}if(!this._$middle){this._$middle=this.$("middleBox");}if(!this._$right){this._$right=this.$("rightBox");}this._delayedCallId=q.sap.delayedCall(0,this,this._animateProxy);};
var a=function(){if(this.getDomRef()){var t=this;var $,b,c;var d="",e="";if(t._$left){$=t._$left;}else{return;}if(t._$middle){b=t._$middle;}else{return;}if(t._$right){c=t._$right;}else{return;}if(t._sBoxColor){d=t._sBoxColor;}else{return;}if(t._sBoxColorActive){e=t._sBoxColorActive;}else{return;}$.css("background-color",e);setTimeout(function(){$.css("background-color",d);b.css("background-color",e);setTimeout(function(){b.css("background-color",d);c.css("background-color",e);setTimeout(function(){c.css("background-color",d);},150);},150);},150);this._delayedCallId=q.sap.delayedCall(1200,this,this._animateProxy);}};}());return L;});
sap.ui.predefine('sap/ui/core/LocalBusyIndicatorRenderer',function(){"use strict";var L={};
L.render=function(R,c){R.write("<div");R.writeControlData(c);R.addClass("sapUiLocalBusyIndicator");R.writeClasses();R.write(">");r(R,c);R.write("</div>");};
var r=function(R,c){var I=c.getId();var s=I+"-animation";var b=["-leftBox","-middleBox","-rightBox"];R.write('<div');R.writeAttribute('id',s);R.addClass("sapUiLocalBusyIndicatorAnimation");R.writeClasses();R.write(">");for(var i=0;i<b.length;i++){R.write('<div');R.addClass("sapUiLocalBusyIndicatorBox");R.writeClasses();R.writeAttribute("id",I+b[i]);R.write(">");R.write("</div>");}R.write("</div>");};return L;},true);
sap.ui.predefine('sap/ui/core/LocalBusyIndicatorSupport',['jquery.sap.global','./Control'],function(q,C){"use strict";var L=function(){if(this===C.prototype){this.setDelay=this.setBusyIndicatorDelay;}else{q.sap.log.error("Only controls can use the LocalBusyIndicator",this);}};return L;},true);
sap.ui.predefine('sap/ui/core/LocaleData',['jquery.sap.global','sap/ui/base/Object','./Configuration','./Locale'],function(q,B,C,L){"use strict";
var a=B.extend("sap.ui.core.LocaleData",{
constructor:function(o){this.oLocale=o;B.apply(this);this.mData=e(o);},
_get:function(){return this._getDeep(this.mData,arguments);},
_getDeep:function(o,p){var r=o;for(var i=0;i<p.length;i++){r=r[p[i]];if(r===undefined){break;}}return r;},
getOrientation:function(){return this._get("orientation");},
getLanguages:function(){return this._get("languages");},
getScripts:function(){return this._get("scripts");},
getTerritories:function(){return this._get("territories");},
getMonths:function(w,s){return this._get(g(s),"months","format",w);},
getMonthsStandAlone:function(w,s){return this._get(g(s),"months","stand-alone",w);},
getDays:function(w,s){return this._get(g(s),"days","format",w);},
getDaysStandAlone:function(w,s){return this._get(g(s),"days","stand-alone",w);},
getQuarters:function(w,s){return this._get(g(s),"quarters","format",w);},
getQuartersStandAlone:function(w,s){return this._get(g(s),"quarters","stand-alone",w);},
getDayPeriods:function(w,s){return this._get(g(s),"dayPeriods","format",w);},
getDayPeriodsStandAlone:function(w,s){return this._get(g(s),"dayPeriods","stand-alone",w);},
getDatePattern:function(s,h){return this._get(g(h),"dateFormats",s);},
getTimePattern:function(s,h){return this._get(g(h),"timeFormats",s);},
getDateTimePattern:function(s,h){return this._get(g(h),"dateTimeFormats",s);},
getCombinedDateTimePattern:function(D,t,s){var h=this.getDateTimePattern(D,s),i=this.getDatePattern(D,s),T=this.getTimePattern(t,s);return h.replace("{0}",T).replace("{1}",i);},
getCustomDateTimePattern:function(s,h){var A=this._get(g(h),"dateTimeFormats","availableFormats");return this._getFormatPattern(s,A,h);},
getIntervalPattern:function(i,s){var I=this._get(g(s),"dateTimeFormats","intervalFormats"),h,j,D,o,p;if(i){h=i.split("-");j=h[0];D=h[1];o=I[j];if(o){p=o[D];if(p){return p;}}}return I.intervalFormatFallback;},
getCombinedIntervalPattern:function(p,s){var i=this._get(g(s),"dateTimeFormats","intervalFormats"),F=i.intervalFormatFallback;return F.replace(/\{(0|1)\}/g,p);},
getCustomIntervalPattern:function(s,G,h){var A=this._get(g(h),"dateTimeFormats","intervalFormats");return this._getFormatPattern(s,A,h,G);},
_getFormatPattern:function(s,A,h,D){var p,P,i;if(!D){p=A[s];}else if(typeof D==="string"){if(D=="j"||D=="J"){D=this.getPreferredHourSymbol();}i=A[s];p=i&&i[D];}if(p){if(typeof p==="object"){P=Object.keys(p).map(function(k){return p[k];});}else{return p;}}if(!P){P=this._createFormatPattern(s,A,h,D);}if(P&&P.length===1){return P[0];}return P;},
_createFormatPattern:function(s,A,h,D){var t=this._parseSkeletonFormat(s),p,o=this._findBestMatch(t,s,A),T,j,P,S,k,n,r=/^([GyYqQMLwWEecdD]+)([hHkKjJmszZvVOXx]+)$/,u,i;if(D){if(typeof D==="string"){n=m[D]?m[D].group:"";if(n){u=c[n].index>t[t.length-1].index;}k=D;}else{u=true;for(i=t.length-1;i>=0;i--){T=t[i];if(D[T.group]){u=false;break;}}for(i=0;i<t.length;i++){T=t[i];if(D[T.group]){k=T.symbol;break;}}if((k=="h"||k=="K")&&D.DayPeriod){k="a";}}if(u){return[this.getCustomDateTimePattern(s,h)];}if(o&&o.missingTokens.length===0){P=o.pattern[k];if(P&&o.distance>0){P=this._expandFields(P,o.patternTokens,t);}}if(!P){j=this._get(g(h),"dateTimeFormats","availableFormats");if(r.test(s)&&"ahHkKjJms".indexOf(k)>=0){P=this._getMixedFormatPattern(s,j,h,D);}else{S=this._getFormatPattern(s,j,h);P=this.getCombinedIntervalPattern(S,h);}}p=[P];}else if(!o){P=s;p=[P];}else{if(typeof o.pattern==="string"){p=[o.pattern];}else if(typeof o.pattern==="object"){p=[];for(var K in o.pattern){P=o.pattern[K];p.push(P);}}if(o.distance>0){if(o.missingTokens.length>0){if(r.test(s)){p=[this._getMixedFormatPattern(s,A,h)];}else{p=this._expandFields(p,o.patternTokens,t);p=this._appendItems(p,o.missingTokens,h);}}else{p=this._expandFields(p,o.patternTokens,t);}}}if(s.indexOf("J")>=0){p.forEach(function(P,I){p[I]=P.replace(/ ?[abB](?=([^']*'[^']*')*[^']*)$/g,"");});}return p;},
_parseSkeletonFormat:function(s){var t=[],T={index:-1},S,o,G;for(var i=0;i<s.length;i++){S=s.charAt(i);if(S=="j"||S=="J"){S=this.getPreferredHourSymbol();}if(S==T.symbol){T.length++;continue;}o=m[S];G=c[o.group];if(o.group=="Other"||G.diffOnly){throw new Error("Symbol '"+S+"' is not allowed in skeleton format '"+s+"'");}if(G.index<=T.index){throw new Error("Symbol '"+S+"' at wrong position or duplicate in skeleton format '"+s+"'");}T={symbol:S,group:o.group,match:o.match,index:G.index,field:G.field,length:1};t.push(T);}return t;},
_findBestMatch:function(t,s,A){var T,h,o,j,k,D,n,F,p,r,u={distance:10000,firstDiffPos:-1};for(var v in A){if(v==="intervalFormatFallback"){continue;}T=this._parseSkeletonFormat(v);D=0;h=[];n=true;if(t.length<T.length){continue;}k=0;F=t.length;for(var i=0;i<t.length;i++){o=t[i];j=T[k];if(F===t.length){F=i;}if(j){p=m[o.symbol];r=m[j.symbol];if(o.symbol===j.symbol){if(o.length===j.length){if(F===i){F=t.length;}}else{if(o.length<p.numericCeiling?j.length<r.numericCeiling:j.length>=r.numericCeiling){D+=Math.abs(o.length-j.length);}else{D+=5;}}k++;continue;}else{if(o.match==j.match){D+=Math.abs(o.length-j.length)+10;k++;continue;}}}h.push(o);D+=50-i;}if(k<T.length){n=false;}if(n&&(D<u.distance||(D===u.distance&&F>u.firstDiffPos))){u.distance=D;u.firstDiffPos=F;u.missingTokens=h;u.pattern=A[v];u.patternTokens=T;}}if(u.pattern){return u;}},
_expandFields:function(p,P,t){var s=(typeof p==="string");var h;if(s){h=[p];}else{h=p;}var r=h.map(function(k){var G={},n={},R="",Q=false,i=0,S,o,O,N,u,v,w,x,y,z;t.forEach(function(T){G[T.group]=T;});P.forEach(function(T){n[T.group]=T;});while(i<k.length){z=k.charAt(i);if(Q){R+=z;if(z=="'"){Q=false;}}else{w=m[z];if(w&&G[w.group]&&n[w.group]){u=G[w.group];v=n[w.group];x=m[u.symbol];y=m[v.symbol];S=u.length;o=v.length;O=1;while(k.charAt(i+1)==z){i++;O++;}if(S===o||((S<x.numericCeiling)?(o>=y.numericCeiling):(o<y.numericCeiling))){N=O;}else{N=Math.max(O,S);}for(var j=0;j<N;j++){R+=z;}}else{R+=z;if(z=="'"){Q=true;}}}i++;}return R;});return s?r[0]:r;},
_appendItems:function(p,h,s){var A=this._get(g(s),"dateTimeFormats","appendItems");p.forEach(function(P,I){var D,j,k;h.forEach(function(t){j=A[t.group];D="'"+this.getDisplayName(t.field)+"'";k="";for(var i=0;i<t.length;i++){k+=t.symbol;}p[I]=j.replace(/\{0\}/,P).replace(/\{1\}/,k).replace(/\{2\}/,D);}.bind(this));}.bind(this));return p;},
_getMixedFormatPattern:function(s,A,h,D){var r=/^([GyYqQMLwWEecdD]+)([hHkKjJmszZvVOXx]+)$/,i=/MMMM|LLLL/,j=/MMM|LLL/,k=/E|e|c/,R,n,t,S,o,T,p,u;R=r.exec(s);n=R[1];t=R[2];o=this._getFormatPattern(n,A,h);if(D){T=this.getCustomIntervalPattern(t,D,h);}else{T=this._getFormatPattern(t,A,h);}if(i.test(n)){S=k.test(n)?"full":"long";}else if(j.test(n)){S="medium";}else{S="short";}p=this.getDateTimePattern(S,h);u=p.replace(/\{1\}/,o).replace(/\{0\}/,T);return u;},
getNumberSymbol:function(t){return this._get("symbols-latn-"+t);},
getDecimalPattern:function(){return this._get("decimalFormat").standard;},
getCurrencyPattern:function(s){return this._get("currencyFormat")[s]||this._get("currencyFormat").standard;},
getCurrencySpacing:function(p){return this._get("currencyFormat","currencySpacing",p==="after"?"afterCurrency":"beforeCurrency");},
getPercentPattern:function(){return this._get("percentFormat").standard;},
getMinimalDaysInFirstWeek:function(){return this._get("weekData-minDays");},
getFirstDayOfWeek:function(){return this._get("weekData-firstDay");},
getWeekendStart:function(){return this._get("weekData-weekendStart");},
getWeekendEnd:function(){return this._get("weekData-weekendEnd");},
getCurrencyDigits:function(s){var o=this._get("currencyDigits");var D=2;if(o){if(o[s]!=undefined){D=o[s];}else{D=o["DEFAULT"];}}return D;},
getCurrencySymbol:function(s){var o=this._get("currencySymbols");return(o&&o[s])||s;},
getCurrencyCodeBySymbol:function(s){var o=this._get("currencySymbols"),h;for(h in o){if(o[h]===s){return h;}}return s;},
getRelativePatterns:function(s,S){if(S===undefined){S="wide";}var p=[],P=this.getPluralCategories(),o,t,v,i;if(!s){s=["year","month","week","day","hour","minute","second"];}s.forEach(function(h){o=this._get("dateFields",h+"-"+S);for(var E in o){if(E.indexOf("relative-type-")===0){v=parseInt(E.substr(14),10);p.push({scale:h,value:v,pattern:o[E]});}else if(E.indexOf("relativeTime-type-")==0){t=o[E];i=E.substr(18)==="past"?-1:1;P.forEach(function(k){p.push({scale:h,sign:i,pattern:t["relativeTimePattern-count-"+k]});});}}}.bind(this));return p;},
getRelativePattern:function(s,D,F,S){var p,t,k,P;if(typeof F==="string"){S=F;F=undefined;}if(F===undefined){F=D>0;}if(S===undefined){S="wide";}k=s+"-"+S;p=this._get("dateFields",k,"relative-type-"+D);if(!p){t=this._get("dateFields",k,"relativeTime-type-"+(F?"future":"past"));P=this.getPluralCategory(Math.abs(D).toString());p=t["relativeTimePattern-count-"+P];}return p;},
getRelativeSecond:function(D,s){return this.getRelativePattern("second",D,s);},
getRelativeMinute:function(D,s){if(D==0){return null;}return this.getRelativePattern("minute",D,s);},
getRelativeHour:function(D,s){if(D==0){return null;}return this.getRelativePattern("hour",D,s);},
getRelativeDay:function(D,s){return this.getRelativePattern("day",D,s);},
getRelativeWeek:function(D,s){return this.getRelativePattern("week",D,s);},
getRelativeMonth:function(D,s){return this.getRelativePattern("month",D,s);},
getDisplayName:function(t,s){if(s===undefined){s="wide";}var S=["era","weekday","zone"],k=S.indexOf(t)===-1?t+"-"+s:t;return this._get("dateFields",k,"displayName");},
getRelativeYear:function(D,s){return this.getRelativePattern("year",D,s);},
getDecimalFormat:function(s,n,p){var F;var o;switch(s){case"long":o=this._get("decimalFormat-long");break;default:o=this._get("decimalFormat-short");break;}if(o){var N=n+"-"+p;F=o[N];if(!F){N=n+"-other";F=o[N];}}return F;},
getCurrencyFormat:function(s,n,p){var F;var o;switch(s){default:o=this._get("currencyFormat-short");break;}if(o){var N=n+"-"+p;F=o[N];if(!F){N=n+"-other";F=o[N];}}return F;},
getEras:function(w,s){var E=this._get(g(s),"era-"+w),h=[];for(var i in E){h[parseInt(i,10)]=E[i];}return h;},
getEraDates:function(s){var E=this._get("eras-"+s.toLowerCase()),h=[];for(var i in E){h[parseInt(i,10)]=E[i];}return h;},
getCalendarWeek:function(s,w){var o=sap.ui.getCore().getLibraryResourceBundle("sap.ui.core",this.oLocale.toString()),k="date.week.calendarweek."+s;return o.getText(k,w);},
getPreferredCalendarType:function(){var s=this._get("calendarPreference"),h=s?s.split(" "):[],j,t,i;sap.ui.getCore().loadLibrary('sap.ui.core');var k=sap.ui.require("sap/ui/core/library").CalendarType;for(i=0;i<h.length;i++){j=h[i];for(t in k){if(j===g(t).substring(3)){return t;}}}return k.Gregorian;},
getPreferredHourSymbol:function(){return this._get("timeData","_preferred");},
getPluralCategories:function(){var p=this._get("plurals"),h=Object.keys(p);h.push("other");return h;},
getPluralCategory:function(n){var p=this._get("plurals");if(typeof n==="number"){n=n.toString();}if(!this._pluralTest){this._pluralTest={};}for(var s in p){var t=this._pluralTest[s];if(!t){t=this._parsePluralRule(p[s]);this._pluralTest[s]=t;}if(t(n)){return s;}}return"other";},
_parsePluralRule:function(r){var O="or",h="and",j="%",k="=",n="!=",p="n",s="i",t="f",u="t",v="v",w="w",R="..",S=",";var i=0,T;T=r.split(" ");function x(o){if(T[i]===o){i++;return true;}return false;}function y(){var o=T[i];i++;return o;}function z(){var I,H;I=A();if(x(O)){H=z();return function(o){return I(o)||H(o);};}return I;}function A(){var I,J;I=D();if(x(h)){J=A();return function(o){return I(o)&&J(o);};}return I;}function D(){var I,J,K;I=E();if(x(k)){K=true;}else if(x(n)){K=false;}else{throw new Error("Expected '=' or '!='");}J=G();if(K){return function(o){return J(o).indexOf(I(o))>=0;};}else{return function(o){return J(o).indexOf(I(o))===-1;};}}function E(){var I;I=F();if(x(j)){var J=parseInt(y(),10);return function(o){return I(o)%J;};}return I;}function F(){if(x(p)){return function(o){return o.n;};}else if(x(s)){return function(o){return o.i;};}else if(x(t)){return function(o){return o.f;};}else if(x(u)){return function(o){return o.t;};}else if(x(v)){return function(o){return o.v;};}else if(x(w)){return function(o){return o.w;};}else{throw new Error("Unknown operand: "+y());}}function G(){var V=[],I=y(),P=I.split(S),J,K,N;P.forEach(function(o){J=o.split(R);if(J.length===1){V.push(parseInt(o,10));}else{K=parseInt(J[0],10);N=parseInt(J[1],10);for(var i=K;i<=N;i++){V.push(i);}}});return function(o){return V;};}var H=z();if(i!=T.length){throw new Error("Not completely parsed");}return function(V){var I=V.indexOf("."),J,K,N,o;if(I===-1){J=V;K="";N="";}else{J=V.substr(0,I);K=V.substr(I+1);N=K.replace(/0+$/,'');}o={n:parseFloat(V),i:parseInt(J,10),v:K.length,w:N.length,f:parseInt(K,10),t:parseInt(N,10)};return H(o);};}
});
var c={"Era":{field:"era",index:0},"Year":{field:"year",index:1},"Quarter":{field:"quarter",index:2},"Month":{field:"month",index:3},"Week":{field:"week",index:4},"Day-Of-Week":{field:"weekday",index:5},"Day":{field:"day",index:6},"DayPeriod":{field:"hour",index:7,diffOnly:true},"Hour":{field:"hour",index:8},"Minute":{field:"minute",index:9},"Second":{field:"second",index:10},"Timezone":{field:"zone",index:11}};var m={"G":{group:"Era",match:"Era",numericCeiling:1},"y":{group:"Year",match:"Year",numericCeiling:100},"Y":{group:"Year",match:"Year",numericCeiling:100},"Q":{group:"Quarter",match:"Quarter",numericCeiling:3},"q":{group:"Quarter",match:"Quarter",numericCeiling:3},"M":{group:"Month",match:"Month",numericCeiling:3},"L":{group:"Month",match:"Month",numericCeiling:3},"w":{group:"Week",match:"Week",numericCeiling:100},"W":{group:"Week",match:"Week",numericCeiling:100},"d":{group:"Day",match:"Day",numericCeiling:100},"D":{group:"Day",match:"Day",numericCeiling:100},"E":{group:"Day-Of-Week",match:"Day-Of-Week",numericCeiling:1},"e":{group:"Day-Of-Week",match:"Day-Of-Week",numericCeiling:3},"c":{group:"Day-Of-Week",match:"Day-Of-Week",numericCeiling:2},"h":{group:"Hour",match:"Hour12",numericCeiling:100},"H":{group:"Hour",match:"Hour24",numericCeiling:100},"k":{group:"Hour",match:"Hour24",numericCeiling:100},"K":{group:"Hour",match:"Hour12",numericCeiling:100},"m":{group:"Minute",match:"Minute",numericCeiling:100},"s":{group:"Second",match:"Second",numericCeiling:100},"z":{group:"Timezone",match:"Timezone",numericCeiling:1},"Z":{group:"Timezone",match:"Timezone",numericCeiling:1},"O":{group:"Timezone",match:"Timezone",numericCeiling:1},"v":{group:"Timezone",match:"Timezone",numericCeiling:1},"V":{group:"Timezone",match:"Timezone",numericCeiling:1},"X":{group:"Timezone",match:"Timezone",numericCeiling:1},"x":{group:"Timezone",match:"Timezone",numericCeiling:1},"S":{group:"Other",numericCeiling:100},"u":{group:"Other",numericCeiling:100},"U":{group:"Other",numericCeiling:1},"r":{group:"Other",numericCeiling:100},"F":{group:"Other",numericCeiling:100},"g":{group:"Other",numericCeiling:100},"a":{group:"DayPeriod",numericCeiling:1},"b":{group:"Other",numericCeiling:1},"B":{group:"Other",numericCeiling:1},"A":{group:"Other",numericCeiling:100}};var M={"orientation":"left-to-right","languages":{},"scripts":{},"territories":{},"ca-gregorian":{"dateFormats":{"full":"EEEE, MMMM d, y","long":"MMMM d, y","medium":"MMM d, y","short":"M/d/yy"},"timeFormats":{"full":"h:mm:ss a zzzz","long":"h:mm:ss a z","medium":"h:mm:ss a","short":"h:mm a"},"dateTimeFormats":{"full":"{1} 'at' {0}","long":"{1} 'at' {0}","medium":"{1}, {0}","short":"{1}, {0}","availableFormats":{"d":"d","E":"ccc","Ed":"d E","Ehm":"E h:mm a","EHm":"E HH:mm","Ehms":"E h:mm:ss a","EHms":"E HH:mm:ss","Gy":"y G","GyMMM":"MMM y G","GyMMMd":"MMM d, y G","GyMMMEd":"E, MMM d, y G","h":"h a","H":"HH","hm":"h:mm a","Hm":"HH:mm","hms":"h:mm:ss a","Hms":"HH:mm:ss","hmsv":"h:mm:ss a v","Hmsv":"HH:mm:ss v","hmv":"h:mm a v","Hmv":"HH:mm v","M":"L","Md":"M/d","MEd":"E, M/d","MMM":"LLL","MMMd":"MMM d","MMMEd":"E, MMM d","MMMMd":"MMMM d","ms":"mm:ss","y":"y","yM":"M/y","yMd":"M/d/y","yMEd":"E, M/d/y","yMMM":"MMM y","yMMMd":"MMM d, y","yMMMEd":"E, MMM d, y","yMMMM":"MMMM y","yQQQ":"QQQ y","yQQQQ":"QQQQ y"},"appendItems":{"Day":"{0} ({2}: {1})","Day-Of-Week":"{0} {1}","Era":"{0} {1}","Hour":"{0} ({2}: {1})","Minute":"{0} ({2}: {1})","Month":"{0} ({2}: {1})","Quarter":"{0} ({2}: {1})","Second":"{0} ({2}: {1})","Timezone":"{0} {1}","Week":"{0} ({2}: {1})","Year":"{0} {1}"},"intervalFormats":{"intervalFormatFallback":"{0} – {1}","d":{"d":"d – d"},"h":{"a":"h a – h a","h":"h – h a"},"H":{"H":"HH – HH"},"hm":{"a":"h:mm a – h:mm a","h":"h:mm – h:mm a","m":"h:mm – h:mm a"},"Hm":{"H":"HH:mm – HH:mm","m":"HH:mm – HH:mm"},"hmv":{"a":"h:mm a – h:mm a v","h":"h:mm – h:mm a v","m":"h:mm – h:mm a v"},"Hmv":{"H":"HH:mm – HH:mm v","m":"HH:mm – HH:mm v"},"hv":{"a":"h a – h a v","h":"h – h a v"},"Hv":{"H":"HH – HH v"},"M":{"M":"M – M"},"Md":{"d":"M/d – M/d","M":"M/d – M/d"},"MEd":{"d":"E, M/d – E, M/d","M":"E, M/d – E, M/d"},"MMM":{"M":"MMM – MMM"},"MMMd":{"d":"MMM d – d","M":"MMM d – MMM d"},"MMMEd":{"d":"E, MMM d – E, MMM d","M":"E, MMM d – E, MMM d"},"y":{"y":"y – y"},"yM":{"M":"M/y – M/y","y":"M/y – M/y"},"yMd":{"d":"M/d/y – M/d/y","M":"M/d/y – M/d/y","y":"M/d/y – M/d/y"},"yMEd":{"d":"E, M/d/y – E, M/d/y","M":"E, M/d/y – E, M/d/y","y":"E, M/d/y – E, M/d/y"},"yMMM":{"M":"MMM – MMM y","y":"MMM y – MMM y"},"yMMMd":{"d":"MMM d – d, y","M":"MMM d – MMM d, y","y":"MMM d, y – MMM d, y"},"yMMMEd":{"d":"E, MMM d – E, MMM d, y","M":"E, MMM d – E, MMM d, y","y":"E, MMM d, y – E, MMM d, y"},"yMMMM":{"M":"MMMM – MMMM y","y":"MMMM y – MMMM y"}}},"months":{"format":{"abbreviated":["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],"narrow":["J","F","M","A","M","J","J","A","S","O","N","D"],"wide":["January","February","March","April","May","June","July","August","September","October","November","December"]},"stand-alone":{"abbreviated":["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],"narrow":["J","F","M","A","M","J","J","A","S","O","N","D"],"wide":["January","February","March","April","May","June","July","August","September","October","November","December"]}},"days":{"format":{"abbreviated":["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],"narrow":["S","M","T","W","T","F","S"],"short":["Su","Mo","Tu","We","Th","Fr","Sa"],"wide":["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"]},"stand-alone":{"abbreviated":["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],"narrow":["S","M","T","W","T","F","S"],"short":["Su","Mo","Tu","We","Th","Fr","Sa"],"wide":["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"]}},"quarters":{"format":{"abbreviated":["Q1","Q2","Q3","Q4"],"narrow":["1","2","3","4"],"wide":["1st quarter","2nd quarter","3rd quarter","4th quarter"]},"stand-alone":{"abbreviated":["Q1","Q2","Q3","Q4"],"narrow":["1","2","3","4"],"wide":["1st quarter","2nd quarter","3rd quarter","4th quarter"]}},"dayPeriods":{"format":{"abbreviated":["AM","PM"],"narrow":["a","p"],"wide":["AM","PM"]},"stand-alone":{"abbreviated":["AM","PM"],"narrow":["AM","PM"],"wide":["AM","PM"]}},"era-wide":{"0":"Before Christ","1":"Anno Domini"},"era-abbreviated":{"0":"BC","1":"AD"},"era-narrow":{"0":"B","1":"A"}},"eras-gregorian":{"0":{"_end":"0-12-31"},"1":{"_start":"1-01-01"}},"dateFields":{"era":{"displayName":"era"},"year-wide":{"displayName":"year","relative-type--1":"last year","relative-type-0":"this year","relative-type-1":"next year","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} year","relativeTimePattern-count-other":"in {0} years"},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} year ago","relativeTimePattern-count-other":"{0} years ago"}},"year-short":{"displayName":"yr.","relative-type--1":"last yr.","relative-type-0":"this yr.","relative-type-1":"next yr.","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} yr.","relativeTimePattern-count-other":"in {0} yr."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} yr. ago","relativeTimePattern-count-other":"{0} yr. ago"}},"year-narrow":{"displayName":"yr.","relative-type--1":"last yr.","relative-type-0":"this yr.","relative-type-1":"next yr.","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} yr.","relativeTimePattern-count-other":"in {0} yr."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} yr. ago","relativeTimePattern-count-other":"{0} yr. ago"}},"quarter-wide":{"displayName":"quarter","relative-type--1":"last quarter","relative-type-0":"this quarter","relative-type-1":"next quarter","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} quarter","relativeTimePattern-count-other":"in {0} quarters"},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} quarter ago","relativeTimePattern-count-other":"{0} quarters ago"}},"quarter-short":{"displayName":"qtr.","relative-type--1":"last qtr.","relative-type-0":"this qtr.","relative-type-1":"next qtr.","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} qtr.","relativeTimePattern-count-other":"in {0} qtrs."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} qtr. ago","relativeTimePattern-count-other":"{0} qtrs. ago"}},"quarter-narrow":{"displayName":"qtr.","relative-type--1":"last qtr.","relative-type-0":"this qtr.","relative-type-1":"next qtr.","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} qtr.","relativeTimePattern-count-other":"in {0} qtrs."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} qtr. ago","relativeTimePattern-count-other":"{0} qtrs. ago"}},"month-wide":{"displayName":"month","relative-type--1":"last month","relative-type-0":"this month","relative-type-1":"next month","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} month","relativeTimePattern-count-other":"in {0} months"},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} month ago","relativeTimePattern-count-other":"{0} months ago"}},"month-short":{"displayName":"mo.","relative-type--1":"last mo.","relative-type-0":"this mo.","relative-type-1":"next mo.","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} mo.","relativeTimePattern-count-other":"in {0} mo."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} mo. ago","relativeTimePattern-count-other":"{0} mo. ago"}},"month-narrow":{"displayName":"mo.","relative-type--1":"last mo.","relative-type-0":"this mo.","relative-type-1":"next mo.","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} mo.","relativeTimePattern-count-other":"in {0} mo."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} mo. ago","relativeTimePattern-count-other":"{0} mo. ago"}},"week-wide":{"displayName":"week","relative-type--1":"last week","relative-type-0":"this week","relative-type-1":"next week","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} week","relativeTimePattern-count-other":"in {0} weeks"},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} week ago","relativeTimePattern-count-other":"{0} weeks ago"},"relativePeriod":"the week of {0}"},"week-short":{"displayName":"wk.","relative-type--1":"last wk.","relative-type-0":"this wk.","relative-type-1":"next wk.","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} wk.","relativeTimePattern-count-other":"in {0} wk."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} wk. ago","relativeTimePattern-count-other":"{0} wk. ago"},"relativePeriod":"the week of {0}"},"week-narrow":{"displayName":"wk.","relative-type--1":"last wk.","relative-type-0":"this wk.","relative-type-1":"next wk.","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} wk.","relativeTimePattern-count-other":"in {0} wk."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} wk. ago","relativeTimePattern-count-other":"{0} wk. ago"},"relativePeriod":"the week of {0}"},"day-wide":{"displayName":"day","relative-type--1":"yesterday","relative-type-0":"today","relative-type-1":"tomorrow","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} day","relativeTimePattern-count-other":"in {0} days"},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} day ago","relativeTimePattern-count-other":"{0} days ago"}},"day-short":{"displayName":"day","relative-type--1":"yesterday","relative-type-0":"today","relative-type-1":"tomorrow","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} day","relativeTimePattern-count-other":"in {0} days"},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} day ago","relativeTimePattern-count-other":"{0} days ago"}},"day-narrow":{"displayName":"day","relative-type--1":"yesterday","relative-type-0":"today","relative-type-1":"tomorrow","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} day","relativeTimePattern-count-other":"in {0} days"},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} day ago","relativeTimePattern-count-other":"{0} days ago"}},"weekday":{"displayName":"day of the week"},"hour-wide":{"displayName":"hour","relative-type-0":"this hour","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} hour","relativeTimePattern-count-other":"in {0} hours"},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} hour ago","relativeTimePattern-count-other":"{0} hours ago"}},"hour-short":{"displayName":"hr.","relative-type-0":"this hour","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} hr.","relativeTimePattern-count-other":"in {0} hr."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} hr. ago","relativeTimePattern-count-other":"{0} hr. ago"}},"hour-narrow":{"displayName":"hr.","relative-type-0":"this hour","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} hr.","relativeTimePattern-count-other":"in {0} hr."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} hr. ago","relativeTimePattern-count-other":"{0} hr. ago"}},"minute-wide":{"displayName":"minute","relative-type-0":"this minute","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} minute","relativeTimePattern-count-other":"in {0} minutes"},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} minute ago","relativeTimePattern-count-other":"{0} minutes ago"}},"minute-short":{"displayName":"min.","relative-type-0":"this minute","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} min.","relativeTimePattern-count-other":"in {0} min."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} min. ago","relativeTimePattern-count-other":"{0} min. ago"}},"minute-narrow":{"displayName":"min.","relative-type-0":"this minute","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} min.","relativeTimePattern-count-other":"in {0} min."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} min. ago","relativeTimePattern-count-other":"{0} min. ago"}},"second-wide":{"displayName":"second","relative-type-0":"now","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} second","relativeTimePattern-count-other":"in {0} seconds"},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} second ago","relativeTimePattern-count-other":"{0} seconds ago"}},"second-short":{"displayName":"sec.","relative-type-0":"now","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} sec.","relativeTimePattern-count-other":"in {0} sec."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} sec. ago","relativeTimePattern-count-other":"{0} sec. ago"}},"second-narrow":{"displayName":"sec.","relative-type-0":"now","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} sec.","relativeTimePattern-count-other":"in {0} sec."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} sec. ago","relativeTimePattern-count-other":"{0} sec. ago"}},"zone":{"displayName":"time zone"}},"decimalFormat":{"standard":"#,##0.###"},"currencyFormat":{"standard":"¤#,##0.00","currencySpacing":{"beforeCurrency":{"currencyMatch":"[:^S:]","surroundingMatch":"[:digit:]","insertBetween":" "},"afterCurrency":{"currencyMatch":"[:^S:]","surroundingMatch":"[:digit:]","insertBetween":" "}}},"percentFormat":{"standard":"#,##0%"},"symbols-latn-decimal":".","symbols-latn-group":",","symbols-latn-plusSign":"+","symbols-latn-minusSign":"-","symbols-latn-percentSign":"%","weekData-minDays":4,"weekData-firstDay":1,"weekData-weekendStart":6,"weekData-weekendEnd":0,"timeData":{_allowed:"H h",_preferred:"H"},"plurals":{}};var b={"iw":"he","ji":"yi","in":"id","sh":"sr"};var d=(function(){var h=L._cldrLocales,r={},i;if(h){for(i=0;i<h.length;i++){r[h[i]]=true;}}return r;}());var l={};
function g(s){if(!s){s=sap.ui.getCore().getConfiguration().getCalendarType();}return"ca-"+s.toLowerCase();}
function e(o){var s=o.getLanguage()||"",S=o.getScript()||"",r=o.getRegion()||"",D;function h(j,k){var n,v,p;if(!k){return;}for(n in k){if(k.hasOwnProperty(n)){v=j[n];p=k[n];if(v===undefined){j[n]=p;}else if(v===null){delete j[n];}else if(typeof v==='object'&&typeof p==='object'){h(v,p);}}}}function i(I){if(!l[I]&&(!d||d[I]===true)){var j=l[I]=q.sap.loadResource("sap/ui/core/cldr/"+I+".json",{dataType:"json",failOnError:false});if(j&&j.__fallbackLocale){h(j,i(j.__fallbackLocale));delete j.__fallbackLocale;}}return l[I];}s=(s&&b[s])||s;if(s==="no"){s="nb";}if(s==="zh"&&!r){if(S==="Hans"){r="CN";}else if(S==="Hant"){r="TW";}}var I=s+"_"+r;if(s&&r){D=i(I);}if(!D&&s){D=i(s);}l[I]=D||M;return l[I];}
var f=a.extend("sap.ui.core.CustomLocaleData",{
constructor:function(o){a.apply(this,arguments);this.mCustomData=sap.ui.getCore().getConfiguration().getFormatSettings().getCustomLocaleData();},
_get:function(){var A=Array.prototype.slice.call(arguments),s,k;if(A[0].indexOf("ca-")==0){s=A[0];if(s==g()){A=A.slice(1);}}k=A.join("-");return this.mCustomData[k]||this._getDeep(this.mData,arguments);}
});
a.getInstance=function(o){return o.hasPrivateUseSubtag("sapufmt")?new f(o):new a(o);};
return a;});
sap.ui.predefine('sap/ui/core/Message',['jquery.sap.global','./Element','./library'],function(q,E,l){"use strict";var M=l.MessageType;
var a=E.extend("sap.ui.core.Message",{metadata:{library:"sap.ui.core",properties:{text:{type:"string",group:"Misc",defaultValue:null},timestamp:{type:"string",group:"Misc",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},level:{type:"sap.ui.core.MessageType",group:"Misc",defaultValue:M.None},readOnly:{type:"boolean",group:"Misc",defaultValue:false}}}});
a.prototype.getDefaultIcon=function(s){var m=q.sap.getModulePath("sap.ui.core.themes."+sap.ui.getCore().getConfiguration().getTheme());var i=m+"/img/message/";if(s&&s=="32x32"){i+="32x32/";}else{i+="16x16/";}var u="";switch(this.getProperty("level")){case M.Error:u=i+"Message_Icon_Error.png";break;case M.Information:u=i+"Message_Icon_Information.png";break;case M.Warning:u=i+"Message_Icon_Warning.png";break;case M.Success:u=i+"Message_Icon_Success.png";break;case M.None:default:u=this.getProperty("icon");break;}return u;};
a.prototype.compareByType=function(o){return a.compareByType(this,o);};
a.compareByType=function(m,o){if(!m&&!o){return 0;}if(m&&!o){return 1;}if(!m&&o){return-1;}var L=m.getLevel();var s=o.getLevel();if(L===s){return 0;}switch(L){case M.Error:return 1;case M.Warning:return s===M.Error?-1:1;case M.Success:return s===M.Error||s===M.Warning?-1:1;case M.Information:return s===M.None?1:-1;case M.None:return-1;default:q.sap.log.error("Comparison error",this);return 0;}};
return a;});
sap.ui.predefine('sap/ui/core/Popup',['jquery.sap.global','sap/ui/Device','sap/ui/base/ManagedObject','sap/ui/base/Object','sap/ui/base/ObjectPool','./Control','./IntervalTrigger','./RenderManager','./Element','./ResizeHandler','jquery.sap.script'],function(q,D,M,B,O,C,I,R,E,a){"use strict";
var P=M.extend("sap.ui.core.Popup",{
constructor:function(c,m,s,A){M.apply(this);this._popupUID=q.sap.uid();this.bOpen=false;this.eOpenState=sap.ui.core.OpenState.CLOSED;this._mEvents={};this._mEvents["sap.ui.core.Popup.addFocusableContent-"+this._popupUID]=this._addFocusableArea;this._mEvents["sap.ui.core.Popup.removeFocusableContent-"+this._popupUID]=this._removeFocusableArea;this._mEvents["sap.ui.core.Popup.closePopup-"+this._popupUID]=this._closePopup;this._mEvents["sap.ui.core.Popup.onFocusEvent-"+this._popupUID]=this.onFocusEvent;this._mEvents["sap.ui.core.Popup.increaseZIndex-"+this._popupUID]=this._increaseMyZIndex;this._mEvents["sap.ui.core.Popup.contains-"+this._popupUID]=this._containsEventBusWrapper;if(c){this.setContent(c);}this._oDefaultPosition={my:P.Dock.CenterCenter,at:P.Dock.CenterCenter,of:document,offset:"0 0",collision:"flip"};this._oPosition=q.extend({},this._oDefaultPosition);this._bModal=!!m;this._oPreviousFocus=null;this._sInitialFocusId=null;this._bShadow=typeof(s)==="boolean"?s:true;this._bAutoClose=!!A;this._animations={open:null,close:null};this._durations={open:"fast",close:"fast"};this._iZIndex=-1;this._oBlindLayer=null;this.setNavigationMode();if(this.touchEnabled){this._fAutoCloseHandler=function(e){if(e.isMarked("delayedMouseEvent")||e.isMarked("cancelAutoClose")){return;}if(this.eOpenState===sap.ui.core.OpenState.CLOSING||this.eOpenState===sap.ui.core.OpenState.CLOSED){return;}if(!this._contains(e.target)){this.close();}};}this._F6NavigationHandler=function(e){var S={},b=this._sF6NavMode,d;if(b=="DOCK"){if(this._bModal){b="NONE";}else if(this._oLastPosition&&this._oLastPosition.of){d=this._getOfDom(this._oLastPosition.of);if(!d||d===document){d=null;b="NONE";}}}switch(b){case"SCOPE":S.scope=this._$()[0];break;case"DOCK":S.target=d;var $=q(d).parents("[data-sap-ui-popup]");S.scope=$.length?$[0]:null;break;default:S.skip=true;}q.sap.handleF6GroupNavigation(e,S);};},
metadata:{library:"sap.ui.core",publicMethods:["open","close","setContent","getContent","setPosition","setShadow","setModal","getModal","setAutoClose","setAutoCloseAreas","isOpen","getAutoClose","getOpenState","setAnimations","setDurations","attachOpened","attachClosed","detachOpened","detachClosed"],associations:{"childPopups":{type:"sap.ui.core.Popup",multiple:true,visibility:"hidden"}},events:{"opened":{},"closed":{}}}
});
P._activateBlindLayer=true;P.blStack=[];P.Dock={BeginTop:"begin top",BeginCenter:"begin center",BeginBottom:"begin bottom",LeftTop:"left top",LeftCenter:"left center",LeftBottom:"left bottom",CenterTop:"center top",CenterCenter:"center center",CenterBottom:"center bottom",RightTop:"right top",RightCenter:"right center",RightBottom:"right bottom",EndTop:"end top",EndCenter:"end center",EndBottom:"end bottom"};P.prototype.touchEnabled=D.support.touch||q.sap.simulateMobileOnDesktop;P.prototype.preventBrowserFocus=(D.support.touch||q.sap.simulateMobileOnDesktop)&&!D.system.combi;
B.extend("sap.ui.core.Popup.Layer",{constructor:function(){var d=this.getDomString();this._$Ref=q(d).appendTo(sap.ui.getCore().getStaticAreaRef());}});
P.Layer.prototype.init=function(o,z){this._$Ref.css({"visibility":"visible","z-index":z});this.update(o,z);this._$Ref.insertAfter(o).show();};
P.Layer.prototype.update=function(o,z){if(o.length){var b=o.rect();this._$Ref.css({"left":b.left,"top":b.top});if(o.css("right")!="auto"&&o.css("right")!="inherit"){this._$Ref.css({"right":o.css("right"),"width":"auto"});}else{this._$Ref.css({"width":b.width,"right":"auto"});}if(o.css("bottom")!="auto"&&o.css("bottom")!="inherit"){this._$Ref.css({"bottom":o.css("bottom"),"height":"auto"});}else{this._$Ref.css({"height":b.height,"bottom":"auto"});}if(typeof(z)==="number"){this._$Ref.css("z-index",z);}}};
P.Layer.prototype.reset=function(){if(this._$Ref.length){this._$Ref[0].style.display="none";this._$Ref[0].style.visibility="hidden";this._$Ref.appendTo(sap.ui.getCore().getStaticAreaRef());}};
P.Layer.prototype.getDomString=function(){q.sap.log.error("sap.ui.core.Popup.Layer: getDomString function must be overwritten!");return"";};
P.Layer.extend("sap.ui.core.Popup.BlindLayer",{constructor:function(){P.Layer.apply(this);}});
P.BlindLayer.prototype.getDomString=function(){return"<div class=\"sapUiBliLy\" id=\"sap-ui-blindlayer-"+q.sap.uid()+"\"><iframe scrolling=\"no\" tabIndex=\"-1\"></iframe></div>";};
P.prototype.oBlindLayerPool=new O(P.BlindLayer);
P.Layer.extend("sap.ui.core.Popup.ShieldLayer",{constructor:function(){P.Layer.apply(this);}});
P.ShieldLayer.prototype.getDomString=function(){return"<div class=\"sapUiPopupShield\" id=\"sap-ui-shieldlayer-"+q.sap.uid()+"\"></div>";};
P.prototype.oShieldLayerPool=new O(P.ShieldLayer);(function(){var l=0;var m=Math.pow(2,32)-1;
P.setInitialZIndex=function(i){if(i>=m){throw new Error("Z-index can't be higher than Number.MAX_SAFE_INTEGER");}l=Math.max(i,this.getLastZIndex());};
P.getLastZIndex=function(){return l;};
P.prototype.getLastZIndex=function(){return P.getLastZIndex();};
P.getNextZIndex=function(){l+=10;if(l>=m){throw new Error("Z-index can't be higher than Number.MAX_SAFE_INTEGER");}return l;};
P.prototype.getNextZIndex=function(){return P.getNextZIndex();};
}());var r=function(o,b){var p=3;var l=Math.abs(o.left-b.left);var t=Math.abs(o.top-b.top);var w=Math.abs(o.width-b.width);var h=Math.abs(o.height-b.height);if(l>p||t>p||w>p||h>p){return false;}return true;};
P.prototype.open=function(d,m,b,o,c,f,g){if(this.eOpenState!=sap.ui.core.OpenState.CLOSED){return;}this.eOpenState=sap.ui.core.OpenState.OPENING;var s;try{s=sap.ui.getCore().getStaticAreaRef();s=sap.ui.getCore().getUIArea(s);}catch(e){q.sap.log.error(e);throw new Error("Popup cannot be opened because static UIArea cannot be determined.");}this._bContentAddedToStatic=false;if(this.oContent instanceof C&&!this.oContent.getParent()){s.addContent(this.oContent,true);this._bContentAddedToStatic=true;}if(this.oContent.getUIArea){var A=this.oContent.getUIArea();if(A===null){q.sap.log.warning("The Popup content is NOT connected with a UIArea and may not work properly!");}else if(P._bEnableUIAreaCheck&&A.getRootNode().id!==s.getRootNode().id){q.sap.log.warning("The Popup content is NOT connected with the static-UIArea and may not work properly!");}}if(typeof(d)=="string"){g=f;f=c;c=o;o=b;b=m;m=d;d=-1;}if(d===undefined){d=-1;}this._oPreviousFocus=P.getCurrentFocusInfo();if(this.isInPopup(o)||this.isInPopup(this._oPosition.of)){var p=this.getParentPopupId(o)||this.getParentPopupId(this._oPosition.of);var h="";var i=this.getContent();if(i instanceof E){h=i.getId();}else if(typeof i==="object"){h=i.id;}this.addChildToPopup(p,h);this.addChildToPopup(p,this._popupUID);}var $=this._$(true);var j="fast";if((d===0)||(d>0)){j=d;}else if((this._durations.open===0)||(this._durations.open>0)){j=this._durations.open;}var _;if(m||b||o||c||f){_=this._createPosition(m,b,o,c,f);this._oPosition=_;}else{_=this._oPosition;}if(!_.of){_.of=this._oPosition.of||document;}this._iZIndex=this._iZIndex===this.getLastZIndex()?this._iZIndex:this.getNextZIndex();var S=sap.ui.getCore().getStaticAreaRef();$.css({"position":"absolute","visibility":"hidden"});if(!($[0].parentNode==S)){$.appendTo(S);}$.css("z-index",this._iZIndex);q.sap.log.debug("position popup content "+$.attr("id")+" at "+(window.JSON?JSON.stringify(_.at):String(_.at)));this._applyPosition(_);if(g!==undefined){this.setFollowOf(g);}$.toggleClass("sapUiShd",this._bShadow);var k=$[0];if(k){k.style.display="none";k.style.visibility="visible";}this._duringOpen();if(j==0){this._opened();}else if(this._animations.open){this._animations.open.call(null,$,j,this._opened.bind(this));}else{$.fadeIn(j,this._opened.bind(this));}};
P.prototype._opened=function(){if(this.eOpenState!==sap.ui.core.OpenState.OPENING){return;}this.bOpen=true;var $=this._$(false,true);if($[0]&&$[0].style){$[0].style.display="block";}if(this._bModal||this._bAutoClose||this._sInitialFocusId){var d=null;if(this._sInitialFocusId){var c=sap.ui.getCore().byId(this._sInitialFocusId);if(c){d=c.getFocusDomRef();}d=d||q.sap.domById(this._sInitialFocusId);}q.sap.focus(d||$.firstFocusableDomRef());var o=this._getOfDom(this._oLastPosition.of);var b=q(o).rect();if(this._oLastOfRect&&b&&!r(this._oLastOfRect,b)){this._applyPosition(this._oLastPosition);}}this.eOpenState=sap.ui.core.OpenState.OPEN;if(this.getFollowOf()){P.DockTrigger.addListener(P.checkDocking,this);}this._updateBlindLayer();this.fireOpened();};
P.prototype._duringOpen=function(){var $=this._$(false,true);if(q.sap.isMouseEventDelayed){if(this._oTopShieldLayer){q.sap.clearDelayedCall(this._iTopShieldRemoveTimer);this._iTopShieldRemoveTimer=null;}else{this._oTopShieldLayer=this.oShieldLayerPool.borrowObject($,this._iZIndex+1);}this._iTopShieldRemoveTimer=q.sap.delayedCall(500,this,function(){this.oShieldLayerPool.returnObject(this._oTopShieldLayer);this._oTopShieldLayer=null;this._iTopShieldRemoveTimer=null;});}if(!!D.browser.msie&&!D.os.windows_phone&&P._activateBlindLayer){this._oBlindLayer=this.oBlindLayerPool.borrowObject($,this._iZIndex-1);}if(this._bModal){this._showBlockLayer();}if(this.oContent instanceof E){this.oContent.addDelegate(this);}this.bOpen=true;if(this._bModal||this._bAutoClose){this._addFocusEventListeners();}this._$(false,true).on("keydown",q.proxy(this._F6NavigationHandler,this));if(this.touchEnabled&&!this._bModal&&this._bAutoClose){q(document).on("touchstart mousedown",q.proxy(this._fAutoCloseHandler,this));}if(this._oBlindLayer){this._resizeListenerId=a.register(this._$().get(0),q.proxy(this.onresize,this));}if(D.os.ios&&D.support.touch){q(document).on("touchmove",this._fnPreventScroll);}};
P.prototype._contains=function(d){var p=this._$().get(0);if(!p){return false;}var c=q.sap.containsOrEquals(p,d);var b;if(!c){b=this.getChildPopups();c=b.some(function(s){var o=q.sap.domById(s);var c=q.sap.containsOrEquals(o,d);if(!c){var e="sap.ui.core.Popup.contains-"+s;var f={domRef:d};sap.ui.getCore().getEventBus().publish("sap.ui",e,f);c=f.contains;}return c;});}return c;};
P.prototype._containsEventBusWrapper=function(c,e,d){d.contains=this._contains(d.domRef);};
P.prototype.onFocusEvent=function(b){var e=q.event.fix(b);if(arguments.length>1&&arguments[1]==="sap.ui.core.Popup.onFocusEvent-"+this._popupUID){e=q.event.fix(arguments[2]);}var t=(e.type=="focus"||e.type=="activate")?"focus":"blur";var c=false;if(t=="focus"){var d=this._$().get(0);if(d){c=this._contains(e.target);q.sap.log.debug("focus event on "+e.target.id+", contains: "+c);if(this._bModal&&!c){var T=P.blStack.length>0&&P.blStack[P.blStack.length-1].popup===this;if(T){if(D.system.desktop||q(e.target).is(":input")){q.sap.delayedCall(0,this,function(){var o=this.oLastBlurredElement?this.oLastBlurredElement:d;q.sap.focus(o);});}}}else if(this._bAutoClose&&c&&this._sTimeoutId){q.sap.clearDelayedCall(this._sTimeoutId);this._sTimeoutId=null;}}}else if(t=="blur"){q.sap.log.debug("blur event on "+e.target.id);if(this._bModal){this.oLastBlurredElement=e.target;}else if(this._bAutoClose){if(!this.touchEnabled&&!this._sTimeoutId){if(e.target===document.activeElement){return;}var i=typeof this._durations.close==="string"?0:this._durations.close;this._sTimeoutId=q.sap.delayedCall(i,this,function(){this.close(i,"autocloseBlur");var o=this._oLastPosition&&this._oLastPosition.of;if(o){var p=this.getParentPopupId(o);if(p){var s="sap.ui.core.Popup.onFocusEvent-"+p;sap.ui.getCore().getEventBus().publish("sap.ui",s,e);}}});}}}};
P.prototype.setInitialFocusId=function(i){this._sInitialFocusId=i;};
P.prototype.close=function(d){if(P._autoCloseDebug){return;}if(this._sTimeoutId){q.sap.clearDelayedCall(this._sTimeoutId);this._sTimeoutId=null;if(arguments.length>1){var A=arguments[1];if(typeof A=="string"&&A=="autocloseBlur"&&this._isFocusInsidePopup()){return;}}}if(this.eOpenState==sap.ui.core.OpenState.CLOSED||this.eOpenState==sap.ui.core.OpenState.CLOSING){return;}var i="fast";if((d===0)||(d>0)){i=d;}else if((this._durations.close===0)||(this._durations.close>0)){i=this._durations.close;}this.eOpenState=sap.ui.core.OpenState.CLOSING;if(this.getFollowOf()){P.DockTrigger.removeListener(P.checkDocking,this);}if(this.oContent&&this._bContentAddedToStatic){sap.ui.getCore().getEventBus().publish("sap.ui","__beforePopupClose",{domNode:this._$().get(0)});var s=sap.ui.getCore().getStaticAreaRef();s=sap.ui.getCore().getUIArea(s);s.removeContent(s.indexOfContent(this.oContent),true);}this._bContentAddedToStatic=false;this._sTimeoutId=null;if(this.fEventHandler){this._removeFocusEventListeners();}this._$(false,true).off("keydown",this._F6NavigationHandler);if(this.touchEnabled){if(!this._bModal&&this._bAutoClose){q(document).off("touchstart mousedown",this._fAutoCloseHandler);}}if(D.os.ios&&D.support.touch){q(document).off("touchmove",this._fnPreventScroll);}if(this.oContent instanceof E){this.oContent.removeDelegate(this);}var $=this._$();if(this._bEventBusEventsRegistered){this._unregisterEventBusEvents();}if(this._oBlindLayer){this.oBlindLayerPool.returnObject(this._oBlindLayer);}this._oBlindLayer=null;if(q.sap.isMouseEventDelayed){if(this._oBottomShieldLayer){q.sap.clearDelayedCall(this._iBottomShieldRemoveTimer);this._iBottomShieldRemoveTimer=null;}else{this._oBottomShieldLayer=this.oShieldLayerPool.borrowObject($,this._iZIndex-3);}this._iBottomShieldRemoveTimer=q.sap.delayedCall(500,this,function(){this.oShieldLayerPool.returnObject(this._oBottomShieldLayer);this._oBottomShieldLayer=null;this._iBottomShieldRemoveTimer=null;});}if(this.isInPopup(this._oLastPosition.of)){var p=this.getParentPopupId(this._oLastPosition.of);var c="";var o=this.getContent();if(o instanceof E){c=o.getId();}else if(typeof o==="object"){c=o.id;}this.removeChildFromPopup(p,c);this.removeChildFromPopup(p,this._popupUID);}if(this._bModal&&this.preventBrowserFocus){$.one("mousedown",function(e){e.preventDefault();});}this._duringClose();if(i==0){this._closed();}else if(this._animations.close){this._animations.close.call(null,$,i,this._closed.bind(this));}else{$.fadeOut(i,this._closed.bind(this));}};
P.prototype._closed=function(){if(this._bModal){this._hideBlockLayer();}var $=this._$(false,true);if($.length){var d=$.get(0);if(d){d.style.display="none";d.style.visibility="hidden";d.style.left="0px";d.style.top="0px";d.style.right="";}$=this._$(false,true);d=$.length?$[0]:null;if(d){d.style.display="none";d.style.visibility="hidden";d.style.left="0px";d.style.top="0px";d.style.right="";}}if(this._bModal){P.applyFocusInfo(this._oPreviousFocus);this._oPreviousFocus=null;this.oLastBlurredElement=null;}this.bOpen=false;this.eOpenState=sap.ui.core.OpenState.CLOSED;var c=this.getChildPopups();for(var j=0,l=c.length;j<l;j++){this.closePopup(c[j]);}this.fireClosed();};
P.prototype._duringClose=function(){if(this._resizeListenerId){a.deregister(this._resizeListenerId);this._resizeListenerId=null;}};
P.getCurrentFocusInfo=function(){var _=null;var f=sap.ui.getCore().getCurrentFocusedControlId();if(f){var F=sap.ui.getCore().byId(f);_={'sFocusId':f,'oFocusInfo':F?F.getFocusInfo():{}};}else{try{var e=document.activeElement;if(e&&e.nodeName){_={'sFocusId':e.id,'oFocusedElement':e,'oFocusInfo':{}};}}catch(b){_=null;}}if(_){_.popup=this;}return _;};
P.applyFocusInfo=function(p){if(p){var f=sap.ui.getCore().byId(p.sFocusId);if(f){f.applyFocusInfo(p.oFocusInfo);}else{var e=q.sap.domById(p.sFocusId)||p.oFocusedElement;q.sap.focus(e);}}};
P.prototype.setContent=function(c){this.oContent=c;return this;};
P.prototype.getContent=function(){return this.oContent;};
P.prototype.setPosition=function(m,b,o,c,d){this._oPosition=this._createPosition(m,b,o,c,d);if(this.eOpenState!=sap.ui.core.OpenState.CLOSED){this._applyPosition(this._oPosition);this._oBlindLayer&&this._oBlindLayer.update(this._$());}return this;};
P.prototype._createPosition=function(m,b,o,c,d){var n=false;if(m&&(m.indexOf("+")>=0||m.indexOf("-")>=0)){n=true;if(c&&c!="0 0"){q.sap.log.warning("offset used in my and in offset, the offset value will be ignored","sap.ui.core.Popup","setPosition");}c=null;}var p=q.extend({},this._oDefaultPosition,{"my":m||this._oDefaultPosition.my,"at":b||this._oDefaultPosition.at,"of":o,"offset":c,"collision":d});if(!q.ui.version){if(P._bNewOffset==null){P._bNewOffset=true;var $=q(document.createElement("div"));$.position({of:window,using:function(g,h){P._bNewOffset=(h!==undefined);}});}}var e=[];var f=[];if(P._bNewOffset||q.sap.Version(q.ui.version).compareTo("1.8.23")>0){if(c&&c!="0 0"){e=p.my.split(" ");f=c.split(" ");var s=[parseInt(f[0],10)<0?"":"+",parseInt(f[1],10)<0?"":"+"];p.my=e[0]+s[0]+f[0]+" "+e[1]+s[1]+f[1];p.offset=null;}}else if(n){e=p.my.split(" ");f=["",""];var i=e[0].indexOf("+");if(i<0){i=e[0].indexOf("-");}if(i>=0){f[0]=e[0].slice(i);e[0]=e[0].slice(0,i);}i=e[1].indexOf("+");if(i<0){i=e[1].indexOf("-");}if(i>=0){f[1]=e[1].slice(i);e[1]=e[1].slice(0,i);}p.my=e[0]+" "+e[1];p.offset=f[0]+" "+f[1];}return p;};
P.prototype._getPositionOffset=function(){var o=[];if(this._oPosition.my&&(this._oPosition.my.indexOf("+")>=0||this._oPosition.my.indexOf("-")>=0)){var m=this._oPosition.my.split(" ");var i=m[0].indexOf("+");if(i<0){i=m[0].indexOf("-");}if(i>=0){o[0]=m[0].slice(i);}i=m[1].indexOf("+");if(i<0){i=m[1].indexOf("-");}if(i>=0){o[1]=m[1].slice(i);}}else if(this._oPosition.offset){o=this._oPosition.offset.split(" ");}return o;};
P.prototype._applyPosition=function(p){var b=sap.ui.getCore().getConfiguration().getRTL();var $=this._$();if($.length){var A=p.at;var d=$.get(0);if(typeof(A)==="string"){d.style.display="block";d.style.left="";d.style.right="";$.position(this._resolveReference(this._convertPositionRTL(p,b)));this._fixPositioning(p,b);}else if(sap.ui.core.CSSSize.isValid(A.left)&&sap.ui.core.CSSSize.isValid(A.top)){$.css({"left":A.left,"top":A.top});}else if(sap.ui.core.CSSSize.isValid(A.right)&&sap.ui.core.CSSSize.isValid(A.top)){$.css({"right":A.right,"top":A.top});}else if(typeof(A.left)==="number"&&typeof(A.top)==="number"){var c=$[0];if(c&&c.style.right){var w=$.outerWidth();$.css({"right":(document.documentElement.clientWidth-(A.left+w))+"px","top":A.top+"px"});}else{$.css({"left":A.left+"px","top":A.top+"px"});}}this._oLastPosition=p;this._oLastOfRect=this._calcOfRect(p.of);}};
P.prototype._calcOfRect=function(o){var b=this._getOfDom(o);if(b){return q(b).rect();}return null;};
P.prototype._getOfDom=function(o){if(o instanceof q.Event){return null;}var $;if(typeof(o)==="string"){$=q.sap.byId(o);}else if(o instanceof q){$=o;}else{$=q(o instanceof E?o.getDomRef():o);}return $[0];};
P.prototype._convertPositionRTL=function(p,b){var f=q.extend({},p);if(b){var n=false;if(f.my&&(f.my.indexOf("+")>=0||f.my.indexOf("-")>=0)){n=true;}if((f.offset||n)&&((f.my.indexOf("begin")>-1)||(f.my.indexOf("end")>-1))&&((f.at.indexOf("begin")>-1)||(f.at.indexOf("end")>-1))){if(n){var m=f.my.split(" ");if(m.length==2){f.my="";if(m[0]){if(m[0].indexOf("begin")>-1||m[0].indexOf("end")>-1){if(m[0].indexOf("+")>-1){m[0]=m[0].replace("+","-");}else if(m[0].indexOf("-")>-1){m[0]=m[0].replace("-","+");}}f.my=m[0];}if(m[1]){if(m[1].indexOf("begin")>-1||m[1].indexOf("end")>-1){if(m[1].indexOf("+")>-1){m[1]=m[1].replace("+","-");}else if(m[1].indexOf("-")>-1){m[1]=m[1].replace("-","+");}}if(m[0]){f.my=f.my+" ";}f.my=f.my+m[1];}}}else{f.offset=this._mirrorOffset(f.offset);}}f.my=f.my.replace("begin","right").replace("end","left");f.at=f.at.replace("begin","right").replace("end","left");}else{f.my=f.my.replace("end","right").replace("begin","left");f.at=f.at.replace("end","right").replace("begin","left");}return f;};
P.prototype._mirrorOffset=function(o){var b=q.trim(o).split(/\s/);var p=parseInt(b[0],10);return(-p)+" "+b[b.length-1];};
P.prototype._fixPositioning=function(p,b){var m=p.my;var $=this._$();var c=0;if(typeof(m)==="string"){if(b&&((m.indexOf("right")>-1)||(m.indexOf("begin")>-1)||(m.indexOf("center")>-1))){$=this._$();c=q(window).width()-$.outerWidth()-$.offset().left;$.css({"right":c+"px","left":""});}else if((m.indexOf("right")>-1)||(m.indexOf("end")>-1)){$=this._$();c=q(window).width()-$.outerWidth()-$.offset().left;$.css({"right":c+"px","left":""});}}};
P.prototype._resolveReference=function(p){var o=p;if(p.of instanceof E){o=q.extend({},p,{of:p.of.getDomRef()});}return o;};
P.prototype.setShadow=function(s){this._bShadow=s;if(this.eOpenState!=sap.ui.core.OpenState.CLOSED){this._$().toggleClass("sapUiShd",s);}return this;};
P.prototype.setModal=function(m,s){var o=this._bModal;this._bModal=m;this._sModalCSSClass=s;if(this.isOpen()){if(o!==m){if(m){this._showBlockLayer();}else{this._hideBlockLayer();}if(this.touchEnabled&&this._bAutoClose){if(!m){q(document).on("touchstart mousedown",q.proxy(this._fAutoCloseHandler,this));}else{q(document).off("touchstart mousedown",this._fAutoCloseHandler);}}}}return this;};
P.prototype.getModal=function(){return this._bModal;};
P.prototype.setNavigationMode=function(m){if(m!="NONE"&&m!="DOCK"&&m!="SCOPE"){this._sF6NavMode="NONE";}this._sF6NavMode=m;};
P.prototype.setAutoClose=function(A){if(this.touchEnabled&&this.isOpen()&&this._bAutoClose!==A){if(!this._bModal){if(A){q(document).on("touchstart mousedown",q.proxy(this._fAutoCloseHandler,this));}else{q(document).off("touchstart mousedown",this._fAutoCloseHandler);}}}this._bAutoClose=A;return this;};
P.prototype.setAutoCloseAreas=function(A){if(!this._aAutoCloseAreas){this._aAutoCloseAreas=[];}var c=function(e){return{onBeforeRendering:function(){var f=o.getDomRef();if(f&&this.isOpen()){if(D.browser.msie){q(f).unbind("deactivate."+this._popupUID,this.fEventHandler);}else{f.removeEventListener("blur",this.fEventHandler,true);}}},onAfterRendering:function(){var f=o.getDomRef();if(f&&this.isOpen()){if(D.browser.msie){q(f).bind("deactivate."+this._popupUID,this.fEventHandler);}else{f.addEventListener("blur",this.fEventHandler,true);}}}};};var s,o,d,b;for(var i=0,l=A.length;i<l;i++){o=A[i];if(o instanceof E){s=o.getId();}else if(typeof o==="object"){s=o.id;}else if(typeof o==="string"){s=o;}if(this.getChildPopups().indexOf(s)===-1){this.addChildPopup(s);b={id:s};if(o instanceof E){d=c(o);o.addEventDelegate(d,this);b.delegate=d;}this._aAutoCloseAreas.push(b);}}return this;};
P.prototype.setAnimations=function(o,c){if(o&&(typeof(o)=="function")){this._animations.open=o;}if(c&&(typeof(c)=="function")){this._animations.close=c;}return this;};
P.prototype.setDurations=function(o,c){if((o>0)||(o===0)){this._durations.open=o;}if((c>0)||(c===0)){this._durations.close=c;}return this;};
P.prototype._fnPreventScroll=function(e){if(!e.isMarked()){e.preventDefault();}};
P.CLOSE_ON_SCROLL="close_Popup_if_of_is_moved";
P.prototype._fnCloseOnScroll=function(e){this.close();};
P.prototype.setFollowOf=function(f){P.DockTrigger.removeListener(P.checkDocking,this);var u=false;this._bFollowOf=true;this._followOfHandler=null;if(typeof(f)==="function"){this._followOfHandler=f;u=true;}else if(typeof(f)==="boolean"){u=f;}else if(f===P.CLOSE_ON_SCROLL){this._followOfHandler=this._fnCloseOnScroll;u=true;}else{this._bFollowOf=false;if(f!==null){q.sap.log.error("Trying to set an invalid type to 'followOf: "+f);}}if(u&&this._oLastPosition){this._oLastOfRect=this._calcOfRect(this._oLastPosition.of);}if(this._bFollowOf&&this.getOpenState()===sap.ui.core.OpenState.OPEN){P.DockTrigger.addListener(P.checkDocking,this);}};
P.prototype.getAutoClose=function(){return this._bAutoClose;};
P.prototype.getFollowOf=function(){if(this._bFollowOf){return typeof(this._followOfHandler)==="function"?this._followOfHandler:true;}return false;};
P.prototype.isOpen=function(){return this.bOpen;};
P.prototype.getOpenState=function(){return this.eOpenState;};
P.prototype.destroy=function(){if(this._resizeListenerId){a.deregister(this._resizeListenerId);this._resizeListenerId=null;}this.close(0);this.oContent=null;if(this._bFollowOf){this.setFollowOf(null);}if(this._bEventBusEventsRegistered){this._unregisterEventBusEvents();}if(this._iTopShieldRemoveTimer){q.sap.clearDelayedCall(this._iTopShieldRemoveTimer);this.oShieldLayerPool.returnObject(this._oTopShieldLayer);this._oTopShieldLayer=null;this._iTopShieldRemoveTimer=null;}if(this._iBottomShieldRemoveTimer){q.sap.clearDelayedCall(this._iBottomShieldRemoveTimer);this.oShieldLayerPool.returnObject(this._oBottomShieldLayer);this._oBottomShieldLayer=null;this._iBottomShieldRemoveTimer=null;}if(this._aAutoCloseAreas){var e;this._aAutoCloseAreas.forEach(function(A){if(A.delegate){e=q.sap.byId(A.id).control(0);if(e){e.removeEventDelegate(A.delegate);}}});}M.prototype.destroy.apply(this,arguments);};
P.prototype.exit=function(){delete this._mEvents;};
P.prototype._addFocusEventListeners=function(c,e,o){if(!this.fEventHandler){this.fEventHandler=q.proxy(this.onFocusEvent,this);}var p=this._$();var b=this.getChildPopups();var d={};var i=0,l=0;if(p.length){if(document.addEventListener&&!D.browser.msie){document.addEventListener("focus",this.fEventHandler,true);p.get(0).addEventListener("blur",this.fEventHandler,true);for(i=0,l=b.length;i<l;i++){d=q.sap.domById(b[i]);if(d){d.addEventListener("blur",this.fEventHandler,true);}}}else{q(document).bind("activate."+this._popupUID,this.fEventHandler);p.bind("deactivate."+this._popupUID,this.fEventHandler);for(i=0,l=b.length;i<l;i++){d=q.sap.domById(b[i]);if(d){q(d).bind("deactivate."+this._popupUID,this.fEventHandler);}}}}};
P.prototype._removeFocusEventListeners=function(c,e,o){var p=this._$(false,true);if(!p.length){return;}var b=this.getChildPopups();var d={};var i=0,l=0;if(document.removeEventListener&&!D.browser.msie){document.removeEventListener("focus",this.fEventHandler,true);p.get(0).removeEventListener("blur",this.fEventHandler,true);for(i=0,l=b.length;i<l;i++){d=q.sap.domById(b[i]);if(d){d.removeEventListener("blur",this.fEventHandler,true);}this.closePopup(b[i]);}}else{q(document).unbind("activate."+this._popupUID,this.fEventHandler);p.unbind("deactivate."+this._popupUID,this.fEventHandler);for(i=0,l=b.length;i<l;i++){d=q.sap.domById(b[i]);if(d){q(d).unbind("deactivate."+this._popupUID,this.fEventHandler);}}}this.fEventHandler=null;};
P.prototype._registerEventBusEvents=function(c,e,o){var t=this;q.each(t._mEvents,function(s,l){sap.ui.getCore().getEventBus().subscribe("sap.ui",s,l,t);});this._bEventBusEventsRegistered=true;};
P.prototype._unregisterEventBusEvents=function(c,e,o){var t=this;q.each(t._mEvents,function(s,l){sap.ui.getCore().getEventBus().unsubscribe("sap.ui",s,l,t);});delete this._bEventBusEventsRegistered;};
P.prototype._addFocusableArea=function(c,e,o){if(this.getChildPopups().indexOf(o.id)===-1){this.addChildPopup(o.id);}};
P.prototype._removeFocusableArea=function(c,e,o){this.removeChildPopup(o.id);};
P.prototype._closePopup=function(c,e,o){this.close(typeof this._durations.close==="string"?0:this._durations.close);};
P.prototype._setIdentity=function($){if(typeof $==="object"){$.attr("data-sap-ui-popup",this._popupUID);}else{q.sap.log.warning("Incorrect DomRef-type for 'setIdentity': "+$,this);return;}if(!this._bEventBusEventsRegistered){this._registerEventBusEvents();}};
P.prototype._$=function(f,g){var c;if(this.oContent instanceof C){c=this.oContent.$();if(f||(c.length===0&&!g)){q.sap.log.info("Rendering of popup content: "+this.oContent.getId());if(c.length>0){R.preserveContent(c[0],true,false);}sap.ui.getCore().getRenderManager().render(this.oContent,sap.ui.getCore().getStaticAreaRef());c=this.oContent.$();}}else if(this.oContent instanceof E){c=this.oContent.$();}else{c=q(this.oContent);}this._setIdentity(c);return c;};
P.prototype._showBlockLayer=function(){var b=q("#sap-ui-blocklayer-popup"),c="sapUiBLy"+(this._sModalCSSClass?" "+this._sModalCSSClass:"");if(b.length===0){b=q('<div id="sap-ui-blocklayer-popup" tabindex="0" class="'+c+'"></div>');b.appendTo(sap.ui.getCore().getStaticAreaRef());}else{b.removeClass().addClass(c);}P.blStack.push({zIndex:this._iZIndex-2,popup:this});b.css({"z-index":this._iZIndex-2,"visibility":"visible"}).show();q("html").addClass("sapUiBLyBack");};
P.prototype._hideBlockLayer=function(){P.blStack.pop();var $=q("#sap-ui-blocklayer-popup");if($.length){var b=$.get(0);if(P.blStack.length>0){b.style.zIndex=P.blStack[P.blStack.length-1].zIndex;b.style.visibility="visible";b.style.display="block";}else{b.style.visibility="hidden";b.style.display="none";q("html").removeClass("sapUiBLyBack");}}};
P.prototype._isFocusInsidePopup=function(){var d=this._$(false).get(0);if(d&&q.sap.containsOrEquals(d,document.activeElement)){return true;}return false;};
P.DockTrigger=new I(200);
P.checkDocking=function(){if(this.getOpenState()===sap.ui.core.OpenState.OPEN){var c=this._getOfDom(this._oLastPosition.of),o=q(c).rect();if(!o){this.close();return;}else if(o.left===0&&o.top===0&&o.height===0&&o.height===0&&this._oLastPosition.of.id){this._oLastPosition.of=q.sap.domById(this._oLastPosition.of.id);c=this._getOfDom(this._oLastPosition.of);o=q(c).rect();if(!o){this.close();return;}}if(!q.sap.containsOrEquals(document.documentElement,c)){if(c.id&&c.id!==""){var n=q.sap.domById(c.id);var N=q(n).rect();if(N&&!r(o,N)){o=N;delete this._oLastPosition.of;this._oLastPosition.of=n;}}}if(this._oLastOfRect){if(!r(this._oLastOfRect,o)){if(this._followOfHandler){var l=q.extend(true,{},this._oLastPosition),L=q.extend(true,{},this._oLastOfRect);this._followOfHandler({lastPosition:l,lastOfRect:L,currentOfRect:o});}else{this._applyPosition(this._oLastPosition);}}}}};
P.prototype.ontouchstart=function(e){this.onmousedown(e,true);this._bMousedownCalled=true;};
P.prototype.onmousedown=function(e,s){if(this._bMousedownCalled&&!s){this._bMousedownCalled=false;return;}if(this._iZIndex===this.getLastZIndex()||this.getModal()){return;}this._increaseMyZIndex("","mousedown",e);};
P.prototype._increaseMyZIndex=function(c,e,o){var p=this.getParentPopup(this._oLastPosition.of);if(o&&o.type==="mousedown"||o&&o.isFromParentPopup||p.length===0){this._iZIndex=this.getNextZIndex();var $=this._$(false,true);$.css("z-index",this._iZIndex);if(this._oBlindLayer){this._oBlindLayer.update($,this._iZIndex-1);}if(o&&!o.type||o&&o.type!="mousedown"||e==="mousedown"){var b=this.getChildPopups();for(var i=0,l=b.length;i<l;i++){this.increaseZIndex(b[i],true);}}}else if(p.length>0){var s=q(p.get(0)).attr("data-sap-ui-popup");this.increaseZIndex(s,false);}};
P.prototype.onAfterRendering=function(e){var c=this.getContent();var $=c instanceof E?c.$():q(c);$.toggleClass("sapUiShd",this._bShadow);$.css("position","absolute");this._setIdentity($);var b=$[0];var l=b.style.left;var d=b.style.right;var t=b.style.top;var f=b.style.bottom;if(!(l&&l!="auto"||d&&d!="auto"||t&&t!="auto"||f&&f!="auto")){q.sap.log.debug("reposition popup content "+$.attr("id")+" at "+(window.JSON?JSON.stringify(this._oLastPosition.at):String(this._oLastPosition.at)));this._applyPosition(this._oLastPosition);}$.show().css({"visibility":"visible","z-index":this._iZIndex});if(this._oBlindLayer){this._resizeListenerId=a.register(this._$().get(0),q.proxy(this.onresize,this));}if(this.isOpen()&&(this.getModal()||this.getAutoClose())){this._addFocusEventListeners();}this._$(false,true).on("keydown",q.proxy(this._F6NavigationHandler,this));};
P.prototype.onBeforeRendering=function(e){if(this._resizeListenerId){a.deregister(this._resizeListenerId);this._resizeListenerId=null;}if(this.isOpen()&&(this.getModal()||this.getAutoClose())){this._removeFocusEventListeners();}this._$(false,true).off("keydown",this._F6NavigationHandler);};
P.prototype.onresize=function(e){if(this.eOpenState!=sap.ui.core.OpenState.CLOSED&&this._oBlindLayer){var t=this;setTimeout(function(){t._updateBlindLayer();},0);}};
P.prototype._updateBlindLayer=function(){if(this.eOpenState!=sap.ui.core.OpenState.CLOSED&&this._oBlindLayer){this._oBlindLayer.update(this._$(false,true));}};
P.prototype.isInPopup=function(t){var p=this.getParentPopup(t);return p&&p.length>0;};
P.prototype.getParentPopup=function(t){var T=t?t:this;var $=q(T instanceof E?T.getDomRef():T);return $.closest("[data-sap-ui-popup]");};
P.prototype.getParentPopupId=function(t){var p=this.getParentPopup(t);return p.attr("data-sap-ui-popup");};
P.prototype.addChildToPopup=function(p,c){var e="sap.ui.core.Popup.addFocusableContent-"+p;sap.ui.getCore().getEventBus().publish("sap.ui",e,{id:c});};
P.prototype.removeChildFromPopup=function(p,c){var e="sap.ui.core.Popup.removeFocusableContent-"+p;sap.ui.getCore().getEventBus().publish("sap.ui",e,{id:c});};
P.prototype.closePopup=function(p){var e="sap.ui.core.Popup.closePopup-"+p;sap.ui.getCore().getEventBus().publish("sap.ui",e);};
P.prototype.increaseZIndex=function(p,i){var e="sap.ui.core.Popup.increaseZIndex-"+p;sap.ui.getCore().getEventBus().publish("sap.ui",e,{isFromParentPopup:i?i:false});};
P.prototype.focusTabChain=function(p){var s=p.event.target,n=p.that.getMetadata().getName(),f;if((!p.$FocusablesContent||!p.$FocusablesFooter)||(!p.$FocusablesContent.length&&!p.$FocusablesFooter.length)){return;}if(s.id===p.firstFocusable){q.sap.log.debug("First dummy focus element was focused","",n);if(p.$FocusablesFooter.length>0){q.sap.log.debug("Last footer element will be focused","",n);f=p.$FocusablesFooter[p.$FocusablesFooter.length-1];}else{q.sap.log.debug("Last content element will be focused","",n);f=p.$FocusablesContent[p.$FocusablesContent.length-1];}}else if(s.id===p.lastFocusable){q.sap.log.debug("Last dummy focus element was focues","",n);if(p.$FocusablesContent.length>0){q.sap.log.debug("First content element will be focused","",n);f=p.$FocusablesContent[0];}else{q.sap.log.debug("First footer element will be focused","",n);f=p.$FocusablesFooter[0];}}if(f){q.sap.delayedCall(0,this,function(){var c=sap.ui.getCore().byId(f.id);if(c instanceof C){q.sap.log.debug("Focus will be handled by "+c.getMetadata().getName(),"",n);}else{q.sap.log.debug("oFocusDomRef will be focused","",n);}q.sap.focus(c?c:f);return c?c.getId():f.id;});}};
return P;});
sap.ui.predefine('sap/ui/core/Renderer',['jquery.sap.global','sap/ui/core/library'],function(q,s){"use strict";var T=s.TextAlign,a=s.TextDirection;var R={};
function c(b){return function(n,r){var C=Object.create(b);C.extend=c(C);if(r){q.extend(C,r);}q.sap.setObject(n,C);return C;};}
var e=c(R);
R.extend=function(n,r){if(typeof n==='string'){return e(n,r);}else{var C=Object.create(n||null);C._super=n;C.extend=c(C);return C;}};
R.getTextAlign=function(t,o){var b="",r=sap.ui.getCore().getConfiguration().getRTL();switch(t){case T.End:switch(o){case a.LTR:b="right";break;case a.RTL:b="left";break;default:b=r?"left":"right";break;}break;case T.Begin:switch(o){case a.LTR:b="left";break;case a.RTL:b="right";break;default:b=r?"right":"left";break;}break;case T.Right:if(!r||o==a.LTR){b="right";}break;case T.Center:b="center";break;case T.Left:if(r||o==a.RTL){b="left";}break;}return b;};
return R;},true);
sap.ui.predefine('sap/ui/core/ScrollBar',['jquery.sap.global','sap/ui/Device','./Control','./library','jquery.sap.script','jquery.sap.trace'],function(q,D,C,l){"use strict";var S=l.ScrollBarAction;
var a=C.extend("sap.ui.core.ScrollBar",{metadata:{library:"sap.ui.core",properties:{vertical:{type:"boolean",group:"Behavior",defaultValue:true},scrollPosition:{type:"int",group:"Behavior",defaultValue:null},size:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},contentSize:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},steps:{type:"int",group:"Dimension",defaultValue:null}},events:{scroll:{parameters:{action:{type:"sap.ui.core.ScrollBarAction"},forward:{type:"boolean"},newScrollPos:{type:"int"},oldScrollPos:{type:"int"}}}}}});
a.prototype.init=function(){this._$ScrollDomRef=null;this._iOldScrollPos=0;this._iOldStep=0;this._bScrollPosIsChecked=false;this._bRTL=sap.ui.getCore().getConfiguration().getRTL();this._bSuppressScroll=false;this._iMaxContentDivSize=1000000;if(q.sap.touchEventMode==="ON"){sap.ui.requireSync("sap/ui/thirdparty/zyngascroll");this._iLastTouchScrollerPosition=null;this._iTouchStepTreshold=24;this._bSkipTouchHandling=false;this._oTouchScroller=new window.Scroller(q.proxy(this._handleTouchScroll,this),{bouncing:false});}};
a.prototype.onBeforeRendering=function(){this.$("sb").unbind("scroll",this.onscroll);};
a.prototype.onAfterRendering=function(){this._iSteps=this.getSteps();var c=this.getContentSize();this._bStepMode=!c;var s=this.getSize();if(q.sap.endsWith(s,"px")){s=s.substr(0,s.length-2);}else{s=this.getVertical()?this.$().height():this.$().width();}var b=null;var $=this.$("ffsize");if(D.browser.firefox){b=$.outerHeight();if(b===0){b=window.getComputedStyle(q("body").get(0))["font-size"];if(q.sap.endsWith(b,"px")){b=b.substr(0,b.length-2);}b=parseInt(b,10);}}$.remove();if(D.browser.webkit){if(!document.width){b=Math.round(40/(window.outerWidth/q(document).width()));}else{b=Math.round(40/(document.width/q(document).width()));}}if(this.getVertical()){if(D.browser.firefox){this._iFactor=b;}else if(D.browser.webkit){this._iFactor=b;}else{this._iFactor=Math.floor(s*0.125);}this._iFactorPage=D.browser.firefox?s-b:Math.floor(s*0.875);}else{if(D.browser.firefox){this._iFactor=10;this._iFactorPage=Math.floor(s*0.8);}else if(D.browser.webkit){this._iFactor=b;this._iFactorPage=Math.floor(s*0.875);}else{this._iFactor=7;this._iFactorPage=s-14;}}this._$ScrollDomRef=this.$("sb");if(this._bStepMode){if(this.getVertical()){var i=this._iSteps*this._iFactor;if(i>this._iMaxContentDivSize){this._iFactor=this._iFactor/(i/this._iMaxContentDivSize);}var d=this._$ScrollDomRef.height()+Math.ceil(this._iSteps*this._iFactor);this._$ScrollDomRef.find("div").height(d);}else{var d=this._$ScrollDomRef.width()+this._iSteps*this._iFactor;this._$ScrollDomRef.find("div").width(d);}}this.setCheckedScrollPosition(this.getScrollPosition()?this.getScrollPosition():0,true);this._$ScrollDomRef.bind("scroll",q.proxy(this.onscroll,this));if(q.sap.touchEventMode==="ON"){this._bSkipTouchHandling=true;var o={width:0,height:0};o[this.getVertical()?"height":"width"]=this._bStepMode?(this.getSteps()*this._iTouchStepTreshold):parseInt(this.getContentSize(),10);this._oTouchScroller.setDimensions(0,0,o.width,o.height);var e=this._$ScrollDomRef.get(0);if(e){var r=e.getBoundingClientRect();this._oTouchScroller.setPosition(r.left+e.clientLeft,r.top+e.clientTop);this._bSkipTouchHandling=false;}}};
a.prototype.onmousewheel=function(e){if(this.$().is(":visible")){var o=e.originalEvent;var w=o.detail?o.detail:o.wheelDelta*(-1)/40;var f=w>0?true:false;if(q.sap.containsOrEquals(this._$ScrollDomRef[0],e.target)){this._doScroll(S.MouseWheel,f);}else{this._bMouseWheel=true;var p=null;if(this._bStepMode){p=w+this._iOldStep;}else{p=w*this._iFactor+this._iOldScrollPos;}this.setCheckedScrollPosition(p,true);}e.preventDefault();e.stopPropagation();return false;}};
a.prototype.ontouchstart=function(e){var t=e.touches;var f=t[0];if(f&&f.target&&f.target.tagName.match(/input|textarea|select/i)){return;}if(this._oTouchScroller){this._oTouchScroller.doTouchStart(t,e.timeStamp);}if(t.length==1){e.preventDefault();}};
a.prototype.ontouchmove=function(e){if(this._oTouchScroller){this._oTouchScroller.doTouchMove(e.touches,e.timeStamp,e.scale);}};
a.prototype.ontouchend=function(e){if(this._oTouchScroller){this._oTouchScroller.doTouchEnd(e.timeStamp);}};
a.prototype.ontouchcancel=function(e){if(this._oTouchScroller){this._oTouchScroller.doTouchEnd(e.timeStamp);}};
a.prototype.onscroll=function(e){if(this._bSuppressScroll){this._bSuppressScroll=false;e.preventDefault();e.stopPropagation();return false;}var s=null;if(this._$ScrollDomRef){if(this.getVertical()){s=Math.round(this._$ScrollDomRef.scrollTop());}else{s=Math.round(this._$ScrollDomRef.scrollLeft());if(D.browser.firefox&&this._bRTL){s=Math.abs(s);}else if(D.browser.webkit&&this._bRTL){var o=this._$ScrollDomRef.get(0);s=o.scrollWidth-o.clientWidth-o.scrollLeft;}}}var d=s-this._iOldScrollPos;var f=d>0?true:false;if(d<0){d=d*(-1);}var b=S.Drag;if(d==this._iFactor){b=S.Step;}else if(d==this._iFactorPage){b=S.Page;}else if(this._bMouseWheel){b=S.MouseWheel;}if(this._bLargeDataScrolling&&b===S.Drag){this._eAction=b;this._bForward=f;if(D.browser.msie){if(this._scrollTimeout){window.clearTimeout(this._scrollTimeout);}this._scrollTimeout=window.setTimeout(this._onScrollTimeout.bind(this),300);}}else{this._doScroll(b,f);}e.preventDefault();e.stopPropagation();return false;};
a.prototype._onScrollTimeout=function(){this._scrollTimeout=undefined;this._doScroll(this._eAction,this._bForward);this._eAction=undefined;this._bForward=undefined;this._bTouchScroll=undefined;};
a.prototype.onmouseup=function(){if(this._bLargeDataScrolling&&(this._eAction||this._bForward||this._bTouchScroll)&&!D.browser.msie){this._doScroll(this._eAction,this._bForward);this._eAction=undefined;this._bForward=undefined;this._bTouchScroll=undefined;}};
a.prototype.ontouchend=a.prototype.onmouseup;
a.prototype._handleTouchScroll=function(L,t,z){if(this._bSkipTouchHandling){return;}var v=this.getVertical()?t:L;var p;if(this._bStepMode){p=Math.max(Math.round(v/this._iTouchStepTreshold),0);}else{p=Math.round(v);}if(this._iLastTouchScrollerPosition!==p){this._iLastTouchScrollerPosition=p;this.setCheckedScrollPosition(p,true);if(this._bLargeDataScrolling){this._bTouchScroll=true;}else{this.fireScroll();}}};
a.prototype.unbind=function(o){if(o){this._$OwnerDomRef=q(o);if(this.getVertical()){this._$OwnerDomRef.unbind(D.browser.firefox?"DOMMouseScroll":"mousewheel",this.onmousewheel);}if(q.sap.touchEventMode==="ON"){this._$OwnerDomRef.unbind(this._getTouchEventType("touchstart"),q.proxy(this.ontouchstart,this));this._$OwnerDomRef.unbind(this._getTouchEventType("touchmove"),q.proxy(this.ontouchmove,this));this._$OwnerDomRef.unbind(this._getTouchEventType("touchend"),q.proxy(this.ontouchend,this));this._$OwnerDomRef.unbind(this._getTouchEventType("touchcancle"),q.proxy(this.ontouchcancle,this));}}};
a.prototype.bind=function(o){if(o){this._$OwnerDomRef=q(o);if(this.getVertical()){this._$OwnerDomRef.bind(D.browser.firefox?"DOMMouseScroll":"mousewheel",q.proxy(this.onmousewheel,this));}if(q.sap.touchEventMode==="ON"){this._$OwnerDomRef.bind(this._getTouchEventType("touchstart"),q.proxy(this.ontouchstart,this));this._$OwnerDomRef.bind(this._getTouchEventType("touchmove"),q.proxy(this.ontouchmove,this));this._$OwnerDomRef.bind(this._getTouchEventType("touchend"),q.proxy(this.ontouchend,this));this._$OwnerDomRef.bind(this._getTouchEventType("touchcancle"),q.proxy(this.ontouchcancle,this));}}};
a.prototype._getTouchEventType=function(t){return q.sap.touchEventMode==="SIM"?("sap"+t):t;};
a.prototype.pageUp=function(){this._doScroll(S.Page,false);};
a.prototype.pageDown=function(){this._doScroll(S.Page,true);};
a.prototype.setScrollPosition=function(s){if(this._$ScrollDomRef){this.setCheckedScrollPosition(s,true);}else{this.setProperty("scrollPosition",s);}return this;};
a.prototype.setCheckedScrollPosition=function(s,c){var i=Math.max(s,0);if(this._bStepMode===undefined){this._bStepMode=!this.getContentSize();}var b=i;if(this._bStepMode){i=Math.min(i,this.getSteps());b=i*this._iFactor;}i=Math.round(i);this._bSuppressScroll=!c;this.setProperty("scrollPosition",i,true);if(this.getVertical()){this._$ScrollDomRef.scrollTop(b);}else{if(D.browser.firefox&&this._bRTL){this._$ScrollDomRef.scrollLeft(-b);}else if(D.browser.webkit&&this._bRTL){var o=this._$ScrollDomRef.get(0);this._$ScrollDomRef.scrollLeft(o.scrollWidth-o.clientWidth-b);}else{this._$ScrollDomRef.scrollLeft(b);}}if(q.sap.touchEventMode==="ON"){var v=i;if(this._bStepMode){v=Math.round(i*this._iTouchStepTreshold);}this._oTouchScroller.__scrollTop=this.getVertical()?v:0;this._oTouchScroller.__scrollLeft=this.getVertical()?0:v;}};
a.prototype.setContentSize=function(c){this.setProperty("contentSize",c,true);this._bStepMode=false;var s=this.$("sbcnt");if(s){if(this.getVertical()){s.height(c);}else{s.width(c);}}return this;};
a.prototype._doScroll=function(A,f){var s=null;if(this._$ScrollDomRef){if(this.getVertical()){s=Math.round(this._$ScrollDomRef.scrollTop());}else{s=Math.round(this._$ScrollDomRef.scrollLeft());if(D.browser.firefox&&this._bRTL){s=Math.abs(s);}else if(D.browser.webkit&&this._bRTL){var o=this._$ScrollDomRef.get(0);s=o.scrollWidth-o.clientWidth-o.scrollLeft;}}}if(this._bStepMode){var i=Math.round(s/this._iFactor);var O=this._iOldStep;if(O!==i){this.setCheckedScrollPosition(i,false);q.sap.log.debug("-----STEPMODE-----: New Step: "+i+" --- Old Step: "+O+" --- Scroll Pos in px: "+s+" --- Action: "+A+" --- Direction is forward: "+f);this.fireScroll({action:A,forward:f,newScrollPos:i,oldScrollPos:O});this._iOldStep=i;}}else{s=Math.round(s);this.setProperty("scrollPosition",s,true);q.sap.log.debug("-----PIXELMODE-----: New ScrollPos: "+s+" --- Old ScrollPos: "+this._iOldScrollPos+" --- Action: "+A+" --- Direction is forward: "+f);this.fireScroll({action:A,forward:f,newScrollPos:s,oldScrollPos:this._iOldScrollPos});}if(Math.round(this._iFactor)==this._iFactor||!D.browser.msie){this._bSuppressScroll=false;}this._iOldScrollPos=s;this._bMouseWheel=false;q.sap.interaction.notifyScrollEvent({type:A});};
a.prototype.onThemeChanged=function(){this.rerender();};
a.prototype.getNativeScrollPosition=function(){if(this._$ScrollDomRef){if(this.getVertical()){return Math.round(this._$ScrollDomRef.scrollTop());}else{return Math.round(this._$ScrollDomRef.scrollLeft());}}return 0;};
a.prototype.setNativeScrollPosition=function(n){var s=Math.round(n);if(this._$ScrollDomRef){if(this.getVertical()){this._$ScrollDomRef.scrollTop(s);}else{this._$ScrollDomRef.scrollLeft(s);}}};
return a;});
sap.ui.predefine('sap/ui/core/ScrollBarRenderer',['jquery.sap.global','sap/ui/Device'],function(q,D){"use strict";var S={};
S.render=function(r,s){var a=r;var R=sap.ui.getCore().getConfiguration().getRTL();a.addClass("sapUiScrollBar");var b;if(D.support.touch){b="sapUiScrollBarTouch";a.addClass(b);}var v=s.getVertical();var c=s.getSize();var C=s.getContentSize();var B=q.sap.scrollbarSize(b);var w=B.width;var h=B.height;if(D.browser.edge){if(!w){w="15";}if(!h){h="15";}}if(v){a.write("<div");a.writeControlData(s);a.write(" style=\"overflow:hidden;width:"+w+"px");if(c){a.write(";height:"+c);}a.write("\"");a.writeClasses();a.write(">");a.write("<div ");a.writeAttribute("id",s.getId()+"-sb");a.write(" style=\"width:"+w*2+"px;height:100%;overflow-y:scroll;overflow-x:hidden");if(R){a.write(";margin-right:-"+w+"px");}else{a.write(";margin-left:-"+w+"px;");}a.write("\">");a.write("<div");a.writeAttribute("id",s.getId()+"-sbcnt");a.write(" style=\"width:"+w+"px");if(C){a.write(";height:"+C);}a.write("\"");a.write(">");a.write("</div>");a.write("</div>");a.write("<div> <span id="+s.getId()+"-ffsize"+" style='position: absolute; top: -9000px; left: -9000px; visibility: hidden; line-height: normal;'> FF Size</span></div>");a.write("</div>");}else{a.write("<div");a.writeControlData(s);a.write(" style=\"overflow:hidden;height:"+h+"px");if(c){a.write(";width:"+c);}a.write("\"");a.writeClasses();a.write(">");a.write("<div ");a.writeAttribute("id",s.getId()+"-sb");a.write(" style=\"height:"+h*2+"px;margin-top:-"+h+"px;overflow-x:scroll;overflow-y:hidden\">");a.write("<div");a.writeAttribute("id",s.getId()+"-sbcnt");a.write(" style=\"height:"+h+"px");if(C){a.write(";width:"+C);}a.write("\"");a.write(">");a.write("</div>");a.write("</div>");a.write("</div>");}};
return S;},true);
sap.ui.predefine('sap/ui/core/SeparatorItem',['./Item','./library'],function(I,l){"use strict";
var S=I.extend("sap.ui.core.SeparatorItem",{metadata:{library:"sap.ui.core"}});
return S;});
sap.ui.predefine('sap/ui/core/StashedControlSupport',['jquery.sap.global','sap/ui/core/Element','sap/ui/core/Control'],function(q,E,C){"use strict";var S={},s={},a=E.extend("sap.ui.core._StashedControl",{constructor:function(i,b){E.apply(this,arguments);b.stashed=true;q.sap.extend(this,b);this._stash(b.sParentId,b.sParentAggregationName);return this;},metadata:{specialSettings:{stashed:{type:'boolean',visibility:'hidden'},sParentId:{type:'string',visibility:'hidden'},sParentAggregationName:{type:'string',visibility:'hidden'},fnCreate:{type:'function',visibility:'hidden'}}}});
a.prototype.setParent=function(){q.sap.log.error("Cannot set parent on a StashedControl",this.getId());};
a.prototype.clone=function(){var c=E.prototype.clone.apply(this,arguments);s[c.getId()]=c;return c;};
a.prototype.destroy=function(){delete s[this.getId()];E.prototype.destroy.apply(this,arguments);};
m(a,true);
S.mixInto=function(c,d){m(c,d);};
function m(c,d){c.getMetadata().addSpecialSetting("stashed",{type:"boolean",defaultValue:!!d});c.prototype.setStashed=function(b){if(this.stashed===true&&!b){if(this.sParentId){var o=u(this,sap.ui.getCore().byId(this.sParentId));o.stashed=false;return;}}else if(b){q.sap.log.warning("Cannot re-stash a control",this.getId());}};c.prototype.getStashed=function(){return this.stashed;};var D=c.prototype.destroy;c.prototype.destroy=function(){delete s[this.getId()];D.apply(this,arguments);};c.prototype._stash=function(p,P){this.sParentId=p;this.sParentAggregationName=P;s[this.getId()]=this;};}
function u(o,p){if(o instanceof a){var b,d,O,f=o.fnCreate,P=o.sParentAggregationName;o.destroy();d=sap.ui.require("sap/ui/core/Component");O=d&&d.getOwnerComponentFor(p);if(O){b=O.runAsOwner(f);}else{b=f();}b.forEach(function(c){p.getMetadata().getAggregation(P).add(p,c);});}delete s[o.getId()];return o;}
function g(A,p){var b=[];for(var i in s){var I=A?s[i]:s[i].getId();if(!p||s[i].sParentId===p){b.push(I);}}return b;}
S.getStashedControlIds=function(p){return g(false,p);};
S.getStashedControls=function(p){return g(true,p);};
S.createStashedControl=function(i,b){return new a(i,b);};
return S;});
sap.ui.predefine('sap/ui/core/Title',['./Element','./library'],function(E,l){"use strict";var T=l.TitleLevel;
var a=E.extend("sap.ui.core.Title",{metadata:{library:"sap.ui.core",properties:{text:{type:"string",group:"Appearance",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},level:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:T.Auto},emphasized:{type:"boolean",group:"Appearance",defaultValue:false}}}});
return a;});
sap.ui.predefine('sap/ui/core/TooltipBase',['jquery.sap.global','./Control','./Popup','./library'],function(q,C,P,l){"use strict";var O=l.OpenState;
var T=C.extend("sap.ui.core.TooltipBase",{metadata:{"abstract":true,library:"sap.ui.core",properties:{text:{type:"string",group:"Misc",defaultValue:""},openDuration:{type:"int",group:"Behavior",defaultValue:200},closeDuration:{type:"int",group:"Behavior",defaultValue:200},myPosition:{type:"sap.ui.core.Dock",group:"Behavior",defaultValue:'begin top'},atPosition:{type:"sap.ui.core.Dock",group:"Behavior",defaultValue:'begin bottom'},offset:{type:"string",group:"Behavior",defaultValue:'10 3'},collision:{type:"sap.ui.core.Collision",group:"Behavior",defaultValue:'flip'},openDelay:{type:"int",group:"Misc",defaultValue:500},closeDelay:{type:"int",group:"Misc",defaultValue:100}},events:{closed:{}}}});
T.prototype._getPopup=q.sap.getter((function(){var p=new P();p.setShadow(true);return p;}()));
T.prototype.onfocusin=function(e){var s=q(e.target).control(0);if(s!=null){var d=s.getFocusDomRef();this.sStoredTooltip=null;if(d.title&&d.title!=""){this.sStoredTooltip=d.title;d.title="";}var p=this._getPopup();if(!(p.isOpen()&&p.getContent()==this)){sap.ui.getCore().getRenderManager().render(this,sap.ui.getCore().getStaticAreaRef(),true);}var v=d.getAttribute("aria-describedby");var i=this.getId()+"-title "+this.getId()+"-txt";if(v==null||v==""){d.setAttribute("aria-describedby",i);}else if(v.indexOf(i)==-1){d.setAttribute("aria-describedby",v+" "+i);}}};
T.prototype.onfocusout=function(e){var s=q(e.target).control(0);if(s!=null){var d=s.getFocusDomRef();if(this.sStoredTooltip){d.title=this.sStoredTooltip;}var v=d.getAttribute("aria-describedby");var i=this.getId()+"-title "+this.getId()+"-txt";if(v&&v.indexOf(i)>=0){if(v.trim()==i){d.removeAttribute("aria-describedby");}else{v=v.replace(i,"");d.setAttribute("aria-describedby",v);}}}if(T.sOpenTimeout){q.sap.clearDelayedCall(T.sOpenTimeout);T.sOpenTimeout=undefined;}this.sCloseNowTimeout=q.sap.delayedCall(this.getCloseDelay(),this,"closePopup");};
T.prototype.isStandardTooltip=function(t){return typeof t==="string"&&!!t.trim();};
T.prototype.onmouseover=function(e){var E=q(e.target).control(0),c=q(e.currentTarget).control(0),L=q(e.relatedTarget).control(0);if(!E){return;}if(E===this){if(this.sCloseNowTimeout){q.sap.clearDelayedCall(this.sCloseNowTimeout);this.sCloseNowTimeout=null;}e.stopPropagation();e.preventDefault();return;}if(c===E||!this.isStandardTooltip(E.getTooltip())){if(this.sCloseNowTimeout){q.sap.clearDelayedCall(this.sCloseNowTimeout);this.sCloseNowTimeout=null;e.stopPropagation();e.preventDefault();}}if(L){if(L.getParent()){if(L.getParent()===c&&c===E){var o=L.getTooltip();if(!this.isStandardTooltip(o)&&(!o||!(o instanceof T))){if(this.sCloseNowTimeout){q.sap.clearDelayedCall(this.sCloseNowTimeout);this.sCloseNowTimeout=null;e.stopPropagation();e.preventDefault();}}}}}if(this._currentControl===E||!this.isStandardTooltip(E.getTooltip())){this.removeStandardTooltips();if(T.sOpenTimeout){q.sap.clearDelayedCall(T.sOpenTimeout);}T.sOpenTimeout=q.sap.delayedCall(this.getOpenDelay(),this,"openPopup",[this._currentControl]);e.stopPropagation();e.preventDefault();}};
T.prototype.onmouseout=function(e){if(T.sOpenTimeout){q.sap.clearDelayedCall(T.sOpenTimeout);T.sOpenTimeout=undefined;}if(!this.sCloseNowTimeout){this.sCloseNowTimeout=q.sap.delayedCall(this.getCloseDelay(),this,"closePopup");}this.restoreStandardTooltips();e.stopPropagation();e.preventDefault();};
T.prototype.closePopup=function(){var p=this._getPopup();if(this.sCloseNowTimeout){q.sap.clearDelayedCall(this.sCloseNowTimeout);}this.sCloseNowTimeout=undefined;p.attachClosed(this.handleClosed,this);p.close();this.restoreStandardTooltips();};
T.prototype.handleClosed=function(){this._getPopup().detachClosed(this.handleClosed,this);this.fireClosed();};
T.prototype.openPopup=function(s){if(!this.getVisible()){return;}if(s.getTooltip()!=null){if(this.sCloseNowTimeout){q.sap.clearDelayedCall(this.sCloseNowTimeout);this.sCloseNowTimeout=null;return;}var p=this._getPopup();if(p.isOpen()&&p.getContent()==this){return;}sap.ui.getCore().getRenderManager().render(this,sap.ui.getCore().getStaticAreaRef(),true);var d=s.getDomRef();p.setContent(this);p.setPosition(this.getMyPosition(),this.getAtPosition(),d,this.getOffset(),this.getCollision());p.setDurations(this.getOpenDuration(),this.getCloseDuration());p.open();this.removeStandardTooltips();}};
T.prototype.removeStandardTooltips=function(){var d=this._currentControl.getDomRef();if(!this.aStoredTooltips){this.aStoredTooltips=[];}else{return;}var t="";while(d&&!(d===document)){t=d.title;if(t){this.aStoredTooltips.push({domref:d,tooltip:t});d.title="";}d=d.parentNode;}if(this._currentControl.getTooltipDomRefs){var D=this._currentControl.getTooltipDomRefs();for(var i=0;i<D.length;i++){d=D[i];if(d){t=d.title;if(t){this.aStoredTooltips.push({domref:d,tooltip:t});d.title="";}}}}};
T.prototype.restoreStandardTooltips=function(){var p=this._getPopup();var e=p.getOpenState();if(e===O.OPEN||e===O.OPENING){return;}if(T.sOpenTimeout){return;}if(this.aStoredTooltips){for(var i=0;i<this.aStoredTooltips.length;i++){var d=this.aStoredTooltips[i].domref;d.title=this.aStoredTooltips[i].tooltip;}}this.aStoredTooltips=null;};
T.prototype._setParent=T.prototype.setParent;
T.prototype.setParent=function(p,a){var _=this._getPopup();if(_&&_.isOpen()){this.closePopup();}this._setParent.apply(this,arguments);};
T.prototype.onkeydown=function(e){if(e.ctrlKey&&e.which==q.sap.KeyCodes.I){var E=q(e.target).control(0);if(E!=null){if(this._currentControl===E||!this.isStandardTooltip(E.getTooltip())){this.removeStandardTooltips();this.openPopup(this._currentControl);e.preventDefault();e.stopPropagation();}}}else if(e.which==q.sap.KeyCodes.ESCAPE){if(T.sOpenTimeout){q.sap.clearDelayedCall(T.sOpenTimeout);T.sOpenTimeout=undefined;}var w=this.oPopup&&this.oPopup.isOpen();this.closePopup();if(w){e.preventDefault();e.stopPropagation();}}};
T.prototype._closeOrPreventOpen=function(){var p=this._getPopup();if(p.isOpen()){this.closePopup();}else if(T.sOpenTimeout){q.sap.clearDelayedCall(T.sOpenTimeout);T.sOpenTimeout=undefined;}};
return T;});
sap.ui.predefine('sap/ui/core/UIComponent.designtime',[],function(){"use strict";return{aggregations:{rootControl:{ignore:false}}};},false);
sap.ui.predefine('sap/ui/core/UIComponent',['jquery.sap.global','../base/ManagedObject','./Component','./library','./UIComponentMetadata','./mvc/Controller','./mvc/View'],function(q,M,C,l,U,a,V){"use strict";var b=l.mvc.ViewType;
var c=C.extend("sap.ui.core.UIComponent",{
constructor:function(i,s){var d=false;try{C.apply(this,arguments);d=true;}finally{if(!d){this._destroyCreatedInstances();}}},
metadata:{"abstract":true,rootView:null,publicMethods:["render"],aggregations:{"rootControl":{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},designTime:true,routing:{}}
},U);
c._fnOnInstanceInitialized=null;c._fnOnInstanceDestroy=null;
c.prototype.init=function(){var t=this;var p={};if(this.getAutoPrefixId()){p.id=function(i){return t.createId(i);};}var r=this._getManifestEntry("/sap.ui5/routing",true)||{},R=r.config||{},v=r.routes;if(v){var d=sap.ui.requireSync("sap/ui/core/routing/Router");var f=g(this._getRouterClassName()||d);this._oRouter=new f(v,R,this,r.targets);this._oTargets=this._oRouter.getTargets();this._oViews=this._oRouter.getViews();}else if(r.targets){var T=sap.ui.requireSync("sap/ui/core/routing/Targets");var e=sap.ui.requireSync("sap/ui/core/routing/Views");this._oViews=new e({component:this});var h=g(R.targetsClass||T);this._oTargets=new h({targets:r.targets,config:R,views:this._oViews});}this.runAsOwner(function(){M.runWithPreprocessors(function(){t.setAggregation("rootControl",t.createContent());},p);});var o=this.getRootControl();if(o instanceof V){if(R.targetParent===undefined){R.targetParent=o.getId();}if(this._oTargets){this._oTargets._setRootViewId(o.getId());}}if(typeof c._fnOnInstanceInitialized==="function"){c._fnOnInstanceInitialized(this);}};
function g(r){var f;if(typeof r==="string"){f=q.sap.getObject(r);if(!f){q.sap.log.error("The specified class for router or targets '"+r+"' is undefined.",this);}}else{f=r;}return f;}
c.prototype.destroy=function(){if(typeof c._fnOnInstanceDestroy==="function"){c._fnOnInstanceDestroy(this);}this._destroyCreatedInstances();C.prototype.destroy.apply(this,arguments);};
c.prototype._destroyCreatedInstances=function(){if(this._oRouter){this._oRouter.destroy();delete this._oRouter;}if(this._oTargets){this._oTargets.destroy();this._oTargets=null;}if(this._oViews){this._oViews.destroy();this._oViews=null;}};
c.getRouterFor=function(o){var v=o;if(v instanceof a){v=v.getView();}if(v instanceof V){var d=C.getOwnerComponentFor(v);if(d){return d.getRouter();}else{return undefined;}}};
c.prototype.getRouter=function(){return this._oRouter;};
c.prototype.getTargets=function(){return this._oTargets;};
c.prototype.getAutoPrefixId=function(){return!!this.getManifestObject().getEntry("/sap.ui5/autoPrefixId");};
c.prototype.byId=function(i){return sap.ui.getCore().byId(this.createId(i));};
c.prototype.createId=function(i){if(!this.isPrefixedId(i)){i=this.getId()+"---"+i;}return i;};
c.prototype.getLocalId=function(i){var p=this.getId()+"---";return(i&&i.indexOf(p)===0)?i.slice(p.length):null;};
c.prototype.isPrefixedId=function(i){return!!(i&&i.indexOf(this.getId()+"---")===0);};
c.prototype.createContent=function(){var r=this._getManifestEntry("/sap.ui5/rootView",true);if(r&&typeof r==="string"){return sap.ui.view({viewName:r,type:b.XML});}else if(r&&typeof r==="object"){if(r.id){r.id=this.createId(r.id);}return sap.ui.view(r);}else if(r){throw new Error("Configuration option 'rootView' of component '"+this.getMetadata().getName()+"' is invalid! 'rootView' must be type of string or object!");}return null;};
c.prototype.getRootControl=function(){return this.getAggregation("rootControl");};
c.prototype.render=function(r){var o=this.getRootControl();if(o&&r){r.renderControl(o);}};
c.prototype.getUIArea=function(){return(this.oContainer?this.oContainer.getUIArea():null);};
c.prototype.getEventingParent=function(){return this.getUIArea();};
c.prototype.setContainer=function(o){this.oContainer=o;if(o){this._applyContextualSettings(o._getContextualSettings());}else{this._oContextualSettings=M._defaultContextualSettings;if(!this._bIsBeingDestroyed){setTimeout(function(){if(!this.oContainer){this._propagateContextualSettings();}}.bind(this),0);}}return this;};
c.prototype.onBeforeRendering=function(){};
c.prototype.onAfterRendering=function(){};
c.prototype._getRouterClassName=function(){var r=this._getManifestEntry("/sap.ui5/routing",true)||{},R=r.config||{};return R.routerClass;};
return c;});
sap.ui.predefine('sap/ui/core/UIComponentMetadata',['./ComponentMetadata','./library'],function(C,l){"use strict";var V=l.mvc.ViewType;var U=function(c,o){C.apply(this,arguments);};U.prototype=Object.create(C.prototype);
U.preprocessClassInfo=function(c){if(c&&typeof c.metadata==="string"){c.metadata={_src:c.metadata};}return c;};
U.prototype.getRootView=function(d){return this.getManifestEntry("/sap.ui5/rootView",!d);};
U.prototype.getRoutingConfig=function(d){return this.getManifestEntry("/sap.ui5/routing/config",!d);};
U.prototype.getRoutes=function(d){return this.getManifestEntry("/sap.ui5/routing/routes",!d);};
U.prototype._convertLegacyMetadata=function(s,m){C.prototype._convertLegacyMetadata.call(this,s,m);var u=m["sap.ui5"];var r=u["rootView"]||s["rootView"];if(r){u["rootView"]=r;}var R=u["routing"]||s["routing"];if(R){u["routing"]=R;}if(u["rootView"]&&typeof u["rootView"]==="string"){u["rootView"]={viewName:u["rootView"],type:V.XML};}};
return U;},true);
sap.ui.predefine('sap/ui/core/ValueStateSupport',['jquery.sap.global','./Element','./library'],function(q,E,l){"use strict";var V=l.ValueState;var a={};var t=null;var e=function(){if(!t){t={};var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.core");t[V.Error]=r.getText("VALUE_STATE_ERROR");t[V.Warning]=r.getText("VALUE_STATE_WARNING");t[V.Success]=r.getText("VALUE_STATE_SUCCESS");}};
a.enrichTooltip=function(o,T){if(!T&&o.getTooltip()){return undefined;}var s=a.getAdditionalText(o);if(s){return(T?T+" - ":"")+s;}return T;};
a.getAdditionalText=function(v){var s=null;if(v&&v.getValueState){s=v.getValueState();}else if(V[v]){s=v;}if(s&&(s!=V.None)){e();return t[s];}return null;};
a.formatValueState=function(s){switch(s){case 1:return V.Warning;case 2:return V.Success;case 3:return V.Error;default:return V.None;}};
return a;},true);
sap.ui.predefine('sap/ui/core/VariantLayoutData',['./LayoutData','./library'],function(L,l){"use strict";
var V=L.extend("sap.ui.core.VariantLayoutData",{metadata:{library:"sap.ui.core",aggregations:{multipleLayoutData:{type:"sap.ui.core.LayoutData",multiple:true,singularName:"multipleLayoutData"}}}});
return V;});
sap.ui.predefine('sap/ui/core/XMLComposite',['jquery.sap.global','sap/ui/core/Control','sap/ui/core/XMLCompositeMetadata','sap/ui/model/base/ManagedObjectModel','sap/ui/core/util/XMLPreprocessor','sap/ui/model/json/JSONModel','sap/ui/core/Fragment','sap/ui/base/ManagedObject','sap/ui/base/DataType','sap/ui/core/AggregationProxy'],function(q,C,X,M,a,J,F,b,D,P){"use strict";var c={};
function i(f,o){if(!c[f]){q.sap.require(f);c[f]=q.sap.getObject(f);}return c[f];}
function p(t,v,n,o){var B=b.bindingParser(v,o,true);if(B&&typeof B==="object"){return B;}var V=v=B||v;var T=D.getType(t);if(T){if(T instanceof D){V=T.parseValue(v);}}else{throw new Error("Property "+n+" has unknown type "+t);}return typeof V==="string"?b.bindingParser.escape(V):V;}
function d(m,n,E,I,v){var A=new J(E),o=I.getMetadata(),f=o.getAllAggregations(),h=o.getAllProperties(),s=o._mAllSpecialSettings;A.getVisitor=function(){return v;};A.getProperty=function(j,k){var r;j=this.resolve(j,k);j=j.substring(1);if(j&&j.startsWith&&j.startsWith("metadataContexts")){return this._navInMetadataContexts(j);}if(h.hasOwnProperty(j)){var l=h[j];if(!E.hasAttribute(j)){return l.defaultValue;}r=v.getResult(E.getAttribute(j))||E.getAttribute(j);if(r){var S=p(l.type,r,j);if(typeof S==="object"&&S.path){return r;}return S;}return null;}else if(f.hasOwnProperty(j)){var t=f[j];if(t.multiple===true&&t.type==="TemplateMetadataContext"){if(!E.hasAttribute(j)){return null;}return E.getAttribute(j);}return E.getAttribute(j);}else if(s.hasOwnProperty(j)){var u=s[j];if(!E.hasAttribute(j)){return u.defaultValue||null;}r=v.getResult(E.getAttribute(j));if(u.type){var S=p(u.type,r,j);if(typeof S==="object"&&S.path){return r;}return S;}if(r){return r;}return E.getAttribute(j);}};A._navInMetadataContexts=function(j){var r=j.replace("metadataContexts/","");var k,l=r.split("/");var R,N=m["metadataContexts"].getObject();while(l.length>0&&N){if(N.getObject){R=N.getObject(l.join("/"));}if(!R){k=l.shift();N=N[k];}else{return R;}}return N;};A.getContextName=function(){return n;};m[n]=A.getContext("/");}
function g(o){var s={};s.models=o.oModels||{};s.bindingContexts=o.oBindingContexts||{};return s;}
var e=C.extend("sap.ui.core.XMLComposite",{
metadata:{aggregations:{_content:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}}},
renderer:function(r,o){r.write("<div");r.writeControlData(o);r.writeClasses();r.write(">");var f=o.getAggregation(o.getMetadata().getCompositeAggregationName());if(f){r.renderControl(f);}r.write("</div>");}
},X);
e.prototype.applySettings=function(){this._bIsInitializing=true;var r=C.prototype.applySettings.apply(this,arguments);this._bIsInitializing=false;return r;};
e.prototype.byId=function(I){return sap.ui.getCore().byId(F.createId(this.getId(),I));};
e.prototype._getManagedObjectModel=function(){if(!this._oManagedObjectModel){this._oManagedObjectModel=new M(this);}return this._oManagedObjectModel;};
e.prototype.getSuppressInvalidateAggregation=function(n,s){var m=this.getMetadata(),A=m.getAggregation(n)||m.getAllPrivateAggregations()[n];if(!A){return true;}s=m._suppressInvalidate(A,s);m._requestFragmentRetemplatingCheck(this,A);return s;};
e.prototype.setProperty=function(n,v,s){var m=this.getMetadata(),o=m.getProperty(n);if(!o){return this;}s=this.getMetadata()._suppressInvalidate(o,s);if(C.prototype.getProperty.apply(this,[n])!==v){m._requestFragmentRetemplatingCheck(this,o);}return C.prototype.setProperty.apply(this,[n,v,s]);};
e.prototype.bindAggregation=function(n,o){var m=this.getMetadata(),A=m.getAggregation(n)||m.getAllPrivateAggregations()[n],B=C.prototype.getBinding.apply(this,[n]);if(!B||(B&&B.getPath()!==o.path)){m._requestFragmentRetemplatingCheck(this,A);}return C.prototype.bindAggregation.apply(this,[n,o]);};
e.prototype.unbindAggregation=function(n){var m=this.getMetadata(),A=m.getAggregation(n)||m.getAllPrivateAggregations()[n];if(this.isBound(n)){m._requestFragmentRetemplatingCheck(this,A,true);}return C.prototype.unbindAggregation.apply(this,[n]);};
e.prototype.setAggregation=function(n,o,s){return C.prototype.setAggregation.apply(this,[n,o,this.getSuppressInvalidateAggregation(n,s)]);};
e.prototype.addAggregation=function(n,o,s){return C.prototype.addAggregation.apply(this,[n,o,this.getSuppressInvalidateAggregation(n,s)]);};
e.prototype.insertAggregation=function(n,o,I,s){return C.prototype.insertAggregation.apply(this,[n,o,I,this.getSuppressInvalidateAggregation(n,s)]);};
e.prototype.removeAggregation=function(n,o,s){return C.prototype.removeAggregation.apply(this,[n,o,this.getSuppressInvalidateAggregation(n,s)]);};
e.prototype.removeAllAggregation=function(n,s){return C.prototype.removeAllAggregation.apply(this,[n,this.getSuppressInvalidateAggregation(n,s)]);};
e.prototype.destroyAggregation=function(n,s){return C.prototype.destroyAggregation.apply(this,[n,this.getSuppressInvalidateAggregation(n,s)]);};
e.prototype.updateAggregation=function(n,s){var A=this.getMetadata().getAggregation(n);if(A&&A.type==="TemplateMetadataContext"){this.invalidate();return;}C.prototype.updateAggregation.apply(this,arguments);};
e.prototype.setVisible=function(v){this.setProperty("visible",v);if(this.getParent()){this.getParent().invalidate();}return this;};
e.prototype._destroyCompositeAggregation=function(){var s=this.getMetadata().getCompositeAggregationName(),o=this.getAggregation(s);if(o){o.destroy();}return this;};
e.prototype.updateBindings=function(){if(this._bIsInitializing){return;}var r=C.prototype.updateBindings.apply(this,arguments);for(var n in this.mBindingInfos){var A=this.getMetadata().getAggregation(n);if(A&&A.multiple&&!A._doesNotRequireFactory&&this.isBound(n)&&!this.getBinding(n)){this[A._sDestructor]();}}return r;};
e.prototype._setCompositeAggregation=function(N){var s=this.getMetadata().getCompositeAggregationName();this._destroyCompositeAggregation();if(!this._oManagedObjectModel){this._getManagedObjectModel();}if(q.isArray(N)){this.setAggregation(s,null);return;}if(N){N.setModel(this._oManagedObjectModel,"$"+this.alias);N.bindObject("$"+this.alias+">/");}var t=this;this.setAggregation(s,N);var t=this;N._getPropertiesToPropagate=function(){var o=b.prototype._getPropertiesToPropagate.apply(this,arguments),B={},m={},f;for(var n in o.oBindingContexts){var h=o.oBindingContexts[n];if(h){f=h.getModel();if(f instanceof M&&f.getRootObject()instanceof e&&"$"+t.alias!==n){continue;}B[n]=o.oBindingContexts[n];}}for(var n in o.oModels){var f=o.oModels[n];if(f&&f instanceof M&&f.getRootObject()instanceof e&&"$"+t.alias!==n){continue;}m[n]=o.oModels[n];}o.oBindingContexts=B;o.oModels=m;return o;};this.invalidate();};
e.prototype._initCompositeSupport=function(s){var m=this.getMetadata(),A=m.getCompositeAggregationName(),I=false;if(s&&A){var n=s[A];if(n&&n.localName==="FragmentDefinition"){this._destroyCompositeAggregation();this._setCompositeAggregation(sap.ui.xmlfragment({sId:this.getId(),fragmentContent:s[A],oController:this}));I=true;}delete s[A];}if(!I){this._destroyCompositeAggregation();this._setCompositeAggregation(sap.ui.xmlfragment({sId:this.getId(),fragmentContent:this.getMetadata()._fragment,oController:this}));}};
e.prototype.requestFragmentRetemplating=function(f){if(f){this.fragmentRetemplating();return;}var A=this.getMetadata().getMandatoryAggregations(),B=true;for(var n in A){B=typeof this.getBindingInfo(n)==="object";if(!B){break;}}if(B){this.fragmentRetemplating();}};
e.prototype.fragmentRetemplating=function(){var m=this.getMetadata(),f=m.getFragment();if(!f){throw new Error("Fragment "+f.tagName+" not found");}var o=this._getManagedObjectModel();var t=this;o.getContextName=function(){return t.alias;};this.setModel(o,this.alias);this.bindObject(this.alias+">/");o._mSettings=g(this._getPropertiesToPropagate());delete o._mSettings.models["$"+this.alias];delete o._mSettings.bindingContexts["$"+this.alias];this.setModel(null,this.alias);a.process(f.querySelector("*"),{},o._mSettings);var s={};s[m.getCompositeAggregationName()]=f;this._initCompositeSupport(s);};
e.initialTemplating=function(E,v,f){var I=i(f),m={},o=I.getMetadata(),h=o.getFragment(),k=new J({});if(!h){throw new Error("Fragment "+f+" not found");}var s=E.getAttribute("metadataContexts");if(!s&&o._mSpecialSettings.metadataContexts){s=o._mSpecialSettings.metadataContexts.defaultValue;}if(s){var K,l,n=b.bindingParser(s);if(!n.parts){l=n;n={parts:[l]};}for(var j=0;j<n.parts.length;j++){l=n.parts[j];if(!l.model){l.model=I.prototype.defaultMetaModel;}K=l.name||l.model||undefined;try{m[K]=v.getContext(l.model+">"+l.path);n[K]=m[K];}catch(r){m["_$error"]=m["_$error"]||k.getContext("/");m["_$error"].oModel.setProperty("/"+K,r);}}var t=new J(n);m["metadataContexts"]=t.getContext("/");}d(m,I.prototype.alias,E,I,v);var u=v["with"](m,true);var w=I.getMetadata();u.visitChildNodes(h);var N=h.ownerDocument.createElementNS("http://schemas.sap.com/sapui5/extension/sap.ui.core.xmlcomposite/1",w.getCompositeAggregationName());N.appendChild(h);E.appendChild(N);};
e.helper={listContext:function(o){var B=o.getModel().getProperty(o.getPath());if(typeof B==="string"){B=b.bindingParser(B);}if(q.isArray(B)){var f=o.getModel().getProperty(o.getPath()+"/@binding");if(f){return f.getModel().getMetaModel().getMetaContext(f.getPath());}else{return undefined;}}if(typeof B==="object"){var v=o.getModel().getVisitor();var m=v.getSettings().models[B.model];if(m){return m.createBindingContext(B.path);}return null;}else{return undefined;}},listMetaContext:function(o){var B=o.getModel().getProperty(o.getPath());if(typeof B==="string"){B=b.bindingParser(B);}if(q.isArray(B)){var f=o.getModel().getProperty(o.getPath()+"/@binding");if(f){return f.getModel().getMetaModel().getMetaContext(f.getPath());}else{return undefined;}}if(typeof B==="object"){var v=o.getModel().getVisitor();B=b.bindingParser("{"+B.path+"}");var m=v.getSettings().models[B.model];if(m){var h=m.getMetaModel();if(h&&h.getMetaContext){return h.getMetaContext(B.path);}}return null;}else{return undefined;}},runtimeProperty:function(o,v){if(o.getModel().getContextName){return"{$"+o.getModel().getContextName()+">"+o.getPath()+"}";}return v;},runtimeBinding:function(o,v){return"{Name}";},runtimeListBinding:function(o,v){if(q.isArray(v)){var B=o.getModel().getProperty(o.getPath()+"/@binding");if(B){return"{path: '"+B.getPath()+"'}";}return null;}return v;}};e.helper.listMetaContext.requiresIContext=true;e.helper.runtimeProperty.requiresIContext=true;e.helper.runtimeListBinding.requiresIContext=true;e.helper.runtimeBinding.requiresIContext=true;return e;},true);
sap.ui.predefine('sap/ui/core/XMLCompositeMetadata',['jquery.sap.global','sap/ui/core/ElementMetadata','sap/ui/core/XMLTemplateProcessor'],function(q,E,X){"use strict";var I={Render:true,Template:"template",None:false};var a=function(c,C){if(!C.hasOwnProperty("renderer")){C.renderer="sap.ui.core.XMLCompositeRenderer";}if(!C.hasOwnProperty("alias")){C.alias="this";}E.apply(this,arguments);var b=this._bAbstract;if(!b){if(!C.fragment&&c!=="sap.ui.core.XMLComposite"){C.fragment=c;C.fragmentUnspecified=true;}if(!this._fragment&&C.fragment){try{this._fragment=X.loadTemplate(C.fragment,"control");}catch(e){if(!C.fragmentUnspecified){throw(e);}else{q.sap.log.warning("Implicitly inferred fragment xml "+C.fragment+" not found. "+c+" is not abstract!");}}}}this._sCompositeAggregation=C.metadata?C.metadata.compositeAggregation||null:null;this._createPrivateAggregationAccessors();this._applyAggregationSettings();};a.prototype=Object.create(E.prototype);a.uid=E.uid;
a.prototype.getCompositeAggregationName=function(){return this._sCompositeAggregation||"_content";};
a.prototype.getFragment=function(){if(this._fragment){return this._fragment.cloneNode(true);}};
a.prototype._applyAggregationSettings=function(){var A=this.getAllAggregations();for(var n in A){if(A[n].type==="TemplateMetadataContext"){this.getAggregation(n)._doesNotRequireFactory=true;}}};
a.prototype._createPrivateAggregationAccessors=function(){var p=this.getAllPrivateAggregations(),b=this.getClass().prototype,g=function(c,f){if(!b[c]){b[c]=f;}};for(var n in p){p[n].generate(g);}};
a.prototype._suppressInvalidate=function(m,s){if(s){return true;}if(!m.appData){m.appData={};m.appData.invalidate=I.None;}if(m&&m.appData&&m.appData.invalidate===I.Render){return false;}return true;};
a.prototype._requestFragmentRetemplatingCheck=function(c,m,f){if(!c._bIsInitializing&&m&&m.appData&&m.appData.invalidate===I.Template&&!c._requestFragmentRetemplatingPending){if(c.requestFragmentRetemplating){c._requestFragmentRetemplatingPending=true;setTimeout(function(){c.requestFragmentRetemplating(f);c._requestFragmentRetemplatingPending=false;},0);}else{throw new Error("Function requestFragmentRetemplating not available although invalidationMode was set to template");}}};
a.prototype.getMandatoryAggregations=function(){if(!this._mMandatoryAggregations){var A=this.getAllAggregations(),m={};for(var n in A){if(A[n].type==="TemplateMetadataContext"&&A[n].appData.mandatory){m[n]=A[n];}}this._mMandatoryAggregations=m;}return this._mMandatoryAggregations;};
return a;},true);
sap.ui.predefine('sap/ui/core/XMLTemplateProcessor',['jquery.sap.global','sap/ui/base/DataType','sap/ui/base/ManagedObject','sap/ui/core/CustomData','./mvc/View','./ExtensionPoint','./StashedControlSupport'],function(q,D,M,C,V,E,S){"use strict";
function p(t,v,n,c){var b=M.bindingParser(v,c,true);if(b&&typeof b==="object"){return b;}var a=v=b||v;var T=D.getType(t);if(T){if(T instanceof D){a=T.parseValue(v);}}else{throw new Error("Property "+n+" has unknown type "+t);}return typeof a==="string"?M.bindingParser.escape(a):a;}
function l(x){return x.localName||x.baseName||x.nodeName;}
var X={};
X.loadTemplate=function(t,s){var r=q.sap.getResourceName(t,"."+(s||"view")+".xml");return q.sap.loadResource(r).documentElement;};
X.parseViewAttributes=function(x,v,s){var a=v.getMetadata().getAllProperties();for(var i=0;i<x.attributes.length;i++){var b=x.attributes[i];if(b.name==='controllerName'){v._controllerName=b.value;}else if(b.name==='resourceBundleName'){v._resourceBundleName=b.value;}else if(b.name==='resourceBundleUrl'){v._resourceBundleUrl=b.value;}else if(b.name==='resourceBundleLocale'){v._resourceBundleLocale=b.value;}else if(b.name==='resourceBundleAlias'){v._resourceBundleAlias=b.value;}else if(b.name==='class'){v.addStyleClass(b.value);}else if(!s[b.name]&&a[b.name]){s[b.name]=p(a[b.name].type,b.value,b.name,v._oContainingView.oController);}}};
var e=false;
X.enrichTemplateIds=function(x,v){var r=(e!==false);e=true;try{X.parseTemplate(x,v);}finally{e=r;}return x;};
X.parseTemplate=function(x,v){var d=sap.ui.getCore().getConfiguration().getDesignMode();var r=[];if(d){v._sapui_declarativeSourceInfo={xmlNode:x,xmlRootNode:v._oContainingView===v?x:v._oContainingView._sapui_declarativeSourceInfo.xmlRootNode};}var c=v.sViewName||v._sFragmentName;if(!c){var t=v;var L=0;while(++L<1000&&t&&t!==t._oContainingView){t=t._oContainingView;}c=t.sViewName;}if(v.isSubView()){f(x,true);}else{if(x.localName==="View"&&x.namespaceURI!=="sap.ui.core.mvc"){q.sap.log.warning("XMLView root node must have the 'sap.ui.core.mvc' namespace, not '"+x.namespaceURI+"'"+(c?" (View name: "+c+")":""));}g(x);}return r;function a(i){return i;}function b(i){return v._oContainingView.createId(i);}function f(x,R,I){if(x.nodeType===1){var j=l(x);if(x.namespaceURI==="http://www.w3.org/1999/xhtml"||x.namespaceURI==="http://www.w3.org/2000/svg"){r.push("<"+j+" ");var H=false;for(var i=0;i<x.attributes.length;i++){var u=x.attributes[i];var w=u.value;if(u.name==="id"){H=true;w=o(v,x);}r.push(u.name+"=\""+q.sap.encodeHTML(w)+"\" ");}if(R===true){r.push("data-sap-ui-preserve"+"=\""+v.getId()+"\" ");if(!H){r.push("id"+"=\""+v.getId()+"\" ");}}r.push(">");if(window.HTMLTemplateElement&&x instanceof HTMLTemplateElement&&x.content instanceof DocumentFragment){g(x.content);}else{g(x);}r.push("</"+j+">");}else if(j==="FragmentDefinition"&&x.namespaceURI==="sap.ui.core"){g(x,false,true);}else{var y=m(x);for(var i=0;i<y.length;i++){var z=y[i];if(v.getMetadata().hasAggregation("content")){v.addAggregation("content",z);}else if(v.getMetadata().hasAssociation(("content"))){v.addAssociation("content",z);}r.push(z);}}}else if(x.nodeType===3&&!I){var A=x.textContent||x.text,B=l(x.parentNode);if(A){if(B!="style"){A=q.sap.encodeHTML(A);}r.push(A);}}}function g(x,R,I){var j=x.childNodes;for(var i=0;i<j.length;i++){f(j[i],R,I);}}function h(N,i){var j;var u=sap.ui.getCore().getLoadedLibraries();q.each(u,function(y,z){if(N===z.namespace||N===z.name){j=z.name+"."+((z.tagNames&&z.tagNames[i])||i);}});j=j||N+"."+i;q.sap.require(j);var w=q.sap.getObject(j);if(w){return w;}else{q.sap.log.error("Can't find object class '"+j+"' for XML-view","","XMLTemplateProcessor.js");}}function k(i){if(i.namespaceURI==="http://www.w3.org/1999/xhtml"||i.namespaceURI==="http://www.w3.org/2000/svg"){var j=i.attributes['id']?i.attributes['id'].textContent||i.attributes['id'].text:null;if(e){X.enrichTemplateIds(i,v);return[];}else{var u=sap.ui.requireSync("sap/ui/core/mvc/XMLView");return[new u({id:j?o(v,i,j):undefined,xmlNode:i,containingView:v._oContainingView})];}}else{return m(i);}}function m(j){if(l(j)==="ExtensionPoint"&&j.namespaceURI==="sap.ui.core"){if(e){return[];}else{return E(v,j.getAttribute("name"),function(){var u=j.childNodes;var w=[];for(var i=0;i<u.length;i++){var y=u[i];if(y.nodeType===1){w=q.merge(w,k(y));}}return w;});}}else{return n(j);}}function n(u){var w=u.namespaceURI,y=h(w,l(u)),z={},A="",B=[],F=null;if(!y){return[];}var G=y.getMetadata();var K=G.getAllSettings();if(!e){for(var i=0;i<u.attributes.length;i++){var H=u.attributes[i],N=H.name,I=K[N],J=H.value;if(N==="id"){z[N]=o(v,u,J);}else if(N==="class"){A+=J;}else if(N==="viewName"){z[N]=J;}else if(N==="fragmentName"){z[N]=J;z['containingView']=v._oContainingView;}else if((N==="binding"&&!I)||N==='objectBindings'){var O=M.bindingParser(J,v._oContainingView.oController);if(O){z.objectBindings=z.objectBindings||{};z.objectBindings[O.model||undefined]=O;}}else if(N==='metadataContexts'){var P;if(X._preprocessMetadataContexts){P=X._preprocessMetadataContexts(y.getMetadata().getName(),u,v._oContainingView.oController);}if(P){z.metadataContexts=z.metadataContexts||{};z.metadataContexts[P.model||undefined]=P;}}else if(N.indexOf(":")>-1){if(H.namespaceURI==="http://schemas.sap.com/sapui5/extension/sap.ui.core.CustomData/1"){var Q=l(H);B.push(new C({key:Q,value:p("any",J,Q,v._oContainingView.oController)}));}else if(H.namespaceURI==="http://schemas.sap.com/sapui5/extension/sap.ui.core.support.Support.info/1"){F=J;}else if(N.indexOf("xmlns:")!==0){q.sap.log.warning(v+": XMLView parser encountered and ignored attribute '"+N+"' (value: '"+J+"') with unknown namespace");}}else if(I&&I._iKind===0){z[N]=p(I.type,J,N,v._oContainingView.oController);}else if(I&&I._iKind===1&&I.altTypes){z[N]=p(I.altTypes[0],J,N,v._oContainingView.oController);}else if(I&&I._iKind===2){var O=M.bindingParser(J,v._oContainingView.oController);if(O){z[N]=O;}else{q.sap.log.error(v+": aggregations with cardinality 0..n only allow binding paths as attribute value (wrong value: "+N+"='"+J+"')");}}else if(I&&I._iKind===3){z[N]=b(J);}else if(I&&I._iKind===4){z[N]=J.split(/[\s,]+/g).filter(a).map(b);}else if(I&&I._iKind===5){var R=V._resolveEventHandler(J,v._oContainingView.oController);if(R){z[N]=R;}else{q.sap.log.warning(v+": event handler function \""+J+"\" is not a function or does not exist in the controller.");}}else if(I&&I._iKind===-1){if(V.prototype.isPrototypeOf(y.prototype)&&N=="async"){z[N]=p(I.type,J,N,v._oContainingView.oController);}else{q.sap.log.warning(v+": setting '"+N+"' for class "+G.getName()+" (value:'"+J+"') is not supported");}}else{if(X._supportInfo){X._supportInfo({context:u,env:{caller:"createRegularControls",error:true,info:"unknown setting '"+N+"' for class "+G.getName()}});}}}if(B.length>0){z.customData=B;}}function T(u,W,Y){var j;for(j=u.firstChild;j;j=j.nextSibling){U(u,W,Y,j);}}function U(u,W,Y,c1,d1){var e1;if(c1.nodeType===1){if(c1.namespaceURI==="http://schemas.sap.com/sapui5/extension/sap.ui.core.xmlcomposite/1"||c1.namespaceURI==="http://schemas.sap.com/sapui5/extension/sap.ui.core.fragmentcontrol/1"){z[l(c1)]=c1.querySelector("*");return;}e1=c1.namespaceURI===w&&Y&&Y[l(c1)];if(e1){T(c1,e1);}else if(W){if(!d1&&c1.getAttribute("stashed")==="true"&&!e){S.createStashedControl(o(v,c1),{sParentId:z["id"],sParentAggregationName:W.name,fnCreate:function(){return U(u,W,Y,c1,true);}});return;}var f1=k(c1);for(var j=0;j<f1.length;j++){var g1=f1[j];var h1=W.name;if(W.multiple){if(!z[h1]){z[h1]=[];}if(typeof z[h1].path==="string"){z[h1].template=g1;}else{z[h1].push(g1);}}else{z[h1]=g1;}}return f1;}else if(l(u)!=="FragmentDefinition"||u.namespaceURI!=="sap.ui.core"){throw new Error("Cannot add direct child without default aggregation defined for control "+G.getElementName());}}else if(c1.nodeType===3){if(q.trim(c1.textContent||c1.text)){throw new Error("Cannot add text nodes as direct child of an aggregation. For adding text to an aggregation, a surrounding html tag is needed: "+q.trim(c1.textContent||c1.text));}}return[];}var W=G.getDefaultAggregation();var Y=G.getAllAggregations();T(u,W,Y);var Z;if(e&&u.hasAttribute("id")){s(v,u);}else if(!e){if(V.prototype.isPrototypeOf(y.prototype)&&typeof y._sType==="string"){Z=sap.ui.view(z,undefined,y._sType);}else{Z=new y(z);}if(A&&Z.addStyleClass){Z.addStyleClass(A);}}if(!Z){Z=[];}else if(!Array.isArray(Z)){Z=[Z];}if(X._supportInfo&&Z){for(var i=0,$=Z.length;i<$;i++){var _=Z[i];if(_&&_.getId()){var a1=X._supportInfo({context:u,env:{caller:"createRegularControls",nodeid:u.getAttribute("id"),controlid:_.getId()}}),b1=F?F+",":"";b1+=a1;X._supportInfo.addSupportInfo(_.getId(),b1);}}}if(d){Z.forEach(function(_){_._sapui_declarativeSourceInfo={xmlNode:u,xmlRootNode:v._sapui_declarativeSourceInfo.xmlRootNode,fragmentName:G.getName()==='sap.ui.core.Fragment'?z['fragmentName']:null};});}return Z;}function o(v,x,i){if(x.getAttributeNS("http://schemas.sap.com/sapui5/extension/sap.ui.core.Internal/1","id")){return x.getAttribute("id");}else{return b(i?i:x.getAttribute("id"));}}function s(v,x){x.setAttribute("id",b(x.getAttribute("id")));x.setAttributeNS("http://schemas.sap.com/sapui5/extension/sap.ui.core.Internal/1","id",true);}};
X._preprocessMetadataContexts=null;return X;},true);
sap.ui.predefine('sap/ui/core/cache/CacheManager',['jquery.sap.global','./LRUPersistentCache','./CacheManagerNOP','sap/ui/Device'],function(q,L,C,D){"use strict";var a={_instance:null,_getInstance:function(){var p,M=c("_getInstance"),t=this;p=new Promise(function(r,d){var I;q.sap.log.debug("Cache Manager: Initialization...");if(!a._instance){I=t._findImplementation();q.sap.measure.start(b,"CM",S);I.init().then(e,d);q.sap.measure.end(b,"CM");}else{e(a._instance);}function e(f){a._instance=f;M.endAsync();q.sap.log.debug("Cache Manager initialized with implementation ["+a._instance.name+"], resolving _getInstance promise");r(f);}});M.endSync();return p;},_findImplementation:function(){if(i()&&this._isSupportedEnvironment()){return L;}else{q.sap.log.warning("UI5 Cache Manager is switched off");return C;}},set:function(k,v){var p,M=c("set",k);q.sap.log.debug("Cache Manager: Setting value of type["+typeof v+"] with key ["+k+"]");p=this._callInstanceMethod("set",arguments).then(function callInstanceHandler(){q.sap.log.debug("Cache Manager: Setting key ["+k+"] completed successfully");M.endAsync();},function(e){q.sap.log.error("Cache Manager: Setting key ["+k+"] failed. Error:"+e);M.endAsync();throw e;});M.endSync();return p;},get:function(k){var p,M=c("get",k);q.sap.log.debug("Cache Manager: Getting key ["+k+"]");p=this._callInstanceMethod("get",arguments).then(function callInstanceHandler(v){q.sap.log.debug("Cache Manager: Getting key ["+k+"] done");M.endAsync();return v;},function(e){q.sap.log.debug("Cache Manager: Getting key ["+k+"] failed. Error: "+e);M.endAsync();throw e;});M.endSync();return p;},has:function(k){var p,M=c("has",k);q.sap.log.debug("Cache Manager: has key ["+k+"] called");p=this._callInstanceMethod("has",arguments).then(function callInstanceHandler(r){M.endAsync();q.sap.log.debug("Cache Manager: has key ["+k+"] returned "+r);return r;});M.endSync();return p;},del:function(k){var p,M=c("del",k);q.sap.log.debug("Cache Manager: del called.");p=this._callInstanceMethod("del",arguments).then(function callInstanceHandler(){q.sap.log.debug("Cache Manager: del completed successfully.");M.endAsync();},function(e){q.sap.log.debug("Cache Manager: del failed. Error: "+e);M.endAsync();throw e;});M.endSync();return p;},reset:function(){var p,M=c("reset");q.sap.log.debug("Cache Manager: Reset called.");p=this._callInstanceMethod("reset",arguments).then(function callInstanceHandler(){q.sap.log.debug("Cache Manager: Reset completed successfully.");M.endAsync();},function(e){q.sap.log.debug("Cache Manager: Reset failed. Error: "+e);M.endAsync();throw e;});M.endSync();return p;},_switchOff:function(){var t=this;return Promise.resolve().then(function(){s(t);sap.ui.getCore().getConfiguration().setUI5CacheOn(false);});},_switchOn:function(){var t=this;return Promise.resolve().then(function(){var o=sap.ui.getCore().getConfiguration();if(!o.isUI5CacheOn()){s(t);sap.ui.getCore().getConfiguration().setUI5CacheOn(true);}return Promise.resolve();});},_callInstanceMethod:function(M,A){var p,d="[sync ] _callInstanceMethod";q.sap.measure.start(d,"CM",S);if(this._instance){q.sap.log.debug("Cache Manager: calling instance...");return this._instance[M].apply(this._instance,A);}q.sap.log.debug("Cache Manager: getting instance...");p=this._getInstance().then(function instanceResolving(e){return e[M].apply(e,A);});q.sap.measure.end(d);return p;},_isSupportedEnvironment:function(){var d=[];if(this._bSupportedEnvironment==undefined){d.push({system:D.system.SYSTEMTYPE.DESKTOP,browserName:D.browser.BROWSER.CHROME,browserVersion:49});d.push({system:D.system.SYSTEMTYPE.DESKTOP,browserName:D.browser.BROWSER.INTERNET_EXPLORER,browserVersion:11});this._bSupportedEnvironment=d.some(function(o){var e=D.system[o.system],f=o.browserName===D.browser.name,g=D.browser.version>=o.browserVersion;return e&&f&&g;});}return this._bSupportedEnvironment;}};var S="CacheManager",b="[sync ] _initImplementation",m=0;
function i(){return sap.ui.getCore().getConfiguration().isUI5CacheOn();}
function s(d){if(d._instance){d._instance._destroy();d._instance=null;}}
function c(o,k){m++;var M="[async]  "+o+"["+k+"]- #"+(m),d="[sync ]  "+o+"["+k+"]- #"+(m);q.sap.measure.start(M,"CM",[S,o]);q.sap.measure.start(d,"CM",[S,o]);return{sMeasureAsync:M,sMeasureSync:d,endAsync:function(){q.sap.measure.end(this.sMeasureAsync);},endSync:function(){q.sap.measure.end(this.sMeasureSync);}};}
return a;},false);
sap.ui.predefine('sap/ui/core/cache/CacheManagerNOP',['jquery.sap.global'],function(q){"use strict";var C={name:"CacheManagerNOP",set:function(){return Promise.resolve();},get:function(){return Promise.resolve(undefined);},has:function(){return Promise.resolve(false);},del:function(){return Promise.resolve();},reset:function(){return Promise.resolve();},init:function(){return Promise.resolve(this);},_db:{close:function(){}},_getCount:function(){return Promise.resolve(0);},_destroy:function(){}};return C;},false);
sap.ui.predefine('sap/ui/core/date/Gregorian',['jquery.sap.global','./UniversalDate','sap/ui/core/Locale','sap/ui/core/LocaleData'],function(q,U,L,a){"use strict";
var G=U.extend("sap.ui.core.date.Gregorian",{constructor:function(){this.oDate=this.createDate(Date,arguments);this.sCalendarType=sap.ui.core.CalendarType.Gregorian;}});
G.UTC=function(){return Date.UTC.apply(Date,arguments);};
G.now=function(){return Date.now();};
return G;});
sap.ui.predefine('sap/ui/core/date/Islamic',['jquery.sap.global','./UniversalDate'],function(q,U){"use strict";
var I=U.extend("sap.ui.core.date.Islamic",{constructor:function(){var a=arguments;if(a.length>1){a=f(a);}this.oDate=this.createDate(Date,a);this.sCalendarType=sap.ui.core.CalendarType.Islamic;}});
I.UTC=function(){var a=f(arguments);return Date.UTC.apply(Date,a);};
I.now=function(){return Date.now();};
var B=1400,G=1721425.5,c=1948439.5,d=-42521587200000,O=86400000;var C=null;
function t(o){var a=o.year,b=o.month,k=o.day,l,n,r,M,D,L,J;L=0;if((b+1)>2){L=j(a)?-1:-2;}J=(G-1)+(365*(a-1))+Math.floor((a-1)/4)+(-Math.floor((a-1)/100))+Math.floor((a-1)/400)+Math.floor((((367*(b+1))-362)/12)+L+k);J=Math.floor(J)+0.5;D=J-c;M=Math.floor(D/29.530588853);if(M<0){l=Math.floor(M/12)+1;n=M%12;if(n<0){n+=12;}r=D-m(l,n)+1;}else{M++;while(g(M)>D){M--;}l=Math.floor(M/12)+1;n=M%12;r=(D-g(12*(l-1)+n))+1;}return{day:r,month:n,year:l};}
function e(o){var a=o.year,b=o.month,k=o.day,M=a<1?m(a,b):g(12*(a-1)+b),J=k+M+c-1,l=Math.floor(J-0.5)+0.5,D=l-G,Q=Math.floor(D/146097),n=h(D,146097),r=Math.floor(n/36524),s=h(n,36524),u=Math.floor(s/1461),v=h(s,1461),y=Math.floor(v/365),Y=(Q*400)+(r*100)+(u*4)+y,w,x,z,A,E,F,L,H;if(!(r==4||y==4)){Y++;}z=G+(365*(Y-1))+Math.floor((Y-1)/4)-(Math.floor((Y-1)/100))+Math.floor((Y-1)/400);A=l-z;E=(G-1)+(365*(Y-1))+Math.floor((Y-1)/4)-(Math.floor((Y-1)/100))+Math.floor((Y-1)/400)+Math.floor((739/12)+((j(Y)?-1:-2))+1);L=0;if(l<E){L=0;}else{L=j(Y)?1:2;}w=Math.floor((((A+L)*12)+373)/367);F=(G-1)+(365*(Y-1))+Math.floor((Y-1)/4)-(Math.floor((Y-1)/100))+Math.floor((Y-1)/400);H=0;if(w>2){H=j(Y)?-1:-2;}F+=Math.floor((((367*w)-362)/12)+H+1);x=(l-F)+1;return{day:x,month:w-1,year:Y};}
function f(a){var b=Array.prototype.slice.call(a),o,k;o={year:a[0],month:a[1],day:a[2]!==undefined?a[2]:1};k=e(o);b[0]=k.year;b[1]=k.month;b[2]=k.day;return b;}
function i(){var D,o;C={};D=sap.ui.getCore().getConfiguration().getFormatSettings().getLegacyDateFormat();o=sap.ui.getCore().getConfiguration().getFormatSettings().getLegacyDateCalendarCustomizing();o=o||[];if(!D&&!o.length){q.sap.log.info("No calendar customizations.");return;}if((D&&!o.length)||(!D&&o.length)){q.sap.log.warning("There is an inconsistency between customization data ["+JSON.stringify(o)+"] and the date format ["+D+"]. Calendar customization won't be used.");return;}o.forEach(function(E){if(E.dateFormat===D){var a=p(E.gregDate);var b=new Date(Date.UTC(a.year,a.month-1,a.day));var M=b.getTime();var k=(M-d)/O;a=p(E.islamicMonthStart);var l=(a.year-1)*12+a.month-1;C[l]=k;}});q.sap.log.info("Working with date format: ["+D+"] and customization: "+JSON.stringify(o));}
function p(D){return{year:parseInt(D.substr(0,4),10),month:parseInt(D.substr(4,2),10),day:parseInt(D.substr(6,2),10)};}
function g(a){if(!C){i();}var b=C[a];if(!b){var y=Math.floor(a/12)+1;var k=a%12;b=m(y,k);}return b;}
function m(y,a){return Math.ceil(29.5*a)+(y-1)*354+Math.floor((3+11*y)/30.0);}
function h(a,b){return a-(b*Math.floor(a/b));}
function j(y){return!(y%400)||(!(y%4)&&!!(y%100));}
I.prototype._getIslamic=function(){return t({day:this.oDate.getDate(),month:this.oDate.getMonth(),year:this.oDate.getFullYear()});};
I.prototype._setIslamic=function(o){var a=e(o);return this.oDate.setFullYear(a.year,a.month,a.day);};
I.prototype._getUTCIslamic=function(){return t({day:this.oDate.getUTCDate(),month:this.oDate.getUTCMonth(),year:this.oDate.getUTCFullYear()});};
I.prototype._setUTCIslamic=function(o){var a=e(o);return this.oDate.setUTCFullYear(a.year,a.month,a.day);};
I.prototype.getDate=function(D){return this._getIslamic().day;};
I.prototype.getMonth=function(){return this._getIslamic().month;};
I.prototype.getYear=function(){return this._getIslamic().year-B;};
I.prototype.getFullYear=function(){return this._getIslamic().year;};
I.prototype.setDate=function(D){var o=this._getIslamic();o.day=D;return this._setIslamic(o);};
I.prototype.setMonth=function(M,D){var o=this._getIslamic();o.month=M;if(D!==undefined){o.day=D;}return this._setIslamic(o);};
I.prototype.setYear=function(y){var o=this._getIslamic();o.year=y+B;return this._setIslamic(o);};
I.prototype.setFullYear=function(y,M,D){var o=this._getIslamic();o.year=y;if(M!==undefined){o.month=M;}if(D!==undefined){o.day=D;}return this._setIslamic(o);};
I.prototype.getUTCDate=function(D){return this._getUTCIslamic().day;};
I.prototype.getUTCMonth=function(){return this._getUTCIslamic().month;};
I.prototype.getUTCFullYear=function(){return this._getUTCIslamic().year;};
I.prototype.setUTCDate=function(D){var o=this._getUTCIslamic();o.day=D;return this._setUTCIslamic(o);};
I.prototype.setUTCMonth=function(M,D){var o=this._getUTCIslamic();o.month=M;if(D!==undefined){o.day=D;}return this._setUTCIslamic(o);};
I.prototype.setUTCFullYear=function(y,M,D){var o=this._getUTCIslamic();o.year=y;if(M!==undefined){o.month=M;}if(D!==undefined){o.day=D;}return this._setUTCIslamic(o);};
return I;});
sap.ui.predefine('sap/ui/core/date/Japanese',['jquery.sap.global','./UniversalDate'],function(q,U,L){"use strict";
var J=U.extend("sap.ui.core.date.Japanese",{constructor:function(){var A=arguments;if(A.length>1){A=b(A);}this.oDate=this.createDate(Date,A);this.sCalendarType=sap.ui.core.CalendarType.Japanese;}});
J.UTC=function(){var A=b(arguments);return Date.UTC.apply(Date,A);};
J.now=function(){return Date.now();};
function t(g){var e=U.getEraByDate(sap.ui.core.CalendarType.Japanese,g.year,g.month,g.day),E=U.getEraStartDate(sap.ui.core.CalendarType.Japanese,e).year;return{era:e,year:g.year-E+1,month:g.month,day:g.day};}
function a(j){var e=U.getEraStartDate(sap.ui.core.CalendarType.Japanese,j.era).year;return{year:e+j.year-1,month:j.month,day:j.day};}
function b(A){var j,g,e,y=A[0];if(typeof y=="number"){if(y>=100){return A;}else{e=U.getCurrentEra(sap.ui.core.CalendarType.Japanese);y=[e,y];}}else if(!Array.isArray(y)){y=[];}j={era:y[0],year:y[1],month:A[1],day:A[2]!==undefined?A[2]:1};g=a(j);A[0]=g.year;return A;}
J.prototype._getJapanese=function(){var g={year:this.oDate.getFullYear(),month:this.oDate.getMonth(),day:this.oDate.getDate()};return t(g);};
J.prototype._setJapanese=function(j){var g=a(j);return this.oDate.setFullYear(g.year,g.month,g.day);};
J.prototype._getUTCJapanese=function(){var g={year:this.oDate.getUTCFullYear(),month:this.oDate.getUTCMonth(),day:this.oDate.getUTCDate()};return t(g);};
J.prototype._setUTCJapanese=function(j){var g=a(j);return this.oDate.setUTCFullYear(g.year,g.month,g.day);};
J.prototype.getYear=function(){return this._getJapanese().year;};
J.prototype.getFullYear=function(){return this._getJapanese().year;};
J.prototype.getEra=function(){return this._getJapanese().era;};
J.prototype.getUTCFullYear=function(){return this._getUTCJapanese().year;};
J.prototype.getUTCEra=function(){return this._getUTCJapanese().era;};
J.prototype.setYear=function(y){var j=this._getJapanese();j.year=y;return this._setJapanese(j);};
J.prototype.setFullYear=function(y,m,d){var j=this._getJapanese();j.year=y;if(m!==undefined){j.month=m;}if(d!==undefined){j.day=d;}return this._setJapanese(j);};
J.prototype.setEra=function(e,y,m,d){var E=U.getEraStartDate(sap.ui.core.CalendarType.Japanese,e),j=t(E);if(y!==undefined){j.year=y;}if(m!==undefined){j.month=m;}if(d!==undefined){j.day=d;}return this._setJapanese(j);};
J.prototype.setUTCFullYear=function(y,m,d){var j=this._getUTCJapanese();j.year=y;if(m!==undefined){j.month=m;}if(d!==undefined){j.day=d;}return this._setUTCJapanese(j);};
J.prototype.setUTCEra=function(e,y,m,d){var E=U.getEraStartDate(sap.ui.core.CalendarType.Japanese,e),j=t(E);if(y!==undefined){j.year=y;}if(m!==undefined){j.month=m;}if(d!==undefined){j.day=d;}return this._setUTCJapanese(j);};
J.prototype.getWeek=function(){return U.getWeekByDate(this.sCalendarType,this.oDate.getFullYear(),this.getMonth(),this.getDate());};
J.prototype.getUTCWeek=function(){return U.getWeekByDate(this.sCalendarType,this.oDate.getUTCFullYear(),this.getUTCMonth(),this.getUTCDate());};
return J;});
sap.ui.predefine('sap/ui/core/date/Persian',['jquery.sap.global','./UniversalDate'],function(q,U){"use strict";
var P=U.extend("sap.ui.core.date.Persian",{constructor:function(){var a=arguments;if(a.length>1){a=e(a);}this.oDate=this.createDate(Date,a);this.sCalendarType=sap.ui.core.CalendarType.Persian;}});
P.UTC=function(){var a=e(arguments);return Date.UTC.apply(Date,a);};
P.now=function(){return Date.now();};
var B=1300;
function t(G){var j=l(G.year,G.month+1,G.day);return h(j);}
function c(a){var j=g(a.year,a.month+1,a.day);return m(j);}
function e(a){var G=Array.prototype.slice.call(a),b,d;if(typeof a[0]!=="number"||typeof a[1]!=="number"||(a[2]!==undefined&&typeof a[2]!="number")){G[0]=NaN;G[1]=NaN;G[2]=NaN;return G;}b={year:a[0],month:a[1],day:a[2]!==undefined?a[2]:1};d=c(b);G[0]=d.year;G[1]=d.month;G[2]=d.day;return G;}
function f(j){var b=[-61,9,38,199,426,686,756,818,1111,1181,1210,1635,2060,2097,2192,2262,2324,2394,2456,3178],a=b.length,d=j+621,k=-14,r=b[0],s,u,v,w,x,n,i;for(i=1;i<a;i+=1){s=b[i];u=s-r;if(j<s){break;}k=k+o(u,33)*8+o(p(u,33),4);r=s;}n=j-r;k=k+o(n,33)*8+o(p(n,33)+3,4);if(p(u,33)===4&&u-n===4){k+=1;}w=o(d,4)-o((o(d,100)+1)*3,4)-150;x=20+k-w;if(u-n<6){n=n-u+o(u+4,33)*33;}v=p(p(n+1,33)-1,4);if(v===-1){v=4;}return{leap:v,gy:d,march:x};}
function g(j,a,b){while(a<1){a+=12;j--;}while(a>12){a-=12;j++;}var r=f(j);return l(r.gy,3,r.march)+(a-1)*31-o(a,7)*(a-7)+b-1;}
function h(j){var a=m(j).year,b=a-621,r=f(b),d=l(a,3,r.march),i,n,k;k=j-d;if(k>=0){if(k<=185){n=1+o(k,31);i=p(k,31)+1;return{year:b,month:n-1,day:i};}else{k-=186;}}else{b-=1;k+=179;if(r.leap===1){k+=1;}}n=7+o(k,30);i=p(k,30)+1;return{year:b,month:n-1,day:i};}
function l(a,b,i){var d=o((a+o(b-8,6)+100100)*1461,4)+o(153*p(b+9,12)+2,5)+i-34840408;d=d-o(o(a+100100+o(b-8,6),100)*3,4)+752;return d;}
function m(a){var j,i,b,d,k;j=4*a+139361631;j=j+o(o(4*a+183187720,146097)*3,4)*4-3908;i=o(p(j,1461),4)*5+308;b=o(p(i,153),5)+1;d=p(o(i,153),12)+1;k=o(j,1461)-100100+o(8-d,6);return{year:k,month:d-1,day:b};}
function o(a,b){return~~(a/b);}
function p(a,b){return a-~~(a/b)*b;}
P.prototype._getPersian=function(){return t({day:this.oDate.getDate(),month:this.oDate.getMonth(),year:this.oDate.getFullYear()});};
P.prototype._setPersian=function(a){var G=c(a);return this.oDate.setFullYear(G.year,G.month,G.day);};
P.prototype._getUTCPersian=function(){return t({day:this.oDate.getUTCDate(),month:this.oDate.getUTCMonth(),year:this.oDate.getUTCFullYear()});};
P.prototype._setUTCPersian=function(a){var G=c(a);return this.oDate.setUTCFullYear(G.year,G.month,G.day);};
P.prototype.getDate=function(d){return this._getPersian().day;};
P.prototype.getMonth=function(){return this._getPersian().month;};
P.prototype.getYear=function(){return this._getPersian().year-B;};
P.prototype.getFullYear=function(){return this._getPersian().year;};
P.prototype.setDate=function(d){var a=this._getPersian();a.day=d;return this._setPersian(a);};
P.prototype.setMonth=function(M,d){var a=this._getPersian();a.month=M;if(d!==undefined){a.day=d;}return this._setPersian(a);};
P.prototype.setYear=function(y){var a=this._getPersian();a.year=y+B;return this._setPersian(a);};
P.prototype.setFullYear=function(y,M,d){var a=this._getPersian();a.year=y;if(M!==undefined){a.month=M;}if(d!==undefined){a.day=d;}return this._setPersian(a);};
P.prototype.getUTCDate=function(d){return this._getUTCPersian().day;};
P.prototype.getUTCMonth=function(){return this._getUTCPersian().month;};
P.prototype.getUTCFullYear=function(){return this._getUTCPersian().year;};
P.prototype.setUTCDate=function(d){var a=this._getUTCPersian();a.day=d;return this._setUTCPersian(a);};
P.prototype.setUTCMonth=function(M,d){var a=this._getUTCPersian();a.month=M;if(d!==undefined){a.day=d;}return this._setUTCPersian(a);};
P.prototype.setUTCFullYear=function(y,M,d){var a=this._getUTCPersian();a.year=y;if(M!==undefined){a.month=M;}if(d!==undefined){a.day=d;}return this._setUTCPersian(a);};
return P;});
sap.ui.predefine('sap/ui/core/date/UniversalDate',['sap/ui/base/Object','sap/ui/core/LocaleData'],function(B,L){"use strict";
var U=B.extend("sap.ui.core.date.UniversalDate",{constructor:function(){var b=U.getClass();return this.createDate(b,arguments);}});
U.UTC=function(){var b=U.getClass();return b.UTC.apply(b,arguments);};
U.now=function(){return Date.now();};
U.prototype.createDate=function(b,A){switch(A.length){case 0:return new b();case 1:return new b(A[0]);case 2:return new b(A[0],A[1]);case 3:return new b(A[0],A[1],A[2]);case 4:return new b(A[0],A[1],A[2],A[3]);case 5:return new b(A[0],A[1],A[2],A[3],A[4]);case 6:return new b(A[0],A[1],A[2],A[3],A[4],A[5]);case 7:return new b(A[0],A[1],A[2],A[3],A[4],A[5],A[6]);}};
U.getInstance=function(d,C){var b,i;if(d instanceof U){d=d.getJSDate();}if(!C){C=sap.ui.getCore().getConfiguration().getCalendarType();}b=U.getClass(C);i=Object.create(b.prototype);i.oDate=d;i.sCalendarType=C;return i;};
U.getClass=function(C){if(!C){C=sap.ui.getCore().getConfiguration().getCalendarType();}return sap.ui.requireSync("sap/ui/core/date/"+C);};
["getDate","getMonth","getFullYear","getYear","getDay","getHours","getMinutes","getSeconds","getMilliseconds","getUTCDate","getUTCMonth","getUTCFullYear","getUTCDay","getUTCHours","getUTCMinutes","getUTCSeconds","getUTCMilliseconds","getTime","valueOf","getTimezoneOffset","toString","toDateString","setDate","setFullYear","setYear","setMonth","setHours","setMinutes","setSeconds","setMilliseconds","setUTCDate","setUTCFullYear","setUTCMonth","setUTCHours","setUTCMinutes","setUTCSeconds","setUTCMilliseconds"].forEach(function(n){U.prototype[n]=function(){return this.oDate[n].apply(this.oDate,arguments);};});
U.prototype.getJSDate=function(){return this.oDate;};
U.prototype.getCalendarType=function(){return this.sCalendarType;};
U.prototype.getEra=function(){return U.getEraByDate(this.sCalendarType,this.oDate.getFullYear(),this.oDate.getMonth(),this.oDate.getDate());};
U.prototype.setEra=function(E){};
U.prototype.getUTCEra=function(){return U.getEraByDate(this.sCalendarType,this.oDate.getUTCFullYear(),this.oDate.getUTCMonth(),this.oDate.getUTCDate());};
U.prototype.setUTCEra=function(E){};
U.prototype.getWeek=function(){return U.getWeekByDate(this.sCalendarType,this.getFullYear(),this.getMonth(),this.getDate());};
U.prototype.setWeek=function(w){var d=U.getFirstDateOfWeek(this.sCalendarType,w.year||this.getFullYear(),w.week);this.setFullYear(d.year,d.month,d.day);};
U.prototype.getUTCWeek=function(){return U.getWeekByDate(this.sCalendarType,this.getUTCFullYear(),this.getUTCMonth(),this.getUTCDate());};
U.prototype.setUTCWeek=function(w){var d=U.getFirstDateOfWeek(this.sCalendarType,w.year||this.getFullYear(),w.week);this.setUTCFullYear(d.year,d.month,d.day);};
U.prototype.getQuarter=function(){return Math.floor((this.getMonth()/3));};
U.prototype.getUTCQuarter=function(){return Math.floor((this.getUTCMonth()/3));};
U.prototype.getDayPeriod=function(){if(this.getHours()<12){return 0;}else{return 1;}};
U.prototype.getUTCDayPeriod=function(){if(this.getUTCHours()<12){return 0;}else{return 1;}};
U.prototype.getTimezoneShort=function(){if(this.oDate.getTimezoneShort){return this.oDate.getTimezoneShort();}};
U.prototype.getTimezoneLong=function(){if(this.oDate.getTimezoneLong){return this.oDate.getTimezoneLong();}};
var m=7*24*60*60*1000;
U.getWeekByDate=function(C,y,M,d){var l=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale(),b=this.getClass(C),f=g(b,y),D=new b(b.UTC(y,M,d)),w,i,n,o,N;if(l.getRegion()==="US"){w=c(f,D);}else{i=y-1;n=y+1;o=g(b,i);N=g(b,n);if(D>=N){y=n;w=0;}else if(D<f){y=i;w=c(o,D);}else{w=c(f,D);}}return{year:y,week:w};};
U.getFirstDateOfWeek=function(C,y,w){var l=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale(),b=this.getClass(C),f=g(b,y),d=new b(f.valueOf()+w*m);if(l.getRegion()==="US"&&w===0&&f.getUTCFullYear()<y){return{year:y,month:0,day:1};}return{year:d.getUTCFullYear(),month:d.getUTCMonth(),day:d.getUTCDate()};};
function g(b,y){var l=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale(),o=L.getInstance(l),M=o.getMinimalDaysInFirstWeek(),f=o.getFirstDayOfWeek(),F=new b(b.UTC(y,0,1)),d=7;while(F.getUTCDay()!==f){F.setUTCDate(F.getUTCDate()-1);d--;}if(d<M){F.setUTCDate(F.getUTCDate()+7);}return F;}
function c(f,t){return Math.floor((t.valueOf()-f.valueOf())/m);}
var e={};
U.getEraByDate=function(C,y,M,d){var E=a(C),t=new Date(0).setUTCFullYear(y,M,d),o;for(var i=E.length-1;i>=0;i--){o=E[i];if(!o){continue;}if(o._start&&t>=o._startInfo.timestamp){return i;}if(o._end&&t<o._endInfo.timestamp){return i;}}};
U.getCurrentEra=function(C){var n=new Date();return this.getEraByDate(C,n.getFullYear(),n.getMonth(),n.getDate());};
U.getEraStartDate=function(C,E){var b=a(C),o=b[E]||b[0];if(o._start){return o._startInfo;}};
function a(C){var l=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale(),o=L.getInstance(l),E=e[C];if(!E){var E=o.getEraDates(C);if(!E[0]){E[0]={_start:"1-1-1"};}for(var i=0;i<E.length;i++){var b=E[i];if(!b){continue;}if(b._start){b._startInfo=p(b._start);}if(b._end){b._endInfo=p(b._end);}}e[C]=E;}return E;}
function p(d){var P=d.split("-"),y,M,D;if(P[0]==""){y=-parseInt(P[1],10);M=parseInt(P[2],10)-1;D=parseInt(P[3],10);}else{y=parseInt(P[0],10);M=parseInt(P[1],10)-1;D=parseInt(P[2],10);}return{timestamp:new Date(0).setUTCFullYear(y,M,D),year:y,month:M,day:D};}
return U;});
sap.ui.predefine('sap/ui/core/delegate/ItemNavigation',['jquery.sap.global','sap/ui/base/EventProvider'],function(q,E){"use strict";
var I=E.extend("sap.ui.core.delegate.ItemNavigation",{constructor:function(d,i,n){E.apply(this);this.oDomRef=null;if(d){this.setRootDomRef(d);}this.aItemDomRefs=[];if(i){this.setItemDomRefs(i);}this.iTabIndex=-1;this.iActiveTabIndex=!!n?-1:0;this.iFocusedIndex=-1;this.iSelectedIndex=-1;this.bCycling=true;this.bTableMode=false;this.iPageSize=-1;this._bMouseDownHappened=false;this.oDisabledModifiers={sapend:["alt","shift"],saphome:["alt","shift"]};}});
I.Events={BeforeFocus:"BeforeFocus",AfterFocus:"AfterFocus",BorderReached:"BorderReached",FocusAgain:"FocusAgain",FocusLeave:"FocusLeave"};
I.prototype.setDisabledModifiers=function(d){this.oDisabledModifiers=d;return this;};
I.prototype.getDisabledModifiers=function(d){return this.oDisabledModifiers;};
I.prototype.hasDisabledModifier=function(e){var d=this.oDisabledModifiers[e.type.replace("modifiers","")];if(Array.isArray(d)){for(var i=0;i<d.length;i++){if(e[d[i]+"Key"]){return true;}}}return false;};
I.prototype.setRootDomRef=function(d){this.oDomRef=d;if(!q(this.oDomRef).data("sap.INItem")){if(this.iFocusedIndex>=0){q(this.oDomRef).attr("tabIndex",this.iTabIndex);}else{q(this.oDomRef).attr("tabIndex",this.iActiveTabIndex);}}q(this.oDomRef).data("sap.INRoot",this);return this;};
I.prototype.getRootDomRef=function(){return this.oDomRef;};
I.prototype.getItemDomRefs=function(){return this.aItemDomRefs;};
I.prototype.setItemDomRefs=function(a){this.aItemDomRefs=a;if(this.iFocusedIndex>a.length-1){this.iFocusedIndex=a.length-1;}for(var i=0;i<this.aItemDomRefs.length;i++){if(this.aItemDomRefs[i]){var $=q(this.aItemDomRefs[i]);if(i==this.iFocusedIndex&&!$.data("sap.INRoot")){$.attr("tabIndex",this.iActiveTabIndex);}else if($.attr("tabindex")=="0"){$.attr("tabIndex",-1);}$.data("sap.INItem",true);$.data("sap.InNavArea",true);if($.data("sap.INRoot")&&i!=this.iFocusedIndex){$.data("sap.INRoot").setNestedItemsTabindex();}}}return this;};
I.prototype.setItemsTabindex=function(){for(var i=0;i<this.aItemDomRefs.length;i++){if(this.aItemDomRefs[i]){var $=q(this.aItemDomRefs[i]);if($.is(":sapFocusable")){if(i==this.iFocusedIndex&&!$.data("sap.INRoot")){$.attr("tabIndex",this.iActiveTabIndex);}else{$.attr("tabIndex",-1);}}}}return this;};
I.prototype.setNestedItemsTabindex=function(){if(q(this.oDomRef).data("sap.INItem")){for(var i=0;i<this.aItemDomRefs.length;i++){if(this.aItemDomRefs[i]&&q(this.aItemDomRefs[i]).attr("tabindex")=="0"){q(this.aItemDomRefs[i]).attr("tabIndex",-1);}}}return this;};
I.prototype.destroy=function(){if(this.oDomRef){q(this.oDomRef).removeData("sap.INRoot");this.oDomRef=null;}if(this.aItemDomRefs){for(var i=0;i<this.aItemDomRefs.length;i++){if(this.aItemDomRefs[i]){q(this.aItemDomRefs[i]).removeData("sap.INItem");q(this.aItemDomRefs[i]).removeData("sap.InNavArea");}}this.aItemDomRefs=null;}this._bItemTabIndex=undefined;this.iFocusedIndex=-1;};
I.prototype.setCycling=function(c){this.bCycling=c;return this;};
I.prototype.setTableMode=function(t,T){this.bTableMode=t;if(this.oConfiguration===undefined){this.oConfiguration=sap.ui.getCore().getConfiguration();}this.bTableList=t?T:false;return this;};
I.prototype.setPageSize=function(p){this.iPageSize=p;return this;};
I.prototype.setSelectedIndex=function(i){this.iSelectedIndex=i;return this;};
I.prototype.setColumns=function(c,n){this.iColumns=c;this.bNoColumnChange=n;return this;};
I.prototype.setHomeEndColumnMode=function(s,c){this._bStayInRow=s;this._bCtrlEnabled=c;return this;};
I.prototype.focusItem=function(i,e){q.sap.log.info("FocusItem: "+i+" iFocusedIndex: "+this.iFocusedIndex,"focusItem","ItemNavigation");if(i==this.iFocusedIndex&&this.aItemDomRefs[this.iFocusedIndex]==document.activeElement){this.fireEvent(I.Events.FocusAgain,{index:i,event:e});return;}if(!this.aItemDomRefs[i]||!q(this.aItemDomRefs[i]).is(":sapFocusable")){if(this.bTableMode){var c=i%this.iColumns;var o=i;if(e&&e.keyCode==q.sap.KeyCodes.ARROW_RIGHT){if(c<this.iColumns-1){i+=this.oConfiguration.getRTL()?-1:1;}}else if(e&&e.keyCode==q.sap.KeyCodes.ARROW_LEFT){if(c>1){i-=this.oConfiguration.getRTL()?-1:1;}}else{if(c>1){i-=1;}}if(i!=o){this.focusItem(i,e);}}return;}this.fireEvent(I.Events.BeforeFocus,{index:i,event:e});this.setFocusedIndex(i);this.bISetFocus=true;if(e&&q(this.aItemDomRefs[this.iFocusedIndex]).data("sap.INRoot")){var a=q(this.aItemDomRefs[this.iFocusedIndex]).data("sap.INRoot");a._sFocusEvent=e.type;}q.sap.log.info("Set Focus on ID: "+this.aItemDomRefs[this.iFocusedIndex].id,"focusItem","ItemNavigation");q.sap.focus(this.aItemDomRefs[this.iFocusedIndex]);this.fireEvent(I.Events.AfterFocus,{index:i,event:e});};
I.prototype.setFocusedIndex=function(i){var $;if(this.aItemDomRefs.length<0){this.iFocusedIndex=-1;return this;}if(i<0){i=0;}if(i>this.aItemDomRefs.length-1){i=this.aItemDomRefs.length-1;}q(this.oDomRef).attr("tabIndex",this.iTabIndex);if(this.iFocusedIndex!==-1&&this.aItemDomRefs.length>this.iFocusedIndex){q(this.aItemDomRefs[this.iFocusedIndex]).attr("tabIndex",-1);$=q(this.aItemDomRefs[this.iFocusedIndex]);if($.data("sap.INRoot")&&i!=this.iFocusedIndex){q($.data("sap.INRoot").aItemDomRefs[$.data("sap.INRoot").iFocusedIndex]).attr("tabIndex",-1);}}this.iFocusedIndex=i;var f=this.aItemDomRefs[this.iFocusedIndex];$=q(this.aItemDomRefs[this.iFocusedIndex]);if(!$.data("sap.INRoot")){q(f).attr("tabIndex",this.iActiveTabIndex);}return this;};
I.prototype.getFocusedDomRef=function(){return this.aItemDomRefs[this.iFocusedIndex];};
I.prototype.getFocusedIndex=function(){return this.iFocusedIndex;};
I.prototype.onfocusin=function(e){var s=e.target;var i=0;if(s==this.oDomRef){if(!this._bItemTabIndex){this.setItemsTabindex();this._bItemTabIndex=true;}if(this._bMouseDownHappened){return;}var a;if(q(this.oDomRef).data("sap.INItem")&&this._sFocusEvent&&!q(this.oDomRef).data("sap.InNavArea")){switch(this._sFocusEvent){case"sapnext":a=0;break;case"sapprevious":a=this.aItemDomRefs.length-1;break;default:if(this.iSelectedIndex!=-1){a=this.iSelectedIndex;}else if(this.iFocusedIndex!=-1){a=this.iFocusedIndex;}else{a=0;}break;}this._sFocusEvent=undefined;}else{if(this.iSelectedIndex!=-1){a=this.iSelectedIndex;}else if(this.iFocusedIndex!=-1){a=this.iFocusedIndex;}else{a=0;}}this.focusItem(a,e);if(this.iFocusedIndex==-1){for(i=a+1;i<this.aItemDomRefs.length;i++){this.focusItem(i,e);if(this.iFocusedIndex==i){break;}}if(this.iFocusedIndex==-1&&a>0){for(i=a-1;i>=0;i--){this.focusItem(i,e);if(this.iFocusedIndex==i){break;}}}}e.preventDefault();e.stopPropagation();}else if(!this.bISetFocus){if(this.aItemDomRefs&&e.target!=this.aItemDomRefs[this.iFocusedIndex]){for(i=0;i<this.aItemDomRefs.length;i++){if(e.target==this.aItemDomRefs[i]){this.focusItem(i,e);break;}}}else{this.fireEvent(I.Events.AfterFocus,{index:this.iFocusedIndex,event:e});}}this.bISetFocus=false;};
I.prototype.onsapfocusleave=function(e){if(!e.relatedControlId||!q.sap.containsOrEquals(this.oDomRef,sap.ui.getCore().byId(e.relatedControlId).getFocusDomRef())){var i;if(this.iSelectedIndex!=-1){i=this.iSelectedIndex;}else if(this.iFocusedIndex!=-1){i=this.iFocusedIndex;}else{i=0;}this.setFocusedIndex(i);var d;if(q(this.oDomRef).data("sap.INItem")){var p;d=q(this.oDomRef);while(!p){d=d.parent();if(d.data("sap.INRoot")){p=d.get(0);}}if(!e.relatedControlId||q.sap.containsOrEquals(p,sap.ui.getCore().byId(e.relatedControlId).getFocusDomRef())){q(this.aItemDomRefs[this.iFocusedIndex]).attr("tabIndex",-1);}}d=q(this.oDomRef);if(d.data("sap.InNavArea")===false){d.data("sap.InNavArea",true);}this.fireEvent(I.Events.FocusLeave,{index:i,event:e});}};
I.prototype.onmousedown=function(e){var s=e.target;var c=function(d,o){var f=false;var C=q(d);while(!C.is(":sapFocusable")&&C.get(0)!=o){C=C.parent();}if(C.get(0)!=o){f=true;}return f;};if(q.sap.containsOrEquals(this.oDomRef,s)){for(var i=0;i<this.aItemDomRefs.length;i++){var o=this.aItemDomRefs[i];if(q.sap.containsOrEquals(o,s)){if(!this.bTableMode){this.focusItem(i,e);}else{if(o===s||!c(s,o)){this.focusItem(i,e);}}return;}}if(s==this.oDomRef){this._bMouseDownHappened=true;var t=this;window.setTimeout(function(){t._bMouseDownHappened=false;},20);}}};
I.prototype.onsapnext=function(e){if(!q.sap.containsOrEquals(this.oDomRef,e.target)){return;}if(q(this.oDomRef).data("sap.InNavArea")){return;}if(this.bTableMode&&this.aItemDomRefs.indexOf(e.target)===-1){return;}var i=this.iFocusedIndex,f=true,b=false;if(i>-1){if(this.bTableMode){var r=this.aItemDomRefs.length/this.iColumns,R=Math.floor(i/this.iColumns),c=i%this.iColumns;if(e.keyCode==q.sap.KeyCodes.ARROW_DOWN){if(R<r-1){i+=this.iColumns;}}else{if(c<this.iColumns-1){i+=1;}}}else{do{if(this.iColumns>1&&e.keyCode==q.sap.KeyCodes.ARROW_DOWN){if((i+this.iColumns)>=this.aItemDomRefs.length){if(!this.bNoColumnChange){if((i%this.iColumns)<(this.iColumns-1)){i=(i%this.iColumns)+1;}else if(this.bCycling){i=0;}}else{i=this.iFocusedIndex;b=true;}}else{i=i+this.iColumns;}}else{if(i==this.aItemDomRefs.length-1){if(q(this.oDomRef).data("sap.INItem")){return;}else if(this.bCycling){i=0;}else{i=this.iFocusedIndex;b=true;}}else{i++;}}if(i===this.iFocusedIndex){if(f){f=false;}else{throw new Error("ItemNavigation has no visible/existing items and is hence unable to select the next one");}}}while(!this.aItemDomRefs[i]||!q(this.aItemDomRefs[i]).is(":sapFocusable"));}this.focusItem(i,e);if(b){this.fireEvent(I.Events.BorderReached,{index:i,event:e});}e.preventDefault();e.stopPropagation();}};
I.prototype.onsapnextmodifiers=function(e){if(this.hasDisabledModifier(e)){return;}this.onsapnext(e);};
I.prototype.onsapprevious=function(e){if(!q.sap.containsOrEquals(this.oDomRef,e.target)){return;}if(q(this.oDomRef).data("sap.InNavArea")){return;}if(this.bTableMode&&this.aItemDomRefs.indexOf(e.target)===-1){return;}var i=this.iFocusedIndex,f=true,b=false;var c=0;if(i>-1){if(this.bTableMode){var r=Math.floor(i/this.iColumns);c=i%this.iColumns;if(e.keyCode==q.sap.KeyCodes.ARROW_UP){if(r>0){i-=this.iColumns;}}else{if(c>0){i-=1;}}}else{do{if(this.iColumns>1&&e.keyCode==q.sap.KeyCodes.ARROW_UP){if((i-this.iColumns)<0){if(!this.bNoColumnChange){c=0;if((i%this.iColumns)>0){c=(i%this.iColumns)-1;}else if(this.bCycling){c=Math.min(this.iColumns-1,this.aItemDomRefs.length-1);}if(i===0&&c===0){i=0;}else{var R=Math.ceil(this.aItemDomRefs.length/this.iColumns);i=c+((R-1)*this.iColumns);if(i>=this.aItemDomRefs.length){i=i-this.iColumns;}}}else{i=this.iFocusedIndex;b=true;}}else{i=i-this.iColumns;}}else{if(i==0){if(q(this.oDomRef).data("sap.INItem")){return;}else if(this.bCycling){i=this.aItemDomRefs.length-1;}else{i=this.iFocusedIndex;b=true;}}else{i--;}}if(i==this.iFocusedIndex){if(f){f=false;}else{throw new Error("ItemNavigation has no visible/existing items and is hence unable to select the previous one");}}}while(!this.aItemDomRefs[i]||!q(this.aItemDomRefs[i]).is(":sapFocusable"));}this.focusItem(i,e);if(b){this.fireEvent(I.Events.BorderReached,{index:i,event:e});}e.preventDefault();e.stopPropagation();}};
I.prototype.onsappreviousmodifiers=function(e){if(this.hasDisabledModifier(e)){return;}this.onsapprevious(e);};
I.prototype.onsappageup=function(e){if(!q.sap.containsOrEquals(this.oDomRef,e.target)){return;}if(this.bTableMode&&this.aItemDomRefs.indexOf(e.target)===-1){return;}var i=0;var b=false;if(this.iPageSize>0){i=this.iFocusedIndex;if(i>-1){i=i-this.iPageSize;while(i>0&&!q(this.aItemDomRefs[i]).is(":sapFocusable")){i--;}if(i<0){if(!this.bNoColumnChange){i=0;}else{i=this.iFocusedIndex;b=true;}}this.focusItem(i,e);}}else if(this.bTableMode){i=this.iFocusedIndex%this.iColumns;this.focusItem(i,e);}if(b){this.fireEvent(I.Events.BorderReached,{index:i,event:e});}e.preventDefault();e.stopPropagation();};
I.prototype.onsappagedown=function(e){if(!q.sap.containsOrEquals(this.oDomRef,e.target)){return;}if(this.bTableMode&&this.aItemDomRefs.indexOf(e.target)===-1){return;}var i=0;var b=false;if(this.iPageSize>0){i=this.iFocusedIndex;if(i>-1){i=i+this.iPageSize;while(i<this.aItemDomRefs.length-1&&!q(this.aItemDomRefs[i]).is(":sapFocusable")){i++;}if(i>this.aItemDomRefs.length-1){if(!this.bNoColumnChange){i=this.aItemDomRefs.length-1;}else{i=this.iFocusedIndex;b=true;}}this.focusItem(i,e);}}else if(this.bTableMode){var r=this.aItemDomRefs.length/this.iColumns,c=this.iFocusedIndex%this.iColumns;i=(r-1)*this.iColumns+c;this.focusItem(i,e);}if(b){this.fireEvent(I.Events.BorderReached,{index:i,event:e});}e.preventDefault();e.stopPropagation();};
I.prototype.onsaphome=function(e){if(!q.sap.containsOrEquals(this.oDomRef,e.target)){return;}if(this.bTableMode&&this.aItemDomRefs.indexOf(e.target)===-1){return;}var i=0;var r=0;if(this.bTableMode){if(!this.bTableList&&!(e.metaKey||e.ctrlKey)){r=Math.floor(this.iFocusedIndex/this.iColumns);i=r*this.iColumns;}}else{if(!!(e.metaKey||e.ctrlKey)&&!this._bCtrlEnabled){return;}if(this._bStayInRow&&!(this._bCtrlEnabled&&(e.metaKey||e.ctrlKey))&&this.iColumns>0){r=Math.floor(this.iFocusedIndex/this.iColumns);i=r*this.iColumns;}else{while(!this.aItemDomRefs[i]||!q(this.aItemDomRefs[i]).is(":sapFocusable")){i++;if(i==this.aItemDomRefs.length){return;}}}}this.focusItem(i,e);e.preventDefault();e.stopPropagation();};
I.prototype.onsaphomemodifiers=function(e){if(this.hasDisabledModifier(e)){return;}this.onsaphome(e);};
I.prototype.onsapend=function(e){if(!q.sap.containsOrEquals(this.oDomRef,e.target)){return;}if(this.bTableMode&&this.aItemDomRefs.indexOf(e.target)===-1){return;}var i=this.aItemDomRefs.length-1;var r=0;if(this.bTableMode){if(!this.bTableList&&!(e.metaKey||e.ctrlKey)){r=Math.floor(this.iFocusedIndex/this.iColumns);i=r*this.iColumns+this.iColumns-1;}}else{if(!!(e.metaKey||e.ctrlKey)&&!this._bCtrlEnabled){return;}if(this._bStayInRow&&!(this._bCtrlEnabled&&(e.metaKey||e.ctrlKey))&&this.iColumns>0){r=Math.floor(this.iFocusedIndex/this.iColumns);i=(r+1)*this.iColumns-1;if(i>=this.aItemDomRefs.length){i=this.aItemDomRefs.length-1;}}else{while(!this.aItemDomRefs[i]||!q(this.aItemDomRefs[i]).is(":sapFocusable")){i--;if(i<0){return;}}}}this.focusItem(i,e);e.preventDefault();e.stopPropagation();};
I.prototype.onsapendmodifiers=function(e){if(this.hasDisabledModifier(e)){return;}this.onsapend(e);};
I.prototype.setTabIndex0=function(){this.iTabIndex=0;this.iActiveTabIndex=0;};
I.prototype.onkeyup=function(e){if(e.keyCode==q.sap.KeyCodes.F2){var d=q(this.oDomRef);if(d.data("sap.InNavArea")){d.data("sap.InNavArea",false);}else if(d.data("sap.InNavArea")===false){d.data("sap.InNavArea",true);}e.preventDefault();e.stopPropagation();}};
return I;});
sap.ui.predefine('sap/ui/core/delegate/ScrollEnablement',['jquery.sap.global','sap/ui/Device','sap/ui/base/Object','sap/ui/core/ResizeHandler'],function(q,D,B,R){"use strict";var $=q;
var S=B.extend("sap.ui.core.delegate.ScrollEnablement",{
constructor:function(c,s,C){B.apply(this);this._oControl=c;this._oControl.addDelegate(this);this._sContentId=s;this._sContainerId=C.scrollContainerId;this._bHorizontal=!!C.horizontal;this._bVertical=!!C.vertical;this._scrollX=0;this._scrollY=0;this._scrollCoef=0.9;i(this);if(this._init){this._init.apply(this,arguments);}},
setHorizontal:function(h){this._bHorizontal=!!h;this._setOverflow&&this._setOverflow();},
setVertical:function(v){this._bVertical=!!v;this._setOverflow&&this._setOverflow();},
getHorizontal:function(){return this._bHorizontal;},
getVertical:function(){return this._bVertical;},
setBounce:function(b){},
setPullDown:function(c){this._oPullDown=c;return this;},
setGrowingList:function(s,a){this._fnScrollLoadCallback=s;this._sScrollLoadDirection=a;return this;},
setIconTabBar:function(I,s,f){this._oIconTabBar=I;this._fnScrollEndCallback=q.proxy(s,I);this._fnScrollStartCallback=q.proxy(f,I);return this;},
scrollTo:function(x,y,t){this._scrollX=x;this._scrollY=y;this._scrollTo(x,y,t);return this;},
getChildPosition:function(e){var E=e instanceof q?e:$(e),o=E.position(),O=E.offsetParent(),a;while(!O.is(this._$Container)){a=O.position();o.top+=a.top;o.left+=a.left;O=O.offsetParent();}return o;},
scrollToElement:function(e,t){if(!this._$Container[0].contains(e)||e.style.display==="none"||e.offsetParent.nodeName.toUpperCase()==="HTML"){return this;}var E=$(e),s=this.getChildPosition(E),l=this.getScrollLeft()+s.left,T=this.getScrollTop()+s.top;if(this._bFlipX){l=this.getScrollLeft()-(s.left-this._$Container.width())-E.width();}this._scrollTo(l,T,t);return this;},
destroy:function(){if(this._exit){this._exit();}if(this._oControl){this._oControl.removeDelegate(this);this._oControl=undefined;}},
refresh:function(){if(this._refresh){this._refresh();}},
_useDefaultScroll:function(t){return t.isContentEditable;},
onkeydown:function(e){if(this._useDefaultScroll(e.target)){return;}var c=this._$Container[0];if(e.altKey&&this.getHorizontal()){switch(e.keyCode){case q.sap.KeyCodes.PAGE_UP:this._customScrollTo(this._scrollX-c.clientWidth,this._scrollY,e);break;case q.sap.KeyCodes.PAGE_DOWN:this._customScrollTo(this._scrollX+c.clientWidth,this._scrollY,e);break;}}if(e.ctrlKey){switch(e.keyCode){case q.sap.KeyCodes.ARROW_UP:if(this.getVertical()){this._customScrollTo(this._scrollX,this._scrollY-c.clientHeight*this._scrollCoef,e);}break;case q.sap.KeyCodes.ARROW_DOWN:if(this.getVertical()){this._customScrollTo(this._scrollX,this._scrollY+c.clientHeight*this._scrollCoef,e);}break;case q.sap.KeyCodes.ARROW_LEFT:if(this.getHorizontal()){this._customScrollTo(this._scrollX-c.clientWidth,this._scrollY,e);}break;case q.sap.KeyCodes.ARROW_RIGHT:if(this.getHorizontal()){this._customScrollTo(this._scrollX+c.clientWidth,this._scrollY,e);}break;case q.sap.KeyCodes.HOME:if(this.getHorizontal()){this._customScrollTo(0,this._scrollY,e);}if(this.getVertical()){this._customScrollTo(this._scrollX,0,e);}break;case q.sap.KeyCodes.END:var l=c.scrollWidth-c.clientWidth;var t=c.scrollHeight-c.clientHeight;if(!this.getHorizontal()){t=this._scrollY;}if(!this.getVertical()){l=this._scrollX;}this._customScrollTo(l,t,e);break;}}},
_customScrollTo:function(l,t,e){var N=e.target.nodeName;if(N!="INPUT"&&N!="TEXTAREA"){e.preventDefault();e.setMarked();this._scrollTo(l,t);}}
});
var n={getScrollTop:function(){return this._scrollY||0;},getScrollLeft:function(){return this._scrollX||0;},getScrollHeight:function(){var c=this._$Container;return(c&&c[0])?c[0].scrollHeight:0;},getMaxScrollTop:function(){var c=this._$Container;return(c&&c[0])?c[0].scrollHeight-c[0].clientHeight:-1;},_cleanup:function(){if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}},_setOverflow:function(){var c=this._$Container;if(!c||!c[0]){return;}if(D.os.ios||D.os.blackberry){c.css("overflow-x",this._bHorizontal&&!this._bDragScroll?"scroll":"hidden").css("overflow-y",this._bVertical&&!this._bDragScroll?"scroll":"hidden").css("-webkit-overflow-scrolling","touch");}else{c.css("overflow-x",this._bHorizontal&&!this._bDragScroll?"auto":"hidden").css("overflow-y",this._bVertical&&!this._bDragScroll?"auto":"hidden");}},_refresh:function(){var c=this._$Container;if(!(c&&c.length)){return;}if(this._oPullDown&&this._oPullDown._bTouchMode){var d=this._oPullDown.getDomRef();if(d){d.style.marginTop=this._oPullDown._iState==2?"":"-"+d.offsetHeight+"px";}}if(c.scrollTop()!=this._scrollY){c.scrollTop(this._scrollY);}if(!(this._oPullDown&&this._oPullDown._bTouchMode)&&!this._fnScrollLoadCallback&&!D.browser.msie){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}},_onScroll:function(){var c=this._$Container,s=c.scrollTop(),v=s-this._scrollY;q.sap.interaction.notifyStepStart(this._oControl);this._scrollX=c.scrollLeft();this._scrollY=s;if(this._fnScrollLoadCallback){if(this._sScrollLoadDirection=="Upwards"){if(v<0&&s<10){this._fnScrollLoadCallback();}}else if(v>=0&&c[0].scrollHeight-s-c[0].clientHeight<100){this._fnScrollLoadCallback();}}if(this._oIconTabBar&&this._fnScrollEndCallback){this._fnScrollEndCallback();}},_onStart:function(e){var c=this._$Container[0];if(!c){return;}this._iLastTouchMoveTime=0;this._bDoDrag=this._bDragScroll||D.os.windows_phone&&/(INPUT|TEXTAREA)/i.test(document.activeElement.tagName);if(!this._scrollable){this._scrollable={};}this._scrollable.vertical=this._bVertical&&c.scrollHeight>c.clientHeight;this._scrollable.horizontal=this._bHorizontal&&c.scrollWidth>c.clientWidth;var p=e.touches?e.touches[0]:e;this._iX=p.pageX;this._iY=p.pageY;if(this._oIOSScroll){if(!this._scrollable.vertical){this._oIOSScroll.iTopDown=0;}else if(c.scrollTop===0){this._oIOSScroll.iTopDown=1;}else if(c.scrollTop===c.scrollHeight-c.clientHeight){this._oIOSScroll.iTopDown=-1;}else{this._oIOSScroll.iTopDown=0;}}this._bPullDown=false;this._iDirection="";},_onTouchMove:function(e){var c=this._$Container[0];var p=e.touches?e.touches[0]:e;var d=p.pageX-this._iX;var a=p.pageY-this._iY;if(this._iDirection==""){if(d!=0||a!=0){this._iDirection=Math.abs(a)>Math.abs(d)?"v":"h";}if(this._oPullDown&&this._oPullDown._bTouchMode&&this._iDirection=="v"&&c.scrollTop<=1){if(a>Math.abs(d)){this._bPullDown=true;}}}if(this._oIOSScroll&&this._oIOSScroll.iTopDown&&a!=0){if(a*this._oIOSScroll.iTopDown>0){this._bDoDrag=true;}}if(this._bPullDown===true){var b=this._oPullDown.getDomRef();var t=e.touches[0].pageY-this._iY-b.offsetHeight;if(t>20){t=20;}b.style.marginTop=t+"px";this._oPullDown.doPull(t);e.preventDefault();this._bDoDrag=false;}if(this._bDoDrag){var s=c.scrollLeft,f=c.scrollTop;if(this._bHorizontal){if(this._bFlipX){c.scrollLeft=s-this._iX+p.pageX;}else{c.scrollLeft=s+this._iX-p.pageX;}}if(this._bVertical){c.scrollTop=f+this._iY-p.pageY;}if((c.scrollLeft!=s)||(c.scrollTop!=f)){e.setMarked&&e.setMarked();e.preventDefault();}this._iX=p.pageX;this._iY=p.pageY;return;}if(D.os.blackberry){if(this._iLastTouchMoveTime&&e.timeStamp-this._iLastTouchMoveTime<100){e.stopPropagation();}else{this._iLastTouchMoveTime=e.timeStamp;}}if(!this._oIOSScroll||this._scrollable.vertical||this._scrollable.horizontal&&this._iDirection=="h"){e.setMarked&&e.setMarked();}},_onEnd:function(e){q.sap.interaction.notifyEventStart(e);if(this._oPullDown&&this._oPullDown._bTouchMode){this._oPullDown.doScrollEnd();this._refresh();}if(this._bDragScroll&&this._iDirection){e.setMarked&&e.setMarked();}},_onMouseDown:function(e){if(this._bDragScroll&&e.button==0){this._bScrolling=true;this._onStart(e);}},_onMouseMove:function(E){if(this._bScrolling){var e=E.originalEvent||E;var b=e.buttons||e.which;if(b==1||E.pressure){var c=this._$Container[0];if(this._bHorizontal){if(this._bFlipX){c.scrollLeft=c.scrollLeft-this._iX+E.pageX;}else{c.scrollLeft=c.scrollLeft+this._iX-E.pageX;}}if(this._bVertical){c.scrollTop=c.scrollTop+this._iY-E.pageY;}this._iX=E.pageX;this._iY=E.pageY;}}},_onMouseUp:function(){if(this._bScrolling){this._bScrolling=false;this._onEnd();}},onBeforeRendering:function(){if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}var c=this._$Container;if(c){if(c.height()>0){this._scrollX=c.scrollLeft();this._scrollY=c.scrollTop();}c.off();}},onAfterRendering:function(){var c=this._$Container=this._sContainerId?$.sap.byId(this._sContainerId):$.sap.byId(this._sContentId).parent();var _=q.proxy(this._refresh,this);var e=c.is(":visible");this._setOverflow();if(this._scrollX!==0||this._scrollY!==0){this._scrollTo(this._scrollX,this._scrollY);}this._refresh();if(!e||D.browser.msie||this._oPullDown||this._fnScrollLoadCallback){this._sResizeListenerId=R.register(c[0],_);}c.scroll(q.proxy(this._onScroll,this));var C=c[0];function a(E,l){E.split(" ").forEach(function(s){C&&C.addEventListener(s,l);});}function o(E){return E.pointerType=="touch"?this._onStart(E):this._onMouseDown(E);}function b(E){return E.pointerType=="touch"?this._onTouchMove(E):this._onMouseMove(E);}function d(E){return E.pointerType=="touch"?this._onEnd(E):this._onMouseUp(E);}if(D.support.pointer&&D.system.desktop){a("pointerdown",o.bind(this));a("pointermove",b.bind(this));a("pointerup pointercancel pointerleave",d.bind(this));}else if(D.support.touch){c.on("touchcancel touchend",this._onEnd.bind(this)).on("touchstart",this._onStart.bind(this)).on("touchmove",this._onTouchMove.bind(this));}else if(this._bDragScroll){c.on("mouseup mouseleave",this._onMouseUp.bind(this)).mousedown(this._onMouseDown.bind(this)).mousemove(this._onMouseMove.bind(this));}},_readActualScrollPosition:function(){if(this._$Container.width()>0){this._scrollX=this._$Container.scrollLeft();}if(this._$Container.height()>0){this._scrollY=this._$Container.scrollTop();}},_scrollTo:function(x,y,t){if(this._$Container.length>0){if(t>0){this._$Container.finish().animate({scrollTop:y,scrollLeft:x},t,q.proxy(this._readActualScrollPosition,this));}else{this._$Container.scrollTop(y);this._$Container.scrollLeft(x);this._readActualScrollPosition();}}}};
function i(s){var d;if(D.support.touch||$.sap.simulateMobileOnDesktop){$.sap.require("jquery.sap.mobile");}d={_init:function(c,a,C){if($.mobile&&$.event.special.swipe&&$.event.special.swipe.scrollSupressionThreshold<120){$.event.special.swipe.scrollSupressionThreshold=120;}$.extend(this,n);if(C.nonTouchScrolling===true){this._bDragScroll=true;}if(sap.ui.getCore().getConfiguration().getRTL()){this._scrollX=9999;if(D.browser.msie||D.browser.edge){this._bFlipX=true;}}if(D.os.ios){this._oIOSScroll={};}},_exit:function(){if(this._cleanup){this._cleanup();}}};$.extend(s,d);}
return S;});
sap.ui.predefine('sap/ui/core/format/DateFormat',['jquery.sap.global','sap/ui/core/library','sap/ui/core/Locale','sap/ui/core/LocaleData','sap/ui/core/date/UniversalDate','jquery.sap.strings'],function(q,l,L,a,U){"use strict";var C=l.CalendarType;var D=function(){throw new Error();};var c={};D.oDateInfo={oDefaultFormatOptions:{style:"medium",relativeScale:"day",relativeStyle:"wide"},aFallbackFormatOptions:[{style:"short"},{style:"medium"},{pattern:"yyyy-MM-dd"},{pattern:"yyyyMMdd",strictParsing:true}],bShortFallbackFormatOptions:true,bPatternFallbackWithoutDelimiter:true,getPattern:function(o,s,e){return o.getDatePattern(s,e);},oRequiredParts:{"text":true,"year":true,"weekYear":true,"month":true,"day":true},aRelativeScales:["year","month","week","day"],aRelativeParseScales:["year","quarter","month","week","day","hour","minute","second"],aIntervalCompareFields:["FullYear","Quarter","Month","Week","Date"]};D.oDateTimeInfo={oDefaultFormatOptions:{style:"medium",relativeScale:"auto",relativeStyle:"wide"},aFallbackFormatOptions:[{style:"short"},{style:"medium"},{pattern:"yyyy-MM-dd'T'HH:mm:ss"},{pattern:"yyyyMMdd HHmmss"}],getPattern:function(o,s,e){var S=s.indexOf("/");if(S>0){return o.getCombinedDateTimePattern(s.substr(0,S),s.substr(S+1),e);}else{return o.getCombinedDateTimePattern(s,s,e);}},oRequiredParts:{"text":true,"year":true,"weekYear":true,"month":true,"day":true,"hour0_23":true,"hour1_24":true,"hour0_11":true,"hour1_12":true},aRelativeScales:["year","month","week","day","hour","minute","second"],aRelativeParseScales:["year","quarter","month","week","day","hour","minute","second"],aIntervalCompareFields:["FullYear","Quarter","Month","Week","Date","DayPeriod","Hours","Minutes","Seconds"]};D.oTimeInfo={oDefaultFormatOptions:{style:"medium",relativeScale:"auto",relativeStyle:"wide"},aFallbackFormatOptions:[{style:"short"},{style:"medium"},{pattern:"HH:mm:ss"},{pattern:"HHmmss"}],getPattern:function(o,s,e){return o.getTimePattern(s,e);},oRequiredParts:{"text":true,"hour0_23":true,"hour1_24":true,"hour0_11":true,"hour1_12":true},aRelativeScales:["hour","minute","second"],aRelativeParseScales:["year","quarter","month","week","day","hour","minute","second"],aIntervalCompareFields:["DayPeriod","Hours","Minutes","Seconds"]};
D.getInstance=function(F,o){return this.getDateInstance(F,o);};
D.getDateInstance=function(F,o){return this.createInstance(F,o,this.oDateInfo);};
D.getDateTimeInstance=function(F,o){return this.createInstance(F,o,this.oDateTimeInfo);};
D.getTimeInstance=function(F,o){return this.createInstance(F,o,this.oTimeInfo);};
function b(F){var P=F.oLocaleData.getIntervalPattern("",F.oFormatOptions.calendarType);P=P.replace(/[^\{\}01 ]/,"-");return P.replace(/\{(0|1)\}/g,F.oFormatOptions.pattern);}
D.createInstance=function(F,o,i){var e=Object.create(this.prototype);if(F instanceof L){o=F;F=undefined;}if(!o){o=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();}e.oLocale=o;e.oLocaleData=a.getInstance(o);e.oFormatOptions=q.extend(false,{},i.oDefaultFormatOptions,F);if(!e.oFormatOptions.calendarType){e.oFormatOptions.calendarType=sap.ui.getCore().getConfiguration().getCalendarType();}if(!e.oFormatOptions.pattern){if(e.oFormatOptions.format){e.oFormatOptions.pattern=e.oLocaleData.getCustomDateTimePattern(e.oFormatOptions.format,e.oFormatOptions.calendarType);}else{e.oFormatOptions.pattern=i.getPattern(e.oLocaleData,e.oFormatOptions.style,e.oFormatOptions.calendarType);}}if(e.oFormatOptions.interval){if(e.oFormatOptions.format){e.intervalPatterns=e.oLocaleData.getCustomIntervalPattern(e.oFormatOptions.format,null,e.oFormatOptions.calendarType);if(typeof e.intervalPatterns==="string"){e.intervalPatterns=[e.intervalPatterns];}e.intervalPatterns.push(e.oLocaleData.getCustomDateTimePattern(e.oFormatOptions.format,e.oFormatOptions.calendarType));}else{e.intervalPatterns=[e.oLocaleData.getCombinedIntervalPattern(e.oFormatOptions.pattern,e.oFormatOptions.calendarType),e.oFormatOptions.pattern];}var s=b(e);e.intervalPatterns.push(s);}if(!e.oFormatOptions.fallback){if(!i.oFallbackFormats){i.oFallbackFormats={};}var g=o.toString(),h=e.oFormatOptions.calendarType,k=g+"-"+h,P,j;if(e.oFormatOptions.pattern&&i.bPatternFallbackWithoutDelimiter){k=k+"-"+e.oFormatOptions.pattern;}if(e.oFormatOptions.interval){k=k+"-"+"interval";}if(!i.oFallbackFormats[k]){j=i.aFallbackFormatOptions;if(i.bShortFallbackFormatOptions){P=i.getPattern(e.oLocaleData,"short");j=j.concat(D._createFallbackOptionsWithoutDelimiter(P));}if(e.oFormatOptions.pattern&&i.bPatternFallbackWithoutDelimiter){j=D._createFallbackOptionsWithoutDelimiter(e.oFormatOptions.pattern).concat(j);}i.oFallbackFormats[k]=D._createFallbackFormat(j,h,o,i,e.oFormatOptions.interval);}e.aFallbackFormats=i.oFallbackFormats[k];}e.oRequiredParts=i.oRequiredParts;e.aRelativeScales=i.aRelativeScales;e.aRelativeParseScales=i.aRelativeParseScales;e.aIntervalCompareFields=i.aIntervalCompareFields;e.init();return e;};
D.prototype.init=function(){var s=this.oFormatOptions.calendarType;this.aMonthsAbbrev=this.oLocaleData.getMonths("abbreviated",s);this.aMonthsWide=this.oLocaleData.getMonths("wide",s);this.aMonthsNarrow=this.oLocaleData.getMonths("narrow",s);this.aMonthsAbbrevSt=this.oLocaleData.getMonthsStandAlone("abbreviated",s);this.aMonthsWideSt=this.oLocaleData.getMonthsStandAlone("wide",s);this.aMonthsNarrowSt=this.oLocaleData.getMonthsStandAlone("narrow",s);this.aDaysAbbrev=this.oLocaleData.getDays("abbreviated",s);this.aDaysWide=this.oLocaleData.getDays("wide",s);this.aDaysNarrow=this.oLocaleData.getDays("narrow",s);this.aDaysShort=this.oLocaleData.getDays("short",s);this.aDaysAbbrevSt=this.oLocaleData.getDaysStandAlone("abbreviated",s);this.aDaysWideSt=this.oLocaleData.getDaysStandAlone("wide",s);this.aDaysNarrowSt=this.oLocaleData.getDaysStandAlone("narrow",s);this.aDaysShortSt=this.oLocaleData.getDaysStandAlone("short",s);this.aQuartersAbbrev=this.oLocaleData.getQuarters("abbreviated",s);this.aQuartersWide=this.oLocaleData.getQuarters("wide",s);this.aQuartersNarrow=this.oLocaleData.getQuarters("narrow",s);this.aQuartersAbbrevSt=this.oLocaleData.getQuartersStandAlone("abbreviated",s);this.aQuartersWideSt=this.oLocaleData.getQuartersStandAlone("wide",s);this.aQuartersNarrowSt=this.oLocaleData.getQuartersStandAlone("narrow",s);this.aErasNarrow=this.oLocaleData.getEras("narrow",s);this.aErasAbbrev=this.oLocaleData.getEras("abbreviated",s);this.aErasWide=this.oLocaleData.getEras("wide",s);this.aDayPeriods=this.oLocaleData.getDayPeriods("abbreviated",s);this.aFormatArray=this.parseCldrDatePattern(this.oFormatOptions.pattern);this.sAllowedCharacters=this.getAllowedCharacters(this.aFormatArray);};
D._createFallbackFormat=function(F,s,o,i,I){return F.map(function(e){if(I){e.interval=true;}e.calendarType=s;e.fallback=true;var g=D.createInstance(e,o,i);g.bIsFallback=true;return g;});};
D._createFallbackOptionsWithoutDelimiter=function(B){var r=/[^dMyGU]/g,o={regex:/d+/g,replace:"dd"},M={regex:/M+/g,replace:"MM"},y={regex:/[yU]+/g,replace:["yyyy","yy"]};B=B.replace(r,"");B=B.replace(o.regex,o.replace);B=B.replace(M.regex,M.replace);return y.replace.map(function(R){return{pattern:B.replace(y.regex,R),strictParsing:true};});};
var p={isNumber:function(i){return i>=48&&i<=57;},findNumbers:function(v,M){var i=0;while(i<M&&this.isNumber(v.charCodeAt(i))){i++;}if(typeof v!=="string"){v=v.toString();}return v.substr(0,i);},findEntry:function(v,e){var F=-1,M=0;for(var j=0;j<e.length;j++){if(e[j]&&e[j].length>M&&v.indexOf(e[j])===0){F=j;M=e[j].length;}}return{index:F,value:F===-1?null:e[F]};},parseTZ:function(v,i){var e=0;var t=v.charAt(0)=="+"?-1:1;var P;e++;P=this.findNumbers(v.substr(e),2);var T=parseInt(P,10);e+=2;if(i){e++;}P=this.findNumbers(v.substr(e),2);e+=2;var g=parseInt(P,10);return{length:e,tzDiff:(g+60*T)*t};},checkValid:function(t,P,F){if(t in F.oRequiredParts&&P){return false;}}};D.prototype.oSymbols={"":{name:"text",format:function(F,o,u,e){return F.value;},parse:function(v,P,F,o){var s;var V=true;var i=0;var e=0;for(;e<P.value.length;e++){s=P.value.charAt(e);if(s!==" "){if(v.charAt(i)!==s){V=false;}i++;}else{while(v.charAt(i)===" "){i++;}}if(!V){break;}}if(V){return{length:i};}else{var g=false;if(o.index<o.formatArray.length-1){g=(o.formatArray[o.index+1].type in F.oRequiredParts);}return{valid:p.checkValid(P.type,g,F)};}}},"G":{name:"era",format:function(F,o,u,e){var E=u?o.getUTCEra():o.getEra();if(F.digits<=3){return e.aErasAbbrev[E];}else if(F.digits===4){return e.aErasWide[E];}else{return e.aErasNarrow[E];}},parse:function(v,P,F,o){var e=[F.aErasWide,F.aErasAbbrev,F.aErasNarrow];for(var i=0;i<e.length;i++){var V=e[i];var g=p.findEntry(v,V);if(g.index!==-1){return{era:g.index,length:g.value.length};}}return{era:F.aErasWide.length-1,valid:p.checkValid(P.type,true,F)};}},"y":{name:"year",format:function(F,o,u,e){var y=u?o.getUTCFullYear():o.getFullYear();var Y=String(y);var s=e.oFormatOptions.calendarType;if(F.digits==2&&Y.length>2){Y=Y.substr(Y.length-2);}if(s!=C.Japanese&&F.digits==1&&y<100){Y=q.sap.padLeft(Y,"0",4);}return q.sap.padLeft(Y,"0",F.digits);},parse:function(v,P,F,o){var s=F.oFormatOptions.calendarType;var e;if(P.digits==1){e=p.findNumbers(v,4);}else if(P.digits==2){e=p.findNumbers(v,2);}else{e=p.findNumbers(v,P.digits);}var y=parseInt(e,10);if(s!=C.Japanese&&e.length<=2){var g=U.getInstance(new Date(),s),i=g.getFullYear(),h=Math.floor(i/100),Y=h*100+y-i;if(Y<-70){y+=(h+1)*100;}else if(Y<30){y+=h*100;}else{y+=(h-1)*100;}}return{length:e.length,valid:p.checkValid(P.type,e==="",F),year:y};}},"Y":{name:"weekYear",format:function(F,o,u,e){var w=u?o.getUTCWeek():o.getWeek();var W=w.year;var s=String(W);var g=e.oFormatOptions.calendarType;if(F.digits==2&&s.length>2){s=s.substr(s.length-2);}if(g!=C.Japanese&&F.digits==1&&W<100){s=q.sap.padLeft(s,"0",4);}return q.sap.padLeft(s,"0",F.digits);},parse:function(v,P,F,o){var s=F.oFormatOptions.calendarType;var e;if(P.digits==1){e=p.findNumbers(v,4);}else if(P.digits==2){e=p.findNumbers(v,2);}else{e=p.findNumbers(v,P.digits);}var y=parseInt(e,10);var w;if(s!=C.Japanese&&e.length<=2){var g=U.getInstance(new Date(),s),i=g.getFullYear(),h=Math.floor(i/100),Y=h*100+w-i;if(Y<-70){w+=(h+1)*100;}else if(Y<30){w+=h*100;}else{w+=(h-1)*100;}}return{length:e.length,valid:p.checkValid(P.type,e==="",F),year:y,weekYear:w};}},"M":{name:"month",format:function(F,o,u,e){var M=u?o.getUTCMonth():o.getMonth();if(F.digits==3){return e.aMonthsAbbrev[M];}else if(F.digits==4){return e.aMonthsWide[M];}else if(F.digits>4){return e.aMonthsNarrow[M];}else{return q.sap.padLeft(String(M+1),"0",F.digits);}},parse:function(v,P,F,o){var M=[F.aMonthsWide,F.aMonthsWideSt,F.aMonthsAbbrev,F.aMonthsAbbrevSt,F.aMonthsNarrow,F.aMonthsNarrowSt];var V;var e;var s;if(P.digits<3){s=p.findNumbers(v,Math.max(P.digits,2));V=p.checkValid(P.type,s==="",F);e=parseInt(s,10)-1;if(o.strict&&(e>11||e<0)){V=false;}}else{for(var i=0;i<M.length;i++){var g=M[i];var h=p.findEntry(v,g);if(h.index!==-1){return{month:h.index,length:h.value.length};}}V=p.checkValid(P.type,true,F);}return{month:e,length:s?s.length:0,valid:V};}},"L":{name:"monthStandalone",format:function(F,o,u,e){var M=u?o.getUTCMonth():o.getMonth();if(F.digits==3){return e.aMonthsAbbrevSt[M];}else if(F.digits==4){return e.aMonthsWideSt[M];}else if(F.digits>4){return e.aMonthsNarrowSt[M];}else{return q.sap.padLeft(String(M+1),"0",F.digits);}},parse:function(v,P,F,o){var M=[F.aMonthsWide,F.aMonthsWideSt,F.aMonthsAbbrev,F.aMonthsAbbrevSt,F.aMonthsNarrow,F.aMonthsNarrowSt];var V;var e;var s;if(P.digits<3){s=p.findNumbers(v,Math.max(P.digits,2));V=p.checkValid(P.type,s==="",F);e=parseInt(s,10)-1;if(o.strict&&(e>11||e<0)){V=false;}}else{for(var i=0;i<M.length;i++){var g=M[i];var h=p.findEntry(v,g);if(h.index!==-1){return{month:h.index,length:h.value.length};}}V=p.checkValid(P.type,true,F);}return{month:e,length:s?s.length:0,valid:V};}},"w":{name:"weekInYear",format:function(F,o,u,e){var w=u?o.getUTCWeek():o.getWeek();var W=w.week;var s=String(W+1);if(F.digits<3){s=q.sap.padLeft(s,"0",F.digits);}else{s=e.oLocaleData.getCalendarWeek(F.digits===3?"narrow":"wide",q.sap.padLeft(s,"0",2));}return s;},parse:function(v,P,F,o){var V;var s;var w;var i=0;if(P.digits<3){s=p.findNumbers(v,2);i=s.length;w=parseInt(s,10)-1;V=p.checkValid(P.type,!s,F);}else{s=F.oLocaleData.getCalendarWeek(P.digits===3?"narrow":"wide");s=s.replace("{0}","[0-9]+");var r=new RegExp(s),R=r.exec(v);if(R){i=R[0].length;w=parseInt(R[0],10)-1;}else{V=p.checkValid(P.type,true,F);}}return{length:i,valid:V,week:w};}},"W":{name:"weekInMonth",format:function(F,o,u,e){return"";},parse:function(){return{};}},"D":{name:"dayInYear",format:function(F,o,u,e){},parse:function(){return{};}},"d":{name:"day",format:function(F,o,u,e){var i=u?o.getUTCDate():o.getDate();return q.sap.padLeft(String(i),"0",F.digits);},parse:function(v,P,F,o){var s=p.findNumbers(v,Math.max(P.digits,2));var V=p.checkValid(P.type,s==="",F);var i=parseInt(s,10);if(o.strict&&(i>31||i<1)){V=false;}return{day:i,length:s.length,valid:V};}},"Q":{name:"quarter",format:function(F,o,u,e){var Q=u?o.getUTCQuarter():o.getQuarter();if(F.digits==3){return e.aQuartersAbbrev[Q];}else if(F.digits==4){return e.aQuartersWide[Q];}else if(F.digits>4){return e.aQuartersNarrow[Q];}else{return q.sap.padLeft(String(Q+1),"0",F.digits);}},parse:function(v,P,F,o){var V;var Q;var s;var e=[F.aQuartersWide,F.aQuartersWideSt,F.aQuartersAbbrev,F.aQuartersAbbrevSt,F.aQuartersNarrow,F.aQuartersNarrowSt];if(P.digits<3){s=p.findNumbers(v,Math.max(P.digits,2));V=p.checkValid(P.type,s==="",F);Q=parseInt(s,10)-1;if(o.strict&&Q>3){V=false;}}else{for(var i=0;i<e.length;i++){var g=e[i];var h=p.findEntry(v,g);if(h.index!==-1){return{quarter:h.index,length:h.value.length};}}V=p.checkValid(P.type,true,F);}return{length:s?s.length:0,quarter:Q,valid:V};}},"q":{name:"quarterStandalone",format:function(F,o,u,e){var Q=u?o.getUTCQuarter():o.getQuarter();if(F.digits==3){return e.aQuartersAbbrevSt[Q];}else if(F.digits==4){return e.aQuartersWideSt[Q];}else if(F.digits>4){return e.aQuartersNarrowSt[Q];}else{return q.sap.padLeft(String(Q+1),"0",F.digits);}},parse:function(v,P,F,o){var V;var Q;var s;var e=[F.aQuartersWide,F.aQuartersWideSt,F.aQuartersAbbrev,F.aQuartersAbbrevSt,F.aQuartersNarrow,F.aQuartersNarrowSt];if(P.digits<3){s=p.findNumbers(v,Math.max(P.digits,2));V=p.checkValid(P.type,s==="",F);Q=parseInt(s,10)-1;if(o.strict&&Q>3){V=false;}}else{for(var i=0;i<e.length;i++){var g=e[i];var h=p.findEntry(v,g);if(h.index!==-1){return{quarter:h.index,length:h.value.length};}}V=p.checkValid(P.type,true,F);}return{length:s?s.length:0,quarter:Q,valid:V};}},"F":{name:"dayOfWeekInMonth",format:function(F,o,u,e){return"";},parse:function(){return{};}},"E":{name:"dayNameInWeek",format:function(F,o,u,e){var i=u?o.getUTCDay():o.getDay();if(F.digits<4){return e.aDaysAbbrev[i];}else if(F.digits==4){return e.aDaysWide[i];}else if(F.digits==5){return e.aDaysNarrow[i];}else{return e.aDaysShort[i];}},parse:function(v,P,F,o){var e=[F.aDaysWide,F.aDaysWideSt,F.aDaysAbbrev,F.aDaysAbbrevSt,F.aDaysShort,F.aDaysShortSt,F.aDaysNarrow,F.aDaysNarrowSt];for(var i=0;i<e.length;i++){var V=e[i];var g=p.findEntry(v,V);if(g.index!==-1){return{day:g.index,length:g.value.length};}}}},"c":{name:"dayNameInWeekStandalone",format:function(F,o,u,e){var i=u?o.getUTCDay():o.getDay();if(F.digits<4){return e.aDaysAbbrevSt[i];}else if(F.digits==4){return e.aDaysWideSt[i];}else if(F.digits==5){return e.aDaysNarrowSt[i];}else{return e.aDaysShortSt[i];}},parse:function(v,P,F,o){var e=[F.aDaysWide,F.aDaysWideSt,F.aDaysAbbrev,F.aDaysAbbrevSt,F.aDaysShort,F.aDaysShortSt,F.aDaysNarrow,F.aDaysNarrowSt];for(var i=0;i<e.length;i++){var V=e[i];var g=p.findEntry(v,V);if(g.index!==-1){return{day:g.index,length:g.value.length};}}}},"u":{name:"dayNumberOfWeek",format:function(F,o,u,e){var i=u?o.getUTCDay():o.getDay();var g=e.oLocaleData.getFirstDayOfWeek();var h=i-(g-1);if(h<=0){h+=7;}return h;},parse:function(v,P,F,o){var s=p.findNumbers(v,P.digits);return{dayNumberOfWeek:parseInt(s,10),length:s.length};}},"a":{name:"amPmMarker",format:function(F,o,u,e){var i=u?o.getUTCDayPeriod():o.getDayPeriod();return e.aDayPeriods[i];},parse:function(v,P,F,o){var e;var i;var A=F.aDayPeriods[0],s=F.aDayPeriods[1];var r=/[aApP](?:\.)?[mM](?:\.)?/;var M=v.match(r);var V=(M&&M.index===0);if(V){v=M[0].replace(/\./g,"").toLowerCase()+v.substring(M[0].length);A=A.toLowerCase();s=s.toLowerCase();}if(v.indexOf(A)===0){e=false;i=(V?M[0].length:A.length);}else if(v.indexOf(s)===0){e=true;i=(V?M[0].length:s.length);}return{pm:e,length:i};}},"H":{name:"hour0_23",format:function(F,o,u,e){var h=u?o.getUTCHours():o.getHours();return q.sap.padLeft(String(h),"0",F.digits);},parse:function(v,P,F,o){var V;var s=p.findNumbers(v,Math.max(P.digits,2));var h=parseInt(s,10);V=p.checkValid(P.type,s==="",F);if(o.strict&&h>23){V=false;}return{hour:h,length:s.length,valid:V};}},"k":{name:"hour1_24",format:function(F,o,u,e){var h=u?o.getUTCHours():o.getHours();var H=(h===0?"24":String(h));return q.sap.padLeft(H,"0",F.digits);},parse:function(v,P,F,o){var V;var s=p.findNumbers(v,Math.max(P.digits,2));var h=parseInt(s,10);V=p.checkValid(P.type,s==="",F);if(h==24){h=0;}if(o.strict&&h>23){V=false;}return{hour:h,length:s.length,valid:V};}},"K":{name:"hour0_11",format:function(F,o,u,e){var h=u?o.getUTCHours():o.getHours();var H=String(h>11?h-12:h);return q.sap.padLeft(H,"0",F.digits);},parse:function(v,P,F,o){var V;var s=p.findNumbers(v,Math.max(P.digits,2));var h=parseInt(s,10);V=p.checkValid(P.type,s==="",F);if(o.strict&&h>11){V=false;}return{hour:h,length:s.length,valid:V};}},"h":{name:"hour1_12",format:function(F,o,u,e){var h=u?o.getUTCHours():o.getHours();var H;if(h>12){H=String(h-12);}else if(h==0){H="12";}else{H=String(h);}return q.sap.padLeft(H,"0",F.digits);},parse:function(v,P,F,o){var e=o.dateValue.pm;var s=p.findNumbers(v,Math.max(P.digits,2));var h=parseInt(s,10);var V=p.checkValid(P.type,s==="",F);if(h==12){h=0;e=(e===undefined)?true:e;}if(o.strict&&h>11){V=false;}return{hour:h,length:s.length,pm:e,valid:V};}},"m":{name:"minute",format:function(F,o,u,e){var M=u?o.getUTCMinutes():o.getMinutes();return q.sap.padLeft(String(M),"0",F.digits);},parse:function(v,P,F,o){var V;var s=p.findNumbers(v,Math.max(P.digits,2));var M=parseInt(s,10);V=p.checkValid(P.type,s==="",F);if(o.strict&&M>59){V=false;}return{length:s.length,minute:M,valid:V};}},"s":{name:"second",format:function(F,o,u,e){var s=u?o.getUTCSeconds():o.getSeconds();return q.sap.padLeft(String(s),"0",F.digits);},parse:function(v,P,F,o){var V;var s=p.findNumbers(v,Math.max(P.digits,2));var S=parseInt(s,10);V=p.checkValid(P.type,s==="",F);if(o.strict&&S>59){V=false;}return{length:s.length,second:S,valid:V};}},"S":{name:"fractionalsecond",format:function(F,o,u,e){var M=u?o.getUTCMilliseconds():o.getMilliseconds();var s=String(M);var g=q.sap.padLeft(s,"0",3);g=g.substr(0,F.digits);g=q.sap.padRight(g,"0",F.digits);return g;},parse:function(v,P,F,o){var s=p.findNumbers(v,P.digits);var i=s.length;s=s.substr(0,3);s=q.sap.padRight(s,"0",3);var M=parseInt(s,10);return{length:i,millisecond:M};}},"z":{name:"timezoneGeneral",format:function(F,o,u,e){if(F.digits>3&&o.getTimezoneLong()){return o.getTimezoneLong();}else if(o.getTimezoneShort()){return o.getTimezoneShort();}var t="GMT";var T=Math.abs(o.getTimezoneOffset());var P=o.getTimezoneOffset()>0;var h=Math.floor(T/60);var M=T%60;if(!u&&T!=0){t+=(P?"-":"+");t+=q.sap.padLeft(String(h),"0",2);t+=":";t+=q.sap.padLeft(String(M),"0",2);}else{t+="Z";}return t;},parse:function(v,P,F,o){var i=0;var t;var T=v.substring(0,3);if(T==="GMT"||T==="UTC"){i=3;}else if(v.substring(0,2)==="UT"){i=2;}else if(v.charAt(0)=="Z"){i=1;t=0;}else{return{error:"cannot be parsed correcly by sap.ui.core.format.DateFormat: The given timezone is not supported!"};}if(v.charAt(0)!="Z"){var e=p.parseTZ(v.substr(i),true);i+=e.length;t=e.tzDiff;}return{length:i,tzDiff:t};}},"Z":{name:"timezoneRFC822",format:function(F,o,u,e){var t=Math.abs(o.getTimezoneOffset());var P=o.getTimezoneOffset()>0;var h=Math.floor(t/60);var M=t%60;var T="";if(!u&&t!=0){T+=(P?"-":"+");T+=q.sap.padLeft(String(h),"0",2);T+=q.sap.padLeft(String(M),"0",2);}return T;},parse:function(v,P,F,o){return p.parseTZ(v,false);}},"X":{name:"timezoneISO8601",format:function(F,o,u,e){var t=Math.abs(o.getTimezoneOffset());var P=o.getTimezoneOffset()>0;var h=Math.floor(t/60);var M=t%60;var T="";if(!u&&t!=0){T+=(P?"-":"+");T+=q.sap.padLeft(String(h),"0",2);T+=":";T+=q.sap.padLeft(String(M),"0",2);}else{T+="Z";}return T;},parse:function(v,P,F,o){if(v.charAt(0)=="Z"){return{length:1,tzDiff:0};}else{return p.parseTZ(v,true);}}}};
D.prototype._format=function(j,u){if(this.oFormatOptions.relative){var r=this.formatRelative(j,u,this.oFormatOptions.relativeRange);if(r){return r;}}var s=this.oFormatOptions.calendarType;var o=U.getInstance(j,s);var B=[],P,R,S;for(var i=0;i<this.aFormatArray.length;i++){P=this.aFormatArray[i];S=P.symbol||"";B.push(this.oSymbols[S].format(P,o,u,this));}R=B.join("");if(sap.ui.getCore().getConfiguration().getOriginInfo()){R=new String(R);R.originInfo={source:"Common Locale Data Repository",locale:this.oLocale.toString(),style:this.oFormatOptions.style,pattern:this.oFormatOptions.pattern};}return R;};
D.prototype.format=function(j,u){if(u===undefined){u=this.oFormatOptions.UTC;}if(Array.isArray(j)){if(!this.oFormatOptions.interval){q.sap.log.error("Non-interval DateFormat can't format more than one date instance.");return"";}if(j.length!==2){q.sap.log.error("Interval DateFormat can only format with 2 date instances but "+j.length+" is given.");return"";}var v=j.every(function(J){return J&&!isNaN(J.getTime());});if(!v){q.sap.log.error("At least one date instance which is passed to the interval DateFormat isn't valid.");return"";}return this._formatInterval(j,u);}else{if(!j||isNaN(j.getTime())){q.sap.log.error("The given date instance isn't valid.");return"";}if(this.oFormatOptions.interval){q.sap.log.error("Interval DateFormat expects an array with two dates for the first argument but only one date is given.");return"";}return this._format(j,u);}};
D.prototype._formatInterval=function(j,u){var s=this.oFormatOptions.calendarType;var F=U.getInstance(j[0],s);var t=U.getInstance(j[1],s);var o;var P;var S;var B=[];var e;var g=this._getGreatestDiffField([F,t],u);if(!g){return this._format(j[0],u);}if(this.oFormatOptions.format){e=this.oLocaleData.getCustomIntervalPattern(this.oFormatOptions.format,g,s);}else{e=this.oLocaleData.getCombinedIntervalPattern(this.oFormatOptions.pattern,s);}this.aFormatArray=this.parseCldrDatePattern(e);o=F;for(var i=0;i<this.aFormatArray.length;i++){P=this.aFormatArray[i];S=P.symbol||"";if(P.repeat){o=t;}B.push(this.oSymbols[S].format(P,o,u,this));}return B.join("");};
var f={FullYear:"Year",Quarter:"Quarter",Month:"Month",Week:"Week",Date:"Day",DayPeriod:"DayPeriod",Hours:"Hour",Minutes:"Minute",Seconds:"Second"};
D.prototype._getGreatestDiffField=function(e,u){var g=false,h={};this.aIntervalCompareFields.forEach(function(F){var G="get"+(u?"UTC":""),M=G+F,s=f[F],v=e[0][M].apply(e[0]),t=e[1][M].apply(e[1]);if(!q.sap.equal(v,t)){g=true;h[s]=true;}});if(g){return h;}return null;};
D.prototype._parse=function(v,F,u,s){var I=0,P,S,r;var o={valid:true};var e={formatArray:F,dateValue:o,strict:s};for(var i=0;i<F.length;i++){S=v.substr(I);P=F[i];e.index=i;r=this.oSymbols[P.symbol||""].parse(S,P,this,e)||{};o=q.extend(o,r);if(r.valid===false){break;}I+=r.length||0;}o.index=I;if(o.pm){o.hour+=12;}if(o.quarter!==undefined&&o.month===undefined&&o.day===undefined){o.month=3*o.quarter;o.day=1;}return o;};
D.prototype._parseInterval=function(v,s,u,S){var e,r,o;this.intervalPatterns.some(function(P){var F=this.parseCldrDatePattern(P);r=undefined;for(var i=0;i<F.length;i++){if(F[i].repeat){r=i;break;}}if(r===undefined){o=this._parse(v,F,u,S);if(o.index===0||o.index<v.length){o.valid=false;}if(o.valid===false){return;}e=[o,o];return true;}else{e=[];o=this._parse(v,F.slice(0,r),u,S);if(o.valid===false){return;}e.push(o);var g=o.index;o=this._parse(v.substring(g),F.slice(r),u,S);if(o.index===0||o.index+g<v.length){o.valid=false;}if(o.valid===false){return;}e.push(o);return true;}}.bind(this));return e;};
var d=function(o,s,u,S){var e,y=typeof o.year==="number"?o.year:1970;if(o.valid){if(u||o.tzDiff!==undefined){e=U.getInstance(new Date(0),s);e.setUTCEra(o.era||U.getCurrentEra(s));e.setUTCFullYear(y);e.setUTCMonth(o.month||0);e.setUTCDate(o.day||1);e.setUTCHours(o.hour||0);e.setUTCMinutes(o.minute||0);e.setUTCSeconds(o.second||0);e.setUTCMilliseconds(o.millisecond||0);if(S&&(o.day||1)!==e.getUTCDate()){o.valid=false;e=undefined;}else{if(o.tzDiff){e.setUTCMinutes((o.minute||0)+o.tzDiff);}if(o.week!==undefined){e.setUTCWeek({year:o.weekYear||o.year,week:o.week});if(o.dayNumberOfWeek!==undefined){e.setUTCDate(e.getUTCDate()+o.dayNumberOfWeek-1);}}}}else{e=U.getInstance(new Date(1970,0,1,0,0,0),s);e.setEra(o.era||U.getCurrentEra(s));e.setFullYear(y);e.setMonth(o.month||0);e.setDate(o.day||1);e.setHours(o.hour||0);e.setMinutes(o.minute||0);e.setSeconds(o.second||0);e.setMilliseconds(o.millisecond||0);if(S&&(o.day||1)!==e.getDate()){o.valid=false;e=undefined;}else if(o.week!==undefined){e.setWeek({year:o.weekYear||o.year,week:o.week});if(o.dayNumberOfWeek!==undefined){e.setDate(e.getDate()+o.dayNumberOfWeek-1);}}}if(o.valid){e=e.getJSDate();return e;}}return null;};
function m(o,e){if(o===e){return o;}var M={};Object.keys(o).forEach(function(k){M[k]=o[k];});Object.keys(e).forEach(function(k){if(!M.hasOwnProperty(k)){M[k]=e[k];}});return M;}
D.prototype.parse=function(v,u,s){v=q.trim(v);var o;var e=this.oFormatOptions.calendarType;if(u===undefined){u=this.oFormatOptions.UTC;}if(s===undefined){s=this.oFormatOptions.strictParsing;}if(!this.oFormatOptions.interval){var j=this.parseRelative(v,u);if(j){return j;}o=this._parse(v,this.aFormatArray,u,s);if(o.index===0||o.index<v.length){o.valid=false;}j=d(o,e,u,s);if(j){return j;}}else{var g=this._parseInterval(v,e,u,s);var J,h;if(g&&g.length==2){var k=m(g[0],g[1]);var n=m(g[1],g[0]);J=d(k,e,u,s);h=d(n,e,u,s);if(J&&h){return[J,h];}}}if(!this.bIsFallback){var r;q.each(this.aFallbackFormats,function(i,F){r=F.parse(v,u,s);if(Array.isArray(r)){return!(r[0]&&r[1]);}else{return!r;}});return r;}if(!this.oFormatOptions.interval){return null;}else{return[null,null];}};
D.prototype.parseCldrDatePattern=function(P){if(c[P]){return c[P];}var F=[],i,Q=false,o=null,s="",n="",A={},I=false;for(i=0;i<P.length;i++){var e=P.charAt(i),N,g,h;if(Q){if(e=="'"){g=P.charAt(i-1);h=P.charAt(i-2);N=P.charAt(i+1);if(g=="'"&&h!="'"){Q=false;}else if(N=="'"){i+=1;}else{Q=false;continue;}}if(s=="text"){o.value+=e;}else{o={type:"text",value:e};F.push(o);s="text";}}else{if(e=="'"){Q=true;}else if(this.oSymbols[e]){n=this.oSymbols[e].name;if(s==n){o.digits++;}else{o={type:n,symbol:e,digits:1};F.push(o);s=n;if(!I){if(A[n]){o.repeat=true;I=true;}else{A[n]=true;}}}}else{if(s=="text"){o.value+=e;}else{o={type:"text",value:e};F.push(o);s="text";}}}}c[P]=F;return F;};
D.prototype.parseRelative=function(v,u){var P,e,r,R,V;if(!v){return null;}P=this.oLocaleData.getRelativePatterns(this.aRelativeParseScales,this.oFormatOptions.relativeStyle);for(var i=0;i<P.length;i++){e=P[i];r=new RegExp("^\\s*"+e.pattern.replace(/\{0\}/,"(\\d+)")+"\\s*$","i");R=r.exec(v);if(R){if(e.value!==undefined){return g(e.value,e.scale);}else{V=parseInt(R[1],10);return g(V*e.sign,e.scale);}}}function g(h,s){var t,T=new Date(),j;if(u){t=T.getTime();}else{t=Date.UTC(T.getFullYear(),T.getMonth(),T.getDate(),T.getHours(),T.getMinutes(),T.getSeconds(),T.getMilliseconds());}j=new Date(t);switch(s){case"second":j.setUTCSeconds(j.getUTCSeconds()+h);break;case"minute":j.setUTCMinutes(j.getUTCMinutes()+h);break;case"hour":j.setUTCHours(j.getUTCHours()+h);break;case"day":j.setUTCDate(j.getUTCDate()+h);break;case"week":j.setUTCDate(j.getUTCDate()+h*7);break;case"month":j.setUTCMonth(j.getUTCMonth()+h);break;case"quarter":j.setUTCMonth(j.getUTCMonth()+h*3);break;case"year":j.setUTCFullYear(j.getUTCFullYear()+h);break;}if(u){return j;}else{return new Date(j.getUTCFullYear(),j.getUTCMonth(),j.getUTCDate(),j.getUTCHours(),j.getUTCMinutes(),j.getUTCSeconds(),j.getUTCMilliseconds());}}};
D.prototype.formatRelative=function(j,u,r){var t=new Date(),s=this.oFormatOptions.relativeScale||"day",T,i,e,P,g;g=(j.getTime()-t.getTime())/1000;if(this.oFormatOptions.relativeScale=="auto"){s=this._getScale(g,this.aRelativeScales);}if(!r){r=this._mRanges[s];}if(s=="year"||s=="month"||s=="day"){T=Date.UTC(t.getFullYear(),t.getMonth(),t.getDate());if(u){i=Date.UTC(j.getUTCFullYear(),j.getUTCMonth(),j.getUTCDate());}else{i=Date.UTC(j.getFullYear(),j.getMonth(),j.getDate());}g=(i-T)/1000;}e=this._getDifference(s,g);if(this.oFormatOptions.relativeScale!="auto"&&(e<r[0]||e>r[1])){return null;}P=this.oLocaleData.getRelativePattern(s,e,g>0,this.oFormatOptions.relativeStyle);return q.sap.formatMessage(P,[Math.abs(e)]);};
D.prototype._mRanges={second:[-60,60],minute:[-60,60],hour:[-24,24],day:[-6,6],week:[-4,4],month:[-12,12],year:[-10,10]};D.prototype._mScales={second:1,minute:60,hour:3600,day:86400,week:604800,month:2592000,quarter:7776000,year:31536000};
D.prototype._getScale=function(e,s){var S,t;e=Math.abs(e);for(var i=0;i<s.length;i++){t=s[i];if(e>=this._mScales[t]){S=t;break;}}if(!S){S=s[s.length-1];}return S;};
D.prototype._getDifference=function(s,i){var S=this._mScales[s],e=i/S;if(i>0){e=Math.floor(e);}else{e=Math.ceil(e);}return e;};
D.prototype.getAllowedCharacters=function(F){if(this.oFormatOptions.relative){return"";}var A="";var n=false;var e=false;var P;for(var i=0;i<this.aFormatArray.length;i++){P=this.aFormatArray[i];switch(P.type){case"text":if(A.indexOf(P.value)<0){A+=P.value;}break;case"day":case"year":case"weekYear":case"dayNumberOfWeek":case"weekInYear":case"hour0_23":case"hour1_24":case"hour0_11":case"hour1_12":case"minute":case"second":case"fractionalsecond":if(!n){A+="0123456789";n=true;}break;case"month":case"monthStandalone":if(P.digits<3){if(!n){A+="0123456789";n=true;}}else{e=true;}break;default:e=true;break;}}if(e){A="";}return A;};
return D;},true);
sap.ui.predefine('sap/ui/core/format/FileSizeFormat',['jquery.sap.global','sap/ui/base/Object','sap/ui/core/Locale','sap/ui/core/LocaleData','sap/ui/core/format/NumberFormat'],function(q,B,L,a,N){"use strict";var _=[{binaryFactor:1,decimalFactor:1,decimalUnit:"Byte",binaryUnit:"Byte"},{binaryFactor:1,decimalFactor:1,decimalUnit:"Bytes",binaryUnit:"Bytes"},{binaryFactor:Math.pow(2,10),decimalFactor:1e3,decimalUnit:"Kilobyte",binaryUnit:"Kibibyte"},{binaryFactor:Math.pow(2,20),decimalFactor:1e6,decimalUnit:"Megabyte",binaryUnit:"Mebibyte"},{binaryFactor:Math.pow(2,30),decimalFactor:1e9,decimalUnit:"Gigabyte",binaryUnit:"Gibibyte"},{binaryFactor:Math.pow(2,40),decimalFactor:1e12,decimalUnit:"Terabyte",binaryUnit:"Tebibyte"},{binaryFactor:Math.pow(2,50),decimalFactor:1e15,decimalUnit:"Petabyte",binaryUnit:"Pebibyte"},{binaryFactor:Math.pow(2,60),decimalFactor:1e18,decimalUnit:"Exabyte",binaryUnit:"Exbibyte"},{binaryFactor:Math.pow(2,70),decimalFactor:1e21,decimalUnit:"Zettabyte",binaryUnit:"Zebibyte"},{binaryFactor:Math.pow(2,80),decimalFactor:1e24,decimalUnit:"Yottabyte",binaryUnit:"Yobibyte"}];
var F=B.extend("sap.ui.core.format.FileSizeFormat",{constructor:function(f){throw new Error();}});
F.getInstance=function(f,l){return this.createInstance(f,l);};
F.createInstance=function(f,l){var o=Object.create(this.prototype);if(f instanceof L){l=f;f=undefined;}if(!l){l=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();}o.oLocale=l;o.oLocaleData=a.getInstance(l);o.oNumberFormat=N.getFloatInstance(f,l);o.oBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.core",l.toString());o.bBinary=f?!!f.binaryFilesize:false;return o;};
F.prototype.format=function(v){var V=null,o;if(typeof v=="string"){try{if(/^\s*[\+-]?0[xX]/.test(v)){V=parseInt(v,16);}else{V=parseFloat(v,10);}}catch(e){}}else if(typeof v=="number"){V=v;}if(V===null){return"NaN";}o=V;var u=c(V,this.bBinary),s=this.oNumberFormat.format(V/u.factor);if(!u.noSecondRounding){V=this.oNumberFormat.parse(s);if((this.bBinary&&Math.abs(V)>=1024)||(!this.bBinary&&Math.abs(V)>=1000)){u=c(V*u.factor,this.bBinary);s=this.oNumberFormat.format(o/u.factor);}}return this.oBundle.getText("FileSize."+u.unit,s);};
F.prototype.parse=function(v){var u,b,V,e;if(!v){return NaN;}for(var i=0;i<_.length;i++){u=_[i];b=d(this.oBundle,u.decimalUnit,v);if(b){e=false;break;}else{b=d(this.oBundle,u.binaryUnit,v);if(b){e=true;break;}}}if(!b){b=v;e=false;u=_[0];}V=this.oNumberFormat.parse(b);return V*(e?u.binaryFactor:u.decimalFactor);};
function c(f,e){var b=Math.abs(f),u,g;for(var i=_.length-1;i>=2;i--){u=_[i];g=e?u.binaryFactor:u.decimalFactor;if(b>=g){return{factor:g,unit:e?u.binaryUnit:u.decimalUnit,noSecondRounding:(i==_.length-1)};}}return{factor:1,unit:_[b>=2?1:0].decimalUnit};}
function d(b,u,v){var p=b.getText("FileSize."+u),e;if(q.sap.startsWith(p,"{0}")){e=p.substr(3,p.length);if(q.sap.endsWithIgnoreCase(v,e)){return v.substr(0,v.length-e.length);}}else if(q.sap.endsWith(p,"{0}")){e=p.substr(0,p.length-3);if(q.sap.startsWithIgnoreCase(v,e)){return v.substr(e.length,v.length);}}else{e=p.split("{0}");if(e.length==2&&q.sap.startsWithIgnoreCase(v,e[0])&&q.sap.endsWithIgnoreCase(v,e[1])){return v.substr(e[0].length,v.length-e[1].length);}}return null;}
return F;});
sap.ui.predefine('sap/ui/core/format/NumberFormat',['jquery.sap.global','sap/ui/base/Object','sap/ui/core/Locale','sap/ui/core/LocaleData'],function(q,B,L,a){"use strict";
var N=B.extend("sap.ui.core.format.NumberFormat",{constructor:function(f){throw new Error();}});
var r=/0+(\.0+)?/;var n={INTEGER:"integer",FLOAT:"float",CURRENCY:"currency",PERCENT:"percent"};var R={FLOOR:"floor",CEILING:"ceiling",TOWARDS_ZERO:"towards_zero",AWAY_FROM_ZERO:"away_from_zero",HALF_FLOOR:"half_floor",HALF_CEILING:"half_ceiling",HALF_TOWARDS_ZERO:"half_towards_zero",HALF_AWAY_FROM_ZERO:"half_away_from_zero"};var m={};m[R.FLOOR]=Math.floor;m[R.CEILING]=Math.ceil;m[R.TOWARDS_ZERO]=function(f){return f>0?Math.floor(f):Math.ceil(f);};m[R.AWAY_FROM_ZERO]=function(f){return f>0?Math.ceil(f):Math.floor(f);};m[R.HALF_TOWARDS_ZERO]=function(f){return f>0?Math.ceil(f-0.5):Math.floor(f+0.5);};m[R.HALF_AWAY_FROM_ZERO]=function(f){return f>0?Math.floor(f+0.5):Math.ceil(f-0.5);};m[R.HALF_FLOOR]=function(f){return Math.ceil(f-0.5);};m[R.HALF_CEILING]=Math.round;N.RoundingMode=R;N.oDefaultIntegerFormat={minIntegerDigits:1,maxIntegerDigits:99,minFractionDigits:0,maxFractionDigits:0,groupingEnabled:false,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:true,type:n.INTEGER,showMeasure:false,style:"standard",parseAsString:false,roundingMode:N.RoundingMode.TOWARDS_ZERO,emptyString:NaN,showScale:true};N.oDefaultFloatFormat={minIntegerDigits:1,maxIntegerDigits:99,minFractionDigits:0,maxFractionDigits:99,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:false,type:n.FLOAT,showMeasure:false,style:"standard",parseAsString:false,roundingMode:N.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true};N.oDefaultPercentFormat={minIntegerDigits:1,maxIntegerDigits:99,minFractionDigits:0,maxFractionDigits:99,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",percentSign:"%",isInteger:false,type:n.PERCENT,showMeasure:false,style:"standard",parseAsString:false,roundingMode:N.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true};N.oDefaultCurrencyFormat={minIntegerDigits:1,maxIntegerDigits:99,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:false,type:n.CURRENCY,showMeasure:true,currencyCode:true,currencyContext:'standard',style:"standard",parseAsString:false,roundingMode:N.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true};
N.getInstance=function(f,l){return this.getFloatInstance(f,l);};
N.getFloatInstance=function(f,l){var F=this.createInstance(f,l),o=this.getLocaleFormatOptions(F.oLocaleData,n.FLOAT);F.oFormatOptions=q.extend(false,{},this.oDefaultFloatFormat,o,f);return F;};
N.getIntegerInstance=function(f,l){var F=this.createInstance(f,l),o=this.getLocaleFormatOptions(F.oLocaleData,n.INTEGER);F.oFormatOptions=q.extend(false,{},this.oDefaultIntegerFormat,o,f);return F;};
N.getCurrencyInstance=function(f,l){var F=this.createInstance(f,l),C=f&&f.currencyContext,o=this.getLocaleFormatOptions(F.oLocaleData,n.CURRENCY,C);F.oFormatOptions=q.extend(false,{},this.oDefaultCurrencyFormat,o,f);return F;};
N.getPercentInstance=function(f,l){var F=this.createInstance(f,l),o=this.getLocaleFormatOptions(F.oLocaleData,n.PERCENT);F.oFormatOptions=q.extend(false,{},this.oDefaultPercentFormat,o,f);return F;};
N.createInstance=function(f,l){var F=Object.create(this.prototype),p;if(f instanceof L){l=f;f=undefined;}if(!l){l=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();}F.oLocale=l;F.oLocaleData=a.getInstance(l);F.oOriginalFormatOptions=f;if(f){if(f.pattern){p=this.parseNumberPattern(f.pattern);q.each(p,function(s,o){f[s]=o;});}if(f.emptyString!==undefined){}}return F;};
N.getLocaleFormatOptions=function(l,t,C){var o={},s;switch(t){case n.PERCENT:s=l.getPercentPattern();break;case n.CURRENCY:s=l.getCurrencyPattern(C);break;default:s=l.getDecimalPattern();}o=this.parseNumberPattern(s);o.plusSign=l.getNumberSymbol("plusSign");o.minusSign=l.getNumberSymbol("minusSign");o.decimalSeparator=l.getNumberSymbol("decimal");o.groupingSeparator=l.getNumberSymbol("group");o.percentSign=l.getNumberSymbol("percentSign");o.pattern=s;switch(t){case n.FLOAT:case n.PERCENT:o.minFractionDigits=0;o.maxFractionDigits=99;break;case n.INTEGER:o.minFractionDigits=0;o.maxFractionDigits=0;o.groupingEnabled=false;break;case n.CURRENCY:o.minFractionDigits=undefined;o.maxFractionDigits=undefined;break;}return o;};
N.parseNumberPattern=function(f){var M=0,h=0,j=0,G=false,k=0,l=0,s=f.indexOf(";"),S={Integer:0,Fraction:1},o=S.Integer;if(s!==-1){f=f.substring(0,s);}for(var i=0;i<f.length;i++){var C=f[i];switch(C){case",":if(G){k=l;l=0;}G=true;break;case".":o=S.Fraction;break;case"0":if(o===S.Integer){M++;if(G){l++;}}else{h++;j++;}break;case"#":if(o===S.Integer){if(G){l++;}}else{j++;}break;}}if(!k){k=l;l=0;}return{minIntegerDigits:M,minFractionDigits:h,maxFractionDigits:j,groupingEnabled:G,groupingSize:k,groupingBaseSize:l};};
N.prototype.format=function(v,M){if(Array.isArray(v)){M=v[1];v=v[0];}var i="",f="",G="",s="",h="",p="",P=0,l=0,j=0,k=0,o=v<0,D=-1,O=q.extend({},this.oFormatOptions),t=this.oOriginalFormatOptions,u,S,w,x;if(v===O.emptyString||(isNaN(v)&&isNaN(O.emptyString))){return"";}if(O.decimals!==undefined){O.minFractionDigits=O.decimals;O.maxFractionDigits=O.decimals;}if(O.shortLimit===undefined||Math.abs(v)>=O.shortLimit){w=O.shortRefNumber===undefined?v:O.shortRefNumber;S=g(w,O,this.oLocaleData);if(S&&S.formatString!="0"){v=v/S.magnitude;if(O.shortDecimals!==undefined){O.minFractionDigits=O.shortDecimals;O.maxFractionDigits=O.shortDecimals;}else{if(t.minFractionDigits===undefined&&t.maxFractionDigits===undefined&&t.decimals===undefined&&t.precision===undefined&&t.pattern===undefined){O.precision=2;}if(t.maxFractionDigits===undefined&&t.decimals===undefined){O.maxFractionDigits=99;}}O.roundingMode=N.RoundingMode.HALF_AWAY_FROM_ZERO;}}if(O.precision!==undefined){O.maxFractionDigits=Math.min(O.maxFractionDigits,e(v,O.precision));O.minFractionDigits=Math.min(O.minFractionDigits,O.maxFractionDigits);}if(O.type==n.PERCENT){v=N._shiftDecimalPoint(v,2);}if(O.type==n.CURRENCY){var y=this.oLocaleData.getCurrencyDigits(M);if(O.maxFractionDigits===undefined){O.maxFractionDigits=y;}if(O.minFractionDigits===undefined){O.minFractionDigits=y;}}if(typeof v=="number"){v=c(v,O.maxFractionDigits,O.roundingMode);}if(v==0){o=false;}h=this.convertToDecimal(v);if(h=="NaN"){return h;}if(o){h=h.substr(1);}D=h.indexOf(".");if(D>-1){i=h.substr(0,D);f=h.substr(D+1);}else{i=h;}if(i.length<O.minIntegerDigits){i=q.sap.padLeft(i,"0",O.minIntegerDigits);}else if(i.length>O.maxIntegerDigits){i=q.sap.padLeft("","?",O.maxIntegerDigits);}if(f.length<O.minFractionDigits){f=q.sap.padRight(f,"0",O.minFractionDigits);}else if(f.length>O.maxFractionDigits){f=f.substr(0,O.maxFractionDigits);}l=i.length;if(O.groupingEnabled){j=O.groupingSize;k=O.groupingBaseSize||j;P=Math.max(l-k,0)%j||j;G=i.substr(0,P);while(l-P>=k){G+=O.groupingSeparator;G+=i.substr(P,j);P+=j;}G+=i.substr(P);}else{G=i;}if(o){s=O.minusSign;}s+=G;if(f){s+=O.decimalSeparator+f;}if(S&&S.formatString&&O.showScale&&O.type!==n.CURRENCY){x=this.oLocaleData.getPluralCategory(i+"."+f);S.formatString=this.oLocaleData.getDecimalFormat(O.style,S.key,x);s=S.formatString.replace(S.valueSubString,s);s=s.replace(/'.'/g,".");}if(O.type===n.CURRENCY){p=O.pattern;if(S&&S.formatString&&O.showScale){x=this.oLocaleData.getPluralCategory(i+"."+f);p=this.oLocaleData.getCurrencyFormat("short",S.key,x);p=p.replace(/'.'/g,".");}u=p.split(";");if(u.length===2){p=o?u[1]:u[0];if(o){s=s.substring(1);}}if(!O.currencyCode){M=this.oLocaleData.getCurrencySymbol(M);}s=this._composeCurrencyResult(p,s,M,{showMeasure:O.showMeasure,negative:o,minusSign:O.minusSign});}if(O.type==n.PERCENT){p=O.pattern;s=p.replace(/[0#.,]+/,s);s=s.replace(/%/,O.percentSign);}if(sap.ui.getCore().getConfiguration().getOriginInfo()){s=new String(s);s.originInfo={source:"Common Locale Data Repository",locale:this.oLocale.toString()};}return s;};
N.prototype._composeCurrencyResult=function(p,f,M,o){var s=o.minusSign;p=p.replace(/[0#.,]+/,f);if(o.showMeasure&&M){var P="\u00a4",h={"[:digit:]":/\d/,"[:^S:]":/[^\$\xA2-\xA5\u058F\u060B\u09F2\u09F3\u09FB\u0AF1\u0BF9\u0E3F\u17DB\u20A0-\u20BD\uA838\uFDFC\uFE69\uFF04\uFFE0\uFFE1\uFFE5\uFFE6]/},i=p.indexOf(P),j=i<p.length/2?"after":"before",S=this.oLocaleData.getCurrencySpacing(j),C=(j==="after"?M.charAt(M.length-1):M.charAt(0)),k,l=h[S.currencyMatch],t=h[S.surroundingMatch],I;p=p.replace(P,M);k=(j==="after"?p.charAt(i+M.length):p.charAt(i-1));if(l&&l.test(C)&&t&&t.test(k)){if(j==="after"){I=i+M.length;}else{I=i;}p=p.slice(0,I)+S.insertBetween+p.slice(I);}else if(o.negative&&j==="after"){s="\ufeff"+o.minusSign;}}else{p=p.replace(/\s*\u00a4\s*/,"");}if(o.negative){p=p.replace(/-/,s);}return p;};
N.prototype.parse=function(v){var o=this.oFormatOptions,p=d(o.plusSign+o.minusSign),G=d(o.groupingSeparator),D=d(o.decimalSeparator),s="^\\s*(["+p+"]?(?:[0-9"+G+"]+|[0-9"+G+"]*"+D+"[0-9]*)(?:[eE][+-][0-9]+)?)\\s*$",f="^\\s*(["+p+"]?[0-9"+G+"]+)\\s*$",h=new RegExp(G,"g"),i=new RegExp(D,"g"),P=this.oLocaleData.getPercentPattern(),j=this.oLocaleData.getNumberSymbol("percentSign"),k,l,t,u,w,C,x=0,S,E;if(v===""){E=o.emptyString;if(o.parseAsString&&(o.emptyString===0||isNaN(o.emptyString))){E=o.emptyString+"";}if(o.type===n.CURRENCY){return[E,undefined];}else{return E;}}if(P.charAt(0)==="%"){s=s.slice(0,1)+"%?"+s.slice(1);}else if(P.charAt(P.length-1)==="%"){s=s.slice(0,s.length-1)+"%?"+s.slice(s.length-1);}v=v.replace(/\s/g,"");S=b(v,this.oFormatOptions.style,this.oLocaleData);if(S){v=S.number;k=new RegExp(s);}else if(o.isInteger){k=new RegExp(f);}else if(o.type===n.CURRENCY){u="[^\\d\\s+-]*";t="(?:^("+u+")"+s.substring(1,s.length-1)+"$)|(?:^"+s.substring(1,s.length-1)+"("+u+")\\s*$)";k=new RegExp(t);}else{k=new RegExp(s);}if(!k.test(v)){return o.type===n.CURRENCY?null:NaN;}if(o.type===n.CURRENCY){w=k.exec(v);if(w[2]){v=w[2];C=w[1]||undefined;}else{v=w[3];C=w[4]||undefined;}if(C&&!o.showMeasure){return null;}}if(C){C=this.oLocaleData.getCurrencyCodeBySymbol(C)||C;}v=v.replace(h,"");v=v.replace(o.plusSign,"+");v=v.replace(o.minusSign,"-");v=v.replace(/^\+/,"");if(S){v=v.replace(i,".");v=N._shiftDecimalPoint(v,Math.round(Math.log(S.factor)/Math.LN10));}if(o.isInteger){x=o.parseAsString?v:parseInt(v,10);}else{v=v.replace(i,".");if(v.indexOf(j)!==-1){l=true;v=v.replace(j,"");}x=o.parseAsString?v:parseFloat(v);if(l){x=N._shiftDecimalPoint(x,-2);}}if(o.parseAsString){x=N._shiftDecimalPoint(v,0);}return o.type===n.CURRENCY?[x,C]:x;};
N.prototype.convertToDecimal=function(v){var V=""+v,f,s,D,F,E,p;if(V.indexOf("e")==-1&&V.indexOf("E")==-1){return V;}var h=V.match(/^([+-]?)((\d+)(?:\.(\d+))?)[eE]([+-]?\d+)$/);f=h[1]=="-";s=h[2].replace(/\./g,"");D=h[3]?h[3].length:0;F=h[4]?h[4].length:0;E=parseInt(h[5],10);if(E>0){if(E<F){p=D+E;V=s.substr(0,p)+"."+s.substr(p);}else{V=s;E-=F;for(var i=0;i<E;i++){V+="0";}}}else{if(-E<D){p=D+E;V=s.substr(0,p)+"."+s.substr(p);}else{V=s;E+=D;for(var i=0;i>E;i--){V="0"+V;}V="0."+V;}}if(f){V="-"+V;}return V;};
N.prototype.getScale=function(){if((this.oFormatOptions.style!=="short"&&this.oFormatOptions.style!=="long")||this.oFormatOptions.shortRefNumber===undefined){return;}var s=g(this.oFormatOptions.shortRefNumber,this.oFormatOptions,this.oLocaleData),S;if(s&&s.formatString){S=s.formatString.replace(r,"").replace(/'.'/g,".").trim();if(S){return S;}}};
N._shiftDecimalPoint=function(v,s){if(typeof s!=="number"){return NaN;}var E=v.toString().toLowerCase().split("e");if(typeof v==="number"){s=E[1]?(+E[1]+s):s;return+(E[0]+"e"+s);}else if(typeof v==="string"){if(parseInt(v,10)===0&&s>=0){return v;}v=E[0];var D=v.indexOf("."),A,i,f;if(D===-1){v=v+".";D=v.length-1;}if(E[1]){D+=(+E[1]);}A=D+s;if(A<=0){v=q.sap.padLeft(v,'0',v.length-A+1);A=1;}else if(A>=v.length-1){v=q.sap.padRight(v,'0',A+1);A=v.length-1;}v=v.replace(".","");i=v.substring(0,A);f=v.substring(A);i=i.replace(/^(-?)0+(\d)/,"$1$2");return i+(f?("."+f):"");}else{return null;}};
function g(v,o,l){var s,k,K,S=o.style,p=o.precision!==undefined?o.precision:2;if(S!="short"&&S!="long"){return undefined;}for(var i=0;i<14;i++){k=Math.pow(10,i);if(c(Math.abs(v)/k,p-1)<10){break;}}K=k.toString();var C=l.getDecimalFormat(S,K,"other");if(!C||C=="0"){return undefined;}else{s={};s.key=K;s.formatString=C;var f=C.match(r);if(f){s.valueSubString=f[0];var h=s.valueSubString.indexOf(".");if(h==-1){s.decimals=0;s.magnitude=k*Math.pow(10,1-s.valueSubString.length);}else{s.decimals=s.valueSubString.length-h-1;s.magnitude=k*Math.pow(10,1-h);}}else{return undefined;}}return s;}
function b(v,s,l){if(s!="short"&&s!="long"){return;}var f,F=1,k=10,p=l.getPluralCategories(),C,G=function(P){C=l.getDecimalFormat(s,k.toString(),P);if(C){C=C.replace(/[\s\u00a0]/g,"");C=C.replace(/'.'/g,".");var h=C.match(r);if(h){var V=h[0];var u=C.replace(V,"");if(!u){return;}var i=v.indexOf(u);if(i>=0){f=v.replace(u,"");F=k;return true;}}}};while(k<1e14){if(p.some(G)){break;}k=k*10;}if(!f){return;}return{number:f,factor:F};}
function c(v,M,s){if(typeof v!=="number"){return NaN;}s=s||N.RoundingMode.HALF_AWAY_FROM_ZERO;M=parseInt(M,10);if(typeof s==="function"){v=s(v,M);}else{if(!M){return m[s](v);}v=N._shiftDecimalPoint(m[s](N._shiftDecimalPoint(v,M)),-M);}return v;}
function d(s){return s.replace(/([.?*+^$[\]\\(){}|-])/g,"\\$1");}
function e(v,p){var i=Math.floor(Math.log(Math.abs(v))/Math.LN10);return Math.max(0,p-i-1);}
return N;});
sap.ui.predefine('sap/ui/core/message/MessageMixin',[],function(){"use strict";var M=function(){this.refreshDataState=r;};
function r(n,d){if(d.getChanges().messages){var m=d.getMessages();var l=sap.ui.core.LabelEnablement.getReferencingLabels(this);if(l&&l.length>0){var L=l[0];m.forEach(function(a){var b=sap.ui.getCore().byId(L);if(b.getMetadata().isInstanceOf("sap.ui.core.Label")&&b.getText){a.setAdditionalText(b.getText());}else{jQuery.sap.log.warning("sap.ui.core.message.Message: Can't create labelText."+"Label with id "+L+" is no valid sap.ui.core.Label.",this);}}.bind(this));}var o=sap.ui.getCore().getMessageManager().getMessageModel();o.checkUpdate();if(m&&m.length>0){var a=m[0];if(sap.ui.core.ValueState[a.type]){this.setValueState(a.type);this.setValueStateText(a.message);}}else{this.setValueState(sap.ui.core.ValueState.None);this.setValueStateText('');}}}
return M;},true);
sap.ui.predefine('sap/ui/core/message/MessageParser',["jquery.sap.global","sap/ui/base/Object"],function(q,O){"use strict";
var M=O.extend("sap.ui.core.message.MessageParser",{
metadata:{publicMethods:["parse","setProcessor"]},
constructor:function(){this._processor=null;}
});
M.prototype.setProcessor=function(p){this._processor=p;return this;};
M.prototype.getProcessor=function(){return this._processor;};
M.prototype.parse=function(r){q.sap.log.error("MessageParser: parse-method must be implemented in the specific parser class. Messages "+"have been ignored.");};
return M;});
sap.ui.predefine('sap/ui/core/mvc/Controller',['jquery.sap.global','sap/ui/base/EventProvider','sap/ui/base/ManagedObject'],function(q,E,M){"use strict";var r={};
var C=E.extend("sap.ui.core.mvc.Controller",{constructor:function(n){var t=null;if(typeof(n)=="string"){if(!r[n]){q.sap.require({modName:n,type:"controller"});if(!r[n]){throw new Error("Controller type "+n+" is still undefined after trying to load it.");}}t=r[n];}E.apply(this,arguments);if(t){q.extend(this,r[n]);}}});
var c={"onInit":true,"onExit":false,"onBeforeRendering":false,"onAfterRendering":true};
function m(o,a){for(var b in a){if(c[b]!==undefined){var O=o[b];if(O&&typeof O==="function"){(function(f,O,d){o[b]=function(){if(d){O.apply(o,arguments);f.apply(o,arguments);}else{f.apply(o,arguments);O.apply(o,arguments);}};})(a[b],O,c[b]);}else{o[b]=a[b];}}else{o[b]=a[b];}}}
C.extendIfRequired=function(o,n,a){var b;var d=sap.ui.require('sap/ui/core/CustomizingConfiguration');if(d){var e=d.getControllerExtension(n,M._sOwnerId);if(e){var s=typeof e==="string"?e:e.controllerName;var f=e.controllerNames||[];if(s){s&&f.unshift(s);}for(var i=0,l=f.length;i<l;i++){var g=f[i];if(typeof g==="string"){q.sap.log.info("Customizing: Controller '"+n+"' is now extended by '"+g+"'");if(!r[g]&&!q.sap.getObject(g)){q.sap.require({modName:g,type:"controller"});}if(!r[g]&&!q.sap.getObject(g)){q.sap.log.error("Attempt to load Extension Controller "+g+" was not successful - is the Controller correctly defined in its file?");}if((b=r[g])!==undefined){m(o,b);}}}}else{q.sap.log.debug("Customizing: no Controller extension found for Controller '"+n+"'.");}}if(C._sExtensionProvider){q.sap.require(C._sExtensionProvider);var h=q.sap.getObject(C._sExtensionProvider);if(h){q.sap.log.info("Customizing: Controller '"+n+"' is now extended by Controller Extension Provider '"+C._sExtensionProvider+"'");var j=new h();var k=j.getControllerExtensions(n,M._sOwnerId,a);if(k instanceof Promise){return k.then(function(p){if(p&&p.length){for(var i=0,l=p.length;i<l;i++){m(o,p[i]);}}return o;},function(p){q.sap.log.error("Controller Extension Provider: Error '"+p+"' thrown in "+C._sExtensionProvider+"; extension provider ignored.");return o;});}else{if(k&&k.length){for(var i=0,l=k.length;i<l;i++){m(o,k[i]);}}}}else{q.sap.log.error("Controller Extension Provider: Extension Provider "+C._sExtensionProvider+" could not be found");}}return o;};
sap.ui.controller=function(n,o){if(!n){throw new Error("Controller name ('sName' parameter) is required");}var e=true;if(typeof o==="boolean"){e=!o;o=undefined;}if(!o){if(!r[n]&&!q.sap.getObject(n)){q.sap.require({modName:n,type:"controller"});}if(r[n]){var a=new C(n);if(e){C.extendIfRequired(a,n);}return a;}else{var b=q.sap.getObject(n);if(typeof b==="function"&&b.prototype instanceof C){var a=new b();if(e){C.extendIfRequired(a,n);}return a;}}throw new Error("Controller "+n+" couldn't be instantiated");}else{r[n]=o;}};
C.prototype.getView=function(){return this.oView;};
C.prototype.byId=function(i){return this.oView?this.oView.byId(i):undefined;};
C.prototype.createId=function(i){return this.oView?this.oView.createId(i):undefined;};
C.prototype.getOwnerComponent=function(){var a=sap.ui.requireSync("sap/ui/core/Component");return a.getOwnerComponentFor(this.getView());};
C.prototype.connectToView=function(v){this.oView=v;if(this.onInit){v.attachAfterInit(this.onInit,this);}if(this.onExit){v.attachBeforeExit(this.onExit,this);}if(this.onAfterRendering){v.attachAfterRendering(this.onAfterRendering,this);}if(this.onBeforeRendering){v.attachBeforeRendering(this.onBeforeRendering,this);}};
C._sExtensionProvider=null;
C.registerExtensionProvider=function(e){C._sExtensionProvider=e;};
return C;});
sap.ui.predefine('sap/ui/core/mvc/HTMLView',['jquery.sap.global','sap/ui/base/ManagedObject','sap/ui/core/DeclarativeSupport','sap/ui/core/library','sap/ui/model/resource/ResourceModel','./View'],function(q,M,D,l,R,V){"use strict";var a=l.mvc.ViewType;
var H=V.extend("sap.ui.core.mvc.HTMLView",{metadata:{library:"sap.ui.core"}});
sap.ui.htmlview=function(i,v){return sap.ui.view(i,v,a.HTML);};
H._sType=a.HTML;H.asyncSupport=true;H._mTemplates={};H._mAllowedSettings={"viewName":true,"controller":true,"viewContent":true,"controllerName":true,"resourceBundleName":true,"resourceBundleUrl":true,"resourceBundleLocale":true,"resourceBundleAlias":true};
H._getTemplate=function(t,o){var u=this._getViewUrl(t);var h=this._mTemplates[u];if(!h){h=this._loadTemplate(t,o);if(o&&o.async){var b=this;return h.then(function(_){b._mTemplates[u]=_;return Promise.resolve(_);});}else{this._mTemplates[u]=h;}}return o.async?Promise.resolve(h):h;};
H.prototype.getControllerName=function(){return this._controllerName;};
H._getViewUrl=function(t){return q.sap.getModulePath(t,".view.html");};
H._loadTemplate=function(t,o){var r=q.sap.getResourceName(t,".view.html");return q.sap.loadResource(r,o);};
H.prototype.initViewSettings=function(s){if(!s){throw new Error("mSettings must be given");}if(s.viewName&&s.viewContent){throw new Error("View name and view content are given. There is no point in doing this, so please decide.");}else if(!s.viewName&&!s.viewContent){throw new Error("Neither view name nor view content is given. One of them is required.");}var t=this;function I(){t._oTemplate=document.createElement("div");if(typeof h==="string"){t._oTemplate.innerHTML=h;}else{var n=h;var f=document.createDocumentFragment();for(var i=0;i<n.length;i++){f.appendChild(n.item(i));}t._oTemplate.appendChild(f);}var m=t._oTemplate.getElementsByTagName("template")[0];var p=t.getMetadata().getAllProperties();if(m){q.each(m.attributes,function(c,A){var N=D.convertAttributeToSettingName(A.name,t.getId());var v=A.value;var P=p[N];if(!s[N]){if(P){s[N]=D.convertValueToType(D.getPropertyDataType(P),v);}else if(H._mAllowedSettings[N]){s[N]=v;}}});t._oTemplate=m;}if(t._oTemplate.content){var f=t._oTemplate.content;t._oTemplate=document.createElement("div");t._oTemplate.appendChild(f);}if(s.controllerName){t._controllerName=s.controllerName;}if((s.resourceBundleName||s.resourceBundleUrl)&&(!s.models||!s.models[s.resourceBundleAlias])){var b=new R({bundleName:s.resourceBundleName,bundleUrl:s.resourceBundleUrl,bundleLocale:s.resourceBundleLocale});t.setModel(b,s.resourceBundleAlias);}}var h=s.viewContent;if(!h){h=H._getTemplate(s.viewName,{async:s.async});}if(s.async){return h.then(function(_){h=_;I();});}I();};
H.prototype.onControllerConnected=function(c){var t=this;M.runWithPreprocessors(function(){D.compile(t._oTemplate,t);},{settings:this._fnSettingsPreprocessor});};
H.prototype.exit=function(){this._oTemplate=null;V.prototype.exit.call(this);if(this._connectedControls){for(var i=0;i<this._connectedControls.length;i++){this._connectedControls[i].destroy();}this._connectedControls=null;}};
H.prototype.connectControl=function(c){this._connectedControls=this._connectedControls||[];this._connectedControls.push(c);};
return H;});
sap.ui.predefine('sap/ui/core/mvc/HTMLViewRenderer',['jquery.sap.global','./ViewRenderer'],function(q,V){"use strict";var H={};
H.render=function(r,c){var a=r;a.write("<div");a.writeControlData(c);a.addClass("sapUiView");a.addClass("sapUiHTMLView");V.addDisplayClass(a,c);if(c.getWidth()){a.addStyle("width",c.getWidth());}if(c.getHeight()){a.addStyle("height",c.getHeight());}a.writeStyles();a.writeClasses();a.write(">");if(c._oTemplate){var h=c._oTemplate.innerHTML;var b=c.getContent();var d=[];var e=function(c){var t=H._getHTML(a,c,h);if(t){h=t;}else{d.push(c);}};if(b){if(Array.isArray(b)){for(var i=0;i<b.length;i++){e(b[i]);}}else if(b){e(b);}}a.write(h);for(var i=0;i<d.length;i++){a.renderControl(d[i]);}}a.write("</div>");};
H._getHTML=function(r,c,h){var i=c.getId();h=h.replace(/(<div)/gi,"\n$1");var a=new RegExp('<div.*?data-sap-ui-id="'+i+'".*?></div>',"gi");var m=a.exec(h);if(m){h=h.replace(m[0],r.getHTML(c));return h;}else{return"";}};
return H;},true);
sap.ui.predefine('sap/ui/core/mvc/JSONView',['jquery.sap.global','sap/ui/base/ManagedObject','sap/ui/core/library','sap/ui/model/resource/ResourceModel','./View'],function(q,M,l,R,V){"use strict";var a=l.mvc.ViewType;
var J=V.extend("sap.ui.core.mvc.JSONView",{metadata:{library:"sap.ui.core"}});
sap.ui.jsonview=function(i,v){return sap.ui.view(i,v,a.JSON);};
J._sType=a.JSON;J.asyncSupport=true;
J.prototype.initViewSettings=function(s){if(!s){throw new Error("mSettings must be given");}if(s.viewName&&s.viewContent){throw new Error("View name and view content are given. There is no point in doing this, so please decide.");}else if(!s.viewName&&!s.viewContent){throw new Error("Neither view name nor view content is given. One of them is required.");}var t=this;var i=function(){if((t._oJSONView.resourceBundleName||t._oJSONView.resourceBundleUrl)&&(!s.models||!s.models[t._oJSONView.resourceBundleAlias])){var m=new R({bundleName:t._oJSONView.resourceBundleName,bundleUrl:t._oJSONView.resourceBundleUrl});t.setModel(m,t._oJSONView.resourceBundleAlias);}};if(s.viewName){if(s.async){return this._loadTemplate(s.viewName,{async:true}).then(i);}else{this._loadTemplate(s.viewName);i();}}else if(s.viewContent){this.mProperties["viewContent"]=s.viewContent;if(typeof s.viewContent==="string"){this._oJSONView=q.parseJSON(s.viewContent);if(!this._oJSONView){throw new Error("error when parsing viewContent: "+s.viewContent);}}else if(typeof s.viewContent==="object"){this._oJSONView=s.viewContent;}else{throw new Error("viewContent must be a JSON string or object, but is a "+(typeof s.viewContent));}if(s.async){return Promise.resolve().then(i);}else{i();}}};
J.prototype.onControllerConnected=function(c){var t=this;M.runWithPreprocessors(function(){t.applySettings({content:t._oJSONView.content},c);},{id:function(i){return t.createId(i);},settings:function(s){var m=this.getMetadata(),v=m.getJSONKeys(),k,o,K;for(k in s){if((K=v[k])!==undefined){o=s[k];switch(K._iKind){case 3:if(typeof o==="string"){s[k]=t.createId(o);}break;case 5:if(typeof o==="string"){s[k]=V._resolveEventHandler(o,c);}break;}}}}});};
J.prototype._loadTemplate=function(t,o){var r=q.sap.getResourceName(t,".view.json");if(!o||!o.async){this._oJSONView=q.sap.loadResource(r);}else{var b=this;return q.sap.loadResource(r,o).then(function(j){b._oJSONView=j;});}};
J.prototype.getControllerName=function(){return this._oJSONView.controllerName;};
return J;});
sap.ui.predefine('sap/ui/core/mvc/JSONViewRenderer',['./ViewRenderer','sap/ui/core/Control'],function(V,C){"use strict";var J={};
J.render=function(r,c){var a=r;a.write("<div");a.writeControlData(c);a.addClass("sapUiView");a.addClass("sapUiJSONView");V.addDisplayClass(a,c);if(c.getWidth()){a.addStyle("width",c.getWidth());}if(c.getHeight()){a.addStyle("height",c.getHeight());}a.writeStyles();a.writeClasses();a.write(">");var b=c.getContent();if(b){if(b instanceof Array&&!(b instanceof C)){for(var i=0;i<b.length;i++){a.renderControl(b[i]);}}else{a.renderControl(c.getContent());}}a.write("</div>");};
return J;},true);
sap.ui.predefine('sap/ui/core/mvc/JSView',['jquery.sap.global','sap/ui/core/library','./View','sap/ui/base/ManagedObject'],function(q,l,V,M){"use strict";
var J=V.extend("sap.ui.core.mvc.JSView",{metadata:{library:"sap.ui.core"}});
(function(){var r={};J.asyncSupport=true;
sap.ui.jsview=function(i,v,a){var s={},o;if(v&&typeof(v)=="string"){s.viewName=v;if(typeof arguments[2]=="boolean"){s.async=a;}else if(typeof arguments[2]=="object"){s.controller=arguments[2];s.async=!!arguments[3];}o=new J(i,s);return o;}else if(v&&typeof(v)=="object"){r[i]=v;q.sap.declare({modName:i,type:"view"},false);}else if(arguments.length==1&&typeof i=="string"||arguments.length==2&&typeof arguments[0]=="string"&&typeof arguments[1]=="boolean"){s.viewName=arguments[0];s.async=!!arguments[1];o=s.id?new J(s.id,s):new J(s);return o;}else{throw new Error("Wrong arguments ('"+i+"', '"+v+"')! Either call sap.ui.jsview([sId,] sViewName) to instantiate a View or sap.ui.jsview(sViewName, oViewImpl) to define a View type.");}};
J.prototype.initViewSettings=function(s){var p;if(!r[s.viewName]&&s.async){p=new Promise(function(a){var m=q.sap.getResourceName(s.viewName,".view");sap.ui.require([m],a);});}else if(!r[s.viewName]){q.sap.require({modName:s.viewName,type:"view"});}q.extend(this,r[s.viewName]);if(s.async){return p||Promise.resolve();}};
J.prototype.onControllerConnected=function(c){var t=this;var p={};if(this.getAutoPrefixId()){p.id=function(i){return t.createId(i);};}p.settings=this._fnSettingsPreprocessor;M.runWithPreprocessors(function(){t.applySettings({content:t.createContent(c)});},p);};
J.prototype.getAutoPrefixId=function(){return false;};
}());return J;});
sap.ui.predefine('sap/ui/core/mvc/JSViewRenderer',['jquery.sap.global','./ViewRenderer'],function(q,V){"use strict";var J={};
J.render=function(r,c){var a=r;a.write("<div");a.writeControlData(c);a.addClass("sapUiView");a.addClass("sapUiJSView");V.addDisplayClass(a,c);if(c.getWidth()){a.addStyle("width",c.getWidth());}if(c.getHeight()){a.addStyle("height",c.getHeight());}a.writeStyles();a.writeClasses();a.write(">");var b=c.getContent();if(b){if(Array.isArray(b)){for(var i=0;i<b.length;i++){a.renderControl(b[i]);}}else if(b){a.renderControl(b);}}a.write("</div>");};
return J;},true);
sap.ui.predefine('sap/ui/core/mvc/TemplateView',['jquery.sap.global','sap/ui/core/library','./View'],function(q,l,V){"use strict";var a=l.mvc.ViewType;
var T=V.extend("sap.ui.core.mvc.TemplateView",{metadata:{library:"sap.ui.core"}});
(function(){
sap.ui.templateview=function(i,v){return sap.ui.view(i,v,a.Template);};
T._sType=a.Template;
T.prototype.getControllerName=function(){return this._sControllerName;};
T._getViewUrl=function(t){return q.sap.getModulePath(t,".view.tmpl");};
T.prototype.initViewSettings=function(s){if(!s){throw new Error("mSettings must be given");}if(!s.viewName){throw new Error("No view name is given.");}this._oTemplate=sap.ui.template({id:this.getId(),src:T._getViewUrl(s.viewName)});this._sControllerName=this._oTemplate._sControllerName;this._oTemplate=this._oTemplate.createControl(undefined,undefined,this);this.addContent(this._oTemplate);};
}());return T;});
sap.ui.predefine('sap/ui/core/mvc/TemplateViewRenderer',['./ViewRenderer'],function(V){"use strict";var T={};
T.render=function(r,c){var a=r;a.write("<div");a.writeControlData(c);a.addClass("sapUiView");a.addClass("sapUiTmplView");V.addDisplayClass(a,c);a.addStyle("width",c.getWidth());a.addStyle("height",c.getHeight());a.writeStyles();a.writeClasses();a.write(">");a.renderControl(c._oTemplate);a.write("</div>");};
return T;},true);
sap.ui.predefine('sap/ui/core/mvc/View',['jquery.sap.global','sap/ui/base/ManagedObject','sap/ui/core/Control','sap/ui/core/mvc/Controller','sap/ui/core/library'],function(q,M,C,a,b){"use strict";var V=b.mvc.ViewType;
var c=C.extend("sap.ui.core.mvc.View",{metadata:{library:"sap.ui.core",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},viewName:{type:"string",group:"Misc",defaultValue:null},displayBlock:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}},events:{afterInit:{},beforeExit:{},afterRendering:{},beforeRendering:{}},specialSettings:{controller:'sap.ui.core.mvc.Controller',controllerName:'string',preprocessors:'Object',resourceBundleName:'string',resourceBundleUrl:'sap.ui.core.URI',resourceBundleLocale:'string',resourceBundleAlias:'string',type:'string',viewContent:'any',viewData:'any',async:{type:"boolean",defaultValue:false}}}});
c._mPreprocessors={};
function d(p){p._settings={};for(var P in p){if(P.indexOf("_")!==0){p._settings[P]=p[P];}}}
function r(p){if(typeof p.preprocessor==="string"){q.sap.require(p.preprocessor);p.preprocessor=q.sap.getObject(p.preprocessor);}else if(typeof p.preprocessor==="function"&&!p.preprocessor.process){p.preprocessor={process:p.preprocessor};}}
function g(L,G){var i,l,O,p=[];for(i=0,l=G.length;i<l;i++){if(G[i]._onDemand){O=G[i];}else{p.push(G[i]);}}for(i=0,l=L.length;i<l;i++){var I=!L[i].preprocessor;if(I&&O){p.unshift(q.extend(L[i],O));}else if(!I){p.push(L[i]);}}return p;}
function e(v,s){var i=v.getMetadata().getClass(),G=c._mPreprocessors[i._sType]||{};v.mPreprocessors=q.extend({},s.preprocessors);for(var _ in i.PreprocessorType){var t=i.PreprocessorType[_];if(v.mPreprocessors[t]&&!Array.isArray(v.mPreprocessors[t])){v.mPreprocessors[t]=[v.mPreprocessors[t]];}else if(!v.mPreprocessors[t]){v.mPreprocessors[t]=[];}v.mPreprocessors[t].forEach(d);v.mPreprocessors[t]=g(v.mPreprocessors[t],G[t]||[]);v.mPreprocessors[t].forEach(r);}}
function f(v){v.oAsyncState={};v.oAsyncState.promise=null;}
c.prototype._initCompositeSupport=function(s){this.oViewData=s.viewData;this.sViewName=s.viewName;var t=this;e(this,s);if(s.async){f(this);}var i=sap.ui.require('sap/ui/core/CustomizingConfiguration');if(i&&i.hasCustomProperties(this.sViewName,this)){this._fnSettingsPreprocessor=function(s){var j=this.getId();if(i&&j){if(t.isPrefixedId(j)){j=j.substring((t.getId()+"--").length);}var l=i.getCustomProperties(t.sViewName,j,t);if(l){s=q.extend(s,l);}}};}var p=function(j){var l=sap.ui.require("sap/ui/core/Component");var O=l&&l.getOwnerComponentFor(t);if(O){return O.runAsOwner(j);}else{return j.call();}};var I=function(){var P=h(t,s);if(P instanceof Promise){return P.then(function(){if(t.onControllerConnected){p(function(){t.onControllerConnected(t.oController);});}});}else{if(t.onControllerConnected){t.onControllerConnected(t.oController);}}};if(this.initViewSettings){if(s.async){this.oAsyncState.promise=this.initViewSettings(s).then(function(){return p(I);}).then(function(){return t.runPreprocessor("controls",t);}).then(function(){return p(t.fireAfterInit.bind(t));}).then(function(){return t;});}else{this.initViewSettings(s);I();this.runPreprocessor("controls",this,true);this.fireAfterInit();}}};
c.prototype.getController=function(){return this.oController;};
c.prototype.byId=function(i){return sap.ui.getCore().byId(this.createId(i));};
c.prototype.createId=function(i){if(!this.isPrefixedId(i)){i=this.getId()+"--"+i;}return i;};
c.prototype.getLocalId=function(i){var p=this.getId()+"--";return(i&&i.indexOf(p)===0)?i.slice(p.length):null;};
c.prototype.isPrefixedId=function(i){return!!(i&&i.indexOf(this.getId()+"--")===0);};
var h=function(t,s){if(!sap.ui.getCore().getConfiguration().getControllerCodeDeactivated()){var i=s.controller,n=i&&typeof i.getMetadata==="function"&&i.getMetadata().getName();if(!i&&t.getControllerName){var j=t.getControllerName();if(j){var l=sap.ui.require('sap/ui/core/CustomizingConfiguration');var p=l&&l.getControllerReplacement(j,M._sOwnerId);if(p){j=typeof p==="string"?p:p.controllerName;}i=sap.ui.controller(j,true);n=j;}}if(i){i=a.extendIfRequired(i,n,!!t.oAsyncState);if(i instanceof Promise){if(!t.oAsyncState){throw new Error("The view "+t.sViewName+" runs in sync mode and therefore cannot use async controller extensions!");}return i.then(function(i){t.oController=i;i.connectToView(t);});}else{t.oController=i;i.connectToView(t);}}}else{t.oController={};}};
c.prototype.getViewData=function(){return this.oViewData;};
function k(){this.oAsyncState=null;}
c.prototype.exit=function(){this.fireBeforeExit();delete this.oController;delete this.oPreprocessorInfo;if(this.oAsyncState){var D=k.bind(this);this.oAsyncState.promise.then(D,D);}};
c.prototype.onAfterRendering=function(){this.fireAfterRendering();};
c.prototype.onBeforeRendering=function(){this.fireBeforeRendering();};
c.prototype.clone=function(i,l){var s={},K,n;for(K in this.mProperties&&!(this.isBound&&this.isBound(K))){if(this.mProperties.hasOwnProperty(K)){s[K]=this.mProperties[K];}}n=C.prototype.clone.call(this,i,l,{cloneChildren:false,cloneBindings:true});var E,p,j;for(E in n.mEventRegistry){p=n.mEventRegistry[E];for(j=p.length-1;j>=0;j--){if(p[j].oListener===this.getController()){p[j]={oListener:n.getController(),fFunction:p[j].fFunction,oData:p[j].oData};}}}n.applySettings(s);return n;};
c.prototype.getPreprocessorInfo=function(s){if(!this.oPreprocessorInfo){this.oPreprocessorInfo={name:this.sViewName,componentId:this._sOwnerId,id:this.getId(),caller:this+" ("+this.sViewName+")",sync:!!s};}if(c._supportInfo){this.oPreprocessorInfo._supportInfo=c._supportInfo;}return this.oPreprocessorInfo;};
c.prototype.runPreprocessor=function(t,s,S){var v=this.getPreprocessorInfo(S),p=this.mPreprocessors&&this.mPreprocessors[t]||[],j,P,A,n;if(!S){A=function(u){return P(u,v,j);};n=Promise.resolve(s);}for(var i=0,l=p.length;i<l;i++){P=p[i].preprocessor.process;if(S&&p[i]._syncSupport===true){s=P(s,v,p[i]._settings);}else if(!S){j=p[i]._settings;n=n.then(A);}else{q.sap.log.debug("Async \""+t+"\"-preprocessor was skipped in sync view execution for "+this.getMetadata().getClass()._sType+"View",this.getId());}}return S?s:n;};
function m(t,v){if(!c._mPreprocessors[v]){c._mPreprocessors[v]={};}if(!c._mPreprocessors[v][t]){c._mPreprocessors[v][t]=[];}}
function o(v,s,t){c._mPreprocessors[s][t].forEach(function(p){if(p._onDemand){q.sap.log.error("Registration for \""+t+"\" failed, only one on-demand-preprocessor allowed",v.getMetadata().getName());return false;}});return true;}
c.registerPreprocessor=function(t,p,v,s,O,S){if(typeof O!=="boolean"){S=O;O=false;}if(p){m(t,v);if(O&&!o(this,v,t)){return;}c._mPreprocessors[v][t].push({preprocessor:p,_onDemand:O,_syncSupport:s,_settings:S});q.sap.log.debug("Registered "+(O?"on-demand-":"")+"preprocessor for \""+t+"\""+(s?" with syncSupport":""),this.getMetadata().getName());}else{q.sap.log.error("Registration for \""+t+"\" failed, no preprocessor specified",this.getMetadata().getName());}};
c.prototype.hasPreprocessor=function(t){return!!this.mPreprocessors[t].length;};
sap.ui.view=function(i,v,t){var j=null,l={};if(typeof i==="object"||typeof i==="string"&&v===undefined){v=i;i=undefined;}if(v){if(typeof v==="string"){l.viewName=v;}else{l=v;}}if(i){l.id=i;}if(t){l.type=t;}var n=sap.ui.require('sap/ui/core/CustomizingConfiguration');if(n){var p=n.getViewReplacement(l.viewName,M._sOwnerId);if(p){q.sap.log.info("Customizing: View replacement for view '"+l.viewName+"' found and applied: "+p.viewName+" (type: "+p.type+")");q.extend(l,p);}else{q.sap.log.debug("Customizing: no View replacement found for view '"+l.viewName+"'.");}}if(!l.type){throw new Error("No view type specified.");}else if(l.type===V.JS){var J=sap.ui.requireSync('sap/ui/core/mvc/JSView');j=new J(l);}else if(l.type===V.JSON){var s=sap.ui.requireSync('sap/ui/core/mvc/JSONView');j=new s(l);}else if(l.type===V.XML){var X=sap.ui.requireSync('sap/ui/core/mvc/XMLView');j=new X(l);}else if(l.type===V.HTML){var H=sap.ui.requireSync('sap/ui/core/mvc/HTMLView');j=new H(l);}else if(l.type===V.Template){var T=sap.ui.requireSync('sap/ui/core/mvc/TemplateView');j=new T(l);}else{throw new Error("Unknown view type "+l.type+" specified.");}return j;};
c.prototype.loaded=function(){if(!this.oAsyncState||!this.oAsyncState.promise){return Promise.resolve(this);}else{return this.oAsyncState.promise;}};
c._resolveEventHandler=function(n,i){var H;if(!sap.ui.getCore().getConfiguration().getControllerCodeDeactivated()){switch(n.indexOf('.')){case 0:H=i&&q.sap.getObject(n.slice(1),undefined,i);break;case-1:H=i&&i[n];if(H!=null){break;}default:H=q.sap.getObject(n);}}else{H=function(){};}if(typeof H==="function"){H._sapui_handlerName=n;return[H,i];}};
return c;});
sap.ui.predefine('sap/ui/core/mvc/ViewRenderer',function(){"use strict";var V={};
V.addDisplayClass=function(r,c){if(c.getDisplayBlock()||(c.getWidth()==="100%"&&c.getHeight()==="100%")){r.addClass("sapUiViewDisplayBlock");}};
return V;},true);
sap.ui.predefine('sap/ui/core/mvc/XMLView.designtime',[],function(){"use strict";return{aggregations:{content:{domRef:":sap-domref"}}};},false);
sap.ui.predefine('sap/ui/core/mvc/XMLView',['jquery.sap.global','sap/ui/core/XMLTemplateProcessor','sap/ui/core/library','./View','sap/ui/model/resource/ResourceModel','sap/ui/base/ManagedObject','sap/ui/core/Control','sap/ui/core/RenderManager','sap/ui/core/cache/CacheManager','jquery.sap.xml','jquery.sap.script'],function(q,X,l,V,R,M,C,a,b){"use strict";var c=a.RenderPrefixes,d=l.mvc.ViewType;
var f=V.extend("sap.ui.core.mvc.XMLView",{metadata:{library:"sap.ui.core",specialSettings:{containingView:{type:'sap.ui.core.mvc.XMLView',visibility:'hidden'},xmlNode:{type:'Element',visibility:'hidden'},cache:'Object'},designTime:true}});
sap.ui.xmlview=function(i,e){return sap.ui.view(i,e,d.XML);};
f._sType=d.XML;f.asyncSupport=true;f._bUseCache=sap.ui.getCore().getConfiguration().getViewCache();
function v(e){if(e.parseError.errorCode!==0){var P=e.parseError;throw new Error("The following problem occurred: XML parse Error for "+P.url+" code: "+P.errorCode+" reason: "+P.reason+" src: "+P.srcText+" line: "+P.line+" linepos: "+P.linepos+" filepos: "+P.filepos);}}
function g(o,S){if(!S){throw new Error("mSettings must be given");}else if(S.viewName&&S.viewContent){throw new Error("View name and view content are given. There is no point in doing this, so please decide.");}else if((S.viewName||S.viewContent)&&S.xmlNode){throw new Error("View name/content AND an XML node are given. There is no point in doing this, so please decide.");}else if(!(S.viewName||S.viewContent)&&!S.xmlNode){throw new Error("Neither view name/content nor an XML node is given. One of them is required.");}else if(S.cache&&!(S.cache.keys&&S.cache.keys.length)){throw new Error("No cache keys provided. At least one is required.");}}
function h(o,S){o.mProperties["viewContent"]=S.viewContent;var e=q.sap.parseXML(S.viewContent);v(e);return e.documentElement;}
function s(o,S){if((o._resourceBundleName||o._resourceBundleUrl)&&(!S.models||!S.models[o._resourceBundleAlias])){var e=new R({bundleName:o._resourceBundleName,bundleUrl:o._resourceBundleUrl,bundleLocale:o._resourceBundleLocale});o.setModel(e,o._resourceBundleAlias);}}
function j(o){o.oAfterRenderingNotifier=new y();o.oAfterRenderingNotifier.addDelegate({onAfterRendering:function(){o.onAfterRenderingBeforeChildren();}});}
function k(S){var e=sap.ui.require("sap/ui/core/Component"),o;while(S&&e){var i=e.getOwnerComponentFor(S);if(i){S=o=i;}else{if(S instanceof e){o=S;}S=S.getParent&&S.getParent();}}return o;}
function m(o,e){var i=k(o),z=i?JSON.stringify(i.getManifest()):null,F=r(o,i);F=F.concat(u(),t(o),e.keys);return p(o,F).then(function(K){return{key:K+"("+q.sap.hashCode(z||"")+")",componentManifest:z,additionalData:e.additionalData};});}
function n(K){return K;}
function p(o,F){return Promise.all(F).then(function(K){if(K.every(n)){return K.join('_');}else{var e=new Error("Provided cache keys may not be empty or undefined.");return Promise.reject(e);}});}
function r(o,e){var i=e&&e.getMetadata().getName();return[i||window.location.host+window.location.pathname,o.getId(),sap.ui.getCore().getConfiguration().getLanguageTag()];}
function t(e){var P=V._mPreprocessors["XML"],i=e.getPreprocessorInfo(false),F=[];function z(o){if(o.preprocessor.getCacheKey){F.push(o.preprocessor.getCacheKey(i));}}for(var T in P){P[T].forEach(z);}return F;}
function u(){return sap.ui.getVersionInfo({async:true}).then(function(i){var T="";if(!i.libraries){T=sap.ui.buildinfo.buildtime;}else{i.libraries.forEach(function(L){T+=L.buildTimestamp;});}return T;});}
function w(e,i){var K=e.key;delete e.key;e.xml=q.sap.serializeXML(i);return b.set(K,e);}
function x(e){return b.get(e.key).then(function(i){if(i&&i.componentManifest==e.componentManifest){i.xml=q.sap.parseXML(i.xml,"application/xml").documentElement;if(i.additionalData){q.extend(true,e.additionalData,i.additionalData);}return i;}});}
f.prototype.initViewSettings=function(S){var i=this,_;function o(e){i._xContent=e;if(V._supportInfo){V._supportInfo({context:i._xContent,env:{caller:"view",viewinfo:q.extend(true,{},i),settings:q.extend(true,{},S||{}),type:"xmlview"}});}if(!i.isSubView()){X.parseViewAttributes(e,i,S);}else{delete S.controller;}s(i,S);j(i);}function z(e,G){if(i.hasPreprocessor("viewxml")){X.enrichTemplateIds(e,i);return i.runPreprocessor("viewxml",e,!G);}return e;}function A(e){return i.runPreprocessor("xml",e).then(function(e){return z(e,true);});}function B(F){return q.sap.loadResource(F,{async:true}).then(function(e){return e.documentElement;});}function D(F,e){return B(F).then(A).then(function(G){if(e){w(e,G);}return G;});}function E(F,G){return m(i,G).then(function(e){return x(e).then(function(H){if(!H){return D(F,e);}else{return H.xml;}});}).catch(function(e){q.sap.log.error(e);return D(F);});}this._oContainingView=S.containingView||this;if(this.oAsyncState){this.oAsyncState.suppressPreserve=true;}g(this,S);if(S.viewName){var F=q.sap.getResourceName(S.viewName,".view.xml");if(S.async){if(S.cache&&f._bUseCache){return E(F,S.cache).then(o);}else{return B(F).then(A).then(o);}}else{_=q.sap.loadResource(F).documentElement;}}else if(S.viewContent){if(S.viewContent.nodeType===window.Node.DOCUMENT_NODE){_=S.viewContent.documentElement;}else{_=h(this,S);}}else if(S.xmlNode){_=S.xmlNode;}if(S.async){return A(_).then(o);}else{_=this.runPreprocessor("xml",_,true);_=z(_);o(_);}};
f.prototype.exit=function(){if(this.oAfterRenderingNotifier){this.oAfterRenderingNotifier.destroy();}V.prototype.exit.apply(this,arguments);};
f.prototype.onControllerConnected=function(o){var e=this;M.runWithPreprocessors(function(){e._aParsedContent=X.parseTemplate(e._xContent,e);if(e.oAsyncState){delete e.oAsyncState.suppressPreserve;}},{settings:this._fnSettingsPreprocessor});};
f.prototype.getControllerName=function(){return this._controllerName;};
f.prototype.isSubView=function(){return this._oContainingView!=this;};
f.prototype.onAfterRenderingBeforeChildren=function(){if(this._$oldContent.length!==0){var e=this.getAggregation("content");if(e){for(var i=0;i<e.length;i++){var o=e[i].getDomRef()||q.sap.domById(c.Invisible+e[i].getId());if(o){q.sap.byId(c.Dummy+e[i].getId(),this._$oldContent).replaceWith(o);}}}q.sap.byId(c.Dummy+this.getId()).replaceWith(this._$oldContent);}this._$oldContent=undefined;};
f.prototype._onChildRerenderedEmpty=function(o,e){q(e).replaceWith('<div id="'+c.Dummy+o.getId()+'" class="sapUiHidden"/>');return true;};
f.prototype.destroy=function(S){var $=a.findPreservedContent(this.getId());if($){$.remove();}if(S=="KeepDom"&&this.getDomRef()){this.getDomRef().removeAttribute("data-sap-ui-preserve");}V.prototype.destroy.call(this,S);};
f.registerPreprocessor=function(T,P,S,o,e){T=T.toUpperCase();if(f.PreprocessorType[T]){V.registerPreprocessor(f.PreprocessorType[T],P,this.getMetadata().getClass()._sType,S,o,e);}else{q.sap.log.error("Preprocessor could not be registered due to unknown sType \""+T+"\"",this.getMetadata().getName());}};
f.PreprocessorType={XML:"xml",VIEWXML:"viewxml",CONTROLS:"controls"};
var y=C.extend("sap.ui.core.mvc.XMLAfterRenderingNotifier",{
metadata:{library:"sap.ui.core"},
renderer:function(o,e){o.write("");}
});
f.registerPreprocessor("xml","sap.ui.core.util.XMLPreprocessor",true,true);return f;});
sap.ui.predefine('sap/ui/core/mvc/XMLViewRenderer',['jquery.sap.global','./ViewRenderer','../RenderManager'],function(q,V,R){"use strict";var P=R.RenderPrefixes.Dummy,a=R.RenderPrefixes.Invisible;var X={};
X.render=function(r,c){var d=c.getDomRef();if(d&&!R.isPreservedContent(d)){R.preserveContent(d,true);}var $=c._$oldContent=R.findPreservedContent(c.getId());if($.length===0){var s=c.isSubView();if(!s){r.write("<div");r.writeControlData(c);r.addClass("sapUiView");r.addClass("sapUiXMLView");V.addDisplayClass(r,c);if(!c.oAsyncState||!c.oAsyncState.suppressPreserve){r.writeAttribute("data-sap-ui-preserve",c.getId());}if(c.getWidth()){r.addStyle("width",c.getWidth());}if(c.getHeight()){r.addStyle("height",c.getHeight());}r.writeStyles();r.writeClasses();r.write(">");}if(c._aParsedContent){for(var i=0;i<c._aParsedContent.length;i++){var f=c._aParsedContent[i];if(f&&typeof(f)==="string"){r.write(f);}else{r.renderControl(f);if(!f.bOutput){r.write('<div id="'+P+f.getId()+'" class="sapUiHidden"/>');}}}}if(!s){r.write("</div>");}}else{r.renderControl(c.oAfterRenderingNotifier);r.write('<div id="'+P+c.getId()+'" class="sapUiHidden">');for(var i=0;i<c._aParsedContent.length;i++){var f=c._aParsedContent[i];if(typeof(f)!=="string"){var F=f.getId(),b=q.sap.byId(F,$);if(b.length==0){b=q.sap.byId(a+F,$);}b.replaceWith('<div id="'+P+F+'" class="sapUiHidden"/>');r.renderControl(f);}}r.write('</div>');}};
return X;},true);
sap.ui.predefine('sap/ui/core/plugin/TemplatingSupport',['jquery.sap.global','sap/ui/core/Core','sap/ui/core/tmpl/Template'],function(q,C,T){"use strict";var a=function(){};
a.prototype.startPlugin=function(c,o){q.sap.log.info("Starting TemplatingSupport plugin.");this.oCore=c;sap.ui.template();};
a.prototype.stopPlugin=function(){q.sap.log.info("Stopping TemplatingSupport plugin.");this.oCore=null;};
(function(){var t=new a();sap.ui.getCore().registerPlugin(t);}());return a;},true);
sap.ui.predefine('sap/ui/core/routing/HashChanger',['jquery.sap.global','sap/ui/base/EventProvider','sap/ui/thirdparty/hasher'],function(q,E,h){"use strict";
var H=E.extend("sap.ui.core.routing.HashChanger",{constructor:function(){E.apply(this);}});
H.prototype.init=function(){if(this._initialized){q.sap.log.info("this HashChanger instance has already been initialized.");return false;}this._initialized=true;h.changed.add(this.fireHashChanged,this);if(!h.isActive()){h.initialized.addOnce(this.fireHashChanged,this);h.init();}else{this.fireHashChanged(h.getHash());}return this._initialized;};
H.prototype.fireHashChanged=function(n,o){this.fireEvent("hashChanged",{newHash:n,oldHash:o});};
H.prototype.setHash=function(s){this.fireEvent("hashSet",{sHash:s});h.setHash(s);};
H.prototype.replaceHash=function(s){this.fireEvent("hashReplaced",{sHash:s});h.replaceHash(s);};
H.prototype.getHash=function(){return h.getHash();};
H.prototype.destroy=function(){h.changed.remove(this.fireHashChanged,this);E.prototype.destroy.apply(this,arguments);};
(function(){var _=null;
H.getInstance=function(){if(!_){_=new H();}return _;};
function e(o){var s,a,n;for(s in _.mEventRegistry){if(_.mEventRegistry.hasOwnProperty(s)){a=_.mEventRegistry[s];n=o.mEventRegistry[s];if(n){o.mEventRegistry[s]=a.concat(n);}else{o.mEventRegistry[s]=a;}}}}
H.replaceHashChanger=function(o){if(_&&o){var g=q.sap.getObject("sap.ui.core.routing.History.getInstance"),a;if(g){a=g();a._unRegisterHashChanger();}e(o);_.destroy();if(a){a._setHashChanger(o);}}_=o;};
}());return H;});
sap.ui.predefine('sap/ui/core/routing/History',['jquery.sap.global','sap/ui/core/library','./HashChanger'],function(q,l,H){"use strict";var a=l.routing.HistoryDirection;var b=function(h){this._iHistoryLength=window.history.length;this.aHistory=[];this._bIsInitial=true;if(!h){q.sap.log.error("sap.ui.core.routing.History constructor was called and it did not get a hashChanger as parameter");}this._setHashChanger(h);this._reset();};
b.prototype.destroy=function(n){this._unRegisterHashChanger();};
b.prototype.getDirection=function(n){if(n!==undefined&&this._bIsInitial){return undefined;}if(n===undefined){return this._sCurrentDirection;}return this._getDirection(n);};
b.prototype.getPreviousHash=function(){return this.aHistory[this.iHistoryPosition-1];};
b.prototype._setHashChanger=function(h){if(this._oHashChanger){this._unRegisterHashChanger();}this._oHashChanger=h;this._oHashChanger.attachEvent("hashChanged",this._onHashChange,this);this._oHashChanger.attachEvent("hashReplaced",this._hashReplaced,this);this._oHashChanger.attachEvent("hashSet",this._hashSet,this);};
b.prototype._unRegisterHashChanger=function(){this._oHashChanger.detachEvent("hashChanged",this._onHashChange,this);this._oHashChanger.detachEvent("hashReplaced",this._hashReplaced,this);this._oHashChanger.detachEvent("hashSet",this._hashSet,this);this._oHashChanger=null;};
b.prototype._reset=function(){this.aHistory.length=0;this.iHistoryPosition=0;this._bUnknown=true;this.aHistory[0]=this._oHashChanger.getHash();};
b.prototype._getDirection=function(n,h,c){if(c&&this._oNextHash&&this._oNextHash.sHash===n){return a.NewEntry;}if(h){return a.NewEntry;}if(this._bUnknown){return a.Unknown;}if(this.aHistory[this.iHistoryPosition+1]===n&&this.aHistory[this.iHistoryPosition-1]===n){return a.Unknown;}if(this.aHistory[this.iHistoryPosition-1]===n){return a.Backwards;}if(this.aHistory[this.iHistoryPosition+1]===n){return a.Forwards;}return a.Unknown;};
b.prototype._onHashChange=function(e){this._hashChange(e.getParameter("newHash"));};
b.prototype._hashChange=function(n){var c=window.history.length,d;if(this._oNextHash&&this._oNextHash.bWasReplaced&&this._oNextHash.sHash===n){this.aHistory[this.iHistoryPosition]=n;this._oNextHash=null;if(!this._bIsInitial){this._sCurrentDirection=a.Unknown;}return;}this._bIsInitial=false;d=this._sCurrentDirection=this._getDirection(n,this._iHistoryLength<window.history.length,true);this._iHistoryLength=c;if(this._oNextHash){this._oNextHash=null;}if(d===a.Unknown){this._reset();return;}this._bUnknown=false;if(d===a.NewEntry){if(this.iHistoryPosition+1<this.aHistory.length){this.aHistory=this.aHistory.slice(0,this.iHistoryPosition+1);}this.aHistory.push(n);this.iHistoryPosition+=1;return;}if(d===a.Forwards){this.iHistoryPosition++;return;}if(d===a.Backwards){this.iHistoryPosition--;}};
b.prototype._hashSet=function(e){this._hashChangedByApp(e.getParameter("sHash"),false);};
b.prototype._hashReplaced=function(e){this._hashChangedByApp(e.getParameter("sHash"),true);};
b.prototype._hashChangedByApp=function(n,w){this._oNextHash={sHash:n,bWasReplaced:w};};
var i=new b(H.getInstance());
b.getInstance=function(){return i;};
return b;},true);
sap.ui.predefine('sap/ui/core/routing/Route',['jquery.sap.global','sap/ui/base/EventProvider','sap/ui/core/routing/Target','sap/ui/core/routing/async/Route','sap/ui/core/routing/sync/Route','sap/ui/core/Component'],function($,E,T,a,s,C){"use strict";
var R=E.extend("sap.ui.core.routing.Route",{
metadata:{publicMethods:["getURL","getPattern"]},
constructor:function(r,c,p){E.apply(this,arguments);if(!c.name){$.sap.log.error("A name has to be specified for every route",this);}this._aPattern=[];this._aRoutes=[];this._oParent=p;this._oConfig=c;this._oRouter=r;var t=this,v=c.pattern,S,b,d=r._isAsync();b=d?a:s;for(var f in b){this[f]=b[f];}if(!$.isArray(v)){v=[v];}if(c.parent){var o=this._getParentRoute(c.parent);if(!o){$.sap.log.error("No parent route with '"+c.parent+"' could be found",this);}else if(o._aPattern.length>1){$.sap.log.error("Routes with multiple patterns cannot be used as parent for nested routes",this);return;}else{this._oNestingParent=o;v.forEach(function(e,i){var n=o._aPattern[0];n=n.charAt(n.length)==="/"?n:n+"/";v[i]=n+e;});}}if($.isArray(c.subroutes)){S=c.subroutes;c.subroutes={};$.each(S,function(i,e){c.subroutes[e.name]=e;});}if(!c.target){c._async=d;this._oTarget=new T(c,r._oViews,p&&p._oTarget);this._oTarget._bUseRawViewId=true;}if(c.subroutes){$.each(c.subroutes,function(e,g){if(g.name===undefined){g.name=e;}r.addRoute(g,t);});}if(c.pattern===undefined){return;}$.each(v,function(i,e){t._aPattern[i]=e;t._aRoutes[i]=r._oRouter.addRoute(e);t._aRoutes[i].greedy=c.greedy;t._aRoutes[i].matched.add(function(){var A={};$.each(arguments,function(g,h){A[t._aRoutes[i]._paramsIds[g]]=h;});t._routeMatched(A,true);});});},
destroy:function(){E.prototype.destroy.apply(this);this._aPattern=null;this._aRoutes=null;this._oParent=null;this._oConfig=null;this.bIsDestroyed=true;return this;},
getURL:function(p){return this._aRoutes[0].interpolate(p);},
getPattern:function(){return this._aPattern[0];},
attachMatched:function(d,f,l){return this.attachEvent("matched",d,f,l);},
detachMatched:function(f,l){return this.detachEvent("matched",f,l);},
attachBeforeMatched:function(d,f,l){return this.attachEvent("beforeMatched",d,f,l);},
detachBeforeMatched:function(f,l){return this.detachEvent("beforeMatched",f,l);},
fireBeforeMatched:function(A){this.fireEvent("beforeMatched",A);return this;},
attachPatternMatched:function(d,f,l){return this.attachEvent("patternMatched",d,f,l);},
detachPatternMatched:function(f,l){return this.detachEvent("patternMatched",f,l);},
_convertToTargetOptions:function(o){return $.extend(true,{},o,{rootView:o.targetParent,controlId:o.targetControl,controlAggregation:o.targetAggregation,clearControlAggregation:o.clearTarget,viewName:o.view,viewType:o.viewType,viewId:o.viewId});},
_getParentRoute:function(p){var P=p.split(":");if(P.length===1||(P.length===2&&!P[0])){return this._oRouter.getRoute(P[P.length-1]);}else{var o=C.getOwnerComponentFor(this._oRouter._oOwner);while(o){if(o.getMetadata().getName()===P[0]){var r=o.getRouter();return r.getRoute(P[1]);}o=C.getOwnerComponentFor(o);}return null;}}
});
R.M_EVENTS={BeforeMatched:"beforeMatched",Matched:"matched",PatternMatched:"patternMatched"};return R;});
sap.ui.predefine('sap/ui/core/routing/Router',['jquery.sap.global','sap/ui/core/library','sap/ui/base/EventProvider','./HashChanger','./Route','./Views','./Targets','./History','sap/ui/thirdparty/crossroads'],function(q,l,E,H,R,V,T,a,c){"use strict";var r={};
var b=E.extend("sap.ui.core.routing.Router",{
constructor:function(o,C,O,t){E.apply(this);this._oConfig=C||{};this._oRouter=c.create();this._oRouter.ignoreState=true;this._oRoutes={};this._oOwner=O;function e(){if(q.sap.getUriParameters().get("sap-ui-xx-asyncRouting")==="true"){q.sap.log.warning("Activation of async view loading in routing via url parameter is only temporarily supported and may be removed soon","Router");return true;}return false;}this._oConfig._async=this._oConfig.async;if(this._oConfig._async===undefined){this._oConfig._async=e();}this._oViews=new V({component:O,async:this._oConfig._async});if(t){this._oTargets=this._createTargets(this._oConfig,t);}var f=this,h;if(!o){o={};}if(Array.isArray(o)){h=o;o={};h.forEach(function(i){o[i.name]=i;});}q.each(o,function(s,i){if(i.name===undefined){i.name=s;}f.addRoute(i);});this._oRouter.bypassed.add(q.proxy(this._onBypassed,this));},
addRoute:function(C,p){if(!C.name){q.sap.log.error("A name has to be specified for every route",this);}if(this._oRoutes[C.name]){q.sap.log.error("Route with name "+C.name+" already exists",this);}this._oRoutes[C.name]=this._createRoute(this,C,p);},
parse:function(n){if(this._oRouter){this._oRouter.parse(n);}else{q.sap.log.warning("This router has been destroyed while the hash changed. No routing events where fired by the destroyed instance.",this);}},
initialize:function(i){var t=this,h=this.oHashChanger=H.getInstance();if(this._bIsInitialized){q.sap.log.warning("Router is already initialized.",this);return this;}this._bIsInitialized=true;this._bLastHashReplaced=false;this._bHashChangedAfterTitleChange=false;this.fnHashChanged=function(f){t.parse(f.getParameter("newHash"));t._bHashChangedAfterTitleChange=true;};if(!h){q.sap.log.error("navTo of the router is called before the router is initialized. If you want to replace the current hash before you initialize the router you may use getUrl and use replaceHash of the Hashchanger.",this);return;}if(this._oTargets){var o=this._oRoutes[this._oConfig.homeRoute];this._oTargets.attachTitleChanged(function(f){var j=f.getParameters();if(o&&d(j.name,o._oConfig.name)){j.isHome=true;}this.fireTitleChanged(j);},this);this.fnHashReplaced=function(){this._bLastHashReplaced=true;};this.oHashChanger.attachEvent("hashReplaced",this.fnHashReplaced,this);this._aHistory=[];var e=o&&g(this._oOwner,o);if(e){this._aHistory.push(e);}}h.init();h.attachEvent("hashChanged",this.fnHashChanged);if(!i){this.parse(h.getHash());}return this;},
stop:function(){if(!this._bIsInitialized){q.sap.log.warning("Router is not initialized. But it got stopped",this);}if(this.fnHashChanged){this.oHashChanger.detachEvent("hashChanged",this.fnHashChanged);}if(this.fnHashReplaced){this.oHashChanger.detachEvent("hashReplaced",this.fnHashReplaced);}this._bIsInitialized=false;return this;},
destroy:function(){E.prototype.destroy.apply(this);if(!this._bIsInitialized){q.sap.log.info("Router is not initialized, but got destroyed.",this);}if(this.fnHashChanged){this.oHashChanger.detachEvent("hashChanged",this.fnHashChanged);}if(this.fnHashReplaced){this.oHashChanger.detachEvent("hashReplaced",this.fnHashReplaced);}this._oRouter.removeAllRoutes();this._oRouter=null;q.each(this._oRoutes,function(i,o){o.destroy();});this._oRoutes=null;this._oConfig=null;if(this._oTargets){this._oTargets.destroy();this._oTargets=null;}this.bIsDestroyed=true;return this;},
getURL:function(n,p){if(p===undefined){p={};}var o=this.getRoute(n);if(!o){q.sap.log.warning("Route with name "+n+" does not exist",this);return;}return o.getURL(p);},
getRoute:function(n){return this._oRoutes[n];},
getViews:function(){return this._oViews;},
_createTargets:function(C,t){return new T({views:this._oViews,config:C,targets:t});},
_createRoute:function(o,C,p){return new R(o,C,p);},
getView:function(v,s,e){var o=this._oViews._getViewWithGlobalId({viewName:v,type:s,id:e});this.fireViewCreated({view:o,viewName:v,type:s});return o;},
setView:function(v,o){this._oViews.setView(v,o);return this;},
navTo:function(n,p,e){var u=this.getURL(n,p);if(u===undefined){q.sap.log.error("Can not navigate to route with name "+n+" because the route does not exist");}if(e){this.oHashChanger.replaceHash(u);}else{this.oHashChanger.setHash(u);}return this;},
getTargets:function(){return this._oTargets;},
getTarget:function(n){return this._oTargets.getTarget(n);},
attachRouteMatched:function(D,f,L){this.attachEvent("routeMatched",D,f,L);return this;},
detachRouteMatched:function(f,L){this.detachEvent("routeMatched",f,L);return this;},
fireRouteMatched:function(A){this.fireEvent("routeMatched",A);return this;},
attachBeforeRouteMatched:function(D,f,L){this.attachEvent("beforeRouteMatched",D,f,L);return this;},
detachBeforeRouteMatched:function(f,L){this.detachEvent("beforeRouteMatched",f,L);return this;},
fireBeforeRouteMatched:function(A){this.fireEvent("beforeRouteMatched",A);return this;},
attachViewCreated:function(D,f,L){this.attachEvent("viewCreated",D,f,L);return this;},
detachViewCreated:function(f,L){this.detachEvent("viewCreated",f,L);return this;},
fireViewCreated:function(A){this.fireEvent("viewCreated",A);return this;},
attachRoutePatternMatched:function(D,f,L){this.attachEvent("routePatternMatched",D,f,L);return this;},
detachRoutePatternMatched:function(f,L){this.detachEvent("routePatternMatched",f,L);return this;},
fireRoutePatternMatched:function(A){this.fireEvent("routePatternMatched",A);return this;},
attachBypassed:function(D,f,L){return this.attachEvent(b.M_EVENTS.BYPASSED,D,f,L);},
detachBypassed:function(f,L){return this.detachEvent(b.M_EVENTS.BYPASSED,f,L);},
fireBypassed:function(A){return this.fireEvent(b.M_EVENTS.BYPASSED,A);},
attachTitleChanged:function(D,f,L){this.attachEvent(b.M_EVENTS.TITLE_CHANGED,D,f,L);return this;},
detachTitleChanged:function(f,L){return this.detachEvent(b.M_EVENTS.TITLE_CHANGED,f,L);},
fireTitleChanged:function(A){var D=a.getInstance().getDirection(),h=this.oHashChanger.getHash(),e=l.routing.HistoryDirection,L=this._aHistory[this._aHistory.length-1],n;if(D===e.Backwards&&L&&!L.isHome){if(L&&L.title!==A.title){this._aHistory.pop();}}else if(L&&L.hash==h){L.title=A.title;this._aHistory.some(function(o,i,f){if(i<f.length-1&&q.sap.equal(o,L)){return f.splice(i,1);}});}else{if(this._bLastHashReplaced){this._aHistory.pop();}n={hash:h,title:A.title};this._aHistory.some(function(o,i,f){if(q.sap.equal(o,n)){return f.splice(i,1);}});this._aHistory.push(n);}A.history=this._aHistory.slice(0,-1);this.fireEvent(b.M_EVENTS.TITLE_CHANGED,A);this._bLastHashReplaced=false;return this;},
getTitleHistory:function(){return this._aHistory||[];},
register:function(n){r[n]=this;return this;},
_onBypassed:function(h){var f=function(){this.fireBypassed({hash:h});}.bind(this);if(this._oConfig.bypassed){var o=this._oTargets.display(this._oConfig.bypassed.target,{hash:h});if(o instanceof Promise){o.then(f);return;}}f();},
_isAsync:function(){return this._oConfig._async;},
metadata:{publicMethods:["initialize","getURL","register","getRoute"]}
});
function d(s,h){return h&&h.indexOf(s)>-1;}
function g(o,h){var s=h.getPattern(),A=o&&o.getManifestEntry("sap.app/title");if(s===""||(s!==undefined&&!/({.*})+/.test(s))){return{hash:s,isHome:true,title:A};}else{q.sap.log.error("Routes with dynamic parts cannot be resolved as home route.");}}
b.M_EVENTS={BEFORE_ROUTE_MATCHED:"beforeRouteMatched",ROUTE_MATCHED:"routeMatched",ROUTE_PATTERN_MATCHED:"routePatternMatched",VIEW_CREATED:"viewCreated",BYPASSED:"bypassed",TITLE_CHANGED:"titleChanged"};
b.getRouter=function(n){return r[n];};
return b;});
sap.ui.predefine('sap/ui/core/routing/Target',['jquery.sap.global','sap/ui/core/Control','sap/ui/base/EventProvider','sap/ui/core/mvc/View','sap/ui/core/routing/async/Target','sap/ui/core/routing/sync/Target'],function(q,C,E,V,a,s){"use strict";
var T=E.extend("sap.ui.core.routing.Target",{
constructor:function(o,v){function c(){if(q.sap.getUriParameters().get("sap-ui-xx-asyncRouting")==="true"){q.sap.log.warning("Activation of async view loading in routing via url parameter is only temporarily supported and may be removed soon","Target");return true;}return false;}if(o._async===undefined){o._async=c();}this._oOptions=o;this._oViews=v;E.apply(this,arguments);if(this._oOptions.title){this._oTitleProvider=new b({target:this});}var d=this._oOptions._async?a:s;for(var f in d){this[f]=d[f];}this._bIsDisplayed=false;},
destroy:function(){this._oParent=null;this._oOptions=null;this._oViews=null;if(this._oTitleProvider){this._oTitleProvider.destroy();}this._oTitleProvider=null;E.prototype.destroy.apply(this,arguments);this.bIsDestroyed=true;return this;},
attachDisplay:function(d,f,l){return this.attachEvent(this.M_EVENTS.DISPLAY,d,f,l);},
detachDisplay:function(f,l){return this.detachEvent(this.M_EVENTS.DISPLAY,f,l);},
fireDisplay:function(A){var t=this._oTitleProvider&&this._oTitleProvider.getTitle();if(t){this.fireTitleChanged({name:this._oOptions.name,title:t});}this._bIsDisplayed=true;return this.fireEvent(this.M_EVENTS.DISPLAY,A);},
attachTitleChanged:function(d,f,l){var h=this.hasListeners("titleChanged"),t=this._oTitleProvider&&this._oTitleProvider.getTitle();this.attachEvent(this.M_EVENTS.TITLE_CHANGED,d,f,l);if(!h&&t&&this._bIsDisplayed){this.fireTitleChanged({name:this._oOptions.name,title:t});}return this;},
detachTitleChanged:function(f,l){return this.detachEvent(this.M_EVENTS.TITLE_CHANGED,f,l);},
fireTitleChanged:function(A){return this.fireEvent(this.M_EVENTS.TITLE_CHANGED,A);},
_getEffectiveViewName:function(v){var c=this._oOptions.viewPath;if(c){v=c+"."+v;}return v;},
_bindTitleInTitleProvider:function(v){if(this._oTitleProvider&&v instanceof V){this._oTitleProvider.applySettings({title:this._oOptions.title},v.getController());}},
_addTitleProviderAsDependent:function(v){if(!this._oTitleProvider){return;}var o=this._oTitleProvider.getParent();if(o){o.removeDependent(this._oTitleProvider);}v.addDependent(this._oTitleProvider);},
_beforePlacingViewIntoContainer:function(A){},
M_EVENTS:{DISPLAY:"display",TITLE_CHANGED:"titleChanged"}
});
var b=C.extend("sap.ui.core.routing.Target.TitleProvider",{
metadata:{library:"sap.ui.core",properties:{title:{type:"string",group:"Data",defaultValue:null}}},
constructor:function(S){this._oTarget=S.target;delete S.target;C.prototype.constructor.call(this,S);},
setTitle:function(t){this.setProperty("title",t,true);if(this._oTarget._bIsDisplayed){this._oTarget.fireTitleChanged({name:this._oTarget._oOptions.name,title:t});}}
});
return T;});
sap.ui.predefine('sap/ui/core/routing/Targets',['jquery.sap.global','sap/ui/base/EventProvider','./Target','./async/Targets','./sync/Targets'],function(q,E,T,a,s){"use strict";
var b=E.extend("sap.ui.core.routing.Targets",{
constructor:function(o){var t,c;E.apply(this);this._mTargets={};this._oConfig=o.config;this._oViews=o.views;if(!this._oConfig){this._oConfig={_async:false};}function d(){if(q.sap.getUriParameters().get("sap-ui-xx-asyncRouting")==="true"){q.sap.log.warning("Activation of async view loading in routing via url parameter is only temporarily supported and may be removed soon","Targets");return true;}return false;}if(this._oConfig._async===undefined){this._oConfig._async=(this._oConfig.async===undefined)?d():this._oConfig.async;}var e=this._oConfig._async?a:s;for(var f in e){this[f]=e[f];}for(t in o.targets){if(o.targets.hasOwnProperty(t)){this._createTarget(t,o.targets[t]);}}for(c in this._mTargets){if(this._mTargets.hasOwnProperty(c)){this._addParentTo(this._mTargets[c]);}}},
destroy:function(){var t;E.prototype.destroy.apply(this);for(t in this._mTargets){if(this._mTargets.hasOwnProperty(t)){this._mTargets[t].destroy();}}this._mTargets=null;this._oViews=null;this._oConfig=null;this.bIsDestroyed=true;return this;},
getViews:function(){return this._oViews;},
getTarget:function(n){var t=this,r=[];if(Array.isArray(n)){n.forEach(function(N){var o=t._mTargets[N];if(o){r.push(o);}else{q.sap.log.error("The target you tried to get \""+N+"\" does not exist!",t);}});return r;}return this._mTargets[n];},
addTarget:function(n,t){var o=this.getTarget(n),c;if(o){q.sap.log.error("Target with name "+n+" already exists",this);}else{c=this._createTarget(n,t);this._addParentTo(c);}return this;},
attachDisplay:function(d,f,l){return this.attachEvent(this.M_EVENTS.DISPLAY,d,f,l);},
detachDisplay:function(f,l){return this.detachEvent(this.M_EVENTS.DISPLAY,f,l);},
fireDisplay:function(A){return this.fireEvent(this.M_EVENTS.DISPLAY,A);},
attachTitleChanged:function(d,f,l){this.attachEvent(this.M_EVENTS.TITLE_CHANGED,d,f,l);return this;},
detachTitleChanged:function(f,l){return this.detachEvent(this.M_EVENTS.TITLE_CHANGED,f,l);},
fireTitleChanged:function(A){return this.fireEvent(this.M_EVENTS.TITLE_CHANGED,A);},
M_EVENTS:{DISPLAY:"display",TITLE_CHANGED:"titleChanged"},
_createTarget:function(n,t){var o,O;O=q.extend(true,{name:n},this._oConfig,t);o=this._constructTarget(O);o.attachDisplay(function(e){var p=e.getParameters();this.fireDisplay({name:n,view:p.view,control:p.control,config:p.config,data:p.data});},this);this._mTargets[n]=o;return o;},
_addParentTo:function(t){var p,P=t._oOptions.parent;if(!P){return;}p=this._mTargets[P];if(!p){q.sap.log.error("The target '"+t._oOptions.name+" has a parent '"+P+"' defined, but it was not found in the other targets",this);return;}t._oParent=p;},
_constructTarget:function(o,p){return new T(o,this._oViews,p);},
_setRootViewId:function(i){var t,o;for(t in this._mTargets){if(this._mTargets.hasOwnProperty(t)){o=this._mTargets[t]._oOptions;if(o.rootView===undefined){o.rootView=i;}}}},
_getTitleTargetName:function(t,p){var o,c;c=p||(typeof t==="string"&&t);if(!c){t.some(function(d){o=this.getTarget(d);while(o&&o._oParent&&o._oParent._oOptions.title){o=o._oParent;}if(o&&o._oOptions.title){c=o._oOptions.name;return true;}}.bind(this));}return c;},
_forwardTitleChanged:function(e){this.fireTitleChanged({name:e.getParameter("name"),title:e.getParameter("title")});},
_attachTitleChanged:function(t,c){var o;c=this._getTitleTargetName(t,c);o=this.getTarget(c);if(this._oLastTitleTarget){this._oLastTitleTarget.detachTitleChanged(this._forwardTitleChanged,this);this._oLastTitleTarget._bIsDisplayed=false;}if(o){o.attachTitleChanged({name:o._oOptions.name},this._forwardTitleChanged,this);this._oLastTitleTarget=o;}else if(c){q.sap.log.error("The target with the name \""+c+"\" where the titleChanged event should be fired does not exist!",this);}}
});
return b;});
sap.ui.predefine('sap/ui/core/routing/Views',['jquery.sap.global','sap/ui/base/EventProvider','sap/ui/core/UIComponent','sap/ui/core/mvc/View','sap/ui/core/routing/async/Views','sap/ui/core/routing/sync/Views'],function(q,E,U,V,a,s){"use strict";
var b=E.extend("sap.ui.core.routing.Views",{
constructor:function(o){if(!o){o={};}this._oViews={};this._oComponent=o.component;if(this._oComponent){}E.apply(this,arguments);function c(){if(q.sap.getUriParameters().get("sap-ui-xx-asyncRouting")==="true"){q.sap.log.warning("Activation of async view loading in routing via url parameter is only temporarily supported and may be removed soon","Views");return true;}return false;}var d=(o.async===undefined)?c():o.async;var e=d?a:s;for(var f in e){this[f]=e[f];}},
metadata:{publicMethods:["getView","setView"]},
getView:function(o){return this._getView(o).loaded();},
setView:function(v,o){this._checkViewName(v);this._oViews[v]=o;return this;},
destroy:function(){var p;E.prototype.destroy.apply(this);for(p in this._oViews){if(this._oViews.hasOwnProperty(p)&&this._oViews[p]){this._oViews[p].destroy();}}this._oViews=undefined;this.bIsDestroyed=true;return this;},
attachCreated:function(d,f,l){return this.attachEvent("created",d,f,l);},
detachCreated:function(f,l){return this.detachEvent("created",f,l);},
fireCreated:function(A){return this.fireEvent("created",A);},
_getView:function(o){if(this._oComponent&&o.id){o=q.extend({},o,{id:this._oComponent.createId(o.id)});}return this._getViewWithGlobalId(o);},
_checkViewName:function(v){if(!v){q.sap.log.error("A name for the view has to be defined",this);}}
});
return b;});
sap.ui.predefine('sap/ui/core/routing/async/Route',['jquery.sap.global','sap/ui/Device'],function(q,D){"use strict";return{_routeMatched:function(a,s,n){var r=this._oRouter,t,c,e,v=null,T=null,i,o,C,b=this;if(!s||s===true){i=true;s=Promise.resolve();}if(this._oParent){s=this._oParent._routeMatched(a,s);}else if(this._oNestingParent){this._oNestingParent._routeMatched(a,s,this);}c=q.extend({},r._oConfig,this._oConfig);o=q.extend({},a);o.routeConfig=c;e={name:c.name,arguments:a,config:c};if(n){e.nestedRoute=n;}this.fireBeforeMatched(e);r.fireBeforeRouteMatched(e);if(this._oTarget){t=this._oTarget;t._oOptions=this._convertToTargetOptions(c);s=t._place(s);if(this._oRouter._oTargetHandler&&this._oRouter._oTargetHandler._chainNavigation){C=s;s=this._oRouter._oTargetHandler._chainNavigation(function(){return C;});}}else if(D.browser.msie||D.browser.edge){C=s;s=new Promise(function(d,f){setTimeout(function(){var g=r._oTargets._display(b._oConfig.target,o,b._oConfig.titleTarget,C);g.then(d,f);},0);});}else{s=r._oTargets._display(this._oConfig.target,o,this._oConfig.titleTarget,s);}return s.then(function(R){R=R||{};v=R.view;T=R.control;e.view=v;e.targetControl=T;if(c.callback){c.callback(this,a,c,T,v);}this.fireEvent("matched",e);r.fireRouteMatched(e);if(i){q.sap.log.info("The route named '"+c.name+"' did match with its pattern",this);this.fireEvent("patternMatched",e);r.fireRoutePatternMatched(e);}return R;}.bind(this));}};});
sap.ui.predefine('sap/ui/core/routing/async/Target',['jquery.sap.global'],function(q){"use strict";return{display:function(d){var s=Promise.resolve();return this._display(d,s).catch(function(v){if(v instanceof Error){return Promise.reject(v);}else{return v;}});},_display:function(d,s){if(this._oParent){s=this._oParent._display(d,s);}return this._place(d,s);},_place:function(d,s){if(d instanceof Promise){s=d;d=undefined;}var o=this._oOptions,t=this,v,c,V,a,b,e,E;if(o.viewName){a=this._getEffectiveViewName(o.viewName);b={viewName:a,type:o.viewType,id:o.viewId,async:o.async};if(this._bUseRawViewId){v=this._oViews._getViewWithGlobalId(b);}else{v=this._oViews._getView(b);}s=s.then(function(p){return v.loaded().then(function(v){t._bindTitleInTitleProvider(v);t._addTitleProviderAsDependent(v);return{view:v,parentInfo:p||{}};},function(E){return Promise.reject({name:o.name,error:E});});}).then(function(f){e=this._isValid(f.parentInfo);if(e!==true){E=e;return this._refuseInvalidTarget(o.name,E);}V=f.parentInfo.view;c=f.parentInfo.control;v=f.view;if(!V&&o.rootView){V=sap.ui.getCore().byId(o.rootView);if(!V){E="Did not find the root view with the id "+o.rootView;return this._refuseInvalidTarget(o.name,E);}}if(o.controlId){if(V){c=V.byId(o.controlId);}if(!c){c=sap.ui.getCore().byId(o.controlId);}if(!c){E="Control with ID "+o.controlId+" could not be found";return this._refuseInvalidTarget(o.name,E);}}this._beforePlacingViewIntoContainer({container:c,view:v,data:d});var A=c.getMetadata().getJSONKeys()[o.controlAggregation];if(!A){E="Control "+o.controlId+" does not have an aggregation called "+o.controlAggregation;return this._refuseInvalidTarget(o.name,E);}if(o.clearControlAggregation===true){c[A._sRemoveAllMutator]();}q.sap.log.info("Did place the view '"+a+"' with the id '"+v.getId()+"' into the aggregation '"+o.controlAggregation+"' of a control with the id '"+c.getId()+"'",this);c[A._sMutator](v);this.fireDisplay({view:v,control:c,config:this._oOptions,data:d});return{name:o.name,view:v,control:c};}.bind(this));}else{s=s.then(function(){return{name:o.name};});}return s;},_isValid:function(p){var o=this._oOptions,c=p&&p.control,h=(c||o.controlId),i=true,l="";if(!h){l="The target "+o.name+" has no controlId set and no parent so the target cannot be displayed.";i=false;}if(!o.controlAggregation){l="The target "+o.name+" has a control id or a parent but no 'controlAggregation' was set, so the target could not be displayed.";i=false;}if(l){q.sap.log.error(l,this);}return i||l;},_refuseInvalidTarget:function(n,m){if(m){q.sap.log.error(m,this);}return{name:n,error:m};}};});
sap.ui.predefine('sap/ui/core/routing/async/Targets',['jquery.sap.global'],function(q){"use strict";return{display:function(t,d,T){var s=Promise.resolve();return this._display(t,d,T,s);},_display:function(t,d,T,s){var a=this,v=[];if(!Array.isArray(t)){t=[t];}this._attachTitleChanged(t,T);return t.reduce(function(p,b){return a._displaySingleTarget(b,d,p).then(function(V){v.push(V);});},s).then(function(){return v;});},_displaySingleTarget:function(n,d,s){var t=this.getTarget(n);if(t!==undefined){return t._display(d,s);}else{var e="The target with the name \""+n+"\" does not exist!";q.sap.log.error(e,this);return Promise.resolve({name:n,error:e});}}};});
sap.ui.predefine('sap/ui/core/routing/async/Views',['jquery.sap.global'],function(q){"use strict";return{_getViewWithGlobalId:function(o){function c(){return sap.ui.view(o);}var v,V;if(!o){q.sap.log.error("the oOptions parameter of getView is mandatory",this);}else{if(o.async===undefined){o.async=true;}V=o.viewName;this._checkViewName(V);v=this._oViews[V];}if(v){return v;}if(this._oComponent){v=this._oComponent.runAsOwner(c);}else{v=c();}this._oViews[V]=v;v.loaded().then(function(v){this.fireCreated({view:v,viewOptions:o});}.bind(this));return v;}};});
sap.ui.predefine('sap/ui/core/routing/sync/Route',['jquery.sap.global'],function(q){"use strict";return{_routeMatched:function(a,i,n){var r=this._oRouter,p,P,t,c,e,v=null,T=null,o;if(this._oParent){p=this._oParent._routeMatched(a);}else if(this._oNestingParent){this._oNestingParent._routeMatched(a,false,this);}c=q.extend({},r._oConfig,this._oConfig);o=q.extend({},a);o.routeConfig=c;e={name:c.name,arguments:a,config:c};if(n){e.nestedRoute=n;}this.fireBeforeMatched(e);r.fireBeforeRouteMatched(e);if(this._oTarget){t=this._oTarget;t._oOptions=this._convertToTargetOptions(c);if(t._isValid(p,false)){P=t._place(p);}P=P||{};v=P.oTargetParent;T=P.oTargetControl;e.view=v;e.targetControl=T;}else{r._oTargets._display(this._oConfig.target,o,this._oConfig.titleTarget);}if(c.callback){c.callback(this,a,c,T,v);}this.fireEvent("matched",e);r.fireRouteMatched(e);if(i){q.sap.log.info("The route named '"+c.name+"' did match with its pattern",this);this.fireEvent("patternMatched",e);r.fireRoutePatternMatched(e);}return P;}};});
sap.ui.predefine('sap/ui/core/routing/sync/Target',['jquery.sap.global'],function(q){"use strict";return{display:function(d){var p;if(this._oParent){p=this._oParent.display(d);}return this._place(p,d);},_place:function(p,d){var o=this._oOptions;p=p||{};var v,c=p.oTargetControl,V=p.oTargetParent;if(!this._isValid(p,true)){return;}if(!V&&o.rootView){V=sap.ui.getCore().byId(o.rootView);if(!V){q.sap.log.error("Did not find the root view with the id "+o.rootView,this);return;}}if(o.controlId){if(V){c=V.byId(o.controlId);}if(!c){c=sap.ui.getCore().byId(o.controlId);}if(!c){q.sap.log.error("Control with ID "+o.controlId+" could not be found",this);return;}}var a=c.getMetadata().getJSONKeys()[o.controlAggregation];if(!a){q.sap.log.error("Control "+o.controlId+" does not have an aggregation called "+o.controlAggregation,this);return;}var s=this._getEffectiveViewName(o.viewName);var b={viewName:s,type:o.viewType,id:o.viewId};if(this._bUseRawViewId){v=this._oViews._getViewWithGlobalId(b);}else{v=this._oViews._getView(b);}this._beforePlacingViewIntoContainer({container:c,view:v,data:d});this._bindTitleInTitleProvider(v);this._addTitleProviderAsDependent(v);if(o.clearControlAggregation===true){c[a._sRemoveAllMutator]();}q.sap.log.info("Did place the view '"+s+"' with the id '"+v.getId()+"' into the aggregation '"+o.controlAggregation+"' of a control with the id '"+c.getId()+"'",this);c[a._sMutator](v);this.fireDisplay({view:v,control:c,config:this._oOptions,data:d});return{oTargetParent:v,oTargetControl:c};},_isValid:function(p,l){var o=this._oOptions,c=p&&p.oTargetControl,h=(c||o.controlId),i=true,L="";if(!h){L="The target "+o.name+" has no controlId set and no parent so the target cannot be displayed.";i=false;}if(!o.controlAggregation){L="The target "+o.name+" has a control id or a parent but no 'controlAggregation' was set, so the target could not be displayed.";i=false;}if(!o.viewName){L="The target "+o.name+" no viewName defined.";i=false;}if(l&&L){q.sap.log.error(L,this);}return i;}};});
sap.ui.predefine('sap/ui/core/routing/sync/Targets',['jquery.sap.global'],function(q){"use strict";return{display:function(t,d,T){this._display(t,d,T);},_display:function(t,d,T){var a=this;this._attachTitleChanged(t,T);if(Array.isArray(t)){t.forEach(function(s){a._displaySingleTarget(s,d);});}else{this._displaySingleTarget(t,d);}return this;},_displaySingleTarget:function(n,d){var t=this.getTarget(n);if(t!==undefined){t.display(d);}else{q.sap.log.error("The target with the name \""+n+"\" does not exist!",this);}}};});
sap.ui.predefine('sap/ui/core/routing/sync/Views',['jquery.sap.global'],function(q){"use strict";return{_getViewWithGlobalId:function(o){function c(){return sap.ui.view(o);}if(!o){q.sap.log.error("the oOptions parameter of getView is mandatory",this);}var v,V=o.viewName;this._checkViewName(V);v=this._oViews[V];if(v){return v;}if(this._oComponent){v=this._oComponent.runAsOwner(c);}else{v=c();}this._oViews[V]=v;this.fireCreated({view:v,viewOptions:o});return v;}};});
sap.ui.predefine('sap/ui/core/search/OpenSearchProvider',['jquery.sap.global','sap/ui/core/library','./SearchProvider','jquery.sap.encoder'],function(q,l,S){"use strict";
var O=S.extend("sap.ui.core.search.OpenSearchProvider",{metadata:{library:"sap.ui.core",properties:{suggestUrl:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},suggestType:{type:"string",group:"Misc",defaultValue:'json'}}}});
O.prototype.suggest=function(v,c){var u=this.getSuggestUrl();if(!u){return;}u=u.replace("{searchTerms}",q.sap.encodeURL(v));var t=this.getSuggestType();var s;if(t&&t.toLowerCase()==="xml"){t="xml";s=function(d){var x=q(d);var i=x.find("Text");var a=[];i.each(function(){a.push(q(this).text());});c(v,a);};}else{t="json";s=function(d){c(v,d[1]);};}q.ajax({url:u,dataType:t,success:s,error:function(X,a,e){q.sap.log.fatal("The following problem occurred: "+a,X.responseText+","+X.status);}});};
return O;});
sap.ui.predefine('sap/ui/core/search/SearchProvider',['jquery.sap.global','sap/ui/core/Element','sap/ui/core/library'],function(q,E,l){"use strict";
var S=E.extend("sap.ui.core.search.SearchProvider",{metadata:{library:"sap.ui.core",properties:{icon:{type:"string",group:"Misc",defaultValue:null}}}});
S.prototype.suggest=function(v,c){q.sap.log.warning("sap.ui.core.search.SearchProvider is the abstract base class for all SearchProviders. Do not create instances of this class, but use a concrete sub class instead.");};
return S;});
sap.ui.predefine('sap/ui/core/service/Service',['jquery.sap.global','sap/ui/base/Object'],function(q,B){"use strict";
var S=B.extend("sap.ui.core.service.Service",{
metadata:{"abstract":true,"library":"sap.ui.core"},
constructor:function(s){B.apply(this);if(s){}this._oServiceContext=s;if(typeof this.init==="function"){this.init();}}
});
S.create=function(s){var A=function A(o){for(var m in s){if(!m.match(/^(metadata|constructor|getContext|destroy)$/)){this[m]=s[m];}else{q.sap.log.warning("The member "+m+" is not allowed for anonymous service declaration and will be ignored!");}}S.apply(this,arguments);};A.prototype=Object.create(S.prototype);return A;};
S.prototype.getInterface=function(){var p=Object.create(null);for(var m in this){if(!m.match(/^_|^metadata$|^constructor$|^getInterface$|^destroy$|^init$|^exit$|^getContext$/)&&typeof this[m]==="function"){p[m]=this[m].bind(this);}}this.getInterface=function(){return p;};return p;};
S.prototype.getContext=function(){return this._oServiceContext;};
S.prototype.destroy=function(){if(typeof this.exit==="function"){this.exit();}B.prototype.destroy.apply(this,arguments);delete this._oServiceContext;};
return S;});
sap.ui.predefine('sap/ui/core/service/ServiceFactory',['jquery.sap.global','sap/ui/base/Object','sap/ui/core/service/Service'],function(q,B,S){"use strict";
var a=B.extend("sap.ui.core.service.ServiceFactory",{
metadata:{"library":"sap.ui.core"},
constructor:function(s){B.apply(this);var f=typeof s==="object"?S.create(s):s;this._fnService=f;}
});
a.prototype.destroy=function(){B.prototype.destroy.apply(this,arguments);delete this._fnService;};
a.prototype.createInstance=function(s){if(typeof this._fnService==="function"){return Promise.resolve(new this._fnService(s));}else{return Promise.reject(new Error("Usage of sap.ui.core.service.ServiceFactory requires a service constructor function to create a new service instance or to override the createInstance function!"));}};
return a;});
sap.ui.predefine('sap/ui/core/service/ServiceFactoryRegistry',['jquery.sap.global','./ServiceFactory'],function(q,S){"use strict";var s=Object.create(null);var a=Object.create(null);
a.register=function(b,o){s[b]=o;return this;};
a.unregister=function(b){delete s[b];return this;};
a.get=function(b){return s[b];};
return a;},true);
sap.ui.predefine('sap/ui/core/theming/Parameters',['jquery.sap.global','sap/ui/thirdparty/URI','../Element','jquery.sap.sjax'],function(q,U,E){"use strict";var c=window["sap-ui-config"]||{};var s=0;if(c['xx-nosync']==='warn'||/(?:\?|&)sap-ui-xx-nosync=(?:warn)/.exec(window.location.search)){s=1;}if(c['xx-nosync']===true||c['xx-nosync']==='true'||/(?:\?|&)sap-ui-xx-nosync=(?:x|X|true)/.exec(window.location.search)){s=2;}var P={};var p=null;var t=null;var a=[];var r=/url[\s]*\('?"?([^\'")]*)'?"?\)/;
function b(){p=null;}
function d(u,T){var M=r.exec(u);if(M){var i=new U(M[1]);if(i.is("relative")){var N=i.absoluteTo(T).normalize().path();u="url('"+N+"')";}}return u;}
function m(C,N,T){for(var i in N){if(typeof C[i]==="undefined"){C[i]=d(N[i],T);}}return C;}
function e(N,T){if(typeof N["default"]!=="object"){N={"default":N,"scopes":{}};}p=p||{};p["default"]=p["default"]||{};p["scopes"]=p["scopes"]||{};m(p["default"],N["default"],T);if(typeof N["scopes"]==="object"){for(var S in N["scopes"]){p["scopes"][S]=p["scopes"][S]||{};m(p["scopes"][S],N["scopes"][S],T);}}}
function f(C){q("link[id^=sap-ui-theme-]").each(function(){C(this.getAttribute("id"),this.href);});}
function l(i,S){var T=new U(S).filename("").query("").toString();var L=document.getElementById(i);var $=q(L);if($.length>0&&q.sap.getUriParameters().get("sap-ui-xx-no-inline-theming-parameters")!=="true"){var D=$.css("background-image");var k=/\(["']data:text\/plain;utf-8,(.*)["']\)$/i.exec(D);if(k&&k.length>=2){var u=k[1];if(u.charAt(0)!=="{"&&u.charAt(u.length-1)!=="}"){try{u=decodeURI(u);}catch(v){q.sap.log.warning("Could not decode theme parameters URI from "+S);}}try{var w=q.parseJSON(u);e(w,T);return;}catch(v){q.sap.log.warning("Could not parse theme parameters from "+S+". Loading library-parameters.json as fallback solution.");}}}var R,x;var y=S.replace(/\/library([^\/.]*)\.(?:css|less)($|[?#])/,function(z,A,B){return"/library-parameters.json"+(B?B:"");});if(s===2){q.sap.log.error("[nosync] Loading library-parameters.json ignored",y,"sap.ui.core.theming.Parameters");return;}else if(s===1){q.sap.log.error("[nosync] Loading library-parameters.json with sync XHR",y,"sap.ui.core.theming.Parameters");}R=q.sap.sjax({url:y,dataType:'json'});if(R.success){x=R.data;if(Array.isArray(x)){for(var j=0;j<x.length;j++){var w=x[j];e(w,T);}}else{e(x,T);}}else{q.sap.log.error("Could not load theme parameters from: "+y,R.error);}}
function g(){if(!p){e({},"");t=sap.ui.getCore().getConfiguration().getTheme();f(l);}return p;}
function h(){a.forEach(function(i){l("sap-ui-theme-"+i.id,i.url);});a=[];}
P._addLibraryTheme=function(T,C){if(p){a.push({id:T,url:C});}};
function n(O){var i=g();if(O.scopeName){i=i["scopes"][O.scopeName];}else{i=i["default"];}var j=i[O.parameterName];if(typeof j==="undefined"&&typeof O.parameterName==="string"){var I=O.parameterName.indexOf(":");if(I!==-1){O.parameterName=O.parameterName.substr(I+1);}j=i[O.parameterName];}if(O.loadPendingParameters&&typeof j==="undefined"){h();j=n({parameterName:O.parameterName,scopeName:O.scopeName,loadPendingParameters:false});}return j;}
function o(j,S){for(var i=0;i<S.length;i++){var C=S[i];for(var k=0;k<C.length;k++){var u=C[k];var v=n({parameterName:j,scopeName:u});if(v){return v;}}}return n({parameterName:j});}
P._getScopes=function(A){if(A&&!p){return;}var i=g();var S=Object.keys(i["scopes"]);return S;};
P.getActiveScopesFor=function(i){var S=[];if(i instanceof E){var j=i.getDomRef();h();var k=this._getScopes();if(j){var N=function(u){var v=j.classList;return v&&v.contains(u);};while(j){var F=k.filter(N);if(F.length>0){S.push(F);}j=j.parentNode;}}else{var C=function(u){return typeof i.hasStyleClass==="function"&&i.hasStyleClass(u);};while(i){var F=k.filter(C);if(F.length>0){S.push(F);}i=typeof i.getParent==="function"&&i.getParent();}}}return S;};
P.get=function(N,k){var u;if(!sap.ui.getCore().isInitialized()){q.sap.log.warning("Called sap.ui.core.theming.Parameters.get() before core has been initialized. "+"This could lead to bad performance and sync XHR as inline parameters might not be available, yet. "+"Consider using the API only when required, e.g. onBeforeRendering.");}if(arguments.length===0){h();var v=g();return q.extend({},v["default"]);}if(!N){return undefined;}if(k instanceof E){h();var S=this.getActiveScopesFor(k);if(typeof N==="string"){return o(N,S);}else if(Array.isArray(N)){var w={};for(var j=0;j<N.length;j++){var x=N[j];w[x]=o(x,S);}return w;}}else{if(typeof N==="string"){u=n({parameterName:N,loadPendingParameters:true});return u;}else if(Array.isArray(N)){var w={};for(var i=0;i<N.length;i++){var x=N[i];w[x]=P.get(x);}return w;}}};
P._setOrLoadParameters=function(L){p={"default":{},"scopes":{}};t=sap.ui.getCore().getConfiguration().getTheme();f(function(i,H){var j=i.substr(13);if(L[j]){q.extend(p["default"],L[j]);}else{l(i,H);}});};
P.reset=function(){var O=arguments[0]===true;if(!O||sap.ui.getCore().getConfiguration().getTheme()!==t){b();}};
P._getThemeImage=function(i,F){i=i||"sapUiGlobalLogo";var j=P.get(i);if(j){var k=r.exec(j);if(k){j=k[1];}else if(j==="''"||j==="none"){j=null;}}if(!!F&&!j){return sap.ui.resource('sap.ui.core','themes/base/img/1x1.gif');}return j;};
return P;},true);
sap.ui.predefine('sap/ui/core/tmpl/DOMAttribute',['sap/ui/core/Element','sap/ui/core/library'],function(E,l){"use strict";
var D=E.extend("sap.ui.core.tmpl.DOMAttribute",{metadata:{library:"sap.ui.core",properties:{name:{type:"string",group:"Data",defaultValue:null},value:{type:"string",group:"Data",defaultValue:null}}}});
D.prototype.setValue=function(v){this.setProperty("value",v,true);var p=this.getParent(),$=p&&p.$();if($&&$.length>0){$.attr(this.getName(),this.getProperty("value"));}return this;};
return D;});
sap.ui.predefine('sap/ui/core/tmpl/DOMElement',['jquery.sap.global','sap/ui/core/Control','sap/ui/core/library','./DOMAttribute'],function(q,C,l,D){"use strict";
var a=C.extend("sap.ui.core.tmpl.DOMElement",{metadata:{library:"sap.ui.core",properties:{text:{type:"string",group:"Appearance",defaultValue:null},tag:{type:"string",group:"Behavior",defaultValue:'span'}},defaultAggregation:"attributes",aggregations:{attributes:{type:"sap.ui.core.tmpl.DOMAttribute",multiple:true,singularName:"attribute"},elements:{type:"sap.ui.core.tmpl.DOMElement",multiple:true,singularName:"element"}}}});
a.prototype.applySettings=function(s){var m=this.getMetadata(),j=m.getJSONKeys();if(s){if(!s["attributes"]){var A=s["attributes"]=[];q.each(s,function(k,v){if(k!=="id"&&!j[k]&&typeof v==="string"){A.push(new D({name:k,value:v}));delete s[k];}});}else{q.sap.log.warning("DOMElement#"+this.getId()+": custom attributes in settings will be ignored since attributes are provided!");}}C.prototype.applySettings.apply(this,arguments);};
a.prototype.exit=a.prototype.onBeforeRendering=function(){var t=this.getTag().toLowerCase();if(t==="input"||t==="textarea"||t==="select"){this.$().off("change");}};
a.prototype.onAfterRendering=function(){var t=this.getTag().toLowerCase();if(t==="input"||t==="textarea"||t==="select"){this.$().on("change",q.proxy(this.oninputchange,this));}};
a.prototype.oninputchange=function(e){var t=this.getTag().toLowerCase();if(t==="input"){var v=this.$().val();this.getAttributes().forEach(function(A){if(A.getName().toLowerCase()==="value"){A.setValue(v);}});}else if(t==="textarea"){var T=this.$().val();this.setText(T);}else if(t==="select"){var T="";this.$().find("select option:selected").each(function(){T+=q(this).text()+" ";});this.setText(T);}};
a.prototype.attr=function(k,v){var A=this.getAttributes(),o;A.forEach(function(V){var n=V.getName();if(n.toLowerCase()===k){o=V;return false;}});if(v===undefined){return o&&o.getValue();}else{if(o){if(v===null){this.removeAttribute(o);}else{o.setValue(v);}}else{if(v!==null){this.addAttribute(new D({name:k,value:v}));}}return this;}};
a.prototype.removeAttr=function(k){this.attr(k,null);return this;};
a.prototype.setText=function(t){this.setProperty("text",t,true);var $=this.$();if($.length>0){var T=this.getTag().toLowerCase();if(T==="textarea"){$.val(this.getProperty("text"));}else{$.text(this.getProperty("text"));}}};
return a;});
sap.ui.predefine('sap/ui/core/tmpl/DOMElementRenderer',['jquery.sap.global'],function(q){"use strict";var D={};
D.render=function(r,e){r.write("<");r.writeEscaped(e.getTag());r.writeControlData(e);e.getAttributes().forEach(function(a){var n=a.getName().toLowerCase();if(n==="class"){var c=a.getValue().split(" ");c.forEach(function(C){var C=C.trim();if(C){r.addClass(q.sap.encodeHTML(C));}});}else if(n==="style"){var s=a.getValue().split(";");s.forEach(function(S){var i=S.indexOf(":");if(i!=-1){var k=S.substring(0,i).trim();var v=S.substring(i+1).trim();r.addStyle(q.sap.encodeHTML(k),q.sap.encodeHTML(v));}});}else{r.writeAttributeEscaped(q.sap.encodeHTML(a.getName()),a.getValue());}});r.writeClasses();r.writeStyles();var E=e.getElements(),h=!!e.getText()||E.length>0;if(!h){r.write("/>");}else{r.write(">");if(e.getText()){r.writeEscaped(e.getText());}E.forEach(function(i,c){r.renderControl(c);});r.write("</");r.writeEscaped(e.getTag());r.write(">");}};
return D;},true);
sap.ui.predefine('sap/ui/core/tmpl/HandlebarsTemplate',['jquery.sap.global','sap/ui/core/Core','./Template','./TemplateControl','sap/ui/thirdparty/handlebars','sap/ui/base/ManagedObject'],function(q,C,T,a,H,M){"use strict";
var b=T.extend("sap.ui.core.tmpl.HandlebarsTemplate",{constructor:function(i,s){T.apply(this,arguments);}});
T.registerType("text/x-handlebars-template","sap.ui.core.tmpl.HandlebarsTemplate");
function d(h){for(var k in h){h[k]=h[k].replace("&gt;",">").replace("&lt;","<").replace("&quot;","\"").replace("&amp;","&");}}
function c(p,P){var r=/^((\w+)>)?(.*)/,e=r.exec(p),s=e[2],f=r.exec(P),g=f[2];var e=r.exec(p);if(P&&s==g){return P+e[3];}else{return p;}}
b.RENDER_HELPERS=(function(){var e=H.helpers["each"],w=H.helpers["with"],I=H.helpers["if"],u=H.helpers["unless"],r=sap.ui.getCore().createRenderManager();r.renderControl=function(o){this.writeControlData(o);this.writeClasses(o);this.writeStyles(o);};var h={"each":function(f,o){o=o||f;if(!o.hash.path){return e.apply(this,arguments);}else{d(o.hash);var R=o.data.renderManager,g=o.data.rootControl,p=o.data.path,P=o.data.parentControl,s=c(o.hash.path,p),i=g.bindList(s),j=[],k;if(o.data){k=H.createFrame(o.data);}if(i){for(var K in i){if(k){k.renderManager=R;k.rootControl=g;k.path=s+"/"+K+"/";k.parentControl=P;}j.push(o.fn({},{data:k}));}}if(!P){return new H.SafeString(j.join(""));}}},"with":function(f,o){o=o||f;if(!o.hash.path){return w.apply(this,arguments);}},"if":function(f,o){o=o||f;if(!o.hash.path){return I.apply(this,arguments);}else{d(o.hash);var R=o.data.rootControl,p=o.data.path,P=c(o.hash.path,p);if(P){var v=R.bindProp(P);if(v){return o.fn(this);}else{return o.inverse(this);}}}},"unless":function(f,o){o=o||f;if(!o.hash.path){return u.apply(this,arguments);}else{d(o.hash);var R=o.data.rootControl,p=o.data.path,P=c(o.hash.path,p);if(P){var v=R.bindProp(P);if(!v){return o.fn(this);}else{return o.inverse(this);}}}},"text":function(f,o){o=o||f;d(o.hash);var R=o.data.rootControl,p=o.data.path,P=c(o.hash.path,p);if(P){var v=R.bindProp(P);return v&&new H.SafeString(q.sap.encodeHTML(v));}else{throw new Error("The expression \"text\" requires the option \"path\"!");}},"element":function(f,o){o=o||f;d(o.hash);var R=o.data.renderManager,g=o.data.rootControl,E=g.createDOMElement(o.hash,o.data.path),p=o.data.parentElement;if(o.fn){o.fn({},{data:{renderManager:R,rootControl:g,parentElement:E}});}if(p){p.addElement(E);return;}return new H.SafeString(R.getHTML(E));},"control":function(f,o){o=o||f;d(o.hash);var R=o.data.renderManager,g=o.data.control;if(g){return new H.SafeString(R.getHTML(g));}var j=o.data.rootControl,p=o.data.path,P=o.data.children,t=o.hash["sap-ui-type"],k=q.sap.getObject(t),m=k&&k.getMetadata(),D=o.hash["sap-ui-default-aggregation"]||m&&m.getDefaultAggregationName(),v=o.data.view;if(!k){throw new Error("Control of type "+t+" cannot be found.");}var n={};if(o.fn){o.fn({},{data:{rootControl:j,path:p,children:n,defaultAggregation:D,view:v}});}var s=q.extend({},o.hash),S;for(var K in s){if(K==="sap-ui-class"&&typeof s[K]==="string"){S=s["sap-ui-class"]&&s["sap-ui-class"].split(" ");delete s[K];}else if(n[K]){delete s[K];}}var N=j.createControl(s,o.data.path,!!P,v);if(S&&S.length>0){S.forEach(N.addStyleClass.bind(N));}if(!q.isEmptyObject(n)){s=o.hash;var A=m.getAllAggregations();for(var x in n){var y=n[x];for(var i=0,l=y.length;i<l;i++){var z=y[i],B=A[x],E=B&&B.multiple;if(typeof s[x]==="string"){var F=M.bindingParser(s[x],v&&v.getController());F.template=z;N.bindAggregation(x,F);}else{if(E){N.addAggregation(x,z);}else{N.setAggregation(x,z);}}}}}if(P){var x=o.hash["sap-ui-aggregation"]||o.data.defaultAggregation;P[x]=P[x]||[];P[x].push(N);return;}return new H.SafeString(R.getHTML(N));},"property":function(f,o){o=o||f;d(o.hash);var R=o.data.rootControl,m=R.getMetadata(),p=o.hash.name,g=m.getProperty(p)._sGetter;return R[g]();},"aggregation":function(f,o){o=o||f;d(o.hash);if(o.data.children){var A=o.hash.name;if(o.fn){var D=q.extend({},o.data,{defaultAggregation:A});o.fn({},{data:D});}}else{var R=o.data.renderManager,g=o.data.rootControl,m=g.getMetadata(),A=o.hash.name,G=m.getAggregation(A)._sGetter,j=[];var k=g[G]();if(k){for(var i=0,l=k.length;i<l;i++){if(o.fn){j.push(o.fn({},{data:{renderManager:R,rootControl:g,control:k[i]}}));}else{j.push(R.getHTML(k[i]));}}}return new H.SafeString(j.join(""));}},"event":function(f,o){o=o||f;},"controlData":function(f,o){o=o||f;var R=o.data.rootControl;return new H.SafeString(r.getHTML(R));}};return h;}());
b.prototype.createMetadata=function(){var t=this.getContent(),f=this._fnTemplate=this._fnTemplate||H.compile(t);var m={},j=a.getMetadata().getAllSettings(),p=a.getMetadata().getAllPrivateAggregations();var h={"property":function(e,o){o=o||e;d(o.hash);var n=o.hash.name;if(n&&n!=="id"&&!j[n]){m.properties=m.properties||{};m.properties[n]=q.extend({},{type:"string"},o.hash);}else{throw new Error("The property name \""+n+"\" is reserved.");}},"aggregation":function(e,o){o=o||e;d(o.hash);var n=o.hash.name;if(n&&!j[n]&&!p[n]){o.hash.multiple=o.hash.multiple=="true";m.aggregations=m.aggregations||{};m.aggregations[n]=q.extend({},o.hash);}else{throw new Error("The aggregation name \""+n+"\" is reserved.");}},"event":function(e,o){o=o||e;},"controlData":function(e,o){o=o||e;m._hasControlData=true;}};["each","if","unless","with"].forEach(function(v){h[v]=function(){};});f({},{helpers:h});return m;};
b.prototype.createRenderer=function(v){var t=this.getContent(),f=this._fnTemplate=this._fnTemplate||H.compile(t);var r=function(e,o){var h=f(o.getContext()||{},{data:{renderManager:e,rootControl:o,view:v},helpers:b.RENDER_HELPERS});e.write(h);};return r;};
return b;});
sap.ui.predefine('sap/ui/core/tmpl/Template',['jquery.sap.global','sap/ui/base/ManagedObject','sap/ui/base/BindingParser','sap/ui/core/Control','sap/ui/core/RenderManager','jquery.sap.sjax'],function(q,M,B,C,R){"use strict";
var T=M.extend("sap.ui.core.tmpl.Template",{
constructor:function(i,s){M.apply(this,arguments);},
metadata:{stereotype:"template","abstract":true,library:"sap.ui.core",properties:{"content":{type:"string",group:"Data",defaultValue:null}},publicMethods:["declareControl","createControl","placeAt","createMetadata","createRenderer"]}
});
var t={};
T.prototype.register=function(){var i=this.getId(),o=t[i],m;if(o&&this!==o){m="adding template with duplicate id '"+i+"'";q.sap.log.error(m);throw new Error("Error: "+m);}t[i]=this;};
T.prototype.deregister=function(){delete t[this.getId()];};
T.byId=function(i){return t[i];};
T.prototype.getInterface=function(){return this;};
T._mSupportedTypes={};
T.registerType=function(s,c){T._mSupportedTypes[s]=c;};
T.unregisterType=function(s){delete T._mSupportedTypes[s];};
T.parsePath=function(p){var m,s=p.indexOf(">");if(s>0){m=p.substr(0,s);p=p.substr(s+1);}return{path:p,model:m};};
T.prototype.init=function(s,S){if(this.getMetadata().getName()==="sap.ui.core.tmpl.Template"){throw new Error("The class 'sap.ui.core.tmpl.Template' is abstract and must not be instantiated!");}if(M.bindingParser===B.complexParser){T.prototype.extractBindingInfo=function(v,i,S){M.bindingParser=B.simpleParser;var r=C.prototype.extractBindingInfo.apply(this,arguments);M.bindingParser=B.complexParser;return r;};}};
T.prototype.declareControl=function(c){if(c){var m=this.createMetadata(),r=this.createRenderer(),a=this;var b=sap.ui.requireSync('sap/ui/core/tmpl/TemplateControl');b.extend(c,{metadata:m,init:function(){b.prototype.init.apply(this,arguments);this.setTemplate(a);},renderer:{renderTemplate:r,hasControlData:m._hasControlData}});return q.sap.getObject(c);}};
T.prototype.createControl=function(i,c,v){var a=sap.ui.requireSync('sap/ui/core/tmpl/TemplateControl');var o=new a({id:i,template:this,context:c});o.setTemplateRenderer(this.createRenderer(v));return o;};
T.prototype.placeAt=function(r,c,p,i){if(typeof c==="string"||typeof c==="number"){p=c;c=undefined;}var I;if(!(r instanceof C)&&i){var $=typeof r==="string"?q.sap.byId(r):q(r);if($.length>0){I=$.attr("id");r=$.get(0);var s=$.attr("data-context");c=c||s&&q.parseJSON(s);R.markInlineTemplate($);}}var o=this.createControl(I,c);o.placeAt(r,p);return o;};
T.prototype.createMetadata=function(){q.sap.log.error("The function createMetadata is an abstract function which needs to be implemented by subclasses.");};
T.prototype.createRenderer=function(){q.sap.log.error("The function createRenderer is an abstract function which needs to be implemented by subclasses.");};
sap.ui.template=function(o){if(!o){var a=[];q.each(T._mSupportedTypes,function(s,j){q("script[type='"+s+"'], [data-type='"+s+"']").each(function(n,E){a.push(sap.ui.template({id:E.id,domref:E,type:s,_class:j}));});});return a;}else{if(typeof o==="string"){return sap.ui.template({id:o});}else if(o&&o.tagName&&o.nodeName&&o.ownerDocument&&o.nodeType===1){return sap.ui.template({id:o.id,domref:o});}o=q.extend({type:T.DEFAULT_TEMPLATE},o);var i,s,c,b,d=false,l=typeof o.src==="string",I=false;if(l){var r=q.sap.sjax({url:o.src,dataType:"text"});if(r.success){i=o.id;s=o.type;c=o.control;b=r.data;var e=/^<!--\sUI5:Template\stype=([a-z\/\-]*)\s(?:controller=([A-Za-z.]*)\s)?-->/,f=b.match(e);if(f){s=f[1];if(f.length==3){d=f[2];}b=b.substr(f[0].length);}}else{throw new Error("The template could not be loaded from "+o.src+"!");}}else{var E=o.domref||q.sap.domById(o.id),$=q(E);I=false;i=o.id||E&&E.id;s=$.attr("type")||o.type;c=$.attr("data-control")||o.control;if(i){var g=sap.ui.getCore().getTemplate(i);if(!g instanceof T){throw new Error("Object for id \""+i+"\" is no sap.ui.core.tmpl.Template!");}else{if(g){return g;}}}if($.length===0){throw new Error("DOM element for the Template with the id \""+i+"\" not found!");}b=$.html();var h=E.tagName.toLowerCase();if(h!=="script"){I=$.parents("body").length===1;}}var j=o._class;if(!j){j=T._mSupportedTypes[s];if(!j){throw new Error("The type \""+s+"\" is not supported.");}}q.sap.require(j);var k=q.sap.getObject(j);var m=new k({id:i,content:b});if(c){m.declareControl(c);}if(d){m._sControllerName=d;}if(I){m.placeAt(i,o.context,undefined,true);}return m;}};
T.DEFAULT_TEMPLATE="text/x-handlebars-template";T.registerType(T.DEFAULT_TEMPLATE,"sap.ui.core.tmpl.HandlebarsTemplate");return T;});
sap.ui.predefine('sap/ui/core/tmpl/TemplateControl',['jquery.sap.global','sap/ui/core/Control','sap/ui/core/DeclarativeSupport','sap/ui/core/library','sap/ui/core/UIArea','./DOMElement','./Template'],function(q,C,D,l,U,a,T){"use strict";
var b=C.extend("sap.ui.core.tmpl.TemplateControl",{metadata:{library:"sap.ui.core",properties:{context:{type:"object",group:"Data",defaultValue:null}},aggregations:{controls:{type:"sap.ui.core.Control",multiple:true,singularName:"control",visibility:"hidden"}},associations:{template:{type:"sap.ui.core.tmpl.Template",multiple:false}},events:{afterRendering:{},beforeRendering:{}}}});
b.prototype.init=function(){this._aBindingInfos=[];};
b.prototype.isInline=function(){var i=false,p=this.getParent();if(p instanceof U&&q(p.getRootNode()).attr("id")===this.getId()){i=true;}return i;};
b.prototype.placeAt=function(r,p){var i=this.isInline();var $=this.$(),u=this.getUIArea();C.prototype.placeAt.apply(this,arguments);if(i&&$.length===1){$.remove();u.destroyContent();}};
b.prototype.getTemplateRenderer=function(){return this.fnRenderer;};
b.prototype.setTemplateRenderer=function(r){this.fnRenderer=r;return this;};
b.prototype._cleanup=function(){this.destroyAggregation("controls");this._aBindingInfos.forEach(function(B){var o=B.binding;if(o){o.detachChange(B.changeHandler);o.destroy();}});this._aBindingInfos=[];};
b.prototype._compile=function(){var t=sap.ui.getCore().byId(this.getTemplate()),d=t&&t.getDeclarativeSupport();if(d){var c=this;setTimeout(function(){D.compile(c.getDomRef());});}};
b.prototype.exit=function(){this._cleanup();};
b.prototype.onBeforeRendering=function(){this.fireBeforeRendering();this._cleanup();};
b.prototype.onAfterRendering=function(){this.fireAfterRendering();};
b.prototype.clone=function(){var c=C.prototype.clone.apply(this,arguments);c.fnRenderer=this.fnRenderer;return c;};
b.prototype.updateBindings=function(u,m){C.prototype.updateBindings.apply(this,arguments);if(this.getDomRef()){this.invalidate();}};
b.prototype.bind=function(p,t){var P=T.parsePath(p),m=this.getModel(P.model),p=P.path,M=t?"bind"+q.sap.charToUpperCase(t):"bindProperty",B=m&&m[M](p),o={binding:B,path:P.path,model:P.model};if(B){o.changeHandler=function(){q.sap.log.debug("TemplateControl#"+this.getId()+": "+t+" binding changed for path \""+p+"\"");this.invalidate();}.bind(this);B.attachChange(o.changeHandler);}this._aBindingInfos.push(o);return B;};
b.prototype.calculatePath=function(p,t){var B=this.getBindingContext(),s=B&&B.getPath();if(p&&s&&!q.sap.startsWith(p,"/")){if(!q.sap.endsWith(s,"/")){s+="/";}p=s+p;}return p;};
b.prototype.bindProp=function(p){var B=this.bind(this.calculatePath(p),"property");return B&&B.getExternalValue();};
b.prototype.bindList=function(p){var B=this.bind(this.calculatePath(p),"list"),m=B&&B.getModel(),p=B&&B.getPath();return B&&m.getProperty(p);};
b.prototype.createDOMElement=function(s,p,d){var e=new a(s);if(p){e.bindObject(p);}if(!d){this.addAggregation("controls",e);}return e;};
b.prototype.createControl=function(s,p,d,v){var h={};q.each(s,function(k,V){h["data-"+q.sap.hyphen(k)]=V;});var $=q("<div/>",h);var c=D._createControl($.get(0),v);if(p){c.bindObject(p);}if(!d){this.addAggregation("controls",c);}return c;};
return b;});
sap.ui.predefine('sap/ui/core/tmpl/TemplateControlRenderer',function(){"use strict";var T={};
T.render=function(r,c){var s=c.isInline()||this.hasControlData;if(!s){r.write("<div");r.writeControlData(c);r.writeStyles();r.writeClasses();r.write(">");}var R=this.renderTemplate||c.getTemplateRenderer();if(R){R.apply(this,arguments);}if(!s){r.write("</div>");}};
return T;},true);
sap.ui.predefine('sap/ui/core/util/DraftEnabledMockServer',["jquery.sap.global","sap/ui/Device","sap/ui/core/util/MockServer","jquery.sap.sjax"],function(q,D,M){"use strict";return{_oDraftMetadata:{},_oConstants:{COM_SAP_VOCABULARIES_COMMON_V1_DRAFTROOT:"com.sap.vocabularies.Common.v1.DraftRoot",COM_SAP_VOCABULARIES_COMMON_V1_DRAFTNODE:"com.sap.vocabularies.Common.v1.DraftNode",COM_SAP_VOCABULARIES_COMMON_V1_SEMANTICKEY:"com.sap.vocabularies.Common.v1.SemanticKey",EMPTY_GUID:"00000000-0000-0000-0000-000000000000",SIBLINGENTITY_NAVIGATION:"SiblingEntity",DRAFT_ADMINISTRATIVE_DATA:"DraftAdministrativeData",DRAFT_ADMINISTRATIVE_DATA_UUID:"DraftAdministrativeDataUUID",ACTIVATION_ACTION:"ActivationAction",EDIT_ACTION:"EditAction",VALIDATE_ACTION:"ValidationFunction",PREPARE_ACTION:"PreparationAction"},handleDraft:function(a,m){var n=function(b){var N=b.getParameter("oEntity");N.IsActiveEntity=false;N.HasActiveEntity=false;N.HasDraftEntity=false;};var d=function(b){var x=b.getParameter("oXhr");var c=q.sap.sjax({url:x.url,dataType:"json"}).data.d;for(var i=0;i<this._oDraftMetadata.draftNodes.length;i++){for(var f in this._mEntitySets[this._oDraftMetadata.draftRootName].navprops){if(this._mEntitySets[this._oDraftMetadata.draftRootName].navprops[f].to.entitySet===this._oDraftMetadata.draftNodes[i]){var r=q.sap.sjax({url:c[f].__deferred.uri,dataType:"json"});if(r.data&&r.data.d&&r.data.d.results){var N;for(var j=0;j<r.data.d.results.length;j++){N=r.data.d.results[j];q.sap.sjax({url:N.__metadata.uri,type:"DELETE"});}}}}}};if(a&&a.EntityContainer){var e=a.EntityContainer[Object.keys(a.EntityContainer)[0]];for(var E in e){var o=e[E];if(o[this._oConstants.COM_SAP_VOCABULARIES_COMMON_V1_DRAFTROOT]){this._oDraftMetadata.draftRootName=E;this._oDraftMetadata.annotations=a;this._oDraftMetadata.mockServerRootUri=m.getRootUri();if(o[this._oConstants.COM_SAP_VOCABULARIES_COMMON_V1_DRAFTROOT][this._oConstants.ACTIVATION_ACTION]){this._oDraftMetadata.draftRootActivationName=o[this._oConstants.COM_SAP_VOCABULARIES_COMMON_V1_DRAFTROOT][this._oConstants.ACTIVATION_ACTION].String;}if(this._oDraftMetadata.draftRootActivationName){this._oDraftMetadata.draftRootActivationName=this._oDraftMetadata.draftRootActivationName.substring(this._oDraftMetadata.draftRootActivationName.lastIndexOf("/")+1);}this._oDraftMetadata.draftRootEditName=o[this._oConstants.COM_SAP_VOCABULARIES_COMMON_V1_DRAFTROOT][this._oConstants.EDIT_ACTION];this._oDraftMetadata.draftRootEditName=this._oDraftMetadata.draftRootEditName?this._oDraftMetadata.draftRootEditName.String:undefined;if(this._oDraftMetadata.draftRootEditName){this._oDraftMetadata.draftRootEditName=this._oDraftMetadata.draftRootEditName.substring(this._oDraftMetadata.draftRootEditName.lastIndexOf("/")+1);}this._oDraftMetadata.draftRootValidationName=o[this._oConstants.COM_SAP_VOCABULARIES_COMMON_V1_DRAFTROOT][this._oConstants.VALIDATE_ACTION];this._oDraftMetadata.draftRootValidationName=this._oDraftMetadata.draftRootValidationName?this._oDraftMetadata.draftRootValidationName.String:undefined;if(this._oDraftMetadata.draftRootValidationName){this._oDraftMetadata.draftRootValidationName=this._oDraftMetadata.draftRootValidationName.substring(this._oDraftMetadata.draftRootValidationName.lastIndexOf("/")+1);}this._oDraftMetadata.draftRootPreparationtionName=o[this._oConstants.COM_SAP_VOCABULARIES_COMMON_V1_DRAFTROOT][this._oConstants.PREPARE_ACTION];this._oDraftMetadata.draftRootPreparationtionName=this._oDraftMetadata.draftRootPreparationtionName?this._oDraftMetadata.draftRootPreparationtionName.String:undefined;if(this._oDraftMetadata.draftRootPreparationtionName){this._oDraftMetadata.draftRootPreparationtionName=this._oDraftMetadata.draftRootPreparationtionName.substring(this._oDraftMetadata.draftRootPreparationtionName.lastIndexOf("/")+1);}q.extend(m,this);m.attachAfter(M.HTTPMETHOD.POST,n,this._oDraftMetadata.draftRootName);m.attachBefore(M.HTTPMETHOD.DELETE,d,this._oDraftMetadata.draftRootName);m.attachAfter(M.HTTPMETHOD.GET,this._fnDraftAdministrativeData,this._oDraftMetadata.draftRootName);}}}},_calcSemanticKeys:function(e,E){var s=[];for(var a in this._oDraftMetadata.annotations){if(a.lastIndexOf(E[e].type)>-1){s=this._oDraftMetadata.annotations[a][this._oConstants.COM_SAP_VOCABULARIES_COMMON_V1_SEMANTICKEY]||[];break;}}var S=[];var b;for(var i=0;i<s.length;i++){b=s[i];for(var k in b){S.push(b[k]);}}return S;},_prepareDraftMetadata:function(e){var t=this;this._oDraftMetadata.draftNodes=[];this._oDraftMetadata.draftRootKey=e[this._oDraftMetadata.draftRootName].keys.filter(function(x){return q.inArray(x,t._calcSemanticKeys(t._oDraftMetadata.draftRootName,e))<0;})[0];var a=t._oDraftMetadata.annotations;var E=a.EntityContainer[Object.keys(a.EntityContainer)[0]];for(var s in E){var o=E[s];if(o[t._oConstants.COM_SAP_VOCABULARIES_COMMON_V1_DRAFTNODE]){this._oDraftMetadata.draftNodes.push(s);}}for(var j=0;j<this._oDraftMetadata.draftNodes.length;j++){this.attachAfter(M.HTTPMETHOD.GET,this._fnDraftAdministrativeData,this._oDraftMetadata.draftNodes[j]);}},_fnDraftAdministrativeData:function(e){var E={};var d=e.getParameter("oFilteredData");if(!d){E=e.getParameter("oEntry");if(E.IsActiveEntity&&!E.HasDraftEntity){E[this._oConstants.DRAFT_ADMINISTRATIVE_DATA]=null;}}else{if(d.results){d=d.results;}else{if(q.isEmptyObject(d)){d=null;return;}}for(var i=0;i<d.length;i++){E=d[i];if(E.IsActiveEntity&&!E.HasDraftEntity){E[this._oConstants.DRAFT_ADMINISTRATIVE_DATA]=null;}}}},_handleDraftArtifacts:function(e){var t=this;var m=this._oMockdata;var d=m[this._oDraftMetadata.draftRootName];var g=function(c,C){return c.filter(function(x){return q.inArray(x,C)<0;})[0];};if(d.length===100){for(var i=0;i<d.length;i++){var E=d[i];if(i<25){E.IsActiveEntity=true;E.HasActiveEntity=false;E.HasDraftEntity=false;E[this._oDraftMetadata.draftRootKey]=this._oConstants.EMPTY_GUID;if(E[this._oConstants.DRAFT_ADMINISTRATIVE_DATA_UUID]){E[this._oConstants.DRAFT_ADMINISTRATIVE_DATA_UUID]=null;}var a=[];var s=[];for(var j=0;j<this._oDraftMetadata.draftNodes.length;j++){s=this._calcSemanticKeys(this._oDraftMetadata.draftNodes[j],e);a=m[this._oDraftMetadata.draftNodes[j]];var o=e[this._oDraftMetadata.draftRootName];for(var n in o.navprops){var N=o.navprops[n];if(N.to.entitySet===this._oDraftMetadata.draftNodes[j]){var p=N.from.propRef.length;for(var k=0;k<p;k++){a[i][N.to.propRef[k]]=E[N.from.propRef[k]];}}}a[i].IsActiveEntity=true;a[i].HasActiveEntity=false;a[i].HasDraftEntity=false;a[i][this._oDraftMetadata.draftRootKey]=this._oConstants.EMPTY_GUID;if(a[i][this._oConstants.DRAFT_ADMINISTRATIVE_DATA_UUID]){a[i][this._oConstants.DRAFT_ADMINISTRATIVE_DATA_UUID]=null;}var b=g(e[this._oDraftMetadata.draftNodes[j]].keys,s);a[i][b]=this._oConstants.EMPTY_GUID;}}else if(i<50){E.IsActiveEntity=false;E.HasActiveEntity=false;E.HasDraftEntity=false;a=[];s=[];for(var j=0;j<this._oDraftMetadata.draftNodes.length;j++){s=this._calcSemanticKeys(this._oDraftMetadata.draftNodes[j],e);a=m[this._oDraftMetadata.draftNodes[j]];var o=e[this._oDraftMetadata.draftRootName];for(var n in o.navprops){var N=o.navprops[n];if(N.to.entitySet===this._oDraftMetadata.draftNodes[j]){var p=N.from.propRef.length;for(var k=0;k<p;k++){a[i][N.to.propRef[k]]=E[N.from.propRef[k]];}}}a[i].IsActiveEntity=false;a[i].HasActiveEntity=false;a[i].HasDraftEntity=false;b=g(e[this._oDraftMetadata.draftNodes[j]].keys,s);}}else if(i<75){var S=q.extend(true,{},E);E.IsActiveEntity=true;E.HasActiveEntity=false;E.HasDraftEntity=true;E[this._oDraftMetadata.draftRootKey]=this._oConstants.EMPTY_GUID;a=[];s=[];for(var j=0;j<this._oDraftMetadata.draftNodes.length;j++){s=this._calcSemanticKeys(this._oDraftMetadata.draftNodes[j],e);a=m[this._oDraftMetadata.draftNodes[j]];var o=e[this._oDraftMetadata.draftRootName];for(var n in o.navprops){var N=o.navprops[n];if(N.to.entitySet===this._oDraftMetadata.draftNodes[j]){var p=N.from.propRef.length;for(var k=0;k<p;k++){a[i][N.to.propRef[k]]=E[N.from.propRef[k]];}}}a[i].IsActiveEntity=true;a[i].HasActiveEntity=false;a[i].HasDraftEntity=true;b=g(e[this._oDraftMetadata.draftNodes[j]].keys,s);a[i][b]=this._oConstants.EMPTY_GUID;}S.IsActiveEntity=false;S.HasActiveEntity=true;S.HasDraftEntity=false;d[i+25]=S;}}}var r=this._getRootUri();q.each(e,function(c,o){q.each(m[c],function(I,f){f.__metadata=f.__metadata||{};f.__metadata.uri=r+c+"("+t._createKeysString(o,f)+")";f.__metadata.type=o.schema+"."+o.type;q.each(o.navprops,function(K){f[K]={__deferred:{uri:r+c+"("+t._createKeysString(o,f)+")/"+K}};});});});},_activate:function(e){var r;var g=function(c,C){return c.filter(function(x){return q.inArray(x,C)<0;})[0];};for(var i=0;i<this._oDraftMetadata.draftNodes.length;i++){for(var n in this._mEntitySets[this._oDraftMetadata.draftRootName].navprops){if(this._mEntitySets[this._oDraftMetadata.draftRootName].navprops[n].to.entitySet===this._oDraftMetadata.draftNodes[i]){r=q.sap.sjax({url:e[n].__deferred.uri,dataType:"json"});if(r.success&&r.data&&r.data.d&&r.data.d.results){var N;for(var j=0;j<r.data.d.results.length;j++){N=r.data.d.results[j];N.IsActiveEntity=true;N.HasActiveEntity=false;N.HasDraftEntity=false;N[this._oDraftMetadata.draftRootKey]=this._oConstants.EMPTY_GUID;var s=this._calcSemanticKeys(this._oDraftMetadata.draftNodes[i],this._mEntitySets);var d=g(this._mEntitySets[this._oDraftMetadata.draftNodes[i]].keys,s);N[d]=this._oConstants.EMPTY_GUID;q.sap.sjax({url:N.__metadata.uri,type:"PATCH",data:JSON.stringify(N)});}}}}}e.IsActiveEntity=true;e.HasActiveEntity=false;e.HasDraftEntity=false;e[this._oDraftMetadata.draftRootKey]=this._oConstants.EMPTY_GUID;q.sap.sjax({url:e.__metadata.uri,type:"PATCH",data:JSON.stringify(e)});return e;},setRequests:function(r){var t=this;r.push({method:"POST",path:new RegExp(t._oDraftMetadata.draftRootActivationName),response:function(x){var R=JSON.parse(x.requestBody);var f=[];for(var p in R){f.push(p+" eq "+R[p]);}var o=q.sap.sjax({url:t._oDraftMetadata.mockServerRootUri+t._oDraftMetadata.draftRootName+"?$filter="+f.join(" and "),dataType:"json"});if(!o.success||!o.data.d.results[0]){x.respond(404);}var e=o.data.d.results[0];if(e.IsActiveEntity){x.respond(400);}if(e.HasActiveEntity){var s=e.SiblingEntity.__deferred.uri;o=q.sap.sjax({url:s,dataType:"json"});if(o.success&&o.data&&o.data.d.__metadata){var S=o.data.d;o=q.sap.sjax({url:S.__metadata.uri,type:"DELETE"});}}e=t._activate(e);x.respondJSON(200,{},JSON.stringify({d:e}));return true;}});if(t._oDraftMetadata.draftRootEditName){r.push({method:"POST",path:new RegExp(t._oDraftMetadata.draftRootEditName+"(\\?(.*))?"),response:function(x,u){var f=[];var R=JSON.parse(x.requestBody);if(R&&!q.isEmptyObject(R)){for(var p in R){f.push(p+" eq "+R[p]);}}else{var U=decodeURIComponent(u).replace("?","&").split("&");for(var a in U){var P=U[a];var b=new RegExp("(.*)=(.*)");var c;if(P){c=b.exec(P);f.push(c[1]+" eq "+c[2]);}}}var o=q.sap.sjax({url:t._oDraftMetadata.mockServerRootUri+t._oDraftMetadata.draftRootName+"?$filter="+f.join(" and "),dataType:"json"});if(!o.success||!o.data.d.results[0]){x.respond(404);}var e=o.data.d.results[0];if(!e.IsActiveEntity||e.HasDraftEntity){x.respond(400);}var d=q.extend(true,{},e);d.IsActiveEntity=false;d.HasActiveEntity=true;d.HasDraftEntity=false;d[t._oDraftMetadata.draftRootKey]=t._generatePropertyValue(t._oDraftMetadata.draftRootKey,"Guid");var s=t._getRootUri();var E=t._mEntitySets[t._oDraftMetadata.draftRootName];d.__metadata=d.__metadata||{};d.__metadata.uri=s+t._oDraftMetadata.draftRootName+"("+t._createKeysString(E,d)+")";d.__metadata.type=E.schema+"."+E.type;q.each(E.navprops,function(k){d[k]={__deferred:{uri:s+t._oDraftMetadata.draftRootName+"("+t._createKeysString(E,d)+")/"+k}};});t._oMockdata[t._oDraftMetadata.draftRootName].push(d);o=q.sap.sjax({url:e.__metadata.uri,type:"PATCH",data:JSON.stringify({HasDraftEntity:true})});x.respondJSON(200,{},JSON.stringify({d:d}));return true;}});}if(t._oDraftMetadata.draftRootValidationName){r.push({method:"GET",path:new RegExp(t._oDraftMetadata.draftRootValidationName+"(\\?(.*))?"),response:function(x,u){var v=t._oDraftMetadata.draftRootValidationName;t.fireEvent(M.HTTPMETHOD.GET+v+":before",{oXhr:x,sUrlParams:u});t.fireEvent(M.HTTPMETHOD.GET+":before",{oXhr:x,sUrlParams:u});var R={d:{}};R.d[v]={"__metadata":{"type":"ValidationResult"},"IsValid":true};t.fireEvent(M.HTTPMETHOD.GET+v+":after",{oXhr:x,oResult:R});t.fireEvent(M.HTTPMETHOD.GET+":after",{oXhr:x,oResult:R});x.respondJSON(200,{},JSON.stringify(R));return true;}});}if(t._oDraftMetadata.draftRootPreparationtionName){r.push({method:"POST",path:new RegExp(t._oDraftMetadata.draftRootPreparationtionName),response:function(x){t.fireEvent(M.HTTPMETHOD.POST+t._oDraftMetadata.draftRootPreparationtionName+":before",{oXhr:x});t.fireEvent(M.HTTPMETHOD.POST+":before",{oXhr:x});var R=JSON.parse(x.requestBody);var f=[];for(var p in R){f.push(p+" eq "+R[p]);}var o=q.sap.sjax({url:t._oDraftMetadata.mockServerRootUri+t._oDraftMetadata.draftRootName+"?$filter="+f.join(" and "),dataType:"json"});if(!o.success||!o.data.d.results[0]){x.respond(404);}var e=o.data.d.results[0];t.fireEvent(M.HTTPMETHOD.POST+t._oDraftMetadata.draftRootPreparationtionName+":after",{oXhr:x,oEntry:e});t.fireEvent(M.HTTPMETHOD.POST+":after",{oXhr:x,oEntry:e});x.respondJSON(200,{},JSON.stringify({d:e}));return true;}});}M.prototype.setRequests.apply(this,[r]);},_generateMockdata:function(e,b){M.prototype._generateMockdata.apply(this,[e,b]);this._handleDraftArtifacts(e);},_loadMockdata:function(e,b){M.prototype._loadMockdata.apply(this,[e,b]);this._handleDraftArtifacts(e);},_resolveNavigation:function(e,f,n,E){var a=M.prototype._resolveNavigation.apply(this,[e,f,n,E]);if(n===this._oConstants.SIBLINGENTITY_NAVIGATION){if(E&&E.IsActiveEntity){a.splice(0,1);}else{a.length>1?a.splice(1,1):a.splice(0,1);}}else if(n===this._oConstants.DRAFT_ADMINISTRATIVE_DATA){if(E){if(E.IsActiveEntity&&!E.HasDraftEntity){a[0]=null;}}else{a[0]=null;}}return a;},_findEntitySets:function(m){var e=M.prototype._findEntitySets.apply(this,[m]);this._prepareDraftMetadata(e);return e;},getEntitySetData:function(e){var E=M.prototype.getEntitySetData.apply(this,[e]);var g=function(){return E;};if(e===this._oDraftMetadata.draftRootName){this._fnDraftAdministrativeData({getParameter:g});return E;}for(var j=0;j<this._oDraftMetadata.draftNodes.length;j++){if(e===this._oDraftMetadata.draftNodes[j]){this._fnDraftAdministrativeData({getParameter:g});return E;}}return E;}};},true);
sap.ui.predefine('sap/ui/core/util/Export',['jquery.sap.global','sap/ui/core/Control','./ExportColumn','./ExportRow','./ExportType','./File'],function(q,C,E,a,b,F){'use strict';
function w(f,o){if(f){return function(){return f.apply(o,arguments);};}else{return f;}}
function p(m){q.sap.log.warning("Usage of deprecated jQuery Promise method: '"+m+"'. "+"Please use the standard Promise methods 'then' / 'catch' instead!","","sap.ui.core.util.Export");}
function c(P,o){var O=new Promise(P);o=o||O;var r=false,R=false;O.then(function(v){r=true;return v;},function(e){R=true;throw e;});var m={then:O.then,"catch":O["catch"]};function f(e){e.then=function(s,g){var A=[w(s,o),w(g,o)];return f(m.then.apply(e,A),o);};e["catch"]=function(g){var A=[w(g,o)];return f(m["catch"].apply(e,A),o);};[{jq:"done",es6:"then"},{jq:"fail",es6:"catch"},{jq:"always",es6:"then"}].forEach(function(g){e[g.jq]=function(){p(g.jq);var h=null;Array.prototype.concat.apply([],arguments).forEach(function(i){var W=w(i,o);var j=function(v){W.apply(this,arguments);return v;};var A=[j];if(g.jq==="always"){A.push(j);}if(!h){h=m[g.es6].apply(e,A);}else{h=h[g.es6].apply(h,A);}});return f(h,o);};});e.pipe=function(D,g){p("pipe");return e.then(D,g);};e.state=function(){p("state");if(r){return"resolved";}else if(R){return"rejected";}else{return"pending";}};return e;}return f(O);}
var d=C.extend('sap.ui.core.util.Export',{metadata:{publicMethods:["generate","saveFile"],library:"sap.ui.core",aggregations:{exportType:{type:'sap.ui.core.util.ExportType',multiple:false},columns:{type:'sap.ui.core.util.ExportColumn',multiple:true,bindable:'bindable'},rows:{type:'sap.ui.core.util.ExportRow',multiple:true,bindable:'bindable'},_template:{type:'sap.ui.core.util.ExportRow',multiple:false,visibility:'hidden'}}}});
d.getMetadata().getAggregation("rows")._doesNotRequireFactory=true;
d.prototype.init=function(){this._oPromise=null;this._fnResolvePromise=null;this._oRowBindingArgs=null;};
d.prototype.exit=function(){delete this._oPromise;delete this._fnResolvePromise;delete this._oRowBindingArgs;};
d.prototype._createRowTemplate=function(){var t=new a(this.getId()+"-row"),e=this.getColumns();for(var i=0,l=e.length;i<l;i++){var o=e[i].getTemplate();if(o){t.addCell(o.clone("col"+i));}}return t;};
d.prototype.bindAggregation=function(n,B){if(n==='rows'){this._oRowBindingArgs=arguments;return this;}return C.prototype.bindAggregation.apply(this,arguments);};
d.prototype.updateRows=function(r){if(r==='change'&&this._fnResolvePromise){var s=this.getExportType()._generate(this);this.destroyAggregation('_template');this.unbindAggregation('rows');this._fnResolvePromise(s);this._oPromise=null;this._fnResolvePromise=null;}};
d.prototype.generate=function(){var t=this;if(!this._oPromise){this._oPromise=c(function(r,e){t._fnResolvePromise=r;if(!t.hasModel()){e("Generate is not possible beause no model was set.");}else{var T=t._createRowTemplate();t.setAggregation('_template',T,true);C.prototype.bindAggregation.apply(t,t._oRowBindingArgs);if(t.getBinding("rows")){t.getBinding("rows").getContexts(0,t.getBinding("rows").getLength());}}},this);}return this._oPromise;};
d.prototype.saveFile=function(f){return this.generate().then(function(s){var e=this.getExportType();F.save(s,f||"data",e.getFileExtension(),e.getMimeType(),e.getCharset(),e.getByteOrderMark());});};
return d;});
sap.ui.predefine('sap/ui/core/util/ExportCell',['sap/ui/core/Element'],function(E){'use strict';
var a=E.extend('sap.ui.core.util.ExportCell',{metadata:{library:"sap.ui.core",properties:{content:'string'}}});
return a;});
sap.ui.predefine('sap/ui/core/util/ExportColumn',['sap/ui/base/ManagedObject','./ExportCell'],function(M,E){'use strict';
var a=M.extend("sap.ui.core.util.ExportColumn",{metadata:{library:"sap.ui.core",properties:{name:"string"},aggregations:{template:{type:"sap.ui.core.util.ExportCell",multiple:false}}}});
return a;});
sap.ui.predefine('sap/ui/core/util/ExportRow',['sap/ui/base/ManagedObject','./ExportCell'],function(M,E){'use strict';
var a=M.extend("sap.ui.core.util.ExportRow",{metadata:{library:"sap.ui.core",aggregations:{cells:{type:"sap.ui.core.util.ExportCell",multiple:true}}}});
return a;});
sap.ui.predefine('sap/ui/core/util/ExportType',['jquery.sap.global','sap/ui/base/ManagedObject'],function(q,M){'use strict';
var E=M.extend('sap.ui.core.util.ExportType',{metadata:{library:"sap.ui.core",properties:{fileExtension:'string',mimeType:'string',charset:'string',byteOrderMark:{type:'boolean',defaultValue:undefined}}}});
E.prototype.init=function(){this._oExport=null;};
E.prototype._generate=function(e){this._oExport=e;var c=this.generate();this._oExport=null;return c;};
E.prototype.generate=function(){return'';};
E.prototype.getColumnCount=function(){if(this._oExport){return this._oExport.getColumns().length;}return 0;};
E.prototype.getRowCount=function(){if(this._oExport&&this._oExport.getBinding("rows")){return this._oExport.getBinding("rows").getLength();}return 0;};
E.prototype.columnGenerator=function(){var i=0,c=this._oExport.getColumns(),C=c.length;return{next:function(){if(i<C){var I=i;i++;return{value:{index:I,name:c[I].getName()},done:false};}else{return{value:undefined,done:true};}}};};
E.prototype.cellGenerator=function(){var i=0,r=this._oExport.getAggregation('_template'),c=r.getCells(),C=c.length;return{next:function(){if(i<C){var I=i;i++;var m={};c[I].getCustomData().forEach(function(o){m[o.getKey()]=o.getValue();});return{value:{index:I,content:c[I].getContent(),customData:m},done:false};}else{return{value:undefined,done:true};}}};};
E.prototype.rowGenerator=function(){var t=this,i=0,e=this._oExport,b=e.getBinding("rows"),B=e.getBindingInfo("rows"),c=b.getContexts(0,b.getLength()),C=c.length,r=e.getAggregation('_template');return{next:function(){if(i<C){var I=i;i++;r.setBindingContext(c[I],B.model);return{value:{index:I,cells:t.cellGenerator()},done:false};}else{return{value:undefined,done:true};}}};};
return E;});
sap.ui.predefine('sap/ui/core/util/ExportTypeCSV',['./ExportType'],function(E){'use strict';var r=/[\r\n"\t;,]/;var a=/^[=\+\-@](?![\d.,]+(?:e[\+-]?\d+)?$)/i;
var C=E.extend('sap.ui.core.util.ExportTypeCSV',{metadata:{library:"sap.ui.core",properties:{separatorChar:{type:'string',defaultValue:','}}}});
C.prototype.setSeparatorChar=function(s){var s=this.validateProperty('separatorChar',s);if(s.length>1){throw new Error("Value of property \"separatorChar\" needs to be exactly one character or empty. "+"\""+s+"\" is "+s.length+" characters long.");}return this.setProperty('separatorChar',s);};
C.prototype.init=function(){this.setProperty('fileExtension','csv',true);this.setProperty('mimeType','text/csv',true);this.setProperty('charset','utf-8',true);};
C.prototype.escapeContent=function(v){if(!v){return v;}if(a.test(v)){v="'"+v;}var c=v.indexOf(this.getSeparatorChar())>-1;if(c||r.test(v)){v=v.replace(/"/g,'""');v='"'+v+'"';}return v;};
C.prototype.generate=function(){var b=[];this.generateColumns(b);this.generateRows(b);return b.join('\r\n');};
C.prototype.generateColumns=function(b){var c=[],o=this.columnGenerator(),d;while(!(d=o.next()).done){c.push(this.escapeContent(d.value.name));}b.push(c.join(this.getSeparatorChar()));};
C.prototype.generateRows=function(b){var R=this.rowGenerator(),o;while(!(o=R.next()).done){var c=[];var d=o.value.cells,e;while(!(e=d.next()).done){c.push(this.escapeContent(e.value.content));}b.push(c.join(this.getSeparatorChar()));}};
return C;});
sap.ui.predefine('sap/ui/core/util/File',['jquery.sap.global'],function(q){'use strict';var F={save:function(d,f,s,m,c,b){var a=f+'.'+s;if(typeof b==='undefined'&&c==='utf-8'&&s==='csv'){b=true;}if(b===true&&c==='utf-8'){d='\ufeff'+d;}if(window.Blob){var t='data:'+m;if(c){t+=';charset='+c;}var B=new window.Blob([d],{type:t});if(window.navigator.msSaveOrOpenBlob){window.navigator.msSaveOrOpenBlob(B,a);}else{var u=window.URL||window.webkitURL;var e=u.createObjectURL(B);var l=window.document.createElement('a');if('download'in l){var $=q(document.body);var g=q(l).attr({download:a,href:e,style:'display:none'});$.append(g);g.get(0).click();g.remove();}else{d=encodeURI(d);var w=window.open(t+","+d);if(!w){throw new Error("Could not download the file, please deactivate your pop-up blocker.");}}}}}};return F;},true);
sap.ui.predefine('sap/ui/core/util/LibraryInfo',['jquery.sap.global','sap/ui/base/Object','jquery.sap.script'],function(q,B){"use strict";
var L=B.extend("sap.ui.core.util.LibraryInfo",{
constructor:function(){B.apply(this);this._oLibInfos={};},
destroy:function(){B.prototype.destroy.apply(this,arguments);this._oLibInfos={};},
getInterface:function(){return this;}
});
L.prototype._loadLibraryMetadata=function(l,c){l=l.replace(/\//g,".");if(this._oLibInfos[l]){q.sap.delayedCall(0,window,c,[this._oLibInfos[l]]);return;}var t=this,u,s,p=/themelib_(.*)/i.exec(l);if(!p){s=".library";u=q.sap.getModulePath(l,'/');}else{s=".theme";u=q.sap.getModulePath("sap.ui.core",'/themes/'+p[1]+"/");}q.ajax({url:u+s,dataType:"xml",error:function(x,a,e){q.sap.log.error("failed to load library details from '"+u+s+": "+a+", "+e);t._oLibInfos[l]={name:l,data:null,url:u};c(t._oLibInfos[l]);},success:function(d,S,x){t._oLibInfos[l]={name:l,data:d,url:u};c(t._oLibInfos[l]);}});};
L.prototype._getLibraryInfo=function(l,c){this._loadLibraryMetadata(l,function(d){var r={libs:[],library:d.name,libraryUrl:d.url};if(d.data){var $=q(d.data);r.vendor=$.find("vendor").text();r.copyright=$.find("copyright").text();r.version=$.find("version").text();r.documentation=$.find("documentation").text();r.releasenotes=$.find("releasenotes").attr("url");r.componentInfo=L.prototype._getLibraryComponentInfo($);}c(r);});};
L.prototype._getThirdPartyInfo=function(l,c){this._loadLibraryMetadata(l,function(d){var r={libs:[],library:d.name,libraryUrl:d.url};if(d.data){var $=q(d.data).find("appData").find("thirdparty").children();$.each(function(i,o){if(o.nodeName==="lib"){var a=q(o);var b=a.children("license");r.libs.push({displayName:a.attr("displayName"),homepage:a.attr("homepage"),license:{url:b.attr("url"),type:b.attr("type"),file:d.url+b.attr("file")}});}});}c(r);});};
L.prototype._getDocuIndex=function(l,c){this._loadLibraryMetadata(l,function(d){var a=d.name,b=d.url,r={"docu":{},library:a,libraryUrl:b};if(!d.data){c(r);return;}var D=q(d.data).find("appData").find("documentation");var u=D.attr("indexUrl");if(!u){c(r);return;}if(D.attr("resolve")=="lib"){u=d.url+u;}q.ajax({url:u,dataType:"json",error:function(x,s,e){q.sap.log.error("failed to load library docu from '"+u+"': "+s+", "+e);c(r);},success:function(d,s,x){d.library=a;d.libraryUrl=b;c(d);}});});};
L.prototype._getReleaseNotes=function(l,v,c){this._loadLibraryMetadata(l,function(d){if(!d.data){c({});return;}var i=(v.split(".").length===3)&&!(/-SNAPSHOT/.test(v));var V=q.sap.Version(v);var m=V.getMajor();var M=V.getMinor();var p=V.getPatch();var D=q(d.data).find("appData").find("releasenotes");var u=D.attr("url");if(!u){q.sap.log.warning("failed to load release notes for library "+l);c({});return;}if(V.getSuffix()==="-SNAPSHOT"){if(M%2!=0){M=(M+1);p=0;}v=m+"."+M+"."+p;}var b=window.location.href,r=/\/\d.\d{1,2}.\d{1,2}\//;if(D.attr("resolve")=="lib"){if(r.test(b)||i===false){u=d.url+u;}else{u="{major}.{minor}.{patch}/"+d.url+u;}}u=u.replace(/\{major\}/g,m);u=u.replace(/\{minor\}/g,M);u=u.replace(/\{patch\}/g,p);q.ajax({url:u,dataType:"json",error:function(x,s,e){if(s==="parsererror"){q.sap.log.error("failed to parse release notes for library '"+l+", "+e);}else{q.sap.log.warning("failed to load release notes for library '"+l+", "+e);}c({});},success:function(d,s,x){c(d,v);}});});};
L.prototype._getLibraryComponentInfo=function(d){var a={};var c=[];var D="";d.find("ownership > component").each(function(b,C){if(C.childElementCount===0){D=C.textContent;}else{var v=C.getElementsByTagName("name");if(v&&v.length>0){v=v[0].textContent;var e=C.getElementsByTagName("module");if(v&&e&&e.length>0){var m=[];for(var i=0;i<e.length;i++){var M=e[i].textContent.replace(/\//g,".");if(M){m.push(M);}}if(m.length>0){c.push({"component":v,"modules":m});}}}}});a["defaultComponent"]=D;if(c&&c.length>0){a["specialCases"]=c;}return a;};
L.prototype._getActualComponent=function(c,m){function a(m,p){m=m.toLowerCase();p=p.toLowerCase();return(m===p||p.match(/\*$/)&&m.indexOf(p.slice(0,-1))===0||p.match(/\.*$/)&&m===p.slice(0,-2));}if(m){for(var k in c){if(!c[k]){q.sap.log.error("No library information deployed for "+k);continue;}var C;if(m.indexOf(k)===0){C=c[k].defaultComponent;}var s=c[k].specialCases;if(s){for(var i=0;i<s.length;i++){var S=s[i].modules;for(var j=0;j<S.length;j++){if(a(m,S[j])){C=s[i].component;}}}}if(C){return C;}}}};
L.prototype._getDefaultComponent=function(l){return l&&l.componentInfo&&l.componentInfo.defaultComponent;};
return L;});
sap.ui.predefine('sap/ui/core/util/MockServer',['jquery.sap.global','sap/ui/Device','sap/ui/base/ManagedObject','sap/ui/thirdparty/sinon','jquery.sap.sjax'],function(q,D,M,d){"use strict";if(D.browser.msie){q.sap.require("sap.ui.thirdparty.sinon-ie");if(!window.FormData){window.FormData=function(){};}}
var f=M.extend("sap.ui.core.util.MockServer",{
constructor:function(i,s,S){M.apply(this,arguments);f._aServers.push(this);},
metadata:{properties:{rootUri:"string",requests:{type:"object[]",defaultValue:[]}}},
_oServer:null,
_aFilter:null,
_oMockdata:null,
_oMetadata:null,
_sMetadataUrl:null,
_sMockdataBaseUrl:null,
_mEntitySets:null,
_oErrorMessages:{INVALID_SYSTEM_QUERY_OPTION_VALUE:"Invalid system query options value",IS_NOT_A_VALID_SYSTEM_QUERY_OPTION:"## is not a valid system query option",URI_VIOLATING_CONSTRUCTION_RULES:"The URI is violating the construction rules defined in the Data Services specification",UNSUPPORTED_FORMAT_VALUE:"Unsupported format value. Only json format is supported",MALFORMED_SYNTAX:"The Data Services Request could not be understood due to malformed syntax",RESOURCE_NOT_FOUND:"Resource not found",INVALID_SORTORDER_DETECTED:"Invalid sortorder ## detected",PROPERTY_NOT_FOUND:"Property ## not found",INVALID_FILTER_QUERY_STATEMENT:"Invalid filter query statement",INVALID_FILTER_OPERATOR:"Invalid $filter operator ##",RESOURCE_NOT_FOUND_FOR_SEGMENT:"Resource not found for the segment ##",MALFORMED_URI_LITERAL_SYNTAX_IN_KEY:"Malformed URI literal syntax in key ##",INVALID_KEY_NAME:"Invalid key name in key predicate. Expected name is ##",INVALID_KEY_PREDICATE_QUANTITY:"Invalid key predicate. The quantity of provided keys does not match the expected value",INVALID_KEY_TYPE:"Invalid key predicate. The key literal for key property ## does not match its type."}
});
f.prototype._getPseudoRandomNumber=function(t){if(!this._iRandomSeed){this._iRandomSeed={};}if(!this._iRandomSeed.hasOwnProperty(t)){this._iRandomSeed[t]=0;}this._iRandomSeed[t]=(this._iRandomSeed[t]+11)*25214903917%281474976710655;return this._iRandomSeed[t]/281474976710655;};
f.prototype.start=function(){this._oServer=f._getInstance();this._aFilters=[];var r=this.getRequests();var l=r.length;for(var i=0;i<l;i++){var R=r[i];this._addRequestHandler(R.method,R.path,R.response);}};
f.prototype.stop=function(){if(this.isStarted()){this._removeAllRequestHandlers();this._removeAllFilters();this._oServer=null;}};
f.prototype.attachBefore=function(h,c,e){e=e?e:"";this.attachEvent(h+e+":before",c);};
f.prototype.attachAfter=function(h,c,e){e=e?e:"";this.attachEvent(h+e+":after",c);};
f.prototype.detachBefore=function(h,c,e){e=e?e:"";this.detachEvent(h+e+":before",c);};
f.prototype.detachAfter=function(h,c,e){e=e?e:"";this.detachEvent(h+e+":after",c);};
f.prototype.isStarted=function(){return!!this._oServer;};
f.prototype.getEntitySetData=function(e){var t=this;var c;if(this._oMockdata&&this._oMockdata.hasOwnProperty(e)){c=q.extend(true,[],t._oMockdata[e]);}else{q.sap.log.error("Unrecognized EntitySet name: "+e);}return c;};
f.prototype.setEntitySetData=function(e,a){if(this._oMockdata&&this._oMockdata.hasOwnProperty(e)){this._oMockdata[e]=a;}else{q.sap.log.error("Unrecognized EntitySet name: "+e);}};
f.prototype._applyQueryOnCollection=function(F,Q,e,u){var a=Q.split('=');var o=a[1];if(o===""){return;}if(o.lastIndexOf(',')===o.length-1){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.URI_VIOLATING_CONSTRUCTION_RULES);}switch(a[0]){case"$top":if(!(new RegExp(/^\d+$/).test(o))){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.INVALID_SYSTEM_QUERY_OPTION_VALUE);}F.results=F.results.slice(0,o);break;case"$skip":if(!(new RegExp(/^\d+$/).test(o))){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.INVALID_SYSTEM_QUERY_OPTION_VALUE);}F.results=F.results.slice(o,F.results.length);break;case"$orderby":F.results=this._getOdataQueryOrderby(F.results,o,e);break;case"$filter":F.results=this._recursiveOdataQueryFilter(F.results,o);break;case"search-focus":break;case"search":var s="";for(var i=0;i<u.length;i++){if(u[i].indexOf("search-focus")!=-1){s=u[i].split('=')[1];break;}}F.results=this._recursiveOdataQuerySearch(F.results,o,s,e);break;case"$select":F.results=this._getOdataQuerySelect(F.results,o,e);break;case"$inlinecount":var c=this._getOdataInlineCount(F.results,o);if(c){F.__count=c;}break;case"$expand":F.results=this._getOdataQueryExpand(F.results,o,e);break;case"$format":F.results=this._getOdataQueryFormat(F.results,o);break;default:this._logAndThrowMockServerCustomError(400,this._oErrorMessages.IS_NOT_A_VALID_SYSTEM_QUERY_OPTION,a[0]);}};
f.prototype._applyQueryOnEntry=function(e,Q,E){var a=Q.split('=');var o=a[1];if(o===""){return;}if(o.lastIndexOf(',')===o.length-1){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.URI_VIOLATING_CONSTRUCTION_RULES);}switch(a[0]){case"$filter":return this._recursiveOdataQueryFilter([e],o)[0];case"$select":return this._getOdataQuerySelect([e],o,E)[0];case"$expand":return this._getOdataQueryExpand([e],o,E)[0];case"$format":return this._getOdataQueryFormat([e],o);default:this._logAndThrowMockServerCustomError(400,this._oErrorMessages.IS_NOT_A_VALID_SYSTEM_QUERY_OPTION,a[0]);}};
f.prototype._getOdataQueryOrderby=function(c,o,e){var p=o.split(',');var t=this;q.each(p,function(i,P){p[i]=t._trim(P);});var C=function compare(a,b){for(var i=0;i<p.length;i++){var s=p[i].split(' ');var S=1;if(s.length>1){switch(s[1]){case'asc':S=1;break;case'desc':S=-1;break;default:t._logAndThrowMockServerCustomError(400,t._oErrorMessages.INVALID_SORTORDER_DETECTED,s[1]);}}var P,h;var j=s[0].indexOf("/");if(j!==-1){P=s[0].substring(j+1);h=s[0].substring(0,j);if(!a[h].hasOwnProperty(P)){var E=false;var T=[];if(h){var k=t._mEntitySets[e].navprops[h].to.entitySet;T=t._mEntityTypes[t._mEntitySets[k].type].properties;for(var i=0;i<T.length;i++){if(T[i].name===P){E=true;break;}}}if(!E){t._logAndThrowMockServerCustomError(400,t._oErrorMessages.PROPERTY_NOT_FOUND,P);}}if(a[h][P]<b[h][P]){return-1*S;}if(a[h][P]>b[h][P]){return 1*S;}}else{P=s[0];if(!a.hasOwnProperty(P)){t._logAndThrowMockServerCustomError(400,t._oErrorMessages.PROPERTY_NOT_FOUND,P);}if(a[P]<b[P]){return-1*S;}if(a[P]>b[P]){return 1*S;}}}return 0;};return c.sort(C);};
f.prototype._arrayUnique=function(b){var a=b.concat();for(var i=0;i<a.length;++i){for(var j=i+1;j<a.length;++j){if(a[i]===a[j]){a.splice(j--,1);}}}return a;};
f.prototype._getBracketIndices=function(s){var S=[];var r=false;var i,e=0;for(var c=0;c<s.length;c++){if(s[c]==='('){if(/[substringof|endswith|startswith]$/.test(s.substring(0,c))){r=true;}else{S.push(s[c]);if(i===undefined){i=c;}}}else if(s[c]===')'){if(!r){S.pop();e=c;if(S.length===0){return{start:i,end:e};}}else{r=false;}}}return{start:i,end:e};};
f.prototype._recursiveOdataQueryFilter=function(a,o){var I=this._getBracketIndices(o);if(I.start===0&&I.end===o.length-1){o=this._trim(o.substring(I.start+1,I.end));return this._recursiveOdataQueryFilter(a,o);}var r=/([^substringof|endswith|startswith]|^)\((.*)\)/,s,p;var O;if(r.test(o)){var b=o.substring(I.start,I.end+1);var c=new RegExp("(.*) +(or|and) +("+this._trim(this._escapeStringForRegExp(b))+".*)");if(I.start===0){c=new RegExp("("+this._trim(this._escapeStringForRegExp(b))+") +(or|and) +(.*)");}var e=c.exec(o);if(e===null){o=o.replace(/[\(\)]/g,"");return this._getOdataQueryFilter(a,this._trim(o));}var E=e[1];O=e[2];var h=e[3];var S=this._recursiveOdataQueryFilter(a,E);if(O==="or"){s=this._recursiveOdataQueryFilter(a,h);return this._arrayUnique(S.concat(s));}if(O==="and"){return this._recursiveOdataQueryFilter(S,h);}}else{p=o.split(/ +and | or +/);if(p.length===1){if(o.match(/ +and | or +/)){throw new Error("400");}return this._getOdataQueryFilter(a,this._trim(o));}var R=this._recursiveOdataQueryFilter(a,p[0]);var j;for(var i=1;i<p.length;i++){j=new RegExp(this._trim(this._escapeStringForRegExp(p[i-1]))+" +(and|or) +"+this._trim(this._escapeStringForRegExp(p[i])));O=j.exec(o)[1];if(O==="or"){s=this._recursiveOdataQueryFilter(a,p[i]);R=this._arrayUnique(R.concat(s));}if(O==="and"){R=this._recursiveOdataQueryFilter(R,p[i]);}}return R;}};
f.prototype._getOdataQueryFilter=function(a,o){if(a.length===0){return a;}var r=new RegExp("(.*) (eq|ne|gt|lt|le|ge) (.*)");var b=new RegExp("(endswith|startswith|substringof)\\((.*)");var O=null;var c=r.exec(o);if(c){O=c[2];}else{c=b.exec(o);if(c){O=c[1];}else{this._logAndThrowMockServerCustomError(400,this._oErrorMessages.INVALID_FILTER_QUERY_STATEMENT);}}var t=this;var G=function(v,V,p,s){var c,e,P;if(!v){c=r.exec(o);e=t._trim(c[V+1]);P=t._trim(c[p+1]);}else{var h=new RegExp("(substringof|startswith|endswith)\\(([^\\)]*),(.*)\\)");c=h.exec(o);e=t._trim(c[V+2]);P=t._trim(c[p+2]);}var T=e[e.length-1];if(T==="M"||T==="m"||T==="L"||T==="f"){e=e.substring(0,e.length-1);}if(e.indexOf("datetime")===0){e=t._getJsonDate(e);}else if(e.indexOf("guid")===0){e=e.substring(5,e.length-1);}else if(e==="true"){e=true;}else if(e==="false"){e=false;}else if(t._isValidNumber(e)){e=parseFloat(e);}else if((e.charAt(0)==="'")&&(e.charAt(e.length-1)==="'")){e=e.substr(1,e.length-2);}var C=P.indexOf("/");if(C!==-1){var i=P.substring(C+1);var j=P.substring(0,C);if(a[0][j]){if(!a[0][j].hasOwnProperty(i)){var E=t._oErrorMessages.PROPERTY_NOT_FOUND.replace("##","'"+i+"'");q.sap.log.error("MockServer: navigation property '"+j+"' was not expanded, so "+E);return a;}}else{t._logAndThrowMockServerCustomError(400,t._oErrorMessages.PROPERTY_NOT_FOUND,P);}return s(P,e,j,i);}else{if(!a[0].hasOwnProperty(P)){t._logAndThrowMockServerCustomError(400,t._oErrorMessages.PROPERTY_NOT_FOUND,P);}return s(P,e);}};switch(O){case"substringof":return G(true,0,1,function(p,v,C,P){return a.filter(function(m){if(C&&P){return(typeof m[C][P]==="string"&&m[C][P].indexOf(v)!==-1);}return(typeof m[p]==="string"&&m[p].indexOf(v)!==-1);});});case"startswith":return G(true,1,0,function(p,v,C,P){return a.filter(function(m){if(C&&P){return(typeof m[C][P]==="string"&&m[C][P].indexOf(v)===0);}return(typeof m[p]==="string"&&m[p].indexOf(v)===0);});});case"endswith":return G(true,1,0,function(p,v,C,P){return a.filter(function(m){if(C&&P){return(typeof m[C][P]==="string"&&m[C][P].indexOf(v)===(m[C][P].length-v.length));}return(typeof m[p]==="string"&&m[p].indexOf(v)===(m[p].length-v.length));});});case"eq":return G(false,2,0,function(p,v,C,P){return a.filter(function(m){if(C&&P){return(m[C][P]===v);}return(m[p]===v);});});case"ne":return G(false,2,0,function(p,v,C,P){return a.filter(function(m){if(C&&P){return(m[C][P]!==v);}return(m[p]!==v);});});case"gt":return G(false,2,0,function(p,v,C,P){return a.filter(function(m){if(C&&P){return(m[C][P]>v);}return(m[p]>v);});});case"lt":return G(false,2,0,function(p,v,C,P){return a.filter(function(m){if(C&&P){return(m[C][P]<v);}return(m[p]<v);});});case"ge":return G(false,2,0,function(p,v,C,P){return a.filter(function(m){if(C&&P){return(m[C][P]>=v);}return(m[p]>=v);});});case"le":return G(false,2,0,function(p,v,C,P){return a.filter(function(m){if(C&&P){return(m[C][P]<=v);}return(m[p]<=v);});});default:this._logAndThrowMockServerCustomError(400,t._oErrorMessages.INVALID_FILTER_OPERATOR,O);}};
f.prototype._recursiveOdataQuerySearch=function(a,o,O,e){var F="";if(O==""||O==undefined){for(var i=0;i<this._mEntitySets[e].keys.length;i++){if(i!=0){F=F+" or ";}F=F+"startswith("+this._mEntitySets[e].keys[i]+",'"+o+"')";}}else{F="substringof('"+o+"',"+O+")";}return this._recursiveOdataQueryFilter(a,F);};
f.prototype._getOdataQuerySelect=function(a,o,e){var t=this;var p,c;var P=o.split(',');var s=[];var b;var h=a[0]?a[0][P[0].split('/')[0]]:null;if(!(h!=null&&h.results&&h.results.length>0)){var C=function(P,j,b,k){if(j["__metadata"]){b["__metadata"]=j["__metadata"];}q.each(P,function(i,l){var n=l.indexOf("/");if(n!==-1){p=l.substring(n+1);c=l.substring(0,n);if(!b[c]){b[c]={};}b[c]=C([p],j[c],b[c],c);}else{if(j&&!j.hasOwnProperty(l)){var E=false;var T=[];if(k){var r=t._mEntitySets[e].navprops[k].to.entitySet;T=t._mEntityTypes[t._mEntitySets[r].type].properties;for(var i=0;i<T.length;i++){if(T[i].name===l){E=true;break;}}}if(!E){t._logAndThrowMockServerCustomError(404,t._oErrorMessages.RESOURCE_NOT_FOUND_FOR_SEGMENT,l);}}b[l]=j[l];}});return b;};if(q.inArray("*",P)!==-1){return a;}q.each(P,function(i,j){P[i]=t._trim(j);});q.each(a,function(i,j){b={};s.push(C(P,j,b));});}else{var m=function(i,j,k){var r={};k=k||'';if(typeof i!=='object'){return i;}if(typeof i.slice==='function'){return i.map(function(l,n){return m(l,j,k);});}if(i.__metadata!==undefined&&k.length===0){r.__metadata=i.__metadata;}j.filter(function(l){return(l+'/').indexOf(k)===0;}).forEach(function(l,_,n){var u=l.substr(k.length).split('/')[0];if(i[u]!==undefined){r[u]=m(i[u],n,k+u+'/');}});if(i.results!==undefined){r.results=m(i.results,j,k);}return r;};s=m(a,P);}return s;};
f.prototype._getOdataInlineCount=function(a,o){var p=o.split(',');if(p.length!==1||(p[0]!=='none'&&p[0]!=='allpages')){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.INVALID_SYSTEM_QUERY_OPTION_VALUE);}if(p[0]==='none'){return;}return a.length;};
f.prototype._getOdataQueryFormat=function(a,o){if(o!=='json'){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.UNSUPPORTED_FORMAT_VALUE);}return a;};
f.prototype._getOdataQueryExpand=function(a,o,e){var t=this;var n=o.split(',');q.each(n,function(i,p){n[i]=t._trim(p);});var E=t._mEntitySets[e].navprops;q.each(a,function(i,r){q.each(n,function(i,N){var b=N.split("/");var s=b[0];if(!r[s]){t._logAndThrowMockServerCustomError(404,t._oErrorMessages.RESOURCE_NOT_FOUND_FOR_SEGMENT,s);}var c=r[s].results||r[s];if(!c||!!c.__deferred){c=q.extend(true,[],t._resolveNavigation(e,r,s,r));}else if(!q.isArray(c)){c=[c];}if(!!c&&b.length>1){var R=b.splice(1,b.length).join("/");c=t._getOdataQueryExpand(c,R,E[s].to.entitySet);}if(E[s].to.multiplicity==="*"){r[s]={results:c};}else{r[s]=c[0]?c[0]:{};}});});return a;};
f.prototype._refreshData=function(){var m=this._loadMetadata(this._sMetadataUrl);if(!m){return;}this._mEntitySets=this._findEntitySets(this._oMetadata);this._mEntityTypes=this._findEntityTypes(this._oMetadata);if(!this._sMockdataBaseUrl){this._generateMockdata(this._mEntitySets,this._oMetadata);}else{if(!q.sap.endsWith(this._sMockdataBaseUrl,"/")&&!q.sap.endsWith(this._sMockdataBaseUrl,".json")){this._sMockdataBaseUrl+="/";}this._loadMockdata(this._mEntitySets,this._sMockdataBaseUrl);}};
f.prototype._getRootUri=function(){var u=this.getRootUri();u=u&&/([^?#]*)([?#].*)?/.exec(u)[1];return u;};
f.prototype._loadMetadata=function(m){var s=q.sap.sjax({url:m,dataType:"text"}).data;if(!s){q.sap.log.error("MockServer: The metadata for url \""+m+"\" could not be found!");}this._sMetadata=s;try{this._oMetadata=q.parseXML(s);}catch(e){q.sap.log.error("MockServer: Invalid metadata XML! Reason: "+e);}return this._oMetadata;};
f.prototype._findEntitySets=function(m){var e={};var p=q(m).find("Principal");var o=q(m).find("Dependent");q(m).find("EntitySet").each(function(i,E){var $=q(E);var a=/((.*)\.)?(.*)/.exec($.attr("EntityType"));e[$.attr("Name")]={"name":$.attr("Name"),"schema":a[2],"type":a[3],"keys":[],"keysType":{},"navprops":{}};});var r=function(R,a,A,F){var E=q(A).find("End[Role='"+R+"']").attr("EntitySet");var s=q(a).find("End[Role='"+R+"']").attr("Multiplicity");var P=[];var c=q(a).find("ReferentialConstraint > [Role='"+R+"']");if(c&&c.length>0){q(c[0]).children("PropertyRef").each(function(i,h){P.push(q(h).attr("Name"));});}else{var b=(F)?p:o;q(b).each(function(i,h){if(R===(q(h).attr("Role"))){q(h).children("PropertyRef").each(function(i,j){P.push(q(j).attr("Name"));});return false;}});}return{"role":R,"entitySet":E,"propRef":P,"multiplicity":s};};q.each(e,function(E,a){var $=q(m).find("EntityType[Name='"+a.type+"']");var k=q($).find("PropertyRef");q.each(k,function(i,P){var K=q(P).attr("Name");a.keys.push(K);a.keysType[K]=q($).find("Property[Name='"+K+"']").attr("Type");});var n=q(m).find("EntityType[Name='"+a.type+"'] NavigationProperty");q.each(n,function(i,N){var b=q(N);var R=b.attr("Relationship").split(".");var A=q(m).find("AssociationSet[Association = '"+R.join(".")+"']");var s=R.pop();var c=q(m).find("Association[Name = '"+s+"']");a.navprops[b.attr("Name")]={"name":b.attr("Name"),"from":r(b.attr("FromRole"),c,A,true),"to":r(b.attr("ToRole"),c,A,false)};});});return e;};
f.prototype._findEntityTypes=function(m){var e={};q(m).find("EntityType").each(function(i,E){var $=q(E);e[$.attr("Name")]={"name":$.attr("Name"),"properties":[],"keys":[]};$.find("Property").each(function(i,p){var P=q(p);var t=P.attr("Type");e[$.attr("Name")].properties.push({"schema":t.substring(0,t.lastIndexOf(".")),"type":t.substring(t.lastIndexOf(".")+1),"name":P.attr("Name"),"precision":P.attr("Precision"),"scale":P.attr("Scale")});});$.find("PropertyRef").each(function(i,k){var K=q(k);var p=K.attr("Name");e[$.attr("Name")].keys.push(p);});});return e;};
f.prototype._findComplexTypes=function(m){var c={};q(m).find("ComplexType").each(function(i,C){var $=q(C);c[$.attr("Name")]={"name":$.attr("Name"),"properties":[]};$.find("Property").each(function(i,p){var P=q(p);var t=P.attr("Type");c[$.attr("Name")].properties.push({"schema":t.substring(0,t.lastIndexOf(".")),"type":t.substring(t.lastIndexOf(".")+1),"name":P.attr("Name"),"precision":P.attr("Precision"),"scale":P.attr("Scale")});});});return c;};
f.prototype._createKeysString=function(e,E){var t=this;var k="";if(E){q.each(e.keys,function(i,K){if(k){k+=",";}var o=E[K];if(e.keysType[K]==="Edm.String"){o=encodeURIComponent("'"+o+"'");}else if(e.keysType[K]==="Edm.DateTime"){o=t._getDateTime(o);o=encodeURIComponent(o);}else if(e.keysType[K]==="Edm.Guid"){o="guid'"+o+"'";}if(e.keys.length===1){k+=o;return k;}k+=K+"="+o;});}return k;};
f.prototype._loadMockdata=function(e,b){var t=this,m={};this._oMockdata={};var l=function(u,o){var r=q.sap.sjax({url:u,dataType:"json"});if(r.success){if(r.data.d){if(r.data.d.results){m[o.name]=r.data.d.results;}else{q.sap.log.error("The mock data format for entity set \""+o.name+"\" invalid");}}else{if(q.isArray(r.data)){m[o.name]=r.data;}else{q.sap.log.error("The mock data for entity set \""+o.name+"\" could not be loaded due to wrong format!");return false;}}return true;}else{if(r.status==="parsererror"){q.sap.log.error("The mock data for entity set \""+o.name+"\" could not be loaded due to a parsing error!");}return false;}};if(q.sap.endsWith(b,".json")){var r=q.sap.sjax({url:b,dataType:"json"});if(r.success){m=r.data;}else{q.sap.log.warning("The mock data for all the entity types could not be found at \""+b+"\"!");}}else{var E={};if(t._aEntitySetsNames&&t._aEntitySetsNames.length>0){var s;for(var i=0;i<t._aEntitySetsNames.length;i++){s=t._aEntitySetsNames[i];if(e[s]){E[s]=e[s];}}}else{E=e;}q.each(E,function(a,o){if(!m[o.type]||!m[o.name]){var c=b+o.name+".json";if(!l(c,o)){q.sap.log.warning("The mock data for entity set \""+o.name+"\" could not be found at \""+b+"\"!");var h=b+o.type+".json";if(!l(h,o)){q.sap.log.warning("The mock data for entity type \""+o.type+"\" could not be found at \""+b+"\"!");if(t._bGenerateMissingMockData){var j={};j[o.name]=o;m[o.type]=t._generateODataMockdataForEntitySet(j,t._oMetadata)[o.name];}}}}});}q.each(e,function(a,o){t._oMockdata[a]=[];if(m[o.name]){q.each(m[o.name],function(I,c){t._oMockdata[a].push(q.extend(true,{},c));});}else if(m[o.type]){q.each(m[o.type],function(I,c){t._oMockdata[a].push(q.extend(true,{},c));});}});q.each(e,function(a,o){if(t._oMockdata[a].length>0){t._enhanceWithMetadata(o,t._oMockdata[a]);}});return this._oMockdata;};
f.prototype._enhanceWithMetadata=function(e,m){if(m){var t=this,r=this._getRootUri(),E=e&&e.name;q.each(m,function(i,o){o.__metadata=o.__metadata||{};o.__metadata.id=r+E+"("+t._createKeysString(e,o)+")";o.__metadata.type=e.schema+"."+e.type;o.__metadata.uri=r+E+"("+t._createKeysString(e,o)+")";q.each(e.navprops,function(k,n){if(o[k]&&!q.isEmptyObject(o[k])&&!o[k]["__deferred"]){t._oMockdata[n.to.entitySet]=t._oMockdata[n.to.entitySet].concat(o[k]);}o[k]={__deferred:{uri:r+E+"("+t._createKeysString(e,o)+")/"+k}};});});}};
f.prototype._isRequestedKeysValid=function(e,r){if(r.length===1){var s=r[0].split('=');if(this._trim(s[0])!==e.keys[0]){r=[e.keys[0]+"="+r[0]];}}for(var i=0;i<r.length;i++){var k=this._trim(r[i].substring(0,r[i].indexOf('=')));var R=this._trim(r[i].substring(r[i].indexOf('=')+1));var F=R.charAt(0);var l=R.charAt(R.length-1);if(e.keysType[k]==="Edm.String"){if(F!=="'"||l!=="'"){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.MALFORMED_URI_LITERAL_SYNTAX_IN_KEY,k);}}else if(e.keysType[k]==="Edm.DateTime"){if(F==="'"||l!=="'"){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.MALFORMED_URI_LITERAL_SYNTAX_IN_KEY,k);}}else if(e.keysType[k]==="Edm.Guid"){if(F==="'"||l!=="'"){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.MALFORMED_URI_LITERAL_SYNTAX_IN_KEY,k);}}else if(e.keysType[k]==="Edm.Binary"){if(!(new RegExp("(binary|X)'[A-Fa-f0-9][A-Fa-f0-9]*'").test(R))){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.MALFORMED_URI_LITERAL_SYNTAX_IN_KEY,k);}}else{if((F==="'"&&l!=="'")||(l==="'"&&F!=="'")){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.MALFORMED_URI_LITERAL_SYNTAX_IN_KEY,k);}}var K=e.keys.join(",");if(e.keys.indexOf(k)===-1){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.INVALID_KEY_NAME,K);}}};
f.prototype._parseKeys=function(k,e){var r={};var p=k.split(",");var K,s,P;for(var i=0;i<p.length;i++){P=p[i].split("=");if(P.length===1&&e.keys.length===1){K=e.keys[0];s=P[0];}else{if(P.length===2){K=P[0];s=P[1];}}r[K]=s;switch(e.keysType[K]){case"Edm.String":r[K]=r[K].replace(/^\'|\'$/g,"");break;case"Edm.Int16":case"Edm.Int32":case"Edm.Int64":case"Edm.Decimal":case"Edm.Byte":case"Edm.Double":case"Edm.Single":case"Edm.SByte":r[K]=parseFloat(r[K]);break;case"Edm.Guid":r[K]=r[K].replace(/^guid\'|\'$/g,"");break;case"Edm.Boolean":case"Edm.Binary":case"Edm.DateTimeOffset":default:r[K]=r[K];}}return r;};
f.prototype._generatePropertyValue=function(k,t,C,i){var I=i;if(!I){I=Math.floor(this._getPseudoRandomNumber("String")*10000)+101;}switch(t){case"String":return k+" "+I;case"DateTime":var a=new Date();a.setFullYear(2000+Math.floor(this._getPseudoRandomNumber("DateTime")*20));a.setDate(Math.floor(this._getPseudoRandomNumber("DateTime")*30));a.setMonth(Math.floor(this._getPseudoRandomNumber("DateTime")*12));a.setMilliseconds(0);return"/Date("+a.getTime()+")/";case"Int16":case"Int32":case"Int64":return Math.floor(this._getPseudoRandomNumber("Int")*10000);case"Decimal":return Math.floor(this._getPseudoRandomNumber("Decimal")*1000000)/100;case"Boolean":return this._getPseudoRandomNumber("Boolean")<0.5;case"Byte":return Math.floor(this._getPseudoRandomNumber("Byte")*10);case"Double":return this._getPseudoRandomNumber("Double")*10;case"Single":return this._getPseudoRandomNumber("Single")*1000000000;case"SByte":return Math.floor(this._getPseudoRandomNumber("SByte")*10);case"Time":return"PT"+Math.floor(this._getPseudoRandomNumber("Time")*23)+"H"+Math.floor(this._getPseudoRandomNumber("Time")*59)+"M"+Math.floor(this._getPseudoRandomNumber("Time")*59)+"S";case"Guid":return'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g,function(c){var r=this._getPseudoRandomNumber("Guid")*16|0,v=c==='x'?r:(r&0x3|0x8);return v.toString(16);}.bind(this));case"Binary":var n=Math.floor(-2147483648+this._getPseudoRandomNumber("Binary")*4294967295),m="";for(var b=0,e=n;b<32;b++,m+=String(e>>>31),e<<=1);return m;case"DateTimeOffset":var a=new Date();a.setFullYear(2000+Math.floor(this._getPseudoRandomNumber("DateTimeOffset")*20));a.setDate(Math.floor(this._getPseudoRandomNumber("DateTimeOffset")*30));a.setMonth(Math.floor(this._getPseudoRandomNumber("DateTimeOffset")*12));a.setMilliseconds(0);return"/Date("+a.getTime()+"+0000)/";default:return this._generateDataFromEntity(C[t],I,C);}};
f.prototype._isFalseyValue=function(k,K,s){switch(s){case"Edm.String":return k==="";case"Edm.Boolean":return k===false;case"Edm.Int16":case"Edm.Int32":case"Edm.Int64":case"Edm.Decimal":case"Edm.Byte":case"Edm.Double":case"Edm.Single":case"Edm.SByte":return k===0||isNaN(k);default:return false;}};
f.prototype._completeKey=function(e,k,E){if(E){for(var i=0;i<e.keys.length;i++){var K=e.keys[i];if(k[K]!==undefined&&k[K]!==null){if(!E[K]){switch(e.keysType[K]){case"Edm.DateTime":E[K]=this._getJsonDate(k[K]);break;case"Edm.Guid":E[K]=k[K].replace(/^guid\'|\'$/g,"");break;default:E[K]=k[K];}}}else{if(!E[K]){E[K]=this._generatePropertyValue(K,e.keysType[K].substring(e.keysType[K].lastIndexOf('.')+1));}}}}};
f.prototype._generateDataFromEntity=function(e,I,c){var E={};if(!e){return E;}for(var i=0;i<e.properties.length;i++){var p=e.properties[i];E[p.name]=this._generatePropertyValue(p.name,p.type,c,I);}return E;};
f.prototype._generateDataFromEntitySet=function(e,E,c){var o=E[e.type];var m=[];for(var i=0;i<100;i++){m.push(this._generateDataFromEntity(o,i+1,c));}return m;};
f.prototype._generateMockdata=function(e,m){var t=this;var o={};var r=this._getRootUri();q.each(e,function(E,a){var b={};b[a.name]=a;o[E]=t._generateODataMockdataForEntitySet(b,m)[E];});q.each(e,function(E,a){for(var n in a.navprops){var N=a.navprops[n];var p=N.from.propRef.length;for(var j=0;j<p;j++){for(var i=0;i<o[E].length;i++){var b=o[E][i];o[N.to.entitySet][i][N.to.propRef[j]]=b[N.from.propRef[j]];}}}q.each(o[E],function(I,c){c.__metadata={uri:r+E+"("+t._createKeysString(a,c)+")",type:a.schema+"."+a.type};q.each(a.navprops,function(k,N){c[k]={__deferred:{uri:r+E+"("+t._createKeysString(a,c)+")/"+k}};});});});this._oMockdata=o;};
f.prototype._generateODataMockdataForEntitySet=function(e,m){var t=this,o={};var E=this._findEntityTypes(m);var c=this._findComplexTypes(m);q.each(e,function(s,a){o[s]=t._generateDataFromEntitySet(a,E,c);});return o;};
f.prototype._resolveNavigation=function(e,F,n){var E=this._mEntitySets[e];var N=E.navprops[n];if(!N){this._logAndThrowMockServerCustomError(404,this._oErrorMessages.RESOURCE_NOT_FOUND);}var a=[];var p=N.from.propRef.length;if(p===0){if(N.to.multiplicity==="*"){return this._oMockdata[N.to.entitySet];}else{a.push(this._oMockdata[N.to.entitySet][0]);return a;}}q.each(this._oMockdata[N.to.entitySet],function(I,t){var b=true;for(var i=0;i<p;i++){if(F[N.from.propRef[i]]!==t[N.to.propRef[i]]){b=false;break;}}if(b){a.push(t);}});return a;};
f.prototype.simulate=function(s,v){var t=this;this._sMetadataUrl=s;if(!v||typeof v==="string"){this._sMockdataBaseUrl=v;}else{this._sMockdataBaseUrl=v.sMockdataBaseUrl;this._bGenerateMissingMockData=v.bGenerateMissingMockData;this._aEntitySetsNames=v.aEntitySetsNames;}var o=this._loadMetadata(this._sMetadataUrl);if(!o){return;}if(this._sMetadata){var a=sap.ui.requireSync("sap/ui/core/util/MockServerAnnotationsHandler");var A=a.parse(this._oMetadata,this._sMetadata);var b=sap.ui.requireSync("sap/ui/core/util/DraftEnabledMockServer");b.handleDraft(A,this);}this._refreshData();var h=function(x,m){if(x.requestHeaders["x-csrf-token"]==="Fetch"){m["X-CSRF-Token"]="42424242424242424242424242424242";}};var G=function(e,k){k=decodeURIComponent(k);var F;var E=t._mEntitySets[e];var K=E.keys;var j=k.split(',');if(j.length!==K.length){t._logAndThrowMockServerCustomError(400,t._oErrorMessages.INVALID_KEY_PREDICATE_QUANTITY);}t._isRequestedKeysValid(E,j);if(j.length===1&&!j[0].split('=')[1]){j=[K[0]+"="+j[0]];}q.each(t._oMockdata[e],function(I,l){for(var i=0;i<j.length;i++){var m=j[i].split('=');var n=t._trim(m[0]);if(q.inArray(n,K)===-1){return true;}var N=t._trim(m[1]);var O=l[n];switch(E.keysType[n]){case"Edm.String":N=N.replace(/^\'|\'$/g,'');break;case"Edm.Time":case"Edm.DateTime":O=t._getDateTime(O);break;case"Edm.Int16":case"Edm.Int32":case"Edm.Decimal":case"Edm.Byte":case"Edm.Double":case"Edm.Single":case"Edm.SByte":if(!t._isValidNumber(N)){return false;}N=parseFloat(N);break;case"Edm.Guid":N=N.replace(/^guid\'|\'$/g,'');break;case"Edm.Boolean":if(["true","false"].indexOf(N)===-1){t._logAndThrowMockServerCustomError(400,t._oErrorMessages.INVALID_KEY_TYPE,n);}N=N==="true";break;case"Edm.Binary":case"Edm.DateTimeOffset":default:N=N;}if(O!==N){return true;}}F={index:I,entry:l};return false;});return F;};var r=function(e,k,u){var S=e.name;var n;if(u){n=e.navprops[u];}if(n){S=n.to.entitySet;}return S;};var H=function(u){var U=[];var S=function(V){var j=V.indexOf("'");var m=V.indexOf("\"");if(j===-1&&m===-1){return null;}else{if(j>-1&&m===-1){return"appost";}if(m>-1&&j===-1){return"doublequotes";}if(j>-1&&m>-1&&j<m){return"appost";}if(j>-1&&m>-1&&m<j){return"doublequotes";}}};var e=function(p,P,m,n){var w=p[m];var j=m+1;while(j<p.length&&p[j].indexOf(n)===-1){w=w+"&"+p[j];j++;}w=w+"&"+p[j];P.push(w);m=j;return m;};for(var i=0;i<u.length;i++){if(!S(u[i])){U.push(u[i]);}if(S(u[i])==="appost"){var k=u[i].indexOf("'");if(u[i].indexOf("'",k+1)===-1){i=e(u,U,i,"'");}else{U.push(u[i]);}}if(S(u[i])==="doublequotes"){var l=u[i].indexOf("\"");if(u[i].indexOf("\"",l+1)===-1){i=e(u,U,i,"\"");}else{U.push(u[i]);}}}return U;};var c=function(x,T,k,u){k=k?decodeURIComponent(k):k;var e=JSON.parse(x.requestBody);if(e){var K={};if(k){K=t._parseKeys(k,t._mEntitySets[T]);}t._completeKey(t._mEntitySets[T],K,e);t._enhanceWithMetadata(t._mEntitySets[T],[e]);return e;}return null;};var R=[];R.push({method:"GET",path:new RegExp("\\$metadata([?#].*)?"),response:function(x){q.sap.require("jquery.sap.xml");q.sap.log.debug("MockServer: incoming request for url: "+x.url);var m={"Content-Type":"application/xml;charset=utf-8"};h(x,m);x.respond(200,m,t._sMetadata);q.sap.log.debug("MockServer: response sent with: 200, "+t._sMetadata);return true;}});R.push({method:"HEAD",path:new RegExp("$"),response:function(x){q.sap.log.debug("MockServer: incoming request for url: "+x.url);var m={"Content-Type":"application/json;charset=utf-8"};h(x,m);x.respond(200,m);q.sap.log.debug("MockServer: response sent with: 200");return true;}});R.push({method:"GET",path:new RegExp("$"),response:function(x){q.sap.log.debug("MockServer: incoming request for url: "+x.url);var m={"Content-Type":"application/json;charset=utf-8"};h(x,m);var e=[];q.each(t._mEntitySets,function(E,j){e.push(E);});var i={EntitySets:e};x.respond(200,m,JSON.stringify({d:i}));q.sap.log.debug("MockServer: response sent with: 200, "+JSON.stringify({d:i}));return true;}});R.push({method:"POST",path:new RegExp("\\$batch([?#].*)?"),response:function(x){q.sap.log.debug("MockServer: incoming request for url: "+x.url);var e=function(Z){switch(Z.statusCode){case 200:return"200 OK";case 201:return"201 Created";case 204:return"204 No Content";case 400:return"400 Bad Request";case 401:return"401 Unauthorized";case 403:return"403 Forbidden";case 404:return"404 Not Found";case 405:return"405 Method Not Allowed";case 409:return"409 Conflict";case 412:return"412 Precondition Failed";case 415:return"415 Unsupported Media Type";case 500:return"500 Internal Server Error";case 501:return"501 Not Implemented";case 503:return"503 Service Unavailable";default:return Z.statusCode+" "+Z.status;}};var B=function(Z,$){var _;if(Z.success){_=JSON.stringify(Z.data)||"";}else{_=Z.errorResponse;}$=$||"application/json";if(Z.responseHeaders){return"HTTP/1.1 "+e(Z)+"\r\n"+Z.responseHeaders+"dataserviceversion: 2.0\r\n\r\n"+_+"\r\n";}else{return"HTTP/1.1 "+e(Z)+"\r\nContent-Type: "+$+"\r\nContent-Length: "+_.length+"\r\ndataserviceversion: 2.0\r\n\r\n"+_+"\r\n";}};var C=function(Z,T,$,N){var _;var a1=function(c1,d1,e1){_={success:true,data:c1,status:d1,statusCode:e1&&e1.status,responseHeaders:e1&&e1.getAllResponseHeaders()};};var b1=function(c1,d1,e1){_={success:false,data:undefined,status:d1,error:e1,statusCode:c1.status,errorResponse:c1.responseText,responseHeaders:c1&&c1.getAllResponseHeaders()};};q.ajax({type:$,async:false,url:Z,data:T,dataType:"json",success:a1,error:b1});if(_.statusCode===400||_.statusCode===404){var W=B(_);throw new Error(W);}N.push(B(_));};var l=function(Z,w){var $;var _;var a1=function(c1,d1,e1){$={success:true,data:c1,status:d1,statusCode:e1&&e1.status,responseHeaders:e1&&e1.getAllResponseHeaders()};};var b1=function(c1,d1,e1){$={success:false,data:undefined,status:d1,error:e1,statusCode:c1.status,errorResponse:c1.responseText,responseHeaders:c1&&c1.getAllResponseHeaders()};};q.ajax({async:false,url:Z,dataType:"json",success:a1,error:b1});var _;if(Z.indexOf('$count')!==-1){_=B($,"text/plain");}else{_=B($);}w.push("\r\nContent-Type: application/http\r\n"+"Content-Length: "+_.length+"\r\n"+"content-transfer-encoding: binary\r\n\r\n"+_);};var n=x.requestBody;var p=new RegExp("--batch_[a-z0-9-]*");var u=p.exec(n)[0];if(!!u){var w=[];var y=n.split(u);var S=x.url.split("$")[0];var z=new RegExp("PUT (.*) HTTP");var E=new RegExp("MERGE (.*) HTTP");var F=new RegExp("POST (.*) HTTP");var I=new RegExp("DELETE (.*) HTTP");var J=new RegExp("GET (.*) HTTP");for(var i=1;i<y.length-1;i++){var K=y[i];if(J.test(K)&&K.indexOf("multipart/mixed")===-1){if(z.test(K)||F.test(K)||I.test(K)){x.respond(400,null,"The Data Services Request could not be understood due to malformed syntax");q.sap.log.debug("MockServer: response sent with: 400");return true;}l(S+J.exec(K)[1],w);}else{var L=q.extend(true,{},t._oMockdata);var N=[];var O=K.substring(K.indexOf("boundary=")+9,K.indexOf("\r\n\r\n"));var P=K.split("--"+O);try{for(var j=1;j<P.length-1;j++){var Q=P[j];var T;if(J.test(Q)){t._oMockdata=L;x.respond(400,null,"The Data Services Request could not be understood due to malformed syntax");q.sap.log.debug("MockServer: response sent with: 400");return;}else if(z.test(Q)){T=Q.substring(Q.indexOf("{"),Q.lastIndexOf("}")+1);C(S+z.exec(Q)[1],T,'PUT',N);}else if(E.test(Q)){T=Q.substring(Q.indexOf("{"),Q.lastIndexOf("}")+1);C(S+E.exec(Q)[1],T,'MERGE',N);}else if(F.test(Q)){T=Q.substring(Q.indexOf("{"),Q.lastIndexOf("}")+1);C(S+F.exec(Q)[1],T,'POST',N);}else if(I.test(Q)){C(S+I.exec(Q)[1],T,'DELETE',N);}}var U="\r\nContent-Type: multipart/mixed; boundary=ejjeeffe1\r\n\r\n--ejjeeffe1";for(var k=0;k<N.length;k++){U+="\r\nContent-Type: application/http\r\n"+"Content-Length: "+N[k].length+"\r\n"+"content-transfer-encoding: binary\r\n\r\n"+N[k]+"--ejjeeffe1";}U+="--\r\n";w.push(U);}catch(V){t._oMockdata=L;var W="\r\nContent-Type: application/http\r\n"+"Content-Length: "+V.message.length+"\r\n"+"content-transfer-encoding: binary\r\n\r\n"+V.message;w.push(W);}}}var X="--ejjeeffe0";for(var m=0;m<w.length;m++){X+=w[m]+"--ejjeeffe0";}X+="--";var Y={'Content-Type':"multipart/mixed; boundary=ejjeeffe0"};h(x,Y);x.respond(202,Y,X);q.sap.log.debug("MockServer: response sent with: 202, "+X);}else{x.respond(202);}return true;}});q.each(this._mEntitySets,function(E,i){R.push({method:"GET",path:new RegExp("("+E+")/\\$count/?(.*)?"),response:function(x,E,u){q.sap.log.debug("MockServer: incoming request for url: "+x.url);t.fireEvent(f.HTTPMETHOD.GET+E+":before",{oXhr:x,sUrlParams:u});t.fireEvent(f.HTTPMETHOD.GET+":before",{oXhr:x,sUrlParams:u});var m={"Content-Type":"text/plain;charset=utf-8"};h(x,m);try{var j=t._oMockdata[E];if(j){var F={results:q.extend(true,[],j)};if(u){var U=decodeURIComponent(u).replace("?","&").split("&");U=H(U);if(U.length>1){U=t._orderQueryOptions(U);}q.each(U,function(I,Q){t._applyQueryOnCollection(F,Q,E,U);});}t.fireEvent(f.HTTPMETHOD.GET+E+":after",{oXhr:x,oFilteredData:F});t.fireEvent(f.HTTPMETHOD.GET+":after",{oXhr:x,oFilteredData:F});x.respond(200,m,""+F.results.length);q.sap.log.debug("MockServer: response sent with: 200, "+F.results.length);}else{t._logAndThrowMockServerCustomError(404,t._oErrorMessages.RESOURCE_NOT_FOUND);}}catch(e){if(e.error){x.respond(e.error.code,m,JSON.stringify(e));}else{q.sap.log.error("MockServer: request failed due to invalid system query options value!");x.respond(parseInt(e.message||e.number,10));}}return true;}});R.push({method:"GET",path:new RegExp("("+E+")/?(\\?(.*))?"),response:function(x,E,u){q.sap.log.debug("MockServer: incoming request for url: "+x.url);t.fireEvent(f.HTTPMETHOD.GET+E+":before",{oXhr:x,sUrlParams:u});t.fireEvent(f.HTTPMETHOD.GET+":before",{oXhr:x,sUrlParams:u});var m={"Content-Type":"application/json;charset=utf-8"};h(x,m);try{var j=t._oMockdata[E];if(j){var F={results:q.extend(true,[],j)};if(u){var U=decodeURIComponent(u).replace("?","&").split("&");U=H(U);if(U.length>1){U=t._orderQueryOptions(U);}q.each(U,function(I,Q){t._applyQueryOnCollection(F,Q,E,U);});}t.fireEvent(f.HTTPMETHOD.GET+E+":after",{oXhr:x,oFilteredData:F});t.fireEvent(f.HTTPMETHOD.GET+":after",{oXhr:x,oFilteredData:F});x.respond(200,m,JSON.stringify({d:F}));q.sap.log.debug("MockServer: response sent with: 200, "+JSON.stringify({d:F}));}else{t._logAndThrowMockServerCustomError(404,t._oErrorMessages.RESOURCE_NOT_FOUND);}}catch(e){if(e.error){x.respond(e.error.code,m,JSON.stringify(e));}else{q.sap.log.debug("MockServer: response sent with: "+parseInt(e.message||e.number,10));x.respond(parseInt(e.message||e.number,10));}}return true;}});R.push({method:"GET",path:new RegExp("("+E+")\\(([^/\\?#]+)\\)/?(\\?(.*))?"),response:function(x,E,k,u){q.sap.log.debug("MockServer: incoming request for url: "+x.url);t.fireEvent(f.HTTPMETHOD.GET+E+":before",{oXhr:x,sKeys:k,sUrlParams:u});t.fireEvent(f.HTTPMETHOD.GET+":before",{oXhr:x,sKeys:k,sUrlParams:u});var m={"Content-Type":"application/json;charset=utf-8"};try{var j=q.extend(true,{},G(E,k));if(!q.isEmptyObject(j)){if(u){var U=decodeURIComponent(u).replace("?","&").split("&");U=H(U);if(U.length>1){U=t._orderQueryOptions(U);}q.each(U,function(I,Q){j.entry=t._applyQueryOnEntry(j.entry,Q,E);});}t.fireEvent(f.HTTPMETHOD.GET+E+":after",{oXhr:x,oEntry:j.entry});t.fireEvent(f.HTTPMETHOD.GET+":after",{oXhr:x,oEntry:j.entry});x.respond(200,m,JSON.stringify({d:j.entry}));q.sap.log.debug("MockServer: response sent with: 200, "+JSON.stringify({d:j.entry}));}else{t._logAndThrowMockServerCustomError(404,t._oErrorMessages.RESOURCE_NOT_FOUND);}}catch(e){if(e.error){x.respond(e.error.code,m,JSON.stringify(e));}else{q.sap.log.debug("MockServer: response sent with: "+parseInt(e.message||e.number,10));x.respond(parseInt(e.message||e.number,10));}}return true;}});q.each(i.navprops,function(n,N){R.push({method:"GET",path:new RegExp("("+E+")\\(([^/\\?#]+)\\)/("+n+")/\\$count/?(.*)?"),response:function(x,E,k,j,u){q.sap.log.debug("MockServer: incoming request for url: "+x.url);t.fireEvent(f.HTTPMETHOD.GET+E+":before",{oXhr:x,sKeys:k,sNavProp:j,sUrlParams:u});t.fireEvent(f.HTTPMETHOD.GET+":before",{oXhr:x,sKeys:k,sNavProp:j,sUrlParams:u});var m={"Content-Type":"text/plain;charset=utf-8"};h(x,m);try{var l=G(E,k);if(l){var p,F={};p=t._resolveNavigation(E,l.entry,j);var w=t._mEntitySets[E].navprops[j].to.multiplicity;if(w==="*"){F={results:q.extend(true,[],p)};}else{F=q.extend(true,{},p[0]);}if(p&&p.length!==0){if(u){var U=decodeURIComponent(u).replace("?","&").split("&");U=H(U);if(U.length>1){U=t._orderQueryOptions(U);}if(w==="*"){q.each(U,function(I,Q){t._applyQueryOnCollection(F,Q,t._mEntitySets[E].navprops[j].to.entitySet,U);});}else{q.each(U,function(I,Q){F=t._applyQueryOnEntry(F,Q,t._mEntitySets[E].navprops[j].to.entitySet);});}}}t.fireEvent(f.HTTPMETHOD.GET+E+":after",{oXhr:x,oFilteredData:F});t.fireEvent(f.HTTPMETHOD.GET+":after",{oXhr:x,oFilteredData:F});F.results=F.results||[];x.respond(200,m,""+F.results.length);q.sap.log.debug("MockServer: response sent with: 200, "+F.results.length);}else{t._logAndThrowMockServerCustomError(404,t._oErrorMessages.RESOURCE_NOT_FOUND);}}catch(e){if(e.error){x.respond(e.error.code,m,JSON.stringify(e));}else{q.sap.log.debug("MockServer: response sent with: "+parseInt(e.message||e.number,10));x.respond(parseInt(e.message||e.number,10));}}return true;}});R.push({method:"GET",path:new RegExp("("+E+")\\(([^/\\?#]+)\\)/("+n+")/?(\\?(.*))?"),response:function(x,E,k,j,u){q.sap.log.debug("MockServer: incoming request for url: "+x.url);t.fireEvent(f.HTTPMETHOD.GET+E+":before",{oXhr:x,sKeys:k,sNavProp:j,sUrlParams:u});t.fireEvent(f.HTTPMETHOD.GET+":before",{oXhr:x,sKeys:k,sNavProp:j,sUrlParams:u});var m={"Content-Type":"application/json;charset=utf-8"};h(x,m);try{var l=G(E,k);if(l){var p,F={};p=t._resolveNavigation(E,l.entry,j,l.entry);var w=t._mEntitySets[E].navprops[j].to.multiplicity;if(w==="*"){F={results:q.extend(true,[],p)};}else{F=q.extend(true,{},p[0]);}if(p&&p.length!==0){if(u){var U=decodeURIComponent(u).replace("?","&").split("&");U=H(U);if(U.length>1){U=t._orderQueryOptions(U);}if(w==="*"){q.each(U,function(I,Q){t._applyQueryOnCollection(F,Q,t._mEntitySets[E].navprops[j].to.entitySet,U);});}else{q.each(U,function(I,Q){F=t._applyQueryOnEntry(F,Q,t._mEntitySets[E].navprops[j].to.entitySet);});}}}t.fireEvent(f.HTTPMETHOD.GET+E+":after",{oXhr:x,oFilteredData:F});t.fireEvent(f.HTTPMETHOD.GET+":after",{oXhr:x,oFilteredData:F});x.respond(200,m,JSON.stringify({d:F}));q.sap.log.debug("MockServer: response sent with: 200, "+JSON.stringify({d:F}));}else{t._logAndThrowMockServerCustomError(404,t._oErrorMessages.RESOURCE_NOT_FOUND);}}catch(e){if(e.error){x.respond(e.error.code,m,JSON.stringify(e));}else{x.respond(parseInt(e.message||e.number,10));q.sap.log.debug("MockServer: response sent with: "+parseInt(e.message||e.number,10));}}return true;}});});R.push({method:"POST",path:new RegExp("("+E+")(\\(([^/\\?#]+)\\)/?(.*)?)?"),response:function(x,E,j,k,n){var m=false;if(x.requestHeaders["x-http-method"]==="MERGE"){m=true;}q.sap.log.debug("MockServer: incoming create request for url: "+x.url);t.fireEvent(f.HTTPMETHOD.POST+E+":before",{oXhr:x,sKeys:k,sNavName:n});t.fireEvent(f.HTTPMETHOD.POST+":before",{oXhr:x,sKeys:k,sNavName:n});var l=null;var p=null;var u=405;try{if(k&&!k.split('=')[1]){k=t._mEntitySets[E].keys[0]+"="+k;}var T=r(i,decodeURIComponent(k),n);if(T){var w=c(x,T,k,n);if(w){p={"Content-Type":"application/json;charset=utf-8"};t.fireEvent(f.HTTPMETHOD.POST+E+":after",{oXhr:x,oEntity:w});t.fireEvent(f.HTTPMETHOD.POST+":after",{oXhr:x,oEntity:w});if(m){var y=G(E,k);if(y){q.extend(t._oMockdata[E][y.index],w);}u=204;}else{var U=t._getRootUri()+T+"("+t._createKeysString(t._mEntitySets[T],w)+")";l=JSON.stringify({d:w,uri:U});t._oMockdata[T]=t._oMockdata[T].concat([w]);u=201;}}}x.respond(u,p,l);q.sap.log.debug("MockServer: response sent with: "+u+", "+l);}catch(e){if(e.error){var z={"Content-Type":"text/plain;charset=utf-8"};x.respond(e.error.code,z,JSON.stringify(e));}else{x.respond(parseInt(e.message||e.number,10));q.sap.log.debug("MockServer: response sent with: "+parseInt(e.message||e.number,10));}}return true;}});R.push({method:"PUT",path:new RegExp("("+E+")\\(([^/\\?#]+)\\)/?(.*)?"),response:function(x,E,k,n){q.sap.log.debug("MockServer: incoming update request for url: "+x.url);t.fireEvent(f.HTTPMETHOD.PUT+E+":before",{oXhr:x,sKeys:k,sNavName:n});t.fireEvent(f.HTTPMETHOD.PUT+":before",{oXhr:x,sKeys:k,sNavName:n});var j=405;var l=null;var m=null;try{var T=r(i,decodeURIComponent(k),n);if(T){var p=c(x,T,k,n);if(p){m={"Content-Type":"application/json;charset=utf-8"};t.fireEvent(f.HTTPMETHOD.PUT+E+":after",{oXhr:x,oEntity:p});t.fireEvent(f.HTTPMETHOD.PUT+":after",{oXhr:x,oEntity:p});var u=G(E,k);if(u){t._oMockdata[E][u.index]=p;}j=204;}}x.respond(j,m,l);q.sap.log.debug("MockServer: response sent with: "+j+", "+l);}catch(e){if(e.error){var w={"Content-Type":"text/plain;charset=utf-8"};x.respond(e.error.code,w,JSON.stringify(e));}else{x.respond(parseInt(e.message||e.number,10));q.sap.log.debug("MockServer: response sent with: "+parseInt(e.message||e.number,10));}}return true;}});R.push({method:"MERGE",path:new RegExp("("+E+")\\(([^/\\?#]+)\\)/?(.*)?"),response:function(x,E,k,n){q.sap.log.debug("MockServer: incoming merge update request for url: "+x.url);t.fireEvent(f.HTTPMETHOD.MERGE+E+":before",{oXhr:x,sKeys:k,sNavName:n});t.fireEvent(f.HTTPMETHOD.MERGE+":before",{oXhr:x,sKeys:k,sNavName:n});var j=405;var l=null;var m=null;try{var T=r(i,decodeURIComponent(k),n);if(T){var p=c(x,T,k,n);if(p){m={"Content-Type":"application/json;charset=utf-8"};t.fireEvent(f.HTTPMETHOD.MERGE+E+":after",{oXhr:x,oEntity:p});t.fireEvent(f.HTTPMETHOD.MERGE+":after",{oXhr:x,oEntity:p});var u=G(E,k);if(u){q.extend(t._oMockdata[E][u.index],p);}j=204;}}x.respond(j,m,l);q.sap.log.debug("MockServer: response sent with: "+j+", "+l);}catch(e){if(e.error){var w={"Content-Type":"text/plain;charset=utf-8"};x.respond(e.error.code,w,JSON.stringify(e));}else{x.respond(parseInt(e.message||e.number,10));q.sap.log.debug("MockServer: response sent with: "+parseInt(e.message||e.number,10));}}return true;}});R.push({method:"PATCH",path:new RegExp("("+E+")\\(([^/\\?#]+)\\)/?(.*)?"),response:function(x,E,k,n){q.sap.log.debug("MockServer: incoming patch update request for url: "+x.url);t.fireEvent(f.HTTPMETHOD.PATCH+E+":before",{oXhr:x,sKeys:k,sNavName:n});t.fireEvent(f.HTTPMETHOD.PATCH+":before",{oXhr:x,sKeys:k,sNavName:n});var j=405;var l=null;var m=null;try{var T=r(i,decodeURIComponent(k),n);if(T){var p=c(x,T,k,n);if(p){m={"Content-Type":"application/json;charset=utf-8"};t.fireEvent(f.HTTPMETHOD.PATCH+E+":after",{oXhr:x,oEntity:p});t.fireEvent(f.HTTPMETHOD.PATCH+":after",{oXhr:x,oEntity:p});var u=G(E,k);if(u){q.extend(t._oMockdata[E][u.index],p);}j=204;}}x.respond(j,m,l);q.sap.log.debug("MockServer: response sent with: "+j+", "+l);}catch(e){if(e.error){var w={"Content-Type":"text/plain;charset=utf-8"};x.respond(e.error.code,w,JSON.stringify(e));}else{x.respond(parseInt(e.message||e.number,10));q.sap.log.debug("MockServer: response sent with: "+parseInt(e.message||e.number,10));}}return true;}});R.push({method:"DELETE",path:new RegExp("("+E+")\\(([^/\\?#]+)\\)/?(.*)?"),response:function(x,E,k,u){q.sap.log.debug("MockServer: incoming delete request for url: "+x.url);t.fireEvent(f.HTTPMETHOD.DELETE+E+":before",{oXhr:x});t.fireEvent(f.HTTPMETHOD.DELETE+":before",{oXhr:x});var j=204;try{var l=G(E,k);if(l){t._oMockdata[E].splice(l.index,1);}else{j=400;}t.fireEvent(f.HTTPMETHOD.DELETE+E+":after",{oXhr:x});t.fireEvent(f.HTTPMETHOD.DELETE+":after",{oXhr:x});x.respond(j,null,null);q.sap.log.debug("MockServer: response sent with: "+j);}catch(e){if(e.error){var m={"Content-Type":"text/plain;charset=utf-8"};x.respond(e.error.code,m,JSON.stringify(e));}else{x.respond(parseInt(e.message||e.number,10));q.sap.log.debug("MockServer: response sent with: "+parseInt(e.message||e.number,10));}}return true;}});});this.setRequests(R);};
f.prototype._orderQueryOptions=function(u){var F,i,s,t,o,S,e,a,b,c,O=[];var h=this;q.each(u,function(I,Q){switch(Q.split('=')[0]){case"$top":t=q.inArray(Q,u);break;case"$skip":s=q.inArray(Q,u);break;case"$orderby":o=q.inArray(Q,u);break;case"$expand":e=q.inArray(Q,u);break;case"$filter":F=q.inArray(Q,u);break;case"$select":S=q.inArray(Q,u);break;case"$inlinecount":i=q.inArray(Q,u);break;case"$format":a=q.inArray(Q,u);break;case"search-focus":c=q.inArray(Q,u);break;case"search":b=q.inArray(Q,u);break;default:if(Q.split('=')[0].indexOf('$')===0){h._logAndThrowMockServerCustomError(400,h._oErrorMessages.IS_NOT_A_VALID_SYSTEM_QUERY_OPTION,Q.split('=')[0]);}}});if(e>=0){O.push(u[e]);}if(F>=0){O.push(u[F]);}if(c>=0){O.push(u[c]);}if(b>=0){O.push(u[b]);}if(i>=0){O.push(u[i]);}if(o>=0){O.push(u[o]);}if(s>=0){O.push(u[s]);}if(t>=0){O.push(u[t]);}if(S>=0){O.push(u[S]);}if(a>=0){O.push(u[a]);}return O;};
f.prototype._removeAllRequestHandlers=function(){var r=this.getRequests();var l=r.length;for(var i=0;i<l;i++){f._removeResponse(r[i].response);}};
f.prototype._removeAllFilters=function(){for(var i=0;i<this._aFilters.length;i++){f._removeFilter(this._aFilters[i]);}this._aFilters=null;};
f.prototype._addRequestHandler=function(m,p,r){m=m?m.toUpperCase():m;if(typeof m!=="string"){throw new Error("Error in request configuration: value of 'method' has to be a string");}if(!(typeof p==="string"||p instanceof RegExp)){throw new Error("Error in request configuration: value of 'path' has to be a string or a regular expression");}if(typeof r!=="function"){throw new Error("Error in request configuration: value of 'response' has to be a function");}var u=this._getRootUri();u=u&&new RegExp(this._escapeStringForRegExp(u));if(p&&!(p instanceof RegExp)){p=new RegExp(this._createRegExpPattern(p));}var R=this._createRegExp(u?u.source+p.source:p.source);this._addFilter(this._createFilter(m,R));this._oServer.respondWith(m,R,r);q.sap.log.debug("MockServer: adding "+m+" request handler for pattern "+R);};
f.prototype._createRegExp=function(p){return new RegExp("^"+p+"$");};
f.prototype._createRegExpPattern=function(p){return p.replace(/:([\w\d]+)/g,"([^\/]+)");};
f.prototype._escapeStringForRegExp=function(s){return s.replace(/[\\\/\[\]\{\}\(\)\-\*\+\?\.\^\$\|]/g,"\\$&");};
f.prototype._trim=function(s){return s&&s.replace(/^\s+|\s+$/g,"");};
f.prototype._isValidNumber=function(s){return!isNaN(parseFloat(s))&&isFinite(s);};
f.prototype._getDateTime=function(s){if(!s){return;}return"datetime'"+new Date(Number(s.replace("/Date(",'').replace(")/",''))).toJSON().substring(0,19)+"'";};
f.prototype._getJsonDate=function(S){if(!S){return;}var n=function(s){var a=q.map(s.slice(0,-5).split(/\D/),function(i){return parseInt(i,10)||0;});a[1]-=1;a=new Date(Date.UTC.apply(Date,a));var o=s.slice(-5);var b=parseInt(o,10)/100;if(o.slice(0,1)==="+"){b*=-1;}a.setHours(a.getHours()+b);return a.getTime();};return"/Date("+n(S.substring("datetime'".length,S.length-1))+")/";};
f.prototype._addFilter=function(F){this._aFilters.push(F);f._addFilter(F);};
f.prototype._createFilter=function(r,R){return function(m,u,a,U,p){return r===m&&R.test(u);};};
f.prototype._logAndThrowMockServerCustomError=function(e,E,p){if(E.indexOf('##')>-1&&p){E=E.replace("##","'"+p+"'");}q.sap.log.error("MockServer: "+E);throw{error:{code:e,message:{lang:"en",value:E}}};};
f.prototype.destroy=function(s){M.prototype.destroy.apply(this,arguments);this.stop();var S=f._aServers;var i=q.inArray(this,S);S.splice(i,1);};
f._aFilters=[];f._oServer=null;f._aServers=[];
f._getInstance=function(){if(!this._oServer){this._oServer=window.sinon.fakeServer.create();this._oServer.autoRespond=true;}return this._oServer;};
f.config=function(c){var s=this._getInstance();s.autoRespond=c.autoRespond===false?false:true;s.autoRespondAfter=c.autoRespondAfter||0;s.fakeHTTPMethods=c.fakeHTTPMethods||false;};
f.respond=function(){this._getInstance().respond();};
f.startAll=function(){for(var i=0;i<this._aServers.length;i++){this._aServers[i].start();}};
f.stopAll=function(){for(var i=0;i<this._aServers.length;i++){this._aServers[i].stop();}this._getInstance().restore();this._oServer=null;};
f.destroyAll=function(){this.stopAll();for(var i=0;i<this._aServers.length;i++){this._aServers[i].destroy();}};
f.HTTPMETHOD={GET:"GET",POST:"POST",DELETE:"DELETE",PUT:"PUT",MERGE:"MERGE",PATCH:"PATCH"};
f._addFilter=function(F){this._aFilters.push(F);};
f._removeFilter=function(F){var i=q.inArray(F,this._aFilters);if(i!==-1){this._aFilters.splice(i,1);}return i!==-1;};
f._removeResponse=function(r){var R=this._oServer.responses;var l=R.length;for(var i=0;i<l;i++){if(R[i].response===r){R.splice(i,1);return true;}}return false;};
window.sinon.FakeXMLHttpRequest.useFilters=true;window.sinon.xhr.supportsCORS=q.support.cors;window.sinon.FakeXMLHttpRequest.addFilter(function(m,u,a,U,p){var F=f._aFilters;for(var i=0;i<F.length;i++){var b=F[i];if(b(m,u,a,U,p)){return false;}}return true;});var g=function(F){if(/.*\.json$/i.test(F)){return"JSON";}if(/.*\.xml$/i.test(F)){return"XML";}if(/.*metadata$/i.test(F)){return"XML";}return null;};
window.sinon.FakeXMLHttpRequest.prototype.respondFile=function(s,h,F){var r=q.sap.sjax({url:F,dataType:"text"});if(!r.success){throw new Error("Could not load file from: "+F);}var o=r.data;var m=g(F);if(this["respond"+m]){this["respond"+m](s,h,o);}else{this.respond(s,h,o);}};
window.sinon.FakeXMLHttpRequest.prototype.respondJSON=function(s,h,j){h=h||{};h["Content-Type"]=h["Content-Type"]||"application/json";this.respond(s,h,typeof j==="string"?j:JSON.stringify(j));};
window.sinon.FakeXMLHttpRequest.prototype.respondXML=function(s,h,x){h=h||{};h["Content-Type"]=h["Content-Type"]||"application/xml";this.respond(s,h,x);};
return f;});
sap.ui.predefine('sap/ui/core/util/MockServerAnnotationsHandler',['jquery.sap.global','sap/ui/Device','sap/ui/core/util/MockServer','sap/ui/model/odata/ODataModel','jquery.sap.xml'],function(q,D,M,O){"use strict";return{parse:function(m,s){if(!this._index){this._index=0;}var u="/annotationhandler"+this._index++ +"/";var o=new M({rootUri:u,requests:[{method:"GET",path:new RegExp("\\$metadata"),response:function(x){x.respond(200,{"Content-Type":"application/xml;charset=utf-8"},s);}}]});o.start();var a={annotationURI:[u+"$metadata"],json:true};var b=new O(u,a);var A=b.getServiceAnnotations();o.destroy();return A;}};},true);
sap.ui.predefine('sap/ui/core/util/XMLPreprocessor',['jquery.sap.global','sap/ui/base/BindingParser','sap/ui/base/ManagedObject','sap/ui/core/XMLTemplateProcessor','sap/ui/model/BindingMode','sap/ui/model/CompositeBinding','sap/ui/model/Context'],function(q,B,M,X,a,C,b){'use strict';var u={},N="http://schemas.sap.com/sapui5/extension/sap.ui.core.template/1",x="sap.ui.core.util.XMLPreprocessor",p=[x],P=x+"/insertFragment",s=x+"/getResolvedBinding",c=x+".process",v={},W=M.extend("sap.ui.core.util._with",{metadata:{properties:{any:"any"},aggregations:{child:{multiple:false,type:"sap.ui.core.util._with"}}}}),R=W.extend("sap.ui.core.util._repeat",{metadata:{aggregations:{list:{multiple:true,type:"n/a",_doesNotRequireFactory:true}}},updateList:function(){}});
function d(w,S,i,j){function k(n){if(!j){j=w.getBinding("any");if(j instanceof C){j=j.getBindings();if(i!==undefined){j=j[i];}}}return Array.isArray(j)?j[n]:j;}function m(o){return o instanceof b?o.getPath():o.getModel().resolve(o.getPath(),o.getContext());}return{getInterface:function(n,o){var t,y,z;if(typeof n==="string"){o=n;n=undefined;}k();if(Array.isArray(j)){if(n>=0&&n<j.length){y=j[n];}else{throw new Error("Invalid index of part: "+n);}}else if(n!==undefined){throw new Error("Not the root formatter of a composite binding");}else if(o){y=j;}else{throw new Error("Missing path");}if(o){z=y.getModel();if(o.charAt(0)!=='/'){t=y instanceof b?y:z.createBindingContext(y.getPath(),y.getContext());}y=z.createBindingContext(o,t);if(!y){throw new Error("Model could not create binding context synchronously: "+z);}}return d(null,S,undefined,y);},getModel:function(n){var o=k(n);return o&&o.getModel();},getPath:function(n){var o=k(n);return o&&m(o);},getSetting:function(n){if(n==="bindingContexts"||n==="models"){throw new Error("Illegal argument: "+n);}return S[n];}};}
function g(w,o,S,j){function k(I,i){var F=I.formatter;I.mode=a.OneTime;if(F&&F.requiresIContext===true){I.formatter=F.bind(null,d(w,S,i));}I.parameters=I.parameters||{};I.parameters.scope=j;}try{k(o);if(o.parts){o.parts.forEach(k);}w.bindProperty("any",o);return w.getBinding("any")?w.getAny():u;}finally{w.unbindProperty("any",true);}}
function e(E,L){return E.namespaceURI===N&&l(E)===L;}
function l(E){return E.localName||E.baseName;}
function r(E){var m=E.getAttribute("template:require");if(m){q.sap.require.apply(q.sap,m.split(" "));}}
function f(E){var A,o=E.attributes,t="<"+E.nodeName,i,n;for(i=0,n=o.length;i<n;i+=1){A=o.item(i);t+=" "+A.name+'="'+A.value+'"';}return t+(E.childNodes.length?">":"/>");}
function h(E,i){i.visitNode(E);}
return{plugIn:function(V,n,L){var o=v[n];if(V!==null&&typeof V!=="function"||V===h){throw new Error("Invalid visitor: "+V);}if(!n||n===N||n==="sap.ui.core"||n.indexOf(" ")>=0){throw new Error("Invalid namespace: "+n);}q.sap.log.debug("Plug-in visitor for namespace '"+n+"', local name '"+L+"'",V,x);if(L){n=n+" "+L;o=v[n]||o;}v[n]=V;return o||h;},visitNodeWrapper:h,process:function(o,V,S){var j=V.caller,D=q.sap.log.isLoggable(q.sap.log.Level.DEBUG,x),k=D,m=V.name,F={},t,w=0,y={},z=V._supportInfo,A=q.sap.log.isLoggable(q.sap.log.Level.WARNING,x);function E(i){return{getContext:function(n){var h1,i1,j1;n=n||"";if(n[0]==="{"){throw new Error("Must be a simple path, not a binding: "+n);}h1=B.simpleParser("{"+n+"}");i1=i.getModel(h1.model);if(!i1){throw new Error("Unknown model '"+h1.model+"': "+n);}j1=i1.resolve(h1.path,i.getBindingContext(h1.model));if(!j1){throw new Error("Cannot resolve path: "+n);}return i1.createBindingContext(j1);},getResult:function(n,h1){var i1=O(n,h1,i,true);if(i1===u){throw new Error("Binding not ready: "+n);}return i1;},getSettings:function(){return S;},getViewInfo:function(){return q.extend(true,{},V);},insertFragment:function(n,h1){Q(n,h1,i);},visitAttributes:function(n){d1(n,i);},visitChildNodes:function(n){e1(n,i);},visitNode:function(n){f1(n,i);},"with":function(n,h1){var i1,j1=false,t,k1=new W();if(!h1){i.setChild(k1);}for(t in n){i1=n[t];j1=true;k1.setModel(i1.getModel(),t);k1.bindObject({model:t,path:i1.getPath()});}return j1||h1?E(k1):this;}};}function G(i){if(D){q.sap.log.debug(K()+Array.prototype.slice.call(arguments,1).join(" "),i&&f(i),x);}}function H(i){if(D){q.sap.log.debug(K()+"Finished","</"+i.nodeName+">",x);}}function I(i,n){i=i+f(n);q.sap.log.error(i,j,x);throw new Error(j+": "+i);}function J(h1){var i1=h1.childNodes,j1,k1=[],i,n,l1=false;for(i=0,n=i1.length;i<n;i+=1){j1=i1.item(i);if(j1.nodeType===1){k1.push(j1);}}if(!k1.length||!e(k1[0],"then")){return null;}for(i=1,n=k1.length;i<n;i+=1){j1=k1[i];if(l1){I("Expected </"+h1.prefix+":if>, but instead saw ",j1);}if(e(j1,"else")){l1=true;}else if(!e(j1,"elseif")){I("Expected <"+h1.prefix+":elseif> or <"+h1.prefix+":else>, but instead saw ",k1[i]);}}return k1;}function K(){return(w<10?"[ ":"[")+w+"] ";}function L(t){return t&&t.charAt(0)==="."?q.sap.getObject(t.slice(1),undefined,y):q.sap.getObject(t);}function O(i,n,h1,i1,j1){var k1;q.sap.measure.average(s,"",p);k1=B.complexParser(i,y,i1,true,true)||i;if(k1.functionsNotFound){if(i1){g1(n,'Function name(s)',k1.functionsNotFound.join(", "),'not found');}q.sap.measure.end(s);return u;}if(typeof k1==="object"){k1=g(h1,k1,S,y);if(i1&&k1===u){g1(n,'Binding not ready');}}else if(j1){j1();}q.sap.measure.end(s);return k1;}function Q(i,n,h1){var i1,j1=m;h1.$mFragmentContexts=h1.$mFragmentContexts||{};if(h1.$mFragmentContexts[i]){I("Cyclic reference to fragment '"+i+"' ",n);}w++;G(n,"fragmentName =",i);h1.$mFragmentContexts[i]=true;m=i;q.sap.measure.average(P,"",p);i1=F[i];if(!i1){i1=X.loadTemplate(i,"fragment");F[i]=i1;}i1=n.ownerDocument.importNode(i1,true);q.sap.measure.end(P);r(i1);if(i1.namespaceURI==="sap.ui.core"&&l(i1)==="FragmentDefinition"){T(i1,h1,n);}else{n.parentNode.insertBefore(i1,n);f1(i1,h1);}n.parentNode.removeChild(n);m=j1;h1.$mFragmentContexts[i]=false;H(n);w--;}function T(i,n,h1){var i1;h1=h1||i;e1(i,n);while((i1=i.firstChild)){h1.parentNode.insertBefore(i1,h1);}}function U(i,n){var h1=g1.bind(null,i,'Constant test condition'),i1,j1=i.getAttribute("test"),k1;try{k1=O(j1,i,n,true,h1);if(k1===u){k1=false;}}catch(ex){g1(i,'Error in formatter:',ex);k1=undefined;}i1=!!k1&&k1!=="false";if(D){if(typeof k1==="string"){k1=JSON.stringify(k1);}else if(k1===undefined){k1="undefined";}else if(Array.isArray(k1)){k1="[object Array]";}G(i,"test ==",k1,"-->",i1);}return i1;}function Y(i,n,h1){var i1=n.value,j1;try{j1=O(i1,i,h1,false);if(j1===u){G(i,'Binding not ready for attribute',n.name);}else if(j1===undefined){G(i,"Removed attribute",n.name);i.removeAttribute(n.name);}else{if(D&&j1!==n.value){G(i,n.name,"=",j1);}n.value=j1;}}catch(ex){G(i,'Error in formatter:',ex);}}function Z(i,n){var t=i.getAttribute("name"),h1,i1,j1=i.getAttribute("value");if(!t||t.length<=1||t.lastIndexOf(".")!==0){I("Missing proper relative name in ",i);}t=t.slice(1);h1=L(j1);if(!h1){I("Invalid value in ",i);}i1=y[t];y[t]=h1;T(i,n);i.parentNode.removeChild(i);y[t]=i1;}function $(i,n){var t=i.getAttribute("name"),h1=u,i1;try{h1=O(t,i,n,true);if(h1!==u&&h1!==t){G(i,"name =",h1);}}catch(ex){g1(i,'Error in formatter:',ex);}var k1=sap.ui.require("sap/ui/core/CustomizingConfiguration");if(h1!==u&&k1){i1=k1.getViewExtension(m,h1,V.componentId);if(i1&&i1.className==="sap.ui.core.Fragment"&&i1.type==="XML"){Q(i1.fragmentName,i,n);return true;}}return false;}function _(i,n){var h1=i.getAttribute("fragmentName"),i1;try{i1=O(h1,i,n,true);}catch(ex){g1(i,'Error in formatter:',ex);return;}if(i1!==u){Q(i1,i,n);}}function a1(i,n){var h1=J(i),i1,j1;w++;if(h1){j1=i;i1=h1.shift();do{if(U(j1,n)){break;}j1=i1=h1.shift();}while(j1&&l(j1)==="elseif");}else if(U(i,n)){i1=i;}if(i1){T(i1,n,i);}i.parentNode.removeChild(i);H(i);w--;}function b1(n,h1){var i1=n.getAttribute("list")||"",j1=B.complexParser(i1,y,false,true,true),k1,l1,m1,n1,o1=n.getAttribute("var");if(o1===""){I("Missing variable name for ",n);}if(!j1){I("Missing binding for ",n);}if(j1.functionsNotFound){g1(n,'Function name(s)',j1.functionsNotFound.join(", "),'not found');}n1=new R();h1.setChild(n1);j1.mode=a.OneTime;n1.bindAggregation("list",j1);l1=n1.getBinding("list");n1.unbindAggregation("list",true);m1=j1.model;if(!l1){I("Missing model '"+m1+"' in ",n);}k1=l1.getContexts(j1.startIndex,j1.length);o1=o1||m1;n1.setModel(l1.getModel(),o1);w++;G(n,"Starting");k1.forEach(function(p1,i){var q1=(i===k1.length-1)?n:n.cloneNode(true);n1.setBindingContext(p1,o1);G(n,o1,"=",p1.getPath());T(q1,n1,n);});H(n);w--;n.parentNode.removeChild(n);}function c1(i,n){var h1,i1,j1,k1,l1=i.getAttribute("helper"),m1,n1=i.getAttribute("path"),o1,p1=i.getAttribute("var");if(p1===""){I("Missing variable name for ",i);}j1=new W();n.setChild(j1);h1=B.simpleParser("{"+n1+"}");p1=p1||h1.model;if(l1||p1){i1=n.getModel(h1.model);if(!i1){I("Missing model '"+h1.model+"' in ",i);}o1=i1.resolve(h1.path,n.getBindingContext(h1.model));if(!o1){I("Cannot resolve path for ",i);}m1=i1.createBindingContext(o1);if(l1){k1=L(l1);if(typeof k1!=="function"){I("Cannot resolve helper for ",i);}m1=k1(m1);}if(m1 instanceof b){i1=m1.getModel();o1=m1.getPath();}else if(m1!==undefined){if(typeof m1!=="string"||m1===""){I("Illegal helper result '"+m1+"' in ",i);}o1=m1;}j1.setModel(i1,p1);j1.bindObject({model:p1,path:o1});}else{j1.bindObject(n1);}w++;G(i,p1,"=",o1);if(j1.getBindingContext(p1)===n.getBindingContext(p1)){g1(i,'Set unchanged path:',o1);j1=n;}T(i,j1);i.parentNode.removeChild(i);H(i);w--;}function d1(n,h1){var i,i1,j1=n.attributes;for(i=j1.length-1;i>=0;i-=1){i1=j1.item(i);if(z){z({context:undefined,env:{caller:"visitAttributes",before:{name:i1.name,value:i1.value}}});}Y(n,i1,h1);if(z){z({context:undefined,env:{caller:"visitAttributes",after:{name:i1.name,value:i1.value}}});}}}function e1(h1,i1){var i,j1=h1.childNodes,n=j1.length,k1=new Array(n);for(i=0;i<n;i+=1){k1[i]=j1.item(i);}j1=null;for(i=0;i<n;i+=1){f1(k1[i],i1);}}function f1(n,i){var h1,i1;if(n.nodeType!==1){return;}if(z){z({context:n,env:{caller:"visitNode",before:{name:n.tagName}}});}if(n.namespaceURI===N){switch(l(n)){case"alias":Z(n,i);return;case"if":a1(n,i);return;case"repeat":b1(n,i);return;case"with":c1(n,i);return;default:I("Unexpected tag ",n);}}else if(n.namespaceURI==="sap.ui.core"){switch(l(n)){case"ExtensionPoint":if($(n,i)){return;}break;case"Fragment":if(n.getAttribute("type")==="XML"){_(n,i);return;}break;}}else{h1=v[n.namespaceURI+" "+l(n)]||v[n.namespaceURI];if(h1){w++;G(n,"Calling visitor");i1=h1(n,E(i));if(i1!==undefined){I("Unexpected return value from visitor for ",n);}H(n);w--;return;}}d1(n,i);e1(n,i);if(z){z({context:n,env:{caller:"visitNode",after:{name:n.tagName}}});}}function g1(i){if(A){if(!k){k=true;q.sap.log.warning("Warning(s) during processing of "+j,null,x);}q.sap.log.warning(K()+Array.prototype.slice.call(arguments,1).join(" "),i&&f(i),x);}}q.sap.measure.average(c,"",p);S=S||{};if(D){G(undefined,"Start processing",j);if(S.bindingContexts instanceof b){G(undefined,"undefined =",S.bindingContexts);}else{for(t in S.bindingContexts){G(undefined,t,"=",S.bindingContexts[t]);}}}if(z){z({context:o,env:{caller:"view",viewinfo:q.extend(true,{},V),settings:q.extend(true,{},S),clone:o.cloneNode(true),type:"template"}});}r(o);f1(o,new W({models:S.models,bindingContexts:S.bindingContexts}));G(undefined,"Finished processing",j);q.sap.measure.end(c);return o;}};},true);
sap.ui.predefine('sap/ui/core/util/serializer/HTMLViewSerializer',['sap/ui/base/EventProvider','./Serializer','./delegate/HTML','sap/ui/thirdparty/vkbeautify'],function(E,S,H,v){"use strict";
var a=E.extend("sap.ui.core.util.serializer.HTMLViewSerializer",{constructor:function(V,w,g,G){E.apply(this);this._oView=V;this._oWindow=w;this._fnGetControlId=g;this._fnGetEventHandlerName=G;}});
a.prototype.serialize=function(){var t=this;var s=function(C){return C instanceof this._oWindow.sap.ui.core.mvc.View&&C!==t._oView;};var c=new S(this._oView,new H(this._fnGetControlId,this._fnGetEventHandlerName),true,this._oWindow,s);var r=c.serialize();var V=[];V.push('<template');if(this._oView.getControllerName&&this._oView.getControllerName()){V.push(' data-controller-name="'+this._oView.getControllerName()+'"');}V.push(" >");V.push(r);V.push("</template>");return v.xml(V.join(""));};
return a;});
sap.ui.predefine('sap/ui/core/util/serializer/Serializer',['jquery.sap.global','sap/ui/base/EventProvider'],function(q,E){"use strict";
var S=E.extend("sap.ui.core.util.serializer.Serializer",{constructor:function(r,s,b,w,f,a){E.apply(this);this._oRootControl=r;this._delegate=s;this._bSkipRoot=!!b;this._oWindow=w||window;this._fnSkipAggregations=f;this._fnSkipElement=a;}});
S.prototype.serialize=function(){return this._serializeRecursive(this._oRootControl,0);};
S.prototype._serializeRecursive=function(c,l,a,b){var C=[];var w=(!this._bSkipRoot||l!==0);if(w){var s=this._delegate.start(c,a,b);var m=this._delegate.middle(c,a,b);C.push(s+m);}var A=c.getMetadata().getAllAggregations();if(A){for(var n in A){if(this._fnSkipAggregations&&this._fnSkipAggregations(c,n)){continue;}var e=[];var o=A[n];var v=c[o._sGetter]();if(c.getBindingPath(n)&&c.getBindingInfo(n).template){e.push(c.getBindingInfo(n).template);}else if(v&&v.length){for(var i=0;i<v.length;i++){var O=v[i];if(this._isObjectSerializable(O)){e.push(O);}}}else if(this._isObjectSerializable(v)){e.push(v);}if(e.length>0){if(w){C.push(this._delegate.startAggregation(c,n));}var d=this._isDefaultAggregation(c,n);for(var j=0;j<e.length;j++){C.push(this._serializeRecursive(e[j],l+1,n,d));}if(w){C.push(this._delegate.endAggregation(c,n));}}}}if(w){var f=this._delegate.end(c,a,b);C.push(f);}return C.join("");};
S.prototype._isObjectSerializable=function(o){return o instanceof this._oWindow.sap.ui.core.Element&&!(this._fnSkipElement&&this._fnSkipElement(o));};
S.prototype._isDefaultAggregation=function(c,a){return c.getMetadata().getDefaultAggregationName()===a;};
return S;});
sap.ui.predefine('sap/ui/core/util/serializer/ViewSerializer',['jquery.sap.global','sap/ui/base/EventProvider','./HTMLViewSerializer','./XMLViewSerializer'],function(q,E,H,X){"use strict";
var V=E.extend("sap.ui.core.util.serializer.ViewSerializer",{constructor:function(r,w,d){E.apply(this);this._oRootControl=r;this._oWindow=w||window;this._mViews={};this._sDefaultXmlNamespace=d;}});
V.prototype.serializeToXML=function(){return this.serialize("XML");};
V.prototype.serializeToHTML=function(){return this.serialize("HTML");};
V.prototype.serialize=function(c){this._mViews={};this._sConvertToViewType=c||undefined;return this._serializeRecursive(this._oRootControl);};
V.prototype._getViewType=function(v){if(!this._sConvertToViewType){if(v instanceof this._oWindow.sap.ui.core.mvc.HTMLView){return"HTML";}else if(v instanceof this._oWindow.sap.ui.core.mvc.XMLView){return"XML";}}return this._sConvertToViewType;};
V.prototype._serializeRecursive=function(c){if(c instanceof this._oWindow.sap.ui.core.mvc.View){var v=this._getViewSerializer(c,this._getViewType(c));if(v){var o=c.getViewName()||c.getControllerName();if(!this._mViews[o]){this._mViews[o]=v.serialize(this._getViewType(c));}}}if(c.getMetadata().getClass()===this._oWindow.sap.ui.core.UIArea){var C=c.getContent();for(var i=0;i<C.length;i++){this._serializeRecursive(C[i]);}}else if(c.getMetadata().getClass()===this._oWindow.sap.ui.core.ComponentContainer){this._serializeRecursive(c.getComponentInstance().getRootControl());}else{var a=c.getMetadata().getAllAggregations();if(a){for(var n in a){var A=a[n];var b=c[A._sGetter]();if(b&&b.length){for(var i=0;i<b.length;i++){var O=b[i];if(O instanceof this._oWindow.sap.ui.core.Element){this._serializeRecursive(O);}}}else if(b instanceof this._oWindow.sap.ui.core.Element){this._serializeRecursive(b);}}}}return this._mViews;};
V.prototype._getViewSerializer=function(v,t){var g=function(e){if(e.fFunction&&e.fFunction._sapui_handlerName){var h=e.fFunction._sapui_handlerName;var c=v.getController();if(c[h]||sap.ui.getCore().getConfiguration().getControllerCodeDeactivated()){return h;}}};var G=function(c){if(c._sapui_controlId){return c._sapui_controlId;}return c.getId().replace(v.createId(""),"");};if(t==="HTML"){return new H(v,this._oWindow,G,g);}else if(t==="XML"){return new X(v,this._oWindow,this._sDefaultXmlNamespace,G,g);}else{var t=(v)?v.constructor:"?";throw Error("View type '"+t+"' is not supported for conversion. Only HTML and XML is supported");}};
return V;});
sap.ui.predefine('sap/ui/core/util/serializer/XMLViewSerializer',['jquery.sap.global','sap/ui/base/EventProvider','./Serializer','./delegate/XML','sap/ui/thirdparty/vkbeautify'],function(q,E,S,X,v){"use strict";
var a=E.extend("sap.ui.core.util.serializer.XMLViewSerializer",{constructor:function(V,w,d,g,G){E.apply(this);this._oView=V;this._oWindow=w;this._sDefaultNamespace=d;this._fnGetControlId=g;this._fnGetEventHandlerName=G;}});
a.prototype.serialize=function(){var p=[];var m=function(C,P){if(!P){var T=(C)?C.constructor:"?";throw Error("Controls with empty package are currently not supported by the XML serializer: "+T);}if(p.indexOf(P)===-1){p.push(P);}};var t=this;var s=function(C){return C instanceof this._oWindow.sap.ui.core.mvc.View&&C!==t._oView;};var c=new S(this._oView,new X(this._sDefaultNamespace,this._fnGetControlId,this._fnGetEventHandlerName,m),true,this._oWindow,s);var r=c.serialize();var V=[];V.push('<sap.ui.core.mvc:View');if(this._oView.getControllerName&&this._oView.getControllerName()){V.push(' controllerName="'+this._oView.getControllerName()+'"');}if(p.indexOf('sap.ui.core.mvc')===-1){p.push('sap.ui.core.mvc');}for(var i=0;i<p.length;i++){if(this._sDefaultNamespace&&this._sDefaultNamespace===p[i]){V.push(' xmlns="'+p[i]+'"');}else{V.push(' xmlns:'+p[i]+'="'+p[i]+'"');}}V.push(" >");V.push(r);V.push("</sap.ui.core.mvc:View>");return v.xml(V.join(""));};
return a;});
sap.ui.predefine('sap/ui/core/util/serializer/delegate/Delegate',['sap/ui/base/EventProvider'],function(E){"use strict";
var D=E.extend("sap.ui.core.util.serializer.delegate.Delegate",{constructor:function(){E.apply(this);}});
D.prototype.start=function(c,a,i){return"";};
D.prototype.middle=function(c,a,i){return"";};
D.prototype.end=function(c,a,i){return"";};
D.prototype.startAggregation=function(c,a){return"";};
D.prototype.endAggregation=function(c,a){return"";};
return D;});
sap.ui.predefine('sap/ui/core/util/serializer/delegate/HTML',['jquery.sap.global','./Delegate'],function(q,D){"use strict";
var H=D.extend("sap.ui.core.util.serializer.delegate.HTML",{constructor:function(g,G){D.apply(this);this._fnGetControlId=g;this._fnGetEventHandlerName=G;}});
H.prototype.startAggregation=function(c,a){return'<div data-sap-ui-aggregation="'+a+'">';};
H.prototype.endAggregation=function(c,a){return'</div>';};
H.prototype.start=function(c,a,i){return"<div";};
H.prototype.middle=function(c,a,b){var h=[];var I=(this._fnGetControlId)?this._fnGetControlId(c):c.getId();if(I.indexOf("__")!==0){h.push(this._createAttribute("id",I));}h.push(this._createAttribute("data-sap-ui-type",c.getMetadata()._sClassName));if(c.aCustomStyleClasses){var C=c.aCustomStyleClasses;var d=[];for(var i=0;i<C.length;i++){var s=C[i];if(!q.sap.startsWith(s,"sapM")&&!q.sap.startsWith(s,"sapUi")){d.push(s);}}if(d.length>0){h.push(this._createAttribute("class",d.join(" ")));}}if(this._fnGetEventHandlerName){var e=c.getMetadata().getAllEvents();for(var E in e){if(c.hasListeners(E)){var f=c.mEventRegistry[E];for(var i=0;i<f.length;i++){var g=this._fnGetEventHandlerName(f[i]);if(g){h.push(this._createAttribute("data-"+this._createHtmlAttributeName(E),g));break;}}}}}var A=c.getMetadata().getAllAssociations();this._createAttributes(h,c,A,function(n,v){if(A[n].multiple){return v.join(" ");}return v;},function(n,v){return(v!==null&&typeof v!==undefined&&v!=="");});var p=c.getMetadata().getAllProperties();var o=c.getMetadata().getPropertyDefaults();this._createAttributes(h,c,p,null,function(n,v){return!q.sap.equal(v,o[n]);});var j=c.getMetadata().getAllAggregations();this._createAttributes(h,c,j,null,function(n,v){if(!c.getBindingInfo(n)&&(!v||(typeof v!=="string"))){return false;}return true;});h.push('>');return h.join('');};
H.prototype.end=function(c,a,i){return"</div>";};
H.prototype._createAttributes=function(h,c,o,g,v){for(var n in o){var p=o[n];var G=p._sGetter;if(c[G]){var V=c[G]();V=g?g(n,V):V;if(!c.getBindingInfo(n)){if(!v||v(n,V)){h.push(this._createAttribute("data-"+this._createHtmlAttributeName(n),V));}}else{h.push(this._createDataBindingAttribute(c,n,V));}}}};
H.prototype._createDataBindingAttribute=function(c,n,v){var b=c.getBindingInfo(n);var B=null;var p=v;if(!b.bindingString){if(b.binding){var C=b.binding.getMetadata().getName();if(C==="sap.ui.model.PropertyBinding"||C==="sap.ui.model.resource.ResourcePropertyBinding"){B=b.binding.getValue();}}if(b.parts){b=b.parts[0];}var m=b.model;if(B===v||B===null){p="{"+(m?(m+">"+b.path):b.path)+"}";}}else{p=b.bindingString;}return this._createAttribute("data-"+this._createHtmlAttributeName(n),p);};
H.prototype._createAttribute=function(a,v){return' '+a+'="'+v+'"';};
H.prototype._createHtmlAttributeName=function(n){return q.sap.hyphen(n);};
return H;});
sap.ui.predefine('sap/ui/core/util/serializer/delegate/XML',['jquery.sap.global','./Delegate'],function(q,D){"use strict";
var X=D.extend("sap.ui.core.util.serializer.delegate.XML",{constructor:function(d,g,G,m){D.apply(this);this._sDefaultNamespace=d;this._fnGetControlId=g;this._fnMemorizePackage=m;this._fnGetEventHandlerName=G;}});
X.prototype.startAggregation=function(c,a){return'<'+this._createAggregationName(c,a)+'>';};
X.prototype.endAggregation=function(c,a){return'</'+this._createAggregationName(c,a)+'>';};
X.prototype.start=function(c,a,i){return"<"+this._createTagName(c);};
X.prototype.end=function(c,a,i){return"</"+this._createTagName(c)+">";};
X.prototype.middle=function(c,a,b){var x=[];var I=(this._fnGetControlId)?this._fnGetControlId(c):c.getId();if(I.indexOf("__")!==0){x.push(this._createAttribute("id",I));}if(c.aCustomStyleClasses){var C=c.aCustomStyleClasses;var d=[];for(var i=0;i<C.length;i++){var s=C[i];if(!q.sap.startsWith(s,"sapM")&&!q.sap.startsWith(s,"sapUi")){d.push(s);}}if(d.length>0){x.push(this._createAttribute("class",d.join(" ")));}}if(this._fnGetEventHandlerName){var e=c.getMetadata().getAllEvents();for(var E in e){if(c.hasListeners(E)){var f=c.mEventRegistry[E];for(var i=0;i<f.length;i++){var h=this._fnGetEventHandlerName(f[i]);if(h){x.push(this._createAttribute(E,h));break;}}}}}var A=c.getMetadata().getAllAssociations();this._createAttributes(x,c,A,function(n,v){if(A[n].multiple){return v.join(" ");}return v;},function(n,v){return(v!==null&&typeof v!==undefined&&v!=="");});var p=c.getMetadata().getAllProperties();var o=c.getMetadata().getPropertyDefaults();this._createAttributes(x,c,p,null,function(n,v){return!q.sap.equal(v,o[n]);});var g=c.getMetadata().getAllAggregations();this._createAttributes(x,c,g,null,function(n,v){if(!c.getBindingInfo(n)&&(!v||(typeof v!=="string"))){return false;}return true;});x.push('>');return x.join('');};
X.prototype._createAttributes=function(x,c,o,g,v){for(var n in o){var p=o[n];var G=p._sGetter;if(c[G]){var V=c[G]();V=g?g(n,V):V;if(!c.getBindingInfo(n)){if(!v||v(n,V)){x.push(this._createAttribute(n,V));}}else{x.push(this._createDataBindingAttribute(c,n,V));}}}};
X.prototype._createDataBindingAttribute=function(c,n,v){var b=c.getBindingInfo(n);var B=null;var p=v;if(!b.bindingString){if(b.binding){var C=b.binding.getMetadata().getName();if(C==="sap.ui.model.PropertyBinding"||C==="sap.ui.model.resource.ResourcePropertyBinding"){B=b.binding.getValue();}}if(b.parts){b=b.parts[0];}var m=b.model;if(B===v||B===null){p="{"+(m?(m+">"+b.path):b.path)+"}";}}else{p=b.bindingString;}return this._createAttribute(n,p);};
X.prototype._createAttribute=function(a,v){var e=q.type(v)==="string"?q.sap.encodeHTML(v):v;return' '+a+'="'+e+'"';};
X.prototype._createTagName=function(c){var C=c.getMetadata()._sClassName;var l=C.lastIndexOf(".");var s=(l===-1)?C:C.substring(l+1);var p=(l===-1)?C:C.substring(0,l);if(this._fnMemorizePackage){this._fnMemorizePackage(c,p);}return this._createNamespace(p,s);};
X.prototype._createAggregationName=function(c,a){var C=c.getMetadata()._sClassName;var l=C.lastIndexOf(".");var p=(l===-1)?C:C.substring(0,l);return this._createNamespace(p,a);};
X.prototype._createNamespace=function(n,N){if(this._sDefaultNamespace&&this._sDefaultNamespace===n){return N;}else{return n+":"+N;}};
return X;});
sap.ui.predefine('sap/ui/core/ws/ReadyState',function(){"use strict";var R={CONNECTING:0,OPEN:1,CLOSING:2,CLOSED:3};return R;},true);
sap.ui.predefine('sap/ui/core/ws/SapPcpWebSocket',['jquery.sap.global','./WebSocket'],function(q,W){"use strict";
var S=W.extend("sap.ui.core.ws.SapPcpWebSocket",{constructor:function(u,p){W.apply(this,arguments);}});
S.SUPPORTED_PROTOCOLS={v10:"v10.pcp.sap.com"};S._deserializeRegexp=/((?:[^:\\]|(?:\\.))+):((?:[^:\\\n]|(?:\\.))*)/;S._SEPARATOR="\n\n";S._MESSAGE="MESSAGE";
S.prototype._onopen=function(){var s=false;if(this.getProtocol()===""){s=true;}else{for(var p in S.SUPPORTED_PROTOCOLS){if(S.SUPPORTED_PROTOCOLS.hasOwnProperty(p)){if(S.SUPPORTED_PROTOCOLS[p]===this.getProtocol()){s=true;break;}}}}if(s){this.fireOpen();}else{q.sap.log.error("Unsupported protocol '"+this.getProtocol()+"' selected by the server. "+"Connection will be closed.");this.close("Unsupported protocol selected by the server");}};
S.prototype._onmessage=function(m){var s=-1,e={};if(typeof m.data==="string"){s=m.data.indexOf(S._SEPARATOR);}if(s!==-1){e.pcpFields=this._extractPcpFields(m.data.substring(0,s));e.data=m.data.substr(s+S._SEPARATOR.length);}else{q.sap.log.warning("Invalid PCP message received: "+m.data);e.pcpFields={};e.data=m.data;}this.fireMessage(e);};
S.prototype._extractPcpFields=function(h){var f=h.split("\n"),l=[],p={};for(var i=0;i<f.length;i++){l=f[i].match(S._deserializeRegexp);if(l&&l.length===3){p[this._unescape(l[1])]=this._unescape(l[2]);}}return p;};
S.prototype._unescape=function(e){var p=e.split("\u0008"),u="";for(var i=0;i<p.length;i++){p[i]=p[i].replace(/\\\\/g,"\u0008").replace(/\\:/g,':').replace(/\\n/g,'\n').replace(/\u0008/g,"\\");}u=p.join("\u0008");return u;};
S.prototype._serializePcpFields=function(p,m,P){var s="",f="",a="";if(m==='string'){a='text';}else if(m==='blob'||m==='arraybuffer'){a='binary';}if(p&&typeof p==='object'){for(f in p){if(p.hasOwnProperty(f)&&f.indexOf('pcp-')!==0){s+=this._escape(f)+":"+this._escape(String(p[f]))+"\n";}}}return"pcp-action:"+P+"\npcp-body-type:"+a+"\n"+s+"\n";};
S.prototype._escape=function(u){return u.replace(/\\/g,'\\\\').replace(/:/g,'\\:').replace(/\n/g,'\\n');};
S.prototype.send=function(m,p){var M=typeof m,P="";P=this._serializePcpFields(p,M,S._MESSAGE);W.prototype.send.call(this,P+m);return this;};
return S;});
sap.ui.predefine('sap/ui/core/ws/WebSocket',['jquery.sap.global','sap/ui/Device','sap/ui/base/EventProvider','./ReadyState','sap/ui/thirdparty/URI'],function(q,D,E,R,U){"use strict";
var W=E.extend("sap.ui.core.ws.WebSocket",{
constructor:function(u,p){E.apply(this);if(!D.support.websocket){throw new Error("Browser does not support WebSockets.");}if(typeof(u)!=="string"){throw new Error("sUrl must be a string.");}if(typeof(p)!=='undefined'&&!Array.isArray(p)&&typeof(p)!=='string'){throw new Error("aProtocols must be a string, array of strings or undefined.");}this._openConnection(u,p);},
metadata:{publicMethods:["send","close","getReadyState","getProtocol"]}
});
W.prototype.getInterface=function(){return this;};
W.M_EVENTS={Open:"open",Close:"close",Error:"error",Message:"message"};
W.prototype.attachOpen=function(d,f,l){this.attachEvent("open",d,f,l);return this;};
W.prototype.detachOpen=function(f,l){this.detachEvent("open",f,l);return this;};
W.prototype.fireOpen=function(a){this.fireEvent("open",a);return this;};
W.prototype.attachClose=function(d,f,l){this.attachEvent("close",d,f,l);return this;};
W.prototype.detachClose=function(f,l){this.detachEvent("close",f,l);return this;};
W.prototype.fireClose=function(a){this.fireEvent("close",a);return this;};
W.prototype.attachError=function(d,f,l){this.attachEvent("error",d,f,l);return this;};
W.prototype.detachError=function(f,l){this.detachEvent("error",f,l);return this;};
W.prototype.fireError=function(a){this.fireEvent("error",a);return this;};
W.prototype.attachMessage=function(d,f,l){this.attachEvent("message",d,f,l);return this;};
W.prototype.detachMessage=function(f,l){this.detachEvent("message",f,l);return this;};
W.prototype.fireMessage=function(a){this.fireEvent("message",a);return this;};
W.prototype._resolveFullUrl=function(u){var o=new U(u);var b=new U();b.search('');b.protocol(b.protocol()==='https'?'wss':'ws');o=o.absoluteTo(b);return o.toString();};
W.prototype._openConnection=function(u,p){var u=this._resolveFullUrl(u);this._oWs=(typeof(p)==='undefined')?new window.WebSocket(u):new window.WebSocket(u,p);this._oWs.onopen=q.proxy(this._onopen,this);this._oWs.onclose=q.proxy(this._onclose,this);this._oWs.onmessage=q.proxy(this._onmessage,this);this._oWs.onerror=q.proxy(this._onerror,this);};
W.prototype._onopen=function(){this.fireOpen();};
W.prototype._onclose=function(c){this.fireClose({code:c.code,reason:c.reason,wasClean:c.wasClean});};
W.prototype._onerror=function(e){this.fireError();};
W.prototype._onmessage=function(m){this.fireMessage({data:m.data});};
W.prototype.send=function(m){if(this.getReadyState()===R.OPEN){this._oWs.send(m);}else if(this.getReadyState()===R.CONNECTING){this.attachEventOnce("open",function(e){this._oWs.send(m);});}else{q.sap.log.warning("Unable to send WebSocket message. "+"Connection is already closed or closing. message: "+m);}return this;};
W.prototype.close=function(c,r){if(typeof(c)==='string'){r=c;c=undefined;}c=(typeof(c)==='undefined')?1000:c;r=(typeof(r)==='undefined')?"":r;if(this.getReadyState()===R.OPEN){this._oWs.close(c,r);}else if(this.getReadyState()===R.CONNECTING){this.attachEventOnce("open",function(e){this._oWs.close(c,r);});}else{var t='';switch(this.getReadyState()){case R.CLOSED:t="Connection is already closed.";break;case R.CLOSING:t="Connection is already closing.";break;}q.sap.log.warning("Unable to close WebSocket connection. "+t);}return this;};
W.prototype.getReadyState=function(){return this._oWs.readyState;};
W.prototype.getProtocol=function(){return this._oWs.protocol;};
return W;});
sap.ui.predefine('sap/ui/model/ClientTreeBindingAdapter',['jquery.sap.global','sap/ui/model/TreeBinding','sap/ui/model/ClientTreeBinding','./TreeBindingAdapter','sap/ui/model/ChangeReason'],function(q,T,C,a,b){"use strict";var c=function(){if(!(this instanceof T)||this._bIsAdapted){return;}a.apply(this);for(var f in c.prototype){if(c.prototype.hasOwnProperty(f)){this[f]=c.prototype[f];}}this._invalidTree=true;this.setNumberOfExpandedLevels(this.mParameters.numberOfExpandedLevels||0);};
c.prototype.setNumberOfExpandedLevels=function(n){this._iNumberOfExpandedLevels=parseInt(n,10);};
c.prototype.getNumberOfExpandedLevels=function(){return this._iNumberOfExpandedLevels;};
c.prototype.nodeHasChildren=function(n){if(!n){return false;}else if(n.isArtificial){return true;}else{return C.prototype.hasChildren.call(this,n.context);}};
c.prototype.resetData=function(o,p){var r=C.prototype.resetData.call(this,o,p);this._aRowIndexMap=[];this._oRootNode=undefined;this._iPageSize=0;this._iThreshold=0;if(!p||p.reason!==b.Sort){this.clearSelection();this._createTreeState(true);}return r;};
c.prototype._calculateGroupID=function(n){var B=this.getPath();var g;if(n.context){var s=n.context.getPath();if(B!="/"){var m=s.match(B+"(.*)");if(m!=null&&m[1]){g=m[1];}else{q.sap.log.warning("CTBA: BindingPath/ContextPath matching problem!");}}if(!g){g=s;}if(q.sap.startsWith(g,"/")){g=g.substring(1,g.length);}var p;if(!n.parent){p=this._calculateGroupID({context:n.context._parentContext||null});}else{p=n.parent.groupID;}g=p+g.replace(/\//g,"_")+"/";}else if(n.context===null){g="/";}return g;};
c.prototype.expand=function(){this._buildTree();a.prototype.expand.apply(this,arguments);};
c.prototype.collapse=function(){this._buildTree();a.prototype.collapse.apply(this,arguments);};
c.prototype._buildTree=function(s,l){if(this._invalidTree){s=s||0;l=l||this.getRootContexts().length;this._invalidTree=false;this._aRowIndexMap=[];a.prototype._buildTree.call(this,s,l);}};
c.prototype.findNode=function(){this._buildTree();return a.prototype.findNode.apply(this,arguments);};
c.prototype.setSelectedIndex=function(){this._buildTree();return a.prototype.setSelectedIndex.apply(this,arguments);};
c.prototype.setSelectionInterval=function(){this._buildTree();return a.prototype.setSelectionInterval.apply(this,arguments);};
c.prototype.addSelectionInterval=function(){this._buildTree();a.prototype.addSelectionInterval.apply(this,arguments);};
c.prototype.removeSelectionInterval=function(){this._buildTree();a.prototype.removeSelectionInterval.apply(this,arguments);};
c.prototype.clearSelection=function(){this._buildTree();a.prototype.clearSelection.apply(this,arguments);};
c.prototype.selectAll=function(){this._buildTree();a.prototype.selectAll.apply(this,arguments);};
c.prototype._calculateRequestLength=function(m,s){return m;};
c.prototype.getLength=function(){this._buildTree();return a.prototype.getLength.apply(this,arguments);};
c.prototype._fireChange=function(){this._invalidTree=true;this.constructor.prototype._fireChange.apply(this,arguments);};
return c;},true);
sap.ui.predefine('sap/ui/model/MetaModel',['./Model'],function(M){"use strict";
var a=M.extend("sap.ui.model.MetaModel",{constructor:function(){M.apply(this,arguments);}});
a.prototype.createBindingContext=function(p,c,P,C){if(typeof c=="function"){C=c;c=null;}if(typeof P=="function"){C=P;P=null;}var s=this.resolve(p,c),n=(s==undefined)?undefined:this.getContext(s?s:"/");if(!n){n=null;}if(C){C(n);}return n;};
a.prototype.destroyBindingContext=function(c){};
return a;});
sap.ui.predefine('sap/ui/model/SelectionModel',['jquery.sap.global','sap/ui/base/EventProvider'],function(q,E){"use strict";
var S=E.extend("sap.ui.model.SelectionModel",{constructor:function(s){E.apply(this);this.iSelectionMode=s||S.SINGLE_SELECTION;this.aSelectedIndices=[];this.iLeadIndex=-1;this.fnSort=function(a,b){return a-b;};this.fnSortReverse=function(a,b){return b-a;};}});
S.SINGLE_SELECTION=0;S.MULTI_SELECTION=1;
S.prototype.getSelectionMode=function(){return this.iSelectionMode;};
S.prototype.setSelectionMode=function(s){this.iSelectionMode=s||S.SINGLE_SELECTION;};
S.prototype.isSelectedIndex=function(i){return this.aSelectedIndices.indexOf(i)!==-1;};
S.prototype.getLeadSelectedIndex=function(){return this.iLeadIndex;};
S.prototype.setLeadSelectedIndex=function(l){this.setSelectionInterval(l,l);return this;};
S.prototype.getMinSelectionIndex=function(){if(this.aSelectedIndices.length>0){var i=this.aSelectedIndices.sort(this.fnSort);return i[0];}else{return-1;}};
S.prototype.getMaxSelectionIndex=function(){if(this.aSelectedIndices.length>0){var i=this.aSelectedIndices.sort(this.fnSortReverse);return i[0];}else{return-1;}};
S.prototype.getSelectedIndices=function(){var i=this.aSelectedIndices.sort(this.fnSort);return i;};
S.prototype.setSelectionInterval=function(f,t){if(this.iSelectionMode===S.SINGLE_SELECTION){f=t;}var F=Math.min(f,t);var T=Math.max(f,t);var o=this.aSelectedIndices.slice();var l={};var c=[];for(var i=0;i<o.length;i++){l[o[i]]=true;if(o[i]<f||o[i]>t){c.push(o[i]);}}var s=[];for(var I=F;I<=T;I++){s.push(I);if(!l[I]){c.push(I);}}this._update(s,t,c);return this;};
S.prototype.addSelectionInterval=function(f,t){if(this.iSelectionMode===S.SINGLE_SELECTION){return this.setSelectionInterval(f,t);}var F=Math.min(f,t);var T=Math.max(f,t);var c=[];var s=this.aSelectedIndices;for(var i=F;i<=T;i++){if(s.indexOf(i)===-1){s.push(i);c.push(i);}}this._update(s,T,c);return this;};
S.prototype.moveSelectionInterval=function(s,m){var c=[];var a=this.aSelectedIndices;var l=this.iLeadIndex;for(var i=0;i<a.length;i++){var I=a[i];if(I>=s){c.push(a[i]);a[i]+=m;c.push(a[i]);if(I===this.iLeadIndex){l+=m;}}}this._update(a,l,c);return this;};
S.prototype.removeSelectionInterval=function(f,t){if(this.iSelectionMode===S.SINGLE_SELECTION){f=t;}var F=Math.min(f,t);var T=Math.max(f,t);var c=[];var s=this.aSelectedIndices;var l=this.iLeadIndex;for(var i=F;i<=T;i++){var I=s.indexOf(i);if(I>-1){s.splice(I,1);c.push(i);}if(i===this.iLeadIndex){l=-1;}}this._update(s,l,c);return this;};
S.prototype.sliceSelectionInterval=function(f,t){var F=Math.min(f,t);var T=Math.max(f,t);var c=[];var r=[];var o=this.aSelectedIndices.slice(0);var s=this.aSelectedIndices;var l=this.iLeadIndex;var R=T-F+1;for(var I=T;I>=F;I--){var a=s.indexOf(I);if(a>-1){s.splice(a,1);r.push(I);}if(I===this.iLeadIndex){l=-1;}}for(var I=0;I<s.length;I++){var O=s[I];if(O>=F){var n=s[I]-R;if(O===l){l=n;}s[I]=n;if(o.indexOf(n)===-1){c.push(n);}}}for(var i=0;i<r.length;i++){var I=o[o.length-1-i];if(c.indexOf(I)===-1){c.push(I);}}for(var i=0;i<r.length;i++){if(s.indexOf(r[i])===-1&&c.indexOf(r[i])===-1){c.push(r[i]);}}this._update(s,l,c);return this;};
S.prototype.clearSelection=function(){if(this.aSelectedIndices.length>0||this.iLeadIndex!==-1){this._update([],-1,this.aSelectedIndices.slice());}return this;};
S.prototype.attachSelectionChanged=function(d,f,l){this.attachEvent("selectionChanged",d,f,l);return this;};
S.prototype.detachSelectionChanged=function(f,l){this.detachEvent("selectionChanged",f,l);return this;};
S.prototype.fireSelectionChanged=function(a){this.fireEvent("selectionChanged",a);return this;};
S.prototype._update=function(s,l,c,b){var p={rowIndices:c&&c.sort(this.fnSort),selectAll:b};this.aSelectedIndices=s;p.oldIndex=this.iLeadIndex;if(this.iLeadIndex!==l){this.iLeadIndex=l;p.leadIndex=this.iLeadIndex;}if(c.length>0||typeof p.leadIndex!=="undefined"){this.fireSelectionChanged(p);}};
S.prototype.selectAll=function(t){var o=this.aSelectedIndices.slice();var l={};var c=[];var s=[];var i=0;for(i=0;i<o.length;i++){l[o[i]]=true;if(o[i]>t){c.push(o[i]);}}for(i=0;i<=t;i++){s.push(i);if(!l[i]){c.push(i);}}this._update(s,0,c,true);return this;};
return S;});
sap.ui.predefine('sap/ui/model/TreeAutoExpandMode',['jquery.sap.global'],function(q){"use strict";var T={Sequential:"Sequential",Bundled:"Bundled"};return T;},true);
sap.ui.predefine('sap/ui/model/TreeBindingAdapter',['jquery.sap.global','sap/ui/model/TreeBinding','sap/ui/model/ClientTreeBinding','sap/ui/model/TreeAutoExpandMode','sap/ui/model/ChangeReason','sap/ui/model/TreeBindingUtils','sap/ui/model/odata/OperationMode'],function(q,T,C,c,d,e,O){"use strict";var f=function(){if(!(this instanceof T)||this._bIsAdapted){return;}for(var a in f.prototype){if(f.prototype.hasOwnProperty(a)){this[a]=f.prototype[a];}}this.mParameters=this.mParameters||{};this._aRowIndexMap=[];this._iThreshold=0;this._iPageSize=0;this.setAutoExpandMode(this.mParameters.autoExpandMode||c.Sequential);if(this.mParameters.collapseRecursive===undefined){this.bCollapseRecursive=true;}else{this.bCollapseRecursive=!!this.mParameters.collapseRecursive;}this._createTreeState();this._bIsAdapted=true;};
f.prototype.getCurrentTreeState=function(){var D=";";var E={};for(var g in this._mTreeState.expanded){E[g]=true;}var m={};for(var g in this._mTreeState.collapsed){m[g]=true;}var s={};for(var g in this._mTreeState.selected){s[g]=true;}return{_getExpandedList:function(){return Object.keys(E).join(D);},_getCollapsedList:function(){return Object.keys(m).join(D);},_getSelectedList:function(){return Object.keys(s).join(D);},_isExpanded:function(g){return!!E[g];},_isCollapsed:function(g){return!!m[g];},_remove:function(g){delete E[g];delete m[g];delete s[g];}};};
f.prototype.setTreeState=function(t){this._oInitialTreeState=t;};
f.prototype.setAutoExpandMode=function(a){this._autoExpandMode=a;};
f.prototype.getLength=function(){if(!this._oRootNode){return 0;}return this._oRootNode.magnitude;};
f.prototype.getContextByIndex=function(i){if(this.isInitial()){return;}var n=this.findNode(i);return n?n.context:undefined;};
f.prototype.getNodeByIndex=function(i){if(this.isInitial()){return;}if(i>=this.getLength()){return undefined;}return this.findNode(i);};
f.prototype.findNode=function(p){if(this.isInitial()){return;}var P=typeof p;var F;var s=[];if(P==="number"){F=this._aRowIndexMap[p];if(!F){var i=-1;this._match(this._oRootNode,s,1,function(n){if(i===p){return true;}i+=1;});F=s[0];}}return F;};
f.prototype._createTreeState=function(r){if(!this._mTreeState||r){this._mTreeState={expanded:{},collapsed:{},selected:{},deselected:{}};}};
f.prototype._updateTreeState=function(p){p=p||{};var t=p.expanded?this._mTreeState.expanded:this._mTreeState.collapsed;var s=p.expanded?this._mTreeState.collapsed:this._mTreeState.expanded;var n=this._getNodeState(p.groupID);if(!n){n=p.fallbackNodeState||this._createNodeState({groupID:p.groupID,expanded:p.expanded,sum:p.sum});}delete s[p.groupID];t[p.groupID]=n;n.expanded=p.expanded;return n;};
f.prototype._createNodeState=function(p){if(!p.groupID){return;}var i;var I;if(this._oInitialTreeState){i=this._oInitialTreeState._isExpanded(p.groupID);I=this._oInitialTreeState._isCollapsed(p.groupID);this._oInitialTreeState._remove(p.groupID);}var b=p.expanded||i||false;var a=p.selected||false;var n={groupID:p.groupID,expanded:b,sections:p.sections||[{startIndex:0,length:this._iPageSize}],sum:p.sum||false,selected:a};if(i||I){this._updateTreeState({groupID:p.groupID,fallbackNodeState:n,expanded:i,collapsed:I});}return n;};
f.prototype._getNodeState=function(g){var E=this._mTreeState.expanded[g];var o=this._mTreeState.collapsed[g];var s=this._mTreeState.selected[g];var D=this._mTreeState.deselected[g];return E||o||s||D;};
f.prototype._updateNodeSections=function(g,n){var N=this._getNodeState(g);if(!N){return;}else if(!n){return;}else if(n.length<=0){return;}else if(n.startIndex<0){return;}N.sections=e.mergeSections(N.sections,n);return N.sections;};
f.prototype._increaseSections=function(){var I=function(n){if(!n){return;}var m=this._getMaxGroupSize(n);var N=n.nodeState;if(m===undefined){var a=[];for(var i=0;i<N.sections.length;i++){var o=N.sections[i];o.length=Math.max(o.length,this._iPageSize);a=e.mergeSections(a,o);}N.sections=a;}};this._map(this._oRootNode,I);};
f.prototype._getMaxGroupSize=function(n){var m=0;if(n.isArtificial){var i=this.oModel.isList(this.sPath,this.getContext());if(this.bDisplayRootNode&&!i&&!this._bRootMissing){m=1;}else{m=this._getGroupSize(n)||0;}}else{m=this.nodeHasChildren(n)?this._getGroupSize(n):0;}return m;};
f.prototype.getContexts=function(s,l,t,r){if(this.isInitial()){return[];}if(!l){l=this.oModel.iSizeLimit;}if(!t){t=0;}if(l>this._iPageSize){this._iPageSize=l;this._increaseSections();}this._iThreshold=Math.max(this._iThreshold,t);this._aRowIndexMap=[];this._buildTree(s,l);var n=[];if(this._oRootNode){n=this._retrieveNodeSection(this._oRootNode,s,l);}this._updateRowIndexMap(n,s);var a=[];var m;for(var i=0;i<n.length;i++){var N=n[i];if(!N.context){m=m||{};var p=N.parent;m[p.groupID]=p;this._updateNodeSections(p.groupID,{startIndex:N.positionInParent,length:1});}a.push(N.context);}if(m){var b=this;q.each(m,function(g,N){N.magnitude=0;N.numberOfTotals=0;b._loadChildContexts(N);});a=[];for(var j=0;j<n.length;j++){var N=n[j];a.push(N.context);}}if(r){return n;}else{return a;}};
f.prototype.getNodes=function(s,l,t){return this.getContexts(s,l,t,true);};
f.prototype._updateRowIndexMap=function(n,s){this._aRowIndexMap=[];for(var i=0;i<n.length;i++){this._aRowIndexMap[s+i]=n[i];}};
f.prototype._retrieveNodeSection=function(n,s,l){var N=-1;var a=[];this._match(this._oRootNode,[],l,function(n,p,P){if(!n||!n.isArtificial){N++;}if(N>=s&&N<s+l){if(!n){n=this._createNode({parent:P,positionInParent:p});P.children[p]=n;}a.push(n);return true;}});return a;};
f.prototype._buildTree=function(s,l){this._oRootNode=undefined;var r=null;var R=this._calculateGroupID({context:r,parent:null});var o=this._getNodeState(R);if(!o){var o=this._createNodeState({groupID:R,sum:true,sections:[{startIndex:s,length:l}]});this._updateTreeState({groupID:o.groupID,fallbackNodeState:o,expanded:true});}this._oRootNode=this._createNode({context:r,parent:null,level:this.bDisplayRootNode&&!(r===null)?0:-1,nodeState:o,isLeaf:false,autoExpand:this.getNumberOfExpandedLevels()+1});this._oRootNode.isArtificial=true;if(this._mTreeState.expanded[this._oRootNode.groupID]){this._loadChildContexts(this._oRootNode);}};
f.prototype._calculateRequestLength=function(m,s){var r;if(!m){r=s.length;}else{r=Math.max(Math.min(s.length,m-s.startIndex),0);}return r;};
f.prototype._loadChildContexts=function(n){var N=n.nodeState;var m=this._getMaxGroupSize(n);if(m>0){if(!n.children[m-1]){n.children[m-1]=undefined;}N.leafCount=m;}if(this.bClientOperation){N.sections=[{startIndex:0,length:m}];}for(var i=0;i<N.sections.length;i++){var o=N.sections[i];var r=this._calculateRequestLength(m,o);if(n.autoExpand>=0&&this._autoExpandMode===c.Bundled){r=Math.max(0,m);}var a;if(n.isArtificial){a=this.getRootContexts(o.startIndex,r,this._iThreshold);}else{a=this.nodeHasChildren(n)?this.getNodeContexts(n.context,o.startIndex,r,this._iThreshold):[];}for(var j=0;j<a.length;j++){var b=a[j];if(!b){continue;}var g=j+o.startIndex;var h=n.children[g];var u={context:a[j],parent:n,level:n.level+1,positionInParent:g,autoExpand:Math.max(n.autoExpand-1,-1)};if(h){h.context=u.context;h.parent=u.parent;h.level=u.level;h.positionInParent=u.positionInParent;h.magnitude=0;h.numberOfTotals=0;h.autoExpand=u.autoExpand;var G;if(b){G=this._calculateGroupID(h);}h.groupID=G;}else{h=this._createNode(u);}h.nodeState=this._getNodeState(h.groupID);if(!h.nodeState){h.nodeState=this._createNodeState({groupID:h.groupID,expanded:false});}h.nodeState.parentGroupID=n.groupID;h.isLeaf=!this.nodeHasChildren(h);n.children[g]=h;if(h.isLeaf){n.numberOfLeafs+=1;}if(h.parent.nodeState.selectAllMode&&!this._mTreeState.deselected[h.groupID]){this.setNodeSelection(h.nodeState,true);}if((h.autoExpand>0||h.nodeState.expanded)&&this.isGrouped()){if(!this._mTreeState.collapsed[h.groupID]&&!h.isLeaf){this._updateTreeState({groupID:h.nodeState.groupID,fallbackNodeState:h.nodeState,expanded:true});this._loadChildContexts(h);}n.magnitude+=Math.max(h.magnitude||0,0);n.numberOfLeafs+=h.numberOfLeafs;}}}n.magnitude+=Math.max(m||0,0);};
f.prototype.isGrouped=function(){return true;};
f.prototype._calculateGroupID=function(n){q.sap.log.error("TreeBindingAdapter#_calculateGroupID: Not implemented. Needs to be implemented in respective sub-classes.");};
f.prototype._createNode=function(p){p=p||{};var o=p.context;var l=p.level||0;var n={context:o,level:l,children:p.children||[],parent:p.parent,nodeState:p.nodeState,isLeaf:p.isLeaf||false,positionInParent:p.positionInParent,magnitude:p.magnitude||0,numberOfTotals:p.numberOfTotals||0,numberOfLeafs:p.numberOfLeafs||0,autoExpand:p.autoExpand||0,absoluteNodeIndex:p.absoluteNodeIndex||0,totalNumberOfLeafs:0};if(o!==undefined){n.groupID=this._calculateGroupID(n);}return n;};
f.prototype.expand=function(i){var n=this.findNode(i);if(!n){return;}this._updateTreeState({groupID:n.nodeState.groupID,fallbackNodeState:n.nodeState,expanded:true});this._fireChange({reason:d.Expand});};
f.prototype.expandToLevel=function(l){this._mTreeState.collapsed={};this.setNumberOfExpandedLevels(l);this._fireChange({reason:d.Expand});};
f.prototype.isExpanded=function(i){var n=this.findNode(i);return n&&n.nodeState?n.nodeState.expanded:false;};
f.prototype.collapse=function(p,s){var n;var t=this;if(typeof p==="object"){n=p;}else if(typeof p==="number"){var N=this.findNode(p);if(!N){return;}n=N.nodeState;}this._updateTreeState({groupID:n.groupID,fallbackNodeState:n,expanded:false});n.selectAllMode=false;if(this.bCollapseRecursive){var g=n.groupID;q.each(this._mTreeState.expanded,function(G,o){if(q.sap.startsWith(G,g)){t._updateTreeState({groupID:G,expanded:false});}});var D=[];q.each(this._mTreeState.selected,function(G,o){if(q.sap.startsWith(G,g)&&G!==g){o.selectAllMode=false;t.setNodeSelection(o,false);D.push(G);}});if(D.length){var a={rowIndices:[]};var i=0;this._map(this._oRootNode,function(N){if(!N||!N.isArtificial){i++;}if(N&&D.indexOf(N.groupID)!==-1){if(N.groupID===this._sLeadSelectionGroupID){a.oldIndex=i;a.leadIndex=-1;}a.rowIndices.push(i);}});this._publishSelectionChanges(a);}}if(!s){this._fireChange({reason:d.Collapse});}};
f.prototype.collapseToLevel=function(l){if(!l||l<0){l=0;}var t=this;q.each(this._mTreeState.expanded,function(g,n){var N=t._getGroupIdLevel(g)-1;if(N===l){t.collapse(n,true);}});this._fireChange({reason:d.Collapse});};
f.prototype._map=function(n,m){m.call(this,n);if(!n){return;}for(var i=0;i<n.children.length;i++){var o=n.children[i];this._map(o,m);}if(this._afterMapHook){this._afterMapHook(n,m);}};
f.prototype._match=function(n,r,m,M,p,P){if(r.length===m){return true;}var N=M.call(this,n,p,P);if(N){r.push(n);}if(!n){return false;}for(var i=0;i<n.children.length;i++){var o=n.children[i];var b=this._match(o,r,m,M,i,n);if(b){return true;}}return this._afterMatchHook?this._afterMatchHook(n,r,m,M,p,P):false;};
f.prototype.toggleIndex=function(i){var n=this.findNode(i);if(!n){return;}if(n.nodeState.expanded){this.collapse(i);}else{this.expand(i);}};
f.prototype._getGroupIdLevel=function(g){if(g==null){q.sap.log.warning("assertion failed: no need to determine level of group ID = null");return-1;}return g.split("/").length-2;};
f.prototype._getGroupSize=function(n){return this.getChildCount(n.context);};
f.prototype.setNodeSelection=function(n,i){if(!n.groupID){return;}n.selected=i;if(i){this._mTreeState.selected[n.groupID]=n;delete this._mTreeState.deselected[n.groupID];}else{delete this._mTreeState.selected[n.groupID];this._mTreeState.deselected[n.groupID]=n;}};
f.prototype.isIndexSelected=function(r){var n=this.getNodeByIndex(r);return n&&n.nodeState?n.nodeState.selected:false;};
f.prototype.isIndexSelectable=function(r){var n=this.getNodeByIndex(r);return this._isNodeSelectable(n);};
f.prototype._isNodeSelectable=function(n){return!!n&&!n.isArtificial;};
f.prototype.setSelectedIndex=function(r){var n=this.findNode(r);if(n&&this._isNodeSelectable(n)){var o=this._clearSelection();var i=o.rowIndices.indexOf(r);if(i>=0){o.rowIndices.splice(i,1);}else{o.rowIndices.push(r);}o.leadGroupID=n.groupID;o.leadIndex=r;this.setNodeSelection(n.nodeState,true);this._publishSelectionChanges(o);}else{q.sap.log.warning("TreeBindingAdapter: The selection was ignored. Please make sure to only select rows, for which data has been fetched to the client. For AnalyticalTables, some rows might not be selectable at all.");}};
f.prototype.getSelectedIndex=function(){if(!this._sLeadSelectionGroupID||q.isEmptyObject(this._mTreeState.selected)){return-1;}var n=-1;var m=function(N){if(!N||!N.isArtificial){n++;}if(N){if(N.groupID===this._sLeadSelectionGroupID){return true;}}};this._match(this._oRootNode,[],1,m);return n;};
f.prototype.getSelectedIndices=function(){var r=[];var t=this;if(q.isEmptyObject(this._mTreeState.selected)){return r;}var n=Object.keys(this._mTreeState.selected).length;var N=-1;var m=function(o){if(!o||!o.isArtificial){N++;}if(o){if(o.nodeState&&o.nodeState.selected&&!o.isArtificial){r.push(N);t._aRowIndexMap[N]=o;return true;}}};this._match(this._oRootNode,[],n,m);return r;};
f.prototype.getSelectedNodesCount=function(){var s;if(this._oRootNode&&this._oRootNode.nodeState.selectAllMode){var g,v,p,G;var o,V=[];if(this.filterInfo&&this.aAllFilters){for(var i=this.filterInfo.aFilteredContexts.length-1;i>=0;i--){o=this.filterInfo.aFilteredContexts[i];V.push(this._calculateGroupID({context:o}));}}v=0;for(g in this._mTreeState.expanded){if(!this.aAllFilters||V.indexOf(g)!==-1){G=this._mTreeState.expanded[g];if(!G.selectAllMode&&G.leafCount!==undefined){v+=G.leafCount;}}}for(g in this._mTreeState.selected){if(!this.aAllFilters||V.indexOf(g)!==-1){G=this._mTreeState.selected[g];p=this._mTreeState.expanded[G.parentGroupID];if(p&&!p.selectAllMode){v--;}}}for(g in this._mTreeState.deselected){if(!this.aAllFilters||V.indexOf(g)!==-1){G=this._mTreeState.deselected[g];p=this._mTreeState.expanded[G.parentGroupID];if(p&&p.selectAllMode){v++;}}}s=this._getSelectableNodesCount(this._oRootNode)-v;}else{s=Object.keys(this._mTreeState.selected).length;}return s;};
f.prototype._getSelectableNodesCount=function(n){if(n){return n.magnitude;}else{return 0;}};
f.prototype.getSelectedContexts=function(){var r=[];var t=this;if(q.isEmptyObject(this._mTreeState.selected)){return r;}var n=Object.keys(this._mTreeState.selected).length;var N=-1;var m=function(o){if(!o||!o.isArtificial){N++;}if(o){if(o.nodeState&&o.nodeState.selected&&!o.isArtificial){r.push(o.context);t._aRowIndexMap[N]=o;return true;}}};this._match(this._oRootNode,[],n,m);return r;};
f.prototype.setSelectionInterval=function(F,t){var m=this._clearSelection();var s=this._setSelectionInterval(F,t,true);var I={};var r=[];for(var i=0;i<m.rowIndices.length;i++){var a=m.rowIndices[i];I[a]=true;}for(i=0;i<s.rowIndices.length;i++){a=s.rowIndices[i];if(I[a]){delete I[a];}else{I[a]=true;}}for(a in I){if(I[a]){r.push(parseInt(a,10));}}this._publishSelectionChanges({rowIndices:r,oldIndex:m.oldIndex,leadIndex:s.leadIndex,leadGroupID:s.leadGroupID});};
f.prototype._setSelectionInterval=function(F,t,s){var n=Math.min(F,t);var N=Math.max(F,t);var a=[];var b=[];var i=Math.abs(N-n)+1;var o;var g=-1;var m=function(h){if(!h||!h.isArtificial){g++;}if(h){if(g>=n&&g<=N){if(this._isNodeSelectable(h)){if(h.nodeState.selected!==!!s){b.push(g);}if(h.groupID===this._sLeadSelectionGroupID){o=g;}this.setNodeSelection(h.nodeState,!!s);}return true;}}};this._match(this._oRootNode,a,i,m);var p={rowIndices:b,oldIndex:o,leadIndex:o&&!s?-1:undefined};if(a.length>0&&s){var l=a[a.length-1];p.leadGroupID=l.groupID;p.leadIndex=N;}return p;};
f.prototype.addSelectionInterval=function(F,t){var p=this._setSelectionInterval(F,t,true);this._publishSelectionChanges(p);};
f.prototype.removeSelectionInterval=function(F,t){var p=this._setSelectionInterval(F,t,false);this._publishSelectionChanges(p);};
f.prototype.selectAll=function(){this._mTreeState.deselected={};var p={rowIndices:[],oldIndex:-1,selectAll:true};var n=-1;this._map(this._oRootNode,function(N){if(!N||!N.isArtificial){n++;}if(N){if(N.groupID===this._sLeadSelectionGroupID){p.oldIndex=n;}if(this._isNodeSelectable(N)){if(N.nodeState.selected!==true){p.rowIndices.push(n);}this.setNodeSelection(N.nodeState,true);p.leadGroupID=N.groupID;p.leadIndex=n;}if(N.nodeState.expanded){N.nodeState.selectAllMode=true;}}});this._publishSelectionChanges(p);};
f.prototype._clearSelection=function(){var n=-1;var o=-1;var m=0;var a=[];for(var g in this._mTreeState.selected){if(g){m++;}}var M=function(N){if(!N||!N.isArtificial){n++;}if(N){N.nodeState.selectAllMode=false;if(this._mTreeState.selected[N.groupID]){if(!N.isArtificial){a.push(n);}this.setNodeSelection(N.nodeState,false);if(N.groupID===this._sLeadSelectionGroupID){o=n;}return true;}}};this._match(this._oRootNode,[],m,M);if(this._oRootNode&&this._oRootNode.nodeState&&this._oRootNode.isArtificial){this._oRootNode.nodeState.selectAllMode=false;}return{rowIndices:a,oldIndex:o,leadIndex:-1};};
f.prototype.clearSelection=function(s){var o=this._clearSelection();if(!s){this._publishSelectionChanges(o);}};
f.prototype._publishSelectionChanges=function(p){p.oldIndex=p.oldIndex||this.getSelectedIndex();p.rowIndices.sort(function(a,b){return a-b;});if(p.leadIndex>=0&&p.leadGroupID){this._sLeadSelectionGroupID=p.leadGroupID;}else if(p.leadIndex===-1){this._sLeadSelectionGroupID=undefined;}else{p.leadIndex=p.oldIndex;}if(p.rowIndices.length>0||(p.leadIndex!=undefined&&p.leadIndex!==-1)){this.fireSelectionChanged(p);}};
f.prototype.setCollapseRecursive=function(b){this.bCollapseRecursive=!!b;};
f.prototype.getCollapseRecursive=function(){return this.bCollapseRecursive;};
f.prototype.attachSelectionChanged=function(D,F,l){this.attachEvent("selectionChanged",D,F,l);return this;};
f.prototype.detachSelectionChanged=function(F,l){this.detachEvent("selectionChanged",F,l);return this;};
f.prototype.fireSelectionChanged=function(a){this.fireEvent("selectionChanged",a);return this;};
return f;},true);
sap.ui.predefine('sap/ui/model/TreeBindingCompatibilityAdapter',['jquery.sap.global','sap/ui/model/TreeBinding','sap/ui/model/ClientTreeBinding','sap/ui/model/ChangeReason','sap/ui/model/TreeBindingUtils'],function(q,T,C,a,b){"use strict";var c=function(B,t){var d=t;q.extend(B,{_init:function(e){this._bExpandFirstLevel=e;this.mContextInfo={};this._initContexts();if(e&&!this._bFirstLevelExpanded){this._expandFirstLevel();}},_initContexts:function(s){this.aContexts=this.getRootContexts(0,Number.MAX_VALUE);for(var i=0,l=this.aContexts.length;i<l;i++){var o=this._getContextInfo(this.aContexts[i]);this._setContextInfo({oContext:this.aContexts[i],iLevel:0,bExpanded:o?o.bExpanded:false});}if(this._bExpandFirstLevel&&!this._bFirstLevelExpanded){this._expandFirstLevel(s);}},_expandFirstLevel:function(s){var d=this;if(this.aContexts&&this.aContexts.length>0){q.each(this.aContexts.slice(),function(i,o){if(!s){d._loadChildContexts(o);}d._getContextInfo(o).bExpanded=true;});this._bFirstLevelExpanded=true;}},_fnFireFilter:B._fireFilter,_fireFilter:function(){this._fnFireFilter.apply(this,arguments);this._initContexts(true);this._restoreContexts(this.aContexts);},_fnFireChange:B._fireChange,_fireChange:function(){this._fnFireChange.apply(this,arguments);this._initContexts(true);this._restoreContexts(this.aContexts);},_restoreContexts:function(e){var d=this;var n=[];q.each(e.slice(),function(i,o){var f=d._getContextInfo(o);if(f&&f.bExpanded){n.push.apply(n,d._loadChildContexts(o));}});if(n.length>0){this._restoreContexts(n);}},_loadChildContexts:function(o){var e=this._getContextInfo(o);var I=q.inArray(o,this.aContexts);var n=this.getNodeContexts(o,0,Number.MAX_VALUE);for(var i=0,l=n.length;i<l;i++){this.aContexts.splice(I+i+1,0,n[i]);var f=this._getContextInfo(n[i]);this._setContextInfo({oParentContext:o,oContext:n[i],iLevel:e.iLevel+1,bExpanded:f?f.bExpanded:false});}return n;},_getContextInfo:function(o){return o?this.mContextInfo[o.getPath()]:undefined;},_setContextInfo:function(D){if(D&&D.oContext){this.mContextInfo[D.oContext.getPath()]=D;}},getLength:function(){return this.aContexts?this.aContexts.length:0;},getContexts:function(s,l){return this.aContexts.slice(s,s+l);},getNodes:function(s,l){var e=this.getContexts(s,s+l);var n=[];for(var i=0;i<e.length;i++){var o=this._getContextInfo(e[i])||{};var f=e[i];n.push({context:f,level:o.iLevel,parent:o.oParentContext,nodeState:{expanded:o.bExpanded,collapsed:!o.bExpanded,selected:false}});}return n;},hasChildren:function(){return true;},nodeHasChildren:function(){return true;},getContextByIndex:function(r){return this.aContexts[r];},getLevel:function(o){var e=this._getContextInfo(o);return e?e.iLevel:-1;},isExpanded:function(r){var o=this.getContextByIndex(r);var e=this._getContextInfo(o);return e?e.bExpanded:false;},expandContext:function(o){var e=this._getContextInfo(o);if(e&&!e.bExpanded){this.storeSelection();this._loadChildContexts(o);e.bExpanded=true;this._fireChange();this.restoreSelection();}},expand:function(r){this.expandContext(this.getContextByIndex(r));},collapseContext:function(o,s){var e=this._getContextInfo(o);if(e&&e.bExpanded){this.storeSelection();for(var i=this.aContexts.length-1;i>0;i--){if(this._getContextInfo(this.aContexts[i]).oParentContext===o){this.aContexts.splice(i,1);}}e.bExpanded=false;if(!s){this._fireChange();}this.restoreSelection();}},collapse:function(r){this.collapseContext(this.getContextByIndex(r));},collapseToLevel:function(l){if(!l||l<0){l=0;}var e=this.aContexts.slice();for(var i=e.length-1;i>=0;i--){var f=this.getLevel(e[i]);if(f!=-1&&f>=l){this.collapseContext(e[i],true);}}this._fireChange();},toggleContext:function(o){var e=this._getContextInfo(o);if(e){if(e.bExpanded){this.collapseContext(o);}else{this.expandContext(o);}}},toggleIndex:function(r){this.toggleContext(this.getContextByIndex(r));},storeSelection:function(){var s=d.getSelectedIndices();var S=[];q.each(s,function(i,v){S.push(d.getContextByIndex(v));});this._aSelectedContexts=S;},restoreSelection:function(){d.clearSelection();var _=this._aSelectedContexts;q.each(this.aContexts,function(i,o){if(q.inArray(o,_)>=0){d.addSelectionInterval(i,i);}});this._aSelectedContexts=undefined;},attachSelectionChanged:function(){return undefined;},clearSelection:function(){d._oSelection.clearSelection();},attachSort:function(){},detachSort:function(){}});B._init(t.getExpandFirstLevel());};return c;},true);
sap.ui.predefine('sap/ui/model/TreeBindingUtils',function(){"use strict";var T=function(){};
T.mergeSections=function(s,n){var N=[];for(var i=0;i<s.length;i++){var c=s[i];var C=c.startIndex+c.length;var a=n.startIndex+n.length;if(n.startIndex<=C&&a>=C&&n.startIndex>=c.startIndex){n.startIndex=c.startIndex;n.length=a-c.startIndex;}else if(n.startIndex<=c.startIndex&&a>=c.startIndex&&a<=C){n.length=C-n.startIndex;}else if(n.startIndex>=c.startIndex&&a<=C){n.startIndex=c.startIndex;n.length=c.length;}else if(a<c.startIndex||n.startIndex>C){N.push(c);}}N.push(n);return N;};
T._determineRequestDelta=function(n,p){var N=n.iSkip+n.iTop;var P=p.iSkip+p.iTop;if(n.iSkip===p.iSkip&&n.iTop===p.iTop){return false;}else if(n.iSkip<p.iSkip&&N>p.iSkip&&N<=P){n.iTop=p.iSkip-n.iSkip;if(n.iThreshold){n.iTop=n.iTop+n.iThreshold;n.iSkip=n.iSkip-n.iThreshold;}}else if(n.iSkip<P&&N>P&&n.iSkip>=p.iSkip){n.iSkip=P;n.iTop=N-n.iSkip;if(n.iThreshold){n.iTop+=n.iThreshold;}}else if(n.iSkip>=p.iSkip&&N<=P){return false;}else if(n.iSkip<=p.iSkip&&N>=P){p.oRequestHandle.abort();}else if(N<=p.iSkip||n.iSkip>=P){}};
return T;});
sap.ui.predefine('sap/ui/model/analytics/AnalyticalBinding',['jquery.sap.global','sap/ui/model/TreeBinding','sap/ui/model/ChangeReason','sap/ui/model/Filter','sap/ui/model/FilterOperator','sap/ui/model/FilterType','sap/ui/model/Sorter','sap/ui/model/odata/CountMode','./odata4analytics','./BatchResponseCollector','./AnalyticalVersionInfo'],function(Q,T,C,F,a,b,S,c,d,B,A){"use strict";
var f=T.extend("sap.ui.model.analytics.AnalyticalBinding",{constructor:function(m,p,o,s,e,P){T.call(this,m,p,o,e,P);this.sEntitySetName=(P&&P.entitySet)?P.entitySet:undefined;this.bArtificalRootContext=false;this.aApplicationFilter=this._convertDeprecatedFilterObjects(e);this.aControlFilter=undefined;this.aSorter=s?s:[];this.aMaxAggregationLevel=[];this.aAggregationLevel=[];this.oPendingRequests={};this.oPendingRequestHandle=[];this.oGroupedRequests={};this.bUseBatchRequests=(P&&P.useBatchRequests===true)?true:false;this.bProvideTotalSize=(P&&P.provideTotalResultSize===false)?false:true;this.bProvideGrandTotals=(P&&P.provideGrandTotals===false)?false:true;this.bReloadSingleUnitMeasures=(P&&P.reloadSingleUnitMeasures===false)?false:true;this.bUseAcceleratedAutoExpand=(P&&P.useAcceleratedAutoExpand===false)?false:true;this.bNoPaging=(P&&P.noPaging===true)?true:false;this.iTotalSize=-1;this.mServiceKey={};this.mServiceLength={};this.mServiceFinalLength={};this.mKeyIndex={};this.mFinalLength=this.mServiceFinalLength;this.mLength={};this.mMultiUnitKey={};this.aMultiUnitLoadFactor={};this.bNeedsUpdate=false;this.mEntityKey={};this.sCustomParams=this.oModel.createCustomParams({custom:this.mParameters.custom});this.oAnalyticalQueryResult=null;this.aAnalyticalInfo=[];this.mAnalyticalInfoByProperty={};this.aBatchRequestQueue=[];if(P&&P.countMode==c.None){Q.sap.log.fatal("requested count mode is ignored; OData requests will include $inlinecout options");}else if(P&&(P.countMode==c.Request||P.countMode==c.Both)){Q.sap.log.warning("default count mode is ignored; OData requests will include $inlinecout options");}else if(this.oModel.sDefaultCountMode==c.Request){Q.sap.log.warning("default count mode is ignored; OData requests will include $inlinecout options");}this.iModelVersion=A.getVersion(this.oModel);if(this.iModelVersion===null){Q.sap.log.error("The AnalyticalBinding does not support Models other than sap.ui.model.odata.ODataModel version 1 or 2.");return;}this.aAllDimensionSortedByName=null;this.aInitialAnalyticalInfo=(P==undefined?[]:P.analyticalInfo);this.bInitial=true;}});
function t(o,e){return function(){if(!o.__supportUID){o.__supportUID=Q.sap.uid();}return{type:"sap.ui.model.analytics.AnalyticalBinding",analyticalError:e,analyticalBindingId:o.__supportUID};};}
f.prototype.setContext=function(o){if(this.oContext!==o){this.oContext=o;this.oDataState=null;if(!this.isRelative()){return;}var r=this.oModel.resolve(this.sPath,this.oContext);if(r){this.resetData();this._initialize();this._fireChange({reason:C.Context});}}};
f.prototype.initialize=function(){if(this.oModel.oMetadata&&this.oModel.oMetadata.isLoaded()&&this.isInitial()){var i=this.isRelative();if(!i||(i&&this.oContext)){this._initialize();}this._fireRefresh({reason:C.Refresh});}return this;};
f.prototype._initialize=function(){if(this.oModel.oMetadata&&this.oModel.oMetadata.isLoaded()){this.bInitial=false;this.oAnalyticalQueryResult=this.oModel.getAnalyticalExtensions().findQueryResultByName(this._getEntitySet());if(!this.oAnalyticalQueryResult){throw("Error in AnalyticalBinding - The QueryResult '"+this._getEntitySet()+"' could not be retrieved. Please check your service definition.");}this.updateAnalyticalInfo(this.aInitialAnalyticalInfo);this.aAllDimensionSortedByName=this.oAnalyticalQueryResult.getAllDimensionNames().concat([]).sort();this._fireRefresh({reason:C.Refresh});}};
f.prototype.getRootContexts=function(p){if(this.isInitial()){return[];}var i=(p&&p.numberOfExpandedLevels?p.numberOfExpandedLevels+1:1);var r=null;var R=this._getRequestId(f._requestType.groupMembersQuery,{groupId:null});if(this.bArtificalRootContext&&!this._cleanupGroupingForCompletedRequest(R)){return r;}r=this._getContextsForParentContext(null);if(r.length==1){return r;}if(i<=1){if(i==1){this._considerRequestGrouping([R,this._getRequestId(f._requestType.groupMembersQuery,{groupId:"/"})]);this.getNodeContexts(this.getModel().getContext("/"),{startIndex:p.startIndex,length:p.length,threshold:p.threshold,level:0,numberOfExpandedLevels:0});}}else{var e=this._prepareGroupMembersAutoExpansionRequestIds("/",p.numberOfExpandedLevels);e.push(R);this._considerRequestGrouping(e);this.getNodeContexts(this.getModel().getContext("/"),{startIndex:p.startIndex,length:p.length,threshold:p.threshold,level:0,numberOfExpandedLevels:p.numberOfExpandedLevels});}if(r.length>1){Q.sap.log.fatal("assertion failed: grand total represented by a single entry");}return r;};
f.prototype.getNodeContexts=function(o,p){if(this.isInitial()){return[];}var s,l,i,L,n,e;if(typeof p=="object"){s=p.startIndex;l=p.length;i=p.threshold;L=p.level;n=p.numberOfExpandedLevels;e=p.supressRequest;}else{s=arguments[1];l=arguments[2];i=arguments[3];L=arguments[4];n=arguments[5];e=arguments[6];}var g=this._getContextsForParentContext(o,s,l,i,L,n,e);return g;};
f.prototype.ContextsAvailabilityStatus={ALL:2,SOME:1,NONE:0};
f.prototype.hasAvailableNodeContexts=function(o,l){var g=this._getGroupIdFromContext(o,l);if(this._getKeys(g)!=undefined){if(this.mFinalLength[g]==true){return f.prototype.ContextsAvailabilityStatus.ALL;}else{return f.prototype.ContextsAvailabilityStatus.SOME;}}else{return f.prototype.ContextsAvailabilityStatus.NONE;}};
f.prototype.getGroupSize=function(o,l){if(o===undefined){return 0;}var g=this._getGroupIdFromContext(o,l);return this.mFinalLength[g]?this.mLength[g]:-1;};
f.prototype.getTotalSize=function(){if(!this.bProvideTotalSize){Q.sap.log.fatal("total size of result explicitly turned off, but getter invoked");}return+this.iTotalSize;};
f.prototype.hasChildren=function(o,p){if(o===undefined){return false;}if(o==null){return true;}var i=p.level;if(i==0){return true;}if(this.aAggregationLevel.length<i){return false;}return Q.inArray(this.aAggregationLevel[i-1],this.aMaxAggregationLevel)<this.aMaxAggregationLevel.length-1;};
f.prototype.hasMeasures=function(){var h=false;for(var p in this.oMeasureDetailsSet){if(this.oMeasureDetailsSet.hasOwnProperty(p)){h=true;break;}}return h;};
f.prototype.getDimensionDetails=function(){return this.oDimensionDetailsSet;};
f.prototype.getMeasureDetails=function(){return this.oMeasureDetailsSet;};
f.prototype.providesGrandTotal=function(){return this.bProvideGrandTotals;};
f.prototype.getProperty=function(p){if(this.isInitial()){return{};}return this.oAnalyticalQueryResult.getEntityType().findPropertyByName(p);};
f.prototype.getFilterablePropertyNames=function(){if(this.isInitial()){return[];}return this.oAnalyticalQueryResult.getEntityType().getFilterablePropertyNames();};
f.prototype.getSortablePropertyNames=function(){if(this.isInitial()){return[];}return this.oAnalyticalQueryResult.getEntityType().getSortablePropertyNames();};
f.prototype.getPropertyLabel=function(p){if(this.isInitial()){return"";}return this.oAnalyticalQueryResult.getEntityType().getLabelOfProperty(p);};
f.prototype.getPropertyHeading=function(p){if(this.isInitial()){return"";}return this.oAnalyticalQueryResult.getEntityType().getHeadingOfProperty(p);};
f.prototype.getPropertyQuickInfo=function(p){if(this.isInitial()){return"";}return this.oAnalyticalQueryResult.getEntityType().getQuickInfoOfProperty(p);};
f.prototype.isMeasure=function(p){return Q.inArray(p,this.aMeasureName)!==-1;};
f.prototype.filter=function(e,s){if(!e){e=[];}if(e instanceof F){e=[e];}e=this._convertDeprecatedFilterObjects(e);if(s==b.Application){this.aApplicationFilter=e;}else{this.aControlFilter=e;}this.iTotalSize=-1;this._abortAllPendingRequests();this.resetData();this._fireRefresh({reason:C.Filter});return this;};
f.prototype.sort=function(s){if(s instanceof S){s=[s];}this.aSorter=s?s:[];this._abortAllPendingRequests();this.resetData(undefined,{reason:C.Sort});this._fireRefresh({reason:C.Sort});return this;};
f.prototype.getGroupName=function(o,l){if(o===undefined){return"";}var g=this.aAggregationLevel[l-1],D=this.oAnalyticalQueryResult.findDimensionByPropertyName(g),v=this.mAnalyticalInfoByProperty[g]&&this.mAnalyticalInfoByProperty[g].formatter,p=o.getProperty(g),e,s,G;if(D&&this.oDimensionDetailsSet[g].textPropertyName){e=D.getTextProperty();}var h,i,j;if(e){h=D.getTextProperty().name;j=this.mAnalyticalInfoByProperty[h]&&this.mAnalyticalInfoByProperty[h].formatter;i=o.getProperty(h);}if(!e){s=v?v(p):p;G=((D.getLabelText())?D.getLabelText()+': ':'')+s;}else{s=v?v(p,i):p;G=((D.getLabelText())?D.getLabelText()+': ':'')+s;var k=j?j(i,p):i;if(k){G+=' - '+k;}}return G;};
f.prototype.updateAnalyticalInfo=function(e,g){if(!this.oModel.oMetadata||!this.oModel.oMetadata.isLoaded()||this.isInitial()){this.aInitialAnalyticalInfo=e;return;}if(Q.sap.equal(this._aLastChangedAnalyticalInfo,e)){if(g){setTimeout(function(){this._fireChange({reason:C.Change});}.bind(this),0);}return;}this._aLastChangedAnalyticalInfo=[];for(var j=0;j<e.length;j++){this._aLastChangedAnalyticalInfo[j]=Q.extend({},e[j]);}var p=this.oDimensionDetailsSet;this.mAnalyticalInfoByProperty={};this.aMaxAggregationLevel=[];this.aAggregationLevel=[];this.aMeasureName=[];if(this.iAnalyticalInfoVersionNumber==undefined){this.iAnalyticalInfoVersionNumber=1;}else if(this.iAnalyticalInfoVersionNumber>999){this.iAnalyticalInfoVersionNumber=1;}else{this.iAnalyticalInfoVersionNumber=this.iAnalyticalInfoVersionNumber+1;}this.oMeasureDetailsSet={};this.oDimensionDetailsSet={};for(var i=0;i<e.length;i++){var D=this.oAnalyticalQueryResult.findDimensionByPropertyName(e[i].name);if(D&&(e[i].inResult==true||e[i].visible==true)){e[i].dimensionPropertyName=D.getName();var o=this.oDimensionDetailsSet[D.getName()];if(!o){o={};o.name=D.getName();o.aAttributeName=[];o.grouped=false;this.oDimensionDetailsSet[D.getName()]=o;this.aMaxAggregationLevel.push(o.name);if(e[i].grouped==true){this.aAggregationLevel.push(o.name);}}if(e[i].grouped==true){if(Q.inArray(D.getName(),this.getSortablePropertyNames())==-1){Q.sap.log.fatal("property "+D.getName()+" must be sortable in order to be used as grouped dimension");}o.grouped=true;}if(D.getName()==e[i].name){o.keyPropertyName=e[i].name;}var h=D.getTextProperty();if(h&&h.name==e[i].name){o.textPropertyName=e[i].name;}if(D.findAttributeByName(e[i].name)){o.aAttributeName.push(e[i].name);}o.analyticalInfo=e[i];}var m=this.oAnalyticalQueryResult.findMeasureByPropertyName(e[i].name);if(m&&(e[i].inResult==true||e[i].visible==true)){e[i].measurePropertyName=m.getName();var M=this.oMeasureDetailsSet[m.getName()];if(!M){M={};M.name=m.getName();this.oMeasureDetailsSet[m.getName()]=M;this.aMeasureName.push(M.name);}if(m.getRawValueProperty().name==e[i].name){M.rawValuePropertyName=e[i].name;}var k=m.getFormattedValueProperty();if(k&&k.name==e[i].name){M.formattedValuePropertyName=e[i].name;}M.analyticalInfo=e[i];}this.mAnalyticalInfoByProperty[e[i].name]=e[i];}for(var l in this.oMeasureDetailsSet){var u=this.oAnalyticalQueryResult.findMeasureByName(l).getUnitProperty();if(u){this.oMeasureDetailsSet[l].unitPropertyName=u.name;}}var n=function(q){var N=[];for(var r in q){N.push(r.name);}return N.sort().join(";");};if(n(p)!=n(this.oDimensionDetailsSet)){this.iTotalSize=-1;}this.aAnalyticalInfo=e;this.resetData();this.bNeedsUpdate=false;if(g){this._fireChange({reason:C.Change});}};
f.prototype.getAnalyticalInfoForColumn=function(s){return this.mAnalyticalInfoByProperty[s];};
f.prototype.loadGroups=function(g){var G=[];for(var s in g){G.push(s);this._resetData(s);var e=g[s];for(var i=0;i<e.length;i++){var o=e[i];this._getContextsForParentGroupId(s,o.startIndex,o.length,o.threshold);}var r=[];for(var j=-1,h;(h=G[++j])!==undefined;){r.push(this._getRequestId(f._requestType.groupMembersQuery,{groupId:h}));}this._considerRequestGrouping(r);}};
f.prototype.getAnalyticalQueryResult=function(){return this.oAnalyticalQueryResult;};
f._requestType={groupMembersQuery:1,totalSizeQuery:2,groupMembersAutoExpansionQuery:3,levelMembersQuery:4,reloadMeasuresQuery:5};f._artificialRootContextGroupId="artificialRootContext";
f.prototype._getContextsForParentContext=function(p,s,l,i,L,n,e){if(p===undefined){return[];}if(p&&p.getPath()=="/"+f._artificialRootContextGroupId){p=this.getModel().getContext("/");}var P=this._getGroupIdFromContext(p,L);return this._getContextsForParentGroupId(P,s,l,i,n,e);};
f.prototype._getContextsForParentGroupId=function(p,s,l,e,n,g){if(p===undefined){return[];}if(!s){s=0;}if(!l){l=this.oModel.iSizeLimit;}if(this.mFinalLength[p]&&this.mLength[p]<s+l){l=this.mLength[p]-s;if(l<0){Q.sap.log.fatal("invalid start index greater than total group length passed");}}if(!e){e=0;}if(!n){n=0;}if(p==null){if(n>0){Q.sap.log.fatal("invalid request to determine nodes of root context");return null;}}else{if(this._getGroupIdLevel(p)>=this.aAggregationLevel.length&&n>0){Q.sap.log.fatal("invalid request to determine nodes of context with group ID "+p);return null;}if(this._getGroupIdLevel(p)+n>this.aAggregationLevel.length){n=this.aAggregationLevel.length-this._getGroupIdLevel(p)-1;}}var h=[],L,G,o,m;var k=p==null?0:this._getGroupIdLevel(p)+1;if(!this.aMultiUnitLoadFactor[k]){this.aMultiUnitLoadFactor[k]=1;}var q=n>0&&p!=null;if(q){var M=this._getGroupIdLevel(p);var r=M+n;var D=true;if(!g){o=this._calculateRequiredGroupExpansion(p,r,s,l+e);D=o.groupId_Missing==null;D=D||o.groupId_Missing.length<p.length||o.groupId_Missing.substring(0,p.length)!=p;}if(D){h=this._getLoadedContextsForGroup(p,s,l);}else{m=l+e;}L=!D;m=Math.ceil(m*this.aMultiUnitLoadFactor[k]);}else{h=this._getLoadedContextsForGroup(p,s,l,g);L=false;if(!g){G=this._calculateRequiredGroupSection(p,s,l,e,h);var P=G.length>0&&l<G.length;L=(h.length!=l&&!(this.mFinalLength[p]&&h.length>=this.mLength[p]-s))||P;G.length=Math.ceil(G.length*this.aMultiUnitLoadFactor[k]);}}if(!L){this._cleanupGroupingForCompletedRequest(this._getRequestId(f._requestType.groupMembersQuery,{groupId:p}));}var E=false;if(this.oModel.getServiceMetadata()){if(L){var N=this.bProvideTotalSize&&this.iTotalSize==-1&&!this._isRequestPending(this._getRequestId(f._requestType.totalSizeQuery));E=true;var u;if(this.bUseBatchRequests){if(q){u=this._prepareGroupMembersAutoExpansionRequestIds(p,n);for(var i=-1,R;(R=u[++i])!==undefined;){if(this._isRequestPending(R)){E=false;break;}}if(E){this.aBatchRequestQueue.push([f._requestType.groupMembersAutoExpansionQuery,p,o,m,n]);}}else{E=!this._isRequestPending(this._getRequestId(f._requestType.groupMembersQuery,{groupId:p}));if(E){this.aBatchRequestQueue.push([f._requestType.groupMembersQuery,p,G.startIndex,G.length]);u=[this._getRequestId(f._requestType.groupMembersQuery,{groupId:p})];}}if(E&&N){u.push(this._getRequestId(f._requestType.totalSizeQuery));this._considerRequestGrouping(u);this.aBatchRequestQueue.push([f._requestType.totalSizeQuery]);}if(E){if(p==null){this._abortAllPendingRequests();}Promise.resolve().then(f.prototype._processRequestQueue.bind(this));}}else{var v;if(q){u=this._prepareGroupMembersAutoExpansionRequestIds(p,n);for(var j=-1,w;(w=u[++j])!==undefined;){if(this._isRequestPending(w)){E=false;break;}}if(E){v=this._prepareGroupMembersAutoExpansionQueryRequest(f._requestType.groupMembersAutoExpansionQuery,p,o,m,n);}}else{E=!this._isRequestPending(this._getRequestId(f._requestType.groupMembersQuery,{groupId:p}));if(E){v=this._prepareGroupMembersQueryRequest(f._requestType.groupMembersQuery,p,G.startIndex,G.length);u=[v.sRequestId];}}if(E){if(p==null){this._abortAllPendingRequests();}this._executeQueryRequest(v);if(N&&!v.bIsFlatListRequest){u.push(this._getRequestId(f._requestType.totalSizeQuery));this._considerRequestGrouping(u);this._executeQueryRequest(this._prepareTotalSizeQueryRequest(f._requestType.totalSizeQuery));}}}}}return h;};
f.prototype._processRequestQueue=function(r){if(r===undefined||r===null){r=this.aBatchRequestQueue||[];}if(r.length==0){return;}var R=[];var e=false;var i,o,g;for(i=-1;(g=r[++i])!==undefined;){if(g[0]==f._requestType.groupMembersQuery){o=f.prototype._prepareGroupMembersQueryRequest.apply(this,g);e=e||o.bIsFlatListRequest;R.push(o);}}for(i=-1;(g=r[++i])!==undefined;){o=null;switch(g[0]){case f._requestType.groupMembersQuery:continue;case f._requestType.totalSizeQuery:if(!e){o=f.prototype._prepareTotalSizeQueryRequest.apply(this,g);R.push(o);}break;case f._requestType.groupMembersAutoExpansionQuery:o=f.prototype._prepareGroupMembersAutoExpansionQueryRequest.apply(this,g);for(var j=-1,l;(l=o.aGroupMembersAutoExpansionRequestDetails[++j])!==undefined;){R.push(l);}break;case f._requestType.reloadMeasuresQuery:{var h=g[1];for(var k=-1,m;(m=h[++k])!==undefined;){R.push(m);}break;}default:Q.sap.log.fatal("unhandled request type "+r[i][0]);continue;}}if(R.length>1){this._executeBatchRequest(R);}else{this._executeQueryRequest(R[0]);}if(r===this.aBatchRequestQueue){this.aBatchRequestQueue=[];}};
f.prototype._prepareGroupMembersQueryRequest=function(r,g,s,L){var G=[];var o=new d.QueryResultRequest(this.oAnalyticalQueryResult);o.setResourcePath(this._getResourcePath());o.getSortExpression().clear();var e=0,h=-1;if(g){G=this._getGroupIdComponents(g);e=h=G.length;var u=0;for(var j=0,p=0;j<e;p++){if(this.oDimensionDetailsSet[this.aMaxAggregationLevel[p]].grouped==false){++u;}else{++j;}}e=h=e+u;if(this.aMaxAggregationLevel.length>0){while(this.oDimensionDetailsSet[this.aMaxAggregationLevel[h]].grouped==false){if(++h==this.aMaxAggregationLevel.length){break;}}}}var I=h>=this.aMaxAggregationLevel.length-1;var q=this.aMaxAggregationLevel.slice(0,h+1);o.setAggregationLevel(q);for(var i=0;i<q.length;i++){var D=this.oDimensionDetailsSet[q[i]];var v=(D.textPropertyName!=undefined);o.includeDimensionKeyTextAttributes(D.name,true,v,D.aAttributeName);if(D.grouped){o.getSortExpression().addSorter(q[i],d.SortOrder.Ascending);}}var w=o.getFilterExpression();w.clear();if(this.aApplicationFilter){w.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){w.addUI5FilterConditions(this.aControlFilter);}if(e>=1){for(var k=0,l=G.length;k<l;k++){w.removeConditions(this.aAggregationLevel[k]);w.addCondition(this.aAggregationLevel[k],a.EQ,G[k]);}}var x;var y;var z;var M;var E=[];if(g!=null||this.bProvideGrandTotals){o.setMeasures(this.aMeasureName);for(var H in this.oMeasureDetailsSet){M=this.oMeasureDetailsSet[H];if(!I&&this.mAnalyticalInfoByProperty[H].total==false){x=false;y=false;z=false;}else{x=(M.rawValuePropertyName!=undefined);y=(M.formattedValuePropertyName!=undefined);z=(M.unitPropertyName!=undefined);if(z){if(Q.inArray(M.unitPropertyName,E)==-1){E.push(M.unitPropertyName);}}}o.includeMeasureRawFormattedValueUnit(M.name,x,y,z);}for(var n in q){var J;if((J=Q.inArray(q[n],E))!=-1){E.splice(J,1);}}}var K=o.getSortExpression();for(var m=0;m<this.aSorter.length;m++){if(this.aSorter[m]){K.addSorter(this.aSorter[m].sPath,this.aSorter[m].bDescending?d.SortOrder.Descending:d.SortOrder.Ascending);}}if(L==0){Q.sap.log.fatal("unhandled case: load 0 entities of sub group");}var N=this._getKeyIndexMapping(g,s);if(!this.bNoPaging){o.setResultPageBoundaries(N.iServiceKeyIndex+1,N.iServiceKeyIndex+L);}o.setRequestOptions(null,!this.mFinalLength[g]);return{iRequestType:r,sRequestId:this._getRequestId(f._requestType.groupMembersQuery,{groupId:g}),oAnalyticalQueryRequest:o,sGroupId:g,aSelectedUnitPropertyName:E,aAggregationLevel:q,bIsFlatListRequest:I&&e==0,bIsLeafGroupsRequest:I,iStartIndex:s,iLength:L,oKeyIndexMapping:N};};
f.prototype._prepareTotalSizeQueryRequest=function(r){var o=new d.QueryResultRequest(this.oAnalyticalQueryResult);o.setResourcePath(this._getResourcePath());o.setAggregationLevel(this.aMaxAggregationLevel);o.setMeasures([]);var e=o.getFilterExpression();e.clear();if(this.aApplicationFilter){e.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){e.addUI5FilterConditions(this.aControlFilter);}o.setRequestOptions(null,null,true);o.setRequestOptions(null,true);return{iRequestType:r,sRequestId:this._getRequestId(f._requestType.totalSizeQuery),oAnalyticalQueryRequest:o};};
f.prototype._prepareGroupMembersAutoExpansionQueryRequest=function(r,g,G,L,n){var e=this;var p=function(G,o){var u=[];if(G.groupId_Missing==null){Q.sap.log.fatal("missing group Id not present");return u;}var q=e._getGroupIdComponents(G.groupId_Missing);var s=q.length;if(s>o){Q.sap.log.fatal("the given group ID is too deep for requested level for auto expansion");return u;}var k=[];for(var i=0;i<s;i++){var l=e.aAggregationLevel[i];var V=q[i];var K=e._getFilterOperatorMatchingPropertySortOrder(l);k[i]=new F(l,K,V);}var M=null;if(G.startIndex_Missing>0){var N=e._getKey(G.groupId_Missing,G.startIndex_Missing-1);var O=e.oModel.getObject("/"+N);var P=e.aAggregationLevel[s];var U=O[P];M=new F(P,e._getFilterOperatorMatchingPropertySortOrder(P,false),U);}for(var w=0;w<o;w++){var W=[];var X=Math.min(s,w+1);for(var Y=0;Y<X;Y++){var Z=[];var $=Math.min(s,Y+1);var _=G.startIndex_Missing>0;for(var a1=0;a1<$;a1++){var b1=new F("x",a.EQ,"x");b1=Q.extend(true,b1,k[a1]);if($>1&&a1<$-1){b1.sOperator=a.EQ;}if(a1==s-1&&w>s-1&&!_){if(b1.sOperator==a.GT){b1.sOperator=a.GE;}else{b1.sOperator=a.LE;}}Z.push(b1);}if(Z.length>0){W.push(new F(Z,true));if(w>s-1&&Y==s-1&&_){var c1=[];for(var j=0;j<Z.length;j++){var d1=new F("x",a.EQ,"x");d1=Q.extend(true,d1,Z[j]);c1.push(d1);}c1[s-1].sOperator=a.EQ;c1.push(M);W.push(new F(c1,true));break;}}}if(W.length>0){u[w]=new F(W,false);}else{u[w]=null;}}return u;};var h=function(r,g,w,K,x,L,M,U){var N=new d.QueryResultRequest(e.oAnalyticalQueryResult);N.setResourcePath(e._getResourcePath());N.getSortExpression().clear();var O=0,P=-1;O=P=w-1;var V=0;for(var i=0,W=0;i<O;W++){if(e.oDimensionDetailsSet[e.aMaxAggregationLevel[W]].grouped==false){++V;}else{++i;}}O=P=O+V;if(e.aMaxAggregationLevel.length>0){while(e.oDimensionDetailsSet[e.aMaxAggregationLevel[P]].grouped==false){if(++P==e.aMaxAggregationLevel.length){break;}}}var X=P>=e.aMaxAggregationLevel.length-1;var Y=e.aMaxAggregationLevel.slice(0,P+1);N.setAggregationLevel(Y);for(var l=0;l<Y.length;l++){var Z=e.oDimensionDetailsSet[Y[l]];var $=(Z.textPropertyName!=undefined);N.includeDimensionKeyTextAttributes(Z.name,true,$,Z.aAttributeName);if(Z.grouped){N.getSortExpression().addSorter(Y[l],d.SortOrder.Ascending);}}var _=N.getFilterExpression();_.clear();if(e.aApplicationFilter){_.addUI5FilterConditions(e.aApplicationFilter);}if(e.aControlFilter){_.addUI5FilterConditions(e.aControlFilter);}if(K){_.addUI5FilterConditions([K]);}var a1;var b1;var c1;var d1;var e1=[];N.setMeasures(e.aMeasureName);for(var f1 in e.oMeasureDetailsSet){d1=e.oMeasureDetailsSet[f1];if(!X&&e.mAnalyticalInfoByProperty[f1].total==false){a1=false;b1=false;c1=false;}else{a1=(d1.rawValuePropertyName!=undefined);b1=(d1.formattedValuePropertyName!=undefined);c1=(d1.unitPropertyName!=undefined);if(c1){if(Q.inArray(d1.unitPropertyName,e1)==-1){e1.push(d1.unitPropertyName);}}}N.includeMeasureRawFormattedValueUnit(d1.name,a1,b1,c1);}for(var j in Y){var g1;if((g1=Q.inArray(Y[j],e1))!=-1){e1.splice(g1,1);}}var h1=N.getSortExpression();for(var k=0;k<e.aSorter.length;k++){if(e.aSorter[k]){h1.addSorter(e.aSorter[k].sPath,e.aSorter[k].bDescending?d.SortOrder.Descending:d.SortOrder.Ascending);}}if(L==0){Q.sap.log.fatal("unhandled case: load 0 entities of sub group");}var i1=x;if(!U){i1=0;}else{var j1=0;for(var k1 in e.mServiceKey){if(k1.split("/").length===w+1){j1+=e.mServiceKey[k1].length;}}i1=Math.max(i1,j1);}if(!e.bNoPaging){N.setResultPageBoundaries(i1+1,L);}return{iRequestType:r,sRequestId:null,oAnalyticalQueryRequest:N,iLevel:w,aSelectedUnitPropertyName:e1,aAggregationLevel:Y,bIsFlatListRequest:X,bIsLeafGroupsRequest:X,iStartIndex:x,iLength:L,bAvoidLengthUpdate:M};};var m=[];var R=[];if(!G){Q.sap.log.fatal("no first missing group member specified");}var o=this._getGroupIdLevel(g)+n+1;var q=e._getGroupIdComponents(G.groupId_Missing);var s=q.length;var u=p(G,o);var v;for(var w=1;w<=o;w++){var x;if(w>=s+2){x=0;v=undefined;}else if(w==s+1){x=G.startIndex_Missing;v=G.groupId_Missing;}else if(s>0){if(w==s){v=G.groupId_Missing;}else{v=this._getGroupIdAncestors(G.groupId_Missing,-(s-w))[0];}var y=this._getGroupIdAncestors(G.groupId_Missing,-(s-w+1))[0];if(!y){Q.sap.log.fatal("failed to determine group id at parent level; group ID = "+g+", level = "+w);}x=this._findKeyIndex(y,this.mEntityKey[v]);if(x==-1){Q.sap.log.fatal("failed to determine position of value "+v+" in group "+y);}v=y;x++;}var z=L>w?Math.ceil((L-w)/(o-w+1)):L;var D=u[w-1];if(this.bUseAcceleratedAutoExpand){var E=h(f._requestType.levelMembersQuery,g,w,D,x,z,false,D==null?true:false);E.sGroupId_Missing_AtLevel=v;E.sRequestId=this._getRequestId(f._requestType.levelMembersQuery,{groupId:g,level:w});m.push(E);R.push(E.sRequestId);}else if(D&&D.aFilters.length>0){if(!D._bMultiFilter||D.bAnd){Q.sap.log.fatal("level filter in wrong shape; cannot break it up");}for(var i=0;i<D.aFilters.length;i++){var H=D.aFilters[i];var I=h(f._requestType.levelMembersQuery,g,w,H,x,z,false,D==null?true:false);I.sGroupId_Missing_AtLevel=v;I.sRequestId=this._getRequestId(f._requestType.levelMembersQuery,{groupId:g,level:w,tupleIndex:i});m.push(I);R.push(I.sRequestId);}}else{var J=h(f._requestType.levelMembersQuery,g,w,null,x,z,false,D==null?true:false);J.sGroupId_Missing_AtLevel=v;J.sRequestId=this._getRequestId(f._requestType.levelMembersQuery,{groupId:g,level:w});m.push(J);R.push(J.sRequestId);}}return{iRequestType:r,aRequestId:R,aGroupMembersAutoExpansionRequestDetails:m,sGroupId:g,iLength:L};};
f.prototype._prepareReloadMeasurePropertiesQueryRequest=function(r,g,m){var o=new d.QueryResultRequest(this.oAnalyticalQueryResult);o.setResourcePath(this._getResourcePath());o.getSortExpression().clear();var e=g.aAggregationLevel;o.setAggregationLevel(e);var I=g.bIsLeafGroupsRequest;var h=o.getFilterExpression();h.clear();if(this.aApplicationFilter){h.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){h.addUI5FilterConditions(this.aControlFilter);}var k=[];for(var i=0;i<e.length;i++){var l=new F(e[i],a.EQ,m.oEntry[e[i]]);k.push(l);}h.addUI5FilterConditions(k);var n;var p;var q;var M;var s=[];o.setMeasures(m.aReloadMeasurePropertyName);for(var u in this.oMeasureDetailsSet){M=this.oMeasureDetailsSet[u];if(Q.inArray(M.name,m.aReloadMeasurePropertyName)==-1){continue;}if(!I&&this.mAnalyticalInfoByProperty[u].total==false){n=false;p=false;q=false;}else{n=(M.rawValuePropertyName!=undefined);p=(M.formattedValuePropertyName!=undefined);q=(M.unitPropertyName!=undefined);if(q){if(Q.inArray(M.unitPropertyName,s)==-1){s.push(M.unitPropertyName);}}}o.includeMeasureRawFormattedValueUnit(M.name,n,p,q);}for(var j in e){var v;if((v=Q.inArray(e[j],s))!=-1){s.splice(v,1);}}return{iRequestType:r,sRequestId:this._getRequestId(f._requestType.reloadMeasuresQuery,{multiUnitEntryKey:this.oModel.getKey(m.oEntry)}),oAnalyticalQueryRequest:o,aSelectedUnitPropertyName:s,aAggregationLevel:e,oMultiUnitRepresentative:m};};
f.prototype._prepareGroupMembersAutoExpansionRequestIds=function(g,n){var m=this._getGroupIdLevel(g)+1;var i=m+n;var r=[];for(var l=m;l<=i;l++){r.push(this._getRequestId(f._requestType.levelMembersQuery,{groupId:g,level:l}));}return r;};
f.prototype._getQueryODataRequestOptions=function(o,p){p=p||{};try{o.getFilterExpression().checkValidity();}catch(e){Q.sap.log.fatal("filter expression is not valid",e.toString());return undefined;}var s=o.getURIQueryOptionValue("$select");var g=o.getURIQueryOptionValue("$filter");var O=o.getURIQueryOptionValue("$orderby");var h=o.getURIQueryOptionValue("$skip");var j=o.getURIQueryOptionValue("$top");var I=o.getURIQueryOptionValue("$inlinecount");if(this.mParameters&&this.mParameters["filter"]){g+="and ("+this.mParameters["filter"]+")";}var P=[];if(s!==null){P.push("$select="+s);}if(g!==null){P.push("$filter="+g);}if(O!==null){P.push("$orderby="+O);}if(h!==null){P.push("$skip="+h);}if(j!==null){P.push("$top="+j);}if(I!==null){P.push("$inlinecount="+I);}if(p.encode===true){for(var i=0;i<P.length;i++){P[i]=P[i].replace(/\ /g,"%20");}}return P;};
f.prototype._executeBatchRequest=function(r){var e=this.iAnalyticalInfoVersionNumber;var g=this;var h=[],E=[];function l(){g.fireDataReceived({__simulateAsyncAnalyticalBinding:true});}var R=new B();function s(j,k){R.success(k);}function m(j,k){R.error(k||j);}this.bNeedsUpdate=true;for(var D=0;D<r.length;D++){var o=r[D];if(o.aAggregationLevel&&o.aAggregationLevel.length>0){this.bNeedsUpdate=false;}}for(var i=-1,n;(n=r[++i])!==undefined;){var p=n.oAnalyticalQueryRequest,G=n.sGroupId;if(p.getURIQueryOptionValue("$select")==null){this.fireDataRequested({__simulateAsyncAnalyticalBinding:true});G=null;this.mServiceLength[G]=this.mLength[G]=1;this.mServiceFinalLength[G]=true;this._setServiceKey(this._getKeyIndexMapping(G,0),f._artificialRootContextGroupId);setTimeout(l);this.bArtificalRootContext=true;continue;}var P=p.getURIToQueryResultEntries();if(!this.oContext&&P[0]!=="/"){P="/"+P;}if(!this._isRequestPending(n.sRequestId)){this._registerNewRequest(n.sRequestId);if(this.iModelVersion===A.V1){h.push(this.oModel.createBatchOperation(P.replace(/\ /g,"%20"),"GET"));}else if(this.iModelVersion===A.V2){var u=this._getQueryODataRequestOptions(p,{encode:true});if(this.sCustomParams){u.push(this.sCustomParams);}var q=this.oModel.read(P.replace(/\ /g,"%20"),{success:s,error:m,context:this.oContext,urlParameters:u});h.push(q);}E.push(n);}}if(h.length>0){Q.sap.log.debug("AnalyticalBinding: executing batch request with "+E.length+" operations");var v;var w=this._getIdForNewRequestHandle();this.fireDataRequested();if(this.iModelVersion===A.V1){this.oModel.addBatchReadOperations(h);v=this.oModel.submitBatch(x,y,true,true);this.oModel.fireRequestSent({url:this.oModel.sServiceUrl+"/$batch",type:"POST",async:true,info:"",infoObject:{}});}else{v={abort:function(){for(var j=0;j<h.length;j++){h[j].abort();}}};R.setup({executedRequests:E,binding:this,success:x,error:y});}this._registerNewRequestHandle(w,v);}function x(z,H){g._deregisterHandleOfCompletedRequest(w);if(E.length!=z.__batchResponses.length){Q.sap.log.fatal("assertion failed: received "+z.__batchResponses.length+" responses for "+E.length+" read operations in the batch request");}if(e!=g.iAnalyticalInfoVersionNumber){for(var j=0;j<E.length;j++){var I=E[j].sRequestId;if(I!==undefined){g._deregisterCompletedRequest(I);g._cleanupGroupingForCompletedRequest(I);}}g.fireDataReceived({data:[]});return;}var J=0;for(var k=0;k<z.__batchResponses.length;k++){if(z.__batchResponses[k].data!=undefined){if(z.__batchResponses[k].data.results.length==0){J++;}switch(E[k].iRequestType){case f._requestType.groupMembersQuery:g._processGroupMembersQueryResponse(E[k],z.__batchResponses[k].data);break;case f._requestType.totalSizeQuery:g._processTotalSizeQueryResponse(E[k],z.__batchResponses[k].data);break;case f._requestType.levelMembersQuery:g._processLevelMembersQueryResponse(E[k],z.__batchResponses[k].data);break;case f._requestType.reloadMeasuresQuery:g._processReloadMeasurePropertiesQueryResponse(E[k],z.__batchResponses[k].data);break;default:Q.sap.log.fatal("invalid request type "+E[k].iRequestType);continue;}}g._deregisterCompletedRequest(E[k].sRequestId);g._cleanupGroupingForCompletedRequest(E[k].sRequestId);}if(g.mParameters&&g.mParameters.numberOfExpandedLevels>0){if(J==z.__batchResponses.length){g.mLength["/"]=0;g.mFinalLength["/"]=true;}}var O=true;var K;g.fireDataReceived({data:z});var V={};if(g.iModelVersion===A.V1){K=g.oModel._getBatchErrors(z);if(K.length>0){O=false;V=g.oModel._handleError(K[0]);}g.oModel.fireRequestCompleted({url:H.requestUri,type:"POST",async:true,info:"",infoObject:{},success:O,errorobject:O?{}:V});if(O){g.oModel.checkUpdate();}}}function y(k){if(k&&k.statusText!="abort"){g._deregisterHandleOfCompletedRequest(w);for(var j=-1,z;(z=E[++j])!==undefined;){g._deregisterCompletedRequest(z.sRequestId);g._cleanupGroupingForCompletedRequest(z.sRequestId);}}if(e!=g.iAnalyticalInfoVersionNumber){return;}var V=k;if(g.iModelVersion===A.V1){V=g.oModel._handleError(k);}g.oModel.fireRequestCompleted({url:"",type:"POST",async:true,info:"",infoObject:{},success:false,errorobject:V});if(g.iModelVersion===A.V1){g.oModel.fireRequestFailed(V);}g.fireDataReceived();}};
f.prototype._executeQueryRequest=function(r){if(r.iRequestType==f._requestType.groupMembersAutoExpansionQuery){for(var i=-1,o;(o=r.aGroupMembersAutoExpansionRequestDetails[++i])!==undefined;){this._executeQueryRequest(o);}return;}var e=this.iAnalyticalInfoVersionNumber;var g=r.oAnalyticalQueryRequest,G=r.sGroupId;var p=g.getURIToQueryResultEntitySet();var P=this._getQueryODataRequestOptions(g);if(!P){return;}var h=this;if(g.getURIQueryOptionValue("$select")==null){this.fireDataRequested({__simulateAsyncAnalyticalBinding:true});G=null;this.mServiceLength[G]=this.mLength[G]=1;this.mServiceFinalLength[G]=true;this._setServiceKey(this._getKeyIndexMapping(G,0),f._artificialRootContextGroupId);this.bNeedsUpdate=true;setTimeout(function(){if(h._cleanupGroupingForCompletedRequest(r.sRequestId)){h.fireDataReceived({__simulateAsyncAnalyticalBinding:true});}});this.bArtificalRootContext=true;return;}this._registerNewRequest(r.sRequestId);this.fireDataRequested();for(var j=0;j<P.length;j++){P[j]=P[j].replace(/\ /g,"%20");}Q.sap.log.debug("AnalyticalBinding: executing query request");var R=this._getIdForNewRequestHandle();if(this.iModelVersion===A.V1){this.oModel._loadData(p,P,s,E,false,u,l);}else{if(this.sCustomParams){P.push(this.sCustomParams);}var k=this.oModel.read(p,{success:s,error:E,context:this.oContext,urlParameters:P});h._registerNewRequestHandle(R,k);}function s(D){h._deregisterHandleOfCompletedRequest(R);if(e!=h.iAnalyticalInfoVersionNumber){h._deregisterCompletedRequest(r.sRequestId);return;}switch(r.iRequestType){case f._requestType.groupMembersQuery:h._processGroupMembersQueryResponse(r,D);break;case f._requestType.totalSizeQuery:h._processTotalSizeQueryResponse(r,D);break;case f._requestType.levelMembersQuery:h._processLevelMembersQueryResponse(r,D);break;case f._requestType.reloadMeasuresQuery:h._processReloadMeasurePropertiesQueryResponse(r,D);break;default:Q.sap.log.fatal("invalid request type "+r.iRequestType);break;}h._deregisterCompletedRequest(r.sRequestId);if(h.iModelVersion===A.V2){l(D);}}function l(D){if(e!=h.iAnalyticalInfoVersionNumber){return;}if(h._cleanupGroupingForCompletedRequest(r.sRequestId)){h.fireDataReceived({data:D});}}function E(m){if(m&&m.statusText=="abort"){h.fireDataReceived();return;}h._deregisterHandleOfCompletedRequest(R);h._deregisterCompletedRequest(r.sRequestId);h._cleanupGroupingForCompletedRequest(r.sRequestId);if(e!=h.iAnalyticalInfoVersionNumber){return;}h.fireDataReceived();}function u(k){h._registerNewRequestHandle(R,k);}};
f.prototype._abortAllPendingRequests=function(){this._abortAllPendingRequestsByHandle();this._clearAllPendingRequests();};
f.prototype._processGroupMembersQueryResponse=function(R,D){var G=R.sGroupId,s=R.aSelectedUnitPropertyName,e=R.aAggregationLevel,n=R.oKeyIndexMapping.iIndex,u=R.oKeyIndexMapping.iServiceKeyIndex,L=R.iLength,K=R.oKeyIndexMapping,v=G==null?0:this._getGroupIdLevel(G)+1;var U=(s.length>0);var P,w;var x;var y=0;var z;var E,H=[];var O=D.results.length;var I=this._getServiceKeys(G,K.iIndex-1);P=undefined;if(I&&I.length>0){for(var i=0,J=I.length;i<J;i++){D.results[i-J]=this.oModel.getObject("/"+I[i]);}var M=D.results[-I.length];P="";for(var j=0;j<e.length;j++){P+=M[e[j]]+"|";}}z=I&&I.length==1;for(var h=0;h<O;h++){var N=D.results[h];if(U){w="";for(var g=0;g<e.length;g++){w+=N[e[g]]+"|";}if(P==w){if(x===undefined){if(h==0){x=-I.length;K.iServiceKeyIndex-=I.length-1;}else{x=h-1;}}var V=-1,W=D.results[h-1];for(var k=0;k<s.length;k++){if(W[s[k]]!=N[s[k]]){V=k;break;}}if(V==-1){Q.sap.log.fatal("assertion failed: no deviating units found for result entries "+(h-1)+" and "+h,null,null,t(this,"NO_DEVIATING_UNITS"));}}if((P!=w||h==O-1)&&x!==undefined){var X=[];for(var l=x;l<h;l++){X.push(D.results[l]);}if(P==w){X.push(D.results[h]);}var Y=[];for(var m=0;m<s.length;m++){var Z=s[m];for(var o=1;o<X.length;o++){if(X[o-1][Z]!=X[o][Z]){Y.push(Z);break;}}}var $=this._createMultiUnitRepresentativeEntry(G,D.results[x],s,Y,R.bIsFlatListRequest);if($.aReloadMeasurePropertyName.length>0){E=this._prepareReloadMeasurePropertiesQueryRequest(f._requestType.reloadMeasuresQuery,R,$);if(E.oAnalyticalQueryRequest&&E.oAnalyticalQueryRequest.getURIQueryOptionValue("$select")!=null){H.push(E);}}var _=this._setAdjacentMultiUnitKeys(K,$,X);var a1;if($.bIsNewEntry){a1=X.length-1;}else{a1=_;}if(z){z=false;}if(a1<0){Q.sap.log.fatal("assertion failed: iDiscardedEntriesCount must be non-negative");}y+=a1;var b1=this.oModel._getKey($.oEntry);var c1=this.oModel.getContext('/'+b1);this._getGroupIdFromContext(c1,v);this.mEntityKey[e1]=b1;x=undefined;if(P!=w){z=this._setServiceKey(K,this.oModel._getKey(N));}}else if(P!=w){z=this._setServiceKey(K,this.oModel._getKey(N));}P=w;}else{this._setServiceKey(K,this.oModel._getKey(N));}if(!R.bIsLeafGroupsRequest){var d1=this._getKey(G,K.iIndex-1),e1=this._getGroupIdFromContext(this.oModel.getContext('/'+d1),v);this.mEntityKey[e1]=d1;}}var f1=[];if(this.bReloadSingleUnitMeasures&&H.length>0){if(this.bUseBatchRequests){this.aBatchRequestQueue.push([f._requestType.reloadMeasuresQuery,H]);Promise.resolve().then(f.prototype._processRequestQueue.bind(this));}else{for(var q=0;q<H.length;q++){var g1=H[q];this._executeQueryRequest(g1);}}for(var p=0;p<H.length;p++){var h1=H[p];f1.push(h1.sRequestId);}this._considerRequestGrouping(f1);}if(I&&I.length>0){for(var r=0,i1=I.length;r<i1;r++){delete D.results[r-i1];}}if(U){y+=this._mergeLoadedKeyIndexWithSubsequentIndexes(K,e,s,R.bIsFlatListRequest);}if(!R.bAvoidLengthUpdate){var j1=false;if(D.__count){this.mServiceLength[G]=parseInt(D.__count,10);this.mLength[G]=this.mServiceLength[G]-y;this.mFinalLength[G]=true;if(R.bIsFlatListRequest){this.iTotalSize=D.__count;}j1=true;}if(this.mServiceLength[G]<u+O){this.mServiceLength[G]=u+O;this.mLength[G]=n+O-y;this.mFinalLength[G]=false;}if(O<L||L===undefined){this.mServiceLength[G]=u+O;this.mLength[G]=n+K.iIndex-n;this.mFinalLength[G]=true;j1=true;}if(O==0){this.mLength[G]=this.mServiceLength[G]=0;this.mFinalLength[G]=true;j1=true;}if(!j1&&this.mLength[G]!==undefined&&y>0){this.mLength[G]-=y;}}this.bNeedsUpdate=true;if(y>0){if(D.results.length-y>0){this.aMultiUnitLoadFactor[e.length]=D.results.length/(D.results.length-y);}if(this.aMultiUnitLoadFactor[e.length]<1.5){this.aMultiUnitLoadFactor[e.length]=2;}}Q.sap.log.info("MultiUnit Situation in Group ("+G+"), discarded: "+y+", load-factor is now: "+this.aMultiUnitLoadFactor[e.length]);};
f.prototype._processTotalSizeQueryResponse=function(r,D){if(D.__count==undefined){Q.sap.log.fatal("missing entity count in query result");return;}this.iTotalSize=D.__count;};
f.prototype._processLevelMembersQueryResponse=function(r,D){var e=this;var p,P;var g=function(h,I){var G={iRequestType:f._requestType.groupMembersQuery,sRequestId:e._getRequestId(f._requestType.groupMembersQuery,{groupId:p}),oAnalyticalQueryRequest:r.oAnalyticalQueryRequest,sGroupId:p,aSelectedUnitPropertyName:r.aSelectedUnitPropertyName,aAggregationLevel:r.aAggregationLevel,bIsFlatListRequest:r.bIsFlatListRequest,bIsLeafGroupsRequest:r.bIsLeafGroupsRequest,iStartIndex:h?r.iStartIndex:0,iLength:r.iLength,bAvoidLengthUpdate:r.bAvoidLengthUpdate};if(h&&r.iStartIndex>0&&(r.sGroupId_Missing_AtLevel!=G.sGroupId||e._getKeys(G.sGroupId)===undefined)){var s=e._getParentGroupId(G.sGroupId);var j=e._findKeyIndex(s,e.mEntityKey[G.sGroupId]);if(j==-1){Q.sap.log.fatal("assertion failed: failed to determine position of "+G.sGroupId+" in group "+s);}if(j>0&&e._getKey(s,j-1)!==undefined){var k=e._getKey(s,j-1);var l=e._getGroupIdFromContext(e.oModel.getContext('/'+k),e._getGroupIdLevel(G.sGroupId));e.mFinalLength[l]=true;G.iStartIndex=0;}}if(I){G.iLength=P.length;}G.oKeyIndexMapping=e._getKeyIndexMapping(G.sGroupId,G.iStartIndex);var m=Q.extend(true,{},D);m.results=P;e._processGroupMembersQueryResponse(G,m);};if(D.results.length==0){return;}p=this._getGroupIdFromContext(this.oModel.getContext("/"+this.oModel._getKey(D.results[0])),r.iLevel-1);P=[];var h=true;for(var i=0;i<D.results.length;i++){var E=D.results[i];var o=this.oModel.getContext("/"+this.oModel._getKey(D.results[i]));var s=this._getGroupIdFromContext(o,r.iLevel-1);if(p==s){P.push(E);if(i<D.results.length-1){continue;}}g(h,D.results.length==r.iLength&&i==D.results.length-1);h=false;if(p!=s){P=[E];}p=s;}if(D.results.length>1&&P.length==1){g(h,D.results.length==r.iLength);}};
f.prototype._processReloadMeasurePropertiesQueryResponse=function(r,D){var m=r.oMultiUnitRepresentative;var M=this.oModel.getKey(m.oEntry);if(D.results.length!=1){Q.sap.log.fatal("assertion failed: more than one entity for reloaded measure properties of entity with key "+M);return;}var R=D.results[0];var o=this.oModel.getObject("/"+M);if(!o){Q.sap.log.fatal("assertion failed: no entity found with key "+M);return;}var e=m.aReloadMeasurePropertyName;for(var i=0;i<e.length;i++){o[e[i]]=R[e[i]];}};
f.prototype._getLoadedContextsForGroup=function(g,s,l,e){var h=[],o,k=this._getKeys(g),K;if(!k){return h;}if(!s){s=0;}if(!l){l=this.oModel.iSizeLimit;if(this.mFinalLength[g]){l=this.mLength[g];}}if(e){i=s||0;K=k(i);while(K){o=this.oModel.getContext('/'+K);h.push(o);i++;K=k(i);}return h;}for(var i=s;i<s+l;i++){K=k(i);if(!K){break;}o=this.oModel.getContext('/'+K);h.push(o);}return h;};
f.prototype._calculateRequiredGroupSection=function(g,s,l,e,h){var k,m,p,P,r,o={},K=this._getKeys(g),n;m=s;k=0;if(!K){P=s;p=s+l;}else{for(var i=s-1;i>=Math.max(s-e,0);i--){n=K(i);if(!n){P=i+1;break;}}for(var j=s+l;j<s+l+e;j++){n=K(j);if(!n){p=j;break;}}}r=s-P;if(P&&s>e&&r<e){if(h.length!==l){m=s-e;}else{m=P-e;}k=e;}m=Math.max(m,0);if(m===s){m+=h.length;}if(h.length!==l){k+=l-h.length;}r=p-s-l;if(r==0){k+=e;}if(p&&r<e&&r>0){if(m>s){m=p;k+=e;}}if(this.mFinalLength[g]&&this.mLength[g]<(k+m)){k=this.mLength[g]-m;}o.startIndex=m;o.length=k;return o;};
f.prototype._calculateRequiredGroupExpansion=function(g,e,s,l){var n={groupId_Missing:null,length_Missing:0};var h=this;var j=function(g,e,s,l){var L=h._getGroupIdLevel(g);if(L==e){var u=h._getLoadedContextsForGroup(g,s,l);var v=s+u.length-1;if(u.length>=l){return n;}else if(h.mFinalLength[g]){if(u.length>=h.mLength[g]){return{groupId_Missing:null,length_Missing:l-u.length};}else{return{groupId_Missing:g,startIndex_Missing:v+1,length_Missing:l-u.length};}}else{return{groupId_Missing:g,startIndex_Missing:v+1,length_Missing:l-u.length};}}var w=h._getLoadedContextsForGroup(g,s,l);var k=l,x=s+w.length-1;for(var i=-1,y;(y=w[++i])!==undefined;){k--;var G=j(h._getGroupIdFromContext(y,L+1),e,0,k);if(G.groupId_Missing==null){if(G.length_Missing==0){return G;}else{k=G.length_Missing;}}else{return G;}if(k==0){break;}}if(h.mFinalLength[g]||k==0){return{groupId_Missing:null,length_Missing:k};}else{return{groupId_Missing:g,startIndex_Missing:x+1,length_Missing:k};}};var L=this._getGroupIdLevel(g);if(L==e+1){g=this._getParentGroupId(g);--L;}if(g==null||L>e){return n;}var k=l,m=s;while(g!=null){var G=j(g,e,m,k);if(G.groupId_Missing!=null){return G;}else if(G.length_Missing==0){return G;}else{var o=false;while(!o){var p=this._getParentGroupId(g);if(p==null){g=p;--L;break;}var q=this.mEntityKey[g];if(!q){return n;}var r=this._findKeyIndex(p,q);if(r==-1){return n;}if(r==this._getKeyCount(p)-1){if(this.mFinalLength[p]){g=p;--L;continue;}else{return{groupId_Missing:p,startIndex_Missing:r+1,length_Missing:k};}}else{q=this._getKey(p,r+1);g=this._getGroupIdFromContext(this.oModel.getContext('/'+q),L);o=true;}}m=0;k=G.length_Missing;}}return{groupId_Missing:null,length_Missing:k};};
f.prototype._getResourcePath=function(){return this.isRelative()?this.oModel.resolve(this.sPath,this.getContext()):this.sPath;};
f.prototype._getEntitySet=function(){var e=this.sEntitySetName;if(!e){e=this.sPath.split("/")[1];if(e.indexOf("(")!=-1){e=e.split("(")[0]+"Results";}}return e;};
f.prototype._getEffectiveSortOrder=function(p){for(var i=0;i<this.aSorter.length;i++){if(this.aSorter[i]&&this.aSorter[i].sPath==p){return this.aSorter[i].bDescending?d.SortOrder.Descending:d.SortOrder.Ascending;}}return null;};
f.prototype._getFilterOperatorMatchingPropertySortOrder=function(p,w){var s;switch(this._getEffectiveSortOrder(p)){case d.SortOrder.Ascending:if(w){s=a.GE;}else{s=a.GT;}break;case d.SortOrder.Descending:if(w){s=a.LE;}else{s=a.LT;}break;default:s=a.GT;}return s;};
f.prototype._convertDeprecatedFilterObjects=function(e){if(!e){return e;}var O=sap.ui.require("sap/ui/model/odata/Filter");if(typeof O==='function'){for(var i=0,l=e.length;i<l;i++){if(e[i]instanceof O){e[i]=e[i].convert();}}}return e;};
f.prototype._getGroupIdFromContext=function(o,l){if(!o){return null;}var g="/";var D=null;if(l>this.aAggregationLevel.length){Q.sap.log.fatal("assertion failed: aggregation level deeper than number of current aggregation levels");}for(var i=0;i<l;i++){D=o.getProperty(this.aAggregationLevel[i]);if(D!=null){g+=encodeURIComponent(D)+"/";}else{g+="@/";}}return g;};
f.prototype._getGroupIdLevel=function(g){if(g==null){Q.sap.log.fatal("assertion failed: no need to determine level of group ID = null");return-1;}return g.split("/").length-2;};
f.prototype._getGroupIdComponents=function(g){if(g==null){return null;}var G=g.split("/");var D=[];for(var i=1;i<G.length-1;i++){if(G[i]=="@"){D[i-1]=null;}else{D[i-1]=decodeURIComponent(G[i]);}}return D;};
f.prototype._getGroupIdAncestors=function(g,n){if(!n){return[];}if(g==null){Q.sap.log.fatal("group ID null does not have ancestors");return[];}if(g=="/"){if(Math.abs(n)==1){return[null];}else{Q.sap.log.fatal("invalid level count "+n+" for ancestors of groupId "+g);return[];}}var G=g.split("/");var e=[],s="";var h=0,k=G.length-3;if(n>0){if(n-1>k){Q.sap.log.fatal("invalid level count "+n+" for ancestors of groupId "+g);}else{k=n-1;}}else if(-(n+1)>k){Q.sap.log.fatal("invalid level count "+n+" for ancestors of groupId "+g);}else{h=k+1+n;for(var i=0;i<h;i++){s+=G[i]+"/";}}for(var j=h;j<=k;j++){s+=G[j]+"/";e.push(s);}return e;};
f.prototype._getParentGroupId=function(g){return this._getGroupIdAncestors(g,-1)[0];};
f.prototype._removeDuplicatesFromStringArray=function(e){var o={};for(var i=0;i<e.length;i++){o[e[i]]=true;}var u=[];for(var s in o){u.push(s);}return u;};
f.prototype._getIdForNewRequestHandle=function(){if(this.oPendingRequestHandle===undefined){this.oPendingRequestHandle=[];}for(var i=0;i<this.oPendingRequestHandle.length;i++){if(this.oPendingRequestHandle[i]===undefined){return i;}}this.oPendingRequestHandle[this.oPendingRequestHandle.length]=undefined;return this.oPendingRequestHandle.length-1;};
f.prototype._registerNewRequestHandle=function(r,R){if(this.oPendingRequestHandle[r]!==undefined){Q.sap.log.fatal("request handle ID already in use");}this.oPendingRequestHandle[r]=R;};
f.prototype._deregisterHandleOfCompletedRequest=function(r){if(Q.isEmptyObject(this.oPendingRequestHandle)){Q.sap.log.warning("No request handles to be cleared. Previous abort/resetData?");return;}if(this.oPendingRequestHandle[r]===undefined){Q.sap.log.fatal("no handle found for this request ID");}this.oPendingRequestHandle[r]=undefined;};
f.prototype._abortAllPendingRequestsByHandle=function(){for(var i=0;i<this.oPendingRequestHandle.length;i++){if(this.oPendingRequestHandle[i]){if(this.oPendingRequestHandle[i]!==undefined){this.oPendingRequestHandle[i].abort();}}}this.oPendingRequestHandle=[];};
f.prototype._getRequestId=function(r,p){switch(r){case f._requestType.groupMembersQuery:if(p.groupId===undefined){Q.sap.log.fatal("missing group ID");}return f._requestType.groupMembersQuery+(p.groupId==null?"":p.groupId);case f._requestType.levelMembersQuery:if(p.level===undefined){Q.sap.log.fatal("missing level");}if(p.groupId===undefined){Q.sap.log.fatal("missing groupId");}return""+f._requestType.levelMembersQuery+p.level+(p.tupleIndex?"-"+p.tupleIndex:"");case f._requestType.totalSizeQuery:return f._requestType.totalSizeQuery;case f._requestType.reloadMeasuresQuery:if(!p.multiUnitEntryKey){Q.sap.log.fatal("missing multi unit entry key");}return f._requestType.reloadMeasuresQuery+p.multiUnitEntryKey;default:Q.sap.log.fatal("invalid request type "+r);return-1;}};
f.prototype._registerNewRequest=function(r){if(r==undefined||r==""){Q.sap.log.fatal("missing request ID");return;}if(!this.oPendingRequests[r]){this.oPendingRequests[r]=1;}else{++this.oPendingRequests[r];}};
f.prototype._considerRequestGrouping=function(r){for(var i=-1,R;(R=r[++i])!==undefined;){if(this.oGroupedRequests[R]===undefined){this.oGroupedRequests[R]={};}var g=this.oGroupedRequests[R];for(var j=0;j<r.length;j++){g[r[j]]=true;}}};
f.prototype._isRequestPending=function(r){return this.oPendingRequests[r]!=undefined&&this.oPendingRequests[r]>0;};
f.prototype._deregisterCompletedRequest=function(r){if(Q.isEmptyObject(this.oPendingRequests)){Q.sap.log.warning("There are no pending requests which could be set to 'completed'.");return;}if(!this.oPendingRequests[r]){Q.sap.log.fatal("assertion failed: there is no pending request ID "+r);}if(this.oPendingRequests[r]==1){delete this.oPendingRequests[r];}else{--this.oPendingRequests[r];}};
f.prototype._cleanupGroupingForCompletedRequest=function(r){if(this._isRequestPending(r)){return false;}var g=true;if(this.oGroupedRequests[r]!=undefined){for(var o in this.oGroupedRequests[r]){if(this.oPendingRequests[o]){g=false;break;}}}if(g){var R=this.oGroupedRequests[r];delete this.oGroupedRequests[r];for(var O in R){if(O!=r){this._cleanupGroupingForCompletedRequest(O);}}}return g;};
f.prototype._getKeyIndexMapping=function(g,s){var k=this.mKeyIndex[g];var e=this.mServiceKey[g];var i=s;if(k!==undefined){var l=s;if(l>0){while(--l>0){if(k[l]!==undefined){break;}}}var L;if(l==0){L=0;}else{if(k[l]>=0){L=k[l];}else if(k[l+1]===undefined){L=k[l]=="ZERO"?0:-k[l];while(e[L+1]!==undefined){++L;}}else{L=Math.abs(k[l+1])-1;}if(e[L]===undefined){Q.sap.log.fatal("assertion failed: no service key at iLastOccupiedServiceKeyIndex = "+L);}}var D=s-l;i=L+D;}var K={sGroupId:g,iIndex:s,iServiceKeyIndex:i};return K;};
f.prototype._moveKeyIndexMapping=function(k,i){return this._getKeyIndexMapping(k.sGroupId,k.iIndex+i);};
f.prototype._getKey=function(g,i){var s=this.mKeyIndex[g][i];if(s===undefined){return undefined;}if(s>=0){return this.mServiceKey[g][s];}if(this.mMultiUnitKey[g]===undefined){Q.sap.log.fatal("assertion failed: missing expected multi currency key for group with ID "+g);return null;}var k=this.mMultiUnitKey[g][i];if(k===undefined){Q.sap.log.fatal("assertion failed: missing expected multi currency key for group with ID "+g+" at pos "+i);return null;}return k;};
f.prototype._getKeys=function(g){if(this.mKeyIndex[g]===undefined){return undefined;}var e=this;return function(i){return e._getKey(g,i);};};
f.prototype._getServiceKeys=function(g,I){var k=this.mKeyIndex[g];if(k===undefined){return undefined;}var s=this.mServiceKey[g],e=k[I];if(e===undefined){return undefined;}if(e>=0){return[s[e]];}var G=[];if(k[I+1]===undefined){e=k[I]=="ZERO"?0:-k[I];while(s[e]!==undefined){G.push(s[e++]);}}else{e=k[I]=="ZERO"?0:-k[I];for(var i=e,n=Math.abs(k[I+1]);i<n;i++){G.push(s[i]);}}return G;};
f.prototype._getKeyCount=function(g){if(this.mKeyIndex[g]===undefined){return undefined;}return this.mKeyIndex[g].length;};
f.prototype._findKeyIndex=function(g,k){var K=this.mKeyIndex[g];var s=this.mServiceKey[g];var m=this.mMultiUnitKey[g];for(var i=0;i<this.mLength[g];i++){if(K[i]<0){if(m[i]==k){return i;}}else if(s[K[i]]==k){return i;}}return-1;};
f.prototype._setServiceKey=function(k,s){if(!this.mServiceKey[k.sGroupId]){this.mServiceKey[k.sGroupId]=[];}if(!this.mKeyIndex[k.sGroupId]){this.mKeyIndex[k.sGroupId]=[];}var n=this.mServiceKey[k.sGroupId][k.iServiceKeyIndex]===undefined;this.mServiceKey[k.sGroupId][k.iServiceKeyIndex++]=s;this.mKeyIndex[k.sGroupId][k.iIndex++]=k.iServiceKeyIndex-1;return n;};
f.prototype._setAdjacentMultiUnitKeys=function(k,m,M){if(!this.mServiceKey[k.sGroupId]){this.mServiceKey[k.sGroupId]=[];}if(!this.mKeyIndex[k.sGroupId]){this.mKeyIndex[k.sGroupId]=[];}if(!this.mMultiUnitKey[k.sGroupId]){this.mMultiUnitKey[k.sGroupId]=[];}--k.iIndex;--k.iServiceKeyIndex;this.mMultiUnitKey[k.sGroupId][k.iIndex]=this.oModel._getKey(m.oEntry);this.mKeyIndex[k.sGroupId][k.iIndex++]=k.iServiceKeyIndex>0?-k.iServiceKeyIndex:"ZERO";var n=0;for(var i=0;i<M.length;i++){if(!this.mServiceKey[k.sGroupId][k.iServiceKeyIndex]){++n;}this.mServiceKey[k.sGroupId][k.iServiceKeyIndex++]=this.oModel._getKey(M[i]);}return n;};
f.prototype._mergeLoadedKeyIndexWithSubsequentIndexes=function(k,e,s,I){var K=this.mKeyIndex[k.sGroupId],g=this.mServiceKey[k.sGroupId],m=this.mMultiUnitKey[k.sGroupId],D=0,n=k.iServiceKeyIndex,h=k.iIndex;var M,o;if(K===undefined){return D;}var N=false;var p=g[n-1],j=g[n];if(j===undefined){return D;}if(p===undefined){Q.sap.log.fatal("assertion failed: missing expected entry before given key index");return D;}var P=this.oModel.getObject("/"+p);var l=this.oModel.getObject("/"+j);var q="",r="";for(var i=0;i<e.length;i++){q+=P[e[i]]+"|";r+=l[e[i]]+"|";}N=q==r;var u=h;if(u>=this.mLength[k.sGroupId]){Q.sap.log.fatal("assertion failed: service key exists,but no corresponding key index found");return D;}while(K[u]===undefined||Math.abs(K[u])<n){++u;}if(N){if(Math.abs(K[u])==n&&K[u]<0){if(u>h){if(K[h-1]<0){m[u]=undefined;K.splice(h,u-h+1);m.splice(h,u-h+1);}else{K[h-1]=-K[h-1];m[h-1]=m[u];m[u]=undefined;K.splice(h,u-h+1);m.splice(h,u-h+1);D=1;}}}else if(Math.abs(K[u])>n){var v=u-1;if(K[v]>0){M=this._createMultiUnitRepresentativeEntry(k.sGroupId,P,s,undefined,I);o=this.oModel._getKey(M.oEntry);K[v]=-K[v];m[v]=o;if(v>h){K.splice(h,v-h);m.splice(h,v-h);}if(M.bIsNewEntry){D=1;}else{D=0;}}else if(K[h-1]<0){if(u>h){m[v]=undefined;K.splice(h,v-h+1);m.splice(h,v-h+1);}}else{K[h-1]=-K[h-1];m[h-1]=m[v];m[v]=undefined;K.splice(h,v-h+1);m.splice(h,v-h+1);}}else if(K[u]==n){if(u>h){if(K[h-1]<0){K.splice(h,u-h+1);m.splice(h,u-h+1);D=1;}else{M=this._createMultiUnitRepresentativeEntry(k.sGroupId,P,s,undefined,I);o=this.oModel._getKey(M.oEntry);if(!M.bIsNewEntry){Q.sap.log.fatal("assertion failed: multi-unit entry already existed before");}K[h-1]=-K[h-1];m[h-1]=o;K.splice(h,u-h+1);m.splice(h,u-h+1);D=1;}}}else{Q.sap.log.fatal("assertion failed: uncovered case detected");return D;}}else if(K[u]>n){Q.sap.log.fatal("unstable query result for group ID "+k.sGroupId+": entries have been removed or added. Complete reload required");}else if(u-h>0){K.splice(h,u-h);m.splice(h,u-h);}return D;};
f.prototype._createMultiUnitRepresentativeEntry=function(g,r,s,D,i){var m=Q.extend(true,{},r);var R=[];for(var M in this.oMeasureDetailsSet){var o=this.oMeasureDetailsSet[M];if(!i&&!this.mAnalyticalInfoByProperty[M].total){if(o.rawValuePropertyName!=undefined){m[o.rawValuePropertyName]=undefined;}if(o.formattedValuePropertyName!=undefined){m[o.formattedValuePropertyName]=undefined;}}else{if(o.rawValuePropertyName!=undefined){m[o.rawValuePropertyName]=null;}if(o.formattedValuePropertyName!=undefined){m[o.formattedValuePropertyName]="*";}}if(D){if(!o.unitPropertyName||Q.inArray(o.unitPropertyName,D)==-1){R.push(o.rawValuePropertyName);}}}for(var k=0;k<s.length;k++){if(Q.inArray(s[k],D)!=-1){m[s[k]]="*";}}var e="";for(var l=0;l<this.aAllDimensionSortedByName.length;l++){var h=m[this.aAllDimensionSortedByName[l]];var j=h===""?'""':h;j=j===undefined?"":j;e+=(j+",");}e+="-multiple-units-not-dereferencable";var n;if(this.mMultiUnitKey[g]&&(n=Q.inArray(e,this.mMultiUnitKey[g]))!=-1){return{oEntry:this.oModel.getObject("/"+e),bIsNewEntry:false,iIndex:n,aReloadMeasurePropertyName:R};}m.__metadata.uri=e;delete m.__metadata["self"];delete m.__metadata["self_link_extensions"];m["^~volatile"]=true;this.oModel._importData(m,{},{});var p=this.oModel._getKey(m);this.oModel.getContext('/'+p)["_volatile"]=true;return{oEntry:m,bIsNewEntry:true,aReloadMeasurePropertyName:R};};
f.prototype._clearAllPendingRequests=function(){this.oPendingRequests={};this.oGroupedRequests={};};
f.prototype.resetData=function(o){var g=o?o.getPath():undefined;this._resetData(g);};
f.prototype._resetData=function(g){if(g){delete this.mServiceKey[g];delete this.mServiceLength[g];delete this.mServiceFinalLength[g];delete this.mKeyIndex[g];delete this.mLength[g];delete this.mMultiUnitKey[g];delete this.mEntityKey[g];}else{this.mServiceKey={};this.mServiceLength={};this.mServiceFinalLength={};this.mFinalLength=this.mServiceFinalLength;this.mKeyIndex={};this.mLength={};this.mMultiUnitKey={};this.mEntityKey={};}};
f.prototype.refresh=function(e){f.prototype._refresh.apply(this,arguments);};
f.prototype._refresh=function(e,m,E){var g=false;if(!e){if(E){var r=this.oModel.resolve(this.sPath,this.oContext);var o=this.oModel.oMetadata._getEntityTypeByPath(r);if(o&&(o.entityType in E)){g=true;}}if(m&&!g){Q.each(this.mServiceKey,function(i,n){Q.each(n,function(i,k){if(k in m){g=true;return false;}});if(g){return false;}});}if(!m&&!E){g=true;}}if(e||g){this._abortAllPendingRequests();this.resetData();this.bNeedsUpdate=false;this._fireRefresh({reason:C.Refresh});}};
f.prototype.checkUpdate=function(e,m){var g=false;if(!e){if(this.bNeedsUpdate||!m){g=true;}else{Q.each(this.mServiceKey,function(i,n){Q.each(n,function(i,k){if(k in m){g=true;return false;}});if(g){return false;}});}}if(e||g){this.bNeedsUpdate=false;this._fireChange({reason:C.Change});}};
f.prototype.getDownloadUrl=function(s){var o=new d.QueryResultRequest(this.oAnalyticalQueryResult);o.setResourcePath(this._getResourcePath());var e=[];var g=[];for(var D in this.oDimensionDetailsSet){e.push(D);}o.setAggregationLevel(e);for(var h in this.oDimensionDetailsSet){var n=this.oDimensionDetailsSet[h];var I=(n.textPropertyName!=undefined);o.includeDimensionKeyTextAttributes(n.name,true,I,n.aAttributeName);}for(var M in this.oMeasureDetailsSet){g.push(M);}o.setMeasures(g);for(var p in this.oMeasureDetailsSet){var q=this.oMeasureDetailsSet[p];var r=(q.rawValuePropertyName!=undefined);var u=(q.formattedValuePropertyName!=undefined);var v=(q.unitPropertyName!=undefined);o.includeMeasureRawFormattedValueUnit(q.name,r,u,v);}var w=o.getSortExpression();w.clear();for(var i=0;i<this.aSorter.length;i++){if(this.aSorter[i]){w.addSorter(this.aSorter[i].sPath,this.aSorter[i].bDescending?d.SortOrder.Descending:d.SortOrder.Ascending);}}var x=o.getFilterExpression();x.clear();if(this.aApplicationFilter){x.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){x.addUI5FilterConditions(this.aControlFilter);}var P=o.getURIToQueryResultEntitySet();var y=this._getQueryODataRequestOptions(o);if(!y){return undefined;}var E=[];for(var k=0,m=this.aAnalyticalInfo.length;k<m;k++){var z=this.aAnalyticalInfo[k];if((z.visible||z.inResult)&&z.name!==""&&z.name!==E[E.length-1]){E.push(z.name);if(this.oMeasureDetailsSet[z.name]!=undefined&&this.oMeasureDetailsSet[z.name].unitPropertyName!=undefined){E.push(this.oMeasureDetailsSet[z.name].unitPropertyName);}}}for(var j=0,l=y.length;j<l;j++){if(/^\$select/i.test(y[j])){y[j]="$select="+E.join(",");break;}}if(s){y.splice(0,0,"$format="+encodeURIComponent(s));}if(this.sCustomParams){y.push(this.sCustomParams);}if(P){return this.oModel._createRequestUrl(P,null,y);}};
return f;});
sap.ui.predefine('sap/ui/model/analytics/AnalyticalTreeBindingAdapter',['jquery.sap.global','sap/ui/model/TreeBinding','./AnalyticalBinding','sap/ui/model/TreeAutoExpandMode','sap/ui/model/ChangeReason','sap/ui/model/odata/ODataTreeBindingAdapter','sap/ui/model/TreeBindingAdapter','sap/ui/model/TreeBindingUtils'],function(q,T,A,a,C,O,b,c){"use strict";var d=function(){if(!(this instanceof T)||this._bIsAdapted){return;}O.apply(this);for(var f in d.prototype){if(d.prototype.hasOwnProperty(f)){this[f]=d.prototype[f];}}this.setAutoExpandMode(this.mParameters.autoExpandMode||a.Bundled);};
d.prototype.getGrandTotalContext=function(){if(this._oRootNode){return this._oRootNode.context;}};
d.prototype.getGrandTotalNode=function(){if(this._oRootNode){return this._oRootNode;}};
d.prototype.getGrandTotalContextInfo=function(){return this._oRootNode;};
d.prototype.getLength=function(){if(!this._oRootNode){return 0;}if(this._oRootNode&&this._oWatermark&&this._isRunningInAutoExpand(a.Bundled)){if(this._oWatermark.groupID===this._oRootNode.groupID){return this._oRootNode.magnitude+this._oRootNode.numberOfTotals;}return this._oWatermark.absoluteNodeIndex+this._oRootNode.numberOfTotals+1;}return this._oRootNode.magnitude+this._oRootNode.numberOfTotals;};
d.prototype.getContextByIndex=function(i){if(this._oRootNode&&i===(this.getLength()-1)&&this.providesGrandTotal()&&this.hasTotaledMeasures()){return this._oRootNode.context;}var n=this.findNode(i);if(!n||!n.context){n={context:this.getContexts(i,1,0)[0]};}return n?n.context:undefined;};
d.prototype.getNodeByIndex=function(i){if(i===(this.getLength()-1)&&this.providesGrandTotal()&&this.hasTotaledMeasures()){return this._oRootNode;}if(i>=this.getLength()){return undefined;}return this.findNode(i);};
d.prototype._isNodeSelectable=function(n){if(!n){return false;}return n.isLeaf&&!n.isArtificial;};
d.prototype.getContexts=function(s,l,t,r){if(!l){l=this.oModel.iSizeLimit;}if(!t){t=0;}this._iPageSize=l;this._iThreshold=Math.max(this._iThreshold,t);this._aRowIndexMap=[];this._buildTree(s,l);var n=[];if(this._oRootNode){n=this._retrieveNodeSection(this._oRootNode,s,l);}this._updateRowIndexMap(n,s);var e=[];var m;for(var i=0;i<n.length;i++){var N=n[i];if(this._isRunningInAutoExpand(a.Bundled)&&this._oWatermark){if(N.groupID===this._oWatermark.groupID||(this._oWatermark.groupID===this._oRootNode.groupID&&(s+i+1)==this.getLength()-1)){this._autoExpandPaging();}}if(!N.context){m=m||{};var p=N.parent;m[p.groupID]=p;this._updateNodeSections(p.groupID,{startIndex:N.positionInParent,length:1});}e.push(N.context);}if(m){var f=this;q.each(m,function(g,N){N.magnitude=0;N.numberOfTotals=0;f._loadChildContexts(N,{absoluteNodeIndex:N.absoluteNodeIndex});});e=[];for(var j=0;j<n.length;j++){var N=n[j];e.push(N.context);}}if(r){return n;}else{return e;}};
d.prototype._autoExpandPaging=function(){var e=this.getNodeContexts(this._oWatermark.context,{startIndex:this._oWatermark.startIndex,length:this._iPageSize,threshold:this._iThreshold,level:this._oWatermark.level,numberOfExpandedLevels:this._oWatermark.autoExpand});return e;};
d.prototype._afterMatchHook=function(n,r,m,M,p,P){if(n.sumNode&&n!==this._oRootNode){if(r.length===m){return true;}var N=M.call(this,n.sumNode,n.sumNode.positionInParent,P);if(N){r.push(n.sumNode);}}};
d.prototype._afterMapHook=function(n,m){if(n.sumNode&&n!==this._oRootNode){m.call(this,n.sumNode);}};
d.prototype._createSumNode=function(n){var s;if(this.bProvideGrandTotals&&!this.mParameters.sumOnTop&&this.hasTotaledMeasures()&&n.children.length>1){s=this._createNode({parent:n.parent,positionInParent:n.children.length,context:n.context,level:n.level});s.nodeState=this._createNodeState({groupID:s.groupID,sum:true,expanded:false});}return s;};
d.prototype._buildTree=function(s,l){this._oRootNode=undefined;this._oWatermark=undefined;var n=this.mParameters&&this.getNumberOfExpandedLevels();var r=this.getRootContexts({startIndex:0,length:this._iPageSize,threshold:this._iThreshold,numberOfExpandedLevels:this._autoExpandMode===a.Bundled?n:undefined});var R;if(r==null){q.sap.log.warning("AnalyticalTreeBindingAdapter: No Dimensions given. An artificial rootContext has be created. Please check your Table/Service definition for dimension columns!");}else{R=r[0];}if(!R){return;}var o=this._getNodeState("/");if(!o){o=this._updateTreeState({groupID:"/",expanded:true,sum:true});this._updateNodeSections("/",{startIndex:0,length:l});}this._oRootNode=this._createNode({context:R,parent:null,level:0,nodeState:o,isLeaf:false,autoExpand:n,absoluteNodeIndex:-1});this._oRootNode.isArtificial=true;this._loadChildContexts(this._oRootNode,{absoluteNodeIndex:-1});};
d.prototype._loadChildContexts=function(n,r){var N=n.nodeState;var m=this.getGroupSize(n.context,n.level);if(m>=0){if(!n.children[m-1]){n.children[m-1]=undefined;}if(n.level===this.aAggregationLevel.length){N.leafCount=m;}n.sumNode=this._createSumNode(n);}for(var i=0;i<N.sections.length;i++){var o=N.sections[i];if(o.startIndex>n.children.length){continue;}var R;if(m===-1){R=o.length;}else{R=Math.min(o.length,m-o.startIndex);}var s=false;if(n.autoExpand>=0&&this._isRunningInAutoExpand(a.Bundled)){s=true;R=Math.max(0,m);}var e=this.getNodeContexts(n.context,{startIndex:o.startIndex,length:R,threshold:s?0:this._iThreshold,level:n.level,supressRequest:s});for(var j=0;j<e.length;j++){var f=e[j];var g=j+o.startIndex;var h=n.children[g];var u={context:e[j],parent:n,level:n.level+1,positionInParent:g,autoExpand:Math.max(n.autoExpand-1,-1),absoluteNodeIndex:(++r.absoluteNodeIndex)};if(h){h.context=u.context;h.parent=u.parent;h.level=u.level;h.positionInParent=u.positionInParent;h.magnitude=0;h.numberOfTotals=0;h.totalNumberOfLeafs=0;h.autoExpand=u.autoExpand;h.absoluteNodeIndex=u.absoluteNodeIndex;var G;if(f){G=this._calculateGroupID(h);}h.groupID=G;}else{h=this._createNode(u);}h.nodeState=this._getNodeState(h.groupID);if(!h.nodeState){h.nodeState=this._createNodeState({groupID:h.groupID,expanded:false});}h.nodeState.parentGroupID=n.groupID;h.isLeaf=!this.nodeHasChildren(h);n.children[g]=h;if(h.isLeaf){n.numberOfLeafs+=1;}if(h.parent.nodeState.selectAllMode&&!this._mTreeState.deselected[h.groupID]&&h.isLeaf){this.setNodeSelection(h.nodeState,true);}if((h.autoExpand>=0||h.nodeState.expanded)&&this.isGrouped()){if(!this._mTreeState.collapsed[h.groupID]){if(h.autoExpand>=0&&h.parent.nodeState.selectAllMode&&!this._mTreeState.deselected[h.groupID]){if(h.nodeState.selectAllMode===undefined){h.nodeState.selectAllMode=true;}}this._updateTreeState({groupID:h.nodeState.groupID,fallbackNodeState:h.nodeState,expanded:true});this._loadChildContexts(h,r);}n.magnitude+=h.magnitude;n.numberOfTotals+=h.numberOfTotals;n.numberOfLeafs+=h.numberOfLeafs;}if(h&&h.isLeaf){n.totalNumberOfLeafs=m;}else{n.totalNumberOfLeafs+=h.totalNumberOfLeafs;}}}m=this._isRunningInAutoExpand(a.Bundled)?n.children.length:m;n.magnitude+=Math.max(m||0,0);if(!m&&!this._isRunningInAutoExpand(a.Bundled)){q.sap.log.warning("AnalyticalTreeBindingAdapter: iMaxGroupSize("+m+") is undefined for node '"+n.groupID+"'!");}if(n.sumNode||(n===this._oRootNode&&this.providesGrandTotal()&&this.hasTotaledMeasures())){n.numberOfTotals+=1;}if(this._isRunningInAutoExpand(a.Bundled)&&n.autoExpand!=-1){if(!this._oWatermark&&!n.isLeaf&&!this.mFinalLength[n.groupID]){this._oWatermark={groupID:n.groupID,context:n.context,absoluteNodeIndex:n.absoluteNodeIndex,startIndex:n.children.length,level:n.level,autoExpand:n.autoExpand};}}};
d.prototype._calculateGroupID=function(n){var g;var m=this.aAggregationLevel.length;if(!this.isGrouped()&&n&&n.positionInParent){g="/"+n.positionInParent+"/";}else{if(n.level>m){g=this._getGroupIdFromContext(n.context,m);g+=n.positionInParent+"/";}else{g=this._getGroupIdFromContext(n.context,n.level);}}return g;};
d.prototype.collapse=function(p){var n,N;if(typeof p==="object"){n=p;}else if(typeof p==="number"){N=this.findNode(p);if(!N){return;}n=N.nodeState;}this._updateTreeState({groupID:n.groupID,expanded:false});n.selectAllMode=false;var e=false;if(this.bCollapseRecursive||this._isRunningInAutoExpand(a.Bundled)){var g=n.groupID;if(this._isRunningInAutoExpand(a.Bundled)&&this._oWatermark&&q.sap.startsWith(this._oWatermark.groupID,g)){if(N&&N.parent){this._oWatermark={groupID:N.parent.groupID,context:N.parent.context,absoluteNodeIndex:N.parent.absoluteNodeIndex,startIndex:N.positionInParent+1,level:N.parent.level,autoExpand:N.parent.autoExpand};}this._autoExpandPaging();e=true;}var t=this;q.each(this._mTreeState.expanded,function(G,o){if(q.sap.startsWith(G,g)){t._updateTreeState({groupID:G,expanded:false});}});var D=[];q.each(this._mTreeState.selected,function(G,o){if(q.sap.startsWith(G,g)){o.selectAllMode=false;t.setNodeSelection(o,false);D.push(G);}});if(D.length){var s={rowIndices:[]};var i=0;this._map(this._oRootNode,function(N){if(!N||!N.isArtificial){i++;}if(N&&D.indexOf(N.groupID)!==-1){if(N.groupID===this._sLeadSelectionGroupID){s.oldIndex=i;s.leadIndex=-1;}s.rowIndices.push(i);}});this._publishSelectionChanges(s);}}if(!e){this._fireChange({reason:C.Collapse});}};
d.prototype.collapseToLevel=function(l){this.setNumberOfExpandedLevels(l,true);b.prototype.collapseToLevel.call(this,l);};
d.prototype.nodeHasChildren=function(n){if(!n||!n.parent||n.nodeState.sum){return false;}else if(n.isArtificial){return true;}else{return A.prototype.hasChildren.call(this,n.context,{level:n.level});}};
d.prototype.resetData=function(o,p){var r=A.prototype.resetData.call(this,o,p);this._aRowIndexMap=[];this._oRootNode=undefined;this._oWatermark=undefined;this._iPageSize=0;this._iThreshold=0;if(!p||p.reason!==C.Sort){this.clearSelection();this._createTreeState(true);}return r;};
d.prototype.hasTotaledMeasures=function(){var h=false;q.each(this.getMeasureDetails()||[],function(i,m){if(m.analyticalInfo.total){h=true;return false;}});return h;};
d.prototype.isGrouped=function(){return(this.aAggregationLevel.length>0);};
d.prototype._isRunningInAutoExpand=function(s){if(this.getNumberOfExpandedLevels()>0&&this._autoExpandMode===s){return true;}else{return false;}};
d.prototype.setNumberOfExpandedLevels=function(l,s){l=l||0;if(l<0){q.sap.log.warning("AnalyticalTreeBindingAdapter: numberOfExpanded levels was set to 0. Negative values are prohibited.");l=0;}if(!s){this.resetData();}this.mParameters.numberOfExpandedLevels=l;};
d.prototype.getNumberOfExpandedLevels=function(){return this.mParameters.numberOfExpandedLevels;};
d.prototype._getSelectableNodesCount=function(n){if(n){return n.totalNumberOfLeafs;}else{return 0;}};
return d;},true);
sap.ui.predefine('sap/ui/model/analytics/AnalyticalVersionInfo',['jquery.sap.global'],function(q){"use strict";var A={NONE:null,V1:1,V2:2,getVersion:function(o){var v;var O;if(o&&o.getMetadata){O=o.getMetadata().getName();}switch(O){case"sap.ui.model.odata.ODataModel":v=this.V1;break;case"sap.ui.model.odata.v2.ODataModel":v=this.V2;break;default:v=this.NONE;q.sap.log.info("AnalyticalVersionInfo.getVersion(...) - The given object is no instance of ODataModel V1 or V2!");break;}return v;}};return A;},true);
sap.ui.predefine('sap/ui/model/analytics/BatchResponseCollector',function(){"use strict";
function B(p){if(p){this.setup(p);}}
B.TYPE_SUCCESS="success";B.TYPE_ERROR="error";
B.prototype.setup=function(p){this.iRequestCollectionCount=0;this.aCollectedSuccesses=[];this.aCollectedErrors=[];this.aExecutedRequestDetails=p.executedRequests;this.oAnalyticalBinding=p.binding;this.fnSuccessHandler=p.success;this.fnErrorHandler=p.error;};
B.prototype.success=function(r){this.collect(r,B.TYPE_SUCCESS);};
B.prototype.error=function(r){this.collect(r,B.TYPE_ERROR);};
B.prototype.collect=function(r,R){this.iRequestCollectionCount++;if(R===B.TYPE_SUCCESS){this.aCollectedSuccesses.push(r);}else{this.aCollectedErrors.push(r);}var o=(this.aCollectedSuccesses.length+this.aCollectedErrors.length);if(o===this.aExecutedRequestDetails.length){if((this.aCollectedSuccesses.length===o)&&this.aCollectedErrors.length===0){this.fnSuccessHandler.call(window,{__batchResponses:this.aCollectedSuccesses},{requestUri:this.oAnalyticalBinding.oModel.sServiceUrl+"/$batch"});}else{this.fnErrorHandler.call(window,this.aCollectedErrors[0]||{});}}};
return B;},true);
sap.ui.predefine('sap/ui/model/analytics/ODataModelAdapter',['jquery.sap.global','./AnalyticalBinding',"./AnalyticalTreeBindingAdapter",'./odata4analytics','./AnalyticalVersionInfo'],function(q,A,a,o,b){"use strict";var O=function(){var m=b.getVersion(this);if(this.iModelVersion===b.NONE||this.getAnalyticalExtensions){return;}this._mPreadapterFunctions={bindList:this.bindList,bindTree:this.bindTree};for(var f in O.prototype){if(O.prototype.hasOwnProperty(f)){this[f]=O.prototype[f];}}if(m===b.V1&&this.isCountSupported()){q.sap.log.info("ODataModelAdapter: switched ODataModel to use inlinecount (mandatory for the AnalyticalBinding)");this.setCountSupported(false);}};
O.prototype.bindList=function(p,c,s,f,P){if(P&&P.analyticalInfo){var B=new A(this,p,c,s,f,P);a.apply(B);return B;}else{return this._mPreadapterFunctions.bindList.apply(this,arguments);}};
O.prototype.bindTree=function(p,c,f,P){if(P&&P.analyticalInfo){var B=new A(this,p,c,[],f,P);return B;}else{return this._mPreadapterFunctions.bindTree.apply(this,arguments);}};
O.prototype.getAnalyticalExtensions=function(){if(this.oOData4SAPAnalyticsModel!=undefined&&this.oOData4SAPAnalyticsModel!=null){return this.oOData4SAPAnalyticsModel;}var m=b.getVersion(this);if(m===b.V2&&!(this.oMetadata&&this.oMetadata.isLoaded())){throw"Failed to get the analytical extensions. The metadata have not been loaded by the model yet."+"Register for the 'metadataLoaded' event of the ODataModel(v2) to know when the analytical extensions can be retrieved.";}var s=null;if(arguments.length==1){var c=arguments[0];var r=q.sap.syncGetText(c);if(r.success){s=r.data;}}try{this.oOData4SAPAnalyticsModel=new o.Model(new o.Model.ReferenceByModel(this),{sAnnotationJSONDoc:s});}catch(e){throw"Failed to instantiate analytical extensions for given OData model: "+e.message;}return this.oOData4SAPAnalyticsModel;};
O.prototype.setAnalyticalExtensions=function(c){this.oOData4SAPAnalyticsModel=c;};
return O;},true);
sap.ui.predefine('sap/ui/model/analytics/odata4analytics',['jquery.sap.global','sap/ui/model/Filter','sap/ui/model/FilterOperator','sap/ui/model/Sorter','./AnalyticalVersionInfo'],function(q,F,c,S,A){"use strict";var o=o||{};o.constants={};o.constants["SAP_NAMESPACE"]="http://www.sap.com/Protocols/SAPData";o.constants["VERSION"]="0.7";o.helper={tokenizeNametoLabelText:function(n){var l="";l=n.replace(/^P_(.*)/,"$1");l=l.replace(/([^A-Z0-9_]+)([A-Z0-9_])/g,"$1 $2");l=l.replace(/([A-Z0-9_]{2,})([A-Z0-9_])([^A-Z0-9_]+)/g,"$1 $2$3");l=l.replace(/(.*) _E$/,"$1");l=l.replace(/(.*) _(.*)/g,"$1 $2");return l;}};
o.Model=function(m,p){this._init(m,p);};
o.Model.ReferenceByURI=function(u){return{sServiceURI:u};};
o.Model.ReferenceByModel=function(m){return{oModel:m};};
o.Model.ReferenceWithWorkaround=function(m,w){return{oModelReference:m,aWorkaroundID:w};};
o.Model.prototype={_init:function(m,p){if(typeof p=="string"){throw"Deprecated second argument: Adjust your invocation by passing an object with a property sAnnotationJSONDoc as a second argument instead";}this._mParameter=p;var t=this;this._oActivatedWorkarounds={};if(m&&m.aWorkaroundID){for(var i=-1,I;(I=m.aWorkaroundID[++i])!==undefined;){this._oActivatedWorkarounds[I]=true;}m=m.oModelReference;}if(!m||(!m.sServiceURI&&!m.oModel)){throw"Usage with oModelReference being an instance of Model.ReferenceByURI or Model.ReferenceByModel";}if(m.oModel){this._oModel=m.oModel;this._iVersion=A.getVersion(this._oModel);a();}else{if(p&&p.modelVersion===A.V2){var V=sap.ui.requireSync("sap/ui/model/odata/v2/ODataModel");this._oModel=new V(m.sServiceURI);this._iVersion=A.V2;a();}else{var O=sap.ui.requireSync("sap/ui/model/odata/ODataModel");this._oModel=new O(m.sServiceURI);this._iVersion=A.V1;a();}}if(this._oModel.getServiceMetadata().dataServices==undefined){throw"Model could not be loaded";}function a(){if(!t._oModel.getServiceMetadata()){t._oModel.attachMetadataLoaded(b);}else{b();}}function b(){if(t.bIsInitialized){return;}t.bIsInitialized=true;if(p&&p.sAnnotationJSONDoc){t.mergeV2Annotations(p.sAnnotationJSONDoc);}t._interpreteMetadata(t._oModel.getServiceMetadata().dataServices);}},_interpreteMetadata:function(M){this._oQueryResultSet={};this._oParameterizationSet={};this._oEntityTypeSet={};this._oEntitySetSet={};this._oEntityTypeNameToEntitySetMap={};var a=this._oModel.getServiceMetadata().dataServices.schema[0];for(var j=-1,C;(C=a.entityContainer[++j])!==undefined;){if(C.isDefaultEntityContainer=="true"){this._oDefaultEntityContainer=C;break;}}var e=a.entityType;var Q=[],P=[],u=[];for(var k=-1,T;(T=e[++k])!==undefined;){var b=false;if(T.extensions!=undefined){for(var l=-1,E;(E=T.extensions[++l])!==undefined;){if(E.namespace==o.constants.SAP_NAMESPACE&&E.name=="semantics"){b=true;switch(E.value){case"aggregate":Q.push(T);break;case"parameters":P.push(T);break;default:u.push(T);}}if(b){continue;}}if(!b){u.push(T);}}else{u.push(T);}}for(var m=-1,d;(d=u[++m])!==undefined;){var f=new o.EntityType(this._oModel.getServiceMetadata(),a,d);this._oEntityTypeSet[f.getQName()]=f;var g=this._getEntitySetsOfType(a,f.getQName());if(g.length==0){throw"Invalid consumption model: No entity set for entity type "+f.getQName()+" found";}if(g.length>1){throw"Unsupported consumption model: More than one entity set for entity type "+f.getQName()+" found";}var h=new o.EntitySet(this._oModel.getServiceMetadata(),a,g[0][0],g[0][1],f);this._oEntitySetSet[h.getQName()]=h;this._oEntityTypeNameToEntitySetMap[f.getQName()]=h;}var i={};for(var n=-1,v;(v=P[++n])!==undefined;){var w=new o.EntityType(this._oModel.getServiceMetadata(),a,v);this._oEntityTypeSet[w.getQName()]=w;var x=this._getEntitySetsOfType(a,w.getQName());if(x.length==0){throw"Invalid consumption model: No entity set for parameter entity type "+w.getQName()+" found";}if(x.length>1){throw"Unsupported consumption model: More than one entity set for parameter entity type "+w.getQName()+" found";}var y=new o.EntitySet(this._oModel.getServiceMetadata(),a,x[0][0],x[0][1],w);this._oEntitySetSet[y.getQName()]=y;this._oEntityTypeNameToEntitySetMap[w.getQName()]=y;var z=new o.Parameterization(w,y);this._oParameterizationSet[z.getName()]=z;i[w.getQName()]=z;var B=w.getQName();if(a.association!=undefined){for(var p=-1,D;(D=a.association[++p])!==undefined;){if(D.referentialConstraint==undefined){continue;}var G=null;if(D.end[0].type==B&&D.end[0].multiplicity=="*"&&D.end[1].multiplicity=="1"){G=D.end[1].type;}else if(D.end[1].type==B&&D.end[1].multiplicity=="*"&&D.end[0].multiplicity=="1"){G=D.end[0].type;}if(!G){continue;}if(D.referentialConstraint.dependent.propertyRef.length!=1){continue;}var H=z.findParameterByName(D.referentialConstraint.dependent.propertyRef[0].name);if(H==null){continue;}var V=this._oEntityTypeSet[G];var I=this._oEntityTypeNameToEntitySetMap[G];H.setValueSetEntity(V,I);}}}for(var r=-1,J;(J=Q[++r])!==undefined;){var K=new o.EntityType(this._oModel.getServiceMetadata(),a,J);this._oEntityTypeSet[K.getQName()]=K;var L=K.getQName();var N=null;var O=null;if(a.association!=undefined){for(var s=-1,R;(R=a.association[++s])!==undefined;){var U=null;if(R.end[0].type==L){U=R.end[1].type;}else if(R.end[1].type==L){U=R.end[0].type;}else{continue;}var W=null;W=i[U];if(W!=null){if(N!=null){throw"LIMITATION: Unable to handle multiple parameter entity types of query entity "+K.name;}else{N=W;O=R;}}}}var X=this._getEntitySetsOfType(a,K.getQName());if(X.length!=1){throw"Invalid consumption model: There must be exactly one entity set for an entity type annotated with aggregating semantics";}var Y=new o.EntitySet(this._oModel.getServiceMetadata(),a,X[0][0],X[0][1],K);this._oEntitySetSet[Y.getQName()]=Y;this._oEntityTypeNameToEntitySetMap[K.getQName()]=Y;var Z=new o.QueryResult(this,K,Y,N);this._oQueryResultSet[Z.getName()]=Z;if(N){N.setTargetQueryResult(Z,O);}if(a.association!=undefined){for(var t=-1,$;($=a.association[++t])!==undefined;){if($.referentialConstraint==undefined){continue;}var _=null;if($.end[0].type==L&&$.end[0].multiplicity=="*"&&$.end[1].multiplicity=="1"){_=$.end[1].type;}else if($.end[1].type==L&&$.end[1].multiplicity=="*"&&$.end[0].multiplicity=="1"){_=$.end[0].type;}if(!_){continue;}if($.referentialConstraint.dependent.propertyRef.length!=1){continue;}var a1=Z.findDimensionByName($.referentialConstraint.dependent.propertyRef[0].name);if(a1==null){continue;}var b1=this._oEntityTypeNameToEntitySetMap[_];a1.setMembersEntitySet(b1);}}}},oUI5ODataModelAnnotatableObject:{objectName:"schema",keyPropName:"namespace",extensions:true,aSubObject:[{objectName:"entityType",keyPropName:"name",extensions:true,aSubObject:[{objectName:"property",keyPropName:"name",aSubObject:[],extensions:true}]},{objectName:"entityContainer",keyPropName:"name",extensions:false,aSubObject:[{objectName:"entitySet",keyPropName:"name",extensions:true,aSubObject:[]}]}]},mergeV2Annotations:function(a){var b=null;try{b=JSON.parse(a);}catch(e){return;}var m;try{m=this._oModel.getServiceMetadata().dataServices;}catch(e){return;}for(var p in b){if(!(this.oUI5ODataModelAnnotatableObject.objectName==p)){continue;}if(!(b[p]instanceof Array)){continue;}this.mergeV2AnnotationLevel(m[this.oUI5ODataModelAnnotatableObject.objectName],b[this.oUI5ODataModelAnnotatableObject.objectName],this.oUI5ODataModelAnnotatableObject);break;}return;},mergeV2AnnotationLevel:function(M,a,u){for(var i=-1,b;(b=a[++i])!==undefined;){for(var j=-1,d;(d=M[++j])!==undefined;){if(!(b[u.keyPropName]==d[u.keyPropName])){continue;}if(b["extensions"]!=undefined){if(d["extensions"]==undefined){d["extensions"]=[];}for(var l=-1,e;(e=b["extensions"][++l])!==undefined;){var f=false;for(var m=-1,g;(g=d["extensions"][++m])!==undefined;){if(e.name==g.name&&e.namespace==g.namespace){g.value=e.value;f=true;break;}}if(!f){d["extensions"].push(e);}}}for(var k=-1,U;(U=u.aSubObject[++k])!==undefined;){for(var p in b){if(!(U.objectName==p)){continue;}if(!(b[U.objectName]instanceof Array)){continue;}if((d[U.objectName]==undefined)||(!(d[U.objectName]instanceof Array))){continue;}this.mergeV2AnnotationLevel(d[U.objectName],b[U.objectName],U);break;}}}}return;},findQueryResultByName:function(n){var Q=this._oQueryResultSet[n];if(!Q&&this._oDefaultEntityContainer){var s=this._oDefaultEntityContainer.name+"."+n;Q=this._oQueryResultSet[s];}return Q;},getAllQueryResultNames:function(){if(this._aQueryResultNames){return this._aQueryResultNames;}this._aQueryResultNames=new Array(0);for(var n in this._oQueryResultSet){this._aQueryResultNames.push(this._oQueryResultSet[n].getName());}return this._aQueryResultNames;},getAllQueryResults:function(){return this._oQueryResultSet;},getODataModel:function(){return this._oModel;},_getEntitySetsOfType:function(s,Q){var e=[];for(var i=-1,E;(E=s.entityContainer[++i])!==undefined;){for(var j=-1,a;(a=E.entitySet[++j])!==undefined;){if(a.entityType==Q){e.push([E,a]);}}}return e;},_mParameter:null,_oModel:null,_oDefaultEntityContainer:null,_aQueryResultNames:null,_oQueryResultSet:null,_oParameterizationSet:null,_oEntityTypeSet:null,_oEntitySetSet:null,_oEntityTypeNameToEntitySetMap:null,_oActivatedWorkarounds:null};
o.QueryResult=function(m,e,E,p){this._init(m,e,E,p);};
o.QueryResult.prototype={_init:function(m,e,E,p,a){this._oModel=m;this._oEntityType=e;this._oEntitySet=E;this._oParameterization=p;this._oDimensionSet={};this._oMeasureSet={};var P=e.getTypeDescription().property;var b={};for(var i=-1,d;(d=P[++i])!==undefined;){if(d.extensions==undefined){continue;}for(var j=-1,f;(f=d.extensions[++j])!==undefined;){if(!f.namespace==o.constants.SAP_NAMESPACE){continue;}switch(f.name){case"aggregation-role":switch(f.value){case"dimension":{var D=new o.Dimension(this,d);this._oDimensionSet[D.getName()]=D;break;}case"measure":{var M=new o.Measure(this,d);this._oMeasureSet[M.getName()]=M;break;}case"totaled-properties-list":this._oTotaledPropertyListProperty=d;break;default:}break;case"attribute-for":{var g=new o.DimensionAttribute(this,d);var k=g.getKeyProperty();b[k.name]=g;break;}default:}}}for(var s in b){var h=b[s];h.getDimension().addAttribute(h);}if(m._oActivatedWorkarounds.IdentifyTextPropertiesByName){var l=[];for(var n in this._oDimensionSet){var r=this._oDimensionSet[n];if(!r.getTextProperty()){var T=null;T=e.findPropertyByName(n+"Name");if(!T){T=e.findPropertyByName(n+"Text");}if(!T){T=e.findPropertyByName(n+"Desc");}if(!T){T=e.findPropertyByName(n+"Description");}if(T){r.setTextProperty(T);l.push(T.name);}}}for(var t=-1,u;(u=l[++t])!==undefined;){delete this._oDimensionSet[u];}}},getName:function(){return this.getEntitySet().getQName();},getParameterization:function(){return this._oParameterization;},getAllDimensionNames:function(){if(this._aDimensionNames){return this._aDimensionNames;}this._aDimensionNames=[];for(var n in this._oDimensionSet){this._aDimensionNames.push(this._oDimensionSet[n].getName());}return this._aDimensionNames;},getAllDimensions:function(){return this._oDimensionSet;},getAllMeasureNames:function(){if(this._aMeasureNames){return this._aMeasureNames;}this._aMeasureNames=[];for(var n in this._oMeasureSet){this._aMeasureNames.push(this._oMeasureSet[n].getName());}return this._aMeasureNames;},getAllMeasures:function(){return this._oMeasureSet;},findDimensionByName:function(n){return this._oDimensionSet[n];},findDimensionByPropertyName:function(n){if(this._oDimensionSet[n]){return this._oDimensionSet[n];}for(var d in this._oDimensionSet){var D=this._oDimensionSet[d];var t=D.getTextProperty();if(t&&t.name==n){return D;}if(D.findAttributeByName(n)){return D;}}return null;},getTotaledPropertiesListProperty:function(){return this._oTotaledPropertyListProperty;},findMeasureByName:function(n){return this._oMeasureSet[n];},findMeasureByPropertyName:function(n){if(this._oMeasureSet[n]){return this._oMeasureSet[n];}for(var m in this._oMeasureSet){var M=this._oMeasureSet[m];var f=M.getFormattedValueProperty();if(f&&f.name==n){return M;}}return null;},getModel:function(){return this._oModel;},getEntityType:function(){return this._oEntityType;},getEntitySet:function(){return this._oEntitySet;},_oModel:null,_oEntityType:null,_oEntitySet:null,_oParameterization:null,_aDimensionNames:null,_oDimensionSet:null,_aMeasureNames:null,_oMeasureSet:null,_oTotaledPropertyListProperty:null};
o.Parameterization=function(e,E){this._init(e,E);};
o.Parameterization.prototype={_init:function(e,E){this._oEntityType=e;this._oEntitySet=E;this._oParameterSet={};var p=e.getTypeDescription().property;for(var i=-1,P;(P=p[++i])!==undefined;){if(P.extensions==undefined){continue;}for(var j=-1,a;(a=P.extensions[++j])!==undefined;){if(!a.namespace==o.constants.SAP_NAMESPACE){continue;}switch(a.name){case"parameter":{var b=new o.Parameter(this,P);this._oParameterSet[b.getName()]=b;break;}default:}}}},setTargetQueryResult:function(Q,a){this._oQueryResult=Q;var s=this._oEntityType.getSchema().namespace+"."+a.name;var n=this._oEntityType.getTypeDescription().navigationProperty;if(!n){throw"Invalid consumption model: Parameters entity type lacks navigation property for association to query result entity type";}for(var i=-1,N;(N=n[++i])!==undefined;){if(N.relationship==s){this._oNavPropToQueryResult=N.name;}}if(!this._oNavPropToQueryResult){throw"Invalid consumption model: Parameters entity type lacks navigation property for association to query result entity type";}},getTargetQueryResult:function(){if(!this._oQueryResult){throw"No target query result set";}return this._oQueryResult;},getName:function(){return this.getEntitySet().getQName();},getAllParameterNames:function(){if(this._aParameterNames){return this._aParameterNames;}this._aParameterNames=[];for(var n in this._oParameterSet){this._aParameterNames.push(this._oParameterSet[n].getName());}return this._aParameterNames;},getAllParameters:function(){return this._oParameterSet;},findParameterByName:function(n){return this._oParameterSet[n];},getNavigationPropertyToQueryResult:function(){return this._oNavPropToQueryResult;},getEntityType:function(){return this._oEntityType;},getEntitySet:function(){return this._oEntitySet;},_oEntityType:null,_oEntitySet:null,_oQueryResult:null,_oNavPropToQueryResult:null,_aParameterNames:null,_oParameterSet:null};
o.Parameter=function(p,P){this._init(p,P);};
o.Parameter.prototype={_init:function(p,P){this._oParameterization=p;this._oProperty=P;var e=p.getEntityType();if(P.extensions!=undefined){for(var i=-1,E;(E=P.extensions[++i])!==undefined;){if(!E.namespace==o.constants.SAP_NAMESPACE){continue;}switch(E.name){case"parameter":switch(E.value){case"mandatory":this._bRequired=true;break;case"optional":this._bRequired=false;break;default:throw"Invalid annotation value for parameter property";}break;case"label":this._sLabelText=E.value;break;case"text":this._oTextProperty=e.findPropertyByName(E.value);break;case"upper-boundary":this._bIntervalBoundaryParameter=true;this._oUpperIntervalBoundaryParameterProperty=e.findPropertyByName(E.value);break;case"lower-boundary":this._bIntervalBoundaryParameter=true;this._oLowerIntervalBoundaryParameterProperty=e.findPropertyByName(E.value);break;default:}}}if(!this._sLabelText){this._sLabelText="";}},setValueSetEntity:function(e,E){this._oValueSetEntityType=e;this._oValueSetEntitySet=E;},getTextProperty:function(){return this._oTextProperty;},getLabelText:function(){if(!this._sLabelText&&this._oParameterization._oQueryResult._oModel._oActivatedWorkarounds.CreateLabelsFromTechnicalNames){this._sLabelText=o.helper.tokenizeNametoLabelText(this.getName());}return this._sLabelText;},isOptional:function(){return(!this._bRequired);},isIntervalBoundary:function(){return this._bIntervalBoundaryParameter;},isLowerIntervalBoundary:function(){return(this._oUpperIntervalBoundaryParameterProperty?true:false);},getPeerIntervalBoundaryParameter:function(){var p=null;if(this._oLowerIntervalBoundaryParameterProperty){p=this._oLowerIntervalBoundaryParameterProperty.name;}else{p=this._oUpperIntervalBoundaryParameterProperty.name;}if(!p){throw"Parameter is not an interval boundary";}return this._oParameterization.findParameterByName(p);},isValueSetAvailable:function(){return(this._oValueSetEntityType?true:false);},getName:function(){return this._oProperty.name;},getProperty:function(){return this._oProperty;},getContainingParameterization:function(){return this._oParameterization;},getURIToValueEntitySet:function(s){var u=null;u=(s?s:"")+"/"+this._oValueSetEntitySet.getQName();return u;},_oParameterization:null,_oProperty:null,_sLabelText:null,_oTextProperty:null,_bRequired:false,_bIntervalBoundaryParameter:false,_oLowerIntervalBoundaryParameterProperty:null,_oUpperIntervalBoundaryParameterProperty:null,_oValueSetEntityType:null,_oValueSetEntitySet:null};
o.Dimension=function(Q,p){this._init(Q,p);};
o.Dimension.prototype={_init:function(Q,p){this._oQueryResult=Q;this._oProperty=p;this._oAttributeSet={};},setMembersEntitySet:function(e){this._oMembersEntitySet=e;},getName:function(){return this._oProperty.name;},getKeyProperty:function(){return this._oProperty;},getTextProperty:function(){if(!this._oTextProperty){this._oTextProperty=this._oQueryResult.getEntityType().getTextPropertyOfProperty(this.getName());}return this._oTextProperty;},setTextProperty:function(t){this._oTextProperty=t;},getLabelText:function(){if(!this._sLabelText){this._sLabelText=this._oQueryResult.getEntityType().getLabelOfProperty(this.getName());}if(!this._sLabelText&&this._oQueryResult._oModel._oActivatedWorkarounds.CreateLabelsFromTechnicalNames){this._sLabelText=o.helper.tokenizeNametoLabelText(this.getName());}return(this._sLabelText==null?"":this._sLabelText);},getSuperOrdinateDimension:function(){if(!this._sSuperOrdinateDimension){var s=this._oQueryResult.getEntityType().getSuperOrdinatePropertyOfProperty(this.getName()).name;this._sSuperOrdinateDimension=this._oQueryResult.findDimensionByName(s);}return this._sSuperOrdinateDimension;},getHierarchy:function(){if(!this._oHierarchy){this._oHierarchy=this._oQueryResult.getEntityType().getHierarchy(this._oProperty.name);}return this._oHierarchy;},getAllAttributeNames:function(){if(this._aAttributeNames){return this._aAttributeNames;}this._aAttributeNames=[];for(var n in this._oAttributeSet){this._aAttributeNames.push(this._oAttributeSet[n].getName());}return this._aAttributeNames;},getAllAttributes:function(){return this._oAttributeSet;},findAttributeByName:function(n){return this._oAttributeSet[n];},addAttribute:function(d){this._oAttributeSet[d.getName()]=d;},getContainingQueryResult:function(){return this._oQueryResult;},hasMasterData:function(){return this._oMembersEntitySet!=null?true:false;},getMasterDataEntitySet:function(){return this._oMembersEntitySet;},_oQueryResult:null,_oProperty:null,_oTextProperty:null,_sLabelText:null,_sSuperOrdinateDimension:null,_aAttributeNames:null,_oAttributeSet:null,_oMembersEntitySet:null,_oHierarchy:null};
o.DimensionAttribute=function(Q,p){this._init(Q,p);};
o.DimensionAttribute.prototype={_init:function(Q,p){this._oQueryResult=Q;this._oProperty=p;if(p.extensions!=undefined){for(var i=-1,e;(e=p.extensions[++i])!==undefined;){if(!e.namespace==o.constants.SAP_NAMESPACE){continue;}switch(e.name){case"attribute-for":this._sDimensionName=e.value;break;case"label":this._sLabelText=e.value;break;case"text":this._oTextProperty=Q.getEntityType().findPropertyByName(e.value);break;default:}}}},getName:function(){return this._oProperty.name;},getKeyProperty:function(){return this._oProperty;},getTextProperty:function(){return this._oTextProperty;},getLabelText:function(){if(!this._sLabelText&&this._oQueryResult._oModel._oActivatedWorkarounds.CreateLabelsFromTechnicalNames){this._sLabelText=o.helper.tokenizeNametoLabelText(this.getName());}return this._sLabelText;},getDimension:function(){return this._oQueryResult.findDimensionByName(this._sDimensionName);},_oQueryResult:null,_oProperty:null,_oTextProperty:null,_sLabelText:null,_sDimensionName:null};
o.Measure=function(Q,p){this._init(Q,p);};
o.Measure.prototype={_init:function(Q,p){this._oQueryResult=Q;this._oProperty=p;if(p.extensions!=undefined){for(var i=-1,e;(e=p.extensions[++i])!==undefined;){if(!e.namespace==o.constants.SAP_NAMESPACE){continue;}switch(e.name){case"label":this._sLabelText=e.value;break;case"text":this._oTextProperty=Q.getEntityType().findPropertyByName(e.value);break;case"unit":this._oUnitProperty=Q.getEntityType().findPropertyByName(e.value);break;default:}}}if(!this._sLabelText){this._sLabelText="";}},getName:function(){return this._oProperty.name;},getRawValueProperty:function(){return this._oProperty;},getFormattedValueProperty:function(){return this._oTextProperty;},getUnitProperty:function(){return this._oUnitProperty;},getLabelText:function(){if(!this._sLabelText&&this._oQueryResult._oModel._oActivatedWorkarounds.CreateLabelsFromTechnicalNames){this._sLabelText=o.helper.tokenizeNametoLabelText(this.getName());}return this._sLabelText;},isUpdatable:function(){if(this._bIsUpdatable!=null){return this._bIsUpdatable;}var u=this._oQueryResult.getEntitySet().getUpdatablePropertyNameSet();return(u[this.getName()]!=undefined);},_oQueryResult:null,_oProperty:null,_oTextProperty:null,_sLabelText:null,_oUnitProperty:null,_bIsUpdatable:null};
o.EntitySet=function(m,s,C,e,E){this._init(m,s,C,e,E);};
o.EntitySet.prototype={_init:function(m,s,C,e,E){this._oEntityType=E;this._oEntitySet=e;this._oContainer=C;this._oSchema=s;this._oModel=m;if(s.entityContainer.length>1){this._sQName=C.name+"."+e.name;}else{this._sQName=e.name;}},getQName:function(){return this._sQName;},getSetDescription:function(){return this._oEntitySet;},getEntityType:function(){return this._oEntityType;},getSchema:function(){return this._oSchema;},getModel:function(){return this._oModel;},getUpdatablePropertyNameSet:function(){if(this._oUpdatablePropertyNames){return this._oUpdatablePropertyNames;}this._oUpdatablePropertyNames={};var s=true;if(this._oEntitySet.extensions!=undefined){for(var j=-1,e;(e=this._oEntitySet.extensions[++j])!==undefined;){if(e.namespace==o.constants.SAP_NAMESPACE&&e.name=="updatable"){if(e.value=="false"){s=false;break;}}}}if(!s){return this._oUpdatablePropertyNames;}var p=this._oEntityType.getTypeDescription().property;for(var i=-1,P;(P=p[++i])!==undefined;){var b=true;if(P.extensions==undefined){continue;}for(var k=-1,E;(E=P.extensions[++k])!==undefined;){if(E.namespace!=o.constants.SAP_NAMESPACE){continue;}if(E.name=="updatable"){if(E.value=="false"){b=false;break;}}}if(b){this._oUpdatablePropertyNames[P.name]=true;}}return this._oUpdatablePropertyNames;},_oEntityType:null,_oEntitySet:null,_oContainer:null,_oSchema:null,_oModel:null,_sQName:null,_oUpdatablePropertyNames:null};
o.EntityType=function(m,s,e){this._init(m,s,e);};
o.EntityType.propertyFilterRestriction={SINGLE_VALUE:"single-value",MULTI_VALUE:"multi-value",INTERVAL:"interval"};o.EntityType.prototype={_init:function(m,s,e){this._oEntityType=e;this._oSchema=s;this._oModel=m;this._aKeyProperties=[];this._oPropertySet={};this._aFilterablePropertyNames=[];this._aSortablePropertyNames=[];this._aRequiredFilterPropertyNames=[];this._oPropertyFilterRestrictionSet={};this._oPropertyHeadingsSet={};this._oPropertyQuickInfosSet={};this._sQName=s.namespace+"."+e.name;var r={};var R=null;for(var i=-1,p;(p=e.key.propertyRef[++i])!==undefined;){this._aKeyProperties.push(p.name);}for(var k=-1,P;(P=e.property[++k])!==undefined;){this._oPropertySet[P.name]=P;this._aFilterablePropertyNames.push(P.name);this._aSortablePropertyNames.push(P.name);if(P.extensions==undefined){continue;}for(var j=-1,E;(E=P.extensions[++j])!==undefined;){if(!E.namespace==o.constants.SAP_NAMESPACE){continue;}switch(E.name){case"filterable":if(E.value=="false"){this._aFilterablePropertyNames.pop(P.name);}break;case"sortable":if(E.value=="false"){this._aSortablePropertyNames.pop(P.name);}break;case"required-in-filter":if(E.value=="true"){this._aRequiredFilterPropertyNames.push(P.name);}break;case"filter-restriction":if(E.value==o.EntityType.propertyFilterRestriction.SINGLE_VALUE||E.value==o.EntityType.propertyFilterRestriction.MULTI_VALUE||E.value==o.EntityType.propertyFilterRestriction.INTERVAL){this._oPropertyFilterRestrictionSet[P.name]=E.value;}break;case"hierarchy-node-for":if(!(R=r[P.name])){R=r[P.name]={};}R.dimensionName=E.value;break;case"hierarchy-parent-node-for":case"hierarchy-parent-nod":if(!(R=r[E.value])){R=r[E.value]={};}R.parentNodeIDProperty=P;break;case"hierarchy-level-for":if(!(R=r[E.value])){R=r[E.value]={};}R.levelProperty=P;break;case"hierarchy-drill-state-for":case"hierarchy-drill-stat":if(!(R=r[E.value])){R=r[E.value]={};}R.drillStateProperty=P;break;default:}}}this._oRecursiveHierarchySet={};for(var h in r){var H=r[h];var a=this._oPropertySet[h];var d=this._oPropertySet[H.dimensionName];if(d==null){d=a;}this._oRecursiveHierarchySet[d.name]=new o.RecursiveHierarchy(e,a,H.parentNodeIDProperty,H.levelProperty,d);}},getProperties:function(){return this._oPropertySet;},findPropertyByName:function(p){return this._oPropertySet[p];},getKeyProperties:function(){return this._aKeyProperties;},getLabelOfProperty:function(p){var P=this._oPropertySet[p];if(P==null){throw"no such property with name "+p;}if(P.extensions!=undefined){for(var i=-1,e;(e=P.extensions[++i])!==undefined;){if(!e.namespace==o.constants.SAP_NAMESPACE){continue;}if(e.name=="label"){return e.value;}}}return null;},getHeadingOfProperty:function(p){var P=this._oPropertySet[p];if(P==null){throw"no such property with name "+p;}var s=null;if(P.extensions!=undefined){for(var i=-1,e;(e=P.extensions[++i])!==undefined;){if(!e.namespace==o.constants.SAP_NAMESPACE){continue;}if(e.name=="heading"){return e.value;}if(e.name=="label"){s=e.value;}}}return s;},getQuickInfoOfProperty:function(p){var P=this._oPropertySet[p];if(P==null){throw"no such property with name "+p;}var s=null;if(P.extensions!=undefined){for(var i=-1,e;(e=P.extensions[++i])!==undefined;){if(!e.namespace==o.constants.SAP_NAMESPACE){continue;}if(e.name=="quickinfo"){return e.value;}if(e.name=="label"){s=e.value;}}}return s;},getTextPropertyOfProperty:function(p){var P=this._oPropertySet[p];if(P==null){throw"no such property with name "+p;}if(P.extensions!=undefined){for(var i=-1,e;(e=P.extensions[++i])!==undefined;){if(e.name=="text"){return this.findPropertyByName(e.value);}}}return null;},getSuperOrdinatePropertyOfProperty:function(p){var P=this._oPropertySet[p];if(P==null){throw"no such property with name "+p;}if(P.extensions!=undefined){for(var i=-1,e;(e=P.extensions[++i])!==undefined;){if(e.name=="super-ordinate"){return this.findPropertyByName(e.value);}}}return null;},getFilterablePropertyNames:function(){return this._aFilterablePropertyNames;},getSortablePropertyNames:function(){return this._aSortablePropertyNames;},getRequiredFilterPropertyNames:function(){return this._aRequiredFilterPropertyNames;},getPropertiesWithFilterRestrictions:function(){return this._oPropertyFilterRestrictionSet;},getAllHierarchyPropertyNames:function(){if(this._aHierarchyPropertyNames){return this._aHierarchyPropertyNames;}this._aHierarchyPropertyNames=[];for(var n in this._oRecursiveHierarchySet){this._aHierarchyPropertyNames.push(this._oRecursiveHierarchySet[n].getNodeValueProperty().name);}return this._aHierarchyPropertyNames;},getHierarchy:function(n){if(this._oRecursiveHierarchySet[n]==undefined){return null;}return this._oRecursiveHierarchySet[n];},getQName:function(){return this._sQName;},getTypeDescription:function(){return this._oEntityType;},getSchema:function(){return this._oSchema;},getModel:function(){return this._oModel;},_oEntityType:null,_oSchema:null,_oModel:null,_sQName:null,_aKeyProperties:null,_oPropertySet:null,_aFilterablePropertyNames:null,_aRequiredFilterPropertyNames:null,_oPropertyFilterRestrictionSet:null,_aHierarchyPropertyNames:null,_oRecursiveHierarchySet:null};
o.RecursiveHierarchy=function(e,n,p,N,a){this._init(e,n,p,N,a);};
o.RecursiveHierarchy.prototype={_init:function(e,n,p,N,a){this._oEntityType=e;this._oNodeIDProperty=n;this._oParentNodeIDProperty=p;this._oNodeLevelProperty=N;this._oNodeValueProperty=a;},isRecursiveHierarchy:function(){return true;},isLeveledHierarchy:function(){return false;},getNodeIDProperty:function(){return this._oNodeIDProperty;},getParentNodeIDProperty:function(){return this._oParentNodeIDProperty;},getNodeLevelProperty:function(){return this._oNodeLevelProperty;},getNodeValueProperty:function(){return this._oNodeValueProperty;},_oNodeIDProperty:null,_oParentNodeIDProperty:null,_oNodeLevelProperty:null,_oNodeValueProperty:null};
o.FilterExpression=function(m,s,e){this._init(m,s,e);};
o.FilterExpression.prototype={_init:function(m,s,e){this._oEntityType=e;this._oSchema=s;this._oModel=m;this._aConditionUI5Filter=[];this._aUI5FilterArray=[];},_renderPropertyFilterValue:function(f,p){return q.sap.encodeURL(this._oModel.getODataModel().formatValue(f,p));},clear:function(){this._aConditionUI5Filter=[];this._aUI5FilterArray=[];},_addCondition:function(p,O,v,V){for(var i=-1,u;(u=this._aConditionUI5Filter[++i])!==undefined;){if(u.sPath==p&&u.sOperator==O&&u.oValue1==v&&u.oValue2==V){return;}}this._aConditionUI5Filter.push(new F(p,O,v,V));},_addUI5FilterArray:function(u){this._aUI5FilterArray.push(u);},addCondition:function(p,O,v,V){var P=this._oEntityType.findPropertyByName(p);if(P==null){throw"Cannot add filter condition for unknown property name "+p;}var f=this._oEntityType.getFilterablePropertyNames();if(q.inArray(p,f)===-1){throw"Cannot add filter condition for not filterable property name "+p;}this._addCondition(p,O,v,V);return this;},removeConditions:function(p){var P=this._oEntityType.findPropertyByName(p);if(P==null){throw"Cannot remove filter conditions for unknown property name "+p;}for(var i=0;i<this._aConditionUI5Filter.length;i++){var u=this._aConditionUI5Filter[i];if(u.sPath==p){this._aConditionUI5Filter.splice(i--,1);}}return this;},addSetCondition:function(p,v){var P=this._oEntityType.findPropertyByName(p);if(P==null){throw"Cannot add filter condition for unknown property name "+p;}var f=this._oEntityType.getFilterablePropertyNames();if(q.inArray(p,f)===-1){throw"Cannot add filter condition for not filterable property name "+p;}for(var i=-1,V;(V=v[++i])!==undefined;){this._addCondition(p,c.EQ,V);}return this;},addUI5FilterConditions:function(u){if(!Array.isArray(u)){throw"Argument is not an array";}if(u.length==0){return this;}var h=false;for(var i=0;i<u.length;i++){if(u[i].aFilters!=undefined){h=true;break;}}if(h){this._addUI5FilterArray(u);}else{for(var j=0;j<u.length;j++){this.addCondition(u[j].sPath,u[j].sOperator,u[j].oValue1,u[j].oValue2);}}return this;},getExpressionAsUI5FilterArray:function(){var f=this._aConditionUI5Filter.concat([]);for(var i=-1,a;(a=this._aUI5FilterArray[++i])!==undefined;){for(var j=-1,b;(b=a[++j])!==undefined;){f.push(b);}}return f;},getPropertiesReferencedByUI5FilterArray:function(u,r){for(var i=-1,U;(U=u[++i])!==undefined;){if(U.aFilters!=undefined){this.getPropertiesReferencedByUI5FilterArray(U.aFilters,r);}else{if(r[U.sPath]==undefined){r[U.sPath]=[];}r[U.sPath].push(U);}}},getReferencedProperties:function(){var r={};for(var i=-1,u;(u=this._aConditionUI5Filter[++i])!==undefined;){if(r[u.sPath]==undefined){r[u.sPath]=[];}r[u.sPath].push(u);}for(var j=-1,U;(U=this._aUI5FilterArray[++j])!==undefined;){this.getPropertiesReferencedByUI5FilterArray(U,r);}return r;},renderUI5Filter:function(u){var p=this._oEntityType.findPropertyByName(u.sPath);if(p==null){throw"Cannot add filter condition for unknown property name "+u.sPath;}var f=null;switch(u.sOperator){case c.BT:f="("+u.sPath+" "+c.GE.toLowerCase()+" "+this._renderPropertyFilterValue(u.oValue1,p.type)+" and "+u.sPath+" "+c.LE.toLowerCase()+" "+this._renderPropertyFilterValue(u.oValue2,p.type)+")";break;case c.Contains:f="substringof("+this._renderPropertyFilterValue(u.oValue1,"Edm.String")+","+u.sPath+")";break;case c.StartsWith:case c.EndsWith:f=u.sOperator.toLowerCase()+"("+u.sPath+","+this._renderPropertyFilterValue(u.oValue1,"Edm.String")+")";break;default:f=u.sPath+" "+u.sOperator.toLowerCase()+" "+this._renderPropertyFilterValue(u.oValue1,p.type);}return f;},renderUI5MultiFilter:function(u){var U=[];var O="";var l=u.bAnd==true?" and ":" or ";for(var i=-1,a;(a=u.aFilters[++i])!==undefined;){if(a.aFilters!=undefined){U.push(a);continue;}O+=(O==""?"":l)+"("+this.renderUI5Filter(a)+")";}if(U.length>0){for(var j=-1,m;(m=U[++j])!==undefined;){O+=(O==""?"":l)+"("+this.renderUI5MultiFilter(m)+")";}}return O;},renderUI5FilterArray:function(u){if(u.length==0){return"";}var O="";u.sort(function(a,b){if(a.sPath==b.sPath){return 0;}if(a.sPath>b.sPath){return 1;}else{return-1;}});var p=u[0].sPath;var s="";var n=[],U=[];for(var i=-1,d;(d=u[++i])!==undefined;){if(d.aFilters!=undefined){U.push(d);continue;}if(p!=d.sPath){if(s!=""){O+=(O==""?"":" and ")+"("+s+")";}s="";if(n.length>0){for(var j=-1,N;(N=n[++j])!==undefined;){s+=(s==""?"":" and ")+this.renderUI5Filter(N);}O+=(O==""?"":" and ")+"("+s+")";s="";}p=d.sPath;n=[];}if(d.sOperator==c.NE){n.push(d);continue;}s+=(s==""?"":" or ")+this.renderUI5Filter(d);}if(s!=""){O+=(O==""?"":" and ")+"("+s+")";}if(n.length>0){s="";for(var k=-1,e;(e=n[++k])!==undefined;){s+=(s==""?"":" and ")+this.renderUI5Filter(e);}O+=(O==""?"":" and ")+"("+s+")";}if(U.length>0){for(var l=-1,m;(m=U[++l])!==undefined;){O+=(O==""?"":" and ")+"("+this.renderUI5MultiFilter(m)+")";}}return O;},getURIFilterOptionValue:function(){var O=this.renderUI5FilterArray(this._aConditionUI5Filter);for(var i=-1,u;(u=this._aUI5FilterArray[++i])!==undefined;){O+=(O==""?"":" and ")+"("+this.renderUI5FilterArray(u)+")";}return O;},checkValidity:function(){var r=this._oEntityType.getRequiredFilterPropertyNames();var p=this.getReferencedProperties();for(var i=-1,P;(P=r[++i])!==undefined;){if(p[P]==undefined){throw"filter expression does not contain required property "+P;}}var a=this._oEntityType.getPropertiesWithFilterRestrictions();for(var s in a){var f=a[s];if(f==o.EntityType.propertyFilterRestriction.SINGLE_VALUE){if(p[s]!=undefined){if(p[s].length>1){var t=p[s][0].oValue1;for(var j=0;j<p[s].length;j++){if(p[s][j].oValue1!=t||p[s][j].sOperator!=c.EQ){throw"filter expression may use "+s+" only with a single EQ condition";}}}}}}return true;},getEntityType:function(){return this._oEntityType;},getSchema:function(){return this._oSchema;},getModel:function(){return this._oModel;},_oEntityType:null,_oSchema:null,_oModel:null,_aFilterCondition:null};o.SortOrder={Ascending:"asc",Descending:"desc"};
o.SortExpression=function(m,s,e){this._init(m,s,e);};
o.SortExpression.prototype={_init:function(m,s,e){this._oEntityType=e;this._oSchema=s;this._oModel=m;this._aSortCondition=[];},_containsSorter:function(p){var r=null;for(var i=-1,C;(C=this._aSortCondition[++i])!==undefined;){if(C.property.name===p){r={sorter:C,index:i};break;}}return r;},_removeFromArray:function(a,f,t){var r=a.slice((t||f)+1||a.length);a.length=f<0?a.length+f:f;return a.push.apply(a,r);},clear:function(){this._aSortCondition=[];},addSorter:function(p,s){var P=this._oEntityType.findPropertyByName(p);if(P==null){throw"Cannot add sort condition for unknown property name "+p;}var e=this._containsSorter(p);if(e!=null){e.sorter.order=s;return this;}var a=this._oEntityType.getSortablePropertyNames();if(q.inArray(p,a)===-1){throw"Cannot add sort condition for not sortable property name "+p;}this._aSortCondition.push({property:P,order:s});return this;},removeSorter:function(p){if(!p){return;}var s=this._containsSorter(p);if(s){this._removeFromArray(this._aSortCondition,s.index);}},getExpressionsAsUI5SorterArray:function(){var s=[];for(var i=-1,C;(C=this._aSortCondition[++i])!==undefined;){s.push(new S(C.property.name,C.order==o.SortOrder.Descending));}return s;},getExpressionAsUI5Sorter:function(){var s=this.getExpressionsAsUI5SorterArray();if(s.length==0){return null;}else{return s[0];}},getURIOrderByOptionValue:function(s){if(this._aSortCondition.length==0){return"";}var O="";for(var i=-1,C;(C=this._aSortCondition[++i])!==undefined;){if(!s[C.property.name]){continue;}O+=(O==""?"":",")+C.property.name+" "+C.order;}return O;},getEntityType:function(){return this._oEntityType;},getSchema:function(){return this._oSchema;},getModel:function(){return this._oModel;},_oEntityType:null,_oSchema:null,_oModel:null,_aSortCondition:null};
o.ParameterizationRequest=function(p){this._init(p);};
o.ParameterizationRequest.prototype={_init:function(p){if(!p){throw"No parameterization given";}this._oParameterization=p;this._oParameterValueAssignment=[];},_renderParameterKeyValue:function(k,p){return q.sap.encodeURL(this._oParameterization.getTargetQueryResult().getModel().getODataModel().formatValue(k,p));},getParameterization:function(){return this._oParameterization;},setParameterValue:function(p,v,t){var P=this._oParameterization.findParameterByName(p);if(!P){throw"Invalid parameter name "+p;}if(t!=null){if(!P.isIntervalBoundary()){throw"Range value cannot be applied to parameter "+p+" accepting only single values";}if(!P.isLowerIntervalBoundary()){throw"Range value given, but parameter "+p+" does not hold the lower boundary";}}if(!P.isIntervalBoundary()){if(v==null){delete this._oParameterValueAssignment[p];}else{this._oParameterValueAssignment[p]=v;}}else{if(v==null&&t!=null){throw"Parameter "+p+": An upper boundary cannot be given without the lower boundary";}if(v==null){delete this._oParameterValueAssignment[p];t=null;}else{this._oParameterValueAssignment[p]=v;}var u=P.getPeerIntervalBoundaryParameter();if(t==null){t=v;}if(v==null){delete this._oParameterValueAssignment[u.getName()];}else{this._oParameterValueAssignment[u.getName()]=t;}}return;},getURIToParameterizationEntitySet:function(s){return(s?s:"")+"/"+this._oParameterization.getEntitySet().getQName();},getURIToParameterizationEntry:function(s){var d=this._oParameterization.getAllParameters();for(var D in d){if(this._oParameterValueAssignment[D]==undefined){throw"Parameter "+D+" has no value assigned";}}var k="",f=true;for(var p in this._oParameterValueAssignment){k+=(f?"":",")+p+"="+this._renderParameterKeyValue(this._oParameterValueAssignment[p],d[p].getProperty().type);f=false;}return(s?s:"")+"/"+this._oParameterization.getEntitySet().getQName()+"("+k+")";},_oParameterization:null,_oParameterValueAssignment:null};
o.QueryResultRequest=function(Q,p){this._init(Q);};
o.QueryResultRequest.prototype={_init:function(Q,p){this._oQueryResult=Q;this._oParameterizationRequest=p;this._oAggregationLevel={};this._oMeasures={};this._bIncludeEntityKey=false;this._oFilterExpression=null;this._oSortExpression=null;this._oSelectedPropertyNames=null;},setParameterizationRequest:function(p){this._oParameterizationRequest=p;},setResourcePath:function(r){this._sResourcePath=r;if(this._sResourcePath.indexOf("/")!=0){throw"Missing leading / (slash) for resource path";}if(this._oQueryResult.getParameterization()){var l=r.lastIndexOf("/");if(l==-1){throw"Missing navigation from parameter entity set to query result in resource path";}var n=r.substring(l+1);if(n!=this._oQueryResult.getParameterization().getNavigationPropertyToQueryResult()){throw"Invalid navigation property from parameter entity set to query result in resource path";}}},getParameterizationRequest:function(){return this._oParameterizationRequest;},getQueryResult:function(){return this._oQueryResult;},setAggregationLevel:function(d){this._oAggregationLevel={};if(!d){d=this._oQueryResult.getAllDimensionNames();}this.addToAggregationLevel(d);this._oSelectedPropertyNames=null;},addToAggregationLevel:function(d){if(!d){return;}this._oSelectedPropertyNames=null;for(var i=-1,D;(D=d[++i])!==undefined;){if(!this._oQueryResult.findDimensionByName(D)){throw D+" is not a valid dimension name";}this._oAggregationLevel[D]={key:true,text:false,attributes:null};}},removeFromAggregationLevel:function(d){if(!d){return;}this._oSelectedPropertyNames=null;for(var i=-1,D;(D=d[++i])!==undefined;){if(!this._oQueryResult.findDimensionByName(D)){throw D+" is not a valid dimension name";}if(this._oAggregationLevel[D]!=undefined){delete this._oAggregationLevel[D];this.getSortExpression().removeSorter(D);}}},getAggregationLevel:function(){var d=[];for(var D in this._oAggregationLevel){d.push(D);}return d;},getAggregationLevelDetails:function(d){if(this._oAggregationLevel[d]==undefined){throw"Aggregation level does not include dimension "+d;}return this._oAggregationLevel[d];},setMeasures:function(m){if(!m){m=this._oQueryResult.getAllMeasureNames();}this._oSelectedPropertyNames=null;this._oMeasures={};for(var i=-1,M;(M=m[++i])!==undefined;){if(!this._oQueryResult.findMeasureByName(M)){throw M+" is not a valid measure name";}this._oMeasures[M]={value:true,text:false,unit:false};}},getMeasureNames:function(){var m=[];for(var M in this._oMeasures){m.push(M);}return m;},includeDimensionKeyTextAttributes:function(d,I,b,a){this._oSelectedPropertyNames=null;var D=[];if(d){if(this._oAggregationLevel[d]==undefined){throw d+" is not included in the aggregation level";}D.push(d);}else{for(var n in this._oAggregationLevel){D.push(n);}a=null;}for(var i=-1,s;(s=D[++i])!==undefined;){if(I!=null){this._oAggregationLevel[s].key=I;}if(b!=null){this._oAggregationLevel[s].text=b;}if(a!=null){this._oAggregationLevel[s].attributes=a;}}},includeMeasureRawFormattedValueUnit:function(m,I,b,a){this._oSelectedPropertyNames=null;var M=[];if(m){if(this._oMeasures[m]==undefined){throw m+" is not part of the query result";}M.push(m);}else{for(var n in this._oMeasures){M.push(n);}}for(var i=-1,s;(s=M[++i])!==undefined;){if(I!=null){this._oMeasures[s].value=I;}if(b!=null){this._oMeasures[s].text=b;}if(a!=null){this._oMeasures[s].unit=a;}}},getFilterExpression:function(){if(this._oFilterExpression==null){var e=this._oQueryResult.getEntityType();this._oFilterExpression=new o.FilterExpression(this._oQueryResult.getModel(),e.getSchema(),e);}return this._oFilterExpression;},setFilterExpression:function(f){this._oFilterExpression=f;},getSortExpression:function(){if(this._oSortExpression==null){var e=this._oQueryResult.getEntityType();this._oSortExpression=new o.SortExpression(e.getModel(),e.getSchema(),e);}return this._oSortExpression;},setSortExpression:function(s){this._oSortExpression=s;},setRequestOptions:function(i,I,r){if(i!=null){this._bIncludeEntityKey=i;}if(I!=null){this._bIncludeCount=I;}if(r!=null){this._bReturnNoEntities=r;}},setResultPageBoundaries:function(s,e){if(s!=null&&typeof s!=="number"){throw"Start value must be null or numeric";}if(e!==null&&typeof e!=="number"){throw"End value must be null or numeric";}if(s==null){s=1;}if(s<1||s>(e==null?s:e)){throw"Invalid values for requested page boundaries";}this._iSkipRequestOption=(s>1)?s-1:null;this._iTopRequestOption=(e!=null)?(e-s+1):null;},getResultPageBoundaries:function(){var e=null;if(this._iTopRequestOption!=null){if(this._iSkipRequestOption==null){e=1;}else{e=this._iSkipRequestOption+this._iTopRequestOption;}}return{start:(this._iSkipRequestOption==null)?1:this._iSkipRequestOption,end:e};},getURIToQueryResultEntitySet:function(s){var u=null;if(this._sResourcePath!=null){u=(s?s:"")+this._sResourcePath;}else if(this._oQueryResult.getParameterization()){if(!this._oParameterizationRequest){throw"Missing parameterization request";}else{u=this._oParameterizationRequest.getURIToParameterizationEntry(s)+"/"+this._oQueryResult.getParameterization().getNavigationPropertyToQueryResult();}}else{u=(s?s:"")+"/"+this._oQueryResult.getEntitySet().getQName();}return u;},getURIOrderByOptionValue:function(){var a,C,O=null,s=this._oSortExpression?this._oSortExpression._aSortCondition:[],i,n=s.length;if(n){a=this._oQueryResult.getAllMeasureNames();for(i=0;i<n;i+=1){C=s[i];if(!this._oSelectedPropertyNames[C.property.name]&&a.indexOf(C.property.name)<0){continue;}O=(O?O+",":"")+C.property.name+" "+C.order;}}return O;},getURIQueryOptionValue:function(Q){var s=null;switch(Q){case"$select":{var a="";this._oSelectedPropertyNames={};var d=null;for(var D in this._oAggregationLevel){var b=this._oQueryResult.findDimensionByName(D);var e=this._oAggregationLevel[D];if(e.key==true){d=b.getKeyProperty().name;if(this._oSelectedPropertyNames[d]==undefined){a+=(a==""?"":",")+d;this._oSelectedPropertyNames[d]=true;}}if(e.text==true&&b.getTextProperty()){d=b.getTextProperty().name;if(this._oSelectedPropertyNames[d]==undefined){a+=(a==""?"":",")+d;this._oSelectedPropertyNames[d]=true;}}if(e.attributes){for(var i=-1,f;(f=e.attributes[++i])!==undefined;){d=b.findAttributeByName(f).getName();if(this._oSelectedPropertyNames[d]==undefined){a+=(a==""?"":",")+d;this._oSelectedPropertyNames[d]=true;}}}}var m;for(var M in this._oMeasures){var g=this._oQueryResult.findMeasureByName(M);var h=this._oMeasures[M];if(h.value==true){m=g.getRawValueProperty().name;if(this._oSelectedPropertyNames[m]==undefined){a+=(a==""?"":",")+m;this._oSelectedPropertyNames[m]=true;}}if(h.text==true&&g.getFormattedValueProperty()){m=g.getFormattedValueProperty().name;if(this._oSelectedPropertyNames[m]==undefined){a+=(a==""?"":",")+m;this._oSelectedPropertyNames[m]=true;}}if(h.unit==true&&g.getUnitProperty()){m=g.getUnitProperty().name;if(this._oSelectedPropertyNames[m]==undefined){a+=(a==""?"":",")+m;this._oSelectedPropertyNames[m]=true;}}}if(this._bIncludeEntityKey){var k=this._oQueryResult.getEntityType().getTypeDescription().key.propertyRef;for(var j=-1,K;(K=k[++j])!==undefined;){a+=(a==""?"":",")+K.name;}}s=(a?a:null);break;}case"$filter":{var l=null;if(this._oFilterExpression){l=this._oFilterExpression.getURIFilterOptionValue();}s=(l?l:null);break;}case"$orderby":{s=this.getURIOrderByOptionValue();break;}case"$top":{s=null;if(this._bReturnNoEntities){s=0;}else if(this._iTopRequestOption!==null){s=this._iTopRequestOption;}break;}case"$skip":{s=null;if(!this._bReturnNoEntities){s=this._iSkipRequestOption;}break;}case"$inlinecount":{s=(this._bIncludeCount==true?"allpages":null);break;}default:break;}return s;},getURIToQueryResultEntries:function(s,r){if(!r){r=this.getURIToQueryResultEntitySet(s);}this.getFilterExpression().checkValidity();var a=this.getURIQueryOptionValue("$select");var f=this.getURIQueryOptionValue("$filter");var b=this.getURIQueryOptionValue("$orderby");var t=this.getURIQueryOptionValue("$top");var d=this.getURIQueryOptionValue("$skip");var i=this.getURIQueryOptionValue("$inlinecount");var u=r;var Q=false;if(a!==null){u+="?$select="+a;Q=true;}if(this._oFilterExpression&&f!==null){if(!Q){u+="?";Q=true;}else{u+="&";}u+="$filter="+f;}if(this._oSortExpression&&b!==null){if(!Q){u+="?";Q=true;}else{u+="&";}u+="$orderby="+b;}if((this._iTopRequestOption||this._bReturnNoEntities)&&t!==null){if(!Q){u+="?";Q=true;}else{u+="&";}u+="$top="+t;}if(this._iSkipRequestOption&&d!==null){if(!Q){u+="?";Q=true;}else{u+="&";}u+="$skip="+d;}if(this._bIncludeCount&&i!==null){if(!Q){u+="?";Q=true;}else{u+="&";}u+="$inlinecount="+i;}return u;},_oQueryResult:null,_oParameterizationRequest:null,_sResourcePath:null,_oAggregationLevel:null,_oMeasures:null,_bIncludeEntityKey:null,_bIncludeCount:null,_bReturnNoEntities:null,_oFilterExpression:null,_oSortExpression:null,_iSkipRequestOption:null,_iTopRequestOption:null};
o.ParameterValueSetRequest=function(p){this._init(p);};
o.ParameterValueSetRequest.prototype={_init:function(p){this._oParameter=p;this._oValueSetResult={};this._oFilterExpression=null;this._oSortExpression=null;},includeParameterText:function(i){if(i!=null){this._oValueSetResult.text=i;}},getFilterExpression:function(){if(this._oFilterExpression==null){var e=this._oParameter.getContainingParameterization().getEntityType();var m=this._oParameter.getContainingParameterization().getTargetQueryResult().getModel();this._oFilterExpression=new o.FilterExpression(m,e.getSchema(),e);}return this._oFilterExpression;},setFilterExpression:function(f){this._oFilterExpression=f;},getSortExpression:function(){if(this._oSortExpression==null){var e=this._oParameter.getContainingParameterization().getEntityType();this._oSortExpression=new o.SortExpression(e.getModel(),e.getSchema(),e);}return this._oSortExpression;},setSortExpression:function(s){this._oSortExpression=s;},getURIQueryOptionValue:function(Q){var s=null;switch(Q){case"$select":{var a="";a+=(a==""?"":",")+this._oParameter.getProperty().name;if(this._oValueSetResult.text==true&&this._oParameter.getTextProperty()){a+=(a==""?"":",")+this._oParameter.getTextProperty().name;}s=(a?a:null);break;}case"$filter":{var f=null;if(this._oFilterExpression){f=this._oFilterExpression.getURIFilterOptionValue();}s=(f?f:null);break;}case"$orderby":{var b=null;if(this._oSortExpression){b=this._oSortExpression.getURIOrderByOptionValue();}s=(b?b:null);break;}default:break;}return s;},getURIToParameterValueSetEntries:function(s){var r=null;r=(s?s:"")+"/"+this._oParameter.getContainingParameterization().getEntitySet().getQName();this.getFilterExpression().checkValidity();var a=this.getURIQueryOptionValue("$select");var f=this.getURIQueryOptionValue("$filter");var b=this.getURIQueryOptionValue("$orderby");var u=r;var Q=false;if(a){u+="?$select="+a;Q=true;}if(this._oFilterExpression&&f){if(!Q){u+="?";Q=true;}else{u+="&";}u+="$filter="+f;}if(this._oSortExpression&&b){if(!Q){u+="?";Q=true;}else{u+="&";}u+="$orderby="+b;}return u;},_oParameter:null,_oFilterExpression:null,_oSortExpression:null,_oValueSetResult:null};
o.DimensionMemberSetRequest=function(d,p,u){this._init(d,p,u);};
o.DimensionMemberSetRequest.prototype={_init:function(d,p,u){this._oDimension=d;this._oParameterizationRequest=p;this._bUseMasterData=u;this._oValueSetResult={};this._oFilterExpression=null;this._oSortExpression=null;if(this._oParameterizationRequest!=null&&this._bUseMasterData==true){throw"LIMITATION: parameterized master data entity sets are not yet implemented";}if(this._bUseMasterData){this._oEntitySet=this._oDimension.getMasterDataEntitySet();}else{this._oEntitySet=this._oDimension.getContainingQueryResult().getEntitySet();if(this._oDimension.getContainingQueryResult().getParameterization()&&!this._oParameterizationRequest){throw"Missing parameterization request";}}},setParameterizationRequest:function(p){this._oParameterizationRequest=p;},includeDimensionTextAttributes:function(i,I){this._oValueSetResult.text={text:false,attributes:false};if(i==true){this._oValueSetResult.text=true;}if(I==true){this._oValueSetResult.attributes=true;}},getFilterExpression:function(){if(this._oFilterExpression==null){var e=this._oEntitySet.getEntityType();var m=this._oDimension.getContainingQueryResult().getModel();this._oFilterExpression=new o.FilterExpression(m,e.getSchema(),e);}return this._oFilterExpression;},setFilterExpression:function(f){this._oFilterExpression=f;},getSortExpression:function(){if(this._oSortExpression==null){this._oSortExpression=new o.SortExpression(this._oEntityType.getModel(),this._oEntityType.getSchema(),this._oEntityType);}return this._oSortExpression;},setSortExpression:function(s){this._oSortExpression=s;},setRequestOptions:function(i){if(i!=null){this._bIncludeCount=i;}},setResultPageBoundaries:function(s,e){if(s!=null&&typeof s!=="number"){throw"Start value must be null or numeric";}if(e!==null&&typeof e!=="number"){throw"End value must be null or numeric";}if(s==null){s=1;}if(s<1||s>(e==null?s:e)){throw"Invalid values for requested page boundaries";}this._iSkipRequestOption=(s>1)?s-1:null;this._iTopRequestOption=(e!=null)?(e-s+1):null;},getResultPageBoundaries:function(){var e=null;if(this._iTopRequestOption!=null){if(this._iSkipRequestOption==null){e=1;}else{e=this._iSkipRequestOption+this._iTopRequestOption;}}return{start:(this._iSkipRequestOption==null)?1:this._iSkipRequestOption,end:e};},getURIQueryOptionValue:function(Q){var s=null;switch(Q){case"$select":{var a="";var e=this._oEntitySet.getEntityType();var K=e.getKeyProperties();var b=[];if(this._bUseMasterData){for(var i=-1,d;(d=K[++i])!==undefined;){a+=(a==""?"":",")+d;var f=e.getTextPropertyOfProperty(d);if(f){if(this._oValueSetResult.text==true){a+=","+f.name;}b.push(f.name);}}}else{a+=(a==""?"":",")+this._oDimension.getKeyProperty().name;if(this._oValueSetResult.text==true&&this._oDimension.getTextProperty()){a+=(a==""?"":",")+this._oDimension.getTextProperty().name;}}if(this._oValueSetResult.attributes){if(this._bUseMasterData){var g=e.getProperties();for(var p in g){var I=false;for(var j=-1,h;(h=K[++j])!==undefined;){if(p==h){I=true;break;}}if(I){continue;}for(var k=-1,m;(m=b[++k])!==undefined;){if(p==m){I=true;break;}}if(!I){a+=","+p;}}}else{var n=this._oDimension.getAllAttributeNames();for(var l=-1,r;(r=n[++l])!==undefined;){a+=(a==""?"":",")+this._oDimension.findAttributeByName(r).getName();}}}s=(a?a:null);break;}case"$filter":{var t=null;if(this._oFilterExpression){t=this._oFilterExpression.getURIFilterOptionValue();}s=(t?t:null);break;}case"$orderby":{var u=null;if(this._oSortExpression){u=this._oSortExpression.getURIOrderByOptionValue();}s=(u?u:null);break;}case"$top":{if(this._iTopRequestOption!==null){s=this._iTopRequestOption;}break;}case"$skip":{s=this._iSkipRequestOption;break;}case"$inlinecount":{s=(this._bIncludeCount==true?"allpages":null);break;}default:break;}return s;},getURIToDimensionMemberEntitySet:function(s){var r=null;if(!this._bUseMasterData&&this._oParameterizationRequest){r=this._oParameterizationRequest.getURIToParameterizationEntry(s)+"/"+this._oDimension.getContainingQueryResult().getParameterization().getNavigationPropertyToQueryResult();}else{r=(s?s:"")+"/"+this._oEntitySet.getQName();}return r;},getURIToDimensionMemberEntries:function(s){var r=this.getURIToDimensionMemberEntitySet(s);this.getFilterExpression().checkValidity();var a=this.getURIQueryOptionValue("$select");var f=this.getURIQueryOptionValue("$filter");var b=this.getURIQueryOptionValue("$orderby");var t=this.getURIQueryOptionValue("$top");var d=this.getURIQueryOptionValue("$skip");var i=this.getURIQueryOptionValue("$inlinecount");var u=r;var Q=false;if(a){u+="?$select="+a;Q=true;}if(this._oFilterExpression&&f){if(!Q){u+="?";Q=true;}else{u+="&";}u+="$filter="+f;}if(this._oSortExpression&&b){if(!Q){u+="?";Q=true;}else{u+="&";}u+="$orderby="+b;}if(this._iTopRequestOption&&t){if(!Q){u+="?";Q=true;}else{u+="&";}u+="$top="+t;}if(this._iSkipRequestOption&&d){if(!Q){u+="?";Q=true;}else{u+="&";}u+="$skip="+d;}if(this._bIncludeCount&&i){if(!Q){u+="?";Q=true;}else{u+="&";}u+="$inlinecount="+i;}return u;},_oDimension:null,_oParameterizationRequest:null,_oEntitySet:null,_bUseMasterData:false,_oFilterExpression:null,_oSortExpression:null,_oValueSetResult:null,_bIncludeCount:null,_iSkipRequestOption:0,_iTopRequestOption:null};return o;},true);
sap.ui.predefine('sap/ui/model/control/ControlModel',['jquery.sap.global','sap/ui/model/Model','./ControlPropertyBinding'],function(q,M,C){"use strict";
var a=M.extend("sap.ui.model.control.ControlModel",{constructor:function(c){M.apply(this,arguments);this.oControl=c;this.oControl.attachEvent("_change",this.checkUpdate,this);this.oElements=[];}});
a.prototype.destroy=function(){this.oControl.detachEvent("_change",this.checkUpdate,this);};
a.prototype.addFacadeComponent=function(e){var i=q.inArray(e,this.oElements);if(i<0){this.oElements.push(e);e.attachEvent("_change",this.checkUpdate,this);}};
a.prototype.removeFacadeComponent=function(e){var i=q.inArray(e,this.oElements);if(i>=0){this.oElements.splice(i,1);e.detachEvent("_change",this.checkUpdate,this);}};
a.prototype.bindProperty=function(p,c){c=c||this.oControl;if(c!==this.oControl){this.addFacadeComponent(c);}return new C(this,p,c);};
a.prototype.checkUpdate=function(e){if(this._onchange){this._onchange(e);}if(this.aBindings.length){var b=this.aBindings.slice(0);q.each(b,function(i,B){B.checkUpdate();});}};
return a;});
sap.ui.predefine('sap/ui/model/control/ControlPropertyBinding',['sap/ui/model/PropertyBinding'],function(P){"use strict";
var C=P.extend("sap.ui.model.control.ControlPropertyBinding",{constructor:function(m,p,c){P.apply(this,arguments);this.oValue=this._getValue();}});
C.prototype.getValue=function(){return this.oValue;};
C.prototype.setValue=function(v){this.oValue=v;this.oContext.setProperty(this.sPath,v);};
C.prototype._getValue=function(){return this.oContext.getProperty(this.sPath);};
C.prototype.setContext=function(c){this.oContext=c;this.checkUpdate();};
C.prototype.checkUpdate=function(){var v=this._getValue();if(v!==this.oValue){this.oValue=v;this._fireChange();}};
return C;});
sap.ui.predefine('sap/ui/model/json/JSONListBinding',['jquery.sap.global','sap/ui/model/ChangeReason','sap/ui/model/ClientListBinding'],function(q,C,a){"use strict";
var J=a.extend("sap.ui.model.json.JSONListBinding");
J.prototype.getContexts=function(s,l){this.iLastStartIndex=s;this.iLastLength=l;if(!s){s=0;}if(!l){l=Math.min(this.iLength,this.oModel.iSizeLimit);}var c=this._getContexts(s,l),b=[];if(this.bUseExtendedChangeDetection){try{for(var i=0;i<c.length;i++){b.push(this.getContextData(c[i]));}if(this.aLastContextData&&s<this.iLastEndIndex){c.diff=q.sap.arraySymbolDiff(this.aLastContextData,b);}this.iLastEndIndex=s+l;this.aLastContexts=c.slice(0);this.aLastContextData=b.slice(0);}catch(e){this.bUseExtendedChangeDetection=false;q.sap.log.warning("JSONListBinding: Extended change detection has been disabled as JSON data could not be serialized.");}}return c;};
J.prototype.getCurrentContexts=function(){if(this.bUseExtendedChangeDetection){return this.aLastContexts||[];}else{return this.getContexts(this.iLastStartIndex,this.iLastLength);}};
J.prototype.updateIndices=function(){var i;this.aIndices=[];if(Array.isArray(this.oList)){for(i=0;i<this.oList.length;i++){this.aIndices.push(i);}}else{for(i in this.oList){this.aIndices.push(i);}}};
J.prototype.update=function(){var l=this.oModel._getObject(this.sPath,this.oContext);if(l){if(Array.isArray(l)){if(this.bUseExtendedChangeDetection){this.oList=q.extend(true,[],l);}else{this.oList=l.slice(0);}}else{this.oList=q.extend(this.bUseExtendedChangeDetection,{},l);}this.updateIndices();this.applyFilter();this.applySort();this.iLength=this._getLength();}else{this.oList=[];this.aIndices=[];this.iLength=0;}};
J.prototype.checkUpdate=function(f){if(this.bSuspended&&!this.bIgnoreSuspend&&!f){return;}if(!this.bUseExtendedChangeDetection){var l=this.oModel._getObject(this.sPath,this.oContext);if(!q.sap.equal(this.oList,l)||f){this.update();this._fireChange({reason:C.Change});}}else{var c=false;var t=this;var l=this.oModel._getObject(this.sPath,this.oContext);if(l&&this.oList.length!=l.length){c=true;}if(!q.sap.equal(this.oList,l)){this.update();}var b=this._getContexts(this.iLastStartIndex,this.iLastLength);if(this.aLastContexts){if(this.aLastContexts.length!=b.length){c=true;}else{q.each(this.aLastContextData,function(i,L){var o=t.getContextData(b[i]);if(o!==L){c=true;return false;}});}}else{c=true;}if(c||f){this._fireChange({reason:C.Change});}}};
return J;});
sap.ui.predefine('sap/ui/model/json/JSONModel',['jquery.sap.global','sap/ui/model/ClientModel','sap/ui/model/Context','./JSONListBinding','./JSONPropertyBinding','./JSONTreeBinding'],function(q,C,a,J,b,c){"use strict";
var d=C.extend("sap.ui.model.json.JSONModel",{
constructor:function(D,o){this.pSequentialImportCompleted=Promise.resolve();C.apply(this,arguments);this.bObserve=o;if(D&&typeof D=="object"){this.setData(D);}},
metadata:{publicMethods:["setJSON","getJSON"]}
});
d.prototype.setData=function(D,m){if(m){this.oData=q.extend(true,Array.isArray(this.oData)?[]:{},this.oData,D);}else{this.oData=D;}if(this.bObserve){this.observeData();}this.checkUpdate();};
d.prototype.observeData=function(){var t=this;function e(v){return function(){return v;};}function f(O,n){return function(v){o(v,O,n);t.checkUpdate();};}function g(O,n,v){if(typeof v=="function"){O[n]=v;}else{Object.defineProperty(O,n,{get:e(v),set:f(O,n)});}}function o(O,p,n){if(Array.isArray(O)){for(var i=0;i<O.length;i++){o(O[i],O,i);}}else if(q.isPlainObject(O)){for(var i in O){o(O[i],O,i);}}if(p){g(p,n,O);}}o(this.oData);};
d.prototype.setJSON=function(j,m){var o;try{o=q.parseJSON(j);this.setData(o,m);}catch(e){q.sap.log.fatal("The following problem occurred: JSON parse Error: "+e);this.fireParseError({url:"",errorCode:-1,reason:"",srcText:e,line:-1,linepos:-1,filepos:-1});}};
d.prototype.getJSON=function(){return JSON.stringify(this.oData);};
d.prototype.loadData=function(u,p,A,t,m,e,h){var f;A=(A!==false);t=t||"GET";e=e===undefined?this.bCache:e;this.fireRequestSent({url:u,type:t,async:A,headers:h,info:"cache="+e+";bMerge="+m,infoObject:{cache:e,merge:m}});var s=function(D){if(!D){q.sap.log.fatal("The following problem occurred: No data was retrieved by service: "+u);}this.setData(D,m);this.fireRequestCompleted({url:u,type:t,async:A,headers:h,info:"cache="+e+";bMerge="+m,infoObject:{cache:e,merge:m},success:true});}.bind(this);var E=function(P){var o={message:P.textStatus,statusCode:P.request.status,statusText:P.request.statusText,responseText:P.request.responseText};q.sap.log.fatal("The following problem occurred: "+P.textStatus,P.request.responseText+","+P.request.status+","+P.request.statusText);this.fireRequestCompleted({url:u,type:t,async:A,headers:h,info:"cache="+e+";bMerge="+m,infoObject:{cache:e,merge:m},success:false,errorobject:o});this.fireRequestFailed(o);}.bind(this);var _=function(s,E){this._ajax({url:u,async:A,dataType:'json',cache:e,data:p,headers:h,type:t,success:s,error:E});}.bind(this);if(A){f=new Promise(function(r,g){var R=function(x,T,o){g({request:x,textStatus:T,error:o});};_(r,R);});this.pSequentialImportCompleted=this.pSequentialImportCompleted.then(function(){return f.then(s,E).catch(function(){});});}else{_(s,E);}};
d.prototype.bindProperty=function(p,o,P){var B=new b(this,p,o,P);return B;};
d.prototype.bindList=function(p,o,s,f,P){var B=new J(this,p,o,s,f,P);return B;};
d.prototype.bindTree=function(p,o,f,P,s){var B=new c(this,p,o,f,P,s);return B;};
d.prototype.setProperty=function(p,v,o,A){var r=this.resolve(p,o),l,O,P;if(!r){return false;}if(r=="/"){this.setData(v);return true;}l=r.lastIndexOf("/");O=r.substring(0,l||1);P=r.substr(l+1);var e=this._getObject(O);if(e){e[P]=v;this.checkUpdate(false,A);return true;}return false;};
d.prototype.getProperty=function(p,o){return this._getObject(p,o);};
d.prototype._getObject=function(p,o){var n=this.isLegacySyntax()?this.oData:null;if(o instanceof a){n=this._getObject(o.getPath());}else if(o){n=o;}if(!p){return n;}var P=p.split("/"),i=0;if(!P[0]){n=this.oData;i++;}while(n&&P[i]){n=n[P[i]];i++;}return n;};
d.prototype.isList=function(p,o){var A=this.resolve(p,o);return Array.isArray(this._getObject(A));};
d.prototype._setMetaModel=function(m){this._oMetaModel=m;};
d.prototype.getMetaModel=function(){return this._oMetaModel;};
return d;});
sap.ui.predefine('sap/ui/model/json/JSONPropertyBinding',['jquery.sap.global','sap/ui/model/ChangeReason','sap/ui/model/ClientPropertyBinding','sap/ui/model/ChangeReason'],function(q,C,a){"use strict";
var J=a.extend("sap.ui.model.json.JSONPropertyBinding");
J.prototype.setValue=function(v){if(this.bSuspended){return;}if(!q.sap.equal(this.oValue,v)){if(this.oModel.setProperty(this.sPath,v,this.oContext,true)){this.oValue=v;this.getDataState().setValue(this.oValue);this.oModel.firePropertyChange({reason:C.Binding,path:this.sPath,context:this.oContext,value:v});}}};
J.prototype.checkUpdate=function(f){if(this.bSuspended&&!f){return;}var v=this._getValue();if(!q.sap.equal(v,this.oValue)||f){this.oValue=v;this.getDataState().setValue(this.oValue);this.checkDataState();this._fireChange({reason:C.Change});}};
return J;});
sap.ui.predefine('sap/ui/model/json/JSONTreeBinding',['jquery.sap.global','sap/ui/model/ClientTreeBinding'],function(q,C){"use strict";
var J=C.extend("sap.ui.model.json.JSONTreeBinding");
J.prototype._saveSubContext=function(n,c,s,N){if(n&&typeof n=="object"){var o=this.oModel.getContext(s+N);if(this.aAllFilters&&!this.bIsFiltering){if(q.inArray(o,this.filterInfo.aFilteredContexts)!=-1){c.push(o);}}else{c.push(o);}}};
return J;});
sap.ui.predefine('sap/ui/model/odata/AnnotationHelper',["jquery.sap.global","sap/ui/base/BindingParser","./_AnnotationHelperBasics","./_AnnotationHelperExpression"],function(q,B,a,E){'use strict';
function c(f,b){if(!b){return f;}function d(){return f.call(this,b.apply(this,arguments));}return d;}
var A={createPropertySetting:function(p,r){var m=false,P;p=p.slice();p.forEach(function(v,i){switch(typeof v){case"boolean":case"number":case"undefined":m=true;break;case"string":P=B.complexParser(v,null,true,true);if(P!==undefined){if(P.functionsNotFound){throw new Error("Function name(s) "+P.functionsNotFound.join(", ")+" not found");}p[i]=v=P;}case"object":if(!v||typeof v!=="object"||!("path"in v)){m=true;}break;default:throw new Error("Unsupported part: "+v);}});P={formatter:r,parts:p};if(m){B.mergeParts(P);}if(P.parts.length===0){P=P.formatter&&P.formatter();if(typeof P==="string"){P=B.complexParser.escape(P);}}else if(P.parts.length===1){r=P.formatter;P=P.parts[0];if(r){P.formatter=c(r,P.formatter);}}return P;},format:function(i,r){if(arguments.length===1){r=i.getObject("");}return E.getExpression(i,r,true);},getNavigationPath:function(i,r){if(arguments.length===1){r=i.getObject("");}var R=a.followPath(i,r);return R?"{"+R.navigationProperties.join("/")+"}":"";},gotoEntitySet:function(C){var e,s,r=C.getObject(),R;if(typeof r==="string"){e=r;}else{R=a.followPath(C,r);e=R&&R.associationSetEnd&&R.associationSetEnd.entitySet;}if(e){s=C.getModel().getODataEntitySet(e,true);}if(!s){q.sap.log.warning(C.getPath()+": found '"+e+"' which is not a name of an entity set",undefined,"sap.ui.model.odata.AnnotationHelper");}return s;},gotoEntityType:function(C){var e=C.getProperty(""),r=C.getModel().getODataEntityType(e,true);if(!r){q.sap.log.warning(C.getPath()+": found '"+e+"' which is not a name of an entity type",undefined,"sap.ui.model.odata.AnnotationHelper");}return r;},gotoFunctionImport:function(C){var f=C.getProperty("String"),r=C.getModel().getODataFunctionImport(f,true);if(!r){q.sap.log.warning(C.getPath()+": found '"+f+"' which is not a name of a function import",undefined,"sap.ui.model.odata.AnnotationHelper");}return r;},isMultiple:function(i,r){if(arguments.length===1){r=i.getObject("");}var R=a.followPath(i,r);if(R){if(R.navigationAfterMultiple){throw new Error('Association end with multiplicity "*" is not the last one: '+r.AnnotationPath);}return String(R.isMultiple);}return"";},resolvePath:function(C){var r=a.followPath(C,C.getObject());if(!r){q.sap.log.warning(C.getPath()+": Path could not be resolved ",undefined,"sap.ui.model.odata.AnnotationHelper");}return r?r.resolvedPath:undefined;},simplePath:function(i,r){if(arguments.length===1){r=i.getObject("");}return E.getExpression(i,r,false);}};A.format.requiresIContext=true;A.getNavigationPath.requiresIContext=true;A.isMultiple.requiresIContext=true;A.simplePath.requiresIContext=true;return A;},true);
sap.ui.predefine('sap/ui/model/odata/AnnotationParser',['jquery.sap.global','sap/ui/Device'],function(q,D){"use strict";var a={EnumMember:true,Path:true,PropertyPath:true,NavigationPropertyPath:true,AnnotationPath:true};var t={Binary:true,Bool:true,Date:true,DateTimeOffset:true,Decimal:true,Duration:true,Float:true,Guid:true,Int:true,String:true,TimeOfDay:true,LabelElementReference:true,EnumMember:true,Path:true,PropertyPath:true,NavigationPropertyPath:true,AnnotationPath:true};var m={And:true,Or:true,Eq:true,Ne:true,Gt:true,Ge:true,Lt:true,Le:true,If:true,Collection:true};var A={merge:function(T,s){var b,c;var S=["propertyAnnotations","EntityContainer","annotationReferences"];for(b in s){if(S.indexOf(b)!==-1){continue;}A._mergeAnnotation(b,s,T);}for(var i=0;i<S.length;++i){var d=S[i];T[d]=T[d]||{};for(b in s[d]){for(c in s[d][b]){T[d][b]=T[d][b]||{};A._mergeAnnotation(c,s[d][b],T[d][b]);}}}},_mergeAnnotation:function(n,b,T){if(Array.isArray(b[n])){T[n]=b[n].slice(0);}else{T[n]=T[n]||{};for(var k in b[n]){T[n][k]=b[n][k];}}},parse:function(M,x){var b={},s,c,d,T,e,f,g,h,l,n,o,p,r,u,v,w,y,z,B,C,E,F,G,i,H;A._parserData={};A._oXPath=A.getXPath();A._parserData.metadataInstance=M;A._parserData.serviceMetadata=M.getServiceMetadata();A._parserData.xmlDocument=A._oXPath.setNameSpace(x);A._parserData.schema={};A._parserData.aliases={};s=A._oXPath.selectNodes("//d:Schema",A._parserData.xmlDocument);for(i=0;i<s.length;i+=1){c=A._oXPath.nextNode(s,i);A._parserData.schema.Alias=c.getAttribute("Alias");A._parserData.schema.Namespace=c.getAttribute("Namespace");}var I={};var J=A._parseReferences(I);if(J){b.annotationReferences=I;b.aliasDefinitions=A._parserData.aliases;}d=A._oXPath.selectNodes("//d:Term",A._parserData.xmlDocument);if(d.length>0){T={};for(H=0;H<d.length;H+=1){e=A._oXPath.nextNode(d,H);f=A.replaceWithAlias(e.getAttribute("Type"));T["@"+A._parserData.schema.Alias+"."+e.getAttribute("Name")]=f;}b.termDefinitions=T;}A._parserData.metadataProperties=A.getAllPropertiesMetadata(A._parserData.serviceMetadata);if(A._parserData.metadataProperties.extensions){b.propertyExtensions=A._parserData.metadataProperties.extensions;}g=A._oXPath.selectNodes("//d:Annotations ",A._parserData.xmlDocument);for(H=0;H<g.length;H+=1){h=A._oXPath.nextNode(g,H);if(h.hasChildNodes()===false){continue;}l=h.getAttribute("Target");n=l.split(".")[0];if(n&&A._parserData.aliases[n]){l=l.replace(new RegExp(n,""),A._parserData.aliases[n]);}o=l;p=null;var K=null;if(l.indexOf("/")>0){o=l.split("/")[0];var S=A._parserData.serviceMetadata.dataServices&&A._parserData.serviceMetadata.dataServices.schema&&A._parserData.serviceMetadata.dataServices.schema.length;if(S){for(var j=A._parserData.serviceMetadata.dataServices.schema.length-1;j>=0;j--){var L=A._parserData.serviceMetadata.dataServices.schema[j];if(L.entityContainer){var N=o.split('.');for(var k=L.entityContainer.length-1;k>=0;k--){if(L.entityContainer[k].name===N[N.length-1]){K=l.replace(o+"/","");break;}}}}}if(!K){p=l.replace(o+"/","");}}if(p){if(!b.propertyAnnotations){b.propertyAnnotations={};}if(!b.propertyAnnotations[o]){b.propertyAnnotations[o]={};}if(!b.propertyAnnotations[o][p]){b.propertyAnnotations[o][p]={};}r=A._oXPath.selectNodes("./d:Annotation",h);for(var O=0;O<r.length;O+=1){u=A._oXPath.nextNode(r,O);v=A.replaceWithAlias(u.getAttribute("Term"));var Q=h.getAttribute("Qualifier")||u.getAttribute("Qualifier");if(Q){v+="#"+Q;}if(u.hasChildNodes()===false){b.propertyAnnotations[o][p][v]=A.enrichFromPropertyValueAttributes({},u);}else{b.propertyAnnotations[o][p][v]=A.getPropertyValue(u);}}}else{var P;if(K){if(!b["EntityContainer"]){b["EntityContainer"]={};}if(!b["EntityContainer"][o]){b["EntityContainer"][o]={};}P=b["EntityContainer"][o];}else{if(!b[o]){b[o]={};}P=b[o];}w=o.replace(A._parserData.aliases[n],n);r=A._oXPath.selectNodes("./d:Annotation",h);for(var R=0;R<r.length;R+=1){u=A._oXPath.nextNode(r,R);var U=A._parseAnnotation(o,h,u);y=U.key;z=U.value;if(!K){P[y]=z;}else{if(!P[K]){P[K]={};}P[K][y]=z;}}B=A._oXPath.selectNodes("//d:Annotations[contains(@Target, '"+w+"')]//d:PropertyValue[contains(@Path, '/')]//@Path",A._parserData.xmlDocument);for(i=0;i<B.length;i+=1){C=A._oXPath.nextNode(B,i);E=C.value;if(b.propertyAnnotations){if(b.propertyAnnotations[o]){if(b.propertyAnnotations[o][E]){continue;}}}F=E.split('/');if(A.findNavProperty(o,F[0])){if(!b.expand){b.expand={};}if(!b.expand[o]){b.expand[o]={};}b.expand[o][F[0]]=F[0];}}G=A._oXPath.selectNodes("//d:Annotations[contains(@Target, '"+w+"')]//d:Path[contains(., '/')]",A._parserData.xmlDocument);for(i=0;i<G.length;i+=1){C=A._oXPath.nextNode(G,i);E=A._oXPath.getNodeText(C);if(b.propertyAnnotations&&b.propertyAnnotations[o]&&b.propertyAnnotations[o][E]){continue;}if(!b.expand){b.expand={};}if(!b.expand[o]){b.expand[o]={};}F=E.split('/');if(A.findNavProperty(o,F[0])){if(!b.expand){b.expand={};}if(!b.expand[o]){b.expand[o]={};}b.expand[o][F[0]]=F[0];}}}}delete A._parserData;return b;},_parseAnnotation:function(s,o,b){var Q=o.getAttribute("Qualifier")||b.getAttribute("Qualifier");var T=A.replaceWithAlias(b.getAttribute("Term"),A._parserData.aliases);if(Q){T+="#"+Q;}var v=A.getPropertyValue(b,A._parserData.aliases,s);v=A.setEdmTypes(v,A._parserData.metadataProperties.types,s,A._parserData.schema);return{key:T,value:v};},_parseReferences:function(b){var f=false;var n,i;var x=A._oXPath;var s="//edmx:Reference/edmx:Include[@Namespace and @Alias]";var o=x.selectNodes(s,A._parserData.xmlDocument);for(i=0;i<o.length;++i){f=true;n=x.nextNode(o,i);A._parserData.aliases[n.getAttribute("Alias")]=n.getAttribute("Namespace");}var r="//edmx:Reference[@Uri]/edmx:IncludeAnnotations[@TermNamespace]";var R=x.selectNodes(r,A._parserData.xmlDocument);for(i=0;i<R.length;++i){f=true;n=x.nextNode(R,i);var T=n.getAttribute("TermNamespace");var c=n.getAttribute("TargetNamespace");var d=n.parentNode.getAttribute("Uri");if(c){if(!b[c]){b[c]={};}b[c][T]=d;}else{b[T]=d;}}return f;},getAllPropertiesMetadata:function(M){var o={},P={},b={},c=false,n,e,C,E={},d={},f={},g=false,h,r,s,T,u,R={types:P};if(!M.dataServices.schema){return R;}for(var i=M.dataServices.schema.length-1;i>=0;i-=1){o=M.dataServices.schema[i];if(o.entityType){n=o.namespace;e=o.entityType;C=o.complexType;for(var j in e){E=e[j];f={};d={};for(var k in E.property){h=E.property[k];if(h.type.substring(0,n.length)===n){for(var l in C){if(C[l].name===h.type.substring(n.length+1)){for(k in C[l].property){r=C[l].property[k];d[C[l].name+"/"+r.name]=r.type;}}}}else{s=h.name;T=h.type;for(var p in h.extensions){u=h.extensions[p];if((u.name==="display-format")&&(u.value==="Date")){T="Edm.Date";}else{g=true;if(!f[s]){f[s]={};}if(u.namespace&&!f[s][u.namespace]){f[s][u.namespace]={};}f[s][u.namespace][u.name]=u.value;}}d[s]=T;}}if(!P[n+"."+E.name]){P[n+"."+E.name]={};}P[n+"."+E.name]=d;if(g){if(!b[n+"."+E.name]){c=true;}b[n+"."+E.name]={};b[n+"."+E.name]=f;}}}}if(c){R={types:P,extensions:b};}return R;},setEdmTypes:function(p,P,T,s){var o,e='';for(var b in p){if(p[b]){o=p[b];if(o.Value&&o.Value.Path){e=A.getEdmType(o.Value.Path,P,T,s);if(e){p[b].EdmType=e;}continue;}if(o.Path){e=A.getEdmType(o.Path,P,T,s);if(e){p[b].EdmType=e;}continue;}if(o.Facets){p[b].Facets=A.setEdmTypes(o.Facets,P,T,s);continue;}if(o.Data){p[b].Data=A.setEdmTypes(o.Data,P,T,s);continue;}if(b==="Data"){p.Data=A.setEdmTypes(o,P,T,s);continue;}if(o.Value&&o.Value.Apply){p[b].Value.Apply.Parameters=A.setEdmTypes(o.Value.Apply.Parameters,P,T,s);continue;}if(o.Value&&o.Type&&(o.Type==="Path")){e=A.getEdmType(o.Value,P,T,s);if(e){p[b].EdmType=e;}}}}return p;},getEdmType:function(p,P,T,s){var i=p.indexOf("/");if(i>-1){var b=p.substr(0,i);var n=A.findNavProperty(T,b);if(n){var c=A._parserData.metadataInstance._getEntityTypeByNavPropertyObject(n);if(c){T=c.entityType;p=p.substr(i+1);}}}if((p.charAt(0)==="@")&&(p.indexOf(s.Alias)===1)){p=p.slice(s.Alias.length+2);}if(p.indexOf("/")>=0){if(P[p.slice(0,p.indexOf("/"))]){T=p.slice(0,p.indexOf("/"));p=p.slice(p.indexOf("/")+1);}}for(var d in P[T]){if(p===d){return P[T][d];}}},enrichFromPropertyValueAttributes:function(b,n){var I={"Property":true,"Qualifier":true,"Term":true,"xmlns":true};for(var i=0;i<n.attributes.length;i+=1){var N=n.attributes[i].name;if(!I[N]&&(N.indexOf("xmlns:")!==0)){var v=n.attributes[i].value;if(N==="EnumMember"&&v.indexOf(" ")>-1){var V=v.split(" ");b[N]=V.map(A.replaceWithAlias).join(" ");}else{b[N]=A.replaceWithAlias(v);}}}return b;},_getRecordValues:function(n){var N=[];var x=A._oXPath;for(var i=0;i<n.length;++i){var o=x.nextNode(n,i);var v=A.getPropertyValues(o);var T=o.getAttribute("Type");if(T){v["RecordType"]=A.replaceWithAlias(T);}N.push(v);}return N;},_getTextValues:function(n){var N=[];var x=A._oXPath;for(var i=0;i<n.length;i+=1){var o=x.nextNode(n,i);var v={};var T=x.getNodeText(o);v[o.nodeName]=A._parserData.aliases?A.replaceWithAlias(T):T;N.push(v);}return N;},_getTextValue:function(n){var x=A._oXPath;var v="";if(n.nodeName in a){v=A.replaceWithAlias(x.getNodeText(n));}else{v=x.getNodeText(n);}if(n.nodeName!=="String"){v=v.trim();}return v;},getPropertyValue:function(d,s){var i;var x=A._oXPath;var p=d.nodeName==="Collection"?[]:{};if(d.hasChildNodes()){var r=x.selectNodes("./d:Record",d);var R=A._getRecordValues(r);var c=x.selectNodes("./d:Collection/d:Record | ./d:Collection/d:If/d:Record",d);var C=A._getRecordValues(c);var P=R.concat(C);if(P.length>0){if(c.length===0&&r.length>0){p=P[0];}else{p=P;}}else{var o=x.selectNodes("./d:Collection/d:AnnotationPath | ./d:Collection/d:NavigationPropertyPath | ./d:Collection/d:PropertyPath",d);if(o.length>0){p=A._getTextValues(o);}else{var b=x.selectNodes("./d:*[not(local-name() = \"Annotation\")]",d);if(b.length>0){for(i=0;i<b.length;i++){var e=x.nextNode(b,i);var v;var n=e.nodeName;var f=e.parentNode.nodeName;if(n==="Apply"){v=A.getApplyFunctions(e);}else{v=A.getPropertyValue(e);}if(m[f]){if(!Array.isArray(p)){p=[];}var V={};V[n]=v;p.push(V);}else if(n==="Collection"){p=v;}else{if(p[n]){q.sap.log.warning("Annotation contained multiple "+n+" values. Only the last "+"one will be stored: "+x.getPath(e));}p[n]=v;}}A.enrichFromPropertyValueAttributes(p,d);}else if(d.nodeName in t){p=A._getTextValue(d);}else{A.enrichFromPropertyValueAttributes(p,d);}}}var N=x.selectNodes("./d:Annotation",d);if(N.length>0){for(i=0;i<N.length;i++){var g=x.nextNode(N,i);var h=A._parseAnnotation(s,d,g);p[h.key]=h.value;}}}else if(d.nodeName in t){p=A._getTextValue(d);}else if(d.nodeName.toLowerCase()==="null"){p=null;}else{A.enrichFromPropertyValueAttributes(p,d);}return p;},getPropertyValues:function(p){var P={},i;var x=A._oXPath;var o=x.selectNodes("./d:Annotation",p);var b=x.selectNodes("./d:PropertyValue",p);function g(p,w,N){var h,j=p;while(j.localName!=="Annotation"){j=j.parentElement;}h=j.parentElement;return(w+" '"+N+"' is defined twice; "+"Annotation Target = "+h.getAttribute("Target")+", Term = "+j.getAttribute("Term"));}if(o.length===0&&b.length===0){P=A.getPropertyValue(p);}else{for(i=0;i<o.length;i++){var c=x.nextNode(o,i);var T=A.replaceWithAlias(c.getAttribute("Term"));P[T]=A.getPropertyValue(c);}for(i=0;i<b.length;i++){var d=x.nextNode(b,i);var s=d.getAttribute("Property");P[s]=A.getPropertyValue(d);var e=x.selectNodes("./d:Apply",d);for(var n=0;n<e.length;n+=1){var f=x.nextNode(e,n);P[s]={};P[s]['Apply']=A.getApplyFunctions(f);}}}return P;},getApplyFunctions:function(b){var x=A._oXPath;var c={Name:b.getAttribute('Function'),Parameters:[]};var p=x.selectNodes("./d:*",b);for(var i=0;i<p.length;i+=1){var P=x.nextNode(p,i);var d={Type:P.nodeName};if(P.nodeName==="Apply"){d.Value=A.getApplyFunctions(P);}else if(P.nodeName==="LabeledElement"){d.Value=A.getPropertyValue(P);d.Name=d.Value.Name;delete d.Value.Name;}else if(m[P.nodeName]){d.Value=A.getPropertyValue(P);}else{d.Value=x.getNodeText(P);}c.Parameters.push(d);}return c;},findNavProperty:function(e,p){var M=A._parserData.serviceMetadata;for(var i=M.dataServices.schema.length-1;i>=0;i-=1){var o=M.dataServices.schema[i];if(o.entityType){var n=o.namespace+".";var E=o.entityType;for(var k=E.length-1;k>=0;k-=1){if(n+E[k].name===e&&E[k].navigationProperty){for(var j=0;j<E[k].navigationProperty.length;j+=1){if(E[k].navigationProperty[j].name===p){return E[k].navigationProperty[j];}}}}}}return null;},replaceWithAlias:function(v,r){if(r===undefined){r=1;}for(var s in A._parserData.aliases){if(v.indexOf(s+".")>=0&&v.indexOf("."+s+".")<0){v=v.replace(s+".",A._parserData.aliases[s]+".");r--;if(r===0){return v;}}}return v;},getXPath:function(){var x={};var p=A._parserData;if(D.browser.msie){x={setNameSpace:function(o){o.setProperty("SelectionNamespaces",'xmlns:edmx="http://docs.oasis-open.org/odata/ns/edmx" xmlns:d="http://docs.oasis-open.org/odata/ns/edm"');o.setProperty("SelectionLanguage","XPath");return o;},selectNodes:function(x,i){return i.selectNodes(x);},nextNode:function(n){return n.nextNode();},getNodeText:function(n){return n.text;}};}else{x={setNameSpace:function(o){return o;},nsResolver:function(b){var n={"edmx":"http://docs.oasis-open.org/odata/ns/edmx","d":"http://docs.oasis-open.org/odata/ns/edm"};return n[b]||null;},selectNodes:function(P,i){var b=p.xmlDocument.evaluate(P,i,this.nsResolver,7,null);b.length=b.snapshotLength;return b;},nextNode:function(n,i){return n.snapshotItem(i);},getNodeText:function(n){return n.textContent;}};}x.getPath=function(n){var P="";var I="getAttribute"in n?n.getAttribute("id"):"";var T=n.tagName?n.tagName:"";if(I){P='id("'+I+'")';}else if(n instanceof Document){P="/";}else if(T.toLowerCase()==="body"){P=T;}else if(n.parentNode){var b=1;for(var i=0;i<n.parentNode.childNodes.length;++i){if(n.parentNode.childNodes[i]===n){P=x.getPath(n.parentNode)+"/"+T+"["+b+"]";break;}else if(n.parentNode.childNodes[i].nodeType===1&&n.parentNode.childNodes[i].tagName===T){++b;}}}else{q.sap.log.error("Wrong Input node - cannot find XPath to it: "+T);}return P;};return x;}};return A;});
sap.ui.predefine('sap/ui/model/odata/CountMode',function(){"use strict";var C={Request:"Request",Inline:"Inline",InlineRepeat:"InlineRepeat",Both:"Both",None:"None"};return C;},true);
sap.ui.predefine('sap/ui/model/odata/Filter',['sap/ui/base/Object','sap/ui/model/Filter','sap/ui/model/FilterOperator'],function(B,F,a){"use strict";
var O=B.extend("sap.ui.model.odata.Filter",{
constructor:function(p,v,A){if(typeof p==="object"){var f=p;p=f.path;v=f.values;A=f.and;}this.sPath=p;this.aValues=v;this.bAND=A==undefined?true:A;},
convert:function(){var f=[];for(var i=0,l=this.aValues&&this.aValues.length||0;i<l;i++){f.push(new F({path:this.sPath,operator:this.aValues[i].operator,value1:this.aValues[i].value1,value2:this.aValues[i].value2}));}if(f.length>1){var o=new F({filters:f,and:this.bAND});return o;}else{return f[0];}}
});
return O;});
sap.ui.predefine('sap/ui/model/odata/ODataAnnotations',['./AnnotationParser','jquery.sap.global','sap/ui/Device','sap/ui/base/EventProvider'],function(A,q,D,E){"use strict";
var O=E.extend("sap.ui.model.odata.ODataAnnotations",{
constructor:function(o){E.apply(this,arguments);if(arguments.length!==1){if(typeof arguments[2]==="object"){o=arguments[2];}o.urls=arguments[0];o.metadata=arguments[1];}this.oMetadata=o.metadata;this.oAnnotations=o.annotationData?o.annotationData:{};this.bLoaded=false;this.bAsync=o&&o.async;this.xPath=null;this.oError=null;this.bValidXML=true;this.oRequestHandles=[];this.oLoadEvent=null;this.oFailedEvent=null;this.mCustomHeaders=o.headers?q.extend({},o.headers):{};if(o.urls){this.addUrl(o.urls);if(!this.bAsync){if(this.oError){q.sap.log.error("OData annotations could not be loaded: "+this.oError.message);}}}},
metadata:{publicMethods:["parse","getAnnotationsData","attachFailed","detachFailed","attachLoaded","detachLoaded"]}
});
O.prototype.getAnnotationsData=function(){return this.oAnnotations;};
O.prototype.isLoaded=function(){return this.bLoaded;};
O.prototype.isFailed=function(){return this.oError!==null;};
O.prototype.fireLoaded=function(a){this.fireEvent("loaded",a);return this;};
O.prototype.attachLoaded=function(d,f,l){this.attachEvent("loaded",d,f,l);return this;};
O.prototype.detachLoaded=function(f,l){this.detachEvent("loaded",f,l);return this;};
O.prototype.fireFailed=function(a){this.fireEvent("failed",a);return this;};
O.prototype.attachFailed=function(d,f,l){this.attachEvent("failed",d,f,l);return this;};
O.prototype.detachFailed=function(f,l){this.detachEvent("failed",f,l);return this;};
O.prototype.setHeaders=function(h){this.mCustomHeaders=q.extend({},h);};
O.prototype._createXMLDocument=function(x,X){var o=null;if(typeof x==="string"){X=x;x=null;}if(D.browser.msie){o=new ActiveXObject("Microsoft.XMLDOM");o.preserveWhiteSpace=true;if(X.indexOf(" xmlns:xml=")>-1){X=X.replace(' xmlns:xml="http://www.w3.org/XML/1998/namespace"',"").replace(" xmlns:xml='http://www.w3.org/XML/1998/namespace'","");}o.loadXML(X);}else if(x){o=x;}else if(window.DOMParser){o=new DOMParser().parseFromString(X,'application/xml');}else{q.sap.log.fatal("The browser does not support XML parsing. Annotations are not available.");}return o;};
O.prototype._documentHasErrors=function(x){return(x.getElementsByTagName("parsererror").length>0||(x.parseError&&x.parseError.errorCode!==0));};
O.prototype._mergeAnnotationData=function(a,s){if(!this.oAnnotations){this.oAnnotations={};}A.merge(this.oAnnotations,a);this.bLoaded=true;if(!s){this.fireLoaded({annotations:a});}};
O.prototype.setXML=function(x,X,o){var d={success:function(){},error:function(){},fireEvents:false};o=q.extend({},d,o);var a=this._createXMLDocument(x,X);var p=function(a){var r={xmlDoc:a};var b=A.parse(this.oMetadata,a);if(b){r.annotations=b;o.success(r);this._mergeAnnotationData(b,!o.fireEvents);}else{o.error(r);if(o.fireEvents){this.fireFailed(r);}}}.bind(this,a);if(this._documentHasErrors(a)){o.error({xmlDoc:a});return false;}else{var m=this.oMetadata.getServiceMetadata();if(!m||q.isEmptyObject(m)){this.oMetadata.attachLoaded(p);}else{p();}return true;}};
O.prototype.addUrl=function(u){var t=this;var U=u;if(Array.isArray(u)&&u.length==0){return Promise.resolve({annotations:this.oAnnotations});}if(!Array.isArray(u)){U=[u];}return new Promise(function(r,R){var l=0;var m={annotations:null,success:[],fail:[]};var f=function(a){l++;if(a.type==="success"){m.success.push(a);}else{m.fail.push(a);}if(l===U.length){m.annotations=t.oAnnotations;if(m.success.length>0){var s={annotations:t.oAnnotations,results:m};t.fireLoaded(s);}if(m.success.length<U.length){var e=new Error("At least one annotation failed to load/parse/merge");e.annotations=m.annotations;e.success=m.success;e.fail=m.fail;R(e);}else{r(m);}}};var i=0;if(t.bAsync){var p=Promise.resolve();for(i=0;i<U.length;++i){var L=t._loadFromUrl.bind(t,U[i]);p=p.then(L,L).then(f,f);}}else{for(i=0;i<U.length;++i){t._loadFromUrl(U[i]).then(f,f);}}});};
O.prototype._loadFromUrl=function(u){var t=this;return new Promise(function(r,R){var a={url:u,async:t.bAsync,headers:q.extend({},t.mCustomHeaders,{"Accept-Language":sap.ui.getCore().getConfiguration().getLanguageTag()})};var o;var f=function(j,S){if(o&&o.bSuppressErrorHandlerCall){return;}t.oError={type:"fail",url:u,message:S,statusCode:j.statusCode,statusText:j.statusText,responseText:j.responseText};if(t.bAsync){t.oFailedEvent=q.sap.delayedCall(0,t,t.fireFailed,[t.oError]);}else{t.fireFailed(t.oError);}R(t.oError);};var s=function(d,S,j){t.setXML(j.responseXML,j.responseText,{success:function(m){r({type:"success",url:u,message:S,statusCode:j.statusCode,statusText:j.statusText,responseText:j.responseText});},error:function(m){f(j,"Malformed XML document");},url:u});};q.ajax(a).done(s).fail(f);});};
O.prototype.destroy=function(){for(var i=0;i<this.oRequestHandles.length;++i){if(this.oRequestHandles[i]){this.oRequestHandles[i].bSuppressErrorHandlerCall=true;this.oRequestHandles[i].abort();this.oRequestHandles[i]=null;}}E.prototype.destroy.apply(this,arguments);if(this.oLoadEvent){q.sap.clearDelayedCall(this.oLoadEvent);}if(this.oFailedEvent){q.sap.clearDelayedCall(this.oFailedEvent);}};
return O;});
sap.ui.predefine('sap/ui/model/odata/ODataContextBinding',['sap/ui/model/ContextBinding','sap/ui/model/ChangeReason'],function(C,a){"use strict";
var O=C.extend("sap.ui.model.odata.ODataContextBinding",{constructor:function(m,p,c,P,e){C.call(this,m,p,c,P,e);}});
O.prototype.initialize=function(){var t=this,r=this.oModel.resolve(this.sPath,this.oContext),d=this.oModel._getObject(this.sPath,this.oContext),R=this.oModel._isReloadNeeded(r,d,this.mParameters);if(this.oModel.oMetadata.isLoaded()){if(r&&R){this.fireDataRequested();}this.oModel.createBindingContext(this.sPath,this.oContext,this.mParameters,function(c){t.oElementContext=c;t._fireChange({reason:a.Context});if(r&&R){t.fireDataReceived();}},R);}};
O.prototype.refresh=function(f,c){var t=this,k,s,b=false,r=this.oModel.resolve(this.sPath,this.oContext);if(c){s=this.oModel._getObject(this.sPath,this.oContext);if(s){k=this.oModel._getKey(s);if(k in c){b=true;}}}else{b=true;}if(f||b){if(r){this.fireDataRequested();}this.oModel.createBindingContext(this.sPath,this.oContext,this.mParameters,function(o){if(t.oElementContext===o){if(f){t._fireChange({reason:a.Context});}}else{t.oElementContext=o;t._fireChange({reason:a.Context});}if(r){t.fireDataReceived();}},true);}};
O.prototype.setContext=function(c){var t=this,r,d,R;if(this.oContext!==c&&this.isRelative()){this.oContext=c;r=this.oModel.resolve(this.sPath,this.oContext);d=this.oModel._getObject(this.sPath,this.oContext);R=this.oModel._isReloadNeeded(r,d,this.mParameters);if(r&&R){this.fireDataRequested();}this.oModel.createBindingContext(this.sPath,this.oContext,this.mParameters,function(c){t.oElementContext=c;t._fireChange({reason:a.Context});if(r&&R){t.fireDataReceived();}},R);}};
return O;});
sap.ui.predefine('sap/ui/model/odata/ODataListBinding',['jquery.sap.global','sap/ui/model/ChangeReason','sap/ui/model/Filter','sap/ui/model/FilterType','sap/ui/model/ListBinding','sap/ui/model/Sorter','./ODataUtils','./CountMode'],function(q,C,F,a,L,S,O,b){"use strict";
var c=L.extend("sap.ui.model.odata.ODataListBinding",{constructor:function(m,p,o,s,f,P){L.apply(this,arguments);this.sFilterParams=null;this.sSortParams=null;this.sRangeParams=null;this.sCustomParams=this.oModel.createCustomParams(this.mParameters);this.iStartIndex=0;this.bPendingChange=false;this.aKeys=[];this.bInitial=true;this.sCountMode=(P&&P.countMode)||this.oModel.sDefaultCountMode;this.bRefresh=false;this.bNeedsUpdate=false;this.bDataAvailable=false;this.bIgnoreSuspend=false;this.oModel.checkFilterOperation(this.aApplicationFilters);if(!this.oModel.getServiceMetadata()){var t=this,d=function(e){t.bInitial=false;t._initSortersFilters();t.oModel.detachMetadataLoaded(d);};this.oModel.attachMetadataLoaded(this,d);}else{this.bInitial=false;this._initSortersFilters();}var r=this.oModel._getObject(this.sPath,this.oContext);this.aExpandRefs=r;if(Array.isArray(r)&&!s&&!f){this.aKeys=r;this.iLength=r.length;this.bLengthFinal=true;this.bDataAvailable=true;}else if(r===null&&this.oModel.resolve(this.sPath,this.oContext)){this.aKeys=[];this.iLength=0;this.bLengthFinal=true;this.bDataAvailable=true;}else{if(this.oModel.getServiceMetadata()){this.resetData();}}}});
c.prototype.getContexts=function(s,l,t){if(this.bInitial){return[];}this.iLastLength=l;this.iLastStartIndex=s;this.iLastThreshold=t;if(!s){s=0;}if(!l){l=this.oModel.iSizeLimit;if(this.bLengthFinal&&this.iLength<l){l=this.iLength;}}if(!t){t=0;}var d=true,e=this._getContexts(s,l),o={},f;f=this.calculateSection(s,l,t,e);d=e.length!=l&&!(this.bLengthFinal&&e.length>=this.iLength-s);if(this.oModel.getServiceMetadata()){if(!this.bPendingRequest&&f.length>0&&(d||l<f.length)){this.loadData(f.startIndex,f.length);e.dataRequested=true;}}if(this.bRefresh){if(this.bLengthFinal&&this.iLength==0){this.loadData(f.startIndex,f.length,true);e.dataRequested=true;}this.bRefresh=false;}else{for(var i=0;i<e.length;i++){o[e[i].getPath()]=e[i].getObject();}if(this.bUseExtendedChangeDetection){if(this.aLastContexts&&s<this.iLastEndIndex){var g=this;var D=q.sap.arrayDiff(this.aLastContexts,e,function(h,n){return q.sap.equal(h&&g.oLastContextData&&g.oLastContextData[h.getPath()],n&&o&&o[n.getPath()]);},true);e.diff=D;}}this.iLastEndIndex=s+l;this.aLastContexts=e.slice(0);this.oLastContextData=q.sap.extend(true,{},o);}return e;};
c.prototype.getCurrentContexts=function(){return this.aLastContexts||[];};
c.prototype._getContexts=function(s,l){var d=[],o,k;if(!s){s=0;}if(!l){l=this.oModel.iSizeLimit;if(this.bLengthFinal&&this.iLength<l){l=this.iLength;}}for(var i=s;i<s+l;i++){k=this.aKeys[i];if(!k){break;}o=this.oModel.getContext('/'+k);d.push(o);}return d;};
c.prototype.calculateSection=function(s,l,t,d){var e,f,p,P,r,o={},k;f=s;e=0;for(var i=s;i>=Math.max(s-t,0);i--){k=this.aKeys[i];if(!k){P=i+1;break;}}for(var j=s+l;j<s+l+t;j++){k=this.aKeys[j];if(!k){p=j;break;}}r=s-P;if(P&&s>t&&r<t){if(d.length!=l){f=s-t;}else{f=P-t;}e=t;}f=Math.max(f,0);if(f==s){f+=d.length;}if(d.length!=l){e+=l-d.length;}r=p-s-l;if(r==0){e+=t;}if(p&&r<t&&r>0){if(f>s){f=p;e+=t;}}if(this.bLengthFinal&&this.iLength<(e+f)){e=this.iLength-f;}o.startIndex=f;o.length=e;return o;};
c.prototype.setContext=function(o){if(this.oContext!=o){this.oContext=o;if(this.isRelative()){this._initSortersFilters();if(!this.bInitial){var r=this.oModel._getObject(this.sPath,this.oContext);this.aExpandRefs=r;if(Array.isArray(r)&&!this.aSorters.length>0&&!this.aFilters.length>0){this.aKeys=r;this.iLength=r.length;this.bLengthFinal=true;this._fireChange({reason:C.Context});}else if(!this.oModel.resolve(this.sPath,this.oContext)||r===null){this.aKeys=[];this.iLength=0;this.bLengthFinal=true;this._fireChange({reason:C.Context});}else{this.refresh();}}}}};
c.prototype.getDownloadUrl=function(f){var p=[],P;if(f){p.push("$format="+encodeURIComponent(f));}if(this.sSortParams){p.push(this.sSortParams);}if(this.sFilterParams){p.push(this.sFilterParams);}if(this.sCustomParams){p.push(this.sCustomParams);}P=this.oModel.resolve(this.sPath,this.oContext);if(P){return this.oModel._createRequestUrl(P,null,p);}};
c.prototype.loadData=function(s,l,p){var t=this,I=false;if(s||l){this.sRangeParams="$skip="+s+"&$top="+l;this.iStartIndex=s;}else{s=this.iStartIndex;}var P=[];if(this.sRangeParams){P.push(this.sRangeParams);}if(this.sSortParams){P.push(this.sSortParams);}if(this.sFilterParams){P.push(this.sFilterParams);}if(this.sCustomParams){P.push(this.sCustomParams);}if(!this.bLengthFinal&&(this.sCountMode==b.Inline||this.sCountMode==b.Both)){P.push("$inlinecount=allpages");I=true;}function f(D){q.each(D.results,function(i,h){t.aKeys[s+i]=t.oModel._getKey(h);});if(I&&D.__count){t.iLength=parseInt(D.__count,10);t.bLengthFinal=true;}if(t.iLength<s+D.results.length){t.iLength=s+D.results.length;t.bLengthFinal=false;}if(D.results.length<l||l===undefined){t.iLength=s+D.results.length;t.bLengthFinal=true;}if(s==0&&D.results.length==0){t.iLength=0;t.bLengthFinal=true;}t.oRequestHandle=null;t.bPendingRequest=false;t.bNeedsUpdate=true;t.bIgnoreSuspend=true;}function d(D){t.fireDataReceived({data:D});}function e(E,A){t.oRequestHandle=null;t.bPendingRequest=false;if(!A){t.aKeys=[];t.iLength=0;t.bLengthFinal=true;t.bDataAvailable=true;t._fireChange({reason:C.Change});}t.fireDataReceived();}function u(h){t.oRequestHandle=h;}var g=this.sPath,o=this.oContext;if(this.isRelative()){g=this.oModel.resolve(g,o);}if(g){if(p){var U=this.oModel._createRequestUrl(g,null,P);this.fireDataRequested();this.oModel.fireRequestSent({url:U,method:"GET",async:true});setTimeout(function(){t.bNeedsUpdate=true;t.checkUpdate();t.oModel.fireRequestCompleted({url:U,method:"GET",async:true,success:true});t.fireDataReceived({data:{}});},0);}else{this.bPendingRequest=true;this.fireDataRequested();this.oModel._loadData(g,P,f,e,false,u,d);}}};
c.prototype.getLength=function(){if(this.bLengthFinal||this.iLength==0){return this.iLength;}else{var A=this.iLastThreshold||this.iLastLength||10;return this.iLength+A;}};
c.prototype.isLengthFinal=function(){return this.bLengthFinal;};
c.prototype._getLength=function(){var t=this;var p=[];if(this.sFilterParams){p.push(this.sFilterParams);}if(this.mParameters&&this.mParameters.custom){var o={custom:{}};q.each(this.mParameters.custom,function(s,v){o.custom[s]=v;});p.push(this.oModel.createCustomParams(o));}function _(D){t.iLength=parseInt(D,10);t.bLengthFinal=true;}function d(e){var E="Request for $count failed: "+e.message;if(e.response){E+=", "+e.response.statusCode+", "+e.response.statusText+", "+e.response.body;}q.sap.log.warning(E);}var P=this.oModel.resolve(this.sPath,this.oContext);if(P){var u=this.oModel._createRequestUrl(P+"/$count",null,p);var r=this.oModel._createRequest(u,"GET",false);r.headers["Accept"]="text/plain, */*;q=0.5";this.oModel._request(r,_,d,undefined,undefined,this.oModel.getServiceMetadata());}};
c.prototype.refresh=function(f,m,e){var d=false;if(!f){if(e){var r=this.oModel.resolve(this.sPath,this.oContext);var E=this.oModel.oMetadata._getEntityTypeByPath(r);if(E&&(E.entityType in e)){d=true;}}if(m&&!d){q.each(this.aKeys,function(i,k){if(k in m){d=true;return false;}});}if(!m&&!e){d=true;}}if(f||d){this.abortPendingRequest();this.resetData();this._fireRefresh({reason:C.Refresh});}};
c.prototype._fireRefresh=function(A){if(this.oModel.resolve(this.sPath,this.oContext)){this.bRefresh=true;this.fireEvent("refresh",A);}};
c.prototype.initialize=function(){if(this.oModel.oMetadata.isLoaded()){if(this.bDataAvailable){this._fireChange({reason:C.Change});}else{this._fireRefresh({reason:C.Refresh});}}};
c.prototype.checkUpdate=function(f,m){var d=this.sChangeReason?this.sChangeReason:C.Change,e=false,l,o,t=this,r,R;if(this.bSuspended&&!this.bIgnoreSuspend){return;}if(!f&&!this.bNeedsUpdate){r=this.oModel._getObject(this.sPath,this.oContext);R=Array.isArray(r)&&!q.sap.equal(r,this.aExpandRefs);this.aExpandRefs=r;if(R){if(this.aSorters.length>0||this.aFilters.length>0){this.refresh();return;}else{this.aKeys=r;this.iLength=r.length;this.bLengthFinal=true;e=true;}}else if(m){q.each(this.aKeys,function(i,k){if(k in m){e=true;return false;}});}else{e=true;}if(e&&this.aLastContexts){e=false;var g=this._getContexts(this.iLastStartIndex,this.iLastLength,this.iLastThreshold);if(this.aLastContexts.length!=g.length){e=true;}else{q.each(this.aLastContexts,function(i,h){l=t.oLastContextData[h.getPath()];o=g[i].getObject();if(!q.sap.equal(l,o,true)){e=true;return false;}});}}}if(f||e||this.bNeedsUpdate){this.bNeedsUpdate=false;this._fireChange({reason:d});}this.sChangeReason=undefined;this.bIgnoreSuspend=false;};
c.prototype.resetData=function(){this.aKeys=[];this.iLength=0;this.bLengthFinal=false;this.sChangeReason=undefined;this.bDataAvailable=false;if(this.oModel.isCountSupported()&&(this.sCountMode==b.Request||this.sCountMode==b.Both)){this._getLength();}};
c.prototype.abortPendingRequest=function(){if(this.oRequestHandle){this.oRequestHandle.abort();this.oRequestHandle=null;this.bPendingRequest=false;}};
c.prototype.sort=function(s,r){var d=false;if(!s){s=[];}if(s instanceof S){s=[s];}this.aSorters=s;this.createSortParams(s);if(!this.bInitial){this.aKeys=[];this.abortPendingRequest();this.sChangeReason=C.Sort;this._fireRefresh({reason:this.sChangeReason});this._fireSort({sorter:s});d=true;}if(r){return d;}else{return this;}};
c.prototype.createSortParams=function(s){this.sSortParams=O.createSortParams(s);};
c.prototype.filter=function(f,s,r){var d=false;if(!f){f=[];}if(f instanceof F){f=[f];}this.oModel.checkFilterOperation(f);if(s==a.Application){this.aApplicationFilters=f;}else{this.aFilters=f;}if(!f||!Array.isArray(f)||f.length==0){this.aFilters=[];}if(!this.aApplicationFilters||!Array.isArray(this.aApplicationFilters)||this.aApplicationFilters.length===0){this.aApplicationFilters=[];}this.createFilterParams(this.aFilters,this.aApplicationFilters);if(!this.bInitial){this.resetData();this.abortPendingRequest();this.sChangeReason=C.Filter;this._fireRefresh({reason:this.sChangeReason});if(s==a.Application){this._fireFilter({filters:this.aApplicationFilters});}else{this._fireFilter({filters:this.aFilters});}d=true;}if(r){return d;}else{return this;}};
c.prototype.createFilterParams=function(d,A){var f,s=O._createFilterParams(d,this.oModel.oMetadata,this.oEntityType),e=O._createFilterParams(A,this.oModel.oMetadata,this.oEntityType);if(s){f=s;}if(e){if(s){f="("+f+")"+"%20and%20"+"("+e+")";}else{f=e;}}if(f){this.sFilterParams="$filter="+f;}else{this.sFilterParams=undefined;}};
c.prototype._initSortersFilters=function(){var r=this.oModel.resolve(this.sPath,this.oContext);if(!r){return;}this.oEntityType=this._getEntityType();this.createSortParams(this.aSorters);this.createFilterParams(this.aFilters.concat(this.aApplicationFilters));};
c.prototype._getEntityType=function(){var r=this.oModel.resolve(this.sPath,this.oContext);if(r){var e=this.oModel.oMetadata._getEntityTypeByPath(r);return e;}return undefined;};
c.prototype.resume=function(){this.bIgnoreSuspend=false;L.prototype.resume.apply(this,arguments);};
return c;});
sap.ui.predefine('sap/ui/model/odata/ODataMessageParser',["jquery.sap.global","sap/ui/model/odata/ODataUtils","sap/ui/Device","sap/ui/core/library","sap/ui/thirdparty/URI","sap/ui/core/message/MessageParser","sap/ui/core/message/Message"],function(q,O,D,c,U,M,a){"use strict";var b=c.MessageType;var s={"error":b.Error,"warning":b.Warning,"success":b.Success,"info":b.Information};
var d=M.extend("sap.ui.model.odata.ODataMessageParser",{
metadata:{publicMethods:["parse","setProcessor","getHeaderField","setHeaderField"]},
constructor:function(S,m){M.apply(this);this._serviceUrl=e(this._parseUrl(S).url);this._metadata=m;this._processor=null;this._headerField="sap-message";this._lastMessages=[];}
});
d.prototype.getHeaderField=function(){return this._headerField;};
d.prototype.setHeaderField=function(F){this._headerField=F;return this;};
d.prototype.parse=function(r,R,G,C){var m=[];var h={url:R?R.requestUri:r.requestUri,request:R,response:r};if(r.statusCode>=200&&r.statusCode<300){this._parseHeader(m,r,h);}else if(r.statusCode>=400&&r.statusCode<600){this._parseBody(m,r,h);}else{q.sap.log.warning("No rule to parse OData response with status "+r.statusCode+" for messages");}if(this._processor){this._propagateMessages(m,h,G,C);}else{this._outputMesages(m);}};
d.prototype._isNavigationProperty=function(p,P){var E=this._metadata._getEntityTypeByPath(p);if(E){var n=this._metadata._getNavigationPropertyNames(E);return n.indexOf(P)>-1;}return false;};
d.prototype._getAffectedTargets=function(m,r,G,C){var A=q.extend({"":true},G,C);var R=this._parseUrl(r).url;if(R.indexOf(this._serviceUrl)===0){R=R.substr(this._serviceUrl.length+1);}var E=this._metadata._getEntitySetByPath(R);if(E){A[E.name]=true;}for(var i=0;i<m.length;++i){var t=m[i].getTarget();if(t){var T=t.replace(/^\/+|\/$/g,"");A[T]=true;var S=T.lastIndexOf("/");if(S>0){var p=T.substr(0,S);var P=T.substr(S);var I=this._isNavigationProperty(p,P);if(!I){A[p]=true;}}}}return A;};
d.prototype._propagateMessages=function(m,r,G,C){var i,t;var A=this._getAffectedTargets(m,r.url,G,C);var R=[];var k=[];for(i=0;i<this._lastMessages.length;++i){t=this._lastMessages[i].getTarget().replace(/^\/+|\/$/g,"");var p=t.lastIndexOf(")/");if(p>0){t=t.substr(0,p+1);}if(A[t]&&!this._lastMessages[i].getPersistent()){R.push(this._lastMessages[i]);}else{k.push(this._lastMessages[i]);}}this.getProcessor().fireMessageChange({oldMessages:R,newMessages:m});this._lastMessages=k.concat(m);};
d.prototype._createMessage=function(m,r,i){var t=m["@sap.severity"]?m["@sap.severity"]:m["severity"];t=s[t]?s[t]:t;var C=m.code?m.code:"";var T=typeof m["message"]==="object"&&m["message"]["value"]?m["message"]["value"]:m["message"];var h=m.longtext_url?m.longtext_url:"";var p=false;if(!m.target&&m.propertyref){m.target=m.propertyref;}if(typeof m.target==="undefined"){m.target="";}if(m.target.indexOf("/#TRANSIENT#")===0){p=true;m.target=m.target.substr(12);}else if(m.transient){p=true;}var j=this._createTarget(m,r);return new a({type:t,code:C,message:T,descriptionUrl:h,target:O._normalizeKey(j),processor:this._processor,technical:i,persistent:p});};
d.prototype._getFunctionTarget=function(F,r,u){var t="";var i;if(r.response&&r.response.headers&&r.response.headers["location"]){t=r.response.headers["location"];var p=t.lastIndexOf(this._serviceUrl);if(p>-1){t=t.substr(p+this._serviceUrl.length);}}else{var A=null;if(F.extensions){for(i=0;i<F.extensions.length;++i){if(F.extensions[i].name==="action-for"){A=F.extensions[i].value;break;}}}var E;if(A){E=this._metadata._getEntityTypeByName(A);}else if(F.entitySet){E=this._metadata._getEntityTypeByPath(F.entitySet);}else if(F.returnType){E=this._metadata._getEntityTypeByName(F.returnType);}var m=this._metadata._getEntitySetByType(E);if(m&&E&&E.key&&E.key.propertyRef){var I="";var P;if(E.key.propertyRef.length===1){P=E.key.propertyRef[0].name;if(u.parameters[P]){I=u.parameters[P];}}else{var k=[];for(i=0;i<E.key.propertyRef.length;++i){P=E.key.propertyRef[i].name;if(u.parameters[P]){k.push(P+"="+u.parameters[P]);}}I=k.join(",");}t="/"+m.name+"("+I+")";}else if(!m){q.sap.log.error("Could not determine path of EntitySet for function call: "+u.url);}else{q.sap.log.error("Could not determine keys of EntityType for function call: "+u.url);}}return t;};
d.prototype._createTarget=function(m,r){var t=m.target;if(t.substr(0,1)!=="/"){var R="";var h=(r.request&&r.request.method)?r.request.method:"GET";var i=(h==="POST"&&r.response&&(r.response.statusCode==="201"||r.response.statusCode===201)&&r.response.headers&&r.response.headers["location"]);var u;if(i){u=r.response.headers["location"];}else if(r.request&&r.request.created&&r.response&&r.response.statusCode>=400){u=r.request.key;}else{u=r.url;}var j=this._parseUrl(u);var k=j.url;var p=k.lastIndexOf(this._serviceUrl);if(p>-1){R=k.substr(p+this._serviceUrl.length+1);}else{R=k;}if(!i){var F=this._metadata._getFunctionImportMetadata(R,h);if(F){R=this._getFunctionTarget(F,r,j);if(t){t=R+"/"+t;}else{t=R;}return t;}}R="/"+R;var S=R.lastIndexOf("/");var n=S>-1?R.substr(S):R;if(n.indexOf("(")>-1){t=R+"/"+t;}else{t=R+t;}}return t;};
d.prototype._parseHeader=function(m,r,R){var F=this.getHeaderField();if(!r.headers){return;}for(var k in r.headers){if(k.toLowerCase()===F.toLowerCase()){F=k;}}if(!r.headers[F]){return;}var h=r.headers[F];var S=null;try{S=JSON.parse(h);m.push(this._createMessage(S,R));if(Array.isArray(S.details)){for(var i=0;i<S.details.length;++i){m.push(this._createMessage(S.details[i],R));}}}catch(j){q.sap.log.error("The message string returned by the back-end could not be parsed");return;}};
d.prototype._parseBody=function(m,r,R){var C=g(r);if(C&&C.indexOf("xml")>-1){this._parseBodyXML(m,r,R,C);}else{this._parseBodyJSON(m,r,R);}if(m.length>1){for(var i=1;i<m.length;i++){if(m[0].getCode()==m[i].getCode()&&m[0].getMessage()==m[i].getMessage()){m.shift();break;}}}};
d.prototype._parseBodyXML=function(h,r,R,C){try{var o=new DOMParser().parseFromString(r.body,C);var E=f(o,["error","errordetail"]);for(var i=0;i<E.length;++i){var N=E[i];var j={};j["severity"]=b.Error;for(var n=0;n<N.childNodes.length;++n){var k=N.childNodes[n];var p=k.nodeName;if(p==="errordetails"||p==="details"||p==="innererror"||p==="#text"){continue;}if(p==="message"&&k.hasChildNodes()&&k.firstChild.nodeType!==window.Node.TEXT_NODE){for(var m=0;m<k.childNodes.length;++m){if(k.childNodes[m].nodeName==="value"){j["message"]=k.childNodes[m].text||k.childNodes[m].textContent;}}}else{j[k.nodeName]=k.text||k.textContent;}}h.push(this._createMessage(j,R,true));}}catch(t){q.sap.log.error("Error message returned by server could not be parsed");}};
d.prototype._parseBodyJSON=function(m,r,R){try{var E=JSON.parse(r.body);var o;if(E["error"]){o=E["error"];}else{o=E["odata.error"];}if(!o){q.sap.log.error("Error message returned by server did not contain error-field");return;}o["severity"]=b.Error;m.push(this._createMessage(o,R,true));var F=null;if(Array.isArray(o.details)){F=o.details;}else if(o.innererror&&Array.isArray(o.innererror.errordetails)){F=o.innererror.errordetails;}else{F=[];}for(var i=0;i<F.length;++i){m.push(this._createMessage(F[i],R,true));}}catch(h){q.sap.log.error("Error message returned by server could not be parsed");}};
d.prototype._parseUrl=function(u){var m={url:u,parameters:{},hash:""};var p=-1;p=u.indexOf("#");if(p>-1){m.hash=m.url.substr(p+1);m.url=m.url.substr(0,p);}p=u.indexOf("?");if(p>-1){var P=m.url.substr(p+1);m.parameters=U.parseQuery(P);m.url=m.url.substr(0,p);}return m;};
d.prototype._outputMesages=function(m){for(var i=0;i<m.length;++i){var o=m[i];var h="[OData Message] "+o.getMessage()+" - "+o.getDescription()+" ("+o.getTarget()+")";switch(m[i].getType()){case b.Error:q.sap.log.error(h);break;case b.Warning:q.sap.log.warning(h);break;case b.Success:q.sap.log.debug(h);break;case b.Information:case b.None:default:q.sap.log.info(h);break;}}};
function g(r){if(r&&r.headers){for(var h in r.headers){if(h.toLowerCase()==="content-type"){return r.headers[h].replace(/([^;]*);.*/,"$1");}}}return false;}
var l=document.createElement("a");
function e(u){l.href=u;return U.parse(l.href).path;}
function f(o,E){var h=[];var m={};for(var i=0;i<E.length;++i){m[E[i]]=true;}var j=o;while(j){if(m[j.tagName]){h.push(j);}if(j.hasChildNodes()){j=j.firstChild;}else{while(!j.nextSibling){j=j.parentNode;if(!j||j===o){j=null;break;}}if(j){j=j.nextSibling;}}}return h;}
return d;});
sap.ui.predefine('sap/ui/model/odata/ODataMetaModel',['jquery.sap.global','sap/ui/model/BindingMode','sap/ui/base/BindingParser','sap/ui/model/Context','sap/ui/base/ManagedObject','sap/ui/model/ClientContextBinding','sap/ui/model/FilterProcessor','sap/ui/model/json/JSONModel','sap/ui/model/json/JSONListBinding','sap/ui/model/json/JSONPropertyBinding','sap/ui/model/json/JSONTreeBinding','sap/ui/model/MetaModel','./_ODataMetaModelUtils'],function(q,B,a,C,M,b,F,J,c,d,e,f,U){"use strict";var o="sap.ui.model.odata.ODataMetaModel",p=[o],P=o+"/load",r=/^((\/dataServices\/schema\/\d+)\/(?:complexType|entityType)\/\d+)\/property\/\d+$/;var O=c.extend("sap.ui.model.odata.ODataMetaListBinding"),R=M.extend("sap.ui.model.odata._resolver",{metadata:{properties:{any:"any"}}});
O.prototype.applyFilter=function(){var t=this;this.aIndices=F.apply(this.aIndices,this.aFilters.concat(this.aApplicationFilters),function(v,s){return s==="@sapui.name"?v:t.oModel.getProperty(s,t.oList[v]);});this.iLength=this.aIndices.length;};
var g=f.extend("sap.ui.model.odata.ODataMetaModel",{constructor:function(m,A,h){var t=this;function l(){var D;if(t.bDestroyed){throw new Error("Meta model already destroyed");}q.sap.measure.average(P,"",p);D=JSON.parse(JSON.stringify(m.getServiceMetadata()));t.oModel=new J(D);t.oModel.setDefaultBindingMode(t.sDefaultBindingMode);U.merge(A?A.getAnnotationsData():{},D,t);q.sap.measure.end(P);}h=h||{};f.apply(this);this.oModel=null;this.mContext2Promise={};this.sDefaultBindingMode=B.OneTime;this.oLoadedPromise=h.annotationsLoadedPromise?h.annotationsLoadedPromise.then(l):new Promise(function(i,j){l();i();});this.oMetadata=m;this.oODataModelInterface=h;this.mQueryCache={};this.mQName2PendingRequest={};this.oResolver=undefined;this.mSupportedBindingModes={"OneTime":true};}});
g.prototype._getObject=function(s,h){var j=h,k,l,i,E,n,v,m,t=s||"",u;if(!h||h instanceof C){t=this.resolve(s||"",h);if(!t){q.sap.log.error("Invalid relative path w/o context",s,o);return null;}}if(t.charAt(0)==="/"){j=this.oModel._getObject("/");t=t.slice(1);}m="/";n=j;while(t){v=undefined;k=undefined;if(t.charAt(0)==='['){try{u=a.parseExpression(t,1);E=u.at;if(E>=0&&(t.length===E+1||t.charAt(E+1)==='/')){k=u.result;v=t.slice(0,E+1);t=t.slice(E+2);}}catch(w){if(!(w instanceof SyntaxError)){throw w;}}}if(v===undefined){E=t.indexOf("/");if(E<0){v=t;t="";}else{v=t.slice(0,E);t=t.slice(E+1);}}if(!n){if(q.sap.log.isLoggable(q.sap.log.Level.WARNING,o)){q.sap.log.warning("Invalid part: "+v,"path: "+s+", context: "+(h instanceof C?h.getPath():h),o);}break;}if(k){if(j===h){q.sap.log.error("A query is not allowed when an object context has been given",s,o);return null;}if(!Array.isArray(n)){q.sap.log.error("Invalid query: '"+m+"' does not point to an array",s,o);return null;}l=m+v;v=this.mQueryCache[l];if(v===undefined){this.oResolver=this.oResolver||new R({models:this.oModel});for(i=0;i<n.length;i++){this.oResolver.bindObject(m+i);this.oResolver.bindProperty("any",k);try{if(this.oResolver.getAny()){this.mQueryCache[l]=v=i;break;}}finally{this.oResolver.unbindProperty("any");this.oResolver.unbindObject();}}}}n=n[v];m=m+v+"/";}return n;};
g.prototype._mergeMetadata=function(h){var E=this.getODataEntityContainer(),m=U.getChildAnnotations(h.annotations,E.namespace+"."+E.name,true),i=E.entitySet.length,s=this.oModel.getObject("/dataServices/schema"),t=this;h.entitySets.forEach(function(j){var k,S,T=j.entityType,n=T.slice(0,T.lastIndexOf("."));if(!t.getODataEntitySet(j.name)){E.entitySet.push(JSON.parse(JSON.stringify(j)));if(!t.getODataEntityType(T)){k=t.oMetadata._getEntityTypeByName(T);S=U.getSchema(s,n);S.entityType.push(JSON.parse(JSON.stringify(k)));U.visitParents(S,h.annotations,"entityType",U.visitEntityType,S.entityType.length-1);}}});U.visitChildren(E.entitySet,m,"EntitySet",s,null,i);};
g.prototype._sendBundledRequest=function(){var Q=this.mQName2PendingRequest,h=Object.keys(Q),t=this;if(!h.length){return;}this.mQName2PendingRequest={};h=h.sort();h.forEach(function(s,i){h[i]=encodeURIComponent(s);});this.oODataModelInterface.addAnnotationUrl("$metadata?sap-value-list="+h.join(",")).then(function(i){var s;t._mergeMetadata(i);for(s in Q){try{Q[s].resolve(i);}catch(E){Q[s].reject(E);}}},function(E){var s;for(s in Q){Q[s].reject(E);}});};
g.prototype.bindContext=function(s,h,m){return new b(this,s,h,m);};
g.prototype.bindList=function(s,h,S,i,m){return new O(this,s,h,S,i,m);};
g.prototype.bindProperty=function(s,h,m){return new d(this,s,h,m);};
g.prototype.bindTree=function(s,h,i,m){return new e(this,s,h,i,m);};
g.prototype.destroy=function(){f.prototype.destroy.apply(this,arguments);return this.oModel&&this.oModel.destroy.apply(this.oModel,arguments);};
g.prototype.getMetaContext=function(s){var A,E,h,m,n,i,Q;function j(S){var k=S.indexOf("(");return k>=0?S.slice(0,k):S;}if(!s){return null;}i=s.split("/");if(i[0]!==""){throw new Error("Not an absolute path: "+s);}i.shift();E=this.getODataEntitySet(j(i[0]));if(!E){throw new Error("Entity set not found: "+i[0]);}i.shift();Q=E.entityType;while(i.length){h=this.getODataEntityType(Q);n=j(i[0]);A=this.getODataAssociationEnd(h,n);if(A){Q=A.type;if(A.multiplicity==="1"&&n!==i[0]){throw new Error("Multiplicity is 1: "+i[0]);}i.shift();}else{m=this.getODataProperty(h,i,true);if(i.length){throw new Error("Property not found: "+i.join("/"));}break;}}m=m||this.getODataEntityType(Q,true);return this.createBindingContext(m);};
g.prototype.getODataAssociationEnd=function(E,n){var N=E?U.findObject(E.navigationProperty,n):null,A=N?U.getObject(this.oModel,"association",N.relationship):null,h=A?U.findObject(A.end,N.toRole,"role"):null;return h;};
g.prototype.getODataAssociationSetEnd=function(E,n){var A,h=null,i=this.getODataEntityContainer(),N=E?U.findObject(E.navigationProperty,n):null;if(i&&N){A=U.findObject(i.associationSet,N.relationship,"association");h=A?U.findObject(A.end,N.toRole,"role"):null;}return h;};
g.prototype.getODataComplexType=function(Q,A){return U.getObject(this.oModel,"complexType",Q,A);};
g.prototype.getODataEntityContainer=function(A){var v=A?undefined:null,s=this.oModel.getObject("/dataServices/schema");if(s){s.forEach(function(S,i){var j=U.findIndex(S.entityContainer,"true","isDefaultEntityContainer");if(j>=0){v=A?"/dataServices/schema/"+i+"/entityContainer/"+j:S.entityContainer[j];return false;}});if(!v&&s.length===1&&s[0].entityContainer&&s[0].entityContainer.length===1){v=A?"/dataServices/schema/0/entityContainer/0":s[0].entityContainer[0];}}return v;};
g.prototype.getODataEntitySet=function(n,A){return U.getFromContainer(this.getODataEntityContainer(),"entitySet",n,A);};
g.prototype.getODataEntityType=function(Q,A){return U.getObject(this.oModel,"entityType",Q,A);};
g.prototype.getODataFunctionImport=function(n,A){var h=n&&n.indexOf('/')>=0?n.split('/'):undefined,E=h?U.getObject(this.oModel,"entityContainer",h[0]):this.getODataEntityContainer();return U.getFromContainer(E,"functionImport",h?h[1]:n,A);};
g.prototype.getODataProperty=function(t,n,A){var i,h=Array.isArray(n)?n:[n],j=null,s;while(t&&h.length){i=U.findIndex(t.property,h[0]);if(i<0){break;}h.shift();j=t.property[i];s=t.$path+"/property/"+i;if(h.length){t=this.getODataComplexType(j.type);}}return A?s:j;};
g.prototype.getODataValueLists=function(h){var i=false,m,s=h.getPath(),j=this.mContext2Promise[s],t=this;if(j){return j;}m=r.exec(s);if(!m){throw new Error("Unsupported property context with path "+s);}j=new Promise(function(k,l){var n=h.getObject(),Q,v=U.getValueLists(n);if(!(""in v)&&n["sap:value-list"]&&t.oODataModelInterface.addAnnotationUrl){i=true;Q=t.oModel.getObject(m[2]).namespace+"."+t.oModel.getObject(m[1]).name;t.mQName2PendingRequest[Q+"/"+n.name]={resolve:function(u){q.extend(n,((u.annotations.propertyAnnotations||{})[Q]||{})[n.name]);v=U.getValueLists(n);if(q.isEmptyObject(v)){l(new Error("No value lists returned for "+s));}else{delete t.mContext2Promise[s];k(v);}},reject:l};setTimeout(t._sendBundledRequest.bind(t),0);}else{k(v);}});if(i){this.mContext2Promise[s]=j;}return j;};
g.prototype.getProperty=function(){return this._getObject.apply(this,arguments);};
g.prototype.isList=function(){return this.oModel.isList.apply(this.oModel,arguments);};
g.prototype.loaded=function(){return this.oLoadedPromise;};
g.prototype.refresh=function(){throw new Error("Unsupported operation: ODataMetaModel#refresh");};
g.prototype.setLegacySyntax=function(l){if(l){throw new Error("Legacy syntax not supported by ODataMetaModel");}};
g.prototype.setProperty=function(){throw new Error("Unsupported operation: ODataMetaModel#setProperty");};
return g;});
sap.ui.predefine('sap/ui/model/odata/ODataMetadata',['jquery.sap.global','sap/ui/base/EventProvider','sap/ui/thirdparty/datajs'],function(q,E,O){"use strict";
var a=E.extend("sap.ui.model.odata.ODataMetadata",{
constructor:function(m,p){E.apply(this,arguments);this.bLoaded=false;this.bFailed=false;this.mEntityTypes={};this.mRequestHandles={};this.sUrl=m;this.bAsync=p.async;this.sUser=p.user;this.bWithCredentials=p.withCredentials;this.sPassword=p.password;this.mHeaders=p.headers;this.oLoadEvent=null;this.oFailedEvent=null;this.oMetadata=null;this.mNamespaces=p.namespaces||{sap:"http://www.sap.com/Protocols/SAPData",m:"http://schemas.microsoft.com/ado/2007/08/dataservices/metadata","":"http://schemas.microsoft.com/ado/2007/06/edmx"};var t=this;this.fnResolve;this.pLoaded=new Promise(function(r,b){t.fnResolve=r;});this._loadMetadata().catch(function(){q.sap.log.error("[ODataMetadata] initial loading of metadata failed");});},
metadata:{publicMethods:["getServiceMetadata","attachFailed","detachFailed","attachLoaded","detachLoaded","refresh"]}
});
a.prototype._setNamespaces=function(n){this.mNamespaces=n;};
a.prototype._loadMetadata=function(u,s){var t=this;u=u||this.sUrl;var r=this._createRequest(u);return new Promise(function(b,c){var R,e=[];function _(m,o){if(!m||!m.dataServices){var p={message:"Invalid metadata document",request:r,response:o};d(p);return;}t.sMetadataBody=o.body;t.oMetadata=t.oMetadata?t.merge(t.oMetadata,m,e):m;t.oRequestHandle=null;var P={metadataString:t.sMetadataBody,entitySets:e};var l=o.headers["Last-Modified"];if(l){P.lastModified=l;}t.fnResolve(P);b(P);if(t.bAsync&&!s){t.fireLoaded(t);}else if(!t.bAsync&&!s){t.bLoaded=true;t.bFailed=false;t.oLoadEvent=q.sap.delayedCall(0,t,t.fireLoaded,[P]);}}function d(o){var p={message:o.message,request:o.request,response:o.response};if(o.response){p.statusCode=o.response.statusCode;p.statusText=o.response.statusText;p.responseText=o.response.body;}if(R&&R.bSuppressErrorHandlerCall){return;}if(t.bAsync){delete t.mRequestHandles[R.id];}c(p);if(t.bAsync&&!s){t.fireFailed(p);}else if(!t.bAsync&&!s){t.bFailed=true;t.oFailedEvent=q.sap.delayedCall(0,t,t.fireFailed,[p]);}}R=O.request(r,_,d,O.metadataHandler);if(t.bAsync){R.id=q.sap.uid();t.mRequestHandles[R.id]=R;}});};
a.prototype.refresh=function(){return this._loadMetadata();};
a.prototype.getServiceMetadata=function(){return this.oMetadata;};
a.prototype.isLoaded=function(){return this.bLoaded;};
a.prototype.loaded=function(){return this.pLoaded;};
a.prototype.isFailed=function(){return this.bFailed;};
a.prototype.fireLoaded=function(p){this.bLoaded=true;this.bFailed=false;this.fireEvent("loaded",p);q.sap.log.debug(this+" - loaded was fired");return this;};
a.prototype.attachLoaded=function(d,f,l){this.attachEvent("loaded",d,f,l);return this;};
a.prototype.detachLoaded=function(f,l){this.detachEvent("loaded",f,l);return this;};
a.prototype.fireFailed=function(A){this.bFailed=true;this.fireEvent("failed",A);return this;};
a.prototype.attachFailed=function(d,f,l){this.attachEvent("failed",d,f,l);return this;};
a.prototype.detachFailed=function(f,l){this.detachEvent("failed",f,l);return this;};
a.prototype._getEntityTypeByPath=function(p){if(!p){return null;}if(!this.oMetadata||q.isEmptyObject(this.oMetadata)){return null;}if(this.mEntityTypes[p]){return this.mEntityTypes[p];}var c=p.replace(/^\/|\/$/g,""),P=c.split("/"),l=P.length,o,e,b,r,t=this;if(P[0].indexOf("(")!=-1){P[0]=P[0].substring(0,P[0].indexOf("("));}if(l>1){o=t._getEntityTypeByPath(P[0]);for(var i=1;i<P.length;i++){if(o){if(P[i].indexOf("(")!=-1){P[i]=P[i].substring(0,P[i].indexOf("("));}r=t._getEntityTypeByNavProperty(o,P[i]);if(r){o=r;}b=o;}}}else{e=this._splitName(this._getEntityTypeName(P[0]));b=this._getObjectMetadata("entityType",e[0],e[1]);if(b){b.entityType=this._getEntityTypeName(P[0]);}}if(!b){var f=P[P.length-1];var F=this._getFunctionImportMetadata(f,"GET");if(!F){F=this._getFunctionImportMetadata(f,"POST");}if(F&&F.entitySet){b=this._getEntityTypeByPath(F.entitySet);if(b){b.entityType=this._getEntityTypeName(F.entitySet);}}}if(b){this.mEntityTypes[p]=b;}return b;};
a.prototype._getEntityTypeByName=function(n){var e,t=this,s,N,S;if(!n){return null;}S=n.indexOf(".");if(S>0){N=n.substr(0,S);s=n.substr(S+1);}else{s=n;}if(!this.oMetadata||q.isEmptyObject(this.oMetadata)){return null;}if(this.mEntityTypes[n]){e=this.mEntityTypes[n];}else{q.each(this.oMetadata.dataServices.schema,function(i,o){if(o.entityType&&(!N||o.namespace===N)){q.each(o.entityType,function(k,b){if(b.name===s){e=b;t.mEntityTypes[n]=e;e.namespace=o.namespace;return false;}});}});}return e;};
a.prototype._getAnnotation=function(p){var n,P,m,M,e,s,o;P=p.split('/#');M=P[1].split('/');if(!P[0]){e=this._getEntityTypeByName(M[0]);if(!e){return;}s=P[1].substr(P[1].indexOf('/')+1);o=this._getPropertyMetadata(e,s);if(!o){return;}m=s.substr(s.indexOf(o.name));m=m.substr(m.indexOf('/')+1);}else{e=this._getEntityTypeByPath(P[0]);if(!e){return;}p=P[0].replace(/^\/|\/$/g,"");s=p.substr(p.indexOf('/')+1);o=this._getPropertyMetadata(e,s);if(!o){return;}m=M.join('/');}n=this._getAnnotationObject(e,o,m);return n;};
a.prototype._getAnnotationObject=function(e,o,m){var A,p,b,n,s;if(!o){return;}n=o;p=m.split('/');if(p[0].indexOf('.')>-1){return this._getV4AnnotationObject(e,o,p);}else{if(p.length>1){n=n[p[0]];if(!n&&o.extensions){for(var i=0;i<o.extensions.length;i++){var c=o.extensions[i];if(c.name==p[0]){n=c;break;}}}m=p.splice(0,1);b=this._getAnnotationObject(e,n,p.join('/'));}else{if(p[0].indexOf('@')>-1){s=p[0].substr(1);A=s.split(':');b=n[A[0]];if(!b&&n.extensions){for(var i=0;i<n.extensions.length;i++){var c=n.extensions[i];if(c.name===A[1]&&c.namespace===this.mNamespaces[A[0]]){b=c.value;break;}}}}else{A=p[0].split(':');b=n[A[0]];b=n[p[0]];if(!b&&n.extensions){for(var i=0;i<n.extensions.length;i++){var c=n.extensions[i];if(c.name===A[1]&&c.namespace===this.mNamespaces[A[0]]){b=c;break;}}}}}}return b;};
a.prototype._getV4AnnotationObject=function(e,o,p){var A,b=[];if(p.length>1){return;}var t=e.namespace?e.namespace+".":"";t+=e.name+"/"+o.name;q.each(this.oMetadata.dataServices.schema,function(i,s){if(s.annotations){q.each(s.annotations,function(k,o){if(o.target===t&&!o.qualifier){b.push(o.annotation);return false;}});}});if(b){q.each(b,function(i,c){q.each(c,function(j,d){if(d.term===p[0]){A=d;}});});}return A;};
a.prototype._splitName=function(f){var p=[];if(f){var s=f.lastIndexOf(".");p[0]=f.substr(s+1);p[1]=f.substr(0,s);}return p;};
a.prototype._getEntityTypeName=function(c){var e;if(c){q.each(this.oMetadata.dataServices.schema,function(i,s){if(s.entityContainer){q.each(s.entityContainer,function(k,o){if(o.entitySet){q.each(o.entitySet,function(j,b){if(b.name===c){e=b.entityType;return false;}});}});}});}return e;};
a.prototype._getObjectMetadata=function(o,s,n){var b;if(s&&n){q.each(this.oMetadata.dataServices.schema,function(i,S){if(S[o]&&S.namespace===n){q.each(S[o],function(j,c){if(c.name===s){b=c;b.namespace=S.namespace;return false;}});return!b;}});}return b;};
a.prototype.getUseBatch=function(){var u=false;q.each(this.oMetadata.dataServices.schema,function(i,s){if(s.entityContainer){q.each(s.entityContainer,function(k,e){if(e.extensions){q.each(e.extensions,function(l,o){if(o.name==="use-batch"&&o.namespace==="http://www.sap.com/Protocols/SAPData"){u=(typeof o.value==='string')?(o.value.toLowerCase()==='true'):!!o.value;return false;}});}});}});return u;};
a.prototype._getFunctionImportMetadata=function(f,m){var o=null;if(f.indexOf("/")>-1){f=f.substr(f.indexOf("/")+1);}q.each(this.oMetadata.dataServices.schema,function(i,s){if(s["entityContainer"]){q.each(s["entityContainer"],function(j,e){if(e["functionImport"]){q.each(e["functionImport"],function(k,F){if(F.name===f&&F.httpMethod===m){o=F;return false;}});}return!o;});}return!o;});return o;};
a.prototype._getEntityTypeByNavProperty=function(e,n){if(!e.navigationProperty){return undefined;}for(var i=0;i<e.navigationProperty.length;++i){var N=e.navigationProperty[i];if(N.name===n){return this._getEntityTypeByNavPropertyObject(N);}}return undefined;};
a.prototype._getEntityTypeByNavPropertyObject=function(n){var t;var A=this._splitName(n.relationship);var m=this._getObjectMetadata("association",A[0],A[1]);if(m){var e=m.end[0];if(e.role!==n.toRole){e=m.end[1];}var b=this._splitName(e.type);t=this._getObjectMetadata("entityType",b[0],b[1]);if(t){t.entityType=e.type;}}return t;};
a.prototype._getNavigationPropertyNames=function(e){var n=[];if(e.navigationProperty){q.each(e.navigationProperty,function(k,N){n.push(N.name);});}return n;};
a.prototype._getPropertyMetadata=function(e,p){var P,t=this;if(!e){return;}p=p.replace(/^\/|\/$/g,"");var b=p.split("/");q.each(e.property,function(k,c){if(c.name===b[0]){P=c;return false;}});if(P&&b.length>1&&!q.sap.startsWith(P.type.toLowerCase(),"edm.")){var n=this._splitName(P.type);P=this._getPropertyMetadata(this._getObjectMetadata("complexType",n[0],n[1]),b[1]);}if(!P&&b.length>1){var o=this._getEntityTypeByNavProperty(e,b[0]);if(o){P=t._getPropertyMetadata(o,b[1]);}}return P;};
a.prototype.destroy=function(){delete this.oMetadata;var t=this;q.each(this.mRequestHandles,function(k,r){r.bSuppressErrorHandlerCall=true;r.abort();delete t.mRequestHandles[k];});if(!!this.oLoadEvent){q.sap.clearDelayedCall(this.oLoadEvent);}if(!!this.oFailedEvent){q.sap.clearDelayedCall(this.oFailedEvent);}E.prototype.destroy.apply(this,arguments);};
a.prototype._createRequest=function(u){var h={},l={"Accept-Language":sap.ui.getCore().getConfiguration().getLanguageTag()};q.extend(h,this.mHeaders,l);var r={headers:h,requestUri:u,method:'GET',user:this.sUser,password:this.sPassword,async:this.bAsync};if(this.bAsync){r.withCredentials=this.bWithCredentials;}return r;};
a.prototype._getEntitySetByPath=function(e){if(!this._entitySetMap){this._entitySetMap={};this.oMetadata.dataServices.schema.forEach(function(s){if(s.entityContainer){s.entityContainer.forEach(function(c){if(c.entitySet){c.entitySet.forEach(function(m){this._entitySetMap[m.entityType]=m;},this);}},this);}},this);}var o=this._getEntityTypeByPath(e);if(o){return this._entitySetMap[o.entityType];}return;};
a.prototype._addUrl=function(u){var U=[].concat(u);return Promise.all(U.map(function(s){return this._loadMetadata(s,true);},this));};
a.prototype.merge=function(t,s,e){var b=this;q.each(t.dataServices.schema,function(i,T){q.each(s.dataServices.schema,function(j,S){if(S.namespace===T.namespace){if(S.entityType){if(!b.mEntityTypeNames){b.mEntityTypeNames={};T.entityType.map(function(o){b.mEntityTypeNames[o.name]=true;});}T.entityType=!T.entityType?[]:T.entityType;for(var i=0;i<S.entityType.length;i++){if(!(S.entityType[i].name in b.mEntityTypeNames)){T.entityType.push(S.entityType[i]);b.mEntityTypeNames[S.entityType[i].name]=true;}}}if(T.entityContainer&&S.entityContainer){q.each(T.entityContainer,function(k,c){q.each(S.entityContainer,function(l,d){if(d.entitySet){if(d.name===c.name){if(!b.mEntitySetNames){b.mEntitySetNames={};c.entitySet.map(function(o){b.mEntitySetNames[o.name]=true;});}c.entitySet=!c.entitySet?[]:c.entitySet;for(var i=0;i<d.entitySet.length;i++){if(!(d.entitySet[i].name in b.mEntitySetNames)){c.entitySet.push(d.entitySet[i]);b.mEntitySetNames[d.entitySet[i].name]=true;}}d.entitySet.forEach(function(o){e.push(o);});}}});});}if(S.annotations){T.annotations=!T.annotations?[]:T.annotations;T.annotations=T.annotations.concat(S.annotations);}}});});return t;};
a.prototype._getEntitySetByType=function(e){var s=e.namespace+"."+e.name;var S=this.oMetadata.dataServices.schema;for(var i=0;i<S.length;++i){var c=S[i].entityContainer;if(c){for(var n=0;n<c.length;++n){var b=c[n].entitySet;if(b){for(var m=0;m<b.length;++m){if(b[m].entityType===s){return b[m];}}}}}}return null;};
return a;});
sap.ui.predefine('sap/ui/model/odata/ODataModel',['jquery.sap.global','sap/ui/model/BindingMode','sap/ui/model/Context','sap/ui/model/Model','./ODataUtils','./CountMode','./ODataContextBinding','./ODataListBinding','./ODataMetadata','./ODataPropertyBinding','./ODataTreeBinding','sap/ui/model/odata/ODataMetaModel','sap/ui/thirdparty/URI','sap/ui/thirdparty/datajs'],function(q,B,C,M,O,a,b,c,d,e,f,g,U,h){"use strict";
var m=M.extend("sap.ui.model.odata.ODataModel",{
constructor:function(s,j,u,p,H,t,w,l){M.apply(this,arguments);var i,r,k,A=null,L,n,D,S,o,v,x=this;if(typeof(s)==="object"){j=s;s=j.serviceUrl;}if(typeof j==="object"){u=j.user;p=j.password;H=j.headers;t=j.tokenHandling;l=j.loadMetadataAsync;w=j.withCredentials;k=j.maxDataServiceVersion;i=j.useBatch;r=j.refreshAfterChange;A=j.annotationURI;L=j.loadAnnotationsJoined;D=j.defaultCountMode;n=j.metadataNamespaces;S=j.serviceUrlParams;o=j.metadataUrlParams;v=j.skipMetadataAnnotationParsing;j=j.json;}this.oServiceData={};this.sDefaultBindingMode=B.OneWay;this.mSupportedBindingModes={"OneWay":true,"OneTime":true,"TwoWay":true};this.mUnsupportedFilterOperators={"Any":true,"All":true};this.bCountSupported=true;this.bJSON=j;this.bCache=true;this.aPendingRequestHandles=[];this.oRequestQueue={};this.aBatchOperations=[];this.oHandler;this.bTokenHandling=t!==false;this.bWithCredentials=w===true;this.bUseBatch=i===true;this.bRefreshAfterChange=r!==false;this.sMaxDataServiceVersion=k;this.bLoadMetadataAsync=!!l;this.bLoadAnnotationsJoined=L===undefined?true:L;this.sAnnotationURI=A;this.sDefaultCountMode=D||a.Both;this.oMetadataLoadEvent=null;this.oMetadataFailedEvent=null;this.bSkipMetadataAnnotationParsing=v;this.oHeaders={};this.setHeaders(H);this.oData={};this.oMetadata=null;this.oAnnotations=null;this.aUrlParams=[];if(s.indexOf("?")==-1){this.sServiceUrl=s;}else{var y=s.split("?");this.sServiceUrl=y[0];if(y[1]){this.aUrlParams.push(y[1]);}}if(sap.ui.getCore().getConfiguration().getStatistics()){this.aUrlParams.push("sap-statistics=true");}this.sServiceUrl=this.sServiceUrl.replace(/\/$/,"");var z=this._createRequestUrl("$metadata",undefined,o);if(!m.mServiceData[z]){m.mServiceData[z]={};}this.oServiceData=m.mServiceData[z];if(this.bTokenHandling&&this.oServiceData.securityToken){this.oHeaders["x-csrf-token"]=this.oServiceData.securityToken;}this.sUser=u;this.sPassword=p;this.oHeaders["Accept-Language"]=sap.ui.getCore().getConfiguration().getLanguageTag();if(!this.oServiceData.oMetadata){this.oServiceData.oMetadata=new d(z,{async:this.bLoadMetadataAsync,user:this.sUser,password:this.sPassword,headers:this.mCustomHeaders,namespaces:n,withCredentials:this.bWithCredentials});}this.oMetadata=this.oServiceData.oMetadata;this.pAnnotationsLoaded=this.oMetadata.loaded();if(this.sAnnotationURI||!this.bSkipMetadataAnnotationParsing){var E=this._getAnnotationParser();if(!this.bSkipMetadataAnnotationParsing){if(!this.bLoadMetadataAsync){this.addAnnotationXML(this.oMetadata.sMetadataBody,!!this.sAnnotationURI);}else{this.pAnnotationsLoaded=this.oMetadata.loaded().then(function(F,P){if(this.bDestroyed){return Promise.reject();}return this.addAnnotationXML(P["metadataString"],F);}.bind(this,!!this.sAnnotationURI));}}if(this.sAnnotationURI){if(this.bLoadMetadataAsync){this.pAnnotationsLoaded=this.pAnnotationsLoaded.then(E.addUrl.bind(E,this.sAnnotationURI));}else{this.pAnnotationsLoaded=Promise.all([this.pAnnotationsLoaded,E.addUrl(this.sAnnotationURI)]);}}}if(S){this.aUrlParams=this.aUrlParams.concat(O._createUrlParamsArray(S));}this.onMetadataLoaded=function(F){x._initializeMetadata();x.initialize();};this.onMetadataFailed=function(F){x.fireMetadataFailed(F.getParameters());};if(!this.oMetadata.isLoaded()){this.oMetadata.attachLoaded(this.onMetadataLoaded);this.oMetadata.attachFailed(this.onMetadataFailed);}if(this.oMetadata.isFailed()){this.refreshMetadata();}if(this.oMetadata.isLoaded()){this._initializeMetadata(true);}if(this.bJSON){if(this.sMaxDataServiceVersion==="3.0"){this.oHeaders["Accept"]="application/json;odata=fullmetadata";}else{this.oHeaders["Accept"]="application/json";}this.oHandler=h.jsonHandler;}else{this.oHeaders["Accept"]="application/atom+xml,application/atomsvc+xml,application/xml";this.oHandler=h.atomHandler;}this.oHeaders["MaxDataServiceVersion"]="2.0";if(this.sMaxDataServiceVersion){this.oHeaders["MaxDataServiceVersion"]=this.sMaxDataServiceVersion;}this.oHeaders["DataServiceVersion"]="2.0";},
metadata:{publicMethods:["create","remove","update","submitChanges","getServiceMetadata","read","hasPendingChanges","refresh","refreshMetadata","resetChanges","isCountSupported","setCountSupported","setDefaultCountMode","getDefaultCountMode","forceNoCache","setProperty","getSecurityToken","refreshSecurityToken","setHeaders","getHeaders","setUseBatch"]}
});
m.M_EVENTS={RejectChange:"rejectChange",MetadataLoaded:"metadataLoaded",MetadataFailed:"metadataFailed",AnnotationsLoaded:"annotationsLoaded",AnnotationsFailed:"annotationsFailed"};m.mServiceData={};
m.prototype.fireRejectChange=function(A){this.fireEvent("rejectChange",A);return this;};
m.prototype.attachRejectChange=function(D,F,l){this.attachEvent("rejectChange",D,F,l);return this;};
m.prototype.detachRejectChange=function(F,l){this.detachEvent("rejectChange",F,l);return this;};
m.prototype._initializeMetadata=function(D){var t=this;this.bUseBatch=this.bUseBatch||this.oMetadata.getUseBatch();var i=function(j){if(!!j){t.metadataLoadEvent=q.sap.delayedCall(0,t,i);}else{if(t.oMetadata){t.fireMetadataLoaded({metadata:t.oMetadata});q.sap.log.debug("ODataModel fired metadataloaded");}}};if(this.sAnnotationURI&&this.bLoadAnnotationsJoined){if(this.oAnnotations&&(this.oAnnotations.bInitialized||this.oAnnotations.isFailed())){i(!this.bLoadMetadataAsync);}else{this.oAnnotations.attachEventOnce("loaded",function(){i(true);});}}else{i(D);}};
m.prototype.fireAnnotationsLoaded=function(A){if(!this.bLoadMetadataAsync){setTimeout(this.fireEvent.bind(this,"annotationsLoaded",A),0);}else{this.fireEvent("annotationsLoaded",A);}return this;};
m.prototype.attachAnnotationsLoaded=function(D,F,l){this.attachEvent("annotationsLoaded",D,F,l);return this;};
m.prototype.detachAnnotationsLoaded=function(F,l){this.detachEvent("annotationsLoaded",F,l);return this;};
m.prototype.fireAnnotationsFailed=function(A){if(!this.bLoadMetadataAsync){setTimeout(this.fireEvent.bind(this,"annotationsFailed",A),0);}else{this.fireEvent("annotationsFailed",A);}q.sap.log.debug("ODataModel fired annotationsfailed");return this;};
m.prototype.attachAnnotationsFailed=function(D,F,l){this.attachEvent("annotationsFailed",D,F,l);return this;};
m.prototype.detachAnnotationsFailed=function(F,l){this.detachEvent("annotationsFailed",F,l);return this;};
m.prototype.fireMetadataLoaded=function(A){this.fireEvent("metadataLoaded",A);return this;};
m.prototype.attachMetadataLoaded=function(D,F,l){this.attachEvent("metadataLoaded",D,F,l);return this;};
m.prototype.detachMetadataLoaded=function(F,l){this.detachEvent("metadataLoaded",F,l);return this;};
m.prototype.fireMetadataFailed=function(A){this.fireEvent("metadataFailed",A);return this;};
m.prototype.attachMetadataFailed=function(D,F,l){this.attachEvent("metadataFailed",D,F,l);return this;};
m.prototype.detachMetadataFailed=function(F,l){this.detachEvent("metadataFailed",F,l);return this;};
m.prototype.refreshMetadata=function(){if(this.oMetadata&&this.oMetadata.refresh){this.oMetadata.refresh();}};
m.prototype._createRequestUrl=function(p,o,u,i,j){var k,r,s,l="";if(p&&p.indexOf('?')!=-1){s=p.substr(p.indexOf('?')+1);p=p.substr(0,p.indexOf('?'));}r=this._normalizePath(p,o);if(!i){l=this.sServiceUrl+r;}else{l=r.substr(r.indexOf('/')+1);}k=O._createUrlParamsArray(u);if(this.aUrlParams){k=k.concat(this.aUrlParams);}if(s){k.push(s);}if(k.length>0){l+="?"+k.join("&");}if(j===undefined){j=true;}if(j===false){var t=q.now();var n=l.replace(/([?&])_=[^&]*/,"$1_="+t);l=n+((n===l)?(/\?/.test(l)?"&":"?")+"_="+t:"");}return l;};
m.prototype._loadData=function(p,P,s,E,i,H,j){var r,R,t=this;function _(D,o){var v=D,w={};if(o.statusCode==204){if(s){s(null);}if(j){j(null);}t.fireRequestCompleted({url:R.requestUri,type:"GET",async:R.async,info:"Accept headers:"+t.oHeaders["Accept"],infoObject:{acceptHeaders:t.oHeaders["Accept"]},success:true});return;}if(!v){q.sap.log.fatal("The following problem occurred: No data was retrieved by service: "+o.requestUri);t.fireRequestCompleted({url:R.requestUri,type:"GET",async:R.async,info:"Accept headers:"+t.oHeaders["Accept"],infoObject:{acceptHeaders:t.oHeaders["Accept"]},success:false});return false;}if(t.bUseBatch){var x=t._getBatchErrors(D);if(x.length>0){k(x[0]);return false;}if(v.__batchResponses&&v.__batchResponses.length>0){v=v.__batchResponses[0].data;}else{q.sap.log.fatal("The following problem occurred: No data was retrieved by service: "+o.requestUri);}}n=n.concat(v.results);if(v.__next){var y=new U(v.__next);R.requestUri=y.absoluteTo(o.requestUri).toString();l(R);}else{q.sap.extend(v.results,n);if(v.results&&!Array.isArray(v.results)){v=v.results;}t._importData(v,w);if(t.sChangeKey&&w){var z=t.sChangeKey.substr(t.sChangeKey.lastIndexOf('/')+1);if(w[z]){delete t.oRequestQueue[t.sChangeKey];t.sChangeKey=null;}}if(s){s(v);}t.checkUpdate(false,false,w);if(j){j(v);}t.fireRequestCompleted({url:R.requestUri,type:"GET",async:R.async,info:"Accept headers:"+t.oHeaders["Accept"],infoObject:{acceptHeaders:t.oHeaders["Accept"]},success:true});}}function k(o){if(t.bTokenHandling&&o.response){var T=t._getHeader("x-csrf-token",o.response.headers);if(!R.bTokenReset&&o.response.statusCode=='403'&&T&&T.toLowerCase()=="required"){t.resetSecurityToken();R.bTokenReset=true;l();return;}}var v=t._handleError(o);if(E){E(o,r&&r.bAborted);}t.fireRequestCompleted({url:R.requestUri,type:"GET",async:R.async,info:"Accept headers:"+t.oHeaders["Accept"],infoObject:{acceptHeaders:t.oHeaders["Accept"]},success:false,errorobject:v});if(!r||!r.bAborted){v.url=R.requestUri;t.fireRequestFailed(v);}}function l(){if(t.bUseBatch){t.updateSecurityToken();var o=U.parse(R.requestUri).query;var v=t._createRequestUrl(p,null,o,t.bUseBatch);R=t._createRequest(v,"GET",true);var w=t._createBatchRequest([R],true);r=t._request(w,_,k,h.batchHandler,undefined,t.getServiceMetadata());}else{r=t._request(R,_,k,t.oHandler,undefined,t.getServiceMetadata());}if(H){var W={abort:function(){r.bAborted=true;r.abort();}};H(W);}}var n=[];var u=this._createRequestUrl(p,null,P,null,i||this.bCache);R=this._createRequest(u,"GET",true);this.fireRequestSent({url:R.requestUri,type:"GET",async:R.async,info:"Accept headers:"+this.oHeaders["Accept"],infoObject:{acceptHeaders:this.oHeaders["Accept"]}});l();};
m.prototype._importData=function(D,k){var t=this,l,K,r,E;if(D.results){l=[];q.each(D.results,function(i,j){l.push(t._importData(j,k));});return l;}else{K=this._getKey(D);E=this.oData[K];if(!E){E=D;this.oData[K]=E;}q.each(D,function(n,p){if(p&&(p.__metadata&&p.__metadata.uri||p.results)&&!p.__deferred){r=t._importData(p,k);if(Array.isArray(r)){E[n]={__list:r};}else{E[n]={__ref:r};}}else if(!p||!p.__deferred){E[n]=p;}});k[K]=true;return K;}};
m.prototype._removeReferences=function(D){var t=this,l;if(D.results){l=[];q.each(D.results,function(i,j){l.push(t._removeReferences(j));});return l;}else{q.each(D,function(p,o){if(o){if(o["__ref"]||o["__list"]){delete D[p];}}});return D;}};
m.prototype._restoreReferences=function(D){var t=this,l,r=[];if(D.results){l=[];q.each(D.results,function(i,j){l.push(t._restoreReferences(j));});return l;}else{q.each(D,function(p,o){if(o&&o["__ref"]){var i=t._getObject("/"+o["__ref"]);if(i){delete o["__ref"];D[p]=i;t._restoreReferences(i);}}else if(o&&o["__list"]){q.each(o["__list"],function(j,E){var i=t._getObject("/"+o["__list"][j]);if(i){r.push(i);t._restoreReferences(i);}});delete o["__list"];o.results=r;r=[];}});return D;}};
m.prototype.removeData=function(){this.oData={};};
m.prototype.initialize=function(){var i=this.aBindings.slice(0);q.each(i,function(I,o){o.initialize();});};
m.prototype.refresh=function(F,r){if(r){this.removeData();}this._refresh(F);};
m.prototype._refresh=function(F,i,E){var j=this.aBindings.slice(0);q.each(j,function(I,o){o.refresh(F,i,E);});};
m.prototype.checkUpdate=function(F,A,i,j){if(A){if(!this.sUpdateTimer){this.sUpdateTimer=q.sap.delayedCall(0,this,function(){this.checkUpdate(F,false,i);});}return;}if(this.sUpdateTimer){q.sap.clearDelayedCall(this.sUpdateTimer);this.sUpdateTimer=null;}var k=this.aBindings.slice(0);q.each(k,function(I,o){if(!j||this.isMetaModelPath(o.getPath())){o.checkUpdate(F,i);}}.bind(this));};
m.prototype.bindProperty=function(p,o,P){var i=new e(this,p,o,P);return i;};
m.prototype.bindList=function(p,o,s,F,P){var i=new c(this,p,o,s,F,P);return i;};
m.prototype.bindTree=function(p,o,F,P){var i=new f(this,p,o,F,P);return i;};
m.prototype.createBindingContext=function(p,o,P,i,r){var r=!!r,F=this.resolve(p,o);if(typeof o=="function"){i=o;o=null;}if(typeof P=="function"){i=P;P=null;}if(!F){if(i){i(null);}return null;}var D=this._getObject(p,o),k,n,t=this;if(!r){r=this._isReloadNeeded(F,D,P);}if(!r){k=this._getKey(D);n=this.getContext('/'+k);if(i){i(n);}return n;}if(i){var I=!q.sap.startsWith(p,"/");if(F){var j=[],s=this.createCustomParams(P);if(s){j.push(s);}this._loadData(F,j,function(D){k=D?t._getKey(D):undefined;if(k&&o&&I){var l=o.getPath();l=l.substr(1);if(t.oData[l]){t.oData[l][p]={__ref:k};}}n=t.getContext('/'+k);i(n);},function(){i(null);});}else{i(null);}}};
m.prototype._isReloadNeeded=function(F,D,p){var n,N=[],s,S=[];if(!F){return false;}if(!D){return true;}if(p&&p["expand"]){n=p["expand"].replace(/\s/g,"");N=n.split(',');}if(N){for(var i=0;i<N.length;i++){var j=N[i].indexOf("/");if(j!==-1){var k=N[i].slice(0,j);var l=N[i].slice(j+1);N[i]=[k,l];}}}for(var i=0;i<N.length;i++){var o=N[i];if(Array.isArray(o)){var r=D[o[0]];var t=o[1];if(!r||(r&&r.__deferred)){return true;}else{if(r){if(r.__list&&r.__list.length>0){for(var u=0;u<r.__list.length;u++){var P="/"+r.__list[u];var v=this.getObject(P);var R=this._isReloadNeeded(P,v,{expand:t});if(R){return true;}}}else if(r.__ref){var P="/"+r.__ref;var v=this.getObject(P);var R=this._isReloadNeeded(P,v,{expand:t});if(R){return true;}}}}}else{if(D[o]===undefined||(D[o]&&D[o].__deferred)){return true;}}}if(p&&p["select"]){s=p["select"].replace(/\s/g,"");S=s.split(',');}for(var i=0;i<S.length;i++){if(D[S[i]]===undefined){return true;}}if(S.length==0){var E=this.oMetadata._getEntityTypeByPath(F);if(!E){return false;}else{for(var i=0;i<E.property.length;i++){if(D[E.property[i].name]===undefined){return true;}}}}return false;};
m.prototype.destroyBindingContext=function(o){};
m.prototype.createCustomParams=function(p){var i=[],j,s={expand:true,select:true};for(var n in p){if(n in s){i.push("$"+n+"="+q.sap.encodeURL(p[n]));}if(n=="custom"){j=p[n];for(var n in j){if(n.indexOf("$")==0){q.sap.log.warning("Trying to set OData parameter "+n+" as custom query option!");}else{i.push(n+"="+q.sap.encodeURL(j[n]));}}}}return i.join("&");};
m.prototype.bindContext=function(p,o,P){var i=new b(this,p,o,P);return i;};
m.prototype.setCountSupported=function(i){this.bCountSupported=i;};
m.prototype.isCountSupported=function(){return this.bCountSupported;};
m.prototype.setDefaultCountMode=function(s){this.sDefaultCountMode=s;};
m.prototype.getDefaultCountMode=function(){return this.sDefaultCountMode;};
m.prototype._getKey=function(o,D){var k,u;if(o instanceof C){k=o.getPath().substr(1);}else if(o&&o.__metadata&&o.__metadata.uri){u=o.__metadata.uri;k=u.substr(u.lastIndexOf("/")+1);}if(D){k=decodeURIComponent(k);}return k;};
m.prototype.getKey=function(o,D){return this._getKey(o,D);};
m.prototype.createKey=function(s,k,D){var E=this.oMetadata._getEntityTypeByPath(s),K=s,t=this,n,v,p;K+="(";if(E.key.propertyRef.length==1){n=E.key.propertyRef[0].name;p=this.oMetadata._getPropertyMetadata(E,n);v=O.formatValue(k[n],p.type);K+=D?v:encodeURIComponent(v);}else{q.each(E.key.propertyRef,function(i,P){if(i>0){K+=",";}n=P.name;p=t.oMetadata._getPropertyMetadata(E,n);v=O.formatValue(k[n],p.type);K+=n;K+="=";K+=D?v:encodeURIComponent(v);});}K+=")";return K;};
m.prototype.getProperty=function(p,o,i){var v=this._getObject(p,o);if(i==null||i==undefined){return v;}if(!q.isPlainObject(v)){return v;}v=q.sap.extend(true,{},v);if(i==true){return this._restoreReferences(v);}else{return this._removeReferences(v);}};
m.prototype._getObject=function(p,o){var n=this.isLegacySyntax()?this.oData:null,r=this.resolve(p,o),s,D,i,j,k,l;if(this.oMetadata&&r&&r.indexOf('/#')>-1){if(this.isMetaModelPath(r)){s=r.indexOf('/##');l=this.getMetaModel();if(!this.bMetaModelLoaded){return null;}D=r.substr(0,s);i=r.substr(s+3);j=l.getMetaContext(D);n=l.getProperty(i,j);}else{n=this.oMetadata._getAnnotation(r);}}else{if(o){k=o.getPath();k=k.substr(1);n=this.oData[k];}if(!p){return n;}var P=p.split("/"),I=0;if(!P[0]){n=this.oData;I++;}while(n&&P[I]){n=n[P[I]];if(n){if(n.__ref){n=this.oData[n.__ref];}else if(n.__list){n=n.__list;}else if(n.__deferred){n=undefined;}}I++;}}return n;};
m.prototype.updateSecurityToken=function(){if(this.bTokenHandling){if(!this.oServiceData.securityToken){this.refreshSecurityToken();}if(this.bTokenHandling){this.oHeaders["x-csrf-token"]=this.oServiceData.securityToken;}}};
m.prototype.resetSecurityToken=function(){delete this.oServiceData.securityToken;delete this.oHeaders["x-csrf-token"];};
m.prototype.getSecurityToken=function(){var t=this.oServiceData.securityToken;if(!t){this.refreshSecurityToken();t=this.oServiceData.securityToken;}return t;};
m.prototype.refreshSecurityToken=function(s,E,A){var t=this,u,T;A=A===true;u=this._createRequestUrl("/");var r=this._createRequest(u,"GET",A);r.headers["x-csrf-token"]="Fetch";function _(D,R){if(R){T=t._getHeader("x-csrf-token",R.headers);if(T){t.oServiceData.securityToken=T;t.oHeaders["x-csrf-token"]=T;}else{t.resetSecurityToken();t.bTokenHandling=false;}}if(s){s(D,R);}}function i(o){t.resetSecurityToken();t.bTokenHandling=false;t._handleError(o);if(E){E(o);}}return this._request(r,_,i,undefined,undefined,this.getServiceMetadata());};
m.prototype._submitRequest=function(r,i,s,E,H,I){var t=this,R,j={};function _(D,o){if(i&&H){var n=t._getBatchErrors(D);if(n.length>0){k(n[0]);return false;}if(D.__batchResponses&&D.__batchResponses.length>0){R=D.__batchResponses[0].data;if(!R&&D.__batchResponses[0].__changeResponses){R=D.__batchResponses[0].__changeResponses[0].data;}}D=R;}if(I){if(D&&D.__batchResponses){q.each(D.__batchResponses,function(p,o){if(o&&o.data){t._importData(o.data,j);}});}}t._handleETag(r,o,i);t._updateRequestQueue(r,i);if(t._isRefreshNeeded(r,o)){t._refresh(false,r.keys,r.entityTypes);}if(s){s(D,o);}}function k(o){if(t.bTokenHandling&&o.response){var T=t._getHeader("x-csrf-token",o.response.headers);if(!r.bTokenReset&&o.response.statusCode=='403'&&T&&T.toLowerCase()=="required"){t.resetSecurityToken();r.bTokenReset=true;l();return;}}t._handleError(o);if(E){E(o);}}function l(){if(t.bTokenHandling&&r.method!=="GET"){t.updateSecurityToken();if(t.bTokenHandling){r.headers["x-csrf-token"]=t.oServiceData.securityToken;}}if(i){return t._request(r,_,k,h.batchHandler,undefined,t.getServiceMetadata());}else{return t._request(r,_,k,t.oHandler,undefined,t.getServiceMetadata());}}return l();};
m.prototype._createBatchRequest=function(n,A){var u,r,o={},p={},K={},E={};p.__batchRequests=n;u=this.sServiceUrl+"/$batch";if(this.aUrlParams.length>0){u+="?"+this.aUrlParams.join("&");}q.extend(o,this.mCustomHeaders,this.oHeaders);delete o["Content-Type"];r={headers:o,requestUri:u,method:"POST",data:p,user:this.sUser,password:this.sPassword,async:A};if(A){r.withCredentials=this.bWithCredentials;}q.each(n,function(i,s){if(s["__changeRequests"]){q.each(s["__changeRequests"],function(j,t){if(t.keys&&t.method!="POST"){q.each(t.keys,function(k,l){K[k]=l;});}else if(t.entityTypes&&t.method=="POST"){q.each(t.entityTypes,function(l,k){E[l]=k;});}});}});r.keys=K;r.entityTypes=E;return r;};
m.prototype._handleETag=function(r,R,k){var u,E,l,n,o,p;if(k){o=r.data.__batchRequests;p=R.data.__batchResponses;if(p&&o){for(var i=0;i<o.length;i++){l=o[i].__changeRequests;if(p[i]){n=p[i].__changeResponses;if(l&&n){for(var j=0;j<l.length;j++){if(l[j].method=="MERGE"||l[j].method=="PUT"){u=l[j].requestUri.replace(this.sServiceUrl+'/','');if(!q.sap.startsWith(u,"/")){u="/"+u;}E=this._getObject(u);if(E&&E.__metadata&&n[j].headers&&n[j].headers.ETag){E.__metadata.etag=n[j].headers.ETag;}}}}}else{q.sap.log.warning("could not update ETags for batch request: corresponding response for request missing");}}}else{q.sap.log.warning("could not update ETags for batch request: no batch responses/requests available");}}else{u=r.requestUri.replace(this.sServiceUrl+'/','');if(!q.sap.startsWith(u,"/")){u="/"+u;}E=this._getObject(u);if(E&&E.__metadata&&R.headers.ETag){E.__metadata.etag=R.headers.ETag;}}};
m.prototype._handleBatchErrors=function(r,D){this._getBatchErrors(D);this._handleETag();};
m.prototype._getBatchErrors=function(D){var E=[],s;q.each(D.__batchResponses,function(i,o){if(o.message){s="The following problem occurred: "+o.message;if(o.response){s+=o.response.statusCode+","+o.response.statusText+","+o.response.body;}E.push(o);q.sap.log.fatal(s);}if(o.__changeResponses){q.each(o.__changeResponses,function(i,j){if(j.message){s="The following problem occurred: "+j.message;if(j.response){s+=j.response.statusCode+","+j.response.statusText+","+j.response.body;}E.push(j);q.sap.log.fatal(s);}});}});return E;};
m.prototype._handleError=function(E){var p={},t;var s="The following problem occurred: "+E.message;p.message=E.message;if(E.response){if(this.bTokenHandling){t=this._getHeader("x-csrf-token",E.response.headers);if(E.response.statusCode=='403'&&t&&t.toLowerCase()=="required"){this.resetSecurityToken();}}s+=E.response.statusCode+","+E.response.statusText+","+E.response.body;p.statusCode=E.response.statusCode;p.statusText=E.response.statusText;p.responseText=E.response.body;}q.sap.log.fatal(s);return p;};
m.prototype.getData=function(p,o,i){return this.getProperty(p,o,i);};
m.prototype._getETag=function(p,P,E){var s,i,I;if(E){s=E;}else{if(P&&P.__metadata){s=P.__metadata.etag;}else if(p){i=p.replace(this.sServiceUrl+'/','');I=i.indexOf("?");if(I>-1){i=i.substr(0,I);}if(this.oData.hasOwnProperty(i)){s=this.getProperty('/'+i+'/__metadata/etag');}}}return s;};
m.prototype._createRequest=function(u,s,A,p,E){var o={},i;q.extend(o,this.mCustomHeaders,this.oHeaders);i=this._getETag(u,p,E);if(i&&s!="GET"){o["If-Match"]=i;}if(this.bJSON&&s!="DELETE"&&this.sMaxDataServiceVersion==="2.0"){o["Content-Type"]="application/json";}if(s=="MERGE"&&!this.bUseBatch){o["x-http-method"]="MERGE";s="POST";}var r={headers:o,requestUri:u,method:s,user:this.sUser,password:this.sPassword,async:A};if(p){r.data=p;}if(A){r.withCredentials=this.bWithCredentials;}return r;};
m.prototype._isRefreshNeeded=function(r,R){var i=false,E,j=[],t=this;if(!this.bRefreshAfterChange){return i;}if(r.data&&Array.isArray(r.data.__batchRequests)){if(R){j=t._getBatchErrors(R.data);q.each(j,function(I,o){if(o.response&&o.response.statusCode=="412"){E=o.response.statusCode;return false;}});if(!!E){return false;}}q.each(r.data.__batchRequests,function(I,o){if(Array.isArray(o.__changeRequests)){q.each(o.__changeRequests,function(I,k){i=i||t._isRefreshNeeded(k);return!i;});}return!i;});}else{if(r.method==="GET"){return false;}else{if(R&&R.statusCode=="412"){i=false;}else{i=true;}}}return i;};
m.prototype.update=function(p,D,P){var s,E,i,r,u,o,j,R,k,S,K,l,A=false;if(P instanceof C||arguments.length>3){o=P;s=arguments[3];E=arguments[4];i=arguments[5];}else{o=P.context||P.oContext;s=P.success||P.fnSuccess;E=P.error||P.fnError;j=P.eTag||P.sETag;i=typeof(P.merge)=="undefined"?P.bMerge===true:P.merge===true;A=typeof(P.async)=="undefined"?P.bAsync===true:P.async===true;l=P.urlParameters;}u=this._createRequestUrl(p,o,l,this.bUseBatch);if(i){r=this._createRequest(u,"MERGE",A,D,j);}else{r=this._createRequest(u,"PUT",A,D,j);}p=this._normalizePath(p,o);S=this._getObject(p);r.keys={};if(S){K=this._getKey(S);r.keys[K]=true;}if(this.bUseBatch){k=this._createBatchRequest([{__changeRequests:[r]}],A);R=this._submitRequest(k,this.bUseBatch,s,E,true);}else{R=this._submitRequest(r,this.bUseBatch,s,E);}return R;};
m.prototype.create=function(p,D,P){var r,o,u,R,E,i,s,j,A=false,k;if(P&&typeof(P)=="object"&&!(P instanceof C)){i=P.context;s=P.success;k=P.urlParameters;j=P.error;A=P.async===true;}else{i=P;s=arguments[3];j=arguments[4];}u=this._createRequestUrl(p,i,k,this.bUseBatch);r=this._createRequest(u,"POST",A,D);p=this._normalizePath(p,i);E=this.oMetadata._getEntityTypeByPath(p);r.entityTypes={};if(E){r.entityTypes[E.entityType]=true;}if(this.bUseBatch){o=this._createBatchRequest([{__changeRequests:[r]}],A);R=this._submitRequest(o,this.bUseBatch,s,j,true);}else{R=this._submitRequest(r,this.bUseBatch,s,j);}return R;};
m.prototype.remove=function(p,P){var o,E,s,S,i,r,u,j,k,l,_,n,R,t,A=false,v=this;if((P instanceof C)||arguments[2]){o=P;S=arguments[2];i=arguments[3];}else if(P){o=P.context||P.oContext;S=P.success||P.fnSuccess;i=P.error||P.fnError;j=P.eTag||P.sETag;l=P.payload||P.oPayload;A=typeof(P.async)=="undefined"?P.bAsync===true:P.async===true;t=P.urlParameters;}_=function(D,w){E=u.substr(u.lastIndexOf('/')+1);if(E.indexOf('?')!=-1){E=E.substr(0,E.indexOf('?'));}delete v.oData[E];delete v.mContexts["/"+E];if(S){S(D,w);}};u=this._createRequestUrl(p,o,t,this.bUseBatch);r=this._createRequest(u,"DELETE",A,l,j);p=this._normalizePath(p,o);s=this._getObject(p);r.keys={};if(s){k=this._getKey(s);r.keys[k]=true;}if(this.bUseBatch){n=this._createBatchRequest([{__changeRequests:[r]}],A);R=this._submitRequest(n,this.bUseBatch,_,i,true);}else{R=this._submitRequest(r,this.bUseBatch,_,i);}return R;};
m.prototype.callFunction=function(F,p){var r,o,u,R,i,P,j,s,E,A,k="GET",l={},t=this;if(p&&typeof(p)=="object"){k=p.method?p.method:k;P=p.urlParameters;j=p.context;s=p.success;E=p.error;A=p.async===true;}else{k=p;P=arguments[2];j=arguments[3];s=arguments[4];E=arguments[5];A=arguments[6]===true;}i=this.oMetadata._getFunctionImportMetadata(F,k);if(i){u=this._createRequestUrl(F,j,null,this.bUseBatch);var n=U(u);if(i.parameter!=null){q.each(P,function(v,w){var x=i.parameter.filter(function(z){return z.name==v&&z.mode=="In";});if(x.length>0){var y=x[0];l[v]=O.formatValue(w,y.type);}else{q.sap.log.warning("Parameter "+v+" is not defined for function call "+F+"!");}});}if(k==="GET"){return t.read(F,j,l,true,s,E);}else{q.each(l,function(v,w){n.addQuery(v,w);});r=this._createRequest(n.toString(),k,A);if(this.bUseBatch){o=this._createBatchRequest([{__changeRequests:[r]}],A);R=this._submitRequest(o,this.bUseBatch,s,E,true);}else{R=this._submitRequest(r,this.bUseBatch,s,E);}return R;}}};
m.prototype.read=function(p,P){var r,u,R,o,i,j,A,s,E,F,S,k,l,n,t,v;if(P&&typeof(P)=="object"&&!(P instanceof C)){i=P.context;j=P.urlParameters;A=P.async!==false;s=P.success;E=P.error;F=P.filters;S=P.sorters;}else{i=P;j=arguments[2];A=arguments[3]!==false;s=arguments[4];E=arguments[5];}A=A!==false;v=O._createUrlParamsArray(j);l=O.createSortParams(S);if(l){v.push(l);}if(F&&!this.oMetadata){q.sap.log.fatal("Tried to use filters in read method before metadata is available.");}else{t=this._normalizePath(p,i);n=this.oMetadata&&this.oMetadata._getEntityTypeByPath(t);k=O.createFilterParams(F,this.oMetadata,n);if(k){v.push(k);}}u=this._createRequestUrl(p,i,v,this.bUseBatch);r=this._createRequest(u,"GET",A);if(this.bUseBatch){o=this._createBatchRequest([r],A);R=this._submitRequest(o,this.bUseBatch,s,E,true);}else{R=this._submitRequest(r,this.bUseBatch,s,E);}return R;};
m.prototype.createBatchOperation=function(p,s,D,P){var o={},E,S,k,i;q.extend(o,this.mCustomHeaders,this.oHeaders);if(q.sap.startsWith(p,"/")){p=p.substr(1);}if(P){E=P.sETag;}if(s!="GET"){E=this._getETag(p,D,E);if(E){o["If-Match"]=E;}}if(this.bJSON){if(s!="DELETE"&&s!="GET"&&this.sMaxDataServiceVersion==="2.0"){o["Content-Type"]="application/json";}}else{o["Content-Type"]="application/atom+xml";}var r={requestUri:p,method:s.toUpperCase(),headers:o};if(D){r.data=D;}if(s!="GET"&&s!="POST"){if(p&&p.indexOf("/")!=0){p='/'+p;}S=this._getObject(p);if(S){k=this._getKey(S);r.keys={};r.keys[k]=true;}}else if(s=="POST"){var n=p;if(p.indexOf('?')!=-1){n=p.substr(0,p.indexOf('?'));}i=this.oMetadata._getEntityTypeByPath(n);if(i){r.entityTypes={};r.entityTypes[i.entityType]=true;}}return r;};
m.prototype.addBatchReadOperations=function(r){if(!Array.isArray(r)||r.length<=0){q.sap.log.warning("No array with batch operations provided!");return false;}var t=this;q.each(r,function(i,R){if(R.method!="GET"){q.sap.log.warning("Batch operation should be a GET operation!");return false;}t.aBatchOperations.push(R);});};
m.prototype.addBatchChangeOperations=function(i){if(!Array.isArray(i)||i.length<=0){return false;}q.each(i,function(I,o){if(o.method!="POST"&&o.method!="PUT"&&o.method!="MERGE"&&o.method!="DELETE"){q.sap.log.warning("Batch operation should be a POST/PUT/MERGE/DELETE operation!");return false;}});this.aBatchOperations.push({__changeRequests:i});};
m.prototype.clearBatch=function(){this.aBatchOperations=[];};
m.prototype.submitBatch=function(s,E,A,i){var r,R,t=this;function _(D,k){if(s){s(D,k,t._getBatchErrors(D));}}if(!(typeof(s)=="function")){var o=A;var j=E;A=s;s=j;E=o;}A=A!==false;if(this.aBatchOperations.length<=0){q.sap.log.warning("No batch operations in batch. No request will be triggered!");return false;}r=this._createBatchRequest(this.aBatchOperations,A);R=this._submitRequest(r,true,_,E,false,i);this.clearBatch();return R;};
m.prototype.getServiceMetadata=function(){if(this.oMetadata&&this.oMetadata.isLoaded()){return this.oMetadata.getServiceMetadata();}};
m.prototype.getServiceAnnotations=function(){if(this.oAnnotations&&this.oAnnotations.getAnnotationsData){return this.oAnnotations.getAnnotationsData();}};
m.prototype.submitChanges=function(s,E,p){var r,P,t=this,i,j,T,k,S,K;if(this.sChangeKey){i=this.sChangeKey.replace(this.sServiceUrl,'');S=this._getObject(i);P=S;if(q.isPlainObject(S)){P=q.sap.extend(true,{},S);if(P.__metadata){T=P.__metadata.type;k=P.__metadata.etag;delete P.__metadata;if(T||k){P.__metadata={};}if(T){P.__metadata.type=T;}if(!!k){P.__metadata.etag=k;}}q.each(P,function(u,v){if(v&&v.__deferred){delete P[u];}});var o=this.oMetadata._getEntityTypeByPath(i);if(o){var n=this.oMetadata._getNavigationPropertyNames(o);q.each(n,function(I,N){delete P[N];});}P=this._removeReferences(P);}if(p&&p.sETag){j=p.sETag;}r=this._createRequest(this.sChangeKey,"MERGE",true,P,j);if(this.sUrlParams){r.requestUri+="?"+this.sUrlParams;}r.keys={};if(S){K=this._getKey(S);r.keys[K]=true;}this.oRequestQueue[this.sChangeKey]=r;}if(q.isEmptyObject(this.oRequestQueue)){return undefined;}if(this.bUseBatch){var l=[];q.each(this.oRequestQueue,function(K,u){delete u._oRef;var R=q.sap.extend(true,{},u);u._oRef=R;R.requestUri=R.requestUri.replace(t.sServiceUrl+'/','');R.data._bCreate?delete R.data._bCreate:false;l.push(R);});r=this._createBatchRequest([{__changeRequests:l}],true);this._submitRequest(r,this.bUseBatch,s,E,true);}else{q.each(this.oRequestQueue,function(K,u){delete u._oRef;var R=q.sap.extend(true,{},u);u._oRef=R;if(R.data&&R.data._bCreate){delete R.data._bCreate;}t._submitRequest(R,this.bUseBatch,s,E,true);});}return undefined;};
m.prototype._updateRequestQueue=function(r,k){var l,n,o,t=this;if(k){l=r.data.__batchRequests;if(l){for(var i=0;i<l.length;i++){n=l[i].__changeRequests;if(n){for(var j=0;j<n.length;j++){o=n[j];q.each(this.oRequestQueue,function(K,p){if(p._oRef===o&&K!==t.sChangeKey){delete t.oRequestQueue[K];delete t.oData[K];delete t.mContexts["/"+K];}else if(t.sChangeKey&&K===t.sChangeKey){delete t.oRequestQueue[K];t.sChangeKey=null;}});}}}}}else{q.each(this.oRequestQueue,function(K,p){if(p._oRef===r&&K!==t.sChangeKey){delete t.oRequestQueue[K];delete t.oData[K];delete t.mContexts["/"+K];}else if(t.sChangeKey&&K===t.sChangeKey){delete t.oRequestQueue[K];t.sChangeKey=null;}});}};
m.prototype.resetChanges=function(s,E){var p;if(this.sChangeKey){p=this.sChangeKey.replace(this.sServiceUrl,'');this._loadData(p,null,s,E);}};
m.prototype.setProperty=function(p,v,o,A){var P,E={},D={},s=this._createRequestUrl(p,o),j=p.substring(0,p.lastIndexOf("/")),k,l,n={},r=false;if(!this.resolve(p,o)){return false;}s=s.replace(this.sServiceUrl+'/','');s=s.substring(0,s.indexOf("/"));s=this.sServiceUrl+'/'+s;P=p.substr(p.lastIndexOf("/")+1);D=this._getObject(j,o);if(!D){return false;}l=j.split("/");for(var i=l.length-1;i>=0;i--){E=this._getObject(l.join("/"),o);if(E){k=this._getKey(E);if(k){break;}}l.splice(i-1,1);}if(!k){k=this._getKey(o);}if(k){n[k]=true;}if(D._bCreate){D[P]=v;r=true;this.checkUpdate(false,A,n);}else{if(!this.sChangeKey){this.sChangeKey=s;}if(this.sChangeKey==s){D[P]=v;r=true;this.checkUpdate(false,A,n);}else{this.fireRejectChange({rejectedValue:v,oldValue:D[P]});}}return r;};
m.prototype._isHeaderPrivate=function(H){switch(H.toLowerCase()){case"accept":case"accept-language":case"maxdataserviceversion":case"dataserviceversion":return true;case"x-csrf-token":return this.bTokenHandling;default:return false;}};
m.prototype.setHeaders=function(H){var i={},t=this;if(H){q.each(H,function(s,j){if(t._isHeaderPrivate(s)){q.sap.log.warning("Not allowed to modify private header: "+s);}else{i[s]=j;}});this.mCustomHeaders=i;}else{this.mCustomHeaders={};}if(this.oAnnotations){this.oAnnotations.setHeaders(this.mCustomHeaders);}};
m.prototype.getHeaders=function(){return q.extend({},this.mCustomHeaders,this.oHeaders);};
m.prototype._getHeader=function(F,H){var s;for(s in H){if(s.toLowerCase()===F.toLowerCase()){return H[s];}}return null;};
m.prototype.hasPendingChanges=function(){return this.sChangeKey!=null;};
m.prototype.updateBindings=function(F){this.checkUpdate(F);};
m.prototype.forceNoCache=function(F){this.bCache=!F;};
m.prototype.setTokenHandlingEnabled=function(t){this.bTokenHandling=t;};
m.prototype.setUseBatch=function(u){this.bUseBatch=u;};
m.prototype.formatValue=function(v,t){return O.formatValue(v,t);};
m.prototype.deleteCreatedEntry=function(o){if(o){var p=o.getPath();delete this.mContexts[p];if(q.sap.startsWith(p,"/")){p=p.substr(1);}delete this.oRequestQueue[p];delete this.oData[p];}};
m.prototype.createEntry=function(p,P){var E={},k,u,r;if(!q.sap.startsWith(p,"/")){p="/"+p;}var o=this.oMetadata._getEntityTypeByPath(p);if(!o){return undefined;}if(typeof P==="object"&&!Array.isArray(P)){E=P;}else{for(var i=0;i<o.property.length;i++){var j=o.property[i];var l=q.inArray(j.name,P)>-1;if(!P||l){E[j.name]=this._createPropertyValue(j.type);if(l){P.splice(P.indexOf(j.name),1);}}}if(P){}}E._bCreate=true;k=p.substring(1)+"('"+q.sap.uid()+"')";this.oData[k]=E;E.__metadata={type:""+o.entityType};u=this._createRequestUrl(p);r=this._createRequest(u,"POST",true,E);r.entityTypes={};r.entityTypes[o.entityType]=true;this.oRequestQueue[k]=r;return this.getContext("/"+k);};
m.prototype._createPropertyValue=function(t){var T=this.oMetadata._splitName(t);var n=T[1];var s=T[0];if(n.toUpperCase()!=='EDM'){var o={};var j=this.oMetadata._getObjectMetadata("complexType",s,n);for(var i=0;i<j.property.length;i++){var p=j.property[i];o[p.name]=this._createPropertyValue(p.type);}return o;}else{return this._getDefaultPropertyValue(s,n);}};
m.prototype._getDefaultPropertyValue=function(t,n){return undefined;};
m.prototype._normalizePath=function(p,o){if(p&&p.indexOf('?')!=-1){p=p.substr(0,p.indexOf('?'));}if(!o&&!q.sap.startsWith(p,"/")){p='/'+p;q.sap.log.warning(this+" path "+p+" should be absolute if no Context is set");}return this.resolve(p,o);};
m.prototype.setRefreshAfterChange=function(r){this.bRefreshAfterChange=r;};
m.prototype.isList=function(p,o){var p=this.resolve(p,o);return p&&p.substr(p.lastIndexOf("/")).indexOf("(")===-1;};
m.prototype.isMetaModelPath=function(p){return p.indexOf("##")==0||p.indexOf("/##")>-1;};
m.prototype._request=function(r,s,E,H,o,i){if(this.bDestroyed){return{abort:function(){}};}var t=this;function w(j){return function(){var I=q.inArray(R,t.aPendingRequestHandles);if(I>-1){t.aPendingRequestHandles.splice(I,1);}if(!(R&&R.bSuppressErrorHandlerCall)){j.apply(this,arguments);}};}var R=h.request(r,w(s||h.defaultSuccess),w(E||h.defaultError),H,o,i);if(r.async!==false){this.aPendingRequestHandles.push(R);}return R;};
m.prototype.destroy=function(){this.bDestroyed=true;if(this.aPendingRequestHandles){for(var i=this.aPendingRequestHandles.length-1;i>=0;i--){var r=this.aPendingRequestHandles[i];if(r&&r.abort){r.bSuppressErrorHandlerCall=true;r.abort();}}delete this.aPendingRequestHandles;}if(!!this.oMetadataLoadEvent){q.sap.clearDelayedCall(this.oMetadataLoadEvent);}if(!!this.oMetadataFailedEvent){q.sap.clearDelayedCall(this.oMetadataFailedEvent);}if(this.oMetadata){this.oMetadata.detachLoaded(this.onMetadataLoaded);this.oMetadata.detachFailed(this.onMetadataFailed);if(!this.oMetadata.isLoaded()&&!this.oMetadata.hasListeners("loaded")){this.oMetadata.destroy();delete this.oServiceData.oMetadata;}delete this.oMetadata;}if(this.oAnnotations){this.oAnnotations.detachFailed(this.onAnnotationsFailed);this.oAnnotations.detachLoaded(this.onAnnotationsLoaded);this.oAnnotations.destroy();delete this.oAnnotations;}M.prototype.destroy.apply(this,arguments);};
m.prototype._getAnnotationParser=function(A){if(!this.oAnnotations){var i=sap.ui.requireSync("sap/ui/model/odata/ODataAnnotations");this.oAnnotations=new i({annotationData:A,url:null,metadata:this.oMetadata,async:this.bLoadMetadataAsync,headers:this.mCustomHeaders});this.oAnnotations.attachFailed(this.onAnnotationsFailed,this);this.oAnnotations.attachLoaded(this.onAnnotationsLoaded,this);}return this.oAnnotations;};
m.prototype.onAnnotationsFailed=function(E){this.fireAnnotationsFailed(E.getParameters());};
m.prototype.onAnnotationsLoaded=function(E){this.fireAnnotationsLoaded(E.getParameters());};
m.prototype.addAnnotationUrl=function(u){var j=[].concat(u),k=[],A=[],E=[],t=this;q.each(j,function(i,s){var I=s.indexOf("$metadata");if(I>=0){if(I==0){s=t.sServiceUrl+'/'+s;}k.push(s);}else{A.push(s);}});return this.oMetadata._addUrl(k).then(function(p){return Promise.all(q.map(p,function(P){E=E.concat(P.entitySets);return t.addAnnotationXML(P["metadataString"]);}));}).then(function(){return t._getAnnotationParser().addUrl(A);}).then(function(p){return{annotations:p.annotations,entitySets:E};});};
m.prototype.addAnnotationXML=function(x,s){return new Promise(function(r,i){this._getAnnotationParser().setXML(null,x,{success:r,error:i,fireEvents:!s});}.bind(this));};
m.prototype.getMetaModel=function(){var t=this;if(!this.oMetaModel){this.oMetaModel=new g(this.oMetadata,this.oAnnotations,{addAnnotationUrl:this.addAnnotationUrl.bind(this),annotationsLoadedPromise:this.oMetadata.isLoaded()&&(!this.oAnnotations||this.oAnnotations.isLoaded())?null:this.pAnnotationsLoaded});this.oMetaModel.loaded().then(function(){t.bMetaModelLoaded=true;t.checkUpdate(false,false,null,true);});}return this.oMetaModel;};
return m;});
sap.ui.predefine('sap/ui/model/odata/ODataPropertyBinding',['jquery.sap.global','sap/ui/model/ChangeReason','sap/ui/model/PropertyBinding','sap/ui/model/ChangeReason'],function(q,C,P){"use strict";
var O=P.extend("sap.ui.model.odata.ODataPropertyBinding",{constructor:function(m,p,c,a){P.apply(this,arguments);this.bInitial=true;this.oValue=this._getValue();this.vOriginalValue;this.getDataState().setValue(this.oValue);}});
O.prototype.initialize=function(){if(this.oModel.oMetadata.isLoaded()&&this.bInitial){this.checkUpdate(true);this.bInitial=false;}};
O.prototype.getValue=function(){return this.oValue;};
O.prototype._getValue=function(){return this.oModel._getObject(this.sPath,this.oContext);};
O.prototype.setValue=function(v){if(this.bSuspended){return;}if(!q.sap.equal(v,this.oValue)&&this.oModel.setProperty(this.sPath,v,this.oContext,true)){this.oValue=v;var d=this.getDataState();d.setValue(this.oValue);this.oModel.firePropertyChange({reason:C.Binding,path:this.sPath,context:this.oContext,value:v});}};
O.prototype.setContext=function(c){if(this.oContext!=c){sap.ui.getCore().getMessageManager().removeMessages(this.getDataState().getControlMessages(),true);this.oContext=c;if(this.isRelative()){this.checkUpdate();}}};
O.prototype.checkUpdate=function(f){if(this.bSuspended&&!f){return;}var d=this.getDataState();var c=false;var o=this.oModel.getOriginalProperty(this.sPath,this.oContext);if(f||!q.sap.equal(o,this.vOriginalValue)){this.vOriginalValue=o;d.setOriginalValue(o);c=true;}var v=this._getValue();if(f||!q.sap.equal(v,this.oValue)){this.oValue=v;d.setValue(this.oValue);this._fireChange({reason:C.Change});c=true;}if(c){this.checkDataState();}};
O.prototype.checkDataState=function(p){var r=this.oModel.resolve(this.sPath,this.oContext);if(!p||r&&r in p){var d=this.getDataState();d.setLaundering(!!p&&!!(r in p));P.prototype.checkDataState.apply(this,arguments);}};
return O;});
sap.ui.predefine('sap/ui/model/odata/ODataTreeBinding',['jquery.sap.global','sap/ui/model/TreeBinding','./CountMode'],function(q,T,C){"use strict";
var O=T.extend("sap.ui.model.odata.ODataTreeBinding",{constructor:function(m,p,c,f,P){T.apply(this,arguments);this.bPendingRequest=false;this.oFinalLengths={};this.oLengths={};this.oKeys={};this.bNeedsUpdate=false;this.bHasTreeAnnotations=this._hasTreeAnnotations();this.oRootContext=null;this.iNumberOfExpandedLevels=P&&P.numberOfExpandedLevels;this.sCountMode=(P&&P.countMode)||this.oModel.sDefaultCountMode;if(!this.bHasTreeAnnotations){if(!P||!P.navigation){q.sap.log.error("A navigation paths parameter object has to be defined");this.oNavigationPaths={};}else{this.oNavigationPaths=P.navigation;}}else{q.sap.log.warning("Tree hierarchy annotations are deprecated and may not work correctly with the sap.ui.model.odata.ODataModel."+" Please use the sap.ui.model.odata.v2.ODataModel (since version 1.28) instead which fully supports hierarchy annotations.");}}});
O.prototype.getRootContexts=function(s,l,t){var n=null,r={numberOfExpandedLevels:this.iNumberOfExpandedLevels},R=[],b=true,a=this;if(this.bHasTreeAnnotations){r.level=0;if(!this.bDisplayRootNode){r.level=1;}}else{n=this.oModel.resolve(this.getPath(),this.getContext());r.navPath=this._getNavPath(this.getPath());if(r.numberOfExpandedLevels>0){var A=n;for(var i=0;i<r.numberOfExpandedLevels;i++){var N=this._getNavPath(A);r.navPath+="/"+N;A+="/"+N;}}var I=this.oModel.isList(this.sPath,this.getContext());if(I){this.bDisplayRootNode=true;}else{b=false;this.oModel.createBindingContext(n,null,{expand:r.navPath},function(o){R=[o];if(a.oRootContext!==o){a.oRootContext=o;a._processODataObject(o.getObject(),n,r.navPath);a.bNeedsUpdate=true;}},this.bRefresh);this.bRefresh=false;}}if(b){if(!this.bDisplayRootNode){R=this._getContextsForNodeId(n,0,1,0,r);}else{R=this._getContextsForNodeId(n,s,l,t,r);}}if(!this.bDisplayRootNode&&R.length>0){this.oRootContext=R[0];R=this.getNodeContexts(R[0],s,l,t);}return R;};
O.prototype.getNodeContexts=function(c,s,l,t){var n,r={};if(this.bHasTreeAnnotations){var d=c.getProperty(this.oTreeProperties["hierarchy-drill-state-for"]);if(d=="leaf"){return[];}n=c.getProperty(this.oTreeProperties["hierarchy-node-for"]);r.level=parseInt(c.getProperty(this.oTreeProperties["hierarchy-level-for"]),10)+1;}else{var N=this._getNavPath(c.getPath());if(!N){return[];}n=this.oModel.resolve(N,c);r.navPath=this.oNavigationPaths[N];}return this._getContextsForNodeId(n,s,l,t,r);};
O.prototype.hasChildren=function(c){if(!c){return false;}if(this.bHasTreeAnnotations){var d=c.getProperty(this.oTreeProperties["hierarchy-drill-state-for"]);return d==="expanded"||d==="collapsed";}else{var n=this._getNavPath(c.getPath());var p=c.getPath()+"/"+n;return n&&this.oLengths[p]>0;}};
O.prototype.getChildCount=function(c){if(this.bHasTreeAnnotations){var h;if(!c){if(this.oRootContext){h=this.oRootContext.getProperty(this.oTreeProperties["hierarchy-node-for"]);}else{h="000000";}}else{h=c.getProperty(this.oTreeProperties["hierarchy-node-for"]);}return this.oLengths[h];}else{if(!c){return this.oLengths[this.getPath()];}return this.oLengths[c.getPath()+"/"+this._getNavPath(c.getPath())];}};
O.prototype._getContextsForNodeId=function(n,s,l,t,p){var c=[],L,k;if(!s){s=0;}if(!l){l=this.oModel.iSizeLimit;}if(!t){t=0;}if(this.bHasTreeAnnotations){if(n==null){n="000000";}if(p.level==0){p.level++;}}if(this.oFinalLengths[n]&&this.oLengths[n]<l){l=this.oLengths[n];}if(this.oKeys[n]){for(var i=s;i<s+l;i++){k=this.oKeys[n][i];if(!k){break;}c.push(this.oModel.getContext('/'+k));}}L=c.length!=l&&!(this.oFinalLengths[n]&&c.length>=this.oLengths[n]);if(this.oModel.getServiceMetadata()){if(!this.bPendingRequest&&L){var P=[];if(this.bHasTreeAnnotations){if(p.numberOfExpandedLevels>0){var a=p.level+p.numberOfExpandedLevels;P.push("$filter="+this.oTreeProperties["hierarchy-level-for"]+" le '0"+a+"'");}else{P.push("$filter="+this.oTreeProperties["hierarchy-level-for"]+" eq '0"+p.level+"' and "+this.oTreeProperties["hierarchy-parent-node-for"]+" eq '"+n+"'");}}else{if(p.navPath){P.push("$expand="+p.navPath);}}this._loadSubNodes(n,s,l,t,P,p);}}return c;};
O.prototype._getCountForNodeId=function(n,s,l,t,p){var a=this;var P=[];function _(d){a.oFinalLengths[n]=true;a.oLengths[n]=parseInt(d,10);}function b(e){var E="Request for $count failed: "+e.message;if(e.response){E+=", "+e.response.statusCode+", "+e.response.statusText+", "+e.response.body;}q.sap.log.warning(E);}var c;if(this.bHasTreeAnnotations){c=this.oModel.resolve(this.getPath(),this.getContext());P.push("$filter="+this.oTreeProperties["hierarchy-parent-node-for"]+" eq '"+n+"'");}else{c=n;}if(c){var u=this.oModel._createRequestUrl(c+"/$count",null,P);var r=this.oModel._createRequest(u,"GET",false);r.headers["Accept"]="text/plain, */*;q=0.5";this.oModel._request(r,_,b,undefined,undefined,this.oModel.getServiceMetadata());}};
O.prototype._loadSubNodes=function(n,s,l,t,p,P){var a=this,I=false;if(s||l){p.push("$skip="+s+"&$top="+l);}if(!a.bHasTreeAnnotations&&!this.oFinalLengths[n]&&(this.sCountMode==C.Inline||this.sCountMode==C.Both)){p.push("$inlinecount=allpages");I=true;}function S(d){if(d.results){if(!a.bHasTreeAnnotations){if(I&&d.__count){a.oLengths[n]=parseInt(d.__count,10);a.oFinalLengths[n]=true;}else{if(a.oModel.isCountSupported()){a._getCountForNodeId(n);}}a.oKeys[n]=[];for(var i=0;i<d.results.length;i++){var E=d.results[i];var k=a.oModel._getKey(E);a._processODataObject(E,"/"+k,P.navPath);a.oKeys[n][i+s]=k;}}else{var L={};for(var i=0;i<d.results.length;i++){var E=d.results[i];n=E[a.oTreeProperties["hierarchy-parent-node-for"]];if(i==0){L[n]=s;}else if(L[n]==undefined){L[n]=0;}if(!(n in a.oKeys)){a.oKeys[n]=[];a._getCountForNodeId(n);}a.oKeys[n][L[n]]=a.oModel._getKey(E);L[n]++;}}}else{a.oKeys[null]=a.oModel._getKey(d);if(!a.bHasTreeAnnotations){a._processODataObject(d,n,P.navPath);}}a.oRequestHandle=null;a.bPendingRequest=false;a.bNeedsUpdate=true;}function c(){a.fireDataReceived();}function e(d){a.oRequestHandle=null;a.bPendingRequest=false;a.fireDataReceived();}function u(h){a.oRequestHandle=h;}if(n){if(!this.oFinalLengths[n]){this.bPendingRequest=true;this.fireDataRequested();var A;if(this.bHasTreeAnnotations){A=this.oModel.resolve(this.getPath(),this.getContext());}else{A=n;}this.oModel._loadData(A,p,S,e,false,u,c);}}};
O.prototype.resetData=function(c){if(c){var p=c.getPath();delete this.oKeys[p];delete this.oLengths[p];delete this.oFinalLengths[p];}else{this.oKeys={};this.oLengths={};this.oFinalLengths={};this.oRootContext=null;}};
O.prototype.refresh=function(f,c,e){var b=false;if(!f){if(e){var r=this.oModel.resolve(this.sPath,this.oContext);var E=this.oModel.oMetadata._getEntityTypeByPath(r);if(E&&(E.entityType in e)){b=true;}}if(c&&!b){q.each(this.oKeys,function(i,n){q.each(n,function(i,k){if(k in c){b=true;return false;}});if(b){return false;}});}if(!c&&!e){b=true;}}if(f||b){this.resetData();this.bNeedsUpdate=false;this.bRefresh=true;this._fireChange();}};
O.prototype.filter=function(f){q.sap.log.warning("Filtering is currently not possible in the ODataTreeBinding");return this;};
O.prototype.checkUpdate=function(f,c){var b=false;if(!f){if(this.bNeedsUpdate||!c){b=true;}else{q.each(this.oKeys,function(i,n){q.each(n,function(i,k){if(k in c){b=true;return false;}});if(b){return false;}});}}if(f||b){this.bNeedsUpdate=false;this._fireChange();}};
O.prototype._getNavPath=function(p){var a=this.oModel.resolve(p,this.getContext());if(!a){return;}var P=a.split("/"),e=P[P.length-1],n;var c=e.split("(")[0];if(c&&this.oNavigationPaths[c]){n=this.oNavigationPaths[c];}return n;};
O.prototype._processODataObject=function(o,p,n){var N=[],t=this;if(n&&n.indexOf("/")>-1){N=n.split("/");n=N[0];N.splice(0,1);}var r=this.oModel._getObject(p);if(Array.isArray(r)){this.oKeys[p]=r;this.oLengths[p]=r.length;this.oFinalLengths[p]=true;}if(n&&o[n]){if(Array.isArray(r)){r.forEach(function(R){var o=t.getModel().getData("/"+R);t._processODataObject(o,"/"+R+"/"+n,N.join("/"));});}else if(typeof r==="object"){t._processODataObject(o,p+"/"+n,N.join("/"));}}};
O.prototype._hasTreeAnnotations=function(){var m=this.oModel,M=m.oMetadata,a=m.resolve(this.getPath(),this.getContext()),e=M._getEntityTypeByPath(a),t=M.mNamespaces["sap"],b=this;this.oTreeProperties={"hierarchy-level-for":false,"hierarchy-parent-node-for":false,"hierarchy-node-for":false,"hierarchy-drill-state-for":false};if(!e){q.sap.log.fatal("EntityType for path "+a+" could not be found.");return false;}q.each(e.property,function(i,p){if(!p.extensions){return true;}q.each(p.extensions,function(i,E){var n=E.name;if(E.namespace===t&&n in b.oTreeProperties&&!b.oTreeProperties[n]){b.oTreeProperties[n]=p.name;}});});var c=false;q.each(this.oTreeProperties,function(i,o){if(!o){c=true;return false;}});return!c;};
return O;});
sap.ui.predefine('sap/ui/model/odata/ODataTreeBindingAdapter',['jquery.sap.global','sap/ui/model/TreeBinding','./v2/ODataTreeBinding','sap/ui/model/TreeBindingAdapter','sap/ui/model/TreeAutoExpandMode','sap/ui/model/ChangeReason','sap/ui/model/TreeBindingUtils','./OperationMode'],function(q,T,O,a,b,C,c,d){"use strict";var e=function(){if(!(this instanceof T)||this._bIsAdapted){return;}a.apply(this);for(var f in e.prototype){if(e.prototype.hasOwnProperty(f)){this[f]=e.prototype[f];}}this.mParameters=this.mParameters||{};this._aRowIndexMap=[];this._iThreshold=0;this._iPageSize=0;this.setAutoExpandMode(this.mParameters.autoExpandMode||b.Sequential);if(this.mParameters.collapseRecursive===undefined){this.bCollapseRecursive=true;}else{this.bCollapseRecursive=!!this.mParameters.collapseRecursive;}this._createTreeState();if(this.mParameters.treeState&&this.sOperationMode==d.Client){this.setTreeState(this.mParameters.treeState);}};
e.prototype.nodeHasChildren=function(n){if(!n){return false;}else if(n.isArtificial){return true;}else{return O.prototype.hasChildren.call(this,n.context);}};
e.prototype._calculateGroupID=function(n){var g="";var G="";var E;if(n.context===null){return"/";}if(n.parent){g=n.parent.groupID;g=g[g.length-1]!=="/"?g+"/":g;if(this.bHasTreeAnnotations){E=(n.context.getProperty(this.oTreeProperties["hierarchy-node-for"])+"").replace(/\//g,"%2F");G=E+"/";}else{G=n.context.sPath.substring(1)+"/";}}else{if(this.bHasTreeAnnotations){g="/";E=(n.context.getProperty(this.oTreeProperties["hierarchy-node-for"])+"").replace(/\//g,"%2F");G=E+"/";}else{g="/";G=n.context.sPath[0]==="/"?n.context.sPath.substring(1):n.context.sPath;}}var s=g+G;return s;};
e.prototype.resetData=function(o,p){var r=O.prototype.resetData.call(this,o,p);this._aRowIndexMap=[];this._oRootNode=undefined;this._iPageSize=0;this._iThreshold=0;if(!p||p.reason!==C.Sort){this.clearSelection();this._createTreeState(true);}return r;};
return e;},true);
sap.ui.predefine('sap/ui/model/odata/ODataTreeBindingFlat',['jquery.sap.global','sap/ui/model/Filter','sap/ui/model/TreeBinding','sap/ui/model/odata/v2/ODataTreeBinding','sap/ui/model/ChangeReason','sap/ui/model/TreeBindingUtils'],function(q,F,T,O,C,c){"use strict";var d=function(){if(!(this instanceof T)||this._bIsAdapted){return;}for(var f in d.prototype){if(d.prototype.hasOwnProperty(f)){this[f]=d.prototype[f];}}this.mParameters=this.mParameters||{};this._iPageSize=0;this._aNodes=this._aNodes||[];this._aNodeCache=[];this._aCollapsed=this._aCollapsed||[];this._aExpanded=this._aExpanded||[];this._aRemoved=[];this._aAdded=[];this._aNodeChanges=[];this._aAllChangedNodes=[];this._mSubtreeHandles={};this._iLowestServerLevel=null;this._aExpandedAfterSelectAll=this._aExpandedAfterSelectAll||[];this._mSelected=this._mSelected||{};this._mDeselected=this._mDeselected||{};this._bSelectAll=false;this._iLengthDelta=0;if(this.mParameters.collapseRecursive===undefined){this.bCollapseRecursive=true;}else{this.bCollapseRecursive=!!this.mParameters.collapseRecursive;}this._bIsAdapted=true;this._bReadOnly=true;this._aPendingRequests=[];this._aPendingChildrenRequests=[];};
d.prototype.setNumberOfExpandedLevels=function(l){this.resetData();O.prototype.setNumberOfExpandedLevels.apply(this,arguments);};
d.prototype.getContexts=function(s,l,t,r){if(this.isInitial()){return[];}s=s||0;l=l||this.oModel.sizeLimit;t=t||0;this._iPageSize=l;this._iThreshold=t;if(this._aNodes.length==0&&!this.isLengthFinal()){this._loadData(s,l,t);}var R=[];var n=this._retrieveNodeSection(s,l);this._aNodeCache=[];var S;var a=0;var L=0;var g={};for(var i=0;i<n.length;i++){var N=n[i];this._aNodeCache[s+i]=N&&N.context?N:undefined;R.push(N.context);if(!N.context){if(N.serverIndex!=undefined){if(S==undefined){S=N.serverIndex;}L=N.serverIndex;}else if(N.positionInParent!=undefined){var p=N.parent;g[p.key]=g[p.key]||[];g[p.key].push(N);}}}a=1+Math.max(L-(S||0),0);if(S!=undefined&&a){this._loadData(S,a,t);}for(var m in g){var o=this._calculateRequestParameters(g[m]);this._loadChildren(g[m][0].parent,o.skip,o.top);}if(r){return n;}else{return R;}};
d.prototype._calculateRequestParameters=function(m){var p=m[0].parent;var M=m[0].positionInParent;var a=Math.min(M+Math.max(this._iThreshold,m.length),p.children.length);for(var i=M;i<a;i++){var o=p.children[i];if(o){break;}}return{skip:M,top:i-M};};
d.prototype._retrieveNodeSection=function(s,l){return this._bReadOnly?this._indexRetrieveNodeSection(s,l):this._mapRetrieveNodeSection(s,l);};
d.prototype._mapRetrieveNodeSection=function(s,l){var n=-1;var N=[];this._map(function(o,r,i,I,p){n++;if(n>=s){if(!o){if(i=="serverIndex"){o={serverIndex:I};}else if(i=="positionInParent"){o={positionInParent:I,parent:p};}}N.push(o);}if(N.length>=l){r.broken=true;}});return N;};
d.prototype._indexRetrieveNodeSection=function(s,l){var i,n=[],N,o;for(i=s;i<s+l;i++){N=this.getNodeInfoByRowIndex(i);if(N.index!==undefined&&N.index<this._aNodes.length){o=this._aNodes[N.index];if(!o){o={serverIndex:N.index};}}else if(N.parent){o=N.parent.children[N.childIndex];if(!o){o={parent:N.parent,positionInParent:N.childIndex};}}if(o){n.push(o);o=null;}}return n;};
d.prototype.getNodes=function(s,l,t){var n=this.getContexts(s,l,t,true);return n;};
d.prototype._map=function(m){var r={broken:false};var f=function(n){if(n.addedSubtrees.length>0&&!n.nodeState.collapsed){for(var j=0;j<n.addedSubtrees.length;j++){var s=n.addedSubtrees[j];t(n,s);if(r.broken){return;}}}};var t=function(n,s){var S=s._getSubtree();if(s){if(Array.isArray(S)){if(s._oSubtreeRoot){b(S,s._oSubtreeRoot.serverIndex,s._oSubtreeRoot,s._oSubtreeRoot.originalLevel||0,n.level+1);}else{b(S,null,null,0,n.level+1);}}else{s._oSubtreeRoot.level=n.level+1;a(s._oSubtreeRoot,false,s._oNewParentNode,-1,s._oSubtreeRoot);}}};var a=function(n,I,p,P,o){if(!I){if(!n.nodeState.removed||o==n){m(n,r,"positionInParent",P,p);if(r.broken){return;}}}f(n);if(r.broken){return;}if(n&&n.children&&n.nodeState.expanded){for(var i=0;i<n.children.length;i++){var e=n.children[i];if(e&&!e.nodeState.removed&&!e.nodeState.reinserted){e.level=n.level+1;}if(e&&!e.nodeState.removed){a(e,false,n,i,o);}else if(!e){m(e,r,"positionInParent",i,n);}if(r.broken){return;}}}};var b=function(e,s,I,S,n){for(var i=0;i<e.length;i++){var N=e[i];if(N&&N.nodeState&&N.nodeState.removed&&N!=I){if(!N.initiallyCollapsed){i+=N.magnitude;}continue;}if(N&&S>=0&&n>=0){N.level=N.originalLevel||0;var l=(N.level-S)||0;N.level=n+l||0;}if(s===null){m(N,r,"newNode");}else{m(N,r,"serverIndex",s+i);}if(r.broken){return;}if(N&&N.nodeState){if(!N.initiallyCollapsed&&N.nodeState.collapsed){i+=N.magnitude;}else{if(N.initiallyCollapsed&&N.nodeState.expanded){a(N,true);if(r.broken){return;}}else if(!N.initiallyCollapsed&&N.nodeState.expanded){f(N);}}}if(r.broken){return;}}};b(this._aNodes,0,null);};
d.prototype._loadData=function(s,t,e){var r={iSkip:s,iTop:t+(e||0),iThreshold:e};this._aPendingRequests.sort(function(a,b){return a.iSkip-b.iSkip;});for(var i=0;i<this._aPendingRequests.length;i++){if(c._determineRequestDelta(r,this._aPendingRequests[i])===false){return;}}s=r.iSkip;t=r.iTop;function _(D){var E,k,I,i,a=function(n,j){if(!n.isDeepOne&&!n.initiallyCollapsed&&n.serverIndex<I&&n.serverIndex+n.magnitude>=I){return true;}};var b=this._aPendingRequests.indexOf(r);this._aPendingRequests.splice(b,1);if(!this._bLengthFinal){var h=D.__count?parseInt(D.__count,10):0;this._aNodes[h-1]=undefined;this._bLengthFinal=true;}if(D.results&&D.results.length>0){for(i=0;i<D.results.length;i++){E=D.results[i];k=this.oModel.getKey(E);I=s+i;var m=E[this.oTreeProperties["hierarchy-node-descendant-count-for"]];if(m<0){m=0;q.sap.log.error("The entry data with key '"+k+"' under binding path '"+this.getPath()+"' has a negative 'hierarchy-node-descendant-count-for' which isn't allowed.");}var n=this._aNodes[I]=this._aNodes[I]||{key:k,context:this.oModel.getContext("/"+k),magnitude:m,level:E[this.oTreeProperties["hierarchy-level-for"]],originalLevel:E[this.oTreeProperties["hierarchy-level-for"]],initiallyCollapsed:E[this.oTreeProperties["hierarchy-drill-state-for"]]==="collapsed",nodeState:{isLeaf:E[this.oTreeProperties["hierarchy-drill-state-for"]]==="leaf",expanded:E[this.oTreeProperties["hierarchy-drill-state-for"]]==="expanded",collapsed:E[this.oTreeProperties["hierarchy-drill-state-for"]]==="collapsed",selected:this._mSelected[k]?this._mSelected[k].nodeState.selected:false},children:[],addedSubtrees:[],serverIndex:I,parent:null};this._iLowestServerLevel=Math.min(this._iLowestServerLevel,n.level);if(this._bSelectAll){if(!this._aExpandedAfterSelectAll.some(a)){this.setNodeSelection(n,true);}}}}this.oModel.callAfterUpdate(function(){this.fireDataReceived({data:D});}.bind(this));this._fireChange({reason:C.Change});}function f(E){var a=this._aPendingRequests.indexOf(r);this._aPendingRequests.splice(a,1);var A=E.statusCode==0;if(!A){this._aNodes=[];this._bLengthFinal=true;this._fireChange({reason:C.Change});}this.fireDataReceived();}var u=["$skip="+s,"$top="+t];if(!this._bLengthFinal){u.push("$inlinecount=allpages");}if(this.sCustomParams){u.push(this.sCustomParams);}this.fireDataRequested();var l=new F(this.oTreeProperties["hierarchy-level-for"],"LE",this.getNumberOfExpandedLevels());var g=[l];if(this.aApplicationFilters){g=g.concat(this.aApplicationFilters);}r.oRequestHandle=this.oModel.read(this.getPath(),{context:this.oContext,urlParameters:u,filters:[new F({filters:g,and:true})],sorters:this.aSorters||[],success:_.bind(this),error:f.bind(this),groupId:this.sRefreshGroupId?this.sRefreshGroupId:this.sGroupId});this._aPendingRequests.push(r);};
d.prototype._propagateMagnitudeChange=function(p,D){while(p!=null&&(p.initiallyCollapsed||p.isDeepOne)){p.magnitude+=D;p=p.parent;}};
d.prototype._loadChildren=function(p,s,t){var r={sParent:p.key,iSkip:s,iTop:t};this._aPendingChildrenRequests.sort(function(a,b){return a.iSkip-b.iSkip;});for(var i=0;i<this._aPendingChildrenRequests.length;i++){var P=this._aPendingChildrenRequests[i];if(P.sParent===r.sParent){if(c._determineRequestDelta(r,P)===false){return;}}}s=r.iSkip;t=r.iTop;function _(D){var a=this._aPendingChildrenRequests.indexOf(r);this._aPendingChildrenRequests.splice(a,1);if(p.childCount==undefined&&D&&D.__count){var b=D.__count?parseInt(D.__count,10):0;p.childCount=b;p.children[b-1]=undefined;this._propagateMagnitudeChange(p,b);this._cleanTreeStateMaps();}if(D.results&&D.results.length>0){for(var i=0;i<D.results.length;i++){var E=D.results[i];var k=this.oModel.getKey(E);var n=p.children[s+i]=p.children[s+i]||{key:k,context:this.oModel.getContext("/"+k),magnitude:0,level:p.level+1,originalLevel:p.level+1,initiallyCollapsed:E[this.oTreeProperties["hierarchy-drill-state-for"]]==="collapsed",nodeState:{isLeaf:E[this.oTreeProperties["hierarchy-drill-state-for"]]==="leaf",expanded:E[this.oTreeProperties["hierarchy-drill-state-for"]]==="expanded",collapsed:E[this.oTreeProperties["hierarchy-drill-state-for"]]==="collapsed",selected:this._mSelected[k]?this._mSelected[k].nodeState.selected:false},positionInParent:s+i,children:[],addedSubtrees:[],parent:p,originalParent:p,isDeepOne:true,containingServerIndex:p.containingServerIndex||p.serverIndex};if(this._bSelectAll&&this._aExpandedAfterSelectAll.indexOf(p)===-1){this.setNodeSelection(n,true);}}}this.oModel.callAfterUpdate(function(){this.fireDataReceived({data:D});}.bind(this));this._fireChange({reason:C.Change});}function e(E){var a=this._aPendingChildrenRequests.indexOf(r);this._aPendingChildrenRequests.splice(a,1);var A=E.statusCode==0;if(!A){if(p.childCount==undefined){p.children=[];p.childCount=0;this._fireChange({reason:C.Change});}}this.fireDataReceived();}var u=["$skip="+s,"$top="+t];if(p.childCount==undefined){u.push("$inlinecount=allpages");}if(this.sCustomParams){u.push(this.sCustomParams);}this.fireDataRequested();var l=new F(this.oTreeProperties["hierarchy-parent-node-for"],"EQ",p.context.getProperty(this.oTreeProperties["hierarchy-node-for"]));var f=[l];if(this.aApplicationFilters){f=f.concat(this.aApplicationFilters);}r.oRequestHandle=this.oModel.read(this.getPath(),{context:this.oContext,urlParameters:u,filters:[new F({filters:f,and:true})],sorters:this.aSorters||[],success:_.bind(this),error:e.bind(this),groupId:this.sRefreshGroupId?this.sRefreshGroupId:this.sGroupId});this._aPendingChildrenRequests.push(r);};
d.prototype.findNode=function(r){return this._bReadOnly?this._indexFindNode(r):this._mapFindNode(r);};
d.prototype._mapFindNode=function(r){if(this.isInitial()){return;}var f=this._aNodeCache[r];if(f){return f;}var n=-1;this._map(function(N,R,i,I,p){n++;if(n===r){f=N;R.broken=true;}});return f;};
d.prototype._indexFindNode=function(r){if(this.isInitial()){return;}var n=this._aNodeCache[r];if(n){return n;}var N=this.getNodeInfoByRowIndex(r),n;if(N.parent){n=N.parent.children[N.childIndex];}else{n=this._aNodes[N.index];}this._aNodeCache[r]=n;return n;};
d.prototype.toggleIndex=function(r){var t=this.findNode(r);if(t){if(t.nodeState.expanded){this.collapse(t);}else{this.expand(t);}}};
d.prototype.expand=function(r,s){var t=r;if(typeof r!=="object"){t=this.findNode(r);}if(t.nodeState.expanded){return;}t.nodeState.expanded=true;t.nodeState.collapsed=false;var i=this._aCollapsed.indexOf(t);if(i!=-1){this._aCollapsed.splice(i,1);}this._aExpanded.push(t);this._sortNodes(this._aExpanded);if(t.serverIndex!==undefined){this._aNodeChanges[t.serverIndex]=true;}if(this._bSelectAll){this._aExpandedAfterSelectAll.push(t);}if(t.initiallyCollapsed&&t.childCount==undefined){this._loadChildren(t,0,this._iPageSize);}else{this._propagateMagnitudeChange(t.parent,t.magnitude);}this._cleanTreeStateMaps();this._aNodeCache=[];if(!s){this._fireChange({reason:C.Expand});}};
d.prototype.expandToLevel=function(l){if(l>this.getNumberOfExpandedLevels()){this.setNumberOfExpandedLevels(l);}};
d.prototype.collapse=function(r,s){var t=r;if(typeof r!=="object"){t=this.findNode(r);}if(t.nodeState.collapsed){return;}t.nodeState.expanded=false;t.nodeState.collapsed=true;var i=this._aExpanded.indexOf(t);if(i!=-1){this._aExpanded.splice(i,1);}if(this._bSelectAll){i=this._aExpandedAfterSelectAll.indexOf(t);if(i!==-1){this._aExpandedAfterSelectAll.splice(i,1);}}this._aCollapsed.push(t);this._sortNodes(this._aCollapsed);if(t.isDeepOne){this._propagateMagnitudeChange(t.parent,t.magnitude*-1);}if(t.serverIndex!==undefined){this._aNodeChanges[t.serverIndex]=true;}this._cleanUpSelection();this._cleanTreeStateMaps();this._aNodeCache=[];if(!s){this._fireChange({reason:C.Collapse});}};
d.prototype.collapseToLevel=function(l){if(l<this.getNumberOfExpandedLevels()){if(this.bCollapseRecursive){for(var k in this._mSelected){var s=this._mSelected[k];if(s.level>l){this.setNodeSelection(s,false);}}}this.setNumberOfExpandedLevels(l);}};
d.prototype._getInvisibleSelectedNodes=function(){var a=[];var i=true;var f=function(n,b){if(n.nodeState.collapsed||(n.nodeState.removed&&!n.nodeState.reinserted)){i=false;b.broken=true;}};for(var k in this._mSelected){var s=this._mSelected[k];i=true;this._up(s,f,false);if(!i){a.push(s);}}return a;};
d.prototype._cleanUpSelection=function(f){var i=this._getInvisibleSelectedNodes();i.forEach(function(s){if(s.key==this._sLeadSelectionKey){this._sLeadSelectionKey=null;}if(this.bCollapseRecursive||f){this.setNodeSelection(s,false);}}.bind(this));};
d.prototype._isInSubtree=function(a,o){var i=false;var f=function(n,b){if(n==a){b.broken=true;i=true;}};this._up(o,f,false);return i;};
d.prototype._up=function(n,u,o){var r={broken:false};var p=this._getParent(n,o);if(p){this._structuralUp(p,u,r,o);}else{this._flatUp(n,u,r,true);}};
d.prototype._structuralUp=function(n,u,b,o){var p=n;do{u(p,b);if(b.broken){return;}n=p;p=this._getParent(p);}while(p);this._flatUp(n,u,b);};
d.prototype._flatUp=function(n,u,b,I){var s=n.serverIndex,i=I?s-1:s,o,p;for(;i>=0;i--){if(this._aNodeChanges[i]){o=this._aNodes[i];if(o.initiallyCollapsed){continue;}if(o.serverIndex+o.magnitude>=s){u(o,b);if(b.broken){return;}p=this._getParent(o);if(p){this._structuralUp(p,u,b);return;}}else{continue;}}}};
d.prototype._getParent=function(n,o){return o?n.originalParent:n.parent;};
d.prototype._cleanTreeStateMaps=function(){this._iLengthDelta=this._bReadOnly?this._indexCleanTreeStateMaps():this._mapCleanTreeStateMaps();};
d.prototype._indexCleanTreeStateMaps=function(){return this._calcIndexDelta(this._aNodes.length);};
d.prototype._mapCleanTreeStateMaps=function(){var a=this._aCollapsed.concat(this._aRemoved).concat(this._aExpanded).concat(this._aAdded),v=true,V,D=0,f=function(n,B){if(n.nodeState.collapsed||(n.nodeState.removed&&!n.nodeState.reinserted)){v=false;B.broken=true;}},s={};var b=[[0,1],[-1,0]];a.forEach(function(n){if(s[n.key]){return;}else{s[n.key]=true;}if(n.nodeState.added){if(!n.nodeState.removed||n.nodeState.reinserted){v=true;this._up(n,f,false);if(v){D++;}}}else{if(n.nodeState.collapsed||n.nodeState.expanded||n.nodeState.removed){v=true;this._up(n,f,false);if(v){if(n.nodeState.removed&&!n.nodeState.reinserted){if(n.isDeepOne||n.initiallyCollapsed){D-=1;}else{D-=(n.magnitude+1);}}else{if(n.nodeState.collapsed&&n.serverIndex!==undefined&&!n.initiallyCollapsed){D-=n.magnitude;}if(n.nodeState.expanded&&(n.isDeepOne||n.initiallyCollapsed)){D+=n.children.length;}}}if(n.nodeState.reinserted){V=v;v=true;this._up(n,f,true);var i=(b[v|0][V|0]);if(!!i){if(n.isDeepOne){D+=i*1;}else{if(n.initiallyCollapsed){D+=i;}else{D+=i*(1+n.magnitude);}}}}}}}.bind(this));return D;};
d.prototype.isLengthFinal=function(){return this._bLengthFinal;};
d.prototype.getLength=function(){return this._aNodes.length+this._iLengthDelta;};
d.prototype.getContextByIndex=function(r){if(this.isInitial()){return;}var n=this.findNode(r);return n&&n.context;};
d.prototype.getNodeByIndex=function(r){if(this.isInitial()){return;}var n=this.findNode(r);return n;};
d.prototype.isExpanded=function(r){var n=this.findNode(r);return n&&n.nodeState.expanded;};
d.prototype.hasChildren=function(o){if(!o){return false;}var n=this._findNodeByContext(o);var N=n&&n.node;return!(N&&N.nodeState.isLeaf);};
d.prototype.nodeHasChildren=function(n){return!(n&&n.nodeState.isLeaf);};
d.prototype.setNodeSelection=function(n,i){n.nodeState.selected=i;if(i){delete this._mDeselected[n.key];this._mSelected[n.key]=n;}else{delete this._mSelected[n.key];this._mDeselected[n.key]=n;if(n.key===this._sLeadSelectionKey){this._sLeadSelectionKey=null;}}};
d.prototype.isIndexSelected=function(r){var n=this.findNode(r);return n&&n.nodeState?n.nodeState.selected:false;};
d.prototype.isIndexSelectable=function(r){var n=this.findNode(r);return!!n;};
d.prototype._clearSelection=function(){return this._bReadOnly?this._indexClearSelection():this._mapClearSelection();};
d.prototype._indexClearSelection=function(){var o=-1,a=[],s,n,r;this._bSelectAll=false;this._aExpandedAfterSelectAll=[];for(s in this._mSelected){n=this._mSelected[s];this.setNodeSelection(n,false);r=this.getRowIndexByNode(n);a.push(r);if(this._sLeadSelectionKey==s){o=r;}}return{rowIndices:a,oldIndex:o,leadIndex:-1};};
d.prototype._mapClearSelection=function(){var n=-1;var o=-1;var m=0;var a=[];this._bSelectAll=false;this._aExpandedAfterSelectAll=[];for(var k in this._mSelected){if(k){m++;}}this._map(function(N,r,i,I,p){n++;if(N&&N.nodeState.selected){this.setNodeSelection(N,false);a.push(n);if(this._sLeadSelectionKey==N.key){o=n;}if(a.length==m){r.broken=true;}}}.bind(this));return{rowIndices:a,oldIndex:o,leadIndex:-1};};
d.prototype.setSelectedIndex=function(r){var n=this.findNode(r);if(n){var o=this._clearSelection();var i=o.rowIndices.indexOf(r);if(i>=0){o.rowIndices.splice(i,1);}else{o.rowIndices.push(r);}o.leadKey=n.key;o.leadIndex=r;this.setNodeSelection(n,true);this._publishSelectionChanges(o);}else{q.sap.log.warning("ODataTreeBindingFlat: The selection of index '"+r+"' was ignored. Please make sure to only select rows, for which data has been fetched to the client.");}};
d.prototype.getSelectedIndex=function(){return this._bReadOnly?this._indexGetSelectedIndex():this._mapGetSelectedIndex();};
d.prototype._indexGetSelectedIndex=function(){if(!this._sLeadSelectionKey||q.isEmptyObject(this._mSelected)){return-1;}var s=this._mSelected[this._sLeadSelectionKey];if(s){return this.getRowIndexByNode(s);}else{return-1;}};
d.prototype._mapGetSelectedIndex=function(){if(!this._sLeadSelectionKey||q.isEmptyObject(this._mSelected)){return-1;}var n=-1;this._map(function(N,r){n++;if(N){if(N.key===this._sLeadSelectionKey){r.broken=true;}}}.bind(this));return n;};
d.prototype.getSelectedIndices=function(){return this._bReadOnly?this._indexGetSelectedIndices():this._mapGetSelectedIndices();};
d.prototype._indexGetSelectedIndices=function(){var n=this._getSelectedNodesInfo();return n.map(function(N){return N.rowIndex;});};
d.prototype._mapGetSelectedIndices=function(){var r=[];if(q.isEmptyObject(this._mSelected)){return r;}var n=-1;this._map(function(N){n++;if(N){if(N.nodeState&&N.nodeState.selected){r.push(n);}}});return r;};
d.prototype.getSelectedNodesCount=function(){var s;if(this._bSelectAll){if(this._bReadOnly){var r=[],n=0,k;this._aExpandedAfterSelectAll.sort(function(a,b){var A=this._getRelatedServerIndex(a);var B=this._getRelatedServerIndex(b);if(A==B&&a.isDeepOne&&b.isDeepOne){return a.originalLevel-b.originalLevel;}return A-B;}.bind(this));var l=-1,N,e,i;for(i=0;i<this._aExpandedAfterSelectAll.length;i++){N=this._aExpandedAfterSelectAll[i];e=this._getRelatedServerIndex(N);if(e<=l&&!N.initiallyCollapsed){continue;}if(N.initiallyCollapsed){l=e;}else{l=e+N.magnitude;}r.push(N);n+=N.magnitude;}var f=function(N,b){if(r.indexOf(N)!==-1){n--;b.broken=true;}};for(k in this._mSelected){this._up(this._mSelected[k],f,true);}var I;var g=function(N,b){if(N.nodeState.collapsed||(N.nodeState.removed&&!N.nodeState.reinserted)||r.indexOf(N)!==-1){I=false;b.broken=true;}};for(k in this._mDeselected){I=true;this._up(this._mDeselected[k],g,true);if(I){n++;}}s=this.getLength()-n;}else{s=0;this._map(function(N,R,a,b,p){var P;if(N){if(N.nodeState.selected){s++;}}else if(N===undefined&&a==="serverIndex"){var j=true;for(var i=b-1;i>=0;i--){if(this._aNodeChanges[i]){P=this._aNodes[i];if(P.serverIndex+P.magnitude>=b&&this._aExpandedAfterSelectAll.indexOf(P)!==-1){j=false;break;}}}if(j){s++;}}}.bind(this));}}else{var h=this._getInvisibleSelectedNodes();s=Math.max(Object.keys(this._mSelected).length-h.length,0);}return s;};
d.prototype.getSelectedContexts=function(){return this._bReadOnly?this._indexGetSelectedContexts():this._mapGetSelectedContexts();};
d.prototype._indexGetSelectedContexts=function(){var n=this._getSelectedNodesInfo();return n.map(function(N){return N.node.context;});};
d.prototype._mapGetSelectedContexts=function(){var r=[];if(q.isEmptyObject(this._mSelected)){return r;}var m=function(n){if(n){if(n.nodeState.selected&&!n.isArtificial){r.push(n.context);}}};this._map(m);return r;};
d.prototype.setSelectionInterval=function(f,t){var m=this._clearSelection();var s=this._setSelectionInterval(f,t,true);var I={};var r=[];var a;for(var i=0;i<m.rowIndices.length;i++){a=m.rowIndices[i];I[a]=true;}for(i=0;i<s.rowIndices.length;i++){a=s.rowIndices[i];if(I[a]){delete I[a];}else{I[a]=true;}}for(a in I){if(I[a]){r.push(parseInt(a,10));}}this._publishSelectionChanges({rowIndices:r,oldIndex:m.oldIndex,leadIndex:s.leadIndex,leadKey:s.leadKey});};
d.prototype._setSelectionInterval=function(f,t,s){return this._bReadOnly?this._indexSetSelectionInterval(f,t,s):this._mapSetSelectionInterval(f,t,s);};
d.prototype._indexSetSelectionInterval=function(f,t,s){var n=Math.min(f,t),N=Math.max(f,t),a=[],b=[],o,e,i,p;s=!!s;for(i=n;i<=N;i++){e=this.findNode(i);if(e){if(e.nodeState.selected!==s){b.push(i);}if(e.key===this._sLeadSelectionKey){o=i;}this.setNodeSelection(e,s);a.push(e);}}p={rowIndices:b,oldIndex:o,leadIndex:o&&!s?-1:undefined};if(a.length>0&&s){p.leadKey=a[a.length-1].key;p.leadIndex=N;}return p;};
d.prototype._mapSetSelectionInterval=function(f,t,s){var n=Math.min(f,t);var N=Math.max(f,t);var a=[];var b=[];var i=Math.abs(N-n)+1;var o;var e=-1;var m=function(g,r,I,h,P){e++;if(g){if(e>=n&&e<=N){if(g.nodeState.selected!==!!s){b.push(e);}if(g.key===this._sLeadSelectionKey){o=e;}this.setNodeSelection(g,!!s);a.push(g);if(a.length===i){r.broken=true;}}}}.bind(this);this._map(m);var p={rowIndices:b,oldIndex:o,leadIndex:o&&!s?-1:undefined};if(a.length>0&&s){var l=a[a.length-1];p.leadKey=l.key;p.leadIndex=N;}return p;};
d.prototype.addSelectionInterval=function(f,t){var p=this._setSelectionInterval(f,t,true);this._publishSelectionChanges(p);};
d.prototype.removeSelectionInterval=function(f,t){var p=this._setSelectionInterval(f,t,false);this._publishSelectionChanges(p);};
d.prototype.selectAll=function(){this._bReadOnly?this._indexSelectAll():this._mapSelectAll();};
d.prototype._indexSelectAll=function(){this._bSelectAll=true;this._aExpandedAfterSelectAll=[];var p={rowIndices:[],oldIndex:-1,selectAll:true};var l=this.getLength(),i,n;for(i=0;i<l;i++){n=this.findNode(i);if(n&&!n.isArtificial){if(n.key===this._sLeadSelectionKey){p.oldIndex=i;}if(!n.nodeState.selected){p.rowIndices.push(i);}this.setNodeSelection(n,true);p.leadKey=n.key;p.leadIndex=i;}}this._publishSelectionChanges(p);};
d.prototype._mapSelectAll=function(){this._bSelectAll=true;this._aExpandedAfterSelectAll=[];var p={rowIndices:[],oldIndex:-1,selectAll:true};var n=-1;this._map(function(N){if(!N||!N.isArtificial){n++;}if(N){if(N.key===this._sLeadSelectionKey){p.oldIndex=n;}if(N){if(!N.isArtificial&&!N.nodeState.selected){p.rowIndices.push(n);}this.setNodeSelection(N,true);p.leadKey=N.key;p.leadIndex=n;}}}.bind(this));this._publishSelectionChanges(p);};
d.prototype.clearSelection=function(s){var o=this._clearSelection();if(!s){this._publishSelectionChanges(o);}};
d.prototype._publishSelectionChanges=function(p){p.oldIndex=p.oldIndex||this.getSelectedIndex();p.rowIndices.sort(function(a,b){return a-b;});if(p.leadIndex>=0&&p.leadKey){this._sLeadSelectionKey=p.leadKey;}else if(p.leadIndex===-1){this._sLeadSelectionKey=undefined;}else{p.leadIndex=p.oldIndex;}if(p.rowIndices.length>0||(p.leadIndex!=undefined&&p.leadIndex!==-1)){this.fireSelectionChanged(p);}};
d.prototype.setCollapseRecursive=function(b){this.bCollapseRecursive=!!b;};
d.prototype.resetData=function(){O.prototype.resetData.apply(this,arguments);this._aNodes=[];this._aCollapsed=[];this._aExpanded=[];this._aExpandedAfterSelectAll=[];this._mSelected={};this._mDeselected={};this._aRemoved=[];this._aNodeChanges=[];this._aAllChangedNodes=[];this._bLengthFinal=false;this._iLowestServerLevel=null;this._bSelectAll=false;this._iLengthDelta=0;};
d.prototype._findNodeByContext=function(o){for(var i in this._aNodeCache){if(this._aNodeCache[i]&&this._aNodeCache[i].context==o){return{node:this._aNodeCache[i],index:parseInt(i,10)};}}var n=-1;var N;this._map(function(a,r,I,b,p){n++;if(a){if(a.context===o){N=a;r.broken=true;}}});return{node:N,index:n};};
d.prototype._getCorrectChangeGroup=function(k){return this.oModel._resolveGroup(k).groupId;};
d.prototype.createEntry=function(p){var a=this.oModel.resolve(this.getPath(),this.getContext());var n;if(a){p=p||{};p.groupId=this._getCorrectChangeGroup(a);p.refreshAfterChange=false;n=this.oModel.createEntry(a,p);}else{q.sap.log.warning("ODataTreeBindingFlat: createEntry failed, as the binding path could not be resolved.");}return n;};
d.prototype.submitChanges=function(p){p=p||{};var a=this.oModel.resolve(this.getPath(),this.getContext());if(!a){q.sap.log.warning("ODataTreeBindingFlat: submitChanges failed, because the binding-path could nit be resolved.");return;}p.groupId=this._getCorrectChangeGroup(a);var o=p.success||q.noop;var f=p.error||q.noop;p.success=function(D){o(D);var s=false;if(D.__batchResponses&&D.__batchResponses[0]&&D.__batchResponses[0].__changeResponses&&D.__batchResponses[0].__changeResponses.length>0){var b=D.__batchResponses[0].__changeResponses;for(var i=0;i<b.length;i++){var r=b[i];var S=parseInt(r.statusCode,10);if(S<200||S>299){s=true;break;}}if(s){}else{this._refresh(true);}}else{q.sap.log.warning("ODataTreeBindingFlat.submitChanges - success: Batch-request response does not contain change response.");}}.bind(this);p.error=function(e){f(e);};this._generateSubmitData();this.oModel.submitChanges(p);};
d.prototype._generateSubmitData=function(){var I=false;var f=function(N,b){if(N.nodeState.removed&&!N.nodeState.reinserted){I=true;b.broken=true;}};var p=[];var t=function(N){if((N.isDeepOne||N.serverIndex>=0)&&p.indexOf(N)==-1){p.push(N);}if(N.nodeState.added){this._generateDeleteRequest(N);}}.bind(this);this._aAllChangedNodes.forEach(function(N){I=false;this._up(N,f,false);if(I){t(N);}else{if(N.nodeState.removed&&!N.nodeState.reinserted){t(N);}else{var P=N.parent.context.getProperty(this.oTreeProperties["hierarchy-node-for"]);this.oModel.setProperty(this.oTreeProperties["hierarchy-parent-node-for"],P,N.context);}}}.bind(this));p.sort(function(a,b){var A=this._getRelatedServerIndex(a);var B=this._getRelatedServerIndex(b);if(A==B&&a.isDeepOne&&b.isDeepOne){return a.originalLevel-b.originalLevel;}return A-B;}.bind(this));var n=function(D){var b=false;this._up(D,function(P,B){if(P.nodeState.removed&&!P.nodeState.reinserted){b=true;B.broken=true;}},true);return b;}.bind(this);for(var i=0;i<p.length;i++){var D=p[i];if(!n(D)){this._generateDeleteRequest(D);q.sap.log.debug("ODataTreeBindingFlat: DELETE "+D.key);}}};
d.prototype._nodeIsOnTopLevel=function(n){if(n&&n.serverIndex>=0){var p=n.parent==null;if(p){if(n.originalLevel==this._iLowestServerLevel){return true;}else{return false;}}}else{q.sap.log.warning("ODataTreeBindingFlat.nodeIsOnTopLevel: Node is not defined or not a server-indexed node.");}};
d.prototype._generateDeleteRequest=function(n){var o=n.context;if(n.nodeState.added){this.oModel.deleteCreatedEntry(o);}else{var a=this.oModel.resolve(this.getPath(),this.getContext());var D=this.oModel.remove(o.getPath(),{groupId:this._getCorrectChangeGroup(a),refreshAfterChange:false});return D;}};
d.prototype._trackChangedNode=function(n){if(this._aAllChangedNodes.indexOf(n)==-1){this._aAllChangedNodes.push(n);}};
d.prototype.addContexts=function(p,v){var n=this._findNodeByContext(p),N=n.node,m=this.getModel(),o,a;if(N){this._bReadOnly=false;if(N.nodeState&&N.nodeState.isLeaf){N.nodeState.isLeaf=false;N.nodeState.collapsed=true;}if(!q.isArray(v)){if(v instanceof sap.ui.model.Context){v=[v];}else{q.sap.log.warning("ODataTreeBinding.addContexts(): The child node argument is not of type sap.ui.model.Context.");}}var b=function(f){return function(){return[f];};};v=v.slice();v.reverse();for(var j=0;j<v.length;j++){var a=v[j];if(!a||!(a instanceof sap.ui.model.Context)){q.sap.log.warning("ODataTreeBindingFlat.addContexts(): no valid child context given!");return;}var o=this._mSubtreeHandles[a.getPath()];this._ensureHierarchyNodeIDForContext(a);if(o&&o._isRemovedSubtree){q.sap.log.info("ODataTreeBindingFlat.addContexts(): Existing context added '"+a.getPath()+"'");o._oNewParentNode=N;o._oSubtreeRoot.nodeState.reinserted=true;o._oSubtreeRoot.originalParent=o._oSubtreeRoot.originalParent||o._oSubtreeRoot.parent;o._oSubtreeRoot.parent=N;o._oSubtreeRoot.containingSubtreeHandle=o;a=o.getContext();this._trackChangedNode(o._oSubtreeRoot);this._mSubtreeHandles[a.getPath()];}else{q.sap.log.info("ODataTreeBindingFlat.addContexts(): Newly created context added.");this._ensureHierarchyNodeIDForContext(a);var f={context:a,key:m.getKey(a),parent:N,nodeState:{isLeaf:true,collapsed:false,expanded:false,selected:false,added:true},addedSubtrees:[],children:[],magnitude:0};this._trackChangedNode(f);this._aAdded.push(f);o={_getSubtree:b(f),_oSubtreeRoot:null,_oNewParentNode:N};}o._iContainingServerIndex=N.serverIndex||N.containingServerIndex;N.addedSubtrees.unshift(o);if(N.serverIndex!==undefined){this._aNodeChanges[N.serverIndex]=true;}}this._aNodeCache=[];this._cleanTreeStateMaps();this._fireChange({reason:C.Add});}else{q.sap.log.warning("The given parent context could not be found in the tree. No new sub-nodes were added!");}};
d.prototype._ensureHierarchyNodeIDForContext=function(o){if(o){var n=o.getProperty(this.oTreeProperties["hierarchy-node-for"]);if(o.bCreated&&!n){this.oModel.setProperty(this.oTreeProperties["hierarchy-node-for"],q.sap.uid(),o);}}};
d.prototype.removeContext=function(o){var t=this;var n=this._findNodeByContext(o);var N=n.node;var i=n.index;if(N){this._bReadOnly=false;N.nodeState.removed=true;this._aRemoved.push(N);this._trackChangedNode(N);if(N.serverIndex!==undefined){this._aNodeChanges[N.serverIndex]=true;}if(N.containingSubtreeHandle&&N.parent!=null){var a=N.parent.addedSubtrees.indexOf(N.containingSubtreeHandle);if(a!=-1){N.parent.addedSubtrees.splice(a,1);N.nodeState.reinserted=false;N.parent=null;}}this._aNodeCache=[];this.setNodeSelection(N,false);this._cleanUpSelection(true);this._cleanTreeStateMaps();this._fireChange({reason:C.Remove});this._mSubtreeHandles[o.getPath()]={_removedFromVisualIndex:i,_isRemovedSubtree:true,_oSubtreeRoot:N,_getSubtree:function(){if(N.serverIndex!=undefined&&!N.initiallyCollapsed){return t._aNodes.slice(N.serverIndex,N.serverIndex+N.magnitude+1);}else{return N;}},getContext:function(){return o;},_restore:function(){N.nodeState.removed=false;var b=t._aRemoved.indexOf(N);if(b!=-1){t._aRemoved.splice(b,1);}this._aNodeCache=[];t._cleanTreeStateMaps();t._fireChange({reason:C.Add});}};return o;}else{q.sap.log.warning("ODataTreeBinding.removeContexts(): The given context is not part of the tree. Was it removed already?");}};
d.prototype._getRelatedServerIndex=function(n){if(n.serverIndex===undefined){return n.containingServerIndex;}else{return n.serverIndex;}};
d.prototype.getNodeInfoByRowIndex=function(r){var i=0,e=0,n,t,v=-1;while(i<this._aCollapsed.length||e<this._aExpanded.length){if(this._aCollapsed[i]&&this._aExpanded[e]){if(this._getRelatedServerIndex(this._aCollapsed[i])>this._getRelatedServerIndex(this._aExpanded[e])){n=this._aExpanded[e];e++;t=false;}else{n=this._aCollapsed[i];i++;t=true;}}else if(this._aCollapsed[i]){n=this._aCollapsed[i];i++;t=true;}else{n=this._aExpanded[e];e++;t=false;}if(r<=this._getRelatedServerIndex(n)){break;}if(t){if(!n.isDeepOne&&!n.initiallyCollapsed&&n.serverIndex>v){r+=n.magnitude;v=n.serverIndex+n.magnitude;}}else{if(n.serverIndex>v){if(!n.isDeepOne&&n.initiallyCollapsed){r-=n.magnitude;}if(r<=n.serverIndex){return this._calcDirectIndex(n,r+n.magnitude-n.serverIndex-1);}}}}return{index:r};};
d.prototype._calcDirectIndex=function(n,a){var i,m,o;for(i=0;i<n.children.length;i++){o=n.children[i];if(a===0){return{parent:n,childIndex:i};}m=o?o.magnitude:0;a--;if(!o||o.nodeState.collapsed){continue;}if(a<m){return this._calcDirectIndex(o,a);}else{a-=m;}}};
d.prototype.getRowIndexByNode=function(n){var D=0;var o;var i;if(n.isDeepOne){while(n.parent){D+=n.positionInParent+1;for(i=0;i<n.positionInParent;i++){o=n.parent.children[i];if(o&&o.nodeState.expanded){D+=o.magnitude;}}n=n.parent;}}return this._calcIndexDelta(n.serverIndex)+n.serverIndex+D;};
d.prototype._getSelectedNodesInfo=function(){var n=[];if(q.isEmptyObject(this._mSelected)){return n;}var i=true;var f=function(N,b){if(N.nodeState.collapsed||(N.nodeState.removed&&!N.nodeState.reinserted)){i=false;b.broken=true;}};for(var k in this._mSelected){var s=this._mSelected[k];i=true;this._up(s,f,false);if(i){n.push({node:s,rowIndex:this.getRowIndexByNode(s)});}}n.sort(function(N,o){return N.rowIndex-o.rowIndex;});return n;};
d.prototype._calcIndexDelta=function(e){var m={};this._aCollapsed.forEach(function(n){if(n.serverIndex>=0&&n.serverIndex<e&&!n.isDeepOne&&!n.initiallyCollapsed){m[n.serverIndex]=n.magnitude;}});var l=0;var a=0;for(var i=0;i<this._aCollapsed.length;i++){var o=this._aCollapsed[i];if(this._getRelatedServerIndex(o)>=e){break;}if(!o.isDeepOne){if(o.serverIndex>=l&&!o.initiallyCollapsed){a-=o.magnitude;l=o.serverIndex+o.magnitude;}else{}}else{}}var E=0;var I=function(n){var f=false;var g=n.serverIndex||n.containingServerIndex;for(var j in m){if(g>j&&g<j+m[j]){f=true;break;}}return f;};for(i=0;i<this._aExpanded.length;i++){var b=this._aExpanded[i];if(this._getRelatedServerIndex(b)>=e){break;}if(b.isDeepOne){var p=b.parent;var y=false;while(p){if(p.nodeState.collapsed){y=true;break;}p=p.parent;}var f=I(b);if(!y&&!f){E+=b.children.length;}}else if(b.initiallyCollapsed){var f=I(b);if(!f){E+=b.children.length;}}}return E+a;};
d.prototype._sortNodes=function(n){var s=function(a,b){var A=this._getRelatedServerIndex(a);var B=this._getRelatedServerIndex(b);return A-B;}.bind(this);n.sort(s);};
d.prototype.attachSelectionChanged=function(D,f,l){this.attachEvent("selectionChanged",D,f,l);return this;};
d.prototype.detachSelectionChanged=function(f,l){this.detachEvent("selectionChanged",f,l);return this;};
d.prototype.fireSelectionChanged=function(a){this.fireEvent("selectionChanged",a);return this;};
d.prototype.getRootContexts=function(){};
d.prototype.getNodeContexts=function(){};
return d;},true);
sap.ui.predefine('sap/ui/model/odata/ODataUtils',['jquery.sap.global','./Filter','sap/ui/model/Sorter','sap/ui/model/Filter','sap/ui/core/format/DateFormat'],function(q,O,S,F,D){"use strict";var r=/^([-+]?)0*(\d+)(\.\d+|)$/,a=/\.$/,b=/0+$/;var c=function(){};
c.createSortParams=function(j){var m;if(!j||j.length==0){return;}m="$orderby=";for(var i=0;i<j.length;i++){var o=j[i];if(o instanceof S){m+=o.sPath;m+=o.bDescending?"%20desc":"%20asc";m+=",";}else{q.sap.log.error("Trying to use "+o+" as a Sorter, but it is a "+typeof o);}}m=m.slice(0,-1);return m;};
c.createFilterParams=function(i,m,E){if(!i||i.length==0){return;}return"$filter="+this._createFilterParams(i,m,E);};
c._createFilterParams=function(m,M,E){var o;if(!m||m.length==0){return;}var t={},u=0,v,o="",w=0,x=this;q.each(m,function(j,i){if(i.sPath){v=t[i.sPath];if(!v){v=t[i.sPath]=[];u++;}}else{v=t["__multiFilter"];if(!v){v=t["__multiFilter"]=[];u++;}}v.push(i);});q.each(t,function(P,v){if(v.length>1){o+='(';}q.each(v,function(i,j){if(j instanceof O){if(j.aValues.length>1){o+='(';}q.each(j.aValues,function(i,y){if(i>0){if(j.bAND){o+="%20and%20";}else{o+="%20or%20";}}o=x._createFilterSegment(j.sPath,M,E,y.operator,y.value1,y.value2,o);});if(j.aValues.length>1){o+=')';}}else if(j._bMultiFilter){o+=x._resolveMultiFilter(j,M,E);}else{o=x._createFilterSegment(j.sPath,M,E,j.sOperator,j.oValue1,j.oValue2,o);}if(i<v.length-1){o+="%20or%20";}});if(v.length>1){o+=')';}if(w<u-1){o+="%20and%20";}w++;});return o;};
c._createUrlParamsArray=function(P){var u,t=q.type(P),i;if(t==="array"){return P;}u=[];if(t==="object"){i=this._encodeURLParameters(P);if(i){u.push(i);}}else if(t==="string"){if(P){u.push(P);}}return u;};
c._encodeURLParameters=function(P){if(!P){return"";}var u=[];q.each(P,function(i,v){if(q.type(v)==="string"){v=encodeURIComponent(v);}i=q.sap.startsWith(i,'$')?i:encodeURIComponent(i);u.push(i+"="+v);});return u.join("&");};
c.setOrigin=function(i,P){var o,j,C;if(!i||!P||i.indexOf(";mo")>0){return i;}if(typeof P=="string"){o=P;}else{o=P.alias;if(!o){j=P.system;C=P.client;if(!j||!C){q.sap.log.warning("ODataUtils.setOrigin: No Client or System ID given for Origin");return i;}o="sid("+j+"."+C+")";}}var u=i.split("?");var B=u[0];var U=u[1]?"?"+u[1]:"";var t="";if(B[B.length-1]==="/"){B=B.substring(0,B.length-1);t="/";}var m=/(\/[^\/]+)$/g;var v=/(;o=[^\/;]+)/g;var L=B.match(m)[0];var w=L.match(v);var x=w?w[0]:null;if(x){if(P.force){var y=L.replace(x,";o="+o);B=B.replace(L,y);return B+t+U;}return i;}B=B+";o="+o+t;return B+U;};
c.setAnnotationOrigin=function(A,P){var i;var j=A.indexOf("/Annotations(");if(j===-1){j=A.indexOf("/Annotations%28");}if(j>=0){if(A.indexOf("/$value",j)===-1){q.sap.log.warning("ODataUtils.setAnnotationOrigin: Annotation url is missing $value segment.");i=A;}else{var m=A.substring(0,j);var o=A.substring(j,A.length);var t=c.setOrigin(m,P);i=t+o;}}else{i=A.replace(P.preOriginBaseUri,P.postOriginBaseUri);}return i;};
c._resolveMultiFilter=function(m,M,E){var t=this,j=m.aFilters,o="";if(j){o+="(";q.each(j,function(i,u){if(u._bMultiFilter){o+=t._resolveMultiFilter(u,M,E);}else if(u.sPath){o+=t._createFilterSegment(u.sPath,M,E,u.sOperator,u.oValue1,u.oValue2,"");}if(i<(j.length-1)){if(m.bAnd){o+="%20and%20";}else{o+="%20or%20";}}});o+=")";}return o;};
c._createFilterSegment=function(P,m,E,o,v,V,i){var j,t;if(E){j=m._getPropertyMetadata(E,P);t=j&&j.type;}if(t){v=this.formatValue(v,t);V=(V!=null)?this.formatValue(V,t):null;}else{}if(v){v=q.sap.encodeURL(String(v));}if(V){V=q.sap.encodeURL(String(V));}switch(o){case"EQ":case"NE":case"GT":case"GE":case"LT":case"LE":i+=P+"%20"+o.toLowerCase()+"%20"+v;break;case"BT":i+="("+P+"%20ge%20"+v+"%20and%20"+P+"%20le%20"+V+")";break;case"Contains":i+="substringof("+v+","+P+")";break;case"StartsWith":i+="startswith("+P+","+v+")";break;case"EndsWith":i+="endswith("+P+","+v+")";break;default:i+="true";}return i;};
c.formatValue=function(v,t){if(!this.oDateTimeFormat){this.oDateTimeFormat=D.getDateInstance({pattern:"'datetime'''yyyy-MM-dd'T'HH:mm:ss''"});this.oDateTimeOffsetFormat=D.getDateInstance({pattern:"'datetimeoffset'''yyyy-MM-dd'T'HH:mm:ss'Z'''"});this.oTimeFormat=D.getTimeInstance({pattern:"'time''PT'HH'H'mm'M'ss'S'''"});}if(v===null||v===undefined){return"null";}var V;switch(t){case"Edm.String":V="'"+String(v).replace(/'/g,"''")+"'";break;case"Edm.Time":if(typeof v==="object"){V=this.oTimeFormat.format(new Date(v.ms),true);}else{V="time'"+v+"'";}break;case"Edm.DateTime":V=this.oDateTimeFormat.format(new Date(v),true);break;case"Edm.DateTimeOffset":V=this.oDateTimeOffsetFormat.format(new Date(v),true);break;case"Edm.Guid":V="guid'"+v+"'";break;case"Edm.Decimal":V=v+"m";break;case"Edm.Int64":V=v+"l";break;case"Edm.Double":V=v+"d";break;case"Edm.Float":case"Edm.Single":V=v+"f";break;case"Edm.Binary":V="binary'"+v+"'";break;default:V=String(v);break;}return V;};
function s(v,V){if(v===V){return 0;}if(v===null||V===null||v===undefined||V===undefined){return NaN;}return v>V?1:-1;}
function p(v){var m;if(typeof v!=="string"){return undefined;}m=r.exec(v);if(!m){return undefined;}return{sign:m[1]==="-"?-1:1,integerLength:m[2].length,abs:m[2]+m[3].replace(b,"").replace(a,"")};}
function d(v,V){var o,i,R;if(v===V){return 0;}o=p(v);i=p(V);if(!o||!i){return NaN;}if(o.sign!==i.sign){return o.sign>i.sign?1:-1;}R=s(o.integerLength,i.integerLength)||s(o.abs,i.abs);return o.sign*R;}
var e=/^PT(\d\d)H(\d\d)M(\d\d)S$/;
function f(v){if(typeof v==="string"&&e.test(v)){v=parseInt(RegExp.$1,10)*3600000+parseInt(RegExp.$2,10)*60000+parseInt(RegExp.$3,10)*1000;}if(v instanceof Date){return v.getTime();}if(v&&v.__edmType==="Edm.Time"){return v.ms;}return v;}
c.compare=function(v,V,A){return A?d(v,V):s(f(v),f(V));};
c.getComparator=function(E){switch(E){case"Edm.Date":case"Edm.DateTime":case"Edm.DateTimeOffset":case"Edm.Time":return c.compare;case"Edm.Decimal":case"Edm.Int64":return d;default:return s;}};
var g=/([(=,])('.*?')([,)])/g,h=/[MLDF](?=[,)](?:[^']*'[^']*')*[^']*$)/g,k=/([(=,])(X')/g,n=function(v,i,j,m){return i+encodeURIComponent(decodeURIComponent(j))+m;},N=function(v){return v.toLowerCase();},l=function(v,i){return i+"binary'";};
c._normalizeKey=function(K){return K.replace(g,n).replace(h,N).replace(k,l);};
return c;},true);
sap.ui.predefine('sap/ui/model/odata/OperationMode',function(){"use strict";var O={Default:"Default",Server:"Server",Client:"Client",Auto:"Auto"};return O;},true);
sap.ui.predefine('sap/ui/model/odata/UpdateMethod',function(){"use strict";var U={Merge:"MERGE",Put:"PUT"};return U;},true);
sap.ui.predefine('sap/ui/model/odata/_AnnotationHelperBasics',['jquery.sap.global','sap/ui/base/BindingParser'],function(q,B){'use strict';var a="sap.ui.model.odata.AnnotationHelper",r=/[\\\{\}:]/,b,d=/^(\/dataServices\/schema\/\d+\/entityContainer\/\d+\/entitySet\/\d+)(?:\/|$)/,p=[a],P=a+"/followPath",f=/^(\/dataServices\/schema\/\d+\/(?:complex|entity)Type\/\d+)(?:\/|$)/,u={"Edm.Boolean":"sap.ui.model.odata.type.Boolean","Edm.Byte":"sap.ui.model.odata.type.Byte","Edm.DateTime":"sap.ui.model.odata.type.DateTime","Edm.DateTimeOffset":"sap.ui.model.odata.type.DateTimeOffset","Edm.Decimal":"sap.ui.model.odata.type.Decimal","Edm.Double":"sap.ui.model.odata.type.Double","Edm.Float":"sap.ui.model.odata.type.Single","Edm.Guid":"sap.ui.model.odata.type.Guid","Edm.Int16":"sap.ui.model.odata.type.Int16","Edm.Int32":"sap.ui.model.odata.type.Int32","Edm.Int64":"sap.ui.model.odata.type.Int64","Edm.SByte":"sap.ui.model.odata.type.SByte","Edm.Single":"sap.ui.model.odata.type.Single","Edm.String":"sap.ui.model.odata.type.String","Edm.Time":"sap.ui.model.odata.type.Time"};b={descend:function(o,v,e){var t=q.extend({},o);b.expectType(o,typeof v==="number"?"array":"object");t.path=o.path+"/"+v;t.value=o.value[v];if(e===true){t.asExpression=true;}else if(e){b.expectType(t,e);}return t;},error:function(o,m,c){m=o.path+": "+m;q.sap.log.error(m,b.toErrorString(o.value),c||a);throw new SyntaxError(m);},expectType:function(o,e){var E,v=o.value;if(e==="array"){E=!Array.isArray(v);}else{E=typeof v!==e||v===null||Array.isArray(v);}if(E){b.error(o,"Expected "+e);}},followPath:function(i,R){var A,s,c,I,m=i.getModel(),e,o={associationSetEnd:undefined,navigationAfterMultiple:false,isMultiple:false,navigationProperties:[],resolvedPath:undefined},S,t;q.sap.measure.average(P,"",p);s=b.getPath(R);c=s!==undefined&&b.getStartingPoint(i,s);if(!c){q.sap.measure.end(P);return undefined;}e=s.split("/");while(s&&e.length&&c){S=e[0];I=S.indexOf("@");if(I===0){c+="/"+S.slice(1);e.shift();continue;}t=m.getObject(c);A=m.getODataAssociationEnd(t,S);if(A){o.associationSetEnd=m.getODataAssociationSetEnd(t,S);o.navigationProperties.push(S);if(o.isMultiple){o.navigationAfterMultiple=true;}o.isMultiple=A.multiplicity==="*";c=m.getODataEntityType(A.type,true);e.shift();continue;}c=m.getODataProperty(t,e,true);}o.resolvedPath=c;q.sap.measure.end(P);return o;},getPath:function(R){if(R){if(R.hasOwnProperty("AnnotationPath")){return R.AnnotationPath;}if(R.hasOwnProperty("Path")){return R.Path;}if(R.hasOwnProperty("PropertyPath")){return R.PropertyPath;}if(R.hasOwnProperty("NavigationPropertyPath")){return R.NavigationPropertyPath;}}return undefined;},getStartingPoint:function(i,s){var e,m=f.exec(i.getPath()),M;if(m){return m[1];}m=d.exec(i.getPath());if(m){if(!s){return m[1];}M=i.getModel();e=M.getObject(m[1]);return M.getODataEntityType(e.entityType,true);}return undefined;},property:function(o,v,e){return b.descend(o,v,e).value;},resultToString:function(R,e,w){var v=R.value;function c(A){var C,s;A=A&&!R.ignoreTypeInPath&&R.type;if(A||r.test(v)){s="{path:"+b.toJSON(v);if(A){s+=",type:'"+u[R.type]+"'";C=b.toJSON(R.constraints);if(C&&C!=="{}"){s+=",constraints:"+C;}}return s+"}";}return"{"+v+"}";}function g(R){switch(R.type){case"Edm.Boolean":case"Edm.Double":case"Edm.Int32":return String(R.value);default:return b.toJSON(R.value);}}switch(R.result){case"binding":return(e?"$":"")+c(w);case"composite":if(e){throw new Error("Trying to embed a composite binding into an expression binding");}return v;case"constant":if(R.type==="edm:Null"){return e?"null":null;}if(e){return g(R);}return typeof v==="string"?B.complexParser.escape(v):String(v);case"expression":return e?v:"{="+v+"}";}},toErrorString:function(v){var j;if(typeof v!=="function"){try{j=b.toJSON(v);if(j!==undefined&&j!=="null"){return j;}}catch(e){}}return String(v);},toJSON:function(v){var s,e=false,R="",i,c;s=JSON.stringify(v);if(s===undefined){return undefined;}for(i=0;i<s.length;i+=1){switch(c=s.charAt(i)){case"'":R+="\\'";break;case'"':if(e){R+=c;e=false;}else{R+="'";}break;case"\\":if(e){R+="\\\\";}e=!e;break;default:if(e){R+="\\";e=false;}R+=c;}}return R;}};return b;},false);
sap.ui.predefine('sap/ui/model/odata/_AnnotationHelperExpression',['jquery.sap.global','./_AnnotationHelperBasics','sap/ui/base/BindingParser','sap/ui/base/ManagedObject','sap/ui/core/format/DateFormat','sap/ui/model/odata/ODataUtils'],function(q,B,a,M,D,O){'use strict';var A="sap.ui.model.odata.AnnotationHelper",d="\\d{4}-(?:0[1-9]|1[0-2])-(?:0[1-9]|[12]\\d|3[01])",s="[-+]?\\d+(?:\\.\\d+)?",m="9007199254740991",b="-"+m,p=[A],P=A+"/getExpression",t="(?:[01]\\d|2[0-3]):[0-5]\\d(?::[0-5]\\d(\\.\\d{1,12})?)?",E={Bool:/^true$|^false$/i,Float:new RegExp("^"+s+"(?:[eE][-+]?\\d+)?$|^NaN$|^-INF$|^INF$"),Date:new RegExp("^"+d+"$"),DateTimeOffset:new RegExp("^"+d+"T"+t+"(?:Z|[-+](?:0\\d|1[0-3]):[0-5]\\d|[-+]14:00)$","i"),Decimal:new RegExp("^"+s+"$"),Guid:/^[A-F0-9]{8}-(?:[A-F0-9]{4}-){3}[A-F0-9]{12}$/i,Int:/^[-+]?\d{1,19}$/,TimeOfDay:new RegExp("^"+t+"$")},c,r=/^\{@i18n>[^\\\{\}:]+\}$/,f=/^\d+$/,o={And:"&&",Eq:"===",Ge:">=",Gt:">",Le:"<=",Lt:"<",Ne:"!==",Not:"!",Or:"||"},g=/^(\/dataServices\/schema\/\d+)(?:\/|$)/,T={"Edm.Boolean":"boolean","Edm.Byte":"number","Edm.Date":"date","Edm.DateTime":"datetime","Edm.DateTimeOffset":"datetime","Edm.Decimal":"decimal","Edm.Double":"number","Edm.Float":"number","Edm.Guid":"string","Edm.Int16":"number","Edm.Int32":"number","Edm.Int64":"decimal","Edm.SByte":"number","Edm.Single":"number","Edm.String":"string","Edm.Time":"time","Edm.TimeOfDay":"time"},h={Bool:"Edm.Boolean",Float:"Edm.Double",Date:"Edm.Date",DateTimeOffset:"Edm.DateTimeOffset",Decimal:"Edm.Decimal",Guid:"Edm.Guid",Int:"Edm.Int64",String:"Edm.String",TimeOfDay:"Edm.TimeOfDay"},j={"boolean":false,"date":true,"datetime":true,"decimal":true,"number":false,"string":false,"time":true};c={adjustOperands:function(e,i){if(e.result!=="constant"&&e.category==="number"&&i.result==="constant"&&i.type==="Edm.Int64"){i.category="number";}if(e.result!=="constant"&&e.category==="decimal"&&i.result==="constant"&&i.type==="Edm.Int32"){i.category="decimal";i.type=e.type;}if(e.result==="constant"&&e.category==="date"&&i.result!=="constant"&&i.category==="datetime"){i.category="date";}},apply:function(i,e){var n=B.descend(e,"Name","string"),k=B.descend(e,"Parameters");switch(n.value){case"odata.concat":return c.concat(i,k);case"odata.fillUriTemplate":return c.fillUriTemplate(i,k);case"odata.uriEncode":return c.uriEncode(i,k);default:B.error(n,"unknown function: "+n.value);}},concat:function(I,e){var k=e.asExpression,l=[],R,n=[];B.expectType(e,"array");e.value.forEach(function(u,i){R=c.parameter(I,e,i);k=k||R.result==="expression";n.push(R);});n.forEach(function(R){if(k){c.wrapExpression(R);}if(R.type!=='edm:Null'){l.push(B.resultToString(R,k,e.withType));}});R=k?{result:"expression",value:l.join("+")}:{result:"composite",value:l.join("")};R.type="Edm.String";return R;},conditional:function(i,e){var C=c.parameter(i,e,0,"Edm.Boolean"),k=c.parameter(i,e,1),l=c.parameter(i,e,2),n=k.type,w=e.withType;if(k.type==="edm:Null"){n=l.type;}else if(l.type!=="edm:Null"&&k.type!==l.type){B.error(e,"Expected same type for second and third parameter, types are '"+k.type+"' and '"+l.type+"'");}return{result:"expression",type:n,value:B.resultToString(c.wrapExpression(C),true,false)+"?"+B.resultToString(c.wrapExpression(k),true,w)+":"+B.resultToString(c.wrapExpression(l),true,w)};},constant:function(i,e,k){var v=e.value;B.expectType(e,"string");if(k==="String"){if(r.test(v)){return{ignoreTypeInPath:true,result:"binding",type:"Edm.String",value:v.slice(1,-1)};}else if(i.getSetting&&i.getSetting("bindTexts")){return{result:"binding",type:"Edm.String",ignoreTypeInPath:true,value:"/##"+c.replaceIndexes(i.getModel(),e.path)};}k="Edm.String";}else if(!E[k].test(v)){B.error(e,"Expected "+k+" value but instead saw '"+v+"'");}else{k=h[k];if(k==="Edm.Int64"&&O.compare(v,b,true)>=0&&O.compare(v,m,true)<=0){k="Edm.Int32";}}return{result:"constant",type:k,value:v};},expression:function(i,e){var R=e.value,S,k;B.expectType(e,"object");if(R.hasOwnProperty("Type")){k=B.property(e,"Type","string");S=B.descend(e,"Value");}else{["And","Apply","Bool","Date","DateTimeOffset","Decimal","Float","Eq","Ge","Gt","Guid","If","Int","Le","Lt","Ne","Not","Null","Or","Path","PropertyPath","String","TimeOfDay"].forEach(function(l){if(R.hasOwnProperty(l)){k=l;S=B.descend(e,l);}});}switch(k){case"Apply":return c.apply(i,S);case"If":return c.conditional(i,S);case"Path":case"PropertyPath":return c.path(i,S);case"Bool":case"Date":case"DateTimeOffset":case"Decimal":case"Float":case"Guid":case"Int":case"String":case"TimeOfDay":return c.constant(i,S,k);case"And":case"Eq":case"Ge":case"Gt":case"Le":case"Lt":case"Ne":case"Or":return c.operator(i,S,k);case"Not":return c.not(i,S);case"Null":return{result:"constant",value:"null",type:"edm:Null"};default:B.error(e,"Unsupported OData expression");}},formatOperand:function(e,i,R,w){var k;if(R.result==="constant"){switch(R.category){case"boolean":case"number":return R.value;case"date":k=c.parseDate(R.value);if(!k){B.error(B.descend(e,i),"Invalid Date "+R.value);}return String(k.getTime());case"datetime":k=c.parseDateTimeOffset(R.value);if(!k){B.error(B.descend(e,i),"Invalid DateTime "+R.value);}return String(k.getTime());case"time":return String(c.parseTimeOfDay(R.value).getTime());}}if(w){c.wrapExpression(R);}return B.resultToString(R,true);},getExpression:function(i,R,w){var k;if(R===undefined){return undefined;}q.sap.measure.average(P,"",p);if(!c.simpleParserWarningLogged&&M.bindingParser===a.simpleParser){q.sap.log.warning("Complex binding syntax not active",null,A);c.simpleParserWarningLogged=true;}try{k=c.expression(i,{asExpression:false,path:i.getPath(),value:R,withType:w});q.sap.measure.end(P);return B.resultToString(k,false,w);}catch(e){q.sap.measure.end(P);if(e instanceof SyntaxError){return"Unsupported: "+a.complexParser.escape(B.toErrorString(R));}throw e;}},fillUriTemplate:function(I,e){var i,n,k=[],l="",u,v=e.value,R,w=c.parameter(I,e,0,"Edm.String");k.push('odata.fillUriTemplate(',B.resultToString(w,true),',{');for(i=1;i<v.length;i+=1){u=B.descend(e,i,"object");n=B.property(u,"Name","string");R=c.expression(I,B.descend(u,"Value"),true);k.push(l,B.toJSON(n),":",B.resultToString(R,true));l=",";}k.push("})");return{result:"expression",value:k.join(""),type:"Edm.String"};},not:function(i,e){var k;e.asExpression=true;k=c.expression(i,e);return{result:"expression",value:"!"+B.resultToString(c.wrapExpression(k),true),type:"Edm.Boolean"};},operator:function(i,e,k){var l=k==="And"||k==="Or"?"Edm.Boolean":undefined,n=c.parameter(i,e,0,l),u=c.parameter(i,e,1,l),v,N,V,w;if(n.type!=="edm:Null"&&u.type!=="edm:Null"){n.category=T[n.type];u.category=T[u.type];c.adjustOperands(n,u);c.adjustOperands(u,n);if(n.category!==u.category){B.error(e,"Expected two comparable parameters but instead saw "+n.type+" and "+u.type);}v=n.category==="decimal"?",true":"";N=j[n.category];}V=c.formatOperand(e,0,n,!N);w=c.formatOperand(e,1,u,!N);return{result:"expression",value:N?"odata.compare("+V+","+w+v+")"+o[k]+"0":V+o[k]+w,type:"Edm.Boolean"};},parameter:function(i,e,I,k){var l=B.descend(e,I),R;l.asExpression=true;R=c.expression(i,l);if(k&&k!==R.type){B.error(l,"Expected "+k+" but instead saw "+R.type);}return R;},parseDate:function(v){return D.getDateInstance({pattern:"yyyy-MM-dd",strictParsing:true,UTC:true}).parse(v);},parseDateTimeOffset:function(v){var e=E.DateTimeOffset.exec(v);if(e&&e[1]&&e[1].length>4){v=v.replace(e[1],e[1].slice(0,4));}return D.getDateTimeInstance({pattern:"yyyy-MM-dd'T'HH:mm:ss.SSSX",strictParsing:true}).parse(v.toUpperCase());},parseTimeOfDay:function(v){if(v.length>12){v=v.slice(0,12);}return D.getTimeInstance({pattern:"HH:mm:ss.SSS",strictParsing:true,UTC:true}).parse(v);},path:function(i,e){var k=e.value,C={},l,I,n,u=i.getModel(),v={getModel:function(){return u;},getPath:function(){return e.path;}},w,R={result:"binding",value:k},x;B.expectType(e,"string");x=B.followPath(v,{"Path":k});if(x&&x.resolvedPath){w=u.getProperty(x.resolvedPath);R.type=w.type;switch(w.type){case"Edm.DateTime":C.displayFormat=w["sap:display-format"];break;case"Edm.Decimal":C.precision=w.precision;C.scale=w.scale;n=w["Org.OData.Validation.V1.Minimum"];if(n&&n.String){C.minimum=n.String;l=n["Org.OData.Validation.V1.Exclusive"];if(l){C.minimumExclusive=l.Bool||"true";}}n=w["Org.OData.Validation.V1.Maximum"];if(n&&n.String){C.maximum=n.String;l=n["Org.OData.Validation.V1.Exclusive"];if(l){C.maximumExclusive=l.Bool||"true";}}break;case"Edm.String":C.maxLength=w.maxLength;I=w["com.sap.vocabularies.Common.v1.IsDigitSequence"];if(I){C.isDigitSequence=I.Bool||"true";}break;}if(w.nullable==="false"){C.nullable="false";}R.constraints=C;}else{q.sap.log.warning("Could not find property '"+k+"' starting from '"+e.path+"'",null,A);}return R;},replaceIndexes:function(e,k){var l,n=k.split('/'),u,R;function v(w,i){var x=e.getProperty(u+"/"+w);if(typeof x==="string"){n[i]="[${"+w+"}==="+B.toJSON(x)+"]";return true;}return false;}l=g.exec(k);if(!l){return k;}u=l[1];if(!v("namespace",3)){return k;}for(var i=4;i<n.length;i++){u=u+"/"+n[i];if(f.test(n[i])&&!v("name",i)){R=e.getProperty(u+"/RecordType");if(R){if(R==="com.sap.vocabularies.UI.v1.DataFieldForAction"){v("Action/String",i);}else if(R==="com.sap.vocabularies.UI.v1.DataFieldForAnnotation"){v("Target/AnnotationPath",i);}else if(R.indexOf("com.sap.vocabularies.UI.v1.DataField")===0){v("Value/Path",i);}}}}return n.join('/');},simpleParserWarningLogged:false,uriEncode:function(i,e){var R=c.parameter(i,e,0);if(R.result==="constant"){if(R.type==="Edm.Date"){R.type="Edm.DateTime";R.value=R.value+"T00:00:00Z";}else if(R.type==="Edm.TimeOfDay"){R.type="Edm.Time";R.value="PT"+R.value.slice(0,2)+"H"+R.value.slice(3,5)+"M"+R.value.slice(6,8)+"S";}}return{result:"expression",value:'odata.uriEncode('+B.resultToString(R,true)+","+B.toJSON(R.type)+")",type:"Edm.String"};},wrapExpression:function(R){if(R.result==="expression"){R.value="("+R.value+")";}return R;}};return c;},false);
sap.ui.predefine('sap/ui/model/odata/_ODataMetaModelUtils',["jquery.sap.global","./_AnnotationHelperBasics"],function(q,_){"use strict";var b={"Bool":"false"},B={"Bool":"true"},d={"year":"IsCalendarYear","yearmonth":"IsCalendarYearMonth","yearmonthday":"IsCalendarDate"},f={"interval":"SingleInterval","multi-value":"MultiValue","single-value":"SingleValue"},l="sap.ui.model.odata.ODataMetaModel",s={"bday":"Contact","city":"Contact/adr","country":"Contact/adr","email":"Contact/email","familyname":"Contact/n","givenname":"Contact/n","honorific":"Contact/n","middlename":"Contact/n","name":"Contact","nickname":"Contact","note":"Contact","org":"Contact","org-role":"Contact","org-unit":"Contact","photo":"Contact","pobox":"Contact/adr","region":"Contact/adr","street":"Contact/adr","suffix":"Contact/n","tel":"Contact/tel","title":"Contact","zip":"Contact/adr","class":"Event","dtend":"Event","dtstart":"Event","duration":"Event","fbtype":"Event","location":"Event","status":"Event","transp":"Event","wholeday":"Event","body":"Message","from":"Message","received":"Message","sender":"Message","subject":"Message","completed":"Task","due":"Task","percent-complete":"Task","priority":"Task"},r=/(\w+)(?:;type=([\w,]+))?/,v={"email":{typeMapping:{"home":"home","pref":"preferred","work":"work"},v4EnumType:"com.sap.vocabularies.Communication.v1.ContactInformationType",v4PropertyAnnotation:"com.sap.vocabularies.Communication.v1.IsEmailAddress"},"tel":{typeMapping:{"cell":"cell","fax":"fax","home":"home","pref":"preferred","video":"video","voice":"voice","work":"work"},v4EnumType:"com.sap.vocabularies.Communication.v1.PhoneType",v4PropertyAnnotation:"com.sap.vocabularies.Communication.v1.IsPhoneNumber"}},V={creatable:{"Org.OData.Capabilities.V1.InsertRestrictions":{"Insertable":b}},pageable:{"Org.OData.Capabilities.V1.SkipSupported":b,"Org.OData.Capabilities.V1.TopSupported":b},"requires-filter":{"Org.OData.Capabilities.V1.FilterRestrictions":{"RequiresFilter":B}},topable:{"Org.OData.Capabilities.V1.TopSupported":b}},m={"city":"locality","email":"address","familyname":"surname","givenname":"given","honorific":"prefix","middlename":"additional","name":"fn","org-role":"role","org-unit":"orgunit","percent-complete":"percentcomplete","tel":"uri","zip":"code"},a={"sap:filterable":["Org.OData.Capabilities.V1.FilterRestrictions","NonFilterableProperties"],"sap:required-in-filter":["Org.OData.Capabilities.V1.FilterRestrictions","RequiredProperties"],"sap:sortable":["Org.OData.Capabilities.V1.SortRestrictions","NonSortableProperties"]},c=/^com\.sap\.vocabularies\.Common\.v1\.ValueList(#.*)?$/,w=q.sap.log.Level.WARNING,U;U={addEntitySetAnnotation:function(o,e,t,n,D){if(t==="EntitySet"&&e.value===n){if(D){q.extend(true,o,V[e.name]);}else{q.extend(o,V[e.name]);}}},addFilterRestriction:function(p,e){var F,g=f[p["sap:filter-restriction"]];if(!g){if(q.sap.log.isLoggable(w,l)){q.sap.log.warning("Unsupported sap:filter-restriction: "+p["sap:filter-restriction"],e.entityType+"."+p.name,l);}return;}F=e["com.sap.vocabularies.Common.v1.FilterExpressionRestrictions"]||[];F.push({"Property":{"PropertyPath":p.name},"AllowedExpressions":{"EnumMember":"com.sap.vocabularies.Common.v1.FilterExpressionType/"+g}});e["com.sap.vocabularies.Common.v1.FilterExpressionRestrictions"]=F;},addPropertyToAnnotation:function(e,E,p){var n=a[e],t=n[0],C=n[1],A=E[t]||{},g=A[C]||[];g.push({"PropertyPath":p.name});A[C]=g;E[t]=A;},addSapSemantics:function(t){if(t.property){t.property.forEach(function(p){var A,i,M,S,T,e=p["sap:semantics"],g,h,o,j,k;if(!e){return;}if(e in d){g="com.sap.vocabularies.Common.v1."+d[e];p[g]=B;return;}M=r.exec(e);if(!M){if(q.sap.log.isLoggable(w,l)){q.sap.log.warning("Unsupported sap:semantics: "+e,t.name+"."+p.name,l);}return;}if(M[2]){e=M[1];k=U.getV4TypesForV2Semantics(e,M[2],p,t);}j=v[e];i=e==="tel"||e==="email";h=s[e];if(h){A=h.split("/");g="com.sap.vocabularies.Communication.v1."+A[0];t[g]=t[g]||{};o=t[g];S=A[1];if(S){o[S]=o[S]||(i?[]:{});if(i){T={};o[S].push(T);o=T;}else{o=o[S];}}o[m[e]||e]={"Path":p.name};if(k){o.type={"EnumMember":k};}}if(j){p[j.v4PropertyAnnotation]=p[j.v4PropertyAnnotation]||B;}});}},addUnitAnnotations:function(S,M){function p(t){(t||[]).forEach(function(T){(T.property||[]).forEach(function(P){var A,e,o,u,g=P["sap:unit"],h;if(g){u={"Path":g};o=_.followPath({getModel:function(){return M;},getPath:function(){return T.$path;}},u);if(o&&o.resolvedPath){h=M.getProperty(o.resolvedPath);e=h["sap:semantics"];if(e==="unit-of-measure"){A="Org.OData.Measures.V1.Unit";}else if(e==="currency-code"){A="Org.OData.Measures.V1.ISOCurrency";}else if(q.sap.log.isLoggable(w,l)){q.sap.log.warning("Unsupported sap:semantics='"+e+"' at sap:unit='"+g+"'; "+"expected 'currency-code' or 'unit-of-measure'",T.namespace+"."+T.name+"/"+P.name,l);}if(A&&!(A in P)){P[A]=u;}}else if(q.sap.log.isLoggable(w,l)){q.sap.log.warning("Path '"+g+"' for sap:unit cannot be resolved",T.namespace+"."+T.name+"/"+P.name,l);}}});});}S.forEach(function(o){p(o.complexType);p(o.entityType);});},addV4Annotation:function(o,e,t){switch(e.name){case"aggregation-role":if(e.value==="dimension"){o["com.sap.vocabularies.Analytics.v1.Dimension"]=B;}else if(e.value==="measure"){o["com.sap.vocabularies.Analytics.v1.Measure"]=B;}break;case"display-format":if(e.value==="NonNegative"){o["com.sap.vocabularies.Common.v1.IsDigitSequence"]=B;}else if(e.value==="UpperCase"){o["com.sap.vocabularies.Common.v1.IsUpperCase"]=B;}break;case"pageable":case"topable":U.addEntitySetAnnotation(o,e,t,"false",false);break;case"creatable":U.addEntitySetAnnotation(o,e,t,"false",true);break;case"deletable":case"deletable-path":U.handleXableAndXablePath(o,e,t,"Org.OData.Capabilities.V1.DeleteRestrictions","Deletable");break;case"updatable":case"updatable-path":U.handleXableAndXablePath(o,e,t,"Org.OData.Capabilities.V1.UpdateRestrictions","Updatable");break;case"requires-filter":U.addEntitySetAnnotation(o,e,t,"true",true);break;case"field-control":o["com.sap.vocabularies.Common.v1.FieldControl"]={"Path":e.value};break;case"heading":o["com.sap.vocabularies.Common.v1.Heading"]={"String":e.value};break;case"label":o["com.sap.vocabularies.Common.v1.Label"]={"String":e.value};break;case"precision":o["Org.OData.Measures.V1.Scale"]={"Path":e.value};break;case"quickinfo":o["com.sap.vocabularies.Common.v1.QuickInfo"]={"String":e.value};break;case"text":o["com.sap.vocabularies.Common.v1.Text"]={"Path":e.value};break;case"visible":if(e.value==="false"){o["com.sap.vocabularies.Common.v1.FieldControl"]={"EnumMember":"com.sap.vocabularies.Common.v1.FieldControlType/Hidden"};o["com.sap.vocabularies.UI.v1.Hidden"]=B;}break;default:}},calculateEntitySetAnnotations:function(e,E){if(E.property){E.property.forEach(function(p){if(p["sap:filterable"]==="false"){U.addPropertyToAnnotation("sap:filterable",e,p);}if(p["sap:required-in-filter"]==="true"){U.addPropertyToAnnotation("sap:required-in-filter",e,p);}if(p["sap:sortable"]==="false"){U.addPropertyToAnnotation("sap:sortable",e,p);}if(p["sap:filter-restriction"]){U.addFilterRestriction(p,e);}});}if(E.navigationProperty){E.navigationProperty.forEach(function(n){if(n["sap:filterable"]==="false"){U.addPropertyToAnnotation("sap:filterable",e,n);}U.handleCreatableNavigationProperty(e,n);});}},findIndex:function(A,e,p){var I=-1;p=p||"name";if(A){A.forEach(function(o,i){if(o[p]===e){I=i;return false;}});}return I;},findObject:function(A,e,p){var i=U.findIndex(A,e,p);return i<0?null:A[i];},getChildAnnotations:function(A,Q,i){var o=i?A.EntityContainer:A.propertyAnnotations;return o&&o[Q]||{};},getFromContainer:function(e,A,n,g){var k,R=g?undefined:null;if(e){k=U.findIndex(e[A],n);if(k>=0){R=g?e.$path+"/"+A+"/"+k:e[A][k];}}return R;},getObject:function(M,A,Q,e){var g,R=e?undefined:null,S,i,n,N;Q=Q||"";i=Q.lastIndexOf(".");n=Q.slice(0,i);N=Q.slice(i+1);S=U.getSchema(M,n);if(S){g=S[A];if(g){g.forEach(function(t){if(t.name===N){R=e?t.$path:t;return false;}});}}return R;},getSchema:function(M,n){var S=null,e=Array.isArray(M)?M:M.getObject("/dataServices/schema");if(e){e.forEach(function(o){if(o.namespace===n){S=o;return false;}});}return S;},getV4TypesForV2Semantics:function(S,t,p,T){var R=[],o=v[S];if(o){t.split(",").forEach(function(e){var g=o.typeMapping[e];if(g){R.push(o.v4EnumType+"/"+g);}else if(q.sap.log.isLoggable(w,l)){q.sap.log.warning("Unsupported type for sap:semantics: "+e,T.name+"."+p.name,l);}});}return R.join(" ");},getValueLists:function(p){var M,n,Q,e={};for(n in p){M=c.exec(n);if(M){Q=(M[1]||"").slice(1);e[Q]=p[n];}}return e;},handleCreatableNavigationProperty:function(e,n){var C=n["sap:creatable"],g=n["sap:creatable-path"],i,N={"NavigationPropertyPath":n.name},h;if(C&&g){q.sap.log.warning("Inconsistent service","Use either 'sap:creatable' or 'sap:creatable-path' at navigation property "+"'"+e.entityType+"/"+n.name+"'",l);C="false";g=undefined;}if(C==="false"||g){i=e["Org.OData.Capabilities.V1.InsertRestrictions"]=e["Org.OData.Capabilities.V1.InsertRestrictions"]||{};h=i["NonInsertableNavigationProperties"]=i["NonInsertableNavigationProperties"]||[];if(g){N={"If":[{"Not":{"Path":g}},N]};}h.push(N);}},handleXableAndXablePath:function(o,e,t,T,p){var g=p.toLowerCase(),h;if(t!=="EntitySet"){return;}if(o["sap:"+g]&&o["sap:"+g+"-path"]){q.sap.log.warning("Inconsistent service","Use either 'sap:"+g+"' or 'sap:"+g+"-path'"+" at entity set '"+o.name+"'",l);h=b;}else if(g!==e.name){h={"Path":e.value};}else if(e.value==="false"){h=b;}if(h){o[T]=o[T]||{};o[T][p]=h;}},liftSAPData:function(o,t){if(!o.extensions){return;}o.extensions.forEach(function(e){if(e.namespace==="http://www.sap.com/Protocols/SAPData"){o["sap:"+e.name]=e.value;U.addV4Annotation(o,e,t);}});switch(t){case"Property":if(o["sap:updatable"]==="false"){if(o["sap:creatable"]==="false"){o["Org.OData.Core.V1.Computed"]=B;}else{o["Org.OData.Core.V1.Immutable"]=B;}}break;case"EntitySet":if(o["sap:searchable"]!=="true"){o["Org.OData.Capabilities.V1.SearchRestrictions"]={"Searchable":b};}break;default:}},merge:function(A,D,M){var S=D.dataServices.schema;if(!S){return;}S.forEach(function(o,i){delete o.annotations;U.liftSAPData(o);o.$path="/dataServices/schema/"+i;q.extend(o,A[o.namespace]);U.visitParents(o,A,"association",function(e,C){U.visitChildren(e.end,C);});U.visitParents(o,A,"complexType",function(C,e){U.visitChildren(C.property,e,"Property");U.addSapSemantics(C);});U.visitParents(o,A,"entityType",U.visitEntityType);U.visitParents(o,A,"entityContainer",function(e,C){U.visitChildren(e.associationSet,C);U.visitChildren(e.entitySet,C,"EntitySet",S);U.visitChildren(e.functionImport,C,"",null,U.visitParameters.bind(this,A,o,e));});});U.addUnitAnnotations(S,M);},visitChildren:function(C,e,t,S,g,i){if(!C){return;}if(i){C=C.slice(i);}C.forEach(function(o){U.liftSAPData(o,t);});C.forEach(function(o){var E;if(t==="EntitySet"){E=U.getObject(S,"entityType",o.entityType);U.calculateEntitySetAnnotations(o,E);}if(g){g(o);}q.extend(o,e[o.name||o.role]);});},visitEntityType:function(e,C){U.visitChildren(e.property,C,"Property");U.visitChildren(e.navigationProperty,C);U.addSapSemantics(e);},visitParameters:function(A,S,e,F){var g;if(!F.parameter){return;}g=U.getChildAnnotations(A,S.namespace+"."+e.name,true);F.parameter.forEach(function(p){U.liftSAPData(p);q.extend(p,g[F.name+"/"+p.name]);});},visitParents:function(S,A,e,C,i){var p=S[e];function g(P,j){var Q=S.namespace+"."+P.name,h=U.getChildAnnotations(A,Q,e==="entityContainer");U.liftSAPData(P);P.namespace=S.namespace;P.$path=S.$path+"/"+e+"/"+j;C(P,h);q.extend(P,A[Q]);}if(!p){return;}if(i!==undefined){g(p[i],i);}else{p.forEach(g);}}};return U;},false);
sap.ui.predefine('sap/ui/model/odata/type/Boolean',['jquery.sap.global','sap/ui/core/Core','sap/ui/model/FormatException','sap/ui/model/odata/type/ODataType','sap/ui/model/ParseException','sap/ui/model/ValidateException'],function(q,C,F,O,P,V){"use strict";
function g(){return a("EnterYesOrNo",[b(true),b(false)]);}
function a(k,p){return sap.ui.getCore().getLibraryResourceBundle().getText(k,p);}
function b(v){return a(v?"YES":"NO");}
function s(t,c){var n=c&&c.nullable;t.oConstraints=undefined;if(n===false||n==="false"){t.oConstraints={nullable:false};}else if(n!==undefined&&n!==true&&n!=="true"){q.sap.log.warning("Illegal nullable: "+n,null,t.getName());}}
var E=O.extend("sap.ui.model.odata.type.Boolean",{constructor:function(f,c){O.apply(this,arguments);s(this,c);}});
E.prototype.formatValue=function(v,t){if(v===null||v===undefined){return null;}switch(this.getPrimitiveType(t)){case"any":case"boolean":return v;case"string":return b(v);default:throw new F("Don't know how to format "+this.getName()+" to "+t);}};
E.prototype.parseValue=function(v,S){var c;if(v===null||v===""){return null;}switch(this.getPrimitiveType(S)){case"boolean":return v;case"string":c=v.trim().toLowerCase();if(c===b(true).toLowerCase()){return true;}if(c===b(false).toLowerCase()){return false;}throw new P(g());default:throw new P("Don't know how to parse "+this.getName()+" from "+S);}};
E.prototype.validateValue=function(v){if(v===null){if(this.oConstraints&&this.oConstraints.nullable===false){throw new V(g());}return;}if(typeof v!=="boolean"){throw new V("Illegal "+this.getName()+" value: "+v);}};
E.prototype.getName=function(){return"sap.ui.model.odata.type.Boolean";};
return E;});
sap.ui.predefine('sap/ui/model/odata/type/Byte',['sap/ui/model/odata/type/Int'],function(I){"use strict";var r={minimum:0,maximum:255};
var B=I.extend("sap.ui.model.odata.type.Byte",{constructor:function(){I.apply(this,arguments);}});
B.prototype.getName=function(){return"sap.ui.model.odata.type.Byte";};
B.prototype.getRange=function(){return r;};
return B;});
sap.ui.predefine('sap/ui/model/odata/type/Date',['jquery.sap.global','sap/ui/core/format/DateFormat','sap/ui/model/FormatException','sap/ui/model/odata/type/ODataType','sap/ui/model/ParseException','sap/ui/model/ValidateException'],function(q,D,F,O,P,V){"use strict";var r=/\d{4}-(?:0[1-9]|1[0-2])-(?:0[1-9]|[12]\d|3[01])/,d="2014-11-27",m;
function g(t){return sap.ui.getCore().getLibraryResourceBundle().getText("EnterDate",[t.formatValue(d,"string")]);}
function a(t){var f;if(!t.oFormat){f=q.extend({strictParsing:true},t.oFormatOptions);f.UTC=true;t.oFormat=D.getDateInstance(f);}return t.oFormat;}
function b(){if(!m){m=D.getDateInstance({pattern:'yyyy-MM-dd',strictParsing:true,UTC:true});}return m;}
function s(t,c){var n=c&&c.nullable;t.oConstraints=undefined;if(n===false||n==="false"){t.oConstraints={nullable:false};}else if(n!==undefined&&n!==true&&n!=="true"){q.sap.log.warning("Illegal nullable: "+n,null,t.getName());}}
var E=O.extend("sap.ui.model.odata.type.Date",{constructor:function(f,c){O.apply(this,arguments);this.oFormatOptions=f;s(this,c);}});
E.prototype._handleLocalizationChange=function(){this.oFormat=null;};
E.prototype.formatValue=function(v,t){var o;if(v===undefined||v===null){return null;}switch(this.getPrimitiveType(t)){case"any":return v;case"string":o=b().parse(v);return o?a(this).format(o):v;default:throw new F("Don't know how to format "+this.getName()+" to "+t);}};
E.prototype.getModelFormat=function(){return b();};
E.prototype.getName=function(){return"sap.ui.model.odata.type.Date";};
E.prototype.parseValue=function(v,S){var R;if(v===""||v===null){return null;}switch(this.getPrimitiveType(S)){case"string":R=a(this).parse(v);if(!R){throw new P(g(this));}return b().format(R);default:throw new P("Don't know how to parse "+this.getName()+" from "+S);}};
E.prototype.validateValue=function(v){if(v===null){if(this.oConstraints&&this.oConstraints.nullable===false){throw new V(g(this));}return;}else if(typeof v!=="string"||!r.test(v)){throw new V("Illegal "+this.getName()+" value: "+v);}};
return E;});
sap.ui.predefine('sap/ui/model/odata/type/DateTime',['jquery.sap.global','sap/ui/model/odata/type/DateTimeBase'],function(q,D){"use strict";
function a(t,c){var A={};if(c){switch(c.displayFormat){case"Date":A.isDateOnly=true;break;case undefined:break;default:q.sap.log.warning("Illegal displayFormat: "+c.displayFormat,null,t.getName());}A.nullable=c.nullable;}return A;}
var b=D.extend("sap.ui.model.odata.type.DateTime",{constructor:function(f,c){D.call(this,f,a(this,c));}});
b.prototype.getName=function(){return"sap.ui.model.odata.type.DateTime";};
return b;});
sap.ui.predefine('sap/ui/model/odata/type/DateTimeBase',["jquery.sap.global","sap/ui/core/format/DateFormat","sap/ui/model/FormatException","sap/ui/model/odata/type/ODataType","sap/ui/model/ParseException","sap/ui/model/ValidateException"],function(q,D,F,O,P,V){"use strict";var d=new Date(2014,10,27,13,47,26);
function i(t){return t.oConstraints&&t.oConstraints.isDateOnly;}
function g(t){return sap.ui.getCore().getLibraryResourceBundle().getText(i(t)?"EnterDate":"EnterDateTime",[t.formatValue(d,"string")]);}
function a(t){var f;if(!t.oFormat){f=q.extend({strictParsing:true},t.oFormatOptions);if(i(t)){f.UTC=true;t.oFormat=D.getDateInstance(f);}else{t.oFormat=D.getDateTimeInstance(f);}}return t.oFormat;}
function s(t,c){var p;t.oConstraints=undefined;if(c){switch(c.nullable){case undefined:case true:case"true":break;case false:case"false":t.oConstraints=t.oConstraints||{};t.oConstraints.nullable=false;break;default:q.sap.log.warning("Illegal nullable: "+c.nullable,null,t.getName());}if(c.isDateOnly===true){t.oConstraints=t.oConstraints||{};t.oConstraints.isDateOnly=true;}p=c.precision;if(p!==undefined){if(p===Math.floor(p)&&p>=1&&p<=12){t.oConstraints=t.oConstraints||{};t.oConstraints.precision=p;}else if(p!==0){q.sap.log.warning("Illegal precision: "+p,null,t.getName());}}}t._handleLocalizationChange();}
var b=O.extend("sap.ui.model.odata.type.DateTimeBase",{
constructor:function(f,c){O.apply(this,arguments);s(this,c);this.oFormat=null;this.oFormatOptions=f;},
metadata:{"abstract":true}
});
b.prototype.formatValue=function(v,t){if(v===null||v===undefined){return null;}switch(this.getPrimitiveType(t)){case"any":return v;case"string":return a(this).format(v);default:throw new F("Don't know how to format "+this.getName()+" to "+t);}};
b.prototype.parseValue=function(v,S){var r;if(v===null||v===""){return null;}switch(this.getPrimitiveType(S)){case"string":r=a(this).parse(v);if(!r){throw new P(g(this));}return r;default:throw new P("Don't know how to parse "+this.getName()+" from "+S);}};
b.prototype._handleLocalizationChange=function(){this.oFormat=null;};
b.prototype.validateValue=function(v){if(v===null){if(this.oConstraints&&this.oConstraints.nullable===false){throw new V(g(this));}return;}else if(v instanceof Date){return;}throw new V("Illegal "+this.getName()+" value: "+v);};
return b;});
sap.ui.predefine('sap/ui/model/odata/type/DateTimeOffset',["jquery.sap.global","sap/ui/core/format/DateFormat","sap/ui/model/FormatException","sap/ui/model/odata/type/DateTimeBase"],function(q,D,F,a){"use strict";
var b=a.extend("sap.ui.model.odata.type.DateTimeOffset",{constructor:function(f,c){var v;a.call(this,f,{nullable:c?c.nullable:undefined,precision:c?c.precision:undefined});this.rDateTimeOffset=undefined;this.bV4=false;if(c){v=c.V4;if(v===true){this.bV4=true;}else if(v!==undefined&&v!==false){q.sap.log.warning("Illegal V4: "+v,null,this.getName());}}}});
function g(t){var p="yyyy-MM-dd'T'HH:mm:ss",P;if(!t.oModelFormat){P=t.oConstraints&&t.oConstraints.precision;if(P){p+="."+q.sap.padRight("","S",P);}t.oModelFormat=D.getDateInstance({pattern:p+"X",strictParsing:true,UTC:t.oFormatOptions&&t.oFormatOptions.UTC});}return t.oModelFormat;}
b.prototype.formatValue=function(v,t){var d;if(typeof v==="string"&&this.getPrimitiveType(t)==="string"){d=g(this).parse(v);if(!d){throw new F("Illegal "+this.getName()+" value: "+v);}v=d;}return a.prototype.formatValue.call(this,v,t);};
b.prototype.getModelFormat=function(){if(this.bV4){return g(this);}return a.prototype.getModelFormat.call(this);};
b.prototype.getName=function(){return"sap.ui.model.odata.type.DateTimeOffset";};
b.prototype.parseValue=function(v,s){var r=a.prototype.parseValue.call(this,v,s);return this.bV4&&r!==null?g(this).format(r):r;};
b.prototype.setV4=function(){this.bV4=true;return this;};
b.prototype.validateValue=function(v){var p;if(this.bV4){if(typeof v==="string"){if(!this.rDateTimeOffset){p=this.oConstraints&&this.oConstraints.precision;this.rDateTimeOffset=new RegExp("^"+"\\d{4}-(?:0[1-9]|1[0-2])-(?:0[1-9]|[12]\\d|3[01])"+"T"+"(?:[01]\\d|2[0-3]):[0-5]\\d(?::[0-5]\\d"+(p?"(\\.\\d{1,"+p+"})?":"")+")?"+"(?:Z|[-+](?:0\\d|1[0-3]):[0-5]\\d|[-+]14:00)$","i");}if(this.rDateTimeOffset.test(v)){return;}}else if(v){v=v.toString();}}a.prototype.validateValue.call(this,v);};
return b;});
sap.ui.predefine('sap/ui/model/odata/type/Decimal',['jquery.sap.global','sap/ui/core/format/NumberFormat','sap/ui/model/FormatException',"sap/ui/model/odata/ODataUtils",'sap/ui/model/odata/type/ODataType','sap/ui/model/ParseException','sap/ui/model/ValidateException'],function(q,N,F,B,O,P,V){"use strict";var r=/^[-+]?(\d+)(?:\.(\d+))?$/;
function g(t){var f,S;if(!t.oFormat){f={groupingEnabled:true,maxIntegerDigits:Infinity};S=a(t);if(S!==Infinity){f.minFractionDigits=f.maxFractionDigits=S;}f=q.extend(f,t.oFormatOptions);f.parseAsString=true;t.oFormat=N.getFloatInstance(f);}return t.oFormat;}
function a(t){return(t.oConstraints&&t.oConstraints.scale)||0;}
function b(k,p){return sap.ui.getCore().getLibraryResourceBundle().getText(k,p);}
function s(t,c){var n,p,v,S,d;function l(j,k){q.sap.log.warning("Illegal "+k+": "+j,null,t.getName());}function e(j,k,m,o){var u=typeof j==="string"?parseInt(j,10):j;if(u===undefined){return k;}if(typeof u!=="number"||isNaN(u)||u<m){l(j,o);return k;}return u;}function f(j,k){if(j){if(j.match(r)){return j;}l(j,k);}}function h(j,k){if(j===true||j==="true"){return true;}if(j!==undefined&&j!==false&&j!=="false"){l(j,k);}}function i(j,k,m){if(k!==m){t.oConstraints=t.oConstraints||{};t.oConstraints[j]=k;}}t.oConstraints=undefined;if(c){n=c.nullable;v=c.precision;d=c.scale;S=d==="variable"?Infinity:e(d,0,0,"scale");p=e(v,Infinity,1,"precision");if(S!==Infinity&&p<=S){q.sap.log.warning("Illegal scale: must be less than precision (precision="+v+", scale="+d+")",null,t.getName());S=Infinity;}i("precision",p,Infinity);i("scale",S,0);if(n===false||n==="false"){i("nullable",false,true);}else if(n!==undefined&&n!==true&&n!=="true"){l(n,"nullable");}i("minimum",f(c.minimum,"minimum"));i("minimumExclusive",h(c.minimumExclusive,"minimumExclusive"));i("maximum",f(c.maximum,"maximum"));i("maximumExclusive",h(c.maximumExclusive,"maximumExclusive"));}t._handleLocalizationChange();}
var D=O.extend("sap.ui.model.odata.type.Decimal",{constructor:function(f,c){O.apply(this,arguments);this.oFormatOptions=f;s(this,c);}});
D.prototype.formatValue=function(v,t){if(v===null||v===undefined){return null;}switch(this.getPrimitiveType(t)){case"any":return v;case"float":return parseFloat(v);case"int":return Math.floor(parseFloat(v));case"string":return g(this).format(v);default:throw new F("Don't know how to format "+this.getName()+" to "+t);}};
D.prototype.parseValue=function(v,S){var R;if(v===null||v===""){return null;}switch(this.getPrimitiveType(S)){case"string":R=g(this).parse(v);if(!R){throw new P(sap.ui.getCore().getLibraryResourceBundle().getText("EnterNumber"));}if(R.indexOf(".")>=0){R=R.replace(/0+$/,"").replace(/\.$/,"");}break;case"int":case"float":R=N.getFloatInstance({maxIntegerDigits:Infinity,decimalSeparator:".",groupingEnabled:false}).format(v);break;default:throw new P("Don't know how to parse "+this.getName()+" from "+S);}return R;};
D.prototype._handleLocalizationChange=function(){this.oFormat=null;};
D.prototype.validateValue=function(v){var f,i,m,M,c,d,e,p,S;if(v===null&&(!this.oConstraints||this.oConstraints.nullable!==false)){return;}if(typeof v!=="string"){throw new V(b("EnterNumber"));}m=r.exec(v);if(!m){throw new V(b("EnterNumber"));}i=m[1].length;f=(m[2]||"").length;S=a(this);p=(this.oConstraints&&this.oConstraints.precision)||Infinity;d=this.oConstraints&&this.oConstraints.minimum;M=this.oConstraints&&this.oConstraints.maximum;if(f>S){if(S===0){throw new V(b("EnterInt"));}else if(i+S>p){throw new V(b("EnterNumberIntegerFraction",[p-S,S]));}throw new V(b("EnterNumberFraction",[S]));}if(S===Infinity){if(i+f>p){throw new V(b("EnterNumberPrecision",[p]));}}else if(i>p-S){throw new V(b("EnterNumberInteger",[p-S]));}if(d){e=this.oConstraints&&this.oConstraints.minimumExclusive;if(B.compare(d,v,true)>=(e?0:1)){throw new V(b(e?"EnterNumberMinExclusive":"EnterNumberMin",[this.formatValue(d,"string")]));}}if(M){c=this.oConstraints&&this.oConstraints.maximumExclusive;if(B.compare(M,v,true)<=(c?0:-1)){throw new V(b(c?"EnterNumberMaxExclusive":"EnterNumberMax",[this.formatValue(M,"string")]));}}};
D.prototype.getName=function(){return"sap.ui.model.odata.type.Decimal";};
return D;});
sap.ui.predefine('sap/ui/model/odata/type/Double',['jquery.sap.global','sap/ui/core/format/NumberFormat','sap/ui/model/FormatException','sap/ui/model/odata/type/ODataType','sap/ui/model/ParseException','sap/ui/model/ValidateException'],function(q,N,F,O,P,V){"use strict";
function g(){return sap.ui.getCore().getLibraryResourceBundle().getText("EnterNumber");}
function a(t){var f;if(!t.oFormat){f=q.extend({groupingEnabled:true},t.oFormatOptions);t.oFormat=N.getFloatInstance(f);}return t.oFormat;}
function i(t){return!t.oConstraints||t.oConstraints.nullable!==false;}
function s(t,c){var n=c&&c.nullable;t.oConstraints=undefined;if(n===false||n==="false"){t.oConstraints={nullable:false};}else if(n!==undefined&&n!==true&&n!=="true"){q.sap.log.warning("Illegal nullable: "+n,null,t.getName());}t._handleLocalizationChange();}
var D=O.extend("sap.ui.model.odata.type.Double",{constructor:function(f,c){O.apply(this,arguments);this.oFormatOptions=f;s(this,c);}});
D.prototype.formatValue=function(v,t){var f,b;if(v===null||v===undefined){return null;}b=typeof v!=="number"?parseFloat(v):v;switch(this.getPrimitiveType(t)){case"any":return v;case"float":return b;case"int":return Math.floor(b);case"string":if(b&&(Math.abs(b)>=1e15||Math.abs(b)<1e-4)){f=a(this).oFormatOptions;return b.toExponential().replace("e","\u00a0E").replace(".",f.decimalSeparator).replace("+",f.plusSign).replace("-",f.minusSign);}return a(this).format(b);default:throw new F("Don't know how to format "+this.getName()+" to "+t);}};
D.prototype.parseValue=function(v,S){var r;if(v===null||v===""){return null;}switch(this.getPrimitiveType(S)){case"string":r=a(this).parse(v);if(isNaN(r)){throw new P(g());}break;case"int":case"float":r=v;break;default:throw new P("Don't know how to parse "+this.getName()+" from "+S);}return r;};
D.prototype._handleLocalizationChange=function(){this.oFormat=null;};
D.prototype.validateValue=function(v){if(v===null&&i(this)){return;}if(typeof v==="number"){return;}throw new V(g());};
D.prototype.getName=function(){return"sap.ui.model.odata.type.Double";};
return D;});
sap.ui.predefine('sap/ui/model/odata/type/Guid',['jquery.sap.global','sap/ui/model/FormatException','sap/ui/model/odata/type/ODataType','sap/ui/model/ParseException','sap/ui/model/ValidateException'],function(q,F,O,P,V){"use strict";var r=/[-\s]/g,a=/^[A-F0-9]{8}-([A-F0-9]{4}-){3}[A-F0-9]{12}$/i;
function g(){return sap.ui.getCore().getLibraryResourceBundle().getText("EnterGuid");}
function s(t,c){var n=c&&c.nullable;t.oConstraints=undefined;if(n===false||n==="false"){t.oConstraints={nullable:false};}else if(n!==undefined&&n!==true&&n!=="true"){q.sap.log.warning("Illegal nullable: "+n,null,t.getName());}}
var E=O.extend("sap.ui.model.odata.type.Guid",{constructor:function(f,c){O.apply(this,arguments);s(this,c);}});
E.prototype.formatValue=function(v,t){if(v===undefined||v===null){return null;}switch(this.getPrimitiveType(t)){case"any":case"string":return v;default:throw new F("Don't know how to format "+this.getName()+" to "+t);}};
E.prototype.getName=function(){return"sap.ui.model.odata.type.Guid";};
E.prototype.parseValue=function(v,S){var R;if(v===""||v===null){return null;}if(this.getPrimitiveType(S)!=="string"){throw new P("Don't know how to parse "+this.getName()+" from "+S);}R=v.replace(r,'');if(R.length!==32){return v;}R=R.slice(0,8)+'-'+R.slice(8,12)+'-'+R.slice(12,16)+'-'+R.slice(16,20)+'-'+R.slice(20);return R.toUpperCase();};
E.prototype.validateValue=function(v){if(v===null){if(this.oConstraints&&this.oConstraints.nullable===false){throw new V(g());}return;}if(typeof v!=="string"){throw new V("Illegal "+this.getName()+" value: "+v);}if(!a.test(v)){throw new V(g());}};
return E;});
sap.ui.predefine('sap/ui/model/odata/type/Int',['jquery.sap.global','sap/ui/core/format/NumberFormat','sap/ui/model/FormatException','sap/ui/model/odata/type/ODataType','sap/ui/model/ParseException','sap/ui/model/ValidateException'],function(q,N,F,O,P,V){"use strict";
function g(t){var f;if(!t.oFormat){f=q.extend({groupingEnabled:true},t.oFormatOptions);t.oFormat=N.getIntegerInstance(f);}return t.oFormat;}
function a(k,p){return sap.ui.getCore().getLibraryResourceBundle().getText(k,p);}
function s(t,c){var n=c&&c.nullable;t.oConstraints=undefined;switch(n){case false:case"false":t.oConstraints={nullable:false};break;case true:case"true":case undefined:break;default:q.sap.log.warning("Illegal nullable: "+n,null,t.getName());}t._handleLocalizationChange();}
var I=O.extend("sap.ui.model.odata.type.Int",{
constructor:function(f,c){O.apply(this,arguments);this.oFormatOptions=f;s(this,c);},
metadata:{"abstract":true}
});
I.prototype._handleLocalizationChange=function(){this.oFormat=null;};
I.prototype.formatValue=function(v,t){if(v===undefined||v===null){return null;}switch(this.getPrimitiveType(t)){case"string":return g(this).format(v);case"int":return Math.floor(v);case"float":case"any":return v;default:throw new F("Don't know how to format "+this.getName()+" to "+t);}};
I.prototype.parseValue=function(v,S){var r;if(v===null||v===""){return null;}switch(this.getPrimitiveType(S)){case"string":r=g(this).parse(v);if(isNaN(r)){throw new P(a("EnterInt"));}return r;case"float":return Math.floor(v);case"int":return v;default:throw new P("Don't know how to parse "+this.getName()+" from "+S);}};
I.prototype.validateValue=function(v){var r=this.getRange();if(v===null){if(this.oConstraints&&this.oConstraints.nullable===false){throw new V(a("EnterInt"));}return;}if(typeof v!=="number"){throw new V(v+" (of type "+typeof v+") is not a valid "+this.getName()+" value");}if(Math.floor(v)!==v){throw new V(a("EnterInt"));}if(v<r.minimum){throw new V(a("EnterNumberMin",[this.formatValue(r.minimum,"string")]));}if(v>r.maximum){throw new V(a("EnterNumberMax",[this.formatValue(r.maximum,"string")]));}};
return I;});
sap.ui.predefine('sap/ui/model/odata/type/Int16',['sap/ui/model/odata/type/Int'],function(I){"use strict";var r={minimum:-32768,maximum:32767};
var a=I.extend("sap.ui.model.odata.type.Int16",{constructor:function(){I.apply(this,arguments);}});
a.prototype.getName=function(){return"sap.ui.model.odata.type.Int16";};
a.prototype.getRange=function(){return r;};
return a;});
sap.ui.predefine('sap/ui/model/odata/type/Int32',['sap/ui/model/odata/type/Int'],function(I){"use strict";var r={minimum:-2147483648,maximum:2147483647};
var a=I.extend("sap.ui.model.odata.type.Int32",{constructor:function(){I.apply(this,arguments);}});
a.prototype.getName=function(){return"sap.ui.model.odata.type.Int32";};
a.prototype.getRange=function(){return r;};
return a;});
sap.ui.predefine('sap/ui/model/odata/type/Int64',['jquery.sap.global','sap/ui/model/odata/type/ODataType','sap/ui/model/FormatException','sap/ui/model/ParseException','sap/ui/core/format/NumberFormat','sap/ui/model/ValidateException'],function(q,O,F,P,N,V){"use strict";var r=/^[-+]?(\d+)$/,R={minimum:"-9223372036854775808",maximum:"9223372036854775807"},s={minimum:"-9007199254740991",maximum:"9007199254740991"};
function c(t,v,R){var A,m,n;m=r.exec(v);if(m){n=v.charAt(0)==='-';A=n?R.minimum.slice(1):R.maximum;if(m[1].length<A.length){return undefined;}if(m[1].length>A.length||m[1]>A){if(n){return a("EnterNumberMin",[t.formatValue(R.minimum,"string")]);}else{return a("EnterNumberMax",[t.formatValue(R.maximum,"string")]);}}return undefined;}return a("EnterInt");}
function g(t){var f;if(!t.oFormat){f=q.extend({groupingEnabled:true},t.oFormatOptions);f.parseAsString=true;t.oFormat=N.getIntegerInstance(f);}return t.oFormat;}
function a(k,p){return sap.ui.getCore().getLibraryResourceBundle().getText(k,p);}
function i(t){return!t.oConstraints||t.oConstraints.nullable!==false;}
function b(t,C){var n=C&&C.nullable;if(n===false||n==="false"){t.oConstraints=t.oConstraints||{};t.oConstraints.nullable=false;}else if(n!==undefined&&n!==true&&n!=="true"){q.sap.log.warning("Illegal nullable: "+n,null,t.getName());}t._handleLocalizationChange();}
var I=O.extend("sap.ui.model.odata.type.Int64",{constructor:function(f,C){O.apply(this,arguments);this.oFormatOptions=f;b(this,C);}});
I.prototype.formatValue=function(v,t){var e;if(v===null||v===undefined){return null;}switch(this.getPrimitiveType(t)){case"any":return v;case"float":case"int":e=c(this,v,s);if(e){throw new F(e);}return parseInt(v,10);case"string":return g(this).format(v);default:throw new F("Don't know how to format "+this.getName()+" to "+t);}};
I.prototype.getName=function(){return"sap.ui.model.odata.type.Int64";};
I.prototype._handleLocalizationChange=function(){this.oFormat=null;};
I.prototype.parseValue=function(v,S){var d;if(v===null||v===""){return null;}switch(this.getPrimitiveType(S)){case"string":d=g(this).parse(v);if(!d){throw new P(a("EnterInt"));}break;case"int":case"float":d=N.getIntegerInstance({maxIntegerDigits:Infinity,groupingEnabled:false}).format(v);break;default:throw new P("Don't know how to parse "+this.getName()+" from "+S);}return d;};
I.prototype.validateValue=function(v){var e;if(v===null&&i(this)){return;}if(typeof v==="string"){e=c(this,v,R);if(e){throw new V(e);}return;}throw new V(a("EnterInt"));};
return I;});
sap.ui.predefine('sap/ui/model/odata/type/ODataType',['sap/ui/model/SimpleType'],function(S){"use strict";
var O=S.extend("sap.ui.model.odata.type.ODataType",{
constructor:function(f,c){},
metadata:{"abstract":true}
});
O.prototype.getInterface=function(){return this;};
O.prototype.setConstraints=function(c){};
O.prototype.setFormatOptions=function(f){};
return O;});
sap.ui.predefine('sap/ui/model/odata/type/Raw',["sap/ui/model/FormatException","sap/ui/model/odata/type/ODataType","sap/ui/model/ParseException","sap/ui/model/ValidateException"],function(F,O,P,V){"use strict";
var R=O.extend("sap.ui.model.odata.type.Raw",{constructor:function(f,c){O.apply(this,arguments);if(f!==undefined||c!==undefined||arguments.length>2){throw new Error("Unsupported arguments");}}});
R.prototype.formatValue=function(v,t){if(t==="any"){return v;}throw new F("Type 'sap.ui.model.odata.type.Raw' does not support formatting");};
R.prototype.getName=function(){return"sap.ui.model.odata.type.Raw";};
R.prototype.parseValue=function(){throw new P("Type 'sap.ui.model.odata.type.Raw' does not support parsing");};
R.prototype.validateValue=function(){throw new V("Type 'sap.ui.model.odata.type.Raw' does not support validating");};
return R;});
sap.ui.predefine('sap/ui/model/odata/type/SByte',['sap/ui/model/odata/type/Int'],function(I){"use strict";var r={minimum:-128,maximum:127};
var S=I.extend("sap.ui.model.odata.type.SByte",{constructor:function(){I.apply(this,arguments);}});
S.prototype.getName=function(){return"sap.ui.model.odata.type.SByte";};
S.prototype.getRange=function(){return r;};
return S;});
sap.ui.predefine('sap/ui/model/odata/type/Single',['jquery.sap.global','sap/ui/core/format/NumberFormat','sap/ui/model/FormatException','sap/ui/model/odata/type/ODataType','sap/ui/model/ParseException','sap/ui/model/ValidateException'],function(q,N,F,O,P,V){"use strict";if(!Math.fround){var a=new window.Float32Array(1);Math.fround=function(v){a[0]=v;return a[0];};}
function g(){return sap.ui.getCore().getLibraryResourceBundle().getText("EnterNumber");}
function b(t){var f;if(!t.oFormat){f=q.extend({groupingEnabled:true},t.oFormatOptions);t.oFormat=N.getFloatInstance(f);}return t.oFormat;}
function i(t){return!t.oConstraints||t.oConstraints.nullable!==false;}
function s(t,c){var n=c&&c.nullable;t.oConstraints=undefined;if(n===false||n==="false"){t.oConstraints={nullable:false};}else if(n!==undefined&&n!==true&&n!=="true"){q.sap.log.warning("Illegal nullable: "+n,null,t.getName());}t._handleLocalizationChange();}
var S=O.extend("sap.ui.model.odata.type.Single",{constructor:function(f,c){O.apply(this,arguments);this.oFormatOptions=f;s(this,c);}});
S.prototype.formatValue=function(v,t){var f;if(v===null||v===undefined){return null;}f=typeof v!=="number"?parseFloat(v):v;switch(this.getPrimitiveType(t)){case"any":return v;case"float":return f;case"int":return Math.floor(f);case"string":return b(this).format(parseFloat(f.toPrecision(7)));default:throw new F("Don't know how to format "+this.getName()+" to "+t);}};
S.prototype.parseValue=function(v,c){var r;if(v===null||v===""){return null;}switch(this.getPrimitiveType(c)){case"string":r=b(this).parse(v);if(isNaN(r)){throw new P(g());}break;case"int":case"float":r=v;break;default:throw new P("Don't know how to parse "+this.getName()+" from "+c);}return Math.fround(r);};
S.prototype._handleLocalizationChange=function(){this.oFormat=null;};
S.prototype.validateValue=function(v){if(v===null&&i(this)){return;}if(typeof v==="number"){return;}throw new V(g());};
S.prototype.getName=function(){return"sap.ui.model.odata.type.Single";};
return S;});
sap.ui.predefine('sap/ui/model/odata/type/String',['jquery.sap.global','sap/ui/model/FormatException','sap/ui/model/odata/type/ODataType','sap/ui/model/ParseException','sap/ui/model/ValidateException','sap/ui/model/type/String'],function(q,F,O,P,V,S){"use strict";var r=/^\d+$/,a=/^0*(?=\d)/,z="00000000000000000000000000000000000000000000000000000000000000000000000000000000";
function f(v,l){if(v.length>=l){return v;}while(z.length<l){z=z+z;}return z.slice(0,l-v.length)+v;}
function i(v,c){return c&&c.isDigitSequence&&v&&v.match(r);}
function s(t,c){var I,m,n;t.oConstraints=undefined;if(c){m=c.maxLength;if(typeof m==="string"){m=parseInt(m,10);}if(typeof m==="number"&&!isNaN(m)&&m>0){t.oConstraints={maxLength:m};}else if(m!==undefined){q.sap.log.warning("Illegal maxLength: "+c.maxLength,null,t.getName());}I=c.isDigitSequence;if(I===true||I==="true"){t.oConstraints=t.oConstraints||{};t.oConstraints.isDigitSequence=true;}else if(I!==undefined&&I!==false&&I!=="false"){q.sap.log.warning("Illegal isDigitSequence: "+I,null,t.getName());}n=c.nullable;if(n===false||n==="false"){t.oConstraints=t.oConstraints||{};t.oConstraints.nullable=false;}else if(n!==undefined&&n!==true&&n!=="true"){q.sap.log.warning("Illegal nullable: "+n,null,t.getName());}}}
var E=O.extend("sap.ui.model.odata.type.String",{constructor:function(o,c){O.apply(this,arguments);s(this,c);}});
E.prototype.formatValue=function(v,t){if(v===null&&this.getPrimitiveType(t)==="string"){return"";}if(i(v,this.oConstraints)){v=v.replace(a,"");}return S.prototype.formatValue.call(this,v,t);};
E.prototype.parseValue=function(v,b){var R;R=v===""?null:S.prototype.parseValue.apply(this,arguments);if(i(R,this.oConstraints)){R=R.replace(a,"");if(this.oConstraints.maxLength){R=f(R,this.oConstraints.maxLength);}}return R;};
E.prototype.validateValue=function(v){var c=this.oConstraints||{},m=c.maxLength;if(v===null){if(c.nullable!==false){return;}}else if(typeof v!=="string"){throw new V("Illegal "+this.getName()+" value: "+v);}else if(c.isDigitSequence){if(!v.match(r)){throw new V(sap.ui.getCore().getLibraryResourceBundle().getText("EnterDigitsOnly"));}if(m&&v.length>m){throw new V(sap.ui.getCore().getLibraryResourceBundle().getText("EnterMaximumOfDigits",[m]));}return;}else if(!m||v.length<=m){return;}throw new V(sap.ui.getCore().getLibraryResourceBundle().getText(m?"EnterTextMaxLength":"EnterText",[m]));};
E.prototype.getName=function(){return"sap.ui.model.odata.type.String";};
return E;});
sap.ui.predefine('sap/ui/model/odata/type/Time',['jquery.sap.global','sap/ui/core/format/DateFormat','sap/ui/model/FormatException','sap/ui/model/odata/type/ODataType','sap/ui/model/ParseException','sap/ui/model/ValidateException'],function(q,D,F,O,P,V){"use strict";var d={__edmType:"Edm.Time",ms:49646000},m={format:b,parse:t};
function g(o){return sap.ui.getCore().getLibraryResourceBundle().getText("EnterTime",[o.formatValue(d,"string")]);}
function a(o){var f;if(!o.oFormat){f=q.extend({strictParsing:true},o.oFormatOptions);f.UTC=true;o.oFormat=D.getTimeInstance(f);}return o.oFormat;}
function i(o){return typeof o==="object"&&o.__edmType==="Edm.Time"&&typeof o.ms==="number";}
function s(o,C){var n=C&&C.nullable;o.oConstraints=undefined;if(n===false||n==="false"){o.oConstraints={nullable:false};}else if(n!==undefined&&n!==true&&n!=="true"){q.sap.log.warning("Illegal nullable: "+n,null,o.getName());}}
function t(o){if(!i(o)){throw new F("Illegal sap.ui.model.odata.type.Time value: "+c(o));}return new Date(o.ms);}
function b(o){return{__edmType:"Edm.Time",ms:((o.getUTCHours()*60+o.getUTCMinutes())*60+o.getUTCSeconds())*1000+o.getUTCMilliseconds()};}
function c(v){try{return JSON.stringify(v);}catch(e){return String(v);}}
var T=O.extend("sap.ui.model.odata.type.Time",{constructor:function(f,C){O.apply(this,arguments);s(this,C);this.oFormatOptions=f;}});
T.prototype.formatValue=function(v,e){if(v===undefined||v===null){return null;}switch(this.getPrimitiveType(e)){case"any":return v;case"string":return a(this).format(t(v));default:throw new F("Don't know how to format "+this.getName()+" to "+e);}};
T.prototype.getModelFormat=function(){return m;};
T.prototype.getName=function(){return"sap.ui.model.odata.type.Time";};
T.prototype.parseValue=function(v,S){var o;if(v===""||v===null){return null;}if(this.getPrimitiveType(S)!=="string"){throw new P("Don't know how to parse "+this.getName()+" from "+S);}o=a(this).parse(v);if(!o){throw new P(g(this));}return b(o);};
T.prototype.validateValue=function(v){if(v===null){if(this.oConstraints&&this.oConstraints.nullable===false){throw new V(g(this));}return;}if(!i(v)){throw new V("Illegal "+this.getName()+" value: "+c(v));}};
T.prototype._handleLocalizationChange=function(){this.oFormat=null;};
return T;});
sap.ui.predefine('sap/ui/model/odata/type/TimeOfDay',["jquery.sap.global","jquery.sap.strings","sap/ui/core/format/DateFormat","sap/ui/model/FormatException","sap/ui/model/ParseException","sap/ui/model/ValidateException","sap/ui/model/odata/type/ODataType"],function(q,Q,D,F,P,V,O){"use strict";
function g(t){return sap.ui.getCore().getLibraryResourceBundle().getText("EnterTime",[t.formatValue("13:47:26","string")]);}
function a(t){var p="HH:mm:ss",i;if(!t.oModelFormat){i=t.oConstraints&&t.oConstraints.precision;if(i){p+="."+q.sap.padRight("","S",i);}t.oModelFormat=D.getTimeInstance({pattern:p,strictParsing:true,UTC:true});}return t.oModelFormat;}
function b(t){var f;if(!t.oUiFormat){f=q.extend({strictParsing:true},t.oFormatOptions);f.UTC=true;t.oUiFormat=D.getTimeInstance(f);}return t.oUiFormat;}
function s(t,c){var n=c&&c.nullable,p=c&&c.precision;t.oConstraints=undefined;if(n===false){t.oConstraints={nullable:false};}else if(n!==undefined&&n!==true){q.sap.log.warning("Illegal nullable: "+n,null,t.getName());}if(p===Math.floor(p)&&p>0&&p<=12){t.oConstraints=t.oConstraints||{};t.oConstraints.precision=p;}else if(p!==undefined&&p!==0){q.sap.log.warning("Illegal precision: "+p,null,t.getName());}}
var T=O.extend("sap.ui.model.odata.type.TimeOfDay",{constructor:function(f,c){O.apply(this,arguments);this.oModelFormat=undefined;this.rTimeOfDay=undefined;this.oUiFormat=undefined;s(this,c);this.oFormatOptions=f;}});
T.prototype._handleLocalizationChange=function(){this.oUiFormat=null;};
T.prototype.formatValue=function(v,t){var d,i;if(v===undefined||v===null){return null;}switch(this.getPrimitiveType(t)){case"any":return v;case"string":i=v.indexOf(".");if(i>=0){v=v.slice(0,i+4);}d=a(this).parse(v);if(d){return b(this).format(d);}throw new F("Illegal "+this.getName()+" value: "+v);default:throw new F("Don't know how to format "+this.getName()+" to "+t);}};
T.prototype.getModelFormat=function(){return a(this);};
T.prototype.getName=function(){return"sap.ui.model.odata.type.TimeOfDay";};
T.prototype.parseValue=function(v,S){var d;if(v===""||v===null){return null;}if(this.getPrimitiveType(S)!=="string"){throw new P("Don't know how to parse "+this.getName()+" from "+S);}d=b(this).parse(v);if(!d){throw new P(g(this));}return a(this).format(d);};
T.prototype.validateValue=function(v){var p;if(v===null){if(this.oConstraints&&this.oConstraints.nullable===false){throw new V(g(this));}return;}if(!this.rTimeOfDay){p=this.oConstraints&&this.oConstraints.precision;this.rTimeOfDay=new RegExp("^(?:[01]\\d|2[0-3]):[0-5]\\d(?::[0-5]\\d"+(p?"(\\.\\d{1,"+p+"})?":"")+")?$");}if(!this.rTimeOfDay.test(v)){throw new V("Illegal sap.ui.model.odata.type.TimeOfDay value: "+v);}};
return T;});
sap.ui.predefine('sap/ui/model/odata/v2/BatchMode',function(){"use strict";var B={None:"None",Group:"Group"};return B;},true);
sap.ui.predefine('sap/ui/model/odata/v2/ODataAnnotations',['jquery.sap.global','sap/ui/model/odata/AnnotationParser','sap/ui/Device','sap/ui/base/EventProvider'],function(q,A,D,E){"use strict";
function a(p){return p.catch(function(e){return e;});}
function c(){return this;}
var O=E.extend("sap.ui.model.odata.v2.ODataAnnotations",{
constructor:function(m,o){E.apply(this,[o]);this._oMetadata=m;this._pReadyToParseNext=m.loaded();this._pLoaded=m.loaded();this._mCustomHeaders={};this._mAnnotations={};if(!o||!o.skipMetadata){if(!o){o={};}if(!o.source){o.source=[];}else if(Array.isArray(o.source)){o.source=o.source.slice(0);}else{o.source=[o.source];}o.source.unshift({type:"xml",data:m.loaded().then(function(p){return{xml:p["metadataString"],lastModified:p["lastModified"]};})});}if(o){this.setHeaders(o.headers);this.addSource(o.source);}},
metadata:{publicMethods:["getData","addSource","getHeaders","setHeaders","attachSuccess","detachSuccess","attachError","detachError","attachLoaded","detachLoaded","attachFailed","detachFailed"]}
});
O.prototype.getData=function(){return this._mAnnotations;};
O.prototype.getAnnotationsData=function(){return this._mAnnotations;};
O.prototype.getHeaders=function(){return q.extend({},this._mCustomHeaders,{"Accept-Language":sap.ui.getCore().getConfiguration().getLanguageTag()});};
O.prototype.setHeaders=function(h){this._mCustomHeaders=q.extend({},h);};
O.prototype.loaded=function(){return this._pLoaded;};
O.prototype.addSource=function(s){if(!s||Array.isArray(s)&&s.length===0){return this._pReadyToParseNext.then(function(){return[];});}if(!Array.isArray(s)){s=[s];}var S=s.map(function(v){return(typeof v==="string")?{type:"url",data:v}:v;});var b=S.map(this._loadSource.bind(this));var m=[];var p=this._pReadyToParseNext;for(var i=0;i<b.length;++i){var d=b[i];p=p.then(c.bind(d)).then(this._parseSourceXML.bind(this)).then(this._parseSource.bind(this)).then(this._mergeSource.bind(this));p.then(this._fireSuccess.bind(this));p.catch(this._fireError.bind(this));m.push(p);p=a(p);}var e=this._promiseFinally(m);var f=this._promiseFinally(m,true);e.then(this._fireLoaded.bind(this),this._fireFailed.bind(this));f.then(this._fireSomeLoaded.bind(this),this._fireAllFailed.bind(this));this._pLoaded=f;this._pReadyToParseNext=a(e);return e;};
O.prototype.attachSuccess=function(d,f,l){return this.attachEvent("success",d,f,l);};
O.prototype.detachSuccess=function(f,l){return this.detachEvent("success",f,l);};
O.prototype.attachError=function(d,f,l){return this.attachEvent("error",d,f,l);};
O.prototype.detachError=function(f,l){return this.detachEvent("error",f,l);};
O.prototype.attachLoaded=function(d,f,l){return this.attachEvent("loaded",d,f,l);};
O.prototype.detachLoaded=function(f,l){return this.detachEvent("loaded",f,l);};
O.prototype.attachFailed=function(d,f,l){return this.attachEvent("failed",d,f,l);};
O.prototype.detachFailed=function(f,l){return this.detachEvent("failed",f,l);};
O.prototype.attachSomeLoaded=function(d,f,l){return this.attachEvent("someLoaded",d,f,l);};
O.prototype.detachSomeLoaded=function(f,l){return this.detachEvent("someLoaded",f,l);};
O.prototype.attachAllFailed=function(d,f,l){return this.attachEvent("allFailed",d,f,l);};
O.prototype.detachAllFailed=function(f,l){return this.detachEvent("allFailed",f,l);};
O.prototype._fireSuccess=function(r){return this.fireEvent("success",{result:r},false,false);};
O.prototype._fireError=function(e){return this.fireEvent("error",{result:e},false,false);};
O.prototype._fireLoaded=function(r){return this.fireEvent("loaded",{result:r},false,false);};
O.prototype._fireFailed=function(e){return this.fireEvent("failed",{result:e},false,false);};
O.prototype._fireSomeLoaded=function(r){return this.fireEvent("someLoaded",{result:r},false,false);};
O.prototype._fireAllFailed=function(e){return this.fireEvent("allFailed",{result:e},false,false);};
O.prototype._loadSource=function(s){if(s.data instanceof Promise){return s.data.then(function(d){delete s.data;s.type="xml";s.xml=d.xml;s.lastModified=d.lastModified;return this._loadSource(s);}.bind(this));}else if(s.type==="xml"){if(typeof s.data==="string"){s.xml=s.data;delete s.data;}return Promise.resolve(s);}else if(s.type==="url"){return this._loadUrl(s);}else{return Promise.reject({error:new Error("Unknown source type: \""+s.type+"\""),source:s});}};
O.prototype._loadUrl=function(s){return new Promise(function(r,R){var m={url:s.data,async:true,headers:this.getHeaders(),beforeSend:function(x){x.overrideMimeType("text/plain");}};var S=function(d,b,x){s.xml=x.responseText;if(x.getResponseHeader("Last-Modified")){s.lastModified=new Date(x.getResponseHeader("Last-Modified"));}r(s);};var f=function(x,b){var e=new Error("Could not load annotation URL: \""+s.data+"\"");e.source=s;R(e);};q.ajax(m).done(S).fail(f);}.bind(this));};
O.prototype._parseSourceXML=function(s){return new Promise(function(r,R){var x;if(D.browser.msie){x=new window.ActiveXObject("Microsoft.XMLDOM");x.preserveWhiteSpace=true;var X=s.xml;if(X.indexOf(" xmlns:xml=")>-1){X=X.replace(' xmlns:xml="http://www.w3.org/XML/1998/namespace"',"").replace(" xmlns:xml='http://www.w3.org/XML/1998/namespace'","");}x.loadXML(X);}else if(window.DOMParser){x=new DOMParser().parseFromString(s.xml,'application/xml');}var e;if(!x){e=new Error("The browser does not support XML parsing. Annotations are not available.");e.source=s;R(e);}else if(x.getElementsByTagName("parsererror").length>0||(x.parseError&&x.parseError.errorCode!==0)){e=new Error("There were errors parsing the XML.");e.source={type:s.type,data:s.data,xml:s.xml,document:x};R(e);}else{s.document=x;r(s);}});};
O.prototype._parseSource=function(s){s.annotations=A.parse(this._oMetadata,s.document);return Promise.resolve(s);};
O.prototype._mergeSource=function(s){A.merge(this._mAnnotations,s.annotations);return Promise.resolve(s);};
O.prototype._promiseFinally=function(p,f){return new Promise(function(r,R){var b=true;var d=true;var P=p.length;var e=[];var C=function(){if(e.length===P){e.annotations=this.getData();if(b||(f&&!d)){r(e);}else{R(e);}}}.bind(this);function o(g,h){b=g?false:b;d=!g?false:d;e.push(h);C();}for(var i=0;i<P;++i){p[i].then(o.bind(this,false));p[i].catch(o.bind(this,true));}}.bind(this));};
return O;});
sap.ui.predefine('sap/ui/model/odata/v2/ODataContextBinding',['jquery.sap.global','sap/ui/model/ContextBinding','sap/ui/model/ChangeReason'],function(q,C,a){"use strict";
var O=C.extend("sap.ui.model.odata.v2.ODataContextBinding",{constructor:function(m,p,c,P,e){C.call(this,m,p,c,P,e);this.bRefreshGroupId=undefined;}});
O.prototype.initialize=function(){var t=this,r,c=this.isRelative()&&this.oContext&&this.oContext.bCreated,R;if(!this.oModel.oMetadata.isLoaded()||!this.bInitial){return;}this.bInitial=false;r=this.oModel.resolve(this.sPath,this.oContext);if(!r||c){this.oElementContext=null;this._fireChange({reason:a.Context});return;}R=this.oModel._isReloadNeeded(r,this.mParameters);if(R){this.fireDataRequested();}this.oModel.createBindingContext(this.sPath,this.oContext,this.mParameters,function(o){var d;t.oElementContext=o;t._fireChange({reason:a.Context});if(R){if(t.oElementContext){d=t.oElementContext.getObject(t.mParameters);}t.oModel.callAfterUpdate(function(){t.fireDataReceived({data:d});});}},R);};
O.prototype.checkUpdate=function(f){var c;if(this.bInitial){return;}c=this.oModel.createBindingContext(this.sPath,this.oContext,this.mParameters);if(c&&c!==this.oElementContext){this.oElementContext=c;this._fireChange({reason:a.Context});}};
O.prototype.refresh=function(f,g){if(typeof f==="string"){g=f;f=false;}this.sRefreshGroup=g;this._refresh(f);this.sRefreshGroup=undefined;};
O.prototype._refresh=function(f,c){var t=this,d,k,s,b=false,p=this.mParameters,e=this.isRelative()&&this.oContext&&this.oContext.bCreated,r=this.oModel.resolve(this.sPath,this.oContext);if(this.bInitial||e){return;}if(c){s=this.oModel._getObject(this.sPath,this.oContext);if(s){k=this.oModel._getKey(s);if(k in c){b=true;}}}else{b=true;}if(f||b){if(r){this.fireDataRequested();}if(this.sRefreshGroup){p=q.extend({},this.mParameters);p.groupId=this.sRefreshGroup;}this.oModel.createBindingContext(this.sPath,this.oContext,p,function(o){if(t.oElementContext===o){if(f){t._fireChange({reason:a.Context});}}else{t.oElementContext=o;t._fireChange({reason:a.Context});}if(t.oElementContext){d=t.oElementContext.getObject(t.mParameters);}if(r){t.oModel.callAfterUpdate(function(){t.fireDataReceived({data:d});});}},true);}};
O.prototype.setContext=function(c){var t=this,d,r,d,b=c&&c.bCreated,R;if(this.oContext!==c){this.oContext=c;if(this.bInitial||!this.isRelative()){return;}r=this.oModel.resolve(this.sPath,this.oContext);if(!r||b){if(this.oElementContext!==null){this.oElementContext=null;this._fireChange({reason:a.Context});}return;}d=this.oModel._getObject(this.sPath,this.oContext);R=this.oModel._isReloadNeeded(r,this.mParameters);if(R){this.fireDataRequested();}this.oModel.createBindingContext(this.sPath,this.oContext,this.mParameters,function(c){t.oElementContext=c;t._fireChange({reason:a.Context});if(r&&R){if(t.oElementContext){d=t.oElementContext.getObject(t.mParameters);}t.oModel.callAfterUpdate(function(){t.fireDataReceived({data:d});});}},R);}};
return O;});
sap.ui.predefine('sap/ui/model/odata/v2/ODataListBinding',['jquery.sap.global','sap/ui/model/FilterType','sap/ui/model/ListBinding','sap/ui/model/odata/ODataUtils','sap/ui/model/odata/CountMode','sap/ui/model/odata/Filter','sap/ui/model/odata/OperationMode','sap/ui/model/ChangeReason','sap/ui/model/Filter','sap/ui/model/FilterProcessor','sap/ui/model/Sorter','sap/ui/model/SorterProcessor'],function(q,F,L,O,C,a,b,c,d,e,S,f){"use strict";
var g=L.extend("sap.ui.model.odata.v2.ODataListBinding",{
constructor:function(m,p,o,s,h,P){L.apply(this,arguments);this.sFilterParams=null;this.sSortParams=null;this.sRangeParams=null;this.sCustomParams=this.oModel.createCustomParams(this.mParameters);this.iStartIndex=0;this.iLength=0;this.bPendingChange=false;this.aAllKeys=null;this.aKeys=[];this.sCountMode=(P&&P.countMode)||this.oModel.sDefaultCountMode;this.sOperationMode=(P&&P.operationMode)||this.oModel.sDefaultOperationMode;this.bRefresh=false;this.bNeedsUpdate=false;this.bDataAvailable=false;this.bIgnoreSuspend=false;this.bPendingRefresh=false;this.sGroupId=undefined;this.sRefreshGroupId=undefined;this.bLengthRequested=false;this.bUseExtendedChangeDetection=true;this.bFaultTolerant=P&&P.faultTolerant;this.bLengthFinal=false;this.iLastEndIndex=0;this.aLastContexts=null;this.aLastContextData=null;this.bInitial=true;this.mRequestHandles={};this.oCountHandle=null;this.bSkipDataEvents=false;this.bUseExpandedList=false;this.oModel.checkFilterOperation(this.aApplicationFilters);if(P&&(P.batchGroupId||P.groupId)){this.sGroupId=P.groupId||P.batchGroupId;}this.iThreshold=(P&&P.threshold)||0;this.bThresholdRejected=false;if(this.sCountMode==C.None){this.bThresholdRejected=true;}var u=this.checkExpandedList();if(!u){this.resetData();}},
metadata:{publicMethods:["getLength"]}
});
g.prototype.getContexts=function(s,l,t){if(this.bInitial){return[];}if(!this.bLengthFinal&&this.sOperationMode==b.Auto&&(this.sCountMode==C.Request||this.sCountMode==C.Both)){if(!this.bLengthRequested){this._getLength();this.bLengthRequested=true;}return[];}if(!this.bLengthFinal&&!this.bPendingRequest&&!this.bLengthRequested){this._getLength();this.bLengthRequested=true;}this.iLastLength=l;this.iLastStartIndex=s;this.iLastThreshold=t;if(!s){s=0;}if(!l){l=this.oModel.iSizeLimit;if(this.bLengthFinal&&this.iLength<l){l=this.iLength;}}if(!t){t=0;}if(this.sOperationMode==b.Auto){if(this.iThreshold>=0){t=Math.max(this.iThreshold,t);}}var h=true,j=this._getContexts(s,l),k=[],o;if(this.useClientMode()){if(!this.aAllKeys&&!this.bPendingRequest&&this.oModel.getServiceMetadata()){this.loadData();j.dataRequested=true;}}else{o=this.calculateSection(s,l,t,j);h=j.length!==l&&!(this.bLengthFinal&&j.length>=this.iLength-s);if(this.oModel.getServiceMetadata()){if(!this.bPendingRequest&&o.length>0&&(h||l<o.length)){this.loadData(o.startIndex,o.length);j.dataRequested=true;}}}if(this.bRefresh){this.bRefresh=false;}else{for(var i=0;i<j.length;i++){k.push(this.getContextData(j[i]));}if(this.bUseExtendedChangeDetection){if(this.aLastContexts&&s<this.iLastEndIndex){j.diff=q.sap.arraySymbolDiff(this.aLastContextData,k);}}this.iLastEndIndex=s+l;this.aLastContexts=j.slice(0);this.aLastContextData=k.slice(0);}return j;};
g.prototype.getCurrentContexts=function(){return this.aLastContexts||[];};
g.prototype.getEntryKey=function(o){return o.getPath();};
g.prototype.getEntryData=function(o){return JSON.stringify(o.getObject(this.mParameters));};
g.prototype._getContexts=function(s,l){var h=[],o,k;if(!s){s=0;}if(!l){l=this.oModel.iSizeLimit;if(this.bLengthFinal&&this.iLength<l){l=this.iLength;}}for(var i=s;i<s+l;i++){k=this.aKeys[i];if(!k){break;}o=this.oModel.getContext('/'+k);h.push(o);}return h;};
g.prototype.calculateSection=function(s,l,t,h){var k,m,p,P,r,o={},K;m=s;k=0;for(var i=s;i>=Math.max(s-t,0);i--){K=this.aKeys[i];if(!K){P=i+1;break;}}for(var j=s+l;j<s+l+t;j++){K=this.aKeys[j];if(!K){p=j;break;}}r=s-P;if(P&&s>t&&r<t){if(h.length!==l){m=s-t;}else{m=P-t;}k=t;}m=Math.max(m,0);if(m===s){m+=h.length;}if(h.length!==l){k+=l-h.length;}r=p-s-l;if(r===0){k+=t;}if(p&&r<t&&r>0){if(m>s){m=p;k+=t;}}if(this.bLengthFinal&&this.iLength<(k+m)){k=this.iLength-m;}o.startIndex=m;o.length=k;return o;};
g.prototype.setContext=function(o){var r,h=o&&o.bCreated;if(this.oContext!==o){this.oContext=o;if(this.bInitial||!this.isRelative()){return;}r=this.oModel.resolve(this.sPath,this.oContext);if(!r||h){if(this.aAllKeys||this.aKeys.length>0||this.iLength>0){this.aAllKeys=null;this.aKeys=[];this.iLength=0;this.bLengthFinal=true;this._fireChange({reason:c.Context});}return;}this._initSortersFilters();if(this.checkExpandedList()){this._fireChange({reason:c.Context});}else{this._refresh();}}};
g.prototype.checkExpandedList=function(s){var r=!!this.oModel.resolve(this.sPath,this.oContext),R=this.oModel._getObject(this.sPath,this.oContext);if(!r||R===undefined||(this.sOperationMode===b.Server&&(this.aApplicationFilters.length>0||this.aFilters.length>0||this.aSorters.length>0))){this.bUseExpandedList=false;this.aExpandRefs=undefined;return false;}else{this.bUseExpandedList=true;this.aExpandRefs=R;if(Array.isArray(R)){if(!s&&(this.oModel._isReloadNeeded("/"+R[0],this.mParameters)||this.oModel._isReloadNeeded("/"+R[R.length-1],this.mParameters))){this.bUseExpandedList=false;this.aExpandRefs=undefined;return false;}this.aAllKeys=R;this.iLength=R.length;this.bLengthFinal=true;this.bDataAvailable=true;this.applyFilter();this.applySort();}else{this.aAllKeys=null;this.aKeys=[];this.iLength=0;this.bLengthFinal=true;this.bDataAvailable=true;}return true;}};
g.prototype.updateExpandedList=function(k){if(this.aExpandRefs){for(var i=0;i<k.length;i++){this.aExpandRefs[i]=k[i];}this.aExpandRefs.length=k.length;}};
g.prototype.useClientMode=function(){return(this.sOperationMode===b.Client||this.sOperationMode===b.Auto&&!this.bThresholdRejected||this.sOperationMode!==b.Server&&this.bUseExpandedList);};
g.prototype.loadData=function(s,l){var t=this,I=false,G=q.sap.uid(),h;if(s||l){this.sRangeParams="$skip="+s+"&$top="+l;this.iStartIndex=s;}else{s=this.iStartIndex;}var p=[];if(this.sRangeParams&&!this.useClientMode()){p.push(this.sRangeParams);}if(this.sSortParams){p.push(this.sSortParams);}if(this.sFilterParams&&!this.useClientMode()){p.push(this.sFilterParams);}if(this.sCustomParams){p.push(this.sCustomParams);}if(this.sCountMode==C.InlineRepeat||!this.bLengthFinal&&(this.sCountMode===C.Inline||this.sCountMode===C.Both)){p.push("$inlinecount=allpages");I=true;}function j(D){if(I&&D.__count){t.iLength=parseInt(D.__count,10);t.bLengthFinal=true;if(t.sOperationMode==b.Auto){if(t.iLength<=t.mParameters.threshold){t.bThresholdRejected=false;}else{t.bThresholdRejected=true;delete t.mRequestHandles[G];t.bPendingRequest=false;t.bNeedsUpdate=true;return;}}}if(t.useClientMode()){t.aKeys=[];q.each(D.results,function(i,k){t.aKeys[i]=t.oModel._getKey(k);});t.updateExpandedList(t.aKeys);t.aAllKeys=t.aKeys.slice();t.iLength=t.aKeys.length;t.bLengthFinal=true;t.applyFilter();t.applySort();}else{if(D.results.length>0){q.each(D.results,function(i,k){t.aKeys[s+i]=t.oModel._getKey(k);});if(t.iLength<s+D.results.length){t.iLength=s+D.results.length;t.bLengthFinal=false;}if(!D.__next&&(D.results.length<l||l===undefined)){t.iLength=s+D.results.length;t.bLengthFinal=true;}}else{if(t.bFaultTolerant&&D.__next){t.iLength=s;t.bLengthFinal=true;}if(s===0){t.iLength=0;t.aKeys=[];t.bLengthFinal=true;}if(s===t.iLength){t.bLengthFinal=true;}}}delete t.mRequestHandles[G];t.bPendingRequest=false;t.bNeedsUpdate=true;t.bIgnoreSuspend=true;t.oModel.callAfterUpdate(function(){t.fireDataReceived({data:D});});}function E(i){var A=i.statusCode==0;delete t.mRequestHandles[G];t.bPendingRequest=false;if(t.bFaultTolerant){t.iLength=t.aKeys.length;t.bLengthFinal=true;t.bDataAvailable=true;}else if(!A){t.aKeys=[];t.aAllKeys=[];t.iLength=0;t.bLengthFinal=true;t.bDataAvailable=true;t._fireChange({reason:c.Change});}if(!t.bSkipDataEvents){t.fireDataReceived();}}var P=this.sPath,o=this.oContext;if(this.isRelative()){P=this.oModel.resolve(P,o);}if(P){this.bPendingRequest=true;if(!this.bSkipDataEvents){this.fireDataRequested();}this.bSkipDataEvents=false;h=this.sRefreshGroup?this.sRefreshGroup:this.sGroupId;this.mRequestHandles[G]=this.oModel.read(P,{groupId:h,urlParameters:p,success:j,error:E});}};
g.prototype.isLengthFinal=function(){return this.bLengthFinal;};
g.prototype.getLength=function(){if(this.bLengthFinal||this.iLength==0){return this.iLength;}else{var A=this.iLastThreshold||this.iLastLength||10;return this.iLength+A;}};
g.prototype._getLength=function(){var t=this;var G;if(this.sCountMode!==C.Request&&this.sCountMode!==C.Both){return;}var p=[];if(this.sFilterParams&&this.sOperationMode!=b.Auto){p.push(this.sFilterParams);}if(this.mParameters&&this.mParameters.custom){var o={custom:{}};q.each(this.mParameters.custom,function(s,v){o.custom[s]=v;});p.push(this.oModel.createCustomParams(o));}function _(D){t.iLength=parseInt(D,10);t.bLengthFinal=true;t.bLengthRequested=true;t.oCountHandle=null;if(t.sOperationMode==b.Auto){if(t.iLength<=t.mParameters.threshold){t.bThresholdRejected=false;}else{t.bThresholdRejected=true;}t._fireChange({reason:c.Change});}}function h(E){delete t.mRequestHandles[P];var s="Request for $count failed: "+E.message;if(E.response){s+=", "+E.response.statusCode+", "+E.response.statusText+", "+E.response.body;}q.sap.log.warning(s);}var P=this.oModel.resolve(this.sPath,this.oContext);if(P){P=P+"/$count";G=this.sRefreshGroup?this.sRefreshGroup:this.sGroupId;this.oCountHandle=this.oModel.read(P,{withCredentials:this.oModel.bWithCredentials,groupId:G,urlParameters:p,success:_,error:h});}};
g.prototype.refresh=function(h,G){if(typeof h==="string"){G=h;h=false;}this.sRefreshGroup=G;this._refresh(h);this.sRefreshGroup=undefined;};
g.prototype._refresh=function(h,m,E){var j=false,k=this.isRelative()&&this.oContext&&this.oContext.bCreated;if(k){return;}this.bPendingRefresh=false;if(!h){if(E){var r=this.oModel.resolve(this.sPath,this.oContext);if(r){var o=this.oModel.oMetadata._getEntityTypeByPath(r);if(o&&(o.entityType in E)){j=true;}}}if(m&&!j){q.each(this.aKeys,function(i,K){if(K in m){j=true;return false;}});}if(!m&&!E){j=true;}}if(h||j){if(this.bSuspended&&!this.bIgnoreSuspend&&!h){this.bPendingRefresh=true;return;}this.abortPendingRequest(true);this.resetData();this._fireRefresh({reason:c.Refresh});}};
g.prototype._fireRefresh=function(p){if(this.oModel.resolve(this.sPath,this.oContext)){this.bRefresh=true;this.fireEvent("refresh",p);}};
g.prototype.initialize=function(){var h=this.isRelative()&&this.oContext&&this.oContext.bCreated;if(this.oModel.oMetadata&&this.oModel.oMetadata.isLoaded()&&this.bInitial&&!h){this.bInitial=false;this._initSortersFilters();if(!this.bSuspended){if(this.bDataAvailable){this._fireChange({reason:c.Change});}else{this._fireRefresh({reason:c.Refresh});}}}return this;};
g.prototype.checkUpdate=function(h,m){var j=this.sChangeReason?this.sChangeReason:c.Change,k=false,o,t=this,l;if(this.bSuspended&&!this.bIgnoreSuspend&&!h){return false;}this.bIgnoreSuspend=false;if(this.bPendingRequest){return;}if(!h&&!this.bNeedsUpdate){l=this.aExpandRefs;this.checkExpandedList(true);if(!q.sap.equal(l,this.aExpandRefs)){k=true;}else if(m){q.each(this.aKeys,function(i,K){if(K in m){k=true;return false;}});}else{k=true;}if(k&&this.aLastContexts){k=false;var n=this._getContexts(this.iLastStartIndex,this.iLastLength,this.iLastThreshold);if(this.aLastContexts.length!==n.length){k=true;}else{q.each(this.aLastContextData,function(i,p){o=t.getContextData(n[i]);if(p!==o){k=true;return false;}});}}}if(h||k||this.bNeedsUpdate){this.bNeedsUpdate=false;this._fireChange({reason:j});}this.sChangeReason=undefined;};
g.prototype.resetData=function(){this.aKeys=[];this.aAllKeys=null;this.iLength=0;this.bLengthFinal=false;this.sChangeReason=undefined;this.bDataAvailable=false;this.bLengthRequested=false;this.bThresholdRejected=false;if(this.sCountMode==C.None){this.bThresholdRejected=true;}};
g.prototype.abortPendingRequest=function(A){if(!q.isEmptyObject(this.mRequestHandles)){this.bSkipDataEvents=true;q.each(this.mRequestHandles,function(p,r){r.abort();});if(A&&this.oCountHandle){this.oCountHandle.abort();}this.mRequestHandles={};this.bPendingRequest=false;}};
g.prototype.getDownloadUrl=function(s){var p=[],P;if(s){p.push("$format="+encodeURIComponent(s));}if(this.sSortParams){p.push(this.sSortParams);}if(this.sFilterParams){p.push(this.sFilterParams);}if(this.sCustomParams){p.push(this.sCustomParams);}P=this.oModel.resolve(this.sPath,this.oContext);if(P){return this.oModel._createRequestUrl(P,null,p);}};
g.prototype.sort=function(s,r){var h=false;this.bIgnoreSuspend=true;if(!s){s=[];}if(s instanceof S){s=[s];}this.aSorters=s;if(!this.useClientMode()){this.createSortParams(s);}if(!this.bInitial){this.addComparators(s);if(this.useClientMode()){if(this.aAllKeys){if(s.length==0){this.applyFilter();}else{this.applySort();}this._fireChange({reason:c.Sort});}else{this.sChangeReason=c.Sort;}}else{this.aKeys=[];this.abortPendingRequest(false);this.sChangeReason=c.Sort;this._fireRefresh({reason:this.sChangeReason});}this._fireSort({sorter:s});h=true;}if(r){return h;}else{return this;}};
g.prototype.addComparators=function(E){var p,t,o=this.oEntityType,h=this;if(!o){q.sap.log.warning("Cannot determine sort/filter comparators, as entitytype of the collection is unkown!");return;}E.forEach(function(i){if(i.aFilters){h.addComparators(i.aFilters);}else if(!i.fnCompare){p=this.oModel.oMetadata._getPropertyMetadata(o,i.sPath);t=p&&p.type;i.fnCompare=O.getComparator(t);}}.bind(this));};
g.prototype.applySort=function(){var t=this,o;this.aKeys=f.apply(this.aKeys,this.aSorters,function(r,p){o=t.oModel.getContext('/'+r);return t.oModel.getProperty(p,o);});};
g.prototype.createSortParams=function(s){this.sSortParams=O.createSortParams(s);};
g.prototype.filter=function(h,s,r){var i=false;this.bIgnoreSuspend=true;if(!h){h=[];}if(h instanceof d){h=[h];}this.oModel.checkFilterOperation(h);if(s===F.Application){this.aApplicationFilters=h;}else{this.aFilters=h;}h=this.aFilters.concat(this.aApplicationFilters);if(!h||!Array.isArray(h)||h.length===0){this.aFilters=[];this.aApplicationFilters=[];}if(!this.useClientMode()){this.createFilterParams(h);}if(!this.bInitial){this.addComparators(this.aFilters);this.addComparators(this.aApplicationFilters);if(this.useClientMode()){if(this.aAllKeys){this.applyFilter();this.applySort();this._fireChange({reason:c.Filter});}else{this.sChangeReason=c.Filter;}}else{this.resetData();this.abortPendingRequest(true);this.sChangeReason=c.Filter;this._fireRefresh({reason:this.sChangeReason});}if(s===F.Application){this._fireFilter({filters:this.aApplicationFilters});}else{this._fireFilter({filters:this.aFilters});}i=true;}if(r){return i;}else{return this;}};
g.prototype.applyFilter=function(){var t=this,o,h=this.aFilters.concat(this.aApplicationFilters),j=[];q.each(h,function(i,k){if(k instanceof a){j.push(k.convert());}else{j.push(k);}});this.aKeys=e.apply(this.aAllKeys,j,function(r,p){o=t.oModel.getContext('/'+r);return t.oModel.getProperty(p,o);});this.iLength=this.aKeys.length;};
g.prototype.createFilterParams=function(h){this.sFilterParams=O.createFilterParams(h,this.oModel.oMetadata,this.oEntityType);};
g.prototype._initSortersFilters=function(){var r=this.oModel.resolve(this.sPath,this.oContext);if(!r){return;}this.oEntityType=this._getEntityType();this.addComparators(this.aSorters);this.addComparators(this.aFilters);this.addComparators(this.aApplicationFilters);if(!this.useClientMode()){this.createSortParams(this.aSorters);this.createFilterParams(this.aFilters.concat(this.aApplicationFilters));}};
g.prototype._getEntityType=function(){var r=this.oModel.resolve(this.sPath,this.oContext);if(r){var E=this.oModel.oMetadata._getEntityTypeByPath(r);return E;}return undefined;};
g.prototype.resume=function(){this.bIgnoreSuspend=false;this.bSuspended=false;if(this.bPendingRefresh){this._refresh();}else{this.checkUpdate();}};
g.prototype.suspend=function(){if(this.bInitial){this.bPendingRefresh=true;}L.prototype.suspend.apply(this,arguments);};
return g;});
sap.ui.predefine('sap/ui/model/odata/v2/ODataModel',['jquery.sap.global','sap/ui/model/BindingMode','sap/ui/model/Context','sap/ui/model/Model','sap/ui/model/odata/v2/ODataAnnotations','sap/ui/model/odata/ODataUtils','sap/ui/model/odata/CountMode','sap/ui/model/odata/UpdateMethod','sap/ui/model/odata/OperationMode','./ODataContextBinding','./ODataListBinding','sap/ui/model/odata/ODataMetadata','sap/ui/model/odata/ODataPropertyBinding','./ODataTreeBinding','sap/ui/model/odata/ODataMetaModel','sap/ui/core/message/MessageParser','sap/ui/model/odata/ODataMessageParser','sap/ui/thirdparty/datajs'],function(q,B,C,M,O,a,b,U,c,d,e,f,g,h,l,m,o,p){"use strict";
var r=M.extend("sap.ui.model.odata.v2.ODataModel",{
constructor:function(s,P){M.apply(this,arguments);var u,i,H,t,w,j,k,R,n,L,D,v,x,y,S,z,E,J,F,G,I,K,N,Q,T,V=this;if(typeof(s)==="object"){P=s;s=P.serviceUrl;}if(P){u=P.user;i=P.password;H=P.headers;t=P.tokenHandling;w=P.withCredentials;j=P.maxDataServiceVersion;k=P.useBatch;R=P.refreshAfterChange;n=P.annotationURI;L=P.loadAnnotationsJoined;v=P.defaultBindingMode;D=P.defaultCountMode;x=P.defaultOperationMode;y=P.metadataNamespaces;S=P.serviceUrlParams;z=P.metadataUrlParams;J=P.json;F=P.messageParser;G=P.skipMetadataAnnotationParsing;I=P.defaultUpdateMethod;K=P.disableHeadRequestForToken;N=P.sequentializeRequests;Q=P.disableSoftStateHeader;T=P.bindableResponseHeaders;}this.mSupportedBindingModes={"OneWay":true,"OneTime":true,"TwoWay":true};this.mUnsupportedFilterOperators={"Any":true,"All":true};this.sDefaultBindingMode=v||B.OneWay;this.bJSON=J!==false;this.aPendingRequestHandles=[];this.aCallAfterUpdate=[];this.mRequests={};this.mDeferredRequests={};this.mChangedEntities={};this.mChangeHandles={};this.mDeferredGroups={};this.mLaunderingState={};this.sDefaultUpdateMethod=I||U.Merge;this.bTokenHandling=t!==false;this.bWithCredentials=w===true;this.bUseBatch=k!==false;this.bRefreshAfterChange=R!==false;this.sMaxDataServiceVersion=j;this.bLoadAnnotationsJoined=L!==false;this.sAnnotationURI=n;this.sDefaultCountMode=D||b.Request;this.sDefaultOperationMode=x||c.Default;this.sMetadataLoadEvent=null;this.oMetadataFailedEvent=null;this.sRefreshGroupId=undefined;this.bIncludeInCurrentBatch=false;this.bSkipMetadataAnnotationParsing=!!G;this.bDisableHeadRequestForToken=!!K;this.bSequentializeRequests=!!N;this.bDisableSoftStateHeader=!!Q;this.aBindableResponseHeaders=T?T:null;if(F){F.setProcessor(this);}this.oMessageParser=F;this.sDefaultChangeGroup="changes";this.setDeferredGroups([this.sDefaultChangeGroup]);this.setChangeGroups({"*":{groupId:this.sDefaultChangeGroup}});this.oData={};this.oMetadata=null;this.oAnnotations=null;this.aUrlParams=[];this.pSequentialRequestCompleted=Promise.resolve();this.pReadyForRequest=Promise.resolve();this.sServiceUrl=s;var W=s.split("?");if(W.length>1){this.sServiceUrl=W[0];if(W[1]){this.aUrlParams.push(W[1]);}}this.sServiceUrl=this.sServiceUrl.replace(/\/$/,"");this.sUser=u;this.sPassword=i;if(sap.ui.getCore().getConfiguration().getStatistics()){this.aUrlParams.push("sap-statistics=true");}this.oHeaders={};this.setHeaders(H);if(!this.bDisableSoftStateHeader){this.oHeaders["sap-contextid-accept"]="header";this.mCustomHeaders["sap-contextid-accept"]="header";}E=a._createUrlParamsArray(z);var X=this._createRequestUrl("/$metadata",undefined,E);this.oServiceData=r.mServiceData[X];if(!this.oServiceData){r.mServiceData[X]={};this.oServiceData=r.mServiceData[X];}if(!this.oServiceData.oMetadata||this.oServiceData.oMetadata.bFailed){this.oMetadata=new f(X,{async:true,user:this.sUser,password:this.sPassword,headers:this.mCustomHeaders,namespaces:y,withCredentials:this.bWithCredentials});this.oServiceData.oMetadata=this.oMetadata;}else{this.oMetadata=this.oServiceData.oMetadata;}this.oAnnotations=new O(this.oMetadata,{source:this.sAnnotationURI,skipMetadata:this.bSkipMetadataAnnotationParsing,headers:this.mCustomHeaders,combineEvents:true});if(!this.bDisableSoftStateHeader){delete this.mCustomHeaders["sap-contextid-accept"];}this.oAnnotations.attachAllFailed(this.onAnnotationsFailed,this);this.oAnnotations.attachSomeLoaded(this.onAnnotationsLoaded,this);this.pAnnotationsLoaded=this.oAnnotations.loaded();if(S){this.aUrlParams=this.aUrlParams.concat(a._createUrlParamsArray(S));}this.onMetadataFailed=function(Y){V.fireMetadataFailed(Y.getParameters());};this.oMetadata.loaded().then(this._initializeMetadata.bind(this));if(!this.oMetadata.isLoaded()){this.oMetadata.attachFailed(this.onMetadataFailed);}if(this.bJSON){if(this.sMaxDataServiceVersion==="3.0"){this.oHeaders["Accept"]="application/json;odata=fullmetadata";}else{this.oHeaders["Accept"]="application/json";}}else{this.oHeaders["Accept"]="application/atom+xml,application/atomsvc+xml,application/xml";}if(this.bTokenHandling&&this.oServiceData.securityToken){this.oHeaders["x-csrf-token"]=this.oServiceData.securityToken;}this.oHeaders["Accept-Language"]=sap.ui.getCore().getConfiguration().getLanguageTag();this.oHeaders["DataServiceVersion"]="2.0";this.oHeaders["MaxDataServiceVersion"]="2.0";if(this.sMaxDataServiceVersion){this.oHeaders["MaxDataServiceVersion"]=this.sMaxDataServiceVersion;}this.oHeaders["sap-cancel-on-close"]=true;},
metadata:{publicMethods:["read","create","update","remove","submitChanges","getServiceMetadata","metadataLoaded","hasPendingChanges","getPendingChanges","refresh","refreshMetadata","resetChanges","setDefaultCountMode","setDefaultBindingMode","getDefaultBindingMode","getDefaultCountMode","setProperty","getSecurityToken","refreshSecurityToken","setHeaders","getHeaders","setUseBatch","setDeferredBatchGroups","getDeferredBatchGroups","setChangeBatchGroups","getChangeBatchGroups"]}
});
r.M_EVENTS={MetadataLoaded:"metadataLoaded",MetadataFailed:"metadataFailed",AnnotationsLoaded:"annotationsLoaded",AnnotationsFailed:"annotationsFailed",BatchRequestFailed:"batchRequestFailed",BatchRequestSent:"batchRequestSent",BatchRequestCompleted:"batchRequestCompleted"};
r.prototype.attachBatchRequestFailed=function(D,F,L){this.attachEvent("batchRequestFailed",D,F,L);return this;};
r.prototype.detachBatchRequestFailed=function(F,L){this.detachEvent("batchRequestFailed",F,L);return this;};
r.prototype.fireBatchRequestFailed=function(i){this.fireEvent("batchRequestFailed",i);return this;};
r.prototype.attachBatchRequestSent=function(D,F,L){this.attachEvent("batchRequestSent",D,F,L);return this;};
r.prototype.detachBatchRequestSent=function(F,L){this.detachEvent("batchRequestSent",F,L);return this;};
r.prototype.fireBatchRequestSent=function(i){this.fireEvent("batchRequestSent",i);return this;};
r.prototype.attachBatchRequestCompleted=function(D,F,L){this.attachEvent("batchRequestCompleted",D,F,L);return this;};
r.prototype.detachBatchRequestCompleted=function(F,L){this.detachEvent("batchRequestCompleted",F,L);return this;};
r.prototype.fireBatchRequestCompleted=function(i){this.fireEvent("batchRequestCompleted",i);return this;};
r.mServiceData={};
r.prototype._initializeMetadata=function(){if(this.bDestroyed){return;}var F=function(){this.fireMetadataLoaded({metadata:this.oMetadata});q.sap.log.debug(this+" - metadataloaded fired");}.bind(this);this.initialize();if(this.bLoadAnnotationsJoined){this.oAnnotations.loaded().then(F,this.fireMetadataFailed.bind(this));}else{F();}};
r.prototype.refreshMetadata=function(){if(this.oMetadata&&this.oMetadata.refresh){return this.oMetadata.refresh();}};
r.prototype.fireAnnotationsLoaded=function(i){this.fireEvent("annotationsLoaded",i);return this;};
r.prototype.attachAnnotationsLoaded=function(D,F,L){this.attachEvent("annotationsLoaded",D,F,L);return this;};
r.prototype.detachAnnotationsLoaded=function(F,L){this.detachEvent("annotationsLoaded",F,L);return this;};
r.prototype.fireAnnotationsFailed=function(i){this.fireEvent("annotationsFailed",i);q.sap.log.debug(this+" - annotationsfailed fired");return this;};
r.prototype.attachAnnotationsFailed=function(D,F,L){this.attachEvent("annotationsFailed",D,F,L);return this;};
r.prototype.detachAnnotationsFailed=function(F,L){this.detachEvent("annotationsFailed",F,L);return this;};
r.prototype.fireMetadataLoaded=function(i){this.fireEvent("metadataLoaded",i);return this;};
r.prototype.attachMetadataLoaded=function(D,F,L){this.attachEvent("metadataLoaded",D,F,L);return this;};
r.prototype.detachMetadataLoaded=function(F,L){this.detachEvent("metadataLoaded",F,L);return this;};
r.prototype.fireMetadataFailed=function(i){this.fireEvent("metadataFailed",i);return this;};
r.prototype.attachMetadataFailed=function(D,F,L){this.attachEvent("metadataFailed",D,F,L);return this;};
r.prototype.detachMetadataFailed=function(F,L){this.detachEvent("metadataFailed",F,L);return this;};
r.prototype._createEventInfo=function(R,k,n){var E={};E.url=R.requestUri;E.method=R.method;E.async=R.async;E.headers=R.headers;if(n){E.requests=[];for(var i=0;i<n.length;i++){var s={};if(Array.isArray(n[i])){var t=n[i];for(var j=0;j<t.length;j++){var R=t[j].request;var I=n[i][j].response;s={};s.url=R.requestUri;s.method=R.method;s.headers=R.headers;if(I){s.response={};if(R._aborted){s.success=false;s.response.statusCode=0;s.response.statusText="abort";}else{s.success=true;if(I.message){s.response.message=I.message;I=I.response;s.response.responseText=I.body;s.success=false;}s.response.headers=I.headers;s.response.statusCode=I.statusCode;s.response.statusText=I.statusText;}}E.requests.push(s);}}else{var R=n[i].request;var I=n[i].response;s.url=R.requestUri;s.method=R.method;s.headers=R.headers;if(I){s.response={};if(R._aborted){s.success=false;s.response.statusCode=0;s.response.statusText="abort";}else{s.success=true;if(I.message){s.response.message=I.message;I=I.response;s.response.responseText=I.body;s.success=false;}s.response.headers=I.headers;s.response.statusCode=I.statusCode;s.response.statusText=I.statusText;}}E.requests.push(s);}}}if(k){E.response={};E.success=true;if(k.message){E.response.message=k.message;E.success=false;}if(k.response){k=k.response;}if(k&&k.statusCode!=undefined){E.response.headers=k.headers;E.response.statusCode=k.statusCode;E.response.statusText=k.statusText;E.response.responseText=k.body!==undefined?k.body:k.responseText;}}E.ID=R.requestID;return E;};
r.prototype._createRequestID=function(){var R;R=q.sap.uid();return R;};
r.prototype._createRequestUrl=function(P,i,u,j){var n,k=[],s="";n=this._normalizePath(P,i);if(!j){s=this.sServiceUrl+n;}else{s=n.substr(n.indexOf('/')+1);}if(this.aUrlParams){k=k.concat(this.aUrlParams);}if(u){k=k.concat(u);}if(k&&k.length>0){s+="?"+k.join("&");}return s;};
r.prototype._importData=function(D,j,R){var t=this,L,k,n,E;if(D.results){L=[];q.each(D.results,function(i,w){var k=t._importData(w,j,R);if(k){L.push(k);}});return L;}else{k=this._getKey(D);if(!k){return k;}E=this._getEntity(k);if(!E){E=D;this._addEntity(E);}if(this.aBindableResponseHeaders){var H={};for(var s in R.headers){var u=s.toLowerCase();if(this.aBindableResponseHeaders.indexOf(u)>-1){H[u]=R.headers[s];}}if(!q.isEmptyObject(H)){if(!D.__metadata){D.__metadata={};}D.__metadata.headers=H;}}q.each(D,function(N,P){if(P&&(P.__metadata&&P.__metadata.uri||P.results)&&!P.__deferred){n=t._importData(P,j,R);if(Array.isArray(n)){E[N]={__list:n};}else{E[N]={__ref:n};}}else if(!P||!P.__deferred){E[N]=P;}});var v={};v[k]=E;this._updateChangedEntities(v);j[k]=true;return k;}};
r.prototype._removeReferences=function(D){var t=this,L;if(!D){return D;}if(D.results){L=[];q.each(D.results,function(i,j){L.push(t._removeReferences(j));});return L;}else{q.each(D,function(P,i){if(i){if(i["__ref"]||i["__list"]){delete D[P];}}});return D;}};
r.prototype._restoreReferences=function(D,v){var t=this,k,j,R;function n(k){var j=v[k];if(!j){j=t._getObject("/"+k);if(j){j=q.sap.extend(true,{},j);v[k]=j;t._restoreReferences(j,v);}}return j;}if(!v){v={};}q.each(D,function(P,s){if(s){if(s.__ref){k=s.__ref;j=n(k);if(j){D[P]=j;}delete s.__ref;}else if(s.__list){R=[];q.each(s.__list,function(i,k){j=n(k);if(j){R.push(j);}});delete s.__list;s.results=R;}}});return D;};
r.prototype.removeData=function(){this.oData={};};
r.prototype.initialize=function(){var i=this.aBindings.slice(0);i.forEach(function(j){j.initialize();});};
r.prototype.refresh=function(F,R,G){if(typeof F==="string"){G=F;F=false;R=false;}if(R){this.removeData();}this._refresh(F,G);};
r.prototype._refresh=function(F,G,i,E){var j=this.aBindings.slice(0);this.sRefreshGroupId=G;j.forEach(function(k){k._refresh(F,i,E);});this.sRefreshGroupId=undefined;};
r.prototype.checkUpdate=function(F,i,j,k){if(i){if(!this.sUpdateTimer){this.sUpdateTimer=q.sap.delayedCall(0,this,function(){this.checkUpdate(F,false,j);});}return;}if(this.sUpdateTimer){q.sap.clearDelayedCall(this.sUpdateTimer);this.sUpdateTimer=null;}var n=this.aBindings.slice(0);n.forEach(function(s){if(!k||this.isMetaModelPath(s.getPath())){s.checkUpdate(F,j);}}.bind(this));this._processAfterUpdate();};
r.prototype.checkDataState=function(L){var i=this.aBindings.slice(0);i.forEach(function(j){if(j.checkDataState){j.checkDataState(L);}});};
r.prototype.bindProperty=function(P,i,j){var k=new g(this,P,i,j);return k;};
r.prototype.bindList=function(P,i,s,F,j){var k=new e(this,P,i,s,F,j);return k;};
r.prototype.bindTree=function(P,i,F,j,s){var k=new h(this,P,i,F,j,s);return k;};
r.prototype.createBindingContext=function(P,i,j,k,R){var s=this.resolve(P,i),n,N,G,t=this;if(typeof i=="function"){R=j;k=i;j=undefined;i=undefined;}if(typeof j=="function"){R=k;k=j;j=undefined;}if(!s){if(k){k(null);}return null;}if(R===undefined){R=this._isReloadNeeded(s,j);}if(!R){n=this.resolve(P,i,true);N=this.getContext(n);if(k){k(N);}return N;}function u(D){var K=D?t._getKey(D):null,L=!(P===""||P.indexOf("/")>0),y=null,z,E;N=null;if(K){N=t.getContext('/'+K);y={__ref:K};}if(i&&I&&L){z=i.getPath();z=z.substr(1);E=t._getEntity(z);if(E){E[P]=y;}}k(N);}function v(E){var y;if(E.statusCode=='404'&&i&&I){var z=i.getPath();z=z.substr(1);y=t._getEntity(z);if(y){y[P]={__ref:null};}}k(null);}if(k){var I=!q.sap.startsWith(P,"/");if(s){var w=[],x=this.createCustomParams(j);if(x){w.push(x);}if(j&&(j.batchGroupId||j.groupId)){G=j.groupId||j.batchGroupId;}this.read(s,{groupId:G,urlParameters:w,success:u,error:v});}else{k(null);}}};
r.prototype._splitEntries=function(E){return E.replace(/\s/g,"").split(',').map(function(s){return s.split("/");});};
r.prototype._filterOwnSelect=function(s,E){var i,j;if(!E){return[];}j=E.map(function(P){return P.name;});i=s.filter(function(S){return S.length===1;}).map(function(S){return S[0];});if(s.length===0||i.indexOf("*")!==-1||i.indexOf("**")!==-1){return j;}else{return i.filter(function(S){return j.indexOf(S)!==-1;});}};
r.prototype._filterOwnExpand=function(E,s){return E.map(function(S){return S[0];}).filter(function(v,i,j){return j.indexOf(v)===i;}).filter(function(v){return s.length===0||s.some(function(S){return S.indexOf(v)===0||S.indexOf("**")===0;});});};
r.prototype._filterSelectByNavProp=function(E,n){return E.filter(function(s){return s[0]===n;}).map(function(s){return s.length>1?s.slice(1):["**"];});};
r.prototype._filterExpandByNavProp=function(E,n){return E.filter(function(s){return s.length>1&&s[0]===n;}).map(function(s){return s.slice(1);});};
r.prototype._isReloadNeeded=function(P,k){var t=this,n=this.oMetadata,E=this.oMetadata._getEntityTypeByPath(P),s=this._getObject(P),u=[],S=[];if(this._isCreatedEntity(s)){return false;}function v(E,s,S,u){var w,x,N,y,z,D,F,G,H;if(!E){return false;}if(s===null){return false;}if(!s){return true;}w=t._filterOwnSelect(S,E.property);for(var i=0;i<w.length;i++){H=w[i];if(s[H]===undefined){return true;}}x=t._filterOwnExpand(u,S);for(var i=0;i<x.length;i++){G=x[i];N=s[G];if(N===null){continue;}if(N===undefined||N.__deferred){return true;}y=n._getEntityTypeByNavProperty(E,G);D=t._filterSelectByNavProp(S,G);F=t._filterExpandByNavProp(u,G);if(N.__ref){z=t._getEntity(N.__ref);if(v(y,z,D,F)){return true;}}if(N.__list){for(var j=0;j<N.__list.length;j++){z=t._getEntity(N.__list[j]);if(v(y,z,D,F)){return true;}}}}return false;}if(k){if(k.select){S=this._splitEntries(k.select);}if(k.expand){u=this._splitEntries(k.expand);}}return v(E,s,S,u);};
r.prototype.createCustomParams=function(P){var i=[],j,s={expand:true,select:true};for(var n in P){if(n in s){i.push("$"+n+"="+q.sap.encodeURL(P[n]));}if(n==="custom"){j=P[n];for(n in j){if(n.indexOf("$")===0){q.sap.log.warning(this+" - Trying to set OData parameter '"+n+"' as custom query option!");}else if(j[n]===undefined){i.push(n);}else{i.push(n+"="+q.sap.encodeURL(j[n]));}}}}return i.join("&");};
r.prototype.bindContext=function(P,i,j){var k=new d(this,P,i,j);return k;};
r.prototype.setDefaultCountMode=function(s){this.sDefaultCountMode=s;};
r.prototype.getDefaultCountMode=function(){return this.sDefaultCountMode;};
r.prototype._addEntity=function(E){var k=this._getKey(E);this.oData[k]=E;};
r.prototype._removeEntity=function(k){k=k&&a._normalizeKey(k);delete this.oData[k];delete this.mChangedEntities[k];delete this.mContexts["/"+k];};
r.prototype._getEntity=function(k){k=k&&a._normalizeKey(k);return this.oData[k];};
r.prototype._getKey=function(v){var k,u;if(v instanceof C){k=v.getPath().substr(1);}else if(v&&v.__metadata&&v.__metadata.uri){u=v.__metadata.uri;k=u.substr(u.lastIndexOf("/")+1);}else if(typeof v==='string'){k=v.substr(v.lastIndexOf("/")+1);}return k&&a._normalizeKey(k);};
r.prototype.getKey=function(v){return this._getKey(v);};
r.prototype.createKey=function(s,k){var E=this.oMetadata._getEntityTypeByPath(s),K=s,t=this,n,P;K+="(";if(E.key.propertyRef.length===1){n=E.key.propertyRef[0].name;P=this.oMetadata._getPropertyMetadata(E,n);K+=encodeURIComponent(a.formatValue(k[n],P.type));}else{q.each(E.key.propertyRef,function(i,j){if(i>0){K+=",";}n=j.name;P=t.oMetadata._getPropertyMetadata(E,n);K+=n;K+="=";K+=encodeURIComponent(a.formatValue(k[n],P.type));});}K+=")";return K;};
r.prototype.getProperty=function(P,i,I){var v=this._getObject(P,i);if(!I){return v;}if(!q.isPlainObject(v)){return v;}v=q.sap.extend(true,{},v);if(I===true){return this._restoreReferences(v);}else{return this._removeReferences(v);}};
r.prototype.getObject=function(P,n,s){if(q.isPlainObject(n)){s=n;n=undefined;}var t=this,R=this.resolve(P,n),v=this._getObject(R),E=this.oMetadata._getEntityTypeByPath(R),u=[],S=[];if(!E||!q.isPlainObject(v)||!v.__metadata||!v.__metadata.uri){return v;}if(!s||!(s.select||s.expand)){return q.sap.extend(true,{},v);}function w(E,v,S,u){var x,y,z,D,N,F,G,H,I,J,K,L,Q;if(!v){return undefined;}if(!E){return undefined;}z=t._filterOwnSelect(S,E.property);y={};for(var i=0;i<z.length;i++){L=z[i];if(v[L]!==undefined){y[L]=v[L];}else{q.sap.log.fatal("No data loaded for select property: "+L+" of entry: "+t.getKey(v));return undefined;}}if(v.__metadata){y.__metadata=v.__metadata;}x=t._filterOwnExpand(u,S);for(var i=0;i<x.length;i++){K=x[i];N=v[K];F=t.oMetadata._getEntityTypeByNavProperty(E,K);I=t._filterSelectByNavProp(S,K);J=t._filterExpandByNavProp(u,K);if(N&&N.__ref){H=t._getObject("/"+N.__ref);G=w(F,H,I,J);if(G!==undefined){y[K]=G;}else{q.sap.log.fatal("No data loaded for expand property: "+K+" of entry: "+t.getKey(G));return undefined;}}if(N&&N.__list){Q=[];for(var j=0;j<N.__list.length;j++){H=t._getObject("/"+N.__list[j]);G=w(F,H,I,J);if(G!==undefined){Q.push(G);}else{q.sap.log.fatal("No data loaded for expand property: "+K+" of entry: "+t.getKey(G));return undefined;}}y[K]=Q;}}D=t._filterOwnSelect(S,E.navigationProperty);for(var k=0;k<D.length;k++){K=D[k];if(x.indexOf(K)===-1){var T=y.__metadata.uri+"/"+K;y[K]={__deferred:{uri:T}};}}return y;}if(s.select){S=this._splitEntries(s.select);}if(s.expand){u=this._splitEntries(s.expand);}v=w(E,v,S,u);return v;};
r.prototype._getObject=function(P,i,j){var n=this.isLegacySyntax()?this.oData:null,k,s,R=this.resolve(P,i),S,D,t,u,K,v;if(this.oMetadata&&this.oMetadata.isLoaded()&&R&&R.indexOf('/#')>-1){if(this.isMetaModelPath(R)){S=R.indexOf('/##');v=this.getMetaModel();if(!this.bMetaModelLoaded){return null;}D=R.substr(0,S);t=R.substr(S+3);u=v.getMetaContext(D);n=v.getProperty(t,u);}else{n=this.oMetadata._getAnnotation(R);}}else{if(!R){return n;}if(R==="/"){return this.oData;}var w=R.split("/"),I=0;K=w[1];w.splice(0,2);k=this.mChangedEntities[K];s=this._getEntity(K);n=j?s:k||s;while(n&&w[I]){var H=k&&k.hasOwnProperty(w[I]);k=k&&k[w[I]];s=s&&s[w[I]];n=j||!H?s:k;if(n){if(n.__ref){k=this.mChangedEntities[n.__ref];s=this._getEntity(n.__ref);n=j?s:k||s;}else if(n.__list){n=n.__list;}else if(n.__deferred){n=undefined;}}I++;}}if(q.isPlainObject(k)){n=j?s:q.sap.extend(true,{},s,k);}return n;};
r.prototype.updateSecurityToken=function(){if(this.bTokenHandling){if(!this.oServiceData.securityToken){this.refreshSecurityToken();}if(this.bTokenHandling){this.oHeaders["x-csrf-token"]=this.oServiceData.securityToken;}}};
r.prototype.resetSecurityToken=function(){delete this.oServiceData.securityToken;delete this.oHeaders["x-csrf-token"];delete this.pSecurityToken;};
r.prototype.getSecurityToken=function(){var t=this.oServiceData.securityToken;if(!t){this.refreshSecurityToken();t=this.oServiceData.securityToken;}return t;};
r.prototype.securityTokenAvailable=function(){if(!this.pSecurityToken){if(this.oServiceData.securityToken){this.pSecurityToken=Promise.resolve(this.oServiceData.securityToken);}else{this.pSecurityToken=new Promise(function(i,j){this.refreshSecurityToken(function(){i(this.oServiceData.securityToken);}.bind(this),function(){j();},true);}.bind(this));}}return this.pSecurityToken;};
r.prototype.refreshSecurityToken=function(s,E,i){var t;var j=this;var u=this._createRequestUrl("/");var T={abort:function(){this.request.abort();}};function k(D,R){if(R){t=j._getHeader("x-csrf-token",R.headers);j._setSessionContextIdHeader(j._getHeader("sap-contextid",R.headers));if(t){j.oServiceData.securityToken=t;j.pSecurityToken=Promise.resolve(t);j.oHeaders["x-csrf-token"]=t;}else{j.resetSecurityToken();j.bTokenHandling=false;}}if(s){s(D,R);}}function n(x){j.resetSecurityToken();j.bTokenHandling=false;j._handleError(x);if(E){E(x);}}function v(x){T.request=w("GET",n);}function w(R,E){var x=j._createRequest(u,R,j._getHeaders(),null,null,!!i);x.headers["x-csrf-token"]="Fetch";return j._request(x,k,E,undefined,undefined,j.getServiceMetadata());}if(this.bDisableHeadRequestForToken){T.request=w("GET",n);}else{T.request=w("HEAD",v);}return T;};
r.prototype._submitRequest=function(R,s,E){var t=this,H,j,k,n,u;n=new Promise(function(i,F){u=i;});function v(i,F){if(s){s(i,F);}u();}function w(i){if(t.bTokenHandling&&i.response){var T=t._getHeader("x-csrf-token",i.response.headers);if(!R.bTokenReset&&i.response.statusCode=='403'&&T&&T.toLowerCase()==="required"){t.resetSecurityToken();R.bTokenReset=true;y();return;}}if(E){E(i);}u();}function x(R){if(t.bTokenHandling&&R.method!=="GET"){t.pReadyForRequest=t.securityTokenAvailable();}return t.pReadyForRequest;}function y(){x(R).then(function(T){if(t.bTokenHandling&&R.method!=="GET"){R.headers["x-csrf-token"]=T;}D();},function(){D();});}function z(T,R,F){var G,I=R.eventInfo.requests;if(I){q.each(I,function(i,R){if(Array.isArray(R)){R.forEach(function(R){q.each(R.parts,function(i,P){G=t._createEventInfo(R.request,P.fnError);t["fireRequest"+T](G);});});}else{if(R.parts){q.each(R.parts,function(i,P){G=t._createEventInfo(R.request,P.fnError);t["fireRequest"+T](G);});}else{G=t._createEventInfo(R.request,R.fnError);t["fireRequest"+T](G);}}});if(R.eventInfo.batch){G=t._createEventInfo(R,F,I);t["fireBatchRequest"+T](G);}}}function D(){if(t.sSessionContextId){R.headers["sap-contextid"]=t.sSessionContextId;}j=t._request(R,v,w,H,undefined,t.getServiceMetadata());if(R.eventInfo){z("Sent",R,null);delete R.eventInfo;}if(k){j.abort();}}H=t._getODataHandler(R.requestUri);if(this.bSequentializeRequests){this.pSequentialRequestCompleted.then(function(){y();});this.pSequentialRequestCompleted=n;}else{y();}return{abort:function(){if(j){j.abort();}k=true;}};};
r.prototype._setSessionContextIdHeader=function(s){if(s){this.sSessionContextId=s;}};
r.prototype._submitSingleRequest=function(R){var t=this,j,k={},G={},E={};function n(D,u){if(D===undefined&&u.statusCode===200){s({message:"Response did not contain a valid OData result",response:u});return;}function v(D,u){for(var i=0;i<R.parts.length;i++){if(R.parts[i].request._aborted){t._processAborted(R.parts[i].request,u);}else if(R.parts[i].fnSuccess){R.parts[i].fnSuccess(D,u);}}if(R.request.requestUri.indexOf("$count")===-1){t.checkUpdate(false,false,G);if(R.bRefreshAfterChange){t._refresh(false,undefined,k,E);}}}t._processSuccess(R.request,u,v,G,k,E);t._setSessionContextIdHeader(t._getHeader("sap-contextid",u.headers));}function s(u){if(u.message=="Request aborted"){for(var i=0;i<R.parts.length;i++){t._processAborted(R.parts[i].request,u);}}else{for(var i=0;i<R.parts.length;i++){t._processError(R.parts[i].request,u,R.parts[i].fnError);}}t._processAfterUpdate();}R.request.eventInfo={requests:R.parts,batch:false};j=this._submitRequest(R.request,n,s);return j;};
r.prototype._submitBatchRequest=function(k,R,s,E){var t=this,n={},G={},u={};function v(j,F,H){for(var i=0;i<j.parts.length;i++){if(H||j.parts[i].request._aborted){t._processAborted(j.parts[i].request,F);}else if(F.message){t._processError(j.parts[i].request,F,j.parts[i].fnError);}else{t._processSuccess(j.parts[i].request,F,j.parts[i].fnSuccess,G,n,u);}}}function w(F,H){if(F===undefined&&H.statusCode===200){x({message:"Response did not contain a valid OData batch result",response:H});return;}var I,J,K,L=F.__batchResponses;if(L){var i,j;for(i=0;i<L.length;i++){I=L[i];if(Array.isArray(R[i])){if(I.message){for(j=0;j<R[i].length;j++){J=R[i][j];v(J,I);J.response=I;}}else{K=I.__changeResponses;for(j=0;j<K.length;j++){var N=K[j];J=R[i][j];v(J,N);J.response=N;}}}else{J=R[i];v(J,I);J.response=I;}}t.checkUpdate(false,false,G);}t._processSuccess(k,H,s,G,n,u,true,R);t._setSessionContextIdHeader(t._getHeader("sap-contextid",H.headers));}function x(j){var F=j.message=="Request aborted";q.each(R,function(i,H){if(Array.isArray(H)){H.forEach(function(H){v(H,j,F);});}else{v(H,j,F);}});t._processAfterUpdate();if(F){t._processAborted(k,j,true);}else{t._processError(k,j,E,true,R);}}k.eventInfo={requests:R,batch:true};var y=this._submitRequest(k,w,x);function z(j){var E;for(var i=0;i<j.parts.length;i++){E=j.parts[i].fnError;if(!j.parts[i].request._aborted&&E){E(A);}}}var D={abort:function(){q.each(R,function(i,j){if(Array.isArray(j)){j.forEach(function(j){z(j);});}else{z(j);}});y.abort();}};return D;};
r.prototype._createBatchRequest=function(i){var u,R,j={},P={};P.__batchRequests=i;u=this.sServiceUrl+"/$batch";if(this.aUrlParams.length>0){u+="?"+this.aUrlParams.join("&");}q.extend(j,this.mCustomHeaders,this.oHeaders);j["Accept"]="multipart/mixed";delete j["Content-Type"];R={headers:j,requestUri:u,method:"POST",data:P,user:this.sUser,password:this.sPassword,async:true};R.withCredentials=this.bWithCredentials;return R;};
r.prototype.abortInternalRequest=function(k,G){var R=this.mRequests;if(G in this.mDeferredGroups){R=this.mDeferredRequests;}var j=R[G];if(j&&k in j.map){var n=j.map[k];for(var i=0;i<n.parts.length;i++){n.parts[i].requestHandle.abort();}}};
r.prototype._pushToRequestQueue=function(R,G,s,i,S,E,j,k){var n=R[G],t=i.key?i.key:i.method+":"+i.requestUri;if(!n){n={};n.map={};n.requests=[];R[G]=n;}if(t in n.map&&(i.key||i.method==='GET')){var u=n.map[t];var v=u.request;if(u.bRefreshAfterChange===undefined){u.bRefreshAfterChange=k;}if(!i.key){u.parts.push({request:i,fnSuccess:S,fnError:E,requestHandle:j});}if(i.method==="GET"){delete v.data;}else{v.method=i.method;v.headers=i.headers;v.data=i.data;v.requestUri=i.requestUri;if(i.method==="PUT"){delete v.headers["x-http-method"];}if(v._aborted){delete v._aborted;}}}else{var u={request:i,bRefreshAfterChange:k,parts:[{request:i,fnSuccess:S,fnError:E,requestHandle:j}]};if(i.method==="GET"){n.requests.push(u);}else{if(!n.changes){n.changes={};}var w=n.changes[s];if(!w){w=[];n.changes[s]=w;}u.changeSetId=s;w.push(u);}n.map[t]=u;}};
r.prototype._collectChangedEntities=function(G,j,E){var t=this;if(G.changes){q.each(G.changes,function(s,k){for(var i=0;i<k.length;i++){if(k[i].bRefreshAfterChange){var R=k[i].request,P="/"+R.requestUri.split("?")[0],n,K;if(R.method==="POST"||R.method==="DELETE"){var u=t.oMetadata._getEntityTypeByPath(P);if(u){E[u.entityType]=true;}}else{n=t._getObject(P);if(n){K=t._getKey(n);}else if(P.lastIndexOf("/")===0){K=t._getKey(P);}if(K){j[K]=true;}}}}});}};
r.prototype._processRequestQueue=function(R,G,s,E){var t=this,P,j=[];function k(n,W){for(var i=0;i<n.parts.length;i++){var u=n.parts[i];if(u.request._aborted){t._processAborted(n.request,null);n.parts.splice(i,1);i--;}else if(W){u.request._handle=W;W.iRelevantRequests++;}}}function w(){return{iRelevantRequests:0,oRequestHandle:{},abort:function(){this.iRelevantRequests--;if(this.iRelevantRequests===0&&this.oRequestHandle){this.oRequestHandle.abort();}}};}if(this.bUseBatch){q.each(R,function(i,n){if(i===G||!G){var u={},v={};t._collectChangedEntities(n,u,v);if(Object.keys(u).length||Object.keys(v).length){t.bIncludeInCurrentBatch=true;t._refresh(false,i,u,v);t.bIncludeInCurrentBatch=false;}}});q.each(R,function(n,u){if(n===G||!G){var v=[],x=[],y,z;var W=w();if(u.changes){q.each(u.changes,function(H,I){y={__changeRequests:[]};z=[];for(var i=0;i<I.length;i++){P='/'+t.getKey(I[i].request.data);t.increaseLaundering(P,I[i].request.data);k(I[i],W);if(I[i].parts.length>0){if(I[i].request.data&&I[i].request.data.__metadata){delete I[i].request.data.__metadata.created;}y.__changeRequests.push(I[i].request);z.push(I[i]);}}if(y.__changeRequests&&y.__changeRequests.length>0){v.push(y);x.push(z);}});}if(u.requests){var D=u.requests;for(var i=0;i<D.length;i++){k(D[i],W);if(D[i].parts.length>0){v.push(D[i].request);x.push(D[i]);}}}if(v.length>0){var F=t._createBatchRequest(v,true);W.oRequestHandle=t._submitBatchRequest(F,x,s,E);j.push(W.oRequestHandle);}delete R[n];}});}else{q.each(R,function(n,u){if(n===G||!G){if(u.changes){q.each(u.changes,function(x,y){for(var i=0;i<y.length;i++){var W=w();P='/'+t.getKey(y[i].request.data);t.increaseLaundering(P,y[i].request.data);k(y[i],W);if(y[i].parts.length>0){W.oRequestHandle=t._submitSingleRequest(y[i]);j.push(W.oRequestHandle);}}});}if(u.requests){var v=u.requests;for(var i=0;i<v.length;i++){var W=w();k(v[i],W);if(v[i].parts.length>0){W.oRequestHandle=t._submitSingleRequest(v[i]);j.push(W.oRequestHandle);}}}delete R[n];}});}this.checkDataState(this.mLaunderingState);return j.length==1?j[0]:j;};
r.prototype._processRequestQueueAsync=function(R){var t=this;if(!this.pCallAsnyc){this.pCallAsnyc=Promise.resolve();this.pCallAsnyc.then(function(){t._processRequestQueue(R);t.pCallAsnyc=undefined;});}};
r.prototype._processSuccess=function(R,i,s,G,j,E,k,n){var t=i.data,I,u,v,P,w,x,y,L={},z={},D=this;if(!k){u=!(i.statusCode===204||i.statusCode==='204');v=R.requestUri;P=v.replace(this.sServiceUrl,"");if(!q.sap.startsWith(P,'/')){P='/'+P;}P=this._normalizePath(P);this.decreaseLaundering(P,R.data);if(u&&t===undefined&&i){this._parseResponse(i,R);q.sap.log.fatal(this+" - No data was retrieved by service: '"+i.requestUri+"'");D.fireRequestCompleted({url:i.requestUri,type:"GET",async:i.async,info:"Accept headers:"+this.oHeaders["Accept"],infoObject:{acceptHeaders:this.oHeaders["Accept"]},success:false});return false;}if(t&&t.results&&!Array.isArray(t.results)){t=t.results;}if(!i._imported&&t&&(Array.isArray(t)||typeof t=='object')){I=q.sap.extend(true,{},t);D._importData(I,L,i);i._imported=true;}x=this._getEntity(R.key);if(L&&x&&x.__metadata.created&&x.__metadata.created.functionImport){var F=[];var H=x["$result"];if(H&&H.__list){q.each(L,function(K){F.push(K);});H.__list=F;}else if(H&&H.__ref){q.each(L,function(K){H.__ref=K;});}}if(!u){w=P.split("/");if(w[1]){z[w[1]]=R;var J={};J[w[1]]=R.data;this._updateChangedEntities(J);}if(R.method==="DELETE"&&w[2]!=="$links"){this._removeEntity(w[1]);}}if(u&&R.method==="POST"){y=this.oMetadata._getEntityTypeByPath(P);if(y){E[y.entityType]=true;}if(R.key){var K=this._getKey(t);var N=this.getContext("/"+R.key);N.sPath='/'+K;N.bCreated=false;this.mContexts[K]=N;this._removeEntity(R.key);x=this._getEntity(K);if(x){delete x.__metadata.created;}}}this._parseResponse(i,R,L,z);q.extend(G,L);q.extend(j,z);this._updateETag(R,i);}if(s){s(t,i);}var Q=this._createEventInfo(R,i,n);if(k){this.fireBatchRequestCompleted(Q);}else{this.fireRequestCompleted(Q);}return true;};
r.prototype._processError=function(R,i,E,j,k){var P,n=this._handleError(i,R);if(!j){P='/'+this.getKey(R.data);this.decreaseLaundering(P,R.data);}if(E){E(n);}var s=this._createEventInfo(R,n,k);if(j){this.fireBatchRequestCompleted(s);this.fireBatchRequestFailed(s);}else{this.fireRequestCompleted(s);this.fireRequestFailed(s);}};
var A={message:"Request aborted",statusCode:0,statusText:"abort",headers:{},responseText:""};
r.prototype._processAborted=function(R,i,j){var P;if(!j){P='/'+this.getKey(R.data);this.decreaseLaundering(P,R.data);}if(i){var E=this._createEventInfo(R,A);E.success=false;if(j){this.fireBatchRequestCompleted(E);}else{this.fireRequestCompleted(E);}}};
r.prototype._processAfterUpdate=function(){var j=this.aCallAfterUpdate;this.aCallAfterUpdate=[];for(var i=0;i<j.length;i++){j[i]();}};
r.prototype._processChange=function(k,D,u){var P,E,i,s,j,t,H,v,R,w,x=this;E=this.oMetadata._getEntityTypeByPath(k);if(!u){u="MERGE";}P=q.sap.extend(true,{},this._getObject('/'+k,true),D);if(D.__metadata&&D.__metadata.created){s=D.__metadata.created.method?D.__metadata.created.method:"POST";k=D.__metadata.created.key;i=D.__metadata.created;if(D.__metadata.created.functionImport){i.urlParameters=this._createFunctionImportParameters(D.__metadata.created.key,s,P);P=undefined;}}else if(u==="MERGE"){s="MERGE";w=this._getEntity(k);}else{s="PUT";}if(P&&P.__metadata){for(var n in P.__metadata){if(n!=='type'&&n!=='uri'&&n!=='etag'&&n!=='content_type'&&n!=='media_src'){delete P.__metadata[n];}}}if(P&&E){var N=this.oMetadata._getNavigationPropertyNames(E);N.forEach(function(F){delete P[F];});}if(s==="MERGE"&&E&&w){q.each(P,function(F,G){if(F!=='__metadata'){if(q.sap.equal(w[F],G)&&!x.isLaundering('/'+k+'/'+F)){delete P[F];}}});var y="/"+k,z;q.each(P,function(F,G){if(F!=='__metadata'){z=x.getProperty(y+"/"+F+"/#@sap:unit");if(z){if(P[z]===undefined){P[z]=w[z];}}}});}P=this._removeReferences(P);v=i&&i.urlParameters?a._createUrlParamsArray(i.urlParameters):undefined;H=i&&i.headers?this._getHeaders(i.headers):this._getHeaders();j=i&&i.eTag?i.eTag:this.getETag(P);t=this._createRequestUrl('/'+k,null,v,this.bUseBatch);R=this._createRequest(t,s,H,P,j);if(this.bUseBatch){R.requestUri=R.requestUri.replace(this.sServiceUrl+'/','');}return R;};
r.prototype._resolveGroup=function(k){var i,E,P,G,s,D;E=this.oMetadata._getEntityTypeByPath(k);D=this._getObject('/'+k);if(D){P=D.__metadata.created;if(P){return{groupId:P.groupId,changeSetId:P.changeSetId};}}if(this.mChangeGroups[E.name]){i=this.mChangeGroups[E.name];G=i.groupId;s=i.single?q.sap.uid():i.changeSetId;}else if(this.mChangeGroups['*']){i=this.mChangeGroups['*'];G=i.groupId;s=i.single?q.sap.uid():i.changeSetId;}return{groupId:G,changeSetId:s};};
r.prototype._updateETag=function(R,i){var u,E,s;u=R.requestUri.replace(this.sServiceUrl+'/','');if(!q.sap.startsWith(u,"/")){u="/"+u;}E=this._getObject(u.split("?")[0]);s=this._getHeader("etag",i.headers);if(E&&E.__metadata&&s){E.__metadata.etag=s;}};
r.prototype._handleError=function(E,R){var P={},t;var s="The following problem occurred: "+E.message;P.message=E.message;if(E.response){this._parseResponse(E.response,R);if(this.bTokenHandling){t=this._getHeader("x-csrf-token",E.response.headers);if(E.response.statusCode=='403'&&t&&t.toLowerCase()==="required"){this.resetSecurityToken();}}s+=E.response.statusCode+","+E.response.statusText+","+E.response.body;P.statusCode=E.response.statusCode;P.statusText=E.response.statusText;P.headers=E.response.headers;P.responseText=E.response.body;}q.sap.log.fatal(s);return P;};
r.prototype.getData=function(P,i,I){return this.getProperty(P,i,I);};
r.prototype._getODataHandler=function(u){if(u.indexOf("$batch")>-1){return p.batchHandler;}else if(u.indexOf("$count")>-1){return undefined;}else if(this.bJSON){return p.jsonHandler;}else{return p.atomHandler;}};
r.prototype.getETag=function(P,i,E){if(typeof P=="object"){E=P;P="";}return this._getETag(P,i,E);};
r.prototype._getETag=function(P,i,D){if(!D||!D.__metadata){D=this._getObject(P,i);}if(D&&D.__metadata){return D.__metadata.etag;}return null;};
r.prototype.forceEntityUpdate=function(k){var D=this.mChangedEntities[k];if(D&&D.__metadata){D.__metadata.etag='*';}else{q.sap.log.error(this+" - Entity with key "+k+" does not exist or has no change");}};
r.prototype._createRequest=function(u,s,H,D,E,i){i=i!==false;if(E&&s!=="GET"){H["If-Match"]=E;}if(!H["Content-Type"]&&s!=="DELETE"&&s!=="GET"){if(this.bJSON){H["Content-Type"]="application/json";}else{H["Content-Type"]="application/atom+xml";}}if(u.indexOf("$count")>-1){H["Accept"]="text/plain, */*;q=0.5";}if(s==="MERGE"&&!this.bUseBatch){H["x-http-method"]="MERGE";s="POST";}var R={headers:H,requestUri:u,method:s,user:this.sUser,password:this.sPassword,async:i};if(D){R.data=D;}if(this.bWithCredentials){R.withCredentials=this.bWithCredentials;}R.requestID=this._createRequestID();return R;};
r.prototype._processRequest=function(P,E){var R,i,j=false,t=this;R={abort:function(){if(!j&&E){E(A);}if(i){i._aborted=true;if(i._handle){i._handle.abort();}}j=true;}};this.oMetadata.loaded().then(function(){i=P(R);t._processRequestQueueAsync(t.mRequests);if(j){R.abort();}});return R;};
r.prototype.update=function(P,D,i){var s,E,R,u,j,k,n,G,t,v,H,w,x,y,z=this;if(i){G=i.groupId||i.batchGroupId;t=i.changeSetId;j=i.context;s=i.success;E=i.error;k=i.eTag;H=i.headers;v=i.urlParameters;y=i.refreshAfterChange;if(i.merge!==undefined){w=i.merge?"MERGE":"PUT";}}y=this._getRefreshAfterChange(y,G);n=a._createUrlParamsArray(v);H=this._getHeaders(H);w=w?w:this.sDefaultUpdateMethod;k=k||this._getETag(P,j,D);return this._processRequest(function(F){u=z._createRequestUrl(P,j,n,z.bUseBatch);R=z._createRequest(u,w,H,D,k);x=z.mRequests;if(G in z.mDeferredGroups){x=z.mDeferredRequests;}z._pushToRequestQueue(x,G,t,R,s,E,F,y);return R;},E);};
r.prototype.create=function(P,D,i){var R,u,E,j,s,k,n,t,H,v,w,G,x,y,z,F=this;if(i){j=i.context;n=i.urlParameters;s=i.success;k=i.error;G=i.groupId||i.batchGroupId;y=i.changeSetId;w=i.eTag;H=i.headers;z=i.refreshAfterChange;}z=this._getRefreshAfterChange(z,G);v=a._createUrlParamsArray(n);H=this._getHeaders(H);x="POST";return this._processRequest(function(I){u=F._createRequestUrl(P,j,v,F.bUseBatch);R=F._createRequest(u,x,H,D,w);P=F._normalizePath(P,j);E=F.oMetadata._getEntityTypeByPath(P);R.entityTypes={};if(E){R.entityTypes[E.entityType]=true;}t=F.mRequests;if(G in F.mDeferredGroups){t=F.mDeferredRequests;}F._pushToRequestQueue(t,G,y,R,s,k,I,z);return R;},k);};
r.prototype.remove=function(P,i){var j,k,s,E,R,u,G,n,t,v,w,H,x,y,z,D=this;if(i){G=i.groupId||i.batchGroupId;n=i.changeSetId;j=i.context;s=i.success;E=i.error;t=i.eTag;H=i.headers;w=i.urlParameters;v=i.refreshAfterChange;}v=this._getRefreshAfterChange(v,G);x=a._createUrlParamsArray(w);H=this._getHeaders(H);y="DELETE";t=t||this._getETag(P,j);function F(I,J){k=u.substr(u.lastIndexOf('/')+1);if(k.indexOf('?')!==-1){k=k.substr(0,k.indexOf('?'));}D._removeEntity(k);if(s){s(I,J);}}return this._processRequest(function(I){u=D._createRequestUrl(P,j,x,D.bUseBatch);R=D._createRequest(u,y,H,undefined,t);z=D.mRequests;if(G in D.mDeferredGroups){z=D.mDeferredRequests;}D._pushToRequestQueue(z,G,n,R,F,E,I,v);return R;},E);};
r.prototype.callFunction=function(F,P){var R,u,i,j,k,n,s,E,t="GET",G,v,H,w,x=this,K,y,z,D,I,J,L,N={};if(P){G=P.groupId||P.batchGroupId;v=P.changeSetId;t=P.method?P.method:t;k=q.extend({},P.urlParameters);w=P.eTag;s=P.success;E=P.error;H=P.headers;L=P.refreshAfterChange;}L=this._getRefreshAfterChange(L,G);if(!q.sap.startsWith(F,"/")){q.sap.log.fatal(this+" callFunction: path '"+F+"' must be absolute!");return;}H=this._getHeaders(H);I=new Promise(function(Q,S){z=Q;D=S;});J=this._processRequest(function(Q){i=x.oMetadata._getFunctionImportMetadata(F,t);if(!i){D();return;}var S=i.entitySet||i.entitySetPath;if(S){N.$result={__list:[]};if(i.returnType&&i.returnType.indexOf("Collection")==-1){N.$result={__ref:{}};}}if(i.parameter!=null){q.each(i.parameter,function(T,V){N[V.name]=x._createPropertyValue(V.type);if(k&&k[V.name]!==undefined){N[V.name]=k[V.name];k[V.name]=a.formatValue(k[V.name],V.type);}else{q.sap.log.warning(x+" - No value for parameter '"+V.name+"' found!'");}});}K=F.substring(1)+"('"+q.sap.uid()+"')";N.__metadata={uri:x.sServiceUrl+'/'+K,created:{key:F.substring(1),success:s,error:E,headers:H,method:t,groupId:G,changeSetId:v,eTag:w,functionImport:true}};x._addEntity(N);y=x.getContext("/"+K);z(y);n=a._createUrlParamsArray(k);u=x._createRequestUrl(F,null,n,x.bUseBatch);R=x._createRequest(u,t,H,undefined,w);R.key=K;j=x.mRequests;if(G in x.mDeferredGroups){j=x.mDeferredRequests;}x._pushToRequestQueue(j,G,v,R,s,E,Q,L);return R;},E);J.contextCreated=function(){return I;};return J;};
r.prototype._createFunctionImportParameters=function(F,s,P){var u=q.extend(true,{},P);delete u.__metadata;delete u["$result"];var i=this.oMetadata._getFunctionImportMetadata(F,s);if(!i){return;}if(i.parameter!=null){q.each(i.parameter,function(I,j){if(u&&u[j.name]!==undefined){u[j.name]=a.formatValue(u[j.name],j.type);}});}return u;};
r.prototype.read=function(P,i){var R,u,j,k,s,E,F,S,n,t,v,N,w,H,x,G,y,z,D=this;if(i){j=i.context;k=i.urlParameters;s=i.success;E=i.error;F=i.filters;S=i.sorters;G=i.groupId||i.batchGroupId;H=i.headers;}if(this.sRefreshGroupId){G=this.sRefreshGroupId;}w=a._createUrlParamsArray(k);H=this._getHeaders(H);x="GET";y=this._getETag(P,j);var I={abort:function(){if(R){R._aborted=true;}}};function J(K){t=a.createSortParams(S);if(t){w.push(t);}var T=P;var L=P.indexOf("$count");if(L!==-1){T=P.substring(0,L-1);}N=D._normalizePath(T,j);v=D.oMetadata._getEntityTypeByPath(N);n=a.createFilterParams(F,D.oMetadata,v);if(n){w.push(n);}u=D._createRequestUrl(P,j,w,D.bUseBatch);R=D._createRequest(u,x,H,null,y);z=D.mRequests;if(G in D.mDeferredGroups){z=D.mDeferredRequests;}D._pushToRequestQueue(z,G,null,R,s,E,K,false);return R;}if(this.bUseBatch&&this.bIncludeInCurrentBatch){R=J(I);return I;}else{return this._processRequest(J,E);}};
r.prototype.getServiceMetadata=function(){if(this.oMetadata&&this.oMetadata.isLoaded()){return this.oMetadata.getServiceMetadata();}};
r.prototype.metadataLoaded=function(){var i=this.oMetadata.loaded();if(this.bLoadAnnotationsJoined){var j=function(){return i;};return this.pAnnotationsLoaded.then(j,j);}else{return i;}};
r.prototype.annotationsLoaded=function(){return this.pAnnotationsLoaded;};
r.prototype.isMetadataLoadingFailed=function(){return this.oMetadata.isFailed();};
r.prototype.getServiceAnnotations=function(){var i=this.oAnnotations.getData();return q.isEmptyObject(i)?null:i;};
r.prototype.onAnnotationsFailed=function(E){this.fireAnnotationsFailed(E.getParameters());};
r.prototype.onAnnotationsLoaded=function(E){this.fireAnnotationsLoaded(E.getParameters());};
r.prototype.addAnnotationUrl=function(u){var i=[].concat(u),j=[],k=[],E=[],t=this;i.forEach(function(s){var I=s.indexOf("$metadata");if(I>=0){if(I==0){s=t.sServiceUrl+'/'+s;}j.push(s);}else{k.push(s);}});return this.oMetadata._addUrl(j).then(function(P){return Promise.all(q.map(P,function(n){E=E.concat(n.entitySets);return t.oAnnotations.addSource({type:"xml",data:n["metadataString"]});}));}).then(function(){return t.oAnnotations.addSource(k);}).then(function(P){return{annotations:t.oAnnotations.getData(),entitySets:E};});};
r.prototype.addAnnotationXML=function(x,s){return this.oAnnotations.addSource({type:"xml",data:x});};
r.prototype.submitChanges=function(P){var R,G,j,s,E,k,v,n=false,t,u,w=this.bRefreshAfterChange,x,y=this;if(P){G=P.groupId||P.batchGroupId;s=P.success;E=P.error;if(P.merge!==undefined){t=P.merge?"MERGE":"PUT";}}if(G&&!this.mDeferredGroups[G]){q.sap.log.fatal(this+" submitChanges: \""+G+"\" is not a deferred group!");}u=q.sap.extend(true,{},y.mChangedEntities);this.oMetadata.loaded().then(function(){q.each(u,function(K,J){j=y._resolveGroup(K);if(j.groupId===G||!G){R=y._processChange(K,J,t||y.sDefaultUpdateMethod);R.key=K;x=J.__metadata&&J.__metadata.created?J.__metadata.created:{};var k={abort:function(){R._aborted=true;}};if(j.groupId in y.mDeferredGroups){y._pushToRequestQueue(y.mDeferredRequests,j.groupId,j.changeSetId,R,x.success,x.error,k,w);}}});var z,D,F,H,I,i;for(z in y.mDeferredRequests){F=y.mDeferredRequests[z];for(D in F.changes){H=F.changes[D];for(i=H.length-1;i>=0;i--){I=H[i];if(I.bRefreshAfterChange===undefined){I.bRefreshAfterChange=w;}}}}v=y._processRequestQueue(y.mDeferredRequests,G,s,E);if(n){k.abort();}});k={abort:function(){if(v){if(Array.isArray(v)){v.forEach(function(k){k.abort();});}else{v.abort();}}else{if(!n&&E){E(A);}n=true;}}};return k;};
r.prototype._updateChangedEntities=function(i){var t=this,R;function u(j,k){q.each(k,function(K){var s=R+'/'+K;if(q.isPlainObject(k[K])&&q.isPlainObject(j[K])){u(j[K],k[K]);if(q.isEmptyObject(k[K])){delete k[K];}}else if(q.sap.equal(k[K],j[K])&&!t.isLaundering(s)){delete k[K];}});}q.each(i,function(k,D){if(k in t.mChangedEntities){var E=t._getObject('/'+k,null,true);var j=t._getObject('/'+k);q.sap.extend(true,E,D);R='/'+k;u(E,j);if(q.isEmptyObject(j)){delete t.mChangedEntities[k];t.abortInternalRequest(k,t._resolveGroup(k).groupId);}else{t.mChangedEntities[k]=j;j.__metadata={};q.extend(j.__metadata,E.__metadata);}}});};
r.prototype.resetChanges=function(P){var t=this,j,E={},k,n;if(P){q.each(P,function(I,s){t.getEntityByPath(s,null,E);j=E.propertyPath.split("/");var K=E.key;k=t.mChangedEntities[K];for(var i=0;i<j.length-1;i++){if(k.hasOwnProperty(j[i])){k=k[j[i]];}else{k=undefined;}}if(k){delete k[j[j.length-1]];}if(t.mChangedEntities[K]){n=t.mChangedEntities[K].__metadata;delete t.mChangedEntities[K].__metadata;if(q.isEmptyObject(t.mChangedEntities[K])||!E.propertyPath){t.oMetadata.loaded().then(function(){t.abortInternalRequest(K,t._resolveGroup(K).groupId);});delete t.mChangedEntities[K];}else{t.mChangedEntities[K].__metadata=n;}}else{q.sap.log.warning(t+" - resetChanges: "+s+" is not changed");}});}else{q.each(this.mChangedEntities,function(K,i){t.oMetadata.loaded().then(function(){t.abortInternalRequest(K,t._resolveGroup(K).groupId);});delete t.mChangedEntities[K];});}this.checkUpdate(true);};
r.prototype.setProperty=function(P,v,j,k){var n,s,R,t,u,E,w,x,K,G,y,z,D={},F={},H,I,J,L=false,N=this,Q;function S(T,V){q.each(V,function(K){if(q.isPlainObject(V[K])&&q.isPlainObject(T[K])){S(T[K],V[K]);if(q.isEmptyObject(V[K])){delete V[K];}}else if(q.sap.equal(V[K],T[K])){delete V[K];}});}w=this.resolve(P,j,true);E=this.getEntityByPath(w,null,F);if(!E){return false;}s=w.substring(w.lastIndexOf("/")+1);K=F.key;u=this._getObject('/'+K,null,true);n=this._getObject(P,j,true);if(!this.mChangedEntities[K]){z=E.__metadata;E={};E.__metadata=q.extend({},z);this.mChangedEntities[K]=E;}I=this.mChangedEntities[K];x=F.propertyPath.split("/");for(var i=0;i<x.length-1;i++){if(!I.hasOwnProperty(x[i])){I[x[i]]={};}I=I[x[i]];}L=u.__metadata.created&&u.__metadata.created.functionImport;I[s]=v;if(q.sap.equal(v,n)&&!this.isLaundering('/'+K)&&!L){z=this.mChangedEntities[K].__metadata;Q=z&&z.created;delete this.mChangedEntities[K].__metadata;if(!Q){S(u,this.mChangedEntities[K]);}if(q.isEmptyObject(this.mChangedEntities[K])){delete this.mChangedEntities[K];D[K]=true;this.checkUpdate(false,k,D);N.oMetadata.loaded().then(function(){N.abortInternalRequest(K,N._resolveGroup(K).groupId);});return true;}this.mChangedEntities[K].__metadata=z;}G=this._resolveGroup(K);R=this.mRequests;if(G.groupId in this.mDeferredGroups){R=this.mDeferredRequests;t=this._processChange(K,{__metadata:E.__metadata});}else{t=this._processChange(K,this._getObject('/'+K));}t.key=K;H=I.__metadata&&I.__metadata.created?I.__metadata.created:{};J=this._getRefreshAfterChange(undefined,G.groupId);this.oMetadata.loaded().then(function(){y={abort:function(){t._aborted=true;}};N._pushToRequestQueue(R,G.groupId,G.changeSetId,t,H.success,H.error,y,J);N._processRequestQueueAsync(N.mRequests);});D[K]=true;this.checkUpdate(false,k,D);return true;};
r.prototype._isHeaderPrivate=function(H){switch(H.toLowerCase()){case"accept":case"accept-language":case"maxdataserviceversion":case"dataserviceversion":return true;case"x-csrf-token":return this.bTokenHandling;case"sap-contextid-accept":case"sap-contextid":return!this.bDisableSoftStateHeader;default:return false;}return false;};
r.prototype.setHeaders=function(H){var i={},t=this;this.mCustomHeaders={};if(H){q.each(H,function(s,j){if(t._isHeaderPrivate(s)){q.sap.log.warning(this+" - modifying private header: '"+s+"' not allowed!");}else{i[s]=j;}});this.mCustomHeaders=i;}if(this.oAnnotations){this.oAnnotations.setHeaders(this.mCustomHeaders);}};
r.prototype._getHeaders=function(H){var i={},t=this;if(H){q.each(H,function(s,j){if(t._isHeaderPrivate(s)){q.sap.log.warning(this+" - modifying private header: '"+s+"' not allowed!");}else{i[s]=j;}});}return q.extend({},this.mCustomHeaders,i,this.oHeaders);};
r.prototype.getHeaders=function(){return q.extend({},this.mCustomHeaders,this.oHeaders);};
r.prototype._getHeader=function(H,i){var s;for(s in i){if(s.toLowerCase()===H.toLowerCase()){return i[s];}}return null;};
r.prototype.hasPendingChanges=function(){return!q.isEmptyObject(this.mChangedEntities);};
r.prototype.hasPendingRequests=function(){return this.aPendingRequestHandles.length>0;};
r.prototype.getPendingChanges=function(){return q.sap.extend(true,{},this.mChangedEntities);};
r.prototype.updateBindings=function(F){this.checkUpdate(F);};
r.prototype.setTokenHandlingEnabled=function(t){this.bTokenHandling=t;};
r.prototype.setUseBatch=function(u){this.bUseBatch=u;};
r.prototype.formatValue=function(v,t){return a.formatValue(v,t);};
r.prototype.deleteCreatedEntry=function(i){var t=this,k,G;if(i){var k=i.getPath().substr(1);G=this._resolveGroup(k).groupId;t.oMetadata.loaded().then(function(){t.abortInternalRequest(k,G);});t._removeEntity(k);sap.ui.getCore().getMessageManager().removeMessages(this.getMessagesByPath(i.getPath()+'/'));}};
r.prototype.createEntry=function(P,j){var s,E,R,u,k,n,K,t,G,v,w,x,H,y,z,D={},F,I="POST",J=this;if(j){z=j.properties;G=j.groupId||j.batchGroupId;v=j.changeSetId;n=j.context;s=j.success;E=j.error;F=j.created;k=j.eTag;H=j.headers;x=j.urlParameters;w=j.refreshAfterChange;}w=this._getRefreshAfterChange(w,G);G=G?G:this.sDefaultChangeGroup;t=a._createUrlParamsArray(x);H=this._getHeaders(H);var L={abort:function(){if(R){R._aborted=true;}}};function N(){var Q;if(!q.sap.startsWith(P,"/")){P="/"+P;}var S=J.oMetadata._getEntityTypeByPath(P);if(!S){return undefined;}if(typeof z==="object"&&!Array.isArray(z)){D=z;}else{for(var i=0;i<S.property.length;i++){var T=S.property[i];var V=q.inArray(T.name,z)>-1;if(!z||V){D[T.name]=J._createPropertyValue(T.type);if(V){z.splice(z.indexOf(T.name),1);}}}if(z){}}var W=J.oMetadata._getEntitySetByType(S);K=W.name+"('"+q.sap.uid()+"')";D.__metadata={type:""+S.entityType,uri:J.sServiceUrl+'/'+K,created:{key:P.substring(1),success:s,error:E,headers:H,urlParameters:x,groupId:G,changeSetId:v,eTag:k}};J._addEntity(q.sap.extend(true,{},D));J.mChangedEntities[K]=D;u=J._createRequestUrl(P,n,t,J.bUseBatch);R=J._createRequest(u,I,H,D,k);Q=J.getContext("/"+K);Q.bCreated=true;R.key=K;R.created=true;y=J.mRequests;if(G in J.mDeferredGroups){y=J.mDeferredRequests;}J.oMetadata.loaded().then(function(){J._pushToRequestQueue(y,G,v,R,s,E,L,w);J._processRequestQueueAsync(J.mRequests);});return Q;}if(F){this.oMetadata.loaded().then(function(){F(N());});}else if(this.oMetadata.isLoaded()){return N();}else{q.sap.log.error("Tried to use createEntry without created-callback, before metadata is available!");}};
r.prototype._isCreatedEntity=function(E){return!!(E&&E.__metadata&&E.__metadata.created);};
r.prototype._createPropertyValue=function(t){var T=this.oMetadata._splitName(t);var n=T[1];var s=T[0];if(n.toUpperCase()!=='EDM'){var j={};var k=this.oMetadata._getObjectMetadata("complexType",s,n);for(var i=0;i<k.property.length;i++){var P=k.pro